// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('cljs.cache');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbfunctions.fns');
goog.require('clojure.string');
/**
 * Returns an empty TTL cache for db-function caching.
 *   Implication of this caching strategy is changes to db functions that get
 *   update will take 5 seconds to recompile, benefit is that the same function
 *   call for a ledger will not have to recompile every time.
 */
fluree.db.dbfunctions.core.db_fn_cache_factory = (function fluree$db$dbfunctions$core$db_fn_cache_factory(){
return cljs.cache.ttl_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ttl","ttl",-1115275118),(5000)], 0));
});
fluree.db.dbfunctions.core.db_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.dbfunctions.core.db_fn_cache_factory());
fluree.db.dbfunctions.core.clear_db_fn_cache = (function fluree$db$dbfunctions$core$clear_db_fn_cache(){
return cljs.core.reset_BANG_(fluree.db.dbfunctions.core.db_fn_cache,fluree.db.dbfunctions.core.db_fn_cache_factory());
});
/**
 * Returns true if this value is a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(value){
var and__4251__auto__ = typeof value === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,value);
} else {
return and__4251__auto__;
}
});
fluree.db.dbfunctions.core.default_fn_map = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),new cljs.core.Symbol(null,"and","and",668631710,null),new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),new cljs.core.Symbol(null,"cas","cas",1188988307,null),new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),new cljs.core.Symbol(null,">",">",1085014381,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"objT","objT",1212205659,null),new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"/","/",-1371932971,null),new cljs.core.Symbol(null,"quot","quot",-1125214196,null),new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),new cljs.core.Symbol(null,"not","not",1044554643,null),new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.Symbol(null,"==","==",-234118149,null),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.Symbol(null,"*","*",345799209,null),new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"now","now",-9994004,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null),new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"get","get",-971253014,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"<","<",993667236,null),new cljs.core.Symbol(null,"-","-",-471816912,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),new cljs.core.Symbol(null,"?p","?p",-10896580,null),new cljs.core.Symbol(null,"nth","nth",1529209554,null),new cljs.core.Symbol(null,"subs","subs",1453849536,null),new cljs.core.Symbol(null,"mod","mod",1510044207,null),new cljs.core.Symbol(null,"?s","?s",456183954,null),new cljs.core.Symbol(null,"rem","rem",664046770,null),new cljs.core.Symbol(null,"query","query",352022017,null),new cljs.core.Symbol(null,"?o","?o",-1814741084,null),new cljs.core.Symbol(null,"objF","objF",-104129083,null),new cljs.core.Symbol(null,"follow","follow",831213865,null),new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null)],[(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pO !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pO;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pO","fluree.db.dbfunctions.fns/?pO",-2142759792,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,302,null,302,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_auth_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_auth_id;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?auth_id","fluree.db.dbfunctions.fns/?auth_id",-1900200218,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,715,null,715,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.and !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.and;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","and","fluree.db.dbfunctions.fns/and",2113043921,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"and","and",668631710,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,232,null,232,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.upper_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.upper_case;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","upper-case","fluree.db.dbfunctions.fns/upper-case",-210929244,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,159,null,159,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.cas !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.cas;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","cas","fluree.db.dbfunctions.fns/cas",-1666886306,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"cas","cas",1188988307,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,813,null,813,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max_pred_val !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max_pred_val;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","max-pred-val","fluree.db.dbfunctions.fns/max-pred-val",884898813,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,522,null,522,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT__EQ_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns",">=","fluree.db.dbfunctions.fns/>=",-1771718525,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,">=",">=",1016916022,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,428,null,428,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.lower_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.lower_case;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","lower-case","fluree.db.dbfunctions.fns/lower-case",-442259,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,147,null,147,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns",">","fluree.db.dbfunctions.fns/>",-23637352,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,">",">",1085014381,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,389,null,389,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.count !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.count;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","count","fluree.db.dbfunctions.fns/count",1267596361,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"count","count",-514511684,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,258,null,258,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nil_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nil_QMARK_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","nil?","fluree.db.dbfunctions.fns/nil?",-1144188177,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,88,null,88,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objT !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objT;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","objT","fluree.db.dbfunctions.fns/objT",308919174,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"objT","objT",1212205659,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,727,null,727,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.inc !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.inc;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","inc","fluree.db.dbfunctions.fns/inc",1299152788,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"inc","inc",324505433,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,534,null,534,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._SLASH_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","/","fluree.db.dbfunctions.fns//",1439768862,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"/","/",-1371932971,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,608,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.quot !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.quot;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","quot","fluree.db.dbfunctions.fns/quot",1725032899,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"quot","quot",-1125214196,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,621,null,621,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.flakes !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.flakes;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","flakes","fluree.db.dbfunctions.fns/flakes",2105901429,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,751,null,751,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","not","fluree.db.dbfunctions.fns/not",-1684442274,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"not","not",1044554643,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,100,null,100,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_sid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_sid;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?sid","fluree.db.dbfunctions.fns/?sid",-1145594406,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,171,null,171,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.uuid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.uuid;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","uuid","fluree.db.dbfunctions.fns/uuid",1199900311,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,779,null,779,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_user_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_user_id;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?user_id","fluree.db.dbfunctions.fns/?user_id",599092011,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,697,null,697,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT__EQ_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","<=","fluree.db.dbfunctions.fns/<=",-535009166,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"<=","<=",1244895369,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,415,null,415,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"==","==",-234118149,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,376,null,376,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.min !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.min;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","min","fluree.db.dbfunctions.fns/min",-1032470830,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"min","min",2085523049,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,467,null,467,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.ceil !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.ceil;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","ceil","fluree.db.dbfunctions.fns/ceil",-1898210568,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,789,null,789,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.if_else !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.if_else;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","if-else","fluree.db.dbfunctions.fns/if-else",-1024242186,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,75,null,75,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pid;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pid","fluree.db.dbfunctions.fns/?pid",-1962601142,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,190,null,190,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._PLUS_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._PLUS_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","+","fluree.db.dbfunctions.fns/+",1979608855,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"+","+",-740910886,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,569,null,569,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"==","==",-234118149,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,376,null,376,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.boolean$ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.boolean$;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","boolean","fluree.db.dbfunctions.fns/boolean",831125140,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,660,null,660,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","max","fluree.db.dbfunctions.fns/max",-821447668,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"max","max",1701898075,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,454,null,454,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.empty_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.empty_QMARK_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","empty?","fluree.db.dbfunctions.fns/empty?",-487925850,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"empty?","empty?",76408555,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,111,null,111,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._STAR_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._STAR_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","*","fluree.db.dbfunctions.fns/*",1333037714,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"*","*",345799209,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,595,null,595,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.relationship_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.relationship_QMARK_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","relationship?","fluree.db.dbfunctions.fns/relationship?",-46706197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,1,507,null,507,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_in !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_in;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-in","fluree.db.dbfunctions.fns/get-in",821000586,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,334,null,334,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Returns the value of a nested structure",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null),"Length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.now !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.now;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","now","fluree.db.dbfunctions.fns/now",1494134809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"now","now",-9994004,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,559,null,559,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.dec !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.dec;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","dec","fluree.db.dbfunctions.fns/dec",2016365502,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,546,null,546,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.floor !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.floor;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","floor","fluree.db.dbfunctions.fns/floor",2077352177,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,801,null,801,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not_EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not_EQ_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","not=","fluree.db.dbfunctions.fns/not=",-1186054057,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"not=","not=",1466536204,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,441,null,441,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","get","fluree.db.dbfunctions.fns/get",1827842903,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get","get",-971253014,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,272,null,272,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.str !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.str;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","str","fluree.db.dbfunctions.fns/str",215086055,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,123,null,123,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","<","fluree.db.dbfunctions.fns/<",-518653073,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"<","<",993667236,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,402,null,402,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","-","fluree.db.dbfunctions.fns/-",-1982229401,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"-","-",-471816912,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,582,null,582,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rand !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rand;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","rand","fluree.db.dbfunctions.fns/rand",805823682,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,763,null,763,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.contains_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.contains_QMARK_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","contains?","fluree.db.dbfunctions.fns/contains?",979635755,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,1,348,null,348,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),"Returns true if key is present.",(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.hash_set !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.hash_set;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","hash-set","fluree.db.dbfunctions.fns/hash-set",-1047040869,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,362,null,362,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns a hash-set of values",(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null),"9 + count of items in hash-set"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.valid_email_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.valid_email_QMARK_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","valid-email?","fluree.db.dbfunctions.fns/valid-email?",110711142,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,685,null,685,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_p !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_p;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?p","fluree.db.dbfunctions.fns/?p",1090611913,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?p","?p",-10896580,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,216,null,216,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nth !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nth;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","nth","fluree.db.dbfunctions.fns/nth",-246664273,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"nth","nth",1529209554,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,60,null,60,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.subs !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.subs;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","subs","fluree.db.dbfunctions.fns/subs",815704759,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"subs","subs",1453849536,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,135,null,135,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.mod !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.mod;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","mod","fluree.db.dbfunctions.fns/mod",-198597254,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"mod","mod",1510044207,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,634,null,634,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_s !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_s;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?s","fluree.db.dbfunctions.fns/?s",-1324621735,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?s","?s",456183954,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,203,null,203,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rem !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rem;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","rem","fluree.db.dbfunctions.fns/rem",1237147007,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"rem","rem",664046770,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,647,null,647,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.query !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.query;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","query","fluree.db.dbfunctions.fns/query",2131906892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"query","query",352022017,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,480,null,480,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_o !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_o;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?o","fluree.db.dbfunctions.fns/?o",2112743665,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?o","?o",-1814741084,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,1,290,null,290,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objF !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objF;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","objF","fluree.db.dbfunctions.fns/objF",1608830606,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"objF","objF",-104129083,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,739,null,739,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.or !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.or;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","or","fluree.db.dbfunctions.fns/or",-919667013,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"or","or",1876275696,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,245,null,245,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.re_find !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.re_find;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","re-find","fluree.db.dbfunctions.fns/re-find",-1361091826,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,672,null,672,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))):null)]);
fluree.db.dbfunctions.core.resolve_local_fn = (function fluree$db$dbfunctions$core$resolve_local_fn(f){
var map__56908 = cljs.core.meta(f);
var map__56908__$1 = cljs.core.__destructure_map(map__56908);
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56908__$1,new cljs.core.Keyword("fdb","spec","fdb/spec",346638389));
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56908__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
var arglist = cljs.core.first(arglists);
var _AMPERSAND_args_QMARK_ = (function (){var and__4251__auto__ = (function (){var G__56910 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("&");
var fexpr__56909 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__56909.cljs$core$IFn$_invoke$arity$1 ? fexpr__56909.cljs$core$IFn$_invoke$arity$1(G__56910) : fexpr__56909.call(null,G__56910));
})();
if(cljs.core.truth_(and__4251__auto__)){
var G__56912 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("args");
var fexpr__56911 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__56911.cljs$core$IFn$_invoke$arity$1 ? fexpr__56911.cljs$core$IFn$_invoke$arity$1(G__56912) : fexpr__56911.call(null,G__56912));
} else {
return and__4251__auto__;
}
})();
var arity = ((cljs.core.not(_AMPERSAND_args_QMARK_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__56907_SHARP_){
return (cljs.core.count(p1__56907_SHARP_) - (1));
}),arglists)):null);
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"f","f",-1597136552),f,new cljs.core.Keyword(null,"params","params",710516235),arglists,new cljs.core.Keyword(null,"arity","arity",-1808556135),arity,new cljs.core.Keyword(null,"&args?","&args?",-1736256945),_AMPERSAND_args_QMARK_,new cljs.core.Keyword(null,"spec","spec",347520401),spec,new cljs.core.Keyword(null,"code","code",1586293142),null], null);
});
fluree.db.dbfunctions.core.build_fn = (function fluree$db$dbfunctions$core$build_fn(var$,fun){
return cljs.core.eval(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,var$,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,fun,null,(1),null))], 0)))));
});
fluree.db.dbfunctions.core.find_fn_STAR_ = (function fluree$db$dbfunctions$core$find_fn_STAR_(db,fn_name,funType){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56997){
var state_val_56998 = (state_56997[(1)]);
if((state_val_56998 === (7))){
var inst_56922 = cljs.core.deref(fluree.db.dbfunctions.core.db_fn_cache);
var inst_56923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56924 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(db);
var inst_56925 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_56926 = [fn_name,inst_56924,inst_56925];
var inst_56927 = (new cljs.core.PersistentVector(null,3,(5),inst_56923,inst_56926,null));
var inst_56928 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_56922,inst_56927);
var state_56997__$1 = state_56997;
var statearr_56999_57036 = state_56997__$1;
(statearr_56999_57036[(2)] = inst_56928);

(statearr_56999_57036[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (1))){
var state_56997__$1 = state_56997;
var statearr_57000_57037 = state_56997__$1;
(statearr_57000_57037[(2)] = null);

(statearr_57000_57037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (4))){
var inst_56913 = (state_56997[(2)]);
var state_56997__$1 = state_56997;
var statearr_57001_57038 = state_56997__$1;
(statearr_57001_57038[(2)] = inst_56913);

(statearr_57001_57038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (15))){
var inst_56946 = (state_56997[(7)]);
var inst_56960 = (state_56997[(8)]);
var inst_56958 = (state_56997[(2)]);
var inst_56959 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_56946,"_fn/params");
var inst_56960__$1 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_56959);
var inst_56961 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_56946,"_fn/code");
var inst_56962 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_56961);
var inst_56963 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_56962,funType,inst_56960__$1) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_56962,funType,inst_56960__$1));
var state_56997__$1 = (function (){var statearr_57002 = state_56997;
(statearr_57002[(9)] = inst_56958);

(statearr_57002[(8)] = inst_56960__$1);

return statearr_57002;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56997__$1,(16),inst_56963);
} else {
if((state_val_56998 === (13))){
var inst_56949 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fn_name], 0));
var inst_56950 = ["Unknown function: ",inst_56949].join('');
var inst_56951 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_56952 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_56953 = cljs.core.PersistentHashMap.fromArrays(inst_56951,inst_56952);
var inst_56954 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_56950,inst_56953);
var inst_56955 = (function(){throw inst_56954})();
var state_56997__$1 = state_56997;
var statearr_57003_57039 = state_56997__$1;
(statearr_57003_57039[(2)] = inst_56955);

(statearr_57003_57039[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (6))){
var state_56997__$1 = state_56997;
var statearr_57004_57040 = state_56997__$1;
(statearr_57004_57040[(2)] = null);

(statearr_57004_57040[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (17))){
var state_56997__$1 = state_56997;
var statearr_57005_57041 = state_56997__$1;
(statearr_57005_57041[(2)] = null);

(statearr_57005_57041[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (3))){
var inst_56995 = (state_56997[(2)]);
var state_56997__$1 = state_56997;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56997__$1,inst_56995);
} else {
if((state_val_56998 === (12))){
var inst_56946 = (state_56997[(7)]);
var inst_56945 = (state_56997[(2)]);
var inst_56946__$1 = fluree.db.util.async.throw_err(inst_56945);
var inst_56947 = cljs.core.empty_QMARK_(inst_56946__$1);
var state_56997__$1 = (function (){var statearr_57006 = state_56997;
(statearr_57006[(7)] = inst_56946__$1);

return statearr_57006;
})();
if(inst_56947){
var statearr_57007_57042 = state_56997__$1;
(statearr_57007_57042[(1)] = (13));

} else {
var statearr_57008_57043 = state_56997__$1;
(statearr_57008_57043[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (2))){
var inst_56919 = (state_56997[(10)]);
var _ = (function (){var statearr_57009 = state_56997;
(statearr_57009[(4)] = cljs.core.cons((5),(state_56997[(4)])));

return statearr_57009;
})();
var inst_56919__$1 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var state_56997__$1 = (function (){var statearr_57010 = state_56997;
(statearr_57010[(10)] = inst_56919__$1);

return statearr_57010;
})();
if(cljs.core.truth_(inst_56919__$1)){
var statearr_57011_57044 = state_56997__$1;
(statearr_57011_57044[(1)] = (6));

} else {
var statearr_57012_57045 = state_56997__$1;
(statearr_57012_57045[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (19))){
var inst_56980 = (state_56997[(11)]);
var inst_56990 = (state_56997[(2)]);
var state_56997__$1 = (function (){var statearr_57013 = state_56997;
(statearr_57013[(12)] = inst_56990);

return statearr_57013;
})();
var statearr_57014_57046 = state_56997__$1;
(statearr_57014_57046[(2)] = inst_56980);

(statearr_57014_57046[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (11))){
var inst_56992 = (state_56997[(2)]);
var _ = (function (){var statearr_57016 = state_56997;
(statearr_57016[(4)] = cljs.core.rest((state_56997[(4)])));

return statearr_57016;
})();
var state_56997__$1 = state_56997;
var statearr_57017_57047 = state_56997__$1;
(statearr_57017_57047[(2)] = inst_56992);

(statearr_57017_57047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (9))){
var inst_56930 = (state_56997[(13)]);
var state_56997__$1 = state_56997;
var statearr_57018_57048 = state_56997__$1;
(statearr_57018_57048[(2)] = inst_56930);

(statearr_57018_57048[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (5))){
var _ = (function (){var statearr_57019 = state_56997;
(statearr_57019[(4)] = cljs.core.rest((state_56997[(4)])));

return statearr_57019;
})();
var state_56997__$1 = state_56997;
var ex57015 = (state_56997__$1[(2)]);
var statearr_57020_57049 = state_56997__$1;
(statearr_57020_57049[(5)] = ex57015);


if((ex57015 instanceof Error)){
var statearr_57021_57050 = state_56997__$1;
(statearr_57021_57050[(1)] = (4));

(statearr_57021_57050[(5)] = null);

} else {
throw ex57015;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (14))){
var state_56997__$1 = state_56997;
var statearr_57022_57051 = state_56997__$1;
(statearr_57022_57051[(2)] = null);

(statearr_57022_57051[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (16))){
var inst_56946 = (state_56997[(7)]);
var inst_56958 = (state_56997[(9)]);
var inst_56930 = (state_56997[(13)]);
var inst_56942 = (state_56997[(14)]);
var inst_56960 = (state_56997[(8)]);
var inst_56919 = (state_56997[(10)]);
var inst_56965 = (state_56997[(2)]);
var inst_56966 = fluree.db.util.async.throw_err(inst_56965);
var inst_56967 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_56946,"_fn/spec");
var inst_56968 = cljs.core.PersistentVector.EMPTY;
var inst_56969 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_56970 = (function (){var forward_time_travel_db_QMARK_ = inst_56919;
var or__4253__auto__ = inst_56930;
var query = inst_56942;
var res = inst_56946;
var _ = inst_56958;
var params = inst_56960;
var code = inst_56966;
var spec = inst_56967;
return (function (x){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(x);
});
})();
var inst_56971 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_56970,inst_56960);
var inst_56972 = cljs.core.cons(inst_56969,inst_56971);
var inst_56973 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_56968,inst_56972);
var inst_56974 = fluree.db.dbfunctions.core.build_fn(inst_56973,inst_56966);
var inst_56975 = [new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"arity","arity",-1808556135),new cljs.core.Keyword(null,"&args?","&args?",-1736256945),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"code","code",1586293142)];
var inst_56976 = cljs.core.count(inst_56960);
var inst_56977 = [inst_56976];
var inst_56978 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_56977);
var inst_56979 = [inst_56974,inst_56960,inst_56978,false,inst_56967,null];
var inst_56980 = cljs.core.PersistentHashMap.fromArrays(inst_56975,inst_56979);
var state_56997__$1 = (function (){var statearr_57023 = state_56997;
(statearr_57023[(11)] = inst_56980);

return statearr_57023;
})();
if(cljs.core.truth_(inst_56919)){
var statearr_57024_57052 = state_56997__$1;
(statearr_57024_57052[(1)] = (17));

} else {
var statearr_57025_57053 = state_56997__$1;
(statearr_57025_57053[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (10))){
var inst_56942 = (state_56997[(14)]);
var inst_56933 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_56934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56935 = ["_fn/params","_fn/code","_fn/spec"];
var inst_56936 = (new cljs.core.PersistentVector(null,3,(5),inst_56934,inst_56935,null));
var inst_56937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56938 = cljs.core.name(fn_name);
var inst_56939 = ["_fn/name",inst_56938];
var inst_56940 = (new cljs.core.PersistentVector(null,2,(5),inst_56937,inst_56939,null));
var inst_56941 = [inst_56936,inst_56940];
var inst_56942__$1 = cljs.core.PersistentHashMap.fromArrays(inst_56933,inst_56941);
var inst_56943 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_56942__$1);
var state_56997__$1 = (function (){var statearr_57026 = state_56997;
(statearr_57026[(14)] = inst_56942__$1);

return statearr_57026;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56997__$1,(12),inst_56943);
} else {
if((state_val_56998 === (18))){
var inst_56980 = (state_56997[(11)]);
var inst_56983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56984 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(db);
var inst_56985 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_56986 = [fn_name,inst_56984,inst_56985];
var inst_56987 = (new cljs.core.PersistentVector(null,3,(5),inst_56983,inst_56986,null));
var inst_56988 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.dbfunctions.core.db_fn_cache,cljs.core.assoc,inst_56987,inst_56980);
var state_56997__$1 = state_56997;
var statearr_57027_57054 = state_56997__$1;
(statearr_57027_57054[(2)] = inst_56988);

(statearr_57027_57054[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (8))){
var inst_56930 = (state_56997[(13)]);
var inst_56930__$1 = (state_56997[(2)]);
var state_56997__$1 = (function (){var statearr_57028 = state_56997;
(statearr_57028[(13)] = inst_56930__$1);

return statearr_57028;
})();
if(cljs.core.truth_(inst_56930__$1)){
var statearr_57029_57055 = state_56997__$1;
(statearr_57029_57055[(1)] = (9));

} else {
var statearr_57030_57056 = state_56997__$1;
(statearr_57030_57056[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2741__auto____0 = (function (){
var statearr_57031 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57031[(0)] = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2741__auto__);

(statearr_57031[(1)] = (1));

return statearr_57031;
});
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2741__auto____1 = (function (state_56997){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_56997);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e57032){var ex__2744__auto__ = e57032;
var statearr_57033_57057 = state_56997;
(statearr_57033_57057[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_56997[(4)]))){
var statearr_57034_57058 = state_56997;
(statearr_57034_57058[(1)] = cljs.core.first((state_56997[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57059 = state_56997;
state_56997 = G__57059;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2741__auto__ = function(state_56997){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2741__auto____1.call(this,state_56997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2741__auto____0;
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_57035 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_57035[(6)] = c__2763__auto__);

return statearr_57035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.dbfunctions.core.find_fn = (function fluree$db$dbfunctions$core$find_fn(var_args){
var G__57061 = arguments.length;
switch (G__57061) {
case 2:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,funType){
if(("nodejs" === cljs.core._STAR_target_STAR_)){
return fluree.db.dbfunctions.core.find_fn_STAR_(db,fn_name,funType);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("DB functions not yet supported in javascript!",cljs.core.PersistentArrayMap.EMPTY);

}
}));

(fluree.db.dbfunctions.core.find_fn.cljs$lang$maxFixedArity = 3);

/**
 * Given a collection of function strings, returns a combined function using the and function
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
fluree.db.dbfunctions.core.symbol_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),null,new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),null,new cljs.core.Symbol(null,"sid","sid",-839419355,null),null,new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),null,new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),null,new cljs.core.Symbol(null,"?a","?a",1314302913,null),null,new cljs.core.Symbol(null,"?db","?db",1493359450,null),null,new cljs.core.Symbol(null,"?s","?s",456183954,null),null,new cljs.core.Symbol(null,"?o","?o",-1814741084,null),null], null), null);
/**
 * Ensures contents of vector are allowed
 */
fluree.db.dbfunctions.core.parse_vector = (function fluree$db$dbfunctions$core$parse_vector(var_args){
var G__57065 = arguments.length;
switch (G__57065) {
case 2:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2 = (function (db,vec){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,null,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3 = (function (db,vec,funType){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,funType,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4 = (function (db,vec,funType,params){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_57195){
var state_val_57196 = (state_57195[(1)]);
if((state_val_57196 === (7))){
var inst_57190 = (state_57195[(2)]);
var _ = (function (){var statearr_57197 = state_57195;
(statearr_57197[(4)] = cljs.core.rest((state_57195[(4)])));

return statearr_57197;
})();
var state_57195__$1 = state_57195;
var statearr_57198_57278 = state_57195__$1;
(statearr_57198_57278[(2)] = inst_57190);

(statearr_57198_57278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (20))){
var inst_57104 = (state_57195[(7)]);
var state_57195__$1 = state_57195;
var statearr_57199_57279 = state_57195__$1;
(statearr_57199_57279[(2)] = inst_57104);

(statearr_57199_57279[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (27))){
var inst_57091 = (state_57195[(8)]);
var inst_57117 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_57118 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57091)," used in function.",inst_57117].join('');
var inst_57119 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_57120 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_57121 = cljs.core.PersistentHashMap.fromArrays(inst_57119,inst_57120);
var inst_57122 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_57118,inst_57121);
var inst_57123 = (function(){throw inst_57122})();
var state_57195__$1 = state_57195;
var statearr_57200_57280 = state_57195__$1;
(statearr_57200_57280[(2)] = inst_57123);

(statearr_57200_57280[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (1))){
var state_57195__$1 = state_57195;
var statearr_57201_57281 = state_57195__$1;
(statearr_57201_57281[(2)] = null);

(statearr_57201_57281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (24))){
var inst_57114 = (state_57195[(9)]);
var inst_57114__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(funType,"functionDec");
var state_57195__$1 = (function (){var statearr_57202 = state_57195;
(statearr_57202[(9)] = inst_57114__$1);

return statearr_57202;
})();
if(inst_57114__$1){
var statearr_57203_57282 = state_57195__$1;
(statearr_57203_57282[(1)] = (26));

} else {
var statearr_57204_57283 = state_57195__$1;
(statearr_57204_57283[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (39))){
var inst_57091 = (state_57195[(8)]);
var inst_57151 = (inst_57091 == null);
var state_57195__$1 = state_57195;
if(cljs.core.truth_(inst_57151)){
var statearr_57205_57284 = state_57195__$1;
(statearr_57205_57284[(1)] = (42));

} else {
var statearr_57206_57285 = state_57195__$1;
(statearr_57206_57285[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (46))){
var state_57195__$1 = state_57195;
var statearr_57207_57286 = state_57195__$1;
(statearr_57207_57286[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (4))){
var inst_57066 = (state_57195[(2)]);
var state_57195__$1 = state_57195;
var statearr_57209_57287 = state_57195__$1;
(statearr_57209_57287[(2)] = inst_57066);

(statearr_57209_57287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (15))){
var inst_57091 = (state_57195[(8)]);
var inst_57102 = (inst_57091 instanceof cljs.core.Symbol);
var state_57195__$1 = state_57195;
if(cljs.core.truth_(inst_57102)){
var statearr_57210_57288 = state_57195__$1;
(statearr_57210_57288[(1)] = (17));

} else {
var statearr_57211_57289 = state_57195__$1;
(statearr_57211_57289[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (48))){
var inst_57158 = (state_57195[(2)]);
var inst_57159 = fluree.db.util.async.throw_err(inst_57158);
var state_57195__$1 = state_57195;
var statearr_57212_57290 = state_57195__$1;
(statearr_57212_57290[(2)] = inst_57159);

(statearr_57212_57290[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (50))){
var state_57195__$1 = state_57195;
var statearr_57213_57291 = state_57195__$1;
(statearr_57213_57291[(2)] = null);

(statearr_57213_57291[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (21))){
var inst_57081 = (state_57195[(10)]);
var inst_57111 = (state_57195[(11)]);
var inst_57085 = (state_57195[(12)]);
var inst_57084 = (state_57195[(13)]);
var inst_57091 = (state_57195[(8)]);
var inst_57092 = (state_57195[(14)]);
var inst_57082 = (state_57195[(15)]);
var inst_57104 = (state_57195[(7)]);
var inst_57079 = (state_57195[(16)]);
var inst_57107 = [inst_57091];
var inst_57108 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_57107);
var inst_57109 = (function (){var x = inst_57091;
var seq__57088 = inst_57092;
var vec__57076 = inst_57079;
var r = inst_57092;
var G__57075 = inst_57084;
var acc = inst_57085;
var seq__57077 = inst_57082;
var first__57089 = inst_57091;
var vec__57087 = inst_57084;
var first__57078 = inst_57081;
var or__4253__auto__ = inst_57104;
return (function (p1__57063_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__57063_SHARP_);
});
})();
var inst_57110 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_57109,params);
var inst_57111__$1 = cljs.core.some(inst_57108,inst_57110);
var state_57195__$1 = (function (){var statearr_57214 = state_57195;
(statearr_57214[(11)] = inst_57111__$1);

return statearr_57214;
})();
if(cljs.core.truth_(inst_57111__$1)){
var statearr_57215_57292 = state_57195__$1;
(statearr_57215_57292[(1)] = (23));

} else {
var statearr_57216_57293 = state_57195__$1;
(statearr_57216_57293[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (31))){
var inst_57141 = (state_57195[(2)]);
var state_57195__$1 = state_57195;
if(cljs.core.truth_(inst_57141)){
var statearr_57217_57294 = state_57195__$1;
(statearr_57217_57294[(1)] = (35));

} else {
var statearr_57218_57295 = state_57195__$1;
(statearr_57218_57295[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (32))){
var inst_57134 = (state_57195[(17)]);
var state_57195__$1 = state_57195;
var statearr_57219_57296 = state_57195__$1;
(statearr_57219_57296[(2)] = inst_57134);

(statearr_57219_57296[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (40))){
var inst_57176 = (state_57195[(2)]);
var state_57195__$1 = state_57195;
var statearr_57220_57297 = state_57195__$1;
(statearr_57220_57297[(2)] = inst_57176);

(statearr_57220_57297[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (33))){
var inst_57091 = (state_57195[(8)]);
var inst_57137 = (inst_57091 == null);
var state_57195__$1 = state_57195;
var statearr_57221_57298 = state_57195__$1;
(statearr_57221_57298[(2)] = inst_57137);

(statearr_57221_57298[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (13))){
var inst_57085 = (state_57195[(12)]);
var inst_57092 = (state_57195[(14)]);
var inst_57184 = (state_57195[(2)]);
var inst_57185 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_57085,inst_57184);
var inst_57084 = inst_57092;
var inst_57085__$1 = inst_57185;
var state_57195__$1 = (function (){var statearr_57222 = state_57195;
(statearr_57222[(12)] = inst_57085__$1);

(statearr_57222[(13)] = inst_57084);

return statearr_57222;
})();
var statearr_57223_57299 = state_57195__$1;
(statearr_57223_57299[(2)] = null);

(statearr_57223_57299[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (22))){
var inst_57129 = (state_57195[(2)]);
var state_57195__$1 = state_57195;
var statearr_57224_57300 = state_57195__$1;
(statearr_57224_57300[(2)] = inst_57129);

(statearr_57224_57300[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (36))){
var inst_57091 = (state_57195[(8)]);
var inst_57144 = cljs.core.vector_QMARK_(inst_57091);
var state_57195__$1 = state_57195;
if(inst_57144){
var statearr_57225_57301 = state_57195__$1;
(statearr_57225_57301[(1)] = (38));

} else {
var statearr_57226_57302 = state_57195__$1;
(statearr_57226_57302[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (41))){
var inst_57148 = (state_57195[(2)]);
var inst_57149 = fluree.db.util.async.throw_err(inst_57148);
var state_57195__$1 = state_57195;
var statearr_57227_57303 = state_57195__$1;
(statearr_57227_57303[(2)] = inst_57149);

(statearr_57227_57303[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (43))){
var inst_57091 = (state_57195[(8)]);
var inst_57154 = cljs.core.list_QMARK_(inst_57091);
var state_57195__$1 = state_57195;
if(inst_57154){
var statearr_57228_57304 = state_57195__$1;
(statearr_57228_57304[(1)] = (45));

} else {
var statearr_57229_57305 = state_57195__$1;
(statearr_57229_57305[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (29))){
var inst_57131 = (state_57195[(18)]);
var state_57195__$1 = state_57195;
var statearr_57230_57306 = state_57195__$1;
(statearr_57230_57306[(2)] = inst_57131);

(statearr_57230_57306[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (44))){
var inst_57174 = (state_57195[(2)]);
var state_57195__$1 = state_57195;
var statearr_57231_57307 = state_57195__$1;
(statearr_57231_57307[(2)] = inst_57174);

(statearr_57231_57307[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (6))){
var inst_57084 = (state_57195[(13)]);
var inst_57091 = (state_57195[(8)]);
var inst_57090 = cljs.core.seq(inst_57084);
var inst_57091__$1 = cljs.core.first(inst_57090);
var inst_57092 = cljs.core.next(inst_57090);
var inst_57093 = (inst_57091__$1 == null);
var state_57195__$1 = (function (){var statearr_57232 = state_57195;
(statearr_57232[(8)] = inst_57091__$1);

(statearr_57232[(14)] = inst_57092);

return statearr_57232;
})();
if(cljs.core.truth_(inst_57093)){
var statearr_57233_57308 = state_57195__$1;
(statearr_57233_57308[(1)] = (8));

} else {
var statearr_57234_57309 = state_57195__$1;
(statearr_57234_57309[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (28))){
var inst_57125 = (state_57195[(2)]);
var state_57195__$1 = state_57195;
var statearr_57235_57310 = state_57195__$1;
(statearr_57235_57310[(2)] = inst_57125);

(statearr_57235_57310[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (51))){
var inst_57170 = (state_57195[(2)]);
var state_57195__$1 = state_57195;
var statearr_57236_57311 = state_57195__$1;
(statearr_57236_57311[(2)] = inst_57170);

(statearr_57236_57311[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (25))){
var inst_57127 = (state_57195[(2)]);
var state_57195__$1 = state_57195;
var statearr_57237_57312 = state_57195__$1;
(statearr_57237_57312[(2)] = inst_57127);

(statearr_57237_57312[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (34))){
var inst_57139 = (state_57195[(2)]);
var state_57195__$1 = state_57195;
var statearr_57238_57313 = state_57195__$1;
(statearr_57238_57313[(2)] = inst_57139);

(statearr_57238_57313[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (17))){
var inst_57091 = (state_57195[(8)]);
var inst_57104 = (state_57195[(7)]);
var inst_57104__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_57091) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_57091));
var state_57195__$1 = (function (){var statearr_57239 = state_57195;
(statearr_57239[(7)] = inst_57104__$1);

return statearr_57239;
})();
if(cljs.core.truth_(inst_57104__$1)){
var statearr_57240_57314 = state_57195__$1;
(statearr_57240_57314[(1)] = (20));

} else {
var statearr_57241_57315 = state_57195__$1;
(statearr_57241_57315[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (3))){
var inst_57193 = (state_57195[(2)]);
var state_57195__$1 = state_57195;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57195__$1,inst_57193);
} else {
if((state_val_57196 === (12))){
var inst_57091 = (state_57195[(8)]);
var inst_57099 = typeof inst_57091 === 'number';
var state_57195__$1 = state_57195;
if(cljs.core.truth_(inst_57099)){
var statearr_57242_57316 = state_57195__$1;
(statearr_57242_57316[(1)] = (14));

} else {
var statearr_57243_57317 = state_57195__$1;
(statearr_57243_57317[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (2))){
var inst_57079 = (state_57195[(16)]);
var _ = (function (){var statearr_57244 = state_57195;
(statearr_57244[(4)] = cljs.core.cons((5),(state_57195[(4)])));

return statearr_57244;
})();
var inst_57079__$1 = vec;
var inst_57080 = cljs.core.seq(inst_57079__$1);
var inst_57081 = cljs.core.first(inst_57080);
var inst_57082 = cljs.core.next(inst_57080);
var inst_57083 = cljs.core.PersistentVector.EMPTY;
var inst_57084 = inst_57079__$1;
var inst_57085 = inst_57083;
var state_57195__$1 = (function (){var statearr_57245 = state_57195;
(statearr_57245[(10)] = inst_57081);

(statearr_57245[(12)] = inst_57085);

(statearr_57245[(13)] = inst_57084);

(statearr_57245[(15)] = inst_57082);

(statearr_57245[(16)] = inst_57079__$1);

return statearr_57245;
})();
var statearr_57246_57318 = state_57195__$1;
(statearr_57246_57318[(2)] = null);

(statearr_57246_57318[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (23))){
var inst_57111 = (state_57195[(11)]);
var state_57195__$1 = state_57195;
var statearr_57247_57319 = state_57195__$1;
(statearr_57247_57319[(2)] = inst_57111);

(statearr_57247_57319[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (47))){
var inst_57172 = (state_57195[(2)]);
var state_57195__$1 = state_57195;
var statearr_57248_57320 = state_57195__$1;
(statearr_57248_57320[(2)] = inst_57172);

(statearr_57248_57320[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (35))){
var inst_57091 = (state_57195[(8)]);
var state_57195__$1 = state_57195;
var statearr_57249_57321 = state_57195__$1;
(statearr_57249_57321[(2)] = inst_57091);

(statearr_57249_57321[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (19))){
var inst_57180 = (state_57195[(2)]);
var state_57195__$1 = state_57195;
var statearr_57250_57322 = state_57195__$1;
(statearr_57250_57322[(2)] = inst_57180);

(statearr_57250_57322[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (11))){
var inst_57091 = (state_57195[(8)]);
var state_57195__$1 = state_57195;
var statearr_57252_57323 = state_57195__$1;
(statearr_57252_57323[(2)] = inst_57091);

(statearr_57252_57323[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (9))){
var inst_57091 = (state_57195[(8)]);
var inst_57096 = typeof inst_57091 === 'string';
var state_57195__$1 = state_57195;
if(cljs.core.truth_(inst_57096)){
var statearr_57253_57324 = state_57195__$1;
(statearr_57253_57324[(1)] = (11));

} else {
var statearr_57254_57325 = state_57195__$1;
(statearr_57254_57325[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (5))){
var _ = (function (){var statearr_57255 = state_57195;
(statearr_57255[(4)] = cljs.core.rest((state_57195[(4)])));

return statearr_57255;
})();
var state_57195__$1 = state_57195;
var ex57251 = (state_57195__$1[(2)]);
var statearr_57256_57326 = state_57195__$1;
(statearr_57256_57326[(5)] = ex57251);


if((ex57251 instanceof Error)){
var statearr_57257_57327 = state_57195__$1;
(statearr_57257_57327[(1)] = (4));

(statearr_57257_57327[(5)] = null);

} else {
throw ex57251;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (14))){
var inst_57091 = (state_57195[(8)]);
var state_57195__$1 = state_57195;
var statearr_57258_57328 = state_57195__$1;
(statearr_57258_57328[(2)] = inst_57091);

(statearr_57258_57328[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (45))){
var inst_57091 = (state_57195[(8)]);
var inst_57156 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_57091,funType,params) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_57091,funType,params));
var state_57195__$1 = state_57195;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57195__$1,(48),inst_57156);
} else {
if((state_val_57196 === (26))){
var inst_57114 = (state_57195[(9)]);
var state_57195__$1 = state_57195;
var statearr_57259_57329 = state_57195__$1;
(statearr_57259_57329[(2)] = inst_57114);

(statearr_57259_57329[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (16))){
var inst_57182 = (state_57195[(2)]);
var state_57195__$1 = state_57195;
var statearr_57260_57330 = state_57195__$1;
(statearr_57260_57330[(2)] = inst_57182);

(statearr_57260_57330[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (38))){
var inst_57091 = (state_57195[(8)]);
var inst_57146 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_57091,funType,params);
var state_57195__$1 = state_57195;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57195__$1,(41),inst_57146);
} else {
if((state_val_57196 === (30))){
var inst_57134 = (state_57195[(17)]);
var inst_57091 = (state_57195[(8)]);
var inst_57134__$1 = inst_57091 === false;
var state_57195__$1 = (function (){var statearr_57261 = state_57195;
(statearr_57261[(17)] = inst_57134__$1);

return statearr_57261;
})();
if(cljs.core.truth_(inst_57134__$1)){
var statearr_57262_57331 = state_57195__$1;
(statearr_57262_57331[(1)] = (32));

} else {
var statearr_57263_57332 = state_57195__$1;
(statearr_57263_57332[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (10))){
var inst_57188 = (state_57195[(2)]);
var state_57195__$1 = state_57195;
var statearr_57264_57333 = state_57195__$1;
(statearr_57264_57333[(2)] = inst_57188);

(statearr_57264_57333[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (18))){
var inst_57131 = (state_57195[(18)]);
var inst_57091 = (state_57195[(8)]);
var inst_57131__$1 = inst_57091 === true;
var state_57195__$1 = (function (){var statearr_57265 = state_57195;
(statearr_57265[(18)] = inst_57131__$1);

return statearr_57265;
})();
if(cljs.core.truth_(inst_57131__$1)){
var statearr_57266_57334 = state_57195__$1;
(statearr_57266_57334[(1)] = (29));

} else {
var statearr_57267_57335 = state_57195__$1;
(statearr_57267_57335[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (42))){
var inst_57091 = (state_57195[(8)]);
var state_57195__$1 = state_57195;
var statearr_57268_57336 = state_57195__$1;
(statearr_57268_57336[(2)] = inst_57091);

(statearr_57268_57336[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (37))){
var inst_57178 = (state_57195[(2)]);
var state_57195__$1 = state_57195;
var statearr_57269_57337 = state_57195__$1;
(statearr_57269_57337[(2)] = inst_57178);

(statearr_57269_57337[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (8))){
var inst_57085 = (state_57195[(12)]);
var state_57195__$1 = state_57195;
var statearr_57270_57338 = state_57195__$1;
(statearr_57270_57338[(2)] = inst_57085);

(statearr_57270_57338[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (49))){
var inst_57091 = (state_57195[(8)]);
var inst_57162 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_57091], 0));
var inst_57163 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_57164 = ["Illegal element (",inst_57162,") in vector: ",inst_57163,"."].join('');
var inst_57165 = cljs.core.PersistentHashMap.EMPTY;
var inst_57166 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_57164,inst_57165);
var inst_57167 = (function(){throw inst_57166})();
var state_57195__$1 = state_57195;
var statearr_57271_57339 = state_57195__$1;
(statearr_57271_57339[(2)] = inst_57167);

(statearr_57271_57339[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2741__auto____0 = (function (){
var statearr_57272 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57272[(0)] = fluree$db$dbfunctions$core$state_machine__2741__auto__);

(statearr_57272[(1)] = (1));

return statearr_57272;
});
var fluree$db$dbfunctions$core$state_machine__2741__auto____1 = (function (state_57195){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_57195);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e57273){var ex__2744__auto__ = e57273;
var statearr_57274_57340 = state_57195;
(statearr_57274_57340[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_57195[(4)]))){
var statearr_57275_57341 = state_57195;
(statearr_57275_57341[(1)] = cljs.core.first((state_57195[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57342 = state_57195;
state_57195 = G__57342;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2741__auto__ = function(state_57195){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2741__auto____1.call(this,state_57195);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2741__auto____0;
fluree$db$dbfunctions$core$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2741__auto____1;
return fluree$db$dbfunctions$core$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_57276 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_57276[(6)] = c__2763__auto__);

return statearr_57276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$lang$maxFixedArity = 4);

/**
 * Looks up function in local-function map. If exists returns map of function details,
 *   if doesn't exist returns nil.
 */
fluree.db.dbfunctions.core.find_local_fn_STAR_ = (function fluree$db$dbfunctions$core$find_local_fn_STAR_(fn_name){
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.core.default_fn_map,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(fn_name));
if(cljs.core.truth_(temp__5753__auto__)){
var local_fn = temp__5753__auto__;
return fluree.db.dbfunctions.core.resolve_local_fn(local_fn);
} else {
return null;
}
});
fluree.db.dbfunctions.core.find_local_fn = cljs.core.memoize(fluree.db.dbfunctions.core.find_local_fn_STAR_);
/**
 * Resolves a full code form expression.
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(var_args){
var G__57345 = arguments.length;
switch (G__57345) {
case 2:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_57509){
var state_val_57510 = (state_57509[(1)]);
if((state_val_57510 === (7))){
var inst_57353 = (state_57509[(7)]);
var inst_57359 = fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,inst_57353,type);
var state_57509__$1 = state_57509;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57509__$1,(9),inst_57359);
} else {
if((state_val_57510 === (59))){
var inst_57402 = (state_57509[(8)]);
var inst_57473 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_57402], 0));
var inst_57474 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_57402) : type.call(null,inst_57402));
var inst_57475 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_57476 = ["Illegal element (",inst_57473,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57474),") in function argument: ",inst_57475,"."].join('');
var inst_57477 = cljs.core.PersistentHashMap.EMPTY;
var inst_57478 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_57476,inst_57477);
var inst_57479 = (function(){throw inst_57478})();
var state_57509__$1 = state_57509;
var statearr_57511_57606 = state_57509__$1;
(statearr_57511_57606[(2)] = inst_57479);

(statearr_57511_57606[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (20))){
var inst_57408 = (state_57509[(2)]);
var state_57509__$1 = state_57509;
if(cljs.core.truth_(inst_57408)){
var statearr_57512_57607 = state_57509__$1;
(statearr_57512_57607[(1)] = (21));

} else {
var statearr_57513_57608 = state_57509__$1;
(statearr_57513_57608[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (58))){
var inst_57469 = (state_57509[(2)]);
var inst_57470 = fluree.db.util.async.throw_err(inst_57469);
var state_57509__$1 = state_57509;
var statearr_57514_57609 = state_57509__$1;
(statearr_57514_57609[(2)] = inst_57470);

(statearr_57514_57609[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (60))){
var state_57509__$1 = state_57509;
var statearr_57515_57610 = state_57509__$1;
(statearr_57515_57610[(2)] = null);

(statearr_57515_57610[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (27))){
var inst_57414 = (state_57509[(2)]);
var inst_57415 = fluree.db.util.async.throw_err(inst_57414);
var state_57509__$1 = state_57509;
var statearr_57516_57611 = state_57509__$1;
(statearr_57516_57611[(2)] = inst_57415);

(statearr_57516_57611[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (1))){
var state_57509__$1 = state_57509;
var statearr_57517_57612 = state_57509__$1;
(statearr_57517_57612[(2)] = null);

(statearr_57517_57612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (24))){
var inst_57402 = (state_57509[(8)]);
var inst_57412 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_57402,type,params);
var state_57509__$1 = state_57509;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57509__$1,(27),inst_57412);
} else {
if((state_val_57510 === (55))){
var inst_57402 = (state_57509[(8)]);
var inst_57467 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_57402,type,params);
var state_57509__$1 = state_57509;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57509__$1,(58),inst_57467);
} else {
if((state_val_57510 === (39))){
var inst_57450 = (state_57509[(2)]);
var state_57509__$1 = state_57509;
var statearr_57518_57613 = state_57509__$1;
(statearr_57518_57613[(2)] = inst_57450);

(statearr_57518_57613[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (46))){
var inst_57452 = (state_57509[(9)]);
var state_57509__$1 = state_57509;
var statearr_57519_57614 = state_57509__$1;
(statearr_57519_57614[(2)] = inst_57452);

(statearr_57519_57614[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (4))){
var inst_57346 = (state_57509[(2)]);
var state_57509__$1 = state_57509;
var statearr_57520_57615 = state_57509__$1;
(statearr_57520_57615[(2)] = inst_57346);

(statearr_57520_57615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (54))){
var inst_57486 = (state_57509[(2)]);
var state_57509__$1 = state_57509;
var statearr_57521_57616 = state_57509__$1;
(statearr_57521_57616[(2)] = inst_57486);

(statearr_57521_57616[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (15))){
var inst_57354 = (state_57509[(10)]);
var inst_57383 = (state_57509[(2)]);
var inst_57391 = cljs.core.seq(inst_57354);
var inst_57392 = cljs.core.first(inst_57391);
var inst_57393 = cljs.core.next(inst_57391);
var inst_57394 = cljs.core.PersistentVector.EMPTY;
var inst_57395 = inst_57354;
var inst_57396 = inst_57394;
var state_57509__$1 = (function (){var statearr_57522 = state_57509;
(statearr_57522[(11)] = inst_57383);

(statearr_57522[(12)] = inst_57392);

(statearr_57522[(13)] = inst_57396);

(statearr_57522[(14)] = inst_57395);

(statearr_57522[(15)] = inst_57393);

return statearr_57522;
})();
var statearr_57523_57617 = state_57509__$1;
(statearr_57523_57617[(2)] = null);

(statearr_57523_57617[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (48))){
var inst_57462 = (state_57509[(2)]);
var state_57509__$1 = state_57509;
if(cljs.core.truth_(inst_57462)){
var statearr_57524_57618 = state_57509__$1;
(statearr_57524_57618[(1)] = (52));

} else {
var statearr_57525_57619 = state_57509__$1;
(statearr_57525_57619[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (50))){
var inst_57402 = (state_57509[(8)]);
var inst_57458 = (inst_57402 == null);
var state_57509__$1 = state_57509;
var statearr_57526_57620 = state_57509__$1;
(statearr_57526_57620[(2)] = inst_57458);

(statearr_57526_57620[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (21))){
var inst_57402 = (state_57509[(8)]);
var inst_57410 = cljs.core.list_QMARK_(inst_57402);
var state_57509__$1 = state_57509;
if(inst_57410){
var statearr_57527_57621 = state_57509__$1;
(statearr_57527_57621[(1)] = (24));

} else {
var statearr_57528_57622 = state_57509__$1;
(statearr_57528_57622[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (31))){
var inst_57402 = (state_57509[(8)]);
var state_57509__$1 = state_57509;
var statearr_57529_57623 = state_57509__$1;
(statearr_57529_57623[(2)] = inst_57402);

(statearr_57529_57623[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (32))){
var inst_57402 = (state_57509[(8)]);
var inst_57423 = (inst_57402 instanceof cljs.core.Symbol);
var state_57509__$1 = state_57509;
if(cljs.core.truth_(inst_57423)){
var statearr_57530_57624 = state_57509__$1;
(statearr_57530_57624[(1)] = (34));

} else {
var statearr_57531_57625 = state_57509__$1;
(statearr_57531_57625[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (40))){
var inst_57432 = (state_57509[(16)]);
var state_57509__$1 = state_57509;
var statearr_57532_57626 = state_57509__$1;
(statearr_57532_57626[(2)] = inst_57432);

(statearr_57532_57626[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (56))){
var state_57509__$1 = state_57509;
var statearr_57533_57627 = state_57509__$1;
(statearr_57533_57627[(1)] = (59));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (33))){
var inst_57490 = (state_57509[(2)]);
var state_57509__$1 = state_57509;
var statearr_57535_57628 = state_57509__$1;
(statearr_57535_57628[(2)] = inst_57490);

(statearr_57535_57628[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (13))){
var inst_57367 = (state_57509[(17)]);
var inst_57353 = (state_57509[(7)]);
var inst_57355 = (state_57509[(18)]);
var inst_57377 = ["Incorrect arity for function ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57353),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57367),", provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57355),"."].join('');
var inst_57378 = cljs.core.PersistentHashMap.EMPTY;
var inst_57379 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_57377,inst_57378);
var inst_57380 = (function(){throw inst_57379})();
var state_57509__$1 = state_57509;
var statearr_57536_57629 = state_57509__$1;
(statearr_57536_57629[(2)] = inst_57380);

(statearr_57536_57629[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (22))){
var inst_57396 = (state_57509[(13)]);
var state_57509__$1 = state_57509;
var statearr_57537_57630 = state_57509__$1;
(statearr_57537_57630[(2)] = inst_57396);

(statearr_57537_57630[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (36))){
var inst_57488 = (state_57509[(2)]);
var state_57509__$1 = state_57509;
var statearr_57538_57631 = state_57509__$1;
(statearr_57538_57631[(2)] = inst_57488);

(statearr_57538_57631[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (41))){
var inst_57435 = (state_57509[(19)]);
var inst_57435__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_57509__$1 = (function (){var statearr_57539 = state_57509;
(statearr_57539[(19)] = inst_57435__$1);

return statearr_57539;
})();
if(inst_57435__$1){
var statearr_57540_57632 = state_57509__$1;
(statearr_57540_57632[(1)] = (43));

} else {
var statearr_57541_57633 = state_57509__$1;
(statearr_57541_57633[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (43))){
var inst_57435 = (state_57509[(19)]);
var state_57509__$1 = state_57509;
var statearr_57542_57634 = state_57509__$1;
(statearr_57542_57634[(2)] = inst_57435);

(statearr_57542_57634[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (61))){
var inst_57482 = (state_57509[(2)]);
var state_57509__$1 = state_57509;
var statearr_57543_57635 = state_57509__$1;
(statearr_57543_57635[(2)] = inst_57482);

(statearr_57543_57635[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (29))){
var inst_57402 = (state_57509[(8)]);
var inst_57420 = typeof inst_57402 === 'number';
var state_57509__$1 = state_57509;
if(cljs.core.truth_(inst_57420)){
var statearr_57544_57636 = state_57509__$1;
(statearr_57544_57636[(1)] = (31));

} else {
var statearr_57545_57637 = state_57509__$1;
(statearr_57545_57637[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (44))){
var inst_57402 = (state_57509[(8)]);
var inst_57438 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_57439 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57402)," used in function argument: ",inst_57438].join('');
var inst_57440 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_57441 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_57442 = cljs.core.PersistentHashMap.fromArrays(inst_57440,inst_57441);
var inst_57443 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_57439,inst_57442);
var inst_57444 = (function(){throw inst_57443})();
var state_57509__$1 = state_57509;
var statearr_57546_57638 = state_57509__$1;
(statearr_57546_57638[(2)] = inst_57444);

(statearr_57546_57638[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (6))){
var inst_57356 = (state_57509[(20)]);
var state_57509__$1 = state_57509;
var statearr_57547_57639 = state_57509__$1;
(statearr_57547_57639[(2)] = inst_57356);

(statearr_57547_57639[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (28))){
var inst_57402 = (state_57509[(8)]);
var state_57509__$1 = state_57509;
var statearr_57548_57640 = state_57509__$1;
(statearr_57548_57640[(2)] = inst_57402);

(statearr_57548_57640[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (51))){
var inst_57460 = (state_57509[(2)]);
var state_57509__$1 = state_57509;
var statearr_57549_57641 = state_57509__$1;
(statearr_57549_57641[(2)] = inst_57460);

(statearr_57549_57641[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (25))){
var inst_57402 = (state_57509[(8)]);
var inst_57417 = typeof inst_57402 === 'string';
var state_57509__$1 = state_57509;
if(cljs.core.truth_(inst_57417)){
var statearr_57550_57642 = state_57509__$1;
(statearr_57550_57642[(1)] = (28));

} else {
var statearr_57551_57643 = state_57509__$1;
(statearr_57551_57643[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (34))){
var inst_57402 = (state_57509[(8)]);
var inst_57425 = (state_57509[(21)]);
var inst_57425__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_57402) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_57402));
var state_57509__$1 = (function (){var statearr_57552 = state_57509;
(statearr_57552[(21)] = inst_57425__$1);

return statearr_57552;
})();
if(cljs.core.truth_(inst_57425__$1)){
var statearr_57553_57644 = state_57509__$1;
(statearr_57553_57644[(1)] = (37));

} else {
var statearr_57554_57645 = state_57509__$1;
(statearr_57554_57645[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (17))){
var inst_57366 = (state_57509[(22)]);
var inst_57501 = (state_57509[(2)]);
var inst_57502 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_57503 = cljs.core.cons(inst_57502,inst_57501);
var inst_57504 = cljs.core.cons(inst_57366,inst_57503);
var _ = (function (){var statearr_57555 = state_57509;
(statearr_57555[(4)] = cljs.core.rest((state_57509[(4)])));

return statearr_57555;
})();
var state_57509__$1 = state_57509;
var statearr_57556_57646 = state_57509__$1;
(statearr_57556_57646[(2)] = inst_57504);

(statearr_57556_57646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (3))){
var inst_57507 = (state_57509[(2)]);
var state_57509__$1 = state_57509;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57509__$1,inst_57507);
} else {
if((state_val_57510 === (12))){
var inst_57374 = (state_57509[(2)]);
var inst_57375 = cljs.core.not(inst_57374);
var state_57509__$1 = state_57509;
if(inst_57375){
var statearr_57557_57647 = state_57509__$1;
(statearr_57557_57647[(1)] = (13));

} else {
var statearr_57558_57648 = state_57509__$1;
(statearr_57558_57648[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (2))){
var inst_57356 = (state_57509[(20)]);
var inst_57354 = (state_57509[(10)]);
var inst_57353 = (state_57509[(7)]);
var _ = (function (){var statearr_57559 = state_57509;
(statearr_57559[(4)] = cljs.core.cons((5),(state_57509[(4)])));

return statearr_57559;
})();
var inst_57353__$1 = cljs.core.first(form);
var inst_57354__$1 = cljs.core.rest(form);
var inst_57355 = cljs.core.count(inst_57354__$1);
var inst_57356__$1 = (fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1(inst_57353__$1) : fluree.db.dbfunctions.core.find_local_fn.call(null,inst_57353__$1));
var state_57509__$1 = (function (){var statearr_57560 = state_57509;
(statearr_57560[(20)] = inst_57356__$1);

(statearr_57560[(10)] = inst_57354__$1);

(statearr_57560[(7)] = inst_57353__$1);

(statearr_57560[(18)] = inst_57355);

return statearr_57560;
})();
if(cljs.core.truth_(inst_57356__$1)){
var statearr_57561_57649 = state_57509__$1;
(statearr_57561_57649[(1)] = (6));

} else {
var statearr_57562_57650 = state_57509__$1;
(statearr_57562_57650[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (23))){
var inst_57499 = (state_57509[(2)]);
var state_57509__$1 = state_57509;
var statearr_57563_57651 = state_57509__$1;
(statearr_57563_57651[(2)] = inst_57499);

(statearr_57563_57651[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (47))){
var inst_57402 = (state_57509[(8)]);
var inst_57455 = (state_57509[(23)]);
var inst_57455__$1 = inst_57402 === false;
var state_57509__$1 = (function (){var statearr_57564 = state_57509;
(statearr_57564[(23)] = inst_57455__$1);

return statearr_57564;
})();
if(cljs.core.truth_(inst_57455__$1)){
var statearr_57565_57652 = state_57509__$1;
(statearr_57565_57652[(1)] = (49));

} else {
var statearr_57566_57653 = state_57509__$1;
(statearr_57566_57653[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (35))){
var inst_57402 = (state_57509[(8)]);
var inst_57452 = (state_57509[(9)]);
var inst_57452__$1 = inst_57402 === true;
var state_57509__$1 = (function (){var statearr_57567 = state_57509;
(statearr_57567[(9)] = inst_57452__$1);

return statearr_57567;
})();
if(cljs.core.truth_(inst_57452__$1)){
var statearr_57568_57654 = state_57509__$1;
(statearr_57568_57654[(1)] = (46));

} else {
var statearr_57569_57655 = state_57509__$1;
(statearr_57569_57655[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (19))){
var inst_57402 = (state_57509[(8)]);
var inst_57406 = inst_57402 === false;
var state_57509__$1 = state_57509;
var statearr_57570_57656 = state_57509__$1;
(statearr_57570_57656[(2)] = inst_57406);

(statearr_57570_57656[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (57))){
var inst_57484 = (state_57509[(2)]);
var state_57509__$1 = state_57509;
var statearr_57571_57657 = state_57509__$1;
(statearr_57571_57657[(2)] = inst_57484);

(statearr_57571_57657[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (11))){
var inst_57367 = (state_57509[(17)]);
var inst_57355 = (state_57509[(18)]);
var inst_57372 = (inst_57367.cljs$core$IFn$_invoke$arity$1 ? inst_57367.cljs$core$IFn$_invoke$arity$1(inst_57355) : inst_57367.call(null,inst_57355));
var state_57509__$1 = state_57509;
var statearr_57573_57658 = state_57509__$1;
(statearr_57573_57658[(2)] = inst_57372);

(statearr_57573_57658[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (9))){
var inst_57361 = (state_57509[(2)]);
var inst_57362 = fluree.db.util.async.throw_err(inst_57361);
var state_57509__$1 = state_57509;
var statearr_57574_57659 = state_57509__$1;
(statearr_57574_57659[(2)] = inst_57362);

(statearr_57574_57659[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (5))){
var _ = (function (){var statearr_57575 = state_57509;
(statearr_57575[(4)] = cljs.core.rest((state_57509[(4)])));

return statearr_57575;
})();
var state_57509__$1 = state_57509;
var ex57572 = (state_57509__$1[(2)]);
var statearr_57576_57660 = state_57509__$1;
(statearr_57576_57660[(5)] = ex57572);


if((ex57572 instanceof Error)){
var statearr_57577_57661 = state_57509__$1;
(statearr_57577_57661[(1)] = (4));

(statearr_57577_57661[(5)] = null);

} else {
throw ex57572;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (14))){
var state_57509__$1 = state_57509;
var statearr_57578_57662 = state_57509__$1;
(statearr_57578_57662[(2)] = null);

(statearr_57578_57662[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (45))){
var inst_57446 = (state_57509[(2)]);
var state_57509__$1 = state_57509;
var statearr_57579_57663 = state_57509__$1;
(statearr_57579_57663[(2)] = inst_57446);

(statearr_57579_57663[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (53))){
var inst_57402 = (state_57509[(8)]);
var inst_57465 = cljs.core.vector_QMARK_(inst_57402);
var state_57509__$1 = state_57509;
if(inst_57465){
var statearr_57580_57664 = state_57509__$1;
(statearr_57580_57664[(1)] = (55));

} else {
var statearr_57581_57665 = state_57509__$1;
(statearr_57581_57665[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (26))){
var inst_57403 = (state_57509[(24)]);
var inst_57396 = (state_57509[(13)]);
var inst_57494 = (state_57509[(2)]);
var inst_57495 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_57396,inst_57494);
var inst_57395 = inst_57403;
var inst_57396__$1 = inst_57495;
var state_57509__$1 = (function (){var statearr_57582 = state_57509;
(statearr_57582[(13)] = inst_57396__$1);

(statearr_57582[(14)] = inst_57395);

return statearr_57582;
})();
var statearr_57583_57666 = state_57509__$1;
(statearr_57583_57666[(2)] = null);

(statearr_57583_57666[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (16))){
var inst_57402 = (state_57509[(8)]);
var inst_57395 = (state_57509[(14)]);
var inst_57401 = cljs.core.seq(inst_57395);
var inst_57402__$1 = cljs.core.first(inst_57401);
var inst_57403 = cljs.core.next(inst_57401);
var state_57509__$1 = (function (){var statearr_57584 = state_57509;
(statearr_57584[(8)] = inst_57402__$1);

(statearr_57584[(24)] = inst_57403);

return statearr_57584;
})();
if(cljs.core.truth_(inst_57402__$1)){
var statearr_57585_57667 = state_57509__$1;
(statearr_57585_57667[(1)] = (18));

} else {
var statearr_57586_57668 = state_57509__$1;
(statearr_57586_57668[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (38))){
var inst_57367 = (state_57509[(17)]);
var inst_57402 = (state_57509[(8)]);
var inst_57369 = (state_57509[(25)]);
var inst_57365 = (state_57509[(26)]);
var inst_57354 = (state_57509[(10)]);
var inst_57403 = (state_57509[(24)]);
var inst_57353 = (state_57509[(7)]);
var inst_57432 = (state_57509[(16)]);
var inst_57355 = (state_57509[(18)]);
var inst_57383 = (state_57509[(11)]);
var inst_57368 = (state_57509[(27)]);
var inst_57392 = (state_57509[(12)]);
var inst_57364 = (state_57509[(28)]);
var inst_57396 = (state_57509[(13)]);
var inst_57395 = (state_57509[(14)]);
var inst_57366 = (state_57509[(22)]);
var inst_57393 = (state_57509[(15)]);
var inst_57425 = (state_57509[(21)]);
var inst_57428 = [inst_57402];
var inst_57429 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_57428);
var inst_57430 = (function (){var arity = inst_57367;
var args_n = inst_57355;
var fn_map = inst_57364;
var first__57390 = inst_57392;
var seq__57399 = inst_57403;
var first__57400 = inst_57402;
var args = inst_57354;
var r = inst_57403;
var _ = inst_57383;
var G__57387 = inst_57395;
var vec__57398 = inst_57395;
var acc = inst_57396;
var seq__57389 = inst_57393;
var arglist = inst_57368;
var map__57352 = inst_57365;
var fn_name = inst_57353;
var _AMPERSAND_args_QMARK_ = inst_57369;
var arg = inst_57402;
var vec__57388 = inst_57354;
var or__4253__auto__ = inst_57425;
var f = inst_57366;
return (function (p1__57343_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__57343_SHARP_);
});
})();
var inst_57431 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_57430,params);
var inst_57432__$1 = cljs.core.some(inst_57429,inst_57431);
var state_57509__$1 = (function (){var statearr_57587 = state_57509;
(statearr_57587[(16)] = inst_57432__$1);

return statearr_57587;
})();
if(cljs.core.truth_(inst_57432__$1)){
var statearr_57588_57669 = state_57509__$1;
(statearr_57588_57669[(1)] = (40));

} else {
var statearr_57589_57670 = state_57509__$1;
(statearr_57589_57670[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (30))){
var inst_57492 = (state_57509[(2)]);
var state_57509__$1 = state_57509;
var statearr_57590_57671 = state_57509__$1;
(statearr_57590_57671[(2)] = inst_57492);

(statearr_57590_57671[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (10))){
var inst_57369 = (state_57509[(25)]);
var state_57509__$1 = state_57509;
var statearr_57591_57672 = state_57509__$1;
(statearr_57591_57672[(2)] = inst_57369);

(statearr_57591_57672[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (18))){
var inst_57402 = (state_57509[(8)]);
var state_57509__$1 = state_57509;
var statearr_57592_57673 = state_57509__$1;
(statearr_57592_57673[(2)] = inst_57402);

(statearr_57592_57673[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (52))){
var inst_57402 = (state_57509[(8)]);
var state_57509__$1 = state_57509;
var statearr_57593_57674 = state_57509__$1;
(statearr_57593_57674[(2)] = inst_57402);

(statearr_57593_57674[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (42))){
var inst_57448 = (state_57509[(2)]);
var state_57509__$1 = state_57509;
var statearr_57594_57675 = state_57509__$1;
(statearr_57594_57675[(2)] = inst_57448);

(statearr_57594_57675[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (37))){
var inst_57425 = (state_57509[(21)]);
var state_57509__$1 = state_57509;
var statearr_57595_57676 = state_57509__$1;
(statearr_57595_57676[(2)] = inst_57425);

(statearr_57595_57676[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (8))){
var inst_57369 = (state_57509[(25)]);
var inst_57365 = (state_57509[(26)]);
var inst_57364 = (state_57509[(28)]);
var inst_57364__$1 = (state_57509[(2)]);
var inst_57365__$1 = cljs.core.__destructure_map(inst_57364__$1);
var inst_57366 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57365__$1,new cljs.core.Keyword(null,"f","f",-1597136552));
var inst_57367 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57365__$1,new cljs.core.Keyword(null,"arity","arity",-1808556135));
var inst_57368 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57365__$1,new cljs.core.Keyword(null,"arglist","arglist",-1808272150));
var inst_57369__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57365__$1,new cljs.core.Keyword(null,"&args?","&args?",-1736256945));
var state_57509__$1 = (function (){var statearr_57596 = state_57509;
(statearr_57596[(17)] = inst_57367);

(statearr_57596[(25)] = inst_57369__$1);

(statearr_57596[(26)] = inst_57365__$1);

(statearr_57596[(27)] = inst_57368);

(statearr_57596[(28)] = inst_57364__$1);

(statearr_57596[(22)] = inst_57366);

return statearr_57596;
})();
if(cljs.core.truth_(inst_57369__$1)){
var statearr_57597_57677 = state_57509__$1;
(statearr_57597_57677[(1)] = (10));

} else {
var statearr_57598_57678 = state_57509__$1;
(statearr_57598_57678[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57510 === (49))){
var inst_57455 = (state_57509[(23)]);
var state_57509__$1 = state_57509;
var statearr_57599_57679 = state_57509__$1;
(statearr_57599_57679[(2)] = inst_57455);

(statearr_57599_57679[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2741__auto____0 = (function (){
var statearr_57600 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57600[(0)] = fluree$db$dbfunctions$core$state_machine__2741__auto__);

(statearr_57600[(1)] = (1));

return statearr_57600;
});
var fluree$db$dbfunctions$core$state_machine__2741__auto____1 = (function (state_57509){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_57509);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e57601){var ex__2744__auto__ = e57601;
var statearr_57602_57680 = state_57509;
(statearr_57602_57680[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_57509[(4)]))){
var statearr_57603_57681 = state_57509;
(statearr_57603_57681[(1)] = cljs.core.first((state_57509[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57682 = state_57509;
state_57509 = G__57682;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2741__auto__ = function(state_57509){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2741__auto____1.call(this,state_57509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2741__auto____0;
fluree$db$dbfunctions$core$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2741__auto____1;
return fluree$db$dbfunctions$core$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_57604 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_57604[(6)] = c__2763__auto__);

return statearr_57604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(var_args){
var G__57684 = arguments.length;
switch (G__57684) {
case 3:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_57766){
var state_val_57767 = (state_57766[(1)]);
if((state_val_57767 === (7))){
var inst_57694 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"false");
var state_57766__$1 = state_57766;
var statearr_57768_57816 = state_57766__$1;
(statearr_57768_57816[(2)] = inst_57694);

(statearr_57768_57816[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (20))){
var inst_57744 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_57766__$1 = state_57766;
var statearr_57769_57817 = state_57766__$1;
(statearr_57769_57817[(2)] = inst_57744);

(statearr_57769_57817[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (1))){
var state_57766__$1 = state_57766;
var statearr_57770_57818 = state_57766__$1;
(statearr_57770_57818[(2)] = null);

(statearr_57770_57818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (24))){
var inst_57741 = (state_57766[(7)]);
var inst_57750 = cljs.core.eval(inst_57741);
var state_57766__$1 = state_57766;
var statearr_57772_57819 = state_57766__$1;
(statearr_57772_57819[(2)] = inst_57750);

(statearr_57772_57819[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (4))){
var inst_57685 = (state_57766[(2)]);
var state_57766__$1 = state_57766;
var statearr_57773_57820 = state_57766__$1;
(statearr_57773_57820[(2)] = inst_57685);

(statearr_57773_57820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (15))){
var _ = (function (){var statearr_57774 = state_57766;
(statearr_57774[(4)] = cljs.core.rest((state_57766[(4)])));

return statearr_57774;
})();
var state_57766__$1 = state_57766;
var ex57771 = (state_57766__$1[(2)]);
var statearr_57775_57821 = state_57766__$1;
(statearr_57775_57821[(5)] = ex57771);


var statearr_57776_57822 = state_57766__$1;
(statearr_57776_57822[(1)] = (14));

(statearr_57776_57822[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (21))){
var inst_57742 = (state_57766[(8)]);
var state_57766__$1 = state_57766;
var statearr_57777_57823 = state_57766__$1;
(statearr_57777_57823[(2)] = inst_57742);

(statearr_57777_57823[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (13))){
var inst_57759 = (state_57766[(2)]);
var state_57766__$1 = state_57766;
var statearr_57778_57824 = state_57766__$1;
(statearr_57778_57824[(2)] = inst_57759);

(statearr_57778_57824[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (22))){
var inst_57747 = (state_57766[(2)]);
var state_57766__$1 = state_57766;
if(cljs.core.truth_(inst_57747)){
var statearr_57779_57825 = state_57766__$1;
(statearr_57779_57825[(1)] = (23));

} else {
var statearr_57780_57826 = state_57766__$1;
(statearr_57780_57826[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (6))){
var inst_57691 = (state_57766[(9)]);
var state_57766__$1 = state_57766;
var statearr_57781_57827 = state_57766__$1;
(statearr_57781_57827[(2)] = inst_57691);

(statearr_57781_57827[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (25))){
var inst_57752 = (state_57766[(2)]);
var inst_57753 = [new cljs.core.Keyword(null,"fnstr","fnstr",2092773532)];
var inst_57754 = [fn_str];
var inst_57755 = cljs.core.PersistentHashMap.fromArrays(inst_57753,inst_57754);
var inst_57756 = cljs.core.with_meta(inst_57752,inst_57755);
var _ = (function (){var statearr_57782 = state_57766;
(statearr_57782[(4)] = cljs.core.rest((state_57766[(4)])));

return statearr_57782;
})();
var state_57766__$1 = state_57766;
var statearr_57783_57828 = state_57766__$1;
(statearr_57783_57828[(2)] = inst_57756);

(statearr_57783_57828[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (17))){
var inst_57717 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_57718 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_57719 = cljs.core.PersistentHashMap.fromArrays(inst_57717,inst_57718);
var inst_57720 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_57719);
var inst_57721 = (function(){throw inst_57720})();
var state_57766__$1 = state_57766;
var statearr_57784_57829 = state_57766__$1;
(statearr_57784_57829[(2)] = inst_57721);

(statearr_57784_57829[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (3))){
var inst_57764 = (state_57766[(2)]);
var state_57766__$1 = state_57766;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57766__$1,inst_57764);
} else {
if((state_val_57767 === (12))){
var _ = (function (){var statearr_57785 = state_57766;
(statearr_57785[(4)] = cljs.core.cons((15),(state_57766[(4)])));

return statearr_57785;
})();
var inst_57714 = cljs.core.re_matches(/(^\(.+\)$)/,fn_str);
var state_57766__$1 = state_57766;
if(cljs.core.truth_(inst_57714)){
var statearr_57786_57830 = state_57766__$1;
(statearr_57786_57830[(1)] = (16));

} else {
var statearr_57787_57831 = state_57766__$1;
(statearr_57787_57831[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (2))){
var inst_57691 = (state_57766[(9)]);
var _ = (function (){var statearr_57788 = state_57766;
(statearr_57788[(4)] = cljs.core.cons((5),(state_57766[(4)])));

return statearr_57788;
})();
var inst_57691__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"true");
var state_57766__$1 = (function (){var statearr_57789 = state_57766;
(statearr_57789[(9)] = inst_57691__$1);

return statearr_57789;
})();
if(inst_57691__$1){
var statearr_57790_57832 = state_57766__$1;
(statearr_57790_57832[(1)] = (6));

} else {
var statearr_57791_57833 = state_57766__$1;
(statearr_57791_57833[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (23))){
var inst_57741 = (state_57766[(7)]);
var state_57766__$1 = state_57766;
var statearr_57792_57834 = state_57766__$1;
(statearr_57792_57834[(2)] = inst_57741);

(statearr_57792_57834[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (19))){
var inst_57742 = (state_57766[(8)]);
var inst_57727 = (state_57766[(2)]);
var inst_57728 = fluree.db.util.async.throw_err(inst_57727);
var inst_57729 = new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null);
var inst_57730 = (new cljs.core.List(null,inst_57729,null,(1),null));
var inst_57731 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_57732 = (new cljs.core.List(null,inst_57731,null,(1),null));
var inst_57733 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_57732);
var inst_57734 = cljs.core.seq(inst_57733);
var inst_57735 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_57734);
var inst_57736 = cljs.core.vec(inst_57735);
var inst_57737 = (new cljs.core.List(null,inst_57736,null,(1),null));
var inst_57738 = (new cljs.core.List(null,inst_57728,null,(1),null));
var inst_57739 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_57730,inst_57737,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_57738], 0));
var inst_57740 = cljs.core.seq(inst_57739);
var inst_57741 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_57740);
var inst_57742__$1 = params;
var state_57766__$1 = (function (){var statearr_57793 = state_57766;
(statearr_57793[(7)] = inst_57741);

(statearr_57793[(8)] = inst_57742__$1);

return statearr_57793;
})();
if(cljs.core.truth_(inst_57742__$1)){
var statearr_57794_57835 = state_57766__$1;
(statearr_57794_57835[(1)] = (20));

} else {
var statearr_57795_57836 = state_57766__$1;
(statearr_57795_57836[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (11))){
var inst_57761 = (state_57766[(2)]);
var _ = (function (){var statearr_57797 = state_57766;
(statearr_57797[(4)] = cljs.core.rest((state_57766[(4)])));

return statearr_57797;
})();
var state_57766__$1 = state_57766;
var statearr_57798_57837 = state_57766__$1;
(statearr_57798_57837[(2)] = inst_57761);

(statearr_57798_57837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (9))){
var inst_57698 = (function (){return (function (n){
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
});
})();
var inst_57699 = fluree.db.dbfunctions.core.true_or_false = inst_57698;
var state_57766__$1 = state_57766;
var statearr_57799_57838 = state_57766__$1;
(statearr_57799_57838[(2)] = inst_57699);

(statearr_57799_57838[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (5))){
var _ = (function (){var statearr_57800 = state_57766;
(statearr_57800[(4)] = cljs.core.rest((state_57766[(4)])));

return statearr_57800;
})();
var state_57766__$1 = state_57766;
var ex57796 = (state_57766__$1[(2)]);
var statearr_57801_57839 = state_57766__$1;
(statearr_57801_57839[(5)] = ex57796);


if((ex57796 instanceof Error)){
var statearr_57802_57840 = state_57766__$1;
(statearr_57802_57840[(1)] = (4));

(statearr_57802_57840[(5)] = null);

} else {
throw ex57796;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (14))){
var inst_57701 = (state_57766[(2)]);
var inst_57702 = (function(){throw inst_57701})();
var inst_57703 = ["Error parsing function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_57704 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_57705 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_57706 = cljs.core.PersistentHashMap.fromArrays(inst_57704,inst_57705);
var inst_57707 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_57703,inst_57706);
var inst_57708 = (function(){throw inst_57707})();
var state_57766__$1 = (function (){var statearr_57803 = state_57766;
(statearr_57803[(10)] = inst_57702);

return statearr_57803;
})();
var statearr_57804_57841 = state_57766__$1;
(statearr_57804_57841[(2)] = inst_57708);

(statearr_57804_57841[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (16))){
var state_57766__$1 = state_57766;
var statearr_57805_57842 = state_57766__$1;
(statearr_57805_57842[(2)] = null);

(statearr_57805_57842[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (10))){
var state_57766__$1 = state_57766;
var statearr_57806_57843 = state_57766__$1;
(statearr_57806_57843[(2)] = null);

(statearr_57806_57843[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57767 === (18))){
var inst_57723 = (state_57766[(2)]);
var inst_57724 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
var inst_57725 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_57724,type,params);
var state_57766__$1 = (function (){var statearr_57807 = state_57766;
(statearr_57807[(11)] = inst_57723);

return statearr_57807;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57766__$1,(19),inst_57725);
} else {
if((state_val_57767 === (8))){
var inst_57696 = (state_57766[(2)]);
var state_57766__$1 = state_57766;
if(cljs.core.truth_(inst_57696)){
var statearr_57808_57844 = state_57766__$1;
(statearr_57808_57844[(1)] = (9));

} else {
var statearr_57809_57845 = state_57766__$1;
(statearr_57809_57845[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2741__auto____0 = (function (){
var statearr_57810 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57810[(0)] = fluree$db$dbfunctions$core$state_machine__2741__auto__);

(statearr_57810[(1)] = (1));

return statearr_57810;
});
var fluree$db$dbfunctions$core$state_machine__2741__auto____1 = (function (state_57766){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_57766);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e57811){var ex__2744__auto__ = e57811;
var statearr_57812_57846 = state_57766;
(statearr_57812_57846[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_57766[(4)]))){
var statearr_57813_57847 = state_57766;
(statearr_57813_57847[(1)] = cljs.core.first((state_57766[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57848 = state_57766;
state_57766 = G__57848;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2741__auto__ = function(state_57766){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2741__auto____1.call(this,state_57766);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2741__auto____0;
fluree$db$dbfunctions$core$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2741__auto____1;
return fluree$db$dbfunctions$core$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_57814 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_57814[(6)] = c__2763__auto__);

return statearr_57814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(db,auth_id,credits,s,p,o,fuel,block_instant){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_57876){
var state_val_57877 = (state_57876[(1)]);
if((state_val_57877 === (7))){
var inst_57863 = (state_57876[(7)]);
var state_57876__$1 = state_57876;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57876__$1,(10),inst_57863);
} else {
if((state_val_57877 === (1))){
var state_57876__$1 = state_57876;
var statearr_57878_57898 = state_57876__$1;
(statearr_57878_57898[(2)] = null);

(statearr_57878_57898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57877 === (4))){
var inst_57849 = (state_57876[(2)]);
var state_57876__$1 = state_57876;
var statearr_57879_57899 = state_57876__$1;
(statearr_57879_57899[(2)] = inst_57849);

(statearr_57879_57899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57877 === (6))){
var inst_57863 = (state_57876[(7)]);
var inst_57858 = (state_57876[(8)]);
var inst_57861 = (state_57876[(2)]);
var inst_57862 = fluree.db.util.async.throw_err(inst_57861);
var inst_57863__$1 = (inst_57862.cljs$core$IFn$_invoke$arity$1 ? inst_57862.cljs$core$IFn$_invoke$arity$1(inst_57858) : inst_57862.call(null,inst_57858));
var inst_57864 = fluree.db.util.async.channel_QMARK_(inst_57863__$1);
var state_57876__$1 = (function (){var statearr_57880 = state_57876;
(statearr_57880[(7)] = inst_57863__$1);

return statearr_57880;
})();
if(inst_57864){
var statearr_57881_57900 = state_57876__$1;
(statearr_57881_57900[(1)] = (7));

} else {
var statearr_57882_57901 = state_57876__$1;
(statearr_57882_57901[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57877 === (3))){
var inst_57874 = (state_57876[(2)]);
var state_57876__$1 = state_57876;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57876__$1,inst_57874);
} else {
if((state_val_57877 === (2))){
var _ = (function (){var statearr_57884 = state_57876;
(statearr_57884[(4)] = cljs.core.cons((5),(state_57876[(4)])));

return statearr_57884;
})();
var inst_57855 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_57856 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"pid","pid",1018387698),new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),new cljs.core.Keyword(null,"state","state",-1988618099)];
var inst_57857 = [db,block_instant,s,p,auth_id,fuel];
var inst_57858 = cljs.core.PersistentHashMap.fromArrays(inst_57856,inst_57857);
var inst_57859 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,inst_57855,"txn",null);
var state_57876__$1 = (function (){var statearr_57885 = state_57876;
(statearr_57885[(8)] = inst_57858);

return statearr_57885;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57876__$1,(6),inst_57859);
} else {
if((state_val_57877 === (9))){
var inst_57871 = (state_57876[(2)]);
var _ = (function (){var statearr_57886 = state_57876;
(statearr_57886[(4)] = cljs.core.rest((state_57876[(4)])));

return statearr_57886;
})();
var state_57876__$1 = state_57876;
var statearr_57887_57902 = state_57876__$1;
(statearr_57887_57902[(2)] = inst_57871);

(statearr_57887_57902[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57877 === (5))){
var _ = (function (){var statearr_57888 = state_57876;
(statearr_57888[(4)] = cljs.core.rest((state_57876[(4)])));

return statearr_57888;
})();
var state_57876__$1 = state_57876;
var ex57883 = (state_57876__$1[(2)]);
var statearr_57889_57903 = state_57876__$1;
(statearr_57889_57903[(5)] = ex57883);


if((ex57883 instanceof Error)){
var statearr_57890_57904 = state_57876__$1;
(statearr_57890_57904[(1)] = (4));

(statearr_57890_57904[(5)] = null);

} else {
throw ex57883;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57877 === (10))){
var inst_57867 = (state_57876[(2)]);
var inst_57868 = fluree.db.util.async.throw_err(inst_57867);
var state_57876__$1 = state_57876;
var statearr_57891_57905 = state_57876__$1;
(statearr_57891_57905[(2)] = inst_57868);

(statearr_57891_57905[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57877 === (8))){
var inst_57863 = (state_57876[(7)]);
var state_57876__$1 = state_57876;
var statearr_57892_57906 = state_57876__$1;
(statearr_57892_57906[(2)] = inst_57863);

(statearr_57892_57906[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2741__auto____0 = (function (){
var statearr_57893 = [null,null,null,null,null,null,null,null,null];
(statearr_57893[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2741__auto__);

(statearr_57893[(1)] = (1));

return statearr_57893;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2741__auto____1 = (function (state_57876){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_57876);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e57894){var ex__2744__auto__ = e57894;
var statearr_57895_57907 = state_57876;
(statearr_57895_57907[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_57876[(4)]))){
var statearr_57896_57908 = state_57876;
(statearr_57896_57908[(1)] = cljs.core.first((state_57876[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57909 = state_57876;
state_57876 = G__57909;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2741__auto__ = function(state_57876){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2741__auto____1.call(this,state_57876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_57897 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_57897[(6)] = c__2763__auto__);

return statearr_57897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
