// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__26611 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26611,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26611,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26611,(2),null);
if(cljs.core.truth_((function (){var and__4251__auto__ = network;
if(cljs.core.truth_(and__4251__auto__)){
return maybe_alias;
} else {
return and__4251__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__26614){
var map__26615 = p__26614;
var map__26615__$1 = cljs.core.__destructure_map(map__26615);
var opts = map__26615__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26615__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_26675){
var state_val_26676 = (state_26675[(1)]);
if((state_val_26676 === (7))){
var inst_26646 = cljs.core.not(reindex_QMARK_);
var state_26675__$1 = state_26675;
var statearr_26677_26701 = state_26675__$1;
(statearr_26677_26701[(2)] = inst_26646);

(statearr_26677_26701[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26676 === (1))){
var state_26675__$1 = state_26675;
var statearr_26678_26702 = state_26675__$1;
(statearr_26678_26702[(2)] = null);

(statearr_26678_26702[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26676 === (4))){
var inst_26616 = (state_26675[(2)]);
var state_26675__$1 = state_26675;
var statearr_26679_26703 = state_26675__$1;
(statearr_26679_26703[(2)] = inst_26616);

(statearr_26679_26703[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26676 === (6))){
var inst_26644 = (state_26675[(7)]);
var inst_26630 = (state_26675[(8)]);
var inst_26636 = (state_26675[(9)]);
var inst_26629 = (state_26675[(2)]);
var inst_26630__$1 = fluree.db.util.async.throw_err(inst_26629);
var inst_26631 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_26632 = cljs.core.__destructure_map(inst_26631);
var inst_26633 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26632,new cljs.core.Keyword(null,"post","post",269697687));
var inst_26634 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26632,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_26635 = fluree.db.flake.size_bytes(inst_26630__$1);
var inst_26636__$1 = (inst_26634 + inst_26635);
var inst_26637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26638 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_26639 = (new cljs.core.PersistentVector(null,2,(5),inst_26637,inst_26638,null));
var inst_26640 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_26639);
var inst_26641 = cljs.core.__destructure_map(inst_26640);
var inst_26642 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26641,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_26643 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26641,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_26644__$1 = (inst_26636__$1 > inst_26643);
var state_26675__$1 = (function (){var statearr_26680 = state_26675;
(statearr_26680[(10)] = inst_26633);

(statearr_26680[(7)] = inst_26644__$1);

(statearr_26680[(8)] = inst_26630__$1);

(statearr_26680[(11)] = inst_26642);

(statearr_26680[(9)] = inst_26636__$1);

return statearr_26680;
})();
if(cljs.core.truth_(inst_26644__$1)){
var statearr_26681_26704 = state_26675__$1;
(statearr_26681_26704[(1)] = (7));

} else {
var statearr_26682_26705 = state_26675__$1;
(statearr_26682_26705[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26676 === (3))){
var inst_26673 = (state_26675[(2)]);
var state_26675__$1 = state_26675;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26675__$1,inst_26673);
} else {
if((state_val_26676 === (12))){
var inst_26633 = (state_26675[(10)]);
var inst_26630 = (state_26675[(8)]);
var inst_26636 = (state_26675[(9)]);
var inst_26659 = (state_26675[(2)]);
var inst_26660 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26633,inst_26630);
var inst_26661 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_26662 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_26661,cljs.core.empty);
var inst_26663 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26664 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26665 = (new cljs.core.PersistentVector(null,2,(5),inst_26663,inst_26664,null));
var inst_26666 = cljs.core.assoc_in(db,inst_26665,inst_26660);
var inst_26667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26668 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26669 = (new cljs.core.PersistentVector(null,2,(5),inst_26667,inst_26668,null));
var inst_26670 = cljs.core.assoc_in(inst_26666,inst_26669,inst_26636);
var _ = (function (){var statearr_26683 = state_26675;
(statearr_26683[(4)] = cljs.core.rest((state_26675[(4)])));

return statearr_26683;
})();
var state_26675__$1 = (function (){var statearr_26684 = state_26675;
(statearr_26684[(12)] = inst_26659);

(statearr_26684[(13)] = inst_26662);

return statearr_26684;
})();
var statearr_26685_26706 = state_26675__$1;
(statearr_26685_26706[(2)] = inst_26670);

(statearr_26685_26706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26676 === (2))){
var _ = (function (){var statearr_26686 = state_26675;
(statearr_26686[(4)] = cljs.core.cons((5),(state_26675[(4)])));

return statearr_26686;
})();
var inst_26624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26625 = [pred_id];
var inst_26626 = (new cljs.core.PersistentVector(null,1,(5),inst_26624,inst_26625,null));
var inst_26627 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26626);
var state_26675__$1 = state_26675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26675__$1,(6),inst_26627);
} else {
if((state_val_26676 === (11))){
var state_26675__$1 = state_26675;
var statearr_26688_26707 = state_26675__$1;
(statearr_26688_26707[(2)] = null);

(statearr_26688_26707[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26676 === (9))){
var inst_26649 = (state_26675[(2)]);
var state_26675__$1 = state_26675;
if(cljs.core.truth_(inst_26649)){
var statearr_26689_26708 = state_26675__$1;
(statearr_26689_26708[(1)] = (10));

} else {
var statearr_26690_26709 = state_26675__$1;
(statearr_26690_26709[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26676 === (5))){
var _ = (function (){var statearr_26691 = state_26675;
(statearr_26691[(4)] = cljs.core.rest((state_26675[(4)])));

return statearr_26691;
})();
var state_26675__$1 = state_26675;
var ex26687 = (state_26675__$1[(2)]);
var statearr_26692_26710 = state_26675__$1;
(statearr_26692_26710[(5)] = ex26687);


if((ex26687 instanceof Error)){
var statearr_26693_26711 = state_26675__$1;
(statearr_26693_26711[(1)] = (4));

(statearr_26693_26711[(5)] = null);

} else {
throw ex26687;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26676 === (10))){
var inst_26651 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_26652 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_26653 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_26654 = cljs.core.PersistentHashMap.fromArrays(inst_26652,inst_26653);
var inst_26655 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26651,inst_26654);
var inst_26656 = (function(){throw inst_26655})();
var state_26675__$1 = state_26675;
var statearr_26694_26712 = state_26675__$1;
(statearr_26694_26712[(2)] = inst_26656);

(statearr_26694_26712[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26676 === (8))){
var inst_26644 = (state_26675[(7)]);
var state_26675__$1 = state_26675;
var statearr_26695_26713 = state_26675__$1;
(statearr_26695_26713[(2)] = inst_26644);

(statearr_26695_26713[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto____0 = (function (){
var statearr_26696 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26696[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto__);

(statearr_26696[(1)] = (1));

return statearr_26696;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto____1 = (function (state_26675){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_26675);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e26697){var ex__2744__auto__ = e26697;
var statearr_26698_26714 = state_26675;
(statearr_26698_26714[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_26675[(4)]))){
var statearr_26699_26715 = state_26675;
(statearr_26699_26715[(1)] = cljs.core.first((state_26675[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26716 = state_26675;
state_26675 = G__26716;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto__ = function(state_26675){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto____1.call(this,state_26675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_26700 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_26700[(6)] = c__2763__auto__);

return statearr_26700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__26721 = arguments.length;
switch (G__26721) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_26917){
var state_val_26918 = (state_26917[(1)]);
if((state_val_26918 === (7))){
var state_26917__$1 = state_26917;
var statearr_26919_26987 = state_26917__$1;
(statearr_26919_26987[(2)] = null);

(statearr_26919_26987[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (20))){
var inst_26760 = (state_26917[(7)]);
var inst_26843 = (state_26917[(8)]);
var inst_26759 = (state_26917[(9)]);
var inst_26842 = (state_26917[(10)]);
var inst_26810 = (state_26917[(11)]);
var inst_26841 = (state_26917[(12)]);
var inst_26839 = (state_26917[(13)]);
var inst_26840 = (state_26917[(14)]);
var inst_26853 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26855 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26856 = (new cljs.core.PersistentVector(null,2,(5),inst_26854,inst_26855,null));
var inst_26857 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26810,inst_26856);
var inst_26858 = (inst_26759 + inst_26857);
var inst_26859 = [inst_26839,inst_26840,inst_26841,inst_26842,inst_26858];
var inst_26860 = cljs.core.PersistentHashMap.fromArrays(inst_26853,inst_26859);
var inst_26861 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_26810,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_26843,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26860], 0));
var state_26917__$1 = (function (){var statearr_26920 = state_26917;
(statearr_26920[(15)] = inst_26861);

return statearr_26920;
})();
if(cljs.core.truth_(inst_26760)){
var statearr_26921_26988 = state_26917__$1;
(statearr_26921_26988[(1)] = (23));

} else {
var statearr_26922_26989 = state_26917__$1;
(statearr_26922_26989[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (27))){
var inst_26861 = (state_26917[(15)]);
var state_26917__$1 = state_26917;
var statearr_26923_26990 = state_26917__$1;
(statearr_26923_26990[(2)] = inst_26861);

(statearr_26923_26990[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (1))){
var state_26917__$1 = state_26917;
var statearr_26924_26991 = state_26917__$1;
(statearr_26924_26991[(2)] = null);

(statearr_26924_26991[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (24))){
var inst_26861 = (state_26917[(15)]);
var inst_26864 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26861);
var inst_26865 = (inst_26864 == null);
var state_26917__$1 = state_26917;
var statearr_26925_26992 = state_26917__$1;
(statearr_26925_26992[(2)] = inst_26865);

(statearr_26925_26992[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (39))){
var inst_26892 = (state_26917[(16)]);
var inst_26850 = (state_26917[(17)]);
var inst_26891 = (state_26917[(18)]);
var inst_26893 = (state_26917[(19)]);
var inst_26900 = (state_26917[(20)]);
var inst_26907 = (state_26917[(2)]);
var inst_26838 = inst_26850;
var inst_26839 = inst_26892;
var inst_26840 = inst_26893;
var inst_26841 = inst_26900;
var inst_26842 = inst_26907;
var inst_26843 = inst_26891;
var state_26917__$1 = (function (){var statearr_26926 = state_26917;
(statearr_26926[(8)] = inst_26843);

(statearr_26926[(10)] = inst_26842);

(statearr_26926[(21)] = inst_26838);

(statearr_26926[(12)] = inst_26841);

(statearr_26926[(13)] = inst_26839);

(statearr_26926[(14)] = inst_26840);

return statearr_26926;
})();
var statearr_26927_26993 = state_26917__$1;
(statearr_26927_26993[(2)] = null);

(statearr_26927_26993[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (4))){
var inst_26722 = (state_26917[(2)]);
var state_26917__$1 = state_26917;
var statearr_26928_26994 = state_26917__$1;
(statearr_26928_26994[(2)] = inst_26722);

(statearr_26928_26994[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (15))){
var inst_26782 = (state_26917[(22)]);
var state_26917__$1 = state_26917;
var statearr_26929_26995 = state_26917__$1;
(statearr_26929_26995[(2)] = inst_26782);

(statearr_26929_26995[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (21))){
var inst_26760 = (state_26917[(7)]);
var inst_26843 = (state_26917[(8)]);
var inst_26849 = (state_26917[(23)]);
var inst_26761 = (state_26917[(24)]);
var inst_26759 = (state_26917[(9)]);
var inst_26750 = (state_26917[(25)]);
var inst_26754 = (state_26917[(26)]);
var inst_26769 = (state_26917[(27)]);
var inst_26842 = (state_26917[(10)]);
var inst_26810 = (state_26917[(11)]);
var inst_26850 = (state_26917[(17)]);
var inst_26729 = (state_26917[(28)]);
var inst_26838 = (state_26917[(21)]);
var inst_26763 = (state_26917[(29)]);
var inst_26744 = (state_26917[(30)]);
var inst_26841 = (state_26917[(12)]);
var inst_26820 = (state_26917[(31)]);
var inst_26746 = (state_26917[(32)]);
var inst_26839 = (state_26917[(13)]);
var inst_26819 = (state_26917[(33)]);
var inst_26758 = (state_26917[(34)]);
var inst_26840 = (state_26917[(14)]);
var inst_26888 = inst_26849.s;
var inst_26889 = fluree.db.flake.sid__GT_cid(inst_26888);
var inst_26890 = (function (){var flakes_bytes = inst_26759;
var t = inst_26729;
var seq__26846 = inst_26850;
var seq__26816 = inst_26820;
var spot = inst_26839;
var add_flakes = inst_26746;
var vec__26845 = inst_26838;
var root_setting_change_QMARK_ = inst_26761;
var first__26817 = inst_26819;
var ref_QMARK__map = inst_26758;
var r = inst_26850;
var psot = inst_26840;
var add_pred_to_idx_QMARK_ = inst_26769;
var _ = inst_26744;
var cid = inst_26889;
var ecount = inst_26843;
var G__26814 = inst_26838;
var pred_ecount = inst_26763;
var first__26847 = inst_26849;
var db_STAR_ = inst_26810;
var schema_change_QMARK_ = inst_26760;
var add_preds = inst_26750;
var vec__26815 = inst_26746;
var opst = inst_26842;
var idx_QMARK__map = inst_26754;
var post = inst_26841;
var f = inst_26849;
return (function (p1__26719_SHARP_){
if(cljs.core.truth_(p1__26719_SHARP_)){
var x__4336__auto__ = p1__26719_SHARP_;
var y__4337__auto__ = f.s;
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
} else {
return f.s;
}
});
})();
var inst_26891 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_26843,inst_26889,inst_26890);
var inst_26892 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26839,inst_26849);
var inst_26893 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26840,inst_26849);
var inst_26894 = inst_26849.p;
var inst_26895 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26754,inst_26894);
var state_26917__$1 = (function (){var statearr_26930 = state_26917;
(statearr_26930[(16)] = inst_26892);

(statearr_26930[(18)] = inst_26891);

(statearr_26930[(19)] = inst_26893);

return statearr_26930;
})();
if(cljs.core.truth_(inst_26895)){
var statearr_26931_26996 = state_26917__$1;
(statearr_26931_26996[(1)] = (34));

} else {
var statearr_26932_26997 = state_26917__$1;
(statearr_26932_26997[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (31))){
var inst_26876 = (state_26917[(35)]);
var state_26917__$1 = state_26917;
var statearr_26933_26998 = state_26917__$1;
(statearr_26933_26998[(2)] = inst_26876);

(statearr_26933_26998[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (32))){
var inst_26886 = (state_26917[(2)]);
var state_26917__$1 = state_26917;
var statearr_26934_26999 = state_26917__$1;
(statearr_26934_26999[(2)] = inst_26886);

(statearr_26934_26999[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (33))){
var inst_26876 = (state_26917[(35)]);
var inst_26881 = (state_26917[(2)]);
var inst_26882 = fluree.db.util.async.throw_err(inst_26881);
var inst_26883 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26876,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26882);
var state_26917__$1 = state_26917;
var statearr_26935_27000 = state_26917__$1;
(statearr_26935_27000[(2)] = inst_26883);

(statearr_26935_27000[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (13))){
var inst_26759 = (state_26917[(9)]);
var inst_26810 = (state_26917[(11)]);
var inst_26729 = (state_26917[(28)]);
var inst_26746 = (state_26917[(32)]);
var inst_26800 = (state_26917[(2)]);
var inst_26801 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26800,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26729);
var inst_26802 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26803 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26804 = (new cljs.core.PersistentVector(null,2,(5),inst_26802,inst_26803,null));
var inst_26805 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26801,inst_26804,cljs.core._PLUS_,inst_26759);
var inst_26806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26807 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_26808 = (new cljs.core.PersistentVector(null,2,(5),inst_26806,inst_26807,null));
var inst_26809 = cljs.core.count(inst_26746);
var inst_26810__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26805,inst_26808,cljs.core._PLUS_,inst_26809);
var inst_26818 = cljs.core.seq(inst_26746);
var inst_26819 = cljs.core.first(inst_26818);
var inst_26820 = cljs.core.next(inst_26818);
var inst_26821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26822 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_26823 = (new cljs.core.PersistentVector(null,2,(5),inst_26821,inst_26822,null));
var inst_26824 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26810__$1,inst_26823);
var inst_26825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26826 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_26827 = (new cljs.core.PersistentVector(null,2,(5),inst_26825,inst_26826,null));
var inst_26828 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26810__$1,inst_26827);
var inst_26829 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26830 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26831 = (new cljs.core.PersistentVector(null,2,(5),inst_26829,inst_26830,null));
var inst_26832 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26810__$1,inst_26831);
var inst_26833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26834 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26835 = (new cljs.core.PersistentVector(null,2,(5),inst_26833,inst_26834,null));
var inst_26836 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26810__$1,inst_26835);
var inst_26837 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26838 = inst_26746;
var inst_26839 = inst_26824;
var inst_26840 = inst_26828;
var inst_26841 = inst_26832;
var inst_26842 = inst_26836;
var inst_26843 = inst_26837;
var state_26917__$1 = (function (){var statearr_26936 = state_26917;
(statearr_26936[(8)] = inst_26843);

(statearr_26936[(10)] = inst_26842);

(statearr_26936[(11)] = inst_26810__$1);

(statearr_26936[(21)] = inst_26838);

(statearr_26936[(12)] = inst_26841);

(statearr_26936[(31)] = inst_26820);

(statearr_26936[(13)] = inst_26839);

(statearr_26936[(33)] = inst_26819);

(statearr_26936[(14)] = inst_26840);

return statearr_26936;
})();
var statearr_26937_27001 = state_26917__$1;
(statearr_26937_27001[(2)] = null);

(statearr_26937_27001[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (22))){
var inst_26910 = (state_26917[(2)]);
var state_26917__$1 = state_26917;
var statearr_26938_27002 = state_26917__$1;
(statearr_26938_27002[(2)] = inst_26910);

(statearr_26938_27002[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (36))){
var inst_26849 = (state_26917[(23)]);
var inst_26758 = (state_26917[(34)]);
var inst_26900 = (state_26917[(2)]);
var inst_26901 = inst_26849.p;
var inst_26902 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26758,inst_26901);
var state_26917__$1 = (function (){var statearr_26939 = state_26917;
(statearr_26939[(20)] = inst_26900);

return statearr_26939;
})();
if(cljs.core.truth_(inst_26902)){
var statearr_26940_27003 = state_26917__$1;
(statearr_26940_27003[(1)] = (37));

} else {
var statearr_26941_27004 = state_26917__$1;
(statearr_26941_27004[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (29))){
var inst_26861 = (state_26917[(15)]);
var inst_26871 = (state_26917[(2)]);
var inst_26872 = fluree.db.util.async.throw_err(inst_26871);
var inst_26873 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26861,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26872);
var state_26917__$1 = state_26917;
var statearr_26942_27005 = state_26917__$1;
(statearr_26942_27005[(2)] = inst_26873);

(statearr_26942_27005[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (6))){
var inst_26729 = (state_26917[(28)]);
var inst_26734 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26735 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26736 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26734)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26735)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26729),"."].join('');
var inst_26737 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26738 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26739 = cljs.core.PersistentHashMap.fromArrays(inst_26737,inst_26738);
var inst_26740 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26736,inst_26739);
var inst_26741 = (function(){throw inst_26740})();
var state_26917__$1 = state_26917;
var statearr_26943_27006 = state_26917__$1;
(statearr_26943_27006[(2)] = inst_26741);

(statearr_26943_27006[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (28))){
var inst_26761 = (state_26917[(24)]);
var inst_26876 = (state_26917[(2)]);
var state_26917__$1 = (function (){var statearr_26944 = state_26917;
(statearr_26944[(35)] = inst_26876);

return statearr_26944;
})();
if(cljs.core.truth_(inst_26761)){
var statearr_26945_27007 = state_26917__$1;
(statearr_26945_27007[(1)] = (30));

} else {
var statearr_26946_27008 = state_26917__$1;
(statearr_26946_27008[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (25))){
var inst_26867 = (state_26917[(2)]);
var state_26917__$1 = state_26917;
if(cljs.core.truth_(inst_26867)){
var statearr_26947_27009 = state_26917__$1;
(statearr_26947_27009[(1)] = (26));

} else {
var statearr_26948_27010 = state_26917__$1;
(statearr_26948_27010[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (34))){
var inst_26849 = (state_26917[(23)]);
var inst_26841 = (state_26917[(12)]);
var inst_26897 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26841,inst_26849);
var state_26917__$1 = state_26917;
var statearr_26949_27011 = state_26917__$1;
(statearr_26949_27011[(2)] = inst_26897);

(statearr_26949_27011[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (17))){
var inst_26789 = (state_26917[(36)]);
var inst_26793 = (state_26917[(2)]);
var inst_26794 = fluree.db.util.async.throw_err(inst_26793);
var inst_26781 = inst_26789;
var inst_26782 = inst_26794;
var state_26917__$1 = (function (){var statearr_26950 = state_26917;
(statearr_26950[(22)] = inst_26782);

(statearr_26950[(37)] = inst_26781);

return statearr_26950;
})();
var statearr_26951_27012 = state_26917__$1;
(statearr_26951_27012[(2)] = null);

(statearr_26951_27012[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (3))){
var inst_26915 = (state_26917[(2)]);
var state_26917__$1 = state_26917;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26917__$1,inst_26915);
} else {
if((state_val_26918 === (12))){
var inst_26781 = (state_26917[(37)]);
var inst_26788 = (state_26917[(38)]);
var inst_26787 = cljs.core.seq(inst_26781);
var inst_26788__$1 = cljs.core.first(inst_26787);
var inst_26789 = cljs.core.next(inst_26787);
var state_26917__$1 = (function (){var statearr_26952 = state_26917;
(statearr_26952[(36)] = inst_26789);

(statearr_26952[(38)] = inst_26788__$1);

return statearr_26952;
})();
if(cljs.core.truth_(inst_26788__$1)){
var statearr_26953_27013 = state_26917__$1;
(statearr_26953_27013[(1)] = (14));

} else {
var statearr_26954_27014 = state_26917__$1;
(statearr_26954_27014[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (2))){
var inst_26729 = (state_26917[(28)]);
var _ = (function (){var statearr_26955 = state_26917;
(statearr_26955[(4)] = cljs.core.cons((5),(state_26917[(4)])));

return statearr_26955;
})();
var inst_26728 = cljs.core.first(flakes);
var inst_26729__$1 = inst_26728.t;
var inst_26730 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26731 = (inst_26730 - (1));
var inst_26732 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_26729__$1,inst_26731);
var state_26917__$1 = (function (){var statearr_26956 = state_26917;
(statearr_26956[(28)] = inst_26729__$1);

return statearr_26956;
})();
if(inst_26732){
var statearr_26957_27015 = state_26917__$1;
(statearr_26957_27015[(1)] = (6));

} else {
var statearr_26958_27016 = state_26917__$1;
(statearr_26958_27016[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (23))){
var inst_26760 = (state_26917[(7)]);
var state_26917__$1 = state_26917;
var statearr_26959_27017 = state_26917__$1;
(statearr_26959_27017[(2)] = inst_26760);

(statearr_26959_27017[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (35))){
var inst_26841 = (state_26917[(12)]);
var state_26917__$1 = state_26917;
var statearr_26960_27018 = state_26917__$1;
(statearr_26960_27018[(2)] = inst_26841);

(statearr_26960_27018[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (19))){
var inst_26912 = (state_26917[(2)]);
var _ = (function (){var statearr_26961 = state_26917;
(statearr_26961[(4)] = cljs.core.rest((state_26917[(4)])));

return statearr_26961;
})();
var state_26917__$1 = state_26917;
var statearr_26962_27019 = state_26917__$1;
(statearr_26962_27019[(2)] = inst_26912);

(statearr_26962_27019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (11))){
var inst_26769 = (state_26917[(27)]);
var inst_26769__$1 = (state_26917[(2)]);
var inst_26777 = cljs.core.seq(inst_26769__$1);
var inst_26778 = cljs.core.first(inst_26777);
var inst_26779 = cljs.core.next(inst_26777);
var inst_26780 = db;
var inst_26781 = inst_26769__$1;
var inst_26782 = inst_26780;
var state_26917__$1 = (function (){var statearr_26964 = state_26917;
(statearr_26964[(27)] = inst_26769__$1);

(statearr_26964[(22)] = inst_26782);

(statearr_26964[(37)] = inst_26781);

(statearr_26964[(39)] = inst_26778);

(statearr_26964[(40)] = inst_26779);

return statearr_26964;
})();
var statearr_26965_27020 = state_26917__$1;
(statearr_26965_27020[(2)] = null);

(statearr_26965_27020[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (9))){
var inst_26763 = (state_26917[(29)]);
var inst_26746 = (state_26917[(32)]);
var inst_26765 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_26746,inst_26763);
var state_26917__$1 = state_26917;
var statearr_26966_27021 = state_26917__$1;
(statearr_26966_27021[(2)] = inst_26765);

(statearr_26966_27021[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (5))){
var _ = (function (){var statearr_26967 = state_26917;
(statearr_26967[(4)] = cljs.core.rest((state_26917[(4)])));

return statearr_26967;
})();
var state_26917__$1 = state_26917;
var ex26963 = (state_26917__$1[(2)]);
var statearr_26968_27022 = state_26917__$1;
(statearr_26968_27022[(5)] = ex26963);


if((ex26963 instanceof Error)){
var statearr_26969_27023 = state_26917__$1;
(statearr_26969_27023[(1)] = (4));

(statearr_26969_27023[(5)] = null);

} else {
throw ex26963;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (14))){
var inst_26782 = (state_26917[(22)]);
var inst_26788 = (state_26917[(38)]);
var inst_26791 = fluree.db.graphdb.add_predicate_to_idx(inst_26782,inst_26788,opts);
var state_26917__$1 = state_26917;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26917__$1,(17),inst_26791);
} else {
if((state_val_26918 === (26))){
var inst_26861 = (state_26917[(15)]);
var inst_26869 = fluree.db.query.schema.schema_map(inst_26861);
var state_26917__$1 = state_26917;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26917__$1,(29),inst_26869);
} else {
if((state_val_26918 === (16))){
var inst_26798 = (state_26917[(2)]);
var state_26917__$1 = state_26917;
var statearr_26970_27024 = state_26917__$1;
(statearr_26970_27024[(2)] = inst_26798);

(statearr_26970_27024[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (38))){
var inst_26842 = (state_26917[(10)]);
var state_26917__$1 = state_26917;
var statearr_26971_27025 = state_26917__$1;
(statearr_26971_27025[(2)] = inst_26842);

(statearr_26971_27025[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (30))){
var inst_26876 = (state_26917[(35)]);
var inst_26879 = fluree.db.query.schema.setting_map(inst_26876);
var state_26917__$1 = state_26917;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26917__$1,(33),inst_26879);
} else {
if((state_val_26918 === (10))){
var inst_26767 = cljs.core.PersistentVector.EMPTY;
var state_26917__$1 = state_26917;
var statearr_26972_27026 = state_26917__$1;
(statearr_26972_27026[(2)] = inst_26767);

(statearr_26972_27026[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (18))){
var inst_26849 = (state_26917[(23)]);
var inst_26838 = (state_26917[(21)]);
var inst_26848 = cljs.core.seq(inst_26838);
var inst_26849__$1 = cljs.core.first(inst_26848);
var inst_26850 = cljs.core.next(inst_26848);
var inst_26851 = cljs.core.not(inst_26849__$1);
var state_26917__$1 = (function (){var statearr_26973 = state_26917;
(statearr_26973[(23)] = inst_26849__$1);

(statearr_26973[(17)] = inst_26850);

return statearr_26973;
})();
if(inst_26851){
var statearr_26974_27027 = state_26917__$1;
(statearr_26974_27027[(1)] = (20));

} else {
var statearr_26975_27028 = state_26917__$1;
(statearr_26975_27028[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (37))){
var inst_26849 = (state_26917[(23)]);
var inst_26842 = (state_26917[(10)]);
var inst_26904 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26842,inst_26849);
var state_26917__$1 = state_26917;
var statearr_26976_27029 = state_26917__$1;
(statearr_26976_27029[(2)] = inst_26904);

(statearr_26976_27029[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26918 === (8))){
var inst_26760 = (state_26917[(7)]);
var inst_26750 = (state_26917[(25)]);
var inst_26754 = (state_26917[(26)]);
var inst_26729 = (state_26917[(28)]);
var inst_26744 = (state_26917[(30)]);
var inst_26746 = (state_26917[(32)]);
var inst_26744__$1 = (state_26917[(2)]);
var inst_26745 = (function (){var t = inst_26729;
var _ = inst_26744__$1;
return (function (p1__26717_SHARP_){
return cljs.core.not((function (){var G__26977 = p1__26717_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__26977) : fluree.db.graphdb.exclude_predicates.call(null,G__26977));
})());
});
})();
var inst_26746__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_26745,flakes);
var inst_26747 = cljs.core.PersistentHashSet.EMPTY;
var inst_26748 = (function (){var t = inst_26729;
var _ = inst_26744__$1;
var add_flakes = inst_26746__$1;
return (function (p1__26718_SHARP_){
return p1__26718_SHARP_.p;
});
})();
var inst_26749 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26748,inst_26746__$1);
var inst_26750__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26747,inst_26749);
var inst_26751 = cljs.core.PersistentHashMap.EMPTY;
var inst_26752 = (function (){var t = inst_26729;
var _ = inst_26744__$1;
var add_flakes = inst_26746__$1;
var add_preds = inst_26750__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_26753 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26752,inst_26750__$1);
var inst_26754__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26751,inst_26753);
var inst_26755 = cljs.core.PersistentHashMap.EMPTY;
var inst_26756 = (function (){var t = inst_26729;
var _ = inst_26744__$1;
var add_flakes = inst_26746__$1;
var add_preds = inst_26750__$1;
var idx_QMARK__map = inst_26754__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_26757 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26756,inst_26750__$1);
var inst_26758 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26755,inst_26757);
var inst_26759 = fluree.db.flake.size_bytes(inst_26746__$1);
var inst_26760__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_26746__$1);
var inst_26761 = fluree.db.util.schema.setting_change_QMARK_(inst_26746__$1);
var inst_26762 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26763 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26762,(0));
var state_26917__$1 = (function (){var statearr_26978 = state_26917;
(statearr_26978[(7)] = inst_26760__$1);

(statearr_26978[(24)] = inst_26761);

(statearr_26978[(9)] = inst_26759);

(statearr_26978[(25)] = inst_26750__$1);

(statearr_26978[(26)] = inst_26754__$1);

(statearr_26978[(29)] = inst_26763);

(statearr_26978[(30)] = inst_26744__$1);

(statearr_26978[(32)] = inst_26746__$1);

(statearr_26978[(34)] = inst_26758);

return statearr_26978;
})();
if(cljs.core.truth_(inst_26760__$1)){
var statearr_26979_27030 = state_26917__$1;
(statearr_26979_27030[(1)] = (9));

} else {
var statearr_26980_27031 = state_26917__$1;
(statearr_26980_27031[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2741__auto__ = null;
var fluree$db$graphdb$state_machine__2741__auto____0 = (function (){
var statearr_26981 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26981[(0)] = fluree$db$graphdb$state_machine__2741__auto__);

(statearr_26981[(1)] = (1));

return statearr_26981;
});
var fluree$db$graphdb$state_machine__2741__auto____1 = (function (state_26917){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_26917);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e26982){var ex__2744__auto__ = e26982;
var statearr_26983_27032 = state_26917;
(statearr_26983_27032[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_26917[(4)]))){
var statearr_26984_27033 = state_26917;
(statearr_26984_27033[(1)] = cljs.core.first((state_26917[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27034 = state_26917;
state_26917 = G__27034;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2741__auto__ = function(state_26917){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2741__auto____1.call(this,state_26917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2741__auto____0;
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2741__auto____1;
return fluree$db$graphdb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_26985 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_26985[(6)] = c__2763__auto__);

return statearr_26985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__27036 = arguments.length;
switch (G__27036) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2763__auto___27183 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_27132){
var state_val_27133 = (state_27132[(1)]);
if((state_val_27133 === (7))){
var state_27132__$1 = state_27132;
var statearr_27134_27184 = state_27132__$1;
(statearr_27134_27184[(2)] = null);

(statearr_27134_27184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (20))){
var inst_27082 = (state_27132[(7)]);
var inst_27080 = (state_27132[(8)]);
var inst_27081 = (state_27132[(9)]);
var inst_27101 = (inst_27080 + (1));
var inst_27102 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27082,new cljs.core.Keyword(null,"t","t",-1397832519),inst_27101);
var inst_27103 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_27102,inst_27081,opts);
var state_27132__$1 = state_27132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27132__$1,(23),inst_27103);
} else {
if((state_val_27133 === (1))){
var state_27132__$1 = state_27132;
var statearr_27135_27185 = state_27132__$1;
(statearr_27135_27185[(2)] = null);

(statearr_27135_27185[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (24))){
var inst_27106 = (state_27132[(10)]);
var inst_27109 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27106,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_27132__$1 = state_27132;
var statearr_27136_27186 = state_27132__$1;
(statearr_27136_27186[(2)] = inst_27109);

(statearr_27136_27186[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (4))){
var inst_27037 = (state_27132[(2)]);
var inst_27038 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_27037);
var state_27132__$1 = state_27132;
var statearr_27137_27187 = state_27132__$1;
(statearr_27137_27187[(2)] = inst_27038);

(statearr_27137_27187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (15))){
var inst_27088 = (state_27132[(11)]);
var state_27132__$1 = state_27132;
var statearr_27138_27188 = state_27132__$1;
(statearr_27138_27188[(2)] = inst_27088);

(statearr_27138_27188[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (21))){
var state_27132__$1 = state_27132;
var statearr_27139_27189 = state_27132__$1;
(statearr_27139_27189[(2)] = null);

(statearr_27139_27189[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (13))){
var inst_27124 = (state_27132[(2)]);
var inst_27125 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_27124);
var state_27132__$1 = state_27132;
var statearr_27140_27190 = state_27132__$1;
(statearr_27140_27190[(2)] = inst_27125);

(statearr_27140_27190[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (22))){
var inst_27120 = (state_27132[(2)]);
var state_27132__$1 = state_27132;
var statearr_27141_27191 = state_27132__$1;
(statearr_27141_27191[(2)] = inst_27120);

(statearr_27141_27191[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (6))){
var inst_27048 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_27049 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_27050 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27048)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27049)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27051 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27052 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27053 = cljs.core.PersistentHashMap.fromArrays(inst_27051,inst_27052);
var inst_27054 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27050,inst_27053);
var inst_27055 = (function(){throw inst_27054})();
var state_27132__$1 = state_27132;
var statearr_27144_27192 = state_27132__$1;
(statearr_27144_27192[(2)] = inst_27055);

(statearr_27144_27192[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (25))){
var inst_27088 = (state_27132[(11)]);
var inst_27106 = (state_27132[(10)]);
var inst_27089 = (state_27132[(12)]);
var inst_27111 = inst_27088.t;
var inst_27112 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27113 = [inst_27088];
var inst_27114 = (new cljs.core.PersistentVector(null,1,(5),inst_27112,inst_27113,null));
var inst_27079 = inst_27089;
var inst_27080 = inst_27111;
var inst_27081 = inst_27114;
var inst_27082 = inst_27106;
var state_27132__$1 = (function (){var statearr_27145 = state_27132;
(statearr_27145[(7)] = inst_27082);

(statearr_27145[(8)] = inst_27080);

(statearr_27145[(9)] = inst_27081);

(statearr_27145[(13)] = inst_27079);

return statearr_27145;
})();
var statearr_27146_27193 = state_27132__$1;
(statearr_27146_27193[(2)] = null);

(statearr_27146_27193[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (17))){
var inst_27088 = (state_27132[(11)]);
var inst_27082 = (state_27132[(7)]);
var inst_27080 = (state_27132[(8)]);
var inst_27081 = (state_27132[(9)]);
var inst_27089 = (state_27132[(12)]);
var inst_27097 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27081,inst_27088);
var tmp27142 = inst_27082;
var tmp27143 = inst_27080;
var inst_27079 = inst_27089;
var inst_27080__$1 = tmp27143;
var inst_27081__$1 = inst_27097;
var inst_27082__$1 = tmp27142;
var state_27132__$1 = (function (){var statearr_27147 = state_27132;
(statearr_27147[(7)] = inst_27082__$1);

(statearr_27147[(8)] = inst_27080__$1);

(statearr_27147[(9)] = inst_27081__$1);

(statearr_27147[(13)] = inst_27079);

return statearr_27147;
})();
var statearr_27148_27194 = state_27132__$1;
(statearr_27148_27194[(2)] = null);

(statearr_27148_27194[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (3))){
var inst_27130 = (state_27132[(2)]);
var state_27132__$1 = state_27132;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27132__$1,inst_27130);
} else {
if((state_val_27133 === (12))){
var inst_27088 = (state_27132[(11)]);
var inst_27079 = (state_27132[(13)]);
var inst_27087 = cljs.core.seq(inst_27079);
var inst_27088__$1 = cljs.core.first(inst_27087);
var inst_27089 = cljs.core.next(inst_27087);
var state_27132__$1 = (function (){var statearr_27149 = state_27132;
(statearr_27149[(11)] = inst_27088__$1);

(statearr_27149[(12)] = inst_27089);

return statearr_27149;
})();
if(cljs.core.truth_(inst_27088__$1)){
var statearr_27150_27195 = state_27132__$1;
(statearr_27150_27195[(1)] = (14));

} else {
var statearr_27151_27196 = state_27132__$1;
(statearr_27151_27196[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (2))){
var _ = (function (){var statearr_27152 = state_27132;
(statearr_27152[(4)] = cljs.core.cons((5),(state_27132[(4)])));

return statearr_27152;
})();
var inst_27044 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_27045 = (inst_27044 + (1));
var inst_27046 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_27045);
var state_27132__$1 = state_27132;
if(inst_27046){
var statearr_27153_27197 = state_27132__$1;
(statearr_27153_27197[(1)] = (6));

} else {
var statearr_27154_27198 = state_27132__$1;
(statearr_27154_27198[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (23))){
var inst_27088 = (state_27132[(11)]);
var inst_27105 = (state_27132[(2)]);
var inst_27106 = fluree.db.util.async.throw_err(inst_27105);
var inst_27107 = (inst_27088 == null);
var state_27132__$1 = (function (){var statearr_27155 = state_27132;
(statearr_27155[(10)] = inst_27106);

return statearr_27155;
})();
if(cljs.core.truth_(inst_27107)){
var statearr_27156_27199 = state_27132__$1;
(statearr_27156_27199[(1)] = (24));

} else {
var statearr_27157_27200 = state_27132__$1;
(statearr_27157_27200[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (19))){
var inst_27122 = (state_27132[(2)]);
var state_27132__$1 = state_27132;
var statearr_27158_27201 = state_27132__$1;
(statearr_27158_27201[(2)] = inst_27122);

(statearr_27158_27201[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (11))){
var inst_27127 = (state_27132[(2)]);
var _ = (function (){var statearr_27160 = state_27132;
(statearr_27160[(4)] = cljs.core.rest((state_27132[(4)])));

return statearr_27160;
})();
var state_27132__$1 = state_27132;
var statearr_27161_27202 = state_27132__$1;
(statearr_27161_27202[(2)] = inst_27127);

(statearr_27161_27202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (9))){
var inst_27061 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_27062 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_27061);
var state_27132__$1 = state_27132;
var statearr_27162_27203 = state_27132__$1;
(statearr_27162_27203[(2)] = inst_27062);

(statearr_27162_27203[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (5))){
var _ = (function (){var statearr_27163 = state_27132;
(statearr_27163[(4)] = cljs.core.rest((state_27132[(4)])));

return statearr_27163;
})();
var state_27132__$1 = state_27132;
var ex27159 = (state_27132__$1[(2)]);
var statearr_27164_27204 = state_27132__$1;
(statearr_27164_27204[(5)] = ex27159);


var statearr_27165_27205 = state_27132__$1;
(statearr_27165_27205[(1)] = (4));

(statearr_27165_27205[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (14))){
var inst_27088 = (state_27132[(11)]);
var inst_27080 = (state_27132[(8)]);
var inst_27091 = inst_27088.t;
var inst_27092 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_27080,inst_27091);
var state_27132__$1 = state_27132;
var statearr_27166_27206 = state_27132__$1;
(statearr_27166_27206[(2)] = inst_27092);

(statearr_27166_27206[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (26))){
var inst_27117 = (state_27132[(2)]);
var state_27132__$1 = state_27132;
var statearr_27167_27207 = state_27132__$1;
(statearr_27167_27207[(2)] = inst_27117);

(statearr_27167_27207[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (16))){
var inst_27095 = (state_27132[(2)]);
var state_27132__$1 = state_27132;
if(cljs.core.truth_(inst_27095)){
var statearr_27168_27208 = state_27132__$1;
(statearr_27168_27208[(1)] = (17));

} else {
var statearr_27169_27209 = state_27132__$1;
(statearr_27169_27209[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (10))){
var inst_27064 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_27065 = cljs.core.first(inst_27064);
var inst_27073 = cljs.core.seq(inst_27064);
var inst_27074 = cljs.core.first(inst_27073);
var inst_27075 = cljs.core.next(inst_27073);
var inst_27076 = inst_27065.t;
var inst_27077 = cljs.core.PersistentVector.EMPTY;
var inst_27078 = db;
var inst_27079 = inst_27064;
var inst_27080 = inst_27076;
var inst_27081 = inst_27077;
var inst_27082 = inst_27078;
var state_27132__$1 = (function (){var statearr_27170 = state_27132;
(statearr_27170[(14)] = inst_27075);

(statearr_27170[(7)] = inst_27082);

(statearr_27170[(8)] = inst_27080);

(statearr_27170[(15)] = inst_27074);

(statearr_27170[(9)] = inst_27081);

(statearr_27170[(13)] = inst_27079);

return statearr_27170;
})();
var statearr_27171_27210 = state_27132__$1;
(statearr_27171_27210[(2)] = null);

(statearr_27171_27210[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (18))){
var state_27132__$1 = state_27132;
var statearr_27172_27211 = state_27132__$1;
(statearr_27172_27211[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27133 === (8))){
var inst_27058 = (state_27132[(2)]);
var inst_27059 = cljs.core.empty_QMARK_(flakes);
var state_27132__$1 = (function (){var statearr_27174 = state_27132;
(statearr_27174[(16)] = inst_27058);

return statearr_27174;
})();
if(inst_27059){
var statearr_27175_27212 = state_27132__$1;
(statearr_27175_27212[(1)] = (9));

} else {
var statearr_27176_27213 = state_27132__$1;
(statearr_27176_27213[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2741__auto__ = null;
var fluree$db$graphdb$state_machine__2741__auto____0 = (function (){
var statearr_27177 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27177[(0)] = fluree$db$graphdb$state_machine__2741__auto__);

(statearr_27177[(1)] = (1));

return statearr_27177;
});
var fluree$db$graphdb$state_machine__2741__auto____1 = (function (state_27132){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_27132);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e27178){var ex__2744__auto__ = e27178;
var statearr_27179_27214 = state_27132;
(statearr_27179_27214[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_27132[(4)]))){
var statearr_27180_27215 = state_27132;
(statearr_27180_27215[(1)] = cljs.core.first((state_27132[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27216 = state_27132;
state_27132 = G__27216;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2741__auto__ = function(state_27132){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2741__auto____1.call(this,state_27132);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2741__auto____0;
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2741__auto____1;
return fluree$db$graphdb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_27181 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_27181[(6)] = c__2763__auto___27183);

return statearr_27181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_27272){
var state_val_27273 = (state_27272[(1)]);
if((state_val_27273 === (7))){
var state_27272__$1 = state_27272;
var statearr_27274_27301 = state_27272__$1;
(statearr_27274_27301[(2)] = tt_id);

(statearr_27274_27301[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (1))){
var state_27272__$1 = state_27272;
var statearr_27275_27302 = state_27272__$1;
(statearr_27275_27302[(2)] = null);

(statearr_27275_27302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (4))){
var inst_27217 = (state_27272[(2)]);
var state_27272__$1 = state_27272;
var statearr_27276_27303 = state_27272__$1;
(statearr_27276_27303[(2)] = inst_27217);

(statearr_27276_27303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (13))){
var inst_27265 = (state_27272[(2)]);
var state_27272__$1 = state_27272;
var statearr_27277_27304 = state_27272__$1;
(statearr_27277_27304[(2)] = inst_27265);

(statearr_27277_27304[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (6))){
var inst_27225 = fluree.db.util.core.random_uuid();
var state_27272__$1 = state_27272;
var statearr_27278_27305 = state_27272__$1;
(statearr_27278_27305[(2)] = inst_27225);

(statearr_27278_27305[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (3))){
var inst_27270 = (state_27272[(2)]);
var state_27272__$1 = state_27272;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27272__$1,inst_27270);
} else {
if((state_val_27273 === (12))){
var inst_27248 = (state_27272[(7)]);
var state_27272__$1 = state_27272;
var statearr_27279_27306 = state_27272__$1;
(statearr_27279_27306[(2)] = inst_27248);

(statearr_27279_27306[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (2))){
var _ = (function (){var statearr_27280 = state_27272;
(statearr_27280[(4)] = cljs.core.cons((5),(state_27272[(4)])));

return statearr_27280;
})();
var inst_27223 = (tt_id == null);
var state_27272__$1 = state_27272;
if(cljs.core.truth_(inst_27223)){
var statearr_27281_27307 = state_27272__$1;
(statearr_27281_27307[(1)] = (6));

} else {
var statearr_27282_27308 = state_27272__$1;
(statearr_27282_27308[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (11))){
var inst_27255 = (state_27272[(8)]);
var inst_27248 = (state_27272[(7)]);
var inst_27258 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_27248,inst_27255);
var state_27272__$1 = state_27272;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27272__$1,(14),inst_27258);
} else {
if((state_val_27273 === (9))){
var inst_27255 = (state_27272[(8)]);
var inst_27249 = (state_27272[(9)]);
var inst_27254 = cljs.core.seq(inst_27249);
var inst_27255__$1 = cljs.core.first(inst_27254);
var inst_27256 = cljs.core.next(inst_27254);
var state_27272__$1 = (function (){var statearr_27284 = state_27272;
(statearr_27284[(8)] = inst_27255__$1);

(statearr_27284[(10)] = inst_27256);

return statearr_27284;
})();
if(cljs.core.truth_(inst_27255__$1)){
var statearr_27285_27309 = state_27272__$1;
(statearr_27285_27309[(1)] = (11));

} else {
var statearr_27286_27310 = state_27272__$1;
(statearr_27286_27310[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (5))){
var _ = (function (){var statearr_27287 = state_27272;
(statearr_27287[(4)] = cljs.core.rest((state_27272[(4)])));

return statearr_27287;
})();
var state_27272__$1 = state_27272;
var ex27283 = (state_27272__$1[(2)]);
var statearr_27288_27311 = state_27272__$1;
(statearr_27288_27311[(5)] = ex27283);


if((ex27283 instanceof Error)){
var statearr_27289_27312 = state_27272__$1;
(statearr_27289_27312[(1)] = (4));

(statearr_27289_27312[(5)] = null);

} else {
throw ex27283;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (14))){
var inst_27256 = (state_27272[(10)]);
var inst_27260 = (state_27272[(2)]);
var inst_27261 = fluree.db.util.async.throw_err(inst_27260);
var inst_27248 = inst_27261;
var inst_27249 = inst_27256;
var state_27272__$1 = (function (){var statearr_27290 = state_27272;
(statearr_27290[(9)] = inst_27249);

(statearr_27290[(7)] = inst_27248);

return statearr_27290;
})();
var statearr_27291_27313 = state_27272__$1;
(statearr_27291_27313[(2)] = null);

(statearr_27291_27313[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (10))){
var inst_27267 = (state_27272[(2)]);
var _ = (function (){var statearr_27292 = state_27272;
(statearr_27292[(4)] = cljs.core.rest((state_27272[(4)])));

return statearr_27292;
})();
var state_27272__$1 = state_27272;
var statearr_27293_27314 = state_27272__$1;
(statearr_27293_27314[(2)] = inst_27267);

(statearr_27293_27314[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (8))){
var inst_27228 = (state_27272[(2)]);
var inst_27229 = (function (){var tt_id_SINGLEQUOTE_ = inst_27228;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_27230 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_27228);
var inst_27231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27232 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_27233 = (new cljs.core.PersistentVector(null,4,(5),inst_27231,inst_27232,null));
var inst_27234 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_27229,inst_27230,inst_27233);
var inst_27235 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_27236 = cljs.core.reverse(inst_27235);
var inst_27237 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_27236);
var inst_27245 = cljs.core.seq(inst_27237);
var inst_27246 = cljs.core.first(inst_27245);
var inst_27247 = cljs.core.next(inst_27245);
var inst_27248 = inst_27234;
var inst_27249 = inst_27237;
var state_27272__$1 = (function (){var statearr_27294 = state_27272;
(statearr_27294[(9)] = inst_27249);

(statearr_27294[(7)] = inst_27248);

(statearr_27294[(11)] = inst_27246);

(statearr_27294[(12)] = inst_27247);

return statearr_27294;
})();
var statearr_27295_27315 = state_27272__$1;
(statearr_27295_27315[(2)] = null);

(statearr_27295_27315[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto____0 = (function (){
var statearr_27296 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27296[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto__);

(statearr_27296[(1)] = (1));

return statearr_27296;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto____1 = (function (state_27272){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_27272);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e27297){var ex__2744__auto__ = e27297;
var statearr_27298_27316 = state_27272;
(statearr_27298_27316[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_27272[(4)]))){
var statearr_27299_27317 = state_27272;
(statearr_27299_27317[(1)] = cljs.core.first((state_27272[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27318 = state_27272;
state_27272 = G__27318;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto__ = function(state_27272){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto____1.call(this,state_27272);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_27300 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_27300[(6)] = c__2763__auto__);

return statearr_27300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2763__auto___27505 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_27436){
var state_val_27437 = (state_27436[(1)]);
if((state_val_27437 === (7))){
var inst_27346 = (state_27436[(7)]);
var inst_27346__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_27436__$1 = (function (){var statearr_27438 = state_27436;
(statearr_27438[(7)] = inst_27346__$1);

return statearr_27438;
})();
if(inst_27346__$1){
var statearr_27439_27506 = state_27436__$1;
(statearr_27439_27506[(1)] = (13));

} else {
var statearr_27440_27507 = state_27436__$1;
(statearr_27440_27507[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (20))){
var state_27436__$1 = state_27436;
var statearr_27441_27508 = state_27436__$1;
(statearr_27441_27508[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (27))){
var inst_27382 = (state_27436[(8)]);
var inst_27386 = inst_27382.s;
var state_27436__$1 = state_27436;
var statearr_27443_27509 = state_27436__$1;
(statearr_27443_27509[(2)] = inst_27386);

(statearr_27443_27509[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (1))){
var state_27436__$1 = state_27436;
var statearr_27444_27510 = state_27436__$1;
(statearr_27444_27510[(2)] = null);

(statearr_27444_27510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (24))){
var inst_27376 = (state_27436[(9)]);
var inst_27380 = cljs.core.first(inst_27376);
var state_27436__$1 = state_27436;
var statearr_27445_27511 = state_27436__$1;
(statearr_27445_27511[(2)] = inst_27380);

(statearr_27445_27511[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (39))){
var state_27436__$1 = state_27436;
var statearr_27446_27512 = state_27436__$1;
(statearr_27446_27512[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (4))){
var inst_27319 = (state_27436[(2)]);
var inst_27320 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27321 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27322 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27323 = cljs.core.PersistentHashMap.fromArrays(inst_27321,inst_27322);
var inst_27324 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_27320,inst_27323,inst_27319);
var inst_27325 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27324);
var state_27436__$1 = state_27436;
var statearr_27448_27513 = state_27436__$1;
(statearr_27448_27513[(2)] = inst_27325);

(statearr_27448_27513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (15))){
var inst_27353 = (state_27436[(2)]);
var state_27436__$1 = state_27436;
if(cljs.core.truth_(inst_27353)){
var statearr_27449_27514 = state_27436__$1;
(statearr_27449_27514[(1)] = (16));

} else {
var statearr_27450_27515 = state_27436__$1;
(statearr_27450_27515[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (21))){
var inst_27402 = (state_27436[(2)]);
var state_27436__$1 = state_27436;
var statearr_27451_27516 = state_27436__$1;
(statearr_27451_27516[(2)] = inst_27402);

(statearr_27451_27516[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (31))){
var inst_27400 = (state_27436[(2)]);
var state_27436__$1 = state_27436;
var statearr_27452_27517 = state_27436__$1;
(statearr_27452_27517[(2)] = inst_27400);

(statearr_27452_27517[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (32))){
var inst_27406 = (state_27436[(10)]);
var inst_27408 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27406);
var state_27436__$1 = state_27436;
var statearr_27453_27518 = state_27436__$1;
(statearr_27453_27518[(2)] = inst_27408);

(statearr_27453_27518[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (40))){
var inst_27429 = (state_27436[(2)]);
var state_27436__$1 = state_27436;
var statearr_27454_27519 = state_27436__$1;
(statearr_27454_27519[(2)] = inst_27429);

(statearr_27454_27519[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (33))){
var inst_27410 = (state_27436[(11)]);
var inst_27406 = (state_27436[(10)]);
var inst_27410__$1 = (inst_27406 == null);
var state_27436__$1 = (function (){var statearr_27455 = state_27436;
(statearr_27455[(11)] = inst_27410__$1);

return statearr_27455;
})();
if(cljs.core.truth_(inst_27410__$1)){
var statearr_27456_27520 = state_27436__$1;
(statearr_27456_27520[(1)] = (35));

} else {
var statearr_27457_27521 = state_27436__$1;
(statearr_27457_27521[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (13))){
var inst_27348 = cljs.core.first(ident);
var inst_27349 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27348);
var inst_27350 = (inst_27349 == null);
var state_27436__$1 = state_27436;
var statearr_27458_27522 = state_27436__$1;
(statearr_27458_27522[(2)] = inst_27350);

(statearr_27458_27522[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (22))){
var inst_27376 = (state_27436[(9)]);
var inst_27375 = (state_27436[(2)]);
var inst_27376__$1 = fluree.db.util.async.throw_err(inst_27375);
var inst_27377 = (inst_27376__$1 == null);
var state_27436__$1 = (function (){var statearr_27459 = state_27436;
(statearr_27459[(9)] = inst_27376__$1);

return statearr_27459;
})();
if(cljs.core.truth_(inst_27377)){
var statearr_27460_27523 = state_27436__$1;
(statearr_27460_27523[(1)] = (23));

} else {
var statearr_27461_27524 = state_27436__$1;
(statearr_27461_27524[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (36))){
var inst_27410 = (state_27436[(11)]);
var state_27436__$1 = state_27436;
var statearr_27462_27525 = state_27436__$1;
(statearr_27462_27525[(2)] = inst_27410);

(statearr_27462_27525[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (41))){
var inst_27424 = cljs.core.async.close_BANG_(return_chan);
var state_27436__$1 = state_27436;
var statearr_27463_27526 = state_27436__$1;
(statearr_27463_27526[(2)] = inst_27424);

(statearr_27463_27526[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (43))){
var inst_27427 = (state_27436[(2)]);
var state_27436__$1 = state_27436;
var statearr_27464_27527 = state_27436__$1;
(statearr_27464_27527[(2)] = inst_27427);

(statearr_27464_27527[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (29))){
var inst_27391 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_27392 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_27391].join('');
var inst_27393 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27394 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27395 = cljs.core.PersistentHashMap.fromArrays(inst_27393,inst_27394);
var inst_27396 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27392,inst_27395);
var inst_27397 = (function(){throw inst_27396})();
var state_27436__$1 = state_27436;
var statearr_27465_27528 = state_27436__$1;
(statearr_27465_27528[(2)] = inst_27397);

(statearr_27465_27528[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (6))){
var inst_27333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27334 = [ident];
var inst_27335 = (new cljs.core.PersistentVector(null,1,(5),inst_27333,inst_27334,null));
var inst_27336 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27335);
var state_27436__$1 = state_27436;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27436__$1,(9),inst_27336);
} else {
if((state_val_27437 === (28))){
var inst_27388 = (state_27436[(2)]);
var state_27436__$1 = state_27436;
var statearr_27466_27529 = state_27436__$1;
(statearr_27466_27529[(2)] = inst_27388);

(statearr_27466_27529[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (25))){
var inst_27382 = (state_27436[(8)]);
var inst_27382__$1 = (state_27436[(2)]);
var inst_27383 = (inst_27382__$1 == null);
var state_27436__$1 = (function (){var statearr_27467 = state_27436;
(statearr_27467[(8)] = inst_27382__$1);

return statearr_27467;
})();
if(cljs.core.truth_(inst_27383)){
var statearr_27468_27530 = state_27436__$1;
(statearr_27468_27530[(1)] = (26));

} else {
var statearr_27469_27531 = state_27436__$1;
(statearr_27469_27531[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (34))){
var inst_27431 = (state_27436[(2)]);
var _ = (function (){var statearr_27470 = state_27436;
(statearr_27470[(4)] = cljs.core.rest((state_27436[(4)])));

return statearr_27470;
})();
var state_27436__$1 = state_27436;
var statearr_27471_27532 = state_27436__$1;
(statearr_27471_27532[(2)] = inst_27431);

(statearr_27471_27532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (17))){
var inst_27364 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_27436__$1 = state_27436;
if(inst_27364){
var statearr_27472_27533 = state_27436__$1;
(statearr_27472_27533[(1)] = (19));

} else {
var statearr_27473_27534 = state_27436__$1;
(statearr_27473_27534[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (3))){
var inst_27434 = (state_27436[(2)]);
var state_27436__$1 = state_27436;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27436__$1,inst_27434);
} else {
if((state_val_27437 === (12))){
var inst_27344 = (state_27436[(2)]);
var state_27436__$1 = state_27436;
var statearr_27474_27535 = state_27436__$1;
(statearr_27474_27535[(2)] = inst_27344);

(statearr_27474_27535[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (2))){
var _ = (function (){var statearr_27475 = state_27436;
(statearr_27475[(4)] = cljs.core.cons((5),(state_27436[(4)])));

return statearr_27475;
})();
var inst_27331 = typeof ident === 'number';
var state_27436__$1 = state_27436;
if(cljs.core.truth_(inst_27331)){
var statearr_27476_27536 = state_27436__$1;
(statearr_27476_27536[(1)] = (6));

} else {
var statearr_27477_27537 = state_27436__$1;
(statearr_27477_27537[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (23))){
var state_27436__$1 = state_27436;
var statearr_27478_27538 = state_27436__$1;
(statearr_27478_27538[(2)] = null);

(statearr_27478_27538[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (35))){
var state_27436__$1 = state_27436;
var statearr_27479_27539 = state_27436__$1;
(statearr_27479_27539[(2)] = strict_QMARK_);

(statearr_27479_27539[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (19))){
var inst_27367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27368 = cljs.core.first(ident);
var inst_27369 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27368);
var inst_27370 = cljs.core.second(ident);
var inst_27371 = [inst_27369,inst_27370];
var inst_27372 = (new cljs.core.PersistentVector(null,2,(5),inst_27367,inst_27371,null));
var inst_27373 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27372);
var state_27436__$1 = state_27436;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27436__$1,(22),inst_27373);
} else {
if((state_val_27437 === (11))){
var state_27436__$1 = state_27436;
var statearr_27481_27540 = state_27436__$1;
(statearr_27481_27540[(2)] = null);

(statearr_27481_27540[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (9))){
var inst_27338 = (state_27436[(2)]);
var inst_27339 = fluree.db.util.async.throw_err(inst_27338);
var inst_27340 = cljs.core.not_empty(inst_27339);
var state_27436__$1 = state_27436;
if(cljs.core.truth_(inst_27340)){
var statearr_27482_27541 = state_27436__$1;
(statearr_27482_27541[(1)] = (10));

} else {
var statearr_27483_27542 = state_27436__$1;
(statearr_27483_27542[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (5))){
var _ = (function (){var statearr_27484 = state_27436;
(statearr_27484[(4)] = cljs.core.rest((state_27436[(4)])));

return statearr_27484;
})();
var state_27436__$1 = state_27436;
var ex27480 = (state_27436__$1[(2)]);
var statearr_27485_27543 = state_27436__$1;
(statearr_27485_27543[(5)] = ex27480);


var statearr_27486_27544 = state_27436__$1;
(statearr_27486_27544[(1)] = (4));

(statearr_27486_27544[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (14))){
var inst_27346 = (state_27436[(7)]);
var state_27436__$1 = state_27436;
var statearr_27487_27545 = state_27436__$1;
(statearr_27487_27545[(2)] = inst_27346);

(statearr_27487_27545[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (26))){
var state_27436__$1 = state_27436;
var statearr_27488_27546 = state_27436__$1;
(statearr_27488_27546[(2)] = null);

(statearr_27488_27546[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (16))){
var inst_27355 = cljs.core.first(ident);
var inst_27356 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27355], 0));
var inst_27357 = ["Subject ID lookup failed. The predicate ",inst_27356," does not exist."].join('');
var inst_27358 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27359 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27360 = cljs.core.PersistentHashMap.fromArrays(inst_27358,inst_27359);
var inst_27361 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27357,inst_27360);
var inst_27362 = (function(){throw inst_27361})();
var state_27436__$1 = state_27436;
var statearr_27489_27547 = state_27436__$1;
(statearr_27489_27547[(2)] = inst_27362);

(statearr_27489_27547[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (38))){
var inst_27416 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27417 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27418 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27419 = cljs.core.PersistentHashMap.fromArrays(inst_27417,inst_27418);
var inst_27420 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27416,inst_27419);
var inst_27421 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27420);
var state_27436__$1 = state_27436;
var statearr_27490_27548 = state_27436__$1;
(statearr_27490_27548[(2)] = inst_27421);

(statearr_27490_27548[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (30))){
var state_27436__$1 = state_27436;
var statearr_27491_27549 = state_27436__$1;
(statearr_27491_27549[(2)] = null);

(statearr_27491_27549[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (10))){
var state_27436__$1 = state_27436;
var statearr_27492_27550 = state_27436__$1;
(statearr_27492_27550[(2)] = ident);

(statearr_27492_27550[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (18))){
var inst_27404 = (state_27436[(2)]);
var state_27436__$1 = state_27436;
var statearr_27493_27551 = state_27436__$1;
(statearr_27493_27551[(2)] = inst_27404);

(statearr_27493_27551[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (42))){
var state_27436__$1 = state_27436;
var statearr_27494_27552 = state_27436__$1;
(statearr_27494_27552[(2)] = null);

(statearr_27494_27552[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (37))){
var inst_27414 = (state_27436[(2)]);
var state_27436__$1 = state_27436;
if(cljs.core.truth_(inst_27414)){
var statearr_27495_27553 = state_27436__$1;
(statearr_27495_27553[(1)] = (38));

} else {
var statearr_27496_27554 = state_27436__$1;
(statearr_27496_27554[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27437 === (8))){
var inst_27406 = (state_27436[(10)]);
var inst_27406__$1 = (state_27436[(2)]);
var state_27436__$1 = (function (){var statearr_27497 = state_27436;
(statearr_27497[(10)] = inst_27406__$1);

return statearr_27497;
})();
if(cljs.core.truth_(inst_27406__$1)){
var statearr_27498_27555 = state_27436__$1;
(statearr_27498_27555[(1)] = (32));

} else {
var statearr_27499_27556 = state_27436__$1;
(statearr_27499_27556[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2741__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2741__auto____0 = (function (){
var statearr_27500 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27500[(0)] = fluree$db$graphdb$subid_$_state_machine__2741__auto__);

(statearr_27500[(1)] = (1));

return statearr_27500;
});
var fluree$db$graphdb$subid_$_state_machine__2741__auto____1 = (function (state_27436){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_27436);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e27501){var ex__2744__auto__ = e27501;
var statearr_27502_27557 = state_27436;
(statearr_27502_27557[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_27436[(4)]))){
var statearr_27503_27558 = state_27436;
(statearr_27503_27558[(1)] = cljs.core.first((state_27436[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27559 = state_27436;
state_27436 = G__27559;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2741__auto__ = function(state_27436){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2741__auto____1.call(this,state_27436);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2741__auto____0;
fluree$db$graphdb$subid_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2741__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_27504 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_27504[(6)] = c__2763__auto___27505);

return statearr_27504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__27560){
var map__27561 = p__27560;
var map__27561__$1 = cljs.core.__destructure_map(map__27561);
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27561__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27561__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_27577){
var state_val_27578 = (state_27577[(1)]);
if((state_val_27578 === (1))){
var state_27577__$1 = state_27577;
var statearr_27579_27593 = state_27577__$1;
(statearr_27579_27593[(2)] = null);

(statearr_27579_27593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27578 === (2))){
var _ = (function (){var statearr_27580 = state_27577;
(statearr_27580[(4)] = cljs.core.cons((5),(state_27577[(4)])));

return statearr_27580;
})();
var inst_27568 = (current_db_fn.cljs$core$IFn$_invoke$arity$0 ? current_db_fn.cljs$core$IFn$_invoke$arity$0() : current_db_fn.call(null));
var state_27577__$1 = state_27577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27577__$1,(6),inst_27568);
} else {
if((state_val_27578 === (3))){
var inst_27575 = (state_27577[(2)]);
var state_27577__$1 = state_27577;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27577__$1,inst_27575);
} else {
if((state_val_27578 === (4))){
var inst_27562 = (state_27577[(2)]);
var state_27577__$1 = state_27577;
var statearr_27582_27594 = state_27577__$1;
(statearr_27582_27594[(2)] = inst_27562);

(statearr_27582_27594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27578 === (5))){
var _ = (function (){var statearr_27583 = state_27577;
(statearr_27583[(4)] = cljs.core.rest((state_27577[(4)])));

return statearr_27583;
})();
var state_27577__$1 = state_27577;
var ex27581 = (state_27577__$1[(2)]);
var statearr_27584_27595 = state_27577__$1;
(statearr_27584_27595[(5)] = ex27581);


if((ex27581 instanceof Error)){
var statearr_27585_27596 = state_27577__$1;
(statearr_27585_27596[(1)] = (4));

(statearr_27585_27596[(5)] = null);

} else {
throw ex27581;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27578 === (6))){
var inst_27570 = (state_27577[(2)]);
var inst_27571 = fluree.db.util.async.throw_err(inst_27570);
var inst_27572 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27571,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_27586 = state_27577;
(statearr_27586[(4)] = cljs.core.rest((state_27577[(4)])));

return statearr_27586;
})();
var state_27577__$1 = state_27577;
var statearr_27587_27597 = state_27577__$1;
(statearr_27587_27597[(2)] = inst_27572);

(statearr_27587_27597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto____0 = (function (){
var statearr_27588 = [null,null,null,null,null,null,null];
(statearr_27588[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto__);

(statearr_27588[(1)] = (1));

return statearr_27588;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto____1 = (function (state_27577){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_27577);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e27589){var ex__2744__auto__ = e27589;
var statearr_27590_27598 = state_27577;
(statearr_27590_27598[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_27577[(4)]))){
var statearr_27591_27599 = state_27577;
(statearr_27591_27599[(1)] = cljs.core.first((state_27577[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27600 = state_27577;
state_27577 = G__27600;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto__ = function(state_27577){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto____1.call(this,state_27577);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_27592 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_27592[(6)] = c__2763__auto__);

return statearr_27592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__27601,property,collection){
var map__27602 = p__27601;
var map__27602__$1 = cljs.core.__destructure_map(map__27602);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27602__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__27603 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__27603.cljs$core$IFn$_invoke$arity$1 ? fexpr__27603.cljs$core$IFn$_invoke$arity$1(property) : fexpr__27603.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__27604,property,predicate){
var map__27605 = p__27604;
var map__27605__$1 = cljs.core.__destructure_map(map__27605);
var this$ = map__27605__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27605__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__27606 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__27606.cljs$core$IFn$_invoke$arity$1 ? fexpr__27606.cljs$core$IFn$_invoke$arity$1(property) : fexpr__27606.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__27607 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop(this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__27607);
} else {
return G__27607;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__27609 = arguments.length;
switch (G__27609) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_27641){
var state_val_27642 = (state_27641[(1)]);
if((state_val_27642 === (7))){
var state_27641__$1 = state_27641;
var statearr_27643_27737 = state_27641__$1;
(statearr_27643_27737[(2)] = null);

(statearr_27643_27737[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27642 === (1))){
var state_27641__$1 = state_27641;
var statearr_27644_27738 = state_27641__$1;
(statearr_27644_27738[(2)] = null);

(statearr_27644_27738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27642 === (4))){
var inst_27610 = (state_27641[(2)]);
var state_27641__$1 = state_27641;
var statearr_27645_27739 = state_27641__$1;
(statearr_27645_27739[(2)] = inst_27610);

(statearr_27645_27739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27642 === (6))){
var inst_27624 = (state_27641[(7)]);
var inst_27623 = (state_27641[(2)]);
var inst_27624__$1 = fluree.db.util.async.throw_err(inst_27623);
var inst_27625 = (inst_27624__$1 == null);
var state_27641__$1 = (function (){var statearr_27646 = state_27641;
(statearr_27646[(7)] = inst_27624__$1);

return statearr_27646;
})();
if(cljs.core.truth_(inst_27625)){
var statearr_27647_27740 = state_27641__$1;
(statearr_27647_27740[(1)] = (7));

} else {
var statearr_27648_27741 = state_27641__$1;
(statearr_27648_27741[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27642 === (3))){
var inst_27639 = (state_27641[(2)]);
var state_27641__$1 = state_27641;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27641__$1,inst_27639);
} else {
if((state_val_27642 === (12))){
var inst_27636 = (state_27641[(2)]);
var _ = (function (){var statearr_27649 = state_27641;
(statearr_27649[(4)] = cljs.core.rest((state_27641[(4)])));

return statearr_27649;
})();
var state_27641__$1 = state_27641;
var statearr_27650_27742 = state_27641__$1;
(statearr_27650_27742[(2)] = inst_27636);

(statearr_27650_27742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27642 === (2))){
var _ = (function (){var statearr_27651 = state_27641;
(statearr_27651[(4)] = cljs.core.cons((5),(state_27641[(4)])));

return statearr_27651;
})();
var inst_27617 = fluree.db.dbproto._rootdb(this$);
var inst_27618 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27619 = [tag_id,(30)];
var inst_27620 = (new cljs.core.PersistentVector(null,2,(5),inst_27618,inst_27619,null));
var inst_27621 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_27617,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27620);
var state_27641__$1 = state_27641;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27641__$1,(6),inst_27621);
} else {
if((state_val_27642 === (11))){
var inst_27630 = (state_27641[(8)]);
var inst_27634 = inst_27630.o;
var state_27641__$1 = state_27641;
var statearr_27653_27743 = state_27641__$1;
(statearr_27653_27743[(2)] = inst_27634);

(statearr_27653_27743[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27642 === (9))){
var inst_27630 = (state_27641[(8)]);
var inst_27630__$1 = (state_27641[(2)]);
var inst_27631 = (inst_27630__$1 == null);
var state_27641__$1 = (function (){var statearr_27654 = state_27641;
(statearr_27654[(8)] = inst_27630__$1);

return statearr_27654;
})();
if(cljs.core.truth_(inst_27631)){
var statearr_27655_27744 = state_27641__$1;
(statearr_27655_27744[(1)] = (10));

} else {
var statearr_27656_27745 = state_27641__$1;
(statearr_27656_27745[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27642 === (5))){
var _ = (function (){var statearr_27657 = state_27641;
(statearr_27657[(4)] = cljs.core.rest((state_27641[(4)])));

return statearr_27657;
})();
var state_27641__$1 = state_27641;
var ex27652 = (state_27641__$1[(2)]);
var statearr_27658_27746 = state_27641__$1;
(statearr_27658_27746[(5)] = ex27652);


if((ex27652 instanceof Error)){
var statearr_27659_27747 = state_27641__$1;
(statearr_27659_27747[(1)] = (4));

(statearr_27659_27747[(5)] = null);

} else {
throw ex27652;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27642 === (10))){
var state_27641__$1 = state_27641;
var statearr_27660_27748 = state_27641__$1;
(statearr_27660_27748[(2)] = null);

(statearr_27660_27748[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27642 === (8))){
var inst_27624 = (state_27641[(7)]);
var inst_27628 = cljs.core.first(inst_27624);
var state_27641__$1 = state_27641;
var statearr_27661_27749 = state_27641__$1;
(statearr_27661_27749[(2)] = inst_27628);

(statearr_27661_27749[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2741__auto__ = null;
var fluree$db$graphdb$state_machine__2741__auto____0 = (function (){
var statearr_27662 = [null,null,null,null,null,null,null,null,null];
(statearr_27662[(0)] = fluree$db$graphdb$state_machine__2741__auto__);

(statearr_27662[(1)] = (1));

return statearr_27662;
});
var fluree$db$graphdb$state_machine__2741__auto____1 = (function (state_27641){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_27641);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e27663){var ex__2744__auto__ = e27663;
var statearr_27664_27750 = state_27641;
(statearr_27664_27750[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_27641[(4)]))){
var statearr_27665_27751 = state_27641;
(statearr_27665_27751[(1)] = cljs.core.first((state_27641[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27752 = state_27641;
state_27641 = G__27752;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2741__auto__ = function(state_27641){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2741__auto____1.call(this,state_27641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2741__auto____0;
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2741__auto____1;
return fluree$db$graphdb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_27666 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_27666[(6)] = c__2763__auto__);

return statearr_27666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_27702){
var state_val_27703 = (state_27702[(1)]);
if((state_val_27703 === (7))){
var inst_27676 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27702__$1 = state_27702;
var statearr_27704_27753 = state_27702__$1;
(statearr_27704_27753[(2)] = inst_27676);

(statearr_27704_27753[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27703 === (1))){
var state_27702__$1 = state_27702;
var statearr_27705_27754 = state_27702__$1;
(statearr_27705_27754[(2)] = null);

(statearr_27705_27754[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27703 === (4))){
var inst_27667 = (state_27702[(2)]);
var state_27702__$1 = state_27702;
var statearr_27706_27755 = state_27702__$1;
(statearr_27706_27755[(2)] = inst_27667);

(statearr_27706_27755[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27703 === (15))){
var inst_27697 = (state_27702[(2)]);
var _ = (function (){var statearr_27707 = state_27702;
(statearr_27707[(4)] = cljs.core.rest((state_27702[(4)])));

return statearr_27707;
})();
var state_27702__$1 = state_27702;
var statearr_27708_27756 = state_27702__$1;
(statearr_27708_27756[(2)] = inst_27697);

(statearr_27708_27756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27703 === (13))){
var inst_27682 = (state_27702[(7)]);
var inst_27688 = clojure.string.includes_QMARK_(inst_27682,":");
var state_27702__$1 = state_27702;
if(inst_27688){
var statearr_27709_27757 = state_27702__$1;
(statearr_27709_27757[(1)] = (16));

} else {
var statearr_27710_27758 = state_27702__$1;
(statearr_27710_27758[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27703 === (6))){
var state_27702__$1 = state_27702;
var statearr_27711_27759 = state_27702__$1;
(statearr_27711_27759[(2)] = pred);

(statearr_27711_27759[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27703 === (17))){
var inst_27682 = (state_27702[(7)]);
var state_27702__$1 = state_27702;
var statearr_27712_27760 = state_27702__$1;
(statearr_27712_27760[(2)] = inst_27682);

(statearr_27712_27760[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27703 === (3))){
var inst_27700 = (state_27702[(2)]);
var state_27702__$1 = state_27702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27702__$1,inst_27700);
} else {
if((state_val_27703 === (12))){
var inst_27686 = (state_27702[(2)]);
var state_27702__$1 = state_27702;
if(cljs.core.truth_(inst_27686)){
var statearr_27713_27761 = state_27702__$1;
(statearr_27713_27761[(1)] = (13));

} else {
var statearr_27714_27762 = state_27702__$1;
(statearr_27714_27762[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27703 === (2))){
var _ = (function (){var statearr_27715 = state_27702;
(statearr_27715[(4)] = cljs.core.cons((5),(state_27702[(4)])));

return statearr_27715;
})();
var inst_27673 = typeof pred === 'string';
var state_27702__$1 = state_27702;
if(cljs.core.truth_(inst_27673)){
var statearr_27716_27763 = state_27702__$1;
(statearr_27716_27763[(1)] = (6));

} else {
var statearr_27717_27764 = state_27702__$1;
(statearr_27717_27764[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27703 === (11))){
var inst_27678 = (state_27702[(8)]);
var state_27702__$1 = state_27702;
var statearr_27719_27765 = state_27702__$1;
(statearr_27719_27765[(2)] = inst_27678);

(statearr_27719_27765[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27703 === (9))){
var inst_27678 = (state_27702[(8)]);
var inst_27681 = (state_27702[(2)]);
var inst_27682 = fluree.db.util.async.throw_err(inst_27681);
var state_27702__$1 = (function (){var statearr_27720 = state_27702;
(statearr_27720[(7)] = inst_27682);

return statearr_27720;
})();
if(cljs.core.truth_(inst_27678)){
var statearr_27721_27766 = state_27702__$1;
(statearr_27721_27766[(1)] = (10));

} else {
var statearr_27722_27767 = state_27702__$1;
(statearr_27722_27767[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27703 === (5))){
var _ = (function (){var statearr_27723 = state_27702;
(statearr_27723[(4)] = cljs.core.rest((state_27702[(4)])));

return statearr_27723;
})();
var state_27702__$1 = state_27702;
var ex27718 = (state_27702__$1[(2)]);
var statearr_27724_27768 = state_27702__$1;
(statearr_27724_27768[(5)] = ex27718);


if((ex27718 instanceof Error)){
var statearr_27725_27769 = state_27702__$1;
(statearr_27725_27769[(1)] = (4));

(statearr_27725_27769[(5)] = null);

} else {
throw ex27718;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27703 === (14))){
var state_27702__$1 = state_27702;
var statearr_27726_27770 = state_27702__$1;
(statearr_27726_27770[(2)] = null);

(statearr_27726_27770[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27703 === (16))){
var inst_27682 = (state_27702[(7)]);
var inst_27690 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_27682,/:/);
var inst_27691 = cljs.core.second(inst_27690);
var state_27702__$1 = state_27702;
var statearr_27727_27771 = state_27702__$1;
(statearr_27727_27771[(2)] = inst_27691);

(statearr_27727_27771[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27703 === (10))){
var inst_27682 = (state_27702[(7)]);
var state_27702__$1 = state_27702;
var statearr_27728_27772 = state_27702__$1;
(statearr_27728_27772[(2)] = inst_27682);

(statearr_27728_27772[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27703 === (18))){
var inst_27694 = (state_27702[(2)]);
var state_27702__$1 = state_27702;
var statearr_27729_27773 = state_27702__$1;
(statearr_27729_27773[(2)] = inst_27694);

(statearr_27729_27773[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27703 === (8))){
var inst_27678 = (state_27702[(2)]);
var inst_27679 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_27702__$1 = (function (){var statearr_27730 = state_27702;
(statearr_27730[(8)] = inst_27678);

return statearr_27730;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27702__$1,(9),inst_27679);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2741__auto__ = null;
var fluree$db$graphdb$state_machine__2741__auto____0 = (function (){
var statearr_27731 = [null,null,null,null,null,null,null,null,null];
(statearr_27731[(0)] = fluree$db$graphdb$state_machine__2741__auto__);

(statearr_27731[(1)] = (1));

return statearr_27731;
});
var fluree$db$graphdb$state_machine__2741__auto____1 = (function (state_27702){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_27702);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e27732){var ex__2744__auto__ = e27732;
var statearr_27733_27774 = state_27702;
(statearr_27733_27774[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_27702[(4)]))){
var statearr_27734_27775 = state_27702;
(statearr_27734_27775[(1)] = cljs.core.first((state_27702[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27776 = state_27702;
state_27702 = G__27776;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2741__auto__ = function(state_27702){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2741__auto____1.call(this,state_27702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2741__auto____0;
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2741__auto____1;
return fluree$db$graphdb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_27735 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_27735[(6)] = c__2763__auto__);

return statearr_27735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__27778 = arguments.length;
switch (G__27778) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_27811){
var state_val_27812 = (state_27811[(1)]);
if((state_val_27812 === (7))){
var state_27811__$1 = state_27811;
var statearr_27813_27901 = state_27811__$1;
(statearr_27813_27901[(2)] = null);

(statearr_27813_27901[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27812 === (1))){
var state_27811__$1 = state_27811;
var statearr_27814_27902 = state_27811__$1;
(statearr_27814_27902[(2)] = null);

(statearr_27814_27902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27812 === (4))){
var inst_27779 = (state_27811[(2)]);
var state_27811__$1 = state_27811;
var statearr_27815_27903 = state_27811__$1;
(statearr_27815_27903[(2)] = inst_27779);

(statearr_27815_27903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27812 === (6))){
var inst_27794 = (state_27811[(7)]);
var inst_27793 = (state_27811[(2)]);
var inst_27794__$1 = fluree.db.util.async.throw_err(inst_27793);
var inst_27795 = (inst_27794__$1 == null);
var state_27811__$1 = (function (){var statearr_27816 = state_27811;
(statearr_27816[(7)] = inst_27794__$1);

return statearr_27816;
})();
if(cljs.core.truth_(inst_27795)){
var statearr_27817_27904 = state_27811__$1;
(statearr_27817_27904[(1)] = (7));

} else {
var statearr_27818_27905 = state_27811__$1;
(statearr_27818_27905[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27812 === (3))){
var inst_27809 = (state_27811[(2)]);
var state_27811__$1 = state_27811;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27811__$1,inst_27809);
} else {
if((state_val_27812 === (12))){
var inst_27806 = (state_27811[(2)]);
var _ = (function (){var statearr_27819 = state_27811;
(statearr_27819[(4)] = cljs.core.rest((state_27811[(4)])));

return statearr_27819;
})();
var state_27811__$1 = state_27811;
var statearr_27820_27906 = state_27811__$1;
(statearr_27820_27906[(2)] = inst_27806);

(statearr_27820_27906[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27812 === (2))){
var _ = (function (){var statearr_27821 = state_27811;
(statearr_27821[(4)] = cljs.core.cons((5),(state_27811[(4)])));

return statearr_27821;
})();
var inst_27785 = (30);
var inst_27787 = fluree.db.dbproto._rootdb(this$);
var inst_27788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27789 = [inst_27785,tag_name];
var inst_27790 = (new cljs.core.PersistentVector(null,2,(5),inst_27788,inst_27789,null));
var inst_27791 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_27787,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27790);
var state_27811__$1 = state_27811;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27811__$1,(6),inst_27791);
} else {
if((state_val_27812 === (11))){
var inst_27800 = (state_27811[(8)]);
var inst_27804 = inst_27800.s;
var state_27811__$1 = state_27811;
var statearr_27823_27907 = state_27811__$1;
(statearr_27823_27907[(2)] = inst_27804);

(statearr_27823_27907[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27812 === (9))){
var inst_27800 = (state_27811[(8)]);
var inst_27800__$1 = (state_27811[(2)]);
var inst_27801 = (inst_27800__$1 == null);
var state_27811__$1 = (function (){var statearr_27824 = state_27811;
(statearr_27824[(8)] = inst_27800__$1);

return statearr_27824;
})();
if(cljs.core.truth_(inst_27801)){
var statearr_27825_27908 = state_27811__$1;
(statearr_27825_27908[(1)] = (10));

} else {
var statearr_27826_27909 = state_27811__$1;
(statearr_27826_27909[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27812 === (5))){
var _ = (function (){var statearr_27827 = state_27811;
(statearr_27827[(4)] = cljs.core.rest((state_27811[(4)])));

return statearr_27827;
})();
var state_27811__$1 = state_27811;
var ex27822 = (state_27811__$1[(2)]);
var statearr_27828_27910 = state_27811__$1;
(statearr_27828_27910[(5)] = ex27822);


if((ex27822 instanceof Error)){
var statearr_27829_27911 = state_27811__$1;
(statearr_27829_27911[(1)] = (4));

(statearr_27829_27911[(5)] = null);

} else {
throw ex27822;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27812 === (10))){
var state_27811__$1 = state_27811;
var statearr_27830_27912 = state_27811__$1;
(statearr_27830_27912[(2)] = null);

(statearr_27830_27912[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27812 === (8))){
var inst_27794 = (state_27811[(7)]);
var inst_27798 = cljs.core.first(inst_27794);
var state_27811__$1 = state_27811;
var statearr_27831_27913 = state_27811__$1;
(statearr_27831_27913[(2)] = inst_27798);

(statearr_27831_27913[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2741__auto__ = null;
var fluree$db$graphdb$state_machine__2741__auto____0 = (function (){
var statearr_27832 = [null,null,null,null,null,null,null,null,null];
(statearr_27832[(0)] = fluree$db$graphdb$state_machine__2741__auto__);

(statearr_27832[(1)] = (1));

return statearr_27832;
});
var fluree$db$graphdb$state_machine__2741__auto____1 = (function (state_27811){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_27811);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e27833){var ex__2744__auto__ = e27833;
var statearr_27834_27914 = state_27811;
(statearr_27834_27914[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_27811[(4)]))){
var statearr_27835_27915 = state_27811;
(statearr_27835_27915[(1)] = cljs.core.first((state_27811[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27916 = state_27811;
state_27811 = G__27916;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2741__auto__ = function(state_27811){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2741__auto____1.call(this,state_27811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2741__auto____0;
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2741__auto____1;
return fluree$db$graphdb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_27836 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_27836[(6)] = c__2763__auto__);

return statearr_27836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_27871){
var state_val_27872 = (state_27871[(1)]);
if((state_val_27872 === (7))){
var inst_27850 = typeof pred === 'string';
var state_27871__$1 = state_27871;
if(cljs.core.truth_(inst_27850)){
var statearr_27873_27917 = state_27871__$1;
(statearr_27873_27917[(1)] = (10));

} else {
var statearr_27874_27918 = state_27871__$1;
(statearr_27874_27918[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27872 === (1))){
var state_27871__$1 = state_27871;
var statearr_27875_27919 = state_27871__$1;
(statearr_27875_27919[(2)] = null);

(statearr_27875_27919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27872 === (4))){
var inst_27837 = (state_27871[(2)]);
var state_27871__$1 = state_27871;
var statearr_27876_27920 = state_27871__$1;
(statearr_27876_27920[(2)] = inst_27837);

(statearr_27876_27920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27872 === (15))){
var inst_27864 = (state_27871[(2)]);
var state_27871__$1 = state_27871;
var statearr_27877_27921 = state_27871__$1;
(statearr_27877_27921[(2)] = inst_27864);

(statearr_27877_27921[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27872 === (13))){
var inst_27855 = (state_27871[(7)]);
var inst_27857 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27855),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_27858 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_27857);
var state_27871__$1 = state_27871;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27871__$1,(16),inst_27858);
} else {
if((state_val_27872 === (6))){
var inst_27845 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_27871__$1 = state_27871;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27871__$1,(9),inst_27845);
} else {
if((state_val_27872 === (3))){
var inst_27869 = (state_27871[(2)]);
var state_27871__$1 = state_27871;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27871__$1,inst_27869);
} else {
if((state_val_27872 === (12))){
var inst_27855 = (state_27871[(7)]);
var inst_27855__$1 = (state_27871[(2)]);
var state_27871__$1 = (function (){var statearr_27878 = state_27871;
(statearr_27878[(7)] = inst_27855__$1);

return statearr_27878;
})();
if(cljs.core.truth_(inst_27855__$1)){
var statearr_27879_27922 = state_27871__$1;
(statearr_27879_27922[(1)] = (13));

} else {
var statearr_27880_27923 = state_27871__$1;
(statearr_27880_27923[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27872 === (2))){
var _ = (function (){var statearr_27881 = state_27871;
(statearr_27881[(4)] = cljs.core.cons((5),(state_27871[(4)])));

return statearr_27881;
})();
var inst_27843 = clojure.string.includes_QMARK_(tag_name,"/");
var state_27871__$1 = state_27871;
if(inst_27843){
var statearr_27882_27924 = state_27871__$1;
(statearr_27882_27924[(1)] = (6));

} else {
var statearr_27883_27925 = state_27871__$1;
(statearr_27883_27925[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27872 === (11))){
var inst_27853 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27871__$1 = state_27871;
var statearr_27885_27926 = state_27871__$1;
(statearr_27885_27926[(2)] = inst_27853);

(statearr_27885_27926[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27872 === (9))){
var inst_27847 = (state_27871[(2)]);
var inst_27848 = fluree.db.util.async.throw_err(inst_27847);
var state_27871__$1 = state_27871;
var statearr_27886_27927 = state_27871__$1;
(statearr_27886_27927[(2)] = inst_27848);

(statearr_27886_27927[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27872 === (5))){
var _ = (function (){var statearr_27887 = state_27871;
(statearr_27887[(4)] = cljs.core.rest((state_27871[(4)])));

return statearr_27887;
})();
var state_27871__$1 = state_27871;
var ex27884 = (state_27871__$1[(2)]);
var statearr_27888_27928 = state_27871__$1;
(statearr_27888_27928[(5)] = ex27884);


if((ex27884 instanceof Error)){
var statearr_27889_27929 = state_27871__$1;
(statearr_27889_27929[(1)] = (4));

(statearr_27889_27929[(5)] = null);

} else {
throw ex27884;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27872 === (14))){
var state_27871__$1 = state_27871;
var statearr_27890_27930 = state_27871__$1;
(statearr_27890_27930[(2)] = null);

(statearr_27890_27930[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27872 === (16))){
var inst_27860 = (state_27871[(2)]);
var inst_27861 = fluree.db.util.async.throw_err(inst_27860);
var state_27871__$1 = state_27871;
var statearr_27891_27931 = state_27871__$1;
(statearr_27891_27931[(2)] = inst_27861);

(statearr_27891_27931[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27872 === (10))){
var state_27871__$1 = state_27871;
var statearr_27892_27932 = state_27871__$1;
(statearr_27892_27932[(2)] = pred);

(statearr_27892_27932[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27872 === (8))){
var inst_27866 = (state_27871[(2)]);
var _ = (function (){var statearr_27893 = state_27871;
(statearr_27893[(4)] = cljs.core.rest((state_27871[(4)])));

return statearr_27893;
})();
var state_27871__$1 = state_27871;
var statearr_27894_27933 = state_27871__$1;
(statearr_27894_27933[(2)] = inst_27866);

(statearr_27894_27933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2741__auto__ = null;
var fluree$db$graphdb$state_machine__2741__auto____0 = (function (){
var statearr_27895 = [null,null,null,null,null,null,null,null];
(statearr_27895[(0)] = fluree$db$graphdb$state_machine__2741__auto__);

(statearr_27895[(1)] = (1));

return statearr_27895;
});
var fluree$db$graphdb$state_machine__2741__auto____1 = (function (state_27871){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_27871);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e27896){var ex__2744__auto__ = e27896;
var statearr_27897_27934 = state_27871;
(statearr_27897_27934[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_27871[(4)]))){
var statearr_27898_27935 = state_27871;
(statearr_27898_27935[(1)] = cljs.core.first((state_27871[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27936 = state_27871;
state_27871 = G__27936;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2741__auto__ = function(state_27871){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2741__auto____1.call(this,state_27871);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2741__auto____0;
fluree$db$graphdb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2741__auto____1;
return fluree$db$graphdb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_27899 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_27899[(6)] = c__2763__auto__);

return statearr_27899;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k27938,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__27942 = k27938;
var G__27942__$1 = (((G__27942 instanceof cljs.core.Keyword))?G__27942.fqn:null);
switch (G__27942__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27938,else__4505__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__27943){
var vec__27944 = p__27943;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27944,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27944,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27937){
var self__ = this;
var G__27937__$1 = this;
return (new cljs.core.RecordIter((0),G__27937__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__27947 = (function (coll__4499__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__27947(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27939,other27940){
var self__ = this;
var this27939__$1 = this;
return (((!((other27940 == null)))) && ((((this27939__$1.constructor === other27940.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.conn,other27940.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.network,other27940.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.dbid,other27940.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.block,other27940.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.t,other27940.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.tt_id,other27940.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.stats,other27940.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.spot,other27940.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.psot,other27940.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.post,other27940.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.opst,other27940.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.schema,other27940.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.settings,other27940.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.index_configs,other27940.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.schema_cache,other27940.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.novelty,other27940.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.permissions,other27940.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.fork,other27940.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.fork_block,other27940.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.current_db_fn,other27940.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27939__$1.__extmap,other27940.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k27938){
var self__ = this;
var this__4509__auto____$1 = this;
var G__27948 = k27938;
var G__27948__$1 = (((G__27948 instanceof cljs.core.Keyword))?G__27948.fqn:null);
switch (G__27948__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k27938);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__27937){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__27949 = cljs.core.keyword_identical_QMARK_;
var expr__27950 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__27952 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27953 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27952,G__27953) : pred__27949.call(null,G__27952,G__27953));
})())){
return (new fluree.db.graphdb.GraphDb(G__27937,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27954 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27955 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27954,G__27955) : pred__27949.call(null,G__27954,G__27955));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__27937,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27956 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__27957 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27956,G__27957) : pred__27949.call(null,G__27956,G__27957));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__27937,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27958 = new cljs.core.Keyword(null,"block","block",664686210);
var G__27959 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27958,G__27959) : pred__27949.call(null,G__27958,G__27959));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__27937,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27960 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__27961 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27960,G__27961) : pred__27949.call(null,G__27960,G__27961));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__27937,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27962 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__27963 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27962,G__27963) : pred__27949.call(null,G__27962,G__27963));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__27937,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27964 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__27965 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27964,G__27965) : pred__27949.call(null,G__27964,G__27965));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__27937,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27966 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__27967 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27966,G__27967) : pred__27949.call(null,G__27966,G__27967));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__27937,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27968 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__27969 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27968,G__27969) : pred__27949.call(null,G__27968,G__27969));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__27937,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27970 = new cljs.core.Keyword(null,"post","post",269697687);
var G__27971 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27970,G__27971) : pred__27949.call(null,G__27970,G__27971));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__27937,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27972 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__27973 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27972,G__27973) : pred__27949.call(null,G__27972,G__27973));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__27937,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27974 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__27975 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27974,G__27975) : pred__27949.call(null,G__27974,G__27975));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__27937,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27976 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__27977 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27976,G__27977) : pred__27949.call(null,G__27976,G__27977));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__27937,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27978 = new cljs.core.Keyword(null,"index-configs","index-configs",1053959280);
var G__27979 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27978,G__27979) : pred__27949.call(null,G__27978,G__27979));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__27937,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27980 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27981 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27980,G__27981) : pred__27949.call(null,G__27980,G__27981));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__27937,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27982 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__27983 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27982,G__27983) : pred__27949.call(null,G__27982,G__27983));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__27937,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27984 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__27985 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27984,G__27985) : pred__27949.call(null,G__27984,G__27985));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__27937,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27986 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__27987 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27986,G__27987) : pred__27949.call(null,G__27986,G__27987));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__27937,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27988 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__27989 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27988,G__27989) : pred__27949.call(null,G__27988,G__27989));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__27937,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27990 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__27991 = expr__27950;
return (pred__27949.cljs$core$IFn$_invoke$arity$2 ? pred__27949.cljs$core$IFn$_invoke$arity$2(G__27990,G__27991) : pred__27949.call(null,G__27990,G__27991));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__27937,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__27937),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__27937){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__27937,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__27941){
var extmap__4542__auto__ = (function (){var G__27992 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27941,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__27941)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27992);
} else {
return G__27992;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__27941),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__27941),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
