// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4253__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_12922){
var state_val_12923 = (state_12922[(1)]);
if((state_val_12923 === (7))){
var inst_12917 = (state_12922[(2)]);
var _ = (function (){var statearr_12924 = state_12922;
(statearr_12924[(4)] = cljs.core.rest((state_12922[(4)])));

return statearr_12924;
})();
var state_12922__$1 = state_12922;
var statearr_12925_12947 = state_12922__$1;
(statearr_12925_12947[(2)] = inst_12917);

(statearr_12925_12947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12923 === (1))){
var state_12922__$1 = state_12922;
var statearr_12926_12948 = state_12922__$1;
(statearr_12926_12948[(2)] = null);

(statearr_12926_12948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12923 === (4))){
var inst_12879 = (state_12922[(2)]);
var state_12922__$1 = state_12922;
var statearr_12927_12949 = state_12922__$1;
(statearr_12927_12949[(2)] = inst_12879);

(statearr_12927_12949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12923 === (6))){
var inst_12897 = (state_12922[(7)]);
var inst_12904 = (state_12922[(8)]);
var inst_12903 = cljs.core.seq(inst_12897);
var inst_12904__$1 = cljs.core.first(inst_12903);
var inst_12905 = cljs.core.next(inst_12903);
var inst_12906 = cljs.core.not(inst_12904__$1);
var state_12922__$1 = (function (){var statearr_12928 = state_12922;
(statearr_12928[(8)] = inst_12904__$1);

(statearr_12928[(9)] = inst_12905);

return statearr_12928;
})();
if(inst_12906){
var statearr_12929_12950 = state_12922__$1;
(statearr_12929_12950[(1)] = (8));

} else {
var statearr_12930_12951 = state_12922__$1;
(statearr_12930_12951[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12923 === (3))){
var inst_12920 = (state_12922[(2)]);
var state_12922__$1 = state_12922;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12922__$1,inst_12920);
} else {
if((state_val_12923 === (2))){
var _ = (function (){var statearr_12931 = state_12922;
(statearr_12931[(4)] = cljs.core.cons((5),(state_12922[(4)])));

return statearr_12931;
})();
var inst_12892 = chs;
var inst_12893 = cljs.core.seq(inst_12892);
var inst_12894 = cljs.core.first(inst_12893);
var inst_12895 = cljs.core.next(inst_12893);
var inst_12896 = coll;
var inst_12897 = inst_12892;
var inst_12898 = inst_12896;
var state_12922__$1 = (function (){var statearr_12932 = state_12922;
(statearr_12932[(7)] = inst_12897);

(statearr_12932[(10)] = inst_12895);

(statearr_12932[(11)] = inst_12898);

(statearr_12932[(12)] = inst_12894);

return statearr_12932;
})();
var statearr_12933_12952 = state_12922__$1;
(statearr_12933_12952[(2)] = null);

(statearr_12933_12952[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12923 === (11))){
var inst_12898 = (state_12922[(11)]);
var inst_12905 = (state_12922[(9)]);
var inst_12910 = (state_12922[(2)]);
var inst_12911 = fluree.db.util.async.throw_err(inst_12910);
var inst_12912 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_12898,inst_12911);
var inst_12897 = inst_12905;
var inst_12898__$1 = inst_12912;
var state_12922__$1 = (function (){var statearr_12935 = state_12922;
(statearr_12935[(7)] = inst_12897);

(statearr_12935[(11)] = inst_12898__$1);

return statearr_12935;
})();
var statearr_12936_12953 = state_12922__$1;
(statearr_12936_12953[(2)] = null);

(statearr_12936_12953[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12923 === (9))){
var inst_12904 = (state_12922[(8)]);
var state_12922__$1 = state_12922;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12922__$1,(11),inst_12904);
} else {
if((state_val_12923 === (5))){
var _ = (function (){var statearr_12937 = state_12922;
(statearr_12937[(4)] = cljs.core.rest((state_12922[(4)])));

return statearr_12937;
})();
var state_12922__$1 = state_12922;
var ex12934 = (state_12922__$1[(2)]);
var statearr_12938_12954 = state_12922__$1;
(statearr_12938_12954[(5)] = ex12934);


var statearr_12939_12955 = state_12922__$1;
(statearr_12939_12955[(1)] = (4));

(statearr_12939_12955[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12923 === (10))){
var inst_12915 = (state_12922[(2)]);
var state_12922__$1 = state_12922;
var statearr_12940_12956 = state_12922__$1;
(statearr_12940_12956[(2)] = inst_12915);

(statearr_12940_12956[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12923 === (8))){
var inst_12898 = (state_12922[(11)]);
var state_12922__$1 = state_12922;
var statearr_12941_12957 = state_12922__$1;
(statearr_12941_12957[(2)] = inst_12898);

(statearr_12941_12957[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto____0 = (function (){
var statearr_12942 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12942[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto__);

(statearr_12942[(1)] = (1));

return statearr_12942;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto____1 = (function (state_12922){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_12922);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e12943){var ex__2744__auto__ = e12943;
var statearr_12944_12958 = state_12922;
(statearr_12944_12958[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_12922[(4)]))){
var statearr_12945_12959 = state_12922;
(statearr_12945_12959[(1)] = cljs.core.first((state_12922[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12960 = state_12922;
state_12922 = G__12960;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto__ = function(state_12922){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto____1.call(this,state_12922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_12946 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_12946[(6)] = c__2763__auto__);

return statearr_12946;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_12986){
var state_val_12987 = (state_12986[(1)]);
if((state_val_12987 === (7))){
var inst_12981 = (state_12986[(2)]);
var _ = (function (){var statearr_12988 = state_12986;
(statearr_12988[(4)] = cljs.core.rest((state_12986[(4)])));

return statearr_12988;
})();
var state_12986__$1 = state_12986;
var statearr_12989_13011 = state_12986__$1;
(statearr_12989_13011[(2)] = inst_12981);

(statearr_12989_13011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12987 === (1))){
var state_12986__$1 = state_12986;
var statearr_12990_13012 = state_12986__$1;
(statearr_12990_13012[(2)] = null);

(statearr_12990_13012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12987 === (4))){
var inst_12961 = (state_12986[(2)]);
var state_12986__$1 = state_12986;
var statearr_12991_13013 = state_12986__$1;
(statearr_12991_13013[(2)] = inst_12961);

(statearr_12991_13013[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12987 === (6))){
var state_12986__$1 = state_12986;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12986__$1,(8),chan);
} else {
if((state_val_12987 === (3))){
var inst_12984 = (state_12986[(2)]);
var state_12986__$1 = state_12986;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12986__$1,inst_12984);
} else {
if((state_val_12987 === (2))){
var _ = (function (){var statearr_12992 = state_12986;
(statearr_12992[(4)] = cljs.core.cons((5),(state_12986[(4)])));

return statearr_12992;
})();
var inst_12967 = coll;
var inst_12968 = inst_12967;
var state_12986__$1 = (function (){var statearr_12993 = state_12986;
(statearr_12993[(7)] = inst_12968);

return statearr_12993;
})();
var statearr_12994_13014 = state_12986__$1;
(statearr_12994_13014[(2)] = null);

(statearr_12994_13014[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12987 === (11))){
var inst_12979 = (state_12986[(2)]);
var state_12986__$1 = state_12986;
var statearr_12996_13015 = state_12986__$1;
(statearr_12996_13015[(2)] = inst_12979);

(statearr_12996_13015[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12987 === (9))){
var inst_12968 = (state_12986[(7)]);
var state_12986__$1 = state_12986;
var statearr_12997_13016 = state_12986__$1;
(statearr_12997_13016[(2)] = inst_12968);

(statearr_12997_13016[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12987 === (5))){
var _ = (function (){var statearr_12998 = state_12986;
(statearr_12998[(4)] = cljs.core.rest((state_12986[(4)])));

return statearr_12998;
})();
var state_12986__$1 = state_12986;
var ex12995 = (state_12986__$1[(2)]);
var statearr_12999_13017 = state_12986__$1;
(statearr_12999_13017[(5)] = ex12995);


var statearr_13000_13018 = state_12986__$1;
(statearr_13000_13018[(1)] = (4));

(statearr_13000_13018[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12987 === (10))){
var inst_12972 = (state_12986[(8)]);
var inst_12968 = (state_12986[(7)]);
var inst_12976 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_12968,inst_12972);
var inst_12968__$1 = inst_12976;
var state_12986__$1 = (function (){var statearr_13001 = state_12986;
(statearr_13001[(7)] = inst_12968__$1);

return statearr_13001;
})();
var statearr_13002_13019 = state_12986__$1;
(statearr_13002_13019[(2)] = null);

(statearr_13002_13019[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12987 === (8))){
var inst_12972 = (state_12986[(8)]);
var inst_12971 = (state_12986[(2)]);
var inst_12972__$1 = fluree.db.util.async.throw_err(inst_12971);
var inst_12973 = (inst_12972__$1 == null);
var state_12986__$1 = (function (){var statearr_13003 = state_12986;
(statearr_13003[(8)] = inst_12972__$1);

return statearr_13003;
})();
if(cljs.core.truth_(inst_12973)){
var statearr_13004_13020 = state_12986__$1;
(statearr_13004_13020[(1)] = (9));

} else {
var statearr_13005_13021 = state_12986__$1;
(statearr_13005_13021[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2741__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2741__auto____0 = (function (){
var statearr_13006 = [null,null,null,null,null,null,null,null,null];
(statearr_13006[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2741__auto__);

(statearr_13006[(1)] = (1));

return statearr_13006;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2741__auto____1 = (function (state_12986){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_12986);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e13007){var ex__2744__auto__ = e13007;
var statearr_13008_13022 = state_12986;
(statearr_13008_13022[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_12986[(4)]))){
var statearr_13009_13023 = state_12986;
(statearr_13009_13023[(1)] = cljs.core.first((state_12986[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13024 = state_12986;
state_12986 = G__13024;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2741__auto__ = function(state_12986){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2741__auto____1.call(this,state_12986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2741__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2741__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_13010 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_13010[(6)] = c__2763__auto__);

return statearr_13010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
