// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__62567 = arguments.length;
switch (G__62567) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_62609){
var state_val_62610 = (state_62609[(1)]);
if((state_val_62610 === (7))){
var inst_62579 = typeof user === 'string';
var state_62609__$1 = state_62609;
if(cljs.core.truth_(inst_62579)){
var statearr_62611_62640 = state_62609__$1;
(statearr_62611_62640[(1)] = (9));

} else {
var statearr_62612_62641 = state_62609__$1;
(statearr_62612_62641[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62610 === (1))){
var state_62609__$1 = state_62609;
var statearr_62613_62642 = state_62609__$1;
(statearr_62613_62642[(2)] = null);

(statearr_62613_62642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62610 === (4))){
var inst_62568 = (state_62609[(2)]);
var inst_62569 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62568], 0));
var inst_62570 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62568) : reject.call(null,inst_62568));
var state_62609__$1 = (function (){var statearr_62614 = state_62609;
(statearr_62614[(7)] = inst_62569);

return statearr_62614;
})();
var statearr_62615_62643 = state_62609__$1;
(statearr_62615_62643[(2)] = inst_62570);

(statearr_62615_62643[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62610 === (15))){
var inst_62598 = (state_62609[(2)]);
var inst_62599 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_62598);
var inst_62600 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62601 = cljs.core.constantly(inst_62599);
var inst_62602 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62600,inst_62601);
var inst_62603 = fluree.db.connection.add_token(conn,inst_62599);
var inst_62604 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_62598) : resolve.call(null,inst_62598));
var _ = (function (){var statearr_62616 = state_62609;
(statearr_62616[(4)] = cljs.core.rest((state_62609[(4)])));

return statearr_62616;
})();
var state_62609__$1 = (function (){var statearr_62617 = state_62609;
(statearr_62617[(8)] = inst_62603);

(statearr_62617[(9)] = inst_62602);

return statearr_62617;
})();
var statearr_62618_62644 = state_62609__$1;
(statearr_62618_62644[(2)] = inst_62604);

(statearr_62618_62644[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62610 === (13))){
var state_62609__$1 = state_62609;
var statearr_62619_62645 = state_62609__$1;
(statearr_62619_62645[(2)] = null);

(statearr_62619_62645[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62610 === (6))){
var state_62609__$1 = state_62609;
var statearr_62620_62646 = state_62609__$1;
(statearr_62620_62646[(2)] = user);

(statearr_62620_62646[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62610 === (3))){
var inst_62607 = (state_62609[(2)]);
var state_62609__$1 = state_62609;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62609__$1,inst_62607);
} else {
if((state_val_62610 === (12))){
var state_62609__$1 = state_62609;
var statearr_62621_62647 = state_62609__$1;
(statearr_62621_62647[(2)] = user);

(statearr_62621_62647[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62610 === (2))){
var _ = (function (){var statearr_62622 = state_62609;
(statearr_62622[(4)] = cljs.core.cons((5),(state_62609[(4)])));

return statearr_62622;
})();
var inst_62576 = typeof user === 'number';
var state_62609__$1 = state_62609;
if(cljs.core.truth_(inst_62576)){
var statearr_62623_62648 = state_62609__$1;
(statearr_62623_62648[(1)] = (6));

} else {
var statearr_62624_62649 = state_62609__$1;
(statearr_62624_62649[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62610 === (11))){
var inst_62590 = (state_62609[(2)]);
var state_62609__$1 = state_62609;
var statearr_62626_62650 = state_62609__$1;
(statearr_62626_62650[(2)] = inst_62590);

(statearr_62626_62650[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62610 === (9))){
var inst_62581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62582 = ["_user/username",user];
var inst_62583 = (new cljs.core.PersistentVector(null,2,(5),inst_62581,inst_62582,null));
var state_62609__$1 = state_62609;
var statearr_62627_62651 = state_62609__$1;
(statearr_62627_62651[(2)] = inst_62583);

(statearr_62627_62651[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62610 === (5))){
var _ = (function (){var statearr_62628 = state_62609;
(statearr_62628[(4)] = cljs.core.rest((state_62609[(4)])));

return statearr_62628;
})();
var state_62609__$1 = state_62609;
var ex62625 = (state_62609__$1[(2)]);
var statearr_62629_62652 = state_62609__$1;
(statearr_62629_62652[(5)] = ex62625);


var statearr_62630_62653 = state_62609__$1;
(statearr_62630_62653[(1)] = (4));

(statearr_62630_62653[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62610 === (14))){
var inst_62588 = (state_62609[(2)]);
var state_62609__$1 = state_62609;
var statearr_62631_62654 = state_62609__$1;
(statearr_62631_62654[(2)] = inst_62588);

(statearr_62631_62654[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62610 === (10))){
var state_62609__$1 = state_62609;
var statearr_62632_62655 = state_62609__$1;
(statearr_62632_62655[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62610 === (8))){
var inst_62592 = (state_62609[(2)]);
var inst_62593 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_62594 = [account,inst_62592,password,expireSeconds,syncTo];
var inst_62595 = cljs.core.PersistentHashMap.fromArrays(inst_62593,inst_62594);
var inst_62596 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_62595);
var state_62609__$1 = state_62609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62609__$1,(15),inst_62596);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_62634 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62634[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_62634[(1)] = (1));

return statearr_62634;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_62609){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62609);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e62635){var ex__2730__auto__ = e62635;
var statearr_62636_62656 = state_62609;
(statearr_62636_62656[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62609[(4)]))){
var statearr_62637_62657 = state_62609;
(statearr_62637_62657[(1)] = cljs.core.first((state_62609[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62658 = state_62609;
state_62609 = G__62658;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_62609){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_62609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_62638 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_62638[(6)] = c__2749__auto__);

return statearr_62638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__62660 = arguments.length;
switch (G__62660) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_62669){
var state_val_62670 = (state_62669[(1)]);
if((state_val_62670 === (1))){
var inst_62661 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62662 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62663 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_62664 = (new cljs.core.PersistentVector(null,4,(5),inst_62662,inst_62663,null));
var inst_62665 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62661,inst_62664);
var inst_62666 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__62671 = cljs.core.seq(cljs.core.keys(x));
var chunk__62672 = null;
var count__62673 = (0);
var i__62674 = (0);
while(true){
if((i__62674 < count__62673)){
var k = chunk__62672.cljs$core$IIndexed$_nth$arity$2(null,i__62674);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__62682 = seq__62671;
var G__62683 = chunk__62672;
var G__62684 = count__62673;
var G__62685 = (i__62674 + (1));
seq__62671 = G__62682;
chunk__62672 = G__62683;
count__62673 = G__62684;
i__62674 = G__62685;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__62671);
if(temp__5753__auto__){
var seq__62671__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__62671__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__62671__$1);
var G__62686 = cljs.core.chunk_rest(seq__62671__$1);
var G__62687 = c__4679__auto__;
var G__62688 = cljs.core.count(c__4679__auto__);
var G__62689 = (0);
seq__62671 = G__62686;
chunk__62672 = G__62687;
count__62673 = G__62688;
i__62674 = G__62689;
continue;
} else {
var k = cljs.core.first(seq__62671__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__62690 = cljs.core.next(seq__62671__$1);
var G__62691 = null;
var G__62692 = (0);
var G__62693 = (0);
seq__62671 = G__62690;
chunk__62672 = G__62691;
count__62673 = G__62692;
i__62674 = G__62693;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_62667 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_62666);
var state_62669__$1 = (function (){var statearr_62675 = state_62669;
(statearr_62675[(7)] = inst_62665);

return statearr_62675;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_62669__$1,inst_62667);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_62676 = [null,null,null,null,null,null,null,null];
(statearr_62676[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_62676[(1)] = (1));

return statearr_62676;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_62669){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62669);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e62677){var ex__2730__auto__ = e62677;
var statearr_62678_62694 = state_62669;
(statearr_62678_62694[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62669[(4)]))){
var statearr_62679_62695 = state_62669;
(statearr_62679_62695[(1)] = cljs.core.first((state_62669[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62696 = state_62669;
state_62669 = G__62696;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_62669){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_62669);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_62680 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_62680[(6)] = c__2749__auto__);

return statearr_62680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__62698 = arguments.length;
switch (G__62698) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_62732){
var state_val_62733 = (state_62732[(1)]);
if((state_val_62733 === (1))){
var state_62732__$1 = state_62732;
var statearr_62734_62755 = state_62732__$1;
(statearr_62734_62755[(2)] = null);

(statearr_62734_62755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62733 === (2))){
var _ = (function (){var statearr_62735 = state_62732;
(statearr_62735[(4)] = cljs.core.cons((5),(state_62732[(4)])));

return statearr_62735;
})();
var inst_62707 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_62708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62709 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_62710 = (new cljs.core.PersistentVector(null,1,(5),inst_62708,inst_62709,null));
var inst_62711 = cljs.core.PersistentHashMap.EMPTY;
var inst_62712 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_62711);
var inst_62713 = cljs.core.assoc_in(inst_62707,inst_62710,inst_62712);
var inst_62714 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62715 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_62716 = (new cljs.core.PersistentVector(null,1,(5),inst_62714,inst_62715,null));
var inst_62717 = cljs.core.PersistentHashMap.EMPTY;
var inst_62718 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_62717);
var inst_62719 = cljs.core.assoc_in(inst_62713,inst_62716,inst_62718);
var inst_62720 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_62721 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_62719);
var inst_62722 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62723 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_62720,null];
var inst_62724 = (new cljs.core.PersistentVector(null,4,(5),inst_62722,inst_62723,null));
var inst_62725 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62721,inst_62724);
var inst_62726 = (function (){var conn = inst_62719;
var pc = inst_62720;
return (function (x){
if((x == null)){
} else {
var seq__62736_62756 = cljs.core.seq(cljs.core.keys(x));
var chunk__62737_62757 = null;
var count__62738_62758 = (0);
var i__62739_62759 = (0);
while(true){
if((i__62739_62759 < count__62738_62758)){
var k_62760 = chunk__62737_62757.cljs$core$IIndexed$_nth$arity$2(null,i__62739_62759);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_62760], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_62760,null));


var G__62761 = seq__62736_62756;
var G__62762 = chunk__62737_62757;
var G__62763 = count__62738_62758;
var G__62764 = (i__62739_62759 + (1));
seq__62736_62756 = G__62761;
chunk__62737_62757 = G__62762;
count__62738_62758 = G__62763;
i__62739_62759 = G__62764;
continue;
} else {
var temp__5753__auto___62765 = cljs.core.seq(seq__62736_62756);
if(temp__5753__auto___62765){
var seq__62736_62766__$1 = temp__5753__auto___62765;
if(cljs.core.chunked_seq_QMARK_(seq__62736_62766__$1)){
var c__4679__auto___62767 = cljs.core.chunk_first(seq__62736_62766__$1);
var G__62768 = cljs.core.chunk_rest(seq__62736_62766__$1);
var G__62769 = c__4679__auto___62767;
var G__62770 = cljs.core.count(c__4679__auto___62767);
var G__62771 = (0);
seq__62736_62756 = G__62768;
chunk__62737_62757 = G__62769;
count__62738_62758 = G__62770;
i__62739_62759 = G__62771;
continue;
} else {
var k_62772 = cljs.core.first(seq__62736_62766__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_62772], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_62772,null));


var G__62773 = cljs.core.next(seq__62736_62766__$1);
var G__62774 = null;
var G__62775 = (0);
var G__62776 = (0);
seq__62736_62756 = G__62773;
chunk__62737_62757 = G__62774;
count__62738_62758 = G__62775;
i__62739_62759 = G__62776;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_62727 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62720,inst_62726);
var ___$1 = (function (){var statearr_62740 = state_62732;
(statearr_62740[(4)] = cljs.core.rest((state_62732[(4)])));

return statearr_62740;
})();
var state_62732__$1 = (function (){var statearr_62741 = state_62732;
(statearr_62741[(7)] = inst_62725);

return statearr_62741;
})();
var statearr_62742_62777 = state_62732__$1;
(statearr_62742_62777[(2)] = inst_62727);

(statearr_62742_62777[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62733 === (3))){
var inst_62730 = (state_62732[(2)]);
var state_62732__$1 = state_62732;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62732__$1,inst_62730);
} else {
if((state_val_62733 === (4))){
var inst_62699 = (state_62732[(2)]);
var inst_62700 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62699], 0));
var inst_62701 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62699) : reject.call(null,inst_62699));
var state_62732__$1 = (function (){var statearr_62744 = state_62732;
(statearr_62744[(8)] = inst_62700);

return statearr_62744;
})();
var statearr_62745_62778 = state_62732__$1;
(statearr_62745_62778[(2)] = inst_62701);

(statearr_62745_62778[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62733 === (5))){
var _ = (function (){var statearr_62746 = state_62732;
(statearr_62746[(4)] = cljs.core.rest((state_62732[(4)])));

return statearr_62746;
})();
var state_62732__$1 = state_62732;
var ex62743 = (state_62732__$1[(2)]);
var statearr_62747_62779 = state_62732__$1;
(statearr_62747_62779[(5)] = ex62743);


var statearr_62748_62780 = state_62732__$1;
(statearr_62748_62780[(1)] = (4));

(statearr_62748_62780[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_62749 = [null,null,null,null,null,null,null,null,null];
(statearr_62749[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_62749[(1)] = (1));

return statearr_62749;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_62732){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62732);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e62750){var ex__2730__auto__ = e62750;
var statearr_62751_62781 = state_62732;
(statearr_62751_62781[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62732[(4)]))){
var statearr_62752_62782 = state_62732;
(statearr_62752_62782[(1)] = cljs.core.first((state_62732[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62783 = state_62732;
state_62732 = G__62783;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_62732){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_62732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_62753 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_62753[(6)] = c__2749__auto__);

return statearr_62753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__62785 = arguments.length;
switch (G__62785) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__62787 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62787,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62787,(1),null);
var cb_STAR_ = (function (header,data){
var G__62790 = cljs.core.clj__GT_js(header);
var G__62791 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__62790,G__62791) : callback.call(null,G__62790,G__62791));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__62792 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62792,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62792,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_62845){
var state_val_62846 = (state_62845[(1)]);
if((state_val_62846 === (7))){
var inst_62806 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62807 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62808 = cljs.core.PersistentHashMap.fromArrays(inst_62806,inst_62807);
var inst_62809 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_62808);
var inst_62810 = (function(){throw inst_62809})();
var state_62845__$1 = state_62845;
var statearr_62847_62879 = state_62845__$1;
(statearr_62847_62879[(2)] = inst_62810);

(statearr_62847_62879[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62846 === (1))){
var state_62845__$1 = state_62845;
var statearr_62848_62880 = state_62845__$1;
(statearr_62848_62880[(2)] = null);

(statearr_62848_62880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62846 === (4))){
var inst_62795 = (state_62845[(2)]);
var inst_62796 = cljs.core.clj__GT_js(inst_62795);
var inst_62797 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62796) : reject.call(null,inst_62796));
var state_62845__$1 = state_62845;
var statearr_62849_62881 = state_62845__$1;
(statearr_62849_62881[(2)] = inst_62797);

(statearr_62849_62881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62846 === (13))){
var inst_62824 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62825 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62826 = cljs.core.PersistentHashMap.fromArrays(inst_62824,inst_62825);
var inst_62827 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_62826);
var inst_62828 = (function(){throw inst_62827})();
var state_62845__$1 = state_62845;
var statearr_62850_62882 = state_62845__$1;
(statearr_62850_62882[(2)] = inst_62828);

(statearr_62850_62882[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62846 === (6))){
var state_62845__$1 = state_62845;
var statearr_62851_62883 = state_62845__$1;
(statearr_62851_62883[(2)] = null);

(statearr_62851_62883[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62846 === (3))){
var inst_62843 = (state_62845[(2)]);
var state_62845__$1 = state_62845;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62845__$1,inst_62843);
} else {
if((state_val_62846 === (12))){
var state_62845__$1 = state_62845;
var statearr_62852_62884 = state_62845__$1;
(statearr_62852_62884[(2)] = null);

(statearr_62852_62884[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62846 === (2))){
var _ = (function (){var statearr_62853 = state_62845;
(statearr_62853[(4)] = cljs.core.cons((5),(state_62845[(4)])));

return statearr_62853;
})();
var inst_62803 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_62845__$1 = state_62845;
if(cljs.core.truth_(inst_62803)){
var statearr_62854_62885 = state_62845__$1;
(statearr_62854_62885[(1)] = (6));

} else {
var statearr_62855_62886 = state_62845__$1;
(statearr_62855_62886[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62846 === (11))){
var inst_62821 = (state_62845[(2)]);
var state_62845__$1 = (function (){var statearr_62857 = state_62845;
(statearr_62857[(7)] = inst_62821);

return statearr_62857;
})();
if(cljs.core.truth_(password)){
var statearr_62858_62887 = state_62845__$1;
(statearr_62858_62887[(1)] = (12));

} else {
var statearr_62859_62888 = state_62845__$1;
(statearr_62859_62888[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62846 === (9))){
var state_62845__$1 = state_62845;
var statearr_62860_62889 = state_62845__$1;
(statearr_62860_62889[(2)] = null);

(statearr_62860_62889[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62846 === (5))){
var _ = (function (){var statearr_62861 = state_62845;
(statearr_62861[(4)] = cljs.core.rest((state_62845[(4)])));

return statearr_62861;
})();
var state_62845__$1 = state_62845;
var ex62856 = (state_62845__$1[(2)]);
var statearr_62862_62890 = state_62845__$1;
(statearr_62862_62890[(5)] = ex62856);


var statearr_62863_62891 = state_62845__$1;
(statearr_62863_62891[(1)] = (4));

(statearr_62863_62891[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62846 === (14))){
var inst_62830 = (state_62845[(2)]);
var inst_62831 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_62832 = fluree.db.util.core.without_nils(inst_62831);
var inst_62833 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_62834 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62836 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_62832,inst_62833,null];
var inst_62837 = (new cljs.core.PersistentVector(null,4,(5),inst_62835,inst_62836,null));
var inst_62838 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62834,inst_62837);
var inst_62839 = (function (){var _ = inst_62830;
var data = inst_62832;
var pc = inst_62833;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__62864 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62864) : reject.call(null,G__62864));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__62865 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62865) : reject.call(null,G__62865));
} else {
var G__62866 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__62866) : resolve.call(null,G__62866));

}
}
});
})();
var inst_62840 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62833,inst_62839);
var _ = (function (){var statearr_62867 = state_62845;
(statearr_62867[(4)] = cljs.core.rest((state_62845[(4)])));

return statearr_62867;
})();
var state_62845__$1 = (function (){var statearr_62868 = state_62845;
(statearr_62868[(8)] = inst_62838);

return statearr_62868;
})();
var statearr_62869_62892 = state_62845__$1;
(statearr_62869_62892[(2)] = inst_62840);

(statearr_62869_62892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62846 === (10))){
var inst_62815 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62816 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62817 = cljs.core.PersistentHashMap.fromArrays(inst_62815,inst_62816);
var inst_62818 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_62817);
var inst_62819 = (function(){throw inst_62818})();
var state_62845__$1 = state_62845;
var statearr_62870_62893 = state_62845__$1;
(statearr_62870_62893[(2)] = inst_62819);

(statearr_62870_62893[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62846 === (8))){
var inst_62812 = (state_62845[(2)]);
var state_62845__$1 = (function (){var statearr_62871 = state_62845;
(statearr_62871[(9)] = inst_62812);

return statearr_62871;
})();
if(cljs.core.truth_(ledger)){
var statearr_62872_62894 = state_62845__$1;
(statearr_62872_62894[(1)] = (9));

} else {
var statearr_62873_62895 = state_62845__$1;
(statearr_62873_62895[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0 = (function (){
var statearr_62874 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62874[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2727__auto__);

(statearr_62874[(1)] = (1));

return statearr_62874;
});
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1 = (function (state_62845){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62845);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e62875){var ex__2730__auto__ = e62875;
var statearr_62876_62896 = state_62845;
(statearr_62876_62896[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62845[(4)]))){
var statearr_62877_62897 = state_62845;
(statearr_62877_62897[(1)] = cljs.core.first((state_62845[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62898 = state_62845;
state_62845 = G__62898;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = function(state_62845){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1.call(this,state_62845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_62878 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_62878[(6)] = c__2749__auto__);

return statearr_62878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__62900 = arguments.length;
switch (G__62900) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_62967){
var state_val_62968 = (state_62967[(1)]);
if((state_val_62968 === (7))){
var inst_62912 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62913 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62914 = cljs.core.PersistentHashMap.fromArrays(inst_62912,inst_62913);
var inst_62915 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_62914);
var inst_62916 = (function(){throw inst_62915})();
var state_62967__$1 = state_62967;
var statearr_62969_63011 = state_62967__$1;
(statearr_62969_63011[(2)] = inst_62916);

(statearr_62969_63011[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (20))){
var inst_62950 = (state_62967[(2)]);
var inst_62951 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_62952 = [ledger,password,user,auth,expire];
var inst_62953 = cljs.core.PersistentHashMap.fromArrays(inst_62951,inst_62952);
var inst_62954 = fluree.db.util.core.without_nils(inst_62953);
var inst_62955 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_62956 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62958 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_62954,inst_62955,null];
var inst_62959 = (new cljs.core.PersistentVector(null,4,(5),inst_62957,inst_62958,null));
var inst_62960 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62956,inst_62959);
var inst_62961 = (function (){var _ = inst_62950;
var data = inst_62954;
var pc = inst_62955;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__62970 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62970) : reject.call(null,G__62970));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__62971 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62971) : reject.call(null,G__62971));
} else {
fluree.db.connection.add_token(conn,result);

var G__62972 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__62972) : resolve.call(null,G__62972));

}
}
});
})();
var inst_62962 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62955,inst_62961);
var _ = (function (){var statearr_62973 = state_62967;
(statearr_62973[(4)] = cljs.core.rest((state_62967[(4)])));

return statearr_62973;
})();
var state_62967__$1 = (function (){var statearr_62974 = state_62967;
(statearr_62974[(7)] = inst_62960);

return statearr_62974;
})();
var statearr_62975_63012 = state_62967__$1;
(statearr_62975_63012[(2)] = inst_62962);

(statearr_62975_63012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (1))){
var state_62967__$1 = state_62967;
var statearr_62976_63013 = state_62967__$1;
(statearr_62976_63013[(2)] = null);

(statearr_62976_63013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (4))){
var inst_62901 = (state_62967[(2)]);
var inst_62902 = cljs.core.clj__GT_js(inst_62901);
var inst_62903 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62902) : reject.call(null,inst_62902));
var state_62967__$1 = state_62967;
var statearr_62977_63014 = state_62967__$1;
(statearr_62977_63014[(2)] = inst_62903);

(statearr_62977_63014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (15))){
var inst_62937 = (state_62967[(8)]);
var state_62967__$1 = state_62967;
var statearr_62978_63015 = state_62967__$1;
(statearr_62978_63015[(2)] = inst_62937);

(statearr_62978_63015[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (13))){
var inst_62930 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62931 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62932 = cljs.core.PersistentHashMap.fromArrays(inst_62930,inst_62931);
var inst_62933 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_62932);
var inst_62934 = (function(){throw inst_62933})();
var state_62967__$1 = state_62967;
var statearr_62979_63016 = state_62967__$1;
(statearr_62979_63016[(2)] = inst_62934);

(statearr_62979_63016[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (6))){
var state_62967__$1 = state_62967;
var statearr_62980_63017 = state_62967__$1;
(statearr_62980_63017[(2)] = null);

(statearr_62980_63017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (17))){
var inst_62941 = (state_62967[(2)]);
var state_62967__$1 = state_62967;
if(cljs.core.truth_(inst_62941)){
var statearr_62981_63018 = state_62967__$1;
(statearr_62981_63018[(1)] = (18));

} else {
var statearr_62982_63019 = state_62967__$1;
(statearr_62982_63019[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (3))){
var inst_62965 = (state_62967[(2)]);
var state_62967__$1 = state_62967;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62967__$1,inst_62965);
} else {
if((state_val_62968 === (12))){
var state_62967__$1 = state_62967;
var statearr_62983_63020 = state_62967__$1;
(statearr_62983_63020[(2)] = null);

(statearr_62983_63020[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (2))){
var _ = (function (){var statearr_62984 = state_62967;
(statearr_62984[(4)] = cljs.core.cons((5),(state_62967[(4)])));

return statearr_62984;
})();
var inst_62909 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_62967__$1 = state_62967;
if(cljs.core.truth_(inst_62909)){
var statearr_62985_63021 = state_62967__$1;
(statearr_62985_63021[(1)] = (6));

} else {
var statearr_62986_63022 = state_62967__$1;
(statearr_62986_63022[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (19))){
var inst_62944 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62945 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62946 = cljs.core.PersistentHashMap.fromArrays(inst_62944,inst_62945);
var inst_62947 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_62946);
var inst_62948 = (function(){throw inst_62947})();
var state_62967__$1 = state_62967;
var statearr_62987_63023 = state_62967__$1;
(statearr_62987_63023[(2)] = inst_62948);

(statearr_62987_63023[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (11))){
var inst_62927 = (state_62967[(2)]);
var state_62967__$1 = (function (){var statearr_62989 = state_62967;
(statearr_62989[(9)] = inst_62927);

return statearr_62989;
})();
if(cljs.core.truth_(password)){
var statearr_62990_63024 = state_62967__$1;
(statearr_62990_63024[(1)] = (12));

} else {
var statearr_62991_63025 = state_62967__$1;
(statearr_62991_63025[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (9))){
var state_62967__$1 = state_62967;
var statearr_62992_63026 = state_62967__$1;
(statearr_62992_63026[(2)] = null);

(statearr_62992_63026[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (5))){
var _ = (function (){var statearr_62993 = state_62967;
(statearr_62993[(4)] = cljs.core.rest((state_62967[(4)])));

return statearr_62993;
})();
var state_62967__$1 = state_62967;
var ex62988 = (state_62967__$1[(2)]);
var statearr_62994_63027 = state_62967__$1;
(statearr_62994_63027[(5)] = ex62988);


var statearr_62995_63028 = state_62967__$1;
(statearr_62995_63028[(1)] = (4));

(statearr_62995_63028[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (14))){
var inst_62937 = (state_62967[(8)]);
var inst_62936 = (state_62967[(2)]);
var inst_62937__$1 = user;
var state_62967__$1 = (function (){var statearr_62996 = state_62967;
(statearr_62996[(8)] = inst_62937__$1);

(statearr_62996[(10)] = inst_62936);

return statearr_62996;
})();
if(cljs.core.truth_(inst_62937__$1)){
var statearr_62997_63029 = state_62967__$1;
(statearr_62997_63029[(1)] = (15));

} else {
var statearr_62998_63030 = state_62967__$1;
(statearr_62998_63030[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (16))){
var state_62967__$1 = state_62967;
var statearr_62999_63031 = state_62967__$1;
(statearr_62999_63031[(2)] = auth);

(statearr_62999_63031[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (10))){
var inst_62921 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62922 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62923 = cljs.core.PersistentHashMap.fromArrays(inst_62921,inst_62922);
var inst_62924 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_62923);
var inst_62925 = (function(){throw inst_62924})();
var state_62967__$1 = state_62967;
var statearr_63000_63032 = state_62967__$1;
(statearr_63000_63032[(2)] = inst_62925);

(statearr_63000_63032[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (18))){
var state_62967__$1 = state_62967;
var statearr_63001_63033 = state_62967__$1;
(statearr_63001_63033[(2)] = null);

(statearr_63001_63033[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62968 === (8))){
var inst_62918 = (state_62967[(2)]);
var state_62967__$1 = (function (){var statearr_63002 = state_62967;
(statearr_63002[(11)] = inst_62918);

return statearr_63002;
})();
if(cljs.core.truth_(ledger)){
var statearr_63003_63034 = state_62967__$1;
(statearr_63003_63034[(1)] = (9));

} else {
var statearr_63004_63035 = state_62967__$1;
(statearr_63004_63035[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_63005 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63005[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_63005[(1)] = (1));

return statearr_63005;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_62967){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62967);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63006){var ex__2730__auto__ = e63006;
var statearr_63007_63036 = state_62967;
(statearr_63007_63036[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62967[(4)]))){
var statearr_63008_63037 = state_62967;
(statearr_63008_63037[(1)] = cljs.core.first((state_62967[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63038 = state_62967;
state_62967 = G__63038;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_62967){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_62967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63009 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63009[(6)] = c__2749__auto__);

return statearr_63009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__63040 = arguments.length;
switch (G__63040) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63075){
var state_val_63076 = (state_63075[(1)]);
if((state_val_63076 === (1))){
var state_63075__$1 = state_63075;
var statearr_63077_63099 = state_63075__$1;
(statearr_63077_63099[(2)] = null);

(statearr_63077_63099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63076 === (2))){
var _ = (function (){var statearr_63078 = state_63075;
(statearr_63078[(4)] = cljs.core.cons((5),(state_63075[(4)])));

return statearr_63078;
})();
var inst_63049 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63075__$1 = state_63075;
if(cljs.core.truth_(inst_63049)){
var statearr_63079_63100 = state_63075__$1;
(statearr_63079_63100[(1)] = (6));

} else {
var statearr_63080_63101 = state_63075__$1;
(statearr_63080_63101[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63076 === (3))){
var inst_63073 = (state_63075[(2)]);
var state_63075__$1 = state_63075;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63075__$1,inst_63073);
} else {
if((state_val_63076 === (4))){
var inst_63041 = (state_63075[(2)]);
var inst_63042 = cljs.core.clj__GT_js(inst_63041);
var inst_63043 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63042) : reject.call(null,inst_63042));
var state_63075__$1 = state_63075;
var statearr_63082_63102 = state_63075__$1;
(statearr_63082_63102[(2)] = inst_63043);

(statearr_63082_63102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63076 === (5))){
var _ = (function (){var statearr_63083 = state_63075;
(statearr_63083[(4)] = cljs.core.rest((state_63075[(4)])));

return statearr_63083;
})();
var state_63075__$1 = state_63075;
var ex63081 = (state_63075__$1[(2)]);
var statearr_63084_63103 = state_63075__$1;
(statearr_63084_63103[(5)] = ex63081);


var statearr_63085_63104 = state_63075__$1;
(statearr_63085_63104[(1)] = (4));

(statearr_63085_63104[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63076 === (6))){
var state_63075__$1 = state_63075;
var statearr_63086_63105 = state_63075__$1;
(statearr_63086_63105[(2)] = null);

(statearr_63086_63105[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63076 === (7))){
var inst_63052 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63053 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63054 = cljs.core.PersistentHashMap.fromArrays(inst_63052,inst_63053);
var inst_63055 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63054);
var inst_63056 = (function(){throw inst_63055})();
var state_63075__$1 = state_63075;
var statearr_63087_63106 = state_63075__$1;
(statearr_63087_63106[(2)] = inst_63056);

(statearr_63087_63106[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63076 === (8))){
var inst_63058 = (state_63075[(2)]);
var inst_63059 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63060 = [jwt,expire];
var inst_63061 = cljs.core.PersistentHashMap.fromArrays(inst_63059,inst_63060);
var inst_63062 = fluree.db.util.core.without_nils(inst_63061);
var inst_63063 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63064 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63066 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_63062,inst_63063,null];
var inst_63067 = (new cljs.core.PersistentVector(null,4,(5),inst_63065,inst_63066,null));
var inst_63068 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63064,inst_63067);
var inst_63069 = (function (){var _ = inst_63058;
var data = inst_63062;
var pc = inst_63063;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63088 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63088) : reject.call(null,G__63088));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__63089 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63089) : resolve.call(null,G__63089));

}
});
})();
var inst_63070 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63063,inst_63069);
var _ = (function (){var statearr_63090 = state_63075;
(statearr_63090[(4)] = cljs.core.rest((state_63075[(4)])));

return statearr_63090;
})();
var state_63075__$1 = (function (){var statearr_63091 = state_63075;
(statearr_63091[(7)] = inst_63068);

return statearr_63091;
})();
var statearr_63092_63107 = state_63075__$1;
(statearr_63092_63107[(2)] = inst_63070);

(statearr_63092_63107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_63093 = [null,null,null,null,null,null,null,null];
(statearr_63093[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_63093[(1)] = (1));

return statearr_63093;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_63075){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63075);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63094){var ex__2730__auto__ = e63094;
var statearr_63095_63108 = state_63075;
(statearr_63095_63108[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63075[(4)]))){
var statearr_63096_63109 = state_63075;
(statearr_63096_63109[(1)] = cljs.core.first((state_63075[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63110 = state_63075;
state_63075 = G__63110;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_63075){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_63075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63097 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63097[(6)] = c__2749__auto__);

return statearr_63097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

