// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__26610 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26610,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26610,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26610,(2),null);
if(cljs.core.truth_((function (){var and__4251__auto__ = network;
if(cljs.core.truth_(and__4251__auto__)){
return maybe_alias;
} else {
return and__4251__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__26613){
var map__26614 = p__26613;
var map__26614__$1 = cljs.core.__destructure_map(map__26614);
var opts = map__26614__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26614__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26674){
var state_val_26675 = (state_26674[(1)]);
if((state_val_26675 === (7))){
var inst_26645 = cljs.core.not(reindex_QMARK_);
var state_26674__$1 = state_26674;
var statearr_26676_26700 = state_26674__$1;
(statearr_26676_26700[(2)] = inst_26645);

(statearr_26676_26700[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26675 === (1))){
var state_26674__$1 = state_26674;
var statearr_26677_26701 = state_26674__$1;
(statearr_26677_26701[(2)] = null);

(statearr_26677_26701[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26675 === (4))){
var inst_26615 = (state_26674[(2)]);
var state_26674__$1 = state_26674;
var statearr_26678_26702 = state_26674__$1;
(statearr_26678_26702[(2)] = inst_26615);

(statearr_26678_26702[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26675 === (6))){
var inst_26629 = (state_26674[(7)]);
var inst_26635 = (state_26674[(8)]);
var inst_26643 = (state_26674[(9)]);
var inst_26628 = (state_26674[(2)]);
var inst_26629__$1 = fluree.db.util.async.throw_err(inst_26628);
var inst_26630 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_26631 = cljs.core.__destructure_map(inst_26630);
var inst_26632 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26631,new cljs.core.Keyword(null,"post","post",269697687));
var inst_26633 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26631,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_26634 = fluree.db.flake.size_bytes(inst_26629__$1);
var inst_26635__$1 = (inst_26633 + inst_26634);
var inst_26636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26637 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_26638 = (new cljs.core.PersistentVector(null,2,(5),inst_26636,inst_26637,null));
var inst_26639 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_26638);
var inst_26640 = cljs.core.__destructure_map(inst_26639);
var inst_26641 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26640,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_26642 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26640,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_26643__$1 = (inst_26635__$1 > inst_26642);
var state_26674__$1 = (function (){var statearr_26679 = state_26674;
(statearr_26679[(10)] = inst_26641);

(statearr_26679[(7)] = inst_26629__$1);

(statearr_26679[(11)] = inst_26632);

(statearr_26679[(8)] = inst_26635__$1);

(statearr_26679[(9)] = inst_26643__$1);

return statearr_26679;
})();
if(cljs.core.truth_(inst_26643__$1)){
var statearr_26680_26703 = state_26674__$1;
(statearr_26680_26703[(1)] = (7));

} else {
var statearr_26681_26704 = state_26674__$1;
(statearr_26681_26704[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26675 === (3))){
var inst_26672 = (state_26674[(2)]);
var state_26674__$1 = state_26674;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26674__$1,inst_26672);
} else {
if((state_val_26675 === (12))){
var inst_26629 = (state_26674[(7)]);
var inst_26632 = (state_26674[(11)]);
var inst_26635 = (state_26674[(8)]);
var inst_26658 = (state_26674[(2)]);
var inst_26659 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26632,inst_26629);
var inst_26660 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_26661 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_26660,cljs.core.empty);
var inst_26662 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26663 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26664 = (new cljs.core.PersistentVector(null,2,(5),inst_26662,inst_26663,null));
var inst_26665 = cljs.core.assoc_in(db,inst_26664,inst_26659);
var inst_26666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26667 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26668 = (new cljs.core.PersistentVector(null,2,(5),inst_26666,inst_26667,null));
var inst_26669 = cljs.core.assoc_in(inst_26665,inst_26668,inst_26635);
var _ = (function (){var statearr_26682 = state_26674;
(statearr_26682[(4)] = cljs.core.rest((state_26674[(4)])));

return statearr_26682;
})();
var state_26674__$1 = (function (){var statearr_26683 = state_26674;
(statearr_26683[(12)] = inst_26661);

(statearr_26683[(13)] = inst_26658);

return statearr_26683;
})();
var statearr_26684_26705 = state_26674__$1;
(statearr_26684_26705[(2)] = inst_26669);

(statearr_26684_26705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26675 === (2))){
var _ = (function (){var statearr_26685 = state_26674;
(statearr_26685[(4)] = cljs.core.cons((5),(state_26674[(4)])));

return statearr_26685;
})();
var inst_26623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26624 = [pred_id];
var inst_26625 = (new cljs.core.PersistentVector(null,1,(5),inst_26623,inst_26624,null));
var inst_26626 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26625);
var state_26674__$1 = state_26674;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26674__$1,(6),inst_26626);
} else {
if((state_val_26675 === (11))){
var state_26674__$1 = state_26674;
var statearr_26687_26706 = state_26674__$1;
(statearr_26687_26706[(2)] = null);

(statearr_26687_26706[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26675 === (9))){
var inst_26648 = (state_26674[(2)]);
var state_26674__$1 = state_26674;
if(cljs.core.truth_(inst_26648)){
var statearr_26688_26707 = state_26674__$1;
(statearr_26688_26707[(1)] = (10));

} else {
var statearr_26689_26708 = state_26674__$1;
(statearr_26689_26708[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26675 === (5))){
var _ = (function (){var statearr_26690 = state_26674;
(statearr_26690[(4)] = cljs.core.rest((state_26674[(4)])));

return statearr_26690;
})();
var state_26674__$1 = state_26674;
var ex26686 = (state_26674__$1[(2)]);
var statearr_26691_26709 = state_26674__$1;
(statearr_26691_26709[(5)] = ex26686);


if((ex26686 instanceof Error)){
var statearr_26692_26710 = state_26674__$1;
(statearr_26692_26710[(1)] = (4));

(statearr_26692_26710[(5)] = null);

} else {
throw ex26686;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26675 === (10))){
var inst_26650 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_26651 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_26652 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_26653 = cljs.core.PersistentHashMap.fromArrays(inst_26651,inst_26652);
var inst_26654 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26650,inst_26653);
var inst_26655 = (function(){throw inst_26654})();
var state_26674__$1 = state_26674;
var statearr_26693_26711 = state_26674__$1;
(statearr_26693_26711[(2)] = inst_26655);

(statearr_26693_26711[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26675 === (8))){
var inst_26643 = (state_26674[(9)]);
var state_26674__$1 = state_26674;
var statearr_26694_26712 = state_26674__$1;
(statearr_26694_26712[(2)] = inst_26643);

(statearr_26694_26712[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0 = (function (){
var statearr_26695 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26695[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__);

(statearr_26695[(1)] = (1));

return statearr_26695;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1 = (function (state_26674){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26674);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26696){var ex__2730__auto__ = e26696;
var statearr_26697_26713 = state_26674;
(statearr_26697_26713[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26674[(4)]))){
var statearr_26698_26714 = state_26674;
(statearr_26698_26714[(1)] = cljs.core.first((state_26674[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26715 = state_26674;
state_26674 = G__26715;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__ = function(state_26674){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1.call(this,state_26674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26699 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26699[(6)] = c__2749__auto__);

return statearr_26699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__26720 = arguments.length;
switch (G__26720) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26916){
var state_val_26917 = (state_26916[(1)]);
if((state_val_26917 === (7))){
var state_26916__$1 = state_26916;
var statearr_26918_26986 = state_26916__$1;
(statearr_26918_26986[(2)] = null);

(statearr_26918_26986[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (20))){
var inst_26759 = (state_26916[(7)]);
var inst_26842 = (state_26916[(8)]);
var inst_26838 = (state_26916[(9)]);
var inst_26841 = (state_26916[(10)]);
var inst_26839 = (state_26916[(11)]);
var inst_26758 = (state_26916[(12)]);
var inst_26840 = (state_26916[(13)]);
var inst_26809 = (state_26916[(14)]);
var inst_26852 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26854 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26855 = (new cljs.core.PersistentVector(null,2,(5),inst_26853,inst_26854,null));
var inst_26856 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26809,inst_26855);
var inst_26857 = (inst_26758 + inst_26856);
var inst_26858 = [inst_26838,inst_26839,inst_26840,inst_26841,inst_26857];
var inst_26859 = cljs.core.PersistentHashMap.fromArrays(inst_26852,inst_26858);
var inst_26860 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_26809,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_26842,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26859], 0));
var state_26916__$1 = (function (){var statearr_26919 = state_26916;
(statearr_26919[(15)] = inst_26860);

return statearr_26919;
})();
if(cljs.core.truth_(inst_26759)){
var statearr_26920_26987 = state_26916__$1;
(statearr_26920_26987[(1)] = (23));

} else {
var statearr_26921_26988 = state_26916__$1;
(statearr_26921_26988[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (27))){
var inst_26860 = (state_26916[(15)]);
var state_26916__$1 = state_26916;
var statearr_26922_26989 = state_26916__$1;
(statearr_26922_26989[(2)] = inst_26860);

(statearr_26922_26989[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (1))){
var state_26916__$1 = state_26916;
var statearr_26923_26990 = state_26916__$1;
(statearr_26923_26990[(2)] = null);

(statearr_26923_26990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (24))){
var inst_26860 = (state_26916[(15)]);
var inst_26863 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26860);
var inst_26864 = (inst_26863 == null);
var state_26916__$1 = state_26916;
var statearr_26924_26991 = state_26916__$1;
(statearr_26924_26991[(2)] = inst_26864);

(statearr_26924_26991[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (39))){
var inst_26849 = (state_26916[(16)]);
var inst_26892 = (state_26916[(17)]);
var inst_26890 = (state_26916[(18)]);
var inst_26891 = (state_26916[(19)]);
var inst_26899 = (state_26916[(20)]);
var inst_26906 = (state_26916[(2)]);
var inst_26837 = inst_26849;
var inst_26838 = inst_26891;
var inst_26839 = inst_26892;
var inst_26840 = inst_26899;
var inst_26841 = inst_26906;
var inst_26842 = inst_26890;
var state_26916__$1 = (function (){var statearr_26925 = state_26916;
(statearr_26925[(8)] = inst_26842);

(statearr_26925[(9)] = inst_26838);

(statearr_26925[(21)] = inst_26837);

(statearr_26925[(10)] = inst_26841);

(statearr_26925[(11)] = inst_26839);

(statearr_26925[(13)] = inst_26840);

return statearr_26925;
})();
var statearr_26926_26992 = state_26916__$1;
(statearr_26926_26992[(2)] = null);

(statearr_26926_26992[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (4))){
var inst_26721 = (state_26916[(2)]);
var state_26916__$1 = state_26916;
var statearr_26927_26993 = state_26916__$1;
(statearr_26927_26993[(2)] = inst_26721);

(statearr_26927_26993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (15))){
var inst_26781 = (state_26916[(22)]);
var state_26916__$1 = state_26916;
var statearr_26928_26994 = state_26916__$1;
(statearr_26928_26994[(2)] = inst_26781);

(statearr_26928_26994[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (21))){
var inst_26760 = (state_26916[(23)]);
var inst_26745 = (state_26916[(24)]);
var inst_26849 = (state_26916[(16)]);
var inst_26759 = (state_26916[(7)]);
var inst_26743 = (state_26916[(25)]);
var inst_26842 = (state_26916[(8)]);
var inst_26768 = (state_26916[(26)]);
var inst_26818 = (state_26916[(27)]);
var inst_26728 = (state_26916[(28)]);
var inst_26762 = (state_26916[(29)]);
var inst_26838 = (state_26916[(9)]);
var inst_26848 = (state_26916[(30)]);
var inst_26837 = (state_26916[(21)]);
var inst_26841 = (state_26916[(10)]);
var inst_26749 = (state_26916[(31)]);
var inst_26753 = (state_26916[(32)]);
var inst_26839 = (state_26916[(11)]);
var inst_26819 = (state_26916[(33)]);
var inst_26757 = (state_26916[(34)]);
var inst_26758 = (state_26916[(12)]);
var inst_26840 = (state_26916[(13)]);
var inst_26809 = (state_26916[(14)]);
var inst_26887 = inst_26848.s;
var inst_26888 = fluree.db.flake.sid__GT_cid(inst_26887);
var inst_26889 = (function (){var flakes_bytes = inst_26758;
var t = inst_26728;
var first__26846 = inst_26848;
var spot = inst_26838;
var add_flakes = inst_26745;
var seq__26815 = inst_26819;
var root_setting_change_QMARK_ = inst_26760;
var vec__26814 = inst_26745;
var vec__26844 = inst_26837;
var ref_QMARK__map = inst_26757;
var r = inst_26849;
var psot = inst_26839;
var add_pred_to_idx_QMARK_ = inst_26768;
var _ = inst_26743;
var cid = inst_26888;
var ecount = inst_26842;
var pred_ecount = inst_26762;
var db_STAR_ = inst_26809;
var schema_change_QMARK_ = inst_26759;
var add_preds = inst_26749;
var seq__26845 = inst_26849;
var opst = inst_26841;
var idx_QMARK__map = inst_26753;
var post = inst_26840;
var G__26813 = inst_26837;
var f = inst_26848;
var first__26816 = inst_26818;
return (function (p1__26718_SHARP_){
if(cljs.core.truth_(p1__26718_SHARP_)){
var x__4336__auto__ = p1__26718_SHARP_;
var y__4337__auto__ = f.s;
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
} else {
return f.s;
}
});
})();
var inst_26890 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_26842,inst_26888,inst_26889);
var inst_26891 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26838,inst_26848);
var inst_26892 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26839,inst_26848);
var inst_26893 = inst_26848.p;
var inst_26894 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26753,inst_26893);
var state_26916__$1 = (function (){var statearr_26929 = state_26916;
(statearr_26929[(17)] = inst_26892);

(statearr_26929[(18)] = inst_26890);

(statearr_26929[(19)] = inst_26891);

return statearr_26929;
})();
if(cljs.core.truth_(inst_26894)){
var statearr_26930_26995 = state_26916__$1;
(statearr_26930_26995[(1)] = (34));

} else {
var statearr_26931_26996 = state_26916__$1;
(statearr_26931_26996[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (31))){
var inst_26875 = (state_26916[(35)]);
var state_26916__$1 = state_26916;
var statearr_26932_26997 = state_26916__$1;
(statearr_26932_26997[(2)] = inst_26875);

(statearr_26932_26997[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (32))){
var inst_26885 = (state_26916[(2)]);
var state_26916__$1 = state_26916;
var statearr_26933_26998 = state_26916__$1;
(statearr_26933_26998[(2)] = inst_26885);

(statearr_26933_26998[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (33))){
var inst_26875 = (state_26916[(35)]);
var inst_26880 = (state_26916[(2)]);
var inst_26881 = fluree.db.util.async.throw_err(inst_26880);
var inst_26882 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26875,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26881);
var state_26916__$1 = state_26916;
var statearr_26934_26999 = state_26916__$1;
(statearr_26934_26999[(2)] = inst_26882);

(statearr_26934_26999[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (13))){
var inst_26745 = (state_26916[(24)]);
var inst_26728 = (state_26916[(28)]);
var inst_26758 = (state_26916[(12)]);
var inst_26809 = (state_26916[(14)]);
var inst_26799 = (state_26916[(2)]);
var inst_26800 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26799,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26728);
var inst_26801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26802 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26803 = (new cljs.core.PersistentVector(null,2,(5),inst_26801,inst_26802,null));
var inst_26804 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26800,inst_26803,cljs.core._PLUS_,inst_26758);
var inst_26805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26806 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_26807 = (new cljs.core.PersistentVector(null,2,(5),inst_26805,inst_26806,null));
var inst_26808 = cljs.core.count(inst_26745);
var inst_26809__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26804,inst_26807,cljs.core._PLUS_,inst_26808);
var inst_26817 = cljs.core.seq(inst_26745);
var inst_26818 = cljs.core.first(inst_26817);
var inst_26819 = cljs.core.next(inst_26817);
var inst_26820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26821 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_26822 = (new cljs.core.PersistentVector(null,2,(5),inst_26820,inst_26821,null));
var inst_26823 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26809__$1,inst_26822);
var inst_26824 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26825 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_26826 = (new cljs.core.PersistentVector(null,2,(5),inst_26824,inst_26825,null));
var inst_26827 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26809__$1,inst_26826);
var inst_26828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26829 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26830 = (new cljs.core.PersistentVector(null,2,(5),inst_26828,inst_26829,null));
var inst_26831 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26809__$1,inst_26830);
var inst_26832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26833 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26834 = (new cljs.core.PersistentVector(null,2,(5),inst_26832,inst_26833,null));
var inst_26835 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26809__$1,inst_26834);
var inst_26836 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26837 = inst_26745;
var inst_26838 = inst_26823;
var inst_26839 = inst_26827;
var inst_26840 = inst_26831;
var inst_26841 = inst_26835;
var inst_26842 = inst_26836;
var state_26916__$1 = (function (){var statearr_26935 = state_26916;
(statearr_26935[(8)] = inst_26842);

(statearr_26935[(27)] = inst_26818);

(statearr_26935[(9)] = inst_26838);

(statearr_26935[(21)] = inst_26837);

(statearr_26935[(10)] = inst_26841);

(statearr_26935[(11)] = inst_26839);

(statearr_26935[(33)] = inst_26819);

(statearr_26935[(13)] = inst_26840);

(statearr_26935[(14)] = inst_26809__$1);

return statearr_26935;
})();
var statearr_26936_27000 = state_26916__$1;
(statearr_26936_27000[(2)] = null);

(statearr_26936_27000[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (22))){
var inst_26909 = (state_26916[(2)]);
var state_26916__$1 = state_26916;
var statearr_26937_27001 = state_26916__$1;
(statearr_26937_27001[(2)] = inst_26909);

(statearr_26937_27001[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (36))){
var inst_26848 = (state_26916[(30)]);
var inst_26757 = (state_26916[(34)]);
var inst_26899 = (state_26916[(2)]);
var inst_26900 = inst_26848.p;
var inst_26901 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26757,inst_26900);
var state_26916__$1 = (function (){var statearr_26938 = state_26916;
(statearr_26938[(20)] = inst_26899);

return statearr_26938;
})();
if(cljs.core.truth_(inst_26901)){
var statearr_26939_27002 = state_26916__$1;
(statearr_26939_27002[(1)] = (37));

} else {
var statearr_26940_27003 = state_26916__$1;
(statearr_26940_27003[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (29))){
var inst_26860 = (state_26916[(15)]);
var inst_26870 = (state_26916[(2)]);
var inst_26871 = fluree.db.util.async.throw_err(inst_26870);
var inst_26872 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26860,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26871);
var state_26916__$1 = state_26916;
var statearr_26941_27004 = state_26916__$1;
(statearr_26941_27004[(2)] = inst_26872);

(statearr_26941_27004[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (6))){
var inst_26728 = (state_26916[(28)]);
var inst_26733 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26734 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26735 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26733)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26734)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26728),"."].join('');
var inst_26736 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26737 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26738 = cljs.core.PersistentHashMap.fromArrays(inst_26736,inst_26737);
var inst_26739 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26735,inst_26738);
var inst_26740 = (function(){throw inst_26739})();
var state_26916__$1 = state_26916;
var statearr_26942_27005 = state_26916__$1;
(statearr_26942_27005[(2)] = inst_26740);

(statearr_26942_27005[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (28))){
var inst_26760 = (state_26916[(23)]);
var inst_26875 = (state_26916[(2)]);
var state_26916__$1 = (function (){var statearr_26943 = state_26916;
(statearr_26943[(35)] = inst_26875);

return statearr_26943;
})();
if(cljs.core.truth_(inst_26760)){
var statearr_26944_27006 = state_26916__$1;
(statearr_26944_27006[(1)] = (30));

} else {
var statearr_26945_27007 = state_26916__$1;
(statearr_26945_27007[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (25))){
var inst_26866 = (state_26916[(2)]);
var state_26916__$1 = state_26916;
if(cljs.core.truth_(inst_26866)){
var statearr_26946_27008 = state_26916__$1;
(statearr_26946_27008[(1)] = (26));

} else {
var statearr_26947_27009 = state_26916__$1;
(statearr_26947_27009[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (34))){
var inst_26848 = (state_26916[(30)]);
var inst_26840 = (state_26916[(13)]);
var inst_26896 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26840,inst_26848);
var state_26916__$1 = state_26916;
var statearr_26948_27010 = state_26916__$1;
(statearr_26948_27010[(2)] = inst_26896);

(statearr_26948_27010[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (17))){
var inst_26788 = (state_26916[(36)]);
var inst_26792 = (state_26916[(2)]);
var inst_26793 = fluree.db.util.async.throw_err(inst_26792);
var inst_26780 = inst_26788;
var inst_26781 = inst_26793;
var state_26916__$1 = (function (){var statearr_26949 = state_26916;
(statearr_26949[(37)] = inst_26780);

(statearr_26949[(22)] = inst_26781);

return statearr_26949;
})();
var statearr_26950_27011 = state_26916__$1;
(statearr_26950_27011[(2)] = null);

(statearr_26950_27011[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (3))){
var inst_26914 = (state_26916[(2)]);
var state_26916__$1 = state_26916;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26916__$1,inst_26914);
} else {
if((state_val_26917 === (12))){
var inst_26780 = (state_26916[(37)]);
var inst_26787 = (state_26916[(38)]);
var inst_26786 = cljs.core.seq(inst_26780);
var inst_26787__$1 = cljs.core.first(inst_26786);
var inst_26788 = cljs.core.next(inst_26786);
var state_26916__$1 = (function (){var statearr_26951 = state_26916;
(statearr_26951[(38)] = inst_26787__$1);

(statearr_26951[(36)] = inst_26788);

return statearr_26951;
})();
if(cljs.core.truth_(inst_26787__$1)){
var statearr_26952_27012 = state_26916__$1;
(statearr_26952_27012[(1)] = (14));

} else {
var statearr_26953_27013 = state_26916__$1;
(statearr_26953_27013[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (2))){
var inst_26728 = (state_26916[(28)]);
var _ = (function (){var statearr_26954 = state_26916;
(statearr_26954[(4)] = cljs.core.cons((5),(state_26916[(4)])));

return statearr_26954;
})();
var inst_26727 = cljs.core.first(flakes);
var inst_26728__$1 = inst_26727.t;
var inst_26729 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26730 = (inst_26729 - (1));
var inst_26731 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_26728__$1,inst_26730);
var state_26916__$1 = (function (){var statearr_26955 = state_26916;
(statearr_26955[(28)] = inst_26728__$1);

return statearr_26955;
})();
if(inst_26731){
var statearr_26956_27014 = state_26916__$1;
(statearr_26956_27014[(1)] = (6));

} else {
var statearr_26957_27015 = state_26916__$1;
(statearr_26957_27015[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (23))){
var inst_26759 = (state_26916[(7)]);
var state_26916__$1 = state_26916;
var statearr_26958_27016 = state_26916__$1;
(statearr_26958_27016[(2)] = inst_26759);

(statearr_26958_27016[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (35))){
var inst_26840 = (state_26916[(13)]);
var state_26916__$1 = state_26916;
var statearr_26959_27017 = state_26916__$1;
(statearr_26959_27017[(2)] = inst_26840);

(statearr_26959_27017[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (19))){
var inst_26911 = (state_26916[(2)]);
var _ = (function (){var statearr_26960 = state_26916;
(statearr_26960[(4)] = cljs.core.rest((state_26916[(4)])));

return statearr_26960;
})();
var state_26916__$1 = state_26916;
var statearr_26961_27018 = state_26916__$1;
(statearr_26961_27018[(2)] = inst_26911);

(statearr_26961_27018[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (11))){
var inst_26768 = (state_26916[(26)]);
var inst_26768__$1 = (state_26916[(2)]);
var inst_26776 = cljs.core.seq(inst_26768__$1);
var inst_26777 = cljs.core.first(inst_26776);
var inst_26778 = cljs.core.next(inst_26776);
var inst_26779 = db;
var inst_26780 = inst_26768__$1;
var inst_26781 = inst_26779;
var state_26916__$1 = (function (){var statearr_26963 = state_26916;
(statearr_26963[(37)] = inst_26780);

(statearr_26963[(26)] = inst_26768__$1);

(statearr_26963[(22)] = inst_26781);

(statearr_26963[(39)] = inst_26778);

(statearr_26963[(40)] = inst_26777);

return statearr_26963;
})();
var statearr_26964_27019 = state_26916__$1;
(statearr_26964_27019[(2)] = null);

(statearr_26964_27019[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (9))){
var inst_26745 = (state_26916[(24)]);
var inst_26762 = (state_26916[(29)]);
var inst_26764 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_26745,inst_26762);
var state_26916__$1 = state_26916;
var statearr_26965_27020 = state_26916__$1;
(statearr_26965_27020[(2)] = inst_26764);

(statearr_26965_27020[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (5))){
var _ = (function (){var statearr_26966 = state_26916;
(statearr_26966[(4)] = cljs.core.rest((state_26916[(4)])));

return statearr_26966;
})();
var state_26916__$1 = state_26916;
var ex26962 = (state_26916__$1[(2)]);
var statearr_26967_27021 = state_26916__$1;
(statearr_26967_27021[(5)] = ex26962);


if((ex26962 instanceof Error)){
var statearr_26968_27022 = state_26916__$1;
(statearr_26968_27022[(1)] = (4));

(statearr_26968_27022[(5)] = null);

} else {
throw ex26962;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (14))){
var inst_26787 = (state_26916[(38)]);
var inst_26781 = (state_26916[(22)]);
var inst_26790 = fluree.db.graphdb.add_predicate_to_idx(inst_26781,inst_26787,opts);
var state_26916__$1 = state_26916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26916__$1,(17),inst_26790);
} else {
if((state_val_26917 === (26))){
var inst_26860 = (state_26916[(15)]);
var inst_26868 = fluree.db.query.schema.schema_map(inst_26860);
var state_26916__$1 = state_26916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26916__$1,(29),inst_26868);
} else {
if((state_val_26917 === (16))){
var inst_26797 = (state_26916[(2)]);
var state_26916__$1 = state_26916;
var statearr_26969_27023 = state_26916__$1;
(statearr_26969_27023[(2)] = inst_26797);

(statearr_26969_27023[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (38))){
var inst_26841 = (state_26916[(10)]);
var state_26916__$1 = state_26916;
var statearr_26970_27024 = state_26916__$1;
(statearr_26970_27024[(2)] = inst_26841);

(statearr_26970_27024[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (30))){
var inst_26875 = (state_26916[(35)]);
var inst_26878 = fluree.db.query.schema.setting_map(inst_26875);
var state_26916__$1 = state_26916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26916__$1,(33),inst_26878);
} else {
if((state_val_26917 === (10))){
var inst_26766 = cljs.core.PersistentVector.EMPTY;
var state_26916__$1 = state_26916;
var statearr_26971_27025 = state_26916__$1;
(statearr_26971_27025[(2)] = inst_26766);

(statearr_26971_27025[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (18))){
var inst_26848 = (state_26916[(30)]);
var inst_26837 = (state_26916[(21)]);
var inst_26847 = cljs.core.seq(inst_26837);
var inst_26848__$1 = cljs.core.first(inst_26847);
var inst_26849 = cljs.core.next(inst_26847);
var inst_26850 = cljs.core.not(inst_26848__$1);
var state_26916__$1 = (function (){var statearr_26972 = state_26916;
(statearr_26972[(16)] = inst_26849);

(statearr_26972[(30)] = inst_26848__$1);

return statearr_26972;
})();
if(inst_26850){
var statearr_26973_27026 = state_26916__$1;
(statearr_26973_27026[(1)] = (20));

} else {
var statearr_26974_27027 = state_26916__$1;
(statearr_26974_27027[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (37))){
var inst_26848 = (state_26916[(30)]);
var inst_26841 = (state_26916[(10)]);
var inst_26903 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26841,inst_26848);
var state_26916__$1 = state_26916;
var statearr_26975_27028 = state_26916__$1;
(statearr_26975_27028[(2)] = inst_26903);

(statearr_26975_27028[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26917 === (8))){
var inst_26745 = (state_26916[(24)]);
var inst_26759 = (state_26916[(7)]);
var inst_26743 = (state_26916[(25)]);
var inst_26728 = (state_26916[(28)]);
var inst_26749 = (state_26916[(31)]);
var inst_26753 = (state_26916[(32)]);
var inst_26743__$1 = (state_26916[(2)]);
var inst_26744 = (function (){var t = inst_26728;
var _ = inst_26743__$1;
return (function (p1__26716_SHARP_){
return cljs.core.not((function (){var G__26976 = p1__26716_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__26976) : fluree.db.graphdb.exclude_predicates.call(null,G__26976));
})());
});
})();
var inst_26745__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_26744,flakes);
var inst_26746 = cljs.core.PersistentHashSet.EMPTY;
var inst_26747 = (function (){var t = inst_26728;
var _ = inst_26743__$1;
var add_flakes = inst_26745__$1;
return (function (p1__26717_SHARP_){
return p1__26717_SHARP_.p;
});
})();
var inst_26748 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26747,inst_26745__$1);
var inst_26749__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26746,inst_26748);
var inst_26750 = cljs.core.PersistentHashMap.EMPTY;
var inst_26751 = (function (){var t = inst_26728;
var _ = inst_26743__$1;
var add_flakes = inst_26745__$1;
var add_preds = inst_26749__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_26752 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26751,inst_26749__$1);
var inst_26753__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26750,inst_26752);
var inst_26754 = cljs.core.PersistentHashMap.EMPTY;
var inst_26755 = (function (){var t = inst_26728;
var _ = inst_26743__$1;
var add_flakes = inst_26745__$1;
var add_preds = inst_26749__$1;
var idx_QMARK__map = inst_26753__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_26756 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26755,inst_26749__$1);
var inst_26757 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26754,inst_26756);
var inst_26758 = fluree.db.flake.size_bytes(inst_26745__$1);
var inst_26759__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_26745__$1);
var inst_26760 = fluree.db.util.schema.setting_change_QMARK_(inst_26745__$1);
var inst_26761 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26762 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26761,(0));
var state_26916__$1 = (function (){var statearr_26977 = state_26916;
(statearr_26977[(23)] = inst_26760);

(statearr_26977[(24)] = inst_26745__$1);

(statearr_26977[(7)] = inst_26759__$1);

(statearr_26977[(25)] = inst_26743__$1);

(statearr_26977[(29)] = inst_26762);

(statearr_26977[(31)] = inst_26749__$1);

(statearr_26977[(32)] = inst_26753__$1);

(statearr_26977[(34)] = inst_26757);

(statearr_26977[(12)] = inst_26758);

return statearr_26977;
})();
if(cljs.core.truth_(inst_26759__$1)){
var statearr_26978_27029 = state_26916__$1;
(statearr_26978_27029[(1)] = (9));

} else {
var statearr_26979_27030 = state_26916__$1;
(statearr_26979_27030[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26980 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26980[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26980[(1)] = (1));

return statearr_26980;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26916){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26916);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26981){var ex__2730__auto__ = e26981;
var statearr_26982_27031 = state_26916;
(statearr_26982_27031[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26916[(4)]))){
var statearr_26983_27032 = state_26916;
(statearr_26983_27032[(1)] = cljs.core.first((state_26916[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27033 = state_26916;
state_26916 = G__27033;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26916){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26984 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26984[(6)] = c__2749__auto__);

return statearr_26984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__27035 = arguments.length;
switch (G__27035) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___27182 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27131){
var state_val_27132 = (state_27131[(1)]);
if((state_val_27132 === (7))){
var state_27131__$1 = state_27131;
var statearr_27133_27183 = state_27131__$1;
(statearr_27133_27183[(2)] = null);

(statearr_27133_27183[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (20))){
var inst_27080 = (state_27131[(7)]);
var inst_27081 = (state_27131[(8)]);
var inst_27079 = (state_27131[(9)]);
var inst_27100 = (inst_27079 + (1));
var inst_27101 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27081,new cljs.core.Keyword(null,"t","t",-1397832519),inst_27100);
var inst_27102 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_27101,inst_27080,opts);
var state_27131__$1 = state_27131;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27131__$1,(23),inst_27102);
} else {
if((state_val_27132 === (1))){
var state_27131__$1 = state_27131;
var statearr_27134_27184 = state_27131__$1;
(statearr_27134_27184[(2)] = null);

(statearr_27134_27184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (24))){
var inst_27105 = (state_27131[(10)]);
var inst_27108 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27105,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_27131__$1 = state_27131;
var statearr_27135_27185 = state_27131__$1;
(statearr_27135_27185[(2)] = inst_27108);

(statearr_27135_27185[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (4))){
var inst_27036 = (state_27131[(2)]);
var inst_27037 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_27036);
var state_27131__$1 = state_27131;
var statearr_27136_27186 = state_27131__$1;
(statearr_27136_27186[(2)] = inst_27037);

(statearr_27136_27186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (15))){
var inst_27087 = (state_27131[(11)]);
var state_27131__$1 = state_27131;
var statearr_27137_27187 = state_27131__$1;
(statearr_27137_27187[(2)] = inst_27087);

(statearr_27137_27187[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (21))){
var state_27131__$1 = state_27131;
var statearr_27138_27188 = state_27131__$1;
(statearr_27138_27188[(2)] = null);

(statearr_27138_27188[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (13))){
var inst_27123 = (state_27131[(2)]);
var inst_27124 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_27123);
var state_27131__$1 = state_27131;
var statearr_27139_27189 = state_27131__$1;
(statearr_27139_27189[(2)] = inst_27124);

(statearr_27139_27189[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (22))){
var inst_27119 = (state_27131[(2)]);
var state_27131__$1 = state_27131;
var statearr_27140_27190 = state_27131__$1;
(statearr_27140_27190[(2)] = inst_27119);

(statearr_27140_27190[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (6))){
var inst_27047 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_27048 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_27049 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27047)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27048)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27050 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27051 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27052 = cljs.core.PersistentHashMap.fromArrays(inst_27050,inst_27051);
var inst_27053 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27049,inst_27052);
var inst_27054 = (function(){throw inst_27053})();
var state_27131__$1 = state_27131;
var statearr_27143_27191 = state_27131__$1;
(statearr_27143_27191[(2)] = inst_27054);

(statearr_27143_27191[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (25))){
var inst_27105 = (state_27131[(10)]);
var inst_27087 = (state_27131[(11)]);
var inst_27088 = (state_27131[(12)]);
var inst_27110 = inst_27087.t;
var inst_27111 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27112 = [inst_27087];
var inst_27113 = (new cljs.core.PersistentVector(null,1,(5),inst_27111,inst_27112,null));
var inst_27078 = inst_27088;
var inst_27079 = inst_27110;
var inst_27080 = inst_27113;
var inst_27081 = inst_27105;
var state_27131__$1 = (function (){var statearr_27144 = state_27131;
(statearr_27144[(7)] = inst_27080);

(statearr_27144[(8)] = inst_27081);

(statearr_27144[(9)] = inst_27079);

(statearr_27144[(13)] = inst_27078);

return statearr_27144;
})();
var statearr_27145_27192 = state_27131__$1;
(statearr_27145_27192[(2)] = null);

(statearr_27145_27192[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (17))){
var inst_27087 = (state_27131[(11)]);
var inst_27088 = (state_27131[(12)]);
var inst_27080 = (state_27131[(7)]);
var inst_27081 = (state_27131[(8)]);
var inst_27079 = (state_27131[(9)]);
var inst_27096 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27080,inst_27087);
var tmp27141 = inst_27081;
var tmp27142 = inst_27079;
var inst_27078 = inst_27088;
var inst_27079__$1 = tmp27142;
var inst_27080__$1 = inst_27096;
var inst_27081__$1 = tmp27141;
var state_27131__$1 = (function (){var statearr_27146 = state_27131;
(statearr_27146[(7)] = inst_27080__$1);

(statearr_27146[(8)] = inst_27081__$1);

(statearr_27146[(9)] = inst_27079__$1);

(statearr_27146[(13)] = inst_27078);

return statearr_27146;
})();
var statearr_27147_27193 = state_27131__$1;
(statearr_27147_27193[(2)] = null);

(statearr_27147_27193[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (3))){
var inst_27129 = (state_27131[(2)]);
var state_27131__$1 = state_27131;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27131__$1,inst_27129);
} else {
if((state_val_27132 === (12))){
var inst_27087 = (state_27131[(11)]);
var inst_27078 = (state_27131[(13)]);
var inst_27086 = cljs.core.seq(inst_27078);
var inst_27087__$1 = cljs.core.first(inst_27086);
var inst_27088 = cljs.core.next(inst_27086);
var state_27131__$1 = (function (){var statearr_27148 = state_27131;
(statearr_27148[(11)] = inst_27087__$1);

(statearr_27148[(12)] = inst_27088);

return statearr_27148;
})();
if(cljs.core.truth_(inst_27087__$1)){
var statearr_27149_27194 = state_27131__$1;
(statearr_27149_27194[(1)] = (14));

} else {
var statearr_27150_27195 = state_27131__$1;
(statearr_27150_27195[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (2))){
var _ = (function (){var statearr_27151 = state_27131;
(statearr_27151[(4)] = cljs.core.cons((5),(state_27131[(4)])));

return statearr_27151;
})();
var inst_27043 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_27044 = (inst_27043 + (1));
var inst_27045 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_27044);
var state_27131__$1 = state_27131;
if(inst_27045){
var statearr_27152_27196 = state_27131__$1;
(statearr_27152_27196[(1)] = (6));

} else {
var statearr_27153_27197 = state_27131__$1;
(statearr_27153_27197[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (23))){
var inst_27087 = (state_27131[(11)]);
var inst_27104 = (state_27131[(2)]);
var inst_27105 = fluree.db.util.async.throw_err(inst_27104);
var inst_27106 = (inst_27087 == null);
var state_27131__$1 = (function (){var statearr_27154 = state_27131;
(statearr_27154[(10)] = inst_27105);

return statearr_27154;
})();
if(cljs.core.truth_(inst_27106)){
var statearr_27155_27198 = state_27131__$1;
(statearr_27155_27198[(1)] = (24));

} else {
var statearr_27156_27199 = state_27131__$1;
(statearr_27156_27199[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (19))){
var inst_27121 = (state_27131[(2)]);
var state_27131__$1 = state_27131;
var statearr_27157_27200 = state_27131__$1;
(statearr_27157_27200[(2)] = inst_27121);

(statearr_27157_27200[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (11))){
var inst_27126 = (state_27131[(2)]);
var _ = (function (){var statearr_27159 = state_27131;
(statearr_27159[(4)] = cljs.core.rest((state_27131[(4)])));

return statearr_27159;
})();
var state_27131__$1 = state_27131;
var statearr_27160_27201 = state_27131__$1;
(statearr_27160_27201[(2)] = inst_27126);

(statearr_27160_27201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (9))){
var inst_27060 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_27061 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_27060);
var state_27131__$1 = state_27131;
var statearr_27161_27202 = state_27131__$1;
(statearr_27161_27202[(2)] = inst_27061);

(statearr_27161_27202[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (5))){
var _ = (function (){var statearr_27162 = state_27131;
(statearr_27162[(4)] = cljs.core.rest((state_27131[(4)])));

return statearr_27162;
})();
var state_27131__$1 = state_27131;
var ex27158 = (state_27131__$1[(2)]);
var statearr_27163_27203 = state_27131__$1;
(statearr_27163_27203[(5)] = ex27158);


var statearr_27164_27204 = state_27131__$1;
(statearr_27164_27204[(1)] = (4));

(statearr_27164_27204[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (14))){
var inst_27087 = (state_27131[(11)]);
var inst_27079 = (state_27131[(9)]);
var inst_27090 = inst_27087.t;
var inst_27091 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_27079,inst_27090);
var state_27131__$1 = state_27131;
var statearr_27165_27205 = state_27131__$1;
(statearr_27165_27205[(2)] = inst_27091);

(statearr_27165_27205[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (26))){
var inst_27116 = (state_27131[(2)]);
var state_27131__$1 = state_27131;
var statearr_27166_27206 = state_27131__$1;
(statearr_27166_27206[(2)] = inst_27116);

(statearr_27166_27206[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (16))){
var inst_27094 = (state_27131[(2)]);
var state_27131__$1 = state_27131;
if(cljs.core.truth_(inst_27094)){
var statearr_27167_27207 = state_27131__$1;
(statearr_27167_27207[(1)] = (17));

} else {
var statearr_27168_27208 = state_27131__$1;
(statearr_27168_27208[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (10))){
var inst_27063 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_27064 = cljs.core.first(inst_27063);
var inst_27072 = cljs.core.seq(inst_27063);
var inst_27073 = cljs.core.first(inst_27072);
var inst_27074 = cljs.core.next(inst_27072);
var inst_27075 = inst_27064.t;
var inst_27076 = cljs.core.PersistentVector.EMPTY;
var inst_27077 = db;
var inst_27078 = inst_27063;
var inst_27079 = inst_27075;
var inst_27080 = inst_27076;
var inst_27081 = inst_27077;
var state_27131__$1 = (function (){var statearr_27169 = state_27131;
(statearr_27169[(14)] = inst_27073);

(statearr_27169[(7)] = inst_27080);

(statearr_27169[(15)] = inst_27074);

(statearr_27169[(8)] = inst_27081);

(statearr_27169[(9)] = inst_27079);

(statearr_27169[(13)] = inst_27078);

return statearr_27169;
})();
var statearr_27170_27209 = state_27131__$1;
(statearr_27170_27209[(2)] = null);

(statearr_27170_27209[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (18))){
var state_27131__$1 = state_27131;
var statearr_27171_27210 = state_27131__$1;
(statearr_27171_27210[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27132 === (8))){
var inst_27057 = (state_27131[(2)]);
var inst_27058 = cljs.core.empty_QMARK_(flakes);
var state_27131__$1 = (function (){var statearr_27173 = state_27131;
(statearr_27173[(16)] = inst_27057);

return statearr_27173;
})();
if(inst_27058){
var statearr_27174_27211 = state_27131__$1;
(statearr_27174_27211[(1)] = (9));

} else {
var statearr_27175_27212 = state_27131__$1;
(statearr_27175_27212[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_27176 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27176[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_27176[(1)] = (1));

return statearr_27176;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_27131){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27131);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27177){var ex__2730__auto__ = e27177;
var statearr_27178_27213 = state_27131;
(statearr_27178_27213[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27131[(4)]))){
var statearr_27179_27214 = state_27131;
(statearr_27179_27214[(1)] = cljs.core.first((state_27131[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27215 = state_27131;
state_27131 = G__27215;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_27131){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_27131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27180 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27180[(6)] = c__2749__auto___27182);

return statearr_27180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27271){
var state_val_27272 = (state_27271[(1)]);
if((state_val_27272 === (7))){
var state_27271__$1 = state_27271;
var statearr_27273_27300 = state_27271__$1;
(statearr_27273_27300[(2)] = tt_id);

(statearr_27273_27300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27272 === (1))){
var state_27271__$1 = state_27271;
var statearr_27274_27301 = state_27271__$1;
(statearr_27274_27301[(2)] = null);

(statearr_27274_27301[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27272 === (4))){
var inst_27216 = (state_27271[(2)]);
var state_27271__$1 = state_27271;
var statearr_27275_27302 = state_27271__$1;
(statearr_27275_27302[(2)] = inst_27216);

(statearr_27275_27302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27272 === (13))){
var inst_27264 = (state_27271[(2)]);
var state_27271__$1 = state_27271;
var statearr_27276_27303 = state_27271__$1;
(statearr_27276_27303[(2)] = inst_27264);

(statearr_27276_27303[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27272 === (6))){
var inst_27224 = fluree.db.util.core.random_uuid();
var state_27271__$1 = state_27271;
var statearr_27277_27304 = state_27271__$1;
(statearr_27277_27304[(2)] = inst_27224);

(statearr_27277_27304[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27272 === (3))){
var inst_27269 = (state_27271[(2)]);
var state_27271__$1 = state_27271;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27271__$1,inst_27269);
} else {
if((state_val_27272 === (12))){
var inst_27247 = (state_27271[(7)]);
var state_27271__$1 = state_27271;
var statearr_27278_27305 = state_27271__$1;
(statearr_27278_27305[(2)] = inst_27247);

(statearr_27278_27305[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27272 === (2))){
var _ = (function (){var statearr_27279 = state_27271;
(statearr_27279[(4)] = cljs.core.cons((5),(state_27271[(4)])));

return statearr_27279;
})();
var inst_27222 = (tt_id == null);
var state_27271__$1 = state_27271;
if(cljs.core.truth_(inst_27222)){
var statearr_27280_27306 = state_27271__$1;
(statearr_27280_27306[(1)] = (6));

} else {
var statearr_27281_27307 = state_27271__$1;
(statearr_27281_27307[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27272 === (11))){
var inst_27254 = (state_27271[(8)]);
var inst_27247 = (state_27271[(7)]);
var inst_27257 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_27247,inst_27254);
var state_27271__$1 = state_27271;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27271__$1,(14),inst_27257);
} else {
if((state_val_27272 === (9))){
var inst_27254 = (state_27271[(8)]);
var inst_27248 = (state_27271[(9)]);
var inst_27253 = cljs.core.seq(inst_27248);
var inst_27254__$1 = cljs.core.first(inst_27253);
var inst_27255 = cljs.core.next(inst_27253);
var state_27271__$1 = (function (){var statearr_27283 = state_27271;
(statearr_27283[(10)] = inst_27255);

(statearr_27283[(8)] = inst_27254__$1);

return statearr_27283;
})();
if(cljs.core.truth_(inst_27254__$1)){
var statearr_27284_27308 = state_27271__$1;
(statearr_27284_27308[(1)] = (11));

} else {
var statearr_27285_27309 = state_27271__$1;
(statearr_27285_27309[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27272 === (5))){
var _ = (function (){var statearr_27286 = state_27271;
(statearr_27286[(4)] = cljs.core.rest((state_27271[(4)])));

return statearr_27286;
})();
var state_27271__$1 = state_27271;
var ex27282 = (state_27271__$1[(2)]);
var statearr_27287_27310 = state_27271__$1;
(statearr_27287_27310[(5)] = ex27282);


if((ex27282 instanceof Error)){
var statearr_27288_27311 = state_27271__$1;
(statearr_27288_27311[(1)] = (4));

(statearr_27288_27311[(5)] = null);

} else {
throw ex27282;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27272 === (14))){
var inst_27255 = (state_27271[(10)]);
var inst_27259 = (state_27271[(2)]);
var inst_27260 = fluree.db.util.async.throw_err(inst_27259);
var inst_27247 = inst_27260;
var inst_27248 = inst_27255;
var state_27271__$1 = (function (){var statearr_27289 = state_27271;
(statearr_27289[(9)] = inst_27248);

(statearr_27289[(7)] = inst_27247);

return statearr_27289;
})();
var statearr_27290_27312 = state_27271__$1;
(statearr_27290_27312[(2)] = null);

(statearr_27290_27312[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27272 === (10))){
var inst_27266 = (state_27271[(2)]);
var _ = (function (){var statearr_27291 = state_27271;
(statearr_27291[(4)] = cljs.core.rest((state_27271[(4)])));

return statearr_27291;
})();
var state_27271__$1 = state_27271;
var statearr_27292_27313 = state_27271__$1;
(statearr_27292_27313[(2)] = inst_27266);

(statearr_27292_27313[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27272 === (8))){
var inst_27227 = (state_27271[(2)]);
var inst_27228 = (function (){var tt_id_SINGLEQUOTE_ = inst_27227;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_27229 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_27227);
var inst_27230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27231 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_27232 = (new cljs.core.PersistentVector(null,4,(5),inst_27230,inst_27231,null));
var inst_27233 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_27228,inst_27229,inst_27232);
var inst_27234 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_27235 = cljs.core.reverse(inst_27234);
var inst_27236 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_27235);
var inst_27244 = cljs.core.seq(inst_27236);
var inst_27245 = cljs.core.first(inst_27244);
var inst_27246 = cljs.core.next(inst_27244);
var inst_27247 = inst_27233;
var inst_27248 = inst_27236;
var state_27271__$1 = (function (){var statearr_27293 = state_27271;
(statearr_27293[(11)] = inst_27245);

(statearr_27293[(9)] = inst_27248);

(statearr_27293[(12)] = inst_27246);

(statearr_27293[(7)] = inst_27247);

return statearr_27293;
})();
var statearr_27294_27314 = state_27271__$1;
(statearr_27294_27314[(2)] = null);

(statearr_27294_27314[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0 = (function (){
var statearr_27295 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27295[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__);

(statearr_27295[(1)] = (1));

return statearr_27295;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1 = (function (state_27271){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27271);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27296){var ex__2730__auto__ = e27296;
var statearr_27297_27315 = state_27271;
(statearr_27297_27315[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27271[(4)]))){
var statearr_27298_27316 = state_27271;
(statearr_27298_27316[(1)] = cljs.core.first((state_27271[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27317 = state_27271;
state_27271 = G__27317;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__ = function(state_27271){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1.call(this,state_27271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27299 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27299[(6)] = c__2749__auto__);

return statearr_27299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___27504 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27435){
var state_val_27436 = (state_27435[(1)]);
if((state_val_27436 === (7))){
var inst_27345 = (state_27435[(7)]);
var inst_27345__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_27435__$1 = (function (){var statearr_27437 = state_27435;
(statearr_27437[(7)] = inst_27345__$1);

return statearr_27437;
})();
if(inst_27345__$1){
var statearr_27438_27505 = state_27435__$1;
(statearr_27438_27505[(1)] = (13));

} else {
var statearr_27439_27506 = state_27435__$1;
(statearr_27439_27506[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (20))){
var state_27435__$1 = state_27435;
var statearr_27440_27507 = state_27435__$1;
(statearr_27440_27507[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (27))){
var inst_27381 = (state_27435[(8)]);
var inst_27385 = inst_27381.s;
var state_27435__$1 = state_27435;
var statearr_27442_27508 = state_27435__$1;
(statearr_27442_27508[(2)] = inst_27385);

(statearr_27442_27508[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (1))){
var state_27435__$1 = state_27435;
var statearr_27443_27509 = state_27435__$1;
(statearr_27443_27509[(2)] = null);

(statearr_27443_27509[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (24))){
var inst_27375 = (state_27435[(9)]);
var inst_27379 = cljs.core.first(inst_27375);
var state_27435__$1 = state_27435;
var statearr_27444_27510 = state_27435__$1;
(statearr_27444_27510[(2)] = inst_27379);

(statearr_27444_27510[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (39))){
var state_27435__$1 = state_27435;
var statearr_27445_27511 = state_27435__$1;
(statearr_27445_27511[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (4))){
var inst_27318 = (state_27435[(2)]);
var inst_27319 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27320 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27321 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27322 = cljs.core.PersistentHashMap.fromArrays(inst_27320,inst_27321);
var inst_27323 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_27319,inst_27322,inst_27318);
var inst_27324 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27323);
var state_27435__$1 = state_27435;
var statearr_27447_27512 = state_27435__$1;
(statearr_27447_27512[(2)] = inst_27324);

(statearr_27447_27512[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (15))){
var inst_27352 = (state_27435[(2)]);
var state_27435__$1 = state_27435;
if(cljs.core.truth_(inst_27352)){
var statearr_27448_27513 = state_27435__$1;
(statearr_27448_27513[(1)] = (16));

} else {
var statearr_27449_27514 = state_27435__$1;
(statearr_27449_27514[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (21))){
var inst_27401 = (state_27435[(2)]);
var state_27435__$1 = state_27435;
var statearr_27450_27515 = state_27435__$1;
(statearr_27450_27515[(2)] = inst_27401);

(statearr_27450_27515[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (31))){
var inst_27399 = (state_27435[(2)]);
var state_27435__$1 = state_27435;
var statearr_27451_27516 = state_27435__$1;
(statearr_27451_27516[(2)] = inst_27399);

(statearr_27451_27516[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (32))){
var inst_27405 = (state_27435[(10)]);
var inst_27407 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27405);
var state_27435__$1 = state_27435;
var statearr_27452_27517 = state_27435__$1;
(statearr_27452_27517[(2)] = inst_27407);

(statearr_27452_27517[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (40))){
var inst_27428 = (state_27435[(2)]);
var state_27435__$1 = state_27435;
var statearr_27453_27518 = state_27435__$1;
(statearr_27453_27518[(2)] = inst_27428);

(statearr_27453_27518[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (33))){
var inst_27409 = (state_27435[(11)]);
var inst_27405 = (state_27435[(10)]);
var inst_27409__$1 = (inst_27405 == null);
var state_27435__$1 = (function (){var statearr_27454 = state_27435;
(statearr_27454[(11)] = inst_27409__$1);

return statearr_27454;
})();
if(cljs.core.truth_(inst_27409__$1)){
var statearr_27455_27519 = state_27435__$1;
(statearr_27455_27519[(1)] = (35));

} else {
var statearr_27456_27520 = state_27435__$1;
(statearr_27456_27520[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (13))){
var inst_27347 = cljs.core.first(ident);
var inst_27348 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27347);
var inst_27349 = (inst_27348 == null);
var state_27435__$1 = state_27435;
var statearr_27457_27521 = state_27435__$1;
(statearr_27457_27521[(2)] = inst_27349);

(statearr_27457_27521[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (22))){
var inst_27375 = (state_27435[(9)]);
var inst_27374 = (state_27435[(2)]);
var inst_27375__$1 = fluree.db.util.async.throw_err(inst_27374);
var inst_27376 = (inst_27375__$1 == null);
var state_27435__$1 = (function (){var statearr_27458 = state_27435;
(statearr_27458[(9)] = inst_27375__$1);

return statearr_27458;
})();
if(cljs.core.truth_(inst_27376)){
var statearr_27459_27522 = state_27435__$1;
(statearr_27459_27522[(1)] = (23));

} else {
var statearr_27460_27523 = state_27435__$1;
(statearr_27460_27523[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (36))){
var inst_27409 = (state_27435[(11)]);
var state_27435__$1 = state_27435;
var statearr_27461_27524 = state_27435__$1;
(statearr_27461_27524[(2)] = inst_27409);

(statearr_27461_27524[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (41))){
var inst_27423 = cljs.core.async.close_BANG_(return_chan);
var state_27435__$1 = state_27435;
var statearr_27462_27525 = state_27435__$1;
(statearr_27462_27525[(2)] = inst_27423);

(statearr_27462_27525[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (43))){
var inst_27426 = (state_27435[(2)]);
var state_27435__$1 = state_27435;
var statearr_27463_27526 = state_27435__$1;
(statearr_27463_27526[(2)] = inst_27426);

(statearr_27463_27526[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (29))){
var inst_27390 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_27391 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_27390].join('');
var inst_27392 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27393 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27394 = cljs.core.PersistentHashMap.fromArrays(inst_27392,inst_27393);
var inst_27395 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27391,inst_27394);
var inst_27396 = (function(){throw inst_27395})();
var state_27435__$1 = state_27435;
var statearr_27464_27527 = state_27435__$1;
(statearr_27464_27527[(2)] = inst_27396);

(statearr_27464_27527[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (6))){
var inst_27332 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27333 = [ident];
var inst_27334 = (new cljs.core.PersistentVector(null,1,(5),inst_27332,inst_27333,null));
var inst_27335 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27334);
var state_27435__$1 = state_27435;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27435__$1,(9),inst_27335);
} else {
if((state_val_27436 === (28))){
var inst_27387 = (state_27435[(2)]);
var state_27435__$1 = state_27435;
var statearr_27465_27528 = state_27435__$1;
(statearr_27465_27528[(2)] = inst_27387);

(statearr_27465_27528[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (25))){
var inst_27381 = (state_27435[(8)]);
var inst_27381__$1 = (state_27435[(2)]);
var inst_27382 = (inst_27381__$1 == null);
var state_27435__$1 = (function (){var statearr_27466 = state_27435;
(statearr_27466[(8)] = inst_27381__$1);

return statearr_27466;
})();
if(cljs.core.truth_(inst_27382)){
var statearr_27467_27529 = state_27435__$1;
(statearr_27467_27529[(1)] = (26));

} else {
var statearr_27468_27530 = state_27435__$1;
(statearr_27468_27530[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (34))){
var inst_27430 = (state_27435[(2)]);
var _ = (function (){var statearr_27469 = state_27435;
(statearr_27469[(4)] = cljs.core.rest((state_27435[(4)])));

return statearr_27469;
})();
var state_27435__$1 = state_27435;
var statearr_27470_27531 = state_27435__$1;
(statearr_27470_27531[(2)] = inst_27430);

(statearr_27470_27531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (17))){
var inst_27363 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_27435__$1 = state_27435;
if(inst_27363){
var statearr_27471_27532 = state_27435__$1;
(statearr_27471_27532[(1)] = (19));

} else {
var statearr_27472_27533 = state_27435__$1;
(statearr_27472_27533[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (3))){
var inst_27433 = (state_27435[(2)]);
var state_27435__$1 = state_27435;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27435__$1,inst_27433);
} else {
if((state_val_27436 === (12))){
var inst_27343 = (state_27435[(2)]);
var state_27435__$1 = state_27435;
var statearr_27473_27534 = state_27435__$1;
(statearr_27473_27534[(2)] = inst_27343);

(statearr_27473_27534[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (2))){
var _ = (function (){var statearr_27474 = state_27435;
(statearr_27474[(4)] = cljs.core.cons((5),(state_27435[(4)])));

return statearr_27474;
})();
var inst_27330 = typeof ident === 'number';
var state_27435__$1 = state_27435;
if(cljs.core.truth_(inst_27330)){
var statearr_27475_27535 = state_27435__$1;
(statearr_27475_27535[(1)] = (6));

} else {
var statearr_27476_27536 = state_27435__$1;
(statearr_27476_27536[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (23))){
var state_27435__$1 = state_27435;
var statearr_27477_27537 = state_27435__$1;
(statearr_27477_27537[(2)] = null);

(statearr_27477_27537[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (35))){
var state_27435__$1 = state_27435;
var statearr_27478_27538 = state_27435__$1;
(statearr_27478_27538[(2)] = strict_QMARK_);

(statearr_27478_27538[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (19))){
var inst_27366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27367 = cljs.core.first(ident);
var inst_27368 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27367);
var inst_27369 = cljs.core.second(ident);
var inst_27370 = [inst_27368,inst_27369];
var inst_27371 = (new cljs.core.PersistentVector(null,2,(5),inst_27366,inst_27370,null));
var inst_27372 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27371);
var state_27435__$1 = state_27435;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27435__$1,(22),inst_27372);
} else {
if((state_val_27436 === (11))){
var state_27435__$1 = state_27435;
var statearr_27480_27539 = state_27435__$1;
(statearr_27480_27539[(2)] = null);

(statearr_27480_27539[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (9))){
var inst_27337 = (state_27435[(2)]);
var inst_27338 = fluree.db.util.async.throw_err(inst_27337);
var inst_27339 = cljs.core.not_empty(inst_27338);
var state_27435__$1 = state_27435;
if(cljs.core.truth_(inst_27339)){
var statearr_27481_27540 = state_27435__$1;
(statearr_27481_27540[(1)] = (10));

} else {
var statearr_27482_27541 = state_27435__$1;
(statearr_27482_27541[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (5))){
var _ = (function (){var statearr_27483 = state_27435;
(statearr_27483[(4)] = cljs.core.rest((state_27435[(4)])));

return statearr_27483;
})();
var state_27435__$1 = state_27435;
var ex27479 = (state_27435__$1[(2)]);
var statearr_27484_27542 = state_27435__$1;
(statearr_27484_27542[(5)] = ex27479);


var statearr_27485_27543 = state_27435__$1;
(statearr_27485_27543[(1)] = (4));

(statearr_27485_27543[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (14))){
var inst_27345 = (state_27435[(7)]);
var state_27435__$1 = state_27435;
var statearr_27486_27544 = state_27435__$1;
(statearr_27486_27544[(2)] = inst_27345);

(statearr_27486_27544[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (26))){
var state_27435__$1 = state_27435;
var statearr_27487_27545 = state_27435__$1;
(statearr_27487_27545[(2)] = null);

(statearr_27487_27545[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (16))){
var inst_27354 = cljs.core.first(ident);
var inst_27355 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27354], 0));
var inst_27356 = ["Subject ID lookup failed. The predicate ",inst_27355," does not exist."].join('');
var inst_27357 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27358 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27359 = cljs.core.PersistentHashMap.fromArrays(inst_27357,inst_27358);
var inst_27360 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27356,inst_27359);
var inst_27361 = (function(){throw inst_27360})();
var state_27435__$1 = state_27435;
var statearr_27488_27546 = state_27435__$1;
(statearr_27488_27546[(2)] = inst_27361);

(statearr_27488_27546[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (38))){
var inst_27415 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27416 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27417 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27418 = cljs.core.PersistentHashMap.fromArrays(inst_27416,inst_27417);
var inst_27419 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27415,inst_27418);
var inst_27420 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27419);
var state_27435__$1 = state_27435;
var statearr_27489_27547 = state_27435__$1;
(statearr_27489_27547[(2)] = inst_27420);

(statearr_27489_27547[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (30))){
var state_27435__$1 = state_27435;
var statearr_27490_27548 = state_27435__$1;
(statearr_27490_27548[(2)] = null);

(statearr_27490_27548[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (10))){
var state_27435__$1 = state_27435;
var statearr_27491_27549 = state_27435__$1;
(statearr_27491_27549[(2)] = ident);

(statearr_27491_27549[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (18))){
var inst_27403 = (state_27435[(2)]);
var state_27435__$1 = state_27435;
var statearr_27492_27550 = state_27435__$1;
(statearr_27492_27550[(2)] = inst_27403);

(statearr_27492_27550[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (42))){
var state_27435__$1 = state_27435;
var statearr_27493_27551 = state_27435__$1;
(statearr_27493_27551[(2)] = null);

(statearr_27493_27551[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (37))){
var inst_27413 = (state_27435[(2)]);
var state_27435__$1 = state_27435;
if(cljs.core.truth_(inst_27413)){
var statearr_27494_27552 = state_27435__$1;
(statearr_27494_27552[(1)] = (38));

} else {
var statearr_27495_27553 = state_27435__$1;
(statearr_27495_27553[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27436 === (8))){
var inst_27405 = (state_27435[(10)]);
var inst_27405__$1 = (state_27435[(2)]);
var state_27435__$1 = (function (){var statearr_27496 = state_27435;
(statearr_27496[(10)] = inst_27405__$1);

return statearr_27496;
})();
if(cljs.core.truth_(inst_27405__$1)){
var statearr_27497_27554 = state_27435__$1;
(statearr_27497_27554[(1)] = (32));

} else {
var statearr_27498_27555 = state_27435__$1;
(statearr_27498_27555[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2727__auto____0 = (function (){
var statearr_27499 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27499[(0)] = fluree$db$graphdb$subid_$_state_machine__2727__auto__);

(statearr_27499[(1)] = (1));

return statearr_27499;
});
var fluree$db$graphdb$subid_$_state_machine__2727__auto____1 = (function (state_27435){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27435);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27500){var ex__2730__auto__ = e27500;
var statearr_27501_27556 = state_27435;
(statearr_27501_27556[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27435[(4)]))){
var statearr_27502_27557 = state_27435;
(statearr_27502_27557[(1)] = cljs.core.first((state_27435[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27558 = state_27435;
state_27435 = G__27558;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2727__auto__ = function(state_27435){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2727__auto____1.call(this,state_27435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2727__auto____0;
fluree$db$graphdb$subid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2727__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27503 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27503[(6)] = c__2749__auto___27504);

return statearr_27503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__27559){
var map__27560 = p__27559;
var map__27560__$1 = cljs.core.__destructure_map(map__27560);
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27560__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27560__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27576){
var state_val_27577 = (state_27576[(1)]);
if((state_val_27577 === (1))){
var state_27576__$1 = state_27576;
var statearr_27578_27592 = state_27576__$1;
(statearr_27578_27592[(2)] = null);

(statearr_27578_27592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27577 === (2))){
var _ = (function (){var statearr_27579 = state_27576;
(statearr_27579[(4)] = cljs.core.cons((5),(state_27576[(4)])));

return statearr_27579;
})();
var inst_27567 = (current_db_fn.cljs$core$IFn$_invoke$arity$0 ? current_db_fn.cljs$core$IFn$_invoke$arity$0() : current_db_fn.call(null));
var state_27576__$1 = state_27576;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27576__$1,(6),inst_27567);
} else {
if((state_val_27577 === (3))){
var inst_27574 = (state_27576[(2)]);
var state_27576__$1 = state_27576;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27576__$1,inst_27574);
} else {
if((state_val_27577 === (4))){
var inst_27561 = (state_27576[(2)]);
var state_27576__$1 = state_27576;
var statearr_27581_27593 = state_27576__$1;
(statearr_27581_27593[(2)] = inst_27561);

(statearr_27581_27593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27577 === (5))){
var _ = (function (){var statearr_27582 = state_27576;
(statearr_27582[(4)] = cljs.core.rest((state_27576[(4)])));

return statearr_27582;
})();
var state_27576__$1 = state_27576;
var ex27580 = (state_27576__$1[(2)]);
var statearr_27583_27594 = state_27576__$1;
(statearr_27583_27594[(5)] = ex27580);


if((ex27580 instanceof Error)){
var statearr_27584_27595 = state_27576__$1;
(statearr_27584_27595[(1)] = (4));

(statearr_27584_27595[(5)] = null);

} else {
throw ex27580;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27577 === (6))){
var inst_27569 = (state_27576[(2)]);
var inst_27570 = fluree.db.util.async.throw_err(inst_27569);
var inst_27571 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27570,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_27585 = state_27576;
(statearr_27585[(4)] = cljs.core.rest((state_27576[(4)])));

return statearr_27585;
})();
var state_27576__$1 = state_27576;
var statearr_27586_27596 = state_27576__$1;
(statearr_27586_27596[(2)] = inst_27571);

(statearr_27586_27596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0 = (function (){
var statearr_27587 = [null,null,null,null,null,null,null];
(statearr_27587[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__);

(statearr_27587[(1)] = (1));

return statearr_27587;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1 = (function (state_27576){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27576);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27588){var ex__2730__auto__ = e27588;
var statearr_27589_27597 = state_27576;
(statearr_27589_27597[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27576[(4)]))){
var statearr_27590_27598 = state_27576;
(statearr_27590_27598[(1)] = cljs.core.first((state_27576[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27599 = state_27576;
state_27576 = G__27599;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__ = function(state_27576){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1.call(this,state_27576);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27591 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27591[(6)] = c__2749__auto__);

return statearr_27591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__27600,property,collection){
var map__27601 = p__27600;
var map__27601__$1 = cljs.core.__destructure_map(map__27601);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27601__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__27602 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__27602.cljs$core$IFn$_invoke$arity$1 ? fexpr__27602.cljs$core$IFn$_invoke$arity$1(property) : fexpr__27602.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__27603,property,predicate){
var map__27604 = p__27603;
var map__27604__$1 = cljs.core.__destructure_map(map__27604);
var this$ = map__27604__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27604__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__27605 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__27605.cljs$core$IFn$_invoke$arity$1 ? fexpr__27605.cljs$core$IFn$_invoke$arity$1(property) : fexpr__27605.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__27606 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop(this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__27606);
} else {
return G__27606;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__27608 = arguments.length;
switch (G__27608) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27640){
var state_val_27641 = (state_27640[(1)]);
if((state_val_27641 === (7))){
var state_27640__$1 = state_27640;
var statearr_27642_27736 = state_27640__$1;
(statearr_27642_27736[(2)] = null);

(statearr_27642_27736[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27641 === (1))){
var state_27640__$1 = state_27640;
var statearr_27643_27737 = state_27640__$1;
(statearr_27643_27737[(2)] = null);

(statearr_27643_27737[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27641 === (4))){
var inst_27609 = (state_27640[(2)]);
var state_27640__$1 = state_27640;
var statearr_27644_27738 = state_27640__$1;
(statearr_27644_27738[(2)] = inst_27609);

(statearr_27644_27738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27641 === (6))){
var inst_27623 = (state_27640[(7)]);
var inst_27622 = (state_27640[(2)]);
var inst_27623__$1 = fluree.db.util.async.throw_err(inst_27622);
var inst_27624 = (inst_27623__$1 == null);
var state_27640__$1 = (function (){var statearr_27645 = state_27640;
(statearr_27645[(7)] = inst_27623__$1);

return statearr_27645;
})();
if(cljs.core.truth_(inst_27624)){
var statearr_27646_27739 = state_27640__$1;
(statearr_27646_27739[(1)] = (7));

} else {
var statearr_27647_27740 = state_27640__$1;
(statearr_27647_27740[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27641 === (3))){
var inst_27638 = (state_27640[(2)]);
var state_27640__$1 = state_27640;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27640__$1,inst_27638);
} else {
if((state_val_27641 === (12))){
var inst_27635 = (state_27640[(2)]);
var _ = (function (){var statearr_27648 = state_27640;
(statearr_27648[(4)] = cljs.core.rest((state_27640[(4)])));

return statearr_27648;
})();
var state_27640__$1 = state_27640;
var statearr_27649_27741 = state_27640__$1;
(statearr_27649_27741[(2)] = inst_27635);

(statearr_27649_27741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27641 === (2))){
var _ = (function (){var statearr_27650 = state_27640;
(statearr_27650[(4)] = cljs.core.cons((5),(state_27640[(4)])));

return statearr_27650;
})();
var inst_27616 = fluree.db.dbproto._rootdb(this$);
var inst_27617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27618 = [tag_id,(30)];
var inst_27619 = (new cljs.core.PersistentVector(null,2,(5),inst_27617,inst_27618,null));
var inst_27620 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_27616,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27619);
var state_27640__$1 = state_27640;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27640__$1,(6),inst_27620);
} else {
if((state_val_27641 === (11))){
var inst_27629 = (state_27640[(8)]);
var inst_27633 = inst_27629.o;
var state_27640__$1 = state_27640;
var statearr_27652_27742 = state_27640__$1;
(statearr_27652_27742[(2)] = inst_27633);

(statearr_27652_27742[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27641 === (9))){
var inst_27629 = (state_27640[(8)]);
var inst_27629__$1 = (state_27640[(2)]);
var inst_27630 = (inst_27629__$1 == null);
var state_27640__$1 = (function (){var statearr_27653 = state_27640;
(statearr_27653[(8)] = inst_27629__$1);

return statearr_27653;
})();
if(cljs.core.truth_(inst_27630)){
var statearr_27654_27743 = state_27640__$1;
(statearr_27654_27743[(1)] = (10));

} else {
var statearr_27655_27744 = state_27640__$1;
(statearr_27655_27744[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27641 === (5))){
var _ = (function (){var statearr_27656 = state_27640;
(statearr_27656[(4)] = cljs.core.rest((state_27640[(4)])));

return statearr_27656;
})();
var state_27640__$1 = state_27640;
var ex27651 = (state_27640__$1[(2)]);
var statearr_27657_27745 = state_27640__$1;
(statearr_27657_27745[(5)] = ex27651);


if((ex27651 instanceof Error)){
var statearr_27658_27746 = state_27640__$1;
(statearr_27658_27746[(1)] = (4));

(statearr_27658_27746[(5)] = null);

} else {
throw ex27651;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27641 === (10))){
var state_27640__$1 = state_27640;
var statearr_27659_27747 = state_27640__$1;
(statearr_27659_27747[(2)] = null);

(statearr_27659_27747[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27641 === (8))){
var inst_27623 = (state_27640[(7)]);
var inst_27627 = cljs.core.first(inst_27623);
var state_27640__$1 = state_27640;
var statearr_27660_27748 = state_27640__$1;
(statearr_27660_27748[(2)] = inst_27627);

(statearr_27660_27748[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_27661 = [null,null,null,null,null,null,null,null,null];
(statearr_27661[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_27661[(1)] = (1));

return statearr_27661;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_27640){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27640);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27662){var ex__2730__auto__ = e27662;
var statearr_27663_27749 = state_27640;
(statearr_27663_27749[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27640[(4)]))){
var statearr_27664_27750 = state_27640;
(statearr_27664_27750[(1)] = cljs.core.first((state_27640[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27751 = state_27640;
state_27640 = G__27751;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_27640){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_27640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27665 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27665[(6)] = c__2749__auto__);

return statearr_27665;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27701){
var state_val_27702 = (state_27701[(1)]);
if((state_val_27702 === (7))){
var inst_27675 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27701__$1 = state_27701;
var statearr_27703_27752 = state_27701__$1;
(statearr_27703_27752[(2)] = inst_27675);

(statearr_27703_27752[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27702 === (1))){
var state_27701__$1 = state_27701;
var statearr_27704_27753 = state_27701__$1;
(statearr_27704_27753[(2)] = null);

(statearr_27704_27753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27702 === (4))){
var inst_27666 = (state_27701[(2)]);
var state_27701__$1 = state_27701;
var statearr_27705_27754 = state_27701__$1;
(statearr_27705_27754[(2)] = inst_27666);

(statearr_27705_27754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27702 === (15))){
var inst_27696 = (state_27701[(2)]);
var _ = (function (){var statearr_27706 = state_27701;
(statearr_27706[(4)] = cljs.core.rest((state_27701[(4)])));

return statearr_27706;
})();
var state_27701__$1 = state_27701;
var statearr_27707_27755 = state_27701__$1;
(statearr_27707_27755[(2)] = inst_27696);

(statearr_27707_27755[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27702 === (13))){
var inst_27681 = (state_27701[(7)]);
var inst_27687 = clojure.string.includes_QMARK_(inst_27681,":");
var state_27701__$1 = state_27701;
if(inst_27687){
var statearr_27708_27756 = state_27701__$1;
(statearr_27708_27756[(1)] = (16));

} else {
var statearr_27709_27757 = state_27701__$1;
(statearr_27709_27757[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27702 === (6))){
var state_27701__$1 = state_27701;
var statearr_27710_27758 = state_27701__$1;
(statearr_27710_27758[(2)] = pred);

(statearr_27710_27758[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27702 === (17))){
var inst_27681 = (state_27701[(7)]);
var state_27701__$1 = state_27701;
var statearr_27711_27759 = state_27701__$1;
(statearr_27711_27759[(2)] = inst_27681);

(statearr_27711_27759[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27702 === (3))){
var inst_27699 = (state_27701[(2)]);
var state_27701__$1 = state_27701;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27701__$1,inst_27699);
} else {
if((state_val_27702 === (12))){
var inst_27685 = (state_27701[(2)]);
var state_27701__$1 = state_27701;
if(cljs.core.truth_(inst_27685)){
var statearr_27712_27760 = state_27701__$1;
(statearr_27712_27760[(1)] = (13));

} else {
var statearr_27713_27761 = state_27701__$1;
(statearr_27713_27761[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27702 === (2))){
var _ = (function (){var statearr_27714 = state_27701;
(statearr_27714[(4)] = cljs.core.cons((5),(state_27701[(4)])));

return statearr_27714;
})();
var inst_27672 = typeof pred === 'string';
var state_27701__$1 = state_27701;
if(cljs.core.truth_(inst_27672)){
var statearr_27715_27762 = state_27701__$1;
(statearr_27715_27762[(1)] = (6));

} else {
var statearr_27716_27763 = state_27701__$1;
(statearr_27716_27763[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27702 === (11))){
var inst_27677 = (state_27701[(8)]);
var state_27701__$1 = state_27701;
var statearr_27718_27764 = state_27701__$1;
(statearr_27718_27764[(2)] = inst_27677);

(statearr_27718_27764[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27702 === (9))){
var inst_27677 = (state_27701[(8)]);
var inst_27680 = (state_27701[(2)]);
var inst_27681 = fluree.db.util.async.throw_err(inst_27680);
var state_27701__$1 = (function (){var statearr_27719 = state_27701;
(statearr_27719[(7)] = inst_27681);

return statearr_27719;
})();
if(cljs.core.truth_(inst_27677)){
var statearr_27720_27765 = state_27701__$1;
(statearr_27720_27765[(1)] = (10));

} else {
var statearr_27721_27766 = state_27701__$1;
(statearr_27721_27766[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27702 === (5))){
var _ = (function (){var statearr_27722 = state_27701;
(statearr_27722[(4)] = cljs.core.rest((state_27701[(4)])));

return statearr_27722;
})();
var state_27701__$1 = state_27701;
var ex27717 = (state_27701__$1[(2)]);
var statearr_27723_27767 = state_27701__$1;
(statearr_27723_27767[(5)] = ex27717);


if((ex27717 instanceof Error)){
var statearr_27724_27768 = state_27701__$1;
(statearr_27724_27768[(1)] = (4));

(statearr_27724_27768[(5)] = null);

} else {
throw ex27717;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27702 === (14))){
var state_27701__$1 = state_27701;
var statearr_27725_27769 = state_27701__$1;
(statearr_27725_27769[(2)] = null);

(statearr_27725_27769[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27702 === (16))){
var inst_27681 = (state_27701[(7)]);
var inst_27689 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_27681,/:/);
var inst_27690 = cljs.core.second(inst_27689);
var state_27701__$1 = state_27701;
var statearr_27726_27770 = state_27701__$1;
(statearr_27726_27770[(2)] = inst_27690);

(statearr_27726_27770[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27702 === (10))){
var inst_27681 = (state_27701[(7)]);
var state_27701__$1 = state_27701;
var statearr_27727_27771 = state_27701__$1;
(statearr_27727_27771[(2)] = inst_27681);

(statearr_27727_27771[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27702 === (18))){
var inst_27693 = (state_27701[(2)]);
var state_27701__$1 = state_27701;
var statearr_27728_27772 = state_27701__$1;
(statearr_27728_27772[(2)] = inst_27693);

(statearr_27728_27772[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27702 === (8))){
var inst_27677 = (state_27701[(2)]);
var inst_27678 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_27701__$1 = (function (){var statearr_27729 = state_27701;
(statearr_27729[(8)] = inst_27677);

return statearr_27729;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27701__$1,(9),inst_27678);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_27730 = [null,null,null,null,null,null,null,null,null];
(statearr_27730[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_27730[(1)] = (1));

return statearr_27730;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_27701){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27701);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27731){var ex__2730__auto__ = e27731;
var statearr_27732_27773 = state_27701;
(statearr_27732_27773[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27701[(4)]))){
var statearr_27733_27774 = state_27701;
(statearr_27733_27774[(1)] = cljs.core.first((state_27701[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27775 = state_27701;
state_27701 = G__27775;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_27701){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_27701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27734 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27734[(6)] = c__2749__auto__);

return statearr_27734;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__27777 = arguments.length;
switch (G__27777) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27810){
var state_val_27811 = (state_27810[(1)]);
if((state_val_27811 === (7))){
var state_27810__$1 = state_27810;
var statearr_27812_27900 = state_27810__$1;
(statearr_27812_27900[(2)] = null);

(statearr_27812_27900[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27811 === (1))){
var state_27810__$1 = state_27810;
var statearr_27813_27901 = state_27810__$1;
(statearr_27813_27901[(2)] = null);

(statearr_27813_27901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27811 === (4))){
var inst_27778 = (state_27810[(2)]);
var state_27810__$1 = state_27810;
var statearr_27814_27902 = state_27810__$1;
(statearr_27814_27902[(2)] = inst_27778);

(statearr_27814_27902[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27811 === (6))){
var inst_27793 = (state_27810[(7)]);
var inst_27792 = (state_27810[(2)]);
var inst_27793__$1 = fluree.db.util.async.throw_err(inst_27792);
var inst_27794 = (inst_27793__$1 == null);
var state_27810__$1 = (function (){var statearr_27815 = state_27810;
(statearr_27815[(7)] = inst_27793__$1);

return statearr_27815;
})();
if(cljs.core.truth_(inst_27794)){
var statearr_27816_27903 = state_27810__$1;
(statearr_27816_27903[(1)] = (7));

} else {
var statearr_27817_27904 = state_27810__$1;
(statearr_27817_27904[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27811 === (3))){
var inst_27808 = (state_27810[(2)]);
var state_27810__$1 = state_27810;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27810__$1,inst_27808);
} else {
if((state_val_27811 === (12))){
var inst_27805 = (state_27810[(2)]);
var _ = (function (){var statearr_27818 = state_27810;
(statearr_27818[(4)] = cljs.core.rest((state_27810[(4)])));

return statearr_27818;
})();
var state_27810__$1 = state_27810;
var statearr_27819_27905 = state_27810__$1;
(statearr_27819_27905[(2)] = inst_27805);

(statearr_27819_27905[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27811 === (2))){
var _ = (function (){var statearr_27820 = state_27810;
(statearr_27820[(4)] = cljs.core.cons((5),(state_27810[(4)])));

return statearr_27820;
})();
var inst_27784 = (30);
var inst_27786 = fluree.db.dbproto._rootdb(this$);
var inst_27787 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27788 = [inst_27784,tag_name];
var inst_27789 = (new cljs.core.PersistentVector(null,2,(5),inst_27787,inst_27788,null));
var inst_27790 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_27786,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27789);
var state_27810__$1 = state_27810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27810__$1,(6),inst_27790);
} else {
if((state_val_27811 === (11))){
var inst_27799 = (state_27810[(8)]);
var inst_27803 = inst_27799.s;
var state_27810__$1 = state_27810;
var statearr_27822_27906 = state_27810__$1;
(statearr_27822_27906[(2)] = inst_27803);

(statearr_27822_27906[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27811 === (9))){
var inst_27799 = (state_27810[(8)]);
var inst_27799__$1 = (state_27810[(2)]);
var inst_27800 = (inst_27799__$1 == null);
var state_27810__$1 = (function (){var statearr_27823 = state_27810;
(statearr_27823[(8)] = inst_27799__$1);

return statearr_27823;
})();
if(cljs.core.truth_(inst_27800)){
var statearr_27824_27907 = state_27810__$1;
(statearr_27824_27907[(1)] = (10));

} else {
var statearr_27825_27908 = state_27810__$1;
(statearr_27825_27908[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27811 === (5))){
var _ = (function (){var statearr_27826 = state_27810;
(statearr_27826[(4)] = cljs.core.rest((state_27810[(4)])));

return statearr_27826;
})();
var state_27810__$1 = state_27810;
var ex27821 = (state_27810__$1[(2)]);
var statearr_27827_27909 = state_27810__$1;
(statearr_27827_27909[(5)] = ex27821);


if((ex27821 instanceof Error)){
var statearr_27828_27910 = state_27810__$1;
(statearr_27828_27910[(1)] = (4));

(statearr_27828_27910[(5)] = null);

} else {
throw ex27821;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27811 === (10))){
var state_27810__$1 = state_27810;
var statearr_27829_27911 = state_27810__$1;
(statearr_27829_27911[(2)] = null);

(statearr_27829_27911[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27811 === (8))){
var inst_27793 = (state_27810[(7)]);
var inst_27797 = cljs.core.first(inst_27793);
var state_27810__$1 = state_27810;
var statearr_27830_27912 = state_27810__$1;
(statearr_27830_27912[(2)] = inst_27797);

(statearr_27830_27912[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_27831 = [null,null,null,null,null,null,null,null,null];
(statearr_27831[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_27831[(1)] = (1));

return statearr_27831;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_27810){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27810);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27832){var ex__2730__auto__ = e27832;
var statearr_27833_27913 = state_27810;
(statearr_27833_27913[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27810[(4)]))){
var statearr_27834_27914 = state_27810;
(statearr_27834_27914[(1)] = cljs.core.first((state_27810[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27915 = state_27810;
state_27810 = G__27915;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_27810){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_27810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27835 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27835[(6)] = c__2749__auto__);

return statearr_27835;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27870){
var state_val_27871 = (state_27870[(1)]);
if((state_val_27871 === (7))){
var inst_27849 = typeof pred === 'string';
var state_27870__$1 = state_27870;
if(cljs.core.truth_(inst_27849)){
var statearr_27872_27916 = state_27870__$1;
(statearr_27872_27916[(1)] = (10));

} else {
var statearr_27873_27917 = state_27870__$1;
(statearr_27873_27917[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (1))){
var state_27870__$1 = state_27870;
var statearr_27874_27918 = state_27870__$1;
(statearr_27874_27918[(2)] = null);

(statearr_27874_27918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (4))){
var inst_27836 = (state_27870[(2)]);
var state_27870__$1 = state_27870;
var statearr_27875_27919 = state_27870__$1;
(statearr_27875_27919[(2)] = inst_27836);

(statearr_27875_27919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (15))){
var inst_27863 = (state_27870[(2)]);
var state_27870__$1 = state_27870;
var statearr_27876_27920 = state_27870__$1;
(statearr_27876_27920[(2)] = inst_27863);

(statearr_27876_27920[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (13))){
var inst_27854 = (state_27870[(7)]);
var inst_27856 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27854),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_27857 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_27856);
var state_27870__$1 = state_27870;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27870__$1,(16),inst_27857);
} else {
if((state_val_27871 === (6))){
var inst_27844 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_27870__$1 = state_27870;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27870__$1,(9),inst_27844);
} else {
if((state_val_27871 === (3))){
var inst_27868 = (state_27870[(2)]);
var state_27870__$1 = state_27870;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27870__$1,inst_27868);
} else {
if((state_val_27871 === (12))){
var inst_27854 = (state_27870[(7)]);
var inst_27854__$1 = (state_27870[(2)]);
var state_27870__$1 = (function (){var statearr_27877 = state_27870;
(statearr_27877[(7)] = inst_27854__$1);

return statearr_27877;
})();
if(cljs.core.truth_(inst_27854__$1)){
var statearr_27878_27921 = state_27870__$1;
(statearr_27878_27921[(1)] = (13));

} else {
var statearr_27879_27922 = state_27870__$1;
(statearr_27879_27922[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (2))){
var _ = (function (){var statearr_27880 = state_27870;
(statearr_27880[(4)] = cljs.core.cons((5),(state_27870[(4)])));

return statearr_27880;
})();
var inst_27842 = clojure.string.includes_QMARK_(tag_name,"/");
var state_27870__$1 = state_27870;
if(inst_27842){
var statearr_27881_27923 = state_27870__$1;
(statearr_27881_27923[(1)] = (6));

} else {
var statearr_27882_27924 = state_27870__$1;
(statearr_27882_27924[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (11))){
var inst_27852 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27870__$1 = state_27870;
var statearr_27884_27925 = state_27870__$1;
(statearr_27884_27925[(2)] = inst_27852);

(statearr_27884_27925[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (9))){
var inst_27846 = (state_27870[(2)]);
var inst_27847 = fluree.db.util.async.throw_err(inst_27846);
var state_27870__$1 = state_27870;
var statearr_27885_27926 = state_27870__$1;
(statearr_27885_27926[(2)] = inst_27847);

(statearr_27885_27926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (5))){
var _ = (function (){var statearr_27886 = state_27870;
(statearr_27886[(4)] = cljs.core.rest((state_27870[(4)])));

return statearr_27886;
})();
var state_27870__$1 = state_27870;
var ex27883 = (state_27870__$1[(2)]);
var statearr_27887_27927 = state_27870__$1;
(statearr_27887_27927[(5)] = ex27883);


if((ex27883 instanceof Error)){
var statearr_27888_27928 = state_27870__$1;
(statearr_27888_27928[(1)] = (4));

(statearr_27888_27928[(5)] = null);

} else {
throw ex27883;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (14))){
var state_27870__$1 = state_27870;
var statearr_27889_27929 = state_27870__$1;
(statearr_27889_27929[(2)] = null);

(statearr_27889_27929[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (16))){
var inst_27859 = (state_27870[(2)]);
var inst_27860 = fluree.db.util.async.throw_err(inst_27859);
var state_27870__$1 = state_27870;
var statearr_27890_27930 = state_27870__$1;
(statearr_27890_27930[(2)] = inst_27860);

(statearr_27890_27930[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (10))){
var state_27870__$1 = state_27870;
var statearr_27891_27931 = state_27870__$1;
(statearr_27891_27931[(2)] = pred);

(statearr_27891_27931[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (8))){
var inst_27865 = (state_27870[(2)]);
var _ = (function (){var statearr_27892 = state_27870;
(statearr_27892[(4)] = cljs.core.rest((state_27870[(4)])));

return statearr_27892;
})();
var state_27870__$1 = state_27870;
var statearr_27893_27932 = state_27870__$1;
(statearr_27893_27932[(2)] = inst_27865);

(statearr_27893_27932[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_27894 = [null,null,null,null,null,null,null,null];
(statearr_27894[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_27894[(1)] = (1));

return statearr_27894;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_27870){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27870);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27895){var ex__2730__auto__ = e27895;
var statearr_27896_27933 = state_27870;
(statearr_27896_27933[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27870[(4)]))){
var statearr_27897_27934 = state_27870;
(statearr_27897_27934[(1)] = cljs.core.first((state_27870[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27935 = state_27870;
state_27870 = G__27935;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_27870){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_27870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27898 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27898[(6)] = c__2749__auto__);

return statearr_27898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k27937,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__27941 = k27937;
var G__27941__$1 = (((G__27941 instanceof cljs.core.Keyword))?G__27941.fqn:null);
switch (G__27941__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27937,else__4505__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__27942){
var vec__27943 = p__27942;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27943,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27943,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27936){
var self__ = this;
var G__27936__$1 = this;
return (new cljs.core.RecordIter((0),G__27936__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__27946 = (function (coll__4499__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__27946(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27938,other27939){
var self__ = this;
var this27938__$1 = this;
return (((!((other27939 == null)))) && ((((this27938__$1.constructor === other27939.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.conn,other27939.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.network,other27939.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.dbid,other27939.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.block,other27939.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.t,other27939.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.tt_id,other27939.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.stats,other27939.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.spot,other27939.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.psot,other27939.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.post,other27939.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.opst,other27939.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.schema,other27939.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.settings,other27939.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.index_configs,other27939.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.schema_cache,other27939.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.novelty,other27939.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.permissions,other27939.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.fork,other27939.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.fork_block,other27939.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.current_db_fn,other27939.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27938__$1.__extmap,other27939.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k27937){
var self__ = this;
var this__4509__auto____$1 = this;
var G__27947 = k27937;
var G__27947__$1 = (((G__27947 instanceof cljs.core.Keyword))?G__27947.fqn:null);
switch (G__27947__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k27937);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__27936){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__27948 = cljs.core.keyword_identical_QMARK_;
var expr__27949 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__27951 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27952 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27951,G__27952) : pred__27948.call(null,G__27951,G__27952));
})())){
return (new fluree.db.graphdb.GraphDb(G__27936,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27953 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27954 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27953,G__27954) : pred__27948.call(null,G__27953,G__27954));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__27936,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27955 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__27956 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27955,G__27956) : pred__27948.call(null,G__27955,G__27956));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__27936,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27957 = new cljs.core.Keyword(null,"block","block",664686210);
var G__27958 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27957,G__27958) : pred__27948.call(null,G__27957,G__27958));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__27936,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27959 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__27960 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27959,G__27960) : pred__27948.call(null,G__27959,G__27960));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__27936,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27961 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__27962 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27961,G__27962) : pred__27948.call(null,G__27961,G__27962));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__27936,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27963 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__27964 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27963,G__27964) : pred__27948.call(null,G__27963,G__27964));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__27936,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27965 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__27966 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27965,G__27966) : pred__27948.call(null,G__27965,G__27966));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__27936,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27967 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__27968 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27967,G__27968) : pred__27948.call(null,G__27967,G__27968));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__27936,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27969 = new cljs.core.Keyword(null,"post","post",269697687);
var G__27970 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27969,G__27970) : pred__27948.call(null,G__27969,G__27970));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__27936,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27971 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__27972 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27971,G__27972) : pred__27948.call(null,G__27971,G__27972));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__27936,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27973 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__27974 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27973,G__27974) : pred__27948.call(null,G__27973,G__27974));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__27936,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27975 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__27976 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27975,G__27976) : pred__27948.call(null,G__27975,G__27976));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__27936,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27977 = new cljs.core.Keyword(null,"index-configs","index-configs",1053959280);
var G__27978 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27977,G__27978) : pred__27948.call(null,G__27977,G__27978));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__27936,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27979 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27980 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27979,G__27980) : pred__27948.call(null,G__27979,G__27980));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__27936,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27981 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__27982 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27981,G__27982) : pred__27948.call(null,G__27981,G__27982));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__27936,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27983 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__27984 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27983,G__27984) : pred__27948.call(null,G__27983,G__27984));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__27936,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27985 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__27986 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27985,G__27986) : pred__27948.call(null,G__27985,G__27986));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__27936,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27987 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__27988 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27987,G__27988) : pred__27948.call(null,G__27987,G__27988));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__27936,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27989 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__27990 = expr__27949;
return (pred__27948.cljs$core$IFn$_invoke$arity$2 ? pred__27948.cljs$core$IFn$_invoke$arity$2(G__27989,G__27990) : pred__27948.call(null,G__27989,G__27990));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__27936,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__27936),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__27936){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__27936,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__27940){
var extmap__4542__auto__ = (function (){var G__27991 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27940,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__27940)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27991);
} else {
return G__27991;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__27940),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__27940),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
