// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19993_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19993_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__19997 = coll;
var vec__19998 = G__19997;
var seq__19999 = cljs.core.seq(vec__19998);
var first__20000 = cljs.core.first(seq__19999);
var seq__19999__$1 = cljs.core.next(seq__19999);
var clause = first__20000;
var r = seq__19999__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19997__$1 = G__19997;
var res__$1 = res;
while(true){
var vec__20004 = G__19997__$1;
var seq__20005 = cljs.core.seq(vec__20004);
var first__20006 = cljs.core.first(seq__20005);
var seq__20005__$1 = cljs.core.next(seq__20005);
var clause__$1 = first__20006;
var r__$1 = seq__20005__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__20007 = r__$1;
var G__20008 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__19997__$1 = G__20007;
res__$1 = G__20008;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__20009){
var map__20010 = p__20009;
var map__20010__$1 = cljs.core.__destructure_map(map__20010);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20010__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__20014 = coll;
var vec__20015 = G__20014;
var seq__20016 = cljs.core.seq(vec__20015);
var first__20017 = cljs.core.first(seq__20016);
var seq__20016__$1 = cljs.core.next(seq__20016);
var clause = first__20017;
var r = seq__20016__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__20014__$1 = G__20014;
var res__$1 = res;
while(true){
var vec__20021 = G__20014__$1;
var seq__20022 = cljs.core.seq(vec__20021);
var first__20023 = cljs.core.first(seq__20022);
var seq__20022__$1 = cljs.core.next(seq__20022);
var clause__$1 = first__20023;
var r__$1 = seq__20022__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__20024 = r__$1;
var G__20025 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__20014__$1 = G__20024;
res__$1 = G__20025;
continue;
} else {
var G__20026 = r__$1;
var G__20027 = res__$2;
G__20014__$1 = G__20026;
res__$1 = G__20027;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__20031 = coll;
var vec__20032 = G__20031;
var seq__20033 = cljs.core.seq(vec__20032);
var first__20034 = cljs.core.first(seq__20033);
var seq__20033__$1 = cljs.core.next(seq__20033);
var clause = first__20034;
var r = seq__20033__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__20031__$1 = G__20031;
var res__$1 = res;
while(true){
var vec__20038 = G__20031__$1;
var seq__20039 = cljs.core.seq(vec__20038);
var first__20040 = cljs.core.first(seq__20039);
var seq__20039__$1 = cljs.core.next(seq__20039);
var clause__$1 = first__20040;
var r__$1 = seq__20039__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__20041 = r__$1;
var G__20042 = res__$2;
G__20031__$1 = G__20041;
res__$1 = G__20042;
continue;
} else {
var G__20043 = r__$1;
var G__20044 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__20031__$1 = G__20043;
res__$1 = G__20044;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__20047 = clause;
var G__20047__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__20047):G__20047);
var G__20047__$2 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__20047__$1)
;
var G__20047__$3 = (function (){var fexpr__20048 = (function (p1__20045_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20045_SHARP_)," ."].join('');
});
return fexpr__20048(G__20047__$2);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__20049 = (function (p1__20046_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20046_SHARP_),"}"].join('');
});
return fexpr__20049(G__20047__$3);
} else {
return G__20047__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__20053 = opts;
var map__20053__$1 = cljs.core.__destructure_map(map__20053);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20053__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20053__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20053__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20053__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20053__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20050_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20050_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__20051_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__20051_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__20052_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__20052_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = language;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20067){
var state_val_20068 = (state_20067[(1)]);
if((state_val_20068 === (1))){
var inst_20054 = fluree.db.util.core.url_encode(query);
var inst_20055 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20054)].join('');
var inst_20056 = ["User-Agent","Accept"];
var inst_20057 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_20058 = cljs.core.PersistentHashMap.fromArrays(inst_20056,inst_20057);
var inst_20059 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_20060 = [inst_20058,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_20061 = cljs.core.PersistentHashMap.fromArrays(inst_20059,inst_20060);
var inst_20062 = fluree.db.util.xhttp.get(inst_20055,inst_20061);
var state_20067__$1 = state_20067;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20067__$1,(2),inst_20062);
} else {
if((state_val_20068 === (2))){
var inst_20064 = (state_20067[(2)]);
var inst_20065 = fluree.db.util.async.throw_err(inst_20064);
var state_20067__$1 = state_20067;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20067__$1,inst_20065);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0 = (function (){
var statearr_20069 = [null,null,null,null,null,null,null];
(statearr_20069[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__);

(statearr_20069[(1)] = (1));

return statearr_20069;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1 = (function (state_20067){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20067);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20070){var ex__2730__auto__ = e20070;
var statearr_20071_20074 = state_20067;
(statearr_20071_20074[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20067[(4)]))){
var statearr_20072_20075 = state_20067;
(statearr_20072_20075[(1)] = cljs.core.first((state_20067[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20076 = state_20067;
state_20067 = G__20076;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__ = function(state_20067){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1.call(this,state_20067);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20073 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20073[(6)] = c__2749__auto__);

return statearr_20073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20094){
var state_val_20095 = (state_20094[(1)]);
if((state_val_20095 === (1))){
var inst_20077 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_20094__$1 = state_20094;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20094__$1,(2),inst_20077);
} else {
if((state_val_20095 === (2))){
var inst_20080 = (state_20094[(7)]);
var inst_20079 = (state_20094[(2)]);
var inst_20080__$1 = fluree.db.util.async.throw_err(inst_20079);
var inst_20081 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_20080__$1);
var inst_20082 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_20081);
var state_20094__$1 = (function (){var statearr_20096 = state_20094;
(statearr_20096[(7)] = inst_20080__$1);

return statearr_20096;
})();
if(inst_20082){
var statearr_20097_20106 = state_20094__$1;
(statearr_20097_20106[(1)] = (3));

} else {
var statearr_20098_20107 = state_20094__$1;
(statearr_20098_20107[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20095 === (3))){
var inst_20080 = (state_20094[(7)]);
var state_20094__$1 = state_20094;
var statearr_20099_20108 = state_20094__$1;
(statearr_20099_20108[(2)] = inst_20080);

(statearr_20099_20108[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20095 === (4))){
var inst_20080 = (state_20094[(7)]);
var inst_20085 = (function (){var body = inst_20080;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_20086 = cljs.core.second(inst_20080);
var inst_20087 = cljs.core.second(inst_20086);
var inst_20088 = cljs.core.first(inst_20087);
var inst_20089 = cljs.core.second(inst_20088);
var inst_20090 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_20085,inst_20089);
var state_20094__$1 = state_20094;
var statearr_20100_20109 = state_20094__$1;
(statearr_20100_20109[(2)] = inst_20090);

(statearr_20100_20109[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20095 === (5))){
var inst_20092 = (state_20094[(2)]);
var state_20094__$1 = state_20094;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20094__$1,inst_20092);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0 = (function (){
var statearr_20101 = [null,null,null,null,null,null,null,null];
(statearr_20101[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__);

(statearr_20101[(1)] = (1));

return statearr_20101;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1 = (function (state_20094){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20094);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20102){var ex__2730__auto__ = e20102;
var statearr_20103_20110 = state_20094;
(statearr_20103_20110[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20094[(4)]))){
var statearr_20104_20111 = state_20094;
(statearr_20104_20111[(1)] = cljs.core.first((state_20094[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20112 = state_20094;
state_20094 = G__20112;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__ = function(state_20094){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1.call(this,state_20094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20105 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20105[(6)] = c__2749__auto__);

return statearr_20105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20113_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20113_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20114_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20114_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20115_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__20115_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__20115_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__20115_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20161){
var state_val_20162 = (state_20161[(1)]);
if((state_val_20162 === (7))){
var inst_20126 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_20161__$1 = state_20161;
var statearr_20163_20191 = state_20161__$1;
(statearr_20163_20191[(2)] = inst_20126);

(statearr_20163_20191[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20162 === (1))){
var state_20161__$1 = state_20161;
var statearr_20164_20192 = state_20161__$1;
(statearr_20164_20192[(2)] = null);

(statearr_20164_20192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20162 === (4))){
var inst_20116 = (state_20161[(2)]);
var state_20161__$1 = state_20161;
var statearr_20165_20193 = state_20161__$1;
(statearr_20165_20193[(2)] = inst_20116);

(statearr_20165_20193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20162 === (15))){
var inst_20134 = (state_20161[(7)]);
var inst_20140 = (state_20161[(8)]);
var inst_20135 = (state_20161[(9)]);
var inst_20145 = (state_20161[(2)]);
var inst_20146 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_20140,(0),inst_20145);
var inst_20147 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20148 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_20134);
var inst_20149 = [inst_20135,inst_20148];
var inst_20150 = cljs.core.PersistentHashMap.fromArrays(inst_20147,inst_20149);
var inst_20151 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20146,inst_20150);
var inst_20152 = (function(){throw inst_20151})();
var state_20161__$1 = state_20161;
var statearr_20166_20194 = state_20161__$1;
(statearr_20166_20194[(2)] = inst_20152);

(statearr_20166_20194[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20162 === (13))){
var inst_20139 = (state_20161[(10)]);
var state_20161__$1 = state_20161;
var statearr_20167_20195 = state_20161__$1;
(statearr_20167_20195[(2)] = inst_20139);

(statearr_20167_20195[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20162 === (6))){
var state_20161__$1 = state_20161;
var statearr_20168_20196 = state_20161__$1;
(statearr_20168_20196[(2)] = null);

(statearr_20168_20196[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20162 === (3))){
var inst_20159 = (state_20161[(2)]);
var state_20161__$1 = state_20161;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20161__$1,inst_20159);
} else {
if((state_val_20162 === (12))){
var inst_20156 = (state_20161[(2)]);
var _ = (function (){var statearr_20169 = state_20161;
(statearr_20169[(4)] = cljs.core.rest((state_20161[(4)])));

return statearr_20169;
})();
var state_20161__$1 = state_20161;
var statearr_20170_20197 = state_20161__$1;
(statearr_20170_20197[(2)] = inst_20156);

(statearr_20170_20197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20162 === (2))){
var _ = (function (){var statearr_20171 = state_20161;
(statearr_20171[(4)] = cljs.core.cons((5),(state_20161[(4)])));

return statearr_20171;
})();
var inst_20123 = cljs.core.empty_QMARK_(matching_vars);
var state_20161__$1 = state_20161;
if(inst_20123){
var statearr_20172_20198 = state_20161__$1;
(statearr_20172_20198[(1)] = (6));

} else {
var statearr_20173_20199 = state_20161__$1;
(statearr_20173_20199[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20162 === (11))){
var inst_20134 = (state_20161[(7)]);
var inst_20154 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_20134,all_vars);
var state_20161__$1 = state_20161;
var statearr_20175_20200 = state_20161__$1;
(statearr_20175_20200[(2)] = inst_20154);

(statearr_20175_20200[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20162 === (9))){
var inst_20134 = (state_20161[(7)]);
var inst_20135 = (state_20161[(9)]);
var inst_20132 = (state_20161[(2)]);
var inst_20133 = fluree.db.util.async.throw_err(inst_20132);
var inst_20134__$1 = cljs.core.__destructure_map(inst_20133);
var inst_20135__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20134__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_20136 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20134__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_20137 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_20135__$1);
var state_20161__$1 = (function (){var statearr_20176 = state_20161;
(statearr_20176[(7)] = inst_20134__$1);

(statearr_20176[(9)] = inst_20135__$1);

(statearr_20176[(11)] = inst_20136);

return statearr_20176;
})();
if(inst_20137){
var statearr_20177_20201 = state_20161__$1;
(statearr_20177_20201[(1)] = (10));

} else {
var statearr_20178_20202 = state_20161__$1;
(statearr_20178_20202[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20162 === (5))){
var _ = (function (){var statearr_20179 = state_20161;
(statearr_20179[(4)] = cljs.core.rest((state_20161[(4)])));

return statearr_20179;
})();
var state_20161__$1 = state_20161;
var ex20174 = (state_20161__$1[(2)]);
var statearr_20180_20203 = state_20161__$1;
(statearr_20180_20203[(5)] = ex20174);


if((ex20174 instanceof Error)){
var statearr_20181_20204 = state_20161__$1;
(statearr_20181_20204[(1)] = (4));

(statearr_20181_20204[(5)] = null);

} else {
throw ex20174;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20162 === (14))){
var state_20161__$1 = state_20161;
var statearr_20182_20205 = state_20161__$1;
(statearr_20182_20205[(2)] = (1000));

(statearr_20182_20205[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20162 === (10))){
var inst_20134 = (state_20161[(7)]);
var inst_20139 = (state_20161[(10)]);
var inst_20136 = (state_20161[(11)]);
var inst_20139__$1 = cljs.core.count(inst_20136);
var inst_20140 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_20134);
var inst_20141 = (inst_20139__$1 < (1000));
var state_20161__$1 = (function (){var statearr_20183 = state_20161;
(statearr_20183[(8)] = inst_20140);

(statearr_20183[(10)] = inst_20139__$1);

return statearr_20183;
})();
if(cljs.core.truth_(inst_20141)){
var statearr_20184_20206 = state_20161__$1;
(statearr_20184_20206[(1)] = (13));

} else {
var statearr_20185_20207 = state_20161__$1;
(statearr_20185_20207[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20162 === (8))){
var inst_20128 = (state_20161[(2)]);
var inst_20129 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_20128,optional_clauses);
var inst_20130 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_20129);
var state_20161__$1 = state_20161;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20161__$1,(9),inst_20130);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_20186 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20186[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__);

(statearr_20186[(1)] = (1));

return statearr_20186;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1 = (function (state_20161){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20161);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20187){var ex__2730__auto__ = e20187;
var statearr_20188_20208 = state_20161;
(statearr_20188_20208[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20161[(4)]))){
var statearr_20189_20209 = state_20161;
(statearr_20189_20209[(1)] = cljs.core.first((state_20161[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20210 = state_20161;
state_20161 = G__20210;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__ = function(state_20161){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1.call(this,state_20161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20190 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20190[(6)] = c__2749__auto__);

return statearr_20190;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
