// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17297){
var state_val_17298 = (state_17297[(1)]);
if((state_val_17298 === (7))){
var inst_17286 = (state_17297[(7)]);
var inst_17288 = fluree.db.storage.core.serde(conn);
var inst_17289 = fluree.db.serde.protocol._deserialize_block(inst_17288,inst_17286);
var state_17297__$1 = state_17297;
var statearr_17299_17318 = state_17297__$1;
(statearr_17299_17318[(2)] = inst_17289);

(statearr_17299_17318[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17298 === (1))){
var state_17297__$1 = state_17297;
var statearr_17300_17319 = state_17297__$1;
(statearr_17300_17319[(2)] = null);

(statearr_17300_17319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17298 === (4))){
var inst_17276 = (state_17297[(2)]);
var state_17297__$1 = state_17297;
var statearr_17301_17320 = state_17297__$1;
(statearr_17301_17320[(2)] = inst_17276);

(statearr_17301_17320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17298 === (6))){
var inst_17286 = (state_17297[(7)]);
var inst_17285 = (state_17297[(2)]);
var inst_17286__$1 = fluree.db.util.async.throw_err(inst_17285);
var state_17297__$1 = (function (){var statearr_17302 = state_17297;
(statearr_17302[(7)] = inst_17286__$1);

return statearr_17302;
})();
if(cljs.core.truth_(inst_17286__$1)){
var statearr_17303_17321 = state_17297__$1;
(statearr_17303_17321[(1)] = (7));

} else {
var statearr_17304_17322 = state_17297__$1;
(statearr_17304_17322[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17298 === (3))){
var inst_17295 = (state_17297[(2)]);
var state_17297__$1 = state_17297;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17297__$1,inst_17295);
} else {
if((state_val_17298 === (2))){
var _ = (function (){var statearr_17306 = state_17297;
(statearr_17306[(4)] = cljs.core.cons((5),(state_17297[(4)])));

return statearr_17306;
})();
var inst_17282 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_17283 = fluree.db.storage.core.storage_read(conn,inst_17282);
var state_17297__$1 = state_17297;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17297__$1,(6),inst_17283);
} else {
if((state_val_17298 === (9))){
var inst_17292 = (state_17297[(2)]);
var _ = (function (){var statearr_17307 = state_17297;
(statearr_17307[(4)] = cljs.core.rest((state_17297[(4)])));

return statearr_17307;
})();
var state_17297__$1 = state_17297;
var statearr_17308_17323 = state_17297__$1;
(statearr_17308_17323[(2)] = inst_17292);

(statearr_17308_17323[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17298 === (5))){
var _ = (function (){var statearr_17309 = state_17297;
(statearr_17309[(4)] = cljs.core.rest((state_17297[(4)])));

return statearr_17309;
})();
var state_17297__$1 = state_17297;
var ex17305 = (state_17297__$1[(2)]);
var statearr_17310_17324 = state_17297__$1;
(statearr_17310_17324[(5)] = ex17305);


if((ex17305 instanceof Error)){
var statearr_17311_17325 = state_17297__$1;
(statearr_17311_17325[(1)] = (4));

(statearr_17311_17325[(5)] = null);

} else {
throw ex17305;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17298 === (8))){
var state_17297__$1 = state_17297;
var statearr_17312_17326 = state_17297__$1;
(statearr_17312_17326[(2)] = null);

(statearr_17312_17326[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2727__auto____0 = (function (){
var statearr_17313 = [null,null,null,null,null,null,null,null];
(statearr_17313[(0)] = fluree$db$storage$core$read_block_$_state_machine__2727__auto__);

(statearr_17313[(1)] = (1));

return statearr_17313;
});
var fluree$db$storage$core$read_block_$_state_machine__2727__auto____1 = (function (state_17297){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17297);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17314){var ex__2730__auto__ = e17314;
var statearr_17315_17327 = state_17297;
(statearr_17315_17327[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17297[(4)]))){
var statearr_17316_17328 = state_17297;
(statearr_17316_17328[(1)] = cljs.core.first((state_17297[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17329 = state_17297;
state_17297 = G__17329;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2727__auto__ = function(state_17297){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2727__auto____1.call(this,state_17297);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17317 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17317[(6)] = c__2749__auto__);

return statearr_17317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17352){
var state_val_17353 = (state_17352[(1)]);
if((state_val_17353 === (7))){
var inst_17341 = (state_17352[(7)]);
var inst_17343 = fluree.db.storage.core.serde(conn);
var inst_17344 = fluree.db.serde.protocol._deserialize_block(inst_17343,inst_17341);
var state_17352__$1 = state_17352;
var statearr_17354_17373 = state_17352__$1;
(statearr_17354_17373[(2)] = inst_17344);

(statearr_17354_17373[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (1))){
var state_17352__$1 = state_17352;
var statearr_17355_17374 = state_17352__$1;
(statearr_17355_17374[(2)] = null);

(statearr_17355_17374[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (4))){
var inst_17330 = (state_17352[(2)]);
var state_17352__$1 = state_17352;
var statearr_17356_17375 = state_17352__$1;
(statearr_17356_17375[(2)] = inst_17330);

(statearr_17356_17375[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (6))){
var inst_17341 = (state_17352[(7)]);
var inst_17340 = (state_17352[(2)]);
var inst_17341__$1 = fluree.db.util.async.throw_err(inst_17340);
var state_17352__$1 = (function (){var statearr_17357 = state_17352;
(statearr_17357[(7)] = inst_17341__$1);

return statearr_17357;
})();
if(cljs.core.truth_(inst_17341__$1)){
var statearr_17358_17376 = state_17352__$1;
(statearr_17358_17376[(1)] = (7));

} else {
var statearr_17359_17377 = state_17352__$1;
(statearr_17359_17377[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (3))){
var inst_17350 = (state_17352[(2)]);
var state_17352__$1 = state_17352;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17352__$1,inst_17350);
} else {
if((state_val_17353 === (2))){
var _ = (function (){var statearr_17361 = state_17352;
(statearr_17361[(4)] = cljs.core.cons((5),(state_17352[(4)])));

return statearr_17361;
})();
var inst_17336 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_17337 = [inst_17336,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17338 = fluree.db.storage.core.storage_read(conn,inst_17337);
var state_17352__$1 = state_17352;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17352__$1,(6),inst_17338);
} else {
if((state_val_17353 === (9))){
var inst_17347 = (state_17352[(2)]);
var _ = (function (){var statearr_17362 = state_17352;
(statearr_17362[(4)] = cljs.core.rest((state_17352[(4)])));

return statearr_17362;
})();
var state_17352__$1 = state_17352;
var statearr_17363_17378 = state_17352__$1;
(statearr_17363_17378[(2)] = inst_17347);

(statearr_17363_17378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (5))){
var _ = (function (){var statearr_17364 = state_17352;
(statearr_17364[(4)] = cljs.core.rest((state_17352[(4)])));

return statearr_17364;
})();
var state_17352__$1 = state_17352;
var ex17360 = (state_17352__$1[(2)]);
var statearr_17365_17379 = state_17352__$1;
(statearr_17365_17379[(5)] = ex17360);


if((ex17360 instanceof Error)){
var statearr_17366_17380 = state_17352__$1;
(statearr_17366_17380[(1)] = (4));

(statearr_17366_17380[(5)] = null);

} else {
throw ex17360;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (8))){
var state_17352__$1 = state_17352;
var statearr_17367_17381 = state_17352__$1;
(statearr_17367_17381[(2)] = null);

(statearr_17367_17381[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0 = (function (){
var statearr_17368 = [null,null,null,null,null,null,null,null];
(statearr_17368[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__);

(statearr_17368[(1)] = (1));

return statearr_17368;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1 = (function (state_17352){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17352);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17369){var ex__2730__auto__ = e17369;
var statearr_17370_17382 = state_17352;
(statearr_17370_17382[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17352[(4)]))){
var statearr_17371_17383 = state_17352;
(statearr_17371_17383[(1)] = cljs.core.first((state_17352[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17384 = state_17352;
state_17352 = G__17384;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__ = function(state_17352){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1.call(this,state_17352);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17372 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17372[(6)] = c__2749__auto__);

return statearr_17372;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17408){
var state_val_17409 = (state_17408[(1)]);
if((state_val_17409 === (1))){
var state_17408__$1 = state_17408;
var statearr_17410_17424 = state_17408__$1;
(statearr_17410_17424[(2)] = null);

(statearr_17410_17424[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17409 === (2))){
var _ = (function (){var statearr_17411 = state_17408;
(statearr_17411[(4)] = cljs.core.cons((5),(state_17408[(4)])));

return statearr_17411;
})();
var inst_17391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17392 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17393 = (new cljs.core.PersistentVector(null,3,(5),inst_17391,inst_17392,null));
var inst_17394 = cljs.core.select_keys(block_data,inst_17393);
var inst_17395 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17394);
var inst_17396 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_17395);
var inst_17397 = [inst_17396,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17398 = fluree.db.storage.core.serde(conn);
var inst_17399 = fluree.db.serde.protocol._serialize_block(inst_17398,inst_17394);
var inst_17400 = fluree.db.storage.core.storage_write(conn,inst_17397,inst_17399);
var state_17408__$1 = state_17408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17408__$1,(6),inst_17400);
} else {
if((state_val_17409 === (3))){
var inst_17406 = (state_17408[(2)]);
var state_17408__$1 = state_17408;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17408__$1,inst_17406);
} else {
if((state_val_17409 === (4))){
var inst_17385 = (state_17408[(2)]);
var state_17408__$1 = state_17408;
var statearr_17413_17425 = state_17408__$1;
(statearr_17413_17425[(2)] = inst_17385);

(statearr_17413_17425[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17409 === (5))){
var _ = (function (){var statearr_17414 = state_17408;
(statearr_17414[(4)] = cljs.core.rest((state_17408[(4)])));

return statearr_17414;
})();
var state_17408__$1 = state_17408;
var ex17412 = (state_17408__$1[(2)]);
var statearr_17415_17426 = state_17408__$1;
(statearr_17415_17426[(5)] = ex17412);


if((ex17412 instanceof Error)){
var statearr_17416_17427 = state_17408__$1;
(statearr_17416_17427[(1)] = (4));

(statearr_17416_17427[(5)] = null);

} else {
throw ex17412;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17409 === (6))){
var inst_17402 = (state_17408[(2)]);
var inst_17403 = fluree.db.util.async.throw_err(inst_17402);
var _ = (function (){var statearr_17417 = state_17408;
(statearr_17417[(4)] = cljs.core.rest((state_17408[(4)])));

return statearr_17417;
})();
var state_17408__$1 = state_17408;
var statearr_17418_17428 = state_17408__$1;
(statearr_17418_17428[(2)] = inst_17403);

(statearr_17418_17428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0 = (function (){
var statearr_17419 = [null,null,null,null,null,null,null];
(statearr_17419[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__);

(statearr_17419[(1)] = (1));

return statearr_17419;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1 = (function (state_17408){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17408);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17420){var ex__2730__auto__ = e17420;
var statearr_17421_17429 = state_17408;
(statearr_17421_17429[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17408[(4)]))){
var statearr_17422_17430 = state_17408;
(statearr_17422_17430[(1)] = cljs.core.first((state_17408[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17431 = state_17408;
state_17408 = G__17431;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__ = function(state_17408){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1.call(this,state_17408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17423 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17423[(6)] = c__2749__auto__);

return statearr_17423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17454){
var state_val_17455 = (state_17454[(1)]);
if((state_val_17455 === (1))){
var state_17454__$1 = state_17454;
var statearr_17456_17470 = state_17454__$1;
(statearr_17456_17470[(2)] = null);

(statearr_17456_17470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17455 === (2))){
var _ = (function (){var statearr_17457 = state_17454;
(statearr_17457[(4)] = cljs.core.cons((5),(state_17454[(4)])));

return statearr_17457;
})();
var inst_17438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17439 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17440 = (new cljs.core.PersistentVector(null,3,(5),inst_17438,inst_17439,null));
var inst_17441 = cljs.core.select_keys(block_data,inst_17440);
var inst_17442 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17441);
var inst_17443 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_17442);
var inst_17444 = fluree.db.storage.core.serde(conn);
var inst_17445 = fluree.db.serde.protocol._serialize_block(inst_17444,inst_17441);
var inst_17446 = fluree.db.storage.core.storage_write(conn,inst_17443,inst_17445);
var state_17454__$1 = state_17454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17454__$1,(6),inst_17446);
} else {
if((state_val_17455 === (3))){
var inst_17452 = (state_17454[(2)]);
var state_17454__$1 = state_17454;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17454__$1,inst_17452);
} else {
if((state_val_17455 === (4))){
var inst_17432 = (state_17454[(2)]);
var state_17454__$1 = state_17454;
var statearr_17459_17471 = state_17454__$1;
(statearr_17459_17471[(2)] = inst_17432);

(statearr_17459_17471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17455 === (5))){
var _ = (function (){var statearr_17460 = state_17454;
(statearr_17460[(4)] = cljs.core.rest((state_17454[(4)])));

return statearr_17460;
})();
var state_17454__$1 = state_17454;
var ex17458 = (state_17454__$1[(2)]);
var statearr_17461_17472 = state_17454__$1;
(statearr_17461_17472[(5)] = ex17458);


if((ex17458 instanceof Error)){
var statearr_17462_17473 = state_17454__$1;
(statearr_17462_17473[(1)] = (4));

(statearr_17462_17473[(5)] = null);

} else {
throw ex17458;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17455 === (6))){
var inst_17448 = (state_17454[(2)]);
var inst_17449 = fluree.db.util.async.throw_err(inst_17448);
var _ = (function (){var statearr_17463 = state_17454;
(statearr_17463[(4)] = cljs.core.rest((state_17454[(4)])));

return statearr_17463;
})();
var state_17454__$1 = state_17454;
var statearr_17464_17474 = state_17454__$1;
(statearr_17464_17474[(2)] = inst_17449);

(statearr_17464_17474[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2727__auto____0 = (function (){
var statearr_17465 = [null,null,null,null,null,null,null];
(statearr_17465[(0)] = fluree$db$storage$core$write_block_$_state_machine__2727__auto__);

(statearr_17465[(1)] = (1));

return statearr_17465;
});
var fluree$db$storage$core$write_block_$_state_machine__2727__auto____1 = (function (state_17454){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17454);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17466){var ex__2730__auto__ = e17466;
var statearr_17467_17475 = state_17454;
(statearr_17467_17475[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17454[(4)]))){
var statearr_17468_17476 = state_17454;
(statearr_17468_17476[(1)] = cljs.core.first((state_17454[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17477 = state_17454;
state_17454 = G__17477;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2727__auto__ = function(state_17454){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2727__auto____1.call(this,state_17454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17469 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17469[(6)] = c__2749__auto__);

return statearr_17469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17497){
var state_val_17498 = (state_17497[(1)]);
if((state_val_17498 === (1))){
var state_17497__$1 = state_17497;
var statearr_17499_17513 = state_17497__$1;
(statearr_17499_17513[(2)] = null);

(statearr_17499_17513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17498 === (2))){
var _ = (function (){var statearr_17500 = state_17497;
(statearr_17500[(4)] = cljs.core.cons((5),(state_17497[(4)])));

return statearr_17500;
})();
var inst_17484 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_17485 = [history,next_his_key];
var inst_17486 = cljs.core.PersistentHashMap.fromArrays(inst_17484,inst_17485);
var inst_17487 = fluree.db.storage.core.serde(conn);
var inst_17488 = fluree.db.serde.protocol._serialize_leaf(inst_17487,inst_17486);
var inst_17489 = fluree.db.storage.core.storage_write(conn,his_key,inst_17488);
var state_17497__$1 = state_17497;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17497__$1,(6),inst_17489);
} else {
if((state_val_17498 === (3))){
var inst_17495 = (state_17497[(2)]);
var state_17497__$1 = state_17497;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17497__$1,inst_17495);
} else {
if((state_val_17498 === (4))){
var inst_17478 = (state_17497[(2)]);
var state_17497__$1 = state_17497;
var statearr_17502_17514 = state_17497__$1;
(statearr_17502_17514[(2)] = inst_17478);

(statearr_17502_17514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17498 === (5))){
var _ = (function (){var statearr_17503 = state_17497;
(statearr_17503[(4)] = cljs.core.rest((state_17497[(4)])));

return statearr_17503;
})();
var state_17497__$1 = state_17497;
var ex17501 = (state_17497__$1[(2)]);
var statearr_17504_17515 = state_17497__$1;
(statearr_17504_17515[(5)] = ex17501);


if((ex17501 instanceof Error)){
var statearr_17505_17516 = state_17497__$1;
(statearr_17505_17516[(1)] = (4));

(statearr_17505_17516[(5)] = null);

} else {
throw ex17501;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17498 === (6))){
var inst_17491 = (state_17497[(2)]);
var inst_17492 = fluree.db.util.async.throw_err(inst_17491);
var _ = (function (){var statearr_17506 = state_17497;
(statearr_17506[(4)] = cljs.core.rest((state_17497[(4)])));

return statearr_17506;
})();
var state_17497__$1 = state_17497;
var statearr_17507_17517 = state_17497__$1;
(statearr_17507_17517[(2)] = inst_17492);

(statearr_17507_17517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2727__auto____0 = (function (){
var statearr_17508 = [null,null,null,null,null,null,null];
(statearr_17508[(0)] = fluree$db$storage$core$write_history_$_state_machine__2727__auto__);

(statearr_17508[(1)] = (1));

return statearr_17508;
});
var fluree$db$storage$core$write_history_$_state_machine__2727__auto____1 = (function (state_17497){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17497);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17509){var ex__2730__auto__ = e17509;
var statearr_17510_17518 = state_17497;
(statearr_17510_17518[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17497[(4)]))){
var statearr_17511_17519 = state_17497;
(statearr_17511_17519[(1)] = cljs.core.first((state_17497[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17520 = state_17497;
state_17497 = G__17520;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2727__auto__ = function(state_17497){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2727__auto____1.call(this,state_17497);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17512 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17512[(6)] = c__2749__auto__);

return statearr_17512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17546){
var state_val_17547 = (state_17546[(1)]);
if((state_val_17547 === (1))){
var state_17546__$1 = state_17546;
var statearr_17548_17565 = state_17546__$1;
(statearr_17548_17565[(2)] = null);

(statearr_17548_17565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17547 === (2))){
var inst_17527 = (state_17546[(7)]);
var _ = (function (){var statearr_17549 = state_17546;
(statearr_17549[(4)] = cljs.core.cons((5),(state_17546[(4)])));

return statearr_17549;
})();
var inst_17527__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_17528 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17527__$1),"-his"].join('');
var inst_17529 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_17530 = [flakes,inst_17528];
var inst_17531 = cljs.core.PersistentHashMap.fromArrays(inst_17529,inst_17530);
var inst_17532 = fluree.db.storage.core.serde(conn);
var inst_17533 = fluree.db.serde.protocol._serialize_leaf(inst_17532,inst_17531);
var inst_17534 = fluree.db.storage.core.write_history(conn,history,inst_17528,null);
var inst_17535 = fluree.db.storage.core.storage_write(conn,inst_17527__$1,inst_17533);
var state_17546__$1 = (function (){var statearr_17550 = state_17546;
(statearr_17550[(7)] = inst_17527__$1);

(statearr_17550[(8)] = inst_17535);

return statearr_17550;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17546__$1,(6),inst_17534);
} else {
if((state_val_17547 === (3))){
var inst_17544 = (state_17546[(2)]);
var state_17546__$1 = state_17546;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17546__$1,inst_17544);
} else {
if((state_val_17547 === (4))){
var inst_17521 = (state_17546[(2)]);
var state_17546__$1 = state_17546;
var statearr_17552_17566 = state_17546__$1;
(statearr_17552_17566[(2)] = inst_17521);

(statearr_17552_17566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17547 === (5))){
var _ = (function (){var statearr_17553 = state_17546;
(statearr_17553[(4)] = cljs.core.rest((state_17546[(4)])));

return statearr_17553;
})();
var state_17546__$1 = state_17546;
var ex17551 = (state_17546__$1[(2)]);
var statearr_17554_17567 = state_17546__$1;
(statearr_17554_17567[(5)] = ex17551);


if((ex17551 instanceof Error)){
var statearr_17555_17568 = state_17546__$1;
(statearr_17555_17568[(1)] = (4));

(statearr_17555_17568[(5)] = null);

} else {
throw ex17551;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17547 === (6))){
var inst_17535 = (state_17546[(8)]);
var inst_17537 = (state_17546[(2)]);
var inst_17538 = fluree.db.util.async.throw_err(inst_17537);
var state_17546__$1 = (function (){var statearr_17556 = state_17546;
(statearr_17556[(9)] = inst_17538);

return statearr_17556;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17546__$1,(7),inst_17535);
} else {
if((state_val_17547 === (7))){
var inst_17527 = (state_17546[(7)]);
var inst_17540 = (state_17546[(2)]);
var inst_17541 = fluree.db.util.async.throw_err(inst_17540);
var _ = (function (){var statearr_17557 = state_17546;
(statearr_17557[(4)] = cljs.core.rest((state_17546[(4)])));

return statearr_17557;
})();
var state_17546__$1 = (function (){var statearr_17558 = state_17546;
(statearr_17558[(10)] = inst_17541);

return statearr_17558;
})();
var statearr_17559_17569 = state_17546__$1;
(statearr_17559_17569[(2)] = inst_17527);

(statearr_17559_17569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2727__auto____0 = (function (){
var statearr_17560 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17560[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2727__auto__);

(statearr_17560[(1)] = (1));

return statearr_17560;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2727__auto____1 = (function (state_17546){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17546);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17561){var ex__2730__auto__ = e17561;
var statearr_17562_17570 = state_17546;
(statearr_17562_17570[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17546[(4)]))){
var statearr_17563_17571 = state_17546;
(statearr_17563_17571[(1)] = cljs.core.first((state_17546[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17572 = state_17546;
state_17546 = G__17572;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2727__auto__ = function(state_17546){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2727__auto____1.call(this,state_17546);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17564 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17564[(6)] = c__2749__auto__);

return statearr_17564;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17589){
var state_val_17590 = (state_17589[(1)]);
if((state_val_17590 === (1))){
var state_17589__$1 = state_17589;
var statearr_17591_17606 = state_17589__$1;
(statearr_17591_17606[(2)] = null);

(statearr_17591_17606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17590 === (2))){
var _ = (function (){var statearr_17592 = state_17589;
(statearr_17592[(4)] = cljs.core.cons((5),(state_17589[(4)])));

return statearr_17592;
})();
var inst_17579 = fluree.db.storage.core.serde(conn);
var inst_17580 = fluree.db.serde.protocol._serialize_branch(inst_17579,data);
var inst_17581 = fluree.db.storage.core.storage_write(conn,key,inst_17580);
var state_17589__$1 = state_17589;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17589__$1,(6),inst_17581);
} else {
if((state_val_17590 === (3))){
var inst_17587 = (state_17589[(2)]);
var state_17589__$1 = state_17589;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17589__$1,inst_17587);
} else {
if((state_val_17590 === (4))){
var inst_17573 = (state_17589[(2)]);
var state_17589__$1 = state_17589;
var statearr_17594_17607 = state_17589__$1;
(statearr_17594_17607[(2)] = inst_17573);

(statearr_17594_17607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17590 === (5))){
var _ = (function (){var statearr_17595 = state_17589;
(statearr_17595[(4)] = cljs.core.rest((state_17589[(4)])));

return statearr_17595;
})();
var state_17589__$1 = state_17589;
var ex17593 = (state_17589__$1[(2)]);
var statearr_17596_17608 = state_17589__$1;
(statearr_17596_17608[(5)] = ex17593);


if((ex17593 instanceof Error)){
var statearr_17597_17609 = state_17589__$1;
(statearr_17597_17609[(1)] = (4));

(statearr_17597_17609[(5)] = null);

} else {
throw ex17593;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17590 === (6))){
var inst_17583 = (state_17589[(2)]);
var inst_17584 = fluree.db.util.async.throw_err(inst_17583);
var _ = (function (){var statearr_17598 = state_17589;
(statearr_17598[(4)] = cljs.core.rest((state_17589[(4)])));

return statearr_17598;
})();
var state_17589__$1 = (function (){var statearr_17599 = state_17589;
(statearr_17599[(7)] = inst_17584);

return statearr_17599;
})();
var statearr_17600_17610 = state_17589__$1;
(statearr_17600_17610[(2)] = key);

(statearr_17600_17610[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0 = (function (){
var statearr_17601 = [null,null,null,null,null,null,null,null];
(statearr_17601[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__);

(statearr_17601[(1)] = (1));

return statearr_17601;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1 = (function (state_17589){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17589);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17602){var ex__2730__auto__ = e17602;
var statearr_17603_17611 = state_17589;
(statearr_17603_17611[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17589[(4)]))){
var statearr_17604_17612 = state_17589;
(statearr_17604_17612[(1)] = cljs.core.first((state_17589[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17613 = state_17589;
state_17589 = G__17613;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__ = function(state_17589){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1.call(this,state_17589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17605 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17605[(6)] = c__2749__auto__);

return statearr_17605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__17614_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__17614_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__17615){
var map__17616 = p__17615;
var map__17616__$1 = cljs.core.__destructure_map(map__17616);
var progress = map__17616__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17616__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17644){
var state_val_17645 = (state_17644[(1)]);
if((state_val_17645 === (1))){
var state_17644__$1 = state_17644;
var statearr_17646_17662 = state_17644__$1;
(statearr_17646_17662[(2)] = null);

(statearr_17646_17662[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17645 === (2))){
var inst_17630 = (state_17644[(7)]);
var _ = (function (){var statearr_17647 = state_17644;
(statearr_17647[(4)] = cljs.core.cons((5),(state_17644[(4)])));

return statearr_17647;
})();
var inst_17624 = db;
var inst_17625 = cljs.core.__destructure_map(inst_17624);
var inst_17626 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17625,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17627 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17625,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17628 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17625,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_17629 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17625,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17630__$1 = fluree.db.storage.core.ledger_garbage_key(inst_17627,inst_17628,inst_17629);
var inst_17631 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_17632 = [inst_17628,inst_17629,garbage];
var inst_17633 = cljs.core.PersistentHashMap.fromArrays(inst_17631,inst_17632);
var inst_17634 = fluree.db.storage.core.serde(inst_17626);
var inst_17635 = fluree.db.serde.protocol._serialize_garbage(inst_17634,inst_17633);
var inst_17636 = fluree.db.storage.core.storage_write(inst_17626,inst_17630__$1,inst_17635);
var state_17644__$1 = (function (){var statearr_17648 = state_17644;
(statearr_17648[(7)] = inst_17630__$1);

return statearr_17648;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17644__$1,(6),inst_17636);
} else {
if((state_val_17645 === (3))){
var inst_17642 = (state_17644[(2)]);
var state_17644__$1 = state_17644;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17644__$1,inst_17642);
} else {
if((state_val_17645 === (4))){
var inst_17617 = (state_17644[(2)]);
var state_17644__$1 = state_17644;
var statearr_17650_17663 = state_17644__$1;
(statearr_17650_17663[(2)] = inst_17617);

(statearr_17650_17663[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17645 === (5))){
var _ = (function (){var statearr_17651 = state_17644;
(statearr_17651[(4)] = cljs.core.rest((state_17644[(4)])));

return statearr_17651;
})();
var state_17644__$1 = state_17644;
var ex17649 = (state_17644__$1[(2)]);
var statearr_17652_17664 = state_17644__$1;
(statearr_17652_17664[(5)] = ex17649);


if((ex17649 instanceof Error)){
var statearr_17653_17665 = state_17644__$1;
(statearr_17653_17665[(1)] = (4));

(statearr_17653_17665[(5)] = null);

} else {
throw ex17649;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17645 === (6))){
var inst_17630 = (state_17644[(7)]);
var inst_17638 = (state_17644[(2)]);
var inst_17639 = fluree.db.util.async.throw_err(inst_17638);
var _ = (function (){var statearr_17654 = state_17644;
(statearr_17654[(4)] = cljs.core.rest((state_17644[(4)])));

return statearr_17654;
})();
var state_17644__$1 = (function (){var statearr_17655 = state_17644;
(statearr_17655[(8)] = inst_17639);

return statearr_17655;
})();
var statearr_17656_17666 = state_17644__$1;
(statearr_17656_17666[(2)] = inst_17630);

(statearr_17656_17666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0 = (function (){
var statearr_17657 = [null,null,null,null,null,null,null,null,null];
(statearr_17657[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__);

(statearr_17657[(1)] = (1));

return statearr_17657;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1 = (function (state_17644){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17644);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17658){var ex__2730__auto__ = e17658;
var statearr_17659_17667 = state_17644;
(statearr_17659_17667[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17644[(4)]))){
var statearr_17660_17668 = state_17644;
(statearr_17660_17668[(1)] = cljs.core.first((state_17644[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17669 = state_17644;
state_17644 = G__17669;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__ = function(state_17644){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1.call(this,state_17644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17661 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17661[(6)] = c__2749__auto__);

return statearr_17661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__17671 = arguments.length;
switch (G__17671) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17727){
var state_val_17728 = (state_17727[(1)]);
if((state_val_17728 === (7))){
var state_17727__$1 = state_17727;
var statearr_17729_17755 = state_17727__$1;
(statearr_17729_17755[(2)] = (0));

(statearr_17729_17755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17728 === (1))){
var state_17727__$1 = state_17727;
var statearr_17730_17756 = state_17727__$1;
(statearr_17730_17756[(2)] = null);

(statearr_17730_17756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17728 === (4))){
var inst_17672 = (state_17727[(2)]);
var state_17727__$1 = state_17727;
var statearr_17731_17757 = state_17727__$1;
(statearr_17731_17757[(2)] = inst_17672);

(statearr_17731_17757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17728 === (6))){
var inst_17697 = (state_17727[(7)]);
var state_17727__$1 = state_17727;
var statearr_17732_17758 = state_17727__$1;
(statearr_17732_17758[(2)] = inst_17697);

(statearr_17732_17758[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17728 === (3))){
var inst_17725 = (state_17727[(2)]);
var state_17727__$1 = state_17727;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17727__$1,inst_17725);
} else {
if((state_val_17728 === (12))){
var inst_17694 = (state_17727[(8)]);
var inst_17721 = (state_17727[(2)]);
var inst_17722 = fluree.db.util.async.throw_err(inst_17721);
var _ = (function (){var statearr_17733 = state_17727;
(statearr_17733[(4)] = cljs.core.rest((state_17727[(4)])));

return statearr_17733;
})();
var state_17727__$1 = (function (){var statearr_17734 = state_17727;
(statearr_17734[(9)] = inst_17722);

return statearr_17734;
})();
var statearr_17735_17759 = state_17727__$1;
(statearr_17735_17759[(2)] = inst_17694);

(statearr_17735_17759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17728 === (2))){
var inst_17685 = (state_17727[(10)]);
var inst_17697 = (state_17727[(7)]);
var inst_17689 = (state_17727[(11)]);
var inst_17687 = (state_17727[(12)]);
var _ = (function (){var statearr_17736 = state_17727;
(statearr_17736[(4)] = cljs.core.cons((5),(state_17727[(4)])));

return statearr_17736;
})();
var inst_17679 = db;
var inst_17680 = cljs.core.__destructure_map(inst_17679);
var inst_17681 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17680,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17682 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17680,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_17683 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17680,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_17684 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17680,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_17685__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17680,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_17686 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17680,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17687__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17680,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17688 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17680,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_17689__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17680,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_17690 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17680,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_17691 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17680,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_17692 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17680,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_17693 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17680,new cljs.core.Keyword(null,"post","post",269697687));
var inst_17694 = fluree.db.storage.core.ledger_root_key(inst_17681,inst_17689__$1,inst_17687__$1);
var inst_17695 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_17696 = fluree.db.storage.core.child_data(inst_17688);
var inst_17697__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_17685__$1);
var state_17727__$1 = (function (){var statearr_17737 = state_17727;
(statearr_17737[(13)] = inst_17690);

(statearr_17737[(14)] = inst_17682);

(statearr_17737[(15)] = inst_17683);

(statearr_17737[(10)] = inst_17685__$1);

(statearr_17737[(7)] = inst_17697__$1);

(statearr_17737[(16)] = inst_17696);

(statearr_17737[(11)] = inst_17689__$1);

(statearr_17737[(12)] = inst_17687__$1);

(statearr_17737[(17)] = inst_17692);

(statearr_17737[(18)] = inst_17695);

(statearr_17737[(19)] = inst_17693);

(statearr_17737[(20)] = inst_17686);

(statearr_17737[(21)] = inst_17691);

(statearr_17737[(22)] = inst_17684);

(statearr_17737[(8)] = inst_17694);

return statearr_17737;
})();
if(cljs.core.truth_(inst_17697__$1)){
var statearr_17738_17760 = state_17727__$1;
(statearr_17738_17760[(1)] = (6));

} else {
var statearr_17739_17761 = state_17727__$1;
(statearr_17739_17761[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17728 === (11))){
var inst_17682 = (state_17727[(14)]);
var inst_17683 = (state_17727[(15)]);
var inst_17685 = (state_17727[(10)]);
var inst_17696 = (state_17727[(16)]);
var inst_17689 = (state_17727[(11)]);
var inst_17687 = (state_17727[(12)]);
var inst_17692 = (state_17727[(17)]);
var inst_17695 = (state_17727[(18)]);
var inst_17693 = (state_17727[(19)]);
var inst_17686 = (state_17727[(20)]);
var inst_17691 = (state_17727[(21)]);
var inst_17701 = (state_17727[(23)]);
var inst_17684 = (state_17727[(22)]);
var inst_17694 = (state_17727[(8)]);
var inst_17706 = (state_17727[(2)]);
var inst_17707 = fluree.db.storage.core.child_data(inst_17691);
var inst_17708 = fluree.db.storage.core.child_data(inst_17693);
var inst_17709 = fluree.db.util.core.current_time_millis();
var inst_17710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17711 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_17712 = (new cljs.core.PersistentVector(null,2,(5),inst_17710,inst_17711,null));
var inst_17713 = cljs.core.select_keys(inst_17685,inst_17712);
var inst_17714 = fluree.db.storage.core.child_data(inst_17684);
var inst_17715 = [inst_17687,inst_17696,inst_17689,inst_17701,inst_17706,inst_17707,inst_17708,inst_17682,inst_17709,inst_17683,inst_17692,inst_17713,inst_17714];
var inst_17716 = cljs.core.PersistentHashMap.fromArrays(inst_17695,inst_17715);
var inst_17717 = fluree.db.storage.core.serde(inst_17686);
var inst_17718 = fluree.db.serde.protocol._serialize_db_root(inst_17717,inst_17716);
var inst_17719 = fluree.db.storage.core.storage_write(inst_17686,inst_17694,inst_17718);
var state_17727__$1 = state_17727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17727__$1,(12),inst_17719);
} else {
if((state_val_17728 === (9))){
var inst_17702 = (state_17727[(24)]);
var state_17727__$1 = state_17727;
var statearr_17741_17762 = state_17727__$1;
(statearr_17741_17762[(2)] = inst_17702);

(statearr_17741_17762[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17728 === (5))){
var _ = (function (){var statearr_17742 = state_17727;
(statearr_17742[(4)] = cljs.core.rest((state_17727[(4)])));

return statearr_17742;
})();
var state_17727__$1 = state_17727;
var ex17740 = (state_17727__$1[(2)]);
var statearr_17743_17763 = state_17727__$1;
(statearr_17743_17763[(5)] = ex17740);


if((ex17740 instanceof Error)){
var statearr_17744_17764 = state_17727__$1;
(statearr_17744_17764[(1)] = (4));

(statearr_17744_17764[(5)] = null);

} else {
throw ex17740;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17728 === (10))){
var inst_17690 = (state_17727[(13)]);
var state_17727__$1 = state_17727;
var statearr_17745_17765 = state_17727__$1;
(statearr_17745_17765[(2)] = inst_17690);

(statearr_17745_17765[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17728 === (8))){
var inst_17702 = (state_17727[(24)]);
var inst_17701 = (state_17727[(2)]);
var inst_17702__$1 = custom_ecount;
var state_17727__$1 = (function (){var statearr_17746 = state_17727;
(statearr_17746[(24)] = inst_17702__$1);

(statearr_17746[(23)] = inst_17701);

return statearr_17746;
})();
if(cljs.core.truth_(inst_17702__$1)){
var statearr_17747_17766 = state_17727__$1;
(statearr_17747_17766[(1)] = (9));

} else {
var statearr_17748_17767 = state_17727__$1;
(statearr_17748_17767[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_17749 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17749[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_17749[(1)] = (1));

return statearr_17749;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_17727){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17727);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17750){var ex__2730__auto__ = e17750;
var statearr_17751_17768 = state_17727;
(statearr_17751_17768[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17727[(4)]))){
var statearr_17752_17769 = state_17727;
(statearr_17752_17769[(1)] = cljs.core.first((state_17727[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17770 = state_17727;
state_17727 = G__17770;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_17727){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_17727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17753 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17753[(6)] = c__2749__auto__);

return statearr_17753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___17829 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17803){
var state_val_17804 = (state_17803[(1)]);
if((state_val_17804 === (7))){
var inst_17783 = (state_17803[(7)]);
var state_17803__$1 = state_17803;
var statearr_17805_17830 = state_17803__$1;
(statearr_17805_17830[(2)] = inst_17783);

(statearr_17805_17830[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17804 === (1))){
var state_17803__$1 = state_17803;
var statearr_17806_17831 = state_17803__$1;
(statearr_17806_17831[(2)] = null);

(statearr_17806_17831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17804 === (4))){
var inst_17771 = (state_17803[(2)]);
var inst_17772 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_17773 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_17771);
var inst_17774 = cljs.core.async.close_BANG_(return_ch);
var state_17803__$1 = (function (){var statearr_17807 = state_17803;
(statearr_17807[(8)] = inst_17772);

(statearr_17807[(9)] = inst_17773);

return statearr_17807;
})();
var statearr_17808_17832 = state_17803__$1;
(statearr_17808_17832[(2)] = inst_17774);

(statearr_17808_17832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17804 === (6))){
var inst_17783 = (state_17803[(7)]);
var inst_17782 = (state_17803[(10)]);
var inst_17782__$1 = (state_17803[(2)]);
var inst_17783__$1 = (inst_17782__$1 == null);
var state_17803__$1 = (function (){var statearr_17809 = state_17803;
(statearr_17809[(7)] = inst_17783__$1);

(statearr_17809[(10)] = inst_17782__$1);

return statearr_17809;
})();
if(cljs.core.truth_(inst_17783__$1)){
var statearr_17810_17833 = state_17803__$1;
(statearr_17810_17833[(1)] = (7));

} else {
var statearr_17811_17834 = state_17803__$1;
(statearr_17811_17834[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17804 === (3))){
var inst_17801 = (state_17803[(2)]);
var state_17803__$1 = state_17803;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17803__$1,inst_17801);
} else {
if((state_val_17804 === (12))){
var inst_17798 = (state_17803[(2)]);
var _ = (function (){var statearr_17812 = state_17803;
(statearr_17812[(4)] = cljs.core.rest((state_17803[(4)])));

return statearr_17812;
})();
var state_17803__$1 = state_17803;
var statearr_17813_17835 = state_17803__$1;
(statearr_17813_17835[(2)] = inst_17798);

(statearr_17813_17835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17804 === (2))){
var _ = (function (){var statearr_17814 = state_17803;
(statearr_17814[(4)] = cljs.core.cons((5),(state_17803[(4)])));

return statearr_17814;
})();
var inst_17780 = fluree.db.storage.core.storage_read(conn,key);
var state_17803__$1 = state_17803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17803__$1,(6),inst_17780);
} else {
if((state_val_17804 === (11))){
var inst_17782 = (state_17803[(10)]);
var inst_17792 = fluree.db.storage.core.serde(conn);
var inst_17793 = fluree.db.serde.protocol._deserialize_leaf(inst_17792,inst_17782);
var inst_17794 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_17793);
var inst_17795 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_17794);
var inst_17796 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_17795);
var state_17803__$1 = state_17803;
var statearr_17816_17836 = state_17803__$1;
(statearr_17816_17836[(2)] = inst_17796);

(statearr_17816_17836[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17804 === (9))){
var inst_17788 = (state_17803[(2)]);
var state_17803__$1 = state_17803;
if(cljs.core.truth_(inst_17788)){
var statearr_17817_17837 = state_17803__$1;
(statearr_17817_17837[(1)] = (10));

} else {
var statearr_17818_17838 = state_17803__$1;
(statearr_17818_17838[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17804 === (5))){
var _ = (function (){var statearr_17819 = state_17803;
(statearr_17819[(4)] = cljs.core.rest((state_17803[(4)])));

return statearr_17819;
})();
var state_17803__$1 = state_17803;
var ex17815 = (state_17803__$1[(2)]);
var statearr_17820_17839 = state_17803__$1;
(statearr_17820_17839[(5)] = ex17815);


var statearr_17821_17840 = state_17803__$1;
(statearr_17821_17840[(1)] = (4));

(statearr_17821_17840[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17804 === (10))){
var inst_17790 = cljs.core.async.close_BANG_(return_ch);
var state_17803__$1 = state_17803;
var statearr_17822_17841 = state_17803__$1;
(statearr_17822_17841[(2)] = inst_17790);

(statearr_17822_17841[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17804 === (8))){
var inst_17782 = (state_17803[(10)]);
var inst_17786 = (inst_17782 instanceof Error);
var state_17803__$1 = state_17803;
var statearr_17823_17842 = state_17803__$1;
(statearr_17823_17842[(2)] = inst_17786);

(statearr_17823_17842[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2727__auto____0 = (function (){
var statearr_17824 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17824[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2727__auto__);

(statearr_17824[(1)] = (1));

return statearr_17824;
});
var fluree$db$storage$core$reify_history_$_state_machine__2727__auto____1 = (function (state_17803){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17803);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17825){var ex__2730__auto__ = e17825;
var statearr_17826_17843 = state_17803;
(statearr_17826_17843[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17803[(4)]))){
var statearr_17827_17844 = state_17803;
(statearr_17827_17844[(1)] = cljs.core.first((state_17803[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17845 = state_17803;
state_17803 = G__17845;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2727__auto__ = function(state_17803){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2727__auto____1.call(this,state_17803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2727__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2727__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17828 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17828[(6)] = c__2749__auto___17829);

return statearr_17828;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__17847 = arguments.length;
switch (G__17847) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4251__auto__ = (rhs == null);
if(and__4251__auto__){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___17959 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17910){
var state_val_17911 = (state_17910[(1)]);
if((state_val_17911 === (7))){
var state_17910__$1 = state_17910;
var statearr_17912_17960 = state_17910__$1;
(statearr_17912_17960[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_17912_17960[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (20))){
var inst_17889 = cljs.core.PersistentVector.EMPTY;
var state_17910__$1 = state_17910;
var statearr_17913_17961 = state_17910__$1;
(statearr_17913_17961[(2)] = inst_17889);

(statearr_17913_17961[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (1))){
var state_17910__$1 = state_17910;
var statearr_17914_17962 = state_17910__$1;
(statearr_17914_17962[(2)] = null);

(statearr_17914_17962[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (24))){
var state_17910__$1 = state_17910;
var statearr_17915_17963 = state_17910__$1;
(statearr_17915_17963[(2)] = null);

(statearr_17915_17963[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (4))){
var inst_17850 = (state_17910[(2)]);
var inst_17851 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_17852 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_17850);
var inst_17853 = cljs.core.async.close_BANG_(result_ch);
var state_17910__$1 = (function (){var statearr_17916 = state_17910;
(statearr_17916[(7)] = inst_17851);

(statearr_17916[(8)] = inst_17852);

return statearr_17916;
})();
var statearr_17917_17964 = state_17910__$1;
(statearr_17917_17964[(2)] = inst_17853);

(statearr_17917_17964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (15))){
var inst_17875 = (state_17910[(2)]);
var state_17910__$1 = state_17910;
var statearr_17918_17965 = state_17910__$1;
(statearr_17918_17965[(2)] = inst_17875);

(statearr_17918_17965[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (21))){
var inst_17879 = (state_17910[(9)]);
var inst_17864 = (state_17910[(10)]);
var inst_17862 = (state_17910[(11)]);
var inst_17892 = (state_17910[(12)]);
var inst_17863 = (state_17910[(13)]);
var inst_17899 = (state_17910[(2)]);
var inst_17900 = (function (){var base_node = inst_17862;
var first_flake = inst_17863;
var node_t = inst_17864;
var source = inst_17879;
var coll = inst_17892;
var conj_QMARK_ = inst_17899;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__17920 = f.p;
var fexpr__17919 = (function (){var or__4253__auto__ = remove_preds;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__17919.cljs$core$IFn$_invoke$arity$1 ? fexpr__17919.cljs$core$IFn$_invoke$arity$1(G__17920) : fexpr__17919.call(null,G__17920));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_17901 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_17862);
var inst_17902 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17900,inst_17901,inst_17892);
var inst_17903 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_17902);
var inst_17904 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17862,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_17903);
var inst_17905 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_17904);
var _ = (function (){var statearr_17921 = state_17910;
(statearr_17921[(4)] = cljs.core.rest((state_17910[(4)])));

return statearr_17921;
})();
var state_17910__$1 = state_17910;
var statearr_17922_17966 = state_17910__$1;
(statearr_17922_17966[(2)] = inst_17905);

(statearr_17922_17966[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (13))){
var state_17910__$1 = state_17910;
var statearr_17923_17967 = state_17910__$1;
(statearr_17923_17967[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_17923_17967[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (22))){
var inst_17879 = (state_17910[(9)]);
var inst_17864 = (state_17910[(10)]);
var inst_17862 = (state_17910[(11)]);
var inst_17892 = (state_17910[(12)]);
var inst_17863 = (state_17910[(13)]);
var inst_17893 = (function (){var base_node = inst_17862;
var first_flake = inst_17863;
var node_t = inst_17864;
var source = inst_17879;
var coll = inst_17892;
return (function (f){
return f.op === true;
});
})();
var state_17910__$1 = state_17910;
var statearr_17924_17968 = state_17910__$1;
(statearr_17924_17968[(2)] = inst_17893);

(statearr_17924_17968[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (6))){
var inst_17864 = (state_17910[(10)]);
var inst_17862 = (state_17910[(11)]);
var inst_17861 = (state_17910[(2)]);
var inst_17862__$1 = fluree.db.util.async.throw_err(inst_17861);
var inst_17863 = fluree.db.dbproto._first_flake(inst_17862__$1);
var inst_17864__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_17862__$1);
var inst_17865 = (inst_17864__$1 > t);
var state_17910__$1 = (function (){var statearr_17925 = state_17910;
(statearr_17925[(10)] = inst_17864__$1);

(statearr_17925[(11)] = inst_17862__$1);

(statearr_17925[(13)] = inst_17863);

return statearr_17925;
})();
if(cljs.core.truth_(inst_17865)){
var statearr_17926_17969 = state_17910__$1;
(statearr_17926_17969[(1)] = (7));

} else {
var statearr_17927_17970 = state_17910__$1;
(statearr_17927_17970[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (17))){
var inst_17863 = (state_17910[(13)]);
var inst_17880 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_17863,rhs,leftmost_QMARK_,t);
var state_17910__$1 = state_17910;
var statearr_17928_17971 = state_17910__$1;
(statearr_17928_17971[(2)] = inst_17880);

(statearr_17928_17971[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (3))){
var inst_17908 = (state_17910[(2)]);
var state_17910__$1 = state_17910;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17910__$1,inst_17908);
} else {
if((state_val_17911 === (12))){
var inst_17877 = (state_17910[(2)]);
var state_17910__$1 = state_17910;
var statearr_17929_17972 = state_17910__$1;
(statearr_17929_17972[(2)] = inst_17877);

(statearr_17929_17972[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (2))){
var _ = (function (){var statearr_17930 = state_17910;
(statearr_17930[(4)] = cljs.core.cons((5),(state_17910[(4)])));

return statearr_17930;
})();
var inst_17859 = fluree.db.dbproto._resolve(node);
var state_17910__$1 = state_17910;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17910__$1,(6),inst_17859);
} else {
if((state_val_17911 === (23))){
var inst_17879 = (state_17910[(9)]);
var inst_17864 = (state_17910[(10)]);
var inst_17862 = (state_17910[(11)]);
var inst_17892 = (state_17910[(12)]);
var inst_17863 = (state_17910[(13)]);
var inst_17895 = (function (){var base_node = inst_17862;
var first_flake = inst_17863;
var node_t = inst_17864;
var source = inst_17879;
var coll = inst_17892;
return (function (f){
return f.op === false;
});
})();
var state_17910__$1 = state_17910;
var statearr_17931_17973 = state_17910__$1;
(statearr_17931_17973[(2)] = inst_17895);

(statearr_17931_17973[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (19))){
var inst_17882 = (state_17910[(14)]);
var inst_17885 = (state_17910[(2)]);
var inst_17886 = fluree.db.util.async.throw_err(inst_17885);
var inst_17887 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_17882,inst_17886);
var state_17910__$1 = state_17910;
var statearr_17932_17974 = state_17910__$1;
(statearr_17932_17974[(2)] = inst_17887);

(statearr_17932_17974[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (11))){
var inst_17864 = (state_17910[(10)]);
var inst_17871 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17864,t);
var state_17910__$1 = state_17910;
if(inst_17871){
var statearr_17934_17975 = state_17910__$1;
(statearr_17934_17975[(1)] = (13));

} else {
var statearr_17935_17976 = state_17910__$1;
(statearr_17935_17976[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (9))){
var inst_17879 = (state_17910[(9)]);
var inst_17879__$1 = (state_17910[(2)]);
var state_17910__$1 = (function (){var statearr_17936 = state_17910;
(statearr_17936[(9)] = inst_17879__$1);

return statearr_17936;
})();
var G__17937_17977 = inst_17879__$1;
var G__17937_17978__$1 = (((G__17937_17977 instanceof cljs.core.Keyword))?G__17937_17977.fqn:null);
switch (G__17937_17978__$1) {
case "novelty":
var statearr_17938_17980 = state_17910__$1;
(statearr_17938_17980[(1)] = (17));


break;
case "history":
var statearr_17939_17981 = state_17910__$1;
(statearr_17939_17981[(1)] = (18));


break;
case "none":
var statearr_17940_17982 = state_17910__$1;
(statearr_17940_17982[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17937_17978__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (5))){
var _ = (function (){var statearr_17941 = state_17910;
(statearr_17941[(4)] = cljs.core.rest((state_17910[(4)])));

return statearr_17941;
})();
var state_17910__$1 = state_17910;
var ex17933 = (state_17910__$1[(2)]);
var statearr_17942_17983 = state_17910__$1;
(statearr_17942_17983[(5)] = ex17933);


var statearr_17943_17984 = state_17910__$1;
(statearr_17943_17984[(1)] = (4));

(statearr_17943_17984[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (14))){
var state_17910__$1 = state_17910;
var statearr_17944_17985 = state_17910__$1;
(statearr_17944_17985[(2)] = null);

(statearr_17944_17985[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (16))){
var inst_17879 = (state_17910[(9)]);
var inst_17892 = (state_17910[(2)]);
var state_17910__$1 = (function (){var statearr_17945 = state_17910;
(statearr_17945[(12)] = inst_17892);

return statearr_17945;
})();
var G__17946_17986 = inst_17879;
var G__17946_17987__$1 = (((G__17946_17986 instanceof cljs.core.Keyword))?G__17946_17986.fqn:null);
switch (G__17946_17987__$1) {
case "novelty":
var statearr_17947_17989 = state_17910__$1;
(statearr_17947_17989[(1)] = (22));


break;
case "history":
var statearr_17948_17990 = state_17910__$1;
(statearr_17948_17990[(1)] = (23));


break;
case "none":
var statearr_17949_17991 = state_17910__$1;
(statearr_17949_17991[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17946_17987__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (10))){
var state_17910__$1 = state_17910;
var statearr_17950_17992 = state_17910__$1;
(statearr_17950_17992[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_17950_17992[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (18))){
var inst_17879 = (state_17910[(9)]);
var inst_17864 = (state_17910[(10)]);
var inst_17862 = (state_17910[(11)]);
var inst_17863 = (state_17910[(13)]);
var inst_17882 = (function (){var base_node = inst_17862;
var first_flake = inst_17863;
var node_t = inst_17864;
var source = inst_17879;
return (function (p1__17849_SHARP_){
return (p1__17849_SHARP_.t <= t);
});
})();
var inst_17883 = fluree.db.dbproto._resolve_history(node);
var state_17910__$1 = (function (){var statearr_17951 = state_17910;
(statearr_17951[(14)] = inst_17882);

return statearr_17951;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17910__$1,(19),inst_17883);
} else {
if((state_val_17911 === (8))){
var inst_17864 = (state_17910[(10)]);
var inst_17868 = (inst_17864 < t);
var state_17910__$1 = state_17910;
if(cljs.core.truth_(inst_17868)){
var statearr_17952_17993 = state_17910__$1;
(statearr_17952_17993[(1)] = (10));

} else {
var statearr_17953_17994 = state_17910__$1;
(statearr_17953_17994[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2727__auto____0 = (function (){
var statearr_17954 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17954[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2727__auto__);

(statearr_17954[(1)] = (1));

return statearr_17954;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2727__auto____1 = (function (state_17910){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17910);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17955){var ex__2730__auto__ = e17955;
var statearr_17956_17995 = state_17910;
(statearr_17956_17995[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17910[(4)]))){
var statearr_17957_17996 = state_17910;
(statearr_17957_17996[(1)] = cljs.core.first((state_17910[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17997 = state_17910;
state_17910 = G__17997;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2727__auto__ = function(state_17910){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2727__auto____1.call(this,state_17910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2727__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2727__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17958 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17958[(6)] = c__2749__auto___17959);

return statearr_17958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18057){
var state_val_18058 = (state_18057[(1)]);
if((state_val_18058 === (7))){
var inst_18008 = (state_18057[(7)]);
var inst_18012 = (inst_18008 <= from_t);
var state_18057__$1 = state_18057;
var statearr_18059_18099 = state_18057__$1;
(statearr_18059_18099[(2)] = inst_18012);

(statearr_18059_18099[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (20))){
var inst_18042 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_18043 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18042)].join('');
var inst_18044 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18045 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_18046 = cljs.core.PersistentHashMap.fromArrays(inst_18044,inst_18045);
var inst_18047 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18043,inst_18046);
var inst_18048 = (function(){throw inst_18047})();
var state_18057__$1 = state_18057;
var statearr_18060_18100 = state_18057__$1;
(statearr_18060_18100[(2)] = inst_18048);

(statearr_18060_18100[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (1))){
var state_18057__$1 = state_18057;
var statearr_18061_18101 = state_18057__$1;
(statearr_18061_18101[(2)] = null);

(statearr_18061_18101[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (4))){
var inst_18000 = (state_18057[(2)]);
var inst_18001 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_18000], 0));
var inst_18002 = (function(){throw inst_18000})();
var state_18057__$1 = (function (){var statearr_18062 = state_18057;
(statearr_18062[(8)] = inst_18001);

return statearr_18062;
})();
var statearr_18063_18102 = state_18057__$1;
(statearr_18063_18102[(2)] = inst_18002);

(statearr_18063_18102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (15))){
var inst_18027 = (state_18057[(2)]);
var state_18057__$1 = (function (){var statearr_18064 = state_18057;
(statearr_18064[(9)] = inst_18027);

return statearr_18064;
})();
if(cljs.core.truth_(from_t)){
var statearr_18065_18103 = state_18057__$1;
(statearr_18065_18103[(1)] = (16));

} else {
var statearr_18066_18104 = state_18057__$1;
(statearr_18066_18104[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (21))){
var inst_18037 = (state_18057[(10)]);
var inst_18036 = (state_18057[(11)]);
var inst_18038 = (state_18057[(12)]);
var inst_18050 = (state_18057[(2)]);
var inst_18051 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_18037,inst_18038,leftmost_QMARK_,to_t);
var inst_18052 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_18051,inst_18036);
var _ = (function (){var statearr_18067 = state_18057;
(statearr_18067[(4)] = cljs.core.rest((state_18057[(4)])));

return statearr_18067;
})();
var state_18057__$1 = (function (){var statearr_18068 = state_18057;
(statearr_18068[(13)] = inst_18050);

return statearr_18068;
})();
var statearr_18069_18105 = state_18057__$1;
(statearr_18069_18105[(2)] = inst_18052);

(statearr_18069_18105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (13))){
var inst_18008 = (state_18057[(7)]);
var inst_18020 = (state_18057[(14)]);
var inst_18023 = (function (){var node_t = inst_18008;
var G__18016 = inst_18020;
return (function (p1__17998_SHARP_){
return (p1__17998_SHARP_.t < to_t);
});
})();
var inst_18024 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_18023,inst_18020);
var state_18057__$1 = state_18057;
var statearr_18070_18106 = state_18057__$1;
(statearr_18070_18106[(2)] = inst_18024);

(statearr_18070_18106[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (6))){
var inst_18009 = (state_18057[(15)]);
var state_18057__$1 = state_18057;
var statearr_18071_18107 = state_18057__$1;
(statearr_18071_18107[(2)] = inst_18009);

(statearr_18071_18107[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (17))){
var inst_18027 = (state_18057[(9)]);
var state_18057__$1 = state_18057;
var statearr_18072_18108 = state_18057__$1;
(statearr_18072_18108[(2)] = inst_18027);

(statearr_18072_18108[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (3))){
var inst_18055 = (state_18057[(2)]);
var state_18057__$1 = state_18057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18057__$1,inst_18055);
} else {
if((state_val_18058 === (12))){
var inst_18008 = (state_18057[(7)]);
var inst_18019 = (state_18057[(2)]);
var inst_18020 = fluree.db.util.async.throw_err(inst_18019);
var inst_18021 = (to_t > inst_18008);
var state_18057__$1 = (function (){var statearr_18073 = state_18057;
(statearr_18073[(14)] = inst_18020);

return statearr_18073;
})();
if(cljs.core.truth_(inst_18021)){
var statearr_18074_18109 = state_18057__$1;
(statearr_18074_18109[(1)] = (13));

} else {
var statearr_18075_18110 = state_18057__$1;
(statearr_18075_18110[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (2))){
var inst_18009 = (state_18057[(15)]);
var _ = (function (){var statearr_18076 = state_18057;
(statearr_18076[(4)] = cljs.core.cons((5),(state_18057[(4)])));

return statearr_18076;
})();
var inst_18008 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_18009__$1 = (from_t == null);
var state_18057__$1 = (function (){var statearr_18077 = state_18057;
(statearr_18077[(7)] = inst_18008);

(statearr_18077[(15)] = inst_18009__$1);

return statearr_18077;
})();
if(cljs.core.truth_(inst_18009__$1)){
var statearr_18078_18111 = state_18057__$1;
(statearr_18078_18111[(1)] = (6));

} else {
var statearr_18079_18112 = state_18057__$1;
(statearr_18079_18112[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (19))){
var state_18057__$1 = state_18057;
var statearr_18080_18113 = state_18057__$1;
(statearr_18080_18113[(2)] = null);

(statearr_18080_18113[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (11))){
var inst_18036 = (state_18057[(2)]);
var inst_18037 = fluree.db.dbproto._first_flake(node);
var inst_18038 = fluree.db.dbproto._rhs(node);
var inst_18039 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_18057__$1 = (function (){var statearr_18082 = state_18057;
(statearr_18082[(10)] = inst_18037);

(statearr_18082[(11)] = inst_18036);

(statearr_18082[(12)] = inst_18038);

return statearr_18082;
})();
if(cljs.core.truth_(inst_18039)){
var statearr_18083_18114 = state_18057__$1;
(statearr_18083_18114[(1)] = (19));

} else {
var statearr_18084_18115 = state_18057__$1;
(statearr_18084_18115[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (9))){
var inst_18017 = fluree.db.dbproto._resolve_history(node);
var state_18057__$1 = state_18057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18057__$1,(12),inst_18017);
} else {
if((state_val_18058 === (5))){
var _ = (function (){var statearr_18085 = state_18057;
(statearr_18085[(4)] = cljs.core.rest((state_18057[(4)])));

return statearr_18085;
})();
var state_18057__$1 = state_18057;
var ex18081 = (state_18057__$1[(2)]);
var statearr_18086_18116 = state_18057__$1;
(statearr_18086_18116[(5)] = ex18081);


var statearr_18087_18117 = state_18057__$1;
(statearr_18087_18117[(1)] = (4));

(statearr_18087_18117[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (14))){
var inst_18020 = (state_18057[(14)]);
var state_18057__$1 = state_18057;
var statearr_18088_18118 = state_18057__$1;
(statearr_18088_18118[(2)] = inst_18020);

(statearr_18088_18118[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (16))){
var inst_18008 = (state_18057[(7)]);
var inst_18027 = (state_18057[(9)]);
var inst_18029 = (function (){var node_t = inst_18008;
var G__18016 = inst_18027;
return (function (p1__17999_SHARP_){
return (p1__17999_SHARP_.t <= from_t);
});
})();
var inst_18030 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_18029,inst_18027);
var state_18057__$1 = state_18057;
var statearr_18089_18119 = state_18057__$1;
(statearr_18089_18119[(2)] = inst_18030);

(statearr_18089_18119[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (10))){
var state_18057__$1 = state_18057;
var statearr_18090_18120 = state_18057__$1;
(statearr_18090_18120[(2)] = null);

(statearr_18090_18120[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (18))){
var inst_18033 = (state_18057[(2)]);
var state_18057__$1 = state_18057;
var statearr_18091_18121 = state_18057__$1;
(statearr_18091_18121[(2)] = inst_18033);

(statearr_18091_18121[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (8))){
var inst_18014 = (state_18057[(2)]);
var state_18057__$1 = state_18057;
if(cljs.core.truth_(inst_18014)){
var statearr_18092_18122 = state_18057__$1;
(statearr_18092_18122[(1)] = (9));

} else {
var statearr_18093_18123 = state_18057__$1;
(statearr_18093_18123[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto____0 = (function (){
var statearr_18094 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18094[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto__);

(statearr_18094[(1)] = (1));

return statearr_18094;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto____1 = (function (state_18057){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18057);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18095){var ex__2730__auto__ = e18095;
var statearr_18096_18124 = state_18057;
(statearr_18096_18124[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18057[(4)]))){
var statearr_18097_18125 = state_18057;
(statearr_18097_18125[(1)] = cljs.core.first((state_18057[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18126 = state_18057;
state_18057 = G__18126;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto__ = function(state_18057){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto____1.call(this,state_18057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18098 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18098[(6)] = c__2749__auto__);

return statearr_18098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4253__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__18127_18137 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18128_18138 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18127_18137,G__18128_18138) : object_cache.call(null,G__18127_18137,G__18128_18138));

var G__18129 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18130 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__18131 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18132 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18131,G__18132) : object_cache.call(null,G__18131,G__18132));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18129,G__18130) : object_cache.call(null,G__18129,G__18130));
} else {
var G__18133 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18134 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__18135 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18136 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18135,G__18136) : object_cache.call(null,G__18135,G__18136));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18133,G__18134) : object_cache.call(null,G__18133,G__18134));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18159){
var state_val_18160 = (state_18159[(1)]);
if((state_val_18160 === (7))){
var inst_18148 = (state_18159[(7)]);
var inst_18150 = fluree.db.storage.core.serde(conn);
var inst_18151 = fluree.db.serde.protocol._deserialize_branch(inst_18150,inst_18148);
var state_18159__$1 = state_18159;
var statearr_18161_18180 = state_18159__$1;
(statearr_18161_18180[(2)] = inst_18151);

(statearr_18161_18180[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18160 === (1))){
var state_18159__$1 = state_18159;
var statearr_18162_18181 = state_18159__$1;
(statearr_18162_18181[(2)] = null);

(statearr_18162_18181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18160 === (4))){
var inst_18139 = (state_18159[(2)]);
var state_18159__$1 = state_18159;
var statearr_18163_18182 = state_18159__$1;
(statearr_18163_18182[(2)] = inst_18139);

(statearr_18163_18182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18160 === (6))){
var inst_18148 = (state_18159[(7)]);
var inst_18147 = (state_18159[(2)]);
var inst_18148__$1 = fluree.db.util.async.throw_err(inst_18147);
var state_18159__$1 = (function (){var statearr_18164 = state_18159;
(statearr_18164[(7)] = inst_18148__$1);

return statearr_18164;
})();
if(cljs.core.truth_(inst_18148__$1)){
var statearr_18165_18183 = state_18159__$1;
(statearr_18165_18183[(1)] = (7));

} else {
var statearr_18166_18184 = state_18159__$1;
(statearr_18166_18184[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18160 === (3))){
var inst_18157 = (state_18159[(2)]);
var state_18159__$1 = state_18159;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18159__$1,inst_18157);
} else {
if((state_val_18160 === (2))){
var _ = (function (){var statearr_18168 = state_18159;
(statearr_18168[(4)] = cljs.core.cons((5),(state_18159[(4)])));

return statearr_18168;
})();
var inst_18145 = fluree.db.storage.core.storage_read(conn,key);
var state_18159__$1 = state_18159;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18159__$1,(6),inst_18145);
} else {
if((state_val_18160 === (9))){
var inst_18154 = (state_18159[(2)]);
var _ = (function (){var statearr_18169 = state_18159;
(statearr_18169[(4)] = cljs.core.rest((state_18159[(4)])));

return statearr_18169;
})();
var state_18159__$1 = state_18159;
var statearr_18170_18185 = state_18159__$1;
(statearr_18170_18185[(2)] = inst_18154);

(statearr_18170_18185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18160 === (5))){
var _ = (function (){var statearr_18171 = state_18159;
(statearr_18171[(4)] = cljs.core.rest((state_18159[(4)])));

return statearr_18171;
})();
var state_18159__$1 = state_18159;
var ex18167 = (state_18159__$1[(2)]);
var statearr_18172_18186 = state_18159__$1;
(statearr_18172_18186[(5)] = ex18167);


if((ex18167 instanceof Error)){
var statearr_18173_18187 = state_18159__$1;
(statearr_18173_18187[(1)] = (4));

(statearr_18173_18187[(5)] = null);

} else {
throw ex18167;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18160 === (8))){
var state_18159__$1 = state_18159;
var statearr_18174_18188 = state_18159__$1;
(statearr_18174_18188[(2)] = null);

(statearr_18174_18188[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0 = (function (){
var statearr_18175 = [null,null,null,null,null,null,null,null];
(statearr_18175[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2727__auto__);

(statearr_18175[(1)] = (1));

return statearr_18175;
});
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1 = (function (state_18159){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18159);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18176){var ex__2730__auto__ = e18176;
var statearr_18177_18189 = state_18159;
(statearr_18177_18189[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18159[(4)]))){
var statearr_18178_18190 = state_18159;
(statearr_18178_18190[(1)] = cljs.core.first((state_18159[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18191 = state_18159;
state_18159 = G__18191;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__ = function(state_18159){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1.call(this,state_18159);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18179 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18179[(6)] = c__2749__auto__);

return statearr_18179;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___18270 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18242){
var state_val_18243 = (state_18242[(1)]);
if((state_val_18243 === (7))){
var inst_18209 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_18210 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18211 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18212 = cljs.core.PersistentHashMap.fromArrays(inst_18210,inst_18211);
var inst_18213 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18209,inst_18212);
var inst_18214 = (function(){throw inst_18213})();
var state_18242__$1 = state_18242;
var statearr_18244_18271 = state_18242__$1;
(statearr_18244_18271[(2)] = inst_18214);

(statearr_18244_18271[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18243 === (1))){
var state_18242__$1 = state_18242;
var statearr_18245_18272 = state_18242__$1;
(statearr_18245_18272[(2)] = null);

(statearr_18245_18272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18243 === (4))){
var inst_18192 = (state_18242[(2)]);
var inst_18193 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_18194 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18192);
var inst_18195 = cljs.core.async.close_BANG_(return_ch);
var state_18242__$1 = (function (){var statearr_18246 = state_18242;
(statearr_18246[(7)] = inst_18194);

(statearr_18246[(8)] = inst_18193);

return statearr_18246;
})();
var statearr_18247_18273 = state_18242__$1;
(statearr_18247_18273[(2)] = inst_18195);

(statearr_18247_18273[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18243 === (6))){
var inst_18206 = (state_18242[(9)]);
var inst_18205 = (state_18242[(2)]);
var inst_18206__$1 = fluree.db.util.async.throw_err(inst_18205);
var inst_18207 = (inst_18206__$1 == null);
var state_18242__$1 = (function (){var statearr_18248 = state_18242;
(statearr_18248[(9)] = inst_18206__$1);

return statearr_18248;
})();
if(cljs.core.truth_(inst_18207)){
var statearr_18249_18274 = state_18242__$1;
(statearr_18249_18274[(1)] = (7));

} else {
var statearr_18250_18275 = state_18242__$1;
(statearr_18250_18275[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18243 === (3))){
var inst_18240 = (state_18242[(2)]);
var state_18242__$1 = state_18242;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18242__$1,inst_18240);
} else {
if((state_val_18243 === (12))){
var inst_18206 = (state_18242[(9)]);
var inst_18223 = (state_18242[(2)]);
var inst_18224 = cljs.core.__destructure_map(inst_18206);
var inst_18225 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18224,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_18226 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18224,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_18227 = config;
var inst_18228 = cljs.core.__destructure_map(inst_18227);
var inst_18229 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18228,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_18231 = (function (){var data = inst_18206;
var _ = inst_18223;
var map__18201 = inst_18224;
var children = inst_18225;
var rhs = inst_18226;
var map__18202 = inst_18228;
var comparator = inst_18229;
return (function (idx,p__18230){
var map__18251 = p__18230;
var map__18251__$1 = cljs.core.__destructure_map(map__18251);
var child = map__18251__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18251__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18251__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18251__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18251__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18251__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4251__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return (idx === (0));
} else {
return and__4251__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_18232 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_18231,inst_18225);
var inst_18233 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),inst_18232);
var inst_18234 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_18233,inst_18232);
var inst_18235 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_18229,inst_18234);
var inst_18236 = fluree.db.index.__GT_IndexNode(block,t,inst_18226,inst_18235,config,leftmost_QMARK_);
var inst_18237 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18236);
var _ = (function (){var statearr_18252 = state_18242;
(statearr_18252[(4)] = cljs.core.rest((state_18242[(4)])));

return statearr_18252;
})();
var state_18242__$1 = state_18242;
var statearr_18253_18276 = state_18242__$1;
(statearr_18253_18276[(2)] = inst_18237);

(statearr_18253_18276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18243 === (2))){
var _ = (function (){var statearr_18254 = state_18242;
(statearr_18254[(4)] = cljs.core.cons((5),(state_18242[(4)])));

return statearr_18254;
})();
var inst_18203 = fluree.db.storage.core.read_branch(conn,key);
var state_18242__$1 = state_18242;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18242__$1,(6),inst_18203);
} else {
if((state_val_18243 === (11))){
var state_18242__$1 = state_18242;
var statearr_18256_18277 = state_18242__$1;
(statearr_18256_18277[(2)] = null);

(statearr_18256_18277[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18243 === (9))){
var inst_18206 = (state_18242[(9)]);
var inst_18217 = (state_18242[(2)]);
var inst_18218 = fluree.db.util.core.exception_QMARK_(inst_18206);
var state_18242__$1 = (function (){var statearr_18257 = state_18242;
(statearr_18257[(10)] = inst_18217);

return statearr_18257;
})();
if(inst_18218){
var statearr_18258_18278 = state_18242__$1;
(statearr_18258_18278[(1)] = (10));

} else {
var statearr_18259_18279 = state_18242__$1;
(statearr_18259_18279[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18243 === (5))){
var _ = (function (){var statearr_18260 = state_18242;
(statearr_18260[(4)] = cljs.core.rest((state_18242[(4)])));

return statearr_18260;
})();
var state_18242__$1 = state_18242;
var ex18255 = (state_18242__$1[(2)]);
var statearr_18261_18280 = state_18242__$1;
(statearr_18261_18280[(5)] = ex18255);


var statearr_18262_18281 = state_18242__$1;
(statearr_18262_18281[(1)] = (4));

(statearr_18262_18281[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18243 === (10))){
var inst_18206 = (state_18242[(9)]);
var inst_18220 = (function(){throw inst_18206})();
var state_18242__$1 = state_18242;
var statearr_18263_18282 = state_18242__$1;
(statearr_18263_18282[(2)] = inst_18220);

(statearr_18263_18282[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18243 === (8))){
var state_18242__$1 = state_18242;
var statearr_18264_18283 = state_18242__$1;
(statearr_18264_18283[(2)] = null);

(statearr_18264_18283[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2727__auto____0 = (function (){
var statearr_18265 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18265[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2727__auto__);

(statearr_18265[(1)] = (1));

return statearr_18265;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2727__auto____1 = (function (state_18242){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18242);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18266){var ex__2730__auto__ = e18266;
var statearr_18267_18284 = state_18242;
(statearr_18267_18284[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18242[(4)]))){
var statearr_18268_18285 = state_18242;
(statearr_18268_18285[(1)] = cljs.core.first((state_18242[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18286 = state_18242;
state_18242 = G__18286;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2727__auto__ = function(state_18242){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2727__auto____1.call(this,state_18242);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2727__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2727__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18269 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18269[(6)] = c__2749__auto___18270);

return statearr_18269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18307){
var state_val_18308 = (state_18307[(1)]);
if((state_val_18308 === (7))){
var state_18307__$1 = state_18307;
var statearr_18309_18329 = state_18307__$1;
(statearr_18309_18329[(2)] = null);

(statearr_18309_18329[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18308 === (1))){
var state_18307__$1 = state_18307;
var statearr_18310_18330 = state_18307__$1;
(statearr_18310_18330[(2)] = null);

(statearr_18310_18330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18308 === (4))){
var inst_18287 = (state_18307[(2)]);
var state_18307__$1 = state_18307;
var statearr_18311_18331 = state_18307__$1;
(statearr_18311_18331[(2)] = inst_18287);

(statearr_18311_18331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18308 === (6))){
var inst_18293 = (state_18307[(7)]);
var inst_18295 = fluree.db.storage.core.serde(conn);
var state_18307__$1 = (function (){var statearr_18312 = state_18307;
(statearr_18312[(8)] = inst_18295);

return statearr_18312;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18307__$1,(9),inst_18293);
} else {
if((state_val_18308 === (3))){
var inst_18305 = (state_18307[(2)]);
var state_18307__$1 = state_18307;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18307__$1,inst_18305);
} else {
if((state_val_18308 === (2))){
var inst_18293 = (state_18307[(7)]);
var _ = (function (){var statearr_18314 = state_18307;
(statearr_18314[(4)] = cljs.core.cons((5),(state_18307[(4)])));

return statearr_18314;
})();
var inst_18293__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_18307__$1 = (function (){var statearr_18315 = state_18307;
(statearr_18315[(7)] = inst_18293__$1);

return statearr_18315;
})();
if(cljs.core.truth_(inst_18293__$1)){
var statearr_18316_18332 = state_18307__$1;
(statearr_18316_18332[(1)] = (6));

} else {
var statearr_18317_18333 = state_18307__$1;
(statearr_18317_18333[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18308 === (9))){
var inst_18295 = (state_18307[(8)]);
var inst_18297 = (state_18307[(2)]);
var inst_18298 = fluree.db.util.async.throw_err(inst_18297);
var inst_18299 = fluree.db.serde.protocol._deserialize_leaf(inst_18295,inst_18298);
var state_18307__$1 = state_18307;
var statearr_18318_18334 = state_18307__$1;
(statearr_18318_18334[(2)] = inst_18299);

(statearr_18318_18334[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18308 === (5))){
var _ = (function (){var statearr_18319 = state_18307;
(statearr_18319[(4)] = cljs.core.rest((state_18307[(4)])));

return statearr_18319;
})();
var state_18307__$1 = state_18307;
var ex18313 = (state_18307__$1[(2)]);
var statearr_18320_18335 = state_18307__$1;
(statearr_18320_18335[(5)] = ex18313);


if((ex18313 instanceof Error)){
var statearr_18321_18336 = state_18307__$1;
(statearr_18321_18336[(1)] = (4));

(statearr_18321_18336[(5)] = null);

} else {
throw ex18313;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18308 === (8))){
var inst_18302 = (state_18307[(2)]);
var _ = (function (){var statearr_18322 = state_18307;
(statearr_18322[(4)] = cljs.core.rest((state_18307[(4)])));

return statearr_18322;
})();
var state_18307__$1 = state_18307;
var statearr_18323_18337 = state_18307__$1;
(statearr_18323_18337[(2)] = inst_18302);

(statearr_18323_18337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0 = (function (){
var statearr_18324 = [null,null,null,null,null,null,null,null,null];
(statearr_18324[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__);

(statearr_18324[(1)] = (1));

return statearr_18324;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1 = (function (state_18307){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18307);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18325){var ex__2730__auto__ = e18325;
var statearr_18326_18338 = state_18307;
(statearr_18326_18338[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18307[(4)]))){
var statearr_18327_18339 = state_18307;
(statearr_18327_18339[(1)] = cljs.core.first((state_18307[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18340 = state_18307;
state_18307 = G__18340;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__ = function(state_18307){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1.call(this,state_18307);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18328 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18328[(6)] = c__2749__auto__);

return statearr_18328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___18413 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18385){
var state_val_18386 = (state_18385[(1)]);
if((state_val_18386 === (7))){
var inst_18357 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_18358 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18359 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18360 = cljs.core.PersistentHashMap.fromArrays(inst_18358,inst_18359);
var inst_18361 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18357,inst_18360);
var inst_18362 = (function(){throw inst_18361})();
var state_18385__$1 = state_18385;
var statearr_18387_18414 = state_18385__$1;
(statearr_18387_18414[(2)] = inst_18362);

(statearr_18387_18414[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18386 === (1))){
var state_18385__$1 = state_18385;
var statearr_18388_18415 = state_18385__$1;
(statearr_18388_18415[(2)] = null);

(statearr_18388_18415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18386 === (4))){
var inst_18341 = (state_18385[(2)]);
var inst_18342 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_18343 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18341);
var inst_18344 = cljs.core.async.close_BANG_(return_ch);
var state_18385__$1 = (function (){var statearr_18389 = state_18385;
(statearr_18389[(7)] = inst_18343);

(statearr_18389[(8)] = inst_18342);

return statearr_18389;
})();
var statearr_18390_18416 = state_18385__$1;
(statearr_18390_18416[(2)] = inst_18344);

(statearr_18390_18416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18386 === (6))){
var inst_18354 = (state_18385[(9)]);
var inst_18354__$1 = (state_18385[(2)]);
var inst_18355 = (inst_18354__$1 == null);
var state_18385__$1 = (function (){var statearr_18391 = state_18385;
(statearr_18391[(9)] = inst_18354__$1);

return statearr_18391;
})();
if(cljs.core.truth_(inst_18355)){
var statearr_18392_18417 = state_18385__$1;
(statearr_18392_18417[(1)] = (7));

} else {
var statearr_18393_18418 = state_18385__$1;
(statearr_18393_18418[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18386 === (3))){
var inst_18383 = (state_18385[(2)]);
var state_18385__$1 = state_18385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18385__$1,inst_18383);
} else {
if((state_val_18386 === (12))){
var inst_18354 = (state_18385[(9)]);
var inst_18371 = (state_18385[(2)]);
var inst_18372 = cljs.core.__destructure_map(inst_18354);
var inst_18373 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18372,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_18374 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18372,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_18375 = config;
var inst_18376 = cljs.core.__destructure_map(inst_18375);
var inst_18377 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18376,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_18378 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_18377,inst_18373);
var inst_18379 = fluree.db.index.data_node(block,t,inst_18378,rhs,config);
var inst_18380 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18379);
var _ = (function (){var statearr_18394 = state_18385;
(statearr_18394[(4)] = cljs.core.rest((state_18385[(4)])));

return statearr_18394;
})();
var state_18385__$1 = (function (){var statearr_18395 = state_18385;
(statearr_18395[(10)] = inst_18371);

(statearr_18395[(11)] = inst_18374);

return statearr_18395;
})();
var statearr_18396_18419 = state_18385__$1;
(statearr_18396_18419[(2)] = inst_18380);

(statearr_18396_18419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18386 === (2))){
var _ = (function (){var statearr_18397 = state_18385;
(statearr_18397[(4)] = cljs.core.cons((5),(state_18385[(4)])));

return statearr_18397;
})();
var inst_18352 = fluree.db.storage.core.read_leaf(conn,key);
var state_18385__$1 = state_18385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18385__$1,(6),inst_18352);
} else {
if((state_val_18386 === (11))){
var state_18385__$1 = state_18385;
var statearr_18399_18420 = state_18385__$1;
(statearr_18399_18420[(2)] = null);

(statearr_18399_18420[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18386 === (9))){
var inst_18354 = (state_18385[(9)]);
var inst_18365 = (state_18385[(2)]);
var inst_18366 = fluree.db.util.core.exception_QMARK_(inst_18354);
var state_18385__$1 = (function (){var statearr_18400 = state_18385;
(statearr_18400[(12)] = inst_18365);

return statearr_18400;
})();
if(inst_18366){
var statearr_18401_18421 = state_18385__$1;
(statearr_18401_18421[(1)] = (10));

} else {
var statearr_18402_18422 = state_18385__$1;
(statearr_18402_18422[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18386 === (5))){
var _ = (function (){var statearr_18403 = state_18385;
(statearr_18403[(4)] = cljs.core.rest((state_18385[(4)])));

return statearr_18403;
})();
var state_18385__$1 = state_18385;
var ex18398 = (state_18385__$1[(2)]);
var statearr_18404_18423 = state_18385__$1;
(statearr_18404_18423[(5)] = ex18398);


var statearr_18405_18424 = state_18385__$1;
(statearr_18405_18424[(1)] = (4));

(statearr_18405_18424[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18386 === (10))){
var inst_18354 = (state_18385[(9)]);
var inst_18368 = (function(){throw inst_18354})();
var state_18385__$1 = state_18385;
var statearr_18406_18425 = state_18385__$1;
(statearr_18406_18425[(2)] = inst_18368);

(statearr_18406_18425[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18386 === (8))){
var state_18385__$1 = state_18385;
var statearr_18407_18426 = state_18385__$1;
(statearr_18407_18426[(2)] = null);

(statearr_18407_18426[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto____0 = (function (){
var statearr_18408 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18408[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto__);

(statearr_18408[(1)] = (1));

return statearr_18408;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto____1 = (function (state_18385){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18385);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18409){var ex__2730__auto__ = e18409;
var statearr_18410_18427 = state_18385;
(statearr_18410_18427[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18385[(4)]))){
var statearr_18411_18428 = state_18385;
(statearr_18411_18428[(1)] = cljs.core.first((state_18385[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18429 = state_18385;
state_18385 = G__18429;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto__ = function(state_18385){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto____1.call(this,state_18385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18412 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18412[(6)] = c__2749__auto___18413);

return statearr_18412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k18431,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__18435 = k18431;
var G__18435__$1 = (((G__18435 instanceof cljs.core.Keyword))?G__18435.fqn:null);
switch (G__18435__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k18431,else__4505__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__18436){
var vec__18437 = p__18436;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18437,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18437,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__18430){
var self__ = this;
var G__18430__$1 = this;
return (new cljs.core.RecordIter((0),G__18430__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__18440 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__18441 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__18442 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__18443 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18442,G__18443) : object_cache.call(null,G__18442,G__18443));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__18444 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__18445 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18444,G__18445) : object_cache.call(null,G__18444,G__18445));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18440,G__18441) : object_cache.call(null,G__18440,G__18441));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__18446 = history_id;
var G__18447 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18446,G__18447) : object_cache.call(null,G__18446,G__18447));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__18448 = (function (coll__4499__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__18448(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this18432,other18433){
var self__ = this;
var this18432__$1 = this;
return (((!((other18433 == null)))) && ((((this18432__$1.constructor === other18433.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18432__$1.conn,other18433.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18432__$1.config,other18433.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18432__$1.network,other18433.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18432__$1.dbid,other18433.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18432__$1.id,other18433.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18432__$1.leaf,other18433.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18432__$1.first,other18433.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18432__$1.rhs,other18433.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18432__$1.size,other18433.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18432__$1.block,other18433.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18432__$1.t,other18433.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18432__$1.tt_id,other18433.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18432__$1.leftmost_QMARK_,other18433.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18432__$1.tempid,other18433.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18432__$1.__extmap,other18433.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k18431){
var self__ = this;
var this__4509__auto____$1 = this;
var G__18449 = k18431;
var G__18449__$1 = (((G__18449 instanceof cljs.core.Keyword))?G__18449.fqn:null);
switch (G__18449__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k18431);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__18430){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__18450 = cljs.core.keyword_identical_QMARK_;
var expr__18451 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__18453 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__18454 = expr__18451;
return (pred__18450.cljs$core$IFn$_invoke$arity$2 ? pred__18450.cljs$core$IFn$_invoke$arity$2(G__18453,G__18454) : pred__18450.call(null,G__18453,G__18454));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__18430,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18455 = new cljs.core.Keyword(null,"config","config",994861415);
var G__18456 = expr__18451;
return (pred__18450.cljs$core$IFn$_invoke$arity$2 ? pred__18450.cljs$core$IFn$_invoke$arity$2(G__18455,G__18456) : pred__18450.call(null,G__18455,G__18456));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__18430,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18457 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__18458 = expr__18451;
return (pred__18450.cljs$core$IFn$_invoke$arity$2 ? pred__18450.cljs$core$IFn$_invoke$arity$2(G__18457,G__18458) : pred__18450.call(null,G__18457,G__18458));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__18430,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18459 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__18460 = expr__18451;
return (pred__18450.cljs$core$IFn$_invoke$arity$2 ? pred__18450.cljs$core$IFn$_invoke$arity$2(G__18459,G__18460) : pred__18450.call(null,G__18459,G__18460));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__18430,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18461 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__18462 = expr__18451;
return (pred__18450.cljs$core$IFn$_invoke$arity$2 ? pred__18450.cljs$core$IFn$_invoke$arity$2(G__18461,G__18462) : pred__18450.call(null,G__18461,G__18462));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__18430,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18463 = new cljs.core.Keyword(null,"leaf","leaf",1306118732);
var G__18464 = expr__18451;
return (pred__18450.cljs$core$IFn$_invoke$arity$2 ? pred__18450.cljs$core$IFn$_invoke$arity$2(G__18463,G__18464) : pred__18450.call(null,G__18463,G__18464));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__18430,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18465 = new cljs.core.Keyword(null,"first","first",-644103046);
var G__18466 = expr__18451;
return (pred__18450.cljs$core$IFn$_invoke$arity$2 ? pred__18450.cljs$core$IFn$_invoke$arity$2(G__18465,G__18466) : pred__18450.call(null,G__18465,G__18466));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__18430,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18467 = new cljs.core.Keyword(null,"rhs","rhs",-229356739);
var G__18468 = expr__18451;
return (pred__18450.cljs$core$IFn$_invoke$arity$2 ? pred__18450.cljs$core$IFn$_invoke$arity$2(G__18467,G__18468) : pred__18450.call(null,G__18467,G__18468));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__18430,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18469 = new cljs.core.Keyword(null,"size","size",1098693007);
var G__18470 = expr__18451;
return (pred__18450.cljs$core$IFn$_invoke$arity$2 ? pred__18450.cljs$core$IFn$_invoke$arity$2(G__18469,G__18470) : pred__18450.call(null,G__18469,G__18470));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__18430,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18471 = new cljs.core.Keyword(null,"block","block",664686210);
var G__18472 = expr__18451;
return (pred__18450.cljs$core$IFn$_invoke$arity$2 ? pred__18450.cljs$core$IFn$_invoke$arity$2(G__18471,G__18472) : pred__18450.call(null,G__18471,G__18472));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__18430,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18473 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__18474 = expr__18451;
return (pred__18450.cljs$core$IFn$_invoke$arity$2 ? pred__18450.cljs$core$IFn$_invoke$arity$2(G__18473,G__18474) : pred__18450.call(null,G__18473,G__18474));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__18430,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18475 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__18476 = expr__18451;
return (pred__18450.cljs$core$IFn$_invoke$arity$2 ? pred__18450.cljs$core$IFn$_invoke$arity$2(G__18475,G__18476) : pred__18450.call(null,G__18475,G__18476));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__18430,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18477 = new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559);
var G__18478 = expr__18451;
return (pred__18450.cljs$core$IFn$_invoke$arity$2 ? pred__18450.cljs$core$IFn$_invoke$arity$2(G__18477,G__18478) : pred__18450.call(null,G__18477,G__18478));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__18430,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18479 = new cljs.core.Keyword(null,"tempid","tempid",1427663222);
var G__18480 = expr__18451;
return (pred__18450.cljs$core$IFn$_invoke$arity$2 ? pred__18450.cljs$core$IFn$_invoke$arity$2(G__18479,G__18480) : pred__18450.call(null,G__18479,G__18480));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__18430,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__18430),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__18430){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__18430,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__18434){
var extmap__4542__auto__ = (function (){var G__18481 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__18434,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], 0));
if(cljs.core.record_QMARK_(G__18434)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__18481);
} else {
return G__18481;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__18434),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__18434),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__18434),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__18434),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__18434),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__18434),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__18434),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__18434),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__18434),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__18434),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__18434),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__18434),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__18434),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__18434),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__18484 = blank_db;
var map__18484__$1 = cljs.core.__destructure_map(map__18484);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18484__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18484__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18484__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__18485 = root_data;
var map__18485__$1 = cljs.core.__destructure_map(map__18485);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18485__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18485__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18485__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18485__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18507){
var state_val_18508 = (state_18507[(1)]);
if((state_val_18508 === (7))){
var state_18507__$1 = state_18507;
var statearr_18509_18529 = state_18507__$1;
(statearr_18509_18529[(2)] = null);

(statearr_18509_18529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18508 === (1))){
var state_18507__$1 = state_18507;
var statearr_18510_18530 = state_18507__$1;
(statearr_18510_18530[(2)] = null);

(statearr_18510_18530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18508 === (4))){
var inst_18486 = (state_18507[(2)]);
var state_18507__$1 = state_18507;
var statearr_18511_18531 = state_18507__$1;
(statearr_18511_18531[(2)] = inst_18486);

(statearr_18511_18531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18508 === (6))){
var inst_18493 = (state_18507[(7)]);
var inst_18495 = fluree.db.storage.core.serde(conn);
var state_18507__$1 = (function (){var statearr_18512 = state_18507;
(statearr_18512[(8)] = inst_18495);

return statearr_18512;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18507__$1,(9),inst_18493);
} else {
if((state_val_18508 === (3))){
var inst_18505 = (state_18507[(2)]);
var state_18507__$1 = state_18507;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18507__$1,inst_18505);
} else {
if((state_val_18508 === (2))){
var inst_18493 = (state_18507[(7)]);
var _ = (function (){var statearr_18514 = state_18507;
(statearr_18514[(4)] = cljs.core.cons((5),(state_18507[(4)])));

return statearr_18514;
})();
var inst_18492 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_18493__$1 = fluree.db.storage.core.storage_read(conn,inst_18492);
var state_18507__$1 = (function (){var statearr_18515 = state_18507;
(statearr_18515[(7)] = inst_18493__$1);

return statearr_18515;
})();
if(cljs.core.truth_(inst_18493__$1)){
var statearr_18516_18532 = state_18507__$1;
(statearr_18516_18532[(1)] = (6));

} else {
var statearr_18517_18533 = state_18507__$1;
(statearr_18517_18533[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18508 === (9))){
var inst_18495 = (state_18507[(8)]);
var inst_18497 = (state_18507[(2)]);
var inst_18498 = fluree.db.util.async.throw_err(inst_18497);
var inst_18499 = fluree.db.serde.protocol._deserialize_garbage(inst_18495,inst_18498);
var state_18507__$1 = state_18507;
var statearr_18518_18534 = state_18507__$1;
(statearr_18518_18534[(2)] = inst_18499);

(statearr_18518_18534[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18508 === (5))){
var _ = (function (){var statearr_18519 = state_18507;
(statearr_18519[(4)] = cljs.core.rest((state_18507[(4)])));

return statearr_18519;
})();
var state_18507__$1 = state_18507;
var ex18513 = (state_18507__$1[(2)]);
var statearr_18520_18535 = state_18507__$1;
(statearr_18520_18535[(5)] = ex18513);


if((ex18513 instanceof Error)){
var statearr_18521_18536 = state_18507__$1;
(statearr_18521_18536[(1)] = (4));

(statearr_18521_18536[(5)] = null);

} else {
throw ex18513;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18508 === (8))){
var inst_18502 = (state_18507[(2)]);
var _ = (function (){var statearr_18522 = state_18507;
(statearr_18522[(4)] = cljs.core.rest((state_18507[(4)])));

return statearr_18522;
})();
var state_18507__$1 = state_18507;
var statearr_18523_18537 = state_18507__$1;
(statearr_18523_18537[(2)] = inst_18502);

(statearr_18523_18537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0 = (function (){
var statearr_18524 = [null,null,null,null,null,null,null,null,null];
(statearr_18524[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__);

(statearr_18524[(1)] = (1));

return statearr_18524;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1 = (function (state_18507){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18507);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18525){var ex__2730__auto__ = e18525;
var statearr_18526_18538 = state_18507;
(statearr_18526_18538[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18507[(4)]))){
var statearr_18527_18539 = state_18507;
(statearr_18527_18539[(1)] = cljs.core.first((state_18507[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18540 = state_18507;
state_18507 = G__18540;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__ = function(state_18507){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1.call(this,state_18507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18528 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18528[(6)] = c__2749__auto__);

return statearr_18528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18562){
var state_val_18563 = (state_18562[(1)]);
if((state_val_18563 === (7))){
var inst_18551 = (state_18562[(7)]);
var inst_18553 = fluree.db.storage.core.serde(conn);
var inst_18554 = fluree.db.serde.protocol._deserialize_db_root(inst_18553,inst_18551);
var state_18562__$1 = state_18562;
var statearr_18564_18583 = state_18562__$1;
(statearr_18564_18583[(2)] = inst_18554);

(statearr_18564_18583[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18563 === (1))){
var state_18562__$1 = state_18562;
var statearr_18565_18584 = state_18562__$1;
(statearr_18565_18584[(2)] = null);

(statearr_18565_18584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18563 === (4))){
var inst_18541 = (state_18562[(2)]);
var state_18562__$1 = state_18562;
var statearr_18566_18585 = state_18562__$1;
(statearr_18566_18585[(2)] = inst_18541);

(statearr_18566_18585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18563 === (6))){
var inst_18551 = (state_18562[(7)]);
var inst_18550 = (state_18562[(2)]);
var inst_18551__$1 = fluree.db.util.async.throw_err(inst_18550);
var state_18562__$1 = (function (){var statearr_18567 = state_18562;
(statearr_18567[(7)] = inst_18551__$1);

return statearr_18567;
})();
if(cljs.core.truth_(inst_18551__$1)){
var statearr_18568_18586 = state_18562__$1;
(statearr_18568_18586[(1)] = (7));

} else {
var statearr_18569_18587 = state_18562__$1;
(statearr_18569_18587[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18563 === (3))){
var inst_18560 = (state_18562[(2)]);
var state_18562__$1 = state_18562;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18562__$1,inst_18560);
} else {
if((state_val_18563 === (2))){
var _ = (function (){var statearr_18571 = state_18562;
(statearr_18571[(4)] = cljs.core.cons((5),(state_18562[(4)])));

return statearr_18571;
})();
var inst_18547 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_18548 = fluree.db.storage.core.storage_read(conn,inst_18547);
var state_18562__$1 = state_18562;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18562__$1,(6),inst_18548);
} else {
if((state_val_18563 === (9))){
var inst_18557 = (state_18562[(2)]);
var _ = (function (){var statearr_18572 = state_18562;
(statearr_18572[(4)] = cljs.core.rest((state_18562[(4)])));

return statearr_18572;
})();
var state_18562__$1 = state_18562;
var statearr_18573_18588 = state_18562__$1;
(statearr_18573_18588[(2)] = inst_18557);

(statearr_18573_18588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18563 === (5))){
var _ = (function (){var statearr_18574 = state_18562;
(statearr_18574[(4)] = cljs.core.rest((state_18562[(4)])));

return statearr_18574;
})();
var state_18562__$1 = state_18562;
var ex18570 = (state_18562__$1[(2)]);
var statearr_18575_18589 = state_18562__$1;
(statearr_18575_18589[(5)] = ex18570);


if((ex18570 instanceof Error)){
var statearr_18576_18590 = state_18562__$1;
(statearr_18576_18590[(1)] = (4));

(statearr_18576_18590[(5)] = null);

} else {
throw ex18570;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18563 === (8))){
var state_18562__$1 = state_18562;
var statearr_18577_18591 = state_18562__$1;
(statearr_18577_18591[(2)] = null);

(statearr_18577_18591[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0 = (function (){
var statearr_18578 = [null,null,null,null,null,null,null,null];
(statearr_18578[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__);

(statearr_18578[(1)] = (1));

return statearr_18578;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1 = (function (state_18562){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18562);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18579){var ex__2730__auto__ = e18579;
var statearr_18580_18592 = state_18562;
(statearr_18580_18592[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18562[(4)]))){
var statearr_18581_18593 = state_18562;
(statearr_18581_18593[(1)] = cljs.core.first((state_18562[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18594 = state_18562;
state_18562 = G__18594;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__ = function(state_18562){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1.call(this,state_18562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18582 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18582[(6)] = c__2749__auto__);

return statearr_18582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18630){
var state_val_18631 = (state_18630[(1)]);
if((state_val_18631 === (7))){
var inst_18604 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_18605 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18606 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_18607 = cljs.core.PersistentHashMap.fromArrays(inst_18605,inst_18606);
var inst_18608 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18604,inst_18607);
var inst_18609 = (function(){throw inst_18608})();
var state_18630__$1 = state_18630;
var statearr_18632_18654 = state_18630__$1;
(statearr_18632_18654[(2)] = inst_18609);

(statearr_18632_18654[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18631 === (1))){
var state_18630__$1 = state_18630;
var statearr_18633_18655 = state_18630__$1;
(statearr_18633_18655[(2)] = null);

(statearr_18633_18655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18631 === (4))){
var inst_18595 = (state_18630[(2)]);
var state_18630__$1 = state_18630;
var statearr_18634_18656 = state_18630__$1;
(statearr_18634_18656[(2)] = inst_18595);

(statearr_18634_18656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18631 === (6))){
var state_18630__$1 = state_18630;
var statearr_18635_18657 = state_18630__$1;
(statearr_18635_18657[(2)] = null);

(statearr_18635_18657[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18631 === (3))){
var inst_18628 = (state_18630[(2)]);
var state_18630__$1 = state_18630;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18630__$1,inst_18628);
} else {
if((state_val_18631 === (2))){
var inst_18601 = (state_18630[(7)]);
var _ = (function (){var statearr_18636 = state_18630;
(statearr_18636[(4)] = cljs.core.cons((5),(state_18630[(4)])));

return statearr_18636;
})();
var inst_18601__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_18630__$1 = (function (){var statearr_18637 = state_18630;
(statearr_18637[(7)] = inst_18601__$1);

return statearr_18637;
})();
if(cljs.core.truth_(inst_18601__$1)){
var statearr_18638_18658 = state_18630__$1;
(statearr_18638_18658[(1)] = (6));

} else {
var statearr_18639_18659 = state_18630__$1;
(statearr_18639_18659[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18631 === (11))){
var inst_18620 = (state_18630[(8)]);
var inst_18623 = (state_18630[(2)]);
var inst_18624 = fluree.db.util.async.throw_err(inst_18623);
var inst_18625 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_18620,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_18624);
var _ = (function (){var statearr_18641 = state_18630;
(statearr_18641[(4)] = cljs.core.rest((state_18630[(4)])));

return statearr_18641;
})();
var state_18630__$1 = state_18630;
var statearr_18642_18660 = state_18630__$1;
(statearr_18642_18660[(2)] = inst_18625);

(statearr_18642_18660[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18631 === (9))){
var inst_18615 = (state_18630[(9)]);
var inst_18613 = (state_18630[(2)]);
var inst_18614 = fluree.db.util.async.throw_err(inst_18613);
var inst_18615__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_18614);
var inst_18616 = fluree.db.query.schema.schema_map(inst_18615__$1);
var state_18630__$1 = (function (){var statearr_18643 = state_18630;
(statearr_18643[(9)] = inst_18615__$1);

return statearr_18643;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18630__$1,(10),inst_18616);
} else {
if((state_val_18631 === (5))){
var _ = (function (){var statearr_18644 = state_18630;
(statearr_18644[(4)] = cljs.core.rest((state_18630[(4)])));

return statearr_18644;
})();
var state_18630__$1 = state_18630;
var ex18640 = (state_18630__$1[(2)]);
var statearr_18645_18661 = state_18630__$1;
(statearr_18645_18661[(5)] = ex18640);


if((ex18640 instanceof Error)){
var statearr_18646_18662 = state_18630__$1;
(statearr_18646_18662[(1)] = (4));

(statearr_18646_18662[(5)] = null);

} else {
throw ex18640;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18631 === (10))){
var inst_18615 = (state_18630[(9)]);
var inst_18620 = (state_18630[(8)]);
var inst_18618 = (state_18630[(2)]);
var inst_18619 = fluree.db.util.async.throw_err(inst_18618);
var inst_18620__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_18615,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_18619);
var inst_18621 = fluree.db.query.schema.setting_map(inst_18620__$1);
var state_18630__$1 = (function (){var statearr_18647 = state_18630;
(statearr_18647[(8)] = inst_18620__$1);

return statearr_18647;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18630__$1,(11),inst_18621);
} else {
if((state_val_18631 === (8))){
var inst_18601 = (state_18630[(7)]);
var inst_18611 = (state_18630[(2)]);
var state_18630__$1 = (function (){var statearr_18648 = state_18630;
(statearr_18648[(10)] = inst_18611);

return statearr_18648;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18630__$1,(9),inst_18601);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0 = (function (){
var statearr_18649 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18649[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2727__auto__);

(statearr_18649[(1)] = (1));

return statearr_18649;
});
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1 = (function (state_18630){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18630);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18650){var ex__2730__auto__ = e18650;
var statearr_18651_18663 = state_18630;
(statearr_18651_18663[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18630[(4)]))){
var statearr_18652_18664 = state_18630;
(statearr_18652_18664[(1)] = cljs.core.first((state_18630[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18665 = state_18630;
state_18630 = G__18665;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__ = function(state_18630){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1.call(this,state_18630);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18653 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18653[(6)] = c__2749__auto__);

return statearr_18653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__18667 = arguments.length;
switch (G__18667) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18720){
var state_val_18721 = (state_18720[(1)]);
if((state_val_18721 === (7))){
var inst_18677 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_18678 = (new Error(inst_18677));
var inst_18679 = (function(){throw inst_18678})();
var state_18720__$1 = state_18720;
var statearr_18722_18762 = state_18720__$1;
(statearr_18722_18762[(2)] = inst_18679);

(statearr_18722_18762[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (20))){
var inst_18711 = (state_18720[(2)]);
var state_18720__$1 = state_18720;
var statearr_18723_18763 = state_18720__$1;
(statearr_18723_18763[(2)] = inst_18711);

(statearr_18723_18763[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (1))){
var state_18720__$1 = state_18720;
var statearr_18724_18764 = state_18720__$1;
(statearr_18724_18764[(2)] = null);

(statearr_18724_18764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (4))){
var inst_18668 = (state_18720[(2)]);
var state_18720__$1 = state_18720;
var statearr_18725_18765 = state_18720__$1;
(statearr_18725_18765[(2)] = inst_18668);

(statearr_18725_18765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (15))){
var inst_18686 = (state_18720[(7)]);
var state_18720__$1 = state_18720;
var statearr_18726_18766 = state_18720__$1;
(statearr_18726_18766[(2)] = inst_18686);

(statearr_18726_18766[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (21))){
var inst_18685 = (state_18720[(8)]);
var inst_18686 = (state_18720[(7)]);
var inst_18690 = (state_18720[(9)]);
var inst_18704 = (inst_18685 + (1));
var inst_18705 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_18686,inst_18690);
var inst_18685__$1 = inst_18704;
var inst_18686__$1 = inst_18705;
var state_18720__$1 = (function (){var statearr_18727 = state_18720;
(statearr_18727[(8)] = inst_18685__$1);

(statearr_18727[(7)] = inst_18686__$1);

return statearr_18727;
})();
var statearr_18728_18767 = state_18720__$1;
(statearr_18728_18767[(2)] = null);

(statearr_18728_18767[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (13))){
var inst_18690 = (state_18720[(9)]);
var inst_18694 = (inst_18690 instanceof Error);
var state_18720__$1 = state_18720;
var statearr_18729_18768 = state_18720__$1;
(statearr_18729_18768[(2)] = inst_18694);

(statearr_18729_18768[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (22))){
var state_18720__$1 = state_18720;
var statearr_18730_18769 = state_18720__$1;
(statearr_18730_18769[(2)] = null);

(statearr_18730_18769[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (6))){
var state_18720__$1 = state_18720;
var statearr_18731_18770 = state_18720__$1;
(statearr_18731_18770[(2)] = null);

(statearr_18731_18770[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (17))){
var inst_18713 = (state_18720[(2)]);
var state_18720__$1 = state_18720;
var statearr_18732_18771 = state_18720__$1;
(statearr_18732_18771[(2)] = inst_18713);

(statearr_18732_18771[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (3))){
var inst_18718 = (state_18720[(2)]);
var state_18720__$1 = state_18720;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18720__$1,inst_18718);
} else {
if((state_val_18721 === (12))){
var inst_18691 = (state_18720[(10)]);
var state_18720__$1 = state_18720;
var statearr_18733_18772 = state_18720__$1;
(statearr_18733_18772[(2)] = inst_18691);

(statearr_18733_18772[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (2))){
var _ = (function (){var statearr_18734 = state_18720;
(statearr_18734[(4)] = cljs.core.cons((5),(state_18720[(4)])));

return statearr_18734;
})();
var inst_18674 = (end >= start);
var state_18720__$1 = state_18720;
if(cljs.core.truth_(inst_18674)){
var statearr_18735_18773 = state_18720__$1;
(statearr_18735_18773[(1)] = (6));

} else {
var statearr_18736_18774 = state_18720__$1;
(statearr_18736_18774[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (23))){
var inst_18709 = (state_18720[(2)]);
var state_18720__$1 = state_18720;
var statearr_18737_18775 = state_18720__$1;
(statearr_18737_18775[(2)] = inst_18709);

(statearr_18737_18775[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (19))){
var state_18720__$1 = state_18720;
var statearr_18738_18776 = state_18720__$1;
(statearr_18738_18776[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (11))){
var inst_18691 = (state_18720[(10)]);
var inst_18690 = (state_18720[(9)]);
var inst_18690__$1 = (state_18720[(2)]);
var inst_18691__$1 = (inst_18690__$1 == null);
var state_18720__$1 = (function (){var statearr_18741 = state_18720;
(statearr_18741[(10)] = inst_18691__$1);

(statearr_18741[(9)] = inst_18690__$1);

return statearr_18741;
})();
if(cljs.core.truth_(inst_18691__$1)){
var statearr_18742_18777 = state_18720__$1;
(statearr_18742_18777[(1)] = (12));

} else {
var statearr_18743_18778 = state_18720__$1;
(statearr_18743_18778[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (9))){
var inst_18685 = (state_18720[(8)]);
var inst_18688 = fluree.db.storage.core.read_block(conn,network,dbid,inst_18685);
var state_18720__$1 = state_18720;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18720__$1,(11),inst_18688);
} else {
if((state_val_18721 === (5))){
var _ = (function (){var statearr_18744 = state_18720;
(statearr_18744[(4)] = cljs.core.rest((state_18720[(4)])));

return statearr_18744;
})();
var state_18720__$1 = state_18720;
var ex18740 = (state_18720__$1[(2)]);
var statearr_18745_18779 = state_18720__$1;
(statearr_18745_18779[(5)] = ex18740);


if((ex18740 instanceof Error)){
var statearr_18746_18780 = state_18720__$1;
(statearr_18746_18780[(1)] = (4));

(statearr_18746_18780[(5)] = null);

} else {
throw ex18740;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (14))){
var inst_18696 = (state_18720[(2)]);
var state_18720__$1 = state_18720;
if(cljs.core.truth_(inst_18696)){
var statearr_18747_18781 = state_18720__$1;
(statearr_18747_18781[(1)] = (15));

} else {
var statearr_18748_18782 = state_18720__$1;
(statearr_18748_18782[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (16))){
var inst_18685 = (state_18720[(8)]);
var inst_18699 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18685,end);
var state_18720__$1 = state_18720;
if(inst_18699){
var statearr_18749_18783 = state_18720__$1;
(statearr_18749_18783[(1)] = (18));

} else {
var statearr_18750_18784 = state_18720__$1;
(statearr_18750_18784[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (10))){
var inst_18715 = (state_18720[(2)]);
var _ = (function (){var statearr_18751 = state_18720;
(statearr_18751[(4)] = cljs.core.rest((state_18720[(4)])));

return statearr_18751;
})();
var state_18720__$1 = state_18720;
var statearr_18752_18785 = state_18720__$1;
(statearr_18752_18785[(2)] = inst_18715);

(statearr_18752_18785[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (18))){
var inst_18686 = (state_18720[(7)]);
var inst_18690 = (state_18720[(9)]);
var inst_18701 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_18686,inst_18690);
var state_18720__$1 = state_18720;
var statearr_18753_18786 = state_18720__$1;
(statearr_18753_18786[(2)] = inst_18701);

(statearr_18753_18786[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18721 === (8))){
var inst_18681 = (state_18720[(2)]);
var inst_18682 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18683 = start;
var inst_18684 = cljs.core.PersistentVector.EMPTY;
var inst_18685 = inst_18683;
var inst_18686 = inst_18684;
var state_18720__$1 = (function (){var statearr_18754 = state_18720;
(statearr_18754[(8)] = inst_18685);

(statearr_18754[(11)] = inst_18681);

(statearr_18754[(12)] = inst_18682);

(statearr_18754[(7)] = inst_18686);

return statearr_18754;
})();
var statearr_18755_18787 = state_18720__$1;
(statearr_18755_18787[(2)] = null);

(statearr_18755_18787[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_18756 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18756[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_18756[(1)] = (1));

return statearr_18756;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_18720){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18720);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18757){var ex__2730__auto__ = e18757;
var statearr_18758_18788 = state_18720;
(statearr_18758_18788[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18720[(4)]))){
var statearr_18759_18789 = state_18720;
(statearr_18759_18789[(1)] = cljs.core.first((state_18720[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18790 = state_18720;
state_18720 = G__18790;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_18720){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_18720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18760 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18760[(6)] = c__2749__auto__);

return statearr_18760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18806){
var state_val_18807 = (state_18806[(1)]);
if((state_val_18807 === (1))){
var state_18806__$1 = state_18806;
var statearr_18808_18822 = state_18806__$1;
(statearr_18808_18822[(2)] = null);

(statearr_18808_18822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18807 === (2))){
var _ = (function (){var statearr_18809 = state_18806;
(statearr_18809[(4)] = cljs.core.cons((5),(state_18806[(4)])));

return statearr_18809;
})();
var inst_18797 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_18806__$1 = state_18806;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18806__$1,(6),inst_18797);
} else {
if((state_val_18807 === (3))){
var inst_18804 = (state_18806[(2)]);
var state_18806__$1 = state_18806;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18806__$1,inst_18804);
} else {
if((state_val_18807 === (4))){
var inst_18791 = (state_18806[(2)]);
var state_18806__$1 = state_18806;
var statearr_18811_18823 = state_18806__$1;
(statearr_18811_18823[(2)] = inst_18791);

(statearr_18811_18823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18807 === (5))){
var _ = (function (){var statearr_18812 = state_18806;
(statearr_18812[(4)] = cljs.core.rest((state_18806[(4)])));

return statearr_18812;
})();
var state_18806__$1 = state_18806;
var ex18810 = (state_18806__$1[(2)]);
var statearr_18813_18824 = state_18806__$1;
(statearr_18813_18824[(5)] = ex18810);


if((ex18810 instanceof Error)){
var statearr_18814_18825 = state_18806__$1;
(statearr_18814_18825[(1)] = (4));

(statearr_18814_18825[(5)] = null);

} else {
throw ex18810;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18807 === (6))){
var inst_18799 = (state_18806[(2)]);
var inst_18800 = fluree.db.util.async.throw_err(inst_18799);
var inst_18801 = cljs.core.first(inst_18800);
var _ = (function (){var statearr_18815 = state_18806;
(statearr_18815[(4)] = cljs.core.rest((state_18806[(4)])));

return statearr_18815;
})();
var state_18806__$1 = state_18806;
var statearr_18816_18826 = state_18806__$1;
(statearr_18816_18826[(2)] = inst_18801);

(statearr_18816_18826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2727__auto____0 = (function (){
var statearr_18817 = [null,null,null,null,null,null,null];
(statearr_18817[(0)] = fluree$db$storage$core$block_$_state_machine__2727__auto__);

(statearr_18817[(1)] = (1));

return statearr_18817;
});
var fluree$db$storage$core$block_$_state_machine__2727__auto____1 = (function (state_18806){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18806);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18818){var ex__2730__auto__ = e18818;
var statearr_18819_18827 = state_18806;
(statearr_18819_18827[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18806[(4)]))){
var statearr_18820_18828 = state_18806;
(statearr_18820_18828[(1)] = cljs.core.first((state_18806[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18829 = state_18806;
state_18806 = G__18829;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2727__auto__ = function(state_18806){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2727__auto____1.call(this,state_18806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2727__auto____0;
fluree$db$storage$core$block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2727__auto____1;
return fluree$db$storage$core$block_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18821 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18821[(6)] = c__2749__auto__);

return statearr_18821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
