// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureedb');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.api_js');
goog.require('fluree.db.connection_js');
cljs.core.enable_console_print_BANG_();
if((typeof flureedb !== 'undefined') && (typeof flureedb.app_state !== 'undefined')){
} else {
flureedb.app_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"FlureeDB APIs",new cljs.core.Keyword(null,"version","version",425292698),"v0.17.0"], null));
}
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state))], 0));
flureedb.on_js_reload = (function flureedb$on_js_reload(){
return null;
});
fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *    1. level [Values: severe, warning, info, config, fine, finer, finest]
 *    
 */
flureedb.set_logging = (function flureedb$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__65618 = opts_SINGLEQUOTE_;
var map__65618__$1 = cljs.core.__destructure_map(map__65618);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65618__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(level));
});
goog.exportSymbol('flureedb.set_logging', flureedb.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 */
flureedb.connect = (function flureedb$connect(var_args){
var G__65620 = arguments.length;
switch (G__65620) {
case 1:
return flureedb.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect', flureedb.connect);

(flureedb.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 * 
 *     Returns a promise that eventually contains the connection object.
 */
flureedb.connect_p = (function flureedb$connect_p(var_args){
var G__65623 = arguments.length;
switch (G__65623) {
case 1:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect_p', flureedb.connect_p);

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureedb.close = (function flureedb$close(conn){
return fluree.db.connection_js.close(conn);
});
goog.exportSymbol('flureedb.close', flureedb.close);
/**
 * Authenticate with Fluree On-Demand
 */
flureedb.authenticate = (function flureedb$authenticate(var_args){
var G__65626 = arguments.length;
switch (G__65626) {
case 4:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.authenticate', flureedb.authenticate);

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,syncTo);
}));

(flureedb.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Attempts to generate a new user auth record account.
 */
flureedb.password_generate = (function flureedb$password_generate(var_args){
var G__65629 = arguments.length;
switch (G__65629) {
case 4:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_generate', flureedb.password_generate);

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5(conn,ledger,password,user,null);
}));

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var data = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate(conn,ledger,password,data);
}));

(flureedb.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *    Must supply ledger, password and either user or auth identifier.
 *    Expire is optional
 *    - connection - connection object to server
 *    - ledger     - ledger identifier
 *    - password   - plain-text password
 *    - user       - _user/username (TODO: should allow any _user ident in the future)
 *    - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *    - expire     - requested time to expire in milliseconds
 */
flureedb.password_login = (function flureedb$password_login(var_args){
var G__65632 = arguments.length;
switch (G__65632) {
case 4:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_login', flureedb.password_login);

(flureedb.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4(conn,ledger,password,user);
}));

(flureedb.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,auth,expire);
}));

(flureedb.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *    Returns a promise that eventually contains the token or an exception
 */
flureedb.renew_token = (function flureedb$renew_token(var_args){
var G__65635 = arguments.length;
switch (G__65635) {
case 2:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.renew_token', flureedb.renew_token);

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,expire);
}));

(flureedb.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureedb.db = (function flureedb$db(var_args){
var args__4870__auto__ = [];
var len__4864__auto___65644 = arguments.length;
var i__4865__auto___65645 = (0);
while(true){
if((i__4865__auto___65645 < len__4864__auto___65644)){
args__4870__auto__.push((arguments[i__4865__auto___65645]));

var G__65646 = (i__4865__auto___65645 + (1));
i__4865__auto___65645 = G__65646;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return flureedb.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});
goog.exportSymbol('flureedb.db', flureedb.db);

(flureedb.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__65640){
var vec__65641 = p__65640;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65641,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts__$1);
}));

(flureedb.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureedb.db.cljs$lang$applyTo = (function (seq65637){
var G__65638 = cljs.core.first(seq65637);
var seq65637__$1 = cljs.core.next(seq65637);
var G__65639 = cljs.core.first(seq65637__$1);
var seq65637__$2 = cljs.core.next(seq65637__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65638,G__65639,seq65637__$2);
}));

/**
 * Returns db's schema map.
 */
flureedb.db_schema = (function flureedb$db_schema(db){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65665){
var state_val_65666 = (state_65665[(1)]);
if((state_val_65666 === (1))){
var state_65665__$1 = state_65665;
var statearr_65667_65682 = state_65665__$1;
(statearr_65667_65682[(2)] = null);

(statearr_65667_65682[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65666 === (2))){
var _ = (function (){var statearr_65668 = state_65665;
(statearr_65668[(4)] = cljs.core.cons((5),(state_65665[(4)])));

return statearr_65668;
})();
var state_65665__$1 = state_65665;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65665__$1,(6),db);
} else {
if((state_val_65666 === (3))){
var inst_65663 = (state_65665[(2)]);
var state_65665__$1 = state_65665;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65665__$1,inst_65663);
} else {
if((state_val_65666 === (4))){
var inst_65647 = (state_65665[(2)]);
var inst_65648 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65647], 0));
var inst_65649 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_65647) : reject.call(null,inst_65647));
var state_65665__$1 = (function (){var statearr_65670 = state_65665;
(statearr_65670[(7)] = inst_65648);

return statearr_65670;
})();
var statearr_65671_65683 = state_65665__$1;
(statearr_65671_65683[(2)] = inst_65649);

(statearr_65671_65683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65666 === (5))){
var _ = (function (){var statearr_65672 = state_65665;
(statearr_65672[(4)] = cljs.core.rest((state_65665[(4)])));

return statearr_65672;
})();
var state_65665__$1 = state_65665;
var ex65669 = (state_65665__$1[(2)]);
var statearr_65673_65684 = state_65665__$1;
(statearr_65673_65684[(5)] = ex65669);


var statearr_65674_65685 = state_65665__$1;
(statearr_65674_65685[(1)] = (4));

(statearr_65674_65685[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65666 === (6))){
var inst_65656 = (state_65665[(2)]);
var inst_65657 = fluree.db.util.async.throw_err(inst_65656);
var inst_65658 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_65657);
var inst_65659 = cljs.core.clj__GT_js(inst_65658);
var inst_65660 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_65659) : resolve.call(null,inst_65659));
var _ = (function (){var statearr_65675 = state_65665;
(statearr_65675[(4)] = cljs.core.rest((state_65665[(4)])));

return statearr_65675;
})();
var state_65665__$1 = state_65665;
var statearr_65676_65686 = state_65665__$1;
(statearr_65676_65686[(2)] = inst_65660);

(statearr_65676_65686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$db_schema_$_state_machine__2727__auto__ = null;
var flureedb$db_schema_$_state_machine__2727__auto____0 = (function (){
var statearr_65677 = [null,null,null,null,null,null,null,null];
(statearr_65677[(0)] = flureedb$db_schema_$_state_machine__2727__auto__);

(statearr_65677[(1)] = (1));

return statearr_65677;
});
var flureedb$db_schema_$_state_machine__2727__auto____1 = (function (state_65665){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65665);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65678){var ex__2730__auto__ = e65678;
var statearr_65679_65687 = state_65665;
(statearr_65679_65687[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65665[(4)]))){
var statearr_65680_65688 = state_65665;
(statearr_65680_65688[(1)] = cljs.core.first((state_65665[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65689 = state_65665;
state_65665 = G__65689;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$db_schema_$_state_machine__2727__auto__ = function(state_65665){
switch(arguments.length){
case 0:
return flureedb$db_schema_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$db_schema_$_state_machine__2727__auto____1.call(this,state_65665);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$db_schema_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$db_schema_$_state_machine__2727__auto____0;
flureedb$db_schema_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$db_schema_$_state_machine__2727__auto____1;
return flureedb$db_schema_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65681 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65681[(6)] = c__2749__auto__);

return statearr_65681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.db_schema', flureedb.db_schema);
/**
 * Completely deletes a ledger.
 *    Returns a promise that will have a response with a corresponding status of success.
 * 
 *    A 200 status indicates the deletion has been successfully initiated.
 *    The full deletion happens in the background on the respective ledger.
 * 
 *    Query servers get notified when this process initiates, and ledger will be marked as
 *    being in a deletion state during the deletion process.
 * 
 *    Attempts to use a ledger in a deletion state will throw an exception.
 */
flureedb.delete_ledger = (function flureedb$delete_ledger(var_args){
var G__65691 = arguments.length;
switch (G__65691) {
case 2:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.delete_ledger', flureedb.delete_ledger);

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65761){
var state_val_65762 = (state_65761[(1)]);
if((state_val_65762 === (7))){
var inst_65704 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_65761__$1 = state_65761;
var statearr_65763_65808 = state_65761__$1;
(statearr_65763_65808[(2)] = inst_65704);

(statearr_65763_65808[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (20))){
var inst_65712 = (state_65761[(7)]);
var inst_65736 = (state_65761[(2)]);
var state_65761__$1 = (function (){var statearr_65764 = state_65761;
(statearr_65764[(8)] = inst_65736);

return statearr_65764;
})();
if(cljs.core.truth_(inst_65712)){
var statearr_65765_65809 = state_65761__$1;
(statearr_65765_65809[(1)] = (21));

} else {
var statearr_65766_65810 = state_65761__$1;
(statearr_65766_65810[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (1))){
var state_65761__$1 = state_65761;
var statearr_65767_65811 = state_65761__$1;
(statearr_65767_65811[(2)] = null);

(statearr_65767_65811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (24))){
var inst_65743 = (state_65761[(2)]);
var inst_65744 = fluree.db.util.async.throw_err(inst_65743);
var state_65761__$1 = state_65761;
var statearr_65768_65812 = state_65761__$1;
(statearr_65768_65812[(2)] = inst_65744);

(statearr_65768_65812[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (4))){
var inst_65692 = (state_65761[(2)]);
var inst_65693 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65692], 0));
var inst_65694 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_65692) : reject.call(null,inst_65692));
var state_65761__$1 = (function (){var statearr_65769 = state_65761;
(statearr_65769[(9)] = inst_65693);

return statearr_65769;
})();
var statearr_65770_65813 = state_65761__$1;
(statearr_65770_65813[(2)] = inst_65694);

(statearr_65770_65813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (15))){
var inst_65725 = (state_65761[(10)]);
var inst_65727 = fluree.db.util.core.without_nils(inst_65725);
var inst_65728 = fluree.db.util.json.stringify(inst_65727);
var state_65761__$1 = state_65761;
var statearr_65771_65814 = state_65761__$1;
(statearr_65771_65814[(2)] = inst_65728);

(statearr_65771_65814[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (21))){
var inst_65736 = (state_65761[(8)]);
var inst_65731 = (state_65761[(11)]);
var inst_65738 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_65739 = [inst_65731,inst_65736];
var inst_65740 = cljs.core.PersistentHashMap.fromArrays(inst_65738,inst_65739);
var inst_65741 = fluree.db.operations.command_async(conn,inst_65740);
var state_65761__$1 = state_65761;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65761__$1,(24),inst_65741);
} else {
if((state_val_65762 === (13))){
var inst_65713 = (state_65761[(12)]);
var inst_65720 = (inst_65713 + (30000));
var state_65761__$1 = state_65761;
var statearr_65772_65815 = state_65761__$1;
(statearr_65772_65815[(2)] = inst_65720);

(statearr_65772_65815[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (22))){
var inst_65725 = (state_65761[(10)]);
var inst_65746 = fluree.db.operations.unsigned_command_async(conn,inst_65725);
var state_65761__$1 = state_65761;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65761__$1,(25),inst_65746);
} else {
if((state_val_65762 === (6))){
var state_65761__$1 = state_65761;
var statearr_65773_65816 = state_65761__$1;
(statearr_65773_65816[(2)] = null);

(statearr_65773_65816[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (25))){
var inst_65748 = (state_65761[(2)]);
var inst_65749 = fluree.db.util.async.throw_err(inst_65748);
var state_65761__$1 = state_65761;
var statearr_65774_65817 = state_65761__$1;
(statearr_65774_65817[(2)] = inst_65749);

(statearr_65774_65817[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (17))){
var inst_65712 = (state_65761[(7)]);
var inst_65731 = (state_65761[(2)]);
var state_65761__$1 = (function (){var statearr_65775 = state_65761;
(statearr_65775[(11)] = inst_65731);

return statearr_65775;
})();
if(cljs.core.truth_(inst_65712)){
var statearr_65776_65818 = state_65761__$1;
(statearr_65776_65818[(1)] = (18));

} else {
var statearr_65777_65819 = state_65761__$1;
(statearr_65777_65819[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (3))){
var inst_65759 = (state_65761[(2)]);
var state_65761__$1 = state_65761;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65761__$1,inst_65759);
} else {
if((state_val_65762 === (12))){
var inst_65710 = (state_65761[(13)]);
var state_65761__$1 = state_65761;
var statearr_65778_65820 = state_65761__$1;
(statearr_65778_65820[(2)] = inst_65710);

(statearr_65778_65820[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (2))){
var _ = (function (){var statearr_65779 = state_65761;
(statearr_65779[(4)] = cljs.core.cons((5),(state_65761[(4)])));

return statearr_65779;
})();
var inst_65701 = (opts == null);
var state_65761__$1 = state_65761;
if(cljs.core.truth_(inst_65701)){
var statearr_65780_65821 = state_65761__$1;
(statearr_65780_65821[(1)] = (6));

} else {
var statearr_65781_65822 = state_65761__$1;
(statearr_65781_65822[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (23))){
var inst_65751 = (state_65761[(2)]);
var inst_65752 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65753 = [(200),inst_65751];
var inst_65754 = cljs.core.PersistentHashMap.fromArrays(inst_65752,inst_65753);
var inst_65755 = cljs.core.clj__GT_js(inst_65754);
var inst_65756 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_65755) : resolve.call(null,inst_65755));
var _ = (function (){var statearr_65782 = state_65761;
(statearr_65782[(4)] = cljs.core.rest((state_65761[(4)])));

return statearr_65782;
})();
var state_65761__$1 = state_65761;
var statearr_65783_65823 = state_65761__$1;
(statearr_65783_65823[(2)] = inst_65756);

(statearr_65783_65823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (19))){
var state_65761__$1 = state_65761;
var statearr_65784_65824 = state_65761__$1;
(statearr_65784_65824[(2)] = null);

(statearr_65784_65824[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (11))){
var inst_65710 = (state_65761[(13)]);
var inst_65717 = (state_65761[(2)]);
var state_65761__$1 = (function (){var statearr_65786 = state_65761;
(statearr_65786[(14)] = inst_65717);

return statearr_65786;
})();
if(cljs.core.truth_(inst_65710)){
var statearr_65787_65825 = state_65761__$1;
(statearr_65787_65825[(1)] = (12));

} else {
var statearr_65788_65826 = state_65761__$1;
(statearr_65788_65826[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (9))){
var inst_65709 = (state_65761[(15)]);
var state_65761__$1 = state_65761;
var statearr_65789_65827 = state_65761__$1;
(statearr_65789_65827[(2)] = inst_65709);

(statearr_65789_65827[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (5))){
var _ = (function (){var statearr_65790 = state_65761;
(statearr_65790[(4)] = cljs.core.rest((state_65761[(4)])));

return statearr_65790;
})();
var state_65761__$1 = state_65761;
var ex65785 = (state_65761__$1[(2)]);
var statearr_65791_65828 = state_65761__$1;
(statearr_65791_65828[(5)] = ex65785);


var statearr_65792_65829 = state_65761__$1;
(statearr_65792_65829[(1)] = (4));

(statearr_65792_65829[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (14))){
var inst_65717 = (state_65761[(14)]);
var inst_65712 = (state_65761[(7)]);
var inst_65722 = (state_65761[(2)]);
var inst_65723 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_65724 = [new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),ledger,inst_65717,inst_65722];
var inst_65725 = cljs.core.PersistentHashMap.fromArrays(inst_65723,inst_65724);
var state_65761__$1 = (function (){var statearr_65793 = state_65761;
(statearr_65793[(10)] = inst_65725);

return statearr_65793;
})();
if(cljs.core.truth_(inst_65712)){
var statearr_65794_65830 = state_65761__$1;
(statearr_65794_65830[(1)] = (15));

} else {
var statearr_65795_65831 = state_65761__$1;
(statearr_65795_65831[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (16))){
var state_65761__$1 = state_65761;
var statearr_65796_65832 = state_65761__$1;
(statearr_65796_65832[(2)] = null);

(statearr_65796_65832[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (10))){
var inst_65713 = (state_65761[(12)]);
var state_65761__$1 = state_65761;
var statearr_65797_65833 = state_65761__$1;
(statearr_65797_65833[(2)] = inst_65713);

(statearr_65797_65833[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (18))){
var inst_65712 = (state_65761[(7)]);
var inst_65731 = (state_65761[(11)]);
var inst_65733 = fluree.crypto.sign_message(inst_65731,inst_65712);
var state_65761__$1 = state_65761;
var statearr_65798_65834 = state_65761__$1;
(statearr_65798_65834[(2)] = inst_65733);

(statearr_65798_65834[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (8))){
var inst_65709 = (state_65761[(15)]);
var inst_65706 = (state_65761[(2)]);
var inst_65707 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_65706);
var inst_65708 = cljs.core.__destructure_map(inst_65706);
var inst_65709__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65708,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_65710 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65708,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_65711 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_65708,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_65712 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65708,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_65713 = fluree.db.util.core.current_time_millis();
var state_65761__$1 = (function (){var statearr_65799 = state_65761;
(statearr_65799[(16)] = inst_65711);

(statearr_65799[(12)] = inst_65713);

(statearr_65799[(15)] = inst_65709__$1);

(statearr_65799[(7)] = inst_65712);

(statearr_65799[(13)] = inst_65710);

(statearr_65799[(17)] = inst_65707);

return statearr_65799;
})();
if(cljs.core.truth_(inst_65709__$1)){
var statearr_65800_65835 = state_65761__$1;
(statearr_65800_65835[(1)] = (9));

} else {
var statearr_65801_65836 = state_65761__$1;
(statearr_65801_65836[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_65802 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65802[(0)] = flureedb$state_machine__2727__auto__);

(statearr_65802[(1)] = (1));

return statearr_65802;
});
var flureedb$state_machine__2727__auto____1 = (function (state_65761){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65761);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65803){var ex__2730__auto__ = e65803;
var statearr_65804_65837 = state_65761;
(statearr_65804_65837[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65761[(4)]))){
var statearr_65805_65838 = state_65761;
(statearr_65805_65838[(1)] = cljs.core.first((state_65761[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65839 = state_65761;
state_65761 = G__65839;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_65761){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_65761);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65806 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65806[(6)] = c__2749__auto__);

return statearr_65806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise returning ledger's stats, including db size and # of flakes.
 *    If ledger doesn't exist, will return an empty map.
 */
flureedb.ledger_stats = (function flureedb$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65858){
var state_val_65859 = (state_65858[(1)]);
if((state_val_65859 === (1))){
var state_65858__$1 = state_65858;
var statearr_65860_65875 = state_65858__$1;
(statearr_65860_65875[(2)] = null);

(statearr_65860_65875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65859 === (2))){
var _ = (function (){var statearr_65861 = state_65858;
(statearr_65861[(4)] = cljs.core.cons((5),(state_65858[(4)])));

return statearr_65861;
})();
var inst_65848 = fluree.db.operations.ledger_stats_async(conn,ledger);
var state_65858__$1 = state_65858;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65858__$1,(6),inst_65848);
} else {
if((state_val_65859 === (3))){
var inst_65856 = (state_65858[(2)]);
var state_65858__$1 = state_65858;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65858__$1,inst_65856);
} else {
if((state_val_65859 === (4))){
var inst_65840 = (state_65858[(2)]);
var inst_65841 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65840], 0));
var inst_65842 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_65840) : reject.call(null,inst_65840));
var state_65858__$1 = (function (){var statearr_65863 = state_65858;
(statearr_65863[(7)] = inst_65841);

return statearr_65863;
})();
var statearr_65864_65876 = state_65858__$1;
(statearr_65864_65876[(2)] = inst_65842);

(statearr_65864_65876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65859 === (5))){
var _ = (function (){var statearr_65865 = state_65858;
(statearr_65865[(4)] = cljs.core.rest((state_65858[(4)])));

return statearr_65865;
})();
var state_65858__$1 = state_65858;
var ex65862 = (state_65858__$1[(2)]);
var statearr_65866_65877 = state_65858__$1;
(statearr_65866_65877[(5)] = ex65862);


var statearr_65867_65878 = state_65858__$1;
(statearr_65867_65878[(1)] = (4));

(statearr_65867_65878[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65859 === (6))){
var inst_65850 = (state_65858[(2)]);
var inst_65851 = fluree.db.util.async.throw_err(inst_65850);
var inst_65852 = cljs.core.clj__GT_js(inst_65851);
var inst_65853 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_65852) : resolve.call(null,inst_65852));
var _ = (function (){var statearr_65868 = state_65858;
(statearr_65868[(4)] = cljs.core.rest((state_65858[(4)])));

return statearr_65868;
})();
var state_65858__$1 = state_65858;
var statearr_65869_65879 = state_65858__$1;
(statearr_65869_65879[(2)] = inst_65853);

(statearr_65869_65879[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$ledger_stats_$_state_machine__2727__auto__ = null;
var flureedb$ledger_stats_$_state_machine__2727__auto____0 = (function (){
var statearr_65870 = [null,null,null,null,null,null,null,null];
(statearr_65870[(0)] = flureedb$ledger_stats_$_state_machine__2727__auto__);

(statearr_65870[(1)] = (1));

return statearr_65870;
});
var flureedb$ledger_stats_$_state_machine__2727__auto____1 = (function (state_65858){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65858);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65871){var ex__2730__auto__ = e65871;
var statearr_65872_65880 = state_65858;
(statearr_65872_65880[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65858[(4)]))){
var statearr_65873_65881 = state_65858;
(statearr_65873_65881[(1)] = cljs.core.first((state_65858[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65882 = state_65858;
state_65858 = G__65882;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$ledger_stats_$_state_machine__2727__auto__ = function(state_65858){
switch(arguments.length){
case 0:
return flureedb$ledger_stats_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$ledger_stats_$_state_machine__2727__auto____1.call(this,state_65858);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$ledger_stats_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$ledger_stats_$_state_machine__2727__auto____0;
flureedb$ledger_stats_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$ledger_stats_$_state_machine__2727__auto____1;
return flureedb$ledger_stats_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65874 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65874[(6)] = c__2749__auto__);

return statearr_65874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.ledger_stats', flureedb.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 *     A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 *     Once successful, will return with a command-id.
 * 
 *     Ledger creation is handled asynchronously and may not be immediately available.
 * 
 *     Options include:
 *     - :alias       - Alias, if different than db-ident.
 *     - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 *     - :doc         - Optional doc string about this db.
 *     - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 *     - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 *     - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 *     - :jwt         - token for Fluree On-Demand access
 *     
 */
flureedb.new_ledger = (function flureedb$new_ledger(var_args){
var G__65884 = arguments.length;
switch (G__65884) {
case 2:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.new_ledger', flureedb.new_ledger);

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66008){
var state_val_66009 = (state_66008[(1)]);
if((state_val_66009 === (7))){
var inst_65907 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66008__$1 = state_66008;
var statearr_66010_66080 = state_66008__$1;
(statearr_66010_66080[(2)] = inst_65907);

(statearr_66010_66080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (20))){
var inst_65914 = (state_66008[(7)]);
var inst_65953 = (state_66008[(2)]);
var inst_65954 = fluree.db.util.core.current_time_millis();
var state_66008__$1 = (function (){var statearr_66011 = state_66008;
(statearr_66011[(8)] = inst_65953);

(statearr_66011[(9)] = inst_65954);

return statearr_66011;
})();
if(cljs.core.truth_(inst_65914)){
var statearr_66012_66081 = state_66008__$1;
(statearr_66012_66081[(1)] = (21));

} else {
var statearr_66013_66082 = state_66008__$1;
(statearr_66013_66082[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (27))){
var inst_65922 = (state_66008[(10)]);
var inst_65967 = (state_66008[(11)]);
var inst_65969 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65967,new cljs.core.Keyword(null,"jwt","jwt",1504015441),inst_65922);
var state_66008__$1 = state_66008;
var statearr_66014_66083 = state_66008__$1;
(statearr_66014_66083[(2)] = inst_65969);

(statearr_66014_66083[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (1))){
var state_66008__$1 = state_66008;
var statearr_66015_66084 = state_66008__$1;
(statearr_66015_66084[(2)] = null);

(statearr_66015_66084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (24))){
var inst_65920 = (state_66008[(12)]);
var state_66008__$1 = state_66008;
var statearr_66016_66085 = state_66008__$1;
(statearr_66016_66085[(2)] = inst_65920);

(statearr_66016_66085[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (39))){
var inst_65990 = (state_66008[(2)]);
var inst_65991 = fluree.db.util.async.throw_err(inst_65990);
var state_66008__$1 = state_66008;
var statearr_66017_66086 = state_66008__$1;
(statearr_66017_66086[(2)] = inst_65991);

(statearr_66017_66086[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (4))){
var inst_65885 = (state_66008[(2)]);
var inst_65886 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65885], 0));
var inst_65887 = cljs.core.ex_data(inst_65885);
var inst_65888 = cljs.core.ex_message(inst_65885);
var inst_65889 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65887,new cljs.core.Keyword(null,"message","message",-406056002),inst_65888);
var inst_65890 = cljs.core.clj__GT_js(inst_65889);
var inst_65891 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_65890) : reject.call(null,inst_65890));
var state_66008__$1 = (function (){var statearr_66018 = state_66008;
(statearr_66018[(13)] = inst_65886);

return statearr_66018;
})();
var statearr_66019_66087 = state_66008__$1;
(statearr_66019_66087[(2)] = inst_65891);

(statearr_66019_66087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (15))){
var inst_65943 = (state_66008[(14)]);
var inst_65945 = fluree.db.graphdb.validate_ledger_name(inst_65943,"alias");
var state_66008__$1 = state_66008;
var statearr_66020_66088 = state_66008__$1;
(statearr_66020_66088[(2)] = inst_65945);

(statearr_66020_66088[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (21))){
var inst_65914 = (state_66008[(7)]);
var state_66008__$1 = state_66008;
var statearr_66021_66089 = state_66008__$1;
(statearr_66021_66089[(2)] = inst_65914);

(statearr_66021_66089[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (31))){
var state_66008__$1 = state_66008;
var statearr_66022_66090 = state_66008__$1;
(statearr_66022_66090[(2)] = null);

(statearr_66022_66090[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (32))){
var inst_65916 = (state_66008[(15)]);
var inst_65978 = (state_66008[(2)]);
var state_66008__$1 = (function (){var statearr_66023 = state_66008;
(statearr_66023[(16)] = inst_65978);

return statearr_66023;
})();
if(cljs.core.truth_(inst_65916)){
var statearr_66024_66091 = state_66008__$1;
(statearr_66024_66091[(1)] = (33));

} else {
var statearr_66025_66092 = state_66008__$1;
(statearr_66025_66092[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (40))){
var inst_65995 = (state_66008[(2)]);
var inst_65996 = fluree.db.util.async.throw_err(inst_65995);
var state_66008__$1 = state_66008;
var statearr_66026_66093 = state_66008__$1;
(statearr_66026_66093[(2)] = inst_65996);

(statearr_66026_66093[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (33))){
var inst_65916 = (state_66008[(15)]);
var inst_65978 = (state_66008[(16)]);
var inst_65980 = fluree.crypto.sign_message(inst_65978,inst_65916);
var state_66008__$1 = state_66008;
var statearr_66027_66094 = state_66008__$1;
(statearr_66027_66094[(2)] = inst_65980);

(statearr_66027_66094[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (13))){
var state_66008__$1 = state_66008;
var statearr_66028_66095 = state_66008__$1;
(statearr_66028_66095[(2)] = null);

(statearr_66028_66095[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (22))){
var inst_65954 = (state_66008[(9)]);
var state_66008__$1 = state_66008;
var statearr_66029_66096 = state_66008__$1;
(statearr_66029_66096[(2)] = inst_65954);

(statearr_66029_66096[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (36))){
var inst_65978 = (state_66008[(16)]);
var inst_65983 = (state_66008[(17)]);
var inst_65985 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_65986 = [inst_65978,inst_65983];
var inst_65987 = cljs.core.PersistentHashMap.fromArrays(inst_65985,inst_65986);
var inst_65988 = fluree.db.operations.command_async(conn,inst_65987);
var state_66008__$1 = state_66008;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66008__$1,(39),inst_65988);
} else {
if((state_val_66009 === (29))){
var inst_65916 = (state_66008[(15)]);
var inst_65972 = (state_66008[(2)]);
var state_66008__$1 = (function (){var statearr_66030 = state_66008;
(statearr_66030[(18)] = inst_65972);

return statearr_66030;
})();
if(cljs.core.truth_(inst_65916)){
var statearr_66031_66097 = state_66008__$1;
(statearr_66031_66097[(1)] = (30));

} else {
var statearr_66032_66098 = state_66008__$1;
(statearr_66032_66098[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (6))){
var state_66008__$1 = state_66008;
var statearr_66033_66099 = state_66008__$1;
(statearr_66033_66099[(2)] = null);

(statearr_66033_66099[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (28))){
var inst_65967 = (state_66008[(11)]);
var state_66008__$1 = state_66008;
var statearr_66034_66100 = state_66008__$1;
(statearr_66034_66100[(2)] = inst_65967);

(statearr_66034_66100[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (25))){
var inst_65954 = (state_66008[(9)]);
var inst_65961 = (inst_65954 + (30000));
var state_66008__$1 = state_66008;
var statearr_66035_66101 = state_66008__$1;
(statearr_66035_66101[(2)] = inst_65961);

(statearr_66035_66101[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (34))){
var state_66008__$1 = state_66008;
var statearr_66036_66102 = state_66008__$1;
(statearr_66036_66102[(2)] = null);

(statearr_66036_66102[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (17))){
var inst_65924 = (state_66008[(19)]);
var inst_65948 = (state_66008[(2)]);
var state_66008__$1 = (function (){var statearr_66037 = state_66008;
(statearr_66037[(20)] = inst_65948);

return statearr_66037;
})();
if(cljs.core.truth_(inst_65924)){
var statearr_66038_66103 = state_66008__$1;
(statearr_66038_66103[(1)] = (18));

} else {
var statearr_66039_66104 = state_66008__$1;
(statearr_66039_66104[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (3))){
var inst_66006 = (state_66008[(2)]);
var state_66008__$1 = state_66008;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66008__$1,inst_66006);
} else {
if((state_val_66009 === (12))){
var inst_65938 = fluree.db.graphdb.validate_ledger_ident(ledger);
var state_66008__$1 = state_66008;
var statearr_66040_66105 = state_66008__$1;
(statearr_66040_66105[(2)] = inst_65938);

(statearr_66040_66105[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (2))){
var _ = (function (){var statearr_66041 = state_66008;
(statearr_66041[(4)] = cljs.core.cons((5),(state_66008[(4)])));

return statearr_66041;
})();
var inst_65904 = (opts == null);
var state_66008__$1 = state_66008;
if(cljs.core.truth_(inst_65904)){
var statearr_66042_66106 = state_66008__$1;
(statearr_66042_66106[(1)] = (6));

} else {
var statearr_66043_66107 = state_66008__$1;
(statearr_66043_66107[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (23))){
var inst_65920 = (state_66008[(12)]);
var inst_65958 = (state_66008[(2)]);
var state_66008__$1 = (function (){var statearr_66044 = state_66008;
(statearr_66044[(21)] = inst_65958);

return statearr_66044;
})();
if(cljs.core.truth_(inst_65920)){
var statearr_66045_66108 = state_66008__$1;
(statearr_66045_66108[(1)] = (24));

} else {
var statearr_66046_66109 = state_66008__$1;
(statearr_66046_66109[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (35))){
var inst_65916 = (state_66008[(15)]);
var inst_65983 = (state_66008[(2)]);
var state_66008__$1 = (function (){var statearr_66047 = state_66008;
(statearr_66047[(17)] = inst_65983);

return statearr_66047;
})();
if(cljs.core.truth_(inst_65916)){
var statearr_66048_66110 = state_66008__$1;
(statearr_66048_66110[(1)] = (36));

} else {
var statearr_66049_66111 = state_66008__$1;
(statearr_66049_66111[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (19))){
var state_66008__$1 = state_66008;
var statearr_66050_66112 = state_66008__$1;
(statearr_66050_66112[(2)] = null);

(statearr_66050_66112[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (11))){
var inst_65924 = (state_66008[(19)]);
var inst_65927 = (state_66008[(22)]);
var inst_65934 = (state_66008[(23)]);
var inst_65934__$1 = (state_66008[(2)]);
var inst_65935 = fluree.db.graphdb.validate_ledger_name(inst_65934__$1,"ledger");
var inst_65936 = fluree.db.graphdb.validate_ledger_name(inst_65927,"network");
var state_66008__$1 = (function (){var statearr_66052 = state_66008;
(statearr_66052[(24)] = inst_65936);

(statearr_66052[(25)] = inst_65935);

(statearr_66052[(23)] = inst_65934__$1);

return statearr_66052;
})();
if(cljs.core.truth_(inst_65924)){
var statearr_66053_66113 = state_66008__$1;
(statearr_66053_66113[(1)] = (12));

} else {
var statearr_66054_66114 = state_66008__$1;
(statearr_66054_66114[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (9))){
var inst_65928 = (state_66008[(26)]);
var inst_65931 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_65928,(1));
var state_66008__$1 = state_66008;
var statearr_66055_66115 = state_66008__$1;
(statearr_66055_66115[(2)] = inst_65931);

(statearr_66055_66115[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (5))){
var _ = (function (){var statearr_66056 = state_66008;
(statearr_66056[(4)] = cljs.core.rest((state_66008[(4)])));

return statearr_66056;
})();
var state_66008__$1 = state_66008;
var ex66051 = (state_66008__$1[(2)]);
var statearr_66057_66116 = state_66008__$1;
(statearr_66057_66116[(5)] = ex66051);


var statearr_66058_66117 = state_66008__$1;
(statearr_66058_66117[(1)] = (4));

(statearr_66058_66117[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (14))){
var inst_65924 = (state_66008[(19)]);
var inst_65941 = (state_66008[(2)]);
var inst_65942 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65941,(0),null);
var inst_65943 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65941,(1),null);
var state_66008__$1 = (function (){var statearr_66059 = state_66008;
(statearr_66059[(14)] = inst_65943);

(statearr_66059[(27)] = inst_65942);

return statearr_66059;
})();
if(cljs.core.truth_(inst_65924)){
var statearr_66060_66118 = state_66008__$1;
(statearr_66060_66118[(1)] = (15));

} else {
var statearr_66061_66119 = state_66008__$1;
(statearr_66061_66119[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (26))){
var inst_65953 = (state_66008[(8)]);
var inst_65958 = (state_66008[(21)]);
var inst_65927 = (state_66008[(22)]);
var inst_65918 = (state_66008[(28)]);
var inst_65919 = (state_66008[(29)]);
var inst_65925 = (state_66008[(30)]);
var inst_65923 = (state_66008[(31)]);
var inst_65921 = (state_66008[(32)]);
var inst_65915 = (state_66008[(33)]);
var inst_65922 = (state_66008[(10)]);
var inst_65913 = (state_66008[(34)]);
var inst_65934 = (state_66008[(23)]);
var inst_65917 = (state_66008[(35)]);
var inst_65963 = (state_66008[(2)]);
var inst_65964 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_65965 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65927),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65934)].join('');
var inst_65966 = [inst_65965,inst_65918,inst_65919,new cljs.core.Keyword(null,"new-ledger","new-ledger",34666434),inst_65963,inst_65921,inst_65953,inst_65925,inst_65923,inst_65913,inst_65958,inst_65915,inst_65917];
var inst_65967 = cljs.core.PersistentHashMap.fromArrays(inst_65964,inst_65966);
var state_66008__$1 = (function (){var statearr_66062 = state_66008;
(statearr_66062[(11)] = inst_65967);

return statearr_66062;
})();
if(cljs.core.truth_(inst_65922)){
var statearr_66063_66120 = state_66008__$1;
(statearr_66063_66120[(1)] = (27));

} else {
var statearr_66064_66121 = state_66008__$1;
(statearr_66064_66121[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (16))){
var state_66008__$1 = state_66008;
var statearr_66065_66122 = state_66008__$1;
(statearr_66065_66122[(2)] = null);

(statearr_66065_66122[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (38))){
var inst_65998 = (state_66008[(2)]);
var inst_65999 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66000 = [(200),inst_65998];
var inst_66001 = cljs.core.PersistentHashMap.fromArrays(inst_65999,inst_66000);
var inst_66002 = cljs.core.clj__GT_js(inst_66001);
var inst_66003 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66002) : resolve.call(null,inst_66002));
var _ = (function (){var statearr_66066 = state_66008;
(statearr_66066[(4)] = cljs.core.rest((state_66008[(4)])));

return statearr_66066;
})();
var state_66008__$1 = state_66008;
var statearr_66067_66123 = state_66008__$1;
(statearr_66067_66123[(2)] = inst_66003);

(statearr_66067_66123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (30))){
var inst_65972 = (state_66008[(18)]);
var inst_65974 = fluree.db.util.core.without_nils(inst_65972);
var inst_65975 = fluree.db.util.json.stringify(inst_65974);
var state_66008__$1 = state_66008;
var statearr_66068_66124 = state_66008__$1;
(statearr_66068_66124[(2)] = inst_65975);

(statearr_66068_66124[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (10))){
var inst_65928 = (state_66008[(26)]);
var state_66008__$1 = state_66008;
var statearr_66069_66125 = state_66008__$1;
(statearr_66069_66125[(2)] = inst_65928);

(statearr_66069_66125[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (18))){
var inst_65943 = (state_66008[(14)]);
var inst_65942 = (state_66008[(27)]);
var inst_65950 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65942),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65943)].join('');
var state_66008__$1 = state_66008;
var statearr_66070_66126 = state_66008__$1;
(statearr_66070_66126[(2)] = inst_65950);

(statearr_66070_66126[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66009 === (37))){
var inst_65972 = (state_66008[(18)]);
var inst_65993 = fluree.db.operations.unsigned_command_async(conn,inst_65972);
var state_66008__$1 = state_66008;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66008__$1,(40),inst_65993);
} else {
if((state_val_66009 === (8))){
var inst_65928 = (state_66008[(26)]);
var inst_65909 = (state_66008[(2)]);
var inst_65910 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_65909);
var inst_65911 = cljs.core.__destructure_map(inst_65909);
var inst_65912 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_65911,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_65913 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65911,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_65914 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65911,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_65915 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65911,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_65916 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65911,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_65917 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65911,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_65918 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65911,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_65919 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65911,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_65920 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65911,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_65921 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65911,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_65922 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65911,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_65923 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65911,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_65924 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65911,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_65925 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65911,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_65926 = fluree.db.graphdb.validate_ledger_ident(ledger);
var inst_65927 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65926,(0),null);
var inst_65928__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65926,(1),null);
var inst_65929 = clojure.string.starts_with_QMARK_(inst_65928__$1,"$");
var state_66008__$1 = (function (){var statearr_66071 = state_66008;
(statearr_66071[(7)] = inst_65914);

(statearr_66071[(19)] = inst_65924);

(statearr_66071[(22)] = inst_65927);

(statearr_66071[(15)] = inst_65916);

(statearr_66071[(28)] = inst_65918);

(statearr_66071[(29)] = inst_65919);

(statearr_66071[(12)] = inst_65920);

(statearr_66071[(36)] = inst_65910);

(statearr_66071[(26)] = inst_65928__$1);

(statearr_66071[(30)] = inst_65925);

(statearr_66071[(31)] = inst_65923);

(statearr_66071[(32)] = inst_65921);

(statearr_66071[(37)] = inst_65912);

(statearr_66071[(33)] = inst_65915);

(statearr_66071[(10)] = inst_65922);

(statearr_66071[(34)] = inst_65913);

(statearr_66071[(35)] = inst_65917);

return statearr_66071;
})();
if(inst_65929){
var statearr_66072_66127 = state_66008__$1;
(statearr_66072_66127[(1)] = (9));

} else {
var statearr_66073_66128 = state_66008__$1;
(statearr_66073_66128[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_66074 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66074[(0)] = flureedb$state_machine__2727__auto__);

(statearr_66074[(1)] = (1));

return statearr_66074;
});
var flureedb$state_machine__2727__auto____1 = (function (state_66008){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66008);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66075){var ex__2730__auto__ = e66075;
var statearr_66076_66129 = state_66008;
(statearr_66076_66129[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66008[(4)]))){
var statearr_66077_66130 = state_66008;
(statearr_66077_66130[(1)] = cljs.core.first((state_66008[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66131 = state_66008;
state_66008 = G__66131;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_66008){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_66008);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66078 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66078[(6)] = c__2749__auto__);

return statearr_66078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *    Returns a promise that will eventually contain a response or an exception
 *    if the timeout period has expired.
 * 
 *    Response may contain an exception, if the tx resulted in an exception.
 */
flureedb.monitor_tx = (function flureedb$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66151){
var state_val_66152 = (state_66151[(1)]);
if((state_val_66152 === (1))){
var state_66151__$1 = state_66151;
var statearr_66153_66169 = state_66151__$1;
(statearr_66153_66169[(2)] = null);

(statearr_66153_66169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66152 === (2))){
var _ = (function (){var statearr_66154 = state_66151;
(statearr_66154[(4)] = cljs.core.cons((5),(state_66151[(4)])));

return statearr_66154;
})();
var inst_66141 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1(conn);
var inst_66142 = fluree.db.api_js.monitor_tx(conn,ledger,txid,timeout_ms);
var state_66151__$1 = (function (){var statearr_66155 = state_66151;
(statearr_66155[(7)] = inst_66141);

return statearr_66155;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66151__$1,(6),inst_66142);
} else {
if((state_val_66152 === (3))){
var inst_66149 = (state_66151[(2)]);
var state_66151__$1 = state_66151;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66151__$1,inst_66149);
} else {
if((state_val_66152 === (4))){
var inst_66132 = (state_66151[(2)]);
var inst_66133 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66132], 0));
var inst_66134 = cljs.core.clj__GT_js(inst_66132);
var inst_66135 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66134) : reject.call(null,inst_66134));
var state_66151__$1 = (function (){var statearr_66157 = state_66151;
(statearr_66157[(8)] = inst_66133);

return statearr_66157;
})();
var statearr_66158_66170 = state_66151__$1;
(statearr_66158_66170[(2)] = inst_66135);

(statearr_66158_66170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66152 === (5))){
var _ = (function (){var statearr_66159 = state_66151;
(statearr_66159[(4)] = cljs.core.rest((state_66151[(4)])));

return statearr_66159;
})();
var state_66151__$1 = state_66151;
var ex66156 = (state_66151__$1[(2)]);
var statearr_66160_66171 = state_66151__$1;
(statearr_66160_66171[(5)] = ex66156);


var statearr_66161_66172 = state_66151__$1;
(statearr_66161_66172[(1)] = (4));

(statearr_66161_66172[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66152 === (6))){
var inst_66144 = (state_66151[(2)]);
var inst_66145 = cljs.core.clj__GT_js(inst_66144);
var inst_66146 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66145) : resolve.call(null,inst_66145));
var _ = (function (){var statearr_66162 = state_66151;
(statearr_66162[(4)] = cljs.core.rest((state_66151[(4)])));

return statearr_66162;
})();
var state_66151__$1 = state_66151;
var statearr_66163_66173 = state_66151__$1;
(statearr_66163_66173[(2)] = inst_66146);

(statearr_66163_66173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$monitor_tx_$_state_machine__2727__auto__ = null;
var flureedb$monitor_tx_$_state_machine__2727__auto____0 = (function (){
var statearr_66164 = [null,null,null,null,null,null,null,null,null];
(statearr_66164[(0)] = flureedb$monitor_tx_$_state_machine__2727__auto__);

(statearr_66164[(1)] = (1));

return statearr_66164;
});
var flureedb$monitor_tx_$_state_machine__2727__auto____1 = (function (state_66151){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66151);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66165){var ex__2730__auto__ = e66165;
var statearr_66166_66174 = state_66151;
(statearr_66166_66174[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66151[(4)]))){
var statearr_66167_66175 = state_66151;
(statearr_66167_66175[(1)] = cljs.core.first((state_66151[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66176 = state_66151;
state_66151 = G__66176;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$monitor_tx_$_state_machine__2727__auto__ = function(state_66151){
switch(arguments.length){
case 0:
return flureedb$monitor_tx_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$monitor_tx_$_state_machine__2727__auto____1.call(this,state_66151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$monitor_tx_$_state_machine__2727__auto____0;
flureedb$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$monitor_tx_$_state_machine__2727__auto____1;
return flureedb$monitor_tx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66168 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66168[(6)] = c__2749__auto__);

return statearr_66168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.monitor_tx', flureedb.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 *     that will eventually have the result of the tx, the txid (if :txid-only option used), or
 *     an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 *     Will locally sign a final transaction command if a private key is provided via :private-key
 *     in the options, otherwise will submit the transaction to the connected ledger and request signature,
 *     provided the ledger group has a default private key available for signing.
 * 
 *     Options (opts) is a map with the following possible keys:
 *     - private-key - The private key to use for signing. If not present, a default
 *                     private key will attempt to be used from the connection, if available.
 *     - auth        - The auth id for the auth record being used. The private key must
 *                     correspond to this auth record, or an authority of this auth record.
 *     - expire      - When this transaction should expire if not yet attempted.
 *                     Defaults to 5 minutes.
 *     - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                     By default epoch milliseconds is used.
 *     - deps        - List of one or more txids that must be successfully processed before
 *                     this tx is processed. If any fail, this tx will fail. (not yet implemented)
 *     - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                     but instead return with the txid once it is successfully persisted by the
 *                     transactors. The txid can be used to look up/monitor the response at a later time.
 *     - timeout     - will respond with an exception if timeout reached before response available.
 *     - jwt         - token to access Fluree On-Demand
 *     
 */
flureedb.transact = (function flureedb$transact(var_args){
var G__66178 = arguments.length;
switch (G__66178) {
case 3:
return flureedb.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.transact', flureedb.transact);

(flureedb.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureedb.transact.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(flureedb.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66204){
var state_val_66205 = (state_66204[(1)]);
if((state_val_66205 === (7))){
var inst_66190 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66204__$1 = state_66204;
var statearr_66206_66227 = state_66204__$1;
(statearr_66206_66227[(2)] = inst_66190);

(statearr_66206_66227[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (1))){
var state_66204__$1 = state_66204;
var statearr_66207_66228 = state_66204__$1;
(statearr_66207_66228[(2)] = null);

(statearr_66207_66228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (4))){
var inst_66179 = (state_66204[(2)]);
var inst_66180 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66179], 0));
var inst_66181 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66179) : reject.call(null,inst_66179));
var state_66204__$1 = (function (){var statearr_66208 = state_66204;
(statearr_66208[(7)] = inst_66180);

return statearr_66208;
})();
var statearr_66209_66229 = state_66204__$1;
(statearr_66209_66229[(2)] = inst_66181);

(statearr_66209_66229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (6))){
var state_66204__$1 = state_66204;
var statearr_66210_66230 = state_66204__$1;
(statearr_66210_66230[(2)] = null);

(statearr_66210_66230[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (3))){
var inst_66202 = (state_66204[(2)]);
var state_66204__$1 = state_66204;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66204__$1,inst_66202);
} else {
if((state_val_66205 === (2))){
var _ = (function (){var statearr_66212 = state_66204;
(statearr_66212[(4)] = cljs.core.cons((5),(state_66204[(4)])));

return statearr_66212;
})();
var inst_66187 = (opts == null);
var state_66204__$1 = state_66204;
if(cljs.core.truth_(inst_66187)){
var statearr_66213_66231 = state_66204__$1;
(statearr_66213_66231[(1)] = (6));

} else {
var statearr_66214_66232 = state_66204__$1;
(statearr_66214_66232[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (9))){
var inst_66197 = (state_66204[(2)]);
var inst_66198 = cljs.core.clj__GT_js(inst_66197);
var inst_66199 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66198) : resolve.call(null,inst_66198));
var _ = (function (){var statearr_66215 = state_66204;
(statearr_66215[(4)] = cljs.core.rest((state_66204[(4)])));

return statearr_66215;
})();
var state_66204__$1 = state_66204;
var statearr_66216_66233 = state_66204__$1;
(statearr_66216_66233[(2)] = inst_66199);

(statearr_66216_66233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (5))){
var _ = (function (){var statearr_66217 = state_66204;
(statearr_66217[(4)] = cljs.core.rest((state_66204[(4)])));

return statearr_66217;
})();
var state_66204__$1 = state_66204;
var ex66211 = (state_66204__$1[(2)]);
var statearr_66218_66234 = state_66204__$1;
(statearr_66218_66234[(5)] = ex66211);


var statearr_66219_66235 = state_66204__$1;
(statearr_66219_66235[(1)] = (4));

(statearr_66219_66235[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (8))){
var inst_66192 = (state_66204[(2)]);
var inst_66193 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_66192);
var inst_66194 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(txn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66195 = fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_66194,inst_66192);
var state_66204__$1 = (function (){var statearr_66220 = state_66204;
(statearr_66220[(8)] = inst_66193);

return statearr_66220;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66204__$1,(9),inst_66195);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_66221 = [null,null,null,null,null,null,null,null,null];
(statearr_66221[(0)] = flureedb$state_machine__2727__auto__);

(statearr_66221[(1)] = (1));

return statearr_66221;
});
var flureedb$state_machine__2727__auto____1 = (function (state_66204){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66204);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66222){var ex__2730__auto__ = e66222;
var statearr_66223_66236 = state_66204;
(statearr_66223_66236[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66204[(4)]))){
var statearr_66224_66237 = state_66204;
(statearr_66224_66237[(1)] = cljs.core.first((state_66204[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66238 = state_66204;
state_66204 = G__66238;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_66204){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_66204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66225 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66225[(6)] = c__2749__auto__);

return statearr_66225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *    to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *    :t and :flakes.
 */
flureedb.block_range = (function flureedb$block_range(var_args){
var G__66240 = arguments.length;
switch (G__66240) {
case 3:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range', flureedb.block_range);

(flureedb.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,start,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,end,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66269){
var state_val_66270 = (state_66269[(1)]);
if((state_val_66270 === (7))){
var inst_66252 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66269__$1 = state_66269;
var statearr_66271_66292 = state_66269__$1;
(statearr_66271_66292[(2)] = inst_66252);

(statearr_66271_66292[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66270 === (1))){
var state_66269__$1 = state_66269;
var statearr_66272_66293 = state_66269__$1;
(statearr_66272_66293[(2)] = null);

(statearr_66272_66293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66270 === (4))){
var inst_66241 = (state_66269[(2)]);
var inst_66242 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66241], 0));
var inst_66243 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66241) : reject.call(null,inst_66241));
var state_66269__$1 = (function (){var statearr_66273 = state_66269;
(statearr_66273[(7)] = inst_66242);

return statearr_66273;
})();
var statearr_66274_66294 = state_66269__$1;
(statearr_66274_66294[(2)] = inst_66243);

(statearr_66274_66294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66270 === (6))){
var state_66269__$1 = state_66269;
var statearr_66275_66295 = state_66269__$1;
(statearr_66275_66295[(2)] = null);

(statearr_66275_66295[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66270 === (3))){
var inst_66267 = (state_66269[(2)]);
var state_66269__$1 = state_66269;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66269__$1,inst_66267);
} else {
if((state_val_66270 === (2))){
var _ = (function (){var statearr_66277 = state_66269;
(statearr_66277[(4)] = cljs.core.cons((5),(state_66269[(4)])));

return statearr_66277;
})();
var inst_66249 = (opts == null);
var state_66269__$1 = state_66269;
if(cljs.core.truth_(inst_66249)){
var statearr_66278_66296 = state_66269__$1;
(statearr_66278_66296[(1)] = (6));

} else {
var statearr_66279_66297 = state_66269__$1;
(statearr_66279_66297[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66270 === (9))){
var inst_66254 = (state_66269[(8)]);
var inst_66257 = (state_66269[(2)]);
var inst_66258 = fluree.db.util.async.throw_err(inst_66257);
var inst_66259 = fluree.db.query.block.block_range(inst_66258,start,end,inst_66254);
var state_66269__$1 = state_66269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66269__$1,(10),inst_66259);
} else {
if((state_val_66270 === (5))){
var _ = (function (){var statearr_66280 = state_66269;
(statearr_66280[(4)] = cljs.core.rest((state_66269[(4)])));

return statearr_66280;
})();
var state_66269__$1 = state_66269;
var ex66276 = (state_66269__$1[(2)]);
var statearr_66281_66298 = state_66269__$1;
(statearr_66281_66298[(5)] = ex66276);


var statearr_66282_66299 = state_66269__$1;
(statearr_66282_66299[(1)] = (4));

(statearr_66282_66299[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66270 === (10))){
var inst_66261 = (state_66269[(2)]);
var inst_66262 = fluree.db.util.async.throw_err(inst_66261);
var inst_66263 = cljs.core.clj__GT_js(inst_66262);
var inst_66264 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66263) : resolve.call(null,inst_66263));
var _ = (function (){var statearr_66283 = state_66269;
(statearr_66283[(4)] = cljs.core.rest((state_66269[(4)])));

return statearr_66283;
})();
var state_66269__$1 = state_66269;
var statearr_66284_66300 = state_66269__$1;
(statearr_66284_66300[(2)] = inst_66264);

(statearr_66284_66300[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66270 === (8))){
var inst_66254 = (state_66269[(8)]);
var inst_66254__$1 = (state_66269[(2)]);
var inst_66255 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66254__$1], 0));
var state_66269__$1 = (function (){var statearr_66285 = state_66269;
(statearr_66285[(8)] = inst_66254__$1);

return statearr_66285;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66269__$1,(9),inst_66255);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_66286 = [null,null,null,null,null,null,null,null,null];
(statearr_66286[(0)] = flureedb$state_machine__2727__auto__);

(statearr_66286[(1)] = (1));

return statearr_66286;
});
var flureedb$state_machine__2727__auto____1 = (function (state_66269){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66269);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66287){var ex__2730__auto__ = e66287;
var statearr_66288_66301 = state_66269;
(statearr_66288_66301[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66269[(4)]))){
var statearr_66289_66302 = state_66269;
(statearr_66289_66302[(1)] = cljs.core.first((state_66269[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66303 = state_66269;
state_66269 = G__66303;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_66269){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_66269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66290 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66290[(6)] = c__2749__auto__);

return statearr_66290;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 *     start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 *     containing keys :block :tx
 */
flureedb.block_range_with_txn = (function flureedb$block_range_with_txn(var_args){
var G__66305 = arguments.length;
switch (G__66305) {
case 3:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range_with_txn', flureedb.block_range_with_txn);

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4(conn,ledger,block_map,null);
}));

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66340){
var state_val_66341 = (state_66340[(1)]);
if((state_val_66341 === (7))){
var inst_66318 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66340__$1 = state_66340;
var statearr_66342_66363 = state_66340__$1;
(statearr_66342_66363[(2)] = inst_66318);

(statearr_66342_66363[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (1))){
var state_66340__$1 = state_66340;
var statearr_66343_66364 = state_66340__$1;
(statearr_66343_66364[(2)] = null);

(statearr_66343_66364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (4))){
var inst_66306 = (state_66340[(2)]);
var inst_66307 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66306], 0));
var inst_66308 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66306) : reject.call(null,inst_66306));
var state_66340__$1 = (function (){var statearr_66344 = state_66340;
(statearr_66344[(7)] = inst_66307);

return statearr_66344;
})();
var statearr_66345_66365 = state_66340__$1;
(statearr_66345_66365[(2)] = inst_66308);

(statearr_66345_66365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (6))){
var state_66340__$1 = state_66340;
var statearr_66346_66366 = state_66340__$1;
(statearr_66346_66366[(2)] = null);

(statearr_66346_66366[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (3))){
var inst_66338 = (state_66340[(2)]);
var state_66340__$1 = state_66340;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66340__$1,inst_66338);
} else {
if((state_val_66341 === (2))){
var _ = (function (){var statearr_66348 = state_66340;
(statearr_66348[(4)] = cljs.core.cons((5),(state_66340[(4)])));

return statearr_66348;
})();
var inst_66315 = (opts == null);
var state_66340__$1 = state_66340;
if(cljs.core.truth_(inst_66315)){
var statearr_66349_66367 = state_66340__$1;
(statearr_66349_66367[(1)] = (6));

} else {
var statearr_66350_66368 = state_66340__$1;
(statearr_66350_66368[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (9))){
var inst_66323 = (state_66340[(8)]);
var inst_66320 = (state_66340[(9)]);
var inst_66324 = (state_66340[(10)]);
var inst_66327 = (state_66340[(2)]);
var inst_66328 = fluree.db.util.async.throw_err(inst_66327);
var inst_66329 = fluree.db.query.block.block_range(inst_66328,inst_66323,inst_66324,inst_66320);
var state_66340__$1 = state_66340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66340__$1,(10),inst_66329);
} else {
if((state_val_66341 === (5))){
var _ = (function (){var statearr_66351 = state_66340;
(statearr_66351[(4)] = cljs.core.rest((state_66340[(4)])));

return statearr_66351;
})();
var state_66340__$1 = state_66340;
var ex66347 = (state_66340__$1[(2)]);
var statearr_66352_66369 = state_66340__$1;
(statearr_66352_66369[(5)] = ex66347);


var statearr_66353_66370 = state_66340__$1;
(statearr_66353_66370[(1)] = (4));

(statearr_66353_66370[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (10))){
var inst_66331 = (state_66340[(2)]);
var inst_66332 = fluree.db.util.async.throw_err(inst_66331);
var inst_66333 = fluree.db.query.range.block_with_tx_data(inst_66332);
var inst_66334 = cljs.core.clj__GT_js(inst_66333);
var inst_66335 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66334) : resolve.call(null,inst_66334));
var _ = (function (){var statearr_66354 = state_66340;
(statearr_66354[(4)] = cljs.core.rest((state_66340[(4)])));

return statearr_66354;
})();
var state_66340__$1 = state_66340;
var statearr_66355_66371 = state_66340__$1;
(statearr_66355_66371[(2)] = inst_66335);

(statearr_66355_66371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (8))){
var inst_66320 = (state_66340[(9)]);
var inst_66320__$1 = (state_66340[(2)]);
var inst_66321 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(block_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66322 = cljs.core.__destructure_map(inst_66321);
var inst_66323 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66322,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_66324 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66322,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_66325 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66320__$1], 0));
var state_66340__$1 = (function (){var statearr_66356 = state_66340;
(statearr_66356[(8)] = inst_66323);

(statearr_66356[(9)] = inst_66320__$1);

(statearr_66356[(10)] = inst_66324);

return statearr_66356;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66340__$1,(9),inst_66325);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_66357 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_66357[(0)] = flureedb$state_machine__2727__auto__);

(statearr_66357[(1)] = (1));

return statearr_66357;
});
var flureedb$state_machine__2727__auto____1 = (function (state_66340){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66340);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66358){var ex__2730__auto__ = e66358;
var statearr_66359_66372 = state_66340;
(statearr_66359_66372[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66340[(4)]))){
var statearr_66360_66373 = state_66340;
(statearr_66360_66373[(1)] = cljs.core.first((state_66340[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66374 = state_66340;
state_66340 = G__66374;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_66340){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_66340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66361 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66361[(6)] = c__2749__auto__);

return statearr_66361;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureedb.block_query = (function flureedb$block_query(var_args){
var G__66376 = arguments.length;
switch (G__66376) {
case 3:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_query', flureedb.block_query);

(flureedb.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66443){
var state_val_66444 = (state_66443[(1)]);
if((state_val_66444 === (7))){
var inst_66389 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66443__$1 = state_66443;
var statearr_66445_66486 = state_66443__$1;
(statearr_66445_66486[(2)] = inst_66389);

(statearr_66445_66486[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (20))){
var inst_66391 = (state_66443[(7)]);
var inst_66385 = (state_66443[(8)]);
var inst_66427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66428 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_66429 = (new cljs.core.PersistentVector(null,1,(5),inst_66427,inst_66428,null));
var inst_66430 = cljs.core.assoc_in(inst_66391,inst_66429,new cljs.core.Keyword(null,"block","block",664686210));
var inst_66431 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_66385,inst_66430);
var state_66443__$1 = state_66443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66443__$1,(23),inst_66431);
} else {
if((state_val_66444 === (1))){
var state_66443__$1 = state_66443;
var statearr_66446_66487 = state_66443__$1;
(statearr_66446_66487[(2)] = null);

(statearr_66446_66487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (4))){
var inst_66377 = (state_66443[(2)]);
var inst_66378 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66377], 0));
var inst_66379 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66377) : reject.call(null,inst_66377));
var state_66443__$1 = (function (){var statearr_66447 = state_66443;
(statearr_66447[(9)] = inst_66378);

return statearr_66447;
})();
var statearr_66448_66488 = state_66443__$1;
(statearr_66448_66488[(2)] = inst_66379);

(statearr_66448_66488[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (15))){
var inst_66415 = (state_66443[(2)]);
var inst_66416 = fluree.db.util.async.throw_err(inst_66415);
var state_66443__$1 = state_66443;
var statearr_66449_66489 = state_66443__$1;
(statearr_66449_66489[(2)] = inst_66416);

(statearr_66449_66489[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (21))){
var inst_66436 = (state_66443[(2)]);
var inst_66437 = cljs.core.clj__GT_js(inst_66436);
var inst_66438 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66437) : resolve.call(null,inst_66437));
var _ = (function (){var statearr_66450 = state_66443;
(statearr_66450[(4)] = cljs.core.rest((state_66443[(4)])));

return statearr_66450;
})();
var state_66443__$1 = state_66443;
var statearr_66451_66490 = state_66443__$1;
(statearr_66451_66490[(2)] = inst_66438);

(statearr_66451_66490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (13))){
var state_66443__$1 = state_66443;
var statearr_66452_66491 = state_66443__$1;
(statearr_66452_66491[(2)] = null);

(statearr_66452_66491[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (22))){
var inst_66424 = (state_66443[(2)]);
var inst_66425 = fluree.db.util.async.throw_err(inst_66424);
var state_66443__$1 = state_66443;
var statearr_66453_66492 = state_66443__$1;
(statearr_66453_66492[(2)] = inst_66425);

(statearr_66453_66492[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (6))){
var state_66443__$1 = state_66443;
var statearr_66454_66493 = state_66443__$1;
(statearr_66454_66493[(2)] = null);

(statearr_66454_66493[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (17))){
var state_66443__$1 = state_66443;
var statearr_66455_66494 = state_66443__$1;
(statearr_66455_66494[(2)] = null);

(statearr_66455_66494[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (3))){
var inst_66441 = (state_66443[(2)]);
var state_66443__$1 = state_66443;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66443__$1,inst_66441);
} else {
if((state_val_66444 === (12))){
var inst_66399 = (state_66443[(10)]);
var inst_66403 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_66443__$1 = (function (){var statearr_66456 = state_66443;
(statearr_66456[(11)] = inst_66403);

return statearr_66456;
})();
if(cljs.core.truth_(inst_66399)){
var statearr_66457_66495 = state_66443__$1;
(statearr_66457_66495[(1)] = (16));

} else {
var statearr_66458_66496 = state_66443__$1;
(statearr_66458_66496[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (2))){
var _ = (function (){var statearr_66459 = state_66443;
(statearr_66459[(4)] = cljs.core.cons((5),(state_66443[(4)])));

return statearr_66459;
})();
var inst_66385 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66386 = (opts == null);
var state_66443__$1 = (function (){var statearr_66460 = state_66443;
(statearr_66460[(8)] = inst_66385);

return statearr_66460;
})();
if(cljs.core.truth_(inst_66386)){
var statearr_66461_66497 = state_66443__$1;
(statearr_66461_66497[(1)] = (6));

} else {
var statearr_66462_66498 = state_66443__$1;
(statearr_66462_66498[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (23))){
var inst_66433 = (state_66443[(2)]);
var inst_66434 = fluree.db.util.async.throw_err(inst_66433);
var state_66443__$1 = state_66443;
var statearr_66463_66499 = state_66443__$1;
(statearr_66463_66499[(2)] = inst_66434);

(statearr_66463_66499[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (19))){
var inst_66391 = (state_66443[(7)]);
var inst_66385 = (state_66443[(8)]);
var inst_66419 = (state_66443[(12)]);
var inst_66422 = fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(inst_66419,inst_66385,inst_66391);
var state_66443__$1 = state_66443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66443__$1,(22),inst_66422);
} else {
if((state_val_66444 === (11))){
var inst_66391 = (state_66443[(7)]);
var inst_66393 = (state_66443[(13)]);
var inst_66399 = (state_66443[(2)]);
var inst_66400 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_66391);
var inst_66401 = (inst_66393 == null);
var state_66443__$1 = (function (){var statearr_66465 = state_66443;
(statearr_66465[(14)] = inst_66400);

(statearr_66465[(10)] = inst_66399);

return statearr_66465;
})();
if(cljs.core.truth_(inst_66401)){
var statearr_66466_66500 = state_66443__$1;
(statearr_66466_66500[(1)] = (12));

} else {
var statearr_66467_66501 = state_66443__$1;
(statearr_66467_66501[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (9))){
var inst_66394 = (state_66443[(15)]);
var state_66443__$1 = state_66443;
var statearr_66468_66502 = state_66443__$1;
(statearr_66468_66502[(2)] = inst_66394);

(statearr_66468_66502[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (5))){
var _ = (function (){var statearr_66469 = state_66443;
(statearr_66469[(4)] = cljs.core.rest((state_66443[(4)])));

return statearr_66469;
})();
var state_66443__$1 = state_66443;
var ex66464 = (state_66443__$1[(2)]);
var statearr_66470_66503 = state_66443__$1;
(statearr_66470_66503[(5)] = ex66464);


var statearr_66471_66504 = state_66443__$1;
(statearr_66471_66504[(1)] = (4));

(statearr_66471_66504[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (14))){
var inst_66393 = (state_66443[(13)]);
var inst_66419 = (state_66443[(2)]);
var inst_66420 = (inst_66393 == null);
var state_66443__$1 = (function (){var statearr_66472 = state_66443;
(statearr_66472[(12)] = inst_66419);

return statearr_66472;
})();
if(cljs.core.truth_(inst_66420)){
var statearr_66473_66505 = state_66443__$1;
(statearr_66473_66505[(1)] = (19));

} else {
var statearr_66474_66506 = state_66443__$1;
(statearr_66474_66506[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (16))){
var inst_66399 = (state_66443[(10)]);
var inst_66405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66406 = ["_auth/id",inst_66399];
var inst_66407 = (new cljs.core.PersistentVector(null,2,(5),inst_66405,inst_66406,null));
var state_66443__$1 = state_66443;
var statearr_66475_66507 = state_66443__$1;
(statearr_66475_66507[(2)] = inst_66407);

(statearr_66475_66507[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (10))){
var inst_66391 = (state_66443[(7)]);
var inst_66397 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_66391);
var state_66443__$1 = state_66443;
var statearr_66476_66508 = state_66443__$1;
(statearr_66476_66508[(2)] = inst_66397);

(statearr_66476_66508[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66444 === (18))){
var inst_66403 = (state_66443[(11)]);
var inst_66400 = (state_66443[(14)]);
var inst_66410 = (state_66443[(2)]);
var inst_66411 = [inst_66410,inst_66400];
var inst_66412 = cljs.core.PersistentHashMap.fromArrays(inst_66403,inst_66411);
var inst_66413 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66412], 0));
var state_66443__$1 = state_66443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66443__$1,(15),inst_66413);
} else {
if((state_val_66444 === (8))){
var inst_66394 = (state_66443[(15)]);
var inst_66391 = (state_66443[(7)]);
var inst_66391__$1 = (state_66443[(2)]);
var inst_66392 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_66391__$1);
var inst_66393 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_66391__$1);
var inst_66394__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_66391__$1);
var state_66443__$1 = (function (){var statearr_66477 = state_66443;
(statearr_66477[(15)] = inst_66394__$1);

(statearr_66477[(7)] = inst_66391__$1);

(statearr_66477[(13)] = inst_66393);

(statearr_66477[(16)] = inst_66392);

return statearr_66477;
})();
if(cljs.core.truth_(inst_66394__$1)){
var statearr_66478_66509 = state_66443__$1;
(statearr_66478_66509[(1)] = (9));

} else {
var statearr_66479_66510 = state_66443__$1;
(statearr_66479_66510[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_66480 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66480[(0)] = flureedb$state_machine__2727__auto__);

(statearr_66480[(1)] = (1));

return statearr_66480;
});
var flureedb$state_machine__2727__auto____1 = (function (state_66443){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66443);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66481){var ex__2730__auto__ = e66481;
var statearr_66482_66511 = state_66443;
(statearr_66482_66511[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66443[(4)]))){
var statearr_66483_66512 = state_66443;
(statearr_66483_66512[(1)] = cljs.core.first((state_66443[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66513 = state_66443;
state_66443 = G__66513;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_66443){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_66443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66484 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66484[(6)] = c__2749__auto__);

return statearr_66484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_query.cljs$lang$maxFixedArity = 4);

flureedb.history_query = (function flureedb$history_query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66533){
var state_val_66534 = (state_66533[(1)]);
if((state_val_66534 === (1))){
var state_66533__$1 = state_66533;
var statearr_66535_66550 = state_66533__$1;
(statearr_66535_66550[(2)] = null);

(statearr_66535_66550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66534 === (2))){
var _ = (function (){var statearr_66536 = state_66533;
(statearr_66536[(4)] = cljs.core.cons((5),(state_66533[(4)])));

return statearr_66536;
})();
var inst_66522 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66523 = fluree.db.api.query.history_query_async(sources,inst_66522);
var state_66533__$1 = state_66533;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66533__$1,(6),inst_66523);
} else {
if((state_val_66534 === (3))){
var inst_66531 = (state_66533[(2)]);
var state_66533__$1 = state_66533;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66533__$1,inst_66531);
} else {
if((state_val_66534 === (4))){
var inst_66514 = (state_66533[(2)]);
var inst_66515 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66514], 0));
var inst_66516 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66514) : reject.call(null,inst_66514));
var state_66533__$1 = (function (){var statearr_66538 = state_66533;
(statearr_66538[(7)] = inst_66515);

return statearr_66538;
})();
var statearr_66539_66551 = state_66533__$1;
(statearr_66539_66551[(2)] = inst_66516);

(statearr_66539_66551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66534 === (5))){
var _ = (function (){var statearr_66540 = state_66533;
(statearr_66540[(4)] = cljs.core.rest((state_66533[(4)])));

return statearr_66540;
})();
var state_66533__$1 = state_66533;
var ex66537 = (state_66533__$1[(2)]);
var statearr_66541_66552 = state_66533__$1;
(statearr_66541_66552[(5)] = ex66537);


var statearr_66542_66553 = state_66533__$1;
(statearr_66542_66553[(1)] = (4));

(statearr_66542_66553[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66534 === (6))){
var inst_66525 = (state_66533[(2)]);
var inst_66526 = fluree.db.util.async.throw_err(inst_66525);
var inst_66527 = cljs.core.clj__GT_js(inst_66526);
var inst_66528 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66527) : resolve.call(null,inst_66527));
var _ = (function (){var statearr_66543 = state_66533;
(statearr_66543[(4)] = cljs.core.rest((state_66533[(4)])));

return statearr_66543;
})();
var state_66533__$1 = state_66533;
var statearr_66544_66554 = state_66533__$1;
(statearr_66544_66554[(2)] = inst_66528);

(statearr_66544_66554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$history_query_$_state_machine__2727__auto__ = null;
var flureedb$history_query_$_state_machine__2727__auto____0 = (function (){
var statearr_66545 = [null,null,null,null,null,null,null,null];
(statearr_66545[(0)] = flureedb$history_query_$_state_machine__2727__auto__);

(statearr_66545[(1)] = (1));

return statearr_66545;
});
var flureedb$history_query_$_state_machine__2727__auto____1 = (function (state_66533){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66533);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66546){var ex__2730__auto__ = e66546;
var statearr_66547_66555 = state_66533;
(statearr_66547_66555[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66533[(4)]))){
var statearr_66548_66556 = state_66533;
(statearr_66548_66556[(1)] = cljs.core.first((state_66533[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66557 = state_66533;
state_66533 = G__66557;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$history_query_$_state_machine__2727__auto__ = function(state_66533){
switch(arguments.length){
case 0:
return flureedb$history_query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$history_query_$_state_machine__2727__auto____1.call(this,state_66533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$history_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$history_query_$_state_machine__2727__auto____0;
flureedb$history_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$history_query_$_state_machine__2727__auto____1;
return flureedb$history_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66549 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66549[(6)] = c__2749__auto__);

return statearr_66549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.history_query', flureedb.history_query);
flureedb.multi_query = (function flureedb$multi_query(sources,multi_query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66577){
var state_val_66578 = (state_66577[(1)]);
if((state_val_66578 === (1))){
var state_66577__$1 = state_66577;
var statearr_66579_66594 = state_66577__$1;
(statearr_66579_66594[(2)] = null);

(statearr_66579_66594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66578 === (2))){
var _ = (function (){var statearr_66580 = state_66577;
(statearr_66580[(4)] = cljs.core.cons((5),(state_66577[(4)])));

return statearr_66580;
})();
var inst_66566 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(multi_query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66567 = fluree.db.api.query.multi_query_async(sources,inst_66566);
var state_66577__$1 = state_66577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66577__$1,(6),inst_66567);
} else {
if((state_val_66578 === (3))){
var inst_66575 = (state_66577[(2)]);
var state_66577__$1 = state_66577;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66577__$1,inst_66575);
} else {
if((state_val_66578 === (4))){
var inst_66558 = (state_66577[(2)]);
var inst_66559 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66558], 0));
var inst_66560 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66558) : reject.call(null,inst_66558));
var state_66577__$1 = (function (){var statearr_66582 = state_66577;
(statearr_66582[(7)] = inst_66559);

return statearr_66582;
})();
var statearr_66583_66595 = state_66577__$1;
(statearr_66583_66595[(2)] = inst_66560);

(statearr_66583_66595[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66578 === (5))){
var _ = (function (){var statearr_66584 = state_66577;
(statearr_66584[(4)] = cljs.core.rest((state_66577[(4)])));

return statearr_66584;
})();
var state_66577__$1 = state_66577;
var ex66581 = (state_66577__$1[(2)]);
var statearr_66585_66596 = state_66577__$1;
(statearr_66585_66596[(5)] = ex66581);


var statearr_66586_66597 = state_66577__$1;
(statearr_66586_66597[(1)] = (4));

(statearr_66586_66597[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66578 === (6))){
var inst_66569 = (state_66577[(2)]);
var inst_66570 = fluree.db.util.async.throw_err(inst_66569);
var inst_66571 = cljs.core.clj__GT_js(inst_66570);
var inst_66572 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66571) : resolve.call(null,inst_66571));
var _ = (function (){var statearr_66587 = state_66577;
(statearr_66587[(4)] = cljs.core.rest((state_66577[(4)])));

return statearr_66587;
})();
var state_66577__$1 = state_66577;
var statearr_66588_66598 = state_66577__$1;
(statearr_66588_66598[(2)] = inst_66572);

(statearr_66588_66598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$multi_query_$_state_machine__2727__auto__ = null;
var flureedb$multi_query_$_state_machine__2727__auto____0 = (function (){
var statearr_66589 = [null,null,null,null,null,null,null,null];
(statearr_66589[(0)] = flureedb$multi_query_$_state_machine__2727__auto__);

(statearr_66589[(1)] = (1));

return statearr_66589;
});
var flureedb$multi_query_$_state_machine__2727__auto____1 = (function (state_66577){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66577);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66590){var ex__2730__auto__ = e66590;
var statearr_66591_66599 = state_66577;
(statearr_66591_66599[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66577[(4)]))){
var statearr_66592_66600 = state_66577;
(statearr_66592_66600[(1)] = cljs.core.first((state_66577[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66601 = state_66577;
state_66577 = G__66601;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$multi_query_$_state_machine__2727__auto__ = function(state_66577){
switch(arguments.length){
case 0:
return flureedb$multi_query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$multi_query_$_state_machine__2727__auto____1.call(this,state_66577);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$multi_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$multi_query_$_state_machine__2727__auto____0;
flureedb$multi_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$multi_query_$_state_machine__2727__auto____1;
return flureedb$multi_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66593 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66593[(6)] = c__2749__auto__);

return statearr_66593;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.multi_query', flureedb.multi_query);
/**
 * Execute a query against a database source, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise containing results.
 */
flureedb.query = (function flureedb$query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66621){
var state_val_66622 = (state_66621[(1)]);
if((state_val_66622 === (1))){
var state_66621__$1 = state_66621;
var statearr_66623_66638 = state_66621__$1;
(statearr_66623_66638[(2)] = null);

(statearr_66623_66638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66622 === (2))){
var _ = (function (){var statearr_66624 = state_66621;
(statearr_66624[(4)] = cljs.core.cons((5),(state_66621[(4)])));

return statearr_66624;
})();
var inst_66611 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66612 = fluree.db.api.query.query_async(sources,inst_66611);
var state_66621__$1 = state_66621;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66621__$1,(6),inst_66612);
} else {
if((state_val_66622 === (3))){
var inst_66619 = (state_66621[(2)]);
var state_66621__$1 = state_66621;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66621__$1,inst_66619);
} else {
if((state_val_66622 === (4))){
var inst_66602 = (state_66621[(2)]);
var inst_66603 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66602], 0));
var inst_66604 = cljs.core.clj__GT_js(inst_66602);
var inst_66605 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66604) : reject.call(null,inst_66604));
var state_66621__$1 = (function (){var statearr_66626 = state_66621;
(statearr_66626[(7)] = inst_66603);

return statearr_66626;
})();
var statearr_66627_66639 = state_66621__$1;
(statearr_66627_66639[(2)] = inst_66605);

(statearr_66627_66639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66622 === (5))){
var _ = (function (){var statearr_66628 = state_66621;
(statearr_66628[(4)] = cljs.core.rest((state_66621[(4)])));

return statearr_66628;
})();
var state_66621__$1 = state_66621;
var ex66625 = (state_66621__$1[(2)]);
var statearr_66629_66640 = state_66621__$1;
(statearr_66629_66640[(5)] = ex66625);


var statearr_66630_66641 = state_66621__$1;
(statearr_66630_66641[(1)] = (4));

(statearr_66630_66641[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66622 === (6))){
var inst_66614 = (state_66621[(2)]);
var inst_66615 = cljs.core.clj__GT_js(inst_66614);
var inst_66616 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66615) : resolve.call(null,inst_66615));
var _ = (function (){var statearr_66631 = state_66621;
(statearr_66631[(4)] = cljs.core.rest((state_66621[(4)])));

return statearr_66631;
})();
var state_66621__$1 = state_66621;
var statearr_66632_66642 = state_66621__$1;
(statearr_66632_66642[(2)] = inst_66616);

(statearr_66632_66642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$query_$_state_machine__2727__auto__ = null;
var flureedb$query_$_state_machine__2727__auto____0 = (function (){
var statearr_66633 = [null,null,null,null,null,null,null,null];
(statearr_66633[(0)] = flureedb$query_$_state_machine__2727__auto__);

(statearr_66633[(1)] = (1));

return statearr_66633;
});
var flureedb$query_$_state_machine__2727__auto____1 = (function (state_66621){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66621);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66634){var ex__2730__auto__ = e66634;
var statearr_66635_66643 = state_66621;
(statearr_66635_66643[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66621[(4)]))){
var statearr_66636_66644 = state_66621;
(statearr_66636_66644[(1)] = cljs.core.first((state_66621[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66645 = state_66621;
state_66621 = G__66645;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$query_$_state_machine__2727__auto__ = function(state_66621){
switch(arguments.length){
case 0:
return flureedb$query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$query_$_state_machine__2727__auto____1.call(this,state_66621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$query_$_state_machine__2727__auto____0;
flureedb$query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$query_$_state_machine__2727__auto____1;
return flureedb$query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66637 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66637[(6)] = c__2749__auto__);

return statearr_66637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.query', flureedb.query);
/**
 * Execute a query against a ledger, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise containing results.
 */
flureedb.signed_query = (function flureedb$signed_query(var_args){
var G__66647 = arguments.length;
switch (G__66647) {
case 3:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.signed_query', flureedb.signed_query);

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66674){
var state_val_66675 = (state_66674[(1)]);
if((state_val_66675 === (7))){
var inst_66661 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66674__$1 = state_66674;
var statearr_66676_66697 = state_66674__$1;
(statearr_66676_66697[(2)] = inst_66661);

(statearr_66676_66697[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66675 === (1))){
var state_66674__$1 = state_66674;
var statearr_66677_66698 = state_66674__$1;
(statearr_66677_66698[(2)] = null);

(statearr_66677_66698[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66675 === (4))){
var inst_66648 = (state_66674[(2)]);
var inst_66649 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66648], 0));
var inst_66650 = cljs.core.clj__GT_js(inst_66648);
var inst_66651 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66650) : reject.call(null,inst_66650));
var state_66674__$1 = (function (){var statearr_66678 = state_66674;
(statearr_66678[(7)] = inst_66649);

return statearr_66678;
})();
var statearr_66679_66699 = state_66674__$1;
(statearr_66679_66699[(2)] = inst_66651);

(statearr_66679_66699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66675 === (6))){
var state_66674__$1 = state_66674;
var statearr_66680_66700 = state_66674__$1;
(statearr_66680_66700[(2)] = null);

(statearr_66680_66700[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66675 === (3))){
var inst_66672 = (state_66674[(2)]);
var state_66674__$1 = state_66674;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66674__$1,inst_66672);
} else {
if((state_val_66675 === (2))){
var _ = (function (){var statearr_66682 = state_66674;
(statearr_66682[(4)] = cljs.core.cons((5),(state_66674[(4)])));

return statearr_66682;
})();
var inst_66657 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66658 = (opts == null);
var state_66674__$1 = (function (){var statearr_66683 = state_66674;
(statearr_66683[(8)] = inst_66657);

return statearr_66683;
})();
if(cljs.core.truth_(inst_66658)){
var statearr_66684_66701 = state_66674__$1;
(statearr_66684_66701[(1)] = (6));

} else {
var statearr_66685_66702 = state_66674__$1;
(statearr_66685_66702[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66675 === (9))){
var inst_66666 = (state_66674[(2)]);
var inst_66667 = fluree.db.util.async.throw_err(inst_66666);
var inst_66668 = cljs.core.clj__GT_js(inst_66667);
var inst_66669 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66668) : resolve.call(null,inst_66668));
var _ = (function (){var statearr_66686 = state_66674;
(statearr_66686[(4)] = cljs.core.rest((state_66674[(4)])));

return statearr_66686;
})();
var state_66674__$1 = state_66674;
var statearr_66687_66703 = state_66674__$1;
(statearr_66687_66703[(2)] = inst_66669);

(statearr_66687_66703[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66675 === (5))){
var _ = (function (){var statearr_66688 = state_66674;
(statearr_66688[(4)] = cljs.core.rest((state_66674[(4)])));

return statearr_66688;
})();
var state_66674__$1 = state_66674;
var ex66681 = (state_66674__$1[(2)]);
var statearr_66689_66704 = state_66674__$1;
(statearr_66689_66704[(5)] = ex66681);


var statearr_66690_66705 = state_66674__$1;
(statearr_66690_66705[(1)] = (4));

(statearr_66690_66705[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66675 === (8))){
var inst_66657 = (state_66674[(8)]);
var inst_66663 = (state_66674[(2)]);
var inst_66664 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_66657,inst_66663);
var state_66674__$1 = state_66674;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66674__$1,(9),inst_66664);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_66691 = [null,null,null,null,null,null,null,null,null];
(statearr_66691[(0)] = flureedb$state_machine__2727__auto__);

(statearr_66691[(1)] = (1));

return statearr_66691;
});
var flureedb$state_machine__2727__auto____1 = (function (state_66674){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66674);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66692){var ex__2730__auto__ = e66692;
var statearr_66693_66706 = state_66674;
(statearr_66693_66706[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66674[(4)]))){
var statearr_66694_66707 = state_66674;
(statearr_66694_66707[(1)] = cljs.core.first((state_66674[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66708 = state_66674;
state_66674 = G__66708;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_66674){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_66674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66695 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66695[(6)] = c__2749__auto__);

return statearr_66695;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *    any key, and a two-argument function that will be called with each event.
 * 
 *    The key is any arbitrary key, and is only used to close the listener via close-listener,
 *    otherwise it is opaque to the listener.
 * 
 *    The callback function's first argument is the event header/metadata and the second argument
 *    is the event data itself.
 */
flureedb.listen = (function flureedb$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen(conn,ledger,key,callback);
});
goog.exportSymbol('flureedb.listen', flureedb.listen);
/**
 * Closes a listener.
 */
flureedb.close_listener = (function flureedb$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener(conn,ledger,key);
});
goog.exportSymbol('flureedb.close_listener', flureedb.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureedb.listeners = (function flureedb$listeners(conn){
return fluree.db.connection_js.listeners(conn);
});
goog.exportSymbol('flureedb.listeners', flureedb.listeners);
/**
 * Takes an http request and creates an http signature using a private key
 */
flureedb.http_signature = (function flureedb$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureedb.http_signature', flureedb.http_signature);
