// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.crypto.aes');
goog.require('cljs.core');
goog.require('alphabase.core');
goog.require('fluree.crypto.util');
goog.require('goog.crypt.Aes');
goog.require('goog.crypt.Cbc');
goog.require('fluree.crypto.pkcs7');
fluree.crypto.aes.encrypt_STAR_ = (function fluree$crypto$aes$encrypt_STAR_(iv,key_ba,ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
var padded = fluree.crypto.pkcs7.encode.call(null,(16),ba);
return cbc.encrypt(padded,cljs.core.clj__GT_js.call(null,iv));
});
/**
 * Encrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out
 *   of key (requires Unlimited Strength crypto to be enabled).
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.encrypt = (function fluree$crypto$aes$encrypt(var_args){
var args__4870__auto__ = [];
var len__4864__auto___61182 = arguments.length;
var i__4865__auto___61183 = (0);
while(true){
if((i__4865__auto___61183 < len__4864__auto___61182)){
args__4870__auto__.push((arguments[i__4865__auto___61183]));

var G__61184 = (i__4865__auto___61183 + (1));
i__4865__auto___61183 = G__61184;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});
goog.exportSymbol('fluree.crypto.aes.encrypt', fluree.crypto.aes.encrypt);

(fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__61176){
var vec__61177 = p__61176;
var map__61180 = cljs.core.nth.call(null,vec__61177,(0),null);
var map__61180__$1 = cljs.core.__destructure_map.call(null,map__61180);
var iv = cljs.core.get.call(null,map__61180__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var output_format = cljs.core.get.call(null,map__61180__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"hex","hex",41691346));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key.call(null,key,(32)):key);
var ba = ((typeof x === 'string')?alphabase.core.string__GT_bytes.call(null,x):x);
var encrypted = fluree.crypto.aes.encrypt_STAR_.call(null,iv,key_ba,ba);
var G__61181 = cljs.core.keyword.call(null,output_format);
var G__61181__$1 = (((G__61181 instanceof cljs.core.Keyword))?G__61181.fqn:null);
switch (G__61181__$1) {
case "none":
return encrypted;

break;
case "hex":
return alphabase.core.bytes__GT_hex.call(null,encrypted);

break;
case "base64":
return alphabase.core.bytes__GT_base64.call(null,encrypted);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__61181__$1)].join('')));

}
}));

(fluree.crypto.aes.encrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.encrypt.cljs$lang$applyTo = (function (seq61173){
var G__61174 = cljs.core.first.call(null,seq61173);
var seq61173__$1 = cljs.core.next.call(null,seq61173);
var G__61175 = cljs.core.first.call(null,seq61173__$1);
var seq61173__$2 = cljs.core.next.call(null,seq61173__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__61174,G__61175,seq61173__$2);
}));

fluree.crypto.aes.decrypt_STAR_ = (function fluree$crypto$aes$decrypt_STAR_(iv,key_ba,x_ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
return fluree.crypto.pkcs7.decode.call(null,(16),cbc.decrypt(x_ba,cljs.core.clj__GT_js.call(null,iv)));
});
/**
 * Decrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out of key.
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.decrypt = (function fluree$crypto$aes$decrypt(var_args){
var args__4870__auto__ = [];
var len__4864__auto___61197 = arguments.length;
var i__4865__auto___61198 = (0);
while(true){
if((i__4865__auto___61198 < len__4864__auto___61197)){
args__4870__auto__.push((arguments[i__4865__auto___61198]));

var G__61199 = (i__4865__auto___61198 + (1));
i__4865__auto___61198 = G__61199;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});
goog.exportSymbol('fluree.crypto.aes.decrypt', fluree.crypto.aes.decrypt);

(fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__61190){
var vec__61191 = p__61190;
var map__61194 = cljs.core.nth.call(null,vec__61191,(0),null);
var map__61194__$1 = cljs.core.__destructure_map.call(null,map__61194);
var iv = cljs.core.get.call(null,map__61194__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var input_format = cljs.core.get.call(null,map__61194__$1,new cljs.core.Keyword(null,"input-format","input-format",-422703481),new cljs.core.Keyword(null,"hex","hex",41691346));
var output_format = cljs.core.get.call(null,map__61194__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"string","string",-1989541586));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key.call(null,key,(32)):key);
var x_ba = ((typeof x === 'string')?(function (){var G__61195 = cljs.core.keyword.call(null,input_format);
var G__61195__$1 = (((G__61195 instanceof cljs.core.Keyword))?G__61195.fqn:null);
switch (G__61195__$1) {
case "hex":
return alphabase.core.hex__GT_bytes.call(null,x);

break;
case "base64":
return alphabase.core.base64__GT_bytes.call(null,x);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__61195__$1)].join('')));

}
})():x);
var decrypt_ba = fluree.crypto.aes.decrypt_STAR_.call(null,iv,key_ba,x_ba);
var G__61196 = cljs.core.keyword.call(null,output_format);
var G__61196__$1 = (((G__61196 instanceof cljs.core.Keyword))?G__61196.fqn:null);
switch (G__61196__$1) {
case "none":
return decrypt_ba;

break;
case "hex":
return alphabase.core.bytes__GT_hex.call(null,decrypt_ba);

break;
case "string":
return alphabase.core.bytes__GT_string.call(null,decrypt_ba);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__61196__$1)].join('')));

}
}));

(fluree.crypto.aes.decrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.decrypt.cljs$lang$applyTo = (function (seq61187){
var G__61188 = cljs.core.first.call(null,seq61187);
var seq61187__$1 = cljs.core.next.call(null,seq61187);
var G__61189 = cljs.core.first.call(null,seq61187__$1);
var seq61187__$2 = cljs.core.next.call(null,seq61187__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__61188,G__61189,seq61187__$2);
}));

