// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__67712 = arguments.length;
switch (G__67712) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5751__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5751__auto__)){
var block = temp__5751__auto__;
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___67751 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67733){
var state_val_67734 = (state_67733[(1)]);
if((state_val_67734 === (1))){
var state_67733__$1 = state_67733;
var statearr_67735_67752 = state_67733__$1;
(statearr_67735_67752[(2)] = null);

(statearr_67735_67752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67734 === (2))){
var _ = (function (){var statearr_67736 = state_67733;
(statearr_67736[(4)] = cljs.core.cons.call(null,(5),(state_67733[(4)])));

return statearr_67736;
})();
var inst_67719 = fluree.db.session.db.call(null,conn,ledger,null);
var state_67733__$1 = state_67733;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67733__$1,(7),inst_67719);
} else {
if((state_val_67734 === (3))){
var inst_67729 = (state_67733[(2)]);
var inst_67730 = cljs.core.async.put_BANG_.call(null,pc,inst_67729);
var inst_67731 = cljs.core.async.close_BANG_.call(null,pc);
var state_67733__$1 = (function (){var statearr_67738 = state_67733;
(statearr_67738[(7)] = inst_67730);

return statearr_67738;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67733__$1,inst_67731);
} else {
if((state_val_67734 === (4))){
var inst_67713 = (state_67733[(2)]);
var state_67733__$1 = state_67733;
var statearr_67739_67753 = state_67733__$1;
(statearr_67739_67753[(2)] = inst_67713);

(statearr_67739_67753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67734 === (5))){
var _ = (function (){var statearr_67740 = state_67733;
(statearr_67740[(4)] = cljs.core.rest.call(null,(state_67733[(4)])));

return statearr_67740;
})();
var state_67733__$1 = state_67733;
var ex67737 = (state_67733__$1[(2)]);
var statearr_67741_67754 = state_67733__$1;
(statearr_67741_67754[(5)] = ex67737);


var statearr_67742_67755 = state_67733__$1;
(statearr_67742_67755[(1)] = (4));

(statearr_67742_67755[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67734 === (6))){
var inst_67725 = (state_67733[(2)]);
var inst_67726 = fluree.db.util.async.throw_err.call(null,inst_67725);
var _ = (function (){var statearr_67743 = state_67733;
(statearr_67743[(4)] = cljs.core.rest.call(null,(state_67733[(4)])));

return statearr_67743;
})();
var state_67733__$1 = state_67733;
var statearr_67744_67756 = state_67733__$1;
(statearr_67744_67756[(2)] = inst_67726);

(statearr_67744_67756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67734 === (7))){
var inst_67721 = (state_67733[(2)]);
var inst_67722 = fluree.db.util.async.throw_err.call(null,inst_67721);
var inst_67723 = fluree.db.time_travel.as_of_block.call(null,inst_67722,block);
var state_67733__$1 = state_67733;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67733__$1,(6),inst_67723);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2746__auto__ = null;
var fluree$db$api$ledger$state_machine__2746__auto____0 = (function (){
var statearr_67745 = [null,null,null,null,null,null,null,null];
(statearr_67745[(0)] = fluree$db$api$ledger$state_machine__2746__auto__);

(statearr_67745[(1)] = (1));

return statearr_67745;
});
var fluree$db$api$ledger$state_machine__2746__auto____1 = (function (state_67733){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67733);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67746){var ex__2749__auto__ = e67746;
var statearr_67747_67757 = state_67733;
(statearr_67747_67757[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67733[(4)]))){
var statearr_67748_67758 = state_67733;
(statearr_67748_67758[(1)] = cljs.core.first.call(null,(state_67733[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67759 = state_67733;
state_67733 = G__67759;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2746__auto__ = function(state_67733){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2746__auto____1.call(this,state_67733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2746__auto____0;
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2746__auto____1;
return fluree$db$api$ledger$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67749 = f__2769__auto__.call(null);
(statearr_67749[(6)] = c__2768__auto___67751);

return statearr_67749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
} else {
return fluree.db.session.db.call(null,conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t.call(null,db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67800){
var state_val_67801 = (state_67800[(1)]);
if((state_val_67801 === (7))){
var inst_67769 = cljs.core._EQ_.call(null,(0),auth);
var state_67800__$1 = state_67800;
if(inst_67769){
var statearr_67802_67833 = state_67800__$1;
(statearr_67802_67833[(1)] = (9));

} else {
var statearr_67803_67834 = state_67800__$1;
(statearr_67803_67834[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67801 === (1))){
var state_67800__$1 = state_67800;
var statearr_67804_67835 = state_67800__$1;
(statearr_67804_67835[(2)] = null);

(statearr_67804_67835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67801 === (4))){
var inst_67760 = (state_67800[(2)]);
var state_67800__$1 = state_67800;
var statearr_67805_67836 = state_67800__$1;
(statearr_67805_67836[(2)] = inst_67760);

(statearr_67805_67836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67801 === (15))){
var inst_67777 = (state_67800[(7)]);
var inst_67776 = (state_67800[(2)]);
var inst_67777__$1 = fluree.db.util.async.throw_err.call(null,inst_67776);
var state_67800__$1 = (function (){var statearr_67806 = state_67800;
(statearr_67806[(7)] = inst_67777__$1);

return statearr_67806;
})();
if(cljs.core.truth_(inst_67777__$1)){
var statearr_67807_67837 = state_67800__$1;
(statearr_67807_67837[(1)] = (16));

} else {
var statearr_67808_67838 = state_67800__$1;
(statearr_67808_67838[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67801 === (13))){
var state_67800__$1 = state_67800;
var statearr_67809_67839 = state_67800__$1;
(statearr_67809_67839[(2)] = null);

(statearr_67809_67839[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67801 === (6))){
var state_67800__$1 = state_67800;
var statearr_67810_67840 = state_67800__$1;
(statearr_67810_67840[(2)] = db);

(statearr_67810_67840[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67801 === (17))){
var inst_67781 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_67782 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67783 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_67784 = cljs.core.PersistentHashMap.fromArrays(inst_67782,inst_67783);
var inst_67785 = cljs.core.ex_info.call(null,inst_67781,inst_67784);
var inst_67786 = (function(){throw inst_67785})();
var state_67800__$1 = state_67800;
var statearr_67811_67841 = state_67800__$1;
(statearr_67811_67841[(2)] = inst_67786);

(statearr_67811_67841[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67801 === (3))){
var inst_67798 = (state_67800[(2)]);
var state_67800__$1 = state_67800;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67800__$1,inst_67798);
} else {
if((state_val_67801 === (12))){
var inst_67774 = fluree.db.dbproto._subid.call(null,db,auth);
var state_67800__$1 = state_67800;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67800__$1,(15),inst_67774);
} else {
if((state_val_67801 === (2))){
var _ = (function (){var statearr_67812 = state_67800;
(statearr_67812[(4)] = cljs.core.cons.call(null,(5),(state_67800[(4)])));

return statearr_67812;
})();
var inst_67766 = cljs.core.not.call(null,auth);
var state_67800__$1 = state_67800;
if(inst_67766){
var statearr_67813_67842 = state_67800__$1;
(statearr_67813_67842[(1)] = (6));

} else {
var statearr_67814_67843 = state_67800__$1;
(statearr_67814_67843[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67801 === (11))){
var inst_67793 = (state_67800[(2)]);
var state_67800__$1 = state_67800;
var statearr_67816_67844 = state_67800__$1;
(statearr_67816_67844[(2)] = inst_67793);

(statearr_67816_67844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67801 === (9))){
var inst_67771 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_67800__$1 = state_67800;
var statearr_67817_67845 = state_67800__$1;
(statearr_67817_67845[(2)] = inst_67771);

(statearr_67817_67845[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67801 === (5))){
var _ = (function (){var statearr_67818 = state_67800;
(statearr_67818[(4)] = cljs.core.rest.call(null,(state_67800[(4)])));

return statearr_67818;
})();
var state_67800__$1 = state_67800;
var ex67815 = (state_67800__$1[(2)]);
var statearr_67819_67846 = state_67800__$1;
(statearr_67819_67846[(5)] = ex67815);


if((ex67815 instanceof Error)){
var statearr_67820_67847 = state_67800__$1;
(statearr_67820_67847[(1)] = (4));

(statearr_67820_67847[(5)] = null);

} else {
throw ex67815;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67801 === (14))){
var inst_67791 = (state_67800[(2)]);
var state_67800__$1 = state_67800;
var statearr_67821_67848 = state_67800__$1;
(statearr_67821_67848[(2)] = inst_67791);

(statearr_67821_67848[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67801 === (16))){
var inst_67777 = (state_67800[(7)]);
var inst_67779 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_67777);
var state_67800__$1 = state_67800;
var statearr_67822_67849 = state_67800__$1;
(statearr_67822_67849[(2)] = inst_67779);

(statearr_67822_67849[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67801 === (10))){
var state_67800__$1 = state_67800;
var statearr_67823_67850 = state_67800__$1;
(statearr_67823_67850[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67801 === (18))){
var inst_67788 = (state_67800[(2)]);
var state_67800__$1 = state_67800;
var statearr_67825_67851 = state_67800__$1;
(statearr_67825_67851[(2)] = inst_67788);

(statearr_67825_67851[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67801 === (8))){
var inst_67795 = (state_67800[(2)]);
var _ = (function (){var statearr_67826 = state_67800;
(statearr_67826[(4)] = cljs.core.rest.call(null,(state_67800[(4)])));

return statearr_67826;
})();
var state_67800__$1 = state_67800;
var statearr_67827_67852 = state_67800__$1;
(statearr_67827_67852[(2)] = inst_67795);

(statearr_67827_67852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0 = (function (){
var statearr_67828 = [null,null,null,null,null,null,null,null];
(statearr_67828[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__);

(statearr_67828[(1)] = (1));

return statearr_67828;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1 = (function (state_67800){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67800);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67829){var ex__2749__auto__ = e67829;
var statearr_67830_67853 = state_67800;
(statearr_67830_67853[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67800[(4)]))){
var statearr_67831_67854 = state_67800;
(statearr_67831_67854[(1)] = cljs.core.first.call(null,(state_67800[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67855 = state_67800;
state_67800 = G__67855;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__ = function(state_67800){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1.call(this,state_67800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67832 = f__2769__auto__.call(null);
(statearr_67832[(6)] = c__2768__auto__);

return statearr_67832;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67919){
var state_val_67920 = (state_67919[(1)]);
if((state_val_67920 === (7))){
var inst_67865 = cljs.core._EQ_.call(null,(0),auth);
var state_67919__$1 = state_67919;
if(inst_67865){
var statearr_67921_67970 = state_67919__$1;
(statearr_67921_67970[(1)] = (9));

} else {
var statearr_67922_67971 = state_67919__$1;
(statearr_67922_67971[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (20))){
var inst_67889 = (state_67919[(7)]);
var state_67919__$1 = state_67919;
if(cljs.core.truth_(inst_67889)){
var statearr_67923_67972 = state_67919__$1;
(statearr_67923_67972[(1)] = (22));

} else {
var statearr_67924_67973 = state_67919__$1;
(statearr_67924_67973[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (27))){
var state_67919__$1 = state_67919;
var statearr_67925_67974 = state_67919__$1;
(statearr_67925_67974[(2)] = null);

(statearr_67925_67974[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (1))){
var state_67919__$1 = state_67919;
var statearr_67926_67975 = state_67919__$1;
(statearr_67926_67975[(2)] = null);

(statearr_67926_67975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (24))){
var inst_67903 = (state_67919[(2)]);
var state_67919__$1 = state_67919;
var statearr_67927_67976 = state_67919__$1;
(statearr_67927_67976[(2)] = inst_67903);

(statearr_67927_67976[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (4))){
var inst_67856 = (state_67919[(2)]);
var state_67919__$1 = state_67919;
var statearr_67928_67977 = state_67919__$1;
(statearr_67928_67977[(2)] = inst_67856);

(statearr_67928_67977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (15))){
var inst_67872 = (state_67919[(8)]);
var inst_67871 = (state_67919[(2)]);
var inst_67872__$1 = fluree.db.util.async.throw_err.call(null,inst_67871);
var state_67919__$1 = (function (){var statearr_67929 = state_67919;
(statearr_67929[(8)] = inst_67872__$1);

return statearr_67929;
})();
if(cljs.core.truth_(inst_67872__$1)){
var statearr_67930_67978 = state_67919__$1;
(statearr_67930_67978[(1)] = (16));

} else {
var statearr_67931_67979 = state_67919__$1;
(statearr_67931_67979[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (21))){
var inst_67905 = (state_67919[(9)]);
var inst_67905__$1 = (state_67919[(2)]);
var state_67919__$1 = (function (){var statearr_67932 = state_67919;
(statearr_67932[(9)] = inst_67905__$1);

return statearr_67932;
})();
if(cljs.core.truth_(inst_67905__$1)){
var statearr_67933_67980 = state_67919__$1;
(statearr_67933_67980[(1)] = (29));

} else {
var statearr_67934_67981 = state_67919__$1;
(statearr_67934_67981[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (31))){
var inst_67889 = (state_67919[(7)]);
var inst_67905 = (state_67919[(9)]);
var inst_67913 = (state_67919[(2)]);
var inst_67914 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_67889,new cljs.core.Keyword(null,"roles","roles",143379530),inst_67905,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_67913);
var _ = (function (){var statearr_67935 = state_67919;
(statearr_67935[(4)] = cljs.core.rest.call(null,(state_67919[(4)])));

return statearr_67935;
})();
var state_67919__$1 = state_67919;
var statearr_67936_67982 = state_67919__$1;
(statearr_67936_67982[(2)] = inst_67914);

(statearr_67936_67982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (32))){
var inst_67909 = (state_67919[(2)]);
var inst_67910 = fluree.db.util.async.throw_err.call(null,inst_67909);
var state_67919__$1 = state_67919;
var statearr_67937_67983 = state_67919__$1;
(statearr_67937_67983[(2)] = inst_67910);

(statearr_67937_67983[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (13))){
var state_67919__$1 = state_67919;
var statearr_67938_67984 = state_67919__$1;
(statearr_67938_67984[(2)] = null);

(statearr_67938_67984[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (22))){
var inst_67889 = (state_67919[(7)]);
var inst_67893 = fluree.db.auth.roles.call(null,db,inst_67889);
var state_67919__$1 = state_67919;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67919__$1,(25),inst_67893);
} else {
if((state_val_67920 === (29))){
var inst_67905 = (state_67919[(9)]);
var inst_67907 = fluree.db.permissions.permission_map.call(null,db,inst_67905,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_67919__$1 = state_67919;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67919__$1,(32),inst_67907);
} else {
if((state_val_67920 === (6))){
var state_67919__$1 = state_67919;
var statearr_67939_67985 = state_67919__$1;
(statearr_67939_67985[(2)] = null);

(statearr_67939_67985[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (28))){
var inst_67901 = (state_67919[(2)]);
var state_67919__$1 = state_67919;
var statearr_67940_67986 = state_67919__$1;
(statearr_67940_67986[(2)] = inst_67901);

(statearr_67940_67986[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (25))){
var inst_67895 = (state_67919[(2)]);
var inst_67896 = fluree.db.util.async.throw_err.call(null,inst_67895);
var state_67919__$1 = state_67919;
var statearr_67941_67987 = state_67919__$1;
(statearr_67941_67987[(2)] = inst_67896);

(statearr_67941_67987[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (17))){
var inst_67875 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_67876 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67877 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_67878 = cljs.core.PersistentHashMap.fromArrays(inst_67876,inst_67877);
var inst_67879 = cljs.core.ex_info.call(null,inst_67875,inst_67878);
var inst_67880 = (function(){throw inst_67879})();
var state_67919__$1 = state_67919;
var statearr_67942_67988 = state_67919__$1;
(statearr_67942_67988[(2)] = inst_67880);

(statearr_67942_67988[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (3))){
var inst_67917 = (state_67919[(2)]);
var state_67919__$1 = state_67919;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67919__$1,inst_67917);
} else {
if((state_val_67920 === (12))){
var inst_67869 = fluree.db.dbproto._subid.call(null,db,auth);
var state_67919__$1 = state_67919;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67919__$1,(15),inst_67869);
} else {
if((state_val_67920 === (2))){
var _ = (function (){var statearr_67943 = state_67919;
(statearr_67943[(4)] = cljs.core.cons.call(null,(5),(state_67919[(4)])));

return statearr_67943;
})();
var inst_67862 = (auth == null);
var state_67919__$1 = state_67919;
if(cljs.core.truth_(inst_67862)){
var statearr_67944_67989 = state_67919__$1;
(statearr_67944_67989[(1)] = (6));

} else {
var statearr_67945_67990 = state_67919__$1;
(statearr_67945_67990[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (23))){
var state_67919__$1 = state_67919;
var statearr_67946_67991 = state_67919__$1;
(statearr_67946_67991[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (19))){
var state_67919__$1 = state_67919;
var statearr_67948_67992 = state_67919__$1;
(statearr_67948_67992[(2)] = roles);

(statearr_67948_67992[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (11))){
var inst_67887 = (state_67919[(2)]);
var state_67919__$1 = state_67919;
var statearr_67950_67993 = state_67919__$1;
(statearr_67950_67993[(2)] = inst_67887);

(statearr_67950_67993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (9))){
var state_67919__$1 = state_67919;
var statearr_67951_67994 = state_67919__$1;
(statearr_67951_67994[(2)] = (0));

(statearr_67951_67994[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (5))){
var _ = (function (){var statearr_67952 = state_67919;
(statearr_67952[(4)] = cljs.core.rest.call(null,(state_67919[(4)])));

return statearr_67952;
})();
var state_67919__$1 = state_67919;
var ex67949 = (state_67919__$1[(2)]);
var statearr_67953_67995 = state_67919__$1;
(statearr_67953_67995[(5)] = ex67949);


if((ex67949 instanceof Error)){
var statearr_67954_67996 = state_67919__$1;
(statearr_67954_67996[(1)] = (4));

(statearr_67954_67996[(5)] = null);

} else {
throw ex67949;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (14))){
var inst_67885 = (state_67919[(2)]);
var state_67919__$1 = state_67919;
var statearr_67955_67997 = state_67919__$1;
(statearr_67955_67997[(2)] = inst_67885);

(statearr_67955_67997[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (26))){
var state_67919__$1 = state_67919;
var statearr_67956_67998 = state_67919__$1;
(statearr_67956_67998[(2)] = null);

(statearr_67956_67998[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (16))){
var inst_67872 = (state_67919[(8)]);
var state_67919__$1 = state_67919;
var statearr_67957_67999 = state_67919__$1;
(statearr_67957_67999[(2)] = inst_67872);

(statearr_67957_67999[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (30))){
var state_67919__$1 = state_67919;
var statearr_67958_68000 = state_67919__$1;
(statearr_67958_68000[(2)] = null);

(statearr_67958_68000[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (10))){
var state_67919__$1 = state_67919;
if(cljs.core.truth_(auth)){
var statearr_67959_68001 = state_67919__$1;
(statearr_67959_68001[(1)] = (12));

} else {
var statearr_67960_68002 = state_67919__$1;
(statearr_67960_68002[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (18))){
var inst_67882 = (state_67919[(2)]);
var state_67919__$1 = state_67919;
var statearr_67961_68003 = state_67919__$1;
(statearr_67961_68003[(2)] = inst_67882);

(statearr_67961_68003[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67920 === (8))){
var inst_67889 = (state_67919[(2)]);
var state_67919__$1 = (function (){var statearr_67962 = state_67919;
(statearr_67962[(7)] = inst_67889);

return statearr_67962;
})();
if(cljs.core.truth_(roles)){
var statearr_67963_68004 = state_67919__$1;
(statearr_67963_68004[(1)] = (19));

} else {
var statearr_67964_68005 = state_67919__$1;
(statearr_67964_68005[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0 = (function (){
var statearr_67965 = [null,null,null,null,null,null,null,null,null,null];
(statearr_67965[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__);

(statearr_67965[(1)] = (1));

return statearr_67965;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1 = (function (state_67919){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67919);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67966){var ex__2749__auto__ = e67966;
var statearr_67967_68006 = state_67919;
(statearr_67967_68006[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67919[(4)]))){
var statearr_67968_68007 = state_67919;
(statearr_67968_68007[(1)] = cljs.core.first.call(null,(state_67919[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68008 = state_67919;
state_67919 = G__68008;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__ = function(state_67919){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1.call(this,state_67919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67969 = f__2769__auto__.call(null);
(statearr_67969[(6)] = c__2768__auto__);

return statearr_67969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__68009 = db;
var map__68009__$1 = cljs.core.__destructure_map.call(null,map__68009);
var conn = cljs.core.get.call(null,map__68009__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__68009__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__68009__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.call(null,"NEW EVENT:",cljs.core.pr_str.call(null,evt),cljs.core.pr_str.call(null,data));

if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_.call(null,new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68016){
var state_val_68017 = (state_68016[(1)]);
if((state_val_68017 === (1))){
var inst_68010 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_68011 = fluree.db.session.db.call(null,conn,inst_68010,null);
var state_68016__$1 = state_68016;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68016__$1,(2),inst_68011);
} else {
if((state_val_68017 === (2))){
var inst_68013 = (state_68016[(2)]);
var inst_68014 = cljs.core.async.put_BANG_.call(null,resp_port,inst_68013);
var state_68016__$1 = state_68016;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68016__$1,inst_68014);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0 = (function (){
var statearr_68018 = [null,null,null,null,null,null,null];
(statearr_68018[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__);

(statearr_68018[(1)] = (1));

return statearr_68018;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1 = (function (state_68016){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68016);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68019){var ex__2749__auto__ = e68019;
var statearr_68020_68047 = state_68016;
(statearr_68020_68047[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68016[(4)]))){
var statearr_68021_68048 = state_68016;
(statearr_68021_68048[(1)] = cljs.core.first.call(null,(state_68016[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68049 = state_68016;
state_68016 = G__68049;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = function(state_68016){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1.call(this,state_68016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68022 = f__2769__auto__.call(null);
(statearr_68022[(6)] = c__2768__auto__);

return statearr_68022;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener.call(null,conn,network,dbid,listen_id,event_fn);

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68035){
var state_val_68036 = (state_68035[(1)]);
if((state_val_68036 === (1))){
var inst_68023 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_68024 = fluree.db.session.db.call(null,conn,inst_68023,null);
var state_68035__$1 = state_68035;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68035__$1,(2),inst_68024);
} else {
if((state_val_68036 === (2))){
var inst_68026 = (state_68035[(7)]);
var inst_68026__$1 = (state_68035[(2)]);
var inst_68027 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_68026__$1);
var inst_68028 = newer_block_QMARK_.call(null,inst_68027);
var state_68035__$1 = (function (){var statearr_68037 = state_68035;
(statearr_68037[(7)] = inst_68026__$1);

return statearr_68037;
})();
if(inst_68028){
var statearr_68038_68050 = state_68035__$1;
(statearr_68038_68050[(1)] = (3));

} else {
var statearr_68039_68051 = state_68035__$1;
(statearr_68039_68051[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68036 === (3))){
var inst_68026 = (state_68035[(7)]);
var inst_68030 = cljs.core.async.put_BANG_.call(null,resp_port,inst_68026);
var state_68035__$1 = state_68035;
var statearr_68040_68052 = state_68035__$1;
(statearr_68040_68052[(2)] = inst_68030);

(statearr_68040_68052[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68036 === (4))){
var state_68035__$1 = state_68035;
var statearr_68041_68053 = state_68035__$1;
(statearr_68041_68053[(2)] = null);

(statearr_68041_68053[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68036 === (5))){
var inst_68033 = (state_68035[(2)]);
var state_68035__$1 = state_68035;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68035__$1,inst_68033);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0 = (function (){
var statearr_68042 = [null,null,null,null,null,null,null,null];
(statearr_68042[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__);

(statearr_68042[(1)] = (1));

return statearr_68042;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1 = (function (state_68035){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68035);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68043){var ex__2749__auto__ = e68043;
var statearr_68044_68054 = state_68035;
(statearr_68044_68054[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68035[(4)]))){
var statearr_68045_68055 = state_68035;
(statearr_68045_68055[(1)] = cljs.core.first.call(null,(state_68035[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68056 = state_68035;
state_68035 = G__68056;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = function(state_68035){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1.call(this,state_68035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68046 = f__2769__auto__.call(null);
(statearr_68046[(6)] = c__2768__auto__);

return statearr_68046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_.call(null,syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.call(null);
var map__68057 = db;
var map__68057__$1 = cljs.core.__destructure_map.call(null,map__68057);
var conn = cljs.core.get.call(null,map__68057__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__68057__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__68057__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid.call(null);
var timeout = ((cljs.core.pos_int_QMARK_.call(null,syncTimeout))?(function (){var x__4339__auto__ = syncTimeout;
var y__4340__auto__ = (120000);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})():(60000));
var res_port = cljs.core.async.chan.call(null);
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.call(null,pc,db);
} else {
fluree.db.api.ledger.syncTo_wait.call(null,db,syncTo,listen_id,res_port);

var c__2768__auto___68133 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68107){
var state_val_68108 = (state_68107[(1)]);
if((state_val_68108 === (7))){
var inst_68073 = (state_68107[(7)]);
var inst_68084 = cljs.core._EQ_.call(null,inst_68073,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_68107__$1 = state_68107;
if(inst_68084){
var statearr_68109_68134 = state_68107__$1;
(statearr_68109_68134[(1)] = (9));

} else {
var statearr_68110_68135 = state_68107__$1;
(statearr_68110_68135[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68108 === (1))){
var inst_68066 = (state_68107[(8)]);
var inst_68058 = (state_68107[(9)]);
var inst_68058__$1 = cljs.core.async.timeout.call(null,timeout);
var inst_68066__$1 = res_port;
var inst_68067 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68068 = [inst_68058__$1,inst_68066__$1];
var inst_68069 = (new cljs.core.PersistentVector(null,2,(5),inst_68067,inst_68068,null));
var state_68107__$1 = (function (){var statearr_68111 = state_68107;
(statearr_68111[(8)] = inst_68066__$1);

(statearr_68111[(9)] = inst_68058__$1);

return statearr_68111;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_68107__$1,(2),inst_68069);
} else {
if((state_val_68108 === (4))){
var inst_68066 = (state_68107[(8)]);
var inst_68073 = (state_68107[(7)]);
var inst_68077 = cljs.core._EQ_.call(null,inst_68073,inst_68066);
var state_68107__$1 = state_68107;
if(inst_68077){
var statearr_68112_68136 = state_68107__$1;
(statearr_68112_68136[(1)] = (6));

} else {
var statearr_68113_68137 = state_68107__$1;
(statearr_68113_68137[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68108 === (13))){
var inst_68092 = (state_68107[(10)]);
var inst_68103 = cljs.core.async.put_BANG_.call(null,pc,inst_68092);
var state_68107__$1 = state_68107;
var statearr_68114_68138 = state_68107__$1;
(statearr_68114_68138[(2)] = inst_68103);

(statearr_68114_68138[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68108 === (6))){
var inst_68071 = (state_68107[(11)]);
var inst_68082 = cljs.core.nth.call(null,inst_68071,(0),null);
var state_68107__$1 = state_68107;
var statearr_68115_68139 = state_68107__$1;
(statearr_68115_68139[(2)] = inst_68082);

(statearr_68115_68139[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68108 === (3))){
var state_68107__$1 = state_68107;
var statearr_68116_68140 = state_68107__$1;
(statearr_68116_68140[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_68116_68140[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68108 === (12))){
var inst_68096 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_68097 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68098 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_68099 = cljs.core.PersistentHashMap.fromArrays(inst_68097,inst_68098);
var inst_68100 = cljs.core.ex_info.call(null,inst_68096,inst_68099);
var inst_68101 = cljs.core.async.put_BANG_.call(null,pc,inst_68100);
var state_68107__$1 = state_68107;
var statearr_68117_68141 = state_68107__$1;
(statearr_68117_68141[(2)] = inst_68101);

(statearr_68117_68141[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68108 === (2))){
var inst_68071 = (state_68107[(11)]);
var inst_68058 = (state_68107[(9)]);
var inst_68073 = (state_68107[(7)]);
var inst_68071__$1 = (state_68107[(2)]);
var inst_68072 = cljs.core.nth.call(null,inst_68071__$1,(0),null);
var inst_68073__$1 = cljs.core.nth.call(null,inst_68071__$1,(1),null);
var inst_68074 = cljs.core._EQ_.call(null,inst_68073__$1,inst_68058);
var state_68107__$1 = (function (){var statearr_68118 = state_68107;
(statearr_68118[(11)] = inst_68071__$1);

(statearr_68118[(12)] = inst_68072);

(statearr_68118[(7)] = inst_68073__$1);

return statearr_68118;
})();
if(inst_68074){
var statearr_68119_68142 = state_68107__$1;
(statearr_68119_68142[(1)] = (3));

} else {
var statearr_68120_68143 = state_68107__$1;
(statearr_68120_68143[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68108 === (11))){
var inst_68088 = (state_68107[(2)]);
var state_68107__$1 = state_68107;
var statearr_68121_68144 = state_68107__$1;
(statearr_68121_68144[(2)] = inst_68088);

(statearr_68121_68144[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68108 === (9))){
var inst_68072 = (state_68107[(12)]);
var state_68107__$1 = state_68107;
var statearr_68122_68145 = state_68107__$1;
(statearr_68122_68145[(2)] = inst_68072);

(statearr_68122_68145[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68108 === (5))){
var inst_68092 = (state_68107[(10)]);
var inst_68092__$1 = (state_68107[(2)]);
var inst_68093 = fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);
var inst_68094 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_68092__$1);
var state_68107__$1 = (function (){var statearr_68123 = state_68107;
(statearr_68123[(13)] = inst_68093);

(statearr_68123[(10)] = inst_68092__$1);

return statearr_68123;
})();
if(inst_68094){
var statearr_68124_68146 = state_68107__$1;
(statearr_68124_68146[(1)] = (12));

} else {
var statearr_68125_68147 = state_68107__$1;
(statearr_68125_68147[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68108 === (14))){
var inst_68105 = (state_68107[(2)]);
var state_68107__$1 = state_68107;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68107__$1,inst_68105);
} else {
if((state_val_68108 === (10))){
var state_68107__$1 = state_68107;
var statearr_68126_68148 = state_68107__$1;
(statearr_68126_68148[(2)] = null);

(statearr_68126_68148[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68108 === (8))){
var inst_68090 = (state_68107[(2)]);
var state_68107__$1 = state_68107;
var statearr_68127_68149 = state_68107__$1;
(statearr_68127_68149[(2)] = inst_68090);

(statearr_68127_68149[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0 = (function (){
var statearr_68128 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68128[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__);

(statearr_68128[(1)] = (1));

return statearr_68128;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1 = (function (state_68107){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68107);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68129){var ex__2749__auto__ = e68129;
var statearr_68130_68150 = state_68107;
(statearr_68130_68150[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68107[(4)]))){
var statearr_68131_68151 = state_68107;
(statearr_68131_68151[(1)] = cljs.core.first.call(null,(state_68107[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68152 = state_68107;
state_68107 = G__68152;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__ = function(state_68107){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1.call(this,state_68107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68132 = f__2769__auto__.call(null);
(statearr_68132[(6)] = c__2768__auto___68133);

return statearr_68132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__68154 = arguments.length;
switch (G__68154) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__68155){
var map__68156 = p__68155;
var map__68156__$1 = cljs.core.__destructure_map.call(null,map__68156);
var opts = map__68156__$1;
var roles = cljs.core.get.call(null,map__68156__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.call(null,map__68156__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.call(null,map__68156__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.call(null,map__68156__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.call(null,map__68156__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.call(null);
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2768__auto___68245 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68207){
var state_val_68208 = (state_68207[(1)]);
if((state_val_68208 === (7))){
var inst_68169 = (state_68207[(7)]);
var inst_68171 = fluree.db.api.ledger.syncTo_db.call(null,inst_68169,syncTo,syncTimeout);
var state_68207__$1 = state_68207;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68207__$1,(10),inst_68171);
} else {
if((state_val_68208 === (20))){
var inst_68193 = (state_68207[(8)]);
var state_68207__$1 = state_68207;
var statearr_68209_68246 = state_68207__$1;
(statearr_68209_68246[(2)] = inst_68193);

(statearr_68209_68246[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68208 === (1))){
var state_68207__$1 = state_68207;
var statearr_68210_68247 = state_68207__$1;
(statearr_68210_68247[(2)] = null);

(statearr_68210_68247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68208 === (4))){
var inst_68157 = (state_68207[(2)]);
var inst_68158 = cljs.core.async.put_BANG_.call(null,pc,inst_68157);
var inst_68159 = cljs.core.async.close_BANG_.call(null,pc);
var state_68207__$1 = (function (){var statearr_68211 = state_68207;
(statearr_68211[(9)] = inst_68158);

return statearr_68211;
})();
var statearr_68212_68248 = state_68207__$1;
(statearr_68212_68248[(2)] = inst_68159);

(statearr_68212_68248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68208 === (15))){
var inst_68185 = (state_68207[(10)]);
var inst_68187 = fluree.db.api.ledger.add_db_permissions.call(null,inst_68185,auth,roles);
var state_68207__$1 = state_68207;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68207__$1,(18),inst_68187);
} else {
if((state_val_68208 === (21))){
var inst_68201 = (state_68207[(2)]);
var inst_68202 = cljs.core.async.put_BANG_.call(null,pc,inst_68201);
var _ = (function (){var statearr_68213 = state_68207;
(statearr_68213[(4)] = cljs.core.rest.call(null,(state_68207[(4)])));

return statearr_68213;
})();
var state_68207__$1 = state_68207;
var statearr_68214_68249 = state_68207__$1;
(statearr_68214_68249[(2)] = inst_68202);

(statearr_68214_68249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68208 === (13))){
var inst_68185 = (state_68207[(2)]);
var state_68207__$1 = (function (){var statearr_68215 = state_68207;
(statearr_68215[(10)] = inst_68185);

return statearr_68215;
})();
if(cljs.core.truth_(roles)){
var statearr_68216_68250 = state_68207__$1;
(statearr_68216_68250[(1)] = (15));

} else {
var statearr_68217_68251 = state_68207__$1;
(statearr_68217_68251[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68208 === (22))){
var inst_68197 = (state_68207[(2)]);
var inst_68198 = fluree.db.util.async.throw_err.call(null,inst_68197);
var state_68207__$1 = state_68207;
var statearr_68218_68252 = state_68207__$1;
(statearr_68218_68252[(2)] = inst_68198);

(statearr_68218_68252[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68208 === (6))){
var inst_68168 = (state_68207[(2)]);
var inst_68169 = fluree.db.util.async.throw_err.call(null,inst_68168);
var state_68207__$1 = (function (){var statearr_68219 = state_68207;
(statearr_68219[(7)] = inst_68169);

return statearr_68219;
})();
if(cljs.core.truth_(syncTo)){
var statearr_68220_68253 = state_68207__$1;
(statearr_68220_68253[(1)] = (7));

} else {
var statearr_68221_68254 = state_68207__$1;
(statearr_68221_68254[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68208 === (17))){
var inst_68193 = (state_68207[(2)]);
var state_68207__$1 = (function (){var statearr_68222 = state_68207;
(statearr_68222[(8)] = inst_68193);

return statearr_68222;
})();
if(cljs.core.truth_(auth)){
var statearr_68223_68255 = state_68207__$1;
(statearr_68223_68255[(1)] = (19));

} else {
var statearr_68224_68256 = state_68207__$1;
(statearr_68224_68256[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68208 === (3))){
var inst_68205 = (state_68207[(2)]);
var state_68207__$1 = state_68207;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68207__$1,inst_68205);
} else {
if((state_val_68208 === (12))){
var inst_68177 = (state_68207[(11)]);
var state_68207__$1 = state_68207;
var statearr_68225_68257 = state_68207__$1;
(statearr_68225_68257[(2)] = inst_68177);

(statearr_68225_68257[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68208 === (2))){
var _ = (function (){var statearr_68226 = state_68207;
(statearr_68226[(4)] = cljs.core.cons.call(null,(5),(state_68207[(4)])));

return statearr_68226;
})();
var inst_68166 = fluree.db.session.db.call(null,conn,ledger,opts_SINGLEQUOTE_);
var state_68207__$1 = state_68207;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68207__$1,(6),inst_68166);
} else {
if((state_val_68208 === (19))){
var inst_68193 = (state_68207[(8)]);
var inst_68195 = fluree.db.api.ledger.add_db_permissions.call(null,inst_68193,auth,roles);
var state_68207__$1 = state_68207;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68207__$1,(22),inst_68195);
} else {
if((state_val_68208 === (11))){
var inst_68177 = (state_68207[(11)]);
var inst_68179 = fluree.db.time_travel.as_of_block.call(null,inst_68177,block);
var state_68207__$1 = state_68207;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68207__$1,(14),inst_68179);
} else {
if((state_val_68208 === (9))){
var inst_68177 = (state_68207[(2)]);
var state_68207__$1 = (function (){var statearr_68228 = state_68207;
(statearr_68228[(11)] = inst_68177);

return statearr_68228;
})();
if(cljs.core.truth_(block)){
var statearr_68229_68258 = state_68207__$1;
(statearr_68229_68258[(1)] = (11));

} else {
var statearr_68230_68259 = state_68207__$1;
(statearr_68230_68259[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68208 === (5))){
var _ = (function (){var statearr_68231 = state_68207;
(statearr_68231[(4)] = cljs.core.rest.call(null,(state_68207[(4)])));

return statearr_68231;
})();
var state_68207__$1 = state_68207;
var ex68227 = (state_68207__$1[(2)]);
var statearr_68232_68260 = state_68207__$1;
(statearr_68232_68260[(5)] = ex68227);


var statearr_68233_68261 = state_68207__$1;
(statearr_68233_68261[(1)] = (4));

(statearr_68233_68261[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68208 === (14))){
var inst_68181 = (state_68207[(2)]);
var inst_68182 = fluree.db.util.async.throw_err.call(null,inst_68181);
var state_68207__$1 = state_68207;
var statearr_68234_68262 = state_68207__$1;
(statearr_68234_68262[(2)] = inst_68182);

(statearr_68234_68262[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68208 === (16))){
var inst_68185 = (state_68207[(10)]);
var state_68207__$1 = state_68207;
var statearr_68235_68263 = state_68207__$1;
(statearr_68235_68263[(2)] = inst_68185);

(statearr_68235_68263[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68208 === (10))){
var inst_68173 = (state_68207[(2)]);
var inst_68174 = fluree.db.util.async.throw_err.call(null,inst_68173);
var state_68207__$1 = state_68207;
var statearr_68236_68264 = state_68207__$1;
(statearr_68236_68264[(2)] = inst_68174);

(statearr_68236_68264[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68208 === (18))){
var inst_68189 = (state_68207[(2)]);
var inst_68190 = fluree.db.util.async.throw_err.call(null,inst_68189);
var state_68207__$1 = state_68207;
var statearr_68237_68265 = state_68207__$1;
(statearr_68237_68265[(2)] = inst_68190);

(statearr_68237_68265[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68208 === (8))){
var inst_68169 = (state_68207[(7)]);
var state_68207__$1 = state_68207;
var statearr_68238_68266 = state_68207__$1;
(statearr_68238_68266[(2)] = inst_68169);

(statearr_68238_68266[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2746__auto__ = null;
var fluree$db$api$ledger$state_machine__2746__auto____0 = (function (){
var statearr_68239 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68239[(0)] = fluree$db$api$ledger$state_machine__2746__auto__);

(statearr_68239[(1)] = (1));

return statearr_68239;
});
var fluree$db$api$ledger$state_machine__2746__auto____1 = (function (state_68207){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68207);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68240){var ex__2749__auto__ = e68240;
var statearr_68241_68267 = state_68207;
(statearr_68241_68267[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68207[(4)]))){
var statearr_68242_68268 = state_68207;
(statearr_68242_68268[(1)] = cljs.core.first.call(null,(state_68207[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68269 = state_68207;
state_68207 = G__68269;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2746__auto__ = function(state_68207){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2746__auto____1.call(this,state_68207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2746__auto____0;
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2746__auto____1;
return fluree$db$api$ledger$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68243 = f__2769__auto__.call(null);
(statearr_68243[(6)] = c__2768__auto___68245);

return statearr_68243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

