// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__59067 = arguments.length;
switch (G__59067) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___59215 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_59154){
var state_val_59155 = (state_59154[(1)]);
if((state_val_59155 === (7))){
var inst_59085 = (state_59154[(7)]);
var inst_59088 = cljs.core.not_EQ_.call(null,(0),inst_59085);
var state_59154__$1 = state_59154;
var statearr_59156_59216 = state_59154__$1;
(statearr_59156_59216[(2)] = inst_59088);

(statearr_59156_59216[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (20))){
var inst_59080 = (state_59154[(8)]);
var inst_59109 = (state_59154[(9)]);
var inst_59113 = fluree.db.auth.roles.call(null,inst_59080,inst_59109);
var state_59154__$1 = state_59154;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59154__$1,(23),inst_59113);
} else {
if((state_val_59155 === (27))){
var inst_59080 = (state_59154[(8)]);
var inst_59128 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_59129 = fluree.db.time_travel.as_of_block.call(null,inst_59080,inst_59128);
var state_59154__$1 = state_59154;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59154__$1,(30),inst_59129);
} else {
if((state_val_59155 === (1))){
var state_59154__$1 = state_59154;
var statearr_59157_59217 = state_59154__$1;
(statearr_59157_59217[(2)] = null);

(statearr_59157_59217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (24))){
var inst_59080 = (state_59154[(8)]);
var inst_59121 = (state_59154[(10)]);
var inst_59123 = fluree.db.permissions.permission_map.call(null,inst_59080,inst_59121,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_59154__$1 = state_59154;
var statearr_59158_59218 = state_59154__$1;
(statearr_59158_59218[(2)] = inst_59123);

(statearr_59158_59218[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (4))){
var inst_59068 = (state_59154[(2)]);
var inst_59069 = cljs.core.async.put_BANG_.call(null,pc,inst_59068);
var inst_59070 = cljs.core.async.close_BANG_.call(null,pc);
var state_59154__$1 = (function (){var statearr_59159 = state_59154;
(statearr_59159[(11)] = inst_59069);

return statearr_59159;
})();
var statearr_59160_59219 = state_59154__$1;
(statearr_59160_59219[(2)] = inst_59070);

(statearr_59160_59219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (15))){
var inst_59085 = (state_59154[(7)]);
var inst_59099 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_59085)," unknown."].join('');
var inst_59100 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59101 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_59102 = cljs.core.PersistentHashMap.fromArrays(inst_59100,inst_59101);
var inst_59103 = cljs.core.ex_info.call(null,inst_59099,inst_59102);
var inst_59104 = (function(){throw inst_59103})();
var state_59154__$1 = state_59154;
var statearr_59161_59220 = state_59154__$1;
(statearr_59161_59220[(2)] = inst_59104);

(statearr_59161_59220[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (21))){
var state_59154__$1 = state_59154;
var statearr_59162_59221 = state_59154__$1;
(statearr_59162_59221[(2)] = null);

(statearr_59162_59221[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (31))){
var inst_59135 = (state_59154[(12)]);
var inst_59085 = (state_59154[(7)]);
var inst_59137 = cljs.core.assoc.call(null,inst_59135,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_59085);
var state_59154__$1 = state_59154;
var statearr_59163_59222 = state_59154__$1;
(statearr_59163_59222[(2)] = inst_59137);

(statearr_59163_59222[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (32))){
var inst_59135 = (state_59154[(12)]);
var state_59154__$1 = state_59154;
var statearr_59164_59223 = state_59154__$1;
(statearr_59164_59223[(2)] = inst_59135);

(statearr_59164_59223[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (33))){
var inst_59121 = (state_59154[(10)]);
var inst_59140 = (state_59154[(2)]);
var state_59154__$1 = (function (){var statearr_59165 = state_59154;
(statearr_59165[(13)] = inst_59140);

return statearr_59165;
})();
if(cljs.core.truth_(inst_59121)){
var statearr_59166_59224 = state_59154__$1;
(statearr_59166_59224[(1)] = (34));

} else {
var statearr_59167_59225 = state_59154__$1;
(statearr_59167_59225[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (13))){
var inst_59096 = (state_59154[(14)]);
var inst_59095 = (state_59154[(2)]);
var inst_59096__$1 = fluree.db.util.async.throw_err.call(null,inst_59095);
var state_59154__$1 = (function (){var statearr_59168 = state_59154;
(statearr_59168[(14)] = inst_59096__$1);

return statearr_59168;
})();
if(cljs.core.truth_(inst_59096__$1)){
var statearr_59169_59226 = state_59154__$1;
(statearr_59169_59226[(1)] = (14));

} else {
var statearr_59170_59227 = state_59154__$1;
(statearr_59170_59227[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (22))){
var inst_59119 = (state_59154[(2)]);
var state_59154__$1 = state_59154;
var statearr_59171_59228 = state_59154__$1;
(statearr_59171_59228[(2)] = inst_59119);

(statearr_59171_59228[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (36))){
var inst_59148 = (state_59154[(2)]);
var inst_59149 = cljs.core.async.put_BANG_.call(null,pc,inst_59148);
var _ = (function (){var statearr_59172 = state_59154;
(statearr_59172[(4)] = cljs.core.rest.call(null,(state_59154[(4)])));

return statearr_59172;
})();
var state_59154__$1 = state_59154;
var statearr_59173_59229 = state_59154__$1;
(statearr_59173_59229[(2)] = inst_59149);

(statearr_59173_59229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (29))){
var inst_59085 = (state_59154[(7)]);
var inst_59135 = (state_59154[(2)]);
var state_59154__$1 = (function (){var statearr_59174 = state_59154;
(statearr_59174[(12)] = inst_59135);

return statearr_59174;
})();
if(cljs.core.truth_(inst_59085)){
var statearr_59175_59230 = state_59154__$1;
(statearr_59175_59230[(1)] = (31));

} else {
var statearr_59176_59231 = state_59154__$1;
(statearr_59176_59231[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (6))){
var inst_59085 = (state_59154[(7)]);
var inst_59079 = (state_59154[(2)]);
var inst_59080 = fluree.db.util.async.throw_err.call(null,inst_59079);
var inst_59081 = opts;
var inst_59082 = cljs.core.__destructure_map.call(null,inst_59081);
var inst_59083 = cljs.core.get.call(null,inst_59082,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_59084 = cljs.core.get.call(null,inst_59082,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_59085__$1 = cljs.core.get.call(null,inst_59082,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_59086 = cljs.core.get.call(null,inst_59082,new cljs.core.Keyword(null,"block","block",664686210));
var state_59154__$1 = (function (){var statearr_59177 = state_59154;
(statearr_59177[(15)] = inst_59083);

(statearr_59177[(8)] = inst_59080);

(statearr_59177[(16)] = inst_59086);

(statearr_59177[(7)] = inst_59085__$1);

(statearr_59177[(17)] = inst_59084);

return statearr_59177;
})();
if(cljs.core.truth_(inst_59085__$1)){
var statearr_59178_59232 = state_59154__$1;
(statearr_59178_59232[(1)] = (7));

} else {
var statearr_59179_59233 = state_59154__$1;
(statearr_59179_59233[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (28))){
var inst_59080 = (state_59154[(8)]);
var state_59154__$1 = state_59154;
var statearr_59180_59234 = state_59154__$1;
(statearr_59180_59234[(2)] = inst_59080);

(statearr_59180_59234[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (25))){
var state_59154__$1 = state_59154;
var statearr_59181_59235 = state_59154__$1;
(statearr_59181_59235[(2)] = null);

(statearr_59181_59235[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (34))){
var inst_59126 = (state_59154[(18)]);
var state_59154__$1 = state_59154;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59154__$1,(37),inst_59126);
} else {
if((state_val_59155 === (17))){
var inst_59083 = (state_59154[(15)]);
var state_59154__$1 = state_59154;
var statearr_59182_59236 = state_59154__$1;
(statearr_59182_59236[(2)] = inst_59083);

(statearr_59182_59236[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (3))){
var inst_59152 = (state_59154[(2)]);
var state_59154__$1 = state_59154;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59154__$1,inst_59152);
} else {
if((state_val_59155 === (12))){
var inst_59083 = (state_59154[(15)]);
var inst_59109 = (state_59154[(2)]);
var state_59154__$1 = (function (){var statearr_59183 = state_59154;
(statearr_59183[(9)] = inst_59109);

return statearr_59183;
})();
if(cljs.core.truth_(inst_59083)){
var statearr_59184_59237 = state_59154__$1;
(statearr_59184_59237[(1)] = (17));

} else {
var statearr_59185_59238 = state_59154__$1;
(statearr_59185_59238[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (2))){
var _ = (function (){var statearr_59186 = state_59154;
(statearr_59186[(4)] = cljs.core.cons.call(null,(5),(state_59154[(4)])));

return statearr_59186;
})();
var inst_59077 = fluree.db.session.db.call(null,conn,ledger,null);
var state_59154__$1 = state_59154;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59154__$1,(6),inst_59077);
} else {
if((state_val_59155 === (23))){
var inst_59115 = (state_59154[(2)]);
var inst_59116 = fluree.db.util.async.throw_err.call(null,inst_59115);
var state_59154__$1 = state_59154;
var statearr_59187_59239 = state_59154__$1;
(statearr_59187_59239[(2)] = inst_59116);

(statearr_59187_59239[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (35))){
var inst_59140 = (state_59154[(13)]);
var state_59154__$1 = state_59154;
var statearr_59188_59240 = state_59154__$1;
(statearr_59188_59240[(2)] = inst_59140);

(statearr_59188_59240[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (19))){
var inst_59121 = (state_59154[(10)]);
var inst_59121__$1 = (state_59154[(2)]);
var state_59154__$1 = (function (){var statearr_59189 = state_59154;
(statearr_59189[(10)] = inst_59121__$1);

return statearr_59189;
})();
if(cljs.core.truth_(inst_59121__$1)){
var statearr_59190_59241 = state_59154__$1;
(statearr_59190_59241[(1)] = (24));

} else {
var statearr_59191_59242 = state_59154__$1;
(statearr_59191_59242[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (11))){
var state_59154__$1 = state_59154;
var statearr_59193_59243 = state_59154__$1;
(statearr_59193_59243[(2)] = null);

(statearr_59193_59243[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (9))){
var inst_59091 = (state_59154[(2)]);
var state_59154__$1 = state_59154;
if(cljs.core.truth_(inst_59091)){
var statearr_59194_59244 = state_59154__$1;
(statearr_59194_59244[(1)] = (10));

} else {
var statearr_59195_59245 = state_59154__$1;
(statearr_59195_59245[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (5))){
var _ = (function (){var statearr_59196 = state_59154;
(statearr_59196[(4)] = cljs.core.rest.call(null,(state_59154[(4)])));

return statearr_59196;
})();
var state_59154__$1 = state_59154;
var ex59192 = (state_59154__$1[(2)]);
var statearr_59197_59246 = state_59154__$1;
(statearr_59197_59246[(5)] = ex59192);


var statearr_59198_59247 = state_59154__$1;
(statearr_59198_59247[(1)] = (4));

(statearr_59198_59247[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (14))){
var inst_59096 = (state_59154[(14)]);
var state_59154__$1 = state_59154;
var statearr_59199_59248 = state_59154__$1;
(statearr_59199_59248[(2)] = inst_59096);

(statearr_59199_59248[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (26))){
var inst_59086 = (state_59154[(16)]);
var inst_59126 = (state_59154[(2)]);
var state_59154__$1 = (function (){var statearr_59200 = state_59154;
(statearr_59200[(18)] = inst_59126);

return statearr_59200;
})();
if(cljs.core.truth_(inst_59086)){
var statearr_59201_59249 = state_59154__$1;
(statearr_59201_59249[(1)] = (27));

} else {
var statearr_59202_59250 = state_59154__$1;
(statearr_59202_59250[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (16))){
var inst_59106 = (state_59154[(2)]);
var state_59154__$1 = state_59154;
var statearr_59203_59251 = state_59154__$1;
(statearr_59203_59251[(2)] = inst_59106);

(statearr_59203_59251[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (30))){
var inst_59131 = (state_59154[(2)]);
var inst_59132 = fluree.db.util.async.throw_err.call(null,inst_59131);
var state_59154__$1 = state_59154;
var statearr_59204_59252 = state_59154__$1;
(statearr_59204_59252[(2)] = inst_59132);

(statearr_59204_59252[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (10))){
var inst_59080 = (state_59154[(8)]);
var inst_59085 = (state_59154[(7)]);
var inst_59093 = fluree.db.dbproto._subid.call(null,inst_59080,inst_59085);
var state_59154__$1 = state_59154;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59154__$1,(13),inst_59093);
} else {
if((state_val_59155 === (18))){
var inst_59109 = (state_59154[(9)]);
var state_59154__$1 = state_59154;
if(cljs.core.truth_(inst_59109)){
var statearr_59205_59253 = state_59154__$1;
(statearr_59205_59253[(1)] = (20));

} else {
var statearr_59206_59254 = state_59154__$1;
(statearr_59206_59254[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (37))){
var inst_59140 = (state_59154[(13)]);
var inst_59143 = (state_59154[(2)]);
var inst_59144 = fluree.db.util.async.throw_err.call(null,inst_59143);
var inst_59145 = cljs.core.assoc.call(null,inst_59140,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_59144);
var state_59154__$1 = state_59154;
var statearr_59207_59255 = state_59154__$1;
(statearr_59207_59255[(2)] = inst_59145);

(statearr_59207_59255[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59155 === (8))){
var inst_59085 = (state_59154[(7)]);
var state_59154__$1 = state_59154;
var statearr_59208_59256 = state_59154__$1;
(statearr_59208_59256[(2)] = inst_59085);

(statearr_59208_59256[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2746__auto__ = null;
var fluree$db$api$query$state_machine__2746__auto____0 = (function (){
var statearr_59209 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59209[(0)] = fluree$db$api$query$state_machine__2746__auto__);

(statearr_59209[(1)] = (1));

return statearr_59209;
});
var fluree$db$api$query$state_machine__2746__auto____1 = (function (state_59154){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_59154);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e59210){var ex__2749__auto__ = e59210;
var statearr_59211_59257 = state_59154;
(statearr_59211_59257[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_59154[(4)]))){
var statearr_59212_59258 = state_59154;
(statearr_59212_59258[(1)] = cljs.core.first.call(null,(state_59154[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59259 = state_59154;
state_59154 = G__59259;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2746__auto__ = function(state_59154){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2746__auto____1.call(this,state_59154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2746__auto____0;
fluree$db$api$query$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2746__auto____1;
return fluree$db$api$query$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_59213 = f__2769__auto__.call(null);
(statearr_59213[(6)] = c__2768__auto___59215);

return statearr_59213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_59400){
var state_val_59401 = (state_59400[(1)]);
if((state_val_59401 === (7))){
var inst_59280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59281 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59282 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59283 = [inst_59281,inst_59282];
var inst_59284 = (new cljs.core.PersistentVector(null,2,(5),inst_59280,inst_59283,null));
var state_59400__$1 = state_59400;
var statearr_59402_59472 = state_59400__$1;
(statearr_59402_59472[(2)] = inst_59284);

(statearr_59402_59472[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (20))){
var inst_59310 = (state_59400[(7)]);
var state_59400__$1 = state_59400;
var statearr_59403_59473 = state_59400__$1;
(statearr_59403_59473[(2)] = inst_59310);

(statearr_59403_59473[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (27))){
var state_59400__$1 = state_59400;
var statearr_59404_59474 = state_59400__$1;
(statearr_59404_59474[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (1))){
var state_59400__$1 = state_59400;
var statearr_59406_59475 = state_59400__$1;
(statearr_59406_59475[(2)] = null);

(statearr_59406_59475[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (24))){
var inst_59309 = (state_59400[(8)]);
var state_59400__$1 = state_59400;
if(cljs.core.truth_(inst_59309)){
var statearr_59407_59476 = state_59400__$1;
(statearr_59407_59476[(1)] = (26));

} else {
var statearr_59408_59477 = state_59400__$1;
(statearr_59408_59477[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (39))){
var inst_59355 = (state_59400[(9)]);
var inst_59356 = (state_59400[(10)]);
var inst_59381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59382 = [inst_59355,inst_59356];
var inst_59383 = (new cljs.core.PersistentVector(null,2,(5),inst_59381,inst_59382,null));
var state_59400__$1 = state_59400;
var statearr_59409_59478 = state_59400__$1;
(statearr_59409_59478[(2)] = inst_59383);

(statearr_59409_59478[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (4))){
var inst_59260 = (state_59400[(2)]);
var state_59400__$1 = state_59400;
var statearr_59410_59479 = state_59400__$1;
(statearr_59410_59479[(2)] = inst_59260);

(statearr_59410_59479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (15))){
var inst_59294 = (state_59400[(11)]);
var inst_59289 = (state_59400[(12)]);
var inst_59303 = (state_59400[(2)]);
var inst_59304 = [inst_59294,inst_59303];
var inst_59305 = (new cljs.core.PersistentVector(null,2,(5),inst_59289,inst_59304,null));
var state_59400__$1 = state_59400;
var statearr_59411_59480 = state_59400__$1;
(statearr_59411_59480[(2)] = inst_59305);

(statearr_59411_59480[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (21))){
var inst_59309 = (state_59400[(8)]);
var state_59400__$1 = state_59400;
var statearr_59412_59481 = state_59400__$1;
(statearr_59412_59481[(2)] = inst_59309);

(statearr_59412_59481[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (31))){
var inst_59350 = (state_59400[(2)]);
var state_59400__$1 = state_59400;
var statearr_59413_59482 = state_59400__$1;
(statearr_59413_59482[(2)] = inst_59350);

(statearr_59413_59482[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (32))){
var inst_59356 = (state_59400[(10)]);
var inst_59359 = cljs.core.pos_int_QMARK_.call(null,inst_59356);
var state_59400__$1 = state_59400;
var statearr_59414_59483 = state_59400__$1;
(statearr_59414_59483[(2)] = inst_59359);

(statearr_59414_59483[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (40))){
var inst_59387 = (state_59400[(13)]);
var inst_59311 = (state_59400[(14)]);
var inst_59385 = (state_59400[(2)]);
var inst_59386 = cljs.core.nth.call(null,inst_59385,(0),null);
var inst_59387__$1 = cljs.core.nth.call(null,inst_59385,(1),null);
var inst_59388 = (inst_59387__$1 > inst_59311);
var state_59400__$1 = (function (){var statearr_59415 = state_59400;
(statearr_59415[(13)] = inst_59387__$1);

(statearr_59415[(15)] = inst_59386);

return statearr_59415;
})();
if(cljs.core.truth_(inst_59388)){
var statearr_59416_59484 = state_59400__$1;
(statearr_59416_59484[(1)] = (41));

} else {
var statearr_59417_59485 = state_59400__$1;
(statearr_59417_59485[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (33))){
var inst_59357 = (state_59400[(16)]);
var state_59400__$1 = state_59400;
var statearr_59418_59486 = state_59400__$1;
(statearr_59418_59486[(2)] = inst_59357);

(statearr_59418_59486[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (13))){
var inst_59295 = (state_59400[(17)]);
var inst_59297 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_59295);
var state_59400__$1 = state_59400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59400__$1,(16),inst_59297);
} else {
if((state_val_59401 === (22))){
var inst_59328 = (state_59400[(2)]);
var state_59400__$1 = state_59400;
if(cljs.core.truth_(inst_59328)){
var statearr_59419_59487 = state_59400__$1;
(statearr_59419_59487[(1)] = (23));

} else {
var statearr_59420_59488 = state_59400__$1;
(statearr_59420_59488[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (36))){
var state_59400__$1 = state_59400;
var statearr_59421_59489 = state_59400__$1;
(statearr_59421_59489[(2)] = null);

(statearr_59421_59489[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (41))){
var inst_59311 = (state_59400[(14)]);
var state_59400__$1 = state_59400;
var statearr_59422_59490 = state_59400__$1;
(statearr_59422_59490[(2)] = inst_59311);

(statearr_59422_59490[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (43))){
var inst_59386 = (state_59400[(15)]);
var inst_59392 = (state_59400[(2)]);
var inst_59393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59394 = [inst_59386,inst_59392];
var inst_59395 = (new cljs.core.PersistentVector(null,2,(5),inst_59393,inst_59394,null));
var _ = (function (){var statearr_59423 = state_59400;
(statearr_59423[(4)] = cljs.core.rest.call(null,(state_59400[(4)])));

return statearr_59423;
})();
var state_59400__$1 = state_59400;
var statearr_59424_59491 = state_59400__$1;
(statearr_59424_59491[(2)] = inst_59395);

(statearr_59424_59491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (29))){
var inst_59286 = (state_59400[(18)]);
var inst_59341 = cljs.core.pr_str.call(null,inst_59286);
var inst_59342 = ["Invalid block range provided: ",inst_59341].join('');
var inst_59343 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59344 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59345 = cljs.core.PersistentHashMap.fromArrays(inst_59343,inst_59344);
var inst_59346 = cljs.core.ex_info.call(null,inst_59342,inst_59345);
var inst_59347 = (function(){throw inst_59346})();
var state_59400__$1 = state_59400;
var statearr_59425_59492 = state_59400__$1;
(statearr_59425_59492[(2)] = inst_59347);

(statearr_59425_59492[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (6))){
var inst_59278 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_59400__$1 = state_59400;
var statearr_59426_59493 = state_59400__$1;
(statearr_59426_59493[(2)] = inst_59278);

(statearr_59426_59493[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (28))){
var inst_59352 = (state_59400[(2)]);
var state_59400__$1 = state_59400;
var statearr_59427_59494 = state_59400__$1;
(statearr_59427_59494[(2)] = inst_59352);

(statearr_59427_59494[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (25))){
var inst_59355 = (state_59400[(9)]);
var inst_59357 = (state_59400[(16)]);
var inst_59354 = (state_59400[(2)]);
var inst_59355__$1 = cljs.core.nth.call(null,inst_59354,(0),null);
var inst_59356 = cljs.core.nth.call(null,inst_59354,(1),null);
var inst_59357__$1 = cljs.core.pos_int_QMARK_.call(null,inst_59355__$1);
var state_59400__$1 = (function (){var statearr_59428 = state_59400;
(statearr_59428[(9)] = inst_59355__$1);

(statearr_59428[(16)] = inst_59357__$1);

(statearr_59428[(10)] = inst_59356);

return statearr_59428;
})();
if(inst_59357__$1){
var statearr_59429_59495 = state_59400__$1;
(statearr_59429_59495[(1)] = (32));

} else {
var statearr_59430_59496 = state_59400__$1;
(statearr_59430_59496[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (34))){
var inst_59362 = (state_59400[(2)]);
var inst_59363 = cljs.core.not.call(null,inst_59362);
var state_59400__$1 = state_59400;
if(inst_59363){
var statearr_59431_59497 = state_59400__$1;
(statearr_59431_59497[(1)] = (35));

} else {
var statearr_59432_59498 = state_59400__$1;
(statearr_59432_59498[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (17))){
var inst_59309 = (state_59400[(8)]);
var inst_59311 = (state_59400[(14)]);
var inst_59314 = cljs.core.pr_str.call(null,inst_59309);
var inst_59315 = cljs.core.pr_str.call(null,inst_59311);
var inst_59316 = ["Start block is out of range for this ledger. Start block provided: ",inst_59314,". Database block: ",inst_59315].join('');
var inst_59317 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59318 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59319 = cljs.core.PersistentHashMap.fromArrays(inst_59317,inst_59318);
var inst_59320 = cljs.core.ex_info.call(null,inst_59316,inst_59319);
var inst_59321 = (function(){throw inst_59320})();
var state_59400__$1 = state_59400;
var statearr_59433_59499 = state_59400__$1;
(statearr_59433_59499[(2)] = inst_59321);

(statearr_59433_59499[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (3))){
var inst_59398 = (state_59400[(2)]);
var state_59400__$1 = state_59400;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59400__$1,inst_59398);
} else {
if((state_val_59401 === (12))){
var inst_59295 = (state_59400[(17)]);
var inst_59286 = (state_59400[(18)]);
var inst_59293 = (state_59400[(2)]);
var inst_59294 = fluree.db.util.async.throw_err.call(null,inst_59293);
var inst_59295__$1 = cljs.core.second.call(null,inst_59286);
var state_59400__$1 = (function (){var statearr_59434 = state_59400;
(statearr_59434[(17)] = inst_59295__$1);

(statearr_59434[(11)] = inst_59294);

return statearr_59434;
})();
if(cljs.core.truth_(inst_59295__$1)){
var statearr_59435_59500 = state_59400__$1;
(statearr_59435_59500[(1)] = (13));

} else {
var statearr_59436_59501 = state_59400__$1;
(statearr_59436_59501[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (2))){
var _ = (function (){var statearr_59437 = state_59400;
(statearr_59437[(4)] = cljs.core.cons.call(null,(5),(state_59400[(4)])));

return statearr_59437;
})();
var inst_59275 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59276 = cljs.core.sequential_QMARK_.call(null,inst_59275);
var state_59400__$1 = state_59400;
if(inst_59276){
var statearr_59438_59502 = state_59400__$1;
(statearr_59438_59502[(1)] = (6));

} else {
var statearr_59439_59503 = state_59400__$1;
(statearr_59439_59503[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (23))){
var inst_59310 = (state_59400[(7)]);
var inst_59309 = (state_59400[(8)]);
var inst_59330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59331 = [inst_59309,inst_59310];
var inst_59332 = (new cljs.core.PersistentVector(null,2,(5),inst_59330,inst_59331,null));
var state_59400__$1 = state_59400;
var statearr_59440_59504 = state_59400__$1;
(statearr_59440_59504[(2)] = inst_59332);

(statearr_59440_59504[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (35))){
var inst_59286 = (state_59400[(18)]);
var inst_59365 = cljs.core.pr_str.call(null,inst_59286);
var inst_59366 = ["Invalid block range provided: ",inst_59365].join('');
var inst_59367 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59368 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59369 = cljs.core.PersistentHashMap.fromArrays(inst_59367,inst_59368);
var inst_59370 = cljs.core.ex_info.call(null,inst_59366,inst_59369);
var inst_59371 = (function(){throw inst_59370})();
var state_59400__$1 = state_59400;
var statearr_59441_59505 = state_59400__$1;
(statearr_59441_59505[(2)] = inst_59371);

(statearr_59441_59505[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (19))){
var inst_59309 = (state_59400[(8)]);
var inst_59324 = (state_59400[(2)]);
var state_59400__$1 = (function (){var statearr_59442 = state_59400;
(statearr_59442[(19)] = inst_59324);

return statearr_59442;
})();
if(cljs.core.truth_(inst_59309)){
var statearr_59443_59506 = state_59400__$1;
(statearr_59443_59506[(1)] = (20));

} else {
var statearr_59444_59507 = state_59400__$1;
(statearr_59444_59507[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (11))){
var inst_59309 = (state_59400[(8)]);
var inst_59311 = (state_59400[(14)]);
var inst_59308 = (state_59400[(2)]);
var inst_59309__$1 = cljs.core.nth.call(null,inst_59308,(0),null);
var inst_59310 = cljs.core.nth.call(null,inst_59308,(1),null);
var inst_59311__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_59312 = (inst_59309__$1 > inst_59311__$1);
var state_59400__$1 = (function (){var statearr_59446 = state_59400;
(statearr_59446[(7)] = inst_59310);

(statearr_59446[(8)] = inst_59309__$1);

(statearr_59446[(14)] = inst_59311__$1);

return statearr_59446;
})();
if(cljs.core.truth_(inst_59312)){
var statearr_59447_59508 = state_59400__$1;
(statearr_59447_59508[(1)] = (17));

} else {
var statearr_59448_59509 = state_59400__$1;
(statearr_59448_59509[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (9))){
var inst_59286 = (state_59400[(18)]);
var inst_59289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59290 = cljs.core.first.call(null,inst_59286);
var inst_59291 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_59290);
var state_59400__$1 = (function (){var statearr_59449 = state_59400;
(statearr_59449[(12)] = inst_59289);

return statearr_59449;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59400__$1,(12),inst_59291);
} else {
if((state_val_59401 === (5))){
var _ = (function (){var statearr_59450 = state_59400;
(statearr_59450[(4)] = cljs.core.rest.call(null,(state_59400[(4)])));

return statearr_59450;
})();
var state_59400__$1 = state_59400;
var ex59445 = (state_59400__$1[(2)]);
var statearr_59451_59510 = state_59400__$1;
(statearr_59451_59510[(5)] = ex59445);


if((ex59445 instanceof Error)){
var statearr_59452_59511 = state_59400__$1;
(statearr_59452_59511[(1)] = (4));

(statearr_59452_59511[(5)] = null);

} else {
throw ex59445;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (14))){
var state_59400__$1 = state_59400;
var statearr_59453_59512 = state_59400__$1;
(statearr_59453_59512[(2)] = null);

(statearr_59453_59512[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (26))){
var inst_59309 = (state_59400[(8)]);
var inst_59335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59336 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_59337 = [inst_59309,inst_59336];
var inst_59338 = (new cljs.core.PersistentVector(null,2,(5),inst_59335,inst_59337,null));
var state_59400__$1 = state_59400;
var statearr_59454_59513 = state_59400__$1;
(statearr_59454_59513[(2)] = inst_59338);

(statearr_59454_59513[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (16))){
var inst_59299 = (state_59400[(2)]);
var inst_59300 = fluree.db.util.async.throw_err.call(null,inst_59299);
var state_59400__$1 = state_59400;
var statearr_59455_59514 = state_59400__$1;
(statearr_59455_59514[(2)] = inst_59300);

(statearr_59455_59514[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (38))){
var inst_59355 = (state_59400[(9)]);
var inst_59356 = (state_59400[(10)]);
var inst_59377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59378 = [inst_59356,inst_59355];
var inst_59379 = (new cljs.core.PersistentVector(null,2,(5),inst_59377,inst_59378,null));
var state_59400__$1 = state_59400;
var statearr_59456_59515 = state_59400__$1;
(statearr_59456_59515[(2)] = inst_59379);

(statearr_59456_59515[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (30))){
var state_59400__$1 = state_59400;
var statearr_59457_59516 = state_59400__$1;
(statearr_59457_59516[(2)] = null);

(statearr_59457_59516[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (10))){
var inst_59286 = (state_59400[(18)]);
var state_59400__$1 = state_59400;
var statearr_59458_59517 = state_59400__$1;
(statearr_59458_59517[(2)] = inst_59286);

(statearr_59458_59517[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (18))){
var state_59400__$1 = state_59400;
var statearr_59459_59518 = state_59400__$1;
(statearr_59459_59518[(2)] = null);

(statearr_59459_59518[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (42))){
var inst_59387 = (state_59400[(13)]);
var state_59400__$1 = state_59400;
var statearr_59460_59519 = state_59400__$1;
(statearr_59460_59519[(2)] = inst_59387);

(statearr_59460_59519[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (37))){
var inst_59355 = (state_59400[(9)]);
var inst_59356 = (state_59400[(10)]);
var inst_59374 = (state_59400[(2)]);
var inst_59375 = (inst_59356 < inst_59355);
var state_59400__$1 = (function (){var statearr_59461 = state_59400;
(statearr_59461[(20)] = inst_59374);

return statearr_59461;
})();
if(cljs.core.truth_(inst_59375)){
var statearr_59462_59520 = state_59400__$1;
(statearr_59462_59520[(1)] = (38));

} else {
var statearr_59463_59521 = state_59400__$1;
(statearr_59463_59521[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59401 === (8))){
var inst_59286 = (state_59400[(18)]);
var inst_59286__$1 = (state_59400[(2)]);
var inst_59287 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_59286__$1);
var state_59400__$1 = (function (){var statearr_59464 = state_59400;
(statearr_59464[(18)] = inst_59286__$1);

return statearr_59464;
})();
if(cljs.core.truth_(inst_59287)){
var statearr_59465_59522 = state_59400__$1;
(statearr_59465_59522[(1)] = (9));

} else {
var statearr_59466_59523 = state_59400__$1;
(statearr_59466_59523[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0 = (function (){
var statearr_59467 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59467[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__);

(statearr_59467[(1)] = (1));

return statearr_59467;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1 = (function (state_59400){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_59400);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e59468){var ex__2749__auto__ = e59468;
var statearr_59469_59524 = state_59400;
(statearr_59469_59524[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_59400[(4)]))){
var statearr_59470_59525 = state_59400;
(statearr_59470_59525[(1)] = cljs.core.first.call(null,(state_59400[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59526 = state_59400;
state_59400 = G__59526;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__ = function(state_59400){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1.call(this,state_59400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_59471 = f__2769__auto__.call(null);
(statearr_59471[(6)] = c__2768__auto__);

return statearr_59471;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_59676){
var state_val_59677 = (state_59676[(1)]);
if((state_val_59677 === (7))){
var inst_59588 = (state_59676[(2)]);
var inst_59589 = cljs.core.nth.call(null,inst_59588,(0),null);
var inst_59590 = cljs.core.nth.call(null,inst_59588,(1),null);
var inst_59598 = cljs.core.vals.call(null,inst_59590);
var inst_59599 = cljs.core.seq.call(null,inst_59598);
var inst_59600 = cljs.core.first.call(null,inst_59599);
var inst_59601 = cljs.core.next.call(null,inst_59599);
var inst_59602 = cljs.core.PersistentVector.EMPTY;
var inst_59603 = inst_59598;
var inst_59604 = inst_59602;
var state_59676__$1 = (function (){var statearr_59678 = state_59676;
(statearr_59678[(7)] = inst_59601);

(statearr_59678[(8)] = inst_59589);

(statearr_59678[(9)] = inst_59600);

(statearr_59678[(10)] = inst_59604);

(statearr_59678[(11)] = inst_59603);

return statearr_59678;
})();
var statearr_59679_59732 = state_59676__$1;
(statearr_59679_59732[(2)] = null);

(statearr_59679_59732[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (20))){
var inst_59610 = (state_59676[(12)]);
var inst_59615 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_59616 = cljs.core.PersistentHashMap.EMPTY;
var inst_59617 = [true,inst_59616];
var inst_59618 = cljs.core.PersistentHashMap.fromArrays(inst_59615,inst_59617);
var inst_59619 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_59618,inst_59610);
var state_59676__$1 = state_59676;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59676__$1,(22),inst_59619);
} else {
if((state_val_59677 === (27))){
var inst_59664 = (state_59676[(2)]);
var state_59676__$1 = state_59676;
var statearr_59680_59733 = state_59676__$1;
(statearr_59680_59733[(2)] = inst_59664);

(statearr_59680_59733[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (1))){
var state_59676__$1 = state_59676;
var statearr_59681_59734 = state_59676__$1;
(statearr_59681_59734[(2)] = null);

(statearr_59681_59734[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (24))){
var inst_59628 = (state_59676[(13)]);
var inst_59666 = (state_59676[(2)]);
var inst_59667 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_59668 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59669 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59670 = [inst_59668,inst_59669,inst_59628,inst_59666];
var inst_59671 = cljs.core.PersistentHashMap.fromArrays(inst_59667,inst_59670);
var _ = (function (){var statearr_59683 = state_59676;
(statearr_59683[(4)] = cljs.core.rest.call(null,(state_59676[(4)])));

return statearr_59683;
})();
var state_59676__$1 = state_59676;
var statearr_59684_59735 = state_59676__$1;
(statearr_59684_59735[(2)] = inst_59671);

(statearr_59684_59735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (4))){
var inst_59529 = (state_59676[(2)]);
var state_59676__$1 = state_59676;
var statearr_59685_59736 = state_59676__$1;
(statearr_59685_59736[(2)] = inst_59529);

(statearr_59685_59736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (15))){
var inst_59553 = (state_59676[(14)]);
var inst_59567 = (state_59676[(15)]);
var inst_59560 = (state_59676[(16)]);
var inst_59548 = (state_59676[(17)]);
var inst_59545 = (state_59676[(18)]);
var inst_59569 = (state_59676[(19)]);
var inst_59552 = (state_59676[(20)]);
var inst_59559 = (state_59676[(21)]);
var inst_59574 = (state_59676[(22)]);
var inst_59551 = (state_59676[(23)]);
var inst_59547 = (state_59676[(24)]);
var inst_59580 = (function (){var G__59541 = inst_59551;
var subject = inst_59567;
var flake = inst_59559;
var r = inst_59560;
var asserted_subjects = inst_59552;
var seq__59556 = inst_59560;
var flake_SINGLEQUOTE_ = inst_59574;
var retracted_subjects = inst_59553;
var seq__59543 = inst_59548;
var vec__59542 = inst_59545;
var first__59544 = inst_59547;
var first__59557 = inst_59559;
var asserted_QMARK_ = inst_59569;
var vec__59555 = inst_59551;
return (function (p1__59528_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__59528_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_59581 = cljs.core.update.call(null,inst_59553,inst_59567,inst_59580);
var tmp59682 = inst_59552;
var inst_59551__$1 = inst_59560;
var inst_59552__$1 = tmp59682;
var inst_59553__$1 = inst_59581;
var state_59676__$1 = (function (){var statearr_59686 = state_59676;
(statearr_59686[(14)] = inst_59553__$1);

(statearr_59686[(20)] = inst_59552__$1);

(statearr_59686[(23)] = inst_59551__$1);

return statearr_59686;
})();
var statearr_59687_59737 = state_59676__$1;
(statearr_59687_59737[(2)] = null);

(statearr_59687_59737[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (21))){
var inst_59626 = (state_59676[(2)]);
var state_59676__$1 = state_59676;
var statearr_59688_59738 = state_59676__$1;
(statearr_59688_59738[(2)] = inst_59626);

(statearr_59688_59738[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (13))){
var inst_59569 = (state_59676[(19)]);
var inst_59574 = (state_59676[(2)]);
var state_59676__$1 = (function (){var statearr_59689 = state_59676;
(statearr_59689[(22)] = inst_59574);

return statearr_59689;
})();
if(cljs.core.truth_(inst_59569)){
var statearr_59690_59739 = state_59676__$1;
(statearr_59690_59739[(1)] = (14));

} else {
var statearr_59691_59740 = state_59676__$1;
(statearr_59691_59740[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (22))){
var inst_59604 = (state_59676[(10)]);
var inst_59611 = (state_59676[(25)]);
var inst_59621 = (state_59676[(2)]);
var inst_59622 = fluree.db.util.async.throw_err.call(null,inst_59621);
var inst_59623 = cljs.core.conj.call(null,inst_59604,inst_59622);
var inst_59603 = inst_59611;
var inst_59604__$1 = inst_59623;
var state_59676__$1 = (function (){var statearr_59692 = state_59676;
(statearr_59692[(10)] = inst_59604__$1);

(statearr_59692[(11)] = inst_59603);

return statearr_59692;
})();
var statearr_59693_59741 = state_59676__$1;
(statearr_59693_59741[(2)] = null);

(statearr_59693_59741[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (6))){
var inst_59559 = (state_59676[(21)]);
var inst_59551 = (state_59676[(23)]);
var inst_59558 = cljs.core.seq.call(null,inst_59551);
var inst_59559__$1 = cljs.core.first.call(null,inst_59558);
var inst_59560 = cljs.core.next.call(null,inst_59558);
var inst_59561 = cljs.core.not.call(null,inst_59559__$1);
var state_59676__$1 = (function (){var statearr_59694 = state_59676;
(statearr_59694[(16)] = inst_59560);

(statearr_59694[(21)] = inst_59559__$1);

return statearr_59694;
})();
if(inst_59561){
var statearr_59695_59742 = state_59676__$1;
(statearr_59695_59742[(1)] = (8));

} else {
var statearr_59696_59743 = state_59676__$1;
(statearr_59696_59743[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (28))){
var inst_59642 = (state_59676[(26)]);
var inst_59649 = (state_59676[(27)]);
var inst_59659 = (state_59676[(2)]);
var inst_59660 = fluree.db.util.async.throw_err.call(null,inst_59659);
var inst_59661 = cljs.core.conj.call(null,inst_59642,inst_59660);
var inst_59641 = inst_59649;
var inst_59642__$1 = inst_59661;
var state_59676__$1 = (function (){var statearr_59697 = state_59676;
(statearr_59697[(26)] = inst_59642__$1);

(statearr_59697[(28)] = inst_59641);

return statearr_59697;
})();
var statearr_59698_59744 = state_59676__$1;
(statearr_59698_59744[(2)] = null);

(statearr_59698_59744[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (25))){
var inst_59642 = (state_59676[(26)]);
var state_59676__$1 = state_59676;
var statearr_59699_59745 = state_59676__$1;
(statearr_59699_59745[(2)] = inst_59642);

(statearr_59699_59745[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (17))){
var inst_59610 = (state_59676[(12)]);
var inst_59603 = (state_59676[(11)]);
var inst_59609 = cljs.core.seq.call(null,inst_59603);
var inst_59610__$1 = cljs.core.first.call(null,inst_59609);
var inst_59611 = cljs.core.next.call(null,inst_59609);
var inst_59612 = cljs.core.not.call(null,inst_59610__$1);
var state_59676__$1 = (function (){var statearr_59700 = state_59676;
(statearr_59700[(12)] = inst_59610__$1);

(statearr_59700[(25)] = inst_59611);

return statearr_59700;
})();
if(inst_59612){
var statearr_59701_59746 = state_59676__$1;
(statearr_59701_59746[(1)] = (19));

} else {
var statearr_59702_59747 = state_59676__$1;
(statearr_59702_59747[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (3))){
var inst_59674 = (state_59676[(2)]);
var state_59676__$1 = state_59676;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59676__$1,inst_59674);
} else {
if((state_val_59677 === (12))){
var inst_59559 = (state_59676[(21)]);
var inst_59572 = fluree.db.flake.flip_flake.call(null,inst_59559);
var state_59676__$1 = state_59676;
var statearr_59703_59748 = state_59676__$1;
(statearr_59703_59748[(2)] = inst_59572);

(statearr_59703_59748[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (2))){
var inst_59545 = (state_59676[(18)]);
var _ = (function (){var statearr_59704 = state_59676;
(statearr_59704[(4)] = cljs.core.cons.call(null,(5),(state_59676[(4)])));

return statearr_59704;
})();
var inst_59545__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59546 = cljs.core.seq.call(null,inst_59545__$1);
var inst_59547 = cljs.core.first.call(null,inst_59546);
var inst_59548 = cljs.core.next.call(null,inst_59546);
var inst_59549 = cljs.core.PersistentHashMap.EMPTY;
var inst_59550 = cljs.core.PersistentHashMap.EMPTY;
var inst_59551 = inst_59545__$1;
var inst_59552 = inst_59549;
var inst_59553 = inst_59550;
var state_59676__$1 = (function (){var statearr_59705 = state_59676;
(statearr_59705[(14)] = inst_59553);

(statearr_59705[(17)] = inst_59548);

(statearr_59705[(18)] = inst_59545__$1);

(statearr_59705[(20)] = inst_59552);

(statearr_59705[(23)] = inst_59551);

(statearr_59705[(24)] = inst_59547);

return statearr_59705;
})();
var statearr_59706_59749 = state_59676__$1;
(statearr_59706_59749[(2)] = null);

(statearr_59706_59749[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (23))){
var inst_59648 = (state_59676[(29)]);
var inst_59641 = (state_59676[(28)]);
var inst_59647 = cljs.core.seq.call(null,inst_59641);
var inst_59648__$1 = cljs.core.first.call(null,inst_59647);
var inst_59649 = cljs.core.next.call(null,inst_59647);
var inst_59650 = cljs.core.not.call(null,inst_59648__$1);
var state_59676__$1 = (function (){var statearr_59707 = state_59676;
(statearr_59707[(29)] = inst_59648__$1);

(statearr_59707[(27)] = inst_59649);

return statearr_59707;
})();
if(inst_59650){
var statearr_59708_59750 = state_59676__$1;
(statearr_59708_59750[(1)] = (25));

} else {
var statearr_59709_59751 = state_59676__$1;
(statearr_59709_59751[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (19))){
var inst_59604 = (state_59676[(10)]);
var state_59676__$1 = state_59676;
var statearr_59710_59752 = state_59676__$1;
(statearr_59710_59752[(2)] = inst_59604);

(statearr_59710_59752[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (11))){
var inst_59559 = (state_59676[(21)]);
var state_59676__$1 = state_59676;
var statearr_59712_59753 = state_59676__$1;
(statearr_59712_59753[(2)] = inst_59559);

(statearr_59712_59753[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (9))){
var inst_59569 = (state_59676[(19)]);
var inst_59559 = (state_59676[(21)]);
var inst_59567 = inst_59559.s;
var inst_59568 = inst_59559.op;
var inst_59569__$1 = inst_59568 === true;
var state_59676__$1 = (function (){var statearr_59714 = state_59676;
(statearr_59714[(15)] = inst_59567);

(statearr_59714[(19)] = inst_59569__$1);

return statearr_59714;
})();
if(cljs.core.truth_(inst_59569__$1)){
var statearr_59715_59754 = state_59676__$1;
(statearr_59715_59754[(1)] = (11));

} else {
var statearr_59716_59755 = state_59676__$1;
(statearr_59716_59755[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (5))){
var _ = (function (){var statearr_59717 = state_59676;
(statearr_59717[(4)] = cljs.core.rest.call(null,(state_59676[(4)])));

return statearr_59717;
})();
var state_59676__$1 = state_59676;
var ex59711 = (state_59676__$1[(2)]);
var statearr_59718_59756 = state_59676__$1;
(statearr_59718_59756[(5)] = ex59711);


if((ex59711 instanceof Error)){
var statearr_59719_59757 = state_59676__$1;
(statearr_59719_59757[(1)] = (4));

(statearr_59719_59757[(5)] = null);

} else {
throw ex59711;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (14))){
var inst_59553 = (state_59676[(14)]);
var inst_59567 = (state_59676[(15)]);
var inst_59560 = (state_59676[(16)]);
var inst_59548 = (state_59676[(17)]);
var inst_59545 = (state_59676[(18)]);
var inst_59569 = (state_59676[(19)]);
var inst_59552 = (state_59676[(20)]);
var inst_59559 = (state_59676[(21)]);
var inst_59574 = (state_59676[(22)]);
var inst_59551 = (state_59676[(23)]);
var inst_59547 = (state_59676[(24)]);
var inst_59576 = (function (){var G__59541 = inst_59551;
var subject = inst_59567;
var flake = inst_59559;
var r = inst_59560;
var asserted_subjects = inst_59552;
var seq__59556 = inst_59560;
var flake_SINGLEQUOTE_ = inst_59574;
var retracted_subjects = inst_59553;
var seq__59543 = inst_59548;
var vec__59542 = inst_59545;
var first__59544 = inst_59547;
var first__59557 = inst_59559;
var asserted_QMARK_ = inst_59569;
var vec__59555 = inst_59551;
return (function (p1__59527_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__59527_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_59577 = cljs.core.update.call(null,inst_59552,inst_59567,inst_59576);
var tmp59713 = inst_59553;
var inst_59551__$1 = inst_59560;
var inst_59552__$1 = inst_59577;
var inst_59553__$1 = tmp59713;
var state_59676__$1 = (function (){var statearr_59720 = state_59676;
(statearr_59720[(14)] = inst_59553__$1);

(statearr_59720[(20)] = inst_59552__$1);

(statearr_59720[(23)] = inst_59551__$1);

return statearr_59720;
})();
var statearr_59721_59758 = state_59676__$1;
(statearr_59721_59758[(2)] = null);

(statearr_59721_59758[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (26))){
var inst_59648 = (state_59676[(29)]);
var inst_59653 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_59654 = cljs.core.PersistentHashMap.EMPTY;
var inst_59655 = [true,inst_59654];
var inst_59656 = cljs.core.PersistentHashMap.fromArrays(inst_59653,inst_59655);
var inst_59657 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_59656,inst_59648);
var state_59676__$1 = state_59676;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59676__$1,(28),inst_59657);
} else {
if((state_val_59677 === (16))){
var inst_59584 = (state_59676[(2)]);
var state_59676__$1 = state_59676;
var statearr_59722_59759 = state_59676__$1;
(statearr_59722_59759[(2)] = inst_59584);

(statearr_59722_59759[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (10))){
var inst_59586 = (state_59676[(2)]);
var state_59676__$1 = state_59676;
var statearr_59723_59760 = state_59676__$1;
(statearr_59723_59760[(2)] = inst_59586);

(statearr_59723_59760[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (18))){
var inst_59589 = (state_59676[(8)]);
var inst_59628 = (state_59676[(2)]);
var inst_59636 = cljs.core.vals.call(null,inst_59589);
var inst_59637 = cljs.core.seq.call(null,inst_59636);
var inst_59638 = cljs.core.first.call(null,inst_59637);
var inst_59639 = cljs.core.next.call(null,inst_59637);
var inst_59640 = cljs.core.PersistentVector.EMPTY;
var inst_59641 = inst_59636;
var inst_59642 = inst_59640;
var state_59676__$1 = (function (){var statearr_59724 = state_59676;
(statearr_59724[(30)] = inst_59639);

(statearr_59724[(13)] = inst_59628);

(statearr_59724[(31)] = inst_59638);

(statearr_59724[(26)] = inst_59642);

(statearr_59724[(28)] = inst_59641);

return statearr_59724;
})();
var statearr_59725_59761 = state_59676__$1;
(statearr_59725_59761[(2)] = null);

(statearr_59725_59761[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59677 === (8))){
var inst_59553 = (state_59676[(14)]);
var inst_59552 = (state_59676[(20)]);
var inst_59563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59564 = [inst_59552,inst_59553];
var inst_59565 = (new cljs.core.PersistentVector(null,2,(5),inst_59563,inst_59564,null));
var state_59676__$1 = state_59676;
var statearr_59726_59762 = state_59676__$1;
(statearr_59726_59762[(2)] = inst_59565);

(statearr_59726_59762[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_59727 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59727[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__);

(statearr_59727[(1)] = (1));

return statearr_59727;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1 = (function (state_59676){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_59676);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e59728){var ex__2749__auto__ = e59728;
var statearr_59729_59763 = state_59676;
(statearr_59729_59763[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_59676[(4)]))){
var statearr_59730_59764 = state_59676;
(statearr_59730_59764[(1)] = cljs.core.first.call(null,(state_59676[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59765 = state_59676;
state_59676 = G__59765;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__ = function(state_59676){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1.call(this,state_59676);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_59731 = f__2769__auto__.call(null);
(statearr_59731[(6)] = c__2768__auto__);

return statearr_59731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_59797){
var state_val_59798 = (state_59797[(1)]);
if((state_val_59798 === (1))){
var inst_59766 = cljs.core.volatile_BANG_.call(null,(0));
var inst_59767 = cljs.core.PersistentHashMap.EMPTY;
var inst_59768 = cljs.core.volatile_BANG_.call(null,inst_59767);
var inst_59769 = cljs.core.first.call(null,resp);
var inst_59770 = cljs.core.rest.call(null,resp);
var inst_59771 = cljs.core.PersistentVector.EMPTY;
var inst_59772 = inst_59766;
var inst_59773 = inst_59768;
var inst_59774 = inst_59769;
var inst_59775 = inst_59770;
var inst_59776 = inst_59771;
var state_59797__$1 = (function (){var statearr_59799 = state_59797;
(statearr_59799[(7)] = inst_59772);

(statearr_59799[(8)] = inst_59776);

(statearr_59799[(9)] = inst_59774);

(statearr_59799[(10)] = inst_59775);

(statearr_59799[(11)] = inst_59773);

return statearr_59799;
})();
var statearr_59800_59815 = state_59797__$1;
(statearr_59800_59815[(2)] = null);

(statearr_59800_59815[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59798 === (2))){
var inst_59772 = (state_59797[(7)]);
var inst_59774 = (state_59797[(9)]);
var inst_59773 = (state_59797[(11)]);
var inst_59778 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_59774,inst_59773,inst_59772);
var state_59797__$1 = state_59797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59797__$1,(4),inst_59778);
} else {
if((state_val_59798 === (3))){
var inst_59795 = (state_59797[(2)]);
var state_59797__$1 = state_59797;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59797__$1,inst_59795);
} else {
if((state_val_59798 === (4))){
var inst_59776 = (state_59797[(8)]);
var inst_59775 = (state_59797[(10)]);
var inst_59780 = (state_59797[(2)]);
var inst_59781 = fluree.db.util.async.throw_err.call(null,inst_59780);
var inst_59782 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59783 = [inst_59781];
var inst_59784 = (new cljs.core.PersistentVector(null,1,(5),inst_59782,inst_59783,null));
var inst_59785 = cljs.core.concat.call(null,inst_59776,inst_59784);
var inst_59786 = cljs.core.first.call(null,inst_59775);
var state_59797__$1 = (function (){var statearr_59803 = state_59797;
(statearr_59803[(12)] = inst_59785);

return statearr_59803;
})();
if(cljs.core.truth_(inst_59786)){
var statearr_59804_59816 = state_59797__$1;
(statearr_59804_59816[(1)] = (5));

} else {
var statearr_59805_59817 = state_59797__$1;
(statearr_59805_59817[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59798 === (5))){
var inst_59772 = (state_59797[(7)]);
var inst_59785 = (state_59797[(12)]);
var inst_59775 = (state_59797[(10)]);
var inst_59773 = (state_59797[(11)]);
var inst_59788 = cljs.core.first.call(null,inst_59775);
var inst_59789 = cljs.core.rest.call(null,inst_59775);
var tmp59801 = inst_59772;
var tmp59802 = inst_59773;
var inst_59772__$1 = tmp59801;
var inst_59773__$1 = tmp59802;
var inst_59774 = inst_59788;
var inst_59775__$1 = inst_59789;
var inst_59776 = inst_59785;
var state_59797__$1 = (function (){var statearr_59806 = state_59797;
(statearr_59806[(7)] = inst_59772__$1);

(statearr_59806[(8)] = inst_59776);

(statearr_59806[(9)] = inst_59774);

(statearr_59806[(10)] = inst_59775__$1);

(statearr_59806[(11)] = inst_59773__$1);

return statearr_59806;
})();
var statearr_59807_59818 = state_59797__$1;
(statearr_59807_59818[(2)] = null);

(statearr_59807_59818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59798 === (6))){
var inst_59785 = (state_59797[(12)]);
var state_59797__$1 = state_59797;
var statearr_59808_59819 = state_59797__$1;
(statearr_59808_59819[(2)] = inst_59785);

(statearr_59808_59819[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59798 === (7))){
var inst_59793 = (state_59797[(2)]);
var state_59797__$1 = state_59797;
var statearr_59809_59820 = state_59797__$1;
(statearr_59809_59820[(2)] = inst_59793);

(statearr_59809_59820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_59810 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59810[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__);

(statearr_59810[(1)] = (1));

return statearr_59810;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1 = (function (state_59797){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_59797);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e59811){var ex__2749__auto__ = e59811;
var statearr_59812_59821 = state_59797;
(statearr_59812_59821[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_59797[(4)]))){
var statearr_59813_59822 = state_59797;
(statearr_59813_59822[(1)] = cljs.core.first.call(null,(state_59797[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59823 = state_59797;
state_59797 = G__59823;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__ = function(state_59797){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1.call(this,state_59797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_59814 = f__2769__auto__.call(null);
(statearr_59814[(6)] = c__2768__auto__);

return statearr_59814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__59825 = arguments.length;
switch (G__59825) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__59827){
var map__59828 = p__59827;
var map__59828__$1 = cljs.core.__destructure_map.call(null,map__59828);
var query = map__59828__$1;
var opts = cljs.core.get.call(null,map__59828__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_59913){
var state_val_59914 = (state_59913[(1)]);
if((state_val_59914 === (7))){
var inst_59839 = (state_59913[(7)]);
var inst_59843 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59844 = ["_auth/id",inst_59839];
var inst_59845 = (new cljs.core.PersistentVector(null,2,(5),inst_59843,inst_59844,null));
var state_59913__$1 = state_59913;
var statearr_59915_59959 = state_59913__$1;
(statearr_59915_59959[(2)] = inst_59845);

(statearr_59915_59959[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (20))){
var inst_59893 = (state_59913[(2)]);
var inst_59894 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_59913__$1 = (function (){var statearr_59916 = state_59913;
(statearr_59916[(8)] = inst_59893);

return statearr_59916;
})();
if(cljs.core.truth_(inst_59894)){
var statearr_59917_59960 = state_59913__$1;
(statearr_59917_59960[(1)] = (22));

} else {
var statearr_59918_59961 = state_59913__$1;
(statearr_59918_59961[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (27))){
var inst_59896 = (state_59913[(9)]);
var inst_59840 = (state_59913[(10)]);
var inst_59902 = (state_59913[(2)]);
var inst_59903 = fluree.db.util.core.response_time_formatted.call(null,inst_59840);
var inst_59904 = [(200),inst_59902,(100),inst_59903];
var inst_59905 = cljs.core.PersistentHashMap.fromArrays(inst_59896,inst_59904);
var state_59913__$1 = state_59913;
var statearr_59919_59962 = state_59913__$1;
(statearr_59919_59962[(2)] = inst_59905);

(statearr_59919_59962[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (1))){
var state_59913__$1 = state_59913;
var statearr_59920_59963 = state_59913__$1;
(statearr_59920_59963[(2)] = null);

(statearr_59920_59963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (24))){
var inst_59908 = (state_59913[(2)]);
var _ = (function (){var statearr_59921 = state_59913;
(statearr_59921[(4)] = cljs.core.rest.call(null,(state_59913[(4)])));

return statearr_59921;
})();
var state_59913__$1 = state_59913;
var statearr_59922_59964 = state_59913__$1;
(statearr_59922_59964[(2)] = inst_59908);

(statearr_59922_59964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (4))){
var inst_59829 = (state_59913[(2)]);
var state_59913__$1 = state_59913;
var statearr_59923_59965 = state_59913__$1;
(statearr_59923_59965[(2)] = inst_59829);

(statearr_59923_59965[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (15))){
var inst_59880 = (state_59913[(11)]);
var state_59913__$1 = state_59913;
var statearr_59924_59966 = state_59913__$1;
(statearr_59924_59966[(2)] = inst_59880);

(statearr_59924_59966[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (21))){
var inst_59889 = (state_59913[(2)]);
var inst_59890 = fluree.db.util.async.throw_err.call(null,inst_59889);
var state_59913__$1 = state_59913;
var statearr_59925_59967 = state_59913__$1;
(statearr_59925_59967[(2)] = inst_59890);

(statearr_59925_59967[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (13))){
var inst_59880 = (state_59913[(11)]);
var inst_59838 = (state_59913[(12)]);
var inst_59879 = (state_59913[(2)]);
var inst_59880__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_59838);
var state_59913__$1 = (function (){var statearr_59926 = state_59913;
(statearr_59926[(13)] = inst_59879);

(statearr_59926[(11)] = inst_59880__$1);

return statearr_59926;
})();
if(cljs.core.truth_(inst_59880__$1)){
var statearr_59927_59968 = state_59913__$1;
(statearr_59927_59968[(1)] = (15));

} else {
var statearr_59928_59969 = state_59913__$1;
(statearr_59928_59969[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (22))){
var inst_59893 = (state_59913[(8)]);
var inst_59896 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_59897 = cljs.core.sequential_QMARK_.call(null,inst_59893);
var state_59913__$1 = (function (){var statearr_59929 = state_59913;
(statearr_59929[(9)] = inst_59896);

return statearr_59929;
})();
if(inst_59897){
var statearr_59930_59970 = state_59913__$1;
(statearr_59930_59970[(1)] = (25));

} else {
var statearr_59931_59971 = state_59913__$1;
(statearr_59931_59971[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (6))){
var inst_59854 = (state_59913[(14)]);
var inst_59838 = (state_59913[(12)]);
var inst_59853 = (state_59913[(2)]);
var inst_59854__$1 = fluree.db.util.async.throw_err.call(null,inst_59853);
var inst_59855 = fluree.db.api.query.resolve_block_range.call(null,inst_59854__$1,inst_59838);
var state_59913__$1 = (function (){var statearr_59932 = state_59913;
(statearr_59932[(14)] = inst_59854__$1);

return statearr_59932;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59913__$1,(10),inst_59855);
} else {
if((state_val_59914 === (25))){
var inst_59893 = (state_59913[(8)]);
var inst_59899 = cljs.core.doall.call(null,inst_59893);
var state_59913__$1 = state_59913;
var statearr_59933_59972 = state_59913__$1;
(statearr_59933_59972[(2)] = inst_59899);

(statearr_59933_59972[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (17))){
var inst_59885 = (state_59913[(2)]);
var state_59913__$1 = state_59913;
if(cljs.core.truth_(inst_59885)){
var statearr_59934_59973 = state_59913__$1;
(statearr_59934_59973[(1)] = (18));

} else {
var statearr_59935_59974 = state_59913__$1;
(statearr_59935_59974[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (3))){
var inst_59911 = (state_59913[(2)]);
var state_59913__$1 = state_59913;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59913__$1,inst_59911);
} else {
if((state_val_59914 === (12))){
var inst_59838 = (state_59913[(12)]);
var inst_59871 = cljs.core.pr_str.call(null,inst_59838);
var inst_59872 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_59871].join('');
var inst_59873 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59874 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59875 = cljs.core.PersistentHashMap.fromArrays(inst_59873,inst_59874);
var inst_59876 = cljs.core.ex_info.call(null,inst_59872,inst_59875);
var inst_59877 = (function(){throw inst_59876})();
var state_59913__$1 = state_59913;
var statearr_59936_59975 = state_59913__$1;
(statearr_59936_59975[(2)] = inst_59877);

(statearr_59936_59975[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (2))){
var inst_59839 = (state_59913[(7)]);
var _ = (function (){var statearr_59937 = state_59913;
(statearr_59937[(4)] = cljs.core.cons.call(null,(5),(state_59913[(4)])));

return statearr_59937;
})();
var inst_59838 = cljs.core.dissoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_59839__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_59840 = fluree.db.util.core.current_time_millis.call(null);
var inst_59841 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_59913__$1 = (function (){var statearr_59938 = state_59913;
(statearr_59938[(15)] = inst_59841);

(statearr_59938[(10)] = inst_59840);

(statearr_59938[(7)] = inst_59839__$1);

(statearr_59938[(12)] = inst_59838);

return statearr_59938;
})();
if(cljs.core.truth_(inst_59839__$1)){
var statearr_59939_59976 = state_59913__$1;
(statearr_59939_59976[(1)] = (7));

} else {
var statearr_59940_59977 = state_59913__$1;
(statearr_59940_59977[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (23))){
var inst_59893 = (state_59913[(8)]);
var state_59913__$1 = state_59913;
var statearr_59941_59978 = state_59913__$1;
(statearr_59941_59978[(2)] = inst_59893);

(statearr_59941_59978[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (19))){
var inst_59879 = (state_59913[(13)]);
var state_59913__$1 = state_59913;
var statearr_59942_59979 = state_59913__$1;
(statearr_59942_59979[(2)] = inst_59879);

(statearr_59942_59979[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (11))){
var inst_59854 = (state_59913[(14)]);
var inst_59860 = (state_59913[(16)]);
var inst_59859 = (state_59913[(17)]);
var inst_59866 = fluree.db.api.query.block_range.call(null,inst_59854,inst_59859,inst_59860,opts);
var state_59913__$1 = state_59913;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59913__$1,(14),inst_59866);
} else {
if((state_val_59914 === (9))){
var inst_59841 = (state_59913[(15)]);
var inst_59848 = (state_59913[(2)]);
var inst_59849 = [inst_59848];
var inst_59850 = cljs.core.PersistentHashMap.fromArrays(inst_59841,inst_59849);
var inst_59851 = fluree.db.api.query.db.call(null,conn,ledger,inst_59850);
var state_59913__$1 = state_59913;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59913__$1,(6),inst_59851);
} else {
if((state_val_59914 === (5))){
var _ = (function (){var statearr_59944 = state_59913;
(statearr_59944[(4)] = cljs.core.rest.call(null,(state_59913[(4)])));

return statearr_59944;
})();
var state_59913__$1 = state_59913;
var ex59943 = (state_59913__$1[(2)]);
var statearr_59945_59980 = state_59913__$1;
(statearr_59945_59980[(5)] = ex59943);


if((ex59943 instanceof Error)){
var statearr_59946_59981 = state_59913__$1;
(statearr_59946_59981[(1)] = (4));

(statearr_59946_59981[(5)] = null);

} else {
throw ex59943;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (14))){
var inst_59868 = (state_59913[(2)]);
var inst_59869 = fluree.db.util.async.throw_err.call(null,inst_59868);
var state_59913__$1 = state_59913;
var statearr_59947_59982 = state_59913__$1;
(statearr_59947_59982[(2)] = inst_59869);

(statearr_59947_59982[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (26))){
var inst_59893 = (state_59913[(8)]);
var state_59913__$1 = state_59913;
var statearr_59948_59983 = state_59913__$1;
(statearr_59948_59983[(2)] = inst_59893);

(statearr_59948_59983[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (16))){
var inst_59838 = (state_59913[(12)]);
var inst_59883 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_59838);
var state_59913__$1 = state_59913;
var statearr_59949_59984 = state_59913__$1;
(statearr_59949_59984[(2)] = inst_59883);

(statearr_59949_59984[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (10))){
var inst_59838 = (state_59913[(12)]);
var inst_59857 = (state_59913[(2)]);
var inst_59858 = fluree.db.util.async.throw_err.call(null,inst_59857);
var inst_59859 = cljs.core.nth.call(null,inst_59858,(0),null);
var inst_59860 = cljs.core.nth.call(null,inst_59858,(1),null);
var inst_59861 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_59862 = cljs.core.dissoc.call(null,inst_59838,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_59863 = cljs.core.keys.call(null,inst_59862);
var inst_59864 = cljs.core._EQ_.call(null,inst_59861,inst_59863);
var state_59913__$1 = (function (){var statearr_59950 = state_59913;
(statearr_59950[(16)] = inst_59860);

(statearr_59950[(17)] = inst_59859);

return statearr_59950;
})();
if(inst_59864){
var statearr_59951_59985 = state_59913__$1;
(statearr_59951_59985[(1)] = (11));

} else {
var statearr_59952_59986 = state_59913__$1;
(statearr_59952_59986[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59914 === (18))){
var inst_59854 = (state_59913[(14)]);
var inst_59879 = (state_59913[(13)]);
var inst_59887 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_59854,inst_59879);
var state_59913__$1 = state_59913;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59913__$1,(21),inst_59887);
} else {
if((state_val_59914 === (8))){
var state_59913__$1 = state_59913;
var statearr_59953_59987 = state_59913__$1;
(statearr_59953_59987[(2)] = null);

(statearr_59953_59987[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_59954 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59954[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2746__auto__);

(statearr_59954[(1)] = (1));

return statearr_59954;
});
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1 = (function (state_59913){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_59913);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e59955){var ex__2749__auto__ = e59955;
var statearr_59956_59988 = state_59913;
(statearr_59956_59988[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_59913[(4)]))){
var statearr_59957_59989 = state_59913;
(statearr_59957_59989[(1)] = cljs.core.first.call(null,(state_59913[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59990 = state_59913;
state_59913 = G__59990;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__ = function(state_59913){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1.call(this,state_59913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_59958 = f__2769__auto__.call(null);
(statearr_59958[(6)] = c__2768__auto__);

return statearr_59958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__59991 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__59991,(0),null);
var p = cljs.core.nth.call(null,vec__59991,(1),null);
var o = cljs.core.nth.call(null,vec__59991,(2),null);
var t = cljs.core.nth.call(null,vec__59991,(3),null);
var vec__59994 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__59994,(0),null);
var idx = cljs.core.nth.call(null,vec__59994,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__59997 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__59997,(0),null);
var id = cljs.core.nth.call(null,vec__59997,(1),null);
var or__4253__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___60001 = arguments.length;
var i__4865__auto___60002 = (0);
while(true){
if((i__4865__auto___60002 < len__4864__auto___60001)){
args__4870__auto__.push((arguments[i__4865__auto___60002]));

var G__60003 = (i__4865__auto___60002 + (1));
i__4865__auto___60002 = G__60003;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq60000){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq60000));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_60199){
var state_val_60200 = (state_60199[(1)]);
if((state_val_60200 === (7))){
var inst_60119 = (state_60199[(7)]);
var inst_60126 = (state_60199[(8)]);
var inst_60125 = cljs.core.seq.call(null,inst_60119);
var inst_60126__$1 = cljs.core.first.call(null,inst_60125);
var inst_60127 = cljs.core.next.call(null,inst_60125);
var state_60199__$1 = (function (){var statearr_60201 = state_60199;
(statearr_60201[(8)] = inst_60126__$1);

(statearr_60201[(9)] = inst_60127);

return statearr_60201;
})();
if(cljs.core.truth_(inst_60126__$1)){
var statearr_60202_60302 = state_60199__$1;
(statearr_60202_60302[(1)] = (9));

} else {
var statearr_60203_60303 = state_60199__$1;
(statearr_60203_60303[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (20))){
var inst_60189 = (state_60199[(2)]);
var state_60199__$1 = state_60199;
var statearr_60204_60304 = state_60199__$1;
(statearr_60204_60304[(2)] = inst_60189);

(statearr_60204_60304[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (27))){
var inst_60165 = (state_60199[(10)]);
var inst_60144 = (state_60199[(11)]);
var inst_60147 = (state_60199[(12)]);
var inst_60167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60168 = [inst_60147,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_60169 = (new cljs.core.PersistentVector(null,2,(5),inst_60167,inst_60168,null));
var inst_60170 = cljs.core.update_in.call(null,inst_60165,inst_60169,fluree.db.api.query.min_safe,inst_60144);
var state_60199__$1 = state_60199;
var statearr_60205_60305 = state_60199__$1;
(statearr_60205_60305[(2)] = inst_60170);

(statearr_60205_60305[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (1))){
var state_60199__$1 = state_60199;
var statearr_60206_60306 = state_60199__$1;
(statearr_60206_60306[(2)] = null);

(statearr_60206_60306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (24))){
var inst_60147 = (state_60199[(12)]);
var inst_60126 = (state_60199[(8)]);
var inst_60157 = (state_60199[(13)]);
var inst_60159 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60160 = [inst_60147,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_60161 = (new cljs.core.PersistentVector(null,2,(5),inst_60159,inst_60160,null));
var inst_60162 = cljs.core.update_in.call(null,inst_60157,inst_60161,cljs.core.conj,inst_60126);
var state_60199__$1 = state_60199;
var statearr_60208_60307 = state_60199__$1;
(statearr_60208_60307[(2)] = inst_60162);

(statearr_60208_60307[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (4))){
var inst_60005 = (state_60199[(2)]);
var state_60199__$1 = state_60199;
var statearr_60209_60308 = state_60199__$1;
(statearr_60209_60308[(2)] = inst_60005);

(statearr_60209_60308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (15))){
var inst_60120 = (state_60199[(14)]);
var inst_60127 = (state_60199[(9)]);
var tmp60207 = inst_60120;
var inst_60119 = inst_60127;
var inst_60120__$1 = tmp60207;
var state_60199__$1 = (function (){var statearr_60210 = state_60199;
(statearr_60210[(7)] = inst_60119);

(statearr_60210[(14)] = inst_60120__$1);

return statearr_60210;
})();
var statearr_60211_60309 = state_60199__$1;
(statearr_60211_60309[(2)] = null);

(statearr_60211_60309[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (21))){
var inst_60147 = (state_60199[(12)]);
var inst_60120 = (state_60199[(14)]);
var inst_60151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60152 = [inst_60147,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60153 = (new cljs.core.PersistentVector(null,2,(5),inst_60151,inst_60152,null));
var inst_60154 = cljs.core.assoc_in.call(null,inst_60120,inst_60153,inst_60147);
var state_60199__$1 = state_60199;
var statearr_60212_60310 = state_60199__$1;
(statearr_60212_60310[(2)] = inst_60154);

(statearr_60212_60310[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (31))){
var inst_60173 = (state_60199[(15)]);
var state_60199__$1 = state_60199;
var statearr_60213_60311 = state_60199__$1;
(statearr_60213_60311[(2)] = inst_60173);

(statearr_60213_60311[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (32))){
var inst_60127 = (state_60199[(9)]);
var inst_60181 = (state_60199[(2)]);
var inst_60119 = inst_60127;
var inst_60120 = inst_60181;
var state_60199__$1 = (function (){var statearr_60214 = state_60199;
(statearr_60214[(7)] = inst_60119);

(statearr_60214[(14)] = inst_60120);

return statearr_60214;
})();
var statearr_60215_60312 = state_60199__$1;
(statearr_60215_60312[(2)] = null);

(statearr_60215_60312[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (33))){
var inst_60120 = (state_60199[(14)]);
var state_60199__$1 = state_60199;
var statearr_60216_60313 = state_60199__$1;
(statearr_60216_60313[(2)] = inst_60120);

(statearr_60216_60313[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (13))){
var inst_60129 = (state_60199[(16)]);
var state_60199__$1 = state_60199;
var statearr_60217_60314 = state_60199__$1;
(statearr_60217_60314[(2)] = inst_60129);

(statearr_60217_60314[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (22))){
var inst_60120 = (state_60199[(14)]);
var state_60199__$1 = state_60199;
var statearr_60218_60315 = state_60199__$1;
(statearr_60218_60315[(2)] = inst_60120);

(statearr_60218_60315[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (29))){
var inst_60173 = (state_60199[(2)]);
var state_60199__$1 = (function (){var statearr_60219 = state_60199;
(statearr_60219[(15)] = inst_60173);

return statearr_60219;
})();
if(cljs.core.truth_(show_auth)){
var statearr_60220_60316 = state_60199__$1;
(statearr_60220_60316[(1)] = (30));

} else {
var statearr_60221_60317 = state_60199__$1;
(statearr_60221_60317[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (6))){
var inst_60105 = (state_60199[(2)]);
var inst_60106 = fluree.db.util.async.throw_err.call(null,inst_60105);
var inst_60114 = resp;
var inst_60115 = cljs.core.seq.call(null,inst_60114);
var inst_60116 = cljs.core.first.call(null,inst_60115);
var inst_60117 = cljs.core.next.call(null,inst_60115);
var inst_60118 = cljs.core.PersistentHashMap.EMPTY;
var inst_60119 = inst_60114;
var inst_60120 = inst_60118;
var state_60199__$1 = (function (){var statearr_60222 = state_60199;
(statearr_60222[(7)] = inst_60119);

(statearr_60222[(17)] = inst_60116);

(statearr_60222[(14)] = inst_60120);

(statearr_60222[(18)] = inst_60117);

(statearr_60222[(19)] = inst_60106);

return statearr_60222;
})();
var statearr_60223_60318 = state_60199__$1;
(statearr_60223_60318[(2)] = null);

(statearr_60223_60318[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (28))){
var inst_60165 = (state_60199[(10)]);
var state_60199__$1 = state_60199;
var statearr_60224_60319 = state_60199__$1;
(statearr_60224_60319[(2)] = inst_60165);

(statearr_60224_60319[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (25))){
var inst_60157 = (state_60199[(13)]);
var state_60199__$1 = state_60199;
var statearr_60225_60320 = state_60199__$1;
(statearr_60225_60320[(2)] = inst_60157);

(statearr_60225_60320[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (34))){
var state_60199__$1 = state_60199;
var statearr_60226_60321 = state_60199__$1;
(statearr_60226_60321[(2)] = null);

(statearr_60226_60321[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (17))){
var inst_60191 = (state_60199[(2)]);
var state_60199__$1 = state_60199;
var statearr_60227_60322 = state_60199__$1;
(statearr_60227_60322[(2)] = inst_60191);

(statearr_60227_60322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (3))){
var inst_60197 = (state_60199[(2)]);
var state_60199__$1 = state_60199;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60199__$1,inst_60197);
} else {
if((state_val_60200 === (12))){
var inst_60126 = (state_60199[(8)]);
var inst_60106 = (state_60199[(19)]);
var inst_60131 = fluree.db.api.query.auth_match.call(null,auth,inst_60106,inst_60126);
var inst_60132 = cljs.core.not.call(null,inst_60131);
var state_60199__$1 = state_60199;
var statearr_60228_60323 = state_60199__$1;
(statearr_60228_60323[(2)] = inst_60132);

(statearr_60228_60323[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (2))){
var _ = (function (){var statearr_60229 = state_60199;
(statearr_60229[(4)] = cljs.core.cons.call(null,(5),(state_60199[(4)])));

return statearr_60229;
})();
var inst_60011 = (function (){return (function (p1__60004_SHARP_){
return p1__60004_SHARP_.t;
});
})();
var inst_60012 = cljs.core.map.call(null,inst_60011,resp);
var inst_60013 = cljs.core.set.call(null,inst_60012);
var inst_60101 = cljs.core.async.chan.call(null,(1));
var inst_60102 = (function (){var ts = inst_60013;
var c__2768__auto____$1 = inst_60101;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_60099){
var state_val_60100 = (state_60099[(1)]);
if((state_val_60100 === (7))){
var inst_60039 = (state_60099[(7)]);
var inst_60027 = (state_60099[(8)]);
var inst_60045 = (state_60099[(9)]);
var inst_60033 = (state_60099[(10)]);
var inst_60038 = (state_60099[(2)]);
var inst_60039__$1 = fluree.db.util.async.throw_err.call(null,inst_60038);
var inst_60041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60042 = [inst_60033,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60043 = (new cljs.core.PersistentVector(null,2,(5),inst_60041,inst_60042,null));
var inst_60044 = cljs.core.assoc_in.call(null,inst_60027,inst_60043,inst_60039__$1);
var inst_60045__$1 = auth;
var state_60099__$1 = (function (){var statearr_60230 = state_60099;
(statearr_60230[(11)] = inst_60044);

(statearr_60230[(7)] = inst_60039__$1);

(statearr_60230[(9)] = inst_60045__$1);

return statearr_60230;
})();
if(cljs.core.truth_(inst_60045__$1)){
var statearr_60231_60324 = state_60099__$1;
(statearr_60231_60324[(1)] = (8));

} else {
var statearr_60232_60325 = state_60099__$1;
(statearr_60232_60325[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60100 === (1))){
var inst_60021 = (state_60099[(12)]);
var inst_60021__$1 = ts;
var inst_60022 = cljs.core.seq.call(null,inst_60021__$1);
var inst_60023 = cljs.core.first.call(null,inst_60022);
var inst_60024 = cljs.core.next.call(null,inst_60022);
var inst_60025 = cljs.core.PersistentHashMap.EMPTY;
var inst_60026 = inst_60021__$1;
var inst_60027 = inst_60025;
var state_60099__$1 = (function (){var statearr_60233 = state_60099;
(statearr_60233[(12)] = inst_60021__$1);

(statearr_60233[(13)] = inst_60026);

(statearr_60233[(8)] = inst_60027);

(statearr_60233[(14)] = inst_60024);

(statearr_60233[(15)] = inst_60023);

return statearr_60233;
})();
var statearr_60234_60326 = state_60099__$1;
(statearr_60234_60326[(2)] = null);

(statearr_60234_60326[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60100 === (4))){
var inst_60033 = (state_60099[(10)]);
var inst_60036 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_60033);
var state_60099__$1 = state_60099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60099__$1,(7),inst_60036);
} else {
if((state_val_60100 === (13))){
var inst_60034 = (state_60099[(16)]);
var inst_60091 = (state_60099[(2)]);
var inst_60026 = inst_60034;
var inst_60027 = inst_60091;
var state_60099__$1 = (function (){var statearr_60235 = state_60099;
(statearr_60235[(13)] = inst_60026);

(statearr_60235[(8)] = inst_60027);

return statearr_60235;
})();
var statearr_60236_60327 = state_60099__$1;
(statearr_60236_60327[(2)] = null);

(statearr_60236_60327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60100 === (6))){
var inst_60095 = (state_60099[(2)]);
var state_60099__$1 = state_60099;
var statearr_60237_60328 = state_60099__$1;
(statearr_60237_60328[(2)] = inst_60095);

(statearr_60237_60328[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60100 === (3))){
var inst_60097 = (state_60099[(2)]);
var state_60099__$1 = state_60099;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60099__$1,inst_60097);
} else {
if((state_val_60100 === (12))){
var inst_60044 = (state_60099[(11)]);
var state_60099__$1 = state_60099;
var statearr_60238_60329 = state_60099__$1;
(statearr_60238_60329[(2)] = inst_60044);

(statearr_60238_60329[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60100 === (2))){
var inst_60026 = (state_60099[(13)]);
var inst_60033 = (state_60099[(10)]);
var inst_60032 = cljs.core.seq.call(null,inst_60026);
var inst_60033__$1 = cljs.core.first.call(null,inst_60032);
var inst_60034 = cljs.core.next.call(null,inst_60032);
var state_60099__$1 = (function (){var statearr_60239 = state_60099;
(statearr_60239[(16)] = inst_60034);

(statearr_60239[(10)] = inst_60033__$1);

return statearr_60239;
})();
if(cljs.core.truth_(inst_60033__$1)){
var statearr_60240_60330 = state_60099__$1;
(statearr_60240_60330[(1)] = (4));

} else {
var statearr_60241_60331 = state_60099__$1;
(statearr_60241_60331[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60100 === (11))){
var inst_60044 = (state_60099[(11)]);
var inst_60039 = (state_60099[(7)]);
var inst_60021 = (state_60099[(12)]);
var inst_60026 = (state_60099[(13)]);
var inst_60027 = (state_60099[(8)]);
var inst_60034 = (state_60099[(16)]);
var inst_60024 = (state_60099[(14)]);
var inst_60033 = (state_60099[(10)]);
var inst_60023 = (state_60099[(15)]);
var inst_60051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60052 = [inst_60033,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_60053 = (new cljs.core.PersistentVector(null,2,(5),inst_60051,inst_60052,null));
var inst_60066 = cljs.core.async.chan.call(null,(1));
var inst_60067 = (function (){var t = inst_60033;
var G__60017 = inst_60026;
var seq__60019 = inst_60024;
var first__60020 = inst_60023;
var block = inst_60039;
var r = inst_60034;
var acc = inst_60027;
var seq__60030 = inst_60034;
var G__60040 = inst_60044;
var vec__60018 = inst_60021;
var c__2768__auto____$2 = inst_60066;
var first__60031 = inst_60033;
var vec__60029 = inst_60026;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_60064){
var state_val_60065 = (state_60064[(1)]);
if((state_val_60065 === (1))){
var state_60064__$1 = state_60064;
var statearr_60242_60332 = state_60064__$1;
(statearr_60242_60332[(2)] = null);

(statearr_60242_60332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60065 === (2))){
var ___$1 = (function (){var statearr_60243 = state_60064;
(statearr_60243[(4)] = cljs.core.cons.call(null,(5),(state_60064[(4)])));

return statearr_60243;
})();
var ___$2 = (function (){var statearr_60244 = state_60064;
(statearr_60244[(4)] = cljs.core.rest.call(null,(state_60064[(4)])));

return statearr_60244;
})();
var state_60064__$1 = state_60064;
var statearr_60245_60333 = state_60064__$1;
(statearr_60245_60333[(2)] = db);

(statearr_60245_60333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60065 === (3))){
var inst_60062 = (state_60064[(2)]);
var state_60064__$1 = state_60064;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60064__$1,inst_60062);
} else {
if((state_val_60065 === (4))){
var inst_60054 = (state_60064[(2)]);
var state_60064__$1 = state_60064;
var statearr_60247_60334 = state_60064__$1;
(statearr_60247_60334[(2)] = inst_60054);

(statearr_60247_60334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60065 === (5))){
var ___$1 = (function (){var statearr_60248 = state_60064;
(statearr_60248[(4)] = cljs.core.rest.call(null,(state_60064[(4)])));

return statearr_60248;
})();
var state_60064__$1 = state_60064;
var ex60246 = (state_60064__$1[(2)]);
var statearr_60249_60335 = state_60064__$1;
(statearr_60249_60335[(5)] = ex60246);


if((ex60246 instanceof Error)){
var statearr_60250_60336 = state_60064__$1;
(statearr_60250_60336[(1)] = (4));

(statearr_60250_60336[(5)] = null);

} else {
throw ex60246;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_60251 = [null,null,null,null,null,null,null];
(statearr_60251[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_60251[(1)] = (1));

return statearr_60251;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_60064){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_60064);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e60252){var ex__2749__auto__ = e60252;
var statearr_60253_60337 = state_60064;
(statearr_60253_60337[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_60064[(4)]))){
var statearr_60254_60338 = state_60064;
(statearr_60254_60338[(1)] = cljs.core.first.call(null,(state_60064[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60339 = state_60064;
state_60064 = G__60339;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_60064){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_60064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_60255 = f__2769__auto__.call(null);
(statearr_60255[(6)] = c__2768__auto____$2);

return statearr_60255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_60068 = cljs.core.async.impl.dispatch.run.call(null,inst_60067);
var inst_60069 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_60070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60071 = ["?auth","?id"];
var inst_60072 = (new cljs.core.PersistentVector(null,2,(5),inst_60070,inst_60071,null));
var inst_60073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60075 = [inst_60033,"_tx/auth","?auth"];
var inst_60076 = (new cljs.core.PersistentVector(null,3,(5),inst_60074,inst_60075,null));
var inst_60077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60078 = ["?auth","_auth/id","?id"];
var inst_60079 = (new cljs.core.PersistentVector(null,3,(5),inst_60077,inst_60078,null));
var inst_60080 = [inst_60076,inst_60079];
var inst_60081 = (new cljs.core.PersistentVector(null,2,(5),inst_60073,inst_60080,null));
var inst_60082 = [inst_60072,inst_60081];
var inst_60083 = cljs.core.PersistentHashMap.fromArrays(inst_60069,inst_60082);
var inst_60084 = fluree.db.api.query.query_async.call(null,inst_60066,inst_60083);
var state_60099__$1 = (function (){var statearr_60256 = state_60099;
(statearr_60256[(17)] = inst_60053);

(statearr_60256[(18)] = inst_60068);

return statearr_60256;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60099__$1,(14),inst_60084);
} else {
if((state_val_60100 === (9))){
var state_60099__$1 = state_60099;
var statearr_60257_60340 = state_60099__$1;
(statearr_60257_60340[(2)] = show_auth);

(statearr_60257_60340[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60100 === (5))){
var inst_60027 = (state_60099[(8)]);
var state_60099__$1 = state_60099;
var statearr_60258_60341 = state_60099__$1;
(statearr_60258_60341[(2)] = inst_60027);

(statearr_60258_60341[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60100 === (14))){
var inst_60044 = (state_60099[(11)]);
var inst_60053 = (state_60099[(17)]);
var inst_60086 = (state_60099[(2)]);
var inst_60087 = fluree.db.util.async.throw_err.call(null,inst_60086);
var inst_60088 = cljs.core.assoc_in.call(null,inst_60044,inst_60053,inst_60087);
var state_60099__$1 = state_60099;
var statearr_60259_60342 = state_60099__$1;
(statearr_60259_60342[(2)] = inst_60088);

(statearr_60259_60342[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60100 === (10))){
var inst_60049 = (state_60099[(2)]);
var state_60099__$1 = state_60099;
if(cljs.core.truth_(inst_60049)){
var statearr_60260_60343 = state_60099__$1;
(statearr_60260_60343[(1)] = (11));

} else {
var statearr_60261_60344 = state_60099__$1;
(statearr_60261_60344[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60100 === (8))){
var inst_60045 = (state_60099[(9)]);
var state_60099__$1 = state_60099;
var statearr_60262_60345 = state_60099__$1;
(statearr_60262_60345[(2)] = inst_60045);

(statearr_60262_60345[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_60263 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60263[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_60263[(1)] = (1));

return statearr_60263;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_60099){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_60099);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e60264){var ex__2749__auto__ = e60264;
var statearr_60265_60346 = state_60099;
(statearr_60265_60346[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_60099[(4)]))){
var statearr_60266_60347 = state_60099;
(statearr_60266_60347[(1)] = cljs.core.first.call(null,(state_60099[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60348 = state_60099;
state_60099 = G__60348;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_60099){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_60099);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_60267 = f__2769__auto__.call(null);
(statearr_60267[(6)] = c__2768__auto____$1);

return statearr_60267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_60103 = cljs.core.async.impl.dispatch.run.call(null,inst_60102);
var state_60199__$1 = (function (){var statearr_60268 = state_60199;
(statearr_60268[(20)] = inst_60103);

return statearr_60268;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60199__$1,(6),inst_60101);
} else {
if((state_val_60200 === (23))){
var inst_60157 = (state_60199[(2)]);
var state_60199__$1 = (function (){var statearr_60269 = state_60199;
(statearr_60269[(13)] = inst_60157);

return statearr_60269;
})();
var statearr_60270_60349 = state_60199__$1;
(statearr_60270_60349[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (35))){
var inst_60187 = (state_60199[(2)]);
var state_60199__$1 = state_60199;
var statearr_60272_60350 = state_60199__$1;
(statearr_60272_60350[(2)] = inst_60187);

(statearr_60272_60350[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (19))){
var state_60199__$1 = state_60199;
var statearr_60273_60351 = state_60199__$1;
(statearr_60273_60351[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (11))){
var inst_60138 = (state_60199[(2)]);
var state_60199__$1 = state_60199;
if(cljs.core.truth_(inst_60138)){
var statearr_60276_60352 = state_60199__$1;
(statearr_60276_60352[(1)] = (15));

} else {
var statearr_60277_60353 = state_60199__$1;
(statearr_60277_60353[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (9))){
var inst_60129 = (state_60199[(16)]);
var inst_60129__$1 = auth;
var state_60199__$1 = (function (){var statearr_60278 = state_60199;
(statearr_60278[(16)] = inst_60129__$1);

return statearr_60278;
})();
if(cljs.core.truth_(inst_60129__$1)){
var statearr_60279_60354 = state_60199__$1;
(statearr_60279_60354[(1)] = (12));

} else {
var statearr_60280_60355 = state_60199__$1;
(statearr_60280_60355[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (5))){
var _ = (function (){var statearr_60281 = state_60199;
(statearr_60281[(4)] = cljs.core.rest.call(null,(state_60199[(4)])));

return statearr_60281;
})();
var state_60199__$1 = state_60199;
var ex60275 = (state_60199__$1[(2)]);
var statearr_60282_60356 = state_60199__$1;
(statearr_60282_60356[(5)] = ex60275);


if((ex60275 instanceof Error)){
var statearr_60283_60357 = state_60199__$1;
(statearr_60283_60357[(1)] = (4));

(statearr_60283_60357[(5)] = null);

} else {
throw ex60275;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (14))){
var inst_60135 = (state_60199[(2)]);
var state_60199__$1 = state_60199;
var statearr_60284_60358 = state_60199__$1;
(statearr_60284_60358[(2)] = inst_60135);

(statearr_60284_60358[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (26))){
var inst_60165 = (state_60199[(2)]);
var state_60199__$1 = (function (){var statearr_60285 = state_60199;
(statearr_60285[(10)] = inst_60165);

return statearr_60285;
})();
var statearr_60286_60359 = state_60199__$1;
(statearr_60286_60359[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (16))){
var inst_60126 = (state_60199[(8)]);
var state_60199__$1 = state_60199;
if(cljs.core.truth_(inst_60126)){
var statearr_60288_60360 = state_60199__$1;
(statearr_60288_60360[(1)] = (18));

} else {
var statearr_60289_60361 = state_60199__$1;
(statearr_60289_60361[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (30))){
var inst_60147 = (state_60199[(12)]);
var inst_60173 = (state_60199[(15)]);
var inst_60148 = (state_60199[(21)]);
var inst_60175 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60176 = [inst_60147,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_60177 = (new cljs.core.PersistentVector(null,2,(5),inst_60175,inst_60176,null));
var inst_60178 = cljs.core.assoc_in.call(null,inst_60173,inst_60177,inst_60148);
var state_60199__$1 = state_60199;
var statearr_60290_60362 = state_60199__$1;
(statearr_60290_60362[(2)] = inst_60178);

(statearr_60290_60362[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (10))){
var inst_60126 = (state_60199[(8)]);
var state_60199__$1 = state_60199;
var statearr_60291_60363 = state_60199__$1;
(statearr_60291_60363[(2)] = inst_60126);

(statearr_60291_60363[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (18))){
var inst_60144 = (state_60199[(11)]);
var inst_60126 = (state_60199[(8)]);
var inst_60106 = (state_60199[(19)]);
var inst_60144__$1 = inst_60126.t;
var inst_60145 = cljs.core.get.call(null,inst_60106,inst_60144__$1);
var inst_60146 = cljs.core.__destructure_map.call(null,inst_60145);
var inst_60147 = cljs.core.get.call(null,inst_60146,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60148 = cljs.core.get.call(null,inst_60146,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_60199__$1 = (function (){var statearr_60292 = state_60199;
(statearr_60292[(11)] = inst_60144__$1);

(statearr_60292[(12)] = inst_60147);

(statearr_60292[(21)] = inst_60148);

return statearr_60292;
})();
var statearr_60293_60364 = state_60199__$1;
(statearr_60293_60364[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60200 === (8))){
var inst_60193 = (state_60199[(2)]);
var inst_60194 = cljs.core.vals.call(null,inst_60193);
var _ = (function (){var statearr_60295 = state_60199;
(statearr_60295[(4)] = cljs.core.rest.call(null,(state_60199[(4)])));

return statearr_60295;
})();
var state_60199__$1 = state_60199;
var statearr_60296_60365 = state_60199__$1;
(statearr_60296_60365[(2)] = inst_60194);

(statearr_60296_60365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_60297 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60297[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_60297[(1)] = (1));

return statearr_60297;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_60199){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_60199);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e60298){var ex__2749__auto__ = e60298;
var statearr_60299_60366 = state_60199;
(statearr_60299_60366[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_60199[(4)]))){
var statearr_60300_60367 = state_60199;
(statearr_60300_60367[(1)] = cljs.core.first.call(null,(state_60199[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60368 = state_60199;
state_60199 = G__60368;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_60199){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_60199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_60301 = f__2769__auto__.call(null);
(statearr_60301[(6)] = c__2768__auto__);

return statearr_60301;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.call(null,(function (block){
return cljs.core.assoc.call(null,block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.call(null,cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_60495){
var state_val_60496 = (state_60495[(1)]);
if((state_val_60496 === (7))){
var inst_60391 = (state_60495[(7)]);
var inst_60393 = fluree.db.api.query.resolve_block_range.call(null,inst_60391,query_map);
var state_60495__$1 = state_60495;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60495__$1,(10),inst_60393);
} else {
if((state_val_60496 === (20))){
var inst_60420 = (state_60495[(2)]);
var inst_60421 = fluree.db.util.async.throw_err.call(null,inst_60420);
var inst_60422 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60421);
var inst_60423 = (inst_60422 - (1));
var state_60495__$1 = state_60495;
var statearr_60497_60560 = state_60495__$1;
(statearr_60497_60560[(2)] = inst_60423);

(statearr_60497_60560[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (27))){
var state_60495__$1 = state_60495;
var statearr_60498_60561 = state_60495__$1;
(statearr_60498_60561[(2)] = null);

(statearr_60498_60561[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (1))){
var state_60495__$1 = state_60495;
var statearr_60499_60562 = state_60495__$1;
(statearr_60499_60562[(2)] = null);

(statearr_60499_60562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (24))){
var inst_60430 = (state_60495[(2)]);
var inst_60431 = fluree.db.util.async.throw_err.call(null,inst_60430);
var inst_60432 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60431);
var state_60495__$1 = state_60495;
var statearr_60500_60563 = state_60495__$1;
(statearr_60500_60563[(2)] = inst_60432);

(statearr_60500_60563[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (39))){
var inst_60467 = (state_60495[(2)]);
var inst_60468 = fluree.db.util.async.throw_err.call(null,inst_60467);
var state_60495__$1 = state_60495;
var statearr_60501_60564 = state_60495__$1;
(statearr_60501_60564[(2)] = inst_60468);

(statearr_60501_60564[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (4))){
var inst_60369 = (state_60495[(2)]);
var state_60495__$1 = state_60495;
var statearr_60502_60565 = state_60495__$1;
(statearr_60502_60565[(2)] = inst_60369);

(statearr_60502_60565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (15))){
var inst_60400 = (state_60495[(8)]);
var state_60495__$1 = state_60495;
var statearr_60503_60566 = state_60495__$1;
(statearr_60503_60566[(2)] = inst_60400);

(statearr_60503_60566[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (21))){
var inst_60391 = (state_60495[(7)]);
var inst_60401 = (state_60495[(9)]);
var inst_60428 = fluree.db.time_travel.as_of_block.call(null,inst_60391,inst_60401);
var state_60495__$1 = state_60495;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60495__$1,(24),inst_60428);
} else {
if((state_val_60496 === (31))){
var inst_60385 = (state_60495[(10)]);
var state_60495__$1 = state_60495;
var statearr_60504_60567 = state_60495__$1;
(statearr_60504_60567[(2)] = inst_60385);

(statearr_60504_60567[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (32))){
var inst_60391 = (state_60495[(7)]);
var inst_60451 = (state_60495[(11)]);
var inst_60446 = (state_60495[(12)]);
var inst_60455 = (state_60495[(2)]);
var inst_60456 = fluree.db.api.query.format_history_resp.call(null,inst_60391,inst_60446,inst_60451,inst_60455);
var state_60495__$1 = state_60495;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60495__$1,(29),inst_60456);
} else {
if((state_val_60496 === (40))){
var inst_60472 = (state_60495[(13)]);
var inst_60446 = (state_60495[(12)]);
var inst_60474 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_60475 = cljs.core.count.call(null,inst_60446);
var inst_60476 = [inst_60472,inst_60475,(200)];
var inst_60477 = cljs.core.PersistentHashMap.fromArrays(inst_60474,inst_60476);
var state_60495__$1 = state_60495;
var statearr_60505_60568 = state_60495__$1;
(statearr_60505_60568[(2)] = inst_60477);

(statearr_60505_60568[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (33))){
var inst_60384 = (state_60495[(14)]);
var state_60495__$1 = state_60495;
var statearr_60506_60569 = state_60495__$1;
(statearr_60506_60569[(2)] = inst_60384);

(statearr_60506_60569[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (13))){
var inst_60490 = (state_60495[(2)]);
var _ = (function (){var statearr_60507 = state_60495;
(statearr_60507[(4)] = cljs.core.rest.call(null,(state_60495[(4)])));

return statearr_60507;
})();
var state_60495__$1 = state_60495;
var statearr_60508_60570 = state_60495__$1;
(statearr_60508_60570[(2)] = inst_60490);

(statearr_60508_60570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (22))){
var inst_60391 = (state_60495[(7)]);
var inst_60434 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60391);
var state_60495__$1 = state_60495;
var statearr_60509_60571 = state_60495__$1;
(statearr_60509_60571[(2)] = inst_60434);

(statearr_60509_60571[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (36))){
var inst_60391 = (state_60495[(7)]);
var inst_60459 = (state_60495[(15)]);
var inst_60465 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_60391,inst_60459);
var state_60495__$1 = state_60495;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60495__$1,(39),inst_60465);
} else {
if((state_val_60496 === (41))){
var inst_60472 = (state_60495[(13)]);
var state_60495__$1 = state_60495;
var statearr_60510_60572 = state_60495__$1;
(statearr_60510_60572[(2)] = inst_60472);

(statearr_60510_60572[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (29))){
var inst_60384 = (state_60495[(14)]);
var inst_60458 = (state_60495[(2)]);
var inst_60459 = fluree.db.util.async.throw_err.call(null,inst_60458);
var state_60495__$1 = (function (){var statearr_60511 = state_60495;
(statearr_60511[(15)] = inst_60459);

return statearr_60511;
})();
if(cljs.core.truth_(inst_60384)){
var statearr_60512_60573 = state_60495__$1;
(statearr_60512_60573[(1)] = (33));

} else {
var statearr_60513_60574 = state_60495__$1;
(statearr_60513_60574[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (6))){
var inst_60381 = (state_60495[(16)]);
var inst_60390 = (state_60495[(2)]);
var inst_60391 = fluree.db.util.async.throw_err.call(null,inst_60390);
var state_60495__$1 = (function (){var statearr_60514 = state_60495;
(statearr_60514[(7)] = inst_60391);

return statearr_60514;
})();
if(cljs.core.truth_(inst_60381)){
var statearr_60515_60575 = state_60495__$1;
(statearr_60515_60575[(1)] = (7));

} else {
var statearr_60516_60576 = state_60495__$1;
(statearr_60516_60576[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (28))){
var inst_60386 = (state_60495[(17)]);
var inst_60451 = (state_60495[(2)]);
var state_60495__$1 = (function (){var statearr_60517 = state_60495;
(statearr_60517[(11)] = inst_60451);

return statearr_60517;
})();
if(cljs.core.truth_(inst_60386)){
var statearr_60518_60577 = state_60495__$1;
(statearr_60518_60577[(1)] = (30));

} else {
var statearr_60519_60578 = state_60495__$1;
(statearr_60519_60578[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (25))){
var inst_60387 = (state_60495[(18)]);
var inst_60445 = (state_60495[(2)]);
var inst_60446 = fluree.db.util.async.throw_err.call(null,inst_60445);
var state_60495__$1 = (function (){var statearr_60520 = state_60495;
(statearr_60520[(12)] = inst_60446);

return statearr_60520;
})();
if(cljs.core.truth_(inst_60387)){
var statearr_60521_60579 = state_60495__$1;
(statearr_60521_60579[(1)] = (26));

} else {
var statearr_60522_60580 = state_60495__$1;
(statearr_60522_60580[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (34))){
var inst_60383 = (state_60495[(19)]);
var state_60495__$1 = state_60495;
var statearr_60523_60581 = state_60495__$1;
(statearr_60523_60581[(2)] = inst_60383);

(statearr_60523_60581[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (17))){
var inst_60391 = (state_60495[(7)]);
var inst_60400 = (state_60495[(8)]);
var inst_60417 = (inst_60400 - (1));
var inst_60418 = fluree.db.time_travel.as_of_block.call(null,inst_60391,inst_60417);
var state_60495__$1 = state_60495;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60495__$1,(20),inst_60418);
} else {
if((state_val_60496 === (3))){
var inst_60493 = (state_60495[(2)]);
var state_60495__$1 = state_60495;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60495__$1,inst_60493);
} else {
if((state_val_60496 === (12))){
var inst_60482 = cljs.core.pr_str.call(null,query_map);
var inst_60483 = ["History query not properly formatted. Provided ",inst_60482].join('');
var inst_60484 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60485 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60486 = cljs.core.PersistentHashMap.fromArrays(inst_60484,inst_60485);
var inst_60487 = cljs.core.ex_info.call(null,inst_60483,inst_60486);
var inst_60488 = (function(){throw inst_60487})();
var state_60495__$1 = state_60495;
var statearr_60524_60582 = state_60495__$1;
(statearr_60524_60582[(2)] = inst_60488);

(statearr_60524_60582[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (2))){
var _ = (function (){var statearr_60525 = state_60495;
(statearr_60525[(4)] = cljs.core.cons.call(null,(5),(state_60495[(4)])));

return statearr_60525;
})();
var inst_60379 = query_map;
var inst_60380 = cljs.core.__destructure_map.call(null,inst_60379);
var inst_60381 = cljs.core.get.call(null,inst_60380,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60382 = cljs.core.get.call(null,inst_60380,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_60383 = cljs.core.get.call(null,inst_60380,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_60384 = cljs.core.get.call(null,inst_60380,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_60385 = cljs.core.get.call(null,inst_60380,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_60386 = cljs.core.get.call(null,inst_60380,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_60387 = cljs.core.get.call(null,inst_60380,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_60388 = cljs.core.get.call(null,inst_60380,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_60495__$1 = (function (){var statearr_60526 = state_60495;
(statearr_60526[(20)] = inst_60382);

(statearr_60526[(18)] = inst_60387);

(statearr_60526[(10)] = inst_60385);

(statearr_60526[(17)] = inst_60386);

(statearr_60526[(16)] = inst_60381);

(statearr_60526[(14)] = inst_60384);

(statearr_60526[(19)] = inst_60383);

(statearr_60526[(21)] = inst_60388);

return statearr_60526;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60495__$1,(6),sources);
} else {
if((state_val_60496 === (23))){
var inst_60391 = (state_60495[(7)]);
var inst_60382 = (state_60495[(20)]);
var inst_60426 = (state_60495[(22)]);
var inst_60436 = (state_60495[(2)]);
var inst_60437 = fluree.db.api.query.get_history_pattern.call(null,inst_60382);
var inst_60438 = cljs.core.nth.call(null,inst_60437,(0),null);
var inst_60439 = cljs.core.nth.call(null,inst_60437,(1),null);
var inst_60440 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_60441 = [inst_60426,inst_60436];
var inst_60442 = cljs.core.PersistentHashMap.fromArrays(inst_60440,inst_60441);
var inst_60443 = fluree.db.query.range.time_range.call(null,inst_60391,inst_60439,cljs.core._EQ_,inst_60438,inst_60442);
var state_60495__$1 = state_60495;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60495__$1,(25),inst_60443);
} else {
if((state_val_60496 === (35))){
var inst_60463 = (state_60495[(2)]);
var state_60495__$1 = state_60495;
if(cljs.core.truth_(inst_60463)){
var statearr_60527_60583 = state_60495__$1;
(statearr_60527_60583[(1)] = (36));

} else {
var statearr_60528_60584 = state_60495__$1;
(statearr_60528_60584[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (19))){
var inst_60401 = (state_60495[(9)]);
var inst_60426 = (state_60495[(2)]);
var state_60495__$1 = (function (){var statearr_60529 = state_60495;
(statearr_60529[(22)] = inst_60426);

return statearr_60529;
})();
if(cljs.core.truth_(inst_60401)){
var statearr_60530_60585 = state_60495__$1;
(statearr_60530_60585[(1)] = (21));

} else {
var statearr_60531_60586 = state_60495__$1;
(statearr_60531_60586[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (11))){
var inst_60400 = (state_60495[(8)]);
var inst_60388 = (state_60495[(21)]);
var inst_60410 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_60388);
var state_60495__$1 = (function (){var statearr_60533 = state_60495;
(statearr_60533[(23)] = inst_60410);

return statearr_60533;
})();
if(cljs.core.truth_(inst_60400)){
var statearr_60534_60587 = state_60495__$1;
(statearr_60534_60587[(1)] = (14));

} else {
var statearr_60535_60588 = state_60495__$1;
(statearr_60535_60588[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (9))){
var inst_60399 = (state_60495[(2)]);
var inst_60400 = cljs.core.nth.call(null,inst_60399,(0),null);
var inst_60401 = cljs.core.nth.call(null,inst_60399,(1),null);
var inst_60402 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_60403 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60404 = cljs.core.keys.call(null,inst_60403);
var inst_60405 = cljs.core._EQ_.call(null,inst_60402,inst_60404);
var state_60495__$1 = (function (){var statearr_60536 = state_60495;
(statearr_60536[(9)] = inst_60401);

(statearr_60536[(8)] = inst_60400);

return statearr_60536;
})();
if(inst_60405){
var statearr_60537_60589 = state_60495__$1;
(statearr_60537_60589[(1)] = (11));

} else {
var statearr_60538_60590 = state_60495__$1;
(statearr_60538_60590[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (5))){
var _ = (function (){var statearr_60539 = state_60495;
(statearr_60539[(4)] = cljs.core.rest.call(null,(state_60495[(4)])));

return statearr_60539;
})();
var state_60495__$1 = state_60495;
var ex60532 = (state_60495__$1[(2)]);
var statearr_60540_60591 = state_60495__$1;
(statearr_60540_60591[(5)] = ex60532);


if((ex60532 instanceof Error)){
var statearr_60541_60592 = state_60495__$1;
(statearr_60541_60592[(1)] = (4));

(statearr_60541_60592[(5)] = null);

} else {
throw ex60532;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (14))){
var inst_60400 = (state_60495[(8)]);
var inst_60412 = cljs.core.not_EQ_.call(null,(1),inst_60400);
var state_60495__$1 = state_60495;
var statearr_60542_60593 = state_60495__$1;
(statearr_60542_60593[(2)] = inst_60412);

(statearr_60542_60593[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (26))){
var inst_60387 = (state_60495[(18)]);
var inst_60448 = cljs.core.set.call(null,inst_60387);
var state_60495__$1 = state_60495;
var statearr_60543_60594 = state_60495__$1;
(statearr_60543_60594[(2)] = inst_60448);

(statearr_60543_60594[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (16))){
var inst_60415 = (state_60495[(2)]);
var state_60495__$1 = state_60495;
if(cljs.core.truth_(inst_60415)){
var statearr_60544_60595 = state_60495__$1;
(statearr_60544_60595[(1)] = (17));

} else {
var statearr_60545_60596 = state_60495__$1;
(statearr_60545_60596[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (38))){
var inst_60410 = (state_60495[(23)]);
var inst_60472 = (state_60495[(2)]);
var state_60495__$1 = (function (){var statearr_60546 = state_60495;
(statearr_60546[(13)] = inst_60472);

return statearr_60546;
})();
if(cljs.core.truth_(inst_60410)){
var statearr_60547_60597 = state_60495__$1;
(statearr_60547_60597[(1)] = (40));

} else {
var statearr_60548_60598 = state_60495__$1;
(statearr_60548_60598[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (30))){
var inst_60386 = (state_60495[(17)]);
var state_60495__$1 = state_60495;
var statearr_60549_60599 = state_60495__$1;
(statearr_60549_60599[(2)] = inst_60386);

(statearr_60549_60599[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (10))){
var inst_60395 = (state_60495[(2)]);
var inst_60396 = fluree.db.util.async.throw_err.call(null,inst_60395);
var state_60495__$1 = state_60495;
var statearr_60550_60600 = state_60495__$1;
(statearr_60550_60600[(2)] = inst_60396);

(statearr_60550_60600[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (18))){
var state_60495__$1 = state_60495;
var statearr_60551_60601 = state_60495__$1;
(statearr_60551_60601[(2)] = (-1));

(statearr_60551_60601[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (42))){
var inst_60480 = (state_60495[(2)]);
var state_60495__$1 = state_60495;
var statearr_60552_60602 = state_60495__$1;
(statearr_60552_60602[(2)] = inst_60480);

(statearr_60552_60602[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (37))){
var inst_60459 = (state_60495[(15)]);
var inst_60470 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_60459);
var state_60495__$1 = state_60495;
var statearr_60553_60603 = state_60495__$1;
(statearr_60553_60603[(2)] = inst_60470);

(statearr_60553_60603[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (8))){
var state_60495__$1 = state_60495;
var statearr_60554_60604 = state_60495__$1;
(statearr_60554_60604[(2)] = null);

(statearr_60554_60604[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_60555 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60555[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2746__auto__);

(statearr_60555[(1)] = (1));

return statearr_60555;
});
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1 = (function (state_60495){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_60495);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e60556){var ex__2749__auto__ = e60556;
var statearr_60557_60605 = state_60495;
(statearr_60557_60605[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_60495[(4)]))){
var statearr_60558_60606 = state_60495;
(statearr_60558_60606[(1)] = cljs.core.first.call(null,(state_60495[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60607 = state_60495;
state_60495 = G__60607;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__ = function(state_60495){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1.call(this,state_60495);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_60559 = f__2769__auto__.call(null);
(statearr_60559[(6)] = c__2768__auto__);

return statearr_60559;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_60740){
var state_val_60741 = (state_60740[(1)]);
if((state_val_60741 === (7))){
var inst_60637 = cljs.core.pr_str.call(null,flureeQL);
var inst_60638 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_60637].join('');
var inst_60639 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60640 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60641 = cljs.core.PersistentHashMap.fromArrays(inst_60639,inst_60640);
var inst_60642 = cljs.core.ex_info.call(null,inst_60638,inst_60641);
var inst_60643 = (function(){throw inst_60642})();
var state_60740__$1 = state_60740;
var statearr_60742_60821 = state_60740__$1;
(statearr_60742_60821[(2)] = inst_60643);

(statearr_60742_60821[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (20))){
var inst_60675 = (state_60740[(2)]);
var state_60740__$1 = state_60740;
if(cljs.core.truth_(inst_60675)){
var statearr_60743_60822 = state_60740__$1;
(statearr_60743_60822[(1)] = (21));

} else {
var statearr_60744_60823 = state_60740__$1;
(statearr_60744_60823[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (27))){
var inst_60619 = (state_60740[(7)]);
var state_60740__$1 = state_60740;
var statearr_60745_60824 = state_60740__$1;
(statearr_60745_60824[(2)] = inst_60619);

(statearr_60745_60824[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (1))){
var state_60740__$1 = state_60740;
var statearr_60746_60825 = state_60740__$1;
(statearr_60746_60825[(2)] = null);

(statearr_60746_60825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (24))){
var inst_60681 = (state_60740[(8)]);
var state_60740__$1 = state_60740;
var statearr_60747_60826 = state_60740__$1;
(statearr_60747_60826[(2)] = inst_60681);

(statearr_60747_60826[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (39))){
var inst_60625 = (state_60740[(9)]);
var state_60740__$1 = state_60740;
if(cljs.core.truth_(inst_60625)){
var statearr_60748_60827 = state_60740__$1;
(statearr_60748_60827[(1)] = (42));

} else {
var statearr_60749_60828 = state_60740__$1;
(statearr_60749_60828[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (46))){
var inst_60713 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60714 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60715 = cljs.core.PersistentHashMap.fromArrays(inst_60713,inst_60714);
var inst_60716 = cljs.core.ex_info.call(null,"Invalid query.",inst_60715);
var inst_60717 = (function(){throw inst_60716})();
var state_60740__$1 = state_60740;
var statearr_60750_60829 = state_60740__$1;
(statearr_60750_60829[(2)] = inst_60717);

(statearr_60750_60829[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (4))){
var inst_60609 = (state_60740[(2)]);
var state_60740__$1 = state_60740;
var statearr_60751_60830 = state_60740__$1;
(statearr_60751_60830[(2)] = inst_60609);

(statearr_60751_60830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (15))){
var inst_60660 = (state_60740[(10)]);
var inst_60622 = (state_60740[(11)]);
var inst_60662 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_60660);
var inst_60663 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_60660);
var inst_60664 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_60660);
var inst_60665 = fluree.db.api.query.get_sources.call(null,inst_60662,inst_60663,inst_60664,inst_60622);
var state_60740__$1 = state_60740;
var statearr_60752_60831 = state_60740__$1;
(statearr_60752_60831[(2)] = inst_60665);

(statearr_60752_60831[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (48))){
var inst_60670 = (state_60740[(12)]);
var inst_60724 = (state_60740[(2)]);
var inst_60725 = fluree.db.util.async.throw_err.call(null,inst_60724);
var state_60740__$1 = (function (){var statearr_60753 = state_60740;
(statearr_60753[(13)] = inst_60725);

return statearr_60753;
})();
if(cljs.core.truth_(inst_60670)){
var statearr_60754_60832 = state_60740__$1;
(statearr_60754_60832[(1)] = (49));

} else {
var statearr_60755_60833 = state_60740__$1;
(statearr_60755_60833[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (50))){
var inst_60725 = (state_60740[(13)]);
var state_60740__$1 = state_60740;
var statearr_60756_60834 = state_60740__$1;
(statearr_60756_60834[(2)] = inst_60725);

(statearr_60756_60834[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (21))){
var inst_60677 = cljs.core.volatile_BANG_.call(null,(0));
var state_60740__$1 = state_60740;
var statearr_60757_60835 = state_60740__$1;
(statearr_60757_60835[(2)] = inst_60677);

(statearr_60757_60835[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (31))){
var inst_60623 = (state_60740[(14)]);
var state_60740__$1 = state_60740;
if(cljs.core.truth_(inst_60623)){
var statearr_60758_60836 = state_60740__$1;
(statearr_60758_60836[(1)] = (33));

} else {
var statearr_60759_60837 = state_60740__$1;
(statearr_60759_60837[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (32))){
var inst_60700 = (state_60740[(2)]);
var state_60740__$1 = state_60740;
var statearr_60760_60838 = state_60740__$1;
(statearr_60760_60838[(2)] = inst_60700);

(statearr_60760_60838[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (40))){
var inst_60702 = (state_60740[(15)]);
var state_60740__$1 = state_60740;
var statearr_60761_60839 = state_60740__$1;
(statearr_60761_60839[(2)] = inst_60702);

(statearr_60761_60839[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (33))){
var inst_60623 = (state_60740[(14)]);
var state_60740__$1 = state_60740;
var statearr_60762_60840 = state_60740__$1;
(statearr_60762_60840[(2)] = inst_60623);

(statearr_60762_60840[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (13))){
var inst_60620 = (state_60740[(16)]);
var inst_60649 = (state_60740[(2)]);
var inst_60650 = fluree.db.util.async.throw_err.call(null,inst_60649);
var inst_60651 = fluree.db.time_travel.as_of_block.call(null,inst_60650,inst_60620);
var state_60740__$1 = state_60740;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60740__$1,(12),inst_60651);
} else {
if((state_val_60741 === (22))){
var state_60740__$1 = state_60740;
var statearr_60763_60841 = state_60740__$1;
(statearr_60763_60841[(2)] = null);

(statearr_60763_60841[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (36))){
var inst_60627 = (state_60740[(17)]);
var state_60740__$1 = state_60740;
var statearr_60764_60842 = state_60740__$1;
(statearr_60764_60842[(2)] = inst_60627);

(statearr_60764_60842[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (41))){
var inst_60710 = (state_60740[(2)]);
var state_60740__$1 = state_60740;
if(cljs.core.truth_(inst_60710)){
var statearr_60765_60843 = state_60740__$1;
(statearr_60765_60843[(1)] = (45));

} else {
var statearr_60766_60844 = state_60740__$1;
(statearr_60766_60844[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (43))){
var inst_60621 = (state_60740[(18)]);
var state_60740__$1 = state_60740;
var statearr_60767_60845 = state_60740__$1;
(statearr_60767_60845[(2)] = inst_60621);

(statearr_60767_60845[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (29))){
var inst_60702 = (state_60740[(15)]);
var inst_60702__$1 = (state_60740[(2)]);
var state_60740__$1 = (function (){var statearr_60768 = state_60740;
(statearr_60768[(15)] = inst_60702__$1);

return statearr_60768;
})();
if(cljs.core.truth_(inst_60702__$1)){
var statearr_60769_60846 = state_60740__$1;
(statearr_60769_60846[(1)] = (39));

} else {
var statearr_60770_60847 = state_60740__$1;
(statearr_60770_60847[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (44))){
var inst_60707 = (state_60740[(2)]);
var state_60740__$1 = state_60740;
var statearr_60771_60848 = state_60740__$1;
(statearr_60771_60848[(2)] = inst_60707);

(statearr_60771_60848[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (6))){
var state_60740__$1 = state_60740;
var statearr_60772_60849 = state_60740__$1;
(statearr_60772_60849[(2)] = null);

(statearr_60772_60849[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (28))){
var inst_60624 = (state_60740[(19)]);
var state_60740__$1 = state_60740;
if(cljs.core.truth_(inst_60624)){
var statearr_60773_60850 = state_60740__$1;
(statearr_60773_60850[(1)] = (30));

} else {
var statearr_60774_60851 = state_60740__$1;
(statearr_60774_60851[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (51))){
var inst_60735 = (state_60740[(2)]);
var _ = (function (){var statearr_60775 = state_60740;
(statearr_60775[(4)] = cljs.core.rest.call(null,(state_60740[(4)])));

return statearr_60775;
})();
var state_60740__$1 = state_60740;
var statearr_60776_60852 = state_60740__$1;
(statearr_60776_60852[(2)] = inst_60735);

(statearr_60776_60852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (25))){
var state_60740__$1 = state_60740;
var statearr_60777_60853 = state_60740__$1;
(statearr_60777_60853[(2)] = (1000000));

(statearr_60777_60853[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (34))){
var inst_60627 = (state_60740[(17)]);
var state_60740__$1 = state_60740;
if(cljs.core.truth_(inst_60627)){
var statearr_60778_60854 = state_60740__$1;
(statearr_60778_60854[(1)] = (36));

} else {
var statearr_60779_60855 = state_60740__$1;
(statearr_60779_60855[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (17))){
var inst_60671 = (state_60740[(20)]);
var inst_60626 = (state_60740[(21)]);
var inst_60669 = (state_60740[(2)]);
var inst_60670 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_60626);
var inst_60671__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_60626);
var state_60740__$1 = (function (){var statearr_60780 = state_60740;
(statearr_60780[(22)] = inst_60669);

(statearr_60780[(20)] = inst_60671__$1);

(statearr_60780[(12)] = inst_60670);

return statearr_60780;
})();
if(cljs.core.truth_(inst_60671__$1)){
var statearr_60781_60856 = state_60740__$1;
(statearr_60781_60856[(1)] = (18));

} else {
var statearr_60782_60857 = state_60740__$1;
(statearr_60782_60857[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (3))){
var inst_60738 = (state_60740[(2)]);
var state_60740__$1 = state_60740;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60740__$1,inst_60738);
} else {
if((state_val_60741 === (12))){
var inst_60653 = (state_60740[(2)]);
var inst_60654 = fluree.db.util.async.throw_err.call(null,inst_60653);
var state_60740__$1 = state_60740;
var statearr_60783_60858 = state_60740__$1;
(statearr_60783_60858[(2)] = inst_60654);

(statearr_60783_60858[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (2))){
var inst_60624 = (state_60740[(19)]);
var inst_60621 = (state_60740[(18)]);
var inst_60625 = (state_60740[(9)]);
var inst_60620 = (state_60740[(16)]);
var inst_60623 = (state_60740[(14)]);
var inst_60619 = (state_60740[(7)]);
var inst_60618 = (state_60740[(23)]);
var inst_60627 = (state_60740[(17)]);
var inst_60626 = (state_60740[(21)]);
var inst_60622 = (state_60740[(11)]);
var _ = (function (){var statearr_60784 = state_60740;
(statearr_60784[(4)] = cljs.core.cons.call(null,(5),(state_60740[(4)])));

return statearr_60784;
})();
var inst_60616 = flureeQL;
var inst_60617 = cljs.core.__destructure_map.call(null,inst_60616);
var inst_60618__$1 = cljs.core.get.call(null,inst_60617,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_60619__$1 = cljs.core.get.call(null,inst_60617,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_60620__$1 = cljs.core.get.call(null,inst_60617,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60621__$1 = cljs.core.get.call(null,inst_60617,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_60622__$1 = cljs.core.get.call(null,inst_60617,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_60623__$1 = cljs.core.get.call(null,inst_60617,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_60624__$1 = cljs.core.get.call(null,inst_60617,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_60625__$1 = cljs.core.get.call(null,inst_60617,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_60626__$1 = cljs.core.get.call(null,inst_60617,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60627__$1 = cljs.core.get.call(null,inst_60617,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_60628 = (function (){var construct = inst_60618__$1;
var map__60615 = inst_60617;
var select = inst_60619__$1;
var block = inst_60620__$1;
var where = inst_60621__$1;
var prefixes = inst_60622__$1;
var selectDistinct = inst_60623__$1;
var selectOne = inst_60624__$1;
var from = inst_60625__$1;
var opts = inst_60626__$1;
var selectReduced = inst_60627__$1;
return (function (p1__60608_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__60608_SHARP_);
});
})();
var inst_60629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60630 = [inst_60619__$1,inst_60624__$1,inst_60623__$1,inst_60627__$1];
var inst_60631 = (new cljs.core.PersistentVector(null,4,(5),inst_60629,inst_60630,null));
var inst_60632 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_60631);
var inst_60633 = cljs.core.count.call(null,inst_60632);
var inst_60634 = inst_60628.call(null,inst_60633);
var state_60740__$1 = (function (){var statearr_60785 = state_60740;
(statearr_60785[(19)] = inst_60624__$1);

(statearr_60785[(18)] = inst_60621__$1);

(statearr_60785[(9)] = inst_60625__$1);

(statearr_60785[(16)] = inst_60620__$1);

(statearr_60785[(14)] = inst_60623__$1);

(statearr_60785[(7)] = inst_60619__$1);

(statearr_60785[(23)] = inst_60618__$1);

(statearr_60785[(17)] = inst_60627__$1);

(statearr_60785[(21)] = inst_60626__$1);

(statearr_60785[(11)] = inst_60622__$1);

return statearr_60785;
})();
if(cljs.core.truth_(inst_60634)){
var statearr_60786_60859 = state_60740__$1;
(statearr_60786_60859[(1)] = (6));

} else {
var statearr_60787_60860 = state_60740__$1;
(statearr_60787_60860[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (23))){
var inst_60681 = (state_60740[(8)]);
var inst_60626 = (state_60740[(21)]);
var inst_60680 = (state_60740[(2)]);
var inst_60681__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_60626);
var state_60740__$1 = (function (){var statearr_60788 = state_60740;
(statearr_60788[(8)] = inst_60681__$1);

(statearr_60788[(24)] = inst_60680);

return statearr_60788;
})();
if(cljs.core.truth_(inst_60681__$1)){
var statearr_60789_60861 = state_60740__$1;
(statearr_60789_60861[(1)] = (24));

} else {
var statearr_60790_60862 = state_60740__$1;
(statearr_60790_60862[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (47))){
var inst_60686 = (state_60740[(25)]);
var inst_60660 = (state_60740[(10)]);
var inst_60719 = (state_60740[(2)]);
var inst_60720 = fluree.db.util.core.current_time_millis.call(null);
var inst_60721 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_60686);
var inst_60722 = fluree.db.query.fql.query.call(null,inst_60660,inst_60721);
var state_60740__$1 = (function (){var statearr_60791 = state_60740;
(statearr_60791[(26)] = inst_60719);

(statearr_60791[(27)] = inst_60720);

return statearr_60791;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60740__$1,(48),inst_60722);
} else {
if((state_val_60741 === (35))){
var inst_60698 = (state_60740[(2)]);
var state_60740__$1 = state_60740;
var statearr_60792_60863 = state_60740__$1;
(statearr_60792_60863[(2)] = inst_60698);

(statearr_60792_60863[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (19))){
var inst_60670 = (state_60740[(12)]);
var state_60740__$1 = state_60740;
var statearr_60793_60864 = state_60740__$1;
(statearr_60793_60864[(2)] = inst_60670);

(statearr_60793_60864[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (11))){
var inst_60622 = (state_60740[(11)]);
var inst_60660 = (state_60740[(2)]);
var state_60740__$1 = (function (){var statearr_60795 = state_60740;
(statearr_60795[(10)] = inst_60660);

return statearr_60795;
})();
if(cljs.core.truth_(inst_60622)){
var statearr_60796_60865 = state_60740__$1;
(statearr_60796_60865[(1)] = (15));

} else {
var statearr_60797_60866 = state_60740__$1;
(statearr_60797_60866[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (9))){
var inst_60646 = (state_60740[(28)]);
var state_60740__$1 = state_60740;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60740__$1,(13),inst_60646);
} else {
if((state_val_60741 === (5))){
var _ = (function (){var statearr_60798 = state_60740;
(statearr_60798[(4)] = cljs.core.rest.call(null,(state_60740[(4)])));

return statearr_60798;
})();
var state_60740__$1 = state_60740;
var ex60794 = (state_60740__$1[(2)]);
var statearr_60799_60867 = state_60740__$1;
(statearr_60799_60867[(5)] = ex60794);


if((ex60794 instanceof Error)){
var statearr_60800_60868 = state_60740__$1;
(statearr_60800_60868[(1)] = (4));

(statearr_60800_60868[(5)] = null);

} else {
throw ex60794;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (14))){
var inst_60657 = (state_60740[(2)]);
var inst_60658 = fluree.db.util.async.throw_err.call(null,inst_60657);
var state_60740__$1 = state_60740;
var statearr_60801_60869 = state_60740__$1;
(statearr_60801_60869[(2)] = inst_60658);

(statearr_60801_60869[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (45))){
var state_60740__$1 = state_60740;
var statearr_60802_60870 = state_60740__$1;
(statearr_60802_60870[(2)] = null);

(statearr_60802_60870[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (26))){
var inst_60669 = (state_60740[(22)]);
var inst_60619 = (state_60740[(7)]);
var inst_60626 = (state_60740[(21)]);
var inst_60680 = (state_60740[(24)]);
var inst_60685 = (state_60740[(2)]);
var inst_60686 = cljs.core.assoc.call(null,inst_60626,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_60669,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_60685,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_60680);
var state_60740__$1 = (function (){var statearr_60803 = state_60740;
(statearr_60803[(25)] = inst_60686);

return statearr_60803;
})();
if(cljs.core.truth_(inst_60619)){
var statearr_60804_60871 = state_60740__$1;
(statearr_60804_60871[(1)] = (27));

} else {
var statearr_60805_60872 = state_60740__$1;
(statearr_60805_60872[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (16))){
var inst_60667 = cljs.core.PersistentHashMap.EMPTY;
var state_60740__$1 = state_60740;
var statearr_60806_60873 = state_60740__$1;
(statearr_60806_60873[(2)] = inst_60667);

(statearr_60806_60873[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (38))){
var inst_60696 = (state_60740[(2)]);
var state_60740__$1 = state_60740;
var statearr_60807_60874 = state_60740__$1;
(statearr_60807_60874[(2)] = inst_60696);

(statearr_60807_60874[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (30))){
var inst_60624 = (state_60740[(19)]);
var state_60740__$1 = state_60740;
var statearr_60808_60875 = state_60740__$1;
(statearr_60808_60875[(2)] = inst_60624);

(statearr_60808_60875[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (10))){
var inst_60646 = (state_60740[(28)]);
var state_60740__$1 = state_60740;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60740__$1,(14),inst_60646);
} else {
if((state_val_60741 === (18))){
var inst_60671 = (state_60740[(20)]);
var state_60740__$1 = state_60740;
var statearr_60809_60876 = state_60740__$1;
(statearr_60809_60876[(2)] = inst_60671);

(statearr_60809_60876[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (42))){
var inst_60625 = (state_60740[(9)]);
var state_60740__$1 = state_60740;
var statearr_60810_60877 = state_60740__$1;
(statearr_60810_60877[(2)] = inst_60625);

(statearr_60810_60877[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (37))){
var inst_60618 = (state_60740[(23)]);
var state_60740__$1 = state_60740;
var statearr_60811_60878 = state_60740__$1;
(statearr_60811_60878[(2)] = inst_60618);

(statearr_60811_60878[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (8))){
var inst_60620 = (state_60740[(16)]);
var inst_60645 = (state_60740[(2)]);
var inst_60646 = sources;
var state_60740__$1 = (function (){var statearr_60812 = state_60740;
(statearr_60812[(28)] = inst_60646);

(statearr_60812[(29)] = inst_60645);

return statearr_60812;
})();
if(cljs.core.truth_(inst_60620)){
var statearr_60813_60879 = state_60740__$1;
(statearr_60813_60879[(1)] = (9));

} else {
var statearr_60814_60880 = state_60740__$1;
(statearr_60814_60880[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60741 === (49))){
var inst_60725 = (state_60740[(13)]);
var inst_60660 = (state_60740[(10)]);
var inst_60720 = (state_60740[(27)]);
var inst_60680 = (state_60740[(24)]);
var inst_60727 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60728 = cljs.core.deref.call(null,inst_60680);
var inst_60729 = fluree.db.util.core.response_time_formatted.call(null,inst_60720);
var inst_60730 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_60660);
var inst_60731 = [(200),inst_60725,inst_60728,inst_60729,inst_60730];
var inst_60732 = cljs.core.PersistentHashMap.fromArrays(inst_60727,inst_60731);
var state_60740__$1 = state_60740;
var statearr_60815_60881 = state_60740__$1;
(statearr_60815_60881[(2)] = inst_60732);

(statearr_60815_60881[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_60816 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60816[(0)] = fluree$db$api$query$query_async_$_state_machine__2746__auto__);

(statearr_60816[(1)] = (1));

return statearr_60816;
});
var fluree$db$api$query$query_async_$_state_machine__2746__auto____1 = (function (state_60740){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_60740);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e60817){var ex__2749__auto__ = e60817;
var statearr_60818_60882 = state_60740;
(statearr_60818_60882[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_60740[(4)]))){
var statearr_60819_60883 = state_60740;
(statearr_60819_60883[(1)] = cljs.core.first.call(null,(state_60740[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60884 = state_60740;
state_60740 = G__60884;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2746__auto__ = function(state_60740){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2746__auto____1.call(this,state_60740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_60820 = f__2769__auto__.call(null);
(statearr_60820[(6)] = c__2768__auto__);

return statearr_60820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_61025){
var state_val_61026 = (state_61025[(1)]);
if((state_val_61026 === (7))){
var inst_61020 = (state_61025[(2)]);
var _ = (function (){var statearr_61027 = state_61025;
(statearr_61027[(4)] = cljs.core.rest.call(null,(state_61025[(4)])));

return statearr_61027;
})();
var state_61025__$1 = state_61025;
var statearr_61028_61104 = state_61025__$1;
(statearr_61028_61104[(2)] = inst_61020);

(statearr_61028_61104[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (20))){
var inst_60992 = (state_61025[(2)]);
var state_61025__$1 = state_61025;
var statearr_61029_61105 = state_61025__$1;
(statearr_61029_61105[(2)] = inst_60992);

(statearr_61029_61105[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (27))){
var inst_60972 = (state_61025[(7)]);
var state_61025__$1 = state_61025;
var statearr_61030_61106 = state_61025__$1;
(statearr_61030_61106[(2)] = inst_60972);

(statearr_61030_61106[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (1))){
var state_61025__$1 = state_61025;
var statearr_61031_61107 = state_61025__$1;
(statearr_61031_61107[(2)] = null);

(statearr_61031_61107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (24))){
var inst_60969 = (state_61025[(8)]);
var state_61025__$1 = state_61025;
var statearr_61032_61108 = state_61025__$1;
(statearr_61032_61108[(2)] = inst_60969);

(statearr_61032_61108[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (39))){
var inst_60959 = (state_61025[(9)]);
var inst_60926 = (state_61025[(10)]);
var inst_60937 = (state_61025[(11)]);
var inst_61003 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61004 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_60937];
var inst_61005 = (new cljs.core.PersistentVector(null,2,(5),inst_61003,inst_61004,null));
var inst_61006 = cljs.core.assoc_in.call(null,inst_60926,inst_61005,inst_60959);
var state_61025__$1 = state_61025;
var statearr_61033_61109 = state_61025__$1;
(statearr_61033_61109[(2)] = inst_61006);

(statearr_61033_61109[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (4))){
var inst_60885 = (state_61025[(2)]);
var state_61025__$1 = state_61025;
var statearr_61034_61110 = state_61025__$1;
(statearr_61034_61110[(2)] = inst_60885);

(statearr_61034_61110[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (15))){
var inst_60959 = (state_61025[(9)]);
var inst_60924 = (state_61025[(12)]);
var inst_60962 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_60959);
var inst_60963 = (inst_60924 == null);
var state_61025__$1 = (function (){var statearr_61035 = state_61025;
(statearr_61035[(13)] = inst_60962);

return statearr_61035;
})();
if(cljs.core.truth_(inst_60963)){
var statearr_61036_61111 = state_61025__$1;
(statearr_61036_61111[(1)] = (18));

} else {
var statearr_61037_61112 = state_61025__$1;
(statearr_61037_61112[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (21))){
var inst_60962 = (state_61025[(13)]);
var state_61025__$1 = state_61025;
var statearr_61038_61113 = state_61025__$1;
(statearr_61038_61113[(2)] = inst_60962);

(statearr_61038_61113[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (31))){
var state_61025__$1 = state_61025;
var statearr_61039_61114 = state_61025__$1;
(statearr_61039_61114[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (32))){
var inst_60988 = (state_61025[(2)]);
var state_61025__$1 = state_61025;
var statearr_61041_61115 = state_61025__$1;
(statearr_61041_61115[(2)] = inst_60988);

(statearr_61041_61115[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (40))){
var inst_60957 = (state_61025[(14)]);
var state_61025__$1 = state_61025;
if(cljs.core.truth_(inst_60957)){
var statearr_61042_61116 = state_61025__$1;
(statearr_61042_61116[(1)] = (42));

} else {
var statearr_61043_61117 = state_61025__$1;
(statearr_61043_61117[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (33))){
var inst_60924 = (state_61025[(12)]);
var inst_60962 = (state_61025[(13)]);
var inst_60983 = ((inst_60962 > inst_60924) ? inst_60962 : inst_60924);
var state_61025__$1 = state_61025;
var statearr_61044_61118 = state_61025__$1;
(statearr_61044_61118[(2)] = inst_60983);

(statearr_61044_61118[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (13))){
var inst_60948 = (state_61025[(2)]);
var state_61025__$1 = state_61025;
var statearr_61045_61119 = state_61025__$1;
(statearr_61045_61119[(2)] = inst_60948);

(statearr_61045_61119[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (22))){
var inst_60969 = (state_61025[(8)]);
var inst_60962 = (state_61025[(13)]);
var inst_60969__$1 = cljs.core._EQ_.call(null,(200),inst_60962);
var state_61025__$1 = (function (){var statearr_61046 = state_61025;
(statearr_61046[(8)] = inst_60969__$1);

return statearr_61046;
})();
if(inst_60969__$1){
var statearr_61047_61120 = state_61025__$1;
(statearr_61047_61120[(1)] = (24));

} else {
var statearr_61048_61121 = state_61025__$1;
(statearr_61048_61121[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (36))){
var inst_60925 = (state_61025[(15)]);
var inst_60959 = (state_61025[(9)]);
var inst_60997 = cljs.core.get.call(null,inst_60959,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_60998 = (inst_60925 + inst_60997);
var state_61025__$1 = state_61025;
var statearr_61049_61122 = state_61025__$1;
(statearr_61049_61122[(2)] = inst_60998);

(statearr_61049_61122[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (41))){
var inst_60936 = (state_61025[(16)]);
var inst_60995 = (state_61025[(17)]);
var inst_61001 = (state_61025[(18)]);
var inst_61015 = (state_61025[(2)]);
var inst_60923 = inst_60936;
var inst_60924 = inst_60995;
var inst_60925 = inst_61001;
var inst_60926 = inst_61015;
var state_61025__$1 = (function (){var statearr_61050 = state_61025;
(statearr_61050[(15)] = inst_60925);

(statearr_61050[(10)] = inst_60926);

(statearr_61050[(19)] = inst_60923);

(statearr_61050[(12)] = inst_60924);

return statearr_61050;
})();
var statearr_61051_61123 = state_61025__$1;
(statearr_61051_61123[(2)] = null);

(statearr_61051_61123[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (43))){
var inst_60959 = (state_61025[(9)]);
var state_61025__$1 = state_61025;
var statearr_61052_61124 = state_61025__$1;
(statearr_61052_61124[(2)] = inst_60959);

(statearr_61052_61124[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (29))){
var inst_60977 = (state_61025[(2)]);
var state_61025__$1 = state_61025;
var statearr_61053_61125 = state_61025__$1;
(statearr_61053_61125[(2)] = inst_60977);

(statearr_61053_61125[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (44))){
var inst_60926 = (state_61025[(10)]);
var inst_60937 = (state_61025[(11)]);
var inst_61012 = (state_61025[(2)]);
var inst_61013 = cljs.core.assoc.call(null,inst_60926,inst_60937,inst_61012);
var state_61025__$1 = state_61025;
var statearr_61054_61126 = state_61025__$1;
(statearr_61054_61126[(2)] = inst_61013);

(statearr_61054_61126[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (6))){
var inst_60938 = (state_61025[(20)]);
var inst_60923 = (state_61025[(19)]);
var inst_60934 = cljs.core.seq.call(null,inst_60923);
var inst_60935 = cljs.core.first.call(null,inst_60934);
var inst_60936 = cljs.core.next.call(null,inst_60934);
var inst_60937 = cljs.core.nth.call(null,inst_60935,(0),null);
var inst_60938__$1 = cljs.core.nth.call(null,inst_60935,(1),null);
var inst_60939 = (inst_60938__$1 == null);
var state_61025__$1 = (function (){var statearr_61055 = state_61025;
(statearr_61055[(20)] = inst_60938__$1);

(statearr_61055[(16)] = inst_60936);

(statearr_61055[(11)] = inst_60937);

return statearr_61055;
})();
if(cljs.core.truth_(inst_60939)){
var statearr_61056_61127 = state_61025__$1;
(statearr_61056_61127[(1)] = (8));

} else {
var statearr_61057_61128 = state_61025__$1;
(statearr_61057_61128[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (28))){
var inst_60924 = (state_61025[(12)]);
var inst_60975 = cljs.core._EQ_.call(null,(207),inst_60924);
var state_61025__$1 = state_61025;
var statearr_61058_61129 = state_61025__$1;
(statearr_61058_61129[(2)] = inst_60975);

(statearr_61058_61129[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (25))){
var inst_60924 = (state_61025[(12)]);
var inst_60972 = (state_61025[(7)]);
var inst_60972__$1 = cljs.core._EQ_.call(null,(200),inst_60924);
var state_61025__$1 = (function (){var statearr_61059 = state_61025;
(statearr_61059[(7)] = inst_60972__$1);

return statearr_61059;
})();
if(inst_60972__$1){
var statearr_61060_61130 = state_61025__$1;
(statearr_61060_61130[(1)] = (27));

} else {
var statearr_61061_61131 = state_61025__$1;
(statearr_61061_61131[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (34))){
var state_61025__$1 = state_61025;
var statearr_61062_61132 = state_61025__$1;
(statearr_61062_61132[(2)] = null);

(statearr_61062_61132[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (17))){
var inst_60956 = (state_61025[(21)]);
var inst_60995 = (state_61025[(2)]);
var state_61025__$1 = (function (){var statearr_61063 = state_61025;
(statearr_61063[(17)] = inst_60995);

return statearr_61063;
})();
if(cljs.core.truth_(inst_60956)){
var statearr_61064_61133 = state_61025__$1;
(statearr_61064_61133[(1)] = (36));

} else {
var statearr_61065_61134 = state_61025__$1;
(statearr_61065_61134[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (3))){
var inst_61023 = (state_61025[(2)]);
var state_61025__$1 = state_61025;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61025__$1,inst_61023);
} else {
if((state_val_61026 === (12))){
var inst_60926 = (state_61025[(10)]);
var state_61025__$1 = state_61025;
var statearr_61066_61135 = state_61025__$1;
(statearr_61066_61135[(2)] = inst_60926);

(statearr_61066_61135[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (2))){
var inst_60899 = (state_61025[(22)]);
var inst_60900 = (state_61025[(23)]);
var inst_60895 = (state_61025[(24)]);
var _ = (function (){var statearr_61067 = state_61025;
(statearr_61067[(4)] = cljs.core.cons.call(null,(5),(state_61025[(4)])));

return statearr_61067;
})();
var inst_60891 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_60892 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60893 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_60894 = (new cljs.core.PersistentVector(null,2,(5),inst_60892,inst_60893,null));
var inst_60895__$1 = cljs.core.get_in.call(null,flureeQL,inst_60894);
var inst_60896 = (function (){var global_block = inst_60891;
var global_meta_QMARK_ = inst_60895__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4253__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4251__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__4251__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_60897 = cljs.core.PersistentHashMap.EMPTY;
var inst_60898 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_60899__$1 = cljs.core.reduce_kv.call(null,inst_60896,inst_60897,inst_60898);
var inst_60900__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_60902 = (function (){var global_block = inst_60891;
var global_meta_QMARK_ = inst_60895__$1;
var queries = inst_60899__$1;
var start_time = inst_60900__$1;
return (function (p__60901){
var vec__61068 = p__60901;
var alias = cljs.core.nth.call(null,vec__61068,(0),null);
var q = cljs.core.nth.call(null,vec__61068,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_60903 = cljs.core.map.call(null,inst_60902,inst_60899__$1);
var inst_60917 = cljs.core.seq.call(null,inst_60903);
var inst_60918 = cljs.core.first.call(null,inst_60917);
var inst_60919 = cljs.core.next.call(null,inst_60917);
var inst_60920 = cljs.core.nth.call(null,inst_60918,(0),null);
var inst_60921 = cljs.core.nth.call(null,inst_60918,(1),null);
var inst_60922 = cljs.core.PersistentHashMap.EMPTY;
var inst_60923 = inst_60903;
var inst_60924 = null;
var inst_60925 = (0);
var inst_60926 = inst_60922;
var state_61025__$1 = (function (){var statearr_61071 = state_61025;
(statearr_61071[(15)] = inst_60925);

(statearr_61071[(10)] = inst_60926);

(statearr_61071[(19)] = inst_60923);

(statearr_61071[(12)] = inst_60924);

(statearr_61071[(22)] = inst_60899__$1);

(statearr_61071[(25)] = inst_60921);

(statearr_61071[(26)] = inst_60919);

(statearr_61071[(23)] = inst_60900__$1);

(statearr_61071[(24)] = inst_60895__$1);

(statearr_61071[(27)] = inst_60920);

return statearr_61071;
})();
var statearr_61072_61136 = state_61025__$1;
(statearr_61072_61136[(2)] = null);

(statearr_61072_61136[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (23))){
var inst_60990 = (state_61025[(2)]);
var state_61025__$1 = state_61025;
var statearr_61073_61137 = state_61025__$1;
(statearr_61073_61137[(2)] = inst_60990);

(statearr_61073_61137[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (35))){
var inst_60986 = (state_61025[(2)]);
var state_61025__$1 = state_61025;
var statearr_61074_61138 = state_61025__$1;
(statearr_61074_61138[(2)] = inst_60986);

(statearr_61074_61138[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (19))){
var inst_60924 = (state_61025[(12)]);
var inst_60962 = (state_61025[(13)]);
var inst_60966 = cljs.core._EQ_.call(null,inst_60924,inst_60962);
var state_61025__$1 = state_61025;
if(inst_60966){
var statearr_61075_61139 = state_61025__$1;
(statearr_61075_61139[(1)] = (21));

} else {
var statearr_61076_61140 = state_61025__$1;
(statearr_61076_61140[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (11))){
var inst_60925 = (state_61025[(15)]);
var inst_60926 = (state_61025[(10)]);
var inst_60924 = (state_61025[(12)]);
var inst_60900 = (state_61025[(23)]);
var inst_60942 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_60943 = fluree.db.util.core.response_time_formatted.call(null,inst_60900);
var inst_60944 = [inst_60926,inst_60925,inst_60924,inst_60943];
var inst_60945 = cljs.core.PersistentHashMap.fromArrays(inst_60942,inst_60944);
var state_61025__$1 = state_61025;
var statearr_61078_61141 = state_61025__$1;
(statearr_61078_61141[(2)] = inst_60945);

(statearr_61078_61141[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (9))){
var inst_60938 = (state_61025[(20)]);
var inst_60899 = (state_61025[(22)]);
var inst_60937 = (state_61025[(11)]);
var inst_60951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60952 = [inst_60937,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_60953 = (new cljs.core.PersistentVector(null,2,(5),inst_60951,inst_60952,null));
var inst_60954 = cljs.core.get_in.call(null,inst_60899,inst_60953);
var inst_60955 = cljs.core.__destructure_map.call(null,inst_60954);
var inst_60956 = cljs.core.get.call(null,inst_60955,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_60957 = cljs.core.get.call(null,inst_60955,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_61025__$1 = (function (){var statearr_61079 = state_61025;
(statearr_61079[(21)] = inst_60956);

(statearr_61079[(14)] = inst_60957);

return statearr_61079;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61025__$1,(14),inst_60938);
} else {
if((state_val_61026 === (5))){
var _ = (function (){var statearr_61080 = state_61025;
(statearr_61080[(4)] = cljs.core.rest.call(null,(state_61025[(4)])));

return statearr_61080;
})();
var state_61025__$1 = state_61025;
var ex61077 = (state_61025__$1[(2)]);
var statearr_61081_61142 = state_61025__$1;
(statearr_61081_61142[(5)] = ex61077);


var statearr_61082_61143 = state_61025__$1;
(statearr_61082_61143[(1)] = (4));

(statearr_61082_61143[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (14))){
var inst_60959 = (state_61025[(9)]);
var inst_60956 = (state_61025[(21)]);
var inst_60959__$1 = (state_61025[(2)]);
var inst_60960 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_60959__$1);
var state_61025__$1 = (function (){var statearr_61083 = state_61025;
(statearr_61083[(9)] = inst_60959__$1);

(statearr_61083[(28)] = inst_60960);

return statearr_61083;
})();
if(cljs.core.truth_(inst_60956)){
var statearr_61084_61144 = state_61025__$1;
(statearr_61084_61144[(1)] = (15));

} else {
var statearr_61085_61145 = state_61025__$1;
(statearr_61085_61145[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (26))){
var inst_60979 = (state_61025[(2)]);
var state_61025__$1 = state_61025;
if(cljs.core.truth_(inst_60979)){
var statearr_61086_61146 = state_61025__$1;
(statearr_61086_61146[(1)] = (30));

} else {
var statearr_61087_61147 = state_61025__$1;
(statearr_61087_61147[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (16))){
var state_61025__$1 = state_61025;
var statearr_61088_61148 = state_61025__$1;
(statearr_61088_61148[(2)] = null);

(statearr_61088_61148[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (38))){
var inst_60960 = (state_61025[(28)]);
var inst_61001 = (state_61025[(2)]);
var state_61025__$1 = (function (){var statearr_61089 = state_61025;
(statearr_61089[(18)] = inst_61001);

return statearr_61089;
})();
if(cljs.core.truth_(inst_60960)){
var statearr_61090_61149 = state_61025__$1;
(statearr_61090_61149[(1)] = (39));

} else {
var statearr_61091_61150 = state_61025__$1;
(statearr_61091_61150[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (30))){
var state_61025__$1 = state_61025;
var statearr_61092_61151 = state_61025__$1;
(statearr_61092_61151[(2)] = (207));

(statearr_61092_61151[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (10))){
var inst_61018 = (state_61025[(2)]);
var state_61025__$1 = state_61025;
var statearr_61093_61152 = state_61025__$1;
(statearr_61093_61152[(2)] = inst_61018);

(statearr_61093_61152[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (18))){
var inst_60962 = (state_61025[(13)]);
var state_61025__$1 = state_61025;
var statearr_61094_61153 = state_61025__$1;
(statearr_61094_61153[(2)] = inst_60962);

(statearr_61094_61153[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (42))){
var inst_60959 = (state_61025[(9)]);
var inst_61009 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_60959);
var state_61025__$1 = state_61025;
var statearr_61095_61154 = state_61025__$1;
(statearr_61095_61154[(2)] = inst_61009);

(statearr_61095_61154[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (37))){
var state_61025__$1 = state_61025;
var statearr_61096_61155 = state_61025__$1;
(statearr_61096_61155[(2)] = null);

(statearr_61096_61155[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61026 === (8))){
var inst_60895 = (state_61025[(24)]);
var state_61025__$1 = state_61025;
if(cljs.core.truth_(inst_60895)){
var statearr_61097_61156 = state_61025__$1;
(statearr_61097_61156[(1)] = (11));

} else {
var statearr_61098_61157 = state_61025__$1;
(statearr_61098_61157[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_61099 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61099[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__);

(statearr_61099[(1)] = (1));

return statearr_61099;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1 = (function (state_61025){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_61025);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e61100){var ex__2749__auto__ = e61100;
var statearr_61101_61158 = state_61025;
(statearr_61101_61158[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_61025[(4)]))){
var statearr_61102_61159 = state_61025;
(statearr_61102_61159[(1)] = cljs.core.first.call(null,(state_61025[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61160 = state_61025;
state_61025 = G__61160;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__ = function(state_61025){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1.call(this,state_61025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_61103 = f__2769__auto__.call(null);
(statearr_61103[(6)] = c__2768__auto__);

return statearr_61103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__61161 = query_type;
var G__61161__$1 = (((G__61161 instanceof cljs.core.Keyword))?G__61161.fqn:null);
switch (G__61161__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__61161__$1)].join('')));

}
});
