// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4913__auto___52916 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_52967){
var state_val_52968 = (state_52967[(1)]);
if((state_val_52968 === (7))){
var inst_52962 = (state_52967[(2)]);
var _ = (function (){var statearr_52969 = state_52967;
(statearr_52969[(4)] = cljs.core.rest.call(null,(state_52967[(4)])));

return statearr_52969;
})();
var state_52967__$1 = state_52967;
var statearr_52970_52997 = state_52967__$1;
(statearr_52970_52997[(2)] = inst_52962);

(statearr_52970_52997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52968 === (1))){
var state_52967__$1 = state_52967;
var statearr_52971_52998 = state_52967__$1;
(statearr_52971_52998[(2)] = null);

(statearr_52971_52998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52968 === (4))){
var inst_52917 = (state_52967[(2)]);
var state_52967__$1 = state_52967;
var statearr_52972_52999 = state_52967__$1;
(statearr_52972_52999[(2)] = inst_52917);

(statearr_52972_52999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52968 === (13))){
var inst_52958 = (state_52967[(2)]);
var state_52967__$1 = state_52967;
var statearr_52973_53000 = state_52967__$1;
(statearr_52973_53000[(2)] = inst_52958);

(statearr_52973_53000[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52968 === (6))){
var inst_52935 = (state_52967[(7)]);
var inst_52942 = (state_52967[(8)]);
var inst_52941 = cljs.core.seq.call(null,inst_52935);
var inst_52942__$1 = cljs.core.first.call(null,inst_52941);
var inst_52943 = cljs.core.next.call(null,inst_52941);
var inst_52944 = cljs.core.not.call(null,inst_52942__$1);
var state_52967__$1 = (function (){var statearr_52974 = state_52967;
(statearr_52974[(8)] = inst_52942__$1);

(statearr_52974[(9)] = inst_52943);

return statearr_52974;
})();
if(inst_52944){
var statearr_52975_53001 = state_52967__$1;
(statearr_52975_53001[(1)] = (8));

} else {
var statearr_52976_53002 = state_52967__$1;
(statearr_52976_53002[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52968 === (3))){
var inst_52965 = (state_52967[(2)]);
var state_52967__$1 = state_52967;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52967__$1,inst_52965);
} else {
if((state_val_52968 === (12))){
var inst_52942 = (state_52967[(8)]);
var inst_52943 = (state_52967[(9)]);
var inst_52936 = (state_52967[(10)]);
var inst_52955 = cljs.core.conj.call(null,inst_52936,inst_52942);
var inst_52935 = inst_52943;
var inst_52936__$1 = inst_52955;
var state_52967__$1 = (function (){var statearr_52977 = state_52967;
(statearr_52977[(7)] = inst_52935);

(statearr_52977[(10)] = inst_52936__$1);

return statearr_52977;
})();
var statearr_52978_53003 = state_52967__$1;
(statearr_52978_53003[(2)] = null);

(statearr_52978_53003[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52968 === (2))){
var _ = (function (){var statearr_52979 = state_52967;
(statearr_52979[(4)] = cljs.core.cons.call(null,(5),(state_52967[(4)])));

return statearr_52979;
})();
var inst_52930 = args;
var inst_52931 = cljs.core.seq.call(null,inst_52930);
var inst_52932 = cljs.core.first.call(null,inst_52931);
var inst_52933 = cljs.core.next.call(null,inst_52931);
var inst_52934 = cljs.core.PersistentVector.EMPTY;
var inst_52935 = inst_52930;
var inst_52936 = inst_52934;
var state_52967__$1 = (function (){var statearr_52980 = state_52967;
(statearr_52980[(7)] = inst_52935);

(statearr_52980[(11)] = inst_52933);

(statearr_52980[(12)] = inst_52932);

(statearr_52980[(10)] = inst_52936);

return statearr_52980;
})();
var statearr_52981_53004 = state_52967__$1;
(statearr_52981_53004[(2)] = null);

(statearr_52981_53004[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52968 === (11))){
var inst_52942 = (state_52967[(8)]);
var state_52967__$1 = state_52967;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52967__$1,(14),inst_52942);
} else {
if((state_val_52968 === (9))){
var inst_52942 = (state_52967[(8)]);
var inst_52947 = fluree.db.util.async.channel_QMARK_.call(null,inst_52942);
var state_52967__$1 = state_52967;
if(inst_52947){
var statearr_52983_53005 = state_52967__$1;
(statearr_52983_53005[(1)] = (11));

} else {
var statearr_52984_53006 = state_52967__$1;
(statearr_52984_53006[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52968 === (5))){
var _ = (function (){var statearr_52985 = state_52967;
(statearr_52985[(4)] = cljs.core.rest.call(null,(state_52967[(4)])));

return statearr_52985;
})();
var state_52967__$1 = state_52967;
var ex52982 = (state_52967__$1[(2)]);
var statearr_52986_53007 = state_52967__$1;
(statearr_52986_53007[(5)] = ex52982);


if((ex52982 instanceof Error)){
var statearr_52987_53008 = state_52967__$1;
(statearr_52987_53008[(1)] = (4));

(statearr_52987_53008[(5)] = null);

} else {
throw ex52982;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52968 === (14))){
var inst_52943 = (state_52967[(9)]);
var inst_52936 = (state_52967[(10)]);
var inst_52950 = (state_52967[(2)]);
var inst_52951 = fluree.db.util.async.throw_err.call(null,inst_52950);
var inst_52952 = cljs.core.conj.call(null,inst_52936,inst_52951);
var inst_52935 = inst_52943;
var inst_52936__$1 = inst_52952;
var state_52967__$1 = (function (){var statearr_52988 = state_52967;
(statearr_52988[(7)] = inst_52935);

(statearr_52988[(10)] = inst_52936__$1);

return statearr_52988;
})();
var statearr_52989_53009 = state_52967__$1;
(statearr_52989_53009[(2)] = null);

(statearr_52989_53009[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52968 === (10))){
var inst_52960 = (state_52967[(2)]);
var state_52967__$1 = state_52967;
var statearr_52990_53010 = state_52967__$1;
(statearr_52990_53010[(2)] = inst_52960);

(statearr_52990_53010[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52968 === (8))){
var inst_52936 = (state_52967[(10)]);
var state_52967__$1 = state_52967;
var statearr_52991_53011 = state_52967__$1;
(statearr_52991_53011[(2)] = inst_52936);

(statearr_52991_53011[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0 = (function (){
var statearr_52992 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52992[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__);

(statearr_52992[(1)] = (1));

return statearr_52992;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1 = (function (state_52967){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_52967);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e52993){var ex__2749__auto__ = e52993;
var statearr_52994_53012 = state_52967;
(statearr_52994_53012[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_52967[(4)]))){
var statearr_52995_53013 = state_52967;
(statearr_52995_53013[(1)] = cljs.core.first.call(null,(state_52967[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53014 = state_52967;
state_52967 = G__53014;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__ = function(state_52967){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1.call(this,state_52967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_52996 = f__2769__auto__.call(null);
(statearr_52996[(6)] = c__2768__auto__);

return statearr_52996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__53015 = entry;
var res = cljs.core.nth.call(null,vec__53015,(0),null);
var cost = cljs.core.nth.call(null,vec__53015,(1),null);
fluree.db.util.log.debug.call(null,"Smart function stack: ",res);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.call(null,new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.call(null,new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.call(null,new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53063){
var state_val_53064 = (state_53063[(1)]);
if((state_val_53064 === (7))){
var state_53063__$1 = state_53063;
var statearr_53065_53094 = state_53063__$1;
(statearr_53065_53094[(2)] = coll);

(statearr_53065_53094[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53064 === (1))){
var state_53063__$1 = state_53063;
var statearr_53066_53095 = state_53063__$1;
(statearr_53066_53095[(2)] = null);

(statearr_53066_53095[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53064 === (4))){
var inst_53018 = (state_53063[(2)]);
var state_53063__$1 = state_53063;
var statearr_53067_53096 = state_53063__$1;
(statearr_53067_53096[(2)] = inst_53018);

(statearr_53067_53096[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53064 === (15))){
var inst_53037 = (state_53063[(7)]);
var inst_53045 = (state_53063[(2)]);
var inst_53046 = fluree.db.dbfunctions.internal.nth.call(null,inst_53037,inst_53045);
var inst_53047 = cljs.core.count.call(null,inst_53037);
var inst_53048 = ((9) + inst_53047);
var inst_53049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53050 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53052 = [inst_53037,inst_53045];
var inst_53053 = (new cljs.core.PersistentVector(null,2,(5),inst_53051,inst_53052,null));
var inst_53054 = ["nth",inst_53053,inst_53046];
var inst_53055 = cljs.core.PersistentHashMap.fromArrays(inst_53050,inst_53054);
var inst_53056 = [inst_53055,inst_53048];
var inst_53057 = (new cljs.core.PersistentVector(null,2,(5),inst_53049,inst_53056,null));
var inst_53058 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53057);
var _ = (function (){var statearr_53068 = state_53063;
(statearr_53068[(4)] = cljs.core.rest.call(null,(state_53063[(4)])));

return statearr_53068;
})();
var state_53063__$1 = (function (){var statearr_53069 = state_53063;
(statearr_53069[(8)] = inst_53058);

return statearr_53069;
})();
var statearr_53070_53097 = state_53063__$1;
(statearr_53070_53097[(2)] = inst_53046);

(statearr_53070_53097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53064 === (13))){
var state_53063__$1 = state_53063;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53063__$1,(16),key);
} else {
if((state_val_53064 === (6))){
var state_53063__$1 = state_53063;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53063__$1,(9),coll);
} else {
if((state_val_53064 === (3))){
var inst_53061 = (state_53063[(2)]);
var state_53063__$1 = state_53063;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53063__$1,inst_53061);
} else {
if((state_val_53064 === (12))){
var inst_53037 = (state_53063[(2)]);
var inst_53038 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_53063__$1 = (function (){var statearr_53071 = state_53063;
(statearr_53071[(7)] = inst_53037);

return statearr_53071;
})();
if(inst_53038){
var statearr_53072_53098 = state_53063__$1;
(statearr_53072_53098[(1)] = (13));

} else {
var statearr_53073_53099 = state_53063__$1;
(statearr_53073_53099[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53064 === (2))){
var _ = (function (){var statearr_53074 = state_53063;
(statearr_53074[(4)] = cljs.core.cons.call(null,(5),(state_53063[(4)])));

return statearr_53074;
})();
var inst_53024 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_53063__$1 = state_53063;
if(inst_53024){
var statearr_53075_53100 = state_53063__$1;
(statearr_53075_53100[(1)] = (6));

} else {
var statearr_53076_53101 = state_53063__$1;
(statearr_53076_53101[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53064 === (11))){
var inst_53031 = (state_53063[(9)]);
var state_53063__$1 = state_53063;
var statearr_53078_53102 = state_53063__$1;
(statearr_53078_53102[(2)] = inst_53031);

(statearr_53078_53102[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53064 === (9))){
var inst_53027 = (state_53063[(2)]);
var inst_53028 = fluree.db.util.async.throw_err.call(null,inst_53027);
var state_53063__$1 = state_53063;
var statearr_53079_53103 = state_53063__$1;
(statearr_53079_53103[(2)] = inst_53028);

(statearr_53079_53103[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53064 === (5))){
var _ = (function (){var statearr_53080 = state_53063;
(statearr_53080[(4)] = cljs.core.rest.call(null,(state_53063[(4)])));

return statearr_53080;
})();
var state_53063__$1 = state_53063;
var ex53077 = (state_53063__$1[(2)]);
var statearr_53081_53104 = state_53063__$1;
(statearr_53081_53104[(5)] = ex53077);


if((ex53077 instanceof Error)){
var statearr_53082_53105 = state_53063__$1;
(statearr_53082_53105[(1)] = (4));

(statearr_53082_53105[(5)] = null);

} else {
throw ex53077;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53064 === (14))){
var state_53063__$1 = state_53063;
var statearr_53083_53106 = state_53063__$1;
(statearr_53083_53106[(2)] = key);

(statearr_53083_53106[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53064 === (16))){
var inst_53041 = (state_53063[(2)]);
var inst_53042 = fluree.db.util.async.throw_err.call(null,inst_53041);
var state_53063__$1 = state_53063;
var statearr_53084_53107 = state_53063__$1;
(statearr_53084_53107[(2)] = inst_53042);

(statearr_53084_53107[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53064 === (10))){
var inst_53031 = (state_53063[(9)]);
var inst_53034 = cljs.core.vec.call(null,inst_53031);
var state_53063__$1 = state_53063;
var statearr_53085_53108 = state_53063__$1;
(statearr_53085_53108[(2)] = inst_53034);

(statearr_53085_53108[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53064 === (8))){
var inst_53031 = (state_53063[(9)]);
var inst_53031__$1 = (state_53063[(2)]);
var inst_53032 = cljs.core.set_QMARK_.call(null,inst_53031__$1);
var state_53063__$1 = (function (){var statearr_53086 = state_53063;
(statearr_53086[(9)] = inst_53031__$1);

return statearr_53086;
})();
if(inst_53032){
var statearr_53087_53109 = state_53063__$1;
(statearr_53087_53109[(1)] = (10));

} else {
var statearr_53088_53110 = state_53063__$1;
(statearr_53088_53110[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0 = (function (){
var statearr_53089 = [null,null,null,null,null,null,null,null,null,null];
(statearr_53089[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__);

(statearr_53089[(1)] = (1));

return statearr_53089;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1 = (function (state_53063){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53063);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53090){var ex__2749__auto__ = e53090;
var statearr_53091_53111 = state_53063;
(statearr_53091_53111[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53063[(4)]))){
var statearr_53092_53112 = state_53063;
(statearr_53092_53112[(1)] = cljs.core.first.call(null,(state_53063[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53113 = state_53063;
state_53063 = G__53113;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__ = function(state_53063){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1.call(this,state_53063);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53093 = f__2769__auto__.call(null);
(statearr_53093[(6)] = c__2768__auto__);

return statearr_53093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53174){
var state_val_53175 = (state_53174[(1)]);
if((state_val_53175 === (7))){
var state_53174__$1 = state_53174;
var statearr_53176_53210 = state_53174__$1;
(statearr_53176_53210[(2)] = test);

(statearr_53176_53210[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53175 === (20))){
var inst_53148 = (state_53174[(2)]);
var inst_53149 = fluree.db.util.async.throw_err.call(null,inst_53148);
var state_53174__$1 = state_53174;
var statearr_53177_53211 = state_53174__$1;
(statearr_53177_53211[(2)] = inst_53149);

(statearr_53177_53211[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53175 === (1))){
var state_53174__$1 = state_53174;
var statearr_53178_53212 = state_53174__$1;
(statearr_53178_53212[(2)] = null);

(statearr_53178_53212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53175 === (4))){
var inst_53114 = (state_53174[(2)]);
var state_53174__$1 = state_53174;
var statearr_53179_53213 = state_53174__$1;
(statearr_53179_53213[(2)] = inst_53114);

(statearr_53179_53213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53175 === (15))){
var inst_53132 = (state_53174[(7)]);
var inst_53140 = (state_53174[(2)]);
var inst_53141 = [inst_53140,f];
var inst_53142 = (new cljs.core.PersistentVector(null,2,(5),inst_53132,inst_53141,null));
var state_53174__$1 = state_53174;
var statearr_53180_53214 = state_53174__$1;
(statearr_53180_53214[(2)] = inst_53142);

(statearr_53180_53214[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53175 === (13))){
var state_53174__$1 = state_53174;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53174__$1,(16),t);
} else {
if((state_val_53175 === (6))){
var state_53174__$1 = state_53174;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53174__$1,(9),test);
} else {
if((state_val_53175 === (17))){
var state_53174__$1 = state_53174;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53174__$1,(20),f);
} else {
if((state_val_53175 === (3))){
var inst_53172 = (state_53174[(2)]);
var state_53174__$1 = state_53174;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53174__$1,inst_53172);
} else {
if((state_val_53175 === (12))){
var inst_53130 = (state_53174[(8)]);
var inst_53156 = (state_53174[(2)]);
var inst_53157 = cljs.core.nth.call(null,inst_53156,(0),null);
var inst_53158 = cljs.core.nth.call(null,inst_53156,(1),null);
var inst_53159 = fluree.db.dbfunctions.internal.if_else.call(null,inst_53130,inst_53157,inst_53158);
var inst_53160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53161 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53163 = [inst_53130,inst_53157,inst_53158];
var inst_53164 = (new cljs.core.PersistentVector(null,3,(5),inst_53162,inst_53163,null));
var inst_53165 = ["if-else",inst_53164,inst_53159];
var inst_53166 = cljs.core.PersistentHashMap.fromArrays(inst_53161,inst_53165);
var inst_53167 = [inst_53166,(10)];
var inst_53168 = (new cljs.core.PersistentVector(null,2,(5),inst_53160,inst_53167,null));
var inst_53169 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53168);
var _ = (function (){var statearr_53181 = state_53174;
(statearr_53181[(4)] = cljs.core.rest.call(null,(state_53174[(4)])));

return statearr_53181;
})();
var state_53174__$1 = (function (){var statearr_53182 = state_53174;
(statearr_53182[(9)] = inst_53169);

return statearr_53182;
})();
var statearr_53183_53215 = state_53174__$1;
(statearr_53183_53215[(2)] = inst_53159);

(statearr_53183_53215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53175 === (2))){
var _ = (function (){var statearr_53184 = state_53174;
(statearr_53184[(4)] = cljs.core.cons.call(null,(5),(state_53174[(4)])));

return statearr_53184;
})();
var inst_53123 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_53174__$1 = state_53174;
if(inst_53123){
var statearr_53185_53216 = state_53174__$1;
(statearr_53185_53216[(1)] = (6));

} else {
var statearr_53186_53217 = state_53174__$1;
(statearr_53186_53217[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53175 === (19))){
var inst_53144 = (state_53174[(10)]);
var inst_53152 = (state_53174[(2)]);
var inst_53153 = [f,inst_53152];
var inst_53154 = (new cljs.core.PersistentVector(null,2,(5),inst_53144,inst_53153,null));
var state_53174__$1 = state_53174;
var statearr_53187_53218 = state_53174__$1;
(statearr_53187_53218[(2)] = inst_53154);

(statearr_53187_53218[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53175 === (11))){
var inst_53144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53145 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_53174__$1 = (function (){var statearr_53189 = state_53174;
(statearr_53189[(10)] = inst_53144);

return statearr_53189;
})();
if(inst_53145){
var statearr_53190_53219 = state_53174__$1;
(statearr_53190_53219[(1)] = (17));

} else {
var statearr_53191_53220 = state_53174__$1;
(statearr_53191_53220[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53175 === (9))){
var inst_53126 = (state_53174[(2)]);
var inst_53127 = fluree.db.util.async.throw_err.call(null,inst_53126);
var state_53174__$1 = state_53174;
var statearr_53192_53221 = state_53174__$1;
(statearr_53192_53221[(2)] = inst_53127);

(statearr_53192_53221[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53175 === (5))){
var _ = (function (){var statearr_53193 = state_53174;
(statearr_53193[(4)] = cljs.core.rest.call(null,(state_53174[(4)])));

return statearr_53193;
})();
var state_53174__$1 = state_53174;
var ex53188 = (state_53174__$1[(2)]);
var statearr_53194_53222 = state_53174__$1;
(statearr_53194_53222[(5)] = ex53188);


if((ex53188 instanceof Error)){
var statearr_53195_53223 = state_53174__$1;
(statearr_53195_53223[(1)] = (4));

(statearr_53195_53223[(5)] = null);

} else {
throw ex53188;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53175 === (14))){
var state_53174__$1 = state_53174;
var statearr_53196_53224 = state_53174__$1;
(statearr_53196_53224[(2)] = t);

(statearr_53196_53224[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53175 === (16))){
var inst_53136 = (state_53174[(2)]);
var inst_53137 = fluree.db.util.async.throw_err.call(null,inst_53136);
var state_53174__$1 = state_53174;
var statearr_53197_53225 = state_53174__$1;
(statearr_53197_53225[(2)] = inst_53137);

(statearr_53197_53225[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53175 === (10))){
var inst_53132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53133 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_53174__$1 = (function (){var statearr_53198 = state_53174;
(statearr_53198[(7)] = inst_53132);

return statearr_53198;
})();
if(inst_53133){
var statearr_53199_53226 = state_53174__$1;
(statearr_53199_53226[(1)] = (13));

} else {
var statearr_53200_53227 = state_53174__$1;
(statearr_53200_53227[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53175 === (18))){
var state_53174__$1 = state_53174;
var statearr_53201_53228 = state_53174__$1;
(statearr_53201_53228[(2)] = f);

(statearr_53201_53228[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53175 === (8))){
var inst_53130 = (state_53174[(8)]);
var inst_53130__$1 = (state_53174[(2)]);
var state_53174__$1 = (function (){var statearr_53202 = state_53174;
(statearr_53202[(8)] = inst_53130__$1);

return statearr_53202;
})();
if(cljs.core.truth_(inst_53130__$1)){
var statearr_53203_53229 = state_53174__$1;
(statearr_53203_53229[(1)] = (10));

} else {
var statearr_53204_53230 = state_53174__$1;
(statearr_53204_53230[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0 = (function (){
var statearr_53205 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_53205[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__);

(statearr_53205[(1)] = (1));

return statearr_53205;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1 = (function (state_53174){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53174);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53206){var ex__2749__auto__ = e53206;
var statearr_53207_53231 = state_53174;
(statearr_53207_53231[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53174[(4)]))){
var statearr_53208_53232 = state_53174;
(statearr_53208_53232[(1)] = cljs.core.first.call(null,(state_53174[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53233 = state_53174;
state_53174 = G__53233;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__ = function(state_53174){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1.call(this,state_53174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53209 = f__2769__auto__.call(null);
(statearr_53209[(6)] = c__2768__auto__);

return statearr_53209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53263){
var state_val_53264 = (state_53263[(1)]);
if((state_val_53264 === (7))){
var state_53263__$1 = state_53263;
var statearr_53265_53284 = state_53263__$1;
(statearr_53265_53284[(2)] = arg);

(statearr_53265_53284[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53264 === (1))){
var state_53263__$1 = state_53263;
var statearr_53266_53285 = state_53263__$1;
(statearr_53266_53285[(2)] = null);

(statearr_53266_53285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53264 === (4))){
var inst_53234 = (state_53263[(2)]);
var state_53263__$1 = state_53263;
var statearr_53267_53286 = state_53263__$1;
(statearr_53267_53286[(2)] = inst_53234);

(statearr_53267_53286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53264 === (6))){
var state_53263__$1 = state_53263;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53263__$1,(9),arg);
} else {
if((state_val_53264 === (3))){
var inst_53261 = (state_53263[(2)]);
var state_53263__$1 = state_53263;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53263__$1,inst_53261);
} else {
if((state_val_53264 === (2))){
var _ = (function (){var statearr_53269 = state_53263;
(statearr_53269[(4)] = cljs.core.cons.call(null,(5),(state_53263[(4)])));

return statearr_53269;
})();
var inst_53240 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_53263__$1 = state_53263;
if(inst_53240){
var statearr_53270_53287 = state_53263__$1;
(statearr_53270_53287[(1)] = (6));

} else {
var statearr_53271_53288 = state_53263__$1;
(statearr_53271_53288[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53264 === (9))){
var inst_53243 = (state_53263[(2)]);
var inst_53244 = fluree.db.util.async.throw_err.call(null,inst_53243);
var state_53263__$1 = state_53263;
var statearr_53272_53289 = state_53263__$1;
(statearr_53272_53289[(2)] = inst_53244);

(statearr_53272_53289[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53264 === (5))){
var _ = (function (){var statearr_53273 = state_53263;
(statearr_53273[(4)] = cljs.core.rest.call(null,(state_53263[(4)])));

return statearr_53273;
})();
var state_53263__$1 = state_53263;
var ex53268 = (state_53263__$1[(2)]);
var statearr_53274_53290 = state_53263__$1;
(statearr_53274_53290[(5)] = ex53268);


if((ex53268 instanceof Error)){
var statearr_53275_53291 = state_53263__$1;
(statearr_53275_53291[(1)] = (4));

(statearr_53275_53291[(5)] = null);

} else {
throw ex53268;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53264 === (8))){
var inst_53247 = (state_53263[(2)]);
var inst_53248 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_53247);
var inst_53249 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53250 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53252 = [inst_53247];
var inst_53253 = (new cljs.core.PersistentVector(null,1,(5),inst_53251,inst_53252,null));
var inst_53254 = ["nil?",inst_53253,inst_53248];
var inst_53255 = cljs.core.PersistentHashMap.fromArrays(inst_53250,inst_53254);
var inst_53256 = [inst_53255,(10)];
var inst_53257 = (new cljs.core.PersistentVector(null,2,(5),inst_53249,inst_53256,null));
var inst_53258 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53257);
var _ = (function (){var statearr_53276 = state_53263;
(statearr_53276[(4)] = cljs.core.rest.call(null,(state_53263[(4)])));

return statearr_53276;
})();
var state_53263__$1 = (function (){var statearr_53277 = state_53263;
(statearr_53277[(7)] = inst_53258);

return statearr_53277;
})();
var statearr_53278_53292 = state_53263__$1;
(statearr_53278_53292[(2)] = inst_53248);

(statearr_53278_53292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_53279 = [null,null,null,null,null,null,null,null];
(statearr_53279[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__);

(statearr_53279[(1)] = (1));

return statearr_53279;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1 = (function (state_53263){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53263);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53280){var ex__2749__auto__ = e53280;
var statearr_53281_53293 = state_53263;
(statearr_53281_53293[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53263[(4)]))){
var statearr_53282_53294 = state_53263;
(statearr_53282_53294[(1)] = cljs.core.first.call(null,(state_53263[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53295 = state_53263;
state_53263 = G__53295;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__ = function(state_53263){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1.call(this,state_53263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53283 = f__2769__auto__.call(null);
(statearr_53283[(6)] = c__2768__auto__);

return statearr_53283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53325){
var state_val_53326 = (state_53325[(1)]);
if((state_val_53326 === (7))){
var state_53325__$1 = state_53325;
var statearr_53327_53346 = state_53325__$1;
(statearr_53327_53346[(2)] = arg);

(statearr_53327_53346[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53326 === (1))){
var state_53325__$1 = state_53325;
var statearr_53328_53347 = state_53325__$1;
(statearr_53328_53347[(2)] = null);

(statearr_53328_53347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53326 === (4))){
var inst_53296 = (state_53325[(2)]);
var state_53325__$1 = state_53325;
var statearr_53329_53348 = state_53325__$1;
(statearr_53329_53348[(2)] = inst_53296);

(statearr_53329_53348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53326 === (6))){
var state_53325__$1 = state_53325;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53325__$1,(9),arg);
} else {
if((state_val_53326 === (3))){
var inst_53323 = (state_53325[(2)]);
var state_53325__$1 = state_53325;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53325__$1,inst_53323);
} else {
if((state_val_53326 === (2))){
var _ = (function (){var statearr_53331 = state_53325;
(statearr_53331[(4)] = cljs.core.cons.call(null,(5),(state_53325[(4)])));

return statearr_53331;
})();
var inst_53302 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_53325__$1 = state_53325;
if(inst_53302){
var statearr_53332_53349 = state_53325__$1;
(statearr_53332_53349[(1)] = (6));

} else {
var statearr_53333_53350 = state_53325__$1;
(statearr_53333_53350[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53326 === (9))){
var inst_53305 = (state_53325[(2)]);
var inst_53306 = fluree.db.util.async.throw_err.call(null,inst_53305);
var state_53325__$1 = state_53325;
var statearr_53334_53351 = state_53325__$1;
(statearr_53334_53351[(2)] = inst_53306);

(statearr_53334_53351[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53326 === (5))){
var _ = (function (){var statearr_53335 = state_53325;
(statearr_53335[(4)] = cljs.core.rest.call(null,(state_53325[(4)])));

return statearr_53335;
})();
var state_53325__$1 = state_53325;
var ex53330 = (state_53325__$1[(2)]);
var statearr_53336_53352 = state_53325__$1;
(statearr_53336_53352[(5)] = ex53330);


if((ex53330 instanceof Error)){
var statearr_53337_53353 = state_53325__$1;
(statearr_53337_53353[(1)] = (4));

(statearr_53337_53353[(5)] = null);

} else {
throw ex53330;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53326 === (8))){
var inst_53309 = (state_53325[(2)]);
var inst_53310 = fluree.db.dbfunctions.internal.not.call(null,inst_53309);
var inst_53311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53312 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53314 = [inst_53309];
var inst_53315 = (new cljs.core.PersistentVector(null,1,(5),inst_53313,inst_53314,null));
var inst_53316 = ["not?",inst_53315,inst_53310];
var inst_53317 = cljs.core.PersistentHashMap.fromArrays(inst_53312,inst_53316);
var inst_53318 = [inst_53317,(10)];
var inst_53319 = (new cljs.core.PersistentVector(null,2,(5),inst_53311,inst_53318,null));
var inst_53320 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53319);
var _ = (function (){var statearr_53338 = state_53325;
(statearr_53338[(4)] = cljs.core.rest.call(null,(state_53325[(4)])));

return statearr_53338;
})();
var state_53325__$1 = (function (){var statearr_53339 = state_53325;
(statearr_53339[(7)] = inst_53320);

return statearr_53339;
})();
var statearr_53340_53354 = state_53325__$1;
(statearr_53340_53354[(2)] = inst_53310);

(statearr_53340_53354[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0 = (function (){
var statearr_53341 = [null,null,null,null,null,null,null,null];
(statearr_53341[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__);

(statearr_53341[(1)] = (1));

return statearr_53341;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1 = (function (state_53325){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53325);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53342){var ex__2749__auto__ = e53342;
var statearr_53343_53355 = state_53325;
(statearr_53343_53355[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53325[(4)]))){
var statearr_53344_53356 = state_53325;
(statearr_53344_53356[(1)] = cljs.core.first.call(null,(state_53325[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53357 = state_53325;
state_53325 = G__53357;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__ = function(state_53325){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1.call(this,state_53325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53345 = f__2769__auto__.call(null);
(statearr_53345[(6)] = c__2768__auto__);

return statearr_53345;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53387){
var state_val_53388 = (state_53387[(1)]);
if((state_val_53388 === (7))){
var state_53387__$1 = state_53387;
var statearr_53389_53408 = state_53387__$1;
(statearr_53389_53408[(2)] = arg);

(statearr_53389_53408[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53388 === (1))){
var state_53387__$1 = state_53387;
var statearr_53390_53409 = state_53387__$1;
(statearr_53390_53409[(2)] = null);

(statearr_53390_53409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53388 === (4))){
var inst_53358 = (state_53387[(2)]);
var state_53387__$1 = state_53387;
var statearr_53391_53410 = state_53387__$1;
(statearr_53391_53410[(2)] = inst_53358);

(statearr_53391_53410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53388 === (6))){
var state_53387__$1 = state_53387;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53387__$1,(9),arg);
} else {
if((state_val_53388 === (3))){
var inst_53385 = (state_53387[(2)]);
var state_53387__$1 = state_53387;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53387__$1,inst_53385);
} else {
if((state_val_53388 === (2))){
var _ = (function (){var statearr_53393 = state_53387;
(statearr_53393[(4)] = cljs.core.cons.call(null,(5),(state_53387[(4)])));

return statearr_53393;
})();
var inst_53364 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_53387__$1 = state_53387;
if(inst_53364){
var statearr_53394_53411 = state_53387__$1;
(statearr_53394_53411[(1)] = (6));

} else {
var statearr_53395_53412 = state_53387__$1;
(statearr_53395_53412[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53388 === (9))){
var inst_53367 = (state_53387[(2)]);
var inst_53368 = fluree.db.util.async.throw_err.call(null,inst_53367);
var state_53387__$1 = state_53387;
var statearr_53396_53413 = state_53387__$1;
(statearr_53396_53413[(2)] = inst_53368);

(statearr_53396_53413[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53388 === (5))){
var _ = (function (){var statearr_53397 = state_53387;
(statearr_53397[(4)] = cljs.core.rest.call(null,(state_53387[(4)])));

return statearr_53397;
})();
var state_53387__$1 = state_53387;
var ex53392 = (state_53387__$1[(2)]);
var statearr_53398_53414 = state_53387__$1;
(statearr_53398_53414[(5)] = ex53392);


if((ex53392 instanceof Error)){
var statearr_53399_53415 = state_53387__$1;
(statearr_53399_53415[(1)] = (4));

(statearr_53399_53415[(5)] = null);

} else {
throw ex53392;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53388 === (8))){
var inst_53371 = (state_53387[(2)]);
var inst_53372 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_53371);
var inst_53373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53374 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53376 = [inst_53371];
var inst_53377 = (new cljs.core.PersistentVector(null,1,(5),inst_53375,inst_53376,null));
var inst_53378 = ["empty?",inst_53377,inst_53372];
var inst_53379 = cljs.core.PersistentHashMap.fromArrays(inst_53374,inst_53378);
var inst_53380 = [inst_53379,(10)];
var inst_53381 = (new cljs.core.PersistentVector(null,2,(5),inst_53373,inst_53380,null));
var inst_53382 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53381);
var _ = (function (){var statearr_53400 = state_53387;
(statearr_53400[(4)] = cljs.core.rest.call(null,(state_53387[(4)])));

return statearr_53400;
})();
var state_53387__$1 = (function (){var statearr_53401 = state_53387;
(statearr_53401[(7)] = inst_53382);

return statearr_53401;
})();
var statearr_53402_53416 = state_53387__$1;
(statearr_53402_53416[(2)] = inst_53372);

(statearr_53402_53416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_53403 = [null,null,null,null,null,null,null,null];
(statearr_53403[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__);

(statearr_53403[(1)] = (1));

return statearr_53403;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1 = (function (state_53387){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53387);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53404){var ex__2749__auto__ = e53404;
var statearr_53405_53417 = state_53387;
(statearr_53405_53417[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53387[(4)]))){
var statearr_53406_53418 = state_53387;
(statearr_53406_53418[(1)] = cljs.core.first.call(null,(state_53387[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53419 = state_53387;
state_53387 = G__53419;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__ = function(state_53387){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1.call(this,state_53387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53407 = f__2769__auto__.call(null);
(statearr_53407[(6)] = c__2768__auto__);

return statearr_53407;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___53464 = arguments.length;
var i__4865__auto___53465 = (0);
while(true){
if((i__4865__auto___53465 < len__4864__auto___53464)){
args__4870__auto__.push((arguments[i__4865__auto___53465]));

var G__53466 = (i__4865__auto___53465 + (1));
i__4865__auto___53465 = G__53466;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53447){
var state_val_53448 = (state_53447[(1)]);
if((state_val_53448 === (1))){
var state_53447__$1 = state_53447;
var statearr_53449_53467 = state_53447__$1;
(statearr_53449_53467[(2)] = null);

(statearr_53449_53467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53448 === (2))){
var _ = (function (){var statearr_53450 = state_53447;
(statearr_53450[(4)] = cljs.core.cons.call(null,(5),(state_53447[(4)])));

return statearr_53450;
})();
var inst_53428 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_53447__$1 = state_53447;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53447__$1,(6),inst_53428);
} else {
if((state_val_53448 === (3))){
var inst_53445 = (state_53447[(2)]);
var state_53447__$1 = state_53447;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53447__$1,inst_53445);
} else {
if((state_val_53448 === (4))){
var inst_53422 = (state_53447[(2)]);
var state_53447__$1 = state_53447;
var statearr_53452_53468 = state_53447__$1;
(statearr_53452_53468[(2)] = inst_53422);

(statearr_53452_53468[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53448 === (5))){
var _ = (function (){var statearr_53453 = state_53447;
(statearr_53453[(4)] = cljs.core.rest.call(null,(state_53447[(4)])));

return statearr_53453;
})();
var state_53447__$1 = state_53447;
var ex53451 = (state_53447__$1[(2)]);
var statearr_53454_53469 = state_53447__$1;
(statearr_53454_53469[(5)] = ex53451);


if((ex53451 instanceof Error)){
var statearr_53455_53470 = state_53447__$1;
(statearr_53455_53470[(1)] = (4));

(statearr_53455_53470[(5)] = null);

} else {
throw ex53451;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53448 === (6))){
var inst_53430 = (state_53447[(2)]);
var inst_53431 = fluree.db.util.async.throw_err.call(null,inst_53430);
var inst_53432 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_53431);
var inst_53433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53434 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53435 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53436 = [inst_53431];
var inst_53437 = (new cljs.core.PersistentVector(null,1,(5),inst_53435,inst_53436,null));
var inst_53438 = ["str",inst_53437,inst_53432];
var inst_53439 = cljs.core.PersistentHashMap.fromArrays(inst_53434,inst_53438);
var inst_53440 = [inst_53439,(10)];
var inst_53441 = (new cljs.core.PersistentVector(null,2,(5),inst_53433,inst_53440,null));
var inst_53442 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53441);
var _ = (function (){var statearr_53456 = state_53447;
(statearr_53456[(4)] = cljs.core.rest.call(null,(state_53447[(4)])));

return statearr_53456;
})();
var state_53447__$1 = (function (){var statearr_53457 = state_53447;
(statearr_53457[(7)] = inst_53442);

return statearr_53457;
})();
var statearr_53458_53471 = state_53447__$1;
(statearr_53458_53471[(2)] = inst_53432);

(statearr_53458_53471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_53459 = [null,null,null,null,null,null,null,null];
(statearr_53459[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_53459[(1)] = (1));

return statearr_53459;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_53447){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53447);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53460){var ex__2749__auto__ = e53460;
var statearr_53461_53472 = state_53447;
(statearr_53461_53472[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53447[(4)]))){
var statearr_53462_53473 = state_53447;
(statearr_53462_53473[(1)] = cljs.core.first.call(null,(state_53447[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53474 = state_53447;
state_53447 = G__53474;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_53447){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_53447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53463 = f__2769__auto__.call(null);
(statearr_53463[(6)] = c__2768__auto__);

return statearr_53463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq53420){
var G__53421 = cljs.core.first.call(null,seq53420);
var seq53420__$1 = cljs.core.next.call(null,seq53420);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53421,seq53420__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53500){
var state_val_53501 = (state_53500[(1)]);
if((state_val_53501 === (1))){
var state_53500__$1 = state_53500;
var statearr_53502_53517 = state_53500__$1;
(statearr_53502_53517[(2)] = null);

(statearr_53502_53517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53501 === (2))){
var _ = (function (){var statearr_53503 = state_53500;
(statearr_53503[(4)] = cljs.core.cons.call(null,(5),(state_53500[(4)])));

return statearr_53503;
})();
var inst_53481 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_53500__$1 = state_53500;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53500__$1,(6),inst_53481);
} else {
if((state_val_53501 === (3))){
var inst_53498 = (state_53500[(2)]);
var state_53500__$1 = state_53500;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53500__$1,inst_53498);
} else {
if((state_val_53501 === (4))){
var inst_53475 = (state_53500[(2)]);
var state_53500__$1 = state_53500;
var statearr_53505_53518 = state_53500__$1;
(statearr_53505_53518[(2)] = inst_53475);

(statearr_53505_53518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53501 === (5))){
var _ = (function (){var statearr_53506 = state_53500;
(statearr_53506[(4)] = cljs.core.rest.call(null,(state_53500[(4)])));

return statearr_53506;
})();
var state_53500__$1 = state_53500;
var ex53504 = (state_53500__$1[(2)]);
var statearr_53507_53519 = state_53500__$1;
(statearr_53507_53519[(5)] = ex53504);


if((ex53504 instanceof Error)){
var statearr_53508_53520 = state_53500__$1;
(statearr_53508_53520[(1)] = (4));

(statearr_53508_53520[(5)] = null);

} else {
throw ex53504;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53501 === (6))){
var inst_53483 = (state_53500[(2)]);
var inst_53484 = fluree.db.util.async.throw_err.call(null,inst_53483);
var inst_53485 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.subs,inst_53484);
var inst_53486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53487 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53489 = [inst_53484];
var inst_53490 = (new cljs.core.PersistentVector(null,1,(5),inst_53488,inst_53489,null));
var inst_53491 = ["subs",inst_53490,inst_53485];
var inst_53492 = cljs.core.PersistentHashMap.fromArrays(inst_53487,inst_53491);
var inst_53493 = [inst_53492,(30)];
var inst_53494 = (new cljs.core.PersistentVector(null,2,(5),inst_53486,inst_53493,null));
var inst_53495 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53494);
var _ = (function (){var statearr_53509 = state_53500;
(statearr_53509[(4)] = cljs.core.rest.call(null,(state_53500[(4)])));

return statearr_53509;
})();
var state_53500__$1 = (function (){var statearr_53510 = state_53500;
(statearr_53510[(7)] = inst_53495);

return statearr_53510;
})();
var statearr_53511_53521 = state_53500__$1;
(statearr_53511_53521[(2)] = inst_53485);

(statearr_53511_53521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0 = (function (){
var statearr_53512 = [null,null,null,null,null,null,null,null];
(statearr_53512[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__);

(statearr_53512[(1)] = (1));

return statearr_53512;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1 = (function (state_53500){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53500);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53513){var ex__2749__auto__ = e53513;
var statearr_53514_53522 = state_53500;
(statearr_53514_53522[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53500[(4)]))){
var statearr_53515_53523 = state_53500;
(statearr_53515_53523[(1)] = cljs.core.first.call(null,(state_53500[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53524 = state_53500;
state_53500 = G__53524;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__ = function(state_53500){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1.call(this,state_53500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53516 = f__2769__auto__.call(null);
(statearr_53516[(6)] = c__2768__auto__);

return statearr_53516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53554){
var state_val_53555 = (state_53554[(1)]);
if((state_val_53555 === (7))){
var state_53554__$1 = state_53554;
var statearr_53556_53575 = state_53554__$1;
(statearr_53556_53575[(2)] = str);

(statearr_53556_53575[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53555 === (1))){
var state_53554__$1 = state_53554;
var statearr_53557_53576 = state_53554__$1;
(statearr_53557_53576[(2)] = null);

(statearr_53557_53576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53555 === (4))){
var inst_53525 = (state_53554[(2)]);
var state_53554__$1 = state_53554;
var statearr_53558_53577 = state_53554__$1;
(statearr_53558_53577[(2)] = inst_53525);

(statearr_53558_53577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53555 === (6))){
var state_53554__$1 = state_53554;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53554__$1,(9),str);
} else {
if((state_val_53555 === (3))){
var inst_53552 = (state_53554[(2)]);
var state_53554__$1 = state_53554;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53554__$1,inst_53552);
} else {
if((state_val_53555 === (2))){
var _ = (function (){var statearr_53560 = state_53554;
(statearr_53560[(4)] = cljs.core.cons.call(null,(5),(state_53554[(4)])));

return statearr_53560;
})();
var inst_53531 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_53554__$1 = state_53554;
if(inst_53531){
var statearr_53561_53578 = state_53554__$1;
(statearr_53561_53578[(1)] = (6));

} else {
var statearr_53562_53579 = state_53554__$1;
(statearr_53562_53579[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53555 === (9))){
var inst_53534 = (state_53554[(2)]);
var inst_53535 = fluree.db.util.async.throw_err.call(null,inst_53534);
var state_53554__$1 = state_53554;
var statearr_53563_53580 = state_53554__$1;
(statearr_53563_53580[(2)] = inst_53535);

(statearr_53563_53580[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53555 === (5))){
var _ = (function (){var statearr_53564 = state_53554;
(statearr_53564[(4)] = cljs.core.rest.call(null,(state_53554[(4)])));

return statearr_53564;
})();
var state_53554__$1 = state_53554;
var ex53559 = (state_53554__$1[(2)]);
var statearr_53565_53581 = state_53554__$1;
(statearr_53565_53581[(5)] = ex53559);


if((ex53559 instanceof Error)){
var statearr_53566_53582 = state_53554__$1;
(statearr_53566_53582[(1)] = (4));

(statearr_53566_53582[(5)] = null);

} else {
throw ex53559;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53555 === (8))){
var inst_53538 = (state_53554[(2)]);
var inst_53539 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_53538);
var inst_53540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53541 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53543 = [inst_53538];
var inst_53544 = (new cljs.core.PersistentVector(null,1,(5),inst_53542,inst_53543,null));
var inst_53545 = ["lower-case",inst_53544,inst_53539];
var inst_53546 = cljs.core.PersistentHashMap.fromArrays(inst_53541,inst_53545);
var inst_53547 = [inst_53546,(10)];
var inst_53548 = (new cljs.core.PersistentVector(null,2,(5),inst_53540,inst_53547,null));
var inst_53549 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53548);
var _ = (function (){var statearr_53567 = state_53554;
(statearr_53567[(4)] = cljs.core.rest.call(null,(state_53554[(4)])));

return statearr_53567;
})();
var state_53554__$1 = (function (){var statearr_53568 = state_53554;
(statearr_53568[(7)] = inst_53549);

return statearr_53568;
})();
var statearr_53569_53583 = state_53554__$1;
(statearr_53569_53583[(2)] = inst_53539);

(statearr_53569_53583[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0 = (function (){
var statearr_53570 = [null,null,null,null,null,null,null,null];
(statearr_53570[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__);

(statearr_53570[(1)] = (1));

return statearr_53570;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1 = (function (state_53554){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53554);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53571){var ex__2749__auto__ = e53571;
var statearr_53572_53584 = state_53554;
(statearr_53572_53584[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53554[(4)]))){
var statearr_53573_53585 = state_53554;
(statearr_53573_53585[(1)] = cljs.core.first.call(null,(state_53554[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53586 = state_53554;
state_53554 = G__53586;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__ = function(state_53554){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1.call(this,state_53554);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53574 = f__2769__auto__.call(null);
(statearr_53574[(6)] = c__2768__auto__);

return statearr_53574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53616){
var state_val_53617 = (state_53616[(1)]);
if((state_val_53617 === (7))){
var state_53616__$1 = state_53616;
var statearr_53618_53637 = state_53616__$1;
(statearr_53618_53637[(2)] = str);

(statearr_53618_53637[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53617 === (1))){
var state_53616__$1 = state_53616;
var statearr_53619_53638 = state_53616__$1;
(statearr_53619_53638[(2)] = null);

(statearr_53619_53638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53617 === (4))){
var inst_53587 = (state_53616[(2)]);
var state_53616__$1 = state_53616;
var statearr_53620_53639 = state_53616__$1;
(statearr_53620_53639[(2)] = inst_53587);

(statearr_53620_53639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53617 === (6))){
var state_53616__$1 = state_53616;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53616__$1,(9),str);
} else {
if((state_val_53617 === (3))){
var inst_53614 = (state_53616[(2)]);
var state_53616__$1 = state_53616;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53616__$1,inst_53614);
} else {
if((state_val_53617 === (2))){
var _ = (function (){var statearr_53622 = state_53616;
(statearr_53622[(4)] = cljs.core.cons.call(null,(5),(state_53616[(4)])));

return statearr_53622;
})();
var inst_53593 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_53616__$1 = state_53616;
if(inst_53593){
var statearr_53623_53640 = state_53616__$1;
(statearr_53623_53640[(1)] = (6));

} else {
var statearr_53624_53641 = state_53616__$1;
(statearr_53624_53641[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53617 === (9))){
var inst_53596 = (state_53616[(2)]);
var inst_53597 = fluree.db.util.async.throw_err.call(null,inst_53596);
var state_53616__$1 = state_53616;
var statearr_53625_53642 = state_53616__$1;
(statearr_53625_53642[(2)] = inst_53597);

(statearr_53625_53642[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53617 === (5))){
var _ = (function (){var statearr_53626 = state_53616;
(statearr_53626[(4)] = cljs.core.rest.call(null,(state_53616[(4)])));

return statearr_53626;
})();
var state_53616__$1 = state_53616;
var ex53621 = (state_53616__$1[(2)]);
var statearr_53627_53643 = state_53616__$1;
(statearr_53627_53643[(5)] = ex53621);


if((ex53621 instanceof Error)){
var statearr_53628_53644 = state_53616__$1;
(statearr_53628_53644[(1)] = (4));

(statearr_53628_53644[(5)] = null);

} else {
throw ex53621;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53617 === (8))){
var inst_53600 = (state_53616[(2)]);
var inst_53601 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_53600);
var inst_53602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53603 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53605 = [inst_53600];
var inst_53606 = (new cljs.core.PersistentVector(null,1,(5),inst_53604,inst_53605,null));
var inst_53607 = ["upper-case",inst_53606,inst_53601];
var inst_53608 = cljs.core.PersistentHashMap.fromArrays(inst_53603,inst_53607);
var inst_53609 = [inst_53608,(10)];
var inst_53610 = (new cljs.core.PersistentVector(null,2,(5),inst_53602,inst_53609,null));
var inst_53611 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53610);
var _ = (function (){var statearr_53629 = state_53616;
(statearr_53629[(4)] = cljs.core.rest.call(null,(state_53616[(4)])));

return statearr_53629;
})();
var state_53616__$1 = (function (){var statearr_53630 = state_53616;
(statearr_53630[(7)] = inst_53611);

return statearr_53630;
})();
var statearr_53631_53645 = state_53616__$1;
(statearr_53631_53645[(2)] = inst_53601);

(statearr_53631_53645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0 = (function (){
var statearr_53632 = [null,null,null,null,null,null,null,null];
(statearr_53632[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__);

(statearr_53632[(1)] = (1));

return statearr_53632;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1 = (function (state_53616){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53616);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53633){var ex__2749__auto__ = e53633;
var statearr_53634_53646 = state_53616;
(statearr_53634_53646[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53616[(4)]))){
var statearr_53635_53647 = state_53616;
(statearr_53635_53647[(1)] = cljs.core.first.call(null,(state_53616[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53648 = state_53616;
state_53616 = G__53648;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__ = function(state_53616){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1.call(this,state_53616);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53636 = f__2769__auto__.call(null);
(statearr_53636[(6)] = c__2768__auto__);

return statearr_53636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4251__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4251__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__53650 = arguments.length;
switch (G__53650) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53678){
var state_val_53679 = (state_53678[(1)]);
if((state_val_53679 === (1))){
var state_53678__$1 = state_53678;
var statearr_53680_53696 = state_53678__$1;
(statearr_53680_53696[(2)] = null);

(statearr_53680_53696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53679 === (2))){
var _ = (function (){var statearr_53681 = state_53678;
(statearr_53681[(4)] = cljs.core.cons.call(null,(5),(state_53678[(4)])));

return statearr_53681;
})();
var inst_53660 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_53678__$1 = state_53678;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53678__$1,(6),inst_53660);
} else {
if((state_val_53679 === (3))){
var inst_53676 = (state_53678[(2)]);
var state_53678__$1 = state_53678;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53678__$1,inst_53676);
} else {
if((state_val_53679 === (4))){
var inst_53651 = (state_53678[(2)]);
var state_53678__$1 = state_53678;
var statearr_53683_53697 = state_53678__$1;
(statearr_53683_53697[(2)] = inst_53651);

(statearr_53683_53697[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53679 === (5))){
var _ = (function (){var statearr_53684 = state_53678;
(statearr_53684[(4)] = cljs.core.rest.call(null,(state_53678[(4)])));

return statearr_53684;
})();
var state_53678__$1 = state_53678;
var ex53682 = (state_53678__$1[(2)]);
var statearr_53685_53698 = state_53678__$1;
(statearr_53685_53698[(5)] = ex53682);


if((ex53682 instanceof Error)){
var statearr_53686_53699 = state_53678__$1;
(statearr_53686_53699[(1)] = (4));

(statearr_53686_53699[(5)] = null);

} else {
throw ex53682;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53679 === (6))){
var inst_53662 = (state_53678[(2)]);
var inst_53663 = fluree.db.util.async.throw_err.call(null,inst_53662);
var inst_53664 = cljs.core.nth.call(null,inst_53663,(0),null);
var inst_53665 = cljs.core.nth.call(null,inst_53663,(1),null);
var inst_53666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53667 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53668 = ["?s","?ctx",inst_53664];
var inst_53669 = cljs.core.PersistentHashMap.fromArrays(inst_53667,inst_53668);
var inst_53670 = ((10) + inst_53665);
var inst_53671 = [inst_53669,inst_53670];
var inst_53672 = (new cljs.core.PersistentVector(null,2,(5),inst_53666,inst_53671,null));
var inst_53673 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53672);
var _ = (function (){var statearr_53687 = state_53678;
(statearr_53687[(4)] = cljs.core.rest.call(null,(state_53678[(4)])));

return statearr_53687;
})();
var state_53678__$1 = (function (){var statearr_53688 = state_53678;
(statearr_53688[(7)] = inst_53673);

return statearr_53688;
})();
var statearr_53689_53700 = state_53678__$1;
(statearr_53689_53700[(2)] = inst_53664);

(statearr_53689_53700[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_53690 = [null,null,null,null,null,null,null,null];
(statearr_53690[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_53690[(1)] = (1));

return statearr_53690;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_53678){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53678);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53691){var ex__2749__auto__ = e53691;
var statearr_53692_53701 = state_53678;
(statearr_53692_53701[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53678[(4)]))){
var statearr_53693_53702 = state_53678;
(statearr_53693_53702[(1)] = cljs.core.first.call(null,(state_53678[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53703 = state_53678;
state_53678 = G__53703;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_53678){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_53678);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53694 = f__2769__auto__.call(null);
(statearr_53694[(6)] = c__2768__auto__);

return statearr_53694;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__53705 = arguments.length;
switch (G__53705) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53743){
var state_val_53744 = (state_53743[(1)]);
if((state_val_53744 === (7))){
var inst_53736 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_53743__$1 = state_53743;
var statearr_53745_53765 = state_53743__$1;
(statearr_53745_53765[(2)] = inst_53736);

(statearr_53745_53765[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53744 === (1))){
var state_53743__$1 = state_53743;
var statearr_53746_53766 = state_53743__$1;
(statearr_53746_53766[(2)] = null);

(statearr_53746_53766[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53744 === (4))){
var inst_53706 = (state_53743[(2)]);
var state_53743__$1 = state_53743;
var statearr_53747_53767 = state_53743__$1;
(statearr_53747_53767[(2)] = inst_53706);

(statearr_53747_53767[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53744 === (6))){
var inst_53717 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_53743__$1 = state_53743;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53743__$1,(10),inst_53717);
} else {
if((state_val_53744 === (3))){
var inst_53741 = (state_53743[(2)]);
var state_53743__$1 = state_53743;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53743__$1,inst_53741);
} else {
if((state_val_53744 === (2))){
var _ = (function (){var statearr_53749 = state_53743;
(statearr_53749[(4)] = cljs.core.cons.call(null,(5),(state_53743[(4)])));

return statearr_53749;
})();
var inst_53712 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_53743__$1 = state_53743;
if(cljs.core.truth_(inst_53712)){
var statearr_53750_53768 = state_53743__$1;
(statearr_53750_53768[(1)] = (6));

} else {
var statearr_53751_53769 = state_53743__$1;
(statearr_53751_53769[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53744 === (9))){
var inst_53723 = (state_53743[(2)]);
var inst_53724 = fluree.db.util.async.throw_err.call(null,inst_53723);
var inst_53725 = cljs.core.nth.call(null,inst_53724,(0),null);
var inst_53726 = cljs.core.nth.call(null,inst_53724,(1),null);
var inst_53727 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53728 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53729 = ["?p","?ctx",inst_53725];
var inst_53730 = cljs.core.PersistentHashMap.fromArrays(inst_53728,inst_53729);
var inst_53731 = ((10) + inst_53726);
var inst_53732 = [inst_53730,inst_53731];
var inst_53733 = (new cljs.core.PersistentVector(null,2,(5),inst_53727,inst_53732,null));
var inst_53734 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53733);
var state_53743__$1 = (function (){var statearr_53752 = state_53743;
(statearr_53752[(7)] = inst_53734);

return statearr_53752;
})();
var statearr_53753_53770 = state_53743__$1;
(statearr_53753_53770[(2)] = inst_53725);

(statearr_53753_53770[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53744 === (5))){
var _ = (function (){var statearr_53754 = state_53743;
(statearr_53754[(4)] = cljs.core.rest.call(null,(state_53743[(4)])));

return statearr_53754;
})();
var state_53743__$1 = state_53743;
var ex53748 = (state_53743__$1[(2)]);
var statearr_53755_53771 = state_53743__$1;
(statearr_53755_53771[(5)] = ex53748);


if((ex53748 instanceof Error)){
var statearr_53756_53772 = state_53743__$1;
(statearr_53756_53772[(1)] = (4));

(statearr_53756_53772[(5)] = null);

} else {
throw ex53748;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53744 === (10))){
var inst_53719 = (state_53743[(2)]);
var inst_53720 = fluree.db.util.async.throw_err.call(null,inst_53719);
var inst_53721 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_53720);
var state_53743__$1 = state_53743;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53743__$1,(9),inst_53721);
} else {
if((state_val_53744 === (8))){
var inst_53738 = (state_53743[(2)]);
var _ = (function (){var statearr_53757 = state_53743;
(statearr_53757[(4)] = cljs.core.rest.call(null,(state_53743[(4)])));

return statearr_53757;
})();
var state_53743__$1 = state_53743;
var statearr_53758_53773 = state_53743__$1;
(statearr_53758_53773[(2)] = inst_53738);

(statearr_53758_53773[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_53759 = [null,null,null,null,null,null,null,null];
(statearr_53759[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_53759[(1)] = (1));

return statearr_53759;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_53743){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53743);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53760){var ex__2749__auto__ = e53760;
var statearr_53761_53774 = state_53743;
(statearr_53761_53774[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53743[(4)]))){
var statearr_53762_53775 = state_53743;
(statearr_53762_53775[(1)] = cljs.core.first.call(null,(state_53743[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53776 = state_53743;
state_53743 = G__53776;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_53743){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_53743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53763 = f__2769__auto__.call(null);
(statearr_53763[(6)] = c__2768__auto__);

return statearr_53763;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4870__auto__ = [];
var len__4864__auto___53825 = arguments.length;
var i__4865__auto___53826 = (0);
while(true){
if((i__4865__auto___53826 < len__4864__auto___53825)){
args__4870__auto__.push((arguments[i__4865__auto___53826]));

var G__53827 = (i__4865__auto___53826 + (1));
i__4865__auto___53826 = G__53827;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53808){
var state_val_53809 = (state_53808[(1)]);
if((state_val_53809 === (1))){
var state_53808__$1 = state_53808;
var statearr_53810_53828 = state_53808__$1;
(statearr_53810_53828[(2)] = null);

(statearr_53810_53828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53809 === (2))){
var _ = (function (){var statearr_53811 = state_53808;
(statearr_53811[(4)] = cljs.core.cons.call(null,(5),(state_53808[(4)])));

return statearr_53811;
})();
var inst_53785 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_53808__$1 = state_53808;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53808__$1,(6),inst_53785);
} else {
if((state_val_53809 === (3))){
var inst_53806 = (state_53808[(2)]);
var state_53808__$1 = state_53808;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53808__$1,inst_53806);
} else {
if((state_val_53809 === (4))){
var inst_53779 = (state_53808[(2)]);
var state_53808__$1 = state_53808;
var statearr_53813_53829 = state_53808__$1;
(statearr_53813_53829[(2)] = inst_53779);

(statearr_53813_53829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53809 === (5))){
var _ = (function (){var statearr_53814 = state_53808;
(statearr_53814[(4)] = cljs.core.rest.call(null,(state_53808[(4)])));

return statearr_53814;
})();
var state_53808__$1 = state_53808;
var ex53812 = (state_53808__$1[(2)]);
var statearr_53815_53830 = state_53808__$1;
(statearr_53815_53830[(5)] = ex53812);


if((ex53812 instanceof Error)){
var statearr_53816_53831 = state_53808__$1;
(statearr_53816_53831[(1)] = (4));

(statearr_53816_53831[(5)] = null);

} else {
throw ex53812;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53809 === (6))){
var inst_53787 = (state_53808[(2)]);
var inst_53788 = fluree.db.util.async.throw_err.call(null,inst_53787);
var inst_53789 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_53788);
var inst_53790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53791 = [inst_53788];
var inst_53792 = (new cljs.core.PersistentVector(null,1,(5),inst_53790,inst_53791,null));
var inst_53793 = cljs.core.count.call(null,inst_53792);
var inst_53794 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53795 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53797 = [inst_53788];
var inst_53798 = (new cljs.core.PersistentVector(null,1,(5),inst_53796,inst_53797,null));
var inst_53799 = ["and",inst_53798,inst_53789];
var inst_53800 = cljs.core.PersistentHashMap.fromArrays(inst_53795,inst_53799);
var inst_53801 = [inst_53800,inst_53793];
var inst_53802 = (new cljs.core.PersistentVector(null,2,(5),inst_53794,inst_53801,null));
var inst_53803 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53802);
var _ = (function (){var statearr_53817 = state_53808;
(statearr_53817[(4)] = cljs.core.rest.call(null,(state_53808[(4)])));

return statearr_53817;
})();
var state_53808__$1 = (function (){var statearr_53818 = state_53808;
(statearr_53818[(7)] = inst_53803);

return statearr_53818;
})();
var statearr_53819_53832 = state_53808__$1;
(statearr_53819_53832[(2)] = inst_53789);

(statearr_53819_53832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_53820 = [null,null,null,null,null,null,null,null];
(statearr_53820[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_53820[(1)] = (1));

return statearr_53820;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_53808){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53808);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53821){var ex__2749__auto__ = e53821;
var statearr_53822_53833 = state_53808;
(statearr_53822_53833[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53808[(4)]))){
var statearr_53823_53834 = state_53808;
(statearr_53823_53834[(1)] = cljs.core.first.call(null,(state_53808[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53835 = state_53808;
state_53808 = G__53835;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_53808){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_53808);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53824 = f__2769__auto__.call(null);
(statearr_53824[(6)] = c__2768__auto__);

return statearr_53824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq53777){
var G__53778 = cljs.core.first.call(null,seq53777);
var seq53777__$1 = cljs.core.next.call(null,seq53777);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53778,seq53777__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4870__auto__ = [];
var len__4864__auto___53884 = arguments.length;
var i__4865__auto___53885 = (0);
while(true){
if((i__4865__auto___53885 < len__4864__auto___53884)){
args__4870__auto__.push((arguments[i__4865__auto___53885]));

var G__53886 = (i__4865__auto___53885 + (1));
i__4865__auto___53885 = G__53886;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53867){
var state_val_53868 = (state_53867[(1)]);
if((state_val_53868 === (1))){
var state_53867__$1 = state_53867;
var statearr_53869_53887 = state_53867__$1;
(statearr_53869_53887[(2)] = null);

(statearr_53869_53887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53868 === (2))){
var _ = (function (){var statearr_53870 = state_53867;
(statearr_53870[(4)] = cljs.core.cons.call(null,(5),(state_53867[(4)])));

return statearr_53870;
})();
var inst_53844 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_53867__$1 = state_53867;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53867__$1,(6),inst_53844);
} else {
if((state_val_53868 === (3))){
var inst_53865 = (state_53867[(2)]);
var state_53867__$1 = state_53867;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53867__$1,inst_53865);
} else {
if((state_val_53868 === (4))){
var inst_53838 = (state_53867[(2)]);
var state_53867__$1 = state_53867;
var statearr_53872_53888 = state_53867__$1;
(statearr_53872_53888[(2)] = inst_53838);

(statearr_53872_53888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53868 === (5))){
var _ = (function (){var statearr_53873 = state_53867;
(statearr_53873[(4)] = cljs.core.rest.call(null,(state_53867[(4)])));

return statearr_53873;
})();
var state_53867__$1 = state_53867;
var ex53871 = (state_53867__$1[(2)]);
var statearr_53874_53889 = state_53867__$1;
(statearr_53874_53889[(5)] = ex53871);


if((ex53871 instanceof Error)){
var statearr_53875_53890 = state_53867__$1;
(statearr_53875_53890[(1)] = (4));

(statearr_53875_53890[(5)] = null);

} else {
throw ex53871;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53868 === (6))){
var inst_53846 = (state_53867[(2)]);
var inst_53847 = fluree.db.util.async.throw_err.call(null,inst_53846);
var inst_53848 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_53847);
var inst_53849 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53850 = [inst_53847];
var inst_53851 = (new cljs.core.PersistentVector(null,1,(5),inst_53849,inst_53850,null));
var inst_53852 = cljs.core.count.call(null,inst_53851);
var inst_53853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53854 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53855 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53856 = [inst_53847];
var inst_53857 = (new cljs.core.PersistentVector(null,1,(5),inst_53855,inst_53856,null));
var inst_53858 = ["or",inst_53857,inst_53848];
var inst_53859 = cljs.core.PersistentHashMap.fromArrays(inst_53854,inst_53858);
var inst_53860 = [inst_53859,inst_53852];
var inst_53861 = (new cljs.core.PersistentVector(null,2,(5),inst_53853,inst_53860,null));
var inst_53862 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53861);
var _ = (function (){var statearr_53876 = state_53867;
(statearr_53876[(4)] = cljs.core.rest.call(null,(state_53867[(4)])));

return statearr_53876;
})();
var state_53867__$1 = (function (){var statearr_53877 = state_53867;
(statearr_53877[(7)] = inst_53862);

return statearr_53877;
})();
var statearr_53878_53891 = state_53867__$1;
(statearr_53878_53891[(2)] = inst_53848);

(statearr_53878_53891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_53879 = [null,null,null,null,null,null,null,null];
(statearr_53879[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_53879[(1)] = (1));

return statearr_53879;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_53867){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53867);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53880){var ex__2749__auto__ = e53880;
var statearr_53881_53892 = state_53867;
(statearr_53881_53892[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53867[(4)]))){
var statearr_53882_53893 = state_53867;
(statearr_53882_53893[(1)] = cljs.core.first.call(null,(state_53867[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53894 = state_53867;
state_53867 = G__53894;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_53867){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_53867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53883 = f__2769__auto__.call(null);
(statearr_53883[(6)] = c__2768__auto__);

return statearr_53883;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq53836){
var G__53837 = cljs.core.first.call(null,seq53836);
var seq53836__$1 = cljs.core.next.call(null,seq53836);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53837,seq53836__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53932){
var state_val_53933 = (state_53932[(1)]);
if((state_val_53933 === (7))){
var inst_53908 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_53932__$1 = state_53932;
if(inst_53908){
var statearr_53934_53957 = state_53932__$1;
(statearr_53934_53957[(1)] = (10));

} else {
var statearr_53935_53958 = state_53932__$1;
(statearr_53935_53958[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53933 === (1))){
var state_53932__$1 = state_53932;
var statearr_53936_53959 = state_53932__$1;
(statearr_53936_53959[(2)] = null);

(statearr_53936_53959[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53933 === (4))){
var inst_53895 = (state_53932[(2)]);
var state_53932__$1 = state_53932;
var statearr_53937_53960 = state_53932__$1;
(statearr_53937_53960[(2)] = inst_53895);

(statearr_53937_53960[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53933 === (13))){
var inst_53911 = (state_53932[(2)]);
var inst_53912 = fluree.db.util.async.throw_err.call(null,inst_53911);
var state_53932__$1 = state_53932;
var statearr_53938_53961 = state_53932__$1;
(statearr_53938_53961[(2)] = inst_53912);

(statearr_53938_53961[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53933 === (6))){
var inst_53903 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_53932__$1 = state_53932;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53932__$1,(9),inst_53903);
} else {
if((state_val_53933 === (3))){
var inst_53930 = (state_53932[(2)]);
var state_53932__$1 = state_53932;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53932__$1,inst_53930);
} else {
if((state_val_53933 === (12))){
var inst_53915 = (state_53932[(2)]);
var state_53932__$1 = state_53932;
var statearr_53939_53962 = state_53932__$1;
(statearr_53939_53962[(2)] = inst_53915);

(statearr_53939_53962[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53933 === (2))){
var _ = (function (){var statearr_53940 = state_53932;
(statearr_53940[(4)] = cljs.core.cons.call(null,(5),(state_53932[(4)])));

return statearr_53940;
})();
var inst_53901 = cljs.core.vector_QMARK_.call(null,coll);
var state_53932__$1 = state_53932;
if(inst_53901){
var statearr_53941_53963 = state_53932__$1;
(statearr_53941_53963[(1)] = (6));

} else {
var statearr_53942_53964 = state_53932__$1;
(statearr_53942_53964[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53933 === (11))){
var state_53932__$1 = state_53932;
var statearr_53944_53965 = state_53932__$1;
(statearr_53944_53965[(2)] = coll);

(statearr_53944_53965[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53933 === (9))){
var inst_53905 = (state_53932[(2)]);
var inst_53906 = fluree.db.util.async.throw_err.call(null,inst_53905);
var state_53932__$1 = state_53932;
var statearr_53945_53966 = state_53932__$1;
(statearr_53945_53966[(2)] = inst_53906);

(statearr_53945_53966[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53933 === (5))){
var _ = (function (){var statearr_53946 = state_53932;
(statearr_53946[(4)] = cljs.core.rest.call(null,(state_53932[(4)])));

return statearr_53946;
})();
var state_53932__$1 = state_53932;
var ex53943 = (state_53932__$1[(2)]);
var statearr_53947_53967 = state_53932__$1;
(statearr_53947_53967[(5)] = ex53943);


if((ex53943 instanceof Error)){
var statearr_53948_53968 = state_53932__$1;
(statearr_53948_53968[(1)] = (4));

(statearr_53948_53968[(5)] = null);

} else {
throw ex53943;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53933 === (10))){
var state_53932__$1 = state_53932;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53932__$1,(13),coll);
} else {
if((state_val_53933 === (8))){
var inst_53917 = (state_53932[(2)]);
var inst_53918 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_53917);
var inst_53919 = cljs.core.count.call(null,inst_53918);
var inst_53920 = ((9) + inst_53919);
var inst_53921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53922 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53923 = ["count",inst_53917,inst_53919];
var inst_53924 = cljs.core.PersistentHashMap.fromArrays(inst_53922,inst_53923);
var inst_53925 = [inst_53924,inst_53920];
var inst_53926 = (new cljs.core.PersistentVector(null,2,(5),inst_53921,inst_53925,null));
var inst_53927 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53926);
var _ = (function (){var statearr_53949 = state_53932;
(statearr_53949[(4)] = cljs.core.rest.call(null,(state_53932[(4)])));

return statearr_53949;
})();
var state_53932__$1 = (function (){var statearr_53950 = state_53932;
(statearr_53950[(7)] = inst_53927);

return statearr_53950;
})();
var statearr_53951_53969 = state_53932__$1;
(statearr_53951_53969[(2)] = inst_53919);

(statearr_53951_53969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0 = (function (){
var statearr_53952 = [null,null,null,null,null,null,null,null];
(statearr_53952[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__);

(statearr_53952[(1)] = (1));

return statearr_53952;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1 = (function (state_53932){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53932);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53953){var ex__2749__auto__ = e53953;
var statearr_53954_53970 = state_53932;
(statearr_53954_53970[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53932[(4)]))){
var statearr_53955_53971 = state_53932;
(statearr_53955_53971[(1)] = cljs.core.first.call(null,(state_53932[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53972 = state_53932;
state_53932 = G__53972;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__ = function(state_53932){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1.call(this,state_53932);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53956 = f__2769__auto__.call(null);
(statearr_53956[(6)] = c__2768__auto__);

return statearr_53956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54022){
var state_val_54023 = (state_54022[(1)]);
if((state_val_54023 === (7))){
var state_54022__$1 = state_54022;
var statearr_54024_54057 = state_54022__$1;
(statearr_54024_54057[(2)] = subject);

(statearr_54024_54057[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54023 === (1))){
var state_54022__$1 = state_54022;
var statearr_54025_54058 = state_54022__$1;
(statearr_54025_54058[(2)] = null);

(statearr_54025_54058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54023 === (4))){
var inst_53973 = (state_54022[(2)]);
var state_54022__$1 = state_54022;
var statearr_54026_54059 = state_54022__$1;
(statearr_54026_54059[(2)] = inst_53973);

(statearr_54026_54059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54023 === (15))){
var inst_53986 = (state_54022[(7)]);
var state_54022__$1 = state_54022;
var statearr_54027_54060 = state_54022__$1;
(statearr_54027_54060[(2)] = inst_53986);

(statearr_54027_54060[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54023 === (13))){
var inst_53990 = (state_54022[(2)]);
var inst_53991 = fluree.db.util.async.throw_err.call(null,inst_53990);
var state_54022__$1 = state_54022;
var statearr_54028_54061 = state_54022__$1;
(statearr_54028_54061[(2)] = inst_53991);

(statearr_54028_54061[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54023 === (6))){
var state_54022__$1 = state_54022;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54022__$1,(9),subject);
} else {
if((state_val_54023 === (17))){
var inst_53986 = (state_54022[(7)]);
var inst_54000 = cljs.core.first.call(null,inst_53986);
var state_54022__$1 = state_54022;
var statearr_54029_54062 = state_54022__$1;
(statearr_54029_54062[(2)] = inst_54000);

(statearr_54029_54062[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54023 === (3))){
var inst_54020 = (state_54022[(2)]);
var state_54022__$1 = state_54022;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54022__$1,inst_54020);
} else {
if((state_val_54023 === (12))){
var inst_53986 = (state_54022[(7)]);
var inst_53994 = (state_54022[(2)]);
var inst_53995 = cljs.core.vector_QMARK_.call(null,inst_53986);
var state_54022__$1 = (function (){var statearr_54030 = state_54022;
(statearr_54030[(8)] = inst_53994);

return statearr_54030;
})();
if(inst_53995){
var statearr_54031_54063 = state_54022__$1;
(statearr_54031_54063[(1)] = (14));

} else {
var statearr_54032_54064 = state_54022__$1;
(statearr_54032_54064[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54023 === (2))){
var _ = (function (){var statearr_54033 = state_54022;
(statearr_54033[(4)] = cljs.core.cons.call(null,(5),(state_54022[(4)])));

return statearr_54033;
})();
var inst_53979 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_54022__$1 = state_54022;
if(inst_53979){
var statearr_54034_54065 = state_54022__$1;
(statearr_54034_54065[(1)] = (6));

} else {
var statearr_54035_54066 = state_54022__$1;
(statearr_54035_54066[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54023 === (19))){
var inst_54003 = (state_54022[(2)]);
var state_54022__$1 = state_54022;
var statearr_54036_54067 = state_54022__$1;
(statearr_54036_54067[(2)] = inst_54003);

(statearr_54036_54067[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54023 === (11))){
var state_54022__$1 = state_54022;
var statearr_54038_54068 = state_54022__$1;
(statearr_54038_54068[(2)] = pred);

(statearr_54038_54068[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54023 === (9))){
var inst_53982 = (state_54022[(2)]);
var inst_53983 = fluree.db.util.async.throw_err.call(null,inst_53982);
var state_54022__$1 = state_54022;
var statearr_54039_54069 = state_54022__$1;
(statearr_54039_54069[(2)] = inst_53983);

(statearr_54039_54069[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54023 === (5))){
var _ = (function (){var statearr_54040 = state_54022;
(statearr_54040[(4)] = cljs.core.rest.call(null,(state_54022[(4)])));

return statearr_54040;
})();
var state_54022__$1 = state_54022;
var ex54037 = (state_54022__$1[(2)]);
var statearr_54041_54070 = state_54022__$1;
(statearr_54041_54070[(5)] = ex54037);


if((ex54037 instanceof Error)){
var statearr_54042_54071 = state_54022__$1;
(statearr_54042_54071[(1)] = (4));

(statearr_54042_54071[(5)] = null);

} else {
throw ex54037;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54023 === (14))){
var inst_53986 = (state_54022[(7)]);
var inst_53997 = cljs.core.count.call(null,inst_53986);
var inst_53998 = cljs.core._EQ_.call(null,(1),inst_53997);
var state_54022__$1 = state_54022;
if(inst_53998){
var statearr_54043_54072 = state_54022__$1;
(statearr_54043_54072[(1)] = (17));

} else {
var statearr_54044_54073 = state_54022__$1;
(statearr_54044_54073[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54023 === (16))){
var inst_53986 = (state_54022[(7)]);
var inst_53994 = (state_54022[(8)]);
var inst_54006 = (state_54022[(2)]);
var inst_54007 = fluree.db.dbfunctions.internal.get.call(null,inst_54006,inst_53994);
var inst_54008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54009 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54011 = [inst_53986,inst_53994];
var inst_54012 = (new cljs.core.PersistentVector(null,2,(5),inst_54010,inst_54011,null));
var inst_54013 = ["get",inst_54012,inst_54007];
var inst_54014 = cljs.core.PersistentHashMap.fromArrays(inst_54009,inst_54013);
var inst_54015 = [inst_54014,(10)];
var inst_54016 = (new cljs.core.PersistentVector(null,2,(5),inst_54008,inst_54015,null));
var inst_54017 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54016);
var _ = (function (){var statearr_54045 = state_54022;
(statearr_54045[(4)] = cljs.core.rest.call(null,(state_54022[(4)])));

return statearr_54045;
})();
var state_54022__$1 = (function (){var statearr_54046 = state_54022;
(statearr_54046[(9)] = inst_54017);

return statearr_54046;
})();
var statearr_54047_54074 = state_54022__$1;
(statearr_54047_54074[(2)] = inst_54007);

(statearr_54047_54074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54023 === (10))){
var state_54022__$1 = state_54022;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54022__$1,(13),pred);
} else {
if((state_val_54023 === (18))){
var inst_53986 = (state_54022[(7)]);
var state_54022__$1 = state_54022;
var statearr_54048_54075 = state_54022__$1;
(statearr_54048_54075[(2)] = inst_53986);

(statearr_54048_54075[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54023 === (8))){
var inst_53986 = (state_54022[(2)]);
var inst_53987 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_54022__$1 = (function (){var statearr_54049 = state_54022;
(statearr_54049[(7)] = inst_53986);

return statearr_54049;
})();
if(inst_53987){
var statearr_54050_54076 = state_54022__$1;
(statearr_54050_54076[(1)] = (10));

} else {
var statearr_54051_54077 = state_54022__$1;
(statearr_54051_54077[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0 = (function (){
var statearr_54052 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54052[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__);

(statearr_54052[(1)] = (1));

return statearr_54052;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1 = (function (state_54022){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54022);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54053){var ex__2749__auto__ = e54053;
var statearr_54054_54078 = state_54022;
(statearr_54054_54078[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54022[(4)]))){
var statearr_54055_54079 = state_54022;
(statearr_54055_54079[(1)] = cljs.core.first.call(null,(state_54022[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54080 = state_54022;
state_54022 = G__54080;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__ = function(state_54022){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1.call(this,state_54022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54056 = f__2769__auto__.call(null);
(statearr_54056[(6)] = c__2768__auto__);

return statearr_54056;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54119){
var state_val_54120 = (state_54119[(1)]);
if((state_val_54120 === (7))){
var inst_54087 = (state_54119[(7)]);
var state_54119__$1 = state_54119;
var statearr_54121_54145 = state_54119__$1;
(statearr_54121_54145[(2)] = inst_54087);

(statearr_54121_54145[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (1))){
var state_54119__$1 = state_54119;
var statearr_54122_54146 = state_54119__$1;
(statearr_54122_54146[(2)] = null);

(statearr_54122_54146[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (4))){
var inst_54081 = (state_54119[(2)]);
var state_54119__$1 = state_54119;
var statearr_54123_54147 = state_54119__$1;
(statearr_54123_54147[(2)] = inst_54081);

(statearr_54123_54147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (6))){
var inst_54089 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54119__$1 = state_54119;
var statearr_54124_54148 = state_54119__$1;
(statearr_54124_54148[(2)] = inst_54089);

(statearr_54124_54148[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (3))){
var inst_54117 = (state_54119[(2)]);
var state_54119__$1 = state_54119;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54119__$1,inst_54117);
} else {
if((state_val_54120 === (12))){
var inst_54099 = (state_54119[(2)]);
var inst_54100 = fluree.db.util.async.throw_err.call(null,inst_54099);
var inst_54101 = cljs.core.nth.call(null,inst_54100,(0),null);
var inst_54102 = cljs.core.nth.call(null,inst_54100,(1),null);
var inst_54103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54104 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54105 = ["?pO","?ctx",inst_54101];
var inst_54106 = cljs.core.PersistentHashMap.fromArrays(inst_54104,inst_54105);
var inst_54107 = ((10) + inst_54102);
var inst_54108 = [inst_54106,inst_54107];
var inst_54109 = (new cljs.core.PersistentVector(null,2,(5),inst_54103,inst_54108,null));
var inst_54110 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54109);
var state_54119__$1 = (function (){var statearr_54125 = state_54119;
(statearr_54125[(8)] = inst_54110);

return statearr_54125;
})();
var statearr_54126_54149 = state_54119__$1;
(statearr_54126_54149[(2)] = inst_54101);

(statearr_54126_54149[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (2))){
var inst_54087 = (state_54119[(7)]);
var _ = (function (){var statearr_54127 = state_54119;
(statearr_54127[(4)] = cljs.core.cons.call(null,(5),(state_54119[(4)])));

return statearr_54127;
})();
var inst_54087__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54119__$1 = (function (){var statearr_54128 = state_54119;
(statearr_54128[(7)] = inst_54087__$1);

return statearr_54128;
})();
if(cljs.core.truth_(inst_54087__$1)){
var statearr_54129_54150 = state_54119__$1;
(statearr_54129_54150[(1)] = (6));

} else {
var statearr_54130_54151 = state_54119__$1;
(statearr_54130_54151[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (11))){
var inst_54114 = (state_54119[(2)]);
var _ = (function (){var statearr_54132 = state_54119;
(statearr_54132[(4)] = cljs.core.rest.call(null,(state_54119[(4)])));

return statearr_54132;
})();
var state_54119__$1 = state_54119;
var statearr_54133_54152 = state_54119__$1;
(statearr_54133_54152[(2)] = inst_54114);

(statearr_54133_54152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (9))){
var inst_54097 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_54119__$1 = state_54119;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54119__$1,(12),inst_54097);
} else {
if((state_val_54120 === (5))){
var _ = (function (){var statearr_54134 = state_54119;
(statearr_54134[(4)] = cljs.core.rest.call(null,(state_54119[(4)])));

return statearr_54134;
})();
var state_54119__$1 = state_54119;
var ex54131 = (state_54119__$1[(2)]);
var statearr_54135_54153 = state_54119__$1;
(statearr_54135_54153[(5)] = ex54131);


if((ex54131 instanceof Error)){
var statearr_54136_54154 = state_54119__$1;
(statearr_54136_54154[(1)] = (4));

(statearr_54136_54154[(5)] = null);

} else {
throw ex54131;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (10))){
var inst_54112 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_54119__$1 = state_54119;
var statearr_54137_54155 = state_54119__$1;
(statearr_54137_54155[(2)] = inst_54112);

(statearr_54137_54155[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (8))){
var inst_54092 = (state_54119[(2)]);
var state_54119__$1 = state_54119;
if(cljs.core.truth_(inst_54092)){
var statearr_54138_54156 = state_54119__$1;
(statearr_54138_54156[(1)] = (9));

} else {
var statearr_54139_54157 = state_54119__$1;
(statearr_54139_54157[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0 = (function (){
var statearr_54140 = [null,null,null,null,null,null,null,null,null];
(statearr_54140[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__);

(statearr_54140[(1)] = (1));

return statearr_54140;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1 = (function (state_54119){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54119);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54141){var ex__2749__auto__ = e54141;
var statearr_54142_54158 = state_54119;
(statearr_54142_54158[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54119[(4)]))){
var statearr_54143_54159 = state_54119;
(statearr_54143_54159[(1)] = cljs.core.first.call(null,(state_54119[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54160 = state_54119;
state_54119 = G__54160;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__ = function(state_54119){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1.call(this,state_54119);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54144 = f__2769__auto__.call(null);
(statearr_54144[(6)] = c__2768__auto__);

return statearr_54144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54212){
var state_val_54213 = (state_54212[(1)]);
if((state_val_54213 === (7))){
var state_54212__$1 = state_54212;
var statearr_54214_54247 = state_54212__$1;
(statearr_54214_54247[(2)] = subject);

(statearr_54214_54247[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54213 === (1))){
var state_54212__$1 = state_54212;
var statearr_54215_54248 = state_54212__$1;
(statearr_54215_54248[(2)] = null);

(statearr_54215_54248[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54213 === (4))){
var inst_54161 = (state_54212[(2)]);
var state_54212__$1 = state_54212;
var statearr_54216_54249 = state_54212__$1;
(statearr_54216_54249[(2)] = inst_54161);

(statearr_54216_54249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54213 === (15))){
var inst_54174 = (state_54212[(7)]);
var state_54212__$1 = state_54212;
var statearr_54217_54250 = state_54212__$1;
(statearr_54217_54250[(2)] = inst_54174);

(statearr_54217_54250[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54213 === (13))){
var inst_54178 = (state_54212[(2)]);
var inst_54179 = fluree.db.util.async.throw_err.call(null,inst_54178);
var state_54212__$1 = state_54212;
var statearr_54218_54251 = state_54212__$1;
(statearr_54218_54251[(2)] = inst_54179);

(statearr_54218_54251[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54213 === (6))){
var state_54212__$1 = state_54212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54212__$1,(9),subject);
} else {
if((state_val_54213 === (17))){
var inst_54174 = (state_54212[(7)]);
var inst_54188 = cljs.core.first.call(null,inst_54174);
var state_54212__$1 = state_54212;
var statearr_54219_54252 = state_54212__$1;
(statearr_54219_54252[(2)] = inst_54188);

(statearr_54219_54252[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54213 === (3))){
var inst_54210 = (state_54212[(2)]);
var state_54212__$1 = state_54212;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54212__$1,inst_54210);
} else {
if((state_val_54213 === (12))){
var inst_54174 = (state_54212[(7)]);
var inst_54182 = (state_54212[(2)]);
var inst_54183 = cljs.core.vector_QMARK_.call(null,inst_54174);
var state_54212__$1 = (function (){var statearr_54220 = state_54212;
(statearr_54220[(8)] = inst_54182);

return statearr_54220;
})();
if(inst_54183){
var statearr_54221_54253 = state_54212__$1;
(statearr_54221_54253[(1)] = (14));

} else {
var statearr_54222_54254 = state_54212__$1;
(statearr_54222_54254[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54213 === (2))){
var _ = (function (){var statearr_54223 = state_54212;
(statearr_54223[(4)] = cljs.core.cons.call(null,(5),(state_54212[(4)])));

return statearr_54223;
})();
var inst_54167 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_54212__$1 = state_54212;
if(inst_54167){
var statearr_54224_54255 = state_54212__$1;
(statearr_54224_54255[(1)] = (6));

} else {
var statearr_54225_54256 = state_54212__$1;
(statearr_54225_54256[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54213 === (19))){
var inst_54191 = (state_54212[(2)]);
var state_54212__$1 = state_54212;
var statearr_54226_54257 = state_54212__$1;
(statearr_54226_54257[(2)] = inst_54191);

(statearr_54226_54257[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54213 === (11))){
var state_54212__$1 = state_54212;
var statearr_54228_54258 = state_54212__$1;
(statearr_54228_54258[(2)] = path);

(statearr_54228_54258[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54213 === (9))){
var inst_54170 = (state_54212[(2)]);
var inst_54171 = fluree.db.util.async.throw_err.call(null,inst_54170);
var state_54212__$1 = state_54212;
var statearr_54229_54259 = state_54212__$1;
(statearr_54229_54259[(2)] = inst_54171);

(statearr_54229_54259[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54213 === (5))){
var _ = (function (){var statearr_54230 = state_54212;
(statearr_54230[(4)] = cljs.core.rest.call(null,(state_54212[(4)])));

return statearr_54230;
})();
var state_54212__$1 = state_54212;
var ex54227 = (state_54212__$1[(2)]);
var statearr_54231_54260 = state_54212__$1;
(statearr_54231_54260[(5)] = ex54227);


if((ex54227 instanceof Error)){
var statearr_54232_54261 = state_54212__$1;
(statearr_54232_54261[(1)] = (4));

(statearr_54232_54261[(5)] = null);

} else {
throw ex54227;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54213 === (14))){
var inst_54174 = (state_54212[(7)]);
var inst_54185 = cljs.core.count.call(null,inst_54174);
var inst_54186 = cljs.core._EQ_.call(null,(1),inst_54185);
var state_54212__$1 = state_54212;
if(inst_54186){
var statearr_54233_54262 = state_54212__$1;
(statearr_54233_54262[(1)] = (17));

} else {
var statearr_54234_54263 = state_54212__$1;
(statearr_54234_54263[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54213 === (16))){
var inst_54174 = (state_54212[(7)]);
var inst_54182 = (state_54212[(8)]);
var inst_54194 = (state_54212[(2)]);
var inst_54195 = fluree.db.dbfunctions.internal.get_all.call(null,inst_54194,inst_54182);
var inst_54196 = cljs.core.count.call(null,inst_54182);
var inst_54197 = ((9) + inst_54196);
var inst_54198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54199 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54201 = [inst_54174,inst_54182];
var inst_54202 = (new cljs.core.PersistentVector(null,2,(5),inst_54200,inst_54201,null));
var inst_54203 = ["get-all",inst_54202,inst_54195];
var inst_54204 = cljs.core.PersistentHashMap.fromArrays(inst_54199,inst_54203);
var inst_54205 = [inst_54204,inst_54197];
var inst_54206 = (new cljs.core.PersistentVector(null,2,(5),inst_54198,inst_54205,null));
var inst_54207 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54206);
var _ = (function (){var statearr_54235 = state_54212;
(statearr_54235[(4)] = cljs.core.rest.call(null,(state_54212[(4)])));

return statearr_54235;
})();
var state_54212__$1 = (function (){var statearr_54236 = state_54212;
(statearr_54236[(9)] = inst_54207);

return statearr_54236;
})();
var statearr_54237_54264 = state_54212__$1;
(statearr_54237_54264[(2)] = inst_54195);

(statearr_54237_54264[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54213 === (10))){
var state_54212__$1 = state_54212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54212__$1,(13),path);
} else {
if((state_val_54213 === (18))){
var inst_54174 = (state_54212[(7)]);
var state_54212__$1 = state_54212;
var statearr_54238_54265 = state_54212__$1;
(statearr_54238_54265[(2)] = inst_54174);

(statearr_54238_54265[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54213 === (8))){
var inst_54174 = (state_54212[(2)]);
var inst_54175 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_54212__$1 = (function (){var statearr_54239 = state_54212;
(statearr_54239[(7)] = inst_54174);

return statearr_54239;
})();
if(inst_54175){
var statearr_54240_54266 = state_54212__$1;
(statearr_54240_54266[(1)] = (10));

} else {
var statearr_54241_54267 = state_54212__$1;
(statearr_54241_54267[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0 = (function (){
var statearr_54242 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54242[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__);

(statearr_54242[(1)] = (1));

return statearr_54242;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1 = (function (state_54212){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54212);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54243){var ex__2749__auto__ = e54243;
var statearr_54244_54268 = state_54212;
(statearr_54244_54268[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54212[(4)]))){
var statearr_54245_54269 = state_54212;
(statearr_54245_54269[(1)] = cljs.core.first.call(null,(state_54212[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54270 = state_54212;
state_54212 = G__54270;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__ = function(state_54212){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1.call(this,state_54212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54246 = f__2769__auto__.call(null);
(statearr_54246[(6)] = c__2768__auto__);

return statearr_54246;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54309){
var state_val_54310 = (state_54309[(1)]);
if((state_val_54310 === (7))){
var state_54309__$1 = state_54309;
var statearr_54311_54335 = state_54309__$1;
(statearr_54311_54335[(2)] = subject);

(statearr_54311_54335[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54310 === (1))){
var state_54309__$1 = state_54309;
var statearr_54312_54336 = state_54309__$1;
(statearr_54312_54336[(2)] = null);

(statearr_54312_54336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54310 === (4))){
var inst_54271 = (state_54309[(2)]);
var state_54309__$1 = state_54309;
var statearr_54313_54337 = state_54309__$1;
(statearr_54313_54337[(2)] = inst_54271);

(statearr_54313_54337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54310 === (13))){
var inst_54288 = (state_54309[(2)]);
var inst_54289 = fluree.db.util.async.throw_err.call(null,inst_54288);
var state_54309__$1 = state_54309;
var statearr_54314_54338 = state_54309__$1;
(statearr_54314_54338[(2)] = inst_54289);

(statearr_54314_54338[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54310 === (6))){
var state_54309__$1 = state_54309;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54309__$1,(9),subject);
} else {
if((state_val_54310 === (3))){
var inst_54307 = (state_54309[(2)]);
var state_54309__$1 = state_54309;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54309__$1,inst_54307);
} else {
if((state_val_54310 === (12))){
var inst_54284 = (state_54309[(7)]);
var inst_54292 = (state_54309[(2)]);
var inst_54293 = fluree.db.dbfunctions.internal.get_in.call(null,inst_54284,inst_54292);
var inst_54294 = cljs.core.count.call(null,inst_54292);
var inst_54295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54296 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54298 = [inst_54284,inst_54292];
var inst_54299 = (new cljs.core.PersistentVector(null,2,(5),inst_54297,inst_54298,null));
var inst_54300 = ["get-in",inst_54299,inst_54293];
var inst_54301 = cljs.core.PersistentHashMap.fromArrays(inst_54296,inst_54300);
var inst_54302 = [inst_54301,inst_54294];
var inst_54303 = (new cljs.core.PersistentVector(null,2,(5),inst_54295,inst_54302,null));
var inst_54304 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54303);
var _ = (function (){var statearr_54315 = state_54309;
(statearr_54315[(4)] = cljs.core.rest.call(null,(state_54309[(4)])));

return statearr_54315;
})();
var state_54309__$1 = (function (){var statearr_54316 = state_54309;
(statearr_54316[(8)] = inst_54304);

return statearr_54316;
})();
var statearr_54317_54339 = state_54309__$1;
(statearr_54317_54339[(2)] = inst_54293);

(statearr_54317_54339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54310 === (2))){
var _ = (function (){var statearr_54318 = state_54309;
(statearr_54318[(4)] = cljs.core.cons.call(null,(5),(state_54309[(4)])));

return statearr_54318;
})();
var inst_54277 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_54309__$1 = state_54309;
if(inst_54277){
var statearr_54319_54340 = state_54309__$1;
(statearr_54319_54340[(1)] = (6));

} else {
var statearr_54320_54341 = state_54309__$1;
(statearr_54320_54341[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54310 === (11))){
var state_54309__$1 = state_54309;
var statearr_54322_54342 = state_54309__$1;
(statearr_54322_54342[(2)] = path);

(statearr_54322_54342[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54310 === (9))){
var inst_54280 = (state_54309[(2)]);
var inst_54281 = fluree.db.util.async.throw_err.call(null,inst_54280);
var state_54309__$1 = state_54309;
var statearr_54323_54343 = state_54309__$1;
(statearr_54323_54343[(2)] = inst_54281);

(statearr_54323_54343[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54310 === (5))){
var _ = (function (){var statearr_54324 = state_54309;
(statearr_54324[(4)] = cljs.core.rest.call(null,(state_54309[(4)])));

return statearr_54324;
})();
var state_54309__$1 = state_54309;
var ex54321 = (state_54309__$1[(2)]);
var statearr_54325_54344 = state_54309__$1;
(statearr_54325_54344[(5)] = ex54321);


if((ex54321 instanceof Error)){
var statearr_54326_54345 = state_54309__$1;
(statearr_54326_54345[(1)] = (4));

(statearr_54326_54345[(5)] = null);

} else {
throw ex54321;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54310 === (10))){
var state_54309__$1 = state_54309;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54309__$1,(13),path);
} else {
if((state_val_54310 === (8))){
var inst_54284 = (state_54309[(2)]);
var inst_54285 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_54309__$1 = (function (){var statearr_54327 = state_54309;
(statearr_54327[(7)] = inst_54284);

return statearr_54327;
})();
if(inst_54285){
var statearr_54328_54346 = state_54309__$1;
(statearr_54328_54346[(1)] = (10));

} else {
var statearr_54329_54347 = state_54309__$1;
(statearr_54329_54347[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0 = (function (){
var statearr_54330 = [null,null,null,null,null,null,null,null,null];
(statearr_54330[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__);

(statearr_54330[(1)] = (1));

return statearr_54330;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1 = (function (state_54309){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54309);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54331){var ex__2749__auto__ = e54331;
var statearr_54332_54348 = state_54309;
(statearr_54332_54348[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54309[(4)]))){
var statearr_54333_54349 = state_54309;
(statearr_54333_54349[(1)] = cljs.core.first.call(null,(state_54309[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54350 = state_54309;
state_54309 = G__54350;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__ = function(state_54309){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1.call(this,state_54309);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54334 = f__2769__auto__.call(null);
(statearr_54334[(6)] = c__2768__auto__);

return statearr_54334;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54395){
var state_val_54396 = (state_54395[(1)]);
if((state_val_54396 === (7))){
var state_54395__$1 = state_54395;
var statearr_54397_54426 = state_54395__$1;
(statearr_54397_54426[(2)] = coll);

(statearr_54397_54426[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (1))){
var state_54395__$1 = state_54395;
var statearr_54398_54427 = state_54395__$1;
(statearr_54398_54427[(2)] = null);

(statearr_54398_54427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (4))){
var inst_54351 = (state_54395[(2)]);
var state_54395__$1 = state_54395;
var statearr_54399_54428 = state_54395__$1;
(statearr_54399_54428[(2)] = inst_54351);

(statearr_54399_54428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (15))){
var inst_54371 = (state_54395[(7)]);
var inst_54379 = (state_54395[(2)]);
var inst_54380 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_54371,inst_54379);
var inst_54381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54382 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54384 = [inst_54371,inst_54379];
var inst_54385 = (new cljs.core.PersistentVector(null,2,(5),inst_54383,inst_54384,null));
var inst_54386 = ["contains?",inst_54385,inst_54380];
var inst_54387 = cljs.core.PersistentHashMap.fromArrays(inst_54382,inst_54386);
var inst_54388 = [inst_54387,(10)];
var inst_54389 = (new cljs.core.PersistentVector(null,2,(5),inst_54381,inst_54388,null));
var inst_54390 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54389);
var _ = (function (){var statearr_54400 = state_54395;
(statearr_54400[(4)] = cljs.core.rest.call(null,(state_54395[(4)])));

return statearr_54400;
})();
var state_54395__$1 = (function (){var statearr_54401 = state_54395;
(statearr_54401[(8)] = inst_54390);

return statearr_54401;
})();
var statearr_54402_54429 = state_54395__$1;
(statearr_54402_54429[(2)] = inst_54380);

(statearr_54402_54429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (13))){
var state_54395__$1 = state_54395;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54395__$1,(16),key);
} else {
if((state_val_54396 === (6))){
var state_54395__$1 = state_54395;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54395__$1,(9),coll);
} else {
if((state_val_54396 === (3))){
var inst_54393 = (state_54395[(2)]);
var state_54395__$1 = state_54395;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54395__$1,inst_54393);
} else {
if((state_val_54396 === (12))){
var inst_54371 = (state_54395[(2)]);
var inst_54372 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_54395__$1 = (function (){var statearr_54403 = state_54395;
(statearr_54403[(7)] = inst_54371);

return statearr_54403;
})();
if(inst_54372){
var statearr_54404_54430 = state_54395__$1;
(statearr_54404_54430[(1)] = (13));

} else {
var statearr_54405_54431 = state_54395__$1;
(statearr_54405_54431[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (2))){
var _ = (function (){var statearr_54406 = state_54395;
(statearr_54406[(4)] = cljs.core.cons.call(null,(5),(state_54395[(4)])));

return statearr_54406;
})();
var inst_54357 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_54395__$1 = state_54395;
if(inst_54357){
var statearr_54407_54432 = state_54395__$1;
(statearr_54407_54432[(1)] = (6));

} else {
var statearr_54408_54433 = state_54395__$1;
(statearr_54408_54433[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (11))){
var inst_54364 = (state_54395[(9)]);
var inst_54368 = cljs.core.flatten.call(null,inst_54364);
var inst_54369 = cljs.core.set.call(null,inst_54368);
var state_54395__$1 = state_54395;
var statearr_54410_54434 = state_54395__$1;
(statearr_54410_54434[(2)] = inst_54369);

(statearr_54410_54434[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (9))){
var inst_54360 = (state_54395[(2)]);
var inst_54361 = fluree.db.util.async.throw_err.call(null,inst_54360);
var state_54395__$1 = state_54395;
var statearr_54411_54435 = state_54395__$1;
(statearr_54411_54435[(2)] = inst_54361);

(statearr_54411_54435[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (5))){
var _ = (function (){var statearr_54412 = state_54395;
(statearr_54412[(4)] = cljs.core.rest.call(null,(state_54395[(4)])));

return statearr_54412;
})();
var state_54395__$1 = state_54395;
var ex54409 = (state_54395__$1[(2)]);
var statearr_54413_54436 = state_54395__$1;
(statearr_54413_54436[(5)] = ex54409);


if((ex54409 instanceof Error)){
var statearr_54414_54437 = state_54395__$1;
(statearr_54414_54437[(1)] = (4));

(statearr_54414_54437[(5)] = null);

} else {
throw ex54409;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (14))){
var state_54395__$1 = state_54395;
var statearr_54415_54438 = state_54395__$1;
(statearr_54415_54438[(2)] = key);

(statearr_54415_54438[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (16))){
var inst_54375 = (state_54395[(2)]);
var inst_54376 = fluree.db.util.async.throw_err.call(null,inst_54375);
var state_54395__$1 = state_54395;
var statearr_54416_54439 = state_54395__$1;
(statearr_54416_54439[(2)] = inst_54376);

(statearr_54416_54439[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (10))){
var inst_54364 = (state_54395[(9)]);
var state_54395__$1 = state_54395;
var statearr_54417_54440 = state_54395__$1;
(statearr_54417_54440[(2)] = inst_54364);

(statearr_54417_54440[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (8))){
var inst_54364 = (state_54395[(9)]);
var inst_54364__$1 = (state_54395[(2)]);
var inst_54365 = cljs.core.set_QMARK_.call(null,inst_54364__$1);
var state_54395__$1 = (function (){var statearr_54418 = state_54395;
(statearr_54418[(9)] = inst_54364__$1);

return statearr_54418;
})();
if(inst_54365){
var statearr_54419_54441 = state_54395__$1;
(statearr_54419_54441[(1)] = (10));

} else {
var statearr_54420_54442 = state_54395__$1;
(statearr_54420_54442[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_54421 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54421[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__);

(statearr_54421[(1)] = (1));

return statearr_54421;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1 = (function (state_54395){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54395);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54422){var ex__2749__auto__ = e54422;
var statearr_54423_54443 = state_54395;
(statearr_54423_54443[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54395[(4)]))){
var statearr_54424_54444 = state_54395;
(statearr_54424_54444[(1)] = cljs.core.first.call(null,(state_54395[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54445 = state_54395;
state_54395 = G__54445;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__ = function(state_54395){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1.call(this,state_54395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54425 = f__2769__auto__.call(null);
(statearr_54425[(6)] = c__2768__auto__);

return statearr_54425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54517 = arguments.length;
var i__4865__auto___54518 = (0);
while(true){
if((i__4865__auto___54518 < len__4864__auto___54517)){
args__4870__auto__.push((arguments[i__4865__auto___54518]));

var G__54519 = (i__4865__auto___54518 + (1));
i__4865__auto___54518 = G__54519;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54491){
var state_val_54492 = (state_54491[(1)]);
if((state_val_54492 === (7))){
var inst_54457 = (state_54491[(7)]);
var inst_54461 = cljs.core.first.call(null,inst_54457);
var inst_54462 = cljs.core.coll_QMARK_.call(null,inst_54461);
var state_54491__$1 = state_54491;
var statearr_54493_54520 = state_54491__$1;
(statearr_54493_54520[(2)] = inst_54462);

(statearr_54493_54520[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54492 === (1))){
var state_54491__$1 = state_54491;
var statearr_54494_54521 = state_54491__$1;
(statearr_54494_54521[(2)] = null);

(statearr_54494_54521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54492 === (4))){
var inst_54448 = (state_54491[(2)]);
var state_54491__$1 = state_54491;
var statearr_54495_54522 = state_54491__$1;
(statearr_54495_54522[(2)] = inst_54448);

(statearr_54495_54522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54492 === (6))){
var inst_54457 = (state_54491[(7)]);
var inst_54459 = (state_54491[(8)]);
var inst_54456 = (state_54491[(2)]);
var inst_54457__$1 = fluree.db.util.async.throw_err.call(null,inst_54456);
var inst_54458 = cljs.core.count.call(null,inst_54457__$1);
var inst_54459__$1 = cljs.core._EQ_.call(null,(1),inst_54458);
var state_54491__$1 = (function (){var statearr_54496 = state_54491;
(statearr_54496[(7)] = inst_54457__$1);

(statearr_54496[(8)] = inst_54459__$1);

return statearr_54496;
})();
if(inst_54459__$1){
var statearr_54497_54523 = state_54491__$1;
(statearr_54497_54523[(1)] = (7));

} else {
var statearr_54498_54524 = state_54491__$1;
(statearr_54498_54524[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54492 === (3))){
var inst_54489 = (state_54491[(2)]);
var state_54491__$1 = state_54491;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54491__$1,inst_54489);
} else {
if((state_val_54492 === (12))){
var inst_54470 = (state_54491[(2)]);
var inst_54471 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_54470);
var inst_54472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54473 = [inst_54470];
var inst_54474 = (new cljs.core.PersistentVector(null,1,(5),inst_54472,inst_54473,null));
var inst_54475 = cljs.core.count.call(null,inst_54474);
var inst_54476 = ((9) + inst_54475);
var inst_54477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54478 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54479 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54480 = [inst_54470];
var inst_54481 = (new cljs.core.PersistentVector(null,1,(5),inst_54479,inst_54480,null));
var inst_54482 = ["hash-set",inst_54481,inst_54471];
var inst_54483 = cljs.core.PersistentHashMap.fromArrays(inst_54478,inst_54482);
var inst_54484 = [inst_54483,inst_54476];
var inst_54485 = (new cljs.core.PersistentVector(null,2,(5),inst_54477,inst_54484,null));
var inst_54486 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54485);
var _ = (function (){var statearr_54499 = state_54491;
(statearr_54499[(4)] = cljs.core.rest.call(null,(state_54491[(4)])));

return statearr_54499;
})();
var state_54491__$1 = (function (){var statearr_54500 = state_54491;
(statearr_54500[(9)] = inst_54486);

return statearr_54500;
})();
var statearr_54501_54525 = state_54491__$1;
(statearr_54501_54525[(2)] = inst_54471);

(statearr_54501_54525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54492 === (2))){
var _ = (function (){var statearr_54502 = state_54491;
(statearr_54502[(4)] = cljs.core.cons.call(null,(5),(state_54491[(4)])));

return statearr_54502;
})();
var inst_54454 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54491__$1 = state_54491;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54491__$1,(6),inst_54454);
} else {
if((state_val_54492 === (11))){
var inst_54457 = (state_54491[(7)]);
var state_54491__$1 = state_54491;
var statearr_54504_54526 = state_54491__$1;
(statearr_54504_54526[(2)] = inst_54457);

(statearr_54504_54526[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54492 === (9))){
var inst_54465 = (state_54491[(2)]);
var state_54491__$1 = state_54491;
if(cljs.core.truth_(inst_54465)){
var statearr_54505_54527 = state_54491__$1;
(statearr_54505_54527[(1)] = (10));

} else {
var statearr_54506_54528 = state_54491__$1;
(statearr_54506_54528[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54492 === (5))){
var _ = (function (){var statearr_54507 = state_54491;
(statearr_54507[(4)] = cljs.core.rest.call(null,(state_54491[(4)])));

return statearr_54507;
})();
var state_54491__$1 = state_54491;
var ex54503 = (state_54491__$1[(2)]);
var statearr_54508_54529 = state_54491__$1;
(statearr_54508_54529[(5)] = ex54503);


if((ex54503 instanceof Error)){
var statearr_54509_54530 = state_54491__$1;
(statearr_54509_54530[(1)] = (4));

(statearr_54509_54530[(5)] = null);

} else {
throw ex54503;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54492 === (10))){
var inst_54457 = (state_54491[(7)]);
var inst_54467 = cljs.core.first.call(null,inst_54457);
var state_54491__$1 = state_54491;
var statearr_54510_54531 = state_54491__$1;
(statearr_54510_54531[(2)] = inst_54467);

(statearr_54510_54531[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54492 === (8))){
var inst_54459 = (state_54491[(8)]);
var state_54491__$1 = state_54491;
var statearr_54511_54532 = state_54491__$1;
(statearr_54511_54532[(2)] = inst_54459);

(statearr_54511_54532[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54512 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54512[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54512[(1)] = (1));

return statearr_54512;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54491){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54491);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54513){var ex__2749__auto__ = e54513;
var statearr_54514_54533 = state_54491;
(statearr_54514_54533[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54491[(4)]))){
var statearr_54515_54534 = state_54491;
(statearr_54515_54534[(1)] = cljs.core.first.call(null,(state_54491[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54535 = state_54491;
state_54491 = G__54535;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54491){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54491);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54516 = f__2769__auto__.call(null);
(statearr_54516[(6)] = c__2768__auto__);

return statearr_54516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq54446){
var G__54447 = cljs.core.first.call(null,seq54446);
var seq54446__$1 = cljs.core.next.call(null,seq54446);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54447,seq54446__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54585 = arguments.length;
var i__4865__auto___54586 = (0);
while(true){
if((i__4865__auto___54586 < len__4864__auto___54585)){
args__4870__auto__.push((arguments[i__4865__auto___54586]));

var G__54587 = (i__4865__auto___54586 + (1));
i__4865__auto___54586 = G__54587;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54568){
var state_val_54569 = (state_54568[(1)]);
if((state_val_54569 === (1))){
var state_54568__$1 = state_54568;
var statearr_54570_54588 = state_54568__$1;
(statearr_54570_54588[(2)] = null);

(statearr_54570_54588[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54569 === (2))){
var _ = (function (){var statearr_54571 = state_54568;
(statearr_54571[(4)] = cljs.core.cons.call(null,(5),(state_54568[(4)])));

return statearr_54571;
})();
var inst_54544 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54568__$1 = state_54568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54568__$1,(6),inst_54544);
} else {
if((state_val_54569 === (3))){
var inst_54566 = (state_54568[(2)]);
var state_54568__$1 = state_54568;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54568__$1,inst_54566);
} else {
if((state_val_54569 === (4))){
var inst_54538 = (state_54568[(2)]);
var state_54568__$1 = state_54568;
var statearr_54573_54589 = state_54568__$1;
(statearr_54573_54589[(2)] = inst_54538);

(statearr_54573_54589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54569 === (5))){
var _ = (function (){var statearr_54574 = state_54568;
(statearr_54574[(4)] = cljs.core.rest.call(null,(state_54568[(4)])));

return statearr_54574;
})();
var state_54568__$1 = state_54568;
var ex54572 = (state_54568__$1[(2)]);
var statearr_54575_54590 = state_54568__$1;
(statearr_54575_54590[(5)] = ex54572);


if((ex54572 instanceof Error)){
var statearr_54576_54591 = state_54568__$1;
(statearr_54576_54591[(1)] = (4));

(statearr_54576_54591[(5)] = null);

} else {
throw ex54572;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54569 === (6))){
var inst_54546 = (state_54568[(2)]);
var inst_54547 = fluree.db.util.async.throw_err.call(null,inst_54546);
var inst_54548 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_54547);
var inst_54549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54550 = [inst_54547];
var inst_54551 = (new cljs.core.PersistentVector(null,1,(5),inst_54549,inst_54550,null));
var inst_54552 = cljs.core.count.call(null,inst_54551);
var inst_54553 = ((9) + inst_54552);
var inst_54554 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54555 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54557 = [inst_54547];
var inst_54558 = (new cljs.core.PersistentVector(null,1,(5),inst_54556,inst_54557,null));
var inst_54559 = ["==",inst_54558,inst_54548];
var inst_54560 = cljs.core.PersistentHashMap.fromArrays(inst_54555,inst_54559);
var inst_54561 = [inst_54560,inst_54553];
var inst_54562 = (new cljs.core.PersistentVector(null,2,(5),inst_54554,inst_54561,null));
var inst_54563 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54562);
var _ = (function (){var statearr_54577 = state_54568;
(statearr_54577[(4)] = cljs.core.rest.call(null,(state_54568[(4)])));

return statearr_54577;
})();
var state_54568__$1 = (function (){var statearr_54578 = state_54568;
(statearr_54578[(7)] = inst_54563);

return statearr_54578;
})();
var statearr_54579_54592 = state_54568__$1;
(statearr_54579_54592[(2)] = inst_54548);

(statearr_54579_54592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54580 = [null,null,null,null,null,null,null,null];
(statearr_54580[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54580[(1)] = (1));

return statearr_54580;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54568){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54568);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54581){var ex__2749__auto__ = e54581;
var statearr_54582_54593 = state_54568;
(statearr_54582_54593[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54568[(4)]))){
var statearr_54583_54594 = state_54568;
(statearr_54583_54594[(1)] = cljs.core.first.call(null,(state_54568[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54595 = state_54568;
state_54568 = G__54595;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54568){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54584 = f__2769__auto__.call(null);
(statearr_54584[(6)] = c__2768__auto__);

return statearr_54584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq54536){
var G__54537 = cljs.core.first.call(null,seq54536);
var seq54536__$1 = cljs.core.next.call(null,seq54536);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54537,seq54536__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54645 = arguments.length;
var i__4865__auto___54646 = (0);
while(true){
if((i__4865__auto___54646 < len__4864__auto___54645)){
args__4870__auto__.push((arguments[i__4865__auto___54646]));

var G__54647 = (i__4865__auto___54646 + (1));
i__4865__auto___54646 = G__54647;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54628){
var state_val_54629 = (state_54628[(1)]);
if((state_val_54629 === (1))){
var state_54628__$1 = state_54628;
var statearr_54630_54648 = state_54628__$1;
(statearr_54630_54648[(2)] = null);

(statearr_54630_54648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54629 === (2))){
var _ = (function (){var statearr_54631 = state_54628;
(statearr_54631[(4)] = cljs.core.cons.call(null,(5),(state_54628[(4)])));

return statearr_54631;
})();
var inst_54604 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54628__$1 = state_54628;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54628__$1,(6),inst_54604);
} else {
if((state_val_54629 === (3))){
var inst_54626 = (state_54628[(2)]);
var state_54628__$1 = state_54628;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54628__$1,inst_54626);
} else {
if((state_val_54629 === (4))){
var inst_54598 = (state_54628[(2)]);
var state_54628__$1 = state_54628;
var statearr_54633_54649 = state_54628__$1;
(statearr_54633_54649[(2)] = inst_54598);

(statearr_54633_54649[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54629 === (5))){
var _ = (function (){var statearr_54634 = state_54628;
(statearr_54634[(4)] = cljs.core.rest.call(null,(state_54628[(4)])));

return statearr_54634;
})();
var state_54628__$1 = state_54628;
var ex54632 = (state_54628__$1[(2)]);
var statearr_54635_54650 = state_54628__$1;
(statearr_54635_54650[(5)] = ex54632);


if((ex54632 instanceof Error)){
var statearr_54636_54651 = state_54628__$1;
(statearr_54636_54651[(1)] = (4));

(statearr_54636_54651[(5)] = null);

} else {
throw ex54632;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54629 === (6))){
var inst_54606 = (state_54628[(2)]);
var inst_54607 = fluree.db.util.async.throw_err.call(null,inst_54606);
var inst_54608 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_54607);
var inst_54609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54610 = [inst_54607];
var inst_54611 = (new cljs.core.PersistentVector(null,1,(5),inst_54609,inst_54610,null));
var inst_54612 = cljs.core.count.call(null,inst_54611);
var inst_54613 = ((9) + inst_54612);
var inst_54614 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54615 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54617 = [inst_54607];
var inst_54618 = (new cljs.core.PersistentVector(null,1,(5),inst_54616,inst_54617,null));
var inst_54619 = [">",inst_54618,inst_54608];
var inst_54620 = cljs.core.PersistentHashMap.fromArrays(inst_54615,inst_54619);
var inst_54621 = [inst_54620,inst_54613];
var inst_54622 = (new cljs.core.PersistentVector(null,2,(5),inst_54614,inst_54621,null));
var inst_54623 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54622);
var _ = (function (){var statearr_54637 = state_54628;
(statearr_54637[(4)] = cljs.core.rest.call(null,(state_54628[(4)])));

return statearr_54637;
})();
var state_54628__$1 = (function (){var statearr_54638 = state_54628;
(statearr_54638[(7)] = inst_54623);

return statearr_54638;
})();
var statearr_54639_54652 = state_54628__$1;
(statearr_54639_54652[(2)] = inst_54608);

(statearr_54639_54652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54640 = [null,null,null,null,null,null,null,null];
(statearr_54640[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54640[(1)] = (1));

return statearr_54640;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54628){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54628);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54641){var ex__2749__auto__ = e54641;
var statearr_54642_54653 = state_54628;
(statearr_54642_54653[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54628[(4)]))){
var statearr_54643_54654 = state_54628;
(statearr_54643_54654[(1)] = cljs.core.first.call(null,(state_54628[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54655 = state_54628;
state_54628 = G__54655;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54628){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54644 = f__2769__auto__.call(null);
(statearr_54644[(6)] = c__2768__auto__);

return statearr_54644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq54596){
var G__54597 = cljs.core.first.call(null,seq54596);
var seq54596__$1 = cljs.core.next.call(null,seq54596);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54597,seq54596__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54705 = arguments.length;
var i__4865__auto___54706 = (0);
while(true){
if((i__4865__auto___54706 < len__4864__auto___54705)){
args__4870__auto__.push((arguments[i__4865__auto___54706]));

var G__54707 = (i__4865__auto___54706 + (1));
i__4865__auto___54706 = G__54707;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54688){
var state_val_54689 = (state_54688[(1)]);
if((state_val_54689 === (1))){
var state_54688__$1 = state_54688;
var statearr_54690_54708 = state_54688__$1;
(statearr_54690_54708[(2)] = null);

(statearr_54690_54708[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54689 === (2))){
var _ = (function (){var statearr_54691 = state_54688;
(statearr_54691[(4)] = cljs.core.cons.call(null,(5),(state_54688[(4)])));

return statearr_54691;
})();
var inst_54664 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54688__$1 = state_54688;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54688__$1,(6),inst_54664);
} else {
if((state_val_54689 === (3))){
var inst_54686 = (state_54688[(2)]);
var state_54688__$1 = state_54688;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54688__$1,inst_54686);
} else {
if((state_val_54689 === (4))){
var inst_54658 = (state_54688[(2)]);
var state_54688__$1 = state_54688;
var statearr_54693_54709 = state_54688__$1;
(statearr_54693_54709[(2)] = inst_54658);

(statearr_54693_54709[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54689 === (5))){
var _ = (function (){var statearr_54694 = state_54688;
(statearr_54694[(4)] = cljs.core.rest.call(null,(state_54688[(4)])));

return statearr_54694;
})();
var state_54688__$1 = state_54688;
var ex54692 = (state_54688__$1[(2)]);
var statearr_54695_54710 = state_54688__$1;
(statearr_54695_54710[(5)] = ex54692);


if((ex54692 instanceof Error)){
var statearr_54696_54711 = state_54688__$1;
(statearr_54696_54711[(1)] = (4));

(statearr_54696_54711[(5)] = null);

} else {
throw ex54692;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54689 === (6))){
var inst_54666 = (state_54688[(2)]);
var inst_54667 = fluree.db.util.async.throw_err.call(null,inst_54666);
var inst_54668 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_54667);
var inst_54669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54670 = [inst_54667];
var inst_54671 = (new cljs.core.PersistentVector(null,1,(5),inst_54669,inst_54670,null));
var inst_54672 = cljs.core.count.call(null,inst_54671);
var inst_54673 = ((9) + inst_54672);
var inst_54674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54675 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54677 = [inst_54667];
var inst_54678 = (new cljs.core.PersistentVector(null,1,(5),inst_54676,inst_54677,null));
var inst_54679 = ["<",inst_54678,inst_54668];
var inst_54680 = cljs.core.PersistentHashMap.fromArrays(inst_54675,inst_54679);
var inst_54681 = [inst_54680,inst_54673];
var inst_54682 = (new cljs.core.PersistentVector(null,2,(5),inst_54674,inst_54681,null));
var inst_54683 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54682);
var _ = (function (){var statearr_54697 = state_54688;
(statearr_54697[(4)] = cljs.core.rest.call(null,(state_54688[(4)])));

return statearr_54697;
})();
var state_54688__$1 = (function (){var statearr_54698 = state_54688;
(statearr_54698[(7)] = inst_54683);

return statearr_54698;
})();
var statearr_54699_54712 = state_54688__$1;
(statearr_54699_54712[(2)] = inst_54668);

(statearr_54699_54712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54700 = [null,null,null,null,null,null,null,null];
(statearr_54700[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54700[(1)] = (1));

return statearr_54700;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54688){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54688);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54701){var ex__2749__auto__ = e54701;
var statearr_54702_54713 = state_54688;
(statearr_54702_54713[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54688[(4)]))){
var statearr_54703_54714 = state_54688;
(statearr_54703_54714[(1)] = cljs.core.first.call(null,(state_54688[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54715 = state_54688;
state_54688 = G__54715;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54688){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54688);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54704 = f__2769__auto__.call(null);
(statearr_54704[(6)] = c__2768__auto__);

return statearr_54704;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq54656){
var G__54657 = cljs.core.first.call(null,seq54656);
var seq54656__$1 = cljs.core.next.call(null,seq54656);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54657,seq54656__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54765 = arguments.length;
var i__4865__auto___54766 = (0);
while(true){
if((i__4865__auto___54766 < len__4864__auto___54765)){
args__4870__auto__.push((arguments[i__4865__auto___54766]));

var G__54767 = (i__4865__auto___54766 + (1));
i__4865__auto___54766 = G__54767;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54748){
var state_val_54749 = (state_54748[(1)]);
if((state_val_54749 === (1))){
var state_54748__$1 = state_54748;
var statearr_54750_54768 = state_54748__$1;
(statearr_54750_54768[(2)] = null);

(statearr_54750_54768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54749 === (2))){
var _ = (function (){var statearr_54751 = state_54748;
(statearr_54751[(4)] = cljs.core.cons.call(null,(5),(state_54748[(4)])));

return statearr_54751;
})();
var inst_54724 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54748__$1 = state_54748;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54748__$1,(6),inst_54724);
} else {
if((state_val_54749 === (3))){
var inst_54746 = (state_54748[(2)]);
var state_54748__$1 = state_54748;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54748__$1,inst_54746);
} else {
if((state_val_54749 === (4))){
var inst_54718 = (state_54748[(2)]);
var state_54748__$1 = state_54748;
var statearr_54753_54769 = state_54748__$1;
(statearr_54753_54769[(2)] = inst_54718);

(statearr_54753_54769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54749 === (5))){
var _ = (function (){var statearr_54754 = state_54748;
(statearr_54754[(4)] = cljs.core.rest.call(null,(state_54748[(4)])));

return statearr_54754;
})();
var state_54748__$1 = state_54748;
var ex54752 = (state_54748__$1[(2)]);
var statearr_54755_54770 = state_54748__$1;
(statearr_54755_54770[(5)] = ex54752);


if((ex54752 instanceof Error)){
var statearr_54756_54771 = state_54748__$1;
(statearr_54756_54771[(1)] = (4));

(statearr_54756_54771[(5)] = null);

} else {
throw ex54752;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54749 === (6))){
var inst_54726 = (state_54748[(2)]);
var inst_54727 = fluree.db.util.async.throw_err.call(null,inst_54726);
var inst_54728 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_54727);
var inst_54729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54730 = [inst_54727];
var inst_54731 = (new cljs.core.PersistentVector(null,1,(5),inst_54729,inst_54730,null));
var inst_54732 = cljs.core.count.call(null,inst_54731);
var inst_54733 = ((9) + inst_54732);
var inst_54734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54735 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54737 = [inst_54727];
var inst_54738 = (new cljs.core.PersistentVector(null,1,(5),inst_54736,inst_54737,null));
var inst_54739 = ["<=",inst_54738,inst_54728];
var inst_54740 = cljs.core.PersistentHashMap.fromArrays(inst_54735,inst_54739);
var inst_54741 = [inst_54740,inst_54733];
var inst_54742 = (new cljs.core.PersistentVector(null,2,(5),inst_54734,inst_54741,null));
var inst_54743 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54742);
var _ = (function (){var statearr_54757 = state_54748;
(statearr_54757[(4)] = cljs.core.rest.call(null,(state_54748[(4)])));

return statearr_54757;
})();
var state_54748__$1 = (function (){var statearr_54758 = state_54748;
(statearr_54758[(7)] = inst_54743);

return statearr_54758;
})();
var statearr_54759_54772 = state_54748__$1;
(statearr_54759_54772[(2)] = inst_54728);

(statearr_54759_54772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54760 = [null,null,null,null,null,null,null,null];
(statearr_54760[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54760[(1)] = (1));

return statearr_54760;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54748){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54748);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54761){var ex__2749__auto__ = e54761;
var statearr_54762_54773 = state_54748;
(statearr_54762_54773[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54748[(4)]))){
var statearr_54763_54774 = state_54748;
(statearr_54763_54774[(1)] = cljs.core.first.call(null,(state_54748[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54775 = state_54748;
state_54748 = G__54775;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54748){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54764 = f__2769__auto__.call(null);
(statearr_54764[(6)] = c__2768__auto__);

return statearr_54764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq54716){
var G__54717 = cljs.core.first.call(null,seq54716);
var seq54716__$1 = cljs.core.next.call(null,seq54716);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54717,seq54716__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54825 = arguments.length;
var i__4865__auto___54826 = (0);
while(true){
if((i__4865__auto___54826 < len__4864__auto___54825)){
args__4870__auto__.push((arguments[i__4865__auto___54826]));

var G__54827 = (i__4865__auto___54826 + (1));
i__4865__auto___54826 = G__54827;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54808){
var state_val_54809 = (state_54808[(1)]);
if((state_val_54809 === (1))){
var state_54808__$1 = state_54808;
var statearr_54810_54828 = state_54808__$1;
(statearr_54810_54828[(2)] = null);

(statearr_54810_54828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54809 === (2))){
var _ = (function (){var statearr_54811 = state_54808;
(statearr_54811[(4)] = cljs.core.cons.call(null,(5),(state_54808[(4)])));

return statearr_54811;
})();
var inst_54784 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54808__$1 = state_54808;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54808__$1,(6),inst_54784);
} else {
if((state_val_54809 === (3))){
var inst_54806 = (state_54808[(2)]);
var state_54808__$1 = state_54808;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54808__$1,inst_54806);
} else {
if((state_val_54809 === (4))){
var inst_54778 = (state_54808[(2)]);
var state_54808__$1 = state_54808;
var statearr_54813_54829 = state_54808__$1;
(statearr_54813_54829[(2)] = inst_54778);

(statearr_54813_54829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54809 === (5))){
var _ = (function (){var statearr_54814 = state_54808;
(statearr_54814[(4)] = cljs.core.rest.call(null,(state_54808[(4)])));

return statearr_54814;
})();
var state_54808__$1 = state_54808;
var ex54812 = (state_54808__$1[(2)]);
var statearr_54815_54830 = state_54808__$1;
(statearr_54815_54830[(5)] = ex54812);


if((ex54812 instanceof Error)){
var statearr_54816_54831 = state_54808__$1;
(statearr_54816_54831[(1)] = (4));

(statearr_54816_54831[(5)] = null);

} else {
throw ex54812;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54809 === (6))){
var inst_54786 = (state_54808[(2)]);
var inst_54787 = fluree.db.util.async.throw_err.call(null,inst_54786);
var inst_54788 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_54787);
var inst_54789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54790 = [inst_54787];
var inst_54791 = (new cljs.core.PersistentVector(null,1,(5),inst_54789,inst_54790,null));
var inst_54792 = cljs.core.count.call(null,inst_54791);
var inst_54793 = ((9) + inst_54792);
var inst_54794 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54795 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54797 = [inst_54787];
var inst_54798 = (new cljs.core.PersistentVector(null,1,(5),inst_54796,inst_54797,null));
var inst_54799 = [">=",inst_54798,inst_54788];
var inst_54800 = cljs.core.PersistentHashMap.fromArrays(inst_54795,inst_54799);
var inst_54801 = [inst_54800,inst_54793];
var inst_54802 = (new cljs.core.PersistentVector(null,2,(5),inst_54794,inst_54801,null));
var inst_54803 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54802);
var _ = (function (){var statearr_54817 = state_54808;
(statearr_54817[(4)] = cljs.core.rest.call(null,(state_54808[(4)])));

return statearr_54817;
})();
var state_54808__$1 = (function (){var statearr_54818 = state_54808;
(statearr_54818[(7)] = inst_54803);

return statearr_54818;
})();
var statearr_54819_54832 = state_54808__$1;
(statearr_54819_54832[(2)] = inst_54788);

(statearr_54819_54832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54820 = [null,null,null,null,null,null,null,null];
(statearr_54820[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54820[(1)] = (1));

return statearr_54820;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54808){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54808);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54821){var ex__2749__auto__ = e54821;
var statearr_54822_54833 = state_54808;
(statearr_54822_54833[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54808[(4)]))){
var statearr_54823_54834 = state_54808;
(statearr_54823_54834[(1)] = cljs.core.first.call(null,(state_54808[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54835 = state_54808;
state_54808 = G__54835;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54808){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54808);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54824 = f__2769__auto__.call(null);
(statearr_54824[(6)] = c__2768__auto__);

return statearr_54824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq54776){
var G__54777 = cljs.core.first.call(null,seq54776);
var seq54776__$1 = cljs.core.next.call(null,seq54776);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54777,seq54776__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54885 = arguments.length;
var i__4865__auto___54886 = (0);
while(true){
if((i__4865__auto___54886 < len__4864__auto___54885)){
args__4870__auto__.push((arguments[i__4865__auto___54886]));

var G__54887 = (i__4865__auto___54886 + (1));
i__4865__auto___54886 = G__54887;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54868){
var state_val_54869 = (state_54868[(1)]);
if((state_val_54869 === (1))){
var state_54868__$1 = state_54868;
var statearr_54870_54888 = state_54868__$1;
(statearr_54870_54888[(2)] = null);

(statearr_54870_54888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54869 === (2))){
var _ = (function (){var statearr_54871 = state_54868;
(statearr_54871[(4)] = cljs.core.cons.call(null,(5),(state_54868[(4)])));

return statearr_54871;
})();
var inst_54844 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54868__$1 = state_54868;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54868__$1,(6),inst_54844);
} else {
if((state_val_54869 === (3))){
var inst_54866 = (state_54868[(2)]);
var state_54868__$1 = state_54868;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54868__$1,inst_54866);
} else {
if((state_val_54869 === (4))){
var inst_54838 = (state_54868[(2)]);
var state_54868__$1 = state_54868;
var statearr_54873_54889 = state_54868__$1;
(statearr_54873_54889[(2)] = inst_54838);

(statearr_54873_54889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54869 === (5))){
var _ = (function (){var statearr_54874 = state_54868;
(statearr_54874[(4)] = cljs.core.rest.call(null,(state_54868[(4)])));

return statearr_54874;
})();
var state_54868__$1 = state_54868;
var ex54872 = (state_54868__$1[(2)]);
var statearr_54875_54890 = state_54868__$1;
(statearr_54875_54890[(5)] = ex54872);


if((ex54872 instanceof Error)){
var statearr_54876_54891 = state_54868__$1;
(statearr_54876_54891[(1)] = (4));

(statearr_54876_54891[(5)] = null);

} else {
throw ex54872;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54869 === (6))){
var inst_54846 = (state_54868[(2)]);
var inst_54847 = fluree.db.util.async.throw_err.call(null,inst_54846);
var inst_54848 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.not_EQ_,inst_54847);
var inst_54849 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54850 = [inst_54847];
var inst_54851 = (new cljs.core.PersistentVector(null,1,(5),inst_54849,inst_54850,null));
var inst_54852 = cljs.core.count.call(null,inst_54851);
var inst_54853 = ((9) + inst_54852);
var inst_54854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54855 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54857 = [inst_54847];
var inst_54858 = (new cljs.core.PersistentVector(null,1,(5),inst_54856,inst_54857,null));
var inst_54859 = ["not=",inst_54858,inst_54848];
var inst_54860 = cljs.core.PersistentHashMap.fromArrays(inst_54855,inst_54859);
var inst_54861 = [inst_54860,inst_54853];
var inst_54862 = (new cljs.core.PersistentVector(null,2,(5),inst_54854,inst_54861,null));
var inst_54863 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54862);
var _ = (function (){var statearr_54877 = state_54868;
(statearr_54877[(4)] = cljs.core.rest.call(null,(state_54868[(4)])));

return statearr_54877;
})();
var state_54868__$1 = (function (){var statearr_54878 = state_54868;
(statearr_54878[(7)] = inst_54863);

return statearr_54878;
})();
var statearr_54879_54892 = state_54868__$1;
(statearr_54879_54892[(2)] = inst_54848);

(statearr_54879_54892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54880 = [null,null,null,null,null,null,null,null];
(statearr_54880[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54880[(1)] = (1));

return statearr_54880;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54868){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54868);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54881){var ex__2749__auto__ = e54881;
var statearr_54882_54893 = state_54868;
(statearr_54882_54893[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54868[(4)]))){
var statearr_54883_54894 = state_54868;
(statearr_54883_54894[(1)] = cljs.core.first.call(null,(state_54868[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54895 = state_54868;
state_54868 = G__54895;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54868){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54884 = f__2769__auto__.call(null);
(statearr_54884[(6)] = c__2768__auto__);

return statearr_54884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq54836){
var G__54837 = cljs.core.first.call(null,seq54836);
var seq54836__$1 = cljs.core.next.call(null,seq54836);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54837,seq54836__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54945 = arguments.length;
var i__4865__auto___54946 = (0);
while(true){
if((i__4865__auto___54946 < len__4864__auto___54945)){
args__4870__auto__.push((arguments[i__4865__auto___54946]));

var G__54947 = (i__4865__auto___54946 + (1));
i__4865__auto___54946 = G__54947;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54928){
var state_val_54929 = (state_54928[(1)]);
if((state_val_54929 === (1))){
var state_54928__$1 = state_54928;
var statearr_54930_54948 = state_54928__$1;
(statearr_54930_54948[(2)] = null);

(statearr_54930_54948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54929 === (2))){
var _ = (function (){var statearr_54931 = state_54928;
(statearr_54931[(4)] = cljs.core.cons.call(null,(5),(state_54928[(4)])));

return statearr_54931;
})();
var inst_54904 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54928__$1 = state_54928;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54928__$1,(6),inst_54904);
} else {
if((state_val_54929 === (3))){
var inst_54926 = (state_54928[(2)]);
var state_54928__$1 = state_54928;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54928__$1,inst_54926);
} else {
if((state_val_54929 === (4))){
var inst_54898 = (state_54928[(2)]);
var state_54928__$1 = state_54928;
var statearr_54933_54949 = state_54928__$1;
(statearr_54933_54949[(2)] = inst_54898);

(statearr_54933_54949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54929 === (5))){
var _ = (function (){var statearr_54934 = state_54928;
(statearr_54934[(4)] = cljs.core.rest.call(null,(state_54928[(4)])));

return statearr_54934;
})();
var state_54928__$1 = state_54928;
var ex54932 = (state_54928__$1[(2)]);
var statearr_54935_54950 = state_54928__$1;
(statearr_54935_54950[(5)] = ex54932);


if((ex54932 instanceof Error)){
var statearr_54936_54951 = state_54928__$1;
(statearr_54936_54951[(1)] = (4));

(statearr_54936_54951[(5)] = null);

} else {
throw ex54932;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54929 === (6))){
var inst_54906 = (state_54928[(2)]);
var inst_54907 = fluree.db.util.async.throw_err.call(null,inst_54906);
var inst_54908 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_54907);
var inst_54909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54910 = [inst_54907];
var inst_54911 = (new cljs.core.PersistentVector(null,1,(5),inst_54909,inst_54910,null));
var inst_54912 = cljs.core.count.call(null,inst_54911);
var inst_54913 = ((9) + inst_54912);
var inst_54914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54915 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54917 = [inst_54907];
var inst_54918 = (new cljs.core.PersistentVector(null,1,(5),inst_54916,inst_54917,null));
var inst_54919 = ["max",inst_54918,inst_54908];
var inst_54920 = cljs.core.PersistentHashMap.fromArrays(inst_54915,inst_54919);
var inst_54921 = [inst_54920,inst_54913];
var inst_54922 = (new cljs.core.PersistentVector(null,2,(5),inst_54914,inst_54921,null));
var inst_54923 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54922);
var _ = (function (){var statearr_54937 = state_54928;
(statearr_54937[(4)] = cljs.core.rest.call(null,(state_54928[(4)])));

return statearr_54937;
})();
var state_54928__$1 = (function (){var statearr_54938 = state_54928;
(statearr_54938[(7)] = inst_54923);

return statearr_54938;
})();
var statearr_54939_54952 = state_54928__$1;
(statearr_54939_54952[(2)] = inst_54908);

(statearr_54939_54952[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54940 = [null,null,null,null,null,null,null,null];
(statearr_54940[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54940[(1)] = (1));

return statearr_54940;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54928){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54928);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54941){var ex__2749__auto__ = e54941;
var statearr_54942_54953 = state_54928;
(statearr_54942_54953[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54928[(4)]))){
var statearr_54943_54954 = state_54928;
(statearr_54943_54954[(1)] = cljs.core.first.call(null,(state_54928[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54955 = state_54928;
state_54928 = G__54955;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54928){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54944 = f__2769__auto__.call(null);
(statearr_54944[(6)] = c__2768__auto__);

return statearr_54944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq54896){
var G__54897 = cljs.core.first.call(null,seq54896);
var seq54896__$1 = cljs.core.next.call(null,seq54896);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54897,seq54896__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55005 = arguments.length;
var i__4865__auto___55006 = (0);
while(true){
if((i__4865__auto___55006 < len__4864__auto___55005)){
args__4870__auto__.push((arguments[i__4865__auto___55006]));

var G__55007 = (i__4865__auto___55006 + (1));
i__4865__auto___55006 = G__55007;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54988){
var state_val_54989 = (state_54988[(1)]);
if((state_val_54989 === (1))){
var state_54988__$1 = state_54988;
var statearr_54990_55008 = state_54988__$1;
(statearr_54990_55008[(2)] = null);

(statearr_54990_55008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54989 === (2))){
var _ = (function (){var statearr_54991 = state_54988;
(statearr_54991[(4)] = cljs.core.cons.call(null,(5),(state_54988[(4)])));

return statearr_54991;
})();
var inst_54964 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54988__$1 = state_54988;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54988__$1,(6),inst_54964);
} else {
if((state_val_54989 === (3))){
var inst_54986 = (state_54988[(2)]);
var state_54988__$1 = state_54988;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54988__$1,inst_54986);
} else {
if((state_val_54989 === (4))){
var inst_54958 = (state_54988[(2)]);
var state_54988__$1 = state_54988;
var statearr_54993_55009 = state_54988__$1;
(statearr_54993_55009[(2)] = inst_54958);

(statearr_54993_55009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54989 === (5))){
var _ = (function (){var statearr_54994 = state_54988;
(statearr_54994[(4)] = cljs.core.rest.call(null,(state_54988[(4)])));

return statearr_54994;
})();
var state_54988__$1 = state_54988;
var ex54992 = (state_54988__$1[(2)]);
var statearr_54995_55010 = state_54988__$1;
(statearr_54995_55010[(5)] = ex54992);


if((ex54992 instanceof Error)){
var statearr_54996_55011 = state_54988__$1;
(statearr_54996_55011[(1)] = (4));

(statearr_54996_55011[(5)] = null);

} else {
throw ex54992;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54989 === (6))){
var inst_54966 = (state_54988[(2)]);
var inst_54967 = fluree.db.util.async.throw_err.call(null,inst_54966);
var inst_54968 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_54967);
var inst_54969 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54970 = [inst_54967];
var inst_54971 = (new cljs.core.PersistentVector(null,1,(5),inst_54969,inst_54970,null));
var inst_54972 = cljs.core.count.call(null,inst_54971);
var inst_54973 = ((9) + inst_54972);
var inst_54974 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54975 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54977 = [inst_54967];
var inst_54978 = (new cljs.core.PersistentVector(null,1,(5),inst_54976,inst_54977,null));
var inst_54979 = ["min",inst_54978,inst_54968];
var inst_54980 = cljs.core.PersistentHashMap.fromArrays(inst_54975,inst_54979);
var inst_54981 = [inst_54980,inst_54973];
var inst_54982 = (new cljs.core.PersistentVector(null,2,(5),inst_54974,inst_54981,null));
var inst_54983 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54982);
var _ = (function (){var statearr_54997 = state_54988;
(statearr_54997[(4)] = cljs.core.rest.call(null,(state_54988[(4)])));

return statearr_54997;
})();
var state_54988__$1 = (function (){var statearr_54998 = state_54988;
(statearr_54998[(7)] = inst_54983);

return statearr_54998;
})();
var statearr_54999_55012 = state_54988__$1;
(statearr_54999_55012[(2)] = inst_54968);

(statearr_54999_55012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55000 = [null,null,null,null,null,null,null,null];
(statearr_55000[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55000[(1)] = (1));

return statearr_55000;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54988){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54988);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55001){var ex__2749__auto__ = e55001;
var statearr_55002_55013 = state_54988;
(statearr_55002_55013[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54988[(4)]))){
var statearr_55003_55014 = state_54988;
(statearr_55003_55014[(1)] = cljs.core.first.call(null,(state_54988[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55015 = state_54988;
state_54988 = G__55015;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54988){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54988);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55004 = f__2769__auto__.call(null);
(statearr_55004[(6)] = c__2768__auto__);

return statearr_55004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq54956){
var G__54957 = cljs.core.first.call(null,seq54956);
var seq54956__$1 = cljs.core.next.call(null,seq54956);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54957,seq54956__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__55017 = arguments.length;
switch (G__55017) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55062){
var state_val_55063 = (state_55062[(1)]);
if((state_val_55063 === (7))){
var state_55062__$1 = state_55062;
var statearr_55064_55201 = state_55062__$1;
(statearr_55064_55201[(2)] = query_map);

(statearr_55064_55201[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55063 === (1))){
var state_55062__$1 = state_55062;
var statearr_55065_55202 = state_55062__$1;
(statearr_55065_55202[(2)] = null);

(statearr_55065_55202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55063 === (4))){
var inst_55018 = (state_55062[(2)]);
var state_55062__$1 = state_55062;
var statearr_55066_55203 = state_55062__$1;
(statearr_55066_55203[(2)] = inst_55018);

(statearr_55066_55203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55063 === (13))){
var inst_55040 = (state_55062[(7)]);
var inst_55044 = (state_55062[(2)]);
var inst_55045 = fluree.db.util.async.throw_err.call(null,inst_55044);
var inst_55046 = cljs.core.nth.call(null,inst_55045,(0),null);
var inst_55047 = cljs.core.nth.call(null,inst_55045,(1),null);
var inst_55048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55049 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55051 = [inst_55040];
var inst_55052 = (new cljs.core.PersistentVector(null,1,(5),inst_55050,inst_55051,null));
var inst_55053 = ["query",inst_55052,inst_55046];
var inst_55054 = cljs.core.PersistentHashMap.fromArrays(inst_55049,inst_55053);
var inst_55055 = [inst_55054,inst_55047];
var inst_55056 = (new cljs.core.PersistentVector(null,2,(5),inst_55048,inst_55055,null));
var inst_55057 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55056);
var _ = (function (){var statearr_55067 = state_55062;
(statearr_55067[(4)] = cljs.core.rest.call(null,(state_55062[(4)])));

return statearr_55067;
})();
var state_55062__$1 = (function (){var statearr_55068 = state_55062;
(statearr_55068[(8)] = inst_55057);

return statearr_55068;
})();
var statearr_55069_55204 = state_55062__$1;
(statearr_55069_55204[(2)] = inst_55046);

(statearr_55069_55204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55063 === (6))){
var state_55062__$1 = state_55062;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55062__$1,(9),query_map);
} else {
if((state_val_55063 === (3))){
var inst_55060 = (state_55062[(2)]);
var state_55062__$1 = state_55062;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55062__$1,inst_55060);
} else {
if((state_val_55063 === (12))){
var inst_55040 = (state_55062[(7)]);
var inst_55040__$1 = (state_55062[(2)]);
var inst_55041 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55042 = fluree.db.dbfunctions.internal.query.call(null,inst_55041,inst_55040__$1);
var state_55062__$1 = (function (){var statearr_55070 = state_55062;
(statearr_55070[(7)] = inst_55040__$1);

return statearr_55070;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55062__$1,(13),inst_55042);
} else {
if((state_val_55063 === (2))){
var _ = (function (){var statearr_55071 = state_55062;
(statearr_55071[(4)] = cljs.core.cons.call(null,(5),(state_55062[(4)])));

return statearr_55071;
})();
var inst_55027 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_55062__$1 = state_55062;
if(inst_55027){
var statearr_55072_55205 = state_55062__$1;
(statearr_55072_55205[(1)] = (6));

} else {
var statearr_55073_55206 = state_55062__$1;
(statearr_55073_55206[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55063 === (11))){
var inst_55034 = (state_55062[(9)]);
var state_55062__$1 = state_55062;
var statearr_55075_55207 = state_55062__$1;
(statearr_55075_55207[(2)] = inst_55034);

(statearr_55075_55207[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55063 === (9))){
var inst_55030 = (state_55062[(2)]);
var inst_55031 = fluree.db.util.async.throw_err.call(null,inst_55030);
var state_55062__$1 = state_55062;
var statearr_55076_55208 = state_55062__$1;
(statearr_55076_55208[(2)] = inst_55031);

(statearr_55076_55208[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55063 === (5))){
var _ = (function (){var statearr_55077 = state_55062;
(statearr_55077[(4)] = cljs.core.rest.call(null,(state_55062[(4)])));

return statearr_55077;
})();
var state_55062__$1 = state_55062;
var ex55074 = (state_55062__$1[(2)]);
var statearr_55078_55209 = state_55062__$1;
(statearr_55078_55209[(5)] = ex55074);


if((ex55074 instanceof Error)){
var statearr_55079_55210 = state_55062__$1;
(statearr_55079_55210[(1)] = (4));

(statearr_55079_55210[(5)] = null);

} else {
throw ex55074;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55063 === (10))){
var inst_55034 = (state_55062[(9)]);
var inst_55037 = fluree.db.util.json.parse.call(null,inst_55034);
var state_55062__$1 = state_55062;
var statearr_55080_55211 = state_55062__$1;
(statearr_55080_55211[(2)] = inst_55037);

(statearr_55080_55211[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55063 === (8))){
var inst_55034 = (state_55062[(9)]);
var inst_55034__$1 = (state_55062[(2)]);
var inst_55035 = typeof inst_55034__$1 === 'string';
var state_55062__$1 = (function (){var statearr_55081 = state_55062;
(statearr_55081[(9)] = inst_55034__$1);

return statearr_55081;
})();
if(cljs.core.truth_(inst_55035)){
var statearr_55082_55212 = state_55062__$1;
(statearr_55082_55212[(1)] = (10));

} else {
var statearr_55083_55213 = state_55062__$1;
(statearr_55083_55213[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55084 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55084[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55084[(1)] = (1));

return statearr_55084;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55062){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55085){var ex__2749__auto__ = e55085;
var statearr_55086_55214 = state_55062;
(statearr_55086_55214[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55062[(4)]))){
var statearr_55087_55215 = state_55062;
(statearr_55087_55215[(1)] = cljs.core.first.call(null,(state_55062[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55216 = state_55062;
state_55062 = G__55216;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55062){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55088 = f__2769__auto__.call(null);
(statearr_55088[(6)] = c__2768__auto__);

return statearr_55088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55159){
var state_val_55160 = (state_55159[(1)]);
if((state_val_55160 === (7))){
var state_55159__$1 = state_55159;
var statearr_55161_55217 = state_55159__$1;
(statearr_55161_55217[(2)] = select);

(statearr_55161_55217[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (20))){
var inst_55129 = (state_55159[(2)]);
var inst_55130 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_55159__$1 = (function (){var statearr_55162 = state_55159;
(statearr_55162[(7)] = inst_55129);

return statearr_55162;
})();
if(inst_55130){
var statearr_55163_55218 = state_55159__$1;
(statearr_55163_55218[(1)] = (22));

} else {
var statearr_55164_55219 = state_55159__$1;
(statearr_55164_55219[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (1))){
var state_55159__$1 = state_55159;
var statearr_55165_55220 = state_55159__$1;
(statearr_55165_55220[(2)] = null);

(statearr_55165_55220[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (24))){
var inst_55113 = (state_55159[(8)]);
var inst_55121 = (state_55159[(9)]);
var inst_55129 = (state_55159[(7)]);
var inst_55105 = (state_55159[(10)]);
var inst_55137 = (state_55159[(2)]);
var inst_55138 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55139 = fluree.db.dbfunctions.internal.query.call(null,inst_55138,inst_55105,inst_55113,inst_55121,inst_55129,inst_55137);
var state_55159__$1 = state_55159;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55159__$1,(26),inst_55139);
} else {
if((state_val_55160 === (4))){
var inst_55089 = (state_55159[(2)]);
var state_55159__$1 = state_55159;
var statearr_55166_55221 = state_55159__$1;
(statearr_55166_55221[(2)] = inst_55089);

(statearr_55166_55221[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (15))){
var state_55159__$1 = state_55159;
var statearr_55167_55222 = state_55159__$1;
(statearr_55167_55222[(2)] = where);

(statearr_55167_55222[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (21))){
var inst_55125 = (state_55159[(2)]);
var inst_55126 = fluree.db.util.async.throw_err.call(null,inst_55125);
var state_55159__$1 = state_55159;
var statearr_55168_55223 = state_55159__$1;
(statearr_55168_55223[(2)] = inst_55126);

(statearr_55168_55223[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (13))){
var inst_55109 = (state_55159[(2)]);
var inst_55110 = fluree.db.util.async.throw_err.call(null,inst_55109);
var state_55159__$1 = state_55159;
var statearr_55169_55224 = state_55159__$1;
(statearr_55169_55224[(2)] = inst_55110);

(statearr_55169_55224[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (22))){
var state_55159__$1 = state_55159;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55159__$1,(25),limit);
} else {
if((state_val_55160 === (6))){
var state_55159__$1 = state_55159;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55159__$1,(9),select);
} else {
if((state_val_55160 === (25))){
var inst_55133 = (state_55159[(2)]);
var inst_55134 = fluree.db.util.async.throw_err.call(null,inst_55133);
var state_55159__$1 = state_55159;
var statearr_55170_55225 = state_55159__$1;
(statearr_55170_55225[(2)] = inst_55134);

(statearr_55170_55225[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (17))){
var inst_55117 = (state_55159[(2)]);
var inst_55118 = fluree.db.util.async.throw_err.call(null,inst_55117);
var state_55159__$1 = state_55159;
var statearr_55171_55226 = state_55159__$1;
(statearr_55171_55226[(2)] = inst_55118);

(statearr_55171_55226[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (3))){
var inst_55157 = (state_55159[(2)]);
var state_55159__$1 = state_55159;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55159__$1,inst_55157);
} else {
if((state_val_55160 === (12))){
var inst_55113 = (state_55159[(2)]);
var inst_55114 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_55159__$1 = (function (){var statearr_55172 = state_55159;
(statearr_55172[(8)] = inst_55113);

return statearr_55172;
})();
if(inst_55114){
var statearr_55173_55227 = state_55159__$1;
(statearr_55173_55227[(1)] = (14));

} else {
var statearr_55174_55228 = state_55159__$1;
(statearr_55174_55228[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (2))){
var _ = (function (){var statearr_55175 = state_55159;
(statearr_55175[(4)] = cljs.core.cons.call(null,(5),(state_55159[(4)])));

return statearr_55175;
})();
var inst_55098 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_55159__$1 = state_55159;
if(inst_55098){
var statearr_55176_55229 = state_55159__$1;
(statearr_55176_55229[(1)] = (6));

} else {
var statearr_55177_55230 = state_55159__$1;
(statearr_55177_55230[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (23))){
var state_55159__$1 = state_55159;
var statearr_55178_55231 = state_55159__$1;
(statearr_55178_55231[(2)] = limit);

(statearr_55178_55231[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (19))){
var state_55159__$1 = state_55159;
var statearr_55179_55232 = state_55159__$1;
(statearr_55179_55232[(2)] = block);

(statearr_55179_55232[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (11))){
var state_55159__$1 = state_55159;
var statearr_55181_55233 = state_55159__$1;
(statearr_55181_55233[(2)] = from);

(statearr_55181_55233[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (9))){
var inst_55101 = (state_55159[(2)]);
var inst_55102 = fluree.db.util.async.throw_err.call(null,inst_55101);
var state_55159__$1 = state_55159;
var statearr_55182_55234 = state_55159__$1;
(statearr_55182_55234[(2)] = inst_55102);

(statearr_55182_55234[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (5))){
var _ = (function (){var statearr_55183 = state_55159;
(statearr_55183[(4)] = cljs.core.rest.call(null,(state_55159[(4)])));

return statearr_55183;
})();
var state_55159__$1 = state_55159;
var ex55180 = (state_55159__$1[(2)]);
var statearr_55184_55235 = state_55159__$1;
(statearr_55184_55235[(5)] = ex55180);


if((ex55180 instanceof Error)){
var statearr_55185_55236 = state_55159__$1;
(statearr_55185_55236[(1)] = (4));

(statearr_55185_55236[(5)] = null);

} else {
throw ex55180;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (14))){
var state_55159__$1 = state_55159;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55159__$1,(17),where);
} else {
if((state_val_55160 === (26))){
var inst_55113 = (state_55159[(8)]);
var inst_55121 = (state_55159[(9)]);
var inst_55129 = (state_55159[(7)]);
var inst_55105 = (state_55159[(10)]);
var inst_55141 = (state_55159[(2)]);
var inst_55142 = fluree.db.util.async.throw_err.call(null,inst_55141);
var inst_55143 = cljs.core.nth.call(null,inst_55142,(0),null);
var inst_55144 = cljs.core.nth.call(null,inst_55142,(1),null);
var inst_55145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55146 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55147 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55148 = [inst_55105,inst_55113,inst_55121,inst_55129];
var inst_55149 = (new cljs.core.PersistentVector(null,4,(5),inst_55147,inst_55148,null));
var inst_55150 = ["query",inst_55149,inst_55143];
var inst_55151 = cljs.core.PersistentHashMap.fromArrays(inst_55146,inst_55150);
var inst_55152 = [inst_55151,inst_55144];
var inst_55153 = (new cljs.core.PersistentVector(null,2,(5),inst_55145,inst_55152,null));
var inst_55154 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55153);
var _ = (function (){var statearr_55186 = state_55159;
(statearr_55186[(4)] = cljs.core.rest.call(null,(state_55159[(4)])));

return statearr_55186;
})();
var state_55159__$1 = (function (){var statearr_55187 = state_55159;
(statearr_55187[(11)] = inst_55154);

return statearr_55187;
})();
var statearr_55188_55237 = state_55159__$1;
(statearr_55188_55237[(2)] = inst_55143);

(statearr_55188_55237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (16))){
var inst_55121 = (state_55159[(2)]);
var inst_55122 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_55159__$1 = (function (){var statearr_55189 = state_55159;
(statearr_55189[(9)] = inst_55121);

return statearr_55189;
})();
if(inst_55122){
var statearr_55190_55238 = state_55159__$1;
(statearr_55190_55238[(1)] = (18));

} else {
var statearr_55191_55239 = state_55159__$1;
(statearr_55191_55239[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (10))){
var state_55159__$1 = state_55159;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55159__$1,(13),from);
} else {
if((state_val_55160 === (18))){
var state_55159__$1 = state_55159;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55159__$1,(21),block);
} else {
if((state_val_55160 === (8))){
var inst_55105 = (state_55159[(2)]);
var inst_55106 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_55159__$1 = (function (){var statearr_55192 = state_55159;
(statearr_55192[(10)] = inst_55105);

return statearr_55192;
})();
if(inst_55106){
var statearr_55193_55240 = state_55159__$1;
(statearr_55193_55240[(1)] = (10));

} else {
var statearr_55194_55241 = state_55159__$1;
(statearr_55194_55241[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55195 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55195[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55195[(1)] = (1));

return statearr_55195;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55159){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55159);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55196){var ex__2749__auto__ = e55196;
var statearr_55197_55242 = state_55159;
(statearr_55197_55242[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55159[(4)]))){
var statearr_55198_55243 = state_55159;
(statearr_55198_55243[(1)] = cljs.core.first.call(null,(state_55159[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55244 = state_55159;
state_55159 = G__55244;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55159){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55159);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55199 = f__2769__auto__.call(null);
(statearr_55199[(6)] = c__2768__auto__);

return statearr_55199;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55300){
var state_val_55301 = (state_55300[(1)]);
if((state_val_55301 === (7))){
var state_55300__$1 = state_55300;
var statearr_55302_55333 = state_55300__$1;
(statearr_55302_55333[(2)] = startSubject);

(statearr_55302_55333[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (1))){
var state_55300__$1 = state_55300;
var statearr_55303_55334 = state_55300__$1;
(statearr_55303_55334[(2)] = null);

(statearr_55303_55334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (4))){
var inst_55245 = (state_55300[(2)]);
var state_55300__$1 = state_55300;
var statearr_55304_55335 = state_55300__$1;
(statearr_55304_55335[(2)] = inst_55245);

(statearr_55304_55335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (15))){
var inst_55277 = (state_55300[(2)]);
var inst_55278 = fluree.db.util.async.throw_err.call(null,inst_55277);
var inst_55279 = cljs.core.nth.call(null,inst_55278,(0),null);
var inst_55280 = cljs.core.nth.call(null,inst_55278,(1),null);
var inst_55281 = cljs.core.empty_QMARK_.call(null,inst_55279);
var state_55300__$1 = (function (){var statearr_55305 = state_55300;
(statearr_55305[(7)] = inst_55280);

return statearr_55305;
})();
if(inst_55281){
var statearr_55306_55336 = state_55300__$1;
(statearr_55306_55336[(1)] = (16));

} else {
var statearr_55307_55337 = state_55300__$1;
(statearr_55307_55337[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (13))){
var inst_55261 = (state_55300[(8)]);
var inst_55273 = (state_55300[(9)]);
var inst_55265 = (state_55300[(10)]);
var inst_55273__$1 = (state_55300[(2)]);
var inst_55274 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55275 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_55274,inst_55261,inst_55265,inst_55273__$1);
var state_55300__$1 = (function (){var statearr_55308 = state_55300;
(statearr_55308[(9)] = inst_55273__$1);

return statearr_55308;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55300__$1,(15),inst_55275);
} else {
if((state_val_55301 === (6))){
var state_55300__$1 = state_55300;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55300__$1,(9),startSubject);
} else {
if((state_val_55301 === (17))){
var state_55300__$1 = state_55300;
var statearr_55309_55338 = state_55300__$1;
(statearr_55309_55338[(2)] = true);

(statearr_55309_55338[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (3))){
var inst_55298 = (state_55300[(2)]);
var state_55300__$1 = state_55300;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55300__$1,inst_55298);
} else {
if((state_val_55301 === (12))){
var state_55300__$1 = state_55300;
var statearr_55310_55339 = state_55300__$1;
(statearr_55310_55339[(2)] = endSubject);

(statearr_55310_55339[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (2))){
var _ = (function (){var statearr_55311 = state_55300;
(statearr_55311[(4)] = cljs.core.cons.call(null,(5),(state_55300[(4)])));

return statearr_55311;
})();
var inst_55254 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_55300__$1 = state_55300;
if(inst_55254){
var statearr_55312_55340 = state_55300__$1;
(statearr_55312_55340[(1)] = (6));

} else {
var statearr_55313_55341 = state_55300__$1;
(statearr_55313_55341[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (11))){
var state_55300__$1 = state_55300;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55300__$1,(14),endSubject);
} else {
if((state_val_55301 === (9))){
var inst_55257 = (state_55300[(2)]);
var inst_55258 = fluree.db.util.async.throw_err.call(null,inst_55257);
var state_55300__$1 = state_55300;
var statearr_55315_55342 = state_55300__$1;
(statearr_55315_55342[(2)] = inst_55258);

(statearr_55315_55342[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (5))){
var _ = (function (){var statearr_55316 = state_55300;
(statearr_55316[(4)] = cljs.core.rest.call(null,(state_55300[(4)])));

return statearr_55316;
})();
var state_55300__$1 = state_55300;
var ex55314 = (state_55300__$1[(2)]);
var statearr_55317_55343 = state_55300__$1;
(statearr_55317_55343[(5)] = ex55314);


if((ex55314 instanceof Error)){
var statearr_55318_55344 = state_55300__$1;
(statearr_55318_55344[(1)] = (4));

(statearr_55318_55344[(5)] = null);

} else {
throw ex55314;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (14))){
var inst_55269 = (state_55300[(2)]);
var inst_55270 = fluree.db.util.async.throw_err.call(null,inst_55269);
var state_55300__$1 = state_55300;
var statearr_55319_55345 = state_55300__$1;
(statearr_55319_55345[(2)] = inst_55270);

(statearr_55319_55345[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (16))){
var state_55300__$1 = state_55300;
var statearr_55320_55346 = state_55300__$1;
(statearr_55320_55346[(2)] = false);

(statearr_55320_55346[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (10))){
var inst_55264 = (state_55300[(2)]);
var inst_55265 = fluree.db.util.async.throw_err.call(null,inst_55264);
var inst_55266 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_55300__$1 = (function (){var statearr_55321 = state_55300;
(statearr_55321[(10)] = inst_55265);

return statearr_55321;
})();
if(inst_55266){
var statearr_55322_55347 = state_55300__$1;
(statearr_55322_55347[(1)] = (11));

} else {
var statearr_55323_55348 = state_55300__$1;
(statearr_55323_55348[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (18))){
var inst_55261 = (state_55300[(8)]);
var inst_55273 = (state_55300[(9)]);
var inst_55280 = (state_55300[(7)]);
var inst_55265 = (state_55300[(10)]);
var inst_55285 = (state_55300[(2)]);
var inst_55286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55287 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55288 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55289 = [inst_55261,inst_55265,inst_55273];
var inst_55290 = (new cljs.core.PersistentVector(null,3,(5),inst_55288,inst_55289,null));
var inst_55291 = ["relationship?",inst_55290,inst_55285];
var inst_55292 = cljs.core.PersistentHashMap.fromArrays(inst_55287,inst_55291);
var inst_55293 = [inst_55292,inst_55280];
var inst_55294 = (new cljs.core.PersistentVector(null,2,(5),inst_55286,inst_55293,null));
var inst_55295 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55294);
var _ = (function (){var statearr_55324 = state_55300;
(statearr_55324[(4)] = cljs.core.rest.call(null,(state_55300[(4)])));

return statearr_55324;
})();
var state_55300__$1 = (function (){var statearr_55325 = state_55300;
(statearr_55325[(11)] = inst_55295);

return statearr_55325;
})();
var statearr_55326_55349 = state_55300__$1;
(statearr_55326_55349[(2)] = inst_55285);

(statearr_55326_55349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (8))){
var inst_55261 = (state_55300[(2)]);
var inst_55262 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_55300__$1 = (function (){var statearr_55327 = state_55300;
(statearr_55327[(8)] = inst_55261);

return statearr_55327;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55300__$1,(10),inst_55262);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_55328 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55328[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__);

(statearr_55328[(1)] = (1));

return statearr_55328;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1 = (function (state_55300){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55300);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55329){var ex__2749__auto__ = e55329;
var statearr_55330_55350 = state_55300;
(statearr_55330_55350[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55300[(4)]))){
var statearr_55331_55351 = state_55300;
(statearr_55331_55351[(1)] = cljs.core.first.call(null,(state_55300[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55352 = state_55300;
state_55300 = G__55352;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__ = function(state_55300){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1.call(this,state_55300);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55332 = f__2769__auto__.call(null);
(statearr_55332[(6)] = c__2768__auto__);

return statearr_55332;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55389){
var state_val_55390 = (state_55389[(1)]);
if((state_val_55390 === (7))){
var state_55389__$1 = state_55389;
var statearr_55391_55411 = state_55389__$1;
(statearr_55391_55411[(2)] = pred_name);

(statearr_55391_55411[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55390 === (1))){
var state_55389__$1 = state_55389;
var statearr_55392_55412 = state_55389__$1;
(statearr_55392_55412[(2)] = null);

(statearr_55392_55412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55390 === (4))){
var inst_55353 = (state_55389[(2)]);
var state_55389__$1 = state_55389;
var statearr_55393_55413 = state_55389__$1;
(statearr_55393_55413[(2)] = inst_55353);

(statearr_55393_55413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55390 === (6))){
var state_55389__$1 = state_55389;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55389__$1,(9),pred_name);
} else {
if((state_val_55390 === (3))){
var inst_55387 = (state_55389[(2)]);
var state_55389__$1 = state_55389;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55389__$1,inst_55387);
} else {
if((state_val_55390 === (2))){
var _ = (function (){var statearr_55395 = state_55389;
(statearr_55395[(4)] = cljs.core.cons.call(null,(5),(state_55389[(4)])));

return statearr_55395;
})();
var inst_55362 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_55389__$1 = state_55389;
if(inst_55362){
var statearr_55396_55414 = state_55389__$1;
(statearr_55396_55414[(1)] = (6));

} else {
var statearr_55397_55415 = state_55389__$1;
(statearr_55397_55415[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55390 === (9))){
var inst_55365 = (state_55389[(2)]);
var inst_55366 = fluree.db.util.async.throw_err.call(null,inst_55365);
var state_55389__$1 = state_55389;
var statearr_55398_55416 = state_55389__$1;
(statearr_55398_55416[(2)] = inst_55366);

(statearr_55398_55416[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55390 === (5))){
var _ = (function (){var statearr_55399 = state_55389;
(statearr_55399[(4)] = cljs.core.rest.call(null,(state_55389[(4)])));

return statearr_55399;
})();
var state_55389__$1 = state_55389;
var ex55394 = (state_55389__$1[(2)]);
var statearr_55400_55417 = state_55389__$1;
(statearr_55400_55417[(5)] = ex55394);


if((ex55394 instanceof Error)){
var statearr_55401_55418 = state_55389__$1;
(statearr_55401_55418[(1)] = (4));

(statearr_55401_55418[(5)] = null);

} else {
throw ex55394;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55390 === (10))){
var inst_55369 = (state_55389[(7)]);
var inst_55373 = (state_55389[(2)]);
var inst_55374 = fluree.db.util.async.throw_err.call(null,inst_55373);
var inst_55375 = cljs.core.nth.call(null,inst_55374,(0),null);
var inst_55376 = cljs.core.nth.call(null,inst_55374,(1),null);
var inst_55377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55378 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55379 = ["max-pred-val",inst_55369,inst_55375];
var inst_55380 = cljs.core.PersistentHashMap.fromArrays(inst_55378,inst_55379);
var inst_55381 = (inst_55376 + (10));
var inst_55382 = [inst_55380,inst_55381];
var inst_55383 = (new cljs.core.PersistentVector(null,2,(5),inst_55377,inst_55382,null));
var inst_55384 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55383);
var _ = (function (){var statearr_55402 = state_55389;
(statearr_55402[(4)] = cljs.core.rest.call(null,(state_55389[(4)])));

return statearr_55402;
})();
var state_55389__$1 = (function (){var statearr_55403 = state_55389;
(statearr_55403[(8)] = inst_55384);

return statearr_55403;
})();
var statearr_55404_55419 = state_55389__$1;
(statearr_55404_55419[(2)] = inst_55375);

(statearr_55404_55419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55390 === (8))){
var inst_55369 = (state_55389[(7)]);
var inst_55369__$1 = (state_55389[(2)]);
var inst_55370 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55371 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_55370,inst_55369__$1,null);
var state_55389__$1 = (function (){var statearr_55405 = state_55389;
(statearr_55405[(7)] = inst_55369__$1);

return statearr_55405;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55389__$1,(10),inst_55371);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0 = (function (){
var statearr_55406 = [null,null,null,null,null,null,null,null,null];
(statearr_55406[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__);

(statearr_55406[(1)] = (1));

return statearr_55406;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1 = (function (state_55389){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55389);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55407){var ex__2749__auto__ = e55407;
var statearr_55408_55420 = state_55389;
(statearr_55408_55420[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55389[(4)]))){
var statearr_55409_55421 = state_55389;
(statearr_55409_55421[(1)] = cljs.core.first.call(null,(state_55389[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55422 = state_55389;
state_55389 = G__55422;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__ = function(state_55389){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1.call(this,state_55389);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55410 = f__2769__auto__.call(null);
(statearr_55410[(6)] = c__2768__auto__);

return statearr_55410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55449){
var state_val_55450 = (state_55449[(1)]);
if((state_val_55450 === (7))){
var state_55449__$1 = state_55449;
var statearr_55451_55470 = state_55449__$1;
(statearr_55451_55470[(2)] = n);

(statearr_55451_55470[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55450 === (1))){
var state_55449__$1 = state_55449;
var statearr_55452_55471 = state_55449__$1;
(statearr_55452_55471[(2)] = null);

(statearr_55452_55471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55450 === (4))){
var inst_55423 = (state_55449[(2)]);
var state_55449__$1 = state_55449;
var statearr_55453_55472 = state_55449__$1;
(statearr_55453_55472[(2)] = inst_55423);

(statearr_55453_55472[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55450 === (6))){
var state_55449__$1 = state_55449;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55449__$1,(9),n);
} else {
if((state_val_55450 === (3))){
var inst_55447 = (state_55449[(2)]);
var state_55449__$1 = state_55449;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55449__$1,inst_55447);
} else {
if((state_val_55450 === (2))){
var _ = (function (){var statearr_55455 = state_55449;
(statearr_55455[(4)] = cljs.core.cons.call(null,(5),(state_55449[(4)])));

return statearr_55455;
})();
var inst_55429 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55449__$1 = state_55449;
if(inst_55429){
var statearr_55456_55473 = state_55449__$1;
(statearr_55456_55473[(1)] = (6));

} else {
var statearr_55457_55474 = state_55449__$1;
(statearr_55457_55474[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55450 === (9))){
var inst_55432 = (state_55449[(2)]);
var inst_55433 = fluree.db.util.async.throw_err.call(null,inst_55432);
var state_55449__$1 = state_55449;
var statearr_55458_55475 = state_55449__$1;
(statearr_55458_55475[(2)] = inst_55433);

(statearr_55458_55475[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55450 === (5))){
var _ = (function (){var statearr_55459 = state_55449;
(statearr_55459[(4)] = cljs.core.rest.call(null,(state_55449[(4)])));

return statearr_55459;
})();
var state_55449__$1 = state_55449;
var ex55454 = (state_55449__$1[(2)]);
var statearr_55460_55476 = state_55449__$1;
(statearr_55460_55476[(5)] = ex55454);


if((ex55454 instanceof Error)){
var statearr_55461_55477 = state_55449__$1;
(statearr_55461_55477[(1)] = (4));

(statearr_55461_55477[(5)] = null);

} else {
throw ex55454;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55450 === (8))){
var inst_55436 = (state_55449[(2)]);
var inst_55437 = fluree.db.dbfunctions.internal.inc.call(null,inst_55436);
var inst_55438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55439 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55440 = ["inc",inst_55436,inst_55437];
var inst_55441 = cljs.core.PersistentHashMap.fromArrays(inst_55439,inst_55440);
var inst_55442 = [inst_55441,(10)];
var inst_55443 = (new cljs.core.PersistentVector(null,2,(5),inst_55438,inst_55442,null));
var inst_55444 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55443);
var _ = (function (){var statearr_55462 = state_55449;
(statearr_55462[(4)] = cljs.core.rest.call(null,(state_55449[(4)])));

return statearr_55462;
})();
var state_55449__$1 = (function (){var statearr_55463 = state_55449;
(statearr_55463[(7)] = inst_55444);

return statearr_55463;
})();
var statearr_55464_55478 = state_55449__$1;
(statearr_55464_55478[(2)] = inst_55437);

(statearr_55464_55478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0 = (function (){
var statearr_55465 = [null,null,null,null,null,null,null,null];
(statearr_55465[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__);

(statearr_55465[(1)] = (1));

return statearr_55465;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1 = (function (state_55449){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55449);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55466){var ex__2749__auto__ = e55466;
var statearr_55467_55479 = state_55449;
(statearr_55467_55479[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55449[(4)]))){
var statearr_55468_55480 = state_55449;
(statearr_55468_55480[(1)] = cljs.core.first.call(null,(state_55449[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55481 = state_55449;
state_55449 = G__55481;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__ = function(state_55449){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1.call(this,state_55449);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55469 = f__2769__auto__.call(null);
(statearr_55469[(6)] = c__2768__auto__);

return statearr_55469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55508){
var state_val_55509 = (state_55508[(1)]);
if((state_val_55509 === (7))){
var state_55508__$1 = state_55508;
var statearr_55510_55529 = state_55508__$1;
(statearr_55510_55529[(2)] = n);

(statearr_55510_55529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55509 === (1))){
var state_55508__$1 = state_55508;
var statearr_55511_55530 = state_55508__$1;
(statearr_55511_55530[(2)] = null);

(statearr_55511_55530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55509 === (4))){
var inst_55482 = (state_55508[(2)]);
var state_55508__$1 = state_55508;
var statearr_55512_55531 = state_55508__$1;
(statearr_55512_55531[(2)] = inst_55482);

(statearr_55512_55531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55509 === (6))){
var state_55508__$1 = state_55508;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55508__$1,(9),n);
} else {
if((state_val_55509 === (3))){
var inst_55506 = (state_55508[(2)]);
var state_55508__$1 = state_55508;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55508__$1,inst_55506);
} else {
if((state_val_55509 === (2))){
var _ = (function (){var statearr_55514 = state_55508;
(statearr_55514[(4)] = cljs.core.cons.call(null,(5),(state_55508[(4)])));

return statearr_55514;
})();
var inst_55488 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55508__$1 = state_55508;
if(inst_55488){
var statearr_55515_55532 = state_55508__$1;
(statearr_55515_55532[(1)] = (6));

} else {
var statearr_55516_55533 = state_55508__$1;
(statearr_55516_55533[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55509 === (9))){
var inst_55491 = (state_55508[(2)]);
var inst_55492 = fluree.db.util.async.throw_err.call(null,inst_55491);
var state_55508__$1 = state_55508;
var statearr_55517_55534 = state_55508__$1;
(statearr_55517_55534[(2)] = inst_55492);

(statearr_55517_55534[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55509 === (5))){
var _ = (function (){var statearr_55518 = state_55508;
(statearr_55518[(4)] = cljs.core.rest.call(null,(state_55508[(4)])));

return statearr_55518;
})();
var state_55508__$1 = state_55508;
var ex55513 = (state_55508__$1[(2)]);
var statearr_55519_55535 = state_55508__$1;
(statearr_55519_55535[(5)] = ex55513);


if((ex55513 instanceof Error)){
var statearr_55520_55536 = state_55508__$1;
(statearr_55520_55536[(1)] = (4));

(statearr_55520_55536[(5)] = null);

} else {
throw ex55513;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55509 === (8))){
var inst_55495 = (state_55508[(2)]);
var inst_55496 = fluree.db.dbfunctions.internal.dec.call(null,inst_55495);
var inst_55497 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55498 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55499 = ["dec",inst_55495,inst_55496];
var inst_55500 = cljs.core.PersistentHashMap.fromArrays(inst_55498,inst_55499);
var inst_55501 = [inst_55500,(10)];
var inst_55502 = (new cljs.core.PersistentVector(null,2,(5),inst_55497,inst_55501,null));
var inst_55503 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55502);
var _ = (function (){var statearr_55521 = state_55508;
(statearr_55521[(4)] = cljs.core.rest.call(null,(state_55508[(4)])));

return statearr_55521;
})();
var state_55508__$1 = (function (){var statearr_55522 = state_55508;
(statearr_55522[(7)] = inst_55503);

return statearr_55522;
})();
var statearr_55523_55537 = state_55508__$1;
(statearr_55523_55537[(2)] = inst_55496);

(statearr_55523_55537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0 = (function (){
var statearr_55524 = [null,null,null,null,null,null,null,null];
(statearr_55524[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__);

(statearr_55524[(1)] = (1));

return statearr_55524;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1 = (function (state_55508){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55508);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55525){var ex__2749__auto__ = e55525;
var statearr_55526_55538 = state_55508;
(statearr_55526_55538[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55508[(4)]))){
var statearr_55527_55539 = state_55508;
(statearr_55527_55539[(1)] = cljs.core.first.call(null,(state_55508[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55540 = state_55508;
state_55508 = G__55540;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__ = function(state_55508){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1.call(this,state_55508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55528 = f__2769__auto__.call(null);
(statearr_55528[(6)] = c__2768__auto__);

return statearr_55528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55590 = arguments.length;
var i__4865__auto___55591 = (0);
while(true){
if((i__4865__auto___55591 < len__4864__auto___55590)){
args__4870__auto__.push((arguments[i__4865__auto___55591]));

var G__55592 = (i__4865__auto___55591 + (1));
i__4865__auto___55591 = G__55592;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55573){
var state_val_55574 = (state_55573[(1)]);
if((state_val_55574 === (1))){
var state_55573__$1 = state_55573;
var statearr_55575_55593 = state_55573__$1;
(statearr_55575_55593[(2)] = null);

(statearr_55575_55593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55574 === (2))){
var _ = (function (){var statearr_55576 = state_55573;
(statearr_55576[(4)] = cljs.core.cons.call(null,(5),(state_55573[(4)])));

return statearr_55576;
})();
var inst_55549 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55573__$1 = state_55573;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55573__$1,(6),inst_55549);
} else {
if((state_val_55574 === (3))){
var inst_55571 = (state_55573[(2)]);
var state_55573__$1 = state_55573;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55573__$1,inst_55571);
} else {
if((state_val_55574 === (4))){
var inst_55543 = (state_55573[(2)]);
var state_55573__$1 = state_55573;
var statearr_55578_55594 = state_55573__$1;
(statearr_55578_55594[(2)] = inst_55543);

(statearr_55578_55594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55574 === (5))){
var _ = (function (){var statearr_55579 = state_55573;
(statearr_55579[(4)] = cljs.core.rest.call(null,(state_55573[(4)])));

return statearr_55579;
})();
var state_55573__$1 = state_55573;
var ex55577 = (state_55573__$1[(2)]);
var statearr_55580_55595 = state_55573__$1;
(statearr_55580_55595[(5)] = ex55577);


if((ex55577 instanceof Error)){
var statearr_55581_55596 = state_55573__$1;
(statearr_55581_55596[(1)] = (4));

(statearr_55581_55596[(5)] = null);

} else {
throw ex55577;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55574 === (6))){
var inst_55551 = (state_55573[(2)]);
var inst_55552 = fluree.db.util.async.throw_err.call(null,inst_55551);
var inst_55553 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_55552);
var inst_55554 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55555 = [inst_55552];
var inst_55556 = (new cljs.core.PersistentVector(null,1,(5),inst_55554,inst_55555,null));
var inst_55557 = cljs.core.count.call(null,inst_55556);
var inst_55558 = ((9) + inst_55557);
var inst_55559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55560 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55562 = [inst_55552];
var inst_55563 = (new cljs.core.PersistentVector(null,1,(5),inst_55561,inst_55562,null));
var inst_55564 = ["+",inst_55563,inst_55553];
var inst_55565 = cljs.core.PersistentHashMap.fromArrays(inst_55560,inst_55564);
var inst_55566 = [inst_55565,inst_55558];
var inst_55567 = (new cljs.core.PersistentVector(null,2,(5),inst_55559,inst_55566,null));
var inst_55568 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55567);
var _ = (function (){var statearr_55582 = state_55573;
(statearr_55582[(4)] = cljs.core.rest.call(null,(state_55573[(4)])));

return statearr_55582;
})();
var state_55573__$1 = (function (){var statearr_55583 = state_55573;
(statearr_55583[(7)] = inst_55568);

return statearr_55583;
})();
var statearr_55584_55597 = state_55573__$1;
(statearr_55584_55597[(2)] = inst_55553);

(statearr_55584_55597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55585 = [null,null,null,null,null,null,null,null];
(statearr_55585[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55585[(1)] = (1));

return statearr_55585;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55573){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55573);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55586){var ex__2749__auto__ = e55586;
var statearr_55587_55598 = state_55573;
(statearr_55587_55598[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55573[(4)]))){
var statearr_55588_55599 = state_55573;
(statearr_55588_55599[(1)] = cljs.core.first.call(null,(state_55573[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55600 = state_55573;
state_55573 = G__55600;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55573){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55589 = f__2769__auto__.call(null);
(statearr_55589[(6)] = c__2768__auto__);

return statearr_55589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq55541){
var G__55542 = cljs.core.first.call(null,seq55541);
var seq55541__$1 = cljs.core.next.call(null,seq55541);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55542,seq55541__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55650 = arguments.length;
var i__4865__auto___55651 = (0);
while(true){
if((i__4865__auto___55651 < len__4864__auto___55650)){
args__4870__auto__.push((arguments[i__4865__auto___55651]));

var G__55652 = (i__4865__auto___55651 + (1));
i__4865__auto___55651 = G__55652;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55633){
var state_val_55634 = (state_55633[(1)]);
if((state_val_55634 === (1))){
var state_55633__$1 = state_55633;
var statearr_55635_55653 = state_55633__$1;
(statearr_55635_55653[(2)] = null);

(statearr_55635_55653[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55634 === (2))){
var _ = (function (){var statearr_55636 = state_55633;
(statearr_55636[(4)] = cljs.core.cons.call(null,(5),(state_55633[(4)])));

return statearr_55636;
})();
var inst_55609 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55633__$1 = state_55633;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55633__$1,(6),inst_55609);
} else {
if((state_val_55634 === (3))){
var inst_55631 = (state_55633[(2)]);
var state_55633__$1 = state_55633;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55633__$1,inst_55631);
} else {
if((state_val_55634 === (4))){
var inst_55603 = (state_55633[(2)]);
var state_55633__$1 = state_55633;
var statearr_55638_55654 = state_55633__$1;
(statearr_55638_55654[(2)] = inst_55603);

(statearr_55638_55654[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55634 === (5))){
var _ = (function (){var statearr_55639 = state_55633;
(statearr_55639[(4)] = cljs.core.rest.call(null,(state_55633[(4)])));

return statearr_55639;
})();
var state_55633__$1 = state_55633;
var ex55637 = (state_55633__$1[(2)]);
var statearr_55640_55655 = state_55633__$1;
(statearr_55640_55655[(5)] = ex55637);


if((ex55637 instanceof Error)){
var statearr_55641_55656 = state_55633__$1;
(statearr_55641_55656[(1)] = (4));

(statearr_55641_55656[(5)] = null);

} else {
throw ex55637;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55634 === (6))){
var inst_55611 = (state_55633[(2)]);
var inst_55612 = fluree.db.util.async.throw_err.call(null,inst_55611);
var inst_55613 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_55612);
var inst_55614 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55615 = [inst_55612];
var inst_55616 = (new cljs.core.PersistentVector(null,1,(5),inst_55614,inst_55615,null));
var inst_55617 = cljs.core.count.call(null,inst_55616);
var inst_55618 = ((9) + inst_55617);
var inst_55619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55620 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55622 = [inst_55612];
var inst_55623 = (new cljs.core.PersistentVector(null,1,(5),inst_55621,inst_55622,null));
var inst_55624 = ["-",inst_55623,inst_55613];
var inst_55625 = cljs.core.PersistentHashMap.fromArrays(inst_55620,inst_55624);
var inst_55626 = [inst_55625,inst_55618];
var inst_55627 = (new cljs.core.PersistentVector(null,2,(5),inst_55619,inst_55626,null));
var inst_55628 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55627);
var _ = (function (){var statearr_55642 = state_55633;
(statearr_55642[(4)] = cljs.core.rest.call(null,(state_55633[(4)])));

return statearr_55642;
})();
var state_55633__$1 = (function (){var statearr_55643 = state_55633;
(statearr_55643[(7)] = inst_55628);

return statearr_55643;
})();
var statearr_55644_55657 = state_55633__$1;
(statearr_55644_55657[(2)] = inst_55613);

(statearr_55644_55657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55645 = [null,null,null,null,null,null,null,null];
(statearr_55645[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55645[(1)] = (1));

return statearr_55645;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55633){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55633);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55646){var ex__2749__auto__ = e55646;
var statearr_55647_55658 = state_55633;
(statearr_55647_55658[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55633[(4)]))){
var statearr_55648_55659 = state_55633;
(statearr_55648_55659[(1)] = cljs.core.first.call(null,(state_55633[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55660 = state_55633;
state_55633 = G__55660;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55633){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55649 = f__2769__auto__.call(null);
(statearr_55649[(6)] = c__2768__auto__);

return statearr_55649;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq55601){
var G__55602 = cljs.core.first.call(null,seq55601);
var seq55601__$1 = cljs.core.next.call(null,seq55601);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55602,seq55601__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55710 = arguments.length;
var i__4865__auto___55711 = (0);
while(true){
if((i__4865__auto___55711 < len__4864__auto___55710)){
args__4870__auto__.push((arguments[i__4865__auto___55711]));

var G__55712 = (i__4865__auto___55711 + (1));
i__4865__auto___55711 = G__55712;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55693){
var state_val_55694 = (state_55693[(1)]);
if((state_val_55694 === (1))){
var state_55693__$1 = state_55693;
var statearr_55695_55713 = state_55693__$1;
(statearr_55695_55713[(2)] = null);

(statearr_55695_55713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55694 === (2))){
var _ = (function (){var statearr_55696 = state_55693;
(statearr_55696[(4)] = cljs.core.cons.call(null,(5),(state_55693[(4)])));

return statearr_55696;
})();
var inst_55669 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55693__$1 = state_55693;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55693__$1,(6),inst_55669);
} else {
if((state_val_55694 === (3))){
var inst_55691 = (state_55693[(2)]);
var state_55693__$1 = state_55693;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55693__$1,inst_55691);
} else {
if((state_val_55694 === (4))){
var inst_55663 = (state_55693[(2)]);
var state_55693__$1 = state_55693;
var statearr_55698_55714 = state_55693__$1;
(statearr_55698_55714[(2)] = inst_55663);

(statearr_55698_55714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55694 === (5))){
var _ = (function (){var statearr_55699 = state_55693;
(statearr_55699[(4)] = cljs.core.rest.call(null,(state_55693[(4)])));

return statearr_55699;
})();
var state_55693__$1 = state_55693;
var ex55697 = (state_55693__$1[(2)]);
var statearr_55700_55715 = state_55693__$1;
(statearr_55700_55715[(5)] = ex55697);


if((ex55697 instanceof Error)){
var statearr_55701_55716 = state_55693__$1;
(statearr_55701_55716[(1)] = (4));

(statearr_55701_55716[(5)] = null);

} else {
throw ex55697;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55694 === (6))){
var inst_55671 = (state_55693[(2)]);
var inst_55672 = fluree.db.util.async.throw_err.call(null,inst_55671);
var inst_55673 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_55672);
var inst_55674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55675 = [inst_55672];
var inst_55676 = (new cljs.core.PersistentVector(null,1,(5),inst_55674,inst_55675,null));
var inst_55677 = cljs.core.count.call(null,inst_55676);
var inst_55678 = ((9) + inst_55677);
var inst_55679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55680 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55682 = [inst_55672];
var inst_55683 = (new cljs.core.PersistentVector(null,1,(5),inst_55681,inst_55682,null));
var inst_55684 = ["*",inst_55683,inst_55673];
var inst_55685 = cljs.core.PersistentHashMap.fromArrays(inst_55680,inst_55684);
var inst_55686 = [inst_55685,inst_55678];
var inst_55687 = (new cljs.core.PersistentVector(null,2,(5),inst_55679,inst_55686,null));
var inst_55688 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55687);
var _ = (function (){var statearr_55702 = state_55693;
(statearr_55702[(4)] = cljs.core.rest.call(null,(state_55693[(4)])));

return statearr_55702;
})();
var state_55693__$1 = (function (){var statearr_55703 = state_55693;
(statearr_55703[(7)] = inst_55688);

return statearr_55703;
})();
var statearr_55704_55717 = state_55693__$1;
(statearr_55704_55717[(2)] = inst_55673);

(statearr_55704_55717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55705 = [null,null,null,null,null,null,null,null];
(statearr_55705[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55705[(1)] = (1));

return statearr_55705;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55693){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55693);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55706){var ex__2749__auto__ = e55706;
var statearr_55707_55718 = state_55693;
(statearr_55707_55718[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55693[(4)]))){
var statearr_55708_55719 = state_55693;
(statearr_55708_55719[(1)] = cljs.core.first.call(null,(state_55693[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55720 = state_55693;
state_55693 = G__55720;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55693){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55709 = f__2769__auto__.call(null);
(statearr_55709[(6)] = c__2768__auto__);

return statearr_55709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq55661){
var G__55662 = cljs.core.first.call(null,seq55661);
var seq55661__$1 = cljs.core.next.call(null,seq55661);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55662,seq55661__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55770 = arguments.length;
var i__4865__auto___55771 = (0);
while(true){
if((i__4865__auto___55771 < len__4864__auto___55770)){
args__4870__auto__.push((arguments[i__4865__auto___55771]));

var G__55772 = (i__4865__auto___55771 + (1));
i__4865__auto___55771 = G__55772;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55753){
var state_val_55754 = (state_55753[(1)]);
if((state_val_55754 === (1))){
var state_55753__$1 = state_55753;
var statearr_55755_55773 = state_55753__$1;
(statearr_55755_55773[(2)] = null);

(statearr_55755_55773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55754 === (2))){
var _ = (function (){var statearr_55756 = state_55753;
(statearr_55756[(4)] = cljs.core.cons.call(null,(5),(state_55753[(4)])));

return statearr_55756;
})();
var inst_55729 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55753__$1 = state_55753;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55753__$1,(6),inst_55729);
} else {
if((state_val_55754 === (3))){
var inst_55751 = (state_55753[(2)]);
var state_55753__$1 = state_55753;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55753__$1,inst_55751);
} else {
if((state_val_55754 === (4))){
var inst_55723 = (state_55753[(2)]);
var state_55753__$1 = state_55753;
var statearr_55758_55774 = state_55753__$1;
(statearr_55758_55774[(2)] = inst_55723);

(statearr_55758_55774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55754 === (5))){
var _ = (function (){var statearr_55759 = state_55753;
(statearr_55759[(4)] = cljs.core.rest.call(null,(state_55753[(4)])));

return statearr_55759;
})();
var state_55753__$1 = state_55753;
var ex55757 = (state_55753__$1[(2)]);
var statearr_55760_55775 = state_55753__$1;
(statearr_55760_55775[(5)] = ex55757);


if((ex55757 instanceof Error)){
var statearr_55761_55776 = state_55753__$1;
(statearr_55761_55776[(1)] = (4));

(statearr_55761_55776[(5)] = null);

} else {
throw ex55757;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55754 === (6))){
var inst_55731 = (state_55753[(2)]);
var inst_55732 = fluree.db.util.async.throw_err.call(null,inst_55731);
var inst_55733 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_55732);
var inst_55734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55735 = [inst_55732];
var inst_55736 = (new cljs.core.PersistentVector(null,1,(5),inst_55734,inst_55735,null));
var inst_55737 = cljs.core.count.call(null,inst_55736);
var inst_55738 = ((9) + inst_55737);
var inst_55739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55740 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55741 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55742 = [inst_55732];
var inst_55743 = (new cljs.core.PersistentVector(null,1,(5),inst_55741,inst_55742,null));
var inst_55744 = ["/",inst_55743,inst_55733];
var inst_55745 = cljs.core.PersistentHashMap.fromArrays(inst_55740,inst_55744);
var inst_55746 = [inst_55745,inst_55738];
var inst_55747 = (new cljs.core.PersistentVector(null,2,(5),inst_55739,inst_55746,null));
var inst_55748 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55747);
var _ = (function (){var statearr_55762 = state_55753;
(statearr_55762[(4)] = cljs.core.rest.call(null,(state_55753[(4)])));

return statearr_55762;
})();
var state_55753__$1 = (function (){var statearr_55763 = state_55753;
(statearr_55763[(7)] = inst_55748);

return statearr_55763;
})();
var statearr_55764_55777 = state_55753__$1;
(statearr_55764_55777[(2)] = inst_55733);

(statearr_55764_55777[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55765 = [null,null,null,null,null,null,null,null];
(statearr_55765[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55765[(1)] = (1));

return statearr_55765;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55753){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55753);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55766){var ex__2749__auto__ = e55766;
var statearr_55767_55778 = state_55753;
(statearr_55767_55778[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55753[(4)]))){
var statearr_55768_55779 = state_55753;
(statearr_55768_55779[(1)] = cljs.core.first.call(null,(state_55753[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55780 = state_55753;
state_55753 = G__55780;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55753){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55769 = f__2769__auto__.call(null);
(statearr_55769[(6)] = c__2768__auto__);

return statearr_55769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq55721){
var G__55722 = cljs.core.first.call(null,seq55721);
var seq55721__$1 = cljs.core.next.call(null,seq55721);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55722,seq55721__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55818){
var state_val_55819 = (state_55818[(1)]);
if((state_val_55819 === (7))){
var state_55818__$1 = state_55818;
var statearr_55820_55844 = state_55818__$1;
(statearr_55820_55844[(2)] = n);

(statearr_55820_55844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55819 === (1))){
var state_55818__$1 = state_55818;
var statearr_55821_55845 = state_55818__$1;
(statearr_55821_55845[(2)] = null);

(statearr_55821_55845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55819 === (4))){
var inst_55781 = (state_55818[(2)]);
var state_55818__$1 = state_55818;
var statearr_55822_55846 = state_55818__$1;
(statearr_55822_55846[(2)] = inst_55781);

(statearr_55822_55846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55819 === (13))){
var inst_55798 = (state_55818[(2)]);
var inst_55799 = fluree.db.util.async.throw_err.call(null,inst_55798);
var state_55818__$1 = state_55818;
var statearr_55823_55847 = state_55818__$1;
(statearr_55823_55847[(2)] = inst_55799);

(statearr_55823_55847[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55819 === (6))){
var state_55818__$1 = state_55818;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55818__$1,(9),n);
} else {
if((state_val_55819 === (3))){
var inst_55816 = (state_55818[(2)]);
var state_55818__$1 = state_55818;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55818__$1,inst_55816);
} else {
if((state_val_55819 === (12))){
var inst_55794 = (state_55818[(7)]);
var inst_55802 = (state_55818[(2)]);
var inst_55803 = fluree.db.dbfunctions.internal.quot.call(null,inst_55794,inst_55802);
var inst_55804 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55805 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55807 = [inst_55794,inst_55802];
var inst_55808 = (new cljs.core.PersistentVector(null,2,(5),inst_55806,inst_55807,null));
var inst_55809 = ["quot",inst_55808,inst_55803];
var inst_55810 = cljs.core.PersistentHashMap.fromArrays(inst_55805,inst_55809);
var inst_55811 = [inst_55810,(2)];
var inst_55812 = (new cljs.core.PersistentVector(null,2,(5),inst_55804,inst_55811,null));
var inst_55813 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55812);
var _ = (function (){var statearr_55824 = state_55818;
(statearr_55824[(4)] = cljs.core.rest.call(null,(state_55818[(4)])));

return statearr_55824;
})();
var state_55818__$1 = (function (){var statearr_55825 = state_55818;
(statearr_55825[(8)] = inst_55813);

return statearr_55825;
})();
var statearr_55826_55848 = state_55818__$1;
(statearr_55826_55848[(2)] = inst_55803);

(statearr_55826_55848[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55819 === (2))){
var _ = (function (){var statearr_55827 = state_55818;
(statearr_55827[(4)] = cljs.core.cons.call(null,(5),(state_55818[(4)])));

return statearr_55827;
})();
var inst_55787 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55818__$1 = state_55818;
if(inst_55787){
var statearr_55828_55849 = state_55818__$1;
(statearr_55828_55849[(1)] = (6));

} else {
var statearr_55829_55850 = state_55818__$1;
(statearr_55829_55850[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55819 === (11))){
var state_55818__$1 = state_55818;
var statearr_55831_55851 = state_55818__$1;
(statearr_55831_55851[(2)] = d);

(statearr_55831_55851[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55819 === (9))){
var inst_55790 = (state_55818[(2)]);
var inst_55791 = fluree.db.util.async.throw_err.call(null,inst_55790);
var state_55818__$1 = state_55818;
var statearr_55832_55852 = state_55818__$1;
(statearr_55832_55852[(2)] = inst_55791);

(statearr_55832_55852[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55819 === (5))){
var _ = (function (){var statearr_55833 = state_55818;
(statearr_55833[(4)] = cljs.core.rest.call(null,(state_55818[(4)])));

return statearr_55833;
})();
var state_55818__$1 = state_55818;
var ex55830 = (state_55818__$1[(2)]);
var statearr_55834_55853 = state_55818__$1;
(statearr_55834_55853[(5)] = ex55830);


if((ex55830 instanceof Error)){
var statearr_55835_55854 = state_55818__$1;
(statearr_55835_55854[(1)] = (4));

(statearr_55835_55854[(5)] = null);

} else {
throw ex55830;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55819 === (10))){
var state_55818__$1 = state_55818;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55818__$1,(13),d);
} else {
if((state_val_55819 === (8))){
var inst_55794 = (state_55818[(2)]);
var inst_55795 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_55818__$1 = (function (){var statearr_55836 = state_55818;
(statearr_55836[(7)] = inst_55794);

return statearr_55836;
})();
if(inst_55795){
var statearr_55837_55855 = state_55818__$1;
(statearr_55837_55855[(1)] = (10));

} else {
var statearr_55838_55856 = state_55818__$1;
(statearr_55838_55856[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0 = (function (){
var statearr_55839 = [null,null,null,null,null,null,null,null,null];
(statearr_55839[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__);

(statearr_55839[(1)] = (1));

return statearr_55839;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1 = (function (state_55818){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55818);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55840){var ex__2749__auto__ = e55840;
var statearr_55841_55857 = state_55818;
(statearr_55841_55857[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55818[(4)]))){
var statearr_55842_55858 = state_55818;
(statearr_55842_55858[(1)] = cljs.core.first.call(null,(state_55818[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55859 = state_55818;
state_55818 = G__55859;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__ = function(state_55818){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1.call(this,state_55818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55843 = f__2769__auto__.call(null);
(statearr_55843[(6)] = c__2768__auto__);

return statearr_55843;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55897){
var state_val_55898 = (state_55897[(1)]);
if((state_val_55898 === (7))){
var state_55897__$1 = state_55897;
var statearr_55899_55923 = state_55897__$1;
(statearr_55899_55923[(2)] = n);

(statearr_55899_55923[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55898 === (1))){
var state_55897__$1 = state_55897;
var statearr_55900_55924 = state_55897__$1;
(statearr_55900_55924[(2)] = null);

(statearr_55900_55924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55898 === (4))){
var inst_55860 = (state_55897[(2)]);
var state_55897__$1 = state_55897;
var statearr_55901_55925 = state_55897__$1;
(statearr_55901_55925[(2)] = inst_55860);

(statearr_55901_55925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55898 === (13))){
var inst_55877 = (state_55897[(2)]);
var inst_55878 = fluree.db.util.async.throw_err.call(null,inst_55877);
var state_55897__$1 = state_55897;
var statearr_55902_55926 = state_55897__$1;
(statearr_55902_55926[(2)] = inst_55878);

(statearr_55902_55926[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55898 === (6))){
var state_55897__$1 = state_55897;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55897__$1,(9),n);
} else {
if((state_val_55898 === (3))){
var inst_55895 = (state_55897[(2)]);
var state_55897__$1 = state_55897;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55897__$1,inst_55895);
} else {
if((state_val_55898 === (12))){
var inst_55873 = (state_55897[(7)]);
var inst_55881 = (state_55897[(2)]);
var inst_55882 = fluree.db.dbfunctions.internal.mod.call(null,inst_55873,inst_55881);
var inst_55883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55884 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55886 = [inst_55873,inst_55881];
var inst_55887 = (new cljs.core.PersistentVector(null,2,(5),inst_55885,inst_55886,null));
var inst_55888 = ["mod",inst_55887,inst_55882];
var inst_55889 = cljs.core.PersistentHashMap.fromArrays(inst_55884,inst_55888);
var inst_55890 = [inst_55889,(2)];
var inst_55891 = (new cljs.core.PersistentVector(null,2,(5),inst_55883,inst_55890,null));
var inst_55892 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55891);
var _ = (function (){var statearr_55903 = state_55897;
(statearr_55903[(4)] = cljs.core.rest.call(null,(state_55897[(4)])));

return statearr_55903;
})();
var state_55897__$1 = (function (){var statearr_55904 = state_55897;
(statearr_55904[(8)] = inst_55892);

return statearr_55904;
})();
var statearr_55905_55927 = state_55897__$1;
(statearr_55905_55927[(2)] = inst_55882);

(statearr_55905_55927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55898 === (2))){
var _ = (function (){var statearr_55906 = state_55897;
(statearr_55906[(4)] = cljs.core.cons.call(null,(5),(state_55897[(4)])));

return statearr_55906;
})();
var inst_55866 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55897__$1 = state_55897;
if(inst_55866){
var statearr_55907_55928 = state_55897__$1;
(statearr_55907_55928[(1)] = (6));

} else {
var statearr_55908_55929 = state_55897__$1;
(statearr_55908_55929[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55898 === (11))){
var state_55897__$1 = state_55897;
var statearr_55910_55930 = state_55897__$1;
(statearr_55910_55930[(2)] = d);

(statearr_55910_55930[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55898 === (9))){
var inst_55869 = (state_55897[(2)]);
var inst_55870 = fluree.db.util.async.throw_err.call(null,inst_55869);
var state_55897__$1 = state_55897;
var statearr_55911_55931 = state_55897__$1;
(statearr_55911_55931[(2)] = inst_55870);

(statearr_55911_55931[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55898 === (5))){
var _ = (function (){var statearr_55912 = state_55897;
(statearr_55912[(4)] = cljs.core.rest.call(null,(state_55897[(4)])));

return statearr_55912;
})();
var state_55897__$1 = state_55897;
var ex55909 = (state_55897__$1[(2)]);
var statearr_55913_55932 = state_55897__$1;
(statearr_55913_55932[(5)] = ex55909);


if((ex55909 instanceof Error)){
var statearr_55914_55933 = state_55897__$1;
(statearr_55914_55933[(1)] = (4));

(statearr_55914_55933[(5)] = null);

} else {
throw ex55909;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55898 === (10))){
var state_55897__$1 = state_55897;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55897__$1,(13),d);
} else {
if((state_val_55898 === (8))){
var inst_55873 = (state_55897[(2)]);
var inst_55874 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_55897__$1 = (function (){var statearr_55915 = state_55897;
(statearr_55915[(7)] = inst_55873);

return statearr_55915;
})();
if(inst_55874){
var statearr_55916_55934 = state_55897__$1;
(statearr_55916_55934[(1)] = (10));

} else {
var statearr_55917_55935 = state_55897__$1;
(statearr_55917_55935[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0 = (function (){
var statearr_55918 = [null,null,null,null,null,null,null,null,null];
(statearr_55918[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__);

(statearr_55918[(1)] = (1));

return statearr_55918;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1 = (function (state_55897){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55897);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55919){var ex__2749__auto__ = e55919;
var statearr_55920_55936 = state_55897;
(statearr_55920_55936[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55897[(4)]))){
var statearr_55921_55937 = state_55897;
(statearr_55921_55937[(1)] = cljs.core.first.call(null,(state_55897[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55938 = state_55897;
state_55897 = G__55938;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__ = function(state_55897){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1.call(this,state_55897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55922 = f__2769__auto__.call(null);
(statearr_55922[(6)] = c__2768__auto__);

return statearr_55922;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55976){
var state_val_55977 = (state_55976[(1)]);
if((state_val_55977 === (7))){
var state_55976__$1 = state_55976;
var statearr_55978_56002 = state_55976__$1;
(statearr_55978_56002[(2)] = n);

(statearr_55978_56002[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (1))){
var state_55976__$1 = state_55976;
var statearr_55979_56003 = state_55976__$1;
(statearr_55979_56003[(2)] = null);

(statearr_55979_56003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (4))){
var inst_55939 = (state_55976[(2)]);
var state_55976__$1 = state_55976;
var statearr_55980_56004 = state_55976__$1;
(statearr_55980_56004[(2)] = inst_55939);

(statearr_55980_56004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (13))){
var inst_55956 = (state_55976[(2)]);
var inst_55957 = fluree.db.util.async.throw_err.call(null,inst_55956);
var state_55976__$1 = state_55976;
var statearr_55981_56005 = state_55976__$1;
(statearr_55981_56005[(2)] = inst_55957);

(statearr_55981_56005[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (6))){
var state_55976__$1 = state_55976;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55976__$1,(9),n);
} else {
if((state_val_55977 === (3))){
var inst_55974 = (state_55976[(2)]);
var state_55976__$1 = state_55976;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55976__$1,inst_55974);
} else {
if((state_val_55977 === (12))){
var inst_55952 = (state_55976[(7)]);
var inst_55960 = (state_55976[(2)]);
var inst_55961 = fluree.db.dbfunctions.internal.rem.call(null,inst_55952,inst_55960);
var inst_55962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55963 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55965 = [inst_55952,inst_55960];
var inst_55966 = (new cljs.core.PersistentVector(null,2,(5),inst_55964,inst_55965,null));
var inst_55967 = ["rem",inst_55966,inst_55961];
var inst_55968 = cljs.core.PersistentHashMap.fromArrays(inst_55963,inst_55967);
var inst_55969 = [inst_55968,(2)];
var inst_55970 = (new cljs.core.PersistentVector(null,2,(5),inst_55962,inst_55969,null));
var inst_55971 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55970);
var _ = (function (){var statearr_55982 = state_55976;
(statearr_55982[(4)] = cljs.core.rest.call(null,(state_55976[(4)])));

return statearr_55982;
})();
var state_55976__$1 = (function (){var statearr_55983 = state_55976;
(statearr_55983[(8)] = inst_55971);

return statearr_55983;
})();
var statearr_55984_56006 = state_55976__$1;
(statearr_55984_56006[(2)] = inst_55961);

(statearr_55984_56006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (2))){
var _ = (function (){var statearr_55985 = state_55976;
(statearr_55985[(4)] = cljs.core.cons.call(null,(5),(state_55976[(4)])));

return statearr_55985;
})();
var inst_55945 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55976__$1 = state_55976;
if(inst_55945){
var statearr_55986_56007 = state_55976__$1;
(statearr_55986_56007[(1)] = (6));

} else {
var statearr_55987_56008 = state_55976__$1;
(statearr_55987_56008[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (11))){
var state_55976__$1 = state_55976;
var statearr_55989_56009 = state_55976__$1;
(statearr_55989_56009[(2)] = d);

(statearr_55989_56009[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (9))){
var inst_55948 = (state_55976[(2)]);
var inst_55949 = fluree.db.util.async.throw_err.call(null,inst_55948);
var state_55976__$1 = state_55976;
var statearr_55990_56010 = state_55976__$1;
(statearr_55990_56010[(2)] = inst_55949);

(statearr_55990_56010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (5))){
var _ = (function (){var statearr_55991 = state_55976;
(statearr_55991[(4)] = cljs.core.rest.call(null,(state_55976[(4)])));

return statearr_55991;
})();
var state_55976__$1 = state_55976;
var ex55988 = (state_55976__$1[(2)]);
var statearr_55992_56011 = state_55976__$1;
(statearr_55992_56011[(5)] = ex55988);


if((ex55988 instanceof Error)){
var statearr_55993_56012 = state_55976__$1;
(statearr_55993_56012[(1)] = (4));

(statearr_55993_56012[(5)] = null);

} else {
throw ex55988;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (10))){
var state_55976__$1 = state_55976;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55976__$1,(13),d);
} else {
if((state_val_55977 === (8))){
var inst_55952 = (state_55976[(2)]);
var inst_55953 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_55976__$1 = (function (){var statearr_55994 = state_55976;
(statearr_55994[(7)] = inst_55952);

return statearr_55994;
})();
if(inst_55953){
var statearr_55995_56013 = state_55976__$1;
(statearr_55995_56013[(1)] = (10));

} else {
var statearr_55996_56014 = state_55976__$1;
(statearr_55996_56014[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0 = (function (){
var statearr_55997 = [null,null,null,null,null,null,null,null,null];
(statearr_55997[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__);

(statearr_55997[(1)] = (1));

return statearr_55997;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1 = (function (state_55976){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55976);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55998){var ex__2749__auto__ = e55998;
var statearr_55999_56015 = state_55976;
(statearr_55999_56015[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55976[(4)]))){
var statearr_56000_56016 = state_55976;
(statearr_56000_56016[(1)] = cljs.core.first.call(null,(state_55976[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56017 = state_55976;
state_55976 = G__56017;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__ = function(state_55976){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1.call(this,state_55976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56001 = f__2769__auto__.call(null);
(statearr_56001[(6)] = c__2768__auto__);

return statearr_56001;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56044){
var state_val_56045 = (state_56044[(1)]);
if((state_val_56045 === (7))){
var state_56044__$1 = state_56044;
var statearr_56046_56065 = state_56044__$1;
(statearr_56046_56065[(2)] = x);

(statearr_56046_56065[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56045 === (1))){
var state_56044__$1 = state_56044;
var statearr_56047_56066 = state_56044__$1;
(statearr_56047_56066[(2)] = null);

(statearr_56047_56066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56045 === (4))){
var inst_56018 = (state_56044[(2)]);
var state_56044__$1 = state_56044;
var statearr_56048_56067 = state_56044__$1;
(statearr_56048_56067[(2)] = inst_56018);

(statearr_56048_56067[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56045 === (6))){
var state_56044__$1 = state_56044;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56044__$1,(9),x);
} else {
if((state_val_56045 === (3))){
var inst_56042 = (state_56044[(2)]);
var state_56044__$1 = state_56044;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56044__$1,inst_56042);
} else {
if((state_val_56045 === (2))){
var _ = (function (){var statearr_56050 = state_56044;
(statearr_56050[(4)] = cljs.core.cons.call(null,(5),(state_56044[(4)])));

return statearr_56050;
})();
var inst_56024 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_56044__$1 = state_56044;
if(inst_56024){
var statearr_56051_56068 = state_56044__$1;
(statearr_56051_56068[(1)] = (6));

} else {
var statearr_56052_56069 = state_56044__$1;
(statearr_56052_56069[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56045 === (9))){
var inst_56027 = (state_56044[(2)]);
var inst_56028 = fluree.db.util.async.throw_err.call(null,inst_56027);
var state_56044__$1 = state_56044;
var statearr_56053_56070 = state_56044__$1;
(statearr_56053_56070[(2)] = inst_56028);

(statearr_56053_56070[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56045 === (5))){
var _ = (function (){var statearr_56054 = state_56044;
(statearr_56054[(4)] = cljs.core.rest.call(null,(state_56044[(4)])));

return statearr_56054;
})();
var state_56044__$1 = state_56044;
var ex56049 = (state_56044__$1[(2)]);
var statearr_56055_56071 = state_56044__$1;
(statearr_56055_56071[(5)] = ex56049);


if((ex56049 instanceof Error)){
var statearr_56056_56072 = state_56044__$1;
(statearr_56056_56072[(1)] = (4));

(statearr_56056_56072[(5)] = null);

} else {
throw ex56049;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56045 === (8))){
var inst_56031 = (state_56044[(2)]);
var inst_56032 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_56031);
var inst_56033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56034 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56035 = ["boolean",inst_56031,inst_56032];
var inst_56036 = cljs.core.PersistentHashMap.fromArrays(inst_56034,inst_56035);
var inst_56037 = [inst_56036,(10)];
var inst_56038 = (new cljs.core.PersistentVector(null,2,(5),inst_56033,inst_56037,null));
var inst_56039 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56038);
var _ = (function (){var statearr_56057 = state_56044;
(statearr_56057[(4)] = cljs.core.rest.call(null,(state_56044[(4)])));

return statearr_56057;
})();
var state_56044__$1 = (function (){var statearr_56058 = state_56044;
(statearr_56058[(7)] = inst_56039);

return statearr_56058;
})();
var statearr_56059_56073 = state_56044__$1;
(statearr_56059_56073[(2)] = inst_56032);

(statearr_56059_56073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0 = (function (){
var statearr_56060 = [null,null,null,null,null,null,null,null];
(statearr_56060[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__);

(statearr_56060[(1)] = (1));

return statearr_56060;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1 = (function (state_56044){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56044);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56061){var ex__2749__auto__ = e56061;
var statearr_56062_56074 = state_56044;
(statearr_56062_56074[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56044[(4)]))){
var statearr_56063_56075 = state_56044;
(statearr_56063_56075[(1)] = cljs.core.first.call(null,(state_56044[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56076 = state_56044;
state_56044 = G__56076;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__ = function(state_56044){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1.call(this,state_56044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56064 = f__2769__auto__.call(null);
(statearr_56064[(6)] = c__2768__auto__);

return statearr_56064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56114){
var state_val_56115 = (state_56114[(1)]);
if((state_val_56115 === (7))){
var state_56114__$1 = state_56114;
var statearr_56116_56140 = state_56114__$1;
(statearr_56116_56140[(2)] = pattern);

(statearr_56116_56140[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56115 === (1))){
var state_56114__$1 = state_56114;
var statearr_56117_56141 = state_56114__$1;
(statearr_56117_56141[(2)] = null);

(statearr_56117_56141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56115 === (4))){
var inst_56077 = (state_56114[(2)]);
var state_56114__$1 = state_56114;
var statearr_56118_56142 = state_56114__$1;
(statearr_56118_56142[(2)] = inst_56077);

(statearr_56118_56142[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56115 === (13))){
var inst_56094 = (state_56114[(2)]);
var inst_56095 = fluree.db.util.async.throw_err.call(null,inst_56094);
var state_56114__$1 = state_56114;
var statearr_56119_56143 = state_56114__$1;
(statearr_56119_56143[(2)] = inst_56095);

(statearr_56119_56143[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56115 === (6))){
var state_56114__$1 = state_56114;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56114__$1,(9),pattern);
} else {
if((state_val_56115 === (3))){
var inst_56112 = (state_56114[(2)]);
var state_56114__$1 = state_56114;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56114__$1,inst_56112);
} else {
if((state_val_56115 === (12))){
var inst_56090 = (state_56114[(7)]);
var inst_56098 = (state_56114[(2)]);
var inst_56099 = fluree.db.dbfunctions.internal.re_find.call(null,inst_56090,inst_56098);
var inst_56100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56101 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56103 = [inst_56090,inst_56098];
var inst_56104 = (new cljs.core.PersistentVector(null,2,(5),inst_56102,inst_56103,null));
var inst_56105 = ["re-find",inst_56104,inst_56099];
var inst_56106 = cljs.core.PersistentHashMap.fromArrays(inst_56101,inst_56105);
var inst_56107 = [inst_56106,(10)];
var inst_56108 = (new cljs.core.PersistentVector(null,2,(5),inst_56100,inst_56107,null));
var inst_56109 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56108);
var _ = (function (){var statearr_56120 = state_56114;
(statearr_56120[(4)] = cljs.core.rest.call(null,(state_56114[(4)])));

return statearr_56120;
})();
var state_56114__$1 = (function (){var statearr_56121 = state_56114;
(statearr_56121[(8)] = inst_56109);

return statearr_56121;
})();
var statearr_56122_56144 = state_56114__$1;
(statearr_56122_56144[(2)] = inst_56099);

(statearr_56122_56144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56115 === (2))){
var _ = (function (){var statearr_56123 = state_56114;
(statearr_56123[(4)] = cljs.core.cons.call(null,(5),(state_56114[(4)])));

return statearr_56123;
})();
var inst_56083 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_56114__$1 = state_56114;
if(inst_56083){
var statearr_56124_56145 = state_56114__$1;
(statearr_56124_56145[(1)] = (6));

} else {
var statearr_56125_56146 = state_56114__$1;
(statearr_56125_56146[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56115 === (11))){
var state_56114__$1 = state_56114;
var statearr_56127_56147 = state_56114__$1;
(statearr_56127_56147[(2)] = string);

(statearr_56127_56147[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56115 === (9))){
var inst_56086 = (state_56114[(2)]);
var inst_56087 = fluree.db.util.async.throw_err.call(null,inst_56086);
var state_56114__$1 = state_56114;
var statearr_56128_56148 = state_56114__$1;
(statearr_56128_56148[(2)] = inst_56087);

(statearr_56128_56148[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56115 === (5))){
var _ = (function (){var statearr_56129 = state_56114;
(statearr_56129[(4)] = cljs.core.rest.call(null,(state_56114[(4)])));

return statearr_56129;
})();
var state_56114__$1 = state_56114;
var ex56126 = (state_56114__$1[(2)]);
var statearr_56130_56149 = state_56114__$1;
(statearr_56130_56149[(5)] = ex56126);


if((ex56126 instanceof Error)){
var statearr_56131_56150 = state_56114__$1;
(statearr_56131_56150[(1)] = (4));

(statearr_56131_56150[(5)] = null);

} else {
throw ex56126;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56115 === (10))){
var state_56114__$1 = state_56114;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56114__$1,(13),string);
} else {
if((state_val_56115 === (8))){
var inst_56090 = (state_56114[(2)]);
var inst_56091 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_56114__$1 = (function (){var statearr_56132 = state_56114;
(statearr_56132[(7)] = inst_56090);

return statearr_56132;
})();
if(inst_56091){
var statearr_56133_56151 = state_56114__$1;
(statearr_56133_56151[(1)] = (10));

} else {
var statearr_56134_56152 = state_56114__$1;
(statearr_56134_56152[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0 = (function (){
var statearr_56135 = [null,null,null,null,null,null,null,null,null];
(statearr_56135[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__);

(statearr_56135[(1)] = (1));

return statearr_56135;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1 = (function (state_56114){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56114);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56136){var ex__2749__auto__ = e56136;
var statearr_56137_56153 = state_56114;
(statearr_56137_56153[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56114[(4)]))){
var statearr_56138_56154 = state_56114;
(statearr_56138_56154[(1)] = cljs.core.first.call(null,(state_56114[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56155 = state_56114;
state_56114 = G__56155;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__ = function(state_56114){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1.call(this,state_56114);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56139 = f__2769__auto__.call(null);
(statearr_56139[(6)] = c__2768__auto__);

return statearr_56139;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56182){
var state_val_56183 = (state_56182[(1)]);
if((state_val_56183 === (7))){
var state_56182__$1 = state_56182;
var statearr_56184_56203 = state_56182__$1;
(statearr_56184_56203[(2)] = email);

(statearr_56184_56203[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56183 === (1))){
var state_56182__$1 = state_56182;
var statearr_56185_56204 = state_56182__$1;
(statearr_56185_56204[(2)] = null);

(statearr_56185_56204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56183 === (4))){
var inst_56156 = (state_56182[(2)]);
var state_56182__$1 = state_56182;
var statearr_56186_56205 = state_56182__$1;
(statearr_56186_56205[(2)] = inst_56156);

(statearr_56186_56205[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56183 === (6))){
var state_56182__$1 = state_56182;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56182__$1,(9),email);
} else {
if((state_val_56183 === (3))){
var inst_56180 = (state_56182[(2)]);
var state_56182__$1 = state_56182;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56182__$1,inst_56180);
} else {
if((state_val_56183 === (2))){
var _ = (function (){var statearr_56188 = state_56182;
(statearr_56188[(4)] = cljs.core.cons.call(null,(5),(state_56182[(4)])));

return statearr_56188;
})();
var inst_56162 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_56182__$1 = state_56182;
if(inst_56162){
var statearr_56189_56206 = state_56182__$1;
(statearr_56189_56206[(1)] = (6));

} else {
var statearr_56190_56207 = state_56182__$1;
(statearr_56190_56207[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56183 === (9))){
var inst_56165 = (state_56182[(2)]);
var inst_56166 = fluree.db.util.async.throw_err.call(null,inst_56165);
var state_56182__$1 = state_56182;
var statearr_56191_56208 = state_56182__$1;
(statearr_56191_56208[(2)] = inst_56166);

(statearr_56191_56208[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56183 === (5))){
var _ = (function (){var statearr_56192 = state_56182;
(statearr_56192[(4)] = cljs.core.rest.call(null,(state_56182[(4)])));

return statearr_56192;
})();
var state_56182__$1 = state_56182;
var ex56187 = (state_56182__$1[(2)]);
var statearr_56193_56209 = state_56182__$1;
(statearr_56193_56209[(5)] = ex56187);


if((ex56187 instanceof Error)){
var statearr_56194_56210 = state_56182__$1;
(statearr_56194_56210[(1)] = (4));

(statearr_56194_56210[(5)] = null);

} else {
throw ex56187;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56183 === (8))){
var inst_56169 = (state_56182[(2)]);
var inst_56170 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_56169);
var inst_56171 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56172 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56173 = ["re-find",inst_56169,inst_56170];
var inst_56174 = cljs.core.PersistentHashMap.fromArrays(inst_56172,inst_56173);
var inst_56175 = [inst_56174,(10)];
var inst_56176 = (new cljs.core.PersistentVector(null,2,(5),inst_56171,inst_56175,null));
var inst_56177 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56176);
var _ = (function (){var statearr_56195 = state_56182;
(statearr_56195[(4)] = cljs.core.rest.call(null,(state_56182[(4)])));

return statearr_56195;
})();
var state_56182__$1 = (function (){var statearr_56196 = state_56182;
(statearr_56196[(7)] = inst_56177);

return statearr_56196;
})();
var statearr_56197_56211 = state_56182__$1;
(statearr_56197_56211[(2)] = inst_56170);

(statearr_56197_56211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_56198 = [null,null,null,null,null,null,null,null];
(statearr_56198[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__);

(statearr_56198[(1)] = (1));

return statearr_56198;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1 = (function (state_56182){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56182);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56199){var ex__2749__auto__ = e56199;
var statearr_56200_56212 = state_56182;
(statearr_56200_56212[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56182[(4)]))){
var statearr_56201_56213 = state_56182;
(statearr_56201_56213[(1)] = cljs.core.first.call(null,(state_56182[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56214 = state_56182;
state_56182 = G__56214;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__ = function(state_56182){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1.call(this,state_56182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56202 = f__2769__auto__.call(null);
(statearr_56202[(6)] = c__2768__auto__);

return statearr_56202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56261){
var state_val_56262 = (state_56261[(1)]);
if((state_val_56262 === (7))){
var inst_56231 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56261__$1 = state_56261;
if(cljs.core.truth_(inst_56231)){
var statearr_56263_56290 = state_56261__$1;
(statearr_56263_56290[(1)] = (9));

} else {
var statearr_56264_56291 = state_56261__$1;
(statearr_56264_56291[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56262 === (1))){
var state_56261__$1 = state_56261;
var statearr_56265_56292 = state_56261__$1;
(statearr_56265_56292[(2)] = null);

(statearr_56265_56292[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56262 === (4))){
var inst_56215 = (state_56261[(2)]);
var state_56261__$1 = state_56261;
var statearr_56266_56293 = state_56261__$1;
(statearr_56266_56293[(2)] = inst_56215);

(statearr_56266_56293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56262 === (15))){
var inst_56242 = (state_56261[(2)]);
var state_56261__$1 = state_56261;
var statearr_56267_56294 = state_56261__$1;
(statearr_56267_56294[(2)] = inst_56242);

(statearr_56267_56294[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56262 === (13))){
var inst_56239 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_56261__$1 = state_56261;
var statearr_56268_56295 = state_56261__$1;
(statearr_56268_56295[(2)] = inst_56239);

(statearr_56268_56295[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56262 === (6))){
var inst_56226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56227 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56228 = [inst_56227,(0)];
var inst_56229 = (new cljs.core.PersistentVector(null,2,(5),inst_56226,inst_56228,null));
var state_56261__$1 = state_56261;
var statearr_56269_56296 = state_56261__$1;
(statearr_56269_56296[(2)] = inst_56229);

(statearr_56269_56296[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56262 === (3))){
var inst_56259 = (state_56261[(2)]);
var state_56261__$1 = state_56261;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56261__$1,inst_56259);
} else {
if((state_val_56262 === (12))){
var inst_56235 = (state_56261[(2)]);
var inst_56236 = fluree.db.util.async.throw_err.call(null,inst_56235);
var state_56261__$1 = state_56261;
var statearr_56270_56297 = state_56261__$1;
(statearr_56270_56297[(2)] = inst_56236);

(statearr_56270_56297[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56262 === (2))){
var _ = (function (){var statearr_56271 = state_56261;
(statearr_56271[(4)] = cljs.core.cons.call(null,(5),(state_56261[(4)])));

return statearr_56271;
})();
var inst_56224 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56261__$1 = state_56261;
if(cljs.core.truth_(inst_56224)){
var statearr_56272_56298 = state_56261__$1;
(statearr_56272_56298[(1)] = (6));

} else {
var statearr_56273_56299 = state_56261__$1;
(statearr_56273_56299[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56262 === (11))){
var inst_56244 = (state_56261[(2)]);
var state_56261__$1 = state_56261;
var statearr_56275_56300 = state_56261__$1;
(statearr_56275_56300[(2)] = inst_56244);

(statearr_56275_56300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56262 === (9))){
var inst_56233 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_56261__$1 = state_56261;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56261__$1,(12),inst_56233);
} else {
if((state_val_56262 === (5))){
var _ = (function (){var statearr_56276 = state_56261;
(statearr_56276[(4)] = cljs.core.rest.call(null,(state_56261[(4)])));

return statearr_56276;
})();
var state_56261__$1 = state_56261;
var ex56274 = (state_56261__$1[(2)]);
var statearr_56277_56301 = state_56261__$1;
(statearr_56277_56301[(5)] = ex56274);


if((ex56274 instanceof Error)){
var statearr_56278_56302 = state_56261__$1;
(statearr_56278_56302[(1)] = (4));

(statearr_56278_56302[(5)] = null);

} else {
throw ex56274;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56262 === (14))){
var state_56261__$1 = state_56261;
var statearr_56279_56303 = state_56261__$1;
(statearr_56279_56303[(2)] = null);

(statearr_56279_56303[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56262 === (10))){
var state_56261__$1 = state_56261;
var statearr_56280_56304 = state_56261__$1;
(statearr_56280_56304[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56262 === (8))){
var inst_56246 = (state_56261[(2)]);
var inst_56247 = cljs.core.nth.call(null,inst_56246,(0),null);
var inst_56248 = cljs.core.nth.call(null,inst_56246,(1),null);
var inst_56249 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56250 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56251 = ["?user_id","?ctx",inst_56247];
var inst_56252 = cljs.core.PersistentHashMap.fromArrays(inst_56250,inst_56251);
var inst_56253 = ((10) + inst_56248);
var inst_56254 = [inst_56252,inst_56253];
var inst_56255 = (new cljs.core.PersistentVector(null,2,(5),inst_56249,inst_56254,null));
var inst_56256 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56255);
var _ = (function (){var statearr_56282 = state_56261;
(statearr_56282[(4)] = cljs.core.rest.call(null,(state_56261[(4)])));

return statearr_56282;
})();
var state_56261__$1 = (function (){var statearr_56283 = state_56261;
(statearr_56283[(7)] = inst_56256);

return statearr_56283;
})();
var statearr_56284_56305 = state_56261__$1;
(statearr_56284_56305[(2)] = inst_56247);

(statearr_56284_56305[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0 = (function (){
var statearr_56285 = [null,null,null,null,null,null,null,null];
(statearr_56285[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__);

(statearr_56285[(1)] = (1));

return statearr_56285;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1 = (function (state_56261){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56261);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56286){var ex__2749__auto__ = e56286;
var statearr_56287_56306 = state_56261;
(statearr_56287_56306[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56261[(4)]))){
var statearr_56288_56307 = state_56261;
(statearr_56288_56307[(1)] = cljs.core.first.call(null,(state_56261[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56308 = state_56261;
state_56261 = G__56308;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__ = function(state_56261){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1.call(this,state_56261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56289 = f__2769__auto__.call(null);
(statearr_56289[(6)] = c__2768__auto__);

return statearr_56289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56336){
var state_val_56337 = (state_56336[(1)]);
if((state_val_56337 === (7))){
var inst_56329 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_56336__$1 = state_56336;
var statearr_56338_56357 = state_56336__$1;
(statearr_56338_56357[(2)] = inst_56329);

(statearr_56338_56357[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56337 === (1))){
var state_56336__$1 = state_56336;
var statearr_56339_56358 = state_56336__$1;
(statearr_56339_56358[(2)] = null);

(statearr_56339_56358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56337 === (4))){
var inst_56309 = (state_56336[(2)]);
var state_56336__$1 = state_56336;
var statearr_56340_56359 = state_56336__$1;
(statearr_56340_56359[(2)] = inst_56309);

(statearr_56340_56359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56337 === (6))){
var inst_56317 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_56336__$1 = state_56336;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56336__$1,(9),inst_56317);
} else {
if((state_val_56337 === (3))){
var inst_56334 = (state_56336[(2)]);
var state_56336__$1 = state_56336;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56336__$1,inst_56334);
} else {
if((state_val_56337 === (2))){
var _ = (function (){var statearr_56342 = state_56336;
(statearr_56342[(4)] = cljs.core.cons.call(null,(5),(state_56336[(4)])));

return statearr_56342;
})();
var inst_56315 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56336__$1 = state_56336;
if(cljs.core.truth_(inst_56315)){
var statearr_56343_56360 = state_56336__$1;
(statearr_56343_56360[(1)] = (6));

} else {
var statearr_56344_56361 = state_56336__$1;
(statearr_56344_56361[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56337 === (9))){
var inst_56319 = (state_56336[(2)]);
var inst_56320 = fluree.db.util.async.throw_err.call(null,inst_56319);
var inst_56321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56322 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56323 = ["?auth_id","?ctx",inst_56320];
var inst_56324 = cljs.core.PersistentHashMap.fromArrays(inst_56322,inst_56323);
var inst_56325 = [inst_56324,(10)];
var inst_56326 = (new cljs.core.PersistentVector(null,2,(5),inst_56321,inst_56325,null));
var inst_56327 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56326);
var state_56336__$1 = (function (){var statearr_56345 = state_56336;
(statearr_56345[(7)] = inst_56327);

return statearr_56345;
})();
var statearr_56346_56362 = state_56336__$1;
(statearr_56346_56362[(2)] = inst_56320);

(statearr_56346_56362[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56337 === (5))){
var _ = (function (){var statearr_56347 = state_56336;
(statearr_56347[(4)] = cljs.core.rest.call(null,(state_56336[(4)])));

return statearr_56347;
})();
var state_56336__$1 = state_56336;
var ex56341 = (state_56336__$1[(2)]);
var statearr_56348_56363 = state_56336__$1;
(statearr_56348_56363[(5)] = ex56341);


if((ex56341 instanceof Error)){
var statearr_56349_56364 = state_56336__$1;
(statearr_56349_56364[(1)] = (4));

(statearr_56349_56364[(5)] = null);

} else {
throw ex56341;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56337 === (8))){
var inst_56331 = (state_56336[(2)]);
var _ = (function (){var statearr_56350 = state_56336;
(statearr_56350[(4)] = cljs.core.rest.call(null,(state_56336[(4)])));

return statearr_56350;
})();
var state_56336__$1 = state_56336;
var statearr_56351_56365 = state_56336__$1;
(statearr_56351_56365[(2)] = inst_56331);

(statearr_56351_56365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0 = (function (){
var statearr_56352 = [null,null,null,null,null,null,null,null];
(statearr_56352[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__);

(statearr_56352[(1)] = (1));

return statearr_56352;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1 = (function (state_56336){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56336);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56353){var ex__2749__auto__ = e56353;
var statearr_56354_56366 = state_56336;
(statearr_56354_56366[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56336[(4)]))){
var statearr_56355_56367 = state_56336;
(statearr_56355_56367[(1)] = cljs.core.first.call(null,(state_56336[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56368 = state_56336;
state_56336 = G__56368;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__ = function(state_56336){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1.call(this,state_56336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56356 = f__2769__auto__.call(null);
(statearr_56356[(6)] = c__2768__auto__);

return statearr_56356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__56370 = arguments.length;
switch (G__56370) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56412){
var state_val_56413 = (state_56412[(1)]);
if((state_val_56413 === (7))){
var state_56412__$1 = state_56412;
var statearr_56414_56444 = state_56412__$1;
(statearr_56414_56444[(2)] = seed);

(statearr_56414_56444[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56413 === (1))){
var state_56412__$1 = state_56412;
var statearr_56415_56445 = state_56412__$1;
(statearr_56415_56445[(2)] = null);

(statearr_56415_56445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56413 === (4))){
var inst_56371 = (state_56412[(2)]);
var state_56412__$1 = state_56412;
var statearr_56416_56446 = state_56412__$1;
(statearr_56416_56446[(2)] = inst_56371);

(statearr_56416_56446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56413 === (15))){
var state_56412__$1 = state_56412;
var statearr_56417_56447 = state_56412__$1;
(statearr_56417_56447[(2)] = (10));

(statearr_56417_56447[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56413 === (13))){
var inst_56388 = (state_56412[(2)]);
var inst_56389 = fluree.db.util.async.throw_err.call(null,inst_56388);
var state_56412__$1 = state_56412;
var statearr_56418_56448 = state_56412__$1;
(statearr_56418_56448[(2)] = inst_56389);

(statearr_56418_56448[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56413 === (6))){
var state_56412__$1 = state_56412;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56412__$1,(9),seed);
} else {
if((state_val_56413 === (3))){
var inst_56410 = (state_56412[(2)]);
var state_56412__$1 = state_56412;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56412__$1,inst_56410);
} else {
if((state_val_56413 === (12))){
var inst_56392 = (state_56412[(7)]);
var inst_56392__$1 = (state_56412[(2)]);
var state_56412__$1 = (function (){var statearr_56419 = state_56412;
(statearr_56419[(7)] = inst_56392__$1);

return statearr_56419;
})();
if(cljs.core.truth_(inst_56392__$1)){
var statearr_56420_56449 = state_56412__$1;
(statearr_56420_56449[(1)] = (14));

} else {
var statearr_56421_56450 = state_56412__$1;
(statearr_56421_56450[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56413 === (2))){
var _ = (function (){var statearr_56422 = state_56412;
(statearr_56422[(4)] = cljs.core.cons.call(null,(5),(state_56412[(4)])));

return statearr_56422;
})();
var inst_56377 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_56412__$1 = state_56412;
if(inst_56377){
var statearr_56423_56451 = state_56412__$1;
(statearr_56423_56451[(1)] = (6));

} else {
var statearr_56424_56452 = state_56412__$1;
(statearr_56424_56452[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56413 === (11))){
var state_56412__$1 = state_56412;
var statearr_56426_56453 = state_56412__$1;
(statearr_56426_56453[(2)] = max);

(statearr_56426_56453[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56413 === (9))){
var inst_56380 = (state_56412[(2)]);
var inst_56381 = fluree.db.util.async.throw_err.call(null,inst_56380);
var state_56412__$1 = state_56412;
var statearr_56427_56454 = state_56412__$1;
(statearr_56427_56454[(2)] = inst_56381);

(statearr_56427_56454[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56413 === (5))){
var _ = (function (){var statearr_56428 = state_56412;
(statearr_56428[(4)] = cljs.core.rest.call(null,(state_56412[(4)])));

return statearr_56428;
})();
var state_56412__$1 = state_56412;
var ex56425 = (state_56412__$1[(2)]);
var statearr_56429_56455 = state_56412__$1;
(statearr_56429_56455[(5)] = ex56425);


if((ex56425 instanceof Error)){
var statearr_56430_56456 = state_56412__$1;
(statearr_56430_56456[(1)] = (4));

(statearr_56430_56456[(5)] = null);

} else {
throw ex56425;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56413 === (14))){
var inst_56392 = (state_56412[(7)]);
var state_56412__$1 = state_56412;
var statearr_56431_56457 = state_56412__$1;
(statearr_56431_56457[(2)] = inst_56392);

(statearr_56431_56457[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56413 === (16))){
var inst_56384 = (state_56412[(8)]);
var inst_56396 = (state_56412[(2)]);
var inst_56397 = fluree.db.dbfunctions.internal.rand.call(null,inst_56384,inst_56396);
var inst_56398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56399 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56401 = [max,seed];
var inst_56402 = (new cljs.core.PersistentVector(null,2,(5),inst_56400,inst_56401,null));
var inst_56403 = ["rand",inst_56402,inst_56397];
var inst_56404 = cljs.core.PersistentHashMap.fromArrays(inst_56399,inst_56403);
var inst_56405 = [inst_56404,(10)];
var inst_56406 = (new cljs.core.PersistentVector(null,2,(5),inst_56398,inst_56405,null));
var inst_56407 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56406);
var _ = (function (){var statearr_56432 = state_56412;
(statearr_56432[(4)] = cljs.core.rest.call(null,(state_56412[(4)])));

return statearr_56432;
})();
var state_56412__$1 = (function (){var statearr_56433 = state_56412;
(statearr_56433[(9)] = inst_56407);

return statearr_56433;
})();
var statearr_56434_56458 = state_56412__$1;
(statearr_56434_56458[(2)] = inst_56397);

(statearr_56434_56458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56413 === (10))){
var state_56412__$1 = state_56412;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56412__$1,(13),max);
} else {
if((state_val_56413 === (8))){
var inst_56384 = (state_56412[(2)]);
var inst_56385 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_56412__$1 = (function (){var statearr_56435 = state_56412;
(statearr_56435[(8)] = inst_56384);

return statearr_56435;
})();
if(inst_56385){
var statearr_56436_56459 = state_56412__$1;
(statearr_56436_56459[(1)] = (10));

} else {
var statearr_56437_56460 = state_56412__$1;
(statearr_56437_56460[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56438 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56438[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56438[(1)] = (1));

return statearr_56438;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56412){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56412);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56439){var ex__2749__auto__ = e56439;
var statearr_56440_56461 = state_56412;
(statearr_56440_56461[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56412[(4)]))){
var statearr_56441_56462 = state_56412;
(statearr_56441_56462[(1)] = cljs.core.first.call(null,(state_56412[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56463 = state_56412;
state_56412 = G__56463;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56412){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56442 = f__2769__auto__.call(null);
(statearr_56442[(6)] = c__2768__auto__);

return statearr_56442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56484){
var state_val_56485 = (state_56484[(1)]);
if((state_val_56485 === (1))){
var state_56484__$1 = state_56484;
var statearr_56486_56501 = state_56484__$1;
(statearr_56486_56501[(2)] = null);

(statearr_56486_56501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (2))){
var _ = (function (){var statearr_56487 = state_56484;
(statearr_56487[(4)] = cljs.core.cons.call(null,(5),(state_56484[(4)])));

return statearr_56487;
})();
var inst_56470 = fluree.db.util.core.random_uuid.call(null);
var inst_56471 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_56470);
var inst_56472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56473 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56474 = cljs.core.PersistentVector.EMPTY;
var inst_56475 = ["uuid",inst_56474,inst_56471];
var inst_56476 = cljs.core.PersistentHashMap.fromArrays(inst_56473,inst_56475);
var inst_56477 = [inst_56476,(10)];
var inst_56478 = (new cljs.core.PersistentVector(null,2,(5),inst_56472,inst_56477,null));
var inst_56479 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56478);
var ___$1 = (function (){var statearr_56488 = state_56484;
(statearr_56488[(4)] = cljs.core.rest.call(null,(state_56484[(4)])));

return statearr_56488;
})();
var state_56484__$1 = (function (){var statearr_56489 = state_56484;
(statearr_56489[(7)] = inst_56479);

return statearr_56489;
})();
var statearr_56490_56502 = state_56484__$1;
(statearr_56490_56502[(2)] = inst_56471);

(statearr_56490_56502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (3))){
var inst_56482 = (state_56484[(2)]);
var state_56484__$1 = state_56484;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56484__$1,inst_56482);
} else {
if((state_val_56485 === (4))){
var inst_56464 = (state_56484[(2)]);
var state_56484__$1 = state_56484;
var statearr_56492_56503 = state_56484__$1;
(statearr_56492_56503[(2)] = inst_56464);

(statearr_56492_56503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (5))){
var _ = (function (){var statearr_56493 = state_56484;
(statearr_56493[(4)] = cljs.core.rest.call(null,(state_56484[(4)])));

return statearr_56493;
})();
var state_56484__$1 = state_56484;
var ex56491 = (state_56484__$1[(2)]);
var statearr_56494_56504 = state_56484__$1;
(statearr_56494_56504[(5)] = ex56491);


if((ex56491 instanceof Error)){
var statearr_56495_56505 = state_56484__$1;
(statearr_56495_56505[(1)] = (4));

(statearr_56495_56505[(5)] = null);

} else {
throw ex56491;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0 = (function (){
var statearr_56496 = [null,null,null,null,null,null,null,null];
(statearr_56496[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__);

(statearr_56496[(1)] = (1));

return statearr_56496;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1 = (function (state_56484){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56484);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56497){var ex__2749__auto__ = e56497;
var statearr_56498_56506 = state_56484;
(statearr_56498_56506[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56484[(4)]))){
var statearr_56499_56507 = state_56484;
(statearr_56499_56507[(1)] = cljs.core.first.call(null,(state_56484[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56508 = state_56484;
state_56484 = G__56508;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__ = function(state_56484){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1.call(this,state_56484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56500 = f__2769__auto__.call(null);
(statearr_56500[(6)] = c__2768__auto__);

return statearr_56500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56538){
var state_val_56539 = (state_56538[(1)]);
if((state_val_56539 === (7))){
var state_56538__$1 = state_56538;
var statearr_56540_56559 = state_56538__$1;
(statearr_56540_56559[(2)] = num);

(statearr_56540_56559[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56539 === (1))){
var state_56538__$1 = state_56538;
var statearr_56541_56560 = state_56538__$1;
(statearr_56541_56560[(2)] = null);

(statearr_56541_56560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56539 === (4))){
var inst_56509 = (state_56538[(2)]);
var state_56538__$1 = state_56538;
var statearr_56542_56561 = state_56538__$1;
(statearr_56542_56561[(2)] = inst_56509);

(statearr_56542_56561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56539 === (6))){
var state_56538__$1 = state_56538;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56538__$1,(9),num);
} else {
if((state_val_56539 === (3))){
var inst_56536 = (state_56538[(2)]);
var state_56538__$1 = state_56538;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56538__$1,inst_56536);
} else {
if((state_val_56539 === (2))){
var _ = (function (){var statearr_56544 = state_56538;
(statearr_56544[(4)] = cljs.core.cons.call(null,(5),(state_56538[(4)])));

return statearr_56544;
})();
var inst_56515 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_56538__$1 = state_56538;
if(inst_56515){
var statearr_56545_56562 = state_56538__$1;
(statearr_56545_56562[(1)] = (6));

} else {
var statearr_56546_56563 = state_56538__$1;
(statearr_56546_56563[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56539 === (9))){
var inst_56518 = (state_56538[(2)]);
var inst_56519 = fluree.db.util.async.throw_err.call(null,inst_56518);
var state_56538__$1 = state_56538;
var statearr_56547_56564 = state_56538__$1;
(statearr_56547_56564[(2)] = inst_56519);

(statearr_56547_56564[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56539 === (5))){
var _ = (function (){var statearr_56548 = state_56538;
(statearr_56548[(4)] = cljs.core.rest.call(null,(state_56538[(4)])));

return statearr_56548;
})();
var state_56538__$1 = state_56538;
var ex56543 = (state_56538__$1[(2)]);
var statearr_56549_56565 = state_56538__$1;
(statearr_56549_56565[(5)] = ex56543);


if((ex56543 instanceof Error)){
var statearr_56550_56566 = state_56538__$1;
(statearr_56550_56566[(1)] = (4));

(statearr_56550_56566[(5)] = null);

} else {
throw ex56543;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56539 === (8))){
var inst_56522 = (state_56538[(2)]);
var inst_56523 = fluree.db.dbfunctions.internal.ceil.call(null,inst_56522);
var inst_56524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56525 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56527 = [fluree.db.dbfunctions.fns.ceil];
var inst_56528 = (new cljs.core.PersistentVector(null,1,(5),inst_56526,inst_56527,null));
var inst_56529 = ["",inst_56528,inst_56523];
var inst_56530 = cljs.core.PersistentHashMap.fromArrays(inst_56525,inst_56529);
var inst_56531 = [inst_56530,(10)];
var inst_56532 = (new cljs.core.PersistentVector(null,2,(5),inst_56524,inst_56531,null));
var inst_56533 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56532);
var _ = (function (){var statearr_56551 = state_56538;
(statearr_56551[(4)] = cljs.core.rest.call(null,(state_56538[(4)])));

return statearr_56551;
})();
var state_56538__$1 = (function (){var statearr_56552 = state_56538;
(statearr_56552[(7)] = inst_56533);

return statearr_56552;
})();
var statearr_56553_56567 = state_56538__$1;
(statearr_56553_56567[(2)] = inst_56523);

(statearr_56553_56567[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0 = (function (){
var statearr_56554 = [null,null,null,null,null,null,null,null];
(statearr_56554[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__);

(statearr_56554[(1)] = (1));

return statearr_56554;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1 = (function (state_56538){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56538);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56555){var ex__2749__auto__ = e56555;
var statearr_56556_56568 = state_56538;
(statearr_56556_56568[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56538[(4)]))){
var statearr_56557_56569 = state_56538;
(statearr_56557_56569[(1)] = cljs.core.first.call(null,(state_56538[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56570 = state_56538;
state_56538 = G__56570;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__ = function(state_56538){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1.call(this,state_56538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56558 = f__2769__auto__.call(null);
(statearr_56558[(6)] = c__2768__auto__);

return statearr_56558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56600){
var state_val_56601 = (state_56600[(1)]);
if((state_val_56601 === (7))){
var state_56600__$1 = state_56600;
var statearr_56602_56621 = state_56600__$1;
(statearr_56602_56621[(2)] = num);

(statearr_56602_56621[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56601 === (1))){
var state_56600__$1 = state_56600;
var statearr_56603_56622 = state_56600__$1;
(statearr_56603_56622[(2)] = null);

(statearr_56603_56622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56601 === (4))){
var inst_56571 = (state_56600[(2)]);
var state_56600__$1 = state_56600;
var statearr_56604_56623 = state_56600__$1;
(statearr_56604_56623[(2)] = inst_56571);

(statearr_56604_56623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56601 === (6))){
var state_56600__$1 = state_56600;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56600__$1,(9),num);
} else {
if((state_val_56601 === (3))){
var inst_56598 = (state_56600[(2)]);
var state_56600__$1 = state_56600;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56600__$1,inst_56598);
} else {
if((state_val_56601 === (2))){
var _ = (function (){var statearr_56606 = state_56600;
(statearr_56606[(4)] = cljs.core.cons.call(null,(5),(state_56600[(4)])));

return statearr_56606;
})();
var inst_56577 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_56600__$1 = state_56600;
if(inst_56577){
var statearr_56607_56624 = state_56600__$1;
(statearr_56607_56624[(1)] = (6));

} else {
var statearr_56608_56625 = state_56600__$1;
(statearr_56608_56625[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56601 === (9))){
var inst_56580 = (state_56600[(2)]);
var inst_56581 = fluree.db.util.async.throw_err.call(null,inst_56580);
var state_56600__$1 = state_56600;
var statearr_56609_56626 = state_56600__$1;
(statearr_56609_56626[(2)] = inst_56581);

(statearr_56609_56626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56601 === (5))){
var _ = (function (){var statearr_56610 = state_56600;
(statearr_56610[(4)] = cljs.core.rest.call(null,(state_56600[(4)])));

return statearr_56610;
})();
var state_56600__$1 = state_56600;
var ex56605 = (state_56600__$1[(2)]);
var statearr_56611_56627 = state_56600__$1;
(statearr_56611_56627[(5)] = ex56605);


if((ex56605 instanceof Error)){
var statearr_56612_56628 = state_56600__$1;
(statearr_56612_56628[(1)] = (4));

(statearr_56612_56628[(5)] = null);

} else {
throw ex56605;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56601 === (8))){
var inst_56584 = (state_56600[(2)]);
var inst_56585 = fluree.db.dbfunctions.internal.floor.call(null,inst_56584);
var inst_56586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56587 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56588 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56589 = [fluree.db.dbfunctions.fns.floor];
var inst_56590 = (new cljs.core.PersistentVector(null,1,(5),inst_56588,inst_56589,null));
var inst_56591 = ["",inst_56590,inst_56585];
var inst_56592 = cljs.core.PersistentHashMap.fromArrays(inst_56587,inst_56591);
var inst_56593 = [inst_56592,(10)];
var inst_56594 = (new cljs.core.PersistentVector(null,2,(5),inst_56586,inst_56593,null));
var inst_56595 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56594);
var _ = (function (){var statearr_56613 = state_56600;
(statearr_56613[(4)] = cljs.core.rest.call(null,(state_56600[(4)])));

return statearr_56613;
})();
var state_56600__$1 = (function (){var statearr_56614 = state_56600;
(statearr_56614[(7)] = inst_56595);

return statearr_56614;
})();
var statearr_56615_56629 = state_56600__$1;
(statearr_56615_56629[(2)] = inst_56585);

(statearr_56615_56629[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0 = (function (){
var statearr_56616 = [null,null,null,null,null,null,null,null];
(statearr_56616[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__);

(statearr_56616[(1)] = (1));

return statearr_56616;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1 = (function (state_56600){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56600);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56617){var ex__2749__auto__ = e56617;
var statearr_56618_56630 = state_56600;
(statearr_56618_56630[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56600[(4)]))){
var statearr_56619_56631 = state_56600;
(statearr_56619_56631[(1)] = cljs.core.first.call(null,(state_56600[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56632 = state_56600;
state_56600 = G__56632;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__ = function(state_56600){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1.call(this,state_56600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56620 = f__2769__auto__.call(null);
(statearr_56620[(6)] = c__2768__auto__);

return statearr_56620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56657){
var state_val_56658 = (state_56657[(1)]);
if((state_val_56658 === (1))){
var state_56657__$1 = state_56657;
var statearr_56659_56674 = state_56657__$1;
(statearr_56659_56674[(2)] = null);

(statearr_56659_56674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56658 === (2))){
var _ = (function (){var statearr_56660 = state_56657;
(statearr_56660[(4)] = cljs.core.cons.call(null,(5),(state_56657[(4)])));

return statearr_56660;
})();
var inst_56639 = fluree.db.dbfunctions.internal.cas.call(null,_QMARK_ctx,compare_val,new_val);
var state_56657__$1 = state_56657;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56657__$1,(6),inst_56639);
} else {
if((state_val_56658 === (3))){
var inst_56655 = (state_56657[(2)]);
var state_56657__$1 = state_56657;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56657__$1,inst_56655);
} else {
if((state_val_56658 === (4))){
var inst_56633 = (state_56657[(2)]);
var state_56657__$1 = state_56657;
var statearr_56662_56675 = state_56657__$1;
(statearr_56662_56675[(2)] = inst_56633);

(statearr_56662_56675[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56658 === (5))){
var _ = (function (){var statearr_56663 = state_56657;
(statearr_56663[(4)] = cljs.core.rest.call(null,(state_56657[(4)])));

return statearr_56663;
})();
var state_56657__$1 = state_56657;
var ex56661 = (state_56657__$1[(2)]);
var statearr_56664_56676 = state_56657__$1;
(statearr_56664_56676[(5)] = ex56661);


if((ex56661 instanceof Error)){
var statearr_56665_56677 = state_56657__$1;
(statearr_56665_56677[(1)] = (4));

(statearr_56665_56677[(5)] = null);

} else {
throw ex56661;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56658 === (6))){
var inst_56641 = (state_56657[(2)]);
var inst_56642 = fluree.db.util.async.throw_err.call(null,inst_56641);
var inst_56643 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56644 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56646 = [compare_val,new_val];
var inst_56647 = (new cljs.core.PersistentVector(null,2,(5),inst_56645,inst_56646,null));
var inst_56648 = ["",inst_56647,inst_56642];
var inst_56649 = cljs.core.PersistentHashMap.fromArrays(inst_56644,inst_56648);
var inst_56650 = [inst_56649,(10)];
var inst_56651 = (new cljs.core.PersistentVector(null,2,(5),inst_56643,inst_56650,null));
var inst_56652 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56651);
var _ = (function (){var statearr_56666 = state_56657;
(statearr_56666[(4)] = cljs.core.rest.call(null,(state_56657[(4)])));

return statearr_56666;
})();
var state_56657__$1 = (function (){var statearr_56667 = state_56657;
(statearr_56667[(7)] = inst_56652);

return statearr_56667;
})();
var statearr_56668_56678 = state_56657__$1;
(statearr_56668_56678[(2)] = inst_56642);

(statearr_56668_56678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0 = (function (){
var statearr_56669 = [null,null,null,null,null,null,null,null];
(statearr_56669[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__);

(statearr_56669[(1)] = (1));

return statearr_56669;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1 = (function (state_56657){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56657);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56670){var ex__2749__auto__ = e56670;
var statearr_56671_56679 = state_56657;
(statearr_56671_56679[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56657[(4)]))){
var statearr_56672_56680 = state_56657;
(statearr_56672_56680[(1)] = cljs.core.first.call(null,(state_56657[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56681 = state_56657;
state_56657 = G__56681;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__ = function(state_56657){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1.call(this,state_56657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56673 = f__2769__auto__.call(null);
(statearr_56673[(6)] = c__2768__auto__);

return statearr_56673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
