// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__19888_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19888_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__19892 = coll;
var vec__19893 = G__19892;
var seq__19894 = cljs.core.seq.call(null,vec__19893);
var first__19895 = cljs.core.first.call(null,seq__19894);
var seq__19894__$1 = cljs.core.next.call(null,seq__19894);
var clause = first__19895;
var r = seq__19894__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19892__$1 = G__19892;
var res__$1 = res;
while(true){
var vec__19899 = G__19892__$1;
var seq__19900 = cljs.core.seq.call(null,vec__19899);
var first__19901 = cljs.core.first.call(null,seq__19900);
var seq__19900__$1 = cljs.core.next.call(null,seq__19900);
var clause__$1 = first__19901;
var r__$1 = seq__19900__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19902 = r__$1;
var G__19903 = cljs.core.conj.call(null,res__$2,clause__$1);
G__19892__$1 = G__19902;
res__$1 = G__19903;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.call(null,(function (res,p__19904){
var map__19905 = p__19904;
var map__19905__$1 = cljs.core.__destructure_map.call(null,map__19905);
var optional = cljs.core.get.call(null,map__19905__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.call(null,res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__19909 = coll;
var vec__19910 = G__19909;
var seq__19911 = cljs.core.seq.call(null,vec__19910);
var first__19912 = cljs.core.first.call(null,seq__19911);
var seq__19911__$1 = cljs.core.next.call(null,seq__19911);
var clause = first__19912;
var r = seq__19911__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19909__$1 = G__19909;
var res__$1 = res;
while(true){
var vec__19916 = G__19909__$1;
var seq__19917 = cljs.core.seq.call(null,vec__19916);
var first__19918 = cljs.core.first.call(null,seq__19917);
var seq__19917__$1 = cljs.core.next.call(null,seq__19917);
var clause__$1 = first__19918;
var r__$1 = seq__19917__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19919 = r__$1;
var G__19920 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__19909__$1 = G__19919;
res__$1 = G__19920;
continue;
} else {
var G__19921 = r__$1;
var G__19922 = res__$2;
G__19909__$1 = G__19921;
res__$1 = G__19922;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__19926 = coll;
var vec__19927 = G__19926;
var seq__19928 = cljs.core.seq.call(null,vec__19927);
var first__19929 = cljs.core.first.call(null,seq__19928);
var seq__19928__$1 = cljs.core.next.call(null,seq__19928);
var clause = first__19929;
var r = seq__19928__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19926__$1 = G__19926;
var res__$1 = res;
while(true){
var vec__19933 = G__19926__$1;
var seq__19934 = cljs.core.seq.call(null,vec__19933);
var first__19935 = cljs.core.first.call(null,seq__19934);
var seq__19934__$1 = cljs.core.next.call(null,seq__19934);
var clause__$1 = first__19935;
var r__$1 = seq__19934__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19936 = r__$1;
var G__19937 = res__$2;
G__19926__$1 = G__19936;
res__$1 = G__19937;
continue;
} else {
var G__19938 = r__$1;
var G__19939 = cljs.core.conj.call(null,res__$2,clause__$1);
G__19926__$1 = G__19938;
res__$1 = G__19939;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__19942 = clause;
var G__19942__$1 = ((cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause)))?cljs.core.drop.call(null,(1),G__19942):G__19942);
var G__19942__$2 = clojure.string.join.call(null," ",G__19942__$1)
;
var G__19942__$3 = (function (p1__19940_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19940_SHARP_)," ."].join('');
}).call(null,G__19942__$2)
;
if(cljs.core.truth_(optional_QMARK_)){
return (function (p1__19941_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19941_SHARP_),"}"].join('');
}).call(null,G__19942__$3);
} else {
return G__19942__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__19946 = opts;
var map__19946__$1 = cljs.core.__destructure_map.call(null,map__19946);
var limit = cljs.core.get.call(null,map__19946__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__19946__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__19946__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__19946__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__19946__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__19943_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19943_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__19944_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__19944_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__19945_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__19945_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = language;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19960){
var state_val_19961 = (state_19960[(1)]);
if((state_val_19961 === (1))){
var inst_19947 = fluree.db.util.core.url_encode.call(null,query);
var inst_19948 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19947)].join('');
var inst_19949 = ["User-Agent","Accept"];
var inst_19950 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_19951 = cljs.core.PersistentHashMap.fromArrays(inst_19949,inst_19950);
var inst_19952 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_19953 = [inst_19951,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_19954 = cljs.core.PersistentHashMap.fromArrays(inst_19952,inst_19953);
var inst_19955 = fluree.db.util.xhttp.get.call(null,inst_19948,inst_19954);
var state_19960__$1 = state_19960;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19960__$1,(2),inst_19955);
} else {
if((state_val_19961 === (2))){
var inst_19957 = (state_19960[(2)]);
var inst_19958 = fluree.db.util.async.throw_err.call(null,inst_19957);
var state_19960__$1 = state_19960;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19960__$1,inst_19958);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0 = (function (){
var statearr_19962 = [null,null,null,null,null,null,null];
(statearr_19962[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__);

(statearr_19962[(1)] = (1));

return statearr_19962;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1 = (function (state_19960){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19960);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19963){var ex__2749__auto__ = e19963;
var statearr_19964_19967 = state_19960;
(statearr_19964_19967[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19960[(4)]))){
var statearr_19965_19968 = state_19960;
(statearr_19965_19968[(1)] = cljs.core.first.call(null,(state_19960[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19969 = state_19960;
state_19960 = G__19969;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__ = function(state_19960){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1.call(this,state_19960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19966 = f__2769__auto__.call(null);
(statearr_19966[(6)] = c__2768__auto__);

return statearr_19966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19987){
var state_val_19988 = (state_19987[(1)]);
if((state_val_19988 === (1))){
var inst_19970 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_19987__$1 = state_19987;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19987__$1,(2),inst_19970);
} else {
if((state_val_19988 === (2))){
var inst_19973 = (state_19987[(7)]);
var inst_19972 = (state_19987[(2)]);
var inst_19973__$1 = fluree.db.util.async.throw_err.call(null,inst_19972);
var inst_19974 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_19973__$1);
var inst_19975 = cljs.core.not_EQ_.call(null,(200),inst_19974);
var state_19987__$1 = (function (){var statearr_19989 = state_19987;
(statearr_19989[(7)] = inst_19973__$1);

return statearr_19989;
})();
if(inst_19975){
var statearr_19990_19999 = state_19987__$1;
(statearr_19990_19999[(1)] = (3));

} else {
var statearr_19991_20000 = state_19987__$1;
(statearr_19991_20000[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (3))){
var inst_19973 = (state_19987[(7)]);
var state_19987__$1 = state_19987;
var statearr_19992_20001 = state_19987__$1;
(statearr_19992_20001[(2)] = inst_19973);

(statearr_19992_20001[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (4))){
var inst_19973 = (state_19987[(7)]);
var inst_19978 = (function (){var body = inst_19973;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_19979 = cljs.core.second.call(null,inst_19973);
var inst_19980 = cljs.core.second.call(null,inst_19979);
var inst_19981 = cljs.core.first.call(null,inst_19980);
var inst_19982 = cljs.core.second.call(null,inst_19981);
var inst_19983 = cljs.core.mapv.call(null,inst_19978,inst_19982);
var state_19987__$1 = state_19987;
var statearr_19993_20002 = state_19987__$1;
(statearr_19993_20002[(2)] = inst_19983);

(statearr_19993_20002[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (5))){
var inst_19985 = (state_19987[(2)]);
var state_19987__$1 = state_19987;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19987__$1,inst_19985);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0 = (function (){
var statearr_19994 = [null,null,null,null,null,null,null,null];
(statearr_19994[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__);

(statearr_19994[(1)] = (1));

return statearr_19994;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1 = (function (state_19987){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19987);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19995){var ex__2749__auto__ = e19995;
var statearr_19996_20003 = state_19987;
(statearr_19996_20003[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19987[(4)]))){
var statearr_19997_20004 = state_19987;
(statearr_19997_20004[(1)] = cljs.core.first.call(null,(state_19987[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20005 = state_19987;
state_19987 = G__20005;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__ = function(state_19987){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1.call(this,state_19987);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19998 = f__2769__auto__.call(null);
(statearr_19998[(6)] = c__2768__auto__);

return statearr_19998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__20006_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20006_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__20007_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20007_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__20008_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__20008_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20054){
var state_val_20055 = (state_20054[(1)]);
if((state_val_20055 === (7))){
var inst_20019 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_20054__$1 = state_20054;
var statearr_20056_20084 = state_20054__$1;
(statearr_20056_20084[(2)] = inst_20019);

(statearr_20056_20084[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20055 === (1))){
var state_20054__$1 = state_20054;
var statearr_20057_20085 = state_20054__$1;
(statearr_20057_20085[(2)] = null);

(statearr_20057_20085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20055 === (4))){
var inst_20009 = (state_20054[(2)]);
var state_20054__$1 = state_20054;
var statearr_20058_20086 = state_20054__$1;
(statearr_20058_20086[(2)] = inst_20009);

(statearr_20058_20086[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20055 === (15))){
var inst_20028 = (state_20054[(7)]);
var inst_20033 = (state_20054[(8)]);
var inst_20027 = (state_20054[(9)]);
var inst_20038 = (state_20054[(2)]);
var inst_20039 = cljs.core.subs.call(null,inst_20033,(0),inst_20038);
var inst_20040 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20041 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_20027);
var inst_20042 = [inst_20028,inst_20041];
var inst_20043 = cljs.core.PersistentHashMap.fromArrays(inst_20040,inst_20042);
var inst_20044 = cljs.core.ex_info.call(null,inst_20039,inst_20043);
var inst_20045 = (function(){throw inst_20044})();
var state_20054__$1 = state_20054;
var statearr_20059_20087 = state_20054__$1;
(statearr_20059_20087[(2)] = inst_20045);

(statearr_20059_20087[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20055 === (13))){
var inst_20032 = (state_20054[(10)]);
var state_20054__$1 = state_20054;
var statearr_20060_20088 = state_20054__$1;
(statearr_20060_20088[(2)] = inst_20032);

(statearr_20060_20088[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20055 === (6))){
var state_20054__$1 = state_20054;
var statearr_20061_20089 = state_20054__$1;
(statearr_20061_20089[(2)] = null);

(statearr_20061_20089[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20055 === (3))){
var inst_20052 = (state_20054[(2)]);
var state_20054__$1 = state_20054;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20054__$1,inst_20052);
} else {
if((state_val_20055 === (12))){
var inst_20049 = (state_20054[(2)]);
var _ = (function (){var statearr_20062 = state_20054;
(statearr_20062[(4)] = cljs.core.rest.call(null,(state_20054[(4)])));

return statearr_20062;
})();
var state_20054__$1 = state_20054;
var statearr_20063_20090 = state_20054__$1;
(statearr_20063_20090[(2)] = inst_20049);

(statearr_20063_20090[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20055 === (2))){
var _ = (function (){var statearr_20064 = state_20054;
(statearr_20064[(4)] = cljs.core.cons.call(null,(5),(state_20054[(4)])));

return statearr_20064;
})();
var inst_20016 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_20054__$1 = state_20054;
if(inst_20016){
var statearr_20065_20091 = state_20054__$1;
(statearr_20065_20091[(1)] = (6));

} else {
var statearr_20066_20092 = state_20054__$1;
(statearr_20066_20092[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20055 === (11))){
var inst_20027 = (state_20054[(9)]);
var inst_20047 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_20027,all_vars);
var state_20054__$1 = state_20054;
var statearr_20068_20093 = state_20054__$1;
(statearr_20068_20093[(2)] = inst_20047);

(statearr_20068_20093[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20055 === (9))){
var inst_20028 = (state_20054[(7)]);
var inst_20027 = (state_20054[(9)]);
var inst_20025 = (state_20054[(2)]);
var inst_20026 = fluree.db.util.async.throw_err.call(null,inst_20025);
var inst_20027__$1 = cljs.core.__destructure_map.call(null,inst_20026);
var inst_20028__$1 = cljs.core.get.call(null,inst_20027__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_20029 = cljs.core.get.call(null,inst_20027__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_20030 = cljs.core._EQ_.call(null,(400),inst_20028__$1);
var state_20054__$1 = (function (){var statearr_20069 = state_20054;
(statearr_20069[(7)] = inst_20028__$1);

(statearr_20069[(11)] = inst_20029);

(statearr_20069[(9)] = inst_20027__$1);

return statearr_20069;
})();
if(inst_20030){
var statearr_20070_20094 = state_20054__$1;
(statearr_20070_20094[(1)] = (10));

} else {
var statearr_20071_20095 = state_20054__$1;
(statearr_20071_20095[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20055 === (5))){
var _ = (function (){var statearr_20072 = state_20054;
(statearr_20072[(4)] = cljs.core.rest.call(null,(state_20054[(4)])));

return statearr_20072;
})();
var state_20054__$1 = state_20054;
var ex20067 = (state_20054__$1[(2)]);
var statearr_20073_20096 = state_20054__$1;
(statearr_20073_20096[(5)] = ex20067);


if((ex20067 instanceof Error)){
var statearr_20074_20097 = state_20054__$1;
(statearr_20074_20097[(1)] = (4));

(statearr_20074_20097[(5)] = null);

} else {
throw ex20067;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20055 === (14))){
var state_20054__$1 = state_20054;
var statearr_20075_20098 = state_20054__$1;
(statearr_20075_20098[(2)] = (1000));

(statearr_20075_20098[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20055 === (10))){
var inst_20032 = (state_20054[(10)]);
var inst_20029 = (state_20054[(11)]);
var inst_20027 = (state_20054[(9)]);
var inst_20032__$1 = cljs.core.count.call(null,inst_20029);
var inst_20033 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_20027);
var inst_20034 = (inst_20032__$1 < (1000));
var state_20054__$1 = (function (){var statearr_20076 = state_20054;
(statearr_20076[(10)] = inst_20032__$1);

(statearr_20076[(8)] = inst_20033);

return statearr_20076;
})();
if(cljs.core.truth_(inst_20034)){
var statearr_20077_20099 = state_20054__$1;
(statearr_20077_20099[(1)] = (13));

} else {
var statearr_20078_20100 = state_20054__$1;
(statearr_20078_20100[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20055 === (8))){
var inst_20021 = (state_20054[(2)]);
var inst_20022 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_20021,optional_clauses);
var inst_20023 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_20022);
var state_20054__$1 = state_20054;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20054__$1,(9),inst_20023);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20079 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20079[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__);

(statearr_20079[(1)] = (1));

return statearr_20079;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1 = (function (state_20054){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20054);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20080){var ex__2749__auto__ = e20080;
var statearr_20081_20101 = state_20054;
(statearr_20081_20101[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20054[(4)]))){
var statearr_20082_20102 = state_20054;
(statearr_20082_20102[(1)] = cljs.core.first.call(null,(state_20054[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20103 = state_20054;
state_20054 = G__20103;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__ = function(state_20054){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1.call(this,state_20054);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20083 = f__2769__auto__.call(null);
(statearr_20083[(6)] = c__2768__auto__);

return statearr_20083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
