// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__22029 = arguments.length;
switch (G__22029) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__22032 = arguments.length;
switch (G__22032) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22034 = null;
var G__22034__0 = (function (){
return xf.call(null);
});
var G__22034__1 = (function (result){
return xf.call(null,result);
});
var G__22034__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__22034 = function(result,flake){
switch(arguments.length){
case 0:
return G__22034__0.call(this);
case 1:
return G__22034__1.call(this,result);
case 2:
return G__22034__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22034.cljs$core$IFn$_invoke$arity$0 = G__22034__0;
G__22034.cljs$core$IFn$_invoke$arity$1 = G__22034__1;
G__22034.cljs$core$IFn$_invoke$arity$2 = G__22034__2;
return G__22034;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__22035 = null;
var G__22035__0 = (function (){
return xf.call(null);
});
var G__22035__1 = (function (result){
return xf.call(null,result);
});
var G__22035__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,cljs.core.count.call(null,flakes));

return xf.call(null,result,flakes);
});
G__22035 = function(result,flakes){
switch(arguments.length){
case 0:
return G__22035__0.call(this);
case 1:
return G__22035__1.call(this,result);
case 2:
return G__22035__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22035.cljs$core$IFn$_invoke$arity$0 = G__22035__0;
G__22035.cljs$core$IFn$_invoke$arity$1 = G__22035__1;
G__22035.cljs$core$IFn$_invoke$arity$2 = G__22035__2;
return G__22035;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4253__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__22037 = res;
var G__22037__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__22036_SHARP_){
return cljs.core.get.call(null,p1__22036_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__22037):G__22037);
var G__22037__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__22037__$1):G__22037__$1);
var G__22037__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__22037__$2):G__22037__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__22037__$3);
} else {
return G__22037__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__22041 = arguments.length;
switch (G__22041) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_22480){
var state_val_22481 = (state_22480[(1)]);
if((state_val_22481 === (121))){
var inst_22403 = (state_22480[(2)]);
var inst_22404 = fluree.db.util.async.throw_err.call(null,inst_22403);
var inst_22405 = cljs.core.seq.call(null,inst_22404);
var state_22480__$1 = state_22480;
if(inst_22405){
var statearr_22482_22696 = state_22480__$1;
(statearr_22482_22696[(1)] = (122));

} else {
var statearr_22483_22697 = state_22480__$1;
(statearr_22483_22697[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (65))){
var inst_22196 = (state_22480[(7)]);
var inst_22195 = (state_22480[(2)]);
var inst_22196__$1 = fluree.db.util.async.throw_err.call(null,inst_22195);
var inst_22197 = cljs.core.seq.call(null,inst_22196__$1);
var state_22480__$1 = (function (){var statearr_22484 = state_22480;
(statearr_22484[(7)] = inst_22196__$1);

return statearr_22484;
})();
if(inst_22197){
var statearr_22485_22698 = state_22480__$1;
(statearr_22485_22698[(1)] = (66));

} else {
var statearr_22486_22699 = state_22480__$1;
(statearr_22486_22699[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (70))){
var inst_22196 = (state_22480[(7)]);
var inst_22207 = cljs.core.count.call(null,inst_22196);
var inst_22208 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_22207);
var state_22480__$1 = state_22480;
var statearr_22487_22700 = state_22480__$1;
(statearr_22487_22700[(2)] = inst_22208);

(statearr_22487_22700[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (62))){
var inst_22186 = (state_22480[(8)]);
var inst_22189 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22190 = inst_22186.o;
var inst_22191 = [inst_22190];
var inst_22192 = (new cljs.core.PersistentVector(null,1,(5),inst_22189,inst_22191,null));
var inst_22193 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22192);
var state_22480__$1 = state_22480;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22480__$1,(65),inst_22193);
} else {
if((state_val_22481 === (74))){
var inst_22180 = (state_22480[(9)]);
var state_22480__$1 = state_22480;
var statearr_22488_22701 = state_22480__$1;
(statearr_22488_22701[(2)] = inst_22180);

(statearr_22488_22701[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (110))){
var inst_22365 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_22366 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_22365);
var inst_22367 = inst_22366 === true;
var state_22480__$1 = state_22480;
if(cljs.core.truth_(inst_22367)){
var statearr_22489_22702 = state_22480__$1;
(statearr_22489_22702[(1)] = (113));

} else {
var statearr_22490_22703 = state_22480__$1;
(statearr_22490_22703[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (130))){
var inst_22475 = (state_22480[(2)]);
var _ = (function (){var statearr_22491 = state_22480;
(statearr_22491[(4)] = cljs.core.rest.call(null,(state_22480[(4)])));

return statearr_22491;
})();
var state_22480__$1 = state_22480;
var statearr_22492_22704 = state_22480__$1;
(statearr_22492_22704[(2)] = inst_22475);

(statearr_22492_22704[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (128))){
var inst_22450 = (state_22480[(10)]);
var inst_22453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22454 = [acc,inst_22450];
var inst_22455 = (new cljs.core.PersistentVector(null,2,(5),inst_22453,inst_22454,null));
var state_22480__$1 = state_22480;
var statearr_22493_22705 = state_22480__$1;
(statearr_22493_22705[(2)] = inst_22455);

(statearr_22493_22705[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (7))){
var inst_22053 = (state_22480[(11)]);
var state_22480__$1 = state_22480;
var statearr_22494_22706 = state_22480__$1;
(statearr_22494_22706[(2)] = inst_22053);

(statearr_22494_22706[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (59))){
var inst_22444 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22495_22707 = state_22480__$1;
(statearr_22495_22707[(2)] = inst_22444);

(statearr_22495_22707[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (86))){
var inst_22274 = (state_22480[(12)]);
var inst_22274__$1 = (state_22480[(2)]);
var state_22480__$1 = (function (){var statearr_22496 = state_22480;
(statearr_22496[(12)] = inst_22274__$1);

return statearr_22496;
})();
if(cljs.core.truth_(inst_22274__$1)){
var statearr_22497_22708 = state_22480__$1;
(statearr_22497_22708[(1)] = (88));

} else {
var statearr_22498_22709 = state_22480__$1;
(statearr_22498_22709[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (20))){
var inst_22095 = (state_22480[(13)]);
var inst_22082 = (state_22480[(14)]);
var inst_22094 = (state_22480[(15)]);
var inst_22093 = (state_22480[(2)]);
var inst_22094__$1 = cljs.core.__destructure_map.call(null,inst_22082);
var inst_22095__$1 = cljs.core.get.call(null,inst_22094__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22096 = cljs.core.get.call(null,inst_22094__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22097 = cljs.core.get.call(null,inst_22094__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22098 = cljs.core.get.call(null,inst_22094__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22099 = cljs.core.get.call(null,inst_22094__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22100 = cljs.core.get.call(null,inst_22094__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22480__$1 = (function (){var statearr_22499 = state_22480;
(statearr_22499[(13)] = inst_22095__$1);

(statearr_22499[(16)] = inst_22093);

(statearr_22499[(17)] = inst_22096);

(statearr_22499[(18)] = inst_22097);

(statearr_22499[(15)] = inst_22094__$1);

(statearr_22499[(19)] = inst_22099);

(statearr_22499[(20)] = inst_22098);

(statearr_22499[(21)] = inst_22100);

return statearr_22499;
})();
if(cljs.core.truth_(inst_22095__$1)){
var statearr_22500_22710 = state_22480__$1;
(statearr_22500_22710[(1)] = (24));

} else {
var statearr_22501_22711 = state_22480__$1;
(statearr_22501_22711[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (72))){
var inst_22205 = (state_22480[(22)]);
var inst_22211 = (state_22480[(2)]);
var inst_22212 = cljs.core.seq.call(null,inst_22205);
var state_22480__$1 = (function (){var statearr_22502 = state_22480;
(statearr_22502[(23)] = inst_22211);

return statearr_22502;
})();
if(inst_22212){
var statearr_22503_22712 = state_22480__$1;
(statearr_22503_22712[(1)] = (73));

} else {
var statearr_22504_22713 = state_22480__$1;
(statearr_22504_22713[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (58))){
var inst_22082 = (state_22480[(14)]);
var inst_22227 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22082);
var state_22480__$1 = state_22480;
if(cljs.core.truth_(inst_22227)){
var statearr_22505_22714 = state_22480__$1;
(statearr_22505_22714[(1)] = (76));

} else {
var statearr_22506_22715 = state_22480__$1;
(statearr_22506_22715[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (60))){
var inst_22179 = (state_22480[(24)]);
var inst_22186 = (state_22480[(8)]);
var inst_22185 = cljs.core.seq.call(null,inst_22179);
var inst_22186__$1 = cljs.core.first.call(null,inst_22185);
var inst_22187 = cljs.core.next.call(null,inst_22185);
var state_22480__$1 = (function (){var statearr_22507 = state_22480;
(statearr_22507[(25)] = inst_22187);

(statearr_22507[(8)] = inst_22186__$1);

return statearr_22507;
})();
if(cljs.core.truth_(inst_22186__$1)){
var statearr_22508_22716 = state_22480__$1;
(statearr_22508_22716[(1)] = (62));

} else {
var statearr_22509_22717 = state_22480__$1;
(statearr_22509_22717[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (27))){
var inst_22103 = (state_22480[(26)]);
var inst_22099 = (state_22480[(19)]);
var inst_22103__$1 = cljs.core.not_EQ_.call(null,(0),inst_22099);
var state_22480__$1 = (function (){var statearr_22510 = state_22480;
(statearr_22510[(26)] = inst_22103__$1);

return statearr_22510;
})();
if(inst_22103__$1){
var statearr_22511_22718 = state_22480__$1;
(statearr_22511_22718[(1)] = (30));

} else {
var statearr_22512_22719 = state_22480__$1;
(statearr_22512_22719[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (1))){
var state_22480__$1 = state_22480;
var statearr_22513_22720 = state_22480__$1;
(statearr_22513_22720[(2)] = null);

(statearr_22513_22720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (69))){
var inst_22201 = (state_22480[(2)]);
var inst_22202 = fluree.db.util.async.throw_err.call(null,inst_22201);
var state_22480__$1 = state_22480;
var statearr_22514_22721 = state_22480__$1;
(statearr_22514_22721[(2)] = inst_22202);

(statearr_22514_22721[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (101))){
var inst_22358 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22515_22722 = state_22480__$1;
(statearr_22515_22722[(2)] = inst_22358);

(statearr_22515_22722[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (24))){
var inst_22099 = (state_22480[(19)]);
var state_22480__$1 = state_22480;
if(cljs.core.truth_(inst_22099)){
var statearr_22516_22723 = state_22480__$1;
(statearr_22516_22723[(1)] = (27));

} else {
var statearr_22517_22724 = state_22480__$1;
(statearr_22517_22724[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (102))){
var inst_22330 = (state_22480[(27)]);
var inst_22329 = (state_22480[(2)]);
var inst_22330__$1 = fluree.db.util.async.throw_err.call(null,inst_22329);
var inst_22331 = cljs.core.empty_QMARK_.call(null,inst_22330__$1);
var state_22480__$1 = (function (){var statearr_22518 = state_22480;
(statearr_22518[(27)] = inst_22330__$1);

return statearr_22518;
})();
if(inst_22331){
var statearr_22519_22725 = state_22480__$1;
(statearr_22519_22725[(1)] = (103));

} else {
var statearr_22520_22726 = state_22480__$1;
(statearr_22520_22726[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (135))){
var state_22480__$1 = state_22480;
var statearr_22521_22727 = state_22480__$1;
(statearr_22521_22727[(2)] = null);

(statearr_22521_22727[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (55))){
var inst_22082 = (state_22480[(14)]);
var inst_22155 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22082);
var state_22480__$1 = state_22480;
var statearr_22522_22728 = state_22480__$1;
(statearr_22522_22728[(2)] = inst_22155);

(statearr_22522_22728[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (85))){
var inst_22082 = (state_22480[(14)]);
var inst_22249 = (state_22480[(28)]);
var inst_22261 = inst_22249.o;
var inst_22262 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22082);
var inst_22263 = fluree.db.dbproto._tag.call(null,db,inst_22261,inst_22262);
var state_22480__$1 = state_22480;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22480__$1,(87),inst_22263);
} else {
if((state_val_22481 === (39))){
var inst_22130 = (state_22480[(29)]);
var inst_22098 = (state_22480[(20)]);
var inst_22130__$1 = cljs.core.not.call(null,inst_22098);
var state_22480__$1 = (function (){var statearr_22523 = state_22480;
(statearr_22523[(29)] = inst_22130__$1);

return statearr_22523;
})();
if(inst_22130__$1){
var statearr_22524_22729 = state_22480__$1;
(statearr_22524_22729[(1)] = (42));

} else {
var statearr_22525_22730 = state_22480__$1;
(statearr_22525_22730[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (88))){
var inst_22274 = (state_22480[(12)]);
var inst_22243 = (state_22480[(30)]);
var inst_22276 = cljs.core.conj.call(null,inst_22243,inst_22274);
var state_22480__$1 = state_22480;
var statearr_22526_22731 = state_22480__$1;
(statearr_22526_22731[(2)] = inst_22276);

(statearr_22526_22731[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (46))){
var inst_22097 = (state_22480[(18)]);
var state_22480__$1 = state_22480;
var statearr_22527_22732 = state_22480__$1;
(statearr_22527_22732[(2)] = inst_22097);

(statearr_22527_22732[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (4))){
var inst_22042 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22528_22733 = state_22480__$1;
(statearr_22528_22733[(2)] = inst_22042);

(statearr_22528_22733[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (77))){
var inst_22289 = (state_22480[(31)]);
var inst_22289__$1 = componentFollow_QMARK_;
var state_22480__$1 = (function (){var statearr_22529 = state_22480;
(statearr_22529[(31)] = inst_22289__$1);

return statearr_22529;
})();
if(cljs.core.truth_(inst_22289__$1)){
var statearr_22530_22734 = state_22480__$1;
(statearr_22530_22734[(1)] = (91));

} else {
var statearr_22531_22735 = state_22480__$1;
(statearr_22531_22735[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (106))){
var inst_22310 = (state_22480[(32)]);
var inst_22344 = (state_22480[(2)]);
var inst_22345 = fluree.db.util.async.throw_err.call(null,inst_22344);
var inst_22346 = cljs.core.conj.call(null,inst_22310,inst_22345);
var state_22480__$1 = state_22480;
var statearr_22532_22736 = state_22480__$1;
(statearr_22532_22736[(2)] = inst_22346);

(statearr_22532_22736[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (119))){
var inst_22388 = (state_22480[(33)]);
var inst_22418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22419 = [inst_22388,offset_map];
var inst_22420 = (new cljs.core.PersistentVector(null,2,(5),inst_22418,inst_22419,null));
var state_22480__$1 = state_22480;
var statearr_22533_22737 = state_22480__$1;
(statearr_22533_22737[(2)] = inst_22420);

(statearr_22533_22737[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (95))){
var inst_22096 = (state_22480[(17)]);
var state_22480__$1 = state_22480;
if(cljs.core.truth_(inst_22096)){
var statearr_22534_22738 = state_22480__$1;
(statearr_22534_22738[(1)] = (110));

} else {
var statearr_22535_22739 = state_22480__$1;
(statearr_22535_22739[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (54))){
var inst_22152 = (state_22480[(34)]);
var state_22480__$1 = state_22480;
var statearr_22536_22740 = state_22480__$1;
(statearr_22536_22740[(2)] = inst_22152);

(statearr_22536_22740[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (92))){
var inst_22289 = (state_22480[(31)]);
var state_22480__$1 = state_22480;
var statearr_22537_22741 = state_22480__$1;
(statearr_22537_22741[(2)] = inst_22289);

(statearr_22537_22741[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (104))){
var inst_22052 = (state_22480[(35)]);
var inst_22330 = (state_22480[(27)]);
var inst_22339 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_22340 = [true,inst_22052];
var inst_22341 = cljs.core.PersistentHashMap.fromArrays(inst_22339,inst_22340);
var inst_22342 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22341,inst_22330);
var state_22480__$1 = state_22480;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22480__$1,(106),inst_22342);
} else {
if((state_val_22481 === (15))){
var inst_22052 = (state_22480[(35)]);
var inst_22075 = (state_22480[(36)]);
var inst_22079 = cljs.core.assoc.call(null,inst_22075,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22052);
var state_22480__$1 = state_22480;
var statearr_22538_22742 = state_22480__$1;
(statearr_22538_22742[(2)] = inst_22079);

(statearr_22538_22742[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (48))){
var inst_22146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22147 = [null,offset_map];
var inst_22148 = (new cljs.core.PersistentVector(null,2,(5),inst_22146,inst_22147,null));
var state_22480__$1 = state_22480;
var statearr_22539_22743 = state_22480__$1;
(statearr_22539_22743[(2)] = inst_22148);

(statearr_22539_22743[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (50))){
var inst_22446 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22540_22744 = state_22480__$1;
(statearr_22540_22744[(2)] = inst_22446);

(statearr_22540_22744[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (116))){
var inst_22394 = (state_22480[(37)]);
var inst_22387 = (state_22480[(38)]);
var inst_22393 = cljs.core.seq.call(null,inst_22387);
var inst_22394__$1 = cljs.core.first.call(null,inst_22393);
var inst_22395 = cljs.core.next.call(null,inst_22393);
var state_22480__$1 = (function (){var statearr_22541 = state_22480;
(statearr_22541[(37)] = inst_22394__$1);

(statearr_22541[(39)] = inst_22395);

return statearr_22541;
})();
if(cljs.core.truth_(inst_22394__$1)){
var statearr_22542_22745 = state_22480__$1;
(statearr_22542_22745[(1)] = (118));

} else {
var statearr_22543_22746 = state_22480__$1;
(statearr_22543_22746[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (75))){
var inst_22187 = (state_22480[(25)]);
var inst_22217 = (state_22480[(2)]);
var inst_22179 = inst_22187;
var inst_22180 = inst_22217;
var state_22480__$1 = (function (){var statearr_22544 = state_22480;
(statearr_22544[(9)] = inst_22180);

(statearr_22544[(24)] = inst_22179);

return statearr_22544;
})();
var statearr_22545_22747 = state_22480__$1;
(statearr_22545_22747[(2)] = null);

(statearr_22545_22747[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (99))){
var inst_22082 = (state_22480[(14)]);
var inst_22316 = (state_22480[(40)]);
var inst_22319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22320 = inst_22316.o;
var inst_22321 = [inst_22320];
var inst_22322 = (new cljs.core.PersistentVector(null,1,(5),inst_22319,inst_22321,null));
var inst_22323 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22324 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22082);
var inst_22325 = [inst_22324];
var inst_22326 = cljs.core.PersistentHashMap.fromArrays(inst_22323,inst_22325);
var inst_22327 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22322,inst_22326);
var state_22480__$1 = state_22480;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22480__$1,(102),inst_22327);
} else {
if((state_val_22481 === (21))){
var inst_22086 = (state_22480[(41)]);
var state_22480__$1 = state_22480;
var statearr_22546_22748 = state_22480__$1;
(statearr_22546_22748[(2)] = inst_22086);

(statearr_22546_22748[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (31))){
var inst_22103 = (state_22480[(26)]);
var state_22480__$1 = state_22480;
var statearr_22547_22749 = state_22480__$1;
(statearr_22547_22749[(2)] = inst_22103);

(statearr_22547_22749[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (113))){
var inst_22095 = (state_22480[(13)]);
var inst_22082 = (state_22480[(14)]);
var inst_22052 = (state_22480[(35)]);
var inst_22093 = (state_22480[(16)]);
var inst_22096 = (state_22480[(17)]);
var inst_22097 = (state_22480[(18)]);
var inst_22067 = (state_22480[(42)]);
var inst_22094 = (state_22480[(15)]);
var inst_22099 = (state_22480[(19)]);
var inst_22098 = (state_22480[(20)]);
var inst_22100 = (state_22480[(21)]);
var inst_22369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22370 = (function (){var p = inst_22100;
var pred_spec__$1 = inst_22067;
var orderBy = inst_22098;
var multi_QMARK_ = inst_22095;
var limit = inst_22097;
var offset = inst_22099;
var k = inst_22093;
var compact_QMARK_ = inst_22052;
var pred_spec_SINGLEQUOTE_ = inst_22082;
var map__22048 = inst_22094;
var ref_QMARK_ = inst_22096;
return (function (p1__22038_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[p1__22038_SHARP_.o]);
});
})();
var inst_22371 = cljs.core.mapv.call(null,inst_22370,flakes);
var inst_22372 = [inst_22371,offset_map];
var inst_22373 = (new cljs.core.PersistentVector(null,2,(5),inst_22369,inst_22372,null));
var state_22480__$1 = state_22480;
var statearr_22548_22750 = state_22480__$1;
(statearr_22548_22750[(2)] = inst_22373);

(statearr_22548_22750[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (32))){
var inst_22109 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22549_22751 = state_22480__$1;
(statearr_22549_22751[(2)] = inst_22109);

(statearr_22549_22751[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (136))){
var inst_22471 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22550_22752 = state_22480__$1;
(statearr_22550_22752[(2)] = inst_22471);

(statearr_22550_22752[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (40))){
var inst_22095 = (state_22480[(13)]);
var state_22480__$1 = state_22480;
var statearr_22551_22753 = state_22480__$1;
(statearr_22551_22753[(2)] = inst_22095);

(statearr_22551_22753[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (129))){
var inst_22095 = (state_22480[(13)]);
var state_22480__$1 = state_22480;
if(cljs.core.truth_(inst_22095)){
var statearr_22552_22754 = state_22480__$1;
(statearr_22552_22754[(1)] = (131));

} else {
var statearr_22553_22755 = state_22480__$1;
(statearr_22553_22755[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (91))){
var inst_22082 = (state_22480[(14)]);
var inst_22291 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22082);
var state_22480__$1 = state_22480;
var statearr_22554_22756 = state_22480__$1;
(statearr_22554_22756[(2)] = inst_22291);

(statearr_22554_22756[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (117))){
var inst_22424 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22555_22757 = state_22480__$1;
(statearr_22555_22757[(2)] = inst_22424);

(statearr_22555_22757[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (108))){
var state_22480__$1 = state_22480;
var statearr_22556_22758 = state_22480__$1;
(statearr_22556_22758[(2)] = null);

(statearr_22556_22758[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (56))){
var inst_22157 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22557_22759 = state_22480__$1;
(statearr_22557_22759[(2)] = inst_22157);

(statearr_22557_22759[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (33))){
var inst_22100 = (state_22480[(21)]);
var inst_22117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22118 = cljs.core.get.call(null,offset_map,inst_22100);
var state_22480__$1 = (function (){var statearr_22558 = state_22480;
(statearr_22558[(43)] = inst_22117);

return statearr_22558;
})();
if(cljs.core.truth_(inst_22118)){
var statearr_22559_22760 = state_22480__$1;
(statearr_22559_22760[(1)] = (36));

} else {
var statearr_22560_22761 = state_22480__$1;
(statearr_22560_22761[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (13))){
var inst_22067 = (state_22480[(42)]);
var state_22480__$1 = state_22480;
var statearr_22561_22762 = state_22480__$1;
(statearr_22561_22762[(2)] = inst_22067);

(statearr_22561_22762[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (22))){
var inst_22082 = (state_22480[(14)]);
var inst_22089 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22082);
var state_22480__$1 = state_22480;
var statearr_22562_22763 = state_22480__$1;
(statearr_22562_22763[(2)] = inst_22089);

(statearr_22562_22763[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (90))){
var inst_22250 = (state_22480[(44)]);
var inst_22279 = (state_22480[(2)]);
var inst_22242 = inst_22250;
var inst_22243 = inst_22279;
var state_22480__$1 = (function (){var statearr_22563 = state_22480;
(statearr_22563[(30)] = inst_22243);

(statearr_22563[(45)] = inst_22242);

return statearr_22563;
})();
var statearr_22564_22764 = state_22480__$1;
(statearr_22564_22764[(2)] = null);

(statearr_22564_22764[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (109))){
var inst_22348 = (state_22480[(46)]);
var inst_22317 = (state_22480[(47)]);
var inst_22354 = (state_22480[(2)]);
var inst_22309 = inst_22317;
var inst_22310 = inst_22348;
var state_22480__$1 = (function (){var statearr_22565 = state_22480;
(statearr_22565[(48)] = inst_22309);

(statearr_22565[(32)] = inst_22310);

(statearr_22565[(49)] = inst_22354);

return statearr_22565;
})();
var statearr_22566_22765 = state_22480__$1;
(statearr_22566_22765[(2)] = null);

(statearr_22566_22765[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (36))){
var inst_22100 = (state_22480[(21)]);
var inst_22120 = cljs.core.update.call(null,offset_map,inst_22100,cljs.core.dec);
var state_22480__$1 = state_22480;
var statearr_22567_22766 = state_22480__$1;
(statearr_22567_22766[(2)] = inst_22120);

(statearr_22567_22766[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (41))){
var inst_22144 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
if(cljs.core.truth_(inst_22144)){
var statearr_22568_22767 = state_22480__$1;
(statearr_22568_22767[(1)] = (48));

} else {
var statearr_22569_22768 = state_22480__$1;
(statearr_22569_22768[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (118))){
var inst_22394 = (state_22480[(37)]);
var inst_22397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22398 = inst_22394.o;
var inst_22399 = [inst_22398];
var inst_22400 = (new cljs.core.PersistentVector(null,1,(5),inst_22397,inst_22399,null));
var inst_22401 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22400);
var state_22480__$1 = state_22480;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22480__$1,(121),inst_22401);
} else {
if((state_val_22481 === (89))){
var inst_22243 = (state_22480[(30)]);
var state_22480__$1 = state_22480;
var statearr_22570_22769 = state_22480__$1;
(statearr_22570_22769[(2)] = inst_22243);

(statearr_22570_22769[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (100))){
var inst_22310 = (state_22480[(32)]);
var state_22480__$1 = state_22480;
var statearr_22571_22770 = state_22480__$1;
(statearr_22571_22770[(2)] = inst_22310);

(statearr_22571_22770[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (131))){
var inst_22450 = (state_22480[(10)]);
var inst_22093 = (state_22480[(16)]);
var inst_22449 = (state_22480[(50)]);
var inst_22458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22459 = cljs.core.assoc.call(null,acc,inst_22093,inst_22449);
var inst_22460 = [inst_22459,inst_22450];
var inst_22461 = (new cljs.core.PersistentVector(null,2,(5),inst_22458,inst_22460,null));
var state_22480__$1 = state_22480;
var statearr_22572_22771 = state_22480__$1;
(statearr_22572_22771[(2)] = inst_22461);

(statearr_22572_22771[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (122))){
var inst_22394 = (state_22480[(37)]);
var inst_22388 = (state_22480[(33)]);
var inst_22395 = (state_22480[(39)]);
var inst_22407 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22408 = inst_22394.o;
var inst_22409 = [inst_22408];
var inst_22410 = cljs.core.PersistentHashMap.fromArrays(inst_22407,inst_22409);
var inst_22411 = cljs.core.conj.call(null,inst_22388,inst_22410);
var inst_22387 = inst_22395;
var inst_22388__$1 = inst_22411;
var state_22480__$1 = (function (){var statearr_22573 = state_22480;
(statearr_22573[(33)] = inst_22388__$1);

(statearr_22573[(38)] = inst_22387);

return statearr_22573;
})();
var statearr_22574_22772 = state_22480__$1;
(statearr_22574_22772[(2)] = null);

(statearr_22574_22772[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (43))){
var inst_22130 = (state_22480[(29)]);
var state_22480__$1 = state_22480;
var statearr_22575_22773 = state_22480__$1;
(statearr_22575_22773[(2)] = inst_22130);

(statearr_22575_22773[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (61))){
var inst_22166 = (state_22480[(51)]);
var inst_22223 = (state_22480[(2)]);
var inst_22224 = [inst_22223,offset_map];
var inst_22225 = (new cljs.core.PersistentVector(null,2,(5),inst_22166,inst_22224,null));
var state_22480__$1 = state_22480;
var statearr_22576_22774 = state_22480__$1;
(statearr_22576_22774[(2)] = inst_22225);

(statearr_22576_22774[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (29))){
var inst_22112 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22577_22775 = state_22480__$1;
(statearr_22577_22775[(2)] = inst_22112);

(statearr_22577_22775[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (44))){
var inst_22141 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22578_22776 = state_22480__$1;
(statearr_22578_22776[(2)] = inst_22141);

(statearr_22578_22776[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (93))){
var inst_22294 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
if(cljs.core.truth_(inst_22294)){
var statearr_22579_22777 = state_22480__$1;
(statearr_22579_22777[(1)] = (94));

} else {
var statearr_22580_22778 = state_22480__$1;
(statearr_22580_22778[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (6))){
var inst_22055 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22056 = (inst_22055 == null);
var state_22480__$1 = state_22480;
var statearr_22581_22779 = state_22480__$1;
(statearr_22581_22779[(2)] = inst_22056);

(statearr_22581_22779[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (111))){
var state_22480__$1 = state_22480;
var statearr_22582_22780 = state_22480__$1;
(statearr_22582_22780[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (28))){
var inst_22099 = (state_22480[(19)]);
var state_22480__$1 = state_22480;
var statearr_22584_22781 = state_22480__$1;
(statearr_22584_22781[(2)] = inst_22099);

(statearr_22584_22781[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (134))){
var inst_22450 = (state_22480[(10)]);
var inst_22093 = (state_22480[(16)]);
var inst_22449 = (state_22480[(50)]);
var inst_22464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22465 = cljs.core.first.call(null,inst_22449);
var inst_22466 = cljs.core.assoc.call(null,acc,inst_22093,inst_22465);
var inst_22467 = [inst_22466,inst_22450];
var inst_22468 = (new cljs.core.PersistentVector(null,2,(5),inst_22464,inst_22467,null));
var state_22480__$1 = state_22480;
var statearr_22585_22782 = state_22480__$1;
(statearr_22585_22782[(2)] = inst_22468);

(statearr_22585_22782[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (64))){
var inst_22221 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22586_22783 = state_22480__$1;
(statearr_22586_22783[(2)] = inst_22221);

(statearr_22586_22783[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (103))){
var inst_22316 = (state_22480[(40)]);
var inst_22310 = (state_22480[(32)]);
var inst_22333 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22334 = inst_22316.o;
var inst_22335 = [inst_22334];
var inst_22336 = cljs.core.PersistentHashMap.fromArrays(inst_22333,inst_22335);
var inst_22337 = cljs.core.conj.call(null,inst_22310,inst_22336);
var state_22480__$1 = state_22480;
var statearr_22587_22784 = state_22480__$1;
(statearr_22587_22784[(2)] = inst_22337);

(statearr_22587_22784[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (51))){
var inst_22082 = (state_22480[(14)]);
var inst_22152 = (state_22480[(34)]);
var inst_22152__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22082);
var state_22480__$1 = (function (){var statearr_22588 = state_22480;
(statearr_22588[(34)] = inst_22152__$1);

return statearr_22588;
})();
if(cljs.core.truth_(inst_22152__$1)){
var statearr_22589_22785 = state_22480__$1;
(statearr_22589_22785[(1)] = (54));

} else {
var statearr_22590_22786 = state_22480__$1;
(statearr_22590_22786[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (25))){
var inst_22095 = (state_22480[(13)]);
var state_22480__$1 = state_22480;
var statearr_22591_22787 = state_22480__$1;
(statearr_22591_22787[(2)] = inst_22095);

(statearr_22591_22787[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (34))){
var inst_22095 = (state_22480[(13)]);
var state_22480__$1 = state_22480;
if(cljs.core.truth_(inst_22095)){
var statearr_22592_22788 = state_22480__$1;
(statearr_22592_22788[(1)] = (39));

} else {
var statearr_22593_22789 = state_22480__$1;
(statearr_22593_22789[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (125))){
var inst_22095 = (state_22480[(13)]);
var inst_22082 = (state_22480[(14)]);
var inst_22052 = (state_22480[(35)]);
var inst_22093 = (state_22480[(16)]);
var inst_22096 = (state_22480[(17)]);
var inst_22097 = (state_22480[(18)]);
var inst_22067 = (state_22480[(42)]);
var inst_22094 = (state_22480[(15)]);
var inst_22099 = (state_22480[(19)]);
var inst_22098 = (state_22480[(20)]);
var inst_22100 = (state_22480[(21)]);
var inst_22429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22430 = (function (){var p = inst_22100;
var pred_spec__$1 = inst_22067;
var orderBy = inst_22098;
var multi_QMARK_ = inst_22095;
var limit = inst_22097;
var offset = inst_22099;
var k = inst_22093;
var compact_QMARK_ = inst_22052;
var pred_spec_SINGLEQUOTE_ = inst_22082;
var map__22048 = inst_22094;
var ref_QMARK_ = inst_22096;
return (function (p1__22039_SHARP_){
return p1__22039_SHARP_.o;
});
})();
var inst_22431 = cljs.core.mapv.call(null,inst_22430,flakes);
var inst_22432 = [inst_22431,offset_map];
var inst_22433 = (new cljs.core.PersistentVector(null,2,(5),inst_22429,inst_22432,null));
var state_22480__$1 = state_22480;
var statearr_22594_22790 = state_22480__$1;
(statearr_22594_22790[(2)] = inst_22433);

(statearr_22594_22790[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (17))){
var inst_22082 = (state_22480[(14)]);
var inst_22083 = (state_22480[(52)]);
var inst_22082__$1 = (state_22480[(2)]);
var inst_22083__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22082__$1);
var state_22480__$1 = (function (){var statearr_22595 = state_22480;
(statearr_22595[(14)] = inst_22082__$1);

(statearr_22595[(52)] = inst_22083__$1);

return statearr_22595;
})();
if(cljs.core.truth_(inst_22083__$1)){
var statearr_22596_22791 = state_22480__$1;
(statearr_22596_22791[(1)] = (18));

} else {
var statearr_22597_22792 = state_22480__$1;
(statearr_22597_22792[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (3))){
var inst_22478 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22480__$1,inst_22478);
} else {
if((state_val_22481 === (12))){
var inst_22067 = (state_22480[(42)]);
var inst_22072 = cljs.core.assoc.call(null,inst_22067,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22480__$1 = state_22480;
var statearr_22598_22793 = state_22480__$1;
(statearr_22598_22793[(2)] = inst_22072);

(statearr_22598_22793[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (2))){
var inst_22053 = (state_22480[(11)]);
var _ = (function (){var statearr_22599 = state_22480;
(statearr_22599[(4)] = cljs.core.cons.call(null,(5),(state_22480[(4)])));

return statearr_22599;
})();
var inst_22052 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22053__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22480__$1 = (function (){var statearr_22600 = state_22480;
(statearr_22600[(11)] = inst_22053__$1);

(statearr_22600[(35)] = inst_22052);

return statearr_22600;
})();
if(cljs.core.truth_(inst_22053__$1)){
var statearr_22601_22794 = state_22480__$1;
(statearr_22601_22794[(1)] = (6));

} else {
var statearr_22602_22795 = state_22480__$1;
(statearr_22602_22795[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (66))){
var inst_22196 = (state_22480[(7)]);
var inst_22165 = (state_22480[(53)]);
var inst_22199 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22165,inst_22196);
var state_22480__$1 = state_22480;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22480__$1,(69),inst_22199);
} else {
if((state_val_22481 === (107))){
var inst_22330 = (state_22480[(27)]);
var inst_22350 = cljs.core.count.call(null,inst_22330);
var inst_22351 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_22350);
var state_22480__$1 = state_22480;
var statearr_22603_22796 = state_22480__$1;
(statearr_22603_22796[(2)] = inst_22351);

(statearr_22603_22796[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (23))){
var inst_22091 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22604_22797 = state_22480__$1;
(statearr_22604_22797[(2)] = inst_22091);

(statearr_22604_22797[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (47))){
var inst_22138 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22605_22798 = state_22480__$1;
(statearr_22605_22798[(2)] = inst_22138);

(statearr_22605_22798[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (35))){
var inst_22449 = (state_22480[(50)]);
var inst_22448 = (state_22480[(2)]);
var inst_22449__$1 = cljs.core.nth.call(null,inst_22448,(0),null);
var inst_22450 = cljs.core.nth.call(null,inst_22448,(1),null);
var inst_22451 = cljs.core.empty_QMARK_.call(null,inst_22449__$1);
var state_22480__$1 = (function (){var statearr_22606 = state_22480;
(statearr_22606[(10)] = inst_22450);

(statearr_22606[(50)] = inst_22449__$1);

return statearr_22606;
})();
if(inst_22451){
var statearr_22607_22799 = state_22480__$1;
(statearr_22607_22799[(1)] = (128));

} else {
var statearr_22608_22800 = state_22480__$1;
(statearr_22608_22800[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (127))){
var inst_22436 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22609_22801 = state_22480__$1;
(statearr_22609_22801[(2)] = inst_22436);

(statearr_22609_22801[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (82))){
var inst_22243 = (state_22480[(30)]);
var state_22480__$1 = state_22480;
var statearr_22610_22802 = state_22480__$1;
(statearr_22610_22802[(2)] = inst_22243);

(statearr_22610_22802[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (76))){
var inst_22229 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22237 = flakes;
var inst_22238 = cljs.core.seq.call(null,inst_22237);
var inst_22239 = cljs.core.first.call(null,inst_22238);
var inst_22240 = cljs.core.next.call(null,inst_22238);
var inst_22241 = cljs.core.PersistentVector.EMPTY;
var inst_22242 = inst_22237;
var inst_22243 = inst_22241;
var state_22480__$1 = (function (){var statearr_22611 = state_22480;
(statearr_22611[(54)] = inst_22239);

(statearr_22611[(55)] = inst_22229);

(statearr_22611[(56)] = inst_22240);

(statearr_22611[(30)] = inst_22243);

(statearr_22611[(45)] = inst_22242);

return statearr_22611;
})();
var statearr_22612_22803 = state_22480__$1;
(statearr_22612_22803[(2)] = null);

(statearr_22612_22803[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (97))){
var inst_22309 = (state_22480[(48)]);
var inst_22316 = (state_22480[(40)]);
var inst_22315 = cljs.core.seq.call(null,inst_22309);
var inst_22316__$1 = cljs.core.first.call(null,inst_22315);
var inst_22317 = cljs.core.next.call(null,inst_22315);
var state_22480__$1 = (function (){var statearr_22613 = state_22480;
(statearr_22613[(40)] = inst_22316__$1);

(statearr_22613[(47)] = inst_22317);

return statearr_22613;
})();
if(cljs.core.truth_(inst_22316__$1)){
var statearr_22614_22804 = state_22480__$1;
(statearr_22614_22804[(1)] = (99));

} else {
var statearr_22615_22805 = state_22480__$1;
(statearr_22615_22805[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (19))){
var inst_22082 = (state_22480[(14)]);
var inst_22086 = (state_22480[(41)]);
var inst_22086__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22082);
var state_22480__$1 = (function (){var statearr_22616 = state_22480;
(statearr_22616[(41)] = inst_22086__$1);

return statearr_22616;
})();
if(cljs.core.truth_(inst_22086__$1)){
var statearr_22617_22806 = state_22480__$1;
(statearr_22617_22806[(1)] = (21));

} else {
var statearr_22618_22807 = state_22480__$1;
(statearr_22618_22807[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (57))){
var inst_22082 = (state_22480[(14)]);
var inst_22162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22163 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22164 = (new cljs.core.PersistentVector(null,3,(5),inst_22162,inst_22163,null));
var inst_22165 = cljs.core.select_keys.call(null,inst_22082,inst_22164);
var inst_22166 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22174 = flakes;
var inst_22175 = cljs.core.seq.call(null,inst_22174);
var inst_22176 = cljs.core.first.call(null,inst_22175);
var inst_22177 = cljs.core.next.call(null,inst_22175);
var inst_22178 = cljs.core.PersistentVector.EMPTY;
var inst_22179 = inst_22174;
var inst_22180 = inst_22178;
var state_22480__$1 = (function (){var statearr_22619 = state_22480;
(statearr_22619[(9)] = inst_22180);

(statearr_22619[(57)] = inst_22176);

(statearr_22619[(51)] = inst_22166);

(statearr_22619[(24)] = inst_22179);

(statearr_22619[(53)] = inst_22165);

(statearr_22619[(58)] = inst_22177);

return statearr_22619;
})();
var statearr_22620_22808 = state_22480__$1;
(statearr_22620_22808[(2)] = null);

(statearr_22620_22808[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (68))){
var inst_22205 = (state_22480[(2)]);
var state_22480__$1 = (function (){var statearr_22621 = state_22480;
(statearr_22621[(22)] = inst_22205);

return statearr_22621;
})();
if(cljs.core.truth_(fuel)){
var statearr_22622_22809 = state_22480__$1;
(statearr_22622_22809[(1)] = (70));

} else {
var statearr_22623_22810 = state_22480__$1;
(statearr_22623_22810[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (11))){
var inst_22067 = (state_22480[(42)]);
var inst_22067__$1 = (state_22480[(2)]);
var inst_22069 = cljs.core.contains_QMARK_.call(null,inst_22067__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22070 = (!(inst_22069));
var state_22480__$1 = (function (){var statearr_22624 = state_22480;
(statearr_22624[(42)] = inst_22067__$1);

return statearr_22624;
})();
if(inst_22070){
var statearr_22625_22811 = state_22480__$1;
(statearr_22625_22811[(1)] = (12));

} else {
var statearr_22626_22812 = state_22480__$1;
(statearr_22626_22812[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (115))){
var inst_22426 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22628_22813 = state_22480__$1;
(statearr_22628_22813[(2)] = inst_22426);

(statearr_22628_22813[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (9))){
var inst_22061 = cljs.core.first.call(null,flakes);
var inst_22062 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22061);
var inst_22063 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22064 = fluree.db.query.fql.wildcard_pred_spec.call(null,db,cache,inst_22062,inst_22063);
var state_22480__$1 = state_22480;
var statearr_22629_22814 = state_22480__$1;
(statearr_22629_22814[(2)] = inst_22064);

(statearr_22629_22814[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (5))){
var _ = (function (){var statearr_22630 = state_22480;
(statearr_22630[(4)] = cljs.core.rest.call(null,(state_22480[(4)])));

return statearr_22630;
})();
var state_22480__$1 = state_22480;
var ex22627 = (state_22480__$1[(2)]);
var statearr_22631_22815 = state_22480__$1;
(statearr_22631_22815[(5)] = ex22627);


if((ex22627 instanceof Error)){
var statearr_22632_22816 = state_22480__$1;
(statearr_22632_22816[(1)] = (4));

(statearr_22632_22816[(5)] = null);

} else {
throw ex22627;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (112))){
var inst_22438 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22633_22817 = state_22480__$1;
(statearr_22633_22817[(2)] = inst_22438);

(statearr_22633_22817[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (83))){
var inst_22283 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22634_22818 = state_22480__$1;
(statearr_22634_22818[(2)] = inst_22283);

(statearr_22634_22818[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (14))){
var inst_22067 = (state_22480[(42)]);
var inst_22075 = (state_22480[(2)]);
var inst_22076 = cljs.core.contains_QMARK_.call(null,inst_22067,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22077 = (!(inst_22076));
var state_22480__$1 = (function (){var statearr_22635 = state_22480;
(statearr_22635[(36)] = inst_22075);

return statearr_22635;
})();
if(inst_22077){
var statearr_22636_22819 = state_22480__$1;
(statearr_22636_22819[(1)] = (15));

} else {
var statearr_22637_22820 = state_22480__$1;
(statearr_22637_22820[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (45))){
var inst_22093 = (state_22480[(16)]);
var inst_22097 = (state_22480[(18)]);
var inst_22133 = cljs.core.get.call(null,acc,inst_22093);
var inst_22134 = cljs.core.count.call(null,inst_22133);
var inst_22135 = (inst_22134 >= inst_22097);
var state_22480__$1 = state_22480;
var statearr_22638_22821 = state_22480__$1;
(statearr_22638_22821[(2)] = inst_22135);

(statearr_22638_22821[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (53))){
var inst_22160 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
if(cljs.core.truth_(inst_22160)){
var statearr_22639_22822 = state_22480__$1;
(statearr_22639_22822[(1)] = (57));

} else {
var statearr_22640_22823 = state_22480__$1;
(statearr_22640_22823[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (78))){
var inst_22442 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22641_22824 = state_22480__$1;
(statearr_22641_22824[(2)] = inst_22442);

(statearr_22641_22824[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (132))){
var state_22480__$1 = state_22480;
var statearr_22643_22825 = state_22480__$1;
(statearr_22643_22825[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (26))){
var inst_22115 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
if(cljs.core.truth_(inst_22115)){
var statearr_22645_22826 = state_22480__$1;
(statearr_22645_22826[(1)] = (33));

} else {
var statearr_22646_22827 = state_22480__$1;
(statearr_22646_22827[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (123))){
var inst_22388 = (state_22480[(33)]);
var inst_22395 = (state_22480[(39)]);
var tmp22642 = inst_22388;
var inst_22387 = inst_22395;
var inst_22388__$1 = tmp22642;
var state_22480__$1 = (function (){var statearr_22647 = state_22480;
(statearr_22647[(33)] = inst_22388__$1);

(statearr_22647[(38)] = inst_22387);

return statearr_22647;
})();
var statearr_22648_22828 = state_22480__$1;
(statearr_22648_22828[(2)] = null);

(statearr_22648_22828[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (16))){
var inst_22075 = (state_22480[(36)]);
var state_22480__$1 = state_22480;
var statearr_22649_22829 = state_22480__$1;
(statearr_22649_22829[(2)] = inst_22075);

(statearr_22649_22829[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (133))){
var inst_22473 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22650_22830 = state_22480__$1;
(statearr_22650_22830[(2)] = inst_22473);

(statearr_22650_22830[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (81))){
var inst_22082 = (state_22480[(14)]);
var inst_22249 = (state_22480[(28)]);
var inst_22258 = (state_22480[(59)]);
var inst_22252 = cljs.core.deref.call(null,cache);
var inst_22253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22254 = inst_22249.o;
var inst_22255 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22082);
var inst_22256 = [inst_22254,inst_22255];
var inst_22257 = (new cljs.core.PersistentVector(null,2,(5),inst_22253,inst_22256,null));
var inst_22258__$1 = cljs.core.get.call(null,inst_22252,inst_22257);
var state_22480__$1 = (function (){var statearr_22651 = state_22480;
(statearr_22651[(59)] = inst_22258__$1);

return statearr_22651;
})();
if(cljs.core.truth_(inst_22258__$1)){
var statearr_22652_22831 = state_22480__$1;
(statearr_22652_22831[(1)] = (84));

} else {
var statearr_22653_22832 = state_22480__$1;
(statearr_22653_22832[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (120))){
var inst_22422 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22654_22833 = state_22480__$1;
(statearr_22654_22833[(2)] = inst_22422);

(statearr_22654_22833[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (79))){
var inst_22249 = (state_22480[(28)]);
var inst_22242 = (state_22480[(45)]);
var inst_22248 = cljs.core.seq.call(null,inst_22242);
var inst_22249__$1 = cljs.core.first.call(null,inst_22248);
var inst_22250 = cljs.core.next.call(null,inst_22248);
var state_22480__$1 = (function (){var statearr_22655 = state_22480;
(statearr_22655[(44)] = inst_22250);

(statearr_22655[(28)] = inst_22249__$1);

return statearr_22655;
})();
if(cljs.core.truth_(inst_22249__$1)){
var statearr_22656_22834 = state_22480__$1;
(statearr_22656_22834[(1)] = (81));

} else {
var statearr_22657_22835 = state_22480__$1;
(statearr_22657_22835[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (38))){
var inst_22117 = (state_22480[(43)]);
var inst_22125 = (state_22480[(2)]);
var inst_22126 = [null,inst_22125];
var inst_22127 = (new cljs.core.PersistentVector(null,2,(5),inst_22117,inst_22126,null));
var state_22480__$1 = state_22480;
var statearr_22658_22836 = state_22480__$1;
(statearr_22658_22836[(2)] = inst_22127);

(statearr_22658_22836[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (126))){
var state_22480__$1 = state_22480;
var statearr_22659_22837 = state_22480__$1;
(statearr_22659_22837[(2)] = null);

(statearr_22659_22837[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (98))){
var inst_22296 = (state_22480[(60)]);
var inst_22360 = (state_22480[(2)]);
var inst_22361 = [inst_22360,offset_map];
var inst_22362 = (new cljs.core.PersistentVector(null,2,(5),inst_22296,inst_22361,null));
var state_22480__$1 = state_22480;
var statearr_22660_22838 = state_22480__$1;
(statearr_22660_22838[(2)] = inst_22362);

(statearr_22660_22838[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (124))){
var inst_22416 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22661_22839 = state_22480__$1;
(statearr_22661_22839[(2)] = inst_22416);

(statearr_22661_22839[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (87))){
var inst_22082 = (state_22480[(14)]);
var inst_22249 = (state_22480[(28)]);
var inst_22265 = (state_22480[(2)]);
var inst_22266 = fluree.db.util.async.throw_err.call(null,inst_22265);
var inst_22267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22268 = inst_22249.o;
var inst_22269 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22082);
var inst_22270 = [inst_22268,inst_22269];
var inst_22271 = (new cljs.core.PersistentVector(null,2,(5),inst_22267,inst_22270,null));
var inst_22272 = fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc,inst_22271,inst_22266);
var state_22480__$1 = (function (){var statearr_22662 = state_22480;
(statearr_22662[(61)] = inst_22272);

return statearr_22662;
})();
var statearr_22663_22840 = state_22480__$1;
(statearr_22663_22840[(2)] = inst_22266);

(statearr_22663_22840[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (30))){
var inst_22100 = (state_22480[(21)]);
var inst_22105 = cljs.core.get.call(null,offset_map,inst_22100);
var inst_22106 = cljs.core.not_EQ_.call(null,(0),inst_22105);
var state_22480__$1 = state_22480;
var statearr_22664_22841 = state_22480__$1;
(statearr_22664_22841[(2)] = inst_22106);

(statearr_22664_22841[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (73))){
var inst_22180 = (state_22480[(9)]);
var inst_22205 = (state_22480[(22)]);
var inst_22214 = cljs.core.conj.call(null,inst_22180,inst_22205);
var state_22480__$1 = state_22480;
var statearr_22665_22842 = state_22480__$1;
(statearr_22665_22842[(2)] = inst_22214);

(statearr_22665_22842[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (96))){
var inst_22440 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
var statearr_22666_22843 = state_22480__$1;
(statearr_22666_22843[(2)] = inst_22440);

(statearr_22666_22843[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (10))){
var state_22480__$1 = state_22480;
var statearr_22667_22844 = state_22480__$1;
(statearr_22667_22844[(2)] = pred_spec);

(statearr_22667_22844[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (18))){
var inst_22083 = (state_22480[(52)]);
var state_22480__$1 = state_22480;
var statearr_22668_22845 = state_22480__$1;
(statearr_22668_22845[(2)] = inst_22083);

(statearr_22668_22845[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (105))){
var inst_22348 = (state_22480[(2)]);
var state_22480__$1 = (function (){var statearr_22669 = state_22480;
(statearr_22669[(46)] = inst_22348);

return statearr_22669;
})();
if(cljs.core.truth_(fuel)){
var statearr_22670_22846 = state_22480__$1;
(statearr_22670_22846[(1)] = (107));

} else {
var statearr_22671_22847 = state_22480__$1;
(statearr_22671_22847[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (52))){
var inst_22150 = (state_22480[(62)]);
var state_22480__$1 = state_22480;
var statearr_22672_22848 = state_22480__$1;
(statearr_22672_22848[(2)] = inst_22150);

(statearr_22672_22848[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (114))){
var inst_22382 = flakes;
var inst_22383 = cljs.core.seq.call(null,inst_22382);
var inst_22384 = cljs.core.first.call(null,inst_22383);
var inst_22385 = cljs.core.next.call(null,inst_22383);
var inst_22386 = cljs.core.PersistentVector.EMPTY;
var inst_22387 = inst_22382;
var inst_22388 = inst_22386;
var state_22480__$1 = (function (){var statearr_22673 = state_22480;
(statearr_22673[(33)] = inst_22388);

(statearr_22673[(63)] = inst_22384);

(statearr_22673[(38)] = inst_22387);

(statearr_22673[(64)] = inst_22385);

return statearr_22673;
})();
var statearr_22674_22849 = state_22480__$1;
(statearr_22674_22849[(2)] = null);

(statearr_22674_22849[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (67))){
var state_22480__$1 = state_22480;
var statearr_22675_22850 = state_22480__$1;
(statearr_22675_22850[(2)] = null);

(statearr_22675_22850[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (71))){
var state_22480__$1 = state_22480;
var statearr_22676_22851 = state_22480__$1;
(statearr_22676_22851[(2)] = null);

(statearr_22676_22851[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (42))){
var inst_22097 = (state_22480[(18)]);
var state_22480__$1 = state_22480;
if(cljs.core.truth_(inst_22097)){
var statearr_22677_22852 = state_22480__$1;
(statearr_22677_22852[(1)] = (45));

} else {
var statearr_22678_22853 = state_22480__$1;
(statearr_22678_22853[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (80))){
var inst_22229 = (state_22480[(55)]);
var inst_22285 = (state_22480[(2)]);
var inst_22286 = [inst_22285,offset_map];
var inst_22287 = (new cljs.core.PersistentVector(null,2,(5),inst_22229,inst_22286,null));
var state_22480__$1 = state_22480;
var statearr_22679_22854 = state_22480__$1;
(statearr_22679_22854[(2)] = inst_22287);

(statearr_22679_22854[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (37))){
var inst_22099 = (state_22480[(19)]);
var inst_22100 = (state_22480[(21)]);
var inst_22122 = (inst_22099 - (1));
var inst_22123 = cljs.core.assoc.call(null,offset_map,inst_22100,inst_22122);
var state_22480__$1 = state_22480;
var statearr_22680_22855 = state_22480__$1;
(statearr_22680_22855[(2)] = inst_22123);

(statearr_22680_22855[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (63))){
var inst_22180 = (state_22480[(9)]);
var state_22480__$1 = state_22480;
var statearr_22681_22856 = state_22480__$1;
(statearr_22681_22856[(2)] = inst_22180);

(statearr_22681_22856[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (94))){
var inst_22296 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22304 = flakes;
var inst_22305 = cljs.core.seq.call(null,inst_22304);
var inst_22306 = cljs.core.first.call(null,inst_22305);
var inst_22307 = cljs.core.next.call(null,inst_22305);
var inst_22308 = cljs.core.PersistentVector.EMPTY;
var inst_22309 = inst_22304;
var inst_22310 = inst_22308;
var state_22480__$1 = (function (){var statearr_22682 = state_22480;
(statearr_22682[(48)] = inst_22309);

(statearr_22682[(32)] = inst_22310);

(statearr_22682[(60)] = inst_22296);

(statearr_22682[(65)] = inst_22307);

(statearr_22682[(66)] = inst_22306);

return statearr_22682;
})();
var statearr_22683_22857 = state_22480__$1;
(statearr_22683_22857[(2)] = null);

(statearr_22683_22857[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (8))){
var inst_22059 = (state_22480[(2)]);
var state_22480__$1 = state_22480;
if(cljs.core.truth_(inst_22059)){
var statearr_22684_22858 = state_22480__$1;
(statearr_22684_22858[(1)] = (9));

} else {
var statearr_22685_22859 = state_22480__$1;
(statearr_22685_22859[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (49))){
var inst_22150 = (state_22480[(62)]);
var inst_22150__$1 = cljs.core.not.call(null,recur_QMARK_);
var state_22480__$1 = (function (){var statearr_22686 = state_22480;
(statearr_22686[(62)] = inst_22150__$1);

return statearr_22686;
})();
if(inst_22150__$1){
var statearr_22687_22860 = state_22480__$1;
(statearr_22687_22860[(1)] = (51));

} else {
var statearr_22688_22861 = state_22480__$1;
(statearr_22688_22861[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22481 === (84))){
var inst_22258 = (state_22480[(59)]);
var state_22480__$1 = state_22480;
var statearr_22689_22862 = state_22480__$1;
(statearr_22689_22862[(2)] = inst_22258);

(statearr_22689_22862[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2746__auto__ = null;
var fluree$db$query$fql$state_machine__2746__auto____0 = (function (){
var statearr_22690 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22690[(0)] = fluree$db$query$fql$state_machine__2746__auto__);

(statearr_22690[(1)] = (1));

return statearr_22690;
});
var fluree$db$query$fql$state_machine__2746__auto____1 = (function (state_22480){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_22480);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22691){var ex__2749__auto__ = e22691;
var statearr_22692_22863 = state_22480;
(statearr_22692_22863[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_22480[(4)]))){
var statearr_22693_22864 = state_22480;
(statearr_22693_22864[(1)] = cljs.core.first.call(null,(state_22480[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22865 = state_22480;
state_22480 = G__22865;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2746__auto__ = function(state_22480){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2746__auto____1.call(this,state_22480);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2746__auto____0;
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2746__auto____1;
return fluree$db$query$fql$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22694 = f__2769__auto__.call(null);
(statearr_22694[(6)] = c__2768__auto__);

return statearr_22694;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__4253__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23025){
var state_val_23026 = (state_23025[(1)]);
if((state_val_23026 === (7))){
var inst_23020 = (state_23025[(2)]);
var _ = (function (){var statearr_23027 = state_23025;
(statearr_23027[(4)] = cljs.core.rest.call(null,(state_23025[(4)])));

return statearr_23027;
})();
var state_23025__$1 = state_23025;
var statearr_23028_23110 = state_23025__$1;
(statearr_23028_23110[(2)] = inst_23020);

(statearr_23028_23110[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (20))){
var inst_22947 = (state_23025[(7)]);
var state_23025__$1 = state_23025;
var statearr_23029_23111 = state_23025__$1;
(statearr_23029_23111[(2)] = inst_22947);

(statearr_23029_23111[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (27))){
var inst_22902 = (state_23025[(8)]);
var state_23025__$1 = state_23025;
if(cljs.core.truth_(inst_22902)){
var statearr_23030_23112 = state_23025__$1;
(statearr_23030_23112[(1)] = (29));

} else {
var statearr_23031_23113 = state_23025__$1;
(statearr_23031_23113[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (1))){
var state_23025__$1 = state_23025;
var statearr_23032_23114 = state_23025__$1;
(statearr_23032_23114[(2)] = null);

(statearr_23032_23114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (24))){
var inst_22903 = (state_23025[(9)]);
var state_23025__$1 = state_23025;
var statearr_23033_23115 = state_23025__$1;
(statearr_23033_23115[(2)] = inst_22903);

(statearr_23033_23115[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (39))){
var inst_22939 = (state_23025[(10)]);
var state_23025__$1 = state_23025;
var statearr_23034_23116 = state_23025__$1;
(statearr_23034_23116[(2)] = inst_22939);

(statearr_23034_23116[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (46))){
var inst_22904 = (state_23025[(11)]);
var state_23025__$1 = state_23025;
var statearr_23035_23117 = state_23025__$1;
(statearr_23035_23117[(2)] = inst_22904);

(statearr_23035_23117[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (4))){
var inst_22866 = (state_23025[(2)]);
var state_23025__$1 = state_23025;
var statearr_23036_23118 = state_23025__$1;
(statearr_23036_23118[(2)] = inst_22866);

(statearr_23036_23118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (15))){
var inst_22915 = (state_23025[(12)]);
var inst_22921 = cljs.core.count.call(null,inst_22915);
var inst_22922 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_22921,max_fuel);
var state_23025__$1 = state_23025;
var statearr_23037_23119 = state_23025__$1;
(statearr_23037_23119[(2)] = inst_22922);

(statearr_23037_23119[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (48))){
var inst_22884 = (state_23025[(13)]);
var inst_22891 = (state_23025[(14)]);
var inst_23006 = (state_23025[(15)]);
var inst_23014 = (state_23025[(2)]);
var inst_23015 = cljs.core.assoc.call(null,inst_22884,inst_23014,inst_23006);
var inst_22883 = inst_22891;
var inst_22884__$1 = inst_23015;
var state_23025__$1 = (function (){var statearr_23038 = state_23025;
(statearr_23038[(13)] = inst_22884__$1);

(statearr_23038[(16)] = inst_22883);

return statearr_23038;
})();
var statearr_23039_23120 = state_23025__$1;
(statearr_23039_23120[(2)] = null);

(statearr_23039_23120[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (50))){
var inst_22906 = (state_23025[(17)]);
var state_23025__$1 = state_23025;
var statearr_23040_23121 = state_23025__$1;
(statearr_23040_23121[(2)] = inst_22906);

(statearr_23040_23121[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (21))){
var inst_22903 = (state_23025[(9)]);
var state_23025__$1 = state_23025;
if(cljs.core.truth_(inst_22903)){
var statearr_23042_23122 = state_23025__$1;
(statearr_23042_23122[(1)] = (23));

} else {
var statearr_23043_23123 = state_23025__$1;
(statearr_23043_23123[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (31))){
var inst_22963 = (state_23025[(2)]);
var state_23025__$1 = state_23025;
if(cljs.core.truth_(inst_22963)){
var statearr_23044_23124 = state_23025__$1;
(statearr_23044_23124[(1)] = (32));

} else {
var statearr_23045_23125 = state_23025__$1;
(statearr_23045_23125[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (32))){
var inst_22939 = (state_23025[(10)]);
var inst_22938 = (state_23025[(18)]);
var inst_22946 = (state_23025[(19)]);
var inst_22965 = (inst_22938 + (1));
var tmp23041 = inst_22939;
var inst_22937 = inst_22946;
var inst_22938__$1 = inst_22965;
var inst_22939__$1 = tmp23041;
var state_23025__$1 = (function (){var statearr_23046 = state_23025;
(statearr_23046[(10)] = inst_22939__$1);

(statearr_23046[(20)] = inst_22937);

(statearr_23046[(18)] = inst_22938__$1);

return statearr_23046;
})();
var statearr_23047_23126 = state_23025__$1;
(statearr_23047_23126[(2)] = null);

(statearr_23047_23126[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (40))){
var state_23025__$1 = state_23025;
if(cljs.core.truth_(fuel)){
var statearr_23048_23127 = state_23025__$1;
(statearr_23048_23127[(1)] = (42));

} else {
var statearr_23049_23128 = state_23025__$1;
(statearr_23049_23128[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (33))){
var state_23025__$1 = state_23025;
var statearr_23050_23129 = state_23025__$1;
(statearr_23050_23129[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (13))){
var inst_22915 = (state_23025[(12)]);
var state_23025__$1 = state_23025;
var statearr_23052_23130 = state_23025__$1;
(statearr_23052_23130[(2)] = inst_22915);

(statearr_23052_23130[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (22))){
var inst_22956 = (state_23025[(2)]);
var state_23025__$1 = state_23025;
if(cljs.core.truth_(inst_22956)){
var statearr_23053_23131 = state_23025__$1;
(statearr_23053_23131[(1)] = (26));

} else {
var statearr_23054_23132 = state_23025__$1;
(statearr_23054_23132[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (36))){
var state_23025__$1 = state_23025;
var statearr_23055_23133 = state_23025__$1;
(statearr_23055_23133[(2)] = null);

(statearr_23055_23133[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (41))){
var inst_22938 = (state_23025[(18)]);
var inst_22946 = (state_23025[(19)]);
var inst_22995 = (state_23025[(2)]);
var inst_22996 = (inst_22938 + (1));
var inst_22937 = inst_22946;
var inst_22938__$1 = inst_22996;
var inst_22939 = inst_22995;
var state_23025__$1 = (function (){var statearr_23056 = state_23025;
(statearr_23056[(10)] = inst_22939);

(statearr_23056[(20)] = inst_22937);

(statearr_23056[(18)] = inst_22938__$1);

return statearr_23056;
})();
var statearr_23057_23134 = state_23025__$1;
(statearr_23057_23134[(2)] = null);

(statearr_23057_23134[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (43))){
var state_23025__$1 = state_23025;
var statearr_23058_23135 = state_23025__$1;
(statearr_23058_23135[(2)] = null);

(statearr_23058_23135[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (29))){
var inst_22902 = (state_23025[(8)]);
var inst_22938 = (state_23025[(18)]);
var inst_22960 = (inst_22938 < inst_22902);
var state_23025__$1 = state_23025;
var statearr_23059_23136 = state_23025__$1;
(statearr_23059_23136[(2)] = inst_22960);

(statearr_23059_23136[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (44))){
var inst_22979 = (state_23025[(21)]);
var inst_22975 = (state_23025[(22)]);
var inst_22988 = (state_23025[(2)]);
var inst_22989 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22979,inst_22975);
var state_23025__$1 = (function (){var statearr_23060 = state_23025;
(statearr_23060[(23)] = inst_22988);

return statearr_23060;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23025__$1,(45),inst_22989);
} else {
if((state_val_23026 === (6))){
var inst_22883 = (state_23025[(16)]);
var inst_22890 = (state_23025[(24)]);
var inst_22889 = cljs.core.seq.call(null,inst_22883);
var inst_22890__$1 = cljs.core.first.call(null,inst_22889);
var inst_22891 = cljs.core.next.call(null,inst_22889);
var inst_22892 = cljs.core.not.call(null,inst_22890__$1);
var state_23025__$1 = (function (){var statearr_23061 = state_23025;
(statearr_23061[(14)] = inst_22891);

(statearr_23061[(24)] = inst_22890__$1);

return statearr_23061;
})();
if(inst_22892){
var statearr_23062_23137 = state_23025__$1;
(statearr_23062_23137[(1)] = (8));

} else {
var statearr_23063_23138 = state_23025__$1;
(statearr_23063_23138[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (28))){
var inst_23004 = (state_23025[(2)]);
var state_23025__$1 = state_23025;
var statearr_23064_23139 = state_23025__$1;
(statearr_23064_23139[(2)] = inst_23004);

(statearr_23064_23139[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (51))){
var inst_23012 = (state_23025[(2)]);
var state_23025__$1 = state_23025;
var statearr_23065_23140 = state_23025__$1;
(statearr_23065_23140[(2)] = inst_23012);

(statearr_23065_23140[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (25))){
var inst_22954 = (state_23025[(2)]);
var state_23025__$1 = state_23025;
var statearr_23066_23141 = state_23025__$1;
(statearr_23066_23141[(2)] = inst_22954);

(statearr_23066_23141[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (34))){
var inst_23002 = (state_23025[(2)]);
var state_23025__$1 = state_23025;
var statearr_23067_23142 = state_23025__$1;
(statearr_23067_23142[(2)] = inst_23002);

(statearr_23067_23142[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (17))){
var inst_22915 = (state_23025[(12)]);
var inst_22925 = (state_23025[(2)]);
var inst_22933 = cljs.core.seq.call(null,inst_22915);
var inst_22934 = cljs.core.first.call(null,inst_22933);
var inst_22935 = cljs.core.next.call(null,inst_22933);
var inst_22936 = cljs.core.PersistentVector.EMPTY;
var inst_22937 = inst_22915;
var inst_22938 = (0);
var inst_22939 = inst_22936;
var state_23025__$1 = (function (){var statearr_23068 = state_23025;
(statearr_23068[(10)] = inst_22939);

(statearr_23068[(25)] = inst_22934);

(statearr_23068[(26)] = inst_22925);

(statearr_23068[(20)] = inst_22937);

(statearr_23068[(27)] = inst_22935);

(statearr_23068[(18)] = inst_22938);

return statearr_23068;
})();
var statearr_23069_23143 = state_23025__$1;
(statearr_23069_23143[(2)] = null);

(statearr_23069_23143[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (3))){
var inst_23023 = (state_23025[(2)]);
var state_23025__$1 = state_23025;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23025__$1,inst_23023);
} else {
if((state_val_23026 === (12))){
var state_23025__$1 = state_23025;
var statearr_23070_23144 = state_23025__$1;
(statearr_23070_23144[(2)] = fuel);

(statearr_23070_23144[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (2))){
var _ = (function (){var statearr_23071 = state_23025;
(statearr_23071[(4)] = cljs.core.cons.call(null,(5),(state_23025[(4)])));

return statearr_23071;
})();
var inst_22879 = reverse_refs_specs;
var inst_22880 = cljs.core.seq.call(null,inst_22879);
var inst_22881 = cljs.core.first.call(null,inst_22880);
var inst_22882 = cljs.core.next.call(null,inst_22880);
var inst_22883 = inst_22879;
var inst_22884 = null;
var state_23025__$1 = (function (){var statearr_23072 = state_23025;
(statearr_23072[(28)] = inst_22881);

(statearr_23072[(29)] = inst_22882);

(statearr_23072[(13)] = inst_22884);

(statearr_23072[(16)] = inst_22883);

return statearr_23072;
})();
var statearr_23073_23145 = state_23025__$1;
(statearr_23073_23145[(2)] = null);

(statearr_23073_23145[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (23))){
var inst_22903 = (state_23025[(9)]);
var inst_22938 = (state_23025[(18)]);
var inst_22951 = (inst_22938 >= inst_22903);
var state_23025__$1 = state_23025;
var statearr_23074_23146 = state_23025__$1;
(statearr_23074_23146[(2)] = inst_22951);

(statearr_23074_23146[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (47))){
var inst_22905 = (state_23025[(30)]);
var state_23025__$1 = state_23025;
if(cljs.core.truth_(inst_22905)){
var statearr_23075_23147 = state_23025__$1;
(statearr_23075_23147[(1)] = (49));

} else {
var statearr_23076_23148 = state_23025__$1;
(statearr_23076_23148[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (35))){
var inst_22945 = (state_23025[(31)]);
var inst_22969 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22970 = [inst_22945];
var inst_22971 = (new cljs.core.PersistentVector(null,1,(5),inst_22969,inst_22970,null));
var inst_22972 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22971);
var state_23025__$1 = state_23025;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23025__$1,(38),inst_22972);
} else {
if((state_val_23026 === (19))){
var inst_22904 = (state_23025[(11)]);
var inst_23006 = (state_23025[(2)]);
var state_23025__$1 = (function (){var statearr_23077 = state_23025;
(statearr_23077[(15)] = inst_23006);

return statearr_23077;
})();
if(cljs.core.truth_(inst_22904)){
var statearr_23078_23149 = state_23025__$1;
(statearr_23078_23149[(1)] = (46));

} else {
var statearr_23079_23150 = state_23025__$1;
(statearr_23079_23150[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (11))){
var inst_22915 = (state_23025[(12)]);
var inst_22912 = (state_23025[(2)]);
var inst_22913 = fluree.db.util.async.throw_err.call(null,inst_22912);
var inst_22914 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_22913);
var inst_22915__$1 = cljs.core.not_empty.call(null,inst_22914);
var state_23025__$1 = (function (){var statearr_23081 = state_23025;
(statearr_23081[(12)] = inst_22915__$1);

return statearr_23081;
})();
if(cljs.core.truth_(inst_22915__$1)){
var statearr_23082_23151 = state_23025__$1;
(statearr_23082_23151[(1)] = (12));

} else {
var statearr_23083_23152 = state_23025__$1;
(statearr_23083_23152[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (9))){
var inst_22900 = (state_23025[(32)]);
var inst_22890 = (state_23025[(24)]);
var inst_22899 = cljs.core.nth.call(null,inst_22890,(0),null);
var inst_22900__$1 = cljs.core.nth.call(null,inst_22890,(1),null);
var inst_22901 = cljs.core.__destructure_map.call(null,inst_22900__$1);
var inst_22902 = cljs.core.get.call(null,inst_22901,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22903 = cljs.core.get.call(null,inst_22901,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22904 = cljs.core.get.call(null,inst_22901,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22905 = cljs.core.get.call(null,inst_22901,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_22906 = cljs.core.get.call(null,inst_22901,new cljs.core.Keyword(null,"p","p",151049309));
var inst_22907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22908 = [subject_id,inst_22899];
var inst_22909 = (new cljs.core.PersistentVector(null,2,(5),inst_22907,inst_22908,null));
var inst_22910 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_22909);
var state_23025__$1 = (function (){var statearr_23084 = state_23025;
(statearr_23084[(9)] = inst_22903);

(statearr_23084[(32)] = inst_22900__$1);

(statearr_23084[(30)] = inst_22905);

(statearr_23084[(8)] = inst_22902);

(statearr_23084[(11)] = inst_22904);

(statearr_23084[(17)] = inst_22906);

return statearr_23084;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23025__$1,(11),inst_22910);
} else {
if((state_val_23026 === (5))){
var _ = (function (){var statearr_23085 = state_23025;
(statearr_23085[(4)] = cljs.core.rest.call(null,(state_23025[(4)])));

return statearr_23085;
})();
var state_23025__$1 = state_23025;
var ex23080 = (state_23025__$1[(2)]);
var statearr_23086_23153 = state_23025__$1;
(statearr_23086_23153[(5)] = ex23080);


if((ex23080 instanceof Error)){
var statearr_23087_23154 = state_23025__$1;
(statearr_23087_23154[(1)] = (4));

(statearr_23087_23154[(5)] = null);

} else {
throw ex23080;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (14))){
var inst_22919 = (state_23025[(2)]);
var state_23025__$1 = state_23025;
if(cljs.core.truth_(inst_22919)){
var statearr_23088_23155 = state_23025__$1;
(statearr_23088_23155[(1)] = (15));

} else {
var statearr_23089_23156 = state_23025__$1;
(statearr_23089_23156[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (45))){
var inst_22939 = (state_23025[(10)]);
var inst_22991 = (state_23025[(2)]);
var inst_22992 = fluree.db.util.async.throw_err.call(null,inst_22991);
var inst_22993 = cljs.core.conj.call(null,inst_22939,inst_22992);
var state_23025__$1 = state_23025;
var statearr_23090_23157 = state_23025__$1;
(statearr_23090_23157[(2)] = inst_22993);

(statearr_23090_23157[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (26))){
var inst_22939 = (state_23025[(10)]);
var state_23025__$1 = state_23025;
var statearr_23091_23158 = state_23025__$1;
(statearr_23091_23158[(2)] = inst_22939);

(statearr_23091_23158[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (16))){
var state_23025__$1 = state_23025;
var statearr_23092_23159 = state_23025__$1;
(statearr_23092_23159[(2)] = null);

(statearr_23092_23159[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (38))){
var inst_22900 = (state_23025[(32)]);
var inst_22975 = (state_23025[(22)]);
var inst_22974 = (state_23025[(2)]);
var inst_22975__$1 = fluree.db.util.async.throw_err.call(null,inst_22974);
var inst_22976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22977 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22978 = (new cljs.core.PersistentVector(null,4,(5),inst_22976,inst_22977,null));
var inst_22979 = cljs.core.select_keys.call(null,inst_22900,inst_22978);
var inst_22980 = cljs.core.empty_QMARK_.call(null,inst_22975__$1);
var state_23025__$1 = (function (){var statearr_23093 = state_23025;
(statearr_23093[(21)] = inst_22979);

(statearr_23093[(22)] = inst_22975__$1);

return statearr_23093;
})();
if(inst_22980){
var statearr_23094_23160 = state_23025__$1;
(statearr_23094_23160[(1)] = (39));

} else {
var statearr_23095_23161 = state_23025__$1;
(statearr_23095_23161[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (30))){
var inst_22902 = (state_23025[(8)]);
var state_23025__$1 = state_23025;
var statearr_23096_23162 = state_23025__$1;
(statearr_23096_23162[(2)] = inst_22902);

(statearr_23096_23162[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (10))){
var inst_23018 = (state_23025[(2)]);
var state_23025__$1 = state_23025;
var statearr_23097_23163 = state_23025__$1;
(statearr_23097_23163[(2)] = inst_23018);

(statearr_23097_23163[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (18))){
var inst_22945 = (state_23025[(31)]);
var inst_22937 = (state_23025[(20)]);
var inst_22947 = (state_23025[(7)]);
var inst_22944 = cljs.core.seq.call(null,inst_22937);
var inst_22945__$1 = cljs.core.first.call(null,inst_22944);
var inst_22946 = cljs.core.next.call(null,inst_22944);
var inst_22947__$1 = cljs.core.not.call(null,inst_22945__$1);
var state_23025__$1 = (function (){var statearr_23098 = state_23025;
(statearr_23098[(31)] = inst_22945__$1);

(statearr_23098[(7)] = inst_22947__$1);

(statearr_23098[(19)] = inst_22946);

return statearr_23098;
})();
if(inst_22947__$1){
var statearr_23099_23164 = state_23025__$1;
(statearr_23099_23164[(1)] = (20));

} else {
var statearr_23100_23165 = state_23025__$1;
(statearr_23100_23165[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (42))){
var inst_22975 = (state_23025[(22)]);
var inst_22984 = cljs.core.count.call(null,inst_22975);
var inst_22985 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_22984,max_fuel);
var state_23025__$1 = state_23025;
var statearr_23101_23166 = state_23025__$1;
(statearr_23101_23166[(2)] = inst_22985);

(statearr_23101_23166[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (37))){
var inst_23000 = (state_23025[(2)]);
var state_23025__$1 = state_23025;
var statearr_23102_23167 = state_23025__$1;
(statearr_23102_23167[(2)] = inst_23000);

(statearr_23102_23167[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (8))){
var inst_22884 = (state_23025[(13)]);
var state_23025__$1 = state_23025;
var statearr_23103_23168 = state_23025__$1;
(statearr_23103_23168[(2)] = inst_22884);

(statearr_23103_23168[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23026 === (49))){
var inst_22905 = (state_23025[(30)]);
var state_23025__$1 = state_23025;
var statearr_23104_23169 = state_23025__$1;
(statearr_23104_23169[(2)] = inst_22905);

(statearr_23104_23169[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto____0 = (function (){
var statearr_23105 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23105[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto__);

(statearr_23105[(1)] = (1));

return statearr_23105;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto____1 = (function (state_23025){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23025);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23106){var ex__2749__auto__ = e23106;
var statearr_23107_23170 = state_23025;
(statearr_23107_23170[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23025[(4)]))){
var statearr_23108_23171 = state_23025;
(statearr_23108_23171[(1)] = cljs.core.first.call(null,(state_23025[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23172 = state_23025;
state_23025 = G__23172;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto__ = function(state_23025){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto____1.call(this,state_23025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23109 = f__2769__auto__.call(null);
(statearr_23109[(6)] = c__2768__auto__);

return statearr_23109;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.call(null,coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__23173 = select_spec;
var map__23173__$1 = cljs.core.__destructure_map.call(null,map__23173);
var recur_seen = cljs.core.get.call(null,map__23173__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.call(null,map__23173__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.call(null,recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23287){
var state_val_23288 = (state_23287[(1)]);
if((state_val_23288 === (7))){
var inst_23199 = flakes;
var inst_23200 = cljs.core.seq.call(null,inst_23199);
var inst_23201 = cljs.core.first.call(null,inst_23200);
var inst_23202 = cljs.core.next.call(null,inst_23200);
var inst_23203 = cljs.core.PersistentVector.EMPTY;
var inst_23204 = inst_23199;
var inst_23205 = (0);
var inst_23206 = inst_23203;
var state_23287__$1 = (function (){var statearr_23289 = state_23287;
(statearr_23289[(7)] = inst_23202);

(statearr_23289[(8)] = inst_23204);

(statearr_23289[(9)] = inst_23201);

(statearr_23289[(10)] = inst_23206);

(statearr_23289[(11)] = inst_23205);

return statearr_23289;
})();
var statearr_23290_23356 = state_23287__$1;
(statearr_23290_23356[(2)] = null);

(statearr_23290_23356[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (20))){
var state_23287__$1 = state_23287;
var statearr_23291_23357 = state_23287__$1;
(statearr_23291_23357[(2)] = results);

(statearr_23291_23357[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (27))){
var state_23287__$1 = state_23287;
var statearr_23292_23358 = state_23287__$1;
(statearr_23292_23358[(2)] = null);

(statearr_23292_23358[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (1))){
var state_23287__$1 = state_23287;
var statearr_23293_23359 = state_23287__$1;
(statearr_23293_23359[(2)] = null);

(statearr_23293_23359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (24))){
var state_23287__$1 = state_23287;
var statearr_23294_23360 = state_23287__$1;
(statearr_23294_23360[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (39))){
var inst_23268 = (state_23287[(12)]);
var inst_23213 = (state_23287[(13)]);
var inst_23206 = (state_23287[(10)]);
var inst_23271 = (state_23287[(2)]);
var inst_23272 = fluree.db.util.async.throw_err.call(null,inst_23271);
var inst_23273 = cljs.core.conj.call(null,inst_23206,inst_23272);
var inst_23204 = inst_23213;
var inst_23205 = inst_23268;
var inst_23206__$1 = inst_23273;
var state_23287__$1 = (function (){var statearr_23296 = state_23287;
(statearr_23296[(8)] = inst_23204);

(statearr_23296[(10)] = inst_23206__$1);

(statearr_23296[(11)] = inst_23205);

return statearr_23296;
})();
var statearr_23297_23361 = state_23287__$1;
(statearr_23297_23361[(2)] = null);

(statearr_23297_23361[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (4))){
var inst_23174 = (state_23287[(2)]);
var state_23287__$1 = state_23287;
var statearr_23298_23362 = state_23287__$1;
(statearr_23298_23362[(2)] = inst_23174);

(statearr_23298_23362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (15))){
var inst_23187 = (state_23287[(14)]);
var state_23287__$1 = state_23287;
var statearr_23299_23363 = state_23287__$1;
(statearr_23299_23363[(2)] = inst_23187);

(statearr_23299_23363[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (21))){
var inst_23183 = (state_23287[(15)]);
var state_23287__$1 = state_23287;
if(cljs.core.truth_(inst_23183)){
var statearr_23300_23364 = state_23287__$1;
(statearr_23300_23364[(1)] = (23));

} else {
var statearr_23301_23365 = state_23287__$1;
(statearr_23301_23365[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (31))){
var inst_23251 = (state_23287[(16)]);
var state_23287__$1 = state_23287;
var statearr_23302_23366 = state_23287__$1;
(statearr_23302_23366[(2)] = inst_23251);

(statearr_23302_23366[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (32))){
var inst_23243 = (state_23287[(17)]);
var inst_23257 = (state_23287[(2)]);
var state_23287__$1 = (function (){var statearr_23303 = state_23287;
(statearr_23303[(18)] = inst_23257);

return statearr_23303;
})();
if(cljs.core.truth_(inst_23243)){
var statearr_23304_23367 = state_23287__$1;
(statearr_23304_23367[(1)] = (33));

} else {
var statearr_23305_23368 = state_23287__$1;
(statearr_23305_23368[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (33))){
var inst_23243 = (state_23287[(17)]);
var state_23287__$1 = state_23287;
var statearr_23306_23369 = state_23287__$1;
(statearr_23306_23369[(2)] = inst_23243);

(statearr_23306_23369[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (13))){
var inst_23223 = (state_23287[(2)]);
var state_23287__$1 = state_23287;
if(cljs.core.truth_(inst_23223)){
var statearr_23308_23370 = state_23287__$1;
(statearr_23308_23370[(1)] = (17));

} else {
var statearr_23309_23371 = state_23287__$1;
(statearr_23309_23371[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (22))){
var inst_23240 = (state_23287[(2)]);
var state_23287__$1 = state_23287;
var statearr_23310_23372 = state_23287__$1;
(statearr_23310_23372[(2)] = inst_23240);

(statearr_23310_23372[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (36))){
var inst_23213 = (state_23287[(13)]);
var inst_23206 = (state_23287[(10)]);
var inst_23205 = (state_23287[(11)]);
var inst_23265 = (inst_23205 + (1));
var tmp23307 = inst_23206;
var inst_23204 = inst_23213;
var inst_23205__$1 = inst_23265;
var inst_23206__$1 = tmp23307;
var state_23287__$1 = (function (){var statearr_23311 = state_23287;
(statearr_23311[(8)] = inst_23204);

(statearr_23311[(10)] = inst_23206__$1);

(statearr_23311[(11)] = inst_23205__$1);

return statearr_23311;
})();
var statearr_23312_23373 = state_23287__$1;
(statearr_23312_23373[(2)] = null);

(statearr_23312_23373[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (29))){
var inst_23250 = (state_23287[(2)]);
var inst_23251 = fluree.db.util.async.throw_err.call(null,inst_23250);
var state_23287__$1 = (function (){var statearr_23313 = state_23287;
(statearr_23313[(16)] = inst_23251);

return statearr_23313;
})();
if(cljs.core.truth_(fuel)){
var statearr_23314_23374 = state_23287__$1;
(statearr_23314_23374[(1)] = (30));

} else {
var statearr_23315_23375 = state_23287__$1;
(statearr_23315_23375[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (6))){
var state_23287__$1 = state_23287;
var statearr_23316_23376 = state_23287__$1;
(statearr_23316_23376[(2)] = results);

(statearr_23316_23376[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (28))){
var inst_23236 = (state_23287[(2)]);
var state_23287__$1 = state_23287;
var statearr_23317_23377 = state_23287__$1;
(statearr_23317_23377[(2)] = inst_23236);

(statearr_23317_23377[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (25))){
var inst_23238 = (state_23287[(2)]);
var state_23287__$1 = state_23287;
var statearr_23318_23378 = state_23287__$1;
(statearr_23318_23378[(2)] = inst_23238);

(statearr_23318_23378[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (34))){
var inst_23257 = (state_23287[(18)]);
var inst_23260 = cljs.core.empty_QMARK_.call(null,inst_23257);
var state_23287__$1 = state_23287;
var statearr_23319_23379 = state_23287__$1;
(statearr_23319_23379[(2)] = inst_23260);

(statearr_23319_23379[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (17))){
var inst_23206 = (state_23287[(10)]);
var inst_23225 = cljs.core.empty_QMARK_.call(null,inst_23206);
var state_23287__$1 = state_23287;
if(inst_23225){
var statearr_23320_23380 = state_23287__$1;
(statearr_23320_23380[(1)] = (20));

} else {
var statearr_23321_23381 = state_23287__$1;
(statearr_23321_23381[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (3))){
var inst_23285 = (state_23287[(2)]);
var state_23287__$1 = state_23287;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23287__$1,inst_23285);
} else {
if((state_val_23288 === (12))){
var inst_23187 = (state_23287[(14)]);
var state_23287__$1 = state_23287;
if(cljs.core.truth_(inst_23187)){
var statearr_23322_23382 = state_23287__$1;
(statearr_23322_23382[(1)] = (14));

} else {
var statearr_23323_23383 = state_23287__$1;
(statearr_23323_23383[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (2))){
var _ = (function (){var statearr_23324 = state_23287;
(statearr_23324[(4)] = cljs.core.cons.call(null,(5),(state_23287[(4)])));

return statearr_23324;
})();
var inst_23181 = select_spec;
var inst_23182 = cljs.core.__destructure_map.call(null,inst_23181);
var inst_23183 = cljs.core.get.call(null,inst_23182,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_23184 = cljs.core.get.call(null,inst_23182,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23185 = cljs.core.get.call(null,inst_23182,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_23186 = cljs.core.get.call(null,inst_23182,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_23187 = cljs.core.get.call(null,inst_23182,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23188 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_23189 = (inst_23186 > inst_23188);
var state_23287__$1 = (function (){var statearr_23325 = state_23287;
(statearr_23325[(14)] = inst_23187);

(statearr_23325[(15)] = inst_23183);

(statearr_23325[(19)] = inst_23185);

(statearr_23325[(20)] = inst_23184);

return statearr_23325;
})();
if(cljs.core.truth_(inst_23189)){
var statearr_23326_23384 = state_23287__$1;
(statearr_23326_23384[(1)] = (6));

} else {
var statearr_23327_23385 = state_23287__$1;
(statearr_23327_23385[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (23))){
var inst_23206 = (state_23287[(10)]);
var inst_23184 = (state_23287[(20)]);
var inst_23229 = cljs.core.assoc.call(null,results,inst_23184,inst_23206);
var state_23287__$1 = state_23287;
var statearr_23328_23386 = state_23287__$1;
(statearr_23328_23386[(2)] = inst_23229);

(statearr_23328_23386[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (35))){
var inst_23212 = (state_23287[(21)]);
var inst_23262 = (state_23287[(2)]);
var inst_23263 = fluree.db.query.fql.recur_select_spec.call(null,select_spec,inst_23212);
var state_23287__$1 = (function (){var statearr_23329 = state_23287;
(statearr_23329[(22)] = inst_23263);

return statearr_23329;
})();
if(cljs.core.truth_(inst_23262)){
var statearr_23330_23387 = state_23287__$1;
(statearr_23330_23387[(1)] = (36));

} else {
var statearr_23331_23388 = state_23287__$1;
(statearr_23331_23388[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (19))){
var inst_23278 = (state_23287[(2)]);
var state_23287__$1 = state_23287;
var statearr_23332_23389 = state_23287__$1;
(statearr_23332_23389[(2)] = inst_23278);

(statearr_23332_23389[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (11))){
var inst_23214 = (state_23287[(23)]);
var state_23287__$1 = state_23287;
var statearr_23334_23390 = state_23287__$1;
(statearr_23334_23390[(2)] = inst_23214);

(statearr_23334_23390[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (9))){
var inst_23204 = (state_23287[(8)]);
var inst_23212 = (state_23287[(21)]);
var inst_23214 = (state_23287[(23)]);
var inst_23211 = cljs.core.seq.call(null,inst_23204);
var inst_23212__$1 = cljs.core.first.call(null,inst_23211);
var inst_23213 = cljs.core.next.call(null,inst_23211);
var inst_23214__$1 = cljs.core.not.call(null,inst_23212__$1);
var state_23287__$1 = (function (){var statearr_23335 = state_23287;
(statearr_23335[(21)] = inst_23212__$1);

(statearr_23335[(13)] = inst_23213);

(statearr_23335[(23)] = inst_23214__$1);

return statearr_23335;
})();
if(inst_23214__$1){
var statearr_23336_23391 = state_23287__$1;
(statearr_23336_23391[(1)] = (11));

} else {
var statearr_23337_23392 = state_23287__$1;
(statearr_23337_23392[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (5))){
var _ = (function (){var statearr_23338 = state_23287;
(statearr_23338[(4)] = cljs.core.rest.call(null,(state_23287[(4)])));

return statearr_23338;
})();
var state_23287__$1 = state_23287;
var ex23333 = (state_23287__$1[(2)]);
var statearr_23339_23393 = state_23287__$1;
(statearr_23339_23393[(5)] = ex23333);


if((ex23333 instanceof Error)){
var statearr_23340_23394 = state_23287__$1;
(statearr_23340_23394[(1)] = (4));

(statearr_23340_23394[(5)] = null);

} else {
throw ex23333;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (14))){
var inst_23187 = (state_23287[(14)]);
var inst_23205 = (state_23287[(11)]);
var inst_23218 = (inst_23205 < inst_23187);
var state_23287__$1 = state_23287;
var statearr_23341_23395 = state_23287__$1;
(statearr_23341_23395[(2)] = inst_23218);

(statearr_23341_23395[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (26))){
var inst_23206 = (state_23287[(10)]);
var inst_23184 = (state_23287[(20)]);
var inst_23232 = cljs.core.first.call(null,inst_23206);
var inst_23233 = cljs.core.assoc.call(null,results,inst_23184,inst_23232);
var state_23287__$1 = state_23287;
var statearr_23342_23396 = state_23287__$1;
(statearr_23342_23396[(2)] = inst_23233);

(statearr_23342_23396[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (16))){
var inst_23221 = (state_23287[(2)]);
var state_23287__$1 = state_23287;
var statearr_23343_23397 = state_23287__$1;
(statearr_23343_23397[(2)] = inst_23221);

(statearr_23343_23397[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (38))){
var inst_23276 = (state_23287[(2)]);
var state_23287__$1 = state_23287;
var statearr_23344_23398 = state_23287__$1;
(statearr_23344_23398[(2)] = inst_23276);

(statearr_23344_23398[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (30))){
var inst_23251 = (state_23287[(16)]);
var inst_23253 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_23254 = cljs.core.sequence.call(null,inst_23253,inst_23251);
var state_23287__$1 = state_23287;
var statearr_23345_23399 = state_23287__$1;
(statearr_23345_23399[(2)] = inst_23254);

(statearr_23345_23399[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (10))){
var inst_23280 = (state_23287[(2)]);
var state_23287__$1 = state_23287;
var statearr_23346_23400 = state_23287__$1;
(statearr_23346_23400[(2)] = inst_23280);

(statearr_23346_23400[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23288 === (18))){
var inst_23212 = (state_23287[(21)]);
var inst_23185 = (state_23287[(19)]);
var inst_23242 = inst_23212.o;
var inst_23243 = cljs.core.contains_QMARK_.call(null,inst_23185,inst_23242);
var inst_23245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23246 = [inst_23242];
var inst_23247 = (new cljs.core.PersistentVector(null,1,(5),inst_23245,inst_23246,null));
var inst_23248 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23247);
var state_23287__$1 = (function (){var statearr_23347 = state_23287;
(statearr_23347[(17)] = inst_23243);

return statearr_23347;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23287__$1,(29),inst_23248);
} else {
if((state_val_23288 === (37))){
var inst_23263 = (state_23287[(22)]);
var inst_23257 = (state_23287[(18)]);
var inst_23205 = (state_23287[(11)]);
var inst_23268 = (inst_23205 + (1));
var inst_23269 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23263,inst_23257);
var state_23287__$1 = (function (){var statearr_23348 = state_23287;
(statearr_23348[(12)] = inst_23268);

return statearr_23348;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23287__$1,(39),inst_23269);
} else {
if((state_val_23288 === (8))){
var inst_23282 = (state_23287[(2)]);
var _ = (function (){var statearr_23349 = state_23287;
(statearr_23349[(4)] = cljs.core.rest.call(null,(state_23287[(4)])));

return statearr_23349;
})();
var state_23287__$1 = state_23287;
var statearr_23350_23401 = state_23287__$1;
(statearr_23350_23401[(2)] = inst_23282);

(statearr_23350_23401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto____0 = (function (){
var statearr_23351 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23351[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto__);

(statearr_23351[(1)] = (1));

return statearr_23351;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto____1 = (function (state_23287){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23287);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23352){var ex__2749__auto__ = e23352;
var statearr_23353_23402 = state_23287;
(statearr_23353_23402[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23287[(4)]))){
var statearr_23354_23403 = state_23287;
(statearr_23354_23403[(1)] = cljs.core.first.call(null,(state_23287[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23404 = state_23287;
state_23287 = G__23404;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto__ = function(state_23287){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto____1.call(this,state_23287);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23355 = f__2769__auto__.call(null);
(statearr_23355[(6)] = c__2768__auto__);

return statearr_23355;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23585){
var state_val_23586 = (state_23585[(1)]);
if((state_val_23586 === (7))){
var state_23585__$1 = state_23585;
var statearr_23587_23673 = state_23585__$1;
(statearr_23587_23673[(2)] = null);

(statearr_23587_23673[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (20))){
var inst_23443 = cljs.core.PersistentHashMap.EMPTY;
var state_23585__$1 = state_23585;
var statearr_23588_23674 = state_23585__$1;
(statearr_23588_23674[(2)] = inst_23443);

(statearr_23588_23674[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (27))){
var inst_23431 = (state_23585[(7)]);
var inst_23425 = (state_23585[(8)]);
var inst_23461 = (state_23585[(9)]);
var inst_23445 = (state_23585[(10)]);
var inst_23564 = (state_23585[(2)]);
var inst_23565 = (function (){var top_level_subject = inst_23425;
var select_spec = inst_23431;
var base_acc = inst_23445;
var acc_PLUS_refs = inst_23461;
var result = inst_23564;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4253__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23566 = cljs.core.PersistentVector.EMPTY;
var inst_23567 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23431);
var inst_23568 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23567);
var inst_23569 = cljs.core.vals.call(null,inst_23568);
var inst_23570 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23431);
var inst_23571 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23570);
var inst_23572 = cljs.core.vals.call(null,inst_23571);
var inst_23573 = cljs.core.concat.call(null,inst_23569,inst_23572);
var inst_23574 = cljs.core.reduce.call(null,inst_23565,inst_23566,inst_23573);
var inst_23576 = (function (){var top_level_subject = inst_23425;
var select_spec = inst_23431;
var base_acc = inst_23445;
var acc_PLUS_refs = inst_23461;
var result = inst_23564;
var sort_preds = inst_23574;
return (function (acc,p__23575){
var vec__23589 = p__23575;
var selectPred = cljs.core.nth.call(null,vec__23589,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__23589,(1),null);
var sortPred = cljs.core.nth.call(null,vec__23589,(2),null);
var limit = cljs.core.nth.call(null,vec__23589,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_23577 = cljs.core.reduce.call(null,inst_23576,inst_23564,inst_23574);
var state_23585__$1 = state_23585;
var statearr_23592_23675 = state_23585__$1;
(statearr_23592_23675[(2)] = inst_23577);

(statearr_23592_23675[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (1))){
var state_23585__$1 = state_23585;
var statearr_23593_23676 = state_23585__$1;
(statearr_23593_23676[(2)] = null);

(statearr_23593_23676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (24))){
var inst_23461 = (state_23585[(9)]);
var inst_23461__$1 = (state_23585[(2)]);
var inst_23462 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_23463 = cljs.core.PersistentHashMap.EMPTY;
var inst_23464 = inst_23462;
var inst_23465 = inst_23461__$1;
var inst_23466 = inst_23463;
var state_23585__$1 = (function (){var statearr_23594 = state_23585;
(statearr_23594[(11)] = inst_23466);

(statearr_23594[(9)] = inst_23461__$1);

(statearr_23594[(12)] = inst_23464);

(statearr_23594[(13)] = inst_23465);

return statearr_23594;
})();
var statearr_23595_23677 = state_23585__$1;
(statearr_23595_23677[(2)] = null);

(statearr_23595_23677[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (39))){
var inst_23431 = (state_23585[(7)]);
var inst_23481 = (state_23585[(14)]);
var inst_23474 = (state_23585[(15)]);
var inst_23465 = (state_23585[(13)]);
var inst_23510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23511 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_23465,inst_23431,inst_23474,inst_23481,false);
var state_23585__$1 = (function (){var statearr_23596 = state_23585;
(statearr_23596[(16)] = inst_23510);

return statearr_23596;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23585__$1,(42),inst_23511);
} else {
if((state_val_23586 === (46))){
var inst_23474 = (state_23585[(15)]);
var inst_23466 = (state_23585[(11)]);
var inst_23464 = (state_23585[(12)]);
var inst_23528 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23529 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23530 = cljs.core.first.call(null,inst_23474);
var inst_23531 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23530);
var inst_23532 = [inst_23531];
var inst_23533 = cljs.core.PersistentHashMap.fromArrays(inst_23529,inst_23532);
var inst_23534 = cljs.core.rest.call(null,inst_23464);
var inst_23535 = [inst_23533,inst_23534,inst_23466];
var inst_23536 = (new cljs.core.PersistentVector(null,3,(5),inst_23528,inst_23535,null));
var state_23585__$1 = state_23585;
var statearr_23597_23678 = state_23585__$1;
(statearr_23597_23678[(2)] = inst_23536);

(statearr_23597_23678[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (4))){
var inst_23405 = (state_23585[(2)]);
var state_23585__$1 = state_23585;
var statearr_23598_23679 = state_23585__$1;
(statearr_23598_23679[(2)] = inst_23405);

(statearr_23598_23679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (15))){
var inst_23431 = (state_23585[(7)]);
var inst_23432 = (state_23585[(17)]);
var inst_23431__$1 = (state_23585[(2)]);
var inst_23432__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23431__$1);
var state_23585__$1 = (function (){var statearr_23599 = state_23585;
(statearr_23599[(7)] = inst_23431__$1);

(statearr_23599[(17)] = inst_23432__$1);

return statearr_23599;
})();
if(cljs.core.truth_(inst_23432__$1)){
var statearr_23600_23680 = state_23585__$1;
(statearr_23600_23680[(1)] = (16));

} else {
var statearr_23601_23681 = state_23585__$1;
(statearr_23601_23681[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (48))){
var inst_23547 = (state_23585[(2)]);
var state_23585__$1 = state_23585;
var statearr_23602_23682 = state_23585__$1;
(statearr_23602_23682[(2)] = inst_23547);

(statearr_23602_23682[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (50))){
var state_23585__$1 = state_23585;
var statearr_23603_23683 = state_23585__$1;
(statearr_23603_23683[(2)] = null);

(statearr_23603_23683[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (21))){
var inst_23431 = (state_23585[(7)]);
var inst_23445 = (state_23585[(2)]);
var inst_23446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23447 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23448 = (new cljs.core.PersistentVector(null,2,(5),inst_23446,inst_23447,null));
var inst_23449 = cljs.core.get_in.call(null,inst_23431,inst_23448);
var state_23585__$1 = (function (){var statearr_23604 = state_23585;
(statearr_23604[(10)] = inst_23445);

return statearr_23604;
})();
if(cljs.core.truth_(inst_23449)){
var statearr_23605_23684 = state_23585__$1;
(statearr_23605_23684[(1)] = (22));

} else {
var statearr_23606_23685 = state_23585__$1;
(statearr_23606_23685[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (31))){
var inst_23480 = (state_23585[(18)]);
var inst_23474 = (state_23585[(15)]);
var inst_23465 = (state_23585[(13)]);
var inst_23484 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23485 = fluree.db.query.fql.flake__GT_recur.call(null,db,inst_23474,inst_23480,inst_23465,fuel,max_fuel,cache);
var state_23585__$1 = (function (){var statearr_23607 = state_23585;
(statearr_23607[(19)] = inst_23484);

return statearr_23607;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23585__$1,(34),inst_23485);
} else {
if((state_val_23586 === (32))){
var inst_23480 = (state_23585[(18)]);
var state_23585__$1 = state_23585;
if(cljs.core.truth_(inst_23480)){
var statearr_23608_23686 = state_23585__$1;
(statearr_23608_23686[(1)] = (35));

} else {
var statearr_23609_23687 = state_23585__$1;
(statearr_23609_23687[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (40))){
var inst_23431 = (state_23585[(7)]);
var inst_23521 = (state_23585[(20)]);
var inst_23520 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23431);
var inst_23521__$1 = cljs.core.empty_QMARK_.call(null,inst_23520);
var state_23585__$1 = (function (){var statearr_23610 = state_23585;
(statearr_23610[(20)] = inst_23521__$1);

return statearr_23610;
})();
if(inst_23521__$1){
var statearr_23611_23688 = state_23585__$1;
(statearr_23611_23688[(1)] = (43));

} else {
var statearr_23612_23689 = state_23585__$1;
(statearr_23612_23689[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (33))){
var inst_23474 = (state_23585[(15)]);
var inst_23553 = (state_23585[(2)]);
var inst_23554 = cljs.core.nth.call(null,inst_23553,(0),null);
var inst_23555 = cljs.core.nth.call(null,inst_23553,(1),null);
var inst_23556 = cljs.core.nth.call(null,inst_23553,(2),null);
var inst_23557 = cljs.core.first.call(null,inst_23474);
var inst_23558 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23557);
var inst_23559 = cljs.core.assoc.call(null,inst_23554,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23558);
var inst_23464 = inst_23555;
var inst_23465 = inst_23559;
var inst_23466 = inst_23556;
var state_23585__$1 = (function (){var statearr_23613 = state_23585;
(statearr_23613[(11)] = inst_23466);

(statearr_23613[(12)] = inst_23464);

(statearr_23613[(13)] = inst_23465);

return statearr_23613;
})();
var statearr_23614_23690 = state_23585__$1;
(statearr_23614_23690[(2)] = null);

(statearr_23614_23690[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (13))){
var inst_23425 = (state_23585[(8)]);
var inst_23428 = fluree.db.query.fql.full_select_spec.call(null,db,cache,base_select_spec,inst_23425);
var state_23585__$1 = state_23585;
var statearr_23615_23691 = state_23585__$1;
(statearr_23615_23691[(2)] = inst_23428);

(statearr_23615_23691[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (22))){
var inst_23431 = (state_23585[(7)]);
var inst_23451 = cljs.core.first.call(null,flakes);
var inst_23452 = fluree.db.query.fql.s.call(null,inst_23451);
var inst_23453 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_23431);
var inst_23454 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_23452,inst_23453);
var state_23585__$1 = state_23585;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23585__$1,(25),inst_23454);
} else {
if((state_val_23586 === (36))){
var inst_23431 = (state_23585[(7)]);
var inst_23508 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23431);
var state_23585__$1 = state_23585;
if(cljs.core.truth_(inst_23508)){
var statearr_23616_23692 = state_23585__$1;
(statearr_23616_23692[(1)] = (39));

} else {
var statearr_23617_23693 = state_23585__$1;
(statearr_23617_23693[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (41))){
var inst_23549 = (state_23585[(2)]);
var state_23585__$1 = state_23585;
var statearr_23618_23694 = state_23585__$1;
(statearr_23618_23694[(2)] = inst_23549);

(statearr_23618_23694[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (43))){
var inst_23431 = (state_23585[(7)]);
var inst_23523 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23431);
var state_23585__$1 = state_23585;
var statearr_23619_23695 = state_23585__$1;
(statearr_23619_23695[(2)] = inst_23523);

(statearr_23619_23695[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (29))){
var inst_23431 = (state_23585[(7)]);
var inst_23480 = (state_23585[(18)]);
var inst_23474 = (state_23585[(15)]);
var inst_23464 = (state_23585[(12)]);
var inst_23474__$1 = cljs.core.first.call(null,inst_23464);
var inst_23475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23476 = cljs.core.first.call(null,inst_23474__$1);
var inst_23477 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_23476);
var inst_23478 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23477];
var inst_23479 = (new cljs.core.PersistentVector(null,3,(5),inst_23475,inst_23478,null));
var inst_23480__$1 = cljs.core.get_in.call(null,inst_23431,inst_23479);
var inst_23481 = fluree.db.query.fql.component_follow_QMARK_.call(null,inst_23480__$1,inst_23431);
var inst_23482 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23480__$1);
var state_23585__$1 = (function (){var statearr_23620 = state_23585;
(statearr_23620[(18)] = inst_23480__$1);

(statearr_23620[(14)] = inst_23481);

(statearr_23620[(15)] = inst_23474__$1);

return statearr_23620;
})();
if(cljs.core.truth_(inst_23482)){
var statearr_23621_23696 = state_23585__$1;
(statearr_23621_23696[(1)] = (31));

} else {
var statearr_23622_23697 = state_23585__$1;
(statearr_23622_23697[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (44))){
var inst_23521 = (state_23585[(20)]);
var state_23585__$1 = state_23585;
var statearr_23623_23698 = state_23585__$1;
(statearr_23623_23698[(2)] = inst_23521);

(statearr_23623_23698[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (6))){
var state_23585__$1 = state_23585;
var statearr_23624_23699 = state_23585__$1;
(statearr_23624_23699[(2)] = null);

(statearr_23624_23699[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (28))){
var inst_23465 = (state_23585[(13)]);
var state_23585__$1 = state_23585;
var statearr_23625_23700 = state_23585__$1;
(statearr_23625_23700[(2)] = inst_23465);

(statearr_23625_23700[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (51))){
var inst_23545 = (state_23585[(2)]);
var state_23585__$1 = state_23585;
var statearr_23626_23701 = state_23585__$1;
(statearr_23626_23701[(2)] = inst_23545);

(statearr_23626_23701[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (25))){
var inst_23445 = (state_23585[(10)]);
var inst_23456 = (state_23585[(2)]);
var inst_23457 = fluree.db.util.async.throw_err.call(null,inst_23456);
var inst_23458 = cljs.core.merge.call(null,inst_23445,inst_23457);
var state_23585__$1 = state_23585;
var statearr_23627_23702 = state_23585__$1;
(statearr_23627_23702[(2)] = inst_23458);

(statearr_23627_23702[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (34))){
var inst_23466 = (state_23585[(11)]);
var inst_23464 = (state_23585[(12)]);
var inst_23484 = (state_23585[(19)]);
var inst_23487 = (state_23585[(2)]);
var inst_23488 = fluree.db.util.async.throw_err.call(null,inst_23487);
var inst_23489 = cljs.core.rest.call(null,inst_23464);
var inst_23490 = [inst_23488,inst_23489,inst_23466];
var inst_23491 = (new cljs.core.PersistentVector(null,3,(5),inst_23484,inst_23490,null));
var state_23585__$1 = state_23585;
var statearr_23628_23703 = state_23585__$1;
(statearr_23628_23703[(2)] = inst_23491);

(statearr_23628_23703[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (17))){
var inst_23431 = (state_23585[(7)]);
var inst_23435 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23431);
var state_23585__$1 = state_23585;
var statearr_23630_23704 = state_23585__$1;
(statearr_23630_23704[(2)] = inst_23435);

(statearr_23630_23704[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (3))){
var inst_23583 = (state_23585[(2)]);
var state_23585__$1 = state_23585;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23585__$1,inst_23583);
} else {
if((state_val_23586 === (12))){
var _ = (function (){var statearr_23631 = state_23585;
(statearr_23631[(4)] = cljs.core.rest.call(null,(state_23585[(4)])));

return statearr_23631;
})();
var state_23585__$1 = state_23585;
var ex23629 = (state_23585__$1[(2)]);
var statearr_23632_23705 = state_23585__$1;
(statearr_23632_23705[(5)] = ex23629);


var statearr_23633_23706 = state_23585__$1;
(statearr_23633_23706[(1)] = (11));

(statearr_23633_23706[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (2))){
var _ = (function (){var statearr_23634 = state_23585;
(statearr_23634[(4)] = cljs.core.cons.call(null,(5),(state_23585[(4)])));

return statearr_23634;
})();
var inst_23411 = cljs.core.not_empty.call(null,flakes);
var state_23585__$1 = state_23585;
if(cljs.core.truth_(inst_23411)){
var statearr_23635_23707 = state_23585__$1;
(statearr_23635_23707[(1)] = (6));

} else {
var statearr_23636_23708 = state_23585__$1;
(statearr_23636_23708[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (23))){
var inst_23445 = (state_23585[(10)]);
var state_23585__$1 = state_23585;
var statearr_23637_23709 = state_23585__$1;
(statearr_23637_23709[(2)] = inst_23445);

(statearr_23637_23709[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (47))){
var state_23585__$1 = state_23585;
var statearr_23638_23710 = state_23585__$1;
(statearr_23638_23710[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (35))){
var inst_23480 = (state_23585[(18)]);
var inst_23481 = (state_23585[(14)]);
var inst_23474 = (state_23585[(15)]);
var inst_23466 = (state_23585[(11)]);
var inst_23465 = (state_23585[(13)]);
var inst_23497 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_23465,inst_23480,inst_23474,inst_23481,false,inst_23466);
var state_23585__$1 = state_23585;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23585__$1,(38),inst_23497);
} else {
if((state_val_23586 === (19))){
var inst_23425 = (state_23585[(8)]);
var inst_23439 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23440 = [inst_23425];
var inst_23441 = cljs.core.PersistentHashMap.fromArrays(inst_23439,inst_23440);
var state_23585__$1 = state_23585;
var statearr_23640_23711 = state_23585__$1;
(statearr_23640_23711[(2)] = inst_23441);

(statearr_23640_23711[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (11))){
var inst_23413 = (state_23585[(2)]);
var inst_23414 = fluree.db.util.log.error.call(null,inst_23413);
var inst_23415 = (function(){throw inst_23413})();
var state_23585__$1 = (function (){var statearr_23642 = state_23585;
(statearr_23642[(21)] = inst_23414);

return statearr_23642;
})();
var statearr_23643_23712 = state_23585__$1;
(statearr_23643_23712[(2)] = inst_23415);

(statearr_23643_23712[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (9))){
var _ = (function (){var statearr_23644 = state_23585;
(statearr_23644[(4)] = cljs.core.cons.call(null,(12),(state_23585[(4)])));

return statearr_23644;
})();
var inst_23421 = cljs.core.first.call(null,flakes);
var inst_23422 = fluree.db.query.fql.s.call(null,inst_23421);
var ___$1 = (function (){var statearr_23645 = state_23585;
(statearr_23645[(4)] = cljs.core.rest.call(null,(state_23585[(4)])));

return statearr_23645;
})();
var state_23585__$1 = state_23585;
var statearr_23646_23713 = state_23585__$1;
(statearr_23646_23713[(2)] = inst_23422);

(statearr_23646_23713[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (5))){
var _ = (function (){var statearr_23647 = state_23585;
(statearr_23647[(4)] = cljs.core.rest.call(null,(state_23585[(4)])));

return statearr_23647;
})();
var state_23585__$1 = state_23585;
var ex23641 = (state_23585__$1[(2)]);
var statearr_23648_23714 = state_23585__$1;
(statearr_23648_23714[(5)] = ex23641);


if((ex23641 instanceof Error)){
var statearr_23649_23715 = state_23585__$1;
(statearr_23649_23715[(1)] = (4));

(statearr_23649_23715[(5)] = null);

} else {
throw ex23641;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (14))){
var state_23585__$1 = state_23585;
var statearr_23650_23716 = state_23585__$1;
(statearr_23650_23716[(2)] = base_select_spec);

(statearr_23650_23716[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (45))){
var inst_23526 = (state_23585[(2)]);
var state_23585__$1 = state_23585;
if(cljs.core.truth_(inst_23526)){
var statearr_23651_23717 = state_23585__$1;
(statearr_23651_23717[(1)] = (46));

} else {
var statearr_23652_23718 = state_23585__$1;
(statearr_23652_23718[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (26))){
var inst_23464 = (state_23585[(12)]);
var inst_23468 = cljs.core.empty_QMARK_.call(null,inst_23464);
var state_23585__$1 = state_23585;
if(inst_23468){
var statearr_23653_23719 = state_23585__$1;
(statearr_23653_23719[(1)] = (28));

} else {
var statearr_23654_23720 = state_23585__$1;
(statearr_23654_23720[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (16))){
var inst_23432 = (state_23585[(17)]);
var state_23585__$1 = state_23585;
var statearr_23655_23721 = state_23585__$1;
(statearr_23655_23721[(2)] = inst_23432);

(statearr_23655_23721[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (38))){
var inst_23464 = (state_23585[(12)]);
var inst_23499 = (state_23585[(2)]);
var inst_23500 = fluree.db.util.async.throw_err.call(null,inst_23499);
var inst_23501 = cljs.core.nth.call(null,inst_23500,(0),null);
var inst_23502 = cljs.core.nth.call(null,inst_23500,(1),null);
var inst_23503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23504 = cljs.core.rest.call(null,inst_23464);
var inst_23505 = [inst_23501,inst_23504,inst_23502];
var inst_23506 = (new cljs.core.PersistentVector(null,3,(5),inst_23503,inst_23505,null));
var state_23585__$1 = state_23585;
var statearr_23656_23722 = state_23585__$1;
(statearr_23656_23722[(2)] = inst_23506);

(statearr_23656_23722[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (30))){
var inst_23562 = (state_23585[(2)]);
var state_23585__$1 = state_23585;
var statearr_23657_23723 = state_23585__$1;
(statearr_23657_23723[(2)] = inst_23562);

(statearr_23657_23723[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (10))){
var inst_23425 = (state_23585[(2)]);
var inst_23426 = fluree.db.query.fql.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_23585__$1 = (function (){var statearr_23658 = state_23585;
(statearr_23658[(8)] = inst_23425);

return statearr_23658;
})();
if(cljs.core.truth_(inst_23426)){
var statearr_23659_23724 = state_23585__$1;
(statearr_23659_23724[(1)] = (13));

} else {
var statearr_23660_23725 = state_23585__$1;
(statearr_23660_23725[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (18))){
var inst_23437 = (state_23585[(2)]);
var state_23585__$1 = state_23585;
if(cljs.core.truth_(inst_23437)){
var statearr_23661_23726 = state_23585__$1;
(statearr_23661_23726[(1)] = (19));

} else {
var statearr_23662_23727 = state_23585__$1;
(statearr_23662_23727[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (42))){
var inst_23466 = (state_23585[(11)]);
var inst_23510 = (state_23585[(16)]);
var inst_23464 = (state_23585[(12)]);
var inst_23513 = (state_23585[(2)]);
var inst_23514 = fluree.db.util.async.throw_err.call(null,inst_23513);
var inst_23515 = cljs.core.first.call(null,inst_23514);
var inst_23516 = cljs.core.rest.call(null,inst_23464);
var inst_23517 = [inst_23515,inst_23516,inst_23466];
var inst_23518 = (new cljs.core.PersistentVector(null,3,(5),inst_23510,inst_23517,null));
var state_23585__$1 = state_23585;
var statearr_23663_23728 = state_23585__$1;
(statearr_23663_23728[(2)] = inst_23518);

(statearr_23663_23728[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (37))){
var inst_23551 = (state_23585[(2)]);
var state_23585__$1 = state_23585;
var statearr_23664_23729 = state_23585__$1;
(statearr_23664_23729[(2)] = inst_23551);

(statearr_23664_23729[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (8))){
var inst_23580 = (state_23585[(2)]);
var _ = (function (){var statearr_23665 = state_23585;
(statearr_23665[(4)] = cljs.core.rest.call(null,(state_23585[(4)])));

return statearr_23665;
})();
var state_23585__$1 = state_23585;
var statearr_23666_23730 = state_23585__$1;
(statearr_23666_23730[(2)] = inst_23580);

(statearr_23666_23730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (49))){
var inst_23466 = (state_23585[(11)]);
var inst_23464 = (state_23585[(12)]);
var inst_23465 = (state_23585[(13)]);
var inst_23539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23540 = cljs.core.rest.call(null,inst_23464);
var inst_23541 = [inst_23465,inst_23540,inst_23466];
var inst_23542 = (new cljs.core.PersistentVector(null,3,(5),inst_23539,inst_23541,null));
var state_23585__$1 = state_23585;
var statearr_23667_23731 = state_23585__$1;
(statearr_23667_23731[(2)] = inst_23542);

(statearr_23667_23731[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto____0 = (function (){
var statearr_23668 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23668[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto__);

(statearr_23668[(1)] = (1));

return statearr_23668;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto____1 = (function (state_23585){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23585);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23669){var ex__2749__auto__ = e23669;
var statearr_23670_23732 = state_23585;
(statearr_23670_23732[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23585[(4)]))){
var statearr_23671_23733 = state_23585;
(statearr_23671_23733[(1)] = cljs.core.first.call(null,(state_23585[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23734 = state_23585;
state_23585 = G__23734;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto__ = function(state_23585){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto____1.call(this,state_23585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23672 = f__2769__auto__.call(null);
(statearr_23672[(6)] = c__2768__auto__);

return statearr_23672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__23737 = arguments.length;
switch (G__23737) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23779){
var state_val_23780 = (state_23779[(1)]);
if((state_val_23780 === (7))){
var inst_23745 = (state_23779[(7)]);
var state_23779__$1 = state_23779;
var statearr_23781_23811 = state_23779__$1;
(statearr_23781_23811[(2)] = inst_23745);

(statearr_23781_23811[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23780 === (1))){
var state_23779__$1 = state_23779;
var statearr_23782_23812 = state_23779__$1;
(statearr_23782_23812[(2)] = null);

(statearr_23782_23812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23780 === (4))){
var inst_23738 = (state_23779[(2)]);
var state_23779__$1 = state_23779;
var statearr_23783_23813 = state_23779__$1;
(statearr_23783_23813[(2)] = inst_23738);

(statearr_23783_23813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23780 === (15))){
var inst_23773 = (state_23779[(2)]);
var inst_23774 = fluree.db.util.async.throw_err.call(null,inst_23773);
var _ = (function (){var statearr_23784 = state_23779;
(statearr_23784[(4)] = cljs.core.rest.call(null,(state_23779[(4)])));

return statearr_23784;
})();
var state_23779__$1 = state_23779;
var statearr_23785_23814 = state_23779__$1;
(statearr_23785_23814[(2)] = inst_23774);

(statearr_23785_23814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23780 === (13))){
var inst_23757 = (state_23779[(8)]);
var state_23779__$1 = state_23779;
var statearr_23786_23815 = state_23779__$1;
(statearr_23786_23815[(2)] = inst_23757);

(statearr_23786_23815[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23780 === (6))){
var inst_23745 = (state_23779[(7)]);
var inst_23747 = fluree.db.query.fql.fuel_flakes_transducer.call(null,fuel,max_fuel);
var inst_23748 = cljs.core.comp.call(null,inst_23745,inst_23747);
var state_23779__$1 = state_23779;
var statearr_23787_23816 = state_23779__$1;
(statearr_23787_23816[(2)] = inst_23748);

(statearr_23787_23816[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23780 === (3))){
var inst_23777 = (state_23779[(2)]);
var state_23779__$1 = state_23779;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23779__$1,inst_23777);
} else {
if((state_val_23780 === (12))){
var inst_23757 = (state_23779[(8)]);
var inst_23759 = cljs.core.take.call(null,limit);
var inst_23760 = cljs.core.comp.call(null,inst_23757,inst_23759);
var state_23779__$1 = state_23779;
var statearr_23788_23817 = state_23779__$1;
(statearr_23788_23817[(2)] = inst_23760);

(statearr_23788_23817[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23780 === (2))){
var _ = (function (){var statearr_23789 = state_23779;
(statearr_23789[(4)] = cljs.core.cons.call(null,(5),(state_23779[(4)])));

return statearr_23789;
})();
var inst_23745 = cljs.core.partition_by.call(null,fluree.db.query.fql.s);
var state_23779__$1 = (function (){var statearr_23790 = state_23779;
(statearr_23790[(7)] = inst_23745);

return statearr_23790;
})();
if(cljs.core.truth_(fuel)){
var statearr_23791_23818 = state_23779__$1;
(statearr_23791_23818[(1)] = (6));

} else {
var statearr_23792_23819 = state_23779__$1;
(statearr_23792_23819[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23780 === (11))){
var inst_23757 = (state_23779[(2)]);
var state_23779__$1 = (function (){var statearr_23794 = state_23779;
(statearr_23794[(8)] = inst_23757);

return statearr_23794;
})();
if(cljs.core.truth_(limit)){
var statearr_23795_23820 = state_23779__$1;
(statearr_23795_23820[(1)] = (12));

} else {
var statearr_23796_23821 = state_23779__$1;
(statearr_23796_23821[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23780 === (9))){
var inst_23751 = (state_23779[(9)]);
var inst_23753 = cljs.core.drop.call(null,offset);
var inst_23754 = cljs.core.comp.call(null,inst_23751,inst_23753);
var state_23779__$1 = state_23779;
var statearr_23797_23822 = state_23779__$1;
(statearr_23797_23822[(2)] = inst_23754);

(statearr_23797_23822[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23780 === (5))){
var _ = (function (){var statearr_23798 = state_23779;
(statearr_23798[(4)] = cljs.core.rest.call(null,(state_23779[(4)])));

return statearr_23798;
})();
var state_23779__$1 = state_23779;
var ex23793 = (state_23779__$1[(2)]);
var statearr_23799_23823 = state_23779__$1;
(statearr_23799_23823[(5)] = ex23793);


if((ex23793 instanceof Error)){
var statearr_23800_23824 = state_23779__$1;
(statearr_23800_23824[(1)] = (4));

(statearr_23800_23824[(5)] = null);

} else {
throw ex23793;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23780 === (14))){
var inst_23763 = (state_23779[(2)]);
var inst_23764 = (function (){return (function (x){
var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref.call(null,fuel) >= max_fuel);
} else {
return and__4251__auto__;
}
});
})();
var inst_23765 = cljs.core.halt_when.call(null,inst_23764);
var inst_23766 = cljs.core.comp.call(null,inst_23763,inst_23765);
var inst_23767 = cljs.core.sequence.call(null,inst_23766,flakes);
var inst_23768 = cljs.core.PersistentVector.EMPTY;
var inst_23769 = (function (){var xf = inst_23766;
var flakes_by_sub = inst_23767;
return (function (p1__23735_SHARP_){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,p1__23735_SHARP_);
});
})();
var inst_23770 = cljs.core.map.call(null,inst_23769,inst_23767);
var inst_23771 = fluree.db.util.async.merge_into_QMARK_.call(null,inst_23768,inst_23770);
var state_23779__$1 = state_23779;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23779__$1,(15),inst_23771);
} else {
if((state_val_23780 === (10))){
var inst_23751 = (state_23779[(9)]);
var state_23779__$1 = state_23779;
var statearr_23801_23825 = state_23779__$1;
(statearr_23801_23825[(2)] = inst_23751);

(statearr_23801_23825[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23780 === (8))){
var inst_23751 = (state_23779[(2)]);
var state_23779__$1 = (function (){var statearr_23802 = state_23779;
(statearr_23802[(9)] = inst_23751);

return statearr_23802;
})();
if(cljs.core.truth_(offset)){
var statearr_23803_23826 = state_23779__$1;
(statearr_23803_23826[(1)] = (9));

} else {
var statearr_23804_23827 = state_23779__$1;
(statearr_23804_23827[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2746__auto__ = null;
var fluree$db$query$fql$state_machine__2746__auto____0 = (function (){
var statearr_23805 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23805[(0)] = fluree$db$query$fql$state_machine__2746__auto__);

(statearr_23805[(1)] = (1));

return statearr_23805;
});
var fluree$db$query$fql$state_machine__2746__auto____1 = (function (state_23779){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23779);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23806){var ex__2749__auto__ = e23806;
var statearr_23807_23828 = state_23779;
(statearr_23807_23828[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23779[(4)]))){
var statearr_23808_23829 = state_23779;
(statearr_23808_23829[(1)] = cljs.core.first.call(null,(state_23779[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23830 = state_23779;
state_23779 = G__23830;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2746__auto__ = function(state_23779){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2746__auto____1.call(this,state_23779);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2746__auto____0;
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2746__auto____1;
return fluree$db$query$fql$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23809 = f__2769__auto__.call(null);
(statearr_23809[(6)] = c__2768__auto__);

return statearr_23809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__23832 = arguments.length;
switch (G__23832) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23918){
var state_val_23919 = (state_23918[(1)]);
if((state_val_23919 === (7))){
var inst_23913 = (state_23918[(2)]);
var _ = (function (){var statearr_23921 = state_23918;
(statearr_23921[(4)] = cljs.core.rest.call(null,(state_23918[(4)])));

return statearr_23921;
})();
var state_23918__$1 = state_23918;
var statearr_23922_23974 = state_23918__$1;
(statearr_23922_23974[(2)] = inst_23913);

(statearr_23922_23974[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (20))){
var inst_23852 = (state_23918[(7)]);
var inst_23860 = (state_23918[(8)]);
var inst_23853 = (state_23918[(9)]);
var inst_23881 = (inst_23852 + (1));
var tmp23920 = inst_23853;
var inst_23851 = inst_23860;
var inst_23852__$1 = inst_23881;
var inst_23853__$1 = tmp23920;
var state_23918__$1 = (function (){var statearr_23923 = state_23918;
(statearr_23923[(10)] = inst_23851);

(statearr_23923[(7)] = inst_23852__$1);

(statearr_23923[(9)] = inst_23853__$1);

return statearr_23923;
})();
var statearr_23924_23975 = state_23918__$1;
(statearr_23924_23975[(2)] = null);

(statearr_23924_23975[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (27))){
var inst_23891 = (state_23918[(11)]);
var inst_23893 = cljs.core.count.call(null,inst_23891);
var inst_23894 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_23893);
var state_23918__$1 = state_23918;
var statearr_23925_23976 = state_23918__$1;
(statearr_23925_23976[(2)] = inst_23894);

(statearr_23925_23976[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (1))){
var state_23918__$1 = state_23918;
var statearr_23926_23977 = state_23918__$1;
(statearr_23926_23977[(2)] = null);

(statearr_23926_23977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (24))){
var state_23918__$1 = state_23918;
var statearr_23927_23978 = state_23918__$1;
(statearr_23927_23978[(2)] = null);

(statearr_23927_23978[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (4))){
var inst_23833 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
var statearr_23928_23979 = state_23918__$1;
(statearr_23928_23979[(2)] = inst_23833);

(statearr_23928_23979[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (15))){
var inst_23874 = (state_23918[(12)]);
var inst_23874__$1 = offset;
var state_23918__$1 = (function (){var statearr_23929 = state_23918;
(statearr_23929[(12)] = inst_23874__$1);

return statearr_23929;
})();
if(cljs.core.truth_(inst_23874__$1)){
var statearr_23930_23980 = state_23918__$1;
(statearr_23930_23980[(1)] = (17));

} else {
var statearr_23931_23981 = state_23918__$1;
(statearr_23931_23981[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (21))){
var state_23918__$1 = state_23918;
var statearr_23932_23982 = state_23918__$1;
(statearr_23932_23982[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (13))){
var inst_23869 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
var statearr_23934_23983 = state_23918__$1;
(statearr_23934_23983[(2)] = inst_23869);

(statearr_23934_23983[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (22))){
var inst_23909 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
var statearr_23935_23984 = state_23918__$1;
(statearr_23935_23984[(2)] = inst_23909);

(statearr_23935_23984[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (29))){
var inst_23891 = (state_23918[(11)]);
var inst_23852 = (state_23918[(7)]);
var inst_23897 = (state_23918[(2)]);
var inst_23898 = (inst_23852 + (1));
var inst_23899 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,inst_23891);
var state_23918__$1 = (function (){var statearr_23936 = state_23918;
(statearr_23936[(13)] = inst_23897);

(statearr_23936[(14)] = inst_23898);

return statearr_23936;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23918__$1,(30),inst_23899);
} else {
if((state_val_23919 === (6))){
var inst_23851 = (state_23918[(10)]);
var inst_23861 = (state_23918[(15)]);
var inst_23859 = (state_23918[(16)]);
var inst_23858 = cljs.core.seq.call(null,inst_23851);
var inst_23859__$1 = cljs.core.first.call(null,inst_23858);
var inst_23860 = cljs.core.next.call(null,inst_23858);
var inst_23861__$1 = (inst_23859__$1 == null);
var state_23918__$1 = (function (){var statearr_23937 = state_23918;
(statearr_23937[(15)] = inst_23861__$1);

(statearr_23937[(8)] = inst_23860);

(statearr_23937[(16)] = inst_23859__$1);

return statearr_23937;
})();
if(cljs.core.truth_(inst_23861__$1)){
var statearr_23938_23985 = state_23918__$1;
(statearr_23938_23985[(1)] = (8));

} else {
var statearr_23939_23986 = state_23918__$1;
(statearr_23939_23986[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (28))){
var state_23918__$1 = state_23918;
var statearr_23940_23987 = state_23918__$1;
(statearr_23940_23987[(2)] = null);

(statearr_23940_23987[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (25))){
var inst_23907 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
var statearr_23941_23988 = state_23918__$1;
(statearr_23941_23988[(2)] = inst_23907);

(statearr_23941_23988[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (17))){
var inst_23852 = (state_23918[(7)]);
var inst_23876 = (inst_23852 < offset);
var state_23918__$1 = state_23918;
var statearr_23942_23989 = state_23918__$1;
(statearr_23942_23989[(2)] = inst_23876);

(statearr_23942_23989[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (3))){
var inst_23916 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23918__$1,inst_23916);
} else {
if((state_val_23919 === (12))){
var inst_23864 = (state_23918[(17)]);
var state_23918__$1 = state_23918;
var statearr_23943_23990 = state_23918__$1;
(statearr_23943_23990[(2)] = inst_23864);

(statearr_23943_23990[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (2))){
var _ = (function (){var statearr_23944 = state_23918;
(statearr_23944[(4)] = cljs.core.cons.call(null,(5),(state_23918[(4)])));

return statearr_23944;
})();
var inst_23846 = subjects;
var inst_23847 = cljs.core.seq.call(null,inst_23846);
var inst_23848 = cljs.core.first.call(null,inst_23847);
var inst_23849 = cljs.core.next.call(null,inst_23847);
var inst_23850 = cljs.core.PersistentVector.EMPTY;
var inst_23851 = inst_23846;
var inst_23852 = (0);
var inst_23853 = inst_23850;
var state_23918__$1 = (function (){var statearr_23945 = state_23918;
(statearr_23945[(10)] = inst_23851);

(statearr_23945[(18)] = inst_23848);

(statearr_23945[(7)] = inst_23852);

(statearr_23945[(19)] = inst_23849);

(statearr_23945[(9)] = inst_23853);

return statearr_23945;
})();
var statearr_23946_23991 = state_23918__$1;
(statearr_23946_23991[(2)] = null);

(statearr_23946_23991[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (23))){
var inst_23859 = (state_23918[(16)]);
var inst_23885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23886 = [inst_23859];
var inst_23887 = (new cljs.core.PersistentVector(null,1,(5),inst_23885,inst_23886,null));
var inst_23888 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23887);
var state_23918__$1 = state_23918;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23918__$1,(26),inst_23888);
} else {
if((state_val_23919 === (19))){
var inst_23879 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
if(cljs.core.truth_(inst_23879)){
var statearr_23947_23992 = state_23918__$1;
(statearr_23947_23992[(1)] = (20));

} else {
var statearr_23948_23993 = state_23918__$1;
(statearr_23948_23993[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (11))){
var inst_23852 = (state_23918[(7)]);
var inst_23866 = (inst_23852 > limit);
var state_23918__$1 = state_23918;
var statearr_23950_23994 = state_23918__$1;
(statearr_23950_23994[(2)] = inst_23866);

(statearr_23950_23994[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (9))){
var inst_23864 = (state_23918[(17)]);
var inst_23864__$1 = limit;
var state_23918__$1 = (function (){var statearr_23951 = state_23918;
(statearr_23951[(17)] = inst_23864__$1);

return statearr_23951;
})();
if(cljs.core.truth_(inst_23864__$1)){
var statearr_23952_23995 = state_23918__$1;
(statearr_23952_23995[(1)] = (11));

} else {
var statearr_23953_23996 = state_23918__$1;
(statearr_23953_23996[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (5))){
var _ = (function (){var statearr_23954 = state_23918;
(statearr_23954[(4)] = cljs.core.rest.call(null,(state_23918[(4)])));

return statearr_23954;
})();
var state_23918__$1 = state_23918;
var ex23949 = (state_23918__$1[(2)]);
var statearr_23955_23997 = state_23918__$1;
(statearr_23955_23997[(5)] = ex23949);


if((ex23949 instanceof Error)){
var statearr_23956_23998 = state_23918__$1;
(statearr_23956_23998[(1)] = (4));

(statearr_23956_23998[(5)] = null);

} else {
throw ex23949;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (14))){
var inst_23853 = (state_23918[(9)]);
var state_23918__$1 = state_23918;
var statearr_23957_23999 = state_23918__$1;
(statearr_23957_23999[(2)] = inst_23853);

(statearr_23957_23999[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (26))){
var inst_23890 = (state_23918[(2)]);
var inst_23891 = fluree.db.util.async.throw_err.call(null,inst_23890);
var state_23918__$1 = (function (){var statearr_23958 = state_23918;
(statearr_23958[(11)] = inst_23891);

return statearr_23958;
})();
if(cljs.core.truth_(fuel)){
var statearr_23959_24000 = state_23918__$1;
(statearr_23959_24000[(1)] = (27));

} else {
var statearr_23960_24001 = state_23918__$1;
(statearr_23960_24001[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (16))){
var inst_23911 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
var statearr_23961_24002 = state_23918__$1;
(statearr_23961_24002[(2)] = inst_23911);

(statearr_23961_24002[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (30))){
var inst_23898 = (state_23918[(14)]);
var inst_23860 = (state_23918[(8)]);
var inst_23853 = (state_23918[(9)]);
var inst_23901 = (state_23918[(2)]);
var inst_23902 = fluree.db.util.async.throw_err.call(null,inst_23901);
var inst_23903 = cljs.core.conj.call(null,inst_23853,inst_23902);
var inst_23851 = inst_23860;
var inst_23852 = inst_23898;
var inst_23853__$1 = inst_23903;
var state_23918__$1 = (function (){var statearr_23962 = state_23918;
(statearr_23962[(10)] = inst_23851);

(statearr_23962[(7)] = inst_23852);

(statearr_23962[(9)] = inst_23853__$1);

return statearr_23962;
})();
var statearr_23963_24003 = state_23918__$1;
(statearr_23963_24003[(2)] = null);

(statearr_23963_24003[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (10))){
var inst_23871 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
if(cljs.core.truth_(inst_23871)){
var statearr_23964_24004 = state_23918__$1;
(statearr_23964_24004[(1)] = (14));

} else {
var statearr_23965_24005 = state_23918__$1;
(statearr_23965_24005[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (18))){
var inst_23874 = (state_23918[(12)]);
var state_23918__$1 = state_23918;
var statearr_23966_24006 = state_23918__$1;
(statearr_23966_24006[(2)] = inst_23874);

(statearr_23966_24006[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (8))){
var inst_23861 = (state_23918[(15)]);
var state_23918__$1 = state_23918;
var statearr_23967_24007 = state_23918__$1;
(statearr_23967_24007[(2)] = inst_23861);

(statearr_23967_24007[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2746__auto__ = null;
var fluree$db$query$fql$state_machine__2746__auto____0 = (function (){
var statearr_23968 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23968[(0)] = fluree$db$query$fql$state_machine__2746__auto__);

(statearr_23968[(1)] = (1));

return statearr_23968;
});
var fluree$db$query$fql$state_machine__2746__auto____1 = (function (state_23918){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23918);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23969){var ex__2749__auto__ = e23969;
var statearr_23970_24008 = state_23918;
(statearr_23970_24008[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23918[(4)]))){
var statearr_23971_24009 = state_23918;
(statearr_23971_24009[(1)] = cljs.core.first.call(null,(state_23918[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24010 = state_23918;
state_23918 = G__24010;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2746__auto__ = function(state_23918){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2746__auto____1.call(this,state_23918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2746__auto____0;
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2746__auto____1;
return fluree$db$query$fql$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23972 = f__2769__auto__.call(null);
(statearr_23972[(6)] = c__2768__auto__);

return statearr_23972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4253__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__24012 = arguments.length;
switch (G__24012) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.call(null,db,where_clause,null,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4 = (function (db,where_clause,default_collection,p__24013){
var map__24014 = p__24013;
var map__24014__$1 = cljs.core.__destructure_map.call(null,map__24014);
var limit = cljs.core.get.call(null,map__24014__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__24014__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24278){
var state_val_24279 = (state_24278[(1)]);
if((state_val_24279 === (65))){
var inst_24241 = (state_24278[(7)]);
var inst_24241__$1 = (state_24278[(2)]);
var state_24278__$1 = (function (){var statearr_24280 = state_24278;
(statearr_24280[(7)] = inst_24241__$1);

return statearr_24280;
})();
if(cljs.core.truth_(inst_24241__$1)){
var statearr_24281_24399 = state_24278__$1;
(statearr_24281_24399[(1)] = (66));

} else {
var statearr_24282_24400 = state_24278__$1;
(statearr_24282_24400[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (70))){
var inst_24244 = (state_24278[(8)]);
var state_24278__$1 = state_24278;
var statearr_24283_24401 = state_24278__$1;
(statearr_24283_24401[(2)] = inst_24244);

(statearr_24283_24401[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (62))){
var inst_24232 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
var statearr_24284_24402 = state_24278__$1;
(statearr_24284_24402[(2)] = inst_24232);

(statearr_24284_24402[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (74))){
var inst_24251 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
var statearr_24285_24403 = state_24278__$1;
(statearr_24285_24403[(2)] = inst_24251);

(statearr_24285_24403[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (7))){
var inst_24027 = (state_24278[(9)]);
var state_24278__$1 = state_24278;
var statearr_24286_24404 = state_24278__$1;
(statearr_24286_24404[(2)] = inst_24027);

(statearr_24286_24404[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (59))){
var inst_24056 = (state_24278[(10)]);
var inst_24224 = cljs.core.empty_QMARK_.call(null,inst_24056);
var state_24278__$1 = state_24278;
if(inst_24224){
var statearr_24287_24405 = state_24278__$1;
(statearr_24287_24405[(1)] = (60));

} else {
var statearr_24288_24406 = state_24278__$1;
(statearr_24288_24406[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (20))){
var state_24278__$1 = state_24278;
if(cljs.core.truth_(offset)){
var statearr_24289_24407 = state_24278__$1;
(statearr_24289_24407[(1)] = (23));

} else {
var statearr_24290_24408 = state_24278__$1;
(statearr_24290_24408[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (72))){
var inst_24041 = (state_24278[(11)]);
var inst_24221 = (state_24278[(12)]);
var inst_24247 = cljs.core.count.call(null,inst_24221);
var inst_24248 = (inst_24247 > inst_24041);
var state_24278__$1 = state_24278;
var statearr_24291_24409 = state_24278__$1;
(statearr_24291_24409[(2)] = inst_24248);

(statearr_24291_24409[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (58))){
var inst_24056 = (state_24278[(10)]);
var inst_24221 = (state_24278[(12)]);
var inst_24222 = cljs.core.into.call(null,inst_24056,inst_24221);
var state_24278__$1 = state_24278;
var statearr_24292_24410 = state_24278__$1;
(statearr_24292_24410[(2)] = inst_24222);

(statearr_24292_24410[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (60))){
var inst_24056 = (state_24278[(10)]);
var inst_24221 = (state_24278[(12)]);
var inst_24226 = cljs.core.into.call(null,inst_24056,inst_24221);
var state_24278__$1 = state_24278;
var statearr_24293_24411 = state_24278__$1;
(statearr_24293_24411[(2)] = inst_24226);

(statearr_24293_24411[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (27))){
var inst_24071 = (state_24278[(13)]);
var state_24278__$1 = state_24278;
var statearr_24294_24412 = state_24278__$1;
(statearr_24294_24412[(2)] = inst_24071);

(statearr_24294_24412[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (1))){
var state_24278__$1 = state_24278;
var statearr_24295_24413 = state_24278__$1;
(statearr_24295_24413[(2)] = null);

(statearr_24295_24413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (69))){
var inst_24041 = (state_24278[(11)]);
var state_24278__$1 = state_24278;
if(cljs.core.truth_(inst_24041)){
var statearr_24296_24414 = state_24278__$1;
(statearr_24296_24414[(1)] = (72));

} else {
var statearr_24297_24415 = state_24278__$1;
(statearr_24297_24415[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (24))){
var inst_24056 = (state_24278[(10)]);
var state_24278__$1 = state_24278;
var statearr_24298_24416 = state_24278__$1;
(statearr_24298_24416[(2)] = inst_24056);

(statearr_24298_24416[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (55))){
var inst_24210 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
var statearr_24299_24417 = state_24278__$1;
(statearr_24299_24417[(2)] = inst_24210);

(statearr_24299_24417[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (39))){
var inst_24218 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
var statearr_24300_24418 = state_24278__$1;
(statearr_24300_24418[(2)] = inst_24218);

(statearr_24300_24418[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (46))){
var inst_24082 = (state_24278[(14)]);
var inst_24100 = (state_24278[(15)]);
var inst_24176 = inst_24100.call(null,cljs.core._LT_,inst_24082);
var state_24278__$1 = state_24278;
if(cljs.core.truth_(inst_24176)){
var statearr_24301_24419 = state_24278__$1;
(statearr_24301_24419[(1)] = (49));

} else {
var statearr_24302_24420 = state_24278__$1;
(statearr_24302_24420[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (4))){
var inst_24015 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
var statearr_24303_24421 = state_24278__$1;
(statearr_24303_24421[(2)] = inst_24015);

(statearr_24303_24421[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (77))){
var inst_24266 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
var statearr_24304_24422 = state_24278__$1;
(statearr_24304_24422[(2)] = inst_24266);

(statearr_24304_24422[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (54))){
var inst_24208 = cljs.core.PersistentVector.EMPTY;
var state_24278__$1 = state_24278;
var statearr_24305_24423 = state_24278__$1;
(statearr_24305_24423[(2)] = inst_24208);

(statearr_24305_24423[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (15))){
var inst_24026 = (state_24278[(16)]);
var inst_24051 = cljs.core.seq.call(null,inst_24026);
var inst_24052 = cljs.core.first.call(null,inst_24051);
var inst_24053 = cljs.core.next.call(null,inst_24051);
var inst_24054 = cljs.core.PersistentHashSet.EMPTY;
var inst_24055 = inst_24026;
var inst_24056 = inst_24054;
var state_24278__$1 = (function (){var statearr_24306 = state_24278;
(statearr_24306[(17)] = inst_24052);

(statearr_24306[(10)] = inst_24056);

(statearr_24306[(18)] = inst_24055);

(statearr_24306[(19)] = inst_24053);

return statearr_24306;
})();
var statearr_24307_24424 = state_24278__$1;
(statearr_24307_24424[(2)] = null);

(statearr_24307_24424[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (48))){
var inst_24173 = (state_24278[(2)]);
var inst_24174 = fluree.db.util.async.throw_err.call(null,inst_24173);
var state_24278__$1 = state_24278;
var statearr_24308_24425 = state_24278__$1;
(statearr_24308_24425[(2)] = inst_24174);

(statearr_24308_24425[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (50))){
var inst_24082 = (state_24278[(14)]);
var inst_24100 = (state_24278[(15)]);
var inst_24192 = inst_24100.call(null,cljs.core._LT__EQ_,inst_24082);
var state_24278__$1 = state_24278;
if(cljs.core.truth_(inst_24192)){
var statearr_24309_24426 = state_24278__$1;
(statearr_24309_24426[(1)] = (53));

} else {
var statearr_24310_24427 = state_24278__$1;
(statearr_24310_24427[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (75))){
var state_24278__$1 = state_24278;
if(cljs.core.truth_(offset)){
var statearr_24311_24428 = state_24278__$1;
(statearr_24311_24428[(1)] = (78));

} else {
var statearr_24312_24429 = state_24278__$1;
(statearr_24312_24429[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (21))){
var inst_24081 = (state_24278[(20)]);
var inst_24062 = (state_24278[(21)]);
var inst_24081__$1 = cljs.core.nth.call(null,inst_24062,(0),null);
var inst_24082 = cljs.core.nth.call(null,inst_24062,(1),null);
var inst_24083 = cljs.core.nth.call(null,inst_24062,(2),null);
var inst_24084 = fluree.db.query.fql.valid_where_predicate_QMARK_.call(null,db,inst_24081__$1);
var inst_24085 = cljs.core.not.call(null,inst_24084);
var state_24278__$1 = (function (){var statearr_24313 = state_24278;
(statearr_24313[(22)] = inst_24083);

(statearr_24313[(20)] = inst_24081__$1);

(statearr_24313[(14)] = inst_24082);

return statearr_24313;
})();
if(inst_24085){
var statearr_24314_24430 = state_24278__$1;
(statearr_24314_24430[(1)] = (29));

} else {
var statearr_24315_24431 = state_24278__$1;
(statearr_24315_24431[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (31))){
var inst_24082 = (state_24278[(14)]);
var inst_24100 = (state_24278[(15)]);
var inst_24096 = (state_24278[(2)]);
var inst_24100__$1 = cljs.core.identical_QMARK_;
var inst_24101 = inst_24100__$1.call(null,cljs.core.not_EQ_,inst_24082);
var state_24278__$1 = (function (){var statearr_24316 = state_24278;
(statearr_24316[(23)] = inst_24096);

(statearr_24316[(15)] = inst_24100__$1);

return statearr_24316;
})();
if(cljs.core.truth_(inst_24101)){
var statearr_24317_24432 = state_24278__$1;
(statearr_24317_24432[(1)] = (32));

} else {
var statearr_24318_24433 = state_24278__$1;
(statearr_24318_24433[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (32))){
var inst_24083 = (state_24278[(22)]);
var inst_24081 = (state_24278[(20)]);
var inst_24041 = (state_24278[(11)]);
var inst_24103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24104 = [inst_24081,inst_24083];
var inst_24105 = (new cljs.core.PersistentVector(null,2,(5),inst_24103,inst_24104,null));
var inst_24106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24107 = [inst_24081];
var inst_24108 = (new cljs.core.PersistentVector(null,1,(5),inst_24106,inst_24107,null));
var inst_24109 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24110 = [inst_24041];
var inst_24111 = cljs.core.PersistentHashMap.fromArrays(inst_24109,inst_24110);
var inst_24112 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24105,cljs.core._LT__EQ_,inst_24108,inst_24111);
var state_24278__$1 = state_24278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24278__$1,(35),inst_24112);
} else {
if((state_val_24279 === (40))){
var inst_24141 = (state_24278[(2)]);
var inst_24142 = fluree.db.util.async.throw_err.call(null,inst_24141);
var state_24278__$1 = state_24278;
var statearr_24319_24434 = state_24278__$1;
(statearr_24319_24434[(2)] = inst_24142);

(statearr_24319_24434[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (56))){
var inst_24205 = (state_24278[(2)]);
var inst_24206 = fluree.db.util.async.throw_err.call(null,inst_24205);
var state_24278__$1 = state_24278;
var statearr_24320_24435 = state_24278__$1;
(statearr_24320_24435[(2)] = inst_24206);

(statearr_24320_24435[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (33))){
var inst_24082 = (state_24278[(14)]);
var inst_24100 = (state_24278[(15)]);
var inst_24131 = inst_24100.call(null,cljs.core._EQ_,inst_24082);
var state_24278__$1 = state_24278;
if(cljs.core.truth_(inst_24131)){
var statearr_24321_24436 = state_24278__$1;
(statearr_24321_24436[(1)] = (37));

} else {
var statearr_24322_24437 = state_24278__$1;
(statearr_24322_24437[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (13))){
var state_24278__$1 = state_24278;
var statearr_24323_24438 = state_24278__$1;
(statearr_24323_24438[(2)] = limit);

(statearr_24323_24438[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (22))){
var inst_24268 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
var statearr_24324_24439 = state_24278__$1;
(statearr_24324_24439[(2)] = inst_24268);

(statearr_24324_24439[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (36))){
var inst_24115 = (state_24278[(24)]);
var inst_24127 = (state_24278[(2)]);
var inst_24128 = fluree.db.util.async.throw_err.call(null,inst_24127);
var inst_24129 = cljs.core.concat.call(null,inst_24115,inst_24128);
var state_24278__$1 = state_24278;
var statearr_24325_24440 = state_24278__$1;
(statearr_24325_24440[(2)] = inst_24129);

(statearr_24325_24440[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (41))){
var inst_24083 = (state_24278[(22)]);
var inst_24081 = (state_24278[(20)]);
var inst_24041 = (state_24278[(11)]);
var inst_24146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24147 = [inst_24081,inst_24083];
var inst_24148 = (new cljs.core.PersistentVector(null,2,(5),inst_24146,inst_24147,null));
var inst_24149 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24150 = [inst_24081];
var inst_24151 = (new cljs.core.PersistentVector(null,1,(5),inst_24149,inst_24150,null));
var inst_24152 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24153 = [inst_24041];
var inst_24154 = cljs.core.PersistentHashMap.fromArrays(inst_24152,inst_24153);
var inst_24155 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24148,cljs.core._LT__EQ_,inst_24151,inst_24154);
var state_24278__$1 = state_24278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24278__$1,(44),inst_24155);
} else {
if((state_val_24279 === (43))){
var inst_24216 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
var statearr_24326_24441 = state_24278__$1;
(statearr_24326_24441[(2)] = inst_24216);

(statearr_24326_24441[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (61))){
var inst_24056 = (state_24278[(10)]);
var inst_24221 = (state_24278[(12)]);
var inst_24228 = cljs.core.PersistentHashSet.EMPTY;
var inst_24229 = cljs.core.into.call(null,inst_24228,inst_24221);
var inst_24230 = clojure.set.intersection.call(null,inst_24056,inst_24229);
var state_24278__$1 = state_24278;
var statearr_24327_24442 = state_24278__$1;
(statearr_24327_24442[(2)] = inst_24230);

(statearr_24327_24442[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (29))){
var inst_24081 = (state_24278[(20)]);
var inst_24087 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_24081);
var inst_24088 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24087)].join('');
var inst_24089 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24090 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_24091 = cljs.core.PersistentHashMap.fromArrays(inst_24089,inst_24090);
var inst_24092 = cljs.core.ex_info.call(null,inst_24088,inst_24091);
var inst_24093 = (function(){throw inst_24092})();
var state_24278__$1 = state_24278;
var statearr_24328_24443 = state_24278__$1;
(statearr_24328_24443[(2)] = inst_24093);

(statearr_24328_24443[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (44))){
var inst_24157 = (state_24278[(2)]);
var inst_24158 = fluree.db.util.async.throw_err.call(null,inst_24157);
var state_24278__$1 = state_24278;
var statearr_24329_24444 = state_24278__$1;
(statearr_24329_24444[(2)] = inst_24158);

(statearr_24329_24444[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (6))){
var inst_24025 = (state_24278[(25)]);
var inst_24029 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_24025);
var state_24278__$1 = state_24278;
var statearr_24330_24445 = state_24278__$1;
(statearr_24330_24445[(2)] = inst_24029);

(statearr_24330_24445[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (28))){
var inst_24076 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
var statearr_24331_24446 = state_24278__$1;
(statearr_24331_24446[(2)] = inst_24076);

(statearr_24331_24446[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (64))){
var inst_24236 = (state_24278[(26)]);
var state_24278__$1 = state_24278;
var statearr_24332_24447 = state_24278__$1;
(statearr_24332_24447[(2)] = inst_24236);

(statearr_24332_24447[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (51))){
var inst_24212 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
var statearr_24333_24448 = state_24278__$1;
(statearr_24333_24448[(2)] = inst_24212);

(statearr_24333_24448[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (25))){
var inst_24071 = (state_24278[(2)]);
var state_24278__$1 = (function (){var statearr_24334 = state_24278;
(statearr_24334[(13)] = inst_24071);

return statearr_24334;
})();
if(cljs.core.truth_(limit)){
var statearr_24335_24449 = state_24278__$1;
(statearr_24335_24449[(1)] = (26));

} else {
var statearr_24336_24450 = state_24278__$1;
(statearr_24336_24450[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (34))){
var inst_24025 = (state_24278[(25)]);
var inst_24220 = (state_24278[(2)]);
var inst_24221 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_24220);
var state_24278__$1 = (function (){var statearr_24337 = state_24278;
(statearr_24337[(12)] = inst_24221);

return statearr_24337;
})();
var G__24338_24451 = inst_24025;
var G__24338_24452__$1 = (((G__24338_24451 instanceof cljs.core.Keyword))?G__24338_24451.fqn:null);
switch (G__24338_24452__$1) {
case "or":
var statearr_24339_24454 = state_24278__$1;
(statearr_24339_24454[(1)] = (58));


break;
case "and":
var statearr_24340_24455 = state_24278__$1;
(statearr_24340_24455[(1)] = (59));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24338_24452__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (17))){
var inst_24273 = (state_24278[(2)]);
var _ = (function (){var statearr_24341 = state_24278;
(statearr_24341[(4)] = cljs.core.rest.call(null,(state_24278[(4)])));

return statearr_24341;
})();
var state_24278__$1 = state_24278;
var statearr_24342_24456 = state_24278__$1;
(statearr_24342_24456[(2)] = inst_24273);

(statearr_24342_24456[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (3))){
var inst_24276 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24278__$1,inst_24276);
} else {
if((state_val_24279 === (12))){
var inst_24035 = (offset + limit);
var state_24278__$1 = state_24278;
var statearr_24343_24457 = state_24278__$1;
(statearr_24343_24457[(2)] = inst_24035);

(statearr_24343_24457[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (2))){
var inst_24027 = (state_24278[(9)]);
var _ = (function (){var statearr_24344 = state_24278;
(statearr_24344[(4)] = cljs.core.cons.call(null,(5),(state_24278[(4)])));

return statearr_24344;
})();
var inst_24024 = fluree.db.query.fql_parser.parse_where.call(null,db,where_clause,default_collection);
var inst_24025 = cljs.core.nth.call(null,inst_24024,(0),null);
var inst_24026 = cljs.core.nth.call(null,inst_24024,(1),null);
var inst_24027__$1 = limit;
var state_24278__$1 = (function (){var statearr_24345 = state_24278;
(statearr_24345[(9)] = inst_24027__$1);

(statearr_24345[(16)] = inst_24026);

(statearr_24345[(25)] = inst_24025);

return statearr_24345;
})();
if(cljs.core.truth_(inst_24027__$1)){
var statearr_24346_24458 = state_24278__$1;
(statearr_24346_24458[(1)] = (6));

} else {
var statearr_24347_24459 = state_24278__$1;
(statearr_24347_24459[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (66))){
var inst_24241 = (state_24278[(7)]);
var state_24278__$1 = state_24278;
var statearr_24348_24460 = state_24278__$1;
(statearr_24348_24460[(2)] = inst_24241);

(statearr_24348_24460[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (23))){
var inst_24056 = (state_24278[(10)]);
var inst_24068 = cljs.core.drop.call(null,offset,inst_24056);
var state_24278__$1 = state_24278;
var statearr_24349_24461 = state_24278__$1;
(statearr_24349_24461[(2)] = inst_24068);

(statearr_24349_24461[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (47))){
var inst_24214 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
var statearr_24350_24462 = state_24278__$1;
(statearr_24350_24462[(2)] = inst_24214);

(statearr_24350_24462[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (35))){
var inst_24083 = (state_24278[(22)]);
var inst_24081 = (state_24278[(20)]);
var inst_24041 = (state_24278[(11)]);
var inst_24114 = (state_24278[(2)]);
var inst_24115 = fluree.db.util.async.throw_err.call(null,inst_24114);
var inst_24116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24117 = [inst_24081];
var inst_24118 = (new cljs.core.PersistentVector(null,1,(5),inst_24116,inst_24117,null));
var inst_24119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24120 = [inst_24081,inst_24083];
var inst_24121 = (new cljs.core.PersistentVector(null,2,(5),inst_24119,inst_24120,null));
var inst_24122 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24123 = [inst_24041];
var inst_24124 = cljs.core.PersistentHashMap.fromArrays(inst_24122,inst_24123);
var inst_24125 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24118,cljs.core._LT_,inst_24121,inst_24124);
var state_24278__$1 = (function (){var statearr_24351 = state_24278;
(statearr_24351[(24)] = inst_24115);

return statearr_24351;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24278__$1,(36),inst_24125);
} else {
if((state_val_24279 === (76))){
var inst_24235 = (state_24278[(27)]);
var inst_24063 = (state_24278[(28)]);
var inst_24055 = inst_24063;
var inst_24056 = inst_24235;
var state_24278__$1 = (function (){var statearr_24352 = state_24278;
(statearr_24352[(10)] = inst_24056);

(statearr_24352[(18)] = inst_24055);

return statearr_24352;
})();
var statearr_24353_24463 = state_24278__$1;
(statearr_24353_24463[(2)] = null);

(statearr_24353_24463[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (19))){
var inst_24270 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
var statearr_24354_24464 = state_24278__$1;
(statearr_24354_24464[(2)] = inst_24270);

(statearr_24354_24464[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (57))){
var inst_24025 = (state_24278[(25)]);
var inst_24236 = (state_24278[(26)]);
var inst_24235 = (state_24278[(2)]);
var inst_24236__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_24025);
var state_24278__$1 = (function (){var statearr_24355 = state_24278;
(statearr_24355[(27)] = inst_24235);

(statearr_24355[(26)] = inst_24236__$1);

return statearr_24355;
})();
if(inst_24236__$1){
var statearr_24356_24465 = state_24278__$1;
(statearr_24356_24465[(1)] = (63));

} else {
var statearr_24357_24466 = state_24278__$1;
(statearr_24357_24466[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (68))){
var inst_24256 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
if(cljs.core.truth_(inst_24256)){
var statearr_24358_24467 = state_24278__$1;
(statearr_24358_24467[(1)] = (75));

} else {
var statearr_24359_24468 = state_24278__$1;
(statearr_24359_24468[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (11))){
var inst_24026 = (state_24278[(16)]);
var inst_24041 = (state_24278[(2)]);
var inst_24042 = cljs.core.not_empty.call(null,inst_24026);
var state_24278__$1 = (function (){var statearr_24361 = state_24278;
(statearr_24361[(11)] = inst_24041);

return statearr_24361;
})();
if(cljs.core.truth_(inst_24042)){
var statearr_24362_24469 = state_24278__$1;
(statearr_24362_24469[(1)] = (15));

} else {
var statearr_24363_24470 = state_24278__$1;
(statearr_24363_24470[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (9))){
var state_24278__$1 = state_24278;
if(cljs.core.truth_(offset)){
var statearr_24364_24471 = state_24278__$1;
(statearr_24364_24471[(1)] = (12));

} else {
var statearr_24365_24472 = state_24278__$1;
(statearr_24365_24472[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (5))){
var _ = (function (){var statearr_24366 = state_24278;
(statearr_24366[(4)] = cljs.core.rest.call(null,(state_24278[(4)])));

return statearr_24366;
})();
var state_24278__$1 = state_24278;
var ex24360 = (state_24278__$1[(2)]);
var statearr_24367_24473 = state_24278__$1;
(statearr_24367_24473[(5)] = ex24360);


if((ex24360 instanceof Error)){
var statearr_24368_24474 = state_24278__$1;
(statearr_24368_24474[(1)] = (4));

(statearr_24368_24474[(5)] = null);

} else {
throw ex24360;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (14))){
var inst_24038 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
var statearr_24369_24475 = state_24278__$1;
(statearr_24369_24475[(2)] = inst_24038);

(statearr_24369_24475[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (45))){
var inst_24083 = (state_24278[(22)]);
var inst_24081 = (state_24278[(20)]);
var inst_24041 = (state_24278[(11)]);
var inst_24162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24163 = [inst_24081,inst_24083];
var inst_24164 = (new cljs.core.PersistentVector(null,2,(5),inst_24162,inst_24163,null));
var inst_24165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24166 = [inst_24081];
var inst_24167 = (new cljs.core.PersistentVector(null,1,(5),inst_24165,inst_24166,null));
var inst_24168 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24169 = [inst_24041];
var inst_24170 = cljs.core.PersistentHashMap.fromArrays(inst_24168,inst_24169);
var inst_24171 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24164,cljs.core._LT__EQ_,inst_24167,inst_24170);
var state_24278__$1 = state_24278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24278__$1,(48),inst_24171);
} else {
if((state_val_24279 === (53))){
var inst_24083 = (state_24278[(22)]);
var inst_24081 = (state_24278[(20)]);
var inst_24041 = (state_24278[(11)]);
var inst_24194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24195 = [inst_24081];
var inst_24196 = (new cljs.core.PersistentVector(null,1,(5),inst_24194,inst_24195,null));
var inst_24197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24198 = [inst_24081,inst_24083];
var inst_24199 = (new cljs.core.PersistentVector(null,2,(5),inst_24197,inst_24198,null));
var inst_24200 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24201 = [inst_24041];
var inst_24202 = cljs.core.PersistentHashMap.fromArrays(inst_24200,inst_24201);
var inst_24203 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24196,cljs.core._LT__EQ_,inst_24199,inst_24202);
var state_24278__$1 = state_24278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24278__$1,(56),inst_24203);
} else {
if((state_val_24279 === (78))){
var inst_24235 = (state_24278[(27)]);
var inst_24259 = cljs.core.drop.call(null,offset,inst_24235);
var state_24278__$1 = state_24278;
var statearr_24370_24476 = state_24278__$1;
(statearr_24370_24476[(2)] = inst_24259);

(statearr_24370_24476[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (26))){
var inst_24071 = (state_24278[(13)]);
var inst_24073 = cljs.core.take.call(null,limit,inst_24071);
var state_24278__$1 = state_24278;
var statearr_24371_24477 = state_24278__$1;
(statearr_24371_24477[(2)] = inst_24073);

(statearr_24371_24477[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (16))){
var state_24278__$1 = state_24278;
var statearr_24372_24478 = state_24278__$1;
(statearr_24372_24478[(2)] = null);

(statearr_24372_24478[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (79))){
var inst_24235 = (state_24278[(27)]);
var state_24278__$1 = state_24278;
var statearr_24373_24479 = state_24278__$1;
(statearr_24373_24479[(2)] = inst_24235);

(statearr_24373_24479[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (38))){
var inst_24082 = (state_24278[(14)]);
var inst_24100 = (state_24278[(15)]);
var inst_24144 = inst_24100.call(null,cljs.core._GT_,inst_24082);
var state_24278__$1 = state_24278;
if(cljs.core.truth_(inst_24144)){
var statearr_24374_24480 = state_24278__$1;
(statearr_24374_24480[(1)] = (41));

} else {
var statearr_24375_24481 = state_24278__$1;
(statearr_24375_24481[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (30))){
var state_24278__$1 = state_24278;
var statearr_24376_24482 = state_24278__$1;
(statearr_24376_24482[(2)] = null);

(statearr_24376_24482[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (73))){
var inst_24041 = (state_24278[(11)]);
var state_24278__$1 = state_24278;
var statearr_24377_24483 = state_24278__$1;
(statearr_24377_24483[(2)] = inst_24041);

(statearr_24377_24483[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (10))){
var state_24278__$1 = state_24278;
var statearr_24378_24484 = state_24278__$1;
(statearr_24378_24484[(2)] = null);

(statearr_24378_24484[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (18))){
var inst_24062 = (state_24278[(21)]);
var inst_24055 = (state_24278[(18)]);
var inst_24061 = cljs.core.seq.call(null,inst_24055);
var inst_24062__$1 = cljs.core.first.call(null,inst_24061);
var inst_24063 = cljs.core.next.call(null,inst_24061);
var inst_24064 = cljs.core.not.call(null,inst_24062__$1);
var state_24278__$1 = (function (){var statearr_24379 = state_24278;
(statearr_24379[(21)] = inst_24062__$1);

(statearr_24379[(28)] = inst_24063);

return statearr_24379;
})();
if(inst_24064){
var statearr_24380_24485 = state_24278__$1;
(statearr_24380_24485[(1)] = (20));

} else {
var statearr_24381_24486 = state_24278__$1;
(statearr_24381_24486[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (52))){
var inst_24189 = (state_24278[(2)]);
var inst_24190 = fluree.db.util.async.throw_err.call(null,inst_24189);
var state_24278__$1 = state_24278;
var statearr_24382_24487 = state_24278__$1;
(statearr_24382_24487[(2)] = inst_24190);

(statearr_24382_24487[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (67))){
var inst_24025 = (state_24278[(25)]);
var inst_24244 = (state_24278[(8)]);
var inst_24244__$1 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_24025);
var state_24278__$1 = (function (){var statearr_24383 = state_24278;
(statearr_24383[(8)] = inst_24244__$1);

return statearr_24383;
})();
if(inst_24244__$1){
var statearr_24384_24488 = state_24278__$1;
(statearr_24384_24488[(1)] = (69));

} else {
var statearr_24385_24489 = state_24278__$1;
(statearr_24385_24489[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (71))){
var inst_24254 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
var statearr_24386_24490 = state_24278__$1;
(statearr_24386_24490[(2)] = inst_24254);

(statearr_24386_24490[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (42))){
var inst_24082 = (state_24278[(14)]);
var inst_24100 = (state_24278[(15)]);
var inst_24160 = inst_24100.call(null,cljs.core._GT__EQ_,inst_24082);
var state_24278__$1 = state_24278;
if(cljs.core.truth_(inst_24160)){
var statearr_24387_24491 = state_24278__$1;
(statearr_24387_24491[(1)] = (45));

} else {
var statearr_24388_24492 = state_24278__$1;
(statearr_24388_24492[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (80))){
var inst_24262 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
var statearr_24389_24493 = state_24278__$1;
(statearr_24389_24493[(2)] = inst_24262);

(statearr_24389_24493[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (37))){
var inst_24083 = (state_24278[(22)]);
var inst_24081 = (state_24278[(20)]);
var inst_24041 = (state_24278[(11)]);
var inst_24133 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24134 = [inst_24081,inst_24083];
var inst_24135 = (new cljs.core.PersistentVector(null,2,(5),inst_24133,inst_24134,null));
var inst_24136 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24137 = [inst_24041];
var inst_24138 = cljs.core.PersistentHashMap.fromArrays(inst_24136,inst_24137);
var inst_24139 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_24135,inst_24138);
var state_24278__$1 = state_24278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24278__$1,(40),inst_24139);
} else {
if((state_val_24279 === (63))){
var inst_24235 = (state_24278[(27)]);
var inst_24238 = cljs.core.empty_QMARK_.call(null,inst_24235);
var state_24278__$1 = state_24278;
var statearr_24390_24494 = state_24278__$1;
(statearr_24390_24494[(2)] = inst_24238);

(statearr_24390_24494[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (8))){
var inst_24032 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
if(cljs.core.truth_(inst_24032)){
var statearr_24391_24495 = state_24278__$1;
(statearr_24391_24495[(1)] = (9));

} else {
var statearr_24392_24496 = state_24278__$1;
(statearr_24392_24496[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (49))){
var inst_24083 = (state_24278[(22)]);
var inst_24081 = (state_24278[(20)]);
var inst_24041 = (state_24278[(11)]);
var inst_24178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24179 = [inst_24081];
var inst_24180 = (new cljs.core.PersistentVector(null,1,(5),inst_24178,inst_24179,null));
var inst_24181 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24182 = [inst_24081,inst_24083];
var inst_24183 = (new cljs.core.PersistentVector(null,2,(5),inst_24181,inst_24182,null));
var inst_24184 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24185 = [inst_24041];
var inst_24186 = cljs.core.PersistentHashMap.fromArrays(inst_24184,inst_24185);
var inst_24187 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24180,cljs.core._LT_,inst_24183,inst_24186);
var state_24278__$1 = state_24278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24278__$1,(52),inst_24187);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2746__auto__ = null;
var fluree$db$query$fql$state_machine__2746__auto____0 = (function (){
var statearr_24393 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24393[(0)] = fluree$db$query$fql$state_machine__2746__auto__);

(statearr_24393[(1)] = (1));

return statearr_24393;
});
var fluree$db$query$fql$state_machine__2746__auto____1 = (function (state_24278){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24278);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24394){var ex__2749__auto__ = e24394;
var statearr_24395_24497 = state_24278;
(statearr_24395_24497[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24278[(4)]))){
var statearr_24396_24498 = state_24278;
(statearr_24396_24498[(1)] = cljs.core.first.call(null,(state_24278[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24499 = state_24278;
state_24278 = G__24499;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2746__auto__ = function(state_24278){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2746__auto____1.call(this,state_24278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2746__auto____0;
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2746__auto____1;
return fluree$db$query$fql$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24397 = f__2769__auto__.call(null);
(statearr_24397[(6)] = c__2768__auto__);

return statearr_24397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 4);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,cljs.core.keys.call(null,x))))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.call(null,cljs.core.first.call(null,cljs.core.keys.call(null,x)));
var ___$1 = (cljs.core.truth_(valid_var.call(null,var_as_symbol))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first.call(null,cljs.core.vals.call(null,x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4253__auto__ = cljs.core.every_QMARK_.call(null,(function (p1__24500_SHARP_){
return ((typeof p1__24500_SHARP_ === 'string') || (cljs.core.map_QMARK_.call(null,p1__24500_SHARP_)));
}),select_smt);
if(or__4253__auto__){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set.call(null,vars);
var all_vars = cljs.core.set.call(null,cljs.core.concat.call(null,vars__$1,cljs.core.keys.call(null,interim_vars)));
return cljs.core.map.call(null,(function (select){
var var_symbol = ((cljs.core.map_QMARK_.call(null,select))?null:cljs.core.symbol.call(null,select));
if(cljs.core.truth_(vars__$1.call(null,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_.call(null,select))){
return fluree.db.query.analytical.parse_aggregate.call(null,select,vars__$1);
} else {
if(cljs.core.map_QMARK_.call(null,select)){
return fluree.db.query.fql.parse_map.call(null,select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.call(null,interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.call(null,interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__24501_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__24501_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__24505 = vars;
var vec__24506 = G__24505;
var seq__24507 = cljs.core.seq.call(null,vec__24506);
var first__24508 = cljs.core.first.call(null,seq__24507);
var seq__24507__$1 = cljs.core.next.call(null,seq__24507);
var var$ = first__24508;
var r = seq__24507__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24505__$1 = G__24505;
var all_vars__$1 = all_vars;
while(true){
var vec__24512 = G__24505__$1;
var seq__24513 = cljs.core.seq.call(null,vec__24512);
var first__24514 = cljs.core.first.call(null,seq__24513);
var seq__24513__$1 = cljs.core.next.call(null,seq__24513);
var var$__$1 = first__24514;
var r__$1 = seq__24513__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__24515 = r__$1;
var G__24516 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__24505__$1 = G__24515;
all_vars__$1 = G__24516;
continue;
} else {
var G__24517 = r__$1;
var G__24518 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__24505__$1 = G__24517;
all_vars__$1 = G__24518;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24553){
var state_val_24554 = (state_24553[(1)]);
if((state_val_24554 === (1))){
var inst_24526 = functionArray;
var inst_24527 = cljs.core.seq.call(null,inst_24526);
var inst_24528 = cljs.core.first.call(null,inst_24527);
var inst_24529 = cljs.core.next.call(null,inst_24527);
var inst_24530 = cljs.core.PersistentVector.EMPTY;
var inst_24531 = inst_24526;
var inst_24532 = inst_24530;
var state_24553__$1 = (function (){var statearr_24555 = state_24553;
(statearr_24555[(7)] = inst_24528);

(statearr_24555[(8)] = inst_24531);

(statearr_24555[(9)] = inst_24532);

(statearr_24555[(10)] = inst_24529);

return statearr_24555;
})();
var statearr_24556_24569 = state_24553__$1;
(statearr_24556_24569[(2)] = null);

(statearr_24556_24569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24554 === (2))){
var inst_24538 = (state_24553[(11)]);
var inst_24531 = (state_24553[(8)]);
var inst_24537 = cljs.core.seq.call(null,inst_24531);
var inst_24538__$1 = cljs.core.first.call(null,inst_24537);
var inst_24539 = cljs.core.next.call(null,inst_24537);
var state_24553__$1 = (function (){var statearr_24557 = state_24553;
(statearr_24557[(11)] = inst_24538__$1);

(statearr_24557[(12)] = inst_24539);

return statearr_24557;
})();
if(cljs.core.truth_(inst_24538__$1)){
var statearr_24558_24570 = state_24553__$1;
(statearr_24558_24570[(1)] = (4));

} else {
var statearr_24559_24571 = state_24553__$1;
(statearr_24559_24571[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24554 === (3))){
var inst_24551 = (state_24553[(2)]);
var state_24553__$1 = state_24553;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24553__$1,inst_24551);
} else {
if((state_val_24554 === (4))){
var inst_24538 = (state_24553[(11)]);
var inst_24541 = inst_24538.call(null,tuple);
var state_24553__$1 = state_24553;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24553__$1,(7),inst_24541);
} else {
if((state_val_24554 === (5))){
var inst_24532 = (state_24553[(9)]);
var state_24553__$1 = state_24553;
var statearr_24560_24572 = state_24553__$1;
(statearr_24560_24572[(2)] = inst_24532);

(statearr_24560_24572[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24554 === (6))){
var inst_24549 = (state_24553[(2)]);
var state_24553__$1 = state_24553;
var statearr_24561_24573 = state_24553__$1;
(statearr_24561_24573[(2)] = inst_24549);

(statearr_24561_24573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24554 === (7))){
var inst_24539 = (state_24553[(12)]);
var inst_24532 = (state_24553[(9)]);
var inst_24543 = (state_24553[(2)]);
var inst_24544 = fluree.db.util.async.throw_err.call(null,inst_24543);
var inst_24545 = cljs.core.conj.call(null,inst_24532,inst_24544);
var inst_24531 = inst_24539;
var inst_24532__$1 = inst_24545;
var state_24553__$1 = (function (){var statearr_24562 = state_24553;
(statearr_24562[(8)] = inst_24531);

(statearr_24562[(9)] = inst_24532__$1);

return statearr_24562;
})();
var statearr_24563_24574 = state_24553__$1;
(statearr_24563_24574[(2)] = null);

(statearr_24563_24574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2746__auto____0 = (function (){
var statearr_24564 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24564[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2746__auto__);

(statearr_24564[(1)] = (1));

return statearr_24564;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2746__auto____1 = (function (state_24553){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24553);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24565){var ex__2749__auto__ = e24565;
var statearr_24566_24575 = state_24553;
(statearr_24566_24575[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24553[(4)]))){
var statearr_24567_24576 = state_24553;
(statearr_24567_24576[(1)] = cljs.core.first.call(null,(state_24553[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24577 = state_24553;
state_24553 = G__24577;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2746__auto__ = function(state_24553){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2746__auto____1.call(this,state_24553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2746__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2746__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24568 = f__2769__auto__.call(null);
(statearr_24568[(6)] = c__2768__auto__);

return statearr_24568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.call(null,(function (idx,select_item){
var temp__5753__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.call(null,pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__24578){
var vec__24579 = p__24578;
var tuple_index = cljs.core.nth.call(null,vec__24579,(0),null);
var query_map = cljs.core.nth.call(null,vec__24579,(1),null);
var temp__5753__auto__ = cljs.core.get.call(null,tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24593){
var state_val_24594 = (state_24593[(1)]);
if((state_val_24594 === (1))){
var inst_24582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24583 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24584 = [query_map,_id,query_opts];
var inst_24585 = cljs.core.PersistentHashMap.fromArrays(inst_24583,inst_24584);
var inst_24586 = fluree.db.query.fql.query.call(null,db,inst_24585);
var state_24593__$1 = (function (){var statearr_24595 = state_24593;
(statearr_24595[(7)] = inst_24582);

return statearr_24595;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24593__$1,(2),inst_24586);
} else {
if((state_val_24594 === (2))){
var inst_24582 = (state_24593[(7)]);
var inst_24588 = (state_24593[(2)]);
var inst_24589 = fluree.db.util.async.throw_err.call(null,inst_24588);
var inst_24590 = [tuple_index,inst_24589];
var inst_24591 = (new cljs.core.PersistentVector(null,2,(5),inst_24582,inst_24590,null));
var state_24593__$1 = state_24593;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24593__$1,inst_24591);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0 = (function (){
var statearr_24596 = [null,null,null,null,null,null,null,null];
(statearr_24596[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2746__auto__);

(statearr_24596[(1)] = (1));

return statearr_24596;
});
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1 = (function (state_24593){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24593);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24597){var ex__2749__auto__ = e24597;
var statearr_24598_24601 = state_24593;
(statearr_24598_24601[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24593[(4)]))){
var statearr_24599_24602 = state_24593;
(statearr_24599_24602[(1)] = cljs.core.first.call(null,(state_24593[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24603 = state_24593;
state_24593 = G__24603;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__ = function(state_24593){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1.call(this,state_24593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24600 = f__2769__auto__.call(null);
(statearr_24600[(6)] = c__2768__auto__);

return statearr_24600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_.call(null,expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__24604 = expand_map_tuple;
var tuple_index = cljs.core.nth.call(null,vec__24604,(0),null);
var query_map_result = cljs.core.nth.call(null,vec__24604,(1),null);
return cljs.core.assoc.call(null,tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24667){
var state_val_24668 = (state_24667[(1)]);
if((state_val_24668 === (7))){
var inst_24662 = (state_24667[(2)]);
var _ = (function (){var statearr_24669 = state_24667;
(statearr_24669[(4)] = cljs.core.rest.call(null,(state_24667[(4)])));

return statearr_24669;
})();
var state_24667__$1 = state_24667;
var statearr_24670_24761 = state_24667__$1;
(statearr_24670_24761[(2)] = inst_24662);

(statearr_24670_24761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (20))){
var inst_24653 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24671_24762 = state_24667__$1;
(statearr_24671_24762[(2)] = inst_24653);

(statearr_24671_24762[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (1))){
var state_24667__$1 = state_24667;
var statearr_24672_24763 = state_24667__$1;
(statearr_24672_24763[(2)] = null);

(statearr_24672_24763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (4))){
var inst_24609 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24673_24764 = state_24667__$1;
(statearr_24673_24764[(2)] = inst_24609);

(statearr_24673_24764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (15))){
var inst_24629 = (state_24667[(7)]);
var inst_24638 = cljs.core.second.call(null,inst_24629);
var inst_24639 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_24638);
var inst_24640 = (inst_24639 > max_fuel);
var state_24667__$1 = state_24667;
if(cljs.core.truth_(inst_24640)){
var statearr_24674_24765 = state_24667__$1;
(statearr_24674_24765[(1)] = (18));

} else {
var statearr_24675_24766 = state_24667__$1;
(statearr_24675_24766[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (13))){
var state_24667__$1 = state_24667;
var statearr_24676_24767 = state_24667__$1;
(statearr_24676_24767[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (6))){
var inst_24617 = (state_24667[(8)]);
var state_24667__$1 = state_24667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24667__$1,(8),inst_24617);
} else {
if((state_val_24668 === (17))){
var inst_24656 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24678_24768 = state_24667__$1;
(statearr_24678_24768[(2)] = inst_24656);

(statearr_24678_24768[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (3))){
var inst_24665 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24667__$1,inst_24665);
} else {
if((state_val_24668 === (12))){
var inst_24618 = (state_24667[(9)]);
var inst_24629 = (state_24667[(7)]);
var inst_24635 = inst_24618.call(null);
var state_24667__$1 = (function (){var statearr_24679 = state_24667;
(statearr_24679[(10)] = inst_24635);

return statearr_24679;
})();
var statearr_24680_24769 = state_24667__$1;
(statearr_24680_24769[(2)] = inst_24629);

(statearr_24680_24769[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (2))){
var inst_24618 = (state_24667[(9)]);
var inst_24617 = (state_24667[(8)]);
var _ = (function (){var statearr_24681 = state_24667;
(statearr_24681[(4)] = cljs.core.cons.call(null,(5),(state_24667[(4)])));

return statearr_24681;
})();
var inst_24615 = fluree.db.query.fql.build_expand_map.call(null,select,pp_keys);
var inst_24616 = cljs.core.async.chan.call(null);
var inst_24617__$1 = cljs.core.async.chan.call(null);
var inst_24618__$1 = (function (){var expandMaps = inst_24615;
var queue_ch = inst_24616;
var res_ch = inst_24617__$1;
return (function (){
cljs.core.async.close_BANG_.call(null,queue_ch);

return cljs.core.async.close_BANG_.call(null,res_ch);
});
})();
var inst_24619 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_24620 = cljs.core.volatile_BANG_.call(null,(0));
var inst_24621 = cljs.core.assoc.call(null,inst_24619,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_24620);
var inst_24622 = (function (){var expandMaps = inst_24615;
var queue_ch = inst_24616;
var res_ch = inst_24617__$1;
var stop_BANG_ = inst_24618__$1;
var opts_STAR_ = inst_24621;
return (function (tuple_res,port){
var c__2768__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24714){
var state_val_24715 = (state_24714[(1)]);
if((state_val_24715 === (7))){
var state_24714__$1 = state_24714;
var statearr_24716_24770 = state_24714__$1;
(statearr_24716_24770[(2)] = tuple_res);

(statearr_24716_24770[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24715 === (1))){
var state_24714__$1 = state_24714;
var statearr_24717_24771 = state_24714__$1;
(statearr_24717_24771[(2)] = null);

(statearr_24717_24771[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24715 === (4))){
var inst_24682 = (state_24714[(2)]);
var inst_24683 = cljs.core.async.put_BANG_.call(null,port,inst_24682);
var inst_24684 = cljs.core.async.close_BANG_.call(null,port);
var state_24714__$1 = (function (){var statearr_24718 = state_24714;
(statearr_24718[(7)] = inst_24683);

return statearr_24718;
})();
var statearr_24719_24772 = state_24714__$1;
(statearr_24719_24772[(2)] = inst_24684);

(statearr_24719_24772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24715 === (6))){
var inst_24691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24692 = [tuple_res];
var inst_24693 = (new cljs.core.PersistentVector(null,1,(5),inst_24691,inst_24692,null));
var state_24714__$1 = state_24714;
var statearr_24720_24773 = state_24714__$1;
(statearr_24720_24773[(2)] = inst_24693);

(statearr_24720_24773[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24715 === (3))){
var inst_24712 = (state_24714[(2)]);
var state_24714__$1 = state_24714;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24714__$1,inst_24712);
} else {
if((state_val_24715 === (2))){
var ___$1 = (function (){var statearr_24722 = state_24714;
(statearr_24722[(4)] = cljs.core.cons.call(null,(5),(state_24714[(4)])));

return statearr_24722;
})();
var state_24714__$1 = state_24714;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_24723_24774 = state_24714__$1;
(statearr_24723_24774[(1)] = (6));

} else {
var statearr_24724_24775 = state_24714__$1;
(statearr_24724_24775[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24715 === (9))){
var inst_24698 = (state_24714[(8)]);
var inst_24696 = (state_24714[(9)]);
var inst_24705 = (state_24714[(2)]);
var inst_24706 = cljs.core.reduce.call(null,fluree.db.query.fql.replace_expand_maps,inst_24696,inst_24705);
var inst_24707 = inst_24698.call(null,inst_24706);
var inst_24708 = cljs.core.async.put_BANG_.call(null,port,inst_24707);
var inst_24709 = cljs.core.async.close_BANG_.call(null,port);
var ___$1 = (function (){var statearr_24725 = state_24714;
(statearr_24725[(4)] = cljs.core.rest.call(null,(state_24714[(4)])));

return statearr_24725;
})();
var state_24714__$1 = (function (){var statearr_24726 = state_24714;
(statearr_24726[(10)] = inst_24708);

return statearr_24726;
})();
var statearr_24727_24776 = state_24714__$1;
(statearr_24727_24776[(2)] = inst_24709);

(statearr_24727_24776[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24715 === (5))){
var ___$1 = (function (){var statearr_24728 = state_24714;
(statearr_24728[(4)] = cljs.core.rest.call(null,(state_24714[(4)])));

return statearr_24728;
})();
var state_24714__$1 = state_24714;
var ex24721 = (state_24714__$1[(2)]);
var statearr_24729_24777 = state_24714__$1;
(statearr_24729_24777[(5)] = ex24721);


var statearr_24730_24778 = state_24714__$1;
(statearr_24730_24778[(1)] = (4));

(statearr_24730_24778[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24715 === (8))){
var inst_24696 = (state_24714[(9)]);
var inst_24696__$1 = (state_24714[(2)]);
var inst_24697 = cljs.core.volatile_BANG_.call(null,(0));
var inst_24698 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24696__$1;
var query_fuel = inst_24697;
return (function (p1__24608_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,p1__24608_SHARP_),cljs.core.deref.call(null,query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24608_SHARP_,cljs.core.deref.call(null,query_fuel)], null);
}
});
})();
var inst_24699 = cljs.core.PersistentVector.EMPTY;
var inst_24700 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24696__$1;
var query_fuel = inst_24697;
return (function (p1__24607_SHARP_){
return fluree.db.query.fql.expand_map.call(null,db,cljs.core.assoc.call(null,opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__24607_SHARP_);
});
})();
var inst_24701 = cljs.core.keep.call(null,inst_24700,expandMaps);
var inst_24702 = cljs.core.async.merge.call(null,inst_24701);
var inst_24703 = cljs.core.async.into.call(null,inst_24699,inst_24702);
var state_24714__$1 = (function (){var statearr_24731 = state_24714;
(statearr_24731[(8)] = inst_24698);

(statearr_24731[(9)] = inst_24696__$1);

return statearr_24731;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24714__$1,(9),inst_24703);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0 = (function (){
var statearr_24732 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24732[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__);

(statearr_24732[(1)] = (1));

return statearr_24732;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1 = (function (state_24714){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24714);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24733){var ex__2749__auto__ = e24733;
var statearr_24734_24779 = state_24714;
(statearr_24734_24779[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24714[(4)]))){
var statearr_24735_24780 = state_24714;
(statearr_24735_24780[(1)] = cljs.core.first.call(null,(state_24714[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24781 = state_24714;
state_24714 = G__24781;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = function(state_24714){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1.call(this,state_24714);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24736 = f__2769__auto__.call(null);
(statearr_24736[(6)] = c__2768__auto____$1);

return statearr_24736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto____$1;
});
})();
var inst_24623 = cljs.core.async.onto_chan_BANG_.call(null,inst_24616,tuples_res);
var inst_24624 = cljs.core.async.pipeline_async.call(null,parallelism,inst_24617__$1,inst_24622,inst_24616);
var inst_24625 = cljs.core.PersistentVector.EMPTY;
var inst_24626 = inst_24625;
var state_24667__$1 = (function (){var statearr_24737 = state_24667;
(statearr_24737[(11)] = inst_24623);

(statearr_24737[(9)] = inst_24618__$1);

(statearr_24737[(8)] = inst_24617__$1);

(statearr_24737[(12)] = inst_24626);

(statearr_24737[(13)] = inst_24624);

return statearr_24737;
})();
var statearr_24738_24782 = state_24667__$1;
(statearr_24738_24782[(2)] = null);

(statearr_24738_24782[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (19))){
var inst_24626 = (state_24667[(12)]);
var inst_24629 = (state_24667[(7)]);
var inst_24649 = cljs.core.first.call(null,inst_24629);
var inst_24650 = cljs.core.conj.call(null,inst_24626,inst_24649);
var inst_24626__$1 = inst_24650;
var state_24667__$1 = (function (){var statearr_24739 = state_24667;
(statearr_24739[(12)] = inst_24626__$1);

return statearr_24739;
})();
var statearr_24740_24783 = state_24667__$1;
(statearr_24740_24783[(2)] = null);

(statearr_24740_24783[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (11))){
var inst_24660 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24742_24784 = state_24667__$1;
(statearr_24742_24784[(2)] = inst_24660);

(statearr_24742_24784[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (9))){
var inst_24626 = (state_24667[(12)]);
var state_24667__$1 = state_24667;
var statearr_24743_24785 = state_24667__$1;
(statearr_24743_24785[(2)] = inst_24626);

(statearr_24743_24785[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (5))){
var _ = (function (){var statearr_24744 = state_24667;
(statearr_24744[(4)] = cljs.core.rest.call(null,(state_24667[(4)])));

return statearr_24744;
})();
var state_24667__$1 = state_24667;
var ex24741 = (state_24667__$1[(2)]);
var statearr_24745_24786 = state_24667__$1;
(statearr_24745_24786[(5)] = ex24741);


if((ex24741 instanceof Error)){
var statearr_24746_24787 = state_24667__$1;
(statearr_24746_24787[(1)] = (4));

(statearr_24746_24787[(5)] = null);

} else {
throw ex24741;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (14))){
var inst_24658 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24747_24788 = state_24667__$1;
(statearr_24747_24788[(2)] = inst_24658);

(statearr_24747_24788[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (16))){
var state_24667__$1 = state_24667;
var statearr_24748_24789 = state_24667__$1;
(statearr_24748_24789[(2)] = null);

(statearr_24748_24789[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (10))){
var inst_24629 = (state_24667[(7)]);
var inst_24633 = fluree.db.util.core.exception_QMARK_.call(null,inst_24629);
var state_24667__$1 = state_24667;
if(inst_24633){
var statearr_24749_24790 = state_24667__$1;
(statearr_24749_24790[(1)] = (12));

} else {
var statearr_24750_24791 = state_24667__$1;
(statearr_24750_24791[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (18))){
var inst_24618 = (state_24667[(9)]);
var inst_24642 = inst_24618.call(null);
var inst_24643 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_24644 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24645 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_24646 = cljs.core.PersistentHashMap.fromArrays(inst_24644,inst_24645);
var inst_24647 = cljs.core.ex_info.call(null,inst_24643,inst_24646);
var state_24667__$1 = (function (){var statearr_24751 = state_24667;
(statearr_24751[(14)] = inst_24642);

return statearr_24751;
})();
var statearr_24752_24792 = state_24667__$1;
(statearr_24752_24792[(2)] = inst_24647);

(statearr_24752_24792[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (8))){
var inst_24629 = (state_24667[(7)]);
var inst_24629__$1 = (state_24667[(2)]);
var inst_24630 = (inst_24629__$1 == null);
var state_24667__$1 = (function (){var statearr_24753 = state_24667;
(statearr_24753[(7)] = inst_24629__$1);

return statearr_24753;
})();
if(cljs.core.truth_(inst_24630)){
var statearr_24754_24793 = state_24667__$1;
(statearr_24754_24793[(1)] = (9));

} else {
var statearr_24755_24794 = state_24667__$1;
(statearr_24755_24794[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0 = (function (){
var statearr_24756 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24756[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__);

(statearr_24756[(1)] = (1));

return statearr_24756;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1 = (function (state_24667){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24667);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24757){var ex__2749__auto__ = e24757;
var statearr_24758_24795 = state_24667;
(statearr_24758_24795[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24667[(4)]))){
var statearr_24759_24796 = state_24667;
(statearr_24759_24796[(1)] = cljs.core.first.call(null,(state_24667[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24797 = state_24667;
state_24667 = G__24797;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = function(state_24667){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1.call(this,state_24667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24760 = f__2769__auto__.call(null);
(statearr_24760[(6)] = c__2768__auto__);

return statearr_24760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__24798 = select;
var map__24798__$1 = cljs.core.__destructure_map.call(null,map__24798);
var as = cljs.core.get.call(null,map__24798__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.call(null,map__24798__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.call(null,map__24798__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__4253__auto__ = as;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly.call(null,value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?cljs.core.constantly.call(null,cljs.core.get.call(null,vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__24801 = orderBy;
var order = cljs.core.nth.call(null,vec__24801,(0),null);
var var$ = cljs.core.nth.call(null,vec__24801,(1),null);
var option = cljs.core.nth.call(null,vec__24801,(2),null);
var comparator = ((cljs.core._EQ_.call(null,"DESC",order))?(function (a,b){
return cljs.core.compare.call(null,b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.call(null,"NOCASE",clojure.string.upper_case.call(null,option))));
var keyfn = ((no_case_QMARK_)?(function (p1__24799_SHARP_){
return clojure.string.upper_case.call(null,cljs.core.nth.call(null,p1__24799_SHARP_,compare_idx));
}):(function (p1__24800_SHARP_){
return cljs.core.nth.call(null,p1__24800_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count.call(null,tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.call(null,keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24806 = arguments.length;
switch (G__24806) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__24807,p__24808,group_limit,opts){
var map__24809 = p__24807;
var map__24809__$1 = cljs.core.__destructure_map.call(null,map__24809);
var res = map__24809__$1;
var vars = cljs.core.get.call(null,map__24809__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24810 = p__24808;
var map__24810__$1 = cljs.core.__destructure_map.call(null,map__24810);
var select_spec = map__24810__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__24810__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__24810__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__24810__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__24810__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.call(null,map__24810__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__24810__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__24810__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__24810__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__24810__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__24810__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24947){
var state_val_24948 = (state_24947[(1)]);
if((state_val_24948 === (7))){
var inst_24817 = (state_24947[(7)]);
var state_24947__$1 = state_24947;
var statearr_24949_25051 = state_24947__$1;
(statearr_24949_25051[(2)] = inst_24817);

(statearr_24949_25051[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (59))){
var inst_24940 = (state_24947[(2)]);
var state_24947__$1 = state_24947;
var statearr_24950_25052 = state_24947__$1;
(statearr_24950_25052[(2)] = inst_24940);

(statearr_24950_25052[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (20))){
var inst_24856 = (state_24947[(8)]);
var inst_24853 = (state_24947[(9)]);
var inst_24852 = (state_24947[(2)]);
var inst_24853__$1 = cljs.core.__destructure_map.call(null,inst_24852);
var inst_24854 = cljs.core.get.call(null,inst_24853__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_24855 = cljs.core.get.call(null,inst_24853__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_24856__$1 = offset;
var state_24947__$1 = (function (){var statearr_24951 = state_24947;
(statearr_24951[(10)] = inst_24854);

(statearr_24951[(8)] = inst_24856__$1);

(statearr_24951[(9)] = inst_24853__$1);

(statearr_24951[(11)] = inst_24855);

return statearr_24951;
})();
if(cljs.core.truth_(inst_24856__$1)){
var statearr_24952_25053 = state_24947__$1;
(statearr_24952_25053[(1)] = (21));

} else {
var statearr_24953_25054 = state_24947__$1;
(statearr_24953_25054[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (58))){
var inst_24932 = (state_24947[(12)]);
var state_24947__$1 = state_24947;
var statearr_24954_25055 = state_24947__$1;
(statearr_24954_25055[(2)] = inst_24932);

(statearr_24954_25055[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (60))){
var inst_24936 = (state_24947[(2)]);
var inst_24937 = fluree.db.util.async.throw_err.call(null,inst_24936);
var state_24947__$1 = state_24947;
var statearr_24955_25056 = state_24947__$1;
(statearr_24955_25056[(2)] = inst_24937);

(statearr_24955_25056[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (27))){
var inst_24868 = cljs.core.not.call(null,inVector_QMARK_);
var state_24947__$1 = state_24947;
var statearr_24956_25057 = state_24947__$1;
(statearr_24956_25057[(2)] = inst_24868);

(statearr_24956_25057[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (1))){
var state_24947__$1 = state_24947;
var statearr_24957_25058 = state_24947__$1;
(statearr_24957_25058[(2)] = null);

(statearr_24957_25058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (24))){
var state_24947__$1 = state_24947;
var statearr_24958_25059 = state_24947__$1;
(statearr_24958_25059[(2)] = offset);

(statearr_24958_25059[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (55))){
var inst_24926 = (state_24947[(13)]);
var state_24947__$1 = state_24947;
var statearr_24959_25060 = state_24947__$1;
(statearr_24959_25060[(2)] = inst_24926);

(statearr_24959_25060[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (39))){
var inst_24894 = (state_24947[(14)]);
var inst_24896 = cljs.core.distinct.call(null);
var inst_24897 = cljs.core.conj.call(null,inst_24894,inst_24896);
var state_24947__$1 = state_24947;
var statearr_24960_25061 = state_24947__$1;
(statearr_24960_25061[(2)] = inst_24897);

(statearr_24960_25061[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (46))){
var inst_24906 = (state_24947[(15)]);
var state_24947__$1 = state_24947;
var statearr_24961_25062 = state_24947__$1;
(statearr_24961_25062[(2)] = inst_24906);

(statearr_24961_25062[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (4))){
var inst_24811 = (state_24947[(2)]);
var state_24947__$1 = state_24947;
var statearr_24962_25063 = state_24947__$1;
(statearr_24962_25063[(2)] = inst_24811);

(statearr_24962_25063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (54))){
var inst_24926 = (state_24947[(13)]);
var inst_24920 = (state_24947[(16)]);
var inst_24928 = cljs.core.PersistentVector.EMPTY;
var inst_24929 = cljs.core.into.call(null,inst_24928,inst_24920,inst_24926);
var state_24947__$1 = state_24947;
var statearr_24963_25064 = state_24947__$1;
(statearr_24963_25064[(2)] = inst_24929);

(statearr_24963_25064[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (15))){
var inst_24838 = (state_24947[(17)]);
var inst_24840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24841 = [inst_24838];
var inst_24842 = (new cljs.core.PersistentVector(null,1,(5),inst_24840,inst_24841,null));
var state_24947__$1 = state_24947;
var statearr_24964_25065 = state_24947__$1;
(statearr_24964_25065[(2)] = inst_24842);

(statearr_24964_25065[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (48))){
var inst_24876 = (state_24947[(18)]);
var inst_24912 = (state_24947[(19)]);
var inst_24865 = (state_24947[(20)]);
var inst_24854 = (state_24947[(10)]);
var inst_24853 = (state_24947[(9)]);
var inst_24855 = (state_24947[(11)]);
var inst_24871 = (state_24947[(21)]);
var inst_24914 = (function (){var map__24847 = inst_24853;
var headers = inst_24854;
var tuples = inst_24855;
var offset_SINGLEQUOTE_ = inst_24865;
var single_result_QMARK_ = inst_24871;
var pp_keys = inst_24876;
var G__24877 = inst_24912;
return (function (p1__24804_SHARP_){
return cljs.core.zipmap.call(null,fluree.db.query.fql.get_pretty_print_keys.call(null,select),p1__24804_SHARP_);
});
})();
var inst_24915 = cljs.core.map.call(null,inst_24914);
var inst_24916 = cljs.core.conj.call(null,inst_24912,inst_24915);
var state_24947__$1 = state_24947;
var statearr_24965_25066 = state_24947__$1;
(statearr_24965_25066[(2)] = inst_24916);

(statearr_24965_25066[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (50))){
var inst_24919 = (state_24947[(2)]);
var inst_24920 = cljs.core.apply.call(null,cljs.core.comp,inst_24919);
var state_24947__$1 = (function (){var statearr_24966 = state_24947;
(statearr_24966[(16)] = inst_24920);

return statearr_24966;
})();
if(cljs.core.truth_(orderBy)){
var statearr_24967_25067 = state_24947__$1;
(statearr_24967_25067[(1)] = (51));

} else {
var statearr_24968_25068 = state_24947__$1;
(statearr_24968_25068[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (21))){
var inst_24858 = cljs.core.not.call(null,groupBy);
var state_24947__$1 = state_24947;
var statearr_24969_25069 = state_24947__$1;
(statearr_24969_25069[(2)] = inst_24858);

(statearr_24969_25069[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (31))){
var state_24947__$1 = state_24947;
var statearr_24970_25070 = state_24947__$1;
(statearr_24970_25070[(2)] = null);

(statearr_24970_25070[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (32))){
var inst_24854 = (state_24947[(10)]);
var inst_24871 = (state_24947[(21)]);
var inst_24876 = (state_24947[(2)]);
var inst_24878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24879 = fluree.db.query.fql.select_tuples_fn.call(null,inst_24854,vars,select);
var inst_24880 = cljs.core.map.call(null,inst_24879);
var inst_24881 = [inst_24880];
var inst_24882 = (new cljs.core.PersistentVector(null,1,(5),inst_24878,inst_24881,null));
var state_24947__$1 = (function (){var statearr_24971 = state_24947;
(statearr_24971[(22)] = inst_24882);

(statearr_24971[(18)] = inst_24876);

return statearr_24971;
})();
if(cljs.core.truth_(inst_24871)){
var statearr_24972_25071 = state_24947__$1;
(statearr_24972_25071[(1)] = (33));

} else {
var statearr_24973_25072 = state_24947__$1;
(statearr_24973_25072[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (40))){
var inst_24894 = (state_24947[(14)]);
var state_24947__$1 = state_24947;
var statearr_24974_25073 = state_24947__$1;
(statearr_24974_25073[(2)] = inst_24894);

(statearr_24974_25073[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (56))){
var inst_24932 = (state_24947[(2)]);
var state_24947__$1 = (function (){var statearr_24975 = state_24947;
(statearr_24975[(12)] = inst_24932);

return statearr_24975;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24976_25074 = state_24947__$1;
(statearr_24976_25074[(1)] = (57));

} else {
var statearr_24977_25075 = state_24947__$1;
(statearr_24977_25075[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (33))){
var inst_24882 = (state_24947[(22)]);
var inst_24884 = cljs.core.map.call(null,cljs.core.first);
var inst_24885 = cljs.core.conj.call(null,inst_24882,inst_24884);
var state_24947__$1 = state_24947;
var statearr_24978_25076 = state_24947__$1;
(statearr_24978_25076[(2)] = inst_24885);

(statearr_24978_25076[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (13))){
var inst_24827 = (state_24947[(23)]);
var state_24947__$1 = state_24947;
var statearr_24979_25077 = state_24947__$1;
(statearr_24979_25077[(2)] = inst_24827);

(statearr_24979_25077[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (22))){
var inst_24856 = (state_24947[(8)]);
var state_24947__$1 = state_24947;
var statearr_24980_25078 = state_24947__$1;
(statearr_24980_25078[(2)] = inst_24856);

(statearr_24980_25078[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (36))){
var inst_24888 = (state_24947[(24)]);
var inst_24890 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(5));
var inst_24891 = cljs.core.conj.call(null,inst_24888,inst_24890);
var state_24947__$1 = state_24947;
var statearr_24981_25079 = state_24947__$1;
(statearr_24981_25079[(2)] = inst_24891);

(statearr_24981_25079[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (41))){
var inst_24865 = (state_24947[(20)]);
var inst_24900 = (state_24947[(2)]);
var state_24947__$1 = (function (){var statearr_24982 = state_24947;
(statearr_24982[(25)] = inst_24900);

return statearr_24982;
})();
if(cljs.core.truth_(inst_24865)){
var statearr_24983_25080 = state_24947__$1;
(statearr_24983_25080[(1)] = (42));

} else {
var statearr_24984_25081 = state_24947__$1;
(statearr_24984_25081[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (43))){
var inst_24900 = (state_24947[(25)]);
var state_24947__$1 = state_24947;
var statearr_24985_25082 = state_24947__$1;
(statearr_24985_25082[(2)] = inst_24900);

(statearr_24985_25082[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (29))){
var inst_24871 = (state_24947[(2)]);
var state_24947__$1 = (function (){var statearr_24986 = state_24947;
(statearr_24986[(21)] = inst_24871);

return statearr_24986;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24987_25083 = state_24947__$1;
(statearr_24987_25083[(1)] = (30));

} else {
var statearr_24988_25084 = state_24947__$1;
(statearr_24988_25084[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (44))){
var inst_24906 = (state_24947[(2)]);
var state_24947__$1 = (function (){var statearr_24989 = state_24947;
(statearr_24989[(15)] = inst_24906);

return statearr_24989;
})();
if(cljs.core.truth_(group_limit)){
var statearr_24990_25085 = state_24947__$1;
(statearr_24990_25085[(1)] = (45));

} else {
var statearr_24991_25086 = state_24947__$1;
(statearr_24991_25086[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (6))){
var inst_24819 = cljs.core.count.call(null,select);
var inst_24820 = cljs.core._EQ_.call(null,(1),inst_24819);
var state_24947__$1 = state_24947;
var statearr_24992_25087 = state_24947__$1;
(statearr_24992_25087[(2)] = inst_24820);

(statearr_24992_25087[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (28))){
var inst_24866 = (state_24947[(26)]);
var state_24947__$1 = state_24947;
var statearr_24993_25088 = state_24947__$1;
(statearr_24993_25088[(2)] = inst_24866);

(statearr_24993_25088[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (51))){
var inst_24854 = (state_24947[(10)]);
var inst_24855 = (state_24947[(11)]);
var inst_24923 = fluree.db.query.fql.order_result_tuples.call(null,fuel,max_fuel,inst_24854,orderBy,inst_24855);
var state_24947__$1 = state_24947;
var statearr_24994_25089 = state_24947__$1;
(statearr_24994_25089[(2)] = inst_24923);

(statearr_24994_25089[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (25))){
var state_24947__$1 = state_24947;
var statearr_24995_25090 = state_24947__$1;
(statearr_24995_25090[(2)] = null);

(statearr_24995_25090[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (34))){
var inst_24882 = (state_24947[(22)]);
var state_24947__$1 = state_24947;
var statearr_24996_25091 = state_24947__$1;
(statearr_24996_25091[(2)] = inst_24882);

(statearr_24996_25091[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (17))){
var inst_24845 = (state_24947[(2)]);
var state_24947__$1 = state_24947;
var statearr_24997_25092 = state_24947__$1;
(statearr_24997_25092[(2)] = inst_24845);

(statearr_24997_25092[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (3))){
var inst_24945 = (state_24947[(2)]);
var state_24947__$1 = state_24947;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24947__$1,inst_24945);
} else {
if((state_val_24948 === (12))){
var inst_24827 = (state_24947[(23)]);
var inst_24829 = cljs.core.first.call(null,select);
var inst_24830 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24829);
var inst_24831 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24830);
var inst_24832 = cljs.core.subs.call(null,inst_24831,(1));
var inst_24833 = [inst_24832];
var inst_24834 = [inst_24827];
var inst_24835 = cljs.core.PersistentHashMap.fromArrays(inst_24833,inst_24834);
var state_24947__$1 = state_24947;
var statearr_24998_25093 = state_24947__$1;
(statearr_24998_25093[(2)] = inst_24835);

(statearr_24998_25093[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (2))){
var inst_24817 = (state_24947[(7)]);
var _ = (function (){var statearr_24999 = state_24947;
(statearr_24999[(4)] = cljs.core.cons.call(null,(5),(state_24947[(4)])));

return statearr_24999;
})();
var inst_24817__$1 = aggregates;
var state_24947__$1 = (function (){var statearr_25000 = state_24947;
(statearr_25000[(7)] = inst_24817__$1);

return statearr_25000;
})();
if(cljs.core.truth_(inst_24817__$1)){
var statearr_25001_25094 = state_24947__$1;
(statearr_25001_25094[(1)] = (6));

} else {
var statearr_25002_25095 = state_24947__$1;
(statearr_25002_25095[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (23))){
var inst_24861 = (state_24947[(2)]);
var state_24947__$1 = state_24947;
if(cljs.core.truth_(inst_24861)){
var statearr_25003_25096 = state_24947__$1;
(statearr_25003_25096[(1)] = (24));

} else {
var statearr_25004_25097 = state_24947__$1;
(statearr_25004_25097[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (47))){
var inst_24912 = (state_24947[(2)]);
var state_24947__$1 = (function (){var statearr_25005 = state_24947;
(statearr_25005[(19)] = inst_24912);

return statearr_25005;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25006_25098 = state_24947__$1;
(statearr_25006_25098[(1)] = (48));

} else {
var statearr_25007_25099 = state_24947__$1;
(statearr_25007_25099[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (35))){
var inst_24888 = (state_24947[(2)]);
var state_24947__$1 = (function (){var statearr_25008 = state_24947;
(statearr_25008[(24)] = inst_24888);

return statearr_25008;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25009_25100 = state_24947__$1;
(statearr_25009_25100[(1)] = (36));

} else {
var statearr_25010_25101 = state_24947__$1;
(statearr_25010_25101[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (19))){
var state_24947__$1 = state_24947;
var statearr_25011_25102 = state_24947__$1;
(statearr_25011_25102[(2)] = res);

(statearr_25011_25102[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (57))){
var inst_24876 = (state_24947[(18)]);
var inst_24871 = (state_24947[(21)]);
var inst_24932 = (state_24947[(12)]);
var inst_24934 = fluree.db.query.fql.pipeline_expandmaps_result.call(null,select,inst_24876,inst_24871,db,fuel,max_fuel,opts,(8),inst_24932);
var state_24947__$1 = state_24947;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24947__$1,(60),inst_24934);
} else {
if((state_val_24948 === (11))){
var inst_24942 = (state_24947[(2)]);
var _ = (function (){var statearr_25013 = state_24947;
(statearr_25013[(4)] = cljs.core.rest.call(null,(state_24947[(4)])));

return statearr_25013;
})();
var state_24947__$1 = state_24947;
var statearr_25014_25103 = state_24947__$1;
(statearr_25014_25103[(2)] = inst_24942);

(statearr_25014_25103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (9))){
var inst_24825 = cljs.core.first.call(null,aggregates);
var inst_24826 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_24825);
var inst_24827 = cljs.core.second.call(null,inst_24826);
var state_24947__$1 = (function (){var statearr_25015 = state_24947;
(statearr_25015[(23)] = inst_24827);

return statearr_25015;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25016_25104 = state_24947__$1;
(statearr_25016_25104[(1)] = (12));

} else {
var statearr_25017_25105 = state_24947__$1;
(statearr_25017_25105[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (5))){
var _ = (function (){var statearr_25018 = state_24947;
(statearr_25018[(4)] = cljs.core.rest.call(null,(state_24947[(4)])));

return statearr_25018;
})();
var state_24947__$1 = state_24947;
var ex25012 = (state_24947__$1[(2)]);
var statearr_25019_25106 = state_24947__$1;
(statearr_25019_25106[(5)] = ex25012);


if((ex25012 instanceof Error)){
var statearr_25020_25107 = state_24947__$1;
(statearr_25020_25107[(1)] = (4));

(statearr_25020_25107[(5)] = null);

} else {
throw ex25012;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (14))){
var inst_24838 = (state_24947[(2)]);
var state_24947__$1 = (function (){var statearr_25021 = state_24947;
(statearr_25021[(17)] = inst_24838);

return statearr_25021;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25022_25108 = state_24947__$1;
(statearr_25022_25108[(1)] = (15));

} else {
var statearr_25023_25109 = state_24947__$1;
(statearr_25023_25109[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (45))){
var inst_24906 = (state_24947[(15)]);
var inst_24908 = cljs.core.take.call(null,group_limit);
var inst_24909 = cljs.core.conj.call(null,inst_24906,inst_24908);
var state_24947__$1 = state_24947;
var statearr_25024_25110 = state_24947__$1;
(statearr_25024_25110[(2)] = inst_24909);

(statearr_25024_25110[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (53))){
var inst_24926 = (state_24947[(2)]);
var state_24947__$1 = (function (){var statearr_25025 = state_24947;
(statearr_25025[(13)] = inst_24926);

return statearr_25025;
})();
var statearr_25026_25111 = state_24947__$1;
(statearr_25026_25111[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (26))){
var inst_24866 = (state_24947[(26)]);
var inst_24865 = (state_24947[(2)]);
var inst_24866__$1 = cljs.core.not.call(null,prettyPrint);
var state_24947__$1 = (function (){var statearr_25028 = state_24947;
(statearr_25028[(26)] = inst_24866__$1);

(statearr_25028[(20)] = inst_24865);

return statearr_25028;
})();
if(inst_24866__$1){
var statearr_25029_25112 = state_24947__$1;
(statearr_25029_25112[(1)] = (27));

} else {
var statearr_25030_25113 = state_24947__$1;
(statearr_25030_25113[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (16))){
var inst_24838 = (state_24947[(17)]);
var state_24947__$1 = state_24947;
var statearr_25031_25114 = state_24947__$1;
(statearr_25031_25114[(2)] = inst_24838);

(statearr_25031_25114[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (38))){
var inst_24894 = (state_24947[(2)]);
var state_24947__$1 = (function (){var statearr_25032 = state_24947;
(statearr_25032[(14)] = inst_24894);

return statearr_25032;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25033_25115 = state_24947__$1;
(statearr_25033_25115[(1)] = (39));

} else {
var statearr_25034_25116 = state_24947__$1;
(statearr_25034_25116[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (30))){
var inst_24873 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_24947__$1 = state_24947;
var statearr_25035_25117 = state_24947__$1;
(statearr_25035_25117[(2)] = inst_24873);

(statearr_25035_25117[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (10))){
var state_24947__$1 = state_24947;
if(cljs.core.truth_(aggregates)){
var statearr_25036_25118 = state_24947__$1;
(statearr_25036_25118[(1)] = (18));

} else {
var statearr_25037_25119 = state_24947__$1;
(statearr_25037_25119[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (18))){
var inst_24849 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_24947__$1 = state_24947;
var statearr_25038_25120 = state_24947__$1;
(statearr_25038_25120[(2)] = inst_24849);

(statearr_25038_25120[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (52))){
var inst_24855 = (state_24947[(11)]);
var state_24947__$1 = state_24947;
var statearr_25039_25121 = state_24947__$1;
(statearr_25039_25121[(2)] = inst_24855);

(statearr_25039_25121[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (42))){
var inst_24865 = (state_24947[(20)]);
var inst_24900 = (state_24947[(25)]);
var inst_24902 = cljs.core.drop.call(null,inst_24865);
var inst_24903 = cljs.core.conj.call(null,inst_24900,inst_24902);
var state_24947__$1 = state_24947;
var statearr_25040_25122 = state_24947__$1;
(statearr_25040_25122[(2)] = inst_24903);

(statearr_25040_25122[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (37))){
var inst_24888 = (state_24947[(24)]);
var state_24947__$1 = state_24947;
var statearr_25041_25123 = state_24947__$1;
(statearr_25041_25123[(2)] = inst_24888);

(statearr_25041_25123[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (8))){
var inst_24823 = (state_24947[(2)]);
var state_24947__$1 = state_24947;
if(cljs.core.truth_(inst_24823)){
var statearr_25042_25124 = state_24947__$1;
(statearr_25042_25124[(1)] = (9));

} else {
var statearr_25043_25125 = state_24947__$1;
(statearr_25043_25125[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24948 === (49))){
var inst_24912 = (state_24947[(19)]);
var state_24947__$1 = state_24947;
var statearr_25044_25126 = state_24947__$1;
(statearr_25044_25126[(2)] = inst_24912);

(statearr_25044_25126[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2746__auto__ = null;
var fluree$db$query$fql$state_machine__2746__auto____0 = (function (){
var statearr_25045 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25045[(0)] = fluree$db$query$fql$state_machine__2746__auto__);

(statearr_25045[(1)] = (1));

return statearr_25045;
});
var fluree$db$query$fql$state_machine__2746__auto____1 = (function (state_24947){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24947);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25046){var ex__2749__auto__ = e25046;
var statearr_25047_25127 = state_24947;
(statearr_25047_25127[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24947[(4)]))){
var statearr_25048_25128 = state_24947;
(statearr_25048_25128[(1)] = cljs.core.first.call(null,(state_24947[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25129 = state_24947;
state_24947 = G__25129;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2746__auto__ = function(state_24947){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2746__auto____1.call(this,state_24947);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2746__auto____0;
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2746__auto____1;
return fluree$db$query$fql$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25049 = f__2769__auto__.call(null);
(statearr_25049[(6)] = c__2768__auto__);

return statearr_25049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__25132,groupBy){
var map__25133 = p__25132;
var map__25133__$1 = cljs.core.__destructure_map.call(null,map__25133);
var res = map__25133__$1;
var headers = cljs.core.get.call(null,map__25133__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__25133__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25134 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__25134,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__25134,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__25130_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__25130_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__25131_SHARP_){
return cljs.core.nth.call(null,tuple,p1__25131_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__25137 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.call(null,vec__25137,(0),null);
var sortCriteria = cljs.core.nth.call(null,vec__25137,(1),null);
if(cljs.core._EQ_.call(null,sortCriteria,groupBy)){
if(cljs.core._EQ_.call(null,sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_.call(null,groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of.call(null,groupBy,sortCriteria);
if(cljs.core._EQ_.call(null,"DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__25140,p__25141,opts){
var map__25142 = p__25140;
var map__25142__$1 = cljs.core.__destructure_map.call(null,map__25142);
var res = map__25142__$1;
var headers = cljs.core.get.call(null,map__25142__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__25142__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25143 = p__25141;
var map__25143__$1 = cljs.core.__destructure_map.call(null,map__25143);
var select_spec = map__25143__$1;
var groupBy = cljs.core.get.call(null,map__25143__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__25143__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__25143__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__25143__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__25143__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__25143__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__25143__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25385){
var state_val_25386 = (state_25385[(1)]);
if((state_val_25386 === (65))){
var state_25385__$1 = state_25385;
var statearr_25387_25538 = state_25385__$1;
(statearr_25387_25538[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (70))){
var inst_25306 = (state_25385[(7)]);
var state_25385__$1 = state_25385;
var statearr_25389_25539 = state_25385__$1;
(statearr_25389_25539[(2)] = inst_25306);

(statearr_25389_25539[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (62))){
var state_25385__$1 = state_25385;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25390_25540 = state_25385__$1;
(statearr_25390_25540[(1)] = (64));

} else {
var statearr_25391_25541 = state_25385__$1;
(statearr_25391_25541[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (74))){
var inst_25281 = (state_25385[(8)]);
var inst_25213 = (state_25385[(9)]);
var inst_25222 = (state_25385[(10)]);
var inst_25314 = cljs.core.assoc.call(null,inst_25213,inst_25222,inst_25281);
var state_25385__$1 = state_25385;
var statearr_25392_25542 = state_25385__$1;
(statearr_25392_25542[(2)] = inst_25314);

(statearr_25392_25542[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (7))){
var state_25385__$1 = state_25385;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25393_25543 = state_25385__$1;
(statearr_25393_25543[(1)] = (82));

} else {
var statearr_25394_25544 = state_25385__$1;
(statearr_25394_25544[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (59))){
var inst_25281 = (state_25385[(8)]);
var inst_25211 = (state_25385[(11)]);
var inst_25285 = cljs.core.count.call(null,inst_25281);
var inst_25286 = (inst_25211 - inst_25285);
var state_25385__$1 = state_25385;
var statearr_25395_25545 = state_25385__$1;
(statearr_25395_25545[(2)] = inst_25286);

(statearr_25395_25545[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (86))){
var state_25385__$1 = state_25385;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25396_25546 = state_25385__$1;
(statearr_25396_25546[(1)] = (89));

} else {
var statearr_25397_25547 = state_25385__$1;
(statearr_25397_25547[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (20))){
var state_25385__$1 = state_25385;
var statearr_25398_25548 = state_25385__$1;
(statearr_25398_25548[(2)] = (0));

(statearr_25398_25548[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (72))){
var inst_25311 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
if(cljs.core.truth_(inst_25311)){
var statearr_25399_25549 = state_25385__$1;
(statearr_25399_25549[(1)] = (73));

} else {
var statearr_25400_25550 = state_25385__$1;
(statearr_25400_25550[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (58))){
var state_25385__$1 = state_25385;
var statearr_25401_25551 = state_25385__$1;
(statearr_25401_25551[(2)] = null);

(statearr_25401_25551[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (60))){
var inst_25212 = (state_25385[(12)]);
var inst_25288 = (state_25385[(2)]);
var inst_25289 = (inst_25212 <= (0));
var state_25385__$1 = (function (){var statearr_25402 = state_25385;
(statearr_25402[(13)] = inst_25288);

return statearr_25402;
})();
if(cljs.core.truth_(inst_25289)){
var statearr_25403_25552 = state_25385__$1;
(statearr_25403_25552[(1)] = (61));

} else {
var statearr_25404_25553 = state_25385__$1;
(statearr_25404_25553[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (27))){
var inst_25211 = (state_25385[(11)]);
var inst_25235 = (inst_25211 < (1));
var state_25385__$1 = state_25385;
var statearr_25405_25554 = state_25385__$1;
(statearr_25405_25554[(2)] = inst_25235);

(statearr_25405_25554[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (1))){
var state_25385__$1 = state_25385;
var statearr_25406_25555 = state_25385__$1;
(statearr_25406_25555[(2)] = null);

(statearr_25406_25555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (69))){
var inst_25301 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
var statearr_25407_25556 = state_25385__$1;
(statearr_25407_25556[(2)] = inst_25301);

(statearr_25407_25556[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (24))){
var inst_25213 = (state_25385[(9)]);
var state_25385__$1 = state_25385;
var statearr_25408_25557 = state_25385__$1;
(statearr_25408_25557[(2)] = inst_25213);

(statearr_25408_25557[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (55))){
var inst_25271 = (state_25385[(14)]);
var inst_25211 = (state_25385[(11)]);
var inst_25278 = cljs.core.take.call(null,inst_25211,inst_25271);
var state_25385__$1 = state_25385;
var statearr_25409_25558 = state_25385__$1;
(statearr_25409_25558[(2)] = inst_25278);

(statearr_25409_25558[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (85))){
var inst_25356 = (state_25385[(15)]);
var inst_25355 = (state_25385[(2)]);
var inst_25356__$1 = fluree.db.util.async.throw_err.call(null,inst_25355);
var inst_25357 = cljs.core.coll_QMARK_.call(null,inst_25356__$1);
var inst_25358 = (!(inst_25357));
var state_25385__$1 = (function (){var statearr_25410 = state_25385;
(statearr_25410[(15)] = inst_25356__$1);

return statearr_25410;
})();
if(inst_25358){
var statearr_25411_25559 = state_25385__$1;
(statearr_25411_25559[(1)] = (86));

} else {
var statearr_25412_25560 = state_25385__$1;
(statearr_25412_25560[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (39))){
var inst_25230 = (state_25385[(16)]);
var inst_25252 = cljs.core.assoc.call(null,select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25253 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25254 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_25230,inst_25252,inst_25253);
var state_25385__$1 = state_25385;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25385__$1,(42),inst_25254);
} else {
if((state_val_25386 === (88))){
var inst_25378 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
var statearr_25413_25561 = state_25385__$1;
(statearr_25413_25561[(2)] = inst_25378);

(statearr_25413_25561[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (46))){
var inst_25212 = (state_25385[(12)]);
var inst_25266 = ((0) < inst_25212);
var state_25385__$1 = state_25385;
if(cljs.core.truth_(inst_25266)){
var statearr_25414_25562 = state_25385__$1;
(statearr_25414_25562[(1)] = (49));

} else {
var statearr_25415_25563 = state_25385__$1;
(statearr_25415_25563[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (4))){
var inst_25144 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
var statearr_25416_25564 = state_25385__$1;
(statearr_25416_25564[(2)] = inst_25144);

(statearr_25416_25564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (77))){
var inst_25211 = (state_25385[(11)]);
var inst_25322 = (inst_25211 - (1));
var state_25385__$1 = state_25385;
var statearr_25417_25565 = state_25385__$1;
(statearr_25417_25565[(2)] = inst_25322);

(statearr_25417_25565[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (95))){
var inst_25356 = (state_25385[(15)]);
var state_25385__$1 = state_25385;
var statearr_25418_25566 = state_25385__$1;
(statearr_25418_25566[(2)] = inst_25356);

(statearr_25418_25566[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (54))){
var inst_25276 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
if(cljs.core.truth_(inst_25276)){
var statearr_25419_25567 = state_25385__$1;
(statearr_25419_25567[(1)] = (55));

} else {
var statearr_25420_25568 = state_25385__$1;
(statearr_25420_25568[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (92))){
var inst_25356 = (state_25385[(15)]);
var inst_25369 = cljs.core.first.call(null,inst_25356);
var state_25385__$1 = state_25385;
var statearr_25421_25569 = state_25385__$1;
(statearr_25421_25569[(2)] = inst_25369);

(statearr_25421_25569[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (15))){
var inst_25162 = (state_25385[(17)]);
var inst_25170 = (state_25385[(2)]);
var inst_25171 = fluree.db.util.async.throw_err.call(null,inst_25170);
var inst_25172 = [inst_25162];
var inst_25173 = [inst_25171];
var inst_25174 = cljs.core.PersistentHashMap.fromArrays(inst_25172,inst_25173);
var state_25385__$1 = state_25385;
var statearr_25422_25570 = state_25385__$1;
(statearr_25422_25570[(2)] = inst_25174);

(statearr_25422_25570[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (48))){
var inst_25334 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
var statearr_25423_25571 = state_25385__$1;
(statearr_25423_25571[(2)] = inst_25334);

(statearr_25423_25571[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (50))){
var inst_25257 = (state_25385[(18)]);
var state_25385__$1 = state_25385;
var statearr_25424_25572 = state_25385__$1;
(statearr_25424_25572[(2)] = inst_25257);

(statearr_25424_25572[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (75))){
var inst_25305 = (state_25385[(19)]);
var inst_25226 = (state_25385[(20)]);
var inst_25288 = (state_25385[(13)]);
var inst_25223 = (state_25385[(21)]);
var inst_25316 = (state_25385[(2)]);
var inst_25209 = inst_25223;
var inst_25210 = inst_25226;
var inst_25211 = inst_25288;
var inst_25212 = inst_25305;
var inst_25213 = inst_25316;
var state_25385__$1 = (function (){var statearr_25425 = state_25385;
(statearr_25425[(22)] = inst_25210);

(statearr_25425[(11)] = inst_25211);

(statearr_25425[(9)] = inst_25213);

(statearr_25425[(23)] = inst_25209);

(statearr_25425[(12)] = inst_25212);

return statearr_25425;
})();
var statearr_25426_25573 = state_25385__$1;
(statearr_25426_25573[(2)] = null);

(statearr_25426_25573[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (21))){
var inst_25190 = (state_25385[(24)]);
var inst_25194 = (state_25385[(25)]);
var inst_25202 = (state_25385[(26)]);
var inst_25207 = (state_25385[(2)]);
var inst_25208 = cljs.core.PersistentHashMap.EMPTY;
var inst_25209 = inst_25190;
var inst_25210 = inst_25194;
var inst_25211 = inst_25202;
var inst_25212 = inst_25207;
var inst_25213 = inst_25208;
var state_25385__$1 = (function (){var statearr_25427 = state_25385;
(statearr_25427[(22)] = inst_25210);

(statearr_25427[(11)] = inst_25211);

(statearr_25427[(9)] = inst_25213);

(statearr_25427[(23)] = inst_25209);

(statearr_25427[(12)] = inst_25212);

return statearr_25427;
})();
var statearr_25428_25574 = state_25385__$1;
(statearr_25428_25574[(2)] = null);

(statearr_25428_25574[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (31))){
var inst_25227 = (state_25385[(27)]);
var inst_25212 = (state_25385[(12)]);
var inst_25241 = (inst_25212 >= inst_25227);
var state_25385__$1 = state_25385;
if(cljs.core.truth_(inst_25241)){
var statearr_25429_25575 = state_25385__$1;
(statearr_25429_25575[(1)] = (33));

} else {
var statearr_25430_25576 = state_25385__$1;
(statearr_25430_25576[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (32))){
var inst_25341 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
var statearr_25431_25577 = state_25385__$1;
(statearr_25431_25577[(2)] = inst_25341);

(statearr_25431_25577[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (40))){
var state_25385__$1 = state_25385;
var statearr_25432_25578 = state_25385__$1;
(statearr_25432_25578[(2)] = null);

(statearr_25432_25578[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (91))){
var inst_25366 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
var statearr_25433_25579 = state_25385__$1;
(statearr_25433_25579[(2)] = inst_25366);

(statearr_25433_25579[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (56))){
var inst_25271 = (state_25385[(14)]);
var state_25385__$1 = state_25385;
var statearr_25434_25580 = state_25385__$1;
(statearr_25434_25580[(2)] = inst_25271);

(statearr_25434_25580[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (33))){
var state_25385__$1 = state_25385;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25435_25581 = state_25385__$1;
(statearr_25435_25581[(1)] = (36));

} else {
var statearr_25436_25582 = state_25385__$1;
(statearr_25436_25582[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (13))){
var inst_25190 = (state_25385[(24)]);
var inst_25159 = (state_25385[(28)]);
var inst_25194 = (state_25385[(25)]);
var inst_25190__$1 = cljs.core.keys.call(null,inst_25159);
var inst_25191 = cljs.core.seq.call(null,inst_25190__$1);
var inst_25192 = cljs.core.first.call(null,inst_25191);
var inst_25193 = cljs.core.next.call(null,inst_25191);
var inst_25194__$1 = cljs.core.vals.call(null,inst_25159);
var inst_25195 = cljs.core.seq.call(null,inst_25194__$1);
var inst_25196 = cljs.core.first.call(null,inst_25195);
var inst_25197 = cljs.core.next.call(null,inst_25195);
var inst_25198 = cljs.core._EQ_.call(null,(0),limit);
var state_25385__$1 = (function (){var statearr_25437 = state_25385;
(statearr_25437[(24)] = inst_25190__$1);

(statearr_25437[(29)] = inst_25196);

(statearr_25437[(30)] = inst_25192);

(statearr_25437[(25)] = inst_25194__$1);

(statearr_25437[(31)] = inst_25193);

(statearr_25437[(32)] = inst_25197);

return statearr_25437;
})();
if(inst_25198){
var statearr_25438_25583 = state_25385__$1;
(statearr_25438_25583[(1)] = (16));

} else {
var statearr_25439_25584 = state_25385__$1;
(statearr_25439_25584[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (22))){
var inst_25210 = (state_25385[(22)]);
var inst_25209 = (state_25385[(23)]);
var inst_25221 = cljs.core.seq.call(null,inst_25209);
var inst_25222 = cljs.core.first.call(null,inst_25221);
var inst_25223 = cljs.core.next.call(null,inst_25221);
var inst_25224 = cljs.core.seq.call(null,inst_25210);
var inst_25225 = cljs.core.first.call(null,inst_25224);
var inst_25226 = cljs.core.next.call(null,inst_25224);
var inst_25227 = cljs.core.count.call(null,inst_25225);
var inst_25228 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25229 = [headers,vars,inst_25225];
var inst_25230 = cljs.core.PersistentHashMap.fromArrays(inst_25228,inst_25229);
var inst_25231 = (inst_25225 == null);
var state_25385__$1 = (function (){var statearr_25440 = state_25385;
(statearr_25440[(27)] = inst_25227);

(statearr_25440[(20)] = inst_25226);

(statearr_25440[(16)] = inst_25230);

(statearr_25440[(21)] = inst_25223);

(statearr_25440[(10)] = inst_25222);

return statearr_25440;
})();
if(cljs.core.truth_(inst_25231)){
var statearr_25441_25585 = state_25385__$1;
(statearr_25441_25585[(1)] = (24));

} else {
var statearr_25442_25586 = state_25385__$1;
(statearr_25442_25586[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (90))){
var inst_25356 = (state_25385[(15)]);
var state_25385__$1 = state_25385;
var statearr_25443_25587 = state_25385__$1;
(statearr_25443_25587[(2)] = inst_25356);

(statearr_25443_25587[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (36))){
var inst_25212 = (state_25385[(12)]);
var inst_25244 = (inst_25212 - (1));
var state_25385__$1 = state_25385;
var statearr_25444_25588 = state_25385__$1;
(statearr_25444_25588[(2)] = inst_25244);

(statearr_25444_25588[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (41))){
var inst_25337 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
var statearr_25445_25589 = state_25385__$1;
(statearr_25445_25589[(2)] = inst_25337);

(statearr_25445_25589[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (89))){
var inst_25356 = (state_25385[(15)]);
var inst_25361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25362 = [inst_25356];
var inst_25363 = (new cljs.core.PersistentVector(null,1,(5),inst_25361,inst_25362,null));
var state_25385__$1 = state_25385;
var statearr_25446_25590 = state_25385__$1;
(statearr_25446_25590[(2)] = inst_25363);

(statearr_25446_25590[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (43))){
var inst_25257 = (state_25385[(18)]);
var inst_25260 = cljs.core.seq.call(null,inst_25257);
var state_25385__$1 = state_25385;
var statearr_25447_25591 = state_25385__$1;
(statearr_25447_25591[(2)] = inst_25260);

(statearr_25447_25591[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (61))){
var state_25385__$1 = state_25385;
var statearr_25448_25592 = state_25385__$1;
(statearr_25448_25592[(2)] = (0));

(statearr_25448_25592[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (29))){
var inst_25238 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
if(cljs.core.truth_(inst_25238)){
var statearr_25449_25593 = state_25385__$1;
(statearr_25449_25593[(1)] = (30));

} else {
var statearr_25450_25594 = state_25385__$1;
(statearr_25450_25594[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (44))){
var inst_25258 = (state_25385[(33)]);
var state_25385__$1 = state_25385;
var statearr_25451_25595 = state_25385__$1;
(statearr_25451_25595[(2)] = inst_25258);

(statearr_25451_25595[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (93))){
var state_25385__$1 = state_25385;
var statearr_25452_25596 = state_25385__$1;
(statearr_25452_25596[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (6))){
var inst_25151 = (state_25385[(34)]);
var inst_25151__$1 = fluree.db.query.fql.build_order_fn.call(null,orderBy,groupBy);
var inst_25153 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var state_25385__$1 = (function (){var statearr_25454 = state_25385;
(statearr_25454[(35)] = inst_25153);

(statearr_25454[(34)] = inst_25151__$1);

return statearr_25454;
})();
if(cljs.core.truth_(inst_25151__$1)){
var statearr_25455_25597 = state_25385__$1;
(statearr_25455_25597[(1)] = (9));

} else {
var statearr_25456_25598 = state_25385__$1;
(statearr_25456_25598[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (28))){
var inst_25211 = (state_25385[(11)]);
var state_25385__$1 = state_25385;
var statearr_25457_25599 = state_25385__$1;
(statearr_25457_25599[(2)] = inst_25211);

(statearr_25457_25599[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (64))){
var inst_25212 = (state_25385[(12)]);
var inst_25293 = (inst_25212 - (1));
var state_25385__$1 = state_25385;
var statearr_25458_25600 = state_25385__$1;
(statearr_25458_25600[(2)] = inst_25293);

(statearr_25458_25600[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (51))){
var inst_25211 = (state_25385[(11)]);
var inst_25271 = (state_25385[(2)]);
var state_25385__$1 = (function (){var statearr_25459 = state_25385;
(statearr_25459[(14)] = inst_25271);

return statearr_25459;
})();
if(cljs.core.truth_(inst_25211)){
var statearr_25460_25601 = state_25385__$1;
(statearr_25460_25601[(1)] = (52));

} else {
var statearr_25461_25602 = state_25385__$1;
(statearr_25461_25602[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (25))){
var inst_25211 = (state_25385[(11)]);
var state_25385__$1 = state_25385;
if(cljs.core.truth_(inst_25211)){
var statearr_25462_25603 = state_25385__$1;
(statearr_25462_25603[(1)] = (27));

} else {
var statearr_25463_25604 = state_25385__$1;
(statearr_25463_25604[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (34))){
var state_25385__$1 = state_25385;
var statearr_25464_25605 = state_25385__$1;
(statearr_25464_25605[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (17))){
var state_25385__$1 = state_25385;
var statearr_25466_25606 = state_25385__$1;
(statearr_25466_25606[(2)] = limit);

(statearr_25466_25606[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (3))){
var inst_25383 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25385__$1,inst_25383);
} else {
if((state_val_25386 === (12))){
var inst_25159 = (state_25385[(28)]);
var inst_25161 = cljs.core.keys.call(null,inst_25159);
var inst_25162 = cljs.core.first.call(null,inst_25161);
var inst_25163 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25164 = cljs.core.vals.call(null,inst_25159);
var inst_25165 = cljs.core.first.call(null,inst_25164);
var inst_25166 = [headers,vars,inst_25165];
var inst_25167 = cljs.core.PersistentHashMap.fromArrays(inst_25163,inst_25166);
var inst_25168 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_25167,select_spec,limit,opts);
var state_25385__$1 = (function (){var statearr_25467 = state_25385;
(statearr_25467[(17)] = inst_25162);

return statearr_25467;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25385__$1,(15),inst_25168);
} else {
if((state_val_25386 === (2))){
var _ = (function (){var statearr_25468 = state_25385;
(statearr_25468[(4)] = cljs.core.cons.call(null,(5),(state_25385[(4)])));

return statearr_25468;
})();
var state_25385__$1 = state_25385;
if(cljs.core.truth_(groupBy)){
var statearr_25469_25607 = state_25385__$1;
(statearr_25469_25607[(1)] = (6));

} else {
var statearr_25470_25608 = state_25385__$1;
(statearr_25470_25608[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (66))){
var inst_25303 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
var statearr_25471_25609 = state_25385__$1;
(statearr_25471_25609[(2)] = inst_25303);

(statearr_25471_25609[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (23))){
var inst_25345 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
var statearr_25472_25610 = state_25385__$1;
(statearr_25472_25610[(2)] = inst_25345);

(statearr_25472_25610[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (47))){
var inst_25211 = (state_25385[(11)]);
var inst_25319 = (inst_25211 == null);
var state_25385__$1 = state_25385;
if(cljs.core.truth_(inst_25319)){
var statearr_25473_25611 = state_25385__$1;
(statearr_25473_25611[(1)] = (76));

} else {
var statearr_25474_25612 = state_25385__$1;
(statearr_25474_25612[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (35))){
var inst_25339 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
var statearr_25475_25613 = state_25385__$1;
(statearr_25475_25613[(2)] = inst_25339);

(statearr_25475_25613[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (82))){
var state_25385__$1 = state_25385;
var statearr_25476_25614 = state_25385__$1;
(statearr_25476_25614[(2)] = (1));

(statearr_25476_25614[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (76))){
var state_25385__$1 = state_25385;
var statearr_25477_25615 = state_25385__$1;
(statearr_25477_25615[(2)] = null);

(statearr_25477_25615[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (97))){
var inst_25374 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
var statearr_25478_25616 = state_25385__$1;
(statearr_25478_25616[(2)] = inst_25374);

(statearr_25478_25616[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (19))){
var inst_25203 = (state_25385[(36)]);
var state_25385__$1 = state_25385;
var statearr_25479_25617 = state_25385__$1;
(statearr_25479_25617[(2)] = inst_25203);

(statearr_25479_25617[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (57))){
var inst_25211 = (state_25385[(11)]);
var inst_25281 = (state_25385[(2)]);
var inst_25282 = (inst_25211 == null);
var state_25385__$1 = (function (){var statearr_25480 = state_25385;
(statearr_25480[(8)] = inst_25281);

return statearr_25480;
})();
if(cljs.core.truth_(inst_25282)){
var statearr_25481_25618 = state_25385__$1;
(statearr_25481_25618[(1)] = (58));

} else {
var statearr_25482_25619 = state_25385__$1;
(statearr_25482_25619[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (68))){
var state_25385__$1 = state_25385;
var statearr_25483_25620 = state_25385__$1;
(statearr_25483_25620[(2)] = null);

(statearr_25483_25620[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (11))){
var inst_25159 = (state_25385[(2)]);
var state_25385__$1 = (function (){var statearr_25485 = state_25385;
(statearr_25485[(28)] = inst_25159);

return statearr_25485;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25486_25621 = state_25385__$1;
(statearr_25486_25621[(1)] = (12));

} else {
var statearr_25487_25622 = state_25385__$1;
(statearr_25487_25622[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (9))){
var inst_25153 = (state_25385[(35)]);
var inst_25151 = (state_25385[(34)]);
var inst_25155 = cljs.core.sorted_map_by.call(null,inst_25151);
var inst_25156 = cljs.core.into.call(null,inst_25155,inst_25153);
var state_25385__$1 = state_25385;
var statearr_25488_25623 = state_25385__$1;
(statearr_25488_25623[(2)] = inst_25156);

(statearr_25488_25623[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (5))){
var _ = (function (){var statearr_25489 = state_25385;
(statearr_25489[(4)] = cljs.core.rest.call(null,(state_25385[(4)])));

return statearr_25489;
})();
var state_25385__$1 = state_25385;
var ex25484 = (state_25385__$1[(2)]);
var statearr_25490_25624 = state_25385__$1;
(statearr_25490_25624[(5)] = ex25484);


if((ex25484 instanceof Error)){
var statearr_25491_25625 = state_25385__$1;
(statearr_25491_25625[(1)] = (4));

(statearr_25491_25625[(5)] = null);

} else {
throw ex25484;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (83))){
var state_25385__$1 = state_25385;
var statearr_25492_25626 = state_25385__$1;
(statearr_25492_25626[(2)] = limit);

(statearr_25492_25626[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (14))){
var inst_25347 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
var statearr_25493_25627 = state_25385__$1;
(statearr_25493_25627[(2)] = inst_25347);

(statearr_25493_25627[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (45))){
var inst_25263 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
if(cljs.core.truth_(inst_25263)){
var statearr_25494_25628 = state_25385__$1;
(statearr_25494_25628[(1)] = (46));

} else {
var statearr_25495_25629 = state_25385__$1;
(statearr_25495_25629[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (53))){
var inst_25211 = (state_25385[(11)]);
var state_25385__$1 = state_25385;
var statearr_25496_25630 = state_25385__$1;
(statearr_25496_25630[(2)] = inst_25211);

(statearr_25496_25630[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (78))){
var inst_25212 = (state_25385[(12)]);
var inst_25324 = (state_25385[(2)]);
var inst_25325 = (inst_25212 <= (0));
var state_25385__$1 = (function (){var statearr_25497 = state_25385;
(statearr_25497[(37)] = inst_25324);

return statearr_25497;
})();
if(cljs.core.truth_(inst_25325)){
var statearr_25498_25631 = state_25385__$1;
(statearr_25498_25631[(1)] = (79));

} else {
var statearr_25499_25632 = state_25385__$1;
(statearr_25499_25632[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (26))){
var inst_25343 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
var statearr_25500_25633 = state_25385__$1;
(statearr_25500_25633[(2)] = inst_25343);

(statearr_25500_25633[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (16))){
var state_25385__$1 = state_25385;
var statearr_25501_25634 = state_25385__$1;
(statearr_25501_25634[(2)] = null);

(statearr_25501_25634[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (81))){
var inst_25257 = (state_25385[(18)]);
var inst_25324 = (state_25385[(37)]);
var inst_25226 = (state_25385[(20)]);
var inst_25213 = (state_25385[(9)]);
var inst_25223 = (state_25385[(21)]);
var inst_25222 = (state_25385[(10)]);
var inst_25330 = (state_25385[(2)]);
var inst_25331 = cljs.core.assoc.call(null,inst_25213,inst_25222,inst_25257);
var inst_25209 = inst_25223;
var inst_25210 = inst_25226;
var inst_25211 = inst_25324;
var inst_25212 = inst_25330;
var inst_25213__$1 = inst_25331;
var state_25385__$1 = (function (){var statearr_25504 = state_25385;
(statearr_25504[(22)] = inst_25210);

(statearr_25504[(11)] = inst_25211);

(statearr_25504[(9)] = inst_25213__$1);

(statearr_25504[(23)] = inst_25209);

(statearr_25504[(12)] = inst_25212);

return statearr_25504;
})();
var statearr_25505_25635 = state_25385__$1;
(statearr_25505_25635[(2)] = null);

(statearr_25505_25635[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (79))){
var state_25385__$1 = state_25385;
var statearr_25506_25636 = state_25385__$1;
(statearr_25506_25636[(2)] = (0));

(statearr_25506_25636[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (38))){
var inst_25211 = (state_25385[(11)]);
var inst_25226 = (state_25385[(20)]);
var inst_25213 = (state_25385[(9)]);
var inst_25223 = (state_25385[(21)]);
var inst_25248 = (state_25385[(2)]);
var tmp25502 = inst_25211;
var tmp25503 = inst_25213;
var inst_25209 = inst_25223;
var inst_25210 = inst_25226;
var inst_25211__$1 = tmp25502;
var inst_25212 = inst_25248;
var inst_25213__$1 = tmp25503;
var state_25385__$1 = (function (){var statearr_25507 = state_25385;
(statearr_25507[(22)] = inst_25210);

(statearr_25507[(11)] = inst_25211__$1);

(statearr_25507[(9)] = inst_25213__$1);

(statearr_25507[(23)] = inst_25209);

(statearr_25507[(12)] = inst_25212);

return statearr_25507;
})();
var statearr_25508_25637 = state_25385__$1;
(statearr_25508_25637[(2)] = null);

(statearr_25508_25637[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (87))){
var state_25385__$1 = state_25385;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25509_25638 = state_25385__$1;
(statearr_25509_25638[(1)] = (92));

} else {
var statearr_25510_25639 = state_25385__$1;
(statearr_25510_25639[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (30))){
var inst_25213 = (state_25385[(9)]);
var state_25385__$1 = state_25385;
var statearr_25511_25640 = state_25385__$1;
(statearr_25511_25640[(2)] = inst_25213);

(statearr_25511_25640[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (73))){
var inst_25213 = (state_25385[(9)]);
var state_25385__$1 = state_25385;
var statearr_25512_25641 = state_25385__$1;
(statearr_25512_25641[(2)] = inst_25213);

(statearr_25512_25641[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (96))){
var state_25385__$1 = state_25385;
var statearr_25513_25642 = state_25385__$1;
(statearr_25513_25642[(2)] = null);

(statearr_25513_25642[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (10))){
var inst_25153 = (state_25385[(35)]);
var state_25385__$1 = state_25385;
var statearr_25514_25643 = state_25385__$1;
(statearr_25514_25643[(2)] = inst_25153);

(statearr_25514_25643[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (18))){
var inst_25203 = (state_25385[(36)]);
var inst_25202 = (state_25385[(2)]);
var inst_25203__$1 = offset;
var state_25385__$1 = (function (){var statearr_25515 = state_25385;
(statearr_25515[(36)] = inst_25203__$1);

(statearr_25515[(26)] = inst_25202);

return statearr_25515;
})();
if(cljs.core.truth_(inst_25203__$1)){
var statearr_25516_25644 = state_25385__$1;
(statearr_25516_25644[(1)] = (19));

} else {
var statearr_25517_25645 = state_25385__$1;
(statearr_25517_25645[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (52))){
var inst_25211 = (state_25385[(11)]);
var inst_25273 = ((0) < inst_25211);
var state_25385__$1 = state_25385;
var statearr_25518_25646 = state_25385__$1;
(statearr_25518_25646[(2)] = inst_25273);

(statearr_25518_25646[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (67))){
var inst_25227 = (state_25385[(27)]);
var inst_25281 = (state_25385[(8)]);
var inst_25212 = (state_25385[(12)]);
var inst_25296 = cljs.core.count.call(null,inst_25281);
var inst_25297 = (inst_25227 - inst_25296);
var inst_25298 = (inst_25212 - inst_25297);
var state_25385__$1 = state_25385;
var statearr_25519_25647 = state_25385__$1;
(statearr_25519_25647[(2)] = inst_25298);

(statearr_25519_25647[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (71))){
var inst_25281 = (state_25385[(8)]);
var inst_25309 = cljs.core.empty_QMARK_.call(null,inst_25281);
var state_25385__$1 = state_25385;
var statearr_25520_25648 = state_25385__$1;
(statearr_25520_25648[(2)] = inst_25309);

(statearr_25520_25648[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (42))){
var inst_25257 = (state_25385[(18)]);
var inst_25258 = (state_25385[(33)]);
var inst_25256 = (state_25385[(2)]);
var inst_25257__$1 = fluree.db.util.async.throw_err.call(null,inst_25256);
var inst_25258__$1 = cljs.core.coll_QMARK_.call(null,inst_25257__$1);
var state_25385__$1 = (function (){var statearr_25521 = state_25385;
(statearr_25521[(18)] = inst_25257__$1);

(statearr_25521[(33)] = inst_25258__$1);

return statearr_25521;
})();
if(inst_25258__$1){
var statearr_25522_25649 = state_25385__$1;
(statearr_25522_25649[(1)] = (43));

} else {
var statearr_25523_25650 = state_25385__$1;
(statearr_25523_25650[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (80))){
var inst_25212 = (state_25385[(12)]);
var inst_25328 = (inst_25212 - (1));
var state_25385__$1 = state_25385;
var statearr_25524_25651 = state_25385__$1;
(statearr_25524_25651[(2)] = inst_25328);

(statearr_25524_25651[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (37))){
var inst_25227 = (state_25385[(27)]);
var inst_25212 = (state_25385[(12)]);
var inst_25246 = (inst_25212 - inst_25227);
var state_25385__$1 = state_25385;
var statearr_25525_25652 = state_25385__$1;
(statearr_25525_25652[(2)] = inst_25246);

(statearr_25525_25652[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (63))){
var inst_25281 = (state_25385[(8)]);
var inst_25306 = (state_25385[(7)]);
var inst_25305 = (state_25385[(2)]);
var inst_25306__$1 = (inst_25281 == null);
var state_25385__$1 = (function (){var statearr_25526 = state_25385;
(statearr_25526[(19)] = inst_25305);

(statearr_25526[(7)] = inst_25306__$1);

return statearr_25526;
})();
if(cljs.core.truth_(inst_25306__$1)){
var statearr_25527_25653 = state_25385__$1;
(statearr_25527_25653[(1)] = (70));

} else {
var statearr_25528_25654 = state_25385__$1;
(statearr_25528_25654[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (94))){
var inst_25376 = (state_25385[(2)]);
var state_25385__$1 = state_25385;
var statearr_25529_25655 = state_25385__$1;
(statearr_25529_25655[(2)] = inst_25376);

(statearr_25529_25655[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (8))){
var inst_25380 = (state_25385[(2)]);
var _ = (function (){var statearr_25530 = state_25385;
(statearr_25530[(4)] = cljs.core.rest.call(null,(state_25385[(4)])));

return statearr_25530;
})();
var state_25385__$1 = state_25385;
var statearr_25531_25656 = state_25385__$1;
(statearr_25531_25656[(2)] = inst_25380);

(statearr_25531_25656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (49))){
var inst_25257 = (state_25385[(18)]);
var inst_25212 = (state_25385[(12)]);
var inst_25268 = cljs.core.drop.call(null,inst_25212,inst_25257);
var state_25385__$1 = state_25385;
var statearr_25532_25657 = state_25385__$1;
(statearr_25532_25657[(2)] = inst_25268);

(statearr_25532_25657[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25386 === (84))){
var inst_25352 = (state_25385[(2)]);
var inst_25353 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,inst_25352,opts);
var state_25385__$1 = state_25385;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25385__$1,(85),inst_25353);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0 = (function (){
var statearr_25533 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25533[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__);

(statearr_25533[(1)] = (1));

return statearr_25533;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1 = (function (state_25385){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25385);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25534){var ex__2749__auto__ = e25534;
var statearr_25535_25658 = state_25385;
(statearr_25535_25658[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25385[(4)]))){
var statearr_25536_25659 = state_25385;
(statearr_25536_25659[(1)] = cljs.core.first.call(null,(state_25385[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25660 = state_25385;
state_25385 = G__25660;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__ = function(state_25385){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1.call(this,state_25385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25537 = f__2769__auto__.call(null);
(statearr_25537[(6)] = c__2768__auto__);

return statearr_25537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__25663,opts){
var map__25664 = p__25663;
var map__25664__$1 = cljs.core.__destructure_map.call(null,map__25664);
var selectOne = cljs.core.get.call(null,map__25664__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.call(null,map__25664__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.call(null,map__25664__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.call(null,map__25664__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4253__auto__ = selectOne;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = select;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_.call(null,select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select.call(null,headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.call(null,(function (p1__25661_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__25661_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some.call(null,(function (p1__25662_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__25662_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_.call(null,aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4253__auto__ = typeof orderBy === 'string';
if(or__4253__auto__){
return or__4253__auto__;
} else {
var and__4251__auto__ = cljs.core.vector_QMARK_.call(null,orderBy);
if(and__4251__auto__){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null).call(null,cljs.core.first.call(null,orderBy));
} else {
return and__4251__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_.call(null,orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.call(null,["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (100);
}
})(),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$.call(null,selectOne),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$.call(null,(function (){var or__4253__auto__ = selectDistinct;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__25665,p__25666){
var map__25667 = p__25665;
var map__25667__$1 = cljs.core.__destructure_map.call(null,map__25667);
var query_map = map__25667__$1;
var construct = cljs.core.get.call(null,map__25667__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__25668 = p__25666;
var map__25668__$1 = cljs.core.__destructure_map.call(null,map__25668);
var where_result = map__25668__$1;
var headers = cljs.core.get.call(null,map__25668__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__25668__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25669 = cljs.core.map.call(null,(function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.call(null,row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.call(null,vec__25669,(0),null);
var fn2 = cljs.core.nth.call(null,vec__25669,(1),null);
var fn3 = cljs.core.nth.call(null,vec__25669,(2),null);
return cljs.core.map.call(null,(function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fn1.call(null,res),fn2.call(null,res),fn3.call(null,res)], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25702){
var state_val_25703 = (state_25702[(1)]);
if((state_val_25703 === (7))){
var inst_25681 = (state_25702[(7)]);
var state_25702__$1 = state_25702;
var statearr_25704_25727 = state_25702__$1;
(statearr_25704_25727[(2)] = inst_25681);

(statearr_25704_25727[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (1))){
var state_25702__$1 = state_25702;
var statearr_25705_25728 = state_25702__$1;
(statearr_25705_25728[(2)] = null);

(statearr_25705_25728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (4))){
var inst_25672 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
var statearr_25706_25729 = state_25702__$1;
(statearr_25706_25729[(2)] = inst_25672);

(statearr_25706_25729[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (13))){
var inst_25691 = (state_25702[(2)]);
var inst_25692 = fluree.db.util.async.throw_err.call(null,inst_25691);
var state_25702__$1 = state_25702;
var statearr_25707_25730 = state_25702__$1;
(statearr_25707_25730[(2)] = inst_25692);

(statearr_25707_25730[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (6))){
var inst_25681 = (state_25702[(7)]);
var inst_25680 = (state_25702[(2)]);
var inst_25681__$1 = fluree.db.util.async.throw_err.call(null,inst_25680);
var inst_25682 = fluree.db.util.core.exception_QMARK_.call(null,inst_25681__$1);
var state_25702__$1 = (function (){var statearr_25708 = state_25702;
(statearr_25708[(7)] = inst_25681__$1);

return statearr_25708;
})();
if(inst_25682){
var statearr_25709_25731 = state_25702__$1;
(statearr_25709_25731[(1)] = (7));

} else {
var statearr_25710_25732 = state_25702__$1;
(statearr_25710_25732[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (3))){
var inst_25700 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25702__$1,inst_25700);
} else {
if((state_val_25703 === (12))){
var inst_25695 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
var statearr_25711_25733 = state_25702__$1;
(statearr_25711_25733[(2)] = inst_25695);

(statearr_25711_25733[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (2))){
var _ = (function (){var statearr_25712 = state_25702;
(statearr_25712[(4)] = cljs.core.cons.call(null,(5),(state_25702[(4)])));

return statearr_25712;
})();
var inst_25678 = fluree.db.query.analytical.q.call(null,query_map,fuel,max_fuel,db,opts);
var state_25702__$1 = state_25702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25702__$1,(6),inst_25678);
} else {
if((state_val_25703 === (11))){
var state_25702__$1 = state_25702;
var statearr_25714_25734 = state_25702__$1;
(statearr_25714_25734[(2)] = null);

(statearr_25714_25734[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (9))){
var inst_25697 = (state_25702[(2)]);
var _ = (function (){var statearr_25715 = state_25702;
(statearr_25715[(4)] = cljs.core.rest.call(null,(state_25702[(4)])));

return statearr_25715;
})();
var state_25702__$1 = state_25702;
var statearr_25716_25735 = state_25702__$1;
(statearr_25716_25735[(2)] = inst_25697);

(statearr_25716_25735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (5))){
var _ = (function (){var statearr_25717 = state_25702;
(statearr_25717[(4)] = cljs.core.rest.call(null,(state_25702[(4)])));

return statearr_25717;
})();
var state_25702__$1 = state_25702;
var ex25713 = (state_25702__$1[(2)]);
var statearr_25718_25736 = state_25702__$1;
(statearr_25718_25736[(5)] = ex25713);


if((ex25713 instanceof Error)){
var statearr_25719_25737 = state_25702__$1;
(statearr_25719_25737[(1)] = (4));

(statearr_25719_25737[(5)] = null);

} else {
throw ex25713;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (10))){
var inst_25681 = (state_25702[(7)]);
var inst_25686 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_25681);
var inst_25687 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_25681);
var inst_25688 = fluree.db.query.fql.get_ad_hoc_select_spec.call(null,inst_25686,inst_25687,query_map,opts);
var inst_25689 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,fuel,max_fuel,inst_25681,inst_25688,opts);
var state_25702__$1 = state_25702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25702__$1,(13),inst_25689);
} else {
if((state_val_25703 === (8))){
var state_25702__$1 = state_25702;
var statearr_25720_25738 = state_25702__$1;
(statearr_25720_25738[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____0 = (function (){
var statearr_25722 = [null,null,null,null,null,null,null,null];
(statearr_25722[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__);

(statearr_25722[(1)] = (1));

return statearr_25722;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____1 = (function (state_25702){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25702);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25723){var ex__2749__auto__ = e25723;
var statearr_25724_25739 = state_25702;
(statearr_25724_25739[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25702[(4)]))){
var statearr_25725_25740 = state_25702;
(statearr_25725_25740[(1)] = cljs.core.first.call(null,(state_25702[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25741 = state_25702;
state_25702 = G__25741;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__ = function(state_25702){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____1.call(this,state_25702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25726 = f__2769__auto__.call(null);
(statearr_25726[(6)] = c__2768__auto__);

return statearr_25726;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.call(null,"Running query:",cljs.core.pr_str.call(null,query_map));

var map__25742 = query_map;
var map__25742__$1 = cljs.core.__destructure_map.call(null,map__25742);
var select = cljs.core.get.call(null,map__25742__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__25742__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.call(null,map__25742__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__25742__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__25742__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.call(null,map__25742__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.call(null,map__25742__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.call(null,map__25742__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.call(null,map__25742__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.call(null,map__25742__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.call(null,map__25742__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.call(null,map__25742__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__25743 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4253__auto__ = offset;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts);
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.call(null,G__25743,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__25743;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.truth_((function (){var or__4253__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_.call(null,(0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_.call(null,where)){
return fluree.db.query.fql.ad_hoc_query.call(null,db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26099){
var state_val_26100 = (state_26099[(1)]);
if((state_val_26100 === (121))){
var inst_26060 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
var statearr_26101_26296 = state_26099__$1;
(statearr_26101_26296[(2)] = inst_26060);

(statearr_26101_26296[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (65))){
var inst_25937 = typeof from === 'string';
var state_26099__$1 = state_26099;
if(cljs.core.truth_(inst_25937)){
var statearr_26102_26297 = state_26099__$1;
(statearr_26102_26297[(1)] = (72));

} else {
var statearr_26103_26298 = state_26099__$1;
(statearr_26103_26298[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (70))){
var inst_25805 = (state_26099[(7)]);
var inst_25803 = (state_26099[(8)]);
var inst_25930 = (state_26099[(2)]);
var inst_25931 = fluree.db.util.async.throw_err.call(null,inst_25930);
var inst_25932 = fluree.db.query.fql.flake_select.call(null,db,inst_25805,fuel,max_fuel,inst_25803,inst_25931);
var state_26099__$1 = state_26099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26099__$1,(71),inst_25932);
} else {
if((state_val_26100 === (62))){
var inst_25910 = (state_26099[(9)]);
var state_26099__$1 = state_26099;
var statearr_26104_26299 = state_26099__$1;
(statearr_26104_26299[(2)] = inst_25910);

(statearr_26104_26299[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (74))){
var inst_26066 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
var statearr_26105_26300 = state_26099__$1;
(statearr_26105_26300[(2)] = inst_26066);

(statearr_26105_26300[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (110))){
var inst_26001 = (state_26099[(10)]);
var state_26099__$1 = state_26099;
var statearr_26106_26301 = state_26099__$1;
(statearr_26106_26301[(2)] = inst_26001);

(statearr_26106_26301[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (130))){
var inst_26086 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
var statearr_26107_26302 = state_26099__$1;
(statearr_26107_26302[(2)] = inst_26086);

(statearr_26107_26302[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (128))){
var inst_26077 = (state_26099[(11)]);
var inst_26082 = fluree.db.util.core.exception_QMARK_.call(null,inst_26077);
var inst_26083 = (!(inst_26082));
var state_26099__$1 = state_26099;
var statearr_26108_26303 = state_26099__$1;
(statearr_26108_26303[(2)] = inst_26083);

(statearr_26108_26303[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (7))){
var inst_25773 = (state_26099[(12)]);
var inst_25773__$1 = selectOne;
var state_26099__$1 = (function (){var statearr_26109 = state_26099;
(statearr_26109[(12)] = inst_25773__$1);

return statearr_26109;
})();
if(cljs.core.truth_(inst_25773__$1)){
var statearr_26110_26304 = state_26099__$1;
(statearr_26110_26304[(1)] = (9));

} else {
var statearr_26111_26305 = state_26099__$1;
(statearr_26111_26305[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (59))){
var inst_25805 = (state_26099[(7)]);
var inst_25803 = (state_26099[(8)]);
var inst_25793 = (state_26099[(13)]);
var inst_25888 = (state_26099[(14)]);
var inst_25902 = (state_26099[(2)]);
var inst_25903 = fluree.db.util.async.throw_err.call(null,inst_25902);
var inst_25904 = cljs.core.sequence.call(null,inst_25888,inst_25903);
var inst_25905 = fluree.db.query.fql.subject_select.call(null,db,inst_25805,fuel,max_fuel,inst_25803,inst_25904,inst_25793);
var state_26099__$1 = state_26099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26099__$1,(60),inst_25905);
} else {
if((state_val_26100 === (86))){
var inst_25805 = (state_26099[(7)]);
var inst_25803 = (state_26099[(8)]);
var inst_25793 = (state_26099[(13)]);
var inst_25795 = (state_26099[(15)]);
var inst_25970 = (state_26099[(2)]);
var inst_25971 = fluree.db.query.fql.subject_select.call(null,db,inst_25805,fuel,max_fuel,inst_25803,inst_25970,inst_25793,inst_25795);
var state_26099__$1 = state_26099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26099__$1,(87),inst_25971);
} else {
if((state_val_26100 === (20))){
var inst_25837 = (state_26099[(2)]);
var inst_25838 = cljs.core.nth.call(null,inst_25837,(0),null);
var inst_25839 = cljs.core.nth.call(null,inst_25837,(1),null);
var inst_25840 = typeof where === 'string';
var state_26099__$1 = (function (){var statearr_26112 = state_26099;
(statearr_26112[(16)] = inst_25839);

(statearr_26112[(17)] = inst_25838);

return statearr_26112;
})();
if(cljs.core.truth_(inst_25840)){
var statearr_26113_26306 = state_26099__$1;
(statearr_26113_26306[(1)] = (30));

} else {
var statearr_26114_26307 = state_26099__$1;
(statearr_26114_26307[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (72))){
var inst_25792 = (state_26099[(18)]);
var state_26099__$1 = state_26099;
if(cljs.core.truth_(inst_25792)){
var statearr_26115_26308 = state_26099__$1;
(statearr_26115_26308[(1)] = (75));

} else {
var statearr_26116_26309 = state_26099__$1;
(statearr_26116_26309[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (58))){
var inst_25896 = (state_26099[(2)]);
var inst_25897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25898 = [from];
var inst_25899 = (new cljs.core.PersistentVector(null,1,(5),inst_25897,inst_25898,null));
var inst_25900 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25899,inst_25896);
var state_26099__$1 = state_26099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26099__$1,(59),inst_25900);
} else {
if((state_val_26100 === (60))){
var inst_25907 = (state_26099[(2)]);
var inst_25908 = fluree.db.util.async.throw_err.call(null,inst_25907);
var state_26099__$1 = state_26099;
var statearr_26117_26310 = state_26099__$1;
(statearr_26117_26310[(2)] = inst_25908);

(statearr_26117_26310[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (27))){
var inst_25822 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25823 = [null,null];
var inst_25824 = (new cljs.core.PersistentVector(null,2,(5),inst_25822,inst_25823,null));
var state_26099__$1 = state_26099;
var statearr_26118_26311 = state_26099__$1;
(statearr_26118_26311[(2)] = inst_25824);

(statearr_26118_26311[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (1))){
var state_26099__$1 = state_26099;
var statearr_26119_26312 = state_26099__$1;
(statearr_26119_26312[(2)] = null);

(statearr_26119_26312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (69))){
var inst_25927 = (state_26099[(2)]);
var inst_25928 = fluree.db.query.range._block_or_tx_collection.call(null,db,inst_25927);
var state_26099__$1 = state_26099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26099__$1,(70),inst_25928);
} else {
if((state_val_26100 === (101))){
var inst_26033 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
var statearr_26120_26313 = state_26099__$1;
(statearr_26120_26313[(2)] = inst_26033);

(statearr_26120_26313[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (24))){
var inst_25792 = (state_26099[(18)]);
var inst_25817 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25818 = [inst_25792,"ASC"];
var inst_25819 = (new cljs.core.PersistentVector(null,2,(5),inst_25817,inst_25818,null));
var state_26099__$1 = state_26099;
var statearr_26121_26314 = state_26099__$1;
(statearr_26121_26314[(2)] = inst_25819);

(statearr_26121_26314[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (102))){
var inst_26007 = (state_26099[(19)]);
var state_26099__$1 = state_26099;
var statearr_26122_26315 = state_26099__$1;
(statearr_26122_26315[(2)] = inst_26007);

(statearr_26122_26315[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (55))){
var inst_25792 = (state_26099[(18)]);
var inst_25888 = (state_26099[(2)]);
var state_26099__$1 = (function (){var statearr_26123 = state_26099;
(statearr_26123[(14)] = inst_25888);

return statearr_26123;
})();
if(cljs.core.truth_(inst_25792)){
var statearr_26124_26316 = state_26099__$1;
(statearr_26124_26316[(1)] = (56));

} else {
var statearr_26125_26317 = state_26099__$1;
(statearr_26125_26317[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (85))){
var inst_25962 = (state_26099[(20)]);
var inst_25966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25967 = [inst_25962];
var inst_25968 = (new cljs.core.PersistentVector(null,1,(5),inst_25966,inst_25967,null));
var state_26099__$1 = state_26099;
var statearr_26126_26318 = state_26099__$1;
(statearr_26126_26318[(2)] = inst_25968);

(statearr_26126_26318[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (39))){
var inst_25793 = (state_26099[(13)]);
var state_26099__$1 = state_26099;
var statearr_26127_26319 = state_26099__$1;
(statearr_26127_26319[(2)] = inst_25793);

(statearr_26127_26319[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (88))){
var inst_25976 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core.inc);
var state_26099__$1 = state_26099;
var statearr_26128_26320 = state_26099__$1;
(statearr_26128_26320[(2)] = inst_25976);

(statearr_26128_26320[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (46))){
var inst_25873 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
if(cljs.core.truth_(inst_25873)){
var statearr_26129_26321 = state_26099__$1;
(statearr_26129_26321[(1)] = (47));

} else {
var statearr_26130_26322 = state_26099__$1;
(statearr_26130_26322[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (4))){
var inst_25760 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
var statearr_26131_26323 = state_26099__$1;
(statearr_26131_26323[(2)] = inst_25760);

(statearr_26131_26323[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (77))){
var inst_25946 = (state_26099[(2)]);
var inst_25947 = fluree.db.query.range.collection.call(null,db,from,inst_25946);
var state_26099__$1 = state_26099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26099__$1,(78),inst_25947);
} else {
if((state_val_26100 === (106))){
var state_26099__$1 = state_26099;
var statearr_26132_26324 = state_26099__$1;
(statearr_26132_26324[(2)] = null);

(statearr_26132_26324[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (119))){
var inst_26052 = cljs.core.pr_str.call(null,query_map);
var inst_26053 = ["Invalid 'from' in query:",inst_26052].join('');
var inst_26054 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26055 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_26056 = cljs.core.PersistentHashMap.fromArrays(inst_26054,inst_26055);
var inst_26057 = cljs.core.ex_info.call(null,inst_26053,inst_26056);
var state_26099__$1 = state_26099;
var statearr_26133_26325 = state_26099__$1;
(statearr_26133_26325[(2)] = inst_26057);

(statearr_26133_26325[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (95))){
var state_26099__$1 = state_26099;
var statearr_26134_26326 = state_26099__$1;
(statearr_26134_26326[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (54))){
var inst_25882 = (state_26099[(21)]);
var state_26099__$1 = state_26099;
var statearr_26136_26327 = state_26099__$1;
(statearr_26136_26327[(2)] = inst_25882);

(statearr_26136_26327[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (92))){
var inst_25981 = (state_26099[(22)]);
var state_26099__$1 = state_26099;
var statearr_26137_26328 = state_26099__$1;
(statearr_26137_26328[(2)] = inst_25981);

(statearr_26137_26328[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (104))){
var inst_26025 = (state_26099[(23)]);
var inst_26025__$1 = (state_26099[(2)]);
var state_26099__$1 = (function (){var statearr_26138 = state_26099;
(statearr_26138[(23)] = inst_26025__$1);

return statearr_26138;
})();
if(cljs.core.truth_(inst_26025__$1)){
var statearr_26139_26329 = state_26099__$1;
(statearr_26139_26329[(1)] = (109));

} else {
var statearr_26140_26330 = state_26099__$1;
(statearr_26140_26330[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (15))){
var inst_25796 = (state_26099[(24)]);
var inst_25794 = (state_26099[(25)]);
var inst_25800 = cljs.core.assoc.call(null,inst_25796,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_25794);
var state_26099__$1 = state_26099;
var statearr_26141_26331 = state_26099__$1;
(statearr_26141_26331[(2)] = inst_25800);

(statearr_26141_26331[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (48))){
var inst_25910 = (state_26099[(9)]);
var inst_25910__$1 = typeof from === 'string';
var state_26099__$1 = (function (){var statearr_26142 = state_26099;
(statearr_26142[(9)] = inst_25910__$1);

return statearr_26142;
})();
if(cljs.core.truth_(inst_25910__$1)){
var statearr_26143_26332 = state_26099__$1;
(statearr_26143_26332[(1)] = (61));

} else {
var statearr_26144_26333 = state_26099__$1;
(statearr_26144_26333[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (50))){
var inst_25876 = (state_26099[(26)]);
var inst_25878 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_25879 = cljs.core.comp.call(null,inst_25876,inst_25878);
var state_26099__$1 = state_26099;
var statearr_26145_26334 = state_26099__$1;
(statearr_26145_26334[(2)] = inst_25879);

(statearr_26145_26334[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (116))){
var state_26099__$1 = state_26099;
var statearr_26146_26335 = state_26099__$1;
(statearr_26146_26335[(2)] = null);

(statearr_26146_26335[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (75))){
var inst_25940 = cljs.core.PersistentHashMap.EMPTY;
var state_26099__$1 = state_26099;
var statearr_26147_26336 = state_26099__$1;
(statearr_26147_26336[(2)] = inst_25940);

(statearr_26147_26336[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (99))){
var inst_26001 = (state_26099[(10)]);
var state_26099__$1 = state_26099;
var statearr_26148_26337 = state_26099__$1;
(statearr_26148_26337[(2)] = inst_26001);

(statearr_26148_26337[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (21))){
var inst_25792 = (state_26099[(18)]);
var inst_25809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25810 = cljs.core.second.call(null,inst_25792);
var inst_25811 = cljs.core.first.call(null,inst_25792);
var inst_25812 = [inst_25810,inst_25811];
var inst_25813 = (new cljs.core.PersistentVector(null,2,(5),inst_25809,inst_25812,null));
var state_26099__$1 = state_26099;
var statearr_26149_26338 = state_26099__$1;
(statearr_26149_26338[(2)] = inst_25813);

(statearr_26149_26338[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (31))){
var inst_25867 = (state_26099[(27)]);
var inst_25867__$1 = typeof from === 'string';
var state_26099__$1 = (function (){var statearr_26150 = state_26099;
(statearr_26150[(27)] = inst_25867__$1);

return statearr_26150;
})();
if(cljs.core.truth_(inst_25867__$1)){
var statearr_26151_26339 = state_26099__$1;
(statearr_26151_26339[(1)] = (44));

} else {
var statearr_26152_26340 = state_26099__$1;
(statearr_26152_26340[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (113))){
var state_26099__$1 = state_26099;
var statearr_26153_26341 = state_26099__$1;
(statearr_26153_26341[(2)] = null);

(statearr_26153_26341[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (32))){
var inst_25838 = (state_26099[(17)]);
var inst_26072 = (state_26099[(2)]);
var state_26099__$1 = (function (){var statearr_26154 = state_26099;
(statearr_26154[(28)] = inst_26072);

return statearr_26154;
})();
if(cljs.core.truth_(inst_25838)){
var statearr_26155_26342 = state_26099__$1;
(statearr_26155_26342[(1)] = (122));

} else {
var statearr_26156_26343 = state_26099__$1;
(statearr_26156_26343[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (40))){
var inst_25792 = (state_26099[(18)]);
var inst_25857 = (state_26099[(2)]);
var state_26099__$1 = (function (){var statearr_26157 = state_26099;
(statearr_26157[(29)] = inst_25857);

return statearr_26157;
})();
if(cljs.core.truth_(inst_25792)){
var statearr_26158_26344 = state_26099__$1;
(statearr_26158_26344[(1)] = (41));

} else {
var statearr_26159_26345 = state_26099__$1;
(statearr_26159_26345[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (129))){
var inst_26080 = (state_26099[(30)]);
var state_26099__$1 = state_26099;
var statearr_26160_26346 = state_26099__$1;
(statearr_26160_26346[(2)] = inst_26080);

(statearr_26160_26346[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (91))){
var inst_25983 = cljs.core.every_QMARK_.call(null,fluree.db.util.core.subj_ident_QMARK_,from);
var state_26099__$1 = state_26099;
var statearr_26161_26347 = state_26099__$1;
(statearr_26161_26347[(2)] = inst_25983);

(statearr_26161_26347[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (117))){
var inst_25795 = (state_26099[(15)]);
var state_26099__$1 = state_26099;
var statearr_26162_26348 = state_26099__$1;
(statearr_26162_26348[(2)] = inst_25795);

(statearr_26162_26348[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (108))){
var inst_26022 = (state_26099[(2)]);
var inst_26023 = fluree.db.util.async.throw_err.call(null,inst_26022);
var state_26099__$1 = state_26099;
var statearr_26163_26349 = state_26099__$1;
(statearr_26163_26349[(2)] = inst_26023);

(statearr_26163_26349[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (56))){
var inst_25890 = cljs.core.PersistentHashMap.EMPTY;
var state_26099__$1 = state_26099;
var statearr_26164_26350 = state_26099__$1;
(statearr_26164_26350[(2)] = inst_25890);

(statearr_26164_26350[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (33))){
var state_26099__$1 = state_26099;
var statearr_26165_26351 = state_26099__$1;
(statearr_26165_26351[(2)] = from);

(statearr_26165_26351[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (13))){
var inst_25779 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25780 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25781 = cljs.core.PersistentHashMap.fromArrays(inst_25779,inst_25780);
var inst_25782 = cljs.core.ex_info.call(null,"Query missing :select or :selectOne.",inst_25781);
var inst_25783 = (function(){throw inst_25782})();
var state_26099__$1 = state_26099;
var statearr_26166_26352 = state_26099__$1;
(statearr_26166_26352[(2)] = inst_25783);

(statearr_26166_26352[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (22))){
var inst_25792 = (state_26099[(18)]);
var inst_25815 = typeof inst_25792 === 'string';
var state_26099__$1 = state_26099;
if(cljs.core.truth_(inst_25815)){
var statearr_26167_26353 = state_26099__$1;
(statearr_26167_26353[(1)] = (24));

} else {
var statearr_26168_26354 = state_26099__$1;
(statearr_26168_26354[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (90))){
var inst_25974 = (state_26099[(31)]);
var inst_25979 = (state_26099[(2)]);
var state_26099__$1 = (function (){var statearr_26169 = state_26099;
(statearr_26169[(32)] = inst_25979);

return statearr_26169;
})();
var statearr_26170_26355 = state_26099__$1;
(statearr_26170_26355[(2)] = inst_25974);

(statearr_26170_26355[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (109))){
var inst_26001 = (state_26099[(10)]);
var inst_26025 = (state_26099[(23)]);
var inst_26027 = cljs.core.conj.call(null,inst_26001,inst_26025);
var state_26099__$1 = state_26099;
var statearr_26171_26356 = state_26099__$1;
(statearr_26171_26356[(2)] = inst_26027);

(statearr_26171_26356[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (36))){
var inst_25792 = (state_26099[(18)]);
var inst_25852 = (state_26099[(2)]);
var inst_25853 = fluree.db.util.async.throw_err.call(null,inst_25852);
var state_26099__$1 = (function (){var statearr_26172 = state_26099;
(statearr_26172[(33)] = inst_25853);

return statearr_26172;
})();
if(cljs.core.truth_(inst_25792)){
var statearr_26173_26357 = state_26099__$1;
(statearr_26173_26357[(1)] = (38));

} else {
var statearr_26174_26358 = state_26099__$1;
(statearr_26174_26358[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (41))){
var state_26099__$1 = state_26099;
var statearr_26175_26359 = state_26099__$1;
(statearr_26175_26359[(2)] = null);

(statearr_26175_26359[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (118))){
var inst_26037 = (state_26099[(34)]);
var inst_25805 = (state_26099[(7)]);
var inst_25803 = (state_26099[(8)]);
var inst_26041 = (state_26099[(35)]);
var inst_26045 = (state_26099[(2)]);
var inst_26046 = fluree.db.query.fql.subject_select.call(null,db,inst_25805,fuel,max_fuel,inst_25803,inst_26037,inst_26041,inst_26045);
var state_26099__$1 = state_26099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26099__$1,(112),inst_26046);
} else {
if((state_val_26100 === (89))){
var state_26099__$1 = state_26099;
var statearr_26176_26360 = state_26099__$1;
(statearr_26176_26360[(2)] = null);

(statearr_26176_26360[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (100))){
var inst_26007 = (state_26099[(19)]);
var inst_26012 = cljs.core.int_QMARK_.call(null,inst_26007);
var state_26099__$1 = state_26099;
if(inst_26012){
var statearr_26177_26361 = state_26099__$1;
(statearr_26177_26361[(1)] = (102));

} else {
var statearr_26178_26362 = state_26099__$1;
(statearr_26178_26362[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (131))){
var inst_26077 = (state_26099[(11)]);
var inst_26091 = cljs.core.first.call(null,inst_26077);
var state_26099__$1 = state_26099;
var statearr_26179_26363 = state_26099__$1;
(statearr_26179_26363[(2)] = inst_26091);

(statearr_26179_26363[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (122))){
var inst_25839 = (state_26099[(16)]);
var inst_25838 = (state_26099[(17)]);
var inst_25793 = (state_26099[(13)]);
var inst_25795 = (state_26099[(15)]);
var inst_26072 = (state_26099[(28)]);
var inst_26074 = fluree.db.query.fql.sort_offset_and_limit_res.call(null,inst_25838,inst_25839,inst_25795,inst_25793,inst_26072);
var state_26099__$1 = state_26099;
var statearr_26180_26364 = state_26099__$1;
(statearr_26180_26364[(2)] = inst_26074);

(statearr_26180_26364[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (43))){
var inst_25853 = (state_26099[(33)]);
var inst_25805 = (state_26099[(7)]);
var inst_25803 = (state_26099[(8)]);
var inst_25857 = (state_26099[(29)]);
var inst_25861 = (state_26099[(2)]);
var inst_25862 = fluree.db.query.fql.subject_select.call(null,db,inst_25805,fuel,max_fuel,inst_25803,inst_25853,inst_25857,inst_25861);
var state_26099__$1 = state_26099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26099__$1,(37),inst_25862);
} else {
if((state_val_26100 === (61))){
var inst_25912 = ["_tx",null,"_block",null];
var inst_25913 = (new cljs.core.PersistentArrayMap(null,2,inst_25912,null));
var inst_25914 = (new cljs.core.PersistentHashSet(null,inst_25913,null));
var inst_25915 = inst_25914.call(null,from);
var state_26099__$1 = state_26099;
var statearr_26181_26365 = state_26099__$1;
(statearr_26181_26365[(2)] = inst_25915);

(statearr_26181_26365[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (29))){
var inst_25827 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
var statearr_26182_26366 = state_26099__$1;
(statearr_26182_26366[(2)] = inst_25827);

(statearr_26182_26366[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (44))){
var inst_25869 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_25870 = clojure.string.includes_QMARK_.call(null,inst_25869,"/");
var state_26099__$1 = state_26099;
var statearr_26183_26367 = state_26099__$1;
(statearr_26183_26367[(2)] = inst_25870);

(statearr_26183_26367[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (93))){
var inst_25986 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
if(cljs.core.truth_(inst_25986)){
var statearr_26184_26368 = state_26099__$1;
(statearr_26184_26368[(1)] = (94));

} else {
var statearr_26185_26369 = state_26099__$1;
(statearr_26185_26369[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (6))){
var inst_25770 = (state_26099[(36)]);
var state_26099__$1 = state_26099;
var statearr_26186_26370 = state_26099__$1;
(statearr_26186_26370[(2)] = inst_25770);

(statearr_26186_26370[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (111))){
var inst_26008 = (state_26099[(37)]);
var inst_26030 = (state_26099[(2)]);
var inst_26000 = inst_26008;
var inst_26001 = inst_26030;
var state_26099__$1 = (function (){var statearr_26187 = state_26099;
(statearr_26187[(10)] = inst_26001);

(statearr_26187[(38)] = inst_26000);

return statearr_26187;
})();
var statearr_26188_26371 = state_26099__$1;
(statearr_26188_26371[(2)] = null);

(statearr_26188_26371[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (28))){
var state_26099__$1 = state_26099;
var statearr_26189_26372 = state_26099__$1;
(statearr_26189_26372[(2)] = null);

(statearr_26189_26372[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (64))){
var inst_25792 = (state_26099[(18)]);
var state_26099__$1 = state_26099;
if(cljs.core.truth_(inst_25792)){
var statearr_26190_26373 = state_26099__$1;
(statearr_26190_26373[(1)] = (67));

} else {
var statearr_26191_26374 = state_26099__$1;
(statearr_26191_26374[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (103))){
var state_26099__$1 = state_26099;
if(cljs.core.truth_(fuel)){
var statearr_26192_26375 = state_26099__$1;
(statearr_26192_26375[(1)] = (105));

} else {
var statearr_26193_26376 = state_26099__$1;
(statearr_26193_26376[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (51))){
var inst_25876 = (state_26099[(26)]);
var state_26099__$1 = state_26099;
var statearr_26194_26377 = state_26099__$1;
(statearr_26194_26377[(2)] = inst_25876);

(statearr_26194_26377[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (25))){
var state_26099__$1 = state_26099;
var statearr_26195_26378 = state_26099__$1;
(statearr_26195_26378[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (34))){
var state_26099__$1 = state_26099;
var statearr_26197_26379 = state_26099__$1;
(statearr_26197_26379[(2)] = null);

(statearr_26197_26379[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (125))){
var inst_26077 = (state_26099[(11)]);
var inst_26080 = (state_26099[(30)]);
var inst_26080__$1 = cljs.core.coll_QMARK_.call(null,inst_26077);
var state_26099__$1 = (function (){var statearr_26198 = state_26099;
(statearr_26198[(30)] = inst_26080__$1);

return statearr_26198;
})();
if(inst_26080__$1){
var statearr_26199_26380 = state_26099__$1;
(statearr_26199_26380[(1)] = (128));

} else {
var statearr_26200_26381 = state_26099__$1;
(statearr_26200_26381[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (17))){
var inst_25792 = (state_26099[(18)]);
var inst_25803 = (state_26099[(2)]);
var inst_25804 = cljs.core.PersistentHashMap.EMPTY;
var inst_25805 = cljs.core.volatile_BANG_.call(null,inst_25804);
var state_26099__$1 = (function (){var statearr_26201 = state_26099;
(statearr_26201[(7)] = inst_25805);

(statearr_26201[(8)] = inst_25803);

return statearr_26201;
})();
if(cljs.core.truth_(inst_25792)){
var statearr_26202_26382 = state_26099__$1;
(statearr_26202_26382[(1)] = (18));

} else {
var statearr_26203_26383 = state_26099__$1;
(statearr_26203_26383[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (3))){
var inst_26097 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26099__$1,inst_26097);
} else {
if((state_val_26100 === (12))){
var inst_25776 = (state_26099[(39)]);
var state_26099__$1 = state_26099;
var statearr_26204_26384 = state_26099__$1;
(statearr_26204_26384[(2)] = inst_25776);

(statearr_26204_26384[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (2))){
var inst_25770 = (state_26099[(36)]);
var _ = (function (){var statearr_26205 = state_26099;
(statearr_26205[(4)] = cljs.core.cons.call(null,(5),(state_26099[(4)])));

return statearr_26205;
})();
var inst_25770__$1 = select;
var state_26099__$1 = (function (){var statearr_26206 = state_26099;
(statearr_26206[(36)] = inst_25770__$1);

return statearr_26206;
})();
if(cljs.core.truth_(inst_25770__$1)){
var statearr_26207_26385 = state_26099__$1;
(statearr_26207_26385[(1)] = (6));

} else {
var statearr_26208_26386 = state_26099__$1;
(statearr_26208_26386[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (66))){
var inst_26068 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
var statearr_26209_26387 = state_26099__$1;
(statearr_26209_26387[(2)] = inst_26068);

(statearr_26209_26387[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (107))){
var inst_26007 = (state_26099[(19)]);
var inst_26019 = (state_26099[(2)]);
var inst_26020 = fluree.db.dbproto._subid.call(null,db,inst_26007,false);
var state_26099__$1 = (function (){var statearr_26210 = state_26099;
(statearr_26210[(40)] = inst_26019);

return statearr_26210;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26099__$1,(108),inst_26020);
} else {
if((state_val_26100 === (23))){
var inst_25831 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
var statearr_26211_26388 = state_26099__$1;
(statearr_26211_26388[(2)] = inst_25831);

(statearr_26211_26388[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (47))){
var inst_25876 = cljs.core.map.call(null,fluree.db.query.fql.s);
var state_26099__$1 = (function (){var statearr_26212 = state_26099;
(statearr_26212[(26)] = inst_25876);

return statearr_26212;
})();
if(cljs.core.truth_(fuel)){
var statearr_26213_26389 = state_26099__$1;
(statearr_26213_26389[(1)] = (50));

} else {
var statearr_26214_26390 = state_26099__$1;
(statearr_26214_26390[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (35))){
var inst_25793 = (state_26099[(13)]);
var inst_25795 = (state_26099[(15)]);
var inst_25846 = (state_26099[(2)]);
var inst_25847 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25848 = [inst_25793,inst_25795];
var inst_25849 = cljs.core.PersistentHashMap.fromArrays(inst_25847,inst_25848);
var inst_25850 = fluree.db.query.fql.where_filter.call(null,db,where,inst_25846,inst_25849);
var state_26099__$1 = state_26099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26099__$1,(36),inst_25850);
} else {
if((state_val_26100 === (127))){
var inst_26089 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
if(cljs.core.truth_(inst_26089)){
var statearr_26215_26391 = state_26099__$1;
(statearr_26215_26391[(1)] = (131));

} else {
var statearr_26216_26392 = state_26099__$1;
(statearr_26216_26392[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (82))){
var inst_26064 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
var statearr_26217_26393 = state_26099__$1;
(statearr_26217_26393[(2)] = inst_26064);

(statearr_26217_26393[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (76))){
var inst_25793 = (state_26099[(13)]);
var inst_25795 = (state_26099[(15)]);
var inst_25942 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25943 = [inst_25793,inst_25795];
var inst_25944 = cljs.core.PersistentHashMap.fromArrays(inst_25942,inst_25943);
var state_26099__$1 = state_26099;
var statearr_26218_26394 = state_26099__$1;
(statearr_26218_26394[(2)] = inst_25944);

(statearr_26218_26394[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (97))){
var inst_26000 = (state_26099[(38)]);
var inst_26007 = (state_26099[(19)]);
var inst_26006 = cljs.core.seq.call(null,inst_26000);
var inst_26007__$1 = cljs.core.first.call(null,inst_26006);
var inst_26008 = cljs.core.next.call(null,inst_26006);
var inst_26009 = cljs.core.not.call(null,inst_26007__$1);
var state_26099__$1 = (function (){var statearr_26219 = state_26099;
(statearr_26219[(19)] = inst_26007__$1);

(statearr_26219[(37)] = inst_26008);

return statearr_26219;
})();
if(inst_26009){
var statearr_26220_26395 = state_26099__$1;
(statearr_26220_26395[(1)] = (99));

} else {
var statearr_26221_26396 = state_26099__$1;
(statearr_26221_26396[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (19))){
var inst_25833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25834 = [null,null];
var inst_25835 = (new cljs.core.PersistentVector(null,2,(5),inst_25833,inst_25834,null));
var state_26099__$1 = state_26099;
var statearr_26222_26397 = state_26099__$1;
(statearr_26222_26397[(2)] = inst_25835);

(statearr_26222_26397[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (57))){
var inst_25793 = (state_26099[(13)]);
var inst_25795 = (state_26099[(15)]);
var inst_25892 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25893 = [inst_25793,inst_25795];
var inst_25894 = cljs.core.PersistentHashMap.fromArrays(inst_25892,inst_25893);
var state_26099__$1 = state_26099;
var statearr_26223_26398 = state_26099__$1;
(statearr_26223_26398[(2)] = inst_25894);

(statearr_26223_26398[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (68))){
var inst_25793 = (state_26099[(13)]);
var inst_25795 = (state_26099[(15)]);
var inst_25923 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25924 = [inst_25793,inst_25795];
var inst_25925 = cljs.core.PersistentHashMap.fromArrays(inst_25923,inst_25924);
var state_26099__$1 = state_26099;
var statearr_26224_26399 = state_26099__$1;
(statearr_26224_26399[(2)] = inst_25925);

(statearr_26224_26399[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (11))){
var inst_25787 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
var statearr_26225_26400 = state_26099__$1;
(statearr_26225_26400[(2)] = inst_25787);

(statearr_26225_26400[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (115))){
var inst_25792 = (state_26099[(18)]);
var inst_26041 = (state_26099[(2)]);
var state_26099__$1 = (function (){var statearr_26227 = state_26099;
(statearr_26227[(35)] = inst_26041);

return statearr_26227;
})();
if(cljs.core.truth_(inst_25792)){
var statearr_26228_26401 = state_26099__$1;
(statearr_26228_26401[(1)] = (116));

} else {
var statearr_26229_26402 = state_26099__$1;
(statearr_26229_26402[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (9))){
var inst_25773 = (state_26099[(12)]);
var state_26099__$1 = state_26099;
var statearr_26230_26403 = state_26099__$1;
(statearr_26230_26403[(2)] = inst_25773);

(statearr_26230_26403[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (5))){
var _ = (function (){var statearr_26231 = state_26099;
(statearr_26231[(4)] = cljs.core.rest.call(null,(state_26099[(4)])));

return statearr_26231;
})();
var state_26099__$1 = state_26099;
var ex26226 = (state_26099__$1[(2)]);
var statearr_26232_26404 = state_26099__$1;
(statearr_26232_26404[(5)] = ex26226);


if((ex26226 instanceof Error)){
var statearr_26233_26405 = state_26099__$1;
(statearr_26233_26405[(1)] = (4));

(statearr_26233_26405[(5)] = null);

} else {
throw ex26226;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (112))){
var inst_26048 = (state_26099[(2)]);
var inst_26049 = fluree.db.util.async.throw_err.call(null,inst_26048);
var state_26099__$1 = state_26099;
var statearr_26234_26406 = state_26099__$1;
(statearr_26234_26406[(2)] = inst_26049);

(statearr_26234_26406[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (83))){
var inst_25962 = (state_26099[(20)]);
var inst_25961 = (state_26099[(2)]);
var inst_25962__$1 = fluree.db.util.async.throw_err.call(null,inst_25961);
var inst_25963 = (inst_25962__$1 == null);
var state_26099__$1 = (function (){var statearr_26235 = state_26099;
(statearr_26235[(20)] = inst_25962__$1);

return statearr_26235;
})();
if(cljs.core.truth_(inst_25963)){
var statearr_26236_26407 = state_26099__$1;
(statearr_26236_26407[(1)] = (84));

} else {
var statearr_26237_26408 = state_26099__$1;
(statearr_26237_26408[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (14))){
var inst_25785 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
var statearr_26238_26409 = state_26099__$1;
(statearr_26238_26409[(2)] = inst_25785);

(statearr_26238_26409[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (45))){
var inst_25867 = (state_26099[(27)]);
var state_26099__$1 = state_26099;
var statearr_26239_26410 = state_26099__$1;
(statearr_26239_26410[(2)] = inst_25867);

(statearr_26239_26410[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (53))){
var inst_25882 = (state_26099[(21)]);
var inst_25884 = cljs.core.distinct.call(null);
var inst_25885 = cljs.core.comp.call(null,inst_25882,inst_25884);
var state_26099__$1 = state_26099;
var statearr_26240_26411 = state_26099__$1;
(statearr_26240_26411[(2)] = inst_25885);

(statearr_26240_26411[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (78))){
var inst_25805 = (state_26099[(7)]);
var inst_25803 = (state_26099[(8)]);
var inst_25949 = (state_26099[(2)]);
var inst_25950 = fluree.db.util.async.throw_err.call(null,inst_25949);
var inst_25951 = fluree.db.query.fql.flake_select.call(null,db,inst_25805,fuel,max_fuel,inst_25803,inst_25950);
var state_26099__$1 = state_26099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26099__$1,(79),inst_25951);
} else {
if((state_val_26100 === (132))){
var inst_26077 = (state_26099[(11)]);
var state_26099__$1 = state_26099;
var statearr_26241_26412 = state_26099__$1;
(statearr_26241_26412[(2)] = inst_26077);

(statearr_26241_26412[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (26))){
var inst_25829 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
var statearr_26242_26413 = state_26099__$1;
(statearr_26242_26413[(2)] = inst_25829);

(statearr_26242_26413[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (123))){
var inst_26072 = (state_26099[(28)]);
var state_26099__$1 = state_26099;
var statearr_26243_26414 = state_26099__$1;
(statearr_26243_26414[(2)] = inst_26072);

(statearr_26243_26414[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (16))){
var inst_25796 = (state_26099[(24)]);
var state_26099__$1 = state_26099;
var statearr_26244_26415 = state_26099__$1;
(statearr_26244_26415[(2)] = inst_25796);

(statearr_26244_26415[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (133))){
var inst_26094 = (state_26099[(2)]);
var _ = (function (){var statearr_26245 = state_26099;
(statearr_26245[(4)] = cljs.core.rest.call(null,(state_26099[(4)])));

return statearr_26245;
})();
var state_26099__$1 = state_26099;
var statearr_26246_26416 = state_26099__$1;
(statearr_26246_26416[(2)] = inst_26094);

(statearr_26246_26416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (81))){
var inst_25981 = (state_26099[(22)]);
var inst_25981__$1 = cljs.core.sequential_QMARK_.call(null,from);
var state_26099__$1 = (function (){var statearr_26247 = state_26099;
(statearr_26247[(22)] = inst_25981__$1);

return statearr_26247;
})();
if(inst_25981__$1){
var statearr_26248_26417 = state_26099__$1;
(statearr_26248_26417[(1)] = (91));

} else {
var statearr_26249_26418 = state_26099__$1;
(statearr_26249_26418[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (120))){
var state_26099__$1 = state_26099;
var statearr_26250_26419 = state_26099__$1;
(statearr_26250_26419[(2)] = null);

(statearr_26250_26419[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (79))){
var inst_25953 = (state_26099[(2)]);
var inst_25954 = fluree.db.util.async.throw_err.call(null,inst_25953);
var state_26099__$1 = state_26099;
var statearr_26251_26420 = state_26099__$1;
(statearr_26251_26420[(2)] = inst_25954);

(statearr_26251_26420[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (38))){
var state_26099__$1 = state_26099;
var statearr_26252_26421 = state_26099__$1;
(statearr_26252_26421[(2)] = null);

(statearr_26252_26421[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (126))){
var inst_26078 = (state_26099[(41)]);
var state_26099__$1 = state_26099;
var statearr_26253_26422 = state_26099__$1;
(statearr_26253_26422[(2)] = inst_26078);

(statearr_26253_26422[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (98))){
var inst_25792 = (state_26099[(18)]);
var inst_26035 = (state_26099[(2)]);
var inst_26036 = cljs.core.PersistentVector.EMPTY;
var inst_26037 = cljs.core.into.call(null,inst_26036,inst_26035);
var state_26099__$1 = (function (){var statearr_26254 = state_26099;
(statearr_26254[(34)] = inst_26037);

return statearr_26254;
})();
if(cljs.core.truth_(inst_25792)){
var statearr_26255_26423 = state_26099__$1;
(statearr_26255_26423[(1)] = (113));

} else {
var statearr_26256_26424 = state_26099__$1;
(statearr_26256_26424[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (124))){
var inst_26078 = (state_26099[(41)]);
var inst_26077 = (state_26099[(2)]);
var inst_26078__$1 = selectOne;
var state_26099__$1 = (function (){var statearr_26257 = state_26099;
(statearr_26257[(41)] = inst_26078__$1);

(statearr_26257[(11)] = inst_26077);

return statearr_26257;
})();
if(cljs.core.truth_(inst_26078__$1)){
var statearr_26258_26425 = state_26099__$1;
(statearr_26258_26425[(1)] = (125));

} else {
var statearr_26259_26426 = state_26099__$1;
(statearr_26259_26426[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (87))){
var inst_25973 = (state_26099[(2)]);
var inst_25974 = fluree.db.util.async.throw_err.call(null,inst_25973);
var state_26099__$1 = (function (){var statearr_26260 = state_26099;
(statearr_26260[(31)] = inst_25974);

return statearr_26260;
})();
if(cljs.core.truth_(fuel)){
var statearr_26261_26427 = state_26099__$1;
(statearr_26261_26427[(1)] = (88));

} else {
var statearr_26262_26428 = state_26099__$1;
(statearr_26262_26428[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (30))){
var inst_25842 = typeof from === 'string';
var state_26099__$1 = state_26099;
if(cljs.core.truth_(inst_25842)){
var statearr_26263_26429 = state_26099__$1;
(statearr_26263_26429[(1)] = (33));

} else {
var statearr_26264_26430 = state_26099__$1;
(statearr_26264_26430[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (73))){
var inst_25956 = fluree.db.util.core.subj_ident_QMARK_.call(null,from);
var state_26099__$1 = state_26099;
if(inst_25956){
var statearr_26265_26431 = state_26099__$1;
(statearr_26265_26431[(1)] = (80));

} else {
var statearr_26266_26432 = state_26099__$1;
(statearr_26266_26432[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (96))){
var inst_26062 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
var statearr_26267_26433 = state_26099__$1;
(statearr_26267_26433[(2)] = inst_26062);

(statearr_26267_26433[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (10))){
var inst_25776 = (state_26099[(39)]);
var inst_25776__$1 = selectDistinct;
var state_26099__$1 = (function (){var statearr_26268 = state_26099;
(statearr_26268[(39)] = inst_25776__$1);

return statearr_26268;
})();
if(cljs.core.truth_(inst_25776__$1)){
var statearr_26269_26434 = state_26099__$1;
(statearr_26269_26434[(1)] = (12));

} else {
var statearr_26270_26435 = state_26099__$1;
(statearr_26270_26435[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (18))){
var inst_25792 = (state_26099[(18)]);
var inst_25807 = cljs.core.vector_QMARK_.call(null,inst_25792);
var state_26099__$1 = state_26099;
if(inst_25807){
var statearr_26271_26436 = state_26099__$1;
(statearr_26271_26436[(1)] = (21));

} else {
var statearr_26272_26437 = state_26099__$1;
(statearr_26272_26437[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (105))){
var inst_26016 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core.inc);
var state_26099__$1 = state_26099;
var statearr_26273_26438 = state_26099__$1;
(statearr_26273_26438[(2)] = inst_26016);

(statearr_26273_26438[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (52))){
var inst_25882 = (state_26099[(2)]);
var state_26099__$1 = (function (){var statearr_26274 = state_26099;
(statearr_26274[(21)] = inst_25882);

return statearr_26274;
})();
var statearr_26275_26439 = state_26099__$1;
(statearr_26275_26439[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (114))){
var inst_25793 = (state_26099[(13)]);
var state_26099__$1 = state_26099;
var statearr_26277_26440 = state_26099__$1;
(statearr_26277_26440[(2)] = inst_25793);

(statearr_26277_26440[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (67))){
var inst_25921 = cljs.core.PersistentHashMap.EMPTY;
var state_26099__$1 = state_26099;
var statearr_26278_26441 = state_26099__$1;
(statearr_26278_26441[(2)] = inst_25921);

(statearr_26278_26441[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (71))){
var inst_25934 = (state_26099[(2)]);
var inst_25935 = fluree.db.util.async.throw_err.call(null,inst_25934);
var state_26099__$1 = state_26099;
var statearr_26279_26442 = state_26099__$1;
(statearr_26279_26442[(2)] = inst_25935);

(statearr_26279_26442[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (42))){
var inst_25795 = (state_26099[(15)]);
var state_26099__$1 = state_26099;
var statearr_26280_26443 = state_26099__$1;
(statearr_26280_26443[(2)] = inst_25795);

(statearr_26280_26443[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (80))){
var inst_25959 = fluree.db.dbproto._subid.call(null,db,from,false);
var state_26099__$1 = state_26099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26099__$1,(83),inst_25959);
} else {
if((state_val_26100 === (37))){
var inst_25864 = (state_26099[(2)]);
var inst_25865 = fluree.db.util.async.throw_err.call(null,inst_25864);
var state_26099__$1 = state_26099;
var statearr_26281_26444 = state_26099__$1;
(statearr_26281_26444[(2)] = inst_25865);

(statearr_26281_26444[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (63))){
var inst_25918 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
if(cljs.core.truth_(inst_25918)){
var statearr_26282_26445 = state_26099__$1;
(statearr_26282_26445[(1)] = (64));

} else {
var statearr_26283_26446 = state_26099__$1;
(statearr_26283_26446[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (94))){
var inst_25995 = from;
var inst_25996 = cljs.core.seq.call(null,inst_25995);
var inst_25997 = cljs.core.first.call(null,inst_25996);
var inst_25998 = cljs.core.next.call(null,inst_25996);
var inst_25999 = cljs.core.PersistentVector.EMPTY;
var inst_26000 = inst_25995;
var inst_26001 = inst_25999;
var state_26099__$1 = (function (){var statearr_26284 = state_26099;
(statearr_26284[(10)] = inst_26001);

(statearr_26284[(42)] = inst_25997);

(statearr_26284[(38)] = inst_26000);

(statearr_26284[(43)] = inst_25998);

return statearr_26284;
})();
var statearr_26285_26447 = state_26099__$1;
(statearr_26285_26447[(2)] = null);

(statearr_26285_26447[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (8))){
var inst_25794 = (state_26099[(25)]);
var inst_25789 = (state_26099[(2)]);
var inst_25790 = opts_SINGLEQUOTE_;
var inst_25791 = cljs.core.__destructure_map.call(null,inst_25790);
var inst_25792 = cljs.core.get.call(null,inst_25791,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_25793 = cljs.core.get.call(null,inst_25791,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25794__$1 = cljs.core.get.call(null,inst_25791,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_25795 = cljs.core.get.call(null,inst_25791,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_25796 = fluree.db.query.fql_parser.parse_db.call(null,db,inst_25789,opts_SINGLEQUOTE_);
var inst_25797 = (inst_25794__$1 == null);
var inst_25798 = cljs.core.not.call(null,inst_25797);
var state_26099__$1 = (function (){var statearr_26286 = state_26099;
(statearr_26286[(24)] = inst_25796);

(statearr_26286[(13)] = inst_25793);

(statearr_26286[(18)] = inst_25792);

(statearr_26286[(15)] = inst_25795);

(statearr_26286[(25)] = inst_25794__$1);

return statearr_26286;
})();
if(inst_25798){
var statearr_26287_26448 = state_26099__$1;
(statearr_26287_26448[(1)] = (15));

} else {
var statearr_26288_26449 = state_26099__$1;
(statearr_26288_26449[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (49))){
var inst_26070 = (state_26099[(2)]);
var state_26099__$1 = state_26099;
var statearr_26289_26450 = state_26099__$1;
(statearr_26289_26450[(2)] = inst_26070);

(statearr_26289_26450[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26100 === (84))){
var state_26099__$1 = state_26099;
var statearr_26290_26451 = state_26099__$1;
(statearr_26290_26451[(2)] = null);

(statearr_26290_26451[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2746__auto____0 = (function (){
var statearr_26291 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26291[(0)] = fluree$db$query$fql$query_$_state_machine__2746__auto__);

(statearr_26291[(1)] = (1));

return statearr_26291;
});
var fluree$db$query$fql$query_$_state_machine__2746__auto____1 = (function (state_26099){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26099);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26292){var ex__2749__auto__ = e26292;
var statearr_26293_26452 = state_26099;
(statearr_26293_26452[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26099[(4)]))){
var statearr_26294_26453 = state_26099;
(statearr_26294_26453[(1)] = cljs.core.first.call(null,(state_26099[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26454 = state_26099;
state_26099 = G__26454;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2746__auto__ = function(state_26099){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2746__auto____1.call(this,state_26099);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2746__auto____0;
fluree$db$query$fql$query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2746__auto____1;
return fluree$db$query$fql$query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26295 = f__2769__auto__.call(null);
(statearr_26295[(6)] = c__2768__auto__);

return statearr_26295;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}

});
