// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.call(null,index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.get.call(null,text,counter))){
var G__65543 = (line + (1));
var G__65544 = (1);
var G__65545 = (counter + (1));
line = G__65543;
col = G__65544;
counter = G__65545;
continue;
} else {
var G__65546 = line;
var G__65547 = (col + (1));
var G__65548 = (counter + (1));
line = G__65546;
col = G__65547;
counter = G__65548;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq.call(null,clojure.string.replace.call(null,text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_.call(null,chars)){
return "";
} else {
if(cljs.core._EQ_.call(null,n__$1,(1))){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.take_while.call(null,cljs.core.complement.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.first.call(null,chars))){
var G__65549 = cljs.core.next.call(null,chars);
var G__65550 = (n__$1 - (1));
chars = G__65549;
n__$1 = G__65550;
continue;
} else {
var G__65551 = cljs.core.next.call(null,chars);
var G__65552 = n__$1;
chars = G__65551;
n__$1 = G__65552;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 * and accounts for horizontal tabs which might change
 * the alignment of the '^' to the error location.
 */
instaparse.failure.marker = (function instaparse$failure$marker(text,n){
if(cljs.core.truth_((function (){var and__4251__auto__ = text;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.integer_QMARK_.call(null,n);
} else {
return and__4251__auto__;
}
})())){
var marker_text = clojure.string.replace.call(null,text,/[^\s]/," ");
if((n <= (1))){
return "^";
} else {
return [cljs.core.subs.call(null,marker_text,(0),(n - (1))),"^"].join('');
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column.call(null,new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.call(null,failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line.call(null,new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.call(null,"NOT ");

return cljs.core.print.call(null,new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.call(null,instaparse.print.char_range__GT_str.call(null,r));
} else {
if((r instanceof RegExp)){
return cljs.core.print.call(null,instaparse.print.regexp__GT_str.call(null,r));
} else {
return cljs.core.pr.call(null,r);

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__65553){
var map__65554 = p__65553;
var map__65554__$1 = cljs.core.__destructure_map.call(null,map__65554);
var line = cljs.core.get.call(null,map__65554__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__65554__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.call(null,map__65554__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.call(null,map__65554__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.call(null,["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join(''));

cljs.core.println.call(null,text);

cljs.core.println.call(null,instaparse.failure.marker.call(null,text,column));

var full_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,cljs.core.complement.call(null,new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count.call(null,full_reasons) + cljs.core.count.call(null,partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.call(null,(1),total)){
cljs.core.println.call(null,"Expected:");
} else {
cljs.core.println.call(null,"Expected one of:");

}
}

var seq__65555_65563 = cljs.core.seq.call(null,full_reasons);
var chunk__65556_65564 = null;
var count__65557_65565 = (0);
var i__65558_65566 = (0);
while(true){
if((i__65558_65566 < count__65557_65565)){
var r_65567 = cljs.core._nth.call(null,chunk__65556_65564,i__65558_65566);
instaparse.failure.print_reason.call(null,r_65567);

cljs.core.println.call(null," (followed by end-of-string)");


var G__65568 = seq__65555_65563;
var G__65569 = chunk__65556_65564;
var G__65570 = count__65557_65565;
var G__65571 = (i__65558_65566 + (1));
seq__65555_65563 = G__65568;
chunk__65556_65564 = G__65569;
count__65557_65565 = G__65570;
i__65558_65566 = G__65571;
continue;
} else {
var temp__5753__auto___65572 = cljs.core.seq.call(null,seq__65555_65563);
if(temp__5753__auto___65572){
var seq__65555_65573__$1 = temp__5753__auto___65572;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__65555_65573__$1)){
var c__4679__auto___65574 = cljs.core.chunk_first.call(null,seq__65555_65573__$1);
var G__65575 = cljs.core.chunk_rest.call(null,seq__65555_65573__$1);
var G__65576 = c__4679__auto___65574;
var G__65577 = cljs.core.count.call(null,c__4679__auto___65574);
var G__65578 = (0);
seq__65555_65563 = G__65575;
chunk__65556_65564 = G__65576;
count__65557_65565 = G__65577;
i__65558_65566 = G__65578;
continue;
} else {
var r_65579 = cljs.core.first.call(null,seq__65555_65573__$1);
instaparse.failure.print_reason.call(null,r_65579);

cljs.core.println.call(null," (followed by end-of-string)");


var G__65580 = cljs.core.next.call(null,seq__65555_65573__$1);
var G__65581 = null;
var G__65582 = (0);
var G__65583 = (0);
seq__65555_65563 = G__65580;
chunk__65556_65564 = G__65581;
count__65557_65565 = G__65582;
i__65558_65566 = G__65583;
continue;
}
} else {
}
}
break;
}

var seq__65559 = cljs.core.seq.call(null,partial_reasons);
var chunk__65560 = null;
var count__65561 = (0);
var i__65562 = (0);
while(true){
if((i__65562 < count__65561)){
var r = cljs.core._nth.call(null,chunk__65560,i__65562);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__65584 = seq__65559;
var G__65585 = chunk__65560;
var G__65586 = count__65561;
var G__65587 = (i__65562 + (1));
seq__65559 = G__65584;
chunk__65560 = G__65585;
count__65561 = G__65586;
i__65562 = G__65587;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__65559);
if(temp__5753__auto__){
var seq__65559__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__65559__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__65559__$1);
var G__65588 = cljs.core.chunk_rest.call(null,seq__65559__$1);
var G__65589 = c__4679__auto__;
var G__65590 = cljs.core.count.call(null,c__4679__auto__);
var G__65591 = (0);
seq__65559 = G__65588;
chunk__65560 = G__65589;
count__65561 = G__65590;
i__65562 = G__65591;
continue;
} else {
var r = cljs.core.first.call(null,seq__65559__$1);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__65592 = cljs.core.next.call(null,seq__65559__$1);
var G__65593 = null;
var G__65594 = (0);
var G__65595 = (0);
seq__65559 = G__65592;
chunk__65560 = G__65593;
count__65561 = G__65594;
i__65562 = G__65595;
continue;
}
} else {
return null;
}
}
break;
}
});
