// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__61504_61673 = cljs.core.seq(servers);
var chunk__61505_61674 = null;
var count__61506_61675 = (0);
var i__61507_61676 = (0);
while(true){
if((i__61507_61676 < count__61506_61675)){
var server_61677 = chunk__61505_61674.cljs$core$IIndexed$_nth$arity$2(null,i__61507_61676);
var healthcheck_uri_61678 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_61677),"/fdb/health"].join('');
var resp_chan_61679 = fluree.db.util.xhttp.post_json(healthcheck_uri_61678,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2749__auto___61680 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__61504_61673,chunk__61505_61674,count__61506_61675,i__61507_61676,c__2749__auto___61680,healthcheck_uri_61678,resp_chan_61679,server_61677){
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = ((function (seq__61504_61673,chunk__61505_61674,count__61506_61675,i__61507_61676,c__2749__auto___61680,healthcheck_uri_61678,resp_chan_61679,server_61677){
return (function (state_61568){
var state_val_61569 = (state_61568[(1)]);
if((state_val_61569 === (1))){
var state_61568__$1 = state_61568;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61568__$1,(2),resp_chan_61679);
} else {
if((state_val_61569 === (2))){
var inst_61557 = (state_61568[(7)]);
var inst_61557__$1 = (state_61568[(2)]);
var inst_61558 = fluree.db.util.core.exception_QMARK_(inst_61557__$1);
var state_61568__$1 = (function (){var statearr_61570 = state_61568;
(statearr_61570[(7)] = inst_61557__$1);

return statearr_61570;
})();
if(inst_61558){
var statearr_61571_61681 = state_61568__$1;
(statearr_61571_61681[(1)] = (3));

} else {
var statearr_61572_61682 = state_61568__$1;
(statearr_61572_61682[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61569 === (3))){
var inst_61557 = (state_61568[(7)]);
var inst_61560 = cljs.core.ex_message(inst_61557);
var inst_61561 = cljs.core.ex_data(inst_61557);
var inst_61562 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_61560,inst_61561], 0));
var state_61568__$1 = state_61568;
var statearr_61573_61683 = state_61568__$1;
(statearr_61573_61683[(2)] = inst_61562);

(statearr_61573_61683[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61569 === (4))){
var inst_61564 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_61677);
var state_61568__$1 = state_61568;
var statearr_61574_61684 = state_61568__$1;
(statearr_61574_61684[(2)] = inst_61564);

(statearr_61574_61684[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61569 === (5))){
var inst_61566 = (state_61568[(2)]);
var state_61568__$1 = state_61568;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61568__$1,inst_61566);
} else {
return null;
}
}
}
}
}
});})(seq__61504_61673,chunk__61505_61674,count__61506_61675,i__61507_61676,c__2749__auto___61680,healthcheck_uri_61678,resp_chan_61679,server_61677))
;
return ((function (seq__61504_61673,chunk__61505_61674,count__61506_61675,i__61507_61676,switch__2726__auto__,c__2749__auto___61680,healthcheck_uri_61678,resp_chan_61679,server_61677){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_61575 = [null,null,null,null,null,null,null,null];
(statearr_61575[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_61575[(1)] = (1));

return statearr_61575;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_61568){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_61568);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e61576){var ex__2730__auto__ = e61576;
var statearr_61577_61685 = state_61568;
(statearr_61577_61685[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_61568[(4)]))){
var statearr_61578_61686 = state_61568;
(statearr_61578_61686[(1)] = cljs.core.first((state_61568[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61687 = state_61568;
state_61568 = G__61687;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_61568){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_61568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
;})(seq__61504_61673,chunk__61505_61674,count__61506_61675,i__61507_61676,switch__2726__auto__,c__2749__auto___61680,healthcheck_uri_61678,resp_chan_61679,server_61677))
})();
var state__2751__auto__ = (function (){var statearr_61579 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_61579[(6)] = c__2749__auto___61680);

return statearr_61579;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});})(seq__61504_61673,chunk__61505_61674,count__61506_61675,i__61507_61676,c__2749__auto___61680,healthcheck_uri_61678,resp_chan_61679,server_61677))
);



var G__61688 = seq__61504_61673;
var G__61689 = chunk__61505_61674;
var G__61690 = count__61506_61675;
var G__61691 = (i__61507_61676 + (1));
seq__61504_61673 = G__61688;
chunk__61505_61674 = G__61689;
count__61506_61675 = G__61690;
i__61507_61676 = G__61691;
continue;
} else {
var temp__5753__auto___61692 = cljs.core.seq(seq__61504_61673);
if(temp__5753__auto___61692){
var seq__61504_61693__$1 = temp__5753__auto___61692;
if(cljs.core.chunked_seq_QMARK_(seq__61504_61693__$1)){
var c__4679__auto___61694 = cljs.core.chunk_first(seq__61504_61693__$1);
var G__61695 = cljs.core.chunk_rest(seq__61504_61693__$1);
var G__61696 = c__4679__auto___61694;
var G__61697 = cljs.core.count(c__4679__auto___61694);
var G__61698 = (0);
seq__61504_61673 = G__61695;
chunk__61505_61674 = G__61696;
count__61506_61675 = G__61697;
i__61507_61676 = G__61698;
continue;
} else {
var server_61699 = cljs.core.first(seq__61504_61693__$1);
var healthcheck_uri_61700 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_61699),"/fdb/health"].join('');
var resp_chan_61701 = fluree.db.util.xhttp.post_json(healthcheck_uri_61700,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2749__auto___61702 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__61504_61673,chunk__61505_61674,count__61506_61675,i__61507_61676,c__2749__auto___61702,healthcheck_uri_61700,resp_chan_61701,server_61699,seq__61504_61693__$1,temp__5753__auto___61692){
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = ((function (seq__61504_61673,chunk__61505_61674,count__61506_61675,i__61507_61676,c__2749__auto___61702,healthcheck_uri_61700,resp_chan_61701,server_61699,seq__61504_61693__$1,temp__5753__auto___61692){
return (function (state_61592){
var state_val_61593 = (state_61592[(1)]);
if((state_val_61593 === (1))){
var state_61592__$1 = state_61592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61592__$1,(2),resp_chan_61701);
} else {
if((state_val_61593 === (2))){
var inst_61581 = (state_61592[(7)]);
var inst_61581__$1 = (state_61592[(2)]);
var inst_61582 = fluree.db.util.core.exception_QMARK_(inst_61581__$1);
var state_61592__$1 = (function (){var statearr_61594 = state_61592;
(statearr_61594[(7)] = inst_61581__$1);

return statearr_61594;
})();
if(inst_61582){
var statearr_61595_61703 = state_61592__$1;
(statearr_61595_61703[(1)] = (3));

} else {
var statearr_61596_61704 = state_61592__$1;
(statearr_61596_61704[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61593 === (3))){
var inst_61581 = (state_61592[(7)]);
var inst_61584 = cljs.core.ex_message(inst_61581);
var inst_61585 = cljs.core.ex_data(inst_61581);
var inst_61586 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_61584,inst_61585], 0));
var state_61592__$1 = state_61592;
var statearr_61597_61705 = state_61592__$1;
(statearr_61597_61705[(2)] = inst_61586);

(statearr_61597_61705[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61593 === (4))){
var inst_61588 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_61699);
var state_61592__$1 = state_61592;
var statearr_61598_61706 = state_61592__$1;
(statearr_61598_61706[(2)] = inst_61588);

(statearr_61598_61706[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61593 === (5))){
var inst_61590 = (state_61592[(2)]);
var state_61592__$1 = state_61592;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61592__$1,inst_61590);
} else {
return null;
}
}
}
}
}
});})(seq__61504_61673,chunk__61505_61674,count__61506_61675,i__61507_61676,c__2749__auto___61702,healthcheck_uri_61700,resp_chan_61701,server_61699,seq__61504_61693__$1,temp__5753__auto___61692))
;
return ((function (seq__61504_61673,chunk__61505_61674,count__61506_61675,i__61507_61676,switch__2726__auto__,c__2749__auto___61702,healthcheck_uri_61700,resp_chan_61701,server_61699,seq__61504_61693__$1,temp__5753__auto___61692){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_61599 = [null,null,null,null,null,null,null,null];
(statearr_61599[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_61599[(1)] = (1));

return statearr_61599;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_61592){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_61592);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e61600){var ex__2730__auto__ = e61600;
var statearr_61601_61707 = state_61592;
(statearr_61601_61707[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_61592[(4)]))){
var statearr_61602_61708 = state_61592;
(statearr_61602_61708[(1)] = cljs.core.first((state_61592[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61709 = state_61592;
state_61592 = G__61709;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_61592){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_61592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
;})(seq__61504_61673,chunk__61505_61674,count__61506_61675,i__61507_61676,switch__2726__auto__,c__2749__auto___61702,healthcheck_uri_61700,resp_chan_61701,server_61699,seq__61504_61693__$1,temp__5753__auto___61692))
})();
var state__2751__auto__ = (function (){var statearr_61603 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_61603[(6)] = c__2749__auto___61702);

return statearr_61603;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});})(seq__61504_61673,chunk__61505_61674,count__61506_61675,i__61507_61676,c__2749__auto___61702,healthcheck_uri_61700,resp_chan_61701,server_61699,seq__61504_61693__$1,temp__5753__auto___61692))
);



var G__61710 = cljs.core.next(seq__61504_61693__$1);
var G__61711 = null;
var G__61712 = (0);
var G__61713 = (0);
seq__61504_61673 = G__61710;
chunk__61505_61674 = G__61711;
count__61506_61675 = G__61712;
i__61507_61676 = G__61713;
continue;
}
} else {
}
}
break;
}

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_61647){
var state_val_61648 = (state_61647[(1)]);
if((state_val_61648 === (7))){
var inst_61619 = (state_61647[(7)]);
var inst_61626 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61619,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_61647__$1 = state_61647;
if(inst_61626){
var statearr_61649_61714 = state_61647__$1;
(statearr_61649_61714[(1)] = (9));

} else {
var statearr_61650_61715 = state_61647__$1;
(statearr_61650_61715[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61648 === (1))){
var inst_61611 = (state_61647[(8)]);
var inst_61612 = (state_61647[(9)]);
var inst_61611__$1 = promise_chan;
var inst_61612__$1 = cljs.core.async.timeout((60000));
var inst_61613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61614 = [inst_61611__$1,inst_61612__$1];
var inst_61615 = (new cljs.core.PersistentVector(null,2,(5),inst_61613,inst_61614,null));
var state_61647__$1 = (function (){var statearr_61651 = state_61647;
(statearr_61651[(8)] = inst_61611__$1);

(statearr_61651[(9)] = inst_61612__$1);

return statearr_61651;
})();
return cljs.core.async.ioc_alts_BANG_(state_61647__$1,(2),inst_61615);
} else {
if((state_val_61648 === (4))){
var inst_61612 = (state_61647[(9)]);
var inst_61619 = (state_61647[(7)]);
var inst_61623 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61619,inst_61612);
var state_61647__$1 = state_61647;
if(inst_61623){
var statearr_61652_61716 = state_61647__$1;
(statearr_61652_61716[(1)] = (6));

} else {
var statearr_61653_61717 = state_61647__$1;
(statearr_61653_61717[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61648 === (13))){
var state_61647__$1 = state_61647;
var statearr_61654_61718 = state_61647__$1;
(statearr_61654_61718[(2)] = null);

(statearr_61654_61718[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61648 === (6))){
var state_61647__$1 = state_61647;
var statearr_61655_61719 = state_61647__$1;
(statearr_61655_61719[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_61655_61719[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61648 === (3))){
var state_61647__$1 = state_61647;
var statearr_61656_61720 = state_61647__$1;
(statearr_61656_61720[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_61656_61720[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61648 === (12))){
var inst_61637 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_61638 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61639 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_61640 = cljs.core.PersistentHashMap.fromArrays(inst_61638,inst_61639);
var inst_61641 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_61640);
var inst_61642 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_61641);
var state_61647__$1 = (function (){var statearr_61657 = state_61647;
(statearr_61657[(10)] = inst_61637);

return statearr_61657;
})();
var statearr_61658_61721 = state_61647__$1;
(statearr_61658_61721[(2)] = inst_61642);

(statearr_61658_61721[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61648 === (2))){
var inst_61611 = (state_61647[(8)]);
var inst_61619 = (state_61647[(7)]);
var inst_61617 = (state_61647[(2)]);
var inst_61618 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61617,(0),null);
var inst_61619__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61617,(1),null);
var inst_61620 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61619__$1,inst_61611);
var state_61647__$1 = (function (){var statearr_61659 = state_61647;
(statearr_61659[(11)] = inst_61618);

(statearr_61659[(7)] = inst_61619__$1);

return statearr_61659;
})();
if(inst_61620){
var statearr_61660_61722 = state_61647__$1;
(statearr_61660_61722[(1)] = (3));

} else {
var statearr_61661_61723 = state_61647__$1;
(statearr_61661_61723[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61648 === (11))){
var inst_61630 = (state_61647[(2)]);
var state_61647__$1 = state_61647;
var statearr_61662_61724 = state_61647__$1;
(statearr_61662_61724[(2)] = inst_61630);

(statearr_61662_61724[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61648 === (9))){
var inst_61618 = (state_61647[(11)]);
var state_61647__$1 = state_61647;
var statearr_61663_61725 = state_61647__$1;
(statearr_61663_61725[(2)] = inst_61618);

(statearr_61663_61725[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61648 === (5))){
var inst_61634 = (state_61647[(2)]);
var inst_61635 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_61634);
var state_61647__$1 = state_61647;
if(inst_61635){
var statearr_61664_61726 = state_61647__$1;
(statearr_61664_61726[(1)] = (12));

} else {
var statearr_61665_61727 = state_61647__$1;
(statearr_61665_61727[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61648 === (14))){
var inst_61645 = (state_61647[(2)]);
var state_61647__$1 = state_61647;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61647__$1,inst_61645);
} else {
if((state_val_61648 === (10))){
var state_61647__$1 = state_61647;
var statearr_61666_61728 = state_61647__$1;
(statearr_61666_61728[(2)] = null);

(statearr_61666_61728[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61648 === (8))){
var inst_61632 = (state_61647[(2)]);
var state_61647__$1 = state_61647;
var statearr_61667_61729 = state_61647__$1;
(statearr_61667_61729[(2)] = inst_61632);

(statearr_61667_61729[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_61668 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61668[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_61668[(1)] = (1));

return statearr_61668;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_61647){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_61647);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e61669){var ex__2730__auto__ = e61669;
var statearr_61670_61730 = state_61647;
(statearr_61670_61730[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_61647[(4)]))){
var statearr_61671_61731 = state_61647;
(statearr_61671_61731[(1)] = cljs.core.first((state_61647[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61732 = state_61647;
state_61647 = G__61732;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_61647){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_61647);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_61672 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_61672[(6)] = c__2749__auto__);

return statearr_61672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_61776){
var state_val_61777 = (state_61776[(1)]);
if((state_val_61777 === (7))){
var state_61776__$1 = state_61776;
var statearr_61778_61804 = state_61776__$1;
(statearr_61778_61804[(2)] = null);

(statearr_61778_61804[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61777 === (1))){
var state_61776__$1 = state_61776;
var statearr_61779_61805 = state_61776__$1;
(statearr_61779_61805[(2)] = null);

(statearr_61779_61805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61777 === (4))){
var inst_61733 = (state_61776[(2)]);
var state_61776__$1 = state_61776;
var statearr_61780_61806 = state_61776__$1;
(statearr_61780_61806[(2)] = inst_61733);

(statearr_61780_61806[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61777 === (6))){
var inst_61755 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_61776__$1 = state_61776;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61776__$1,(9),inst_61755);
} else {
if((state_val_61777 === (3))){
var inst_61774 = (state_61776[(2)]);
var state_61776__$1 = state_61776;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61776__$1,inst_61774);
} else {
if((state_val_61777 === (12))){
var inst_61768 = (state_61776[(2)]);
var state_61776__$1 = state_61776;
var statearr_61781_61807 = state_61776__$1;
(statearr_61781_61807[(2)] = inst_61768);

(statearr_61781_61807[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61777 === (2))){
var inst_61744 = (state_61776[(7)]);
var inst_61739 = (state_61776[(8)]);
var inst_61749 = (state_61776[(9)]);
var _ = (function (){var statearr_61782 = state_61776;
(statearr_61782[(4)] = cljs.core.cons((5),(state_61776[(4)])));

return statearr_61782;
})();
var inst_61739__$1 = fluree.db.util.core.random_uuid();
var inst_61740 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61741 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_61742 = (new cljs.core.PersistentVector(null,2,(5),inst_61740,inst_61741,null));
var inst_61743 = (function (){var lock_id = inst_61739__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_61744__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_61742,inst_61743);
var inst_61745 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61746 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_61747 = (new cljs.core.PersistentVector(null,3,(5),inst_61745,inst_61746,null));
var inst_61748 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61744__$1,inst_61747);
var inst_61749__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61739__$1,inst_61748);
var inst_61750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61751 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_61752 = (new cljs.core.PersistentVector(null,3,(5),inst_61750,inst_61751,null));
var inst_61753 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61744__$1,inst_61752);
var state_61776__$1 = (function (){var statearr_61783 = state_61776;
(statearr_61783[(10)] = inst_61753);

(statearr_61783[(7)] = inst_61744__$1);

(statearr_61783[(8)] = inst_61739__$1);

(statearr_61783[(9)] = inst_61749__$1);

return statearr_61783;
})();
if(inst_61749__$1){
var statearr_61784_61808 = state_61776__$1;
(statearr_61784_61808[(1)] = (6));

} else {
var statearr_61785_61809 = state_61776__$1;
(statearr_61785_61809[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61777 === (11))){
var inst_61759 = (state_61776[(11)]);
var inst_61753 = (state_61776[(10)]);
var inst_61760 = (state_61776[(12)]);
var inst_61766 = fluree.db.util.xhttp.try_socket(inst_61759,sub_chan,pub_chan,inst_61753,(60000),inst_61760);
var state_61776__$1 = state_61776;
var statearr_61787_61810 = state_61776__$1;
(statearr_61787_61810[(2)] = inst_61766);

(statearr_61787_61810[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61777 === (9))){
var inst_61759 = (state_61776[(11)]);
var inst_61753 = (state_61776[(10)]);
var inst_61744 = (state_61776[(7)]);
var inst_61739 = (state_61776[(8)]);
var inst_61757 = (state_61776[(13)]);
var inst_61749 = (state_61776[(9)]);
var inst_61757__$1 = (state_61776[(2)]);
var inst_61758 = clojure.string.replace(inst_61757__$1,"http","ws");
var inst_61759__$1 = [inst_61758,"/fdb/ws"].join('');
var inst_61760 = (function (){var lock_id = inst_61739;
var state = inst_61744;
var have_lock_QMARK_ = inst_61749;
var resp_chan = inst_61753;
var healthy_server = inst_61757__$1;
var ws_url = inst_61759__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_61761 = fluree.db.util.core.exception_QMARK_(inst_61757__$1);
var state_61776__$1 = (function (){var statearr_61788 = state_61776;
(statearr_61788[(11)] = inst_61759__$1);

(statearr_61788[(12)] = inst_61760);

(statearr_61788[(13)] = inst_61757__$1);

return statearr_61788;
})();
if(inst_61761){
var statearr_61789_61811 = state_61776__$1;
(statearr_61789_61811[(1)] = (10));

} else {
var statearr_61790_61812 = state_61776__$1;
(statearr_61790_61812[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61777 === (5))){
var _ = (function (){var statearr_61791 = state_61776;
(statearr_61791[(4)] = cljs.core.rest((state_61776[(4)])));

return statearr_61791;
})();
var state_61776__$1 = state_61776;
var ex61786 = (state_61776__$1[(2)]);
var statearr_61792_61813 = state_61776__$1;
(statearr_61792_61813[(5)] = ex61786);


if((ex61786 instanceof Error)){
var statearr_61793_61814 = state_61776__$1;
(statearr_61793_61814[(1)] = (4));

(statearr_61793_61814[(5)] = null);

} else {
throw ex61786;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61777 === (10))){
var inst_61753 = (state_61776[(10)]);
var inst_61757 = (state_61776[(13)]);
var inst_61763 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_61764 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_61753,inst_61757);
var state_61776__$1 = (function (){var statearr_61794 = state_61776;
(statearr_61794[(14)] = inst_61763);

return statearr_61794;
})();
var statearr_61795_61815 = state_61776__$1;
(statearr_61795_61815[(2)] = inst_61764);

(statearr_61795_61815[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61777 === (8))){
var inst_61753 = (state_61776[(10)]);
var inst_61771 = (state_61776[(2)]);
var _ = (function (){var statearr_61796 = state_61776;
(statearr_61796[(4)] = cljs.core.rest((state_61776[(4)])));

return statearr_61796;
})();
var state_61776__$1 = (function (){var statearr_61797 = state_61776;
(statearr_61797[(15)] = inst_61771);

return statearr_61797;
})();
var statearr_61798_61816 = state_61776__$1;
(statearr_61798_61816[(2)] = inst_61753);

(statearr_61798_61816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2727__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_61799 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61799[(0)] = fluree$db$connection$establish_socket_$_state_machine__2727__auto__);

(statearr_61799[(1)] = (1));

return statearr_61799;
});
var fluree$db$connection$establish_socket_$_state_machine__2727__auto____1 = (function (state_61776){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_61776);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e61800){var ex__2730__auto__ = e61800;
var statearr_61801_61817 = state_61776;
(statearr_61801_61817[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_61776[(4)]))){
var statearr_61802_61818 = state_61776;
(statearr_61802_61818[(1)] = cljs.core.first((state_61776[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61819 = state_61776;
state_61776 = G__61819;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2727__auto__ = function(state_61776){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2727__auto____1.call(this,state_61776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2727__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2727__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_61803 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_61803[(6)] = c__2749__auto__);

return statearr_61803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k61821,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__61825 = k61821;
var G__61825__$1 = (((G__61825 instanceof cljs.core.Keyword))?G__61825.fqn:null);
switch (G__61825__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k61821,else__4505__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__61826){
var vec__61827 = p__61826;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61827,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61827,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__61820){
var self__ = this;
var G__61820__$1 = this;
return (new cljs.core.RecordIter((0),G__61820__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (22 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__61830 = (function (coll__4499__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__61830(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this61822,other61823){
var self__ = this;
var this61822__$1 = this;
return (((!((other61823 == null)))) && ((((this61822__$1.constructor === other61823.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.id,other61823.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.servers,other61823.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.state,other61823.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.req_chan,other61823.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.sub_chan,other61823.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.pub_chan,other61823.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.group,other61823.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.storage_read,other61823.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.storage_write,other61823.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.object_cache,other61823.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.parallelism,other61823.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.serializer,other61823.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.default_network,other61823.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.transactor_QMARK_,other61823.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.publish,other61823.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.transact_handler,other61823.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.tx_private_key,other61823.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.tx_key_id,other61823.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.meta,other61823.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.add_listener,other61823.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.remove_listener,other61823.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.close,other61823.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61822__$1.__extmap,other61823.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k61821){
var self__ = this;
var this__4509__auto____$1 = this;
var G__61831 = k61821;
var G__61831__$1 = (((G__61831 instanceof cljs.core.Keyword))?G__61831.fqn:null);
switch (G__61831__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k61821);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__61820){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__61832 = cljs.core.keyword_identical_QMARK_;
var expr__61833 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__61835 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__61836 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61835,G__61836) : pred__61832.call(null,G__61835,G__61836));
})())){
return (new fluree.db.connection.Connection(G__61820,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61837 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__61838 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61837,G__61838) : pred__61832.call(null,G__61837,G__61838));
})())){
return (new fluree.db.connection.Connection(self__.id,G__61820,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61839 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__61840 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61839,G__61840) : pred__61832.call(null,G__61839,G__61840));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__61820,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61841 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__61842 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61841,G__61842) : pred__61832.call(null,G__61841,G__61842));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__61820,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61843 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__61844 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61843,G__61844) : pred__61832.call(null,G__61843,G__61844));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__61820,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61845 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__61846 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61845,G__61846) : pred__61832.call(null,G__61845,G__61846));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__61820,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61847 = new cljs.core.Keyword(null,"group","group",582596132);
var G__61848 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61847,G__61848) : pred__61832.call(null,G__61847,G__61848));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__61820,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61849 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__61850 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61849,G__61850) : pred__61832.call(null,G__61849,G__61850));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__61820,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61851 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__61852 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61851,G__61852) : pred__61832.call(null,G__61851,G__61852));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__61820,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61853 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__61854 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61853,G__61854) : pred__61832.call(null,G__61853,G__61854));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__61820,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61855 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__61856 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61855,G__61856) : pred__61832.call(null,G__61855,G__61856));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__61820,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61857 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__61858 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61857,G__61858) : pred__61832.call(null,G__61857,G__61858));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__61820,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61859 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__61860 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61859,G__61860) : pred__61832.call(null,G__61859,G__61860));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__61820,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61861 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__61862 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61861,G__61862) : pred__61832.call(null,G__61861,G__61862));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__61820,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61863 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__61864 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61863,G__61864) : pred__61832.call(null,G__61863,G__61864));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__61820,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61865 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__61866 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61865,G__61866) : pred__61832.call(null,G__61865,G__61866));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__61820,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61867 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__61868 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61867,G__61868) : pred__61832.call(null,G__61867,G__61868));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__61820,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61869 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__61870 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61869,G__61870) : pred__61832.call(null,G__61869,G__61870));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__61820,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61871 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__61872 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61871,G__61872) : pred__61832.call(null,G__61871,G__61872));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__61820,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61873 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__61874 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61873,G__61874) : pred__61832.call(null,G__61873,G__61874));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__61820,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61875 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__61876 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61875,G__61876) : pred__61832.call(null,G__61875,G__61876));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__61820,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61877 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__61878 = expr__61833;
return (pred__61832.cljs$core$IFn$_invoke$arity$2 ? pred__61832.cljs$core$IFn$_invoke$arity$2(G__61877,G__61878) : pred__61832.call(null,G__61877,G__61878));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__61820,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__61820),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__61820){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__61820,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__61824){
var extmap__4542__auto__ = (function (){var G__61879 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__61824,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__61824)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__61879);
} else {
return G__61879;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__61824),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__61824),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__61885 = servers_STAR_;
var vec__61886 = G__61885;
var seq__61887 = cljs.core.seq(vec__61886);
var first__61888 = cljs.core.first(seq__61887);
var seq__61887__$1 = cljs.core.next(seq__61887);
var server = first__61888;
var r = seq__61887__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__61885__$1 = G__61885;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__61892 = G__61885__$1;
var seq__61893 = cljs.core.seq(vec__61892);
var first__61894 = cljs.core.first(seq__61893);
var seq__61893__$1 = cljs.core.next(seq__61893);
var server__$1 = first__61894;
var r__$1 = seq__61893__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__61895 = r__$1;
var G__61896 = is_https_QMARK_;
var G__61897 = result_STAR_;
G__61885__$1 = G__61895;
https_QMARK___$1 = G__61896;
result__$1 = G__61897;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__61898 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__61898 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__61898);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_61927){
var state_val_61928 = (state_61927[(1)]);
if((state_val_61928 === (7))){
var inst_61913 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61914 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61915 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61916 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61917 = fluree.db.connection.establish_socket(inst_61913,inst_61914,inst_61915,inst_61916);
var state_61927__$1 = state_61927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61927__$1,(9),inst_61917);
} else {
if((state_val_61928 === (1))){
var state_61927__$1 = state_61927;
var statearr_61929_61948 = state_61927__$1;
(statearr_61929_61948[(2)] = null);

(statearr_61929_61948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61928 === (4))){
var inst_61899 = (state_61927[(2)]);
var state_61927__$1 = state_61927;
var statearr_61930_61949 = state_61927__$1;
(statearr_61930_61949[(2)] = inst_61899);

(statearr_61930_61949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61928 === (6))){
var inst_61910 = (state_61927[(7)]);
var state_61927__$1 = state_61927;
var statearr_61931_61950 = state_61927__$1;
(statearr_61931_61950[(2)] = inst_61910);

(statearr_61931_61950[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61928 === (3))){
var inst_61925 = (state_61927[(2)]);
var state_61927__$1 = state_61927;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61927__$1,inst_61925);
} else {
if((state_val_61928 === (2))){
var inst_61910 = (state_61927[(7)]);
var _ = (function (){var statearr_61933 = state_61927;
(statearr_61933[(4)] = cljs.core.cons((5),(state_61927[(4)])));

return statearr_61933;
})();
var inst_61905 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_61906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61907 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61908 = [inst_61907,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_61909 = (new cljs.core.PersistentVector(null,3,(5),inst_61906,inst_61908,null));
var inst_61910__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61905,inst_61909);
var state_61927__$1 = (function (){var statearr_61934 = state_61927;
(statearr_61934[(7)] = inst_61910__$1);

return statearr_61934;
})();
if(cljs.core.truth_(inst_61910__$1)){
var statearr_61935_61951 = state_61927__$1;
(statearr_61935_61951[(1)] = (6));

} else {
var statearr_61936_61952 = state_61927__$1;
(statearr_61936_61952[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61928 === (9))){
var inst_61919 = (state_61927[(2)]);
var inst_61920 = fluree.db.util.async.throw_err(inst_61919);
var state_61927__$1 = state_61927;
var statearr_61937_61953 = state_61927__$1;
(statearr_61937_61953[(2)] = inst_61920);

(statearr_61937_61953[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61928 === (5))){
var _ = (function (){var statearr_61938 = state_61927;
(statearr_61938[(4)] = cljs.core.rest((state_61927[(4)])));

return statearr_61938;
})();
var state_61927__$1 = state_61927;
var ex61932 = (state_61927__$1[(2)]);
var statearr_61939_61954 = state_61927__$1;
(statearr_61939_61954[(5)] = ex61932);


if((ex61932 instanceof Error)){
var statearr_61940_61955 = state_61927__$1;
(statearr_61940_61955[(1)] = (4));

(statearr_61940_61955[(5)] = null);

} else {
throw ex61932;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61928 === (8))){
var inst_61922 = (state_61927[(2)]);
var _ = (function (){var statearr_61941 = state_61927;
(statearr_61941[(4)] = cljs.core.rest((state_61927[(4)])));

return statearr_61941;
})();
var state_61927__$1 = state_61927;
var statearr_61942_61956 = state_61927__$1;
(statearr_61942_61956[(2)] = inst_61922);

(statearr_61942_61956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2727__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_61943 = [null,null,null,null,null,null,null,null];
(statearr_61943[(0)] = fluree$db$connection$get_socket_$_state_machine__2727__auto__);

(statearr_61943[(1)] = (1));

return statearr_61943;
});
var fluree$db$connection$get_socket_$_state_machine__2727__auto____1 = (function (state_61927){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_61927);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e61944){var ex__2730__auto__ = e61944;
var statearr_61945_61957 = state_61927;
(statearr_61945_61957[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_61927[(4)]))){
var statearr_61946_61958 = state_61927;
(statearr_61946_61958[(1)] = cljs.core.first((state_61927[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61959 = state_61927;
state_61927 = G__61959;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2727__auto__ = function(state_61927){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2727__auto____1.call(this,state_61927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2727__auto____0;
fluree$db$connection$get_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2727__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_61947 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_61947[(6)] = c__2749__auto__);

return statearr_61947;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4253__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e61960){var e = e61960;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_62087){
var state_val_62088 = (state_62087[(1)]);
if((state_val_62088 === (7))){
var inst_62083 = (state_62087[(2)]);
var state_62087__$1 = state_62087;
var statearr_62090_62160 = state_62087__$1;
(statearr_62090_62160[(2)] = inst_62083);

(statearr_62090_62160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (20))){
var _ = (function (){var statearr_62091 = state_62087;
(statearr_62091[(4)] = cljs.core.rest((state_62087[(4)])));

return statearr_62091;
})();
var state_62087__$1 = state_62087;
var ex62089 = (state_62087__$1[(2)]);
var statearr_62092_62161 = state_62087__$1;
(statearr_62092_62161[(5)] = ex62089);


var statearr_62093_62162 = state_62087__$1;
(statearr_62093_62162[(1)] = (10));

(statearr_62093_62162[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (27))){
var inst_62075 = (state_62087[(2)]);
var _ = (function (){var statearr_62094 = state_62087;
(statearr_62094[(4)] = cljs.core.rest((state_62087[(4)])));

return statearr_62094;
})();
var state_62087__$1 = state_62087;
var statearr_62095_62163 = state_62087__$1;
(statearr_62095_62163[(2)] = inst_62075);

(statearr_62095_62163[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (1))){
var inst_61962 = (0);
var state_62087__$1 = (function (){var statearr_62096 = state_62087;
(statearr_62096[(7)] = inst_61962);

return statearr_62096;
})();
var statearr_62097_62164 = state_62087__$1;
(statearr_62097_62164[(2)] = null);

(statearr_62097_62164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (24))){
var inst_62053 = (state_62087[(8)]);
var inst_62053__$1 = (state_62087[(2)]);
var inst_62054 = inst_62053__$1 === true;
var state_62087__$1 = (function (){var statearr_62098 = state_62087;
(statearr_62098[(8)] = inst_62053__$1);

return statearr_62098;
})();
if(cljs.core.truth_(inst_62054)){
var statearr_62099_62165 = state_62087__$1;
(statearr_62099_62165[(1)] = (25));

} else {
var statearr_62100_62166 = state_62087__$1;
(statearr_62100_62166[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (4))){
var inst_61965 = (state_62087[(9)]);
var inst_61965__$1 = (state_62087[(2)]);
var state_62087__$1 = (function (){var statearr_62101 = state_62087;
(statearr_62101[(9)] = inst_61965__$1);

return statearr_62101;
})();
if(cljs.core.truth_(inst_61965__$1)){
var statearr_62102_62167 = state_62087__$1;
(statearr_62102_62167[(1)] = (5));

} else {
var statearr_62103_62168 = state_62087__$1;
(statearr_62103_62168[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (15))){
var inst_61978 = (state_62087[(10)]);
var state_62087__$1 = state_62087;
var statearr_62104_62169 = state_62087__$1;
(statearr_62104_62169[(2)] = inst_61978);

(statearr_62104_62169[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (21))){
var inst_62010 = (state_62087[(11)]);
var inst_62005 = (state_62087[(12)]);
var inst_62002 = (state_62087[(13)]);
var inst_62004 = (state_62087[(14)]);
var inst_62003 = (state_62087[(15)]);
var inst_62009 = (state_62087[(16)]);
var inst_61962 = (state_62087[(7)]);
var inst_62001 = (state_62087[(17)]);
var inst_62006 = (state_62087[(18)]);
var inst_61965 = (state_62087[(9)]);
var inst_62012 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62013 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62009];
var inst_62014 = (new cljs.core.PersistentVector(null,2,(5),inst_62012,inst_62013,null));
var inst_62015 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_62014,inst_62004);
var inst_62042 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_62043 = (function (){var resp_chan = inst_62004;
var timeout = inst_62010;
var c__2749__auto____$1 = inst_62042;
var i = inst_61962;
var data = inst_62003;
var map__62000 = inst_62006;
var _ = inst_62001;
var req_id = inst_62009;
var operation = inst_62002;
var msg = inst_61965;
var vec__61997 = inst_61965;
var opts = inst_62005;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_62040){
var state_val_62041 = (state_62040[(1)]);
if((state_val_62041 === (1))){
var inst_62019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62020 = cljs.core.async.timeout(timeout);
var inst_62021 = [resp_chan,inst_62020];
var inst_62022 = (new cljs.core.PersistentVector(null,2,(5),inst_62019,inst_62021,null));
var state_62040__$1 = state_62040;
return cljs.core.async.ioc_alts_BANG_(state_62040__$1,(2),inst_62022);
} else {
if((state_val_62041 === (2))){
var inst_62025 = (state_62040[(7)]);
var inst_62024 = (state_62040[(2)]);
var inst_62025__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62024,(0),null);
var inst_62026 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62024,(1),null);
var inst_62027 = (function (){var vec__62016 = inst_62024;
var resp = inst_62025__$1;
var c = inst_62026;
return (function (p1__61961_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__61961_SHARP_,req_id);
});
})();
var inst_62028 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62027);
var inst_62029 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62026,resp_chan);
var state_62040__$1 = (function (){var statearr_62105 = state_62040;
(statearr_62105[(7)] = inst_62025__$1);

(statearr_62105[(8)] = inst_62028);

return statearr_62105;
})();
if(inst_62029){
var statearr_62106_62170 = state_62040__$1;
(statearr_62106_62170[(1)] = (3));

} else {
var statearr_62107_62171 = state_62040__$1;
(statearr_62107_62171[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62041 === (3))){
var inst_62025 = (state_62040[(7)]);
var state_62040__$1 = state_62040;
var statearr_62108_62172 = state_62040__$1;
(statearr_62108_62172[(2)] = inst_62025);

(statearr_62108_62172[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62041 === (4))){
var inst_62032 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_62033 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62034 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_62035 = cljs.core.PersistentHashMap.fromArrays(inst_62033,inst_62034);
var inst_62036 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_62032,inst_62035);
var state_62040__$1 = state_62040;
var statearr_62109_62173 = state_62040__$1;
(statearr_62109_62173[(2)] = inst_62036);

(statearr_62109_62173[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62041 === (5))){
var inst_62038 = (state_62040[(2)]);
var state_62040__$1 = state_62040;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62040__$1,inst_62038);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____0 = (function (){
var statearr_62110 = [null,null,null,null,null,null,null,null,null];
(statearr_62110[(0)] = fluree$db$connection$msg_producer_$_state_machine__2727__auto__);

(statearr_62110[(1)] = (1));

return statearr_62110;
});
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____1 = (function (state_62040){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62040);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e62111){var ex__2730__auto__ = e62111;
var statearr_62112_62174 = state_62040;
(statearr_62112_62174[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62040[(4)]))){
var statearr_62113_62175 = state_62040;
(statearr_62113_62175[(1)] = cljs.core.first((state_62040[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62176 = state_62040;
state_62040 = G__62176;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = function(state_62040){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____1.call(this,state_62040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_62114 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_62114[(6)] = c__2749__auto____$1);

return statearr_62114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_62044 = cljs.core.async.impl.dispatch.run(inst_62043);
var state_62087__$1 = (function (){var statearr_62115 = state_62087;
(statearr_62115[(19)] = inst_62044);

(statearr_62115[(20)] = inst_62015);

return statearr_62115;
})();
var statearr_62116_62177 = state_62087__$1;
(statearr_62116_62177[(2)] = inst_62042);

(statearr_62116_62177[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (31))){
var inst_62063 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_62087__$1 = state_62087;
var statearr_62117_62178 = state_62087__$1;
(statearr_62117_62178[(2)] = inst_62063);

(statearr_62117_62178[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (32))){
var state_62087__$1 = state_62087;
var statearr_62118_62179 = state_62087__$1;
(statearr_62118_62179[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (33))){
var inst_62071 = (state_62087[(2)]);
var state_62087__$1 = state_62087;
var statearr_62120_62180 = state_62087__$1;
(statearr_62120_62180[(2)] = inst_62071);

(statearr_62120_62180[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (13))){
var inst_61978 = (state_62087[(10)]);
var inst_61975 = (state_62087[(2)]);
var inst_61976 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61975,(0),null);
var inst_61977 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61975,(1),null);
var inst_61978__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61975,(2),null);
var state_62087__$1 = (function (){var statearr_62121 = state_62087;
(statearr_62121[(21)] = inst_61976);

(statearr_62121[(22)] = inst_61977);

(statearr_62121[(10)] = inst_61978__$1);

return statearr_62121;
})();
if(cljs.core.truth_(inst_61978__$1)){
var statearr_62122_62181 = state_62087__$1;
(statearr_62122_62181[(1)] = (14));

} else {
var statearr_62123_62182 = state_62087__$1;
(statearr_62123_62182[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (22))){
var state_62087__$1 = state_62087;
var statearr_62124_62183 = state_62087__$1;
(statearr_62124_62183[(2)] = null);

(statearr_62124_62183[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (36))){
var inst_62069 = (state_62087[(2)]);
var state_62087__$1 = state_62087;
var statearr_62125_62184 = state_62087__$1;
(statearr_62125_62184[(2)] = inst_62069);

(statearr_62125_62184[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (29))){
var inst_62053 = (state_62087[(8)]);
var inst_62061 = (inst_62053 == null);
var state_62087__$1 = state_62087;
if(cljs.core.truth_(inst_62061)){
var statearr_62126_62185 = state_62087__$1;
(statearr_62126_62185[(1)] = (31));

} else {
var statearr_62127_62186 = state_62087__$1;
(statearr_62127_62186[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (6))){
var state_62087__$1 = state_62087;
var statearr_62128_62187 = state_62087__$1;
(statearr_62128_62187[(2)] = null);

(statearr_62128_62187[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (28))){
var inst_62053 = (state_62087[(8)]);
var inst_62059 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62053,"Error processing message in producer."], 0));
var state_62087__$1 = state_62087;
var statearr_62129_62188 = state_62087__$1;
(statearr_62129_62188[(2)] = inst_62059);

(statearr_62129_62188[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (25))){
var state_62087__$1 = state_62087;
var statearr_62130_62189 = state_62087__$1;
(statearr_62130_62189[(2)] = null);

(statearr_62130_62189[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (34))){
var inst_62053 = (state_62087[(8)]);
var inst_62066 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_62053], 0));
var state_62087__$1 = state_62087;
var statearr_62131_62190 = state_62087__$1;
(statearr_62131_62190[(2)] = inst_62066);

(statearr_62131_62190[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (17))){
var inst_61967 = (state_62087[(23)]);
var inst_61978 = (state_62087[(10)]);
var inst_61985 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_61978,inst_61967);
var state_62087__$1 = state_62087;
var statearr_62132_62191 = state_62087__$1;
(statearr_62132_62191[(2)] = inst_61985);

(statearr_62132_62191[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (3))){
var inst_62085 = (state_62087[(2)]);
var state_62087__$1 = state_62087;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62087__$1,inst_62085);
} else {
if((state_val_62088 === (12))){
var state_62087__$1 = state_62087;
var statearr_62133_62192 = state_62087__$1;
(statearr_62133_62192[(2)] = null);

(statearr_62133_62192[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (2))){
var state_62087__$1 = state_62087;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62087__$1,(4),req_chan);
} else {
if((state_val_62088 === (23))){
var inst_62002 = (state_62087[(13)]);
var inst_62003 = (state_62087[(15)]);
var inst_62009 = (state_62087[(16)]);
var inst_62047 = (state_62087[(2)]);
var inst_62048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62049 = [inst_62002,inst_62009,inst_62003];
var inst_62050 = (new cljs.core.PersistentVector(null,3,(5),inst_62048,inst_62049,null));
var inst_62051 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_62050) : publish_fn.call(null,conn,inst_62050));
var state_62087__$1 = (function (){var statearr_62134 = state_62087;
(statearr_62134[(24)] = inst_62047);

return statearr_62134;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62087__$1,(24),inst_62051);
} else {
if((state_val_62088 === (35))){
var state_62087__$1 = state_62087;
var statearr_62135_62193 = state_62087__$1;
(statearr_62135_62193[(2)] = null);

(statearr_62135_62193[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (19))){
var inst_61991 = (state_62087[(2)]);
var state_62087__$1 = state_62087;
var statearr_62136_62194 = state_62087__$1;
(statearr_62136_62194[(2)] = inst_61991);

(statearr_62136_62194[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (11))){
var inst_61965 = (state_62087[(9)]);
var state_62087__$1 = state_62087;
var statearr_62137_62195 = state_62087__$1;
(statearr_62137_62195[(2)] = inst_61965);

(statearr_62137_62195[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (9))){
var inst_61962 = (state_62087[(7)]);
var inst_62078 = (state_62087[(2)]);
var inst_62079 = (inst_61962 + (1));
var inst_61962__$1 = inst_62079;
var state_62087__$1 = (function (){var statearr_62138 = state_62087;
(statearr_62138[(7)] = inst_61962__$1);

(statearr_62138[(25)] = inst_62078);

return statearr_62138;
})();
var statearr_62139_62196 = state_62087__$1;
(statearr_62139_62196[(2)] = null);

(statearr_62139_62196[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (5))){
var state_62087__$1 = state_62087;
var statearr_62140_62197 = state_62087__$1;
(statearr_62140_62197[(2)] = null);

(statearr_62140_62197[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (14))){
var inst_61978 = (state_62087[(10)]);
var inst_61980 = fluree.db.util.async.channel_QMARK_(inst_61978);
var state_62087__$1 = state_62087;
var statearr_62141_62198 = state_62087__$1;
(statearr_62141_62198[(2)] = inst_61980);

(statearr_62141_62198[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (26))){
var inst_62053 = (state_62087[(8)]);
var inst_62057 = fluree.db.util.core.exception_QMARK_(inst_62053);
var state_62087__$1 = state_62087;
if(inst_62057){
var statearr_62142_62199 = state_62087__$1;
(statearr_62142_62199[(1)] = (28));

} else {
var statearr_62143_62200 = state_62087__$1;
(statearr_62143_62200[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (16))){
var inst_61983 = (state_62087[(2)]);
var state_62087__$1 = state_62087;
if(cljs.core.truth_(inst_61983)){
var statearr_62144_62201 = state_62087__$1;
(statearr_62144_62201[(1)] = (17));

} else {
var statearr_62145_62202 = state_62087__$1;
(statearr_62145_62202[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (30))){
var inst_62073 = (state_62087[(2)]);
var state_62087__$1 = state_62087;
var statearr_62146_62203 = state_62087__$1;
(statearr_62146_62203[(2)] = inst_62073);

(statearr_62146_62203[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (10))){
var inst_61965 = (state_62087[(9)]);
var inst_61967 = (state_62087[(2)]);
var inst_61971 = cljs.core.sequential_QMARK_(inst_61965);
var state_62087__$1 = (function (){var statearr_62147 = state_62087;
(statearr_62147[(23)] = inst_61967);

return statearr_62147;
})();
if(inst_61971){
var statearr_62148_62204 = state_62087__$1;
(statearr_62148_62204[(1)] = (11));

} else {
var statearr_62149_62205 = state_62087__$1;
(statearr_62149_62205[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (18))){
var inst_61967 = (state_62087[(23)]);
var inst_61965 = (state_62087[(9)]);
var inst_61987 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_61965], 0));
var inst_61988 = ["Error processing ledger request, no valid return channel: ",inst_61987].join('');
var inst_61989 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_61967,inst_61988], 0));
var state_62087__$1 = state_62087;
var statearr_62150_62206 = state_62087__$1;
(statearr_62150_62206[(2)] = inst_61989);

(statearr_62150_62206[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62088 === (8))){
var inst_62005 = (state_62087[(12)]);
var inst_62004 = (state_62087[(14)]);
var inst_62006 = (state_62087[(18)]);
var inst_61965 = (state_62087[(9)]);
var _ = (function (){var statearr_62151 = state_62087;
(statearr_62151[(4)] = cljs.core.cons((20),(state_62087[(4)])));

return statearr_62151;
})();
var inst_62001 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_61965], 0));
var inst_62002 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61965,(0),null);
var inst_62003 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61965,(1),null);
var inst_62004__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61965,(2),null);
var inst_62005__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61965,(3),null);
var inst_62006__$1 = cljs.core.__destructure_map(inst_62005__$1);
var inst_62007 = fluree.db.util.core.random_uuid();
var inst_62008 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62007);
var inst_62009 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62006__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_62008);
var inst_62010 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62006__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_62087__$1 = (function (){var statearr_62152 = state_62087;
(statearr_62152[(11)] = inst_62010);

(statearr_62152[(12)] = inst_62005__$1);

(statearr_62152[(13)] = inst_62002);

(statearr_62152[(14)] = inst_62004__$1);

(statearr_62152[(15)] = inst_62003);

(statearr_62152[(16)] = inst_62009);

(statearr_62152[(17)] = inst_62001);

(statearr_62152[(18)] = inst_62006__$1);

return statearr_62152;
})();
if(cljs.core.truth_(inst_62004__$1)){
var statearr_62153_62207 = state_62087__$1;
(statearr_62153_62207[(1)] = (21));

} else {
var statearr_62154_62208 = state_62087__$1;
(statearr_62154_62208[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____0 = (function (){
var statearr_62155 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62155[(0)] = fluree$db$connection$msg_producer_$_state_machine__2727__auto__);

(statearr_62155[(1)] = (1));

return statearr_62155;
});
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____1 = (function (state_62087){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62087);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e62156){var ex__2730__auto__ = e62156;
var statearr_62157_62209 = state_62087;
(statearr_62157_62209[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62087[(4)]))){
var statearr_62158_62210 = state_62087;
(statearr_62158_62210[(1)] = cljs.core.first((state_62087[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62211 = state_62087;
state_62087 = G__62211;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = function(state_62087){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____1.call(this,state_62087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_62159 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_62159[(6)] = c__2749__auto__);

return statearr_62159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__62212 = conn;
var map__62212__$1 = cljs.core.__destructure_map(map__62212);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62212__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_62297){
var state_val_62298 = (state_62297[(1)]);
if((state_val_62298 === (7))){
var inst_62293 = (state_62297[(2)]);
var state_62297__$1 = state_62297;
var statearr_62299_62350 = state_62297__$1;
(statearr_62299_62350[(2)] = inst_62293);

(statearr_62299_62350[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (20))){
var inst_62231 = (state_62297[(7)]);
var inst_62245 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_62246 = [inst_62231];
var inst_62247 = cljs.core.PersistentHashMap.fromArrays(inst_62245,inst_62246);
var inst_62248 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_62247], 0));
var state_62297__$1 = state_62297;
var statearr_62300_62351 = state_62297__$1;
(statearr_62300_62351[(2)] = inst_62248);

(statearr_62300_62351[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (27))){
var state_62297__$1 = state_62297;
var statearr_62301_62352 = state_62297__$1;
(statearr_62301_62352[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (1))){
var inst_62213 = (0);
var state_62297__$1 = (function (){var statearr_62303 = state_62297;
(statearr_62303[(8)] = inst_62213);

return statearr_62303;
})();
var statearr_62304_62353 = state_62297__$1;
(statearr_62304_62353[(2)] = null);

(statearr_62304_62353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (24))){
var inst_62224 = (state_62297[(9)]);
var inst_62273 = fluree.db.util.core.exception_QMARK_(inst_62224);
var state_62297__$1 = state_62297;
if(inst_62273){
var statearr_62305_62354 = state_62297__$1;
(statearr_62305_62354[(1)] = (26));

} else {
var statearr_62306_62355 = state_62297__$1;
(statearr_62306_62355[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (4))){
var inst_62218 = (state_62297[(10)]);
var inst_62223 = (state_62297[(2)]);
var inst_62224 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62223,(0),null);
var inst_62225 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62223,(1),null);
var inst_62226 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62225,inst_62218);
var state_62297__$1 = (function (){var statearr_62307 = state_62297;
(statearr_62307[(9)] = inst_62224);

return statearr_62307;
})();
if(inst_62226){
var statearr_62308_62356 = state_62297__$1;
(statearr_62308_62356[(1)] = (5));

} else {
var statearr_62309_62357 = state_62297__$1;
(statearr_62309_62357[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (15))){
var inst_62231 = (state_62297[(7)]);
var inst_62240 = typeof inst_62231 === 'string';
var state_62297__$1 = state_62297;
if(cljs.core.truth_(inst_62240)){
var statearr_62310_62358 = state_62297__$1;
(statearr_62310_62358[(1)] = (17));

} else {
var statearr_62311_62359 = state_62297__$1;
(statearr_62311_62359[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (21))){
var state_62297__$1 = state_62297;
var statearr_62312_62360 = state_62297__$1;
(statearr_62312_62360[(2)] = null);

(statearr_62312_62360[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (31))){
var inst_62287 = (state_62297[(2)]);
var state_62297__$1 = state_62297;
var statearr_62313_62361 = state_62297__$1;
(statearr_62313_62361[(2)] = inst_62287);

(statearr_62313_62361[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (13))){
var inst_62257 = (state_62297[(2)]);
var inst_62258 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62259 = fluree.db.connection.close_websocket(inst_62258);
var inst_62260 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62261 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_62260);
var state_62297__$1 = (function (){var statearr_62314 = state_62297;
(statearr_62314[(11)] = inst_62259);

(statearr_62314[(12)] = inst_62257);

return statearr_62314;
})();
var statearr_62315_62362 = state_62297__$1;
(statearr_62315_62362[(2)] = inst_62261);

(statearr_62315_62362[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (22))){
var inst_62251 = (state_62297[(2)]);
var state_62297__$1 = state_62297;
var statearr_62316_62363 = state_62297__$1;
(statearr_62316_62363[(2)] = inst_62251);

(statearr_62316_62363[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (29))){
var inst_62224 = (state_62297[(9)]);
var inst_62279 = fluree.db.util.json.parse(inst_62224);
var inst_62280 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62279], 0));
var inst_62281 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Received message:",inst_62280], 0));
var inst_62282 = fluree.db.util.json.parse(inst_62224);
var inst_62283 = fluree.db.conn_events.process_events(conn,inst_62282);
var inst_62213 = (0);
var state_62297__$1 = (function (){var statearr_62317 = state_62297;
(statearr_62317[(13)] = inst_62281);

(statearr_62317[(14)] = inst_62283);

(statearr_62317[(8)] = inst_62213);

return statearr_62317;
})();
var statearr_62318_62364 = state_62297__$1;
(statearr_62318_62364[(2)] = null);

(statearr_62318_62364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (6))){
var inst_62224 = (state_62297[(9)]);
var inst_62269 = (inst_62224 == null);
var state_62297__$1 = state_62297;
if(cljs.core.truth_(inst_62269)){
var statearr_62319_62365 = state_62297__$1;
(statearr_62319_62365[(1)] = (23));

} else {
var statearr_62320_62366 = state_62297__$1;
(statearr_62320_62366[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (28))){
var inst_62289 = (state_62297[(2)]);
var state_62297__$1 = state_62297;
var statearr_62321_62367 = state_62297__$1;
(statearr_62321_62367[(2)] = inst_62289);

(statearr_62321_62367[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (25))){
var inst_62291 = (state_62297[(2)]);
var state_62297__$1 = state_62297;
var statearr_62322_62368 = state_62297__$1;
(statearr_62322_62368[(2)] = inst_62291);

(statearr_62322_62368[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (17))){
var inst_62231 = (state_62297[(7)]);
var inst_62242 = cljs.core.eval(inst_62231);
var state_62297__$1 = state_62297;
var statearr_62323_62369 = state_62297__$1;
(statearr_62323_62369[(2)] = inst_62242);

(statearr_62323_62369[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (3))){
var inst_62295 = (state_62297[(2)]);
var state_62297__$1 = state_62297;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62297__$1,inst_62295);
} else {
if((state_val_62298 === (12))){
var inst_62231 = (state_62297[(7)]);
var inst_62236 = cljs.core.fn_QMARK_(inst_62231);
var state_62297__$1 = state_62297;
if(inst_62236){
var statearr_62324_62370 = state_62297__$1;
(statearr_62324_62370[(1)] = (14));

} else {
var statearr_62325_62371 = state_62297__$1;
(statearr_62325_62371[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (2))){
var inst_62218 = (state_62297[(10)]);
var inst_62218__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_62219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62220 = [sub_chan,inst_62218__$1];
var inst_62221 = (new cljs.core.PersistentVector(null,2,(5),inst_62219,inst_62220,null));
var state_62297__$1 = (function (){var statearr_62326 = state_62297;
(statearr_62326[(10)] = inst_62218__$1);

return statearr_62326;
})();
return cljs.core.async.ioc_alts_BANG_(state_62297__$1,(4),inst_62221);
} else {
if((state_val_62298 === (23))){
var inst_62271 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_62297__$1 = state_62297;
var statearr_62327_62372 = state_62297__$1;
(statearr_62327_62372[(2)] = inst_62271);

(statearr_62327_62372[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (19))){
var inst_62253 = (state_62297[(2)]);
var state_62297__$1 = state_62297;
var statearr_62328_62373 = state_62297__$1;
(statearr_62328_62373[(2)] = inst_62253);

(statearr_62328_62373[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (11))){
var inst_62234 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_62297__$1 = state_62297;
var statearr_62329_62374 = state_62297__$1;
(statearr_62329_62374[(2)] = inst_62234);

(statearr_62329_62374[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (9))){
var inst_62213 = (state_62297[(8)]);
var inst_62263 = fluree.db.connection.ping_transactor(conn);
var inst_62264 = (inst_62213 + (1));
var inst_62213__$1 = inst_62264;
var state_62297__$1 = (function (){var statearr_62330 = state_62297;
(statearr_62330[(15)] = inst_62263);

(statearr_62330[(8)] = inst_62213__$1);

return statearr_62330;
})();
var statearr_62331_62375 = state_62297__$1;
(statearr_62331_62375[(2)] = null);

(statearr_62331_62375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (5))){
var inst_62213 = (state_62297[(8)]);
var inst_62228 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_62213);
var state_62297__$1 = state_62297;
if(inst_62228){
var statearr_62332_62376 = state_62297__$1;
(statearr_62332_62376[(1)] = (8));

} else {
var statearr_62333_62377 = state_62297__$1;
(statearr_62333_62377[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (14))){
var inst_62231 = (state_62297[(7)]);
var inst_62238 = (inst_62231.cljs$core$IFn$_invoke$arity$0 ? inst_62231.cljs$core$IFn$_invoke$arity$0() : inst_62231.call(null));
var state_62297__$1 = state_62297;
var statearr_62334_62378 = state_62297__$1;
(statearr_62334_62378[(2)] = inst_62238);

(statearr_62334_62378[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (26))){
var inst_62224 = (state_62297[(9)]);
var inst_62275 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62224], 0));
var inst_62213 = (0);
var state_62297__$1 = (function (){var statearr_62335 = state_62297;
(statearr_62335[(16)] = inst_62275);

(statearr_62335[(8)] = inst_62213);

return statearr_62335;
})();
var statearr_62336_62379 = state_62297__$1;
(statearr_62336_62379[(2)] = null);

(statearr_62336_62379[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (16))){
var inst_62255 = (state_62297[(2)]);
var state_62297__$1 = state_62297;
var statearr_62337_62380 = state_62297__$1;
(statearr_62337_62380[(2)] = inst_62255);

(statearr_62337_62380[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (30))){
var state_62297__$1 = state_62297;
var statearr_62338_62381 = state_62297__$1;
(statearr_62338_62381[(2)] = null);

(statearr_62338_62381[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (10))){
var inst_62267 = (state_62297[(2)]);
var state_62297__$1 = state_62297;
var statearr_62339_62382 = state_62297__$1;
(statearr_62339_62382[(2)] = inst_62267);

(statearr_62339_62382[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (18))){
var state_62297__$1 = state_62297;
var statearr_62340_62383 = state_62297__$1;
(statearr_62340_62383[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62298 === (8))){
var inst_62231 = (state_62297[(7)]);
var inst_62230 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_62231__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62232 = (inst_62231__$1 == null);
var state_62297__$1 = (function (){var statearr_62342 = state_62297;
(statearr_62342[(17)] = inst_62230);

(statearr_62342[(7)] = inst_62231__$1);

return statearr_62342;
})();
if(cljs.core.truth_(inst_62232)){
var statearr_62343_62384 = state_62297__$1;
(statearr_62343_62384[(1)] = (11));

} else {
var statearr_62344_62385 = state_62297__$1;
(statearr_62344_62385[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0 = (function (){
var statearr_62345 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62345[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2727__auto__);

(statearr_62345[(1)] = (1));

return statearr_62345;
});
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1 = (function (state_62297){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62297);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e62346){var ex__2730__auto__ = e62346;
var statearr_62347_62386 = state_62297;
(statearr_62347_62386[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62297[(4)]))){
var statearr_62348_62387 = state_62297;
(statearr_62348_62387[(1)] = cljs.core.first((state_62297[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62388 = state_62297;
state_62297 = G__62388;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__ = function(state_62297){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1.call(this,state_62297);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_62349 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_62349[(6)] = c__2749__auto__);

return statearr_62349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__62390 = arguments.length;
switch (G__62390) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__62391 = opts;
var map__62391__$1 = cljs.core.__destructure_map(map__62391);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62391__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62391__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_62443){
var state_val_62444 = (state_62443[(1)]);
if((state_val_62444 === (7))){
var inst_62401 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_62402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62403 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_62404 = (new cljs.core.PersistentVector(null,2,(5),inst_62402,inst_62403,null));
var inst_62405 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62401,inst_62404);
var state_62443__$1 = state_62443;
var statearr_62445_62476 = state_62443__$1;
(statearr_62445_62476[(2)] = inst_62405);

(statearr_62445_62476[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62444 === (1))){
var state_62443__$1 = state_62443;
var statearr_62446_62477 = state_62443__$1;
(statearr_62446_62477[(2)] = null);

(statearr_62446_62477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62444 === (4))){
var inst_62392 = (state_62443[(2)]);
var state_62443__$1 = state_62443;
var statearr_62447_62478 = state_62443__$1;
(statearr_62447_62478[(2)] = inst_62392);

(statearr_62447_62478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62444 === (15))){
var inst_62412 = (state_62443[(7)]);
var inst_62431 = (state_62443[(2)]);
var inst_62432 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_62433 = [(5000),inst_62431,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_62434 = cljs.core.PersistentHashMap.fromArrays(inst_62432,inst_62433);
var inst_62435 = fluree.db.util.xhttp.get(inst_62412,inst_62434);
var state_62443__$1 = state_62443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62443__$1,(16),inst_62435);
} else {
if((state_val_62444 === (13))){
var inst_62422 = (state_62443[(8)]);
var inst_62412 = (state_62443[(7)]);
var inst_62424 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_62425 = [inst_62422];
var inst_62426 = cljs.core.PersistentHashMap.fromArrays(inst_62424,inst_62425);
var inst_62427 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_62412,inst_62426,private$);
var inst_62428 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_62427);
var state_62443__$1 = state_62443;
var statearr_62448_62479 = state_62443__$1;
(statearr_62448_62479[(2)] = inst_62428);

(statearr_62448_62479[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62444 === (6))){
var inst_62398 = (state_62443[(9)]);
var state_62443__$1 = state_62443;
var statearr_62449_62480 = state_62443__$1;
(statearr_62449_62480[(2)] = inst_62398);

(statearr_62449_62480[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62444 === (3))){
var inst_62441 = (state_62443[(2)]);
var state_62443__$1 = state_62443;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62443__$1,inst_62441);
} else {
if((state_val_62444 === (12))){
var inst_62422 = (state_62443[(2)]);
var state_62443__$1 = (function (){var statearr_62450 = state_62443;
(statearr_62450[(8)] = inst_62422);

return statearr_62450;
})();
if(cljs.core.truth_(private$)){
var statearr_62451_62481 = state_62443__$1;
(statearr_62451_62481[(1)] = (13));

} else {
var statearr_62452_62482 = state_62443__$1;
(statearr_62452_62482[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62444 === (2))){
var inst_62398 = (state_62443[(9)]);
var _ = (function (){var statearr_62453 = state_62443;
(statearr_62453[(4)] = cljs.core.cons((5),(state_62443[(4)])));

return statearr_62453;
})();
var inst_62398__$1 = jwt;
var state_62443__$1 = (function (){var statearr_62454 = state_62443;
(statearr_62454[(9)] = inst_62398__$1);

return statearr_62454;
})();
if(cljs.core.truth_(inst_62398__$1)){
var statearr_62455_62483 = state_62443__$1;
(statearr_62455_62483[(1)] = (6));

} else {
var statearr_62456_62484 = state_62443__$1;
(statearr_62456_62484[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62444 === (11))){
var inst_62416 = (state_62443[(10)]);
var state_62443__$1 = state_62443;
var statearr_62458_62485 = state_62443__$1;
(statearr_62458_62485[(2)] = inst_62416);

(statearr_62458_62485[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62444 === (9))){
var inst_62408 = (state_62443[(11)]);
var inst_62407 = (state_62443[(12)]);
var inst_62411 = (state_62443[(2)]);
var inst_62412 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62411),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62408)].join('');
var inst_62414 = ["Accept"];
var inst_62415 = ["application/json"];
var inst_62416 = cljs.core.PersistentHashMap.fromArrays(inst_62414,inst_62415);
var state_62443__$1 = (function (){var statearr_62459 = state_62443;
(statearr_62459[(7)] = inst_62412);

(statearr_62459[(10)] = inst_62416);

return statearr_62459;
})();
if(cljs.core.truth_(inst_62407)){
var statearr_62460_62486 = state_62443__$1;
(statearr_62460_62486[(1)] = (10));

} else {
var statearr_62461_62487 = state_62443__$1;
(statearr_62461_62487[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62444 === (5))){
var _ = (function (){var statearr_62462 = state_62443;
(statearr_62462[(4)] = cljs.core.rest((state_62443[(4)])));

return statearr_62462;
})();
var state_62443__$1 = state_62443;
var ex62457 = (state_62443__$1[(2)]);
var statearr_62463_62488 = state_62443__$1;
(statearr_62463_62488[(5)] = ex62457);


if((ex62457 instanceof Error)){
var statearr_62464_62489 = state_62443__$1;
(statearr_62464_62489[(1)] = (4));

(statearr_62464_62489[(5)] = null);

} else {
throw ex62457;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62444 === (14))){
var inst_62422 = (state_62443[(8)]);
var state_62443__$1 = state_62443;
var statearr_62465_62490 = state_62443__$1;
(statearr_62465_62490[(2)] = inst_62422);

(statearr_62465_62490[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62444 === (16))){
var inst_62437 = (state_62443[(2)]);
var inst_62438 = fluree.db.util.async.throw_err(inst_62437);
var _ = (function (){var statearr_62466 = state_62443;
(statearr_62466[(4)] = cljs.core.rest((state_62443[(4)])));

return statearr_62466;
})();
var state_62443__$1 = state_62443;
var statearr_62467_62491 = state_62443__$1;
(statearr_62467_62491[(2)] = inst_62438);

(statearr_62467_62491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62444 === (10))){
var inst_62407 = (state_62443[(12)]);
var inst_62416 = (state_62443[(10)]);
var inst_62418 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62407)].join('');
var inst_62419 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_62416,"Authorization",inst_62418);
var state_62443__$1 = state_62443;
var statearr_62468_62492 = state_62443__$1;
(statearr_62468_62492[(2)] = inst_62419);

(statearr_62468_62492[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62444 === (8))){
var inst_62407 = (state_62443[(2)]);
var inst_62408 = clojure.string.replace(k,"_","/");
var inst_62409 = fluree.db.connection.get_server(conn_id,servers);
var state_62443__$1 = (function (){var statearr_62469 = state_62443;
(statearr_62469[(11)] = inst_62408);

(statearr_62469[(12)] = inst_62407);

return statearr_62469;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62443__$1,(9),inst_62409);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2727__auto__ = null;
var fluree$db$connection$state_machine__2727__auto____0 = (function (){
var statearr_62470 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62470[(0)] = fluree$db$connection$state_machine__2727__auto__);

(statearr_62470[(1)] = (1));

return statearr_62470;
});
var fluree$db$connection$state_machine__2727__auto____1 = (function (state_62443){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62443);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e62471){var ex__2730__auto__ = e62471;
var statearr_62472_62493 = state_62443;
(statearr_62472_62493[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62443[(4)]))){
var statearr_62473_62494 = state_62443;
(statearr_62473_62494[(1)] = cljs.core.first((state_62443[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62495 = state_62443;
state_62443 = G__62495;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2727__auto__ = function(state_62443){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2727__auto____1.call(this,state_62443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2727__auto____0;
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2727__auto____1;
return fluree$db$connection$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_62474 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_62474[(6)] = c__2749__auto__);

return statearr_62474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__62496_SHARP_){
if(cljs.core.truth_(p1__62496_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__62497_SHARP_){
var or__4253__auto__ = p1__62497_SHARP_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return token;
}
}));

return true;
}catch (e62498){var e = e62498;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__62499 = opts;
var map__62499__$1 = cljs.core.__destructure_map(map__62499);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62499__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62499__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62499__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62499__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62499__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62499__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62499__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62499__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62499__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62499__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62499__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62499__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62499__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62499__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62499__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62499__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62499__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62499__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62499__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62499__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62499__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62499__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62499__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62499__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4253__auto__ = object_cache;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356)], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4253__auto__ = storage_read;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4253__auto__ = storage_exists;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = storage_read;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4251__auto__ = storage_write;
if(cljs.core.truth_(and__4251__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__62500_62501 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__62500_62501.cljs$core$IFn$_invoke$arity$0 ? fexpr__62500_62501.cljs$core$IFn$_invoke$arity$0() : fexpr__62500_62501.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4870__auto__ = [];
var len__4864__auto___62542 = arguments.length;
var i__4865__auto___62543 = (0);
while(true){
if((i__4865__auto___62543 < len__4864__auto___62542)){
args__4870__auto__.push((arguments[i__4865__auto___62543]));

var G__62544 = (i__4865__auto___62543 + (1));
i__4865__auto___62543 = G__62544;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__62504){
var vec__62505 = p__62504;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62505,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2749__auto___62545 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_62525){
var state_val_62526 = (state_62525[(1)]);
if((state_val_62526 === (1))){
var inst_62508 = fluree.db.connection.get_socket(conn);
var state_62525__$1 = state_62525;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62525__$1,(2),inst_62508);
} else {
if((state_val_62526 === (2))){
var inst_62511 = (state_62525[(7)]);
var inst_62510 = (state_62525[(8)]);
var inst_62510__$1 = (state_62525[(2)]);
var inst_62511__$1 = (inst_62510__$1 == null);
var state_62525__$1 = (function (){var statearr_62527 = state_62525;
(statearr_62527[(7)] = inst_62511__$1);

(statearr_62527[(8)] = inst_62510__$1);

return statearr_62527;
})();
if(cljs.core.truth_(inst_62511__$1)){
var statearr_62528_62546 = state_62525__$1;
(statearr_62528_62546[(1)] = (3));

} else {
var statearr_62529_62547 = state_62525__$1;
(statearr_62529_62547[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62526 === (3))){
var inst_62511 = (state_62525[(7)]);
var state_62525__$1 = state_62525;
var statearr_62530_62548 = state_62525__$1;
(statearr_62530_62548[(2)] = inst_62511);

(statearr_62530_62548[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62526 === (4))){
var inst_62510 = (state_62525[(8)]);
var inst_62514 = fluree.db.util.core.exception_QMARK_(inst_62510);
var state_62525__$1 = state_62525;
var statearr_62531_62549 = state_62525__$1;
(statearr_62531_62549[(2)] = inst_62514);

(statearr_62531_62549[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62526 === (5))){
var inst_62516 = (state_62525[(2)]);
var state_62525__$1 = state_62525;
if(cljs.core.truth_(inst_62516)){
var statearr_62532_62550 = state_62525__$1;
(statearr_62532_62550[(1)] = (6));

} else {
var statearr_62533_62551 = state_62525__$1;
(statearr_62533_62551[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62526 === (6))){
var inst_62510 = (state_62525[(8)]);
var inst_62518 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62510,"Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_62519 = cljs.core.async.close_BANG_(conn);
var state_62525__$1 = (function (){var statearr_62534 = state_62525;
(statearr_62534[(9)] = inst_62518);

return statearr_62534;
})();
var statearr_62535_62552 = state_62525__$1;
(statearr_62535_62552[(2)] = inst_62519);

(statearr_62535_62552[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62526 === (7))){
var inst_62521 = fluree.db.connection.msg_consumer(conn);
var state_62525__$1 = state_62525;
var statearr_62536_62553 = state_62525__$1;
(statearr_62536_62553[(2)] = inst_62521);

(statearr_62536_62553[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62526 === (8))){
var inst_62523 = (state_62525[(2)]);
var state_62525__$1 = state_62525;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62525__$1,inst_62523);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2727__auto__ = null;
var fluree$db$connection$state_machine__2727__auto____0 = (function (){
var statearr_62537 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62537[(0)] = fluree$db$connection$state_machine__2727__auto__);

(statearr_62537[(1)] = (1));

return statearr_62537;
});
var fluree$db$connection$state_machine__2727__auto____1 = (function (state_62525){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62525);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e62538){var ex__2730__auto__ = e62538;
var statearr_62539_62554 = state_62525;
(statearr_62539_62554[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62525[(4)]))){
var statearr_62540_62555 = state_62525;
(statearr_62540_62555[(1)] = cljs.core.first((state_62525[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62556 = state_62525;
state_62525 = G__62556;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2727__auto__ = function(state_62525){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2727__auto____1.call(this,state_62525);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2727__auto____0;
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2727__auto____1;
return fluree$db$connection$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_62541 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_62541[(6)] = c__2749__auto___62545);

return statearr_62541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq62502){
var G__62503 = cljs.core.first(seq62502);
var seq62502__$1 = cljs.core.next(seq62502);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__62503,seq62502__$1);
}));

