// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__22166 = arguments.length;
switch (G__22166) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__22167 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__22167) : f.call(null,G__22167));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__22168 = cljs.core._deref(vol);
var G__22169 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__22168,G__22169) : f.call(null,G__22168,G__22169));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__22170 = cljs.core._deref(vol);
var G__22171 = arg1;
var G__22172 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__22170,G__22171,G__22172) : f.call(null,G__22170,G__22171,G__22172));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__22173 = cljs.core._deref(vol);
var G__22174 = arg1;
var G__22175 = arg2;
var G__22176 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__22173,G__22174,G__22175,G__22176) : f.call(null,G__22173,G__22174,G__22175,G__22176));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__22179 = arguments.length;
switch (G__22179) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22181 = null;
var G__22181__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22181__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22181__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__22181 = function(result,flake){
switch(arguments.length){
case 0:
return G__22181__0.call(this);
case 1:
return G__22181__1.call(this,result);
case 2:
return G__22181__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22181.cljs$core$IFn$_invoke$arity$0 = G__22181__0;
G__22181.cljs$core$IFn$_invoke$arity$1 = G__22181__1;
G__22181.cljs$core$IFn$_invoke$arity$2 = G__22181__2;
return G__22181;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__22182 = null;
var G__22182__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22182__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22182__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,cljs.core.count(flakes));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__22182 = function(result,flakes){
switch(arguments.length){
case 0:
return G__22182__0.call(this);
case 1:
return G__22182__1.call(this,result);
case 2:
return G__22182__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22182.cljs$core$IFn$_invoke$arity$0 = G__22182__0;
G__22182.cljs$core$IFn$_invoke$arity$1 = G__22182__1;
G__22182.cljs$core$IFn$_invoke$arity$2 = G__22182__2;
return G__22182;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4253__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__22184 = res;
var G__22184__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__22183_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__22183_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__22184):G__22184);
var G__22184__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__22184__$1):G__22184__$1);
var G__22184__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__22184__$2):G__22184__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__22184__$3);
} else {
return G__22184__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__22188 = arguments.length;
switch (G__22188) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22627){
var state_val_22628 = (state_22627[(1)]);
if((state_val_22628 === (121))){
var inst_22550 = (state_22627[(2)]);
var inst_22551 = fluree.db.util.async.throw_err(inst_22550);
var inst_22552 = cljs.core.seq(inst_22551);
var state_22627__$1 = state_22627;
if(inst_22552){
var statearr_22629_22843 = state_22627__$1;
(statearr_22629_22843[(1)] = (122));

} else {
var statearr_22630_22844 = state_22627__$1;
(statearr_22630_22844[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (65))){
var inst_22343 = (state_22627[(7)]);
var inst_22342 = (state_22627[(2)]);
var inst_22343__$1 = fluree.db.util.async.throw_err(inst_22342);
var inst_22344 = cljs.core.seq(inst_22343__$1);
var state_22627__$1 = (function (){var statearr_22631 = state_22627;
(statearr_22631[(7)] = inst_22343__$1);

return statearr_22631;
})();
if(inst_22344){
var statearr_22632_22845 = state_22627__$1;
(statearr_22632_22845[(1)] = (66));

} else {
var statearr_22633_22846 = state_22627__$1;
(statearr_22633_22846[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (70))){
var inst_22343 = (state_22627[(7)]);
var inst_22354 = cljs.core.count(inst_22343);
var inst_22355 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_22354);
var state_22627__$1 = state_22627;
var statearr_22634_22847 = state_22627__$1;
(statearr_22634_22847[(2)] = inst_22355);

(statearr_22634_22847[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (62))){
var inst_22333 = (state_22627[(8)]);
var inst_22336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22337 = inst_22333.o;
var inst_22338 = [inst_22337];
var inst_22339 = (new cljs.core.PersistentVector(null,1,(5),inst_22336,inst_22338,null));
var inst_22340 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22339);
var state_22627__$1 = state_22627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22627__$1,(65),inst_22340);
} else {
if((state_val_22628 === (74))){
var inst_22327 = (state_22627[(9)]);
var state_22627__$1 = state_22627;
var statearr_22635_22848 = state_22627__$1;
(statearr_22635_22848[(2)] = inst_22327);

(statearr_22635_22848[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (110))){
var inst_22512 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_22513 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_22512);
var inst_22514 = inst_22513 === true;
var state_22627__$1 = state_22627;
if(cljs.core.truth_(inst_22514)){
var statearr_22636_22849 = state_22627__$1;
(statearr_22636_22849[(1)] = (113));

} else {
var statearr_22637_22850 = state_22627__$1;
(statearr_22637_22850[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (130))){
var inst_22622 = (state_22627[(2)]);
var _ = (function (){var statearr_22638 = state_22627;
(statearr_22638[(4)] = cljs.core.rest((state_22627[(4)])));

return statearr_22638;
})();
var state_22627__$1 = state_22627;
var statearr_22639_22851 = state_22627__$1;
(statearr_22639_22851[(2)] = inst_22622);

(statearr_22639_22851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (128))){
var inst_22597 = (state_22627[(10)]);
var inst_22600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22601 = [acc,inst_22597];
var inst_22602 = (new cljs.core.PersistentVector(null,2,(5),inst_22600,inst_22601,null));
var state_22627__$1 = state_22627;
var statearr_22640_22852 = state_22627__$1;
(statearr_22640_22852[(2)] = inst_22602);

(statearr_22640_22852[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (7))){
var inst_22200 = (state_22627[(11)]);
var state_22627__$1 = state_22627;
var statearr_22641_22853 = state_22627__$1;
(statearr_22641_22853[(2)] = inst_22200);

(statearr_22641_22853[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (59))){
var inst_22591 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22642_22854 = state_22627__$1;
(statearr_22642_22854[(2)] = inst_22591);

(statearr_22642_22854[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (86))){
var inst_22421 = (state_22627[(12)]);
var inst_22421__$1 = (state_22627[(2)]);
var state_22627__$1 = (function (){var statearr_22643 = state_22627;
(statearr_22643[(12)] = inst_22421__$1);

return statearr_22643;
})();
if(cljs.core.truth_(inst_22421__$1)){
var statearr_22644_22855 = state_22627__$1;
(statearr_22644_22855[(1)] = (88));

} else {
var statearr_22645_22856 = state_22627__$1;
(statearr_22645_22856[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (20))){
var inst_22229 = (state_22627[(13)]);
var inst_22241 = (state_22627[(14)]);
var inst_22242 = (state_22627[(15)]);
var inst_22240 = (state_22627[(2)]);
var inst_22241__$1 = cljs.core.__destructure_map(inst_22229);
var inst_22242__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22241__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22243 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22241__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22244 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22241__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22245 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22241__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22246 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22241__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22247 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22241__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22627__$1 = (function (){var statearr_22646 = state_22627;
(statearr_22646[(16)] = inst_22247);

(statearr_22646[(17)] = inst_22245);

(statearr_22646[(18)] = inst_22240);

(statearr_22646[(19)] = inst_22246);

(statearr_22646[(20)] = inst_22244);

(statearr_22646[(21)] = inst_22243);

(statearr_22646[(14)] = inst_22241__$1);

(statearr_22646[(15)] = inst_22242__$1);

return statearr_22646;
})();
if(cljs.core.truth_(inst_22242__$1)){
var statearr_22647_22857 = state_22627__$1;
(statearr_22647_22857[(1)] = (24));

} else {
var statearr_22648_22858 = state_22627__$1;
(statearr_22648_22858[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (72))){
var inst_22352 = (state_22627[(22)]);
var inst_22358 = (state_22627[(2)]);
var inst_22359 = cljs.core.seq(inst_22352);
var state_22627__$1 = (function (){var statearr_22649 = state_22627;
(statearr_22649[(23)] = inst_22358);

return statearr_22649;
})();
if(inst_22359){
var statearr_22650_22859 = state_22627__$1;
(statearr_22650_22859[(1)] = (73));

} else {
var statearr_22651_22860 = state_22627__$1;
(statearr_22651_22860[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (58))){
var inst_22229 = (state_22627[(13)]);
var inst_22374 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22229);
var state_22627__$1 = state_22627;
if(cljs.core.truth_(inst_22374)){
var statearr_22652_22861 = state_22627__$1;
(statearr_22652_22861[(1)] = (76));

} else {
var statearr_22653_22862 = state_22627__$1;
(statearr_22653_22862[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (60))){
var inst_22326 = (state_22627[(24)]);
var inst_22333 = (state_22627[(8)]);
var inst_22332 = cljs.core.seq(inst_22326);
var inst_22333__$1 = cljs.core.first(inst_22332);
var inst_22334 = cljs.core.next(inst_22332);
var state_22627__$1 = (function (){var statearr_22654 = state_22627;
(statearr_22654[(25)] = inst_22334);

(statearr_22654[(8)] = inst_22333__$1);

return statearr_22654;
})();
if(cljs.core.truth_(inst_22333__$1)){
var statearr_22655_22863 = state_22627__$1;
(statearr_22655_22863[(1)] = (62));

} else {
var statearr_22656_22864 = state_22627__$1;
(statearr_22656_22864[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (27))){
var inst_22250 = (state_22627[(26)]);
var inst_22246 = (state_22627[(19)]);
var inst_22250__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22246);
var state_22627__$1 = (function (){var statearr_22657 = state_22627;
(statearr_22657[(26)] = inst_22250__$1);

return statearr_22657;
})();
if(inst_22250__$1){
var statearr_22658_22865 = state_22627__$1;
(statearr_22658_22865[(1)] = (30));

} else {
var statearr_22659_22866 = state_22627__$1;
(statearr_22659_22866[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (1))){
var state_22627__$1 = state_22627;
var statearr_22660_22867 = state_22627__$1;
(statearr_22660_22867[(2)] = null);

(statearr_22660_22867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (69))){
var inst_22348 = (state_22627[(2)]);
var inst_22349 = fluree.db.util.async.throw_err(inst_22348);
var state_22627__$1 = state_22627;
var statearr_22661_22868 = state_22627__$1;
(statearr_22661_22868[(2)] = inst_22349);

(statearr_22661_22868[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (101))){
var inst_22505 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22662_22869 = state_22627__$1;
(statearr_22662_22869[(2)] = inst_22505);

(statearr_22662_22869[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (24))){
var inst_22246 = (state_22627[(19)]);
var state_22627__$1 = state_22627;
if(cljs.core.truth_(inst_22246)){
var statearr_22663_22870 = state_22627__$1;
(statearr_22663_22870[(1)] = (27));

} else {
var statearr_22664_22871 = state_22627__$1;
(statearr_22664_22871[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (102))){
var inst_22477 = (state_22627[(27)]);
var inst_22476 = (state_22627[(2)]);
var inst_22477__$1 = fluree.db.util.async.throw_err(inst_22476);
var inst_22478 = cljs.core.empty_QMARK_(inst_22477__$1);
var state_22627__$1 = (function (){var statearr_22665 = state_22627;
(statearr_22665[(27)] = inst_22477__$1);

return statearr_22665;
})();
if(inst_22478){
var statearr_22666_22872 = state_22627__$1;
(statearr_22666_22872[(1)] = (103));

} else {
var statearr_22667_22873 = state_22627__$1;
(statearr_22667_22873[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (135))){
var state_22627__$1 = state_22627;
var statearr_22668_22874 = state_22627__$1;
(statearr_22668_22874[(2)] = null);

(statearr_22668_22874[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (55))){
var inst_22229 = (state_22627[(13)]);
var inst_22302 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22229);
var state_22627__$1 = state_22627;
var statearr_22669_22875 = state_22627__$1;
(statearr_22669_22875[(2)] = inst_22302);

(statearr_22669_22875[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (85))){
var inst_22396 = (state_22627[(28)]);
var inst_22229 = (state_22627[(13)]);
var inst_22408 = inst_22396.o;
var inst_22409 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22229);
var inst_22410 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_22408,inst_22409);
var state_22627__$1 = state_22627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22627__$1,(87),inst_22410);
} else {
if((state_val_22628 === (39))){
var inst_22245 = (state_22627[(17)]);
var inst_22277 = (state_22627[(29)]);
var inst_22277__$1 = cljs.core.not(inst_22245);
var state_22627__$1 = (function (){var statearr_22670 = state_22627;
(statearr_22670[(29)] = inst_22277__$1);

return statearr_22670;
})();
if(inst_22277__$1){
var statearr_22671_22876 = state_22627__$1;
(statearr_22671_22876[(1)] = (42));

} else {
var statearr_22672_22877 = state_22627__$1;
(statearr_22672_22877[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (88))){
var inst_22421 = (state_22627[(12)]);
var inst_22390 = (state_22627[(30)]);
var inst_22423 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22390,inst_22421);
var state_22627__$1 = state_22627;
var statearr_22673_22878 = state_22627__$1;
(statearr_22673_22878[(2)] = inst_22423);

(statearr_22673_22878[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (46))){
var inst_22244 = (state_22627[(20)]);
var state_22627__$1 = state_22627;
var statearr_22674_22879 = state_22627__$1;
(statearr_22674_22879[(2)] = inst_22244);

(statearr_22674_22879[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (4))){
var inst_22189 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22675_22880 = state_22627__$1;
(statearr_22675_22880[(2)] = inst_22189);

(statearr_22675_22880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (77))){
var inst_22436 = (state_22627[(31)]);
var inst_22436__$1 = componentFollow_QMARK_;
var state_22627__$1 = (function (){var statearr_22676 = state_22627;
(statearr_22676[(31)] = inst_22436__$1);

return statearr_22676;
})();
if(cljs.core.truth_(inst_22436__$1)){
var statearr_22677_22881 = state_22627__$1;
(statearr_22677_22881[(1)] = (91));

} else {
var statearr_22678_22882 = state_22627__$1;
(statearr_22678_22882[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (106))){
var inst_22457 = (state_22627[(32)]);
var inst_22491 = (state_22627[(2)]);
var inst_22492 = fluree.db.util.async.throw_err(inst_22491);
var inst_22493 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22457,inst_22492);
var state_22627__$1 = state_22627;
var statearr_22679_22883 = state_22627__$1;
(statearr_22679_22883[(2)] = inst_22493);

(statearr_22679_22883[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (119))){
var inst_22535 = (state_22627[(33)]);
var inst_22565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22566 = [inst_22535,offset_map];
var inst_22567 = (new cljs.core.PersistentVector(null,2,(5),inst_22565,inst_22566,null));
var state_22627__$1 = state_22627;
var statearr_22680_22884 = state_22627__$1;
(statearr_22680_22884[(2)] = inst_22567);

(statearr_22680_22884[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (95))){
var inst_22243 = (state_22627[(21)]);
var state_22627__$1 = state_22627;
if(cljs.core.truth_(inst_22243)){
var statearr_22681_22885 = state_22627__$1;
(statearr_22681_22885[(1)] = (110));

} else {
var statearr_22682_22886 = state_22627__$1;
(statearr_22682_22886[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (54))){
var inst_22299 = (state_22627[(34)]);
var state_22627__$1 = state_22627;
var statearr_22683_22887 = state_22627__$1;
(statearr_22683_22887[(2)] = inst_22299);

(statearr_22683_22887[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (92))){
var inst_22436 = (state_22627[(31)]);
var state_22627__$1 = state_22627;
var statearr_22684_22888 = state_22627__$1;
(statearr_22684_22888[(2)] = inst_22436);

(statearr_22684_22888[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (104))){
var inst_22477 = (state_22627[(27)]);
var inst_22199 = (state_22627[(35)]);
var inst_22486 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_22487 = [true,inst_22199];
var inst_22488 = cljs.core.PersistentHashMap.fromArrays(inst_22486,inst_22487);
var inst_22489 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22488,inst_22477) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22488,inst_22477));
var state_22627__$1 = state_22627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22627__$1,(106),inst_22489);
} else {
if((state_val_22628 === (15))){
var inst_22199 = (state_22627[(35)]);
var inst_22222 = (state_22627[(36)]);
var inst_22226 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22222,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22199);
var state_22627__$1 = state_22627;
var statearr_22685_22889 = state_22627__$1;
(statearr_22685_22889[(2)] = inst_22226);

(statearr_22685_22889[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (48))){
var inst_22293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22294 = [null,offset_map];
var inst_22295 = (new cljs.core.PersistentVector(null,2,(5),inst_22293,inst_22294,null));
var state_22627__$1 = state_22627;
var statearr_22686_22890 = state_22627__$1;
(statearr_22686_22890[(2)] = inst_22295);

(statearr_22686_22890[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (50))){
var inst_22593 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22687_22891 = state_22627__$1;
(statearr_22687_22891[(2)] = inst_22593);

(statearr_22687_22891[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (116))){
var inst_22534 = (state_22627[(37)]);
var inst_22541 = (state_22627[(38)]);
var inst_22540 = cljs.core.seq(inst_22534);
var inst_22541__$1 = cljs.core.first(inst_22540);
var inst_22542 = cljs.core.next(inst_22540);
var state_22627__$1 = (function (){var statearr_22688 = state_22627;
(statearr_22688[(39)] = inst_22542);

(statearr_22688[(38)] = inst_22541__$1);

return statearr_22688;
})();
if(cljs.core.truth_(inst_22541__$1)){
var statearr_22689_22892 = state_22627__$1;
(statearr_22689_22892[(1)] = (118));

} else {
var statearr_22690_22893 = state_22627__$1;
(statearr_22690_22893[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (75))){
var inst_22334 = (state_22627[(25)]);
var inst_22364 = (state_22627[(2)]);
var inst_22326 = inst_22334;
var inst_22327 = inst_22364;
var state_22627__$1 = (function (){var statearr_22691 = state_22627;
(statearr_22691[(9)] = inst_22327);

(statearr_22691[(24)] = inst_22326);

return statearr_22691;
})();
var statearr_22692_22894 = state_22627__$1;
(statearr_22692_22894[(2)] = null);

(statearr_22692_22894[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (99))){
var inst_22229 = (state_22627[(13)]);
var inst_22463 = (state_22627[(40)]);
var inst_22466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22467 = inst_22463.o;
var inst_22468 = [inst_22467];
var inst_22469 = (new cljs.core.PersistentVector(null,1,(5),inst_22466,inst_22468,null));
var inst_22470 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22471 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22229);
var inst_22472 = [inst_22471];
var inst_22473 = cljs.core.PersistentHashMap.fromArrays(inst_22470,inst_22472);
var inst_22474 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22469,inst_22473);
var state_22627__$1 = state_22627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22627__$1,(102),inst_22474);
} else {
if((state_val_22628 === (21))){
var inst_22233 = (state_22627[(41)]);
var state_22627__$1 = state_22627;
var statearr_22693_22895 = state_22627__$1;
(statearr_22693_22895[(2)] = inst_22233);

(statearr_22693_22895[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (31))){
var inst_22250 = (state_22627[(26)]);
var state_22627__$1 = state_22627;
var statearr_22694_22896 = state_22627__$1;
(statearr_22694_22896[(2)] = inst_22250);

(statearr_22694_22896[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (113))){
var inst_22247 = (state_22627[(16)]);
var inst_22245 = (state_22627[(17)]);
var inst_22214 = (state_22627[(42)]);
var inst_22229 = (state_22627[(13)]);
var inst_22199 = (state_22627[(35)]);
var inst_22240 = (state_22627[(18)]);
var inst_22246 = (state_22627[(19)]);
var inst_22244 = (state_22627[(20)]);
var inst_22243 = (state_22627[(21)]);
var inst_22241 = (state_22627[(14)]);
var inst_22242 = (state_22627[(15)]);
var inst_22516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22517 = (function (){var p = inst_22247;
var pred_spec__$1 = inst_22214;
var orderBy = inst_22245;
var multi_QMARK_ = inst_22242;
var limit = inst_22244;
var offset = inst_22246;
var map__22195 = inst_22241;
var k = inst_22240;
var compact_QMARK_ = inst_22199;
var pred_spec_SINGLEQUOTE_ = inst_22229;
var ref_QMARK_ = inst_22243;
return (function (p1__22185_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[p1__22185_SHARP_.o]);
});
})();
var inst_22518 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_22517,flakes);
var inst_22519 = [inst_22518,offset_map];
var inst_22520 = (new cljs.core.PersistentVector(null,2,(5),inst_22516,inst_22519,null));
var state_22627__$1 = state_22627;
var statearr_22695_22897 = state_22627__$1;
(statearr_22695_22897[(2)] = inst_22520);

(statearr_22695_22897[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (32))){
var inst_22256 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22696_22898 = state_22627__$1;
(statearr_22696_22898[(2)] = inst_22256);

(statearr_22696_22898[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (136))){
var inst_22618 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22697_22899 = state_22627__$1;
(statearr_22697_22899[(2)] = inst_22618);

(statearr_22697_22899[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (40))){
var inst_22242 = (state_22627[(15)]);
var state_22627__$1 = state_22627;
var statearr_22698_22900 = state_22627__$1;
(statearr_22698_22900[(2)] = inst_22242);

(statearr_22698_22900[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (129))){
var inst_22242 = (state_22627[(15)]);
var state_22627__$1 = state_22627;
if(cljs.core.truth_(inst_22242)){
var statearr_22699_22901 = state_22627__$1;
(statearr_22699_22901[(1)] = (131));

} else {
var statearr_22700_22902 = state_22627__$1;
(statearr_22700_22902[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (91))){
var inst_22229 = (state_22627[(13)]);
var inst_22438 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22229);
var state_22627__$1 = state_22627;
var statearr_22701_22903 = state_22627__$1;
(statearr_22701_22903[(2)] = inst_22438);

(statearr_22701_22903[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (117))){
var inst_22571 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22702_22904 = state_22627__$1;
(statearr_22702_22904[(2)] = inst_22571);

(statearr_22702_22904[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (108))){
var state_22627__$1 = state_22627;
var statearr_22703_22905 = state_22627__$1;
(statearr_22703_22905[(2)] = null);

(statearr_22703_22905[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (56))){
var inst_22304 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22704_22906 = state_22627__$1;
(statearr_22704_22906[(2)] = inst_22304);

(statearr_22704_22906[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (33))){
var inst_22247 = (state_22627[(16)]);
var inst_22264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22265 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22247);
var state_22627__$1 = (function (){var statearr_22705 = state_22627;
(statearr_22705[(43)] = inst_22264);

return statearr_22705;
})();
if(cljs.core.truth_(inst_22265)){
var statearr_22706_22907 = state_22627__$1;
(statearr_22706_22907[(1)] = (36));

} else {
var statearr_22707_22908 = state_22627__$1;
(statearr_22707_22908[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (13))){
var inst_22214 = (state_22627[(42)]);
var state_22627__$1 = state_22627;
var statearr_22708_22909 = state_22627__$1;
(statearr_22708_22909[(2)] = inst_22214);

(statearr_22708_22909[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (22))){
var inst_22229 = (state_22627[(13)]);
var inst_22236 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22229);
var state_22627__$1 = state_22627;
var statearr_22709_22910 = state_22627__$1;
(statearr_22709_22910[(2)] = inst_22236);

(statearr_22709_22910[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (90))){
var inst_22397 = (state_22627[(44)]);
var inst_22426 = (state_22627[(2)]);
var inst_22389 = inst_22397;
var inst_22390 = inst_22426;
var state_22627__$1 = (function (){var statearr_22710 = state_22627;
(statearr_22710[(45)] = inst_22389);

(statearr_22710[(30)] = inst_22390);

return statearr_22710;
})();
var statearr_22711_22911 = state_22627__$1;
(statearr_22711_22911[(2)] = null);

(statearr_22711_22911[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (109))){
var inst_22495 = (state_22627[(46)]);
var inst_22464 = (state_22627[(47)]);
var inst_22501 = (state_22627[(2)]);
var inst_22456 = inst_22464;
var inst_22457 = inst_22495;
var state_22627__$1 = (function (){var statearr_22712 = state_22627;
(statearr_22712[(48)] = inst_22456);

(statearr_22712[(32)] = inst_22457);

(statearr_22712[(49)] = inst_22501);

return statearr_22712;
})();
var statearr_22713_22912 = state_22627__$1;
(statearr_22713_22912[(2)] = null);

(statearr_22713_22912[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (36))){
var inst_22247 = (state_22627[(16)]);
var inst_22267 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22247,cljs.core.dec);
var state_22627__$1 = state_22627;
var statearr_22714_22913 = state_22627__$1;
(statearr_22714_22913[(2)] = inst_22267);

(statearr_22714_22913[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (41))){
var inst_22291 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
if(cljs.core.truth_(inst_22291)){
var statearr_22715_22914 = state_22627__$1;
(statearr_22715_22914[(1)] = (48));

} else {
var statearr_22716_22915 = state_22627__$1;
(statearr_22716_22915[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (118))){
var inst_22541 = (state_22627[(38)]);
var inst_22544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22545 = inst_22541.o;
var inst_22546 = [inst_22545];
var inst_22547 = (new cljs.core.PersistentVector(null,1,(5),inst_22544,inst_22546,null));
var inst_22548 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22547);
var state_22627__$1 = state_22627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22627__$1,(121),inst_22548);
} else {
if((state_val_22628 === (89))){
var inst_22390 = (state_22627[(30)]);
var state_22627__$1 = state_22627;
var statearr_22717_22916 = state_22627__$1;
(statearr_22717_22916[(2)] = inst_22390);

(statearr_22717_22916[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (100))){
var inst_22457 = (state_22627[(32)]);
var state_22627__$1 = state_22627;
var statearr_22718_22917 = state_22627__$1;
(statearr_22718_22917[(2)] = inst_22457);

(statearr_22718_22917[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (131))){
var inst_22597 = (state_22627[(10)]);
var inst_22240 = (state_22627[(18)]);
var inst_22596 = (state_22627[(50)]);
var inst_22605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22606 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22240,inst_22596);
var inst_22607 = [inst_22606,inst_22597];
var inst_22608 = (new cljs.core.PersistentVector(null,2,(5),inst_22605,inst_22607,null));
var state_22627__$1 = state_22627;
var statearr_22719_22918 = state_22627__$1;
(statearr_22719_22918[(2)] = inst_22608);

(statearr_22719_22918[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (122))){
var inst_22542 = (state_22627[(39)]);
var inst_22535 = (state_22627[(33)]);
var inst_22541 = (state_22627[(38)]);
var inst_22554 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22555 = inst_22541.o;
var inst_22556 = [inst_22555];
var inst_22557 = cljs.core.PersistentHashMap.fromArrays(inst_22554,inst_22556);
var inst_22558 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22535,inst_22557);
var inst_22534 = inst_22542;
var inst_22535__$1 = inst_22558;
var state_22627__$1 = (function (){var statearr_22720 = state_22627;
(statearr_22720[(37)] = inst_22534);

(statearr_22720[(33)] = inst_22535__$1);

return statearr_22720;
})();
var statearr_22721_22919 = state_22627__$1;
(statearr_22721_22919[(2)] = null);

(statearr_22721_22919[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (43))){
var inst_22277 = (state_22627[(29)]);
var state_22627__$1 = state_22627;
var statearr_22722_22920 = state_22627__$1;
(statearr_22722_22920[(2)] = inst_22277);

(statearr_22722_22920[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (61))){
var inst_22313 = (state_22627[(51)]);
var inst_22370 = (state_22627[(2)]);
var inst_22371 = [inst_22370,offset_map];
var inst_22372 = (new cljs.core.PersistentVector(null,2,(5),inst_22313,inst_22371,null));
var state_22627__$1 = state_22627;
var statearr_22723_22921 = state_22627__$1;
(statearr_22723_22921[(2)] = inst_22372);

(statearr_22723_22921[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (29))){
var inst_22259 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22724_22922 = state_22627__$1;
(statearr_22724_22922[(2)] = inst_22259);

(statearr_22724_22922[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (44))){
var inst_22288 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22725_22923 = state_22627__$1;
(statearr_22725_22923[(2)] = inst_22288);

(statearr_22725_22923[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (93))){
var inst_22441 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
if(cljs.core.truth_(inst_22441)){
var statearr_22726_22924 = state_22627__$1;
(statearr_22726_22924[(1)] = (94));

} else {
var statearr_22727_22925 = state_22627__$1;
(statearr_22727_22925[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (6))){
var inst_22202 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22203 = (inst_22202 == null);
var state_22627__$1 = state_22627;
var statearr_22728_22926 = state_22627__$1;
(statearr_22728_22926[(2)] = inst_22203);

(statearr_22728_22926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (111))){
var state_22627__$1 = state_22627;
var statearr_22729_22927 = state_22627__$1;
(statearr_22729_22927[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (28))){
var inst_22246 = (state_22627[(19)]);
var state_22627__$1 = state_22627;
var statearr_22731_22928 = state_22627__$1;
(statearr_22731_22928[(2)] = inst_22246);

(statearr_22731_22928[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (134))){
var inst_22597 = (state_22627[(10)]);
var inst_22240 = (state_22627[(18)]);
var inst_22596 = (state_22627[(50)]);
var inst_22611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22612 = cljs.core.first(inst_22596);
var inst_22613 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22240,inst_22612);
var inst_22614 = [inst_22613,inst_22597];
var inst_22615 = (new cljs.core.PersistentVector(null,2,(5),inst_22611,inst_22614,null));
var state_22627__$1 = state_22627;
var statearr_22732_22929 = state_22627__$1;
(statearr_22732_22929[(2)] = inst_22615);

(statearr_22732_22929[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (64))){
var inst_22368 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22733_22930 = state_22627__$1;
(statearr_22733_22930[(2)] = inst_22368);

(statearr_22733_22930[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (103))){
var inst_22463 = (state_22627[(40)]);
var inst_22457 = (state_22627[(32)]);
var inst_22480 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22481 = inst_22463.o;
var inst_22482 = [inst_22481];
var inst_22483 = cljs.core.PersistentHashMap.fromArrays(inst_22480,inst_22482);
var inst_22484 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22457,inst_22483);
var state_22627__$1 = state_22627;
var statearr_22734_22931 = state_22627__$1;
(statearr_22734_22931[(2)] = inst_22484);

(statearr_22734_22931[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (51))){
var inst_22229 = (state_22627[(13)]);
var inst_22299 = (state_22627[(34)]);
var inst_22299__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22229);
var state_22627__$1 = (function (){var statearr_22735 = state_22627;
(statearr_22735[(34)] = inst_22299__$1);

return statearr_22735;
})();
if(cljs.core.truth_(inst_22299__$1)){
var statearr_22736_22932 = state_22627__$1;
(statearr_22736_22932[(1)] = (54));

} else {
var statearr_22737_22933 = state_22627__$1;
(statearr_22737_22933[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (25))){
var inst_22242 = (state_22627[(15)]);
var state_22627__$1 = state_22627;
var statearr_22738_22934 = state_22627__$1;
(statearr_22738_22934[(2)] = inst_22242);

(statearr_22738_22934[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (34))){
var inst_22242 = (state_22627[(15)]);
var state_22627__$1 = state_22627;
if(cljs.core.truth_(inst_22242)){
var statearr_22739_22935 = state_22627__$1;
(statearr_22739_22935[(1)] = (39));

} else {
var statearr_22740_22936 = state_22627__$1;
(statearr_22740_22936[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (125))){
var inst_22247 = (state_22627[(16)]);
var inst_22245 = (state_22627[(17)]);
var inst_22214 = (state_22627[(42)]);
var inst_22229 = (state_22627[(13)]);
var inst_22199 = (state_22627[(35)]);
var inst_22240 = (state_22627[(18)]);
var inst_22246 = (state_22627[(19)]);
var inst_22244 = (state_22627[(20)]);
var inst_22243 = (state_22627[(21)]);
var inst_22241 = (state_22627[(14)]);
var inst_22242 = (state_22627[(15)]);
var inst_22576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22577 = (function (){var p = inst_22247;
var pred_spec__$1 = inst_22214;
var orderBy = inst_22245;
var multi_QMARK_ = inst_22242;
var limit = inst_22244;
var offset = inst_22246;
var map__22195 = inst_22241;
var k = inst_22240;
var compact_QMARK_ = inst_22199;
var pred_spec_SINGLEQUOTE_ = inst_22229;
var ref_QMARK_ = inst_22243;
return (function (p1__22186_SHARP_){
return p1__22186_SHARP_.o;
});
})();
var inst_22578 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_22577,flakes);
var inst_22579 = [inst_22578,offset_map];
var inst_22580 = (new cljs.core.PersistentVector(null,2,(5),inst_22576,inst_22579,null));
var state_22627__$1 = state_22627;
var statearr_22741_22937 = state_22627__$1;
(statearr_22741_22937[(2)] = inst_22580);

(statearr_22741_22937[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (17))){
var inst_22230 = (state_22627[(52)]);
var inst_22229 = (state_22627[(13)]);
var inst_22229__$1 = (state_22627[(2)]);
var inst_22230__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22229__$1);
var state_22627__$1 = (function (){var statearr_22742 = state_22627;
(statearr_22742[(52)] = inst_22230__$1);

(statearr_22742[(13)] = inst_22229__$1);

return statearr_22742;
})();
if(cljs.core.truth_(inst_22230__$1)){
var statearr_22743_22938 = state_22627__$1;
(statearr_22743_22938[(1)] = (18));

} else {
var statearr_22744_22939 = state_22627__$1;
(statearr_22744_22939[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (3))){
var inst_22625 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22627__$1,inst_22625);
} else {
if((state_val_22628 === (12))){
var inst_22214 = (state_22627[(42)]);
var inst_22219 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22214,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22627__$1 = state_22627;
var statearr_22745_22940 = state_22627__$1;
(statearr_22745_22940[(2)] = inst_22219);

(statearr_22745_22940[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (2))){
var inst_22200 = (state_22627[(11)]);
var _ = (function (){var statearr_22746 = state_22627;
(statearr_22746[(4)] = cljs.core.cons((5),(state_22627[(4)])));

return statearr_22746;
})();
var inst_22199 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22200__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22627__$1 = (function (){var statearr_22747 = state_22627;
(statearr_22747[(11)] = inst_22200__$1);

(statearr_22747[(35)] = inst_22199);

return statearr_22747;
})();
if(cljs.core.truth_(inst_22200__$1)){
var statearr_22748_22941 = state_22627__$1;
(statearr_22748_22941[(1)] = (6));

} else {
var statearr_22749_22942 = state_22627__$1;
(statearr_22749_22942[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (66))){
var inst_22312 = (state_22627[(53)]);
var inst_22343 = (state_22627[(7)]);
var inst_22346 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22312,inst_22343) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22312,inst_22343));
var state_22627__$1 = state_22627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22627__$1,(69),inst_22346);
} else {
if((state_val_22628 === (107))){
var inst_22477 = (state_22627[(27)]);
var inst_22497 = cljs.core.count(inst_22477);
var inst_22498 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_22497);
var state_22627__$1 = state_22627;
var statearr_22750_22943 = state_22627__$1;
(statearr_22750_22943[(2)] = inst_22498);

(statearr_22750_22943[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (23))){
var inst_22238 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22751_22944 = state_22627__$1;
(statearr_22751_22944[(2)] = inst_22238);

(statearr_22751_22944[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (47))){
var inst_22285 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22752_22945 = state_22627__$1;
(statearr_22752_22945[(2)] = inst_22285);

(statearr_22752_22945[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (35))){
var inst_22596 = (state_22627[(50)]);
var inst_22595 = (state_22627[(2)]);
var inst_22596__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22595,(0),null);
var inst_22597 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22595,(1),null);
var inst_22598 = cljs.core.empty_QMARK_(inst_22596__$1);
var state_22627__$1 = (function (){var statearr_22753 = state_22627;
(statearr_22753[(10)] = inst_22597);

(statearr_22753[(50)] = inst_22596__$1);

return statearr_22753;
})();
if(inst_22598){
var statearr_22754_22946 = state_22627__$1;
(statearr_22754_22946[(1)] = (128));

} else {
var statearr_22755_22947 = state_22627__$1;
(statearr_22755_22947[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (127))){
var inst_22583 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22756_22948 = state_22627__$1;
(statearr_22756_22948[(2)] = inst_22583);

(statearr_22756_22948[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (82))){
var inst_22390 = (state_22627[(30)]);
var state_22627__$1 = state_22627;
var statearr_22757_22949 = state_22627__$1;
(statearr_22757_22949[(2)] = inst_22390);

(statearr_22757_22949[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (76))){
var inst_22376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22384 = flakes;
var inst_22385 = cljs.core.seq(inst_22384);
var inst_22386 = cljs.core.first(inst_22385);
var inst_22387 = cljs.core.next(inst_22385);
var inst_22388 = cljs.core.PersistentVector.EMPTY;
var inst_22389 = inst_22384;
var inst_22390 = inst_22388;
var state_22627__$1 = (function (){var statearr_22758 = state_22627;
(statearr_22758[(45)] = inst_22389);

(statearr_22758[(54)] = inst_22387);

(statearr_22758[(55)] = inst_22376);

(statearr_22758[(56)] = inst_22386);

(statearr_22758[(30)] = inst_22390);

return statearr_22758;
})();
var statearr_22759_22950 = state_22627__$1;
(statearr_22759_22950[(2)] = null);

(statearr_22759_22950[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (97))){
var inst_22456 = (state_22627[(48)]);
var inst_22463 = (state_22627[(40)]);
var inst_22462 = cljs.core.seq(inst_22456);
var inst_22463__$1 = cljs.core.first(inst_22462);
var inst_22464 = cljs.core.next(inst_22462);
var state_22627__$1 = (function (){var statearr_22760 = state_22627;
(statearr_22760[(40)] = inst_22463__$1);

(statearr_22760[(47)] = inst_22464);

return statearr_22760;
})();
if(cljs.core.truth_(inst_22463__$1)){
var statearr_22761_22951 = state_22627__$1;
(statearr_22761_22951[(1)] = (99));

} else {
var statearr_22762_22952 = state_22627__$1;
(statearr_22762_22952[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (19))){
var inst_22229 = (state_22627[(13)]);
var inst_22233 = (state_22627[(41)]);
var inst_22233__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22229);
var state_22627__$1 = (function (){var statearr_22763 = state_22627;
(statearr_22763[(41)] = inst_22233__$1);

return statearr_22763;
})();
if(cljs.core.truth_(inst_22233__$1)){
var statearr_22764_22953 = state_22627__$1;
(statearr_22764_22953[(1)] = (21));

} else {
var statearr_22765_22954 = state_22627__$1;
(statearr_22765_22954[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (57))){
var inst_22229 = (state_22627[(13)]);
var inst_22309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22310 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22311 = (new cljs.core.PersistentVector(null,3,(5),inst_22309,inst_22310,null));
var inst_22312 = cljs.core.select_keys(inst_22229,inst_22311);
var inst_22313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22321 = flakes;
var inst_22322 = cljs.core.seq(inst_22321);
var inst_22323 = cljs.core.first(inst_22322);
var inst_22324 = cljs.core.next(inst_22322);
var inst_22325 = cljs.core.PersistentVector.EMPTY;
var inst_22326 = inst_22321;
var inst_22327 = inst_22325;
var state_22627__$1 = (function (){var statearr_22766 = state_22627;
(statearr_22766[(9)] = inst_22327);

(statearr_22766[(24)] = inst_22326);

(statearr_22766[(57)] = inst_22324);

(statearr_22766[(53)] = inst_22312);

(statearr_22766[(51)] = inst_22313);

(statearr_22766[(58)] = inst_22323);

return statearr_22766;
})();
var statearr_22767_22955 = state_22627__$1;
(statearr_22767_22955[(2)] = null);

(statearr_22767_22955[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (68))){
var inst_22352 = (state_22627[(2)]);
var state_22627__$1 = (function (){var statearr_22768 = state_22627;
(statearr_22768[(22)] = inst_22352);

return statearr_22768;
})();
if(cljs.core.truth_(fuel)){
var statearr_22769_22956 = state_22627__$1;
(statearr_22769_22956[(1)] = (70));

} else {
var statearr_22770_22957 = state_22627__$1;
(statearr_22770_22957[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (11))){
var inst_22214 = (state_22627[(42)]);
var inst_22214__$1 = (state_22627[(2)]);
var inst_22216 = cljs.core.contains_QMARK_(inst_22214__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22217 = (!(inst_22216));
var state_22627__$1 = (function (){var statearr_22771 = state_22627;
(statearr_22771[(42)] = inst_22214__$1);

return statearr_22771;
})();
if(inst_22217){
var statearr_22772_22958 = state_22627__$1;
(statearr_22772_22958[(1)] = (12));

} else {
var statearr_22773_22959 = state_22627__$1;
(statearr_22773_22959[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (115))){
var inst_22573 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22775_22960 = state_22627__$1;
(statearr_22775_22960[(2)] = inst_22573);

(statearr_22775_22960[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (9))){
var inst_22208 = cljs.core.first(flakes);
var inst_22209 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22208);
var inst_22210 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22211 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_22209,inst_22210);
var state_22627__$1 = state_22627;
var statearr_22776_22961 = state_22627__$1;
(statearr_22776_22961[(2)] = inst_22211);

(statearr_22776_22961[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (5))){
var _ = (function (){var statearr_22777 = state_22627;
(statearr_22777[(4)] = cljs.core.rest((state_22627[(4)])));

return statearr_22777;
})();
var state_22627__$1 = state_22627;
var ex22774 = (state_22627__$1[(2)]);
var statearr_22778_22962 = state_22627__$1;
(statearr_22778_22962[(5)] = ex22774);


if((ex22774 instanceof Error)){
var statearr_22779_22963 = state_22627__$1;
(statearr_22779_22963[(1)] = (4));

(statearr_22779_22963[(5)] = null);

} else {
throw ex22774;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (112))){
var inst_22585 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22780_22964 = state_22627__$1;
(statearr_22780_22964[(2)] = inst_22585);

(statearr_22780_22964[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (83))){
var inst_22430 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22781_22965 = state_22627__$1;
(statearr_22781_22965[(2)] = inst_22430);

(statearr_22781_22965[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (14))){
var inst_22214 = (state_22627[(42)]);
var inst_22222 = (state_22627[(2)]);
var inst_22223 = cljs.core.contains_QMARK_(inst_22214,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22224 = (!(inst_22223));
var state_22627__$1 = (function (){var statearr_22782 = state_22627;
(statearr_22782[(36)] = inst_22222);

return statearr_22782;
})();
if(inst_22224){
var statearr_22783_22966 = state_22627__$1;
(statearr_22783_22966[(1)] = (15));

} else {
var statearr_22784_22967 = state_22627__$1;
(statearr_22784_22967[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (45))){
var inst_22240 = (state_22627[(18)]);
var inst_22244 = (state_22627[(20)]);
var inst_22280 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_22240);
var inst_22281 = cljs.core.count(inst_22280);
var inst_22282 = (inst_22281 >= inst_22244);
var state_22627__$1 = state_22627;
var statearr_22785_22968 = state_22627__$1;
(statearr_22785_22968[(2)] = inst_22282);

(statearr_22785_22968[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (53))){
var inst_22307 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
if(cljs.core.truth_(inst_22307)){
var statearr_22786_22969 = state_22627__$1;
(statearr_22786_22969[(1)] = (57));

} else {
var statearr_22787_22970 = state_22627__$1;
(statearr_22787_22970[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (78))){
var inst_22589 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22788_22971 = state_22627__$1;
(statearr_22788_22971[(2)] = inst_22589);

(statearr_22788_22971[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (132))){
var state_22627__$1 = state_22627;
var statearr_22790_22972 = state_22627__$1;
(statearr_22790_22972[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (26))){
var inst_22262 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
if(cljs.core.truth_(inst_22262)){
var statearr_22792_22973 = state_22627__$1;
(statearr_22792_22973[(1)] = (33));

} else {
var statearr_22793_22974 = state_22627__$1;
(statearr_22793_22974[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (123))){
var inst_22542 = (state_22627[(39)]);
var inst_22535 = (state_22627[(33)]);
var tmp22789 = inst_22535;
var inst_22534 = inst_22542;
var inst_22535__$1 = tmp22789;
var state_22627__$1 = (function (){var statearr_22794 = state_22627;
(statearr_22794[(37)] = inst_22534);

(statearr_22794[(33)] = inst_22535__$1);

return statearr_22794;
})();
var statearr_22795_22975 = state_22627__$1;
(statearr_22795_22975[(2)] = null);

(statearr_22795_22975[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (16))){
var inst_22222 = (state_22627[(36)]);
var state_22627__$1 = state_22627;
var statearr_22796_22976 = state_22627__$1;
(statearr_22796_22976[(2)] = inst_22222);

(statearr_22796_22976[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (133))){
var inst_22620 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22797_22977 = state_22627__$1;
(statearr_22797_22977[(2)] = inst_22620);

(statearr_22797_22977[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (81))){
var inst_22396 = (state_22627[(28)]);
var inst_22229 = (state_22627[(13)]);
var inst_22405 = (state_22627[(59)]);
var inst_22399 = cljs.core.deref(cache);
var inst_22400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22401 = inst_22396.o;
var inst_22402 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22229);
var inst_22403 = [inst_22401,inst_22402];
var inst_22404 = (new cljs.core.PersistentVector(null,2,(5),inst_22400,inst_22403,null));
var inst_22405__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22399,inst_22404);
var state_22627__$1 = (function (){var statearr_22798 = state_22627;
(statearr_22798[(59)] = inst_22405__$1);

return statearr_22798;
})();
if(cljs.core.truth_(inst_22405__$1)){
var statearr_22799_22978 = state_22627__$1;
(statearr_22799_22978[(1)] = (84));

} else {
var statearr_22800_22979 = state_22627__$1;
(statearr_22800_22979[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (120))){
var inst_22569 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22801_22980 = state_22627__$1;
(statearr_22801_22980[(2)] = inst_22569);

(statearr_22801_22980[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (79))){
var inst_22389 = (state_22627[(45)]);
var inst_22396 = (state_22627[(28)]);
var inst_22395 = cljs.core.seq(inst_22389);
var inst_22396__$1 = cljs.core.first(inst_22395);
var inst_22397 = cljs.core.next(inst_22395);
var state_22627__$1 = (function (){var statearr_22802 = state_22627;
(statearr_22802[(28)] = inst_22396__$1);

(statearr_22802[(44)] = inst_22397);

return statearr_22802;
})();
if(cljs.core.truth_(inst_22396__$1)){
var statearr_22803_22981 = state_22627__$1;
(statearr_22803_22981[(1)] = (81));

} else {
var statearr_22804_22982 = state_22627__$1;
(statearr_22804_22982[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (38))){
var inst_22264 = (state_22627[(43)]);
var inst_22272 = (state_22627[(2)]);
var inst_22273 = [null,inst_22272];
var inst_22274 = (new cljs.core.PersistentVector(null,2,(5),inst_22264,inst_22273,null));
var state_22627__$1 = state_22627;
var statearr_22805_22983 = state_22627__$1;
(statearr_22805_22983[(2)] = inst_22274);

(statearr_22805_22983[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (126))){
var state_22627__$1 = state_22627;
var statearr_22806_22984 = state_22627__$1;
(statearr_22806_22984[(2)] = null);

(statearr_22806_22984[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (98))){
var inst_22443 = (state_22627[(60)]);
var inst_22507 = (state_22627[(2)]);
var inst_22508 = [inst_22507,offset_map];
var inst_22509 = (new cljs.core.PersistentVector(null,2,(5),inst_22443,inst_22508,null));
var state_22627__$1 = state_22627;
var statearr_22807_22985 = state_22627__$1;
(statearr_22807_22985[(2)] = inst_22509);

(statearr_22807_22985[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (124))){
var inst_22563 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22808_22986 = state_22627__$1;
(statearr_22808_22986[(2)] = inst_22563);

(statearr_22808_22986[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (87))){
var inst_22396 = (state_22627[(28)]);
var inst_22229 = (state_22627[(13)]);
var inst_22412 = (state_22627[(2)]);
var inst_22413 = fluree.db.util.async.throw_err(inst_22412);
var inst_22414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22415 = inst_22396.o;
var inst_22416 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22229);
var inst_22417 = [inst_22415,inst_22416];
var inst_22418 = (new cljs.core.PersistentVector(null,2,(5),inst_22414,inst_22417,null));
var inst_22419 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_22418,inst_22413);
var state_22627__$1 = (function (){var statearr_22809 = state_22627;
(statearr_22809[(61)] = inst_22419);

return statearr_22809;
})();
var statearr_22810_22987 = state_22627__$1;
(statearr_22810_22987[(2)] = inst_22413);

(statearr_22810_22987[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (30))){
var inst_22247 = (state_22627[(16)]);
var inst_22252 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22247);
var inst_22253 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22252);
var state_22627__$1 = state_22627;
var statearr_22811_22988 = state_22627__$1;
(statearr_22811_22988[(2)] = inst_22253);

(statearr_22811_22988[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (73))){
var inst_22327 = (state_22627[(9)]);
var inst_22352 = (state_22627[(22)]);
var inst_22361 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22327,inst_22352);
var state_22627__$1 = state_22627;
var statearr_22812_22989 = state_22627__$1;
(statearr_22812_22989[(2)] = inst_22361);

(statearr_22812_22989[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (96))){
var inst_22587 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
var statearr_22813_22990 = state_22627__$1;
(statearr_22813_22990[(2)] = inst_22587);

(statearr_22813_22990[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (10))){
var state_22627__$1 = state_22627;
var statearr_22814_22991 = state_22627__$1;
(statearr_22814_22991[(2)] = pred_spec);

(statearr_22814_22991[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (18))){
var inst_22230 = (state_22627[(52)]);
var state_22627__$1 = state_22627;
var statearr_22815_22992 = state_22627__$1;
(statearr_22815_22992[(2)] = inst_22230);

(statearr_22815_22992[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (105))){
var inst_22495 = (state_22627[(2)]);
var state_22627__$1 = (function (){var statearr_22816 = state_22627;
(statearr_22816[(46)] = inst_22495);

return statearr_22816;
})();
if(cljs.core.truth_(fuel)){
var statearr_22817_22993 = state_22627__$1;
(statearr_22817_22993[(1)] = (107));

} else {
var statearr_22818_22994 = state_22627__$1;
(statearr_22818_22994[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (52))){
var inst_22297 = (state_22627[(62)]);
var state_22627__$1 = state_22627;
var statearr_22819_22995 = state_22627__$1;
(statearr_22819_22995[(2)] = inst_22297);

(statearr_22819_22995[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (114))){
var inst_22529 = flakes;
var inst_22530 = cljs.core.seq(inst_22529);
var inst_22531 = cljs.core.first(inst_22530);
var inst_22532 = cljs.core.next(inst_22530);
var inst_22533 = cljs.core.PersistentVector.EMPTY;
var inst_22534 = inst_22529;
var inst_22535 = inst_22533;
var state_22627__$1 = (function (){var statearr_22820 = state_22627;
(statearr_22820[(63)] = inst_22531);

(statearr_22820[(37)] = inst_22534);

(statearr_22820[(33)] = inst_22535);

(statearr_22820[(64)] = inst_22532);

return statearr_22820;
})();
var statearr_22821_22996 = state_22627__$1;
(statearr_22821_22996[(2)] = null);

(statearr_22821_22996[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (67))){
var state_22627__$1 = state_22627;
var statearr_22822_22997 = state_22627__$1;
(statearr_22822_22997[(2)] = null);

(statearr_22822_22997[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (71))){
var state_22627__$1 = state_22627;
var statearr_22823_22998 = state_22627__$1;
(statearr_22823_22998[(2)] = null);

(statearr_22823_22998[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (42))){
var inst_22244 = (state_22627[(20)]);
var state_22627__$1 = state_22627;
if(cljs.core.truth_(inst_22244)){
var statearr_22824_22999 = state_22627__$1;
(statearr_22824_22999[(1)] = (45));

} else {
var statearr_22825_23000 = state_22627__$1;
(statearr_22825_23000[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (80))){
var inst_22376 = (state_22627[(55)]);
var inst_22432 = (state_22627[(2)]);
var inst_22433 = [inst_22432,offset_map];
var inst_22434 = (new cljs.core.PersistentVector(null,2,(5),inst_22376,inst_22433,null));
var state_22627__$1 = state_22627;
var statearr_22826_23001 = state_22627__$1;
(statearr_22826_23001[(2)] = inst_22434);

(statearr_22826_23001[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (37))){
var inst_22247 = (state_22627[(16)]);
var inst_22246 = (state_22627[(19)]);
var inst_22269 = (inst_22246 - (1));
var inst_22270 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22247,inst_22269);
var state_22627__$1 = state_22627;
var statearr_22827_23002 = state_22627__$1;
(statearr_22827_23002[(2)] = inst_22270);

(statearr_22827_23002[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (63))){
var inst_22327 = (state_22627[(9)]);
var state_22627__$1 = state_22627;
var statearr_22828_23003 = state_22627__$1;
(statearr_22828_23003[(2)] = inst_22327);

(statearr_22828_23003[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (94))){
var inst_22443 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22451 = flakes;
var inst_22452 = cljs.core.seq(inst_22451);
var inst_22453 = cljs.core.first(inst_22452);
var inst_22454 = cljs.core.next(inst_22452);
var inst_22455 = cljs.core.PersistentVector.EMPTY;
var inst_22456 = inst_22451;
var inst_22457 = inst_22455;
var state_22627__$1 = (function (){var statearr_22829 = state_22627;
(statearr_22829[(65)] = inst_22453);

(statearr_22829[(48)] = inst_22456);

(statearr_22829[(66)] = inst_22454);

(statearr_22829[(32)] = inst_22457);

(statearr_22829[(60)] = inst_22443);

return statearr_22829;
})();
var statearr_22830_23004 = state_22627__$1;
(statearr_22830_23004[(2)] = null);

(statearr_22830_23004[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (8))){
var inst_22206 = (state_22627[(2)]);
var state_22627__$1 = state_22627;
if(cljs.core.truth_(inst_22206)){
var statearr_22831_23005 = state_22627__$1;
(statearr_22831_23005[(1)] = (9));

} else {
var statearr_22832_23006 = state_22627__$1;
(statearr_22832_23006[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (49))){
var inst_22297 = (state_22627[(62)]);
var inst_22297__$1 = cljs.core.not(recur_QMARK_);
var state_22627__$1 = (function (){var statearr_22833 = state_22627;
(statearr_22833[(62)] = inst_22297__$1);

return statearr_22833;
})();
if(inst_22297__$1){
var statearr_22834_23007 = state_22627__$1;
(statearr_22834_23007[(1)] = (51));

} else {
var statearr_22835_23008 = state_22627__$1;
(statearr_22835_23008[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22628 === (84))){
var inst_22405 = (state_22627[(59)]);
var state_22627__$1 = state_22627;
var statearr_22836_23009 = state_22627__$1;
(statearr_22836_23009[(2)] = inst_22405);

(statearr_22836_23009[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2727__auto__ = null;
var fluree$db$query$fql$state_machine__2727__auto____0 = (function (){
var statearr_22837 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22837[(0)] = fluree$db$query$fql$state_machine__2727__auto__);

(statearr_22837[(1)] = (1));

return statearr_22837;
});
var fluree$db$query$fql$state_machine__2727__auto____1 = (function (state_22627){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_22627);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22838){var ex__2730__auto__ = e22838;
var statearr_22839_23010 = state_22627;
(statearr_22839_23010[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_22627[(4)]))){
var statearr_22840_23011 = state_22627;
(statearr_22840_23011[(1)] = cljs.core.first((state_22627[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23012 = state_22627;
state_22627 = G__23012;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2727__auto__ = function(state_22627){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2727__auto____1.call(this,state_22627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2727__auto____0;
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2727__auto____1;
return fluree$db$query$fql$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22841 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_22841[(6)] = c__2749__auto__);

return statearr_22841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23172){
var state_val_23173 = (state_23172[(1)]);
if((state_val_23173 === (7))){
var inst_23167 = (state_23172[(2)]);
var _ = (function (){var statearr_23174 = state_23172;
(statearr_23174[(4)] = cljs.core.rest((state_23172[(4)])));

return statearr_23174;
})();
var state_23172__$1 = state_23172;
var statearr_23175_23257 = state_23172__$1;
(statearr_23175_23257[(2)] = inst_23167);

(statearr_23175_23257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (20))){
var inst_23094 = (state_23172[(7)]);
var state_23172__$1 = state_23172;
var statearr_23176_23258 = state_23172__$1;
(statearr_23176_23258[(2)] = inst_23094);

(statearr_23176_23258[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (27))){
var inst_23049 = (state_23172[(8)]);
var state_23172__$1 = state_23172;
if(cljs.core.truth_(inst_23049)){
var statearr_23177_23259 = state_23172__$1;
(statearr_23177_23259[(1)] = (29));

} else {
var statearr_23178_23260 = state_23172__$1;
(statearr_23178_23260[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (1))){
var state_23172__$1 = state_23172;
var statearr_23179_23261 = state_23172__$1;
(statearr_23179_23261[(2)] = null);

(statearr_23179_23261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (24))){
var inst_23050 = (state_23172[(9)]);
var state_23172__$1 = state_23172;
var statearr_23180_23262 = state_23172__$1;
(statearr_23180_23262[(2)] = inst_23050);

(statearr_23180_23262[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (39))){
var inst_23086 = (state_23172[(10)]);
var state_23172__$1 = state_23172;
var statearr_23181_23263 = state_23172__$1;
(statearr_23181_23263[(2)] = inst_23086);

(statearr_23181_23263[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (46))){
var inst_23051 = (state_23172[(11)]);
var state_23172__$1 = state_23172;
var statearr_23182_23264 = state_23172__$1;
(statearr_23182_23264[(2)] = inst_23051);

(statearr_23182_23264[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (4))){
var inst_23013 = (state_23172[(2)]);
var state_23172__$1 = state_23172;
var statearr_23183_23265 = state_23172__$1;
(statearr_23183_23265[(2)] = inst_23013);

(statearr_23183_23265[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (15))){
var inst_23062 = (state_23172[(12)]);
var inst_23068 = cljs.core.count(inst_23062);
var inst_23069 = fluree.db.query.fql.add_fuel(fuel,inst_23068,max_fuel);
var state_23172__$1 = state_23172;
var statearr_23184_23266 = state_23172__$1;
(statearr_23184_23266[(2)] = inst_23069);

(statearr_23184_23266[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (48))){
var inst_23153 = (state_23172[(13)]);
var inst_23038 = (state_23172[(14)]);
var inst_23031 = (state_23172[(15)]);
var inst_23161 = (state_23172[(2)]);
var inst_23162 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23031,inst_23161,inst_23153);
var inst_23030 = inst_23038;
var inst_23031__$1 = inst_23162;
var state_23172__$1 = (function (){var statearr_23185 = state_23172;
(statearr_23185[(16)] = inst_23030);

(statearr_23185[(15)] = inst_23031__$1);

return statearr_23185;
})();
var statearr_23186_23267 = state_23172__$1;
(statearr_23186_23267[(2)] = null);

(statearr_23186_23267[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (50))){
var inst_23053 = (state_23172[(17)]);
var state_23172__$1 = state_23172;
var statearr_23187_23268 = state_23172__$1;
(statearr_23187_23268[(2)] = inst_23053);

(statearr_23187_23268[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (21))){
var inst_23050 = (state_23172[(9)]);
var state_23172__$1 = state_23172;
if(cljs.core.truth_(inst_23050)){
var statearr_23189_23269 = state_23172__$1;
(statearr_23189_23269[(1)] = (23));

} else {
var statearr_23190_23270 = state_23172__$1;
(statearr_23190_23270[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (31))){
var inst_23110 = (state_23172[(2)]);
var state_23172__$1 = state_23172;
if(cljs.core.truth_(inst_23110)){
var statearr_23191_23271 = state_23172__$1;
(statearr_23191_23271[(1)] = (32));

} else {
var statearr_23192_23272 = state_23172__$1;
(statearr_23192_23272[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (32))){
var inst_23086 = (state_23172[(10)]);
var inst_23085 = (state_23172[(18)]);
var inst_23093 = (state_23172[(19)]);
var inst_23112 = (inst_23085 + (1));
var tmp23188 = inst_23086;
var inst_23084 = inst_23093;
var inst_23085__$1 = inst_23112;
var inst_23086__$1 = tmp23188;
var state_23172__$1 = (function (){var statearr_23193 = state_23172;
(statearr_23193[(10)] = inst_23086__$1);

(statearr_23193[(18)] = inst_23085__$1);

(statearr_23193[(20)] = inst_23084);

return statearr_23193;
})();
var statearr_23194_23273 = state_23172__$1;
(statearr_23194_23273[(2)] = null);

(statearr_23194_23273[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (40))){
var state_23172__$1 = state_23172;
if(cljs.core.truth_(fuel)){
var statearr_23195_23274 = state_23172__$1;
(statearr_23195_23274[(1)] = (42));

} else {
var statearr_23196_23275 = state_23172__$1;
(statearr_23196_23275[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (33))){
var state_23172__$1 = state_23172;
var statearr_23197_23276 = state_23172__$1;
(statearr_23197_23276[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (13))){
var inst_23062 = (state_23172[(12)]);
var state_23172__$1 = state_23172;
var statearr_23199_23277 = state_23172__$1;
(statearr_23199_23277[(2)] = inst_23062);

(statearr_23199_23277[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (22))){
var inst_23103 = (state_23172[(2)]);
var state_23172__$1 = state_23172;
if(cljs.core.truth_(inst_23103)){
var statearr_23200_23278 = state_23172__$1;
(statearr_23200_23278[(1)] = (26));

} else {
var statearr_23201_23279 = state_23172__$1;
(statearr_23201_23279[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (36))){
var state_23172__$1 = state_23172;
var statearr_23202_23280 = state_23172__$1;
(statearr_23202_23280[(2)] = null);

(statearr_23202_23280[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (41))){
var inst_23085 = (state_23172[(18)]);
var inst_23093 = (state_23172[(19)]);
var inst_23142 = (state_23172[(2)]);
var inst_23143 = (inst_23085 + (1));
var inst_23084 = inst_23093;
var inst_23085__$1 = inst_23143;
var inst_23086 = inst_23142;
var state_23172__$1 = (function (){var statearr_23203 = state_23172;
(statearr_23203[(10)] = inst_23086);

(statearr_23203[(18)] = inst_23085__$1);

(statearr_23203[(20)] = inst_23084);

return statearr_23203;
})();
var statearr_23204_23281 = state_23172__$1;
(statearr_23204_23281[(2)] = null);

(statearr_23204_23281[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (43))){
var state_23172__$1 = state_23172;
var statearr_23205_23282 = state_23172__$1;
(statearr_23205_23282[(2)] = null);

(statearr_23205_23282[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (29))){
var inst_23085 = (state_23172[(18)]);
var inst_23049 = (state_23172[(8)]);
var inst_23107 = (inst_23085 < inst_23049);
var state_23172__$1 = state_23172;
var statearr_23206_23283 = state_23172__$1;
(statearr_23206_23283[(2)] = inst_23107);

(statearr_23206_23283[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (44))){
var inst_23122 = (state_23172[(21)]);
var inst_23126 = (state_23172[(22)]);
var inst_23135 = (state_23172[(2)]);
var inst_23136 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_23126,inst_23122) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23126,inst_23122));
var state_23172__$1 = (function (){var statearr_23207 = state_23172;
(statearr_23207[(23)] = inst_23135);

return statearr_23207;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23172__$1,(45),inst_23136);
} else {
if((state_val_23173 === (6))){
var inst_23030 = (state_23172[(16)]);
var inst_23037 = (state_23172[(24)]);
var inst_23036 = cljs.core.seq(inst_23030);
var inst_23037__$1 = cljs.core.first(inst_23036);
var inst_23038 = cljs.core.next(inst_23036);
var inst_23039 = cljs.core.not(inst_23037__$1);
var state_23172__$1 = (function (){var statearr_23208 = state_23172;
(statearr_23208[(14)] = inst_23038);

(statearr_23208[(24)] = inst_23037__$1);

return statearr_23208;
})();
if(inst_23039){
var statearr_23209_23284 = state_23172__$1;
(statearr_23209_23284[(1)] = (8));

} else {
var statearr_23210_23285 = state_23172__$1;
(statearr_23210_23285[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (28))){
var inst_23151 = (state_23172[(2)]);
var state_23172__$1 = state_23172;
var statearr_23211_23286 = state_23172__$1;
(statearr_23211_23286[(2)] = inst_23151);

(statearr_23211_23286[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (51))){
var inst_23159 = (state_23172[(2)]);
var state_23172__$1 = state_23172;
var statearr_23212_23287 = state_23172__$1;
(statearr_23212_23287[(2)] = inst_23159);

(statearr_23212_23287[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (25))){
var inst_23101 = (state_23172[(2)]);
var state_23172__$1 = state_23172;
var statearr_23213_23288 = state_23172__$1;
(statearr_23213_23288[(2)] = inst_23101);

(statearr_23213_23288[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (34))){
var inst_23149 = (state_23172[(2)]);
var state_23172__$1 = state_23172;
var statearr_23214_23289 = state_23172__$1;
(statearr_23214_23289[(2)] = inst_23149);

(statearr_23214_23289[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (17))){
var inst_23062 = (state_23172[(12)]);
var inst_23072 = (state_23172[(2)]);
var inst_23080 = cljs.core.seq(inst_23062);
var inst_23081 = cljs.core.first(inst_23080);
var inst_23082 = cljs.core.next(inst_23080);
var inst_23083 = cljs.core.PersistentVector.EMPTY;
var inst_23084 = inst_23062;
var inst_23085 = (0);
var inst_23086 = inst_23083;
var state_23172__$1 = (function (){var statearr_23215 = state_23172;
(statearr_23215[(25)] = inst_23081);

(statearr_23215[(10)] = inst_23086);

(statearr_23215[(18)] = inst_23085);

(statearr_23215[(26)] = inst_23072);

(statearr_23215[(27)] = inst_23082);

(statearr_23215[(20)] = inst_23084);

return statearr_23215;
})();
var statearr_23216_23290 = state_23172__$1;
(statearr_23216_23290[(2)] = null);

(statearr_23216_23290[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (3))){
var inst_23170 = (state_23172[(2)]);
var state_23172__$1 = state_23172;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23172__$1,inst_23170);
} else {
if((state_val_23173 === (12))){
var state_23172__$1 = state_23172;
var statearr_23217_23291 = state_23172__$1;
(statearr_23217_23291[(2)] = fuel);

(statearr_23217_23291[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (2))){
var _ = (function (){var statearr_23218 = state_23172;
(statearr_23218[(4)] = cljs.core.cons((5),(state_23172[(4)])));

return statearr_23218;
})();
var inst_23026 = reverse_refs_specs;
var inst_23027 = cljs.core.seq(inst_23026);
var inst_23028 = cljs.core.first(inst_23027);
var inst_23029 = cljs.core.next(inst_23027);
var inst_23030 = inst_23026;
var inst_23031 = null;
var state_23172__$1 = (function (){var statearr_23219 = state_23172;
(statearr_23219[(28)] = inst_23029);

(statearr_23219[(16)] = inst_23030);

(statearr_23219[(29)] = inst_23028);

(statearr_23219[(15)] = inst_23031);

return statearr_23219;
})();
var statearr_23220_23292 = state_23172__$1;
(statearr_23220_23292[(2)] = null);

(statearr_23220_23292[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (23))){
var inst_23050 = (state_23172[(9)]);
var inst_23085 = (state_23172[(18)]);
var inst_23098 = (inst_23085 >= inst_23050);
var state_23172__$1 = state_23172;
var statearr_23221_23293 = state_23172__$1;
(statearr_23221_23293[(2)] = inst_23098);

(statearr_23221_23293[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (47))){
var inst_23052 = (state_23172[(30)]);
var state_23172__$1 = state_23172;
if(cljs.core.truth_(inst_23052)){
var statearr_23222_23294 = state_23172__$1;
(statearr_23222_23294[(1)] = (49));

} else {
var statearr_23223_23295 = state_23172__$1;
(statearr_23223_23295[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (35))){
var inst_23092 = (state_23172[(31)]);
var inst_23116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23117 = [inst_23092];
var inst_23118 = (new cljs.core.PersistentVector(null,1,(5),inst_23116,inst_23117,null));
var inst_23119 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23118);
var state_23172__$1 = state_23172;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23172__$1,(38),inst_23119);
} else {
if((state_val_23173 === (19))){
var inst_23051 = (state_23172[(11)]);
var inst_23153 = (state_23172[(2)]);
var state_23172__$1 = (function (){var statearr_23224 = state_23172;
(statearr_23224[(13)] = inst_23153);

return statearr_23224;
})();
if(cljs.core.truth_(inst_23051)){
var statearr_23225_23296 = state_23172__$1;
(statearr_23225_23296[(1)] = (46));

} else {
var statearr_23226_23297 = state_23172__$1;
(statearr_23226_23297[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (11))){
var inst_23062 = (state_23172[(12)]);
var inst_23059 = (state_23172[(2)]);
var inst_23060 = fluree.db.util.async.throw_err(inst_23059);
var inst_23061 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_23060);
var inst_23062__$1 = cljs.core.not_empty(inst_23061);
var state_23172__$1 = (function (){var statearr_23228 = state_23172;
(statearr_23228[(12)] = inst_23062__$1);

return statearr_23228;
})();
if(cljs.core.truth_(inst_23062__$1)){
var statearr_23229_23298 = state_23172__$1;
(statearr_23229_23298[(1)] = (12));

} else {
var statearr_23230_23299 = state_23172__$1;
(statearr_23230_23299[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (9))){
var inst_23047 = (state_23172[(32)]);
var inst_23037 = (state_23172[(24)]);
var inst_23046 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23037,(0),null);
var inst_23047__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23037,(1),null);
var inst_23048 = cljs.core.__destructure_map(inst_23047__$1);
var inst_23049 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23048,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_23050 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23048,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23051 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23048,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23052 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23048,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_23053 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23048,new cljs.core.Keyword(null,"p","p",151049309));
var inst_23054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23055 = [subject_id,inst_23046];
var inst_23056 = (new cljs.core.PersistentVector(null,2,(5),inst_23054,inst_23055,null));
var inst_23057 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_23056);
var state_23172__$1 = (function (){var statearr_23231 = state_23172;
(statearr_23231[(9)] = inst_23050);

(statearr_23231[(17)] = inst_23053);

(statearr_23231[(32)] = inst_23047__$1);

(statearr_23231[(8)] = inst_23049);

(statearr_23231[(11)] = inst_23051);

(statearr_23231[(30)] = inst_23052);

return statearr_23231;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23172__$1,(11),inst_23057);
} else {
if((state_val_23173 === (5))){
var _ = (function (){var statearr_23232 = state_23172;
(statearr_23232[(4)] = cljs.core.rest((state_23172[(4)])));

return statearr_23232;
})();
var state_23172__$1 = state_23172;
var ex23227 = (state_23172__$1[(2)]);
var statearr_23233_23300 = state_23172__$1;
(statearr_23233_23300[(5)] = ex23227);


if((ex23227 instanceof Error)){
var statearr_23234_23301 = state_23172__$1;
(statearr_23234_23301[(1)] = (4));

(statearr_23234_23301[(5)] = null);

} else {
throw ex23227;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (14))){
var inst_23066 = (state_23172[(2)]);
var state_23172__$1 = state_23172;
if(cljs.core.truth_(inst_23066)){
var statearr_23235_23302 = state_23172__$1;
(statearr_23235_23302[(1)] = (15));

} else {
var statearr_23236_23303 = state_23172__$1;
(statearr_23236_23303[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (45))){
var inst_23086 = (state_23172[(10)]);
var inst_23138 = (state_23172[(2)]);
var inst_23139 = fluree.db.util.async.throw_err(inst_23138);
var inst_23140 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23086,inst_23139);
var state_23172__$1 = state_23172;
var statearr_23237_23304 = state_23172__$1;
(statearr_23237_23304[(2)] = inst_23140);

(statearr_23237_23304[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (26))){
var inst_23086 = (state_23172[(10)]);
var state_23172__$1 = state_23172;
var statearr_23238_23305 = state_23172__$1;
(statearr_23238_23305[(2)] = inst_23086);

(statearr_23238_23305[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (16))){
var state_23172__$1 = state_23172;
var statearr_23239_23306 = state_23172__$1;
(statearr_23239_23306[(2)] = null);

(statearr_23239_23306[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (38))){
var inst_23047 = (state_23172[(32)]);
var inst_23122 = (state_23172[(21)]);
var inst_23121 = (state_23172[(2)]);
var inst_23122__$1 = fluree.db.util.async.throw_err(inst_23121);
var inst_23123 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23124 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23125 = (new cljs.core.PersistentVector(null,4,(5),inst_23123,inst_23124,null));
var inst_23126 = cljs.core.select_keys(inst_23047,inst_23125);
var inst_23127 = cljs.core.empty_QMARK_(inst_23122__$1);
var state_23172__$1 = (function (){var statearr_23240 = state_23172;
(statearr_23240[(21)] = inst_23122__$1);

(statearr_23240[(22)] = inst_23126);

return statearr_23240;
})();
if(inst_23127){
var statearr_23241_23307 = state_23172__$1;
(statearr_23241_23307[(1)] = (39));

} else {
var statearr_23242_23308 = state_23172__$1;
(statearr_23242_23308[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (30))){
var inst_23049 = (state_23172[(8)]);
var state_23172__$1 = state_23172;
var statearr_23243_23309 = state_23172__$1;
(statearr_23243_23309[(2)] = inst_23049);

(statearr_23243_23309[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (10))){
var inst_23165 = (state_23172[(2)]);
var state_23172__$1 = state_23172;
var statearr_23244_23310 = state_23172__$1;
(statearr_23244_23310[(2)] = inst_23165);

(statearr_23244_23310[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (18))){
var inst_23094 = (state_23172[(7)]);
var inst_23092 = (state_23172[(31)]);
var inst_23084 = (state_23172[(20)]);
var inst_23091 = cljs.core.seq(inst_23084);
var inst_23092__$1 = cljs.core.first(inst_23091);
var inst_23093 = cljs.core.next(inst_23091);
var inst_23094__$1 = cljs.core.not(inst_23092__$1);
var state_23172__$1 = (function (){var statearr_23245 = state_23172;
(statearr_23245[(7)] = inst_23094__$1);

(statearr_23245[(19)] = inst_23093);

(statearr_23245[(31)] = inst_23092__$1);

return statearr_23245;
})();
if(inst_23094__$1){
var statearr_23246_23311 = state_23172__$1;
(statearr_23246_23311[(1)] = (20));

} else {
var statearr_23247_23312 = state_23172__$1;
(statearr_23247_23312[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (42))){
var inst_23122 = (state_23172[(21)]);
var inst_23131 = cljs.core.count(inst_23122);
var inst_23132 = fluree.db.query.fql.add_fuel(fuel,inst_23131,max_fuel);
var state_23172__$1 = state_23172;
var statearr_23248_23313 = state_23172__$1;
(statearr_23248_23313[(2)] = inst_23132);

(statearr_23248_23313[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (37))){
var inst_23147 = (state_23172[(2)]);
var state_23172__$1 = state_23172;
var statearr_23249_23314 = state_23172__$1;
(statearr_23249_23314[(2)] = inst_23147);

(statearr_23249_23314[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (8))){
var inst_23031 = (state_23172[(15)]);
var state_23172__$1 = state_23172;
var statearr_23250_23315 = state_23172__$1;
(statearr_23250_23315[(2)] = inst_23031);

(statearr_23250_23315[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (49))){
var inst_23052 = (state_23172[(30)]);
var state_23172__$1 = state_23172;
var statearr_23251_23316 = state_23172__$1;
(statearr_23251_23316[(2)] = inst_23052);

(statearr_23251_23316[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto____0 = (function (){
var statearr_23252 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23252[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto__);

(statearr_23252[(1)] = (1));

return statearr_23252;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto____1 = (function (state_23172){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23172);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23253){var ex__2730__auto__ = e23253;
var statearr_23254_23317 = state_23172;
(statearr_23254_23317[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23172[(4)]))){
var statearr_23255_23318 = state_23172;
(statearr_23255_23318[(1)] = cljs.core.first((state_23172[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23319 = state_23172;
state_23172 = G__23319;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto__ = function(state_23172){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto____1.call(this,state_23172);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23256 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23256[(6)] = c__2749__auto__);

return statearr_23256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__23320 = select_spec;
var map__23320__$1 = cljs.core.__destructure_map(map__23320);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23320__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23320__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23434){
var state_val_23435 = (state_23434[(1)]);
if((state_val_23435 === (7))){
var inst_23346 = flakes;
var inst_23347 = cljs.core.seq(inst_23346);
var inst_23348 = cljs.core.first(inst_23347);
var inst_23349 = cljs.core.next(inst_23347);
var inst_23350 = cljs.core.PersistentVector.EMPTY;
var inst_23351 = inst_23346;
var inst_23352 = (0);
var inst_23353 = inst_23350;
var state_23434__$1 = (function (){var statearr_23436 = state_23434;
(statearr_23436[(7)] = inst_23348);

(statearr_23436[(8)] = inst_23351);

(statearr_23436[(9)] = inst_23353);

(statearr_23436[(10)] = inst_23349);

(statearr_23436[(11)] = inst_23352);

return statearr_23436;
})();
var statearr_23437_23503 = state_23434__$1;
(statearr_23437_23503[(2)] = null);

(statearr_23437_23503[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (20))){
var state_23434__$1 = state_23434;
var statearr_23438_23504 = state_23434__$1;
(statearr_23438_23504[(2)] = results);

(statearr_23438_23504[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (27))){
var state_23434__$1 = state_23434;
var statearr_23439_23505 = state_23434__$1;
(statearr_23439_23505[(2)] = null);

(statearr_23439_23505[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (1))){
var state_23434__$1 = state_23434;
var statearr_23440_23506 = state_23434__$1;
(statearr_23440_23506[(2)] = null);

(statearr_23440_23506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (24))){
var state_23434__$1 = state_23434;
var statearr_23441_23507 = state_23434__$1;
(statearr_23441_23507[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (39))){
var inst_23415 = (state_23434[(12)]);
var inst_23353 = (state_23434[(9)]);
var inst_23360 = (state_23434[(13)]);
var inst_23418 = (state_23434[(2)]);
var inst_23419 = fluree.db.util.async.throw_err(inst_23418);
var inst_23420 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23353,inst_23419);
var inst_23351 = inst_23360;
var inst_23352 = inst_23415;
var inst_23353__$1 = inst_23420;
var state_23434__$1 = (function (){var statearr_23443 = state_23434;
(statearr_23443[(8)] = inst_23351);

(statearr_23443[(9)] = inst_23353__$1);

(statearr_23443[(11)] = inst_23352);

return statearr_23443;
})();
var statearr_23444_23508 = state_23434__$1;
(statearr_23444_23508[(2)] = null);

(statearr_23444_23508[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (4))){
var inst_23321 = (state_23434[(2)]);
var state_23434__$1 = state_23434;
var statearr_23445_23509 = state_23434__$1;
(statearr_23445_23509[(2)] = inst_23321);

(statearr_23445_23509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (15))){
var inst_23334 = (state_23434[(14)]);
var state_23434__$1 = state_23434;
var statearr_23446_23510 = state_23434__$1;
(statearr_23446_23510[(2)] = inst_23334);

(statearr_23446_23510[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (21))){
var inst_23330 = (state_23434[(15)]);
var state_23434__$1 = state_23434;
if(cljs.core.truth_(inst_23330)){
var statearr_23447_23511 = state_23434__$1;
(statearr_23447_23511[(1)] = (23));

} else {
var statearr_23448_23512 = state_23434__$1;
(statearr_23448_23512[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (31))){
var inst_23398 = (state_23434[(16)]);
var state_23434__$1 = state_23434;
var statearr_23449_23513 = state_23434__$1;
(statearr_23449_23513[(2)] = inst_23398);

(statearr_23449_23513[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (32))){
var inst_23390 = (state_23434[(17)]);
var inst_23404 = (state_23434[(2)]);
var state_23434__$1 = (function (){var statearr_23450 = state_23434;
(statearr_23450[(18)] = inst_23404);

return statearr_23450;
})();
if(cljs.core.truth_(inst_23390)){
var statearr_23451_23514 = state_23434__$1;
(statearr_23451_23514[(1)] = (33));

} else {
var statearr_23452_23515 = state_23434__$1;
(statearr_23452_23515[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (33))){
var inst_23390 = (state_23434[(17)]);
var state_23434__$1 = state_23434;
var statearr_23453_23516 = state_23434__$1;
(statearr_23453_23516[(2)] = inst_23390);

(statearr_23453_23516[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (13))){
var inst_23370 = (state_23434[(2)]);
var state_23434__$1 = state_23434;
if(cljs.core.truth_(inst_23370)){
var statearr_23455_23517 = state_23434__$1;
(statearr_23455_23517[(1)] = (17));

} else {
var statearr_23456_23518 = state_23434__$1;
(statearr_23456_23518[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (22))){
var inst_23387 = (state_23434[(2)]);
var state_23434__$1 = state_23434;
var statearr_23457_23519 = state_23434__$1;
(statearr_23457_23519[(2)] = inst_23387);

(statearr_23457_23519[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (36))){
var inst_23353 = (state_23434[(9)]);
var inst_23360 = (state_23434[(13)]);
var inst_23352 = (state_23434[(11)]);
var inst_23412 = (inst_23352 + (1));
var tmp23454 = inst_23353;
var inst_23351 = inst_23360;
var inst_23352__$1 = inst_23412;
var inst_23353__$1 = tmp23454;
var state_23434__$1 = (function (){var statearr_23458 = state_23434;
(statearr_23458[(8)] = inst_23351);

(statearr_23458[(9)] = inst_23353__$1);

(statearr_23458[(11)] = inst_23352__$1);

return statearr_23458;
})();
var statearr_23459_23520 = state_23434__$1;
(statearr_23459_23520[(2)] = null);

(statearr_23459_23520[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (29))){
var inst_23397 = (state_23434[(2)]);
var inst_23398 = fluree.db.util.async.throw_err(inst_23397);
var state_23434__$1 = (function (){var statearr_23460 = state_23434;
(statearr_23460[(16)] = inst_23398);

return statearr_23460;
})();
if(cljs.core.truth_(fuel)){
var statearr_23461_23521 = state_23434__$1;
(statearr_23461_23521[(1)] = (30));

} else {
var statearr_23462_23522 = state_23434__$1;
(statearr_23462_23522[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (6))){
var state_23434__$1 = state_23434;
var statearr_23463_23523 = state_23434__$1;
(statearr_23463_23523[(2)] = results);

(statearr_23463_23523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (28))){
var inst_23383 = (state_23434[(2)]);
var state_23434__$1 = state_23434;
var statearr_23464_23524 = state_23434__$1;
(statearr_23464_23524[(2)] = inst_23383);

(statearr_23464_23524[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (25))){
var inst_23385 = (state_23434[(2)]);
var state_23434__$1 = state_23434;
var statearr_23465_23525 = state_23434__$1;
(statearr_23465_23525[(2)] = inst_23385);

(statearr_23465_23525[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (34))){
var inst_23404 = (state_23434[(18)]);
var inst_23407 = cljs.core.empty_QMARK_(inst_23404);
var state_23434__$1 = state_23434;
var statearr_23466_23526 = state_23434__$1;
(statearr_23466_23526[(2)] = inst_23407);

(statearr_23466_23526[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (17))){
var inst_23353 = (state_23434[(9)]);
var inst_23372 = cljs.core.empty_QMARK_(inst_23353);
var state_23434__$1 = state_23434;
if(inst_23372){
var statearr_23467_23527 = state_23434__$1;
(statearr_23467_23527[(1)] = (20));

} else {
var statearr_23468_23528 = state_23434__$1;
(statearr_23468_23528[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (3))){
var inst_23432 = (state_23434[(2)]);
var state_23434__$1 = state_23434;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23434__$1,inst_23432);
} else {
if((state_val_23435 === (12))){
var inst_23334 = (state_23434[(14)]);
var state_23434__$1 = state_23434;
if(cljs.core.truth_(inst_23334)){
var statearr_23469_23529 = state_23434__$1;
(statearr_23469_23529[(1)] = (14));

} else {
var statearr_23470_23530 = state_23434__$1;
(statearr_23470_23530[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (2))){
var _ = (function (){var statearr_23471 = state_23434;
(statearr_23471[(4)] = cljs.core.cons((5),(state_23434[(4)])));

return statearr_23471;
})();
var inst_23328 = select_spec;
var inst_23329 = cljs.core.__destructure_map(inst_23328);
var inst_23330 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23329,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_23331 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23329,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23332 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23329,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_23333 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23329,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_23334 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23329,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23335 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_23336 = (inst_23333 > inst_23335);
var state_23434__$1 = (function (){var statearr_23472 = state_23434;
(statearr_23472[(15)] = inst_23330);

(statearr_23472[(14)] = inst_23334);

(statearr_23472[(19)] = inst_23332);

(statearr_23472[(20)] = inst_23331);

return statearr_23472;
})();
if(cljs.core.truth_(inst_23336)){
var statearr_23473_23531 = state_23434__$1;
(statearr_23473_23531[(1)] = (6));

} else {
var statearr_23474_23532 = state_23434__$1;
(statearr_23474_23532[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (23))){
var inst_23353 = (state_23434[(9)]);
var inst_23331 = (state_23434[(20)]);
var inst_23376 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_23331,inst_23353);
var state_23434__$1 = state_23434;
var statearr_23475_23533 = state_23434__$1;
(statearr_23475_23533[(2)] = inst_23376);

(statearr_23475_23533[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (35))){
var inst_23359 = (state_23434[(21)]);
var inst_23409 = (state_23434[(2)]);
var inst_23410 = fluree.db.query.fql.recur_select_spec(select_spec,inst_23359);
var state_23434__$1 = (function (){var statearr_23476 = state_23434;
(statearr_23476[(22)] = inst_23410);

return statearr_23476;
})();
if(cljs.core.truth_(inst_23409)){
var statearr_23477_23534 = state_23434__$1;
(statearr_23477_23534[(1)] = (36));

} else {
var statearr_23478_23535 = state_23434__$1;
(statearr_23478_23535[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (19))){
var inst_23425 = (state_23434[(2)]);
var state_23434__$1 = state_23434;
var statearr_23479_23536 = state_23434__$1;
(statearr_23479_23536[(2)] = inst_23425);

(statearr_23479_23536[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (11))){
var inst_23361 = (state_23434[(23)]);
var state_23434__$1 = state_23434;
var statearr_23481_23537 = state_23434__$1;
(statearr_23481_23537[(2)] = inst_23361);

(statearr_23481_23537[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (9))){
var inst_23351 = (state_23434[(8)]);
var inst_23359 = (state_23434[(21)]);
var inst_23361 = (state_23434[(23)]);
var inst_23358 = cljs.core.seq(inst_23351);
var inst_23359__$1 = cljs.core.first(inst_23358);
var inst_23360 = cljs.core.next(inst_23358);
var inst_23361__$1 = cljs.core.not(inst_23359__$1);
var state_23434__$1 = (function (){var statearr_23482 = state_23434;
(statearr_23482[(21)] = inst_23359__$1);

(statearr_23482[(23)] = inst_23361__$1);

(statearr_23482[(13)] = inst_23360);

return statearr_23482;
})();
if(inst_23361__$1){
var statearr_23483_23538 = state_23434__$1;
(statearr_23483_23538[(1)] = (11));

} else {
var statearr_23484_23539 = state_23434__$1;
(statearr_23484_23539[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (5))){
var _ = (function (){var statearr_23485 = state_23434;
(statearr_23485[(4)] = cljs.core.rest((state_23434[(4)])));

return statearr_23485;
})();
var state_23434__$1 = state_23434;
var ex23480 = (state_23434__$1[(2)]);
var statearr_23486_23540 = state_23434__$1;
(statearr_23486_23540[(5)] = ex23480);


if((ex23480 instanceof Error)){
var statearr_23487_23541 = state_23434__$1;
(statearr_23487_23541[(1)] = (4));

(statearr_23487_23541[(5)] = null);

} else {
throw ex23480;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (14))){
var inst_23334 = (state_23434[(14)]);
var inst_23352 = (state_23434[(11)]);
var inst_23365 = (inst_23352 < inst_23334);
var state_23434__$1 = state_23434;
var statearr_23488_23542 = state_23434__$1;
(statearr_23488_23542[(2)] = inst_23365);

(statearr_23488_23542[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (26))){
var inst_23353 = (state_23434[(9)]);
var inst_23331 = (state_23434[(20)]);
var inst_23379 = cljs.core.first(inst_23353);
var inst_23380 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_23331,inst_23379);
var state_23434__$1 = state_23434;
var statearr_23489_23543 = state_23434__$1;
(statearr_23489_23543[(2)] = inst_23380);

(statearr_23489_23543[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (16))){
var inst_23368 = (state_23434[(2)]);
var state_23434__$1 = state_23434;
var statearr_23490_23544 = state_23434__$1;
(statearr_23490_23544[(2)] = inst_23368);

(statearr_23490_23544[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (38))){
var inst_23423 = (state_23434[(2)]);
var state_23434__$1 = state_23434;
var statearr_23491_23545 = state_23434__$1;
(statearr_23491_23545[(2)] = inst_23423);

(statearr_23491_23545[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (30))){
var inst_23398 = (state_23434[(16)]);
var inst_23400 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_23401 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_23400,inst_23398);
var state_23434__$1 = state_23434;
var statearr_23492_23546 = state_23434__$1;
(statearr_23492_23546[(2)] = inst_23401);

(statearr_23492_23546[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (10))){
var inst_23427 = (state_23434[(2)]);
var state_23434__$1 = state_23434;
var statearr_23493_23547 = state_23434__$1;
(statearr_23493_23547[(2)] = inst_23427);

(statearr_23493_23547[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23435 === (18))){
var inst_23359 = (state_23434[(21)]);
var inst_23332 = (state_23434[(19)]);
var inst_23389 = inst_23359.o;
var inst_23390 = cljs.core.contains_QMARK_(inst_23332,inst_23389);
var inst_23392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23393 = [inst_23389];
var inst_23394 = (new cljs.core.PersistentVector(null,1,(5),inst_23392,inst_23393,null));
var inst_23395 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23394);
var state_23434__$1 = (function (){var statearr_23494 = state_23434;
(statearr_23494[(17)] = inst_23390);

return statearr_23494;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23434__$1,(29),inst_23395);
} else {
if((state_val_23435 === (37))){
var inst_23404 = (state_23434[(18)]);
var inst_23410 = (state_23434[(22)]);
var inst_23352 = (state_23434[(11)]);
var inst_23415 = (inst_23352 + (1));
var inst_23416 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_23410,inst_23404) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23410,inst_23404));
var state_23434__$1 = (function (){var statearr_23495 = state_23434;
(statearr_23495[(12)] = inst_23415);

return statearr_23495;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23434__$1,(39),inst_23416);
} else {
if((state_val_23435 === (8))){
var inst_23429 = (state_23434[(2)]);
var _ = (function (){var statearr_23496 = state_23434;
(statearr_23496[(4)] = cljs.core.rest((state_23434[(4)])));

return statearr_23496;
})();
var state_23434__$1 = state_23434;
var statearr_23497_23548 = state_23434__$1;
(statearr_23497_23548[(2)] = inst_23429);

(statearr_23497_23548[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto____0 = (function (){
var statearr_23498 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23498[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto__);

(statearr_23498[(1)] = (1));

return statearr_23498;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto____1 = (function (state_23434){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23434);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23499){var ex__2730__auto__ = e23499;
var statearr_23500_23549 = state_23434;
(statearr_23500_23549[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23434[(4)]))){
var statearr_23501_23550 = state_23434;
(statearr_23501_23550[(1)] = cljs.core.first((state_23434[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23551 = state_23434;
state_23434 = G__23551;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto__ = function(state_23434){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto____1.call(this,state_23434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23502 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23502[(6)] = c__2749__auto__);

return statearr_23502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23732){
var state_val_23733 = (state_23732[(1)]);
if((state_val_23733 === (7))){
var state_23732__$1 = state_23732;
var statearr_23734_23820 = state_23732__$1;
(statearr_23734_23820[(2)] = null);

(statearr_23734_23820[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (20))){
var inst_23590 = cljs.core.PersistentHashMap.EMPTY;
var state_23732__$1 = state_23732;
var statearr_23735_23821 = state_23732__$1;
(statearr_23735_23821[(2)] = inst_23590);

(statearr_23735_23821[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (27))){
var inst_23608 = (state_23732[(7)]);
var inst_23578 = (state_23732[(8)]);
var inst_23592 = (state_23732[(9)]);
var inst_23572 = (state_23732[(10)]);
var inst_23711 = (state_23732[(2)]);
var inst_23712 = (function (){var top_level_subject = inst_23572;
var select_spec = inst_23578;
var base_acc = inst_23592;
var acc_PLUS_refs = inst_23608;
var result = inst_23711;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4253__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23713 = cljs.core.PersistentVector.EMPTY;
var inst_23714 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23578);
var inst_23715 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23714);
var inst_23716 = cljs.core.vals(inst_23715);
var inst_23717 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23578);
var inst_23718 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23717);
var inst_23719 = cljs.core.vals(inst_23718);
var inst_23720 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_23716,inst_23719);
var inst_23721 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23712,inst_23713,inst_23720);
var inst_23723 = (function (){var top_level_subject = inst_23572;
var select_spec = inst_23578;
var base_acc = inst_23592;
var acc_PLUS_refs = inst_23608;
var result = inst_23711;
var sort_preds = inst_23721;
return (function (acc,p__23722){
var vec__23736 = p__23722;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23736,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23736,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23736,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23736,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_23724 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23723,inst_23711,inst_23721);
var state_23732__$1 = state_23732;
var statearr_23739_23822 = state_23732__$1;
(statearr_23739_23822[(2)] = inst_23724);

(statearr_23739_23822[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (1))){
var state_23732__$1 = state_23732;
var statearr_23740_23823 = state_23732__$1;
(statearr_23740_23823[(2)] = null);

(statearr_23740_23823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (24))){
var inst_23608 = (state_23732[(7)]);
var inst_23608__$1 = (state_23732[(2)]);
var inst_23609 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_23610 = cljs.core.PersistentHashMap.EMPTY;
var inst_23611 = inst_23609;
var inst_23612 = inst_23608__$1;
var inst_23613 = inst_23610;
var state_23732__$1 = (function (){var statearr_23741 = state_23732;
(statearr_23741[(11)] = inst_23613);

(statearr_23741[(7)] = inst_23608__$1);

(statearr_23741[(12)] = inst_23612);

(statearr_23741[(13)] = inst_23611);

return statearr_23741;
})();
var statearr_23742_23824 = state_23732__$1;
(statearr_23742_23824[(2)] = null);

(statearr_23742_23824[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (39))){
var inst_23578 = (state_23732[(8)]);
var inst_23621 = (state_23732[(14)]);
var inst_23628 = (state_23732[(15)]);
var inst_23612 = (state_23732[(12)]);
var inst_23657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23658 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_23612,inst_23578,inst_23621,inst_23628,false);
var state_23732__$1 = (function (){var statearr_23743 = state_23732;
(statearr_23743[(16)] = inst_23657);

return statearr_23743;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23732__$1,(42),inst_23658);
} else {
if((state_val_23733 === (46))){
var inst_23613 = (state_23732[(11)]);
var inst_23621 = (state_23732[(14)]);
var inst_23611 = (state_23732[(13)]);
var inst_23675 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23676 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23677 = cljs.core.first(inst_23621);
var inst_23678 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23677);
var inst_23679 = [inst_23678];
var inst_23680 = cljs.core.PersistentHashMap.fromArrays(inst_23676,inst_23679);
var inst_23681 = cljs.core.rest(inst_23611);
var inst_23682 = [inst_23680,inst_23681,inst_23613];
var inst_23683 = (new cljs.core.PersistentVector(null,3,(5),inst_23675,inst_23682,null));
var state_23732__$1 = state_23732;
var statearr_23744_23825 = state_23732__$1;
(statearr_23744_23825[(2)] = inst_23683);

(statearr_23744_23825[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (4))){
var inst_23552 = (state_23732[(2)]);
var state_23732__$1 = state_23732;
var statearr_23745_23826 = state_23732__$1;
(statearr_23745_23826[(2)] = inst_23552);

(statearr_23745_23826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (15))){
var inst_23578 = (state_23732[(8)]);
var inst_23579 = (state_23732[(17)]);
var inst_23578__$1 = (state_23732[(2)]);
var inst_23579__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23578__$1);
var state_23732__$1 = (function (){var statearr_23746 = state_23732;
(statearr_23746[(8)] = inst_23578__$1);

(statearr_23746[(17)] = inst_23579__$1);

return statearr_23746;
})();
if(cljs.core.truth_(inst_23579__$1)){
var statearr_23747_23827 = state_23732__$1;
(statearr_23747_23827[(1)] = (16));

} else {
var statearr_23748_23828 = state_23732__$1;
(statearr_23748_23828[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (48))){
var inst_23694 = (state_23732[(2)]);
var state_23732__$1 = state_23732;
var statearr_23749_23829 = state_23732__$1;
(statearr_23749_23829[(2)] = inst_23694);

(statearr_23749_23829[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (50))){
var state_23732__$1 = state_23732;
var statearr_23750_23830 = state_23732__$1;
(statearr_23750_23830[(2)] = null);

(statearr_23750_23830[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (21))){
var inst_23578 = (state_23732[(8)]);
var inst_23592 = (state_23732[(2)]);
var inst_23593 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23594 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23595 = (new cljs.core.PersistentVector(null,2,(5),inst_23593,inst_23594,null));
var inst_23596 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23578,inst_23595);
var state_23732__$1 = (function (){var statearr_23751 = state_23732;
(statearr_23751[(9)] = inst_23592);

return statearr_23751;
})();
if(cljs.core.truth_(inst_23596)){
var statearr_23752_23831 = state_23732__$1;
(statearr_23752_23831[(1)] = (22));

} else {
var statearr_23753_23832 = state_23732__$1;
(statearr_23753_23832[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (31))){
var inst_23621 = (state_23732[(14)]);
var inst_23627 = (state_23732[(18)]);
var inst_23612 = (state_23732[(12)]);
var inst_23631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23632 = fluree.db.query.fql.flake__GT_recur(db,inst_23621,inst_23627,inst_23612,fuel,max_fuel,cache);
var state_23732__$1 = (function (){var statearr_23754 = state_23732;
(statearr_23754[(19)] = inst_23631);

return statearr_23754;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23732__$1,(34),inst_23632);
} else {
if((state_val_23733 === (32))){
var inst_23627 = (state_23732[(18)]);
var state_23732__$1 = state_23732;
if(cljs.core.truth_(inst_23627)){
var statearr_23755_23833 = state_23732__$1;
(statearr_23755_23833[(1)] = (35));

} else {
var statearr_23756_23834 = state_23732__$1;
(statearr_23756_23834[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (40))){
var inst_23578 = (state_23732[(8)]);
var inst_23668 = (state_23732[(20)]);
var inst_23667 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23578);
var inst_23668__$1 = cljs.core.empty_QMARK_(inst_23667);
var state_23732__$1 = (function (){var statearr_23757 = state_23732;
(statearr_23757[(20)] = inst_23668__$1);

return statearr_23757;
})();
if(inst_23668__$1){
var statearr_23758_23835 = state_23732__$1;
(statearr_23758_23835[(1)] = (43));

} else {
var statearr_23759_23836 = state_23732__$1;
(statearr_23759_23836[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (33))){
var inst_23621 = (state_23732[(14)]);
var inst_23700 = (state_23732[(2)]);
var inst_23701 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23700,(0),null);
var inst_23702 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23700,(1),null);
var inst_23703 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23700,(2),null);
var inst_23704 = cljs.core.first(inst_23621);
var inst_23705 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23704);
var inst_23706 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23701,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23705);
var inst_23611 = inst_23702;
var inst_23612 = inst_23706;
var inst_23613 = inst_23703;
var state_23732__$1 = (function (){var statearr_23760 = state_23732;
(statearr_23760[(11)] = inst_23613);

(statearr_23760[(12)] = inst_23612);

(statearr_23760[(13)] = inst_23611);

return statearr_23760;
})();
var statearr_23761_23837 = state_23732__$1;
(statearr_23761_23837[(2)] = null);

(statearr_23761_23837[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (13))){
var inst_23572 = (state_23732[(10)]);
var inst_23575 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_23572);
var state_23732__$1 = state_23732;
var statearr_23762_23838 = state_23732__$1;
(statearr_23762_23838[(2)] = inst_23575);

(statearr_23762_23838[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (22))){
var inst_23578 = (state_23732[(8)]);
var inst_23598 = cljs.core.first(flakes);
var inst_23599 = fluree.db.query.fql.s(inst_23598);
var inst_23600 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_23578);
var inst_23601 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_23599,inst_23600);
var state_23732__$1 = state_23732;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23732__$1,(25),inst_23601);
} else {
if((state_val_23733 === (36))){
var inst_23578 = (state_23732[(8)]);
var inst_23655 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23578);
var state_23732__$1 = state_23732;
if(cljs.core.truth_(inst_23655)){
var statearr_23763_23839 = state_23732__$1;
(statearr_23763_23839[(1)] = (39));

} else {
var statearr_23764_23840 = state_23732__$1;
(statearr_23764_23840[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (41))){
var inst_23696 = (state_23732[(2)]);
var state_23732__$1 = state_23732;
var statearr_23765_23841 = state_23732__$1;
(statearr_23765_23841[(2)] = inst_23696);

(statearr_23765_23841[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (43))){
var inst_23578 = (state_23732[(8)]);
var inst_23670 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23578);
var state_23732__$1 = state_23732;
var statearr_23766_23842 = state_23732__$1;
(statearr_23766_23842[(2)] = inst_23670);

(statearr_23766_23842[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (29))){
var inst_23578 = (state_23732[(8)]);
var inst_23621 = (state_23732[(14)]);
var inst_23627 = (state_23732[(18)]);
var inst_23611 = (state_23732[(13)]);
var inst_23621__$1 = cljs.core.first(inst_23611);
var inst_23622 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23623 = cljs.core.first(inst_23621__$1);
var inst_23624 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_23623);
var inst_23625 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23624];
var inst_23626 = (new cljs.core.PersistentVector(null,3,(5),inst_23622,inst_23625,null));
var inst_23627__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23578,inst_23626);
var inst_23628 = fluree.db.query.fql.component_follow_QMARK_(inst_23627__$1,inst_23578);
var inst_23629 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23627__$1);
var state_23732__$1 = (function (){var statearr_23767 = state_23732;
(statearr_23767[(14)] = inst_23621__$1);

(statearr_23767[(15)] = inst_23628);

(statearr_23767[(18)] = inst_23627__$1);

return statearr_23767;
})();
if(cljs.core.truth_(inst_23629)){
var statearr_23768_23843 = state_23732__$1;
(statearr_23768_23843[(1)] = (31));

} else {
var statearr_23769_23844 = state_23732__$1;
(statearr_23769_23844[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (44))){
var inst_23668 = (state_23732[(20)]);
var state_23732__$1 = state_23732;
var statearr_23770_23845 = state_23732__$1;
(statearr_23770_23845[(2)] = inst_23668);

(statearr_23770_23845[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (6))){
var state_23732__$1 = state_23732;
var statearr_23771_23846 = state_23732__$1;
(statearr_23771_23846[(2)] = null);

(statearr_23771_23846[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (28))){
var inst_23612 = (state_23732[(12)]);
var state_23732__$1 = state_23732;
var statearr_23772_23847 = state_23732__$1;
(statearr_23772_23847[(2)] = inst_23612);

(statearr_23772_23847[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (51))){
var inst_23692 = (state_23732[(2)]);
var state_23732__$1 = state_23732;
var statearr_23773_23848 = state_23732__$1;
(statearr_23773_23848[(2)] = inst_23692);

(statearr_23773_23848[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (25))){
var inst_23592 = (state_23732[(9)]);
var inst_23603 = (state_23732[(2)]);
var inst_23604 = fluree.db.util.async.throw_err(inst_23603);
var inst_23605 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23592,inst_23604], 0));
var state_23732__$1 = state_23732;
var statearr_23774_23849 = state_23732__$1;
(statearr_23774_23849[(2)] = inst_23605);

(statearr_23774_23849[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (34))){
var inst_23613 = (state_23732[(11)]);
var inst_23631 = (state_23732[(19)]);
var inst_23611 = (state_23732[(13)]);
var inst_23634 = (state_23732[(2)]);
var inst_23635 = fluree.db.util.async.throw_err(inst_23634);
var inst_23636 = cljs.core.rest(inst_23611);
var inst_23637 = [inst_23635,inst_23636,inst_23613];
var inst_23638 = (new cljs.core.PersistentVector(null,3,(5),inst_23631,inst_23637,null));
var state_23732__$1 = state_23732;
var statearr_23775_23850 = state_23732__$1;
(statearr_23775_23850[(2)] = inst_23638);

(statearr_23775_23850[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (17))){
var inst_23578 = (state_23732[(8)]);
var inst_23582 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23578);
var state_23732__$1 = state_23732;
var statearr_23777_23851 = state_23732__$1;
(statearr_23777_23851[(2)] = inst_23582);

(statearr_23777_23851[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (3))){
var inst_23730 = (state_23732[(2)]);
var state_23732__$1 = state_23732;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23732__$1,inst_23730);
} else {
if((state_val_23733 === (12))){
var _ = (function (){var statearr_23778 = state_23732;
(statearr_23778[(4)] = cljs.core.rest((state_23732[(4)])));

return statearr_23778;
})();
var state_23732__$1 = state_23732;
var ex23776 = (state_23732__$1[(2)]);
var statearr_23779_23852 = state_23732__$1;
(statearr_23779_23852[(5)] = ex23776);


var statearr_23780_23853 = state_23732__$1;
(statearr_23780_23853[(1)] = (11));

(statearr_23780_23853[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (2))){
var _ = (function (){var statearr_23781 = state_23732;
(statearr_23781[(4)] = cljs.core.cons((5),(state_23732[(4)])));

return statearr_23781;
})();
var inst_23558 = cljs.core.not_empty(flakes);
var state_23732__$1 = state_23732;
if(cljs.core.truth_(inst_23558)){
var statearr_23782_23854 = state_23732__$1;
(statearr_23782_23854[(1)] = (6));

} else {
var statearr_23783_23855 = state_23732__$1;
(statearr_23783_23855[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (23))){
var inst_23592 = (state_23732[(9)]);
var state_23732__$1 = state_23732;
var statearr_23784_23856 = state_23732__$1;
(statearr_23784_23856[(2)] = inst_23592);

(statearr_23784_23856[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (47))){
var state_23732__$1 = state_23732;
var statearr_23785_23857 = state_23732__$1;
(statearr_23785_23857[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (35))){
var inst_23613 = (state_23732[(11)]);
var inst_23621 = (state_23732[(14)]);
var inst_23628 = (state_23732[(15)]);
var inst_23627 = (state_23732[(18)]);
var inst_23612 = (state_23732[(12)]);
var inst_23644 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_23612,inst_23627,inst_23621,inst_23628,false,inst_23613);
var state_23732__$1 = state_23732;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23732__$1,(38),inst_23644);
} else {
if((state_val_23733 === (19))){
var inst_23572 = (state_23732[(10)]);
var inst_23586 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23587 = [inst_23572];
var inst_23588 = cljs.core.PersistentHashMap.fromArrays(inst_23586,inst_23587);
var state_23732__$1 = state_23732;
var statearr_23787_23858 = state_23732__$1;
(statearr_23787_23858[(2)] = inst_23588);

(statearr_23787_23858[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (11))){
var inst_23560 = (state_23732[(2)]);
var inst_23561 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23560], 0));
var inst_23562 = (function(){throw inst_23560})();
var state_23732__$1 = (function (){var statearr_23789 = state_23732;
(statearr_23789[(21)] = inst_23561);

return statearr_23789;
})();
var statearr_23790_23859 = state_23732__$1;
(statearr_23790_23859[(2)] = inst_23562);

(statearr_23790_23859[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (9))){
var _ = (function (){var statearr_23791 = state_23732;
(statearr_23791[(4)] = cljs.core.cons((12),(state_23732[(4)])));

return statearr_23791;
})();
var inst_23568 = cljs.core.first(flakes);
var inst_23569 = fluree.db.query.fql.s(inst_23568);
var ___$1 = (function (){var statearr_23792 = state_23732;
(statearr_23792[(4)] = cljs.core.rest((state_23732[(4)])));

return statearr_23792;
})();
var state_23732__$1 = state_23732;
var statearr_23793_23860 = state_23732__$1;
(statearr_23793_23860[(2)] = inst_23569);

(statearr_23793_23860[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (5))){
var _ = (function (){var statearr_23794 = state_23732;
(statearr_23794[(4)] = cljs.core.rest((state_23732[(4)])));

return statearr_23794;
})();
var state_23732__$1 = state_23732;
var ex23788 = (state_23732__$1[(2)]);
var statearr_23795_23861 = state_23732__$1;
(statearr_23795_23861[(5)] = ex23788);


if((ex23788 instanceof Error)){
var statearr_23796_23862 = state_23732__$1;
(statearr_23796_23862[(1)] = (4));

(statearr_23796_23862[(5)] = null);

} else {
throw ex23788;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (14))){
var state_23732__$1 = state_23732;
var statearr_23797_23863 = state_23732__$1;
(statearr_23797_23863[(2)] = base_select_spec);

(statearr_23797_23863[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (45))){
var inst_23673 = (state_23732[(2)]);
var state_23732__$1 = state_23732;
if(cljs.core.truth_(inst_23673)){
var statearr_23798_23864 = state_23732__$1;
(statearr_23798_23864[(1)] = (46));

} else {
var statearr_23799_23865 = state_23732__$1;
(statearr_23799_23865[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (26))){
var inst_23611 = (state_23732[(13)]);
var inst_23615 = cljs.core.empty_QMARK_(inst_23611);
var state_23732__$1 = state_23732;
if(inst_23615){
var statearr_23800_23866 = state_23732__$1;
(statearr_23800_23866[(1)] = (28));

} else {
var statearr_23801_23867 = state_23732__$1;
(statearr_23801_23867[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (16))){
var inst_23579 = (state_23732[(17)]);
var state_23732__$1 = state_23732;
var statearr_23802_23868 = state_23732__$1;
(statearr_23802_23868[(2)] = inst_23579);

(statearr_23802_23868[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (38))){
var inst_23611 = (state_23732[(13)]);
var inst_23646 = (state_23732[(2)]);
var inst_23647 = fluree.db.util.async.throw_err(inst_23646);
var inst_23648 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23647,(0),null);
var inst_23649 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23647,(1),null);
var inst_23650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23651 = cljs.core.rest(inst_23611);
var inst_23652 = [inst_23648,inst_23651,inst_23649];
var inst_23653 = (new cljs.core.PersistentVector(null,3,(5),inst_23650,inst_23652,null));
var state_23732__$1 = state_23732;
var statearr_23803_23869 = state_23732__$1;
(statearr_23803_23869[(2)] = inst_23653);

(statearr_23803_23869[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (30))){
var inst_23709 = (state_23732[(2)]);
var state_23732__$1 = state_23732;
var statearr_23804_23870 = state_23732__$1;
(statearr_23804_23870[(2)] = inst_23709);

(statearr_23804_23870[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (10))){
var inst_23572 = (state_23732[(2)]);
var inst_23573 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_23732__$1 = (function (){var statearr_23805 = state_23732;
(statearr_23805[(10)] = inst_23572);

return statearr_23805;
})();
if(cljs.core.truth_(inst_23573)){
var statearr_23806_23871 = state_23732__$1;
(statearr_23806_23871[(1)] = (13));

} else {
var statearr_23807_23872 = state_23732__$1;
(statearr_23807_23872[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (18))){
var inst_23584 = (state_23732[(2)]);
var state_23732__$1 = state_23732;
if(cljs.core.truth_(inst_23584)){
var statearr_23808_23873 = state_23732__$1;
(statearr_23808_23873[(1)] = (19));

} else {
var statearr_23809_23874 = state_23732__$1;
(statearr_23809_23874[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (42))){
var inst_23613 = (state_23732[(11)]);
var inst_23657 = (state_23732[(16)]);
var inst_23611 = (state_23732[(13)]);
var inst_23660 = (state_23732[(2)]);
var inst_23661 = fluree.db.util.async.throw_err(inst_23660);
var inst_23662 = cljs.core.first(inst_23661);
var inst_23663 = cljs.core.rest(inst_23611);
var inst_23664 = [inst_23662,inst_23663,inst_23613];
var inst_23665 = (new cljs.core.PersistentVector(null,3,(5),inst_23657,inst_23664,null));
var state_23732__$1 = state_23732;
var statearr_23810_23875 = state_23732__$1;
(statearr_23810_23875[(2)] = inst_23665);

(statearr_23810_23875[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (37))){
var inst_23698 = (state_23732[(2)]);
var state_23732__$1 = state_23732;
var statearr_23811_23876 = state_23732__$1;
(statearr_23811_23876[(2)] = inst_23698);

(statearr_23811_23876[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (8))){
var inst_23727 = (state_23732[(2)]);
var _ = (function (){var statearr_23812 = state_23732;
(statearr_23812[(4)] = cljs.core.rest((state_23732[(4)])));

return statearr_23812;
})();
var state_23732__$1 = state_23732;
var statearr_23813_23877 = state_23732__$1;
(statearr_23813_23877[(2)] = inst_23727);

(statearr_23813_23877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23733 === (49))){
var inst_23613 = (state_23732[(11)]);
var inst_23612 = (state_23732[(12)]);
var inst_23611 = (state_23732[(13)]);
var inst_23686 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23687 = cljs.core.rest(inst_23611);
var inst_23688 = [inst_23612,inst_23687,inst_23613];
var inst_23689 = (new cljs.core.PersistentVector(null,3,(5),inst_23686,inst_23688,null));
var state_23732__$1 = state_23732;
var statearr_23814_23878 = state_23732__$1;
(statearr_23814_23878[(2)] = inst_23689);

(statearr_23814_23878[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto____0 = (function (){
var statearr_23815 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23815[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto__);

(statearr_23815[(1)] = (1));

return statearr_23815;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto____1 = (function (state_23732){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23732);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23816){var ex__2730__auto__ = e23816;
var statearr_23817_23879 = state_23732;
(statearr_23817_23879[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23732[(4)]))){
var statearr_23818_23880 = state_23732;
(statearr_23818_23880[(1)] = cljs.core.first((state_23732[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23881 = state_23732;
state_23732 = G__23881;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto__ = function(state_23732){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto____1.call(this,state_23732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23819 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23819[(6)] = c__2749__auto__);

return statearr_23819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__23884 = arguments.length;
switch (G__23884) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23926){
var state_val_23927 = (state_23926[(1)]);
if((state_val_23927 === (7))){
var inst_23892 = (state_23926[(7)]);
var state_23926__$1 = state_23926;
var statearr_23928_23958 = state_23926__$1;
(statearr_23928_23958[(2)] = inst_23892);

(statearr_23928_23958[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23927 === (1))){
var state_23926__$1 = state_23926;
var statearr_23929_23959 = state_23926__$1;
(statearr_23929_23959[(2)] = null);

(statearr_23929_23959[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23927 === (4))){
var inst_23885 = (state_23926[(2)]);
var state_23926__$1 = state_23926;
var statearr_23930_23960 = state_23926__$1;
(statearr_23930_23960[(2)] = inst_23885);

(statearr_23930_23960[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23927 === (15))){
var inst_23920 = (state_23926[(2)]);
var inst_23921 = fluree.db.util.async.throw_err(inst_23920);
var _ = (function (){var statearr_23931 = state_23926;
(statearr_23931[(4)] = cljs.core.rest((state_23926[(4)])));

return statearr_23931;
})();
var state_23926__$1 = state_23926;
var statearr_23932_23961 = state_23926__$1;
(statearr_23932_23961[(2)] = inst_23921);

(statearr_23932_23961[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23927 === (13))){
var inst_23904 = (state_23926[(8)]);
var state_23926__$1 = state_23926;
var statearr_23933_23962 = state_23926__$1;
(statearr_23933_23962[(2)] = inst_23904);

(statearr_23933_23962[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23927 === (6))){
var inst_23892 = (state_23926[(7)]);
var inst_23894 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_23895 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23892,inst_23894);
var state_23926__$1 = state_23926;
var statearr_23934_23963 = state_23926__$1;
(statearr_23934_23963[(2)] = inst_23895);

(statearr_23934_23963[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23927 === (3))){
var inst_23924 = (state_23926[(2)]);
var state_23926__$1 = state_23926;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23926__$1,inst_23924);
} else {
if((state_val_23927 === (12))){
var inst_23904 = (state_23926[(8)]);
var inst_23906 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_23907 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23904,inst_23906);
var state_23926__$1 = state_23926;
var statearr_23935_23964 = state_23926__$1;
(statearr_23935_23964[(2)] = inst_23907);

(statearr_23935_23964[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23927 === (2))){
var _ = (function (){var statearr_23936 = state_23926;
(statearr_23936[(4)] = cljs.core.cons((5),(state_23926[(4)])));

return statearr_23936;
})();
var inst_23892 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_23926__$1 = (function (){var statearr_23937 = state_23926;
(statearr_23937[(7)] = inst_23892);

return statearr_23937;
})();
if(cljs.core.truth_(fuel)){
var statearr_23938_23965 = state_23926__$1;
(statearr_23938_23965[(1)] = (6));

} else {
var statearr_23939_23966 = state_23926__$1;
(statearr_23939_23966[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23927 === (11))){
var inst_23904 = (state_23926[(2)]);
var state_23926__$1 = (function (){var statearr_23941 = state_23926;
(statearr_23941[(8)] = inst_23904);

return statearr_23941;
})();
if(cljs.core.truth_(limit)){
var statearr_23942_23967 = state_23926__$1;
(statearr_23942_23967[(1)] = (12));

} else {
var statearr_23943_23968 = state_23926__$1;
(statearr_23943_23968[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23927 === (9))){
var inst_23898 = (state_23926[(9)]);
var inst_23900 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_23901 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23898,inst_23900);
var state_23926__$1 = state_23926;
var statearr_23944_23969 = state_23926__$1;
(statearr_23944_23969[(2)] = inst_23901);

(statearr_23944_23969[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23927 === (5))){
var _ = (function (){var statearr_23945 = state_23926;
(statearr_23945[(4)] = cljs.core.rest((state_23926[(4)])));

return statearr_23945;
})();
var state_23926__$1 = state_23926;
var ex23940 = (state_23926__$1[(2)]);
var statearr_23946_23970 = state_23926__$1;
(statearr_23946_23970[(5)] = ex23940);


if((ex23940 instanceof Error)){
var statearr_23947_23971 = state_23926__$1;
(statearr_23947_23971[(1)] = (4));

(statearr_23947_23971[(5)] = null);

} else {
throw ex23940;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23927 === (14))){
var inst_23910 = (state_23926[(2)]);
var inst_23911 = (function (){return (function (x){
var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4251__auto__;
}
});
})();
var inst_23912 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_23911);
var inst_23913 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23910,inst_23912);
var inst_23914 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_23913,flakes);
var inst_23915 = cljs.core.PersistentVector.EMPTY;
var inst_23916 = (function (){var xf = inst_23913;
var flakes_by_sub = inst_23914;
return (function (p1__23882_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__23882_SHARP_);
});
})();
var inst_23917 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_23916,inst_23914);
var inst_23918 = fluree.db.util.async.merge_into_QMARK_(inst_23915,inst_23917);
var state_23926__$1 = state_23926;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23926__$1,(15),inst_23918);
} else {
if((state_val_23927 === (10))){
var inst_23898 = (state_23926[(9)]);
var state_23926__$1 = state_23926;
var statearr_23948_23972 = state_23926__$1;
(statearr_23948_23972[(2)] = inst_23898);

(statearr_23948_23972[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23927 === (8))){
var inst_23898 = (state_23926[(2)]);
var state_23926__$1 = (function (){var statearr_23949 = state_23926;
(statearr_23949[(9)] = inst_23898);

return statearr_23949;
})();
if(cljs.core.truth_(offset)){
var statearr_23950_23973 = state_23926__$1;
(statearr_23950_23973[(1)] = (9));

} else {
var statearr_23951_23974 = state_23926__$1;
(statearr_23951_23974[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2727__auto__ = null;
var fluree$db$query$fql$state_machine__2727__auto____0 = (function (){
var statearr_23952 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23952[(0)] = fluree$db$query$fql$state_machine__2727__auto__);

(statearr_23952[(1)] = (1));

return statearr_23952;
});
var fluree$db$query$fql$state_machine__2727__auto____1 = (function (state_23926){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23926);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23953){var ex__2730__auto__ = e23953;
var statearr_23954_23975 = state_23926;
(statearr_23954_23975[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23926[(4)]))){
var statearr_23955_23976 = state_23926;
(statearr_23955_23976[(1)] = cljs.core.first((state_23926[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23977 = state_23926;
state_23926 = G__23977;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2727__auto__ = function(state_23926){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2727__auto____1.call(this,state_23926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2727__auto____0;
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2727__auto____1;
return fluree$db$query$fql$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23956 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23956[(6)] = c__2749__auto__);

return statearr_23956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__23979 = arguments.length;
switch (G__23979) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24065){
var state_val_24066 = (state_24065[(1)]);
if((state_val_24066 === (7))){
var inst_24060 = (state_24065[(2)]);
var _ = (function (){var statearr_24068 = state_24065;
(statearr_24068[(4)] = cljs.core.rest((state_24065[(4)])));

return statearr_24068;
})();
var state_24065__$1 = state_24065;
var statearr_24069_24121 = state_24065__$1;
(statearr_24069_24121[(2)] = inst_24060);

(statearr_24069_24121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (20))){
var inst_24000 = (state_24065[(7)]);
var inst_24007 = (state_24065[(8)]);
var inst_23999 = (state_24065[(9)]);
var inst_24028 = (inst_23999 + (1));
var tmp24067 = inst_24000;
var inst_23998 = inst_24007;
var inst_23999__$1 = inst_24028;
var inst_24000__$1 = tmp24067;
var state_24065__$1 = (function (){var statearr_24070 = state_24065;
(statearr_24070[(10)] = inst_23998);

(statearr_24070[(7)] = inst_24000__$1);

(statearr_24070[(9)] = inst_23999__$1);

return statearr_24070;
})();
var statearr_24071_24122 = state_24065__$1;
(statearr_24071_24122[(2)] = null);

(statearr_24071_24122[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (27))){
var inst_24038 = (state_24065[(11)]);
var inst_24040 = cljs.core.count(inst_24038);
var inst_24041 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_24040);
var state_24065__$1 = state_24065;
var statearr_24072_24123 = state_24065__$1;
(statearr_24072_24123[(2)] = inst_24041);

(statearr_24072_24123[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (1))){
var state_24065__$1 = state_24065;
var statearr_24073_24124 = state_24065__$1;
(statearr_24073_24124[(2)] = null);

(statearr_24073_24124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (24))){
var state_24065__$1 = state_24065;
var statearr_24074_24125 = state_24065__$1;
(statearr_24074_24125[(2)] = null);

(statearr_24074_24125[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (4))){
var inst_23980 = (state_24065[(2)]);
var state_24065__$1 = state_24065;
var statearr_24075_24126 = state_24065__$1;
(statearr_24075_24126[(2)] = inst_23980);

(statearr_24075_24126[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (15))){
var inst_24021 = (state_24065[(12)]);
var inst_24021__$1 = offset;
var state_24065__$1 = (function (){var statearr_24076 = state_24065;
(statearr_24076[(12)] = inst_24021__$1);

return statearr_24076;
})();
if(cljs.core.truth_(inst_24021__$1)){
var statearr_24077_24127 = state_24065__$1;
(statearr_24077_24127[(1)] = (17));

} else {
var statearr_24078_24128 = state_24065__$1;
(statearr_24078_24128[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (21))){
var state_24065__$1 = state_24065;
var statearr_24079_24129 = state_24065__$1;
(statearr_24079_24129[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (13))){
var inst_24016 = (state_24065[(2)]);
var state_24065__$1 = state_24065;
var statearr_24081_24130 = state_24065__$1;
(statearr_24081_24130[(2)] = inst_24016);

(statearr_24081_24130[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (22))){
var inst_24056 = (state_24065[(2)]);
var state_24065__$1 = state_24065;
var statearr_24082_24131 = state_24065__$1;
(statearr_24082_24131[(2)] = inst_24056);

(statearr_24082_24131[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (29))){
var inst_24038 = (state_24065[(11)]);
var inst_23999 = (state_24065[(9)]);
var inst_24044 = (state_24065[(2)]);
var inst_24045 = (inst_23999 + (1));
var inst_24046 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,inst_24038);
var state_24065__$1 = (function (){var statearr_24083 = state_24065;
(statearr_24083[(13)] = inst_24044);

(statearr_24083[(14)] = inst_24045);

return statearr_24083;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24065__$1,(30),inst_24046);
} else {
if((state_val_24066 === (6))){
var inst_24008 = (state_24065[(15)]);
var inst_23998 = (state_24065[(10)]);
var inst_24006 = (state_24065[(16)]);
var inst_24005 = cljs.core.seq(inst_23998);
var inst_24006__$1 = cljs.core.first(inst_24005);
var inst_24007 = cljs.core.next(inst_24005);
var inst_24008__$1 = (inst_24006__$1 == null);
var state_24065__$1 = (function (){var statearr_24084 = state_24065;
(statearr_24084[(15)] = inst_24008__$1);

(statearr_24084[(16)] = inst_24006__$1);

(statearr_24084[(8)] = inst_24007);

return statearr_24084;
})();
if(cljs.core.truth_(inst_24008__$1)){
var statearr_24085_24132 = state_24065__$1;
(statearr_24085_24132[(1)] = (8));

} else {
var statearr_24086_24133 = state_24065__$1;
(statearr_24086_24133[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (28))){
var state_24065__$1 = state_24065;
var statearr_24087_24134 = state_24065__$1;
(statearr_24087_24134[(2)] = null);

(statearr_24087_24134[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (25))){
var inst_24054 = (state_24065[(2)]);
var state_24065__$1 = state_24065;
var statearr_24088_24135 = state_24065__$1;
(statearr_24088_24135[(2)] = inst_24054);

(statearr_24088_24135[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (17))){
var inst_23999 = (state_24065[(9)]);
var inst_24023 = (inst_23999 < offset);
var state_24065__$1 = state_24065;
var statearr_24089_24136 = state_24065__$1;
(statearr_24089_24136[(2)] = inst_24023);

(statearr_24089_24136[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (3))){
var inst_24063 = (state_24065[(2)]);
var state_24065__$1 = state_24065;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24065__$1,inst_24063);
} else {
if((state_val_24066 === (12))){
var inst_24011 = (state_24065[(17)]);
var state_24065__$1 = state_24065;
var statearr_24090_24137 = state_24065__$1;
(statearr_24090_24137[(2)] = inst_24011);

(statearr_24090_24137[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (2))){
var _ = (function (){var statearr_24091 = state_24065;
(statearr_24091[(4)] = cljs.core.cons((5),(state_24065[(4)])));

return statearr_24091;
})();
var inst_23993 = subjects;
var inst_23994 = cljs.core.seq(inst_23993);
var inst_23995 = cljs.core.first(inst_23994);
var inst_23996 = cljs.core.next(inst_23994);
var inst_23997 = cljs.core.PersistentVector.EMPTY;
var inst_23998 = inst_23993;
var inst_23999 = (0);
var inst_24000 = inst_23997;
var state_24065__$1 = (function (){var statearr_24092 = state_24065;
(statearr_24092[(10)] = inst_23998);

(statearr_24092[(7)] = inst_24000);

(statearr_24092[(18)] = inst_23996);

(statearr_24092[(9)] = inst_23999);

(statearr_24092[(19)] = inst_23995);

return statearr_24092;
})();
var statearr_24093_24138 = state_24065__$1;
(statearr_24093_24138[(2)] = null);

(statearr_24093_24138[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (23))){
var inst_24006 = (state_24065[(16)]);
var inst_24032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24033 = [inst_24006];
var inst_24034 = (new cljs.core.PersistentVector(null,1,(5),inst_24032,inst_24033,null));
var inst_24035 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_24034);
var state_24065__$1 = state_24065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24065__$1,(26),inst_24035);
} else {
if((state_val_24066 === (19))){
var inst_24026 = (state_24065[(2)]);
var state_24065__$1 = state_24065;
if(cljs.core.truth_(inst_24026)){
var statearr_24094_24139 = state_24065__$1;
(statearr_24094_24139[(1)] = (20));

} else {
var statearr_24095_24140 = state_24065__$1;
(statearr_24095_24140[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (11))){
var inst_23999 = (state_24065[(9)]);
var inst_24013 = (inst_23999 > limit);
var state_24065__$1 = state_24065;
var statearr_24097_24141 = state_24065__$1;
(statearr_24097_24141[(2)] = inst_24013);

(statearr_24097_24141[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (9))){
var inst_24011 = (state_24065[(17)]);
var inst_24011__$1 = limit;
var state_24065__$1 = (function (){var statearr_24098 = state_24065;
(statearr_24098[(17)] = inst_24011__$1);

return statearr_24098;
})();
if(cljs.core.truth_(inst_24011__$1)){
var statearr_24099_24142 = state_24065__$1;
(statearr_24099_24142[(1)] = (11));

} else {
var statearr_24100_24143 = state_24065__$1;
(statearr_24100_24143[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (5))){
var _ = (function (){var statearr_24101 = state_24065;
(statearr_24101[(4)] = cljs.core.rest((state_24065[(4)])));

return statearr_24101;
})();
var state_24065__$1 = state_24065;
var ex24096 = (state_24065__$1[(2)]);
var statearr_24102_24144 = state_24065__$1;
(statearr_24102_24144[(5)] = ex24096);


if((ex24096 instanceof Error)){
var statearr_24103_24145 = state_24065__$1;
(statearr_24103_24145[(1)] = (4));

(statearr_24103_24145[(5)] = null);

} else {
throw ex24096;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (14))){
var inst_24000 = (state_24065[(7)]);
var state_24065__$1 = state_24065;
var statearr_24104_24146 = state_24065__$1;
(statearr_24104_24146[(2)] = inst_24000);

(statearr_24104_24146[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (26))){
var inst_24037 = (state_24065[(2)]);
var inst_24038 = fluree.db.util.async.throw_err(inst_24037);
var state_24065__$1 = (function (){var statearr_24105 = state_24065;
(statearr_24105[(11)] = inst_24038);

return statearr_24105;
})();
if(cljs.core.truth_(fuel)){
var statearr_24106_24147 = state_24065__$1;
(statearr_24106_24147[(1)] = (27));

} else {
var statearr_24107_24148 = state_24065__$1;
(statearr_24107_24148[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (16))){
var inst_24058 = (state_24065[(2)]);
var state_24065__$1 = state_24065;
var statearr_24108_24149 = state_24065__$1;
(statearr_24108_24149[(2)] = inst_24058);

(statearr_24108_24149[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (30))){
var inst_24000 = (state_24065[(7)]);
var inst_24045 = (state_24065[(14)]);
var inst_24007 = (state_24065[(8)]);
var inst_24048 = (state_24065[(2)]);
var inst_24049 = fluree.db.util.async.throw_err(inst_24048);
var inst_24050 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24000,inst_24049);
var inst_23998 = inst_24007;
var inst_23999 = inst_24045;
var inst_24000__$1 = inst_24050;
var state_24065__$1 = (function (){var statearr_24109 = state_24065;
(statearr_24109[(10)] = inst_23998);

(statearr_24109[(7)] = inst_24000__$1);

(statearr_24109[(9)] = inst_23999);

return statearr_24109;
})();
var statearr_24110_24150 = state_24065__$1;
(statearr_24110_24150[(2)] = null);

(statearr_24110_24150[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (10))){
var inst_24018 = (state_24065[(2)]);
var state_24065__$1 = state_24065;
if(cljs.core.truth_(inst_24018)){
var statearr_24111_24151 = state_24065__$1;
(statearr_24111_24151[(1)] = (14));

} else {
var statearr_24112_24152 = state_24065__$1;
(statearr_24112_24152[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (18))){
var inst_24021 = (state_24065[(12)]);
var state_24065__$1 = state_24065;
var statearr_24113_24153 = state_24065__$1;
(statearr_24113_24153[(2)] = inst_24021);

(statearr_24113_24153[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (8))){
var inst_24008 = (state_24065[(15)]);
var state_24065__$1 = state_24065;
var statearr_24114_24154 = state_24065__$1;
(statearr_24114_24154[(2)] = inst_24008);

(statearr_24114_24154[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2727__auto__ = null;
var fluree$db$query$fql$state_machine__2727__auto____0 = (function (){
var statearr_24115 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24115[(0)] = fluree$db$query$fql$state_machine__2727__auto__);

(statearr_24115[(1)] = (1));

return statearr_24115;
});
var fluree$db$query$fql$state_machine__2727__auto____1 = (function (state_24065){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24065);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24116){var ex__2730__auto__ = e24116;
var statearr_24117_24155 = state_24065;
(statearr_24117_24155[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24065[(4)]))){
var statearr_24118_24156 = state_24065;
(statearr_24118_24156[(1)] = cljs.core.first((state_24065[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24157 = state_24065;
state_24065 = G__24157;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2727__auto__ = function(state_24065){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2727__auto____1.call(this,state_24065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2727__auto____0;
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2727__auto____1;
return fluree$db$query$fql$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24119 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24119[(6)] = c__2749__auto__);

return statearr_24119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4253__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__24159 = arguments.length;
switch (G__24159) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where_clause,null,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4 = (function (db,where_clause,default_collection,p__24160){
var map__24161 = p__24160;
var map__24161__$1 = cljs.core.__destructure_map(map__24161);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24161__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24161__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24425){
var state_val_24426 = (state_24425[(1)]);
if((state_val_24426 === (65))){
var inst_24388 = (state_24425[(7)]);
var inst_24388__$1 = (state_24425[(2)]);
var state_24425__$1 = (function (){var statearr_24427 = state_24425;
(statearr_24427[(7)] = inst_24388__$1);

return statearr_24427;
})();
if(cljs.core.truth_(inst_24388__$1)){
var statearr_24428_24546 = state_24425__$1;
(statearr_24428_24546[(1)] = (66));

} else {
var statearr_24429_24547 = state_24425__$1;
(statearr_24429_24547[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (70))){
var inst_24391 = (state_24425[(8)]);
var state_24425__$1 = state_24425;
var statearr_24430_24548 = state_24425__$1;
(statearr_24430_24548[(2)] = inst_24391);

(statearr_24430_24548[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (62))){
var inst_24379 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
var statearr_24431_24549 = state_24425__$1;
(statearr_24431_24549[(2)] = inst_24379);

(statearr_24431_24549[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (74))){
var inst_24398 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
var statearr_24432_24550 = state_24425__$1;
(statearr_24432_24550[(2)] = inst_24398);

(statearr_24432_24550[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (7))){
var inst_24174 = (state_24425[(9)]);
var state_24425__$1 = state_24425;
var statearr_24433_24551 = state_24425__$1;
(statearr_24433_24551[(2)] = inst_24174);

(statearr_24433_24551[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (59))){
var inst_24203 = (state_24425[(10)]);
var inst_24371 = cljs.core.empty_QMARK_(inst_24203);
var state_24425__$1 = state_24425;
if(inst_24371){
var statearr_24434_24552 = state_24425__$1;
(statearr_24434_24552[(1)] = (60));

} else {
var statearr_24435_24553 = state_24425__$1;
(statearr_24435_24553[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (20))){
var state_24425__$1 = state_24425;
if(cljs.core.truth_(offset)){
var statearr_24436_24554 = state_24425__$1;
(statearr_24436_24554[(1)] = (23));

} else {
var statearr_24437_24555 = state_24425__$1;
(statearr_24437_24555[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (72))){
var inst_24188 = (state_24425[(11)]);
var inst_24368 = (state_24425[(12)]);
var inst_24394 = cljs.core.count(inst_24368);
var inst_24395 = (inst_24394 > inst_24188);
var state_24425__$1 = state_24425;
var statearr_24438_24556 = state_24425__$1;
(statearr_24438_24556[(2)] = inst_24395);

(statearr_24438_24556[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (58))){
var inst_24203 = (state_24425[(10)]);
var inst_24368 = (state_24425[(12)]);
var inst_24369 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24203,inst_24368);
var state_24425__$1 = state_24425;
var statearr_24439_24557 = state_24425__$1;
(statearr_24439_24557[(2)] = inst_24369);

(statearr_24439_24557[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (60))){
var inst_24203 = (state_24425[(10)]);
var inst_24368 = (state_24425[(12)]);
var inst_24373 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24203,inst_24368);
var state_24425__$1 = state_24425;
var statearr_24440_24558 = state_24425__$1;
(statearr_24440_24558[(2)] = inst_24373);

(statearr_24440_24558[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (27))){
var inst_24218 = (state_24425[(13)]);
var state_24425__$1 = state_24425;
var statearr_24441_24559 = state_24425__$1;
(statearr_24441_24559[(2)] = inst_24218);

(statearr_24441_24559[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (1))){
var state_24425__$1 = state_24425;
var statearr_24442_24560 = state_24425__$1;
(statearr_24442_24560[(2)] = null);

(statearr_24442_24560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (69))){
var inst_24188 = (state_24425[(11)]);
var state_24425__$1 = state_24425;
if(cljs.core.truth_(inst_24188)){
var statearr_24443_24561 = state_24425__$1;
(statearr_24443_24561[(1)] = (72));

} else {
var statearr_24444_24562 = state_24425__$1;
(statearr_24444_24562[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (24))){
var inst_24203 = (state_24425[(10)]);
var state_24425__$1 = state_24425;
var statearr_24445_24563 = state_24425__$1;
(statearr_24445_24563[(2)] = inst_24203);

(statearr_24445_24563[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (55))){
var inst_24357 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
var statearr_24446_24564 = state_24425__$1;
(statearr_24446_24564[(2)] = inst_24357);

(statearr_24446_24564[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (39))){
var inst_24365 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
var statearr_24447_24565 = state_24425__$1;
(statearr_24447_24565[(2)] = inst_24365);

(statearr_24447_24565[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (46))){
var inst_24247 = (state_24425[(14)]);
var inst_24229 = (state_24425[(15)]);
var inst_24323 = (inst_24247.cljs$core$IFn$_invoke$arity$2 ? inst_24247.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_24229) : inst_24247.call(null,cljs.core._LT_,inst_24229));
var state_24425__$1 = state_24425;
if(cljs.core.truth_(inst_24323)){
var statearr_24448_24566 = state_24425__$1;
(statearr_24448_24566[(1)] = (49));

} else {
var statearr_24449_24567 = state_24425__$1;
(statearr_24449_24567[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (4))){
var inst_24162 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
var statearr_24450_24568 = state_24425__$1;
(statearr_24450_24568[(2)] = inst_24162);

(statearr_24450_24568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (77))){
var inst_24413 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
var statearr_24451_24569 = state_24425__$1;
(statearr_24451_24569[(2)] = inst_24413);

(statearr_24451_24569[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (54))){
var inst_24355 = cljs.core.PersistentVector.EMPTY;
var state_24425__$1 = state_24425;
var statearr_24452_24570 = state_24425__$1;
(statearr_24452_24570[(2)] = inst_24355);

(statearr_24452_24570[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (15))){
var inst_24173 = (state_24425[(16)]);
var inst_24198 = cljs.core.seq(inst_24173);
var inst_24199 = cljs.core.first(inst_24198);
var inst_24200 = cljs.core.next(inst_24198);
var inst_24201 = cljs.core.PersistentHashSet.EMPTY;
var inst_24202 = inst_24173;
var inst_24203 = inst_24201;
var state_24425__$1 = (function (){var statearr_24453 = state_24425;
(statearr_24453[(10)] = inst_24203);

(statearr_24453[(17)] = inst_24202);

(statearr_24453[(18)] = inst_24200);

(statearr_24453[(19)] = inst_24199);

return statearr_24453;
})();
var statearr_24454_24571 = state_24425__$1;
(statearr_24454_24571[(2)] = null);

(statearr_24454_24571[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (48))){
var inst_24320 = (state_24425[(2)]);
var inst_24321 = fluree.db.util.async.throw_err(inst_24320);
var state_24425__$1 = state_24425;
var statearr_24455_24572 = state_24425__$1;
(statearr_24455_24572[(2)] = inst_24321);

(statearr_24455_24572[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (50))){
var inst_24247 = (state_24425[(14)]);
var inst_24229 = (state_24425[(15)]);
var inst_24339 = (inst_24247.cljs$core$IFn$_invoke$arity$2 ? inst_24247.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_24229) : inst_24247.call(null,cljs.core._LT__EQ_,inst_24229));
var state_24425__$1 = state_24425;
if(cljs.core.truth_(inst_24339)){
var statearr_24456_24573 = state_24425__$1;
(statearr_24456_24573[(1)] = (53));

} else {
var statearr_24457_24574 = state_24425__$1;
(statearr_24457_24574[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (75))){
var state_24425__$1 = state_24425;
if(cljs.core.truth_(offset)){
var statearr_24458_24575 = state_24425__$1;
(statearr_24458_24575[(1)] = (78));

} else {
var statearr_24459_24576 = state_24425__$1;
(statearr_24459_24576[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (21))){
var inst_24209 = (state_24425[(20)]);
var inst_24228 = (state_24425[(21)]);
var inst_24228__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24209,(0),null);
var inst_24229 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24209,(1),null);
var inst_24230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24209,(2),null);
var inst_24231 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_24228__$1);
var inst_24232 = cljs.core.not(inst_24231);
var state_24425__$1 = (function (){var statearr_24460 = state_24425;
(statearr_24460[(21)] = inst_24228__$1);

(statearr_24460[(22)] = inst_24230);

(statearr_24460[(15)] = inst_24229);

return statearr_24460;
})();
if(inst_24232){
var statearr_24461_24577 = state_24425__$1;
(statearr_24461_24577[(1)] = (29));

} else {
var statearr_24462_24578 = state_24425__$1;
(statearr_24462_24578[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (31))){
var inst_24247 = (state_24425[(14)]);
var inst_24229 = (state_24425[(15)]);
var inst_24243 = (state_24425[(2)]);
var inst_24247__$1 = cljs.core.identical_QMARK_;
var inst_24248 = (inst_24247__$1.cljs$core$IFn$_invoke$arity$2 ? inst_24247__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_24229) : inst_24247__$1.call(null,cljs.core.not_EQ_,inst_24229));
var state_24425__$1 = (function (){var statearr_24463 = state_24425;
(statearr_24463[(23)] = inst_24243);

(statearr_24463[(14)] = inst_24247__$1);

return statearr_24463;
})();
if(cljs.core.truth_(inst_24248)){
var statearr_24464_24579 = state_24425__$1;
(statearr_24464_24579[(1)] = (32));

} else {
var statearr_24465_24580 = state_24425__$1;
(statearr_24465_24580[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (32))){
var inst_24228 = (state_24425[(21)]);
var inst_24188 = (state_24425[(11)]);
var inst_24230 = (state_24425[(22)]);
var inst_24250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24251 = [inst_24228,inst_24230];
var inst_24252 = (new cljs.core.PersistentVector(null,2,(5),inst_24250,inst_24251,null));
var inst_24253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24254 = [inst_24228];
var inst_24255 = (new cljs.core.PersistentVector(null,1,(5),inst_24253,inst_24254,null));
var inst_24256 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24257 = [inst_24188];
var inst_24258 = cljs.core.PersistentHashMap.fromArrays(inst_24256,inst_24257);
var inst_24259 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24252,cljs.core._LT__EQ_,inst_24255,inst_24258);
var state_24425__$1 = state_24425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24425__$1,(35),inst_24259);
} else {
if((state_val_24426 === (40))){
var inst_24288 = (state_24425[(2)]);
var inst_24289 = fluree.db.util.async.throw_err(inst_24288);
var state_24425__$1 = state_24425;
var statearr_24466_24581 = state_24425__$1;
(statearr_24466_24581[(2)] = inst_24289);

(statearr_24466_24581[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (56))){
var inst_24352 = (state_24425[(2)]);
var inst_24353 = fluree.db.util.async.throw_err(inst_24352);
var state_24425__$1 = state_24425;
var statearr_24467_24582 = state_24425__$1;
(statearr_24467_24582[(2)] = inst_24353);

(statearr_24467_24582[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (33))){
var inst_24247 = (state_24425[(14)]);
var inst_24229 = (state_24425[(15)]);
var inst_24278 = (inst_24247.cljs$core$IFn$_invoke$arity$2 ? inst_24247.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_24229) : inst_24247.call(null,cljs.core._EQ_,inst_24229));
var state_24425__$1 = state_24425;
if(cljs.core.truth_(inst_24278)){
var statearr_24468_24583 = state_24425__$1;
(statearr_24468_24583[(1)] = (37));

} else {
var statearr_24469_24584 = state_24425__$1;
(statearr_24469_24584[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (13))){
var state_24425__$1 = state_24425;
var statearr_24470_24585 = state_24425__$1;
(statearr_24470_24585[(2)] = limit);

(statearr_24470_24585[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (22))){
var inst_24415 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
var statearr_24471_24586 = state_24425__$1;
(statearr_24471_24586[(2)] = inst_24415);

(statearr_24471_24586[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (36))){
var inst_24262 = (state_24425[(24)]);
var inst_24274 = (state_24425[(2)]);
var inst_24275 = fluree.db.util.async.throw_err(inst_24274);
var inst_24276 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_24262,inst_24275);
var state_24425__$1 = state_24425;
var statearr_24472_24587 = state_24425__$1;
(statearr_24472_24587[(2)] = inst_24276);

(statearr_24472_24587[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (41))){
var inst_24228 = (state_24425[(21)]);
var inst_24188 = (state_24425[(11)]);
var inst_24230 = (state_24425[(22)]);
var inst_24293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24294 = [inst_24228,inst_24230];
var inst_24295 = (new cljs.core.PersistentVector(null,2,(5),inst_24293,inst_24294,null));
var inst_24296 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24297 = [inst_24228];
var inst_24298 = (new cljs.core.PersistentVector(null,1,(5),inst_24296,inst_24297,null));
var inst_24299 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24300 = [inst_24188];
var inst_24301 = cljs.core.PersistentHashMap.fromArrays(inst_24299,inst_24300);
var inst_24302 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24295,cljs.core._LT__EQ_,inst_24298,inst_24301);
var state_24425__$1 = state_24425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24425__$1,(44),inst_24302);
} else {
if((state_val_24426 === (43))){
var inst_24363 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
var statearr_24473_24588 = state_24425__$1;
(statearr_24473_24588[(2)] = inst_24363);

(statearr_24473_24588[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (61))){
var inst_24203 = (state_24425[(10)]);
var inst_24368 = (state_24425[(12)]);
var inst_24375 = cljs.core.PersistentHashSet.EMPTY;
var inst_24376 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24375,inst_24368);
var inst_24377 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_24203,inst_24376);
var state_24425__$1 = state_24425;
var statearr_24474_24589 = state_24425__$1;
(statearr_24474_24589[(2)] = inst_24377);

(statearr_24474_24589[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (29))){
var inst_24228 = (state_24425[(21)]);
var inst_24234 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_24228);
var inst_24235 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24234)].join('');
var inst_24236 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24237 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_24238 = cljs.core.PersistentHashMap.fromArrays(inst_24236,inst_24237);
var inst_24239 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24235,inst_24238);
var inst_24240 = (function(){throw inst_24239})();
var state_24425__$1 = state_24425;
var statearr_24475_24590 = state_24425__$1;
(statearr_24475_24590[(2)] = inst_24240);

(statearr_24475_24590[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (44))){
var inst_24304 = (state_24425[(2)]);
var inst_24305 = fluree.db.util.async.throw_err(inst_24304);
var state_24425__$1 = state_24425;
var statearr_24476_24591 = state_24425__$1;
(statearr_24476_24591[(2)] = inst_24305);

(statearr_24476_24591[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (6))){
var inst_24172 = (state_24425[(25)]);
var inst_24176 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_24172);
var state_24425__$1 = state_24425;
var statearr_24477_24592 = state_24425__$1;
(statearr_24477_24592[(2)] = inst_24176);

(statearr_24477_24592[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (28))){
var inst_24223 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
var statearr_24478_24593 = state_24425__$1;
(statearr_24478_24593[(2)] = inst_24223);

(statearr_24478_24593[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (64))){
var inst_24383 = (state_24425[(26)]);
var state_24425__$1 = state_24425;
var statearr_24479_24594 = state_24425__$1;
(statearr_24479_24594[(2)] = inst_24383);

(statearr_24479_24594[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (51))){
var inst_24359 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
var statearr_24480_24595 = state_24425__$1;
(statearr_24480_24595[(2)] = inst_24359);

(statearr_24480_24595[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (25))){
var inst_24218 = (state_24425[(2)]);
var state_24425__$1 = (function (){var statearr_24481 = state_24425;
(statearr_24481[(13)] = inst_24218);

return statearr_24481;
})();
if(cljs.core.truth_(limit)){
var statearr_24482_24596 = state_24425__$1;
(statearr_24482_24596[(1)] = (26));

} else {
var statearr_24483_24597 = state_24425__$1;
(statearr_24483_24597[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (34))){
var inst_24172 = (state_24425[(25)]);
var inst_24367 = (state_24425[(2)]);
var inst_24368 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_24367);
var state_24425__$1 = (function (){var statearr_24484 = state_24425;
(statearr_24484[(12)] = inst_24368);

return statearr_24484;
})();
var G__24485_24598 = inst_24172;
var G__24485_24599__$1 = (((G__24485_24598 instanceof cljs.core.Keyword))?G__24485_24598.fqn:null);
switch (G__24485_24599__$1) {
case "or":
var statearr_24486_24601 = state_24425__$1;
(statearr_24486_24601[(1)] = (58));


break;
case "and":
var statearr_24487_24602 = state_24425__$1;
(statearr_24487_24602[(1)] = (59));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24485_24599__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (17))){
var inst_24420 = (state_24425[(2)]);
var _ = (function (){var statearr_24488 = state_24425;
(statearr_24488[(4)] = cljs.core.rest((state_24425[(4)])));

return statearr_24488;
})();
var state_24425__$1 = state_24425;
var statearr_24489_24603 = state_24425__$1;
(statearr_24489_24603[(2)] = inst_24420);

(statearr_24489_24603[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (3))){
var inst_24423 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24425__$1,inst_24423);
} else {
if((state_val_24426 === (12))){
var inst_24182 = (offset + limit);
var state_24425__$1 = state_24425;
var statearr_24490_24604 = state_24425__$1;
(statearr_24490_24604[(2)] = inst_24182);

(statearr_24490_24604[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (2))){
var inst_24174 = (state_24425[(9)]);
var _ = (function (){var statearr_24491 = state_24425;
(statearr_24491[(4)] = cljs.core.cons((5),(state_24425[(4)])));

return statearr_24491;
})();
var inst_24171 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_24172 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24171,(0),null);
var inst_24173 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24171,(1),null);
var inst_24174__$1 = limit;
var state_24425__$1 = (function (){var statearr_24492 = state_24425;
(statearr_24492[(9)] = inst_24174__$1);

(statearr_24492[(16)] = inst_24173);

(statearr_24492[(25)] = inst_24172);

return statearr_24492;
})();
if(cljs.core.truth_(inst_24174__$1)){
var statearr_24493_24605 = state_24425__$1;
(statearr_24493_24605[(1)] = (6));

} else {
var statearr_24494_24606 = state_24425__$1;
(statearr_24494_24606[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (66))){
var inst_24388 = (state_24425[(7)]);
var state_24425__$1 = state_24425;
var statearr_24495_24607 = state_24425__$1;
(statearr_24495_24607[(2)] = inst_24388);

(statearr_24495_24607[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (23))){
var inst_24203 = (state_24425[(10)]);
var inst_24215 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_24203);
var state_24425__$1 = state_24425;
var statearr_24496_24608 = state_24425__$1;
(statearr_24496_24608[(2)] = inst_24215);

(statearr_24496_24608[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (47))){
var inst_24361 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
var statearr_24497_24609 = state_24425__$1;
(statearr_24497_24609[(2)] = inst_24361);

(statearr_24497_24609[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (35))){
var inst_24228 = (state_24425[(21)]);
var inst_24188 = (state_24425[(11)]);
var inst_24230 = (state_24425[(22)]);
var inst_24261 = (state_24425[(2)]);
var inst_24262 = fluree.db.util.async.throw_err(inst_24261);
var inst_24263 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24264 = [inst_24228];
var inst_24265 = (new cljs.core.PersistentVector(null,1,(5),inst_24263,inst_24264,null));
var inst_24266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24267 = [inst_24228,inst_24230];
var inst_24268 = (new cljs.core.PersistentVector(null,2,(5),inst_24266,inst_24267,null));
var inst_24269 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24270 = [inst_24188];
var inst_24271 = cljs.core.PersistentHashMap.fromArrays(inst_24269,inst_24270);
var inst_24272 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24265,cljs.core._LT_,inst_24268,inst_24271);
var state_24425__$1 = (function (){var statearr_24498 = state_24425;
(statearr_24498[(24)] = inst_24262);

return statearr_24498;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24425__$1,(36),inst_24272);
} else {
if((state_val_24426 === (76))){
var inst_24382 = (state_24425[(27)]);
var inst_24210 = (state_24425[(28)]);
var inst_24202 = inst_24210;
var inst_24203 = inst_24382;
var state_24425__$1 = (function (){var statearr_24499 = state_24425;
(statearr_24499[(10)] = inst_24203);

(statearr_24499[(17)] = inst_24202);

return statearr_24499;
})();
var statearr_24500_24610 = state_24425__$1;
(statearr_24500_24610[(2)] = null);

(statearr_24500_24610[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (19))){
var inst_24417 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
var statearr_24501_24611 = state_24425__$1;
(statearr_24501_24611[(2)] = inst_24417);

(statearr_24501_24611[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (57))){
var inst_24383 = (state_24425[(26)]);
var inst_24172 = (state_24425[(25)]);
var inst_24382 = (state_24425[(2)]);
var inst_24383__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_24172);
var state_24425__$1 = (function (){var statearr_24502 = state_24425;
(statearr_24502[(27)] = inst_24382);

(statearr_24502[(26)] = inst_24383__$1);

return statearr_24502;
})();
if(inst_24383__$1){
var statearr_24503_24612 = state_24425__$1;
(statearr_24503_24612[(1)] = (63));

} else {
var statearr_24504_24613 = state_24425__$1;
(statearr_24504_24613[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (68))){
var inst_24403 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
if(cljs.core.truth_(inst_24403)){
var statearr_24505_24614 = state_24425__$1;
(statearr_24505_24614[(1)] = (75));

} else {
var statearr_24506_24615 = state_24425__$1;
(statearr_24506_24615[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (11))){
var inst_24173 = (state_24425[(16)]);
var inst_24188 = (state_24425[(2)]);
var inst_24189 = cljs.core.not_empty(inst_24173);
var state_24425__$1 = (function (){var statearr_24508 = state_24425;
(statearr_24508[(11)] = inst_24188);

return statearr_24508;
})();
if(cljs.core.truth_(inst_24189)){
var statearr_24509_24616 = state_24425__$1;
(statearr_24509_24616[(1)] = (15));

} else {
var statearr_24510_24617 = state_24425__$1;
(statearr_24510_24617[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (9))){
var state_24425__$1 = state_24425;
if(cljs.core.truth_(offset)){
var statearr_24511_24618 = state_24425__$1;
(statearr_24511_24618[(1)] = (12));

} else {
var statearr_24512_24619 = state_24425__$1;
(statearr_24512_24619[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (5))){
var _ = (function (){var statearr_24513 = state_24425;
(statearr_24513[(4)] = cljs.core.rest((state_24425[(4)])));

return statearr_24513;
})();
var state_24425__$1 = state_24425;
var ex24507 = (state_24425__$1[(2)]);
var statearr_24514_24620 = state_24425__$1;
(statearr_24514_24620[(5)] = ex24507);


if((ex24507 instanceof Error)){
var statearr_24515_24621 = state_24425__$1;
(statearr_24515_24621[(1)] = (4));

(statearr_24515_24621[(5)] = null);

} else {
throw ex24507;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (14))){
var inst_24185 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
var statearr_24516_24622 = state_24425__$1;
(statearr_24516_24622[(2)] = inst_24185);

(statearr_24516_24622[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (45))){
var inst_24228 = (state_24425[(21)]);
var inst_24188 = (state_24425[(11)]);
var inst_24230 = (state_24425[(22)]);
var inst_24309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24310 = [inst_24228,inst_24230];
var inst_24311 = (new cljs.core.PersistentVector(null,2,(5),inst_24309,inst_24310,null));
var inst_24312 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24313 = [inst_24228];
var inst_24314 = (new cljs.core.PersistentVector(null,1,(5),inst_24312,inst_24313,null));
var inst_24315 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24316 = [inst_24188];
var inst_24317 = cljs.core.PersistentHashMap.fromArrays(inst_24315,inst_24316);
var inst_24318 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24311,cljs.core._LT__EQ_,inst_24314,inst_24317);
var state_24425__$1 = state_24425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24425__$1,(48),inst_24318);
} else {
if((state_val_24426 === (53))){
var inst_24228 = (state_24425[(21)]);
var inst_24188 = (state_24425[(11)]);
var inst_24230 = (state_24425[(22)]);
var inst_24341 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24342 = [inst_24228];
var inst_24343 = (new cljs.core.PersistentVector(null,1,(5),inst_24341,inst_24342,null));
var inst_24344 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24345 = [inst_24228,inst_24230];
var inst_24346 = (new cljs.core.PersistentVector(null,2,(5),inst_24344,inst_24345,null));
var inst_24347 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24348 = [inst_24188];
var inst_24349 = cljs.core.PersistentHashMap.fromArrays(inst_24347,inst_24348);
var inst_24350 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24343,cljs.core._LT__EQ_,inst_24346,inst_24349);
var state_24425__$1 = state_24425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24425__$1,(56),inst_24350);
} else {
if((state_val_24426 === (78))){
var inst_24382 = (state_24425[(27)]);
var inst_24406 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_24382);
var state_24425__$1 = state_24425;
var statearr_24517_24623 = state_24425__$1;
(statearr_24517_24623[(2)] = inst_24406);

(statearr_24517_24623[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (26))){
var inst_24218 = (state_24425[(13)]);
var inst_24220 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_24218);
var state_24425__$1 = state_24425;
var statearr_24518_24624 = state_24425__$1;
(statearr_24518_24624[(2)] = inst_24220);

(statearr_24518_24624[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (16))){
var state_24425__$1 = state_24425;
var statearr_24519_24625 = state_24425__$1;
(statearr_24519_24625[(2)] = null);

(statearr_24519_24625[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (79))){
var inst_24382 = (state_24425[(27)]);
var state_24425__$1 = state_24425;
var statearr_24520_24626 = state_24425__$1;
(statearr_24520_24626[(2)] = inst_24382);

(statearr_24520_24626[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (38))){
var inst_24247 = (state_24425[(14)]);
var inst_24229 = (state_24425[(15)]);
var inst_24291 = (inst_24247.cljs$core$IFn$_invoke$arity$2 ? inst_24247.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_24229) : inst_24247.call(null,cljs.core._GT_,inst_24229));
var state_24425__$1 = state_24425;
if(cljs.core.truth_(inst_24291)){
var statearr_24521_24627 = state_24425__$1;
(statearr_24521_24627[(1)] = (41));

} else {
var statearr_24522_24628 = state_24425__$1;
(statearr_24522_24628[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (30))){
var state_24425__$1 = state_24425;
var statearr_24523_24629 = state_24425__$1;
(statearr_24523_24629[(2)] = null);

(statearr_24523_24629[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (73))){
var inst_24188 = (state_24425[(11)]);
var state_24425__$1 = state_24425;
var statearr_24524_24630 = state_24425__$1;
(statearr_24524_24630[(2)] = inst_24188);

(statearr_24524_24630[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (10))){
var state_24425__$1 = state_24425;
var statearr_24525_24631 = state_24425__$1;
(statearr_24525_24631[(2)] = null);

(statearr_24525_24631[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (18))){
var inst_24209 = (state_24425[(20)]);
var inst_24202 = (state_24425[(17)]);
var inst_24208 = cljs.core.seq(inst_24202);
var inst_24209__$1 = cljs.core.first(inst_24208);
var inst_24210 = cljs.core.next(inst_24208);
var inst_24211 = cljs.core.not(inst_24209__$1);
var state_24425__$1 = (function (){var statearr_24526 = state_24425;
(statearr_24526[(20)] = inst_24209__$1);

(statearr_24526[(28)] = inst_24210);

return statearr_24526;
})();
if(inst_24211){
var statearr_24527_24632 = state_24425__$1;
(statearr_24527_24632[(1)] = (20));

} else {
var statearr_24528_24633 = state_24425__$1;
(statearr_24528_24633[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (52))){
var inst_24336 = (state_24425[(2)]);
var inst_24337 = fluree.db.util.async.throw_err(inst_24336);
var state_24425__$1 = state_24425;
var statearr_24529_24634 = state_24425__$1;
(statearr_24529_24634[(2)] = inst_24337);

(statearr_24529_24634[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (67))){
var inst_24391 = (state_24425[(8)]);
var inst_24172 = (state_24425[(25)]);
var inst_24391__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_24172);
var state_24425__$1 = (function (){var statearr_24530 = state_24425;
(statearr_24530[(8)] = inst_24391__$1);

return statearr_24530;
})();
if(inst_24391__$1){
var statearr_24531_24635 = state_24425__$1;
(statearr_24531_24635[(1)] = (69));

} else {
var statearr_24532_24636 = state_24425__$1;
(statearr_24532_24636[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (71))){
var inst_24401 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
var statearr_24533_24637 = state_24425__$1;
(statearr_24533_24637[(2)] = inst_24401);

(statearr_24533_24637[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (42))){
var inst_24247 = (state_24425[(14)]);
var inst_24229 = (state_24425[(15)]);
var inst_24307 = (inst_24247.cljs$core$IFn$_invoke$arity$2 ? inst_24247.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_24229) : inst_24247.call(null,cljs.core._GT__EQ_,inst_24229));
var state_24425__$1 = state_24425;
if(cljs.core.truth_(inst_24307)){
var statearr_24534_24638 = state_24425__$1;
(statearr_24534_24638[(1)] = (45));

} else {
var statearr_24535_24639 = state_24425__$1;
(statearr_24535_24639[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (80))){
var inst_24409 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
var statearr_24536_24640 = state_24425__$1;
(statearr_24536_24640[(2)] = inst_24409);

(statearr_24536_24640[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (37))){
var inst_24228 = (state_24425[(21)]);
var inst_24188 = (state_24425[(11)]);
var inst_24230 = (state_24425[(22)]);
var inst_24280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24281 = [inst_24228,inst_24230];
var inst_24282 = (new cljs.core.PersistentVector(null,2,(5),inst_24280,inst_24281,null));
var inst_24283 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24284 = [inst_24188];
var inst_24285 = cljs.core.PersistentHashMap.fromArrays(inst_24283,inst_24284);
var inst_24286 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_24282,inst_24285);
var state_24425__$1 = state_24425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24425__$1,(40),inst_24286);
} else {
if((state_val_24426 === (63))){
var inst_24382 = (state_24425[(27)]);
var inst_24385 = cljs.core.empty_QMARK_(inst_24382);
var state_24425__$1 = state_24425;
var statearr_24537_24641 = state_24425__$1;
(statearr_24537_24641[(2)] = inst_24385);

(statearr_24537_24641[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (8))){
var inst_24179 = (state_24425[(2)]);
var state_24425__$1 = state_24425;
if(cljs.core.truth_(inst_24179)){
var statearr_24538_24642 = state_24425__$1;
(statearr_24538_24642[(1)] = (9));

} else {
var statearr_24539_24643 = state_24425__$1;
(statearr_24539_24643[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24426 === (49))){
var inst_24228 = (state_24425[(21)]);
var inst_24188 = (state_24425[(11)]);
var inst_24230 = (state_24425[(22)]);
var inst_24325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24326 = [inst_24228];
var inst_24327 = (new cljs.core.PersistentVector(null,1,(5),inst_24325,inst_24326,null));
var inst_24328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24329 = [inst_24228,inst_24230];
var inst_24330 = (new cljs.core.PersistentVector(null,2,(5),inst_24328,inst_24329,null));
var inst_24331 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24332 = [inst_24188];
var inst_24333 = cljs.core.PersistentHashMap.fromArrays(inst_24331,inst_24332);
var inst_24334 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24327,cljs.core._LT_,inst_24330,inst_24333);
var state_24425__$1 = state_24425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24425__$1,(52),inst_24334);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2727__auto__ = null;
var fluree$db$query$fql$state_machine__2727__auto____0 = (function (){
var statearr_24540 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24540[(0)] = fluree$db$query$fql$state_machine__2727__auto__);

(statearr_24540[(1)] = (1));

return statearr_24540;
});
var fluree$db$query$fql$state_machine__2727__auto____1 = (function (state_24425){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24425);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24541){var ex__2730__auto__ = e24541;
var statearr_24542_24644 = state_24425;
(statearr_24542_24644[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24425[(4)]))){
var statearr_24543_24645 = state_24425;
(statearr_24543_24645[(1)] = cljs.core.first((state_24425[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24646 = state_24425;
state_24425 = G__24646;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2727__auto__ = function(state_24425){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2727__auto____1.call(this,state_24425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2727__auto____0;
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2727__auto____1;
return fluree$db$query$fql$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24544 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24544[(6)] = c__2749__auto__);

return statearr_24544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 4);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4253__auto__ = cljs.core.every_QMARK_((function (p1__24647_SHARP_){
return ((typeof p1__24647_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__24647_SHARP_)));
}),select_smt);
if(or__4253__auto__){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__24648_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__24648_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__24652 = vars;
var vec__24653 = G__24652;
var seq__24654 = cljs.core.seq(vec__24653);
var first__24655 = cljs.core.first(seq__24654);
var seq__24654__$1 = cljs.core.next(seq__24654);
var var$ = first__24655;
var r = seq__24654__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24652__$1 = G__24652;
var all_vars__$1 = all_vars;
while(true){
var vec__24660 = G__24652__$1;
var seq__24661 = cljs.core.seq(vec__24660);
var first__24662 = cljs.core.first(seq__24661);
var seq__24661__$1 = cljs.core.next(seq__24661);
var var$__$1 = first__24662;
var r__$1 = seq__24661__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__24663 = cljs.core.set(all_vars__$2);
return (fexpr__24663.cljs$core$IFn$_invoke$arity$1 ? fexpr__24663.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__24663.call(null,var$__$1));
})())){
var G__24664 = r__$1;
var G__24665 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__24652__$1 = G__24664;
all_vars__$1 = G__24665;
continue;
} else {
var G__24666 = r__$1;
var G__24667 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__24652__$1 = G__24666;
all_vars__$1 = G__24667;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24702){
var state_val_24703 = (state_24702[(1)]);
if((state_val_24703 === (1))){
var inst_24675 = functionArray;
var inst_24676 = cljs.core.seq(inst_24675);
var inst_24677 = cljs.core.first(inst_24676);
var inst_24678 = cljs.core.next(inst_24676);
var inst_24679 = cljs.core.PersistentVector.EMPTY;
var inst_24680 = inst_24675;
var inst_24681 = inst_24679;
var state_24702__$1 = (function (){var statearr_24704 = state_24702;
(statearr_24704[(7)] = inst_24678);

(statearr_24704[(8)] = inst_24681);

(statearr_24704[(9)] = inst_24677);

(statearr_24704[(10)] = inst_24680);

return statearr_24704;
})();
var statearr_24705_24718 = state_24702__$1;
(statearr_24705_24718[(2)] = null);

(statearr_24705_24718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24703 === (2))){
var inst_24687 = (state_24702[(11)]);
var inst_24680 = (state_24702[(10)]);
var inst_24686 = cljs.core.seq(inst_24680);
var inst_24687__$1 = cljs.core.first(inst_24686);
var inst_24688 = cljs.core.next(inst_24686);
var state_24702__$1 = (function (){var statearr_24706 = state_24702;
(statearr_24706[(11)] = inst_24687__$1);

(statearr_24706[(12)] = inst_24688);

return statearr_24706;
})();
if(cljs.core.truth_(inst_24687__$1)){
var statearr_24707_24719 = state_24702__$1;
(statearr_24707_24719[(1)] = (4));

} else {
var statearr_24708_24720 = state_24702__$1;
(statearr_24708_24720[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24703 === (3))){
var inst_24700 = (state_24702[(2)]);
var state_24702__$1 = state_24702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24702__$1,inst_24700);
} else {
if((state_val_24703 === (4))){
var inst_24687 = (state_24702[(11)]);
var inst_24690 = (inst_24687.cljs$core$IFn$_invoke$arity$1 ? inst_24687.cljs$core$IFn$_invoke$arity$1(tuple) : inst_24687.call(null,tuple));
var state_24702__$1 = state_24702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24702__$1,(7),inst_24690);
} else {
if((state_val_24703 === (5))){
var inst_24681 = (state_24702[(8)]);
var state_24702__$1 = state_24702;
var statearr_24709_24721 = state_24702__$1;
(statearr_24709_24721[(2)] = inst_24681);

(statearr_24709_24721[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24703 === (6))){
var inst_24698 = (state_24702[(2)]);
var state_24702__$1 = state_24702;
var statearr_24710_24722 = state_24702__$1;
(statearr_24710_24722[(2)] = inst_24698);

(statearr_24710_24722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24703 === (7))){
var inst_24681 = (state_24702[(8)]);
var inst_24688 = (state_24702[(12)]);
var inst_24692 = (state_24702[(2)]);
var inst_24693 = fluree.db.util.async.throw_err(inst_24692);
var inst_24694 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24681,inst_24693);
var inst_24680 = inst_24688;
var inst_24681__$1 = inst_24694;
var state_24702__$1 = (function (){var statearr_24711 = state_24702;
(statearr_24711[(8)] = inst_24681__$1);

(statearr_24711[(10)] = inst_24680);

return statearr_24711;
})();
var statearr_24712_24723 = state_24702__$1;
(statearr_24712_24723[(2)] = null);

(statearr_24712_24723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2727__auto____0 = (function (){
var statearr_24713 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24713[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2727__auto__);

(statearr_24713[(1)] = (1));

return statearr_24713;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2727__auto____1 = (function (state_24702){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24702);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24714){var ex__2730__auto__ = e24714;
var statearr_24715_24724 = state_24702;
(statearr_24715_24724[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24702[(4)]))){
var statearr_24716_24725 = state_24702;
(statearr_24716_24725[(1)] = cljs.core.first((state_24702[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24726 = state_24702;
state_24702 = G__24726;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2727__auto__ = function(state_24702){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2727__auto____1.call(this,state_24702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2727__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2727__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24717 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24717[(6)] = c__2749__auto__);

return statearr_24717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__24727){
var vec__24728 = p__24727;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24728,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24728,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24742){
var state_val_24743 = (state_24742[(1)]);
if((state_val_24743 === (1))){
var inst_24731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24732 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24733 = [query_map,_id,query_opts];
var inst_24734 = cljs.core.PersistentHashMap.fromArrays(inst_24732,inst_24733);
var inst_24735 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_24734) : fluree.db.query.fql.query.call(null,db,inst_24734));
var state_24742__$1 = (function (){var statearr_24744 = state_24742;
(statearr_24744[(7)] = inst_24731);

return statearr_24744;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24742__$1,(2),inst_24735);
} else {
if((state_val_24743 === (2))){
var inst_24731 = (state_24742[(7)]);
var inst_24737 = (state_24742[(2)]);
var inst_24738 = fluree.db.util.async.throw_err(inst_24737);
var inst_24739 = [tuple_index,inst_24738];
var inst_24740 = (new cljs.core.PersistentVector(null,2,(5),inst_24731,inst_24739,null));
var state_24742__$1 = state_24742;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24742__$1,inst_24740);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0 = (function (){
var statearr_24745 = [null,null,null,null,null,null,null,null];
(statearr_24745[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2727__auto__);

(statearr_24745[(1)] = (1));

return statearr_24745;
});
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1 = (function (state_24742){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24742);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24746){var ex__2730__auto__ = e24746;
var statearr_24747_24750 = state_24742;
(statearr_24747_24750[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24742[(4)]))){
var statearr_24748_24751 = state_24742;
(statearr_24748_24751[(1)] = cljs.core.first((state_24742[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24752 = state_24742;
state_24742 = G__24752;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__ = function(state_24742){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1.call(this,state_24742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24749 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24749[(6)] = c__2749__auto__);

return statearr_24749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__24753 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24753,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24753,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24816){
var state_val_24817 = (state_24816[(1)]);
if((state_val_24817 === (7))){
var inst_24811 = (state_24816[(2)]);
var _ = (function (){var statearr_24818 = state_24816;
(statearr_24818[(4)] = cljs.core.rest((state_24816[(4)])));

return statearr_24818;
})();
var state_24816__$1 = state_24816;
var statearr_24819_24910 = state_24816__$1;
(statearr_24819_24910[(2)] = inst_24811);

(statearr_24819_24910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24817 === (20))){
var inst_24802 = (state_24816[(2)]);
var state_24816__$1 = state_24816;
var statearr_24820_24911 = state_24816__$1;
(statearr_24820_24911[(2)] = inst_24802);

(statearr_24820_24911[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24817 === (1))){
var state_24816__$1 = state_24816;
var statearr_24821_24912 = state_24816__$1;
(statearr_24821_24912[(2)] = null);

(statearr_24821_24912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24817 === (4))){
var inst_24758 = (state_24816[(2)]);
var state_24816__$1 = state_24816;
var statearr_24822_24913 = state_24816__$1;
(statearr_24822_24913[(2)] = inst_24758);

(statearr_24822_24913[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24817 === (15))){
var inst_24778 = (state_24816[(7)]);
var inst_24787 = cljs.core.second(inst_24778);
var inst_24788 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_24787);
var inst_24789 = (inst_24788 > max_fuel);
var state_24816__$1 = state_24816;
if(cljs.core.truth_(inst_24789)){
var statearr_24823_24914 = state_24816__$1;
(statearr_24823_24914[(1)] = (18));

} else {
var statearr_24824_24915 = state_24816__$1;
(statearr_24824_24915[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24817 === (13))){
var state_24816__$1 = state_24816;
var statearr_24825_24916 = state_24816__$1;
(statearr_24825_24916[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24817 === (6))){
var inst_24766 = (state_24816[(8)]);
var state_24816__$1 = state_24816;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24816__$1,(8),inst_24766);
} else {
if((state_val_24817 === (17))){
var inst_24805 = (state_24816[(2)]);
var state_24816__$1 = state_24816;
var statearr_24827_24917 = state_24816__$1;
(statearr_24827_24917[(2)] = inst_24805);

(statearr_24827_24917[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24817 === (3))){
var inst_24814 = (state_24816[(2)]);
var state_24816__$1 = state_24816;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24816__$1,inst_24814);
} else {
if((state_val_24817 === (12))){
var inst_24778 = (state_24816[(7)]);
var inst_24767 = (state_24816[(9)]);
var inst_24784 = (inst_24767.cljs$core$IFn$_invoke$arity$0 ? inst_24767.cljs$core$IFn$_invoke$arity$0() : inst_24767.call(null));
var state_24816__$1 = (function (){var statearr_24828 = state_24816;
(statearr_24828[(10)] = inst_24784);

return statearr_24828;
})();
var statearr_24829_24918 = state_24816__$1;
(statearr_24829_24918[(2)] = inst_24778);

(statearr_24829_24918[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24817 === (2))){
var inst_24766 = (state_24816[(8)]);
var inst_24767 = (state_24816[(9)]);
var _ = (function (){var statearr_24830 = state_24816;
(statearr_24830[(4)] = cljs.core.cons((5),(state_24816[(4)])));

return statearr_24830;
})();
var inst_24764 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_24765 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24766__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24767__$1 = (function (){var expandMaps = inst_24764;
var queue_ch = inst_24765;
var res_ch = inst_24766__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_24768 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_24769 = cljs.core.volatile_BANG_((0));
var inst_24770 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24768,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_24769);
var inst_24771 = (function (){var expandMaps = inst_24764;
var queue_ch = inst_24765;
var res_ch = inst_24766__$1;
var stop_BANG_ = inst_24767__$1;
var opts_STAR_ = inst_24770;
return (function (tuple_res,port){
var c__2749__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24863){
var state_val_24864 = (state_24863[(1)]);
if((state_val_24864 === (7))){
var state_24863__$1 = state_24863;
var statearr_24865_24919 = state_24863__$1;
(statearr_24865_24919[(2)] = tuple_res);

(statearr_24865_24919[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (1))){
var state_24863__$1 = state_24863;
var statearr_24866_24920 = state_24863__$1;
(statearr_24866_24920[(2)] = null);

(statearr_24866_24920[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (4))){
var inst_24831 = (state_24863[(2)]);
var inst_24832 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24831);
var inst_24833 = cljs.core.async.close_BANG_(port);
var state_24863__$1 = (function (){var statearr_24867 = state_24863;
(statearr_24867[(7)] = inst_24832);

return statearr_24867;
})();
var statearr_24868_24921 = state_24863__$1;
(statearr_24868_24921[(2)] = inst_24833);

(statearr_24868_24921[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (6))){
var inst_24840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24841 = [tuple_res];
var inst_24842 = (new cljs.core.PersistentVector(null,1,(5),inst_24840,inst_24841,null));
var state_24863__$1 = state_24863;
var statearr_24869_24922 = state_24863__$1;
(statearr_24869_24922[(2)] = inst_24842);

(statearr_24869_24922[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (3))){
var inst_24861 = (state_24863[(2)]);
var state_24863__$1 = state_24863;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24863__$1,inst_24861);
} else {
if((state_val_24864 === (2))){
var ___$1 = (function (){var statearr_24871 = state_24863;
(statearr_24871[(4)] = cljs.core.cons((5),(state_24863[(4)])));

return statearr_24871;
})();
var state_24863__$1 = state_24863;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_24872_24923 = state_24863__$1;
(statearr_24872_24923[(1)] = (6));

} else {
var statearr_24873_24924 = state_24863__$1;
(statearr_24873_24924[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (9))){
var inst_24847 = (state_24863[(8)]);
var inst_24845 = (state_24863[(9)]);
var inst_24854 = (state_24863[(2)]);
var inst_24855 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_24845,inst_24854);
var inst_24856 = (inst_24847.cljs$core$IFn$_invoke$arity$1 ? inst_24847.cljs$core$IFn$_invoke$arity$1(inst_24855) : inst_24847.call(null,inst_24855));
var inst_24857 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24856);
var inst_24858 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_24874 = state_24863;
(statearr_24874[(4)] = cljs.core.rest((state_24863[(4)])));

return statearr_24874;
})();
var state_24863__$1 = (function (){var statearr_24875 = state_24863;
(statearr_24875[(10)] = inst_24857);

return statearr_24875;
})();
var statearr_24876_24925 = state_24863__$1;
(statearr_24876_24925[(2)] = inst_24858);

(statearr_24876_24925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (5))){
var ___$1 = (function (){var statearr_24877 = state_24863;
(statearr_24877[(4)] = cljs.core.rest((state_24863[(4)])));

return statearr_24877;
})();
var state_24863__$1 = state_24863;
var ex24870 = (state_24863__$1[(2)]);
var statearr_24878_24926 = state_24863__$1;
(statearr_24878_24926[(5)] = ex24870);


var statearr_24879_24927 = state_24863__$1;
(statearr_24879_24927[(1)] = (4));

(statearr_24879_24927[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (8))){
var inst_24845 = (state_24863[(9)]);
var inst_24845__$1 = (state_24863[(2)]);
var inst_24846 = cljs.core.volatile_BANG_((0));
var inst_24847 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24845__$1;
var query_fuel = inst_24846;
return (function (p1__24757_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__24757_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24757_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_24848 = cljs.core.PersistentVector.EMPTY;
var inst_24849 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24845__$1;
var query_fuel = inst_24846;
return (function (p1__24756_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__24756_SHARP_);
});
})();
var inst_24850 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_24849,expandMaps);
var inst_24851 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_24850);
var inst_24852 = cljs.core.async.into(inst_24848,inst_24851);
var state_24863__$1 = (function (){var statearr_24880 = state_24863;
(statearr_24880[(8)] = inst_24847);

(statearr_24880[(9)] = inst_24845__$1);

return statearr_24880;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24863__$1,(9),inst_24852);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0 = (function (){
var statearr_24881 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24881[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__);

(statearr_24881[(1)] = (1));

return statearr_24881;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1 = (function (state_24863){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24863);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24882){var ex__2730__auto__ = e24882;
var statearr_24883_24928 = state_24863;
(statearr_24883_24928[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24863[(4)]))){
var statearr_24884_24929 = state_24863;
(statearr_24884_24929[(1)] = cljs.core.first((state_24863[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24930 = state_24863;
state_24863 = G__24930;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = function(state_24863){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1.call(this,state_24863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24885 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24885[(6)] = c__2749__auto____$1);

return statearr_24885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto____$1;
});
})();
var inst_24772 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_24765,tuples_res);
var inst_24773 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_24766__$1,inst_24771,inst_24765);
var inst_24774 = cljs.core.PersistentVector.EMPTY;
var inst_24775 = inst_24774;
var state_24816__$1 = (function (){var statearr_24886 = state_24816;
(statearr_24886[(11)] = inst_24775);

(statearr_24886[(8)] = inst_24766__$1);

(statearr_24886[(12)] = inst_24773);

(statearr_24886[(9)] = inst_24767__$1);

(statearr_24886[(13)] = inst_24772);

return statearr_24886;
})();
var statearr_24887_24931 = state_24816__$1;
(statearr_24887_24931[(2)] = null);

(statearr_24887_24931[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24817 === (19))){
var inst_24778 = (state_24816[(7)]);
var inst_24775 = (state_24816[(11)]);
var inst_24798 = cljs.core.first(inst_24778);
var inst_24799 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24775,inst_24798);
var inst_24775__$1 = inst_24799;
var state_24816__$1 = (function (){var statearr_24888 = state_24816;
(statearr_24888[(11)] = inst_24775__$1);

return statearr_24888;
})();
var statearr_24889_24932 = state_24816__$1;
(statearr_24889_24932[(2)] = null);

(statearr_24889_24932[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24817 === (11))){
var inst_24809 = (state_24816[(2)]);
var state_24816__$1 = state_24816;
var statearr_24891_24933 = state_24816__$1;
(statearr_24891_24933[(2)] = inst_24809);

(statearr_24891_24933[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24817 === (9))){
var inst_24775 = (state_24816[(11)]);
var state_24816__$1 = state_24816;
var statearr_24892_24934 = state_24816__$1;
(statearr_24892_24934[(2)] = inst_24775);

(statearr_24892_24934[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24817 === (5))){
var _ = (function (){var statearr_24893 = state_24816;
(statearr_24893[(4)] = cljs.core.rest((state_24816[(4)])));

return statearr_24893;
})();
var state_24816__$1 = state_24816;
var ex24890 = (state_24816__$1[(2)]);
var statearr_24894_24935 = state_24816__$1;
(statearr_24894_24935[(5)] = ex24890);


if((ex24890 instanceof Error)){
var statearr_24895_24936 = state_24816__$1;
(statearr_24895_24936[(1)] = (4));

(statearr_24895_24936[(5)] = null);

} else {
throw ex24890;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24817 === (14))){
var inst_24807 = (state_24816[(2)]);
var state_24816__$1 = state_24816;
var statearr_24896_24937 = state_24816__$1;
(statearr_24896_24937[(2)] = inst_24807);

(statearr_24896_24937[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24817 === (16))){
var state_24816__$1 = state_24816;
var statearr_24897_24938 = state_24816__$1;
(statearr_24897_24938[(2)] = null);

(statearr_24897_24938[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24817 === (10))){
var inst_24778 = (state_24816[(7)]);
var inst_24782 = fluree.db.util.core.exception_QMARK_(inst_24778);
var state_24816__$1 = state_24816;
if(inst_24782){
var statearr_24898_24939 = state_24816__$1;
(statearr_24898_24939[(1)] = (12));

} else {
var statearr_24899_24940 = state_24816__$1;
(statearr_24899_24940[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24817 === (18))){
var inst_24767 = (state_24816[(9)]);
var inst_24791 = (inst_24767.cljs$core$IFn$_invoke$arity$0 ? inst_24767.cljs$core$IFn$_invoke$arity$0() : inst_24767.call(null));
var inst_24792 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_24793 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24794 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_24795 = cljs.core.PersistentHashMap.fromArrays(inst_24793,inst_24794);
var inst_24796 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24792,inst_24795);
var state_24816__$1 = (function (){var statearr_24900 = state_24816;
(statearr_24900[(14)] = inst_24791);

return statearr_24900;
})();
var statearr_24901_24941 = state_24816__$1;
(statearr_24901_24941[(2)] = inst_24796);

(statearr_24901_24941[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24817 === (8))){
var inst_24778 = (state_24816[(7)]);
var inst_24778__$1 = (state_24816[(2)]);
var inst_24779 = (inst_24778__$1 == null);
var state_24816__$1 = (function (){var statearr_24902 = state_24816;
(statearr_24902[(7)] = inst_24778__$1);

return statearr_24902;
})();
if(cljs.core.truth_(inst_24779)){
var statearr_24903_24942 = state_24816__$1;
(statearr_24903_24942[(1)] = (9));

} else {
var statearr_24904_24943 = state_24816__$1;
(statearr_24904_24943[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0 = (function (){
var statearr_24905 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24905[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__);

(statearr_24905[(1)] = (1));

return statearr_24905;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1 = (function (state_24816){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24816);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24906){var ex__2730__auto__ = e24906;
var statearr_24907_24944 = state_24816;
(statearr_24907_24944[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24816[(4)]))){
var statearr_24908_24945 = state_24816;
(statearr_24908_24945[(1)] = cljs.core.first((state_24816[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24946 = state_24816;
state_24816 = G__24946;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = function(state_24816){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1.call(this,state_24816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24909 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24909[(6)] = c__2749__auto__);

return statearr_24909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__24947 = select;
var map__24947__$1 = cljs.core.__destructure_map(map__24947);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24947__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24947__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24947__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__4253__auto__ = as;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__24950 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24950,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24950,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24950,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__24948_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24948_SHARP_,compare_idx));
}):(function (p1__24949_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24949_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24955 = arguments.length;
switch (G__24955) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__24956,p__24957,group_limit,opts){
var map__24958 = p__24956;
var map__24958__$1 = cljs.core.__destructure_map(map__24958);
var res = map__24958__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24958__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24959 = p__24957;
var map__24959__$1 = cljs.core.__destructure_map(map__24959);
var select_spec = map__24959__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24959__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24959__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24959__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24959__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24959__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24959__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24959__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24959__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24959__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24959__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25096){
var state_val_25097 = (state_25096[(1)]);
if((state_val_25097 === (7))){
var inst_24966 = (state_25096[(7)]);
var state_25096__$1 = state_25096;
var statearr_25098_25200 = state_25096__$1;
(statearr_25098_25200[(2)] = inst_24966);

(statearr_25098_25200[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (59))){
var inst_25089 = (state_25096[(2)]);
var state_25096__$1 = state_25096;
var statearr_25099_25201 = state_25096__$1;
(statearr_25099_25201[(2)] = inst_25089);

(statearr_25099_25201[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (20))){
var inst_25002 = (state_25096[(8)]);
var inst_25005 = (state_25096[(9)]);
var inst_25001 = (state_25096[(2)]);
var inst_25002__$1 = cljs.core.__destructure_map(inst_25001);
var inst_25003 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25002__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_25004 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25002__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_25005__$1 = offset;
var state_25096__$1 = (function (){var statearr_25100 = state_25096;
(statearr_25100[(10)] = inst_25004);

(statearr_25100[(11)] = inst_25003);

(statearr_25100[(8)] = inst_25002__$1);

(statearr_25100[(9)] = inst_25005__$1);

return statearr_25100;
})();
if(cljs.core.truth_(inst_25005__$1)){
var statearr_25101_25202 = state_25096__$1;
(statearr_25101_25202[(1)] = (21));

} else {
var statearr_25102_25203 = state_25096__$1;
(statearr_25102_25203[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (58))){
var inst_25081 = (state_25096[(12)]);
var state_25096__$1 = state_25096;
var statearr_25103_25204 = state_25096__$1;
(statearr_25103_25204[(2)] = inst_25081);

(statearr_25103_25204[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (60))){
var inst_25085 = (state_25096[(2)]);
var inst_25086 = fluree.db.util.async.throw_err(inst_25085);
var state_25096__$1 = state_25096;
var statearr_25104_25205 = state_25096__$1;
(statearr_25104_25205[(2)] = inst_25086);

(statearr_25104_25205[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (27))){
var inst_25017 = cljs.core.not(inVector_QMARK_);
var state_25096__$1 = state_25096;
var statearr_25105_25206 = state_25096__$1;
(statearr_25105_25206[(2)] = inst_25017);

(statearr_25105_25206[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (1))){
var state_25096__$1 = state_25096;
var statearr_25106_25207 = state_25096__$1;
(statearr_25106_25207[(2)] = null);

(statearr_25106_25207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (24))){
var state_25096__$1 = state_25096;
var statearr_25107_25208 = state_25096__$1;
(statearr_25107_25208[(2)] = offset);

(statearr_25107_25208[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (55))){
var inst_25075 = (state_25096[(13)]);
var state_25096__$1 = state_25096;
var statearr_25108_25209 = state_25096__$1;
(statearr_25108_25209[(2)] = inst_25075);

(statearr_25108_25209[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (39))){
var inst_25043 = (state_25096[(14)]);
var inst_25045 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_25046 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25043,inst_25045);
var state_25096__$1 = state_25096;
var statearr_25109_25210 = state_25096__$1;
(statearr_25109_25210[(2)] = inst_25046);

(statearr_25109_25210[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (46))){
var inst_25055 = (state_25096[(15)]);
var state_25096__$1 = state_25096;
var statearr_25110_25211 = state_25096__$1;
(statearr_25110_25211[(2)] = inst_25055);

(statearr_25110_25211[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (4))){
var inst_24960 = (state_25096[(2)]);
var state_25096__$1 = state_25096;
var statearr_25111_25212 = state_25096__$1;
(statearr_25111_25212[(2)] = inst_24960);

(statearr_25111_25212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (54))){
var inst_25069 = (state_25096[(16)]);
var inst_25075 = (state_25096[(13)]);
var inst_25077 = cljs.core.PersistentVector.EMPTY;
var inst_25078 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_25077,inst_25069,inst_25075);
var state_25096__$1 = state_25096;
var statearr_25112_25213 = state_25096__$1;
(statearr_25112_25213[(2)] = inst_25078);

(statearr_25112_25213[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (15))){
var inst_24987 = (state_25096[(17)]);
var inst_24989 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24990 = [inst_24987];
var inst_24991 = (new cljs.core.PersistentVector(null,1,(5),inst_24989,inst_24990,null));
var state_25096__$1 = state_25096;
var statearr_25113_25214 = state_25096__$1;
(statearr_25113_25214[(2)] = inst_24991);

(statearr_25113_25214[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (48))){
var inst_25020 = (state_25096[(18)]);
var inst_25004 = (state_25096[(10)]);
var inst_25014 = (state_25096[(19)]);
var inst_25025 = (state_25096[(20)]);
var inst_25003 = (state_25096[(11)]);
var inst_25061 = (state_25096[(21)]);
var inst_25002 = (state_25096[(8)]);
var inst_25063 = (function (){var map__24996 = inst_25002;
var headers = inst_25003;
var tuples = inst_25004;
var offset_SINGLEQUOTE_ = inst_25014;
var single_result_QMARK_ = inst_25020;
var pp_keys = inst_25025;
var G__25026 = inst_25061;
return (function (p1__24953_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__24953_SHARP_);
});
})();
var inst_25064 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_25063);
var inst_25065 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25061,inst_25064);
var state_25096__$1 = state_25096;
var statearr_25114_25215 = state_25096__$1;
(statearr_25114_25215[(2)] = inst_25065);

(statearr_25114_25215[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (50))){
var inst_25068 = (state_25096[(2)]);
var inst_25069 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_25068);
var state_25096__$1 = (function (){var statearr_25115 = state_25096;
(statearr_25115[(16)] = inst_25069);

return statearr_25115;
})();
if(cljs.core.truth_(orderBy)){
var statearr_25116_25216 = state_25096__$1;
(statearr_25116_25216[(1)] = (51));

} else {
var statearr_25117_25217 = state_25096__$1;
(statearr_25117_25217[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (21))){
var inst_25007 = cljs.core.not(groupBy);
var state_25096__$1 = state_25096;
var statearr_25118_25218 = state_25096__$1;
(statearr_25118_25218[(2)] = inst_25007);

(statearr_25118_25218[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (31))){
var state_25096__$1 = state_25096;
var statearr_25119_25219 = state_25096__$1;
(statearr_25119_25219[(2)] = null);

(statearr_25119_25219[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (32))){
var inst_25020 = (state_25096[(18)]);
var inst_25003 = (state_25096[(11)]);
var inst_25025 = (state_25096[(2)]);
var inst_25027 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25028 = fluree.db.query.fql.select_tuples_fn(inst_25003,vars,select);
var inst_25029 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_25028);
var inst_25030 = [inst_25029];
var inst_25031 = (new cljs.core.PersistentVector(null,1,(5),inst_25027,inst_25030,null));
var state_25096__$1 = (function (){var statearr_25120 = state_25096;
(statearr_25120[(22)] = inst_25031);

(statearr_25120[(20)] = inst_25025);

return statearr_25120;
})();
if(cljs.core.truth_(inst_25020)){
var statearr_25121_25220 = state_25096__$1;
(statearr_25121_25220[(1)] = (33));

} else {
var statearr_25122_25221 = state_25096__$1;
(statearr_25122_25221[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (40))){
var inst_25043 = (state_25096[(14)]);
var state_25096__$1 = state_25096;
var statearr_25123_25222 = state_25096__$1;
(statearr_25123_25222[(2)] = inst_25043);

(statearr_25123_25222[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (56))){
var inst_25081 = (state_25096[(2)]);
var state_25096__$1 = (function (){var statearr_25124 = state_25096;
(statearr_25124[(12)] = inst_25081);

return statearr_25124;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_25125_25223 = state_25096__$1;
(statearr_25125_25223[(1)] = (57));

} else {
var statearr_25126_25224 = state_25096__$1;
(statearr_25126_25224[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (33))){
var inst_25031 = (state_25096[(22)]);
var inst_25033 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_25034 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25031,inst_25033);
var state_25096__$1 = state_25096;
var statearr_25127_25225 = state_25096__$1;
(statearr_25127_25225[(2)] = inst_25034);

(statearr_25127_25225[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (13))){
var inst_24976 = (state_25096[(23)]);
var state_25096__$1 = state_25096;
var statearr_25128_25226 = state_25096__$1;
(statearr_25128_25226[(2)] = inst_24976);

(statearr_25128_25226[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (22))){
var inst_25005 = (state_25096[(9)]);
var state_25096__$1 = state_25096;
var statearr_25129_25227 = state_25096__$1;
(statearr_25129_25227[(2)] = inst_25005);

(statearr_25129_25227[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (36))){
var inst_25037 = (state_25096[(24)]);
var inst_25039 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_25040 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25037,inst_25039);
var state_25096__$1 = state_25096;
var statearr_25130_25228 = state_25096__$1;
(statearr_25130_25228[(2)] = inst_25040);

(statearr_25130_25228[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (41))){
var inst_25014 = (state_25096[(19)]);
var inst_25049 = (state_25096[(2)]);
var state_25096__$1 = (function (){var statearr_25131 = state_25096;
(statearr_25131[(25)] = inst_25049);

return statearr_25131;
})();
if(cljs.core.truth_(inst_25014)){
var statearr_25132_25229 = state_25096__$1;
(statearr_25132_25229[(1)] = (42));

} else {
var statearr_25133_25230 = state_25096__$1;
(statearr_25133_25230[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (43))){
var inst_25049 = (state_25096[(25)]);
var state_25096__$1 = state_25096;
var statearr_25134_25231 = state_25096__$1;
(statearr_25134_25231[(2)] = inst_25049);

(statearr_25134_25231[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (29))){
var inst_25020 = (state_25096[(2)]);
var state_25096__$1 = (function (){var statearr_25135 = state_25096;
(statearr_25135[(18)] = inst_25020);

return statearr_25135;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25136_25232 = state_25096__$1;
(statearr_25136_25232[(1)] = (30));

} else {
var statearr_25137_25233 = state_25096__$1;
(statearr_25137_25233[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (44))){
var inst_25055 = (state_25096[(2)]);
var state_25096__$1 = (function (){var statearr_25138 = state_25096;
(statearr_25138[(15)] = inst_25055);

return statearr_25138;
})();
if(cljs.core.truth_(group_limit)){
var statearr_25139_25234 = state_25096__$1;
(statearr_25139_25234[(1)] = (45));

} else {
var statearr_25140_25235 = state_25096__$1;
(statearr_25140_25235[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (6))){
var inst_24968 = cljs.core.count(select);
var inst_24969 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_24968);
var state_25096__$1 = state_25096;
var statearr_25141_25236 = state_25096__$1;
(statearr_25141_25236[(2)] = inst_24969);

(statearr_25141_25236[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (28))){
var inst_25015 = (state_25096[(26)]);
var state_25096__$1 = state_25096;
var statearr_25142_25237 = state_25096__$1;
(statearr_25142_25237[(2)] = inst_25015);

(statearr_25142_25237[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (51))){
var inst_25004 = (state_25096[(10)]);
var inst_25003 = (state_25096[(11)]);
var inst_25072 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_25003,orderBy,inst_25004);
var state_25096__$1 = state_25096;
var statearr_25143_25238 = state_25096__$1;
(statearr_25143_25238[(2)] = inst_25072);

(statearr_25143_25238[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (25))){
var state_25096__$1 = state_25096;
var statearr_25144_25239 = state_25096__$1;
(statearr_25144_25239[(2)] = null);

(statearr_25144_25239[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (34))){
var inst_25031 = (state_25096[(22)]);
var state_25096__$1 = state_25096;
var statearr_25145_25240 = state_25096__$1;
(statearr_25145_25240[(2)] = inst_25031);

(statearr_25145_25240[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (17))){
var inst_24994 = (state_25096[(2)]);
var state_25096__$1 = state_25096;
var statearr_25146_25241 = state_25096__$1;
(statearr_25146_25241[(2)] = inst_24994);

(statearr_25146_25241[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (3))){
var inst_25094 = (state_25096[(2)]);
var state_25096__$1 = state_25096;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25096__$1,inst_25094);
} else {
if((state_val_25097 === (12))){
var inst_24976 = (state_25096[(23)]);
var inst_24978 = cljs.core.first(select);
var inst_24979 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24978);
var inst_24980 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24979);
var inst_24981 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_24980,(1));
var inst_24982 = [inst_24981];
var inst_24983 = [inst_24976];
var inst_24984 = cljs.core.PersistentHashMap.fromArrays(inst_24982,inst_24983);
var state_25096__$1 = state_25096;
var statearr_25147_25242 = state_25096__$1;
(statearr_25147_25242[(2)] = inst_24984);

(statearr_25147_25242[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (2))){
var inst_24966 = (state_25096[(7)]);
var _ = (function (){var statearr_25148 = state_25096;
(statearr_25148[(4)] = cljs.core.cons((5),(state_25096[(4)])));

return statearr_25148;
})();
var inst_24966__$1 = aggregates;
var state_25096__$1 = (function (){var statearr_25149 = state_25096;
(statearr_25149[(7)] = inst_24966__$1);

return statearr_25149;
})();
if(cljs.core.truth_(inst_24966__$1)){
var statearr_25150_25243 = state_25096__$1;
(statearr_25150_25243[(1)] = (6));

} else {
var statearr_25151_25244 = state_25096__$1;
(statearr_25151_25244[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (23))){
var inst_25010 = (state_25096[(2)]);
var state_25096__$1 = state_25096;
if(cljs.core.truth_(inst_25010)){
var statearr_25152_25245 = state_25096__$1;
(statearr_25152_25245[(1)] = (24));

} else {
var statearr_25153_25246 = state_25096__$1;
(statearr_25153_25246[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (47))){
var inst_25061 = (state_25096[(2)]);
var state_25096__$1 = (function (){var statearr_25154 = state_25096;
(statearr_25154[(21)] = inst_25061);

return statearr_25154;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25155_25247 = state_25096__$1;
(statearr_25155_25247[(1)] = (48));

} else {
var statearr_25156_25248 = state_25096__$1;
(statearr_25156_25248[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (35))){
var inst_25037 = (state_25096[(2)]);
var state_25096__$1 = (function (){var statearr_25157 = state_25096;
(statearr_25157[(24)] = inst_25037);

return statearr_25157;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25158_25249 = state_25096__$1;
(statearr_25158_25249[(1)] = (36));

} else {
var statearr_25159_25250 = state_25096__$1;
(statearr_25159_25250[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (19))){
var state_25096__$1 = state_25096;
var statearr_25160_25251 = state_25096__$1;
(statearr_25160_25251[(2)] = res);

(statearr_25160_25251[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (57))){
var inst_25020 = (state_25096[(18)]);
var inst_25081 = (state_25096[(12)]);
var inst_25025 = (state_25096[(20)]);
var inst_25083 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_25025,inst_25020,db,fuel,max_fuel,opts,(8),inst_25081);
var state_25096__$1 = state_25096;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25096__$1,(60),inst_25083);
} else {
if((state_val_25097 === (11))){
var inst_25091 = (state_25096[(2)]);
var _ = (function (){var statearr_25162 = state_25096;
(statearr_25162[(4)] = cljs.core.rest((state_25096[(4)])));

return statearr_25162;
})();
var state_25096__$1 = state_25096;
var statearr_25163_25252 = state_25096__$1;
(statearr_25163_25252[(2)] = inst_25091);

(statearr_25163_25252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (9))){
var inst_24974 = cljs.core.first(aggregates);
var inst_24975 = fluree.db.query.analytical.calculate_aggregate(res,inst_24974);
var inst_24976 = cljs.core.second(inst_24975);
var state_25096__$1 = (function (){var statearr_25164 = state_25096;
(statearr_25164[(23)] = inst_24976);

return statearr_25164;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25165_25253 = state_25096__$1;
(statearr_25165_25253[(1)] = (12));

} else {
var statearr_25166_25254 = state_25096__$1;
(statearr_25166_25254[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (5))){
var _ = (function (){var statearr_25167 = state_25096;
(statearr_25167[(4)] = cljs.core.rest((state_25096[(4)])));

return statearr_25167;
})();
var state_25096__$1 = state_25096;
var ex25161 = (state_25096__$1[(2)]);
var statearr_25168_25255 = state_25096__$1;
(statearr_25168_25255[(5)] = ex25161);


if((ex25161 instanceof Error)){
var statearr_25169_25256 = state_25096__$1;
(statearr_25169_25256[(1)] = (4));

(statearr_25169_25256[(5)] = null);

} else {
throw ex25161;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (14))){
var inst_24987 = (state_25096[(2)]);
var state_25096__$1 = (function (){var statearr_25170 = state_25096;
(statearr_25170[(17)] = inst_24987);

return statearr_25170;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25171_25257 = state_25096__$1;
(statearr_25171_25257[(1)] = (15));

} else {
var statearr_25172_25258 = state_25096__$1;
(statearr_25172_25258[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (45))){
var inst_25055 = (state_25096[(15)]);
var inst_25057 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_25058 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25055,inst_25057);
var state_25096__$1 = state_25096;
var statearr_25173_25259 = state_25096__$1;
(statearr_25173_25259[(2)] = inst_25058);

(statearr_25173_25259[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (53))){
var inst_25075 = (state_25096[(2)]);
var state_25096__$1 = (function (){var statearr_25174 = state_25096;
(statearr_25174[(13)] = inst_25075);

return statearr_25174;
})();
var statearr_25175_25260 = state_25096__$1;
(statearr_25175_25260[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (26))){
var inst_25015 = (state_25096[(26)]);
var inst_25014 = (state_25096[(2)]);
var inst_25015__$1 = cljs.core.not(prettyPrint);
var state_25096__$1 = (function (){var statearr_25177 = state_25096;
(statearr_25177[(19)] = inst_25014);

(statearr_25177[(26)] = inst_25015__$1);

return statearr_25177;
})();
if(inst_25015__$1){
var statearr_25178_25261 = state_25096__$1;
(statearr_25178_25261[(1)] = (27));

} else {
var statearr_25179_25262 = state_25096__$1;
(statearr_25179_25262[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (16))){
var inst_24987 = (state_25096[(17)]);
var state_25096__$1 = state_25096;
var statearr_25180_25263 = state_25096__$1;
(statearr_25180_25263[(2)] = inst_24987);

(statearr_25180_25263[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (38))){
var inst_25043 = (state_25096[(2)]);
var state_25096__$1 = (function (){var statearr_25181 = state_25096;
(statearr_25181[(14)] = inst_25043);

return statearr_25181;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25182_25264 = state_25096__$1;
(statearr_25182_25264[(1)] = (39));

} else {
var statearr_25183_25265 = state_25096__$1;
(statearr_25183_25265[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (30))){
var inst_25022 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_25096__$1 = state_25096;
var statearr_25184_25266 = state_25096__$1;
(statearr_25184_25266[(2)] = inst_25022);

(statearr_25184_25266[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (10))){
var state_25096__$1 = state_25096;
if(cljs.core.truth_(aggregates)){
var statearr_25185_25267 = state_25096__$1;
(statearr_25185_25267[(1)] = (18));

} else {
var statearr_25186_25268 = state_25096__$1;
(statearr_25186_25268[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (18))){
var inst_24998 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_25096__$1 = state_25096;
var statearr_25187_25269 = state_25096__$1;
(statearr_25187_25269[(2)] = inst_24998);

(statearr_25187_25269[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (52))){
var inst_25004 = (state_25096[(10)]);
var state_25096__$1 = state_25096;
var statearr_25188_25270 = state_25096__$1;
(statearr_25188_25270[(2)] = inst_25004);

(statearr_25188_25270[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (42))){
var inst_25049 = (state_25096[(25)]);
var inst_25014 = (state_25096[(19)]);
var inst_25051 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_25014);
var inst_25052 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25049,inst_25051);
var state_25096__$1 = state_25096;
var statearr_25189_25271 = state_25096__$1;
(statearr_25189_25271[(2)] = inst_25052);

(statearr_25189_25271[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (37))){
var inst_25037 = (state_25096[(24)]);
var state_25096__$1 = state_25096;
var statearr_25190_25272 = state_25096__$1;
(statearr_25190_25272[(2)] = inst_25037);

(statearr_25190_25272[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (8))){
var inst_24972 = (state_25096[(2)]);
var state_25096__$1 = state_25096;
if(cljs.core.truth_(inst_24972)){
var statearr_25191_25273 = state_25096__$1;
(statearr_25191_25273[(1)] = (9));

} else {
var statearr_25192_25274 = state_25096__$1;
(statearr_25192_25274[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25097 === (49))){
var inst_25061 = (state_25096[(21)]);
var state_25096__$1 = state_25096;
var statearr_25193_25275 = state_25096__$1;
(statearr_25193_25275[(2)] = inst_25061);

(statearr_25193_25275[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2727__auto__ = null;
var fluree$db$query$fql$state_machine__2727__auto____0 = (function (){
var statearr_25194 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25194[(0)] = fluree$db$query$fql$state_machine__2727__auto__);

(statearr_25194[(1)] = (1));

return statearr_25194;
});
var fluree$db$query$fql$state_machine__2727__auto____1 = (function (state_25096){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25096);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25195){var ex__2730__auto__ = e25195;
var statearr_25196_25276 = state_25096;
(statearr_25196_25276[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25096[(4)]))){
var statearr_25197_25277 = state_25096;
(statearr_25197_25277[(1)] = cljs.core.first((state_25096[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25278 = state_25096;
state_25096 = G__25278;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2727__auto__ = function(state_25096){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2727__auto____1.call(this,state_25096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2727__auto____0;
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2727__auto____1;
return fluree$db$query$fql$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25198 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25198[(6)] = c__2749__auto__);

return statearr_25198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__25281,groupBy){
var map__25282 = p__25281;
var map__25282__$1 = cljs.core.__destructure_map(map__25282);
var res = map__25282__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25282__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25282__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25283 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25283,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25283,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25279_SHARP_){
return fluree.db.util.core.index_of(headers,p1__25279_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25280_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__25280_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__25286 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25286,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25286,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__25289,p__25290,opts){
var map__25291 = p__25289;
var map__25291__$1 = cljs.core.__destructure_map(map__25291);
var res = map__25291__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25291__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25291__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25292 = p__25290;
var map__25292__$1 = cljs.core.__destructure_map(map__25292);
var select_spec = map__25292__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25292__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25292__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25292__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25292__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25292__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25292__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25292__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25534){
var state_val_25535 = (state_25534[(1)]);
if((state_val_25535 === (65))){
var state_25534__$1 = state_25534;
var statearr_25536_25687 = state_25534__$1;
(statearr_25536_25687[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (70))){
var inst_25455 = (state_25534[(7)]);
var state_25534__$1 = state_25534;
var statearr_25538_25688 = state_25534__$1;
(statearr_25538_25688[(2)] = inst_25455);

(statearr_25538_25688[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (62))){
var state_25534__$1 = state_25534;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25539_25689 = state_25534__$1;
(statearr_25539_25689[(1)] = (64));

} else {
var statearr_25540_25690 = state_25534__$1;
(statearr_25540_25690[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (74))){
var inst_25362 = (state_25534[(8)]);
var inst_25371 = (state_25534[(9)]);
var inst_25430 = (state_25534[(10)]);
var inst_25463 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25362,inst_25371,inst_25430);
var state_25534__$1 = state_25534;
var statearr_25541_25691 = state_25534__$1;
(statearr_25541_25691[(2)] = inst_25463);

(statearr_25541_25691[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (7))){
var state_25534__$1 = state_25534;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25542_25692 = state_25534__$1;
(statearr_25542_25692[(1)] = (82));

} else {
var statearr_25543_25693 = state_25534__$1;
(statearr_25543_25693[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (59))){
var inst_25360 = (state_25534[(11)]);
var inst_25430 = (state_25534[(10)]);
var inst_25434 = cljs.core.count(inst_25430);
var inst_25435 = (inst_25360 - inst_25434);
var state_25534__$1 = state_25534;
var statearr_25544_25694 = state_25534__$1;
(statearr_25544_25694[(2)] = inst_25435);

(statearr_25544_25694[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (86))){
var state_25534__$1 = state_25534;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25545_25695 = state_25534__$1;
(statearr_25545_25695[(1)] = (89));

} else {
var statearr_25546_25696 = state_25534__$1;
(statearr_25546_25696[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (20))){
var state_25534__$1 = state_25534;
var statearr_25547_25697 = state_25534__$1;
(statearr_25547_25697[(2)] = (0));

(statearr_25547_25697[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (72))){
var inst_25460 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
if(cljs.core.truth_(inst_25460)){
var statearr_25548_25698 = state_25534__$1;
(statearr_25548_25698[(1)] = (73));

} else {
var statearr_25549_25699 = state_25534__$1;
(statearr_25549_25699[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (58))){
var state_25534__$1 = state_25534;
var statearr_25550_25700 = state_25534__$1;
(statearr_25550_25700[(2)] = null);

(statearr_25550_25700[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (60))){
var inst_25361 = (state_25534[(12)]);
var inst_25437 = (state_25534[(2)]);
var inst_25438 = (inst_25361 <= (0));
var state_25534__$1 = (function (){var statearr_25551 = state_25534;
(statearr_25551[(13)] = inst_25437);

return statearr_25551;
})();
if(cljs.core.truth_(inst_25438)){
var statearr_25552_25701 = state_25534__$1;
(statearr_25552_25701[(1)] = (61));

} else {
var statearr_25553_25702 = state_25534__$1;
(statearr_25553_25702[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (27))){
var inst_25360 = (state_25534[(11)]);
var inst_25384 = (inst_25360 < (1));
var state_25534__$1 = state_25534;
var statearr_25554_25703 = state_25534__$1;
(statearr_25554_25703[(2)] = inst_25384);

(statearr_25554_25703[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (1))){
var state_25534__$1 = state_25534;
var statearr_25555_25704 = state_25534__$1;
(statearr_25555_25704[(2)] = null);

(statearr_25555_25704[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (69))){
var inst_25450 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
var statearr_25556_25705 = state_25534__$1;
(statearr_25556_25705[(2)] = inst_25450);

(statearr_25556_25705[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (24))){
var inst_25362 = (state_25534[(8)]);
var state_25534__$1 = state_25534;
var statearr_25557_25706 = state_25534__$1;
(statearr_25557_25706[(2)] = inst_25362);

(statearr_25557_25706[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (55))){
var inst_25360 = (state_25534[(11)]);
var inst_25420 = (state_25534[(14)]);
var inst_25427 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_25360,inst_25420);
var state_25534__$1 = state_25534;
var statearr_25558_25707 = state_25534__$1;
(statearr_25558_25707[(2)] = inst_25427);

(statearr_25558_25707[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (85))){
var inst_25505 = (state_25534[(15)]);
var inst_25504 = (state_25534[(2)]);
var inst_25505__$1 = fluree.db.util.async.throw_err(inst_25504);
var inst_25506 = cljs.core.coll_QMARK_(inst_25505__$1);
var inst_25507 = (!(inst_25506));
var state_25534__$1 = (function (){var statearr_25559 = state_25534;
(statearr_25559[(15)] = inst_25505__$1);

return statearr_25559;
})();
if(inst_25507){
var statearr_25560_25708 = state_25534__$1;
(statearr_25560_25708[(1)] = (86));

} else {
var statearr_25561_25709 = state_25534__$1;
(statearr_25561_25709[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (39))){
var inst_25379 = (state_25534[(16)]);
var inst_25401 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25402 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25403 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_25379,inst_25401,inst_25402);
var state_25534__$1 = state_25534;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25534__$1,(42),inst_25403);
} else {
if((state_val_25535 === (88))){
var inst_25527 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
var statearr_25562_25710 = state_25534__$1;
(statearr_25562_25710[(2)] = inst_25527);

(statearr_25562_25710[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (46))){
var inst_25361 = (state_25534[(12)]);
var inst_25415 = ((0) < inst_25361);
var state_25534__$1 = state_25534;
if(cljs.core.truth_(inst_25415)){
var statearr_25563_25711 = state_25534__$1;
(statearr_25563_25711[(1)] = (49));

} else {
var statearr_25564_25712 = state_25534__$1;
(statearr_25564_25712[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (4))){
var inst_25293 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
var statearr_25565_25713 = state_25534__$1;
(statearr_25565_25713[(2)] = inst_25293);

(statearr_25565_25713[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (77))){
var inst_25360 = (state_25534[(11)]);
var inst_25471 = (inst_25360 - (1));
var state_25534__$1 = state_25534;
var statearr_25566_25714 = state_25534__$1;
(statearr_25566_25714[(2)] = inst_25471);

(statearr_25566_25714[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (95))){
var inst_25505 = (state_25534[(15)]);
var state_25534__$1 = state_25534;
var statearr_25567_25715 = state_25534__$1;
(statearr_25567_25715[(2)] = inst_25505);

(statearr_25567_25715[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (54))){
var inst_25425 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
if(cljs.core.truth_(inst_25425)){
var statearr_25568_25716 = state_25534__$1;
(statearr_25568_25716[(1)] = (55));

} else {
var statearr_25569_25717 = state_25534__$1;
(statearr_25569_25717[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (92))){
var inst_25505 = (state_25534[(15)]);
var inst_25518 = cljs.core.first(inst_25505);
var state_25534__$1 = state_25534;
var statearr_25570_25718 = state_25534__$1;
(statearr_25570_25718[(2)] = inst_25518);

(statearr_25570_25718[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (15))){
var inst_25311 = (state_25534[(17)]);
var inst_25319 = (state_25534[(2)]);
var inst_25320 = fluree.db.util.async.throw_err(inst_25319);
var inst_25321 = [inst_25311];
var inst_25322 = [inst_25320];
var inst_25323 = cljs.core.PersistentHashMap.fromArrays(inst_25321,inst_25322);
var state_25534__$1 = state_25534;
var statearr_25571_25719 = state_25534__$1;
(statearr_25571_25719[(2)] = inst_25323);

(statearr_25571_25719[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (48))){
var inst_25483 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
var statearr_25572_25720 = state_25534__$1;
(statearr_25572_25720[(2)] = inst_25483);

(statearr_25572_25720[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (50))){
var inst_25406 = (state_25534[(18)]);
var state_25534__$1 = state_25534;
var statearr_25573_25721 = state_25534__$1;
(statearr_25573_25721[(2)] = inst_25406);

(statearr_25573_25721[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (75))){
var inst_25375 = (state_25534[(19)]);
var inst_25437 = (state_25534[(13)]);
var inst_25372 = (state_25534[(20)]);
var inst_25454 = (state_25534[(21)]);
var inst_25465 = (state_25534[(2)]);
var inst_25358 = inst_25372;
var inst_25359 = inst_25375;
var inst_25360 = inst_25437;
var inst_25361 = inst_25454;
var inst_25362 = inst_25465;
var state_25534__$1 = (function (){var statearr_25574 = state_25534;
(statearr_25574[(8)] = inst_25362);

(statearr_25574[(22)] = inst_25358);

(statearr_25574[(11)] = inst_25360);

(statearr_25574[(12)] = inst_25361);

(statearr_25574[(23)] = inst_25359);

return statearr_25574;
})();
var statearr_25575_25722 = state_25534__$1;
(statearr_25575_25722[(2)] = null);

(statearr_25575_25722[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (21))){
var inst_25343 = (state_25534[(24)]);
var inst_25339 = (state_25534[(25)]);
var inst_25351 = (state_25534[(26)]);
var inst_25356 = (state_25534[(2)]);
var inst_25357 = cljs.core.PersistentHashMap.EMPTY;
var inst_25358 = inst_25339;
var inst_25359 = inst_25343;
var inst_25360 = inst_25351;
var inst_25361 = inst_25356;
var inst_25362 = inst_25357;
var state_25534__$1 = (function (){var statearr_25576 = state_25534;
(statearr_25576[(8)] = inst_25362);

(statearr_25576[(22)] = inst_25358);

(statearr_25576[(11)] = inst_25360);

(statearr_25576[(12)] = inst_25361);

(statearr_25576[(23)] = inst_25359);

return statearr_25576;
})();
var statearr_25577_25723 = state_25534__$1;
(statearr_25577_25723[(2)] = null);

(statearr_25577_25723[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (31))){
var inst_25376 = (state_25534[(27)]);
var inst_25361 = (state_25534[(12)]);
var inst_25390 = (inst_25361 >= inst_25376);
var state_25534__$1 = state_25534;
if(cljs.core.truth_(inst_25390)){
var statearr_25578_25724 = state_25534__$1;
(statearr_25578_25724[(1)] = (33));

} else {
var statearr_25579_25725 = state_25534__$1;
(statearr_25579_25725[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (32))){
var inst_25490 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
var statearr_25580_25726 = state_25534__$1;
(statearr_25580_25726[(2)] = inst_25490);

(statearr_25580_25726[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (40))){
var state_25534__$1 = state_25534;
var statearr_25581_25727 = state_25534__$1;
(statearr_25581_25727[(2)] = null);

(statearr_25581_25727[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (91))){
var inst_25515 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
var statearr_25582_25728 = state_25534__$1;
(statearr_25582_25728[(2)] = inst_25515);

(statearr_25582_25728[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (56))){
var inst_25420 = (state_25534[(14)]);
var state_25534__$1 = state_25534;
var statearr_25583_25729 = state_25534__$1;
(statearr_25583_25729[(2)] = inst_25420);

(statearr_25583_25729[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (33))){
var state_25534__$1 = state_25534;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25584_25730 = state_25534__$1;
(statearr_25584_25730[(1)] = (36));

} else {
var statearr_25585_25731 = state_25534__$1;
(statearr_25585_25731[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (13))){
var inst_25343 = (state_25534[(24)]);
var inst_25339 = (state_25534[(25)]);
var inst_25308 = (state_25534[(28)]);
var inst_25339__$1 = cljs.core.keys(inst_25308);
var inst_25340 = cljs.core.seq(inst_25339__$1);
var inst_25341 = cljs.core.first(inst_25340);
var inst_25342 = cljs.core.next(inst_25340);
var inst_25343__$1 = cljs.core.vals(inst_25308);
var inst_25344 = cljs.core.seq(inst_25343__$1);
var inst_25345 = cljs.core.first(inst_25344);
var inst_25346 = cljs.core.next(inst_25344);
var inst_25347 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_25534__$1 = (function (){var statearr_25586 = state_25534;
(statearr_25586[(24)] = inst_25343__$1);

(statearr_25586[(25)] = inst_25339__$1);

(statearr_25586[(29)] = inst_25341);

(statearr_25586[(30)] = inst_25345);

(statearr_25586[(31)] = inst_25342);

(statearr_25586[(32)] = inst_25346);

return statearr_25586;
})();
if(inst_25347){
var statearr_25587_25732 = state_25534__$1;
(statearr_25587_25732[(1)] = (16));

} else {
var statearr_25588_25733 = state_25534__$1;
(statearr_25588_25733[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (22))){
var inst_25358 = (state_25534[(22)]);
var inst_25359 = (state_25534[(23)]);
var inst_25370 = cljs.core.seq(inst_25358);
var inst_25371 = cljs.core.first(inst_25370);
var inst_25372 = cljs.core.next(inst_25370);
var inst_25373 = cljs.core.seq(inst_25359);
var inst_25374 = cljs.core.first(inst_25373);
var inst_25375 = cljs.core.next(inst_25373);
var inst_25376 = cljs.core.count(inst_25374);
var inst_25377 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25378 = [headers,vars,inst_25374];
var inst_25379 = cljs.core.PersistentHashMap.fromArrays(inst_25377,inst_25378);
var inst_25380 = (inst_25374 == null);
var state_25534__$1 = (function (){var statearr_25589 = state_25534;
(statearr_25589[(19)] = inst_25375);

(statearr_25589[(16)] = inst_25379);

(statearr_25589[(9)] = inst_25371);

(statearr_25589[(27)] = inst_25376);

(statearr_25589[(20)] = inst_25372);

return statearr_25589;
})();
if(cljs.core.truth_(inst_25380)){
var statearr_25590_25734 = state_25534__$1;
(statearr_25590_25734[(1)] = (24));

} else {
var statearr_25591_25735 = state_25534__$1;
(statearr_25591_25735[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (90))){
var inst_25505 = (state_25534[(15)]);
var state_25534__$1 = state_25534;
var statearr_25592_25736 = state_25534__$1;
(statearr_25592_25736[(2)] = inst_25505);

(statearr_25592_25736[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (36))){
var inst_25361 = (state_25534[(12)]);
var inst_25393 = (inst_25361 - (1));
var state_25534__$1 = state_25534;
var statearr_25593_25737 = state_25534__$1;
(statearr_25593_25737[(2)] = inst_25393);

(statearr_25593_25737[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (41))){
var inst_25486 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
var statearr_25594_25738 = state_25534__$1;
(statearr_25594_25738[(2)] = inst_25486);

(statearr_25594_25738[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (89))){
var inst_25505 = (state_25534[(15)]);
var inst_25510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25511 = [inst_25505];
var inst_25512 = (new cljs.core.PersistentVector(null,1,(5),inst_25510,inst_25511,null));
var state_25534__$1 = state_25534;
var statearr_25595_25739 = state_25534__$1;
(statearr_25595_25739[(2)] = inst_25512);

(statearr_25595_25739[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (43))){
var inst_25406 = (state_25534[(18)]);
var inst_25409 = cljs.core.seq(inst_25406);
var state_25534__$1 = state_25534;
var statearr_25596_25740 = state_25534__$1;
(statearr_25596_25740[(2)] = inst_25409);

(statearr_25596_25740[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (61))){
var state_25534__$1 = state_25534;
var statearr_25597_25741 = state_25534__$1;
(statearr_25597_25741[(2)] = (0));

(statearr_25597_25741[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (29))){
var inst_25387 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
if(cljs.core.truth_(inst_25387)){
var statearr_25598_25742 = state_25534__$1;
(statearr_25598_25742[(1)] = (30));

} else {
var statearr_25599_25743 = state_25534__$1;
(statearr_25599_25743[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (44))){
var inst_25407 = (state_25534[(33)]);
var state_25534__$1 = state_25534;
var statearr_25600_25744 = state_25534__$1;
(statearr_25600_25744[(2)] = inst_25407);

(statearr_25600_25744[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (93))){
var state_25534__$1 = state_25534;
var statearr_25601_25745 = state_25534__$1;
(statearr_25601_25745[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (6))){
var inst_25300 = (state_25534[(34)]);
var inst_25300__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_25302 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_25534__$1 = (function (){var statearr_25603 = state_25534;
(statearr_25603[(34)] = inst_25300__$1);

(statearr_25603[(35)] = inst_25302);

return statearr_25603;
})();
if(cljs.core.truth_(inst_25300__$1)){
var statearr_25604_25746 = state_25534__$1;
(statearr_25604_25746[(1)] = (9));

} else {
var statearr_25605_25747 = state_25534__$1;
(statearr_25605_25747[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (28))){
var inst_25360 = (state_25534[(11)]);
var state_25534__$1 = state_25534;
var statearr_25606_25748 = state_25534__$1;
(statearr_25606_25748[(2)] = inst_25360);

(statearr_25606_25748[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (64))){
var inst_25361 = (state_25534[(12)]);
var inst_25442 = (inst_25361 - (1));
var state_25534__$1 = state_25534;
var statearr_25607_25749 = state_25534__$1;
(statearr_25607_25749[(2)] = inst_25442);

(statearr_25607_25749[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (51))){
var inst_25360 = (state_25534[(11)]);
var inst_25420 = (state_25534[(2)]);
var state_25534__$1 = (function (){var statearr_25608 = state_25534;
(statearr_25608[(14)] = inst_25420);

return statearr_25608;
})();
if(cljs.core.truth_(inst_25360)){
var statearr_25609_25750 = state_25534__$1;
(statearr_25609_25750[(1)] = (52));

} else {
var statearr_25610_25751 = state_25534__$1;
(statearr_25610_25751[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (25))){
var inst_25360 = (state_25534[(11)]);
var state_25534__$1 = state_25534;
if(cljs.core.truth_(inst_25360)){
var statearr_25611_25752 = state_25534__$1;
(statearr_25611_25752[(1)] = (27));

} else {
var statearr_25612_25753 = state_25534__$1;
(statearr_25612_25753[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (34))){
var state_25534__$1 = state_25534;
var statearr_25613_25754 = state_25534__$1;
(statearr_25613_25754[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (17))){
var state_25534__$1 = state_25534;
var statearr_25615_25755 = state_25534__$1;
(statearr_25615_25755[(2)] = limit);

(statearr_25615_25755[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (3))){
var inst_25532 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25534__$1,inst_25532);
} else {
if((state_val_25535 === (12))){
var inst_25308 = (state_25534[(28)]);
var inst_25310 = cljs.core.keys(inst_25308);
var inst_25311 = cljs.core.first(inst_25310);
var inst_25312 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25313 = cljs.core.vals(inst_25308);
var inst_25314 = cljs.core.first(inst_25313);
var inst_25315 = [headers,vars,inst_25314];
var inst_25316 = cljs.core.PersistentHashMap.fromArrays(inst_25312,inst_25315);
var inst_25317 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_25316,select_spec,limit,opts);
var state_25534__$1 = (function (){var statearr_25616 = state_25534;
(statearr_25616[(17)] = inst_25311);

return statearr_25616;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25534__$1,(15),inst_25317);
} else {
if((state_val_25535 === (2))){
var _ = (function (){var statearr_25617 = state_25534;
(statearr_25617[(4)] = cljs.core.cons((5),(state_25534[(4)])));

return statearr_25617;
})();
var state_25534__$1 = state_25534;
if(cljs.core.truth_(groupBy)){
var statearr_25618_25756 = state_25534__$1;
(statearr_25618_25756[(1)] = (6));

} else {
var statearr_25619_25757 = state_25534__$1;
(statearr_25619_25757[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (66))){
var inst_25452 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
var statearr_25620_25758 = state_25534__$1;
(statearr_25620_25758[(2)] = inst_25452);

(statearr_25620_25758[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (23))){
var inst_25494 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
var statearr_25621_25759 = state_25534__$1;
(statearr_25621_25759[(2)] = inst_25494);

(statearr_25621_25759[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (47))){
var inst_25360 = (state_25534[(11)]);
var inst_25468 = (inst_25360 == null);
var state_25534__$1 = state_25534;
if(cljs.core.truth_(inst_25468)){
var statearr_25622_25760 = state_25534__$1;
(statearr_25622_25760[(1)] = (76));

} else {
var statearr_25623_25761 = state_25534__$1;
(statearr_25623_25761[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (35))){
var inst_25488 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
var statearr_25624_25762 = state_25534__$1;
(statearr_25624_25762[(2)] = inst_25488);

(statearr_25624_25762[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (82))){
var state_25534__$1 = state_25534;
var statearr_25625_25763 = state_25534__$1;
(statearr_25625_25763[(2)] = (1));

(statearr_25625_25763[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (76))){
var state_25534__$1 = state_25534;
var statearr_25626_25764 = state_25534__$1;
(statearr_25626_25764[(2)] = null);

(statearr_25626_25764[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (97))){
var inst_25523 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
var statearr_25627_25765 = state_25534__$1;
(statearr_25627_25765[(2)] = inst_25523);

(statearr_25627_25765[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (19))){
var inst_25352 = (state_25534[(36)]);
var state_25534__$1 = state_25534;
var statearr_25628_25766 = state_25534__$1;
(statearr_25628_25766[(2)] = inst_25352);

(statearr_25628_25766[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (57))){
var inst_25360 = (state_25534[(11)]);
var inst_25430 = (state_25534[(2)]);
var inst_25431 = (inst_25360 == null);
var state_25534__$1 = (function (){var statearr_25629 = state_25534;
(statearr_25629[(10)] = inst_25430);

return statearr_25629;
})();
if(cljs.core.truth_(inst_25431)){
var statearr_25630_25767 = state_25534__$1;
(statearr_25630_25767[(1)] = (58));

} else {
var statearr_25631_25768 = state_25534__$1;
(statearr_25631_25768[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (68))){
var state_25534__$1 = state_25534;
var statearr_25632_25769 = state_25534__$1;
(statearr_25632_25769[(2)] = null);

(statearr_25632_25769[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (11))){
var inst_25308 = (state_25534[(2)]);
var state_25534__$1 = (function (){var statearr_25634 = state_25534;
(statearr_25634[(28)] = inst_25308);

return statearr_25634;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25635_25770 = state_25534__$1;
(statearr_25635_25770[(1)] = (12));

} else {
var statearr_25636_25771 = state_25534__$1;
(statearr_25636_25771[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (9))){
var inst_25300 = (state_25534[(34)]);
var inst_25302 = (state_25534[(35)]);
var inst_25304 = cljs.core.sorted_map_by(inst_25300);
var inst_25305 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25304,inst_25302);
var state_25534__$1 = state_25534;
var statearr_25637_25772 = state_25534__$1;
(statearr_25637_25772[(2)] = inst_25305);

(statearr_25637_25772[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (5))){
var _ = (function (){var statearr_25638 = state_25534;
(statearr_25638[(4)] = cljs.core.rest((state_25534[(4)])));

return statearr_25638;
})();
var state_25534__$1 = state_25534;
var ex25633 = (state_25534__$1[(2)]);
var statearr_25639_25773 = state_25534__$1;
(statearr_25639_25773[(5)] = ex25633);


if((ex25633 instanceof Error)){
var statearr_25640_25774 = state_25534__$1;
(statearr_25640_25774[(1)] = (4));

(statearr_25640_25774[(5)] = null);

} else {
throw ex25633;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (83))){
var state_25534__$1 = state_25534;
var statearr_25641_25775 = state_25534__$1;
(statearr_25641_25775[(2)] = limit);

(statearr_25641_25775[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (14))){
var inst_25496 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
var statearr_25642_25776 = state_25534__$1;
(statearr_25642_25776[(2)] = inst_25496);

(statearr_25642_25776[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (45))){
var inst_25412 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
if(cljs.core.truth_(inst_25412)){
var statearr_25643_25777 = state_25534__$1;
(statearr_25643_25777[(1)] = (46));

} else {
var statearr_25644_25778 = state_25534__$1;
(statearr_25644_25778[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (53))){
var inst_25360 = (state_25534[(11)]);
var state_25534__$1 = state_25534;
var statearr_25645_25779 = state_25534__$1;
(statearr_25645_25779[(2)] = inst_25360);

(statearr_25645_25779[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (78))){
var inst_25361 = (state_25534[(12)]);
var inst_25473 = (state_25534[(2)]);
var inst_25474 = (inst_25361 <= (0));
var state_25534__$1 = (function (){var statearr_25646 = state_25534;
(statearr_25646[(37)] = inst_25473);

return statearr_25646;
})();
if(cljs.core.truth_(inst_25474)){
var statearr_25647_25780 = state_25534__$1;
(statearr_25647_25780[(1)] = (79));

} else {
var statearr_25648_25781 = state_25534__$1;
(statearr_25648_25781[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (26))){
var inst_25492 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
var statearr_25649_25782 = state_25534__$1;
(statearr_25649_25782[(2)] = inst_25492);

(statearr_25649_25782[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (16))){
var state_25534__$1 = state_25534;
var statearr_25650_25783 = state_25534__$1;
(statearr_25650_25783[(2)] = null);

(statearr_25650_25783[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (81))){
var inst_25375 = (state_25534[(19)]);
var inst_25362 = (state_25534[(8)]);
var inst_25371 = (state_25534[(9)]);
var inst_25406 = (state_25534[(18)]);
var inst_25372 = (state_25534[(20)]);
var inst_25473 = (state_25534[(37)]);
var inst_25479 = (state_25534[(2)]);
var inst_25480 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25362,inst_25371,inst_25406);
var inst_25358 = inst_25372;
var inst_25359 = inst_25375;
var inst_25360 = inst_25473;
var inst_25361 = inst_25479;
var inst_25362__$1 = inst_25480;
var state_25534__$1 = (function (){var statearr_25653 = state_25534;
(statearr_25653[(8)] = inst_25362__$1);

(statearr_25653[(22)] = inst_25358);

(statearr_25653[(11)] = inst_25360);

(statearr_25653[(12)] = inst_25361);

(statearr_25653[(23)] = inst_25359);

return statearr_25653;
})();
var statearr_25654_25784 = state_25534__$1;
(statearr_25654_25784[(2)] = null);

(statearr_25654_25784[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (79))){
var state_25534__$1 = state_25534;
var statearr_25655_25785 = state_25534__$1;
(statearr_25655_25785[(2)] = (0));

(statearr_25655_25785[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (38))){
var inst_25375 = (state_25534[(19)]);
var inst_25362 = (state_25534[(8)]);
var inst_25360 = (state_25534[(11)]);
var inst_25372 = (state_25534[(20)]);
var inst_25397 = (state_25534[(2)]);
var tmp25651 = inst_25362;
var tmp25652 = inst_25360;
var inst_25358 = inst_25372;
var inst_25359 = inst_25375;
var inst_25360__$1 = tmp25652;
var inst_25361 = inst_25397;
var inst_25362__$1 = tmp25651;
var state_25534__$1 = (function (){var statearr_25656 = state_25534;
(statearr_25656[(8)] = inst_25362__$1);

(statearr_25656[(22)] = inst_25358);

(statearr_25656[(11)] = inst_25360__$1);

(statearr_25656[(12)] = inst_25361);

(statearr_25656[(23)] = inst_25359);

return statearr_25656;
})();
var statearr_25657_25786 = state_25534__$1;
(statearr_25657_25786[(2)] = null);

(statearr_25657_25786[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (87))){
var state_25534__$1 = state_25534;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25658_25787 = state_25534__$1;
(statearr_25658_25787[(1)] = (92));

} else {
var statearr_25659_25788 = state_25534__$1;
(statearr_25659_25788[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (30))){
var inst_25362 = (state_25534[(8)]);
var state_25534__$1 = state_25534;
var statearr_25660_25789 = state_25534__$1;
(statearr_25660_25789[(2)] = inst_25362);

(statearr_25660_25789[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (73))){
var inst_25362 = (state_25534[(8)]);
var state_25534__$1 = state_25534;
var statearr_25661_25790 = state_25534__$1;
(statearr_25661_25790[(2)] = inst_25362);

(statearr_25661_25790[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (96))){
var state_25534__$1 = state_25534;
var statearr_25662_25791 = state_25534__$1;
(statearr_25662_25791[(2)] = null);

(statearr_25662_25791[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (10))){
var inst_25302 = (state_25534[(35)]);
var state_25534__$1 = state_25534;
var statearr_25663_25792 = state_25534__$1;
(statearr_25663_25792[(2)] = inst_25302);

(statearr_25663_25792[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (18))){
var inst_25352 = (state_25534[(36)]);
var inst_25351 = (state_25534[(2)]);
var inst_25352__$1 = offset;
var state_25534__$1 = (function (){var statearr_25664 = state_25534;
(statearr_25664[(26)] = inst_25351);

(statearr_25664[(36)] = inst_25352__$1);

return statearr_25664;
})();
if(cljs.core.truth_(inst_25352__$1)){
var statearr_25665_25793 = state_25534__$1;
(statearr_25665_25793[(1)] = (19));

} else {
var statearr_25666_25794 = state_25534__$1;
(statearr_25666_25794[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (52))){
var inst_25360 = (state_25534[(11)]);
var inst_25422 = ((0) < inst_25360);
var state_25534__$1 = state_25534;
var statearr_25667_25795 = state_25534__$1;
(statearr_25667_25795[(2)] = inst_25422);

(statearr_25667_25795[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (67))){
var inst_25376 = (state_25534[(27)]);
var inst_25361 = (state_25534[(12)]);
var inst_25430 = (state_25534[(10)]);
var inst_25445 = cljs.core.count(inst_25430);
var inst_25446 = (inst_25376 - inst_25445);
var inst_25447 = (inst_25361 - inst_25446);
var state_25534__$1 = state_25534;
var statearr_25668_25796 = state_25534__$1;
(statearr_25668_25796[(2)] = inst_25447);

(statearr_25668_25796[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (71))){
var inst_25430 = (state_25534[(10)]);
var inst_25458 = cljs.core.empty_QMARK_(inst_25430);
var state_25534__$1 = state_25534;
var statearr_25669_25797 = state_25534__$1;
(statearr_25669_25797[(2)] = inst_25458);

(statearr_25669_25797[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (42))){
var inst_25406 = (state_25534[(18)]);
var inst_25407 = (state_25534[(33)]);
var inst_25405 = (state_25534[(2)]);
var inst_25406__$1 = fluree.db.util.async.throw_err(inst_25405);
var inst_25407__$1 = cljs.core.coll_QMARK_(inst_25406__$1);
var state_25534__$1 = (function (){var statearr_25670 = state_25534;
(statearr_25670[(18)] = inst_25406__$1);

(statearr_25670[(33)] = inst_25407__$1);

return statearr_25670;
})();
if(inst_25407__$1){
var statearr_25671_25798 = state_25534__$1;
(statearr_25671_25798[(1)] = (43));

} else {
var statearr_25672_25799 = state_25534__$1;
(statearr_25672_25799[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (80))){
var inst_25361 = (state_25534[(12)]);
var inst_25477 = (inst_25361 - (1));
var state_25534__$1 = state_25534;
var statearr_25673_25800 = state_25534__$1;
(statearr_25673_25800[(2)] = inst_25477);

(statearr_25673_25800[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (37))){
var inst_25376 = (state_25534[(27)]);
var inst_25361 = (state_25534[(12)]);
var inst_25395 = (inst_25361 - inst_25376);
var state_25534__$1 = state_25534;
var statearr_25674_25801 = state_25534__$1;
(statearr_25674_25801[(2)] = inst_25395);

(statearr_25674_25801[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (63))){
var inst_25455 = (state_25534[(7)]);
var inst_25430 = (state_25534[(10)]);
var inst_25454 = (state_25534[(2)]);
var inst_25455__$1 = (inst_25430 == null);
var state_25534__$1 = (function (){var statearr_25675 = state_25534;
(statearr_25675[(21)] = inst_25454);

(statearr_25675[(7)] = inst_25455__$1);

return statearr_25675;
})();
if(cljs.core.truth_(inst_25455__$1)){
var statearr_25676_25802 = state_25534__$1;
(statearr_25676_25802[(1)] = (70));

} else {
var statearr_25677_25803 = state_25534__$1;
(statearr_25677_25803[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (94))){
var inst_25525 = (state_25534[(2)]);
var state_25534__$1 = state_25534;
var statearr_25678_25804 = state_25534__$1;
(statearr_25678_25804[(2)] = inst_25525);

(statearr_25678_25804[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (8))){
var inst_25529 = (state_25534[(2)]);
var _ = (function (){var statearr_25679 = state_25534;
(statearr_25679[(4)] = cljs.core.rest((state_25534[(4)])));

return statearr_25679;
})();
var state_25534__$1 = state_25534;
var statearr_25680_25805 = state_25534__$1;
(statearr_25680_25805[(2)] = inst_25529);

(statearr_25680_25805[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (49))){
var inst_25406 = (state_25534[(18)]);
var inst_25361 = (state_25534[(12)]);
var inst_25417 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_25361,inst_25406);
var state_25534__$1 = state_25534;
var statearr_25681_25806 = state_25534__$1;
(statearr_25681_25806[(2)] = inst_25417);

(statearr_25681_25806[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25535 === (84))){
var inst_25501 = (state_25534[(2)]);
var inst_25502 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_25501,opts);
var state_25534__$1 = state_25534;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25534__$1,(85),inst_25502);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0 = (function (){
var statearr_25682 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25682[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__);

(statearr_25682[(1)] = (1));

return statearr_25682;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1 = (function (state_25534){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25534);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25683){var ex__2730__auto__ = e25683;
var statearr_25684_25807 = state_25534;
(statearr_25684_25807[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25534[(4)]))){
var statearr_25685_25808 = state_25534;
(statearr_25685_25808[(1)] = cljs.core.first((state_25534[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25809 = state_25534;
state_25534 = G__25809;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__ = function(state_25534){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1.call(this,state_25534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25686 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25686[(6)] = c__2749__auto__);

return statearr_25686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__25812,opts){
var map__25813 = p__25812;
var map__25813__$1 = cljs.core.__destructure_map(map__25813);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25813__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25813__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25813__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25813__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4253__auto__ = selectOne;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = select;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__25810_SHARP_){
return cljs.core.contains_QMARK_(p1__25810_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__25811_SHARP_){
return cljs.core.contains_QMARK_(p1__25811_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4253__auto__ = typeof orderBy === 'string';
if(or__4253__auto__){
return or__4253__auto__;
} else {
var and__4251__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4251__auto__){
var G__25815 = cljs.core.first(orderBy);
var fexpr__25814 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__25814.cljs$core$IFn$_invoke$arity$1 ? fexpr__25814.cljs$core$IFn$_invoke$arity$1(G__25815) : fexpr__25814.call(null,G__25815));
} else {
return and__4251__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (100);
}
})(),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4253__auto__ = selectDistinct;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__25816,p__25817){
var map__25818 = p__25816;
var map__25818__$1 = cljs.core.__destructure_map(map__25818);
var query_map = map__25818__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25818__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__25819 = p__25817;
var map__25819__$1 = cljs.core.__destructure_map(map__25819);
var where_result = map__25819__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25819__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25819__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25820 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25820,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25820,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25820,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25853){
var state_val_25854 = (state_25853[(1)]);
if((state_val_25854 === (7))){
var inst_25832 = (state_25853[(7)]);
var state_25853__$1 = state_25853;
var statearr_25855_25878 = state_25853__$1;
(statearr_25855_25878[(2)] = inst_25832);

(statearr_25855_25878[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25854 === (1))){
var state_25853__$1 = state_25853;
var statearr_25856_25879 = state_25853__$1;
(statearr_25856_25879[(2)] = null);

(statearr_25856_25879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25854 === (4))){
var inst_25823 = (state_25853[(2)]);
var state_25853__$1 = state_25853;
var statearr_25857_25880 = state_25853__$1;
(statearr_25857_25880[(2)] = inst_25823);

(statearr_25857_25880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25854 === (13))){
var inst_25842 = (state_25853[(2)]);
var inst_25843 = fluree.db.util.async.throw_err(inst_25842);
var state_25853__$1 = state_25853;
var statearr_25858_25881 = state_25853__$1;
(statearr_25858_25881[(2)] = inst_25843);

(statearr_25858_25881[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25854 === (6))){
var inst_25832 = (state_25853[(7)]);
var inst_25831 = (state_25853[(2)]);
var inst_25832__$1 = fluree.db.util.async.throw_err(inst_25831);
var inst_25833 = fluree.db.util.core.exception_QMARK_(inst_25832__$1);
var state_25853__$1 = (function (){var statearr_25859 = state_25853;
(statearr_25859[(7)] = inst_25832__$1);

return statearr_25859;
})();
if(inst_25833){
var statearr_25860_25882 = state_25853__$1;
(statearr_25860_25882[(1)] = (7));

} else {
var statearr_25861_25883 = state_25853__$1;
(statearr_25861_25883[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25854 === (3))){
var inst_25851 = (state_25853[(2)]);
var state_25853__$1 = state_25853;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25853__$1,inst_25851);
} else {
if((state_val_25854 === (12))){
var inst_25846 = (state_25853[(2)]);
var state_25853__$1 = state_25853;
var statearr_25862_25884 = state_25853__$1;
(statearr_25862_25884[(2)] = inst_25846);

(statearr_25862_25884[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25854 === (2))){
var _ = (function (){var statearr_25863 = state_25853;
(statearr_25863[(4)] = cljs.core.cons((5),(state_25853[(4)])));

return statearr_25863;
})();
var inst_25829 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_25853__$1 = state_25853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25853__$1,(6),inst_25829);
} else {
if((state_val_25854 === (11))){
var state_25853__$1 = state_25853;
var statearr_25865_25885 = state_25853__$1;
(statearr_25865_25885[(2)] = null);

(statearr_25865_25885[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25854 === (9))){
var inst_25848 = (state_25853[(2)]);
var _ = (function (){var statearr_25866 = state_25853;
(statearr_25866[(4)] = cljs.core.rest((state_25853[(4)])));

return statearr_25866;
})();
var state_25853__$1 = state_25853;
var statearr_25867_25886 = state_25853__$1;
(statearr_25867_25886[(2)] = inst_25848);

(statearr_25867_25886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25854 === (5))){
var _ = (function (){var statearr_25868 = state_25853;
(statearr_25868[(4)] = cljs.core.rest((state_25853[(4)])));

return statearr_25868;
})();
var state_25853__$1 = state_25853;
var ex25864 = (state_25853__$1[(2)]);
var statearr_25869_25887 = state_25853__$1;
(statearr_25869_25887[(5)] = ex25864);


if((ex25864 instanceof Error)){
var statearr_25870_25888 = state_25853__$1;
(statearr_25870_25888[(1)] = (4));

(statearr_25870_25888[(5)] = null);

} else {
throw ex25864;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25854 === (10))){
var inst_25832 = (state_25853[(7)]);
var inst_25837 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_25832);
var inst_25838 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_25832);
var inst_25839 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_25837,inst_25838,query_map,opts);
var inst_25840 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_25832,inst_25839,opts);
var state_25853__$1 = state_25853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25853__$1,(13),inst_25840);
} else {
if((state_val_25854 === (8))){
var state_25853__$1 = state_25853;
var statearr_25871_25889 = state_25853__$1;
(statearr_25871_25889[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0 = (function (){
var statearr_25873 = [null,null,null,null,null,null,null,null];
(statearr_25873[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__);

(statearr_25873[(1)] = (1));

return statearr_25873;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1 = (function (state_25853){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25853);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25874){var ex__2730__auto__ = e25874;
var statearr_25875_25890 = state_25853;
(statearr_25875_25890[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25853[(4)]))){
var statearr_25876_25891 = state_25853;
(statearr_25876_25891[(1)] = cljs.core.first((state_25853[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25892 = state_25853;
state_25853 = G__25892;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__ = function(state_25853){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1.call(this,state_25853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25877 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25877[(6)] = c__2749__auto__);

return statearr_25877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Running query:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0))], 0));

var map__25893 = query_map;
var map__25893__$1 = cljs.core.__destructure_map(map__25893);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25893__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25893__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25893__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25893__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25893__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25893__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25893__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25893__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25893__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25893__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25893__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25893__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__25894 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4253__auto__ = offset;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__25894,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__25894;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.truth_((function (){var or__4253__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26252){
var state_val_26253 = (state_26252[(1)]);
if((state_val_26253 === (121))){
var inst_26213 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
var statearr_26254_26449 = state_26252__$1;
(statearr_26254_26449[(2)] = inst_26213);

(statearr_26254_26449[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (65))){
var inst_26090 = typeof from === 'string';
var state_26252__$1 = state_26252;
if(cljs.core.truth_(inst_26090)){
var statearr_26255_26450 = state_26252__$1;
(statearr_26255_26450[(1)] = (72));

} else {
var statearr_26256_26451 = state_26252__$1;
(statearr_26256_26451[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (70))){
var inst_25958 = (state_26252[(7)]);
var inst_25956 = (state_26252[(8)]);
var inst_26083 = (state_26252[(2)]);
var inst_26084 = fluree.db.util.async.throw_err(inst_26083);
var inst_26085 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_25958,fuel,max_fuel,inst_25956,inst_26084);
var state_26252__$1 = state_26252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26252__$1,(71),inst_26085);
} else {
if((state_val_26253 === (62))){
var inst_26063 = (state_26252[(9)]);
var state_26252__$1 = state_26252;
var statearr_26257_26452 = state_26252__$1;
(statearr_26257_26452[(2)] = inst_26063);

(statearr_26257_26452[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (74))){
var inst_26219 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
var statearr_26258_26453 = state_26252__$1;
(statearr_26258_26453[(2)] = inst_26219);

(statearr_26258_26453[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (110))){
var inst_26154 = (state_26252[(10)]);
var state_26252__$1 = state_26252;
var statearr_26259_26454 = state_26252__$1;
(statearr_26259_26454[(2)] = inst_26154);

(statearr_26259_26454[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (130))){
var inst_26239 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
var statearr_26260_26455 = state_26252__$1;
(statearr_26260_26455[(2)] = inst_26239);

(statearr_26260_26455[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (128))){
var inst_26230 = (state_26252[(11)]);
var inst_26235 = fluree.db.util.core.exception_QMARK_(inst_26230);
var inst_26236 = (!(inst_26235));
var state_26252__$1 = state_26252;
var statearr_26261_26456 = state_26252__$1;
(statearr_26261_26456[(2)] = inst_26236);

(statearr_26261_26456[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (7))){
var inst_25926 = (state_26252[(12)]);
var inst_25926__$1 = selectOne;
var state_26252__$1 = (function (){var statearr_26262 = state_26252;
(statearr_26262[(12)] = inst_25926__$1);

return statearr_26262;
})();
if(cljs.core.truth_(inst_25926__$1)){
var statearr_26263_26457 = state_26252__$1;
(statearr_26263_26457[(1)] = (9));

} else {
var statearr_26264_26458 = state_26252__$1;
(statearr_26264_26458[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (59))){
var inst_25946 = (state_26252[(13)]);
var inst_25958 = (state_26252[(7)]);
var inst_25956 = (state_26252[(8)]);
var inst_26041 = (state_26252[(14)]);
var inst_26055 = (state_26252[(2)]);
var inst_26056 = fluree.db.util.async.throw_err(inst_26055);
var inst_26057 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_26041,inst_26056);
var inst_26058 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_25958,fuel,max_fuel,inst_25956,inst_26057,inst_25946);
var state_26252__$1 = state_26252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26252__$1,(60),inst_26058);
} else {
if((state_val_26253 === (86))){
var inst_25946 = (state_26252[(13)]);
var inst_25958 = (state_26252[(7)]);
var inst_25956 = (state_26252[(8)]);
var inst_25948 = (state_26252[(15)]);
var inst_26123 = (state_26252[(2)]);
var inst_26124 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25958,fuel,max_fuel,inst_25956,inst_26123,inst_25946,inst_25948);
var state_26252__$1 = state_26252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26252__$1,(87),inst_26124);
} else {
if((state_val_26253 === (20))){
var inst_25990 = (state_26252[(2)]);
var inst_25991 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25990,(0),null);
var inst_25992 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25990,(1),null);
var inst_25993 = typeof where === 'string';
var state_26252__$1 = (function (){var statearr_26265 = state_26252;
(statearr_26265[(16)] = inst_25992);

(statearr_26265[(17)] = inst_25991);

return statearr_26265;
})();
if(cljs.core.truth_(inst_25993)){
var statearr_26266_26459 = state_26252__$1;
(statearr_26266_26459[(1)] = (30));

} else {
var statearr_26267_26460 = state_26252__$1;
(statearr_26267_26460[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (72))){
var inst_25945 = (state_26252[(18)]);
var state_26252__$1 = state_26252;
if(cljs.core.truth_(inst_25945)){
var statearr_26268_26461 = state_26252__$1;
(statearr_26268_26461[(1)] = (75));

} else {
var statearr_26269_26462 = state_26252__$1;
(statearr_26269_26462[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (58))){
var inst_26049 = (state_26252[(2)]);
var inst_26050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26051 = [from];
var inst_26052 = (new cljs.core.PersistentVector(null,1,(5),inst_26050,inst_26051,null));
var inst_26053 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26052,inst_26049);
var state_26252__$1 = state_26252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26252__$1,(59),inst_26053);
} else {
if((state_val_26253 === (60))){
var inst_26060 = (state_26252[(2)]);
var inst_26061 = fluree.db.util.async.throw_err(inst_26060);
var state_26252__$1 = state_26252;
var statearr_26270_26463 = state_26252__$1;
(statearr_26270_26463[(2)] = inst_26061);

(statearr_26270_26463[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (27))){
var inst_25975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25976 = [null,null];
var inst_25977 = (new cljs.core.PersistentVector(null,2,(5),inst_25975,inst_25976,null));
var state_26252__$1 = state_26252;
var statearr_26271_26464 = state_26252__$1;
(statearr_26271_26464[(2)] = inst_25977);

(statearr_26271_26464[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (1))){
var state_26252__$1 = state_26252;
var statearr_26272_26465 = state_26252__$1;
(statearr_26272_26465[(2)] = null);

(statearr_26272_26465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (69))){
var inst_26080 = (state_26252[(2)]);
var inst_26081 = fluree.db.query.range._block_or_tx_collection(db,inst_26080);
var state_26252__$1 = state_26252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26252__$1,(70),inst_26081);
} else {
if((state_val_26253 === (101))){
var inst_26186 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
var statearr_26273_26466 = state_26252__$1;
(statearr_26273_26466[(2)] = inst_26186);

(statearr_26273_26466[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (24))){
var inst_25945 = (state_26252[(18)]);
var inst_25970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25971 = [inst_25945,"ASC"];
var inst_25972 = (new cljs.core.PersistentVector(null,2,(5),inst_25970,inst_25971,null));
var state_26252__$1 = state_26252;
var statearr_26274_26467 = state_26252__$1;
(statearr_26274_26467[(2)] = inst_25972);

(statearr_26274_26467[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (102))){
var inst_26160 = (state_26252[(19)]);
var state_26252__$1 = state_26252;
var statearr_26275_26468 = state_26252__$1;
(statearr_26275_26468[(2)] = inst_26160);

(statearr_26275_26468[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (55))){
var inst_25945 = (state_26252[(18)]);
var inst_26041 = (state_26252[(2)]);
var state_26252__$1 = (function (){var statearr_26276 = state_26252;
(statearr_26276[(14)] = inst_26041);

return statearr_26276;
})();
if(cljs.core.truth_(inst_25945)){
var statearr_26277_26469 = state_26252__$1;
(statearr_26277_26469[(1)] = (56));

} else {
var statearr_26278_26470 = state_26252__$1;
(statearr_26278_26470[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (85))){
var inst_26115 = (state_26252[(20)]);
var inst_26119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26120 = [inst_26115];
var inst_26121 = (new cljs.core.PersistentVector(null,1,(5),inst_26119,inst_26120,null));
var state_26252__$1 = state_26252;
var statearr_26279_26471 = state_26252__$1;
(statearr_26279_26471[(2)] = inst_26121);

(statearr_26279_26471[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (39))){
var inst_25946 = (state_26252[(13)]);
var state_26252__$1 = state_26252;
var statearr_26280_26472 = state_26252__$1;
(statearr_26280_26472[(2)] = inst_25946);

(statearr_26280_26472[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (88))){
var inst_26129 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_26252__$1 = state_26252;
var statearr_26281_26473 = state_26252__$1;
(statearr_26281_26473[(2)] = inst_26129);

(statearr_26281_26473[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (46))){
var inst_26026 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
if(cljs.core.truth_(inst_26026)){
var statearr_26282_26474 = state_26252__$1;
(statearr_26282_26474[(1)] = (47));

} else {
var statearr_26283_26475 = state_26252__$1;
(statearr_26283_26475[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (4))){
var inst_25913 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
var statearr_26284_26476 = state_26252__$1;
(statearr_26284_26476[(2)] = inst_25913);

(statearr_26284_26476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (77))){
var inst_26099 = (state_26252[(2)]);
var inst_26100 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_26099);
var state_26252__$1 = state_26252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26252__$1,(78),inst_26100);
} else {
if((state_val_26253 === (106))){
var state_26252__$1 = state_26252;
var statearr_26285_26477 = state_26252__$1;
(statearr_26285_26477[(2)] = null);

(statearr_26285_26477[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (119))){
var inst_26205 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_26206 = ["Invalid 'from' in query:",inst_26205].join('');
var inst_26207 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26208 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_26209 = cljs.core.PersistentHashMap.fromArrays(inst_26207,inst_26208);
var inst_26210 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26206,inst_26209);
var state_26252__$1 = state_26252;
var statearr_26286_26478 = state_26252__$1;
(statearr_26286_26478[(2)] = inst_26210);

(statearr_26286_26478[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (95))){
var state_26252__$1 = state_26252;
var statearr_26287_26479 = state_26252__$1;
(statearr_26287_26479[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (54))){
var inst_26035 = (state_26252[(21)]);
var state_26252__$1 = state_26252;
var statearr_26289_26480 = state_26252__$1;
(statearr_26289_26480[(2)] = inst_26035);

(statearr_26289_26480[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (92))){
var inst_26134 = (state_26252[(22)]);
var state_26252__$1 = state_26252;
var statearr_26290_26481 = state_26252__$1;
(statearr_26290_26481[(2)] = inst_26134);

(statearr_26290_26481[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (104))){
var inst_26178 = (state_26252[(23)]);
var inst_26178__$1 = (state_26252[(2)]);
var state_26252__$1 = (function (){var statearr_26291 = state_26252;
(statearr_26291[(23)] = inst_26178__$1);

return statearr_26291;
})();
if(cljs.core.truth_(inst_26178__$1)){
var statearr_26292_26482 = state_26252__$1;
(statearr_26292_26482[(1)] = (109));

} else {
var statearr_26293_26483 = state_26252__$1;
(statearr_26293_26483[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (15))){
var inst_25947 = (state_26252[(24)]);
var inst_25949 = (state_26252[(25)]);
var inst_25953 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25949,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_25947);
var state_26252__$1 = state_26252;
var statearr_26294_26484 = state_26252__$1;
(statearr_26294_26484[(2)] = inst_25953);

(statearr_26294_26484[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (48))){
var inst_26063 = (state_26252[(9)]);
var inst_26063__$1 = typeof from === 'string';
var state_26252__$1 = (function (){var statearr_26295 = state_26252;
(statearr_26295[(9)] = inst_26063__$1);

return statearr_26295;
})();
if(cljs.core.truth_(inst_26063__$1)){
var statearr_26296_26485 = state_26252__$1;
(statearr_26296_26485[(1)] = (61));

} else {
var statearr_26297_26486 = state_26252__$1;
(statearr_26297_26486[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (50))){
var inst_26029 = (state_26252[(26)]);
var inst_26031 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_26032 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_26029,inst_26031);
var state_26252__$1 = state_26252;
var statearr_26298_26487 = state_26252__$1;
(statearr_26298_26487[(2)] = inst_26032);

(statearr_26298_26487[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (116))){
var state_26252__$1 = state_26252;
var statearr_26299_26488 = state_26252__$1;
(statearr_26299_26488[(2)] = null);

(statearr_26299_26488[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (75))){
var inst_26093 = cljs.core.PersistentHashMap.EMPTY;
var state_26252__$1 = state_26252;
var statearr_26300_26489 = state_26252__$1;
(statearr_26300_26489[(2)] = inst_26093);

(statearr_26300_26489[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (99))){
var inst_26154 = (state_26252[(10)]);
var state_26252__$1 = state_26252;
var statearr_26301_26490 = state_26252__$1;
(statearr_26301_26490[(2)] = inst_26154);

(statearr_26301_26490[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (21))){
var inst_25945 = (state_26252[(18)]);
var inst_25962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25963 = cljs.core.second(inst_25945);
var inst_25964 = cljs.core.first(inst_25945);
var inst_25965 = [inst_25963,inst_25964];
var inst_25966 = (new cljs.core.PersistentVector(null,2,(5),inst_25962,inst_25965,null));
var state_26252__$1 = state_26252;
var statearr_26302_26491 = state_26252__$1;
(statearr_26302_26491[(2)] = inst_25966);

(statearr_26302_26491[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (31))){
var inst_26020 = (state_26252[(27)]);
var inst_26020__$1 = typeof from === 'string';
var state_26252__$1 = (function (){var statearr_26303 = state_26252;
(statearr_26303[(27)] = inst_26020__$1);

return statearr_26303;
})();
if(cljs.core.truth_(inst_26020__$1)){
var statearr_26304_26492 = state_26252__$1;
(statearr_26304_26492[(1)] = (44));

} else {
var statearr_26305_26493 = state_26252__$1;
(statearr_26305_26493[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (113))){
var state_26252__$1 = state_26252;
var statearr_26306_26494 = state_26252__$1;
(statearr_26306_26494[(2)] = null);

(statearr_26306_26494[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (32))){
var inst_25991 = (state_26252[(17)]);
var inst_26225 = (state_26252[(2)]);
var state_26252__$1 = (function (){var statearr_26307 = state_26252;
(statearr_26307[(28)] = inst_26225);

return statearr_26307;
})();
if(cljs.core.truth_(inst_25991)){
var statearr_26308_26495 = state_26252__$1;
(statearr_26308_26495[(1)] = (122));

} else {
var statearr_26309_26496 = state_26252__$1;
(statearr_26309_26496[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (40))){
var inst_25945 = (state_26252[(18)]);
var inst_26010 = (state_26252[(2)]);
var state_26252__$1 = (function (){var statearr_26310 = state_26252;
(statearr_26310[(29)] = inst_26010);

return statearr_26310;
})();
if(cljs.core.truth_(inst_25945)){
var statearr_26311_26497 = state_26252__$1;
(statearr_26311_26497[(1)] = (41));

} else {
var statearr_26312_26498 = state_26252__$1;
(statearr_26312_26498[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (129))){
var inst_26233 = (state_26252[(30)]);
var state_26252__$1 = state_26252;
var statearr_26313_26499 = state_26252__$1;
(statearr_26313_26499[(2)] = inst_26233);

(statearr_26313_26499[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (91))){
var inst_26136 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_26252__$1 = state_26252;
var statearr_26314_26500 = state_26252__$1;
(statearr_26314_26500[(2)] = inst_26136);

(statearr_26314_26500[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (117))){
var inst_25948 = (state_26252[(15)]);
var state_26252__$1 = state_26252;
var statearr_26315_26501 = state_26252__$1;
(statearr_26315_26501[(2)] = inst_25948);

(statearr_26315_26501[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (108))){
var inst_26175 = (state_26252[(2)]);
var inst_26176 = fluree.db.util.async.throw_err(inst_26175);
var state_26252__$1 = state_26252;
var statearr_26316_26502 = state_26252__$1;
(statearr_26316_26502[(2)] = inst_26176);

(statearr_26316_26502[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (56))){
var inst_26043 = cljs.core.PersistentHashMap.EMPTY;
var state_26252__$1 = state_26252;
var statearr_26317_26503 = state_26252__$1;
(statearr_26317_26503[(2)] = inst_26043);

(statearr_26317_26503[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (33))){
var state_26252__$1 = state_26252;
var statearr_26318_26504 = state_26252__$1;
(statearr_26318_26504[(2)] = from);

(statearr_26318_26504[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (13))){
var inst_25932 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25933 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25934 = cljs.core.PersistentHashMap.fromArrays(inst_25932,inst_25933);
var inst_25935 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_25934);
var inst_25936 = (function(){throw inst_25935})();
var state_26252__$1 = state_26252;
var statearr_26319_26505 = state_26252__$1;
(statearr_26319_26505[(2)] = inst_25936);

(statearr_26319_26505[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (22))){
var inst_25945 = (state_26252[(18)]);
var inst_25968 = typeof inst_25945 === 'string';
var state_26252__$1 = state_26252;
if(cljs.core.truth_(inst_25968)){
var statearr_26320_26506 = state_26252__$1;
(statearr_26320_26506[(1)] = (24));

} else {
var statearr_26321_26507 = state_26252__$1;
(statearr_26321_26507[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (90))){
var inst_26127 = (state_26252[(31)]);
var inst_26132 = (state_26252[(2)]);
var state_26252__$1 = (function (){var statearr_26322 = state_26252;
(statearr_26322[(32)] = inst_26132);

return statearr_26322;
})();
var statearr_26323_26508 = state_26252__$1;
(statearr_26323_26508[(2)] = inst_26127);

(statearr_26323_26508[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (109))){
var inst_26178 = (state_26252[(23)]);
var inst_26154 = (state_26252[(10)]);
var inst_26180 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26154,inst_26178);
var state_26252__$1 = state_26252;
var statearr_26324_26509 = state_26252__$1;
(statearr_26324_26509[(2)] = inst_26180);

(statearr_26324_26509[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (36))){
var inst_25945 = (state_26252[(18)]);
var inst_26005 = (state_26252[(2)]);
var inst_26006 = fluree.db.util.async.throw_err(inst_26005);
var state_26252__$1 = (function (){var statearr_26325 = state_26252;
(statearr_26325[(33)] = inst_26006);

return statearr_26325;
})();
if(cljs.core.truth_(inst_25945)){
var statearr_26326_26510 = state_26252__$1;
(statearr_26326_26510[(1)] = (38));

} else {
var statearr_26327_26511 = state_26252__$1;
(statearr_26327_26511[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (41))){
var state_26252__$1 = state_26252;
var statearr_26328_26512 = state_26252__$1;
(statearr_26328_26512[(2)] = null);

(statearr_26328_26512[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (118))){
var inst_26190 = (state_26252[(34)]);
var inst_25958 = (state_26252[(7)]);
var inst_25956 = (state_26252[(8)]);
var inst_26194 = (state_26252[(35)]);
var inst_26198 = (state_26252[(2)]);
var inst_26199 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25958,fuel,max_fuel,inst_25956,inst_26190,inst_26194,inst_26198);
var state_26252__$1 = state_26252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26252__$1,(112),inst_26199);
} else {
if((state_val_26253 === (89))){
var state_26252__$1 = state_26252;
var statearr_26329_26513 = state_26252__$1;
(statearr_26329_26513[(2)] = null);

(statearr_26329_26513[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (100))){
var inst_26160 = (state_26252[(19)]);
var inst_26165 = cljs.core.int_QMARK_(inst_26160);
var state_26252__$1 = state_26252;
if(inst_26165){
var statearr_26330_26514 = state_26252__$1;
(statearr_26330_26514[(1)] = (102));

} else {
var statearr_26331_26515 = state_26252__$1;
(statearr_26331_26515[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (131))){
var inst_26230 = (state_26252[(11)]);
var inst_26244 = cljs.core.first(inst_26230);
var state_26252__$1 = state_26252;
var statearr_26332_26516 = state_26252__$1;
(statearr_26332_26516[(2)] = inst_26244);

(statearr_26332_26516[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (122))){
var inst_25992 = (state_26252[(16)]);
var inst_25946 = (state_26252[(13)]);
var inst_25991 = (state_26252[(17)]);
var inst_25948 = (state_26252[(15)]);
var inst_26225 = (state_26252[(28)]);
var inst_26227 = fluree.db.query.fql.sort_offset_and_limit_res(inst_25991,inst_25992,inst_25948,inst_25946,inst_26225);
var state_26252__$1 = state_26252;
var statearr_26333_26517 = state_26252__$1;
(statearr_26333_26517[(2)] = inst_26227);

(statearr_26333_26517[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (43))){
var inst_26006 = (state_26252[(33)]);
var inst_25958 = (state_26252[(7)]);
var inst_25956 = (state_26252[(8)]);
var inst_26010 = (state_26252[(29)]);
var inst_26014 = (state_26252[(2)]);
var inst_26015 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25958,fuel,max_fuel,inst_25956,inst_26006,inst_26010,inst_26014);
var state_26252__$1 = state_26252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26252__$1,(37),inst_26015);
} else {
if((state_val_26253 === (61))){
var inst_26065 = ["_tx",null,"_block",null];
var inst_26066 = (new cljs.core.PersistentArrayMap(null,2,inst_26065,null));
var inst_26067 = (new cljs.core.PersistentHashSet(null,inst_26066,null));
var inst_26068 = (inst_26067.cljs$core$IFn$_invoke$arity$1 ? inst_26067.cljs$core$IFn$_invoke$arity$1(from) : inst_26067.call(null,from));
var state_26252__$1 = state_26252;
var statearr_26334_26518 = state_26252__$1;
(statearr_26334_26518[(2)] = inst_26068);

(statearr_26334_26518[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (29))){
var inst_25980 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
var statearr_26335_26519 = state_26252__$1;
(statearr_26335_26519[(2)] = inst_25980);

(statearr_26335_26519[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (44))){
var inst_26022 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_26023 = clojure.string.includes_QMARK_(inst_26022,"/");
var state_26252__$1 = state_26252;
var statearr_26336_26520 = state_26252__$1;
(statearr_26336_26520[(2)] = inst_26023);

(statearr_26336_26520[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (93))){
var inst_26139 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
if(cljs.core.truth_(inst_26139)){
var statearr_26337_26521 = state_26252__$1;
(statearr_26337_26521[(1)] = (94));

} else {
var statearr_26338_26522 = state_26252__$1;
(statearr_26338_26522[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (6))){
var inst_25923 = (state_26252[(36)]);
var state_26252__$1 = state_26252;
var statearr_26339_26523 = state_26252__$1;
(statearr_26339_26523[(2)] = inst_25923);

(statearr_26339_26523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (111))){
var inst_26161 = (state_26252[(37)]);
var inst_26183 = (state_26252[(2)]);
var inst_26153 = inst_26161;
var inst_26154 = inst_26183;
var state_26252__$1 = (function (){var statearr_26340 = state_26252;
(statearr_26340[(38)] = inst_26153);

(statearr_26340[(10)] = inst_26154);

return statearr_26340;
})();
var statearr_26341_26524 = state_26252__$1;
(statearr_26341_26524[(2)] = null);

(statearr_26341_26524[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (28))){
var state_26252__$1 = state_26252;
var statearr_26342_26525 = state_26252__$1;
(statearr_26342_26525[(2)] = null);

(statearr_26342_26525[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (64))){
var inst_25945 = (state_26252[(18)]);
var state_26252__$1 = state_26252;
if(cljs.core.truth_(inst_25945)){
var statearr_26343_26526 = state_26252__$1;
(statearr_26343_26526[(1)] = (67));

} else {
var statearr_26344_26527 = state_26252__$1;
(statearr_26344_26527[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (103))){
var state_26252__$1 = state_26252;
if(cljs.core.truth_(fuel)){
var statearr_26345_26528 = state_26252__$1;
(statearr_26345_26528[(1)] = (105));

} else {
var statearr_26346_26529 = state_26252__$1;
(statearr_26346_26529[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (51))){
var inst_26029 = (state_26252[(26)]);
var state_26252__$1 = state_26252;
var statearr_26347_26530 = state_26252__$1;
(statearr_26347_26530[(2)] = inst_26029);

(statearr_26347_26530[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (25))){
var state_26252__$1 = state_26252;
var statearr_26348_26531 = state_26252__$1;
(statearr_26348_26531[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (34))){
var state_26252__$1 = state_26252;
var statearr_26350_26532 = state_26252__$1;
(statearr_26350_26532[(2)] = null);

(statearr_26350_26532[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (125))){
var inst_26230 = (state_26252[(11)]);
var inst_26233 = (state_26252[(30)]);
var inst_26233__$1 = cljs.core.coll_QMARK_(inst_26230);
var state_26252__$1 = (function (){var statearr_26351 = state_26252;
(statearr_26351[(30)] = inst_26233__$1);

return statearr_26351;
})();
if(inst_26233__$1){
var statearr_26352_26533 = state_26252__$1;
(statearr_26352_26533[(1)] = (128));

} else {
var statearr_26353_26534 = state_26252__$1;
(statearr_26353_26534[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (17))){
var inst_25945 = (state_26252[(18)]);
var inst_25956 = (state_26252[(2)]);
var inst_25957 = cljs.core.PersistentHashMap.EMPTY;
var inst_25958 = cljs.core.volatile_BANG_(inst_25957);
var state_26252__$1 = (function (){var statearr_26354 = state_26252;
(statearr_26354[(7)] = inst_25958);

(statearr_26354[(8)] = inst_25956);

return statearr_26354;
})();
if(cljs.core.truth_(inst_25945)){
var statearr_26355_26535 = state_26252__$1;
(statearr_26355_26535[(1)] = (18));

} else {
var statearr_26356_26536 = state_26252__$1;
(statearr_26356_26536[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (3))){
var inst_26250 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26252__$1,inst_26250);
} else {
if((state_val_26253 === (12))){
var inst_25929 = (state_26252[(39)]);
var state_26252__$1 = state_26252;
var statearr_26357_26537 = state_26252__$1;
(statearr_26357_26537[(2)] = inst_25929);

(statearr_26357_26537[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (2))){
var inst_25923 = (state_26252[(36)]);
var _ = (function (){var statearr_26358 = state_26252;
(statearr_26358[(4)] = cljs.core.cons((5),(state_26252[(4)])));

return statearr_26358;
})();
var inst_25923__$1 = select;
var state_26252__$1 = (function (){var statearr_26359 = state_26252;
(statearr_26359[(36)] = inst_25923__$1);

return statearr_26359;
})();
if(cljs.core.truth_(inst_25923__$1)){
var statearr_26360_26538 = state_26252__$1;
(statearr_26360_26538[(1)] = (6));

} else {
var statearr_26361_26539 = state_26252__$1;
(statearr_26361_26539[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (66))){
var inst_26221 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
var statearr_26362_26540 = state_26252__$1;
(statearr_26362_26540[(2)] = inst_26221);

(statearr_26362_26540[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (107))){
var inst_26160 = (state_26252[(19)]);
var inst_26172 = (state_26252[(2)]);
var inst_26173 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_26160,false);
var state_26252__$1 = (function (){var statearr_26363 = state_26252;
(statearr_26363[(40)] = inst_26172);

return statearr_26363;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26252__$1,(108),inst_26173);
} else {
if((state_val_26253 === (23))){
var inst_25984 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
var statearr_26364_26541 = state_26252__$1;
(statearr_26364_26541[(2)] = inst_25984);

(statearr_26364_26541[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (47))){
var inst_26029 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_26252__$1 = (function (){var statearr_26365 = state_26252;
(statearr_26365[(26)] = inst_26029);

return statearr_26365;
})();
if(cljs.core.truth_(fuel)){
var statearr_26366_26542 = state_26252__$1;
(statearr_26366_26542[(1)] = (50));

} else {
var statearr_26367_26543 = state_26252__$1;
(statearr_26367_26543[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (35))){
var inst_25946 = (state_26252[(13)]);
var inst_25948 = (state_26252[(15)]);
var inst_25999 = (state_26252[(2)]);
var inst_26000 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26001 = [inst_25946,inst_25948];
var inst_26002 = cljs.core.PersistentHashMap.fromArrays(inst_26000,inst_26001);
var inst_26003 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where,inst_25999,inst_26002);
var state_26252__$1 = state_26252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26252__$1,(36),inst_26003);
} else {
if((state_val_26253 === (127))){
var inst_26242 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
if(cljs.core.truth_(inst_26242)){
var statearr_26368_26544 = state_26252__$1;
(statearr_26368_26544[(1)] = (131));

} else {
var statearr_26369_26545 = state_26252__$1;
(statearr_26369_26545[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (82))){
var inst_26217 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
var statearr_26370_26546 = state_26252__$1;
(statearr_26370_26546[(2)] = inst_26217);

(statearr_26370_26546[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (76))){
var inst_25946 = (state_26252[(13)]);
var inst_25948 = (state_26252[(15)]);
var inst_26095 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26096 = [inst_25946,inst_25948];
var inst_26097 = cljs.core.PersistentHashMap.fromArrays(inst_26095,inst_26096);
var state_26252__$1 = state_26252;
var statearr_26371_26547 = state_26252__$1;
(statearr_26371_26547[(2)] = inst_26097);

(statearr_26371_26547[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (97))){
var inst_26160 = (state_26252[(19)]);
var inst_26153 = (state_26252[(38)]);
var inst_26159 = cljs.core.seq(inst_26153);
var inst_26160__$1 = cljs.core.first(inst_26159);
var inst_26161 = cljs.core.next(inst_26159);
var inst_26162 = cljs.core.not(inst_26160__$1);
var state_26252__$1 = (function (){var statearr_26372 = state_26252;
(statearr_26372[(37)] = inst_26161);

(statearr_26372[(19)] = inst_26160__$1);

return statearr_26372;
})();
if(inst_26162){
var statearr_26373_26548 = state_26252__$1;
(statearr_26373_26548[(1)] = (99));

} else {
var statearr_26374_26549 = state_26252__$1;
(statearr_26374_26549[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (19))){
var inst_25986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25987 = [null,null];
var inst_25988 = (new cljs.core.PersistentVector(null,2,(5),inst_25986,inst_25987,null));
var state_26252__$1 = state_26252;
var statearr_26375_26550 = state_26252__$1;
(statearr_26375_26550[(2)] = inst_25988);

(statearr_26375_26550[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (57))){
var inst_25946 = (state_26252[(13)]);
var inst_25948 = (state_26252[(15)]);
var inst_26045 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26046 = [inst_25946,inst_25948];
var inst_26047 = cljs.core.PersistentHashMap.fromArrays(inst_26045,inst_26046);
var state_26252__$1 = state_26252;
var statearr_26376_26551 = state_26252__$1;
(statearr_26376_26551[(2)] = inst_26047);

(statearr_26376_26551[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (68))){
var inst_25946 = (state_26252[(13)]);
var inst_25948 = (state_26252[(15)]);
var inst_26076 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26077 = [inst_25946,inst_25948];
var inst_26078 = cljs.core.PersistentHashMap.fromArrays(inst_26076,inst_26077);
var state_26252__$1 = state_26252;
var statearr_26377_26552 = state_26252__$1;
(statearr_26377_26552[(2)] = inst_26078);

(statearr_26377_26552[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (11))){
var inst_25940 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
var statearr_26378_26553 = state_26252__$1;
(statearr_26378_26553[(2)] = inst_25940);

(statearr_26378_26553[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (115))){
var inst_25945 = (state_26252[(18)]);
var inst_26194 = (state_26252[(2)]);
var state_26252__$1 = (function (){var statearr_26380 = state_26252;
(statearr_26380[(35)] = inst_26194);

return statearr_26380;
})();
if(cljs.core.truth_(inst_25945)){
var statearr_26381_26554 = state_26252__$1;
(statearr_26381_26554[(1)] = (116));

} else {
var statearr_26382_26555 = state_26252__$1;
(statearr_26382_26555[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (9))){
var inst_25926 = (state_26252[(12)]);
var state_26252__$1 = state_26252;
var statearr_26383_26556 = state_26252__$1;
(statearr_26383_26556[(2)] = inst_25926);

(statearr_26383_26556[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (5))){
var _ = (function (){var statearr_26384 = state_26252;
(statearr_26384[(4)] = cljs.core.rest((state_26252[(4)])));

return statearr_26384;
})();
var state_26252__$1 = state_26252;
var ex26379 = (state_26252__$1[(2)]);
var statearr_26385_26557 = state_26252__$1;
(statearr_26385_26557[(5)] = ex26379);


if((ex26379 instanceof Error)){
var statearr_26386_26558 = state_26252__$1;
(statearr_26386_26558[(1)] = (4));

(statearr_26386_26558[(5)] = null);

} else {
throw ex26379;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (112))){
var inst_26201 = (state_26252[(2)]);
var inst_26202 = fluree.db.util.async.throw_err(inst_26201);
var state_26252__$1 = state_26252;
var statearr_26387_26559 = state_26252__$1;
(statearr_26387_26559[(2)] = inst_26202);

(statearr_26387_26559[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (83))){
var inst_26115 = (state_26252[(20)]);
var inst_26114 = (state_26252[(2)]);
var inst_26115__$1 = fluree.db.util.async.throw_err(inst_26114);
var inst_26116 = (inst_26115__$1 == null);
var state_26252__$1 = (function (){var statearr_26388 = state_26252;
(statearr_26388[(20)] = inst_26115__$1);

return statearr_26388;
})();
if(cljs.core.truth_(inst_26116)){
var statearr_26389_26560 = state_26252__$1;
(statearr_26389_26560[(1)] = (84));

} else {
var statearr_26390_26561 = state_26252__$1;
(statearr_26390_26561[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (14))){
var inst_25938 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
var statearr_26391_26562 = state_26252__$1;
(statearr_26391_26562[(2)] = inst_25938);

(statearr_26391_26562[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (45))){
var inst_26020 = (state_26252[(27)]);
var state_26252__$1 = state_26252;
var statearr_26392_26563 = state_26252__$1;
(statearr_26392_26563[(2)] = inst_26020);

(statearr_26392_26563[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (53))){
var inst_26035 = (state_26252[(21)]);
var inst_26037 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_26038 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_26035,inst_26037);
var state_26252__$1 = state_26252;
var statearr_26393_26564 = state_26252__$1;
(statearr_26393_26564[(2)] = inst_26038);

(statearr_26393_26564[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (78))){
var inst_25958 = (state_26252[(7)]);
var inst_25956 = (state_26252[(8)]);
var inst_26102 = (state_26252[(2)]);
var inst_26103 = fluree.db.util.async.throw_err(inst_26102);
var inst_26104 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_25958,fuel,max_fuel,inst_25956,inst_26103);
var state_26252__$1 = state_26252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26252__$1,(79),inst_26104);
} else {
if((state_val_26253 === (132))){
var inst_26230 = (state_26252[(11)]);
var state_26252__$1 = state_26252;
var statearr_26394_26565 = state_26252__$1;
(statearr_26394_26565[(2)] = inst_26230);

(statearr_26394_26565[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (26))){
var inst_25982 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
var statearr_26395_26566 = state_26252__$1;
(statearr_26395_26566[(2)] = inst_25982);

(statearr_26395_26566[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (123))){
var inst_26225 = (state_26252[(28)]);
var state_26252__$1 = state_26252;
var statearr_26396_26567 = state_26252__$1;
(statearr_26396_26567[(2)] = inst_26225);

(statearr_26396_26567[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (16))){
var inst_25949 = (state_26252[(25)]);
var state_26252__$1 = state_26252;
var statearr_26397_26568 = state_26252__$1;
(statearr_26397_26568[(2)] = inst_25949);

(statearr_26397_26568[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (133))){
var inst_26247 = (state_26252[(2)]);
var _ = (function (){var statearr_26398 = state_26252;
(statearr_26398[(4)] = cljs.core.rest((state_26252[(4)])));

return statearr_26398;
})();
var state_26252__$1 = state_26252;
var statearr_26399_26569 = state_26252__$1;
(statearr_26399_26569[(2)] = inst_26247);

(statearr_26399_26569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (81))){
var inst_26134 = (state_26252[(22)]);
var inst_26134__$1 = cljs.core.sequential_QMARK_(from);
var state_26252__$1 = (function (){var statearr_26400 = state_26252;
(statearr_26400[(22)] = inst_26134__$1);

return statearr_26400;
})();
if(inst_26134__$1){
var statearr_26401_26570 = state_26252__$1;
(statearr_26401_26570[(1)] = (91));

} else {
var statearr_26402_26571 = state_26252__$1;
(statearr_26402_26571[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (120))){
var state_26252__$1 = state_26252;
var statearr_26403_26572 = state_26252__$1;
(statearr_26403_26572[(2)] = null);

(statearr_26403_26572[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (79))){
var inst_26106 = (state_26252[(2)]);
var inst_26107 = fluree.db.util.async.throw_err(inst_26106);
var state_26252__$1 = state_26252;
var statearr_26404_26573 = state_26252__$1;
(statearr_26404_26573[(2)] = inst_26107);

(statearr_26404_26573[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (38))){
var state_26252__$1 = state_26252;
var statearr_26405_26574 = state_26252__$1;
(statearr_26405_26574[(2)] = null);

(statearr_26405_26574[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (126))){
var inst_26231 = (state_26252[(41)]);
var state_26252__$1 = state_26252;
var statearr_26406_26575 = state_26252__$1;
(statearr_26406_26575[(2)] = inst_26231);

(statearr_26406_26575[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (98))){
var inst_25945 = (state_26252[(18)]);
var inst_26188 = (state_26252[(2)]);
var inst_26189 = cljs.core.PersistentVector.EMPTY;
var inst_26190 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26189,inst_26188);
var state_26252__$1 = (function (){var statearr_26407 = state_26252;
(statearr_26407[(34)] = inst_26190);

return statearr_26407;
})();
if(cljs.core.truth_(inst_25945)){
var statearr_26408_26576 = state_26252__$1;
(statearr_26408_26576[(1)] = (113));

} else {
var statearr_26409_26577 = state_26252__$1;
(statearr_26409_26577[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (124))){
var inst_26231 = (state_26252[(41)]);
var inst_26230 = (state_26252[(2)]);
var inst_26231__$1 = selectOne;
var state_26252__$1 = (function (){var statearr_26410 = state_26252;
(statearr_26410[(41)] = inst_26231__$1);

(statearr_26410[(11)] = inst_26230);

return statearr_26410;
})();
if(cljs.core.truth_(inst_26231__$1)){
var statearr_26411_26578 = state_26252__$1;
(statearr_26411_26578[(1)] = (125));

} else {
var statearr_26412_26579 = state_26252__$1;
(statearr_26412_26579[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (87))){
var inst_26126 = (state_26252[(2)]);
var inst_26127 = fluree.db.util.async.throw_err(inst_26126);
var state_26252__$1 = (function (){var statearr_26413 = state_26252;
(statearr_26413[(31)] = inst_26127);

return statearr_26413;
})();
if(cljs.core.truth_(fuel)){
var statearr_26414_26580 = state_26252__$1;
(statearr_26414_26580[(1)] = (88));

} else {
var statearr_26415_26581 = state_26252__$1;
(statearr_26415_26581[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (30))){
var inst_25995 = typeof from === 'string';
var state_26252__$1 = state_26252;
if(cljs.core.truth_(inst_25995)){
var statearr_26416_26582 = state_26252__$1;
(statearr_26416_26582[(1)] = (33));

} else {
var statearr_26417_26583 = state_26252__$1;
(statearr_26417_26583[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (73))){
var inst_26109 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_26252__$1 = state_26252;
if(inst_26109){
var statearr_26418_26584 = state_26252__$1;
(statearr_26418_26584[(1)] = (80));

} else {
var statearr_26419_26585 = state_26252__$1;
(statearr_26419_26585[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (96))){
var inst_26215 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
var statearr_26420_26586 = state_26252__$1;
(statearr_26420_26586[(2)] = inst_26215);

(statearr_26420_26586[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (10))){
var inst_25929 = (state_26252[(39)]);
var inst_25929__$1 = selectDistinct;
var state_26252__$1 = (function (){var statearr_26421 = state_26252;
(statearr_26421[(39)] = inst_25929__$1);

return statearr_26421;
})();
if(cljs.core.truth_(inst_25929__$1)){
var statearr_26422_26587 = state_26252__$1;
(statearr_26422_26587[(1)] = (12));

} else {
var statearr_26423_26588 = state_26252__$1;
(statearr_26423_26588[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (18))){
var inst_25945 = (state_26252[(18)]);
var inst_25960 = cljs.core.vector_QMARK_(inst_25945);
var state_26252__$1 = state_26252;
if(inst_25960){
var statearr_26424_26589 = state_26252__$1;
(statearr_26424_26589[(1)] = (21));

} else {
var statearr_26425_26590 = state_26252__$1;
(statearr_26425_26590[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (105))){
var inst_26169 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_26252__$1 = state_26252;
var statearr_26426_26591 = state_26252__$1;
(statearr_26426_26591[(2)] = inst_26169);

(statearr_26426_26591[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (52))){
var inst_26035 = (state_26252[(2)]);
var state_26252__$1 = (function (){var statearr_26427 = state_26252;
(statearr_26427[(21)] = inst_26035);

return statearr_26427;
})();
var statearr_26428_26592 = state_26252__$1;
(statearr_26428_26592[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (114))){
var inst_25946 = (state_26252[(13)]);
var state_26252__$1 = state_26252;
var statearr_26430_26593 = state_26252__$1;
(statearr_26430_26593[(2)] = inst_25946);

(statearr_26430_26593[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (67))){
var inst_26074 = cljs.core.PersistentHashMap.EMPTY;
var state_26252__$1 = state_26252;
var statearr_26431_26594 = state_26252__$1;
(statearr_26431_26594[(2)] = inst_26074);

(statearr_26431_26594[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (71))){
var inst_26087 = (state_26252[(2)]);
var inst_26088 = fluree.db.util.async.throw_err(inst_26087);
var state_26252__$1 = state_26252;
var statearr_26432_26595 = state_26252__$1;
(statearr_26432_26595[(2)] = inst_26088);

(statearr_26432_26595[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (42))){
var inst_25948 = (state_26252[(15)]);
var state_26252__$1 = state_26252;
var statearr_26433_26596 = state_26252__$1;
(statearr_26433_26596[(2)] = inst_25948);

(statearr_26433_26596[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (80))){
var inst_26112 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_26252__$1 = state_26252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26252__$1,(83),inst_26112);
} else {
if((state_val_26253 === (37))){
var inst_26017 = (state_26252[(2)]);
var inst_26018 = fluree.db.util.async.throw_err(inst_26017);
var state_26252__$1 = state_26252;
var statearr_26434_26597 = state_26252__$1;
(statearr_26434_26597[(2)] = inst_26018);

(statearr_26434_26597[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (63))){
var inst_26071 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
if(cljs.core.truth_(inst_26071)){
var statearr_26435_26598 = state_26252__$1;
(statearr_26435_26598[(1)] = (64));

} else {
var statearr_26436_26599 = state_26252__$1;
(statearr_26436_26599[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (94))){
var inst_26148 = from;
var inst_26149 = cljs.core.seq(inst_26148);
var inst_26150 = cljs.core.first(inst_26149);
var inst_26151 = cljs.core.next(inst_26149);
var inst_26152 = cljs.core.PersistentVector.EMPTY;
var inst_26153 = inst_26148;
var inst_26154 = inst_26152;
var state_26252__$1 = (function (){var statearr_26437 = state_26252;
(statearr_26437[(42)] = inst_26150);

(statearr_26437[(43)] = inst_26151);

(statearr_26437[(38)] = inst_26153);

(statearr_26437[(10)] = inst_26154);

return statearr_26437;
})();
var statearr_26438_26600 = state_26252__$1;
(statearr_26438_26600[(2)] = null);

(statearr_26438_26600[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (8))){
var inst_25947 = (state_26252[(24)]);
var inst_25942 = (state_26252[(2)]);
var inst_25943 = opts_SINGLEQUOTE_;
var inst_25944 = cljs.core.__destructure_map(inst_25943);
var inst_25945 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25944,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_25946 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25944,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25947__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25944,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_25948 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25944,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_25949 = fluree.db.query.fql_parser.parse_db(db,inst_25942,opts_SINGLEQUOTE_);
var inst_25950 = (inst_25947__$1 == null);
var inst_25951 = cljs.core.not(inst_25950);
var state_26252__$1 = (function (){var statearr_26439 = state_26252;
(statearr_26439[(24)] = inst_25947__$1);

(statearr_26439[(13)] = inst_25946);

(statearr_26439[(15)] = inst_25948);

(statearr_26439[(18)] = inst_25945);

(statearr_26439[(25)] = inst_25949);

return statearr_26439;
})();
if(inst_25951){
var statearr_26440_26601 = state_26252__$1;
(statearr_26440_26601[(1)] = (15));

} else {
var statearr_26441_26602 = state_26252__$1;
(statearr_26441_26602[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (49))){
var inst_26223 = (state_26252[(2)]);
var state_26252__$1 = state_26252;
var statearr_26442_26603 = state_26252__$1;
(statearr_26442_26603[(2)] = inst_26223);

(statearr_26442_26603[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26253 === (84))){
var state_26252__$1 = state_26252;
var statearr_26443_26604 = state_26252__$1;
(statearr_26443_26604[(2)] = null);

(statearr_26443_26604[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2727__auto____0 = (function (){
var statearr_26444 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26444[(0)] = fluree$db$query$fql$query_$_state_machine__2727__auto__);

(statearr_26444[(1)] = (1));

return statearr_26444;
});
var fluree$db$query$fql$query_$_state_machine__2727__auto____1 = (function (state_26252){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26252);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26445){var ex__2730__auto__ = e26445;
var statearr_26446_26605 = state_26252;
(statearr_26446_26605[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26252[(4)]))){
var statearr_26447_26606 = state_26252;
(statearr_26447_26606[(1)] = cljs.core.first((state_26252[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26607 = state_26252;
state_26252 = G__26607;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2727__auto__ = function(state_26252){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2727__auto____1.call(this,state_26252);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2727__auto____0;
fluree$db$query$fql$query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2727__auto____1;
return fluree$db$query$fql$query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26448 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26448[(6)] = c__2749__auto__);

return statearr_26448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}

});
