// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4253__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_11479){
var state_val_11480 = (state_11479[(1)]);
if((state_val_11480 === (7))){
var inst_11474 = (state_11479[(2)]);
var _ = (function (){var statearr_11481 = state_11479;
(statearr_11481[(4)] = cljs.core.rest((state_11479[(4)])));

return statearr_11481;
})();
var state_11479__$1 = state_11479;
var statearr_11482_11504 = state_11479__$1;
(statearr_11482_11504[(2)] = inst_11474);

(statearr_11482_11504[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11480 === (1))){
var state_11479__$1 = state_11479;
var statearr_11483_11505 = state_11479__$1;
(statearr_11483_11505[(2)] = null);

(statearr_11483_11505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11480 === (4))){
var inst_11436 = (state_11479[(2)]);
var state_11479__$1 = state_11479;
var statearr_11484_11506 = state_11479__$1;
(statearr_11484_11506[(2)] = inst_11436);

(statearr_11484_11506[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11480 === (6))){
var inst_11454 = (state_11479[(7)]);
var inst_11461 = (state_11479[(8)]);
var inst_11460 = cljs.core.seq(inst_11454);
var inst_11461__$1 = cljs.core.first(inst_11460);
var inst_11462 = cljs.core.next(inst_11460);
var inst_11463 = cljs.core.not(inst_11461__$1);
var state_11479__$1 = (function (){var statearr_11485 = state_11479;
(statearr_11485[(9)] = inst_11462);

(statearr_11485[(8)] = inst_11461__$1);

return statearr_11485;
})();
if(inst_11463){
var statearr_11486_11507 = state_11479__$1;
(statearr_11486_11507[(1)] = (8));

} else {
var statearr_11487_11508 = state_11479__$1;
(statearr_11487_11508[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11480 === (3))){
var inst_11477 = (state_11479[(2)]);
var state_11479__$1 = state_11479;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11479__$1,inst_11477);
} else {
if((state_val_11480 === (2))){
var _ = (function (){var statearr_11488 = state_11479;
(statearr_11488[(4)] = cljs.core.cons((5),(state_11479[(4)])));

return statearr_11488;
})();
var inst_11449 = chs;
var inst_11450 = cljs.core.seq(inst_11449);
var inst_11451 = cljs.core.first(inst_11450);
var inst_11452 = cljs.core.next(inst_11450);
var inst_11453 = coll;
var inst_11454 = inst_11449;
var inst_11455 = inst_11453;
var state_11479__$1 = (function (){var statearr_11489 = state_11479;
(statearr_11489[(10)] = inst_11452);

(statearr_11489[(7)] = inst_11454);

(statearr_11489[(11)] = inst_11455);

(statearr_11489[(12)] = inst_11451);

return statearr_11489;
})();
var statearr_11490_11509 = state_11479__$1;
(statearr_11490_11509[(2)] = null);

(statearr_11490_11509[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11480 === (11))){
var inst_11462 = (state_11479[(9)]);
var inst_11455 = (state_11479[(11)]);
var inst_11467 = (state_11479[(2)]);
var inst_11468 = fluree.db.util.async.throw_err(inst_11467);
var inst_11469 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_11455,inst_11468);
var inst_11454 = inst_11462;
var inst_11455__$1 = inst_11469;
var state_11479__$1 = (function (){var statearr_11492 = state_11479;
(statearr_11492[(7)] = inst_11454);

(statearr_11492[(11)] = inst_11455__$1);

return statearr_11492;
})();
var statearr_11493_11510 = state_11479__$1;
(statearr_11493_11510[(2)] = null);

(statearr_11493_11510[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11480 === (9))){
var inst_11461 = (state_11479[(8)]);
var state_11479__$1 = state_11479;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11479__$1,(11),inst_11461);
} else {
if((state_val_11480 === (5))){
var _ = (function (){var statearr_11494 = state_11479;
(statearr_11494[(4)] = cljs.core.rest((state_11479[(4)])));

return statearr_11494;
})();
var state_11479__$1 = state_11479;
var ex11491 = (state_11479__$1[(2)]);
var statearr_11495_11511 = state_11479__$1;
(statearr_11495_11511[(5)] = ex11491);


var statearr_11496_11512 = state_11479__$1;
(statearr_11496_11512[(1)] = (4));

(statearr_11496_11512[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11480 === (10))){
var inst_11472 = (state_11479[(2)]);
var state_11479__$1 = state_11479;
var statearr_11497_11513 = state_11479__$1;
(statearr_11497_11513[(2)] = inst_11472);

(statearr_11497_11513[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11480 === (8))){
var inst_11455 = (state_11479[(11)]);
var state_11479__$1 = state_11479;
var statearr_11498_11514 = state_11479__$1;
(statearr_11498_11514[(2)] = inst_11455);

(statearr_11498_11514[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_11499 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11499[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__);

(statearr_11499[(1)] = (1));

return statearr_11499;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____1 = (function (state_11479){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_11479);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e11500){var ex__2730__auto__ = e11500;
var statearr_11501_11515 = state_11479;
(statearr_11501_11515[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_11479[(4)]))){
var statearr_11502_11516 = state_11479;
(statearr_11502_11516[(1)] = cljs.core.first((state_11479[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11517 = state_11479;
state_11479 = G__11517;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__ = function(state_11479){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____1.call(this,state_11479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_11503 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_11503[(6)] = c__2749__auto__);

return statearr_11503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_11543){
var state_val_11544 = (state_11543[(1)]);
if((state_val_11544 === (7))){
var inst_11538 = (state_11543[(2)]);
var _ = (function (){var statearr_11545 = state_11543;
(statearr_11545[(4)] = cljs.core.rest((state_11543[(4)])));

return statearr_11545;
})();
var state_11543__$1 = state_11543;
var statearr_11546_11568 = state_11543__$1;
(statearr_11546_11568[(2)] = inst_11538);

(statearr_11546_11568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11544 === (1))){
var state_11543__$1 = state_11543;
var statearr_11547_11569 = state_11543__$1;
(statearr_11547_11569[(2)] = null);

(statearr_11547_11569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11544 === (4))){
var inst_11518 = (state_11543[(2)]);
var state_11543__$1 = state_11543;
var statearr_11548_11570 = state_11543__$1;
(statearr_11548_11570[(2)] = inst_11518);

(statearr_11548_11570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11544 === (6))){
var state_11543__$1 = state_11543;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11543__$1,(8),chan);
} else {
if((state_val_11544 === (3))){
var inst_11541 = (state_11543[(2)]);
var state_11543__$1 = state_11543;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11543__$1,inst_11541);
} else {
if((state_val_11544 === (2))){
var _ = (function (){var statearr_11549 = state_11543;
(statearr_11549[(4)] = cljs.core.cons((5),(state_11543[(4)])));

return statearr_11549;
})();
var inst_11524 = coll;
var inst_11525 = inst_11524;
var state_11543__$1 = (function (){var statearr_11550 = state_11543;
(statearr_11550[(7)] = inst_11525);

return statearr_11550;
})();
var statearr_11551_11571 = state_11543__$1;
(statearr_11551_11571[(2)] = null);

(statearr_11551_11571[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11544 === (11))){
var inst_11536 = (state_11543[(2)]);
var state_11543__$1 = state_11543;
var statearr_11553_11572 = state_11543__$1;
(statearr_11553_11572[(2)] = inst_11536);

(statearr_11553_11572[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11544 === (9))){
var inst_11525 = (state_11543[(7)]);
var state_11543__$1 = state_11543;
var statearr_11554_11573 = state_11543__$1;
(statearr_11554_11573[(2)] = inst_11525);

(statearr_11554_11573[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11544 === (5))){
var _ = (function (){var statearr_11555 = state_11543;
(statearr_11555[(4)] = cljs.core.rest((state_11543[(4)])));

return statearr_11555;
})();
var state_11543__$1 = state_11543;
var ex11552 = (state_11543__$1[(2)]);
var statearr_11556_11574 = state_11543__$1;
(statearr_11556_11574[(5)] = ex11552);


var statearr_11557_11575 = state_11543__$1;
(statearr_11557_11575[(1)] = (4));

(statearr_11557_11575[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11544 === (10))){
var inst_11525 = (state_11543[(7)]);
var inst_11529 = (state_11543[(8)]);
var inst_11533 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_11525,inst_11529);
var inst_11525__$1 = inst_11533;
var state_11543__$1 = (function (){var statearr_11558 = state_11543;
(statearr_11558[(7)] = inst_11525__$1);

return statearr_11558;
})();
var statearr_11559_11576 = state_11543__$1;
(statearr_11559_11576[(2)] = null);

(statearr_11559_11576[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11544 === (8))){
var inst_11529 = (state_11543[(8)]);
var inst_11528 = (state_11543[(2)]);
var inst_11529__$1 = fluree.db.util.async.throw_err(inst_11528);
var inst_11530 = (inst_11529__$1 == null);
var state_11543__$1 = (function (){var statearr_11560 = state_11543;
(statearr_11560[(8)] = inst_11529__$1);

return statearr_11560;
})();
if(cljs.core.truth_(inst_11530)){
var statearr_11561_11577 = state_11543__$1;
(statearr_11561_11577[(1)] = (9));

} else {
var statearr_11562_11578 = state_11543__$1;
(statearr_11562_11578[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_11563 = [null,null,null,null,null,null,null,null,null];
(statearr_11563[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__);

(statearr_11563[(1)] = (1));

return statearr_11563;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____1 = (function (state_11543){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_11543);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e11564){var ex__2730__auto__ = e11564;
var statearr_11565_11579 = state_11543;
(statearr_11565_11579[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_11543[(4)]))){
var statearr_11566_11580 = state_11543;
(statearr_11566_11580[(1)] = cljs.core.first((state_11543[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11581 = state_11543;
state_11543 = G__11581;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__ = function(state_11543){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____1.call(this,state_11543);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_11567 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_11567[(6)] = c__2749__auto__);

return statearr_11567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
