// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureeworker');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.session');
goog.require('fluree.db.connection');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.connection_js');
goog.require('goog.object');
goog.scope(function(){
flureeworker.goog$module$goog$object = goog.module.get('goog.object');
});
flureeworker.conn_register = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
flureeworker.postMessage = (function flureeworker$postMessage(message){
return self.postMessage(cljs.core.clj__GT_js(message));
});
flureeworker.conn_id__GT_db = (function flureeworker$conn_id__GT_db(conn_id,time){
var map__63674 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63674__$1 = cljs.core.__destructure_map(map__63674);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63674__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63674__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"block","block",664686210),time], null));
});
/**
 * Parses a (nested) JavaScript object into a Clojure map
 */
flureeworker.obj__GT_clj = (function flureeworker$obj__GT_clj(obj){
if(cljs.core.truth_(goog.isObject(obj))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,key){
var v = flureeworker.goog$module$goog$object.get.call(null,obj,key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("function",goog.typeOf(v))){
return result;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),(flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1 ? flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1(v) : flureeworker.obj__GT_clj.call(null,v)));
}
}),cljs.core.PersistentArrayMap.EMPTY,goog.object.getKeys(obj));
} else {
return obj;
}
});
if((typeof flureeworker !== 'undefined') && (typeof flureeworker.worker_action !== 'undefined')){
} else {
flureeworker.worker_action = (function (){var method_table__4747__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__63675 = cljs.core.get_global_hierarchy;
return (fexpr__63675.cljs$core$IFn$_invoke$arity$0 ? fexpr__63675.cljs$core$IFn$_invoke$arity$0() : fexpr__63675.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("flureeworker","worker-action"),(function() { 
var G__63676__delegate = function (conn_id,event,_){
return event;
};
var G__63676 = function (conn_id,event,var_args){
var _ = null;
if (arguments.length > 2) {
var G__63677__i = 0, G__63677__a = new Array(arguments.length -  2);
while (G__63677__i < G__63677__a.length) {G__63677__a[G__63677__i] = arguments[G__63677__i + 2]; ++G__63677__i;}
  _ = new cljs.core.IndexedSeq(G__63677__a,0,null);
} 
return G__63676__delegate.call(this,conn_id,event,_);};
G__63676.cljs$lang$maxFixedArity = 2;
G__63676.cljs$lang$applyTo = (function (arglist__63678){
var conn_id = cljs.core.first(arglist__63678);
arglist__63678 = cljs.core.next(arglist__63678);
var event = cljs.core.first(arglist__63678);
var _ = cljs.core.rest(arglist__63678);
return G__63676__delegate(conn_id,event,_);
});
G__63676.cljs$core$IFn$_invoke$arity$variadic = G__63676__delegate;
return G__63676;
})()
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setState","setState",552299271),(function (conn_id,_,id,state_update){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setState",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(state_update)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connStatus","connStatus",63327857),(function (conn_id,_,id,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connStatus",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"login","login",55217519),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"login",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"pwGenerate",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connClosed","connClosed",1810797125),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connClosed",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connReset","connReset",-1382938159),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connReset",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setTransact","setTransact",1791803585),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setTransact",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connInit","connInit",-148647574),(function (_,___$1){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"conn","conn",278309663),(0),new cljs.core.Keyword(null,"event","event",301435442),"connInit"], null));
}));
/**
 * Send an error map back to the worker invoker
 */
flureeworker.error_return_map = (function flureeworker$error_return_map(error){
var default_error = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"message","message",-406056002),(function (){var or__4253__auto__ = cljs.core.ex_message(error);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unknown Error.";
}
})(),new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
var e_map = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([default_error,cljs.core.ex_data(error)], 0));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),e_map,new cljs.core.Keyword(null,"status","status",-1997798413),"error"], null);
});
/**
 * Process a query for a specific component id and return result with a :setState call.
 */
flureeworker.process_query = (function flureeworker$process_query(conn_id,id,conn_opts){
var flureeql = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),id], null));
var jwt = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null));
var opts_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([conn_opts,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(flureeql)], 0)),new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt);
if(cljs.core.truth_(flureeql)){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63696){
var state_val_63697 = (state_63696[(1)]);
if((state_val_63697 === (1))){
var inst_63679 = new cljs.core.Keyword(null,"forceTime","forceTime",827124337).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var inst_63680 = flureeworker.conn_id__GT_db(conn_id,inst_63679);
var inst_63681 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeql,new cljs.core.Keyword(null,"opts","opts",155075701),opts_SINGLEQUOTE_);
var inst_63682 = fluree.db.api.query.query(inst_63680,inst_63681);
var state_63696__$1 = state_63696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63696__$1,(2),inst_63682);
} else {
if((state_val_63697 === (2))){
var inst_63684 = (state_63696[(7)]);
var inst_63684__$1 = (state_63696[(2)]);
var inst_63685 = fluree.db.util.core.exception_QMARK_(inst_63684__$1);
var state_63696__$1 = (function (){var statearr_63698 = state_63696;
(statearr_63698[(7)] = inst_63684__$1);

return statearr_63698;
})();
if(inst_63685){
var statearr_63699_63712 = state_63696__$1;
(statearr_63699_63712[(1)] = (3));

} else {
var statearr_63700_63713 = state_63696__$1;
(statearr_63700_63713[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63697 === (3))){
var inst_63684 = (state_63696[(7)]);
var inst_63687 = flureeworker.error_return_map(inst_63684);
var state_63696__$1 = state_63696;
var statearr_63701_63714 = state_63696__$1;
(statearr_63701_63714[(2)] = inst_63687);

(statearr_63701_63714[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63697 === (4))){
var inst_63684 = (state_63696[(7)]);
var inst_63689 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_63690 = [inst_63684,"loaded"];
var inst_63691 = cljs.core.PersistentHashMap.fromArrays(inst_63689,inst_63690);
var state_63696__$1 = state_63696;
var statearr_63702_63715 = state_63696__$1;
(statearr_63702_63715[(2)] = inst_63691);

(statearr_63702_63715[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63697 === (5))){
var inst_63693 = (state_63696[(2)]);
var inst_63694 = (function (){var G__63703 = conn_id;
var G__63704 = new cljs.core.Keyword(null,"setState","setState",552299271);
var G__63705 = id;
var G__63706 = inst_63693;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63703,G__63704,G__63705,G__63706) : flureeworker.worker_action.call(null,G__63703,G__63704,G__63705,G__63706));
})();
var state_63696__$1 = state_63696;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63696__$1,inst_63694);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$process_query_$_state_machine__2727__auto__ = null;
var flureeworker$process_query_$_state_machine__2727__auto____0 = (function (){
var statearr_63707 = [null,null,null,null,null,null,null,null];
(statearr_63707[(0)] = flureeworker$process_query_$_state_machine__2727__auto__);

(statearr_63707[(1)] = (1));

return statearr_63707;
});
var flureeworker$process_query_$_state_machine__2727__auto____1 = (function (state_63696){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63696);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63708){var ex__2730__auto__ = e63708;
var statearr_63709_63716 = state_63696;
(statearr_63709_63716[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63696[(4)]))){
var statearr_63710_63717 = state_63696;
(statearr_63710_63717[(1)] = cljs.core.first((state_63696[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63718 = state_63696;
state_63696 = G__63718;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$process_query_$_state_machine__2727__auto__ = function(state_63696){
switch(arguments.length){
case 0:
return flureeworker$process_query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$process_query_$_state_machine__2727__auto____1.call(this,state_63696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$process_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$process_query_$_state_machine__2727__auto____0;
flureeworker$process_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$process_query_$_state_machine__2727__auto____1;
return flureeworker$process_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63711 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63711[(6)] = c__2749__auto__);

return statearr_63711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
/**
 * Re-execute every registered query.
 */
flureeworker.process_all_queries = (function flureeworker$process_all_queries(conn_id){
var map__63719 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63719__$1 = cljs.core.__destructure_map(map__63719);
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63719__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63719__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var query_ids = cljs.core.keys(queries);
var seq__63720 = cljs.core.seq(query_ids);
var chunk__63721 = null;
var count__63722 = (0);
var i__63723 = (0);
while(true){
if((i__63723 < count__63722)){
var id = chunk__63721.cljs$core$IIndexed$_nth$arity$2(null,i__63723);
flureeworker.process_query(conn_id,id,opts);


var G__63724 = seq__63720;
var G__63725 = chunk__63721;
var G__63726 = count__63722;
var G__63727 = (i__63723 + (1));
seq__63720 = G__63724;
chunk__63721 = G__63725;
count__63722 = G__63726;
i__63723 = G__63727;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__63720);
if(temp__5753__auto__){
var seq__63720__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63720__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__63720__$1);
var G__63728 = cljs.core.chunk_rest(seq__63720__$1);
var G__63729 = c__4679__auto__;
var G__63730 = cljs.core.count(c__4679__auto__);
var G__63731 = (0);
seq__63720 = G__63728;
chunk__63721 = G__63729;
count__63722 = G__63730;
i__63723 = G__63731;
continue;
} else {
var id = cljs.core.first(seq__63720__$1);
flureeworker.process_query(conn_id,id,opts);


var G__63732 = cljs.core.next(seq__63720__$1);
var G__63733 = null;
var G__63734 = (0);
var G__63735 = (0);
seq__63720 = G__63732;
chunk__63721 = G__63733;
count__63722 = G__63734;
i__63723 = G__63735;
continue;
}
} else {
return null;
}
}
break;
}
});
flureeworker.ledger_listener = (function flureeworker$ledger_listener(conn,ledger,conn_id){
var vec__63736 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63736,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63736,(1),null);
var cb = (function (header,data){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63744){
var state_val_63745 = (state_63744[(1)]);
if((state_val_63745 === (1))){
var inst_63739 = cljs.core.async.timeout((100));
var state_63744__$1 = state_63744;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63744__$1,(2),inst_63739);
} else {
if((state_val_63745 === (2))){
var inst_63741 = (state_63744[(2)]);
var inst_63742 = flureeworker.process_all_queries(conn_id);
var state_63744__$1 = (function (){var statearr_63746 = state_63744;
(statearr_63746[(7)] = inst_63741);

return statearr_63746;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63744__$1,inst_63742);
} else {
return null;
}
}
});
return (function() {
var flureeworker$ledger_listener_$_state_machine__2727__auto__ = null;
var flureeworker$ledger_listener_$_state_machine__2727__auto____0 = (function (){
var statearr_63747 = [null,null,null,null,null,null,null,null];
(statearr_63747[(0)] = flureeworker$ledger_listener_$_state_machine__2727__auto__);

(statearr_63747[(1)] = (1));

return statearr_63747;
});
var flureeworker$ledger_listener_$_state_machine__2727__auto____1 = (function (state_63744){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63744);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63748){var ex__2730__auto__ = e63748;
var statearr_63749_63752 = state_63744;
(statearr_63749_63752[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63744[(4)]))){
var statearr_63750_63753 = state_63744;
(statearr_63750_63753[(1)] = cljs.core.first((state_63744[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63754 = state_63744;
state_63744 = G__63754;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$ledger_listener_$_state_machine__2727__auto__ = function(state_63744){
switch(arguments.length){
case 0:
return flureeworker$ledger_listener_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$ledger_listener_$_state_machine__2727__auto____1.call(this,state_63744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$ledger_listener_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$ledger_listener_$_state_machine__2727__auto____0;
flureeworker$ledger_listener_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$ledger_listener_$_state_machine__2727__auto____1;
return flureeworker$ledger_listener_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63751 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63751[(6)] = c__2749__auto__);

return statearr_63751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
return fluree.db.connection.add_listener(conn,network,ledger_id,conn_id,cb);
});
flureeworker.remove_conn_listener = (function flureeworker$remove_conn_listener(conn,conn_id,ledger){
var vec__63755 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63755,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63755,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,conn_id);
});
/**
 * Registers new connection with all of its items.
 */
flureeworker.register_connection = (function flureeworker$register_connection(conn,config,queries){
var map__63758 = config;
var map__63758__$1 = cljs.core.__destructure_map(map__63758);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63758__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63758__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63758__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var log = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63758__$1,new cljs.core.Keyword(null,"log","log",-1595516004));
var compact = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63758__$1,new cljs.core.Keyword(null,"compact","compact",-348732150));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63758__$1,new cljs.core.Keyword(null,"private","private",-558947994));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,id,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"closed","closed",-919675359),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"queries","queries",1446291995),new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"conn","conn",278309663)],[false,ledger,private$,config,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"compact","compact",-348732150),compact], null),servers,(function (){var or__4253__auto__ = queries;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),log,conn]));
});
/**
 * Creates a new connection from existing configuration
 */
flureeworker.connect_STAR_ = (function flureeworker$connect_STAR_(conn_id,ref){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63759 = conn_data;
var map__63759__$1 = cljs.core.__destructure_map(map__63759);
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63759__$1,new cljs.core.Keyword(null,"config","config",994861415));
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63759__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63759__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var map__63760 = config;
var map__63760__$1 = cljs.core.__destructure_map(map__63760);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63760__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63760__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63760__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63760__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63766){
var state_val_63767 = (state_63766[(1)]);
if((state_val_63767 === (1))){
var inst_63761 = cljs.core.async.timeout((100));
var state_63766__$1 = state_63766;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63766__$1,(2),inst_63761);
} else {
if((state_val_63767 === (2))){
var inst_63763 = (state_63766[(2)]);
var inst_63764 = (flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2 ? flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2(id,ref) : flureeworker.connect_STAR_.call(null,id,ref));
var state_63766__$1 = (function (){var statearr_63768 = state_63766;
(statearr_63768[(7)] = inst_63763);

return statearr_63768;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63766__$1,inst_63764);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_STAR__$_state_machine__2727__auto__ = null;
var flureeworker$connect_STAR__$_state_machine__2727__auto____0 = (function (){
var statearr_63769 = [null,null,null,null,null,null,null,null];
(statearr_63769[(0)] = flureeworker$connect_STAR__$_state_machine__2727__auto__);

(statearr_63769[(1)] = (1));

return statearr_63769;
});
var flureeworker$connect_STAR__$_state_machine__2727__auto____1 = (function (state_63766){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63766);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63770){var ex__2730__auto__ = e63770;
var statearr_63771_63782 = state_63766;
(statearr_63771_63782[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63766[(4)]))){
var statearr_63772_63783 = state_63766;
(statearr_63772_63783[(1)] = cljs.core.first((state_63766[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63784 = state_63766;
state_63766 = G__63784;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$connect_STAR__$_state_machine__2727__auto__ = function(state_63766){
switch(arguments.length){
case 0:
return flureeworker$connect_STAR__$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$connect_STAR__$_state_machine__2727__auto____1.call(this,state_63766);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_STAR__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_STAR__$_state_machine__2727__auto____0;
flureeworker$connect_STAR__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_STAR__$_state_machine__2727__auto____1;
return flureeworker$connect_STAR__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63773 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63773[(6)] = c__2749__auto__);

return statearr_63773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}):null);
var opts = cljs.core.assoc_in(config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
if(cljs.core.truth_(jwt)){
fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
} else {
}

flureeworker.register_connection(conn,config,queries);

flureeworker.ledger_listener(conn,ledger,id);

var G__63774_63785 = conn_id;
var G__63775_63786 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__63776_63787 = ref;
var G__63777_63788 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection reset"], null);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63774_63785,G__63775_63786,G__63776_63787,G__63777_63788) : flureeworker.worker_action.call(null,G__63774_63785,G__63775_63786,G__63776_63787,G__63777_63788));

return flureeworker.process_all_queries(conn_id);
})).catch((function (error){
var error_data = (function (){var temp__5751__auto__ = cljs.core.ex_data(error);
if(cljs.core.truth_(temp__5751__auto__)){
var ex_data = temp__5751__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(error)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))].join('')], null);
}
})();
var G__63778 = conn_id;
var G__63779 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__63780 = ref;
var G__63781 = error_data;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63778,G__63779,G__63780,G__63781) : flureeworker.worker_action.call(null,G__63778,G__63779,G__63780,G__63781));
}));
});
flureeworker.close_connection_STAR_ = (function flureeworker$close_connection_STAR_(var_args){
var G__63790 = arguments.length;
switch (G__63790) {
case 1:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,false);
}));

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,save_config_QMARK_){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63791 = conn_data;
var map__63791__$1 = cljs.core.__destructure_map(map__63791);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63791__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63791__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63791__$1,new cljs.core.Keyword(null,"config","config",994861415));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63791__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var new_config = (cljs.core.truth_(save_config_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"closed","closed",-919675359),true,new cljs.core.Keyword(null,"config","config",994861415),config,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"closed","closed",-919675359),true], null));
if((((conn_data == null)) || (new cljs.core.Keyword(null,"closed","closed",-919675359).cljs$core$IFn$_invoke$arity$1(conn_data) === true))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection doesn't exist, or is already closed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
flureeworker.remove_conn_listener(conn,conn_id,ledger);

fluree.db.connection_js.close(conn);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,conn_id,new_config);

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection closed."], null);
}
}));

(flureeworker.close_connection_STAR_.cljs$lang$maxFixedArity = 2);

flureeworker.close_connection = (function flureeworker$close_connection(conn_id,ref){
try{var G__63798 = conn_id;
var G__63799 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__63800 = ref;
var G__63801 = flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1(conn_id);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63798,G__63799,G__63800,G__63801) : flureeworker.worker_action.call(null,G__63798,G__63799,G__63800,G__63801));
}catch (e63793){var e = e63793;
var msg = (function (){var or__4253__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4253__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__63794 = conn_id;
var G__63795 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__63796 = ref;
var G__63797 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63794,G__63795,G__63796,G__63797) : flureeworker.worker_action.call(null,G__63794,G__63795,G__63796,G__63797));
}});
flureeworker.reset_connection = (function flureeworker$reset_connection(conn_id,ref){
try{var save_config_QMARK_ = true;
flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,save_config_QMARK_);

return flureeworker.connect_STAR_(conn_id,ref);
}catch (e63802){var e = e63802;
var msg = (function (){var or__4253__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4253__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__63803 = conn_id;
var G__63804 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__63805 = ref;
var G__63806 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63803,G__63804,G__63805,G__63806) : flureeworker.worker_action.call(null,G__63803,G__63804,G__63805,G__63806));
}});
/**
 * Open new connection to a Fluree instance
 */
flureeworker.connect_p = (function flureeworker$connect_p(config,ref){
var config_STAR_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(config,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__63807 = config_STAR_;
var map__63807__$1 = cljs.core.__destructure_map(map__63807);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63807__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63807__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63807__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63807__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"log","log",-1595516004).cljs$core$IFn$_invoke$arity$1(config_STAR_))?fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"finest","finest",-1359568890)):null);
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63813){
var state_val_63814 = (state_63813[(1)]);
if((state_val_63814 === (1))){
var inst_63808 = cljs.core.async.timeout((100));
var state_63813__$1 = state_63813;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63813__$1,(2),inst_63808);
} else {
if((state_val_63814 === (2))){
var inst_63810 = (state_63813[(2)]);
var inst_63811 = flureeworker.connect_STAR_(id,ref);
var state_63813__$1 = (function (){var statearr_63815 = state_63813;
(statearr_63815[(7)] = inst_63810);

return statearr_63815;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63813__$1,inst_63811);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_p_$_state_machine__2727__auto__ = null;
var flureeworker$connect_p_$_state_machine__2727__auto____0 = (function (){
var statearr_63816 = [null,null,null,null,null,null,null,null];
(statearr_63816[(0)] = flureeworker$connect_p_$_state_machine__2727__auto__);

(statearr_63816[(1)] = (1));

return statearr_63816;
});
var flureeworker$connect_p_$_state_machine__2727__auto____1 = (function (state_63813){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63813);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63817){var ex__2730__auto__ = e63817;
var statearr_63818_63829 = state_63813;
(statearr_63818_63829[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63813[(4)]))){
var statearr_63819_63830 = state_63813;
(statearr_63819_63830[(1)] = cljs.core.first((state_63813[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63831 = state_63813;
state_63813 = G__63831;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$connect_p_$_state_machine__2727__auto__ = function(state_63813){
switch(arguments.length){
case 0:
return flureeworker$connect_p_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$connect_p_$_state_machine__2727__auto____1.call(this,state_63813);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_p_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_p_$_state_machine__2727__auto____0;
flureeworker$connect_p_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_p_$_state_machine__2727__auto____1;
return flureeworker$connect_p_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63820 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63820[(6)] = c__2749__auto__);

return statearr_63820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}):null);
var opts = cljs.core.assoc_in(config_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
flureeworker.register_connection(conn,config_STAR_,null);

flureeworker.ledger_listener(conn,ledger,id);

var G__63821 = id;
var G__63822 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__63823 = ref;
var G__63824 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection is ready."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63821,G__63822,G__63823,G__63824) : flureeworker.worker_action.call(null,G__63821,G__63822,G__63823,G__63824));
})).catch((function (error){
var G__63825 = id;
var G__63826 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__63827 = ref;
var G__63828 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.str.cljs$core$IFn$_invoke$arity$1(error)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63825,G__63826,G__63827,G__63828) : flureeworker.worker_action.call(null,G__63825,G__63826,G__63827,G__63828));
}));
});
/**
 * Returns true if connection has been closed.
 */
flureeworker.conn_closed_QMARK_ = (function flureeworker$conn_closed_QMARK_(conn_id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"closed","closed",-919675359)], null));
});
/**
 * Authenticate with ledger via username and password.
 * 
 * If authentication is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.login = (function flureeworker$login(var_args){
var args__4870__auto__ = [];
var len__4864__auto___63899 = arguments.length;
var i__4865__auto___63900 = (0);
while(true){
if((i__4865__auto___63900 < len__4864__auto___63899)){
args__4870__auto__.push((arguments[i__4865__auto___63900]));

var G__63901 = (i__4865__auto___63900 + (1));
i__4865__auto___63900 = G__63901;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((4) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((4)),(0),null)):null);
return flureeworker.login.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4871__auto__);
});

(flureeworker.login.cljs$core$IFn$_invoke$arity$variadic = (function (conn_id,ref,username,password,p__63837){
var vec__63838 = p__63837;
var expire = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63838,(0),null);
var map__63841 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63841__$1 = cljs.core.__destructure_map(map__63841);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63841__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63841__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63841__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__63842 = conn_id;
var G__63843 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63844 = ref;
var G__63845 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63842,G__63843,G__63844,G__63845) : flureeworker.worker_action.call(null,G__63842,G__63843,G__63844,G__63845));
})());
var auth = null;
var c__2749__auto___63902 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63866){
var state_val_63867 = (state_63866[(1)]);
if((state_val_63867 === (1))){
var state_63866__$1 = state_63866;
var statearr_63868_63903 = state_63866__$1;
(statearr_63868_63903[(2)] = null);

(statearr_63868_63903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63867 === (2))){
var ___$1 = (function (){var statearr_63869 = state_63866;
(statearr_63869[(4)] = cljs.core.cons((5),(state_63866[(4)])));

return statearr_63869;
})();
var inst_63857 = fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,username,auth,expire);
var inst_63858 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__63870 = conn_id;
var G__63871 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63872 = ref;
var G__63873 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63870,G__63871,G__63872,G__63873) : flureeworker.worker_action.call(null,G__63870,G__63871,G__63872,G__63873));
});
})();
var inst_63859 = inst_63857.then(inst_63858);
var inst_63860 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e63874){var ___$2 = e63874;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Authentication failed: unknown authentication error";
}
})();
var error = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__63875 = conn_id;
var G__63876 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63877 = ref;
var G__63878 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63875,G__63876,G__63877,G__63878) : flureeworker.worker_action.call(null,G__63875,G__63876,G__63877,G__63878));
} else {
var G__63879 = conn_id;
var G__63880 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63881 = ref;
var G__63882 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Authentication failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63879,G__63880,G__63881,G__63882) : flureeworker.worker_action.call(null,G__63879,G__63880,G__63881,G__63882));

}
});
})();
var inst_63861 = inst_63859.catch(inst_63860);
var ___$2 = (function (){var statearr_63883 = state_63866;
(statearr_63883[(4)] = cljs.core.rest((state_63866[(4)])));

return statearr_63883;
})();
var state_63866__$1 = state_63866;
var statearr_63884_63904 = state_63866__$1;
(statearr_63884_63904[(2)] = inst_63861);

(statearr_63884_63904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63867 === (3))){
var inst_63864 = (state_63866[(2)]);
var state_63866__$1 = state_63866;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63866__$1,inst_63864);
} else {
if((state_val_63867 === (4))){
var inst_63846 = (state_63866[(2)]);
var inst_63847 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_63848 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63846);
var inst_63849 = [(400),inst_63848];
var inst_63850 = cljs.core.PersistentHashMap.fromArrays(inst_63847,inst_63849);
var inst_63851 = (function (){var G__63886 = conn_id;
var G__63887 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63888 = ref;
var G__63889 = inst_63850;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63886,G__63887,G__63888,G__63889) : flureeworker.worker_action.call(null,G__63886,G__63887,G__63888,G__63889));
})();
var state_63866__$1 = state_63866;
var statearr_63890_63905 = state_63866__$1;
(statearr_63890_63905[(2)] = inst_63851);

(statearr_63890_63905[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63867 === (5))){
var ___$1 = (function (){var statearr_63891 = state_63866;
(statearr_63891[(4)] = cljs.core.rest((state_63866[(4)])));

return statearr_63891;
})();
var state_63866__$1 = state_63866;
var ex63885 = (state_63866__$1[(2)]);
var statearr_63892_63906 = state_63866__$1;
(statearr_63892_63906[(5)] = ex63885);


var statearr_63893_63907 = state_63866__$1;
(statearr_63893_63907[(1)] = (4));

(statearr_63893_63907[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$state_machine__2727__auto__ = null;
var flureeworker$state_machine__2727__auto____0 = (function (){
var statearr_63894 = [null,null,null,null,null,null,null];
(statearr_63894[(0)] = flureeworker$state_machine__2727__auto__);

(statearr_63894[(1)] = (1));

return statearr_63894;
});
var flureeworker$state_machine__2727__auto____1 = (function (state_63866){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63866);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63895){var ex__2730__auto__ = e63895;
var statearr_63896_63908 = state_63866;
(statearr_63896_63908[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63866[(4)]))){
var statearr_63897_63909 = state_63866;
(statearr_63897_63909[(1)] = cljs.core.first((state_63866[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63910 = state_63866;
state_63866 = G__63910;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$state_machine__2727__auto__ = function(state_63866){
switch(arguments.length){
case 0:
return flureeworker$state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$state_machine__2727__auto____1.call(this,state_63866);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$state_machine__2727__auto____0;
flureeworker$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$state_machine__2727__auto____1;
return flureeworker$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63898 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63898[(6)] = c__2749__auto___63902);

return statearr_63898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return true;
}));

(flureeworker.login.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(flureeworker.login.cljs$lang$applyTo = (function (seq63832){
var G__63833 = cljs.core.first(seq63832);
var seq63832__$1 = cljs.core.next(seq63832);
var G__63834 = cljs.core.first(seq63832__$1);
var seq63832__$2 = cljs.core.next(seq63832__$1);
var G__63835 = cljs.core.first(seq63832__$2);
var seq63832__$3 = cljs.core.next(seq63832__$2);
var G__63836 = cljs.core.first(seq63832__$3);
var seq63832__$4 = cljs.core.next(seq63832__$3);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63833,G__63834,G__63835,G__63836,seq63832__$4);
}));

/**
 * Attempts to generate a new user auth record account.
 * 
 * If request is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.pw_generate = (function flureeworker$pw_generate(conn_id,ref,map_data){
var map__63911 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63911__$1 = cljs.core.__destructure_map(map__63911);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63911__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63911__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__63913 = conn_id;
var G__63914 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63915 = ref;
var G__63916 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63913,G__63914,G__63915,G__63916) : flureeworker.worker_action.call(null,G__63913,G__63914,G__63915,G__63916));
})());
var map__63912 = map_data;
var map__63912__$1 = cljs.core.__destructure_map(map__63912);
var username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63912__$1,new cljs.core.Keyword(null,"username","username",1605666410));
var password = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63912__$1,new cljs.core.Keyword(null,"password","password",417022471));
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63912__$1,new cljs.core.Keyword(null,"options","options",99638489));
var opts = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys(options,cljs.core.keys(options)),new cljs.core.Keyword(null,"user","user",1532431356),username);
var c__2749__auto___63970 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63937){
var state_val_63938 = (state_63937[(1)]);
if((state_val_63938 === (1))){
var state_63937__$1 = state_63937;
var statearr_63939_63971 = state_63937__$1;
(statearr_63939_63971[(2)] = null);

(statearr_63939_63971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63938 === (2))){
var ___$1 = (function (){var statearr_63940 = state_63937;
(statearr_63940[(4)] = cljs.core.cons((5),(state_63937[(4)])));

return statearr_63940;
})();
var inst_63928 = fluree.db.connection_js.password_generate(conn,ledger,password,opts);
var inst_63929 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__63941 = conn_id;
var G__63942 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__63943 = ref;
var G__63944 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63941,G__63942,G__63943,G__63944) : flureeworker.worker_action.call(null,G__63941,G__63942,G__63943,G__63944));
});
})();
var inst_63930 = inst_63928.then(inst_63929);
var inst_63931 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e63945){var ___$2 = e63945;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Password Generation failed: unknown error";
}
})();
var error = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__63946 = conn_id;
var G__63947 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__63948 = ref;
var G__63949 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63946,G__63947,G__63948,G__63949) : flureeworker.worker_action.call(null,G__63946,G__63947,G__63948,G__63949));
} else {
var G__63950 = conn_id;
var G__63951 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__63952 = ref;
var G__63953 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Password Generation failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63950,G__63951,G__63952,G__63953) : flureeworker.worker_action.call(null,G__63950,G__63951,G__63952,G__63953));

}
});
})();
var inst_63932 = inst_63930.catch(inst_63931);
var ___$2 = (function (){var statearr_63954 = state_63937;
(statearr_63954[(4)] = cljs.core.rest((state_63937[(4)])));

return statearr_63954;
})();
var state_63937__$1 = state_63937;
var statearr_63955_63972 = state_63937__$1;
(statearr_63955_63972[(2)] = inst_63932);

(statearr_63955_63972[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63938 === (3))){
var inst_63935 = (state_63937[(2)]);
var state_63937__$1 = state_63937;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63937__$1,inst_63935);
} else {
if((state_val_63938 === (4))){
var inst_63917 = (state_63937[(2)]);
var inst_63918 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_63919 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63917);
var inst_63920 = [(400),inst_63919];
var inst_63921 = cljs.core.PersistentHashMap.fromArrays(inst_63918,inst_63920);
var inst_63922 = (function (){var G__63957 = conn_id;
var G__63958 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__63959 = ref;
var G__63960 = inst_63921;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63957,G__63958,G__63959,G__63960) : flureeworker.worker_action.call(null,G__63957,G__63958,G__63959,G__63960));
})();
var state_63937__$1 = state_63937;
var statearr_63961_63973 = state_63937__$1;
(statearr_63961_63973[(2)] = inst_63922);

(statearr_63961_63973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63938 === (5))){
var ___$1 = (function (){var statearr_63962 = state_63937;
(statearr_63962[(4)] = cljs.core.rest((state_63937[(4)])));

return statearr_63962;
})();
var state_63937__$1 = state_63937;
var ex63956 = (state_63937__$1[(2)]);
var statearr_63963_63974 = state_63937__$1;
(statearr_63963_63974[(5)] = ex63956);


var statearr_63964_63975 = state_63937__$1;
(statearr_63964_63975[(1)] = (4));

(statearr_63964_63975[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$pw_generate_$_state_machine__2727__auto__ = null;
var flureeworker$pw_generate_$_state_machine__2727__auto____0 = (function (){
var statearr_63965 = [null,null,null,null,null,null,null];
(statearr_63965[(0)] = flureeworker$pw_generate_$_state_machine__2727__auto__);

(statearr_63965[(1)] = (1));

return statearr_63965;
});
var flureeworker$pw_generate_$_state_machine__2727__auto____1 = (function (state_63937){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63937);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63966){var ex__2730__auto__ = e63966;
var statearr_63967_63976 = state_63937;
(statearr_63967_63976[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63937[(4)]))){
var statearr_63968_63977 = state_63937;
(statearr_63968_63977[(1)] = cljs.core.first((state_63937[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63978 = state_63937;
state_63937 = G__63978;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$pw_generate_$_state_machine__2727__auto__ = function(state_63937){
switch(arguments.length){
case 0:
return flureeworker$pw_generate_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$pw_generate_$_state_machine__2727__auto____1.call(this,state_63937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$pw_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$pw_generate_$_state_machine__2727__auto____0;
flureeworker$pw_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$pw_generate_$_state_machine__2727__auto____1;
return flureeworker$pw_generate_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63969 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63969[(6)] = c__2749__auto___63970);

return statearr_63969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return true;
});
flureeworker.unregisterQuery = (function flureeworker$unregisterQuery(conn_id,ref){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref], 0));
});
/**
 * Registers a new flureeQL query. 'opts' gets merged in with the flureeQL.opts, and is there
 *   to ease adding options to a GraphQL (and later other string-based queries like SPARQL and SQL),
 *   which do not have the same ability to dynamically add options.
 */
flureeworker.registerQuery = (function flureeworker$registerQuery(conn_id,ref,js_flurql,force_update_QMARK_){
var flureeQL = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(js_flurql,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(flureeQL,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),ref], null)))) || (force_update_QMARK_ === true))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref,flureeQL], 0));

flureeworker.process_query(conn_id,ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"opts","opts",155075701)], null)));
} else {
}

return true;
});
/**
 * Submits a transaction across a websocket to a fluree instance
 */
flureeworker.transact = (function flureeworker$transact(conn_id,ref,map_data){
return new cljs.core.Keyword(null,"TODO","TODO",-523795145);
});
/**
 * Takes javascript array and move it into a clojurescript list without
 *   converting individual elements.
 */
flureeworker.js_array__GT_clj_list = (function flureeworker$js_array__GT_clj_list(js_array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__63979_SHARP_){
return (js_array[p1__63979_SHARP_]);
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(js_array.length));
});
/**
 * Main handler function for worker events
 *   Even data is a javascript object with the following keys:
 *   - action - the action to perform
 *   - params - parameters for the action we are calling
 *   - conn - the connection ID
 *   - ref - the reference ID to include in the response
 *   
 */
flureeworker.decode_message = (function flureeworker$decode_message(event){
try{var data = (event["data"]);
var action_str = (data["action"]);
var conn_id = (data["conn"]);
var ref = (data["ref"]);
var params_js = (data["params"]);
var params = ((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact"))))?flureeworker.obj__GT_clj(cljs.core.first(params_js)):flureeworker.js_array__GT_clj_list(params_js)
);
if(cljs.core.truth_(flureeworker.conn_closed_QMARK_(conn_id))){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),action_str,new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),({"status": (400), "message": "Connection has been closed."})], null));
} else {
return null;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"connect")){
return flureeworker.connect_p(cljs.core.first(params),ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"close")){
return flureeworker.close_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"reset")){
return flureeworker.reset_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"registerQuery")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(flureeworker.registerQuery,conn_id,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.unregisterQuery(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"login")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(flureeworker.login,conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")){
return flureeworker.pw_generate(conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact")){
return flureeworker.transact(conn_id,ref,params);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unknown action: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(action_str)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"status","status",-1997798413),(400)], null));

}
}
}
}
}
}
}
}
}
}catch (e63980){var e = e63980;
var data = (event["data"]);
var error_data = (function (){var temp__5751__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(temp__5751__auto__)){
var ex_data = temp__5751__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(e)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0))].join('')], null);
}
})();
console.error("Error executing message:",data);

console.error(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0)));

return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),(data["conn"]),new cljs.core.Keyword(null,"event","event",301435442),(data["action"]),new cljs.core.Keyword(null,"ref","ref",1289896967),(data["ref"]),new cljs.core.Keyword(null,"data","data",-232669377),error_data], null));
}});
/**
 * Log errors in this web worker
 */
flureeworker.log_error = (function flureeworker$log_error(error){
return console.error(error);
});
var temp__5753__auto___63981 = cljs.core.not(self.document);
if(temp__5753__auto___63981){
var worker_QMARK__63982 = temp__5753__auto___63981;
(self.onerror = flureeworker.log_error);

(self.onmessage = flureeworker.decode_message);
} else {
}
var G__63983_63985 = null;
var G__63984_63986 = new cljs.core.Keyword(null,"connInit","connInit",-148647574);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2(G__63983_63985,G__63984_63986) : flureeworker.worker_action.call(null,G__63983_63985,G__63984_63986));
