// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__38742(s__38743){
return (new cljs.core.LazySeq(null,(function (){
var s__38743__$1 = s__38743;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__38743__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__38748 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38748,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38748,(1),null);
var iterys__4648__auto__ = ((function (s__38743__$1,vec__38748,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__38742_$_iter__38744(s__38745){
return (new cljs.core.LazySeq(null,((function (s__38743__$1,vec__38748,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__38745__$1 = s__38745;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__38745__$1);
if(temp__5753__auto____$1){
var s__38745__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__38745__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__38745__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__38747 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__38746 = (0);
while(true){
if((i__38746 < size__4651__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__38746);
cljs.core.chunk_append(b__38747,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__38800 = (i__38746 + (1));
i__38746 = G__38800;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38747),tailrecursion$priority_map$iter__38742_$_iter__38744(cljs.core.chunk_rest(s__38745__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38747),null);
}
} else {
var item = cljs.core.first(s__38745__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__38742_$_iter__38744(cljs.core.rest(s__38745__$2)));
}
} else {
return null;
}
break;
}
});})(s__38743__$1,vec__38748,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__38743__$1,vec__38748,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4649__auto__ = cljs.core.seq(iterys__4648__auto__(item_set));
if(fs__4649__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4649__auto__,tailrecursion$priority_map$iter__38742(cljs.core.rest(s__38743__$1)));
} else {
var G__38801 = cljs.core.rest(s__38743__$1);
s__38743__$1 = G__38801;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__38751(s__38752){
return (new cljs.core.LazySeq(null,(function (){
var s__38752__$1 = s__38752;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__38752__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__38757 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38757,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38757,(1),null);
var iterys__4648__auto__ = ((function (s__38752__$1,vec__38757,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__38751_$_iter__38753(s__38754){
return (new cljs.core.LazySeq(null,((function (s__38752__$1,vec__38757,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__38754__$1 = s__38754;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__38754__$1);
if(temp__5753__auto____$1){
var s__38754__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__38754__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__38754__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__38756 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__38755 = (0);
while(true){
if((i__38755 < size__4651__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__38755);
cljs.core.chunk_append(b__38756,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__38802 = (i__38755 + (1));
i__38755 = G__38802;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38756),tailrecursion$priority_map$iter__38751_$_iter__38753(cljs.core.chunk_rest(s__38754__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38756),null);
}
} else {
var item = cljs.core.first(s__38754__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__38751_$_iter__38753(cljs.core.rest(s__38754__$2)));
}
} else {
return null;
}
break;
}
});})(s__38752__$1,vec__38757,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__38752__$1,vec__38757,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4649__auto__ = cljs.core.seq(iterys__4648__auto__(item_set));
if(fs__4649__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4649__auto__,tailrecursion$priority_map$iter__38751(cljs.core.rest(s__38752__$1)));
} else {
var G__38803 = cljs.core.rest(s__38752__$1);
s__38752__$1 = G__38803;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__38760 = item;
var G__38761 = new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517);
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__38760,G__38761) : self__.item__GT_priority.call(null,G__38760,G__38761));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517))){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5751__auto__)){
var current_priority = temp__5751__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__38762(s__38763){
return (new cljs.core.LazySeq(null,(function (){
var s__38763__$1 = s__38763;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__38763__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__38768 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38768,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38768,(1),null);
var iterys__4648__auto__ = ((function (s__38763__$1,vec__38768,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__38762_$_iter__38764(s__38765){
return (new cljs.core.LazySeq(null,((function (s__38763__$1,vec__38768,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__38765__$1 = s__38765;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__38765__$1);
if(temp__5753__auto____$1){
var s__38765__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__38765__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__38765__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__38767 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__38766 = (0);
while(true){
if((i__38766 < size__4651__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__38766);
cljs.core.chunk_append(b__38767,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__38804 = (i__38766 + (1));
i__38766 = G__38804;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38767),tailrecursion$priority_map$iter__38762_$_iter__38764(cljs.core.chunk_rest(s__38765__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38767),null);
}
} else {
var item = cljs.core.first(s__38765__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__38762_$_iter__38764(cljs.core.rest(s__38765__$2)));
}
} else {
return null;
}
break;
}
});})(s__38763__$1,vec__38768,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__38763__$1,vec__38768,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4649__auto__ = cljs.core.seq(iterys__4648__auto__(item_set));
if(fs__4649__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4649__auto__,tailrecursion$priority_map$iter__38762(cljs.core.rest(s__38763__$1)));
} else {
var G__38805 = cljs.core.rest(s__38763__$1);
s__38763__$1 = G__38805;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__38771(s__38772){
return (new cljs.core.LazySeq(null,(function (){
var s__38772__$1 = s__38772;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__38772__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__38777 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38777,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38777,(1),null);
var iterys__4648__auto__ = ((function (s__38772__$1,vec__38777,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__38771_$_iter__38773(s__38774){
return (new cljs.core.LazySeq(null,((function (s__38772__$1,vec__38777,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__38774__$1 = s__38774;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__38774__$1);
if(temp__5753__auto____$1){
var s__38774__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__38774__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__38774__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__38776 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__38775 = (0);
while(true){
if((i__38775 < size__4651__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__38775);
cljs.core.chunk_append(b__38776,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__38806 = (i__38775 + (1));
i__38775 = G__38806;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38776),tailrecursion$priority_map$iter__38771_$_iter__38773(cljs.core.chunk_rest(s__38774__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38776),null);
}
} else {
var item = cljs.core.first(s__38774__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__38771_$_iter__38773(cljs.core.rest(s__38774__$2)));
}
} else {
return null;
}
break;
}
});})(s__38772__$1,vec__38777,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__38772__$1,vec__38777,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4649__auto__ = cljs.core.seq(iterys__4648__auto__(item_set));
if(fs__4649__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4649__auto__,tailrecursion$priority_map$iter__38771(cljs.core.rest(s__38772__$1)));
} else {
var G__38807 = cljs.core.rest(s__38772__$1);
s__38772__$1 = G__38807;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__38808 = null;
var G__38808__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__38808__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__38808 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__38808__2.call(this,self__,item);
case 3:
return G__38808__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__38808.cljs$core$IFn$_invoke$arity$2 = G__38808__2;
G__38808.cljs$core$IFn$_invoke$arity$3 = G__38808__3;
return G__38808;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args38741){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args38741)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__38780 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__38780.cljs$core$IFn$_invoke$arity$1 ? fexpr__38780.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__38780.call(null,this$__$1));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__38781(s__38782){
return (new cljs.core.LazySeq(null,(function (){
var s__38782__$1 = s__38782;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__38782__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__38787 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38787,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38787,(1),null);
var iterys__4648__auto__ = ((function (s__38782__$1,vec__38787,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__38781_$_iter__38783(s__38784){
return (new cljs.core.LazySeq(null,((function (s__38782__$1,vec__38787,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__38784__$1 = s__38784;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__38784__$1);
if(temp__5753__auto____$1){
var s__38784__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__38784__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__38784__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__38786 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__38785 = (0);
while(true){
if((i__38785 < size__4651__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__38785);
cljs.core.chunk_append(b__38786,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__38809 = (i__38785 + (1));
i__38785 = G__38809;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38786),tailrecursion$priority_map$iter__38781_$_iter__38783(cljs.core.chunk_rest(s__38784__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38786),null);
}
} else {
var item = cljs.core.first(s__38784__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__38781_$_iter__38783(cljs.core.rest(s__38784__$2)));
}
} else {
return null;
}
break;
}
});})(s__38782__$1,vec__38787,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__38782__$1,vec__38787,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4649__auto__ = cljs.core.seq(iterys__4648__auto__(item_set));
if(fs__4649__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4649__auto__,tailrecursion$priority_map$iter__38781(cljs.core.rest(s__38782__$1)));
} else {
var G__38810 = cljs.core.rest(s__38782__$1);
s__38782__$1 = G__38810;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__38790(s__38791){
return (new cljs.core.LazySeq(null,(function (){
var s__38791__$1 = s__38791;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__38791__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__38796 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38796,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38796,(1),null);
var iterys__4648__auto__ = ((function (s__38791__$1,vec__38796,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__38790_$_iter__38792(s__38793){
return (new cljs.core.LazySeq(null,((function (s__38791__$1,vec__38796,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__38793__$1 = s__38793;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__38793__$1);
if(temp__5753__auto____$1){
var s__38793__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__38793__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__38793__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__38795 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__38794 = (0);
while(true){
if((i__38794 < size__4651__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__38794);
cljs.core.chunk_append(b__38795,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__38811 = (i__38794 + (1));
i__38794 = G__38811;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38795),tailrecursion$priority_map$iter__38790_$_iter__38792(cljs.core.chunk_rest(s__38793__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38795),null);
}
} else {
var item = cljs.core.first(s__38793__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__38790_$_iter__38792(cljs.core.rest(s__38793__$2)));
}
} else {
return null;
}
break;
}
});})(s__38791__$1,vec__38796,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__38791__$1,vec__38796,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4649__auto__ = cljs.core.seq(iterys__4648__auto__(item_set));
if(fs__4649__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4649__auto__,tailrecursion$priority_map$iter__38790(cljs.core.rest(s__38791__$1)));
} else {
var G__38812 = cljs.core.rest(s__38791__$1);
s__38791__$1 = G__38812;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__38799 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__38799) : self__.keyfn.call(null,G__38799));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"priority->set-of-items","priority->set-of-items",-1256537211,null),new cljs.core.Symbol(null,"item->priority","item->priority",-899999435,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__38814 = arguments.length;
switch (G__38814) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38817 = arguments.length;
var i__4865__auto___38818 = (0);
while(true){
if((i__4865__auto___38818 < len__4864__auto___38817)){
args__4870__auto__.push((arguments[i__4865__auto___38818]));

var G__38819 = (i__4865__auto___38818 + (1));
i__4865__auto___38818 = G__38819;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__38820 = cljs.core.nnext(in$);
var G__38821 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__38820;
out = G__38821;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq38816){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38816));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38824 = arguments.length;
var i__4865__auto___38825 = (0);
while(true){
if((i__4865__auto___38825 < len__4864__auto___38824)){
args__4870__auto__.push((arguments[i__4865__auto___38825]));

var G__38826 = (i__4865__auto___38825 + (1));
i__4865__auto___38825 = G__38826;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__38827 = cljs.core.nnext(in$);
var G__38828 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__38827;
out = G__38828;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq38822){
var G__38823 = cljs.core.first(seq38822);
var seq38822__$1 = cljs.core.next(seq38822);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38823,seq38822__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38831 = arguments.length;
var i__4865__auto___38832 = (0);
while(true){
if((i__4865__auto___38832 < len__4864__auto___38831)){
args__4870__auto__.push((arguments[i__4865__auto___38832]));

var G__38833 = (i__4865__auto___38832 + (1));
i__4865__auto___38832 = G__38833;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__38834 = cljs.core.nnext(in$);
var G__38835 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__38834;
out = G__38835;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq38829){
var G__38830 = cljs.core.first(seq38829);
var seq38829__$1 = cljs.core.next(seq38829);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38830,seq38829__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38839 = arguments.length;
var i__4865__auto___38840 = (0);
while(true){
if((i__4865__auto___38840 < len__4864__auto___38839)){
args__4870__auto__.push((arguments[i__4865__auto___38840]));

var G__38841 = (i__4865__auto___38840 + (1));
i__4865__auto___38840 = G__38841;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__38842 = cljs.core.nnext(in$);
var G__38843 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__38842;
out = G__38843;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq38836){
var G__38837 = cljs.core.first(seq38836);
var seq38836__$1 = cljs.core.next(seq38836);
var G__38838 = cljs.core.first(seq38836__$1);
var seq38836__$2 = cljs.core.next(seq38836__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38837,G__38838,seq38836__$2);
}));

