// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__6806 = s;
var map__6806__$1 = cljs.core.__destructure_map(map__6806);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6806__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6806__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__6808 = info;
var map__6809 = G__6808;
var map__6809__$1 = cljs.core.__destructure_map(map__6809);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6809__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__6808__$1 = G__6808;
while(true){
var d__$2 = d__$1;
var map__6811 = G__6808__$1;
var map__6811__$1 = cljs.core.__destructure_map(map__6811);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6811__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__6812 = (d__$2 + (1));
var G__6813 = shadow__$1;
d__$1 = G__6812;
G__6808__$1 = G__6813;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__6814){
var map__6815 = p__6814;
var map__6815__$1 = cljs.core.__destructure_map(map__6815);
var name_var = map__6815__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6815__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6815__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__6816 = info;
var map__6816__$1 = cljs.core.__destructure_map(map__6816);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6816__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6816__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__6817 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__6817) : cljs.compiler.munge.call(null,G__6817));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__6819 = arguments.length;
switch (G__6819) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__6820 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11790,11790,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__6820.cljs$core$IFn$_invoke$arity$1 ? fexpr__6820.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__6820.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__6822 = cp;
switch (G__6822) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__6824_6828 = cljs.core.seq(s);
var chunk__6825_6829 = null;
var count__6826_6830 = (0);
var i__6827_6831 = (0);
while(true){
if((i__6827_6831 < count__6826_6830)){
var c_6832 = chunk__6825_6829.cljs$core$IIndexed$_nth$arity$2(null,i__6827_6831);
sb.append(cljs.compiler.escape_char(c_6832));


var G__6833 = seq__6824_6828;
var G__6834 = chunk__6825_6829;
var G__6835 = count__6826_6830;
var G__6836 = (i__6827_6831 + (1));
seq__6824_6828 = G__6833;
chunk__6825_6829 = G__6834;
count__6826_6830 = G__6835;
i__6827_6831 = G__6836;
continue;
} else {
var temp__5804__auto___6837 = cljs.core.seq(seq__6824_6828);
if(temp__5804__auto___6837){
var seq__6824_6838__$1 = temp__5804__auto___6837;
if(cljs.core.chunked_seq_QMARK_(seq__6824_6838__$1)){
var c__5567__auto___6839 = cljs.core.chunk_first(seq__6824_6838__$1);
var G__6840 = cljs.core.chunk_rest(seq__6824_6838__$1);
var G__6841 = c__5567__auto___6839;
var G__6842 = cljs.core.count(c__5567__auto___6839);
var G__6843 = (0);
seq__6824_6828 = G__6840;
chunk__6825_6829 = G__6841;
count__6826_6830 = G__6842;
i__6827_6831 = G__6843;
continue;
} else {
var c_6844 = cljs.core.first(seq__6824_6838__$1);
sb.append(cljs.compiler.escape_char(c_6844));


var G__6845 = cljs.core.next(seq__6824_6838__$1);
var G__6846 = null;
var G__6847 = (0);
var G__6848 = (0);
seq__6824_6828 = G__6845;
chunk__6825_6829 = G__6846;
count__6826_6830 = G__6847;
i__6827_6831 = G__6848;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__5641__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5645__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__6849 = cljs.core.get_global_hierarchy;
return (fexpr__6849.cljs$core$IFn$_invoke$arity$0 ? fexpr__6849.cljs$core$IFn$_invoke$arity$0() : fexpr__6849.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5645__auto__,method_table__5641__auto__,prefer_table__5642__auto__,method_cache__5643__auto__,cached_hierarchy__5644__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__6850_6855 = ast;
var map__6850_6856__$1 = cljs.core.__destructure_map(map__6850_6855);
var env_6857 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6850_6856__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_6857))){
var map__6851_6858 = env_6857;
var map__6851_6859__$1 = cljs.core.__destructure_map(map__6851_6858);
var line_6860 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6851_6859__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_6861 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6851_6859__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__6852 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__6854 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__6853 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__6853.cljs$core$IFn$_invoke$arity$1 ? fexpr__6853.cljs$core$IFn$_invoke$arity$1(G__6854) : fexpr__6853.call(null,G__6854));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__6852,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__6852;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_6860 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_6861)?(column_6861 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__6870 = arguments.length;
switch (G__6870) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__5793__auto__ = [];
var len__5768__auto___6877 = arguments.length;
var i__5769__auto___6878 = (0);
while(true){
if((i__5769__auto___6878 < len__5768__auto___6877)){
args_arr__5793__auto__.push((arguments[i__5769__auto___6878]));

var G__6879 = (i__5769__auto___6878 + (1));
i__5769__auto___6878 = G__6879;
continue;
} else {
}
break;
}

var argseq__5794__auto__ = (new cljs.core.IndexedSeq(args_arr__5793__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__5794__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_6880 = (function (){var G__6871 = a;
if((!(typeof a === 'string'))){
return G__6871.toString();
} else {
return G__6871;
}
})();
var temp__5808__auto___6881 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5808__auto___6881 == null)){
} else {
var sm_data_6882 = temp__5808__auto___6881;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_6882,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__6862_SHARP_){
return (p1__6862_SHARP_ + s_6880.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_6880], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__6872 = cljs.core.seq(xs);
var chunk__6873 = null;
var count__6874 = (0);
var i__6875 = (0);
while(true){
if((i__6875 < count__6874)){
var x = chunk__6873.cljs$core$IIndexed$_nth$arity$2(null,i__6875);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__6883 = seq__6872;
var G__6884 = chunk__6873;
var G__6885 = count__6874;
var G__6886 = (i__6875 + (1));
seq__6872 = G__6883;
chunk__6873 = G__6884;
count__6874 = G__6885;
i__6875 = G__6886;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__6872);
if(temp__5804__auto__){
var seq__6872__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__6872__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__6872__$1);
var G__6887 = cljs.core.chunk_rest(seq__6872__$1);
var G__6888 = c__5567__auto__;
var G__6889 = cljs.core.count(c__5567__auto__);
var G__6890 = (0);
seq__6872 = G__6887;
chunk__6873 = G__6888;
count__6874 = G__6889;
i__6875 = G__6890;
continue;
} else {
var x = cljs.core.first(seq__6872__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__6891 = cljs.core.next(seq__6872__$1);
var G__6892 = null;
var G__6893 = (0);
var G__6894 = (0);
seq__6872 = G__6891;
chunk__6873 = G__6892;
count__6874 = G__6893;
i__6875 = G__6894;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq6864){
var G__6865 = cljs.core.first(seq6864);
var seq6864__$1 = cljs.core.next(seq6864);
var G__6866 = cljs.core.first(seq6864__$1);
var seq6864__$2 = cljs.core.next(seq6864__$1);
var G__6867 = cljs.core.first(seq6864__$2);
var seq6864__$3 = cljs.core.next(seq6864__$2);
var G__6868 = cljs.core.first(seq6864__$3);
var seq6864__$4 = cljs.core.next(seq6864__$3);
var G__6869 = cljs.core.first(seq6864__$4);
var seq6864__$5 = cljs.core.next(seq6864__$4);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6865,G__6866,G__6867,G__6868,G__6869,seq6864__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__6895){
var map__6896 = p__6895;
var map__6896__$1 = cljs.core.__destructure_map(map__6896);
var m = map__6896__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6896__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__6904 = arguments.length;
switch (G__6904) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__5793__auto__ = [];
var len__5768__auto___6910 = arguments.length;
var i__5769__auto___6911 = (0);
while(true){
if((i__5769__auto___6911 < len__5768__auto___6910)){
args_arr__5793__auto__.push((arguments[i__5769__auto___6911]));

var G__6912 = (i__5769__auto___6911 + (1));
i__5769__auto___6911 = G__6912;
continue;
} else {
}
break;
}

var argseq__5794__auto__ = (new cljs.core.IndexedSeq(args_arr__5793__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__5794__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__6905_6913 = cljs.core.seq(xs);
var chunk__6906_6914 = null;
var count__6907_6915 = (0);
var i__6908_6916 = (0);
while(true){
if((i__6908_6916 < count__6907_6915)){
var x_6917 = chunk__6906_6914.cljs$core$IIndexed$_nth$arity$2(null,i__6908_6916);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_6917);


var G__6918 = seq__6905_6913;
var G__6919 = chunk__6906_6914;
var G__6920 = count__6907_6915;
var G__6921 = (i__6908_6916 + (1));
seq__6905_6913 = G__6918;
chunk__6906_6914 = G__6919;
count__6907_6915 = G__6920;
i__6908_6916 = G__6921;
continue;
} else {
var temp__5804__auto___6922 = cljs.core.seq(seq__6905_6913);
if(temp__5804__auto___6922){
var seq__6905_6923__$1 = temp__5804__auto___6922;
if(cljs.core.chunked_seq_QMARK_(seq__6905_6923__$1)){
var c__5567__auto___6924 = cljs.core.chunk_first(seq__6905_6923__$1);
var G__6925 = cljs.core.chunk_rest(seq__6905_6923__$1);
var G__6926 = c__5567__auto___6924;
var G__6927 = cljs.core.count(c__5567__auto___6924);
var G__6928 = (0);
seq__6905_6913 = G__6925;
chunk__6906_6914 = G__6926;
count__6907_6915 = G__6927;
i__6908_6916 = G__6928;
continue;
} else {
var x_6929 = cljs.core.first(seq__6905_6923__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_6929);


var G__6930 = cljs.core.next(seq__6905_6923__$1);
var G__6931 = null;
var G__6932 = (0);
var G__6933 = (0);
seq__6905_6913 = G__6930;
chunk__6906_6914 = G__6931;
count__6907_6915 = G__6932;
i__6908_6916 = G__6933;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq6898){
var G__6899 = cljs.core.first(seq6898);
var seq6898__$1 = cljs.core.next(seq6898);
var G__6900 = cljs.core.first(seq6898__$1);
var seq6898__$2 = cljs.core.next(seq6898__$1);
var G__6901 = cljs.core.first(seq6898__$2);
var seq6898__$3 = cljs.core.next(seq6898__$2);
var G__6902 = cljs.core.first(seq6898__$3);
var seq6898__$4 = cljs.core.next(seq6898__$3);
var G__6903 = cljs.core.first(seq6898__$4);
var seq6898__$5 = cljs.core.next(seq6898__$4);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6899,G__6900,G__6901,G__6902,G__6903,seq6898__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__5689__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__6934_6938 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__6935_6939 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__6936_6940 = true;
var _STAR_print_fn_STAR__temp_val__6937_6941 = (function (x__5690__auto__){
return sb__5689__auto__.append(x__5690__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__6936_6940);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__6937_6941);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__6935_6939);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__6934_6938);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__5689__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__5641__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5645__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__6942 = cljs.core.get_global_hierarchy;
return (fexpr__6942.cljs$core$IFn$_invoke$arity$0 ? fexpr__6942.cljs$core$IFn$_invoke$arity$0() : fexpr__6942.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5645__auto__,method_table__5641__auto__,prefer_table__5642__auto__,method_cache__5643__auto__,cached_hierarchy__5644__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__6943 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6943,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6943,(1),null);
var G__6946 = ns;
var G__6947 = name;
var G__6948 = (function (){
var G__6949 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__6949) : cljs.compiler.emit_constant.call(null,G__6949));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__6946,G__6947,G__6948) : cljs.compiler.emit_record_value.call(null,G__6946,G__6947,G__6948));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(x)){
var G__6950 = cljs.core.keys(x);
var G__6951 = cljs.core.vals(x);
var G__6952 = cljs.compiler.emit_constants_comma_sep;
var G__6953 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__6950,G__6951,G__6952,G__6953) : cljs.compiler.emit_map.call(null,G__6950,G__6951,G__6952,G__6953));
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__6954 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__6955 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__6954,G__6955) : cljs.compiler.emit_with_meta.call(null,G__6954,G__6955));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
if((((x === (0))) && ((((1) / x) < (0))))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(-0)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__6956 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6956,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6956,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6956,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5802__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__5043__auto__)){
var G__6959 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__6959) : x.call(null,G__6959));
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var value = temp__5802__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5802__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__5043__auto__)){
var G__6960 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__6960) : x.call(null,G__6960));
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var value = temp__5802__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",inst_ms,")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emit_inst(date.getTime());
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__6962 = items;
var G__6963 = (function (p1__6961_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__6961_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__6962,G__6963) : cljs.compiler.emit_js_object.call(null,G__6962,G__6963));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__6965){
var map__6966 = p__6965;
var map__6966__$1 = cljs.core.__destructure_map(map__6966);
var ast = map__6966__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6966__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6966__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6966__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5802__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5802__auto__)){
var const_expr = temp__5802__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__6967 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__6967__$1 = cljs.core.__destructure_map(map__6967);
var cenv = map__6967__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6967__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__5045__auto__ = js_module_name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__6968 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__5043__auto__ = (function (){var G__6969 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__6969) : cljs.compiler.es5_GT__EQ_.call(null,G__6969));
})();
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__5043__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__6968,cljs.analyzer.es5_allowed);
} else {
return G__6968;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__5045__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__6970 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__6970,reserved);
} else {
return G__6970;
}
})();
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__6971_6972 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__6971_6973__$1 = (((G__6971_6972 instanceof cljs.core.Keyword))?G__6971_6972.fqn:null);
switch (G__6971_6973__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__5043__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__6975){
var map__6976 = p__6975;
var map__6976__$1 = cljs.core.__destructure_map(map__6976);
var arg = map__6976__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6976__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6976__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6976__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6976__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__6977 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__6977__$1 = cljs.core.__destructure_map(map__6977);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6977__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__6978){
var map__6979 = p__6978;
var map__6979__$1 = cljs.core.__destructure_map(map__6979);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6979__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6979__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6979__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__6980_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6980_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__6981 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__6981) : comma_sep.call(null,G__6981));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__6982 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__6982) : comma_sep.call(null,G__6982));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__6983){
var map__6984 = p__6983;
var map__6984__$1 = cljs.core.__destructure_map(map__6984);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6984__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6984__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6984__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__6985){
var map__6986 = p__6985;
var map__6986__$1 = cljs.core.__destructure_map(map__6986);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6986__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6986__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__6987_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6987_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__6988 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__6988) : comma_sep.call(null,G__6988));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__6989){
var map__6990 = p__6989;
var map__6990__$1 = cljs.core.__destructure_map(map__6990);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6990__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6990__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5804__auto___7013 = cljs.core.seq(items);
if(temp__5804__auto___7013){
var items_7014__$1 = temp__5804__auto___7013;
var vec__6991_7015 = items_7014__$1;
var seq__6992_7016 = cljs.core.seq(vec__6991_7015);
var first__6993_7017 = cljs.core.first(seq__6992_7016);
var seq__6992_7018__$1 = cljs.core.next(seq__6992_7016);
var vec__6994_7019 = first__6993_7017;
var k_7020 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6994_7019,(0),null);
var v_7021 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6994_7019,(1),null);
var r_7022 = seq__6992_7018__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_7020),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_7021) : emit_js_object_val.call(null,v_7021)));

var seq__6997_7023 = cljs.core.seq(r_7022);
var chunk__6998_7024 = null;
var count__6999_7025 = (0);
var i__7000_7026 = (0);
while(true){
if((i__7000_7026 < count__6999_7025)){
var vec__7007_7027 = chunk__6998_7024.cljs$core$IIndexed$_nth$arity$2(null,i__7000_7026);
var k_7028__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7007_7027,(0),null);
var v_7029__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7007_7027,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_7028__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_7029__$1) : emit_js_object_val.call(null,v_7029__$1)));


var G__7030 = seq__6997_7023;
var G__7031 = chunk__6998_7024;
var G__7032 = count__6999_7025;
var G__7033 = (i__7000_7026 + (1));
seq__6997_7023 = G__7030;
chunk__6998_7024 = G__7031;
count__6999_7025 = G__7032;
i__7000_7026 = G__7033;
continue;
} else {
var temp__5804__auto___7034__$1 = cljs.core.seq(seq__6997_7023);
if(temp__5804__auto___7034__$1){
var seq__6997_7035__$1 = temp__5804__auto___7034__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6997_7035__$1)){
var c__5567__auto___7036 = cljs.core.chunk_first(seq__6997_7035__$1);
var G__7037 = cljs.core.chunk_rest(seq__6997_7035__$1);
var G__7038 = c__5567__auto___7036;
var G__7039 = cljs.core.count(c__5567__auto___7036);
var G__7040 = (0);
seq__6997_7023 = G__7037;
chunk__6998_7024 = G__7038;
count__6999_7025 = G__7039;
i__7000_7026 = G__7040;
continue;
} else {
var vec__7010_7041 = cljs.core.first(seq__6997_7035__$1);
var k_7042__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7010_7041,(0),null);
var v_7043__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7010_7041,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_7042__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_7043__$1) : emit_js_object_val.call(null,v_7043__$1)));


var G__7044 = cljs.core.next(seq__6997_7035__$1);
var G__7045 = null;
var G__7046 = (0);
var G__7047 = (0);
seq__6997_7023 = G__7044;
chunk__6998_7024 = G__7045;
count__6999_7025 = G__7046;
i__7000_7026 = G__7047;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__7048){
var map__7049 = p__7048;
var map__7049__$1 = cljs.core.__destructure_map(map__7049);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7049__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7049__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7049__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__7050){
var map__7051 = p__7050;
var map__7051__$1 = cljs.core.__destructure_map(map__7051);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7051__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7051__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__7052){
var map__7053 = p__7052;
var map__7053__$1 = cljs.core.__destructure_map(map__7053);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7053__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__7054){
var map__7055 = p__7054;
var map__7055__$1 = cljs.core.__destructure_map(map__7055);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7055__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7055__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__7056 = cljs.analyzer.unwrap_quote(expr);
var map__7056__$1 = cljs.core.__destructure_map(map__7056);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7056__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7056__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7056__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__5045__auto__ = (function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842));
if(and__5043__auto__){
var and__5043__auto____$1 = form;
if(cljs.core.truth_(and__5043__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = (!((const_expr == null)));
if(and__5043__auto__){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return and__5043__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__7057 = cljs.analyzer.unwrap_quote(expr);
var map__7057__$1 = cljs.core.__destructure_map(map__7057);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7057__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7057__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7057__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__5045__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__5045__auto__){
return or__5045__auto__;
} else {
var and__5043__auto__ = (!((const_expr == null)));
if(and__5043__auto__){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return and__5043__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__5045__auto__ = (function (){var fexpr__7058 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__7058.cljs$core$IFn$_invoke$arity$1 ? fexpr__7058.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__7058.call(null,tag));
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__7059){
var map__7060 = p__7059;
var map__7060__$1 = cljs.core.__destructure_map(map__7060);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7060__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7060__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7060__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7060__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7060__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__5045__auto__ = unchecked;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__7061){
var map__7062 = p__7061;
var map__7062__$1 = cljs.core.__destructure_map(map__7062);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7062__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7062__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7062__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7062__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__7063_7091 = cljs.core.seq(nodes);
var chunk__7064_7092 = null;
var count__7065_7093 = (0);
var i__7066_7094 = (0);
while(true){
if((i__7066_7094 < count__7065_7093)){
var map__7079_7095 = chunk__7064_7092.cljs$core$IIndexed$_nth$arity$2(null,i__7066_7094);
var map__7079_7096__$1 = cljs.core.__destructure_map(map__7079_7095);
var ts_7097 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7079_7096__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__7080_7098 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7079_7096__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__7080_7099__$1 = cljs.core.__destructure_map(map__7080_7098);
var then_7100 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7080_7099__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__7081_7101 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_7097));
var chunk__7082_7102 = null;
var count__7083_7103 = (0);
var i__7084_7104 = (0);
while(true){
if((i__7084_7104 < count__7083_7103)){
var test_7105 = chunk__7082_7102.cljs$core$IIndexed$_nth$arity$2(null,i__7084_7104);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7105,":");


var G__7106 = seq__7081_7101;
var G__7107 = chunk__7082_7102;
var G__7108 = count__7083_7103;
var G__7109 = (i__7084_7104 + (1));
seq__7081_7101 = G__7106;
chunk__7082_7102 = G__7107;
count__7083_7103 = G__7108;
i__7084_7104 = G__7109;
continue;
} else {
var temp__5804__auto___7110 = cljs.core.seq(seq__7081_7101);
if(temp__5804__auto___7110){
var seq__7081_7111__$1 = temp__5804__auto___7110;
if(cljs.core.chunked_seq_QMARK_(seq__7081_7111__$1)){
var c__5567__auto___7112 = cljs.core.chunk_first(seq__7081_7111__$1);
var G__7113 = cljs.core.chunk_rest(seq__7081_7111__$1);
var G__7114 = c__5567__auto___7112;
var G__7115 = cljs.core.count(c__5567__auto___7112);
var G__7116 = (0);
seq__7081_7101 = G__7113;
chunk__7082_7102 = G__7114;
count__7083_7103 = G__7115;
i__7084_7104 = G__7116;
continue;
} else {
var test_7117 = cljs.core.first(seq__7081_7111__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7117,":");


var G__7118 = cljs.core.next(seq__7081_7111__$1);
var G__7119 = null;
var G__7120 = (0);
var G__7121 = (0);
seq__7081_7101 = G__7118;
chunk__7082_7102 = G__7119;
count__7083_7103 = G__7120;
i__7084_7104 = G__7121;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_7100);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_7100);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__7122 = seq__7063_7091;
var G__7123 = chunk__7064_7092;
var G__7124 = count__7065_7093;
var G__7125 = (i__7066_7094 + (1));
seq__7063_7091 = G__7122;
chunk__7064_7092 = G__7123;
count__7065_7093 = G__7124;
i__7066_7094 = G__7125;
continue;
} else {
var temp__5804__auto___7126 = cljs.core.seq(seq__7063_7091);
if(temp__5804__auto___7126){
var seq__7063_7127__$1 = temp__5804__auto___7126;
if(cljs.core.chunked_seq_QMARK_(seq__7063_7127__$1)){
var c__5567__auto___7128 = cljs.core.chunk_first(seq__7063_7127__$1);
var G__7129 = cljs.core.chunk_rest(seq__7063_7127__$1);
var G__7130 = c__5567__auto___7128;
var G__7131 = cljs.core.count(c__5567__auto___7128);
var G__7132 = (0);
seq__7063_7091 = G__7129;
chunk__7064_7092 = G__7130;
count__7065_7093 = G__7131;
i__7066_7094 = G__7132;
continue;
} else {
var map__7085_7133 = cljs.core.first(seq__7063_7127__$1);
var map__7085_7134__$1 = cljs.core.__destructure_map(map__7085_7133);
var ts_7135 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7085_7134__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__7086_7136 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7085_7134__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__7086_7137__$1 = cljs.core.__destructure_map(map__7086_7136);
var then_7138 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7086_7137__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__7087_7139 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_7135));
var chunk__7088_7140 = null;
var count__7089_7141 = (0);
var i__7090_7142 = (0);
while(true){
if((i__7090_7142 < count__7089_7141)){
var test_7143 = chunk__7088_7140.cljs$core$IIndexed$_nth$arity$2(null,i__7090_7142);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7143,":");


var G__7144 = seq__7087_7139;
var G__7145 = chunk__7088_7140;
var G__7146 = count__7089_7141;
var G__7147 = (i__7090_7142 + (1));
seq__7087_7139 = G__7144;
chunk__7088_7140 = G__7145;
count__7089_7141 = G__7146;
i__7090_7142 = G__7147;
continue;
} else {
var temp__5804__auto___7148__$1 = cljs.core.seq(seq__7087_7139);
if(temp__5804__auto___7148__$1){
var seq__7087_7149__$1 = temp__5804__auto___7148__$1;
if(cljs.core.chunked_seq_QMARK_(seq__7087_7149__$1)){
var c__5567__auto___7150 = cljs.core.chunk_first(seq__7087_7149__$1);
var G__7151 = cljs.core.chunk_rest(seq__7087_7149__$1);
var G__7152 = c__5567__auto___7150;
var G__7153 = cljs.core.count(c__5567__auto___7150);
var G__7154 = (0);
seq__7087_7139 = G__7151;
chunk__7088_7140 = G__7152;
count__7089_7141 = G__7153;
i__7090_7142 = G__7154;
continue;
} else {
var test_7155 = cljs.core.first(seq__7087_7149__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7155,":");


var G__7156 = cljs.core.next(seq__7087_7149__$1);
var G__7157 = null;
var G__7158 = (0);
var G__7159 = (0);
seq__7087_7139 = G__7156;
chunk__7088_7140 = G__7157;
count__7089_7141 = G__7158;
i__7090_7142 = G__7159;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_7138);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_7138);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__7160 = cljs.core.next(seq__7063_7127__$1);
var G__7161 = null;
var G__7162 = (0);
var G__7163 = (0);
seq__7063_7091 = G__7160;
chunk__7064_7092 = G__7161;
count__7065_7093 = G__7162;
i__7066_7094 = G__7163;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__7164){
var map__7165 = p__7164;
var map__7165__$1 = cljs.core.__destructure_map(map__7165);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7165__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7165__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__7169 = env;
var G__7170 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__7169,G__7170) : cljs.compiler.resolve_type.call(null,G__7169,G__7170));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__7171 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7171,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7171,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__7166_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__7166_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__7166_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__7174 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__7174,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__7174;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__7177 = env;
var G__7178 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__7177,G__7178) : cljs.compiler.resolve_type.call(null,G__7177,G__7178));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__7179_SHARP_){
return cljs.compiler.resolve_type(env,p1__7179_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__7180 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__7181 = cljs.core.seq(vec__7180);
var first__7182 = cljs.core.first(seq__7181);
var seq__7181__$1 = cljs.core.next(seq__7181);
var p = first__7182;
var first__7182__$1 = cljs.core.first(seq__7181__$1);
var seq__7181__$2 = cljs.core.next(seq__7181__$1);
var ts = first__7182__$1;
var first__7182__$2 = cljs.core.first(seq__7181__$2);
var seq__7181__$3 = cljs.core.next(seq__7181__$2);
var n = first__7182__$2;
var xs = seq__7181__$3;
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p);
if(and__5043__auto__){
var and__5043__auto____$1 = ts;
if(cljs.core.truth_(and__5043__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__7183 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__7184 = cljs.core.seq(vec__7183);
var first__7185 = cljs.core.first(seq__7184);
var seq__7184__$1 = cljs.core.next(seq__7184);
var p = first__7185;
var first__7185__$1 = cljs.core.first(seq__7184__$1);
var seq__7184__$2 = cljs.core.next(seq__7184__$1);
var ts = first__7185__$1;
var xs = seq__7184__$2;
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p);
if(and__5043__auto__){
var and__5043__auto____$1 = ts;
if(cljs.core.truth_(and__5043__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__7187 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__7186 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__7186.cljs$core$IFn$_invoke$arity$1 ? fexpr__7186.cljs$core$IFn$_invoke$arity$1(G__7187) : fexpr__7186.call(null,G__7187));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__7190 = arguments.length;
switch (G__7190) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__7198 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__7188_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__7188_SHARP_);
} else {
return p1__7188_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__7199 = cljs.core.seq(vec__7198);
var first__7200 = cljs.core.first(seq__7199);
var seq__7199__$1 = cljs.core.next(seq__7199);
var x = first__7200;
var ys = seq__7199__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__7201 = cljs.core.seq(ys);
var chunk__7202 = null;
var count__7203 = (0);
var i__7204 = (0);
while(true){
if((i__7204 < count__7203)){
var next_line = chunk__7202.cljs$core$IIndexed$_nth$arity$2(null,i__7204);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__7210 = seq__7201;
var G__7211 = chunk__7202;
var G__7212 = count__7203;
var G__7213 = (i__7204 + (1));
seq__7201 = G__7210;
chunk__7202 = G__7211;
count__7203 = G__7212;
i__7204 = G__7213;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__7201);
if(temp__5804__auto__){
var seq__7201__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7201__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__7201__$1);
var G__7214 = cljs.core.chunk_rest(seq__7201__$1);
var G__7215 = c__5567__auto__;
var G__7216 = cljs.core.count(c__5567__auto__);
var G__7217 = (0);
seq__7201 = G__7214;
chunk__7202 = G__7215;
count__7203 = G__7216;
i__7204 = G__7217;
continue;
} else {
var next_line = cljs.core.first(seq__7201__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__7218 = cljs.core.next(seq__7201__$1);
var G__7219 = null;
var G__7220 = (0);
var G__7221 = (0);
seq__7201 = G__7218;
chunk__7202 = G__7219;
count__7203 = G__7220;
i__7204 = G__7221;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__7205_7222 = cljs.core.seq(docs__$2);
var chunk__7206_7223 = null;
var count__7207_7224 = (0);
var i__7208_7225 = (0);
while(true){
if((i__7208_7225 < count__7207_7224)){
var e_7226 = chunk__7206_7223.cljs$core$IIndexed$_nth$arity$2(null,i__7208_7225);
if(cljs.core.truth_(e_7226)){
print_comment_lines(e_7226);
} else {
}


var G__7227 = seq__7205_7222;
var G__7228 = chunk__7206_7223;
var G__7229 = count__7207_7224;
var G__7230 = (i__7208_7225 + (1));
seq__7205_7222 = G__7227;
chunk__7206_7223 = G__7228;
count__7207_7224 = G__7229;
i__7208_7225 = G__7230;
continue;
} else {
var temp__5804__auto___7231 = cljs.core.seq(seq__7205_7222);
if(temp__5804__auto___7231){
var seq__7205_7232__$1 = temp__5804__auto___7231;
if(cljs.core.chunked_seq_QMARK_(seq__7205_7232__$1)){
var c__5567__auto___7233 = cljs.core.chunk_first(seq__7205_7232__$1);
var G__7234 = cljs.core.chunk_rest(seq__7205_7232__$1);
var G__7235 = c__5567__auto___7233;
var G__7236 = cljs.core.count(c__5567__auto___7233);
var G__7237 = (0);
seq__7205_7222 = G__7234;
chunk__7206_7223 = G__7235;
count__7207_7224 = G__7236;
i__7208_7225 = G__7237;
continue;
} else {
var e_7238 = cljs.core.first(seq__7205_7232__$1);
if(cljs.core.truth_(e_7238)){
print_comment_lines(e_7238);
} else {
}


var G__7239 = cljs.core.next(seq__7205_7232__$1);
var G__7240 = null;
var G__7241 = (0);
var G__7242 = (0);
seq__7205_7222 = G__7239;
chunk__7206_7223 = G__7240;
count__7207_7224 = G__7241;
i__7208_7225 = G__7242;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__5043__auto__ = cljs.core.some((function (p1__7244_SHARP_){
return goog.string.startsWith(p1__7244_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = opts;
if(cljs.core.truth_(and__5043__auto____$1)){
var and__5043__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__5043__auto____$2){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return and__5043__auto____$2;
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__7245){
var map__7246 = p__7245;
var map__7246__$1 = cljs.core.__destructure_map(map__7246);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7246__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7246__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7246__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7246__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7246__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7246__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7246__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7246__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7246__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7246__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__5045__auto__ = init;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5802__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5802__auto__)){
var define = temp__5802__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return test;
} else {
return and__5043__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__7247){
var map__7248 = p__7247;
var map__7248__$1 = cljs.core.__destructure_map(map__7248);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7248__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7248__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7248__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__7249_7273 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__7250_7274 = null;
var count__7251_7275 = (0);
var i__7252_7276 = (0);
while(true){
if((i__7252_7276 < count__7251_7275)){
var vec__7259_7277 = chunk__7250_7274.cljs$core$IIndexed$_nth$arity$2(null,i__7252_7276);
var i_7278 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7259_7277,(0),null);
var param_7279 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7259_7277,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_7279);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__7280 = seq__7249_7273;
var G__7281 = chunk__7250_7274;
var G__7282 = count__7251_7275;
var G__7283 = (i__7252_7276 + (1));
seq__7249_7273 = G__7280;
chunk__7250_7274 = G__7281;
count__7251_7275 = G__7282;
i__7252_7276 = G__7283;
continue;
} else {
var temp__5804__auto___7284 = cljs.core.seq(seq__7249_7273);
if(temp__5804__auto___7284){
var seq__7249_7285__$1 = temp__5804__auto___7284;
if(cljs.core.chunked_seq_QMARK_(seq__7249_7285__$1)){
var c__5567__auto___7286 = cljs.core.chunk_first(seq__7249_7285__$1);
var G__7287 = cljs.core.chunk_rest(seq__7249_7285__$1);
var G__7288 = c__5567__auto___7286;
var G__7289 = cljs.core.count(c__5567__auto___7286);
var G__7290 = (0);
seq__7249_7273 = G__7287;
chunk__7250_7274 = G__7288;
count__7251_7275 = G__7289;
i__7252_7276 = G__7290;
continue;
} else {
var vec__7262_7291 = cljs.core.first(seq__7249_7285__$1);
var i_7292 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7262_7291,(0),null);
var param_7293 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7262_7291,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_7293);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__7294 = cljs.core.next(seq__7249_7285__$1);
var G__7295 = null;
var G__7296 = (0);
var G__7297 = (0);
seq__7249_7273 = G__7294;
chunk__7250_7274 = G__7295;
count__7251_7275 = G__7296;
i__7252_7276 = G__7297;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__7265_7298 = cljs.core.seq(params);
var chunk__7266_7299 = null;
var count__7267_7300 = (0);
var i__7268_7301 = (0);
while(true){
if((i__7268_7301 < count__7267_7300)){
var param_7302 = chunk__7266_7299.cljs$core$IIndexed$_nth$arity$2(null,i__7268_7301);
cljs.compiler.emit(param_7302);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7302,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7303 = seq__7265_7298;
var G__7304 = chunk__7266_7299;
var G__7305 = count__7267_7300;
var G__7306 = (i__7268_7301 + (1));
seq__7265_7298 = G__7303;
chunk__7266_7299 = G__7304;
count__7267_7300 = G__7305;
i__7268_7301 = G__7306;
continue;
} else {
var temp__5804__auto___7307 = cljs.core.seq(seq__7265_7298);
if(temp__5804__auto___7307){
var seq__7265_7308__$1 = temp__5804__auto___7307;
if(cljs.core.chunked_seq_QMARK_(seq__7265_7308__$1)){
var c__5567__auto___7309 = cljs.core.chunk_first(seq__7265_7308__$1);
var G__7310 = cljs.core.chunk_rest(seq__7265_7308__$1);
var G__7311 = c__5567__auto___7309;
var G__7312 = cljs.core.count(c__5567__auto___7309);
var G__7313 = (0);
seq__7265_7298 = G__7310;
chunk__7266_7299 = G__7311;
count__7267_7300 = G__7312;
i__7268_7301 = G__7313;
continue;
} else {
var param_7314 = cljs.core.first(seq__7265_7308__$1);
cljs.compiler.emit(param_7314);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7314,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7315 = cljs.core.next(seq__7265_7308__$1);
var G__7316 = null;
var G__7317 = (0);
var G__7318 = (0);
seq__7265_7298 = G__7315;
chunk__7266_7299 = G__7316;
count__7267_7300 = G__7317;
i__7268_7301 = G__7318;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__7269_7319 = cljs.core.seq(params);
var chunk__7270_7320 = null;
var count__7271_7321 = (0);
var i__7272_7322 = (0);
while(true){
if((i__7272_7322 < count__7271_7321)){
var param_7323 = chunk__7270_7320.cljs$core$IIndexed$_nth$arity$2(null,i__7272_7322);
cljs.compiler.emit(param_7323);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7323,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7324 = seq__7269_7319;
var G__7325 = chunk__7270_7320;
var G__7326 = count__7271_7321;
var G__7327 = (i__7272_7322 + (1));
seq__7269_7319 = G__7324;
chunk__7270_7320 = G__7325;
count__7271_7321 = G__7326;
i__7272_7322 = G__7327;
continue;
} else {
var temp__5804__auto___7328 = cljs.core.seq(seq__7269_7319);
if(temp__5804__auto___7328){
var seq__7269_7329__$1 = temp__5804__auto___7328;
if(cljs.core.chunked_seq_QMARK_(seq__7269_7329__$1)){
var c__5567__auto___7330 = cljs.core.chunk_first(seq__7269_7329__$1);
var G__7331 = cljs.core.chunk_rest(seq__7269_7329__$1);
var G__7332 = c__5567__auto___7330;
var G__7333 = cljs.core.count(c__5567__auto___7330);
var G__7334 = (0);
seq__7269_7319 = G__7331;
chunk__7270_7320 = G__7332;
count__7271_7321 = G__7333;
i__7272_7322 = G__7334;
continue;
} else {
var param_7335 = cljs.core.first(seq__7269_7329__$1);
cljs.compiler.emit(param_7335);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7335,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7336 = cljs.core.next(seq__7269_7329__$1);
var G__7337 = null;
var G__7338 = (0);
var G__7339 = (0);
seq__7269_7319 = G__7336;
chunk__7270_7320 = G__7337;
count__7271_7321 = G__7338;
i__7272_7322 = G__7339;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__7340 = cljs.core.seq(params);
var chunk__7341 = null;
var count__7342 = (0);
var i__7343 = (0);
while(true){
if((i__7343 < count__7342)){
var param = chunk__7341.cljs$core$IIndexed$_nth$arity$2(null,i__7343);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7344 = seq__7340;
var G__7345 = chunk__7341;
var G__7346 = count__7342;
var G__7347 = (i__7343 + (1));
seq__7340 = G__7344;
chunk__7341 = G__7345;
count__7342 = G__7346;
i__7343 = G__7347;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__7340);
if(temp__5804__auto__){
var seq__7340__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7340__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__7340__$1);
var G__7348 = cljs.core.chunk_rest(seq__7340__$1);
var G__7349 = c__5567__auto__;
var G__7350 = cljs.core.count(c__5567__auto__);
var G__7351 = (0);
seq__7340 = G__7348;
chunk__7341 = G__7349;
count__7342 = G__7350;
i__7343 = G__7351;
continue;
} else {
var param = cljs.core.first(seq__7340__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7352 = cljs.core.next(seq__7340__$1);
var G__7353 = null;
var G__7354 = (0);
var G__7355 = (0);
seq__7340 = G__7352;
chunk__7341 = G__7353;
count__7342 = G__7354;
i__7343 = G__7355;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__7356){
var map__7357 = p__7356;
var map__7357__$1 = cljs.core.__destructure_map(map__7357);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7357__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7357__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7357__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7357__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7357__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7357__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__7358){
var map__7359 = p__7358;
var map__7359__$1 = cljs.core.__destructure_map(map__7359);
var f = map__7359__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7359__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7359__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7359__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7359__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7359__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7359__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7359__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7359__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_7368__$1 = (function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_7369 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_7368__$1);
var delegate_name_7370 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7369),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_7370," = function (");

var seq__7360_7371 = cljs.core.seq(params);
var chunk__7361_7372 = null;
var count__7362_7373 = (0);
var i__7363_7374 = (0);
while(true){
if((i__7363_7374 < count__7362_7373)){
var param_7375 = chunk__7361_7372.cljs$core$IIndexed$_nth$arity$2(null,i__7363_7374);
cljs.compiler.emit(param_7375);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7375,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7376 = seq__7360_7371;
var G__7377 = chunk__7361_7372;
var G__7378 = count__7362_7373;
var G__7379 = (i__7363_7374 + (1));
seq__7360_7371 = G__7376;
chunk__7361_7372 = G__7377;
count__7362_7373 = G__7378;
i__7363_7374 = G__7379;
continue;
} else {
var temp__5804__auto___7380 = cljs.core.seq(seq__7360_7371);
if(temp__5804__auto___7380){
var seq__7360_7381__$1 = temp__5804__auto___7380;
if(cljs.core.chunked_seq_QMARK_(seq__7360_7381__$1)){
var c__5567__auto___7382 = cljs.core.chunk_first(seq__7360_7381__$1);
var G__7383 = cljs.core.chunk_rest(seq__7360_7381__$1);
var G__7384 = c__5567__auto___7382;
var G__7385 = cljs.core.count(c__5567__auto___7382);
var G__7386 = (0);
seq__7360_7371 = G__7383;
chunk__7361_7372 = G__7384;
count__7362_7373 = G__7385;
i__7363_7374 = G__7386;
continue;
} else {
var param_7387 = cljs.core.first(seq__7360_7381__$1);
cljs.compiler.emit(param_7387);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7387,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7388 = cljs.core.next(seq__7360_7381__$1);
var G__7389 = null;
var G__7390 = (0);
var G__7391 = (0);
seq__7360_7371 = G__7388;
chunk__7361_7372 = G__7389;
count__7362_7373 = G__7390;
i__7363_7374 = G__7391;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_7369," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_7392 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_7392,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_7370,".call(this,");

var seq__7364_7393 = cljs.core.seq(params);
var chunk__7365_7394 = null;
var count__7366_7395 = (0);
var i__7367_7396 = (0);
while(true){
if((i__7367_7396 < count__7366_7395)){
var param_7397 = chunk__7365_7394.cljs$core$IIndexed$_nth$arity$2(null,i__7367_7396);
cljs.compiler.emit(param_7397);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7397,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7398 = seq__7364_7393;
var G__7399 = chunk__7365_7394;
var G__7400 = count__7366_7395;
var G__7401 = (i__7367_7396 + (1));
seq__7364_7393 = G__7398;
chunk__7365_7394 = G__7399;
count__7366_7395 = G__7400;
i__7367_7396 = G__7401;
continue;
} else {
var temp__5804__auto___7402 = cljs.core.seq(seq__7364_7393);
if(temp__5804__auto___7402){
var seq__7364_7403__$1 = temp__5804__auto___7402;
if(cljs.core.chunked_seq_QMARK_(seq__7364_7403__$1)){
var c__5567__auto___7404 = cljs.core.chunk_first(seq__7364_7403__$1);
var G__7405 = cljs.core.chunk_rest(seq__7364_7403__$1);
var G__7406 = c__5567__auto___7404;
var G__7407 = cljs.core.count(c__5567__auto___7404);
var G__7408 = (0);
seq__7364_7393 = G__7405;
chunk__7365_7394 = G__7406;
count__7366_7395 = G__7407;
i__7367_7396 = G__7408;
continue;
} else {
var param_7409 = cljs.core.first(seq__7364_7403__$1);
cljs.compiler.emit(param_7409);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7409,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7410 = cljs.core.next(seq__7364_7403__$1);
var G__7411 = null;
var G__7412 = (0);
var G__7413 = (0);
seq__7364_7393 = G__7410;
chunk__7365_7394 = G__7411;
count__7366_7395 = G__7412;
i__7367_7396 = G__7413;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7369,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_7369,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_7368__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7369,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_7370,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_7369,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__7417){
var map__7418 = p__7417;
var map__7418__$1 = cljs.core.__destructure_map(map__7418);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7418__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7418__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7418__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7418__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7418__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7418__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7418__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7418__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__7414_SHARP_){
var and__5043__auto__ = p1__7414_SHARP_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__7414_SHARP_));
} else {
return and__5043__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__5045__auto__ = in_loop;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_7470__$1 = (function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_7471 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_7470__$1);
var maxparams_7472 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_7473 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7471),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_7474 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__7415_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__7415_SHARP_)));
}),cljs.core.seq(mmap_7473));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_7471," = null;");

var seq__7419_7475 = cljs.core.seq(ms_7474);
var chunk__7420_7476 = null;
var count__7421_7477 = (0);
var i__7422_7478 = (0);
while(true){
if((i__7422_7478 < count__7421_7477)){
var vec__7429_7479 = chunk__7420_7476.cljs$core$IIndexed$_nth$arity$2(null,i__7422_7478);
var n_7480 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7429_7479,(0),null);
var meth_7481 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7429_7479,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_7480," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7481))){
cljs.compiler.emit_variadic_fn_method(meth_7481);
} else {
cljs.compiler.emit_fn_method(meth_7481);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__7482 = seq__7419_7475;
var G__7483 = chunk__7420_7476;
var G__7484 = count__7421_7477;
var G__7485 = (i__7422_7478 + (1));
seq__7419_7475 = G__7482;
chunk__7420_7476 = G__7483;
count__7421_7477 = G__7484;
i__7422_7478 = G__7485;
continue;
} else {
var temp__5804__auto___7486 = cljs.core.seq(seq__7419_7475);
if(temp__5804__auto___7486){
var seq__7419_7487__$1 = temp__5804__auto___7486;
if(cljs.core.chunked_seq_QMARK_(seq__7419_7487__$1)){
var c__5567__auto___7488 = cljs.core.chunk_first(seq__7419_7487__$1);
var G__7489 = cljs.core.chunk_rest(seq__7419_7487__$1);
var G__7490 = c__5567__auto___7488;
var G__7491 = cljs.core.count(c__5567__auto___7488);
var G__7492 = (0);
seq__7419_7475 = G__7489;
chunk__7420_7476 = G__7490;
count__7421_7477 = G__7491;
i__7422_7478 = G__7492;
continue;
} else {
var vec__7432_7493 = cljs.core.first(seq__7419_7487__$1);
var n_7494 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7432_7493,(0),null);
var meth_7495 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7432_7493,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_7494," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7495))){
cljs.compiler.emit_variadic_fn_method(meth_7495);
} else {
cljs.compiler.emit_fn_method(meth_7495);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__7496 = cljs.core.next(seq__7419_7487__$1);
var G__7497 = null;
var G__7498 = (0);
var G__7499 = (0);
seq__7419_7475 = G__7496;
chunk__7420_7476 = G__7497;
count__7421_7477 = G__7498;
i__7422_7478 = G__7499;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7471," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_7472),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_7472)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_7472));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__7435_7500 = cljs.core.seq(ms_7474);
var chunk__7436_7501 = null;
var count__7437_7502 = (0);
var i__7438_7503 = (0);
while(true){
if((i__7438_7503 < count__7437_7502)){
var vec__7445_7504 = chunk__7436_7501.cljs$core$IIndexed$_nth$arity$2(null,i__7438_7503);
var n_7505 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7445_7504,(0),null);
var meth_7506 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7445_7504,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7506))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_7507 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_7507," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_7508 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_7507," = new cljs.core.IndexedSeq(",a_7508,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_7505,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_7472)),(((cljs.core.count(maxparams_7472) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_7507,");"], 0));
} else {
var pcnt_7509 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7506));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_7509,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_7505,".call(this",(((pcnt_7509 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_7509,maxparams_7472)),null,(1),null)),(2),null))),");");
}


var G__7510 = seq__7435_7500;
var G__7511 = chunk__7436_7501;
var G__7512 = count__7437_7502;
var G__7513 = (i__7438_7503 + (1));
seq__7435_7500 = G__7510;
chunk__7436_7501 = G__7511;
count__7437_7502 = G__7512;
i__7438_7503 = G__7513;
continue;
} else {
var temp__5804__auto___7514 = cljs.core.seq(seq__7435_7500);
if(temp__5804__auto___7514){
var seq__7435_7515__$1 = temp__5804__auto___7514;
if(cljs.core.chunked_seq_QMARK_(seq__7435_7515__$1)){
var c__5567__auto___7516 = cljs.core.chunk_first(seq__7435_7515__$1);
var G__7517 = cljs.core.chunk_rest(seq__7435_7515__$1);
var G__7518 = c__5567__auto___7516;
var G__7519 = cljs.core.count(c__5567__auto___7516);
var G__7520 = (0);
seq__7435_7500 = G__7517;
chunk__7436_7501 = G__7518;
count__7437_7502 = G__7519;
i__7438_7503 = G__7520;
continue;
} else {
var vec__7448_7521 = cljs.core.first(seq__7435_7515__$1);
var n_7522 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7448_7521,(0),null);
var meth_7523 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7448_7521,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7523))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_7524 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_7524," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_7525 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_7524," = new cljs.core.IndexedSeq(",a_7525,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_7522,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_7472)),(((cljs.core.count(maxparams_7472) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_7524,");"], 0));
} else {
var pcnt_7526 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7523));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_7526,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_7522,".call(this",(((pcnt_7526 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_7526,maxparams_7472)),null,(1),null)),(2),null))),");");
}


var G__7527 = cljs.core.next(seq__7435_7515__$1);
var G__7528 = null;
var G__7529 = (0);
var G__7530 = (0);
seq__7435_7500 = G__7527;
chunk__7436_7501 = G__7528;
count__7437_7502 = G__7529;
i__7438_7503 = G__7530;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_7531 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_7474)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_7531,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7471,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7471,".cljs$lang$applyTo = ",cljs.core.some((function (p1__7416_SHARP_){
var vec__7451 = p1__7416_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7451,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7451,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_7474),".cljs$lang$applyTo;");
} else {
}

var seq__7454_7532 = cljs.core.seq(ms_7474);
var chunk__7455_7533 = null;
var count__7456_7534 = (0);
var i__7457_7535 = (0);
while(true){
if((i__7457_7535 < count__7456_7534)){
var vec__7464_7536 = chunk__7455_7533.cljs$core$IIndexed$_nth$arity$2(null,i__7457_7535);
var n_7537 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7464_7536,(0),null);
var meth_7538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7464_7536,(1),null);
var c_7539 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7538));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7538))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7471,".cljs$core$IFn$_invoke$arity$variadic = ",n_7537,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_7471,".cljs$core$IFn$_invoke$arity$",c_7539," = ",n_7537,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__7540 = seq__7454_7532;
var G__7541 = chunk__7455_7533;
var G__7542 = count__7456_7534;
var G__7543 = (i__7457_7535 + (1));
seq__7454_7532 = G__7540;
chunk__7455_7533 = G__7541;
count__7456_7534 = G__7542;
i__7457_7535 = G__7543;
continue;
} else {
var temp__5804__auto___7544 = cljs.core.seq(seq__7454_7532);
if(temp__5804__auto___7544){
var seq__7454_7545__$1 = temp__5804__auto___7544;
if(cljs.core.chunked_seq_QMARK_(seq__7454_7545__$1)){
var c__5567__auto___7546 = cljs.core.chunk_first(seq__7454_7545__$1);
var G__7547 = cljs.core.chunk_rest(seq__7454_7545__$1);
var G__7548 = c__5567__auto___7546;
var G__7549 = cljs.core.count(c__5567__auto___7546);
var G__7550 = (0);
seq__7454_7532 = G__7547;
chunk__7455_7533 = G__7548;
count__7456_7534 = G__7549;
i__7457_7535 = G__7550;
continue;
} else {
var vec__7467_7551 = cljs.core.first(seq__7454_7545__$1);
var n_7552 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7467_7551,(0),null);
var meth_7553 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7467_7551,(1),null);
var c_7554 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7553));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7553))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7471,".cljs$core$IFn$_invoke$arity$variadic = ",n_7552,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_7471,".cljs$core$IFn$_invoke$arity$",c_7554," = ",n_7552,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__7555 = cljs.core.next(seq__7454_7545__$1);
var G__7556 = null;
var G__7557 = (0);
var G__7558 = (0);
seq__7454_7532 = G__7555;
chunk__7455_7533 = G__7556;
count__7456_7534 = G__7557;
i__7457_7535 = G__7558;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_7471,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__7559){
var map__7560 = p__7559;
var map__7560__$1 = cljs.core.__destructure_map(map__7560);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7560__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7560__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7560__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__7561_7565 = cljs.core.seq(statements);
var chunk__7562_7566 = null;
var count__7563_7567 = (0);
var i__7564_7568 = (0);
while(true){
if((i__7564_7568 < count__7563_7567)){
var s_7569 = chunk__7562_7566.cljs$core$IIndexed$_nth$arity$2(null,i__7564_7568);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_7569);


var G__7570 = seq__7561_7565;
var G__7571 = chunk__7562_7566;
var G__7572 = count__7563_7567;
var G__7573 = (i__7564_7568 + (1));
seq__7561_7565 = G__7570;
chunk__7562_7566 = G__7571;
count__7563_7567 = G__7572;
i__7564_7568 = G__7573;
continue;
} else {
var temp__5804__auto___7574 = cljs.core.seq(seq__7561_7565);
if(temp__5804__auto___7574){
var seq__7561_7575__$1 = temp__5804__auto___7574;
if(cljs.core.chunked_seq_QMARK_(seq__7561_7575__$1)){
var c__5567__auto___7576 = cljs.core.chunk_first(seq__7561_7575__$1);
var G__7577 = cljs.core.chunk_rest(seq__7561_7575__$1);
var G__7578 = c__5567__auto___7576;
var G__7579 = cljs.core.count(c__5567__auto___7576);
var G__7580 = (0);
seq__7561_7565 = G__7577;
chunk__7562_7566 = G__7578;
count__7563_7567 = G__7579;
i__7564_7568 = G__7580;
continue;
} else {
var s_7581 = cljs.core.first(seq__7561_7575__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_7581);


var G__7582 = cljs.core.next(seq__7561_7575__$1);
var G__7583 = null;
var G__7584 = (0);
var G__7585 = (0);
seq__7561_7565 = G__7582;
chunk__7562_7566 = G__7583;
count__7563_7567 = G__7584;
i__7564_7568 = G__7585;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__7586){
var map__7587 = p__7586;
var map__7587__$1 = cljs.core.__destructure_map(map__7587);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7587__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7587__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7587__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7587__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7587__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__7588,is_loop){
var map__7589 = p__7588;
var map__7589__$1 = cljs.core.__destructure_map(map__7589);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7589__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7589__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7589__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__7590_7600 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__7591_7601 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__7591_7601);

try{var seq__7592_7602 = cljs.core.seq(bindings);
var chunk__7593_7603 = null;
var count__7594_7604 = (0);
var i__7595_7605 = (0);
while(true){
if((i__7595_7605 < count__7594_7604)){
var map__7598_7606 = chunk__7593_7603.cljs$core$IIndexed$_nth$arity$2(null,i__7595_7605);
var map__7598_7607__$1 = cljs.core.__destructure_map(map__7598_7606);
var binding_7608 = map__7598_7607__$1;
var init_7609 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7598_7607__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_7608);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_7609,";");


var G__7610 = seq__7592_7602;
var G__7611 = chunk__7593_7603;
var G__7612 = count__7594_7604;
var G__7613 = (i__7595_7605 + (1));
seq__7592_7602 = G__7610;
chunk__7593_7603 = G__7611;
count__7594_7604 = G__7612;
i__7595_7605 = G__7613;
continue;
} else {
var temp__5804__auto___7614 = cljs.core.seq(seq__7592_7602);
if(temp__5804__auto___7614){
var seq__7592_7615__$1 = temp__5804__auto___7614;
if(cljs.core.chunked_seq_QMARK_(seq__7592_7615__$1)){
var c__5567__auto___7616 = cljs.core.chunk_first(seq__7592_7615__$1);
var G__7617 = cljs.core.chunk_rest(seq__7592_7615__$1);
var G__7618 = c__5567__auto___7616;
var G__7619 = cljs.core.count(c__5567__auto___7616);
var G__7620 = (0);
seq__7592_7602 = G__7617;
chunk__7593_7603 = G__7618;
count__7594_7604 = G__7619;
i__7595_7605 = G__7620;
continue;
} else {
var map__7599_7621 = cljs.core.first(seq__7592_7615__$1);
var map__7599_7622__$1 = cljs.core.__destructure_map(map__7599_7621);
var binding_7623 = map__7599_7622__$1;
var init_7624 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7599_7622__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_7623);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_7624,";");


var G__7625 = cljs.core.next(seq__7592_7615__$1);
var G__7626 = null;
var G__7627 = (0);
var G__7628 = (0);
seq__7592_7602 = G__7625;
chunk__7593_7603 = G__7626;
count__7594_7604 = G__7627;
i__7595_7605 = G__7628;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__7590_7600);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__7629){
var map__7630 = p__7629;
var map__7630__$1 = cljs.core.__destructure_map(map__7630);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7630__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7630__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7630__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__5635__auto___7631 = cljs.core.count(exprs);
var i_7632 = (0);
while(true){
if((i_7632 < n__5635__auto___7631)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_7632) : temps.call(null,i_7632))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_7632) : exprs.call(null,i_7632)),";");

var G__7633 = (i_7632 + (1));
i_7632 = G__7633;
continue;
} else {
}
break;
}

var n__5635__auto___7634 = cljs.core.count(exprs);
var i_7635 = (0);
while(true){
if((i_7635 < n__5635__auto___7634)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_7635) : params.call(null,i_7635)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_7635) : temps.call(null,i_7635)),";");

var G__7636 = (i_7635 + (1));
i_7635 = G__7636;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__7637){
var map__7638 = p__7637;
var map__7638__$1 = cljs.core.__destructure_map(map__7638);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7638__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7638__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7638__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__7639_7647 = cljs.core.seq(bindings);
var chunk__7640_7648 = null;
var count__7641_7649 = (0);
var i__7642_7650 = (0);
while(true){
if((i__7642_7650 < count__7641_7649)){
var map__7645_7651 = chunk__7640_7648.cljs$core$IIndexed$_nth$arity$2(null,i__7642_7650);
var map__7645_7652__$1 = cljs.core.__destructure_map(map__7645_7651);
var binding_7653 = map__7645_7652__$1;
var init_7654 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7645_7652__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_7653)," = ",init_7654,";");


var G__7655 = seq__7639_7647;
var G__7656 = chunk__7640_7648;
var G__7657 = count__7641_7649;
var G__7658 = (i__7642_7650 + (1));
seq__7639_7647 = G__7655;
chunk__7640_7648 = G__7656;
count__7641_7649 = G__7657;
i__7642_7650 = G__7658;
continue;
} else {
var temp__5804__auto___7659 = cljs.core.seq(seq__7639_7647);
if(temp__5804__auto___7659){
var seq__7639_7660__$1 = temp__5804__auto___7659;
if(cljs.core.chunked_seq_QMARK_(seq__7639_7660__$1)){
var c__5567__auto___7661 = cljs.core.chunk_first(seq__7639_7660__$1);
var G__7662 = cljs.core.chunk_rest(seq__7639_7660__$1);
var G__7663 = c__5567__auto___7661;
var G__7664 = cljs.core.count(c__5567__auto___7661);
var G__7665 = (0);
seq__7639_7647 = G__7662;
chunk__7640_7648 = G__7663;
count__7641_7649 = G__7664;
i__7642_7650 = G__7665;
continue;
} else {
var map__7646_7666 = cljs.core.first(seq__7639_7660__$1);
var map__7646_7667__$1 = cljs.core.__destructure_map(map__7646_7666);
var binding_7668 = map__7646_7667__$1;
var init_7669 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7646_7667__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_7668)," = ",init_7669,";");


var G__7670 = cljs.core.next(seq__7639_7660__$1);
var G__7671 = null;
var G__7672 = (0);
var G__7673 = (0);
seq__7639_7647 = G__7670;
chunk__7640_7648 = G__7671;
count__7641_7649 = G__7672;
i__7642_7650 = G__7673;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__7676){
var map__7677 = p__7676;
var map__7677__$1 = cljs.core.__destructure_map(map__7677);
var expr = map__7677__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7677__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7677__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7677__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__5043__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__5043__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__5043__auto__ = protocol;
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = tag;
if(cljs.core.truth_(and__5043__auto____$1)){
var or__5045__auto__ = (function (){var and__5043__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto____$2)){
var and__5043__auto____$3 = protocol;
if(cljs.core.truth_(and__5043__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__5043__auto____$3;
}
} else {
return and__5043__auto____$2;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto____$2 = (function (){var or__5045__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__5043__auto____$2)){
var or__5045__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__5045__auto____$1){
return or__5045__auto____$1;
} else {
var and__5043__auto____$3 = (!(cljs.core.set_QMARK_(tag)));
if(and__5043__auto____$3){
var and__5043__auto____$4 = cljs.core.not((function (){var fexpr__7681 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__7681.cljs$core$IFn$_invoke$arity$1 ? fexpr__7681.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__7681.call(null,tag));
})());
if(and__5043__auto____$4){
var temp__5804__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5804__auto__)){
var ps = temp__5804__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return and__5043__auto____$4;
}
} else {
return and__5043__auto____$3;
}
}
} else {
return and__5043__auto____$2;
}
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__7682 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__7682.cljs$core$IFn$_invoke$arity$1 ? fexpr__7682.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__7682.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__5045__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__5045__auto____$1){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__5045__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = (function (){var temp__5804__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5804__auto__)){
var ns_str = temp__5804__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__5045__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__5045__auto__){
return or__5045__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__7678 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (arity > mfa);
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7674_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__7674_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7675_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__7675_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7678,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7678,(1),null);
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_7685 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_7685,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_7686 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_7686,args)),(((mfa_7686 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_7686,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
var G__7684 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__7683 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__7683.cljs$core$IFn$_invoke$arity$1 ? fexpr__7683.cljs$core$IFn$_invoke$arity$1(G__7684) : fexpr__7683.call(null,G__7684));
} else {
return and__5043__auto__;
}
})())){
var fprop_7687 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_7687," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_7687,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_7687," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_7687,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__7688){
var map__7689 = p__7688;
var map__7689__$1 = cljs.core.__destructure_map(map__7689);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7689__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7689__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7689__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__7690){
var map__7691 = p__7690;
var map__7691__$1 = cljs.core.__destructure_map(map__7691);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7691__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7691__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7691__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(sublib,/\./);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__7692_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__7692_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__7693 = cljs.analyzer.lib_AMPERSAND_sublib(lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7693,(0),null);
var sublib = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7693,(1),null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.sublib_select(sublib),";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__7696 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__7696__$1 = cljs.core.__destructure_map(map__7696);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7696__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7696__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__7697 = options;
var map__7697__$1 = cljs.core.__destructure_map(map__7697);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7697__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7697__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7697__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__7698 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__7704 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__7704__$1 = cljs.core.__destructure_map(map__7704);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7704__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7704__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7698,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7698,(1),null);
var vec__7701 = (function (){var map__7705 = cljs.core.group_by(cljs.analyzer.goog_module_dep_QMARK_,libs_to_load);
var map__7705__$1 = cljs.core.__destructure_map(map__7705);
var goog_modules = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7705__$1,true);
var libs_to_load__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7705__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goog_modules,libs_to_load__$1], null);
})();
var goog_modules = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7701,(0),null);
var libs_to_load__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7701,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load__$1);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__7706_7750 = cljs.core.seq(libs_to_load__$1);
var chunk__7707_7751 = null;
var count__7708_7752 = (0);
var i__7709_7753 = (0);
while(true){
if((i__7709_7753 < count__7708_7752)){
var lib_7754 = chunk__7707_7751.cljs$core$IIndexed$_nth$arity$2(null,i__7709_7753);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_7754)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7754),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7754),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7754),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7754),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_7754,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7754),"');");
}

}
}
}


var G__7755 = seq__7706_7750;
var G__7756 = chunk__7707_7751;
var G__7757 = count__7708_7752;
var G__7758 = (i__7709_7753 + (1));
seq__7706_7750 = G__7755;
chunk__7707_7751 = G__7756;
count__7708_7752 = G__7757;
i__7709_7753 = G__7758;
continue;
} else {
var temp__5804__auto___7759 = cljs.core.seq(seq__7706_7750);
if(temp__5804__auto___7759){
var seq__7706_7760__$1 = temp__5804__auto___7759;
if(cljs.core.chunked_seq_QMARK_(seq__7706_7760__$1)){
var c__5567__auto___7761 = cljs.core.chunk_first(seq__7706_7760__$1);
var G__7762 = cljs.core.chunk_rest(seq__7706_7760__$1);
var G__7763 = c__5567__auto___7761;
var G__7764 = cljs.core.count(c__5567__auto___7761);
var G__7765 = (0);
seq__7706_7750 = G__7762;
chunk__7707_7751 = G__7763;
count__7708_7752 = G__7764;
i__7709_7753 = G__7765;
continue;
} else {
var lib_7766 = cljs.core.first(seq__7706_7760__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_7766)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7766),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7766),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7766),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7766),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_7766,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7766),"');");
}

}
}
}


var G__7767 = cljs.core.next(seq__7706_7760__$1);
var G__7768 = null;
var G__7769 = (0);
var G__7770 = (0);
seq__7706_7750 = G__7767;
chunk__7707_7751 = G__7768;
count__7708_7752 = G__7769;
i__7709_7753 = G__7770;
continue;
}
} else {
}
}
break;
}

var seq__7710_7771 = cljs.core.seq(node_libs);
var chunk__7711_7772 = null;
var count__7712_7773 = (0);
var i__7713_7774 = (0);
while(true){
if((i__7713_7774 < count__7712_7773)){
var lib_7775 = chunk__7711_7772.cljs$core$IIndexed$_nth$arity$2(null,i__7713_7774);
var vec__7720_7776 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7775);
var lib_SINGLEQUOTE__7777 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7720_7776,(0),null);
var sublib_7778 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7720_7776,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_7775)," = require('",lib_SINGLEQUOTE__7777,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7778),";"], 0));


var G__7779 = seq__7710_7771;
var G__7780 = chunk__7711_7772;
var G__7781 = count__7712_7773;
var G__7782 = (i__7713_7774 + (1));
seq__7710_7771 = G__7779;
chunk__7711_7772 = G__7780;
count__7712_7773 = G__7781;
i__7713_7774 = G__7782;
continue;
} else {
var temp__5804__auto___7783 = cljs.core.seq(seq__7710_7771);
if(temp__5804__auto___7783){
var seq__7710_7784__$1 = temp__5804__auto___7783;
if(cljs.core.chunked_seq_QMARK_(seq__7710_7784__$1)){
var c__5567__auto___7785 = cljs.core.chunk_first(seq__7710_7784__$1);
var G__7786 = cljs.core.chunk_rest(seq__7710_7784__$1);
var G__7787 = c__5567__auto___7785;
var G__7788 = cljs.core.count(c__5567__auto___7785);
var G__7789 = (0);
seq__7710_7771 = G__7786;
chunk__7711_7772 = G__7787;
count__7712_7773 = G__7788;
i__7713_7774 = G__7789;
continue;
} else {
var lib_7790 = cljs.core.first(seq__7710_7784__$1);
var vec__7723_7791 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7790);
var lib_SINGLEQUOTE__7792 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7723_7791,(0),null);
var sublib_7793 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7723_7791,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_7790)," = require('",lib_SINGLEQUOTE__7792,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7793),";"], 0));


var G__7794 = cljs.core.next(seq__7710_7784__$1);
var G__7795 = null;
var G__7796 = (0);
var G__7797 = (0);
seq__7710_7771 = G__7794;
chunk__7711_7772 = G__7795;
count__7712_7773 = G__7796;
i__7713_7774 = G__7797;
continue;
}
} else {
}
}
break;
}

var seq__7726_7798 = cljs.core.seq(goog_modules);
var chunk__7727_7799 = null;
var count__7728_7800 = (0);
var i__7729_7801 = (0);
while(true){
if((i__7729_7801 < count__7728_7800)){
var lib_7802 = chunk__7727_7799.cljs$core$IIndexed$_nth$arity$2(null,i__7729_7801);
var vec__7736_7803 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7802);
var lib_SINGLEQUOTE__7804 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7736_7803,(0),null);
var sublib_7805 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7736_7803,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",lib_SINGLEQUOTE__7804,"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.scope(function(){");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_goog_module_lib.cljs$core$IFn$_invoke$arity$1(lib_7802)," = goog.module.get('",lib_SINGLEQUOTE__7804,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7805),";"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");


var G__7806 = seq__7726_7798;
var G__7807 = chunk__7727_7799;
var G__7808 = count__7728_7800;
var G__7809 = (i__7729_7801 + (1));
seq__7726_7798 = G__7806;
chunk__7727_7799 = G__7807;
count__7728_7800 = G__7808;
i__7729_7801 = G__7809;
continue;
} else {
var temp__5804__auto___7810 = cljs.core.seq(seq__7726_7798);
if(temp__5804__auto___7810){
var seq__7726_7811__$1 = temp__5804__auto___7810;
if(cljs.core.chunked_seq_QMARK_(seq__7726_7811__$1)){
var c__5567__auto___7812 = cljs.core.chunk_first(seq__7726_7811__$1);
var G__7813 = cljs.core.chunk_rest(seq__7726_7811__$1);
var G__7814 = c__5567__auto___7812;
var G__7815 = cljs.core.count(c__5567__auto___7812);
var G__7816 = (0);
seq__7726_7798 = G__7813;
chunk__7727_7799 = G__7814;
count__7728_7800 = G__7815;
i__7729_7801 = G__7816;
continue;
} else {
var lib_7817 = cljs.core.first(seq__7726_7811__$1);
var vec__7739_7818 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7817);
var lib_SINGLEQUOTE__7819 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7739_7818,(0),null);
var sublib_7820 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7739_7818,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",lib_SINGLEQUOTE__7819,"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.scope(function(){");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_goog_module_lib.cljs$core$IFn$_invoke$arity$1(lib_7817)," = goog.module.get('",lib_SINGLEQUOTE__7819,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7820),";"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");


var G__7821 = cljs.core.next(seq__7726_7811__$1);
var G__7822 = null;
var G__7823 = (0);
var G__7824 = (0);
seq__7726_7798 = G__7821;
chunk__7727_7799 = G__7822;
count__7728_7800 = G__7823;
i__7729_7801 = G__7824;
continue;
}
} else {
}
}
break;
}

var seq__7742_7825 = cljs.core.seq(global_exports_libs);
var chunk__7743_7826 = null;
var count__7744_7827 = (0);
var i__7745_7828 = (0);
while(true){
if((i__7745_7828 < count__7744_7827)){
var lib_7829 = chunk__7743_7826.cljs$core$IIndexed$_nth$arity$2(null,i__7745_7828);
var map__7748_7830 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_7829))));
var map__7748_7831__$1 = cljs.core.__destructure_map(map__7748_7830);
var global_exports_7832 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7748_7831__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_7832,lib_7829);


var G__7833 = seq__7742_7825;
var G__7834 = chunk__7743_7826;
var G__7835 = count__7744_7827;
var G__7836 = (i__7745_7828 + (1));
seq__7742_7825 = G__7833;
chunk__7743_7826 = G__7834;
count__7744_7827 = G__7835;
i__7745_7828 = G__7836;
continue;
} else {
var temp__5804__auto___7837 = cljs.core.seq(seq__7742_7825);
if(temp__5804__auto___7837){
var seq__7742_7838__$1 = temp__5804__auto___7837;
if(cljs.core.chunked_seq_QMARK_(seq__7742_7838__$1)){
var c__5567__auto___7839 = cljs.core.chunk_first(seq__7742_7838__$1);
var G__7840 = cljs.core.chunk_rest(seq__7742_7838__$1);
var G__7841 = c__5567__auto___7839;
var G__7842 = cljs.core.count(c__5567__auto___7839);
var G__7843 = (0);
seq__7742_7825 = G__7840;
chunk__7743_7826 = G__7841;
count__7744_7827 = G__7842;
i__7745_7828 = G__7843;
continue;
} else {
var lib_7844 = cljs.core.first(seq__7742_7838__$1);
var map__7749_7845 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_7844))));
var map__7749_7846__$1 = cljs.core.__destructure_map(map__7749_7845);
var global_exports_7847 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7749_7846__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_7847,lib_7844);


var G__7848 = cljs.core.next(seq__7742_7838__$1);
var G__7849 = null;
var G__7850 = (0);
var G__7851 = (0);
seq__7742_7825 = G__7848;
chunk__7743_7826 = G__7849;
count__7744_7827 = G__7850;
i__7745_7828 = G__7851;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__7852){
var map__7853 = p__7852;
var map__7853__$1 = cljs.core.__destructure_map(map__7853);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7853__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7853__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7853__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7853__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7853__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7853__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7853__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__7854){
var map__7855 = p__7854;
var map__7855__$1 = cljs.core.__destructure_map(map__7855);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7855__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7855__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7855__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7855__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7855__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7855__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7855__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__7856){
var map__7857 = p__7856;
var map__7857__$1 = cljs.core.__destructure_map(map__7857);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7857__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7857__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7857__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7857__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7857__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__7858_7882 = cljs.core.seq(protocols);
var chunk__7859_7883 = null;
var count__7860_7884 = (0);
var i__7861_7885 = (0);
while(true){
if((i__7861_7885 < count__7860_7884)){
var protocol_7886 = chunk__7859_7883.cljs$core$IIndexed$_nth$arity$2(null,i__7861_7885);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7886)),"}");


var G__7887 = seq__7858_7882;
var G__7888 = chunk__7859_7883;
var G__7889 = count__7860_7884;
var G__7890 = (i__7861_7885 + (1));
seq__7858_7882 = G__7887;
chunk__7859_7883 = G__7888;
count__7860_7884 = G__7889;
i__7861_7885 = G__7890;
continue;
} else {
var temp__5804__auto___7891 = cljs.core.seq(seq__7858_7882);
if(temp__5804__auto___7891){
var seq__7858_7892__$1 = temp__5804__auto___7891;
if(cljs.core.chunked_seq_QMARK_(seq__7858_7892__$1)){
var c__5567__auto___7893 = cljs.core.chunk_first(seq__7858_7892__$1);
var G__7894 = cljs.core.chunk_rest(seq__7858_7892__$1);
var G__7895 = c__5567__auto___7893;
var G__7896 = cljs.core.count(c__5567__auto___7893);
var G__7897 = (0);
seq__7858_7882 = G__7894;
chunk__7859_7883 = G__7895;
count__7860_7884 = G__7896;
i__7861_7885 = G__7897;
continue;
} else {
var protocol_7898 = cljs.core.first(seq__7858_7892__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7898)),"}");


var G__7899 = cljs.core.next(seq__7858_7892__$1);
var G__7900 = null;
var G__7901 = (0);
var G__7902 = (0);
seq__7858_7882 = G__7899;
chunk__7859_7883 = G__7900;
count__7860_7884 = G__7901;
i__7861_7885 = G__7902;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__7862_7903 = cljs.core.seq(fields__$1);
var chunk__7863_7904 = null;
var count__7864_7905 = (0);
var i__7865_7906 = (0);
while(true){
if((i__7865_7906 < count__7864_7905)){
var fld_7907 = chunk__7863_7904.cljs$core$IIndexed$_nth$arity$2(null,i__7865_7906);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_7907," = ",fld_7907,";");


var G__7908 = seq__7862_7903;
var G__7909 = chunk__7863_7904;
var G__7910 = count__7864_7905;
var G__7911 = (i__7865_7906 + (1));
seq__7862_7903 = G__7908;
chunk__7863_7904 = G__7909;
count__7864_7905 = G__7910;
i__7865_7906 = G__7911;
continue;
} else {
var temp__5804__auto___7912 = cljs.core.seq(seq__7862_7903);
if(temp__5804__auto___7912){
var seq__7862_7913__$1 = temp__5804__auto___7912;
if(cljs.core.chunked_seq_QMARK_(seq__7862_7913__$1)){
var c__5567__auto___7914 = cljs.core.chunk_first(seq__7862_7913__$1);
var G__7915 = cljs.core.chunk_rest(seq__7862_7913__$1);
var G__7916 = c__5567__auto___7914;
var G__7917 = cljs.core.count(c__5567__auto___7914);
var G__7918 = (0);
seq__7862_7903 = G__7915;
chunk__7863_7904 = G__7916;
count__7864_7905 = G__7917;
i__7865_7906 = G__7918;
continue;
} else {
var fld_7919 = cljs.core.first(seq__7862_7913__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_7919," = ",fld_7919,";");


var G__7920 = cljs.core.next(seq__7862_7913__$1);
var G__7921 = null;
var G__7922 = (0);
var G__7923 = (0);
seq__7862_7903 = G__7920;
chunk__7863_7904 = G__7921;
count__7864_7905 = G__7922;
i__7865_7906 = G__7923;
continue;
}
} else {
}
}
break;
}

var seq__7866_7924 = cljs.core.seq(pmasks);
var chunk__7867_7925 = null;
var count__7868_7926 = (0);
var i__7869_7927 = (0);
while(true){
if((i__7869_7927 < count__7868_7926)){
var vec__7876_7928 = chunk__7867_7925.cljs$core$IIndexed$_nth$arity$2(null,i__7869_7927);
var pno_7929 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7876_7928,(0),null);
var pmask_7930 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7876_7928,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_7929,"$ = ",pmask_7930,";");


var G__7931 = seq__7866_7924;
var G__7932 = chunk__7867_7925;
var G__7933 = count__7868_7926;
var G__7934 = (i__7869_7927 + (1));
seq__7866_7924 = G__7931;
chunk__7867_7925 = G__7932;
count__7868_7926 = G__7933;
i__7869_7927 = G__7934;
continue;
} else {
var temp__5804__auto___7935 = cljs.core.seq(seq__7866_7924);
if(temp__5804__auto___7935){
var seq__7866_7936__$1 = temp__5804__auto___7935;
if(cljs.core.chunked_seq_QMARK_(seq__7866_7936__$1)){
var c__5567__auto___7937 = cljs.core.chunk_first(seq__7866_7936__$1);
var G__7938 = cljs.core.chunk_rest(seq__7866_7936__$1);
var G__7939 = c__5567__auto___7937;
var G__7940 = cljs.core.count(c__5567__auto___7937);
var G__7941 = (0);
seq__7866_7924 = G__7938;
chunk__7867_7925 = G__7939;
count__7868_7926 = G__7940;
i__7869_7927 = G__7941;
continue;
} else {
var vec__7879_7942 = cljs.core.first(seq__7866_7936__$1);
var pno_7943 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7879_7942,(0),null);
var pmask_7944 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7879_7942,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_7943,"$ = ",pmask_7944,";");


var G__7945 = cljs.core.next(seq__7866_7936__$1);
var G__7946 = null;
var G__7947 = (0);
var G__7948 = (0);
seq__7866_7924 = G__7945;
chunk__7867_7925 = G__7946;
count__7868_7926 = G__7947;
i__7869_7927 = G__7948;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__7949){
var map__7950 = p__7949;
var map__7950__$1 = cljs.core.__destructure_map(map__7950);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7950__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7950__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7950__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7950__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7950__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__7951_7975 = cljs.core.seq(protocols);
var chunk__7952_7976 = null;
var count__7953_7977 = (0);
var i__7954_7978 = (0);
while(true){
if((i__7954_7978 < count__7953_7977)){
var protocol_7979 = chunk__7952_7976.cljs$core$IIndexed$_nth$arity$2(null,i__7954_7978);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7979)),"}");


var G__7980 = seq__7951_7975;
var G__7981 = chunk__7952_7976;
var G__7982 = count__7953_7977;
var G__7983 = (i__7954_7978 + (1));
seq__7951_7975 = G__7980;
chunk__7952_7976 = G__7981;
count__7953_7977 = G__7982;
i__7954_7978 = G__7983;
continue;
} else {
var temp__5804__auto___7984 = cljs.core.seq(seq__7951_7975);
if(temp__5804__auto___7984){
var seq__7951_7985__$1 = temp__5804__auto___7984;
if(cljs.core.chunked_seq_QMARK_(seq__7951_7985__$1)){
var c__5567__auto___7986 = cljs.core.chunk_first(seq__7951_7985__$1);
var G__7987 = cljs.core.chunk_rest(seq__7951_7985__$1);
var G__7988 = c__5567__auto___7986;
var G__7989 = cljs.core.count(c__5567__auto___7986);
var G__7990 = (0);
seq__7951_7975 = G__7987;
chunk__7952_7976 = G__7988;
count__7953_7977 = G__7989;
i__7954_7978 = G__7990;
continue;
} else {
var protocol_7991 = cljs.core.first(seq__7951_7985__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7991)),"}");


var G__7992 = cljs.core.next(seq__7951_7985__$1);
var G__7993 = null;
var G__7994 = (0);
var G__7995 = (0);
seq__7951_7975 = G__7992;
chunk__7952_7976 = G__7993;
count__7953_7977 = G__7994;
i__7954_7978 = G__7995;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__7955_7996 = cljs.core.seq(fields__$1);
var chunk__7956_7997 = null;
var count__7957_7998 = (0);
var i__7958_7999 = (0);
while(true){
if((i__7958_7999 < count__7957_7998)){
var fld_8000 = chunk__7956_7997.cljs$core$IIndexed$_nth$arity$2(null,i__7958_7999);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_8000," = ",fld_8000,";");


var G__8001 = seq__7955_7996;
var G__8002 = chunk__7956_7997;
var G__8003 = count__7957_7998;
var G__8004 = (i__7958_7999 + (1));
seq__7955_7996 = G__8001;
chunk__7956_7997 = G__8002;
count__7957_7998 = G__8003;
i__7958_7999 = G__8004;
continue;
} else {
var temp__5804__auto___8005 = cljs.core.seq(seq__7955_7996);
if(temp__5804__auto___8005){
var seq__7955_8006__$1 = temp__5804__auto___8005;
if(cljs.core.chunked_seq_QMARK_(seq__7955_8006__$1)){
var c__5567__auto___8007 = cljs.core.chunk_first(seq__7955_8006__$1);
var G__8008 = cljs.core.chunk_rest(seq__7955_8006__$1);
var G__8009 = c__5567__auto___8007;
var G__8010 = cljs.core.count(c__5567__auto___8007);
var G__8011 = (0);
seq__7955_7996 = G__8008;
chunk__7956_7997 = G__8009;
count__7957_7998 = G__8010;
i__7958_7999 = G__8011;
continue;
} else {
var fld_8012 = cljs.core.first(seq__7955_8006__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_8012," = ",fld_8012,";");


var G__8013 = cljs.core.next(seq__7955_8006__$1);
var G__8014 = null;
var G__8015 = (0);
var G__8016 = (0);
seq__7955_7996 = G__8013;
chunk__7956_7997 = G__8014;
count__7957_7998 = G__8015;
i__7958_7999 = G__8016;
continue;
}
} else {
}
}
break;
}

var seq__7959_8017 = cljs.core.seq(pmasks);
var chunk__7960_8018 = null;
var count__7961_8019 = (0);
var i__7962_8020 = (0);
while(true){
if((i__7962_8020 < count__7961_8019)){
var vec__7969_8021 = chunk__7960_8018.cljs$core$IIndexed$_nth$arity$2(null,i__7962_8020);
var pno_8022 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7969_8021,(0),null);
var pmask_8023 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7969_8021,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_8022,"$ = ",pmask_8023,";");


var G__8024 = seq__7959_8017;
var G__8025 = chunk__7960_8018;
var G__8026 = count__7961_8019;
var G__8027 = (i__7962_8020 + (1));
seq__7959_8017 = G__8024;
chunk__7960_8018 = G__8025;
count__7961_8019 = G__8026;
i__7962_8020 = G__8027;
continue;
} else {
var temp__5804__auto___8028 = cljs.core.seq(seq__7959_8017);
if(temp__5804__auto___8028){
var seq__7959_8029__$1 = temp__5804__auto___8028;
if(cljs.core.chunked_seq_QMARK_(seq__7959_8029__$1)){
var c__5567__auto___8030 = cljs.core.chunk_first(seq__7959_8029__$1);
var G__8031 = cljs.core.chunk_rest(seq__7959_8029__$1);
var G__8032 = c__5567__auto___8030;
var G__8033 = cljs.core.count(c__5567__auto___8030);
var G__8034 = (0);
seq__7959_8017 = G__8031;
chunk__7960_8018 = G__8032;
count__7961_8019 = G__8033;
i__7962_8020 = G__8034;
continue;
} else {
var vec__7972_8035 = cljs.core.first(seq__7959_8029__$1);
var pno_8036 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7972_8035,(0),null);
var pmask_8037 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7972_8035,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_8036,"$ = ",pmask_8037,";");


var G__8038 = cljs.core.next(seq__7959_8029__$1);
var G__8039 = null;
var G__8040 = (0);
var G__8041 = (0);
seq__7959_8017 = G__8038;
chunk__7960_8018 = G__8039;
count__7961_8019 = G__8040;
i__7962_8020 = G__8041;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__8042){
var map__8043 = p__8042;
var map__8043__$1 = cljs.core.__destructure_map(map__8043);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8043__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8043__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8043__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8043__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8043__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__8044){
var map__8045 = p__8044;
var map__8045__$1 = cljs.core.__destructure_map(map__8045);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8045__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8045__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8045__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8045__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8045__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__5043__auto__ = code;
if(cljs.core.truth_(and__5043__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__5043__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__8050 = cljs.core.seq(table);
var chunk__8051 = null;
var count__8052 = (0);
var i__8053 = (0);
while(true){
if((i__8053 < count__8052)){
var vec__8060 = chunk__8051.cljs$core$IIndexed$_nth$arity$2(null,i__8053);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8060,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8060,(1),null);
var ns_8066 = cljs.core.namespace(sym);
var name_8067 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__8068 = seq__8050;
var G__8069 = chunk__8051;
var G__8070 = count__8052;
var G__8071 = (i__8053 + (1));
seq__8050 = G__8068;
chunk__8051 = G__8069;
count__8052 = G__8070;
i__8053 = G__8071;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__8050);
if(temp__5804__auto__){
var seq__8050__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__8050__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__8050__$1);
var G__8072 = cljs.core.chunk_rest(seq__8050__$1);
var G__8073 = c__5567__auto__;
var G__8074 = cljs.core.count(c__5567__auto__);
var G__8075 = (0);
seq__8050 = G__8072;
chunk__8051 = G__8073;
count__8052 = G__8074;
i__8053 = G__8075;
continue;
} else {
var vec__8063 = cljs.core.first(seq__8050__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8063,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8063,(1),null);
var ns_8076 = cljs.core.namespace(sym);
var name_8077 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__8078 = cljs.core.next(seq__8050__$1);
var G__8079 = null;
var G__8080 = (0);
var G__8081 = (0);
seq__8050 = G__8078;
chunk__8051 = G__8079;
count__8052 = G__8080;
i__8053 = G__8081;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__8083 = arguments.length;
switch (G__8083) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_8088 = cljs.core.first(ks);
var vec__8084_8089 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_8088);
var top_8090 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8084_8089,(0),null);
var prefix_SINGLEQUOTE__8091 = vec__8084_8089;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_8088)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__8091) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_8090)) || (cljs.core.contains_QMARK_(known_externs,top_8090)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__8091)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_8090);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__8091)),";");
}
} else {
}

var m_8092 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_8088);
if(cljs.core.empty_QMARK_(m_8092)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__8091,m_8092,top_level,known_externs);
}

var G__8093 = cljs.core.next(ks);
ks = G__8093;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

