// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
goog.scope(function(){
cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__11572 = arguments.length;
switch (G__11572) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11573 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11573 = (function (f,blockable,meta11574){
this.f = f;
this.blockable = blockable;
this.meta11574 = meta11574;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11573.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11575,meta11574__$1){
var self__ = this;
var _11575__$1 = this;
return (new cljs.core.async.t_cljs$core$async11573(self__.f,self__.blockable,meta11574__$1));
}));

(cljs.core.async.t_cljs$core$async11573.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11575){
var self__ = this;
var _11575__$1 = this;
return self__.meta11574;
}));

(cljs.core.async.t_cljs$core$async11573.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11573.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11573.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async11573.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async11573.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11574","meta11574",144828616,null)], null);
}));

(cljs.core.async.t_cljs$core$async11573.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11573.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11573");

(cljs.core.async.t_cljs$core$async11573.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async11573");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11573.
 */
cljs.core.async.__GT_t_cljs$core$async11573 = (function cljs$core$async$__GT_t_cljs$core$async11573(f__$1,blockable__$1,meta11574){
return (new cljs.core.async.t_cljs$core$async11573(f__$1,blockable__$1,meta11574));
});

}

return (new cljs.core.async.t_cljs$core$async11573(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__11579 = arguments.length;
switch (G__11579) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__11582 = arguments.length;
switch (G__11582) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__11585 = arguments.length;
switch (G__11585) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_11587 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_11587) : fn1.call(null,val_11587));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_11587) : fn1.call(null,val_11587));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__11589 = arguments.length;
switch (G__11589) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5635__auto___11591 = n;
var x_11592 = (0);
while(true){
if((x_11592 < n__5635__auto___11591)){
(a[x_11592] = x_11592);

var G__11593 = (x_11592 + (1));
x_11592 = G__11593;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle.call(null,a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11594 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11594 = (function (flag,meta11595){
this.flag = flag;
this.meta11595 = meta11595;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11594.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11596,meta11595__$1){
var self__ = this;
var _11596__$1 = this;
return (new cljs.core.async.t_cljs$core$async11594(self__.flag,meta11595__$1));
}));

(cljs.core.async.t_cljs$core$async11594.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11596){
var self__ = this;
var _11596__$1 = this;
return self__.meta11595;
}));

(cljs.core.async.t_cljs$core$async11594.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11594.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async11594.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11594.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async11594.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11595","meta11595",-571501425,null)], null);
}));

(cljs.core.async.t_cljs$core$async11594.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11594.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11594");

(cljs.core.async.t_cljs$core$async11594.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async11594");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11594.
 */
cljs.core.async.__GT_t_cljs$core$async11594 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11594(flag__$1,meta11595){
return (new cljs.core.async.t_cljs$core$async11594(flag__$1,meta11595));
});

}

return (new cljs.core.async.t_cljs$core$async11594(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11597 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11597 = (function (flag,cb,meta11598){
this.flag = flag;
this.cb = cb;
this.meta11598 = meta11598;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11597.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11599,meta11598__$1){
var self__ = this;
var _11599__$1 = this;
return (new cljs.core.async.t_cljs$core$async11597(self__.flag,self__.cb,meta11598__$1));
}));

(cljs.core.async.t_cljs$core$async11597.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11599){
var self__ = this;
var _11599__$1 = this;
return self__.meta11598;
}));

(cljs.core.async.t_cljs$core$async11597.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11597.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async11597.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11597.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async11597.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11598","meta11598",-723957917,null)], null);
}));

(cljs.core.async.t_cljs$core$async11597.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11597.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11597");

(cljs.core.async.t_cljs$core$async11597.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async11597");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11597.
 */
cljs.core.async.__GT_t_cljs$core$async11597 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11597(flag__$1,cb__$1,meta11598){
return (new cljs.core.async.t_cljs$core$async11597(flag__$1,cb__$1,meta11598));
});

}

return (new cljs.core.async.t_cljs$core$async11597(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11600_SHARP_){
var G__11602 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11600_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__11602) : fret.call(null,G__11602));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11601_SHARP_){
var G__11603 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11601_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__11603) : fret.call(null,G__11603));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11604 = (i + (1));
i = G__11604;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5043__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5043__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___11609 = arguments.length;
var i__5769__auto___11610 = (0);
while(true){
if((i__5769__auto___11610 < len__5768__auto___11609)){
args__5774__auto__.push((arguments[i__5769__auto___11610]));

var G__11611 = (i__5769__auto___11610 + (1));
i__5769__auto___11610 = G__11611;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11607){
var map__11608 = p__11607;
var map__11608__$1 = cljs.core.__destructure_map(map__11608);
var opts = map__11608__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11605){
var G__11606 = cljs.core.first(seq11605);
var seq11605__$1 = cljs.core.next(seq11605);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11606,seq11605__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__11613 = arguments.length;
switch (G__11613) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11512__auto___11660 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_11637){
var state_val_11638 = (state_11637[(1)]);
if((state_val_11638 === (7))){
var inst_11633 = (state_11637[(2)]);
var state_11637__$1 = state_11637;
var statearr_11639_11661 = state_11637__$1;
(statearr_11639_11661[(2)] = inst_11633);

(statearr_11639_11661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11638 === (1))){
var state_11637__$1 = state_11637;
var statearr_11640_11662 = state_11637__$1;
(statearr_11640_11662[(2)] = null);

(statearr_11640_11662[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11638 === (4))){
var inst_11616 = (state_11637[(7)]);
var inst_11616__$1 = (state_11637[(2)]);
var inst_11617 = (inst_11616__$1 == null);
var state_11637__$1 = (function (){var statearr_11641 = state_11637;
(statearr_11641[(7)] = inst_11616__$1);

return statearr_11641;
})();
if(cljs.core.truth_(inst_11617)){
var statearr_11642_11663 = state_11637__$1;
(statearr_11642_11663[(1)] = (5));

} else {
var statearr_11643_11664 = state_11637__$1;
(statearr_11643_11664[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11638 === (13))){
var state_11637__$1 = state_11637;
var statearr_11644_11665 = state_11637__$1;
(statearr_11644_11665[(2)] = null);

(statearr_11644_11665[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11638 === (6))){
var inst_11616 = (state_11637[(7)]);
var state_11637__$1 = state_11637;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11637__$1,(11),to,inst_11616);
} else {
if((state_val_11638 === (3))){
var inst_11635 = (state_11637[(2)]);
var state_11637__$1 = state_11637;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11637__$1,inst_11635);
} else {
if((state_val_11638 === (12))){
var state_11637__$1 = state_11637;
var statearr_11645_11666 = state_11637__$1;
(statearr_11645_11666[(2)] = null);

(statearr_11645_11666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11638 === (2))){
var state_11637__$1 = state_11637;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11637__$1,(4),from);
} else {
if((state_val_11638 === (11))){
var inst_11626 = (state_11637[(2)]);
var state_11637__$1 = state_11637;
if(cljs.core.truth_(inst_11626)){
var statearr_11646_11667 = state_11637__$1;
(statearr_11646_11667[(1)] = (12));

} else {
var statearr_11647_11668 = state_11637__$1;
(statearr_11647_11668[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11638 === (9))){
var state_11637__$1 = state_11637;
var statearr_11648_11669 = state_11637__$1;
(statearr_11648_11669[(2)] = null);

(statearr_11648_11669[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11638 === (5))){
var state_11637__$1 = state_11637;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11649_11670 = state_11637__$1;
(statearr_11649_11670[(1)] = (8));

} else {
var statearr_11650_11671 = state_11637__$1;
(statearr_11650_11671[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11638 === (14))){
var inst_11631 = (state_11637[(2)]);
var state_11637__$1 = state_11637;
var statearr_11651_11672 = state_11637__$1;
(statearr_11651_11672[(2)] = inst_11631);

(statearr_11651_11672[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11638 === (10))){
var inst_11623 = (state_11637[(2)]);
var state_11637__$1 = state_11637;
var statearr_11652_11673 = state_11637__$1;
(statearr_11652_11673[(2)] = inst_11623);

(statearr_11652_11673[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11638 === (8))){
var inst_11620 = cljs.core.async.close_BANG_(to);
var state_11637__$1 = state_11637;
var statearr_11653_11674 = state_11637__$1;
(statearr_11653_11674[(2)] = inst_11620);

(statearr_11653_11674[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11438__auto__ = null;
var cljs$core$async$state_machine__11438__auto____0 = (function (){
var statearr_11654 = [null,null,null,null,null,null,null,null];
(statearr_11654[(0)] = cljs$core$async$state_machine__11438__auto__);

(statearr_11654[(1)] = (1));

return statearr_11654;
});
var cljs$core$async$state_machine__11438__auto____1 = (function (state_11637){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_11637);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e11655){var ex__11441__auto__ = e11655;
var statearr_11656_11675 = state_11637;
(statearr_11656_11675[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_11637[(4)]))){
var statearr_11657_11676 = state_11637;
(statearr_11657_11676[(1)] = cljs.core.first((state_11637[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11677 = state_11637;
state_11637 = G__11677;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$state_machine__11438__auto__ = function(state_11637){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11438__auto____1.call(this,state_11637);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11438__auto____0;
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11438__auto____1;
return cljs$core$async$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_11658 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_11658[(6)] = c__11512__auto___11660);

return statearr_11658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__11678){
var vec__11679 = p__11678;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11679,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11679,(1),null);
var job = vec__11679;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__11512__auto___11855 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_11686){
var state_val_11687 = (state_11686[(1)]);
if((state_val_11687 === (1))){
var state_11686__$1 = state_11686;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11686__$1,(2),res,v);
} else {
if((state_val_11687 === (2))){
var inst_11683 = (state_11686[(2)]);
var inst_11684 = cljs.core.async.close_BANG_(res);
var state_11686__$1 = (function (){var statearr_11688 = state_11686;
(statearr_11688[(7)] = inst_11683);

return statearr_11688;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_11686__$1,inst_11684);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____0 = (function (){
var statearr_11689 = [null,null,null,null,null,null,null,null];
(statearr_11689[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__);

(statearr_11689[(1)] = (1));

return statearr_11689;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____1 = (function (state_11686){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_11686);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e11690){var ex__11441__auto__ = e11690;
var statearr_11691_11856 = state_11686;
(statearr_11691_11856[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_11686[(4)]))){
var statearr_11692_11857 = state_11686;
(statearr_11692_11857[(1)] = cljs.core.first((state_11686[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11858 = state_11686;
state_11686 = G__11858;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__ = function(state_11686){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____1.call(this,state_11686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_11693 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_11693[(6)] = c__11512__auto___11855);

return statearr_11693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__11694){
var vec__11695 = p__11694;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11695,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11695,(1),null);
var job = vec__11695;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5635__auto___11859 = n;
var __11860 = (0);
while(true){
if((__11860 < n__5635__auto___11859)){
var G__11698_11861 = type;
var G__11698_11862__$1 = (((G__11698_11861 instanceof cljs.core.Keyword))?G__11698_11861.fqn:null);
switch (G__11698_11862__$1) {
case "compute":
var c__11512__auto___11864 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__11860,c__11512__auto___11864,G__11698_11861,G__11698_11862__$1,n__5635__auto___11859,jobs,results,process__$1,async){
return (function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = ((function (__11860,c__11512__auto___11864,G__11698_11861,G__11698_11862__$1,n__5635__auto___11859,jobs,results,process__$1,async){
return (function (state_11711){
var state_val_11712 = (state_11711[(1)]);
if((state_val_11712 === (1))){
var state_11711__$1 = state_11711;
var statearr_11713_11865 = state_11711__$1;
(statearr_11713_11865[(2)] = null);

(statearr_11713_11865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11712 === (2))){
var state_11711__$1 = state_11711;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11711__$1,(4),jobs);
} else {
if((state_val_11712 === (3))){
var inst_11709 = (state_11711[(2)]);
var state_11711__$1 = state_11711;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11711__$1,inst_11709);
} else {
if((state_val_11712 === (4))){
var inst_11701 = (state_11711[(2)]);
var inst_11702 = process__$1(inst_11701);
var state_11711__$1 = state_11711;
if(cljs.core.truth_(inst_11702)){
var statearr_11714_11866 = state_11711__$1;
(statearr_11714_11866[(1)] = (5));

} else {
var statearr_11715_11867 = state_11711__$1;
(statearr_11715_11867[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11712 === (5))){
var state_11711__$1 = state_11711;
var statearr_11716_11868 = state_11711__$1;
(statearr_11716_11868[(2)] = null);

(statearr_11716_11868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11712 === (6))){
var state_11711__$1 = state_11711;
var statearr_11717_11869 = state_11711__$1;
(statearr_11717_11869[(2)] = null);

(statearr_11717_11869[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11712 === (7))){
var inst_11707 = (state_11711[(2)]);
var state_11711__$1 = state_11711;
var statearr_11718_11870 = state_11711__$1;
(statearr_11718_11870[(2)] = inst_11707);

(statearr_11718_11870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11860,c__11512__auto___11864,G__11698_11861,G__11698_11862__$1,n__5635__auto___11859,jobs,results,process__$1,async))
;
return ((function (__11860,switch__11437__auto__,c__11512__auto___11864,G__11698_11861,G__11698_11862__$1,n__5635__auto___11859,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____0 = (function (){
var statearr_11719 = [null,null,null,null,null,null,null];
(statearr_11719[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__);

(statearr_11719[(1)] = (1));

return statearr_11719;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____1 = (function (state_11711){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_11711);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e11720){var ex__11441__auto__ = e11720;
var statearr_11721_11871 = state_11711;
(statearr_11721_11871[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_11711[(4)]))){
var statearr_11722_11872 = state_11711;
(statearr_11722_11872[(1)] = cljs.core.first((state_11711[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11873 = state_11711;
state_11711 = G__11873;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__ = function(state_11711){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____1.call(this,state_11711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__;
})()
;})(__11860,switch__11437__auto__,c__11512__auto___11864,G__11698_11861,G__11698_11862__$1,n__5635__auto___11859,jobs,results,process__$1,async))
})();
var state__11514__auto__ = (function (){var statearr_11723 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_11723[(6)] = c__11512__auto___11864);

return statearr_11723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
});})(__11860,c__11512__auto___11864,G__11698_11861,G__11698_11862__$1,n__5635__auto___11859,jobs,results,process__$1,async))
);


break;
case "async":
var c__11512__auto___11874 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__11860,c__11512__auto___11874,G__11698_11861,G__11698_11862__$1,n__5635__auto___11859,jobs,results,process__$1,async){
return (function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = ((function (__11860,c__11512__auto___11874,G__11698_11861,G__11698_11862__$1,n__5635__auto___11859,jobs,results,process__$1,async){
return (function (state_11736){
var state_val_11737 = (state_11736[(1)]);
if((state_val_11737 === (1))){
var state_11736__$1 = state_11736;
var statearr_11738_11875 = state_11736__$1;
(statearr_11738_11875[(2)] = null);

(statearr_11738_11875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11737 === (2))){
var state_11736__$1 = state_11736;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11736__$1,(4),jobs);
} else {
if((state_val_11737 === (3))){
var inst_11734 = (state_11736[(2)]);
var state_11736__$1 = state_11736;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11736__$1,inst_11734);
} else {
if((state_val_11737 === (4))){
var inst_11726 = (state_11736[(2)]);
var inst_11727 = async(inst_11726);
var state_11736__$1 = state_11736;
if(cljs.core.truth_(inst_11727)){
var statearr_11739_11876 = state_11736__$1;
(statearr_11739_11876[(1)] = (5));

} else {
var statearr_11740_11877 = state_11736__$1;
(statearr_11740_11877[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11737 === (5))){
var state_11736__$1 = state_11736;
var statearr_11741_11878 = state_11736__$1;
(statearr_11741_11878[(2)] = null);

(statearr_11741_11878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11737 === (6))){
var state_11736__$1 = state_11736;
var statearr_11742_11879 = state_11736__$1;
(statearr_11742_11879[(2)] = null);

(statearr_11742_11879[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11737 === (7))){
var inst_11732 = (state_11736[(2)]);
var state_11736__$1 = state_11736;
var statearr_11743_11880 = state_11736__$1;
(statearr_11743_11880[(2)] = inst_11732);

(statearr_11743_11880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11860,c__11512__auto___11874,G__11698_11861,G__11698_11862__$1,n__5635__auto___11859,jobs,results,process__$1,async))
;
return ((function (__11860,switch__11437__auto__,c__11512__auto___11874,G__11698_11861,G__11698_11862__$1,n__5635__auto___11859,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____0 = (function (){
var statearr_11744 = [null,null,null,null,null,null,null];
(statearr_11744[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__);

(statearr_11744[(1)] = (1));

return statearr_11744;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____1 = (function (state_11736){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_11736);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e11745){var ex__11441__auto__ = e11745;
var statearr_11746_11881 = state_11736;
(statearr_11746_11881[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_11736[(4)]))){
var statearr_11747_11882 = state_11736;
(statearr_11747_11882[(1)] = cljs.core.first((state_11736[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11883 = state_11736;
state_11736 = G__11883;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__ = function(state_11736){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____1.call(this,state_11736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__;
})()
;})(__11860,switch__11437__auto__,c__11512__auto___11874,G__11698_11861,G__11698_11862__$1,n__5635__auto___11859,jobs,results,process__$1,async))
})();
var state__11514__auto__ = (function (){var statearr_11748 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_11748[(6)] = c__11512__auto___11874);

return statearr_11748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
});})(__11860,c__11512__auto___11874,G__11698_11861,G__11698_11862__$1,n__5635__auto___11859,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__11698_11862__$1)].join('')));

}

var G__11884 = (__11860 + (1));
__11860 = G__11884;
continue;
} else {
}
break;
}

var c__11512__auto___11885 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_11770){
var state_val_11771 = (state_11770[(1)]);
if((state_val_11771 === (7))){
var inst_11766 = (state_11770[(2)]);
var state_11770__$1 = state_11770;
var statearr_11772_11886 = state_11770__$1;
(statearr_11772_11886[(2)] = inst_11766);

(statearr_11772_11886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11771 === (1))){
var state_11770__$1 = state_11770;
var statearr_11773_11887 = state_11770__$1;
(statearr_11773_11887[(2)] = null);

(statearr_11773_11887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11771 === (4))){
var inst_11751 = (state_11770[(7)]);
var inst_11751__$1 = (state_11770[(2)]);
var inst_11752 = (inst_11751__$1 == null);
var state_11770__$1 = (function (){var statearr_11774 = state_11770;
(statearr_11774[(7)] = inst_11751__$1);

return statearr_11774;
})();
if(cljs.core.truth_(inst_11752)){
var statearr_11775_11888 = state_11770__$1;
(statearr_11775_11888[(1)] = (5));

} else {
var statearr_11776_11889 = state_11770__$1;
(statearr_11776_11889[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11771 === (6))){
var inst_11751 = (state_11770[(7)]);
var inst_11756 = (state_11770[(8)]);
var inst_11756__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_11757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11758 = [inst_11751,inst_11756__$1];
var inst_11759 = (new cljs.core.PersistentVector(null,2,(5),inst_11757,inst_11758,null));
var state_11770__$1 = (function (){var statearr_11777 = state_11770;
(statearr_11777[(8)] = inst_11756__$1);

return statearr_11777;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11770__$1,(8),jobs,inst_11759);
} else {
if((state_val_11771 === (3))){
var inst_11768 = (state_11770[(2)]);
var state_11770__$1 = state_11770;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11770__$1,inst_11768);
} else {
if((state_val_11771 === (2))){
var state_11770__$1 = state_11770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11770__$1,(4),from);
} else {
if((state_val_11771 === (9))){
var inst_11763 = (state_11770[(2)]);
var state_11770__$1 = (function (){var statearr_11778 = state_11770;
(statearr_11778[(9)] = inst_11763);

return statearr_11778;
})();
var statearr_11779_11890 = state_11770__$1;
(statearr_11779_11890[(2)] = null);

(statearr_11779_11890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11771 === (5))){
var inst_11754 = cljs.core.async.close_BANG_(jobs);
var state_11770__$1 = state_11770;
var statearr_11780_11891 = state_11770__$1;
(statearr_11780_11891[(2)] = inst_11754);

(statearr_11780_11891[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11771 === (8))){
var inst_11756 = (state_11770[(8)]);
var inst_11761 = (state_11770[(2)]);
var state_11770__$1 = (function (){var statearr_11781 = state_11770;
(statearr_11781[(10)] = inst_11761);

return statearr_11781;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11770__$1,(9),results,inst_11756);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____0 = (function (){
var statearr_11782 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11782[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__);

(statearr_11782[(1)] = (1));

return statearr_11782;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____1 = (function (state_11770){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_11770);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e11783){var ex__11441__auto__ = e11783;
var statearr_11784_11892 = state_11770;
(statearr_11784_11892[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_11770[(4)]))){
var statearr_11785_11893 = state_11770;
(statearr_11785_11893[(1)] = cljs.core.first((state_11770[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11894 = state_11770;
state_11770 = G__11894;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__ = function(state_11770){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____1.call(this,state_11770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_11786 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_11786[(6)] = c__11512__auto___11885);

return statearr_11786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_11824){
var state_val_11825 = (state_11824[(1)]);
if((state_val_11825 === (7))){
var inst_11820 = (state_11824[(2)]);
var state_11824__$1 = state_11824;
var statearr_11826_11895 = state_11824__$1;
(statearr_11826_11895[(2)] = inst_11820);

(statearr_11826_11895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11825 === (20))){
var state_11824__$1 = state_11824;
var statearr_11827_11896 = state_11824__$1;
(statearr_11827_11896[(2)] = null);

(statearr_11827_11896[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11825 === (1))){
var state_11824__$1 = state_11824;
var statearr_11828_11897 = state_11824__$1;
(statearr_11828_11897[(2)] = null);

(statearr_11828_11897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11825 === (4))){
var inst_11789 = (state_11824[(7)]);
var inst_11789__$1 = (state_11824[(2)]);
var inst_11790 = (inst_11789__$1 == null);
var state_11824__$1 = (function (){var statearr_11829 = state_11824;
(statearr_11829[(7)] = inst_11789__$1);

return statearr_11829;
})();
if(cljs.core.truth_(inst_11790)){
var statearr_11830_11898 = state_11824__$1;
(statearr_11830_11898[(1)] = (5));

} else {
var statearr_11831_11899 = state_11824__$1;
(statearr_11831_11899[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11825 === (15))){
var inst_11802 = (state_11824[(8)]);
var state_11824__$1 = state_11824;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11824__$1,(18),to,inst_11802);
} else {
if((state_val_11825 === (21))){
var inst_11815 = (state_11824[(2)]);
var state_11824__$1 = state_11824;
var statearr_11832_11900 = state_11824__$1;
(statearr_11832_11900[(2)] = inst_11815);

(statearr_11832_11900[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11825 === (13))){
var inst_11817 = (state_11824[(2)]);
var state_11824__$1 = (function (){var statearr_11833 = state_11824;
(statearr_11833[(9)] = inst_11817);

return statearr_11833;
})();
var statearr_11834_11901 = state_11824__$1;
(statearr_11834_11901[(2)] = null);

(statearr_11834_11901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11825 === (6))){
var inst_11789 = (state_11824[(7)]);
var state_11824__$1 = state_11824;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11824__$1,(11),inst_11789);
} else {
if((state_val_11825 === (17))){
var inst_11810 = (state_11824[(2)]);
var state_11824__$1 = state_11824;
if(cljs.core.truth_(inst_11810)){
var statearr_11835_11902 = state_11824__$1;
(statearr_11835_11902[(1)] = (19));

} else {
var statearr_11836_11903 = state_11824__$1;
(statearr_11836_11903[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11825 === (3))){
var inst_11822 = (state_11824[(2)]);
var state_11824__$1 = state_11824;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11824__$1,inst_11822);
} else {
if((state_val_11825 === (12))){
var inst_11799 = (state_11824[(10)]);
var state_11824__$1 = state_11824;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11824__$1,(14),inst_11799);
} else {
if((state_val_11825 === (2))){
var state_11824__$1 = state_11824;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11824__$1,(4),results);
} else {
if((state_val_11825 === (19))){
var state_11824__$1 = state_11824;
var statearr_11837_11904 = state_11824__$1;
(statearr_11837_11904[(2)] = null);

(statearr_11837_11904[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11825 === (11))){
var inst_11799 = (state_11824[(2)]);
var state_11824__$1 = (function (){var statearr_11838 = state_11824;
(statearr_11838[(10)] = inst_11799);

return statearr_11838;
})();
var statearr_11839_11905 = state_11824__$1;
(statearr_11839_11905[(2)] = null);

(statearr_11839_11905[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11825 === (9))){
var state_11824__$1 = state_11824;
var statearr_11840_11906 = state_11824__$1;
(statearr_11840_11906[(2)] = null);

(statearr_11840_11906[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11825 === (5))){
var state_11824__$1 = state_11824;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11841_11907 = state_11824__$1;
(statearr_11841_11907[(1)] = (8));

} else {
var statearr_11842_11908 = state_11824__$1;
(statearr_11842_11908[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11825 === (14))){
var inst_11802 = (state_11824[(8)]);
var inst_11804 = (state_11824[(11)]);
var inst_11802__$1 = (state_11824[(2)]);
var inst_11803 = (inst_11802__$1 == null);
var inst_11804__$1 = cljs.core.not(inst_11803);
var state_11824__$1 = (function (){var statearr_11843 = state_11824;
(statearr_11843[(8)] = inst_11802__$1);

(statearr_11843[(11)] = inst_11804__$1);

return statearr_11843;
})();
if(inst_11804__$1){
var statearr_11844_11909 = state_11824__$1;
(statearr_11844_11909[(1)] = (15));

} else {
var statearr_11845_11910 = state_11824__$1;
(statearr_11845_11910[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11825 === (16))){
var inst_11804 = (state_11824[(11)]);
var state_11824__$1 = state_11824;
var statearr_11846_11911 = state_11824__$1;
(statearr_11846_11911[(2)] = inst_11804);

(statearr_11846_11911[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11825 === (10))){
var inst_11796 = (state_11824[(2)]);
var state_11824__$1 = state_11824;
var statearr_11847_11912 = state_11824__$1;
(statearr_11847_11912[(2)] = inst_11796);

(statearr_11847_11912[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11825 === (18))){
var inst_11807 = (state_11824[(2)]);
var state_11824__$1 = state_11824;
var statearr_11848_11913 = state_11824__$1;
(statearr_11848_11913[(2)] = inst_11807);

(statearr_11848_11913[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11825 === (8))){
var inst_11793 = cljs.core.async.close_BANG_(to);
var state_11824__$1 = state_11824;
var statearr_11849_11914 = state_11824__$1;
(statearr_11849_11914[(2)] = inst_11793);

(statearr_11849_11914[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____0 = (function (){
var statearr_11850 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11850[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__);

(statearr_11850[(1)] = (1));

return statearr_11850;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____1 = (function (state_11824){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_11824);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e11851){var ex__11441__auto__ = e11851;
var statearr_11852_11915 = state_11824;
(statearr_11852_11915[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_11824[(4)]))){
var statearr_11853_11916 = state_11824;
(statearr_11853_11916[(1)] = cljs.core.first((state_11824[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11917 = state_11824;
state_11824 = G__11917;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__ = function(state_11824){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____1.call(this,state_11824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11438__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_11854 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_11854[(6)] = c__11512__auto__);

return statearr_11854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__11919 = arguments.length;
switch (G__11919) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__11922 = arguments.length;
switch (G__11922) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__11925 = arguments.length;
switch (G__11925) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__11512__auto___11975 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_11951){
var state_val_11952 = (state_11951[(1)]);
if((state_val_11952 === (7))){
var inst_11947 = (state_11951[(2)]);
var state_11951__$1 = state_11951;
var statearr_11953_11976 = state_11951__$1;
(statearr_11953_11976[(2)] = inst_11947);

(statearr_11953_11976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (1))){
var state_11951__$1 = state_11951;
var statearr_11954_11977 = state_11951__$1;
(statearr_11954_11977[(2)] = null);

(statearr_11954_11977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (4))){
var inst_11928 = (state_11951[(7)]);
var inst_11928__$1 = (state_11951[(2)]);
var inst_11929 = (inst_11928__$1 == null);
var state_11951__$1 = (function (){var statearr_11955 = state_11951;
(statearr_11955[(7)] = inst_11928__$1);

return statearr_11955;
})();
if(cljs.core.truth_(inst_11929)){
var statearr_11956_11978 = state_11951__$1;
(statearr_11956_11978[(1)] = (5));

} else {
var statearr_11957_11979 = state_11951__$1;
(statearr_11957_11979[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (13))){
var state_11951__$1 = state_11951;
var statearr_11958_11980 = state_11951__$1;
(statearr_11958_11980[(2)] = null);

(statearr_11958_11980[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (6))){
var inst_11928 = (state_11951[(7)]);
var inst_11934 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_11928) : p.call(null,inst_11928));
var state_11951__$1 = state_11951;
if(cljs.core.truth_(inst_11934)){
var statearr_11959_11981 = state_11951__$1;
(statearr_11959_11981[(1)] = (9));

} else {
var statearr_11960_11982 = state_11951__$1;
(statearr_11960_11982[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (3))){
var inst_11949 = (state_11951[(2)]);
var state_11951__$1 = state_11951;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11951__$1,inst_11949);
} else {
if((state_val_11952 === (12))){
var state_11951__$1 = state_11951;
var statearr_11961_11983 = state_11951__$1;
(statearr_11961_11983[(2)] = null);

(statearr_11961_11983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (2))){
var state_11951__$1 = state_11951;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11951__$1,(4),ch);
} else {
if((state_val_11952 === (11))){
var inst_11928 = (state_11951[(7)]);
var inst_11938 = (state_11951[(2)]);
var state_11951__$1 = state_11951;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11951__$1,(8),inst_11938,inst_11928);
} else {
if((state_val_11952 === (9))){
var state_11951__$1 = state_11951;
var statearr_11962_11984 = state_11951__$1;
(statearr_11962_11984[(2)] = tc);

(statearr_11962_11984[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (5))){
var inst_11931 = cljs.core.async.close_BANG_(tc);
var inst_11932 = cljs.core.async.close_BANG_(fc);
var state_11951__$1 = (function (){var statearr_11963 = state_11951;
(statearr_11963[(8)] = inst_11931);

return statearr_11963;
})();
var statearr_11964_11985 = state_11951__$1;
(statearr_11964_11985[(2)] = inst_11932);

(statearr_11964_11985[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (14))){
var inst_11945 = (state_11951[(2)]);
var state_11951__$1 = state_11951;
var statearr_11965_11986 = state_11951__$1;
(statearr_11965_11986[(2)] = inst_11945);

(statearr_11965_11986[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (10))){
var state_11951__$1 = state_11951;
var statearr_11966_11987 = state_11951__$1;
(statearr_11966_11987[(2)] = fc);

(statearr_11966_11987[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (8))){
var inst_11940 = (state_11951[(2)]);
var state_11951__$1 = state_11951;
if(cljs.core.truth_(inst_11940)){
var statearr_11967_11988 = state_11951__$1;
(statearr_11967_11988[(1)] = (12));

} else {
var statearr_11968_11989 = state_11951__$1;
(statearr_11968_11989[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11438__auto__ = null;
var cljs$core$async$state_machine__11438__auto____0 = (function (){
var statearr_11969 = [null,null,null,null,null,null,null,null,null];
(statearr_11969[(0)] = cljs$core$async$state_machine__11438__auto__);

(statearr_11969[(1)] = (1));

return statearr_11969;
});
var cljs$core$async$state_machine__11438__auto____1 = (function (state_11951){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_11951);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e11970){var ex__11441__auto__ = e11970;
var statearr_11971_11990 = state_11951;
(statearr_11971_11990[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_11951[(4)]))){
var statearr_11972_11991 = state_11951;
(statearr_11972_11991[(1)] = cljs.core.first((state_11951[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11992 = state_11951;
state_11951 = G__11992;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$state_machine__11438__auto__ = function(state_11951){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11438__auto____1.call(this,state_11951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11438__auto____0;
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11438__auto____1;
return cljs$core$async$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_11973 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_11973[(6)] = c__11512__auto___11975);

return statearr_11973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_12014){
var state_val_12015 = (state_12014[(1)]);
if((state_val_12015 === (7))){
var inst_12010 = (state_12014[(2)]);
var state_12014__$1 = state_12014;
var statearr_12016_12035 = state_12014__$1;
(statearr_12016_12035[(2)] = inst_12010);

(statearr_12016_12035[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12015 === (1))){
var inst_11993 = init;
var inst_11994 = inst_11993;
var state_12014__$1 = (function (){var statearr_12017 = state_12014;
(statearr_12017[(7)] = inst_11994);

return statearr_12017;
})();
var statearr_12018_12036 = state_12014__$1;
(statearr_12018_12036[(2)] = null);

(statearr_12018_12036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12015 === (4))){
var inst_11997 = (state_12014[(8)]);
var inst_11997__$1 = (state_12014[(2)]);
var inst_11998 = (inst_11997__$1 == null);
var state_12014__$1 = (function (){var statearr_12019 = state_12014;
(statearr_12019[(8)] = inst_11997__$1);

return statearr_12019;
})();
if(cljs.core.truth_(inst_11998)){
var statearr_12020_12037 = state_12014__$1;
(statearr_12020_12037[(1)] = (5));

} else {
var statearr_12021_12038 = state_12014__$1;
(statearr_12021_12038[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12015 === (6))){
var inst_11997 = (state_12014[(8)]);
var inst_12001 = (state_12014[(9)]);
var inst_11994 = (state_12014[(7)]);
var inst_12001__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_11994,inst_11997) : f.call(null,inst_11994,inst_11997));
var inst_12002 = cljs.core.reduced_QMARK_(inst_12001__$1);
var state_12014__$1 = (function (){var statearr_12022 = state_12014;
(statearr_12022[(9)] = inst_12001__$1);

return statearr_12022;
})();
if(inst_12002){
var statearr_12023_12039 = state_12014__$1;
(statearr_12023_12039[(1)] = (8));

} else {
var statearr_12024_12040 = state_12014__$1;
(statearr_12024_12040[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12015 === (3))){
var inst_12012 = (state_12014[(2)]);
var state_12014__$1 = state_12014;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12014__$1,inst_12012);
} else {
if((state_val_12015 === (2))){
var state_12014__$1 = state_12014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12014__$1,(4),ch);
} else {
if((state_val_12015 === (9))){
var inst_12001 = (state_12014[(9)]);
var inst_11994 = inst_12001;
var state_12014__$1 = (function (){var statearr_12025 = state_12014;
(statearr_12025[(7)] = inst_11994);

return statearr_12025;
})();
var statearr_12026_12041 = state_12014__$1;
(statearr_12026_12041[(2)] = null);

(statearr_12026_12041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12015 === (5))){
var inst_11994 = (state_12014[(7)]);
var state_12014__$1 = state_12014;
var statearr_12027_12042 = state_12014__$1;
(statearr_12027_12042[(2)] = inst_11994);

(statearr_12027_12042[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12015 === (10))){
var inst_12008 = (state_12014[(2)]);
var state_12014__$1 = state_12014;
var statearr_12028_12043 = state_12014__$1;
(statearr_12028_12043[(2)] = inst_12008);

(statearr_12028_12043[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12015 === (8))){
var inst_12001 = (state_12014[(9)]);
var inst_12004 = cljs.core.deref(inst_12001);
var state_12014__$1 = state_12014;
var statearr_12029_12044 = state_12014__$1;
(statearr_12029_12044[(2)] = inst_12004);

(statearr_12029_12044[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__11438__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11438__auto____0 = (function (){
var statearr_12030 = [null,null,null,null,null,null,null,null,null,null];
(statearr_12030[(0)] = cljs$core$async$reduce_$_state_machine__11438__auto__);

(statearr_12030[(1)] = (1));

return statearr_12030;
});
var cljs$core$async$reduce_$_state_machine__11438__auto____1 = (function (state_12014){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_12014);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e12031){var ex__11441__auto__ = e12031;
var statearr_12032_12045 = state_12014;
(statearr_12032_12045[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_12014[(4)]))){
var statearr_12033_12046 = state_12014;
(statearr_12033_12046[(1)] = cljs.core.first((state_12014[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12047 = state_12014;
state_12014 = G__12047;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11438__auto__ = function(state_12014){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11438__auto____1.call(this,state_12014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11438__auto____0;
cljs$core$async$reduce_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11438__auto____1;
return cljs$core$async$reduce_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_12034 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_12034[(6)] = c__11512__auto__);

return statearr_12034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_12053){
var state_val_12054 = (state_12053[(1)]);
if((state_val_12054 === (1))){
var inst_12048 = cljs.core.async.reduce(f__$1,init,ch);
var state_12053__$1 = state_12053;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12053__$1,(2),inst_12048);
} else {
if((state_val_12054 === (2))){
var inst_12050 = (state_12053[(2)]);
var inst_12051 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_12050) : f__$1.call(null,inst_12050));
var state_12053__$1 = state_12053;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12053__$1,inst_12051);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__11438__auto__ = null;
var cljs$core$async$transduce_$_state_machine__11438__auto____0 = (function (){
var statearr_12055 = [null,null,null,null,null,null,null];
(statearr_12055[(0)] = cljs$core$async$transduce_$_state_machine__11438__auto__);

(statearr_12055[(1)] = (1));

return statearr_12055;
});
var cljs$core$async$transduce_$_state_machine__11438__auto____1 = (function (state_12053){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_12053);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e12056){var ex__11441__auto__ = e12056;
var statearr_12057_12060 = state_12053;
(statearr_12057_12060[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_12053[(4)]))){
var statearr_12058_12061 = state_12053;
(statearr_12058_12061[(1)] = cljs.core.first((state_12053[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12062 = state_12053;
state_12053 = G__12062;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__11438__auto__ = function(state_12053){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__11438__auto____1.call(this,state_12053);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__11438__auto____0;
cljs$core$async$transduce_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__11438__auto____1;
return cljs$core$async$transduce_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_12059 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_12059[(6)] = c__11512__auto__);

return statearr_12059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__12064 = arguments.length;
switch (G__12064) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_12089){
var state_val_12090 = (state_12089[(1)]);
if((state_val_12090 === (7))){
var inst_12071 = (state_12089[(2)]);
var state_12089__$1 = state_12089;
var statearr_12091_12113 = state_12089__$1;
(statearr_12091_12113[(2)] = inst_12071);

(statearr_12091_12113[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12090 === (1))){
var inst_12065 = cljs.core.seq(coll);
var inst_12066 = inst_12065;
var state_12089__$1 = (function (){var statearr_12092 = state_12089;
(statearr_12092[(7)] = inst_12066);

return statearr_12092;
})();
var statearr_12093_12114 = state_12089__$1;
(statearr_12093_12114[(2)] = null);

(statearr_12093_12114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12090 === (4))){
var inst_12066 = (state_12089[(7)]);
var inst_12069 = cljs.core.first(inst_12066);
var state_12089__$1 = state_12089;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12089__$1,(7),ch,inst_12069);
} else {
if((state_val_12090 === (13))){
var inst_12083 = (state_12089[(2)]);
var state_12089__$1 = state_12089;
var statearr_12094_12115 = state_12089__$1;
(statearr_12094_12115[(2)] = inst_12083);

(statearr_12094_12115[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12090 === (6))){
var inst_12074 = (state_12089[(2)]);
var state_12089__$1 = state_12089;
if(cljs.core.truth_(inst_12074)){
var statearr_12095_12116 = state_12089__$1;
(statearr_12095_12116[(1)] = (8));

} else {
var statearr_12096_12117 = state_12089__$1;
(statearr_12096_12117[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12090 === (3))){
var inst_12087 = (state_12089[(2)]);
var state_12089__$1 = state_12089;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12089__$1,inst_12087);
} else {
if((state_val_12090 === (12))){
var state_12089__$1 = state_12089;
var statearr_12097_12118 = state_12089__$1;
(statearr_12097_12118[(2)] = null);

(statearr_12097_12118[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12090 === (2))){
var inst_12066 = (state_12089[(7)]);
var state_12089__$1 = state_12089;
if(cljs.core.truth_(inst_12066)){
var statearr_12098_12119 = state_12089__$1;
(statearr_12098_12119[(1)] = (4));

} else {
var statearr_12099_12120 = state_12089__$1;
(statearr_12099_12120[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12090 === (11))){
var inst_12080 = cljs.core.async.close_BANG_(ch);
var state_12089__$1 = state_12089;
var statearr_12100_12121 = state_12089__$1;
(statearr_12100_12121[(2)] = inst_12080);

(statearr_12100_12121[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12090 === (9))){
var state_12089__$1 = state_12089;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12101_12122 = state_12089__$1;
(statearr_12101_12122[(1)] = (11));

} else {
var statearr_12102_12123 = state_12089__$1;
(statearr_12102_12123[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12090 === (5))){
var inst_12066 = (state_12089[(7)]);
var state_12089__$1 = state_12089;
var statearr_12103_12124 = state_12089__$1;
(statearr_12103_12124[(2)] = inst_12066);

(statearr_12103_12124[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12090 === (10))){
var inst_12085 = (state_12089[(2)]);
var state_12089__$1 = state_12089;
var statearr_12104_12125 = state_12089__$1;
(statearr_12104_12125[(2)] = inst_12085);

(statearr_12104_12125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12090 === (8))){
var inst_12066 = (state_12089[(7)]);
var inst_12076 = cljs.core.next(inst_12066);
var inst_12066__$1 = inst_12076;
var state_12089__$1 = (function (){var statearr_12105 = state_12089;
(statearr_12105[(7)] = inst_12066__$1);

return statearr_12105;
})();
var statearr_12106_12126 = state_12089__$1;
(statearr_12106_12126[(2)] = null);

(statearr_12106_12126[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11438__auto__ = null;
var cljs$core$async$state_machine__11438__auto____0 = (function (){
var statearr_12107 = [null,null,null,null,null,null,null,null];
(statearr_12107[(0)] = cljs$core$async$state_machine__11438__auto__);

(statearr_12107[(1)] = (1));

return statearr_12107;
});
var cljs$core$async$state_machine__11438__auto____1 = (function (state_12089){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_12089);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e12108){var ex__11441__auto__ = e12108;
var statearr_12109_12127 = state_12089;
(statearr_12109_12127[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_12089[(4)]))){
var statearr_12110_12128 = state_12089;
(statearr_12110_12128[(1)] = cljs.core.first((state_12089[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12129 = state_12089;
state_12089 = G__12129;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$state_machine__11438__auto__ = function(state_12089){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11438__auto____1.call(this,state_12089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11438__auto____0;
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11438__auto____1;
return cljs$core$async$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_12111 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_12111[(6)] = c__11512__auto__);

return statearr_12111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__12131 = arguments.length;
switch (G__12131) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_12133 = (function (_){
var x__5392__auto__ = (((_ == null))?null:_);
var m__5393__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5393__auto__.call(null,_));
} else {
var m__5391__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5391__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_12133(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_12134 = (function (m,ch,close_QMARK_){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5393__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5391__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5391__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_12134(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_12135 = (function (m,ch){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5393__auto__.call(null,m,ch));
} else {
var m__5391__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5391__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_12135(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_12136 = (function (m){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5393__auto__.call(null,m));
} else {
var m__5391__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5391__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_12136(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12137 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12137 = (function (ch,cs,meta12138){
this.ch = ch;
this.cs = cs;
this.meta12138 = meta12138;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12137.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12139,meta12138__$1){
var self__ = this;
var _12139__$1 = this;
return (new cljs.core.async.t_cljs$core$async12137(self__.ch,self__.cs,meta12138__$1));
}));

(cljs.core.async.t_cljs$core$async12137.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12139){
var self__ = this;
var _12139__$1 = this;
return self__.meta12138;
}));

(cljs.core.async.t_cljs$core$async12137.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12137.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async12137.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12137.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async12137.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async12137.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async12137.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta12138","meta12138",1300351097,null)], null);
}));

(cljs.core.async.t_cljs$core$async12137.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12137.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12137");

(cljs.core.async.t_cljs$core$async12137.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async12137");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12137.
 */
cljs.core.async.__GT_t_cljs$core$async12137 = (function cljs$core$async$mult_$___GT_t_cljs$core$async12137(ch__$1,cs__$1,meta12138){
return (new cljs.core.async.t_cljs$core$async12137(ch__$1,cs__$1,meta12138));
});

}

return (new cljs.core.async.t_cljs$core$async12137(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__11512__auto___12356 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_12272){
var state_val_12273 = (state_12272[(1)]);
if((state_val_12273 === (7))){
var inst_12268 = (state_12272[(2)]);
var state_12272__$1 = state_12272;
var statearr_12274_12357 = state_12272__$1;
(statearr_12274_12357[(2)] = inst_12268);

(statearr_12274_12357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (20))){
var inst_12173 = (state_12272[(7)]);
var inst_12185 = cljs.core.first(inst_12173);
var inst_12186 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12185,(0),null);
var inst_12187 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12185,(1),null);
var state_12272__$1 = (function (){var statearr_12275 = state_12272;
(statearr_12275[(8)] = inst_12186);

return statearr_12275;
})();
if(cljs.core.truth_(inst_12187)){
var statearr_12276_12358 = state_12272__$1;
(statearr_12276_12358[(1)] = (22));

} else {
var statearr_12277_12359 = state_12272__$1;
(statearr_12277_12359[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (27))){
var inst_12222 = (state_12272[(9)]);
var inst_12142 = (state_12272[(10)]);
var inst_12217 = (state_12272[(11)]);
var inst_12215 = (state_12272[(12)]);
var inst_12222__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_12215,inst_12217);
var inst_12223 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_12222__$1,inst_12142,done);
var state_12272__$1 = (function (){var statearr_12278 = state_12272;
(statearr_12278[(9)] = inst_12222__$1);

return statearr_12278;
})();
if(cljs.core.truth_(inst_12223)){
var statearr_12279_12360 = state_12272__$1;
(statearr_12279_12360[(1)] = (30));

} else {
var statearr_12280_12361 = state_12272__$1;
(statearr_12280_12361[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (1))){
var state_12272__$1 = state_12272;
var statearr_12281_12362 = state_12272__$1;
(statearr_12281_12362[(2)] = null);

(statearr_12281_12362[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (24))){
var inst_12173 = (state_12272[(7)]);
var inst_12192 = (state_12272[(2)]);
var inst_12193 = cljs.core.next(inst_12173);
var inst_12151 = inst_12193;
var inst_12152 = null;
var inst_12153 = (0);
var inst_12154 = (0);
var state_12272__$1 = (function (){var statearr_12282 = state_12272;
(statearr_12282[(13)] = inst_12192);

(statearr_12282[(14)] = inst_12154);

(statearr_12282[(15)] = inst_12153);

(statearr_12282[(16)] = inst_12152);

(statearr_12282[(17)] = inst_12151);

return statearr_12282;
})();
var statearr_12283_12363 = state_12272__$1;
(statearr_12283_12363[(2)] = null);

(statearr_12283_12363[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (39))){
var state_12272__$1 = state_12272;
var statearr_12287_12364 = state_12272__$1;
(statearr_12287_12364[(2)] = null);

(statearr_12287_12364[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (4))){
var inst_12142 = (state_12272[(10)]);
var inst_12142__$1 = (state_12272[(2)]);
var inst_12143 = (inst_12142__$1 == null);
var state_12272__$1 = (function (){var statearr_12288 = state_12272;
(statearr_12288[(10)] = inst_12142__$1);

return statearr_12288;
})();
if(cljs.core.truth_(inst_12143)){
var statearr_12289_12365 = state_12272__$1;
(statearr_12289_12365[(1)] = (5));

} else {
var statearr_12290_12366 = state_12272__$1;
(statearr_12290_12366[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (15))){
var inst_12154 = (state_12272[(14)]);
var inst_12153 = (state_12272[(15)]);
var inst_12152 = (state_12272[(16)]);
var inst_12151 = (state_12272[(17)]);
var inst_12169 = (state_12272[(2)]);
var inst_12170 = (inst_12154 + (1));
var tmp12284 = inst_12153;
var tmp12285 = inst_12152;
var tmp12286 = inst_12151;
var inst_12151__$1 = tmp12286;
var inst_12152__$1 = tmp12285;
var inst_12153__$1 = tmp12284;
var inst_12154__$1 = inst_12170;
var state_12272__$1 = (function (){var statearr_12291 = state_12272;
(statearr_12291[(14)] = inst_12154__$1);

(statearr_12291[(15)] = inst_12153__$1);

(statearr_12291[(16)] = inst_12152__$1);

(statearr_12291[(18)] = inst_12169);

(statearr_12291[(17)] = inst_12151__$1);

return statearr_12291;
})();
var statearr_12292_12367 = state_12272__$1;
(statearr_12292_12367[(2)] = null);

(statearr_12292_12367[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (21))){
var inst_12196 = (state_12272[(2)]);
var state_12272__$1 = state_12272;
var statearr_12296_12368 = state_12272__$1;
(statearr_12296_12368[(2)] = inst_12196);

(statearr_12296_12368[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (31))){
var inst_12222 = (state_12272[(9)]);
var inst_12226 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_12222);
var state_12272__$1 = state_12272;
var statearr_12297_12369 = state_12272__$1;
(statearr_12297_12369[(2)] = inst_12226);

(statearr_12297_12369[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (32))){
var inst_12216 = (state_12272[(19)]);
var inst_12214 = (state_12272[(20)]);
var inst_12217 = (state_12272[(11)]);
var inst_12215 = (state_12272[(12)]);
var inst_12228 = (state_12272[(2)]);
var inst_12229 = (inst_12217 + (1));
var tmp12293 = inst_12216;
var tmp12294 = inst_12214;
var tmp12295 = inst_12215;
var inst_12214__$1 = tmp12294;
var inst_12215__$1 = tmp12295;
var inst_12216__$1 = tmp12293;
var inst_12217__$1 = inst_12229;
var state_12272__$1 = (function (){var statearr_12298 = state_12272;
(statearr_12298[(19)] = inst_12216__$1);

(statearr_12298[(20)] = inst_12214__$1);

(statearr_12298[(11)] = inst_12217__$1);

(statearr_12298[(12)] = inst_12215__$1);

(statearr_12298[(21)] = inst_12228);

return statearr_12298;
})();
var statearr_12299_12370 = state_12272__$1;
(statearr_12299_12370[(2)] = null);

(statearr_12299_12370[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (40))){
var inst_12241 = (state_12272[(22)]);
var inst_12245 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_12241);
var state_12272__$1 = state_12272;
var statearr_12300_12371 = state_12272__$1;
(statearr_12300_12371[(2)] = inst_12245);

(statearr_12300_12371[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (33))){
var inst_12232 = (state_12272[(23)]);
var inst_12234 = cljs.core.chunked_seq_QMARK_(inst_12232);
var state_12272__$1 = state_12272;
if(inst_12234){
var statearr_12301_12372 = state_12272__$1;
(statearr_12301_12372[(1)] = (36));

} else {
var statearr_12302_12373 = state_12272__$1;
(statearr_12302_12373[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (13))){
var inst_12163 = (state_12272[(24)]);
var inst_12166 = cljs.core.async.close_BANG_(inst_12163);
var state_12272__$1 = state_12272;
var statearr_12303_12374 = state_12272__$1;
(statearr_12303_12374[(2)] = inst_12166);

(statearr_12303_12374[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (22))){
var inst_12186 = (state_12272[(8)]);
var inst_12189 = cljs.core.async.close_BANG_(inst_12186);
var state_12272__$1 = state_12272;
var statearr_12304_12375 = state_12272__$1;
(statearr_12304_12375[(2)] = inst_12189);

(statearr_12304_12375[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (36))){
var inst_12232 = (state_12272[(23)]);
var inst_12236 = cljs.core.chunk_first(inst_12232);
var inst_12237 = cljs.core.chunk_rest(inst_12232);
var inst_12238 = cljs.core.count(inst_12236);
var inst_12214 = inst_12237;
var inst_12215 = inst_12236;
var inst_12216 = inst_12238;
var inst_12217 = (0);
var state_12272__$1 = (function (){var statearr_12305 = state_12272;
(statearr_12305[(19)] = inst_12216);

(statearr_12305[(20)] = inst_12214);

(statearr_12305[(11)] = inst_12217);

(statearr_12305[(12)] = inst_12215);

return statearr_12305;
})();
var statearr_12306_12376 = state_12272__$1;
(statearr_12306_12376[(2)] = null);

(statearr_12306_12376[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (41))){
var inst_12232 = (state_12272[(23)]);
var inst_12247 = (state_12272[(2)]);
var inst_12248 = cljs.core.next(inst_12232);
var inst_12214 = inst_12248;
var inst_12215 = null;
var inst_12216 = (0);
var inst_12217 = (0);
var state_12272__$1 = (function (){var statearr_12307 = state_12272;
(statearr_12307[(19)] = inst_12216);

(statearr_12307[(20)] = inst_12214);

(statearr_12307[(25)] = inst_12247);

(statearr_12307[(11)] = inst_12217);

(statearr_12307[(12)] = inst_12215);

return statearr_12307;
})();
var statearr_12308_12377 = state_12272__$1;
(statearr_12308_12377[(2)] = null);

(statearr_12308_12377[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (43))){
var state_12272__$1 = state_12272;
var statearr_12309_12378 = state_12272__$1;
(statearr_12309_12378[(2)] = null);

(statearr_12309_12378[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (29))){
var inst_12256 = (state_12272[(2)]);
var state_12272__$1 = state_12272;
var statearr_12310_12379 = state_12272__$1;
(statearr_12310_12379[(2)] = inst_12256);

(statearr_12310_12379[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (44))){
var inst_12265 = (state_12272[(2)]);
var state_12272__$1 = (function (){var statearr_12311 = state_12272;
(statearr_12311[(26)] = inst_12265);

return statearr_12311;
})();
var statearr_12312_12380 = state_12272__$1;
(statearr_12312_12380[(2)] = null);

(statearr_12312_12380[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (6))){
var inst_12206 = (state_12272[(27)]);
var inst_12205 = cljs.core.deref(cs);
var inst_12206__$1 = cljs.core.keys(inst_12205);
var inst_12207 = cljs.core.count(inst_12206__$1);
var inst_12208 = cljs.core.reset_BANG_(dctr,inst_12207);
var inst_12213 = cljs.core.seq(inst_12206__$1);
var inst_12214 = inst_12213;
var inst_12215 = null;
var inst_12216 = (0);
var inst_12217 = (0);
var state_12272__$1 = (function (){var statearr_12313 = state_12272;
(statearr_12313[(19)] = inst_12216);

(statearr_12313[(20)] = inst_12214);

(statearr_12313[(28)] = inst_12208);

(statearr_12313[(27)] = inst_12206__$1);

(statearr_12313[(11)] = inst_12217);

(statearr_12313[(12)] = inst_12215);

return statearr_12313;
})();
var statearr_12314_12381 = state_12272__$1;
(statearr_12314_12381[(2)] = null);

(statearr_12314_12381[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (28))){
var inst_12214 = (state_12272[(20)]);
var inst_12232 = (state_12272[(23)]);
var inst_12232__$1 = cljs.core.seq(inst_12214);
var state_12272__$1 = (function (){var statearr_12315 = state_12272;
(statearr_12315[(23)] = inst_12232__$1);

return statearr_12315;
})();
if(inst_12232__$1){
var statearr_12316_12382 = state_12272__$1;
(statearr_12316_12382[(1)] = (33));

} else {
var statearr_12317_12383 = state_12272__$1;
(statearr_12317_12383[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (25))){
var inst_12216 = (state_12272[(19)]);
var inst_12217 = (state_12272[(11)]);
var inst_12219 = (inst_12217 < inst_12216);
var inst_12220 = inst_12219;
var state_12272__$1 = state_12272;
if(cljs.core.truth_(inst_12220)){
var statearr_12318_12384 = state_12272__$1;
(statearr_12318_12384[(1)] = (27));

} else {
var statearr_12319_12385 = state_12272__$1;
(statearr_12319_12385[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (34))){
var state_12272__$1 = state_12272;
var statearr_12320_12386 = state_12272__$1;
(statearr_12320_12386[(2)] = null);

(statearr_12320_12386[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (17))){
var state_12272__$1 = state_12272;
var statearr_12321_12387 = state_12272__$1;
(statearr_12321_12387[(2)] = null);

(statearr_12321_12387[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (3))){
var inst_12270 = (state_12272[(2)]);
var state_12272__$1 = state_12272;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12272__$1,inst_12270);
} else {
if((state_val_12273 === (12))){
var inst_12201 = (state_12272[(2)]);
var state_12272__$1 = state_12272;
var statearr_12322_12388 = state_12272__$1;
(statearr_12322_12388[(2)] = inst_12201);

(statearr_12322_12388[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (2))){
var state_12272__$1 = state_12272;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12272__$1,(4),ch);
} else {
if((state_val_12273 === (23))){
var state_12272__$1 = state_12272;
var statearr_12323_12389 = state_12272__$1;
(statearr_12323_12389[(2)] = null);

(statearr_12323_12389[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (35))){
var inst_12254 = (state_12272[(2)]);
var state_12272__$1 = state_12272;
var statearr_12324_12390 = state_12272__$1;
(statearr_12324_12390[(2)] = inst_12254);

(statearr_12324_12390[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (19))){
var inst_12173 = (state_12272[(7)]);
var inst_12177 = cljs.core.chunk_first(inst_12173);
var inst_12178 = cljs.core.chunk_rest(inst_12173);
var inst_12179 = cljs.core.count(inst_12177);
var inst_12151 = inst_12178;
var inst_12152 = inst_12177;
var inst_12153 = inst_12179;
var inst_12154 = (0);
var state_12272__$1 = (function (){var statearr_12325 = state_12272;
(statearr_12325[(14)] = inst_12154);

(statearr_12325[(15)] = inst_12153);

(statearr_12325[(16)] = inst_12152);

(statearr_12325[(17)] = inst_12151);

return statearr_12325;
})();
var statearr_12326_12391 = state_12272__$1;
(statearr_12326_12391[(2)] = null);

(statearr_12326_12391[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (11))){
var inst_12173 = (state_12272[(7)]);
var inst_12151 = (state_12272[(17)]);
var inst_12173__$1 = cljs.core.seq(inst_12151);
var state_12272__$1 = (function (){var statearr_12327 = state_12272;
(statearr_12327[(7)] = inst_12173__$1);

return statearr_12327;
})();
if(inst_12173__$1){
var statearr_12328_12392 = state_12272__$1;
(statearr_12328_12392[(1)] = (16));

} else {
var statearr_12329_12393 = state_12272__$1;
(statearr_12329_12393[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (9))){
var inst_12203 = (state_12272[(2)]);
var state_12272__$1 = state_12272;
var statearr_12330_12394 = state_12272__$1;
(statearr_12330_12394[(2)] = inst_12203);

(statearr_12330_12394[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (5))){
var inst_12149 = cljs.core.deref(cs);
var inst_12150 = cljs.core.seq(inst_12149);
var inst_12151 = inst_12150;
var inst_12152 = null;
var inst_12153 = (0);
var inst_12154 = (0);
var state_12272__$1 = (function (){var statearr_12331 = state_12272;
(statearr_12331[(14)] = inst_12154);

(statearr_12331[(15)] = inst_12153);

(statearr_12331[(16)] = inst_12152);

(statearr_12331[(17)] = inst_12151);

return statearr_12331;
})();
var statearr_12332_12395 = state_12272__$1;
(statearr_12332_12395[(2)] = null);

(statearr_12332_12395[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (14))){
var state_12272__$1 = state_12272;
var statearr_12333_12396 = state_12272__$1;
(statearr_12333_12396[(2)] = null);

(statearr_12333_12396[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (45))){
var inst_12262 = (state_12272[(2)]);
var state_12272__$1 = state_12272;
var statearr_12334_12397 = state_12272__$1;
(statearr_12334_12397[(2)] = inst_12262);

(statearr_12334_12397[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (26))){
var inst_12206 = (state_12272[(27)]);
var inst_12258 = (state_12272[(2)]);
var inst_12259 = cljs.core.seq(inst_12206);
var state_12272__$1 = (function (){var statearr_12335 = state_12272;
(statearr_12335[(29)] = inst_12258);

return statearr_12335;
})();
if(inst_12259){
var statearr_12336_12398 = state_12272__$1;
(statearr_12336_12398[(1)] = (42));

} else {
var statearr_12337_12399 = state_12272__$1;
(statearr_12337_12399[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (16))){
var inst_12173 = (state_12272[(7)]);
var inst_12175 = cljs.core.chunked_seq_QMARK_(inst_12173);
var state_12272__$1 = state_12272;
if(inst_12175){
var statearr_12338_12400 = state_12272__$1;
(statearr_12338_12400[(1)] = (19));

} else {
var statearr_12339_12401 = state_12272__$1;
(statearr_12339_12401[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (38))){
var inst_12251 = (state_12272[(2)]);
var state_12272__$1 = state_12272;
var statearr_12340_12402 = state_12272__$1;
(statearr_12340_12402[(2)] = inst_12251);

(statearr_12340_12402[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (30))){
var state_12272__$1 = state_12272;
var statearr_12341_12403 = state_12272__$1;
(statearr_12341_12403[(2)] = null);

(statearr_12341_12403[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (10))){
var inst_12154 = (state_12272[(14)]);
var inst_12152 = (state_12272[(16)]);
var inst_12162 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_12152,inst_12154);
var inst_12163 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12162,(0),null);
var inst_12164 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12162,(1),null);
var state_12272__$1 = (function (){var statearr_12342 = state_12272;
(statearr_12342[(24)] = inst_12163);

return statearr_12342;
})();
if(cljs.core.truth_(inst_12164)){
var statearr_12343_12404 = state_12272__$1;
(statearr_12343_12404[(1)] = (13));

} else {
var statearr_12344_12405 = state_12272__$1;
(statearr_12344_12405[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (18))){
var inst_12199 = (state_12272[(2)]);
var state_12272__$1 = state_12272;
var statearr_12345_12406 = state_12272__$1;
(statearr_12345_12406[(2)] = inst_12199);

(statearr_12345_12406[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (42))){
var state_12272__$1 = state_12272;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12272__$1,(45),dchan);
} else {
if((state_val_12273 === (37))){
var inst_12142 = (state_12272[(10)]);
var inst_12241 = (state_12272[(22)]);
var inst_12232 = (state_12272[(23)]);
var inst_12241__$1 = cljs.core.first(inst_12232);
var inst_12242 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_12241__$1,inst_12142,done);
var state_12272__$1 = (function (){var statearr_12346 = state_12272;
(statearr_12346[(22)] = inst_12241__$1);

return statearr_12346;
})();
if(cljs.core.truth_(inst_12242)){
var statearr_12347_12407 = state_12272__$1;
(statearr_12347_12407[(1)] = (39));

} else {
var statearr_12348_12408 = state_12272__$1;
(statearr_12348_12408[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12273 === (8))){
var inst_12154 = (state_12272[(14)]);
var inst_12153 = (state_12272[(15)]);
var inst_12156 = (inst_12154 < inst_12153);
var inst_12157 = inst_12156;
var state_12272__$1 = state_12272;
if(cljs.core.truth_(inst_12157)){
var statearr_12349_12409 = state_12272__$1;
(statearr_12349_12409[(1)] = (10));

} else {
var statearr_12350_12410 = state_12272__$1;
(statearr_12350_12410[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__11438__auto__ = null;
var cljs$core$async$mult_$_state_machine__11438__auto____0 = (function (){
var statearr_12351 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12351[(0)] = cljs$core$async$mult_$_state_machine__11438__auto__);

(statearr_12351[(1)] = (1));

return statearr_12351;
});
var cljs$core$async$mult_$_state_machine__11438__auto____1 = (function (state_12272){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_12272);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e12352){var ex__11441__auto__ = e12352;
var statearr_12353_12411 = state_12272;
(statearr_12353_12411[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_12272[(4)]))){
var statearr_12354_12412 = state_12272;
(statearr_12354_12412[(1)] = cljs.core.first((state_12272[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12413 = state_12272;
state_12272 = G__12413;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11438__auto__ = function(state_12272){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11438__auto____1.call(this,state_12272);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11438__auto____0;
cljs$core$async$mult_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11438__auto____1;
return cljs$core$async$mult_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_12355 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_12355[(6)] = c__11512__auto___12356);

return statearr_12355;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__12415 = arguments.length;
switch (G__12415) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_12417 = (function (m,ch){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5393__auto__.call(null,m,ch));
} else {
var m__5391__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5391__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_12417(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_12418 = (function (m,ch){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5393__auto__.call(null,m,ch));
} else {
var m__5391__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5391__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_12418(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_12419 = (function (m){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5393__auto__.call(null,m));
} else {
var m__5391__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5391__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_12419(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_12420 = (function (m,state_map){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5393__auto__.call(null,m,state_map));
} else {
var m__5391__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5391__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_12420(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_12421 = (function (m,mode){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5393__auto__.call(null,m,mode));
} else {
var m__5391__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5391__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_12421(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___12431 = arguments.length;
var i__5769__auto___12432 = (0);
while(true){
if((i__5769__auto___12432 < len__5768__auto___12431)){
args__5774__auto__.push((arguments[i__5769__auto___12432]));

var G__12433 = (i__5769__auto___12432 + (1));
i__5769__auto___12432 = G__12433;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((3) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5775__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__12426){
var map__12427 = p__12426;
var map__12427__$1 = cljs.core.__destructure_map(map__12427);
var opts = map__12427__$1;
var statearr_12428_12434 = state;
(statearr_12428_12434[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_12429_12435 = state;
(statearr_12429_12435[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_12430_12436 = state;
(statearr_12430_12436[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq12422){
var G__12423 = cljs.core.first(seq12422);
var seq12422__$1 = cljs.core.next(seq12422);
var G__12424 = cljs.core.first(seq12422__$1);
var seq12422__$2 = cljs.core.next(seq12422__$1);
var G__12425 = cljs.core.first(seq12422__$2);
var seq12422__$3 = cljs.core.next(seq12422__$2);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12423,G__12424,G__12425,seq12422__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12437 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12437 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12438){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12438 = meta12438;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12437.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12439,meta12438__$1){
var self__ = this;
var _12439__$1 = this;
return (new cljs.core.async.t_cljs$core$async12437(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12438__$1));
}));

(cljs.core.async.t_cljs$core$async12437.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12439){
var self__ = this;
var _12439__$1 = this;
return self__.meta12438;
}));

(cljs.core.async.t_cljs$core$async12437.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12437.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async12437.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12437.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12437.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12437.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12437.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12437.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12437.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta12438","meta12438",266513858,null)], null);
}));

(cljs.core.async.t_cljs$core$async12437.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12437.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12437");

(cljs.core.async.t_cljs$core$async12437.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async12437");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12437.
 */
cljs.core.async.__GT_t_cljs$core$async12437 = (function cljs$core$async$mix_$___GT_t_cljs$core$async12437(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12438){
return (new cljs.core.async.t_cljs$core$async12437(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12438));
});

}

return (new cljs.core.async.t_cljs$core$async12437(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11512__auto___12552 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_12507){
var state_val_12508 = (state_12507[(1)]);
if((state_val_12508 === (7))){
var inst_12467 = (state_12507[(2)]);
var state_12507__$1 = state_12507;
if(cljs.core.truth_(inst_12467)){
var statearr_12509_12553 = state_12507__$1;
(statearr_12509_12553[(1)] = (8));

} else {
var statearr_12510_12554 = state_12507__$1;
(statearr_12510_12554[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (20))){
var inst_12460 = (state_12507[(7)]);
var state_12507__$1 = state_12507;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12507__$1,(23),out,inst_12460);
} else {
if((state_val_12508 === (1))){
var inst_12443 = calc_state();
var inst_12444 = cljs.core.__destructure_map(inst_12443);
var inst_12445 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12444,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12446 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12444,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12447 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12444,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12448 = inst_12443;
var state_12507__$1 = (function (){var statearr_12511 = state_12507;
(statearr_12511[(8)] = inst_12447);

(statearr_12511[(9)] = inst_12445);

(statearr_12511[(10)] = inst_12446);

(statearr_12511[(11)] = inst_12448);

return statearr_12511;
})();
var statearr_12512_12555 = state_12507__$1;
(statearr_12512_12555[(2)] = null);

(statearr_12512_12555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (24))){
var inst_12451 = (state_12507[(12)]);
var inst_12448 = inst_12451;
var state_12507__$1 = (function (){var statearr_12513 = state_12507;
(statearr_12513[(11)] = inst_12448);

return statearr_12513;
})();
var statearr_12514_12556 = state_12507__$1;
(statearr_12514_12556[(2)] = null);

(statearr_12514_12556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (4))){
var inst_12460 = (state_12507[(7)]);
var inst_12462 = (state_12507[(13)]);
var inst_12459 = (state_12507[(2)]);
var inst_12460__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12459,(0),null);
var inst_12461 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12459,(1),null);
var inst_12462__$1 = (inst_12460__$1 == null);
var state_12507__$1 = (function (){var statearr_12515 = state_12507;
(statearr_12515[(7)] = inst_12460__$1);

(statearr_12515[(14)] = inst_12461);

(statearr_12515[(13)] = inst_12462__$1);

return statearr_12515;
})();
if(cljs.core.truth_(inst_12462__$1)){
var statearr_12516_12557 = state_12507__$1;
(statearr_12516_12557[(1)] = (5));

} else {
var statearr_12517_12558 = state_12507__$1;
(statearr_12517_12558[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (15))){
var inst_12481 = (state_12507[(15)]);
var inst_12452 = (state_12507[(16)]);
var inst_12481__$1 = cljs.core.empty_QMARK_(inst_12452);
var state_12507__$1 = (function (){var statearr_12518 = state_12507;
(statearr_12518[(15)] = inst_12481__$1);

return statearr_12518;
})();
if(inst_12481__$1){
var statearr_12519_12559 = state_12507__$1;
(statearr_12519_12559[(1)] = (17));

} else {
var statearr_12520_12560 = state_12507__$1;
(statearr_12520_12560[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (21))){
var inst_12451 = (state_12507[(12)]);
var inst_12448 = inst_12451;
var state_12507__$1 = (function (){var statearr_12521 = state_12507;
(statearr_12521[(11)] = inst_12448);

return statearr_12521;
})();
var statearr_12522_12561 = state_12507__$1;
(statearr_12522_12561[(2)] = null);

(statearr_12522_12561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (13))){
var inst_12474 = (state_12507[(2)]);
var inst_12475 = calc_state();
var inst_12448 = inst_12475;
var state_12507__$1 = (function (){var statearr_12523 = state_12507;
(statearr_12523[(17)] = inst_12474);

(statearr_12523[(11)] = inst_12448);

return statearr_12523;
})();
var statearr_12524_12562 = state_12507__$1;
(statearr_12524_12562[(2)] = null);

(statearr_12524_12562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (22))){
var inst_12501 = (state_12507[(2)]);
var state_12507__$1 = state_12507;
var statearr_12525_12563 = state_12507__$1;
(statearr_12525_12563[(2)] = inst_12501);

(statearr_12525_12563[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (6))){
var inst_12461 = (state_12507[(14)]);
var inst_12465 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_12461,change);
var state_12507__$1 = state_12507;
var statearr_12526_12564 = state_12507__$1;
(statearr_12526_12564[(2)] = inst_12465);

(statearr_12526_12564[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (25))){
var state_12507__$1 = state_12507;
var statearr_12527_12565 = state_12507__$1;
(statearr_12527_12565[(2)] = null);

(statearr_12527_12565[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (17))){
var inst_12461 = (state_12507[(14)]);
var inst_12453 = (state_12507[(18)]);
var inst_12483 = (inst_12453.cljs$core$IFn$_invoke$arity$1 ? inst_12453.cljs$core$IFn$_invoke$arity$1(inst_12461) : inst_12453.call(null,inst_12461));
var inst_12484 = cljs.core.not(inst_12483);
var state_12507__$1 = state_12507;
var statearr_12528_12566 = state_12507__$1;
(statearr_12528_12566[(2)] = inst_12484);

(statearr_12528_12566[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (3))){
var inst_12505 = (state_12507[(2)]);
var state_12507__$1 = state_12507;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12507__$1,inst_12505);
} else {
if((state_val_12508 === (12))){
var state_12507__$1 = state_12507;
var statearr_12529_12567 = state_12507__$1;
(statearr_12529_12567[(2)] = null);

(statearr_12529_12567[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (2))){
var inst_12451 = (state_12507[(12)]);
var inst_12448 = (state_12507[(11)]);
var inst_12451__$1 = cljs.core.__destructure_map(inst_12448);
var inst_12452 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12451__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12453 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12451__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12454 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12451__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12507__$1 = (function (){var statearr_12530 = state_12507;
(statearr_12530[(12)] = inst_12451__$1);

(statearr_12530[(18)] = inst_12453);

(statearr_12530[(16)] = inst_12452);

return statearr_12530;
})();
return cljs.core.async.ioc_alts_BANG_(state_12507__$1,(4),inst_12454);
} else {
if((state_val_12508 === (23))){
var inst_12492 = (state_12507[(2)]);
var state_12507__$1 = state_12507;
if(cljs.core.truth_(inst_12492)){
var statearr_12531_12568 = state_12507__$1;
(statearr_12531_12568[(1)] = (24));

} else {
var statearr_12532_12569 = state_12507__$1;
(statearr_12532_12569[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (19))){
var inst_12487 = (state_12507[(2)]);
var state_12507__$1 = state_12507;
var statearr_12533_12570 = state_12507__$1;
(statearr_12533_12570[(2)] = inst_12487);

(statearr_12533_12570[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (11))){
var inst_12461 = (state_12507[(14)]);
var inst_12471 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_12461);
var state_12507__$1 = state_12507;
var statearr_12534_12571 = state_12507__$1;
(statearr_12534_12571[(2)] = inst_12471);

(statearr_12534_12571[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (9))){
var inst_12461 = (state_12507[(14)]);
var inst_12478 = (state_12507[(19)]);
var inst_12452 = (state_12507[(16)]);
var inst_12478__$1 = (inst_12452.cljs$core$IFn$_invoke$arity$1 ? inst_12452.cljs$core$IFn$_invoke$arity$1(inst_12461) : inst_12452.call(null,inst_12461));
var state_12507__$1 = (function (){var statearr_12535 = state_12507;
(statearr_12535[(19)] = inst_12478__$1);

return statearr_12535;
})();
if(cljs.core.truth_(inst_12478__$1)){
var statearr_12536_12572 = state_12507__$1;
(statearr_12536_12572[(1)] = (14));

} else {
var statearr_12537_12573 = state_12507__$1;
(statearr_12537_12573[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (5))){
var inst_12462 = (state_12507[(13)]);
var state_12507__$1 = state_12507;
var statearr_12538_12574 = state_12507__$1;
(statearr_12538_12574[(2)] = inst_12462);

(statearr_12538_12574[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (14))){
var inst_12478 = (state_12507[(19)]);
var state_12507__$1 = state_12507;
var statearr_12539_12575 = state_12507__$1;
(statearr_12539_12575[(2)] = inst_12478);

(statearr_12539_12575[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (26))){
var inst_12497 = (state_12507[(2)]);
var state_12507__$1 = state_12507;
var statearr_12540_12576 = state_12507__$1;
(statearr_12540_12576[(2)] = inst_12497);

(statearr_12540_12576[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (16))){
var inst_12489 = (state_12507[(2)]);
var state_12507__$1 = state_12507;
if(cljs.core.truth_(inst_12489)){
var statearr_12541_12577 = state_12507__$1;
(statearr_12541_12577[(1)] = (20));

} else {
var statearr_12542_12578 = state_12507__$1;
(statearr_12542_12578[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (10))){
var inst_12503 = (state_12507[(2)]);
var state_12507__$1 = state_12507;
var statearr_12543_12579 = state_12507__$1;
(statearr_12543_12579[(2)] = inst_12503);

(statearr_12543_12579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (18))){
var inst_12481 = (state_12507[(15)]);
var state_12507__$1 = state_12507;
var statearr_12544_12580 = state_12507__$1;
(statearr_12544_12580[(2)] = inst_12481);

(statearr_12544_12580[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12508 === (8))){
var inst_12460 = (state_12507[(7)]);
var inst_12469 = (inst_12460 == null);
var state_12507__$1 = state_12507;
if(cljs.core.truth_(inst_12469)){
var statearr_12545_12581 = state_12507__$1;
(statearr_12545_12581[(1)] = (11));

} else {
var statearr_12546_12582 = state_12507__$1;
(statearr_12546_12582[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__11438__auto__ = null;
var cljs$core$async$mix_$_state_machine__11438__auto____0 = (function (){
var statearr_12547 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12547[(0)] = cljs$core$async$mix_$_state_machine__11438__auto__);

(statearr_12547[(1)] = (1));

return statearr_12547;
});
var cljs$core$async$mix_$_state_machine__11438__auto____1 = (function (state_12507){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_12507);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e12548){var ex__11441__auto__ = e12548;
var statearr_12549_12583 = state_12507;
(statearr_12549_12583[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_12507[(4)]))){
var statearr_12550_12584 = state_12507;
(statearr_12550_12584[(1)] = cljs.core.first((state_12507[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12585 = state_12507;
state_12507 = G__12585;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11438__auto__ = function(state_12507){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11438__auto____1.call(this,state_12507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11438__auto____0;
cljs$core$async$mix_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11438__auto____1;
return cljs$core$async$mix_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_12551 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_12551[(6)] = c__11512__auto___12552);

return statearr_12551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_12588 = (function (p,v,ch,close_QMARK_){
var x__5392__auto__ = (((p == null))?null:p);
var m__5393__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5393__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5391__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5391__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_12588(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_12589 = (function (p,v,ch){
var x__5392__auto__ = (((p == null))?null:p);
var m__5393__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5393__auto__.call(null,p,v,ch));
} else {
var m__5391__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5391__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_12589(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_12590 = (function() {
var G__12591 = null;
var G__12591__1 = (function (p){
var x__5392__auto__ = (((p == null))?null:p);
var m__5393__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5393__auto__.call(null,p));
} else {
var m__5391__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5391__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__12591__2 = (function (p,v){
var x__5392__auto__ = (((p == null))?null:p);
var m__5393__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5393__auto__.call(null,p,v));
} else {
var m__5391__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5391__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__12591 = function(p,v){
switch(arguments.length){
case 1:
return G__12591__1.call(this,p);
case 2:
return G__12591__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12591.cljs$core$IFn$_invoke$arity$1 = G__12591__1;
G__12591.cljs$core$IFn$_invoke$arity$2 = G__12591__2;
return G__12591;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__12587 = arguments.length;
switch (G__12587) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12590.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12590.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__12595 = arguments.length;
switch (G__12595) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__12593_SHARP_){
if(cljs.core.truth_((p1__12593_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__12593_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__12593_SHARP_.call(null,topic)))){
return p1__12593_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__12593_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12596 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12596 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12597){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12597 = meta12597;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12596.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12598,meta12597__$1){
var self__ = this;
var _12598__$1 = this;
return (new cljs.core.async.t_cljs$core$async12596(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12597__$1));
}));

(cljs.core.async.t_cljs$core$async12596.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12598){
var self__ = this;
var _12598__$1 = this;
return self__.meta12597;
}));

(cljs.core.async.t_cljs$core$async12596.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12596.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async12596.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12596.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async12596.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async12596.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async12596.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async12596.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12597","meta12597",722004719,null)], null);
}));

(cljs.core.async.t_cljs$core$async12596.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12596.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12596");

(cljs.core.async.t_cljs$core$async12596.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async12596");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12596.
 */
cljs.core.async.__GT_t_cljs$core$async12596 = (function cljs$core$async$__GT_t_cljs$core$async12596(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12597){
return (new cljs.core.async.t_cljs$core$async12596(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12597));
});

}

return (new cljs.core.async.t_cljs$core$async12596(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11512__auto___12717 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_12670){
var state_val_12671 = (state_12670[(1)]);
if((state_val_12671 === (7))){
var inst_12666 = (state_12670[(2)]);
var state_12670__$1 = state_12670;
var statearr_12672_12718 = state_12670__$1;
(statearr_12672_12718[(2)] = inst_12666);

(statearr_12672_12718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (20))){
var state_12670__$1 = state_12670;
var statearr_12673_12719 = state_12670__$1;
(statearr_12673_12719[(2)] = null);

(statearr_12673_12719[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (1))){
var state_12670__$1 = state_12670;
var statearr_12674_12720 = state_12670__$1;
(statearr_12674_12720[(2)] = null);

(statearr_12674_12720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (24))){
var inst_12649 = (state_12670[(7)]);
var inst_12658 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_12649);
var state_12670__$1 = state_12670;
var statearr_12675_12721 = state_12670__$1;
(statearr_12675_12721[(2)] = inst_12658);

(statearr_12675_12721[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (4))){
var inst_12601 = (state_12670[(8)]);
var inst_12601__$1 = (state_12670[(2)]);
var inst_12602 = (inst_12601__$1 == null);
var state_12670__$1 = (function (){var statearr_12676 = state_12670;
(statearr_12676[(8)] = inst_12601__$1);

return statearr_12676;
})();
if(cljs.core.truth_(inst_12602)){
var statearr_12677_12722 = state_12670__$1;
(statearr_12677_12722[(1)] = (5));

} else {
var statearr_12678_12723 = state_12670__$1;
(statearr_12678_12723[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (15))){
var inst_12643 = (state_12670[(2)]);
var state_12670__$1 = state_12670;
var statearr_12679_12724 = state_12670__$1;
(statearr_12679_12724[(2)] = inst_12643);

(statearr_12679_12724[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (21))){
var inst_12663 = (state_12670[(2)]);
var state_12670__$1 = (function (){var statearr_12680 = state_12670;
(statearr_12680[(9)] = inst_12663);

return statearr_12680;
})();
var statearr_12681_12725 = state_12670__$1;
(statearr_12681_12725[(2)] = null);

(statearr_12681_12725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (13))){
var inst_12625 = (state_12670[(10)]);
var inst_12627 = cljs.core.chunked_seq_QMARK_(inst_12625);
var state_12670__$1 = state_12670;
if(inst_12627){
var statearr_12682_12726 = state_12670__$1;
(statearr_12682_12726[(1)] = (16));

} else {
var statearr_12683_12727 = state_12670__$1;
(statearr_12683_12727[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (22))){
var inst_12655 = (state_12670[(2)]);
var state_12670__$1 = state_12670;
if(cljs.core.truth_(inst_12655)){
var statearr_12684_12728 = state_12670__$1;
(statearr_12684_12728[(1)] = (23));

} else {
var statearr_12685_12729 = state_12670__$1;
(statearr_12685_12729[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (6))){
var inst_12601 = (state_12670[(8)]);
var inst_12649 = (state_12670[(7)]);
var inst_12651 = (state_12670[(11)]);
var inst_12649__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_12601) : topic_fn.call(null,inst_12601));
var inst_12650 = cljs.core.deref(mults);
var inst_12651__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12650,inst_12649__$1);
var state_12670__$1 = (function (){var statearr_12686 = state_12670;
(statearr_12686[(7)] = inst_12649__$1);

(statearr_12686[(11)] = inst_12651__$1);

return statearr_12686;
})();
if(cljs.core.truth_(inst_12651__$1)){
var statearr_12687_12730 = state_12670__$1;
(statearr_12687_12730[(1)] = (19));

} else {
var statearr_12688_12731 = state_12670__$1;
(statearr_12688_12731[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (25))){
var inst_12660 = (state_12670[(2)]);
var state_12670__$1 = state_12670;
var statearr_12689_12732 = state_12670__$1;
(statearr_12689_12732[(2)] = inst_12660);

(statearr_12689_12732[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (17))){
var inst_12625 = (state_12670[(10)]);
var inst_12634 = cljs.core.first(inst_12625);
var inst_12635 = cljs.core.async.muxch_STAR_(inst_12634);
var inst_12636 = cljs.core.async.close_BANG_(inst_12635);
var inst_12637 = cljs.core.next(inst_12625);
var inst_12611 = inst_12637;
var inst_12612 = null;
var inst_12613 = (0);
var inst_12614 = (0);
var state_12670__$1 = (function (){var statearr_12690 = state_12670;
(statearr_12690[(12)] = inst_12613);

(statearr_12690[(13)] = inst_12614);

(statearr_12690[(14)] = inst_12636);

(statearr_12690[(15)] = inst_12611);

(statearr_12690[(16)] = inst_12612);

return statearr_12690;
})();
var statearr_12691_12733 = state_12670__$1;
(statearr_12691_12733[(2)] = null);

(statearr_12691_12733[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (3))){
var inst_12668 = (state_12670[(2)]);
var state_12670__$1 = state_12670;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12670__$1,inst_12668);
} else {
if((state_val_12671 === (12))){
var inst_12645 = (state_12670[(2)]);
var state_12670__$1 = state_12670;
var statearr_12692_12734 = state_12670__$1;
(statearr_12692_12734[(2)] = inst_12645);

(statearr_12692_12734[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (2))){
var state_12670__$1 = state_12670;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12670__$1,(4),ch);
} else {
if((state_val_12671 === (23))){
var state_12670__$1 = state_12670;
var statearr_12693_12735 = state_12670__$1;
(statearr_12693_12735[(2)] = null);

(statearr_12693_12735[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (19))){
var inst_12601 = (state_12670[(8)]);
var inst_12651 = (state_12670[(11)]);
var inst_12653 = cljs.core.async.muxch_STAR_(inst_12651);
var state_12670__$1 = state_12670;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12670__$1,(22),inst_12653,inst_12601);
} else {
if((state_val_12671 === (11))){
var inst_12611 = (state_12670[(15)]);
var inst_12625 = (state_12670[(10)]);
var inst_12625__$1 = cljs.core.seq(inst_12611);
var state_12670__$1 = (function (){var statearr_12694 = state_12670;
(statearr_12694[(10)] = inst_12625__$1);

return statearr_12694;
})();
if(inst_12625__$1){
var statearr_12695_12736 = state_12670__$1;
(statearr_12695_12736[(1)] = (13));

} else {
var statearr_12696_12737 = state_12670__$1;
(statearr_12696_12737[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (9))){
var inst_12647 = (state_12670[(2)]);
var state_12670__$1 = state_12670;
var statearr_12697_12738 = state_12670__$1;
(statearr_12697_12738[(2)] = inst_12647);

(statearr_12697_12738[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (5))){
var inst_12608 = cljs.core.deref(mults);
var inst_12609 = cljs.core.vals(inst_12608);
var inst_12610 = cljs.core.seq(inst_12609);
var inst_12611 = inst_12610;
var inst_12612 = null;
var inst_12613 = (0);
var inst_12614 = (0);
var state_12670__$1 = (function (){var statearr_12698 = state_12670;
(statearr_12698[(12)] = inst_12613);

(statearr_12698[(13)] = inst_12614);

(statearr_12698[(15)] = inst_12611);

(statearr_12698[(16)] = inst_12612);

return statearr_12698;
})();
var statearr_12699_12739 = state_12670__$1;
(statearr_12699_12739[(2)] = null);

(statearr_12699_12739[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (14))){
var state_12670__$1 = state_12670;
var statearr_12703_12740 = state_12670__$1;
(statearr_12703_12740[(2)] = null);

(statearr_12703_12740[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (16))){
var inst_12625 = (state_12670[(10)]);
var inst_12629 = cljs.core.chunk_first(inst_12625);
var inst_12630 = cljs.core.chunk_rest(inst_12625);
var inst_12631 = cljs.core.count(inst_12629);
var inst_12611 = inst_12630;
var inst_12612 = inst_12629;
var inst_12613 = inst_12631;
var inst_12614 = (0);
var state_12670__$1 = (function (){var statearr_12704 = state_12670;
(statearr_12704[(12)] = inst_12613);

(statearr_12704[(13)] = inst_12614);

(statearr_12704[(15)] = inst_12611);

(statearr_12704[(16)] = inst_12612);

return statearr_12704;
})();
var statearr_12705_12741 = state_12670__$1;
(statearr_12705_12741[(2)] = null);

(statearr_12705_12741[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (10))){
var inst_12613 = (state_12670[(12)]);
var inst_12614 = (state_12670[(13)]);
var inst_12611 = (state_12670[(15)]);
var inst_12612 = (state_12670[(16)]);
var inst_12619 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_12612,inst_12614);
var inst_12620 = cljs.core.async.muxch_STAR_(inst_12619);
var inst_12621 = cljs.core.async.close_BANG_(inst_12620);
var inst_12622 = (inst_12614 + (1));
var tmp12700 = inst_12613;
var tmp12701 = inst_12611;
var tmp12702 = inst_12612;
var inst_12611__$1 = tmp12701;
var inst_12612__$1 = tmp12702;
var inst_12613__$1 = tmp12700;
var inst_12614__$1 = inst_12622;
var state_12670__$1 = (function (){var statearr_12706 = state_12670;
(statearr_12706[(12)] = inst_12613__$1);

(statearr_12706[(13)] = inst_12614__$1);

(statearr_12706[(17)] = inst_12621);

(statearr_12706[(15)] = inst_12611__$1);

(statearr_12706[(16)] = inst_12612__$1);

return statearr_12706;
})();
var statearr_12707_12742 = state_12670__$1;
(statearr_12707_12742[(2)] = null);

(statearr_12707_12742[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (18))){
var inst_12640 = (state_12670[(2)]);
var state_12670__$1 = state_12670;
var statearr_12708_12743 = state_12670__$1;
(statearr_12708_12743[(2)] = inst_12640);

(statearr_12708_12743[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (8))){
var inst_12613 = (state_12670[(12)]);
var inst_12614 = (state_12670[(13)]);
var inst_12616 = (inst_12614 < inst_12613);
var inst_12617 = inst_12616;
var state_12670__$1 = state_12670;
if(cljs.core.truth_(inst_12617)){
var statearr_12709_12744 = state_12670__$1;
(statearr_12709_12744[(1)] = (10));

} else {
var statearr_12710_12745 = state_12670__$1;
(statearr_12710_12745[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11438__auto__ = null;
var cljs$core$async$state_machine__11438__auto____0 = (function (){
var statearr_12711 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12711[(0)] = cljs$core$async$state_machine__11438__auto__);

(statearr_12711[(1)] = (1));

return statearr_12711;
});
var cljs$core$async$state_machine__11438__auto____1 = (function (state_12670){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_12670);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e12712){var ex__11441__auto__ = e12712;
var statearr_12713_12746 = state_12670;
(statearr_12713_12746[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_12670[(4)]))){
var statearr_12714_12747 = state_12670;
(statearr_12714_12747[(1)] = cljs.core.first((state_12670[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12748 = state_12670;
state_12670 = G__12748;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$state_machine__11438__auto__ = function(state_12670){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11438__auto____1.call(this,state_12670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11438__auto____0;
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11438__auto____1;
return cljs$core$async$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_12715 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_12715[(6)] = c__11512__auto___12717);

return statearr_12715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__12750 = arguments.length;
switch (G__12750) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__12753 = arguments.length;
switch (G__12753) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__12756 = arguments.length;
switch (G__12756) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__11512__auto___12834 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_12799){
var state_val_12800 = (state_12799[(1)]);
if((state_val_12800 === (7))){
var state_12799__$1 = state_12799;
var statearr_12801_12835 = state_12799__$1;
(statearr_12801_12835[(2)] = null);

(statearr_12801_12835[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12800 === (1))){
var state_12799__$1 = state_12799;
var statearr_12802_12836 = state_12799__$1;
(statearr_12802_12836[(2)] = null);

(statearr_12802_12836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12800 === (4))){
var inst_12760 = (state_12799[(7)]);
var inst_12759 = (state_12799[(8)]);
var inst_12762 = (inst_12760 < inst_12759);
var state_12799__$1 = state_12799;
if(cljs.core.truth_(inst_12762)){
var statearr_12803_12837 = state_12799__$1;
(statearr_12803_12837[(1)] = (6));

} else {
var statearr_12804_12838 = state_12799__$1;
(statearr_12804_12838[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12800 === (15))){
var inst_12785 = (state_12799[(9)]);
var inst_12790 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_12785);
var state_12799__$1 = state_12799;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12799__$1,(17),out,inst_12790);
} else {
if((state_val_12800 === (13))){
var inst_12785 = (state_12799[(9)]);
var inst_12785__$1 = (state_12799[(2)]);
var inst_12786 = cljs.core.some(cljs.core.nil_QMARK_,inst_12785__$1);
var state_12799__$1 = (function (){var statearr_12805 = state_12799;
(statearr_12805[(9)] = inst_12785__$1);

return statearr_12805;
})();
if(cljs.core.truth_(inst_12786)){
var statearr_12806_12839 = state_12799__$1;
(statearr_12806_12839[(1)] = (14));

} else {
var statearr_12807_12840 = state_12799__$1;
(statearr_12807_12840[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12800 === (6))){
var state_12799__$1 = state_12799;
var statearr_12808_12841 = state_12799__$1;
(statearr_12808_12841[(2)] = null);

(statearr_12808_12841[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12800 === (17))){
var inst_12792 = (state_12799[(2)]);
var state_12799__$1 = (function (){var statearr_12810 = state_12799;
(statearr_12810[(10)] = inst_12792);

return statearr_12810;
})();
var statearr_12811_12842 = state_12799__$1;
(statearr_12811_12842[(2)] = null);

(statearr_12811_12842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12800 === (3))){
var inst_12797 = (state_12799[(2)]);
var state_12799__$1 = state_12799;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12799__$1,inst_12797);
} else {
if((state_val_12800 === (12))){
var _ = (function (){var statearr_12812 = state_12799;
(statearr_12812[(4)] = cljs.core.rest((state_12799[(4)])));

return statearr_12812;
})();
var state_12799__$1 = state_12799;
var ex12809 = (state_12799__$1[(2)]);
var statearr_12813_12843 = state_12799__$1;
(statearr_12813_12843[(5)] = ex12809);


if((ex12809 instanceof Object)){
var statearr_12814_12844 = state_12799__$1;
(statearr_12814_12844[(1)] = (11));

(statearr_12814_12844[(5)] = null);

} else {
throw ex12809;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12800 === (2))){
var inst_12758 = cljs.core.reset_BANG_(dctr,cnt);
var inst_12759 = cnt;
var inst_12760 = (0);
var state_12799__$1 = (function (){var statearr_12815 = state_12799;
(statearr_12815[(11)] = inst_12758);

(statearr_12815[(7)] = inst_12760);

(statearr_12815[(8)] = inst_12759);

return statearr_12815;
})();
var statearr_12816_12845 = state_12799__$1;
(statearr_12816_12845[(2)] = null);

(statearr_12816_12845[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12800 === (11))){
var inst_12764 = (state_12799[(2)]);
var inst_12765 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_12799__$1 = (function (){var statearr_12817 = state_12799;
(statearr_12817[(12)] = inst_12764);

return statearr_12817;
})();
var statearr_12818_12846 = state_12799__$1;
(statearr_12818_12846[(2)] = inst_12765);

(statearr_12818_12846[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12800 === (9))){
var inst_12760 = (state_12799[(7)]);
var _ = (function (){var statearr_12819 = state_12799;
(statearr_12819[(4)] = cljs.core.cons((12),(state_12799[(4)])));

return statearr_12819;
})();
var inst_12771 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_12760) : chs__$1.call(null,inst_12760));
var inst_12772 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_12760) : done.call(null,inst_12760));
var inst_12773 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_12771,inst_12772);
var ___$1 = (function (){var statearr_12820 = state_12799;
(statearr_12820[(4)] = cljs.core.rest((state_12799[(4)])));

return statearr_12820;
})();
var state_12799__$1 = state_12799;
var statearr_12821_12847 = state_12799__$1;
(statearr_12821_12847[(2)] = inst_12773);

(statearr_12821_12847[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12800 === (5))){
var inst_12783 = (state_12799[(2)]);
var state_12799__$1 = (function (){var statearr_12822 = state_12799;
(statearr_12822[(13)] = inst_12783);

return statearr_12822;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12799__$1,(13),dchan);
} else {
if((state_val_12800 === (14))){
var inst_12788 = cljs.core.async.close_BANG_(out);
var state_12799__$1 = state_12799;
var statearr_12823_12848 = state_12799__$1;
(statearr_12823_12848[(2)] = inst_12788);

(statearr_12823_12848[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12800 === (16))){
var inst_12795 = (state_12799[(2)]);
var state_12799__$1 = state_12799;
var statearr_12824_12849 = state_12799__$1;
(statearr_12824_12849[(2)] = inst_12795);

(statearr_12824_12849[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12800 === (10))){
var inst_12760 = (state_12799[(7)]);
var inst_12776 = (state_12799[(2)]);
var inst_12777 = (inst_12760 + (1));
var inst_12760__$1 = inst_12777;
var state_12799__$1 = (function (){var statearr_12825 = state_12799;
(statearr_12825[(14)] = inst_12776);

(statearr_12825[(7)] = inst_12760__$1);

return statearr_12825;
})();
var statearr_12826_12850 = state_12799__$1;
(statearr_12826_12850[(2)] = null);

(statearr_12826_12850[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12800 === (8))){
var inst_12781 = (state_12799[(2)]);
var state_12799__$1 = state_12799;
var statearr_12827_12851 = state_12799__$1;
(statearr_12827_12851[(2)] = inst_12781);

(statearr_12827_12851[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11438__auto__ = null;
var cljs$core$async$state_machine__11438__auto____0 = (function (){
var statearr_12828 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12828[(0)] = cljs$core$async$state_machine__11438__auto__);

(statearr_12828[(1)] = (1));

return statearr_12828;
});
var cljs$core$async$state_machine__11438__auto____1 = (function (state_12799){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_12799);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e12829){var ex__11441__auto__ = e12829;
var statearr_12830_12852 = state_12799;
(statearr_12830_12852[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_12799[(4)]))){
var statearr_12831_12853 = state_12799;
(statearr_12831_12853[(1)] = cljs.core.first((state_12799[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12854 = state_12799;
state_12799 = G__12854;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$state_machine__11438__auto__ = function(state_12799){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11438__auto____1.call(this,state_12799);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11438__auto____0;
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11438__auto____1;
return cljs$core$async$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_12832 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_12832[(6)] = c__11512__auto___12834);

return statearr_12832;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__12857 = arguments.length;
switch (G__12857) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11512__auto___12912 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_12889){
var state_val_12890 = (state_12889[(1)]);
if((state_val_12890 === (7))){
var inst_12868 = (state_12889[(7)]);
var inst_12869 = (state_12889[(8)]);
var inst_12868__$1 = (state_12889[(2)]);
var inst_12869__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12868__$1,(0),null);
var inst_12870 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12868__$1,(1),null);
var inst_12871 = (inst_12869__$1 == null);
var state_12889__$1 = (function (){var statearr_12891 = state_12889;
(statearr_12891[(9)] = inst_12870);

(statearr_12891[(7)] = inst_12868__$1);

(statearr_12891[(8)] = inst_12869__$1);

return statearr_12891;
})();
if(cljs.core.truth_(inst_12871)){
var statearr_12892_12913 = state_12889__$1;
(statearr_12892_12913[(1)] = (8));

} else {
var statearr_12893_12914 = state_12889__$1;
(statearr_12893_12914[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12890 === (1))){
var inst_12858 = cljs.core.vec(chs);
var inst_12859 = inst_12858;
var state_12889__$1 = (function (){var statearr_12894 = state_12889;
(statearr_12894[(10)] = inst_12859);

return statearr_12894;
})();
var statearr_12895_12915 = state_12889__$1;
(statearr_12895_12915[(2)] = null);

(statearr_12895_12915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12890 === (4))){
var inst_12859 = (state_12889[(10)]);
var state_12889__$1 = state_12889;
return cljs.core.async.ioc_alts_BANG_(state_12889__$1,(7),inst_12859);
} else {
if((state_val_12890 === (6))){
var inst_12885 = (state_12889[(2)]);
var state_12889__$1 = state_12889;
var statearr_12896_12916 = state_12889__$1;
(statearr_12896_12916[(2)] = inst_12885);

(statearr_12896_12916[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12890 === (3))){
var inst_12887 = (state_12889[(2)]);
var state_12889__$1 = state_12889;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12889__$1,inst_12887);
} else {
if((state_val_12890 === (2))){
var inst_12859 = (state_12889[(10)]);
var inst_12861 = cljs.core.count(inst_12859);
var inst_12862 = (inst_12861 > (0));
var state_12889__$1 = state_12889;
if(cljs.core.truth_(inst_12862)){
var statearr_12898_12917 = state_12889__$1;
(statearr_12898_12917[(1)] = (4));

} else {
var statearr_12899_12918 = state_12889__$1;
(statearr_12899_12918[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12890 === (11))){
var inst_12859 = (state_12889[(10)]);
var inst_12878 = (state_12889[(2)]);
var tmp12897 = inst_12859;
var inst_12859__$1 = tmp12897;
var state_12889__$1 = (function (){var statearr_12900 = state_12889;
(statearr_12900[(10)] = inst_12859__$1);

(statearr_12900[(11)] = inst_12878);

return statearr_12900;
})();
var statearr_12901_12919 = state_12889__$1;
(statearr_12901_12919[(2)] = null);

(statearr_12901_12919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12890 === (9))){
var inst_12869 = (state_12889[(8)]);
var state_12889__$1 = state_12889;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12889__$1,(11),out,inst_12869);
} else {
if((state_val_12890 === (5))){
var inst_12883 = cljs.core.async.close_BANG_(out);
var state_12889__$1 = state_12889;
var statearr_12902_12920 = state_12889__$1;
(statearr_12902_12920[(2)] = inst_12883);

(statearr_12902_12920[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12890 === (10))){
var inst_12881 = (state_12889[(2)]);
var state_12889__$1 = state_12889;
var statearr_12903_12921 = state_12889__$1;
(statearr_12903_12921[(2)] = inst_12881);

(statearr_12903_12921[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12890 === (8))){
var inst_12870 = (state_12889[(9)]);
var inst_12859 = (state_12889[(10)]);
var inst_12868 = (state_12889[(7)]);
var inst_12869 = (state_12889[(8)]);
var inst_12873 = (function (){var cs = inst_12859;
var vec__12864 = inst_12868;
var v = inst_12869;
var c = inst_12870;
return (function (p1__12855_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__12855_SHARP_);
});
})();
var inst_12874 = cljs.core.filterv(inst_12873,inst_12859);
var inst_12859__$1 = inst_12874;
var state_12889__$1 = (function (){var statearr_12904 = state_12889;
(statearr_12904[(10)] = inst_12859__$1);

return statearr_12904;
})();
var statearr_12905_12922 = state_12889__$1;
(statearr_12905_12922[(2)] = null);

(statearr_12905_12922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11438__auto__ = null;
var cljs$core$async$state_machine__11438__auto____0 = (function (){
var statearr_12906 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12906[(0)] = cljs$core$async$state_machine__11438__auto__);

(statearr_12906[(1)] = (1));

return statearr_12906;
});
var cljs$core$async$state_machine__11438__auto____1 = (function (state_12889){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_12889);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e12907){var ex__11441__auto__ = e12907;
var statearr_12908_12923 = state_12889;
(statearr_12908_12923[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_12889[(4)]))){
var statearr_12909_12924 = state_12889;
(statearr_12909_12924[(1)] = cljs.core.first((state_12889[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12925 = state_12889;
state_12889 = G__12925;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$state_machine__11438__auto__ = function(state_12889){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11438__auto____1.call(this,state_12889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11438__auto____0;
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11438__auto____1;
return cljs$core$async$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_12910 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_12910[(6)] = c__11512__auto___12912);

return statearr_12910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__12927 = arguments.length;
switch (G__12927) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11512__auto___12973 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_12951){
var state_val_12952 = (state_12951[(1)]);
if((state_val_12952 === (7))){
var inst_12933 = (state_12951[(7)]);
var inst_12933__$1 = (state_12951[(2)]);
var inst_12934 = (inst_12933__$1 == null);
var inst_12935 = cljs.core.not(inst_12934);
var state_12951__$1 = (function (){var statearr_12953 = state_12951;
(statearr_12953[(7)] = inst_12933__$1);

return statearr_12953;
})();
if(inst_12935){
var statearr_12954_12974 = state_12951__$1;
(statearr_12954_12974[(1)] = (8));

} else {
var statearr_12955_12975 = state_12951__$1;
(statearr_12955_12975[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12952 === (1))){
var inst_12928 = (0);
var state_12951__$1 = (function (){var statearr_12956 = state_12951;
(statearr_12956[(8)] = inst_12928);

return statearr_12956;
})();
var statearr_12957_12976 = state_12951__$1;
(statearr_12957_12976[(2)] = null);

(statearr_12957_12976[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12952 === (4))){
var state_12951__$1 = state_12951;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12951__$1,(7),ch);
} else {
if((state_val_12952 === (6))){
var inst_12946 = (state_12951[(2)]);
var state_12951__$1 = state_12951;
var statearr_12958_12977 = state_12951__$1;
(statearr_12958_12977[(2)] = inst_12946);

(statearr_12958_12977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12952 === (3))){
var inst_12948 = (state_12951[(2)]);
var inst_12949 = cljs.core.async.close_BANG_(out);
var state_12951__$1 = (function (){var statearr_12959 = state_12951;
(statearr_12959[(9)] = inst_12948);

return statearr_12959;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_12951__$1,inst_12949);
} else {
if((state_val_12952 === (2))){
var inst_12928 = (state_12951[(8)]);
var inst_12930 = (inst_12928 < n);
var state_12951__$1 = state_12951;
if(cljs.core.truth_(inst_12930)){
var statearr_12960_12978 = state_12951__$1;
(statearr_12960_12978[(1)] = (4));

} else {
var statearr_12961_12979 = state_12951__$1;
(statearr_12961_12979[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12952 === (11))){
var inst_12928 = (state_12951[(8)]);
var inst_12938 = (state_12951[(2)]);
var inst_12939 = (inst_12928 + (1));
var inst_12928__$1 = inst_12939;
var state_12951__$1 = (function (){var statearr_12962 = state_12951;
(statearr_12962[(8)] = inst_12928__$1);

(statearr_12962[(10)] = inst_12938);

return statearr_12962;
})();
var statearr_12963_12980 = state_12951__$1;
(statearr_12963_12980[(2)] = null);

(statearr_12963_12980[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12952 === (9))){
var state_12951__$1 = state_12951;
var statearr_12964_12981 = state_12951__$1;
(statearr_12964_12981[(2)] = null);

(statearr_12964_12981[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12952 === (5))){
var state_12951__$1 = state_12951;
var statearr_12965_12982 = state_12951__$1;
(statearr_12965_12982[(2)] = null);

(statearr_12965_12982[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12952 === (10))){
var inst_12943 = (state_12951[(2)]);
var state_12951__$1 = state_12951;
var statearr_12966_12983 = state_12951__$1;
(statearr_12966_12983[(2)] = inst_12943);

(statearr_12966_12983[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12952 === (8))){
var inst_12933 = (state_12951[(7)]);
var state_12951__$1 = state_12951;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12951__$1,(11),out,inst_12933);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11438__auto__ = null;
var cljs$core$async$state_machine__11438__auto____0 = (function (){
var statearr_12967 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12967[(0)] = cljs$core$async$state_machine__11438__auto__);

(statearr_12967[(1)] = (1));

return statearr_12967;
});
var cljs$core$async$state_machine__11438__auto____1 = (function (state_12951){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_12951);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e12968){var ex__11441__auto__ = e12968;
var statearr_12969_12984 = state_12951;
(statearr_12969_12984[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_12951[(4)]))){
var statearr_12970_12985 = state_12951;
(statearr_12970_12985[(1)] = cljs.core.first((state_12951[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12986 = state_12951;
state_12951 = G__12986;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$state_machine__11438__auto__ = function(state_12951){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11438__auto____1.call(this,state_12951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11438__auto____0;
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11438__auto____1;
return cljs$core$async$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_12971 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_12971[(6)] = c__11512__auto___12973);

return statearr_12971;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12988 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12988 = (function (f,ch,meta12989){
this.f = f;
this.ch = ch;
this.meta12989 = meta12989;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12988.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12990,meta12989__$1){
var self__ = this;
var _12990__$1 = this;
return (new cljs.core.async.t_cljs$core$async12988(self__.f,self__.ch,meta12989__$1));
}));

(cljs.core.async.t_cljs$core$async12988.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12990){
var self__ = this;
var _12990__$1 = this;
return self__.meta12989;
}));

(cljs.core.async.t_cljs$core$async12988.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12988.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12988.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12988.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12988.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12991 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12991 = (function (f,ch,meta12989,_,fn1,meta12992){
this.f = f;
this.ch = ch;
this.meta12989 = meta12989;
this._ = _;
this.fn1 = fn1;
this.meta12992 = meta12992;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12991.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12993,meta12992__$1){
var self__ = this;
var _12993__$1 = this;
return (new cljs.core.async.t_cljs$core$async12991(self__.f,self__.ch,self__.meta12989,self__._,self__.fn1,meta12992__$1));
}));

(cljs.core.async.t_cljs$core$async12991.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12993){
var self__ = this;
var _12993__$1 = this;
return self__.meta12992;
}));

(cljs.core.async.t_cljs$core$async12991.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12991.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async12991.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12991.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__12987_SHARP_){
var G__12994 = (((p1__12987_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__12987_SHARP_) : self__.f.call(null,p1__12987_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__12994) : f1.call(null,G__12994));
});
}));

(cljs.core.async.t_cljs$core$async12991.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12989","meta12989",-1852725590,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async12988","cljs.core.async/t_cljs$core$async12988",-802086228,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta12992","meta12992",-829734649,null)], null);
}));

(cljs.core.async.t_cljs$core$async12991.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12991.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12991");

(cljs.core.async.t_cljs$core$async12991.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async12991");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12991.
 */
cljs.core.async.__GT_t_cljs$core$async12991 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12991(f__$1,ch__$1,meta12989__$1,___$2,fn1__$1,meta12992){
return (new cljs.core.async.t_cljs$core$async12991(f__$1,ch__$1,meta12989__$1,___$2,fn1__$1,meta12992));
});

}

return (new cljs.core.async.t_cljs$core$async12991(self__.f,self__.ch,self__.meta12989,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__12995 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__12995) : self__.f.call(null,G__12995));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async12988.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12988.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async12988.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12989","meta12989",-1852725590,null)], null);
}));

(cljs.core.async.t_cljs$core$async12988.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12988.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12988");

(cljs.core.async.t_cljs$core$async12988.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async12988");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12988.
 */
cljs.core.async.__GT_t_cljs$core$async12988 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12988(f__$1,ch__$1,meta12989){
return (new cljs.core.async.t_cljs$core$async12988(f__$1,ch__$1,meta12989));
});

}

return (new cljs.core.async.t_cljs$core$async12988(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12996 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12996 = (function (f,ch,meta12997){
this.f = f;
this.ch = ch;
this.meta12997 = meta12997;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12996.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12998,meta12997__$1){
var self__ = this;
var _12998__$1 = this;
return (new cljs.core.async.t_cljs$core$async12996(self__.f,self__.ch,meta12997__$1));
}));

(cljs.core.async.t_cljs$core$async12996.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12998){
var self__ = this;
var _12998__$1 = this;
return self__.meta12997;
}));

(cljs.core.async.t_cljs$core$async12996.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12996.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12996.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12996.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12996.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12996.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async12996.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12997","meta12997",-2099498415,null)], null);
}));

(cljs.core.async.t_cljs$core$async12996.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12996.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12996");

(cljs.core.async.t_cljs$core$async12996.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async12996");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12996.
 */
cljs.core.async.__GT_t_cljs$core$async12996 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async12996(f__$1,ch__$1,meta12997){
return (new cljs.core.async.t_cljs$core$async12996(f__$1,ch__$1,meta12997));
});

}

return (new cljs.core.async.t_cljs$core$async12996(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12999 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12999 = (function (p,ch,meta13000){
this.p = p;
this.ch = ch;
this.meta13000 = meta13000;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12999.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13001,meta13000__$1){
var self__ = this;
var _13001__$1 = this;
return (new cljs.core.async.t_cljs$core$async12999(self__.p,self__.ch,meta13000__$1));
}));

(cljs.core.async.t_cljs$core$async12999.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13001){
var self__ = this;
var _13001__$1 = this;
return self__.meta13000;
}));

(cljs.core.async.t_cljs$core$async12999.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12999.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12999.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12999.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12999.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12999.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12999.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async12999.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13000","meta13000",-1828759806,null)], null);
}));

(cljs.core.async.t_cljs$core$async12999.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12999.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12999");

(cljs.core.async.t_cljs$core$async12999.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async12999");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12999.
 */
cljs.core.async.__GT_t_cljs$core$async12999 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async12999(p__$1,ch__$1,meta13000){
return (new cljs.core.async.t_cljs$core$async12999(p__$1,ch__$1,meta13000));
});

}

return (new cljs.core.async.t_cljs$core$async12999(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__13003 = arguments.length;
switch (G__13003) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11512__auto___13044 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_13024){
var state_val_13025 = (state_13024[(1)]);
if((state_val_13025 === (7))){
var inst_13020 = (state_13024[(2)]);
var state_13024__$1 = state_13024;
var statearr_13026_13045 = state_13024__$1;
(statearr_13026_13045[(2)] = inst_13020);

(statearr_13026_13045[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13025 === (1))){
var state_13024__$1 = state_13024;
var statearr_13027_13046 = state_13024__$1;
(statearr_13027_13046[(2)] = null);

(statearr_13027_13046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13025 === (4))){
var inst_13006 = (state_13024[(7)]);
var inst_13006__$1 = (state_13024[(2)]);
var inst_13007 = (inst_13006__$1 == null);
var state_13024__$1 = (function (){var statearr_13028 = state_13024;
(statearr_13028[(7)] = inst_13006__$1);

return statearr_13028;
})();
if(cljs.core.truth_(inst_13007)){
var statearr_13029_13047 = state_13024__$1;
(statearr_13029_13047[(1)] = (5));

} else {
var statearr_13030_13048 = state_13024__$1;
(statearr_13030_13048[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13025 === (6))){
var inst_13006 = (state_13024[(7)]);
var inst_13011 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_13006) : p.call(null,inst_13006));
var state_13024__$1 = state_13024;
if(cljs.core.truth_(inst_13011)){
var statearr_13031_13049 = state_13024__$1;
(statearr_13031_13049[(1)] = (8));

} else {
var statearr_13032_13050 = state_13024__$1;
(statearr_13032_13050[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13025 === (3))){
var inst_13022 = (state_13024[(2)]);
var state_13024__$1 = state_13024;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13024__$1,inst_13022);
} else {
if((state_val_13025 === (2))){
var state_13024__$1 = state_13024;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13024__$1,(4),ch);
} else {
if((state_val_13025 === (11))){
var inst_13014 = (state_13024[(2)]);
var state_13024__$1 = state_13024;
var statearr_13033_13051 = state_13024__$1;
(statearr_13033_13051[(2)] = inst_13014);

(statearr_13033_13051[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13025 === (9))){
var state_13024__$1 = state_13024;
var statearr_13034_13052 = state_13024__$1;
(statearr_13034_13052[(2)] = null);

(statearr_13034_13052[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13025 === (5))){
var inst_13009 = cljs.core.async.close_BANG_(out);
var state_13024__$1 = state_13024;
var statearr_13035_13053 = state_13024__$1;
(statearr_13035_13053[(2)] = inst_13009);

(statearr_13035_13053[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13025 === (10))){
var inst_13017 = (state_13024[(2)]);
var state_13024__$1 = (function (){var statearr_13036 = state_13024;
(statearr_13036[(8)] = inst_13017);

return statearr_13036;
})();
var statearr_13037_13054 = state_13024__$1;
(statearr_13037_13054[(2)] = null);

(statearr_13037_13054[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13025 === (8))){
var inst_13006 = (state_13024[(7)]);
var state_13024__$1 = state_13024;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13024__$1,(11),out,inst_13006);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11438__auto__ = null;
var cljs$core$async$state_machine__11438__auto____0 = (function (){
var statearr_13038 = [null,null,null,null,null,null,null,null,null];
(statearr_13038[(0)] = cljs$core$async$state_machine__11438__auto__);

(statearr_13038[(1)] = (1));

return statearr_13038;
});
var cljs$core$async$state_machine__11438__auto____1 = (function (state_13024){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_13024);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e13039){var ex__11441__auto__ = e13039;
var statearr_13040_13055 = state_13024;
(statearr_13040_13055[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_13024[(4)]))){
var statearr_13041_13056 = state_13024;
(statearr_13041_13056[(1)] = cljs.core.first((state_13024[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13057 = state_13024;
state_13024 = G__13057;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$state_machine__11438__auto__ = function(state_13024){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11438__auto____1.call(this,state_13024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11438__auto____0;
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11438__auto____1;
return cljs$core$async$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_13042 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_13042[(6)] = c__11512__auto___13044);

return statearr_13042;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__13059 = arguments.length;
switch (G__13059) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_13122){
var state_val_13123 = (state_13122[(1)]);
if((state_val_13123 === (7))){
var inst_13118 = (state_13122[(2)]);
var state_13122__$1 = state_13122;
var statearr_13124_13163 = state_13122__$1;
(statearr_13124_13163[(2)] = inst_13118);

(statearr_13124_13163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (20))){
var inst_13088 = (state_13122[(7)]);
var inst_13099 = (state_13122[(2)]);
var inst_13100 = cljs.core.next(inst_13088);
var inst_13074 = inst_13100;
var inst_13075 = null;
var inst_13076 = (0);
var inst_13077 = (0);
var state_13122__$1 = (function (){var statearr_13125 = state_13122;
(statearr_13125[(8)] = inst_13075);

(statearr_13125[(9)] = inst_13074);

(statearr_13125[(10)] = inst_13099);

(statearr_13125[(11)] = inst_13077);

(statearr_13125[(12)] = inst_13076);

return statearr_13125;
})();
var statearr_13126_13164 = state_13122__$1;
(statearr_13126_13164[(2)] = null);

(statearr_13126_13164[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (1))){
var state_13122__$1 = state_13122;
var statearr_13127_13165 = state_13122__$1;
(statearr_13127_13165[(2)] = null);

(statearr_13127_13165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (4))){
var inst_13063 = (state_13122[(13)]);
var inst_13063__$1 = (state_13122[(2)]);
var inst_13064 = (inst_13063__$1 == null);
var state_13122__$1 = (function (){var statearr_13128 = state_13122;
(statearr_13128[(13)] = inst_13063__$1);

return statearr_13128;
})();
if(cljs.core.truth_(inst_13064)){
var statearr_13129_13166 = state_13122__$1;
(statearr_13129_13166[(1)] = (5));

} else {
var statearr_13130_13167 = state_13122__$1;
(statearr_13130_13167[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (15))){
var state_13122__$1 = state_13122;
var statearr_13134_13168 = state_13122__$1;
(statearr_13134_13168[(2)] = null);

(statearr_13134_13168[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (21))){
var state_13122__$1 = state_13122;
var statearr_13135_13169 = state_13122__$1;
(statearr_13135_13169[(2)] = null);

(statearr_13135_13169[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (13))){
var inst_13075 = (state_13122[(8)]);
var inst_13074 = (state_13122[(9)]);
var inst_13077 = (state_13122[(11)]);
var inst_13076 = (state_13122[(12)]);
var inst_13084 = (state_13122[(2)]);
var inst_13085 = (inst_13077 + (1));
var tmp13131 = inst_13075;
var tmp13132 = inst_13074;
var tmp13133 = inst_13076;
var inst_13074__$1 = tmp13132;
var inst_13075__$1 = tmp13131;
var inst_13076__$1 = tmp13133;
var inst_13077__$1 = inst_13085;
var state_13122__$1 = (function (){var statearr_13136 = state_13122;
(statearr_13136[(8)] = inst_13075__$1);

(statearr_13136[(9)] = inst_13074__$1);

(statearr_13136[(11)] = inst_13077__$1);

(statearr_13136[(14)] = inst_13084);

(statearr_13136[(12)] = inst_13076__$1);

return statearr_13136;
})();
var statearr_13137_13170 = state_13122__$1;
(statearr_13137_13170[(2)] = null);

(statearr_13137_13170[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (22))){
var state_13122__$1 = state_13122;
var statearr_13138_13171 = state_13122__$1;
(statearr_13138_13171[(2)] = null);

(statearr_13138_13171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (6))){
var inst_13063 = (state_13122[(13)]);
var inst_13072 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_13063) : f.call(null,inst_13063));
var inst_13073 = cljs.core.seq(inst_13072);
var inst_13074 = inst_13073;
var inst_13075 = null;
var inst_13076 = (0);
var inst_13077 = (0);
var state_13122__$1 = (function (){var statearr_13139 = state_13122;
(statearr_13139[(8)] = inst_13075);

(statearr_13139[(9)] = inst_13074);

(statearr_13139[(11)] = inst_13077);

(statearr_13139[(12)] = inst_13076);

return statearr_13139;
})();
var statearr_13140_13172 = state_13122__$1;
(statearr_13140_13172[(2)] = null);

(statearr_13140_13172[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (17))){
var inst_13088 = (state_13122[(7)]);
var inst_13092 = cljs.core.chunk_first(inst_13088);
var inst_13093 = cljs.core.chunk_rest(inst_13088);
var inst_13094 = cljs.core.count(inst_13092);
var inst_13074 = inst_13093;
var inst_13075 = inst_13092;
var inst_13076 = inst_13094;
var inst_13077 = (0);
var state_13122__$1 = (function (){var statearr_13141 = state_13122;
(statearr_13141[(8)] = inst_13075);

(statearr_13141[(9)] = inst_13074);

(statearr_13141[(11)] = inst_13077);

(statearr_13141[(12)] = inst_13076);

return statearr_13141;
})();
var statearr_13142_13173 = state_13122__$1;
(statearr_13142_13173[(2)] = null);

(statearr_13142_13173[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (3))){
var inst_13120 = (state_13122[(2)]);
var state_13122__$1 = state_13122;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13122__$1,inst_13120);
} else {
if((state_val_13123 === (12))){
var inst_13108 = (state_13122[(2)]);
var state_13122__$1 = state_13122;
var statearr_13143_13174 = state_13122__$1;
(statearr_13143_13174[(2)] = inst_13108);

(statearr_13143_13174[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (2))){
var state_13122__$1 = state_13122;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13122__$1,(4),in$);
} else {
if((state_val_13123 === (23))){
var inst_13116 = (state_13122[(2)]);
var state_13122__$1 = state_13122;
var statearr_13144_13175 = state_13122__$1;
(statearr_13144_13175[(2)] = inst_13116);

(statearr_13144_13175[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (19))){
var inst_13103 = (state_13122[(2)]);
var state_13122__$1 = state_13122;
var statearr_13145_13176 = state_13122__$1;
(statearr_13145_13176[(2)] = inst_13103);

(statearr_13145_13176[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (11))){
var inst_13074 = (state_13122[(9)]);
var inst_13088 = (state_13122[(7)]);
var inst_13088__$1 = cljs.core.seq(inst_13074);
var state_13122__$1 = (function (){var statearr_13146 = state_13122;
(statearr_13146[(7)] = inst_13088__$1);

return statearr_13146;
})();
if(inst_13088__$1){
var statearr_13147_13177 = state_13122__$1;
(statearr_13147_13177[(1)] = (14));

} else {
var statearr_13148_13178 = state_13122__$1;
(statearr_13148_13178[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (9))){
var inst_13110 = (state_13122[(2)]);
var inst_13111 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_13122__$1 = (function (){var statearr_13149 = state_13122;
(statearr_13149[(15)] = inst_13110);

return statearr_13149;
})();
if(cljs.core.truth_(inst_13111)){
var statearr_13150_13179 = state_13122__$1;
(statearr_13150_13179[(1)] = (21));

} else {
var statearr_13151_13180 = state_13122__$1;
(statearr_13151_13180[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (5))){
var inst_13066 = cljs.core.async.close_BANG_(out);
var state_13122__$1 = state_13122;
var statearr_13152_13181 = state_13122__$1;
(statearr_13152_13181[(2)] = inst_13066);

(statearr_13152_13181[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (14))){
var inst_13088 = (state_13122[(7)]);
var inst_13090 = cljs.core.chunked_seq_QMARK_(inst_13088);
var state_13122__$1 = state_13122;
if(inst_13090){
var statearr_13153_13182 = state_13122__$1;
(statearr_13153_13182[(1)] = (17));

} else {
var statearr_13154_13183 = state_13122__$1;
(statearr_13154_13183[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (16))){
var inst_13106 = (state_13122[(2)]);
var state_13122__$1 = state_13122;
var statearr_13155_13184 = state_13122__$1;
(statearr_13155_13184[(2)] = inst_13106);

(statearr_13155_13184[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13123 === (10))){
var inst_13075 = (state_13122[(8)]);
var inst_13077 = (state_13122[(11)]);
var inst_13082 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_13075,inst_13077);
var state_13122__$1 = state_13122;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13122__$1,(13),out,inst_13082);
} else {
if((state_val_13123 === (18))){
var inst_13088 = (state_13122[(7)]);
var inst_13097 = cljs.core.first(inst_13088);
var state_13122__$1 = state_13122;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13122__$1,(20),out,inst_13097);
} else {
if((state_val_13123 === (8))){
var inst_13077 = (state_13122[(11)]);
var inst_13076 = (state_13122[(12)]);
var inst_13079 = (inst_13077 < inst_13076);
var inst_13080 = inst_13079;
var state_13122__$1 = state_13122;
if(cljs.core.truth_(inst_13080)){
var statearr_13156_13185 = state_13122__$1;
(statearr_13156_13185[(1)] = (10));

} else {
var statearr_13157_13186 = state_13122__$1;
(statearr_13157_13186[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11438__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11438__auto____0 = (function (){
var statearr_13158 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13158[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11438__auto__);

(statearr_13158[(1)] = (1));

return statearr_13158;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11438__auto____1 = (function (state_13122){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_13122);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e13159){var ex__11441__auto__ = e13159;
var statearr_13160_13187 = state_13122;
(statearr_13160_13187[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_13122[(4)]))){
var statearr_13161_13188 = state_13122;
(statearr_13161_13188[(1)] = cljs.core.first((state_13122[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13189 = state_13122;
state_13122 = G__13189;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11438__auto__ = function(state_13122){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11438__auto____1.call(this,state_13122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11438__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11438__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_13162 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_13162[(6)] = c__11512__auto__);

return statearr_13162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__13191 = arguments.length;
switch (G__13191) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__13194 = arguments.length;
switch (G__13194) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__13197 = arguments.length;
switch (G__13197) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11512__auto___13245 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_13221){
var state_val_13222 = (state_13221[(1)]);
if((state_val_13222 === (7))){
var inst_13216 = (state_13221[(2)]);
var state_13221__$1 = state_13221;
var statearr_13223_13246 = state_13221__$1;
(statearr_13223_13246[(2)] = inst_13216);

(statearr_13223_13246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13222 === (1))){
var inst_13198 = null;
var state_13221__$1 = (function (){var statearr_13224 = state_13221;
(statearr_13224[(7)] = inst_13198);

return statearr_13224;
})();
var statearr_13225_13247 = state_13221__$1;
(statearr_13225_13247[(2)] = null);

(statearr_13225_13247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13222 === (4))){
var inst_13201 = (state_13221[(8)]);
var inst_13201__$1 = (state_13221[(2)]);
var inst_13202 = (inst_13201__$1 == null);
var inst_13203 = cljs.core.not(inst_13202);
var state_13221__$1 = (function (){var statearr_13226 = state_13221;
(statearr_13226[(8)] = inst_13201__$1);

return statearr_13226;
})();
if(inst_13203){
var statearr_13227_13248 = state_13221__$1;
(statearr_13227_13248[(1)] = (5));

} else {
var statearr_13228_13249 = state_13221__$1;
(statearr_13228_13249[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13222 === (6))){
var state_13221__$1 = state_13221;
var statearr_13229_13250 = state_13221__$1;
(statearr_13229_13250[(2)] = null);

(statearr_13229_13250[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13222 === (3))){
var inst_13218 = (state_13221[(2)]);
var inst_13219 = cljs.core.async.close_BANG_(out);
var state_13221__$1 = (function (){var statearr_13230 = state_13221;
(statearr_13230[(9)] = inst_13218);

return statearr_13230;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_13221__$1,inst_13219);
} else {
if((state_val_13222 === (2))){
var state_13221__$1 = state_13221;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13221__$1,(4),ch);
} else {
if((state_val_13222 === (11))){
var inst_13201 = (state_13221[(8)]);
var inst_13210 = (state_13221[(2)]);
var inst_13198 = inst_13201;
var state_13221__$1 = (function (){var statearr_13231 = state_13221;
(statearr_13231[(10)] = inst_13210);

(statearr_13231[(7)] = inst_13198);

return statearr_13231;
})();
var statearr_13232_13251 = state_13221__$1;
(statearr_13232_13251[(2)] = null);

(statearr_13232_13251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13222 === (9))){
var inst_13201 = (state_13221[(8)]);
var state_13221__$1 = state_13221;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13221__$1,(11),out,inst_13201);
} else {
if((state_val_13222 === (5))){
var inst_13201 = (state_13221[(8)]);
var inst_13198 = (state_13221[(7)]);
var inst_13205 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13201,inst_13198);
var state_13221__$1 = state_13221;
if(inst_13205){
var statearr_13234_13252 = state_13221__$1;
(statearr_13234_13252[(1)] = (8));

} else {
var statearr_13235_13253 = state_13221__$1;
(statearr_13235_13253[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13222 === (10))){
var inst_13213 = (state_13221[(2)]);
var state_13221__$1 = state_13221;
var statearr_13236_13254 = state_13221__$1;
(statearr_13236_13254[(2)] = inst_13213);

(statearr_13236_13254[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13222 === (8))){
var inst_13198 = (state_13221[(7)]);
var tmp13233 = inst_13198;
var inst_13198__$1 = tmp13233;
var state_13221__$1 = (function (){var statearr_13237 = state_13221;
(statearr_13237[(7)] = inst_13198__$1);

return statearr_13237;
})();
var statearr_13238_13255 = state_13221__$1;
(statearr_13238_13255[(2)] = null);

(statearr_13238_13255[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11438__auto__ = null;
var cljs$core$async$state_machine__11438__auto____0 = (function (){
var statearr_13239 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13239[(0)] = cljs$core$async$state_machine__11438__auto__);

(statearr_13239[(1)] = (1));

return statearr_13239;
});
var cljs$core$async$state_machine__11438__auto____1 = (function (state_13221){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_13221);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e13240){var ex__11441__auto__ = e13240;
var statearr_13241_13256 = state_13221;
(statearr_13241_13256[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_13221[(4)]))){
var statearr_13242_13257 = state_13221;
(statearr_13242_13257[(1)] = cljs.core.first((state_13221[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13258 = state_13221;
state_13221 = G__13258;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$state_machine__11438__auto__ = function(state_13221){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11438__auto____1.call(this,state_13221);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11438__auto____0;
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11438__auto____1;
return cljs$core$async$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_13243 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_13243[(6)] = c__11512__auto___13245);

return statearr_13243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__13260 = arguments.length;
switch (G__13260) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11512__auto___13327 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_13298){
var state_val_13299 = (state_13298[(1)]);
if((state_val_13299 === (7))){
var inst_13294 = (state_13298[(2)]);
var state_13298__$1 = state_13298;
var statearr_13300_13328 = state_13298__$1;
(statearr_13300_13328[(2)] = inst_13294);

(statearr_13300_13328[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (1))){
var inst_13261 = (new Array(n));
var inst_13262 = inst_13261;
var inst_13263 = (0);
var state_13298__$1 = (function (){var statearr_13301 = state_13298;
(statearr_13301[(7)] = inst_13263);

(statearr_13301[(8)] = inst_13262);

return statearr_13301;
})();
var statearr_13302_13329 = state_13298__$1;
(statearr_13302_13329[(2)] = null);

(statearr_13302_13329[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (4))){
var inst_13266 = (state_13298[(9)]);
var inst_13266__$1 = (state_13298[(2)]);
var inst_13267 = (inst_13266__$1 == null);
var inst_13268 = cljs.core.not(inst_13267);
var state_13298__$1 = (function (){var statearr_13303 = state_13298;
(statearr_13303[(9)] = inst_13266__$1);

return statearr_13303;
})();
if(inst_13268){
var statearr_13304_13330 = state_13298__$1;
(statearr_13304_13330[(1)] = (5));

} else {
var statearr_13305_13331 = state_13298__$1;
(statearr_13305_13331[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (15))){
var inst_13288 = (state_13298[(2)]);
var state_13298__$1 = state_13298;
var statearr_13306_13332 = state_13298__$1;
(statearr_13306_13332[(2)] = inst_13288);

(statearr_13306_13332[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (13))){
var state_13298__$1 = state_13298;
var statearr_13307_13333 = state_13298__$1;
(statearr_13307_13333[(2)] = null);

(statearr_13307_13333[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (6))){
var inst_13263 = (state_13298[(7)]);
var inst_13284 = (inst_13263 > (0));
var state_13298__$1 = state_13298;
if(cljs.core.truth_(inst_13284)){
var statearr_13308_13334 = state_13298__$1;
(statearr_13308_13334[(1)] = (12));

} else {
var statearr_13309_13335 = state_13298__$1;
(statearr_13309_13335[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (3))){
var inst_13296 = (state_13298[(2)]);
var state_13298__$1 = state_13298;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13298__$1,inst_13296);
} else {
if((state_val_13299 === (12))){
var inst_13262 = (state_13298[(8)]);
var inst_13286 = cljs.core.vec(inst_13262);
var state_13298__$1 = state_13298;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13298__$1,(15),out,inst_13286);
} else {
if((state_val_13299 === (2))){
var state_13298__$1 = state_13298;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13298__$1,(4),ch);
} else {
if((state_val_13299 === (11))){
var inst_13278 = (state_13298[(2)]);
var inst_13279 = (new Array(n));
var inst_13262 = inst_13279;
var inst_13263 = (0);
var state_13298__$1 = (function (){var statearr_13310 = state_13298;
(statearr_13310[(7)] = inst_13263);

(statearr_13310[(10)] = inst_13278);

(statearr_13310[(8)] = inst_13262);

return statearr_13310;
})();
var statearr_13311_13336 = state_13298__$1;
(statearr_13311_13336[(2)] = null);

(statearr_13311_13336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (9))){
var inst_13262 = (state_13298[(8)]);
var inst_13276 = cljs.core.vec(inst_13262);
var state_13298__$1 = state_13298;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13298__$1,(11),out,inst_13276);
} else {
if((state_val_13299 === (5))){
var inst_13266 = (state_13298[(9)]);
var inst_13263 = (state_13298[(7)]);
var inst_13271 = (state_13298[(11)]);
var inst_13262 = (state_13298[(8)]);
var inst_13270 = (inst_13262[inst_13263] = inst_13266);
var inst_13271__$1 = (inst_13263 + (1));
var inst_13272 = (inst_13271__$1 < n);
var state_13298__$1 = (function (){var statearr_13312 = state_13298;
(statearr_13312[(12)] = inst_13270);

(statearr_13312[(11)] = inst_13271__$1);

return statearr_13312;
})();
if(cljs.core.truth_(inst_13272)){
var statearr_13313_13337 = state_13298__$1;
(statearr_13313_13337[(1)] = (8));

} else {
var statearr_13314_13338 = state_13298__$1;
(statearr_13314_13338[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (14))){
var inst_13291 = (state_13298[(2)]);
var inst_13292 = cljs.core.async.close_BANG_(out);
var state_13298__$1 = (function (){var statearr_13316 = state_13298;
(statearr_13316[(13)] = inst_13291);

return statearr_13316;
})();
var statearr_13317_13339 = state_13298__$1;
(statearr_13317_13339[(2)] = inst_13292);

(statearr_13317_13339[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (10))){
var inst_13282 = (state_13298[(2)]);
var state_13298__$1 = state_13298;
var statearr_13318_13340 = state_13298__$1;
(statearr_13318_13340[(2)] = inst_13282);

(statearr_13318_13340[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (8))){
var inst_13271 = (state_13298[(11)]);
var inst_13262 = (state_13298[(8)]);
var tmp13315 = inst_13262;
var inst_13262__$1 = tmp13315;
var inst_13263 = inst_13271;
var state_13298__$1 = (function (){var statearr_13319 = state_13298;
(statearr_13319[(7)] = inst_13263);

(statearr_13319[(8)] = inst_13262__$1);

return statearr_13319;
})();
var statearr_13320_13341 = state_13298__$1;
(statearr_13320_13341[(2)] = null);

(statearr_13320_13341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11438__auto__ = null;
var cljs$core$async$state_machine__11438__auto____0 = (function (){
var statearr_13321 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13321[(0)] = cljs$core$async$state_machine__11438__auto__);

(statearr_13321[(1)] = (1));

return statearr_13321;
});
var cljs$core$async$state_machine__11438__auto____1 = (function (state_13298){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_13298);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e13322){var ex__11441__auto__ = e13322;
var statearr_13323_13342 = state_13298;
(statearr_13323_13342[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_13298[(4)]))){
var statearr_13324_13343 = state_13298;
(statearr_13324_13343[(1)] = cljs.core.first((state_13298[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13344 = state_13298;
state_13298 = G__13344;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$state_machine__11438__auto__ = function(state_13298){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11438__auto____1.call(this,state_13298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11438__auto____0;
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11438__auto____1;
return cljs$core$async$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_13325 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_13325[(6)] = c__11512__auto___13327);

return statearr_13325;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__13346 = arguments.length;
switch (G__13346) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11512__auto___13424 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_13391){
var state_val_13392 = (state_13391[(1)]);
if((state_val_13392 === (7))){
var inst_13387 = (state_13391[(2)]);
var state_13391__$1 = state_13391;
var statearr_13393_13425 = state_13391__$1;
(statearr_13393_13425[(2)] = inst_13387);

(statearr_13393_13425[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13392 === (1))){
var inst_13347 = [];
var inst_13348 = inst_13347;
var inst_13349 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13391__$1 = (function (){var statearr_13394 = state_13391;
(statearr_13394[(7)] = inst_13348);

(statearr_13394[(8)] = inst_13349);

return statearr_13394;
})();
var statearr_13395_13426 = state_13391__$1;
(statearr_13395_13426[(2)] = null);

(statearr_13395_13426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13392 === (4))){
var inst_13352 = (state_13391[(9)]);
var inst_13352__$1 = (state_13391[(2)]);
var inst_13353 = (inst_13352__$1 == null);
var inst_13354 = cljs.core.not(inst_13353);
var state_13391__$1 = (function (){var statearr_13396 = state_13391;
(statearr_13396[(9)] = inst_13352__$1);

return statearr_13396;
})();
if(inst_13354){
var statearr_13397_13427 = state_13391__$1;
(statearr_13397_13427[(1)] = (5));

} else {
var statearr_13398_13428 = state_13391__$1;
(statearr_13398_13428[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13392 === (15))){
var inst_13348 = (state_13391[(7)]);
var inst_13379 = cljs.core.vec(inst_13348);
var state_13391__$1 = state_13391;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13391__$1,(18),out,inst_13379);
} else {
if((state_val_13392 === (13))){
var inst_13374 = (state_13391[(2)]);
var state_13391__$1 = state_13391;
var statearr_13399_13429 = state_13391__$1;
(statearr_13399_13429[(2)] = inst_13374);

(statearr_13399_13429[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13392 === (6))){
var inst_13348 = (state_13391[(7)]);
var inst_13376 = inst_13348.length;
var inst_13377 = (inst_13376 > (0));
var state_13391__$1 = state_13391;
if(cljs.core.truth_(inst_13377)){
var statearr_13400_13430 = state_13391__$1;
(statearr_13400_13430[(1)] = (15));

} else {
var statearr_13401_13431 = state_13391__$1;
(statearr_13401_13431[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13392 === (17))){
var inst_13384 = (state_13391[(2)]);
var inst_13385 = cljs.core.async.close_BANG_(out);
var state_13391__$1 = (function (){var statearr_13402 = state_13391;
(statearr_13402[(10)] = inst_13384);

return statearr_13402;
})();
var statearr_13403_13432 = state_13391__$1;
(statearr_13403_13432[(2)] = inst_13385);

(statearr_13403_13432[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13392 === (3))){
var inst_13389 = (state_13391[(2)]);
var state_13391__$1 = state_13391;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13391__$1,inst_13389);
} else {
if((state_val_13392 === (12))){
var inst_13348 = (state_13391[(7)]);
var inst_13367 = cljs.core.vec(inst_13348);
var state_13391__$1 = state_13391;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13391__$1,(14),out,inst_13367);
} else {
if((state_val_13392 === (2))){
var state_13391__$1 = state_13391;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13391__$1,(4),ch);
} else {
if((state_val_13392 === (11))){
var inst_13348 = (state_13391[(7)]);
var inst_13356 = (state_13391[(11)]);
var inst_13352 = (state_13391[(9)]);
var inst_13364 = inst_13348.push(inst_13352);
var tmp13404 = inst_13348;
var inst_13348__$1 = tmp13404;
var inst_13349 = inst_13356;
var state_13391__$1 = (function (){var statearr_13405 = state_13391;
(statearr_13405[(7)] = inst_13348__$1);

(statearr_13405[(8)] = inst_13349);

(statearr_13405[(12)] = inst_13364);

return statearr_13405;
})();
var statearr_13406_13433 = state_13391__$1;
(statearr_13406_13433[(2)] = null);

(statearr_13406_13433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13392 === (9))){
var inst_13349 = (state_13391[(8)]);
var inst_13360 = cljs.core.keyword_identical_QMARK_(inst_13349,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_13391__$1 = state_13391;
var statearr_13407_13434 = state_13391__$1;
(statearr_13407_13434[(2)] = inst_13360);

(statearr_13407_13434[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13392 === (5))){
var inst_13349 = (state_13391[(8)]);
var inst_13356 = (state_13391[(11)]);
var inst_13352 = (state_13391[(9)]);
var inst_13357 = (state_13391[(13)]);
var inst_13356__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_13352) : f.call(null,inst_13352));
var inst_13357__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13356__$1,inst_13349);
var state_13391__$1 = (function (){var statearr_13408 = state_13391;
(statearr_13408[(11)] = inst_13356__$1);

(statearr_13408[(13)] = inst_13357__$1);

return statearr_13408;
})();
if(inst_13357__$1){
var statearr_13409_13435 = state_13391__$1;
(statearr_13409_13435[(1)] = (8));

} else {
var statearr_13410_13436 = state_13391__$1;
(statearr_13410_13436[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13392 === (14))){
var inst_13356 = (state_13391[(11)]);
var inst_13352 = (state_13391[(9)]);
var inst_13369 = (state_13391[(2)]);
var inst_13370 = [];
var inst_13371 = inst_13370.push(inst_13352);
var inst_13348 = inst_13370;
var inst_13349 = inst_13356;
var state_13391__$1 = (function (){var statearr_13411 = state_13391;
(statearr_13411[(7)] = inst_13348);

(statearr_13411[(8)] = inst_13349);

(statearr_13411[(14)] = inst_13369);

(statearr_13411[(15)] = inst_13371);

return statearr_13411;
})();
var statearr_13412_13437 = state_13391__$1;
(statearr_13412_13437[(2)] = null);

(statearr_13412_13437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13392 === (16))){
var state_13391__$1 = state_13391;
var statearr_13413_13438 = state_13391__$1;
(statearr_13413_13438[(2)] = null);

(statearr_13413_13438[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13392 === (10))){
var inst_13362 = (state_13391[(2)]);
var state_13391__$1 = state_13391;
if(cljs.core.truth_(inst_13362)){
var statearr_13414_13439 = state_13391__$1;
(statearr_13414_13439[(1)] = (11));

} else {
var statearr_13415_13440 = state_13391__$1;
(statearr_13415_13440[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13392 === (18))){
var inst_13381 = (state_13391[(2)]);
var state_13391__$1 = state_13391;
var statearr_13416_13441 = state_13391__$1;
(statearr_13416_13441[(2)] = inst_13381);

(statearr_13416_13441[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13392 === (8))){
var inst_13357 = (state_13391[(13)]);
var state_13391__$1 = state_13391;
var statearr_13417_13442 = state_13391__$1;
(statearr_13417_13442[(2)] = inst_13357);

(statearr_13417_13442[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11438__auto__ = null;
var cljs$core$async$state_machine__11438__auto____0 = (function (){
var statearr_13418 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13418[(0)] = cljs$core$async$state_machine__11438__auto__);

(statearr_13418[(1)] = (1));

return statearr_13418;
});
var cljs$core$async$state_machine__11438__auto____1 = (function (state_13391){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_13391);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e13419){var ex__11441__auto__ = e13419;
var statearr_13420_13443 = state_13391;
(statearr_13420_13443[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_13391[(4)]))){
var statearr_13421_13444 = state_13391;
(statearr_13421_13444[(1)] = cljs.core.first((state_13391[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13445 = state_13391;
state_13391 = G__13445;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
cljs$core$async$state_machine__11438__auto__ = function(state_13391){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11438__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11438__auto____1.call(this,state_13391);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11438__auto____0;
cljs$core$async$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11438__auto____1;
return cljs$core$async$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_13422 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_13422[(6)] = c__11512__auto___13424);

return statearr_13422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

