// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__78701 = arguments.length;
switch (G__78701) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11512__auto___78740 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_78722){
var state_val_78723 = (state_78722[(1)]);
if((state_val_78723 === (1))){
var state_78722__$1 = state_78722;
var statearr_78724_78741 = state_78722__$1;
(statearr_78724_78741[(2)] = null);

(statearr_78724_78741[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78723 === (2))){
var _ = (function (){var statearr_78725 = state_78722;
(statearr_78725[(4)] = cljs.core.cons((5),(state_78722[(4)])));

return statearr_78725;
})();
var inst_78708 = fluree.db.session.db(conn,ledger,null);
var state_78722__$1 = state_78722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78722__$1,(7),inst_78708);
} else {
if((state_val_78723 === (3))){
var inst_78718 = (state_78722[(2)]);
var inst_78719 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_78718);
var inst_78720 = cljs.core.async.close_BANG_(pc);
var state_78722__$1 = (function (){var statearr_78727 = state_78722;
(statearr_78727[(7)] = inst_78719);

return statearr_78727;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_78722__$1,inst_78720);
} else {
if((state_val_78723 === (4))){
var inst_78702 = (state_78722[(2)]);
var state_78722__$1 = state_78722;
var statearr_78728_78742 = state_78722__$1;
(statearr_78728_78742[(2)] = inst_78702);

(statearr_78728_78742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78723 === (5))){
var _ = (function (){var statearr_78729 = state_78722;
(statearr_78729[(4)] = cljs.core.rest((state_78722[(4)])));

return statearr_78729;
})();
var state_78722__$1 = state_78722;
var ex78726 = (state_78722__$1[(2)]);
var statearr_78730_78743 = state_78722__$1;
(statearr_78730_78743[(5)] = ex78726);


var statearr_78731_78744 = state_78722__$1;
(statearr_78731_78744[(1)] = (4));

(statearr_78731_78744[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78723 === (6))){
var inst_78714 = (state_78722[(2)]);
var inst_78715 = fluree.db.util.async.throw_err(inst_78714);
var _ = (function (){var statearr_78732 = state_78722;
(statearr_78732[(4)] = cljs.core.rest((state_78722[(4)])));

return statearr_78732;
})();
var state_78722__$1 = state_78722;
var statearr_78733_78745 = state_78722__$1;
(statearr_78733_78745[(2)] = inst_78715);

(statearr_78733_78745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78723 === (7))){
var inst_78710 = (state_78722[(2)]);
var inst_78711 = fluree.db.util.async.throw_err(inst_78710);
var inst_78712 = fluree.db.time_travel.as_of_block(inst_78711,block);
var state_78722__$1 = state_78722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78722__$1,(6),inst_78712);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__11438__auto__ = null;
var fluree$db$api$ledger$state_machine__11438__auto____0 = (function (){
var statearr_78734 = [null,null,null,null,null,null,null,null];
(statearr_78734[(0)] = fluree$db$api$ledger$state_machine__11438__auto__);

(statearr_78734[(1)] = (1));

return statearr_78734;
});
var fluree$db$api$ledger$state_machine__11438__auto____1 = (function (state_78722){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_78722);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e78735){var ex__11441__auto__ = e78735;
var statearr_78736_78746 = state_78722;
(statearr_78736_78746[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_78722[(4)]))){
var statearr_78737_78747 = state_78722;
(statearr_78737_78747[(1)] = cljs.core.first((state_78722[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78748 = state_78722;
state_78722 = G__78748;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__11438__auto__ = function(state_78722){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__11438__auto____1.call(this,state_78722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__11438__auto____0;
fluree$db$api$ledger$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__11438__auto____1;
return fluree$db$api$ledger$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_78738 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_78738[(6)] = c__11512__auto___78740);

return statearr_78738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_78789){
var state_val_78790 = (state_78789[(1)]);
if((state_val_78790 === (7))){
var inst_78758 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_78789__$1 = state_78789;
if(inst_78758){
var statearr_78791_78822 = state_78789__$1;
(statearr_78791_78822[(1)] = (9));

} else {
var statearr_78792_78823 = state_78789__$1;
(statearr_78792_78823[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78790 === (1))){
var state_78789__$1 = state_78789;
var statearr_78793_78824 = state_78789__$1;
(statearr_78793_78824[(2)] = null);

(statearr_78793_78824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78790 === (4))){
var inst_78749 = (state_78789[(2)]);
var state_78789__$1 = state_78789;
var statearr_78794_78825 = state_78789__$1;
(statearr_78794_78825[(2)] = inst_78749);

(statearr_78794_78825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78790 === (15))){
var inst_78766 = (state_78789[(7)]);
var inst_78765 = (state_78789[(2)]);
var inst_78766__$1 = fluree.db.util.async.throw_err(inst_78765);
var state_78789__$1 = (function (){var statearr_78795 = state_78789;
(statearr_78795[(7)] = inst_78766__$1);

return statearr_78795;
})();
if(cljs.core.truth_(inst_78766__$1)){
var statearr_78796_78826 = state_78789__$1;
(statearr_78796_78826[(1)] = (16));

} else {
var statearr_78797_78827 = state_78789__$1;
(statearr_78797_78827[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78790 === (13))){
var state_78789__$1 = state_78789;
var statearr_78798_78828 = state_78789__$1;
(statearr_78798_78828[(2)] = null);

(statearr_78798_78828[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78790 === (6))){
var state_78789__$1 = state_78789;
var statearr_78799_78829 = state_78789__$1;
(statearr_78799_78829[(2)] = db);

(statearr_78799_78829[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78790 === (17))){
var inst_78770 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_78771 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78772 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_78773 = cljs.core.PersistentHashMap.fromArrays(inst_78771,inst_78772);
var inst_78774 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_78770,inst_78773);
var inst_78775 = (function(){throw inst_78774})();
var state_78789__$1 = state_78789;
var statearr_78800_78830 = state_78789__$1;
(statearr_78800_78830[(2)] = inst_78775);

(statearr_78800_78830[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78790 === (3))){
var inst_78787 = (state_78789[(2)]);
var state_78789__$1 = state_78789;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78789__$1,inst_78787);
} else {
if((state_val_78790 === (12))){
var inst_78763 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_78789__$1 = state_78789;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78789__$1,(15),inst_78763);
} else {
if((state_val_78790 === (2))){
var _ = (function (){var statearr_78801 = state_78789;
(statearr_78801[(4)] = cljs.core.cons((5),(state_78789[(4)])));

return statearr_78801;
})();
var inst_78755 = cljs.core.not(auth);
var state_78789__$1 = state_78789;
if(inst_78755){
var statearr_78802_78831 = state_78789__$1;
(statearr_78802_78831[(1)] = (6));

} else {
var statearr_78803_78832 = state_78789__$1;
(statearr_78803_78832[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78790 === (11))){
var inst_78782 = (state_78789[(2)]);
var state_78789__$1 = state_78789;
var statearr_78805_78833 = state_78789__$1;
(statearr_78805_78833[(2)] = inst_78782);

(statearr_78805_78833[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78790 === (9))){
var inst_78760 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_78789__$1 = state_78789;
var statearr_78806_78834 = state_78789__$1;
(statearr_78806_78834[(2)] = inst_78760);

(statearr_78806_78834[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78790 === (5))){
var _ = (function (){var statearr_78807 = state_78789;
(statearr_78807[(4)] = cljs.core.rest((state_78789[(4)])));

return statearr_78807;
})();
var state_78789__$1 = state_78789;
var ex78804 = (state_78789__$1[(2)]);
var statearr_78808_78835 = state_78789__$1;
(statearr_78808_78835[(5)] = ex78804);


if((ex78804 instanceof Error)){
var statearr_78809_78836 = state_78789__$1;
(statearr_78809_78836[(1)] = (4));

(statearr_78809_78836[(5)] = null);

} else {
throw ex78804;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78790 === (14))){
var inst_78780 = (state_78789[(2)]);
var state_78789__$1 = state_78789;
var statearr_78810_78837 = state_78789__$1;
(statearr_78810_78837[(2)] = inst_78780);

(statearr_78810_78837[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78790 === (16))){
var inst_78766 = (state_78789[(7)]);
var inst_78768 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_78766);
var state_78789__$1 = state_78789;
var statearr_78811_78838 = state_78789__$1;
(statearr_78811_78838[(2)] = inst_78768);

(statearr_78811_78838[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78790 === (10))){
var state_78789__$1 = state_78789;
var statearr_78812_78839 = state_78789__$1;
(statearr_78812_78839[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78790 === (18))){
var inst_78777 = (state_78789[(2)]);
var state_78789__$1 = state_78789;
var statearr_78814_78840 = state_78789__$1;
(statearr_78814_78840[(2)] = inst_78777);

(statearr_78814_78840[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78790 === (8))){
var inst_78784 = (state_78789[(2)]);
var _ = (function (){var statearr_78815 = state_78789;
(statearr_78815[(4)] = cljs.core.rest((state_78789[(4)])));

return statearr_78815;
})();
var state_78789__$1 = state_78789;
var statearr_78816_78841 = state_78789__$1;
(statearr_78816_78841[(2)] = inst_78784);

(statearr_78816_78841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11438__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11438__auto____0 = (function (){
var statearr_78817 = [null,null,null,null,null,null,null,null];
(statearr_78817[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11438__auto__);

(statearr_78817[(1)] = (1));

return statearr_78817;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11438__auto____1 = (function (state_78789){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_78789);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e78818){var ex__11441__auto__ = e78818;
var statearr_78819_78842 = state_78789;
(statearr_78819_78842[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_78789[(4)]))){
var statearr_78820_78843 = state_78789;
(statearr_78820_78843[(1)] = cljs.core.first((state_78789[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78844 = state_78789;
state_78789 = G__78844;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11438__auto__ = function(state_78789){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11438__auto____1.call(this,state_78789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11438__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11438__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_78821 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_78821[(6)] = c__11512__auto__);

return statearr_78821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_78908){
var state_val_78909 = (state_78908[(1)]);
if((state_val_78909 === (7))){
var inst_78854 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_78908__$1 = state_78908;
if(inst_78854){
var statearr_78910_78959 = state_78908__$1;
(statearr_78910_78959[(1)] = (9));

} else {
var statearr_78911_78960 = state_78908__$1;
(statearr_78911_78960[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (20))){
var inst_78878 = (state_78908[(7)]);
var state_78908__$1 = state_78908;
if(cljs.core.truth_(inst_78878)){
var statearr_78912_78961 = state_78908__$1;
(statearr_78912_78961[(1)] = (22));

} else {
var statearr_78913_78962 = state_78908__$1;
(statearr_78913_78962[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (27))){
var state_78908__$1 = state_78908;
var statearr_78914_78963 = state_78908__$1;
(statearr_78914_78963[(2)] = null);

(statearr_78914_78963[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (1))){
var state_78908__$1 = state_78908;
var statearr_78915_78964 = state_78908__$1;
(statearr_78915_78964[(2)] = null);

(statearr_78915_78964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (24))){
var inst_78892 = (state_78908[(2)]);
var state_78908__$1 = state_78908;
var statearr_78916_78965 = state_78908__$1;
(statearr_78916_78965[(2)] = inst_78892);

(statearr_78916_78965[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (4))){
var inst_78845 = (state_78908[(2)]);
var state_78908__$1 = state_78908;
var statearr_78917_78966 = state_78908__$1;
(statearr_78917_78966[(2)] = inst_78845);

(statearr_78917_78966[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (15))){
var inst_78861 = (state_78908[(8)]);
var inst_78860 = (state_78908[(2)]);
var inst_78861__$1 = fluree.db.util.async.throw_err(inst_78860);
var state_78908__$1 = (function (){var statearr_78918 = state_78908;
(statearr_78918[(8)] = inst_78861__$1);

return statearr_78918;
})();
if(cljs.core.truth_(inst_78861__$1)){
var statearr_78919_78967 = state_78908__$1;
(statearr_78919_78967[(1)] = (16));

} else {
var statearr_78920_78968 = state_78908__$1;
(statearr_78920_78968[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (21))){
var inst_78894 = (state_78908[(9)]);
var inst_78894__$1 = (state_78908[(2)]);
var state_78908__$1 = (function (){var statearr_78921 = state_78908;
(statearr_78921[(9)] = inst_78894__$1);

return statearr_78921;
})();
if(cljs.core.truth_(inst_78894__$1)){
var statearr_78922_78969 = state_78908__$1;
(statearr_78922_78969[(1)] = (29));

} else {
var statearr_78923_78970 = state_78908__$1;
(statearr_78923_78970[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (31))){
var inst_78894 = (state_78908[(9)]);
var inst_78878 = (state_78908[(7)]);
var inst_78902 = (state_78908[(2)]);
var inst_78903 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_78878,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_78894,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_78902], 0));
var _ = (function (){var statearr_78924 = state_78908;
(statearr_78924[(4)] = cljs.core.rest((state_78908[(4)])));

return statearr_78924;
})();
var state_78908__$1 = state_78908;
var statearr_78925_78971 = state_78908__$1;
(statearr_78925_78971[(2)] = inst_78903);

(statearr_78925_78971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (32))){
var inst_78898 = (state_78908[(2)]);
var inst_78899 = fluree.db.util.async.throw_err(inst_78898);
var state_78908__$1 = state_78908;
var statearr_78926_78972 = state_78908__$1;
(statearr_78926_78972[(2)] = inst_78899);

(statearr_78926_78972[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (13))){
var state_78908__$1 = state_78908;
var statearr_78927_78973 = state_78908__$1;
(statearr_78927_78973[(2)] = null);

(statearr_78927_78973[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (22))){
var inst_78878 = (state_78908[(7)]);
var inst_78882 = fluree.db.auth.roles(db,inst_78878);
var state_78908__$1 = state_78908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78908__$1,(25),inst_78882);
} else {
if((state_val_78909 === (29))){
var inst_78894 = (state_78908[(9)]);
var inst_78896 = fluree.db.permissions.permission_map(db,inst_78894,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_78908__$1 = state_78908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78908__$1,(32),inst_78896);
} else {
if((state_val_78909 === (6))){
var state_78908__$1 = state_78908;
var statearr_78928_78974 = state_78908__$1;
(statearr_78928_78974[(2)] = null);

(statearr_78928_78974[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (28))){
var inst_78890 = (state_78908[(2)]);
var state_78908__$1 = state_78908;
var statearr_78929_78975 = state_78908__$1;
(statearr_78929_78975[(2)] = inst_78890);

(statearr_78929_78975[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (25))){
var inst_78884 = (state_78908[(2)]);
var inst_78885 = fluree.db.util.async.throw_err(inst_78884);
var state_78908__$1 = state_78908;
var statearr_78930_78976 = state_78908__$1;
(statearr_78930_78976[(2)] = inst_78885);

(statearr_78930_78976[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (17))){
var inst_78864 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_78865 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78866 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_78867 = cljs.core.PersistentHashMap.fromArrays(inst_78865,inst_78866);
var inst_78868 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_78864,inst_78867);
var inst_78869 = (function(){throw inst_78868})();
var state_78908__$1 = state_78908;
var statearr_78931_78977 = state_78908__$1;
(statearr_78931_78977[(2)] = inst_78869);

(statearr_78931_78977[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (3))){
var inst_78906 = (state_78908[(2)]);
var state_78908__$1 = state_78908;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78908__$1,inst_78906);
} else {
if((state_val_78909 === (12))){
var inst_78858 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_78908__$1 = state_78908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78908__$1,(15),inst_78858);
} else {
if((state_val_78909 === (2))){
var _ = (function (){var statearr_78932 = state_78908;
(statearr_78932[(4)] = cljs.core.cons((5),(state_78908[(4)])));

return statearr_78932;
})();
var inst_78851 = (auth == null);
var state_78908__$1 = state_78908;
if(cljs.core.truth_(inst_78851)){
var statearr_78933_78978 = state_78908__$1;
(statearr_78933_78978[(1)] = (6));

} else {
var statearr_78934_78979 = state_78908__$1;
(statearr_78934_78979[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (23))){
var state_78908__$1 = state_78908;
var statearr_78935_78980 = state_78908__$1;
(statearr_78935_78980[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (19))){
var state_78908__$1 = state_78908;
var statearr_78937_78981 = state_78908__$1;
(statearr_78937_78981[(2)] = roles);

(statearr_78937_78981[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (11))){
var inst_78876 = (state_78908[(2)]);
var state_78908__$1 = state_78908;
var statearr_78939_78982 = state_78908__$1;
(statearr_78939_78982[(2)] = inst_78876);

(statearr_78939_78982[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (9))){
var state_78908__$1 = state_78908;
var statearr_78940_78983 = state_78908__$1;
(statearr_78940_78983[(2)] = (0));

(statearr_78940_78983[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (5))){
var _ = (function (){var statearr_78941 = state_78908;
(statearr_78941[(4)] = cljs.core.rest((state_78908[(4)])));

return statearr_78941;
})();
var state_78908__$1 = state_78908;
var ex78938 = (state_78908__$1[(2)]);
var statearr_78942_78984 = state_78908__$1;
(statearr_78942_78984[(5)] = ex78938);


if((ex78938 instanceof Error)){
var statearr_78943_78985 = state_78908__$1;
(statearr_78943_78985[(1)] = (4));

(statearr_78943_78985[(5)] = null);

} else {
throw ex78938;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (14))){
var inst_78874 = (state_78908[(2)]);
var state_78908__$1 = state_78908;
var statearr_78944_78986 = state_78908__$1;
(statearr_78944_78986[(2)] = inst_78874);

(statearr_78944_78986[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (26))){
var state_78908__$1 = state_78908;
var statearr_78945_78987 = state_78908__$1;
(statearr_78945_78987[(2)] = null);

(statearr_78945_78987[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (16))){
var inst_78861 = (state_78908[(8)]);
var state_78908__$1 = state_78908;
var statearr_78946_78988 = state_78908__$1;
(statearr_78946_78988[(2)] = inst_78861);

(statearr_78946_78988[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (30))){
var state_78908__$1 = state_78908;
var statearr_78947_78989 = state_78908__$1;
(statearr_78947_78989[(2)] = null);

(statearr_78947_78989[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (10))){
var state_78908__$1 = state_78908;
if(cljs.core.truth_(auth)){
var statearr_78948_78990 = state_78908__$1;
(statearr_78948_78990[(1)] = (12));

} else {
var statearr_78949_78991 = state_78908__$1;
(statearr_78949_78991[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (18))){
var inst_78871 = (state_78908[(2)]);
var state_78908__$1 = state_78908;
var statearr_78950_78992 = state_78908__$1;
(statearr_78950_78992[(2)] = inst_78871);

(statearr_78950_78992[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78909 === (8))){
var inst_78878 = (state_78908[(2)]);
var state_78908__$1 = (function (){var statearr_78951 = state_78908;
(statearr_78951[(7)] = inst_78878);

return statearr_78951;
})();
if(cljs.core.truth_(roles)){
var statearr_78952_78993 = state_78908__$1;
(statearr_78952_78993[(1)] = (19));

} else {
var statearr_78953_78994 = state_78908__$1;
(statearr_78953_78994[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__11438__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__11438__auto____0 = (function (){
var statearr_78954 = [null,null,null,null,null,null,null,null,null,null];
(statearr_78954[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__11438__auto__);

(statearr_78954[(1)] = (1));

return statearr_78954;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__11438__auto____1 = (function (state_78908){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_78908);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e78955){var ex__11441__auto__ = e78955;
var statearr_78956_78995 = state_78908;
(statearr_78956_78995[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_78908[(4)]))){
var statearr_78957_78996 = state_78908;
(statearr_78957_78996[(1)] = cljs.core.first((state_78908[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78997 = state_78908;
state_78908 = G__78997;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__11438__auto__ = function(state_78908){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__11438__auto____1.call(this,state_78908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__11438__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__11438__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_78958 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_78958[(6)] = c__11512__auto__);

return statearr_78958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__78998 = db;
var map__78998__$1 = cljs.core.__destructure_map(map__78998);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78998__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78998__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78998__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_79005){
var state_val_79006 = (state_79005[(1)]);
if((state_val_79006 === (1))){
var inst_78999 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_79000 = fluree.db.session.db(conn,inst_78999,null);
var state_79005__$1 = state_79005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79005__$1,(2),inst_79000);
} else {
if((state_val_79006 === (2))){
var inst_79002 = (state_79005[(2)]);
var inst_79003 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_79002);
var state_79005__$1 = state_79005;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79005__$1,inst_79003);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto____0 = (function (){
var statearr_79007 = [null,null,null,null,null,null,null];
(statearr_79007[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto__);

(statearr_79007[(1)] = (1));

return statearr_79007;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto____1 = (function (state_79005){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_79005);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e79008){var ex__11441__auto__ = e79008;
var statearr_79009_79036 = state_79005;
(statearr_79009_79036[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_79005[(4)]))){
var statearr_79010_79037 = state_79005;
(statearr_79010_79037[(1)] = cljs.core.first((state_79005[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79038 = state_79005;
state_79005 = G__79038;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto__ = function(state_79005){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto____1.call(this,state_79005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_79011 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_79011[(6)] = c__11512__auto__);

return statearr_79011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_79024){
var state_val_79025 = (state_79024[(1)]);
if((state_val_79025 === (1))){
var inst_79012 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_79013 = fluree.db.session.db(conn,inst_79012,null);
var state_79024__$1 = state_79024;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79024__$1,(2),inst_79013);
} else {
if((state_val_79025 === (2))){
var inst_79015 = (state_79024[(7)]);
var inst_79015__$1 = (state_79024[(2)]);
var inst_79016 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_79015__$1);
var inst_79017 = newer_block_QMARK_(inst_79016);
var state_79024__$1 = (function (){var statearr_79026 = state_79024;
(statearr_79026[(7)] = inst_79015__$1);

return statearr_79026;
})();
if(inst_79017){
var statearr_79027_79039 = state_79024__$1;
(statearr_79027_79039[(1)] = (3));

} else {
var statearr_79028_79040 = state_79024__$1;
(statearr_79028_79040[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79025 === (3))){
var inst_79015 = (state_79024[(7)]);
var inst_79019 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_79015);
var state_79024__$1 = state_79024;
var statearr_79029_79041 = state_79024__$1;
(statearr_79029_79041[(2)] = inst_79019);

(statearr_79029_79041[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79025 === (4))){
var state_79024__$1 = state_79024;
var statearr_79030_79042 = state_79024__$1;
(statearr_79030_79042[(2)] = null);

(statearr_79030_79042[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79025 === (5))){
var inst_79022 = (state_79024[(2)]);
var state_79024__$1 = state_79024;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79024__$1,inst_79022);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto____0 = (function (){
var statearr_79031 = [null,null,null,null,null,null,null,null];
(statearr_79031[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto__);

(statearr_79031[(1)] = (1));

return statearr_79031;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto____1 = (function (state_79024){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_79024);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e79032){var ex__11441__auto__ = e79032;
var statearr_79033_79043 = state_79024;
(statearr_79033_79043[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_79024[(4)]))){
var statearr_79034_79044 = state_79024;
(statearr_79034_79044[(1)] = cljs.core.first((state_79024[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79045 = state_79024;
state_79024 = G__79045;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto__ = function(state_79024){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto____1.call(this,state_79024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_79035 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_79035[(6)] = c__11512__auto__);

return statearr_79035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__79046 = db;
var map__79046__$1 = cljs.core.__destructure_map(map__79046);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__79046__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__79046__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__79046__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__11512__auto___79122 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_79096){
var state_val_79097 = (state_79096[(1)]);
if((state_val_79097 === (7))){
var inst_79062 = (state_79096[(7)]);
var inst_79073 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_79062,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_79096__$1 = state_79096;
if(inst_79073){
var statearr_79098_79123 = state_79096__$1;
(statearr_79098_79123[(1)] = (9));

} else {
var statearr_79099_79124 = state_79096__$1;
(statearr_79099_79124[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79097 === (1))){
var inst_79055 = (state_79096[(8)]);
var inst_79047 = (state_79096[(9)]);
var inst_79047__$1 = cljs.core.async.timeout(timeout);
var inst_79055__$1 = res_port;
var inst_79056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79057 = [inst_79047__$1,inst_79055__$1];
var inst_79058 = (new cljs.core.PersistentVector(null,2,(5),inst_79056,inst_79057,null));
var state_79096__$1 = (function (){var statearr_79100 = state_79096;
(statearr_79100[(8)] = inst_79055__$1);

(statearr_79100[(9)] = inst_79047__$1);

return statearr_79100;
})();
return cljs.core.async.ioc_alts_BANG_(state_79096__$1,(2),inst_79058);
} else {
if((state_val_79097 === (4))){
var inst_79062 = (state_79096[(7)]);
var inst_79055 = (state_79096[(8)]);
var inst_79066 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_79062,inst_79055);
var state_79096__$1 = state_79096;
if(inst_79066){
var statearr_79101_79125 = state_79096__$1;
(statearr_79101_79125[(1)] = (6));

} else {
var statearr_79102_79126 = state_79096__$1;
(statearr_79102_79126[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79097 === (13))){
var inst_79081 = (state_79096[(10)]);
var inst_79092 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_79081);
var state_79096__$1 = state_79096;
var statearr_79103_79127 = state_79096__$1;
(statearr_79103_79127[(2)] = inst_79092);

(statearr_79103_79127[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79097 === (6))){
var inst_79060 = (state_79096[(11)]);
var inst_79071 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79060,(0),null);
var state_79096__$1 = state_79096;
var statearr_79104_79128 = state_79096__$1;
(statearr_79104_79128[(2)] = inst_79071);

(statearr_79104_79128[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79097 === (3))){
var state_79096__$1 = state_79096;
var statearr_79105_79129 = state_79096__$1;
(statearr_79105_79129[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_79105_79129[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79097 === (12))){
var inst_79085 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_79086 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_79087 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_79088 = cljs.core.PersistentHashMap.fromArrays(inst_79086,inst_79087);
var inst_79089 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_79085,inst_79088);
var inst_79090 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_79089);
var state_79096__$1 = state_79096;
var statearr_79106_79130 = state_79096__$1;
(statearr_79106_79130[(2)] = inst_79090);

(statearr_79106_79130[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79097 === (2))){
var inst_79062 = (state_79096[(7)]);
var inst_79060 = (state_79096[(11)]);
var inst_79047 = (state_79096[(9)]);
var inst_79060__$1 = (state_79096[(2)]);
var inst_79061 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79060__$1,(0),null);
var inst_79062__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79060__$1,(1),null);
var inst_79063 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_79062__$1,inst_79047);
var state_79096__$1 = (function (){var statearr_79107 = state_79096;
(statearr_79107[(7)] = inst_79062__$1);

(statearr_79107[(11)] = inst_79060__$1);

(statearr_79107[(12)] = inst_79061);

return statearr_79107;
})();
if(inst_79063){
var statearr_79108_79131 = state_79096__$1;
(statearr_79108_79131[(1)] = (3));

} else {
var statearr_79109_79132 = state_79096__$1;
(statearr_79109_79132[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79097 === (11))){
var inst_79077 = (state_79096[(2)]);
var state_79096__$1 = state_79096;
var statearr_79110_79133 = state_79096__$1;
(statearr_79110_79133[(2)] = inst_79077);

(statearr_79110_79133[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79097 === (9))){
var inst_79061 = (state_79096[(12)]);
var state_79096__$1 = state_79096;
var statearr_79111_79134 = state_79096__$1;
(statearr_79111_79134[(2)] = inst_79061);

(statearr_79111_79134[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79097 === (5))){
var inst_79081 = (state_79096[(10)]);
var inst_79081__$1 = (state_79096[(2)]);
var inst_79082 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_79083 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_79081__$1);
var state_79096__$1 = (function (){var statearr_79112 = state_79096;
(statearr_79112[(10)] = inst_79081__$1);

(statearr_79112[(13)] = inst_79082);

return statearr_79112;
})();
if(inst_79083){
var statearr_79113_79135 = state_79096__$1;
(statearr_79113_79135[(1)] = (12));

} else {
var statearr_79114_79136 = state_79096__$1;
(statearr_79114_79136[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79097 === (14))){
var inst_79094 = (state_79096[(2)]);
var state_79096__$1 = state_79096;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79096__$1,inst_79094);
} else {
if((state_val_79097 === (10))){
var state_79096__$1 = state_79096;
var statearr_79115_79137 = state_79096__$1;
(statearr_79115_79137[(2)] = null);

(statearr_79115_79137[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79097 === (8))){
var inst_79079 = (state_79096[(2)]);
var state_79096__$1 = state_79096;
var statearr_79116_79138 = state_79096__$1;
(statearr_79116_79138[(2)] = inst_79079);

(statearr_79116_79138[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__11438__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__11438__auto____0 = (function (){
var statearr_79117 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79117[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__11438__auto__);

(statearr_79117[(1)] = (1));

return statearr_79117;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__11438__auto____1 = (function (state_79096){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_79096);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e79118){var ex__11441__auto__ = e79118;
var statearr_79119_79139 = state_79096;
(statearr_79119_79139[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_79096[(4)]))){
var statearr_79120_79140 = state_79096;
(statearr_79120_79140[(1)] = cljs.core.first((state_79096[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79141 = state_79096;
state_79096 = G__79141;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__11438__auto__ = function(state_79096){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__11438__auto____1.call(this,state_79096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__11438__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__11438__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_79121 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_79121[(6)] = c__11512__auto___79122);

return statearr_79121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__79143 = arguments.length;
switch (G__79143) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__79144){
var map__79145 = p__79144;
var map__79145__$1 = cljs.core.__destructure_map(map__79145);
var opts = map__79145__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__79145__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__79145__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__79145__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__79145__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__79145__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__11512__auto___79234 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_79196){
var state_val_79197 = (state_79196[(1)]);
if((state_val_79197 === (7))){
var inst_79158 = (state_79196[(7)]);
var inst_79160 = fluree.db.api.ledger.syncTo_db(inst_79158,syncTo,syncTimeout);
var state_79196__$1 = state_79196;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79196__$1,(10),inst_79160);
} else {
if((state_val_79197 === (20))){
var inst_79182 = (state_79196[(8)]);
var state_79196__$1 = state_79196;
var statearr_79198_79235 = state_79196__$1;
(statearr_79198_79235[(2)] = inst_79182);

(statearr_79198_79235[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79197 === (1))){
var state_79196__$1 = state_79196;
var statearr_79199_79236 = state_79196__$1;
(statearr_79199_79236[(2)] = null);

(statearr_79199_79236[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79197 === (4))){
var inst_79146 = (state_79196[(2)]);
var inst_79147 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_79146);
var inst_79148 = cljs.core.async.close_BANG_(pc);
var state_79196__$1 = (function (){var statearr_79200 = state_79196;
(statearr_79200[(9)] = inst_79147);

return statearr_79200;
})();
var statearr_79201_79237 = state_79196__$1;
(statearr_79201_79237[(2)] = inst_79148);

(statearr_79201_79237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79197 === (15))){
var inst_79174 = (state_79196[(10)]);
var inst_79176 = fluree.db.api.ledger.add_db_permissions(inst_79174,auth,roles);
var state_79196__$1 = state_79196;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79196__$1,(18),inst_79176);
} else {
if((state_val_79197 === (21))){
var inst_79190 = (state_79196[(2)]);
var inst_79191 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_79190);
var _ = (function (){var statearr_79202 = state_79196;
(statearr_79202[(4)] = cljs.core.rest((state_79196[(4)])));

return statearr_79202;
})();
var state_79196__$1 = state_79196;
var statearr_79203_79238 = state_79196__$1;
(statearr_79203_79238[(2)] = inst_79191);

(statearr_79203_79238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79197 === (13))){
var inst_79174 = (state_79196[(2)]);
var state_79196__$1 = (function (){var statearr_79204 = state_79196;
(statearr_79204[(10)] = inst_79174);

return statearr_79204;
})();
if(cljs.core.truth_(roles)){
var statearr_79205_79239 = state_79196__$1;
(statearr_79205_79239[(1)] = (15));

} else {
var statearr_79206_79240 = state_79196__$1;
(statearr_79206_79240[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79197 === (22))){
var inst_79186 = (state_79196[(2)]);
var inst_79187 = fluree.db.util.async.throw_err(inst_79186);
var state_79196__$1 = state_79196;
var statearr_79207_79241 = state_79196__$1;
(statearr_79207_79241[(2)] = inst_79187);

(statearr_79207_79241[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79197 === (6))){
var inst_79157 = (state_79196[(2)]);
var inst_79158 = fluree.db.util.async.throw_err(inst_79157);
var state_79196__$1 = (function (){var statearr_79208 = state_79196;
(statearr_79208[(7)] = inst_79158);

return statearr_79208;
})();
if(cljs.core.truth_(syncTo)){
var statearr_79209_79242 = state_79196__$1;
(statearr_79209_79242[(1)] = (7));

} else {
var statearr_79210_79243 = state_79196__$1;
(statearr_79210_79243[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79197 === (17))){
var inst_79182 = (state_79196[(2)]);
var state_79196__$1 = (function (){var statearr_79211 = state_79196;
(statearr_79211[(8)] = inst_79182);

return statearr_79211;
})();
if(cljs.core.truth_(auth)){
var statearr_79212_79244 = state_79196__$1;
(statearr_79212_79244[(1)] = (19));

} else {
var statearr_79213_79245 = state_79196__$1;
(statearr_79213_79245[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79197 === (3))){
var inst_79194 = (state_79196[(2)]);
var state_79196__$1 = state_79196;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79196__$1,inst_79194);
} else {
if((state_val_79197 === (12))){
var inst_79166 = (state_79196[(11)]);
var state_79196__$1 = state_79196;
var statearr_79214_79246 = state_79196__$1;
(statearr_79214_79246[(2)] = inst_79166);

(statearr_79214_79246[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79197 === (2))){
var _ = (function (){var statearr_79215 = state_79196;
(statearr_79215[(4)] = cljs.core.cons((5),(state_79196[(4)])));

return statearr_79215;
})();
var inst_79155 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_79196__$1 = state_79196;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79196__$1,(6),inst_79155);
} else {
if((state_val_79197 === (19))){
var inst_79182 = (state_79196[(8)]);
var inst_79184 = fluree.db.api.ledger.add_db_permissions(inst_79182,auth,roles);
var state_79196__$1 = state_79196;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79196__$1,(22),inst_79184);
} else {
if((state_val_79197 === (11))){
var inst_79166 = (state_79196[(11)]);
var inst_79168 = fluree.db.time_travel.as_of_block(inst_79166,block);
var state_79196__$1 = state_79196;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79196__$1,(14),inst_79168);
} else {
if((state_val_79197 === (9))){
var inst_79166 = (state_79196[(2)]);
var state_79196__$1 = (function (){var statearr_79217 = state_79196;
(statearr_79217[(11)] = inst_79166);

return statearr_79217;
})();
if(cljs.core.truth_(block)){
var statearr_79218_79247 = state_79196__$1;
(statearr_79218_79247[(1)] = (11));

} else {
var statearr_79219_79248 = state_79196__$1;
(statearr_79219_79248[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79197 === (5))){
var _ = (function (){var statearr_79220 = state_79196;
(statearr_79220[(4)] = cljs.core.rest((state_79196[(4)])));

return statearr_79220;
})();
var state_79196__$1 = state_79196;
var ex79216 = (state_79196__$1[(2)]);
var statearr_79221_79249 = state_79196__$1;
(statearr_79221_79249[(5)] = ex79216);


var statearr_79222_79250 = state_79196__$1;
(statearr_79222_79250[(1)] = (4));

(statearr_79222_79250[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79197 === (14))){
var inst_79170 = (state_79196[(2)]);
var inst_79171 = fluree.db.util.async.throw_err(inst_79170);
var state_79196__$1 = state_79196;
var statearr_79223_79251 = state_79196__$1;
(statearr_79223_79251[(2)] = inst_79171);

(statearr_79223_79251[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79197 === (16))){
var inst_79174 = (state_79196[(10)]);
var state_79196__$1 = state_79196;
var statearr_79224_79252 = state_79196__$1;
(statearr_79224_79252[(2)] = inst_79174);

(statearr_79224_79252[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79197 === (10))){
var inst_79162 = (state_79196[(2)]);
var inst_79163 = fluree.db.util.async.throw_err(inst_79162);
var state_79196__$1 = state_79196;
var statearr_79225_79253 = state_79196__$1;
(statearr_79225_79253[(2)] = inst_79163);

(statearr_79225_79253[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79197 === (18))){
var inst_79178 = (state_79196[(2)]);
var inst_79179 = fluree.db.util.async.throw_err(inst_79178);
var state_79196__$1 = state_79196;
var statearr_79226_79254 = state_79196__$1;
(statearr_79226_79254[(2)] = inst_79179);

(statearr_79226_79254[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79197 === (8))){
var inst_79158 = (state_79196[(7)]);
var state_79196__$1 = state_79196;
var statearr_79227_79255 = state_79196__$1;
(statearr_79227_79255[(2)] = inst_79158);

(statearr_79227_79255[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__11438__auto__ = null;
var fluree$db$api$ledger$state_machine__11438__auto____0 = (function (){
var statearr_79228 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79228[(0)] = fluree$db$api$ledger$state_machine__11438__auto__);

(statearr_79228[(1)] = (1));

return statearr_79228;
});
var fluree$db$api$ledger$state_machine__11438__auto____1 = (function (state_79196){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_79196);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e79229){var ex__11441__auto__ = e79229;
var statearr_79230_79256 = state_79196;
(statearr_79230_79256[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_79196[(4)]))){
var statearr_79231_79257 = state_79196;
(statearr_79231_79257[(1)] = cljs.core.first((state_79196[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79258 = state_79196;
state_79196 = G__79258;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__11438__auto__ = function(state_79196){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__11438__auto____1.call(this,state_79196);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__11438__auto____0;
fluree$db$api$ledger$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__11438__auto____1;
return fluree$db$api$ledger$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_79232 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_79232[(6)] = c__11512__auto___79234);

return statearr_79232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

