// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__71292 = arguments.length;
switch (G__71292) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11512__auto___71440 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_71379){
var state_val_71380 = (state_71379[(1)]);
if((state_val_71380 === (7))){
var inst_71310 = (state_71379[(7)]);
var inst_71313 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_71310);
var state_71379__$1 = state_71379;
var statearr_71381_71441 = state_71379__$1;
(statearr_71381_71441[(2)] = inst_71313);

(statearr_71381_71441[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (20))){
var inst_71334 = (state_71379[(8)]);
var inst_71305 = (state_71379[(9)]);
var inst_71338 = fluree.db.auth.roles(inst_71305,inst_71334);
var state_71379__$1 = state_71379;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71379__$1,(23),inst_71338);
} else {
if((state_val_71380 === (27))){
var inst_71305 = (state_71379[(9)]);
var inst_71353 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_71354 = fluree.db.time_travel.as_of_block(inst_71305,inst_71353);
var state_71379__$1 = state_71379;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71379__$1,(30),inst_71354);
} else {
if((state_val_71380 === (1))){
var state_71379__$1 = state_71379;
var statearr_71382_71442 = state_71379__$1;
(statearr_71382_71442[(2)] = null);

(statearr_71382_71442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (24))){
var inst_71346 = (state_71379[(10)]);
var inst_71305 = (state_71379[(9)]);
var inst_71348 = fluree.db.permissions.permission_map(inst_71305,inst_71346,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_71379__$1 = state_71379;
var statearr_71383_71443 = state_71379__$1;
(statearr_71383_71443[(2)] = inst_71348);

(statearr_71383_71443[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (4))){
var inst_71293 = (state_71379[(2)]);
var inst_71294 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_71293);
var inst_71295 = cljs.core.async.close_BANG_(pc);
var state_71379__$1 = (function (){var statearr_71384 = state_71379;
(statearr_71384[(11)] = inst_71294);

return statearr_71384;
})();
var statearr_71385_71444 = state_71379__$1;
(statearr_71385_71444[(2)] = inst_71295);

(statearr_71385_71444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (15))){
var inst_71310 = (state_71379[(7)]);
var inst_71324 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71310)," unknown."].join('');
var inst_71325 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71326 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_71327 = cljs.core.PersistentHashMap.fromArrays(inst_71325,inst_71326);
var inst_71328 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_71324,inst_71327);
var inst_71329 = (function(){throw inst_71328})();
var state_71379__$1 = state_71379;
var statearr_71386_71445 = state_71379__$1;
(statearr_71386_71445[(2)] = inst_71329);

(statearr_71386_71445[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (21))){
var state_71379__$1 = state_71379;
var statearr_71387_71446 = state_71379__$1;
(statearr_71387_71446[(2)] = null);

(statearr_71387_71446[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (31))){
var inst_71310 = (state_71379[(7)]);
var inst_71360 = (state_71379[(12)]);
var inst_71362 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_71360,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_71310);
var state_71379__$1 = state_71379;
var statearr_71388_71447 = state_71379__$1;
(statearr_71388_71447[(2)] = inst_71362);

(statearr_71388_71447[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (32))){
var inst_71360 = (state_71379[(12)]);
var state_71379__$1 = state_71379;
var statearr_71389_71448 = state_71379__$1;
(statearr_71389_71448[(2)] = inst_71360);

(statearr_71389_71448[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (33))){
var inst_71346 = (state_71379[(10)]);
var inst_71365 = (state_71379[(2)]);
var state_71379__$1 = (function (){var statearr_71390 = state_71379;
(statearr_71390[(13)] = inst_71365);

return statearr_71390;
})();
if(cljs.core.truth_(inst_71346)){
var statearr_71391_71449 = state_71379__$1;
(statearr_71391_71449[(1)] = (34));

} else {
var statearr_71392_71450 = state_71379__$1;
(statearr_71392_71450[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (13))){
var inst_71321 = (state_71379[(14)]);
var inst_71320 = (state_71379[(2)]);
var inst_71321__$1 = fluree.db.util.async.throw_err(inst_71320);
var state_71379__$1 = (function (){var statearr_71393 = state_71379;
(statearr_71393[(14)] = inst_71321__$1);

return statearr_71393;
})();
if(cljs.core.truth_(inst_71321__$1)){
var statearr_71394_71451 = state_71379__$1;
(statearr_71394_71451[(1)] = (14));

} else {
var statearr_71395_71452 = state_71379__$1;
(statearr_71395_71452[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (22))){
var inst_71344 = (state_71379[(2)]);
var state_71379__$1 = state_71379;
var statearr_71396_71453 = state_71379__$1;
(statearr_71396_71453[(2)] = inst_71344);

(statearr_71396_71453[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (36))){
var inst_71373 = (state_71379[(2)]);
var inst_71374 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_71373);
var _ = (function (){var statearr_71397 = state_71379;
(statearr_71397[(4)] = cljs.core.rest((state_71379[(4)])));

return statearr_71397;
})();
var state_71379__$1 = state_71379;
var statearr_71398_71454 = state_71379__$1;
(statearr_71398_71454[(2)] = inst_71374);

(statearr_71398_71454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (29))){
var inst_71310 = (state_71379[(7)]);
var inst_71360 = (state_71379[(2)]);
var state_71379__$1 = (function (){var statearr_71399 = state_71379;
(statearr_71399[(12)] = inst_71360);

return statearr_71399;
})();
if(cljs.core.truth_(inst_71310)){
var statearr_71400_71455 = state_71379__$1;
(statearr_71400_71455[(1)] = (31));

} else {
var statearr_71401_71456 = state_71379__$1;
(statearr_71401_71456[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (6))){
var inst_71310 = (state_71379[(7)]);
var inst_71304 = (state_71379[(2)]);
var inst_71305 = fluree.db.util.async.throw_err(inst_71304);
var inst_71306 = opts;
var inst_71307 = cljs.core.__destructure_map(inst_71306);
var inst_71308 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71307,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_71309 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71307,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_71310__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71307,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_71311 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71307,new cljs.core.Keyword(null,"block","block",664686210));
var state_71379__$1 = (function (){var statearr_71402 = state_71379;
(statearr_71402[(15)] = inst_71311);

(statearr_71402[(9)] = inst_71305);

(statearr_71402[(7)] = inst_71310__$1);

(statearr_71402[(16)] = inst_71309);

(statearr_71402[(17)] = inst_71308);

return statearr_71402;
})();
if(cljs.core.truth_(inst_71310__$1)){
var statearr_71403_71457 = state_71379__$1;
(statearr_71403_71457[(1)] = (7));

} else {
var statearr_71404_71458 = state_71379__$1;
(statearr_71404_71458[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (28))){
var inst_71305 = (state_71379[(9)]);
var state_71379__$1 = state_71379;
var statearr_71405_71459 = state_71379__$1;
(statearr_71405_71459[(2)] = inst_71305);

(statearr_71405_71459[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (25))){
var state_71379__$1 = state_71379;
var statearr_71406_71460 = state_71379__$1;
(statearr_71406_71460[(2)] = null);

(statearr_71406_71460[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (34))){
var inst_71351 = (state_71379[(18)]);
var state_71379__$1 = state_71379;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71379__$1,(37),inst_71351);
} else {
if((state_val_71380 === (17))){
var inst_71308 = (state_71379[(17)]);
var state_71379__$1 = state_71379;
var statearr_71407_71461 = state_71379__$1;
(statearr_71407_71461[(2)] = inst_71308);

(statearr_71407_71461[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (3))){
var inst_71377 = (state_71379[(2)]);
var state_71379__$1 = state_71379;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71379__$1,inst_71377);
} else {
if((state_val_71380 === (12))){
var inst_71308 = (state_71379[(17)]);
var inst_71334 = (state_71379[(2)]);
var state_71379__$1 = (function (){var statearr_71408 = state_71379;
(statearr_71408[(8)] = inst_71334);

return statearr_71408;
})();
if(cljs.core.truth_(inst_71308)){
var statearr_71409_71462 = state_71379__$1;
(statearr_71409_71462[(1)] = (17));

} else {
var statearr_71410_71463 = state_71379__$1;
(statearr_71410_71463[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (2))){
var _ = (function (){var statearr_71411 = state_71379;
(statearr_71411[(4)] = cljs.core.cons((5),(state_71379[(4)])));

return statearr_71411;
})();
var inst_71302 = fluree.db.session.db(conn,ledger,null);
var state_71379__$1 = state_71379;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71379__$1,(6),inst_71302);
} else {
if((state_val_71380 === (23))){
var inst_71340 = (state_71379[(2)]);
var inst_71341 = fluree.db.util.async.throw_err(inst_71340);
var state_71379__$1 = state_71379;
var statearr_71412_71464 = state_71379__$1;
(statearr_71412_71464[(2)] = inst_71341);

(statearr_71412_71464[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (35))){
var inst_71365 = (state_71379[(13)]);
var state_71379__$1 = state_71379;
var statearr_71413_71465 = state_71379__$1;
(statearr_71413_71465[(2)] = inst_71365);

(statearr_71413_71465[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (19))){
var inst_71346 = (state_71379[(10)]);
var inst_71346__$1 = (state_71379[(2)]);
var state_71379__$1 = (function (){var statearr_71414 = state_71379;
(statearr_71414[(10)] = inst_71346__$1);

return statearr_71414;
})();
if(cljs.core.truth_(inst_71346__$1)){
var statearr_71415_71466 = state_71379__$1;
(statearr_71415_71466[(1)] = (24));

} else {
var statearr_71416_71467 = state_71379__$1;
(statearr_71416_71467[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (11))){
var state_71379__$1 = state_71379;
var statearr_71418_71468 = state_71379__$1;
(statearr_71418_71468[(2)] = null);

(statearr_71418_71468[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (9))){
var inst_71316 = (state_71379[(2)]);
var state_71379__$1 = state_71379;
if(cljs.core.truth_(inst_71316)){
var statearr_71419_71469 = state_71379__$1;
(statearr_71419_71469[(1)] = (10));

} else {
var statearr_71420_71470 = state_71379__$1;
(statearr_71420_71470[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (5))){
var _ = (function (){var statearr_71421 = state_71379;
(statearr_71421[(4)] = cljs.core.rest((state_71379[(4)])));

return statearr_71421;
})();
var state_71379__$1 = state_71379;
var ex71417 = (state_71379__$1[(2)]);
var statearr_71422_71471 = state_71379__$1;
(statearr_71422_71471[(5)] = ex71417);


var statearr_71423_71472 = state_71379__$1;
(statearr_71423_71472[(1)] = (4));

(statearr_71423_71472[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (14))){
var inst_71321 = (state_71379[(14)]);
var state_71379__$1 = state_71379;
var statearr_71424_71473 = state_71379__$1;
(statearr_71424_71473[(2)] = inst_71321);

(statearr_71424_71473[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (26))){
var inst_71311 = (state_71379[(15)]);
var inst_71351 = (state_71379[(2)]);
var state_71379__$1 = (function (){var statearr_71425 = state_71379;
(statearr_71425[(18)] = inst_71351);

return statearr_71425;
})();
if(cljs.core.truth_(inst_71311)){
var statearr_71426_71474 = state_71379__$1;
(statearr_71426_71474[(1)] = (27));

} else {
var statearr_71427_71475 = state_71379__$1;
(statearr_71427_71475[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (16))){
var inst_71331 = (state_71379[(2)]);
var state_71379__$1 = state_71379;
var statearr_71428_71476 = state_71379__$1;
(statearr_71428_71476[(2)] = inst_71331);

(statearr_71428_71476[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (30))){
var inst_71356 = (state_71379[(2)]);
var inst_71357 = fluree.db.util.async.throw_err(inst_71356);
var state_71379__$1 = state_71379;
var statearr_71429_71477 = state_71379__$1;
(statearr_71429_71477[(2)] = inst_71357);

(statearr_71429_71477[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (10))){
var inst_71305 = (state_71379[(9)]);
var inst_71310 = (state_71379[(7)]);
var inst_71318 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_71305,inst_71310);
var state_71379__$1 = state_71379;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71379__$1,(13),inst_71318);
} else {
if((state_val_71380 === (18))){
var inst_71334 = (state_71379[(8)]);
var state_71379__$1 = state_71379;
if(cljs.core.truth_(inst_71334)){
var statearr_71430_71478 = state_71379__$1;
(statearr_71430_71478[(1)] = (20));

} else {
var statearr_71431_71479 = state_71379__$1;
(statearr_71431_71479[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (37))){
var inst_71365 = (state_71379[(13)]);
var inst_71368 = (state_71379[(2)]);
var inst_71369 = fluree.db.util.async.throw_err(inst_71368);
var inst_71370 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_71365,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_71369);
var state_71379__$1 = state_71379;
var statearr_71432_71480 = state_71379__$1;
(statearr_71432_71480[(2)] = inst_71370);

(statearr_71432_71480[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71380 === (8))){
var inst_71310 = (state_71379[(7)]);
var state_71379__$1 = state_71379;
var statearr_71433_71481 = state_71379__$1;
(statearr_71433_71481[(2)] = inst_71310);

(statearr_71433_71481[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__11438__auto__ = null;
var fluree$db$api$query$state_machine__11438__auto____0 = (function (){
var statearr_71434 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71434[(0)] = fluree$db$api$query$state_machine__11438__auto__);

(statearr_71434[(1)] = (1));

return statearr_71434;
});
var fluree$db$api$query$state_machine__11438__auto____1 = (function (state_71379){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_71379);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e71435){var ex__11441__auto__ = e71435;
var statearr_71436_71482 = state_71379;
(statearr_71436_71482[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_71379[(4)]))){
var statearr_71437_71483 = state_71379;
(statearr_71437_71483[(1)] = cljs.core.first((state_71379[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71484 = state_71379;
state_71379 = G__71484;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__11438__auto__ = function(state_71379){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__11438__auto____1.call(this,state_71379);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__11438__auto____0;
fluree$db$api$query$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__11438__auto____1;
return fluree$db$api$query$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_71438 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_71438[(6)] = c__11512__auto___71440);

return statearr_71438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_71625){
var state_val_71626 = (state_71625[(1)]);
if((state_val_71626 === (7))){
var inst_71505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71506 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_71507 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_71508 = [inst_71506,inst_71507];
var inst_71509 = (new cljs.core.PersistentVector(null,2,(5),inst_71505,inst_71508,null));
var state_71625__$1 = state_71625;
var statearr_71627_71697 = state_71625__$1;
(statearr_71627_71697[(2)] = inst_71509);

(statearr_71627_71697[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (20))){
var inst_71535 = (state_71625[(7)]);
var state_71625__$1 = state_71625;
var statearr_71628_71698 = state_71625__$1;
(statearr_71628_71698[(2)] = inst_71535);

(statearr_71628_71698[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (27))){
var state_71625__$1 = state_71625;
var statearr_71629_71699 = state_71625__$1;
(statearr_71629_71699[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (1))){
var state_71625__$1 = state_71625;
var statearr_71631_71700 = state_71625__$1;
(statearr_71631_71700[(2)] = null);

(statearr_71631_71700[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (24))){
var inst_71534 = (state_71625[(8)]);
var state_71625__$1 = state_71625;
if(cljs.core.truth_(inst_71534)){
var statearr_71632_71701 = state_71625__$1;
(statearr_71632_71701[(1)] = (26));

} else {
var statearr_71633_71702 = state_71625__$1;
(statearr_71633_71702[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (39))){
var inst_71580 = (state_71625[(9)]);
var inst_71581 = (state_71625[(10)]);
var inst_71606 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71607 = [inst_71580,inst_71581];
var inst_71608 = (new cljs.core.PersistentVector(null,2,(5),inst_71606,inst_71607,null));
var state_71625__$1 = state_71625;
var statearr_71634_71703 = state_71625__$1;
(statearr_71634_71703[(2)] = inst_71608);

(statearr_71634_71703[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (4))){
var inst_71485 = (state_71625[(2)]);
var state_71625__$1 = state_71625;
var statearr_71635_71704 = state_71625__$1;
(statearr_71635_71704[(2)] = inst_71485);

(statearr_71635_71704[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (15))){
var inst_71519 = (state_71625[(11)]);
var inst_71514 = (state_71625[(12)]);
var inst_71528 = (state_71625[(2)]);
var inst_71529 = [inst_71519,inst_71528];
var inst_71530 = (new cljs.core.PersistentVector(null,2,(5),inst_71514,inst_71529,null));
var state_71625__$1 = state_71625;
var statearr_71636_71705 = state_71625__$1;
(statearr_71636_71705[(2)] = inst_71530);

(statearr_71636_71705[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (21))){
var inst_71534 = (state_71625[(8)]);
var state_71625__$1 = state_71625;
var statearr_71637_71706 = state_71625__$1;
(statearr_71637_71706[(2)] = inst_71534);

(statearr_71637_71706[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (31))){
var inst_71575 = (state_71625[(2)]);
var state_71625__$1 = state_71625;
var statearr_71638_71707 = state_71625__$1;
(statearr_71638_71707[(2)] = inst_71575);

(statearr_71638_71707[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (32))){
var inst_71581 = (state_71625[(10)]);
var inst_71584 = cljs.core.pos_int_QMARK_(inst_71581);
var state_71625__$1 = state_71625;
var statearr_71639_71708 = state_71625__$1;
(statearr_71639_71708[(2)] = inst_71584);

(statearr_71639_71708[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (40))){
var inst_71612 = (state_71625[(13)]);
var inst_71536 = (state_71625[(14)]);
var inst_71610 = (state_71625[(2)]);
var inst_71611 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71610,(0),null);
var inst_71612__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71610,(1),null);
var inst_71613 = (inst_71612__$1 > inst_71536);
var state_71625__$1 = (function (){var statearr_71640 = state_71625;
(statearr_71640[(13)] = inst_71612__$1);

(statearr_71640[(15)] = inst_71611);

return statearr_71640;
})();
if(cljs.core.truth_(inst_71613)){
var statearr_71641_71709 = state_71625__$1;
(statearr_71641_71709[(1)] = (41));

} else {
var statearr_71642_71710 = state_71625__$1;
(statearr_71642_71710[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (33))){
var inst_71582 = (state_71625[(16)]);
var state_71625__$1 = state_71625;
var statearr_71643_71711 = state_71625__$1;
(statearr_71643_71711[(2)] = inst_71582);

(statearr_71643_71711[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (13))){
var inst_71520 = (state_71625[(17)]);
var inst_71522 = fluree.db.time_travel.block_to_int_format(db,inst_71520);
var state_71625__$1 = state_71625;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71625__$1,(16),inst_71522);
} else {
if((state_val_71626 === (22))){
var inst_71553 = (state_71625[(2)]);
var state_71625__$1 = state_71625;
if(cljs.core.truth_(inst_71553)){
var statearr_71644_71712 = state_71625__$1;
(statearr_71644_71712[(1)] = (23));

} else {
var statearr_71645_71713 = state_71625__$1;
(statearr_71645_71713[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (36))){
var state_71625__$1 = state_71625;
var statearr_71646_71714 = state_71625__$1;
(statearr_71646_71714[(2)] = null);

(statearr_71646_71714[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (41))){
var inst_71536 = (state_71625[(14)]);
var state_71625__$1 = state_71625;
var statearr_71647_71715 = state_71625__$1;
(statearr_71647_71715[(2)] = inst_71536);

(statearr_71647_71715[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (43))){
var inst_71611 = (state_71625[(15)]);
var inst_71617 = (state_71625[(2)]);
var inst_71618 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71619 = [inst_71611,inst_71617];
var inst_71620 = (new cljs.core.PersistentVector(null,2,(5),inst_71618,inst_71619,null));
var _ = (function (){var statearr_71648 = state_71625;
(statearr_71648[(4)] = cljs.core.rest((state_71625[(4)])));

return statearr_71648;
})();
var state_71625__$1 = state_71625;
var statearr_71649_71716 = state_71625__$1;
(statearr_71649_71716[(2)] = inst_71620);

(statearr_71649_71716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (29))){
var inst_71511 = (state_71625[(18)]);
var inst_71566 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_71511], 0));
var inst_71567 = ["Invalid block range provided: ",inst_71566].join('');
var inst_71568 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71569 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71570 = cljs.core.PersistentHashMap.fromArrays(inst_71568,inst_71569);
var inst_71571 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_71567,inst_71570);
var inst_71572 = (function(){throw inst_71571})();
var state_71625__$1 = state_71625;
var statearr_71650_71717 = state_71625__$1;
(statearr_71650_71717[(2)] = inst_71572);

(statearr_71650_71717[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (6))){
var inst_71503 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_71625__$1 = state_71625;
var statearr_71651_71718 = state_71625__$1;
(statearr_71651_71718[(2)] = inst_71503);

(statearr_71651_71718[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (28))){
var inst_71577 = (state_71625[(2)]);
var state_71625__$1 = state_71625;
var statearr_71652_71719 = state_71625__$1;
(statearr_71652_71719[(2)] = inst_71577);

(statearr_71652_71719[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (25))){
var inst_71582 = (state_71625[(16)]);
var inst_71580 = (state_71625[(9)]);
var inst_71579 = (state_71625[(2)]);
var inst_71580__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71579,(0),null);
var inst_71581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71579,(1),null);
var inst_71582__$1 = cljs.core.pos_int_QMARK_(inst_71580__$1);
var state_71625__$1 = (function (){var statearr_71653 = state_71625;
(statearr_71653[(16)] = inst_71582__$1);

(statearr_71653[(9)] = inst_71580__$1);

(statearr_71653[(10)] = inst_71581);

return statearr_71653;
})();
if(inst_71582__$1){
var statearr_71654_71720 = state_71625__$1;
(statearr_71654_71720[(1)] = (32));

} else {
var statearr_71655_71721 = state_71625__$1;
(statearr_71655_71721[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (34))){
var inst_71587 = (state_71625[(2)]);
var inst_71588 = cljs.core.not(inst_71587);
var state_71625__$1 = state_71625;
if(inst_71588){
var statearr_71656_71722 = state_71625__$1;
(statearr_71656_71722[(1)] = (35));

} else {
var statearr_71657_71723 = state_71625__$1;
(statearr_71657_71723[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (17))){
var inst_71534 = (state_71625[(8)]);
var inst_71536 = (state_71625[(14)]);
var inst_71539 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_71534], 0));
var inst_71540 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_71536], 0));
var inst_71541 = ["Start block is out of range for this ledger. Start block provided: ",inst_71539,". Database block: ",inst_71540].join('');
var inst_71542 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71543 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71544 = cljs.core.PersistentHashMap.fromArrays(inst_71542,inst_71543);
var inst_71545 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_71541,inst_71544);
var inst_71546 = (function(){throw inst_71545})();
var state_71625__$1 = state_71625;
var statearr_71658_71724 = state_71625__$1;
(statearr_71658_71724[(2)] = inst_71546);

(statearr_71658_71724[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (3))){
var inst_71623 = (state_71625[(2)]);
var state_71625__$1 = state_71625;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71625__$1,inst_71623);
} else {
if((state_val_71626 === (12))){
var inst_71511 = (state_71625[(18)]);
var inst_71520 = (state_71625[(17)]);
var inst_71518 = (state_71625[(2)]);
var inst_71519 = fluree.db.util.async.throw_err(inst_71518);
var inst_71520__$1 = cljs.core.second(inst_71511);
var state_71625__$1 = (function (){var statearr_71659 = state_71625;
(statearr_71659[(11)] = inst_71519);

(statearr_71659[(17)] = inst_71520__$1);

return statearr_71659;
})();
if(cljs.core.truth_(inst_71520__$1)){
var statearr_71660_71725 = state_71625__$1;
(statearr_71660_71725[(1)] = (13));

} else {
var statearr_71661_71726 = state_71625__$1;
(statearr_71661_71726[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (2))){
var _ = (function (){var statearr_71662 = state_71625;
(statearr_71662[(4)] = cljs.core.cons((5),(state_71625[(4)])));

return statearr_71662;
})();
var inst_71500 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_71501 = cljs.core.sequential_QMARK_(inst_71500);
var state_71625__$1 = state_71625;
if(inst_71501){
var statearr_71663_71727 = state_71625__$1;
(statearr_71663_71727[(1)] = (6));

} else {
var statearr_71664_71728 = state_71625__$1;
(statearr_71664_71728[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (23))){
var inst_71534 = (state_71625[(8)]);
var inst_71535 = (state_71625[(7)]);
var inst_71555 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71556 = [inst_71534,inst_71535];
var inst_71557 = (new cljs.core.PersistentVector(null,2,(5),inst_71555,inst_71556,null));
var state_71625__$1 = state_71625;
var statearr_71665_71729 = state_71625__$1;
(statearr_71665_71729[(2)] = inst_71557);

(statearr_71665_71729[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (35))){
var inst_71511 = (state_71625[(18)]);
var inst_71590 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_71511], 0));
var inst_71591 = ["Invalid block range provided: ",inst_71590].join('');
var inst_71592 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71593 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71594 = cljs.core.PersistentHashMap.fromArrays(inst_71592,inst_71593);
var inst_71595 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_71591,inst_71594);
var inst_71596 = (function(){throw inst_71595})();
var state_71625__$1 = state_71625;
var statearr_71666_71730 = state_71625__$1;
(statearr_71666_71730[(2)] = inst_71596);

(statearr_71666_71730[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (19))){
var inst_71534 = (state_71625[(8)]);
var inst_71549 = (state_71625[(2)]);
var state_71625__$1 = (function (){var statearr_71667 = state_71625;
(statearr_71667[(19)] = inst_71549);

return statearr_71667;
})();
if(cljs.core.truth_(inst_71534)){
var statearr_71668_71731 = state_71625__$1;
(statearr_71668_71731[(1)] = (20));

} else {
var statearr_71669_71732 = state_71625__$1;
(statearr_71669_71732[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (11))){
var inst_71534 = (state_71625[(8)]);
var inst_71536 = (state_71625[(14)]);
var inst_71533 = (state_71625[(2)]);
var inst_71534__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71533,(0),null);
var inst_71535 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71533,(1),null);
var inst_71536__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_71537 = (inst_71534__$1 > inst_71536__$1);
var state_71625__$1 = (function (){var statearr_71671 = state_71625;
(statearr_71671[(8)] = inst_71534__$1);

(statearr_71671[(14)] = inst_71536__$1);

(statearr_71671[(7)] = inst_71535);

return statearr_71671;
})();
if(cljs.core.truth_(inst_71537)){
var statearr_71672_71733 = state_71625__$1;
(statearr_71672_71733[(1)] = (17));

} else {
var statearr_71673_71734 = state_71625__$1;
(statearr_71673_71734[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (9))){
var inst_71511 = (state_71625[(18)]);
var inst_71514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71515 = cljs.core.first(inst_71511);
var inst_71516 = fluree.db.time_travel.block_to_int_format(db,inst_71515);
var state_71625__$1 = (function (){var statearr_71674 = state_71625;
(statearr_71674[(12)] = inst_71514);

return statearr_71674;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71625__$1,(12),inst_71516);
} else {
if((state_val_71626 === (5))){
var _ = (function (){var statearr_71675 = state_71625;
(statearr_71675[(4)] = cljs.core.rest((state_71625[(4)])));

return statearr_71675;
})();
var state_71625__$1 = state_71625;
var ex71670 = (state_71625__$1[(2)]);
var statearr_71676_71735 = state_71625__$1;
(statearr_71676_71735[(5)] = ex71670);


if((ex71670 instanceof Error)){
var statearr_71677_71736 = state_71625__$1;
(statearr_71677_71736[(1)] = (4));

(statearr_71677_71736[(5)] = null);

} else {
throw ex71670;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (14))){
var state_71625__$1 = state_71625;
var statearr_71678_71737 = state_71625__$1;
(statearr_71678_71737[(2)] = null);

(statearr_71678_71737[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (26))){
var inst_71534 = (state_71625[(8)]);
var inst_71560 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71561 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_71562 = [inst_71534,inst_71561];
var inst_71563 = (new cljs.core.PersistentVector(null,2,(5),inst_71560,inst_71562,null));
var state_71625__$1 = state_71625;
var statearr_71679_71738 = state_71625__$1;
(statearr_71679_71738[(2)] = inst_71563);

(statearr_71679_71738[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (16))){
var inst_71524 = (state_71625[(2)]);
var inst_71525 = fluree.db.util.async.throw_err(inst_71524);
var state_71625__$1 = state_71625;
var statearr_71680_71739 = state_71625__$1;
(statearr_71680_71739[(2)] = inst_71525);

(statearr_71680_71739[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (38))){
var inst_71580 = (state_71625[(9)]);
var inst_71581 = (state_71625[(10)]);
var inst_71602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71603 = [inst_71581,inst_71580];
var inst_71604 = (new cljs.core.PersistentVector(null,2,(5),inst_71602,inst_71603,null));
var state_71625__$1 = state_71625;
var statearr_71681_71740 = state_71625__$1;
(statearr_71681_71740[(2)] = inst_71604);

(statearr_71681_71740[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (30))){
var state_71625__$1 = state_71625;
var statearr_71682_71741 = state_71625__$1;
(statearr_71682_71741[(2)] = null);

(statearr_71682_71741[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (10))){
var inst_71511 = (state_71625[(18)]);
var state_71625__$1 = state_71625;
var statearr_71683_71742 = state_71625__$1;
(statearr_71683_71742[(2)] = inst_71511);

(statearr_71683_71742[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (18))){
var state_71625__$1 = state_71625;
var statearr_71684_71743 = state_71625__$1;
(statearr_71684_71743[(2)] = null);

(statearr_71684_71743[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (42))){
var inst_71612 = (state_71625[(13)]);
var state_71625__$1 = state_71625;
var statearr_71685_71744 = state_71625__$1;
(statearr_71685_71744[(2)] = inst_71612);

(statearr_71685_71744[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (37))){
var inst_71580 = (state_71625[(9)]);
var inst_71581 = (state_71625[(10)]);
var inst_71599 = (state_71625[(2)]);
var inst_71600 = (inst_71581 < inst_71580);
var state_71625__$1 = (function (){var statearr_71686 = state_71625;
(statearr_71686[(20)] = inst_71599);

return statearr_71686;
})();
if(cljs.core.truth_(inst_71600)){
var statearr_71687_71745 = state_71625__$1;
(statearr_71687_71745[(1)] = (38));

} else {
var statearr_71688_71746 = state_71625__$1;
(statearr_71688_71746[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (8))){
var inst_71511 = (state_71625[(18)]);
var inst_71511__$1 = (state_71625[(2)]);
var inst_71512 = cljs.core.some(cljs.core.string_QMARK_,inst_71511__$1);
var state_71625__$1 = (function (){var statearr_71689 = state_71625;
(statearr_71689[(18)] = inst_71511__$1);

return statearr_71689;
})();
if(cljs.core.truth_(inst_71512)){
var statearr_71690_71747 = state_71625__$1;
(statearr_71690_71747[(1)] = (9));

} else {
var statearr_71691_71748 = state_71625__$1;
(statearr_71691_71748[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__11438__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__11438__auto____0 = (function (){
var statearr_71692 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71692[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__11438__auto__);

(statearr_71692[(1)] = (1));

return statearr_71692;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__11438__auto____1 = (function (state_71625){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_71625);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e71693){var ex__11441__auto__ = e71693;
var statearr_71694_71749 = state_71625;
(statearr_71694_71749[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_71625[(4)]))){
var statearr_71695_71750 = state_71625;
(statearr_71695_71750[(1)] = cljs.core.first((state_71625[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71751 = state_71625;
state_71625 = G__71751;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__11438__auto__ = function(state_71625){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__11438__auto____1.call(this,state_71625);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__11438__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__11438__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_71696 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_71696[(6)] = c__11512__auto__);

return statearr_71696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_71901){
var state_val_71902 = (state_71901[(1)]);
if((state_val_71902 === (7))){
var inst_71813 = (state_71901[(2)]);
var inst_71814 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71813,(0),null);
var inst_71815 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71813,(1),null);
var inst_71823 = cljs.core.vals(inst_71815);
var inst_71824 = cljs.core.seq(inst_71823);
var inst_71825 = cljs.core.first(inst_71824);
var inst_71826 = cljs.core.next(inst_71824);
var inst_71827 = cljs.core.PersistentVector.EMPTY;
var inst_71828 = inst_71823;
var inst_71829 = inst_71827;
var state_71901__$1 = (function (){var statearr_71903 = state_71901;
(statearr_71903[(7)] = inst_71814);

(statearr_71903[(8)] = inst_71829);

(statearr_71903[(9)] = inst_71825);

(statearr_71903[(10)] = inst_71828);

(statearr_71903[(11)] = inst_71826);

return statearr_71903;
})();
var statearr_71904_71957 = state_71901__$1;
(statearr_71904_71957[(2)] = null);

(statearr_71904_71957[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (20))){
var inst_71835 = (state_71901[(12)]);
var inst_71840 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_71841 = cljs.core.PersistentHashMap.EMPTY;
var inst_71842 = [true,inst_71841];
var inst_71843 = cljs.core.PersistentHashMap.fromArrays(inst_71840,inst_71842);
var inst_71844 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_71843,inst_71835);
var state_71901__$1 = state_71901;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71901__$1,(22),inst_71844);
} else {
if((state_val_71902 === (27))){
var inst_71889 = (state_71901[(2)]);
var state_71901__$1 = state_71901;
var statearr_71905_71958 = state_71901__$1;
(statearr_71905_71958[(2)] = inst_71889);

(statearr_71905_71958[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (1))){
var state_71901__$1 = state_71901;
var statearr_71906_71959 = state_71901__$1;
(statearr_71906_71959[(2)] = null);

(statearr_71906_71959[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (24))){
var inst_71853 = (state_71901[(13)]);
var inst_71891 = (state_71901[(2)]);
var inst_71892 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_71893 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_71894 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_71895 = [inst_71893,inst_71894,inst_71853,inst_71891];
var inst_71896 = cljs.core.PersistentHashMap.fromArrays(inst_71892,inst_71895);
var _ = (function (){var statearr_71908 = state_71901;
(statearr_71908[(4)] = cljs.core.rest((state_71901[(4)])));

return statearr_71908;
})();
var state_71901__$1 = state_71901;
var statearr_71909_71960 = state_71901__$1;
(statearr_71909_71960[(2)] = inst_71896);

(statearr_71909_71960[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (4))){
var inst_71754 = (state_71901[(2)]);
var state_71901__$1 = state_71901;
var statearr_71910_71961 = state_71901__$1;
(statearr_71910_71961[(2)] = inst_71754);

(statearr_71910_71961[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (15))){
var inst_71776 = (state_71901[(14)]);
var inst_71785 = (state_71901[(15)]);
var inst_71773 = (state_71901[(16)]);
var inst_71777 = (state_71901[(17)]);
var inst_71784 = (state_71901[(18)]);
var inst_71792 = (state_71901[(19)]);
var inst_71799 = (state_71901[(20)]);
var inst_71794 = (state_71901[(21)]);
var inst_71772 = (state_71901[(22)]);
var inst_71778 = (state_71901[(23)]);
var inst_71770 = (state_71901[(24)]);
var inst_71805 = (function (){var first__71769 = inst_71772;
var vec__71767 = inst_71770;
var subject = inst_71792;
var flake = inst_71784;
var seq__71781 = inst_71785;
var r = inst_71785;
var asserted_subjects = inst_71777;
var flake_SINGLEQUOTE_ = inst_71799;
var retracted_subjects = inst_71778;
var seq__71768 = inst_71773;
var first__71782 = inst_71784;
var G__71766 = inst_71776;
var asserted_QMARK_ = inst_71794;
var vec__71780 = inst_71776;
return (function (p1__71753_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__71753_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_71806 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_71778,inst_71792,inst_71805);
var tmp71907 = inst_71777;
var inst_71776__$1 = inst_71785;
var inst_71777__$1 = tmp71907;
var inst_71778__$1 = inst_71806;
var state_71901__$1 = (function (){var statearr_71911 = state_71901;
(statearr_71911[(14)] = inst_71776__$1);

(statearr_71911[(17)] = inst_71777__$1);

(statearr_71911[(23)] = inst_71778__$1);

return statearr_71911;
})();
var statearr_71912_71962 = state_71901__$1;
(statearr_71912_71962[(2)] = null);

(statearr_71912_71962[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (21))){
var inst_71851 = (state_71901[(2)]);
var state_71901__$1 = state_71901;
var statearr_71913_71963 = state_71901__$1;
(statearr_71913_71963[(2)] = inst_71851);

(statearr_71913_71963[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (13))){
var inst_71794 = (state_71901[(21)]);
var inst_71799 = (state_71901[(2)]);
var state_71901__$1 = (function (){var statearr_71914 = state_71901;
(statearr_71914[(20)] = inst_71799);

return statearr_71914;
})();
if(cljs.core.truth_(inst_71794)){
var statearr_71915_71964 = state_71901__$1;
(statearr_71915_71964[(1)] = (14));

} else {
var statearr_71916_71965 = state_71901__$1;
(statearr_71916_71965[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (22))){
var inst_71829 = (state_71901[(8)]);
var inst_71836 = (state_71901[(25)]);
var inst_71846 = (state_71901[(2)]);
var inst_71847 = fluree.db.util.async.throw_err(inst_71846);
var inst_71848 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_71829,inst_71847);
var inst_71828 = inst_71836;
var inst_71829__$1 = inst_71848;
var state_71901__$1 = (function (){var statearr_71917 = state_71901;
(statearr_71917[(8)] = inst_71829__$1);

(statearr_71917[(10)] = inst_71828);

return statearr_71917;
})();
var statearr_71918_71966 = state_71901__$1;
(statearr_71918_71966[(2)] = null);

(statearr_71918_71966[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (6))){
var inst_71776 = (state_71901[(14)]);
var inst_71784 = (state_71901[(18)]);
var inst_71783 = cljs.core.seq(inst_71776);
var inst_71784__$1 = cljs.core.first(inst_71783);
var inst_71785 = cljs.core.next(inst_71783);
var inst_71786 = cljs.core.not(inst_71784__$1);
var state_71901__$1 = (function (){var statearr_71919 = state_71901;
(statearr_71919[(15)] = inst_71785);

(statearr_71919[(18)] = inst_71784__$1);

return statearr_71919;
})();
if(inst_71786){
var statearr_71920_71967 = state_71901__$1;
(statearr_71920_71967[(1)] = (8));

} else {
var statearr_71921_71968 = state_71901__$1;
(statearr_71921_71968[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (28))){
var inst_71874 = (state_71901[(26)]);
var inst_71867 = (state_71901[(27)]);
var inst_71884 = (state_71901[(2)]);
var inst_71885 = fluree.db.util.async.throw_err(inst_71884);
var inst_71886 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_71867,inst_71885);
var inst_71866 = inst_71874;
var inst_71867__$1 = inst_71886;
var state_71901__$1 = (function (){var statearr_71922 = state_71901;
(statearr_71922[(27)] = inst_71867__$1);

(statearr_71922[(28)] = inst_71866);

return statearr_71922;
})();
var statearr_71923_71969 = state_71901__$1;
(statearr_71923_71969[(2)] = null);

(statearr_71923_71969[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (25))){
var inst_71867 = (state_71901[(27)]);
var state_71901__$1 = state_71901;
var statearr_71924_71970 = state_71901__$1;
(statearr_71924_71970[(2)] = inst_71867);

(statearr_71924_71970[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (17))){
var inst_71835 = (state_71901[(12)]);
var inst_71828 = (state_71901[(10)]);
var inst_71834 = cljs.core.seq(inst_71828);
var inst_71835__$1 = cljs.core.first(inst_71834);
var inst_71836 = cljs.core.next(inst_71834);
var inst_71837 = cljs.core.not(inst_71835__$1);
var state_71901__$1 = (function (){var statearr_71925 = state_71901;
(statearr_71925[(12)] = inst_71835__$1);

(statearr_71925[(25)] = inst_71836);

return statearr_71925;
})();
if(inst_71837){
var statearr_71926_71971 = state_71901__$1;
(statearr_71926_71971[(1)] = (19));

} else {
var statearr_71927_71972 = state_71901__$1;
(statearr_71927_71972[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (3))){
var inst_71899 = (state_71901[(2)]);
var state_71901__$1 = state_71901;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71901__$1,inst_71899);
} else {
if((state_val_71902 === (12))){
var inst_71784 = (state_71901[(18)]);
var inst_71797 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_71784);
var state_71901__$1 = state_71901;
var statearr_71928_71973 = state_71901__$1;
(statearr_71928_71973[(2)] = inst_71797);

(statearr_71928_71973[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (2))){
var inst_71770 = (state_71901[(24)]);
var _ = (function (){var statearr_71929 = state_71901;
(statearr_71929[(4)] = cljs.core.cons((5),(state_71901[(4)])));

return statearr_71929;
})();
var inst_71770__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_71771 = cljs.core.seq(inst_71770__$1);
var inst_71772 = cljs.core.first(inst_71771);
var inst_71773 = cljs.core.next(inst_71771);
var inst_71774 = cljs.core.PersistentHashMap.EMPTY;
var inst_71775 = cljs.core.PersistentHashMap.EMPTY;
var inst_71776 = inst_71770__$1;
var inst_71777 = inst_71774;
var inst_71778 = inst_71775;
var state_71901__$1 = (function (){var statearr_71930 = state_71901;
(statearr_71930[(14)] = inst_71776);

(statearr_71930[(16)] = inst_71773);

(statearr_71930[(17)] = inst_71777);

(statearr_71930[(22)] = inst_71772);

(statearr_71930[(23)] = inst_71778);

(statearr_71930[(24)] = inst_71770__$1);

return statearr_71930;
})();
var statearr_71931_71974 = state_71901__$1;
(statearr_71931_71974[(2)] = null);

(statearr_71931_71974[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (23))){
var inst_71866 = (state_71901[(28)]);
var inst_71873 = (state_71901[(29)]);
var inst_71872 = cljs.core.seq(inst_71866);
var inst_71873__$1 = cljs.core.first(inst_71872);
var inst_71874 = cljs.core.next(inst_71872);
var inst_71875 = cljs.core.not(inst_71873__$1);
var state_71901__$1 = (function (){var statearr_71932 = state_71901;
(statearr_71932[(26)] = inst_71874);

(statearr_71932[(29)] = inst_71873__$1);

return statearr_71932;
})();
if(inst_71875){
var statearr_71933_71975 = state_71901__$1;
(statearr_71933_71975[(1)] = (25));

} else {
var statearr_71934_71976 = state_71901__$1;
(statearr_71934_71976[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (19))){
var inst_71829 = (state_71901[(8)]);
var state_71901__$1 = state_71901;
var statearr_71935_71977 = state_71901__$1;
(statearr_71935_71977[(2)] = inst_71829);

(statearr_71935_71977[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (11))){
var inst_71784 = (state_71901[(18)]);
var state_71901__$1 = state_71901;
var statearr_71937_71978 = state_71901__$1;
(statearr_71937_71978[(2)] = inst_71784);

(statearr_71937_71978[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (9))){
var inst_71784 = (state_71901[(18)]);
var inst_71794 = (state_71901[(21)]);
var inst_71792 = inst_71784.s;
var inst_71793 = inst_71784.op;
var inst_71794__$1 = inst_71793 === true;
var state_71901__$1 = (function (){var statearr_71939 = state_71901;
(statearr_71939[(19)] = inst_71792);

(statearr_71939[(21)] = inst_71794__$1);

return statearr_71939;
})();
if(cljs.core.truth_(inst_71794__$1)){
var statearr_71940_71979 = state_71901__$1;
(statearr_71940_71979[(1)] = (11));

} else {
var statearr_71941_71980 = state_71901__$1;
(statearr_71941_71980[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (5))){
var _ = (function (){var statearr_71942 = state_71901;
(statearr_71942[(4)] = cljs.core.rest((state_71901[(4)])));

return statearr_71942;
})();
var state_71901__$1 = state_71901;
var ex71936 = (state_71901__$1[(2)]);
var statearr_71943_71981 = state_71901__$1;
(statearr_71943_71981[(5)] = ex71936);


if((ex71936 instanceof Error)){
var statearr_71944_71982 = state_71901__$1;
(statearr_71944_71982[(1)] = (4));

(statearr_71944_71982[(5)] = null);

} else {
throw ex71936;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (14))){
var inst_71776 = (state_71901[(14)]);
var inst_71785 = (state_71901[(15)]);
var inst_71773 = (state_71901[(16)]);
var inst_71777 = (state_71901[(17)]);
var inst_71784 = (state_71901[(18)]);
var inst_71792 = (state_71901[(19)]);
var inst_71799 = (state_71901[(20)]);
var inst_71794 = (state_71901[(21)]);
var inst_71772 = (state_71901[(22)]);
var inst_71778 = (state_71901[(23)]);
var inst_71770 = (state_71901[(24)]);
var inst_71801 = (function (){var first__71769 = inst_71772;
var vec__71767 = inst_71770;
var subject = inst_71792;
var flake = inst_71784;
var seq__71781 = inst_71785;
var r = inst_71785;
var asserted_subjects = inst_71777;
var flake_SINGLEQUOTE_ = inst_71799;
var retracted_subjects = inst_71778;
var seq__71768 = inst_71773;
var first__71782 = inst_71784;
var G__71766 = inst_71776;
var asserted_QMARK_ = inst_71794;
var vec__71780 = inst_71776;
return (function (p1__71752_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__71752_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_71802 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_71777,inst_71792,inst_71801);
var tmp71938 = inst_71778;
var inst_71776__$1 = inst_71785;
var inst_71777__$1 = inst_71802;
var inst_71778__$1 = tmp71938;
var state_71901__$1 = (function (){var statearr_71945 = state_71901;
(statearr_71945[(14)] = inst_71776__$1);

(statearr_71945[(17)] = inst_71777__$1);

(statearr_71945[(23)] = inst_71778__$1);

return statearr_71945;
})();
var statearr_71946_71983 = state_71901__$1;
(statearr_71946_71983[(2)] = null);

(statearr_71946_71983[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (26))){
var inst_71873 = (state_71901[(29)]);
var inst_71878 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_71879 = cljs.core.PersistentHashMap.EMPTY;
var inst_71880 = [true,inst_71879];
var inst_71881 = cljs.core.PersistentHashMap.fromArrays(inst_71878,inst_71880);
var inst_71882 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_71881,inst_71873);
var state_71901__$1 = state_71901;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71901__$1,(28),inst_71882);
} else {
if((state_val_71902 === (16))){
var inst_71809 = (state_71901[(2)]);
var state_71901__$1 = state_71901;
var statearr_71947_71984 = state_71901__$1;
(statearr_71947_71984[(2)] = inst_71809);

(statearr_71947_71984[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (10))){
var inst_71811 = (state_71901[(2)]);
var state_71901__$1 = state_71901;
var statearr_71948_71985 = state_71901__$1;
(statearr_71948_71985[(2)] = inst_71811);

(statearr_71948_71985[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (18))){
var inst_71814 = (state_71901[(7)]);
var inst_71853 = (state_71901[(2)]);
var inst_71861 = cljs.core.vals(inst_71814);
var inst_71862 = cljs.core.seq(inst_71861);
var inst_71863 = cljs.core.first(inst_71862);
var inst_71864 = cljs.core.next(inst_71862);
var inst_71865 = cljs.core.PersistentVector.EMPTY;
var inst_71866 = inst_71861;
var inst_71867 = inst_71865;
var state_71901__$1 = (function (){var statearr_71949 = state_71901;
(statearr_71949[(27)] = inst_71867);

(statearr_71949[(13)] = inst_71853);

(statearr_71949[(28)] = inst_71866);

(statearr_71949[(30)] = inst_71864);

(statearr_71949[(31)] = inst_71863);

return statearr_71949;
})();
var statearr_71950_71986 = state_71901__$1;
(statearr_71950_71986[(2)] = null);

(statearr_71950_71986[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71902 === (8))){
var inst_71777 = (state_71901[(17)]);
var inst_71778 = (state_71901[(23)]);
var inst_71788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71789 = [inst_71777,inst_71778];
var inst_71790 = (new cljs.core.PersistentVector(null,2,(5),inst_71788,inst_71789,null));
var state_71901__$1 = state_71901;
var statearr_71951_71987 = state_71901__$1;
(statearr_71951_71987[(2)] = inst_71790);

(statearr_71951_71987[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__11438__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__11438__auto____0 = (function (){
var statearr_71952 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71952[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__11438__auto__);

(statearr_71952[(1)] = (1));

return statearr_71952;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__11438__auto____1 = (function (state_71901){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_71901);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e71953){var ex__11441__auto__ = e71953;
var statearr_71954_71988 = state_71901;
(statearr_71954_71988[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_71901[(4)]))){
var statearr_71955_71989 = state_71901;
(statearr_71955_71989[(1)] = cljs.core.first((state_71901[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71990 = state_71901;
state_71901 = G__71990;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__11438__auto__ = function(state_71901){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__11438__auto____1.call(this,state_71901);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__11438__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__11438__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_71956 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_71956[(6)] = c__11512__auto__);

return statearr_71956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_72022){
var state_val_72023 = (state_72022[(1)]);
if((state_val_72023 === (1))){
var inst_71991 = cljs.core.volatile_BANG_((0));
var inst_71992 = cljs.core.PersistentHashMap.EMPTY;
var inst_71993 = cljs.core.volatile_BANG_(inst_71992);
var inst_71994 = cljs.core.first(resp);
var inst_71995 = cljs.core.rest(resp);
var inst_71996 = cljs.core.PersistentVector.EMPTY;
var inst_71997 = inst_71991;
var inst_71998 = inst_71993;
var inst_71999 = inst_71994;
var inst_72000 = inst_71995;
var inst_72001 = inst_71996;
var state_72022__$1 = (function (){var statearr_72024 = state_72022;
(statearr_72024[(7)] = inst_71997);

(statearr_72024[(8)] = inst_71998);

(statearr_72024[(9)] = inst_72000);

(statearr_72024[(10)] = inst_72001);

(statearr_72024[(11)] = inst_71999);

return statearr_72024;
})();
var statearr_72025_72040 = state_72022__$1;
(statearr_72025_72040[(2)] = null);

(statearr_72025_72040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72023 === (2))){
var inst_71997 = (state_72022[(7)]);
var inst_71998 = (state_72022[(8)]);
var inst_71999 = (state_72022[(11)]);
var inst_72003 = fluree.db.api.query.format_block_resp_pretty(db,inst_71999,inst_71998,inst_71997);
var state_72022__$1 = state_72022;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72022__$1,(4),inst_72003);
} else {
if((state_val_72023 === (3))){
var inst_72020 = (state_72022[(2)]);
var state_72022__$1 = state_72022;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72022__$1,inst_72020);
} else {
if((state_val_72023 === (4))){
var inst_72000 = (state_72022[(9)]);
var inst_72001 = (state_72022[(10)]);
var inst_72005 = (state_72022[(2)]);
var inst_72006 = fluree.db.util.async.throw_err(inst_72005);
var inst_72007 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72008 = [inst_72006];
var inst_72009 = (new cljs.core.PersistentVector(null,1,(5),inst_72007,inst_72008,null));
var inst_72010 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_72001,inst_72009);
var inst_72011 = cljs.core.first(inst_72000);
var state_72022__$1 = (function (){var statearr_72028 = state_72022;
(statearr_72028[(12)] = inst_72010);

return statearr_72028;
})();
if(cljs.core.truth_(inst_72011)){
var statearr_72029_72041 = state_72022__$1;
(statearr_72029_72041[(1)] = (5));

} else {
var statearr_72030_72042 = state_72022__$1;
(statearr_72030_72042[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72023 === (5))){
var inst_72010 = (state_72022[(12)]);
var inst_71997 = (state_72022[(7)]);
var inst_71998 = (state_72022[(8)]);
var inst_72000 = (state_72022[(9)]);
var inst_72013 = cljs.core.first(inst_72000);
var inst_72014 = cljs.core.rest(inst_72000);
var tmp72026 = inst_71997;
var tmp72027 = inst_71998;
var inst_71997__$1 = tmp72026;
var inst_71998__$1 = tmp72027;
var inst_71999 = inst_72013;
var inst_72000__$1 = inst_72014;
var inst_72001 = inst_72010;
var state_72022__$1 = (function (){var statearr_72031 = state_72022;
(statearr_72031[(7)] = inst_71997__$1);

(statearr_72031[(8)] = inst_71998__$1);

(statearr_72031[(9)] = inst_72000__$1);

(statearr_72031[(10)] = inst_72001);

(statearr_72031[(11)] = inst_71999);

return statearr_72031;
})();
var statearr_72032_72043 = state_72022__$1;
(statearr_72032_72043[(2)] = null);

(statearr_72032_72043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72023 === (6))){
var inst_72010 = (state_72022[(12)]);
var state_72022__$1 = state_72022;
var statearr_72033_72044 = state_72022__$1;
(statearr_72033_72044[(2)] = inst_72010);

(statearr_72033_72044[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72023 === (7))){
var inst_72018 = (state_72022[(2)]);
var state_72022__$1 = state_72022;
var statearr_72034_72045 = state_72022__$1;
(statearr_72034_72045[(2)] = inst_72018);

(statearr_72034_72045[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11438__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11438__auto____0 = (function (){
var statearr_72035 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72035[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11438__auto__);

(statearr_72035[(1)] = (1));

return statearr_72035;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11438__auto____1 = (function (state_72022){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_72022);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e72036){var ex__11441__auto__ = e72036;
var statearr_72037_72046 = state_72022;
(statearr_72037_72046[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_72022[(4)]))){
var statearr_72038_72047 = state_72022;
(statearr_72038_72047[(1)] = cljs.core.first((state_72022[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72048 = state_72022;
state_72022 = G__72048;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11438__auto__ = function(state_72022){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11438__auto____1.call(this,state_72022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11438__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11438__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_72039 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_72039[(6)] = c__11512__auto__);

return statearr_72039;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__72050 = arguments.length;
switch (G__72050) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__72052){
var map__72053 = p__72052;
var map__72053__$1 = cljs.core.__destructure_map(map__72053);
var query = map__72053__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72053__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_72138){
var state_val_72139 = (state_72138[(1)]);
if((state_val_72139 === (7))){
var inst_72064 = (state_72138[(7)]);
var inst_72068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72069 = ["_auth/id",inst_72064];
var inst_72070 = (new cljs.core.PersistentVector(null,2,(5),inst_72068,inst_72069,null));
var state_72138__$1 = state_72138;
var statearr_72140_72184 = state_72138__$1;
(statearr_72140_72184[(2)] = inst_72070);

(statearr_72140_72184[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (20))){
var inst_72118 = (state_72138[(2)]);
var inst_72119 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_72138__$1 = (function (){var statearr_72141 = state_72138;
(statearr_72141[(8)] = inst_72118);

return statearr_72141;
})();
if(cljs.core.truth_(inst_72119)){
var statearr_72142_72185 = state_72138__$1;
(statearr_72142_72185[(1)] = (22));

} else {
var statearr_72143_72186 = state_72138__$1;
(statearr_72143_72186[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (27))){
var inst_72121 = (state_72138[(9)]);
var inst_72065 = (state_72138[(10)]);
var inst_72127 = (state_72138[(2)]);
var inst_72128 = fluree.db.util.core.response_time_formatted(inst_72065);
var inst_72129 = [(200),inst_72127,(100),inst_72128];
var inst_72130 = cljs.core.PersistentHashMap.fromArrays(inst_72121,inst_72129);
var state_72138__$1 = state_72138;
var statearr_72144_72187 = state_72138__$1;
(statearr_72144_72187[(2)] = inst_72130);

(statearr_72144_72187[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (1))){
var state_72138__$1 = state_72138;
var statearr_72145_72188 = state_72138__$1;
(statearr_72145_72188[(2)] = null);

(statearr_72145_72188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (24))){
var inst_72133 = (state_72138[(2)]);
var _ = (function (){var statearr_72146 = state_72138;
(statearr_72146[(4)] = cljs.core.rest((state_72138[(4)])));

return statearr_72146;
})();
var state_72138__$1 = state_72138;
var statearr_72147_72189 = state_72138__$1;
(statearr_72147_72189[(2)] = inst_72133);

(statearr_72147_72189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (4))){
var inst_72054 = (state_72138[(2)]);
var state_72138__$1 = state_72138;
var statearr_72148_72190 = state_72138__$1;
(statearr_72148_72190[(2)] = inst_72054);

(statearr_72148_72190[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (15))){
var inst_72105 = (state_72138[(11)]);
var state_72138__$1 = state_72138;
var statearr_72149_72191 = state_72138__$1;
(statearr_72149_72191[(2)] = inst_72105);

(statearr_72149_72191[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (21))){
var inst_72114 = (state_72138[(2)]);
var inst_72115 = fluree.db.util.async.throw_err(inst_72114);
var state_72138__$1 = state_72138;
var statearr_72150_72192 = state_72138__$1;
(statearr_72150_72192[(2)] = inst_72115);

(statearr_72150_72192[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (13))){
var inst_72063 = (state_72138[(12)]);
var inst_72105 = (state_72138[(11)]);
var inst_72104 = (state_72138[(2)]);
var inst_72105__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_72063);
var state_72138__$1 = (function (){var statearr_72151 = state_72138;
(statearr_72151[(13)] = inst_72104);

(statearr_72151[(11)] = inst_72105__$1);

return statearr_72151;
})();
if(cljs.core.truth_(inst_72105__$1)){
var statearr_72152_72193 = state_72138__$1;
(statearr_72152_72193[(1)] = (15));

} else {
var statearr_72153_72194 = state_72138__$1;
(statearr_72153_72194[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (22))){
var inst_72118 = (state_72138[(8)]);
var inst_72121 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_72122 = cljs.core.sequential_QMARK_(inst_72118);
var state_72138__$1 = (function (){var statearr_72154 = state_72138;
(statearr_72154[(9)] = inst_72121);

return statearr_72154;
})();
if(inst_72122){
var statearr_72155_72195 = state_72138__$1;
(statearr_72155_72195[(1)] = (25));

} else {
var statearr_72156_72196 = state_72138__$1;
(statearr_72156_72196[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (6))){
var inst_72063 = (state_72138[(12)]);
var inst_72079 = (state_72138[(14)]);
var inst_72078 = (state_72138[(2)]);
var inst_72079__$1 = fluree.db.util.async.throw_err(inst_72078);
var inst_72080 = fluree.db.api.query.resolve_block_range(inst_72079__$1,inst_72063);
var state_72138__$1 = (function (){var statearr_72157 = state_72138;
(statearr_72157[(14)] = inst_72079__$1);

return statearr_72157;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72138__$1,(10),inst_72080);
} else {
if((state_val_72139 === (25))){
var inst_72118 = (state_72138[(8)]);
var inst_72124 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_72118);
var state_72138__$1 = state_72138;
var statearr_72158_72197 = state_72138__$1;
(statearr_72158_72197[(2)] = inst_72124);

(statearr_72158_72197[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (17))){
var inst_72110 = (state_72138[(2)]);
var state_72138__$1 = state_72138;
if(cljs.core.truth_(inst_72110)){
var statearr_72159_72198 = state_72138__$1;
(statearr_72159_72198[(1)] = (18));

} else {
var statearr_72160_72199 = state_72138__$1;
(statearr_72160_72199[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (3))){
var inst_72136 = (state_72138[(2)]);
var state_72138__$1 = state_72138;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72138__$1,inst_72136);
} else {
if((state_val_72139 === (12))){
var inst_72063 = (state_72138[(12)]);
var inst_72096 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_72063], 0));
var inst_72097 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_72096].join('');
var inst_72098 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72099 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72100 = cljs.core.PersistentHashMap.fromArrays(inst_72098,inst_72099);
var inst_72101 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_72097,inst_72100);
var inst_72102 = (function(){throw inst_72101})();
var state_72138__$1 = state_72138;
var statearr_72161_72200 = state_72138__$1;
(statearr_72161_72200[(2)] = inst_72102);

(statearr_72161_72200[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (2))){
var inst_72064 = (state_72138[(7)]);
var _ = (function (){var statearr_72162 = state_72138;
(statearr_72162[(4)] = cljs.core.cons((5),(state_72138[(4)])));

return statearr_72162;
})();
var inst_72063 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_72064__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_72065 = fluree.db.util.core.current_time_millis();
var inst_72066 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_72138__$1 = (function (){var statearr_72163 = state_72138;
(statearr_72163[(15)] = inst_72066);

(statearr_72163[(10)] = inst_72065);

(statearr_72163[(12)] = inst_72063);

(statearr_72163[(7)] = inst_72064__$1);

return statearr_72163;
})();
if(cljs.core.truth_(inst_72064__$1)){
var statearr_72164_72201 = state_72138__$1;
(statearr_72164_72201[(1)] = (7));

} else {
var statearr_72165_72202 = state_72138__$1;
(statearr_72165_72202[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (23))){
var inst_72118 = (state_72138[(8)]);
var state_72138__$1 = state_72138;
var statearr_72166_72203 = state_72138__$1;
(statearr_72166_72203[(2)] = inst_72118);

(statearr_72166_72203[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (19))){
var inst_72104 = (state_72138[(13)]);
var state_72138__$1 = state_72138;
var statearr_72167_72204 = state_72138__$1;
(statearr_72167_72204[(2)] = inst_72104);

(statearr_72167_72204[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (11))){
var inst_72085 = (state_72138[(16)]);
var inst_72079 = (state_72138[(14)]);
var inst_72084 = (state_72138[(17)]);
var inst_72091 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_72079,inst_72084,inst_72085,opts);
var state_72138__$1 = state_72138;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72138__$1,(14),inst_72091);
} else {
if((state_val_72139 === (9))){
var inst_72066 = (state_72138[(15)]);
var inst_72073 = (state_72138[(2)]);
var inst_72074 = [inst_72073];
var inst_72075 = cljs.core.PersistentHashMap.fromArrays(inst_72066,inst_72074);
var inst_72076 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_72075);
var state_72138__$1 = state_72138;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72138__$1,(6),inst_72076);
} else {
if((state_val_72139 === (5))){
var _ = (function (){var statearr_72169 = state_72138;
(statearr_72169[(4)] = cljs.core.rest((state_72138[(4)])));

return statearr_72169;
})();
var state_72138__$1 = state_72138;
var ex72168 = (state_72138__$1[(2)]);
var statearr_72170_72205 = state_72138__$1;
(statearr_72170_72205[(5)] = ex72168);


if((ex72168 instanceof Error)){
var statearr_72171_72206 = state_72138__$1;
(statearr_72171_72206[(1)] = (4));

(statearr_72171_72206[(5)] = null);

} else {
throw ex72168;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (14))){
var inst_72093 = (state_72138[(2)]);
var inst_72094 = fluree.db.util.async.throw_err(inst_72093);
var state_72138__$1 = state_72138;
var statearr_72172_72207 = state_72138__$1;
(statearr_72172_72207[(2)] = inst_72094);

(statearr_72172_72207[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (26))){
var inst_72118 = (state_72138[(8)]);
var state_72138__$1 = state_72138;
var statearr_72173_72208 = state_72138__$1;
(statearr_72173_72208[(2)] = inst_72118);

(statearr_72173_72208[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (16))){
var inst_72063 = (state_72138[(12)]);
var inst_72108 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_72063);
var state_72138__$1 = state_72138;
var statearr_72174_72209 = state_72138__$1;
(statearr_72174_72209[(2)] = inst_72108);

(statearr_72174_72209[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (10))){
var inst_72063 = (state_72138[(12)]);
var inst_72082 = (state_72138[(2)]);
var inst_72083 = fluree.db.util.async.throw_err(inst_72082);
var inst_72084 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72083,(0),null);
var inst_72085 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72083,(1),null);
var inst_72086 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_72087 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_72063,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_72088 = cljs.core.keys(inst_72087);
var inst_72089 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72086,inst_72088);
var state_72138__$1 = (function (){var statearr_72175 = state_72138;
(statearr_72175[(16)] = inst_72085);

(statearr_72175[(17)] = inst_72084);

return statearr_72175;
})();
if(inst_72089){
var statearr_72176_72210 = state_72138__$1;
(statearr_72176_72210[(1)] = (11));

} else {
var statearr_72177_72211 = state_72138__$1;
(statearr_72177_72211[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72139 === (18))){
var inst_72104 = (state_72138[(13)]);
var inst_72079 = (state_72138[(14)]);
var inst_72112 = fluree.db.api.query.format_blocks_resp_pretty(inst_72079,inst_72104);
var state_72138__$1 = state_72138;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72138__$1,(21),inst_72112);
} else {
if((state_val_72139 === (8))){
var state_72138__$1 = state_72138;
var statearr_72178_72212 = state_72138__$1;
(statearr_72178_72212[(2)] = null);

(statearr_72178_72212[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__11438__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__11438__auto____0 = (function (){
var statearr_72179 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72179[(0)] = fluree$db$api$query$block_query_async_$_state_machine__11438__auto__);

(statearr_72179[(1)] = (1));

return statearr_72179;
});
var fluree$db$api$query$block_query_async_$_state_machine__11438__auto____1 = (function (state_72138){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_72138);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e72180){var ex__11441__auto__ = e72180;
var statearr_72181_72213 = state_72138;
(statearr_72181_72213[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_72138[(4)]))){
var statearr_72182_72214 = state_72138;
(statearr_72182_72214[(1)] = cljs.core.first((state_72138[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72215 = state_72138;
state_72138 = G__72215;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__11438__auto__ = function(state_72138){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__11438__auto____1.call(this,state_72138);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__11438__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__11438__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_72183 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_72183[(6)] = c__11512__auto__);

return statearr_72183;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__72216 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72216,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72216,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72216,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72216,(3),null);
var vec__72219 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72219,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72219,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__72222 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72222,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72222,(1),null);
var or__5045__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5774__auto__ = [];
var len__5768__auto___72226 = arguments.length;
var i__5769__auto___72227 = (0);
while(true){
if((i__5769__auto___72227 < len__5768__auto___72226)){
args__5774__auto__.push((arguments[i__5769__auto___72227]));

var G__72228 = (i__5769__auto___72227 + (1));
i__5769__auto___72227 = G__72228;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq72225){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq72225));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_72424){
var state_val_72425 = (state_72424[(1)]);
if((state_val_72425 === (7))){
var inst_72351 = (state_72424[(7)]);
var inst_72344 = (state_72424[(8)]);
var inst_72350 = cljs.core.seq(inst_72344);
var inst_72351__$1 = cljs.core.first(inst_72350);
var inst_72352 = cljs.core.next(inst_72350);
var state_72424__$1 = (function (){var statearr_72426 = state_72424;
(statearr_72426[(7)] = inst_72351__$1);

(statearr_72426[(9)] = inst_72352);

return statearr_72426;
})();
if(cljs.core.truth_(inst_72351__$1)){
var statearr_72427_72527 = state_72424__$1;
(statearr_72427_72527[(1)] = (9));

} else {
var statearr_72428_72528 = state_72424__$1;
(statearr_72428_72528[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (20))){
var inst_72414 = (state_72424[(2)]);
var state_72424__$1 = state_72424;
var statearr_72429_72529 = state_72424__$1;
(statearr_72429_72529[(2)] = inst_72414);

(statearr_72429_72529[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (27))){
var inst_72369 = (state_72424[(10)]);
var inst_72372 = (state_72424[(11)]);
var inst_72390 = (state_72424[(12)]);
var inst_72392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72393 = [inst_72372,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_72394 = (new cljs.core.PersistentVector(null,2,(5),inst_72392,inst_72393,null));
var inst_72395 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_72390,inst_72394,fluree.db.api.query.min_safe,inst_72369);
var state_72424__$1 = state_72424;
var statearr_72430_72530 = state_72424__$1;
(statearr_72430_72530[(2)] = inst_72395);

(statearr_72430_72530[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (1))){
var state_72424__$1 = state_72424;
var statearr_72431_72531 = state_72424__$1;
(statearr_72431_72531[(2)] = null);

(statearr_72431_72531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (24))){
var inst_72351 = (state_72424[(7)]);
var inst_72382 = (state_72424[(13)]);
var inst_72372 = (state_72424[(11)]);
var inst_72384 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72385 = [inst_72372,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_72386 = (new cljs.core.PersistentVector(null,2,(5),inst_72384,inst_72385,null));
var inst_72387 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_72382,inst_72386,cljs.core.conj,inst_72351);
var state_72424__$1 = state_72424;
var statearr_72433_72532 = state_72424__$1;
(statearr_72433_72532[(2)] = inst_72387);

(statearr_72433_72532[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (4))){
var inst_72230 = (state_72424[(2)]);
var state_72424__$1 = state_72424;
var statearr_72434_72533 = state_72424__$1;
(statearr_72434_72533[(2)] = inst_72230);

(statearr_72434_72533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (15))){
var inst_72352 = (state_72424[(9)]);
var inst_72345 = (state_72424[(14)]);
var tmp72432 = inst_72345;
var inst_72344 = inst_72352;
var inst_72345__$1 = tmp72432;
var state_72424__$1 = (function (){var statearr_72435 = state_72424;
(statearr_72435[(8)] = inst_72344);

(statearr_72435[(14)] = inst_72345__$1);

return statearr_72435;
})();
var statearr_72436_72534 = state_72424__$1;
(statearr_72436_72534[(2)] = null);

(statearr_72436_72534[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (21))){
var inst_72372 = (state_72424[(11)]);
var inst_72345 = (state_72424[(14)]);
var inst_72376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72377 = [inst_72372,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_72378 = (new cljs.core.PersistentVector(null,2,(5),inst_72376,inst_72377,null));
var inst_72379 = cljs.core.assoc_in(inst_72345,inst_72378,inst_72372);
var state_72424__$1 = state_72424;
var statearr_72437_72535 = state_72424__$1;
(statearr_72437_72535[(2)] = inst_72379);

(statearr_72437_72535[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (31))){
var inst_72398 = (state_72424[(15)]);
var state_72424__$1 = state_72424;
var statearr_72438_72536 = state_72424__$1;
(statearr_72438_72536[(2)] = inst_72398);

(statearr_72438_72536[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (32))){
var inst_72352 = (state_72424[(9)]);
var inst_72406 = (state_72424[(2)]);
var inst_72344 = inst_72352;
var inst_72345 = inst_72406;
var state_72424__$1 = (function (){var statearr_72439 = state_72424;
(statearr_72439[(8)] = inst_72344);

(statearr_72439[(14)] = inst_72345);

return statearr_72439;
})();
var statearr_72440_72537 = state_72424__$1;
(statearr_72440_72537[(2)] = null);

(statearr_72440_72537[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (33))){
var inst_72345 = (state_72424[(14)]);
var state_72424__$1 = state_72424;
var statearr_72441_72538 = state_72424__$1;
(statearr_72441_72538[(2)] = inst_72345);

(statearr_72441_72538[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (13))){
var inst_72354 = (state_72424[(16)]);
var state_72424__$1 = state_72424;
var statearr_72442_72539 = state_72424__$1;
(statearr_72442_72539[(2)] = inst_72354);

(statearr_72442_72539[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (22))){
var inst_72345 = (state_72424[(14)]);
var state_72424__$1 = state_72424;
var statearr_72443_72540 = state_72424__$1;
(statearr_72443_72540[(2)] = inst_72345);

(statearr_72443_72540[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (29))){
var inst_72398 = (state_72424[(2)]);
var state_72424__$1 = (function (){var statearr_72444 = state_72424;
(statearr_72444[(15)] = inst_72398);

return statearr_72444;
})();
if(cljs.core.truth_(show_auth)){
var statearr_72445_72541 = state_72424__$1;
(statearr_72445_72541[(1)] = (30));

} else {
var statearr_72446_72542 = state_72424__$1;
(statearr_72446_72542[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (6))){
var inst_72330 = (state_72424[(2)]);
var inst_72331 = fluree.db.util.async.throw_err(inst_72330);
var inst_72339 = resp;
var inst_72340 = cljs.core.seq(inst_72339);
var inst_72341 = cljs.core.first(inst_72340);
var inst_72342 = cljs.core.next(inst_72340);
var inst_72343 = cljs.core.PersistentHashMap.EMPTY;
var inst_72344 = inst_72339;
var inst_72345 = inst_72343;
var state_72424__$1 = (function (){var statearr_72447 = state_72424;
(statearr_72447[(17)] = inst_72331);

(statearr_72447[(18)] = inst_72341);

(statearr_72447[(8)] = inst_72344);

(statearr_72447[(19)] = inst_72342);

(statearr_72447[(14)] = inst_72345);

return statearr_72447;
})();
var statearr_72448_72543 = state_72424__$1;
(statearr_72448_72543[(2)] = null);

(statearr_72448_72543[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (28))){
var inst_72390 = (state_72424[(12)]);
var state_72424__$1 = state_72424;
var statearr_72449_72544 = state_72424__$1;
(statearr_72449_72544[(2)] = inst_72390);

(statearr_72449_72544[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (25))){
var inst_72382 = (state_72424[(13)]);
var state_72424__$1 = state_72424;
var statearr_72450_72545 = state_72424__$1;
(statearr_72450_72545[(2)] = inst_72382);

(statearr_72450_72545[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (34))){
var state_72424__$1 = state_72424;
var statearr_72451_72546 = state_72424__$1;
(statearr_72451_72546[(2)] = null);

(statearr_72451_72546[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (17))){
var inst_72416 = (state_72424[(2)]);
var state_72424__$1 = state_72424;
var statearr_72452_72547 = state_72424__$1;
(statearr_72452_72547[(2)] = inst_72416);

(statearr_72452_72547[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (3))){
var inst_72422 = (state_72424[(2)]);
var state_72424__$1 = state_72424;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72424__$1,inst_72422);
} else {
if((state_val_72425 === (12))){
var inst_72351 = (state_72424[(7)]);
var inst_72331 = (state_72424[(17)]);
var inst_72356 = fluree.db.api.query.auth_match(auth,inst_72331,inst_72351);
var inst_72357 = cljs.core.not(inst_72356);
var state_72424__$1 = state_72424;
var statearr_72453_72548 = state_72424__$1;
(statearr_72453_72548[(2)] = inst_72357);

(statearr_72453_72548[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (2))){
var _ = (function (){var statearr_72454 = state_72424;
(statearr_72454[(4)] = cljs.core.cons((5),(state_72424[(4)])));

return statearr_72454;
})();
var inst_72236 = (function (){return (function (p1__72229_SHARP_){
return p1__72229_SHARP_.t;
});
})();
var inst_72237 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_72236,resp);
var inst_72238 = cljs.core.set(inst_72237);
var inst_72326 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_72327 = (function (){var ts = inst_72238;
var c__11512__auto____$1 = inst_72326;
return (function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_72324){
var state_val_72325 = (state_72324[(1)]);
if((state_val_72325 === (7))){
var inst_72252 = (state_72324[(7)]);
var inst_72258 = (state_72324[(8)]);
var inst_72264 = (state_72324[(9)]);
var inst_72270 = (state_72324[(10)]);
var inst_72263 = (state_72324[(2)]);
var inst_72264__$1 = fluree.db.util.async.throw_err(inst_72263);
var inst_72266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72267 = [inst_72258,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_72268 = (new cljs.core.PersistentVector(null,2,(5),inst_72266,inst_72267,null));
var inst_72269 = cljs.core.assoc_in(inst_72252,inst_72268,inst_72264__$1);
var inst_72270__$1 = auth;
var state_72324__$1 = (function (){var statearr_72455 = state_72324;
(statearr_72455[(11)] = inst_72269);

(statearr_72455[(9)] = inst_72264__$1);

(statearr_72455[(10)] = inst_72270__$1);

return statearr_72455;
})();
if(cljs.core.truth_(inst_72270__$1)){
var statearr_72456_72549 = state_72324__$1;
(statearr_72456_72549[(1)] = (8));

} else {
var statearr_72457_72550 = state_72324__$1;
(statearr_72457_72550[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72325 === (1))){
var inst_72246 = (state_72324[(12)]);
var inst_72246__$1 = ts;
var inst_72247 = cljs.core.seq(inst_72246__$1);
var inst_72248 = cljs.core.first(inst_72247);
var inst_72249 = cljs.core.next(inst_72247);
var inst_72250 = cljs.core.PersistentHashMap.EMPTY;
var inst_72251 = inst_72246__$1;
var inst_72252 = inst_72250;
var state_72324__$1 = (function (){var statearr_72458 = state_72324;
(statearr_72458[(7)] = inst_72252);

(statearr_72458[(12)] = inst_72246__$1);

(statearr_72458[(13)] = inst_72251);

(statearr_72458[(14)] = inst_72248);

(statearr_72458[(15)] = inst_72249);

return statearr_72458;
})();
var statearr_72459_72551 = state_72324__$1;
(statearr_72459_72551[(2)] = null);

(statearr_72459_72551[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72325 === (4))){
var inst_72258 = (state_72324[(8)]);
var inst_72261 = fluree.db.time_travel.non_border_t_to_block(db,inst_72258);
var state_72324__$1 = state_72324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72324__$1,(7),inst_72261);
} else {
if((state_val_72325 === (13))){
var inst_72259 = (state_72324[(16)]);
var inst_72316 = (state_72324[(2)]);
var inst_72251 = inst_72259;
var inst_72252 = inst_72316;
var state_72324__$1 = (function (){var statearr_72460 = state_72324;
(statearr_72460[(7)] = inst_72252);

(statearr_72460[(13)] = inst_72251);

return statearr_72460;
})();
var statearr_72461_72552 = state_72324__$1;
(statearr_72461_72552[(2)] = null);

(statearr_72461_72552[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72325 === (6))){
var inst_72320 = (state_72324[(2)]);
var state_72324__$1 = state_72324;
var statearr_72462_72553 = state_72324__$1;
(statearr_72462_72553[(2)] = inst_72320);

(statearr_72462_72553[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72325 === (3))){
var inst_72322 = (state_72324[(2)]);
var state_72324__$1 = state_72324;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72324__$1,inst_72322);
} else {
if((state_val_72325 === (12))){
var inst_72269 = (state_72324[(11)]);
var state_72324__$1 = state_72324;
var statearr_72463_72554 = state_72324__$1;
(statearr_72463_72554[(2)] = inst_72269);

(statearr_72463_72554[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72325 === (2))){
var inst_72251 = (state_72324[(13)]);
var inst_72258 = (state_72324[(8)]);
var inst_72257 = cljs.core.seq(inst_72251);
var inst_72258__$1 = cljs.core.first(inst_72257);
var inst_72259 = cljs.core.next(inst_72257);
var state_72324__$1 = (function (){var statearr_72464 = state_72324;
(statearr_72464[(16)] = inst_72259);

(statearr_72464[(8)] = inst_72258__$1);

return statearr_72464;
})();
if(cljs.core.truth_(inst_72258__$1)){
var statearr_72465_72555 = state_72324__$1;
(statearr_72465_72555[(1)] = (4));

} else {
var statearr_72466_72556 = state_72324__$1;
(statearr_72466_72556[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72325 === (11))){
var inst_72252 = (state_72324[(7)]);
var inst_72259 = (state_72324[(16)]);
var inst_72246 = (state_72324[(12)]);
var inst_72251 = (state_72324[(13)]);
var inst_72248 = (state_72324[(14)]);
var inst_72258 = (state_72324[(8)]);
var inst_72269 = (state_72324[(11)]);
var inst_72264 = (state_72324[(9)]);
var inst_72249 = (state_72324[(15)]);
var inst_72276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72277 = [inst_72258,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_72278 = (new cljs.core.PersistentVector(null,2,(5),inst_72276,inst_72277,null));
var inst_72291 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_72292 = (function (){var t = inst_72258;
var seq__72244 = inst_72249;
var c__11512__auto____$2 = inst_72291;
var vec__72243 = inst_72246;
var G__72242 = inst_72251;
var block = inst_72264;
var r = inst_72259;
var seq__72255 = inst_72259;
var G__72265 = inst_72269;
var acc = inst_72252;
var first__72245 = inst_72248;
var vec__72254 = inst_72251;
var first__72256 = inst_72258;
return (function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_72289){
var state_val_72290 = (state_72289[(1)]);
if((state_val_72290 === (1))){
var state_72289__$1 = state_72289;
var statearr_72467_72557 = state_72289__$1;
(statearr_72467_72557[(2)] = null);

(statearr_72467_72557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (2))){
var ___$1 = (function (){var statearr_72468 = state_72289;
(statearr_72468[(4)] = cljs.core.cons((5),(state_72289[(4)])));

return statearr_72468;
})();
var ___$2 = (function (){var statearr_72469 = state_72289;
(statearr_72469[(4)] = cljs.core.rest((state_72289[(4)])));

return statearr_72469;
})();
var state_72289__$1 = state_72289;
var statearr_72470_72558 = state_72289__$1;
(statearr_72470_72558[(2)] = db);

(statearr_72470_72558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (3))){
var inst_72287 = (state_72289[(2)]);
var state_72289__$1 = state_72289;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72289__$1,inst_72287);
} else {
if((state_val_72290 === (4))){
var inst_72279 = (state_72289[(2)]);
var state_72289__$1 = state_72289;
var statearr_72472_72559 = state_72289__$1;
(statearr_72472_72559[(2)] = inst_72279);

(statearr_72472_72559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (5))){
var ___$1 = (function (){var statearr_72473 = state_72289;
(statearr_72473[(4)] = cljs.core.rest((state_72289[(4)])));

return statearr_72473;
})();
var state_72289__$1 = state_72289;
var ex72471 = (state_72289__$1[(2)]);
var statearr_72474_72560 = state_72289__$1;
(statearr_72474_72560[(5)] = ex72471);


if((ex72471 instanceof Error)){
var statearr_72475_72561 = state_72289__$1;
(statearr_72475_72561[(1)] = (4));

(statearr_72475_72561[(5)] = null);

} else {
throw ex72471;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____0 = (function (){
var statearr_72476 = [null,null,null,null,null,null,null];
(statearr_72476[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__);

(statearr_72476[(1)] = (1));

return statearr_72476;
});
var fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____1 = (function (state_72289){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_72289);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e72477){var ex__11441__auto__ = e72477;
var statearr_72478_72562 = state_72289;
(statearr_72478_72562[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_72289[(4)]))){
var statearr_72479_72563 = state_72289;
(statearr_72479_72563[(1)] = cljs.core.first((state_72289[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72564 = state_72289;
state_72289 = G__72564;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__ = function(state_72289){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____1.call(this,state_72289);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_72480 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_72480[(6)] = c__11512__auto____$2);

return statearr_72480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
});
})();
var inst_72293 = cljs.core.async.impl.dispatch.run(inst_72292);
var inst_72294 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_72295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72296 = ["?auth","?id"];
var inst_72297 = (new cljs.core.PersistentVector(null,2,(5),inst_72295,inst_72296,null));
var inst_72298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72299 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72300 = [inst_72258,"_tx/auth","?auth"];
var inst_72301 = (new cljs.core.PersistentVector(null,3,(5),inst_72299,inst_72300,null));
var inst_72302 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72303 = ["?auth","_auth/id","?id"];
var inst_72304 = (new cljs.core.PersistentVector(null,3,(5),inst_72302,inst_72303,null));
var inst_72305 = [inst_72301,inst_72304];
var inst_72306 = (new cljs.core.PersistentVector(null,2,(5),inst_72298,inst_72305,null));
var inst_72307 = [inst_72297,inst_72306];
var inst_72308 = cljs.core.PersistentHashMap.fromArrays(inst_72294,inst_72307);
var inst_72309 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_72291,inst_72308) : fluree.db.api.query.query_async.call(null,inst_72291,inst_72308));
var state_72324__$1 = (function (){var statearr_72481 = state_72324;
(statearr_72481[(17)] = inst_72278);

(statearr_72481[(18)] = inst_72293);

return statearr_72481;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72324__$1,(14),inst_72309);
} else {
if((state_val_72325 === (9))){
var state_72324__$1 = state_72324;
var statearr_72482_72565 = state_72324__$1;
(statearr_72482_72565[(2)] = show_auth);

(statearr_72482_72565[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72325 === (5))){
var inst_72252 = (state_72324[(7)]);
var state_72324__$1 = state_72324;
var statearr_72483_72566 = state_72324__$1;
(statearr_72483_72566[(2)] = inst_72252);

(statearr_72483_72566[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72325 === (14))){
var inst_72278 = (state_72324[(17)]);
var inst_72269 = (state_72324[(11)]);
var inst_72311 = (state_72324[(2)]);
var inst_72312 = fluree.db.util.async.throw_err(inst_72311);
var inst_72313 = cljs.core.assoc_in(inst_72269,inst_72278,inst_72312);
var state_72324__$1 = state_72324;
var statearr_72484_72567 = state_72324__$1;
(statearr_72484_72567[(2)] = inst_72313);

(statearr_72484_72567[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72325 === (10))){
var inst_72274 = (state_72324[(2)]);
var state_72324__$1 = state_72324;
if(cljs.core.truth_(inst_72274)){
var statearr_72485_72568 = state_72324__$1;
(statearr_72485_72568[(1)] = (11));

} else {
var statearr_72486_72569 = state_72324__$1;
(statearr_72486_72569[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72325 === (8))){
var inst_72270 = (state_72324[(10)]);
var state_72324__$1 = state_72324;
var statearr_72487_72570 = state_72324__$1;
(statearr_72487_72570[(2)] = inst_72270);

(statearr_72487_72570[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____0 = (function (){
var statearr_72488 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72488[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__);

(statearr_72488[(1)] = (1));

return statearr_72488;
});
var fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____1 = (function (state_72324){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_72324);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e72489){var ex__11441__auto__ = e72489;
var statearr_72490_72571 = state_72324;
(statearr_72490_72571[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_72324[(4)]))){
var statearr_72491_72572 = state_72324;
(statearr_72491_72572[(1)] = cljs.core.first((state_72324[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72573 = state_72324;
state_72324 = G__72573;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__ = function(state_72324){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____1.call(this,state_72324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_72492 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_72492[(6)] = c__11512__auto____$1);

return statearr_72492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
});
})();
var inst_72328 = cljs.core.async.impl.dispatch.run(inst_72327);
var state_72424__$1 = (function (){var statearr_72493 = state_72424;
(statearr_72493[(20)] = inst_72328);

return statearr_72493;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72424__$1,(6),inst_72326);
} else {
if((state_val_72425 === (23))){
var inst_72382 = (state_72424[(2)]);
var state_72424__$1 = (function (){var statearr_72494 = state_72424;
(statearr_72494[(13)] = inst_72382);

return statearr_72494;
})();
var statearr_72495_72574 = state_72424__$1;
(statearr_72495_72574[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (35))){
var inst_72412 = (state_72424[(2)]);
var state_72424__$1 = state_72424;
var statearr_72497_72575 = state_72424__$1;
(statearr_72497_72575[(2)] = inst_72412);

(statearr_72497_72575[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (19))){
var state_72424__$1 = state_72424;
var statearr_72498_72576 = state_72424__$1;
(statearr_72498_72576[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (11))){
var inst_72363 = (state_72424[(2)]);
var state_72424__$1 = state_72424;
if(cljs.core.truth_(inst_72363)){
var statearr_72501_72577 = state_72424__$1;
(statearr_72501_72577[(1)] = (15));

} else {
var statearr_72502_72578 = state_72424__$1;
(statearr_72502_72578[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (9))){
var inst_72354 = (state_72424[(16)]);
var inst_72354__$1 = auth;
var state_72424__$1 = (function (){var statearr_72503 = state_72424;
(statearr_72503[(16)] = inst_72354__$1);

return statearr_72503;
})();
if(cljs.core.truth_(inst_72354__$1)){
var statearr_72504_72579 = state_72424__$1;
(statearr_72504_72579[(1)] = (12));

} else {
var statearr_72505_72580 = state_72424__$1;
(statearr_72505_72580[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (5))){
var _ = (function (){var statearr_72506 = state_72424;
(statearr_72506[(4)] = cljs.core.rest((state_72424[(4)])));

return statearr_72506;
})();
var state_72424__$1 = state_72424;
var ex72500 = (state_72424__$1[(2)]);
var statearr_72507_72581 = state_72424__$1;
(statearr_72507_72581[(5)] = ex72500);


if((ex72500 instanceof Error)){
var statearr_72508_72582 = state_72424__$1;
(statearr_72508_72582[(1)] = (4));

(statearr_72508_72582[(5)] = null);

} else {
throw ex72500;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (14))){
var inst_72360 = (state_72424[(2)]);
var state_72424__$1 = state_72424;
var statearr_72509_72583 = state_72424__$1;
(statearr_72509_72583[(2)] = inst_72360);

(statearr_72509_72583[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (26))){
var inst_72390 = (state_72424[(2)]);
var state_72424__$1 = (function (){var statearr_72510 = state_72424;
(statearr_72510[(12)] = inst_72390);

return statearr_72510;
})();
var statearr_72511_72584 = state_72424__$1;
(statearr_72511_72584[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (16))){
var inst_72351 = (state_72424[(7)]);
var state_72424__$1 = state_72424;
if(cljs.core.truth_(inst_72351)){
var statearr_72513_72585 = state_72424__$1;
(statearr_72513_72585[(1)] = (18));

} else {
var statearr_72514_72586 = state_72424__$1;
(statearr_72514_72586[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (30))){
var inst_72372 = (state_72424[(11)]);
var inst_72373 = (state_72424[(21)]);
var inst_72398 = (state_72424[(15)]);
var inst_72400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72401 = [inst_72372,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_72402 = (new cljs.core.PersistentVector(null,2,(5),inst_72400,inst_72401,null));
var inst_72403 = cljs.core.assoc_in(inst_72398,inst_72402,inst_72373);
var state_72424__$1 = state_72424;
var statearr_72515_72587 = state_72424__$1;
(statearr_72515_72587[(2)] = inst_72403);

(statearr_72515_72587[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (10))){
var inst_72351 = (state_72424[(7)]);
var state_72424__$1 = state_72424;
var statearr_72516_72588 = state_72424__$1;
(statearr_72516_72588[(2)] = inst_72351);

(statearr_72516_72588[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (18))){
var inst_72351 = (state_72424[(7)]);
var inst_72331 = (state_72424[(17)]);
var inst_72369 = (state_72424[(10)]);
var inst_72369__$1 = inst_72351.t;
var inst_72370 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72331,inst_72369__$1);
var inst_72371 = cljs.core.__destructure_map(inst_72370);
var inst_72372 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72371,new cljs.core.Keyword(null,"block","block",664686210));
var inst_72373 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72371,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_72424__$1 = (function (){var statearr_72517 = state_72424;
(statearr_72517[(10)] = inst_72369__$1);

(statearr_72517[(11)] = inst_72372);

(statearr_72517[(21)] = inst_72373);

return statearr_72517;
})();
var statearr_72518_72589 = state_72424__$1;
(statearr_72518_72589[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72425 === (8))){
var inst_72418 = (state_72424[(2)]);
var inst_72419 = cljs.core.vals(inst_72418);
var _ = (function (){var statearr_72520 = state_72424;
(statearr_72520[(4)] = cljs.core.rest((state_72424[(4)])));

return statearr_72520;
})();
var state_72424__$1 = state_72424;
var statearr_72521_72590 = state_72424__$1;
(statearr_72521_72590[(2)] = inst_72419);

(statearr_72521_72590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____0 = (function (){
var statearr_72522 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72522[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__);

(statearr_72522[(1)] = (1));

return statearr_72522;
});
var fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____1 = (function (state_72424){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_72424);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e72523){var ex__11441__auto__ = e72523;
var statearr_72524_72591 = state_72424;
(statearr_72524_72591[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_72424[(4)]))){
var statearr_72525_72592 = state_72424;
(statearr_72525_72592[(1)] = cljs.core.first((state_72424[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72593 = state_72424;
state_72424 = G__72593;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__ = function(state_72424){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____1.call(this,state_72424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__11438__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_72526 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_72526[(6)] = c__11512__auto__);

return statearr_72526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_72720){
var state_val_72721 = (state_72720[(1)]);
if((state_val_72721 === (7))){
var inst_72616 = (state_72720[(7)]);
var inst_72618 = fluree.db.api.query.resolve_block_range(inst_72616,query_map);
var state_72720__$1 = state_72720;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72720__$1,(10),inst_72618);
} else {
if((state_val_72721 === (20))){
var inst_72645 = (state_72720[(2)]);
var inst_72646 = fluree.db.util.async.throw_err(inst_72645);
var inst_72647 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_72646);
var inst_72648 = (inst_72647 - (1));
var state_72720__$1 = state_72720;
var statearr_72722_72785 = state_72720__$1;
(statearr_72722_72785[(2)] = inst_72648);

(statearr_72722_72785[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (27))){
var state_72720__$1 = state_72720;
var statearr_72723_72786 = state_72720__$1;
(statearr_72723_72786[(2)] = null);

(statearr_72723_72786[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (1))){
var state_72720__$1 = state_72720;
var statearr_72724_72787 = state_72720__$1;
(statearr_72724_72787[(2)] = null);

(statearr_72724_72787[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (24))){
var inst_72655 = (state_72720[(2)]);
var inst_72656 = fluree.db.util.async.throw_err(inst_72655);
var inst_72657 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_72656);
var state_72720__$1 = state_72720;
var statearr_72725_72788 = state_72720__$1;
(statearr_72725_72788[(2)] = inst_72657);

(statearr_72725_72788[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (39))){
var inst_72692 = (state_72720[(2)]);
var inst_72693 = fluree.db.util.async.throw_err(inst_72692);
var state_72720__$1 = state_72720;
var statearr_72726_72789 = state_72720__$1;
(statearr_72726_72789[(2)] = inst_72693);

(statearr_72726_72789[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (4))){
var inst_72594 = (state_72720[(2)]);
var state_72720__$1 = state_72720;
var statearr_72727_72790 = state_72720__$1;
(statearr_72727_72790[(2)] = inst_72594);

(statearr_72727_72790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (15))){
var inst_72625 = (state_72720[(8)]);
var state_72720__$1 = state_72720;
var statearr_72728_72791 = state_72720__$1;
(statearr_72728_72791[(2)] = inst_72625);

(statearr_72728_72791[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (21))){
var inst_72616 = (state_72720[(7)]);
var inst_72626 = (state_72720[(9)]);
var inst_72653 = fluree.db.time_travel.as_of_block(inst_72616,inst_72626);
var state_72720__$1 = state_72720;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72720__$1,(24),inst_72653);
} else {
if((state_val_72721 === (31))){
var inst_72610 = (state_72720[(10)]);
var state_72720__$1 = state_72720;
var statearr_72729_72792 = state_72720__$1;
(statearr_72729_72792[(2)] = inst_72610);

(statearr_72729_72792[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (32))){
var inst_72676 = (state_72720[(11)]);
var inst_72616 = (state_72720[(7)]);
var inst_72671 = (state_72720[(12)]);
var inst_72680 = (state_72720[(2)]);
var inst_72681 = fluree.db.api.query.format_history_resp(inst_72616,inst_72671,inst_72676,inst_72680);
var state_72720__$1 = state_72720;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72720__$1,(29),inst_72681);
} else {
if((state_val_72721 === (40))){
var inst_72697 = (state_72720[(13)]);
var inst_72671 = (state_72720[(12)]);
var inst_72699 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_72700 = cljs.core.count(inst_72671);
var inst_72701 = [inst_72697,inst_72700,(200)];
var inst_72702 = cljs.core.PersistentHashMap.fromArrays(inst_72699,inst_72701);
var state_72720__$1 = state_72720;
var statearr_72730_72793 = state_72720__$1;
(statearr_72730_72793[(2)] = inst_72702);

(statearr_72730_72793[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (33))){
var inst_72609 = (state_72720[(14)]);
var state_72720__$1 = state_72720;
var statearr_72731_72794 = state_72720__$1;
(statearr_72731_72794[(2)] = inst_72609);

(statearr_72731_72794[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (13))){
var inst_72715 = (state_72720[(2)]);
var _ = (function (){var statearr_72732 = state_72720;
(statearr_72732[(4)] = cljs.core.rest((state_72720[(4)])));

return statearr_72732;
})();
var state_72720__$1 = state_72720;
var statearr_72733_72795 = state_72720__$1;
(statearr_72733_72795[(2)] = inst_72715);

(statearr_72733_72795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (22))){
var inst_72616 = (state_72720[(7)]);
var inst_72659 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_72616);
var state_72720__$1 = state_72720;
var statearr_72734_72796 = state_72720__$1;
(statearr_72734_72796[(2)] = inst_72659);

(statearr_72734_72796[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (36))){
var inst_72684 = (state_72720[(15)]);
var inst_72616 = (state_72720[(7)]);
var inst_72690 = fluree.db.api.query.format_blocks_resp_pretty(inst_72616,inst_72684);
var state_72720__$1 = state_72720;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72720__$1,(39),inst_72690);
} else {
if((state_val_72721 === (41))){
var inst_72697 = (state_72720[(13)]);
var state_72720__$1 = state_72720;
var statearr_72735_72797 = state_72720__$1;
(statearr_72735_72797[(2)] = inst_72697);

(statearr_72735_72797[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (29))){
var inst_72609 = (state_72720[(14)]);
var inst_72683 = (state_72720[(2)]);
var inst_72684 = fluree.db.util.async.throw_err(inst_72683);
var state_72720__$1 = (function (){var statearr_72736 = state_72720;
(statearr_72736[(15)] = inst_72684);

return statearr_72736;
})();
if(cljs.core.truth_(inst_72609)){
var statearr_72737_72798 = state_72720__$1;
(statearr_72737_72798[(1)] = (33));

} else {
var statearr_72738_72799 = state_72720__$1;
(statearr_72738_72799[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (6))){
var inst_72606 = (state_72720[(16)]);
var inst_72615 = (state_72720[(2)]);
var inst_72616 = fluree.db.util.async.throw_err(inst_72615);
var state_72720__$1 = (function (){var statearr_72739 = state_72720;
(statearr_72739[(7)] = inst_72616);

return statearr_72739;
})();
if(cljs.core.truth_(inst_72606)){
var statearr_72740_72800 = state_72720__$1;
(statearr_72740_72800[(1)] = (7));

} else {
var statearr_72741_72801 = state_72720__$1;
(statearr_72741_72801[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (28))){
var inst_72611 = (state_72720[(17)]);
var inst_72676 = (state_72720[(2)]);
var state_72720__$1 = (function (){var statearr_72742 = state_72720;
(statearr_72742[(11)] = inst_72676);

return statearr_72742;
})();
if(cljs.core.truth_(inst_72611)){
var statearr_72743_72802 = state_72720__$1;
(statearr_72743_72802[(1)] = (30));

} else {
var statearr_72744_72803 = state_72720__$1;
(statearr_72744_72803[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (25))){
var inst_72612 = (state_72720[(18)]);
var inst_72670 = (state_72720[(2)]);
var inst_72671 = fluree.db.util.async.throw_err(inst_72670);
var state_72720__$1 = (function (){var statearr_72745 = state_72720;
(statearr_72745[(12)] = inst_72671);

return statearr_72745;
})();
if(cljs.core.truth_(inst_72612)){
var statearr_72746_72804 = state_72720__$1;
(statearr_72746_72804[(1)] = (26));

} else {
var statearr_72747_72805 = state_72720__$1;
(statearr_72747_72805[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (34))){
var inst_72608 = (state_72720[(19)]);
var state_72720__$1 = state_72720;
var statearr_72748_72806 = state_72720__$1;
(statearr_72748_72806[(2)] = inst_72608);

(statearr_72748_72806[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (17))){
var inst_72625 = (state_72720[(8)]);
var inst_72616 = (state_72720[(7)]);
var inst_72642 = (inst_72625 - (1));
var inst_72643 = fluree.db.time_travel.as_of_block(inst_72616,inst_72642);
var state_72720__$1 = state_72720;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72720__$1,(20),inst_72643);
} else {
if((state_val_72721 === (3))){
var inst_72718 = (state_72720[(2)]);
var state_72720__$1 = state_72720;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72720__$1,inst_72718);
} else {
if((state_val_72721 === (12))){
var inst_72707 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_72708 = ["History query not properly formatted. Provided ",inst_72707].join('');
var inst_72709 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72710 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72711 = cljs.core.PersistentHashMap.fromArrays(inst_72709,inst_72710);
var inst_72712 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_72708,inst_72711);
var inst_72713 = (function(){throw inst_72712})();
var state_72720__$1 = state_72720;
var statearr_72749_72807 = state_72720__$1;
(statearr_72749_72807[(2)] = inst_72713);

(statearr_72749_72807[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (2))){
var _ = (function (){var statearr_72750 = state_72720;
(statearr_72750[(4)] = cljs.core.cons((5),(state_72720[(4)])));

return statearr_72750;
})();
var inst_72604 = query_map;
var inst_72605 = cljs.core.__destructure_map(inst_72604);
var inst_72606 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72605,new cljs.core.Keyword(null,"block","block",664686210));
var inst_72607 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72605,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_72608 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72605,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_72609 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72605,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_72610 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72605,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_72611 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72605,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_72612 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72605,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_72613 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72605,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_72720__$1 = (function (){var statearr_72751 = state_72720;
(statearr_72751[(18)] = inst_72612);

(statearr_72751[(17)] = inst_72611);

(statearr_72751[(19)] = inst_72608);

(statearr_72751[(10)] = inst_72610);

(statearr_72751[(16)] = inst_72606);

(statearr_72751[(20)] = inst_72607);

(statearr_72751[(21)] = inst_72613);

(statearr_72751[(14)] = inst_72609);

return statearr_72751;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72720__$1,(6),sources);
} else {
if((state_val_72721 === (23))){
var inst_72616 = (state_72720[(7)]);
var inst_72607 = (state_72720[(20)]);
var inst_72651 = (state_72720[(22)]);
var inst_72661 = (state_72720[(2)]);
var inst_72662 = fluree.db.api.query.get_history_pattern(inst_72607);
var inst_72663 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72662,(0),null);
var inst_72664 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72662,(1),null);
var inst_72665 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_72666 = [inst_72651,inst_72661];
var inst_72667 = cljs.core.PersistentHashMap.fromArrays(inst_72665,inst_72666);
var inst_72668 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_72616,inst_72664,cljs.core._EQ_,inst_72663,inst_72667);
var state_72720__$1 = state_72720;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72720__$1,(25),inst_72668);
} else {
if((state_val_72721 === (35))){
var inst_72688 = (state_72720[(2)]);
var state_72720__$1 = state_72720;
if(cljs.core.truth_(inst_72688)){
var statearr_72752_72808 = state_72720__$1;
(statearr_72752_72808[(1)] = (36));

} else {
var statearr_72753_72809 = state_72720__$1;
(statearr_72753_72809[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (19))){
var inst_72626 = (state_72720[(9)]);
var inst_72651 = (state_72720[(2)]);
var state_72720__$1 = (function (){var statearr_72754 = state_72720;
(statearr_72754[(22)] = inst_72651);

return statearr_72754;
})();
if(cljs.core.truth_(inst_72626)){
var statearr_72755_72810 = state_72720__$1;
(statearr_72755_72810[(1)] = (21));

} else {
var statearr_72756_72811 = state_72720__$1;
(statearr_72756_72811[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (11))){
var inst_72625 = (state_72720[(8)]);
var inst_72613 = (state_72720[(21)]);
var inst_72635 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_72613);
var state_72720__$1 = (function (){var statearr_72758 = state_72720;
(statearr_72758[(23)] = inst_72635);

return statearr_72758;
})();
if(cljs.core.truth_(inst_72625)){
var statearr_72759_72812 = state_72720__$1;
(statearr_72759_72812[(1)] = (14));

} else {
var statearr_72760_72813 = state_72720__$1;
(statearr_72760_72813[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (9))){
var inst_72624 = (state_72720[(2)]);
var inst_72625 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72624,(0),null);
var inst_72626 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72624,(1),null);
var inst_72627 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_72628 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(query_map,new cljs.core.Keyword(null,"block","block",664686210),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701)], 0));
var inst_72629 = cljs.core.keys(inst_72628);
var inst_72630 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72627,inst_72629);
var state_72720__$1 = (function (){var statearr_72761 = state_72720;
(statearr_72761[(8)] = inst_72625);

(statearr_72761[(9)] = inst_72626);

return statearr_72761;
})();
if(inst_72630){
var statearr_72762_72814 = state_72720__$1;
(statearr_72762_72814[(1)] = (11));

} else {
var statearr_72763_72815 = state_72720__$1;
(statearr_72763_72815[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (5))){
var _ = (function (){var statearr_72764 = state_72720;
(statearr_72764[(4)] = cljs.core.rest((state_72720[(4)])));

return statearr_72764;
})();
var state_72720__$1 = state_72720;
var ex72757 = (state_72720__$1[(2)]);
var statearr_72765_72816 = state_72720__$1;
(statearr_72765_72816[(5)] = ex72757);


if((ex72757 instanceof Error)){
var statearr_72766_72817 = state_72720__$1;
(statearr_72766_72817[(1)] = (4));

(statearr_72766_72817[(5)] = null);

} else {
throw ex72757;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (14))){
var inst_72625 = (state_72720[(8)]);
var inst_72637 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_72625);
var state_72720__$1 = state_72720;
var statearr_72767_72818 = state_72720__$1;
(statearr_72767_72818[(2)] = inst_72637);

(statearr_72767_72818[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (26))){
var inst_72612 = (state_72720[(18)]);
var inst_72673 = cljs.core.set(inst_72612);
var state_72720__$1 = state_72720;
var statearr_72768_72819 = state_72720__$1;
(statearr_72768_72819[(2)] = inst_72673);

(statearr_72768_72819[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (16))){
var inst_72640 = (state_72720[(2)]);
var state_72720__$1 = state_72720;
if(cljs.core.truth_(inst_72640)){
var statearr_72769_72820 = state_72720__$1;
(statearr_72769_72820[(1)] = (17));

} else {
var statearr_72770_72821 = state_72720__$1;
(statearr_72770_72821[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (38))){
var inst_72635 = (state_72720[(23)]);
var inst_72697 = (state_72720[(2)]);
var state_72720__$1 = (function (){var statearr_72771 = state_72720;
(statearr_72771[(13)] = inst_72697);

return statearr_72771;
})();
if(cljs.core.truth_(inst_72635)){
var statearr_72772_72822 = state_72720__$1;
(statearr_72772_72822[(1)] = (40));

} else {
var statearr_72773_72823 = state_72720__$1;
(statearr_72773_72823[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (30))){
var inst_72611 = (state_72720[(17)]);
var state_72720__$1 = state_72720;
var statearr_72774_72824 = state_72720__$1;
(statearr_72774_72824[(2)] = inst_72611);

(statearr_72774_72824[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (10))){
var inst_72620 = (state_72720[(2)]);
var inst_72621 = fluree.db.util.async.throw_err(inst_72620);
var state_72720__$1 = state_72720;
var statearr_72775_72825 = state_72720__$1;
(statearr_72775_72825[(2)] = inst_72621);

(statearr_72775_72825[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (18))){
var state_72720__$1 = state_72720;
var statearr_72776_72826 = state_72720__$1;
(statearr_72776_72826[(2)] = (-1));

(statearr_72776_72826[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (42))){
var inst_72705 = (state_72720[(2)]);
var state_72720__$1 = state_72720;
var statearr_72777_72827 = state_72720__$1;
(statearr_72777_72827[(2)] = inst_72705);

(statearr_72777_72827[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (37))){
var inst_72684 = (state_72720[(15)]);
var inst_72695 = fluree.db.api.query.block_Flakes__GT_vector(inst_72684);
var state_72720__$1 = state_72720;
var statearr_72778_72828 = state_72720__$1;
(statearr_72778_72828[(2)] = inst_72695);

(statearr_72778_72828[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (8))){
var state_72720__$1 = state_72720;
var statearr_72779_72829 = state_72720__$1;
(statearr_72779_72829[(2)] = null);

(statearr_72779_72829[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__11438__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__11438__auto____0 = (function (){
var statearr_72780 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72780[(0)] = fluree$db$api$query$history_query_async_$_state_machine__11438__auto__);

(statearr_72780[(1)] = (1));

return statearr_72780;
});
var fluree$db$api$query$history_query_async_$_state_machine__11438__auto____1 = (function (state_72720){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_72720);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e72781){var ex__11441__auto__ = e72781;
var statearr_72782_72830 = state_72720;
(statearr_72782_72830[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_72720[(4)]))){
var statearr_72783_72831 = state_72720;
(statearr_72783_72831[(1)] = cljs.core.first((state_72720[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72832 = state_72720;
state_72720 = G__72832;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__11438__auto__ = function(state_72720){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__11438__auto____1.call(this,state_72720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__11438__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__11438__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_72784 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_72784[(6)] = c__11512__auto__);

return statearr_72784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_72965){
var state_val_72966 = (state_72965[(1)]);
if((state_val_72966 === (7))){
var inst_72862 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_72863 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_72862].join('');
var inst_72864 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72865 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72866 = cljs.core.PersistentHashMap.fromArrays(inst_72864,inst_72865);
var inst_72867 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_72863,inst_72866);
var inst_72868 = (function(){throw inst_72867})();
var state_72965__$1 = state_72965;
var statearr_72967_73046 = state_72965__$1;
(statearr_72967_73046[(2)] = inst_72868);

(statearr_72967_73046[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (20))){
var inst_72900 = (state_72965[(2)]);
var state_72965__$1 = state_72965;
if(cljs.core.truth_(inst_72900)){
var statearr_72968_73047 = state_72965__$1;
(statearr_72968_73047[(1)] = (21));

} else {
var statearr_72969_73048 = state_72965__$1;
(statearr_72969_73048[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (27))){
var inst_72844 = (state_72965[(7)]);
var state_72965__$1 = state_72965;
var statearr_72970_73049 = state_72965__$1;
(statearr_72970_73049[(2)] = inst_72844);

(statearr_72970_73049[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (1))){
var state_72965__$1 = state_72965;
var statearr_72971_73050 = state_72965__$1;
(statearr_72971_73050[(2)] = null);

(statearr_72971_73050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (24))){
var inst_72906 = (state_72965[(8)]);
var state_72965__$1 = state_72965;
var statearr_72972_73051 = state_72965__$1;
(statearr_72972_73051[(2)] = inst_72906);

(statearr_72972_73051[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (39))){
var inst_72850 = (state_72965[(9)]);
var state_72965__$1 = state_72965;
if(cljs.core.truth_(inst_72850)){
var statearr_72973_73052 = state_72965__$1;
(statearr_72973_73052[(1)] = (42));

} else {
var statearr_72974_73053 = state_72965__$1;
(statearr_72974_73053[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (46))){
var inst_72938 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72939 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72940 = cljs.core.PersistentHashMap.fromArrays(inst_72938,inst_72939);
var inst_72941 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_72940);
var inst_72942 = (function(){throw inst_72941})();
var state_72965__$1 = state_72965;
var statearr_72975_73054 = state_72965__$1;
(statearr_72975_73054[(2)] = inst_72942);

(statearr_72975_73054[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (4))){
var inst_72834 = (state_72965[(2)]);
var state_72965__$1 = state_72965;
var statearr_72976_73055 = state_72965__$1;
(statearr_72976_73055[(2)] = inst_72834);

(statearr_72976_73055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (15))){
var inst_72885 = (state_72965[(10)]);
var inst_72847 = (state_72965[(11)]);
var inst_72887 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_72885);
var inst_72888 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_72885);
var inst_72889 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_72885);
var inst_72890 = fluree.db.api.query.get_sources(inst_72887,inst_72888,inst_72889,inst_72847);
var state_72965__$1 = state_72965;
var statearr_72977_73056 = state_72965__$1;
(statearr_72977_73056[(2)] = inst_72890);

(statearr_72977_73056[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (48))){
var inst_72895 = (state_72965[(12)]);
var inst_72949 = (state_72965[(2)]);
var inst_72950 = fluree.db.util.async.throw_err(inst_72949);
var state_72965__$1 = (function (){var statearr_72978 = state_72965;
(statearr_72978[(13)] = inst_72950);

return statearr_72978;
})();
if(cljs.core.truth_(inst_72895)){
var statearr_72979_73057 = state_72965__$1;
(statearr_72979_73057[(1)] = (49));

} else {
var statearr_72980_73058 = state_72965__$1;
(statearr_72980_73058[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (50))){
var inst_72950 = (state_72965[(13)]);
var state_72965__$1 = state_72965;
var statearr_72981_73059 = state_72965__$1;
(statearr_72981_73059[(2)] = inst_72950);

(statearr_72981_73059[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (21))){
var inst_72902 = cljs.core.volatile_BANG_((0));
var state_72965__$1 = state_72965;
var statearr_72982_73060 = state_72965__$1;
(statearr_72982_73060[(2)] = inst_72902);

(statearr_72982_73060[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (31))){
var inst_72848 = (state_72965[(14)]);
var state_72965__$1 = state_72965;
if(cljs.core.truth_(inst_72848)){
var statearr_72983_73061 = state_72965__$1;
(statearr_72983_73061[(1)] = (33));

} else {
var statearr_72984_73062 = state_72965__$1;
(statearr_72984_73062[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (32))){
var inst_72925 = (state_72965[(2)]);
var state_72965__$1 = state_72965;
var statearr_72985_73063 = state_72965__$1;
(statearr_72985_73063[(2)] = inst_72925);

(statearr_72985_73063[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (40))){
var inst_72927 = (state_72965[(15)]);
var state_72965__$1 = state_72965;
var statearr_72986_73064 = state_72965__$1;
(statearr_72986_73064[(2)] = inst_72927);

(statearr_72986_73064[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (33))){
var inst_72848 = (state_72965[(14)]);
var state_72965__$1 = state_72965;
var statearr_72987_73065 = state_72965__$1;
(statearr_72987_73065[(2)] = inst_72848);

(statearr_72987_73065[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (13))){
var inst_72845 = (state_72965[(16)]);
var inst_72874 = (state_72965[(2)]);
var inst_72875 = fluree.db.util.async.throw_err(inst_72874);
var inst_72876 = fluree.db.time_travel.as_of_block(inst_72875,inst_72845);
var state_72965__$1 = state_72965;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72965__$1,(12),inst_72876);
} else {
if((state_val_72966 === (22))){
var state_72965__$1 = state_72965;
var statearr_72988_73066 = state_72965__$1;
(statearr_72988_73066[(2)] = null);

(statearr_72988_73066[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (36))){
var inst_72852 = (state_72965[(17)]);
var state_72965__$1 = state_72965;
var statearr_72989_73067 = state_72965__$1;
(statearr_72989_73067[(2)] = inst_72852);

(statearr_72989_73067[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (41))){
var inst_72935 = (state_72965[(2)]);
var state_72965__$1 = state_72965;
if(cljs.core.truth_(inst_72935)){
var statearr_72990_73068 = state_72965__$1;
(statearr_72990_73068[(1)] = (45));

} else {
var statearr_72991_73069 = state_72965__$1;
(statearr_72991_73069[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (43))){
var inst_72846 = (state_72965[(18)]);
var state_72965__$1 = state_72965;
var statearr_72992_73070 = state_72965__$1;
(statearr_72992_73070[(2)] = inst_72846);

(statearr_72992_73070[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (29))){
var inst_72927 = (state_72965[(15)]);
var inst_72927__$1 = (state_72965[(2)]);
var state_72965__$1 = (function (){var statearr_72993 = state_72965;
(statearr_72993[(15)] = inst_72927__$1);

return statearr_72993;
})();
if(cljs.core.truth_(inst_72927__$1)){
var statearr_72994_73071 = state_72965__$1;
(statearr_72994_73071[(1)] = (39));

} else {
var statearr_72995_73072 = state_72965__$1;
(statearr_72995_73072[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (44))){
var inst_72932 = (state_72965[(2)]);
var state_72965__$1 = state_72965;
var statearr_72996_73073 = state_72965__$1;
(statearr_72996_73073[(2)] = inst_72932);

(statearr_72996_73073[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (6))){
var state_72965__$1 = state_72965;
var statearr_72997_73074 = state_72965__$1;
(statearr_72997_73074[(2)] = null);

(statearr_72997_73074[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (28))){
var inst_72849 = (state_72965[(19)]);
var state_72965__$1 = state_72965;
if(cljs.core.truth_(inst_72849)){
var statearr_72998_73075 = state_72965__$1;
(statearr_72998_73075[(1)] = (30));

} else {
var statearr_72999_73076 = state_72965__$1;
(statearr_72999_73076[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (51))){
var inst_72960 = (state_72965[(2)]);
var _ = (function (){var statearr_73000 = state_72965;
(statearr_73000[(4)] = cljs.core.rest((state_72965[(4)])));

return statearr_73000;
})();
var state_72965__$1 = state_72965;
var statearr_73001_73077 = state_72965__$1;
(statearr_73001_73077[(2)] = inst_72960);

(statearr_73001_73077[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (25))){
var state_72965__$1 = state_72965;
var statearr_73002_73078 = state_72965__$1;
(statearr_73002_73078[(2)] = (1000000));

(statearr_73002_73078[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (34))){
var inst_72852 = (state_72965[(17)]);
var state_72965__$1 = state_72965;
if(cljs.core.truth_(inst_72852)){
var statearr_73003_73079 = state_72965__$1;
(statearr_73003_73079[(1)] = (36));

} else {
var statearr_73004_73080 = state_72965__$1;
(statearr_73004_73080[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (17))){
var inst_72851 = (state_72965[(20)]);
var inst_72896 = (state_72965[(21)]);
var inst_72894 = (state_72965[(2)]);
var inst_72895 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_72851);
var inst_72896__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_72851);
var state_72965__$1 = (function (){var statearr_73005 = state_72965;
(statearr_73005[(12)] = inst_72895);

(statearr_73005[(21)] = inst_72896__$1);

(statearr_73005[(22)] = inst_72894);

return statearr_73005;
})();
if(cljs.core.truth_(inst_72896__$1)){
var statearr_73006_73081 = state_72965__$1;
(statearr_73006_73081[(1)] = (18));

} else {
var statearr_73007_73082 = state_72965__$1;
(statearr_73007_73082[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (3))){
var inst_72963 = (state_72965[(2)]);
var state_72965__$1 = state_72965;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72965__$1,inst_72963);
} else {
if((state_val_72966 === (12))){
var inst_72878 = (state_72965[(2)]);
var inst_72879 = fluree.db.util.async.throw_err(inst_72878);
var state_72965__$1 = state_72965;
var statearr_73008_73083 = state_72965__$1;
(statearr_73008_73083[(2)] = inst_72879);

(statearr_73008_73083[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (2))){
var inst_72852 = (state_72965[(17)]);
var inst_72845 = (state_72965[(16)]);
var inst_72843 = (state_72965[(23)]);
var inst_72850 = (state_72965[(9)]);
var inst_72848 = (state_72965[(14)]);
var inst_72851 = (state_72965[(20)]);
var inst_72849 = (state_72965[(19)]);
var inst_72847 = (state_72965[(11)]);
var inst_72846 = (state_72965[(18)]);
var inst_72844 = (state_72965[(7)]);
var _ = (function (){var statearr_73009 = state_72965;
(statearr_73009[(4)] = cljs.core.cons((5),(state_72965[(4)])));

return statearr_73009;
})();
var inst_72841 = flureeQL;
var inst_72842 = cljs.core.__destructure_map(inst_72841);
var inst_72843__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72842,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_72844__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72842,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_72845__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72842,new cljs.core.Keyword(null,"block","block",664686210));
var inst_72846__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72842,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_72847__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72842,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_72848__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72842,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_72849__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72842,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_72850__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72842,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_72851__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72842,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_72852__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72842,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_72853 = (function (){var construct = inst_72843__$1;
var select = inst_72844__$1;
var block = inst_72845__$1;
var where = inst_72846__$1;
var prefixes = inst_72847__$1;
var map__72840 = inst_72842;
var selectDistinct = inst_72848__$1;
var selectOne = inst_72849__$1;
var from = inst_72850__$1;
var opts = inst_72851__$1;
var selectReduced = inst_72852__$1;
return (function (p1__72833_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__72833_SHARP_);
});
})();
var inst_72854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72855 = [inst_72844__$1,inst_72849__$1,inst_72848__$1,inst_72852__$1];
var inst_72856 = (new cljs.core.PersistentVector(null,4,(5),inst_72854,inst_72855,null));
var inst_72857 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_72856);
var inst_72858 = cljs.core.count(inst_72857);
var inst_72859 = (inst_72853.cljs$core$IFn$_invoke$arity$1 ? inst_72853.cljs$core$IFn$_invoke$arity$1(inst_72858) : inst_72853.call(null,inst_72858));
var state_72965__$1 = (function (){var statearr_73010 = state_72965;
(statearr_73010[(17)] = inst_72852__$1);

(statearr_73010[(16)] = inst_72845__$1);

(statearr_73010[(23)] = inst_72843__$1);

(statearr_73010[(9)] = inst_72850__$1);

(statearr_73010[(14)] = inst_72848__$1);

(statearr_73010[(20)] = inst_72851__$1);

(statearr_73010[(19)] = inst_72849__$1);

(statearr_73010[(11)] = inst_72847__$1);

(statearr_73010[(18)] = inst_72846__$1);

(statearr_73010[(7)] = inst_72844__$1);

return statearr_73010;
})();
if(cljs.core.truth_(inst_72859)){
var statearr_73011_73084 = state_72965__$1;
(statearr_73011_73084[(1)] = (6));

} else {
var statearr_73012_73085 = state_72965__$1;
(statearr_73012_73085[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (23))){
var inst_72851 = (state_72965[(20)]);
var inst_72906 = (state_72965[(8)]);
var inst_72905 = (state_72965[(2)]);
var inst_72906__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_72851);
var state_72965__$1 = (function (){var statearr_73013 = state_72965;
(statearr_73013[(8)] = inst_72906__$1);

(statearr_73013[(24)] = inst_72905);

return statearr_73013;
})();
if(cljs.core.truth_(inst_72906__$1)){
var statearr_73014_73086 = state_72965__$1;
(statearr_73014_73086[(1)] = (24));

} else {
var statearr_73015_73087 = state_72965__$1;
(statearr_73015_73087[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (47))){
var inst_72885 = (state_72965[(10)]);
var inst_72911 = (state_72965[(25)]);
var inst_72944 = (state_72965[(2)]);
var inst_72945 = fluree.db.util.core.current_time_millis();
var inst_72946 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_72911);
var inst_72947 = fluree.db.query.fql.query(inst_72885,inst_72946);
var state_72965__$1 = (function (){var statearr_73016 = state_72965;
(statearr_73016[(26)] = inst_72944);

(statearr_73016[(27)] = inst_72945);

return statearr_73016;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72965__$1,(48),inst_72947);
} else {
if((state_val_72966 === (35))){
var inst_72923 = (state_72965[(2)]);
var state_72965__$1 = state_72965;
var statearr_73017_73088 = state_72965__$1;
(statearr_73017_73088[(2)] = inst_72923);

(statearr_73017_73088[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (19))){
var inst_72895 = (state_72965[(12)]);
var state_72965__$1 = state_72965;
var statearr_73018_73089 = state_72965__$1;
(statearr_73018_73089[(2)] = inst_72895);

(statearr_73018_73089[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (11))){
var inst_72847 = (state_72965[(11)]);
var inst_72885 = (state_72965[(2)]);
var state_72965__$1 = (function (){var statearr_73020 = state_72965;
(statearr_73020[(10)] = inst_72885);

return statearr_73020;
})();
if(cljs.core.truth_(inst_72847)){
var statearr_73021_73090 = state_72965__$1;
(statearr_73021_73090[(1)] = (15));

} else {
var statearr_73022_73091 = state_72965__$1;
(statearr_73022_73091[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (9))){
var inst_72871 = (state_72965[(28)]);
var state_72965__$1 = state_72965;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72965__$1,(13),inst_72871);
} else {
if((state_val_72966 === (5))){
var _ = (function (){var statearr_73023 = state_72965;
(statearr_73023[(4)] = cljs.core.rest((state_72965[(4)])));

return statearr_73023;
})();
var state_72965__$1 = state_72965;
var ex73019 = (state_72965__$1[(2)]);
var statearr_73024_73092 = state_72965__$1;
(statearr_73024_73092[(5)] = ex73019);


if((ex73019 instanceof Error)){
var statearr_73025_73093 = state_72965__$1;
(statearr_73025_73093[(1)] = (4));

(statearr_73025_73093[(5)] = null);

} else {
throw ex73019;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (14))){
var inst_72882 = (state_72965[(2)]);
var inst_72883 = fluree.db.util.async.throw_err(inst_72882);
var state_72965__$1 = state_72965;
var statearr_73026_73094 = state_72965__$1;
(statearr_73026_73094[(2)] = inst_72883);

(statearr_73026_73094[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (45))){
var state_72965__$1 = state_72965;
var statearr_73027_73095 = state_72965__$1;
(statearr_73027_73095[(2)] = null);

(statearr_73027_73095[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (26))){
var inst_72851 = (state_72965[(20)]);
var inst_72905 = (state_72965[(24)]);
var inst_72844 = (state_72965[(7)]);
var inst_72894 = (state_72965[(22)]);
var inst_72910 = (state_72965[(2)]);
var inst_72911 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_72851,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_72894,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_72910,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_72905], 0));
var state_72965__$1 = (function (){var statearr_73028 = state_72965;
(statearr_73028[(25)] = inst_72911);

return statearr_73028;
})();
if(cljs.core.truth_(inst_72844)){
var statearr_73029_73096 = state_72965__$1;
(statearr_73029_73096[(1)] = (27));

} else {
var statearr_73030_73097 = state_72965__$1;
(statearr_73030_73097[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (16))){
var inst_72892 = cljs.core.PersistentHashMap.EMPTY;
var state_72965__$1 = state_72965;
var statearr_73031_73098 = state_72965__$1;
(statearr_73031_73098[(2)] = inst_72892);

(statearr_73031_73098[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (38))){
var inst_72921 = (state_72965[(2)]);
var state_72965__$1 = state_72965;
var statearr_73032_73099 = state_72965__$1;
(statearr_73032_73099[(2)] = inst_72921);

(statearr_73032_73099[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (30))){
var inst_72849 = (state_72965[(19)]);
var state_72965__$1 = state_72965;
var statearr_73033_73100 = state_72965__$1;
(statearr_73033_73100[(2)] = inst_72849);

(statearr_73033_73100[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (10))){
var inst_72871 = (state_72965[(28)]);
var state_72965__$1 = state_72965;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72965__$1,(14),inst_72871);
} else {
if((state_val_72966 === (18))){
var inst_72896 = (state_72965[(21)]);
var state_72965__$1 = state_72965;
var statearr_73034_73101 = state_72965__$1;
(statearr_73034_73101[(2)] = inst_72896);

(statearr_73034_73101[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (42))){
var inst_72850 = (state_72965[(9)]);
var state_72965__$1 = state_72965;
var statearr_73035_73102 = state_72965__$1;
(statearr_73035_73102[(2)] = inst_72850);

(statearr_73035_73102[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (37))){
var inst_72843 = (state_72965[(23)]);
var state_72965__$1 = state_72965;
var statearr_73036_73103 = state_72965__$1;
(statearr_73036_73103[(2)] = inst_72843);

(statearr_73036_73103[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (8))){
var inst_72845 = (state_72965[(16)]);
var inst_72870 = (state_72965[(2)]);
var inst_72871 = sources;
var state_72965__$1 = (function (){var statearr_73037 = state_72965;
(statearr_73037[(29)] = inst_72870);

(statearr_73037[(28)] = inst_72871);

return statearr_73037;
})();
if(cljs.core.truth_(inst_72845)){
var statearr_73038_73104 = state_72965__$1;
(statearr_73038_73104[(1)] = (9));

} else {
var statearr_73039_73105 = state_72965__$1;
(statearr_73039_73105[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72966 === (49))){
var inst_72885 = (state_72965[(10)]);
var inst_72950 = (state_72965[(13)]);
var inst_72945 = (state_72965[(27)]);
var inst_72905 = (state_72965[(24)]);
var inst_72952 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_72953 = cljs.core.deref(inst_72905);
var inst_72954 = fluree.db.util.core.response_time_formatted(inst_72945);
var inst_72955 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_72885);
var inst_72956 = [(200),inst_72950,inst_72953,inst_72954,inst_72955];
var inst_72957 = cljs.core.PersistentHashMap.fromArrays(inst_72952,inst_72956);
var state_72965__$1 = state_72965;
var statearr_73040_73106 = state_72965__$1;
(statearr_73040_73106[(2)] = inst_72957);

(statearr_73040_73106[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__11438__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__11438__auto____0 = (function (){
var statearr_73041 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73041[(0)] = fluree$db$api$query$query_async_$_state_machine__11438__auto__);

(statearr_73041[(1)] = (1));

return statearr_73041;
});
var fluree$db$api$query$query_async_$_state_machine__11438__auto____1 = (function (state_72965){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_72965);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e73042){var ex__11441__auto__ = e73042;
var statearr_73043_73107 = state_72965;
(statearr_73043_73107[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_72965[(4)]))){
var statearr_73044_73108 = state_72965;
(statearr_73044_73108[(1)] = cljs.core.first((state_72965[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73109 = state_72965;
state_72965 = G__73109;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__11438__auto__ = function(state_72965){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__11438__auto____1.call(this,state_72965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__11438__auto____0;
fluree$db$api$query$query_async_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__11438__auto____1;
return fluree$db$api$query$query_async_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_73045 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_73045[(6)] = c__11512__auto__);

return statearr_73045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_73250){
var state_val_73251 = (state_73250[(1)]);
if((state_val_73251 === (7))){
var inst_73245 = (state_73250[(2)]);
var _ = (function (){var statearr_73252 = state_73250;
(statearr_73252[(4)] = cljs.core.rest((state_73250[(4)])));

return statearr_73252;
})();
var state_73250__$1 = state_73250;
var statearr_73253_73329 = state_73250__$1;
(statearr_73253_73329[(2)] = inst_73245);

(statearr_73253_73329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (20))){
var inst_73217 = (state_73250[(2)]);
var state_73250__$1 = state_73250;
var statearr_73254_73330 = state_73250__$1;
(statearr_73254_73330[(2)] = inst_73217);

(statearr_73254_73330[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (27))){
var inst_73197 = (state_73250[(7)]);
var state_73250__$1 = state_73250;
var statearr_73255_73331 = state_73250__$1;
(statearr_73255_73331[(2)] = inst_73197);

(statearr_73255_73331[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (1))){
var state_73250__$1 = state_73250;
var statearr_73256_73332 = state_73250__$1;
(statearr_73256_73332[(2)] = null);

(statearr_73256_73332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (24))){
var inst_73194 = (state_73250[(8)]);
var state_73250__$1 = state_73250;
var statearr_73257_73333 = state_73250__$1;
(statearr_73257_73333[(2)] = inst_73194);

(statearr_73257_73333[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (39))){
var inst_73151 = (state_73250[(9)]);
var inst_73184 = (state_73250[(10)]);
var inst_73162 = (state_73250[(11)]);
var inst_73228 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73229 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_73162];
var inst_73230 = (new cljs.core.PersistentVector(null,2,(5),inst_73228,inst_73229,null));
var inst_73231 = cljs.core.assoc_in(inst_73151,inst_73230,inst_73184);
var state_73250__$1 = state_73250;
var statearr_73258_73334 = state_73250__$1;
(statearr_73258_73334[(2)] = inst_73231);

(statearr_73258_73334[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (4))){
var inst_73110 = (state_73250[(2)]);
var state_73250__$1 = state_73250;
var statearr_73259_73335 = state_73250__$1;
(statearr_73259_73335[(2)] = inst_73110);

(statearr_73259_73335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (15))){
var inst_73149 = (state_73250[(12)]);
var inst_73184 = (state_73250[(10)]);
var inst_73187 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_73184);
var inst_73188 = (inst_73149 == null);
var state_73250__$1 = (function (){var statearr_73260 = state_73250;
(statearr_73260[(13)] = inst_73187);

return statearr_73260;
})();
if(cljs.core.truth_(inst_73188)){
var statearr_73261_73336 = state_73250__$1;
(statearr_73261_73336[(1)] = (18));

} else {
var statearr_73262_73337 = state_73250__$1;
(statearr_73262_73337[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (21))){
var inst_73187 = (state_73250[(13)]);
var state_73250__$1 = state_73250;
var statearr_73263_73338 = state_73250__$1;
(statearr_73263_73338[(2)] = inst_73187);

(statearr_73263_73338[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (31))){
var state_73250__$1 = state_73250;
var statearr_73264_73339 = state_73250__$1;
(statearr_73264_73339[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (32))){
var inst_73213 = (state_73250[(2)]);
var state_73250__$1 = state_73250;
var statearr_73266_73340 = state_73250__$1;
(statearr_73266_73340[(2)] = inst_73213);

(statearr_73266_73340[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (40))){
var inst_73182 = (state_73250[(14)]);
var state_73250__$1 = state_73250;
if(cljs.core.truth_(inst_73182)){
var statearr_73267_73341 = state_73250__$1;
(statearr_73267_73341[(1)] = (42));

} else {
var statearr_73268_73342 = state_73250__$1;
(statearr_73268_73342[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (33))){
var inst_73187 = (state_73250[(13)]);
var inst_73149 = (state_73250[(12)]);
var inst_73208 = ((inst_73187 > inst_73149) ? inst_73187 : inst_73149);
var state_73250__$1 = state_73250;
var statearr_73269_73343 = state_73250__$1;
(statearr_73269_73343[(2)] = inst_73208);

(statearr_73269_73343[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (13))){
var inst_73173 = (state_73250[(2)]);
var state_73250__$1 = state_73250;
var statearr_73270_73344 = state_73250__$1;
(statearr_73270_73344[(2)] = inst_73173);

(statearr_73270_73344[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (22))){
var inst_73187 = (state_73250[(13)]);
var inst_73194 = (state_73250[(8)]);
var inst_73194__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_73187);
var state_73250__$1 = (function (){var statearr_73271 = state_73250;
(statearr_73271[(8)] = inst_73194__$1);

return statearr_73271;
})();
if(inst_73194__$1){
var statearr_73272_73345 = state_73250__$1;
(statearr_73272_73345[(1)] = (24));

} else {
var statearr_73273_73346 = state_73250__$1;
(statearr_73273_73346[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (36))){
var inst_73184 = (state_73250[(10)]);
var inst_73150 = (state_73250[(15)]);
var inst_73222 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_73184,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_73223 = (inst_73150 + inst_73222);
var state_73250__$1 = state_73250;
var statearr_73274_73347 = state_73250__$1;
(statearr_73274_73347[(2)] = inst_73223);

(statearr_73274_73347[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (41))){
var inst_73161 = (state_73250[(16)]);
var inst_73226 = (state_73250[(17)]);
var inst_73220 = (state_73250[(18)]);
var inst_73240 = (state_73250[(2)]);
var inst_73148 = inst_73161;
var inst_73149 = inst_73220;
var inst_73150 = inst_73226;
var inst_73151 = inst_73240;
var state_73250__$1 = (function (){var statearr_73275 = state_73250;
(statearr_73275[(9)] = inst_73151);

(statearr_73275[(19)] = inst_73148);

(statearr_73275[(12)] = inst_73149);

(statearr_73275[(15)] = inst_73150);

return statearr_73275;
})();
var statearr_73276_73348 = state_73250__$1;
(statearr_73276_73348[(2)] = null);

(statearr_73276_73348[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (43))){
var inst_73184 = (state_73250[(10)]);
var state_73250__$1 = state_73250;
var statearr_73277_73349 = state_73250__$1;
(statearr_73277_73349[(2)] = inst_73184);

(statearr_73277_73349[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (29))){
var inst_73202 = (state_73250[(2)]);
var state_73250__$1 = state_73250;
var statearr_73278_73350 = state_73250__$1;
(statearr_73278_73350[(2)] = inst_73202);

(statearr_73278_73350[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (44))){
var inst_73151 = (state_73250[(9)]);
var inst_73162 = (state_73250[(11)]);
var inst_73237 = (state_73250[(2)]);
var inst_73238 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_73151,inst_73162,inst_73237);
var state_73250__$1 = state_73250;
var statearr_73279_73351 = state_73250__$1;
(statearr_73279_73351[(2)] = inst_73238);

(statearr_73279_73351[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (6))){
var inst_73148 = (state_73250[(19)]);
var inst_73163 = (state_73250[(20)]);
var inst_73159 = cljs.core.seq(inst_73148);
var inst_73160 = cljs.core.first(inst_73159);
var inst_73161 = cljs.core.next(inst_73159);
var inst_73162 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73160,(0),null);
var inst_73163__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73160,(1),null);
var inst_73164 = (inst_73163__$1 == null);
var state_73250__$1 = (function (){var statearr_73280 = state_73250;
(statearr_73280[(16)] = inst_73161);

(statearr_73280[(20)] = inst_73163__$1);

(statearr_73280[(11)] = inst_73162);

return statearr_73280;
})();
if(cljs.core.truth_(inst_73164)){
var statearr_73281_73352 = state_73250__$1;
(statearr_73281_73352[(1)] = (8));

} else {
var statearr_73282_73353 = state_73250__$1;
(statearr_73282_73353[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (28))){
var inst_73149 = (state_73250[(12)]);
var inst_73200 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_73149);
var state_73250__$1 = state_73250;
var statearr_73283_73354 = state_73250__$1;
(statearr_73283_73354[(2)] = inst_73200);

(statearr_73283_73354[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (25))){
var inst_73197 = (state_73250[(7)]);
var inst_73149 = (state_73250[(12)]);
var inst_73197__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_73149);
var state_73250__$1 = (function (){var statearr_73284 = state_73250;
(statearr_73284[(7)] = inst_73197__$1);

return statearr_73284;
})();
if(inst_73197__$1){
var statearr_73285_73355 = state_73250__$1;
(statearr_73285_73355[(1)] = (27));

} else {
var statearr_73286_73356 = state_73250__$1;
(statearr_73286_73356[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (34))){
var state_73250__$1 = state_73250;
var statearr_73287_73357 = state_73250__$1;
(statearr_73287_73357[(2)] = null);

(statearr_73287_73357[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (17))){
var inst_73181 = (state_73250[(21)]);
var inst_73220 = (state_73250[(2)]);
var state_73250__$1 = (function (){var statearr_73288 = state_73250;
(statearr_73288[(18)] = inst_73220);

return statearr_73288;
})();
if(cljs.core.truth_(inst_73181)){
var statearr_73289_73358 = state_73250__$1;
(statearr_73289_73358[(1)] = (36));

} else {
var statearr_73290_73359 = state_73250__$1;
(statearr_73290_73359[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (3))){
var inst_73248 = (state_73250[(2)]);
var state_73250__$1 = state_73250;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73250__$1,inst_73248);
} else {
if((state_val_73251 === (12))){
var inst_73151 = (state_73250[(9)]);
var state_73250__$1 = state_73250;
var statearr_73291_73360 = state_73250__$1;
(statearr_73291_73360[(2)] = inst_73151);

(statearr_73291_73360[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (2))){
var inst_73124 = (state_73250[(22)]);
var inst_73125 = (state_73250[(23)]);
var inst_73120 = (state_73250[(24)]);
var _ = (function (){var statearr_73292 = state_73250;
(statearr_73292[(4)] = cljs.core.cons((5),(state_73250[(4)])));

return statearr_73292;
})();
var inst_73116 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_73117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73118 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_73119 = (new cljs.core.PersistentVector(null,2,(5),inst_73117,inst_73118,null));
var inst_73120__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_73119);
var inst_73121 = (function (){var global_block = inst_73116;
var global_meta_QMARK_ = inst_73120__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_73122 = cljs.core.PersistentHashMap.EMPTY;
var inst_73123 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_73124__$1 = cljs.core.reduce_kv(inst_73121,inst_73122,inst_73123);
var inst_73125__$1 = fluree.db.util.core.current_time_millis();
var inst_73127 = (function (){var global_block = inst_73116;
var global_meta_QMARK_ = inst_73120__$1;
var queries = inst_73124__$1;
var start_time = inst_73125__$1;
return (function (p__73126){
var vec__73293 = p__73126;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73293,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73293,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_73128 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_73127,inst_73124__$1);
var inst_73142 = cljs.core.seq(inst_73128);
var inst_73143 = cljs.core.first(inst_73142);
var inst_73144 = cljs.core.next(inst_73142);
var inst_73145 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73143,(0),null);
var inst_73146 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73143,(1),null);
var inst_73147 = cljs.core.PersistentHashMap.EMPTY;
var inst_73148 = inst_73128;
var inst_73149 = null;
var inst_73150 = (0);
var inst_73151 = inst_73147;
var state_73250__$1 = (function (){var statearr_73296 = state_73250;
(statearr_73296[(9)] = inst_73151);

(statearr_73296[(25)] = inst_73144);

(statearr_73296[(22)] = inst_73124__$1);

(statearr_73296[(19)] = inst_73148);

(statearr_73296[(23)] = inst_73125__$1);

(statearr_73296[(26)] = inst_73146);

(statearr_73296[(27)] = inst_73145);

(statearr_73296[(12)] = inst_73149);

(statearr_73296[(24)] = inst_73120__$1);

(statearr_73296[(15)] = inst_73150);

return statearr_73296;
})();
var statearr_73297_73361 = state_73250__$1;
(statearr_73297_73361[(2)] = null);

(statearr_73297_73361[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (23))){
var inst_73215 = (state_73250[(2)]);
var state_73250__$1 = state_73250;
var statearr_73298_73362 = state_73250__$1;
(statearr_73298_73362[(2)] = inst_73215);

(statearr_73298_73362[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (35))){
var inst_73211 = (state_73250[(2)]);
var state_73250__$1 = state_73250;
var statearr_73299_73363 = state_73250__$1;
(statearr_73299_73363[(2)] = inst_73211);

(statearr_73299_73363[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (19))){
var inst_73187 = (state_73250[(13)]);
var inst_73149 = (state_73250[(12)]);
var inst_73191 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73149,inst_73187);
var state_73250__$1 = state_73250;
if(inst_73191){
var statearr_73300_73364 = state_73250__$1;
(statearr_73300_73364[(1)] = (21));

} else {
var statearr_73301_73365 = state_73250__$1;
(statearr_73301_73365[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (11))){
var inst_73151 = (state_73250[(9)]);
var inst_73125 = (state_73250[(23)]);
var inst_73149 = (state_73250[(12)]);
var inst_73150 = (state_73250[(15)]);
var inst_73167 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_73168 = fluree.db.util.core.response_time_formatted(inst_73125);
var inst_73169 = [inst_73151,inst_73150,inst_73149,inst_73168];
var inst_73170 = cljs.core.PersistentHashMap.fromArrays(inst_73167,inst_73169);
var state_73250__$1 = state_73250;
var statearr_73303_73366 = state_73250__$1;
(statearr_73303_73366[(2)] = inst_73170);

(statearr_73303_73366[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (9))){
var inst_73124 = (state_73250[(22)]);
var inst_73163 = (state_73250[(20)]);
var inst_73162 = (state_73250[(11)]);
var inst_73176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73177 = [inst_73162,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_73178 = (new cljs.core.PersistentVector(null,2,(5),inst_73176,inst_73177,null));
var inst_73179 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_73124,inst_73178);
var inst_73180 = cljs.core.__destructure_map(inst_73179);
var inst_73181 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73180,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_73182 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73180,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_73250__$1 = (function (){var statearr_73304 = state_73250;
(statearr_73304[(21)] = inst_73181);

(statearr_73304[(14)] = inst_73182);

return statearr_73304;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73250__$1,(14),inst_73163);
} else {
if((state_val_73251 === (5))){
var _ = (function (){var statearr_73305 = state_73250;
(statearr_73305[(4)] = cljs.core.rest((state_73250[(4)])));

return statearr_73305;
})();
var state_73250__$1 = state_73250;
var ex73302 = (state_73250__$1[(2)]);
var statearr_73306_73367 = state_73250__$1;
(statearr_73306_73367[(5)] = ex73302);


var statearr_73307_73368 = state_73250__$1;
(statearr_73307_73368[(1)] = (4));

(statearr_73307_73368[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (14))){
var inst_73184 = (state_73250[(10)]);
var inst_73181 = (state_73250[(21)]);
var inst_73184__$1 = (state_73250[(2)]);
var inst_73185 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_73184__$1);
var state_73250__$1 = (function (){var statearr_73308 = state_73250;
(statearr_73308[(28)] = inst_73185);

(statearr_73308[(10)] = inst_73184__$1);

return statearr_73308;
})();
if(cljs.core.truth_(inst_73181)){
var statearr_73309_73369 = state_73250__$1;
(statearr_73309_73369[(1)] = (15));

} else {
var statearr_73310_73370 = state_73250__$1;
(statearr_73310_73370[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (26))){
var inst_73204 = (state_73250[(2)]);
var state_73250__$1 = state_73250;
if(cljs.core.truth_(inst_73204)){
var statearr_73311_73371 = state_73250__$1;
(statearr_73311_73371[(1)] = (30));

} else {
var statearr_73312_73372 = state_73250__$1;
(statearr_73312_73372[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (16))){
var state_73250__$1 = state_73250;
var statearr_73313_73373 = state_73250__$1;
(statearr_73313_73373[(2)] = null);

(statearr_73313_73373[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (38))){
var inst_73185 = (state_73250[(28)]);
var inst_73226 = (state_73250[(2)]);
var state_73250__$1 = (function (){var statearr_73314 = state_73250;
(statearr_73314[(17)] = inst_73226);

return statearr_73314;
})();
if(cljs.core.truth_(inst_73185)){
var statearr_73315_73374 = state_73250__$1;
(statearr_73315_73374[(1)] = (39));

} else {
var statearr_73316_73375 = state_73250__$1;
(statearr_73316_73375[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (30))){
var state_73250__$1 = state_73250;
var statearr_73317_73376 = state_73250__$1;
(statearr_73317_73376[(2)] = (207));

(statearr_73317_73376[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (10))){
var inst_73243 = (state_73250[(2)]);
var state_73250__$1 = state_73250;
var statearr_73318_73377 = state_73250__$1;
(statearr_73318_73377[(2)] = inst_73243);

(statearr_73318_73377[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (18))){
var inst_73187 = (state_73250[(13)]);
var state_73250__$1 = state_73250;
var statearr_73319_73378 = state_73250__$1;
(statearr_73319_73378[(2)] = inst_73187);

(statearr_73319_73378[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (42))){
var inst_73184 = (state_73250[(10)]);
var inst_73234 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_73184);
var state_73250__$1 = state_73250;
var statearr_73320_73379 = state_73250__$1;
(statearr_73320_73379[(2)] = inst_73234);

(statearr_73320_73379[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (37))){
var state_73250__$1 = state_73250;
var statearr_73321_73380 = state_73250__$1;
(statearr_73321_73380[(2)] = null);

(statearr_73321_73380[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (8))){
var inst_73120 = (state_73250[(24)]);
var state_73250__$1 = state_73250;
if(cljs.core.truth_(inst_73120)){
var statearr_73322_73381 = state_73250__$1;
(statearr_73322_73381[(1)] = (11));

} else {
var statearr_73323_73382 = state_73250__$1;
(statearr_73323_73382[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__11438__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__11438__auto____0 = (function (){
var statearr_73324 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73324[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__11438__auto__);

(statearr_73324[(1)] = (1));

return statearr_73324;
});
var fluree$db$api$query$multi_query_async_$_state_machine__11438__auto____1 = (function (state_73250){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_73250);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e73325){var ex__11441__auto__ = e73325;
var statearr_73326_73383 = state_73250;
(statearr_73326_73383[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_73250[(4)]))){
var statearr_73327_73384 = state_73250;
(statearr_73327_73384[(1)] = cljs.core.first((state_73250[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73385 = state_73250;
state_73250 = G__73385;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__11438__auto__ = function(state_73250){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__11438__auto____1.call(this,state_73250);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__11438__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__11438__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_73328 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_73328[(6)] = c__11512__auto__);

return statearr_73328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__73386 = query_type;
var G__73386__$1 = (((G__73386 instanceof cljs.core.Keyword))?G__73386.fqn:null);
switch (G__73386__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__73386__$1)].join('')));

}
});
