// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__5774__auto__ = [];
var len__5768__auto___75302 = arguments.length;
var i__5769__auto___75303 = (0);
while(true){
if((i__5769__auto___75303 < len__5768__auto___75302)){
args__5774__auto__.push((arguments[i__5769__auto___75303]));

var G__75304 = (i__5769__auto___75303 + (1));
i__5769__auto___75303 = G__75304;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((2) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5775__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__75234){
var vec__75235 = p__75234;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75235,(0),null);
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11512__auto___75305 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_75279){
var state_val_75280 = (state_75279[(1)]);
if((state_val_75280 === (7))){
var inst_75256 = (state_75279[(7)]);
var inst_75265 = (state_75279[(8)]);
var inst_75267 = fluree.db.time_travel.as_of_block(inst_75265,inst_75256);
var state_75279__$1 = state_75279;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75279__$1,(10),inst_75267);
} else {
if((state_val_75280 === (1))){
var state_75279__$1 = state_75279;
var statearr_75281_75306 = state_75279__$1;
(statearr_75281_75306[(2)] = null);

(statearr_75281_75306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (4))){
var inst_75238 = (state_75279[(2)]);
var inst_75239 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75238], 0));
var inst_75240 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_75238);
var inst_75241 = cljs.core.async.close_BANG_(pc);
var state_75279__$1 = (function (){var statearr_75282 = state_75279;
(statearr_75282[(9)] = inst_75240);

(statearr_75282[(10)] = inst_75239);

return statearr_75282;
})();
var statearr_75283_75307 = state_75279__$1;
(statearr_75283_75307[(2)] = inst_75241);

(statearr_75283_75307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (6))){
var inst_75256 = (state_75279[(7)]);
var inst_75260 = (state_75279[(11)]);
var inst_75259 = (state_75279[(12)]);
var inst_75263 = (state_75279[(2)]);
var inst_75264 = fluree.db.util.async.throw_err(inst_75263);
var inst_75265 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_75264,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),inst_75259,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_75260], 0));
var state_75279__$1 = (function (){var statearr_75284 = state_75279;
(statearr_75284[(8)] = inst_75265);

return statearr_75284;
})();
if(cljs.core.truth_(inst_75256)){
var statearr_75285_75308 = state_75279__$1;
(statearr_75285_75308[(1)] = (7));

} else {
var statearr_75286_75309 = state_75279__$1;
(statearr_75286_75309[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (3))){
var inst_75277 = (state_75279[(2)]);
var state_75279__$1 = state_75279;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75279__$1,inst_75277);
} else {
if((state_val_75280 === (2))){
var _ = (function (){var statearr_75288 = state_75279;
(statearr_75288[(4)] = cljs.core.cons((5),(state_75279[(4)])));

return statearr_75288;
})();
var inst_75251 = opts;
var inst_75252 = cljs.core.__destructure_map(inst_75251);
var inst_75253 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75252,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_75254 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75252,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_75255 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75252,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_75256 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75252,new cljs.core.Keyword(null,"block","block",664686210));
var inst_75257 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,opts);
var inst_75258 = fluree.db.session.resolve_ledger(conn,ledger);
var inst_75259 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75258,(0),null);
var inst_75260 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75258,(1),null);
var inst_75261 = fluree.db.session.db(conn,ledger,opts);
var state_75279__$1 = (function (){var statearr_75289 = state_75279;
(statearr_75289[(13)] = inst_75254);

(statearr_75289[(14)] = inst_75253);

(statearr_75289[(15)] = inst_75257);

(statearr_75289[(7)] = inst_75256);

(statearr_75289[(16)] = inst_75255);

(statearr_75289[(11)] = inst_75260);

(statearr_75289[(12)] = inst_75259);

return statearr_75289;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75279__$1,(6),inst_75261);
} else {
if((state_val_75280 === (9))){
var inst_75273 = (state_75279[(2)]);
var inst_75274 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_75273);
var _ = (function (){var statearr_75290 = state_75279;
(statearr_75290[(4)] = cljs.core.rest((state_75279[(4)])));

return statearr_75290;
})();
var state_75279__$1 = state_75279;
var statearr_75291_75310 = state_75279__$1;
(statearr_75291_75310[(2)] = inst_75274);

(statearr_75291_75310[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (5))){
var _ = (function (){var statearr_75292 = state_75279;
(statearr_75292[(4)] = cljs.core.rest((state_75279[(4)])));

return statearr_75292;
})();
var state_75279__$1 = state_75279;
var ex75287 = (state_75279__$1[(2)]);
var statearr_75293_75311 = state_75279__$1;
(statearr_75293_75311[(5)] = ex75287);


var statearr_75294_75312 = state_75279__$1;
(statearr_75294_75312[(1)] = (4));

(statearr_75294_75312[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (10))){
var inst_75269 = (state_75279[(2)]);
var inst_75270 = fluree.db.util.async.throw_err(inst_75269);
var state_75279__$1 = state_75279;
var statearr_75295_75313 = state_75279__$1;
(statearr_75295_75313[(2)] = inst_75270);

(statearr_75295_75313[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (8))){
var inst_75265 = (state_75279[(8)]);
var state_75279__$1 = state_75279;
var statearr_75296_75314 = state_75279__$1;
(statearr_75296_75314[(2)] = inst_75265);

(statearr_75296_75314[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11438__auto__ = null;
var fluree$db$api_js$state_machine__11438__auto____0 = (function (){
var statearr_75297 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75297[(0)] = fluree$db$api_js$state_machine__11438__auto__);

(statearr_75297[(1)] = (1));

return statearr_75297;
});
var fluree$db$api_js$state_machine__11438__auto____1 = (function (state_75279){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_75279);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e75298){var ex__11441__auto__ = e75298;
var statearr_75299_75315 = state_75279;
(statearr_75299_75315[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_75279[(4)]))){
var statearr_75300_75316 = state_75279;
(statearr_75300_75316[(1)] = cljs.core.first((state_75279[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75317 = state_75279;
state_75279 = G__75317;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11438__auto__ = function(state_75279){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11438__auto____1.call(this,state_75279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11438__auto____0;
fluree$db$api_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11438__auto____1;
return fluree$db$api_js$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_75301 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_75301[(6)] = c__11512__auto___75305);

return statearr_75301;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq75231){
var G__75232 = cljs.core.first(seq75231);
var seq75231__$1 = cljs.core.next(seq75231);
var G__75233 = cljs.core.first(seq75231__$1);
var seq75231__$2 = cljs.core.next(seq75231__$1);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__75232,G__75233,seq75231__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__5043__auto__){
var and__5043__auto____$1 = open_api;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(network,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(val,/\//)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__5043__auto__){
return open_api;
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__5043__auto__){
return auth;
} else {
return and__5043__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__75319 = arguments.length;
switch (G__75319) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_75445){
var state_val_75446 = (state_75445[(1)]);
if((state_val_75446 === (7))){
var inst_75345 = (state_75445[(7)]);
var inst_75335 = (state_75445[(8)]);
var inst_75347 = fluree.db.time_travel.as_of_block(inst_75345,inst_75335);
var state_75445__$1 = state_75445;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75445__$1,(10),inst_75347);
} else {
if((state_val_75446 === (20))){
var inst_75339 = (state_75445[(9)]);
var state_75445__$1 = state_75445;
var statearr_75447_75527 = state_75445__$1;
(statearr_75447_75527[(2)] = inst_75339);

(statearr_75447_75527[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (27))){
var inst_75333 = (state_75445[(10)]);
var state_75445__$1 = state_75445;
var statearr_75448_75528 = state_75445__$1;
(statearr_75448_75528[(2)] = inst_75333);

(statearr_75448_75528[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (1))){
var state_75445__$1 = state_75445;
var statearr_75449_75529 = state_75445__$1;
(statearr_75449_75529[(2)] = null);

(statearr_75449_75529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (24))){
var inst_75342 = (state_75445[(11)]);
var state_75445__$1 = state_75445;
if(cljs.core.truth_(inst_75342)){
var statearr_75450_75530 = state_75445__$1;
(statearr_75450_75530[(1)] = (26));

} else {
var statearr_75451_75531 = state_75445__$1;
(statearr_75451_75531[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (39))){
var inst_75407 = (state_75445[(12)]);
var inst_75410 = cljs.core.ex_data(inst_75407);
var inst_75411 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75412 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_75410);
var inst_75413 = cljs.core.ex_message(inst_75407);
var inst_75414 = [inst_75412,inst_75413,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75415 = cljs.core.PersistentHashMap.fromArrays(inst_75411,inst_75414);
var state_75445__$1 = state_75445;
var statearr_75452_75532 = state_75445__$1;
(statearr_75452_75532[(2)] = inst_75415);

(statearr_75452_75532[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (46))){
var inst_75407 = (state_75445[(12)]);
var state_75445__$1 = state_75445;
var statearr_75453_75533 = state_75445__$1;
(statearr_75453_75533[(2)] = inst_75407);

(statearr_75453_75533[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (4))){
var inst_75320 = (state_75445[(2)]);
var inst_75321 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75320], 0));
var inst_75322 = cljs.core.ex_data(inst_75320);
var inst_75323 = cljs.core.ex_message(inst_75320);
var inst_75324 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75322,new cljs.core.Keyword(null,"message","message",-406056002),inst_75323);
var state_75445__$1 = (function (){var statearr_75454 = state_75445;
(statearr_75454[(13)] = inst_75321);

return statearr_75454;
})();
var statearr_75455_75534 = state_75445__$1;
(statearr_75455_75534[(2)] = inst_75324);

(statearr_75455_75534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (15))){
var state_75445__$1 = state_75445;
var statearr_75456_75535 = state_75445__$1;
(statearr_75456_75535[(2)] = (1000000));

(statearr_75456_75535[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (48))){
var inst_75407 = (state_75445[(12)]);
var state_75445__$1 = state_75445;
var statearr_75457_75536 = state_75445__$1;
(statearr_75457_75536[(2)] = inst_75407);

(statearr_75457_75536[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (50))){
var inst_75434 = (state_75445[(2)]);
var state_75445__$1 = state_75445;
var statearr_75458_75537 = state_75445__$1;
(statearr_75458_75537[(2)] = inst_75434);

(statearr_75458_75537[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (21))){
var inst_75338 = (state_75445[(14)]);
var state_75445__$1 = state_75445;
if(cljs.core.truth_(inst_75338)){
var statearr_75459_75538 = state_75445__$1;
(statearr_75459_75538[(1)] = (23));

} else {
var statearr_75460_75539 = state_75445__$1;
(statearr_75460_75539[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (31))){
var inst_75396 = (state_75445[(2)]);
var inst_75397 = cljs.core.not(inst_75396);
var state_75445__$1 = state_75445;
if(inst_75397){
var statearr_75461_75540 = state_75445__$1;
(statearr_75461_75540[(1)] = (35));

} else {
var statearr_75462_75541 = state_75445__$1;
(statearr_75462_75541[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (32))){
var inst_75340 = (state_75445[(15)]);
var state_75445__$1 = state_75445;
var statearr_75463_75542 = state_75445__$1;
(statearr_75463_75542[(2)] = inst_75340);

(statearr_75463_75542[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (40))){
var inst_75370 = (state_75445[(16)]);
var state_75445__$1 = state_75445;
if(cljs.core.truth_(inst_75370)){
var statearr_75464_75543 = state_75445__$1;
(statearr_75464_75543[(1)] = (42));

} else {
var statearr_75465_75544 = state_75445__$1;
(statearr_75465_75544[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (33))){
var inst_75336 = (state_75445[(17)]);
var state_75445__$1 = state_75445;
var statearr_75466_75545 = state_75445__$1;
(statearr_75466_75545[(2)] = inst_75336);

(statearr_75466_75545[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (13))){
var inst_75365 = (state_75445[(18)]);
var inst_75341 = (state_75445[(19)]);
var inst_75363 = (state_75445[(2)]);
var inst_75364 = cljs.core.volatile_BANG_((0));
var inst_75365__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_75341);
var state_75445__$1 = (function (){var statearr_75467 = state_75445;
(statearr_75467[(20)] = inst_75363);

(statearr_75467[(18)] = inst_75365__$1);

(statearr_75467[(21)] = inst_75364);

return statearr_75467;
})();
if(cljs.core.truth_(inst_75365__$1)){
var statearr_75468_75546 = state_75445__$1;
(statearr_75468_75546[(1)] = (14));

} else {
var statearr_75469_75547 = state_75445__$1;
(statearr_75469_75547[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (22))){
var inst_75386 = (state_75445[(2)]);
var state_75445__$1 = state_75445;
var statearr_75470_75548 = state_75445__$1;
(statearr_75470_75548[(2)] = inst_75386);

(statearr_75470_75548[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (36))){
var inst_75372 = (state_75445[(22)]);
var inst_75353 = (state_75445[(23)]);
var inst_75403 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_75372);
var inst_75404 = fluree.db.query.fql.query(inst_75353,inst_75403);
var state_75445__$1 = state_75445;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75445__$1,(38),inst_75404);
} else {
if((state_val_75446 === (41))){
var inst_75438 = (state_75445[(2)]);
var state_75445__$1 = state_75445;
var statearr_75471_75549 = state_75445__$1;
(statearr_75471_75549[(2)] = inst_75438);

(statearr_75471_75549[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (43))){
var state_75445__$1 = state_75445;
var statearr_75472_75550 = state_75445__$1;
(statearr_75472_75550[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (29))){
var inst_75340 = (state_75445[(15)]);
var state_75445__$1 = state_75445;
if(cljs.core.truth_(inst_75340)){
var statearr_75474_75551 = state_75445__$1;
(statearr_75474_75551[(1)] = (32));

} else {
var statearr_75475_75552 = state_75445__$1;
(statearr_75475_75552[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (44))){
var inst_75436 = (state_75445[(2)]);
var state_75445__$1 = state_75445;
var statearr_75476_75553 = state_75445__$1;
(statearr_75476_75553[(2)] = inst_75436);

(statearr_75476_75553[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (6))){
var inst_75335 = (state_75445[(8)]);
var inst_75344 = (state_75445[(2)]);
var inst_75345 = fluree.db.util.async.throw_err(inst_75344);
var state_75445__$1 = (function (){var statearr_75477 = state_75445;
(statearr_75477[(7)] = inst_75345);

return statearr_75477;
})();
if(cljs.core.truth_(inst_75335)){
var statearr_75478_75554 = state_75445__$1;
(statearr_75478_75554[(1)] = (7));

} else {
var statearr_75479_75555 = state_75445__$1;
(statearr_75479_75555[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (28))){
var inst_75382 = (state_75445[(2)]);
var state_75445__$1 = state_75445;
var statearr_75480_75556 = state_75445__$1;
(statearr_75480_75556[(2)] = inst_75382);

(statearr_75480_75556[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (25))){
var inst_75384 = (state_75445[(2)]);
var state_75445__$1 = state_75445;
var statearr_75481_75557 = state_75445__$1;
(statearr_75481_75557[(2)] = inst_75384);

(statearr_75481_75557[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (34))){
var inst_75393 = (state_75445[(2)]);
var state_75445__$1 = state_75445;
var statearr_75482_75558 = state_75445__$1;
(statearr_75482_75558[(2)] = inst_75393);

(statearr_75482_75558[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (17))){
var inst_75334 = (state_75445[(24)]);
var state_75445__$1 = state_75445;
var statearr_75483_75559 = state_75445__$1;
(statearr_75483_75559[(2)] = inst_75334);

(statearr_75483_75559[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (3))){
var inst_75443 = (state_75445[(2)]);
var state_75445__$1 = state_75445;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75445__$1,inst_75443);
} else {
if((state_val_75446 === (12))){
var inst_75361 = cljs.core.PersistentHashMap.EMPTY;
var state_75445__$1 = state_75445;
var statearr_75484_75560 = state_75445__$1;
(statearr_75484_75560[(2)] = inst_75361);

(statearr_75484_75560[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (2))){
var _ = (function (){var statearr_75485 = state_75445;
(statearr_75485[(4)] = cljs.core.cons((5),(state_75445[(4)])));

return statearr_75485;
})();
var inst_75331 = query_map;
var inst_75332 = cljs.core.__destructure_map(inst_75331);
var inst_75333 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75332,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_75334 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75332,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_75335 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75332,new cljs.core.Keyword(null,"block","block",664686210));
var inst_75336 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75332,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_75337 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75332,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_75338 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75332,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_75339 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75332,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_75340 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75332,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_75341 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75332,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_75342 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75332,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_75445__$1 = (function (){var statearr_75486 = state_75445;
(statearr_75486[(15)] = inst_75340);

(statearr_75486[(9)] = inst_75339);

(statearr_75486[(17)] = inst_75336);

(statearr_75486[(11)] = inst_75342);

(statearr_75486[(24)] = inst_75334);

(statearr_75486[(25)] = inst_75337);

(statearr_75486[(14)] = inst_75338);

(statearr_75486[(19)] = inst_75341);

(statearr_75486[(8)] = inst_75335);

(statearr_75486[(10)] = inst_75333);

return statearr_75486;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75445__$1,(6),sources);
} else {
if((state_val_75446 === (23))){
var inst_75338 = (state_75445[(14)]);
var state_75445__$1 = state_75445;
var statearr_75487_75561 = state_75445__$1;
(statearr_75487_75561[(2)] = inst_75338);

(statearr_75487_75561[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (47))){
var inst_75418 = (state_75445[(26)]);
var inst_75371 = (state_75445[(27)]);
var inst_75353 = (state_75445[(23)]);
var inst_75364 = (state_75445[(21)]);
var inst_75424 = (state_75445[(2)]);
var inst_75425 = cljs.core.deref(inst_75364);
var inst_75426 = fluree.db.util.core.response_time_formatted(inst_75371);
var inst_75427 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_75353);
var inst_75428 = [(200),inst_75424,inst_75425,inst_75426,inst_75427];
var inst_75429 = cljs.core.PersistentHashMap.fromArrays(inst_75418,inst_75428);
var state_75445__$1 = state_75445;
var statearr_75488_75562 = state_75445__$1;
(statearr_75488_75562[(2)] = inst_75429);

(statearr_75488_75562[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (35))){
var inst_75399 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75400 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75401 = cljs.core.PersistentHashMap.fromArrays(inst_75399,inst_75400);
var state_75445__$1 = state_75445;
var statearr_75489_75563 = state_75445__$1;
(statearr_75489_75563[(2)] = inst_75401);

(statearr_75489_75563[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (19))){
var inst_75388 = (state_75445[(28)]);
var inst_75388__$1 = (state_75445[(2)]);
var state_75445__$1 = (function (){var statearr_75490 = state_75445;
(statearr_75490[(28)] = inst_75388__$1);

return statearr_75490;
})();
if(cljs.core.truth_(inst_75388__$1)){
var statearr_75491_75564 = state_75445__$1;
(statearr_75491_75564[(1)] = (29));

} else {
var statearr_75492_75565 = state_75445__$1;
(statearr_75492_75565[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (11))){
var inst_75353 = (state_75445[(23)]);
var inst_75354 = (state_75445[(29)]);
var inst_75337 = (state_75445[(25)]);
var inst_75356 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_75353);
var inst_75357 = fluree.db.connection_js.open_api_QMARK_(inst_75354);
var inst_75358 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_75353);
var inst_75359 = fluree.db.api_js.get_sources(inst_75354,inst_75356,inst_75357,inst_75358,inst_75337,db_fn);
var state_75445__$1 = state_75445;
var statearr_75494_75566 = state_75445__$1;
(statearr_75494_75566[(2)] = inst_75359);

(statearr_75494_75566[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (9))){
var inst_75353 = (state_75445[(23)]);
var inst_75337 = (state_75445[(25)]);
var inst_75353__$1 = (state_75445[(2)]);
var inst_75354 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_75353__$1);
var state_75445__$1 = (function (){var statearr_75495 = state_75445;
(statearr_75495[(23)] = inst_75353__$1);

(statearr_75495[(29)] = inst_75354);

return statearr_75495;
})();
if(cljs.core.truth_(inst_75337)){
var statearr_75496_75567 = state_75445__$1;
(statearr_75496_75567[(1)] = (11));

} else {
var statearr_75497_75568 = state_75445__$1;
(statearr_75497_75568[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (5))){
var _ = (function (){var statearr_75498 = state_75445;
(statearr_75498[(4)] = cljs.core.rest((state_75445[(4)])));

return statearr_75498;
})();
var state_75445__$1 = state_75445;
var ex75493 = (state_75445__$1[(2)]);
var statearr_75499_75569 = state_75445__$1;
(statearr_75499_75569[(5)] = ex75493);


var statearr_75500_75570 = state_75445__$1;
(statearr_75500_75570[(1)] = (4));

(statearr_75500_75570[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (14))){
var inst_75365 = (state_75445[(18)]);
var state_75445__$1 = state_75445;
var statearr_75501_75571 = state_75445__$1;
(statearr_75501_75571[(2)] = inst_75365);

(statearr_75501_75571[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (45))){
var inst_75407 = (state_75445[(12)]);
var inst_75421 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_75407);
var state_75445__$1 = state_75445;
var statearr_75502_75572 = state_75445__$1;
(statearr_75502_75572[(2)] = inst_75421);

(statearr_75502_75572[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (26))){
var inst_75342 = (state_75445[(11)]);
var state_75445__$1 = state_75445;
var statearr_75503_75573 = state_75445__$1;
(statearr_75503_75573[(2)] = inst_75342);

(statearr_75503_75573[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (16))){
var inst_75363 = (state_75445[(20)]);
var inst_75334 = (state_75445[(24)]);
var inst_75341 = (state_75445[(19)]);
var inst_75364 = (state_75445[(21)]);
var inst_75369 = (state_75445[(2)]);
var inst_75370 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_75341);
var inst_75371 = fluree.db.util.core.current_time_millis();
var inst_75372 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_75341,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_75363,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_75369,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_75364], 0));
var state_75445__$1 = (function (){var statearr_75504 = state_75445;
(statearr_75504[(27)] = inst_75371);

(statearr_75504[(22)] = inst_75372);

(statearr_75504[(16)] = inst_75370);

return statearr_75504;
})();
if(cljs.core.truth_(inst_75334)){
var statearr_75505_75574 = state_75445__$1;
(statearr_75505_75574[(1)] = (17));

} else {
var statearr_75506_75575 = state_75445__$1;
(statearr_75506_75575[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (38))){
var inst_75407 = (state_75445[(12)]);
var inst_75406 = (state_75445[(2)]);
var inst_75407__$1 = fluree.db.util.async.throw_err(inst_75406);
var inst_75408 = (inst_75407__$1 instanceof cljs.core.ExceptionInfo);
var state_75445__$1 = (function (){var statearr_75507 = state_75445;
(statearr_75507[(12)] = inst_75407__$1);

return statearr_75507;
})();
if(cljs.core.truth_(inst_75408)){
var statearr_75508_75576 = state_75445__$1;
(statearr_75508_75576[(1)] = (39));

} else {
var statearr_75509_75577 = state_75445__$1;
(statearr_75509_75577[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (30))){
var inst_75388 = (state_75445[(28)]);
var state_75445__$1 = state_75445;
var statearr_75510_75578 = state_75445__$1;
(statearr_75510_75578[(2)] = inst_75388);

(statearr_75510_75578[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (10))){
var inst_75349 = (state_75445[(2)]);
var inst_75350 = fluree.db.util.async.throw_err(inst_75349);
var state_75445__$1 = state_75445;
var statearr_75511_75579 = state_75445__$1;
(statearr_75511_75579[(2)] = inst_75350);

(statearr_75511_75579[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (18))){
var inst_75339 = (state_75445[(9)]);
var state_75445__$1 = state_75445;
if(cljs.core.truth_(inst_75339)){
var statearr_75512_75580 = state_75445__$1;
(statearr_75512_75580[(1)] = (20));

} else {
var statearr_75513_75581 = state_75445__$1;
(statearr_75513_75581[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (42))){
var inst_75407 = (state_75445[(12)]);
var inst_75418 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_75419 = cljs.core.sequential_QMARK_(inst_75407);
var state_75445__$1 = (function (){var statearr_75514 = state_75445;
(statearr_75514[(26)] = inst_75418);

return statearr_75514;
})();
if(inst_75419){
var statearr_75515_75582 = state_75445__$1;
(statearr_75515_75582[(1)] = (45));

} else {
var statearr_75516_75583 = state_75445__$1;
(statearr_75516_75583[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (37))){
var inst_75440 = (state_75445[(2)]);
var _ = (function (){var statearr_75517 = state_75445;
(statearr_75517[(4)] = cljs.core.rest((state_75445[(4)])));

return statearr_75517;
})();
var state_75445__$1 = state_75445;
var statearr_75518_75584 = state_75445__$1;
(statearr_75518_75584[(2)] = inst_75440);

(statearr_75518_75584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (8))){
var inst_75345 = (state_75445[(7)]);
var state_75445__$1 = state_75445;
var statearr_75519_75585 = state_75445__$1;
(statearr_75519_75585[(2)] = inst_75345);

(statearr_75519_75585[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75446 === (49))){
var state_75445__$1 = state_75445;
var statearr_75520_75586 = state_75445__$1;
(statearr_75520_75586[(2)] = null);

(statearr_75520_75586[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11438__auto__ = null;
var fluree$db$api_js$state_machine__11438__auto____0 = (function (){
var statearr_75521 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75521[(0)] = fluree$db$api_js$state_machine__11438__auto__);

(statearr_75521[(1)] = (1));

return statearr_75521;
});
var fluree$db$api_js$state_machine__11438__auto____1 = (function (state_75445){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_75445);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e75522){var ex__11441__auto__ = e75522;
var statearr_75523_75587 = state_75445;
(statearr_75523_75587[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_75445[(4)]))){
var statearr_75524_75588 = state_75445;
(statearr_75524_75588[(1)] = cljs.core.first((state_75445[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75589 = state_75445;
state_75445 = G__75589;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11438__auto__ = function(state_75445){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11438__auto____1.call(this,state_75445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11438__auto____0;
fluree$db$api_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11438__auto____1;
return fluree$db$api_js$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_75525 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_75525[(6)] = c__11512__auto__);

return statearr_75525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var key = cljs.core.random_uuid();
var resp_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout_ms);
fluree.db.session.monitor_tx(session,tid,key,(function (p1__75590_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,p1__75590_SHARP_);
}));

var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_75612){
var state_val_75613 = (state_75612[(1)]);
if((state_val_75613 === (1))){
var inst_75594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75595 = [resp_chan,timeout_chan];
var inst_75596 = (new cljs.core.PersistentVector(null,2,(5),inst_75594,inst_75595,null));
var state_75612__$1 = state_75612;
return cljs.core.async.ioc_alts_BANG_(state_75612__$1,(2),inst_75596);
} else {
if((state_val_75613 === (2))){
var inst_75598 = (state_75612[(2)]);
var inst_75599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75598,(0),null);
var inst_75600 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75598,(1),null);
var inst_75601 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(timeout_chan,inst_75600);
var state_75612__$1 = (function (){var statearr_75614 = state_75612;
(statearr_75614[(7)] = inst_75599);

return statearr_75614;
})();
if(inst_75601){
var statearr_75615_75625 = state_75612__$1;
(statearr_75615_75625[(1)] = (3));

} else {
var statearr_75616_75626 = state_75612__$1;
(statearr_75616_75626[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75613 === (3))){
var inst_75603 = fluree.db.session.monitor_tx_remove(session,tid,key);
var inst_75604 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_75605 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_75606 = [tid,(408),inst_75605];
var inst_75607 = cljs.core.PersistentHashMap.fromArrays(inst_75604,inst_75606);
var state_75612__$1 = (function (){var statearr_75617 = state_75612;
(statearr_75617[(8)] = inst_75603);

return statearr_75617;
})();
var statearr_75618_75627 = state_75612__$1;
(statearr_75618_75627[(2)] = inst_75607);

(statearr_75618_75627[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75613 === (4))){
var inst_75599 = (state_75612[(7)]);
var state_75612__$1 = state_75612;
var statearr_75619_75628 = state_75612__$1;
(statearr_75619_75628[(2)] = inst_75599);

(statearr_75619_75628[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75613 === (5))){
var inst_75610 = (state_75612[(2)]);
var state_75612__$1 = state_75612;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75612__$1,inst_75610);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__11438__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__11438__auto____0 = (function (){
var statearr_75620 = [null,null,null,null,null,null,null,null,null];
(statearr_75620[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__11438__auto__);

(statearr_75620[(1)] = (1));

return statearr_75620;
});
var fluree$db$api_js$monitor_tx_$_state_machine__11438__auto____1 = (function (state_75612){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_75612);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e75621){var ex__11441__auto__ = e75621;
var statearr_75622_75629 = state_75612;
(statearr_75622_75629[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_75612[(4)]))){
var statearr_75623_75630 = state_75612;
(statearr_75623_75630[(1)] = cljs.core.first((state_75612[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75631 = state_75612;
state_75612 = G__75631;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__11438__auto__ = function(state_75612){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__11438__auto____1.call(this,state_75612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__11438__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__11438__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_75624 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_75624[(6)] = c__11512__auto__);

return statearr_75624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__75633 = arguments.length;
switch (G__75633) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__75634 = opts;
var map__75634__$1 = cljs.core.__destructure_map(map__75634);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75634__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75634__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75634__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75634__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_(deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__75635 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75635,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75635,(1),null);
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e75638){var e = e75638;

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__75641 = arguments.length;
switch (G__75641) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_75707){
var state_val_75708 = (state_75707[(1)]);
if((state_val_75708 === (7))){
var inst_75661 = (state_75707[(7)]);
var inst_75660 = (state_75707[(8)]);
var inst_75663 = (state_75707[(9)]);
var inst_75658 = (state_75707[(10)]);
var inst_75662 = (state_75707[(11)]);
var inst_75676 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_75677 = [ledger,txn,inst_75658,inst_75660,inst_75661,inst_75662,inst_75663];
var inst_75678 = cljs.core.PersistentHashMap.fromArrays(inst_75676,inst_75677);
var inst_75679 = fluree.db.util.core.without_nils(inst_75678);
var inst_75680 = fluree.db.operations.transact_async(conn,inst_75679);
var state_75707__$1 = state_75707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75707__$1,(13),inst_75680);
} else {
if((state_val_75708 === (20))){
var inst_75698 = (state_75707[(2)]);
var state_75707__$1 = state_75707;
var statearr_75709_75745 = state_75707__$1;
(statearr_75709_75745[(2)] = inst_75698);

(statearr_75709_75745[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75708 === (1))){
var state_75707__$1 = state_75707;
var statearr_75710_75746 = state_75707__$1;
(statearr_75710_75746[(2)] = null);

(statearr_75710_75746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75708 === (4))){
var inst_75642 = (state_75707[(2)]);
var inst_75643 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75642], 0));
var inst_75644 = cljs.core.ex_data(inst_75642);
var inst_75645 = cljs.core.ex_message(inst_75642);
var inst_75646 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75644,new cljs.core.Keyword(null,"message","message",-406056002),inst_75645);
var state_75707__$1 = (function (){var statearr_75711 = state_75707;
(statearr_75711[(12)] = inst_75643);

return statearr_75711;
})();
var statearr_75712_75747 = state_75707__$1;
(statearr_75712_75747[(2)] = inst_75646);

(statearr_75712_75747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75708 === (15))){
var inst_75682 = (state_75707[(13)]);
var inst_75657 = (state_75707[(14)]);
var inst_75685 = fluree.db.api_js.monitor_tx(conn,ledger,inst_75682,inst_75657);
var state_75707__$1 = state_75707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75707__$1,(17),inst_75685);
} else {
if((state_val_75708 === (13))){
var inst_75656 = (state_75707[(15)]);
var inst_75682 = (state_75707[(2)]);
var state_75707__$1 = (function (){var statearr_75713 = state_75707;
(statearr_75713[(13)] = inst_75682);

return statearr_75713;
})();
if(cljs.core.truth_(inst_75656)){
var statearr_75714_75748 = state_75707__$1;
(statearr_75714_75748[(1)] = (14));

} else {
var statearr_75715_75749 = state_75707__$1;
(statearr_75715_75749[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75708 === (6))){
var inst_75656 = (state_75707[(15)]);
var inst_75655 = (state_75707[(16)]);
var inst_75665 = fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,inst_75655,opts);
var inst_75666 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_75665);
var inst_75667 = fluree.db.operations.command_async(conn,inst_75665);
var state_75707__$1 = (function (){var statearr_75716 = state_75707;
(statearr_75716[(17)] = inst_75666);

(statearr_75716[(18)] = inst_75667);

return statearr_75716;
})();
if(cljs.core.truth_(inst_75656)){
var statearr_75717_75750 = state_75707__$1;
(statearr_75717_75750[(1)] = (9));

} else {
var statearr_75718_75751 = state_75707__$1;
(statearr_75718_75751[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75708 === (17))){
var inst_75687 = (state_75707[(19)]);
var inst_75687__$1 = (state_75707[(2)]);
var inst_75688 = (inst_75687__$1 instanceof cljs.core.ExceptionInfo);
var state_75707__$1 = (function (){var statearr_75719 = state_75707;
(statearr_75719[(19)] = inst_75687__$1);

return statearr_75719;
})();
if(cljs.core.truth_(inst_75688)){
var statearr_75720_75752 = state_75707__$1;
(statearr_75720_75752[(1)] = (18));

} else {
var statearr_75721_75753 = state_75707__$1;
(statearr_75721_75753[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75708 === (3))){
var inst_75705 = (state_75707[(2)]);
var state_75707__$1 = state_75707;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75707__$1,inst_75705);
} else {
if((state_val_75708 === (12))){
var inst_75672 = (state_75707[(2)]);
var state_75707__$1 = state_75707;
var statearr_75722_75754 = state_75707__$1;
(statearr_75722_75754[(2)] = inst_75672);

(statearr_75722_75754[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75708 === (2))){
var inst_75655 = (state_75707[(16)]);
var _ = (function (){var statearr_75723 = state_75707;
(statearr_75723[(4)] = cljs.core.cons((5),(state_75707[(4)])));

return statearr_75723;
})();
var inst_75653 = opts;
var inst_75654 = cljs.core.__destructure_map(inst_75653);
var inst_75655__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75654,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_75656 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75654,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_75657 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_75654,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_75658 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75654,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_75659 = fluree.db.util.core.current_time_millis();
var inst_75660 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_75654,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_75659);
var inst_75661 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75654,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_75662 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75654,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_75663 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75654,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_75707__$1 = (function (){var statearr_75724 = state_75707;
(statearr_75724[(7)] = inst_75661);

(statearr_75724[(15)] = inst_75656);

(statearr_75724[(14)] = inst_75657);

(statearr_75724[(8)] = inst_75660);

(statearr_75724[(9)] = inst_75663);

(statearr_75724[(10)] = inst_75658);

(statearr_75724[(11)] = inst_75662);

(statearr_75724[(16)] = inst_75655__$1);

return statearr_75724;
})();
if(cljs.core.truth_(inst_75655__$1)){
var statearr_75725_75755 = state_75707__$1;
(statearr_75725_75755[(1)] = (6));

} else {
var statearr_75726_75756 = state_75707__$1;
(statearr_75726_75756[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75708 === (19))){
var inst_75687 = (state_75707[(19)]);
var state_75707__$1 = state_75707;
var statearr_75727_75757 = state_75707__$1;
(statearr_75727_75757[(2)] = inst_75687);

(statearr_75727_75757[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75708 === (11))){
var inst_75674 = (state_75707[(2)]);
var state_75707__$1 = state_75707;
var statearr_75729_75758 = state_75707__$1;
(statearr_75729_75758[(2)] = inst_75674);

(statearr_75729_75758[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75708 === (9))){
var inst_75667 = (state_75707[(18)]);
var state_75707__$1 = state_75707;
var statearr_75730_75759 = state_75707__$1;
(statearr_75730_75759[(2)] = inst_75667);

(statearr_75730_75759[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75708 === (5))){
var _ = (function (){var statearr_75731 = state_75707;
(statearr_75731[(4)] = cljs.core.rest((state_75707[(4)])));

return statearr_75731;
})();
var state_75707__$1 = state_75707;
var ex75728 = (state_75707__$1[(2)]);
var statearr_75732_75760 = state_75707__$1;
(statearr_75732_75760[(5)] = ex75728);


var statearr_75733_75761 = state_75707__$1;
(statearr_75733_75761[(1)] = (4));

(statearr_75733_75761[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75708 === (14))){
var inst_75682 = (state_75707[(13)]);
var state_75707__$1 = state_75707;
var statearr_75734_75762 = state_75707__$1;
(statearr_75734_75762[(2)] = inst_75682);

(statearr_75734_75762[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75708 === (16))){
var inst_75700 = (state_75707[(2)]);
var state_75707__$1 = state_75707;
var statearr_75735_75763 = state_75707__$1;
(statearr_75735_75763[(2)] = inst_75700);

(statearr_75735_75763[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75708 === (10))){
var inst_75666 = (state_75707[(17)]);
var inst_75657 = (state_75707[(14)]);
var inst_75670 = fluree.db.api_js.monitor_tx(conn,ledger,inst_75666,inst_75657);
var state_75707__$1 = state_75707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75707__$1,(12),inst_75670);
} else {
if((state_val_75708 === (18))){
var inst_75687 = (state_75707[(19)]);
var inst_75690 = cljs.core.ex_data(inst_75687);
var inst_75691 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75692 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_75690);
var inst_75693 = cljs.core.ex_message(inst_75687);
var inst_75694 = [inst_75692,inst_75693,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_75695 = cljs.core.PersistentHashMap.fromArrays(inst_75691,inst_75694);
var state_75707__$1 = state_75707;
var statearr_75736_75764 = state_75707__$1;
(statearr_75736_75764[(2)] = inst_75695);

(statearr_75736_75764[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75708 === (8))){
var inst_75702 = (state_75707[(2)]);
var _ = (function (){var statearr_75737 = state_75707;
(statearr_75737[(4)] = cljs.core.rest((state_75707[(4)])));

return statearr_75737;
})();
var state_75707__$1 = state_75707;
var statearr_75738_75765 = state_75707__$1;
(statearr_75738_75765[(2)] = inst_75702);

(statearr_75738_75765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11438__auto__ = null;
var fluree$db$api_js$state_machine__11438__auto____0 = (function (){
var statearr_75739 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75739[(0)] = fluree$db$api_js$state_machine__11438__auto__);

(statearr_75739[(1)] = (1));

return statearr_75739;
});
var fluree$db$api_js$state_machine__11438__auto____1 = (function (state_75707){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_75707);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e75740){var ex__11441__auto__ = e75740;
var statearr_75741_75766 = state_75707;
(statearr_75741_75766[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_75707[(4)]))){
var statearr_75742_75767 = state_75707;
(statearr_75742_75767[(1)] = cljs.core.first((state_75707[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75768 = state_75707;
state_75707 = G__75768;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11438__auto__ = function(state_75707){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11438__auto____1.call(this,state_75707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11438__auto____0;
fluree$db$api_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11438__auto____1;
return fluree$db$api_js$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_75743 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_75743[(6)] = c__11512__auto__);

return statearr_75743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__5774__auto__ = [];
var len__5768__auto___75770 = arguments.length;
var i__5769__auto___75771 = (0);
while(true){
if((i__5769__auto___75771 < len__5768__auto___75770)){
args__5774__auto__.push((arguments[i__5769__auto___75771]));

var G__75772 = (i__5769__auto___75771 + (1));
i__5769__auto___75771 = G__75772;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq75769){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq75769));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_75803){
var state_val_75804 = (state_75803[(1)]);
if((state_val_75804 === (1))){
var inst_75773 = cljs.core.first(flakes);
var inst_75774 = cljs.core.rest(flakes);
var inst_75775 = cljs.core.PersistentVector.EMPTY;
var inst_75776 = inst_75773;
var inst_75777 = inst_75774;
var inst_75778 = inst_75775;
var state_75803__$1 = (function (){var statearr_75805 = state_75803;
(statearr_75805[(7)] = inst_75776);

(statearr_75805[(8)] = inst_75777);

(statearr_75805[(9)] = inst_75778);

return statearr_75805;
})();
var statearr_75806_75819 = state_75803__$1;
(statearr_75806_75819[(2)] = null);

(statearr_75806_75819[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75804 === (2))){
var inst_75776 = (state_75803[(7)]);
var inst_75780 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_75781 = cljs.core.PersistentHashMap.EMPTY;
var inst_75782 = [true,inst_75781];
var inst_75783 = cljs.core.PersistentHashMap.fromArrays(inst_75780,inst_75782);
var inst_75784 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_75783,inst_75776);
var state_75803__$1 = state_75803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75803__$1,(4),inst_75784);
} else {
if((state_val_75804 === (3))){
var inst_75801 = (state_75803[(2)]);
var state_75803__$1 = state_75803;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75803__$1,inst_75801);
} else {
if((state_val_75804 === (4))){
var inst_75777 = (state_75803[(8)]);
var inst_75778 = (state_75803[(9)]);
var inst_75786 = (state_75803[(2)]);
var inst_75787 = fluree.db.util.async.throw_err(inst_75786);
var inst_75788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75789 = [inst_75787];
var inst_75790 = (new cljs.core.PersistentVector(null,1,(5),inst_75788,inst_75789,null));
var inst_75791 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_75778,inst_75790);
var inst_75792 = cljs.core.first(inst_75777);
var state_75803__$1 = (function (){var statearr_75807 = state_75803;
(statearr_75807[(10)] = inst_75791);

return statearr_75807;
})();
if(cljs.core.truth_(inst_75792)){
var statearr_75808_75820 = state_75803__$1;
(statearr_75808_75820[(1)] = (5));

} else {
var statearr_75809_75821 = state_75803__$1;
(statearr_75809_75821[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75804 === (5))){
var inst_75791 = (state_75803[(10)]);
var inst_75777 = (state_75803[(8)]);
var inst_75794 = cljs.core.first(inst_75777);
var inst_75795 = cljs.core.rest(inst_75777);
var inst_75776 = inst_75794;
var inst_75777__$1 = inst_75795;
var inst_75778 = inst_75791;
var state_75803__$1 = (function (){var statearr_75810 = state_75803;
(statearr_75810[(7)] = inst_75776);

(statearr_75810[(8)] = inst_75777__$1);

(statearr_75810[(9)] = inst_75778);

return statearr_75810;
})();
var statearr_75811_75822 = state_75803__$1;
(statearr_75811_75822[(2)] = null);

(statearr_75811_75822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75804 === (6))){
var inst_75791 = (state_75803[(10)]);
var state_75803__$1 = state_75803;
var statearr_75812_75823 = state_75803__$1;
(statearr_75812_75823[(2)] = inst_75791);

(statearr_75812_75823[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75804 === (7))){
var inst_75799 = (state_75803[(2)]);
var state_75803__$1 = state_75803;
var statearr_75813_75824 = state_75803__$1;
(statearr_75813_75824[(2)] = inst_75799);

(statearr_75813_75824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11438__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11438__auto____0 = (function (){
var statearr_75814 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_75814[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11438__auto__);

(statearr_75814[(1)] = (1));

return statearr_75814;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11438__auto____1 = (function (state_75803){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_75803);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e75815){var ex__11441__auto__ = e75815;
var statearr_75816_75825 = state_75803;
(statearr_75816_75825[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_75803[(4)]))){
var statearr_75817_75826 = state_75803;
(statearr_75817_75826[(1)] = cljs.core.first((state_75803[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75827 = state_75803;
state_75803 = G__75827;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11438__auto__ = function(state_75803){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11438__auto____1.call(this,state_75803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11438__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11438__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_75818 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_75818[(6)] = c__11512__auto__);

return statearr_75818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_75895){
var state_val_75896 = (state_75895[(1)]);
if((state_val_75896 === (7))){
var inst_75855 = (state_75895[(2)]);
var inst_75856 = fluree.db.util.async.throw_err(inst_75855);
var state_75895__$1 = state_75895;
var statearr_75897_75923 = state_75895__$1;
(statearr_75897_75923[(2)] = inst_75856);

(statearr_75897_75923[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75896 === (1))){
var inst_75832 = cljs.core.volatile_BANG_((0));
var inst_75833 = cljs.core.PersistentHashMap.EMPTY;
var inst_75834 = cljs.core.volatile_BANG_(inst_75833);
var inst_75835 = cljs.core.first(resp);
var inst_75836 = cljs.core.rest(resp);
var inst_75837 = cljs.core.PersistentVector.EMPTY;
var inst_75838 = inst_75832;
var inst_75839 = inst_75834;
var inst_75840 = inst_75835;
var inst_75841 = inst_75836;
var inst_75842 = inst_75837;
var state_75895__$1 = (function (){var statearr_75898 = state_75895;
(statearr_75898[(7)] = inst_75840);

(statearr_75898[(8)] = inst_75838);

(statearr_75898[(9)] = inst_75841);

(statearr_75898[(10)] = inst_75839);

(statearr_75898[(11)] = inst_75842);

return statearr_75898;
})();
var statearr_75899_75924 = state_75895__$1;
(statearr_75899_75924[(2)] = null);

(statearr_75899_75924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75896 === (4))){
var inst_75840 = (state_75895[(7)]);
var inst_75838 = (state_75895[(8)]);
var inst_75841 = (state_75895[(9)]);
var inst_75844 = (state_75895[(12)]);
var inst_75839 = (state_75895[(10)]);
var inst_75846 = (state_75895[(13)]);
var inst_75842 = (state_75895[(11)]);
var inst_75850 = (function (){var fuel = inst_75838;
var cache = inst_75839;
var curr_block = inst_75840;
var rest_blocks = inst_75841;
var acc = inst_75842;
var flakes = inst_75844;
var asserted = inst_75846;
return (function (p1__75829_SHARP_){
return p1__75829_SHARP_.s;
});
})();
var inst_75851 = cljs.core.group_by(inst_75850,inst_75846);
var inst_75852 = cljs.core.vals(inst_75851);
var inst_75853 = fluree.db.api_js.format_flake_groups_pretty(db,inst_75839,inst_75838,inst_75852);
var state_75895__$1 = state_75895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75895__$1,(7),inst_75853);
} else {
if((state_val_75896 === (13))){
var inst_75883 = (state_75895[(14)]);
var state_75895__$1 = state_75895;
var statearr_75900_75925 = state_75895__$1;
(statearr_75900_75925[(2)] = inst_75883);

(statearr_75900_75925[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75896 === (6))){
var inst_75840 = (state_75895[(7)]);
var inst_75838 = (state_75895[(8)]);
var inst_75841 = (state_75895[(9)]);
var inst_75844 = (state_75895[(12)]);
var inst_75859 = (state_75895[(15)]);
var inst_75839 = (state_75895[(10)]);
var inst_75846 = (state_75895[(13)]);
var inst_75861 = (state_75895[(16)]);
var inst_75842 = (state_75895[(11)]);
var inst_75859__$1 = (state_75895[(2)]);
var inst_75860 = (function (){var fuel = inst_75838;
var cache = inst_75839;
var curr_block = inst_75840;
var rest_blocks = inst_75841;
var acc = inst_75842;
var flakes = inst_75844;
var asserted = inst_75846;
var asserted_SINGLEQUOTE_ = inst_75859__$1;
return (function (p1__75830_SHARP_){
return p1__75830_SHARP_.op === false;
});
})();
var inst_75861__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_75860,inst_75844);
var inst_75862 = cljs.core.empty_QMARK_(inst_75861__$1);
var inst_75863 = (!(inst_75862));
var state_75895__$1 = (function (){var statearr_75903 = state_75895;
(statearr_75903[(15)] = inst_75859__$1);

(statearr_75903[(16)] = inst_75861__$1);

return statearr_75903;
})();
if(inst_75863){
var statearr_75904_75926 = state_75895__$1;
(statearr_75904_75926[(1)] = (8));

} else {
var statearr_75905_75927 = state_75895__$1;
(statearr_75905_75927[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75896 === (3))){
var inst_75893 = (state_75895[(2)]);
var state_75895__$1 = state_75895;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75895__$1,inst_75893);
} else {
if((state_val_75896 === (12))){
var inst_75838 = (state_75895[(8)]);
var inst_75841 = (state_75895[(9)]);
var inst_75883 = (state_75895[(14)]);
var inst_75839 = (state_75895[(10)]);
var inst_75886 = cljs.core.first(inst_75841);
var inst_75887 = cljs.core.rest(inst_75841);
var tmp75901 = inst_75838;
var tmp75902 = inst_75839;
var inst_75838__$1 = tmp75901;
var inst_75839__$1 = tmp75902;
var inst_75840 = inst_75886;
var inst_75841__$1 = inst_75887;
var inst_75842 = inst_75883;
var state_75895__$1 = (function (){var statearr_75906 = state_75895;
(statearr_75906[(7)] = inst_75840);

(statearr_75906[(8)] = inst_75838__$1);

(statearr_75906[(9)] = inst_75841__$1);

(statearr_75906[(10)] = inst_75839__$1);

(statearr_75906[(11)] = inst_75842);

return statearr_75906;
})();
var statearr_75907_75928 = state_75895__$1;
(statearr_75907_75928[(2)] = null);

(statearr_75907_75928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75896 === (2))){
var inst_75840 = (state_75895[(7)]);
var inst_75838 = (state_75895[(8)]);
var inst_75841 = (state_75895[(9)]);
var inst_75844 = (state_75895[(12)]);
var inst_75839 = (state_75895[(10)]);
var inst_75846 = (state_75895[(13)]);
var inst_75842 = (state_75895[(11)]);
var inst_75844__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_75840);
var inst_75845 = (function (){var fuel = inst_75838;
var cache = inst_75839;
var curr_block = inst_75840;
var rest_blocks = inst_75841;
var acc = inst_75842;
var flakes = inst_75844__$1;
return (function (p1__75828_SHARP_){
return p1__75828_SHARP_.op;
});
})();
var inst_75846__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_75845,inst_75844__$1);
var inst_75847 = cljs.core.empty_QMARK_(inst_75846__$1);
var inst_75848 = (!(inst_75847));
var state_75895__$1 = (function (){var statearr_75908 = state_75895;
(statearr_75908[(12)] = inst_75844__$1);

(statearr_75908[(13)] = inst_75846__$1);

return statearr_75908;
})();
if(inst_75848){
var statearr_75909_75929 = state_75895__$1;
(statearr_75909_75929[(1)] = (4));

} else {
var statearr_75910_75930 = state_75895__$1;
(statearr_75910_75930[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75896 === (11))){
var inst_75871 = (state_75895[(2)]);
var inst_75872 = fluree.db.util.async.throw_err(inst_75871);
var state_75895__$1 = state_75895;
var statearr_75911_75931 = state_75895__$1;
(statearr_75911_75931[(2)] = inst_75872);

(statearr_75911_75931[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75896 === (9))){
var state_75895__$1 = state_75895;
var statearr_75912_75932 = state_75895__$1;
(statearr_75912_75932[(2)] = null);

(statearr_75912_75932[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75896 === (5))){
var state_75895__$1 = state_75895;
var statearr_75913_75933 = state_75895__$1;
(statearr_75913_75933[(2)] = null);

(statearr_75913_75933[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75896 === (14))){
var inst_75891 = (state_75895[(2)]);
var state_75895__$1 = state_75895;
var statearr_75914_75934 = state_75895__$1;
(statearr_75914_75934[(2)] = inst_75891);

(statearr_75914_75934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75896 === (10))){
var inst_75840 = (state_75895[(7)]);
var inst_75841 = (state_75895[(9)]);
var inst_75859 = (state_75895[(15)]);
var inst_75842 = (state_75895[(11)]);
var inst_75875 = (state_75895[(2)]);
var inst_75876 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_75877 = [inst_75859,inst_75875];
var inst_75878 = cljs.core.PersistentHashMap.fromArrays(inst_75876,inst_75877);
var inst_75879 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75840,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_75878);
var inst_75880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75881 = [inst_75879];
var inst_75882 = (new cljs.core.PersistentVector(null,1,(5),inst_75880,inst_75881,null));
var inst_75883 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_75842,inst_75882);
var inst_75884 = cljs.core.first(inst_75841);
var state_75895__$1 = (function (){var statearr_75915 = state_75895;
(statearr_75915[(14)] = inst_75883);

return statearr_75915;
})();
if(cljs.core.truth_(inst_75884)){
var statearr_75916_75935 = state_75895__$1;
(statearr_75916_75935[(1)] = (12));

} else {
var statearr_75917_75936 = state_75895__$1;
(statearr_75917_75936[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75896 === (8))){
var inst_75840 = (state_75895[(7)]);
var inst_75838 = (state_75895[(8)]);
var inst_75841 = (state_75895[(9)]);
var inst_75844 = (state_75895[(12)]);
var inst_75859 = (state_75895[(15)]);
var inst_75839 = (state_75895[(10)]);
var inst_75846 = (state_75895[(13)]);
var inst_75861 = (state_75895[(16)]);
var inst_75842 = (state_75895[(11)]);
var inst_75865 = (function (){var flakes = inst_75844;
var rest_blocks = inst_75841;
var curr_block = inst_75840;
var asserted_SINGLEQUOTE_ = inst_75859;
var acc = inst_75842;
var fuel = inst_75838;
var cache = inst_75839;
var retracted = inst_75861;
var asserted = inst_75846;
return (function (p1__75831_SHARP_){
return p1__75831_SHARP_.s;
});
})();
var inst_75866 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.flip_flake,inst_75861);
var inst_75867 = cljs.core.group_by(inst_75865,inst_75866);
var inst_75868 = cljs.core.vals(inst_75867);
var inst_75869 = fluree.db.api_js.format_flake_groups_pretty(db,inst_75839,inst_75838,inst_75868);
var state_75895__$1 = state_75895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75895__$1,(11),inst_75869);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__11438__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__11438__auto____0 = (function (){
var statearr_75918 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75918[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__11438__auto__);

(statearr_75918[(1)] = (1));

return statearr_75918;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__11438__auto____1 = (function (state_75895){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_75895);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e75919){var ex__11441__auto__ = e75919;
var statearr_75920_75937 = state_75895;
(statearr_75920_75937[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_75895[(4)]))){
var statearr_75921_75938 = state_75895;
(statearr_75921_75938[(1)] = cljs.core.first((state_75895[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75939 = state_75895;
state_75895 = G__75939;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__11438__auto__ = function(state_75895){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__11438__auto____1.call(this,state_75895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__11438__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__11438__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_75922 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_75922[(6)] = c__11512__auto__);

return statearr_75922;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_76039){
var state_val_76040 = (state_76039[(1)]);
if((state_val_76040 === (7))){
var inst_76004 = (state_76039[(7)]);
var inst_76011 = (state_76039[(8)]);
var inst_76010 = cljs.core.seq(inst_76004);
var inst_76011__$1 = cljs.core.first(inst_76010);
var inst_76012 = cljs.core.next(inst_76010);
var state_76039__$1 = (function (){var statearr_76041 = state_76039;
(statearr_76041[(9)] = inst_76012);

(statearr_76041[(8)] = inst_76011__$1);

return statearr_76041;
})();
if(cljs.core.truth_(inst_76011__$1)){
var statearr_76042_76079 = state_76039__$1;
(statearr_76042_76079[(1)] = (9));

} else {
var statearr_76043_76080 = state_76039__$1;
(statearr_76043_76080[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76040 === (1))){
var state_76039__$1 = state_76039;
var statearr_76044_76081 = state_76039__$1;
(statearr_76044_76081[(2)] = null);

(statearr_76044_76081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76040 === (4))){
var inst_75941 = (state_76039[(2)]);
var state_76039__$1 = state_76039;
var statearr_76045_76082 = state_76039__$1;
(statearr_76045_76082[(2)] = inst_75941);

(statearr_76045_76082[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76040 === (6))){
var inst_75990 = (state_76039[(2)]);
var inst_75991 = fluree.db.util.async.throw_err(inst_75990);
var inst_75999 = resp;
var inst_76000 = cljs.core.seq(inst_75999);
var inst_76001 = cljs.core.first(inst_76000);
var inst_76002 = cljs.core.next(inst_76000);
var inst_76003 = cljs.core.PersistentHashMap.EMPTY;
var inst_76004 = inst_75999;
var inst_76005 = inst_76003;
var state_76039__$1 = (function (){var statearr_76046 = state_76039;
(statearr_76046[(7)] = inst_76004);

(statearr_76046[(10)] = inst_76005);

(statearr_76046[(11)] = inst_76001);

(statearr_76046[(12)] = inst_75991);

(statearr_76046[(13)] = inst_76002);

return statearr_76046;
})();
var statearr_76047_76083 = state_76039__$1;
(statearr_76047_76083[(2)] = null);

(statearr_76047_76083[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76040 === (3))){
var inst_76037 = (state_76039[(2)]);
var state_76039__$1 = state_76039;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76039__$1,inst_76037);
} else {
if((state_val_76040 === (2))){
var _ = (function (){var statearr_76048 = state_76039;
(statearr_76048[(4)] = cljs.core.cons((5),(state_76039[(4)])));

return statearr_76048;
})();
var inst_75947 = (function (){return (function (p1__75940_SHARP_){
return p1__75940_SHARP_.t;
});
})();
var inst_75948 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_75947,resp);
var inst_75949 = cljs.core.set(inst_75948);
var inst_75986 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_75987 = (function (){var ts = inst_75949;
var c__11512__auto____$1 = inst_75986;
return (function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_75984){
var state_val_75985 = (state_75984[(1)]);
if((state_val_75985 === (1))){
var inst_75957 = ts;
var inst_75958 = cljs.core.seq(inst_75957);
var inst_75959 = cljs.core.first(inst_75958);
var inst_75960 = cljs.core.next(inst_75958);
var inst_75961 = cljs.core.PersistentHashMap.EMPTY;
var inst_75962 = inst_75957;
var inst_75963 = inst_75961;
var state_75984__$1 = (function (){var statearr_76049 = state_75984;
(statearr_76049[(7)] = inst_75959);

(statearr_76049[(8)] = inst_75960);

(statearr_76049[(9)] = inst_75962);

(statearr_76049[(10)] = inst_75963);

return statearr_76049;
})();
var statearr_76050_76084 = state_75984__$1;
(statearr_76050_76084[(2)] = null);

(statearr_76050_76084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75985 === (2))){
var inst_75969 = (state_75984[(11)]);
var inst_75962 = (state_75984[(9)]);
var inst_75968 = cljs.core.seq(inst_75962);
var inst_75969__$1 = cljs.core.first(inst_75968);
var inst_75970 = cljs.core.next(inst_75968);
var state_75984__$1 = (function (){var statearr_76051 = state_75984;
(statearr_76051[(11)] = inst_75969__$1);

(statearr_76051[(12)] = inst_75970);

return statearr_76051;
})();
if(cljs.core.truth_(inst_75969__$1)){
var statearr_76052_76085 = state_75984__$1;
(statearr_76052_76085[(1)] = (4));

} else {
var statearr_76053_76086 = state_75984__$1;
(statearr_76053_76086[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75985 === (3))){
var inst_75982 = (state_75984[(2)]);
var state_75984__$1 = state_75984;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75984__$1,inst_75982);
} else {
if((state_val_75985 === (4))){
var inst_75969 = (state_75984[(11)]);
var inst_75972 = fluree.db.time_travel.non_border_t_to_block(db,inst_75969);
var state_75984__$1 = state_75984;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75984__$1,(7),inst_75972);
} else {
if((state_val_75985 === (5))){
var inst_75963 = (state_75984[(10)]);
var state_75984__$1 = state_75984;
var statearr_76054_76087 = state_75984__$1;
(statearr_76054_76087[(2)] = inst_75963);

(statearr_76054_76087[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75985 === (6))){
var inst_75980 = (state_75984[(2)]);
var state_75984__$1 = state_75984;
var statearr_76055_76088 = state_75984__$1;
(statearr_76055_76088[(2)] = inst_75980);

(statearr_76055_76088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75985 === (7))){
var inst_75969 = (state_75984[(11)]);
var inst_75970 = (state_75984[(12)]);
var inst_75963 = (state_75984[(10)]);
var inst_75974 = (state_75984[(2)]);
var inst_75975 = fluree.db.util.async.throw_err(inst_75974);
var inst_75976 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75963,inst_75969,inst_75975);
var inst_75962 = inst_75970;
var inst_75963__$1 = inst_75976;
var state_75984__$1 = (function (){var statearr_76056 = state_75984;
(statearr_76056[(9)] = inst_75962);

(statearr_76056[(10)] = inst_75963__$1);

return statearr_76056;
})();
var statearr_76057_76089 = state_75984__$1;
(statearr_76057_76089[(2)] = null);

(statearr_76057_76089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__11438__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__11438__auto____0 = (function (){
var statearr_76058 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76058[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__11438__auto__);

(statearr_76058[(1)] = (1));

return statearr_76058;
});
var fluree$db$api_js$format_history_resp_$_state_machine__11438__auto____1 = (function (state_75984){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_75984);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e76059){var ex__11441__auto__ = e76059;
var statearr_76060_76090 = state_75984;
(statearr_76060_76090[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_75984[(4)]))){
var statearr_76061_76091 = state_75984;
(statearr_76061_76091[(1)] = cljs.core.first((state_75984[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76092 = state_75984;
state_75984 = G__76092;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__11438__auto__ = function(state_75984){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__11438__auto____1.call(this,state_75984);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__11438__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__11438__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_76062 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_76062[(6)] = c__11512__auto____$1);

return statearr_76062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
});
})();
var inst_75988 = cljs.core.async.impl.dispatch.run(inst_75987);
var state_76039__$1 = (function (){var statearr_76063 = state_76039;
(statearr_76063[(14)] = inst_75988);

return statearr_76063;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76039__$1,(6),inst_75986);
} else {
if((state_val_76040 === (11))){
var inst_76031 = (state_76039[(2)]);
var state_76039__$1 = state_76039;
var statearr_76065_76093 = state_76039__$1;
(statearr_76065_76093[(2)] = inst_76031);

(statearr_76065_76093[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76040 === (9))){
var inst_76012 = (state_76039[(9)]);
var inst_76011 = (state_76039[(8)]);
var inst_76005 = (state_76039[(10)]);
var inst_75991 = (state_76039[(12)]);
var inst_76014 = inst_76011.t;
var inst_76015 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75991,inst_76014);
var inst_76016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76017 = [inst_76015,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_76018 = (new cljs.core.PersistentVector(null,2,(5),inst_76016,inst_76017,null));
var inst_76019 = cljs.core.assoc_in(inst_76005,inst_76018,inst_76015);
var inst_76020 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76021 = [inst_76015,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_76022 = (new cljs.core.PersistentVector(null,2,(5),inst_76020,inst_76021,null));
var inst_76023 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_76019,inst_76022,cljs.core.conj,inst_76011);
var inst_76024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76025 = [inst_76015,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_76026 = (new cljs.core.PersistentVector(null,2,(5),inst_76024,inst_76025,null));
var inst_76027 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_76023,inst_76026,fluree.db.api_js.min_safe,inst_76014);
var inst_76004 = inst_76012;
var inst_76005__$1 = inst_76027;
var state_76039__$1 = (function (){var statearr_76066 = state_76039;
(statearr_76066[(7)] = inst_76004);

(statearr_76066[(10)] = inst_76005__$1);

return statearr_76066;
})();
var statearr_76067_76094 = state_76039__$1;
(statearr_76067_76094[(2)] = null);

(statearr_76067_76094[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76040 === (5))){
var _ = (function (){var statearr_76068 = state_76039;
(statearr_76068[(4)] = cljs.core.rest((state_76039[(4)])));

return statearr_76068;
})();
var state_76039__$1 = state_76039;
var ex76064 = (state_76039__$1[(2)]);
var statearr_76069_76095 = state_76039__$1;
(statearr_76069_76095[(5)] = ex76064);


if((ex76064 instanceof Error)){
var statearr_76070_76096 = state_76039__$1;
(statearr_76070_76096[(1)] = (4));

(statearr_76070_76096[(5)] = null);

} else {
throw ex76064;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76040 === (10))){
var inst_76005 = (state_76039[(10)]);
var state_76039__$1 = state_76039;
var statearr_76071_76097 = state_76039__$1;
(statearr_76071_76097[(2)] = inst_76005);

(statearr_76071_76097[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76040 === (8))){
var inst_76033 = (state_76039[(2)]);
var inst_76034 = cljs.core.vals(inst_76033);
var _ = (function (){var statearr_76072 = state_76039;
(statearr_76072[(4)] = cljs.core.rest((state_76039[(4)])));

return statearr_76072;
})();
var state_76039__$1 = state_76039;
var statearr_76073_76098 = state_76039__$1;
(statearr_76073_76098[(2)] = inst_76034);

(statearr_76073_76098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__11438__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__11438__auto____0 = (function (){
var statearr_76074 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76074[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__11438__auto__);

(statearr_76074[(1)] = (1));

return statearr_76074;
});
var fluree$db$api_js$format_history_resp_$_state_machine__11438__auto____1 = (function (state_76039){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_76039);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e76075){var ex__11441__auto__ = e76075;
var statearr_76076_76099 = state_76039;
(statearr_76076_76099[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_76039[(4)]))){
var statearr_76077_76100 = state_76039;
(statearr_76077_76100[(1)] = cljs.core.first((state_76039[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76101 = state_76039;
state_76039 = G__76101;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__11438__auto__ = function(state_76039){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__11438__auto____1.call(this,state_76039);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__11438__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__11438__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_76078 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_76078[(6)] = c__11512__auto__);

return statearr_76078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_76246){
var state_val_76247 = (state_76246[(1)]);
if((state_val_76247 === (7))){
var inst_76126 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76127 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_76128 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_76129 = [inst_76127,inst_76128];
var inst_76130 = (new cljs.core.PersistentVector(null,2,(5),inst_76126,inst_76129,null));
var state_76246__$1 = state_76246;
var statearr_76248_76319 = state_76246__$1;
(statearr_76248_76319[(2)] = inst_76130);

(statearr_76248_76319[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (20))){
var inst_76156 = (state_76246[(7)]);
var state_76246__$1 = state_76246;
var statearr_76249_76320 = state_76246__$1;
(statearr_76249_76320[(2)] = inst_76156);

(statearr_76249_76320[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (27))){
var state_76246__$1 = state_76246;
var statearr_76250_76321 = state_76246__$1;
(statearr_76250_76321[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (1))){
var state_76246__$1 = state_76246;
var statearr_76252_76322 = state_76246__$1;
(statearr_76252_76322[(2)] = null);

(statearr_76252_76322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (24))){
var inst_76155 = (state_76246[(8)]);
var state_76246__$1 = state_76246;
if(cljs.core.truth_(inst_76155)){
var statearr_76253_76323 = state_76246__$1;
(statearr_76253_76323[(1)] = (26));

} else {
var statearr_76254_76324 = state_76246__$1;
(statearr_76254_76324[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (39))){
var inst_76202 = (state_76246[(9)]);
var inst_76201 = (state_76246[(10)]);
var inst_76227 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76228 = [inst_76201,inst_76202];
var inst_76229 = (new cljs.core.PersistentVector(null,2,(5),inst_76227,inst_76228,null));
var state_76246__$1 = state_76246;
var statearr_76255_76325 = state_76246__$1;
(statearr_76255_76325[(2)] = inst_76229);

(statearr_76255_76325[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (4))){
var inst_76102 = (state_76246[(2)]);
var inst_76103 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76102], 0));
var inst_76104 = cljs.core.ex_data(inst_76102);
var inst_76105 = cljs.core.ex_message(inst_76102);
var inst_76106 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76104,new cljs.core.Keyword(null,"message","message",-406056002),inst_76105);
var state_76246__$1 = (function (){var statearr_76256 = state_76246;
(statearr_76256[(11)] = inst_76103);

return statearr_76256;
})();
var statearr_76257_76326 = state_76246__$1;
(statearr_76257_76326[(2)] = inst_76106);

(statearr_76257_76326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (15))){
var inst_76135 = (state_76246[(12)]);
var inst_76140 = (state_76246[(13)]);
var inst_76149 = (state_76246[(2)]);
var inst_76150 = [inst_76140,inst_76149];
var inst_76151 = (new cljs.core.PersistentVector(null,2,(5),inst_76135,inst_76150,null));
var state_76246__$1 = state_76246;
var statearr_76258_76327 = state_76246__$1;
(statearr_76258_76327[(2)] = inst_76151);

(statearr_76258_76327[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (21))){
var inst_76155 = (state_76246[(8)]);
var state_76246__$1 = state_76246;
var statearr_76259_76328 = state_76246__$1;
(statearr_76259_76328[(2)] = inst_76155);

(statearr_76259_76328[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (31))){
var inst_76196 = (state_76246[(2)]);
var state_76246__$1 = state_76246;
var statearr_76260_76329 = state_76246__$1;
(statearr_76260_76329[(2)] = inst_76196);

(statearr_76260_76329[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (32))){
var inst_76202 = (state_76246[(9)]);
var inst_76205 = cljs.core.pos_int_QMARK_(inst_76202);
var state_76246__$1 = state_76246;
var statearr_76261_76330 = state_76246__$1;
(statearr_76261_76330[(2)] = inst_76205);

(statearr_76261_76330[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (40))){
var inst_76157 = (state_76246[(14)]);
var inst_76233 = (state_76246[(15)]);
var inst_76231 = (state_76246[(2)]);
var inst_76232 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76231,(0),null);
var inst_76233__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76231,(1),null);
var inst_76234 = (inst_76233__$1 > inst_76157);
var state_76246__$1 = (function (){var statearr_76262 = state_76246;
(statearr_76262[(16)] = inst_76232);

(statearr_76262[(15)] = inst_76233__$1);

return statearr_76262;
})();
if(cljs.core.truth_(inst_76234)){
var statearr_76263_76331 = state_76246__$1;
(statearr_76263_76331[(1)] = (41));

} else {
var statearr_76264_76332 = state_76246__$1;
(statearr_76264_76332[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (33))){
var inst_76203 = (state_76246[(17)]);
var state_76246__$1 = state_76246;
var statearr_76265_76333 = state_76246__$1;
(statearr_76265_76333[(2)] = inst_76203);

(statearr_76265_76333[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (13))){
var inst_76141 = (state_76246[(18)]);
var inst_76143 = fluree.db.time_travel.block_to_int_format(db,inst_76141);
var state_76246__$1 = state_76246;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76246__$1,(16),inst_76143);
} else {
if((state_val_76247 === (22))){
var inst_76174 = (state_76246[(2)]);
var state_76246__$1 = state_76246;
if(cljs.core.truth_(inst_76174)){
var statearr_76266_76334 = state_76246__$1;
(statearr_76266_76334[(1)] = (23));

} else {
var statearr_76267_76335 = state_76246__$1;
(statearr_76267_76335[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (36))){
var state_76246__$1 = state_76246;
var statearr_76268_76336 = state_76246__$1;
(statearr_76268_76336[(2)] = null);

(statearr_76268_76336[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (41))){
var inst_76157 = (state_76246[(14)]);
var state_76246__$1 = state_76246;
var statearr_76269_76337 = state_76246__$1;
(statearr_76269_76337[(2)] = inst_76157);

(statearr_76269_76337[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (43))){
var inst_76232 = (state_76246[(16)]);
var inst_76238 = (state_76246[(2)]);
var inst_76239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76240 = [inst_76232,inst_76238];
var inst_76241 = (new cljs.core.PersistentVector(null,2,(5),inst_76239,inst_76240,null));
var _ = (function (){var statearr_76270 = state_76246;
(statearr_76270[(4)] = cljs.core.rest((state_76246[(4)])));

return statearr_76270;
})();
var state_76246__$1 = state_76246;
var statearr_76271_76338 = state_76246__$1;
(statearr_76271_76338[(2)] = inst_76241);

(statearr_76271_76338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (29))){
var inst_76132 = (state_76246[(19)]);
var inst_76187 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76132], 0));
var inst_76188 = ["Invalid block range provided: ",inst_76187].join('');
var inst_76189 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76190 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_76191 = cljs.core.PersistentHashMap.fromArrays(inst_76189,inst_76190);
var inst_76192 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76188,inst_76191);
var inst_76193 = (function(){throw inst_76192})();
var state_76246__$1 = state_76246;
var statearr_76272_76339 = state_76246__$1;
(statearr_76272_76339[(2)] = inst_76193);

(statearr_76272_76339[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (6))){
var inst_76124 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_76246__$1 = state_76246;
var statearr_76273_76340 = state_76246__$1;
(statearr_76273_76340[(2)] = inst_76124);

(statearr_76273_76340[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (28))){
var inst_76198 = (state_76246[(2)]);
var state_76246__$1 = state_76246;
var statearr_76274_76341 = state_76246__$1;
(statearr_76274_76341[(2)] = inst_76198);

(statearr_76274_76341[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (25))){
var inst_76203 = (state_76246[(17)]);
var inst_76201 = (state_76246[(10)]);
var inst_76200 = (state_76246[(2)]);
var inst_76201__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76200,(0),null);
var inst_76202 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76200,(1),null);
var inst_76203__$1 = cljs.core.pos_int_QMARK_(inst_76201__$1);
var state_76246__$1 = (function (){var statearr_76275 = state_76246;
(statearr_76275[(17)] = inst_76203__$1);

(statearr_76275[(9)] = inst_76202);

(statearr_76275[(10)] = inst_76201__$1);

return statearr_76275;
})();
if(inst_76203__$1){
var statearr_76276_76342 = state_76246__$1;
(statearr_76276_76342[(1)] = (32));

} else {
var statearr_76277_76343 = state_76246__$1;
(statearr_76277_76343[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (34))){
var inst_76208 = (state_76246[(2)]);
var inst_76209 = cljs.core.not(inst_76208);
var state_76246__$1 = state_76246;
if(inst_76209){
var statearr_76278_76344 = state_76246__$1;
(statearr_76278_76344[(1)] = (35));

} else {
var statearr_76279_76345 = state_76246__$1;
(statearr_76279_76345[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (17))){
var inst_76157 = (state_76246[(14)]);
var inst_76155 = (state_76246[(8)]);
var inst_76160 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76155], 0));
var inst_76161 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76157], 0));
var inst_76162 = ["Start block is out of range for this ledger. Start block provided: ",inst_76160,". Database block: ",inst_76161].join('');
var inst_76163 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76164 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_76165 = cljs.core.PersistentHashMap.fromArrays(inst_76163,inst_76164);
var inst_76166 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76162,inst_76165);
var inst_76167 = (function(){throw inst_76166})();
var state_76246__$1 = state_76246;
var statearr_76280_76346 = state_76246__$1;
(statearr_76280_76346[(2)] = inst_76167);

(statearr_76280_76346[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (3))){
var inst_76244 = (state_76246[(2)]);
var state_76246__$1 = state_76246;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76246__$1,inst_76244);
} else {
if((state_val_76247 === (12))){
var inst_76132 = (state_76246[(19)]);
var inst_76141 = (state_76246[(18)]);
var inst_76139 = (state_76246[(2)]);
var inst_76140 = fluree.db.util.async.throw_err(inst_76139);
var inst_76141__$1 = cljs.core.second(inst_76132);
var state_76246__$1 = (function (){var statearr_76281 = state_76246;
(statearr_76281[(13)] = inst_76140);

(statearr_76281[(18)] = inst_76141__$1);

return statearr_76281;
})();
if(cljs.core.truth_(inst_76141__$1)){
var statearr_76282_76347 = state_76246__$1;
(statearr_76282_76347[(1)] = (13));

} else {
var statearr_76283_76348 = state_76246__$1;
(statearr_76283_76348[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (2))){
var _ = (function (){var statearr_76284 = state_76246;
(statearr_76284[(4)] = cljs.core.cons((5),(state_76246[(4)])));

return statearr_76284;
})();
var inst_76121 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_76122 = cljs.core.sequential_QMARK_(inst_76121);
var state_76246__$1 = state_76246;
if(inst_76122){
var statearr_76285_76349 = state_76246__$1;
(statearr_76285_76349[(1)] = (6));

} else {
var statearr_76286_76350 = state_76246__$1;
(statearr_76286_76350[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (23))){
var inst_76155 = (state_76246[(8)]);
var inst_76156 = (state_76246[(7)]);
var inst_76176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76177 = [inst_76155,inst_76156];
var inst_76178 = (new cljs.core.PersistentVector(null,2,(5),inst_76176,inst_76177,null));
var state_76246__$1 = state_76246;
var statearr_76287_76351 = state_76246__$1;
(statearr_76287_76351[(2)] = inst_76178);

(statearr_76287_76351[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (35))){
var inst_76132 = (state_76246[(19)]);
var inst_76211 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76132], 0));
var inst_76212 = ["Invalid block range provided: ",inst_76211].join('');
var inst_76213 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76214 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_76215 = cljs.core.PersistentHashMap.fromArrays(inst_76213,inst_76214);
var inst_76216 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76212,inst_76215);
var inst_76217 = (function(){throw inst_76216})();
var state_76246__$1 = state_76246;
var statearr_76288_76352 = state_76246__$1;
(statearr_76288_76352[(2)] = inst_76217);

(statearr_76288_76352[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (19))){
var inst_76155 = (state_76246[(8)]);
var inst_76170 = (state_76246[(2)]);
var state_76246__$1 = (function (){var statearr_76289 = state_76246;
(statearr_76289[(20)] = inst_76170);

return statearr_76289;
})();
if(cljs.core.truth_(inst_76155)){
var statearr_76290_76353 = state_76246__$1;
(statearr_76290_76353[(1)] = (20));

} else {
var statearr_76291_76354 = state_76246__$1;
(statearr_76291_76354[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (11))){
var inst_76157 = (state_76246[(14)]);
var inst_76155 = (state_76246[(8)]);
var inst_76154 = (state_76246[(2)]);
var inst_76155__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76154,(0),null);
var inst_76156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76154,(1),null);
var inst_76157__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_76158 = (inst_76155__$1 > inst_76157__$1);
var state_76246__$1 = (function (){var statearr_76293 = state_76246;
(statearr_76293[(14)] = inst_76157__$1);

(statearr_76293[(8)] = inst_76155__$1);

(statearr_76293[(7)] = inst_76156);

return statearr_76293;
})();
if(cljs.core.truth_(inst_76158)){
var statearr_76294_76355 = state_76246__$1;
(statearr_76294_76355[(1)] = (17));

} else {
var statearr_76295_76356 = state_76246__$1;
(statearr_76295_76356[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (9))){
var inst_76132 = (state_76246[(19)]);
var inst_76135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76136 = cljs.core.first(inst_76132);
var inst_76137 = fluree.db.time_travel.block_to_int_format(db,inst_76136);
var state_76246__$1 = (function (){var statearr_76296 = state_76246;
(statearr_76296[(12)] = inst_76135);

return statearr_76296;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76246__$1,(12),inst_76137);
} else {
if((state_val_76247 === (5))){
var _ = (function (){var statearr_76297 = state_76246;
(statearr_76297[(4)] = cljs.core.rest((state_76246[(4)])));

return statearr_76297;
})();
var state_76246__$1 = state_76246;
var ex76292 = (state_76246__$1[(2)]);
var statearr_76298_76357 = state_76246__$1;
(statearr_76298_76357[(5)] = ex76292);


var statearr_76299_76358 = state_76246__$1;
(statearr_76299_76358[(1)] = (4));

(statearr_76299_76358[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (14))){
var state_76246__$1 = state_76246;
var statearr_76300_76359 = state_76246__$1;
(statearr_76300_76359[(2)] = null);

(statearr_76300_76359[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (26))){
var inst_76155 = (state_76246[(8)]);
var inst_76181 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76182 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_76183 = [inst_76155,inst_76182];
var inst_76184 = (new cljs.core.PersistentVector(null,2,(5),inst_76181,inst_76183,null));
var state_76246__$1 = state_76246;
var statearr_76301_76360 = state_76246__$1;
(statearr_76301_76360[(2)] = inst_76184);

(statearr_76301_76360[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (16))){
var inst_76145 = (state_76246[(2)]);
var inst_76146 = fluree.db.util.async.throw_err(inst_76145);
var state_76246__$1 = state_76246;
var statearr_76302_76361 = state_76246__$1;
(statearr_76302_76361[(2)] = inst_76146);

(statearr_76302_76361[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (38))){
var inst_76202 = (state_76246[(9)]);
var inst_76201 = (state_76246[(10)]);
var inst_76223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76224 = [inst_76202,inst_76201];
var inst_76225 = (new cljs.core.PersistentVector(null,2,(5),inst_76223,inst_76224,null));
var state_76246__$1 = state_76246;
var statearr_76303_76362 = state_76246__$1;
(statearr_76303_76362[(2)] = inst_76225);

(statearr_76303_76362[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (30))){
var state_76246__$1 = state_76246;
var statearr_76304_76363 = state_76246__$1;
(statearr_76304_76363[(2)] = null);

(statearr_76304_76363[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (10))){
var inst_76132 = (state_76246[(19)]);
var state_76246__$1 = state_76246;
var statearr_76305_76364 = state_76246__$1;
(statearr_76305_76364[(2)] = inst_76132);

(statearr_76305_76364[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (18))){
var state_76246__$1 = state_76246;
var statearr_76306_76365 = state_76246__$1;
(statearr_76306_76365[(2)] = null);

(statearr_76306_76365[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (42))){
var inst_76233 = (state_76246[(15)]);
var state_76246__$1 = state_76246;
var statearr_76307_76366 = state_76246__$1;
(statearr_76307_76366[(2)] = inst_76233);

(statearr_76307_76366[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (37))){
var inst_76202 = (state_76246[(9)]);
var inst_76201 = (state_76246[(10)]);
var inst_76220 = (state_76246[(2)]);
var inst_76221 = (inst_76202 < inst_76201);
var state_76246__$1 = (function (){var statearr_76308 = state_76246;
(statearr_76308[(21)] = inst_76220);

return statearr_76308;
})();
if(cljs.core.truth_(inst_76221)){
var statearr_76309_76367 = state_76246__$1;
(statearr_76309_76367[(1)] = (38));

} else {
var statearr_76310_76368 = state_76246__$1;
(statearr_76310_76368[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76247 === (8))){
var inst_76132 = (state_76246[(19)]);
var inst_76132__$1 = (state_76246[(2)]);
var inst_76133 = cljs.core.some(cljs.core.string_QMARK_,inst_76132__$1);
var state_76246__$1 = (function (){var statearr_76311 = state_76246;
(statearr_76311[(19)] = inst_76132__$1);

return statearr_76311;
})();
if(cljs.core.truth_(inst_76133)){
var statearr_76312_76369 = state_76246__$1;
(statearr_76312_76369[(1)] = (9));

} else {
var statearr_76313_76370 = state_76246__$1;
(statearr_76313_76370[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__11438__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__11438__auto____0 = (function (){
var statearr_76314 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76314[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__11438__auto__);

(statearr_76314[(1)] = (1));

return statearr_76314;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__11438__auto____1 = (function (state_76246){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_76246);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e76315){var ex__11441__auto__ = e76315;
var statearr_76316_76371 = state_76246;
(statearr_76316_76371[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_76246[(4)]))){
var statearr_76317_76372 = state_76246;
(statearr_76317_76372[(1)] = cljs.core.first((state_76246[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76373 = state_76246;
state_76246 = G__76373;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__11438__auto__ = function(state_76246){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__11438__auto____1.call(this,state_76246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__11438__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__11438__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_76318 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_76318[(6)] = c__11512__auto__);

return statearr_76318;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__76375 = arguments.length;
switch (G__76375) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_76466){
var state_val_76467 = (state_76466[(1)]);
if((state_val_76467 === (7))){
var inst_76398 = (state_76466[(7)]);
var inst_76401 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_76398);
var state_76466__$1 = state_76466;
var statearr_76468_76519 = state_76466__$1;
(statearr_76468_76519[(2)] = inst_76401);

(statearr_76468_76519[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (20))){
var inst_76437 = (state_76466[(8)]);
var inst_76440 = fluree.db.api_js.format_block_resp_pretty(db,inst_76437);
var state_76466__$1 = state_76466;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76466__$1,(23),inst_76440);
} else {
if((state_val_76467 === (27))){
var inst_76446 = (state_76466[(9)]);
var inst_76452 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_76446);
var state_76466__$1 = state_76466;
var statearr_76469_76520 = state_76466__$1;
(statearr_76469_76520[(2)] = inst_76452);

(statearr_76469_76520[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (1))){
var state_76466__$1 = state_76466;
var statearr_76470_76521 = state_76466__$1;
(statearr_76470_76521[(2)] = null);

(statearr_76470_76521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (24))){
var inst_76446 = (state_76466[(9)]);
var inst_76449 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_76450 = cljs.core.sequential_QMARK_(inst_76446);
var state_76466__$1 = (function (){var statearr_76471 = state_76466;
(statearr_76471[(10)] = inst_76449);

return statearr_76471;
})();
if(inst_76450){
var statearr_76472_76522 = state_76466__$1;
(statearr_76472_76522[(1)] = (27));

} else {
var statearr_76473_76523 = state_76466__$1;
(statearr_76473_76523[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (4))){
var inst_76376 = (state_76466[(2)]);
var inst_76377 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76376], 0));
var inst_76378 = cljs.core.ex_data(inst_76376);
var inst_76379 = cljs.core.ex_message(inst_76376);
var inst_76380 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76378,new cljs.core.Keyword(null,"message","message",-406056002),inst_76379);
var state_76466__$1 = (function (){var statearr_76474 = state_76466;
(statearr_76474[(11)] = inst_76377);

return statearr_76474;
})();
var statearr_76475_76524 = state_76466__$1;
(statearr_76475_76524[(2)] = inst_76380);

(statearr_76475_76524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (15))){
var inst_76398 = (state_76466[(7)]);
var inst_76411 = (state_76466[(2)]);
var inst_76412 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76411,inst_76398);
var inst_76413 = (function(){throw inst_76412})();
var state_76466__$1 = state_76466;
var statearr_76476_76525 = state_76466__$1;
(statearr_76476_76525[(2)] = inst_76413);

(statearr_76476_76525[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (21))){
var inst_76437 = (state_76466[(8)]);
var state_76466__$1 = state_76466;
var statearr_76477_76526 = state_76466__$1;
(statearr_76477_76526[(2)] = inst_76437);

(statearr_76477_76526[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (13))){
var inst_76406 = (state_76466[(12)]);
var state_76466__$1 = state_76466;
var statearr_76478_76527 = state_76466__$1;
(statearr_76478_76527[(2)] = inst_76406);

(statearr_76478_76527[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (22))){
var inst_76446 = (state_76466[(2)]);
var inst_76447 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_76466__$1 = (function (){var statearr_76479 = state_76466;
(statearr_76479[(9)] = inst_76446);

return statearr_76479;
})();
if(cljs.core.truth_(inst_76447)){
var statearr_76480_76528 = state_76466__$1;
(statearr_76480_76528[(1)] = (24));

} else {
var statearr_76481_76529 = state_76466__$1;
(statearr_76481_76529[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (29))){
var inst_76449 = (state_76466[(10)]);
var inst_76390 = (state_76466[(13)]);
var inst_76455 = (state_76466[(2)]);
var inst_76456 = fluree.db.util.core.response_time_formatted(inst_76390);
var inst_76457 = [(200),inst_76455,(100),inst_76456];
var inst_76458 = cljs.core.PersistentHashMap.fromArrays(inst_76449,inst_76457);
var state_76466__$1 = state_76466;
var statearr_76482_76530 = state_76466__$1;
(statearr_76482_76530[(2)] = inst_76458);

(statearr_76482_76530[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (6))){
var inst_76399 = (state_76466[(14)]);
var inst_76398 = (state_76466[(7)]);
var inst_76397 = (state_76466[(2)]);
var inst_76398__$1 = fluree.db.util.async.throw_err(inst_76397);
var inst_76399__$1 = cljs.core.map_QMARK_(inst_76398__$1);
var state_76466__$1 = (function (){var statearr_76483 = state_76466;
(statearr_76483[(14)] = inst_76399__$1);

(statearr_76483[(7)] = inst_76398__$1);

return statearr_76483;
})();
if(inst_76399__$1){
var statearr_76484_76531 = state_76466__$1;
(statearr_76484_76531[(1)] = (7));

} else {
var statearr_76485_76532 = state_76466__$1;
(statearr_76485_76532[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (28))){
var inst_76446 = (state_76466[(9)]);
var state_76466__$1 = state_76466;
var statearr_76486_76533 = state_76466__$1;
(statearr_76486_76533[(2)] = inst_76446);

(statearr_76486_76533[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (25))){
var inst_76446 = (state_76466[(9)]);
var state_76466__$1 = state_76466;
var statearr_76487_76534 = state_76466__$1;
(statearr_76487_76534[(2)] = inst_76446);

(statearr_76487_76534[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (17))){
var inst_76429 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_76430 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_76429].join('');
var inst_76431 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76432 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_76433 = cljs.core.PersistentHashMap.fromArrays(inst_76431,inst_76432);
var inst_76434 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76430,inst_76433);
var inst_76435 = (function(){throw inst_76434})();
var state_76466__$1 = state_76466;
var statearr_76488_76535 = state_76466__$1;
(statearr_76488_76535[(2)] = inst_76435);

(statearr_76488_76535[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (3))){
var inst_76464 = (state_76466[(2)]);
var state_76466__$1 = state_76466;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76466__$1,inst_76464);
} else {
if((state_val_76467 === (12))){
var inst_76398 = (state_76466[(7)]);
var inst_76416 = (state_76466[(2)]);
var inst_76417 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76398,(0),null);
var inst_76418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76398,(1),null);
var inst_76419 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_76420 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_76421 = cljs.core.keys(inst_76420);
var inst_76422 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_76419,inst_76421);
var state_76466__$1 = (function (){var statearr_76489 = state_76466;
(statearr_76489[(15)] = inst_76418);

(statearr_76489[(16)] = inst_76416);

(statearr_76489[(17)] = inst_76417);

return statearr_76489;
})();
if(inst_76422){
var statearr_76490_76536 = state_76466__$1;
(statearr_76490_76536[(1)] = (16));

} else {
var statearr_76491_76537 = state_76466__$1;
(statearr_76491_76537[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (2))){
var _ = (function (){var statearr_76492 = state_76466;
(statearr_76492[(4)] = cljs.core.cons((5),(state_76466[(4)])));

return statearr_76492;
})();
var inst_76390 = fluree.db.util.core.current_time_millis();
var inst_76391 = db;
var inst_76392 = cljs.core.__destructure_map(inst_76391);
var inst_76393 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76392,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_76394 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76392,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_76395 = fluree.db.api_js.resolve_block_range(db,query_map);
var state_76466__$1 = (function (){var statearr_76493 = state_76466;
(statearr_76493[(18)] = inst_76393);

(statearr_76493[(13)] = inst_76390);

(statearr_76493[(19)] = inst_76394);

return statearr_76493;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76466__$1,(6),inst_76395);
} else {
if((state_val_76467 === (23))){
var inst_76442 = (state_76466[(2)]);
var inst_76443 = fluree.db.util.async.throw_err(inst_76442);
var state_76466__$1 = state_76466;
var statearr_76494_76538 = state_76466__$1;
(statearr_76494_76538[(2)] = inst_76443);

(statearr_76494_76538[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (19))){
var inst_76426 = (state_76466[(2)]);
var inst_76427 = fluree.db.util.async.throw_err(inst_76426);
var state_76466__$1 = state_76466;
var statearr_76495_76539 = state_76466__$1;
(statearr_76495_76539[(2)] = inst_76427);

(statearr_76495_76539[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (11))){
var state_76466__$1 = state_76466;
var statearr_76497_76540 = state_76466__$1;
(statearr_76497_76540[(2)] = null);

(statearr_76497_76540[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (9))){
var inst_76404 = (state_76466[(2)]);
var state_76466__$1 = state_76466;
if(cljs.core.truth_(inst_76404)){
var statearr_76498_76541 = state_76466__$1;
(statearr_76498_76541[(1)] = (10));

} else {
var statearr_76499_76542 = state_76466__$1;
(statearr_76499_76542[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (5))){
var _ = (function (){var statearr_76500 = state_76466;
(statearr_76500[(4)] = cljs.core.rest((state_76466[(4)])));

return statearr_76500;
})();
var state_76466__$1 = state_76466;
var ex76496 = (state_76466__$1[(2)]);
var statearr_76501_76543 = state_76466__$1;
(statearr_76501_76543[(5)] = ex76496);


var statearr_76502_76544 = state_76466__$1;
(statearr_76502_76544[(1)] = (4));

(statearr_76502_76544[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (14))){
var inst_76393 = (state_76466[(18)]);
var inst_76394 = (state_76466[(19)]);
var inst_76409 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76393),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76394)].join('');
var state_76466__$1 = state_76466;
var statearr_76503_76545 = state_76466__$1;
(statearr_76503_76545[(2)] = inst_76409);

(statearr_76503_76545[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (26))){
var inst_76461 = (state_76466[(2)]);
var _ = (function (){var statearr_76504 = state_76466;
(statearr_76504[(4)] = cljs.core.rest((state_76466[(4)])));

return statearr_76504;
})();
var state_76466__$1 = state_76466;
var statearr_76505_76546 = state_76466__$1;
(statearr_76505_76546[(2)] = inst_76461);

(statearr_76505_76546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (16))){
var inst_76418 = (state_76466[(15)]);
var inst_76417 = (state_76466[(17)]);
var inst_76424 = fluree.db.query.block.block_range(db,inst_76417,inst_76418,opts);
var state_76466__$1 = state_76466;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76466__$1,(19),inst_76424);
} else {
if((state_val_76467 === (10))){
var inst_76406 = (state_76466[(12)]);
var inst_76398 = (state_76466[(7)]);
var inst_76406__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_76398);
var state_76466__$1 = (function (){var statearr_76506 = state_76466;
(statearr_76506[(12)] = inst_76406__$1);

return statearr_76506;
})();
if(cljs.core.truth_(inst_76406__$1)){
var statearr_76507_76547 = state_76466__$1;
(statearr_76507_76547[(1)] = (13));

} else {
var statearr_76508_76548 = state_76466__$1;
(statearr_76508_76548[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (18))){
var inst_76437 = (state_76466[(2)]);
var inst_76438 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_76466__$1 = (function (){var statearr_76509 = state_76466;
(statearr_76509[(8)] = inst_76437);

return statearr_76509;
})();
if(cljs.core.truth_(inst_76438)){
var statearr_76510_76549 = state_76466__$1;
(statearr_76510_76549[(1)] = (20));

} else {
var statearr_76511_76550 = state_76466__$1;
(statearr_76511_76550[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76467 === (8))){
var inst_76399 = (state_76466[(14)]);
var state_76466__$1 = state_76466;
var statearr_76512_76551 = state_76466__$1;
(statearr_76512_76551[(2)] = inst_76399);

(statearr_76512_76551[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11438__auto__ = null;
var fluree$db$api_js$state_machine__11438__auto____0 = (function (){
var statearr_76513 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76513[(0)] = fluree$db$api_js$state_machine__11438__auto__);

(statearr_76513[(1)] = (1));

return statearr_76513;
});
var fluree$db$api_js$state_machine__11438__auto____1 = (function (state_76466){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_76466);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e76514){var ex__11441__auto__ = e76514;
var statearr_76515_76552 = state_76466;
(statearr_76515_76552[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_76466[(4)]))){
var statearr_76516_76553 = state_76466;
(statearr_76516_76553[(1)] = cljs.core.first((state_76466[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76554 = state_76466;
state_76466 = G__76554;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11438__auto__ = function(state_76466){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11438__auto____1.call(this,state_76466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11438__auto____0;
fluree$db$api_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11438__auto____1;
return fluree$db$api_js$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_76517 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_76517[(6)] = c__11512__auto__);

return statearr_76517;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__76556 = arguments.length;
switch (G__76556) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_76751){
var state_val_76752 = (state_76751[(1)]);
if((state_val_76752 === (62))){
var inst_76749 = (state_76751[(2)]);
var state_76751__$1 = state_76751;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76751__$1,inst_76749);
} else {
if((state_val_76752 === (7))){
var inst_76577 = (state_76751[(7)]);
var inst_76587 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_76577);
var state_76751__$1 = state_76751;
var statearr_76753_76844 = state_76751__$1;
(statearr_76753_76844[(2)] = inst_76587);

(statearr_76753_76844[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (59))){
var inst_76737 = (state_76751[(2)]);
var inst_76738 = fluree.db.util.async.throw_err(inst_76737);
var state_76751__$1 = state_76751;
var statearr_76754_76845 = state_76751__$1;
(statearr_76754_76845[(2)] = inst_76738);

(statearr_76754_76845[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (20))){
var inst_76645 = (state_76751[(8)]);
var inst_76653 = (state_76751[(9)]);
var inst_76645__$1 = (state_76751[(2)]);
var inst_76646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76647 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76645__$1,(0));
var inst_76648 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76645__$1,(1));
var inst_76649 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76645__$1,(2));
var inst_76650 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76645__$1,(3));
var inst_76651 = [inst_76647,inst_76648,inst_76649,inst_76650];
var inst_76652 = (new cljs.core.PersistentVector(null,4,(5),inst_76646,inst_76651,null));
var inst_76653__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76652,(0),null);
var inst_76654 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76652,(1),null);
var inst_76655 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76652,(2),null);
var inst_76656 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76652,(3),null);
var inst_76657 = (inst_76653__$1 == null);
var inst_76658 = cljs.core.not(inst_76657);
var state_76751__$1 = (function (){var statearr_76755 = state_76751;
(statearr_76755[(10)] = inst_76656);

(statearr_76755[(11)] = inst_76655);

(statearr_76755[(12)] = inst_76654);

(statearr_76755[(8)] = inst_76645__$1);

(statearr_76755[(9)] = inst_76653__$1);

return statearr_76755;
})();
if(inst_76658){
var statearr_76756_76846 = state_76751__$1;
(statearr_76756_76846[(1)] = (30));

} else {
var statearr_76757_76847 = state_76751__$1;
(statearr_76757_76847[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (58))){
var inst_76585 = (state_76751[(13)]);
var inst_76741 = (state_76751[(2)]);
var state_76751__$1 = (function (){var statearr_76758 = state_76751;
(statearr_76758[(14)] = inst_76741);

return statearr_76758;
})();
if(cljs.core.truth_(inst_76585)){
var statearr_76759_76848 = state_76751__$1;
(statearr_76759_76848[(1)] = (60));

} else {
var statearr_76760_76849 = state_76751__$1;
(statearr_76760_76849[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (60))){
var inst_76741 = (state_76751[(14)]);
var inst_76729 = (state_76751[(15)]);
var inst_76743 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_76744 = cljs.core.count(inst_76729);
var inst_76745 = [inst_76741,inst_76744,(200)];
var inst_76746 = cljs.core.PersistentHashMap.fromArrays(inst_76743,inst_76745);
var state_76751__$1 = state_76751;
var statearr_76761_76850 = state_76751__$1;
(statearr_76761_76850[(2)] = inst_76746);

(statearr_76761_76850[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (27))){
var inst_76564 = (state_76751[(16)]);
var inst_76633 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76564)].join('');
var inst_76634 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76635 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_76636 = cljs.core.PersistentHashMap.fromArrays(inst_76634,inst_76635);
var inst_76637 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76633,inst_76636);
var inst_76638 = (function(){throw inst_76637})();
var state_76751__$1 = state_76751;
var statearr_76762_76851 = state_76751__$1;
(statearr_76762_76851[(2)] = inst_76638);

(statearr_76762_76851[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (1))){
var inst_76561 = query_map;
var inst_76562 = cljs.core.__destructure_map(inst_76561);
var inst_76563 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76562,new cljs.core.Keyword(null,"block","block",664686210));
var inst_76564 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76562,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_76565 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76562,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_76751__$1 = (function (){var statearr_76763 = state_76751;
(statearr_76763[(16)] = inst_76564);

(statearr_76763[(17)] = inst_76565);

(statearr_76763[(18)] = inst_76563);

return statearr_76763;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76751__$1,(2),sources);
} else {
if((state_val_76752 === (24))){
var inst_76564 = (state_76751[(16)]);
var inst_76622 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76564)].join('');
var inst_76623 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76624 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_76625 = cljs.core.PersistentHashMap.fromArrays(inst_76623,inst_76624);
var inst_76626 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76622,inst_76625);
var inst_76627 = (function(){throw inst_76626})();
var state_76751__$1 = state_76751;
var statearr_76764_76852 = state_76751__$1;
(statearr_76764_76852[(2)] = inst_76627);

(statearr_76764_76852[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (55))){
var inst_76565 = (state_76751[(17)]);
var inst_76732 = (state_76751[(2)]);
var inst_76733 = fluree.db.util.async.throw_err(inst_76732);
var state_76751__$1 = (function (){var statearr_76765 = state_76751;
(statearr_76765[(19)] = inst_76733);

return statearr_76765;
})();
if(cljs.core.truth_(inst_76565)){
var statearr_76766_76853 = state_76751__$1;
(statearr_76766_76853[(1)] = (56));

} else {
var statearr_76767_76854 = state_76751__$1;
(statearr_76767_76854[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (39))){
var inst_76656 = (state_76751[(10)]);
var inst_76655 = (state_76751[(11)]);
var inst_76654 = (state_76751[(12)]);
var inst_76653 = (state_76751[(9)]);
var inst_76677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76678 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76679 = [inst_76654,inst_76653,inst_76655,inst_76656];
var inst_76680 = (new cljs.core.PersistentVector(null,4,(5),inst_76678,inst_76679,null));
var inst_76681 = [inst_76680,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_76682 = (new cljs.core.PersistentVector(null,2,(5),inst_76677,inst_76681,null));
var state_76751__$1 = state_76751;
var statearr_76768_76855 = state_76751__$1;
(statearr_76768_76855[(2)] = inst_76682);

(statearr_76768_76855[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (46))){
var inst_76687 = (state_76751[(20)]);
var state_76751__$1 = state_76751;
var statearr_76769_76856 = state_76751__$1;
(statearr_76769_76856[(2)] = inst_76687);

(statearr_76769_76856[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (4))){
var state_76751__$1 = state_76751;
var statearr_76770_76857 = state_76751__$1;
(statearr_76770_76857[(2)] = null);

(statearr_76770_76857[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (54))){
var inst_76568 = (state_76751[(21)]);
var inst_76729 = (state_76751[(15)]);
var inst_76728 = (state_76751[(2)]);
var inst_76729__$1 = fluree.db.util.async.throw_err(inst_76728);
var inst_76730 = fluree.db.api_js.format_history_resp(inst_76568,inst_76729__$1);
var state_76751__$1 = (function (){var statearr_76771 = state_76751;
(statearr_76771[(15)] = inst_76729__$1);

return statearr_76771;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76751__$1,(55),inst_76730);
} else {
if((state_val_76752 === (15))){
var inst_76568 = (state_76751[(21)]);
var inst_76609 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_76568);
var state_76751__$1 = state_76751;
var statearr_76772_76858 = state_76751__$1;
(statearr_76772_76858[(2)] = inst_76609);

(statearr_76772_76858[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (48))){
var inst_76656 = (state_76751[(10)]);
var inst_76655 = (state_76751[(11)]);
var inst_76654 = (state_76751[(12)]);
var inst_76653 = (state_76751[(9)]);
var inst_76698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76700 = [inst_76654,inst_76655,inst_76653,inst_76656];
var inst_76701 = (new cljs.core.PersistentVector(null,4,(5),inst_76699,inst_76700,null));
var inst_76702 = [inst_76701,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_76703 = (new cljs.core.PersistentVector(null,2,(5),inst_76698,inst_76702,null));
var state_76751__$1 = state_76751;
var statearr_76773_76859 = state_76751__$1;
(statearr_76773_76859[(2)] = inst_76703);

(statearr_76773_76859[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (50))){
var inst_76716 = (state_76751[(2)]);
var state_76751__$1 = state_76751;
var statearr_76774_76860 = state_76751__$1;
(statearr_76774_76860[(2)] = inst_76716);

(statearr_76774_76860[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (21))){
var inst_76564 = (state_76751[(16)]);
var inst_76620 = cljs.core.empty_QMARK_(inst_76564);
var state_76751__$1 = state_76751;
if(inst_76620){
var statearr_76775_76861 = state_76751__$1;
(statearr_76775_76861[(1)] = (24));

} else {
var statearr_76776_76862 = state_76751__$1;
(statearr_76776_76862[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (31))){
var inst_76653 = (state_76751[(9)]);
var inst_76664 = (state_76751[(22)]);
var inst_76664__$1 = (inst_76653 == null);
var state_76751__$1 = (function (){var statearr_76777 = state_76751;
(statearr_76777[(22)] = inst_76664__$1);

return statearr_76777;
})();
if(cljs.core.truth_(inst_76664__$1)){
var statearr_76778_76863 = state_76751__$1;
(statearr_76778_76863[(1)] = (33));

} else {
var statearr_76779_76864 = state_76751__$1;
(statearr_76779_76864[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (32))){
var inst_76601 = (state_76751[(23)]);
var inst_76611 = (state_76751[(24)]);
var inst_76568 = (state_76751[(21)]);
var inst_76720 = (state_76751[(2)]);
var inst_76721 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76720,(0),null);
var inst_76722 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76720,(1),null);
var inst_76723 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_76724 = [inst_76601,inst_76611];
var inst_76725 = cljs.core.PersistentHashMap.fromArrays(inst_76723,inst_76724);
var inst_76726 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_76568,inst_76722,cljs.core._EQ_,inst_76721,inst_76725);
var state_76751__$1 = state_76751;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76751__$1,(54),inst_76726);
} else {
if((state_val_76752 === (40))){
var inst_76684 = (state_76751[(25)]);
var inst_76653 = (state_76751[(9)]);
var inst_76684__$1 = (inst_76653 == null);
var state_76751__$1 = (function (){var statearr_76780 = state_76751;
(statearr_76780[(25)] = inst_76684__$1);

return statearr_76780;
})();
if(cljs.core.truth_(inst_76684__$1)){
var statearr_76781_76865 = state_76751__$1;
(statearr_76781_76865[(1)] = (42));

} else {
var statearr_76782_76866 = state_76751__$1;
(statearr_76782_76866[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (56))){
var inst_76733 = (state_76751[(19)]);
var inst_76568 = (state_76751[(21)]);
var inst_76735 = fluree.db.api_js.format_block_resp_pretty(inst_76568,inst_76733);
var state_76751__$1 = state_76751;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76751__$1,(59),inst_76735);
} else {
if((state_val_76752 === (33))){
var inst_76654 = (state_76751[(12)]);
var inst_76667 = (state_76751[(26)]);
var inst_76666 = (inst_76654 == null);
var inst_76667__$1 = cljs.core.not(inst_76666);
var state_76751__$1 = (function (){var statearr_76783 = state_76751;
(statearr_76783[(26)] = inst_76667__$1);

return statearr_76783;
})();
if(inst_76667__$1){
var statearr_76784_76867 = state_76751__$1;
(statearr_76784_76867[(1)] = (36));

} else {
var statearr_76785_76868 = state_76751__$1;
(statearr_76785_76868[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (13))){
var inst_76595 = (state_76751[(2)]);
var inst_76596 = fluree.db.util.async.throw_err(inst_76595);
var inst_76597 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_76596);
var inst_76598 = (inst_76597 - (1));
var state_76751__$1 = state_76751;
var statearr_76786_76869 = state_76751__$1;
(statearr_76786_76869[(2)] = inst_76598);

(statearr_76786_76869[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (22))){
var state_76751__$1 = state_76751;
var statearr_76787_76870 = state_76751__$1;
(statearr_76787_76870[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (36))){
var inst_76655 = (state_76751[(11)]);
var inst_76669 = (inst_76655 == null);
var state_76751__$1 = state_76751;
var statearr_76789_76871 = state_76751__$1;
(statearr_76789_76871[(2)] = inst_76669);

(statearr_76789_76871[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (41))){
var inst_76718 = (state_76751[(2)]);
var state_76751__$1 = state_76751;
var statearr_76790_76872 = state_76751__$1;
(statearr_76790_76872[(2)] = inst_76718);

(statearr_76790_76872[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (43))){
var inst_76684 = (state_76751[(25)]);
var state_76751__$1 = state_76751;
var statearr_76791_76873 = state_76751__$1;
(statearr_76791_76873[(2)] = inst_76684);

(statearr_76791_76873[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (61))){
var inst_76741 = (state_76751[(14)]);
var state_76751__$1 = state_76751;
var statearr_76792_76874 = state_76751__$1;
(statearr_76792_76874[(2)] = inst_76741);

(statearr_76792_76874[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (29))){
var inst_76641 = (state_76751[(2)]);
var state_76751__$1 = state_76751;
var statearr_76793_76875 = state_76751__$1;
(statearr_76793_76875[(2)] = inst_76641);

(statearr_76793_76875[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (44))){
var inst_76696 = (state_76751[(2)]);
var state_76751__$1 = state_76751;
if(cljs.core.truth_(inst_76696)){
var statearr_76794_76876 = state_76751__$1;
(statearr_76794_76876[(1)] = (48));

} else {
var statearr_76795_76877 = state_76751__$1;
(statearr_76795_76877[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (6))){
var inst_76572 = (state_76751[(2)]);
var inst_76573 = fluree.db.util.async.throw_err(inst_76572);
var state_76751__$1 = state_76751;
var statearr_76796_76878 = state_76751__$1;
(statearr_76796_76878[(2)] = inst_76573);

(statearr_76796_76878[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (28))){
var state_76751__$1 = state_76751;
var statearr_76797_76879 = state_76751__$1;
(statearr_76797_76879[(2)] = null);

(statearr_76797_76879[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (51))){
var inst_76564 = (state_76751[(16)]);
var inst_76706 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76564)].join('');
var inst_76707 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76708 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_76709 = cljs.core.PersistentHashMap.fromArrays(inst_76707,inst_76708);
var inst_76710 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76706,inst_76709);
var inst_76711 = (function(){throw inst_76710})();
var state_76751__$1 = state_76751;
var statearr_76798_76880 = state_76751__$1;
(statearr_76798_76880[(2)] = inst_76711);

(statearr_76798_76880[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (25))){
var inst_76564 = (state_76751[(16)]);
var state_76751__$1 = state_76751;
var statearr_76799_76881 = state_76751__$1;
(statearr_76799_76881[(2)] = inst_76564);

(statearr_76799_76881[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (34))){
var inst_76664 = (state_76751[(22)]);
var state_76751__$1 = state_76751;
var statearr_76800_76882 = state_76751__$1;
(statearr_76800_76882[(2)] = inst_76664);

(statearr_76800_76882[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (17))){
var inst_76605 = (state_76751[(2)]);
var inst_76606 = fluree.db.util.async.throw_err(inst_76605);
var inst_76607 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_76606);
var state_76751__$1 = state_76751;
var statearr_76801_76883 = state_76751__$1;
(statearr_76801_76883[(2)] = inst_76607);

(statearr_76801_76883[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (3))){
var inst_76568 = (state_76751[(21)]);
var inst_76570 = fluree.db.api_js.resolve_block_range(inst_76568,query_map);
var state_76751__$1 = state_76751;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76751__$1,(6),inst_76570);
} else {
if((state_val_76752 === (12))){
var inst_76578 = (state_76751[(27)]);
var inst_76601 = (state_76751[(2)]);
var state_76751__$1 = (function (){var statearr_76802 = state_76751;
(statearr_76802[(23)] = inst_76601);

return statearr_76802;
})();
if(cljs.core.truth_(inst_76578)){
var statearr_76803_76884 = state_76751__$1;
(statearr_76803_76884[(1)] = (14));

} else {
var statearr_76804_76885 = state_76751__$1;
(statearr_76804_76885[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (2))){
var inst_76563 = (state_76751[(18)]);
var inst_76567 = (state_76751[(2)]);
var inst_76568 = fluree.db.util.async.throw_err(inst_76567);
var state_76751__$1 = (function (){var statearr_76805 = state_76751;
(statearr_76805[(21)] = inst_76568);

return statearr_76805;
})();
if(cljs.core.truth_(inst_76563)){
var statearr_76806_76886 = state_76751__$1;
(statearr_76806_76886[(1)] = (3));

} else {
var statearr_76807_76887 = state_76751__$1;
(statearr_76807_76887[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (23))){
var inst_76643 = (state_76751[(2)]);
var state_76751__$1 = state_76751;
var statearr_76808_76888 = state_76751__$1;
(statearr_76808_76888[(2)] = inst_76643);

(statearr_76808_76888[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (47))){
var inst_76693 = (state_76751[(2)]);
var state_76751__$1 = state_76751;
var statearr_76809_76889 = state_76751__$1;
(statearr_76809_76889[(2)] = inst_76693);

(statearr_76809_76889[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (35))){
var inst_76675 = (state_76751[(2)]);
var state_76751__$1 = state_76751;
if(cljs.core.truth_(inst_76675)){
var statearr_76810_76890 = state_76751__$1;
(statearr_76810_76890[(1)] = (39));

} else {
var statearr_76811_76891 = state_76751__$1;
(statearr_76811_76891[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (19))){
var inst_76564 = (state_76751[(16)]);
var inst_76618 = cljs.core.sequential_QMARK_(inst_76564);
var state_76751__$1 = state_76751;
if(inst_76618){
var statearr_76812_76892 = state_76751__$1;
(statearr_76812_76892[(1)] = (21));

} else {
var statearr_76813_76893 = state_76751__$1;
(statearr_76813_76893[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (57))){
var inst_76733 = (state_76751[(19)]);
var state_76751__$1 = state_76751;
var statearr_76814_76894 = state_76751__$1;
(statearr_76814_76894[(2)] = inst_76733);

(statearr_76814_76894[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (11))){
var state_76751__$1 = state_76751;
var statearr_76815_76895 = state_76751__$1;
(statearr_76815_76895[(2)] = (-1));

(statearr_76815_76895[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (9))){
var inst_76590 = (state_76751[(2)]);
var state_76751__$1 = state_76751;
if(cljs.core.truth_(inst_76590)){
var statearr_76816_76896 = state_76751__$1;
(statearr_76816_76896[(1)] = (10));

} else {
var statearr_76817_76897 = state_76751__$1;
(statearr_76817_76897[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (5))){
var inst_76577 = (state_76751[(7)]);
var inst_76576 = (state_76751[(2)]);
var inst_76577__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76576,(0),null);
var inst_76578 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76576,(1),null);
var inst_76585 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_76751__$1 = (function (){var statearr_76818 = state_76751;
(statearr_76818[(7)] = inst_76577__$1);

(statearr_76818[(27)] = inst_76578);

(statearr_76818[(13)] = inst_76585);

return statearr_76818;
})();
if(cljs.core.truth_(inst_76577__$1)){
var statearr_76819_76898 = state_76751__$1;
(statearr_76819_76898[(1)] = (7));

} else {
var statearr_76820_76899 = state_76751__$1;
(statearr_76820_76899[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (14))){
var inst_76578 = (state_76751[(27)]);
var inst_76568 = (state_76751[(21)]);
var inst_76603 = fluree.db.time_travel.as_of_block(inst_76568,inst_76578);
var state_76751__$1 = state_76751;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76751__$1,(17),inst_76603);
} else {
if((state_val_76752 === (45))){
var inst_76655 = (state_76751[(11)]);
var inst_76689 = (inst_76655 == null);
var inst_76690 = cljs.core.not(inst_76689);
var state_76751__$1 = state_76751;
var statearr_76821_76900 = state_76751__$1;
(statearr_76821_76900[(2)] = inst_76690);

(statearr_76821_76900[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (53))){
var inst_76714 = (state_76751[(2)]);
var state_76751__$1 = state_76751;
var statearr_76822_76901 = state_76751__$1;
(statearr_76822_76901[(2)] = inst_76714);

(statearr_76822_76901[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (26))){
var inst_76630 = (state_76751[(2)]);
var state_76751__$1 = state_76751;
var statearr_76823_76902 = state_76751__$1;
(statearr_76823_76902[(2)] = inst_76630);

(statearr_76823_76902[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (16))){
var inst_76564 = (state_76751[(16)]);
var inst_76611 = (state_76751[(2)]);
var inst_76612 = fluree.db.util.core.subj_ident_QMARK_(inst_76564);
var state_76751__$1 = (function (){var statearr_76824 = state_76751;
(statearr_76824[(24)] = inst_76611);

return statearr_76824;
})();
if(inst_76612){
var statearr_76825_76903 = state_76751__$1;
(statearr_76825_76903[(1)] = (18));

} else {
var statearr_76826_76904 = state_76751__$1;
(statearr_76826_76904[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (38))){
var inst_76672 = (state_76751[(2)]);
var state_76751__$1 = state_76751;
var statearr_76827_76905 = state_76751__$1;
(statearr_76827_76905[(2)] = inst_76672);

(statearr_76827_76905[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (30))){
var inst_76645 = (state_76751[(8)]);
var inst_76660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76661 = [inst_76645,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_76662 = (new cljs.core.PersistentVector(null,2,(5),inst_76660,inst_76661,null));
var state_76751__$1 = state_76751;
var statearr_76828_76906 = state_76751__$1;
(statearr_76828_76906[(2)] = inst_76662);

(statearr_76828_76906[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (10))){
var inst_76577 = (state_76751[(7)]);
var inst_76568 = (state_76751[(21)]);
var inst_76592 = (inst_76577 - (1));
var inst_76593 = fluree.db.time_travel.as_of_block(inst_76568,inst_76592);
var state_76751__$1 = state_76751;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76751__$1,(13),inst_76593);
} else {
if((state_val_76752 === (18))){
var inst_76564 = (state_76751[(16)]);
var inst_76614 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76615 = [inst_76564];
var inst_76616 = (new cljs.core.PersistentVector(null,1,(5),inst_76614,inst_76615,null));
var state_76751__$1 = state_76751;
var statearr_76829_76907 = state_76751__$1;
(statearr_76829_76907[(2)] = inst_76616);

(statearr_76829_76907[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (52))){
var state_76751__$1 = state_76751;
var statearr_76830_76908 = state_76751__$1;
(statearr_76830_76908[(2)] = null);

(statearr_76830_76908[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (42))){
var inst_76654 = (state_76751[(12)]);
var inst_76687 = (state_76751[(20)]);
var inst_76686 = (inst_76654 == null);
var inst_76687__$1 = cljs.core.not(inst_76686);
var state_76751__$1 = (function (){var statearr_76831 = state_76751;
(statearr_76831[(20)] = inst_76687__$1);

return statearr_76831;
})();
if(inst_76687__$1){
var statearr_76832_76909 = state_76751__$1;
(statearr_76832_76909[(1)] = (45));

} else {
var statearr_76833_76910 = state_76751__$1;
(statearr_76833_76910[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (37))){
var inst_76667 = (state_76751[(26)]);
var state_76751__$1 = state_76751;
var statearr_76834_76911 = state_76751__$1;
(statearr_76834_76911[(2)] = inst_76667);

(statearr_76834_76911[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (8))){
var inst_76577 = (state_76751[(7)]);
var state_76751__$1 = state_76751;
var statearr_76835_76912 = state_76751__$1;
(statearr_76835_76912[(2)] = inst_76577);

(statearr_76835_76912[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76752 === (49))){
var state_76751__$1 = state_76751;
var statearr_76836_76913 = state_76751__$1;
(statearr_76836_76913[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11438__auto__ = null;
var fluree$db$api_js$state_machine__11438__auto____0 = (function (){
var statearr_76838 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76838[(0)] = fluree$db$api_js$state_machine__11438__auto__);

(statearr_76838[(1)] = (1));

return statearr_76838;
});
var fluree$db$api_js$state_machine__11438__auto____1 = (function (state_76751){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_76751);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e76839){var ex__11441__auto__ = e76839;
var statearr_76840_76914 = state_76751;
(statearr_76840_76914[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_76751[(4)]))){
var statearr_76841_76915 = state_76751;
(statearr_76841_76915[(1)] = cljs.core.first((state_76751[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76916 = state_76751;
state_76751 = G__76916;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11438__auto__ = function(state_76751){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11438__auto____1.call(this,state_76751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11438__auto____0;
fluree$db$api_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11438__auto____1;
return fluree$db$api_js$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_76842 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_76842[(6)] = c__11512__auto__);

return statearr_76842;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__76924 = arguments.length;
switch (G__76924) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(fluree.db.time_travel.block_to_int_format(fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.map_QMARK_(block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.coll_QMARK_(block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__76917_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__76917_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals(multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys(multi_query_map_SINGLEQUOTE_);
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_77013){
var state_val_77014 = (state_77013[(1)]);
if((state_val_77014 === (7))){
var inst_76970 = (state_77013[(7)]);
var inst_76964 = (state_77013[(8)]);
var inst_76967 = (state_77013[(9)]);
var inst_76974 = (state_77013[(10)]);
var inst_76980 = (function (){var responses = inst_76964;
var responses_STAR_ = inst_76967;
var statuses = inst_76970;
var fuel = inst_76974;
return (function (p1__76920_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),p1__76920_SHARP_);
});
})();
var inst_76981 = cljs.core.some(inst_76980,inst_76970);
var state_77013__$1 = state_77013;
if(cljs.core.truth_(inst_76981)){
var statearr_77015_77063 = state_77013__$1;
(statearr_77015_77063[(1)] = (9));

} else {
var statearr_77016_77064 = state_77013__$1;
(statearr_77016_77064[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77014 === (20))){
var inst_77008 = (state_77013[(2)]);
var state_77013__$1 = state_77013;
var statearr_77017_77065 = state_77013__$1;
(statearr_77017_77065[(2)] = inst_77008);

(statearr_77017_77065[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77014 === (1))){
var inst_76959 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_76960 = (function (){var c__11512__auto____$1 = inst_76959;
return (function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_76957){
var state_val_76958 = (state_76957[(1)]);
if((state_val_76958 === (1))){
var inst_76925 = cljs.core.first(keys_SINGLEQUOTE_);
var inst_76926 = cljs.core.first(vals_SINGLEQUOTE_);
var inst_76927 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76926,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_76928 = cljs.core.rest(keys_SINGLEQUOTE_);
var inst_76929 = cljs.core.rest(vals_SINGLEQUOTE_);
var inst_76930 = cljs.core.PersistentHashMap.EMPTY;
var inst_76931 = inst_76925;
var inst_76932 = inst_76927;
var inst_76933 = inst_76928;
var inst_76934 = inst_76929;
var inst_76935 = inst_76930;
var state_76957__$1 = (function (){var statearr_77018 = state_76957;
(statearr_77018[(7)] = inst_76932);

(statearr_77018[(8)] = inst_76935);

(statearr_77018[(9)] = inst_76931);

(statearr_77018[(10)] = inst_76934);

(statearr_77018[(11)] = inst_76933);

return statearr_77018;
})();
var statearr_77019_77066 = state_76957__$1;
(statearr_77019_77066[(2)] = null);

(statearr_77019_77066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76958 === (2))){
var inst_76932 = (state_76957[(7)]);
var inst_76937 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_76932);
var inst_76938 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,inst_76937], 0));
var inst_76939 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76932,new cljs.core.Keyword(null,"opts","opts",155075701),inst_76938);
var inst_76940 = fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(db,inst_76939,db_fn);
var state_76957__$1 = state_76957;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76957__$1,(4),inst_76940);
} else {
if((state_val_76958 === (3))){
var inst_76955 = (state_76957[(2)]);
var state_76957__$1 = state_76957;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76957__$1,inst_76955);
} else {
if((state_val_76958 === (4))){
var inst_76935 = (state_76957[(8)]);
var inst_76931 = (state_76957[(9)]);
var inst_76933 = (state_76957[(11)]);
var inst_76942 = (state_76957[(2)]);
var inst_76943 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76935,inst_76931,inst_76942);
var inst_76944 = cljs.core.first(inst_76933);
var state_76957__$1 = (function (){var statearr_77020 = state_76957;
(statearr_77020[(12)] = inst_76943);

return statearr_77020;
})();
if(cljs.core.truth_(inst_76944)){
var statearr_77021_77067 = state_76957__$1;
(statearr_77021_77067[(1)] = (5));

} else {
var statearr_77022_77068 = state_76957__$1;
(statearr_77022_77068[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76958 === (5))){
var inst_76943 = (state_76957[(12)]);
var inst_76934 = (state_76957[(10)]);
var inst_76933 = (state_76957[(11)]);
var inst_76946 = cljs.core.first(inst_76933);
var inst_76947 = cljs.core.first(inst_76934);
var inst_76948 = cljs.core.rest(inst_76933);
var inst_76949 = cljs.core.rest(inst_76934);
var inst_76931 = inst_76946;
var inst_76932 = inst_76947;
var inst_76933__$1 = inst_76948;
var inst_76934__$1 = inst_76949;
var inst_76935 = inst_76943;
var state_76957__$1 = (function (){var statearr_77023 = state_76957;
(statearr_77023[(7)] = inst_76932);

(statearr_77023[(8)] = inst_76935);

(statearr_77023[(9)] = inst_76931);

(statearr_77023[(10)] = inst_76934__$1);

(statearr_77023[(11)] = inst_76933__$1);

return statearr_77023;
})();
var statearr_77024_77069 = state_76957__$1;
(statearr_77024_77069[(2)] = null);

(statearr_77024_77069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76958 === (6))){
var inst_76943 = (state_76957[(12)]);
var state_76957__$1 = state_76957;
var statearr_77025_77070 = state_76957__$1;
(statearr_77025_77070[(2)] = inst_76943);

(statearr_77025_77070[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76958 === (7))){
var inst_76953 = (state_76957[(2)]);
var state_76957__$1 = state_76957;
var statearr_77026_77071 = state_76957__$1;
(statearr_77026_77071[(2)] = inst_76953);

(statearr_77026_77071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11438__auto__ = null;
var fluree$db$api_js$state_machine__11438__auto____0 = (function (){
var statearr_77027 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77027[(0)] = fluree$db$api_js$state_machine__11438__auto__);

(statearr_77027[(1)] = (1));

return statearr_77027;
});
var fluree$db$api_js$state_machine__11438__auto____1 = (function (state_76957){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_76957);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e77028){var ex__11441__auto__ = e77028;
var statearr_77029_77072 = state_76957;
(statearr_77029_77072[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_76957[(4)]))){
var statearr_77030_77073 = state_76957;
(statearr_77030_77073[(1)] = cljs.core.first((state_76957[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77074 = state_76957;
state_76957 = G__77074;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11438__auto__ = function(state_76957){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11438__auto____1.call(this,state_76957);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11438__auto____0;
fluree$db$api_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11438__auto____1;
return fluree$db$api_js$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_77031 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_77031[(6)] = c__11512__auto____$1);

return statearr_77031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
});
})();
var inst_76961 = cljs.core.async.impl.dispatch.run(inst_76960);
var state_77013__$1 = (function (){var statearr_77032 = state_77013;
(statearr_77032[(11)] = inst_76961);

return statearr_77032;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77013__$1,(2),inst_76959);
} else {
if((state_val_77014 === (4))){
var inst_76964 = (state_77013[(8)]);
var state_77013__$1 = state_77013;
var statearr_77033_77075 = state_77013__$1;
(statearr_77033_77075[(2)] = inst_76964);

(statearr_77033_77075[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77014 === (15))){
var state_77013__$1 = state_77013;
var statearr_77034_77076 = state_77013__$1;
(statearr_77034_77076[(2)] = (400));

(statearr_77034_77076[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77014 === (13))){
var state_77013__$1 = state_77013;
var statearr_77035_77077 = state_77013__$1;
(statearr_77035_77077[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77014 === (6))){
var inst_76970 = (state_77013[(7)]);
var inst_76978 = cljs.core.first(inst_76970);
var state_77013__$1 = state_77013;
var statearr_77037_77078 = state_77013__$1;
(statearr_77037_77078[(2)] = inst_76978);

(statearr_77037_77078[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77014 === (17))){
var inst_76991 = (state_77013[(2)]);
var state_77013__$1 = state_77013;
var statearr_77038_77079 = state_77013__$1;
(statearr_77038_77079[(2)] = inst_76991);

(statearr_77038_77079[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77014 === (3))){
var inst_76970 = (state_77013[(7)]);
var inst_76964 = (state_77013[(8)]);
var inst_76967 = (state_77013[(9)]);
var inst_76974 = (state_77013[(10)]);
var inst_76969 = cljs.core.vals(inst_76964);
var inst_76970__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"status","status",-1997798413),inst_76969);
var inst_76971 = (function (){var responses = inst_76964;
var responses_STAR_ = inst_76967;
var statuses = inst_76970__$1;
return (function (p1__76918_SHARP_){
var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__76918_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
});
})();
var inst_76972 = cljs.core.vals(inst_76964);
var inst_76973 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_76971,inst_76972);
var inst_76974__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,inst_76973);
var inst_76975 = (function (){var responses = inst_76964;
var responses_STAR_ = inst_76967;
var statuses = inst_76970__$1;
var fuel = inst_76974__$1;
return (function (p1__76919_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(statuses),p1__76919_SHARP_);
});
})();
var inst_76976 = cljs.core.every_QMARK_(inst_76975,inst_76970__$1);
var state_77013__$1 = (function (){var statearr_77039 = state_77013;
(statearr_77039[(7)] = inst_76970__$1);

(statearr_77039[(10)] = inst_76974__$1);

return statearr_77039;
})();
if(inst_76976){
var statearr_77040_77080 = state_77013__$1;
(statearr_77040_77080[(1)] = (6));

} else {
var statearr_77041_77081 = state_77013__$1;
(statearr_77041_77081[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77014 === (12))){
var state_77013__$1 = state_77013;
var statearr_77042_77082 = state_77013__$1;
(statearr_77042_77082[(2)] = (500));

(statearr_77042_77082[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77014 === (2))){
var inst_76964 = (state_77013[(8)]);
var inst_76963 = (state_77013[(2)]);
var inst_76964__$1 = fluree.db.util.async.throw_err(inst_76963);
var inst_76965 = (function (){var responses = inst_76964__$1;
return (function (acc,index,response){
var resp = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,index,resp);
}
});
})();
var inst_76966 = cljs.core.PersistentHashMap.EMPTY;
var inst_76967 = cljs.core.reduce_kv(inst_76965,inst_76966,inst_76964__$1);
var state_77013__$1 = (function (){var statearr_77043 = state_77013;
(statearr_77043[(8)] = inst_76964__$1);

(statearr_77043[(9)] = inst_76967);

return statearr_77043;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_77044_77083 = state_77013__$1;
(statearr_77044_77083[(1)] = (3));

} else {
var statearr_77045_77084 = state_77013__$1;
(statearr_77045_77084[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77014 === (19))){
var inst_76967 = (state_77013[(9)]);
var inst_76997 = (state_77013[(12)]);
var inst_76974 = (state_77013[(10)]);
var inst_77006 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_76967,new cljs.core.Keyword(null,"status","status",-1997798413),inst_76997,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_76974], 0));
var state_77013__$1 = state_77013;
var statearr_77046_77085 = state_77013__$1;
(statearr_77046_77085[(2)] = inst_77006);

(statearr_77046_77085[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77014 === (11))){
var inst_76995 = (state_77013[(2)]);
var state_77013__$1 = state_77013;
var statearr_77047_77086 = state_77013__$1;
(statearr_77047_77086[(2)] = inst_76995);

(statearr_77047_77086[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77014 === (9))){
var state_77013__$1 = state_77013;
var statearr_77048_77087 = state_77013__$1;
(statearr_77048_77087[(2)] = (207));

(statearr_77048_77087[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77014 === (5))){
var inst_77011 = (state_77013[(2)]);
var state_77013__$1 = state_77013;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77013__$1,inst_77011);
} else {
if((state_val_77014 === (14))){
var inst_76993 = (state_77013[(2)]);
var state_77013__$1 = state_77013;
var statearr_77049_77088 = state_77013__$1;
(statearr_77049_77088[(2)] = inst_76993);

(statearr_77049_77088[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77014 === (16))){
var state_77013__$1 = state_77013;
var statearr_77050_77089 = state_77013__$1;
(statearr_77050_77089[(2)] = null);

(statearr_77050_77089[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77014 === (10))){
var inst_76970 = (state_77013[(7)]);
var inst_76964 = (state_77013[(8)]);
var inst_76967 = (state_77013[(9)]);
var inst_76974 = (state_77013[(10)]);
var inst_76984 = (function (){var responses = inst_76964;
var responses_STAR_ = inst_76967;
var statuses = inst_76970;
var fuel = inst_76974;
return (function (p1__76921_SHARP_){
return ((499) < p1__76921_SHARP_);
});
})();
var inst_76985 = cljs.core.some(inst_76984,inst_76970);
var state_77013__$1 = state_77013;
if(cljs.core.truth_(inst_76985)){
var statearr_77051_77090 = state_77013__$1;
(statearr_77051_77090[(1)] = (12));

} else {
var statearr_77052_77091 = state_77013__$1;
(statearr_77052_77091[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77014 === (18))){
var inst_77002 = (state_77013[(13)]);
var inst_76967 = (state_77013[(9)]);
var inst_76997 = (state_77013[(12)]);
var inst_76974 = (state_77013[(10)]);
var inst_77004 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_76967,new cljs.core.Keyword(null,"status","status",-1997798413),inst_76997,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_76974,new cljs.core.Keyword(null,"block","block",664686210),inst_77002], 0));
var state_77013__$1 = state_77013;
var statearr_77053_77092 = state_77013__$1;
(statearr_77053_77092[(2)] = inst_77004);

(statearr_77053_77092[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77014 === (8))){
var inst_76970 = (state_77013[(7)]);
var inst_76964 = (state_77013[(8)]);
var inst_77002 = (state_77013[(13)]);
var inst_76967 = (state_77013[(9)]);
var inst_76997 = (state_77013[(12)]);
var inst_76974 = (state_77013[(10)]);
var inst_76997__$1 = (state_77013[(2)]);
var inst_76998 = (function (){var responses = inst_76964;
var responses_STAR_ = inst_76967;
var statuses = inst_76970;
var fuel = inst_76974;
var status = inst_76997__$1;
return (function (p1__76922_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__76922_SHARP_));
});
})();
var inst_76999 = cljs.core.vals(inst_76964);
var inst_77000 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_76998,inst_76999);
var inst_77001 = cljs.core.first(inst_77000);
var inst_77002__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_77001);
var state_77013__$1 = (function (){var statearr_77054 = state_77013;
(statearr_77054[(13)] = inst_77002__$1);

(statearr_77054[(12)] = inst_76997__$1);

return statearr_77054;
})();
if(cljs.core.truth_(inst_77002__$1)){
var statearr_77055_77093 = state_77013__$1;
(statearr_77055_77093[(1)] = (18));

} else {
var statearr_77056_77094 = state_77013__$1;
(statearr_77056_77094[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11438__auto__ = null;
var fluree$db$api_js$state_machine__11438__auto____0 = (function (){
var statearr_77057 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77057[(0)] = fluree$db$api_js$state_machine__11438__auto__);

(statearr_77057[(1)] = (1));

return statearr_77057;
});
var fluree$db$api_js$state_machine__11438__auto____1 = (function (state_77013){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_77013);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e77058){var ex__11441__auto__ = e77058;
var statearr_77059_77095 = state_77013;
(statearr_77059_77095[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_77013[(4)]))){
var statearr_77060_77096 = state_77013;
(statearr_77060_77096[(1)] = cljs.core.first((state_77013[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77097 = state_77013;
state_77013 = G__77097;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11438__auto__ = function(state_77013){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11438__auto____1.call(this,state_77013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11438__auto____0;
fluree$db$api_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11438__auto____1;
return fluree$db$api_js$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_77061 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_77061[(6)] = c__11512__auto__);

return statearr_77061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__77099 = arguments.length;
switch (G__77099) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__77100 = opts;
var map__77100__$1 = cljs.core.__destructure_map(map__77100);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77100__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77100__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77100__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77100__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__77101 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__77101,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__77101,(1),null);
var action__$1 = (function (){var or__5045__auto__ = action;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e77104){var e = e77104;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__77107 = arguments.length;
switch (G__77107) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_77138){
var state_val_77139 = (state_77138[(1)]);
if((state_val_77139 === (7))){
var state_77138__$1 = state_77138;
var statearr_77140_77161 = state_77138__$1;
(statearr_77140_77161[(2)] = opts);

(statearr_77140_77161[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77139 === (1))){
var state_77138__$1 = state_77138;
var statearr_77141_77162 = state_77138__$1;
(statearr_77141_77162[(2)] = null);

(statearr_77141_77162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77139 === (4))){
var inst_77108 = (state_77138[(2)]);
var inst_77109 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_77108], 0));
var inst_77110 = cljs.core.ex_data(inst_77108);
var inst_77111 = cljs.core.ex_message(inst_77108);
var inst_77112 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_77110,new cljs.core.Keyword(null,"message","message",-406056002),inst_77111);
var state_77138__$1 = (function (){var statearr_77142 = state_77138;
(statearr_77142[(7)] = inst_77109);

return statearr_77142;
})();
var statearr_77143_77163 = state_77138__$1;
(statearr_77143_77163[(2)] = inst_77112);

(statearr_77143_77163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77139 === (6))){
var inst_77122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77123 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_77124 = (new cljs.core.PersistentVector(null,1,(5),inst_77122,inst_77123,null));
var inst_77125 = cljs.core.assoc_in(opts,inst_77124,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_77138__$1 = state_77138;
var statearr_77144_77164 = state_77138__$1;
(statearr_77144_77164[(2)] = inst_77125);

(statearr_77144_77164[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77139 === (3))){
var inst_77136 = (state_77138[(2)]);
var state_77138__$1 = state_77138;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77138__$1,inst_77136);
} else {
if((state_val_77139 === (2))){
var _ = (function (){var statearr_77146 = state_77138;
(statearr_77146[(4)] = cljs.core.cons((5),(state_77138[(4)])));

return statearr_77146;
})();
var inst_77118 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_77119 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_77120 = (inst_77119 == null);
var state_77138__$1 = (function (){var statearr_77147 = state_77138;
(statearr_77147[(8)] = inst_77118);

return statearr_77147;
})();
if(cljs.core.truth_(inst_77120)){
var statearr_77148_77165 = state_77138__$1;
(statearr_77148_77165[(1)] = (6));

} else {
var statearr_77149_77166 = state_77138__$1;
(statearr_77149_77166[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77139 === (9))){
var inst_77132 = (state_77138[(2)]);
var inst_77133 = fluree.db.util.async.throw_err(inst_77132);
var _ = (function (){var statearr_77150 = state_77138;
(statearr_77150[(4)] = cljs.core.rest((state_77138[(4)])));

return statearr_77150;
})();
var state_77138__$1 = state_77138;
var statearr_77151_77167 = state_77138__$1;
(statearr_77151_77167[(2)] = inst_77133);

(statearr_77151_77167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77139 === (5))){
var _ = (function (){var statearr_77152 = state_77138;
(statearr_77152[(4)] = cljs.core.rest((state_77138[(4)])));

return statearr_77152;
})();
var state_77138__$1 = state_77138;
var ex77145 = (state_77138__$1[(2)]);
var statearr_77153_77168 = state_77138__$1;
(statearr_77153_77168[(5)] = ex77145);


var statearr_77154_77169 = state_77138__$1;
(statearr_77154_77169[(1)] = (4));

(statearr_77154_77169[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77139 === (8))){
var inst_77118 = (state_77138[(8)]);
var inst_77128 = (state_77138[(2)]);
var inst_77129 = fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,query_map,inst_77118,inst_77128);
var inst_77130 = fluree.db.operations.command_async(conn,inst_77129);
var state_77138__$1 = state_77138;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77138__$1,(9),inst_77130);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11438__auto__ = null;
var fluree$db$api_js$state_machine__11438__auto____0 = (function (){
var statearr_77155 = [null,null,null,null,null,null,null,null,null];
(statearr_77155[(0)] = fluree$db$api_js$state_machine__11438__auto__);

(statearr_77155[(1)] = (1));

return statearr_77155;
});
var fluree$db$api_js$state_machine__11438__auto____1 = (function (state_77138){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_77138);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e77156){var ex__11441__auto__ = e77156;
var statearr_77157_77170 = state_77138;
(statearr_77157_77170[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_77138[(4)]))){
var statearr_77158_77171 = state_77138;
(statearr_77158_77171[(1)] = cljs.core.first((state_77138[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77172 = state_77138;
state_77138 = G__77172;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11438__auto__ = function(state_77138){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11438__auto____1.call(this,state_77138);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11438__auto____0;
fluree$db$api_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11438__auto____1;
return fluree$db$api_js$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_77159 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_77159[(6)] = c__11512__auto__);

return statearr_77159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

