// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__73622_73791 = cljs.core.seq(servers);
var chunk__73623_73792 = null;
var count__73624_73793 = (0);
var i__73625_73794 = (0);
while(true){
if((i__73625_73794 < count__73624_73793)){
var server_73795 = chunk__73623_73792.cljs$core$IIndexed$_nth$arity$2(null,i__73625_73794);
var healthcheck_uri_73796 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_73795),"/fdb/health"].join('');
var resp_chan_73797 = fluree.db.util.xhttp.post_json(healthcheck_uri_73796,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__11512__auto___73798 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__73622_73791,chunk__73623_73792,count__73624_73793,i__73625_73794,c__11512__auto___73798,healthcheck_uri_73796,resp_chan_73797,server_73795){
return (function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = ((function (seq__73622_73791,chunk__73623_73792,count__73624_73793,i__73625_73794,c__11512__auto___73798,healthcheck_uri_73796,resp_chan_73797,server_73795){
return (function (state_73686){
var state_val_73687 = (state_73686[(1)]);
if((state_val_73687 === (1))){
var state_73686__$1 = state_73686;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73686__$1,(2),resp_chan_73797);
} else {
if((state_val_73687 === (2))){
var inst_73675 = (state_73686[(7)]);
var inst_73675__$1 = (state_73686[(2)]);
var inst_73676 = fluree.db.util.core.exception_QMARK_(inst_73675__$1);
var state_73686__$1 = (function (){var statearr_73688 = state_73686;
(statearr_73688[(7)] = inst_73675__$1);

return statearr_73688;
})();
if(inst_73676){
var statearr_73689_73799 = state_73686__$1;
(statearr_73689_73799[(1)] = (3));

} else {
var statearr_73690_73800 = state_73686__$1;
(statearr_73690_73800[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73687 === (3))){
var inst_73675 = (state_73686[(7)]);
var inst_73678 = cljs.core.ex_message(inst_73675);
var inst_73679 = cljs.core.ex_data(inst_73675);
var inst_73680 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_73678,inst_73679], 0));
var state_73686__$1 = state_73686;
var statearr_73691_73801 = state_73686__$1;
(statearr_73691_73801[(2)] = inst_73680);

(statearr_73691_73801[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73687 === (4))){
var inst_73682 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_73795);
var state_73686__$1 = state_73686;
var statearr_73692_73802 = state_73686__$1;
(statearr_73692_73802[(2)] = inst_73682);

(statearr_73692_73802[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73687 === (5))){
var inst_73684 = (state_73686[(2)]);
var state_73686__$1 = state_73686;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73686__$1,inst_73684);
} else {
return null;
}
}
}
}
}
});})(seq__73622_73791,chunk__73623_73792,count__73624_73793,i__73625_73794,c__11512__auto___73798,healthcheck_uri_73796,resp_chan_73797,server_73795))
;
return ((function (seq__73622_73791,chunk__73623_73792,count__73624_73793,i__73625_73794,switch__11437__auto__,c__11512__auto___73798,healthcheck_uri_73796,resp_chan_73797,server_73795){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____0 = (function (){
var statearr_73693 = [null,null,null,null,null,null,null,null];
(statearr_73693[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__);

(statearr_73693[(1)] = (1));

return statearr_73693;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____1 = (function (state_73686){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_73686);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e73694){var ex__11441__auto__ = e73694;
var statearr_73695_73803 = state_73686;
(statearr_73695_73803[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_73686[(4)]))){
var statearr_73696_73804 = state_73686;
(statearr_73696_73804[(1)] = cljs.core.first((state_73686[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73805 = state_73686;
state_73686 = G__73805;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__ = function(state_73686){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____1.call(this,state_73686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__;
})()
;})(seq__73622_73791,chunk__73623_73792,count__73624_73793,i__73625_73794,switch__11437__auto__,c__11512__auto___73798,healthcheck_uri_73796,resp_chan_73797,server_73795))
})();
var state__11514__auto__ = (function (){var statearr_73697 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_73697[(6)] = c__11512__auto___73798);

return statearr_73697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
});})(seq__73622_73791,chunk__73623_73792,count__73624_73793,i__73625_73794,c__11512__auto___73798,healthcheck_uri_73796,resp_chan_73797,server_73795))
);



var G__73806 = seq__73622_73791;
var G__73807 = chunk__73623_73792;
var G__73808 = count__73624_73793;
var G__73809 = (i__73625_73794 + (1));
seq__73622_73791 = G__73806;
chunk__73623_73792 = G__73807;
count__73624_73793 = G__73808;
i__73625_73794 = G__73809;
continue;
} else {
var temp__5804__auto___73810 = cljs.core.seq(seq__73622_73791);
if(temp__5804__auto___73810){
var seq__73622_73811__$1 = temp__5804__auto___73810;
if(cljs.core.chunked_seq_QMARK_(seq__73622_73811__$1)){
var c__5567__auto___73812 = cljs.core.chunk_first(seq__73622_73811__$1);
var G__73813 = cljs.core.chunk_rest(seq__73622_73811__$1);
var G__73814 = c__5567__auto___73812;
var G__73815 = cljs.core.count(c__5567__auto___73812);
var G__73816 = (0);
seq__73622_73791 = G__73813;
chunk__73623_73792 = G__73814;
count__73624_73793 = G__73815;
i__73625_73794 = G__73816;
continue;
} else {
var server_73817 = cljs.core.first(seq__73622_73811__$1);
var healthcheck_uri_73818 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_73817),"/fdb/health"].join('');
var resp_chan_73819 = fluree.db.util.xhttp.post_json(healthcheck_uri_73818,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__11512__auto___73820 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__73622_73791,chunk__73623_73792,count__73624_73793,i__73625_73794,c__11512__auto___73820,healthcheck_uri_73818,resp_chan_73819,server_73817,seq__73622_73811__$1,temp__5804__auto___73810){
return (function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = ((function (seq__73622_73791,chunk__73623_73792,count__73624_73793,i__73625_73794,c__11512__auto___73820,healthcheck_uri_73818,resp_chan_73819,server_73817,seq__73622_73811__$1,temp__5804__auto___73810){
return (function (state_73710){
var state_val_73711 = (state_73710[(1)]);
if((state_val_73711 === (1))){
var state_73710__$1 = state_73710;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73710__$1,(2),resp_chan_73819);
} else {
if((state_val_73711 === (2))){
var inst_73699 = (state_73710[(7)]);
var inst_73699__$1 = (state_73710[(2)]);
var inst_73700 = fluree.db.util.core.exception_QMARK_(inst_73699__$1);
var state_73710__$1 = (function (){var statearr_73712 = state_73710;
(statearr_73712[(7)] = inst_73699__$1);

return statearr_73712;
})();
if(inst_73700){
var statearr_73713_73821 = state_73710__$1;
(statearr_73713_73821[(1)] = (3));

} else {
var statearr_73714_73822 = state_73710__$1;
(statearr_73714_73822[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73711 === (3))){
var inst_73699 = (state_73710[(7)]);
var inst_73702 = cljs.core.ex_message(inst_73699);
var inst_73703 = cljs.core.ex_data(inst_73699);
var inst_73704 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_73702,inst_73703], 0));
var state_73710__$1 = state_73710;
var statearr_73715_73823 = state_73710__$1;
(statearr_73715_73823[(2)] = inst_73704);

(statearr_73715_73823[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73711 === (4))){
var inst_73706 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_73817);
var state_73710__$1 = state_73710;
var statearr_73716_73824 = state_73710__$1;
(statearr_73716_73824[(2)] = inst_73706);

(statearr_73716_73824[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73711 === (5))){
var inst_73708 = (state_73710[(2)]);
var state_73710__$1 = state_73710;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73710__$1,inst_73708);
} else {
return null;
}
}
}
}
}
});})(seq__73622_73791,chunk__73623_73792,count__73624_73793,i__73625_73794,c__11512__auto___73820,healthcheck_uri_73818,resp_chan_73819,server_73817,seq__73622_73811__$1,temp__5804__auto___73810))
;
return ((function (seq__73622_73791,chunk__73623_73792,count__73624_73793,i__73625_73794,switch__11437__auto__,c__11512__auto___73820,healthcheck_uri_73818,resp_chan_73819,server_73817,seq__73622_73811__$1,temp__5804__auto___73810){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____0 = (function (){
var statearr_73717 = [null,null,null,null,null,null,null,null];
(statearr_73717[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__);

(statearr_73717[(1)] = (1));

return statearr_73717;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____1 = (function (state_73710){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_73710);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e73718){var ex__11441__auto__ = e73718;
var statearr_73719_73825 = state_73710;
(statearr_73719_73825[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_73710[(4)]))){
var statearr_73720_73826 = state_73710;
(statearr_73720_73826[(1)] = cljs.core.first((state_73710[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73827 = state_73710;
state_73710 = G__73827;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__ = function(state_73710){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____1.call(this,state_73710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__;
})()
;})(seq__73622_73791,chunk__73623_73792,count__73624_73793,i__73625_73794,switch__11437__auto__,c__11512__auto___73820,healthcheck_uri_73818,resp_chan_73819,server_73817,seq__73622_73811__$1,temp__5804__auto___73810))
})();
var state__11514__auto__ = (function (){var statearr_73721 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_73721[(6)] = c__11512__auto___73820);

return statearr_73721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
});})(seq__73622_73791,chunk__73623_73792,count__73624_73793,i__73625_73794,c__11512__auto___73820,healthcheck_uri_73818,resp_chan_73819,server_73817,seq__73622_73811__$1,temp__5804__auto___73810))
);



var G__73828 = cljs.core.next(seq__73622_73811__$1);
var G__73829 = null;
var G__73830 = (0);
var G__73831 = (0);
seq__73622_73791 = G__73828;
chunk__73623_73792 = G__73829;
count__73624_73793 = G__73830;
i__73625_73794 = G__73831;
continue;
}
} else {
}
}
break;
}

var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_73765){
var state_val_73766 = (state_73765[(1)]);
if((state_val_73766 === (7))){
var inst_73737 = (state_73765[(7)]);
var inst_73744 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73737,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_73765__$1 = state_73765;
if(inst_73744){
var statearr_73767_73832 = state_73765__$1;
(statearr_73767_73832[(1)] = (9));

} else {
var statearr_73768_73833 = state_73765__$1;
(statearr_73768_73833[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73766 === (1))){
var inst_73729 = (state_73765[(8)]);
var inst_73730 = (state_73765[(9)]);
var inst_73729__$1 = promise_chan;
var inst_73730__$1 = cljs.core.async.timeout((60000));
var inst_73731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73732 = [inst_73729__$1,inst_73730__$1];
var inst_73733 = (new cljs.core.PersistentVector(null,2,(5),inst_73731,inst_73732,null));
var state_73765__$1 = (function (){var statearr_73769 = state_73765;
(statearr_73769[(8)] = inst_73729__$1);

(statearr_73769[(9)] = inst_73730__$1);

return statearr_73769;
})();
return cljs.core.async.ioc_alts_BANG_(state_73765__$1,(2),inst_73733);
} else {
if((state_val_73766 === (4))){
var inst_73730 = (state_73765[(9)]);
var inst_73737 = (state_73765[(7)]);
var inst_73741 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73737,inst_73730);
var state_73765__$1 = state_73765;
if(inst_73741){
var statearr_73770_73834 = state_73765__$1;
(statearr_73770_73834[(1)] = (6));

} else {
var statearr_73771_73835 = state_73765__$1;
(statearr_73771_73835[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73766 === (13))){
var state_73765__$1 = state_73765;
var statearr_73772_73836 = state_73765__$1;
(statearr_73772_73836[(2)] = null);

(statearr_73772_73836[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73766 === (6))){
var state_73765__$1 = state_73765;
var statearr_73773_73837 = state_73765__$1;
(statearr_73773_73837[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_73773_73837[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73766 === (3))){
var state_73765__$1 = state_73765;
var statearr_73774_73838 = state_73765__$1;
(statearr_73774_73838[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_73774_73838[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73766 === (12))){
var inst_73755 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_73756 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73757 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_73758 = cljs.core.PersistentHashMap.fromArrays(inst_73756,inst_73757);
var inst_73759 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_73758);
var inst_73760 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_73759);
var state_73765__$1 = (function (){var statearr_73775 = state_73765;
(statearr_73775[(10)] = inst_73755);

return statearr_73775;
})();
var statearr_73776_73839 = state_73765__$1;
(statearr_73776_73839[(2)] = inst_73760);

(statearr_73776_73839[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73766 === (2))){
var inst_73729 = (state_73765[(8)]);
var inst_73737 = (state_73765[(7)]);
var inst_73735 = (state_73765[(2)]);
var inst_73736 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73735,(0),null);
var inst_73737__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73735,(1),null);
var inst_73738 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73737__$1,inst_73729);
var state_73765__$1 = (function (){var statearr_73777 = state_73765;
(statearr_73777[(11)] = inst_73736);

(statearr_73777[(7)] = inst_73737__$1);

return statearr_73777;
})();
if(inst_73738){
var statearr_73778_73840 = state_73765__$1;
(statearr_73778_73840[(1)] = (3));

} else {
var statearr_73779_73841 = state_73765__$1;
(statearr_73779_73841[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73766 === (11))){
var inst_73748 = (state_73765[(2)]);
var state_73765__$1 = state_73765;
var statearr_73780_73842 = state_73765__$1;
(statearr_73780_73842[(2)] = inst_73748);

(statearr_73780_73842[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73766 === (9))){
var inst_73736 = (state_73765[(11)]);
var state_73765__$1 = state_73765;
var statearr_73781_73843 = state_73765__$1;
(statearr_73781_73843[(2)] = inst_73736);

(statearr_73781_73843[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73766 === (5))){
var inst_73752 = (state_73765[(2)]);
var inst_73753 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_73752);
var state_73765__$1 = state_73765;
if(inst_73753){
var statearr_73782_73844 = state_73765__$1;
(statearr_73782_73844[(1)] = (12));

} else {
var statearr_73783_73845 = state_73765__$1;
(statearr_73783_73845[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73766 === (14))){
var inst_73763 = (state_73765[(2)]);
var state_73765__$1 = state_73765;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73765__$1,inst_73763);
} else {
if((state_val_73766 === (10))){
var state_73765__$1 = state_73765;
var statearr_73784_73846 = state_73765__$1;
(statearr_73784_73846[(2)] = null);

(statearr_73784_73846[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73766 === (8))){
var inst_73750 = (state_73765[(2)]);
var state_73765__$1 = state_73765;
var statearr_73785_73847 = state_73765__$1;
(statearr_73785_73847[(2)] = inst_73750);

(statearr_73785_73847[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____0 = (function (){
var statearr_73786 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73786[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__);

(statearr_73786[(1)] = (1));

return statearr_73786;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____1 = (function (state_73765){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_73765);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e73787){var ex__11441__auto__ = e73787;
var statearr_73788_73848 = state_73765;
(statearr_73788_73848[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_73765[(4)]))){
var statearr_73789_73849 = state_73765;
(statearr_73789_73849[(1)] = cljs.core.first((state_73765[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73850 = state_73765;
state_73765 = G__73850;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__ = function(state_73765){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____1.call(this,state_73765);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_73790 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_73790[(6)] = c__11512__auto__);

return statearr_73790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_73894){
var state_val_73895 = (state_73894[(1)]);
if((state_val_73895 === (7))){
var state_73894__$1 = state_73894;
var statearr_73896_73922 = state_73894__$1;
(statearr_73896_73922[(2)] = null);

(statearr_73896_73922[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73895 === (1))){
var state_73894__$1 = state_73894;
var statearr_73897_73923 = state_73894__$1;
(statearr_73897_73923[(2)] = null);

(statearr_73897_73923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73895 === (4))){
var inst_73851 = (state_73894[(2)]);
var state_73894__$1 = state_73894;
var statearr_73898_73924 = state_73894__$1;
(statearr_73898_73924[(2)] = inst_73851);

(statearr_73898_73924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73895 === (6))){
var inst_73873 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_73894__$1 = state_73894;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73894__$1,(9),inst_73873);
} else {
if((state_val_73895 === (3))){
var inst_73892 = (state_73894[(2)]);
var state_73894__$1 = state_73894;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73894__$1,inst_73892);
} else {
if((state_val_73895 === (12))){
var inst_73886 = (state_73894[(2)]);
var state_73894__$1 = state_73894;
var statearr_73899_73925 = state_73894__$1;
(statearr_73899_73925[(2)] = inst_73886);

(statearr_73899_73925[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73895 === (2))){
var inst_73857 = (state_73894[(7)]);
var inst_73862 = (state_73894[(8)]);
var inst_73867 = (state_73894[(9)]);
var _ = (function (){var statearr_73900 = state_73894;
(statearr_73900[(4)] = cljs.core.cons((5),(state_73894[(4)])));

return statearr_73900;
})();
var inst_73857__$1 = fluree.db.util.core.random_uuid();
var inst_73858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73859 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_73860 = (new cljs.core.PersistentVector(null,2,(5),inst_73858,inst_73859,null));
var inst_73861 = (function (){var lock_id = inst_73857__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_73862__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_73860,inst_73861);
var inst_73863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73864 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_73865 = (new cljs.core.PersistentVector(null,3,(5),inst_73863,inst_73864,null));
var inst_73866 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_73862__$1,inst_73865);
var inst_73867__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73857__$1,inst_73866);
var inst_73868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73869 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_73870 = (new cljs.core.PersistentVector(null,3,(5),inst_73868,inst_73869,null));
var inst_73871 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_73862__$1,inst_73870);
var state_73894__$1 = (function (){var statearr_73901 = state_73894;
(statearr_73901[(7)] = inst_73857__$1);

(statearr_73901[(10)] = inst_73871);

(statearr_73901[(8)] = inst_73862__$1);

(statearr_73901[(9)] = inst_73867__$1);

return statearr_73901;
})();
if(inst_73867__$1){
var statearr_73902_73926 = state_73894__$1;
(statearr_73902_73926[(1)] = (6));

} else {
var statearr_73903_73927 = state_73894__$1;
(statearr_73903_73927[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73895 === (11))){
var inst_73871 = (state_73894[(10)]);
var inst_73877 = (state_73894[(11)]);
var inst_73878 = (state_73894[(12)]);
var inst_73884 = fluree.db.util.xhttp.try_socket(inst_73877,sub_chan,pub_chan,inst_73871,(60000),inst_73878);
var state_73894__$1 = state_73894;
var statearr_73905_73928 = state_73894__$1;
(statearr_73905_73928[(2)] = inst_73884);

(statearr_73905_73928[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73895 === (9))){
var inst_73857 = (state_73894[(7)]);
var inst_73871 = (state_73894[(10)]);
var inst_73877 = (state_73894[(11)]);
var inst_73862 = (state_73894[(8)]);
var inst_73867 = (state_73894[(9)]);
var inst_73875 = (state_73894[(13)]);
var inst_73875__$1 = (state_73894[(2)]);
var inst_73876 = clojure.string.replace(inst_73875__$1,"http","ws");
var inst_73877__$1 = [inst_73876,"/fdb/ws"].join('');
var inst_73878 = (function (){var lock_id = inst_73857;
var state = inst_73862;
var have_lock_QMARK_ = inst_73867;
var resp_chan = inst_73871;
var healthy_server = inst_73875__$1;
var ws_url = inst_73877__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_73879 = fluree.db.util.core.exception_QMARK_(inst_73875__$1);
var state_73894__$1 = (function (){var statearr_73906 = state_73894;
(statearr_73906[(11)] = inst_73877__$1);

(statearr_73906[(12)] = inst_73878);

(statearr_73906[(13)] = inst_73875__$1);

return statearr_73906;
})();
if(inst_73879){
var statearr_73907_73929 = state_73894__$1;
(statearr_73907_73929[(1)] = (10));

} else {
var statearr_73908_73930 = state_73894__$1;
(statearr_73908_73930[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73895 === (5))){
var _ = (function (){var statearr_73909 = state_73894;
(statearr_73909[(4)] = cljs.core.rest((state_73894[(4)])));

return statearr_73909;
})();
var state_73894__$1 = state_73894;
var ex73904 = (state_73894__$1[(2)]);
var statearr_73910_73931 = state_73894__$1;
(statearr_73910_73931[(5)] = ex73904);


if((ex73904 instanceof Error)){
var statearr_73911_73932 = state_73894__$1;
(statearr_73911_73932[(1)] = (4));

(statearr_73911_73932[(5)] = null);

} else {
throw ex73904;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73895 === (10))){
var inst_73871 = (state_73894[(10)]);
var inst_73875 = (state_73894[(13)]);
var inst_73881 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_73882 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73871,inst_73875);
var state_73894__$1 = (function (){var statearr_73912 = state_73894;
(statearr_73912[(14)] = inst_73881);

return statearr_73912;
})();
var statearr_73913_73933 = state_73894__$1;
(statearr_73913_73933[(2)] = inst_73882);

(statearr_73913_73933[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73895 === (8))){
var inst_73871 = (state_73894[(10)]);
var inst_73889 = (state_73894[(2)]);
var _ = (function (){var statearr_73914 = state_73894;
(statearr_73914[(4)] = cljs.core.rest((state_73894[(4)])));

return statearr_73914;
})();
var state_73894__$1 = (function (){var statearr_73915 = state_73894;
(statearr_73915[(15)] = inst_73889);

return statearr_73915;
})();
var statearr_73916_73934 = state_73894__$1;
(statearr_73916_73934[(2)] = inst_73871);

(statearr_73916_73934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__11438__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__11438__auto____0 = (function (){
var statearr_73917 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73917[(0)] = fluree$db$connection$establish_socket_$_state_machine__11438__auto__);

(statearr_73917[(1)] = (1));

return statearr_73917;
});
var fluree$db$connection$establish_socket_$_state_machine__11438__auto____1 = (function (state_73894){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_73894);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e73918){var ex__11441__auto__ = e73918;
var statearr_73919_73935 = state_73894;
(statearr_73919_73935[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_73894[(4)]))){
var statearr_73920_73936 = state_73894;
(statearr_73920_73936[(1)] = cljs.core.first((state_73894[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73937 = state_73894;
state_73894 = G__73937;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__11438__auto__ = function(state_73894){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__11438__auto____1.call(this,state_73894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__11438__auto____0;
fluree$db$connection$establish_socket_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__11438__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_73921 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_73921[(6)] = c__11512__auto__);

return statearr_73921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k73939,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__73943 = k73939;
var G__73943__$1 = (((G__73943 instanceof cljs.core.Keyword))?G__73943.fqn:null);
switch (G__73943__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k73939,else__5345__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5365__auto__,p__73944){
var vec__73945 = p__73944;
var k__5366__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73945,(0),null);
var v__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73945,(1),null);
return (f__5363__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5363__auto__.cljs$core$IFn$_invoke$arity$3(ret__5365__auto__,k__5366__auto__,v__5367__auto__) : f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__));
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer(writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer(writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5359__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__73938){
var self__ = this;
var G__73938__$1 = this;
return (new cljs.core.RecordIter((0),G__73938__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (22 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__73948 = (function (coll__5339__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__5339__auto__));
});
return fexpr__73948(this__5338__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this73940,other73941){
var self__ = this;
var this73940__$1 = this;
return (((!((other73941 == null)))) && ((((this73940__$1.constructor === other73941.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.id,other73941.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.servers,other73941.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.state,other73941.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.req_chan,other73941.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.sub_chan,other73941.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.pub_chan,other73941.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.group,other73941.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.storage_read,other73941.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.storage_write,other73941.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.object_cache,other73941.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.parallelism,other73941.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.serializer,other73941.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.default_network,other73941.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.transactor_QMARK_,other73941.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.publish,other73941.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.transact_handler,other73941.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.tx_private_key,other73941.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.tx_key_id,other73941.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.meta,other73941.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.add_listener,other73941.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.remove_listener,other73941.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.close,other73941.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73940__$1.__extmap,other73941.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5353__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k73939){
var self__ = this;
var this__5349__auto____$1 = this;
var G__73949 = k73939;
var G__73949__$1 = (((G__73949 instanceof cljs.core.Keyword))?G__73949.fqn:null);
switch (G__73949__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k73939);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__73938){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__73950 = cljs.core.keyword_identical_QMARK_;
var expr__73951 = k__5351__auto__;
if(cljs.core.truth_((function (){var G__73953 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__73954 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73953,G__73954) : pred__73950.call(null,G__73953,G__73954));
})())){
return (new fluree.db.connection.Connection(G__73938,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73955 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__73956 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73955,G__73956) : pred__73950.call(null,G__73955,G__73956));
})())){
return (new fluree.db.connection.Connection(self__.id,G__73938,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73957 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__73958 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73957,G__73958) : pred__73950.call(null,G__73957,G__73958));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__73938,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73959 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__73960 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73959,G__73960) : pred__73950.call(null,G__73959,G__73960));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__73938,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73961 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__73962 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73961,G__73962) : pred__73950.call(null,G__73961,G__73962));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__73938,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73963 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__73964 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73963,G__73964) : pred__73950.call(null,G__73963,G__73964));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__73938,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73965 = new cljs.core.Keyword(null,"group","group",582596132);
var G__73966 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73965,G__73966) : pred__73950.call(null,G__73965,G__73966));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__73938,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73967 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__73968 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73967,G__73968) : pred__73950.call(null,G__73967,G__73968));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__73938,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73969 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__73970 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73969,G__73970) : pred__73950.call(null,G__73969,G__73970));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__73938,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73971 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__73972 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73971,G__73972) : pred__73950.call(null,G__73971,G__73972));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__73938,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73973 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__73974 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73973,G__73974) : pred__73950.call(null,G__73973,G__73974));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__73938,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73975 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__73976 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73975,G__73976) : pred__73950.call(null,G__73975,G__73976));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__73938,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73977 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__73978 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73977,G__73978) : pred__73950.call(null,G__73977,G__73978));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__73938,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73979 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__73980 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73979,G__73980) : pred__73950.call(null,G__73979,G__73980));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__73938,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73981 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__73982 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73981,G__73982) : pred__73950.call(null,G__73981,G__73982));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__73938,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73983 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__73984 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73983,G__73984) : pred__73950.call(null,G__73983,G__73984));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__73938,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73985 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__73986 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73985,G__73986) : pred__73950.call(null,G__73985,G__73986));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__73938,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73987 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__73988 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73987,G__73988) : pred__73950.call(null,G__73987,G__73988));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__73938,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73989 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__73990 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73989,G__73990) : pred__73950.call(null,G__73989,G__73990));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__73938,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73991 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__73992 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73991,G__73992) : pred__73950.call(null,G__73991,G__73992));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__73938,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73993 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__73994 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73993,G__73994) : pred__73950.call(null,G__73993,G__73994));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__73938,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73995 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__73996 = expr__73951;
return (pred__73950.cljs$core$IFn$_invoke$arity$2 ? pred__73950.cljs$core$IFn$_invoke$arity$2(G__73995,G__73996) : pred__73950.call(null,G__73995,G__73996));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__73938,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5351__auto__,G__73938),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__73938){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__73938,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write(writer__5389__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__73942){
var extmap__5384__auto__ = (function (){var G__73997 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__73942,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__73942)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__73997);
} else {
return G__73997;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__73942),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__73942),null,cljs.core.not_empty(extmap__5384__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__74003 = servers_STAR_;
var vec__74004 = G__74003;
var seq__74005 = cljs.core.seq(vec__74004);
var first__74006 = cljs.core.first(seq__74005);
var seq__74005__$1 = cljs.core.next(seq__74005);
var server = first__74006;
var r = seq__74005__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__74003__$1 = G__74003;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__74010 = G__74003__$1;
var seq__74011 = cljs.core.seq(vec__74010);
var first__74012 = cljs.core.first(seq__74011);
var seq__74011__$1 = cljs.core.next(seq__74011);
var server__$1 = first__74012;
var r__$1 = seq__74011__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__74013 = r__$1;
var G__74014 = is_https_QMARK_;
var G__74015 = result_STAR_;
G__74003__$1 = G__74013;
https_QMARK___$1 = G__74014;
result__$1 = G__74015;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__74016 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__74016 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__74016);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_74045){
var state_val_74046 = (state_74045[(1)]);
if((state_val_74046 === (7))){
var inst_74031 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74032 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74033 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74034 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74035 = fluree.db.connection.establish_socket(inst_74031,inst_74032,inst_74033,inst_74034);
var state_74045__$1 = state_74045;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74045__$1,(9),inst_74035);
} else {
if((state_val_74046 === (1))){
var state_74045__$1 = state_74045;
var statearr_74047_74066 = state_74045__$1;
(statearr_74047_74066[(2)] = null);

(statearr_74047_74066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74046 === (4))){
var inst_74017 = (state_74045[(2)]);
var state_74045__$1 = state_74045;
var statearr_74048_74067 = state_74045__$1;
(statearr_74048_74067[(2)] = inst_74017);

(statearr_74048_74067[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74046 === (6))){
var inst_74028 = (state_74045[(7)]);
var state_74045__$1 = state_74045;
var statearr_74049_74068 = state_74045__$1;
(statearr_74049_74068[(2)] = inst_74028);

(statearr_74049_74068[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74046 === (3))){
var inst_74043 = (state_74045[(2)]);
var state_74045__$1 = state_74045;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74045__$1,inst_74043);
} else {
if((state_val_74046 === (2))){
var inst_74028 = (state_74045[(7)]);
var _ = (function (){var statearr_74051 = state_74045;
(statearr_74051[(4)] = cljs.core.cons((5),(state_74045[(4)])));

return statearr_74051;
})();
var inst_74023 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_74024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74025 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74026 = [inst_74025,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_74027 = (new cljs.core.PersistentVector(null,3,(5),inst_74024,inst_74026,null));
var inst_74028__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_74023,inst_74027);
var state_74045__$1 = (function (){var statearr_74052 = state_74045;
(statearr_74052[(7)] = inst_74028__$1);

return statearr_74052;
})();
if(cljs.core.truth_(inst_74028__$1)){
var statearr_74053_74069 = state_74045__$1;
(statearr_74053_74069[(1)] = (6));

} else {
var statearr_74054_74070 = state_74045__$1;
(statearr_74054_74070[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74046 === (9))){
var inst_74037 = (state_74045[(2)]);
var inst_74038 = fluree.db.util.async.throw_err(inst_74037);
var state_74045__$1 = state_74045;
var statearr_74055_74071 = state_74045__$1;
(statearr_74055_74071[(2)] = inst_74038);

(statearr_74055_74071[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74046 === (5))){
var _ = (function (){var statearr_74056 = state_74045;
(statearr_74056[(4)] = cljs.core.rest((state_74045[(4)])));

return statearr_74056;
})();
var state_74045__$1 = state_74045;
var ex74050 = (state_74045__$1[(2)]);
var statearr_74057_74072 = state_74045__$1;
(statearr_74057_74072[(5)] = ex74050);


if((ex74050 instanceof Error)){
var statearr_74058_74073 = state_74045__$1;
(statearr_74058_74073[(1)] = (4));

(statearr_74058_74073[(5)] = null);

} else {
throw ex74050;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74046 === (8))){
var inst_74040 = (state_74045[(2)]);
var _ = (function (){var statearr_74059 = state_74045;
(statearr_74059[(4)] = cljs.core.rest((state_74045[(4)])));

return statearr_74059;
})();
var state_74045__$1 = state_74045;
var statearr_74060_74074 = state_74045__$1;
(statearr_74060_74074[(2)] = inst_74040);

(statearr_74060_74074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__11438__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__11438__auto____0 = (function (){
var statearr_74061 = [null,null,null,null,null,null,null,null];
(statearr_74061[(0)] = fluree$db$connection$get_socket_$_state_machine__11438__auto__);

(statearr_74061[(1)] = (1));

return statearr_74061;
});
var fluree$db$connection$get_socket_$_state_machine__11438__auto____1 = (function (state_74045){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_74045);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e74062){var ex__11441__auto__ = e74062;
var statearr_74063_74075 = state_74045;
(statearr_74063_74075[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_74045[(4)]))){
var statearr_74064_74076 = state_74045;
(statearr_74064_74076[(1)] = cljs.core.first((state_74045[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74077 = state_74045;
state_74045 = G__74077;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__11438__auto__ = function(state_74045){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__11438__auto____1.call(this,state_74045);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__11438__auto____0;
fluree$db$connection$get_socket_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__11438__auto____1;
return fluree$db$connection$get_socket_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_74065 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_74065[(6)] = c__11512__auto__);

return statearr_74065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e74078){var e = e74078;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_74205){
var state_val_74206 = (state_74205[(1)]);
if((state_val_74206 === (7))){
var inst_74201 = (state_74205[(2)]);
var state_74205__$1 = state_74205;
var statearr_74208_74278 = state_74205__$1;
(statearr_74208_74278[(2)] = inst_74201);

(statearr_74208_74278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (20))){
var _ = (function (){var statearr_74209 = state_74205;
(statearr_74209[(4)] = cljs.core.rest((state_74205[(4)])));

return statearr_74209;
})();
var state_74205__$1 = state_74205;
var ex74207 = (state_74205__$1[(2)]);
var statearr_74210_74279 = state_74205__$1;
(statearr_74210_74279[(5)] = ex74207);


var statearr_74211_74280 = state_74205__$1;
(statearr_74211_74280[(1)] = (10));

(statearr_74211_74280[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (27))){
var inst_74193 = (state_74205[(2)]);
var _ = (function (){var statearr_74212 = state_74205;
(statearr_74212[(4)] = cljs.core.rest((state_74205[(4)])));

return statearr_74212;
})();
var state_74205__$1 = state_74205;
var statearr_74213_74281 = state_74205__$1;
(statearr_74213_74281[(2)] = inst_74193);

(statearr_74213_74281[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (1))){
var inst_74080 = (0);
var state_74205__$1 = (function (){var statearr_74214 = state_74205;
(statearr_74214[(7)] = inst_74080);

return statearr_74214;
})();
var statearr_74215_74282 = state_74205__$1;
(statearr_74215_74282[(2)] = null);

(statearr_74215_74282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (24))){
var inst_74171 = (state_74205[(8)]);
var inst_74171__$1 = (state_74205[(2)]);
var inst_74172 = inst_74171__$1 === true;
var state_74205__$1 = (function (){var statearr_74216 = state_74205;
(statearr_74216[(8)] = inst_74171__$1);

return statearr_74216;
})();
if(cljs.core.truth_(inst_74172)){
var statearr_74217_74283 = state_74205__$1;
(statearr_74217_74283[(1)] = (25));

} else {
var statearr_74218_74284 = state_74205__$1;
(statearr_74218_74284[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (4))){
var inst_74083 = (state_74205[(9)]);
var inst_74083__$1 = (state_74205[(2)]);
var state_74205__$1 = (function (){var statearr_74219 = state_74205;
(statearr_74219[(9)] = inst_74083__$1);

return statearr_74219;
})();
if(cljs.core.truth_(inst_74083__$1)){
var statearr_74220_74285 = state_74205__$1;
(statearr_74220_74285[(1)] = (5));

} else {
var statearr_74221_74286 = state_74205__$1;
(statearr_74221_74286[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (15))){
var inst_74096 = (state_74205[(10)]);
var state_74205__$1 = state_74205;
var statearr_74222_74287 = state_74205__$1;
(statearr_74222_74287[(2)] = inst_74096);

(statearr_74222_74287[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (21))){
var inst_74123 = (state_74205[(11)]);
var inst_74080 = (state_74205[(7)]);
var inst_74083 = (state_74205[(9)]);
var inst_74121 = (state_74205[(12)]);
var inst_74127 = (state_74205[(13)]);
var inst_74119 = (state_74205[(14)]);
var inst_74122 = (state_74205[(15)]);
var inst_74124 = (state_74205[(16)]);
var inst_74128 = (state_74205[(17)]);
var inst_74120 = (state_74205[(18)]);
var inst_74130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74131 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_74127];
var inst_74132 = (new cljs.core.PersistentVector(null,2,(5),inst_74130,inst_74131,null));
var inst_74133 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_74132,inst_74122);
var inst_74160 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_74161 = (function (){var resp_chan = inst_74122;
var timeout = inst_74128;
var c__11512__auto____$1 = inst_74160;
var i = inst_74080;
var data = inst_74121;
var _ = inst_74119;
var map__74118 = inst_74124;
var req_id = inst_74127;
var operation = inst_74120;
var vec__74115 = inst_74083;
var msg = inst_74083;
var opts = inst_74123;
return (function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_74158){
var state_val_74159 = (state_74158[(1)]);
if((state_val_74159 === (1))){
var inst_74137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74138 = cljs.core.async.timeout(timeout);
var inst_74139 = [resp_chan,inst_74138];
var inst_74140 = (new cljs.core.PersistentVector(null,2,(5),inst_74137,inst_74139,null));
var state_74158__$1 = state_74158;
return cljs.core.async.ioc_alts_BANG_(state_74158__$1,(2),inst_74140);
} else {
if((state_val_74159 === (2))){
var inst_74143 = (state_74158[(7)]);
var inst_74142 = (state_74158[(2)]);
var inst_74143__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74142,(0),null);
var inst_74144 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74142,(1),null);
var inst_74145 = (function (){var vec__74134 = inst_74142;
var resp = inst_74143__$1;
var c = inst_74144;
return (function (p1__74079_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__74079_SHARP_,req_id);
});
})();
var inst_74146 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_74145);
var inst_74147 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74144,resp_chan);
var state_74158__$1 = (function (){var statearr_74223 = state_74158;
(statearr_74223[(7)] = inst_74143__$1);

(statearr_74223[(8)] = inst_74146);

return statearr_74223;
})();
if(inst_74147){
var statearr_74224_74288 = state_74158__$1;
(statearr_74224_74288[(1)] = (3));

} else {
var statearr_74225_74289 = state_74158__$1;
(statearr_74225_74289[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74159 === (3))){
var inst_74143 = (state_74158[(7)]);
var state_74158__$1 = state_74158;
var statearr_74226_74290 = state_74158__$1;
(statearr_74226_74290[(2)] = inst_74143);

(statearr_74226_74290[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74159 === (4))){
var inst_74150 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_74151 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74152 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_74153 = cljs.core.PersistentHashMap.fromArrays(inst_74151,inst_74152);
var inst_74154 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74150,inst_74153);
var state_74158__$1 = state_74158;
var statearr_74227_74291 = state_74158__$1;
(statearr_74227_74291[(2)] = inst_74154);

(statearr_74227_74291[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74159 === (5))){
var inst_74156 = (state_74158[(2)]);
var state_74158__$1 = state_74158;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74158__$1,inst_74156);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__11438__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__11438__auto____0 = (function (){
var statearr_74228 = [null,null,null,null,null,null,null,null,null];
(statearr_74228[(0)] = fluree$db$connection$msg_producer_$_state_machine__11438__auto__);

(statearr_74228[(1)] = (1));

return statearr_74228;
});
var fluree$db$connection$msg_producer_$_state_machine__11438__auto____1 = (function (state_74158){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_74158);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e74229){var ex__11441__auto__ = e74229;
var statearr_74230_74292 = state_74158;
(statearr_74230_74292[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_74158[(4)]))){
var statearr_74231_74293 = state_74158;
(statearr_74231_74293[(1)] = cljs.core.first((state_74158[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74294 = state_74158;
state_74158 = G__74294;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__11438__auto__ = function(state_74158){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__11438__auto____1.call(this,state_74158);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__11438__auto____0;
fluree$db$connection$msg_producer_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__11438__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_74232 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_74232[(6)] = c__11512__auto____$1);

return statearr_74232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
});
})();
var inst_74162 = cljs.core.async.impl.dispatch.run(inst_74161);
var state_74205__$1 = (function (){var statearr_74233 = state_74205;
(statearr_74233[(19)] = inst_74162);

(statearr_74233[(20)] = inst_74133);

return statearr_74233;
})();
var statearr_74234_74295 = state_74205__$1;
(statearr_74234_74295[(2)] = inst_74160);

(statearr_74234_74295[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (31))){
var inst_74181 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_74205__$1 = state_74205;
var statearr_74235_74296 = state_74205__$1;
(statearr_74235_74296[(2)] = inst_74181);

(statearr_74235_74296[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (32))){
var state_74205__$1 = state_74205;
var statearr_74236_74297 = state_74205__$1;
(statearr_74236_74297[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (33))){
var inst_74189 = (state_74205[(2)]);
var state_74205__$1 = state_74205;
var statearr_74238_74298 = state_74205__$1;
(statearr_74238_74298[(2)] = inst_74189);

(statearr_74238_74298[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (13))){
var inst_74096 = (state_74205[(10)]);
var inst_74093 = (state_74205[(2)]);
var inst_74094 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74093,(0),null);
var inst_74095 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74093,(1),null);
var inst_74096__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74093,(2),null);
var state_74205__$1 = (function (){var statearr_74239 = state_74205;
(statearr_74239[(21)] = inst_74094);

(statearr_74239[(10)] = inst_74096__$1);

(statearr_74239[(22)] = inst_74095);

return statearr_74239;
})();
if(cljs.core.truth_(inst_74096__$1)){
var statearr_74240_74299 = state_74205__$1;
(statearr_74240_74299[(1)] = (14));

} else {
var statearr_74241_74300 = state_74205__$1;
(statearr_74241_74300[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (22))){
var state_74205__$1 = state_74205;
var statearr_74242_74301 = state_74205__$1;
(statearr_74242_74301[(2)] = null);

(statearr_74242_74301[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (36))){
var inst_74187 = (state_74205[(2)]);
var state_74205__$1 = state_74205;
var statearr_74243_74302 = state_74205__$1;
(statearr_74243_74302[(2)] = inst_74187);

(statearr_74243_74302[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (29))){
var inst_74171 = (state_74205[(8)]);
var inst_74179 = (inst_74171 == null);
var state_74205__$1 = state_74205;
if(cljs.core.truth_(inst_74179)){
var statearr_74244_74303 = state_74205__$1;
(statearr_74244_74303[(1)] = (31));

} else {
var statearr_74245_74304 = state_74205__$1;
(statearr_74245_74304[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (6))){
var state_74205__$1 = state_74205;
var statearr_74246_74305 = state_74205__$1;
(statearr_74246_74305[(2)] = null);

(statearr_74246_74305[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (28))){
var inst_74171 = (state_74205[(8)]);
var inst_74177 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74171,"Error processing message in producer."], 0));
var state_74205__$1 = state_74205;
var statearr_74247_74306 = state_74205__$1;
(statearr_74247_74306[(2)] = inst_74177);

(statearr_74247_74306[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (25))){
var state_74205__$1 = state_74205;
var statearr_74248_74307 = state_74205__$1;
(statearr_74248_74307[(2)] = null);

(statearr_74248_74307[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (34))){
var inst_74171 = (state_74205[(8)]);
var inst_74184 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_74171], 0));
var state_74205__$1 = state_74205;
var statearr_74249_74308 = state_74205__$1;
(statearr_74249_74308[(2)] = inst_74184);

(statearr_74249_74308[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (17))){
var inst_74096 = (state_74205[(10)]);
var inst_74085 = (state_74205[(23)]);
var inst_74103 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74096,inst_74085);
var state_74205__$1 = state_74205;
var statearr_74250_74309 = state_74205__$1;
(statearr_74250_74309[(2)] = inst_74103);

(statearr_74250_74309[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (3))){
var inst_74203 = (state_74205[(2)]);
var state_74205__$1 = state_74205;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74205__$1,inst_74203);
} else {
if((state_val_74206 === (12))){
var state_74205__$1 = state_74205;
var statearr_74251_74310 = state_74205__$1;
(statearr_74251_74310[(2)] = null);

(statearr_74251_74310[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (2))){
var state_74205__$1 = state_74205;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74205__$1,(4),req_chan);
} else {
if((state_val_74206 === (23))){
var inst_74121 = (state_74205[(12)]);
var inst_74127 = (state_74205[(13)]);
var inst_74120 = (state_74205[(18)]);
var inst_74165 = (state_74205[(2)]);
var inst_74166 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74167 = [inst_74120,inst_74127,inst_74121];
var inst_74168 = (new cljs.core.PersistentVector(null,3,(5),inst_74166,inst_74167,null));
var inst_74169 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_74168) : publish_fn.call(null,conn,inst_74168));
var state_74205__$1 = (function (){var statearr_74252 = state_74205;
(statearr_74252[(24)] = inst_74165);

return statearr_74252;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74205__$1,(24),inst_74169);
} else {
if((state_val_74206 === (35))){
var state_74205__$1 = state_74205;
var statearr_74253_74311 = state_74205__$1;
(statearr_74253_74311[(2)] = null);

(statearr_74253_74311[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (19))){
var inst_74109 = (state_74205[(2)]);
var state_74205__$1 = state_74205;
var statearr_74254_74312 = state_74205__$1;
(statearr_74254_74312[(2)] = inst_74109);

(statearr_74254_74312[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (11))){
var inst_74083 = (state_74205[(9)]);
var state_74205__$1 = state_74205;
var statearr_74255_74313 = state_74205__$1;
(statearr_74255_74313[(2)] = inst_74083);

(statearr_74255_74313[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (9))){
var inst_74080 = (state_74205[(7)]);
var inst_74196 = (state_74205[(2)]);
var inst_74197 = (inst_74080 + (1));
var inst_74080__$1 = inst_74197;
var state_74205__$1 = (function (){var statearr_74256 = state_74205;
(statearr_74256[(7)] = inst_74080__$1);

(statearr_74256[(25)] = inst_74196);

return statearr_74256;
})();
var statearr_74257_74314 = state_74205__$1;
(statearr_74257_74314[(2)] = null);

(statearr_74257_74314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (5))){
var state_74205__$1 = state_74205;
var statearr_74258_74315 = state_74205__$1;
(statearr_74258_74315[(2)] = null);

(statearr_74258_74315[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (14))){
var inst_74096 = (state_74205[(10)]);
var inst_74098 = fluree.db.util.async.channel_QMARK_(inst_74096);
var state_74205__$1 = state_74205;
var statearr_74259_74316 = state_74205__$1;
(statearr_74259_74316[(2)] = inst_74098);

(statearr_74259_74316[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (26))){
var inst_74171 = (state_74205[(8)]);
var inst_74175 = fluree.db.util.core.exception_QMARK_(inst_74171);
var state_74205__$1 = state_74205;
if(inst_74175){
var statearr_74260_74317 = state_74205__$1;
(statearr_74260_74317[(1)] = (28));

} else {
var statearr_74261_74318 = state_74205__$1;
(statearr_74261_74318[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (16))){
var inst_74101 = (state_74205[(2)]);
var state_74205__$1 = state_74205;
if(cljs.core.truth_(inst_74101)){
var statearr_74262_74319 = state_74205__$1;
(statearr_74262_74319[(1)] = (17));

} else {
var statearr_74263_74320 = state_74205__$1;
(statearr_74263_74320[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (30))){
var inst_74191 = (state_74205[(2)]);
var state_74205__$1 = state_74205;
var statearr_74264_74321 = state_74205__$1;
(statearr_74264_74321[(2)] = inst_74191);

(statearr_74264_74321[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (10))){
var inst_74083 = (state_74205[(9)]);
var inst_74085 = (state_74205[(2)]);
var inst_74089 = cljs.core.sequential_QMARK_(inst_74083);
var state_74205__$1 = (function (){var statearr_74265 = state_74205;
(statearr_74265[(23)] = inst_74085);

return statearr_74265;
})();
if(inst_74089){
var statearr_74266_74322 = state_74205__$1;
(statearr_74266_74322[(1)] = (11));

} else {
var statearr_74267_74323 = state_74205__$1;
(statearr_74267_74323[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (18))){
var inst_74083 = (state_74205[(9)]);
var inst_74085 = (state_74205[(23)]);
var inst_74105 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74083], 0));
var inst_74106 = ["Error processing ledger request, no valid return channel: ",inst_74105].join('');
var inst_74107 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74085,inst_74106], 0));
var state_74205__$1 = state_74205;
var statearr_74268_74324 = state_74205__$1;
(statearr_74268_74324[(2)] = inst_74107);

(statearr_74268_74324[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74206 === (8))){
var inst_74123 = (state_74205[(11)]);
var inst_74083 = (state_74205[(9)]);
var inst_74122 = (state_74205[(15)]);
var inst_74124 = (state_74205[(16)]);
var _ = (function (){var statearr_74269 = state_74205;
(statearr_74269[(4)] = cljs.core.cons((20),(state_74205[(4)])));

return statearr_74269;
})();
var inst_74119 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_74083], 0));
var inst_74120 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74083,(0),null);
var inst_74121 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74083,(1),null);
var inst_74122__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74083,(2),null);
var inst_74123__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74083,(3),null);
var inst_74124__$1 = cljs.core.__destructure_map(inst_74123__$1);
var inst_74125 = fluree.db.util.core.random_uuid();
var inst_74126 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74125);
var inst_74127 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_74124__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_74126);
var inst_74128 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_74124__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_74205__$1 = (function (){var statearr_74270 = state_74205;
(statearr_74270[(11)] = inst_74123__$1);

(statearr_74270[(12)] = inst_74121);

(statearr_74270[(13)] = inst_74127);

(statearr_74270[(14)] = inst_74119);

(statearr_74270[(15)] = inst_74122__$1);

(statearr_74270[(16)] = inst_74124__$1);

(statearr_74270[(17)] = inst_74128);

(statearr_74270[(18)] = inst_74120);

return statearr_74270;
})();
if(cljs.core.truth_(inst_74122__$1)){
var statearr_74271_74325 = state_74205__$1;
(statearr_74271_74325[(1)] = (21));

} else {
var statearr_74272_74326 = state_74205__$1;
(statearr_74272_74326[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__11438__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__11438__auto____0 = (function (){
var statearr_74273 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74273[(0)] = fluree$db$connection$msg_producer_$_state_machine__11438__auto__);

(statearr_74273[(1)] = (1));

return statearr_74273;
});
var fluree$db$connection$msg_producer_$_state_machine__11438__auto____1 = (function (state_74205){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_74205);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e74274){var ex__11441__auto__ = e74274;
var statearr_74275_74327 = state_74205;
(statearr_74275_74327[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_74205[(4)]))){
var statearr_74276_74328 = state_74205;
(statearr_74276_74328[(1)] = cljs.core.first((state_74205[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74329 = state_74205;
state_74205 = G__74329;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__11438__auto__ = function(state_74205){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__11438__auto____1.call(this,state_74205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__11438__auto____0;
fluree$db$connection$msg_producer_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__11438__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_74277 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_74277[(6)] = c__11512__auto__);

return statearr_74277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__74330 = conn;
var map__74330__$1 = cljs.core.__destructure_map(map__74330);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74330__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_74415){
var state_val_74416 = (state_74415[(1)]);
if((state_val_74416 === (7))){
var inst_74411 = (state_74415[(2)]);
var state_74415__$1 = state_74415;
var statearr_74417_74468 = state_74415__$1;
(statearr_74417_74468[(2)] = inst_74411);

(statearr_74417_74468[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (20))){
var inst_74349 = (state_74415[(7)]);
var inst_74363 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_74364 = [inst_74349];
var inst_74365 = cljs.core.PersistentHashMap.fromArrays(inst_74363,inst_74364);
var inst_74366 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_74365], 0));
var state_74415__$1 = state_74415;
var statearr_74418_74469 = state_74415__$1;
(statearr_74418_74469[(2)] = inst_74366);

(statearr_74418_74469[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (27))){
var state_74415__$1 = state_74415;
var statearr_74419_74470 = state_74415__$1;
(statearr_74419_74470[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (1))){
var inst_74331 = (0);
var state_74415__$1 = (function (){var statearr_74421 = state_74415;
(statearr_74421[(8)] = inst_74331);

return statearr_74421;
})();
var statearr_74422_74471 = state_74415__$1;
(statearr_74422_74471[(2)] = null);

(statearr_74422_74471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (24))){
var inst_74342 = (state_74415[(9)]);
var inst_74391 = fluree.db.util.core.exception_QMARK_(inst_74342);
var state_74415__$1 = state_74415;
if(inst_74391){
var statearr_74423_74472 = state_74415__$1;
(statearr_74423_74472[(1)] = (26));

} else {
var statearr_74424_74473 = state_74415__$1;
(statearr_74424_74473[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (4))){
var inst_74336 = (state_74415[(10)]);
var inst_74341 = (state_74415[(2)]);
var inst_74342 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74341,(0),null);
var inst_74343 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74341,(1),null);
var inst_74344 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74343,inst_74336);
var state_74415__$1 = (function (){var statearr_74425 = state_74415;
(statearr_74425[(9)] = inst_74342);

return statearr_74425;
})();
if(inst_74344){
var statearr_74426_74474 = state_74415__$1;
(statearr_74426_74474[(1)] = (5));

} else {
var statearr_74427_74475 = state_74415__$1;
(statearr_74427_74475[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (15))){
var inst_74349 = (state_74415[(7)]);
var inst_74358 = typeof inst_74349 === 'string';
var state_74415__$1 = state_74415;
if(cljs.core.truth_(inst_74358)){
var statearr_74428_74476 = state_74415__$1;
(statearr_74428_74476[(1)] = (17));

} else {
var statearr_74429_74477 = state_74415__$1;
(statearr_74429_74477[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (21))){
var state_74415__$1 = state_74415;
var statearr_74430_74478 = state_74415__$1;
(statearr_74430_74478[(2)] = null);

(statearr_74430_74478[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (31))){
var inst_74405 = (state_74415[(2)]);
var state_74415__$1 = state_74415;
var statearr_74431_74479 = state_74415__$1;
(statearr_74431_74479[(2)] = inst_74405);

(statearr_74431_74479[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (13))){
var inst_74375 = (state_74415[(2)]);
var inst_74376 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74377 = fluree.db.connection.close_websocket(inst_74376);
var inst_74378 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74379 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_74378);
var state_74415__$1 = (function (){var statearr_74432 = state_74415;
(statearr_74432[(11)] = inst_74375);

(statearr_74432[(12)] = inst_74377);

return statearr_74432;
})();
var statearr_74433_74480 = state_74415__$1;
(statearr_74433_74480[(2)] = inst_74379);

(statearr_74433_74480[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (22))){
var inst_74369 = (state_74415[(2)]);
var state_74415__$1 = state_74415;
var statearr_74434_74481 = state_74415__$1;
(statearr_74434_74481[(2)] = inst_74369);

(statearr_74434_74481[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (29))){
var inst_74342 = (state_74415[(9)]);
var inst_74397 = fluree.db.util.json.parse(inst_74342);
var inst_74398 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74397], 0));
var inst_74399 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Received message:",inst_74398], 0));
var inst_74400 = fluree.db.util.json.parse(inst_74342);
var inst_74401 = fluree.db.conn_events.process_events(conn,inst_74400);
var inst_74331 = (0);
var state_74415__$1 = (function (){var statearr_74435 = state_74415;
(statearr_74435[(13)] = inst_74401);

(statearr_74435[(8)] = inst_74331);

(statearr_74435[(14)] = inst_74399);

return statearr_74435;
})();
var statearr_74436_74482 = state_74415__$1;
(statearr_74436_74482[(2)] = null);

(statearr_74436_74482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (6))){
var inst_74342 = (state_74415[(9)]);
var inst_74387 = (inst_74342 == null);
var state_74415__$1 = state_74415;
if(cljs.core.truth_(inst_74387)){
var statearr_74437_74483 = state_74415__$1;
(statearr_74437_74483[(1)] = (23));

} else {
var statearr_74438_74484 = state_74415__$1;
(statearr_74438_74484[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (28))){
var inst_74407 = (state_74415[(2)]);
var state_74415__$1 = state_74415;
var statearr_74439_74485 = state_74415__$1;
(statearr_74439_74485[(2)] = inst_74407);

(statearr_74439_74485[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (25))){
var inst_74409 = (state_74415[(2)]);
var state_74415__$1 = state_74415;
var statearr_74440_74486 = state_74415__$1;
(statearr_74440_74486[(2)] = inst_74409);

(statearr_74440_74486[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (17))){
var inst_74349 = (state_74415[(7)]);
var inst_74360 = cljs.core.eval(inst_74349);
var state_74415__$1 = state_74415;
var statearr_74441_74487 = state_74415__$1;
(statearr_74441_74487[(2)] = inst_74360);

(statearr_74441_74487[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (3))){
var inst_74413 = (state_74415[(2)]);
var state_74415__$1 = state_74415;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74415__$1,inst_74413);
} else {
if((state_val_74416 === (12))){
var inst_74349 = (state_74415[(7)]);
var inst_74354 = cljs.core.fn_QMARK_(inst_74349);
var state_74415__$1 = state_74415;
if(inst_74354){
var statearr_74442_74488 = state_74415__$1;
(statearr_74442_74488[(1)] = (14));

} else {
var statearr_74443_74489 = state_74415__$1;
(statearr_74443_74489[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (2))){
var inst_74336 = (state_74415[(10)]);
var inst_74336__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_74337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74338 = [sub_chan,inst_74336__$1];
var inst_74339 = (new cljs.core.PersistentVector(null,2,(5),inst_74337,inst_74338,null));
var state_74415__$1 = (function (){var statearr_74444 = state_74415;
(statearr_74444[(10)] = inst_74336__$1);

return statearr_74444;
})();
return cljs.core.async.ioc_alts_BANG_(state_74415__$1,(4),inst_74339);
} else {
if((state_val_74416 === (23))){
var inst_74389 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_74415__$1 = state_74415;
var statearr_74445_74490 = state_74415__$1;
(statearr_74445_74490[(2)] = inst_74389);

(statearr_74445_74490[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (19))){
var inst_74371 = (state_74415[(2)]);
var state_74415__$1 = state_74415;
var statearr_74446_74491 = state_74415__$1;
(statearr_74446_74491[(2)] = inst_74371);

(statearr_74446_74491[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (11))){
var inst_74352 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_74415__$1 = state_74415;
var statearr_74447_74492 = state_74415__$1;
(statearr_74447_74492[(2)] = inst_74352);

(statearr_74447_74492[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (9))){
var inst_74331 = (state_74415[(8)]);
var inst_74381 = fluree.db.connection.ping_transactor(conn);
var inst_74382 = (inst_74331 + (1));
var inst_74331__$1 = inst_74382;
var state_74415__$1 = (function (){var statearr_74448 = state_74415;
(statearr_74448[(15)] = inst_74381);

(statearr_74448[(8)] = inst_74331__$1);

return statearr_74448;
})();
var statearr_74449_74493 = state_74415__$1;
(statearr_74449_74493[(2)] = null);

(statearr_74449_74493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (5))){
var inst_74331 = (state_74415[(8)]);
var inst_74346 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_74331);
var state_74415__$1 = state_74415;
if(inst_74346){
var statearr_74450_74494 = state_74415__$1;
(statearr_74450_74494[(1)] = (8));

} else {
var statearr_74451_74495 = state_74415__$1;
(statearr_74451_74495[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (14))){
var inst_74349 = (state_74415[(7)]);
var inst_74356 = (inst_74349.cljs$core$IFn$_invoke$arity$0 ? inst_74349.cljs$core$IFn$_invoke$arity$0() : inst_74349.call(null));
var state_74415__$1 = state_74415;
var statearr_74452_74496 = state_74415__$1;
(statearr_74452_74496[(2)] = inst_74356);

(statearr_74452_74496[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (26))){
var inst_74342 = (state_74415[(9)]);
var inst_74393 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74342], 0));
var inst_74331 = (0);
var state_74415__$1 = (function (){var statearr_74453 = state_74415;
(statearr_74453[(8)] = inst_74331);

(statearr_74453[(16)] = inst_74393);

return statearr_74453;
})();
var statearr_74454_74497 = state_74415__$1;
(statearr_74454_74497[(2)] = null);

(statearr_74454_74497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (16))){
var inst_74373 = (state_74415[(2)]);
var state_74415__$1 = state_74415;
var statearr_74455_74498 = state_74415__$1;
(statearr_74455_74498[(2)] = inst_74373);

(statearr_74455_74498[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (30))){
var state_74415__$1 = state_74415;
var statearr_74456_74499 = state_74415__$1;
(statearr_74456_74499[(2)] = null);

(statearr_74456_74499[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (10))){
var inst_74385 = (state_74415[(2)]);
var state_74415__$1 = state_74415;
var statearr_74457_74500 = state_74415__$1;
(statearr_74457_74500[(2)] = inst_74385);

(statearr_74457_74500[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (18))){
var state_74415__$1 = state_74415;
var statearr_74458_74501 = state_74415__$1;
(statearr_74458_74501[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74416 === (8))){
var inst_74349 = (state_74415[(7)]);
var inst_74348 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_74349__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74350 = (inst_74349__$1 == null);
var state_74415__$1 = (function (){var statearr_74460 = state_74415;
(statearr_74460[(7)] = inst_74349__$1);

(statearr_74460[(17)] = inst_74348);

return statearr_74460;
})();
if(cljs.core.truth_(inst_74350)){
var statearr_74461_74502 = state_74415__$1;
(statearr_74461_74502[(1)] = (11));

} else {
var statearr_74462_74503 = state_74415__$1;
(statearr_74462_74503[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__11438__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__11438__auto____0 = (function (){
var statearr_74463 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74463[(0)] = fluree$db$connection$msg_consumer_$_state_machine__11438__auto__);

(statearr_74463[(1)] = (1));

return statearr_74463;
});
var fluree$db$connection$msg_consumer_$_state_machine__11438__auto____1 = (function (state_74415){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_74415);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e74464){var ex__11441__auto__ = e74464;
var statearr_74465_74504 = state_74415;
(statearr_74465_74504[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_74415[(4)]))){
var statearr_74466_74505 = state_74415;
(statearr_74466_74505[(1)] = cljs.core.first((state_74415[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74506 = state_74415;
state_74415 = G__74506;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__11438__auto__ = function(state_74415){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__11438__auto____1.call(this,state_74415);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__11438__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__11438__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_74467 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_74467[(6)] = c__11512__auto__);

return statearr_74467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__74508 = arguments.length;
switch (G__74508) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__74509 = opts;
var map__74509__$1 = cljs.core.__destructure_map(map__74509);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74509__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74509__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_74561){
var state_val_74562 = (state_74561[(1)]);
if((state_val_74562 === (7))){
var inst_74519 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_74520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74521 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_74522 = (new cljs.core.PersistentVector(null,2,(5),inst_74520,inst_74521,null));
var inst_74523 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_74519,inst_74522);
var state_74561__$1 = state_74561;
var statearr_74563_74594 = state_74561__$1;
(statearr_74563_74594[(2)] = inst_74523);

(statearr_74563_74594[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74562 === (1))){
var state_74561__$1 = state_74561;
var statearr_74564_74595 = state_74561__$1;
(statearr_74564_74595[(2)] = null);

(statearr_74564_74595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74562 === (4))){
var inst_74510 = (state_74561[(2)]);
var state_74561__$1 = state_74561;
var statearr_74565_74596 = state_74561__$1;
(statearr_74565_74596[(2)] = inst_74510);

(statearr_74565_74596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74562 === (15))){
var inst_74530 = (state_74561[(7)]);
var inst_74549 = (state_74561[(2)]);
var inst_74550 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_74551 = [(5000),inst_74549,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_74552 = cljs.core.PersistentHashMap.fromArrays(inst_74550,inst_74551);
var inst_74553 = fluree.db.util.xhttp.get(inst_74530,inst_74552);
var state_74561__$1 = state_74561;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74561__$1,(16),inst_74553);
} else {
if((state_val_74562 === (13))){
var inst_74540 = (state_74561[(8)]);
var inst_74530 = (state_74561[(7)]);
var inst_74542 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_74543 = [inst_74540];
var inst_74544 = cljs.core.PersistentHashMap.fromArrays(inst_74542,inst_74543);
var inst_74545 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_74530,inst_74544,private$);
var inst_74546 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_74545);
var state_74561__$1 = state_74561;
var statearr_74566_74597 = state_74561__$1;
(statearr_74566_74597[(2)] = inst_74546);

(statearr_74566_74597[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74562 === (6))){
var inst_74516 = (state_74561[(9)]);
var state_74561__$1 = state_74561;
var statearr_74567_74598 = state_74561__$1;
(statearr_74567_74598[(2)] = inst_74516);

(statearr_74567_74598[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74562 === (3))){
var inst_74559 = (state_74561[(2)]);
var state_74561__$1 = state_74561;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74561__$1,inst_74559);
} else {
if((state_val_74562 === (12))){
var inst_74540 = (state_74561[(2)]);
var state_74561__$1 = (function (){var statearr_74568 = state_74561;
(statearr_74568[(8)] = inst_74540);

return statearr_74568;
})();
if(cljs.core.truth_(private$)){
var statearr_74569_74599 = state_74561__$1;
(statearr_74569_74599[(1)] = (13));

} else {
var statearr_74570_74600 = state_74561__$1;
(statearr_74570_74600[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74562 === (2))){
var inst_74516 = (state_74561[(9)]);
var _ = (function (){var statearr_74571 = state_74561;
(statearr_74571[(4)] = cljs.core.cons((5),(state_74561[(4)])));

return statearr_74571;
})();
var inst_74516__$1 = jwt;
var state_74561__$1 = (function (){var statearr_74572 = state_74561;
(statearr_74572[(9)] = inst_74516__$1);

return statearr_74572;
})();
if(cljs.core.truth_(inst_74516__$1)){
var statearr_74573_74601 = state_74561__$1;
(statearr_74573_74601[(1)] = (6));

} else {
var statearr_74574_74602 = state_74561__$1;
(statearr_74574_74602[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74562 === (11))){
var inst_74534 = (state_74561[(10)]);
var state_74561__$1 = state_74561;
var statearr_74576_74603 = state_74561__$1;
(statearr_74576_74603[(2)] = inst_74534);

(statearr_74576_74603[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74562 === (9))){
var inst_74525 = (state_74561[(11)]);
var inst_74526 = (state_74561[(12)]);
var inst_74529 = (state_74561[(2)]);
var inst_74530 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74529),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74526)].join('');
var inst_74532 = ["Accept"];
var inst_74533 = ["application/json"];
var inst_74534 = cljs.core.PersistentHashMap.fromArrays(inst_74532,inst_74533);
var state_74561__$1 = (function (){var statearr_74577 = state_74561;
(statearr_74577[(10)] = inst_74534);

(statearr_74577[(7)] = inst_74530);

return statearr_74577;
})();
if(cljs.core.truth_(inst_74525)){
var statearr_74578_74604 = state_74561__$1;
(statearr_74578_74604[(1)] = (10));

} else {
var statearr_74579_74605 = state_74561__$1;
(statearr_74579_74605[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74562 === (5))){
var _ = (function (){var statearr_74580 = state_74561;
(statearr_74580[(4)] = cljs.core.rest((state_74561[(4)])));

return statearr_74580;
})();
var state_74561__$1 = state_74561;
var ex74575 = (state_74561__$1[(2)]);
var statearr_74581_74606 = state_74561__$1;
(statearr_74581_74606[(5)] = ex74575);


if((ex74575 instanceof Error)){
var statearr_74582_74607 = state_74561__$1;
(statearr_74582_74607[(1)] = (4));

(statearr_74582_74607[(5)] = null);

} else {
throw ex74575;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74562 === (14))){
var inst_74540 = (state_74561[(8)]);
var state_74561__$1 = state_74561;
var statearr_74583_74608 = state_74561__$1;
(statearr_74583_74608[(2)] = inst_74540);

(statearr_74583_74608[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74562 === (16))){
var inst_74555 = (state_74561[(2)]);
var inst_74556 = fluree.db.util.async.throw_err(inst_74555);
var _ = (function (){var statearr_74584 = state_74561;
(statearr_74584[(4)] = cljs.core.rest((state_74561[(4)])));

return statearr_74584;
})();
var state_74561__$1 = state_74561;
var statearr_74585_74609 = state_74561__$1;
(statearr_74585_74609[(2)] = inst_74556);

(statearr_74585_74609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74562 === (10))){
var inst_74525 = (state_74561[(11)]);
var inst_74534 = (state_74561[(10)]);
var inst_74536 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74525)].join('');
var inst_74537 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74534,"Authorization",inst_74536);
var state_74561__$1 = state_74561;
var statearr_74586_74610 = state_74561__$1;
(statearr_74586_74610[(2)] = inst_74537);

(statearr_74586_74610[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74562 === (8))){
var inst_74525 = (state_74561[(2)]);
var inst_74526 = clojure.string.replace(k,"_","/");
var inst_74527 = fluree.db.connection.get_server(conn_id,servers);
var state_74561__$1 = (function (){var statearr_74587 = state_74561;
(statearr_74587[(11)] = inst_74525);

(statearr_74587[(12)] = inst_74526);

return statearr_74587;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74561__$1,(9),inst_74527);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__11438__auto__ = null;
var fluree$db$connection$state_machine__11438__auto____0 = (function (){
var statearr_74588 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74588[(0)] = fluree$db$connection$state_machine__11438__auto__);

(statearr_74588[(1)] = (1));

return statearr_74588;
});
var fluree$db$connection$state_machine__11438__auto____1 = (function (state_74561){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_74561);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e74589){var ex__11441__auto__ = e74589;
var statearr_74590_74611 = state_74561;
(statearr_74590_74611[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_74561[(4)]))){
var statearr_74591_74612 = state_74561;
(statearr_74591_74612[(1)] = cljs.core.first((state_74561[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74613 = state_74561;
state_74561 = G__74613;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$connection$state_machine__11438__auto__ = function(state_74561){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__11438__auto____1.call(this,state_74561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__11438__auto____0;
fluree$db$connection$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__11438__auto____1;
return fluree$db$connection$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_74592 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_74592[(6)] = c__11512__auto__);

return statearr_74592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__74614_SHARP_){
if(cljs.core.truth_(p1__74614_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__74615_SHARP_){
var or__5045__auto__ = p1__74615_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e74616){var e = e74616;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__74617 = opts;
var map__74617__$1 = cljs.core.__destructure_map(map__74617);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74617__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74617__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74617__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74617__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74617__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74617__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74617__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74617__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74617__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74617__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74617__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74617__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74617__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74617__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74617__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74617__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74617__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74617__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74617__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74617__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74617__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74617__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74617__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74617__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356)], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__74618_74619 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__74618_74619.cljs$core$IFn$_invoke$arity$0 ? fexpr__74618_74619.cljs$core$IFn$_invoke$arity$0() : fexpr__74618_74619.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5774__auto__ = [];
var len__5768__auto___74660 = arguments.length;
var i__5769__auto___74661 = (0);
while(true){
if((i__5769__auto___74661 < len__5768__auto___74660)){
args__5774__auto__.push((arguments[i__5769__auto___74661]));

var G__74662 = (i__5769__auto___74661 + (1));
i__5769__auto___74661 = G__74662;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__74622){
var vec__74623 = p__74622;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74623,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__11512__auto___74663 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_74643){
var state_val_74644 = (state_74643[(1)]);
if((state_val_74644 === (1))){
var inst_74626 = fluree.db.connection.get_socket(conn);
var state_74643__$1 = state_74643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74643__$1,(2),inst_74626);
} else {
if((state_val_74644 === (2))){
var inst_74629 = (state_74643[(7)]);
var inst_74628 = (state_74643[(8)]);
var inst_74628__$1 = (state_74643[(2)]);
var inst_74629__$1 = (inst_74628__$1 == null);
var state_74643__$1 = (function (){var statearr_74645 = state_74643;
(statearr_74645[(7)] = inst_74629__$1);

(statearr_74645[(8)] = inst_74628__$1);

return statearr_74645;
})();
if(cljs.core.truth_(inst_74629__$1)){
var statearr_74646_74664 = state_74643__$1;
(statearr_74646_74664[(1)] = (3));

} else {
var statearr_74647_74665 = state_74643__$1;
(statearr_74647_74665[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74644 === (3))){
var inst_74629 = (state_74643[(7)]);
var state_74643__$1 = state_74643;
var statearr_74648_74666 = state_74643__$1;
(statearr_74648_74666[(2)] = inst_74629);

(statearr_74648_74666[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74644 === (4))){
var inst_74628 = (state_74643[(8)]);
var inst_74632 = fluree.db.util.core.exception_QMARK_(inst_74628);
var state_74643__$1 = state_74643;
var statearr_74649_74667 = state_74643__$1;
(statearr_74649_74667[(2)] = inst_74632);

(statearr_74649_74667[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74644 === (5))){
var inst_74634 = (state_74643[(2)]);
var state_74643__$1 = state_74643;
if(cljs.core.truth_(inst_74634)){
var statearr_74650_74668 = state_74643__$1;
(statearr_74650_74668[(1)] = (6));

} else {
var statearr_74651_74669 = state_74643__$1;
(statearr_74651_74669[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74644 === (6))){
var inst_74628 = (state_74643[(8)]);
var inst_74636 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74628,"Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_74637 = cljs.core.async.close_BANG_(conn);
var state_74643__$1 = (function (){var statearr_74652 = state_74643;
(statearr_74652[(9)] = inst_74636);

return statearr_74652;
})();
var statearr_74653_74670 = state_74643__$1;
(statearr_74653_74670[(2)] = inst_74637);

(statearr_74653_74670[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74644 === (7))){
var inst_74639 = fluree.db.connection.msg_consumer(conn);
var state_74643__$1 = state_74643;
var statearr_74654_74671 = state_74643__$1;
(statearr_74654_74671[(2)] = inst_74639);

(statearr_74654_74671[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74644 === (8))){
var inst_74641 = (state_74643[(2)]);
var state_74643__$1 = state_74643;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74643__$1,inst_74641);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__11438__auto__ = null;
var fluree$db$connection$state_machine__11438__auto____0 = (function (){
var statearr_74655 = [null,null,null,null,null,null,null,null,null,null];
(statearr_74655[(0)] = fluree$db$connection$state_machine__11438__auto__);

(statearr_74655[(1)] = (1));

return statearr_74655;
});
var fluree$db$connection$state_machine__11438__auto____1 = (function (state_74643){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_74643);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e74656){var ex__11441__auto__ = e74656;
var statearr_74657_74672 = state_74643;
(statearr_74657_74672[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_74643[(4)]))){
var statearr_74658_74673 = state_74643;
(statearr_74658_74673[(1)] = cljs.core.first((state_74643[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74674 = state_74643;
state_74643 = G__74674;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$connection$state_machine__11438__auto__ = function(state_74643){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__11438__auto____1.call(this,state_74643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__11438__auto____0;
fluree$db$connection$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__11438__auto____1;
return fluree$db$connection$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_74659 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_74659[(6)] = c__11512__auto___74663);

return statearr_74659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq74620){
var G__74621 = cljs.core.first(seq74620);
var seq74620__$1 = cljs.core.next(seq74620);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74621,seq74620__$1);
}));

