// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__74685 = arguments.length;
switch (G__74685) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_74727){
var state_val_74728 = (state_74727[(1)]);
if((state_val_74728 === (7))){
var inst_74697 = typeof user === 'string';
var state_74727__$1 = state_74727;
if(cljs.core.truth_(inst_74697)){
var statearr_74729_74758 = state_74727__$1;
(statearr_74729_74758[(1)] = (9));

} else {
var statearr_74730_74759 = state_74727__$1;
(statearr_74730_74759[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74728 === (1))){
var state_74727__$1 = state_74727;
var statearr_74731_74760 = state_74727__$1;
(statearr_74731_74760[(2)] = null);

(statearr_74731_74760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74728 === (4))){
var inst_74686 = (state_74727[(2)]);
var inst_74687 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74686], 0));
var inst_74688 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_74686) : reject.call(null,inst_74686));
var state_74727__$1 = (function (){var statearr_74732 = state_74727;
(statearr_74732[(7)] = inst_74687);

return statearr_74732;
})();
var statearr_74733_74761 = state_74727__$1;
(statearr_74733_74761[(2)] = inst_74688);

(statearr_74733_74761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74728 === (15))){
var inst_74716 = (state_74727[(2)]);
var inst_74717 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_74716);
var inst_74718 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74719 = cljs.core.constantly(inst_74717);
var inst_74720 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74718,inst_74719);
var inst_74721 = fluree.db.connection.add_token(conn,inst_74717);
var inst_74722 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_74716) : resolve.call(null,inst_74716));
var _ = (function (){var statearr_74734 = state_74727;
(statearr_74734[(4)] = cljs.core.rest((state_74727[(4)])));

return statearr_74734;
})();
var state_74727__$1 = (function (){var statearr_74735 = state_74727;
(statearr_74735[(8)] = inst_74720);

(statearr_74735[(9)] = inst_74721);

return statearr_74735;
})();
var statearr_74736_74762 = state_74727__$1;
(statearr_74736_74762[(2)] = inst_74722);

(statearr_74736_74762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74728 === (13))){
var state_74727__$1 = state_74727;
var statearr_74737_74763 = state_74727__$1;
(statearr_74737_74763[(2)] = null);

(statearr_74737_74763[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74728 === (6))){
var state_74727__$1 = state_74727;
var statearr_74738_74764 = state_74727__$1;
(statearr_74738_74764[(2)] = user);

(statearr_74738_74764[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74728 === (3))){
var inst_74725 = (state_74727[(2)]);
var state_74727__$1 = state_74727;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74727__$1,inst_74725);
} else {
if((state_val_74728 === (12))){
var state_74727__$1 = state_74727;
var statearr_74739_74765 = state_74727__$1;
(statearr_74739_74765[(2)] = user);

(statearr_74739_74765[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74728 === (2))){
var _ = (function (){var statearr_74740 = state_74727;
(statearr_74740[(4)] = cljs.core.cons((5),(state_74727[(4)])));

return statearr_74740;
})();
var inst_74694 = typeof user === 'number';
var state_74727__$1 = state_74727;
if(cljs.core.truth_(inst_74694)){
var statearr_74741_74766 = state_74727__$1;
(statearr_74741_74766[(1)] = (6));

} else {
var statearr_74742_74767 = state_74727__$1;
(statearr_74742_74767[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74728 === (11))){
var inst_74708 = (state_74727[(2)]);
var state_74727__$1 = state_74727;
var statearr_74744_74768 = state_74727__$1;
(statearr_74744_74768[(2)] = inst_74708);

(statearr_74744_74768[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74728 === (9))){
var inst_74699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74700 = ["_user/username",user];
var inst_74701 = (new cljs.core.PersistentVector(null,2,(5),inst_74699,inst_74700,null));
var state_74727__$1 = state_74727;
var statearr_74745_74769 = state_74727__$1;
(statearr_74745_74769[(2)] = inst_74701);

(statearr_74745_74769[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74728 === (5))){
var _ = (function (){var statearr_74746 = state_74727;
(statearr_74746[(4)] = cljs.core.rest((state_74727[(4)])));

return statearr_74746;
})();
var state_74727__$1 = state_74727;
var ex74743 = (state_74727__$1[(2)]);
var statearr_74747_74770 = state_74727__$1;
(statearr_74747_74770[(5)] = ex74743);


var statearr_74748_74771 = state_74727__$1;
(statearr_74748_74771[(1)] = (4));

(statearr_74748_74771[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74728 === (14))){
var inst_74706 = (state_74727[(2)]);
var state_74727__$1 = state_74727;
var statearr_74749_74772 = state_74727__$1;
(statearr_74749_74772[(2)] = inst_74706);

(statearr_74749_74772[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74728 === (10))){
var state_74727__$1 = state_74727;
var statearr_74750_74773 = state_74727__$1;
(statearr_74750_74773[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74728 === (8))){
var inst_74710 = (state_74727[(2)]);
var inst_74711 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_74712 = [account,inst_74710,password,expireSeconds,syncTo];
var inst_74713 = cljs.core.PersistentHashMap.fromArrays(inst_74711,inst_74712);
var inst_74714 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_74713);
var state_74727__$1 = state_74727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74727__$1,(15),inst_74714);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__11438__auto__ = null;
var fluree$db$connection_js$state_machine__11438__auto____0 = (function (){
var statearr_74752 = [null,null,null,null,null,null,null,null,null,null];
(statearr_74752[(0)] = fluree$db$connection_js$state_machine__11438__auto__);

(statearr_74752[(1)] = (1));

return statearr_74752;
});
var fluree$db$connection_js$state_machine__11438__auto____1 = (function (state_74727){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_74727);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e74753){var ex__11441__auto__ = e74753;
var statearr_74754_74774 = state_74727;
(statearr_74754_74774[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_74727[(4)]))){
var statearr_74755_74775 = state_74727;
(statearr_74755_74775[(1)] = cljs.core.first((state_74727[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74776 = state_74727;
state_74727 = G__74776;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__11438__auto__ = function(state_74727){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__11438__auto____1.call(this,state_74727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__11438__auto____0;
fluree$db$connection_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__11438__auto____1;
return fluree$db$connection_js$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_74756 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_74756[(6)] = c__11512__auto__);

return statearr_74756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__74778 = arguments.length;
switch (G__74778) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_74787){
var state_val_74788 = (state_74787[(1)]);
if((state_val_74788 === (1))){
var inst_74779 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74781 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_74782 = (new cljs.core.PersistentVector(null,4,(5),inst_74780,inst_74781,null));
var inst_74783 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74779,inst_74782);
var inst_74784 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__74789 = cljs.core.seq(cljs.core.keys(x));
var chunk__74790 = null;
var count__74791 = (0);
var i__74792 = (0);
while(true){
if((i__74792 < count__74791)){
var k = chunk__74790.cljs$core$IIndexed$_nth$arity$2(null,i__74792);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__74800 = seq__74789;
var G__74801 = chunk__74790;
var G__74802 = count__74791;
var G__74803 = (i__74792 + (1));
seq__74789 = G__74800;
chunk__74790 = G__74801;
count__74791 = G__74802;
i__74792 = G__74803;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__74789);
if(temp__5804__auto__){
var seq__74789__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__74789__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__74789__$1);
var G__74804 = cljs.core.chunk_rest(seq__74789__$1);
var G__74805 = c__5567__auto__;
var G__74806 = cljs.core.count(c__5567__auto__);
var G__74807 = (0);
seq__74789 = G__74804;
chunk__74790 = G__74805;
count__74791 = G__74806;
i__74792 = G__74807;
continue;
} else {
var k = cljs.core.first(seq__74789__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__74808 = cljs.core.next(seq__74789__$1);
var G__74809 = null;
var G__74810 = (0);
var G__74811 = (0);
seq__74789 = G__74808;
chunk__74790 = G__74809;
count__74791 = G__74810;
i__74792 = G__74811;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_74785 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_74784);
var state_74787__$1 = (function (){var statearr_74793 = state_74787;
(statearr_74793[(7)] = inst_74783);

return statearr_74793;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_74787__$1,inst_74785);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__11438__auto__ = null;
var fluree$db$connection_js$state_machine__11438__auto____0 = (function (){
var statearr_74794 = [null,null,null,null,null,null,null,null];
(statearr_74794[(0)] = fluree$db$connection_js$state_machine__11438__auto__);

(statearr_74794[(1)] = (1));

return statearr_74794;
});
var fluree$db$connection_js$state_machine__11438__auto____1 = (function (state_74787){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_74787);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e74795){var ex__11441__auto__ = e74795;
var statearr_74796_74812 = state_74787;
(statearr_74796_74812[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_74787[(4)]))){
var statearr_74797_74813 = state_74787;
(statearr_74797_74813[(1)] = cljs.core.first((state_74787[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74814 = state_74787;
state_74787 = G__74814;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__11438__auto__ = function(state_74787){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__11438__auto____1.call(this,state_74787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__11438__auto____0;
fluree$db$connection_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__11438__auto____1;
return fluree$db$connection_js$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_74798 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_74798[(6)] = c__11512__auto__);

return statearr_74798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__74816 = arguments.length;
switch (G__74816) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_74850){
var state_val_74851 = (state_74850[(1)]);
if((state_val_74851 === (1))){
var state_74850__$1 = state_74850;
var statearr_74852_74873 = state_74850__$1;
(statearr_74852_74873[(2)] = null);

(statearr_74852_74873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74851 === (2))){
var _ = (function (){var statearr_74853 = state_74850;
(statearr_74853[(4)] = cljs.core.cons((5),(state_74850[(4)])));

return statearr_74853;
})();
var inst_74825 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_74826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74827 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_74828 = (new cljs.core.PersistentVector(null,1,(5),inst_74826,inst_74827,null));
var inst_74829 = cljs.core.PersistentHashMap.EMPTY;
var inst_74830 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_74829);
var inst_74831 = cljs.core.assoc_in(inst_74825,inst_74828,inst_74830);
var inst_74832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74833 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_74834 = (new cljs.core.PersistentVector(null,1,(5),inst_74832,inst_74833,null));
var inst_74835 = cljs.core.PersistentHashMap.EMPTY;
var inst_74836 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_74835);
var inst_74837 = cljs.core.assoc_in(inst_74831,inst_74834,inst_74836);
var inst_74838 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_74839 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_74837);
var inst_74840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74841 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_74838,null];
var inst_74842 = (new cljs.core.PersistentVector(null,4,(5),inst_74840,inst_74841,null));
var inst_74843 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74839,inst_74842);
var inst_74844 = (function (){var conn = inst_74837;
var pc = inst_74838;
return (function (x){
if((x == null)){
} else {
var seq__74854_74874 = cljs.core.seq(cljs.core.keys(x));
var chunk__74855_74875 = null;
var count__74856_74876 = (0);
var i__74857_74877 = (0);
while(true){
if((i__74857_74877 < count__74856_74876)){
var k_74878 = chunk__74855_74875.cljs$core$IIndexed$_nth$arity$2(null,i__74857_74877);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_74878], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_74878,null));


var G__74879 = seq__74854_74874;
var G__74880 = chunk__74855_74875;
var G__74881 = count__74856_74876;
var G__74882 = (i__74857_74877 + (1));
seq__74854_74874 = G__74879;
chunk__74855_74875 = G__74880;
count__74856_74876 = G__74881;
i__74857_74877 = G__74882;
continue;
} else {
var temp__5804__auto___74883 = cljs.core.seq(seq__74854_74874);
if(temp__5804__auto___74883){
var seq__74854_74884__$1 = temp__5804__auto___74883;
if(cljs.core.chunked_seq_QMARK_(seq__74854_74884__$1)){
var c__5567__auto___74885 = cljs.core.chunk_first(seq__74854_74884__$1);
var G__74886 = cljs.core.chunk_rest(seq__74854_74884__$1);
var G__74887 = c__5567__auto___74885;
var G__74888 = cljs.core.count(c__5567__auto___74885);
var G__74889 = (0);
seq__74854_74874 = G__74886;
chunk__74855_74875 = G__74887;
count__74856_74876 = G__74888;
i__74857_74877 = G__74889;
continue;
} else {
var k_74890 = cljs.core.first(seq__74854_74884__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_74890], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_74890,null));


var G__74891 = cljs.core.next(seq__74854_74884__$1);
var G__74892 = null;
var G__74893 = (0);
var G__74894 = (0);
seq__74854_74874 = G__74891;
chunk__74855_74875 = G__74892;
count__74856_74876 = G__74893;
i__74857_74877 = G__74894;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_74845 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74838,inst_74844);
var ___$1 = (function (){var statearr_74858 = state_74850;
(statearr_74858[(4)] = cljs.core.rest((state_74850[(4)])));

return statearr_74858;
})();
var state_74850__$1 = (function (){var statearr_74859 = state_74850;
(statearr_74859[(7)] = inst_74843);

return statearr_74859;
})();
var statearr_74860_74895 = state_74850__$1;
(statearr_74860_74895[(2)] = inst_74845);

(statearr_74860_74895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74851 === (3))){
var inst_74848 = (state_74850[(2)]);
var state_74850__$1 = state_74850;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74850__$1,inst_74848);
} else {
if((state_val_74851 === (4))){
var inst_74817 = (state_74850[(2)]);
var inst_74818 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74817], 0));
var inst_74819 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_74817) : reject.call(null,inst_74817));
var state_74850__$1 = (function (){var statearr_74862 = state_74850;
(statearr_74862[(8)] = inst_74818);

return statearr_74862;
})();
var statearr_74863_74896 = state_74850__$1;
(statearr_74863_74896[(2)] = inst_74819);

(statearr_74863_74896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74851 === (5))){
var _ = (function (){var statearr_74864 = state_74850;
(statearr_74864[(4)] = cljs.core.rest((state_74850[(4)])));

return statearr_74864;
})();
var state_74850__$1 = state_74850;
var ex74861 = (state_74850__$1[(2)]);
var statearr_74865_74897 = state_74850__$1;
(statearr_74865_74897[(5)] = ex74861);


var statearr_74866_74898 = state_74850__$1;
(statearr_74866_74898[(1)] = (4));

(statearr_74866_74898[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__11438__auto__ = null;
var fluree$db$connection_js$state_machine__11438__auto____0 = (function (){
var statearr_74867 = [null,null,null,null,null,null,null,null,null];
(statearr_74867[(0)] = fluree$db$connection_js$state_machine__11438__auto__);

(statearr_74867[(1)] = (1));

return statearr_74867;
});
var fluree$db$connection_js$state_machine__11438__auto____1 = (function (state_74850){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_74850);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e74868){var ex__11441__auto__ = e74868;
var statearr_74869_74899 = state_74850;
(statearr_74869_74899[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_74850[(4)]))){
var statearr_74870_74900 = state_74850;
(statearr_74870_74900[(1)] = cljs.core.first((state_74850[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74901 = state_74850;
state_74850 = G__74901;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__11438__auto__ = function(state_74850){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__11438__auto____1.call(this,state_74850);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__11438__auto____0;
fluree$db$connection_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__11438__auto____1;
return fluree$db$connection_js$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_74871 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_74871[(6)] = c__11512__auto__);

return statearr_74871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__74903 = arguments.length;
switch (G__74903) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__74905 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74905,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74905,(1),null);
var cb_STAR_ = (function (header,data){
var G__74908 = cljs.core.clj__GT_js(header);
var G__74909 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__74908,G__74909) : callback.call(null,G__74908,G__74909));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__74910 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74910,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74910,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_74963){
var state_val_74964 = (state_74963[(1)]);
if((state_val_74964 === (7))){
var inst_74924 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74925 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_74926 = cljs.core.PersistentHashMap.fromArrays(inst_74924,inst_74925);
var inst_74927 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_74926);
var inst_74928 = (function(){throw inst_74927})();
var state_74963__$1 = state_74963;
var statearr_74965_74997 = state_74963__$1;
(statearr_74965_74997[(2)] = inst_74928);

(statearr_74965_74997[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (1))){
var state_74963__$1 = state_74963;
var statearr_74966_74998 = state_74963__$1;
(statearr_74966_74998[(2)] = null);

(statearr_74966_74998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (4))){
var inst_74913 = (state_74963[(2)]);
var inst_74914 = cljs.core.clj__GT_js(inst_74913);
var inst_74915 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_74914) : reject.call(null,inst_74914));
var state_74963__$1 = state_74963;
var statearr_74967_74999 = state_74963__$1;
(statearr_74967_74999[(2)] = inst_74915);

(statearr_74967_74999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (13))){
var inst_74942 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74943 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_74944 = cljs.core.PersistentHashMap.fromArrays(inst_74942,inst_74943);
var inst_74945 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_74944);
var inst_74946 = (function(){throw inst_74945})();
var state_74963__$1 = state_74963;
var statearr_74968_75000 = state_74963__$1;
(statearr_74968_75000[(2)] = inst_74946);

(statearr_74968_75000[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (6))){
var state_74963__$1 = state_74963;
var statearr_74969_75001 = state_74963__$1;
(statearr_74969_75001[(2)] = null);

(statearr_74969_75001[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (3))){
var inst_74961 = (state_74963[(2)]);
var state_74963__$1 = state_74963;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74963__$1,inst_74961);
} else {
if((state_val_74964 === (12))){
var state_74963__$1 = state_74963;
var statearr_74970_75002 = state_74963__$1;
(statearr_74970_75002[(2)] = null);

(statearr_74970_75002[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (2))){
var _ = (function (){var statearr_74971 = state_74963;
(statearr_74971[(4)] = cljs.core.cons((5),(state_74963[(4)])));

return statearr_74971;
})();
var inst_74921 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_74963__$1 = state_74963;
if(cljs.core.truth_(inst_74921)){
var statearr_74972_75003 = state_74963__$1;
(statearr_74972_75003[(1)] = (6));

} else {
var statearr_74973_75004 = state_74963__$1;
(statearr_74973_75004[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (11))){
var inst_74939 = (state_74963[(2)]);
var state_74963__$1 = (function (){var statearr_74975 = state_74963;
(statearr_74975[(7)] = inst_74939);

return statearr_74975;
})();
if(cljs.core.truth_(password)){
var statearr_74976_75005 = state_74963__$1;
(statearr_74976_75005[(1)] = (12));

} else {
var statearr_74977_75006 = state_74963__$1;
(statearr_74977_75006[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (9))){
var state_74963__$1 = state_74963;
var statearr_74978_75007 = state_74963__$1;
(statearr_74978_75007[(2)] = null);

(statearr_74978_75007[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (5))){
var _ = (function (){var statearr_74979 = state_74963;
(statearr_74979[(4)] = cljs.core.rest((state_74963[(4)])));

return statearr_74979;
})();
var state_74963__$1 = state_74963;
var ex74974 = (state_74963__$1[(2)]);
var statearr_74980_75008 = state_74963__$1;
(statearr_74980_75008[(5)] = ex74974);


var statearr_74981_75009 = state_74963__$1;
(statearr_74981_75009[(1)] = (4));

(statearr_74981_75009[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (14))){
var inst_74948 = (state_74963[(2)]);
var inst_74949 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_74950 = fluree.db.util.core.without_nils(inst_74949);
var inst_74951 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_74952 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74954 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_74950,inst_74951,null];
var inst_74955 = (new cljs.core.PersistentVector(null,4,(5),inst_74953,inst_74954,null));
var inst_74956 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74952,inst_74955);
var inst_74957 = (function (){var _ = inst_74948;
var data = inst_74950;
var pc = inst_74951;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__74982 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__74982) : reject.call(null,G__74982));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__74983 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__74983) : reject.call(null,G__74983));
} else {
var G__74984 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__74984) : resolve.call(null,G__74984));

}
}
});
})();
var inst_74958 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74951,inst_74957);
var _ = (function (){var statearr_74985 = state_74963;
(statearr_74985[(4)] = cljs.core.rest((state_74963[(4)])));

return statearr_74985;
})();
var state_74963__$1 = (function (){var statearr_74986 = state_74963;
(statearr_74986[(8)] = inst_74956);

return statearr_74986;
})();
var statearr_74987_75010 = state_74963__$1;
(statearr_74987_75010[(2)] = inst_74958);

(statearr_74987_75010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (10))){
var inst_74933 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74934 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_74935 = cljs.core.PersistentHashMap.fromArrays(inst_74933,inst_74934);
var inst_74936 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_74935);
var inst_74937 = (function(){throw inst_74936})();
var state_74963__$1 = state_74963;
var statearr_74988_75011 = state_74963__$1;
(statearr_74988_75011[(2)] = inst_74937);

(statearr_74988_75011[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (8))){
var inst_74930 = (state_74963[(2)]);
var state_74963__$1 = (function (){var statearr_74989 = state_74963;
(statearr_74989[(9)] = inst_74930);

return statearr_74989;
})();
if(cljs.core.truth_(ledger)){
var statearr_74990_75012 = state_74963__$1;
(statearr_74990_75012[(1)] = (9));

} else {
var statearr_74991_75013 = state_74963__$1;
(statearr_74991_75013[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__11438__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__11438__auto____0 = (function (){
var statearr_74992 = [null,null,null,null,null,null,null,null,null,null];
(statearr_74992[(0)] = fluree$db$connection_js$password_generate_$_state_machine__11438__auto__);

(statearr_74992[(1)] = (1));

return statearr_74992;
});
var fluree$db$connection_js$password_generate_$_state_machine__11438__auto____1 = (function (state_74963){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_74963);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e74993){var ex__11441__auto__ = e74993;
var statearr_74994_75014 = state_74963;
(statearr_74994_75014[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_74963[(4)]))){
var statearr_74995_75015 = state_74963;
(statearr_74995_75015[(1)] = cljs.core.first((state_74963[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75016 = state_74963;
state_74963 = G__75016;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__11438__auto__ = function(state_74963){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__11438__auto____1.call(this,state_74963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__11438__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__11438__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_74996 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_74996[(6)] = c__11512__auto__);

return statearr_74996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__75018 = arguments.length;
switch (G__75018) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_75085){
var state_val_75086 = (state_75085[(1)]);
if((state_val_75086 === (7))){
var inst_75030 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75031 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_75032 = cljs.core.PersistentHashMap.fromArrays(inst_75030,inst_75031);
var inst_75033 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_75032);
var inst_75034 = (function(){throw inst_75033})();
var state_75085__$1 = state_75085;
var statearr_75087_75129 = state_75085__$1;
(statearr_75087_75129[(2)] = inst_75034);

(statearr_75087_75129[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (20))){
var inst_75068 = (state_75085[(2)]);
var inst_75069 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_75070 = [ledger,password,user,auth,expire];
var inst_75071 = cljs.core.PersistentHashMap.fromArrays(inst_75069,inst_75070);
var inst_75072 = fluree.db.util.core.without_nils(inst_75071);
var inst_75073 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_75074 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_75075 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75076 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_75072,inst_75073,null];
var inst_75077 = (new cljs.core.PersistentVector(null,4,(5),inst_75075,inst_75076,null));
var inst_75078 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_75074,inst_75077);
var inst_75079 = (function (){var _ = inst_75068;
var data = inst_75072;
var pc = inst_75073;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__75088 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__75088) : reject.call(null,G__75088));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__75089 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__75089) : reject.call(null,G__75089));
} else {
fluree.db.connection.add_token(conn,result);

var G__75090 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__75090) : resolve.call(null,G__75090));

}
}
});
})();
var inst_75080 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_75073,inst_75079);
var _ = (function (){var statearr_75091 = state_75085;
(statearr_75091[(4)] = cljs.core.rest((state_75085[(4)])));

return statearr_75091;
})();
var state_75085__$1 = (function (){var statearr_75092 = state_75085;
(statearr_75092[(7)] = inst_75078);

return statearr_75092;
})();
var statearr_75093_75130 = state_75085__$1;
(statearr_75093_75130[(2)] = inst_75080);

(statearr_75093_75130[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (1))){
var state_75085__$1 = state_75085;
var statearr_75094_75131 = state_75085__$1;
(statearr_75094_75131[(2)] = null);

(statearr_75094_75131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (4))){
var inst_75019 = (state_75085[(2)]);
var inst_75020 = cljs.core.clj__GT_js(inst_75019);
var inst_75021 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_75020) : reject.call(null,inst_75020));
var state_75085__$1 = state_75085;
var statearr_75095_75132 = state_75085__$1;
(statearr_75095_75132[(2)] = inst_75021);

(statearr_75095_75132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (15))){
var inst_75055 = (state_75085[(8)]);
var state_75085__$1 = state_75085;
var statearr_75096_75133 = state_75085__$1;
(statearr_75096_75133[(2)] = inst_75055);

(statearr_75096_75133[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (13))){
var inst_75048 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75049 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_75050 = cljs.core.PersistentHashMap.fromArrays(inst_75048,inst_75049);
var inst_75051 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_75050);
var inst_75052 = (function(){throw inst_75051})();
var state_75085__$1 = state_75085;
var statearr_75097_75134 = state_75085__$1;
(statearr_75097_75134[(2)] = inst_75052);

(statearr_75097_75134[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (6))){
var state_75085__$1 = state_75085;
var statearr_75098_75135 = state_75085__$1;
(statearr_75098_75135[(2)] = null);

(statearr_75098_75135[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (17))){
var inst_75059 = (state_75085[(2)]);
var state_75085__$1 = state_75085;
if(cljs.core.truth_(inst_75059)){
var statearr_75099_75136 = state_75085__$1;
(statearr_75099_75136[(1)] = (18));

} else {
var statearr_75100_75137 = state_75085__$1;
(statearr_75100_75137[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (3))){
var inst_75083 = (state_75085[(2)]);
var state_75085__$1 = state_75085;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75085__$1,inst_75083);
} else {
if((state_val_75086 === (12))){
var state_75085__$1 = state_75085;
var statearr_75101_75138 = state_75085__$1;
(statearr_75101_75138[(2)] = null);

(statearr_75101_75138[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (2))){
var _ = (function (){var statearr_75102 = state_75085;
(statearr_75102[(4)] = cljs.core.cons((5),(state_75085[(4)])));

return statearr_75102;
})();
var inst_75027 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_75085__$1 = state_75085;
if(cljs.core.truth_(inst_75027)){
var statearr_75103_75139 = state_75085__$1;
(statearr_75103_75139[(1)] = (6));

} else {
var statearr_75104_75140 = state_75085__$1;
(statearr_75104_75140[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (19))){
var inst_75062 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75063 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_75064 = cljs.core.PersistentHashMap.fromArrays(inst_75062,inst_75063);
var inst_75065 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_75064);
var inst_75066 = (function(){throw inst_75065})();
var state_75085__$1 = state_75085;
var statearr_75105_75141 = state_75085__$1;
(statearr_75105_75141[(2)] = inst_75066);

(statearr_75105_75141[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (11))){
var inst_75045 = (state_75085[(2)]);
var state_75085__$1 = (function (){var statearr_75107 = state_75085;
(statearr_75107[(9)] = inst_75045);

return statearr_75107;
})();
if(cljs.core.truth_(password)){
var statearr_75108_75142 = state_75085__$1;
(statearr_75108_75142[(1)] = (12));

} else {
var statearr_75109_75143 = state_75085__$1;
(statearr_75109_75143[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (9))){
var state_75085__$1 = state_75085;
var statearr_75110_75144 = state_75085__$1;
(statearr_75110_75144[(2)] = null);

(statearr_75110_75144[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (5))){
var _ = (function (){var statearr_75111 = state_75085;
(statearr_75111[(4)] = cljs.core.rest((state_75085[(4)])));

return statearr_75111;
})();
var state_75085__$1 = state_75085;
var ex75106 = (state_75085__$1[(2)]);
var statearr_75112_75145 = state_75085__$1;
(statearr_75112_75145[(5)] = ex75106);


var statearr_75113_75146 = state_75085__$1;
(statearr_75113_75146[(1)] = (4));

(statearr_75113_75146[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (14))){
var inst_75055 = (state_75085[(8)]);
var inst_75054 = (state_75085[(2)]);
var inst_75055__$1 = user;
var state_75085__$1 = (function (){var statearr_75114 = state_75085;
(statearr_75114[(10)] = inst_75054);

(statearr_75114[(8)] = inst_75055__$1);

return statearr_75114;
})();
if(cljs.core.truth_(inst_75055__$1)){
var statearr_75115_75147 = state_75085__$1;
(statearr_75115_75147[(1)] = (15));

} else {
var statearr_75116_75148 = state_75085__$1;
(statearr_75116_75148[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (16))){
var state_75085__$1 = state_75085;
var statearr_75117_75149 = state_75085__$1;
(statearr_75117_75149[(2)] = auth);

(statearr_75117_75149[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (10))){
var inst_75039 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75040 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_75041 = cljs.core.PersistentHashMap.fromArrays(inst_75039,inst_75040);
var inst_75042 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_75041);
var inst_75043 = (function(){throw inst_75042})();
var state_75085__$1 = state_75085;
var statearr_75118_75150 = state_75085__$1;
(statearr_75118_75150[(2)] = inst_75043);

(statearr_75118_75150[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (18))){
var state_75085__$1 = state_75085;
var statearr_75119_75151 = state_75085__$1;
(statearr_75119_75151[(2)] = null);

(statearr_75119_75151[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75086 === (8))){
var inst_75036 = (state_75085[(2)]);
var state_75085__$1 = (function (){var statearr_75120 = state_75085;
(statearr_75120[(11)] = inst_75036);

return statearr_75120;
})();
if(cljs.core.truth_(ledger)){
var statearr_75121_75152 = state_75085__$1;
(statearr_75121_75152[(1)] = (9));

} else {
var statearr_75122_75153 = state_75085__$1;
(statearr_75122_75153[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__11438__auto__ = null;
var fluree$db$connection_js$state_machine__11438__auto____0 = (function (){
var statearr_75123 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75123[(0)] = fluree$db$connection_js$state_machine__11438__auto__);

(statearr_75123[(1)] = (1));

return statearr_75123;
});
var fluree$db$connection_js$state_machine__11438__auto____1 = (function (state_75085){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_75085);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e75124){var ex__11441__auto__ = e75124;
var statearr_75125_75154 = state_75085;
(statearr_75125_75154[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_75085[(4)]))){
var statearr_75126_75155 = state_75085;
(statearr_75126_75155[(1)] = cljs.core.first((state_75085[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75156 = state_75085;
state_75085 = G__75156;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__11438__auto__ = function(state_75085){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__11438__auto____1.call(this,state_75085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__11438__auto____0;
fluree$db$connection_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__11438__auto____1;
return fluree$db$connection_js$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_75127 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_75127[(6)] = c__11512__auto__);

return statearr_75127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__75158 = arguments.length;
switch (G__75158) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_75193){
var state_val_75194 = (state_75193[(1)]);
if((state_val_75194 === (1))){
var state_75193__$1 = state_75193;
var statearr_75195_75217 = state_75193__$1;
(statearr_75195_75217[(2)] = null);

(statearr_75195_75217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75194 === (2))){
var _ = (function (){var statearr_75196 = state_75193;
(statearr_75196[(4)] = cljs.core.cons((5),(state_75193[(4)])));

return statearr_75196;
})();
var inst_75167 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_75193__$1 = state_75193;
if(cljs.core.truth_(inst_75167)){
var statearr_75197_75218 = state_75193__$1;
(statearr_75197_75218[(1)] = (6));

} else {
var statearr_75198_75219 = state_75193__$1;
(statearr_75198_75219[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75194 === (3))){
var inst_75191 = (state_75193[(2)]);
var state_75193__$1 = state_75193;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75193__$1,inst_75191);
} else {
if((state_val_75194 === (4))){
var inst_75159 = (state_75193[(2)]);
var inst_75160 = cljs.core.clj__GT_js(inst_75159);
var inst_75161 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_75160) : reject.call(null,inst_75160));
var state_75193__$1 = state_75193;
var statearr_75200_75220 = state_75193__$1;
(statearr_75200_75220[(2)] = inst_75161);

(statearr_75200_75220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75194 === (5))){
var _ = (function (){var statearr_75201 = state_75193;
(statearr_75201[(4)] = cljs.core.rest((state_75193[(4)])));

return statearr_75201;
})();
var state_75193__$1 = state_75193;
var ex75199 = (state_75193__$1[(2)]);
var statearr_75202_75221 = state_75193__$1;
(statearr_75202_75221[(5)] = ex75199);


var statearr_75203_75222 = state_75193__$1;
(statearr_75203_75222[(1)] = (4));

(statearr_75203_75222[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75194 === (6))){
var state_75193__$1 = state_75193;
var statearr_75204_75223 = state_75193__$1;
(statearr_75204_75223[(2)] = null);

(statearr_75204_75223[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75194 === (7))){
var inst_75170 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75171 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_75172 = cljs.core.PersistentHashMap.fromArrays(inst_75170,inst_75171);
var inst_75173 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_75172);
var inst_75174 = (function(){throw inst_75173})();
var state_75193__$1 = state_75193;
var statearr_75205_75224 = state_75193__$1;
(statearr_75205_75224[(2)] = inst_75174);

(statearr_75205_75224[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75194 === (8))){
var inst_75176 = (state_75193[(2)]);
var inst_75177 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_75178 = [jwt,expire];
var inst_75179 = cljs.core.PersistentHashMap.fromArrays(inst_75177,inst_75178);
var inst_75180 = fluree.db.util.core.without_nils(inst_75179);
var inst_75181 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_75182 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_75183 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75184 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_75180,inst_75181,null];
var inst_75185 = (new cljs.core.PersistentVector(null,4,(5),inst_75183,inst_75184,null));
var inst_75186 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_75182,inst_75185);
var inst_75187 = (function (){var _ = inst_75176;
var data = inst_75180;
var pc = inst_75181;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__75206 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__75206) : reject.call(null,G__75206));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__75207 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__75207) : resolve.call(null,G__75207));

}
});
})();
var inst_75188 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_75181,inst_75187);
var _ = (function (){var statearr_75208 = state_75193;
(statearr_75208[(4)] = cljs.core.rest((state_75193[(4)])));

return statearr_75208;
})();
var state_75193__$1 = (function (){var statearr_75209 = state_75193;
(statearr_75209[(7)] = inst_75186);

return statearr_75209;
})();
var statearr_75210_75225 = state_75193__$1;
(statearr_75210_75225[(2)] = inst_75188);

(statearr_75210_75225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__11438__auto__ = null;
var fluree$db$connection_js$state_machine__11438__auto____0 = (function (){
var statearr_75211 = [null,null,null,null,null,null,null,null];
(statearr_75211[(0)] = fluree$db$connection_js$state_machine__11438__auto__);

(statearr_75211[(1)] = (1));

return statearr_75211;
});
var fluree$db$connection_js$state_machine__11438__auto____1 = (function (state_75193){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_75193);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e75212){var ex__11441__auto__ = e75212;
var statearr_75213_75226 = state_75193;
(statearr_75213_75226[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_75193[(4)]))){
var statearr_75214_75227 = state_75193;
(statearr_75214_75227[(1)] = cljs.core.first((state_75193[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75228 = state_75193;
state_75193 = G__75228;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__11438__auto__ = function(state_75193){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__11438__auto____1.call(this,state_75193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__11438__auto____0;
fluree$db$connection_js$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__11438__auto____1;
return fluree$db$connection_js$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_75215 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_75215[(6)] = c__11512__auto__);

return statearr_75215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

