// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5823__auto___65137 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_65188){
var state_val_65189 = (state_65188[(1)]);
if((state_val_65189 === (7))){
var inst_65183 = (state_65188[(2)]);
var _ = (function (){var statearr_65190 = state_65188;
(statearr_65190[(4)] = cljs.core.rest((state_65188[(4)])));

return statearr_65190;
})();
var state_65188__$1 = state_65188;
var statearr_65191_65218 = state_65188__$1;
(statearr_65191_65218[(2)] = inst_65183);

(statearr_65191_65218[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65189 === (1))){
var state_65188__$1 = state_65188;
var statearr_65192_65219 = state_65188__$1;
(statearr_65192_65219[(2)] = null);

(statearr_65192_65219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65189 === (4))){
var inst_65138 = (state_65188[(2)]);
var state_65188__$1 = state_65188;
var statearr_65193_65220 = state_65188__$1;
(statearr_65193_65220[(2)] = inst_65138);

(statearr_65193_65220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65189 === (13))){
var inst_65179 = (state_65188[(2)]);
var state_65188__$1 = state_65188;
var statearr_65194_65221 = state_65188__$1;
(statearr_65194_65221[(2)] = inst_65179);

(statearr_65194_65221[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65189 === (6))){
var inst_65163 = (state_65188[(7)]);
var inst_65156 = (state_65188[(8)]);
var inst_65162 = cljs.core.seq(inst_65156);
var inst_65163__$1 = cljs.core.first(inst_65162);
var inst_65164 = cljs.core.next(inst_65162);
var inst_65165 = cljs.core.not(inst_65163__$1);
var state_65188__$1 = (function (){var statearr_65195 = state_65188;
(statearr_65195[(7)] = inst_65163__$1);

(statearr_65195[(9)] = inst_65164);

return statearr_65195;
})();
if(inst_65165){
var statearr_65196_65222 = state_65188__$1;
(statearr_65196_65222[(1)] = (8));

} else {
var statearr_65197_65223 = state_65188__$1;
(statearr_65197_65223[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65189 === (3))){
var inst_65186 = (state_65188[(2)]);
var state_65188__$1 = state_65188;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65188__$1,inst_65186);
} else {
if((state_val_65189 === (12))){
var inst_65163 = (state_65188[(7)]);
var inst_65164 = (state_65188[(9)]);
var inst_65157 = (state_65188[(10)]);
var inst_65176 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_65157,inst_65163);
var inst_65156 = inst_65164;
var inst_65157__$1 = inst_65176;
var state_65188__$1 = (function (){var statearr_65198 = state_65188;
(statearr_65198[(10)] = inst_65157__$1);

(statearr_65198[(8)] = inst_65156);

return statearr_65198;
})();
var statearr_65199_65224 = state_65188__$1;
(statearr_65199_65224[(2)] = null);

(statearr_65199_65224[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65189 === (2))){
var _ = (function (){var statearr_65200 = state_65188;
(statearr_65200[(4)] = cljs.core.cons((5),(state_65188[(4)])));

return statearr_65200;
})();
var inst_65151 = args;
var inst_65152 = cljs.core.seq(inst_65151);
var inst_65153 = cljs.core.first(inst_65152);
var inst_65154 = cljs.core.next(inst_65152);
var inst_65155 = cljs.core.PersistentVector.EMPTY;
var inst_65156 = inst_65151;
var inst_65157 = inst_65155;
var state_65188__$1 = (function (){var statearr_65201 = state_65188;
(statearr_65201[(10)] = inst_65157);

(statearr_65201[(8)] = inst_65156);

(statearr_65201[(11)] = inst_65154);

(statearr_65201[(12)] = inst_65153);

return statearr_65201;
})();
var statearr_65202_65225 = state_65188__$1;
(statearr_65202_65225[(2)] = null);

(statearr_65202_65225[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65189 === (11))){
var inst_65163 = (state_65188[(7)]);
var state_65188__$1 = state_65188;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65188__$1,(14),inst_65163);
} else {
if((state_val_65189 === (9))){
var inst_65163 = (state_65188[(7)]);
var inst_65168 = fluree.db.util.async.channel_QMARK_(inst_65163);
var state_65188__$1 = state_65188;
if(inst_65168){
var statearr_65204_65226 = state_65188__$1;
(statearr_65204_65226[(1)] = (11));

} else {
var statearr_65205_65227 = state_65188__$1;
(statearr_65205_65227[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65189 === (5))){
var _ = (function (){var statearr_65206 = state_65188;
(statearr_65206[(4)] = cljs.core.rest((state_65188[(4)])));

return statearr_65206;
})();
var state_65188__$1 = state_65188;
var ex65203 = (state_65188__$1[(2)]);
var statearr_65207_65228 = state_65188__$1;
(statearr_65207_65228[(5)] = ex65203);


if((ex65203 instanceof Error)){
var statearr_65208_65229 = state_65188__$1;
(statearr_65208_65229[(1)] = (4));

(statearr_65208_65229[(5)] = null);

} else {
throw ex65203;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65189 === (14))){
var inst_65164 = (state_65188[(9)]);
var inst_65157 = (state_65188[(10)]);
var inst_65171 = (state_65188[(2)]);
var inst_65172 = fluree.db.util.async.throw_err(inst_65171);
var inst_65173 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_65157,inst_65172);
var inst_65156 = inst_65164;
var inst_65157__$1 = inst_65173;
var state_65188__$1 = (function (){var statearr_65209 = state_65188;
(statearr_65209[(10)] = inst_65157__$1);

(statearr_65209[(8)] = inst_65156);

return statearr_65209;
})();
var statearr_65210_65230 = state_65188__$1;
(statearr_65210_65230[(2)] = null);

(statearr_65210_65230[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65189 === (10))){
var inst_65181 = (state_65188[(2)]);
var state_65188__$1 = state_65188;
var statearr_65211_65231 = state_65188__$1;
(statearr_65211_65231[(2)] = inst_65181);

(statearr_65211_65231[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65189 === (8))){
var inst_65157 = (state_65188[(10)]);
var state_65188__$1 = state_65188;
var statearr_65212_65232 = state_65188__$1;
(statearr_65212_65232[(2)] = inst_65157);

(statearr_65212_65232[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11438__auto____0 = (function (){
var statearr_65213 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65213[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11438__auto__);

(statearr_65213[(1)] = (1));

return statearr_65213;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11438__auto____1 = (function (state_65188){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_65188);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e65214){var ex__11441__auto__ = e65214;
var statearr_65215_65233 = state_65188;
(statearr_65215_65233[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_65188[(4)]))){
var statearr_65216_65234 = state_65188;
(statearr_65216_65234[(1)] = cljs.core.first((state_65188[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65235 = state_65188;
state_65188 = G__65235;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11438__auto__ = function(state_65188){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11438__auto____1.call(this,state_65188);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_65217 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_65217[(6)] = c__11512__auto__);

return statearr_65217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__65236 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65236,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65236,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost], 0)),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_65284){
var state_val_65285 = (state_65284[(1)]);
if((state_val_65285 === (7))){
var state_65284__$1 = state_65284;
var statearr_65286_65315 = state_65284__$1;
(statearr_65286_65315[(2)] = coll);

(statearr_65286_65315[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65285 === (1))){
var state_65284__$1 = state_65284;
var statearr_65287_65316 = state_65284__$1;
(statearr_65287_65316[(2)] = null);

(statearr_65287_65316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65285 === (4))){
var inst_65239 = (state_65284[(2)]);
var state_65284__$1 = state_65284;
var statearr_65288_65317 = state_65284__$1;
(statearr_65288_65317[(2)] = inst_65239);

(statearr_65288_65317[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65285 === (15))){
var inst_65258 = (state_65284[(7)]);
var inst_65266 = (state_65284[(2)]);
var inst_65267 = fluree.db.dbfunctions.internal.nth(inst_65258,inst_65266);
var inst_65268 = cljs.core.count(inst_65258);
var inst_65269 = ((9) + inst_65268);
var inst_65270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65271 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65273 = [inst_65258,inst_65266];
var inst_65274 = (new cljs.core.PersistentVector(null,2,(5),inst_65272,inst_65273,null));
var inst_65275 = ["nth",inst_65274,inst_65267];
var inst_65276 = cljs.core.PersistentHashMap.fromArrays(inst_65271,inst_65275);
var inst_65277 = [inst_65276,inst_65269];
var inst_65278 = (new cljs.core.PersistentVector(null,2,(5),inst_65270,inst_65277,null));
var inst_65279 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65278);
var _ = (function (){var statearr_65289 = state_65284;
(statearr_65289[(4)] = cljs.core.rest((state_65284[(4)])));

return statearr_65289;
})();
var state_65284__$1 = (function (){var statearr_65290 = state_65284;
(statearr_65290[(8)] = inst_65279);

return statearr_65290;
})();
var statearr_65291_65318 = state_65284__$1;
(statearr_65291_65318[(2)] = inst_65267);

(statearr_65291_65318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65285 === (13))){
var state_65284__$1 = state_65284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65284__$1,(16),key);
} else {
if((state_val_65285 === (6))){
var state_65284__$1 = state_65284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65284__$1,(9),coll);
} else {
if((state_val_65285 === (3))){
var inst_65282 = (state_65284[(2)]);
var state_65284__$1 = state_65284;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65284__$1,inst_65282);
} else {
if((state_val_65285 === (12))){
var inst_65258 = (state_65284[(2)]);
var inst_65259 = fluree.db.util.async.channel_QMARK_(key);
var state_65284__$1 = (function (){var statearr_65292 = state_65284;
(statearr_65292[(7)] = inst_65258);

return statearr_65292;
})();
if(inst_65259){
var statearr_65293_65319 = state_65284__$1;
(statearr_65293_65319[(1)] = (13));

} else {
var statearr_65294_65320 = state_65284__$1;
(statearr_65294_65320[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65285 === (2))){
var _ = (function (){var statearr_65295 = state_65284;
(statearr_65295[(4)] = cljs.core.cons((5),(state_65284[(4)])));

return statearr_65295;
})();
var inst_65245 = fluree.db.util.async.channel_QMARK_(coll);
var state_65284__$1 = state_65284;
if(inst_65245){
var statearr_65296_65321 = state_65284__$1;
(statearr_65296_65321[(1)] = (6));

} else {
var statearr_65297_65322 = state_65284__$1;
(statearr_65297_65322[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65285 === (11))){
var inst_65252 = (state_65284[(9)]);
var state_65284__$1 = state_65284;
var statearr_65299_65323 = state_65284__$1;
(statearr_65299_65323[(2)] = inst_65252);

(statearr_65299_65323[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65285 === (9))){
var inst_65248 = (state_65284[(2)]);
var inst_65249 = fluree.db.util.async.throw_err(inst_65248);
var state_65284__$1 = state_65284;
var statearr_65300_65324 = state_65284__$1;
(statearr_65300_65324[(2)] = inst_65249);

(statearr_65300_65324[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65285 === (5))){
var _ = (function (){var statearr_65301 = state_65284;
(statearr_65301[(4)] = cljs.core.rest((state_65284[(4)])));

return statearr_65301;
})();
var state_65284__$1 = state_65284;
var ex65298 = (state_65284__$1[(2)]);
var statearr_65302_65325 = state_65284__$1;
(statearr_65302_65325[(5)] = ex65298);


if((ex65298 instanceof Error)){
var statearr_65303_65326 = state_65284__$1;
(statearr_65303_65326[(1)] = (4));

(statearr_65303_65326[(5)] = null);

} else {
throw ex65298;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65285 === (14))){
var state_65284__$1 = state_65284;
var statearr_65304_65327 = state_65284__$1;
(statearr_65304_65327[(2)] = key);

(statearr_65304_65327[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65285 === (16))){
var inst_65262 = (state_65284[(2)]);
var inst_65263 = fluree.db.util.async.throw_err(inst_65262);
var state_65284__$1 = state_65284;
var statearr_65305_65328 = state_65284__$1;
(statearr_65305_65328[(2)] = inst_65263);

(statearr_65305_65328[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65285 === (10))){
var inst_65252 = (state_65284[(9)]);
var inst_65255 = cljs.core.vec(inst_65252);
var state_65284__$1 = state_65284;
var statearr_65306_65329 = state_65284__$1;
(statearr_65306_65329[(2)] = inst_65255);

(statearr_65306_65329[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65285 === (8))){
var inst_65252 = (state_65284[(9)]);
var inst_65252__$1 = (state_65284[(2)]);
var inst_65253 = cljs.core.set_QMARK_(inst_65252__$1);
var state_65284__$1 = (function (){var statearr_65307 = state_65284;
(statearr_65307[(9)] = inst_65252__$1);

return statearr_65307;
})();
if(inst_65253){
var statearr_65308_65330 = state_65284__$1;
(statearr_65308_65330[(1)] = (10));

} else {
var statearr_65309_65331 = state_65284__$1;
(statearr_65309_65331[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__11438__auto____0 = (function (){
var statearr_65310 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65310[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__11438__auto__);

(statearr_65310[(1)] = (1));

return statearr_65310;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__11438__auto____1 = (function (state_65284){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_65284);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e65311){var ex__11441__auto__ = e65311;
var statearr_65312_65332 = state_65284;
(statearr_65312_65332[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_65284[(4)]))){
var statearr_65313_65333 = state_65284;
(statearr_65313_65333[(1)] = cljs.core.first((state_65284[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65334 = state_65284;
state_65284 = G__65334;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__11438__auto__ = function(state_65284){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__11438__auto____1.call(this,state_65284);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_65314 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_65314[(6)] = c__11512__auto__);

return statearr_65314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_65395){
var state_val_65396 = (state_65395[(1)]);
if((state_val_65396 === (7))){
var state_65395__$1 = state_65395;
var statearr_65397_65431 = state_65395__$1;
(statearr_65397_65431[(2)] = test);

(statearr_65397_65431[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (20))){
var inst_65369 = (state_65395[(2)]);
var inst_65370 = fluree.db.util.async.throw_err(inst_65369);
var state_65395__$1 = state_65395;
var statearr_65398_65432 = state_65395__$1;
(statearr_65398_65432[(2)] = inst_65370);

(statearr_65398_65432[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (1))){
var state_65395__$1 = state_65395;
var statearr_65399_65433 = state_65395__$1;
(statearr_65399_65433[(2)] = null);

(statearr_65399_65433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (4))){
var inst_65335 = (state_65395[(2)]);
var state_65395__$1 = state_65395;
var statearr_65400_65434 = state_65395__$1;
(statearr_65400_65434[(2)] = inst_65335);

(statearr_65400_65434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (15))){
var inst_65353 = (state_65395[(7)]);
var inst_65361 = (state_65395[(2)]);
var inst_65362 = [inst_65361,f];
var inst_65363 = (new cljs.core.PersistentVector(null,2,(5),inst_65353,inst_65362,null));
var state_65395__$1 = state_65395;
var statearr_65401_65435 = state_65395__$1;
(statearr_65401_65435[(2)] = inst_65363);

(statearr_65401_65435[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (13))){
var state_65395__$1 = state_65395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65395__$1,(16),t);
} else {
if((state_val_65396 === (6))){
var state_65395__$1 = state_65395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65395__$1,(9),test);
} else {
if((state_val_65396 === (17))){
var state_65395__$1 = state_65395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65395__$1,(20),f);
} else {
if((state_val_65396 === (3))){
var inst_65393 = (state_65395[(2)]);
var state_65395__$1 = state_65395;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65395__$1,inst_65393);
} else {
if((state_val_65396 === (12))){
var inst_65351 = (state_65395[(8)]);
var inst_65377 = (state_65395[(2)]);
var inst_65378 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65377,(0),null);
var inst_65379 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65377,(1),null);
var inst_65380 = fluree.db.dbfunctions.internal.if_else(inst_65351,inst_65378,inst_65379);
var inst_65381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65382 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65384 = [inst_65351,inst_65378,inst_65379];
var inst_65385 = (new cljs.core.PersistentVector(null,3,(5),inst_65383,inst_65384,null));
var inst_65386 = ["if-else",inst_65385,inst_65380];
var inst_65387 = cljs.core.PersistentHashMap.fromArrays(inst_65382,inst_65386);
var inst_65388 = [inst_65387,(10)];
var inst_65389 = (new cljs.core.PersistentVector(null,2,(5),inst_65381,inst_65388,null));
var inst_65390 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65389);
var _ = (function (){var statearr_65402 = state_65395;
(statearr_65402[(4)] = cljs.core.rest((state_65395[(4)])));

return statearr_65402;
})();
var state_65395__$1 = (function (){var statearr_65403 = state_65395;
(statearr_65403[(9)] = inst_65390);

return statearr_65403;
})();
var statearr_65404_65436 = state_65395__$1;
(statearr_65404_65436[(2)] = inst_65380);

(statearr_65404_65436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (2))){
var _ = (function (){var statearr_65405 = state_65395;
(statearr_65405[(4)] = cljs.core.cons((5),(state_65395[(4)])));

return statearr_65405;
})();
var inst_65344 = fluree.db.util.async.channel_QMARK_(test);
var state_65395__$1 = state_65395;
if(inst_65344){
var statearr_65406_65437 = state_65395__$1;
(statearr_65406_65437[(1)] = (6));

} else {
var statearr_65407_65438 = state_65395__$1;
(statearr_65407_65438[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (19))){
var inst_65365 = (state_65395[(10)]);
var inst_65373 = (state_65395[(2)]);
var inst_65374 = [f,inst_65373];
var inst_65375 = (new cljs.core.PersistentVector(null,2,(5),inst_65365,inst_65374,null));
var state_65395__$1 = state_65395;
var statearr_65408_65439 = state_65395__$1;
(statearr_65408_65439[(2)] = inst_65375);

(statearr_65408_65439[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (11))){
var inst_65365 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65366 = fluree.db.util.async.channel_QMARK_(f);
var state_65395__$1 = (function (){var statearr_65410 = state_65395;
(statearr_65410[(10)] = inst_65365);

return statearr_65410;
})();
if(inst_65366){
var statearr_65411_65440 = state_65395__$1;
(statearr_65411_65440[(1)] = (17));

} else {
var statearr_65412_65441 = state_65395__$1;
(statearr_65412_65441[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (9))){
var inst_65347 = (state_65395[(2)]);
var inst_65348 = fluree.db.util.async.throw_err(inst_65347);
var state_65395__$1 = state_65395;
var statearr_65413_65442 = state_65395__$1;
(statearr_65413_65442[(2)] = inst_65348);

(statearr_65413_65442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (5))){
var _ = (function (){var statearr_65414 = state_65395;
(statearr_65414[(4)] = cljs.core.rest((state_65395[(4)])));

return statearr_65414;
})();
var state_65395__$1 = state_65395;
var ex65409 = (state_65395__$1[(2)]);
var statearr_65415_65443 = state_65395__$1;
(statearr_65415_65443[(5)] = ex65409);


if((ex65409 instanceof Error)){
var statearr_65416_65444 = state_65395__$1;
(statearr_65416_65444[(1)] = (4));

(statearr_65416_65444[(5)] = null);

} else {
throw ex65409;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (14))){
var state_65395__$1 = state_65395;
var statearr_65417_65445 = state_65395__$1;
(statearr_65417_65445[(2)] = t);

(statearr_65417_65445[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (16))){
var inst_65357 = (state_65395[(2)]);
var inst_65358 = fluree.db.util.async.throw_err(inst_65357);
var state_65395__$1 = state_65395;
var statearr_65418_65446 = state_65395__$1;
(statearr_65418_65446[(2)] = inst_65358);

(statearr_65418_65446[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (10))){
var inst_65353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65354 = fluree.db.util.async.channel_QMARK_(t);
var state_65395__$1 = (function (){var statearr_65419 = state_65395;
(statearr_65419[(7)] = inst_65353);

return statearr_65419;
})();
if(inst_65354){
var statearr_65420_65447 = state_65395__$1;
(statearr_65420_65447[(1)] = (13));

} else {
var statearr_65421_65448 = state_65395__$1;
(statearr_65421_65448[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (18))){
var state_65395__$1 = state_65395;
var statearr_65422_65449 = state_65395__$1;
(statearr_65422_65449[(2)] = f);

(statearr_65422_65449[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65396 === (8))){
var inst_65351 = (state_65395[(8)]);
var inst_65351__$1 = (state_65395[(2)]);
var state_65395__$1 = (function (){var statearr_65423 = state_65395;
(statearr_65423[(8)] = inst_65351__$1);

return statearr_65423;
})();
if(cljs.core.truth_(inst_65351__$1)){
var statearr_65424_65450 = state_65395__$1;
(statearr_65424_65450[(1)] = (10));

} else {
var statearr_65425_65451 = state_65395__$1;
(statearr_65425_65451[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__11438__auto____0 = (function (){
var statearr_65426 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_65426[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__11438__auto__);

(statearr_65426[(1)] = (1));

return statearr_65426;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__11438__auto____1 = (function (state_65395){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_65395);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e65427){var ex__11441__auto__ = e65427;
var statearr_65428_65452 = state_65395;
(statearr_65428_65452[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_65395[(4)]))){
var statearr_65429_65453 = state_65395;
(statearr_65429_65453[(1)] = cljs.core.first((state_65395[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65454 = state_65395;
state_65395 = G__65454;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__11438__auto__ = function(state_65395){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__11438__auto____1.call(this,state_65395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_65430 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_65430[(6)] = c__11512__auto__);

return statearr_65430;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_65484){
var state_val_65485 = (state_65484[(1)]);
if((state_val_65485 === (7))){
var state_65484__$1 = state_65484;
var statearr_65486_65505 = state_65484__$1;
(statearr_65486_65505[(2)] = arg);

(statearr_65486_65505[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65485 === (1))){
var state_65484__$1 = state_65484;
var statearr_65487_65506 = state_65484__$1;
(statearr_65487_65506[(2)] = null);

(statearr_65487_65506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65485 === (4))){
var inst_65455 = (state_65484[(2)]);
var state_65484__$1 = state_65484;
var statearr_65488_65507 = state_65484__$1;
(statearr_65488_65507[(2)] = inst_65455);

(statearr_65488_65507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65485 === (6))){
var state_65484__$1 = state_65484;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65484__$1,(9),arg);
} else {
if((state_val_65485 === (3))){
var inst_65482 = (state_65484[(2)]);
var state_65484__$1 = state_65484;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65484__$1,inst_65482);
} else {
if((state_val_65485 === (2))){
var _ = (function (){var statearr_65490 = state_65484;
(statearr_65490[(4)] = cljs.core.cons((5),(state_65484[(4)])));

return statearr_65490;
})();
var inst_65461 = fluree.db.util.async.channel_QMARK_(arg);
var state_65484__$1 = state_65484;
if(inst_65461){
var statearr_65491_65508 = state_65484__$1;
(statearr_65491_65508[(1)] = (6));

} else {
var statearr_65492_65509 = state_65484__$1;
(statearr_65492_65509[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65485 === (9))){
var inst_65464 = (state_65484[(2)]);
var inst_65465 = fluree.db.util.async.throw_err(inst_65464);
var state_65484__$1 = state_65484;
var statearr_65493_65510 = state_65484__$1;
(statearr_65493_65510[(2)] = inst_65465);

(statearr_65493_65510[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65485 === (5))){
var _ = (function (){var statearr_65494 = state_65484;
(statearr_65494[(4)] = cljs.core.rest((state_65484[(4)])));

return statearr_65494;
})();
var state_65484__$1 = state_65484;
var ex65489 = (state_65484__$1[(2)]);
var statearr_65495_65511 = state_65484__$1;
(statearr_65495_65511[(5)] = ex65489);


if((ex65489 instanceof Error)){
var statearr_65496_65512 = state_65484__$1;
(statearr_65496_65512[(1)] = (4));

(statearr_65496_65512[(5)] = null);

} else {
throw ex65489;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65485 === (8))){
var inst_65468 = (state_65484[(2)]);
var inst_65469 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_65468);
var inst_65470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65471 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65473 = [inst_65468];
var inst_65474 = (new cljs.core.PersistentVector(null,1,(5),inst_65472,inst_65473,null));
var inst_65475 = ["nil?",inst_65474,inst_65469];
var inst_65476 = cljs.core.PersistentHashMap.fromArrays(inst_65471,inst_65475);
var inst_65477 = [inst_65476,(10)];
var inst_65478 = (new cljs.core.PersistentVector(null,2,(5),inst_65470,inst_65477,null));
var inst_65479 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65478);
var _ = (function (){var statearr_65497 = state_65484;
(statearr_65497[(4)] = cljs.core.rest((state_65484[(4)])));

return statearr_65497;
})();
var state_65484__$1 = (function (){var statearr_65498 = state_65484;
(statearr_65498[(7)] = inst_65479);

return statearr_65498;
})();
var statearr_65499_65513 = state_65484__$1;
(statearr_65499_65513[(2)] = inst_65469);

(statearr_65499_65513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11438__auto____0 = (function (){
var statearr_65500 = [null,null,null,null,null,null,null,null];
(statearr_65500[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11438__auto__);

(statearr_65500[(1)] = (1));

return statearr_65500;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11438__auto____1 = (function (state_65484){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_65484);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e65501){var ex__11441__auto__ = e65501;
var statearr_65502_65514 = state_65484;
(statearr_65502_65514[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_65484[(4)]))){
var statearr_65503_65515 = state_65484;
(statearr_65503_65515[(1)] = cljs.core.first((state_65484[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65516 = state_65484;
state_65484 = G__65516;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11438__auto__ = function(state_65484){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11438__auto____1.call(this,state_65484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_65504 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_65504[(6)] = c__11512__auto__);

return statearr_65504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_65546){
var state_val_65547 = (state_65546[(1)]);
if((state_val_65547 === (7))){
var state_65546__$1 = state_65546;
var statearr_65548_65567 = state_65546__$1;
(statearr_65548_65567[(2)] = arg);

(statearr_65548_65567[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65547 === (1))){
var state_65546__$1 = state_65546;
var statearr_65549_65568 = state_65546__$1;
(statearr_65549_65568[(2)] = null);

(statearr_65549_65568[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65547 === (4))){
var inst_65517 = (state_65546[(2)]);
var state_65546__$1 = state_65546;
var statearr_65550_65569 = state_65546__$1;
(statearr_65550_65569[(2)] = inst_65517);

(statearr_65550_65569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65547 === (6))){
var state_65546__$1 = state_65546;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65546__$1,(9),arg);
} else {
if((state_val_65547 === (3))){
var inst_65544 = (state_65546[(2)]);
var state_65546__$1 = state_65546;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65546__$1,inst_65544);
} else {
if((state_val_65547 === (2))){
var _ = (function (){var statearr_65552 = state_65546;
(statearr_65552[(4)] = cljs.core.cons((5),(state_65546[(4)])));

return statearr_65552;
})();
var inst_65523 = fluree.db.util.async.channel_QMARK_(arg);
var state_65546__$1 = state_65546;
if(inst_65523){
var statearr_65553_65570 = state_65546__$1;
(statearr_65553_65570[(1)] = (6));

} else {
var statearr_65554_65571 = state_65546__$1;
(statearr_65554_65571[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65547 === (9))){
var inst_65526 = (state_65546[(2)]);
var inst_65527 = fluree.db.util.async.throw_err(inst_65526);
var state_65546__$1 = state_65546;
var statearr_65555_65572 = state_65546__$1;
(statearr_65555_65572[(2)] = inst_65527);

(statearr_65555_65572[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65547 === (5))){
var _ = (function (){var statearr_65556 = state_65546;
(statearr_65556[(4)] = cljs.core.rest((state_65546[(4)])));

return statearr_65556;
})();
var state_65546__$1 = state_65546;
var ex65551 = (state_65546__$1[(2)]);
var statearr_65557_65573 = state_65546__$1;
(statearr_65557_65573[(5)] = ex65551);


if((ex65551 instanceof Error)){
var statearr_65558_65574 = state_65546__$1;
(statearr_65558_65574[(1)] = (4));

(statearr_65558_65574[(5)] = null);

} else {
throw ex65551;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65547 === (8))){
var inst_65530 = (state_65546[(2)]);
var inst_65531 = fluree.db.dbfunctions.internal.not(inst_65530);
var inst_65532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65533 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65535 = [inst_65530];
var inst_65536 = (new cljs.core.PersistentVector(null,1,(5),inst_65534,inst_65535,null));
var inst_65537 = ["not?",inst_65536,inst_65531];
var inst_65538 = cljs.core.PersistentHashMap.fromArrays(inst_65533,inst_65537);
var inst_65539 = [inst_65538,(10)];
var inst_65540 = (new cljs.core.PersistentVector(null,2,(5),inst_65532,inst_65539,null));
var inst_65541 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65540);
var _ = (function (){var statearr_65559 = state_65546;
(statearr_65559[(4)] = cljs.core.rest((state_65546[(4)])));

return statearr_65559;
})();
var state_65546__$1 = (function (){var statearr_65560 = state_65546;
(statearr_65560[(7)] = inst_65541);

return statearr_65560;
})();
var statearr_65561_65575 = state_65546__$1;
(statearr_65561_65575[(2)] = inst_65531);

(statearr_65561_65575[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__11438__auto____0 = (function (){
var statearr_65562 = [null,null,null,null,null,null,null,null];
(statearr_65562[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__11438__auto__);

(statearr_65562[(1)] = (1));

return statearr_65562;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__11438__auto____1 = (function (state_65546){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_65546);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e65563){var ex__11441__auto__ = e65563;
var statearr_65564_65576 = state_65546;
(statearr_65564_65576[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_65546[(4)]))){
var statearr_65565_65577 = state_65546;
(statearr_65565_65577[(1)] = cljs.core.first((state_65546[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65578 = state_65546;
state_65546 = G__65578;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__11438__auto__ = function(state_65546){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__11438__auto____1.call(this,state_65546);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_65566 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_65566[(6)] = c__11512__auto__);

return statearr_65566;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_65608){
var state_val_65609 = (state_65608[(1)]);
if((state_val_65609 === (7))){
var state_65608__$1 = state_65608;
var statearr_65610_65629 = state_65608__$1;
(statearr_65610_65629[(2)] = arg);

(statearr_65610_65629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (1))){
var state_65608__$1 = state_65608;
var statearr_65611_65630 = state_65608__$1;
(statearr_65611_65630[(2)] = null);

(statearr_65611_65630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (4))){
var inst_65579 = (state_65608[(2)]);
var state_65608__$1 = state_65608;
var statearr_65612_65631 = state_65608__$1;
(statearr_65612_65631[(2)] = inst_65579);

(statearr_65612_65631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (6))){
var state_65608__$1 = state_65608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65608__$1,(9),arg);
} else {
if((state_val_65609 === (3))){
var inst_65606 = (state_65608[(2)]);
var state_65608__$1 = state_65608;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65608__$1,inst_65606);
} else {
if((state_val_65609 === (2))){
var _ = (function (){var statearr_65614 = state_65608;
(statearr_65614[(4)] = cljs.core.cons((5),(state_65608[(4)])));

return statearr_65614;
})();
var inst_65585 = fluree.db.util.async.channel_QMARK_(arg);
var state_65608__$1 = state_65608;
if(inst_65585){
var statearr_65615_65632 = state_65608__$1;
(statearr_65615_65632[(1)] = (6));

} else {
var statearr_65616_65633 = state_65608__$1;
(statearr_65616_65633[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (9))){
var inst_65588 = (state_65608[(2)]);
var inst_65589 = fluree.db.util.async.throw_err(inst_65588);
var state_65608__$1 = state_65608;
var statearr_65617_65634 = state_65608__$1;
(statearr_65617_65634[(2)] = inst_65589);

(statearr_65617_65634[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (5))){
var _ = (function (){var statearr_65618 = state_65608;
(statearr_65618[(4)] = cljs.core.rest((state_65608[(4)])));

return statearr_65618;
})();
var state_65608__$1 = state_65608;
var ex65613 = (state_65608__$1[(2)]);
var statearr_65619_65635 = state_65608__$1;
(statearr_65619_65635[(5)] = ex65613);


if((ex65613 instanceof Error)){
var statearr_65620_65636 = state_65608__$1;
(statearr_65620_65636[(1)] = (4));

(statearr_65620_65636[(5)] = null);

} else {
throw ex65613;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (8))){
var inst_65592 = (state_65608[(2)]);
var inst_65593 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_65592);
var inst_65594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65595 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65596 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65597 = [inst_65592];
var inst_65598 = (new cljs.core.PersistentVector(null,1,(5),inst_65596,inst_65597,null));
var inst_65599 = ["empty?",inst_65598,inst_65593];
var inst_65600 = cljs.core.PersistentHashMap.fromArrays(inst_65595,inst_65599);
var inst_65601 = [inst_65600,(10)];
var inst_65602 = (new cljs.core.PersistentVector(null,2,(5),inst_65594,inst_65601,null));
var inst_65603 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65602);
var _ = (function (){var statearr_65621 = state_65608;
(statearr_65621[(4)] = cljs.core.rest((state_65608[(4)])));

return statearr_65621;
})();
var state_65608__$1 = (function (){var statearr_65622 = state_65608;
(statearr_65622[(7)] = inst_65603);

return statearr_65622;
})();
var statearr_65623_65637 = state_65608__$1;
(statearr_65623_65637[(2)] = inst_65593);

(statearr_65623_65637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11438__auto____0 = (function (){
var statearr_65624 = [null,null,null,null,null,null,null,null];
(statearr_65624[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11438__auto__);

(statearr_65624[(1)] = (1));

return statearr_65624;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11438__auto____1 = (function (state_65608){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_65608);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e65625){var ex__11441__auto__ = e65625;
var statearr_65626_65638 = state_65608;
(statearr_65626_65638[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_65608[(4)]))){
var statearr_65627_65639 = state_65608;
(statearr_65627_65639[(1)] = cljs.core.first((state_65608[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65640 = state_65608;
state_65608 = G__65640;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11438__auto__ = function(state_65608){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11438__auto____1.call(this,state_65608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_65628 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_65628[(6)] = c__11512__auto__);

return statearr_65628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5774__auto__ = [];
var len__5768__auto___65685 = arguments.length;
var i__5769__auto___65686 = (0);
while(true){
if((i__5769__auto___65686 < len__5768__auto___65685)){
args__5774__auto__.push((arguments[i__5769__auto___65686]));

var G__65687 = (i__5769__auto___65686 + (1));
i__5769__auto___65686 = G__65687;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_65668){
var state_val_65669 = (state_65668[(1)]);
if((state_val_65669 === (1))){
var state_65668__$1 = state_65668;
var statearr_65670_65688 = state_65668__$1;
(statearr_65670_65688[(2)] = null);

(statearr_65670_65688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65669 === (2))){
var _ = (function (){var statearr_65671 = state_65668;
(statearr_65671[(4)] = cljs.core.cons((5),(state_65668[(4)])));

return statearr_65671;
})();
var inst_65649 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65668__$1 = state_65668;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65668__$1,(6),inst_65649);
} else {
if((state_val_65669 === (3))){
var inst_65666 = (state_65668[(2)]);
var state_65668__$1 = state_65668;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65668__$1,inst_65666);
} else {
if((state_val_65669 === (4))){
var inst_65643 = (state_65668[(2)]);
var state_65668__$1 = state_65668;
var statearr_65673_65689 = state_65668__$1;
(statearr_65673_65689[(2)] = inst_65643);

(statearr_65673_65689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65669 === (5))){
var _ = (function (){var statearr_65674 = state_65668;
(statearr_65674[(4)] = cljs.core.rest((state_65668[(4)])));

return statearr_65674;
})();
var state_65668__$1 = state_65668;
var ex65672 = (state_65668__$1[(2)]);
var statearr_65675_65690 = state_65668__$1;
(statearr_65675_65690[(5)] = ex65672);


if((ex65672 instanceof Error)){
var statearr_65676_65691 = state_65668__$1;
(statearr_65676_65691[(1)] = (4));

(statearr_65676_65691[(5)] = null);

} else {
throw ex65672;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65669 === (6))){
var inst_65651 = (state_65668[(2)]);
var inst_65652 = fluree.db.util.async.throw_err(inst_65651);
var inst_65653 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_65652);
var inst_65654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65655 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65657 = [inst_65652];
var inst_65658 = (new cljs.core.PersistentVector(null,1,(5),inst_65656,inst_65657,null));
var inst_65659 = ["str",inst_65658,inst_65653];
var inst_65660 = cljs.core.PersistentHashMap.fromArrays(inst_65655,inst_65659);
var inst_65661 = [inst_65660,(10)];
var inst_65662 = (new cljs.core.PersistentVector(null,2,(5),inst_65654,inst_65661,null));
var inst_65663 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65662);
var _ = (function (){var statearr_65677 = state_65668;
(statearr_65677[(4)] = cljs.core.rest((state_65668[(4)])));

return statearr_65677;
})();
var state_65668__$1 = (function (){var statearr_65678 = state_65668;
(statearr_65678[(7)] = inst_65663);

return statearr_65678;
})();
var statearr_65679_65692 = state_65668__$1;
(statearr_65679_65692[(2)] = inst_65653);

(statearr_65679_65692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_65680 = [null,null,null,null,null,null,null,null];
(statearr_65680[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_65680[(1)] = (1));

return statearr_65680;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_65668){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_65668);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e65681){var ex__11441__auto__ = e65681;
var statearr_65682_65693 = state_65668;
(statearr_65682_65693[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_65668[(4)]))){
var statearr_65683_65694 = state_65668;
(statearr_65683_65694[(1)] = cljs.core.first((state_65668[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65695 = state_65668;
state_65668 = G__65695;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_65668){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_65668);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_65684 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_65684[(6)] = c__11512__auto__);

return statearr_65684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq65641){
var G__65642 = cljs.core.first(seq65641);
var seq65641__$1 = cljs.core.next(seq65641);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65642,seq65641__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_65721){
var state_val_65722 = (state_65721[(1)]);
if((state_val_65722 === (1))){
var state_65721__$1 = state_65721;
var statearr_65723_65738 = state_65721__$1;
(statearr_65723_65738[(2)] = null);

(statearr_65723_65738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65722 === (2))){
var _ = (function (){var statearr_65724 = state_65721;
(statearr_65724[(4)] = cljs.core.cons((5),(state_65721[(4)])));

return statearr_65724;
})();
var inst_65702 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65721__$1 = state_65721;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65721__$1,(6),inst_65702);
} else {
if((state_val_65722 === (3))){
var inst_65719 = (state_65721[(2)]);
var state_65721__$1 = state_65721;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65721__$1,inst_65719);
} else {
if((state_val_65722 === (4))){
var inst_65696 = (state_65721[(2)]);
var state_65721__$1 = state_65721;
var statearr_65726_65739 = state_65721__$1;
(statearr_65726_65739[(2)] = inst_65696);

(statearr_65726_65739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65722 === (5))){
var _ = (function (){var statearr_65727 = state_65721;
(statearr_65727[(4)] = cljs.core.rest((state_65721[(4)])));

return statearr_65727;
})();
var state_65721__$1 = state_65721;
var ex65725 = (state_65721__$1[(2)]);
var statearr_65728_65740 = state_65721__$1;
(statearr_65728_65740[(5)] = ex65725);


if((ex65725 instanceof Error)){
var statearr_65729_65741 = state_65721__$1;
(statearr_65729_65741[(1)] = (4));

(statearr_65729_65741[(5)] = null);

} else {
throw ex65725;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65722 === (6))){
var inst_65704 = (state_65721[(2)]);
var inst_65705 = fluree.db.util.async.throw_err(inst_65704);
var inst_65706 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_65705);
var inst_65707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65708 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65710 = [inst_65705];
var inst_65711 = (new cljs.core.PersistentVector(null,1,(5),inst_65709,inst_65710,null));
var inst_65712 = ["subs",inst_65711,inst_65706];
var inst_65713 = cljs.core.PersistentHashMap.fromArrays(inst_65708,inst_65712);
var inst_65714 = [inst_65713,(30)];
var inst_65715 = (new cljs.core.PersistentVector(null,2,(5),inst_65707,inst_65714,null));
var inst_65716 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65715);
var _ = (function (){var statearr_65730 = state_65721;
(statearr_65730[(4)] = cljs.core.rest((state_65721[(4)])));

return statearr_65730;
})();
var state_65721__$1 = (function (){var statearr_65731 = state_65721;
(statearr_65731[(7)] = inst_65716);

return statearr_65731;
})();
var statearr_65732_65742 = state_65721__$1;
(statearr_65732_65742[(2)] = inst_65706);

(statearr_65732_65742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__11438__auto____0 = (function (){
var statearr_65733 = [null,null,null,null,null,null,null,null];
(statearr_65733[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__11438__auto__);

(statearr_65733[(1)] = (1));

return statearr_65733;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__11438__auto____1 = (function (state_65721){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_65721);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e65734){var ex__11441__auto__ = e65734;
var statearr_65735_65743 = state_65721;
(statearr_65735_65743[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_65721[(4)]))){
var statearr_65736_65744 = state_65721;
(statearr_65736_65744[(1)] = cljs.core.first((state_65721[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65745 = state_65721;
state_65721 = G__65745;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__11438__auto__ = function(state_65721){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__11438__auto____1.call(this,state_65721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_65737 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_65737[(6)] = c__11512__auto__);

return statearr_65737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_65775){
var state_val_65776 = (state_65775[(1)]);
if((state_val_65776 === (7))){
var state_65775__$1 = state_65775;
var statearr_65777_65796 = state_65775__$1;
(statearr_65777_65796[(2)] = str);

(statearr_65777_65796[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65776 === (1))){
var state_65775__$1 = state_65775;
var statearr_65778_65797 = state_65775__$1;
(statearr_65778_65797[(2)] = null);

(statearr_65778_65797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65776 === (4))){
var inst_65746 = (state_65775[(2)]);
var state_65775__$1 = state_65775;
var statearr_65779_65798 = state_65775__$1;
(statearr_65779_65798[(2)] = inst_65746);

(statearr_65779_65798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65776 === (6))){
var state_65775__$1 = state_65775;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65775__$1,(9),str);
} else {
if((state_val_65776 === (3))){
var inst_65773 = (state_65775[(2)]);
var state_65775__$1 = state_65775;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65775__$1,inst_65773);
} else {
if((state_val_65776 === (2))){
var _ = (function (){var statearr_65781 = state_65775;
(statearr_65781[(4)] = cljs.core.cons((5),(state_65775[(4)])));

return statearr_65781;
})();
var inst_65752 = fluree.db.util.async.channel_QMARK_(str);
var state_65775__$1 = state_65775;
if(inst_65752){
var statearr_65782_65799 = state_65775__$1;
(statearr_65782_65799[(1)] = (6));

} else {
var statearr_65783_65800 = state_65775__$1;
(statearr_65783_65800[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65776 === (9))){
var inst_65755 = (state_65775[(2)]);
var inst_65756 = fluree.db.util.async.throw_err(inst_65755);
var state_65775__$1 = state_65775;
var statearr_65784_65801 = state_65775__$1;
(statearr_65784_65801[(2)] = inst_65756);

(statearr_65784_65801[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65776 === (5))){
var _ = (function (){var statearr_65785 = state_65775;
(statearr_65785[(4)] = cljs.core.rest((state_65775[(4)])));

return statearr_65785;
})();
var state_65775__$1 = state_65775;
var ex65780 = (state_65775__$1[(2)]);
var statearr_65786_65802 = state_65775__$1;
(statearr_65786_65802[(5)] = ex65780);


if((ex65780 instanceof Error)){
var statearr_65787_65803 = state_65775__$1;
(statearr_65787_65803[(1)] = (4));

(statearr_65787_65803[(5)] = null);

} else {
throw ex65780;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65776 === (8))){
var inst_65759 = (state_65775[(2)]);
var inst_65760 = fluree.db.dbfunctions.internal.lower_case(inst_65759);
var inst_65761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65762 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65764 = [inst_65759];
var inst_65765 = (new cljs.core.PersistentVector(null,1,(5),inst_65763,inst_65764,null));
var inst_65766 = ["lower-case",inst_65765,inst_65760];
var inst_65767 = cljs.core.PersistentHashMap.fromArrays(inst_65762,inst_65766);
var inst_65768 = [inst_65767,(10)];
var inst_65769 = (new cljs.core.PersistentVector(null,2,(5),inst_65761,inst_65768,null));
var inst_65770 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65769);
var _ = (function (){var statearr_65788 = state_65775;
(statearr_65788[(4)] = cljs.core.rest((state_65775[(4)])));

return statearr_65788;
})();
var state_65775__$1 = (function (){var statearr_65789 = state_65775;
(statearr_65789[(7)] = inst_65770);

return statearr_65789;
})();
var statearr_65790_65804 = state_65775__$1;
(statearr_65790_65804[(2)] = inst_65760);

(statearr_65790_65804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__11438__auto____0 = (function (){
var statearr_65791 = [null,null,null,null,null,null,null,null];
(statearr_65791[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__11438__auto__);

(statearr_65791[(1)] = (1));

return statearr_65791;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__11438__auto____1 = (function (state_65775){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_65775);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e65792){var ex__11441__auto__ = e65792;
var statearr_65793_65805 = state_65775;
(statearr_65793_65805[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_65775[(4)]))){
var statearr_65794_65806 = state_65775;
(statearr_65794_65806[(1)] = cljs.core.first((state_65775[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65807 = state_65775;
state_65775 = G__65807;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__11438__auto__ = function(state_65775){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__11438__auto____1.call(this,state_65775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_65795 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_65795[(6)] = c__11512__auto__);

return statearr_65795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_65837){
var state_val_65838 = (state_65837[(1)]);
if((state_val_65838 === (7))){
var state_65837__$1 = state_65837;
var statearr_65839_65858 = state_65837__$1;
(statearr_65839_65858[(2)] = str);

(statearr_65839_65858[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65838 === (1))){
var state_65837__$1 = state_65837;
var statearr_65840_65859 = state_65837__$1;
(statearr_65840_65859[(2)] = null);

(statearr_65840_65859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65838 === (4))){
var inst_65808 = (state_65837[(2)]);
var state_65837__$1 = state_65837;
var statearr_65841_65860 = state_65837__$1;
(statearr_65841_65860[(2)] = inst_65808);

(statearr_65841_65860[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65838 === (6))){
var state_65837__$1 = state_65837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65837__$1,(9),str);
} else {
if((state_val_65838 === (3))){
var inst_65835 = (state_65837[(2)]);
var state_65837__$1 = state_65837;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65837__$1,inst_65835);
} else {
if((state_val_65838 === (2))){
var _ = (function (){var statearr_65843 = state_65837;
(statearr_65843[(4)] = cljs.core.cons((5),(state_65837[(4)])));

return statearr_65843;
})();
var inst_65814 = fluree.db.util.async.channel_QMARK_(str);
var state_65837__$1 = state_65837;
if(inst_65814){
var statearr_65844_65861 = state_65837__$1;
(statearr_65844_65861[(1)] = (6));

} else {
var statearr_65845_65862 = state_65837__$1;
(statearr_65845_65862[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65838 === (9))){
var inst_65817 = (state_65837[(2)]);
var inst_65818 = fluree.db.util.async.throw_err(inst_65817);
var state_65837__$1 = state_65837;
var statearr_65846_65863 = state_65837__$1;
(statearr_65846_65863[(2)] = inst_65818);

(statearr_65846_65863[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65838 === (5))){
var _ = (function (){var statearr_65847 = state_65837;
(statearr_65847[(4)] = cljs.core.rest((state_65837[(4)])));

return statearr_65847;
})();
var state_65837__$1 = state_65837;
var ex65842 = (state_65837__$1[(2)]);
var statearr_65848_65864 = state_65837__$1;
(statearr_65848_65864[(5)] = ex65842);


if((ex65842 instanceof Error)){
var statearr_65849_65865 = state_65837__$1;
(statearr_65849_65865[(1)] = (4));

(statearr_65849_65865[(5)] = null);

} else {
throw ex65842;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65838 === (8))){
var inst_65821 = (state_65837[(2)]);
var inst_65822 = fluree.db.dbfunctions.internal.upper_case(inst_65821);
var inst_65823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65824 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65826 = [inst_65821];
var inst_65827 = (new cljs.core.PersistentVector(null,1,(5),inst_65825,inst_65826,null));
var inst_65828 = ["upper-case",inst_65827,inst_65822];
var inst_65829 = cljs.core.PersistentHashMap.fromArrays(inst_65824,inst_65828);
var inst_65830 = [inst_65829,(10)];
var inst_65831 = (new cljs.core.PersistentVector(null,2,(5),inst_65823,inst_65830,null));
var inst_65832 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65831);
var _ = (function (){var statearr_65850 = state_65837;
(statearr_65850[(4)] = cljs.core.rest((state_65837[(4)])));

return statearr_65850;
})();
var state_65837__$1 = (function (){var statearr_65851 = state_65837;
(statearr_65851[(7)] = inst_65832);

return statearr_65851;
})();
var statearr_65852_65866 = state_65837__$1;
(statearr_65852_65866[(2)] = inst_65822);

(statearr_65852_65866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__11438__auto____0 = (function (){
var statearr_65853 = [null,null,null,null,null,null,null,null];
(statearr_65853[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__11438__auto__);

(statearr_65853[(1)] = (1));

return statearr_65853;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__11438__auto____1 = (function (state_65837){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_65837);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e65854){var ex__11441__auto__ = e65854;
var statearr_65855_65867 = state_65837;
(statearr_65855_65867[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_65837[(4)]))){
var statearr_65856_65868 = state_65837;
(statearr_65856_65868[(1)] = cljs.core.first((state_65837[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65869 = state_65837;
state_65837 = G__65869;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__11438__auto__ = function(state_65837){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__11438__auto____1.call(this,state_65837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_65857 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_65857[(6)] = c__11512__auto__);

return statearr_65857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__65871 = arguments.length;
switch (G__65871) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_65899){
var state_val_65900 = (state_65899[(1)]);
if((state_val_65900 === (1))){
var state_65899__$1 = state_65899;
var statearr_65901_65917 = state_65899__$1;
(statearr_65901_65917[(2)] = null);

(statearr_65901_65917[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65900 === (2))){
var _ = (function (){var statearr_65902 = state_65899;
(statearr_65902[(4)] = cljs.core.cons((5),(state_65899[(4)])));

return statearr_65902;
})();
var inst_65881 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_65899__$1 = state_65899;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65899__$1,(6),inst_65881);
} else {
if((state_val_65900 === (3))){
var inst_65897 = (state_65899[(2)]);
var state_65899__$1 = state_65899;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65899__$1,inst_65897);
} else {
if((state_val_65900 === (4))){
var inst_65872 = (state_65899[(2)]);
var state_65899__$1 = state_65899;
var statearr_65904_65918 = state_65899__$1;
(statearr_65904_65918[(2)] = inst_65872);

(statearr_65904_65918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65900 === (5))){
var _ = (function (){var statearr_65905 = state_65899;
(statearr_65905[(4)] = cljs.core.rest((state_65899[(4)])));

return statearr_65905;
})();
var state_65899__$1 = state_65899;
var ex65903 = (state_65899__$1[(2)]);
var statearr_65906_65919 = state_65899__$1;
(statearr_65906_65919[(5)] = ex65903);


if((ex65903 instanceof Error)){
var statearr_65907_65920 = state_65899__$1;
(statearr_65907_65920[(1)] = (4));

(statearr_65907_65920[(5)] = null);

} else {
throw ex65903;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65900 === (6))){
var inst_65883 = (state_65899[(2)]);
var inst_65884 = fluree.db.util.async.throw_err(inst_65883);
var inst_65885 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65884,(0),null);
var inst_65886 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65884,(1),null);
var inst_65887 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65888 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65889 = ["?s","?ctx",inst_65885];
var inst_65890 = cljs.core.PersistentHashMap.fromArrays(inst_65888,inst_65889);
var inst_65891 = ((10) + inst_65886);
var inst_65892 = [inst_65890,inst_65891];
var inst_65893 = (new cljs.core.PersistentVector(null,2,(5),inst_65887,inst_65892,null));
var inst_65894 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65893);
var _ = (function (){var statearr_65908 = state_65899;
(statearr_65908[(4)] = cljs.core.rest((state_65899[(4)])));

return statearr_65908;
})();
var state_65899__$1 = (function (){var statearr_65909 = state_65899;
(statearr_65909[(7)] = inst_65894);

return statearr_65909;
})();
var statearr_65910_65921 = state_65899__$1;
(statearr_65910_65921[(2)] = inst_65885);

(statearr_65910_65921[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_65911 = [null,null,null,null,null,null,null,null];
(statearr_65911[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_65911[(1)] = (1));

return statearr_65911;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_65899){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_65899);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e65912){var ex__11441__auto__ = e65912;
var statearr_65913_65922 = state_65899;
(statearr_65913_65922[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_65899[(4)]))){
var statearr_65914_65923 = state_65899;
(statearr_65914_65923[(1)] = cljs.core.first((state_65899[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65924 = state_65899;
state_65899 = G__65924;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_65899){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_65899);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_65915 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_65915[(6)] = c__11512__auto__);

return statearr_65915;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__65926 = arguments.length;
switch (G__65926) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_65964){
var state_val_65965 = (state_65964[(1)]);
if((state_val_65965 === (7))){
var inst_65957 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_65964__$1 = state_65964;
var statearr_65966_65986 = state_65964__$1;
(statearr_65966_65986[(2)] = inst_65957);

(statearr_65966_65986[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65965 === (1))){
var state_65964__$1 = state_65964;
var statearr_65967_65987 = state_65964__$1;
(statearr_65967_65987[(2)] = null);

(statearr_65967_65987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65965 === (4))){
var inst_65927 = (state_65964[(2)]);
var state_65964__$1 = state_65964;
var statearr_65968_65988 = state_65964__$1;
(statearr_65968_65988[(2)] = inst_65927);

(statearr_65968_65988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65965 === (6))){
var inst_65938 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_65964__$1 = state_65964;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65964__$1,(10),inst_65938);
} else {
if((state_val_65965 === (3))){
var inst_65962 = (state_65964[(2)]);
var state_65964__$1 = state_65964;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65964__$1,inst_65962);
} else {
if((state_val_65965 === (2))){
var _ = (function (){var statearr_65970 = state_65964;
(statearr_65970[(4)] = cljs.core.cons((5),(state_65964[(4)])));

return statearr_65970;
})();
var inst_65933 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65964__$1 = state_65964;
if(cljs.core.truth_(inst_65933)){
var statearr_65971_65989 = state_65964__$1;
(statearr_65971_65989[(1)] = (6));

} else {
var statearr_65972_65990 = state_65964__$1;
(statearr_65972_65990[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65965 === (9))){
var inst_65944 = (state_65964[(2)]);
var inst_65945 = fluree.db.util.async.throw_err(inst_65944);
var inst_65946 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65945,(0),null);
var inst_65947 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65945,(1),null);
var inst_65948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65949 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65950 = ["?p","?ctx",inst_65946];
var inst_65951 = cljs.core.PersistentHashMap.fromArrays(inst_65949,inst_65950);
var inst_65952 = ((10) + inst_65947);
var inst_65953 = [inst_65951,inst_65952];
var inst_65954 = (new cljs.core.PersistentVector(null,2,(5),inst_65948,inst_65953,null));
var inst_65955 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65954);
var state_65964__$1 = (function (){var statearr_65973 = state_65964;
(statearr_65973[(7)] = inst_65955);

return statearr_65973;
})();
var statearr_65974_65991 = state_65964__$1;
(statearr_65974_65991[(2)] = inst_65946);

(statearr_65974_65991[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65965 === (5))){
var _ = (function (){var statearr_65975 = state_65964;
(statearr_65975[(4)] = cljs.core.rest((state_65964[(4)])));

return statearr_65975;
})();
var state_65964__$1 = state_65964;
var ex65969 = (state_65964__$1[(2)]);
var statearr_65976_65992 = state_65964__$1;
(statearr_65976_65992[(5)] = ex65969);


if((ex65969 instanceof Error)){
var statearr_65977_65993 = state_65964__$1;
(statearr_65977_65993[(1)] = (4));

(statearr_65977_65993[(5)] = null);

} else {
throw ex65969;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65965 === (10))){
var inst_65940 = (state_65964[(2)]);
var inst_65941 = fluree.db.util.async.throw_err(inst_65940);
var inst_65942 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_65941);
var state_65964__$1 = state_65964;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65964__$1,(9),inst_65942);
} else {
if((state_val_65965 === (8))){
var inst_65959 = (state_65964[(2)]);
var _ = (function (){var statearr_65978 = state_65964;
(statearr_65978[(4)] = cljs.core.rest((state_65964[(4)])));

return statearr_65978;
})();
var state_65964__$1 = state_65964;
var statearr_65979_65994 = state_65964__$1;
(statearr_65979_65994[(2)] = inst_65959);

(statearr_65979_65994[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_65980 = [null,null,null,null,null,null,null,null];
(statearr_65980[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_65980[(1)] = (1));

return statearr_65980;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_65964){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_65964);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e65981){var ex__11441__auto__ = e65981;
var statearr_65982_65995 = state_65964;
(statearr_65982_65995[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_65964[(4)]))){
var statearr_65983_65996 = state_65964;
(statearr_65983_65996[(1)] = cljs.core.first((state_65964[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65997 = state_65964;
state_65964 = G__65997;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_65964){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_65964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_65984 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_65984[(6)] = c__11512__auto__);

return statearr_65984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5774__auto__ = [];
var len__5768__auto___66046 = arguments.length;
var i__5769__auto___66047 = (0);
while(true){
if((i__5769__auto___66047 < len__5768__auto___66046)){
args__5774__auto__.push((arguments[i__5769__auto___66047]));

var G__66048 = (i__5769__auto___66047 + (1));
i__5769__auto___66047 = G__66048;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_66029){
var state_val_66030 = (state_66029[(1)]);
if((state_val_66030 === (1))){
var state_66029__$1 = state_66029;
var statearr_66031_66049 = state_66029__$1;
(statearr_66031_66049[(2)] = null);

(statearr_66031_66049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (2))){
var _ = (function (){var statearr_66032 = state_66029;
(statearr_66032[(4)] = cljs.core.cons((5),(state_66029[(4)])));

return statearr_66032;
})();
var inst_66006 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66029__$1 = state_66029;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66029__$1,(6),inst_66006);
} else {
if((state_val_66030 === (3))){
var inst_66027 = (state_66029[(2)]);
var state_66029__$1 = state_66029;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66029__$1,inst_66027);
} else {
if((state_val_66030 === (4))){
var inst_66000 = (state_66029[(2)]);
var state_66029__$1 = state_66029;
var statearr_66034_66050 = state_66029__$1;
(statearr_66034_66050[(2)] = inst_66000);

(statearr_66034_66050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (5))){
var _ = (function (){var statearr_66035 = state_66029;
(statearr_66035[(4)] = cljs.core.rest((state_66029[(4)])));

return statearr_66035;
})();
var state_66029__$1 = state_66029;
var ex66033 = (state_66029__$1[(2)]);
var statearr_66036_66051 = state_66029__$1;
(statearr_66036_66051[(5)] = ex66033);


if((ex66033 instanceof Error)){
var statearr_66037_66052 = state_66029__$1;
(statearr_66037_66052[(1)] = (4));

(statearr_66037_66052[(5)] = null);

} else {
throw ex66033;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (6))){
var inst_66008 = (state_66029[(2)]);
var inst_66009 = fluree.db.util.async.throw_err(inst_66008);
var inst_66010 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_66009);
var inst_66011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66012 = [inst_66009];
var inst_66013 = (new cljs.core.PersistentVector(null,1,(5),inst_66011,inst_66012,null));
var inst_66014 = cljs.core.count(inst_66013);
var inst_66015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66016 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66018 = [inst_66009];
var inst_66019 = (new cljs.core.PersistentVector(null,1,(5),inst_66017,inst_66018,null));
var inst_66020 = ["and",inst_66019,inst_66010];
var inst_66021 = cljs.core.PersistentHashMap.fromArrays(inst_66016,inst_66020);
var inst_66022 = [inst_66021,inst_66014];
var inst_66023 = (new cljs.core.PersistentVector(null,2,(5),inst_66015,inst_66022,null));
var inst_66024 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66023);
var _ = (function (){var statearr_66038 = state_66029;
(statearr_66038[(4)] = cljs.core.rest((state_66029[(4)])));

return statearr_66038;
})();
var state_66029__$1 = (function (){var statearr_66039 = state_66029;
(statearr_66039[(7)] = inst_66024);

return statearr_66039;
})();
var statearr_66040_66053 = state_66029__$1;
(statearr_66040_66053[(2)] = inst_66010);

(statearr_66040_66053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_66041 = [null,null,null,null,null,null,null,null];
(statearr_66041[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_66041[(1)] = (1));

return statearr_66041;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_66029){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_66029);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e66042){var ex__11441__auto__ = e66042;
var statearr_66043_66054 = state_66029;
(statearr_66043_66054[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_66029[(4)]))){
var statearr_66044_66055 = state_66029;
(statearr_66044_66055[(1)] = cljs.core.first((state_66029[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66056 = state_66029;
state_66029 = G__66056;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_66029){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_66029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_66045 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_66045[(6)] = c__11512__auto__);

return statearr_66045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq65998){
var G__65999 = cljs.core.first(seq65998);
var seq65998__$1 = cljs.core.next(seq65998);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65999,seq65998__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5774__auto__ = [];
var len__5768__auto___66105 = arguments.length;
var i__5769__auto___66106 = (0);
while(true){
if((i__5769__auto___66106 < len__5768__auto___66105)){
args__5774__auto__.push((arguments[i__5769__auto___66106]));

var G__66107 = (i__5769__auto___66106 + (1));
i__5769__auto___66106 = G__66107;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_66088){
var state_val_66089 = (state_66088[(1)]);
if((state_val_66089 === (1))){
var state_66088__$1 = state_66088;
var statearr_66090_66108 = state_66088__$1;
(statearr_66090_66108[(2)] = null);

(statearr_66090_66108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66089 === (2))){
var _ = (function (){var statearr_66091 = state_66088;
(statearr_66091[(4)] = cljs.core.cons((5),(state_66088[(4)])));

return statearr_66091;
})();
var inst_66065 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66088__$1 = state_66088;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66088__$1,(6),inst_66065);
} else {
if((state_val_66089 === (3))){
var inst_66086 = (state_66088[(2)]);
var state_66088__$1 = state_66088;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66088__$1,inst_66086);
} else {
if((state_val_66089 === (4))){
var inst_66059 = (state_66088[(2)]);
var state_66088__$1 = state_66088;
var statearr_66093_66109 = state_66088__$1;
(statearr_66093_66109[(2)] = inst_66059);

(statearr_66093_66109[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66089 === (5))){
var _ = (function (){var statearr_66094 = state_66088;
(statearr_66094[(4)] = cljs.core.rest((state_66088[(4)])));

return statearr_66094;
})();
var state_66088__$1 = state_66088;
var ex66092 = (state_66088__$1[(2)]);
var statearr_66095_66110 = state_66088__$1;
(statearr_66095_66110[(5)] = ex66092);


if((ex66092 instanceof Error)){
var statearr_66096_66111 = state_66088__$1;
(statearr_66096_66111[(1)] = (4));

(statearr_66096_66111[(5)] = null);

} else {
throw ex66092;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66089 === (6))){
var inst_66067 = (state_66088[(2)]);
var inst_66068 = fluree.db.util.async.throw_err(inst_66067);
var inst_66069 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_66068);
var inst_66070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66071 = [inst_66068];
var inst_66072 = (new cljs.core.PersistentVector(null,1,(5),inst_66070,inst_66071,null));
var inst_66073 = cljs.core.count(inst_66072);
var inst_66074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66075 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66077 = [inst_66068];
var inst_66078 = (new cljs.core.PersistentVector(null,1,(5),inst_66076,inst_66077,null));
var inst_66079 = ["or",inst_66078,inst_66069];
var inst_66080 = cljs.core.PersistentHashMap.fromArrays(inst_66075,inst_66079);
var inst_66081 = [inst_66080,inst_66073];
var inst_66082 = (new cljs.core.PersistentVector(null,2,(5),inst_66074,inst_66081,null));
var inst_66083 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66082);
var _ = (function (){var statearr_66097 = state_66088;
(statearr_66097[(4)] = cljs.core.rest((state_66088[(4)])));

return statearr_66097;
})();
var state_66088__$1 = (function (){var statearr_66098 = state_66088;
(statearr_66098[(7)] = inst_66083);

return statearr_66098;
})();
var statearr_66099_66112 = state_66088__$1;
(statearr_66099_66112[(2)] = inst_66069);

(statearr_66099_66112[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_66100 = [null,null,null,null,null,null,null,null];
(statearr_66100[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_66100[(1)] = (1));

return statearr_66100;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_66088){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_66088);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e66101){var ex__11441__auto__ = e66101;
var statearr_66102_66113 = state_66088;
(statearr_66102_66113[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_66088[(4)]))){
var statearr_66103_66114 = state_66088;
(statearr_66103_66114[(1)] = cljs.core.first((state_66088[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66115 = state_66088;
state_66088 = G__66115;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_66088){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_66088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_66104 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_66104[(6)] = c__11512__auto__);

return statearr_66104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq66057){
var G__66058 = cljs.core.first(seq66057);
var seq66057__$1 = cljs.core.next(seq66057);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66058,seq66057__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_66153){
var state_val_66154 = (state_66153[(1)]);
if((state_val_66154 === (7))){
var inst_66129 = fluree.db.util.async.channel_QMARK_(coll);
var state_66153__$1 = state_66153;
if(inst_66129){
var statearr_66155_66178 = state_66153__$1;
(statearr_66155_66178[(1)] = (10));

} else {
var statearr_66156_66179 = state_66153__$1;
(statearr_66156_66179[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66154 === (1))){
var state_66153__$1 = state_66153;
var statearr_66157_66180 = state_66153__$1;
(statearr_66157_66180[(2)] = null);

(statearr_66157_66180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66154 === (4))){
var inst_66116 = (state_66153[(2)]);
var state_66153__$1 = state_66153;
var statearr_66158_66181 = state_66153__$1;
(statearr_66158_66181[(2)] = inst_66116);

(statearr_66158_66181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66154 === (13))){
var inst_66132 = (state_66153[(2)]);
var inst_66133 = fluree.db.util.async.throw_err(inst_66132);
var state_66153__$1 = state_66153;
var statearr_66159_66182 = state_66153__$1;
(statearr_66159_66182[(2)] = inst_66133);

(statearr_66159_66182[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66154 === (6))){
var inst_66124 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_66153__$1 = state_66153;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66153__$1,(9),inst_66124);
} else {
if((state_val_66154 === (3))){
var inst_66151 = (state_66153[(2)]);
var state_66153__$1 = state_66153;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66153__$1,inst_66151);
} else {
if((state_val_66154 === (12))){
var inst_66136 = (state_66153[(2)]);
var state_66153__$1 = state_66153;
var statearr_66160_66183 = state_66153__$1;
(statearr_66160_66183[(2)] = inst_66136);

(statearr_66160_66183[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66154 === (2))){
var _ = (function (){var statearr_66161 = state_66153;
(statearr_66161[(4)] = cljs.core.cons((5),(state_66153[(4)])));

return statearr_66161;
})();
var inst_66122 = cljs.core.vector_QMARK_(coll);
var state_66153__$1 = state_66153;
if(inst_66122){
var statearr_66162_66184 = state_66153__$1;
(statearr_66162_66184[(1)] = (6));

} else {
var statearr_66163_66185 = state_66153__$1;
(statearr_66163_66185[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66154 === (11))){
var state_66153__$1 = state_66153;
var statearr_66165_66186 = state_66153__$1;
(statearr_66165_66186[(2)] = coll);

(statearr_66165_66186[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66154 === (9))){
var inst_66126 = (state_66153[(2)]);
var inst_66127 = fluree.db.util.async.throw_err(inst_66126);
var state_66153__$1 = state_66153;
var statearr_66166_66187 = state_66153__$1;
(statearr_66166_66187[(2)] = inst_66127);

(statearr_66166_66187[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66154 === (5))){
var _ = (function (){var statearr_66167 = state_66153;
(statearr_66167[(4)] = cljs.core.rest((state_66153[(4)])));

return statearr_66167;
})();
var state_66153__$1 = state_66153;
var ex66164 = (state_66153__$1[(2)]);
var statearr_66168_66188 = state_66153__$1;
(statearr_66168_66188[(5)] = ex66164);


if((ex66164 instanceof Error)){
var statearr_66169_66189 = state_66153__$1;
(statearr_66169_66189[(1)] = (4));

(statearr_66169_66189[(5)] = null);

} else {
throw ex66164;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66154 === (10))){
var state_66153__$1 = state_66153;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66153__$1,(13),coll);
} else {
if((state_val_66154 === (8))){
var inst_66138 = (state_66153[(2)]);
var inst_66139 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_66138);
var inst_66140 = cljs.core.count(inst_66139);
var inst_66141 = ((9) + inst_66140);
var inst_66142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66143 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66144 = ["count",inst_66138,inst_66140];
var inst_66145 = cljs.core.PersistentHashMap.fromArrays(inst_66143,inst_66144);
var inst_66146 = [inst_66145,inst_66141];
var inst_66147 = (new cljs.core.PersistentVector(null,2,(5),inst_66142,inst_66146,null));
var inst_66148 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66147);
var _ = (function (){var statearr_66170 = state_66153;
(statearr_66170[(4)] = cljs.core.rest((state_66153[(4)])));

return statearr_66170;
})();
var state_66153__$1 = (function (){var statearr_66171 = state_66153;
(statearr_66171[(7)] = inst_66148);

return statearr_66171;
})();
var statearr_66172_66190 = state_66153__$1;
(statearr_66172_66190[(2)] = inst_66140);

(statearr_66172_66190[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__11438__auto____0 = (function (){
var statearr_66173 = [null,null,null,null,null,null,null,null];
(statearr_66173[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__11438__auto__);

(statearr_66173[(1)] = (1));

return statearr_66173;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__11438__auto____1 = (function (state_66153){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_66153);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e66174){var ex__11441__auto__ = e66174;
var statearr_66175_66191 = state_66153;
(statearr_66175_66191[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_66153[(4)]))){
var statearr_66176_66192 = state_66153;
(statearr_66176_66192[(1)] = cljs.core.first((state_66153[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66193 = state_66153;
state_66153 = G__66193;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__11438__auto__ = function(state_66153){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__11438__auto____1.call(this,state_66153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_66177 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_66177[(6)] = c__11512__auto__);

return statearr_66177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_66243){
var state_val_66244 = (state_66243[(1)]);
if((state_val_66244 === (7))){
var state_66243__$1 = state_66243;
var statearr_66245_66278 = state_66243__$1;
(statearr_66245_66278[(2)] = subject);

(statearr_66245_66278[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66244 === (1))){
var state_66243__$1 = state_66243;
var statearr_66246_66279 = state_66243__$1;
(statearr_66246_66279[(2)] = null);

(statearr_66246_66279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66244 === (4))){
var inst_66194 = (state_66243[(2)]);
var state_66243__$1 = state_66243;
var statearr_66247_66280 = state_66243__$1;
(statearr_66247_66280[(2)] = inst_66194);

(statearr_66247_66280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66244 === (15))){
var inst_66207 = (state_66243[(7)]);
var state_66243__$1 = state_66243;
var statearr_66248_66281 = state_66243__$1;
(statearr_66248_66281[(2)] = inst_66207);

(statearr_66248_66281[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66244 === (13))){
var inst_66211 = (state_66243[(2)]);
var inst_66212 = fluree.db.util.async.throw_err(inst_66211);
var state_66243__$1 = state_66243;
var statearr_66249_66282 = state_66243__$1;
(statearr_66249_66282[(2)] = inst_66212);

(statearr_66249_66282[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66244 === (6))){
var state_66243__$1 = state_66243;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66243__$1,(9),subject);
} else {
if((state_val_66244 === (17))){
var inst_66207 = (state_66243[(7)]);
var inst_66221 = cljs.core.first(inst_66207);
var state_66243__$1 = state_66243;
var statearr_66250_66283 = state_66243__$1;
(statearr_66250_66283[(2)] = inst_66221);

(statearr_66250_66283[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66244 === (3))){
var inst_66241 = (state_66243[(2)]);
var state_66243__$1 = state_66243;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66243__$1,inst_66241);
} else {
if((state_val_66244 === (12))){
var inst_66207 = (state_66243[(7)]);
var inst_66215 = (state_66243[(2)]);
var inst_66216 = cljs.core.vector_QMARK_(inst_66207);
var state_66243__$1 = (function (){var statearr_66251 = state_66243;
(statearr_66251[(8)] = inst_66215);

return statearr_66251;
})();
if(inst_66216){
var statearr_66252_66284 = state_66243__$1;
(statearr_66252_66284[(1)] = (14));

} else {
var statearr_66253_66285 = state_66243__$1;
(statearr_66253_66285[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66244 === (2))){
var _ = (function (){var statearr_66254 = state_66243;
(statearr_66254[(4)] = cljs.core.cons((5),(state_66243[(4)])));

return statearr_66254;
})();
var inst_66200 = fluree.db.util.async.channel_QMARK_(subject);
var state_66243__$1 = state_66243;
if(inst_66200){
var statearr_66255_66286 = state_66243__$1;
(statearr_66255_66286[(1)] = (6));

} else {
var statearr_66256_66287 = state_66243__$1;
(statearr_66256_66287[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66244 === (19))){
var inst_66224 = (state_66243[(2)]);
var state_66243__$1 = state_66243;
var statearr_66257_66288 = state_66243__$1;
(statearr_66257_66288[(2)] = inst_66224);

(statearr_66257_66288[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66244 === (11))){
var state_66243__$1 = state_66243;
var statearr_66259_66289 = state_66243__$1;
(statearr_66259_66289[(2)] = pred);

(statearr_66259_66289[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66244 === (9))){
var inst_66203 = (state_66243[(2)]);
var inst_66204 = fluree.db.util.async.throw_err(inst_66203);
var state_66243__$1 = state_66243;
var statearr_66260_66290 = state_66243__$1;
(statearr_66260_66290[(2)] = inst_66204);

(statearr_66260_66290[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66244 === (5))){
var _ = (function (){var statearr_66261 = state_66243;
(statearr_66261[(4)] = cljs.core.rest((state_66243[(4)])));

return statearr_66261;
})();
var state_66243__$1 = state_66243;
var ex66258 = (state_66243__$1[(2)]);
var statearr_66262_66291 = state_66243__$1;
(statearr_66262_66291[(5)] = ex66258);


if((ex66258 instanceof Error)){
var statearr_66263_66292 = state_66243__$1;
(statearr_66263_66292[(1)] = (4));

(statearr_66263_66292[(5)] = null);

} else {
throw ex66258;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66244 === (14))){
var inst_66207 = (state_66243[(7)]);
var inst_66218 = cljs.core.count(inst_66207);
var inst_66219 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_66218);
var state_66243__$1 = state_66243;
if(inst_66219){
var statearr_66264_66293 = state_66243__$1;
(statearr_66264_66293[(1)] = (17));

} else {
var statearr_66265_66294 = state_66243__$1;
(statearr_66265_66294[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66244 === (16))){
var inst_66207 = (state_66243[(7)]);
var inst_66215 = (state_66243[(8)]);
var inst_66227 = (state_66243[(2)]);
var inst_66228 = fluree.db.dbfunctions.internal.get(inst_66227,inst_66215);
var inst_66229 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66230 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66232 = [inst_66207,inst_66215];
var inst_66233 = (new cljs.core.PersistentVector(null,2,(5),inst_66231,inst_66232,null));
var inst_66234 = ["get",inst_66233,inst_66228];
var inst_66235 = cljs.core.PersistentHashMap.fromArrays(inst_66230,inst_66234);
var inst_66236 = [inst_66235,(10)];
var inst_66237 = (new cljs.core.PersistentVector(null,2,(5),inst_66229,inst_66236,null));
var inst_66238 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66237);
var _ = (function (){var statearr_66266 = state_66243;
(statearr_66266[(4)] = cljs.core.rest((state_66243[(4)])));

return statearr_66266;
})();
var state_66243__$1 = (function (){var statearr_66267 = state_66243;
(statearr_66267[(9)] = inst_66238);

return statearr_66267;
})();
var statearr_66268_66295 = state_66243__$1;
(statearr_66268_66295[(2)] = inst_66228);

(statearr_66268_66295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66244 === (10))){
var state_66243__$1 = state_66243;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66243__$1,(13),pred);
} else {
if((state_val_66244 === (18))){
var inst_66207 = (state_66243[(7)]);
var state_66243__$1 = state_66243;
var statearr_66269_66296 = state_66243__$1;
(statearr_66269_66296[(2)] = inst_66207);

(statearr_66269_66296[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66244 === (8))){
var inst_66207 = (state_66243[(2)]);
var inst_66208 = fluree.db.util.async.channel_QMARK_(pred);
var state_66243__$1 = (function (){var statearr_66270 = state_66243;
(statearr_66270[(7)] = inst_66207);

return statearr_66270;
})();
if(inst_66208){
var statearr_66271_66297 = state_66243__$1;
(statearr_66271_66297[(1)] = (10));

} else {
var statearr_66272_66298 = state_66243__$1;
(statearr_66272_66298[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__11438__auto____0 = (function (){
var statearr_66273 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66273[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__11438__auto__);

(statearr_66273[(1)] = (1));

return statearr_66273;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__11438__auto____1 = (function (state_66243){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_66243);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e66274){var ex__11441__auto__ = e66274;
var statearr_66275_66299 = state_66243;
(statearr_66275_66299[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_66243[(4)]))){
var statearr_66276_66300 = state_66243;
(statearr_66276_66300[(1)] = cljs.core.first((state_66243[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66301 = state_66243;
state_66243 = G__66301;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__11438__auto__ = function(state_66243){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__11438__auto____1.call(this,state_66243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_66277 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_66277[(6)] = c__11512__auto__);

return statearr_66277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_66340){
var state_val_66341 = (state_66340[(1)]);
if((state_val_66341 === (7))){
var inst_66308 = (state_66340[(7)]);
var state_66340__$1 = state_66340;
var statearr_66342_66366 = state_66340__$1;
(statearr_66342_66366[(2)] = inst_66308);

(statearr_66342_66366[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (1))){
var state_66340__$1 = state_66340;
var statearr_66343_66367 = state_66340__$1;
(statearr_66343_66367[(2)] = null);

(statearr_66343_66367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (4))){
var inst_66302 = (state_66340[(2)]);
var state_66340__$1 = state_66340;
var statearr_66344_66368 = state_66340__$1;
(statearr_66344_66368[(2)] = inst_66302);

(statearr_66344_66368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (6))){
var inst_66310 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_66340__$1 = state_66340;
var statearr_66345_66369 = state_66340__$1;
(statearr_66345_66369[(2)] = inst_66310);

(statearr_66345_66369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (3))){
var inst_66338 = (state_66340[(2)]);
var state_66340__$1 = state_66340;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66340__$1,inst_66338);
} else {
if((state_val_66341 === (12))){
var inst_66320 = (state_66340[(2)]);
var inst_66321 = fluree.db.util.async.throw_err(inst_66320);
var inst_66322 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66321,(0),null);
var inst_66323 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66321,(1),null);
var inst_66324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66325 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66326 = ["?pO","?ctx",inst_66322];
var inst_66327 = cljs.core.PersistentHashMap.fromArrays(inst_66325,inst_66326);
var inst_66328 = ((10) + inst_66323);
var inst_66329 = [inst_66327,inst_66328];
var inst_66330 = (new cljs.core.PersistentVector(null,2,(5),inst_66324,inst_66329,null));
var inst_66331 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66330);
var state_66340__$1 = (function (){var statearr_66346 = state_66340;
(statearr_66346[(8)] = inst_66331);

return statearr_66346;
})();
var statearr_66347_66370 = state_66340__$1;
(statearr_66347_66370[(2)] = inst_66322);

(statearr_66347_66370[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (2))){
var inst_66308 = (state_66340[(7)]);
var _ = (function (){var statearr_66348 = state_66340;
(statearr_66348[(4)] = cljs.core.cons((5),(state_66340[(4)])));

return statearr_66348;
})();
var inst_66308__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_66340__$1 = (function (){var statearr_66349 = state_66340;
(statearr_66349[(7)] = inst_66308__$1);

return statearr_66349;
})();
if(cljs.core.truth_(inst_66308__$1)){
var statearr_66350_66371 = state_66340__$1;
(statearr_66350_66371[(1)] = (6));

} else {
var statearr_66351_66372 = state_66340__$1;
(statearr_66351_66372[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (11))){
var inst_66335 = (state_66340[(2)]);
var _ = (function (){var statearr_66353 = state_66340;
(statearr_66353[(4)] = cljs.core.rest((state_66340[(4)])));

return statearr_66353;
})();
var state_66340__$1 = state_66340;
var statearr_66354_66373 = state_66340__$1;
(statearr_66354_66373[(2)] = inst_66335);

(statearr_66354_66373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (9))){
var inst_66318 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_66340__$1 = state_66340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66340__$1,(12),inst_66318);
} else {
if((state_val_66341 === (5))){
var _ = (function (){var statearr_66355 = state_66340;
(statearr_66355[(4)] = cljs.core.rest((state_66340[(4)])));

return statearr_66355;
})();
var state_66340__$1 = state_66340;
var ex66352 = (state_66340__$1[(2)]);
var statearr_66356_66374 = state_66340__$1;
(statearr_66356_66374[(5)] = ex66352);


if((ex66352 instanceof Error)){
var statearr_66357_66375 = state_66340__$1;
(statearr_66357_66375[(1)] = (4));

(statearr_66357_66375[(5)] = null);

} else {
throw ex66352;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (10))){
var inst_66333 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_66340__$1 = state_66340;
var statearr_66358_66376 = state_66340__$1;
(statearr_66358_66376[(2)] = inst_66333);

(statearr_66358_66376[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (8))){
var inst_66313 = (state_66340[(2)]);
var state_66340__$1 = state_66340;
if(cljs.core.truth_(inst_66313)){
var statearr_66359_66377 = state_66340__$1;
(statearr_66359_66377[(1)] = (9));

} else {
var statearr_66360_66378 = state_66340__$1;
(statearr_66360_66378[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11438__auto____0 = (function (){
var statearr_66361 = [null,null,null,null,null,null,null,null,null];
(statearr_66361[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11438__auto__);

(statearr_66361[(1)] = (1));

return statearr_66361;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11438__auto____1 = (function (state_66340){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_66340);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e66362){var ex__11441__auto__ = e66362;
var statearr_66363_66379 = state_66340;
(statearr_66363_66379[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_66340[(4)]))){
var statearr_66364_66380 = state_66340;
(statearr_66364_66380[(1)] = cljs.core.first((state_66340[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66381 = state_66340;
state_66340 = G__66381;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11438__auto__ = function(state_66340){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11438__auto____1.call(this,state_66340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_66365 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_66365[(6)] = c__11512__auto__);

return statearr_66365;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_66433){
var state_val_66434 = (state_66433[(1)]);
if((state_val_66434 === (7))){
var state_66433__$1 = state_66433;
var statearr_66435_66468 = state_66433__$1;
(statearr_66435_66468[(2)] = subject);

(statearr_66435_66468[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66434 === (1))){
var state_66433__$1 = state_66433;
var statearr_66436_66469 = state_66433__$1;
(statearr_66436_66469[(2)] = null);

(statearr_66436_66469[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66434 === (4))){
var inst_66382 = (state_66433[(2)]);
var state_66433__$1 = state_66433;
var statearr_66437_66470 = state_66433__$1;
(statearr_66437_66470[(2)] = inst_66382);

(statearr_66437_66470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66434 === (15))){
var inst_66395 = (state_66433[(7)]);
var state_66433__$1 = state_66433;
var statearr_66438_66471 = state_66433__$1;
(statearr_66438_66471[(2)] = inst_66395);

(statearr_66438_66471[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66434 === (13))){
var inst_66399 = (state_66433[(2)]);
var inst_66400 = fluree.db.util.async.throw_err(inst_66399);
var state_66433__$1 = state_66433;
var statearr_66439_66472 = state_66433__$1;
(statearr_66439_66472[(2)] = inst_66400);

(statearr_66439_66472[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66434 === (6))){
var state_66433__$1 = state_66433;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66433__$1,(9),subject);
} else {
if((state_val_66434 === (17))){
var inst_66395 = (state_66433[(7)]);
var inst_66409 = cljs.core.first(inst_66395);
var state_66433__$1 = state_66433;
var statearr_66440_66473 = state_66433__$1;
(statearr_66440_66473[(2)] = inst_66409);

(statearr_66440_66473[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66434 === (3))){
var inst_66431 = (state_66433[(2)]);
var state_66433__$1 = state_66433;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66433__$1,inst_66431);
} else {
if((state_val_66434 === (12))){
var inst_66395 = (state_66433[(7)]);
var inst_66403 = (state_66433[(2)]);
var inst_66404 = cljs.core.vector_QMARK_(inst_66395);
var state_66433__$1 = (function (){var statearr_66441 = state_66433;
(statearr_66441[(8)] = inst_66403);

return statearr_66441;
})();
if(inst_66404){
var statearr_66442_66474 = state_66433__$1;
(statearr_66442_66474[(1)] = (14));

} else {
var statearr_66443_66475 = state_66433__$1;
(statearr_66443_66475[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66434 === (2))){
var _ = (function (){var statearr_66444 = state_66433;
(statearr_66444[(4)] = cljs.core.cons((5),(state_66433[(4)])));

return statearr_66444;
})();
var inst_66388 = fluree.db.util.async.channel_QMARK_(subject);
var state_66433__$1 = state_66433;
if(inst_66388){
var statearr_66445_66476 = state_66433__$1;
(statearr_66445_66476[(1)] = (6));

} else {
var statearr_66446_66477 = state_66433__$1;
(statearr_66446_66477[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66434 === (19))){
var inst_66412 = (state_66433[(2)]);
var state_66433__$1 = state_66433;
var statearr_66447_66478 = state_66433__$1;
(statearr_66447_66478[(2)] = inst_66412);

(statearr_66447_66478[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66434 === (11))){
var state_66433__$1 = state_66433;
var statearr_66449_66479 = state_66433__$1;
(statearr_66449_66479[(2)] = path);

(statearr_66449_66479[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66434 === (9))){
var inst_66391 = (state_66433[(2)]);
var inst_66392 = fluree.db.util.async.throw_err(inst_66391);
var state_66433__$1 = state_66433;
var statearr_66450_66480 = state_66433__$1;
(statearr_66450_66480[(2)] = inst_66392);

(statearr_66450_66480[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66434 === (5))){
var _ = (function (){var statearr_66451 = state_66433;
(statearr_66451[(4)] = cljs.core.rest((state_66433[(4)])));

return statearr_66451;
})();
var state_66433__$1 = state_66433;
var ex66448 = (state_66433__$1[(2)]);
var statearr_66452_66481 = state_66433__$1;
(statearr_66452_66481[(5)] = ex66448);


if((ex66448 instanceof Error)){
var statearr_66453_66482 = state_66433__$1;
(statearr_66453_66482[(1)] = (4));

(statearr_66453_66482[(5)] = null);

} else {
throw ex66448;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66434 === (14))){
var inst_66395 = (state_66433[(7)]);
var inst_66406 = cljs.core.count(inst_66395);
var inst_66407 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_66406);
var state_66433__$1 = state_66433;
if(inst_66407){
var statearr_66454_66483 = state_66433__$1;
(statearr_66454_66483[(1)] = (17));

} else {
var statearr_66455_66484 = state_66433__$1;
(statearr_66455_66484[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66434 === (16))){
var inst_66403 = (state_66433[(8)]);
var inst_66395 = (state_66433[(7)]);
var inst_66415 = (state_66433[(2)]);
var inst_66416 = fluree.db.dbfunctions.internal.get_all(inst_66415,inst_66403);
var inst_66417 = cljs.core.count(inst_66403);
var inst_66418 = ((9) + inst_66417);
var inst_66419 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66420 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66422 = [inst_66395,inst_66403];
var inst_66423 = (new cljs.core.PersistentVector(null,2,(5),inst_66421,inst_66422,null));
var inst_66424 = ["get-all",inst_66423,inst_66416];
var inst_66425 = cljs.core.PersistentHashMap.fromArrays(inst_66420,inst_66424);
var inst_66426 = [inst_66425,inst_66418];
var inst_66427 = (new cljs.core.PersistentVector(null,2,(5),inst_66419,inst_66426,null));
var inst_66428 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66427);
var _ = (function (){var statearr_66456 = state_66433;
(statearr_66456[(4)] = cljs.core.rest((state_66433[(4)])));

return statearr_66456;
})();
var state_66433__$1 = (function (){var statearr_66457 = state_66433;
(statearr_66457[(9)] = inst_66428);

return statearr_66457;
})();
var statearr_66458_66485 = state_66433__$1;
(statearr_66458_66485[(2)] = inst_66416);

(statearr_66458_66485[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66434 === (10))){
var state_66433__$1 = state_66433;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66433__$1,(13),path);
} else {
if((state_val_66434 === (18))){
var inst_66395 = (state_66433[(7)]);
var state_66433__$1 = state_66433;
var statearr_66459_66486 = state_66433__$1;
(statearr_66459_66486[(2)] = inst_66395);

(statearr_66459_66486[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66434 === (8))){
var inst_66395 = (state_66433[(2)]);
var inst_66396 = fluree.db.util.async.channel_QMARK_(path);
var state_66433__$1 = (function (){var statearr_66460 = state_66433;
(statearr_66460[(7)] = inst_66395);

return statearr_66460;
})();
if(inst_66396){
var statearr_66461_66487 = state_66433__$1;
(statearr_66461_66487[(1)] = (10));

} else {
var statearr_66462_66488 = state_66433__$1;
(statearr_66462_66488[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__11438__auto____0 = (function (){
var statearr_66463 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66463[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__11438__auto__);

(statearr_66463[(1)] = (1));

return statearr_66463;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__11438__auto____1 = (function (state_66433){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_66433);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e66464){var ex__11441__auto__ = e66464;
var statearr_66465_66489 = state_66433;
(statearr_66465_66489[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_66433[(4)]))){
var statearr_66466_66490 = state_66433;
(statearr_66466_66490[(1)] = cljs.core.first((state_66433[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66491 = state_66433;
state_66433 = G__66491;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__11438__auto__ = function(state_66433){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__11438__auto____1.call(this,state_66433);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_66467 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_66467[(6)] = c__11512__auto__);

return statearr_66467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_66530){
var state_val_66531 = (state_66530[(1)]);
if((state_val_66531 === (7))){
var state_66530__$1 = state_66530;
var statearr_66532_66556 = state_66530__$1;
(statearr_66532_66556[(2)] = subject);

(statearr_66532_66556[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66531 === (1))){
var state_66530__$1 = state_66530;
var statearr_66533_66557 = state_66530__$1;
(statearr_66533_66557[(2)] = null);

(statearr_66533_66557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66531 === (4))){
var inst_66492 = (state_66530[(2)]);
var state_66530__$1 = state_66530;
var statearr_66534_66558 = state_66530__$1;
(statearr_66534_66558[(2)] = inst_66492);

(statearr_66534_66558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66531 === (13))){
var inst_66509 = (state_66530[(2)]);
var inst_66510 = fluree.db.util.async.throw_err(inst_66509);
var state_66530__$1 = state_66530;
var statearr_66535_66559 = state_66530__$1;
(statearr_66535_66559[(2)] = inst_66510);

(statearr_66535_66559[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66531 === (6))){
var state_66530__$1 = state_66530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66530__$1,(9),subject);
} else {
if((state_val_66531 === (3))){
var inst_66528 = (state_66530[(2)]);
var state_66530__$1 = state_66530;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66530__$1,inst_66528);
} else {
if((state_val_66531 === (12))){
var inst_66505 = (state_66530[(7)]);
var inst_66513 = (state_66530[(2)]);
var inst_66514 = fluree.db.dbfunctions.internal.get_in(inst_66505,inst_66513);
var inst_66515 = cljs.core.count(inst_66513);
var inst_66516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66517 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66519 = [inst_66505,inst_66513];
var inst_66520 = (new cljs.core.PersistentVector(null,2,(5),inst_66518,inst_66519,null));
var inst_66521 = ["get-in",inst_66520,inst_66514];
var inst_66522 = cljs.core.PersistentHashMap.fromArrays(inst_66517,inst_66521);
var inst_66523 = [inst_66522,inst_66515];
var inst_66524 = (new cljs.core.PersistentVector(null,2,(5),inst_66516,inst_66523,null));
var inst_66525 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66524);
var _ = (function (){var statearr_66536 = state_66530;
(statearr_66536[(4)] = cljs.core.rest((state_66530[(4)])));

return statearr_66536;
})();
var state_66530__$1 = (function (){var statearr_66537 = state_66530;
(statearr_66537[(8)] = inst_66525);

return statearr_66537;
})();
var statearr_66538_66560 = state_66530__$1;
(statearr_66538_66560[(2)] = inst_66514);

(statearr_66538_66560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66531 === (2))){
var _ = (function (){var statearr_66539 = state_66530;
(statearr_66539[(4)] = cljs.core.cons((5),(state_66530[(4)])));

return statearr_66539;
})();
var inst_66498 = fluree.db.util.async.channel_QMARK_(subject);
var state_66530__$1 = state_66530;
if(inst_66498){
var statearr_66540_66561 = state_66530__$1;
(statearr_66540_66561[(1)] = (6));

} else {
var statearr_66541_66562 = state_66530__$1;
(statearr_66541_66562[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66531 === (11))){
var state_66530__$1 = state_66530;
var statearr_66543_66563 = state_66530__$1;
(statearr_66543_66563[(2)] = path);

(statearr_66543_66563[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66531 === (9))){
var inst_66501 = (state_66530[(2)]);
var inst_66502 = fluree.db.util.async.throw_err(inst_66501);
var state_66530__$1 = state_66530;
var statearr_66544_66564 = state_66530__$1;
(statearr_66544_66564[(2)] = inst_66502);

(statearr_66544_66564[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66531 === (5))){
var _ = (function (){var statearr_66545 = state_66530;
(statearr_66545[(4)] = cljs.core.rest((state_66530[(4)])));

return statearr_66545;
})();
var state_66530__$1 = state_66530;
var ex66542 = (state_66530__$1[(2)]);
var statearr_66546_66565 = state_66530__$1;
(statearr_66546_66565[(5)] = ex66542);


if((ex66542 instanceof Error)){
var statearr_66547_66566 = state_66530__$1;
(statearr_66547_66566[(1)] = (4));

(statearr_66547_66566[(5)] = null);

} else {
throw ex66542;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66531 === (10))){
var state_66530__$1 = state_66530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66530__$1,(13),path);
} else {
if((state_val_66531 === (8))){
var inst_66505 = (state_66530[(2)]);
var inst_66506 = fluree.db.util.async.channel_QMARK_(path);
var state_66530__$1 = (function (){var statearr_66548 = state_66530;
(statearr_66548[(7)] = inst_66505);

return statearr_66548;
})();
if(inst_66506){
var statearr_66549_66567 = state_66530__$1;
(statearr_66549_66567[(1)] = (10));

} else {
var statearr_66550_66568 = state_66530__$1;
(statearr_66550_66568[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__11438__auto____0 = (function (){
var statearr_66551 = [null,null,null,null,null,null,null,null,null];
(statearr_66551[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__11438__auto__);

(statearr_66551[(1)] = (1));

return statearr_66551;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__11438__auto____1 = (function (state_66530){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_66530);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e66552){var ex__11441__auto__ = e66552;
var statearr_66553_66569 = state_66530;
(statearr_66553_66569[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_66530[(4)]))){
var statearr_66554_66570 = state_66530;
(statearr_66554_66570[(1)] = cljs.core.first((state_66530[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66571 = state_66530;
state_66530 = G__66571;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__11438__auto__ = function(state_66530){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__11438__auto____1.call(this,state_66530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_66555 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_66555[(6)] = c__11512__auto__);

return statearr_66555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_66616){
var state_val_66617 = (state_66616[(1)]);
if((state_val_66617 === (7))){
var state_66616__$1 = state_66616;
var statearr_66618_66647 = state_66616__$1;
(statearr_66618_66647[(2)] = coll);

(statearr_66618_66647[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66617 === (1))){
var state_66616__$1 = state_66616;
var statearr_66619_66648 = state_66616__$1;
(statearr_66619_66648[(2)] = null);

(statearr_66619_66648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66617 === (4))){
var inst_66572 = (state_66616[(2)]);
var state_66616__$1 = state_66616;
var statearr_66620_66649 = state_66616__$1;
(statearr_66620_66649[(2)] = inst_66572);

(statearr_66620_66649[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66617 === (15))){
var inst_66592 = (state_66616[(7)]);
var inst_66600 = (state_66616[(2)]);
var inst_66601 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_66592,inst_66600);
var inst_66602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66603 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66605 = [inst_66592,inst_66600];
var inst_66606 = (new cljs.core.PersistentVector(null,2,(5),inst_66604,inst_66605,null));
var inst_66607 = ["contains?",inst_66606,inst_66601];
var inst_66608 = cljs.core.PersistentHashMap.fromArrays(inst_66603,inst_66607);
var inst_66609 = [inst_66608,(10)];
var inst_66610 = (new cljs.core.PersistentVector(null,2,(5),inst_66602,inst_66609,null));
var inst_66611 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66610);
var _ = (function (){var statearr_66621 = state_66616;
(statearr_66621[(4)] = cljs.core.rest((state_66616[(4)])));

return statearr_66621;
})();
var state_66616__$1 = (function (){var statearr_66622 = state_66616;
(statearr_66622[(8)] = inst_66611);

return statearr_66622;
})();
var statearr_66623_66650 = state_66616__$1;
(statearr_66623_66650[(2)] = inst_66601);

(statearr_66623_66650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66617 === (13))){
var state_66616__$1 = state_66616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66616__$1,(16),key);
} else {
if((state_val_66617 === (6))){
var state_66616__$1 = state_66616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66616__$1,(9),coll);
} else {
if((state_val_66617 === (3))){
var inst_66614 = (state_66616[(2)]);
var state_66616__$1 = state_66616;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66616__$1,inst_66614);
} else {
if((state_val_66617 === (12))){
var inst_66592 = (state_66616[(2)]);
var inst_66593 = fluree.db.util.async.channel_QMARK_(key);
var state_66616__$1 = (function (){var statearr_66624 = state_66616;
(statearr_66624[(7)] = inst_66592);

return statearr_66624;
})();
if(inst_66593){
var statearr_66625_66651 = state_66616__$1;
(statearr_66625_66651[(1)] = (13));

} else {
var statearr_66626_66652 = state_66616__$1;
(statearr_66626_66652[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66617 === (2))){
var _ = (function (){var statearr_66627 = state_66616;
(statearr_66627[(4)] = cljs.core.cons((5),(state_66616[(4)])));

return statearr_66627;
})();
var inst_66578 = fluree.db.util.async.channel_QMARK_(coll);
var state_66616__$1 = state_66616;
if(inst_66578){
var statearr_66628_66653 = state_66616__$1;
(statearr_66628_66653[(1)] = (6));

} else {
var statearr_66629_66654 = state_66616__$1;
(statearr_66629_66654[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66617 === (11))){
var inst_66585 = (state_66616[(9)]);
var inst_66589 = cljs.core.flatten(inst_66585);
var inst_66590 = cljs.core.set(inst_66589);
var state_66616__$1 = state_66616;
var statearr_66631_66655 = state_66616__$1;
(statearr_66631_66655[(2)] = inst_66590);

(statearr_66631_66655[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66617 === (9))){
var inst_66581 = (state_66616[(2)]);
var inst_66582 = fluree.db.util.async.throw_err(inst_66581);
var state_66616__$1 = state_66616;
var statearr_66632_66656 = state_66616__$1;
(statearr_66632_66656[(2)] = inst_66582);

(statearr_66632_66656[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66617 === (5))){
var _ = (function (){var statearr_66633 = state_66616;
(statearr_66633[(4)] = cljs.core.rest((state_66616[(4)])));

return statearr_66633;
})();
var state_66616__$1 = state_66616;
var ex66630 = (state_66616__$1[(2)]);
var statearr_66634_66657 = state_66616__$1;
(statearr_66634_66657[(5)] = ex66630);


if((ex66630 instanceof Error)){
var statearr_66635_66658 = state_66616__$1;
(statearr_66635_66658[(1)] = (4));

(statearr_66635_66658[(5)] = null);

} else {
throw ex66630;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66617 === (14))){
var state_66616__$1 = state_66616;
var statearr_66636_66659 = state_66616__$1;
(statearr_66636_66659[(2)] = key);

(statearr_66636_66659[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66617 === (16))){
var inst_66596 = (state_66616[(2)]);
var inst_66597 = fluree.db.util.async.throw_err(inst_66596);
var state_66616__$1 = state_66616;
var statearr_66637_66660 = state_66616__$1;
(statearr_66637_66660[(2)] = inst_66597);

(statearr_66637_66660[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66617 === (10))){
var inst_66585 = (state_66616[(9)]);
var state_66616__$1 = state_66616;
var statearr_66638_66661 = state_66616__$1;
(statearr_66638_66661[(2)] = inst_66585);

(statearr_66638_66661[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66617 === (8))){
var inst_66585 = (state_66616[(9)]);
var inst_66585__$1 = (state_66616[(2)]);
var inst_66586 = cljs.core.set_QMARK_(inst_66585__$1);
var state_66616__$1 = (function (){var statearr_66639 = state_66616;
(statearr_66639[(9)] = inst_66585__$1);

return statearr_66639;
})();
if(inst_66586){
var statearr_66640_66662 = state_66616__$1;
(statearr_66640_66662[(1)] = (10));

} else {
var statearr_66641_66663 = state_66616__$1;
(statearr_66641_66663[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11438__auto____0 = (function (){
var statearr_66642 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66642[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11438__auto__);

(statearr_66642[(1)] = (1));

return statearr_66642;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11438__auto____1 = (function (state_66616){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_66616);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e66643){var ex__11441__auto__ = e66643;
var statearr_66644_66664 = state_66616;
(statearr_66644_66664[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_66616[(4)]))){
var statearr_66645_66665 = state_66616;
(statearr_66645_66665[(1)] = cljs.core.first((state_66616[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66666 = state_66616;
state_66616 = G__66666;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11438__auto__ = function(state_66616){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11438__auto____1.call(this,state_66616);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_66646 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_66646[(6)] = c__11512__auto__);

return statearr_66646;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5774__auto__ = [];
var len__5768__auto___66738 = arguments.length;
var i__5769__auto___66739 = (0);
while(true){
if((i__5769__auto___66739 < len__5768__auto___66738)){
args__5774__auto__.push((arguments[i__5769__auto___66739]));

var G__66740 = (i__5769__auto___66739 + (1));
i__5769__auto___66739 = G__66740;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_66712){
var state_val_66713 = (state_66712[(1)]);
if((state_val_66713 === (7))){
var inst_66678 = (state_66712[(7)]);
var inst_66682 = cljs.core.first(inst_66678);
var inst_66683 = cljs.core.coll_QMARK_(inst_66682);
var state_66712__$1 = state_66712;
var statearr_66714_66741 = state_66712__$1;
(statearr_66714_66741[(2)] = inst_66683);

(statearr_66714_66741[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66713 === (1))){
var state_66712__$1 = state_66712;
var statearr_66715_66742 = state_66712__$1;
(statearr_66715_66742[(2)] = null);

(statearr_66715_66742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66713 === (4))){
var inst_66669 = (state_66712[(2)]);
var state_66712__$1 = state_66712;
var statearr_66716_66743 = state_66712__$1;
(statearr_66716_66743[(2)] = inst_66669);

(statearr_66716_66743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66713 === (6))){
var inst_66678 = (state_66712[(7)]);
var inst_66680 = (state_66712[(8)]);
var inst_66677 = (state_66712[(2)]);
var inst_66678__$1 = fluree.db.util.async.throw_err(inst_66677);
var inst_66679 = cljs.core.count(inst_66678__$1);
var inst_66680__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_66679);
var state_66712__$1 = (function (){var statearr_66717 = state_66712;
(statearr_66717[(7)] = inst_66678__$1);

(statearr_66717[(8)] = inst_66680__$1);

return statearr_66717;
})();
if(inst_66680__$1){
var statearr_66718_66744 = state_66712__$1;
(statearr_66718_66744[(1)] = (7));

} else {
var statearr_66719_66745 = state_66712__$1;
(statearr_66719_66745[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66713 === (3))){
var inst_66710 = (state_66712[(2)]);
var state_66712__$1 = state_66712;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66712__$1,inst_66710);
} else {
if((state_val_66713 === (12))){
var inst_66691 = (state_66712[(2)]);
var inst_66692 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_66691);
var inst_66693 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66694 = [inst_66691];
var inst_66695 = (new cljs.core.PersistentVector(null,1,(5),inst_66693,inst_66694,null));
var inst_66696 = cljs.core.count(inst_66695);
var inst_66697 = ((9) + inst_66696);
var inst_66698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66699 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66701 = [inst_66691];
var inst_66702 = (new cljs.core.PersistentVector(null,1,(5),inst_66700,inst_66701,null));
var inst_66703 = ["hash-set",inst_66702,inst_66692];
var inst_66704 = cljs.core.PersistentHashMap.fromArrays(inst_66699,inst_66703);
var inst_66705 = [inst_66704,inst_66697];
var inst_66706 = (new cljs.core.PersistentVector(null,2,(5),inst_66698,inst_66705,null));
var inst_66707 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66706);
var _ = (function (){var statearr_66720 = state_66712;
(statearr_66720[(4)] = cljs.core.rest((state_66712[(4)])));

return statearr_66720;
})();
var state_66712__$1 = (function (){var statearr_66721 = state_66712;
(statearr_66721[(9)] = inst_66707);

return statearr_66721;
})();
var statearr_66722_66746 = state_66712__$1;
(statearr_66722_66746[(2)] = inst_66692);

(statearr_66722_66746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66713 === (2))){
var _ = (function (){var statearr_66723 = state_66712;
(statearr_66723[(4)] = cljs.core.cons((5),(state_66712[(4)])));

return statearr_66723;
})();
var inst_66675 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66712__$1 = state_66712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66712__$1,(6),inst_66675);
} else {
if((state_val_66713 === (11))){
var inst_66678 = (state_66712[(7)]);
var state_66712__$1 = state_66712;
var statearr_66725_66747 = state_66712__$1;
(statearr_66725_66747[(2)] = inst_66678);

(statearr_66725_66747[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66713 === (9))){
var inst_66686 = (state_66712[(2)]);
var state_66712__$1 = state_66712;
if(cljs.core.truth_(inst_66686)){
var statearr_66726_66748 = state_66712__$1;
(statearr_66726_66748[(1)] = (10));

} else {
var statearr_66727_66749 = state_66712__$1;
(statearr_66727_66749[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66713 === (5))){
var _ = (function (){var statearr_66728 = state_66712;
(statearr_66728[(4)] = cljs.core.rest((state_66712[(4)])));

return statearr_66728;
})();
var state_66712__$1 = state_66712;
var ex66724 = (state_66712__$1[(2)]);
var statearr_66729_66750 = state_66712__$1;
(statearr_66729_66750[(5)] = ex66724);


if((ex66724 instanceof Error)){
var statearr_66730_66751 = state_66712__$1;
(statearr_66730_66751[(1)] = (4));

(statearr_66730_66751[(5)] = null);

} else {
throw ex66724;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66713 === (10))){
var inst_66678 = (state_66712[(7)]);
var inst_66688 = cljs.core.first(inst_66678);
var state_66712__$1 = state_66712;
var statearr_66731_66752 = state_66712__$1;
(statearr_66731_66752[(2)] = inst_66688);

(statearr_66731_66752[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66713 === (8))){
var inst_66680 = (state_66712[(8)]);
var state_66712__$1 = state_66712;
var statearr_66732_66753 = state_66712__$1;
(statearr_66732_66753[(2)] = inst_66680);

(statearr_66732_66753[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_66733 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66733[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_66733[(1)] = (1));

return statearr_66733;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_66712){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_66712);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e66734){var ex__11441__auto__ = e66734;
var statearr_66735_66754 = state_66712;
(statearr_66735_66754[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_66712[(4)]))){
var statearr_66736_66755 = state_66712;
(statearr_66736_66755[(1)] = cljs.core.first((state_66712[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66756 = state_66712;
state_66712 = G__66756;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_66712){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_66712);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_66737 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_66737[(6)] = c__11512__auto__);

return statearr_66737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq66667){
var G__66668 = cljs.core.first(seq66667);
var seq66667__$1 = cljs.core.next(seq66667);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66668,seq66667__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___66806 = arguments.length;
var i__5769__auto___66807 = (0);
while(true){
if((i__5769__auto___66807 < len__5768__auto___66806)){
args__5774__auto__.push((arguments[i__5769__auto___66807]));

var G__66808 = (i__5769__auto___66807 + (1));
i__5769__auto___66807 = G__66808;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_66789){
var state_val_66790 = (state_66789[(1)]);
if((state_val_66790 === (1))){
var state_66789__$1 = state_66789;
var statearr_66791_66809 = state_66789__$1;
(statearr_66791_66809[(2)] = null);

(statearr_66791_66809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66790 === (2))){
var _ = (function (){var statearr_66792 = state_66789;
(statearr_66792[(4)] = cljs.core.cons((5),(state_66789[(4)])));

return statearr_66792;
})();
var inst_66765 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66789__$1 = state_66789;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66789__$1,(6),inst_66765);
} else {
if((state_val_66790 === (3))){
var inst_66787 = (state_66789[(2)]);
var state_66789__$1 = state_66789;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66789__$1,inst_66787);
} else {
if((state_val_66790 === (4))){
var inst_66759 = (state_66789[(2)]);
var state_66789__$1 = state_66789;
var statearr_66794_66810 = state_66789__$1;
(statearr_66794_66810[(2)] = inst_66759);

(statearr_66794_66810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66790 === (5))){
var _ = (function (){var statearr_66795 = state_66789;
(statearr_66795[(4)] = cljs.core.rest((state_66789[(4)])));

return statearr_66795;
})();
var state_66789__$1 = state_66789;
var ex66793 = (state_66789__$1[(2)]);
var statearr_66796_66811 = state_66789__$1;
(statearr_66796_66811[(5)] = ex66793);


if((ex66793 instanceof Error)){
var statearr_66797_66812 = state_66789__$1;
(statearr_66797_66812[(1)] = (4));

(statearr_66797_66812[(5)] = null);

} else {
throw ex66793;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66790 === (6))){
var inst_66767 = (state_66789[(2)]);
var inst_66768 = fluree.db.util.async.throw_err(inst_66767);
var inst_66769 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_66768);
var inst_66770 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66771 = [inst_66768];
var inst_66772 = (new cljs.core.PersistentVector(null,1,(5),inst_66770,inst_66771,null));
var inst_66773 = cljs.core.count(inst_66772);
var inst_66774 = ((9) + inst_66773);
var inst_66775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66776 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66778 = [inst_66768];
var inst_66779 = (new cljs.core.PersistentVector(null,1,(5),inst_66777,inst_66778,null));
var inst_66780 = ["==",inst_66779,inst_66769];
var inst_66781 = cljs.core.PersistentHashMap.fromArrays(inst_66776,inst_66780);
var inst_66782 = [inst_66781,inst_66774];
var inst_66783 = (new cljs.core.PersistentVector(null,2,(5),inst_66775,inst_66782,null));
var inst_66784 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66783);
var _ = (function (){var statearr_66798 = state_66789;
(statearr_66798[(4)] = cljs.core.rest((state_66789[(4)])));

return statearr_66798;
})();
var state_66789__$1 = (function (){var statearr_66799 = state_66789;
(statearr_66799[(7)] = inst_66784);

return statearr_66799;
})();
var statearr_66800_66813 = state_66789__$1;
(statearr_66800_66813[(2)] = inst_66769);

(statearr_66800_66813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_66801 = [null,null,null,null,null,null,null,null];
(statearr_66801[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_66801[(1)] = (1));

return statearr_66801;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_66789){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_66789);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e66802){var ex__11441__auto__ = e66802;
var statearr_66803_66814 = state_66789;
(statearr_66803_66814[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_66789[(4)]))){
var statearr_66804_66815 = state_66789;
(statearr_66804_66815[(1)] = cljs.core.first((state_66789[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66816 = state_66789;
state_66789 = G__66816;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_66789){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_66789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_66805 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_66805[(6)] = c__11512__auto__);

return statearr_66805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq66757){
var G__66758 = cljs.core.first(seq66757);
var seq66757__$1 = cljs.core.next(seq66757);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66758,seq66757__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___66866 = arguments.length;
var i__5769__auto___66867 = (0);
while(true){
if((i__5769__auto___66867 < len__5768__auto___66866)){
args__5774__auto__.push((arguments[i__5769__auto___66867]));

var G__66868 = (i__5769__auto___66867 + (1));
i__5769__auto___66867 = G__66868;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_66849){
var state_val_66850 = (state_66849[(1)]);
if((state_val_66850 === (1))){
var state_66849__$1 = state_66849;
var statearr_66851_66869 = state_66849__$1;
(statearr_66851_66869[(2)] = null);

(statearr_66851_66869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66850 === (2))){
var _ = (function (){var statearr_66852 = state_66849;
(statearr_66852[(4)] = cljs.core.cons((5),(state_66849[(4)])));

return statearr_66852;
})();
var inst_66825 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66849__$1 = state_66849;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66849__$1,(6),inst_66825);
} else {
if((state_val_66850 === (3))){
var inst_66847 = (state_66849[(2)]);
var state_66849__$1 = state_66849;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66849__$1,inst_66847);
} else {
if((state_val_66850 === (4))){
var inst_66819 = (state_66849[(2)]);
var state_66849__$1 = state_66849;
var statearr_66854_66870 = state_66849__$1;
(statearr_66854_66870[(2)] = inst_66819);

(statearr_66854_66870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66850 === (5))){
var _ = (function (){var statearr_66855 = state_66849;
(statearr_66855[(4)] = cljs.core.rest((state_66849[(4)])));

return statearr_66855;
})();
var state_66849__$1 = state_66849;
var ex66853 = (state_66849__$1[(2)]);
var statearr_66856_66871 = state_66849__$1;
(statearr_66856_66871[(5)] = ex66853);


if((ex66853 instanceof Error)){
var statearr_66857_66872 = state_66849__$1;
(statearr_66857_66872[(1)] = (4));

(statearr_66857_66872[(5)] = null);

} else {
throw ex66853;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66850 === (6))){
var inst_66827 = (state_66849[(2)]);
var inst_66828 = fluree.db.util.async.throw_err(inst_66827);
var inst_66829 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_66828);
var inst_66830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66831 = [inst_66828];
var inst_66832 = (new cljs.core.PersistentVector(null,1,(5),inst_66830,inst_66831,null));
var inst_66833 = cljs.core.count(inst_66832);
var inst_66834 = ((9) + inst_66833);
var inst_66835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66836 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66838 = [inst_66828];
var inst_66839 = (new cljs.core.PersistentVector(null,1,(5),inst_66837,inst_66838,null));
var inst_66840 = [">",inst_66839,inst_66829];
var inst_66841 = cljs.core.PersistentHashMap.fromArrays(inst_66836,inst_66840);
var inst_66842 = [inst_66841,inst_66834];
var inst_66843 = (new cljs.core.PersistentVector(null,2,(5),inst_66835,inst_66842,null));
var inst_66844 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66843);
var _ = (function (){var statearr_66858 = state_66849;
(statearr_66858[(4)] = cljs.core.rest((state_66849[(4)])));

return statearr_66858;
})();
var state_66849__$1 = (function (){var statearr_66859 = state_66849;
(statearr_66859[(7)] = inst_66844);

return statearr_66859;
})();
var statearr_66860_66873 = state_66849__$1;
(statearr_66860_66873[(2)] = inst_66829);

(statearr_66860_66873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_66861 = [null,null,null,null,null,null,null,null];
(statearr_66861[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_66861[(1)] = (1));

return statearr_66861;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_66849){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_66849);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e66862){var ex__11441__auto__ = e66862;
var statearr_66863_66874 = state_66849;
(statearr_66863_66874[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_66849[(4)]))){
var statearr_66864_66875 = state_66849;
(statearr_66864_66875[(1)] = cljs.core.first((state_66849[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66876 = state_66849;
state_66849 = G__66876;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_66849){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_66849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_66865 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_66865[(6)] = c__11512__auto__);

return statearr_66865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq66817){
var G__66818 = cljs.core.first(seq66817);
var seq66817__$1 = cljs.core.next(seq66817);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66818,seq66817__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___66926 = arguments.length;
var i__5769__auto___66927 = (0);
while(true){
if((i__5769__auto___66927 < len__5768__auto___66926)){
args__5774__auto__.push((arguments[i__5769__auto___66927]));

var G__66928 = (i__5769__auto___66927 + (1));
i__5769__auto___66927 = G__66928;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_66909){
var state_val_66910 = (state_66909[(1)]);
if((state_val_66910 === (1))){
var state_66909__$1 = state_66909;
var statearr_66911_66929 = state_66909__$1;
(statearr_66911_66929[(2)] = null);

(statearr_66911_66929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66910 === (2))){
var _ = (function (){var statearr_66912 = state_66909;
(statearr_66912[(4)] = cljs.core.cons((5),(state_66909[(4)])));

return statearr_66912;
})();
var inst_66885 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66909__$1 = state_66909;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66909__$1,(6),inst_66885);
} else {
if((state_val_66910 === (3))){
var inst_66907 = (state_66909[(2)]);
var state_66909__$1 = state_66909;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66909__$1,inst_66907);
} else {
if((state_val_66910 === (4))){
var inst_66879 = (state_66909[(2)]);
var state_66909__$1 = state_66909;
var statearr_66914_66930 = state_66909__$1;
(statearr_66914_66930[(2)] = inst_66879);

(statearr_66914_66930[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66910 === (5))){
var _ = (function (){var statearr_66915 = state_66909;
(statearr_66915[(4)] = cljs.core.rest((state_66909[(4)])));

return statearr_66915;
})();
var state_66909__$1 = state_66909;
var ex66913 = (state_66909__$1[(2)]);
var statearr_66916_66931 = state_66909__$1;
(statearr_66916_66931[(5)] = ex66913);


if((ex66913 instanceof Error)){
var statearr_66917_66932 = state_66909__$1;
(statearr_66917_66932[(1)] = (4));

(statearr_66917_66932[(5)] = null);

} else {
throw ex66913;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66910 === (6))){
var inst_66887 = (state_66909[(2)]);
var inst_66888 = fluree.db.util.async.throw_err(inst_66887);
var inst_66889 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_66888);
var inst_66890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66891 = [inst_66888];
var inst_66892 = (new cljs.core.PersistentVector(null,1,(5),inst_66890,inst_66891,null));
var inst_66893 = cljs.core.count(inst_66892);
var inst_66894 = ((9) + inst_66893);
var inst_66895 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66896 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66898 = [inst_66888];
var inst_66899 = (new cljs.core.PersistentVector(null,1,(5),inst_66897,inst_66898,null));
var inst_66900 = ["<",inst_66899,inst_66889];
var inst_66901 = cljs.core.PersistentHashMap.fromArrays(inst_66896,inst_66900);
var inst_66902 = [inst_66901,inst_66894];
var inst_66903 = (new cljs.core.PersistentVector(null,2,(5),inst_66895,inst_66902,null));
var inst_66904 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66903);
var _ = (function (){var statearr_66918 = state_66909;
(statearr_66918[(4)] = cljs.core.rest((state_66909[(4)])));

return statearr_66918;
})();
var state_66909__$1 = (function (){var statearr_66919 = state_66909;
(statearr_66919[(7)] = inst_66904);

return statearr_66919;
})();
var statearr_66920_66933 = state_66909__$1;
(statearr_66920_66933[(2)] = inst_66889);

(statearr_66920_66933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_66921 = [null,null,null,null,null,null,null,null];
(statearr_66921[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_66921[(1)] = (1));

return statearr_66921;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_66909){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_66909);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e66922){var ex__11441__auto__ = e66922;
var statearr_66923_66934 = state_66909;
(statearr_66923_66934[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_66909[(4)]))){
var statearr_66924_66935 = state_66909;
(statearr_66924_66935[(1)] = cljs.core.first((state_66909[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66936 = state_66909;
state_66909 = G__66936;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_66909){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_66909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_66925 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_66925[(6)] = c__11512__auto__);

return statearr_66925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq66877){
var G__66878 = cljs.core.first(seq66877);
var seq66877__$1 = cljs.core.next(seq66877);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66878,seq66877__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___66986 = arguments.length;
var i__5769__auto___66987 = (0);
while(true){
if((i__5769__auto___66987 < len__5768__auto___66986)){
args__5774__auto__.push((arguments[i__5769__auto___66987]));

var G__66988 = (i__5769__auto___66987 + (1));
i__5769__auto___66987 = G__66988;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_66969){
var state_val_66970 = (state_66969[(1)]);
if((state_val_66970 === (1))){
var state_66969__$1 = state_66969;
var statearr_66971_66989 = state_66969__$1;
(statearr_66971_66989[(2)] = null);

(statearr_66971_66989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66970 === (2))){
var _ = (function (){var statearr_66972 = state_66969;
(statearr_66972[(4)] = cljs.core.cons((5),(state_66969[(4)])));

return statearr_66972;
})();
var inst_66945 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66969__$1 = state_66969;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66969__$1,(6),inst_66945);
} else {
if((state_val_66970 === (3))){
var inst_66967 = (state_66969[(2)]);
var state_66969__$1 = state_66969;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66969__$1,inst_66967);
} else {
if((state_val_66970 === (4))){
var inst_66939 = (state_66969[(2)]);
var state_66969__$1 = state_66969;
var statearr_66974_66990 = state_66969__$1;
(statearr_66974_66990[(2)] = inst_66939);

(statearr_66974_66990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66970 === (5))){
var _ = (function (){var statearr_66975 = state_66969;
(statearr_66975[(4)] = cljs.core.rest((state_66969[(4)])));

return statearr_66975;
})();
var state_66969__$1 = state_66969;
var ex66973 = (state_66969__$1[(2)]);
var statearr_66976_66991 = state_66969__$1;
(statearr_66976_66991[(5)] = ex66973);


if((ex66973 instanceof Error)){
var statearr_66977_66992 = state_66969__$1;
(statearr_66977_66992[(1)] = (4));

(statearr_66977_66992[(5)] = null);

} else {
throw ex66973;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66970 === (6))){
var inst_66947 = (state_66969[(2)]);
var inst_66948 = fluree.db.util.async.throw_err(inst_66947);
var inst_66949 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_66948);
var inst_66950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66951 = [inst_66948];
var inst_66952 = (new cljs.core.PersistentVector(null,1,(5),inst_66950,inst_66951,null));
var inst_66953 = cljs.core.count(inst_66952);
var inst_66954 = ((9) + inst_66953);
var inst_66955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66956 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66958 = [inst_66948];
var inst_66959 = (new cljs.core.PersistentVector(null,1,(5),inst_66957,inst_66958,null));
var inst_66960 = ["<=",inst_66959,inst_66949];
var inst_66961 = cljs.core.PersistentHashMap.fromArrays(inst_66956,inst_66960);
var inst_66962 = [inst_66961,inst_66954];
var inst_66963 = (new cljs.core.PersistentVector(null,2,(5),inst_66955,inst_66962,null));
var inst_66964 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66963);
var _ = (function (){var statearr_66978 = state_66969;
(statearr_66978[(4)] = cljs.core.rest((state_66969[(4)])));

return statearr_66978;
})();
var state_66969__$1 = (function (){var statearr_66979 = state_66969;
(statearr_66979[(7)] = inst_66964);

return statearr_66979;
})();
var statearr_66980_66993 = state_66969__$1;
(statearr_66980_66993[(2)] = inst_66949);

(statearr_66980_66993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_66981 = [null,null,null,null,null,null,null,null];
(statearr_66981[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_66981[(1)] = (1));

return statearr_66981;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_66969){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_66969);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e66982){var ex__11441__auto__ = e66982;
var statearr_66983_66994 = state_66969;
(statearr_66983_66994[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_66969[(4)]))){
var statearr_66984_66995 = state_66969;
(statearr_66984_66995[(1)] = cljs.core.first((state_66969[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66996 = state_66969;
state_66969 = G__66996;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_66969){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_66969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_66985 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_66985[(6)] = c__11512__auto__);

return statearr_66985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq66937){
var G__66938 = cljs.core.first(seq66937);
var seq66937__$1 = cljs.core.next(seq66937);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66938,seq66937__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___67046 = arguments.length;
var i__5769__auto___67047 = (0);
while(true){
if((i__5769__auto___67047 < len__5768__auto___67046)){
args__5774__auto__.push((arguments[i__5769__auto___67047]));

var G__67048 = (i__5769__auto___67047 + (1));
i__5769__auto___67047 = G__67048;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_67029){
var state_val_67030 = (state_67029[(1)]);
if((state_val_67030 === (1))){
var state_67029__$1 = state_67029;
var statearr_67031_67049 = state_67029__$1;
(statearr_67031_67049[(2)] = null);

(statearr_67031_67049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67030 === (2))){
var _ = (function (){var statearr_67032 = state_67029;
(statearr_67032[(4)] = cljs.core.cons((5),(state_67029[(4)])));

return statearr_67032;
})();
var inst_67005 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67029__$1 = state_67029;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67029__$1,(6),inst_67005);
} else {
if((state_val_67030 === (3))){
var inst_67027 = (state_67029[(2)]);
var state_67029__$1 = state_67029;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67029__$1,inst_67027);
} else {
if((state_val_67030 === (4))){
var inst_66999 = (state_67029[(2)]);
var state_67029__$1 = state_67029;
var statearr_67034_67050 = state_67029__$1;
(statearr_67034_67050[(2)] = inst_66999);

(statearr_67034_67050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67030 === (5))){
var _ = (function (){var statearr_67035 = state_67029;
(statearr_67035[(4)] = cljs.core.rest((state_67029[(4)])));

return statearr_67035;
})();
var state_67029__$1 = state_67029;
var ex67033 = (state_67029__$1[(2)]);
var statearr_67036_67051 = state_67029__$1;
(statearr_67036_67051[(5)] = ex67033);


if((ex67033 instanceof Error)){
var statearr_67037_67052 = state_67029__$1;
(statearr_67037_67052[(1)] = (4));

(statearr_67037_67052[(5)] = null);

} else {
throw ex67033;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67030 === (6))){
var inst_67007 = (state_67029[(2)]);
var inst_67008 = fluree.db.util.async.throw_err(inst_67007);
var inst_67009 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_67008);
var inst_67010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67011 = [inst_67008];
var inst_67012 = (new cljs.core.PersistentVector(null,1,(5),inst_67010,inst_67011,null));
var inst_67013 = cljs.core.count(inst_67012);
var inst_67014 = ((9) + inst_67013);
var inst_67015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67016 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67018 = [inst_67008];
var inst_67019 = (new cljs.core.PersistentVector(null,1,(5),inst_67017,inst_67018,null));
var inst_67020 = [">=",inst_67019,inst_67009];
var inst_67021 = cljs.core.PersistentHashMap.fromArrays(inst_67016,inst_67020);
var inst_67022 = [inst_67021,inst_67014];
var inst_67023 = (new cljs.core.PersistentVector(null,2,(5),inst_67015,inst_67022,null));
var inst_67024 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67023);
var _ = (function (){var statearr_67038 = state_67029;
(statearr_67038[(4)] = cljs.core.rest((state_67029[(4)])));

return statearr_67038;
})();
var state_67029__$1 = (function (){var statearr_67039 = state_67029;
(statearr_67039[(7)] = inst_67024);

return statearr_67039;
})();
var statearr_67040_67053 = state_67029__$1;
(statearr_67040_67053[(2)] = inst_67009);

(statearr_67040_67053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_67041 = [null,null,null,null,null,null,null,null];
(statearr_67041[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_67041[(1)] = (1));

return statearr_67041;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_67029){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_67029);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e67042){var ex__11441__auto__ = e67042;
var statearr_67043_67054 = state_67029;
(statearr_67043_67054[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_67029[(4)]))){
var statearr_67044_67055 = state_67029;
(statearr_67044_67055[(1)] = cljs.core.first((state_67029[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67056 = state_67029;
state_67029 = G__67056;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_67029){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_67029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_67045 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_67045[(6)] = c__11512__auto__);

return statearr_67045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq66997){
var G__66998 = cljs.core.first(seq66997);
var seq66997__$1 = cljs.core.next(seq66997);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66998,seq66997__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___67106 = arguments.length;
var i__5769__auto___67107 = (0);
while(true){
if((i__5769__auto___67107 < len__5768__auto___67106)){
args__5774__auto__.push((arguments[i__5769__auto___67107]));

var G__67108 = (i__5769__auto___67107 + (1));
i__5769__auto___67107 = G__67108;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_67089){
var state_val_67090 = (state_67089[(1)]);
if((state_val_67090 === (1))){
var state_67089__$1 = state_67089;
var statearr_67091_67109 = state_67089__$1;
(statearr_67091_67109[(2)] = null);

(statearr_67091_67109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67090 === (2))){
var _ = (function (){var statearr_67092 = state_67089;
(statearr_67092[(4)] = cljs.core.cons((5),(state_67089[(4)])));

return statearr_67092;
})();
var inst_67065 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67089__$1 = state_67089;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67089__$1,(6),inst_67065);
} else {
if((state_val_67090 === (3))){
var inst_67087 = (state_67089[(2)]);
var state_67089__$1 = state_67089;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67089__$1,inst_67087);
} else {
if((state_val_67090 === (4))){
var inst_67059 = (state_67089[(2)]);
var state_67089__$1 = state_67089;
var statearr_67094_67110 = state_67089__$1;
(statearr_67094_67110[(2)] = inst_67059);

(statearr_67094_67110[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67090 === (5))){
var _ = (function (){var statearr_67095 = state_67089;
(statearr_67095[(4)] = cljs.core.rest((state_67089[(4)])));

return statearr_67095;
})();
var state_67089__$1 = state_67089;
var ex67093 = (state_67089__$1[(2)]);
var statearr_67096_67111 = state_67089__$1;
(statearr_67096_67111[(5)] = ex67093);


if((ex67093 instanceof Error)){
var statearr_67097_67112 = state_67089__$1;
(statearr_67097_67112[(1)] = (4));

(statearr_67097_67112[(5)] = null);

} else {
throw ex67093;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67090 === (6))){
var inst_67067 = (state_67089[(2)]);
var inst_67068 = fluree.db.util.async.throw_err(inst_67067);
var inst_67069 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_67068);
var inst_67070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67071 = [inst_67068];
var inst_67072 = (new cljs.core.PersistentVector(null,1,(5),inst_67070,inst_67071,null));
var inst_67073 = cljs.core.count(inst_67072);
var inst_67074 = ((9) + inst_67073);
var inst_67075 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67076 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67078 = [inst_67068];
var inst_67079 = (new cljs.core.PersistentVector(null,1,(5),inst_67077,inst_67078,null));
var inst_67080 = ["not=",inst_67079,inst_67069];
var inst_67081 = cljs.core.PersistentHashMap.fromArrays(inst_67076,inst_67080);
var inst_67082 = [inst_67081,inst_67074];
var inst_67083 = (new cljs.core.PersistentVector(null,2,(5),inst_67075,inst_67082,null));
var inst_67084 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67083);
var _ = (function (){var statearr_67098 = state_67089;
(statearr_67098[(4)] = cljs.core.rest((state_67089[(4)])));

return statearr_67098;
})();
var state_67089__$1 = (function (){var statearr_67099 = state_67089;
(statearr_67099[(7)] = inst_67084);

return statearr_67099;
})();
var statearr_67100_67113 = state_67089__$1;
(statearr_67100_67113[(2)] = inst_67069);

(statearr_67100_67113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_67101 = [null,null,null,null,null,null,null,null];
(statearr_67101[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_67101[(1)] = (1));

return statearr_67101;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_67089){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_67089);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e67102){var ex__11441__auto__ = e67102;
var statearr_67103_67114 = state_67089;
(statearr_67103_67114[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_67089[(4)]))){
var statearr_67104_67115 = state_67089;
(statearr_67104_67115[(1)] = cljs.core.first((state_67089[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67116 = state_67089;
state_67089 = G__67116;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_67089){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_67089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_67105 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_67105[(6)] = c__11512__auto__);

return statearr_67105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq67057){
var G__67058 = cljs.core.first(seq67057);
var seq67057__$1 = cljs.core.next(seq67057);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67058,seq67057__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5774__auto__ = [];
var len__5768__auto___67166 = arguments.length;
var i__5769__auto___67167 = (0);
while(true){
if((i__5769__auto___67167 < len__5768__auto___67166)){
args__5774__auto__.push((arguments[i__5769__auto___67167]));

var G__67168 = (i__5769__auto___67167 + (1));
i__5769__auto___67167 = G__67168;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_67149){
var state_val_67150 = (state_67149[(1)]);
if((state_val_67150 === (1))){
var state_67149__$1 = state_67149;
var statearr_67151_67169 = state_67149__$1;
(statearr_67151_67169[(2)] = null);

(statearr_67151_67169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67150 === (2))){
var _ = (function (){var statearr_67152 = state_67149;
(statearr_67152[(4)] = cljs.core.cons((5),(state_67149[(4)])));

return statearr_67152;
})();
var inst_67125 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67149__$1 = state_67149;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67149__$1,(6),inst_67125);
} else {
if((state_val_67150 === (3))){
var inst_67147 = (state_67149[(2)]);
var state_67149__$1 = state_67149;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67149__$1,inst_67147);
} else {
if((state_val_67150 === (4))){
var inst_67119 = (state_67149[(2)]);
var state_67149__$1 = state_67149;
var statearr_67154_67170 = state_67149__$1;
(statearr_67154_67170[(2)] = inst_67119);

(statearr_67154_67170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67150 === (5))){
var _ = (function (){var statearr_67155 = state_67149;
(statearr_67155[(4)] = cljs.core.rest((state_67149[(4)])));

return statearr_67155;
})();
var state_67149__$1 = state_67149;
var ex67153 = (state_67149__$1[(2)]);
var statearr_67156_67171 = state_67149__$1;
(statearr_67156_67171[(5)] = ex67153);


if((ex67153 instanceof Error)){
var statearr_67157_67172 = state_67149__$1;
(statearr_67157_67172[(1)] = (4));

(statearr_67157_67172[(5)] = null);

} else {
throw ex67153;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67150 === (6))){
var inst_67127 = (state_67149[(2)]);
var inst_67128 = fluree.db.util.async.throw_err(inst_67127);
var inst_67129 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_67128);
var inst_67130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67131 = [inst_67128];
var inst_67132 = (new cljs.core.PersistentVector(null,1,(5),inst_67130,inst_67131,null));
var inst_67133 = cljs.core.count(inst_67132);
var inst_67134 = ((9) + inst_67133);
var inst_67135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67136 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67138 = [inst_67128];
var inst_67139 = (new cljs.core.PersistentVector(null,1,(5),inst_67137,inst_67138,null));
var inst_67140 = ["max",inst_67139,inst_67129];
var inst_67141 = cljs.core.PersistentHashMap.fromArrays(inst_67136,inst_67140);
var inst_67142 = [inst_67141,inst_67134];
var inst_67143 = (new cljs.core.PersistentVector(null,2,(5),inst_67135,inst_67142,null));
var inst_67144 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67143);
var _ = (function (){var statearr_67158 = state_67149;
(statearr_67158[(4)] = cljs.core.rest((state_67149[(4)])));

return statearr_67158;
})();
var state_67149__$1 = (function (){var statearr_67159 = state_67149;
(statearr_67159[(7)] = inst_67144);

return statearr_67159;
})();
var statearr_67160_67173 = state_67149__$1;
(statearr_67160_67173[(2)] = inst_67129);

(statearr_67160_67173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_67161 = [null,null,null,null,null,null,null,null];
(statearr_67161[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_67161[(1)] = (1));

return statearr_67161;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_67149){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_67149);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e67162){var ex__11441__auto__ = e67162;
var statearr_67163_67174 = state_67149;
(statearr_67163_67174[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_67149[(4)]))){
var statearr_67164_67175 = state_67149;
(statearr_67164_67175[(1)] = cljs.core.first((state_67149[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67176 = state_67149;
state_67149 = G__67176;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_67149){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_67149);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_67165 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_67165[(6)] = c__11512__auto__);

return statearr_67165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq67117){
var G__67118 = cljs.core.first(seq67117);
var seq67117__$1 = cljs.core.next(seq67117);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67118,seq67117__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5774__auto__ = [];
var len__5768__auto___67226 = arguments.length;
var i__5769__auto___67227 = (0);
while(true){
if((i__5769__auto___67227 < len__5768__auto___67226)){
args__5774__auto__.push((arguments[i__5769__auto___67227]));

var G__67228 = (i__5769__auto___67227 + (1));
i__5769__auto___67227 = G__67228;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_67209){
var state_val_67210 = (state_67209[(1)]);
if((state_val_67210 === (1))){
var state_67209__$1 = state_67209;
var statearr_67211_67229 = state_67209__$1;
(statearr_67211_67229[(2)] = null);

(statearr_67211_67229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67210 === (2))){
var _ = (function (){var statearr_67212 = state_67209;
(statearr_67212[(4)] = cljs.core.cons((5),(state_67209[(4)])));

return statearr_67212;
})();
var inst_67185 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67209__$1 = state_67209;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67209__$1,(6),inst_67185);
} else {
if((state_val_67210 === (3))){
var inst_67207 = (state_67209[(2)]);
var state_67209__$1 = state_67209;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67209__$1,inst_67207);
} else {
if((state_val_67210 === (4))){
var inst_67179 = (state_67209[(2)]);
var state_67209__$1 = state_67209;
var statearr_67214_67230 = state_67209__$1;
(statearr_67214_67230[(2)] = inst_67179);

(statearr_67214_67230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67210 === (5))){
var _ = (function (){var statearr_67215 = state_67209;
(statearr_67215[(4)] = cljs.core.rest((state_67209[(4)])));

return statearr_67215;
})();
var state_67209__$1 = state_67209;
var ex67213 = (state_67209__$1[(2)]);
var statearr_67216_67231 = state_67209__$1;
(statearr_67216_67231[(5)] = ex67213);


if((ex67213 instanceof Error)){
var statearr_67217_67232 = state_67209__$1;
(statearr_67217_67232[(1)] = (4));

(statearr_67217_67232[(5)] = null);

} else {
throw ex67213;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67210 === (6))){
var inst_67187 = (state_67209[(2)]);
var inst_67188 = fluree.db.util.async.throw_err(inst_67187);
var inst_67189 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_67188);
var inst_67190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67191 = [inst_67188];
var inst_67192 = (new cljs.core.PersistentVector(null,1,(5),inst_67190,inst_67191,null));
var inst_67193 = cljs.core.count(inst_67192);
var inst_67194 = ((9) + inst_67193);
var inst_67195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67196 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67198 = [inst_67188];
var inst_67199 = (new cljs.core.PersistentVector(null,1,(5),inst_67197,inst_67198,null));
var inst_67200 = ["min",inst_67199,inst_67189];
var inst_67201 = cljs.core.PersistentHashMap.fromArrays(inst_67196,inst_67200);
var inst_67202 = [inst_67201,inst_67194];
var inst_67203 = (new cljs.core.PersistentVector(null,2,(5),inst_67195,inst_67202,null));
var inst_67204 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67203);
var _ = (function (){var statearr_67218 = state_67209;
(statearr_67218[(4)] = cljs.core.rest((state_67209[(4)])));

return statearr_67218;
})();
var state_67209__$1 = (function (){var statearr_67219 = state_67209;
(statearr_67219[(7)] = inst_67204);

return statearr_67219;
})();
var statearr_67220_67233 = state_67209__$1;
(statearr_67220_67233[(2)] = inst_67189);

(statearr_67220_67233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_67221 = [null,null,null,null,null,null,null,null];
(statearr_67221[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_67221[(1)] = (1));

return statearr_67221;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_67209){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_67209);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e67222){var ex__11441__auto__ = e67222;
var statearr_67223_67234 = state_67209;
(statearr_67223_67234[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_67209[(4)]))){
var statearr_67224_67235 = state_67209;
(statearr_67224_67235[(1)] = cljs.core.first((state_67209[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67236 = state_67209;
state_67209 = G__67236;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_67209){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_67209);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_67225 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_67225[(6)] = c__11512__auto__);

return statearr_67225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq67177){
var G__67178 = cljs.core.first(seq67177);
var seq67177__$1 = cljs.core.next(seq67177);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67178,seq67177__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__67238 = arguments.length;
switch (G__67238) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_67283){
var state_val_67284 = (state_67283[(1)]);
if((state_val_67284 === (7))){
var state_67283__$1 = state_67283;
var statearr_67285_67422 = state_67283__$1;
(statearr_67285_67422[(2)] = query_map);

(statearr_67285_67422[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67284 === (1))){
var state_67283__$1 = state_67283;
var statearr_67286_67423 = state_67283__$1;
(statearr_67286_67423[(2)] = null);

(statearr_67286_67423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67284 === (4))){
var inst_67239 = (state_67283[(2)]);
var state_67283__$1 = state_67283;
var statearr_67287_67424 = state_67283__$1;
(statearr_67287_67424[(2)] = inst_67239);

(statearr_67287_67424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67284 === (13))){
var inst_67261 = (state_67283[(7)]);
var inst_67265 = (state_67283[(2)]);
var inst_67266 = fluree.db.util.async.throw_err(inst_67265);
var inst_67267 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67266,(0),null);
var inst_67268 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67266,(1),null);
var inst_67269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67270 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67272 = [inst_67261];
var inst_67273 = (new cljs.core.PersistentVector(null,1,(5),inst_67271,inst_67272,null));
var inst_67274 = ["query",inst_67273,inst_67267];
var inst_67275 = cljs.core.PersistentHashMap.fromArrays(inst_67270,inst_67274);
var inst_67276 = [inst_67275,inst_67268];
var inst_67277 = (new cljs.core.PersistentVector(null,2,(5),inst_67269,inst_67276,null));
var inst_67278 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67277);
var _ = (function (){var statearr_67288 = state_67283;
(statearr_67288[(4)] = cljs.core.rest((state_67283[(4)])));

return statearr_67288;
})();
var state_67283__$1 = (function (){var statearr_67289 = state_67283;
(statearr_67289[(8)] = inst_67278);

return statearr_67289;
})();
var statearr_67290_67425 = state_67283__$1;
(statearr_67290_67425[(2)] = inst_67267);

(statearr_67290_67425[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67284 === (6))){
var state_67283__$1 = state_67283;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67283__$1,(9),query_map);
} else {
if((state_val_67284 === (3))){
var inst_67281 = (state_67283[(2)]);
var state_67283__$1 = state_67283;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67283__$1,inst_67281);
} else {
if((state_val_67284 === (12))){
var inst_67261 = (state_67283[(7)]);
var inst_67261__$1 = (state_67283[(2)]);
var inst_67262 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_67263 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_67262,inst_67261__$1);
var state_67283__$1 = (function (){var statearr_67291 = state_67283;
(statearr_67291[(7)] = inst_67261__$1);

return statearr_67291;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67283__$1,(13),inst_67263);
} else {
if((state_val_67284 === (2))){
var _ = (function (){var statearr_67292 = state_67283;
(statearr_67292[(4)] = cljs.core.cons((5),(state_67283[(4)])));

return statearr_67292;
})();
var inst_67248 = fluree.db.util.async.channel_QMARK_(query_map);
var state_67283__$1 = state_67283;
if(inst_67248){
var statearr_67293_67426 = state_67283__$1;
(statearr_67293_67426[(1)] = (6));

} else {
var statearr_67294_67427 = state_67283__$1;
(statearr_67294_67427[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67284 === (11))){
var inst_67255 = (state_67283[(9)]);
var state_67283__$1 = state_67283;
var statearr_67296_67428 = state_67283__$1;
(statearr_67296_67428[(2)] = inst_67255);

(statearr_67296_67428[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67284 === (9))){
var inst_67251 = (state_67283[(2)]);
var inst_67252 = fluree.db.util.async.throw_err(inst_67251);
var state_67283__$1 = state_67283;
var statearr_67297_67429 = state_67283__$1;
(statearr_67297_67429[(2)] = inst_67252);

(statearr_67297_67429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67284 === (5))){
var _ = (function (){var statearr_67298 = state_67283;
(statearr_67298[(4)] = cljs.core.rest((state_67283[(4)])));

return statearr_67298;
})();
var state_67283__$1 = state_67283;
var ex67295 = (state_67283__$1[(2)]);
var statearr_67299_67430 = state_67283__$1;
(statearr_67299_67430[(5)] = ex67295);


if((ex67295 instanceof Error)){
var statearr_67300_67431 = state_67283__$1;
(statearr_67300_67431[(1)] = (4));

(statearr_67300_67431[(5)] = null);

} else {
throw ex67295;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67284 === (10))){
var inst_67255 = (state_67283[(9)]);
var inst_67258 = fluree.db.util.json.parse(inst_67255);
var state_67283__$1 = state_67283;
var statearr_67301_67432 = state_67283__$1;
(statearr_67301_67432[(2)] = inst_67258);

(statearr_67301_67432[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67284 === (8))){
var inst_67255 = (state_67283[(9)]);
var inst_67255__$1 = (state_67283[(2)]);
var inst_67256 = typeof inst_67255__$1 === 'string';
var state_67283__$1 = (function (){var statearr_67302 = state_67283;
(statearr_67302[(9)] = inst_67255__$1);

return statearr_67302;
})();
if(cljs.core.truth_(inst_67256)){
var statearr_67303_67433 = state_67283__$1;
(statearr_67303_67433[(1)] = (10));

} else {
var statearr_67304_67434 = state_67283__$1;
(statearr_67304_67434[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_67305 = [null,null,null,null,null,null,null,null,null,null];
(statearr_67305[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_67305[(1)] = (1));

return statearr_67305;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_67283){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_67283);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e67306){var ex__11441__auto__ = e67306;
var statearr_67307_67435 = state_67283;
(statearr_67307_67435[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_67283[(4)]))){
var statearr_67308_67436 = state_67283;
(statearr_67308_67436[(1)] = cljs.core.first((state_67283[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67437 = state_67283;
state_67283 = G__67437;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_67283){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_67283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_67309 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_67309[(6)] = c__11512__auto__);

return statearr_67309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_67380){
var state_val_67381 = (state_67380[(1)]);
if((state_val_67381 === (7))){
var state_67380__$1 = state_67380;
var statearr_67382_67438 = state_67380__$1;
(statearr_67382_67438[(2)] = select);

(statearr_67382_67438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (20))){
var inst_67350 = (state_67380[(2)]);
var inst_67351 = fluree.db.util.async.channel_QMARK_(limit);
var state_67380__$1 = (function (){var statearr_67383 = state_67380;
(statearr_67383[(7)] = inst_67350);

return statearr_67383;
})();
if(inst_67351){
var statearr_67384_67439 = state_67380__$1;
(statearr_67384_67439[(1)] = (22));

} else {
var statearr_67385_67440 = state_67380__$1;
(statearr_67385_67440[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (1))){
var state_67380__$1 = state_67380;
var statearr_67386_67441 = state_67380__$1;
(statearr_67386_67441[(2)] = null);

(statearr_67386_67441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (24))){
var inst_67342 = (state_67380[(8)]);
var inst_67334 = (state_67380[(9)]);
var inst_67326 = (state_67380[(10)]);
var inst_67350 = (state_67380[(7)]);
var inst_67358 = (state_67380[(2)]);
var inst_67359 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_67360 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_67359,inst_67326,inst_67334,inst_67342,inst_67350,inst_67358);
var state_67380__$1 = state_67380;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67380__$1,(26),inst_67360);
} else {
if((state_val_67381 === (4))){
var inst_67310 = (state_67380[(2)]);
var state_67380__$1 = state_67380;
var statearr_67387_67442 = state_67380__$1;
(statearr_67387_67442[(2)] = inst_67310);

(statearr_67387_67442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (15))){
var state_67380__$1 = state_67380;
var statearr_67388_67443 = state_67380__$1;
(statearr_67388_67443[(2)] = where);

(statearr_67388_67443[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (21))){
var inst_67346 = (state_67380[(2)]);
var inst_67347 = fluree.db.util.async.throw_err(inst_67346);
var state_67380__$1 = state_67380;
var statearr_67389_67444 = state_67380__$1;
(statearr_67389_67444[(2)] = inst_67347);

(statearr_67389_67444[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (13))){
var inst_67330 = (state_67380[(2)]);
var inst_67331 = fluree.db.util.async.throw_err(inst_67330);
var state_67380__$1 = state_67380;
var statearr_67390_67445 = state_67380__$1;
(statearr_67390_67445[(2)] = inst_67331);

(statearr_67390_67445[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (22))){
var state_67380__$1 = state_67380;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67380__$1,(25),limit);
} else {
if((state_val_67381 === (6))){
var state_67380__$1 = state_67380;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67380__$1,(9),select);
} else {
if((state_val_67381 === (25))){
var inst_67354 = (state_67380[(2)]);
var inst_67355 = fluree.db.util.async.throw_err(inst_67354);
var state_67380__$1 = state_67380;
var statearr_67391_67446 = state_67380__$1;
(statearr_67391_67446[(2)] = inst_67355);

(statearr_67391_67446[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (17))){
var inst_67338 = (state_67380[(2)]);
var inst_67339 = fluree.db.util.async.throw_err(inst_67338);
var state_67380__$1 = state_67380;
var statearr_67392_67447 = state_67380__$1;
(statearr_67392_67447[(2)] = inst_67339);

(statearr_67392_67447[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (3))){
var inst_67378 = (state_67380[(2)]);
var state_67380__$1 = state_67380;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67380__$1,inst_67378);
} else {
if((state_val_67381 === (12))){
var inst_67334 = (state_67380[(2)]);
var inst_67335 = fluree.db.util.async.channel_QMARK_(where);
var state_67380__$1 = (function (){var statearr_67393 = state_67380;
(statearr_67393[(9)] = inst_67334);

return statearr_67393;
})();
if(inst_67335){
var statearr_67394_67448 = state_67380__$1;
(statearr_67394_67448[(1)] = (14));

} else {
var statearr_67395_67449 = state_67380__$1;
(statearr_67395_67449[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (2))){
var _ = (function (){var statearr_67396 = state_67380;
(statearr_67396[(4)] = cljs.core.cons((5),(state_67380[(4)])));

return statearr_67396;
})();
var inst_67319 = fluree.db.util.async.channel_QMARK_(select);
var state_67380__$1 = state_67380;
if(inst_67319){
var statearr_67397_67450 = state_67380__$1;
(statearr_67397_67450[(1)] = (6));

} else {
var statearr_67398_67451 = state_67380__$1;
(statearr_67398_67451[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (23))){
var state_67380__$1 = state_67380;
var statearr_67399_67452 = state_67380__$1;
(statearr_67399_67452[(2)] = limit);

(statearr_67399_67452[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (19))){
var state_67380__$1 = state_67380;
var statearr_67400_67453 = state_67380__$1;
(statearr_67400_67453[(2)] = block);

(statearr_67400_67453[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (11))){
var state_67380__$1 = state_67380;
var statearr_67402_67454 = state_67380__$1;
(statearr_67402_67454[(2)] = from);

(statearr_67402_67454[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (9))){
var inst_67322 = (state_67380[(2)]);
var inst_67323 = fluree.db.util.async.throw_err(inst_67322);
var state_67380__$1 = state_67380;
var statearr_67403_67455 = state_67380__$1;
(statearr_67403_67455[(2)] = inst_67323);

(statearr_67403_67455[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (5))){
var _ = (function (){var statearr_67404 = state_67380;
(statearr_67404[(4)] = cljs.core.rest((state_67380[(4)])));

return statearr_67404;
})();
var state_67380__$1 = state_67380;
var ex67401 = (state_67380__$1[(2)]);
var statearr_67405_67456 = state_67380__$1;
(statearr_67405_67456[(5)] = ex67401);


if((ex67401 instanceof Error)){
var statearr_67406_67457 = state_67380__$1;
(statearr_67406_67457[(1)] = (4));

(statearr_67406_67457[(5)] = null);

} else {
throw ex67401;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (14))){
var state_67380__$1 = state_67380;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67380__$1,(17),where);
} else {
if((state_val_67381 === (26))){
var inst_67342 = (state_67380[(8)]);
var inst_67334 = (state_67380[(9)]);
var inst_67326 = (state_67380[(10)]);
var inst_67350 = (state_67380[(7)]);
var inst_67362 = (state_67380[(2)]);
var inst_67363 = fluree.db.util.async.throw_err(inst_67362);
var inst_67364 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67363,(0),null);
var inst_67365 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67363,(1),null);
var inst_67366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67367 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67369 = [inst_67326,inst_67334,inst_67342,inst_67350];
var inst_67370 = (new cljs.core.PersistentVector(null,4,(5),inst_67368,inst_67369,null));
var inst_67371 = ["query",inst_67370,inst_67364];
var inst_67372 = cljs.core.PersistentHashMap.fromArrays(inst_67367,inst_67371);
var inst_67373 = [inst_67372,inst_67365];
var inst_67374 = (new cljs.core.PersistentVector(null,2,(5),inst_67366,inst_67373,null));
var inst_67375 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67374);
var _ = (function (){var statearr_67407 = state_67380;
(statearr_67407[(4)] = cljs.core.rest((state_67380[(4)])));

return statearr_67407;
})();
var state_67380__$1 = (function (){var statearr_67408 = state_67380;
(statearr_67408[(11)] = inst_67375);

return statearr_67408;
})();
var statearr_67409_67458 = state_67380__$1;
(statearr_67409_67458[(2)] = inst_67364);

(statearr_67409_67458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (16))){
var inst_67342 = (state_67380[(2)]);
var inst_67343 = fluree.db.util.async.channel_QMARK_(block);
var state_67380__$1 = (function (){var statearr_67410 = state_67380;
(statearr_67410[(8)] = inst_67342);

return statearr_67410;
})();
if(inst_67343){
var statearr_67411_67459 = state_67380__$1;
(statearr_67411_67459[(1)] = (18));

} else {
var statearr_67412_67460 = state_67380__$1;
(statearr_67412_67460[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67381 === (10))){
var state_67380__$1 = state_67380;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67380__$1,(13),from);
} else {
if((state_val_67381 === (18))){
var state_67380__$1 = state_67380;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67380__$1,(21),block);
} else {
if((state_val_67381 === (8))){
var inst_67326 = (state_67380[(2)]);
var inst_67327 = fluree.db.util.async.channel_QMARK_(from);
var state_67380__$1 = (function (){var statearr_67413 = state_67380;
(statearr_67413[(10)] = inst_67326);

return statearr_67413;
})();
if(inst_67327){
var statearr_67414_67461 = state_67380__$1;
(statearr_67414_67461[(1)] = (10));

} else {
var statearr_67415_67462 = state_67380__$1;
(statearr_67415_67462[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_67416 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67416[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_67416[(1)] = (1));

return statearr_67416;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_67380){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_67380);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e67417){var ex__11441__auto__ = e67417;
var statearr_67418_67463 = state_67380;
(statearr_67418_67463[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_67380[(4)]))){
var statearr_67419_67464 = state_67380;
(statearr_67419_67464[(1)] = cljs.core.first((state_67380[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67465 = state_67380;
state_67380 = G__67465;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_67380){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_67380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_67420 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_67420[(6)] = c__11512__auto__);

return statearr_67420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_67521){
var state_val_67522 = (state_67521[(1)]);
if((state_val_67522 === (7))){
var state_67521__$1 = state_67521;
var statearr_67523_67554 = state_67521__$1;
(statearr_67523_67554[(2)] = startSubject);

(statearr_67523_67554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67522 === (1))){
var state_67521__$1 = state_67521;
var statearr_67524_67555 = state_67521__$1;
(statearr_67524_67555[(2)] = null);

(statearr_67524_67555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67522 === (4))){
var inst_67466 = (state_67521[(2)]);
var state_67521__$1 = state_67521;
var statearr_67525_67556 = state_67521__$1;
(statearr_67525_67556[(2)] = inst_67466);

(statearr_67525_67556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67522 === (15))){
var inst_67498 = (state_67521[(2)]);
var inst_67499 = fluree.db.util.async.throw_err(inst_67498);
var inst_67500 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67499,(0),null);
var inst_67501 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67499,(1),null);
var inst_67502 = cljs.core.empty_QMARK_(inst_67500);
var state_67521__$1 = (function (){var statearr_67526 = state_67521;
(statearr_67526[(7)] = inst_67501);

return statearr_67526;
})();
if(inst_67502){
var statearr_67527_67557 = state_67521__$1;
(statearr_67527_67557[(1)] = (16));

} else {
var statearr_67528_67558 = state_67521__$1;
(statearr_67528_67558[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67522 === (13))){
var inst_67482 = (state_67521[(8)]);
var inst_67494 = (state_67521[(9)]);
var inst_67486 = (state_67521[(10)]);
var inst_67494__$1 = (state_67521[(2)]);
var inst_67495 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_67496 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_67495,inst_67482,inst_67486,inst_67494__$1);
var state_67521__$1 = (function (){var statearr_67529 = state_67521;
(statearr_67529[(9)] = inst_67494__$1);

return statearr_67529;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67521__$1,(15),inst_67496);
} else {
if((state_val_67522 === (6))){
var state_67521__$1 = state_67521;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67521__$1,(9),startSubject);
} else {
if((state_val_67522 === (17))){
var state_67521__$1 = state_67521;
var statearr_67530_67559 = state_67521__$1;
(statearr_67530_67559[(2)] = true);

(statearr_67530_67559[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67522 === (3))){
var inst_67519 = (state_67521[(2)]);
var state_67521__$1 = state_67521;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67521__$1,inst_67519);
} else {
if((state_val_67522 === (12))){
var state_67521__$1 = state_67521;
var statearr_67531_67560 = state_67521__$1;
(statearr_67531_67560[(2)] = endSubject);

(statearr_67531_67560[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67522 === (2))){
var _ = (function (){var statearr_67532 = state_67521;
(statearr_67532[(4)] = cljs.core.cons((5),(state_67521[(4)])));

return statearr_67532;
})();
var inst_67475 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_67521__$1 = state_67521;
if(inst_67475){
var statearr_67533_67561 = state_67521__$1;
(statearr_67533_67561[(1)] = (6));

} else {
var statearr_67534_67562 = state_67521__$1;
(statearr_67534_67562[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67522 === (11))){
var state_67521__$1 = state_67521;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67521__$1,(14),endSubject);
} else {
if((state_val_67522 === (9))){
var inst_67478 = (state_67521[(2)]);
var inst_67479 = fluree.db.util.async.throw_err(inst_67478);
var state_67521__$1 = state_67521;
var statearr_67536_67563 = state_67521__$1;
(statearr_67536_67563[(2)] = inst_67479);

(statearr_67536_67563[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67522 === (5))){
var _ = (function (){var statearr_67537 = state_67521;
(statearr_67537[(4)] = cljs.core.rest((state_67521[(4)])));

return statearr_67537;
})();
var state_67521__$1 = state_67521;
var ex67535 = (state_67521__$1[(2)]);
var statearr_67538_67564 = state_67521__$1;
(statearr_67538_67564[(5)] = ex67535);


if((ex67535 instanceof Error)){
var statearr_67539_67565 = state_67521__$1;
(statearr_67539_67565[(1)] = (4));

(statearr_67539_67565[(5)] = null);

} else {
throw ex67535;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67522 === (14))){
var inst_67490 = (state_67521[(2)]);
var inst_67491 = fluree.db.util.async.throw_err(inst_67490);
var state_67521__$1 = state_67521;
var statearr_67540_67566 = state_67521__$1;
(statearr_67540_67566[(2)] = inst_67491);

(statearr_67540_67566[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67522 === (16))){
var state_67521__$1 = state_67521;
var statearr_67541_67567 = state_67521__$1;
(statearr_67541_67567[(2)] = false);

(statearr_67541_67567[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67522 === (10))){
var inst_67485 = (state_67521[(2)]);
var inst_67486 = fluree.db.util.async.throw_err(inst_67485);
var inst_67487 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_67521__$1 = (function (){var statearr_67542 = state_67521;
(statearr_67542[(10)] = inst_67486);

return statearr_67542;
})();
if(inst_67487){
var statearr_67543_67568 = state_67521__$1;
(statearr_67543_67568[(1)] = (11));

} else {
var statearr_67544_67569 = state_67521__$1;
(statearr_67544_67569[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67522 === (18))){
var inst_67501 = (state_67521[(7)]);
var inst_67482 = (state_67521[(8)]);
var inst_67494 = (state_67521[(9)]);
var inst_67486 = (state_67521[(10)]);
var inst_67506 = (state_67521[(2)]);
var inst_67507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67508 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67510 = [inst_67482,inst_67486,inst_67494];
var inst_67511 = (new cljs.core.PersistentVector(null,3,(5),inst_67509,inst_67510,null));
var inst_67512 = ["relationship?",inst_67511,inst_67506];
var inst_67513 = cljs.core.PersistentHashMap.fromArrays(inst_67508,inst_67512);
var inst_67514 = [inst_67513,inst_67501];
var inst_67515 = (new cljs.core.PersistentVector(null,2,(5),inst_67507,inst_67514,null));
var inst_67516 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67515);
var _ = (function (){var statearr_67545 = state_67521;
(statearr_67545[(4)] = cljs.core.rest((state_67521[(4)])));

return statearr_67545;
})();
var state_67521__$1 = (function (){var statearr_67546 = state_67521;
(statearr_67546[(11)] = inst_67516);

return statearr_67546;
})();
var statearr_67547_67570 = state_67521__$1;
(statearr_67547_67570[(2)] = inst_67506);

(statearr_67547_67570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67522 === (8))){
var inst_67482 = (state_67521[(2)]);
var inst_67483 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_67521__$1 = (function (){var statearr_67548 = state_67521;
(statearr_67548[(8)] = inst_67482);

return statearr_67548;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67521__$1,(10),inst_67483);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11438__auto____0 = (function (){
var statearr_67549 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67549[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11438__auto__);

(statearr_67549[(1)] = (1));

return statearr_67549;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11438__auto____1 = (function (state_67521){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_67521);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e67550){var ex__11441__auto__ = e67550;
var statearr_67551_67571 = state_67521;
(statearr_67551_67571[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_67521[(4)]))){
var statearr_67552_67572 = state_67521;
(statearr_67552_67572[(1)] = cljs.core.first((state_67521[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67573 = state_67521;
state_67521 = G__67573;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11438__auto__ = function(state_67521){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11438__auto____1.call(this,state_67521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_67553 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_67553[(6)] = c__11512__auto__);

return statearr_67553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_67610){
var state_val_67611 = (state_67610[(1)]);
if((state_val_67611 === (7))){
var state_67610__$1 = state_67610;
var statearr_67612_67632 = state_67610__$1;
(statearr_67612_67632[(2)] = pred_name);

(statearr_67612_67632[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67611 === (1))){
var state_67610__$1 = state_67610;
var statearr_67613_67633 = state_67610__$1;
(statearr_67613_67633[(2)] = null);

(statearr_67613_67633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67611 === (4))){
var inst_67574 = (state_67610[(2)]);
var state_67610__$1 = state_67610;
var statearr_67614_67634 = state_67610__$1;
(statearr_67614_67634[(2)] = inst_67574);

(statearr_67614_67634[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67611 === (6))){
var state_67610__$1 = state_67610;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67610__$1,(9),pred_name);
} else {
if((state_val_67611 === (3))){
var inst_67608 = (state_67610[(2)]);
var state_67610__$1 = state_67610;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67610__$1,inst_67608);
} else {
if((state_val_67611 === (2))){
var _ = (function (){var statearr_67616 = state_67610;
(statearr_67616[(4)] = cljs.core.cons((5),(state_67610[(4)])));

return statearr_67616;
})();
var inst_67583 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_67610__$1 = state_67610;
if(inst_67583){
var statearr_67617_67635 = state_67610__$1;
(statearr_67617_67635[(1)] = (6));

} else {
var statearr_67618_67636 = state_67610__$1;
(statearr_67618_67636[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67611 === (9))){
var inst_67586 = (state_67610[(2)]);
var inst_67587 = fluree.db.util.async.throw_err(inst_67586);
var state_67610__$1 = state_67610;
var statearr_67619_67637 = state_67610__$1;
(statearr_67619_67637[(2)] = inst_67587);

(statearr_67619_67637[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67611 === (5))){
var _ = (function (){var statearr_67620 = state_67610;
(statearr_67620[(4)] = cljs.core.rest((state_67610[(4)])));

return statearr_67620;
})();
var state_67610__$1 = state_67610;
var ex67615 = (state_67610__$1[(2)]);
var statearr_67621_67638 = state_67610__$1;
(statearr_67621_67638[(5)] = ex67615);


if((ex67615 instanceof Error)){
var statearr_67622_67639 = state_67610__$1;
(statearr_67622_67639[(1)] = (4));

(statearr_67622_67639[(5)] = null);

} else {
throw ex67615;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67611 === (10))){
var inst_67590 = (state_67610[(7)]);
var inst_67594 = (state_67610[(2)]);
var inst_67595 = fluree.db.util.async.throw_err(inst_67594);
var inst_67596 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67595,(0),null);
var inst_67597 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67595,(1),null);
var inst_67598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67599 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67600 = ["max-pred-val",inst_67590,inst_67596];
var inst_67601 = cljs.core.PersistentHashMap.fromArrays(inst_67599,inst_67600);
var inst_67602 = (inst_67597 + (10));
var inst_67603 = [inst_67601,inst_67602];
var inst_67604 = (new cljs.core.PersistentVector(null,2,(5),inst_67598,inst_67603,null));
var inst_67605 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67604);
var _ = (function (){var statearr_67623 = state_67610;
(statearr_67623[(4)] = cljs.core.rest((state_67610[(4)])));

return statearr_67623;
})();
var state_67610__$1 = (function (){var statearr_67624 = state_67610;
(statearr_67624[(8)] = inst_67605);

return statearr_67624;
})();
var statearr_67625_67640 = state_67610__$1;
(statearr_67625_67640[(2)] = inst_67596);

(statearr_67625_67640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67611 === (8))){
var inst_67590 = (state_67610[(7)]);
var inst_67590__$1 = (state_67610[(2)]);
var inst_67591 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_67592 = fluree.db.dbfunctions.internal.max_pred_val(inst_67591,inst_67590__$1,null);
var state_67610__$1 = (function (){var statearr_67626 = state_67610;
(statearr_67626[(7)] = inst_67590__$1);

return statearr_67626;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67610__$1,(10),inst_67592);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11438__auto____0 = (function (){
var statearr_67627 = [null,null,null,null,null,null,null,null,null];
(statearr_67627[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11438__auto__);

(statearr_67627[(1)] = (1));

return statearr_67627;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11438__auto____1 = (function (state_67610){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_67610);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e67628){var ex__11441__auto__ = e67628;
var statearr_67629_67641 = state_67610;
(statearr_67629_67641[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_67610[(4)]))){
var statearr_67630_67642 = state_67610;
(statearr_67630_67642[(1)] = cljs.core.first((state_67610[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67643 = state_67610;
state_67610 = G__67643;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11438__auto__ = function(state_67610){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11438__auto____1.call(this,state_67610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_67631 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_67631[(6)] = c__11512__auto__);

return statearr_67631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_67670){
var state_val_67671 = (state_67670[(1)]);
if((state_val_67671 === (7))){
var state_67670__$1 = state_67670;
var statearr_67672_67691 = state_67670__$1;
(statearr_67672_67691[(2)] = n);

(statearr_67672_67691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67671 === (1))){
var state_67670__$1 = state_67670;
var statearr_67673_67692 = state_67670__$1;
(statearr_67673_67692[(2)] = null);

(statearr_67673_67692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67671 === (4))){
var inst_67644 = (state_67670[(2)]);
var state_67670__$1 = state_67670;
var statearr_67674_67693 = state_67670__$1;
(statearr_67674_67693[(2)] = inst_67644);

(statearr_67674_67693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67671 === (6))){
var state_67670__$1 = state_67670;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67670__$1,(9),n);
} else {
if((state_val_67671 === (3))){
var inst_67668 = (state_67670[(2)]);
var state_67670__$1 = state_67670;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67670__$1,inst_67668);
} else {
if((state_val_67671 === (2))){
var _ = (function (){var statearr_67676 = state_67670;
(statearr_67676[(4)] = cljs.core.cons((5),(state_67670[(4)])));

return statearr_67676;
})();
var inst_67650 = fluree.db.util.async.channel_QMARK_(n);
var state_67670__$1 = state_67670;
if(inst_67650){
var statearr_67677_67694 = state_67670__$1;
(statearr_67677_67694[(1)] = (6));

} else {
var statearr_67678_67695 = state_67670__$1;
(statearr_67678_67695[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67671 === (9))){
var inst_67653 = (state_67670[(2)]);
var inst_67654 = fluree.db.util.async.throw_err(inst_67653);
var state_67670__$1 = state_67670;
var statearr_67679_67696 = state_67670__$1;
(statearr_67679_67696[(2)] = inst_67654);

(statearr_67679_67696[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67671 === (5))){
var _ = (function (){var statearr_67680 = state_67670;
(statearr_67680[(4)] = cljs.core.rest((state_67670[(4)])));

return statearr_67680;
})();
var state_67670__$1 = state_67670;
var ex67675 = (state_67670__$1[(2)]);
var statearr_67681_67697 = state_67670__$1;
(statearr_67681_67697[(5)] = ex67675);


if((ex67675 instanceof Error)){
var statearr_67682_67698 = state_67670__$1;
(statearr_67682_67698[(1)] = (4));

(statearr_67682_67698[(5)] = null);

} else {
throw ex67675;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67671 === (8))){
var inst_67657 = (state_67670[(2)]);
var inst_67658 = fluree.db.dbfunctions.internal.inc(inst_67657);
var inst_67659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67660 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67661 = ["inc",inst_67657,inst_67658];
var inst_67662 = cljs.core.PersistentHashMap.fromArrays(inst_67660,inst_67661);
var inst_67663 = [inst_67662,(10)];
var inst_67664 = (new cljs.core.PersistentVector(null,2,(5),inst_67659,inst_67663,null));
var inst_67665 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67664);
var _ = (function (){var statearr_67683 = state_67670;
(statearr_67683[(4)] = cljs.core.rest((state_67670[(4)])));

return statearr_67683;
})();
var state_67670__$1 = (function (){var statearr_67684 = state_67670;
(statearr_67684[(7)] = inst_67665);

return statearr_67684;
})();
var statearr_67685_67699 = state_67670__$1;
(statearr_67685_67699[(2)] = inst_67658);

(statearr_67685_67699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__11438__auto____0 = (function (){
var statearr_67686 = [null,null,null,null,null,null,null,null];
(statearr_67686[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__11438__auto__);

(statearr_67686[(1)] = (1));

return statearr_67686;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__11438__auto____1 = (function (state_67670){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_67670);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e67687){var ex__11441__auto__ = e67687;
var statearr_67688_67700 = state_67670;
(statearr_67688_67700[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_67670[(4)]))){
var statearr_67689_67701 = state_67670;
(statearr_67689_67701[(1)] = cljs.core.first((state_67670[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67702 = state_67670;
state_67670 = G__67702;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__11438__auto__ = function(state_67670){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__11438__auto____1.call(this,state_67670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_67690 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_67690[(6)] = c__11512__auto__);

return statearr_67690;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_67729){
var state_val_67730 = (state_67729[(1)]);
if((state_val_67730 === (7))){
var state_67729__$1 = state_67729;
var statearr_67731_67750 = state_67729__$1;
(statearr_67731_67750[(2)] = n);

(statearr_67731_67750[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67730 === (1))){
var state_67729__$1 = state_67729;
var statearr_67732_67751 = state_67729__$1;
(statearr_67732_67751[(2)] = null);

(statearr_67732_67751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67730 === (4))){
var inst_67703 = (state_67729[(2)]);
var state_67729__$1 = state_67729;
var statearr_67733_67752 = state_67729__$1;
(statearr_67733_67752[(2)] = inst_67703);

(statearr_67733_67752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67730 === (6))){
var state_67729__$1 = state_67729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67729__$1,(9),n);
} else {
if((state_val_67730 === (3))){
var inst_67727 = (state_67729[(2)]);
var state_67729__$1 = state_67729;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67729__$1,inst_67727);
} else {
if((state_val_67730 === (2))){
var _ = (function (){var statearr_67735 = state_67729;
(statearr_67735[(4)] = cljs.core.cons((5),(state_67729[(4)])));

return statearr_67735;
})();
var inst_67709 = fluree.db.util.async.channel_QMARK_(n);
var state_67729__$1 = state_67729;
if(inst_67709){
var statearr_67736_67753 = state_67729__$1;
(statearr_67736_67753[(1)] = (6));

} else {
var statearr_67737_67754 = state_67729__$1;
(statearr_67737_67754[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67730 === (9))){
var inst_67712 = (state_67729[(2)]);
var inst_67713 = fluree.db.util.async.throw_err(inst_67712);
var state_67729__$1 = state_67729;
var statearr_67738_67755 = state_67729__$1;
(statearr_67738_67755[(2)] = inst_67713);

(statearr_67738_67755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67730 === (5))){
var _ = (function (){var statearr_67739 = state_67729;
(statearr_67739[(4)] = cljs.core.rest((state_67729[(4)])));

return statearr_67739;
})();
var state_67729__$1 = state_67729;
var ex67734 = (state_67729__$1[(2)]);
var statearr_67740_67756 = state_67729__$1;
(statearr_67740_67756[(5)] = ex67734);


if((ex67734 instanceof Error)){
var statearr_67741_67757 = state_67729__$1;
(statearr_67741_67757[(1)] = (4));

(statearr_67741_67757[(5)] = null);

} else {
throw ex67734;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67730 === (8))){
var inst_67716 = (state_67729[(2)]);
var inst_67717 = fluree.db.dbfunctions.internal.dec(inst_67716);
var inst_67718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67719 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67720 = ["dec",inst_67716,inst_67717];
var inst_67721 = cljs.core.PersistentHashMap.fromArrays(inst_67719,inst_67720);
var inst_67722 = [inst_67721,(10)];
var inst_67723 = (new cljs.core.PersistentVector(null,2,(5),inst_67718,inst_67722,null));
var inst_67724 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67723);
var _ = (function (){var statearr_67742 = state_67729;
(statearr_67742[(4)] = cljs.core.rest((state_67729[(4)])));

return statearr_67742;
})();
var state_67729__$1 = (function (){var statearr_67743 = state_67729;
(statearr_67743[(7)] = inst_67724);

return statearr_67743;
})();
var statearr_67744_67758 = state_67729__$1;
(statearr_67744_67758[(2)] = inst_67717);

(statearr_67744_67758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__11438__auto____0 = (function (){
var statearr_67745 = [null,null,null,null,null,null,null,null];
(statearr_67745[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__11438__auto__);

(statearr_67745[(1)] = (1));

return statearr_67745;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__11438__auto____1 = (function (state_67729){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_67729);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e67746){var ex__11441__auto__ = e67746;
var statearr_67747_67759 = state_67729;
(statearr_67747_67759[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_67729[(4)]))){
var statearr_67748_67760 = state_67729;
(statearr_67748_67760[(1)] = cljs.core.first((state_67729[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67761 = state_67729;
state_67729 = G__67761;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__11438__auto__ = function(state_67729){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__11438__auto____1.call(this,state_67729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_67749 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_67749[(6)] = c__11512__auto__);

return statearr_67749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___67811 = arguments.length;
var i__5769__auto___67812 = (0);
while(true){
if((i__5769__auto___67812 < len__5768__auto___67811)){
args__5774__auto__.push((arguments[i__5769__auto___67812]));

var G__67813 = (i__5769__auto___67812 + (1));
i__5769__auto___67812 = G__67813;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_67794){
var state_val_67795 = (state_67794[(1)]);
if((state_val_67795 === (1))){
var state_67794__$1 = state_67794;
var statearr_67796_67814 = state_67794__$1;
(statearr_67796_67814[(2)] = null);

(statearr_67796_67814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67795 === (2))){
var _ = (function (){var statearr_67797 = state_67794;
(statearr_67797[(4)] = cljs.core.cons((5),(state_67794[(4)])));

return statearr_67797;
})();
var inst_67770 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67794__$1 = state_67794;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67794__$1,(6),inst_67770);
} else {
if((state_val_67795 === (3))){
var inst_67792 = (state_67794[(2)]);
var state_67794__$1 = state_67794;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67794__$1,inst_67792);
} else {
if((state_val_67795 === (4))){
var inst_67764 = (state_67794[(2)]);
var state_67794__$1 = state_67794;
var statearr_67799_67815 = state_67794__$1;
(statearr_67799_67815[(2)] = inst_67764);

(statearr_67799_67815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67795 === (5))){
var _ = (function (){var statearr_67800 = state_67794;
(statearr_67800[(4)] = cljs.core.rest((state_67794[(4)])));

return statearr_67800;
})();
var state_67794__$1 = state_67794;
var ex67798 = (state_67794__$1[(2)]);
var statearr_67801_67816 = state_67794__$1;
(statearr_67801_67816[(5)] = ex67798);


if((ex67798 instanceof Error)){
var statearr_67802_67817 = state_67794__$1;
(statearr_67802_67817[(1)] = (4));

(statearr_67802_67817[(5)] = null);

} else {
throw ex67798;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67795 === (6))){
var inst_67772 = (state_67794[(2)]);
var inst_67773 = fluree.db.util.async.throw_err(inst_67772);
var inst_67774 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_67773);
var inst_67775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67776 = [inst_67773];
var inst_67777 = (new cljs.core.PersistentVector(null,1,(5),inst_67775,inst_67776,null));
var inst_67778 = cljs.core.count(inst_67777);
var inst_67779 = ((9) + inst_67778);
var inst_67780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67781 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67782 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67783 = [inst_67773];
var inst_67784 = (new cljs.core.PersistentVector(null,1,(5),inst_67782,inst_67783,null));
var inst_67785 = ["+",inst_67784,inst_67774];
var inst_67786 = cljs.core.PersistentHashMap.fromArrays(inst_67781,inst_67785);
var inst_67787 = [inst_67786,inst_67779];
var inst_67788 = (new cljs.core.PersistentVector(null,2,(5),inst_67780,inst_67787,null));
var inst_67789 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67788);
var _ = (function (){var statearr_67803 = state_67794;
(statearr_67803[(4)] = cljs.core.rest((state_67794[(4)])));

return statearr_67803;
})();
var state_67794__$1 = (function (){var statearr_67804 = state_67794;
(statearr_67804[(7)] = inst_67789);

return statearr_67804;
})();
var statearr_67805_67818 = state_67794__$1;
(statearr_67805_67818[(2)] = inst_67774);

(statearr_67805_67818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_67806 = [null,null,null,null,null,null,null,null];
(statearr_67806[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_67806[(1)] = (1));

return statearr_67806;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_67794){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_67794);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e67807){var ex__11441__auto__ = e67807;
var statearr_67808_67819 = state_67794;
(statearr_67808_67819[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_67794[(4)]))){
var statearr_67809_67820 = state_67794;
(statearr_67809_67820[(1)] = cljs.core.first((state_67794[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67821 = state_67794;
state_67794 = G__67821;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_67794){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_67794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_67810 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_67810[(6)] = c__11512__auto__);

return statearr_67810;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq67762){
var G__67763 = cljs.core.first(seq67762);
var seq67762__$1 = cljs.core.next(seq67762);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67763,seq67762__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___67871 = arguments.length;
var i__5769__auto___67872 = (0);
while(true){
if((i__5769__auto___67872 < len__5768__auto___67871)){
args__5774__auto__.push((arguments[i__5769__auto___67872]));

var G__67873 = (i__5769__auto___67872 + (1));
i__5769__auto___67872 = G__67873;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_67854){
var state_val_67855 = (state_67854[(1)]);
if((state_val_67855 === (1))){
var state_67854__$1 = state_67854;
var statearr_67856_67874 = state_67854__$1;
(statearr_67856_67874[(2)] = null);

(statearr_67856_67874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67855 === (2))){
var _ = (function (){var statearr_67857 = state_67854;
(statearr_67857[(4)] = cljs.core.cons((5),(state_67854[(4)])));

return statearr_67857;
})();
var inst_67830 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67854__$1 = state_67854;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67854__$1,(6),inst_67830);
} else {
if((state_val_67855 === (3))){
var inst_67852 = (state_67854[(2)]);
var state_67854__$1 = state_67854;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67854__$1,inst_67852);
} else {
if((state_val_67855 === (4))){
var inst_67824 = (state_67854[(2)]);
var state_67854__$1 = state_67854;
var statearr_67859_67875 = state_67854__$1;
(statearr_67859_67875[(2)] = inst_67824);

(statearr_67859_67875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67855 === (5))){
var _ = (function (){var statearr_67860 = state_67854;
(statearr_67860[(4)] = cljs.core.rest((state_67854[(4)])));

return statearr_67860;
})();
var state_67854__$1 = state_67854;
var ex67858 = (state_67854__$1[(2)]);
var statearr_67861_67876 = state_67854__$1;
(statearr_67861_67876[(5)] = ex67858);


if((ex67858 instanceof Error)){
var statearr_67862_67877 = state_67854__$1;
(statearr_67862_67877[(1)] = (4));

(statearr_67862_67877[(5)] = null);

} else {
throw ex67858;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67855 === (6))){
var inst_67832 = (state_67854[(2)]);
var inst_67833 = fluree.db.util.async.throw_err(inst_67832);
var inst_67834 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_67833);
var inst_67835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67836 = [inst_67833];
var inst_67837 = (new cljs.core.PersistentVector(null,1,(5),inst_67835,inst_67836,null));
var inst_67838 = cljs.core.count(inst_67837);
var inst_67839 = ((9) + inst_67838);
var inst_67840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67841 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67843 = [inst_67833];
var inst_67844 = (new cljs.core.PersistentVector(null,1,(5),inst_67842,inst_67843,null));
var inst_67845 = ["-",inst_67844,inst_67834];
var inst_67846 = cljs.core.PersistentHashMap.fromArrays(inst_67841,inst_67845);
var inst_67847 = [inst_67846,inst_67839];
var inst_67848 = (new cljs.core.PersistentVector(null,2,(5),inst_67840,inst_67847,null));
var inst_67849 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67848);
var _ = (function (){var statearr_67863 = state_67854;
(statearr_67863[(4)] = cljs.core.rest((state_67854[(4)])));

return statearr_67863;
})();
var state_67854__$1 = (function (){var statearr_67864 = state_67854;
(statearr_67864[(7)] = inst_67849);

return statearr_67864;
})();
var statearr_67865_67878 = state_67854__$1;
(statearr_67865_67878[(2)] = inst_67834);

(statearr_67865_67878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_67866 = [null,null,null,null,null,null,null,null];
(statearr_67866[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_67866[(1)] = (1));

return statearr_67866;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_67854){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_67854);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e67867){var ex__11441__auto__ = e67867;
var statearr_67868_67879 = state_67854;
(statearr_67868_67879[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_67854[(4)]))){
var statearr_67869_67880 = state_67854;
(statearr_67869_67880[(1)] = cljs.core.first((state_67854[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67881 = state_67854;
state_67854 = G__67881;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_67854){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_67854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_67870 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_67870[(6)] = c__11512__auto__);

return statearr_67870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq67822){
var G__67823 = cljs.core.first(seq67822);
var seq67822__$1 = cljs.core.next(seq67822);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67823,seq67822__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___67931 = arguments.length;
var i__5769__auto___67932 = (0);
while(true){
if((i__5769__auto___67932 < len__5768__auto___67931)){
args__5774__auto__.push((arguments[i__5769__auto___67932]));

var G__67933 = (i__5769__auto___67932 + (1));
i__5769__auto___67932 = G__67933;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_67914){
var state_val_67915 = (state_67914[(1)]);
if((state_val_67915 === (1))){
var state_67914__$1 = state_67914;
var statearr_67916_67934 = state_67914__$1;
(statearr_67916_67934[(2)] = null);

(statearr_67916_67934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67915 === (2))){
var _ = (function (){var statearr_67917 = state_67914;
(statearr_67917[(4)] = cljs.core.cons((5),(state_67914[(4)])));

return statearr_67917;
})();
var inst_67890 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67914__$1 = state_67914;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67914__$1,(6),inst_67890);
} else {
if((state_val_67915 === (3))){
var inst_67912 = (state_67914[(2)]);
var state_67914__$1 = state_67914;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67914__$1,inst_67912);
} else {
if((state_val_67915 === (4))){
var inst_67884 = (state_67914[(2)]);
var state_67914__$1 = state_67914;
var statearr_67919_67935 = state_67914__$1;
(statearr_67919_67935[(2)] = inst_67884);

(statearr_67919_67935[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67915 === (5))){
var _ = (function (){var statearr_67920 = state_67914;
(statearr_67920[(4)] = cljs.core.rest((state_67914[(4)])));

return statearr_67920;
})();
var state_67914__$1 = state_67914;
var ex67918 = (state_67914__$1[(2)]);
var statearr_67921_67936 = state_67914__$1;
(statearr_67921_67936[(5)] = ex67918);


if((ex67918 instanceof Error)){
var statearr_67922_67937 = state_67914__$1;
(statearr_67922_67937[(1)] = (4));

(statearr_67922_67937[(5)] = null);

} else {
throw ex67918;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67915 === (6))){
var inst_67892 = (state_67914[(2)]);
var inst_67893 = fluree.db.util.async.throw_err(inst_67892);
var inst_67894 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_67893);
var inst_67895 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67896 = [inst_67893];
var inst_67897 = (new cljs.core.PersistentVector(null,1,(5),inst_67895,inst_67896,null));
var inst_67898 = cljs.core.count(inst_67897);
var inst_67899 = ((9) + inst_67898);
var inst_67900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67901 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67903 = [inst_67893];
var inst_67904 = (new cljs.core.PersistentVector(null,1,(5),inst_67902,inst_67903,null));
var inst_67905 = ["*",inst_67904,inst_67894];
var inst_67906 = cljs.core.PersistentHashMap.fromArrays(inst_67901,inst_67905);
var inst_67907 = [inst_67906,inst_67899];
var inst_67908 = (new cljs.core.PersistentVector(null,2,(5),inst_67900,inst_67907,null));
var inst_67909 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67908);
var _ = (function (){var statearr_67923 = state_67914;
(statearr_67923[(4)] = cljs.core.rest((state_67914[(4)])));

return statearr_67923;
})();
var state_67914__$1 = (function (){var statearr_67924 = state_67914;
(statearr_67924[(7)] = inst_67909);

return statearr_67924;
})();
var statearr_67925_67938 = state_67914__$1;
(statearr_67925_67938[(2)] = inst_67894);

(statearr_67925_67938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_67926 = [null,null,null,null,null,null,null,null];
(statearr_67926[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_67926[(1)] = (1));

return statearr_67926;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_67914){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_67914);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e67927){var ex__11441__auto__ = e67927;
var statearr_67928_67939 = state_67914;
(statearr_67928_67939[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_67914[(4)]))){
var statearr_67929_67940 = state_67914;
(statearr_67929_67940[(1)] = cljs.core.first((state_67914[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67941 = state_67914;
state_67914 = G__67941;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_67914){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_67914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_67930 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_67930[(6)] = c__11512__auto__);

return statearr_67930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq67882){
var G__67883 = cljs.core.first(seq67882);
var seq67882__$1 = cljs.core.next(seq67882);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67883,seq67882__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___67991 = arguments.length;
var i__5769__auto___67992 = (0);
while(true){
if((i__5769__auto___67992 < len__5768__auto___67991)){
args__5774__auto__.push((arguments[i__5769__auto___67992]));

var G__67993 = (i__5769__auto___67992 + (1));
i__5769__auto___67992 = G__67993;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_67974){
var state_val_67975 = (state_67974[(1)]);
if((state_val_67975 === (1))){
var state_67974__$1 = state_67974;
var statearr_67976_67994 = state_67974__$1;
(statearr_67976_67994[(2)] = null);

(statearr_67976_67994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67975 === (2))){
var _ = (function (){var statearr_67977 = state_67974;
(statearr_67977[(4)] = cljs.core.cons((5),(state_67974[(4)])));

return statearr_67977;
})();
var inst_67950 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67974__$1 = state_67974;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67974__$1,(6),inst_67950);
} else {
if((state_val_67975 === (3))){
var inst_67972 = (state_67974[(2)]);
var state_67974__$1 = state_67974;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67974__$1,inst_67972);
} else {
if((state_val_67975 === (4))){
var inst_67944 = (state_67974[(2)]);
var state_67974__$1 = state_67974;
var statearr_67979_67995 = state_67974__$1;
(statearr_67979_67995[(2)] = inst_67944);

(statearr_67979_67995[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67975 === (5))){
var _ = (function (){var statearr_67980 = state_67974;
(statearr_67980[(4)] = cljs.core.rest((state_67974[(4)])));

return statearr_67980;
})();
var state_67974__$1 = state_67974;
var ex67978 = (state_67974__$1[(2)]);
var statearr_67981_67996 = state_67974__$1;
(statearr_67981_67996[(5)] = ex67978);


if((ex67978 instanceof Error)){
var statearr_67982_67997 = state_67974__$1;
(statearr_67982_67997[(1)] = (4));

(statearr_67982_67997[(5)] = null);

} else {
throw ex67978;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67975 === (6))){
var inst_67952 = (state_67974[(2)]);
var inst_67953 = fluree.db.util.async.throw_err(inst_67952);
var inst_67954 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_67953);
var inst_67955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67956 = [inst_67953];
var inst_67957 = (new cljs.core.PersistentVector(null,1,(5),inst_67955,inst_67956,null));
var inst_67958 = cljs.core.count(inst_67957);
var inst_67959 = ((9) + inst_67958);
var inst_67960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67961 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67963 = [inst_67953];
var inst_67964 = (new cljs.core.PersistentVector(null,1,(5),inst_67962,inst_67963,null));
var inst_67965 = ["/",inst_67964,inst_67954];
var inst_67966 = cljs.core.PersistentHashMap.fromArrays(inst_67961,inst_67965);
var inst_67967 = [inst_67966,inst_67959];
var inst_67968 = (new cljs.core.PersistentVector(null,2,(5),inst_67960,inst_67967,null));
var inst_67969 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67968);
var _ = (function (){var statearr_67983 = state_67974;
(statearr_67983[(4)] = cljs.core.rest((state_67974[(4)])));

return statearr_67983;
})();
var state_67974__$1 = (function (){var statearr_67984 = state_67974;
(statearr_67984[(7)] = inst_67969);

return statearr_67984;
})();
var statearr_67985_67998 = state_67974__$1;
(statearr_67985_67998[(2)] = inst_67954);

(statearr_67985_67998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_67986 = [null,null,null,null,null,null,null,null];
(statearr_67986[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_67986[(1)] = (1));

return statearr_67986;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_67974){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_67974);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e67987){var ex__11441__auto__ = e67987;
var statearr_67988_67999 = state_67974;
(statearr_67988_67999[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_67974[(4)]))){
var statearr_67989_68000 = state_67974;
(statearr_67989_68000[(1)] = cljs.core.first((state_67974[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68001 = state_67974;
state_67974 = G__68001;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_67974){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_67974);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_67990 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_67990[(6)] = c__11512__auto__);

return statearr_67990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq67942){
var G__67943 = cljs.core.first(seq67942);
var seq67942__$1 = cljs.core.next(seq67942);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67943,seq67942__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_68039){
var state_val_68040 = (state_68039[(1)]);
if((state_val_68040 === (7))){
var state_68039__$1 = state_68039;
var statearr_68041_68065 = state_68039__$1;
(statearr_68041_68065[(2)] = n);

(statearr_68041_68065[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68040 === (1))){
var state_68039__$1 = state_68039;
var statearr_68042_68066 = state_68039__$1;
(statearr_68042_68066[(2)] = null);

(statearr_68042_68066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68040 === (4))){
var inst_68002 = (state_68039[(2)]);
var state_68039__$1 = state_68039;
var statearr_68043_68067 = state_68039__$1;
(statearr_68043_68067[(2)] = inst_68002);

(statearr_68043_68067[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68040 === (13))){
var inst_68019 = (state_68039[(2)]);
var inst_68020 = fluree.db.util.async.throw_err(inst_68019);
var state_68039__$1 = state_68039;
var statearr_68044_68068 = state_68039__$1;
(statearr_68044_68068[(2)] = inst_68020);

(statearr_68044_68068[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68040 === (6))){
var state_68039__$1 = state_68039;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68039__$1,(9),n);
} else {
if((state_val_68040 === (3))){
var inst_68037 = (state_68039[(2)]);
var state_68039__$1 = state_68039;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68039__$1,inst_68037);
} else {
if((state_val_68040 === (12))){
var inst_68015 = (state_68039[(7)]);
var inst_68023 = (state_68039[(2)]);
var inst_68024 = fluree.db.dbfunctions.internal.quot(inst_68015,inst_68023);
var inst_68025 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68026 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68027 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68028 = [inst_68015,inst_68023];
var inst_68029 = (new cljs.core.PersistentVector(null,2,(5),inst_68027,inst_68028,null));
var inst_68030 = ["quot",inst_68029,inst_68024];
var inst_68031 = cljs.core.PersistentHashMap.fromArrays(inst_68026,inst_68030);
var inst_68032 = [inst_68031,(2)];
var inst_68033 = (new cljs.core.PersistentVector(null,2,(5),inst_68025,inst_68032,null));
var inst_68034 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68033);
var _ = (function (){var statearr_68045 = state_68039;
(statearr_68045[(4)] = cljs.core.rest((state_68039[(4)])));

return statearr_68045;
})();
var state_68039__$1 = (function (){var statearr_68046 = state_68039;
(statearr_68046[(8)] = inst_68034);

return statearr_68046;
})();
var statearr_68047_68069 = state_68039__$1;
(statearr_68047_68069[(2)] = inst_68024);

(statearr_68047_68069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68040 === (2))){
var _ = (function (){var statearr_68048 = state_68039;
(statearr_68048[(4)] = cljs.core.cons((5),(state_68039[(4)])));

return statearr_68048;
})();
var inst_68008 = fluree.db.util.async.channel_QMARK_(n);
var state_68039__$1 = state_68039;
if(inst_68008){
var statearr_68049_68070 = state_68039__$1;
(statearr_68049_68070[(1)] = (6));

} else {
var statearr_68050_68071 = state_68039__$1;
(statearr_68050_68071[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68040 === (11))){
var state_68039__$1 = state_68039;
var statearr_68052_68072 = state_68039__$1;
(statearr_68052_68072[(2)] = d);

(statearr_68052_68072[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68040 === (9))){
var inst_68011 = (state_68039[(2)]);
var inst_68012 = fluree.db.util.async.throw_err(inst_68011);
var state_68039__$1 = state_68039;
var statearr_68053_68073 = state_68039__$1;
(statearr_68053_68073[(2)] = inst_68012);

(statearr_68053_68073[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68040 === (5))){
var _ = (function (){var statearr_68054 = state_68039;
(statearr_68054[(4)] = cljs.core.rest((state_68039[(4)])));

return statearr_68054;
})();
var state_68039__$1 = state_68039;
var ex68051 = (state_68039__$1[(2)]);
var statearr_68055_68074 = state_68039__$1;
(statearr_68055_68074[(5)] = ex68051);


if((ex68051 instanceof Error)){
var statearr_68056_68075 = state_68039__$1;
(statearr_68056_68075[(1)] = (4));

(statearr_68056_68075[(5)] = null);

} else {
throw ex68051;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68040 === (10))){
var state_68039__$1 = state_68039;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68039__$1,(13),d);
} else {
if((state_val_68040 === (8))){
var inst_68015 = (state_68039[(2)]);
var inst_68016 = fluree.db.util.async.channel_QMARK_(d);
var state_68039__$1 = (function (){var statearr_68057 = state_68039;
(statearr_68057[(7)] = inst_68015);

return statearr_68057;
})();
if(inst_68016){
var statearr_68058_68076 = state_68039__$1;
(statearr_68058_68076[(1)] = (10));

} else {
var statearr_68059_68077 = state_68039__$1;
(statearr_68059_68077[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__11438__auto____0 = (function (){
var statearr_68060 = [null,null,null,null,null,null,null,null,null];
(statearr_68060[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__11438__auto__);

(statearr_68060[(1)] = (1));

return statearr_68060;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__11438__auto____1 = (function (state_68039){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_68039);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e68061){var ex__11441__auto__ = e68061;
var statearr_68062_68078 = state_68039;
(statearr_68062_68078[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_68039[(4)]))){
var statearr_68063_68079 = state_68039;
(statearr_68063_68079[(1)] = cljs.core.first((state_68039[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68080 = state_68039;
state_68039 = G__68080;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__11438__auto__ = function(state_68039){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__11438__auto____1.call(this,state_68039);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_68064 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_68064[(6)] = c__11512__auto__);

return statearr_68064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_68118){
var state_val_68119 = (state_68118[(1)]);
if((state_val_68119 === (7))){
var state_68118__$1 = state_68118;
var statearr_68120_68144 = state_68118__$1;
(statearr_68120_68144[(2)] = n);

(statearr_68120_68144[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68119 === (1))){
var state_68118__$1 = state_68118;
var statearr_68121_68145 = state_68118__$1;
(statearr_68121_68145[(2)] = null);

(statearr_68121_68145[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68119 === (4))){
var inst_68081 = (state_68118[(2)]);
var state_68118__$1 = state_68118;
var statearr_68122_68146 = state_68118__$1;
(statearr_68122_68146[(2)] = inst_68081);

(statearr_68122_68146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68119 === (13))){
var inst_68098 = (state_68118[(2)]);
var inst_68099 = fluree.db.util.async.throw_err(inst_68098);
var state_68118__$1 = state_68118;
var statearr_68123_68147 = state_68118__$1;
(statearr_68123_68147[(2)] = inst_68099);

(statearr_68123_68147[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68119 === (6))){
var state_68118__$1 = state_68118;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68118__$1,(9),n);
} else {
if((state_val_68119 === (3))){
var inst_68116 = (state_68118[(2)]);
var state_68118__$1 = state_68118;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68118__$1,inst_68116);
} else {
if((state_val_68119 === (12))){
var inst_68094 = (state_68118[(7)]);
var inst_68102 = (state_68118[(2)]);
var inst_68103 = fluree.db.dbfunctions.internal.mod(inst_68094,inst_68102);
var inst_68104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68105 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68107 = [inst_68094,inst_68102];
var inst_68108 = (new cljs.core.PersistentVector(null,2,(5),inst_68106,inst_68107,null));
var inst_68109 = ["mod",inst_68108,inst_68103];
var inst_68110 = cljs.core.PersistentHashMap.fromArrays(inst_68105,inst_68109);
var inst_68111 = [inst_68110,(2)];
var inst_68112 = (new cljs.core.PersistentVector(null,2,(5),inst_68104,inst_68111,null));
var inst_68113 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68112);
var _ = (function (){var statearr_68124 = state_68118;
(statearr_68124[(4)] = cljs.core.rest((state_68118[(4)])));

return statearr_68124;
})();
var state_68118__$1 = (function (){var statearr_68125 = state_68118;
(statearr_68125[(8)] = inst_68113);

return statearr_68125;
})();
var statearr_68126_68148 = state_68118__$1;
(statearr_68126_68148[(2)] = inst_68103);

(statearr_68126_68148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68119 === (2))){
var _ = (function (){var statearr_68127 = state_68118;
(statearr_68127[(4)] = cljs.core.cons((5),(state_68118[(4)])));

return statearr_68127;
})();
var inst_68087 = fluree.db.util.async.channel_QMARK_(n);
var state_68118__$1 = state_68118;
if(inst_68087){
var statearr_68128_68149 = state_68118__$1;
(statearr_68128_68149[(1)] = (6));

} else {
var statearr_68129_68150 = state_68118__$1;
(statearr_68129_68150[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68119 === (11))){
var state_68118__$1 = state_68118;
var statearr_68131_68151 = state_68118__$1;
(statearr_68131_68151[(2)] = d);

(statearr_68131_68151[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68119 === (9))){
var inst_68090 = (state_68118[(2)]);
var inst_68091 = fluree.db.util.async.throw_err(inst_68090);
var state_68118__$1 = state_68118;
var statearr_68132_68152 = state_68118__$1;
(statearr_68132_68152[(2)] = inst_68091);

(statearr_68132_68152[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68119 === (5))){
var _ = (function (){var statearr_68133 = state_68118;
(statearr_68133[(4)] = cljs.core.rest((state_68118[(4)])));

return statearr_68133;
})();
var state_68118__$1 = state_68118;
var ex68130 = (state_68118__$1[(2)]);
var statearr_68134_68153 = state_68118__$1;
(statearr_68134_68153[(5)] = ex68130);


if((ex68130 instanceof Error)){
var statearr_68135_68154 = state_68118__$1;
(statearr_68135_68154[(1)] = (4));

(statearr_68135_68154[(5)] = null);

} else {
throw ex68130;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68119 === (10))){
var state_68118__$1 = state_68118;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68118__$1,(13),d);
} else {
if((state_val_68119 === (8))){
var inst_68094 = (state_68118[(2)]);
var inst_68095 = fluree.db.util.async.channel_QMARK_(d);
var state_68118__$1 = (function (){var statearr_68136 = state_68118;
(statearr_68136[(7)] = inst_68094);

return statearr_68136;
})();
if(inst_68095){
var statearr_68137_68155 = state_68118__$1;
(statearr_68137_68155[(1)] = (10));

} else {
var statearr_68138_68156 = state_68118__$1;
(statearr_68138_68156[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__11438__auto____0 = (function (){
var statearr_68139 = [null,null,null,null,null,null,null,null,null];
(statearr_68139[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__11438__auto__);

(statearr_68139[(1)] = (1));

return statearr_68139;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__11438__auto____1 = (function (state_68118){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_68118);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e68140){var ex__11441__auto__ = e68140;
var statearr_68141_68157 = state_68118;
(statearr_68141_68157[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_68118[(4)]))){
var statearr_68142_68158 = state_68118;
(statearr_68142_68158[(1)] = cljs.core.first((state_68118[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68159 = state_68118;
state_68118 = G__68159;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__11438__auto__ = function(state_68118){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__11438__auto____1.call(this,state_68118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_68143 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_68143[(6)] = c__11512__auto__);

return statearr_68143;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_68197){
var state_val_68198 = (state_68197[(1)]);
if((state_val_68198 === (7))){
var state_68197__$1 = state_68197;
var statearr_68199_68223 = state_68197__$1;
(statearr_68199_68223[(2)] = n);

(statearr_68199_68223[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68198 === (1))){
var state_68197__$1 = state_68197;
var statearr_68200_68224 = state_68197__$1;
(statearr_68200_68224[(2)] = null);

(statearr_68200_68224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68198 === (4))){
var inst_68160 = (state_68197[(2)]);
var state_68197__$1 = state_68197;
var statearr_68201_68225 = state_68197__$1;
(statearr_68201_68225[(2)] = inst_68160);

(statearr_68201_68225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68198 === (13))){
var inst_68177 = (state_68197[(2)]);
var inst_68178 = fluree.db.util.async.throw_err(inst_68177);
var state_68197__$1 = state_68197;
var statearr_68202_68226 = state_68197__$1;
(statearr_68202_68226[(2)] = inst_68178);

(statearr_68202_68226[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68198 === (6))){
var state_68197__$1 = state_68197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68197__$1,(9),n);
} else {
if((state_val_68198 === (3))){
var inst_68195 = (state_68197[(2)]);
var state_68197__$1 = state_68197;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68197__$1,inst_68195);
} else {
if((state_val_68198 === (12))){
var inst_68173 = (state_68197[(7)]);
var inst_68181 = (state_68197[(2)]);
var inst_68182 = fluree.db.dbfunctions.internal.rem(inst_68173,inst_68181);
var inst_68183 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68184 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68186 = [inst_68173,inst_68181];
var inst_68187 = (new cljs.core.PersistentVector(null,2,(5),inst_68185,inst_68186,null));
var inst_68188 = ["rem",inst_68187,inst_68182];
var inst_68189 = cljs.core.PersistentHashMap.fromArrays(inst_68184,inst_68188);
var inst_68190 = [inst_68189,(2)];
var inst_68191 = (new cljs.core.PersistentVector(null,2,(5),inst_68183,inst_68190,null));
var inst_68192 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68191);
var _ = (function (){var statearr_68203 = state_68197;
(statearr_68203[(4)] = cljs.core.rest((state_68197[(4)])));

return statearr_68203;
})();
var state_68197__$1 = (function (){var statearr_68204 = state_68197;
(statearr_68204[(8)] = inst_68192);

return statearr_68204;
})();
var statearr_68205_68227 = state_68197__$1;
(statearr_68205_68227[(2)] = inst_68182);

(statearr_68205_68227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68198 === (2))){
var _ = (function (){var statearr_68206 = state_68197;
(statearr_68206[(4)] = cljs.core.cons((5),(state_68197[(4)])));

return statearr_68206;
})();
var inst_68166 = fluree.db.util.async.channel_QMARK_(n);
var state_68197__$1 = state_68197;
if(inst_68166){
var statearr_68207_68228 = state_68197__$1;
(statearr_68207_68228[(1)] = (6));

} else {
var statearr_68208_68229 = state_68197__$1;
(statearr_68208_68229[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68198 === (11))){
var state_68197__$1 = state_68197;
var statearr_68210_68230 = state_68197__$1;
(statearr_68210_68230[(2)] = d);

(statearr_68210_68230[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68198 === (9))){
var inst_68169 = (state_68197[(2)]);
var inst_68170 = fluree.db.util.async.throw_err(inst_68169);
var state_68197__$1 = state_68197;
var statearr_68211_68231 = state_68197__$1;
(statearr_68211_68231[(2)] = inst_68170);

(statearr_68211_68231[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68198 === (5))){
var _ = (function (){var statearr_68212 = state_68197;
(statearr_68212[(4)] = cljs.core.rest((state_68197[(4)])));

return statearr_68212;
})();
var state_68197__$1 = state_68197;
var ex68209 = (state_68197__$1[(2)]);
var statearr_68213_68232 = state_68197__$1;
(statearr_68213_68232[(5)] = ex68209);


if((ex68209 instanceof Error)){
var statearr_68214_68233 = state_68197__$1;
(statearr_68214_68233[(1)] = (4));

(statearr_68214_68233[(5)] = null);

} else {
throw ex68209;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68198 === (10))){
var state_68197__$1 = state_68197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68197__$1,(13),d);
} else {
if((state_val_68198 === (8))){
var inst_68173 = (state_68197[(2)]);
var inst_68174 = fluree.db.util.async.channel_QMARK_(d);
var state_68197__$1 = (function (){var statearr_68215 = state_68197;
(statearr_68215[(7)] = inst_68173);

return statearr_68215;
})();
if(inst_68174){
var statearr_68216_68234 = state_68197__$1;
(statearr_68216_68234[(1)] = (10));

} else {
var statearr_68217_68235 = state_68197__$1;
(statearr_68217_68235[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__11438__auto____0 = (function (){
var statearr_68218 = [null,null,null,null,null,null,null,null,null];
(statearr_68218[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__11438__auto__);

(statearr_68218[(1)] = (1));

return statearr_68218;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__11438__auto____1 = (function (state_68197){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_68197);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e68219){var ex__11441__auto__ = e68219;
var statearr_68220_68236 = state_68197;
(statearr_68220_68236[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_68197[(4)]))){
var statearr_68221_68237 = state_68197;
(statearr_68221_68237[(1)] = cljs.core.first((state_68197[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68238 = state_68197;
state_68197 = G__68238;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__11438__auto__ = function(state_68197){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__11438__auto____1.call(this,state_68197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_68222 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_68222[(6)] = c__11512__auto__);

return statearr_68222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_68265){
var state_val_68266 = (state_68265[(1)]);
if((state_val_68266 === (7))){
var state_68265__$1 = state_68265;
var statearr_68267_68286 = state_68265__$1;
(statearr_68267_68286[(2)] = x);

(statearr_68267_68286[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68266 === (1))){
var state_68265__$1 = state_68265;
var statearr_68268_68287 = state_68265__$1;
(statearr_68268_68287[(2)] = null);

(statearr_68268_68287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68266 === (4))){
var inst_68239 = (state_68265[(2)]);
var state_68265__$1 = state_68265;
var statearr_68269_68288 = state_68265__$1;
(statearr_68269_68288[(2)] = inst_68239);

(statearr_68269_68288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68266 === (6))){
var state_68265__$1 = state_68265;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68265__$1,(9),x);
} else {
if((state_val_68266 === (3))){
var inst_68263 = (state_68265[(2)]);
var state_68265__$1 = state_68265;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68265__$1,inst_68263);
} else {
if((state_val_68266 === (2))){
var _ = (function (){var statearr_68271 = state_68265;
(statearr_68271[(4)] = cljs.core.cons((5),(state_68265[(4)])));

return statearr_68271;
})();
var inst_68245 = fluree.db.util.async.channel_QMARK_(x);
var state_68265__$1 = state_68265;
if(inst_68245){
var statearr_68272_68289 = state_68265__$1;
(statearr_68272_68289[(1)] = (6));

} else {
var statearr_68273_68290 = state_68265__$1;
(statearr_68273_68290[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68266 === (9))){
var inst_68248 = (state_68265[(2)]);
var inst_68249 = fluree.db.util.async.throw_err(inst_68248);
var state_68265__$1 = state_68265;
var statearr_68274_68291 = state_68265__$1;
(statearr_68274_68291[(2)] = inst_68249);

(statearr_68274_68291[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68266 === (5))){
var _ = (function (){var statearr_68275 = state_68265;
(statearr_68275[(4)] = cljs.core.rest((state_68265[(4)])));

return statearr_68275;
})();
var state_68265__$1 = state_68265;
var ex68270 = (state_68265__$1[(2)]);
var statearr_68276_68292 = state_68265__$1;
(statearr_68276_68292[(5)] = ex68270);


if((ex68270 instanceof Error)){
var statearr_68277_68293 = state_68265__$1;
(statearr_68277_68293[(1)] = (4));

(statearr_68277_68293[(5)] = null);

} else {
throw ex68270;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68266 === (8))){
var inst_68252 = (state_68265[(2)]);
var inst_68253 = fluree.db.dbfunctions.internal.boolean$(inst_68252);
var inst_68254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68255 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68256 = ["boolean",inst_68252,inst_68253];
var inst_68257 = cljs.core.PersistentHashMap.fromArrays(inst_68255,inst_68256);
var inst_68258 = [inst_68257,(10)];
var inst_68259 = (new cljs.core.PersistentVector(null,2,(5),inst_68254,inst_68258,null));
var inst_68260 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68259);
var _ = (function (){var statearr_68278 = state_68265;
(statearr_68278[(4)] = cljs.core.rest((state_68265[(4)])));

return statearr_68278;
})();
var state_68265__$1 = (function (){var statearr_68279 = state_68265;
(statearr_68279[(7)] = inst_68260);

return statearr_68279;
})();
var statearr_68280_68294 = state_68265__$1;
(statearr_68280_68294[(2)] = inst_68253);

(statearr_68280_68294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__11438__auto____0 = (function (){
var statearr_68281 = [null,null,null,null,null,null,null,null];
(statearr_68281[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__11438__auto__);

(statearr_68281[(1)] = (1));

return statearr_68281;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__11438__auto____1 = (function (state_68265){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_68265);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e68282){var ex__11441__auto__ = e68282;
var statearr_68283_68295 = state_68265;
(statearr_68283_68295[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_68265[(4)]))){
var statearr_68284_68296 = state_68265;
(statearr_68284_68296[(1)] = cljs.core.first((state_68265[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68297 = state_68265;
state_68265 = G__68297;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__11438__auto__ = function(state_68265){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__11438__auto____1.call(this,state_68265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_68285 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_68285[(6)] = c__11512__auto__);

return statearr_68285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_68335){
var state_val_68336 = (state_68335[(1)]);
if((state_val_68336 === (7))){
var state_68335__$1 = state_68335;
var statearr_68337_68361 = state_68335__$1;
(statearr_68337_68361[(2)] = pattern);

(statearr_68337_68361[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68336 === (1))){
var state_68335__$1 = state_68335;
var statearr_68338_68362 = state_68335__$1;
(statearr_68338_68362[(2)] = null);

(statearr_68338_68362[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68336 === (4))){
var inst_68298 = (state_68335[(2)]);
var state_68335__$1 = state_68335;
var statearr_68339_68363 = state_68335__$1;
(statearr_68339_68363[(2)] = inst_68298);

(statearr_68339_68363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68336 === (13))){
var inst_68315 = (state_68335[(2)]);
var inst_68316 = fluree.db.util.async.throw_err(inst_68315);
var state_68335__$1 = state_68335;
var statearr_68340_68364 = state_68335__$1;
(statearr_68340_68364[(2)] = inst_68316);

(statearr_68340_68364[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68336 === (6))){
var state_68335__$1 = state_68335;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68335__$1,(9),pattern);
} else {
if((state_val_68336 === (3))){
var inst_68333 = (state_68335[(2)]);
var state_68335__$1 = state_68335;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68335__$1,inst_68333);
} else {
if((state_val_68336 === (12))){
var inst_68311 = (state_68335[(7)]);
var inst_68319 = (state_68335[(2)]);
var inst_68320 = fluree.db.dbfunctions.internal.re_find(inst_68311,inst_68319);
var inst_68321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68322 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68324 = [inst_68311,inst_68319];
var inst_68325 = (new cljs.core.PersistentVector(null,2,(5),inst_68323,inst_68324,null));
var inst_68326 = ["re-find",inst_68325,inst_68320];
var inst_68327 = cljs.core.PersistentHashMap.fromArrays(inst_68322,inst_68326);
var inst_68328 = [inst_68327,(10)];
var inst_68329 = (new cljs.core.PersistentVector(null,2,(5),inst_68321,inst_68328,null));
var inst_68330 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68329);
var _ = (function (){var statearr_68341 = state_68335;
(statearr_68341[(4)] = cljs.core.rest((state_68335[(4)])));

return statearr_68341;
})();
var state_68335__$1 = (function (){var statearr_68342 = state_68335;
(statearr_68342[(8)] = inst_68330);

return statearr_68342;
})();
var statearr_68343_68365 = state_68335__$1;
(statearr_68343_68365[(2)] = inst_68320);

(statearr_68343_68365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68336 === (2))){
var _ = (function (){var statearr_68344 = state_68335;
(statearr_68344[(4)] = cljs.core.cons((5),(state_68335[(4)])));

return statearr_68344;
})();
var inst_68304 = fluree.db.util.async.channel_QMARK_(pattern);
var state_68335__$1 = state_68335;
if(inst_68304){
var statearr_68345_68366 = state_68335__$1;
(statearr_68345_68366[(1)] = (6));

} else {
var statearr_68346_68367 = state_68335__$1;
(statearr_68346_68367[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68336 === (11))){
var state_68335__$1 = state_68335;
var statearr_68348_68368 = state_68335__$1;
(statearr_68348_68368[(2)] = string);

(statearr_68348_68368[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68336 === (9))){
var inst_68307 = (state_68335[(2)]);
var inst_68308 = fluree.db.util.async.throw_err(inst_68307);
var state_68335__$1 = state_68335;
var statearr_68349_68369 = state_68335__$1;
(statearr_68349_68369[(2)] = inst_68308);

(statearr_68349_68369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68336 === (5))){
var _ = (function (){var statearr_68350 = state_68335;
(statearr_68350[(4)] = cljs.core.rest((state_68335[(4)])));

return statearr_68350;
})();
var state_68335__$1 = state_68335;
var ex68347 = (state_68335__$1[(2)]);
var statearr_68351_68370 = state_68335__$1;
(statearr_68351_68370[(5)] = ex68347);


if((ex68347 instanceof Error)){
var statearr_68352_68371 = state_68335__$1;
(statearr_68352_68371[(1)] = (4));

(statearr_68352_68371[(5)] = null);

} else {
throw ex68347;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68336 === (10))){
var state_68335__$1 = state_68335;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68335__$1,(13),string);
} else {
if((state_val_68336 === (8))){
var inst_68311 = (state_68335[(2)]);
var inst_68312 = fluree.db.util.async.channel_QMARK_(string);
var state_68335__$1 = (function (){var statearr_68353 = state_68335;
(statearr_68353[(7)] = inst_68311);

return statearr_68353;
})();
if(inst_68312){
var statearr_68354_68372 = state_68335__$1;
(statearr_68354_68372[(1)] = (10));

} else {
var statearr_68355_68373 = state_68335__$1;
(statearr_68355_68373[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__11438__auto____0 = (function (){
var statearr_68356 = [null,null,null,null,null,null,null,null,null];
(statearr_68356[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__11438__auto__);

(statearr_68356[(1)] = (1));

return statearr_68356;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__11438__auto____1 = (function (state_68335){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_68335);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e68357){var ex__11441__auto__ = e68357;
var statearr_68358_68374 = state_68335;
(statearr_68358_68374[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_68335[(4)]))){
var statearr_68359_68375 = state_68335;
(statearr_68359_68375[(1)] = cljs.core.first((state_68335[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68376 = state_68335;
state_68335 = G__68376;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__11438__auto__ = function(state_68335){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__11438__auto____1.call(this,state_68335);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_68360 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_68360[(6)] = c__11512__auto__);

return statearr_68360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_68403){
var state_val_68404 = (state_68403[(1)]);
if((state_val_68404 === (7))){
var state_68403__$1 = state_68403;
var statearr_68405_68424 = state_68403__$1;
(statearr_68405_68424[(2)] = email);

(statearr_68405_68424[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68404 === (1))){
var state_68403__$1 = state_68403;
var statearr_68406_68425 = state_68403__$1;
(statearr_68406_68425[(2)] = null);

(statearr_68406_68425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68404 === (4))){
var inst_68377 = (state_68403[(2)]);
var state_68403__$1 = state_68403;
var statearr_68407_68426 = state_68403__$1;
(statearr_68407_68426[(2)] = inst_68377);

(statearr_68407_68426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68404 === (6))){
var state_68403__$1 = state_68403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68403__$1,(9),email);
} else {
if((state_val_68404 === (3))){
var inst_68401 = (state_68403[(2)]);
var state_68403__$1 = state_68403;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68403__$1,inst_68401);
} else {
if((state_val_68404 === (2))){
var _ = (function (){var statearr_68409 = state_68403;
(statearr_68409[(4)] = cljs.core.cons((5),(state_68403[(4)])));

return statearr_68409;
})();
var inst_68383 = fluree.db.util.async.channel_QMARK_(email);
var state_68403__$1 = state_68403;
if(inst_68383){
var statearr_68410_68427 = state_68403__$1;
(statearr_68410_68427[(1)] = (6));

} else {
var statearr_68411_68428 = state_68403__$1;
(statearr_68411_68428[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68404 === (9))){
var inst_68386 = (state_68403[(2)]);
var inst_68387 = fluree.db.util.async.throw_err(inst_68386);
var state_68403__$1 = state_68403;
var statearr_68412_68429 = state_68403__$1;
(statearr_68412_68429[(2)] = inst_68387);

(statearr_68412_68429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68404 === (5))){
var _ = (function (){var statearr_68413 = state_68403;
(statearr_68413[(4)] = cljs.core.rest((state_68403[(4)])));

return statearr_68413;
})();
var state_68403__$1 = state_68403;
var ex68408 = (state_68403__$1[(2)]);
var statearr_68414_68430 = state_68403__$1;
(statearr_68414_68430[(5)] = ex68408);


if((ex68408 instanceof Error)){
var statearr_68415_68431 = state_68403__$1;
(statearr_68415_68431[(1)] = (4));

(statearr_68415_68431[(5)] = null);

} else {
throw ex68408;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68404 === (8))){
var inst_68390 = (state_68403[(2)]);
var inst_68391 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_68390);
var inst_68392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68393 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68394 = ["re-find",inst_68390,inst_68391];
var inst_68395 = cljs.core.PersistentHashMap.fromArrays(inst_68393,inst_68394);
var inst_68396 = [inst_68395,(10)];
var inst_68397 = (new cljs.core.PersistentVector(null,2,(5),inst_68392,inst_68396,null));
var inst_68398 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68397);
var _ = (function (){var statearr_68416 = state_68403;
(statearr_68416[(4)] = cljs.core.rest((state_68403[(4)])));

return statearr_68416;
})();
var state_68403__$1 = (function (){var statearr_68417 = state_68403;
(statearr_68417[(7)] = inst_68398);

return statearr_68417;
})();
var statearr_68418_68432 = state_68403__$1;
(statearr_68418_68432[(2)] = inst_68391);

(statearr_68418_68432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11438__auto____0 = (function (){
var statearr_68419 = [null,null,null,null,null,null,null,null];
(statearr_68419[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11438__auto__);

(statearr_68419[(1)] = (1));

return statearr_68419;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11438__auto____1 = (function (state_68403){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_68403);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e68420){var ex__11441__auto__ = e68420;
var statearr_68421_68433 = state_68403;
(statearr_68421_68433[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_68403[(4)]))){
var statearr_68422_68434 = state_68403;
(statearr_68422_68434[(1)] = cljs.core.first((state_68403[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68435 = state_68403;
state_68403 = G__68435;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11438__auto__ = function(state_68403){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11438__auto____1.call(this,state_68403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_68423 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_68423[(6)] = c__11512__auto__);

return statearr_68423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_68482){
var state_val_68483 = (state_68482[(1)]);
if((state_val_68483 === (7))){
var inst_68452 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_68482__$1 = state_68482;
if(cljs.core.truth_(inst_68452)){
var statearr_68484_68511 = state_68482__$1;
(statearr_68484_68511[(1)] = (9));

} else {
var statearr_68485_68512 = state_68482__$1;
(statearr_68485_68512[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (1))){
var state_68482__$1 = state_68482;
var statearr_68486_68513 = state_68482__$1;
(statearr_68486_68513[(2)] = null);

(statearr_68486_68513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (4))){
var inst_68436 = (state_68482[(2)]);
var state_68482__$1 = state_68482;
var statearr_68487_68514 = state_68482__$1;
(statearr_68487_68514[(2)] = inst_68436);

(statearr_68487_68514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (15))){
var inst_68463 = (state_68482[(2)]);
var state_68482__$1 = state_68482;
var statearr_68488_68515 = state_68482__$1;
(statearr_68488_68515[(2)] = inst_68463);

(statearr_68488_68515[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (13))){
var inst_68460 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_68482__$1 = state_68482;
var statearr_68489_68516 = state_68482__$1;
(statearr_68489_68516[(2)] = inst_68460);

(statearr_68489_68516[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (6))){
var inst_68447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68448 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_68449 = [inst_68448,(0)];
var inst_68450 = (new cljs.core.PersistentVector(null,2,(5),inst_68447,inst_68449,null));
var state_68482__$1 = state_68482;
var statearr_68490_68517 = state_68482__$1;
(statearr_68490_68517[(2)] = inst_68450);

(statearr_68490_68517[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (3))){
var inst_68480 = (state_68482[(2)]);
var state_68482__$1 = state_68482;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68482__$1,inst_68480);
} else {
if((state_val_68483 === (12))){
var inst_68456 = (state_68482[(2)]);
var inst_68457 = fluree.db.util.async.throw_err(inst_68456);
var state_68482__$1 = state_68482;
var statearr_68491_68518 = state_68482__$1;
(statearr_68491_68518[(2)] = inst_68457);

(statearr_68491_68518[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (2))){
var _ = (function (){var statearr_68492 = state_68482;
(statearr_68492[(4)] = cljs.core.cons((5),(state_68482[(4)])));

return statearr_68492;
})();
var inst_68445 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_68482__$1 = state_68482;
if(cljs.core.truth_(inst_68445)){
var statearr_68493_68519 = state_68482__$1;
(statearr_68493_68519[(1)] = (6));

} else {
var statearr_68494_68520 = state_68482__$1;
(statearr_68494_68520[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (11))){
var inst_68465 = (state_68482[(2)]);
var state_68482__$1 = state_68482;
var statearr_68496_68521 = state_68482__$1;
(statearr_68496_68521[(2)] = inst_68465);

(statearr_68496_68521[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (9))){
var inst_68454 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_68482__$1 = state_68482;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68482__$1,(12),inst_68454);
} else {
if((state_val_68483 === (5))){
var _ = (function (){var statearr_68497 = state_68482;
(statearr_68497[(4)] = cljs.core.rest((state_68482[(4)])));

return statearr_68497;
})();
var state_68482__$1 = state_68482;
var ex68495 = (state_68482__$1[(2)]);
var statearr_68498_68522 = state_68482__$1;
(statearr_68498_68522[(5)] = ex68495);


if((ex68495 instanceof Error)){
var statearr_68499_68523 = state_68482__$1;
(statearr_68499_68523[(1)] = (4));

(statearr_68499_68523[(5)] = null);

} else {
throw ex68495;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (14))){
var state_68482__$1 = state_68482;
var statearr_68500_68524 = state_68482__$1;
(statearr_68500_68524[(2)] = null);

(statearr_68500_68524[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (10))){
var state_68482__$1 = state_68482;
var statearr_68501_68525 = state_68482__$1;
(statearr_68501_68525[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (8))){
var inst_68467 = (state_68482[(2)]);
var inst_68468 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68467,(0),null);
var inst_68469 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68467,(1),null);
var inst_68470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68471 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68472 = ["?user_id","?ctx",inst_68468];
var inst_68473 = cljs.core.PersistentHashMap.fromArrays(inst_68471,inst_68472);
var inst_68474 = ((10) + inst_68469);
var inst_68475 = [inst_68473,inst_68474];
var inst_68476 = (new cljs.core.PersistentVector(null,2,(5),inst_68470,inst_68475,null));
var inst_68477 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68476);
var _ = (function (){var statearr_68503 = state_68482;
(statearr_68503[(4)] = cljs.core.rest((state_68482[(4)])));

return statearr_68503;
})();
var state_68482__$1 = (function (){var statearr_68504 = state_68482;
(statearr_68504[(7)] = inst_68477);

return statearr_68504;
})();
var statearr_68505_68526 = state_68482__$1;
(statearr_68505_68526[(2)] = inst_68468);

(statearr_68505_68526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11438__auto____0 = (function (){
var statearr_68506 = [null,null,null,null,null,null,null,null];
(statearr_68506[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11438__auto__);

(statearr_68506[(1)] = (1));

return statearr_68506;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11438__auto____1 = (function (state_68482){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_68482);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e68507){var ex__11441__auto__ = e68507;
var statearr_68508_68527 = state_68482;
(statearr_68508_68527[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_68482[(4)]))){
var statearr_68509_68528 = state_68482;
(statearr_68509_68528[(1)] = cljs.core.first((state_68482[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68529 = state_68482;
state_68482 = G__68529;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11438__auto__ = function(state_68482){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11438__auto____1.call(this,state_68482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_68510 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_68510[(6)] = c__11512__auto__);

return statearr_68510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_68557){
var state_val_68558 = (state_68557[(1)]);
if((state_val_68558 === (7))){
var inst_68550 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_68557__$1 = state_68557;
var statearr_68559_68578 = state_68557__$1;
(statearr_68559_68578[(2)] = inst_68550);

(statearr_68559_68578[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68558 === (1))){
var state_68557__$1 = state_68557;
var statearr_68560_68579 = state_68557__$1;
(statearr_68560_68579[(2)] = null);

(statearr_68560_68579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68558 === (4))){
var inst_68530 = (state_68557[(2)]);
var state_68557__$1 = state_68557;
var statearr_68561_68580 = state_68557__$1;
(statearr_68561_68580[(2)] = inst_68530);

(statearr_68561_68580[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68558 === (6))){
var inst_68538 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_68557__$1 = state_68557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68557__$1,(9),inst_68538);
} else {
if((state_val_68558 === (3))){
var inst_68555 = (state_68557[(2)]);
var state_68557__$1 = state_68557;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68557__$1,inst_68555);
} else {
if((state_val_68558 === (2))){
var _ = (function (){var statearr_68563 = state_68557;
(statearr_68563[(4)] = cljs.core.cons((5),(state_68557[(4)])));

return statearr_68563;
})();
var inst_68536 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_68557__$1 = state_68557;
if(cljs.core.truth_(inst_68536)){
var statearr_68564_68581 = state_68557__$1;
(statearr_68564_68581[(1)] = (6));

} else {
var statearr_68565_68582 = state_68557__$1;
(statearr_68565_68582[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68558 === (9))){
var inst_68540 = (state_68557[(2)]);
var inst_68541 = fluree.db.util.async.throw_err(inst_68540);
var inst_68542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68543 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68544 = ["?auth_id","?ctx",inst_68541];
var inst_68545 = cljs.core.PersistentHashMap.fromArrays(inst_68543,inst_68544);
var inst_68546 = [inst_68545,(10)];
var inst_68547 = (new cljs.core.PersistentVector(null,2,(5),inst_68542,inst_68546,null));
var inst_68548 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68547);
var state_68557__$1 = (function (){var statearr_68566 = state_68557;
(statearr_68566[(7)] = inst_68548);

return statearr_68566;
})();
var statearr_68567_68583 = state_68557__$1;
(statearr_68567_68583[(2)] = inst_68541);

(statearr_68567_68583[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68558 === (5))){
var _ = (function (){var statearr_68568 = state_68557;
(statearr_68568[(4)] = cljs.core.rest((state_68557[(4)])));

return statearr_68568;
})();
var state_68557__$1 = state_68557;
var ex68562 = (state_68557__$1[(2)]);
var statearr_68569_68584 = state_68557__$1;
(statearr_68569_68584[(5)] = ex68562);


if((ex68562 instanceof Error)){
var statearr_68570_68585 = state_68557__$1;
(statearr_68570_68585[(1)] = (4));

(statearr_68570_68585[(5)] = null);

} else {
throw ex68562;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68558 === (8))){
var inst_68552 = (state_68557[(2)]);
var _ = (function (){var statearr_68571 = state_68557;
(statearr_68571[(4)] = cljs.core.rest((state_68557[(4)])));

return statearr_68571;
})();
var state_68557__$1 = state_68557;
var statearr_68572_68586 = state_68557__$1;
(statearr_68572_68586[(2)] = inst_68552);

(statearr_68572_68586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11438__auto____0 = (function (){
var statearr_68573 = [null,null,null,null,null,null,null,null];
(statearr_68573[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11438__auto__);

(statearr_68573[(1)] = (1));

return statearr_68573;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11438__auto____1 = (function (state_68557){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_68557);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e68574){var ex__11441__auto__ = e68574;
var statearr_68575_68587 = state_68557;
(statearr_68575_68587[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_68557[(4)]))){
var statearr_68576_68588 = state_68557;
(statearr_68576_68588[(1)] = cljs.core.first((state_68557[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68589 = state_68557;
state_68557 = G__68589;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11438__auto__ = function(state_68557){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11438__auto____1.call(this,state_68557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_68577 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_68577[(6)] = c__11512__auto__);

return statearr_68577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__68591 = arguments.length;
switch (G__68591) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_68633){
var state_val_68634 = (state_68633[(1)]);
if((state_val_68634 === (7))){
var state_68633__$1 = state_68633;
var statearr_68635_68665 = state_68633__$1;
(statearr_68635_68665[(2)] = seed);

(statearr_68635_68665[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68634 === (1))){
var state_68633__$1 = state_68633;
var statearr_68636_68666 = state_68633__$1;
(statearr_68636_68666[(2)] = null);

(statearr_68636_68666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68634 === (4))){
var inst_68592 = (state_68633[(2)]);
var state_68633__$1 = state_68633;
var statearr_68637_68667 = state_68633__$1;
(statearr_68637_68667[(2)] = inst_68592);

(statearr_68637_68667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68634 === (15))){
var state_68633__$1 = state_68633;
var statearr_68638_68668 = state_68633__$1;
(statearr_68638_68668[(2)] = (10));

(statearr_68638_68668[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68634 === (13))){
var inst_68609 = (state_68633[(2)]);
var inst_68610 = fluree.db.util.async.throw_err(inst_68609);
var state_68633__$1 = state_68633;
var statearr_68639_68669 = state_68633__$1;
(statearr_68639_68669[(2)] = inst_68610);

(statearr_68639_68669[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68634 === (6))){
var state_68633__$1 = state_68633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68633__$1,(9),seed);
} else {
if((state_val_68634 === (3))){
var inst_68631 = (state_68633[(2)]);
var state_68633__$1 = state_68633;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68633__$1,inst_68631);
} else {
if((state_val_68634 === (12))){
var inst_68613 = (state_68633[(7)]);
var inst_68613__$1 = (state_68633[(2)]);
var state_68633__$1 = (function (){var statearr_68640 = state_68633;
(statearr_68640[(7)] = inst_68613__$1);

return statearr_68640;
})();
if(cljs.core.truth_(inst_68613__$1)){
var statearr_68641_68670 = state_68633__$1;
(statearr_68641_68670[(1)] = (14));

} else {
var statearr_68642_68671 = state_68633__$1;
(statearr_68642_68671[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68634 === (2))){
var _ = (function (){var statearr_68643 = state_68633;
(statearr_68643[(4)] = cljs.core.cons((5),(state_68633[(4)])));

return statearr_68643;
})();
var inst_68598 = fluree.db.util.async.channel_QMARK_(seed);
var state_68633__$1 = state_68633;
if(inst_68598){
var statearr_68644_68672 = state_68633__$1;
(statearr_68644_68672[(1)] = (6));

} else {
var statearr_68645_68673 = state_68633__$1;
(statearr_68645_68673[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68634 === (11))){
var state_68633__$1 = state_68633;
var statearr_68647_68674 = state_68633__$1;
(statearr_68647_68674[(2)] = max);

(statearr_68647_68674[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68634 === (9))){
var inst_68601 = (state_68633[(2)]);
var inst_68602 = fluree.db.util.async.throw_err(inst_68601);
var state_68633__$1 = state_68633;
var statearr_68648_68675 = state_68633__$1;
(statearr_68648_68675[(2)] = inst_68602);

(statearr_68648_68675[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68634 === (5))){
var _ = (function (){var statearr_68649 = state_68633;
(statearr_68649[(4)] = cljs.core.rest((state_68633[(4)])));

return statearr_68649;
})();
var state_68633__$1 = state_68633;
var ex68646 = (state_68633__$1[(2)]);
var statearr_68650_68676 = state_68633__$1;
(statearr_68650_68676[(5)] = ex68646);


if((ex68646 instanceof Error)){
var statearr_68651_68677 = state_68633__$1;
(statearr_68651_68677[(1)] = (4));

(statearr_68651_68677[(5)] = null);

} else {
throw ex68646;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68634 === (14))){
var inst_68613 = (state_68633[(7)]);
var state_68633__$1 = state_68633;
var statearr_68652_68678 = state_68633__$1;
(statearr_68652_68678[(2)] = inst_68613);

(statearr_68652_68678[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68634 === (16))){
var inst_68605 = (state_68633[(8)]);
var inst_68617 = (state_68633[(2)]);
var inst_68618 = fluree.db.dbfunctions.internal.rand(inst_68605,inst_68617);
var inst_68619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68620 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68622 = [max,seed];
var inst_68623 = (new cljs.core.PersistentVector(null,2,(5),inst_68621,inst_68622,null));
var inst_68624 = ["rand",inst_68623,inst_68618];
var inst_68625 = cljs.core.PersistentHashMap.fromArrays(inst_68620,inst_68624);
var inst_68626 = [inst_68625,(10)];
var inst_68627 = (new cljs.core.PersistentVector(null,2,(5),inst_68619,inst_68626,null));
var inst_68628 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68627);
var _ = (function (){var statearr_68653 = state_68633;
(statearr_68653[(4)] = cljs.core.rest((state_68633[(4)])));

return statearr_68653;
})();
var state_68633__$1 = (function (){var statearr_68654 = state_68633;
(statearr_68654[(9)] = inst_68628);

return statearr_68654;
})();
var statearr_68655_68679 = state_68633__$1;
(statearr_68655_68679[(2)] = inst_68618);

(statearr_68655_68679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68634 === (10))){
var state_68633__$1 = state_68633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68633__$1,(13),max);
} else {
if((state_val_68634 === (8))){
var inst_68605 = (state_68633[(2)]);
var inst_68606 = fluree.db.util.async.channel_QMARK_(max);
var state_68633__$1 = (function (){var statearr_68656 = state_68633;
(statearr_68656[(8)] = inst_68605);

return statearr_68656;
})();
if(inst_68606){
var statearr_68657_68680 = state_68633__$1;
(statearr_68657_68680[(1)] = (10));

} else {
var statearr_68658_68681 = state_68633__$1;
(statearr_68658_68681[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11438__auto____0 = (function (){
var statearr_68659 = [null,null,null,null,null,null,null,null,null,null];
(statearr_68659[(0)] = fluree$db$dbfunctions$fns$state_machine__11438__auto__);

(statearr_68659[(1)] = (1));

return statearr_68659;
});
var fluree$db$dbfunctions$fns$state_machine__11438__auto____1 = (function (state_68633){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_68633);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e68660){var ex__11441__auto__ = e68660;
var statearr_68661_68682 = state_68633;
(statearr_68661_68682[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_68633[(4)]))){
var statearr_68662_68683 = state_68633;
(statearr_68662_68683[(1)] = cljs.core.first((state_68633[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68684 = state_68633;
state_68633 = G__68684;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11438__auto__ = function(state_68633){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11438__auto____1.call(this,state_68633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_68663 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_68663[(6)] = c__11512__auto__);

return statearr_68663;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_68705){
var state_val_68706 = (state_68705[(1)]);
if((state_val_68706 === (1))){
var state_68705__$1 = state_68705;
var statearr_68707_68722 = state_68705__$1;
(statearr_68707_68722[(2)] = null);

(statearr_68707_68722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68706 === (2))){
var _ = (function (){var statearr_68708 = state_68705;
(statearr_68708[(4)] = cljs.core.cons((5),(state_68705[(4)])));

return statearr_68708;
})();
var inst_68691 = fluree.db.util.core.random_uuid();
var inst_68692 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68691);
var inst_68693 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68694 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68695 = cljs.core.PersistentVector.EMPTY;
var inst_68696 = ["uuid",inst_68695,inst_68692];
var inst_68697 = cljs.core.PersistentHashMap.fromArrays(inst_68694,inst_68696);
var inst_68698 = [inst_68697,(10)];
var inst_68699 = (new cljs.core.PersistentVector(null,2,(5),inst_68693,inst_68698,null));
var inst_68700 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68699);
var ___$1 = (function (){var statearr_68709 = state_68705;
(statearr_68709[(4)] = cljs.core.rest((state_68705[(4)])));

return statearr_68709;
})();
var state_68705__$1 = (function (){var statearr_68710 = state_68705;
(statearr_68710[(7)] = inst_68700);

return statearr_68710;
})();
var statearr_68711_68723 = state_68705__$1;
(statearr_68711_68723[(2)] = inst_68692);

(statearr_68711_68723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68706 === (3))){
var inst_68703 = (state_68705[(2)]);
var state_68705__$1 = state_68705;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68705__$1,inst_68703);
} else {
if((state_val_68706 === (4))){
var inst_68685 = (state_68705[(2)]);
var state_68705__$1 = state_68705;
var statearr_68713_68724 = state_68705__$1;
(statearr_68713_68724[(2)] = inst_68685);

(statearr_68713_68724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68706 === (5))){
var _ = (function (){var statearr_68714 = state_68705;
(statearr_68714[(4)] = cljs.core.rest((state_68705[(4)])));

return statearr_68714;
})();
var state_68705__$1 = state_68705;
var ex68712 = (state_68705__$1[(2)]);
var statearr_68715_68725 = state_68705__$1;
(statearr_68715_68725[(5)] = ex68712);


if((ex68712 instanceof Error)){
var statearr_68716_68726 = state_68705__$1;
(statearr_68716_68726[(1)] = (4));

(statearr_68716_68726[(5)] = null);

} else {
throw ex68712;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__11438__auto____0 = (function (){
var statearr_68717 = [null,null,null,null,null,null,null,null];
(statearr_68717[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__11438__auto__);

(statearr_68717[(1)] = (1));

return statearr_68717;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__11438__auto____1 = (function (state_68705){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_68705);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e68718){var ex__11441__auto__ = e68718;
var statearr_68719_68727 = state_68705;
(statearr_68719_68727[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_68705[(4)]))){
var statearr_68720_68728 = state_68705;
(statearr_68720_68728[(1)] = cljs.core.first((state_68705[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68729 = state_68705;
state_68705 = G__68729;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__11438__auto__ = function(state_68705){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__11438__auto____1.call(this,state_68705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_68721 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_68721[(6)] = c__11512__auto__);

return statearr_68721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_68759){
var state_val_68760 = (state_68759[(1)]);
if((state_val_68760 === (7))){
var state_68759__$1 = state_68759;
var statearr_68761_68780 = state_68759__$1;
(statearr_68761_68780[(2)] = num);

(statearr_68761_68780[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68760 === (1))){
var state_68759__$1 = state_68759;
var statearr_68762_68781 = state_68759__$1;
(statearr_68762_68781[(2)] = null);

(statearr_68762_68781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68760 === (4))){
var inst_68730 = (state_68759[(2)]);
var state_68759__$1 = state_68759;
var statearr_68763_68782 = state_68759__$1;
(statearr_68763_68782[(2)] = inst_68730);

(statearr_68763_68782[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68760 === (6))){
var state_68759__$1 = state_68759;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68759__$1,(9),num);
} else {
if((state_val_68760 === (3))){
var inst_68757 = (state_68759[(2)]);
var state_68759__$1 = state_68759;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68759__$1,inst_68757);
} else {
if((state_val_68760 === (2))){
var _ = (function (){var statearr_68765 = state_68759;
(statearr_68765[(4)] = cljs.core.cons((5),(state_68759[(4)])));

return statearr_68765;
})();
var inst_68736 = fluree.db.util.async.channel_QMARK_(num);
var state_68759__$1 = state_68759;
if(inst_68736){
var statearr_68766_68783 = state_68759__$1;
(statearr_68766_68783[(1)] = (6));

} else {
var statearr_68767_68784 = state_68759__$1;
(statearr_68767_68784[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68760 === (9))){
var inst_68739 = (state_68759[(2)]);
var inst_68740 = fluree.db.util.async.throw_err(inst_68739);
var state_68759__$1 = state_68759;
var statearr_68768_68785 = state_68759__$1;
(statearr_68768_68785[(2)] = inst_68740);

(statearr_68768_68785[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68760 === (5))){
var _ = (function (){var statearr_68769 = state_68759;
(statearr_68769[(4)] = cljs.core.rest((state_68759[(4)])));

return statearr_68769;
})();
var state_68759__$1 = state_68759;
var ex68764 = (state_68759__$1[(2)]);
var statearr_68770_68786 = state_68759__$1;
(statearr_68770_68786[(5)] = ex68764);


if((ex68764 instanceof Error)){
var statearr_68771_68787 = state_68759__$1;
(statearr_68771_68787[(1)] = (4));

(statearr_68771_68787[(5)] = null);

} else {
throw ex68764;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68760 === (8))){
var inst_68743 = (state_68759[(2)]);
var inst_68744 = fluree.db.dbfunctions.internal.ceil(inst_68743);
var inst_68745 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68746 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68748 = [fluree.db.dbfunctions.fns.ceil];
var inst_68749 = (new cljs.core.PersistentVector(null,1,(5),inst_68747,inst_68748,null));
var inst_68750 = ["",inst_68749,inst_68744];
var inst_68751 = cljs.core.PersistentHashMap.fromArrays(inst_68746,inst_68750);
var inst_68752 = [inst_68751,(10)];
var inst_68753 = (new cljs.core.PersistentVector(null,2,(5),inst_68745,inst_68752,null));
var inst_68754 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68753);
var _ = (function (){var statearr_68772 = state_68759;
(statearr_68772[(4)] = cljs.core.rest((state_68759[(4)])));

return statearr_68772;
})();
var state_68759__$1 = (function (){var statearr_68773 = state_68759;
(statearr_68773[(7)] = inst_68754);

return statearr_68773;
})();
var statearr_68774_68788 = state_68759__$1;
(statearr_68774_68788[(2)] = inst_68744);

(statearr_68774_68788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__11438__auto____0 = (function (){
var statearr_68775 = [null,null,null,null,null,null,null,null];
(statearr_68775[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__11438__auto__);

(statearr_68775[(1)] = (1));

return statearr_68775;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__11438__auto____1 = (function (state_68759){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_68759);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e68776){var ex__11441__auto__ = e68776;
var statearr_68777_68789 = state_68759;
(statearr_68777_68789[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_68759[(4)]))){
var statearr_68778_68790 = state_68759;
(statearr_68778_68790[(1)] = cljs.core.first((state_68759[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68791 = state_68759;
state_68759 = G__68791;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__11438__auto__ = function(state_68759){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__11438__auto____1.call(this,state_68759);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_68779 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_68779[(6)] = c__11512__auto__);

return statearr_68779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_68821){
var state_val_68822 = (state_68821[(1)]);
if((state_val_68822 === (7))){
var state_68821__$1 = state_68821;
var statearr_68823_68842 = state_68821__$1;
(statearr_68823_68842[(2)] = num);

(statearr_68823_68842[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68822 === (1))){
var state_68821__$1 = state_68821;
var statearr_68824_68843 = state_68821__$1;
(statearr_68824_68843[(2)] = null);

(statearr_68824_68843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68822 === (4))){
var inst_68792 = (state_68821[(2)]);
var state_68821__$1 = state_68821;
var statearr_68825_68844 = state_68821__$1;
(statearr_68825_68844[(2)] = inst_68792);

(statearr_68825_68844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68822 === (6))){
var state_68821__$1 = state_68821;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68821__$1,(9),num);
} else {
if((state_val_68822 === (3))){
var inst_68819 = (state_68821[(2)]);
var state_68821__$1 = state_68821;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68821__$1,inst_68819);
} else {
if((state_val_68822 === (2))){
var _ = (function (){var statearr_68827 = state_68821;
(statearr_68827[(4)] = cljs.core.cons((5),(state_68821[(4)])));

return statearr_68827;
})();
var inst_68798 = fluree.db.util.async.channel_QMARK_(num);
var state_68821__$1 = state_68821;
if(inst_68798){
var statearr_68828_68845 = state_68821__$1;
(statearr_68828_68845[(1)] = (6));

} else {
var statearr_68829_68846 = state_68821__$1;
(statearr_68829_68846[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68822 === (9))){
var inst_68801 = (state_68821[(2)]);
var inst_68802 = fluree.db.util.async.throw_err(inst_68801);
var state_68821__$1 = state_68821;
var statearr_68830_68847 = state_68821__$1;
(statearr_68830_68847[(2)] = inst_68802);

(statearr_68830_68847[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68822 === (5))){
var _ = (function (){var statearr_68831 = state_68821;
(statearr_68831[(4)] = cljs.core.rest((state_68821[(4)])));

return statearr_68831;
})();
var state_68821__$1 = state_68821;
var ex68826 = (state_68821__$1[(2)]);
var statearr_68832_68848 = state_68821__$1;
(statearr_68832_68848[(5)] = ex68826);


if((ex68826 instanceof Error)){
var statearr_68833_68849 = state_68821__$1;
(statearr_68833_68849[(1)] = (4));

(statearr_68833_68849[(5)] = null);

} else {
throw ex68826;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68822 === (8))){
var inst_68805 = (state_68821[(2)]);
var inst_68806 = fluree.db.dbfunctions.internal.floor(inst_68805);
var inst_68807 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68808 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68810 = [fluree.db.dbfunctions.fns.floor];
var inst_68811 = (new cljs.core.PersistentVector(null,1,(5),inst_68809,inst_68810,null));
var inst_68812 = ["",inst_68811,inst_68806];
var inst_68813 = cljs.core.PersistentHashMap.fromArrays(inst_68808,inst_68812);
var inst_68814 = [inst_68813,(10)];
var inst_68815 = (new cljs.core.PersistentVector(null,2,(5),inst_68807,inst_68814,null));
var inst_68816 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68815);
var _ = (function (){var statearr_68834 = state_68821;
(statearr_68834[(4)] = cljs.core.rest((state_68821[(4)])));

return statearr_68834;
})();
var state_68821__$1 = (function (){var statearr_68835 = state_68821;
(statearr_68835[(7)] = inst_68816);

return statearr_68835;
})();
var statearr_68836_68850 = state_68821__$1;
(statearr_68836_68850[(2)] = inst_68806);

(statearr_68836_68850[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__11438__auto____0 = (function (){
var statearr_68837 = [null,null,null,null,null,null,null,null];
(statearr_68837[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__11438__auto__);

(statearr_68837[(1)] = (1));

return statearr_68837;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__11438__auto____1 = (function (state_68821){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_68821);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e68838){var ex__11441__auto__ = e68838;
var statearr_68839_68851 = state_68821;
(statearr_68839_68851[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_68821[(4)]))){
var statearr_68840_68852 = state_68821;
(statearr_68840_68852[(1)] = cljs.core.first((state_68821[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68853 = state_68821;
state_68821 = G__68853;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__11438__auto__ = function(state_68821){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__11438__auto____1.call(this,state_68821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_68841 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_68841[(6)] = c__11512__auto__);

return statearr_68841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_68878){
var state_val_68879 = (state_68878[(1)]);
if((state_val_68879 === (1))){
var state_68878__$1 = state_68878;
var statearr_68880_68895 = state_68878__$1;
(statearr_68880_68895[(2)] = null);

(statearr_68880_68895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68879 === (2))){
var _ = (function (){var statearr_68881 = state_68878;
(statearr_68881[(4)] = cljs.core.cons((5),(state_68878[(4)])));

return statearr_68881;
})();
var inst_68860 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_68878__$1 = state_68878;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68878__$1,(6),inst_68860);
} else {
if((state_val_68879 === (3))){
var inst_68876 = (state_68878[(2)]);
var state_68878__$1 = state_68878;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68878__$1,inst_68876);
} else {
if((state_val_68879 === (4))){
var inst_68854 = (state_68878[(2)]);
var state_68878__$1 = state_68878;
var statearr_68883_68896 = state_68878__$1;
(statearr_68883_68896[(2)] = inst_68854);

(statearr_68883_68896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68879 === (5))){
var _ = (function (){var statearr_68884 = state_68878;
(statearr_68884[(4)] = cljs.core.rest((state_68878[(4)])));

return statearr_68884;
})();
var state_68878__$1 = state_68878;
var ex68882 = (state_68878__$1[(2)]);
var statearr_68885_68897 = state_68878__$1;
(statearr_68885_68897[(5)] = ex68882);


if((ex68882 instanceof Error)){
var statearr_68886_68898 = state_68878__$1;
(statearr_68886_68898[(1)] = (4));

(statearr_68886_68898[(5)] = null);

} else {
throw ex68882;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68879 === (6))){
var inst_68862 = (state_68878[(2)]);
var inst_68863 = fluree.db.util.async.throw_err(inst_68862);
var inst_68864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68865 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68867 = [compare_val,new_val];
var inst_68868 = (new cljs.core.PersistentVector(null,2,(5),inst_68866,inst_68867,null));
var inst_68869 = ["",inst_68868,inst_68863];
var inst_68870 = cljs.core.PersistentHashMap.fromArrays(inst_68865,inst_68869);
var inst_68871 = [inst_68870,(10)];
var inst_68872 = (new cljs.core.PersistentVector(null,2,(5),inst_68864,inst_68871,null));
var inst_68873 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68872);
var _ = (function (){var statearr_68887 = state_68878;
(statearr_68887[(4)] = cljs.core.rest((state_68878[(4)])));

return statearr_68887;
})();
var state_68878__$1 = (function (){var statearr_68888 = state_68878;
(statearr_68888[(7)] = inst_68873);

return statearr_68888;
})();
var statearr_68889_68899 = state_68878__$1;
(statearr_68889_68899[(2)] = inst_68863);

(statearr_68889_68899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__11438__auto____0 = (function (){
var statearr_68890 = [null,null,null,null,null,null,null,null];
(statearr_68890[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__11438__auto__);

(statearr_68890[(1)] = (1));

return statearr_68890;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__11438__auto____1 = (function (state_68878){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_68878);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e68891){var ex__11441__auto__ = e68891;
var statearr_68892_68900 = state_68878;
(statearr_68892_68900[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_68878[(4)]))){
var statearr_68893_68901 = state_68878;
(statearr_68893_68901[(1)] = cljs.core.first((state_68878[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68902 = state_68878;
state_68878 = G__68902;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__11438__auto__ = function(state_68878){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__11438__auto____1.call(this,state_68878);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_68894 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_68894[(6)] = c__11512__auto__);

return statearr_68894;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
