// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40708 = arguments.length;
var i__5769__auto___40709 = (0);
while(true){
if((i__5769__auto___40709 < len__5768__auto___40708)){
args__5774__auto__.push((arguments[i__5769__auto___40709]));

var G__40710 = (i__5769__auto___40709 + (1));
i__5769__auto___40709 = G__40710;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((2) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq40705){
var G__40706 = cljs.core.first(seq40705);
var seq40705__$1 = cljs.core.next(seq40705);
var G__40707 = cljs.core.first(seq40705__$1);
var seq40705__$2 = cljs.core.next(seq40705__$1);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__40706,G__40707,seq40705__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e40711){var e = e40711;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e40712){var e = e40712;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e40713){var e = e40713;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e40714){var e = e40714;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e40715){var e = e40715;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40718 = arguments.length;
var i__5769__auto___40719 = (0);
while(true){
if((i__5769__auto___40719 < len__5768__auto___40718)){
args__5774__auto__.push((arguments[i__5769__auto___40719]));

var G__40720 = (i__5769__auto___40719 + (1));
i__5769__auto___40719 = G__40720;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e40717){var e = e40717;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq40716){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40716));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40723 = arguments.length;
var i__5769__auto___40724 = (0);
while(true){
if((i__5769__auto___40724 < len__5768__auto___40723)){
args__5774__auto__.push((arguments[i__5769__auto___40724]));

var G__40725 = (i__5769__auto___40724 + (1));
i__5769__auto___40724 = G__40725;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e40722){var e = e40722;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq40721){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40721));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e40726){var e = e40726;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40729 = arguments.length;
var i__5769__auto___40730 = (0);
while(true){
if((i__5769__auto___40730 < len__5768__auto___40729)){
args__5774__auto__.push((arguments[i__5769__auto___40730]));

var G__40731 = (i__5769__auto___40730 + (1));
i__5769__auto___40730 = G__40731;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e40728){var e = e40728;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq40727){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40727));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40734 = arguments.length;
var i__5769__auto___40735 = (0);
while(true){
if((i__5769__auto___40735 < len__5768__auto___40734)){
args__5774__auto__.push((arguments[i__5769__auto___40735]));

var G__40736 = (i__5769__auto___40735 + (1));
i__5769__auto___40735 = G__40736;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e40733){var e = e40733;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq40732){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40732));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e40737){var e = e40737;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e40738){var e = e40738;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40741 = arguments.length;
var i__5769__auto___40742 = (0);
while(true){
if((i__5769__auto___40742 < len__5768__auto___40741)){
args__5774__auto__.push((arguments[i__5769__auto___40742]));

var G__40743 = (i__5769__auto___40742 + (1));
i__5769__auto___40742 = G__40743;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e40740){var e = e40740;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq40739){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40739));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40746 = arguments.length;
var i__5769__auto___40747 = (0);
while(true){
if((i__5769__auto___40747 < len__5768__auto___40746)){
args__5774__auto__.push((arguments[i__5769__auto___40747]));

var G__40748 = (i__5769__auto___40747 + (1));
i__5769__auto___40747 = G__40748;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e40745){var e = e40745;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq40744){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40744));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40751 = arguments.length;
var i__5769__auto___40752 = (0);
while(true){
if((i__5769__auto___40752 < len__5768__auto___40751)){
args__5774__auto__.push((arguments[i__5769__auto___40752]));

var G__40753 = (i__5769__auto___40752 + (1));
i__5769__auto___40752 = G__40753;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e40750){var e = e40750;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq40749){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40749));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40756 = arguments.length;
var i__5769__auto___40757 = (0);
while(true){
if((i__5769__auto___40757 < len__5768__auto___40756)){
args__5774__auto__.push((arguments[i__5769__auto___40757]));

var G__40758 = (i__5769__auto___40757 + (1));
i__5769__auto___40757 = G__40758;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e40755){var e = e40755;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq40754){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40754));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40761 = arguments.length;
var i__5769__auto___40762 = (0);
while(true){
if((i__5769__auto___40762 < len__5768__auto___40761)){
args__5774__auto__.push((arguments[i__5769__auto___40762]));

var G__40763 = (i__5769__auto___40762 + (1));
i__5769__auto___40762 = G__40763;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e40760){var e = e40760;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq40759){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40759));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40766 = arguments.length;
var i__5769__auto___40767 = (0);
while(true){
if((i__5769__auto___40767 < len__5768__auto___40766)){
args__5774__auto__.push((arguments[i__5769__auto___40767]));

var G__40768 = (i__5769__auto___40767 + (1));
i__5769__auto___40767 = G__40768;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e40765){var e = e40765;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq40764){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40764));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40771 = arguments.length;
var i__5769__auto___40772 = (0);
while(true){
if((i__5769__auto___40772 < len__5768__auto___40771)){
args__5774__auto__.push((arguments[i__5769__auto___40772]));

var G__40773 = (i__5769__auto___40772 + (1));
i__5769__auto___40772 = G__40773;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e40770){var e = e40770;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq40769){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40769));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__40775 = arguments.length;
switch (G__40775) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_40803){
var state_val_40804 = (state_40803[(1)]);
if((state_val_40804 === (7))){
var inst_40788 = (state_40803[(7)]);
var inst_40791 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_40788,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_40803__$1 = state_40803;
var statearr_40805_40891 = state_40803__$1;
(statearr_40805_40891[(2)] = inst_40791);

(statearr_40805_40891[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40804 === (1))){
var state_40803__$1 = state_40803;
var statearr_40806_40892 = state_40803__$1;
(statearr_40806_40892[(2)] = null);

(statearr_40806_40892[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40804 === (4))){
var inst_40776 = (state_40803[(2)]);
var state_40803__$1 = state_40803;
var statearr_40807_40893 = state_40803__$1;
(statearr_40807_40893[(2)] = inst_40776);

(statearr_40807_40893[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40804 === (6))){
var inst_40788 = (state_40803[(7)]);
var inst_40788__$1 = (state_40803[(2)]);
var inst_40789 = fluree.db.util.core.exception_QMARK_(inst_40788__$1);
var state_40803__$1 = (function (){var statearr_40808 = state_40803;
(statearr_40808[(7)] = inst_40788__$1);

return statearr_40808;
})();
if(inst_40789){
var statearr_40809_40894 = state_40803__$1;
(statearr_40809_40894[(1)] = (7));

} else {
var statearr_40810_40895 = state_40803__$1;
(statearr_40810_40895[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40804 === (3))){
var inst_40801 = (state_40803[(2)]);
var state_40803__$1 = state_40803;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40803__$1,inst_40801);
} else {
if((state_val_40804 === (2))){
var inst_40782 = (state_40803[(8)]);
var _ = (function (){var statearr_40812 = state_40803;
(statearr_40812[(4)] = cljs.core.cons((5),(state_40803[(4)])));

return statearr_40812;
})();
var inst_40782__$1 = cljs.core.volatile_BANG_((0));
var inst_40783 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_40784 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_40783,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_40782__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_40785 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_40784);
var inst_40786 = fluree.db.query.fql.query(db,inst_40785);
var state_40803__$1 = (function (){var statearr_40813 = state_40803;
(statearr_40813[(8)] = inst_40782__$1);

return statearr_40813;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40803__$1,(6),inst_40786);
} else {
if((state_val_40804 === (9))){
var inst_40798 = (state_40803[(2)]);
var _ = (function (){var statearr_40814 = state_40803;
(statearr_40814[(4)] = cljs.core.rest((state_40803[(4)])));

return statearr_40814;
})();
var state_40803__$1 = state_40803;
var statearr_40815_40896 = state_40803__$1;
(statearr_40815_40896[(2)] = inst_40798);

(statearr_40815_40896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40804 === (5))){
var _ = (function (){var statearr_40816 = state_40803;
(statearr_40816[(4)] = cljs.core.rest((state_40803[(4)])));

return statearr_40816;
})();
var state_40803__$1 = state_40803;
var ex40811 = (state_40803__$1[(2)]);
var statearr_40817_40897 = state_40803__$1;
(statearr_40817_40897[(5)] = ex40811);


if((ex40811 instanceof Error)){
var statearr_40818_40898 = state_40803__$1;
(statearr_40818_40898[(1)] = (4));

(statearr_40818_40898[(5)] = null);

} else {
throw ex40811;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40804 === (8))){
var inst_40788 = (state_40803[(7)]);
var inst_40782 = (state_40803[(8)]);
var inst_40793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40794 = cljs.core.deref(inst_40782);
var inst_40795 = [inst_40788,inst_40794];
var inst_40796 = (new cljs.core.PersistentVector(null,2,(5),inst_40793,inst_40795,null));
var state_40803__$1 = state_40803;
var statearr_40819_40899 = state_40803__$1;
(statearr_40819_40899[(2)] = inst_40796);

(statearr_40819_40899[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__11438__auto____0 = (function (){
var statearr_40820 = [null,null,null,null,null,null,null,null,null];
(statearr_40820[(0)] = fluree$db$dbfunctions$internal$state_machine__11438__auto__);

(statearr_40820[(1)] = (1));

return statearr_40820;
});
var fluree$db$dbfunctions$internal$state_machine__11438__auto____1 = (function (state_40803){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_40803);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e40821){var ex__11441__auto__ = e40821;
var statearr_40822_40900 = state_40803;
(statearr_40822_40900[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_40803[(4)]))){
var statearr_40823_40901 = state_40803;
(statearr_40823_40901[(1)] = cljs.core.first((state_40803[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40902 = state_40803;
state_40803 = G__40902;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__11438__auto__ = function(state_40803){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__11438__auto____1.call(this,state_40803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__11438__auto____0;
fluree$db$dbfunctions$internal$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__11438__auto____1;
return fluree$db$dbfunctions$internal$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_40824 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_40824[(6)] = c__11512__auto__);

return statearr_40824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_40869){
var state_val_40870 = (state_40869[(1)]);
if((state_val_40870 === (7))){
var inst_40855 = (state_40869[(2)]);
var inst_40856 = fluree.db.query.fql.query(db,inst_40855);
var state_40869__$1 = state_40869;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40869__$1,(8),inst_40856);
} else {
if((state_val_40870 === (1))){
var inst_40825 = typeof select === 'string';
var state_40869__$1 = state_40869;
if(cljs.core.truth_(inst_40825)){
var statearr_40871_40903 = state_40869__$1;
(statearr_40871_40903[(1)] = (2));

} else {
var statearr_40872_40904 = state_40869__$1;
(statearr_40872_40904[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40870 === (4))){
var inst_40838 = (state_40869[(7)]);
var inst_40831 = (state_40869[(8)]);
var inst_40830 = (state_40869[(2)]);
var inst_40831__$1 = cljs.core.volatile_BANG_((0));
var inst_40832 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_40833 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_40834 = [inst_40831__$1,(100000)];
var inst_40835 = cljs.core.PersistentHashMap.fromArrays(inst_40833,inst_40834);
var inst_40836 = [inst_40830,from,where,block,limit,inst_40835];
var inst_40837 = cljs.core.PersistentHashMap.fromArrays(inst_40832,inst_40836);
var inst_40838__$1 = fluree.db.util.core.without_nils(inst_40837);
var inst_40839 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_40838__$1);
var inst_40840 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_40838__$1);
var inst_40841 = cljs.core.first(inst_40840);
var inst_40842 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40841], 0));
var inst_40843 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_40842);
var inst_40844 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_40838__$1);
var inst_40845 = cljs.core.last(inst_40844);
var inst_40846 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40845], 0));
var inst_40847 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_40846);
var inst_40848 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40839,inst_40843,inst_40847], 0));
var state_40869__$1 = (function (){var statearr_40873 = state_40869;
(statearr_40873[(7)] = inst_40838__$1);

(statearr_40873[(8)] = inst_40831__$1);

return statearr_40873;
})();
if(cljs.core.truth_(inst_40848)){
var statearr_40874_40905 = state_40869__$1;
(statearr_40874_40905[(1)] = (5));

} else {
var statearr_40875_40906 = state_40869__$1;
(statearr_40875_40906[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40870 === (6))){
var inst_40838 = (state_40869[(7)]);
var state_40869__$1 = state_40869;
var statearr_40876_40907 = state_40869__$1;
(statearr_40876_40907[(2)] = inst_40838);

(statearr_40876_40907[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40870 === (3))){
var state_40869__$1 = state_40869;
var statearr_40877_40908 = state_40869__$1;
(statearr_40877_40908[(2)] = select);

(statearr_40877_40908[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40870 === (2))){
var inst_40827 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_40869__$1 = state_40869;
var statearr_40878_40909 = state_40869__$1;
(statearr_40878_40909[(2)] = inst_40827);

(statearr_40878_40909[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40870 === (11))){
var inst_40867 = (state_40869[(2)]);
var state_40869__$1 = state_40869;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40869__$1,inst_40867);
} else {
if((state_val_40870 === (9))){
var inst_40858 = (state_40869[(9)]);
var state_40869__$1 = state_40869;
var statearr_40879_40910 = state_40869__$1;
(statearr_40879_40910[(2)] = inst_40858);

(statearr_40879_40910[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40870 === (5))){
var inst_40838 = (state_40869[(7)]);
var inst_40850 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_40838);
var inst_40851 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_40850);
var inst_40852 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40838,new cljs.core.Keyword(null,"where","where",-2044795965),inst_40851);
var state_40869__$1 = state_40869;
var statearr_40880_40911 = state_40869__$1;
(statearr_40880_40911[(2)] = inst_40852);

(statearr_40880_40911[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40870 === (10))){
var inst_40858 = (state_40869[(9)]);
var inst_40831 = (state_40869[(8)]);
var inst_40862 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40863 = cljs.core.deref(inst_40831);
var inst_40864 = [inst_40858,inst_40863];
var inst_40865 = (new cljs.core.PersistentVector(null,2,(5),inst_40862,inst_40864,null));
var state_40869__$1 = state_40869;
var statearr_40881_40912 = state_40869__$1;
(statearr_40881_40912[(2)] = inst_40865);

(statearr_40881_40912[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40870 === (8))){
var inst_40858 = (state_40869[(9)]);
var inst_40858__$1 = (state_40869[(2)]);
var inst_40859 = fluree.db.util.core.exception_QMARK_(inst_40858__$1);
var state_40869__$1 = (function (){var statearr_40882 = state_40869;
(statearr_40882[(9)] = inst_40858__$1);

return statearr_40882;
})();
if(inst_40859){
var statearr_40883_40913 = state_40869__$1;
(statearr_40883_40913[(1)] = (9));

} else {
var statearr_40884_40914 = state_40869__$1;
(statearr_40884_40914[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__11438__auto____0 = (function (){
var statearr_40885 = [null,null,null,null,null,null,null,null,null,null];
(statearr_40885[(0)] = fluree$db$dbfunctions$internal$state_machine__11438__auto__);

(statearr_40885[(1)] = (1));

return statearr_40885;
});
var fluree$db$dbfunctions$internal$state_machine__11438__auto____1 = (function (state_40869){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_40869);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e40886){var ex__11441__auto__ = e40886;
var statearr_40887_40915 = state_40869;
(statearr_40887_40915[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_40869[(4)]))){
var statearr_40888_40916 = state_40869;
(statearr_40888_40916[(1)] = cljs.core.first((state_40869[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40917 = state_40869;
state_40869 = G__40917;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__11438__auto__ = function(state_40869){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__11438__auto____1.call(this,state_40869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__11438__auto____0;
fluree$db$dbfunctions$internal$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__11438__auto____1;
return fluree$db$dbfunctions$internal$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_40889 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_40889[(6)] = c__11512__auto__);

return statearr_40889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__40921 = path;
var vec__40922 = G__40921;
var seq__40923 = cljs.core.seq(vec__40922);
var first__40924 = cljs.core.first(seq__40923);
var seq__40923__$1 = cljs.core.next(seq__40923);
var var$ = first__40924;
var r = seq__40923__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__40921__$1 = G__40921;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__40928 = G__40921__$1;
var seq__40929 = cljs.core.seq(vec__40928);
var first__40930 = cljs.core.first(seq__40929);
var seq__40929__$1 = cljs.core.next(seq__40929);
var var$__$1 = first__40930;
var r__$1 = seq__40929__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__40931 = r__$1;
var G__40932 = n__$2;
var G__40933 = next_clauses;
G__40921__$1 = G__40931;
n__$1 = G__40932;
where_clauses__$1 = G__40933;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__40934 = r__$1;
var G__40935 = next_n;
var G__40936 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__40921__$1 = G__40934;
n__$1 = G__40935;
where_clauses__$1 = G__40936;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_40973){
var state_val_40974 = (state_40973[(1)]);
if((state_val_40974 === (7))){
var inst_40946 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40947 = [path];
var inst_40948 = (new cljs.core.PersistentVector(null,1,(5),inst_40946,inst_40947,null));
var state_40973__$1 = state_40973;
var statearr_40975_41003 = state_40973__$1;
(statearr_40975_41003[(2)] = inst_40948);

(statearr_40975_41003[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40974 === (1))){
var state_40973__$1 = state_40973;
var statearr_40976_41004 = state_40973__$1;
(statearr_40976_41004[(2)] = null);

(statearr_40976_41004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40974 === (4))){
var inst_40937 = (state_40973[(2)]);
var state_40973__$1 = state_40973;
var statearr_40977_41005 = state_40973__$1;
(statearr_40977_41005[(2)] = inst_40937);

(statearr_40977_41005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40974 === (13))){
var inst_40964 = (state_40973[(2)]);
var inst_40965 = fluree.db.util.async.throw_err(inst_40964);
var _ = (function (){var statearr_40978 = state_40973;
(statearr_40978[(4)] = cljs.core.rest((state_40973[(4)])));

return statearr_40978;
})();
var state_40973__$1 = state_40973;
var statearr_40979_41006 = state_40973__$1;
(statearr_40979_41006[(2)] = inst_40965);

(statearr_40979_41006[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40974 === (6))){
var state_40973__$1 = state_40973;
var statearr_40981_41007 = state_40973__$1;
(statearr_40981_41007[(2)] = path);

(statearr_40981_41007[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40974 === (3))){
var inst_40971 = (state_40973[(2)]);
var state_40973__$1 = state_40973;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40973__$1,inst_40971);
} else {
if((state_val_40974 === (12))){
var _ = (function (){var statearr_40982 = state_40973;
(statearr_40982[(4)] = cljs.core.rest((state_40973[(4)])));

return statearr_40982;
})();
var state_40973__$1 = state_40973;
var ex40980 = (state_40973__$1[(2)]);
var statearr_40983_41008 = state_40973__$1;
(statearr_40983_41008[(5)] = ex40980);


var statearr_40984_41009 = state_40973__$1;
(statearr_40984_41009[(1)] = (11));

(statearr_40984_41009[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40974 === (2))){
var _ = (function (){var statearr_40985 = state_40973;
(statearr_40985[(4)] = cljs.core.cons((5),(state_40973[(4)])));

return statearr_40985;
})();
var inst_40943 = cljs.core.vector_QMARK_(path);
var state_40973__$1 = state_40973;
if(inst_40943){
var statearr_40986_41010 = state_40973__$1;
(statearr_40986_41010[(1)] = (6));

} else {
var statearr_40987_41011 = state_40973__$1;
(statearr_40987_41011[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40974 === (11))){
var inst_40950 = (state_40973[(7)]);
var inst_40955 = (state_40973[(2)]);
var inst_40956 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_40955,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_40950,endSubject], 0));
var state_40973__$1 = state_40973;
var statearr_40989_41012 = state_40973__$1;
(statearr_40989_41012[(2)] = inst_40956);

(statearr_40989_41012[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40974 === (9))){
var inst_40954 = (state_40973[(8)]);
var _ = (function (){var statearr_40990 = state_40973;
(statearr_40990[(4)] = cljs.core.cons((12),(state_40973[(4)])));

return statearr_40990;
})();
var inst_40962 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_40954);
var state_40973__$1 = state_40973;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40973__$1,(13),inst_40962);
} else {
if((state_val_40974 === (5))){
var _ = (function (){var statearr_40991 = state_40973;
(statearr_40991[(4)] = cljs.core.rest((state_40973[(4)])));

return statearr_40991;
})();
var state_40973__$1 = state_40973;
var ex40988 = (state_40973__$1[(2)]);
var statearr_40992_41013 = state_40973__$1;
(statearr_40992_41013[(5)] = ex40988);


if((ex40988 instanceof Error)){
var statearr_40993_41014 = state_40973__$1;
(statearr_40993_41014[(1)] = (4));

(statearr_40993_41014[(5)] = null);

} else {
throw ex40988;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40974 === (10))){
var inst_40968 = (state_40973[(2)]);
var _ = (function (){var statearr_40994 = state_40973;
(statearr_40994[(4)] = cljs.core.rest((state_40973[(4)])));

return statearr_40994;
})();
var state_40973__$1 = state_40973;
var statearr_40995_41015 = state_40973__$1;
(statearr_40995_41015[(2)] = inst_40968);

(statearr_40995_41015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40974 === (8))){
var inst_40950 = (state_40973[(7)]);
var inst_40950__$1 = (state_40973[(2)]);
var inst_40951 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_40950__$1,endSubject);
var inst_40952 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_40953 = ["?var1",inst_40951];
var inst_40954 = cljs.core.PersistentHashMap.fromArrays(inst_40952,inst_40953);
var state_40973__$1 = (function (){var statearr_40996 = state_40973;
(statearr_40996[(7)] = inst_40950__$1);

(statearr_40996[(8)] = inst_40954);

return statearr_40996;
})();
var statearr_40997_41016 = state_40973__$1;
(statearr_40997_41016[(2)] = null);

(statearr_40997_41016[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11438__auto____0 = (function (){
var statearr_40998 = [null,null,null,null,null,null,null,null,null];
(statearr_40998[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11438__auto__);

(statearr_40998[(1)] = (1));

return statearr_40998;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11438__auto____1 = (function (state_40973){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_40973);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e40999){var ex__11441__auto__ = e40999;
var statearr_41000_41017 = state_40973;
(statearr_41000_41017[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_40973[(4)]))){
var statearr_41001_41018 = state_40973;
(statearr_41001_41018[(1)] = cljs.core.first((state_40973[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41019 = state_40973;
state_40973 = G__41019;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11438__auto__ = function(state_40973){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11438__auto____1.call(this,state_40973);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11438__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_41002 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_41002[(6)] = c__11512__auto__);

return statearr_41002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e41020){var e = e41020;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e41021){var e = e41021;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e41022){var e = e41022;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e41023){var e = e41023;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___41026 = arguments.length;
var i__5769__auto___41027 = (0);
while(true){
if((i__5769__auto___41027 < len__5768__auto___41026)){
args__5774__auto__.push((arguments[i__5769__auto___41027]));

var G__41028 = (i__5769__auto___41027 + (1));
i__5769__auto___41027 = G__41028;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e41025){var e = e41025;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq41024){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41024));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___41031 = arguments.length;
var i__5769__auto___41032 = (0);
while(true){
if((i__5769__auto___41032 < len__5768__auto___41031)){
args__5774__auto__.push((arguments[i__5769__auto___41032]));

var G__41033 = (i__5769__auto___41032 + (1));
i__5769__auto___41032 = G__41033;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e41030){var e = e41030;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq41029){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41029));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___41036 = arguments.length;
var i__5769__auto___41037 = (0);
while(true){
if((i__5769__auto___41037 < len__5768__auto___41036)){
args__5774__auto__.push((arguments[i__5769__auto___41037]));

var G__41038 = (i__5769__auto___41037 + (1));
i__5769__auto___41037 = G__41038;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e41035){var e = e41035;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq41034){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41034));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___41041 = arguments.length;
var i__5769__auto___41042 = (0);
while(true){
if((i__5769__auto___41042 < len__5768__auto___41041)){
args__5774__auto__.push((arguments[i__5769__auto___41042]));

var G__41043 = (i__5769__auto___41042 + (1));
i__5769__auto___41042 = G__41043;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e41040){var e = e41040;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq41039){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41039));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e41044){var e = e41044;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e41045){var e = e41045;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e41046){var e = e41046;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e41047){var e = e41047;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e41048){var e = e41048;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__41054 = path;
var vec__41055 = G__41054;
var seq__41056 = cljs.core.seq(vec__41055);
var first__41057 = cljs.core.first(seq__41056);
var seq__41056__$1 = cljs.core.next(seq__41056);
var pred = first__41057;
var r = seq__41056__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__41054__$1 = G__41054;
var subjects__$1 = subjects;
while(true){
var vec__41061 = G__41054__$1;
var seq__41062 = cljs.core.seq(vec__41061);
var first__41063 = cljs.core.first(seq__41062);
var seq__41062__$1 = cljs.core.next(seq__41062);
var pred__$1 = first__41063;
var r__$1 = seq__41062__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__41054__$1,subjects__$1,vec__41061,seq__41062,first__41063,seq__41062__$1,pred__$1,r__$1,subjects__$2,G__41054,vec__41055,seq__41056,first__41057,seq__41056__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__41054__$1,subjects__$1,vec__41061,seq__41062,first__41063,seq__41062__$1,pred__$1,r__$1,subjects__$2,G__41054,vec__41055,seq__41056,first__41057,seq__41056__$1,pred,r,subjects){
return (function (p1__41049_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__41049_SHARP_,pred__$1);
});})(G__41054__$1,subjects__$1,vec__41061,seq__41062,first__41063,seq__41062__$1,pred__$1,r__$1,subjects__$2,G__41054,vec__41055,seq__41056,first__41057,seq__41056__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__41054__$1,subjects__$1,vec__41061,seq__41062,first__41063,seq__41062__$1,pred__$1,r__$1,subjects__$2,G__41054,vec__41055,seq__41056,first__41057,seq__41056__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__41064 = r__$1;
var G__41065 = next_subjects;
G__41054__$1 = G__41064;
subjects__$1 = G__41065;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e41050){var e = e41050;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e41066){var e = e41066;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e41067){var e = e41067;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5774__auto__ = [];
var len__5768__auto___41070 = arguments.length;
var i__5769__auto___41071 = (0);
while(true){
if((i__5769__auto___41071 < len__5768__auto___41070)){
args__5774__auto__.push((arguments[i__5769__auto___41071]));

var G__41072 = (i__5769__auto___41071 + (1));
i__5769__auto___41071 = G__41072;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e41069){var e = e41069;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq41068){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41068));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e41073){var e = e41073;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___41076 = arguments.length;
var i__5769__auto___41077 = (0);
while(true){
if((i__5769__auto___41077 < len__5768__auto___41076)){
args__5774__auto__.push((arguments[i__5769__auto___41077]));

var G__41078 = (i__5769__auto___41077 + (1));
i__5769__auto___41077 = G__41078;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e41075){var e = e41075;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq41074){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41074));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e41079){var e = e41079;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_41136){
var state_val_41137 = (state_41136[(1)]);
if((state_val_41137 === (7))){
var inst_41082 = (state_41136[(2)]);
var state_41136__$1 = state_41136;
var statearr_41138_41172 = state_41136__$1;
(statearr_41138_41172[(2)] = inst_41082);

(statearr_41138_41172[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41137 === (1))){
var state_41136__$1 = state_41136;
var statearr_41139_41173 = state_41136__$1;
(statearr_41139_41173[(2)] = null);

(statearr_41139_41173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41137 === (4))){
var inst_41081 = (state_41136[(2)]);
var state_41136__$1 = (function (){var statearr_41140 = state_41136;
(statearr_41140[(7)] = inst_41081);

return statearr_41140;
})();
var statearr_41141_41174 = state_41136__$1;
(statearr_41141_41174[(2)] = null);

(statearr_41141_41174[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41137 === (15))){
var inst_41104 = (state_41136[(8)]);
var inst_41119 = (state_41136[(9)]);
var inst_41106 = (state_41136[(10)]);
var inst_41117 = (state_41136[(11)]);
var inst_41116 = (state_41136[(12)]);
var inst_41107 = (state_41136[(13)]);
var inst_41123 = (function (){var db = inst_41104;
var prevT = inst_41106;
var db_SINGLEQUOTE_ = inst_41107;
var prev_vals = inst_41116;
var fuel = inst_41117;
var G__41118 = inst_41119;
return (function (p1__41080_SHARP_){
var f = p1__41080_SHARP_;
return f.o;
});
})();
var inst_41124 = (inst_41123.cljs$core$IFn$_invoke$arity$1 ? inst_41123.cljs$core$IFn$_invoke$arity$1(inst_41119) : inst_41123.call(null,inst_41119));
var state_41136__$1 = state_41136;
var statearr_41142_41175 = state_41136__$1;
(statearr_41142_41175[(2)] = inst_41124);

(statearr_41142_41175[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41137 === (13))){
var inst_41119 = (state_41136[(9)]);
var inst_41116 = (state_41136[(12)]);
var inst_41115 = (state_41136[(2)]);
var inst_41116__$1 = fluree.db.util.async.throw_err(inst_41115);
var inst_41117 = fluree.db.dbfunctions.internal.count(inst_41116__$1);
var inst_41119__$1 = cljs.core.first(inst_41116__$1);
var inst_41120 = (inst_41119__$1 == null);
var state_41136__$1 = (function (){var statearr_41143 = state_41136;
(statearr_41143[(9)] = inst_41119__$1);

(statearr_41143[(11)] = inst_41117);

(statearr_41143[(12)] = inst_41116__$1);

return statearr_41143;
})();
if(cljs.core.truth_(inst_41120)){
var statearr_41144_41176 = state_41136__$1;
(statearr_41144_41176[(1)] = (14));

} else {
var statearr_41145_41177 = state_41136__$1;
(statearr_41145_41177[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41137 === (6))){
var inst_41091 = (state_41136[(2)]);
var state_41136__$1 = state_41136;
var statearr_41146_41178 = state_41136__$1;
(statearr_41146_41178[(2)] = inst_41091);

(statearr_41146_41178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41137 === (3))){
var inst_41134 = (state_41136[(2)]);
var state_41136__$1 = state_41136;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41136__$1,inst_41134);
} else {
if((state_val_41137 === (12))){
var inst_41131 = (state_41136[(2)]);
var _ = (function (){var statearr_41147 = state_41136;
(statearr_41147[(4)] = cljs.core.rest((state_41136[(4)])));

return statearr_41147;
})();
var state_41136__$1 = state_41136;
var statearr_41148_41179 = state_41136__$1;
(statearr_41148_41179[(2)] = inst_41131);

(statearr_41148_41179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41137 === (2))){
var _ = (function (){var statearr_41150 = state_41136;
(statearr_41150[(4)] = cljs.core.cons((9),(state_41136[(4)])));

return statearr_41150;
})();
var inst_41097 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41098 = typeof inst_41097 === 'string';
var state_41136__$1 = state_41136;
if(cljs.core.truth_(inst_41098)){
var statearr_41151_41180 = state_41136__$1;
(statearr_41151_41180[(1)] = (10));

} else {
var statearr_41152_41181 = state_41136__$1;
(statearr_41152_41181[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41137 === (11))){
var inst_41104 = (state_41136[(8)]);
var inst_41106 = (state_41136[(10)]);
var inst_41107 = (state_41136[(13)]);
var inst_41104__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41105 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_41104__$1);
var inst_41106__$1 = fluree.db.dbfunctions.internal.inc(inst_41105);
var inst_41107__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41104__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_41106__$1);
var inst_41108 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41109 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41110 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41111 = [inst_41109,inst_41110];
var inst_41112 = (new cljs.core.PersistentVector(null,2,(5),inst_41108,inst_41111,null));
var inst_41113 = fluree.db.dbproto._search(inst_41107__$1,inst_41112);
var state_41136__$1 = (function (){var statearr_41153 = state_41136;
(statearr_41153[(8)] = inst_41104__$1);

(statearr_41153[(10)] = inst_41106__$1);

(statearr_41153[(13)] = inst_41107__$1);

return statearr_41153;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41136__$1,(13),inst_41113);
} else {
if((state_val_41137 === (9))){
var _ = (function (){var statearr_41154 = state_41136;
(statearr_41154[(4)] = cljs.core.rest((state_41136[(4)])));

return statearr_41154;
})();
var state_41136__$1 = state_41136;
var ex41149 = (state_41136__$1[(2)]);
var statearr_41155_41182 = state_41136__$1;
(statearr_41155_41182[(5)] = ex41149);


var statearr_41156_41183 = state_41136__$1;
(statearr_41156_41183[(1)] = (4));

(statearr_41156_41183[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41137 === (5))){
var inst_41081 = (state_41136[(7)]);
var _ = (function (){var statearr_41157 = state_41136;
(statearr_41157[(4)] = cljs.core.cons((8),(state_41136[(4)])));

return statearr_41157;
})();
var inst_41088 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41081,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_41158 = state_41136;
(statearr_41158[(4)] = cljs.core.rest((state_41136[(4)])));

return statearr_41158;
})();
var state_41136__$1 = state_41136;
var statearr_41159_41184 = state_41136__$1;
(statearr_41159_41184[(2)] = inst_41088);

(statearr_41159_41184[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41137 === (14))){
var state_41136__$1 = state_41136;
var statearr_41160_41185 = state_41136__$1;
(statearr_41160_41185[(2)] = null);

(statearr_41160_41185[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41137 === (16))){
var inst_41117 = (state_41136[(11)]);
var inst_41126 = (state_41136[(2)]);
var inst_41127 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41128 = [inst_41126,inst_41117];
var inst_41129 = (new cljs.core.PersistentVector(null,2,(5),inst_41127,inst_41128,null));
var state_41136__$1 = state_41136;
var statearr_41162_41186 = state_41136__$1;
(statearr_41162_41186[(2)] = inst_41129);

(statearr_41162_41186[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41137 === (10))){
var inst_41100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41101 = [null,(0)];
var inst_41102 = (new cljs.core.PersistentVector(null,2,(5),inst_41100,inst_41101,null));
var state_41136__$1 = state_41136;
var statearr_41163_41187 = state_41136__$1;
(statearr_41163_41187[(2)] = inst_41102);

(statearr_41163_41187[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41137 === (8))){
var _ = (function (){var statearr_41164 = state_41136;
(statearr_41164[(4)] = cljs.core.rest((state_41136[(4)])));

return statearr_41164;
})();
var state_41136__$1 = state_41136;
var ex41161 = (state_41136__$1[(2)]);
var statearr_41165_41188 = state_41136__$1;
(statearr_41165_41188[(5)] = ex41161);


var statearr_41166_41189 = state_41136__$1;
(statearr_41166_41189[(1)] = (7));

(statearr_41166_41189[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11438__auto____0 = (function (){
var statearr_41167 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41167[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11438__auto__);

(statearr_41167[(1)] = (1));

return statearr_41167;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11438__auto____1 = (function (state_41136){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_41136);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e41168){var ex__11441__auto__ = e41168;
var statearr_41169_41190 = state_41136;
(statearr_41169_41190[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_41136[(4)]))){
var statearr_41170_41191 = state_41136;
(statearr_41170_41191[(1)] = cljs.core.first((state_41136[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41192 = state_41136;
state_41136 = G__41192;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11438__auto__ = function(state_41136){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11438__auto____1.call(this,state_41136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_41171 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_41171[(6)] = c__11512__auto__);

return statearr_41171;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_41244){
var state_val_41245 = (state_41244[(1)]);
if((state_val_41245 === (7))){
var inst_41194 = (state_41244[(2)]);
var state_41244__$1 = state_41244;
var statearr_41246_41275 = state_41244__$1;
(statearr_41246_41275[(2)] = inst_41194);

(statearr_41246_41275[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41245 === (1))){
var state_41244__$1 = state_41244;
var statearr_41247_41276 = state_41244__$1;
(statearr_41247_41276[(2)] = null);

(statearr_41247_41276[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41245 === (4))){
var inst_41193 = (state_41244[(2)]);
var state_41244__$1 = (function (){var statearr_41248 = state_41244;
(statearr_41248[(7)] = inst_41193);

return statearr_41248;
})();
var statearr_41249_41277 = state_41244__$1;
(statearr_41249_41277[(2)] = null);

(statearr_41249_41277[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41245 === (13))){
var inst_41239 = (state_41244[(2)]);
var _ = (function (){var statearr_41250 = state_41244;
(statearr_41250[(4)] = cljs.core.rest((state_41244[(4)])));

return statearr_41250;
})();
var state_41244__$1 = state_41244;
var statearr_41251_41278 = state_41244__$1;
(statearr_41251_41278[(2)] = inst_41239);

(statearr_41251_41278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41245 === (6))){
var inst_41203 = (state_41244[(2)]);
var state_41244__$1 = state_41244;
var statearr_41252_41279 = state_41244__$1;
(statearr_41252_41279[(2)] = inst_41203);

(statearr_41252_41279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41245 === (3))){
var inst_41242 = (state_41244[(2)]);
var state_41244__$1 = state_41244;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41244__$1,inst_41242);
} else {
if((state_val_41245 === (12))){
var inst_41226 = (state_41244[(8)]);
var inst_41235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41236 = [null,inst_41226];
var inst_41237 = (new cljs.core.PersistentVector(null,2,(5),inst_41235,inst_41236,null));
var state_41244__$1 = state_41244;
var statearr_41253_41280 = state_41244__$1;
(statearr_41253_41280[(2)] = inst_41237);

(statearr_41253_41280[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41245 === (2))){
var _ = (function (){var statearr_41255 = state_41244;
(statearr_41255[(4)] = cljs.core.cons((9),(state_41244[(4)])));

return statearr_41255;
})();
var inst_41212 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_41213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41215 = [null,pred_name,"?o"];
var inst_41216 = (new cljs.core.PersistentVector(null,3,(5),inst_41214,inst_41215,null));
var inst_41217 = [inst_41216];
var inst_41218 = (new cljs.core.PersistentVector(null,1,(5),inst_41213,inst_41217,null));
var inst_41219 = ["?o",inst_41218,opts];
var inst_41220 = cljs.core.PersistentHashMap.fromArrays(inst_41212,inst_41219);
var inst_41221 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_41220);
var state_41244__$1 = state_41244;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41244__$1,(10),inst_41221);
} else {
if((state_val_41245 === (11))){
var inst_41225 = (state_41244[(9)]);
var inst_41226 = (state_41244[(8)]);
var inst_41230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41231 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_41225);
var inst_41232 = [inst_41231,inst_41226];
var inst_41233 = (new cljs.core.PersistentVector(null,2,(5),inst_41230,inst_41232,null));
var state_41244__$1 = state_41244;
var statearr_41256_41281 = state_41244__$1;
(statearr_41256_41281[(2)] = inst_41233);

(statearr_41256_41281[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41245 === (9))){
var _ = (function (){var statearr_41257 = state_41244;
(statearr_41257[(4)] = cljs.core.rest((state_41244[(4)])));

return statearr_41257;
})();
var state_41244__$1 = state_41244;
var ex41254 = (state_41244__$1[(2)]);
var statearr_41258_41282 = state_41244__$1;
(statearr_41258_41282[(5)] = ex41254);


var statearr_41259_41283 = state_41244__$1;
(statearr_41259_41283[(1)] = (4));

(statearr_41259_41283[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41245 === (5))){
var inst_41193 = (state_41244[(7)]);
var _ = (function (){var statearr_41261 = state_41244;
(statearr_41261[(4)] = cljs.core.cons((8),(state_41244[(4)])));

return statearr_41261;
})();
var inst_41200 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41193,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_41262 = state_41244;
(statearr_41262[(4)] = cljs.core.rest((state_41244[(4)])));

return statearr_41262;
})();
var state_41244__$1 = state_41244;
var statearr_41263_41284 = state_41244__$1;
(statearr_41263_41284[(2)] = inst_41200);

(statearr_41263_41284[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41245 === (10))){
var inst_41225 = (state_41244[(9)]);
var inst_41223 = (state_41244[(2)]);
var inst_41224 = fluree.db.util.async.throw_err(inst_41223);
var inst_41225__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41224,(0),null);
var inst_41226 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41224,(1),null);
var inst_41227 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_41225__$1);
var inst_41228 = cljs.core.not(inst_41227);
var state_41244__$1 = (function (){var statearr_41264 = state_41244;
(statearr_41264[(9)] = inst_41225__$1);

(statearr_41264[(8)] = inst_41226);

return statearr_41264;
})();
if(inst_41228){
var statearr_41265_41285 = state_41244__$1;
(statearr_41265_41285[(1)] = (11));

} else {
var statearr_41266_41286 = state_41244__$1;
(statearr_41266_41286[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41245 === (8))){
var _ = (function (){var statearr_41267 = state_41244;
(statearr_41267[(4)] = cljs.core.rest((state_41244[(4)])));

return statearr_41267;
})();
var state_41244__$1 = state_41244;
var ex41260 = (state_41244__$1[(2)]);
var statearr_41268_41287 = state_41244__$1;
(statearr_41268_41287[(5)] = ex41260);


var statearr_41269_41288 = state_41244__$1;
(statearr_41269_41288[(1)] = (7));

(statearr_41269_41288[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11438__auto____0 = (function (){
var statearr_41270 = [null,null,null,null,null,null,null,null,null,null];
(statearr_41270[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11438__auto__);

(statearr_41270[(1)] = (1));

return statearr_41270;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11438__auto____1 = (function (state_41244){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_41244);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e41271){var ex__11441__auto__ = e41271;
var statearr_41272_41289 = state_41244;
(statearr_41272_41289[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_41244[(4)]))){
var statearr_41273_41290 = state_41244;
(statearr_41273_41290[(1)] = cljs.core.first((state_41244[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41291 = state_41244;
state_41244 = G__41291;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11438__auto__ = function(state_41244){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11438__auto____1.call(this,state_41244);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_41274 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_41274[(6)] = c__11512__auto__);

return statearr_41274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e41292){var e = e41292;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__41294 = arguments.length;
switch (G__41294) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_41364){
var state_val_41365 = (state_41364[(1)]);
if((state_val_41365 === (7))){
var inst_41296 = (state_41364[(2)]);
var state_41364__$1 = state_41364;
var statearr_41366_41410 = state_41364__$1;
(statearr_41366_41410[(2)] = inst_41296);

(statearr_41366_41410[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (20))){
var inst_41340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41341 = ["*"];
var inst_41342 = (new cljs.core.PersistentVector(null,1,(5),inst_41340,inst_41341,null));
var state_41364__$1 = state_41364;
var statearr_41367_41411 = state_41364__$1;
(statearr_41367_41411[(2)] = inst_41342);

(statearr_41367_41411[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (1))){
var state_41364__$1 = state_41364;
var statearr_41368_41412 = state_41364__$1;
(statearr_41368_41412[(2)] = null);

(statearr_41368_41412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (4))){
var inst_41295 = (state_41364[(2)]);
var state_41364__$1 = (function (){var statearr_41369 = state_41364;
(statearr_41369[(7)] = inst_41295);

return statearr_41369;
})();
var statearr_41370_41413 = state_41364__$1;
(statearr_41370_41413[(2)] = null);

(statearr_41370_41413[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (15))){
var inst_41359 = (state_41364[(2)]);
var _ = (function (){var statearr_41371 = state_41364;
(statearr_41371[(4)] = cljs.core.rest((state_41364[(4)])));

return statearr_41371;
})();
var state_41364__$1 = state_41364;
var statearr_41372_41414 = state_41364__$1;
(statearr_41372_41414[(2)] = inst_41359);

(statearr_41372_41414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (21))){
var inst_41323 = (state_41364[(8)]);
var inst_41330 = (state_41364[(9)]);
var inst_41344 = (state_41364[(2)]);
var inst_41345 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_41346 = cljs.core.PersistentHashMap.EMPTY;
var inst_41347 = [inst_41344,inst_41330,inst_41346];
var inst_41348 = cljs.core.PersistentHashMap.fromArrays(inst_41345,inst_41347);
var inst_41349 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41323,inst_41348);
var state_41364__$1 = state_41364;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41364__$1,(22),inst_41349);
} else {
if((state_val_41365 === (13))){
var inst_41318 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41364__$1 = state_41364;
var statearr_41373_41415 = state_41364__$1;
(statearr_41373_41415[(2)] = inst_41318);

(statearr_41373_41415[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (22))){
var inst_41351 = (state_41364[(2)]);
var inst_41352 = fluree.db.util.async.throw_err(inst_41351);
var inst_41353 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41352,(0),null);
var inst_41354 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41352,(1),null);
var inst_41355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41356 = [inst_41353,inst_41354];
var inst_41357 = (new cljs.core.PersistentVector(null,2,(5),inst_41355,inst_41356,null));
var state_41364__$1 = state_41364;
var statearr_41374_41416 = state_41364__$1;
(statearr_41374_41416[(2)] = inst_41357);

(statearr_41374_41416[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (6))){
var inst_41305 = (state_41364[(2)]);
var state_41364__$1 = state_41364;
var statearr_41375_41417 = state_41364__$1;
(statearr_41375_41417[(2)] = inst_41305);

(statearr_41375_41417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (17))){
var inst_41327 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41328 = fluree.db.dbfunctions.internal.get(inst_41327,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_41364__$1 = state_41364;
var statearr_41376_41418 = state_41364__$1;
(statearr_41376_41418[(2)] = inst_41328);

(statearr_41376_41418[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (3))){
var inst_41362 = (state_41364[(2)]);
var state_41364__$1 = state_41364;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41364__$1,inst_41362);
} else {
if((state_val_41365 === (12))){
var inst_41316 = (state_41364[(2)]);
var state_41364__$1 = state_41364;
if(cljs.core.truth_(inst_41316)){
var statearr_41377_41419 = state_41364__$1;
(statearr_41377_41419[(1)] = (13));

} else {
var statearr_41378_41420 = state_41364__$1;
(statearr_41378_41420[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (2))){
var inst_41311 = (state_41364[(10)]);
var _ = (function (){var statearr_41379 = state_41364;
(statearr_41379[(4)] = cljs.core.cons((9),(state_41364[(4)])));

return statearr_41379;
})();
var inst_41311__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41364__$1 = (function (){var statearr_41380 = state_41364;
(statearr_41380[(10)] = inst_41311__$1);

return statearr_41380;
})();
if(cljs.core.truth_(inst_41311__$1)){
var statearr_41381_41421 = state_41364__$1;
(statearr_41381_41421[(1)] = (10));

} else {
var statearr_41382_41422 = state_41364__$1;
(statearr_41382_41422[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (19))){
var inst_41332 = cljs.core.PersistentVector.EMPTY;
var inst_41333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41334 = ["*"];
var inst_41335 = (new cljs.core.PersistentVector(null,1,(5),inst_41333,inst_41334,null));
var inst_41336 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_41337 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_41335,inst_41336);
var inst_41338 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41332,inst_41337);
var state_41364__$1 = state_41364;
var statearr_41384_41423 = state_41364__$1;
(statearr_41384_41423[(2)] = inst_41338);

(statearr_41384_41423[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (11))){
var inst_41311 = (state_41364[(10)]);
var state_41364__$1 = state_41364;
var statearr_41385_41424 = state_41364__$1;
(statearr_41385_41424[(2)] = inst_41311);

(statearr_41385_41424[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (9))){
var _ = (function (){var statearr_41386 = state_41364;
(statearr_41386[(4)] = cljs.core.rest((state_41364[(4)])));

return statearr_41386;
})();
var state_41364__$1 = state_41364;
var ex41383 = (state_41364__$1[(2)]);
var statearr_41387_41425 = state_41364__$1;
(statearr_41387_41425[(5)] = ex41383);


var statearr_41388_41426 = state_41364__$1;
(statearr_41388_41426[(1)] = (4));

(statearr_41388_41426[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (5))){
var inst_41295 = (state_41364[(7)]);
var _ = (function (){var statearr_41389 = state_41364;
(statearr_41389[(4)] = cljs.core.cons((8),(state_41364[(4)])));

return statearr_41389;
})();
var inst_41302 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41295,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_41390 = state_41364;
(statearr_41390[(4)] = cljs.core.rest((state_41364[(4)])));

return statearr_41390;
})();
var state_41364__$1 = state_41364;
var statearr_41391_41427 = state_41364__$1;
(statearr_41391_41427[(2)] = inst_41302);

(statearr_41391_41427[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (14))){
var inst_41324 = (state_41364[(11)]);
var inst_41323 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41324__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41364__$1 = (function (){var statearr_41392 = state_41364;
(statearr_41392[(8)] = inst_41323);

(statearr_41392[(11)] = inst_41324__$1);

return statearr_41392;
})();
if(cljs.core.truth_(inst_41324__$1)){
var statearr_41393_41428 = state_41364__$1;
(statearr_41393_41428[(1)] = (16));

} else {
var statearr_41394_41429 = state_41364__$1;
(statearr_41394_41429[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (16))){
var inst_41324 = (state_41364[(11)]);
var state_41364__$1 = state_41364;
var statearr_41395_41430 = state_41364__$1;
(statearr_41395_41430[(2)] = inst_41324);

(statearr_41395_41430[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (10))){
var inst_41313 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_41364__$1 = state_41364;
var statearr_41397_41431 = state_41364__$1;
(statearr_41397_41431[(2)] = inst_41313);

(statearr_41397_41431[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (18))){
var inst_41330 = (state_41364[(2)]);
var state_41364__$1 = (function (){var statearr_41398 = state_41364;
(statearr_41398[(9)] = inst_41330);

return statearr_41398;
})();
if(cljs.core.truth_(additional_params)){
var statearr_41399_41432 = state_41364__$1;
(statearr_41399_41432[(1)] = (19));

} else {
var statearr_41400_41433 = state_41364__$1;
(statearr_41400_41433[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41365 === (8))){
var _ = (function (){var statearr_41401 = state_41364;
(statearr_41401[(4)] = cljs.core.rest((state_41364[(4)])));

return statearr_41401;
})();
var state_41364__$1 = state_41364;
var ex41396 = (state_41364__$1[(2)]);
var statearr_41402_41434 = state_41364__$1;
(statearr_41402_41434[(5)] = ex41396);


var statearr_41403_41435 = state_41364__$1;
(statearr_41403_41435[(1)] = (7));

(statearr_41403_41435[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__11438__auto____0 = (function (){
var statearr_41404 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41404[(0)] = fluree$db$dbfunctions$internal$state_machine__11438__auto__);

(statearr_41404[(1)] = (1));

return statearr_41404;
});
var fluree$db$dbfunctions$internal$state_machine__11438__auto____1 = (function (state_41364){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_41364);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e41405){var ex__11441__auto__ = e41405;
var statearr_41406_41436 = state_41364;
(statearr_41406_41436[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_41364[(4)]))){
var statearr_41407_41437 = state_41364;
(statearr_41407_41437[(1)] = cljs.core.first((state_41364[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41438 = state_41364;
state_41364 = G__41438;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__11438__auto__ = function(state_41364){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__11438__auto____1.call(this,state_41364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__11438__auto____0;
fluree$db$dbfunctions$internal$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__11438__auto____1;
return fluree$db$dbfunctions$internal$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_41408 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_41408[(6)] = c__11512__auto__);

return statearr_41408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__41440 = arguments.length;
switch (G__41440) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_41484){
var state_val_41485 = (state_41484[(1)]);
if((state_val_41485 === (7))){
var inst_41462 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41463 = ["*"];
var inst_41464 = (new cljs.core.PersistentVector(null,1,(5),inst_41462,inst_41463,null));
var state_41484__$1 = state_41484;
var statearr_41486_41506 = state_41484__$1;
(statearr_41486_41506[(2)] = inst_41464);

(statearr_41486_41506[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41485 === (1))){
var state_41484__$1 = state_41484;
var statearr_41487_41507 = state_41484__$1;
(statearr_41487_41507[(2)] = null);

(statearr_41487_41507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41485 === (4))){
var inst_41441 = (state_41484[(2)]);
var inst_41442 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41441,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_41484__$1 = state_41484;
var statearr_41488_41508 = state_41484__$1;
(statearr_41488_41508[(2)] = inst_41442);

(statearr_41488_41508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41485 === (6))){
var inst_41454 = cljs.core.PersistentVector.EMPTY;
var inst_41455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41456 = ["*"];
var inst_41457 = (new cljs.core.PersistentVector(null,1,(5),inst_41455,inst_41456,null));
var inst_41458 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_41459 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_41457,inst_41458);
var inst_41460 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41454,inst_41459);
var state_41484__$1 = state_41484;
var statearr_41489_41509 = state_41484__$1;
(statearr_41489_41509[(2)] = inst_41460);

(statearr_41489_41509[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41485 === (3))){
var inst_41482 = (state_41484[(2)]);
var state_41484__$1 = state_41484;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41484__$1,inst_41482);
} else {
if((state_val_41485 === (2))){
var _ = (function (){var statearr_41491 = state_41484;
(statearr_41491[(4)] = cljs.core.cons((5),(state_41484[(4)])));

return statearr_41491;
})();
var inst_41451 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41452 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41484__$1 = (function (){var statearr_41492 = state_41484;
(statearr_41492[(7)] = inst_41451);

(statearr_41492[(8)] = inst_41452);

return statearr_41492;
})();
if(cljs.core.truth_(additional_params)){
var statearr_41493_41510 = state_41484__$1;
(statearr_41493_41510[(1)] = (6));

} else {
var statearr_41494_41511 = state_41484__$1;
(statearr_41494_41511[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41485 === (9))){
var inst_41473 = (state_41484[(2)]);
var inst_41474 = fluree.db.util.async.throw_err(inst_41473);
var inst_41475 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41474,(0),null);
var inst_41476 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41474,(1),null);
var inst_41477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41478 = [inst_41475,inst_41476];
var inst_41479 = (new cljs.core.PersistentVector(null,2,(5),inst_41477,inst_41478,null));
var _ = (function (){var statearr_41495 = state_41484;
(statearr_41495[(4)] = cljs.core.rest((state_41484[(4)])));

return statearr_41495;
})();
var state_41484__$1 = state_41484;
var statearr_41496_41512 = state_41484__$1;
(statearr_41496_41512[(2)] = inst_41479);

(statearr_41496_41512[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41485 === (5))){
var _ = (function (){var statearr_41497 = state_41484;
(statearr_41497[(4)] = cljs.core.rest((state_41484[(4)])));

return statearr_41497;
})();
var state_41484__$1 = state_41484;
var ex41490 = (state_41484__$1[(2)]);
var statearr_41498_41513 = state_41484__$1;
(statearr_41498_41513[(5)] = ex41490);


var statearr_41499_41514 = state_41484__$1;
(statearr_41499_41514[(1)] = (4));

(statearr_41499_41514[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41485 === (8))){
var inst_41451 = (state_41484[(7)]);
var inst_41452 = (state_41484[(8)]);
var inst_41466 = (state_41484[(2)]);
var inst_41467 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_41468 = cljs.core.PersistentHashMap.EMPTY;
var inst_41469 = [inst_41466,inst_41452,inst_41468];
var inst_41470 = cljs.core.PersistentHashMap.fromArrays(inst_41467,inst_41469);
var inst_41471 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41451,inst_41470);
var state_41484__$1 = state_41484;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41484__$1,(9),inst_41471);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__11438__auto____0 = (function (){
var statearr_41500 = [null,null,null,null,null,null,null,null,null];
(statearr_41500[(0)] = fluree$db$dbfunctions$internal$state_machine__11438__auto__);

(statearr_41500[(1)] = (1));

return statearr_41500;
});
var fluree$db$dbfunctions$internal$state_machine__11438__auto____1 = (function (state_41484){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_41484);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e41501){var ex__11441__auto__ = e41501;
var statearr_41502_41515 = state_41484;
(statearr_41502_41515[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_41484[(4)]))){
var statearr_41503_41516 = state_41484;
(statearr_41503_41516[(1)] = cljs.core.first((state_41484[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41517 = state_41484;
state_41484 = G__41517;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__11438__auto__ = function(state_41484){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__11438__auto____1.call(this,state_41484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__11438__auto____0;
fluree$db$dbfunctions$internal$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__11438__auto____1;
return fluree$db$dbfunctions$internal$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_41504 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_41504[(6)] = c__11512__auto__);

return statearr_41504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_41561){
var state_val_41562 = (state_41561[(1)]);
if((state_val_41562 === (1))){
var state_41561__$1 = state_41561;
var statearr_41563_41577 = state_41561__$1;
(statearr_41563_41577[(2)] = null);

(statearr_41563_41577[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41562 === (2))){
var _ = (function (){var statearr_41564 = state_41561;
(statearr_41564[(4)] = cljs.core.cons((5),(state_41561[(4)])));

return statearr_41564;
})();
var inst_41528 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_41529 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41530 = ["_user/_auth"];
var inst_41531 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41532 = ["*"];
var inst_41533 = (new cljs.core.PersistentVector(null,1,(5),inst_41531,inst_41532,null));
var inst_41534 = [inst_41533];
var inst_41535 = cljs.core.PersistentHashMap.fromArrays(inst_41530,inst_41534);
var inst_41536 = [inst_41535];
var inst_41537 = (new cljs.core.PersistentVector(null,1,(5),inst_41529,inst_41536,null));
var inst_41538 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41539 = cljs.core.PersistentHashMap.EMPTY;
var inst_41540 = [inst_41537,inst_41538,inst_41539];
var inst_41541 = cljs.core.PersistentHashMap.fromArrays(inst_41528,inst_41540);
var inst_41542 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41543 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41542,inst_41541);
var state_41561__$1 = state_41561;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41561__$1,(6),inst_41543);
} else {
if((state_val_41562 === (3))){
var inst_41559 = (state_41561[(2)]);
var state_41561__$1 = state_41561;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41561__$1,inst_41559);
} else {
if((state_val_41562 === (4))){
var inst_41518 = (state_41561[(2)]);
var inst_41519 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41518,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_41561__$1 = state_41561;
var statearr_41566_41578 = state_41561__$1;
(statearr_41566_41578[(2)] = inst_41519);

(statearr_41566_41578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41562 === (5))){
var _ = (function (){var statearr_41567 = state_41561;
(statearr_41567[(4)] = cljs.core.rest((state_41561[(4)])));

return statearr_41567;
})();
var state_41561__$1 = state_41561;
var ex41565 = (state_41561__$1[(2)]);
var statearr_41568_41579 = state_41561__$1;
(statearr_41568_41579[(5)] = ex41565);


var statearr_41569_41580 = state_41561__$1;
(statearr_41569_41580[(1)] = (4));

(statearr_41569_41580[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41562 === (6))){
var inst_41545 = (state_41561[(2)]);
var inst_41546 = fluree.db.util.async.throw_err(inst_41545);
var inst_41547 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41546,(0),null);
var inst_41548 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41546,(1),null);
var inst_41549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41550 = ["_user/_auth","_id"];
var inst_41551 = (new cljs.core.PersistentVector(null,2,(5),inst_41549,inst_41550,null));
var inst_41552 = fluree.db.dbfunctions.internal.get_in(inst_41547,inst_41551);
var inst_41553 = cljs.core.first(inst_41552);
var inst_41554 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41555 = [inst_41553,inst_41548];
var inst_41556 = (new cljs.core.PersistentVector(null,2,(5),inst_41554,inst_41555,null));
var _ = (function (){var statearr_41570 = state_41561;
(statearr_41570[(4)] = cljs.core.rest((state_41561[(4)])));

return statearr_41570;
})();
var state_41561__$1 = state_41561;
var statearr_41571_41581 = state_41561__$1;
(statearr_41571_41581[(2)] = inst_41556);

(statearr_41571_41581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11438__auto____0 = (function (){
var statearr_41572 = [null,null,null,null,null,null,null];
(statearr_41572[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11438__auto__);

(statearr_41572[(1)] = (1));

return statearr_41572;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11438__auto____1 = (function (state_41561){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_41561);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e41573){var ex__11441__auto__ = e41573;
var statearr_41574_41582 = state_41561;
(statearr_41574_41582[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_41561[(4)]))){
var statearr_41575_41583 = state_41561;
(statearr_41575_41583[(1)] = cljs.core.first((state_41561[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41584 = state_41561;
state_41561 = G__41584;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11438__auto__ = function(state_41561){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11438__auto____1.call(this,state_41561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_41576 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_41576[(6)] = c__11512__auto__);

return statearr_41576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_41601){
var state_val_41602 = (state_41601[(1)]);
if((state_val_41602 === (1))){
var state_41601__$1 = state_41601;
var statearr_41603_41617 = state_41601__$1;
(statearr_41603_41617[(2)] = null);

(statearr_41603_41617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41602 === (2))){
var _ = (function (){var statearr_41604 = state_41601;
(statearr_41604[(4)] = cljs.core.cons((5),(state_41601[(4)])));

return statearr_41604;
})();
var inst_41591 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41592 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41593 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_41592,inst_41591);
var state_41601__$1 = state_41601;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41601__$1,(6),inst_41593);
} else {
if((state_val_41602 === (3))){
var inst_41599 = (state_41601[(2)]);
var state_41601__$1 = state_41601;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41601__$1,inst_41599);
} else {
if((state_val_41602 === (4))){
var inst_41585 = (state_41601[(2)]);
var state_41601__$1 = state_41601;
var statearr_41606_41618 = state_41601__$1;
(statearr_41606_41618[(2)] = inst_41585);

(statearr_41606_41618[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41602 === (5))){
var _ = (function (){var statearr_41607 = state_41601;
(statearr_41607[(4)] = cljs.core.rest((state_41601[(4)])));

return statearr_41607;
})();
var state_41601__$1 = state_41601;
var ex41605 = (state_41601__$1[(2)]);
var statearr_41608_41619 = state_41601__$1;
(statearr_41608_41619[(5)] = ex41605);


if((ex41605 instanceof Error)){
var statearr_41609_41620 = state_41601__$1;
(statearr_41609_41620[(1)] = (4));

(statearr_41609_41620[(5)] = null);

} else {
throw ex41605;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41602 === (6))){
var inst_41595 = (state_41601[(2)]);
var inst_41596 = fluree.db.util.async.throw_err(inst_41595);
var _ = (function (){var statearr_41610 = state_41601;
(statearr_41610[(4)] = cljs.core.rest((state_41601[(4)])));

return statearr_41610;
})();
var state_41601__$1 = state_41601;
var statearr_41611_41621 = state_41601__$1;
(statearr_41611_41621[(2)] = inst_41596);

(statearr_41611_41621[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11438__auto____0 = (function (){
var statearr_41612 = [null,null,null,null,null,null,null];
(statearr_41612[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11438__auto__);

(statearr_41612[(1)] = (1));

return statearr_41612;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11438__auto____1 = (function (state_41601){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_41601);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e41613){var ex__11441__auto__ = e41613;
var statearr_41614_41622 = state_41601;
(statearr_41614_41622[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_41601[(4)]))){
var statearr_41615_41623 = state_41601;
(statearr_41615_41623[(1)] = cljs.core.first((state_41601[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41624 = state_41601;
state_41601 = G__41624;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11438__auto__ = function(state_41601){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11438__auto____1.call(this,state_41601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_41616 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_41616[(6)] = c__11512__auto__);

return statearr_41616;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__41625_SHARP_){
return p1__41625_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__41626_SHARP_){
return p1__41626_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e41627){var e = e41627;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__41628_SHARP_){
return p1__41628_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__41629_SHARP_){
return p1__41629_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e41630){var e = e41630;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__41632 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__41632);
})() | (0));
return num;
}catch (e41631){var e = e41631;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_41712){
var state_val_41713 = (state_41712[(1)]);
if((state_val_41713 === (7))){
var inst_41651 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_41652 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_41653 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_41654 = cljs.core.PersistentHashMap.fromArrays(inst_41652,inst_41653);
var inst_41655 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41651,inst_41654);
var inst_41656 = (function(){throw inst_41655})();
var state_41712__$1 = state_41712;
var statearr_41714_41749 = state_41712__$1;
(statearr_41714_41749[(2)] = inst_41656);

(statearr_41714_41749[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41713 === (1))){
var state_41712__$1 = state_41712;
var statearr_41715_41750 = state_41712__$1;
(statearr_41715_41750[(2)] = null);

(statearr_41715_41750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41713 === (4))){
var inst_41633 = (state_41712[(2)]);
var state_41712__$1 = state_41712;
var statearr_41716_41751 = state_41712__$1;
(statearr_41716_41751[(2)] = inst_41633);

(statearr_41716_41751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41713 === (15))){
var inst_41696 = (state_41712[(7)]);
var inst_41692 = (state_41712[(2)]);
var inst_41693 = fluree.db.util.async.throw_err(inst_41692);
var inst_41694 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41693,(0),null);
var inst_41695 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41693,(1),null);
var inst_41696__$1 = cljs.core.first(inst_41694);
var inst_41697 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_41696__$1,compare_val);
var state_41712__$1 = (function (){var statearr_41717 = state_41712;
(statearr_41717[(8)] = inst_41695);

(statearr_41717[(7)] = inst_41696__$1);

return statearr_41717;
})();
if(inst_41697){
var statearr_41718_41752 = state_41712__$1;
(statearr_41718_41752[(1)] = (16));

} else {
var statearr_41719_41753 = state_41712__$1;
(statearr_41719_41753[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41713 === (13))){
var state_41712__$1 = state_41712;
var statearr_41720_41754 = state_41712__$1;
(statearr_41720_41754[(2)] = null);

(statearr_41720_41754[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41713 === (6))){
var state_41712__$1 = state_41712;
var statearr_41721_41755 = state_41712__$1;
(statearr_41721_41755[(2)] = null);

(statearr_41721_41755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41713 === (17))){
var inst_41696 = (state_41712[(7)]);
var inst_41700 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41696)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_41701 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_41702 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_41703 = cljs.core.PersistentHashMap.fromArrays(inst_41701,inst_41702);
var inst_41704 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41700,inst_41703);
var inst_41705 = (function(){throw inst_41704})();
var state_41712__$1 = state_41712;
var statearr_41722_41756 = state_41712__$1;
(statearr_41722_41756[(2)] = inst_41705);

(statearr_41722_41756[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41713 === (3))){
var inst_41710 = (state_41712[(2)]);
var state_41712__$1 = state_41712;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41712__$1,inst_41710);
} else {
if((state_val_41713 === (12))){
var inst_41648 = (state_41712[(9)]);
var inst_41671 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_41648], 0));
var inst_41672 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_41673 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_41674 = cljs.core.PersistentHashMap.fromArrays(inst_41672,inst_41673);
var inst_41675 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41671,inst_41674);
var inst_41676 = (function(){throw inst_41675})();
var state_41712__$1 = state_41712;
var statearr_41723_41757 = state_41712__$1;
(statearr_41723_41757[(2)] = inst_41676);

(statearr_41723_41757[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41713 === (2))){
var inst_41645 = (state_41712[(10)]);
var inst_41646 = (state_41712[(11)]);
var inst_41647 = (state_41712[(12)]);
var _ = (function (){var statearr_41724 = state_41712;
(statearr_41724[(4)] = cljs.core.cons((5),(state_41712[(4)])));

return statearr_41724;
})();
var inst_41643 = _QMARK_ctx;
var inst_41644 = cljs.core.__destructure_map(inst_41643);
var inst_41645__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41644,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_41646__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41644,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_41647__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41644,new cljs.core.Keyword(null,"db","db",993250759));
var inst_41648 = fluree.db.dbproto._p_prop(inst_41647__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_41646__$1);
var state_41712__$1 = (function (){var statearr_41725 = state_41712;
(statearr_41725[(10)] = inst_41645__$1);

(statearr_41725[(11)] = inst_41646__$1);

(statearr_41725[(9)] = inst_41648);

(statearr_41725[(12)] = inst_41647__$1);

return statearr_41725;
})();
if(cljs.core.truth_(inst_41645__$1)){
var statearr_41726_41758 = state_41712__$1;
(statearr_41726_41758[(1)] = (6));

} else {
var statearr_41727_41759 = state_41712__$1;
(statearr_41727_41759[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41713 === (11))){
var inst_41646 = (state_41712[(11)]);
var inst_41647 = (state_41712[(12)]);
var inst_41668 = (state_41712[(2)]);
var inst_41669 = fluree.db.dbproto._p_prop(inst_41647,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_41646);
var state_41712__$1 = (function (){var statearr_41729 = state_41712;
(statearr_41729[(13)] = inst_41668);

return statearr_41729;
})();
if(cljs.core.truth_(inst_41669)){
var statearr_41730_41760 = state_41712__$1;
(statearr_41730_41760[(1)] = (12));

} else {
var statearr_41731_41761 = state_41712__$1;
(statearr_41731_41761[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41713 === (9))){
var state_41712__$1 = state_41712;
var statearr_41732_41762 = state_41712__$1;
(statearr_41732_41762[(2)] = null);

(statearr_41732_41762[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41713 === (5))){
var _ = (function (){var statearr_41733 = state_41712;
(statearr_41733[(4)] = cljs.core.rest((state_41712[(4)])));

return statearr_41733;
})();
var state_41712__$1 = state_41712;
var ex41728 = (state_41712__$1[(2)]);
var statearr_41734_41763 = state_41712__$1;
(statearr_41734_41763[(5)] = ex41728);


if((ex41728 instanceof Error)){
var statearr_41735_41764 = state_41712__$1;
(statearr_41735_41764[(1)] = (4));

(statearr_41735_41764[(5)] = null);

} else {
throw ex41728;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41713 === (14))){
var inst_41645 = (state_41712[(10)]);
var inst_41648 = (state_41712[(9)]);
var inst_41647 = (state_41712[(12)]);
var inst_41679 = (state_41712[(2)]);
var inst_41680 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_41681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41683 = [inst_41645,inst_41648,"?current-val"];
var inst_41684 = (new cljs.core.PersistentVector(null,3,(5),inst_41682,inst_41683,null));
var inst_41685 = [inst_41684];
var inst_41686 = (new cljs.core.PersistentVector(null,1,(5),inst_41681,inst_41685,null));
var inst_41687 = cljs.core.PersistentHashMap.EMPTY;
var inst_41688 = ["?current-val",inst_41686,inst_41687];
var inst_41689 = cljs.core.PersistentHashMap.fromArrays(inst_41680,inst_41688);
var inst_41690 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41647,inst_41689);
var state_41712__$1 = (function (){var statearr_41736 = state_41712;
(statearr_41736[(14)] = inst_41679);

return statearr_41736;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41712__$1,(15),inst_41690);
} else {
if((state_val_41713 === (16))){
var state_41712__$1 = state_41712;
var statearr_41737_41765 = state_41712__$1;
(statearr_41737_41765[(2)] = new_val);

(statearr_41737_41765[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41713 === (10))){
var inst_41661 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_41662 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_41663 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_41664 = cljs.core.PersistentHashMap.fromArrays(inst_41662,inst_41663);
var inst_41665 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41661,inst_41664);
var inst_41666 = (function(){throw inst_41665})();
var state_41712__$1 = state_41712;
var statearr_41738_41766 = state_41712__$1;
(statearr_41738_41766[(2)] = inst_41666);

(statearr_41738_41766[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41713 === (18))){
var inst_41707 = (state_41712[(2)]);
var _ = (function (){var statearr_41739 = state_41712;
(statearr_41739[(4)] = cljs.core.rest((state_41712[(4)])));

return statearr_41739;
})();
var state_41712__$1 = state_41712;
var statearr_41740_41767 = state_41712__$1;
(statearr_41740_41767[(2)] = inst_41707);

(statearr_41740_41767[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41713 === (8))){
var inst_41648 = (state_41712[(9)]);
var inst_41658 = (state_41712[(2)]);
var state_41712__$1 = (function (){var statearr_41741 = state_41712;
(statearr_41741[(15)] = inst_41658);

return statearr_41741;
})();
if(cljs.core.truth_(inst_41648)){
var statearr_41742_41768 = state_41712__$1;
(statearr_41742_41768[(1)] = (9));

} else {
var statearr_41743_41769 = state_41712__$1;
(statearr_41743_41769[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__11438__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__11438__auto____0 = (function (){
var statearr_41744 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41744[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__11438__auto__);

(statearr_41744[(1)] = (1));

return statearr_41744;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__11438__auto____1 = (function (state_41712){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_41712);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e41745){var ex__11441__auto__ = e41745;
var statearr_41746_41770 = state_41712;
(statearr_41746_41770[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_41712[(4)]))){
var statearr_41747_41771 = state_41712;
(statearr_41747_41771[(1)] = cljs.core.first((state_41712[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41772 = state_41712;
state_41712 = G__41772;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__11438__auto__ = function(state_41712){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__11438__auto____1.call(this,state_41712);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__11438__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__11438__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_41748 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_41748[(6)] = c__11512__auto__);

return statearr_41748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
