// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__38244 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38244,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38244,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38244,(2),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__38247){
var map__38248 = p__38247;
var map__38248__$1 = cljs.core.__destructure_map(map__38248);
var opts = map__38248__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38248__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_38308){
var state_val_38309 = (state_38308[(1)]);
if((state_val_38309 === (7))){
var inst_38279 = cljs.core.not(reindex_QMARK_);
var state_38308__$1 = state_38308;
var statearr_38310_38334 = state_38308__$1;
(statearr_38310_38334[(2)] = inst_38279);

(statearr_38310_38334[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38309 === (1))){
var state_38308__$1 = state_38308;
var statearr_38311_38335 = state_38308__$1;
(statearr_38311_38335[(2)] = null);

(statearr_38311_38335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38309 === (4))){
var inst_38249 = (state_38308[(2)]);
var state_38308__$1 = state_38308;
var statearr_38312_38336 = state_38308__$1;
(statearr_38312_38336[(2)] = inst_38249);

(statearr_38312_38336[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38309 === (6))){
var inst_38263 = (state_38308[(7)]);
var inst_38277 = (state_38308[(8)]);
var inst_38269 = (state_38308[(9)]);
var inst_38262 = (state_38308[(2)]);
var inst_38263__$1 = fluree.db.util.async.throw_err(inst_38262);
var inst_38264 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_38265 = cljs.core.__destructure_map(inst_38264);
var inst_38266 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38265,new cljs.core.Keyword(null,"post","post",269697687));
var inst_38267 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38265,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_38268 = fluree.db.flake.size_bytes(inst_38263__$1);
var inst_38269__$1 = (inst_38267 + inst_38268);
var inst_38270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38271 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_38272 = (new cljs.core.PersistentVector(null,2,(5),inst_38270,inst_38271,null));
var inst_38273 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_38272);
var inst_38274 = cljs.core.__destructure_map(inst_38273);
var inst_38275 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38274,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_38276 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38274,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_38277__$1 = (inst_38269__$1 > inst_38276);
var state_38308__$1 = (function (){var statearr_38313 = state_38308;
(statearr_38313[(7)] = inst_38263__$1);

(statearr_38313[(8)] = inst_38277__$1);

(statearr_38313[(10)] = inst_38275);

(statearr_38313[(9)] = inst_38269__$1);

(statearr_38313[(11)] = inst_38266);

return statearr_38313;
})();
if(cljs.core.truth_(inst_38277__$1)){
var statearr_38314_38337 = state_38308__$1;
(statearr_38314_38337[(1)] = (7));

} else {
var statearr_38315_38338 = state_38308__$1;
(statearr_38315_38338[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38309 === (3))){
var inst_38306 = (state_38308[(2)]);
var state_38308__$1 = state_38308;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38308__$1,inst_38306);
} else {
if((state_val_38309 === (12))){
var inst_38263 = (state_38308[(7)]);
var inst_38269 = (state_38308[(9)]);
var inst_38266 = (state_38308[(11)]);
var inst_38292 = (state_38308[(2)]);
var inst_38293 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38266,inst_38263);
var inst_38294 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_38295 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_38294,cljs.core.empty);
var inst_38296 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38297 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_38298 = (new cljs.core.PersistentVector(null,2,(5),inst_38296,inst_38297,null));
var inst_38299 = cljs.core.assoc_in(db,inst_38298,inst_38293);
var inst_38300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38301 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_38302 = (new cljs.core.PersistentVector(null,2,(5),inst_38300,inst_38301,null));
var inst_38303 = cljs.core.assoc_in(inst_38299,inst_38302,inst_38269);
var _ = (function (){var statearr_38316 = state_38308;
(statearr_38316[(4)] = cljs.core.rest((state_38308[(4)])));

return statearr_38316;
})();
var state_38308__$1 = (function (){var statearr_38317 = state_38308;
(statearr_38317[(12)] = inst_38295);

(statearr_38317[(13)] = inst_38292);

return statearr_38317;
})();
var statearr_38318_38339 = state_38308__$1;
(statearr_38318_38339[(2)] = inst_38303);

(statearr_38318_38339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38309 === (2))){
var _ = (function (){var statearr_38319 = state_38308;
(statearr_38319[(4)] = cljs.core.cons((5),(state_38308[(4)])));

return statearr_38319;
})();
var inst_38257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38258 = [pred_id];
var inst_38259 = (new cljs.core.PersistentVector(null,1,(5),inst_38257,inst_38258,null));
var inst_38260 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_38259);
var state_38308__$1 = state_38308;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38308__$1,(6),inst_38260);
} else {
if((state_val_38309 === (11))){
var state_38308__$1 = state_38308;
var statearr_38321_38340 = state_38308__$1;
(statearr_38321_38340[(2)] = null);

(statearr_38321_38340[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38309 === (9))){
var inst_38282 = (state_38308[(2)]);
var state_38308__$1 = state_38308;
if(cljs.core.truth_(inst_38282)){
var statearr_38322_38341 = state_38308__$1;
(statearr_38322_38341[(1)] = (10));

} else {
var statearr_38323_38342 = state_38308__$1;
(statearr_38323_38342[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38309 === (5))){
var _ = (function (){var statearr_38324 = state_38308;
(statearr_38324[(4)] = cljs.core.rest((state_38308[(4)])));

return statearr_38324;
})();
var state_38308__$1 = state_38308;
var ex38320 = (state_38308__$1[(2)]);
var statearr_38325_38343 = state_38308__$1;
(statearr_38325_38343[(5)] = ex38320);


if((ex38320 instanceof Error)){
var statearr_38326_38344 = state_38308__$1;
(statearr_38326_38344[(1)] = (4));

(statearr_38326_38344[(5)] = null);

} else {
throw ex38320;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38309 === (10))){
var inst_38284 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_38285 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_38286 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_38287 = cljs.core.PersistentHashMap.fromArrays(inst_38285,inst_38286);
var inst_38288 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38284,inst_38287);
var inst_38289 = (function(){throw inst_38288})();
var state_38308__$1 = state_38308;
var statearr_38327_38345 = state_38308__$1;
(statearr_38327_38345[(2)] = inst_38289);

(statearr_38327_38345[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38309 === (8))){
var inst_38277 = (state_38308[(8)]);
var state_38308__$1 = state_38308;
var statearr_38328_38346 = state_38308__$1;
(statearr_38328_38346[(2)] = inst_38277);

(statearr_38328_38346[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11438__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11438__auto____0 = (function (){
var statearr_38329 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38329[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11438__auto__);

(statearr_38329[(1)] = (1));

return statearr_38329;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11438__auto____1 = (function (state_38308){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_38308);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e38330){var ex__11441__auto__ = e38330;
var statearr_38331_38347 = state_38308;
(statearr_38331_38347[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_38308[(4)]))){
var statearr_38332_38348 = state_38308;
(statearr_38332_38348[(1)] = cljs.core.first((state_38308[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38349 = state_38308;
state_38308 = G__38349;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11438__auto__ = function(state_38308){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11438__auto____1.call(this,state_38308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11438__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11438__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_38333 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_38333[(6)] = c__11512__auto__);

return statearr_38333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__38354 = arguments.length;
switch (G__38354) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_38550){
var state_val_38551 = (state_38550[(1)]);
if((state_val_38551 === (7))){
var state_38550__$1 = state_38550;
var statearr_38552_38620 = state_38550__$1;
(statearr_38552_38620[(2)] = null);

(statearr_38552_38620[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (20))){
var inst_38474 = (state_38550[(7)]);
var inst_38393 = (state_38550[(8)]);
var inst_38476 = (state_38550[(9)]);
var inst_38443 = (state_38550[(10)]);
var inst_38472 = (state_38550[(11)]);
var inst_38475 = (state_38550[(12)]);
var inst_38473 = (state_38550[(13)]);
var inst_38392 = (state_38550[(14)]);
var inst_38486 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_38487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38488 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_38489 = (new cljs.core.PersistentVector(null,2,(5),inst_38487,inst_38488,null));
var inst_38490 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38443,inst_38489);
var inst_38491 = (inst_38392 + inst_38490);
var inst_38492 = [inst_38472,inst_38473,inst_38474,inst_38475,inst_38491];
var inst_38493 = cljs.core.PersistentHashMap.fromArrays(inst_38486,inst_38492);
var inst_38494 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_38443,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_38476,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_38493], 0));
var state_38550__$1 = (function (){var statearr_38553 = state_38550;
(statearr_38553[(15)] = inst_38494);

return statearr_38553;
})();
if(cljs.core.truth_(inst_38393)){
var statearr_38554_38621 = state_38550__$1;
(statearr_38554_38621[(1)] = (23));

} else {
var statearr_38555_38622 = state_38550__$1;
(statearr_38555_38622[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (27))){
var inst_38494 = (state_38550[(15)]);
var state_38550__$1 = state_38550;
var statearr_38556_38623 = state_38550__$1;
(statearr_38556_38623[(2)] = inst_38494);

(statearr_38556_38623[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (1))){
var state_38550__$1 = state_38550;
var statearr_38557_38624 = state_38550__$1;
(statearr_38557_38624[(2)] = null);

(statearr_38557_38624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (24))){
var inst_38494 = (state_38550[(15)]);
var inst_38497 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_38494);
var inst_38498 = (inst_38497 == null);
var state_38550__$1 = state_38550;
var statearr_38558_38625 = state_38550__$1;
(statearr_38558_38625[(2)] = inst_38498);

(statearr_38558_38625[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (39))){
var inst_38483 = (state_38550[(16)]);
var inst_38526 = (state_38550[(17)]);
var inst_38533 = (state_38550[(18)]);
var inst_38525 = (state_38550[(19)]);
var inst_38524 = (state_38550[(20)]);
var inst_38540 = (state_38550[(2)]);
var inst_38471 = inst_38483;
var inst_38472 = inst_38525;
var inst_38473 = inst_38526;
var inst_38474 = inst_38533;
var inst_38475 = inst_38540;
var inst_38476 = inst_38524;
var state_38550__$1 = (function (){var statearr_38559 = state_38550;
(statearr_38559[(7)] = inst_38474);

(statearr_38559[(9)] = inst_38476);

(statearr_38559[(11)] = inst_38472);

(statearr_38559[(12)] = inst_38475);

(statearr_38559[(13)] = inst_38473);

(statearr_38559[(21)] = inst_38471);

return statearr_38559;
})();
var statearr_38560_38626 = state_38550__$1;
(statearr_38560_38626[(2)] = null);

(statearr_38560_38626[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (4))){
var inst_38355 = (state_38550[(2)]);
var state_38550__$1 = state_38550;
var statearr_38561_38627 = state_38550__$1;
(statearr_38561_38627[(2)] = inst_38355);

(statearr_38561_38627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (15))){
var inst_38415 = (state_38550[(22)]);
var state_38550__$1 = state_38550;
var statearr_38562_38628 = state_38550__$1;
(statearr_38562_38628[(2)] = inst_38415);

(statearr_38562_38628[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (21))){
var inst_38474 = (state_38550[(7)]);
var inst_38452 = (state_38550[(23)]);
var inst_38383 = (state_38550[(24)]);
var inst_38393 = (state_38550[(8)]);
var inst_38476 = (state_38550[(9)]);
var inst_38402 = (state_38550[(25)]);
var inst_38483 = (state_38550[(16)]);
var inst_38443 = (state_38550[(10)]);
var inst_38453 = (state_38550[(26)]);
var inst_38379 = (state_38550[(27)]);
var inst_38396 = (state_38550[(28)]);
var inst_38482 = (state_38550[(29)]);
var inst_38472 = (state_38550[(11)]);
var inst_38362 = (state_38550[(30)]);
var inst_38475 = (state_38550[(12)]);
var inst_38394 = (state_38550[(31)]);
var inst_38387 = (state_38550[(32)]);
var inst_38473 = (state_38550[(13)]);
var inst_38377 = (state_38550[(33)]);
var inst_38392 = (state_38550[(14)]);
var inst_38471 = (state_38550[(21)]);
var inst_38391 = (state_38550[(34)]);
var inst_38521 = inst_38482.s;
var inst_38522 = fluree.db.flake.sid__GT_cid(inst_38521);
var inst_38523 = (function (){var flakes_bytes = inst_38392;
var t = inst_38362;
var spot = inst_38472;
var add_flakes = inst_38379;
var root_setting_change_QMARK_ = inst_38394;
var vec__38448 = inst_38379;
var ref_QMARK__map = inst_38391;
var seq__38479 = inst_38483;
var r = inst_38483;
var psot = inst_38473;
var add_pred_to_idx_QMARK_ = inst_38402;
var _ = inst_38377;
var cid = inst_38522;
var ecount = inst_38476;
var pred_ecount = inst_38396;
var first__38450 = inst_38452;
var db_STAR_ = inst_38443;
var schema_change_QMARK_ = inst_38393;
var vec__38478 = inst_38471;
var add_preds = inst_38383;
var first__38480 = inst_38482;
var opst = inst_38475;
var seq__38449 = inst_38453;
var idx_QMARK__map = inst_38387;
var post = inst_38474;
var G__38447 = inst_38471;
var f = inst_38482;
return (function (p1__38352_SHARP_){
if(cljs.core.truth_(p1__38352_SHARP_)){
var x__5130__auto__ = p1__38352_SHARP_;
var y__5131__auto__ = f.s;
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
} else {
return f.s;
}
});
})();
var inst_38524 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_38476,inst_38522,inst_38523);
var inst_38525 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38472,inst_38482);
var inst_38526 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38473,inst_38482);
var inst_38527 = inst_38482.p;
var inst_38528 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38387,inst_38527);
var state_38550__$1 = (function (){var statearr_38563 = state_38550;
(statearr_38563[(17)] = inst_38526);

(statearr_38563[(19)] = inst_38525);

(statearr_38563[(20)] = inst_38524);

return statearr_38563;
})();
if(cljs.core.truth_(inst_38528)){
var statearr_38564_38629 = state_38550__$1;
(statearr_38564_38629[(1)] = (34));

} else {
var statearr_38565_38630 = state_38550__$1;
(statearr_38565_38630[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (31))){
var inst_38509 = (state_38550[(35)]);
var state_38550__$1 = state_38550;
var statearr_38566_38631 = state_38550__$1;
(statearr_38566_38631[(2)] = inst_38509);

(statearr_38566_38631[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (32))){
var inst_38519 = (state_38550[(2)]);
var state_38550__$1 = state_38550;
var statearr_38567_38632 = state_38550__$1;
(statearr_38567_38632[(2)] = inst_38519);

(statearr_38567_38632[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (33))){
var inst_38509 = (state_38550[(35)]);
var inst_38514 = (state_38550[(2)]);
var inst_38515 = fluree.db.util.async.throw_err(inst_38514);
var inst_38516 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38509,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_38515);
var state_38550__$1 = state_38550;
var statearr_38568_38633 = state_38550__$1;
(statearr_38568_38633[(2)] = inst_38516);

(statearr_38568_38633[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (13))){
var inst_38443 = (state_38550[(10)]);
var inst_38379 = (state_38550[(27)]);
var inst_38362 = (state_38550[(30)]);
var inst_38392 = (state_38550[(14)]);
var inst_38433 = (state_38550[(2)]);
var inst_38434 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38433,new cljs.core.Keyword(null,"t","t",-1397832519),inst_38362);
var inst_38435 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38436 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_38437 = (new cljs.core.PersistentVector(null,2,(5),inst_38435,inst_38436,null));
var inst_38438 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_38434,inst_38437,cljs.core._PLUS_,inst_38392);
var inst_38439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38440 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_38441 = (new cljs.core.PersistentVector(null,2,(5),inst_38439,inst_38440,null));
var inst_38442 = cljs.core.count(inst_38379);
var inst_38443__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_38438,inst_38441,cljs.core._PLUS_,inst_38442);
var inst_38451 = cljs.core.seq(inst_38379);
var inst_38452 = cljs.core.first(inst_38451);
var inst_38453 = cljs.core.next(inst_38451);
var inst_38454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38455 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_38456 = (new cljs.core.PersistentVector(null,2,(5),inst_38454,inst_38455,null));
var inst_38457 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38443__$1,inst_38456);
var inst_38458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38459 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_38460 = (new cljs.core.PersistentVector(null,2,(5),inst_38458,inst_38459,null));
var inst_38461 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38443__$1,inst_38460);
var inst_38462 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38463 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_38464 = (new cljs.core.PersistentVector(null,2,(5),inst_38462,inst_38463,null));
var inst_38465 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38443__$1,inst_38464);
var inst_38466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38467 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_38468 = (new cljs.core.PersistentVector(null,2,(5),inst_38466,inst_38467,null));
var inst_38469 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38443__$1,inst_38468);
var inst_38470 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_38471 = inst_38379;
var inst_38472 = inst_38457;
var inst_38473 = inst_38461;
var inst_38474 = inst_38465;
var inst_38475 = inst_38469;
var inst_38476 = inst_38470;
var state_38550__$1 = (function (){var statearr_38569 = state_38550;
(statearr_38569[(7)] = inst_38474);

(statearr_38569[(23)] = inst_38452);

(statearr_38569[(9)] = inst_38476);

(statearr_38569[(10)] = inst_38443__$1);

(statearr_38569[(26)] = inst_38453);

(statearr_38569[(11)] = inst_38472);

(statearr_38569[(12)] = inst_38475);

(statearr_38569[(13)] = inst_38473);

(statearr_38569[(21)] = inst_38471);

return statearr_38569;
})();
var statearr_38570_38634 = state_38550__$1;
(statearr_38570_38634[(2)] = null);

(statearr_38570_38634[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (22))){
var inst_38543 = (state_38550[(2)]);
var state_38550__$1 = state_38550;
var statearr_38571_38635 = state_38550__$1;
(statearr_38571_38635[(2)] = inst_38543);

(statearr_38571_38635[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (36))){
var inst_38482 = (state_38550[(29)]);
var inst_38391 = (state_38550[(34)]);
var inst_38533 = (state_38550[(2)]);
var inst_38534 = inst_38482.p;
var inst_38535 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38391,inst_38534);
var state_38550__$1 = (function (){var statearr_38572 = state_38550;
(statearr_38572[(18)] = inst_38533);

return statearr_38572;
})();
if(cljs.core.truth_(inst_38535)){
var statearr_38573_38636 = state_38550__$1;
(statearr_38573_38636[(1)] = (37));

} else {
var statearr_38574_38637 = state_38550__$1;
(statearr_38574_38637[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (29))){
var inst_38494 = (state_38550[(15)]);
var inst_38504 = (state_38550[(2)]);
var inst_38505 = fluree.db.util.async.throw_err(inst_38504);
var inst_38506 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38494,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_38505);
var state_38550__$1 = state_38550;
var statearr_38575_38638 = state_38550__$1;
(statearr_38575_38638[(2)] = inst_38506);

(statearr_38575_38638[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (6))){
var inst_38362 = (state_38550[(30)]);
var inst_38367 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_38368 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_38369 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38367)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38368)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38362),"."].join('');
var inst_38370 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38371 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_38372 = cljs.core.PersistentHashMap.fromArrays(inst_38370,inst_38371);
var inst_38373 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38369,inst_38372);
var inst_38374 = (function(){throw inst_38373})();
var state_38550__$1 = state_38550;
var statearr_38576_38639 = state_38550__$1;
(statearr_38576_38639[(2)] = inst_38374);

(statearr_38576_38639[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (28))){
var inst_38394 = (state_38550[(31)]);
var inst_38509 = (state_38550[(2)]);
var state_38550__$1 = (function (){var statearr_38577 = state_38550;
(statearr_38577[(35)] = inst_38509);

return statearr_38577;
})();
if(cljs.core.truth_(inst_38394)){
var statearr_38578_38640 = state_38550__$1;
(statearr_38578_38640[(1)] = (30));

} else {
var statearr_38579_38641 = state_38550__$1;
(statearr_38579_38641[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (25))){
var inst_38500 = (state_38550[(2)]);
var state_38550__$1 = state_38550;
if(cljs.core.truth_(inst_38500)){
var statearr_38580_38642 = state_38550__$1;
(statearr_38580_38642[(1)] = (26));

} else {
var statearr_38581_38643 = state_38550__$1;
(statearr_38581_38643[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (34))){
var inst_38474 = (state_38550[(7)]);
var inst_38482 = (state_38550[(29)]);
var inst_38530 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38474,inst_38482);
var state_38550__$1 = state_38550;
var statearr_38582_38644 = state_38550__$1;
(statearr_38582_38644[(2)] = inst_38530);

(statearr_38582_38644[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (17))){
var inst_38422 = (state_38550[(36)]);
var inst_38426 = (state_38550[(2)]);
var inst_38427 = fluree.db.util.async.throw_err(inst_38426);
var inst_38414 = inst_38422;
var inst_38415 = inst_38427;
var state_38550__$1 = (function (){var statearr_38583 = state_38550;
(statearr_38583[(37)] = inst_38414);

(statearr_38583[(22)] = inst_38415);

return statearr_38583;
})();
var statearr_38584_38645 = state_38550__$1;
(statearr_38584_38645[(2)] = null);

(statearr_38584_38645[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (3))){
var inst_38548 = (state_38550[(2)]);
var state_38550__$1 = state_38550;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38550__$1,inst_38548);
} else {
if((state_val_38551 === (12))){
var inst_38421 = (state_38550[(38)]);
var inst_38414 = (state_38550[(37)]);
var inst_38420 = cljs.core.seq(inst_38414);
var inst_38421__$1 = cljs.core.first(inst_38420);
var inst_38422 = cljs.core.next(inst_38420);
var state_38550__$1 = (function (){var statearr_38585 = state_38550;
(statearr_38585[(38)] = inst_38421__$1);

(statearr_38585[(36)] = inst_38422);

return statearr_38585;
})();
if(cljs.core.truth_(inst_38421__$1)){
var statearr_38586_38646 = state_38550__$1;
(statearr_38586_38646[(1)] = (14));

} else {
var statearr_38587_38647 = state_38550__$1;
(statearr_38587_38647[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (2))){
var inst_38362 = (state_38550[(30)]);
var _ = (function (){var statearr_38588 = state_38550;
(statearr_38588[(4)] = cljs.core.cons((5),(state_38550[(4)])));

return statearr_38588;
})();
var inst_38361 = cljs.core.first(flakes);
var inst_38362__$1 = inst_38361.t;
var inst_38363 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_38364 = (inst_38363 - (1));
var inst_38365 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_38362__$1,inst_38364);
var state_38550__$1 = (function (){var statearr_38589 = state_38550;
(statearr_38589[(30)] = inst_38362__$1);

return statearr_38589;
})();
if(inst_38365){
var statearr_38590_38648 = state_38550__$1;
(statearr_38590_38648[(1)] = (6));

} else {
var statearr_38591_38649 = state_38550__$1;
(statearr_38591_38649[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (23))){
var inst_38393 = (state_38550[(8)]);
var state_38550__$1 = state_38550;
var statearr_38592_38650 = state_38550__$1;
(statearr_38592_38650[(2)] = inst_38393);

(statearr_38592_38650[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (35))){
var inst_38474 = (state_38550[(7)]);
var state_38550__$1 = state_38550;
var statearr_38593_38651 = state_38550__$1;
(statearr_38593_38651[(2)] = inst_38474);

(statearr_38593_38651[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (19))){
var inst_38545 = (state_38550[(2)]);
var _ = (function (){var statearr_38594 = state_38550;
(statearr_38594[(4)] = cljs.core.rest((state_38550[(4)])));

return statearr_38594;
})();
var state_38550__$1 = state_38550;
var statearr_38595_38652 = state_38550__$1;
(statearr_38595_38652[(2)] = inst_38545);

(statearr_38595_38652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (11))){
var inst_38402 = (state_38550[(25)]);
var inst_38402__$1 = (state_38550[(2)]);
var inst_38410 = cljs.core.seq(inst_38402__$1);
var inst_38411 = cljs.core.first(inst_38410);
var inst_38412 = cljs.core.next(inst_38410);
var inst_38413 = db;
var inst_38414 = inst_38402__$1;
var inst_38415 = inst_38413;
var state_38550__$1 = (function (){var statearr_38597 = state_38550;
(statearr_38597[(25)] = inst_38402__$1);

(statearr_38597[(39)] = inst_38412);

(statearr_38597[(37)] = inst_38414);

(statearr_38597[(40)] = inst_38411);

(statearr_38597[(22)] = inst_38415);

return statearr_38597;
})();
var statearr_38598_38653 = state_38550__$1;
(statearr_38598_38653[(2)] = null);

(statearr_38598_38653[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (9))){
var inst_38379 = (state_38550[(27)]);
var inst_38396 = (state_38550[(28)]);
var inst_38398 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_38379,inst_38396);
var state_38550__$1 = state_38550;
var statearr_38599_38654 = state_38550__$1;
(statearr_38599_38654[(2)] = inst_38398);

(statearr_38599_38654[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (5))){
var _ = (function (){var statearr_38600 = state_38550;
(statearr_38600[(4)] = cljs.core.rest((state_38550[(4)])));

return statearr_38600;
})();
var state_38550__$1 = state_38550;
var ex38596 = (state_38550__$1[(2)]);
var statearr_38601_38655 = state_38550__$1;
(statearr_38601_38655[(5)] = ex38596);


if((ex38596 instanceof Error)){
var statearr_38602_38656 = state_38550__$1;
(statearr_38602_38656[(1)] = (4));

(statearr_38602_38656[(5)] = null);

} else {
throw ex38596;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (14))){
var inst_38421 = (state_38550[(38)]);
var inst_38415 = (state_38550[(22)]);
var inst_38424 = fluree.db.graphdb.add_predicate_to_idx(inst_38415,inst_38421,opts);
var state_38550__$1 = state_38550;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38550__$1,(17),inst_38424);
} else {
if((state_val_38551 === (26))){
var inst_38494 = (state_38550[(15)]);
var inst_38502 = fluree.db.query.schema.schema_map(inst_38494);
var state_38550__$1 = state_38550;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38550__$1,(29),inst_38502);
} else {
if((state_val_38551 === (16))){
var inst_38431 = (state_38550[(2)]);
var state_38550__$1 = state_38550;
var statearr_38603_38657 = state_38550__$1;
(statearr_38603_38657[(2)] = inst_38431);

(statearr_38603_38657[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (38))){
var inst_38475 = (state_38550[(12)]);
var state_38550__$1 = state_38550;
var statearr_38604_38658 = state_38550__$1;
(statearr_38604_38658[(2)] = inst_38475);

(statearr_38604_38658[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (30))){
var inst_38509 = (state_38550[(35)]);
var inst_38512 = fluree.db.query.schema.setting_map(inst_38509);
var state_38550__$1 = state_38550;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38550__$1,(33),inst_38512);
} else {
if((state_val_38551 === (10))){
var inst_38400 = cljs.core.PersistentVector.EMPTY;
var state_38550__$1 = state_38550;
var statearr_38605_38659 = state_38550__$1;
(statearr_38605_38659[(2)] = inst_38400);

(statearr_38605_38659[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (18))){
var inst_38482 = (state_38550[(29)]);
var inst_38471 = (state_38550[(21)]);
var inst_38481 = cljs.core.seq(inst_38471);
var inst_38482__$1 = cljs.core.first(inst_38481);
var inst_38483 = cljs.core.next(inst_38481);
var inst_38484 = cljs.core.not(inst_38482__$1);
var state_38550__$1 = (function (){var statearr_38606 = state_38550;
(statearr_38606[(16)] = inst_38483);

(statearr_38606[(29)] = inst_38482__$1);

return statearr_38606;
})();
if(inst_38484){
var statearr_38607_38660 = state_38550__$1;
(statearr_38607_38660[(1)] = (20));

} else {
var statearr_38608_38661 = state_38550__$1;
(statearr_38608_38661[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (37))){
var inst_38482 = (state_38550[(29)]);
var inst_38475 = (state_38550[(12)]);
var inst_38537 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38475,inst_38482);
var state_38550__$1 = state_38550;
var statearr_38609_38662 = state_38550__$1;
(statearr_38609_38662[(2)] = inst_38537);

(statearr_38609_38662[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38551 === (8))){
var inst_38383 = (state_38550[(24)]);
var inst_38393 = (state_38550[(8)]);
var inst_38379 = (state_38550[(27)]);
var inst_38362 = (state_38550[(30)]);
var inst_38387 = (state_38550[(32)]);
var inst_38377 = (state_38550[(33)]);
var inst_38377__$1 = (state_38550[(2)]);
var inst_38378 = (function (){var t = inst_38362;
var _ = inst_38377__$1;
return (function (p1__38350_SHARP_){
return cljs.core.not((function (){var G__38610 = p1__38350_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__38610) : fluree.db.graphdb.exclude_predicates.call(null,G__38610));
})());
});
})();
var inst_38379__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_38378,flakes);
var inst_38380 = cljs.core.PersistentHashSet.EMPTY;
var inst_38381 = (function (){var t = inst_38362;
var _ = inst_38377__$1;
var add_flakes = inst_38379__$1;
return (function (p1__38351_SHARP_){
return p1__38351_SHARP_.p;
});
})();
var inst_38382 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38381,inst_38379__$1);
var inst_38383__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38380,inst_38382);
var inst_38384 = cljs.core.PersistentHashMap.EMPTY;
var inst_38385 = (function (){var t = inst_38362;
var _ = inst_38377__$1;
var add_flakes = inst_38379__$1;
var add_preds = inst_38383__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_38386 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38385,inst_38383__$1);
var inst_38387__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38384,inst_38386);
var inst_38388 = cljs.core.PersistentHashMap.EMPTY;
var inst_38389 = (function (){var t = inst_38362;
var _ = inst_38377__$1;
var add_flakes = inst_38379__$1;
var add_preds = inst_38383__$1;
var idx_QMARK__map = inst_38387__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_38390 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38389,inst_38383__$1);
var inst_38391 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38388,inst_38390);
var inst_38392 = fluree.db.flake.size_bytes(inst_38379__$1);
var inst_38393__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_38379__$1);
var inst_38394 = fluree.db.util.schema.setting_change_QMARK_(inst_38379__$1);
var inst_38395 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_38396 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38395,(0));
var state_38550__$1 = (function (){var statearr_38611 = state_38550;
(statearr_38611[(24)] = inst_38383__$1);

(statearr_38611[(8)] = inst_38393__$1);

(statearr_38611[(27)] = inst_38379__$1);

(statearr_38611[(28)] = inst_38396);

(statearr_38611[(31)] = inst_38394);

(statearr_38611[(32)] = inst_38387__$1);

(statearr_38611[(33)] = inst_38377__$1);

(statearr_38611[(14)] = inst_38392);

(statearr_38611[(34)] = inst_38391);

return statearr_38611;
})();
if(cljs.core.truth_(inst_38393__$1)){
var statearr_38612_38663 = state_38550__$1;
(statearr_38612_38663[(1)] = (9));

} else {
var statearr_38613_38664 = state_38550__$1;
(statearr_38613_38664[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__11438__auto__ = null;
var fluree$db$graphdb$state_machine__11438__auto____0 = (function (){
var statearr_38614 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38614[(0)] = fluree$db$graphdb$state_machine__11438__auto__);

(statearr_38614[(1)] = (1));

return statearr_38614;
});
var fluree$db$graphdb$state_machine__11438__auto____1 = (function (state_38550){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_38550);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e38615){var ex__11441__auto__ = e38615;
var statearr_38616_38665 = state_38550;
(statearr_38616_38665[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_38550[(4)]))){
var statearr_38617_38666 = state_38550;
(statearr_38617_38666[(1)] = cljs.core.first((state_38550[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38667 = state_38550;
state_38550 = G__38667;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__11438__auto__ = function(state_38550){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__11438__auto____1.call(this,state_38550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__11438__auto____0;
fluree$db$graphdb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__11438__auto____1;
return fluree$db$graphdb$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_38618 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_38618[(6)] = c__11512__auto__);

return statearr_38618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__38669 = arguments.length;
switch (G__38669) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11512__auto___38816 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_38765){
var state_val_38766 = (state_38765[(1)]);
if((state_val_38766 === (7))){
var state_38765__$1 = state_38765;
var statearr_38767_38817 = state_38765__$1;
(statearr_38767_38817[(2)] = null);

(statearr_38767_38817[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (20))){
var inst_38715 = (state_38765[(7)]);
var inst_38714 = (state_38765[(8)]);
var inst_38713 = (state_38765[(9)]);
var inst_38734 = (inst_38713 + (1));
var inst_38735 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38715,new cljs.core.Keyword(null,"t","t",-1397832519),inst_38734);
var inst_38736 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_38735,inst_38714,opts);
var state_38765__$1 = state_38765;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38765__$1,(23),inst_38736);
} else {
if((state_val_38766 === (1))){
var state_38765__$1 = state_38765;
var statearr_38768_38818 = state_38765__$1;
(statearr_38768_38818[(2)] = null);

(statearr_38768_38818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (24))){
var inst_38739 = (state_38765[(10)]);
var inst_38742 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38739,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_38765__$1 = state_38765;
var statearr_38769_38819 = state_38765__$1;
(statearr_38769_38819[(2)] = inst_38742);

(statearr_38769_38819[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (4))){
var inst_38670 = (state_38765[(2)]);
var inst_38671 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_38670);
var state_38765__$1 = state_38765;
var statearr_38770_38820 = state_38765__$1;
(statearr_38770_38820[(2)] = inst_38671);

(statearr_38770_38820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (15))){
var inst_38721 = (state_38765[(11)]);
var state_38765__$1 = state_38765;
var statearr_38771_38821 = state_38765__$1;
(statearr_38771_38821[(2)] = inst_38721);

(statearr_38771_38821[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (21))){
var state_38765__$1 = state_38765;
var statearr_38772_38822 = state_38765__$1;
(statearr_38772_38822[(2)] = null);

(statearr_38772_38822[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (13))){
var inst_38757 = (state_38765[(2)]);
var inst_38758 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_38757);
var state_38765__$1 = state_38765;
var statearr_38773_38823 = state_38765__$1;
(statearr_38773_38823[(2)] = inst_38758);

(statearr_38773_38823[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (22))){
var inst_38753 = (state_38765[(2)]);
var state_38765__$1 = state_38765;
var statearr_38774_38824 = state_38765__$1;
(statearr_38774_38824[(2)] = inst_38753);

(statearr_38774_38824[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (6))){
var inst_38681 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_38682 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_38683 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38681)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38682)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_38684 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38685 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_38686 = cljs.core.PersistentHashMap.fromArrays(inst_38684,inst_38685);
var inst_38687 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38683,inst_38686);
var inst_38688 = (function(){throw inst_38687})();
var state_38765__$1 = state_38765;
var statearr_38777_38825 = state_38765__$1;
(statearr_38777_38825[(2)] = inst_38688);

(statearr_38777_38825[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (25))){
var inst_38721 = (state_38765[(11)]);
var inst_38739 = (state_38765[(10)]);
var inst_38722 = (state_38765[(12)]);
var inst_38744 = inst_38721.t;
var inst_38745 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38746 = [inst_38721];
var inst_38747 = (new cljs.core.PersistentVector(null,1,(5),inst_38745,inst_38746,null));
var inst_38712 = inst_38722;
var inst_38713 = inst_38744;
var inst_38714 = inst_38747;
var inst_38715 = inst_38739;
var state_38765__$1 = (function (){var statearr_38778 = state_38765;
(statearr_38778[(7)] = inst_38715);

(statearr_38778[(13)] = inst_38712);

(statearr_38778[(8)] = inst_38714);

(statearr_38778[(9)] = inst_38713);

return statearr_38778;
})();
var statearr_38779_38826 = state_38765__$1;
(statearr_38779_38826[(2)] = null);

(statearr_38779_38826[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (17))){
var inst_38715 = (state_38765[(7)]);
var inst_38721 = (state_38765[(11)]);
var inst_38714 = (state_38765[(8)]);
var inst_38722 = (state_38765[(12)]);
var inst_38713 = (state_38765[(9)]);
var inst_38730 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38714,inst_38721);
var tmp38775 = inst_38715;
var tmp38776 = inst_38713;
var inst_38712 = inst_38722;
var inst_38713__$1 = tmp38776;
var inst_38714__$1 = inst_38730;
var inst_38715__$1 = tmp38775;
var state_38765__$1 = (function (){var statearr_38780 = state_38765;
(statearr_38780[(7)] = inst_38715__$1);

(statearr_38780[(13)] = inst_38712);

(statearr_38780[(8)] = inst_38714__$1);

(statearr_38780[(9)] = inst_38713__$1);

return statearr_38780;
})();
var statearr_38781_38827 = state_38765__$1;
(statearr_38781_38827[(2)] = null);

(statearr_38781_38827[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (3))){
var inst_38763 = (state_38765[(2)]);
var state_38765__$1 = state_38765;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38765__$1,inst_38763);
} else {
if((state_val_38766 === (12))){
var inst_38721 = (state_38765[(11)]);
var inst_38712 = (state_38765[(13)]);
var inst_38720 = cljs.core.seq(inst_38712);
var inst_38721__$1 = cljs.core.first(inst_38720);
var inst_38722 = cljs.core.next(inst_38720);
var state_38765__$1 = (function (){var statearr_38782 = state_38765;
(statearr_38782[(11)] = inst_38721__$1);

(statearr_38782[(12)] = inst_38722);

return statearr_38782;
})();
if(cljs.core.truth_(inst_38721__$1)){
var statearr_38783_38828 = state_38765__$1;
(statearr_38783_38828[(1)] = (14));

} else {
var statearr_38784_38829 = state_38765__$1;
(statearr_38784_38829[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (2))){
var _ = (function (){var statearr_38785 = state_38765;
(statearr_38785[(4)] = cljs.core.cons((5),(state_38765[(4)])));

return statearr_38785;
})();
var inst_38677 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_38678 = (inst_38677 + (1));
var inst_38679 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_38678);
var state_38765__$1 = state_38765;
if(inst_38679){
var statearr_38786_38830 = state_38765__$1;
(statearr_38786_38830[(1)] = (6));

} else {
var statearr_38787_38831 = state_38765__$1;
(statearr_38787_38831[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (23))){
var inst_38721 = (state_38765[(11)]);
var inst_38738 = (state_38765[(2)]);
var inst_38739 = fluree.db.util.async.throw_err(inst_38738);
var inst_38740 = (inst_38721 == null);
var state_38765__$1 = (function (){var statearr_38788 = state_38765;
(statearr_38788[(10)] = inst_38739);

return statearr_38788;
})();
if(cljs.core.truth_(inst_38740)){
var statearr_38789_38832 = state_38765__$1;
(statearr_38789_38832[(1)] = (24));

} else {
var statearr_38790_38833 = state_38765__$1;
(statearr_38790_38833[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (19))){
var inst_38755 = (state_38765[(2)]);
var state_38765__$1 = state_38765;
var statearr_38791_38834 = state_38765__$1;
(statearr_38791_38834[(2)] = inst_38755);

(statearr_38791_38834[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (11))){
var inst_38760 = (state_38765[(2)]);
var _ = (function (){var statearr_38793 = state_38765;
(statearr_38793[(4)] = cljs.core.rest((state_38765[(4)])));

return statearr_38793;
})();
var state_38765__$1 = state_38765;
var statearr_38794_38835 = state_38765__$1;
(statearr_38794_38835[(2)] = inst_38760);

(statearr_38794_38835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (9))){
var inst_38694 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_38695 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_38694);
var state_38765__$1 = state_38765;
var statearr_38795_38836 = state_38765__$1;
(statearr_38795_38836[(2)] = inst_38695);

(statearr_38795_38836[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (5))){
var _ = (function (){var statearr_38796 = state_38765;
(statearr_38796[(4)] = cljs.core.rest((state_38765[(4)])));

return statearr_38796;
})();
var state_38765__$1 = state_38765;
var ex38792 = (state_38765__$1[(2)]);
var statearr_38797_38837 = state_38765__$1;
(statearr_38797_38837[(5)] = ex38792);


var statearr_38798_38838 = state_38765__$1;
(statearr_38798_38838[(1)] = (4));

(statearr_38798_38838[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (14))){
var inst_38721 = (state_38765[(11)]);
var inst_38713 = (state_38765[(9)]);
var inst_38724 = inst_38721.t;
var inst_38725 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38713,inst_38724);
var state_38765__$1 = state_38765;
var statearr_38799_38839 = state_38765__$1;
(statearr_38799_38839[(2)] = inst_38725);

(statearr_38799_38839[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (26))){
var inst_38750 = (state_38765[(2)]);
var state_38765__$1 = state_38765;
var statearr_38800_38840 = state_38765__$1;
(statearr_38800_38840[(2)] = inst_38750);

(statearr_38800_38840[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (16))){
var inst_38728 = (state_38765[(2)]);
var state_38765__$1 = state_38765;
if(cljs.core.truth_(inst_38728)){
var statearr_38801_38841 = state_38765__$1;
(statearr_38801_38841[(1)] = (17));

} else {
var statearr_38802_38842 = state_38765__$1;
(statearr_38802_38842[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (10))){
var inst_38697 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_38698 = cljs.core.first(inst_38697);
var inst_38706 = cljs.core.seq(inst_38697);
var inst_38707 = cljs.core.first(inst_38706);
var inst_38708 = cljs.core.next(inst_38706);
var inst_38709 = inst_38698.t;
var inst_38710 = cljs.core.PersistentVector.EMPTY;
var inst_38711 = db;
var inst_38712 = inst_38697;
var inst_38713 = inst_38709;
var inst_38714 = inst_38710;
var inst_38715 = inst_38711;
var state_38765__$1 = (function (){var statearr_38803 = state_38765;
(statearr_38803[(7)] = inst_38715);

(statearr_38803[(14)] = inst_38708);

(statearr_38803[(13)] = inst_38712);

(statearr_38803[(15)] = inst_38707);

(statearr_38803[(8)] = inst_38714);

(statearr_38803[(9)] = inst_38713);

return statearr_38803;
})();
var statearr_38804_38843 = state_38765__$1;
(statearr_38804_38843[(2)] = null);

(statearr_38804_38843[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (18))){
var state_38765__$1 = state_38765;
var statearr_38805_38844 = state_38765__$1;
(statearr_38805_38844[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38766 === (8))){
var inst_38691 = (state_38765[(2)]);
var inst_38692 = cljs.core.empty_QMARK_(flakes);
var state_38765__$1 = (function (){var statearr_38807 = state_38765;
(statearr_38807[(16)] = inst_38691);

return statearr_38807;
})();
if(inst_38692){
var statearr_38808_38845 = state_38765__$1;
(statearr_38808_38845[(1)] = (9));

} else {
var statearr_38809_38846 = state_38765__$1;
(statearr_38809_38846[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__11438__auto__ = null;
var fluree$db$graphdb$state_machine__11438__auto____0 = (function (){
var statearr_38810 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38810[(0)] = fluree$db$graphdb$state_machine__11438__auto__);

(statearr_38810[(1)] = (1));

return statearr_38810;
});
var fluree$db$graphdb$state_machine__11438__auto____1 = (function (state_38765){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_38765);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e38811){var ex__11441__auto__ = e38811;
var statearr_38812_38847 = state_38765;
(statearr_38812_38847[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_38765[(4)]))){
var statearr_38813_38848 = state_38765;
(statearr_38813_38848[(1)] = cljs.core.first((state_38765[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38849 = state_38765;
state_38765 = G__38849;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__11438__auto__ = function(state_38765){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__11438__auto____1.call(this,state_38765);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__11438__auto____0;
fluree$db$graphdb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__11438__auto____1;
return fluree$db$graphdb$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_38814 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_38814[(6)] = c__11512__auto___38816);

return statearr_38814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_38905){
var state_val_38906 = (state_38905[(1)]);
if((state_val_38906 === (7))){
var state_38905__$1 = state_38905;
var statearr_38907_38934 = state_38905__$1;
(statearr_38907_38934[(2)] = tt_id);

(statearr_38907_38934[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38906 === (1))){
var state_38905__$1 = state_38905;
var statearr_38908_38935 = state_38905__$1;
(statearr_38908_38935[(2)] = null);

(statearr_38908_38935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38906 === (4))){
var inst_38850 = (state_38905[(2)]);
var state_38905__$1 = state_38905;
var statearr_38909_38936 = state_38905__$1;
(statearr_38909_38936[(2)] = inst_38850);

(statearr_38909_38936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38906 === (13))){
var inst_38898 = (state_38905[(2)]);
var state_38905__$1 = state_38905;
var statearr_38910_38937 = state_38905__$1;
(statearr_38910_38937[(2)] = inst_38898);

(statearr_38910_38937[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38906 === (6))){
var inst_38858 = fluree.db.util.core.random_uuid();
var state_38905__$1 = state_38905;
var statearr_38911_38938 = state_38905__$1;
(statearr_38911_38938[(2)] = inst_38858);

(statearr_38911_38938[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38906 === (3))){
var inst_38903 = (state_38905[(2)]);
var state_38905__$1 = state_38905;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38905__$1,inst_38903);
} else {
if((state_val_38906 === (12))){
var inst_38881 = (state_38905[(7)]);
var state_38905__$1 = state_38905;
var statearr_38912_38939 = state_38905__$1;
(statearr_38912_38939[(2)] = inst_38881);

(statearr_38912_38939[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38906 === (2))){
var _ = (function (){var statearr_38913 = state_38905;
(statearr_38913[(4)] = cljs.core.cons((5),(state_38905[(4)])));

return statearr_38913;
})();
var inst_38856 = (tt_id == null);
var state_38905__$1 = state_38905;
if(cljs.core.truth_(inst_38856)){
var statearr_38914_38940 = state_38905__$1;
(statearr_38914_38940[(1)] = (6));

} else {
var statearr_38915_38941 = state_38905__$1;
(statearr_38915_38941[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38906 === (11))){
var inst_38881 = (state_38905[(7)]);
var inst_38888 = (state_38905[(8)]);
var inst_38891 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_38881,inst_38888);
var state_38905__$1 = state_38905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38905__$1,(14),inst_38891);
} else {
if((state_val_38906 === (9))){
var inst_38888 = (state_38905[(8)]);
var inst_38882 = (state_38905[(9)]);
var inst_38887 = cljs.core.seq(inst_38882);
var inst_38888__$1 = cljs.core.first(inst_38887);
var inst_38889 = cljs.core.next(inst_38887);
var state_38905__$1 = (function (){var statearr_38917 = state_38905;
(statearr_38917[(8)] = inst_38888__$1);

(statearr_38917[(10)] = inst_38889);

return statearr_38917;
})();
if(cljs.core.truth_(inst_38888__$1)){
var statearr_38918_38942 = state_38905__$1;
(statearr_38918_38942[(1)] = (11));

} else {
var statearr_38919_38943 = state_38905__$1;
(statearr_38919_38943[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38906 === (5))){
var _ = (function (){var statearr_38920 = state_38905;
(statearr_38920[(4)] = cljs.core.rest((state_38905[(4)])));

return statearr_38920;
})();
var state_38905__$1 = state_38905;
var ex38916 = (state_38905__$1[(2)]);
var statearr_38921_38944 = state_38905__$1;
(statearr_38921_38944[(5)] = ex38916);


if((ex38916 instanceof Error)){
var statearr_38922_38945 = state_38905__$1;
(statearr_38922_38945[(1)] = (4));

(statearr_38922_38945[(5)] = null);

} else {
throw ex38916;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38906 === (14))){
var inst_38889 = (state_38905[(10)]);
var inst_38893 = (state_38905[(2)]);
var inst_38894 = fluree.db.util.async.throw_err(inst_38893);
var inst_38881 = inst_38894;
var inst_38882 = inst_38889;
var state_38905__$1 = (function (){var statearr_38923 = state_38905;
(statearr_38923[(7)] = inst_38881);

(statearr_38923[(9)] = inst_38882);

return statearr_38923;
})();
var statearr_38924_38946 = state_38905__$1;
(statearr_38924_38946[(2)] = null);

(statearr_38924_38946[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38906 === (10))){
var inst_38900 = (state_38905[(2)]);
var _ = (function (){var statearr_38925 = state_38905;
(statearr_38925[(4)] = cljs.core.rest((state_38905[(4)])));

return statearr_38925;
})();
var state_38905__$1 = state_38905;
var statearr_38926_38947 = state_38905__$1;
(statearr_38926_38947[(2)] = inst_38900);

(statearr_38926_38947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38906 === (8))){
var inst_38861 = (state_38905[(2)]);
var inst_38862 = (function (){var tt_id_SINGLEQUOTE_ = inst_38861;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_38863 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_38861);
var inst_38864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38865 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_38866 = (new cljs.core.PersistentVector(null,4,(5),inst_38864,inst_38865,null));
var inst_38867 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_38862,inst_38863,inst_38866);
var inst_38868 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_38869 = cljs.core.reverse(inst_38868);
var inst_38870 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_38869);
var inst_38878 = cljs.core.seq(inst_38870);
var inst_38879 = cljs.core.first(inst_38878);
var inst_38880 = cljs.core.next(inst_38878);
var inst_38881 = inst_38867;
var inst_38882 = inst_38870;
var state_38905__$1 = (function (){var statearr_38927 = state_38905;
(statearr_38927[(7)] = inst_38881);

(statearr_38927[(11)] = inst_38880);

(statearr_38927[(12)] = inst_38879);

(statearr_38927[(9)] = inst_38882);

return statearr_38927;
})();
var statearr_38928_38948 = state_38905__$1;
(statearr_38928_38948[(2)] = null);

(statearr_38928_38948[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__11438__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__11438__auto____0 = (function (){
var statearr_38929 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38929[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__11438__auto__);

(statearr_38929[(1)] = (1));

return statearr_38929;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__11438__auto____1 = (function (state_38905){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_38905);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e38930){var ex__11441__auto__ = e38930;
var statearr_38931_38949 = state_38905;
(statearr_38931_38949[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_38905[(4)]))){
var statearr_38932_38950 = state_38905;
(statearr_38932_38950[(1)] = cljs.core.first((state_38905[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38951 = state_38905;
state_38905 = G__38951;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__11438__auto__ = function(state_38905){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__11438__auto____1.call(this,state_38905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__11438__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__11438__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_38933 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_38933[(6)] = c__11512__auto__);

return statearr_38933;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11512__auto___39138 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_39069){
var state_val_39070 = (state_39069[(1)]);
if((state_val_39070 === (7))){
var inst_38979 = (state_39069[(7)]);
var inst_38979__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_39069__$1 = (function (){var statearr_39071 = state_39069;
(statearr_39071[(7)] = inst_38979__$1);

return statearr_39071;
})();
if(inst_38979__$1){
var statearr_39072_39139 = state_39069__$1;
(statearr_39072_39139[(1)] = (13));

} else {
var statearr_39073_39140 = state_39069__$1;
(statearr_39073_39140[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (20))){
var state_39069__$1 = state_39069;
var statearr_39074_39141 = state_39069__$1;
(statearr_39074_39141[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (27))){
var inst_39015 = (state_39069[(8)]);
var inst_39019 = inst_39015.s;
var state_39069__$1 = state_39069;
var statearr_39076_39142 = state_39069__$1;
(statearr_39076_39142[(2)] = inst_39019);

(statearr_39076_39142[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (1))){
var state_39069__$1 = state_39069;
var statearr_39077_39143 = state_39069__$1;
(statearr_39077_39143[(2)] = null);

(statearr_39077_39143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (24))){
var inst_39009 = (state_39069[(9)]);
var inst_39013 = cljs.core.first(inst_39009);
var state_39069__$1 = state_39069;
var statearr_39078_39144 = state_39069__$1;
(statearr_39078_39144[(2)] = inst_39013);

(statearr_39078_39144[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (39))){
var state_39069__$1 = state_39069;
var statearr_39079_39145 = state_39069__$1;
(statearr_39079_39145[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (4))){
var inst_38952 = (state_39069[(2)]);
var inst_38953 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_38954 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38955 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_38956 = cljs.core.PersistentHashMap.fromArrays(inst_38954,inst_38955);
var inst_38957 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_38953,inst_38956,inst_38952);
var inst_38958 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_38957);
var state_39069__$1 = state_39069;
var statearr_39081_39146 = state_39069__$1;
(statearr_39081_39146[(2)] = inst_38958);

(statearr_39081_39146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (15))){
var inst_38986 = (state_39069[(2)]);
var state_39069__$1 = state_39069;
if(cljs.core.truth_(inst_38986)){
var statearr_39082_39147 = state_39069__$1;
(statearr_39082_39147[(1)] = (16));

} else {
var statearr_39083_39148 = state_39069__$1;
(statearr_39083_39148[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (21))){
var inst_39035 = (state_39069[(2)]);
var state_39069__$1 = state_39069;
var statearr_39084_39149 = state_39069__$1;
(statearr_39084_39149[(2)] = inst_39035);

(statearr_39084_39149[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (31))){
var inst_39033 = (state_39069[(2)]);
var state_39069__$1 = state_39069;
var statearr_39085_39150 = state_39069__$1;
(statearr_39085_39150[(2)] = inst_39033);

(statearr_39085_39150[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (32))){
var inst_39039 = (state_39069[(10)]);
var inst_39041 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_39039);
var state_39069__$1 = state_39069;
var statearr_39086_39151 = state_39069__$1;
(statearr_39086_39151[(2)] = inst_39041);

(statearr_39086_39151[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (40))){
var inst_39062 = (state_39069[(2)]);
var state_39069__$1 = state_39069;
var statearr_39087_39152 = state_39069__$1;
(statearr_39087_39152[(2)] = inst_39062);

(statearr_39087_39152[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (33))){
var inst_39043 = (state_39069[(11)]);
var inst_39039 = (state_39069[(10)]);
var inst_39043__$1 = (inst_39039 == null);
var state_39069__$1 = (function (){var statearr_39088 = state_39069;
(statearr_39088[(11)] = inst_39043__$1);

return statearr_39088;
})();
if(cljs.core.truth_(inst_39043__$1)){
var statearr_39089_39153 = state_39069__$1;
(statearr_39089_39153[(1)] = (35));

} else {
var statearr_39090_39154 = state_39069__$1;
(statearr_39090_39154[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (13))){
var inst_38981 = cljs.core.first(ident);
var inst_38982 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_38981);
var inst_38983 = (inst_38982 == null);
var state_39069__$1 = state_39069;
var statearr_39091_39155 = state_39069__$1;
(statearr_39091_39155[(2)] = inst_38983);

(statearr_39091_39155[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (22))){
var inst_39009 = (state_39069[(9)]);
var inst_39008 = (state_39069[(2)]);
var inst_39009__$1 = fluree.db.util.async.throw_err(inst_39008);
var inst_39010 = (inst_39009__$1 == null);
var state_39069__$1 = (function (){var statearr_39092 = state_39069;
(statearr_39092[(9)] = inst_39009__$1);

return statearr_39092;
})();
if(cljs.core.truth_(inst_39010)){
var statearr_39093_39156 = state_39069__$1;
(statearr_39093_39156[(1)] = (23));

} else {
var statearr_39094_39157 = state_39069__$1;
(statearr_39094_39157[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (36))){
var inst_39043 = (state_39069[(11)]);
var state_39069__$1 = state_39069;
var statearr_39095_39158 = state_39069__$1;
(statearr_39095_39158[(2)] = inst_39043);

(statearr_39095_39158[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (41))){
var inst_39057 = cljs.core.async.close_BANG_(return_chan);
var state_39069__$1 = state_39069;
var statearr_39096_39159 = state_39069__$1;
(statearr_39096_39159[(2)] = inst_39057);

(statearr_39096_39159[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (43))){
var inst_39060 = (state_39069[(2)]);
var state_39069__$1 = state_39069;
var statearr_39097_39160 = state_39069__$1;
(statearr_39097_39160[(2)] = inst_39060);

(statearr_39097_39160[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (29))){
var inst_39024 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_39025 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_39024].join('');
var inst_39026 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39027 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_39028 = cljs.core.PersistentHashMap.fromArrays(inst_39026,inst_39027);
var inst_39029 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39025,inst_39028);
var inst_39030 = (function(){throw inst_39029})();
var state_39069__$1 = state_39069;
var statearr_39098_39161 = state_39069__$1;
(statearr_39098_39161[(2)] = inst_39030);

(statearr_39098_39161[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (6))){
var inst_38966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38967 = [ident];
var inst_38968 = (new cljs.core.PersistentVector(null,1,(5),inst_38966,inst_38967,null));
var inst_38969 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_38968);
var state_39069__$1 = state_39069;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39069__$1,(9),inst_38969);
} else {
if((state_val_39070 === (28))){
var inst_39021 = (state_39069[(2)]);
var state_39069__$1 = state_39069;
var statearr_39099_39162 = state_39069__$1;
(statearr_39099_39162[(2)] = inst_39021);

(statearr_39099_39162[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (25))){
var inst_39015 = (state_39069[(8)]);
var inst_39015__$1 = (state_39069[(2)]);
var inst_39016 = (inst_39015__$1 == null);
var state_39069__$1 = (function (){var statearr_39100 = state_39069;
(statearr_39100[(8)] = inst_39015__$1);

return statearr_39100;
})();
if(cljs.core.truth_(inst_39016)){
var statearr_39101_39163 = state_39069__$1;
(statearr_39101_39163[(1)] = (26));

} else {
var statearr_39102_39164 = state_39069__$1;
(statearr_39102_39164[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (34))){
var inst_39064 = (state_39069[(2)]);
var _ = (function (){var statearr_39103 = state_39069;
(statearr_39103[(4)] = cljs.core.rest((state_39069[(4)])));

return statearr_39103;
})();
var state_39069__$1 = state_39069;
var statearr_39104_39165 = state_39069__$1;
(statearr_39104_39165[(2)] = inst_39064);

(statearr_39104_39165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (17))){
var inst_38997 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_39069__$1 = state_39069;
if(inst_38997){
var statearr_39105_39166 = state_39069__$1;
(statearr_39105_39166[(1)] = (19));

} else {
var statearr_39106_39167 = state_39069__$1;
(statearr_39106_39167[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (3))){
var inst_39067 = (state_39069[(2)]);
var state_39069__$1 = state_39069;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39069__$1,inst_39067);
} else {
if((state_val_39070 === (12))){
var inst_38977 = (state_39069[(2)]);
var state_39069__$1 = state_39069;
var statearr_39107_39168 = state_39069__$1;
(statearr_39107_39168[(2)] = inst_38977);

(statearr_39107_39168[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (2))){
var _ = (function (){var statearr_39108 = state_39069;
(statearr_39108[(4)] = cljs.core.cons((5),(state_39069[(4)])));

return statearr_39108;
})();
var inst_38964 = typeof ident === 'number';
var state_39069__$1 = state_39069;
if(cljs.core.truth_(inst_38964)){
var statearr_39109_39169 = state_39069__$1;
(statearr_39109_39169[(1)] = (6));

} else {
var statearr_39110_39170 = state_39069__$1;
(statearr_39110_39170[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (23))){
var state_39069__$1 = state_39069;
var statearr_39111_39171 = state_39069__$1;
(statearr_39111_39171[(2)] = null);

(statearr_39111_39171[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (35))){
var state_39069__$1 = state_39069;
var statearr_39112_39172 = state_39069__$1;
(statearr_39112_39172[(2)] = strict_QMARK_);

(statearr_39112_39172[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (19))){
var inst_39000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39001 = cljs.core.first(ident);
var inst_39002 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_39001);
var inst_39003 = cljs.core.second(ident);
var inst_39004 = [inst_39002,inst_39003];
var inst_39005 = (new cljs.core.PersistentVector(null,2,(5),inst_39000,inst_39004,null));
var inst_39006 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_39005);
var state_39069__$1 = state_39069;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39069__$1,(22),inst_39006);
} else {
if((state_val_39070 === (11))){
var state_39069__$1 = state_39069;
var statearr_39114_39173 = state_39069__$1;
(statearr_39114_39173[(2)] = null);

(statearr_39114_39173[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (9))){
var inst_38971 = (state_39069[(2)]);
var inst_38972 = fluree.db.util.async.throw_err(inst_38971);
var inst_38973 = cljs.core.not_empty(inst_38972);
var state_39069__$1 = state_39069;
if(cljs.core.truth_(inst_38973)){
var statearr_39115_39174 = state_39069__$1;
(statearr_39115_39174[(1)] = (10));

} else {
var statearr_39116_39175 = state_39069__$1;
(statearr_39116_39175[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (5))){
var _ = (function (){var statearr_39117 = state_39069;
(statearr_39117[(4)] = cljs.core.rest((state_39069[(4)])));

return statearr_39117;
})();
var state_39069__$1 = state_39069;
var ex39113 = (state_39069__$1[(2)]);
var statearr_39118_39176 = state_39069__$1;
(statearr_39118_39176[(5)] = ex39113);


var statearr_39119_39177 = state_39069__$1;
(statearr_39119_39177[(1)] = (4));

(statearr_39119_39177[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (14))){
var inst_38979 = (state_39069[(7)]);
var state_39069__$1 = state_39069;
var statearr_39120_39178 = state_39069__$1;
(statearr_39120_39178[(2)] = inst_38979);

(statearr_39120_39178[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (26))){
var state_39069__$1 = state_39069;
var statearr_39121_39179 = state_39069__$1;
(statearr_39121_39179[(2)] = null);

(statearr_39121_39179[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (16))){
var inst_38988 = cljs.core.first(ident);
var inst_38989 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38988], 0));
var inst_38990 = ["Subject ID lookup failed. The predicate ",inst_38989," does not exist."].join('');
var inst_38991 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38992 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_38993 = cljs.core.PersistentHashMap.fromArrays(inst_38991,inst_38992);
var inst_38994 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38990,inst_38993);
var inst_38995 = (function(){throw inst_38994})();
var state_39069__$1 = state_39069;
var statearr_39122_39180 = state_39069__$1;
(statearr_39122_39180[(2)] = inst_38995);

(statearr_39122_39180[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (38))){
var inst_39049 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_39050 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39051 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_39052 = cljs.core.PersistentHashMap.fromArrays(inst_39050,inst_39051);
var inst_39053 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39049,inst_39052);
var inst_39054 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_39053);
var state_39069__$1 = state_39069;
var statearr_39123_39181 = state_39069__$1;
(statearr_39123_39181[(2)] = inst_39054);

(statearr_39123_39181[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (30))){
var state_39069__$1 = state_39069;
var statearr_39124_39182 = state_39069__$1;
(statearr_39124_39182[(2)] = null);

(statearr_39124_39182[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (10))){
var state_39069__$1 = state_39069;
var statearr_39125_39183 = state_39069__$1;
(statearr_39125_39183[(2)] = ident);

(statearr_39125_39183[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (18))){
var inst_39037 = (state_39069[(2)]);
var state_39069__$1 = state_39069;
var statearr_39126_39184 = state_39069__$1;
(statearr_39126_39184[(2)] = inst_39037);

(statearr_39126_39184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (42))){
var state_39069__$1 = state_39069;
var statearr_39127_39185 = state_39069__$1;
(statearr_39127_39185[(2)] = null);

(statearr_39127_39185[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (37))){
var inst_39047 = (state_39069[(2)]);
var state_39069__$1 = state_39069;
if(cljs.core.truth_(inst_39047)){
var statearr_39128_39186 = state_39069__$1;
(statearr_39128_39186[(1)] = (38));

} else {
var statearr_39129_39187 = state_39069__$1;
(statearr_39129_39187[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39070 === (8))){
var inst_39039 = (state_39069[(10)]);
var inst_39039__$1 = (state_39069[(2)]);
var state_39069__$1 = (function (){var statearr_39130 = state_39069;
(statearr_39130[(10)] = inst_39039__$1);

return statearr_39130;
})();
if(cljs.core.truth_(inst_39039__$1)){
var statearr_39131_39188 = state_39069__$1;
(statearr_39131_39188[(1)] = (32));

} else {
var statearr_39132_39189 = state_39069__$1;
(statearr_39132_39189[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__11438__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__11438__auto____0 = (function (){
var statearr_39133 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39133[(0)] = fluree$db$graphdb$subid_$_state_machine__11438__auto__);

(statearr_39133[(1)] = (1));

return statearr_39133;
});
var fluree$db$graphdb$subid_$_state_machine__11438__auto____1 = (function (state_39069){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_39069);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e39134){var ex__11441__auto__ = e39134;
var statearr_39135_39190 = state_39069;
(statearr_39135_39190[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_39069[(4)]))){
var statearr_39136_39191 = state_39069;
(statearr_39136_39191[(1)] = cljs.core.first((state_39069[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39192 = state_39069;
state_39069 = G__39192;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__11438__auto__ = function(state_39069){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__11438__auto____1.call(this,state_39069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__11438__auto____0;
fluree$db$graphdb$subid_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__11438__auto____1;
return fluree$db$graphdb$subid_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_39137 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_39137[(6)] = c__11512__auto___39138);

return statearr_39137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__39193){
var map__39194 = p__39193;
var map__39194__$1 = cljs.core.__destructure_map(map__39194);
var db = map__39194__$1;
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39194__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39194__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_39210){
var state_val_39211 = (state_39210[(1)]);
if((state_val_39211 === (1))){
var state_39210__$1 = state_39210;
var statearr_39212_39226 = state_39210__$1;
(statearr_39212_39226[(2)] = null);

(statearr_39212_39226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39211 === (2))){
var _ = (function (){var statearr_39213 = state_39210;
(statearr_39213[(4)] = cljs.core.cons((5),(state_39210[(4)])));

return statearr_39213;
})();
var inst_39201 = (current_db_fn.cljs$core$IFn$_invoke$arity$1 ? current_db_fn.cljs$core$IFn$_invoke$arity$1(db) : current_db_fn.call(null,db));
var state_39210__$1 = state_39210;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39210__$1,(6),inst_39201);
} else {
if((state_val_39211 === (3))){
var inst_39208 = (state_39210[(2)]);
var state_39210__$1 = state_39210;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39210__$1,inst_39208);
} else {
if((state_val_39211 === (4))){
var inst_39195 = (state_39210[(2)]);
var state_39210__$1 = state_39210;
var statearr_39215_39227 = state_39210__$1;
(statearr_39215_39227[(2)] = inst_39195);

(statearr_39215_39227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39211 === (5))){
var _ = (function (){var statearr_39216 = state_39210;
(statearr_39216[(4)] = cljs.core.rest((state_39210[(4)])));

return statearr_39216;
})();
var state_39210__$1 = state_39210;
var ex39214 = (state_39210__$1[(2)]);
var statearr_39217_39228 = state_39210__$1;
(statearr_39217_39228[(5)] = ex39214);


if((ex39214 instanceof Error)){
var statearr_39218_39229 = state_39210__$1;
(statearr_39218_39229[(1)] = (4));

(statearr_39218_39229[(5)] = null);

} else {
throw ex39214;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39211 === (6))){
var inst_39203 = (state_39210[(2)]);
var inst_39204 = fluree.db.util.async.throw_err(inst_39203);
var inst_39205 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39204,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_39219 = state_39210;
(statearr_39219[(4)] = cljs.core.rest((state_39210[(4)])));

return statearr_39219;
})();
var state_39210__$1 = state_39210;
var statearr_39220_39230 = state_39210__$1;
(statearr_39220_39230[(2)] = inst_39205);

(statearr_39220_39230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__11438__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__11438__auto____0 = (function (){
var statearr_39221 = [null,null,null,null,null,null,null];
(statearr_39221[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__11438__auto__);

(statearr_39221[(1)] = (1));

return statearr_39221;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__11438__auto____1 = (function (state_39210){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_39210);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e39222){var ex__11441__auto__ = e39222;
var statearr_39223_39231 = state_39210;
(statearr_39223_39231[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_39210[(4)]))){
var statearr_39224_39232 = state_39210;
(statearr_39224_39232[(1)] = cljs.core.first((state_39210[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39233 = state_39210;
state_39210 = G__39233;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__11438__auto__ = function(state_39210){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__11438__auto____1.call(this,state_39210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__11438__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__11438__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_39225 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_39225[(6)] = c__11512__auto__);

return statearr_39225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__39234,property,collection){
var map__39235 = p__39234;
var map__39235__$1 = cljs.core.__destructure_map(map__39235);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39235__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__39236 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__39236.cljs$core$IFn$_invoke$arity$1 ? fexpr__39236.cljs$core$IFn$_invoke$arity$1(property) : fexpr__39236.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__39237,property,predicate){
var map__39238 = p__39237;
var map__39238__$1 = cljs.core.__destructure_map(map__39238);
var this$ = map__39238__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39238__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__39239 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__39239.cljs$core$IFn$_invoke$arity$1 ? fexpr__39239.cljs$core$IFn$_invoke$arity$1(property) : fexpr__39239.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__39240 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop(this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__39240);
} else {
return G__39240;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__39242 = arguments.length;
switch (G__39242) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_39274){
var state_val_39275 = (state_39274[(1)]);
if((state_val_39275 === (7))){
var state_39274__$1 = state_39274;
var statearr_39276_39370 = state_39274__$1;
(statearr_39276_39370[(2)] = null);

(statearr_39276_39370[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39275 === (1))){
var state_39274__$1 = state_39274;
var statearr_39277_39371 = state_39274__$1;
(statearr_39277_39371[(2)] = null);

(statearr_39277_39371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39275 === (4))){
var inst_39243 = (state_39274[(2)]);
var state_39274__$1 = state_39274;
var statearr_39278_39372 = state_39274__$1;
(statearr_39278_39372[(2)] = inst_39243);

(statearr_39278_39372[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39275 === (6))){
var inst_39257 = (state_39274[(7)]);
var inst_39256 = (state_39274[(2)]);
var inst_39257__$1 = fluree.db.util.async.throw_err(inst_39256);
var inst_39258 = (inst_39257__$1 == null);
var state_39274__$1 = (function (){var statearr_39279 = state_39274;
(statearr_39279[(7)] = inst_39257__$1);

return statearr_39279;
})();
if(cljs.core.truth_(inst_39258)){
var statearr_39280_39373 = state_39274__$1;
(statearr_39280_39373[(1)] = (7));

} else {
var statearr_39281_39374 = state_39274__$1;
(statearr_39281_39374[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39275 === (3))){
var inst_39272 = (state_39274[(2)]);
var state_39274__$1 = state_39274;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39274__$1,inst_39272);
} else {
if((state_val_39275 === (12))){
var inst_39269 = (state_39274[(2)]);
var _ = (function (){var statearr_39282 = state_39274;
(statearr_39282[(4)] = cljs.core.rest((state_39274[(4)])));

return statearr_39282;
})();
var state_39274__$1 = state_39274;
var statearr_39283_39375 = state_39274__$1;
(statearr_39283_39375[(2)] = inst_39269);

(statearr_39283_39375[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39275 === (2))){
var _ = (function (){var statearr_39284 = state_39274;
(statearr_39284[(4)] = cljs.core.cons((5),(state_39274[(4)])));

return statearr_39284;
})();
var inst_39250 = fluree.db.dbproto._rootdb(this$);
var inst_39251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39252 = [tag_id,(30)];
var inst_39253 = (new cljs.core.PersistentVector(null,2,(5),inst_39251,inst_39252,null));
var inst_39254 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_39250,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_39253);
var state_39274__$1 = state_39274;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39274__$1,(6),inst_39254);
} else {
if((state_val_39275 === (11))){
var inst_39263 = (state_39274[(8)]);
var inst_39267 = inst_39263.o;
var state_39274__$1 = state_39274;
var statearr_39286_39376 = state_39274__$1;
(statearr_39286_39376[(2)] = inst_39267);

(statearr_39286_39376[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39275 === (9))){
var inst_39263 = (state_39274[(8)]);
var inst_39263__$1 = (state_39274[(2)]);
var inst_39264 = (inst_39263__$1 == null);
var state_39274__$1 = (function (){var statearr_39287 = state_39274;
(statearr_39287[(8)] = inst_39263__$1);

return statearr_39287;
})();
if(cljs.core.truth_(inst_39264)){
var statearr_39288_39377 = state_39274__$1;
(statearr_39288_39377[(1)] = (10));

} else {
var statearr_39289_39378 = state_39274__$1;
(statearr_39289_39378[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39275 === (5))){
var _ = (function (){var statearr_39290 = state_39274;
(statearr_39290[(4)] = cljs.core.rest((state_39274[(4)])));

return statearr_39290;
})();
var state_39274__$1 = state_39274;
var ex39285 = (state_39274__$1[(2)]);
var statearr_39291_39379 = state_39274__$1;
(statearr_39291_39379[(5)] = ex39285);


if((ex39285 instanceof Error)){
var statearr_39292_39380 = state_39274__$1;
(statearr_39292_39380[(1)] = (4));

(statearr_39292_39380[(5)] = null);

} else {
throw ex39285;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39275 === (10))){
var state_39274__$1 = state_39274;
var statearr_39293_39381 = state_39274__$1;
(statearr_39293_39381[(2)] = null);

(statearr_39293_39381[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39275 === (8))){
var inst_39257 = (state_39274[(7)]);
var inst_39261 = cljs.core.first(inst_39257);
var state_39274__$1 = state_39274;
var statearr_39294_39382 = state_39274__$1;
(statearr_39294_39382[(2)] = inst_39261);

(statearr_39294_39382[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__11438__auto__ = null;
var fluree$db$graphdb$state_machine__11438__auto____0 = (function (){
var statearr_39295 = [null,null,null,null,null,null,null,null,null];
(statearr_39295[(0)] = fluree$db$graphdb$state_machine__11438__auto__);

(statearr_39295[(1)] = (1));

return statearr_39295;
});
var fluree$db$graphdb$state_machine__11438__auto____1 = (function (state_39274){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_39274);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e39296){var ex__11441__auto__ = e39296;
var statearr_39297_39383 = state_39274;
(statearr_39297_39383[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_39274[(4)]))){
var statearr_39298_39384 = state_39274;
(statearr_39298_39384[(1)] = cljs.core.first((state_39274[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39385 = state_39274;
state_39274 = G__39385;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__11438__auto__ = function(state_39274){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__11438__auto____1.call(this,state_39274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__11438__auto____0;
fluree$db$graphdb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__11438__auto____1;
return fluree$db$graphdb$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_39299 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_39299[(6)] = c__11512__auto__);

return statearr_39299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_39335){
var state_val_39336 = (state_39335[(1)]);
if((state_val_39336 === (7))){
var inst_39309 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_39335__$1 = state_39335;
var statearr_39337_39386 = state_39335__$1;
(statearr_39337_39386[(2)] = inst_39309);

(statearr_39337_39386[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39336 === (1))){
var state_39335__$1 = state_39335;
var statearr_39338_39387 = state_39335__$1;
(statearr_39338_39387[(2)] = null);

(statearr_39338_39387[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39336 === (4))){
var inst_39300 = (state_39335[(2)]);
var state_39335__$1 = state_39335;
var statearr_39339_39388 = state_39335__$1;
(statearr_39339_39388[(2)] = inst_39300);

(statearr_39339_39388[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39336 === (15))){
var inst_39330 = (state_39335[(2)]);
var _ = (function (){var statearr_39340 = state_39335;
(statearr_39340[(4)] = cljs.core.rest((state_39335[(4)])));

return statearr_39340;
})();
var state_39335__$1 = state_39335;
var statearr_39341_39389 = state_39335__$1;
(statearr_39341_39389[(2)] = inst_39330);

(statearr_39341_39389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39336 === (13))){
var inst_39315 = (state_39335[(7)]);
var inst_39321 = clojure.string.includes_QMARK_(inst_39315,":");
var state_39335__$1 = state_39335;
if(inst_39321){
var statearr_39342_39390 = state_39335__$1;
(statearr_39342_39390[(1)] = (16));

} else {
var statearr_39343_39391 = state_39335__$1;
(statearr_39343_39391[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39336 === (6))){
var state_39335__$1 = state_39335;
var statearr_39344_39392 = state_39335__$1;
(statearr_39344_39392[(2)] = pred);

(statearr_39344_39392[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39336 === (17))){
var inst_39315 = (state_39335[(7)]);
var state_39335__$1 = state_39335;
var statearr_39345_39393 = state_39335__$1;
(statearr_39345_39393[(2)] = inst_39315);

(statearr_39345_39393[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39336 === (3))){
var inst_39333 = (state_39335[(2)]);
var state_39335__$1 = state_39335;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39335__$1,inst_39333);
} else {
if((state_val_39336 === (12))){
var inst_39319 = (state_39335[(2)]);
var state_39335__$1 = state_39335;
if(cljs.core.truth_(inst_39319)){
var statearr_39346_39394 = state_39335__$1;
(statearr_39346_39394[(1)] = (13));

} else {
var statearr_39347_39395 = state_39335__$1;
(statearr_39347_39395[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39336 === (2))){
var _ = (function (){var statearr_39348 = state_39335;
(statearr_39348[(4)] = cljs.core.cons((5),(state_39335[(4)])));

return statearr_39348;
})();
var inst_39306 = typeof pred === 'string';
var state_39335__$1 = state_39335;
if(cljs.core.truth_(inst_39306)){
var statearr_39349_39396 = state_39335__$1;
(statearr_39349_39396[(1)] = (6));

} else {
var statearr_39350_39397 = state_39335__$1;
(statearr_39350_39397[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39336 === (11))){
var inst_39311 = (state_39335[(8)]);
var state_39335__$1 = state_39335;
var statearr_39352_39398 = state_39335__$1;
(statearr_39352_39398[(2)] = inst_39311);

(statearr_39352_39398[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39336 === (9))){
var inst_39311 = (state_39335[(8)]);
var inst_39314 = (state_39335[(2)]);
var inst_39315 = fluree.db.util.async.throw_err(inst_39314);
var state_39335__$1 = (function (){var statearr_39353 = state_39335;
(statearr_39353[(7)] = inst_39315);

return statearr_39353;
})();
if(cljs.core.truth_(inst_39311)){
var statearr_39354_39399 = state_39335__$1;
(statearr_39354_39399[(1)] = (10));

} else {
var statearr_39355_39400 = state_39335__$1;
(statearr_39355_39400[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39336 === (5))){
var _ = (function (){var statearr_39356 = state_39335;
(statearr_39356[(4)] = cljs.core.rest((state_39335[(4)])));

return statearr_39356;
})();
var state_39335__$1 = state_39335;
var ex39351 = (state_39335__$1[(2)]);
var statearr_39357_39401 = state_39335__$1;
(statearr_39357_39401[(5)] = ex39351);


if((ex39351 instanceof Error)){
var statearr_39358_39402 = state_39335__$1;
(statearr_39358_39402[(1)] = (4));

(statearr_39358_39402[(5)] = null);

} else {
throw ex39351;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39336 === (14))){
var state_39335__$1 = state_39335;
var statearr_39359_39403 = state_39335__$1;
(statearr_39359_39403[(2)] = null);

(statearr_39359_39403[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39336 === (16))){
var inst_39315 = (state_39335[(7)]);
var inst_39323 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_39315,/:/);
var inst_39324 = cljs.core.second(inst_39323);
var state_39335__$1 = state_39335;
var statearr_39360_39404 = state_39335__$1;
(statearr_39360_39404[(2)] = inst_39324);

(statearr_39360_39404[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39336 === (10))){
var inst_39315 = (state_39335[(7)]);
var state_39335__$1 = state_39335;
var statearr_39361_39405 = state_39335__$1;
(statearr_39361_39405[(2)] = inst_39315);

(statearr_39361_39405[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39336 === (18))){
var inst_39327 = (state_39335[(2)]);
var state_39335__$1 = state_39335;
var statearr_39362_39406 = state_39335__$1;
(statearr_39362_39406[(2)] = inst_39327);

(statearr_39362_39406[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39336 === (8))){
var inst_39311 = (state_39335[(2)]);
var inst_39312 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_39335__$1 = (function (){var statearr_39363 = state_39335;
(statearr_39363[(8)] = inst_39311);

return statearr_39363;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39335__$1,(9),inst_39312);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__11438__auto__ = null;
var fluree$db$graphdb$state_machine__11438__auto____0 = (function (){
var statearr_39364 = [null,null,null,null,null,null,null,null,null];
(statearr_39364[(0)] = fluree$db$graphdb$state_machine__11438__auto__);

(statearr_39364[(1)] = (1));

return statearr_39364;
});
var fluree$db$graphdb$state_machine__11438__auto____1 = (function (state_39335){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_39335);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e39365){var ex__11441__auto__ = e39365;
var statearr_39366_39407 = state_39335;
(statearr_39366_39407[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_39335[(4)]))){
var statearr_39367_39408 = state_39335;
(statearr_39367_39408[(1)] = cljs.core.first((state_39335[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39409 = state_39335;
state_39335 = G__39409;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__11438__auto__ = function(state_39335){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__11438__auto____1.call(this,state_39335);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__11438__auto____0;
fluree$db$graphdb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__11438__auto____1;
return fluree$db$graphdb$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_39368 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_39368[(6)] = c__11512__auto__);

return statearr_39368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__39411 = arguments.length;
switch (G__39411) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_39444){
var state_val_39445 = (state_39444[(1)]);
if((state_val_39445 === (7))){
var state_39444__$1 = state_39444;
var statearr_39446_39534 = state_39444__$1;
(statearr_39446_39534[(2)] = null);

(statearr_39446_39534[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39445 === (1))){
var state_39444__$1 = state_39444;
var statearr_39447_39535 = state_39444__$1;
(statearr_39447_39535[(2)] = null);

(statearr_39447_39535[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39445 === (4))){
var inst_39412 = (state_39444[(2)]);
var state_39444__$1 = state_39444;
var statearr_39448_39536 = state_39444__$1;
(statearr_39448_39536[(2)] = inst_39412);

(statearr_39448_39536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39445 === (6))){
var inst_39427 = (state_39444[(7)]);
var inst_39426 = (state_39444[(2)]);
var inst_39427__$1 = fluree.db.util.async.throw_err(inst_39426);
var inst_39428 = (inst_39427__$1 == null);
var state_39444__$1 = (function (){var statearr_39449 = state_39444;
(statearr_39449[(7)] = inst_39427__$1);

return statearr_39449;
})();
if(cljs.core.truth_(inst_39428)){
var statearr_39450_39537 = state_39444__$1;
(statearr_39450_39537[(1)] = (7));

} else {
var statearr_39451_39538 = state_39444__$1;
(statearr_39451_39538[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39445 === (3))){
var inst_39442 = (state_39444[(2)]);
var state_39444__$1 = state_39444;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39444__$1,inst_39442);
} else {
if((state_val_39445 === (12))){
var inst_39439 = (state_39444[(2)]);
var _ = (function (){var statearr_39452 = state_39444;
(statearr_39452[(4)] = cljs.core.rest((state_39444[(4)])));

return statearr_39452;
})();
var state_39444__$1 = state_39444;
var statearr_39453_39539 = state_39444__$1;
(statearr_39453_39539[(2)] = inst_39439);

(statearr_39453_39539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39445 === (2))){
var _ = (function (){var statearr_39454 = state_39444;
(statearr_39454[(4)] = cljs.core.cons((5),(state_39444[(4)])));

return statearr_39454;
})();
var inst_39418 = (30);
var inst_39420 = fluree.db.dbproto._rootdb(this$);
var inst_39421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39422 = [inst_39418,tag_name];
var inst_39423 = (new cljs.core.PersistentVector(null,2,(5),inst_39421,inst_39422,null));
var inst_39424 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_39420,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_39423);
var state_39444__$1 = state_39444;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39444__$1,(6),inst_39424);
} else {
if((state_val_39445 === (11))){
var inst_39433 = (state_39444[(8)]);
var inst_39437 = inst_39433.s;
var state_39444__$1 = state_39444;
var statearr_39456_39540 = state_39444__$1;
(statearr_39456_39540[(2)] = inst_39437);

(statearr_39456_39540[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39445 === (9))){
var inst_39433 = (state_39444[(8)]);
var inst_39433__$1 = (state_39444[(2)]);
var inst_39434 = (inst_39433__$1 == null);
var state_39444__$1 = (function (){var statearr_39457 = state_39444;
(statearr_39457[(8)] = inst_39433__$1);

return statearr_39457;
})();
if(cljs.core.truth_(inst_39434)){
var statearr_39458_39541 = state_39444__$1;
(statearr_39458_39541[(1)] = (10));

} else {
var statearr_39459_39542 = state_39444__$1;
(statearr_39459_39542[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39445 === (5))){
var _ = (function (){var statearr_39460 = state_39444;
(statearr_39460[(4)] = cljs.core.rest((state_39444[(4)])));

return statearr_39460;
})();
var state_39444__$1 = state_39444;
var ex39455 = (state_39444__$1[(2)]);
var statearr_39461_39543 = state_39444__$1;
(statearr_39461_39543[(5)] = ex39455);


if((ex39455 instanceof Error)){
var statearr_39462_39544 = state_39444__$1;
(statearr_39462_39544[(1)] = (4));

(statearr_39462_39544[(5)] = null);

} else {
throw ex39455;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39445 === (10))){
var state_39444__$1 = state_39444;
var statearr_39463_39545 = state_39444__$1;
(statearr_39463_39545[(2)] = null);

(statearr_39463_39545[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39445 === (8))){
var inst_39427 = (state_39444[(7)]);
var inst_39431 = cljs.core.first(inst_39427);
var state_39444__$1 = state_39444;
var statearr_39464_39546 = state_39444__$1;
(statearr_39464_39546[(2)] = inst_39431);

(statearr_39464_39546[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__11438__auto__ = null;
var fluree$db$graphdb$state_machine__11438__auto____0 = (function (){
var statearr_39465 = [null,null,null,null,null,null,null,null,null];
(statearr_39465[(0)] = fluree$db$graphdb$state_machine__11438__auto__);

(statearr_39465[(1)] = (1));

return statearr_39465;
});
var fluree$db$graphdb$state_machine__11438__auto____1 = (function (state_39444){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_39444);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e39466){var ex__11441__auto__ = e39466;
var statearr_39467_39547 = state_39444;
(statearr_39467_39547[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_39444[(4)]))){
var statearr_39468_39548 = state_39444;
(statearr_39468_39548[(1)] = cljs.core.first((state_39444[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39549 = state_39444;
state_39444 = G__39549;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__11438__auto__ = function(state_39444){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__11438__auto____1.call(this,state_39444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__11438__auto____0;
fluree$db$graphdb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__11438__auto____1;
return fluree$db$graphdb$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_39469 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_39469[(6)] = c__11512__auto__);

return statearr_39469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_39504){
var state_val_39505 = (state_39504[(1)]);
if((state_val_39505 === (7))){
var inst_39483 = typeof pred === 'string';
var state_39504__$1 = state_39504;
if(cljs.core.truth_(inst_39483)){
var statearr_39506_39550 = state_39504__$1;
(statearr_39506_39550[(1)] = (10));

} else {
var statearr_39507_39551 = state_39504__$1;
(statearr_39507_39551[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39505 === (1))){
var state_39504__$1 = state_39504;
var statearr_39508_39552 = state_39504__$1;
(statearr_39508_39552[(2)] = null);

(statearr_39508_39552[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39505 === (4))){
var inst_39470 = (state_39504[(2)]);
var state_39504__$1 = state_39504;
var statearr_39509_39553 = state_39504__$1;
(statearr_39509_39553[(2)] = inst_39470);

(statearr_39509_39553[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39505 === (15))){
var inst_39497 = (state_39504[(2)]);
var state_39504__$1 = state_39504;
var statearr_39510_39554 = state_39504__$1;
(statearr_39510_39554[(2)] = inst_39497);

(statearr_39510_39554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39505 === (13))){
var inst_39488 = (state_39504[(7)]);
var inst_39490 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39488),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_39491 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_39490);
var state_39504__$1 = state_39504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39504__$1,(16),inst_39491);
} else {
if((state_val_39505 === (6))){
var inst_39478 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_39504__$1 = state_39504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39504__$1,(9),inst_39478);
} else {
if((state_val_39505 === (3))){
var inst_39502 = (state_39504[(2)]);
var state_39504__$1 = state_39504;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39504__$1,inst_39502);
} else {
if((state_val_39505 === (12))){
var inst_39488 = (state_39504[(7)]);
var inst_39488__$1 = (state_39504[(2)]);
var state_39504__$1 = (function (){var statearr_39511 = state_39504;
(statearr_39511[(7)] = inst_39488__$1);

return statearr_39511;
})();
if(cljs.core.truth_(inst_39488__$1)){
var statearr_39512_39555 = state_39504__$1;
(statearr_39512_39555[(1)] = (13));

} else {
var statearr_39513_39556 = state_39504__$1;
(statearr_39513_39556[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39505 === (2))){
var _ = (function (){var statearr_39514 = state_39504;
(statearr_39514[(4)] = cljs.core.cons((5),(state_39504[(4)])));

return statearr_39514;
})();
var inst_39476 = clojure.string.includes_QMARK_(tag_name,"/");
var state_39504__$1 = state_39504;
if(inst_39476){
var statearr_39515_39557 = state_39504__$1;
(statearr_39515_39557[(1)] = (6));

} else {
var statearr_39516_39558 = state_39504__$1;
(statearr_39516_39558[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39505 === (11))){
var inst_39486 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_39504__$1 = state_39504;
var statearr_39518_39559 = state_39504__$1;
(statearr_39518_39559[(2)] = inst_39486);

(statearr_39518_39559[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39505 === (9))){
var inst_39480 = (state_39504[(2)]);
var inst_39481 = fluree.db.util.async.throw_err(inst_39480);
var state_39504__$1 = state_39504;
var statearr_39519_39560 = state_39504__$1;
(statearr_39519_39560[(2)] = inst_39481);

(statearr_39519_39560[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39505 === (5))){
var _ = (function (){var statearr_39520 = state_39504;
(statearr_39520[(4)] = cljs.core.rest((state_39504[(4)])));

return statearr_39520;
})();
var state_39504__$1 = state_39504;
var ex39517 = (state_39504__$1[(2)]);
var statearr_39521_39561 = state_39504__$1;
(statearr_39521_39561[(5)] = ex39517);


if((ex39517 instanceof Error)){
var statearr_39522_39562 = state_39504__$1;
(statearr_39522_39562[(1)] = (4));

(statearr_39522_39562[(5)] = null);

} else {
throw ex39517;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39505 === (14))){
var state_39504__$1 = state_39504;
var statearr_39523_39563 = state_39504__$1;
(statearr_39523_39563[(2)] = null);

(statearr_39523_39563[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39505 === (16))){
var inst_39493 = (state_39504[(2)]);
var inst_39494 = fluree.db.util.async.throw_err(inst_39493);
var state_39504__$1 = state_39504;
var statearr_39524_39564 = state_39504__$1;
(statearr_39524_39564[(2)] = inst_39494);

(statearr_39524_39564[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39505 === (10))){
var state_39504__$1 = state_39504;
var statearr_39525_39565 = state_39504__$1;
(statearr_39525_39565[(2)] = pred);

(statearr_39525_39565[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39505 === (8))){
var inst_39499 = (state_39504[(2)]);
var _ = (function (){var statearr_39526 = state_39504;
(statearr_39526[(4)] = cljs.core.rest((state_39504[(4)])));

return statearr_39526;
})();
var state_39504__$1 = state_39504;
var statearr_39527_39566 = state_39504__$1;
(statearr_39527_39566[(2)] = inst_39499);

(statearr_39527_39566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__11438__auto__ = null;
var fluree$db$graphdb$state_machine__11438__auto____0 = (function (){
var statearr_39528 = [null,null,null,null,null,null,null,null];
(statearr_39528[(0)] = fluree$db$graphdb$state_machine__11438__auto__);

(statearr_39528[(1)] = (1));

return statearr_39528;
});
var fluree$db$graphdb$state_machine__11438__auto____1 = (function (state_39504){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_39504);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e39529){var ex__11441__auto__ = e39529;
var statearr_39530_39567 = state_39504;
(statearr_39530_39567[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_39504[(4)]))){
var statearr_39531_39568 = state_39504;
(statearr_39531_39568[(1)] = cljs.core.first((state_39504[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39569 = state_39504;
state_39504 = G__39569;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__11438__auto__ = function(state_39504){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__11438__auto____1.call(this,state_39504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__11438__auto____0;
fluree$db$graphdb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__11438__auto____1;
return fluree$db$graphdb$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_39532 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_39532[(6)] = c__11512__auto__);

return statearr_39532;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k39571,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__39575 = k39571;
var G__39575__$1 = (((G__39575 instanceof cljs.core.Keyword))?G__39575.fqn:null);
switch (G__39575__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39571,else__5345__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5365__auto__,p__39576){
var vec__39577 = p__39576;
var k__5366__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39577,(0),null);
var v__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39577,(1),null);
return (f__5363__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5363__auto__.cljs$core$IFn$_invoke$arity$3(ret__5365__auto__,k__5366__auto__,v__5367__auto__) : f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__));
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer(writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer(writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__5359__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39570){
var self__ = this;
var G__39570__$1 = this;
return (new cljs.core.RecordIter((0),G__39570__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__39580 = (function (coll__5339__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__5339__auto__));
});
return fexpr__39580(this__5338__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this39572,other39573){
var self__ = this;
var this39572__$1 = this;
return (((!((other39573 == null)))) && ((((this39572__$1.constructor === other39573.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.conn,other39573.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.network,other39573.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.dbid,other39573.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.block,other39573.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.t,other39573.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.tt_id,other39573.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.stats,other39573.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.spot,other39573.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.psot,other39573.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.post,other39573.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.opst,other39573.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.schema,other39573.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.settings,other39573.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.index_configs,other39573.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.schema_cache,other39573.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.novelty,other39573.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.permissions,other39573.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.fork,other39573.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.fork_block,other39573.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.current_db_fn,other39573.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39572__$1.__extmap,other39573.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5353__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k39571){
var self__ = this;
var this__5349__auto____$1 = this;
var G__39581 = k39571;
var G__39581__$1 = (((G__39581 instanceof cljs.core.Keyword))?G__39581.fqn:null);
switch (G__39581__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k39571);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__39570){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__39582 = cljs.core.keyword_identical_QMARK_;
var expr__39583 = k__5351__auto__;
if(cljs.core.truth_((function (){var G__39585 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__39586 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39585,G__39586) : pred__39582.call(null,G__39585,G__39586));
})())){
return (new fluree.db.graphdb.GraphDb(G__39570,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39587 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__39588 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39587,G__39588) : pred__39582.call(null,G__39587,G__39588));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__39570,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39589 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__39590 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39589,G__39590) : pred__39582.call(null,G__39589,G__39590));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__39570,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39591 = new cljs.core.Keyword(null,"block","block",664686210);
var G__39592 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39591,G__39592) : pred__39582.call(null,G__39591,G__39592));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__39570,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39593 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__39594 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39593,G__39594) : pred__39582.call(null,G__39593,G__39594));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__39570,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39595 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__39596 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39595,G__39596) : pred__39582.call(null,G__39595,G__39596));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__39570,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39597 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__39598 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39597,G__39598) : pred__39582.call(null,G__39597,G__39598));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__39570,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39599 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__39600 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39599,G__39600) : pred__39582.call(null,G__39599,G__39600));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__39570,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39601 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__39602 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39601,G__39602) : pred__39582.call(null,G__39601,G__39602));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__39570,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39603 = new cljs.core.Keyword(null,"post","post",269697687);
var G__39604 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39603,G__39604) : pred__39582.call(null,G__39603,G__39604));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__39570,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39605 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__39606 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39605,G__39606) : pred__39582.call(null,G__39605,G__39606));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__39570,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39607 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__39608 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39607,G__39608) : pred__39582.call(null,G__39607,G__39608));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__39570,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39609 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__39610 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39609,G__39610) : pred__39582.call(null,G__39609,G__39610));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__39570,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39611 = new cljs.core.Keyword(null,"index-configs","index-configs",1053959280);
var G__39612 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39611,G__39612) : pred__39582.call(null,G__39611,G__39612));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__39570,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39613 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__39614 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39613,G__39614) : pred__39582.call(null,G__39613,G__39614));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__39570,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39615 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__39616 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39615,G__39616) : pred__39582.call(null,G__39615,G__39616));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__39570,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39617 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__39618 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39617,G__39618) : pred__39582.call(null,G__39617,G__39618));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__39570,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39619 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__39620 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39619,G__39620) : pred__39582.call(null,G__39619,G__39620));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__39570,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39621 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__39622 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39621,G__39622) : pred__39582.call(null,G__39621,G__39622));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__39570,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39623 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__39624 = expr__39583;
return (pred__39582.cljs$core$IFn$_invoke$arity$2 ? pred__39582.cljs$core$IFn$_invoke$arity$2(G__39623,G__39624) : pred__39582.call(null,G__39623,G__39624));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__39570,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5351__auto__,G__39570),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__39570){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__39570,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write(writer__5389__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__39574){
var extmap__5384__auto__ = (function (){var G__39625 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39574,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__39574)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__39625);
} else {
return G__39625;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__39574),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__39574),null,cljs.core.not_empty(extmap__5384__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
