// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__30400 = arguments.length;
switch (G__30400) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis(),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__30403 = arguments.length;
switch (G__30403) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11512__auto___30456 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_30434){
var state_val_30435 = (state_30434[(1)]);
if((state_val_30435 === (1))){
var state_30434__$1 = state_30434;
var statearr_30436_30457 = state_30434__$1;
(statearr_30436_30457[(2)] = null);

(statearr_30436_30457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (2))){
var _ = (function (){var statearr_30437 = state_30434;
(statearr_30437[(4)] = cljs.core.cons((5),(state_30434[(4)])));

return statearr_30437;
})();
var inst_30411 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_30434__$1 = state_30434;
if(cljs.core.truth_(inst_30411)){
var statearr_30438_30458 = state_30434__$1;
(statearr_30438_30458[(1)] = (6));

} else {
var statearr_30439_30459 = state_30434__$1;
(statearr_30439_30459[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (3))){
var inst_30432 = (state_30434[(2)]);
var state_30434__$1 = state_30434;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30434__$1,inst_30432);
} else {
if((state_val_30435 === (4))){
var inst_30404 = (state_30434[(2)]);
var inst_30405 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_30404);
var state_30434__$1 = state_30434;
var statearr_30441_30460 = state_30434__$1;
(statearr_30441_30460[(2)] = inst_30405);

(statearr_30441_30460[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (5))){
var _ = (function (){var statearr_30442 = state_30434;
(statearr_30442[(4)] = cljs.core.rest((state_30434[(4)])));

return statearr_30442;
})();
var state_30434__$1 = state_30434;
var ex30440 = (state_30434__$1[(2)]);
var statearr_30443_30461 = state_30434__$1;
(statearr_30443_30461[(5)] = ex30440);


var statearr_30444_30462 = state_30434__$1;
(statearr_30444_30462[(1)] = (4));

(statearr_30444_30462[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (6))){
var inst_30413 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30414 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_30415 = cljs.core.PersistentHashMap.fromArrays(inst_30413,inst_30414);
var inst_30416 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_30415);
var inst_30417 = (function(){throw inst_30416})();
var state_30434__$1 = state_30434;
var statearr_30445_30463 = state_30434__$1;
(statearr_30445_30463[(2)] = inst_30417);

(statearr_30445_30463[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (7))){
var inst_30419 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_30420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30421 = [operation,data,pc,opts];
var inst_30422 = (new cljs.core.PersistentVector(null,4,(5),inst_30420,inst_30421,null));
var inst_30423 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_30419,inst_30422);
var inst_30424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30425 = [operation,data,pc,opts];
var inst_30426 = (new cljs.core.PersistentVector(null,4,(5),inst_30424,inst_30425,null));
var inst_30427 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_30426], 0));
var state_30434__$1 = (function (){var statearr_30446 = state_30434;
(statearr_30446[(7)] = inst_30423);

return statearr_30446;
})();
var statearr_30447_30464 = state_30434__$1;
(statearr_30447_30464[(2)] = inst_30427);

(statearr_30447_30464[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (8))){
var inst_30429 = (state_30434[(2)]);
var _ = (function (){var statearr_30448 = state_30434;
(statearr_30448[(4)] = cljs.core.rest((state_30434[(4)])));

return statearr_30448;
})();
var state_30434__$1 = state_30434;
var statearr_30449_30465 = state_30434__$1;
(statearr_30449_30465[(2)] = inst_30429);

(statearr_30449_30465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__11438__auto__ = null;
var fluree$db$operations$state_machine__11438__auto____0 = (function (){
var statearr_30450 = [null,null,null,null,null,null,null,null];
(statearr_30450[(0)] = fluree$db$operations$state_machine__11438__auto__);

(statearr_30450[(1)] = (1));

return statearr_30450;
});
var fluree$db$operations$state_machine__11438__auto____1 = (function (state_30434){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_30434);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e30451){var ex__11441__auto__ = e30451;
var statearr_30452_30466 = state_30434;
(statearr_30452_30466[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_30434[(4)]))){
var statearr_30453_30467 = state_30434;
(statearr_30453_30467[(1)] = cljs.core.first((state_30434[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30468 = state_30434;
state_30434 = G__30468;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$operations$state_machine__11438__auto__ = function(state_30434){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__11438__auto____1.call(this,state_30434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__11438__auto____0;
fluree$db$operations$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__11438__auto____1;
return fluree$db$operations$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_30454 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_30454[(6)] = c__11512__auto___30456);

return statearr_30454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__30470 = arguments.length;
switch (G__30470) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__30471){
var map__30472 = p__30471;
var map__30472__$1 = cljs.core.__destructure_map(map__30472);
var opts = map__30472__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30472__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__30473 = session;
var map__30473__$1 = cljs.core.__destructure_map(map__30473);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30473__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30473__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30473__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__5774__auto__ = [];
var len__5768__auto___30500 = arguments.length;
var i__5769__auto___30501 = (0);
while(true){
if((i__5769__auto___30501 < len__5768__auto___30500)){
args__5774__auto__.push((arguments[i__5769__auto___30501]));

var G__30502 = (i__5769__auto___30501 + (1));
i__5769__auto___30501 = G__30502;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__30477){
var vec__30478 = p__30477;
var map__30481 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30478,(0),null);
var map__30481__$1 = cljs.core.__destructure_map(map__30481);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30481__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30481__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__30478;
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_30493){
var state_val_30494 = (state_30493[(1)]);
if((state_val_30494 === (1))){
var inst_30483 = session;
var inst_30484 = cljs.core.__destructure_map(inst_30483);
var inst_30485 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30484,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_30486 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30484,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_30487 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30484,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_30488 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_30489 = [inst_30485,inst_30486,toBlock,toTime];
var inst_30490 = cljs.core.PersistentHashMap.fromArrays(inst_30488,inst_30489);
var inst_30491 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_30487,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_30490);
var state_30493__$1 = state_30493;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30493__$1,inst_30491);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__11438__auto__ = null;
var fluree$db$operations$state_machine__11438__auto____0 = (function (){
var statearr_30495 = [null,null,null,null,null,null,null];
(statearr_30495[(0)] = fluree$db$operations$state_machine__11438__auto__);

(statearr_30495[(1)] = (1));

return statearr_30495;
});
var fluree$db$operations$state_machine__11438__auto____1 = (function (state_30493){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_30493);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e30496){var ex__11441__auto__ = e30496;
var statearr_30497_30503 = state_30493;
(statearr_30497_30503[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_30493[(4)]))){
var statearr_30498_30504 = state_30493;
(statearr_30498_30504[(1)] = cljs.core.first((state_30493[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30505 = state_30493;
state_30493 = G__30505;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$operations$state_machine__11438__auto__ = function(state_30493){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__11438__auto____1.call(this,state_30493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__11438__auto____0;
fluree$db$operations$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__11438__auto____1;
return fluree$db$operations$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_30499 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_30499[(6)] = c__11512__auto__);

return statearr_30499;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq30475){
var G__30476 = cljs.core.first(seq30475);
var seq30475__$1 = cljs.core.next(seq30475);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30476,seq30475__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__30506 = session;
var map__30506__$1 = cljs.core.__destructure_map(map__30506);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30506__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30506__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30506__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"snapshot-ledger","snapshot-ledger",-1972847996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-list","ledger-list",-945136952),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__30508 = arguments.length;
switch (G__30508) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__30509 = opts;
var map__30509__$1 = cljs.core.__destructure_map(map__30509);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30509__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30509__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__5045__auto__ = auth;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
