// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e31780){var e = e31780;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__31781_SHARP_){
var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__31781_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__31781_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__31781_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__31781_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__31782_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31782_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__31783_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31783_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__5043__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__5045__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__31788 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31788,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31788,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__31784_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31784_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__5043__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__5043__auto__;
}
})())){
var vec__31791 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31791,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31791,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__5045__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__31785_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31785_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__31786_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31786_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__31787_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31787_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31794_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__31794_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (add_amount > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fuel;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__5043__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5802__auto__ = (function (){var G__31795 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__31795) : intersecting_vars.call(null,G__31795));
})();
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__31798,optional_QMARK_,fuel,max_fuel){
var map__31799 = p__31798;
var map__31799__$1 = cljs.core.__destructure_map(map__31799);
var res = map__31799__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31799__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_31865){
var state_val_31866 = (state_31865[(1)]);
if((state_val_31866 === (7))){
var inst_31854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31855 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_31856 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_31855,clause);
var inst_31857 = [null,inst_31856];
var inst_31858 = (new cljs.core.PersistentVector(null,2,(5),inst_31854,inst_31857,null));
var state_31865__$1 = state_31865;
var statearr_31867_31895 = state_31865__$1;
(statearr_31867_31895[(2)] = inst_31858);

(statearr_31867_31895[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31866 === (1))){
var state_31865__$1 = state_31865;
var statearr_31868_31896 = state_31865__$1;
(statearr_31868_31896[(2)] = null);

(statearr_31868_31896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31866 === (4))){
var inst_31800 = (state_31865[(2)]);
var state_31865__$1 = state_31865;
var statearr_31869_31897 = state_31865__$1;
(statearr_31869_31897[(2)] = inst_31800);

(statearr_31869_31897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31866 === (15))){
var inst_31843 = (state_31865[(2)]);
var inst_31844 = fluree.db.util.async.throw_err(inst_31843);
var inst_31845 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_31844);
var inst_31846 = cljs.core.count(inst_31845);
var inst_31847 = fluree.db.query.analytical.add_fuel(inst_31846,fuel,max_fuel);
var inst_31848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31849 = [inst_31844,r];
var inst_31850 = (new cljs.core.PersistentVector(null,2,(5),inst_31848,inst_31849,null));
var state_31865__$1 = (function (){var statearr_31870 = state_31865;
(statearr_31870[(7)] = inst_31847);

return statearr_31870;
})();
var statearr_31871_31898 = state_31865__$1;
(statearr_31871_31898[(2)] = inst_31850);

(statearr_31871_31898[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31866 === (13))){
var inst_31809 = (state_31865[(8)]);
var inst_31822 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_31823 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_31822);
var inst_31824 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_31809);
var inst_31825 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_31824);
var inst_31826 = cljs.core.set(inst_31825);
var inst_31827 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_31823);
var inst_31828 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_31827);
var inst_31829 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31826,inst_31828);
var inst_31830 = (function (){var all_wd = inst_31809;
var optional = inst_31823;
var all_wd_vars = inst_31826;
var all_vars = inst_31829;
return (function (p1__31796_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__31796_SHARP_) : all_vars.call(null,p1__31796_SHARP_));
});
})();
var inst_31831 = cljs.core.keys(vars);
var inst_31832 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_31830,inst_31831);
var inst_31833 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_31832);
var inst_31834 = cljs.core.set(inst_31833);
var inst_31835 = (function (){var all_wd = inst_31809;
var optional = inst_31823;
var all_wd_vars = inst_31826;
var all_vars = inst_31829;
var intersecting_vars = inst_31834;
return (function (p1__31797_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__31797_SHARP_);
});
})();
var inst_31836 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_31835,inst_31809);
var inst_31837 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_31836);
var inst_31838 = fluree.db.query.analytical.select_from_tuples(inst_31837,res);
var inst_31839 = fluree.db.query.analytical.replace_vars_wikidata(inst_31809,inst_31834,vars);
var inst_31840 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_31834,inst_31829);
var inst_31841 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_31839,inst_31837,inst_31838,inst_31840,inst_31823);
var state_31865__$1 = state_31865;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31865__$1,(15),inst_31841);
} else {
if((state_val_31866 === (6))){
var inst_31810 = (state_31865[(9)]);
var inst_31808 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_31809 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_31808);
var inst_31810__$1 = optional_QMARK_;
var state_31865__$1 = (function (){var statearr_31872 = state_31865;
(statearr_31872[(9)] = inst_31810__$1);

(statearr_31872[(8)] = inst_31809);

return statearr_31872;
})();
if(cljs.core.truth_(inst_31810__$1)){
var statearr_31873_31899 = state_31865__$1;
(statearr_31873_31899[(1)] = (9));

} else {
var statearr_31874_31900 = state_31865__$1;
(statearr_31874_31900[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31866 === (3))){
var inst_31863 = (state_31865[(2)]);
var state_31865__$1 = state_31865;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31865__$1,inst_31863);
} else {
if((state_val_31866 === (12))){
var inst_31818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31819 = [null,r];
var inst_31820 = (new cljs.core.PersistentVector(null,2,(5),inst_31818,inst_31819,null));
var state_31865__$1 = state_31865;
var statearr_31875_31901 = state_31865__$1;
(statearr_31875_31901[(2)] = inst_31820);

(statearr_31875_31901[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31866 === (2))){
var _ = (function (){var statearr_31876 = state_31865;
(statearr_31876[(4)] = cljs.core.cons((5),(state_31865[(4)])));

return statearr_31876;
})();
var inst_31806 = (r == null);
var state_31865__$1 = state_31865;
if(cljs.core.truth_(inst_31806)){
var statearr_31877_31902 = state_31865__$1;
(statearr_31877_31902[(1)] = (6));

} else {
var statearr_31878_31903 = state_31865__$1;
(statearr_31878_31903[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31866 === (11))){
var inst_31816 = (state_31865[(2)]);
var state_31865__$1 = state_31865;
if(cljs.core.truth_(inst_31816)){
var statearr_31880_31904 = state_31865__$1;
(statearr_31880_31904[(1)] = (12));

} else {
var statearr_31881_31905 = state_31865__$1;
(statearr_31881_31905[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31866 === (9))){
var inst_31809 = (state_31865[(8)]);
var inst_31812 = cljs.core.empty_QMARK_(inst_31809);
var inst_31813 = (!(inst_31812));
var state_31865__$1 = state_31865;
var statearr_31882_31906 = state_31865__$1;
(statearr_31882_31906[(2)] = inst_31813);

(statearr_31882_31906[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31866 === (5))){
var _ = (function (){var statearr_31883 = state_31865;
(statearr_31883[(4)] = cljs.core.rest((state_31865[(4)])));

return statearr_31883;
})();
var state_31865__$1 = state_31865;
var ex31879 = (state_31865__$1[(2)]);
var statearr_31884_31907 = state_31865__$1;
(statearr_31884_31907[(5)] = ex31879);


if((ex31879 instanceof Error)){
var statearr_31885_31908 = state_31865__$1;
(statearr_31885_31908[(1)] = (4));

(statearr_31885_31908[(5)] = null);

} else {
throw ex31879;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31866 === (14))){
var inst_31852 = (state_31865[(2)]);
var state_31865__$1 = state_31865;
var statearr_31886_31909 = state_31865__$1;
(statearr_31886_31909[(2)] = inst_31852);

(statearr_31886_31909[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31866 === (10))){
var inst_31810 = (state_31865[(9)]);
var state_31865__$1 = state_31865;
var statearr_31887_31910 = state_31865__$1;
(statearr_31887_31910[(2)] = inst_31810);

(statearr_31887_31910[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31866 === (8))){
var inst_31860 = (state_31865[(2)]);
var _ = (function (){var statearr_31888 = state_31865;
(statearr_31888[(4)] = cljs.core.rest((state_31865[(4)])));

return statearr_31888;
})();
var state_31865__$1 = state_31865;
var statearr_31889_31911 = state_31865__$1;
(statearr_31889_31911[(2)] = inst_31860);

(statearr_31889_31911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11438__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11438__auto____0 = (function (){
var statearr_31890 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31890[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11438__auto__);

(statearr_31890[(1)] = (1));

return statearr_31890;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11438__auto____1 = (function (state_31865){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_31865);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e31891){var ex__11441__auto__ = e31891;
var statearr_31892_31912 = state_31865;
(statearr_31892_31912[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_31865[(4)]))){
var statearr_31893_31913 = state_31865;
(statearr_31893_31913[(1)] = cljs.core.first((state_31865[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31914 = state_31865;
state_31865 = G__31914;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11438__auto__ = function(state_31865){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11438__auto____1.call(this,state_31865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11438__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11438__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_31894 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_31894[(6)] = c__11512__auto__);

return statearr_31894;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__31916 = arguments.length;
switch (G__31916) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_32010){
var state_val_32011 = (state_32010[(1)]);
if((state_val_32011 === (7))){
var inst_31923 = (state_32010[(7)]);
var inst_31933 = clojure.string.starts_with_QMARK_(inst_31923,"$fdb");
var state_32010__$1 = state_32010;
if(inst_31933){
var statearr_32012_32061 = state_32010__$1;
(statearr_32012_32061[(1)] = (9));

} else {
var statearr_32013_32062 = state_32010__$1;
(statearr_32013_32062[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (20))){
var state_32010__$1 = state_32010;
var statearr_32014_32063 = state_32010__$1;
(statearr_32014_32063[(2)] = null);

(statearr_32014_32063[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (27))){
var inst_31973 = (state_32010[(8)]);
var state_32010__$1 = state_32010;
var statearr_32015_32064 = state_32010__$1;
(statearr_32015_32064[(2)] = inst_31973);

(statearr_32015_32064[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (1))){
var state_32010__$1 = state_32010;
var statearr_32016_32065 = state_32010__$1;
(statearr_32016_32065[(2)] = null);

(statearr_32016_32065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (24))){
var inst_31996 = (state_32010[(2)]);
var state_32010__$1 = state_32010;
var statearr_32017_32066 = state_32010__$1;
(statearr_32017_32066[(2)] = inst_31996);

(statearr_32017_32066[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (4))){
var inst_31917 = (state_32010[(2)]);
var state_32010__$1 = state_32010;
var statearr_32018_32067 = state_32010__$1;
(statearr_32018_32067[(2)] = inst_31917);

(statearr_32018_32067[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (15))){
var inst_31940 = (state_32010[(9)]);
var inst_31946 = (state_32010[(2)]);
var inst_31947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31948 = cljs.core.PersistentVector.EMPTY;
var inst_31949 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_31950 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31948,inst_31949);
var inst_31951 = [inst_31940,inst_31950];
var inst_31952 = (new cljs.core.PersistentVector(null,2,(5),inst_31947,inst_31951,null));
var state_32010__$1 = (function (){var statearr_32019 = state_32010;
(statearr_32019[(10)] = inst_31946);

return statearr_32019;
})();
var statearr_32020_32068 = state_32010__$1;
(statearr_32020_32068[(2)] = inst_31952);

(statearr_32020_32068[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (21))){
var inst_31999 = (state_32010[(2)]);
var state_32010__$1 = state_32010;
var statearr_32021_32069 = state_32010__$1;
(statearr_32021_32069[(2)] = inst_31999);

(statearr_32021_32069[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (13))){
var inst_31940 = (state_32010[(9)]);
var inst_31943 = (function(){throw inst_31940})();
var state_32010__$1 = state_32010;
var statearr_32022_32070 = state_32010__$1;
(statearr_32022_32070[(2)] = inst_31943);

(statearr_32022_32070[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (22))){
var inst_31962 = (state_32010[(11)]);
var inst_31964 = (state_32010[(12)]);
var inst_31966 = fluree.db.query.analytical.parse_block_from_source(inst_31962);
var inst_31967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31968 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_31964];
var inst_31969 = (new cljs.core.PersistentVector(null,2,(5),inst_31967,inst_31968,null));
var inst_31970 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_31969);
var state_32010__$1 = (function (){var statearr_32023 = state_32010;
(statearr_32023[(13)] = inst_31966);

return statearr_32023;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32010__$1,(25),inst_31970);
} else {
if((state_val_32011 === (29))){
var inst_31977 = (state_32010[(2)]);
var inst_31978 = fluree.db.util.async.throw_err(inst_31977);
var state_32010__$1 = state_32010;
var statearr_32024_32071 = state_32010__$1;
(statearr_32024_32071[(2)] = inst_31978);

(statearr_32024_32071[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (6))){
var inst_31926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31927 = cljs.core.PersistentVector.EMPTY;
var inst_31928 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_31929 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31927,inst_31928);
var inst_31930 = [db,inst_31929];
var inst_31931 = (new cljs.core.PersistentVector(null,2,(5),inst_31926,inst_31930,null));
var state_32010__$1 = state_32010;
var statearr_32025_32072 = state_32010__$1;
(statearr_32025_32072[(2)] = inst_31931);

(statearr_32025_32072[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (28))){
var inst_31981 = (state_32010[(2)]);
var inst_31982 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31983 = cljs.core.PersistentVector.EMPTY;
var inst_31984 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_31985 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31983,inst_31984);
var inst_31986 = [inst_31981,inst_31985];
var inst_31987 = (new cljs.core.PersistentVector(null,2,(5),inst_31982,inst_31986,null));
var state_32010__$1 = state_32010;
var statearr_32026_32073 = state_32010__$1;
(statearr_32026_32073[(2)] = inst_31987);

(statearr_32026_32073[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (25))){
var inst_31966 = (state_32010[(13)]);
var inst_31972 = (state_32010[(2)]);
var inst_31973 = fluree.db.util.async.throw_err(inst_31972);
var state_32010__$1 = (function (){var statearr_32027 = state_32010;
(statearr_32027[(8)] = inst_31973);

return statearr_32027;
})();
if(cljs.core.truth_(inst_31966)){
var statearr_32028_32074 = state_32010__$1;
(statearr_32028_32074[(1)] = (26));

} else {
var statearr_32029_32075 = state_32010__$1;
(statearr_32029_32075[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (17))){
var state_32010__$1 = state_32010;
var statearr_32030_32076 = state_32010__$1;
(statearr_32030_32076[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (3))){
var inst_32008 = (state_32010[(2)]);
var state_32010__$1 = state_32010;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32010__$1,inst_32008);
} else {
if((state_val_32011 === (12))){
var inst_31940 = (state_32010[(9)]);
var inst_31939 = (state_32010[(2)]);
var inst_31940__$1 = fluree.db.util.async.throw_err(inst_31939);
var inst_31941 = fluree.db.util.core.exception_QMARK_(inst_31940__$1);
var state_32010__$1 = (function (){var statearr_32032 = state_32010;
(statearr_32032[(9)] = inst_31940__$1);

return statearr_32032;
})();
if(inst_31941){
var statearr_32033_32077 = state_32010__$1;
(statearr_32033_32077[(1)] = (13));

} else {
var statearr_32034_32078 = state_32010__$1;
(statearr_32034_32078[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (2))){
var inst_31923 = (state_32010[(7)]);
var _ = (function (){var statearr_32035 = state_32010;
(statearr_32035[(4)] = cljs.core.cons((5),(state_32010[(4)])));

return statearr_32035;
})();
var inst_31923__$1 = cljs.core.first(clause);
var inst_31924 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_31923__$1);
var state_32010__$1 = (function (){var statearr_32036 = state_32010;
(statearr_32036[(7)] = inst_31923__$1);

return statearr_32036;
})();
if(inst_31924){
var statearr_32037_32079 = state_32010__$1;
(statearr_32037_32079[(1)] = (6));

} else {
var statearr_32038_32080 = state_32010__$1;
(statearr_32038_32080[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (23))){
var inst_31923 = (state_32010[(7)]);
var inst_31989 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31923)," is not supported in Fluree"].join('');
var inst_31990 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31991 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31992 = cljs.core.PersistentHashMap.fromArrays(inst_31990,inst_31991);
var inst_31993 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31989,inst_31992);
var inst_31994 = (function(){throw inst_31993})();
var state_32010__$1 = state_32010;
var statearr_32039_32081 = state_32010__$1;
(statearr_32039_32081[(2)] = inst_31994);

(statearr_32039_32081[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (19))){
var inst_31923 = (state_32010[(7)]);
var inst_31964 = (state_32010[(12)]);
var inst_31961 = fluree.db.query.analytical.isolate_source_name(inst_31923);
var inst_31962 = fluree.db.query.analytical.isolate_source_block(inst_31923);
var inst_31963 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_31961);
var inst_31964__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_31963);
var state_32010__$1 = (function (){var statearr_32040 = state_32010;
(statearr_32040[(11)] = inst_31962);

(statearr_32040[(12)] = inst_31964__$1);

return statearr_32040;
})();
if(cljs.core.truth_(inst_31964__$1)){
var statearr_32041_32082 = state_32010__$1;
(statearr_32041_32082[(1)] = (22));

} else {
var statearr_32042_32083 = state_32010__$1;
(statearr_32042_32083[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (11))){
var inst_32003 = (state_32010[(2)]);
var state_32010__$1 = state_32010;
var statearr_32044_32084 = state_32010__$1;
(statearr_32044_32084[(2)] = inst_32003);

(statearr_32044_32084[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (9))){
var inst_31923 = (state_32010[(7)]);
var inst_31935 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_31923,(4));
var inst_31936 = fluree.db.query.analytical.parse_block_from_source(inst_31935);
var inst_31937 = fluree.db.time_travel.as_of_block(db,inst_31936);
var state_32010__$1 = state_32010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32010__$1,(12),inst_31937);
} else {
if((state_val_32011 === (5))){
var _ = (function (){var statearr_32045 = state_32010;
(statearr_32045[(4)] = cljs.core.rest((state_32010[(4)])));

return statearr_32045;
})();
var state_32010__$1 = state_32010;
var ex32043 = (state_32010__$1[(2)]);
var statearr_32046_32085 = state_32010__$1;
(statearr_32046_32085[(5)] = ex32043);


if((ex32043 instanceof Error)){
var statearr_32047_32086 = state_32010__$1;
(statearr_32047_32086[(1)] = (4));

(statearr_32047_32086[(5)] = null);

} else {
throw ex32043;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (14))){
var state_32010__$1 = state_32010;
var statearr_32048_32087 = state_32010__$1;
(statearr_32048_32087[(2)] = null);

(statearr_32048_32087[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (26))){
var inst_31966 = (state_32010[(13)]);
var inst_31973 = (state_32010[(8)]);
var inst_31975 = fluree.db.time_travel.as_of_block(inst_31973,inst_31966);
var state_32010__$1 = state_32010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32010__$1,(29),inst_31975);
} else {
if((state_val_32011 === (16))){
var inst_31956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31957 = ["$wd",clause];
var inst_31958 = (new cljs.core.PersistentVector(null,2,(5),inst_31956,inst_31957,null));
var state_32010__$1 = state_32010;
var statearr_32049_32088 = state_32010__$1;
(statearr_32049_32088[(2)] = inst_31958);

(statearr_32049_32088[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (10))){
var inst_31923 = (state_32010[(7)]);
var inst_31954 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_31923);
var state_32010__$1 = state_32010;
if(inst_31954){
var statearr_32050_32089 = state_32010__$1;
(statearr_32050_32089[(1)] = (16));

} else {
var statearr_32051_32090 = state_32010__$1;
(statearr_32051_32090[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (18))){
var inst_32001 = (state_32010[(2)]);
var state_32010__$1 = state_32010;
var statearr_32052_32091 = state_32010__$1;
(statearr_32052_32091[(2)] = inst_32001);

(statearr_32052_32091[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32011 === (8))){
var inst_32005 = (state_32010[(2)]);
var _ = (function (){var statearr_32053 = state_32010;
(statearr_32053[(4)] = cljs.core.rest((state_32010[(4)])));

return statearr_32053;
})();
var state_32010__$1 = state_32010;
var statearr_32054_32092 = state_32010__$1;
(statearr_32054_32092[(2)] = inst_32005);

(statearr_32054_32092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__11438__auto__ = null;
var fluree$db$query$analytical$state_machine__11438__auto____0 = (function (){
var statearr_32055 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32055[(0)] = fluree$db$query$analytical$state_machine__11438__auto__);

(statearr_32055[(1)] = (1));

return statearr_32055;
});
var fluree$db$query$analytical$state_machine__11438__auto____1 = (function (state_32010){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_32010);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e32056){var ex__11441__auto__ = e32056;
var statearr_32057_32093 = state_32010;
(statearr_32057_32093[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_32010[(4)]))){
var statearr_32058_32094 = state_32010;
(statearr_32058_32094[(1)] = cljs.core.first((state_32010[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32095 = state_32010;
state_32010 = G__32095;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__11438__auto__ = function(state_32010){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__11438__auto____1.call(this,state_32010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__11438__auto____0;
fluree$db$query$analytical$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__11438__auto____1;
return fluree$db$query$analytical$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_32059 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_32059[(6)] = c__11512__auto__);

return statearr_32059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__32096){
var vec__32097 = p__32096;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32097,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32097,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32100_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__32100_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__32104 = subjects;
var vec__32105 = G__32104;
var seq__32106 = cljs.core.seq(vec__32105);
var first__32107 = cljs.core.first(seq__32106);
var seq__32106__$1 = cljs.core.next(seq__32106);
var subject = first__32107;
var r = seq__32106__$1;
var acc = expanded_map;
var G__32104__$1 = G__32104;
var acc__$1 = acc;
while(true){
var vec__32111 = G__32104__$1;
var seq__32112 = cljs.core.seq(vec__32111);
var first__32113 = cljs.core.first(seq__32112);
var seq__32112__$1 = cljs.core.next(seq__32112);
var subject__$1 = first__32113;
var r__$1 = seq__32112__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__32114 = r__$1;
var G__32115 = acc__$2;
G__32104__$1 = G__32114;
acc__$1 = G__32115;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__32104__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__32111,seq__32112,first__32113,seq__32112__$1,subject__$1,r__$1,acc__$2,G__32104,vec__32105,seq__32106,first__32107,seq__32106__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__5045__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__32104__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__32111,seq__32112,first__32113,seq__32112__$1,subject__$1,r__$1,acc__$2,G__32104,vec__32105,seq__32106,first__32107,seq__32106__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__32104__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__32111,seq__32112,first__32113,seq__32112__$1,subject__$1,r__$1,acc__$2,G__32104,vec__32105,seq__32106,first__32107,seq__32106__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__32104__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__32111,seq__32112,first__32113,seq__32112__$1,subject__$1,r__$1,acc__$2,G__32104,vec__32105,seq__32106,first__32107,seq__32106__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__32104__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__32111,seq__32112,first__32113,seq__32112__$1,subject__$1,r__$1,acc__$2,G__32104,vec__32105,seq__32106,first__32107,seq__32106__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__32104__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__32111,seq__32112,first__32113,seq__32112__$1,subject__$1,r__$1,acc__$2,G__32104,vec__32105,seq__32106,first__32107,seq__32106__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__32116 = r__$1;
var G__32117 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__32104__$1 = G__32116;
acc__$1 = G__32117;
continue;
} else {
var G__32118 = subjects;
var G__32119 = acc_STAR_;
G__32104__$1 = G__32118;
acc__$1 = G__32119;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32120_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__32120_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_32211){
var state_val_32212 = (state_32211[(1)]);
if((state_val_32212 === (7))){
var state_32211__$1 = state_32211;
var statearr_32213_32259 = state_32211__$1;
(statearr_32213_32259[(2)] = (100));

(statearr_32213_32259[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (20))){
var inst_32160 = (state_32211[(7)]);
var state_32211__$1 = state_32211;
var statearr_32214_32260 = state_32211__$1;
(statearr_32214_32260[(2)] = inst_32160);

(statearr_32214_32260[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (1))){
var state_32211__$1 = state_32211;
var statearr_32215_32261 = state_32211__$1;
(statearr_32215_32261[(2)] = null);

(statearr_32215_32261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (24))){
var inst_32199 = (state_32211[(8)]);
var inst_32197 = (state_32211[(9)]);
var inst_32132 = (state_32211[(10)]);
var inst_32198 = (state_32211[(11)]);
var inst_32202 = (function (){var max_depth = inst_32132;
var recur_map__$1 = inst_32198;
var subjects = inst_32197;
var tuples = inst_32199;
return (function (p1__32121_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__32121_SHARP_)],null));
});
})();
var inst_32203 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_32202,inst_32199);
var inst_32204 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_32203);
var state_32211__$1 = state_32211;
var statearr_32216_32262 = state_32211__$1;
(statearr_32216_32262[(2)] = inst_32204);

(statearr_32216_32262[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (4))){
var inst_32122 = (state_32211[(2)]);
var state_32211__$1 = state_32211;
var statearr_32217_32263 = state_32211__$1;
(statearr_32217_32263[(2)] = inst_32122);

(statearr_32217_32263[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (15))){
var inst_32145 = (state_32211[(12)]);
var inst_32156 = cljs.core.PersistentVector.EMPTY;
var inst_32157 = cljs.core.seq(inst_32145);
var inst_32158 = cljs.core.first(inst_32157);
var inst_32159 = cljs.core.next(inst_32157);
var inst_32160 = inst_32156;
var inst_32161 = inst_32145;
var state_32211__$1 = (function (){var statearr_32218 = state_32211;
(statearr_32218[(7)] = inst_32160);

(statearr_32218[(13)] = inst_32161);

(statearr_32218[(14)] = inst_32159);

(statearr_32218[(15)] = inst_32158);

return statearr_32218;
})();
var statearr_32219_32264 = state_32211__$1;
(statearr_32219_32264[(2)] = null);

(statearr_32219_32264[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (21))){
var inst_32181 = (state_32211[(2)]);
var state_32211__$1 = state_32211;
var statearr_32220_32265 = state_32211__$1;
(statearr_32220_32265[(2)] = inst_32181);

(statearr_32220_32265[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (13))){
var inst_32194 = (state_32211[(2)]);
var state_32211__$1 = state_32211;
var statearr_32221_32266 = state_32211__$1;
(statearr_32221_32266[(2)] = inst_32194);

(statearr_32221_32266[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (22))){
var inst_32160 = (state_32211[(7)]);
var inst_32168 = (state_32211[(16)]);
var inst_32175 = (state_32211[(2)]);
var inst_32176 = fluree.db.util.async.throw_err(inst_32175);
var inst_32177 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_32160,inst_32176);
var inst_32160__$1 = inst_32177;
var inst_32161 = inst_32168;
var state_32211__$1 = (function (){var statearr_32222 = state_32211;
(statearr_32222[(7)] = inst_32160__$1);

(statearr_32222[(13)] = inst_32161);

return statearr_32222;
})();
var statearr_32223_32267 = state_32211__$1;
(statearr_32223_32267[(2)] = null);

(statearr_32223_32267[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (6))){
var inst_32128 = (state_32211[(17)]);
var state_32211__$1 = state_32211;
var statearr_32224_32268 = state_32211__$1;
(statearr_32224_32268[(2)] = inst_32128);

(statearr_32224_32268[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (25))){
var inst_32206 = (state_32211[(2)]);
var _ = (function (){var statearr_32225 = state_32211;
(statearr_32225[(4)] = cljs.core.rest((state_32211[(4)])));

return statearr_32225;
})();
var state_32211__$1 = state_32211;
var statearr_32226_32269 = state_32211__$1;
(statearr_32226_32269[(2)] = inst_32206);

(statearr_32226_32269[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (17))){
var inst_32161 = (state_32211[(13)]);
var inst_32167 = (state_32211[(18)]);
var inst_32166 = cljs.core.seq(inst_32161);
var inst_32167__$1 = cljs.core.first(inst_32166);
var inst_32168 = cljs.core.next(inst_32166);
var state_32211__$1 = (function (){var statearr_32227 = state_32211;
(statearr_32227[(18)] = inst_32167__$1);

(statearr_32227[(16)] = inst_32168);

return statearr_32227;
})();
if(cljs.core.truth_(inst_32167__$1)){
var statearr_32228_32270 = state_32211__$1;
(statearr_32228_32270[(1)] = (19));

} else {
var statearr_32229_32271 = state_32211__$1;
(statearr_32229_32271[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (3))){
var inst_32209 = (state_32211[(2)]);
var state_32211__$1 = state_32211;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32211__$1,inst_32209);
} else {
if((state_val_32212 === (12))){
var inst_32134 = (state_32211[(19)]);
var inst_32145 = (state_32211[(12)]);
var inst_32140 = cljs.core.vals(inst_32134);
var inst_32141 = cljs.core.flatten(inst_32140);
var inst_32142 = cljs.core.set(inst_32141);
var inst_32143 = cljs.core.keys(inst_32134);
var inst_32144 = cljs.core.set(inst_32143);
var inst_32145__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_32142,inst_32144);
var inst_32146 = cljs.core.empty_QMARK_(inst_32145__$1);
var state_32211__$1 = (function (){var statearr_32230 = state_32211;
(statearr_32230[(12)] = inst_32145__$1);

return statearr_32230;
})();
if(inst_32146){
var statearr_32231_32272 = state_32211__$1;
(statearr_32231_32272[(1)] = (14));

} else {
var statearr_32232_32273 = state_32211__$1;
(statearr_32232_32273[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (2))){
var inst_32128 = (state_32211[(17)]);
var _ = (function (){var statearr_32233 = state_32211;
(statearr_32233[(4)] = cljs.core.cons((5),(state_32211[(4)])));

return statearr_32233;
})();
var inst_32128__$1 = depth;
var state_32211__$1 = (function (){var statearr_32234 = state_32211;
(statearr_32234[(17)] = inst_32128__$1);

return statearr_32234;
})();
if(cljs.core.truth_(inst_32128__$1)){
var statearr_32235_32274 = state_32211__$1;
(statearr_32235_32274[(1)] = (6));

} else {
var statearr_32236_32275 = state_32211__$1;
(statearr_32236_32275[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (23))){
var inst_32199 = (state_32211[(8)]);
var state_32211__$1 = state_32211;
var statearr_32237_32276 = state_32211__$1;
(statearr_32237_32276[(2)] = inst_32199);

(statearr_32237_32276[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (19))){
var inst_32167 = (state_32211[(18)]);
var inst_32170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32171 = [inst_32167,predicate];
var inst_32172 = (new cljs.core.PersistentVector(null,2,(5),inst_32170,inst_32171,null));
var inst_32173 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_32172);
var state_32211__$1 = state_32211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32211__$1,(22),inst_32173);
} else {
if((state_val_32212 === (11))){
var inst_32134 = (state_32211[(19)]);
var state_32211__$1 = state_32211;
var statearr_32239_32277 = state_32211__$1;
(statearr_32239_32277[(2)] = inst_32134);

(statearr_32239_32277[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (9))){
var inst_32135 = (state_32211[(20)]);
var inst_32132 = (state_32211[(10)]);
var inst_32137 = (inst_32135 >= inst_32132);
var state_32211__$1 = state_32211;
if(cljs.core.truth_(inst_32137)){
var statearr_32240_32278 = state_32211__$1;
(statearr_32240_32278[(1)] = (11));

} else {
var statearr_32241_32279 = state_32211__$1;
(statearr_32241_32279[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (5))){
var _ = (function (){var statearr_32242 = state_32211;
(statearr_32242[(4)] = cljs.core.rest((state_32211[(4)])));

return statearr_32242;
})();
var state_32211__$1 = state_32211;
var ex32238 = (state_32211__$1[(2)]);
var statearr_32243_32280 = state_32211__$1;
(statearr_32243_32280[(5)] = ex32238);


if((ex32238 instanceof Error)){
var statearr_32244_32281 = state_32211__$1;
(statearr_32244_32281[(1)] = (4));

(statearr_32244_32281[(5)] = null);

} else {
throw ex32238;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (14))){
var inst_32134 = (state_32211[(19)]);
var state_32211__$1 = state_32211;
var statearr_32245_32282 = state_32211__$1;
(statearr_32245_32282[(2)] = inst_32134);

(statearr_32245_32282[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (16))){
var inst_32192 = (state_32211[(2)]);
var state_32211__$1 = state_32211;
var statearr_32246_32283 = state_32211__$1;
(statearr_32246_32283[(2)] = inst_32192);

(statearr_32246_32283[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (10))){
var inst_32197 = (state_32211[(9)]);
var inst_32198 = (state_32211[(11)]);
var inst_32196 = (state_32211[(2)]);
var inst_32197__$1 = cljs.core.keys(inst_32196);
var inst_32198__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_32197__$1,inst_32196);
var inst_32199 = fluree.db.query.analytical.recur_map__GT_tuples(inst_32197__$1,inst_32198__$1);
var state_32211__$1 = (function (){var statearr_32247 = state_32211;
(statearr_32247[(8)] = inst_32199);

(statearr_32247[(9)] = inst_32197__$1);

(statearr_32247[(11)] = inst_32198__$1);

return statearr_32247;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_32248_32284 = state_32211__$1;
(statearr_32248_32284[(1)] = (23));

} else {
var statearr_32249_32285 = state_32211__$1;
(statearr_32249_32285[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (18))){
var inst_32134 = (state_32211[(19)]);
var inst_32135 = (state_32211[(20)]);
var inst_32183 = (state_32211[(2)]);
var inst_32184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32185 = [(0),(2)];
var inst_32186 = (new cljs.core.PersistentVector(null,2,(5),inst_32184,inst_32185,null));
var inst_32187 = fluree.db.query.analytical.get_ns_arrays(inst_32186,inst_32183);
var inst_32188 = fluree.db.query.analytical.tuples__GT_map(inst_32134,inst_32187);
var inst_32189 = (inst_32135 + (1));
var inst_32134__$1 = inst_32188;
var inst_32135__$1 = inst_32189;
var state_32211__$1 = (function (){var statearr_32250 = state_32211;
(statearr_32250[(19)] = inst_32134__$1);

(statearr_32250[(20)] = inst_32135__$1);

return statearr_32250;
})();
var statearr_32251_32286 = state_32211__$1;
(statearr_32251_32286[(2)] = null);

(statearr_32251_32286[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (8))){
var inst_32132 = (state_32211[(2)]);
var inst_32133 = recur_map;
var inst_32134 = inst_32133;
var inst_32135 = (1);
var state_32211__$1 = (function (){var statearr_32252 = state_32211;
(statearr_32252[(19)] = inst_32134);

(statearr_32252[(20)] = inst_32135);

(statearr_32252[(10)] = inst_32132);

return statearr_32252;
})();
var statearr_32253_32287 = state_32211__$1;
(statearr_32253_32287[(2)] = null);

(statearr_32253_32287[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11438__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11438__auto____0 = (function (){
var statearr_32254 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32254[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11438__auto__);

(statearr_32254[(1)] = (1));

return statearr_32254;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11438__auto____1 = (function (state_32211){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_32211);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e32255){var ex__11441__auto__ = e32255;
var statearr_32256_32288 = state_32211;
(statearr_32256_32288[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_32211[(4)]))){
var statearr_32257_32289 = state_32211;
(statearr_32257_32289[(1)] = cljs.core.first((state_32211[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32290 = state_32211;
state_32211 = G__32290;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11438__auto__ = function(state_32211){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11438__auto____1.call(this,state_32211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11438__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11438__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_32258 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_32258[(6)] = c__11512__auto__);

return statearr_32258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__32291,clause,fuel,max_fuel){
var map__32292 = p__32291;
var map__32292__$1 = cljs.core.__destructure_map(map__32292);
var res = map__32292__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32292__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32292__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32292__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_32403){
var state_val_32404 = (state_32403[(1)]);
if((state_val_32404 === (7))){
var inst_32309 = (state_32403[(7)]);
var state_32403__$1 = state_32403;
var statearr_32405_32458 = state_32403__$1;
(statearr_32405_32458[(2)] = inst_32309);

(statearr_32405_32458[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (20))){
var inst_32337 = (state_32403[(8)]);
var inst_32368 = typeof inst_32337 === 'number';
var state_32403__$1 = state_32403;
if(cljs.core.truth_(inst_32368)){
var statearr_32406_32459 = state_32403__$1;
(statearr_32406_32459[(1)] = (22));

} else {
var statearr_32407_32460 = state_32403__$1;
(statearr_32407_32460[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (27))){
var inst_32383 = (state_32403[(2)]);
var state_32403__$1 = state_32403;
var statearr_32408_32461 = state_32403__$1;
(statearr_32408_32461[(2)] = inst_32383);

(statearr_32408_32461[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (1))){
var state_32403__$1 = state_32403;
var statearr_32409_32462 = state_32403__$1;
(statearr_32409_32462[(2)] = null);

(statearr_32409_32462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (24))){
var inst_32385 = (state_32403[(2)]);
var state_32403__$1 = state_32403;
var statearr_32410_32463 = state_32403__$1;
(statearr_32410_32463[(2)] = inst_32385);

(statearr_32410_32463[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (4))){
var inst_32293 = (state_32403[(2)]);
var state_32403__$1 = state_32403;
var statearr_32411_32464 = state_32403__$1;
(statearr_32411_32464[(2)] = inst_32293);

(statearr_32411_32464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (15))){
var inst_32351 = (state_32403[(2)]);
var inst_32352 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_32353 = fluree.db.query.analytical.variable_QMARK_(inst_32352);
var state_32403__$1 = (function (){var statearr_32412 = state_32403;
(statearr_32412[(9)] = inst_32351);

return statearr_32412;
})();
if(cljs.core.truth_(inst_32353)){
var statearr_32413_32465 = state_32403__$1;
(statearr_32413_32465[(1)] = (16));

} else {
var statearr_32414_32466 = state_32403__$1;
(statearr_32414_32466[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (21))){
var inst_32310 = (state_32403[(10)]);
var inst_32340 = (state_32403[(11)]);
var inst_32339 = (state_32403[(12)]);
var inst_32387 = (state_32403[(2)]);
var inst_32388 = fluree.db.query.analytical.tuples__GT_recur(db,inst_32340,inst_32387,inst_32310,inst_32339);
var state_32403__$1 = state_32403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32403__$1,(28),inst_32388);
} else {
if((state_val_32404 === (13))){
var inst_32319 = (state_32403[(13)]);
var inst_32343 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32319)].join('');
var inst_32344 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_32345 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_32346 = cljs.core.PersistentHashMap.fromArrays(inst_32344,inst_32345);
var inst_32347 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_32343,inst_32346);
var inst_32348 = (function(){throw inst_32347})();
var state_32403__$1 = state_32403;
var statearr_32415_32467 = state_32403__$1;
(statearr_32415_32467[(2)] = inst_32348);

(statearr_32415_32467[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (22))){
var inst_32337 = (state_32403[(8)]);
var inst_32335 = (state_32403[(14)]);
var inst_32370 = cljs.core.PersistentHashMap.EMPTY;
var inst_32371 = cljs.core.flatten(inst_32335);
var inst_32372 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_32370,inst_32337,inst_32371);
var state_32403__$1 = state_32403;
var statearr_32416_32468 = state_32403__$1;
(statearr_32416_32468[(2)] = inst_32372);

(statearr_32416_32468[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (6))){
var inst_32321 = (state_32403[(15)]);
var state_32403__$1 = state_32403;
var statearr_32417_32469 = state_32403__$1;
(statearr_32417_32469[(2)] = inst_32321);

(statearr_32417_32469[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (28))){
var inst_32390 = (state_32403[(2)]);
var inst_32391 = fluree.db.util.async.throw_err(inst_32390);
var state_32403__$1 = state_32403;
var statearr_32418_32470 = state_32403__$1;
(statearr_32418_32470[(2)] = inst_32391);

(statearr_32418_32470[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (25))){
var inst_32331 = (state_32403[(16)]);
var inst_32335 = (state_32403[(14)]);
var inst_32376 = cljs.core.PersistentHashMap.EMPTY;
var inst_32377 = cljs.core.first(inst_32331);
var inst_32378 = cljs.core.first(inst_32377);
var inst_32379 = cljs.core.flatten(inst_32335);
var inst_32380 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_32376,inst_32378,inst_32379);
var state_32403__$1 = state_32403;
var statearr_32419_32471 = state_32403__$1;
(statearr_32419_32471[(2)] = inst_32380);

(statearr_32419_32471[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (17))){
var inst_32319 = (state_32403[(13)]);
var inst_32356 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32319)].join('');
var inst_32357 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_32358 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_32359 = cljs.core.PersistentHashMap.fromArrays(inst_32357,inst_32358);
var inst_32360 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_32356,inst_32359);
var inst_32361 = (function(){throw inst_32360})();
var state_32403__$1 = state_32403;
var statearr_32420_32472 = state_32403__$1;
(statearr_32420_32472[(2)] = inst_32361);

(statearr_32420_32472[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (3))){
var inst_32401 = (state_32403[(2)]);
var state_32403__$1 = state_32403;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32403__$1,inst_32401);
} else {
if((state_val_32404 === (12))){
var inst_32306 = (state_32403[(17)]);
var inst_32394 = (state_32403[(2)]);
var inst_32395 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_32396 = cljs.core.keys(inst_32306);
var inst_32397 = [inst_32396,vars,inst_32394];
var inst_32398 = cljs.core.PersistentHashMap.fromArrays(inst_32395,inst_32397);
var _ = (function (){var statearr_32421 = state_32403;
(statearr_32421[(4)] = cljs.core.rest((state_32403[(4)])));

return statearr_32421;
})();
var state_32403__$1 = state_32403;
var statearr_32422_32473 = state_32403__$1;
(statearr_32422_32473[(2)] = inst_32398);

(statearr_32422_32473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (2))){
var inst_32309 = (state_32403[(7)]);
var inst_32310 = (state_32403[(10)]);
var inst_32306 = (state_32403[(17)]);
var inst_32321 = (state_32403[(15)]);
var _ = (function (){var statearr_32423 = state_32403;
(statearr_32423[(4)] = cljs.core.cons((5),(state_32403[(4)])));

return statearr_32423;
})();
var inst_32303 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_32304 = cljs.core.__destructure_map(inst_32303);
var inst_32305 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32304,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_32306__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32304,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_32307 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32304,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_32308 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_32309__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_32307);
var inst_32310__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_32307);
var inst_32312 = (function (){var map__32299 = inst_32304;
var search = inst_32305;
var rel = inst_32306__$1;
var opts = inst_32307;
var common_keys = inst_32308;
var object_fn = inst_32309__$1;
var recur_depth = inst_32310__$1;
return (function (p__32311,common_key){
var vec__32424 = p__32311;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32424,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32424,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__32427 = cljs.core._EQ_;
var expr__32428 = idx_of;
if(cljs.core.truth_((pred__32427.cljs$core$IFn$_invoke$arity$2 ? pred__32427.cljs$core$IFn$_invoke$arity$2((0),expr__32428) : pred__32427.call(null,(0),expr__32428)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__32427.cljs$core$IFn$_invoke$arity$2 ? pred__32427.cljs$core$IFn$_invoke$arity$2((1),expr__32428) : pred__32427.call(null,(1),expr__32428)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__32427.cljs$core$IFn$_invoke$arity$2 ? pred__32427.cljs$core$IFn$_invoke$arity$2((2),expr__32428) : pred__32427.call(null,(2),expr__32428)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__32428)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__5043__auto__ = (!(single_v_QMARK_));
if(and__5043__auto__){
var and__5043__auto____$1 = object_fn;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_32313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32314 = cljs.core.PersistentHashMap.EMPTY;
var inst_32315 = [inst_32314,inst_32305];
var inst_32316 = (new cljs.core.PersistentVector(null,2,(5),inst_32313,inst_32315,null));
var inst_32317 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32312,inst_32316,inst_32308);
var inst_32318 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32317,(0),null);
var inst_32319 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32317,(1),null);
var inst_32320 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_32321__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_32318);
var state_32403__$1 = (function (){var statearr_32430 = state_32403;
(statearr_32430[(7)] = inst_32309__$1);

(statearr_32430[(18)] = inst_32320);

(statearr_32430[(13)] = inst_32319);

(statearr_32430[(10)] = inst_32310__$1);

(statearr_32430[(17)] = inst_32306__$1);

(statearr_32430[(15)] = inst_32321__$1);

return statearr_32430;
})();
if(cljs.core.truth_(inst_32321__$1)){
var statearr_32431_32474 = state_32403__$1;
(statearr_32431_32474[(1)] = (6));

} else {
var statearr_32432_32475 = state_32403__$1;
(statearr_32432_32475[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (23))){
var inst_32337 = (state_32403[(8)]);
var inst_32374 = cljs.core.coll_QMARK_(inst_32337);
var state_32403__$1 = state_32403;
if(inst_32374){
var statearr_32433_32476 = state_32403__$1;
(statearr_32433_32476[(1)] = (25));

} else {
var statearr_32434_32477 = state_32403__$1;
(statearr_32434_32477[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (19))){
var inst_32335 = (state_32403[(14)]);
var inst_32365 = cljs.core.PersistentHashMap.EMPTY;
var inst_32366 = fluree.db.query.analytical.tuples__GT_map(inst_32365,inst_32335);
var state_32403__$1 = state_32403;
var statearr_32435_32478 = state_32403__$1;
(statearr_32435_32478[(2)] = inst_32366);

(statearr_32435_32478[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (11))){
var inst_32335 = (state_32403[(14)]);
var state_32403__$1 = state_32403;
var statearr_32437_32479 = state_32403__$1;
(statearr_32437_32479[(2)] = inst_32335);

(statearr_32437_32479[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (9))){
var inst_32331 = (state_32403[(16)]);
var inst_32310 = (state_32403[(10)]);
var inst_32306 = (state_32403[(17)]);
var inst_32330 = (state_32403[(2)]);
var inst_32331__$1 = fluree.db.util.async.throw_err(inst_32330);
var inst_32332 = cljs.core.count(inst_32331__$1);
var inst_32333 = fluree.db.query.analytical.add_fuel(inst_32332,fuel,max_fuel);
var inst_32334 = cljs.core.vals(inst_32306);
var inst_32335 = fluree.db.query.analytical.get_ns_arrays(inst_32334,inst_32331__$1);
var state_32403__$1 = (function (){var statearr_32438 = state_32403;
(statearr_32438[(16)] = inst_32331__$1);

(statearr_32438[(14)] = inst_32335);

(statearr_32438[(19)] = inst_32333);

return statearr_32438;
})();
if(cljs.core.truth_(inst_32310)){
var statearr_32439_32480 = state_32403__$1;
(statearr_32439_32480[(1)] = (10));

} else {
var statearr_32440_32481 = state_32403__$1;
(statearr_32440_32481[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (5))){
var _ = (function (){var statearr_32441 = state_32403;
(statearr_32441[(4)] = cljs.core.rest((state_32403[(4)])));

return statearr_32441;
})();
var state_32403__$1 = state_32403;
var ex32436 = (state_32403__$1[(2)]);
var statearr_32442_32482 = state_32403__$1;
(statearr_32442_32482[(5)] = ex32436);


if((ex32436 instanceof Error)){
var statearr_32443_32483 = state_32403__$1;
(statearr_32443_32483[(1)] = (4));

(statearr_32443_32483[(5)] = null);

} else {
throw ex32436;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (14))){
var state_32403__$1 = state_32403;
var statearr_32444_32484 = state_32403__$1;
(statearr_32444_32484[(2)] = null);

(statearr_32444_32484[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (26))){
var state_32403__$1 = state_32403;
var statearr_32445_32485 = state_32403__$1;
(statearr_32445_32485[(2)] = null);

(statearr_32445_32485[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (16))){
var state_32403__$1 = state_32403;
var statearr_32446_32486 = state_32403__$1;
(statearr_32446_32486[(2)] = null);

(statearr_32446_32486[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (10))){
var inst_32319 = (state_32403[(13)]);
var inst_32340 = (state_32403[(11)]);
var inst_32337 = cljs.core.first(inst_32319);
var inst_32338 = cljs.core.first(clause);
var inst_32339 = fluree.db.query.analytical.variable_QMARK_(inst_32338);
var inst_32340__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_32319,(1));
var inst_32341 = fluree.db.query.analytical.variable_QMARK_(inst_32340__$1);
var state_32403__$1 = (function (){var statearr_32447 = state_32403;
(statearr_32447[(8)] = inst_32337);

(statearr_32447[(11)] = inst_32340__$1);

(statearr_32447[(12)] = inst_32339);

return statearr_32447;
})();
if(cljs.core.truth_(inst_32341)){
var statearr_32448_32487 = state_32403__$1;
(statearr_32448_32487[(1)] = (13));

} else {
var statearr_32449_32488 = state_32403__$1;
(statearr_32449_32488[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (18))){
var inst_32339 = (state_32403[(12)]);
var inst_32363 = (state_32403[(2)]);
var state_32403__$1 = (function (){var statearr_32450 = state_32403;
(statearr_32450[(20)] = inst_32363);

return statearr_32450;
})();
if(cljs.core.truth_(inst_32339)){
var statearr_32451_32489 = state_32403__$1;
(statearr_32451_32489[(1)] = (19));

} else {
var statearr_32452_32490 = state_32403__$1;
(statearr_32452_32490[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32404 === (8))){
var inst_32320 = (state_32403[(18)]);
var inst_32319 = (state_32403[(13)]);
var inst_32325 = (state_32403[(2)]);
var inst_32326 = [inst_32325];
var inst_32327 = cljs.core.PersistentHashMap.fromArrays(inst_32320,inst_32326);
var inst_32328 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_32319,inst_32327);
var state_32403__$1 = state_32403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32403__$1,(9),inst_32328);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11438__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11438__auto____0 = (function (){
var statearr_32453 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32453[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11438__auto__);

(statearr_32453[(1)] = (1));

return statearr_32453;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11438__auto____1 = (function (state_32403){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_32403);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e32454){var ex__11441__auto__ = e32454;
var statearr_32455_32491 = state_32403;
(statearr_32455_32491[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_32403[(4)]))){
var statearr_32456_32492 = state_32403;
(statearr_32456_32492[(1)] = cljs.core.first((state_32403[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32493 = state_32403;
state_32403 = G__32493;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11438__auto__ = function(state_32403){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11438__auto____1.call(this,state_32403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11438__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11438__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_32457 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_32457[(6)] = c__11512__auto__);

return statearr_32457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__32494,res,clause){
var map__32495 = p__32494;
var map__32495__$1 = cljs.core.__destructure_map(map__32495);
var db = map__32495__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32495__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32495__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32495__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_32604){
var state_val_32605 = (state_32604[(1)]);
if((state_val_32605 === (7))){
var inst_32504 = (state_32604[(7)]);
var state_32604__$1 = state_32604;
var statearr_32606_32647 = state_32604__$1;
(statearr_32606_32647[(2)] = inst_32504);

(statearr_32606_32647[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (20))){
var state_32604__$1 = state_32604;
var statearr_32607_32648 = state_32604__$1;
(statearr_32607_32648[(2)] = null);

(statearr_32607_32648[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (1))){
var state_32604__$1 = state_32604;
var statearr_32608_32649 = state_32604__$1;
(statearr_32608_32649[(2)] = null);

(statearr_32608_32649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (24))){
var inst_32506 = (state_32604[(8)]);
var inst_32577 = (state_32604[(2)]);
var inst_32578 = fluree.db.flake.sid__GT_cid(inst_32577);
var inst_32579 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_32578);
var inst_32580 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_32581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32582 = [inst_32506];
var inst_32583 = (new cljs.core.PersistentVector(null,1,(5),inst_32581,inst_32582,null));
var inst_32584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32586 = [inst_32579];
var inst_32587 = (new cljs.core.PersistentVector(null,1,(5),inst_32585,inst_32586,null));
var inst_32588 = [inst_32587];
var inst_32589 = (new cljs.core.PersistentVector(null,1,(5),inst_32584,inst_32588,null));
var inst_32590 = cljs.core.PersistentHashMap.EMPTY;
var inst_32591 = [inst_32583,inst_32589,inst_32590];
var inst_32592 = cljs.core.PersistentHashMap.fromArrays(inst_32580,inst_32591);
var state_32604__$1 = state_32604;
var statearr_32609_32650 = state_32604__$1;
(statearr_32609_32650[(2)] = inst_32592);

(statearr_32609_32650[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (4))){
var inst_32497 = (state_32604[(2)]);
var state_32604__$1 = state_32604;
var statearr_32610_32651 = state_32604__$1;
(statearr_32610_32651[(2)] = inst_32497);

(statearr_32610_32651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (15))){
var inst_32504 = (state_32604[(7)]);
var inst_32506 = (state_32604[(8)]);
var inst_32525 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_32526 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_32527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32528 = [inst_32504];
var inst_32529 = (new cljs.core.PersistentVector(null,1,(5),inst_32527,inst_32528,null));
var inst_32530 = (function (){var subject_var = inst_32504;
var object_var = inst_32506;
var min_sid = inst_32525;
var max_sid = (0);
return (function (p1__32496_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__32496_SHARP_);
});
})();
var inst_32531 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_32525,(0));
var inst_32532 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_32530,inst_32531);
var inst_32533 = cljs.core.PersistentHashMap.EMPTY;
var inst_32534 = [inst_32529,inst_32532,inst_32533];
var inst_32535 = cljs.core.PersistentHashMap.fromArrays(inst_32526,inst_32534);
var state_32604__$1 = state_32604;
var statearr_32611_32652 = state_32604__$1;
(statearr_32611_32652[(2)] = inst_32535);

(statearr_32611_32652[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (21))){
var inst_32595 = (state_32604[(2)]);
var state_32604__$1 = state_32604;
var statearr_32612_32653 = state_32604__$1;
(statearr_32612_32653[(2)] = inst_32595);

(statearr_32612_32653[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (13))){
var inst_32506 = (state_32604[(8)]);
var state_32604__$1 = state_32604;
if(cljs.core.truth_(inst_32506)){
var statearr_32613_32654 = state_32604__$1;
(statearr_32613_32654[(1)] = (19));

} else {
var statearr_32614_32655 = state_32604__$1;
(statearr_32614_32655[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (22))){
var inst_32568 = (state_32604[(9)]);
var state_32604__$1 = state_32604;
var statearr_32615_32656 = state_32604__$1;
(statearr_32615_32656[(2)] = inst_32568);

(statearr_32615_32656[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (6))){
var inst_32506 = (state_32604[(8)]);
var state_32604__$1 = state_32604;
var statearr_32616_32657 = state_32604__$1;
(statearr_32616_32657[(2)] = inst_32506);

(statearr_32616_32657[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (25))){
var inst_32574 = (state_32604[(2)]);
var inst_32575 = fluree.db.util.async.throw_err(inst_32574);
var state_32604__$1 = state_32604;
var statearr_32617_32658 = state_32604__$1;
(statearr_32617_32658[(2)] = inst_32575);

(statearr_32617_32658[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (17))){
var inst_32565 = (state_32604[(2)]);
var state_32604__$1 = state_32604;
var statearr_32618_32659 = state_32604__$1;
(statearr_32618_32659[(2)] = inst_32565);

(statearr_32618_32659[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (3))){
var inst_32602 = (state_32604[(2)]);
var state_32604__$1 = state_32604;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32604__$1,inst_32602);
} else {
if((state_val_32605 === (12))){
var inst_32519 = ["_tx",null,"_block",null];
var inst_32520 = (new cljs.core.PersistentArrayMap(null,2,inst_32519,null));
var inst_32521 = (new cljs.core.PersistentHashSet(null,inst_32520,null));
var inst_32522 = cljs.core.last(clause);
var inst_32523 = (inst_32521.cljs$core$IFn$_invoke$arity$1 ? inst_32521.cljs$core$IFn$_invoke$arity$1(inst_32522) : inst_32521.call(null,inst_32522));
var state_32604__$1 = state_32604;
if(cljs.core.truth_(inst_32523)){
var statearr_32619_32660 = state_32604__$1;
(statearr_32619_32660[(1)] = (15));

} else {
var statearr_32620_32661 = state_32604__$1;
(statearr_32620_32661[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (2))){
var inst_32504 = (state_32604[(7)]);
var _ = (function (){var statearr_32621 = state_32604;
(statearr_32621[(4)] = cljs.core.cons((5),(state_32604[(4)])));

return statearr_32621;
})();
var inst_32503 = cljs.core.first(clause);
var inst_32504__$1 = fluree.db.query.analytical.variable_QMARK_(inst_32503);
var inst_32505 = cljs.core.last(clause);
var inst_32506 = fluree.db.query.analytical.variable_QMARK_(inst_32505);
var state_32604__$1 = (function (){var statearr_32622 = state_32604;
(statearr_32622[(7)] = inst_32504__$1);

(statearr_32622[(8)] = inst_32506);

return statearr_32622;
})();
if(cljs.core.truth_(inst_32504__$1)){
var statearr_32623_32662 = state_32604__$1;
(statearr_32623_32662[(1)] = (6));

} else {
var statearr_32624_32663 = state_32604__$1;
(statearr_32624_32663[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (23))){
var inst_32568 = (state_32604[(9)]);
var inst_32572 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_32568);
var state_32604__$1 = state_32604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32604__$1,(25),inst_32572);
} else {
if((state_val_32605 === (19))){
var inst_32568 = (state_32604[(9)]);
var inst_32568__$1 = cljs.core.first(clause);
var inst_32569 = typeof inst_32568__$1 === 'number';
var state_32604__$1 = (function (){var statearr_32625 = state_32604;
(statearr_32625[(9)] = inst_32568__$1);

return statearr_32625;
})();
if(cljs.core.truth_(inst_32569)){
var statearr_32626_32664 = state_32604__$1;
(statearr_32626_32664[(1)] = (22));

} else {
var statearr_32627_32665 = state_32604__$1;
(statearr_32627_32665[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (11))){
var inst_32599 = (state_32604[(2)]);
var _ = (function (){var statearr_32629 = state_32604;
(statearr_32629[(4)] = cljs.core.rest((state_32604[(4)])));

return statearr_32629;
})();
var state_32604__$1 = state_32604;
var statearr_32630_32666 = state_32604__$1;
(statearr_32630_32666[(2)] = inst_32599);

(statearr_32630_32666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (9))){
var inst_32512 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_32513 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_32514 = cljs.core.PersistentHashMap.fromArrays(inst_32512,inst_32513);
var inst_32515 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_32514);
var inst_32516 = (function(){throw inst_32515})();
var state_32604__$1 = state_32604;
var statearr_32631_32667 = state_32604__$1;
(statearr_32631_32667[(2)] = inst_32516);

(statearr_32631_32667[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (5))){
var _ = (function (){var statearr_32632 = state_32604;
(statearr_32632[(4)] = cljs.core.rest((state_32604[(4)])));

return statearr_32632;
})();
var state_32604__$1 = state_32604;
var ex32628 = (state_32604__$1[(2)]);
var statearr_32633_32668 = state_32604__$1;
(statearr_32633_32668[(5)] = ex32628);


if((ex32628 instanceof Error)){
var statearr_32634_32669 = state_32604__$1;
(statearr_32634_32669[(1)] = (4));

(statearr_32634_32669[(5)] = null);

} else {
throw ex32628;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (14))){
var inst_32597 = (state_32604[(2)]);
var state_32604__$1 = state_32604;
var statearr_32635_32670 = state_32604__$1;
(statearr_32635_32670[(2)] = inst_32597);

(statearr_32635_32670[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (16))){
var inst_32540 = (state_32604[(10)]);
var inst_32541 = (state_32604[(11)]);
var inst_32538 = (state_32604[(12)]);
var inst_32537 = cljs.core.last(clause);
var inst_32538__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_32537);
var inst_32539 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_32540__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32539,inst_32538__$1);
var inst_32541__$1 = fluree.db.flake.min_subject_id(inst_32538__$1);
var inst_32542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32543 = [inst_32540__$1];
var inst_32544 = (new cljs.core.PersistentVector(null,1,(5),inst_32542,inst_32543,null));
var inst_32545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32546 = [inst_32541__$1];
var inst_32547 = (new cljs.core.PersistentVector(null,1,(5),inst_32545,inst_32546,null));
var inst_32548 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_32544,cljs.core._LT__EQ_,inst_32547);
var state_32604__$1 = (function (){var statearr_32636 = state_32604;
(statearr_32636[(10)] = inst_32540__$1);

(statearr_32636[(11)] = inst_32541__$1);

(statearr_32636[(12)] = inst_32538__$1);

return statearr_32636;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32604__$1,(18),inst_32548);
} else {
if((state_val_32605 === (10))){
var inst_32504 = (state_32604[(7)]);
var state_32604__$1 = state_32604;
if(cljs.core.truth_(inst_32504)){
var statearr_32637_32671 = state_32604__$1;
(statearr_32637_32671[(1)] = (12));

} else {
var statearr_32638_32672 = state_32604__$1;
(statearr_32638_32672[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (18))){
var inst_32540 = (state_32604[(10)]);
var inst_32504 = (state_32604[(7)]);
var inst_32506 = (state_32604[(8)]);
var inst_32541 = (state_32604[(11)]);
var inst_32538 = (state_32604[(12)]);
var inst_32550 = (state_32604[(2)]);
var inst_32551 = fluree.db.util.async.throw_err(inst_32550);
var inst_32552 = (function (){var subject_var = inst_32504;
var object_var = inst_32506;
var partition = inst_32538;
var max_sid = inst_32540;
var min_sid = inst_32541;
var flakes = inst_32551;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_32553 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_32552);
var inst_32554 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_32555 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_32553,inst_32554);
var inst_32556 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_32557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32558 = [inst_32504];
var inst_32559 = (new cljs.core.PersistentVector(null,1,(5),inst_32557,inst_32558,null));
var inst_32560 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_32555,inst_32551);
var inst_32561 = cljs.core.PersistentHashMap.EMPTY;
var inst_32562 = [inst_32559,inst_32560,inst_32561];
var inst_32563 = cljs.core.PersistentHashMap.fromArrays(inst_32556,inst_32562);
var state_32604__$1 = state_32604;
var statearr_32639_32673 = state_32604__$1;
(statearr_32639_32673[(2)] = inst_32563);

(statearr_32639_32673[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32605 === (8))){
var inst_32510 = (state_32604[(2)]);
var state_32604__$1 = state_32604;
if(cljs.core.truth_(inst_32510)){
var statearr_32640_32674 = state_32604__$1;
(statearr_32640_32674[(1)] = (9));

} else {
var statearr_32641_32675 = state_32604__$1;
(statearr_32641_32675[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11438__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11438__auto____0 = (function (){
var statearr_32642 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32642[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11438__auto__);

(statearr_32642[(1)] = (1));

return statearr_32642;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11438__auto____1 = (function (state_32604){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_32604);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e32643){var ex__11441__auto__ = e32643;
var statearr_32644_32676 = state_32604;
(statearr_32644_32676[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_32604[(4)]))){
var statearr_32645_32677 = state_32604;
(statearr_32645_32677[(1)] = cljs.core.first((state_32604[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32678 = state_32604;
state_32604 = G__32678;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11438__auto__ = function(state_32604){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11438__auto____1.call(this,state_32604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11438__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11438__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_32646 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_32646[(6)] = c__11512__auto__);

return statearr_32646;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__32685 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__32685 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__32685;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__5522__auto__ = (function fluree$db$query$analytical$variance_$_iter__32686(s__32687){
return (new cljs.core.LazySeq(null,(function (){
var s__32687__$1 = s__32687;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__32687__$1);
if(temp__5804__auto__){
var s__32687__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__32687__$2)){
var c__5520__auto__ = cljs.core.chunk_first(s__32687__$2);
var size__5521__auto__ = cljs.core.count(c__5520__auto__);
var b__32689 = cljs.core.chunk_buffer(size__5521__auto__);
if((function (){var i__32688 = (0);
while(true){
if((i__32688 < size__5521__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5520__auto__,i__32688);
var delta = (x - mean);
cljs.core.chunk_append(b__32689,(delta * delta));

var G__32691 = (i__32688 + (1));
i__32688 = G__32691;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__32689),fluree$db$query$analytical$variance_$_iter__32686(cljs.core.chunk_rest(s__32687__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__32689),null);
}
} else {
var x = cljs.core.first(s__32687__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__32686(cljs.core.rest(s__32687__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__32690 = variance(coll);
return Math.sqrt(G__32690);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__5130__auto__ = n;
var y__5131__auto__ = (- n);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
}),(function() {
var G__32692 = null;
var G__32692__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__32692__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__32692 = function(n,coll){
switch(arguments.length){
case 1:
return G__32692__1.call(this,n);
case 2:
return G__32692__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32692.cljs$core$IFn$_invoke$arity$1 = G__32692__1;
G__32692.cljs$core$IFn$_invoke$arity$2 = G__32692__2;
return G__32692;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__32693 = null;
var G__32693__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__32693__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__32693 = function(n,coll){
switch(arguments.length){
case 1:
return G__32693__1.call(this,n);
case 2:
return G__32693__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32693.cljs$core$IFn$_invoke$arity$1 = G__32693__1;
G__32693.cljs$core$IFn$_invoke$arity$2 = G__32693__2;
return G__32693;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__32694 = null;
var G__32694__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__32694__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__32694 = function(n,coll){
switch(arguments.length){
case 1:
return G__32694__1.call(this,n);
case 2:
return G__32694__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32694.cljs$core$IFn$_invoke$arity$1 = G__32694__1;
G__32694.cljs$core$IFn$_invoke$arity$2 = G__32694__2;
return G__32694;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__32695 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32695,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32695,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32695,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__32698 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__32701 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__32701) : agg_fn.call(null,G__32701));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32698,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32698,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__32702 = agg;
var map__32702__$1 = cljs.core.__destructure_map(map__32702);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32702__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32702__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32702__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__32704 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32704,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32704,(1),null);
var map__32707 = res__$1;
var map__32707__$1 = cljs.core.__destructure_map(map__32707);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32707__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32707__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32703_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__32703_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32708_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__32708_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32709_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__32709_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__32710_SHARP_,p2__32711_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__32710_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__32711_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32712_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__32712_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__32715,row,b_tuple){
var vec__32716 = p__32715;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32716,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32716,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32713_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__32713_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = acc;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32714_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__32714_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32719_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__32719_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32720_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__32720_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__32725 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__32727 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__32726 = (function (p1__32721_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__32721_SHARP_);
});
return fexpr__32726(G__32727);
})()),cljs.core.set(b_idxs));
var fexpr__32724 = (function (p1__32722_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__32722_SHARP_);
});
return fexpr__32724(G__32725);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32723_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__32723_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32728_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__32728_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32729_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__32729_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__32734 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__32736 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__32735 = (function (p1__32730_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__32730_SHARP_);
});
return fexpr__32735(G__32736);
})()),cljs.core.set(b_idxs));
var fexpr__32733 = (function (p1__32731_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__32731_SHARP_);
});
return fexpr__32733(G__32734);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32732_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__32732_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__32738 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32738,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32738,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__32737_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__32737_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__32743 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32743,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32743,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32741_SHARP_){
return fluree.db.util.core.index_of(headers,p1__32741_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__32742_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__32742_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__32746,filters,optional_QMARK_){
var map__32747 = p__32746;
var map__32747__$1 = cljs.core.__destructure_map(map__32747);
var tuple_map = map__32747__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32747__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32747__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32747__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__32748 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32748,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32748,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__32751 = res;
var map__32751__$1 = cljs.core.__destructure_map(map__32751);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32751__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32751__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5802__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_32807){
var state_val_32808 = (state_32807[(1)]);
if((state_val_32808 === (7))){
var inst_32781 = (state_32807[(7)]);
var inst_32779 = (state_32807[(2)]);
var inst_32780 = fluree.db.util.async.throw_err(inst_32779);
var inst_32781__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32780,(0),null);
var inst_32782 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32780,(1),null);
var inst_32783 = (inst_32781__$1 == null);
var state_32807__$1 = (function (){var statearr_32809 = state_32807;
(statearr_32809[(8)] = inst_32782);

(statearr_32809[(7)] = inst_32781__$1);

return statearr_32809;
})();
if(cljs.core.truth_(inst_32783)){
var statearr_32810_32839 = state_32807__$1;
(statearr_32810_32839[(1)] = (8));

} else {
var statearr_32811_32840 = state_32807__$1;
(statearr_32811_32840[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32808 === (1))){
var inst_32759 = optional_clauses;
var inst_32760 = cljs.core.seq(inst_32759);
var inst_32761 = cljs.core.first(inst_32760);
var inst_32762 = cljs.core.next(inst_32760);
var inst_32763 = where_tuples;
var inst_32764 = inst_32759;
var inst_32765 = inst_32763;
var state_32807__$1 = (function (){var statearr_32812 = state_32807;
(statearr_32812[(9)] = inst_32761);

(statearr_32812[(10)] = inst_32764);

(statearr_32812[(11)] = inst_32762);

(statearr_32812[(12)] = inst_32765);

return statearr_32812;
})();
var statearr_32813_32841 = state_32807__$1;
(statearr_32813_32841[(2)] = null);

(statearr_32813_32841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32808 === (4))){
var inst_32771 = (state_32807[(13)]);
var inst_32772 = (state_32807[(14)]);
var inst_32765 = (state_32807[(12)]);
var inst_32777 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_32765,inst_32771,inst_32772,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_32765,inst_32771,inst_32772,true,fuel,max_fuel,opts));
var state_32807__$1 = state_32807;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32807__$1,(7),inst_32777);
} else {
if((state_val_32808 === (15))){
var state_32807__$1 = state_32807;
var statearr_32814_32842 = state_32807__$1;
(statearr_32814_32842[(2)] = null);

(statearr_32814_32842[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32808 === (13))){
var inst_32798 = (state_32807[(2)]);
var state_32807__$1 = state_32807;
var statearr_32815_32843 = state_32807__$1;
(statearr_32815_32843[(2)] = inst_32798);

(statearr_32815_32843[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32808 === (6))){
var inst_32803 = (state_32807[(2)]);
var state_32807__$1 = state_32807;
var statearr_32816_32844 = state_32807__$1;
(statearr_32816_32844[(2)] = inst_32803);

(statearr_32816_32844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32808 === (3))){
var inst_32805 = (state_32807[(2)]);
var state_32807__$1 = state_32807;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32807__$1,inst_32805);
} else {
if((state_val_32808 === (12))){
var state_32807__$1 = state_32807;
var statearr_32817_32845 = state_32807__$1;
(statearr_32817_32845[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32808 === (2))){
var inst_32771 = (state_32807[(13)]);
var inst_32764 = (state_32807[(10)]);
var inst_32770 = cljs.core.seq(inst_32764);
var inst_32771__$1 = cljs.core.first(inst_32770);
var inst_32772 = cljs.core.next(inst_32770);
var state_32807__$1 = (function (){var statearr_32819 = state_32807;
(statearr_32819[(13)] = inst_32771__$1);

(statearr_32819[(14)] = inst_32772);

return statearr_32819;
})();
if(cljs.core.truth_(inst_32771__$1)){
var statearr_32820_32846 = state_32807__$1;
(statearr_32820_32846[(1)] = (4));

} else {
var statearr_32821_32847 = state_32807__$1;
(statearr_32821_32847[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32808 === (11))){
var inst_32782 = (state_32807[(8)]);
var inst_32781 = (state_32807[(7)]);
var inst_32764 = inst_32782;
var inst_32765 = inst_32781;
var state_32807__$1 = (function (){var statearr_32822 = state_32807;
(statearr_32822[(10)] = inst_32764);

(statearr_32822[(12)] = inst_32765);

return statearr_32822;
})();
var statearr_32823_32848 = state_32807__$1;
(statearr_32823_32848[(2)] = null);

(statearr_32823_32848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32808 === (9))){
var inst_32771 = (state_32807[(13)]);
var inst_32787 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_32771);
var state_32807__$1 = state_32807;
if(cljs.core.truth_(inst_32787)){
var statearr_32824_32849 = state_32807__$1;
(statearr_32824_32849[(1)] = (11));

} else {
var statearr_32825_32850 = state_32807__$1;
(statearr_32825_32850[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32808 === (5))){
var inst_32765 = (state_32807[(12)]);
var state_32807__$1 = state_32807;
var statearr_32826_32851 = state_32807__$1;
(statearr_32826_32851[(2)] = inst_32765);

(statearr_32826_32851[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32808 === (14))){
var inst_32782 = (state_32807[(8)]);
var inst_32781 = (state_32807[(7)]);
var inst_32765 = (state_32807[(12)]);
var inst_32792 = fluree.db.query.analytical.left_outer_join(inst_32765,inst_32781);
var inst_32764 = inst_32782;
var inst_32765__$1 = inst_32792;
var state_32807__$1 = (function (){var statearr_32827 = state_32807;
(statearr_32827[(10)] = inst_32764);

(statearr_32827[(12)] = inst_32765__$1);

return statearr_32827;
})();
var statearr_32828_32852 = state_32807__$1;
(statearr_32828_32852[(2)] = null);

(statearr_32828_32852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32808 === (16))){
var inst_32796 = (state_32807[(2)]);
var state_32807__$1 = state_32807;
var statearr_32830_32853 = state_32807__$1;
(statearr_32830_32853[(2)] = inst_32796);

(statearr_32830_32853[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32808 === (10))){
var inst_32800 = (state_32807[(2)]);
var state_32807__$1 = state_32807;
var statearr_32831_32854 = state_32807__$1;
(statearr_32831_32854[(2)] = inst_32800);

(statearr_32831_32854[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32808 === (8))){
var inst_32782 = (state_32807[(8)]);
var inst_32765 = (state_32807[(12)]);
var tmp32829 = inst_32765;
var inst_32764 = inst_32782;
var inst_32765__$1 = tmp32829;
var state_32807__$1 = (function (){var statearr_32832 = state_32807;
(statearr_32832[(10)] = inst_32764);

(statearr_32832[(12)] = inst_32765__$1);

return statearr_32832;
})();
var statearr_32833_32855 = state_32807__$1;
(statearr_32833_32855[(2)] = null);

(statearr_32833_32855[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11438__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11438__auto____0 = (function (){
var statearr_32834 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32834[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11438__auto__);

(statearr_32834[(1)] = (1));

return statearr_32834;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11438__auto____1 = (function (state_32807){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_32807);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e32835){var ex__11441__auto__ = e32835;
var statearr_32836_32856 = state_32807;
(statearr_32836_32856[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_32807[(4)]))){
var statearr_32837_32857 = state_32807;
(statearr_32837_32857[(1)] = cljs.core.first((state_32807[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32858 = state_32807;
state_32807 = G__32858;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11438__auto__ = function(state_32807){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11438__auto____1.call(this,state_32807);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11438__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11438__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_32838 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_32838[(6)] = c__11512__auto__);

return statearr_32838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__32860){
var vec__32861 = p__32860;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32861,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32861,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32859_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__32859_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__32865,p__32866,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__32867 = p__32865;
var map__32867__$1 = cljs.core.__destructure_map(map__32867);
var q_map = map__32867__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32867__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__32868 = p__32866;
var map__32868__$1 = cljs.core.__destructure_map(map__32868);
var res = map__32868__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32868__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_33105){
var state_val_33106 = (state_33105[(1)]);
if((state_val_33106 === (65))){
var inst_33055 = (state_33105[(7)]);
var inst_33054 = (state_33105[(8)]);
var inst_33066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33067 = fluree.db.query.analytical.full_text__GT_tuples(inst_33054,res,inst_33055);
var inst_33068 = [inst_33067,r];
var inst_33069 = (new cljs.core.PersistentVector(null,2,(5),inst_33066,inst_33068,null));
var state_33105__$1 = state_33105;
var statearr_33107_33220 = state_33105__$1;
(statearr_33107_33220[(2)] = inst_33069);

(statearr_33107_33220[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (70))){
var inst_33081 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33108_33221 = state_33105__$1;
(statearr_33108_33221[(2)] = inst_33081);

(statearr_33108_33221[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (62))){
var inst_33055 = (state_33105[(7)]);
var inst_33063 = cljs.core.second(inst_33055);
var inst_33064 = clojure.string.starts_with_QMARK_(inst_33063,"fullText:");
var state_33105__$1 = state_33105;
if(inst_33064){
var statearr_33109_33222 = state_33105__$1;
(statearr_33109_33222[(1)] = (65));

} else {
var statearr_33110_33223 = state_33105__$1;
(statearr_33110_33223[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (7))){
var inst_32974 = (state_33105[(9)]);
var inst_32973 = cljs.core.count(clause);
var inst_32974__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_32973);
var state_33105__$1 = (function (){var statearr_33111 = state_33105;
(statearr_33111[(9)] = inst_32974__$1);

return statearr_33111;
})();
if(inst_32974__$1){
var statearr_33112_33224 = state_33105__$1;
(statearr_33112_33224[(1)] = (31));

} else {
var statearr_33113_33225 = state_33105__$1;
(statearr_33113_33225[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (59))){
var inst_33088 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33114_33226 = state_33105__$1;
(statearr_33114_33226[(2)] = inst_33088);

(statearr_33114_33226[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (20))){
var inst_32937 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33115_33227 = state_33105__$1;
(statearr_33115_33227[(2)] = inst_32937);

(statearr_33115_33227[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (58))){
var state_33105__$1 = state_33105;
var statearr_33116_33228 = state_33105__$1;
(statearr_33116_33228[(2)] = null);

(statearr_33116_33228[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (60))){
var inst_33054 = (state_33105[(8)]);
var inst_33052 = (state_33105[(2)]);
var inst_33053 = fluree.db.util.async.throw_err(inst_33052);
var inst_33054__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33053,(0),null);
var inst_33055 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33053,(1),null);
var inst_33056 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_33054__$1);
var state_33105__$1 = (function (){var statearr_33117 = state_33105;
(statearr_33117[(7)] = inst_33055);

(statearr_33117[(8)] = inst_33054__$1);

return statearr_33117;
})();
if(inst_33056){
var statearr_33118_33229 = state_33105__$1;
(statearr_33118_33229[(1)] = (61));

} else {
var statearr_33119_33230 = state_33105__$1;
(statearr_33119_33230[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (27))){
var inst_32967 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33120_33231 = state_33105__$1;
(statearr_33120_33231[(2)] = inst_32967);

(statearr_33120_33231[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (1))){
var state_33105__$1 = state_33105;
var statearr_33121_33232 = state_33105__$1;
(statearr_33121_33232[(2)] = null);

(statearr_33121_33232[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (69))){
var state_33105__$1 = state_33105;
var statearr_33122_33233 = state_33105__$1;
(statearr_33122_33233[(2)] = null);

(statearr_33122_33233[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (24))){
var inst_32931 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33123_33234 = state_33105__$1;
(statearr_33123_33234[(2)] = inst_32931);

(statearr_33123_33234[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (55))){
var inst_33037 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_33038 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_33039 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_33040 = cljs.core.PersistentHashMap.fromArrays(inst_33038,inst_33039);
var inst_33041 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33037,inst_33040);
var inst_33042 = (function(){throw inst_33041})();
var state_33105__$1 = state_33105;
var statearr_33124_33235 = state_33105__$1;
(statearr_33124_33235[(2)] = inst_33042);

(statearr_33124_33235[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (39))){
var inst_32994 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
if(cljs.core.truth_(inst_32994)){
var statearr_33125_33236 = state_33105__$1;
(statearr_33125_33236[(1)] = (40));

} else {
var statearr_33126_33237 = state_33105__$1;
(statearr_33126_33237[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (46))){
var inst_33094 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33127_33238 = state_33105__$1;
(statearr_33127_33238[(2)] = inst_33094);

(statearr_33127_33238[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (4))){
var inst_32869 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33128_33239 = state_33105__$1;
(statearr_33128_33239[(2)] = inst_32869);

(statearr_33128_33239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (54))){
var inst_33030 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_33031 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_33032 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_33033 = cljs.core.PersistentHashMap.fromArrays(inst_33031,inst_33032);
var inst_33034 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33030,inst_33033);
var inst_33035 = (function(){throw inst_33034})();
var state_33105__$1 = state_33105;
var statearr_33129_33240 = state_33105__$1;
(statearr_33129_33240[(2)] = inst_33035);

(statearr_33129_33240[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (15))){
var inst_32969 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33130_33241 = state_33105__$1;
(statearr_33130_33241[(2)] = inst_32969);

(statearr_33130_33241[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (48))){
var inst_33018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33019 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_33020 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_33019);
var inst_33021 = [inst_33020,r];
var inst_33022 = (new cljs.core.PersistentVector(null,2,(5),inst_33018,inst_33021,null));
var state_33105__$1 = state_33105;
var statearr_33131_33242 = state_33105__$1;
(statearr_33131_33242[(2)] = inst_33022);

(statearr_33131_33242[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (50))){
var inst_33092 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33132_33243 = state_33105__$1;
(statearr_33132_33243[(2)] = inst_33092);

(statearr_33132_33243[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (21))){
var inst_32882 = (state_33105[(10)]);
var inst_32915 = (state_33105[(11)]);
var inst_32878 = (state_33105[(12)]);
var inst_32914 = (state_33105[(13)]);
var inst_32908 = (state_33105[(14)]);
var inst_32906 = (state_33105[(15)]);
var inst_32905 = (state_33105[(16)]);
var inst_32903 = (state_33105[(17)]);
var inst_32907 = (state_33105[(18)]);
var inst_32919 = (state_33105[(2)]);
var inst_32920 = fluree.db.util.async.throw_err(inst_32919);
var inst_32921 = (function (){var new_res = inst_32920;
var first__32912 = inst_32914;
var rest = inst_32915;
var tuples = inst_32908;
var seq__32901 = inst_32906;
var pred__32879 = inst_32882;
var vec__32900 = inst_32903;
var vec__32910 = inst_32907;
var seq__32911 = inst_32915;
var first__32902 = inst_32905;
var segment_type = inst_32878;
var G__32899 = inst_32907;
var expr__32880 = inst_32878;
var clause_group = inst_32914;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_32922 = cljs.core.keys(vars);
var inst_32923 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32921,inst_32920,inst_32922);
var inst_32924 = fluree.db.query.analytical.res_absorb_vars(inst_32923);
var state_33105__$1 = (function (){var statearr_33133 = state_33105;
(statearr_33133[(19)] = inst_32924);

return statearr_33133;
})();
if(cljs.core.truth_(inst_32908)){
var statearr_33134_33244 = state_33105__$1;
(statearr_33134_33244[(1)] = (22));

} else {
var statearr_33135_33245 = state_33105__$1;
(statearr_33135_33245[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (31))){
var inst_32976 = cljs.core.second(clause);
var inst_32977 = clojure.string.starts_with_QMARK_(inst_32976,"fullText:");
var state_33105__$1 = state_33105;
var statearr_33136_33246 = state_33105__$1;
(statearr_33136_33246[(2)] = inst_32977);

(statearr_33136_33246[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (32))){
var inst_32974 = (state_33105[(9)]);
var state_33105__$1 = state_33105;
var statearr_33137_33247 = state_33105__$1;
(statearr_33137_33247[(2)] = inst_32974);

(statearr_33137_33247[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (40))){
var inst_32996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32997 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_33105__$1 = (function (){var statearr_33138 = state_33105;
(statearr_33138[(20)] = inst_32996);

return statearr_33138;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33105__$1,(43),inst_32997);
} else {
if((state_val_33106 === (56))){
var inst_33044 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33139_33248 = state_33105__$1;
(statearr_33139_33248[(2)] = inst_33044);

(statearr_33139_33248[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (33))){
var inst_32980 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
if(cljs.core.truth_(inst_32980)){
var statearr_33140_33249 = state_33105__$1;
(statearr_33140_33249[(1)] = (34));

} else {
var statearr_33141_33250 = state_33105__$1;
(statearr_33141_33250[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (13))){
var inst_32903 = (state_33105[(17)]);
var inst_32903__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_32904 = cljs.core.seq(inst_32903__$1);
var inst_32905 = cljs.core.first(inst_32904);
var inst_32906 = cljs.core.next(inst_32904);
var inst_32907 = inst_32903__$1;
var inst_32908 = null;
var state_33105__$1 = (function (){var statearr_33142 = state_33105;
(statearr_33142[(14)] = inst_32908);

(statearr_33142[(15)] = inst_32906);

(statearr_33142[(16)] = inst_32905);

(statearr_33142[(17)] = inst_32903__$1);

(statearr_33142[(18)] = inst_32907);

return statearr_33142;
})();
var statearr_33143_33251 = state_33105__$1;
(statearr_33143_33251[(2)] = null);

(statearr_33143_33251[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (22))){
var inst_32915 = (state_33105[(11)]);
var inst_32924 = (state_33105[(19)]);
var inst_32908 = (state_33105[(14)]);
var inst_32926 = fluree.db.query.union.results(inst_32908,inst_32924);
var inst_32907 = inst_32915;
var inst_32908__$1 = inst_32926;
var state_33105__$1 = (function (){var statearr_33144 = state_33105;
(statearr_33144[(14)] = inst_32908__$1);

(statearr_33144[(18)] = inst_32907);

return statearr_33144;
})();
var statearr_33145_33252 = state_33105__$1;
(statearr_33145_33252[(2)] = null);

(statearr_33145_33252[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (36))){
var inst_33098 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33146_33253 = state_33105__$1;
(statearr_33146_33253[(2)] = inst_33098);

(statearr_33146_33253[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (41))){
var inst_33004 = cljs.core.count(clause);
var inst_33005 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_33004);
var state_33105__$1 = state_33105;
if(inst_33005){
var statearr_33147_33254 = state_33105__$1;
(statearr_33147_33254[(1)] = (44));

} else {
var statearr_33148_33255 = state_33105__$1;
(statearr_33148_33255[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (43))){
var inst_32996 = (state_33105[(20)]);
var inst_32999 = (state_33105[(2)]);
var inst_33000 = fluree.db.util.async.throw_err(inst_32999);
var inst_33001 = [inst_33000,r];
var inst_33002 = (new cljs.core.PersistentVector(null,2,(5),inst_32996,inst_33001,null));
var state_33105__$1 = state_33105;
var statearr_33149_33256 = state_33105__$1;
(statearr_33149_33256[(2)] = inst_33002);

(statearr_33149_33256[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (61))){
var inst_33055 = (state_33105[(7)]);
var inst_33058 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_33055,r,res,optional_QMARK_,fuel,max_fuel);
var state_33105__$1 = state_33105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33105__$1,(64),inst_33058);
} else {
if((state_val_33106 === (29))){
var inst_32878 = (state_33105[(12)]);
var inst_32961 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32878)].join('');
var inst_32962 = (new Error(inst_32961));
var inst_32963 = (function(){throw inst_32962})();
var state_33105__$1 = state_33105;
var statearr_33150_33257 = state_33105__$1;
(statearr_33150_33257[(2)] = inst_32963);

(statearr_33150_33257[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (44))){
var inst_33007 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33008 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_33105__$1 = (function (){var statearr_33151 = state_33105;
(statearr_33151[(21)] = inst_33007);

return statearr_33151;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33105__$1,(47),inst_33008);
} else {
if((state_val_33106 === (6))){
var inst_32882 = (state_33105[(10)]);
var inst_32878 = (state_33105[(12)]);
var inst_32877 = cljs.core.keys(clause);
var inst_32878__$1 = cljs.core.first(inst_32877);
var inst_32882__$1 = cljs.core._EQ_;
var inst_32883 = (function (){var G__33152 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__33153 = inst_32878__$1;
return (inst_32882__$1.cljs$core$IFn$_invoke$arity$2 ? inst_32882__$1.cljs$core$IFn$_invoke$arity$2(G__33152,G__33153) : inst_32882__$1.call(null,G__33152,G__33153));
})();
var state_33105__$1 = (function (){var statearr_33154 = state_33105;
(statearr_33154[(10)] = inst_32882__$1);

(statearr_33154[(12)] = inst_32878__$1);

return statearr_33154;
})();
if(cljs.core.truth_(inst_32883)){
var statearr_33155_33258 = state_33105__$1;
(statearr_33155_33258[(1)] = (9));

} else {
var statearr_33156_33259 = state_33105__$1;
(statearr_33156_33259[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (28))){
var inst_32955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32956 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_32957 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_32956,optional_QMARK_);
var inst_32958 = [inst_32957,r];
var inst_32959 = (new cljs.core.PersistentVector(null,2,(5),inst_32955,inst_32958,null));
var state_33105__$1 = state_33105;
var statearr_33157_33260 = state_33105__$1;
(statearr_33157_33260[(2)] = inst_32959);

(statearr_33157_33260[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (64))){
var inst_33060 = (state_33105[(2)]);
var inst_33061 = fluree.db.util.async.throw_err(inst_33060);
var state_33105__$1 = state_33105;
var statearr_33158_33261 = state_33105__$1;
(statearr_33158_33261[(2)] = inst_33061);

(statearr_33158_33261[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (51))){
var inst_33027 = cljs.core.first(clause);
var inst_33028 = cljs.core.sequential_QMARK_(inst_33027);
var state_33105__$1 = state_33105;
if(inst_33028){
var statearr_33159_33262 = state_33105__$1;
(statearr_33159_33262[(1)] = (54));

} else {
var statearr_33160_33263 = state_33105__$1;
(statearr_33160_33263[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (25))){
var inst_32882 = (state_33105[(10)]);
var inst_32878 = (state_33105[(12)]);
var inst_32943 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_32944 = (function (){var segment_type = inst_32878;
var pred__32879 = inst_32882;
var expr__32880 = inst_32878;
var bindings = inst_32943;
return (function (p1__32864_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__32864_SHARP_);
});
})();
var inst_32945 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_32944,inst_32943);
var inst_32946 = cljs.core.PersistentHashMap.EMPTY;
var inst_32947 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32946,inst_32945);
var inst_32948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32949 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_32947);
var inst_32950 = [inst_32949,r];
var inst_32951 = (new cljs.core.PersistentVector(null,2,(5),inst_32948,inst_32950,null));
var state_33105__$1 = state_33105;
var statearr_33161_33264 = state_33105__$1;
(statearr_33161_33264[(2)] = inst_32951);

(statearr_33161_33264[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (34))){
var inst_32982 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32983 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_32984 = [inst_32983,r];
var inst_32985 = (new cljs.core.PersistentVector(null,2,(5),inst_32982,inst_32984,null));
var state_33105__$1 = state_33105;
var statearr_33162_33265 = state_33105__$1;
(statearr_33162_33265[(2)] = inst_32985);

(statearr_33162_33265[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (17))){
var inst_32939 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33163_33266 = state_33105__$1;
(statearr_33163_33266[(2)] = inst_32939);

(statearr_33163_33266[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (3))){
var inst_33103 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33105__$1,inst_33103);
} else {
if((state_val_33106 === (12))){
var inst_32885 = (state_33105[(22)]);
var inst_32889 = (state_33105[(2)]);
var inst_32890 = fluree.db.util.async.throw_err(inst_32889);
var inst_32891 = [inst_32890,r];
var inst_32892 = (new cljs.core.PersistentVector(null,2,(5),inst_32885,inst_32891,null));
var state_33105__$1 = state_33105;
var statearr_33164_33267 = state_33105__$1;
(statearr_33164_33267[(2)] = inst_32892);

(statearr_33164_33267[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (2))){
var _ = (function (){var statearr_33165 = state_33105;
(statearr_33165[(4)] = cljs.core.cons((5),(state_33105[(4)])));

return statearr_33165;
})();
var inst_32875 = cljs.core.map_QMARK_(clause);
var state_33105__$1 = state_33105;
if(inst_32875){
var statearr_33166_33268 = state_33105__$1;
(statearr_33166_33268[(1)] = (6));

} else {
var statearr_33167_33269 = state_33105__$1;
(statearr_33167_33269[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (66))){
var state_33105__$1 = state_33105;
var statearr_33168_33270 = state_33105__$1;
(statearr_33168_33270[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (23))){
var inst_32915 = (state_33105[(11)]);
var inst_32924 = (state_33105[(19)]);
var inst_32907 = inst_32915;
var inst_32908 = inst_32924;
var state_33105__$1 = (function (){var statearr_33170 = state_33105;
(statearr_33170[(14)] = inst_32908);

(statearr_33170[(18)] = inst_32907);

return statearr_33170;
})();
var statearr_33171_33271 = state_33105__$1;
(statearr_33171_33271[(2)] = null);

(statearr_33171_33271[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (47))){
var inst_33007 = (state_33105[(21)]);
var inst_33010 = (state_33105[(2)]);
var inst_33011 = fluree.db.util.async.throw_err(inst_33010);
var inst_33012 = [inst_33011,r];
var inst_33013 = (new cljs.core.PersistentVector(null,2,(5),inst_33007,inst_33012,null));
var state_33105__$1 = state_33105;
var statearr_33172_33272 = state_33105__$1;
(statearr_33172_33272[(2)] = inst_33013);

(statearr_33172_33272[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (35))){
var inst_32988 = (state_33105[(23)]);
var inst_32987 = cljs.core.count(clause);
var inst_32988__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_32987);
var state_33105__$1 = (function (){var statearr_33173 = state_33105;
(statearr_33173[(23)] = inst_32988__$1);

return statearr_33173;
})();
if(inst_32988__$1){
var statearr_33174_33273 = state_33105__$1;
(statearr_33174_33273[(1)] = (37));

} else {
var statearr_33175_33274 = state_33105__$1;
(statearr_33175_33274[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (19))){
var inst_32908 = (state_33105[(14)]);
var inst_32933 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32934 = [inst_32908,r];
var inst_32935 = (new cljs.core.PersistentVector(null,2,(5),inst_32933,inst_32934,null));
var state_33105__$1 = state_33105;
var statearr_33176_33275 = state_33105__$1;
(statearr_33176_33275[(2)] = inst_32935);

(statearr_33176_33275[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (57))){
var inst_33050 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_33105__$1 = state_33105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33105__$1,(60),inst_33050);
} else {
if((state_val_33106 === (68))){
var inst_33055 = (state_33105[(7)]);
var inst_33054 = (state_33105[(8)]);
var inst_33072 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33073 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_33054,res,inst_33055,fuel,max_fuel);
var state_33105__$1 = (function (){var statearr_33177 = state_33105;
(statearr_33177[(24)] = inst_33072);

return statearr_33177;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33105__$1,(71),inst_33073);
} else {
if((state_val_33106 === (11))){
var inst_32971 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33179_33276 = state_33105__$1;
(statearr_33179_33276[(2)] = inst_32971);

(statearr_33179_33276[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (9))){
var inst_32885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32886 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_32887 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_32886,res,fuel,max_fuel,opts);
var state_33105__$1 = (function (){var statearr_33180 = state_33105;
(statearr_33180[(22)] = inst_32885);

return statearr_33180;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33105__$1,(12),inst_32887);
} else {
if((state_val_33106 === (5))){
var _ = (function (){var statearr_33181 = state_33105;
(statearr_33181[(4)] = cljs.core.rest((state_33105[(4)])));

return statearr_33181;
})();
var state_33105__$1 = state_33105;
var ex33178 = (state_33105__$1[(2)]);
var statearr_33182_33277 = state_33105__$1;
(statearr_33182_33277[(5)] = ex33178);


if((ex33178 instanceof Error)){
var statearr_33183_33278 = state_33105__$1;
(statearr_33183_33278[(1)] = (4));

(statearr_33183_33278[(5)] = null);

} else {
throw ex33178;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (14))){
var inst_32882 = (state_33105[(10)]);
var inst_32878 = (state_33105[(12)]);
var inst_32941 = (function (){var G__33184 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__33185 = inst_32878;
return (inst_32882.cljs$core$IFn$_invoke$arity$2 ? inst_32882.cljs$core$IFn$_invoke$arity$2(G__33184,G__33185) : inst_32882.call(null,G__33184,G__33185));
})();
var state_33105__$1 = state_33105;
if(cljs.core.truth_(inst_32941)){
var statearr_33186_33279 = state_33105__$1;
(statearr_33186_33279[(1)] = (25));

} else {
var statearr_33187_33280 = state_33105__$1;
(statearr_33187_33280[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (45))){
var inst_33015 = cljs.core.count(clause);
var inst_33016 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_33015);
var state_33105__$1 = state_33105;
if(inst_33016){
var statearr_33188_33281 = state_33105__$1;
(statearr_33188_33281[(1)] = (48));

} else {
var statearr_33189_33282 = state_33105__$1;
(statearr_33189_33282[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (53))){
var inst_33090 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33190_33283 = state_33105__$1;
(statearr_33190_33283[(2)] = inst_33090);

(statearr_33190_33283[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (26))){
var inst_32882 = (state_33105[(10)]);
var inst_32878 = (state_33105[(12)]);
var inst_32953 = (function (){var G__33191 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__33192 = inst_32878;
return (inst_32882.cljs$core$IFn$_invoke$arity$2 ? inst_32882.cljs$core$IFn$_invoke$arity$2(G__33191,G__33192) : inst_32882.call(null,G__33191,G__33192));
})();
var state_33105__$1 = state_33105;
if(cljs.core.truth_(inst_32953)){
var statearr_33193_33284 = state_33105__$1;
(statearr_33193_33284[(1)] = (28));

} else {
var statearr_33194_33285 = state_33105__$1;
(statearr_33194_33285[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (16))){
var inst_32914 = (state_33105[(13)]);
var inst_32907 = (state_33105[(18)]);
var inst_32913 = cljs.core.seq(inst_32907);
var inst_32914__$1 = cljs.core.first(inst_32913);
var inst_32915 = cljs.core.next(inst_32913);
var state_33105__$1 = (function (){var statearr_33195 = state_33105;
(statearr_33195[(11)] = inst_32915);

(statearr_33195[(13)] = inst_32914__$1);

return statearr_33195;
})();
if(cljs.core.truth_(inst_32914__$1)){
var statearr_33196_33286 = state_33105__$1;
(statearr_33196_33286[(1)] = (18));

} else {
var statearr_33197_33287 = state_33105__$1;
(statearr_33197_33287[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (38))){
var inst_32988 = (state_33105[(23)]);
var state_33105__$1 = state_33105;
var statearr_33198_33288 = state_33105__$1;
(statearr_33198_33288[(2)] = inst_32988);

(statearr_33198_33288[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (30))){
var inst_32965 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33199_33289 = state_33105__$1;
(statearr_33199_33289[(2)] = inst_32965);

(statearr_33199_33289[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (10))){
var inst_32882 = (state_33105[(10)]);
var inst_32878 = (state_33105[(12)]);
var inst_32894 = (function (){var G__33200 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__33201 = inst_32878;
return (inst_32882.cljs$core$IFn$_invoke$arity$2 ? inst_32882.cljs$core$IFn$_invoke$arity$2(G__33200,G__33201) : inst_32882.call(null,G__33200,G__33201));
})();
var state_33105__$1 = state_33105;
if(cljs.core.truth_(inst_32894)){
var statearr_33202_33290 = state_33105__$1;
(statearr_33202_33290[(1)] = (13));

} else {
var statearr_33203_33291 = state_33105__$1;
(statearr_33203_33291[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (18))){
var inst_32914 = (state_33105[(13)]);
var inst_32917 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_32914,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_32914,q_map,vars,fuel,max_fuel,opts));
var state_33105__$1 = state_33105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33105__$1,(21),inst_32917);
} else {
if((state_val_33106 === (52))){
var state_33105__$1 = state_33105;
var statearr_33204_33292 = state_33105__$1;
(statearr_33204_33292[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (67))){
var inst_33083 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33206_33293 = state_33105__$1;
(statearr_33206_33293[(2)] = inst_33083);

(statearr_33206_33293[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (71))){
var inst_33072 = (state_33105[(24)]);
var inst_33075 = (state_33105[(2)]);
var inst_33076 = fluree.db.util.async.throw_err(inst_33075);
var inst_33077 = [inst_33076,r];
var inst_33078 = (new cljs.core.PersistentVector(null,2,(5),inst_33072,inst_33077,null));
var state_33105__$1 = state_33105;
var statearr_33207_33294 = state_33105__$1;
(statearr_33207_33294[(2)] = inst_33078);

(statearr_33207_33294[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (42))){
var inst_33096 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33208_33295 = state_33105__$1;
(statearr_33208_33295[(2)] = inst_33096);

(statearr_33208_33295[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (37))){
var inst_32990 = cljs.core.second(clause);
var inst_32991 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32990,"rdf:type");
var state_33105__$1 = state_33105;
var statearr_33209_33296 = state_33105__$1;
(statearr_33209_33296[(2)] = inst_32991);

(statearr_33209_33296[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (63))){
var inst_33085 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33210_33297 = state_33105__$1;
(statearr_33210_33297[(2)] = inst_33085);

(statearr_33210_33297[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (8))){
var inst_33100 = (state_33105[(2)]);
var _ = (function (){var statearr_33211 = state_33105;
(statearr_33211[(4)] = cljs.core.rest((state_33105[(4)])));

return statearr_33211;
})();
var state_33105__$1 = state_33105;
var statearr_33212_33298 = state_33105__$1;
(statearr_33212_33298[(2)] = inst_33100);

(statearr_33212_33298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (49))){
var inst_33024 = cljs.core.count(clause);
var inst_33025 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_33024);
var state_33105__$1 = state_33105;
if(inst_33025){
var statearr_33213_33299 = state_33105__$1;
(statearr_33213_33299[(1)] = (51));

} else {
var statearr_33214_33300 = state_33105__$1;
(statearr_33214_33300[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11438__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11438__auto____0 = (function (){
var statearr_33215 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33215[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11438__auto__);

(statearr_33215[(1)] = (1));

return statearr_33215;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11438__auto____1 = (function (state_33105){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_33105);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e33216){var ex__11441__auto__ = e33216;
var statearr_33217_33301 = state_33105;
(statearr_33217_33301[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_33105[(4)]))){
var statearr_33218_33302 = state_33105;
(statearr_33218_33302[(1)] = cljs.core.first((state_33105[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33303 = state_33105;
state_33105 = G__33303;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11438__auto__ = function(state_33105){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11438__auto____1.call(this,state_33105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11438__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11438__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_33219 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_33219[(6)] = c__11512__auto__);

return statearr_33219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__33305 = arguments.length;
switch (G__33305) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_33385){
var state_val_33386 = (state_33385[(1)]);
if((state_val_33386 === (7))){
var inst_33380 = (state_33385[(2)]);
var _ = (function (){var statearr_33387 = state_33385;
(statearr_33387[(4)] = cljs.core.rest((state_33385[(4)])));

return statearr_33387;
})();
var state_33385__$1 = state_33385;
var statearr_33388_33436 = state_33385__$1;
(statearr_33388_33436[(2)] = inst_33380);

(statearr_33388_33436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (20))){
var inst_33345 = (state_33385[(7)]);
var inst_33357 = (state_33385[(2)]);
var inst_33327 = inst_33345;
var inst_33328 = inst_33357;
var state_33385__$1 = (function (){var statearr_33389 = state_33385;
(statearr_33389[(8)] = inst_33328);

(statearr_33389[(9)] = inst_33327);

return statearr_33389;
})();
var statearr_33390_33437 = state_33385__$1;
(statearr_33390_33437[(2)] = null);

(statearr_33390_33437[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (1))){
var state_33385__$1 = state_33385;
var statearr_33391_33438 = state_33385__$1;
(statearr_33391_33438[(2)] = null);

(statearr_33391_33438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (24))){
var inst_33328 = (state_33385[(8)]);
var inst_33344 = (state_33385[(10)]);
var inst_33345 = (state_33385[(7)]);
var inst_33365 = fluree.db.query.analytical.inner_join(inst_33328,inst_33344);
var inst_33327 = inst_33345;
var inst_33328__$1 = inst_33365;
var state_33385__$1 = (function (){var statearr_33392 = state_33385;
(statearr_33392[(8)] = inst_33328__$1);

(statearr_33392[(9)] = inst_33327);

return statearr_33392;
})();
var statearr_33393_33439 = state_33385__$1;
(statearr_33393_33439[(2)] = null);

(statearr_33393_33439[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (4))){
var inst_33306 = (state_33385[(2)]);
var state_33385__$1 = state_33385;
var statearr_33395_33440 = state_33385__$1;
(statearr_33395_33440[(2)] = inst_33306);

(statearr_33395_33440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (15))){
var inst_33344 = (state_33385[(10)]);
var state_33385__$1 = state_33385;
if(cljs.core.truth_(inst_33344)){
var statearr_33396_33441 = state_33385__$1;
(statearr_33396_33441[(1)] = (18));

} else {
var statearr_33397_33442 = state_33385__$1;
(statearr_33397_33442[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (21))){
var inst_33328 = (state_33385[(8)]);
var inst_33345 = (state_33385[(7)]);
var tmp33394 = inst_33328;
var inst_33327 = inst_33345;
var inst_33328__$1 = tmp33394;
var state_33385__$1 = (function (){var statearr_33398 = state_33385;
(statearr_33398[(8)] = inst_33328__$1);

(statearr_33398[(9)] = inst_33327);

return statearr_33398;
})();
var statearr_33399_33443 = state_33385__$1;
(statearr_33399_33443[(2)] = null);

(statearr_33399_33443[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (13))){
var inst_33328 = (state_33385[(8)]);
var inst_33351 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_33328,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_33352 = cljs.core.empty_QMARK_(inst_33351);
var state_33385__$1 = state_33385;
if(inst_33352){
var statearr_33400_33444 = state_33385__$1;
(statearr_33400_33444[(1)] = (15));

} else {
var statearr_33401_33445 = state_33385__$1;
(statearr_33401_33445[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (22))){
var state_33385__$1 = state_33385;
var statearr_33402_33446 = state_33385__$1;
(statearr_33402_33446[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (6))){
var inst_33334 = (state_33385[(11)]);
var inst_33327 = (state_33385[(9)]);
var inst_33333 = cljs.core.seq(inst_33327);
var inst_33334__$1 = cljs.core.first(inst_33333);
var inst_33335 = cljs.core.next(inst_33333);
var state_33385__$1 = (function (){var statearr_33404 = state_33385;
(statearr_33404[(11)] = inst_33334__$1);

(statearr_33404[(12)] = inst_33335);

return statearr_33404;
})();
if(cljs.core.truth_(inst_33334__$1)){
var statearr_33405_33447 = state_33385__$1;
(statearr_33405_33447[(1)] = (8));

} else {
var statearr_33406_33448 = state_33385__$1;
(statearr_33406_33448[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (25))){
var state_33385__$1 = state_33385;
var statearr_33407_33449 = state_33385__$1;
(statearr_33407_33449[(2)] = null);

(statearr_33407_33449[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (17))){
var inst_33373 = (state_33385[(2)]);
var state_33385__$1 = state_33385;
var statearr_33408_33450 = state_33385__$1;
(statearr_33408_33450[(2)] = inst_33373);

(statearr_33408_33450[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (3))){
var inst_33383 = (state_33385[(2)]);
var state_33385__$1 = state_33385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33385__$1,inst_33383);
} else {
if((state_val_33386 === (12))){
var inst_33344 = (state_33385[(10)]);
var inst_33345 = (state_33385[(7)]);
var inst_33327 = inst_33345;
var inst_33328 = inst_33344;
var state_33385__$1 = (function (){var statearr_33409 = state_33385;
(statearr_33409[(8)] = inst_33328);

(statearr_33409[(9)] = inst_33327);

return statearr_33409;
})();
var statearr_33410_33451 = state_33385__$1;
(statearr_33410_33451[(2)] = null);

(statearr_33410_33451[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (2))){
var _ = (function (){var statearr_33411 = state_33385;
(statearr_33411[(4)] = cljs.core.cons((5),(state_33385[(4)])));

return statearr_33411;
})();
var inst_33319 = where;
var inst_33320 = cljs.core.seq(inst_33319);
var inst_33321 = cljs.core.first(inst_33320);
var inst_33322 = cljs.core.next(inst_33320);
var inst_33323 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_33324 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_33325 = [inst_33324];
var inst_33326 = cljs.core.PersistentHashMap.fromArrays(inst_33323,inst_33325);
var inst_33327 = inst_33319;
var inst_33328 = inst_33326;
var state_33385__$1 = (function (){var statearr_33412 = state_33385;
(statearr_33412[(8)] = inst_33328);

(statearr_33412[(9)] = inst_33327);

(statearr_33412[(13)] = inst_33321);

(statearr_33412[(14)] = inst_33322);

return statearr_33412;
})();
var statearr_33413_33452 = state_33385__$1;
(statearr_33413_33452[(2)] = null);

(statearr_33413_33452[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (23))){
var inst_33371 = (state_33385[(2)]);
var state_33385__$1 = state_33385;
var statearr_33414_33453 = state_33385__$1;
(statearr_33414_33453[(2)] = inst_33371);

(statearr_33414_33453[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (19))){
var inst_33328 = (state_33385[(8)]);
var state_33385__$1 = state_33385;
var statearr_33415_33454 = state_33385__$1;
(statearr_33415_33454[(2)] = inst_33328);

(statearr_33415_33454[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (11))){
var inst_33334 = (state_33385[(11)]);
var inst_33342 = (state_33385[(2)]);
var inst_33343 = fluree.db.util.async.throw_err(inst_33342);
var inst_33344 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33343,(0),null);
var inst_33345 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33343,(1),null);
var inst_33346 = cljs.core.count(inst_33334);
var inst_33347 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_33346);
var state_33385__$1 = (function (){var statearr_33417 = state_33385;
(statearr_33417[(10)] = inst_33344);

(statearr_33417[(7)] = inst_33345);

return statearr_33417;
})();
if(inst_33347){
var statearr_33418_33455 = state_33385__$1;
(statearr_33418_33455[(1)] = (12));

} else {
var statearr_33419_33456 = state_33385__$1;
(statearr_33419_33456[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (9))){
var inst_33328 = (state_33385[(8)]);
var state_33385__$1 = state_33385;
var statearr_33420_33457 = state_33385__$1;
(statearr_33420_33457[(2)] = inst_33328);

(statearr_33420_33457[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (5))){
var _ = (function (){var statearr_33421 = state_33385;
(statearr_33421[(4)] = cljs.core.rest((state_33385[(4)])));

return statearr_33421;
})();
var state_33385__$1 = state_33385;
var ex33416 = (state_33385__$1[(2)]);
var statearr_33422_33458 = state_33385__$1;
(statearr_33422_33458[(5)] = ex33416);


if((ex33416 instanceof Error)){
var statearr_33423_33459 = state_33385__$1;
(statearr_33423_33459[(1)] = (4));

(statearr_33423_33459[(5)] = null);

} else {
throw ex33416;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (14))){
var inst_33375 = (state_33385[(2)]);
var state_33385__$1 = state_33385;
var statearr_33424_33460 = state_33385__$1;
(statearr_33424_33460[(2)] = inst_33375);

(statearr_33424_33460[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (26))){
var inst_33369 = (state_33385[(2)]);
var state_33385__$1 = state_33385;
var statearr_33425_33461 = state_33385__$1;
(statearr_33425_33461[(2)] = inst_33369);

(statearr_33425_33461[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (16))){
var inst_33344 = (state_33385[(10)]);
var inst_33360 = (inst_33344 == null);
var state_33385__$1 = state_33385;
if(cljs.core.truth_(inst_33360)){
var statearr_33426_33462 = state_33385__$1;
(statearr_33426_33462[(1)] = (21));

} else {
var statearr_33427_33463 = state_33385__$1;
(statearr_33427_33463[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (10))){
var inst_33378 = (state_33385[(2)]);
var state_33385__$1 = state_33385;
var statearr_33428_33464 = state_33385__$1;
(statearr_33428_33464[(2)] = inst_33378);

(statearr_33428_33464[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (18))){
var inst_33344 = (state_33385[(10)]);
var state_33385__$1 = state_33385;
var statearr_33429_33465 = state_33385__$1;
(statearr_33429_33465[(2)] = inst_33344);

(statearr_33429_33465[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33386 === (8))){
var inst_33328 = (state_33385[(8)]);
var inst_33334 = (state_33385[(11)]);
var inst_33335 = (state_33385[(12)]);
var inst_33340 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_33328,inst_33334,inst_33335,false,fuel,max_fuel,opts);
var state_33385__$1 = state_33385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33385__$1,(11),inst_33340);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__11438__auto__ = null;
var fluree$db$query$analytical$state_machine__11438__auto____0 = (function (){
var statearr_33430 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33430[(0)] = fluree$db$query$analytical$state_machine__11438__auto__);

(statearr_33430[(1)] = (1));

return statearr_33430;
});
var fluree$db$query$analytical$state_machine__11438__auto____1 = (function (state_33385){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_33385);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e33431){var ex__11441__auto__ = e33431;
var statearr_33432_33466 = state_33385;
(statearr_33432_33466[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_33385[(4)]))){
var statearr_33433_33467 = state_33385;
(statearr_33433_33467[(1)] = cljs.core.first((state_33385[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33468 = state_33385;
state_33385 = G__33468;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__11438__auto__ = function(state_33385){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__11438__auto____1.call(this,state_33385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__11438__auto____0;
fluree$db$query$analytical$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__11438__auto____1;
return fluree$db$query$analytical$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_33434 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_33434[(6)] = c__11512__auto__);

return statearr_33434;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_33503){
var state_val_33504 = (state_33503[(1)]);
if((state_val_33504 === (7))){
var inst_33480 = (state_33503[(7)]);
var inst_33485 = (state_33503[(8)]);
var inst_33487 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_33480,inst_33485,fuel,max_fuel,opts);
var state_33503__$1 = state_33503;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33503__$1,(10),inst_33487);
} else {
if((state_val_33504 === (1))){
var state_33503__$1 = state_33503;
var statearr_33505_33530 = state_33503__$1;
(statearr_33505_33530[(2)] = null);

(statearr_33505_33530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33504 === (4))){
var inst_33469 = (state_33503[(2)]);
var state_33503__$1 = state_33503;
var statearr_33506_33531 = state_33503__$1;
(statearr_33506_33531[(2)] = inst_33469);

(statearr_33506_33531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33504 === (13))){
var inst_33498 = (state_33503[(2)]);
var _ = (function (){var statearr_33507 = state_33503;
(statearr_33507[(4)] = cljs.core.rest((state_33503[(4)])));

return statearr_33507;
})();
var state_33503__$1 = state_33503;
var statearr_33508_33532 = state_33503__$1;
(statearr_33508_33532[(2)] = inst_33498);

(statearr_33508_33532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33504 === (6))){
var inst_33480 = (state_33503[(7)]);
var inst_33484 = (state_33503[(2)]);
var inst_33485 = fluree.db.util.async.throw_err(inst_33484);
var state_33503__$1 = (function (){var statearr_33509 = state_33503;
(statearr_33509[(8)] = inst_33485);

return statearr_33509;
})();
if(cljs.core.truth_(inst_33480)){
var statearr_33510_33533 = state_33503__$1;
(statearr_33510_33533[(1)] = (7));

} else {
var statearr_33511_33534 = state_33503__$1;
(statearr_33511_33534[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33504 === (3))){
var inst_33501 = (state_33503[(2)]);
var state_33503__$1 = state_33503;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33503__$1,inst_33501);
} else {
if((state_val_33504 === (12))){
var inst_33493 = (state_33503[(9)]);
var state_33503__$1 = state_33503;
var statearr_33512_33535 = state_33503__$1;
(statearr_33512_33535[(2)] = inst_33493);

(statearr_33512_33535[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33504 === (2))){
var _ = (function (){var statearr_33513 = state_33503;
(statearr_33513[(4)] = cljs.core.cons((5),(state_33503[(4)])));

return statearr_33513;
})();
var inst_33476 = q_map;
var inst_33477 = cljs.core.__destructure_map(inst_33476);
var inst_33478 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33477,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_33479 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33477,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_33480 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33477,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_33481 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33477,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_33482 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_33479,q_map,inst_33478,fuel,max_fuel,opts);
var state_33503__$1 = (function (){var statearr_33514 = state_33503;
(statearr_33514[(7)] = inst_33480);

(statearr_33514[(10)] = inst_33481);

return statearr_33514;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33503__$1,(6),inst_33482);
} else {
if((state_val_33504 === (11))){
var inst_33481 = (state_33503[(10)]);
var inst_33493 = (state_33503[(9)]);
var inst_33495 = fluree.db.query.analytical.tuples__GT_filtered(inst_33493,inst_33481,null);
var state_33503__$1 = state_33503;
var statearr_33516_33536 = state_33503__$1;
(statearr_33516_33536[(2)] = inst_33495);

(statearr_33516_33536[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33504 === (9))){
var inst_33481 = (state_33503[(10)]);
var inst_33493 = (state_33503[(2)]);
var state_33503__$1 = (function (){var statearr_33517 = state_33503;
(statearr_33517[(9)] = inst_33493);

return statearr_33517;
})();
if(cljs.core.truth_(inst_33481)){
var statearr_33518_33537 = state_33503__$1;
(statearr_33518_33537[(1)] = (11));

} else {
var statearr_33519_33538 = state_33503__$1;
(statearr_33519_33538[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33504 === (5))){
var _ = (function (){var statearr_33520 = state_33503;
(statearr_33520[(4)] = cljs.core.rest((state_33503[(4)])));

return statearr_33520;
})();
var state_33503__$1 = state_33503;
var ex33515 = (state_33503__$1[(2)]);
var statearr_33521_33539 = state_33503__$1;
(statearr_33521_33539[(5)] = ex33515);


if((ex33515 instanceof Error)){
var statearr_33522_33540 = state_33503__$1;
(statearr_33522_33540[(1)] = (4));

(statearr_33522_33540[(5)] = null);

} else {
throw ex33515;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33504 === (10))){
var inst_33489 = (state_33503[(2)]);
var inst_33490 = fluree.db.util.async.throw_err(inst_33489);
var state_33503__$1 = state_33503;
var statearr_33523_33541 = state_33503__$1;
(statearr_33523_33541[(2)] = inst_33490);

(statearr_33523_33541[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33504 === (8))){
var inst_33485 = (state_33503[(8)]);
var state_33503__$1 = state_33503;
var statearr_33524_33542 = state_33503__$1;
(statearr_33524_33542[(2)] = inst_33485);

(statearr_33524_33542[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__11438__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__11438__auto____0 = (function (){
var statearr_33525 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33525[(0)] = fluree$db$query$analytical$q_$_state_machine__11438__auto__);

(statearr_33525[(1)] = (1));

return statearr_33525;
});
var fluree$db$query$analytical$q_$_state_machine__11438__auto____1 = (function (state_33503){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_33503);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e33526){var ex__11441__auto__ = e33526;
var statearr_33527_33543 = state_33503;
(statearr_33527_33543[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_33503[(4)]))){
var statearr_33528_33544 = state_33503;
(statearr_33528_33544[(1)] = cljs.core.first((state_33503[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33545 = state_33503;
state_33503 = G__33545;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__11438__auto__ = function(state_33503){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__11438__auto____1.call(this,state_33503);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__11438__auto____0;
fluree$db$query$analytical$q_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__11438__auto____1;
return fluree$db$query$analytical$q_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_33529 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_33529[(6)] = c__11512__auto__);

return statearr_33529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
