// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31560_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31560_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__31564 = coll;
var vec__31565 = G__31564;
var seq__31566 = cljs.core.seq(vec__31565);
var first__31567 = cljs.core.first(seq__31566);
var seq__31566__$1 = cljs.core.next(seq__31566);
var clause = first__31567;
var r = seq__31566__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__31564__$1 = G__31564;
var res__$1 = res;
while(true){
var vec__31571 = G__31564__$1;
var seq__31572 = cljs.core.seq(vec__31571);
var first__31573 = cljs.core.first(seq__31572);
var seq__31572__$1 = cljs.core.next(seq__31572);
var clause__$1 = first__31573;
var r__$1 = seq__31572__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__31574 = r__$1;
var G__31575 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__31564__$1 = G__31574;
res__$1 = G__31575;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__31576){
var map__31577 = p__31576;
var map__31577__$1 = cljs.core.__destructure_map(map__31577);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31577__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__31581 = coll;
var vec__31582 = G__31581;
var seq__31583 = cljs.core.seq(vec__31582);
var first__31584 = cljs.core.first(seq__31583);
var seq__31583__$1 = cljs.core.next(seq__31583);
var clause = first__31584;
var r = seq__31583__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__31581__$1 = G__31581;
var res__$1 = res;
while(true){
var vec__31588 = G__31581__$1;
var seq__31589 = cljs.core.seq(vec__31588);
var first__31590 = cljs.core.first(seq__31589);
var seq__31589__$1 = cljs.core.next(seq__31589);
var clause__$1 = first__31590;
var r__$1 = seq__31589__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__31591 = r__$1;
var G__31592 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__31581__$1 = G__31591;
res__$1 = G__31592;
continue;
} else {
var G__31593 = r__$1;
var G__31594 = res__$2;
G__31581__$1 = G__31593;
res__$1 = G__31594;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__31598 = coll;
var vec__31599 = G__31598;
var seq__31600 = cljs.core.seq(vec__31599);
var first__31601 = cljs.core.first(seq__31600);
var seq__31600__$1 = cljs.core.next(seq__31600);
var clause = first__31601;
var r = seq__31600__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__31598__$1 = G__31598;
var res__$1 = res;
while(true){
var vec__31605 = G__31598__$1;
var seq__31606 = cljs.core.seq(vec__31605);
var first__31607 = cljs.core.first(seq__31606);
var seq__31606__$1 = cljs.core.next(seq__31606);
var clause__$1 = first__31607;
var r__$1 = seq__31606__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__31608 = r__$1;
var G__31609 = res__$2;
G__31598__$1 = G__31608;
res__$1 = G__31609;
continue;
} else {
var G__31610 = r__$1;
var G__31611 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__31598__$1 = G__31610;
res__$1 = G__31611;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__31614 = clause;
var G__31614__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__31614):G__31614);
var G__31614__$2 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__31614__$1)
;
var G__31614__$3 = (function (){var fexpr__31615 = (function (p1__31612_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31612_SHARP_)," ."].join('');
});
return fexpr__31615(G__31614__$2);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__31616 = (function (p1__31613_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31613_SHARP_),"}"].join('');
});
return fexpr__31616(G__31614__$3);
} else {
return G__31614__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__31620 = opts;
var map__31620__$1 = cljs.core.__destructure_map(map__31620);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31620__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31620__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31620__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31620__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31620__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31617_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31617_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__31618_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__31618_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__31619_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__31619_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = language;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_31634){
var state_val_31635 = (state_31634[(1)]);
if((state_val_31635 === (1))){
var inst_31621 = fluree.db.util.core.url_encode(query);
var inst_31622 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31621)].join('');
var inst_31623 = ["User-Agent","Accept"];
var inst_31624 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_31625 = cljs.core.PersistentHashMap.fromArrays(inst_31623,inst_31624);
var inst_31626 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_31627 = [inst_31625,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_31628 = cljs.core.PersistentHashMap.fromArrays(inst_31626,inst_31627);
var inst_31629 = fluree.db.util.xhttp.get(inst_31622,inst_31628);
var state_31634__$1 = state_31634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31634__$1,(2),inst_31629);
} else {
if((state_val_31635 === (2))){
var inst_31631 = (state_31634[(2)]);
var inst_31632 = fluree.db.util.async.throw_err(inst_31631);
var state_31634__$1 = state_31634;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31634__$1,inst_31632);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11438__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11438__auto____0 = (function (){
var statearr_31636 = [null,null,null,null,null,null,null];
(statearr_31636[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11438__auto__);

(statearr_31636[(1)] = (1));

return statearr_31636;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11438__auto____1 = (function (state_31634){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_31634);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e31637){var ex__11441__auto__ = e31637;
var statearr_31638_31641 = state_31634;
(statearr_31638_31641[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_31634[(4)]))){
var statearr_31639_31642 = state_31634;
(statearr_31639_31642[(1)] = cljs.core.first((state_31634[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31643 = state_31634;
state_31634 = G__31643;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11438__auto__ = function(state_31634){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11438__auto____1.call(this,state_31634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11438__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11438__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_31640 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_31640[(6)] = c__11512__auto__);

return statearr_31640;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_31661){
var state_val_31662 = (state_31661[(1)]);
if((state_val_31662 === (1))){
var inst_31644 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_31661__$1 = state_31661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31661__$1,(2),inst_31644);
} else {
if((state_val_31662 === (2))){
var inst_31647 = (state_31661[(7)]);
var inst_31646 = (state_31661[(2)]);
var inst_31647__$1 = fluree.db.util.async.throw_err(inst_31646);
var inst_31648 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_31647__$1);
var inst_31649 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_31648);
var state_31661__$1 = (function (){var statearr_31663 = state_31661;
(statearr_31663[(7)] = inst_31647__$1);

return statearr_31663;
})();
if(inst_31649){
var statearr_31664_31673 = state_31661__$1;
(statearr_31664_31673[(1)] = (3));

} else {
var statearr_31665_31674 = state_31661__$1;
(statearr_31665_31674[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31662 === (3))){
var inst_31647 = (state_31661[(7)]);
var state_31661__$1 = state_31661;
var statearr_31666_31675 = state_31661__$1;
(statearr_31666_31675[(2)] = inst_31647);

(statearr_31666_31675[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31662 === (4))){
var inst_31647 = (state_31661[(7)]);
var inst_31652 = (function (){var body = inst_31647;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_31653 = cljs.core.second(inst_31647);
var inst_31654 = cljs.core.second(inst_31653);
var inst_31655 = cljs.core.first(inst_31654);
var inst_31656 = cljs.core.second(inst_31655);
var inst_31657 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_31652,inst_31656);
var state_31661__$1 = state_31661;
var statearr_31667_31676 = state_31661__$1;
(statearr_31667_31676[(2)] = inst_31657);

(statearr_31667_31676[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31662 === (5))){
var inst_31659 = (state_31661[(2)]);
var state_31661__$1 = state_31661;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31661__$1,inst_31659);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11438__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11438__auto____0 = (function (){
var statearr_31668 = [null,null,null,null,null,null,null,null];
(statearr_31668[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11438__auto__);

(statearr_31668[(1)] = (1));

return statearr_31668;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11438__auto____1 = (function (state_31661){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_31661);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e31669){var ex__11441__auto__ = e31669;
var statearr_31670_31677 = state_31661;
(statearr_31670_31677[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_31661[(4)]))){
var statearr_31671_31678 = state_31661;
(statearr_31671_31678[(1)] = cljs.core.first((state_31661[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31679 = state_31661;
state_31661 = G__31679;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11438__auto__ = function(state_31661){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11438__auto____1.call(this,state_31661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11438__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11438__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_31672 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_31672[(6)] = c__11512__auto__);

return statearr_31672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31680_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31680_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31681_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31681_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31682_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__31682_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__31682_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__31682_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_31728){
var state_val_31729 = (state_31728[(1)]);
if((state_val_31729 === (7))){
var inst_31693 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_31728__$1 = state_31728;
var statearr_31730_31758 = state_31728__$1;
(statearr_31730_31758[(2)] = inst_31693);

(statearr_31730_31758[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31729 === (1))){
var state_31728__$1 = state_31728;
var statearr_31731_31759 = state_31728__$1;
(statearr_31731_31759[(2)] = null);

(statearr_31731_31759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31729 === (4))){
var inst_31683 = (state_31728[(2)]);
var state_31728__$1 = state_31728;
var statearr_31732_31760 = state_31728__$1;
(statearr_31732_31760[(2)] = inst_31683);

(statearr_31732_31760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31729 === (15))){
var inst_31702 = (state_31728[(7)]);
var inst_31707 = (state_31728[(8)]);
var inst_31701 = (state_31728[(9)]);
var inst_31712 = (state_31728[(2)]);
var inst_31713 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_31707,(0),inst_31712);
var inst_31714 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31715 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_31701);
var inst_31716 = [inst_31702,inst_31715];
var inst_31717 = cljs.core.PersistentHashMap.fromArrays(inst_31714,inst_31716);
var inst_31718 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31713,inst_31717);
var inst_31719 = (function(){throw inst_31718})();
var state_31728__$1 = state_31728;
var statearr_31733_31761 = state_31728__$1;
(statearr_31733_31761[(2)] = inst_31719);

(statearr_31733_31761[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31729 === (13))){
var inst_31706 = (state_31728[(10)]);
var state_31728__$1 = state_31728;
var statearr_31734_31762 = state_31728__$1;
(statearr_31734_31762[(2)] = inst_31706);

(statearr_31734_31762[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31729 === (6))){
var state_31728__$1 = state_31728;
var statearr_31735_31763 = state_31728__$1;
(statearr_31735_31763[(2)] = null);

(statearr_31735_31763[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31729 === (3))){
var inst_31726 = (state_31728[(2)]);
var state_31728__$1 = state_31728;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31728__$1,inst_31726);
} else {
if((state_val_31729 === (12))){
var inst_31723 = (state_31728[(2)]);
var _ = (function (){var statearr_31736 = state_31728;
(statearr_31736[(4)] = cljs.core.rest((state_31728[(4)])));

return statearr_31736;
})();
var state_31728__$1 = state_31728;
var statearr_31737_31764 = state_31728__$1;
(statearr_31737_31764[(2)] = inst_31723);

(statearr_31737_31764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31729 === (2))){
var _ = (function (){var statearr_31738 = state_31728;
(statearr_31738[(4)] = cljs.core.cons((5),(state_31728[(4)])));

return statearr_31738;
})();
var inst_31690 = cljs.core.empty_QMARK_(matching_vars);
var state_31728__$1 = state_31728;
if(inst_31690){
var statearr_31739_31765 = state_31728__$1;
(statearr_31739_31765[(1)] = (6));

} else {
var statearr_31740_31766 = state_31728__$1;
(statearr_31740_31766[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31729 === (11))){
var inst_31701 = (state_31728[(9)]);
var inst_31721 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_31701,all_vars);
var state_31728__$1 = state_31728;
var statearr_31742_31767 = state_31728__$1;
(statearr_31742_31767[(2)] = inst_31721);

(statearr_31742_31767[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31729 === (9))){
var inst_31702 = (state_31728[(7)]);
var inst_31701 = (state_31728[(9)]);
var inst_31699 = (state_31728[(2)]);
var inst_31700 = fluree.db.util.async.throw_err(inst_31699);
var inst_31701__$1 = cljs.core.__destructure_map(inst_31700);
var inst_31702__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31701__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_31703 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31701__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_31704 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_31702__$1);
var state_31728__$1 = (function (){var statearr_31743 = state_31728;
(statearr_31743[(7)] = inst_31702__$1);

(statearr_31743[(11)] = inst_31703);

(statearr_31743[(9)] = inst_31701__$1);

return statearr_31743;
})();
if(inst_31704){
var statearr_31744_31768 = state_31728__$1;
(statearr_31744_31768[(1)] = (10));

} else {
var statearr_31745_31769 = state_31728__$1;
(statearr_31745_31769[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31729 === (5))){
var _ = (function (){var statearr_31746 = state_31728;
(statearr_31746[(4)] = cljs.core.rest((state_31728[(4)])));

return statearr_31746;
})();
var state_31728__$1 = state_31728;
var ex31741 = (state_31728__$1[(2)]);
var statearr_31747_31770 = state_31728__$1;
(statearr_31747_31770[(5)] = ex31741);


if((ex31741 instanceof Error)){
var statearr_31748_31771 = state_31728__$1;
(statearr_31748_31771[(1)] = (4));

(statearr_31748_31771[(5)] = null);

} else {
throw ex31741;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31729 === (14))){
var state_31728__$1 = state_31728;
var statearr_31749_31772 = state_31728__$1;
(statearr_31749_31772[(2)] = (1000));

(statearr_31749_31772[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31729 === (10))){
var inst_31703 = (state_31728[(11)]);
var inst_31706 = (state_31728[(10)]);
var inst_31701 = (state_31728[(9)]);
var inst_31706__$1 = cljs.core.count(inst_31703);
var inst_31707 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_31701);
var inst_31708 = (inst_31706__$1 < (1000));
var state_31728__$1 = (function (){var statearr_31750 = state_31728;
(statearr_31750[(8)] = inst_31707);

(statearr_31750[(10)] = inst_31706__$1);

return statearr_31750;
})();
if(cljs.core.truth_(inst_31708)){
var statearr_31751_31773 = state_31728__$1;
(statearr_31751_31773[(1)] = (13));

} else {
var statearr_31752_31774 = state_31728__$1;
(statearr_31752_31774[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31729 === (8))){
var inst_31695 = (state_31728[(2)]);
var inst_31696 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_31695,optional_clauses);
var inst_31697 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_31696);
var state_31728__$1 = state_31728;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31728__$1,(9),inst_31697);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11438__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11438__auto____0 = (function (){
var statearr_31753 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31753[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11438__auto__);

(statearr_31753[(1)] = (1));

return statearr_31753;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11438__auto____1 = (function (state_31728){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_31728);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e31754){var ex__11441__auto__ = e31754;
var statearr_31755_31775 = state_31728;
(statearr_31755_31775[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_31728[(4)]))){
var statearr_31756_31776 = state_31728;
(statearr_31756_31776[(1)] = cljs.core.first((state_31728[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31777 = state_31728;
state_31728 = G__31777;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11438__auto__ = function(state_31728){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11438__auto____1.call(this,state_31728);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11438__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11438__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_31757 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_31757[(6)] = c__11512__auto__);

return statearr_31757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
