// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__33800 = arguments.length;
switch (G__33800) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__33801 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33801) : f.call(null,G__33801));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__33802 = cljs.core._deref(vol);
var G__33803 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33802,G__33803) : f.call(null,G__33802,G__33803));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__33804 = cljs.core._deref(vol);
var G__33805 = arg1;
var G__33806 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33804,G__33805,G__33806) : f.call(null,G__33804,G__33805,G__33806));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__33807 = cljs.core._deref(vol);
var G__33808 = arg1;
var G__33809 = arg2;
var G__33810 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__33807,G__33808,G__33809,G__33810) : f.call(null,G__33807,G__33808,G__33809,G__33810));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__33813 = arguments.length;
switch (G__33813) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__33815 = null;
var G__33815__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__33815__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__33815__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__33815 = function(result,flake){
switch(arguments.length){
case 0:
return G__33815__0.call(this);
case 1:
return G__33815__1.call(this,result);
case 2:
return G__33815__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33815.cljs$core$IFn$_invoke$arity$0 = G__33815__0;
G__33815.cljs$core$IFn$_invoke$arity$1 = G__33815__1;
G__33815.cljs$core$IFn$_invoke$arity$2 = G__33815__2;
return G__33815;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__33816 = null;
var G__33816__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__33816__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__33816__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,cljs.core.count(flakes));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__33816 = function(result,flakes){
switch(arguments.length){
case 0:
return G__33816__0.call(this);
case 1:
return G__33816__1.call(this,result);
case 2:
return G__33816__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33816.cljs$core$IFn$_invoke$arity$0 = G__33816__0;
G__33816.cljs$core$IFn$_invoke$arity$1 = G__33816__1;
G__33816.cljs$core$IFn$_invoke$arity$2 = G__33816__2;
return G__33816;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__33818 = res;
var G__33818__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__33817_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__33817_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__33818):G__33818);
var G__33818__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__33818__$1):G__33818__$1);
var G__33818__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__33818__$2):G__33818__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__33818__$3);
} else {
return G__33818__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__33822 = arguments.length;
switch (G__33822) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_34261){
var state_val_34262 = (state_34261[(1)]);
if((state_val_34262 === (121))){
var inst_34184 = (state_34261[(2)]);
var inst_34185 = fluree.db.util.async.throw_err(inst_34184);
var inst_34186 = cljs.core.seq(inst_34185);
var state_34261__$1 = state_34261;
if(inst_34186){
var statearr_34263_34477 = state_34261__$1;
(statearr_34263_34477[(1)] = (122));

} else {
var statearr_34264_34478 = state_34261__$1;
(statearr_34264_34478[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (65))){
var inst_33977 = (state_34261[(7)]);
var inst_33976 = (state_34261[(2)]);
var inst_33977__$1 = fluree.db.util.async.throw_err(inst_33976);
var inst_33978 = cljs.core.seq(inst_33977__$1);
var state_34261__$1 = (function (){var statearr_34265 = state_34261;
(statearr_34265[(7)] = inst_33977__$1);

return statearr_34265;
})();
if(inst_33978){
var statearr_34266_34479 = state_34261__$1;
(statearr_34266_34479[(1)] = (66));

} else {
var statearr_34267_34480 = state_34261__$1;
(statearr_34267_34480[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (70))){
var inst_33977 = (state_34261[(7)]);
var inst_33988 = cljs.core.count(inst_33977);
var inst_33989 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_33988);
var state_34261__$1 = state_34261;
var statearr_34268_34481 = state_34261__$1;
(statearr_34268_34481[(2)] = inst_33989);

(statearr_34268_34481[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (62))){
var inst_33967 = (state_34261[(8)]);
var inst_33970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33971 = inst_33967.o;
var inst_33972 = [inst_33971];
var inst_33973 = (new cljs.core.PersistentVector(null,1,(5),inst_33970,inst_33972,null));
var inst_33974 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_33973);
var state_34261__$1 = state_34261;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34261__$1,(65),inst_33974);
} else {
if((state_val_34262 === (74))){
var inst_33961 = (state_34261[(9)]);
var state_34261__$1 = state_34261;
var statearr_34269_34482 = state_34261__$1;
(statearr_34269_34482[(2)] = inst_33961);

(statearr_34269_34482[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (110))){
var inst_34146 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_34147 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_34146);
var inst_34148 = inst_34147 === true;
var state_34261__$1 = state_34261;
if(cljs.core.truth_(inst_34148)){
var statearr_34270_34483 = state_34261__$1;
(statearr_34270_34483[(1)] = (113));

} else {
var statearr_34271_34484 = state_34261__$1;
(statearr_34271_34484[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (130))){
var inst_34256 = (state_34261[(2)]);
var _ = (function (){var statearr_34272 = state_34261;
(statearr_34272[(4)] = cljs.core.rest((state_34261[(4)])));

return statearr_34272;
})();
var state_34261__$1 = state_34261;
var statearr_34273_34485 = state_34261__$1;
(statearr_34273_34485[(2)] = inst_34256);

(statearr_34273_34485[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (128))){
var inst_34231 = (state_34261[(10)]);
var inst_34234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34235 = [acc,inst_34231];
var inst_34236 = (new cljs.core.PersistentVector(null,2,(5),inst_34234,inst_34235,null));
var state_34261__$1 = state_34261;
var statearr_34274_34486 = state_34261__$1;
(statearr_34274_34486[(2)] = inst_34236);

(statearr_34274_34486[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (7))){
var inst_33834 = (state_34261[(11)]);
var state_34261__$1 = state_34261;
var statearr_34275_34487 = state_34261__$1;
(statearr_34275_34487[(2)] = inst_33834);

(statearr_34275_34487[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (59))){
var inst_34225 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34276_34488 = state_34261__$1;
(statearr_34276_34488[(2)] = inst_34225);

(statearr_34276_34488[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (86))){
var inst_34055 = (state_34261[(12)]);
var inst_34055__$1 = (state_34261[(2)]);
var state_34261__$1 = (function (){var statearr_34277 = state_34261;
(statearr_34277[(12)] = inst_34055__$1);

return statearr_34277;
})();
if(cljs.core.truth_(inst_34055__$1)){
var statearr_34278_34489 = state_34261__$1;
(statearr_34278_34489[(1)] = (88));

} else {
var statearr_34279_34490 = state_34261__$1;
(statearr_34279_34490[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (20))){
var inst_33875 = (state_34261[(13)]);
var inst_33876 = (state_34261[(14)]);
var inst_33863 = (state_34261[(15)]);
var inst_33874 = (state_34261[(2)]);
var inst_33875__$1 = cljs.core.__destructure_map(inst_33863);
var inst_33876__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33875__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_33877 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33875__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_33878 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33875__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_33879 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33875__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_33880 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33875__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_33881 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33875__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_34261__$1 = (function (){var statearr_34280 = state_34261;
(statearr_34280[(16)] = inst_33881);

(statearr_34280[(17)] = inst_33878);

(statearr_34280[(18)] = inst_33880);

(statearr_34280[(19)] = inst_33874);

(statearr_34280[(20)] = inst_33877);

(statearr_34280[(13)] = inst_33875__$1);

(statearr_34280[(14)] = inst_33876__$1);

(statearr_34280[(21)] = inst_33879);

return statearr_34280;
})();
if(cljs.core.truth_(inst_33876__$1)){
var statearr_34281_34491 = state_34261__$1;
(statearr_34281_34491[(1)] = (24));

} else {
var statearr_34282_34492 = state_34261__$1;
(statearr_34282_34492[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (72))){
var inst_33986 = (state_34261[(22)]);
var inst_33992 = (state_34261[(2)]);
var inst_33993 = cljs.core.seq(inst_33986);
var state_34261__$1 = (function (){var statearr_34283 = state_34261;
(statearr_34283[(23)] = inst_33992);

return statearr_34283;
})();
if(inst_33993){
var statearr_34284_34493 = state_34261__$1;
(statearr_34284_34493[(1)] = (73));

} else {
var statearr_34285_34494 = state_34261__$1;
(statearr_34285_34494[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (58))){
var inst_33863 = (state_34261[(15)]);
var inst_34008 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_33863);
var state_34261__$1 = state_34261;
if(cljs.core.truth_(inst_34008)){
var statearr_34286_34495 = state_34261__$1;
(statearr_34286_34495[(1)] = (76));

} else {
var statearr_34287_34496 = state_34261__$1;
(statearr_34287_34496[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (60))){
var inst_33960 = (state_34261[(24)]);
var inst_33967 = (state_34261[(8)]);
var inst_33966 = cljs.core.seq(inst_33960);
var inst_33967__$1 = cljs.core.first(inst_33966);
var inst_33968 = cljs.core.next(inst_33966);
var state_34261__$1 = (function (){var statearr_34288 = state_34261;
(statearr_34288[(8)] = inst_33967__$1);

(statearr_34288[(25)] = inst_33968);

return statearr_34288;
})();
if(cljs.core.truth_(inst_33967__$1)){
var statearr_34289_34497 = state_34261__$1;
(statearr_34289_34497[(1)] = (62));

} else {
var statearr_34290_34498 = state_34261__$1;
(statearr_34290_34498[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (27))){
var inst_33880 = (state_34261[(18)]);
var inst_33884 = (state_34261[(26)]);
var inst_33884__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_33880);
var state_34261__$1 = (function (){var statearr_34291 = state_34261;
(statearr_34291[(26)] = inst_33884__$1);

return statearr_34291;
})();
if(inst_33884__$1){
var statearr_34292_34499 = state_34261__$1;
(statearr_34292_34499[(1)] = (30));

} else {
var statearr_34293_34500 = state_34261__$1;
(statearr_34293_34500[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (1))){
var state_34261__$1 = state_34261;
var statearr_34294_34501 = state_34261__$1;
(statearr_34294_34501[(2)] = null);

(statearr_34294_34501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (69))){
var inst_33982 = (state_34261[(2)]);
var inst_33983 = fluree.db.util.async.throw_err(inst_33982);
var state_34261__$1 = state_34261;
var statearr_34295_34502 = state_34261__$1;
(statearr_34295_34502[(2)] = inst_33983);

(statearr_34295_34502[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (101))){
var inst_34139 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34296_34503 = state_34261__$1;
(statearr_34296_34503[(2)] = inst_34139);

(statearr_34296_34503[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (24))){
var inst_33880 = (state_34261[(18)]);
var state_34261__$1 = state_34261;
if(cljs.core.truth_(inst_33880)){
var statearr_34297_34504 = state_34261__$1;
(statearr_34297_34504[(1)] = (27));

} else {
var statearr_34298_34505 = state_34261__$1;
(statearr_34298_34505[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (102))){
var inst_34111 = (state_34261[(27)]);
var inst_34110 = (state_34261[(2)]);
var inst_34111__$1 = fluree.db.util.async.throw_err(inst_34110);
var inst_34112 = cljs.core.empty_QMARK_(inst_34111__$1);
var state_34261__$1 = (function (){var statearr_34299 = state_34261;
(statearr_34299[(27)] = inst_34111__$1);

return statearr_34299;
})();
if(inst_34112){
var statearr_34300_34506 = state_34261__$1;
(statearr_34300_34506[(1)] = (103));

} else {
var statearr_34301_34507 = state_34261__$1;
(statearr_34301_34507[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (135))){
var state_34261__$1 = state_34261;
var statearr_34302_34508 = state_34261__$1;
(statearr_34302_34508[(2)] = null);

(statearr_34302_34508[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (55))){
var inst_33863 = (state_34261[(15)]);
var inst_33936 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_33863);
var state_34261__$1 = state_34261;
var statearr_34303_34509 = state_34261__$1;
(statearr_34303_34509[(2)] = inst_33936);

(statearr_34303_34509[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (85))){
var inst_34030 = (state_34261[(28)]);
var inst_33863 = (state_34261[(15)]);
var inst_34042 = inst_34030.o;
var inst_34043 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_33863);
var inst_34044 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_34042,inst_34043);
var state_34261__$1 = state_34261;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34261__$1,(87),inst_34044);
} else {
if((state_val_34262 === (39))){
var inst_33911 = (state_34261[(29)]);
var inst_33879 = (state_34261[(21)]);
var inst_33911__$1 = cljs.core.not(inst_33879);
var state_34261__$1 = (function (){var statearr_34304 = state_34261;
(statearr_34304[(29)] = inst_33911__$1);

return statearr_34304;
})();
if(inst_33911__$1){
var statearr_34305_34510 = state_34261__$1;
(statearr_34305_34510[(1)] = (42));

} else {
var statearr_34306_34511 = state_34261__$1;
(statearr_34306_34511[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (88))){
var inst_34024 = (state_34261[(30)]);
var inst_34055 = (state_34261[(12)]);
var inst_34057 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34024,inst_34055);
var state_34261__$1 = state_34261;
var statearr_34307_34512 = state_34261__$1;
(statearr_34307_34512[(2)] = inst_34057);

(statearr_34307_34512[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (46))){
var inst_33878 = (state_34261[(17)]);
var state_34261__$1 = state_34261;
var statearr_34308_34513 = state_34261__$1;
(statearr_34308_34513[(2)] = inst_33878);

(statearr_34308_34513[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (4))){
var inst_33823 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34309_34514 = state_34261__$1;
(statearr_34309_34514[(2)] = inst_33823);

(statearr_34309_34514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (77))){
var inst_34070 = (state_34261[(31)]);
var inst_34070__$1 = componentFollow_QMARK_;
var state_34261__$1 = (function (){var statearr_34310 = state_34261;
(statearr_34310[(31)] = inst_34070__$1);

return statearr_34310;
})();
if(cljs.core.truth_(inst_34070__$1)){
var statearr_34311_34515 = state_34261__$1;
(statearr_34311_34515[(1)] = (91));

} else {
var statearr_34312_34516 = state_34261__$1;
(statearr_34312_34516[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (106))){
var inst_34091 = (state_34261[(32)]);
var inst_34125 = (state_34261[(2)]);
var inst_34126 = fluree.db.util.async.throw_err(inst_34125);
var inst_34127 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34091,inst_34126);
var state_34261__$1 = state_34261;
var statearr_34313_34517 = state_34261__$1;
(statearr_34313_34517[(2)] = inst_34127);

(statearr_34313_34517[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (119))){
var inst_34169 = (state_34261[(33)]);
var inst_34199 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34200 = [inst_34169,offset_map];
var inst_34201 = (new cljs.core.PersistentVector(null,2,(5),inst_34199,inst_34200,null));
var state_34261__$1 = state_34261;
var statearr_34314_34518 = state_34261__$1;
(statearr_34314_34518[(2)] = inst_34201);

(statearr_34314_34518[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (95))){
var inst_33877 = (state_34261[(20)]);
var state_34261__$1 = state_34261;
if(cljs.core.truth_(inst_33877)){
var statearr_34315_34519 = state_34261__$1;
(statearr_34315_34519[(1)] = (110));

} else {
var statearr_34316_34520 = state_34261__$1;
(statearr_34316_34520[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (54))){
var inst_33933 = (state_34261[(34)]);
var state_34261__$1 = state_34261;
var statearr_34317_34521 = state_34261__$1;
(statearr_34317_34521[(2)] = inst_33933);

(statearr_34317_34521[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (92))){
var inst_34070 = (state_34261[(31)]);
var state_34261__$1 = state_34261;
var statearr_34318_34522 = state_34261__$1;
(statearr_34318_34522[(2)] = inst_34070);

(statearr_34318_34522[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (104))){
var inst_34111 = (state_34261[(27)]);
var inst_33833 = (state_34261[(35)]);
var inst_34120 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_34121 = [true,inst_33833];
var inst_34122 = cljs.core.PersistentHashMap.fromArrays(inst_34120,inst_34121);
var inst_34123 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_34122,inst_34111) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_34122,inst_34111));
var state_34261__$1 = state_34261;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34261__$1,(106),inst_34123);
} else {
if((state_val_34262 === (15))){
var inst_33856 = (state_34261[(36)]);
var inst_33833 = (state_34261[(35)]);
var inst_33860 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33856,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_33833);
var state_34261__$1 = state_34261;
var statearr_34319_34523 = state_34261__$1;
(statearr_34319_34523[(2)] = inst_33860);

(statearr_34319_34523[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (48))){
var inst_33927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33928 = [null,offset_map];
var inst_33929 = (new cljs.core.PersistentVector(null,2,(5),inst_33927,inst_33928,null));
var state_34261__$1 = state_34261;
var statearr_34320_34524 = state_34261__$1;
(statearr_34320_34524[(2)] = inst_33929);

(statearr_34320_34524[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (50))){
var inst_34227 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34321_34525 = state_34261__$1;
(statearr_34321_34525[(2)] = inst_34227);

(statearr_34321_34525[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (116))){
var inst_34175 = (state_34261[(37)]);
var inst_34168 = (state_34261[(38)]);
var inst_34174 = cljs.core.seq(inst_34168);
var inst_34175__$1 = cljs.core.first(inst_34174);
var inst_34176 = cljs.core.next(inst_34174);
var state_34261__$1 = (function (){var statearr_34322 = state_34261;
(statearr_34322[(37)] = inst_34175__$1);

(statearr_34322[(39)] = inst_34176);

return statearr_34322;
})();
if(cljs.core.truth_(inst_34175__$1)){
var statearr_34323_34526 = state_34261__$1;
(statearr_34323_34526[(1)] = (118));

} else {
var statearr_34324_34527 = state_34261__$1;
(statearr_34324_34527[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (75))){
var inst_33968 = (state_34261[(25)]);
var inst_33998 = (state_34261[(2)]);
var inst_33960 = inst_33968;
var inst_33961 = inst_33998;
var state_34261__$1 = (function (){var statearr_34325 = state_34261;
(statearr_34325[(24)] = inst_33960);

(statearr_34325[(9)] = inst_33961);

return statearr_34325;
})();
var statearr_34326_34528 = state_34261__$1;
(statearr_34326_34528[(2)] = null);

(statearr_34326_34528[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (99))){
var inst_34097 = (state_34261[(40)]);
var inst_33863 = (state_34261[(15)]);
var inst_34100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34101 = inst_34097.o;
var inst_34102 = [inst_34101];
var inst_34103 = (new cljs.core.PersistentVector(null,1,(5),inst_34100,inst_34102,null));
var inst_34104 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_34105 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_33863);
var inst_34106 = [inst_34105];
var inst_34107 = cljs.core.PersistentHashMap.fromArrays(inst_34104,inst_34106);
var inst_34108 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_34103,inst_34107);
var state_34261__$1 = state_34261;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34261__$1,(102),inst_34108);
} else {
if((state_val_34262 === (21))){
var inst_33867 = (state_34261[(41)]);
var state_34261__$1 = state_34261;
var statearr_34327_34529 = state_34261__$1;
(statearr_34327_34529[(2)] = inst_33867);

(statearr_34327_34529[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (31))){
var inst_33884 = (state_34261[(26)]);
var state_34261__$1 = state_34261;
var statearr_34328_34530 = state_34261__$1;
(statearr_34328_34530[(2)] = inst_33884);

(statearr_34328_34530[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (113))){
var inst_33881 = (state_34261[(16)]);
var inst_33878 = (state_34261[(17)]);
var inst_33880 = (state_34261[(18)]);
var inst_33874 = (state_34261[(19)]);
var inst_33877 = (state_34261[(20)]);
var inst_33875 = (state_34261[(13)]);
var inst_33876 = (state_34261[(14)]);
var inst_33833 = (state_34261[(35)]);
var inst_33848 = (state_34261[(42)]);
var inst_33863 = (state_34261[(15)]);
var inst_33879 = (state_34261[(21)]);
var inst_34150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34151 = (function (){var p = inst_33881;
var pred_spec__$1 = inst_33848;
var orderBy = inst_33879;
var multi_QMARK_ = inst_33876;
var limit = inst_33878;
var map__33829 = inst_33875;
var offset = inst_33880;
var k = inst_33874;
var compact_QMARK_ = inst_33833;
var pred_spec_SINGLEQUOTE_ = inst_33863;
var ref_QMARK_ = inst_33877;
return (function (p1__33819_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[p1__33819_SHARP_.o]);
});
})();
var inst_34152 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_34151,flakes);
var inst_34153 = [inst_34152,offset_map];
var inst_34154 = (new cljs.core.PersistentVector(null,2,(5),inst_34150,inst_34153,null));
var state_34261__$1 = state_34261;
var statearr_34329_34531 = state_34261__$1;
(statearr_34329_34531[(2)] = inst_34154);

(statearr_34329_34531[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (32))){
var inst_33890 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34330_34532 = state_34261__$1;
(statearr_34330_34532[(2)] = inst_33890);

(statearr_34330_34532[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (136))){
var inst_34252 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34331_34533 = state_34261__$1;
(statearr_34331_34533[(2)] = inst_34252);

(statearr_34331_34533[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (40))){
var inst_33876 = (state_34261[(14)]);
var state_34261__$1 = state_34261;
var statearr_34332_34534 = state_34261__$1;
(statearr_34332_34534[(2)] = inst_33876);

(statearr_34332_34534[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (129))){
var inst_33876 = (state_34261[(14)]);
var state_34261__$1 = state_34261;
if(cljs.core.truth_(inst_33876)){
var statearr_34333_34535 = state_34261__$1;
(statearr_34333_34535[(1)] = (131));

} else {
var statearr_34334_34536 = state_34261__$1;
(statearr_34334_34536[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (91))){
var inst_33863 = (state_34261[(15)]);
var inst_34072 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_33863);
var state_34261__$1 = state_34261;
var statearr_34335_34537 = state_34261__$1;
(statearr_34335_34537[(2)] = inst_34072);

(statearr_34335_34537[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (117))){
var inst_34205 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34336_34538 = state_34261__$1;
(statearr_34336_34538[(2)] = inst_34205);

(statearr_34336_34538[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (108))){
var state_34261__$1 = state_34261;
var statearr_34337_34539 = state_34261__$1;
(statearr_34337_34539[(2)] = null);

(statearr_34337_34539[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (56))){
var inst_33938 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34338_34540 = state_34261__$1;
(statearr_34338_34540[(2)] = inst_33938);

(statearr_34338_34540[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (33))){
var inst_33881 = (state_34261[(16)]);
var inst_33898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33899 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_33881);
var state_34261__$1 = (function (){var statearr_34339 = state_34261;
(statearr_34339[(43)] = inst_33898);

return statearr_34339;
})();
if(cljs.core.truth_(inst_33899)){
var statearr_34340_34541 = state_34261__$1;
(statearr_34340_34541[(1)] = (36));

} else {
var statearr_34341_34542 = state_34261__$1;
(statearr_34341_34542[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (13))){
var inst_33848 = (state_34261[(42)]);
var state_34261__$1 = state_34261;
var statearr_34342_34543 = state_34261__$1;
(statearr_34342_34543[(2)] = inst_33848);

(statearr_34342_34543[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (22))){
var inst_33863 = (state_34261[(15)]);
var inst_33870 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_33863);
var state_34261__$1 = state_34261;
var statearr_34343_34544 = state_34261__$1;
(statearr_34343_34544[(2)] = inst_33870);

(statearr_34343_34544[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (90))){
var inst_34031 = (state_34261[(44)]);
var inst_34060 = (state_34261[(2)]);
var inst_34023 = inst_34031;
var inst_34024 = inst_34060;
var state_34261__$1 = (function (){var statearr_34344 = state_34261;
(statearr_34344[(30)] = inst_34024);

(statearr_34344[(45)] = inst_34023);

return statearr_34344;
})();
var statearr_34345_34545 = state_34261__$1;
(statearr_34345_34545[(2)] = null);

(statearr_34345_34545[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (109))){
var inst_34098 = (state_34261[(46)]);
var inst_34129 = (state_34261[(47)]);
var inst_34135 = (state_34261[(2)]);
var inst_34090 = inst_34098;
var inst_34091 = inst_34129;
var state_34261__$1 = (function (){var statearr_34346 = state_34261;
(statearr_34346[(32)] = inst_34091);

(statearr_34346[(48)] = inst_34135);

(statearr_34346[(49)] = inst_34090);

return statearr_34346;
})();
var statearr_34347_34546 = state_34261__$1;
(statearr_34347_34546[(2)] = null);

(statearr_34347_34546[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (36))){
var inst_33881 = (state_34261[(16)]);
var inst_33901 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_33881,cljs.core.dec);
var state_34261__$1 = state_34261;
var statearr_34348_34547 = state_34261__$1;
(statearr_34348_34547[(2)] = inst_33901);

(statearr_34348_34547[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (41))){
var inst_33925 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
if(cljs.core.truth_(inst_33925)){
var statearr_34349_34548 = state_34261__$1;
(statearr_34349_34548[(1)] = (48));

} else {
var statearr_34350_34549 = state_34261__$1;
(statearr_34350_34549[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (118))){
var inst_34175 = (state_34261[(37)]);
var inst_34178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34179 = inst_34175.o;
var inst_34180 = [inst_34179];
var inst_34181 = (new cljs.core.PersistentVector(null,1,(5),inst_34178,inst_34180,null));
var inst_34182 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_34181);
var state_34261__$1 = state_34261;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34261__$1,(121),inst_34182);
} else {
if((state_val_34262 === (89))){
var inst_34024 = (state_34261[(30)]);
var state_34261__$1 = state_34261;
var statearr_34351_34550 = state_34261__$1;
(statearr_34351_34550[(2)] = inst_34024);

(statearr_34351_34550[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (100))){
var inst_34091 = (state_34261[(32)]);
var state_34261__$1 = state_34261;
var statearr_34352_34551 = state_34261__$1;
(statearr_34352_34551[(2)] = inst_34091);

(statearr_34352_34551[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (131))){
var inst_33874 = (state_34261[(19)]);
var inst_34230 = (state_34261[(50)]);
var inst_34231 = (state_34261[(10)]);
var inst_34239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34240 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_33874,inst_34230);
var inst_34241 = [inst_34240,inst_34231];
var inst_34242 = (new cljs.core.PersistentVector(null,2,(5),inst_34239,inst_34241,null));
var state_34261__$1 = state_34261;
var statearr_34353_34552 = state_34261__$1;
(statearr_34353_34552[(2)] = inst_34242);

(statearr_34353_34552[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (122))){
var inst_34175 = (state_34261[(37)]);
var inst_34169 = (state_34261[(33)]);
var inst_34176 = (state_34261[(39)]);
var inst_34188 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_34189 = inst_34175.o;
var inst_34190 = [inst_34189];
var inst_34191 = cljs.core.PersistentHashMap.fromArrays(inst_34188,inst_34190);
var inst_34192 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34169,inst_34191);
var inst_34168 = inst_34176;
var inst_34169__$1 = inst_34192;
var state_34261__$1 = (function (){var statearr_34354 = state_34261;
(statearr_34354[(33)] = inst_34169__$1);

(statearr_34354[(38)] = inst_34168);

return statearr_34354;
})();
var statearr_34355_34553 = state_34261__$1;
(statearr_34355_34553[(2)] = null);

(statearr_34355_34553[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (43))){
var inst_33911 = (state_34261[(29)]);
var state_34261__$1 = state_34261;
var statearr_34356_34554 = state_34261__$1;
(statearr_34356_34554[(2)] = inst_33911);

(statearr_34356_34554[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (61))){
var inst_33947 = (state_34261[(51)]);
var inst_34004 = (state_34261[(2)]);
var inst_34005 = [inst_34004,offset_map];
var inst_34006 = (new cljs.core.PersistentVector(null,2,(5),inst_33947,inst_34005,null));
var state_34261__$1 = state_34261;
var statearr_34357_34555 = state_34261__$1;
(statearr_34357_34555[(2)] = inst_34006);

(statearr_34357_34555[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (29))){
var inst_33893 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34358_34556 = state_34261__$1;
(statearr_34358_34556[(2)] = inst_33893);

(statearr_34358_34556[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (44))){
var inst_33922 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34359_34557 = state_34261__$1;
(statearr_34359_34557[(2)] = inst_33922);

(statearr_34359_34557[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (93))){
var inst_34075 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
if(cljs.core.truth_(inst_34075)){
var statearr_34360_34558 = state_34261__$1;
(statearr_34360_34558[(1)] = (94));

} else {
var statearr_34361_34559 = state_34261__$1;
(statearr_34361_34559[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (6))){
var inst_33836 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_33837 = (inst_33836 == null);
var state_34261__$1 = state_34261;
var statearr_34362_34560 = state_34261__$1;
(statearr_34362_34560[(2)] = inst_33837);

(statearr_34362_34560[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (111))){
var state_34261__$1 = state_34261;
var statearr_34363_34561 = state_34261__$1;
(statearr_34363_34561[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (28))){
var inst_33880 = (state_34261[(18)]);
var state_34261__$1 = state_34261;
var statearr_34365_34562 = state_34261__$1;
(statearr_34365_34562[(2)] = inst_33880);

(statearr_34365_34562[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (134))){
var inst_33874 = (state_34261[(19)]);
var inst_34230 = (state_34261[(50)]);
var inst_34231 = (state_34261[(10)]);
var inst_34245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34246 = cljs.core.first(inst_34230);
var inst_34247 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_33874,inst_34246);
var inst_34248 = [inst_34247,inst_34231];
var inst_34249 = (new cljs.core.PersistentVector(null,2,(5),inst_34245,inst_34248,null));
var state_34261__$1 = state_34261;
var statearr_34366_34563 = state_34261__$1;
(statearr_34366_34563[(2)] = inst_34249);

(statearr_34366_34563[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (64))){
var inst_34002 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34367_34564 = state_34261__$1;
(statearr_34367_34564[(2)] = inst_34002);

(statearr_34367_34564[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (103))){
var inst_34091 = (state_34261[(32)]);
var inst_34097 = (state_34261[(40)]);
var inst_34114 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_34115 = inst_34097.o;
var inst_34116 = [inst_34115];
var inst_34117 = cljs.core.PersistentHashMap.fromArrays(inst_34114,inst_34116);
var inst_34118 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34091,inst_34117);
var state_34261__$1 = state_34261;
var statearr_34368_34565 = state_34261__$1;
(statearr_34368_34565[(2)] = inst_34118);

(statearr_34368_34565[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (51))){
var inst_33933 = (state_34261[(34)]);
var inst_33863 = (state_34261[(15)]);
var inst_33933__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_33863);
var state_34261__$1 = (function (){var statearr_34369 = state_34261;
(statearr_34369[(34)] = inst_33933__$1);

return statearr_34369;
})();
if(cljs.core.truth_(inst_33933__$1)){
var statearr_34370_34566 = state_34261__$1;
(statearr_34370_34566[(1)] = (54));

} else {
var statearr_34371_34567 = state_34261__$1;
(statearr_34371_34567[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (25))){
var inst_33876 = (state_34261[(14)]);
var state_34261__$1 = state_34261;
var statearr_34372_34568 = state_34261__$1;
(statearr_34372_34568[(2)] = inst_33876);

(statearr_34372_34568[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (34))){
var inst_33876 = (state_34261[(14)]);
var state_34261__$1 = state_34261;
if(cljs.core.truth_(inst_33876)){
var statearr_34373_34569 = state_34261__$1;
(statearr_34373_34569[(1)] = (39));

} else {
var statearr_34374_34570 = state_34261__$1;
(statearr_34374_34570[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (125))){
var inst_33881 = (state_34261[(16)]);
var inst_33878 = (state_34261[(17)]);
var inst_33880 = (state_34261[(18)]);
var inst_33874 = (state_34261[(19)]);
var inst_33877 = (state_34261[(20)]);
var inst_33875 = (state_34261[(13)]);
var inst_33876 = (state_34261[(14)]);
var inst_33833 = (state_34261[(35)]);
var inst_33848 = (state_34261[(42)]);
var inst_33863 = (state_34261[(15)]);
var inst_33879 = (state_34261[(21)]);
var inst_34210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34211 = (function (){var p = inst_33881;
var pred_spec__$1 = inst_33848;
var orderBy = inst_33879;
var multi_QMARK_ = inst_33876;
var limit = inst_33878;
var map__33829 = inst_33875;
var offset = inst_33880;
var k = inst_33874;
var compact_QMARK_ = inst_33833;
var pred_spec_SINGLEQUOTE_ = inst_33863;
var ref_QMARK_ = inst_33877;
return (function (p1__33820_SHARP_){
return p1__33820_SHARP_.o;
});
})();
var inst_34212 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_34211,flakes);
var inst_34213 = [inst_34212,offset_map];
var inst_34214 = (new cljs.core.PersistentVector(null,2,(5),inst_34210,inst_34213,null));
var state_34261__$1 = state_34261;
var statearr_34375_34571 = state_34261__$1;
(statearr_34375_34571[(2)] = inst_34214);

(statearr_34375_34571[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (17))){
var inst_33864 = (state_34261[(52)]);
var inst_33863 = (state_34261[(15)]);
var inst_33863__$1 = (state_34261[(2)]);
var inst_33864__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_33863__$1);
var state_34261__$1 = (function (){var statearr_34376 = state_34261;
(statearr_34376[(52)] = inst_33864__$1);

(statearr_34376[(15)] = inst_33863__$1);

return statearr_34376;
})();
if(cljs.core.truth_(inst_33864__$1)){
var statearr_34377_34572 = state_34261__$1;
(statearr_34377_34572[(1)] = (18));

} else {
var statearr_34378_34573 = state_34261__$1;
(statearr_34378_34573[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (3))){
var inst_34259 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34261__$1,inst_34259);
} else {
if((state_val_34262 === (12))){
var inst_33848 = (state_34261[(42)]);
var inst_33853 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33848,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_34261__$1 = state_34261;
var statearr_34379_34574 = state_34261__$1;
(statearr_34379_34574[(2)] = inst_33853);

(statearr_34379_34574[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (2))){
var inst_33834 = (state_34261[(11)]);
var _ = (function (){var statearr_34380 = state_34261;
(statearr_34380[(4)] = cljs.core.cons((5),(state_34261[(4)])));

return statearr_34380;
})();
var inst_33833 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_33834__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_34261__$1 = (function (){var statearr_34381 = state_34261;
(statearr_34381[(11)] = inst_33834__$1);

(statearr_34381[(35)] = inst_33833);

return statearr_34381;
})();
if(cljs.core.truth_(inst_33834__$1)){
var statearr_34382_34575 = state_34261__$1;
(statearr_34382_34575[(1)] = (6));

} else {
var statearr_34383_34576 = state_34261__$1;
(statearr_34383_34576[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (66))){
var inst_33946 = (state_34261[(53)]);
var inst_33977 = (state_34261[(7)]);
var inst_33980 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_33946,inst_33977) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_33946,inst_33977));
var state_34261__$1 = state_34261;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34261__$1,(69),inst_33980);
} else {
if((state_val_34262 === (107))){
var inst_34111 = (state_34261[(27)]);
var inst_34131 = cljs.core.count(inst_34111);
var inst_34132 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_34131);
var state_34261__$1 = state_34261;
var statearr_34384_34577 = state_34261__$1;
(statearr_34384_34577[(2)] = inst_34132);

(statearr_34384_34577[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (23))){
var inst_33872 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34385_34578 = state_34261__$1;
(statearr_34385_34578[(2)] = inst_33872);

(statearr_34385_34578[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (47))){
var inst_33919 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34386_34579 = state_34261__$1;
(statearr_34386_34579[(2)] = inst_33919);

(statearr_34386_34579[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (35))){
var inst_34230 = (state_34261[(50)]);
var inst_34229 = (state_34261[(2)]);
var inst_34230__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34229,(0),null);
var inst_34231 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34229,(1),null);
var inst_34232 = cljs.core.empty_QMARK_(inst_34230__$1);
var state_34261__$1 = (function (){var statearr_34387 = state_34261;
(statearr_34387[(50)] = inst_34230__$1);

(statearr_34387[(10)] = inst_34231);

return statearr_34387;
})();
if(inst_34232){
var statearr_34388_34580 = state_34261__$1;
(statearr_34388_34580[(1)] = (128));

} else {
var statearr_34389_34581 = state_34261__$1;
(statearr_34389_34581[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (127))){
var inst_34217 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34390_34582 = state_34261__$1;
(statearr_34390_34582[(2)] = inst_34217);

(statearr_34390_34582[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (82))){
var inst_34024 = (state_34261[(30)]);
var state_34261__$1 = state_34261;
var statearr_34391_34583 = state_34261__$1;
(statearr_34391_34583[(2)] = inst_34024);

(statearr_34391_34583[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (76))){
var inst_34010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34018 = flakes;
var inst_34019 = cljs.core.seq(inst_34018);
var inst_34020 = cljs.core.first(inst_34019);
var inst_34021 = cljs.core.next(inst_34019);
var inst_34022 = cljs.core.PersistentVector.EMPTY;
var inst_34023 = inst_34018;
var inst_34024 = inst_34022;
var state_34261__$1 = (function (){var statearr_34392 = state_34261;
(statearr_34392[(54)] = inst_34020);

(statearr_34392[(30)] = inst_34024);

(statearr_34392[(55)] = inst_34010);

(statearr_34392[(45)] = inst_34023);

(statearr_34392[(56)] = inst_34021);

return statearr_34392;
})();
var statearr_34393_34584 = state_34261__$1;
(statearr_34393_34584[(2)] = null);

(statearr_34393_34584[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (97))){
var inst_34097 = (state_34261[(40)]);
var inst_34090 = (state_34261[(49)]);
var inst_34096 = cljs.core.seq(inst_34090);
var inst_34097__$1 = cljs.core.first(inst_34096);
var inst_34098 = cljs.core.next(inst_34096);
var state_34261__$1 = (function (){var statearr_34394 = state_34261;
(statearr_34394[(46)] = inst_34098);

(statearr_34394[(40)] = inst_34097__$1);

return statearr_34394;
})();
if(cljs.core.truth_(inst_34097__$1)){
var statearr_34395_34585 = state_34261__$1;
(statearr_34395_34585[(1)] = (99));

} else {
var statearr_34396_34586 = state_34261__$1;
(statearr_34396_34586[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (19))){
var inst_33863 = (state_34261[(15)]);
var inst_33867 = (state_34261[(41)]);
var inst_33867__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_33863);
var state_34261__$1 = (function (){var statearr_34397 = state_34261;
(statearr_34397[(41)] = inst_33867__$1);

return statearr_34397;
})();
if(cljs.core.truth_(inst_33867__$1)){
var statearr_34398_34587 = state_34261__$1;
(statearr_34398_34587[(1)] = (21));

} else {
var statearr_34399_34588 = state_34261__$1;
(statearr_34399_34588[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (57))){
var inst_33863 = (state_34261[(15)]);
var inst_33943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33944 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_33945 = (new cljs.core.PersistentVector(null,3,(5),inst_33943,inst_33944,null));
var inst_33946 = cljs.core.select_keys(inst_33863,inst_33945);
var inst_33947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33955 = flakes;
var inst_33956 = cljs.core.seq(inst_33955);
var inst_33957 = cljs.core.first(inst_33956);
var inst_33958 = cljs.core.next(inst_33956);
var inst_33959 = cljs.core.PersistentVector.EMPTY;
var inst_33960 = inst_33955;
var inst_33961 = inst_33959;
var state_34261__$1 = (function (){var statearr_34400 = state_34261;
(statearr_34400[(24)] = inst_33960);

(statearr_34400[(57)] = inst_33957);

(statearr_34400[(9)] = inst_33961);

(statearr_34400[(58)] = inst_33958);

(statearr_34400[(53)] = inst_33946);

(statearr_34400[(51)] = inst_33947);

return statearr_34400;
})();
var statearr_34401_34589 = state_34261__$1;
(statearr_34401_34589[(2)] = null);

(statearr_34401_34589[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (68))){
var inst_33986 = (state_34261[(2)]);
var state_34261__$1 = (function (){var statearr_34402 = state_34261;
(statearr_34402[(22)] = inst_33986);

return statearr_34402;
})();
if(cljs.core.truth_(fuel)){
var statearr_34403_34590 = state_34261__$1;
(statearr_34403_34590[(1)] = (70));

} else {
var statearr_34404_34591 = state_34261__$1;
(statearr_34404_34591[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (11))){
var inst_33848 = (state_34261[(42)]);
var inst_33848__$1 = (state_34261[(2)]);
var inst_33850 = cljs.core.contains_QMARK_(inst_33848__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_33851 = (!(inst_33850));
var state_34261__$1 = (function (){var statearr_34405 = state_34261;
(statearr_34405[(42)] = inst_33848__$1);

return statearr_34405;
})();
if(inst_33851){
var statearr_34406_34592 = state_34261__$1;
(statearr_34406_34592[(1)] = (12));

} else {
var statearr_34407_34593 = state_34261__$1;
(statearr_34407_34593[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (115))){
var inst_34207 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34409_34594 = state_34261__$1;
(statearr_34409_34594[(2)] = inst_34207);

(statearr_34409_34594[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (9))){
var inst_33842 = cljs.core.first(flakes);
var inst_33843 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_33842);
var inst_33844 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_33845 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_33843,inst_33844);
var state_34261__$1 = state_34261;
var statearr_34410_34595 = state_34261__$1;
(statearr_34410_34595[(2)] = inst_33845);

(statearr_34410_34595[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (5))){
var _ = (function (){var statearr_34411 = state_34261;
(statearr_34411[(4)] = cljs.core.rest((state_34261[(4)])));

return statearr_34411;
})();
var state_34261__$1 = state_34261;
var ex34408 = (state_34261__$1[(2)]);
var statearr_34412_34596 = state_34261__$1;
(statearr_34412_34596[(5)] = ex34408);


if((ex34408 instanceof Error)){
var statearr_34413_34597 = state_34261__$1;
(statearr_34413_34597[(1)] = (4));

(statearr_34413_34597[(5)] = null);

} else {
throw ex34408;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (112))){
var inst_34219 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34414_34598 = state_34261__$1;
(statearr_34414_34598[(2)] = inst_34219);

(statearr_34414_34598[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (83))){
var inst_34064 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34415_34599 = state_34261__$1;
(statearr_34415_34599[(2)] = inst_34064);

(statearr_34415_34599[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (14))){
var inst_33848 = (state_34261[(42)]);
var inst_33856 = (state_34261[(2)]);
var inst_33857 = cljs.core.contains_QMARK_(inst_33848,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_33858 = (!(inst_33857));
var state_34261__$1 = (function (){var statearr_34416 = state_34261;
(statearr_34416[(36)] = inst_33856);

return statearr_34416;
})();
if(inst_33858){
var statearr_34417_34600 = state_34261__$1;
(statearr_34417_34600[(1)] = (15));

} else {
var statearr_34418_34601 = state_34261__$1;
(statearr_34418_34601[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (45))){
var inst_33878 = (state_34261[(17)]);
var inst_33874 = (state_34261[(19)]);
var inst_33914 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_33874);
var inst_33915 = cljs.core.count(inst_33914);
var inst_33916 = (inst_33915 >= inst_33878);
var state_34261__$1 = state_34261;
var statearr_34419_34602 = state_34261__$1;
(statearr_34419_34602[(2)] = inst_33916);

(statearr_34419_34602[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (53))){
var inst_33941 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
if(cljs.core.truth_(inst_33941)){
var statearr_34420_34603 = state_34261__$1;
(statearr_34420_34603[(1)] = (57));

} else {
var statearr_34421_34604 = state_34261__$1;
(statearr_34421_34604[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (78))){
var inst_34223 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34422_34605 = state_34261__$1;
(statearr_34422_34605[(2)] = inst_34223);

(statearr_34422_34605[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (132))){
var state_34261__$1 = state_34261;
var statearr_34424_34606 = state_34261__$1;
(statearr_34424_34606[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (26))){
var inst_33896 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
if(cljs.core.truth_(inst_33896)){
var statearr_34426_34607 = state_34261__$1;
(statearr_34426_34607[(1)] = (33));

} else {
var statearr_34427_34608 = state_34261__$1;
(statearr_34427_34608[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (123))){
var inst_34169 = (state_34261[(33)]);
var inst_34176 = (state_34261[(39)]);
var tmp34423 = inst_34169;
var inst_34168 = inst_34176;
var inst_34169__$1 = tmp34423;
var state_34261__$1 = (function (){var statearr_34428 = state_34261;
(statearr_34428[(33)] = inst_34169__$1);

(statearr_34428[(38)] = inst_34168);

return statearr_34428;
})();
var statearr_34429_34609 = state_34261__$1;
(statearr_34429_34609[(2)] = null);

(statearr_34429_34609[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (16))){
var inst_33856 = (state_34261[(36)]);
var state_34261__$1 = state_34261;
var statearr_34430_34610 = state_34261__$1;
(statearr_34430_34610[(2)] = inst_33856);

(statearr_34430_34610[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (133))){
var inst_34254 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34431_34611 = state_34261__$1;
(statearr_34431_34611[(2)] = inst_34254);

(statearr_34431_34611[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (81))){
var inst_34039 = (state_34261[(59)]);
var inst_34030 = (state_34261[(28)]);
var inst_33863 = (state_34261[(15)]);
var inst_34033 = cljs.core.deref(cache);
var inst_34034 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34035 = inst_34030.o;
var inst_34036 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_33863);
var inst_34037 = [inst_34035,inst_34036];
var inst_34038 = (new cljs.core.PersistentVector(null,2,(5),inst_34034,inst_34037,null));
var inst_34039__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34033,inst_34038);
var state_34261__$1 = (function (){var statearr_34432 = state_34261;
(statearr_34432[(59)] = inst_34039__$1);

return statearr_34432;
})();
if(cljs.core.truth_(inst_34039__$1)){
var statearr_34433_34612 = state_34261__$1;
(statearr_34433_34612[(1)] = (84));

} else {
var statearr_34434_34613 = state_34261__$1;
(statearr_34434_34613[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (120))){
var inst_34203 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34435_34614 = state_34261__$1;
(statearr_34435_34614[(2)] = inst_34203);

(statearr_34435_34614[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (79))){
var inst_34030 = (state_34261[(28)]);
var inst_34023 = (state_34261[(45)]);
var inst_34029 = cljs.core.seq(inst_34023);
var inst_34030__$1 = cljs.core.first(inst_34029);
var inst_34031 = cljs.core.next(inst_34029);
var state_34261__$1 = (function (){var statearr_34436 = state_34261;
(statearr_34436[(28)] = inst_34030__$1);

(statearr_34436[(44)] = inst_34031);

return statearr_34436;
})();
if(cljs.core.truth_(inst_34030__$1)){
var statearr_34437_34615 = state_34261__$1;
(statearr_34437_34615[(1)] = (81));

} else {
var statearr_34438_34616 = state_34261__$1;
(statearr_34438_34616[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (38))){
var inst_33898 = (state_34261[(43)]);
var inst_33906 = (state_34261[(2)]);
var inst_33907 = [null,inst_33906];
var inst_33908 = (new cljs.core.PersistentVector(null,2,(5),inst_33898,inst_33907,null));
var state_34261__$1 = state_34261;
var statearr_34439_34617 = state_34261__$1;
(statearr_34439_34617[(2)] = inst_33908);

(statearr_34439_34617[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (126))){
var state_34261__$1 = state_34261;
var statearr_34440_34618 = state_34261__$1;
(statearr_34440_34618[(2)] = null);

(statearr_34440_34618[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (98))){
var inst_34077 = (state_34261[(60)]);
var inst_34141 = (state_34261[(2)]);
var inst_34142 = [inst_34141,offset_map];
var inst_34143 = (new cljs.core.PersistentVector(null,2,(5),inst_34077,inst_34142,null));
var state_34261__$1 = state_34261;
var statearr_34441_34619 = state_34261__$1;
(statearr_34441_34619[(2)] = inst_34143);

(statearr_34441_34619[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (124))){
var inst_34197 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34442_34620 = state_34261__$1;
(statearr_34442_34620[(2)] = inst_34197);

(statearr_34442_34620[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (87))){
var inst_34030 = (state_34261[(28)]);
var inst_33863 = (state_34261[(15)]);
var inst_34046 = (state_34261[(2)]);
var inst_34047 = fluree.db.util.async.throw_err(inst_34046);
var inst_34048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34049 = inst_34030.o;
var inst_34050 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_33863);
var inst_34051 = [inst_34049,inst_34050];
var inst_34052 = (new cljs.core.PersistentVector(null,2,(5),inst_34048,inst_34051,null));
var inst_34053 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_34052,inst_34047);
var state_34261__$1 = (function (){var statearr_34443 = state_34261;
(statearr_34443[(61)] = inst_34053);

return statearr_34443;
})();
var statearr_34444_34621 = state_34261__$1;
(statearr_34444_34621[(2)] = inst_34047);

(statearr_34444_34621[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (30))){
var inst_33881 = (state_34261[(16)]);
var inst_33886 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_33881);
var inst_33887 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_33886);
var state_34261__$1 = state_34261;
var statearr_34445_34622 = state_34261__$1;
(statearr_34445_34622[(2)] = inst_33887);

(statearr_34445_34622[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (73))){
var inst_33961 = (state_34261[(9)]);
var inst_33986 = (state_34261[(22)]);
var inst_33995 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33961,inst_33986);
var state_34261__$1 = state_34261;
var statearr_34446_34623 = state_34261__$1;
(statearr_34446_34623[(2)] = inst_33995);

(statearr_34446_34623[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (96))){
var inst_34221 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
var statearr_34447_34624 = state_34261__$1;
(statearr_34447_34624[(2)] = inst_34221);

(statearr_34447_34624[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (10))){
var state_34261__$1 = state_34261;
var statearr_34448_34625 = state_34261__$1;
(statearr_34448_34625[(2)] = pred_spec);

(statearr_34448_34625[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (18))){
var inst_33864 = (state_34261[(52)]);
var state_34261__$1 = state_34261;
var statearr_34449_34626 = state_34261__$1;
(statearr_34449_34626[(2)] = inst_33864);

(statearr_34449_34626[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (105))){
var inst_34129 = (state_34261[(2)]);
var state_34261__$1 = (function (){var statearr_34450 = state_34261;
(statearr_34450[(47)] = inst_34129);

return statearr_34450;
})();
if(cljs.core.truth_(fuel)){
var statearr_34451_34627 = state_34261__$1;
(statearr_34451_34627[(1)] = (107));

} else {
var statearr_34452_34628 = state_34261__$1;
(statearr_34452_34628[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (52))){
var inst_33931 = (state_34261[(62)]);
var state_34261__$1 = state_34261;
var statearr_34453_34629 = state_34261__$1;
(statearr_34453_34629[(2)] = inst_33931);

(statearr_34453_34629[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (114))){
var inst_34163 = flakes;
var inst_34164 = cljs.core.seq(inst_34163);
var inst_34165 = cljs.core.first(inst_34164);
var inst_34166 = cljs.core.next(inst_34164);
var inst_34167 = cljs.core.PersistentVector.EMPTY;
var inst_34168 = inst_34163;
var inst_34169 = inst_34167;
var state_34261__$1 = (function (){var statearr_34454 = state_34261;
(statearr_34454[(63)] = inst_34165);

(statearr_34454[(64)] = inst_34166);

(statearr_34454[(33)] = inst_34169);

(statearr_34454[(38)] = inst_34168);

return statearr_34454;
})();
var statearr_34455_34630 = state_34261__$1;
(statearr_34455_34630[(2)] = null);

(statearr_34455_34630[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (67))){
var state_34261__$1 = state_34261;
var statearr_34456_34631 = state_34261__$1;
(statearr_34456_34631[(2)] = null);

(statearr_34456_34631[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (71))){
var state_34261__$1 = state_34261;
var statearr_34457_34632 = state_34261__$1;
(statearr_34457_34632[(2)] = null);

(statearr_34457_34632[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (42))){
var inst_33878 = (state_34261[(17)]);
var state_34261__$1 = state_34261;
if(cljs.core.truth_(inst_33878)){
var statearr_34458_34633 = state_34261__$1;
(statearr_34458_34633[(1)] = (45));

} else {
var statearr_34459_34634 = state_34261__$1;
(statearr_34459_34634[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (80))){
var inst_34010 = (state_34261[(55)]);
var inst_34066 = (state_34261[(2)]);
var inst_34067 = [inst_34066,offset_map];
var inst_34068 = (new cljs.core.PersistentVector(null,2,(5),inst_34010,inst_34067,null));
var state_34261__$1 = state_34261;
var statearr_34460_34635 = state_34261__$1;
(statearr_34460_34635[(2)] = inst_34068);

(statearr_34460_34635[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (37))){
var inst_33881 = (state_34261[(16)]);
var inst_33880 = (state_34261[(18)]);
var inst_33903 = (inst_33880 - (1));
var inst_33904 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_33881,inst_33903);
var state_34261__$1 = state_34261;
var statearr_34461_34636 = state_34261__$1;
(statearr_34461_34636[(2)] = inst_33904);

(statearr_34461_34636[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (63))){
var inst_33961 = (state_34261[(9)]);
var state_34261__$1 = state_34261;
var statearr_34462_34637 = state_34261__$1;
(statearr_34462_34637[(2)] = inst_33961);

(statearr_34462_34637[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (94))){
var inst_34077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34085 = flakes;
var inst_34086 = cljs.core.seq(inst_34085);
var inst_34087 = cljs.core.first(inst_34086);
var inst_34088 = cljs.core.next(inst_34086);
var inst_34089 = cljs.core.PersistentVector.EMPTY;
var inst_34090 = inst_34085;
var inst_34091 = inst_34089;
var state_34261__$1 = (function (){var statearr_34463 = state_34261;
(statearr_34463[(32)] = inst_34091);

(statearr_34463[(60)] = inst_34077);

(statearr_34463[(65)] = inst_34088);

(statearr_34463[(66)] = inst_34087);

(statearr_34463[(49)] = inst_34090);

return statearr_34463;
})();
var statearr_34464_34638 = state_34261__$1;
(statearr_34464_34638[(2)] = null);

(statearr_34464_34638[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (8))){
var inst_33840 = (state_34261[(2)]);
var state_34261__$1 = state_34261;
if(cljs.core.truth_(inst_33840)){
var statearr_34465_34639 = state_34261__$1;
(statearr_34465_34639[(1)] = (9));

} else {
var statearr_34466_34640 = state_34261__$1;
(statearr_34466_34640[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (49))){
var inst_33931 = (state_34261[(62)]);
var inst_33931__$1 = cljs.core.not(recur_QMARK_);
var state_34261__$1 = (function (){var statearr_34467 = state_34261;
(statearr_34467[(62)] = inst_33931__$1);

return statearr_34467;
})();
if(inst_33931__$1){
var statearr_34468_34641 = state_34261__$1;
(statearr_34468_34641[(1)] = (51));

} else {
var statearr_34469_34642 = state_34261__$1;
(statearr_34469_34642[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34262 === (84))){
var inst_34039 = (state_34261[(59)]);
var state_34261__$1 = state_34261;
var statearr_34470_34643 = state_34261__$1;
(statearr_34470_34643[(2)] = inst_34039);

(statearr_34470_34643[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__11438__auto__ = null;
var fluree$db$query$fql$state_machine__11438__auto____0 = (function (){
var statearr_34471 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34471[(0)] = fluree$db$query$fql$state_machine__11438__auto__);

(statearr_34471[(1)] = (1));

return statearr_34471;
});
var fluree$db$query$fql$state_machine__11438__auto____1 = (function (state_34261){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_34261);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e34472){var ex__11441__auto__ = e34472;
var statearr_34473_34644 = state_34261;
(statearr_34473_34644[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_34261[(4)]))){
var statearr_34474_34645 = state_34261;
(statearr_34474_34645[(1)] = cljs.core.first((state_34261[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34646 = state_34261;
state_34261 = G__34646;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__11438__auto__ = function(state_34261){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__11438__auto____1.call(this,state_34261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__11438__auto____0;
fluree$db$query$fql$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__11438__auto____1;
return fluree$db$query$fql$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_34475 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_34475[(6)] = c__11512__auto__);

return statearr_34475;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_34806){
var state_val_34807 = (state_34806[(1)]);
if((state_val_34807 === (7))){
var inst_34801 = (state_34806[(2)]);
var _ = (function (){var statearr_34808 = state_34806;
(statearr_34808[(4)] = cljs.core.rest((state_34806[(4)])));

return statearr_34808;
})();
var state_34806__$1 = state_34806;
var statearr_34809_34891 = state_34806__$1;
(statearr_34809_34891[(2)] = inst_34801);

(statearr_34809_34891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (20))){
var inst_34728 = (state_34806[(7)]);
var state_34806__$1 = state_34806;
var statearr_34810_34892 = state_34806__$1;
(statearr_34810_34892[(2)] = inst_34728);

(statearr_34810_34892[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (27))){
var inst_34683 = (state_34806[(8)]);
var state_34806__$1 = state_34806;
if(cljs.core.truth_(inst_34683)){
var statearr_34811_34893 = state_34806__$1;
(statearr_34811_34893[(1)] = (29));

} else {
var statearr_34812_34894 = state_34806__$1;
(statearr_34812_34894[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (1))){
var state_34806__$1 = state_34806;
var statearr_34813_34895 = state_34806__$1;
(statearr_34813_34895[(2)] = null);

(statearr_34813_34895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (24))){
var inst_34684 = (state_34806[(9)]);
var state_34806__$1 = state_34806;
var statearr_34814_34896 = state_34806__$1;
(statearr_34814_34896[(2)] = inst_34684);

(statearr_34814_34896[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (39))){
var inst_34720 = (state_34806[(10)]);
var state_34806__$1 = state_34806;
var statearr_34815_34897 = state_34806__$1;
(statearr_34815_34897[(2)] = inst_34720);

(statearr_34815_34897[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (46))){
var inst_34685 = (state_34806[(11)]);
var state_34806__$1 = state_34806;
var statearr_34816_34898 = state_34806__$1;
(statearr_34816_34898[(2)] = inst_34685);

(statearr_34816_34898[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (4))){
var inst_34647 = (state_34806[(2)]);
var state_34806__$1 = state_34806;
var statearr_34817_34899 = state_34806__$1;
(statearr_34817_34899[(2)] = inst_34647);

(statearr_34817_34899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (15))){
var inst_34696 = (state_34806[(12)]);
var inst_34702 = cljs.core.count(inst_34696);
var inst_34703 = fluree.db.query.fql.add_fuel(fuel,inst_34702,max_fuel);
var state_34806__$1 = state_34806;
var statearr_34818_34900 = state_34806__$1;
(statearr_34818_34900[(2)] = inst_34703);

(statearr_34818_34900[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (48))){
var inst_34665 = (state_34806[(13)]);
var inst_34787 = (state_34806[(14)]);
var inst_34672 = (state_34806[(15)]);
var inst_34795 = (state_34806[(2)]);
var inst_34796 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34665,inst_34795,inst_34787);
var inst_34664 = inst_34672;
var inst_34665__$1 = inst_34796;
var state_34806__$1 = (function (){var statearr_34819 = state_34806;
(statearr_34819[(13)] = inst_34665__$1);

(statearr_34819[(16)] = inst_34664);

return statearr_34819;
})();
var statearr_34820_34901 = state_34806__$1;
(statearr_34820_34901[(2)] = null);

(statearr_34820_34901[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (50))){
var inst_34687 = (state_34806[(17)]);
var state_34806__$1 = state_34806;
var statearr_34821_34902 = state_34806__$1;
(statearr_34821_34902[(2)] = inst_34687);

(statearr_34821_34902[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (21))){
var inst_34684 = (state_34806[(9)]);
var state_34806__$1 = state_34806;
if(cljs.core.truth_(inst_34684)){
var statearr_34823_34903 = state_34806__$1;
(statearr_34823_34903[(1)] = (23));

} else {
var statearr_34824_34904 = state_34806__$1;
(statearr_34824_34904[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (31))){
var inst_34744 = (state_34806[(2)]);
var state_34806__$1 = state_34806;
if(cljs.core.truth_(inst_34744)){
var statearr_34825_34905 = state_34806__$1;
(statearr_34825_34905[(1)] = (32));

} else {
var statearr_34826_34906 = state_34806__$1;
(statearr_34826_34906[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (32))){
var inst_34727 = (state_34806[(18)]);
var inst_34719 = (state_34806[(19)]);
var inst_34720 = (state_34806[(10)]);
var inst_34746 = (inst_34719 + (1));
var tmp34822 = inst_34720;
var inst_34718 = inst_34727;
var inst_34719__$1 = inst_34746;
var inst_34720__$1 = tmp34822;
var state_34806__$1 = (function (){var statearr_34827 = state_34806;
(statearr_34827[(20)] = inst_34718);

(statearr_34827[(19)] = inst_34719__$1);

(statearr_34827[(10)] = inst_34720__$1);

return statearr_34827;
})();
var statearr_34828_34907 = state_34806__$1;
(statearr_34828_34907[(2)] = null);

(statearr_34828_34907[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (40))){
var state_34806__$1 = state_34806;
if(cljs.core.truth_(fuel)){
var statearr_34829_34908 = state_34806__$1;
(statearr_34829_34908[(1)] = (42));

} else {
var statearr_34830_34909 = state_34806__$1;
(statearr_34830_34909[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (33))){
var state_34806__$1 = state_34806;
var statearr_34831_34910 = state_34806__$1;
(statearr_34831_34910[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (13))){
var inst_34696 = (state_34806[(12)]);
var state_34806__$1 = state_34806;
var statearr_34833_34911 = state_34806__$1;
(statearr_34833_34911[(2)] = inst_34696);

(statearr_34833_34911[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (22))){
var inst_34737 = (state_34806[(2)]);
var state_34806__$1 = state_34806;
if(cljs.core.truth_(inst_34737)){
var statearr_34834_34912 = state_34806__$1;
(statearr_34834_34912[(1)] = (26));

} else {
var statearr_34835_34913 = state_34806__$1;
(statearr_34835_34913[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (36))){
var state_34806__$1 = state_34806;
var statearr_34836_34914 = state_34806__$1;
(statearr_34836_34914[(2)] = null);

(statearr_34836_34914[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (41))){
var inst_34727 = (state_34806[(18)]);
var inst_34719 = (state_34806[(19)]);
var inst_34776 = (state_34806[(2)]);
var inst_34777 = (inst_34719 + (1));
var inst_34718 = inst_34727;
var inst_34719__$1 = inst_34777;
var inst_34720 = inst_34776;
var state_34806__$1 = (function (){var statearr_34837 = state_34806;
(statearr_34837[(20)] = inst_34718);

(statearr_34837[(19)] = inst_34719__$1);

(statearr_34837[(10)] = inst_34720);

return statearr_34837;
})();
var statearr_34838_34915 = state_34806__$1;
(statearr_34838_34915[(2)] = null);

(statearr_34838_34915[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (43))){
var state_34806__$1 = state_34806;
var statearr_34839_34916 = state_34806__$1;
(statearr_34839_34916[(2)] = null);

(statearr_34839_34916[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (29))){
var inst_34683 = (state_34806[(8)]);
var inst_34719 = (state_34806[(19)]);
var inst_34741 = (inst_34719 < inst_34683);
var state_34806__$1 = state_34806;
var statearr_34840_34917 = state_34806__$1;
(statearr_34840_34917[(2)] = inst_34741);

(statearr_34840_34917[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (44))){
var inst_34760 = (state_34806[(21)]);
var inst_34756 = (state_34806[(22)]);
var inst_34769 = (state_34806[(2)]);
var inst_34770 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_34760,inst_34756) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_34760,inst_34756));
var state_34806__$1 = (function (){var statearr_34841 = state_34806;
(statearr_34841[(23)] = inst_34769);

return statearr_34841;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34806__$1,(45),inst_34770);
} else {
if((state_val_34807 === (6))){
var inst_34671 = (state_34806[(24)]);
var inst_34664 = (state_34806[(16)]);
var inst_34670 = cljs.core.seq(inst_34664);
var inst_34671__$1 = cljs.core.first(inst_34670);
var inst_34672 = cljs.core.next(inst_34670);
var inst_34673 = cljs.core.not(inst_34671__$1);
var state_34806__$1 = (function (){var statearr_34842 = state_34806;
(statearr_34842[(24)] = inst_34671__$1);

(statearr_34842[(15)] = inst_34672);

return statearr_34842;
})();
if(inst_34673){
var statearr_34843_34918 = state_34806__$1;
(statearr_34843_34918[(1)] = (8));

} else {
var statearr_34844_34919 = state_34806__$1;
(statearr_34844_34919[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (28))){
var inst_34785 = (state_34806[(2)]);
var state_34806__$1 = state_34806;
var statearr_34845_34920 = state_34806__$1;
(statearr_34845_34920[(2)] = inst_34785);

(statearr_34845_34920[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (51))){
var inst_34793 = (state_34806[(2)]);
var state_34806__$1 = state_34806;
var statearr_34846_34921 = state_34806__$1;
(statearr_34846_34921[(2)] = inst_34793);

(statearr_34846_34921[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (25))){
var inst_34735 = (state_34806[(2)]);
var state_34806__$1 = state_34806;
var statearr_34847_34922 = state_34806__$1;
(statearr_34847_34922[(2)] = inst_34735);

(statearr_34847_34922[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (34))){
var inst_34783 = (state_34806[(2)]);
var state_34806__$1 = state_34806;
var statearr_34848_34923 = state_34806__$1;
(statearr_34848_34923[(2)] = inst_34783);

(statearr_34848_34923[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (17))){
var inst_34696 = (state_34806[(12)]);
var inst_34706 = (state_34806[(2)]);
var inst_34714 = cljs.core.seq(inst_34696);
var inst_34715 = cljs.core.first(inst_34714);
var inst_34716 = cljs.core.next(inst_34714);
var inst_34717 = cljs.core.PersistentVector.EMPTY;
var inst_34718 = inst_34696;
var inst_34719 = (0);
var inst_34720 = inst_34717;
var state_34806__$1 = (function (){var statearr_34849 = state_34806;
(statearr_34849[(20)] = inst_34718);

(statearr_34849[(25)] = inst_34716);

(statearr_34849[(26)] = inst_34706);

(statearr_34849[(19)] = inst_34719);

(statearr_34849[(27)] = inst_34715);

(statearr_34849[(10)] = inst_34720);

return statearr_34849;
})();
var statearr_34850_34924 = state_34806__$1;
(statearr_34850_34924[(2)] = null);

(statearr_34850_34924[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (3))){
var inst_34804 = (state_34806[(2)]);
var state_34806__$1 = state_34806;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34806__$1,inst_34804);
} else {
if((state_val_34807 === (12))){
var state_34806__$1 = state_34806;
var statearr_34851_34925 = state_34806__$1;
(statearr_34851_34925[(2)] = fuel);

(statearr_34851_34925[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (2))){
var _ = (function (){var statearr_34852 = state_34806;
(statearr_34852[(4)] = cljs.core.cons((5),(state_34806[(4)])));

return statearr_34852;
})();
var inst_34660 = reverse_refs_specs;
var inst_34661 = cljs.core.seq(inst_34660);
var inst_34662 = cljs.core.first(inst_34661);
var inst_34663 = cljs.core.next(inst_34661);
var inst_34664 = inst_34660;
var inst_34665 = null;
var state_34806__$1 = (function (){var statearr_34853 = state_34806;
(statearr_34853[(13)] = inst_34665);

(statearr_34853[(28)] = inst_34663);

(statearr_34853[(16)] = inst_34664);

(statearr_34853[(29)] = inst_34662);

return statearr_34853;
})();
var statearr_34854_34926 = state_34806__$1;
(statearr_34854_34926[(2)] = null);

(statearr_34854_34926[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (23))){
var inst_34684 = (state_34806[(9)]);
var inst_34719 = (state_34806[(19)]);
var inst_34732 = (inst_34719 >= inst_34684);
var state_34806__$1 = state_34806;
var statearr_34855_34927 = state_34806__$1;
(statearr_34855_34927[(2)] = inst_34732);

(statearr_34855_34927[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (47))){
var inst_34686 = (state_34806[(30)]);
var state_34806__$1 = state_34806;
if(cljs.core.truth_(inst_34686)){
var statearr_34856_34928 = state_34806__$1;
(statearr_34856_34928[(1)] = (49));

} else {
var statearr_34857_34929 = state_34806__$1;
(statearr_34857_34929[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (35))){
var inst_34726 = (state_34806[(31)]);
var inst_34750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34751 = [inst_34726];
var inst_34752 = (new cljs.core.PersistentVector(null,1,(5),inst_34750,inst_34751,null));
var inst_34753 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_34752);
var state_34806__$1 = state_34806;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34806__$1,(38),inst_34753);
} else {
if((state_val_34807 === (19))){
var inst_34685 = (state_34806[(11)]);
var inst_34787 = (state_34806[(2)]);
var state_34806__$1 = (function (){var statearr_34858 = state_34806;
(statearr_34858[(14)] = inst_34787);

return statearr_34858;
})();
if(cljs.core.truth_(inst_34685)){
var statearr_34859_34930 = state_34806__$1;
(statearr_34859_34930[(1)] = (46));

} else {
var statearr_34860_34931 = state_34806__$1;
(statearr_34860_34931[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (11))){
var inst_34696 = (state_34806[(12)]);
var inst_34693 = (state_34806[(2)]);
var inst_34694 = fluree.db.util.async.throw_err(inst_34693);
var inst_34695 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_34694);
var inst_34696__$1 = cljs.core.not_empty(inst_34695);
var state_34806__$1 = (function (){var statearr_34862 = state_34806;
(statearr_34862[(12)] = inst_34696__$1);

return statearr_34862;
})();
if(cljs.core.truth_(inst_34696__$1)){
var statearr_34863_34932 = state_34806__$1;
(statearr_34863_34932[(1)] = (12));

} else {
var statearr_34864_34933 = state_34806__$1;
(statearr_34864_34933[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (9))){
var inst_34681 = (state_34806[(32)]);
var inst_34671 = (state_34806[(24)]);
var inst_34680 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34671,(0),null);
var inst_34681__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34671,(1),null);
var inst_34682 = cljs.core.__destructure_map(inst_34681__$1);
var inst_34683 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34682,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_34684 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34682,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_34685 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34682,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_34686 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34682,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_34687 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34682,new cljs.core.Keyword(null,"p","p",151049309));
var inst_34688 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34689 = [subject_id,inst_34680];
var inst_34690 = (new cljs.core.PersistentVector(null,2,(5),inst_34688,inst_34689,null));
var inst_34691 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_34690);
var state_34806__$1 = (function (){var statearr_34865 = state_34806;
(statearr_34865[(9)] = inst_34684);

(statearr_34865[(8)] = inst_34683);

(statearr_34865[(32)] = inst_34681__$1);

(statearr_34865[(11)] = inst_34685);

(statearr_34865[(17)] = inst_34687);

(statearr_34865[(30)] = inst_34686);

return statearr_34865;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34806__$1,(11),inst_34691);
} else {
if((state_val_34807 === (5))){
var _ = (function (){var statearr_34866 = state_34806;
(statearr_34866[(4)] = cljs.core.rest((state_34806[(4)])));

return statearr_34866;
})();
var state_34806__$1 = state_34806;
var ex34861 = (state_34806__$1[(2)]);
var statearr_34867_34934 = state_34806__$1;
(statearr_34867_34934[(5)] = ex34861);


if((ex34861 instanceof Error)){
var statearr_34868_34935 = state_34806__$1;
(statearr_34868_34935[(1)] = (4));

(statearr_34868_34935[(5)] = null);

} else {
throw ex34861;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (14))){
var inst_34700 = (state_34806[(2)]);
var state_34806__$1 = state_34806;
if(cljs.core.truth_(inst_34700)){
var statearr_34869_34936 = state_34806__$1;
(statearr_34869_34936[(1)] = (15));

} else {
var statearr_34870_34937 = state_34806__$1;
(statearr_34870_34937[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (45))){
var inst_34720 = (state_34806[(10)]);
var inst_34772 = (state_34806[(2)]);
var inst_34773 = fluree.db.util.async.throw_err(inst_34772);
var inst_34774 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34720,inst_34773);
var state_34806__$1 = state_34806;
var statearr_34871_34938 = state_34806__$1;
(statearr_34871_34938[(2)] = inst_34774);

(statearr_34871_34938[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (26))){
var inst_34720 = (state_34806[(10)]);
var state_34806__$1 = state_34806;
var statearr_34872_34939 = state_34806__$1;
(statearr_34872_34939[(2)] = inst_34720);

(statearr_34872_34939[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (16))){
var state_34806__$1 = state_34806;
var statearr_34873_34940 = state_34806__$1;
(statearr_34873_34940[(2)] = null);

(statearr_34873_34940[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (38))){
var inst_34681 = (state_34806[(32)]);
var inst_34756 = (state_34806[(22)]);
var inst_34755 = (state_34806[(2)]);
var inst_34756__$1 = fluree.db.util.async.throw_err(inst_34755);
var inst_34757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34758 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_34759 = (new cljs.core.PersistentVector(null,4,(5),inst_34757,inst_34758,null));
var inst_34760 = cljs.core.select_keys(inst_34681,inst_34759);
var inst_34761 = cljs.core.empty_QMARK_(inst_34756__$1);
var state_34806__$1 = (function (){var statearr_34874 = state_34806;
(statearr_34874[(21)] = inst_34760);

(statearr_34874[(22)] = inst_34756__$1);

return statearr_34874;
})();
if(inst_34761){
var statearr_34875_34941 = state_34806__$1;
(statearr_34875_34941[(1)] = (39));

} else {
var statearr_34876_34942 = state_34806__$1;
(statearr_34876_34942[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (30))){
var inst_34683 = (state_34806[(8)]);
var state_34806__$1 = state_34806;
var statearr_34877_34943 = state_34806__$1;
(statearr_34877_34943[(2)] = inst_34683);

(statearr_34877_34943[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (10))){
var inst_34799 = (state_34806[(2)]);
var state_34806__$1 = state_34806;
var statearr_34878_34944 = state_34806__$1;
(statearr_34878_34944[(2)] = inst_34799);

(statearr_34878_34944[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (18))){
var inst_34718 = (state_34806[(20)]);
var inst_34726 = (state_34806[(31)]);
var inst_34728 = (state_34806[(7)]);
var inst_34725 = cljs.core.seq(inst_34718);
var inst_34726__$1 = cljs.core.first(inst_34725);
var inst_34727 = cljs.core.next(inst_34725);
var inst_34728__$1 = cljs.core.not(inst_34726__$1);
var state_34806__$1 = (function (){var statearr_34879 = state_34806;
(statearr_34879[(18)] = inst_34727);

(statearr_34879[(31)] = inst_34726__$1);

(statearr_34879[(7)] = inst_34728__$1);

return statearr_34879;
})();
if(inst_34728__$1){
var statearr_34880_34945 = state_34806__$1;
(statearr_34880_34945[(1)] = (20));

} else {
var statearr_34881_34946 = state_34806__$1;
(statearr_34881_34946[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (42))){
var inst_34756 = (state_34806[(22)]);
var inst_34765 = cljs.core.count(inst_34756);
var inst_34766 = fluree.db.query.fql.add_fuel(fuel,inst_34765,max_fuel);
var state_34806__$1 = state_34806;
var statearr_34882_34947 = state_34806__$1;
(statearr_34882_34947[(2)] = inst_34766);

(statearr_34882_34947[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (37))){
var inst_34781 = (state_34806[(2)]);
var state_34806__$1 = state_34806;
var statearr_34883_34948 = state_34806__$1;
(statearr_34883_34948[(2)] = inst_34781);

(statearr_34883_34948[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (8))){
var inst_34665 = (state_34806[(13)]);
var state_34806__$1 = state_34806;
var statearr_34884_34949 = state_34806__$1;
(statearr_34884_34949[(2)] = inst_34665);

(statearr_34884_34949[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34807 === (49))){
var inst_34686 = (state_34806[(30)]);
var state_34806__$1 = state_34806;
var statearr_34885_34950 = state_34806__$1;
(statearr_34885_34950[(2)] = inst_34686);

(statearr_34885_34950[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11438__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11438__auto____0 = (function (){
var statearr_34886 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34886[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11438__auto__);

(statearr_34886[(1)] = (1));

return statearr_34886;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11438__auto____1 = (function (state_34806){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_34806);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e34887){var ex__11441__auto__ = e34887;
var statearr_34888_34951 = state_34806;
(statearr_34888_34951[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_34806[(4)]))){
var statearr_34889_34952 = state_34806;
(statearr_34889_34952[(1)] = cljs.core.first((state_34806[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34953 = state_34806;
state_34806 = G__34953;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11438__auto__ = function(state_34806){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11438__auto____1.call(this,state_34806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11438__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11438__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_34890 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_34890[(6)] = c__11512__auto__);

return statearr_34890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__34954 = select_spec;
var map__34954__$1 = cljs.core.__destructure_map(map__34954);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34954__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34954__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_35068){
var state_val_35069 = (state_35068[(1)]);
if((state_val_35069 === (7))){
var inst_34980 = flakes;
var inst_34981 = cljs.core.seq(inst_34980);
var inst_34982 = cljs.core.first(inst_34981);
var inst_34983 = cljs.core.next(inst_34981);
var inst_34984 = cljs.core.PersistentVector.EMPTY;
var inst_34985 = inst_34980;
var inst_34986 = (0);
var inst_34987 = inst_34984;
var state_35068__$1 = (function (){var statearr_35070 = state_35068;
(statearr_35070[(7)] = inst_34983);

(statearr_35070[(8)] = inst_34985);

(statearr_35070[(9)] = inst_34986);

(statearr_35070[(10)] = inst_34982);

(statearr_35070[(11)] = inst_34987);

return statearr_35070;
})();
var statearr_35071_35137 = state_35068__$1;
(statearr_35071_35137[(2)] = null);

(statearr_35071_35137[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (20))){
var state_35068__$1 = state_35068;
var statearr_35072_35138 = state_35068__$1;
(statearr_35072_35138[(2)] = results);

(statearr_35072_35138[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (27))){
var state_35068__$1 = state_35068;
var statearr_35073_35139 = state_35068__$1;
(statearr_35073_35139[(2)] = null);

(statearr_35073_35139[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (1))){
var state_35068__$1 = state_35068;
var statearr_35074_35140 = state_35068__$1;
(statearr_35074_35140[(2)] = null);

(statearr_35074_35140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (24))){
var state_35068__$1 = state_35068;
var statearr_35075_35141 = state_35068__$1;
(statearr_35075_35141[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (39))){
var inst_34994 = (state_35068[(12)]);
var inst_34987 = (state_35068[(11)]);
var inst_35049 = (state_35068[(13)]);
var inst_35052 = (state_35068[(2)]);
var inst_35053 = fluree.db.util.async.throw_err(inst_35052);
var inst_35054 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34987,inst_35053);
var inst_34985 = inst_34994;
var inst_34986 = inst_35049;
var inst_34987__$1 = inst_35054;
var state_35068__$1 = (function (){var statearr_35077 = state_35068;
(statearr_35077[(8)] = inst_34985);

(statearr_35077[(9)] = inst_34986);

(statearr_35077[(11)] = inst_34987__$1);

return statearr_35077;
})();
var statearr_35078_35142 = state_35068__$1;
(statearr_35078_35142[(2)] = null);

(statearr_35078_35142[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (4))){
var inst_34955 = (state_35068[(2)]);
var state_35068__$1 = state_35068;
var statearr_35079_35143 = state_35068__$1;
(statearr_35079_35143[(2)] = inst_34955);

(statearr_35079_35143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (15))){
var inst_34968 = (state_35068[(14)]);
var state_35068__$1 = state_35068;
var statearr_35080_35144 = state_35068__$1;
(statearr_35080_35144[(2)] = inst_34968);

(statearr_35080_35144[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (21))){
var inst_34964 = (state_35068[(15)]);
var state_35068__$1 = state_35068;
if(cljs.core.truth_(inst_34964)){
var statearr_35081_35145 = state_35068__$1;
(statearr_35081_35145[(1)] = (23));

} else {
var statearr_35082_35146 = state_35068__$1;
(statearr_35082_35146[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (31))){
var inst_35032 = (state_35068[(16)]);
var state_35068__$1 = state_35068;
var statearr_35083_35147 = state_35068__$1;
(statearr_35083_35147[(2)] = inst_35032);

(statearr_35083_35147[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (32))){
var inst_35024 = (state_35068[(17)]);
var inst_35038 = (state_35068[(2)]);
var state_35068__$1 = (function (){var statearr_35084 = state_35068;
(statearr_35084[(18)] = inst_35038);

return statearr_35084;
})();
if(cljs.core.truth_(inst_35024)){
var statearr_35085_35148 = state_35068__$1;
(statearr_35085_35148[(1)] = (33));

} else {
var statearr_35086_35149 = state_35068__$1;
(statearr_35086_35149[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (33))){
var inst_35024 = (state_35068[(17)]);
var state_35068__$1 = state_35068;
var statearr_35087_35150 = state_35068__$1;
(statearr_35087_35150[(2)] = inst_35024);

(statearr_35087_35150[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (13))){
var inst_35004 = (state_35068[(2)]);
var state_35068__$1 = state_35068;
if(cljs.core.truth_(inst_35004)){
var statearr_35089_35151 = state_35068__$1;
(statearr_35089_35151[(1)] = (17));

} else {
var statearr_35090_35152 = state_35068__$1;
(statearr_35090_35152[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (22))){
var inst_35021 = (state_35068[(2)]);
var state_35068__$1 = state_35068;
var statearr_35091_35153 = state_35068__$1;
(statearr_35091_35153[(2)] = inst_35021);

(statearr_35091_35153[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (36))){
var inst_34986 = (state_35068[(9)]);
var inst_34994 = (state_35068[(12)]);
var inst_34987 = (state_35068[(11)]);
var inst_35046 = (inst_34986 + (1));
var tmp35088 = inst_34987;
var inst_34985 = inst_34994;
var inst_34986__$1 = inst_35046;
var inst_34987__$1 = tmp35088;
var state_35068__$1 = (function (){var statearr_35092 = state_35068;
(statearr_35092[(8)] = inst_34985);

(statearr_35092[(9)] = inst_34986__$1);

(statearr_35092[(11)] = inst_34987__$1);

return statearr_35092;
})();
var statearr_35093_35154 = state_35068__$1;
(statearr_35093_35154[(2)] = null);

(statearr_35093_35154[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (29))){
var inst_35031 = (state_35068[(2)]);
var inst_35032 = fluree.db.util.async.throw_err(inst_35031);
var state_35068__$1 = (function (){var statearr_35094 = state_35068;
(statearr_35094[(16)] = inst_35032);

return statearr_35094;
})();
if(cljs.core.truth_(fuel)){
var statearr_35095_35155 = state_35068__$1;
(statearr_35095_35155[(1)] = (30));

} else {
var statearr_35096_35156 = state_35068__$1;
(statearr_35096_35156[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (6))){
var state_35068__$1 = state_35068;
var statearr_35097_35157 = state_35068__$1;
(statearr_35097_35157[(2)] = results);

(statearr_35097_35157[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (28))){
var inst_35017 = (state_35068[(2)]);
var state_35068__$1 = state_35068;
var statearr_35098_35158 = state_35068__$1;
(statearr_35098_35158[(2)] = inst_35017);

(statearr_35098_35158[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (25))){
var inst_35019 = (state_35068[(2)]);
var state_35068__$1 = state_35068;
var statearr_35099_35159 = state_35068__$1;
(statearr_35099_35159[(2)] = inst_35019);

(statearr_35099_35159[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (34))){
var inst_35038 = (state_35068[(18)]);
var inst_35041 = cljs.core.empty_QMARK_(inst_35038);
var state_35068__$1 = state_35068;
var statearr_35100_35160 = state_35068__$1;
(statearr_35100_35160[(2)] = inst_35041);

(statearr_35100_35160[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (17))){
var inst_34987 = (state_35068[(11)]);
var inst_35006 = cljs.core.empty_QMARK_(inst_34987);
var state_35068__$1 = state_35068;
if(inst_35006){
var statearr_35101_35161 = state_35068__$1;
(statearr_35101_35161[(1)] = (20));

} else {
var statearr_35102_35162 = state_35068__$1;
(statearr_35102_35162[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (3))){
var inst_35066 = (state_35068[(2)]);
var state_35068__$1 = state_35068;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35068__$1,inst_35066);
} else {
if((state_val_35069 === (12))){
var inst_34968 = (state_35068[(14)]);
var state_35068__$1 = state_35068;
if(cljs.core.truth_(inst_34968)){
var statearr_35103_35163 = state_35068__$1;
(statearr_35103_35163[(1)] = (14));

} else {
var statearr_35104_35164 = state_35068__$1;
(statearr_35104_35164[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (2))){
var _ = (function (){var statearr_35105 = state_35068;
(statearr_35105[(4)] = cljs.core.cons((5),(state_35068[(4)])));

return statearr_35105;
})();
var inst_34962 = select_spec;
var inst_34963 = cljs.core.__destructure_map(inst_34962);
var inst_34964 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34963,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_34965 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34963,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_34966 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34963,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_34967 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34963,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_34968 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34963,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_34969 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_34970 = (inst_34967 > inst_34969);
var state_35068__$1 = (function (){var statearr_35106 = state_35068;
(statearr_35106[(15)] = inst_34964);

(statearr_35106[(19)] = inst_34965);

(statearr_35106[(14)] = inst_34968);

(statearr_35106[(20)] = inst_34966);

return statearr_35106;
})();
if(cljs.core.truth_(inst_34970)){
var statearr_35107_35165 = state_35068__$1;
(statearr_35107_35165[(1)] = (6));

} else {
var statearr_35108_35166 = state_35068__$1;
(statearr_35108_35166[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (23))){
var inst_34965 = (state_35068[(19)]);
var inst_34987 = (state_35068[(11)]);
var inst_35010 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_34965,inst_34987);
var state_35068__$1 = state_35068;
var statearr_35109_35167 = state_35068__$1;
(statearr_35109_35167[(2)] = inst_35010);

(statearr_35109_35167[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (35))){
var inst_34993 = (state_35068[(21)]);
var inst_35043 = (state_35068[(2)]);
var inst_35044 = fluree.db.query.fql.recur_select_spec(select_spec,inst_34993);
var state_35068__$1 = (function (){var statearr_35110 = state_35068;
(statearr_35110[(22)] = inst_35044);

return statearr_35110;
})();
if(cljs.core.truth_(inst_35043)){
var statearr_35111_35168 = state_35068__$1;
(statearr_35111_35168[(1)] = (36));

} else {
var statearr_35112_35169 = state_35068__$1;
(statearr_35112_35169[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (19))){
var inst_35059 = (state_35068[(2)]);
var state_35068__$1 = state_35068;
var statearr_35113_35170 = state_35068__$1;
(statearr_35113_35170[(2)] = inst_35059);

(statearr_35113_35170[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (11))){
var inst_34995 = (state_35068[(23)]);
var state_35068__$1 = state_35068;
var statearr_35115_35171 = state_35068__$1;
(statearr_35115_35171[(2)] = inst_34995);

(statearr_35115_35171[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (9))){
var inst_34995 = (state_35068[(23)]);
var inst_34993 = (state_35068[(21)]);
var inst_34985 = (state_35068[(8)]);
var inst_34992 = cljs.core.seq(inst_34985);
var inst_34993__$1 = cljs.core.first(inst_34992);
var inst_34994 = cljs.core.next(inst_34992);
var inst_34995__$1 = cljs.core.not(inst_34993__$1);
var state_35068__$1 = (function (){var statearr_35116 = state_35068;
(statearr_35116[(23)] = inst_34995__$1);

(statearr_35116[(21)] = inst_34993__$1);

(statearr_35116[(12)] = inst_34994);

return statearr_35116;
})();
if(inst_34995__$1){
var statearr_35117_35172 = state_35068__$1;
(statearr_35117_35172[(1)] = (11));

} else {
var statearr_35118_35173 = state_35068__$1;
(statearr_35118_35173[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (5))){
var _ = (function (){var statearr_35119 = state_35068;
(statearr_35119[(4)] = cljs.core.rest((state_35068[(4)])));

return statearr_35119;
})();
var state_35068__$1 = state_35068;
var ex35114 = (state_35068__$1[(2)]);
var statearr_35120_35174 = state_35068__$1;
(statearr_35120_35174[(5)] = ex35114);


if((ex35114 instanceof Error)){
var statearr_35121_35175 = state_35068__$1;
(statearr_35121_35175[(1)] = (4));

(statearr_35121_35175[(5)] = null);

} else {
throw ex35114;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (14))){
var inst_34986 = (state_35068[(9)]);
var inst_34968 = (state_35068[(14)]);
var inst_34999 = (inst_34986 < inst_34968);
var state_35068__$1 = state_35068;
var statearr_35122_35176 = state_35068__$1;
(statearr_35122_35176[(2)] = inst_34999);

(statearr_35122_35176[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (26))){
var inst_34965 = (state_35068[(19)]);
var inst_34987 = (state_35068[(11)]);
var inst_35013 = cljs.core.first(inst_34987);
var inst_35014 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_34965,inst_35013);
var state_35068__$1 = state_35068;
var statearr_35123_35177 = state_35068__$1;
(statearr_35123_35177[(2)] = inst_35014);

(statearr_35123_35177[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (16))){
var inst_35002 = (state_35068[(2)]);
var state_35068__$1 = state_35068;
var statearr_35124_35178 = state_35068__$1;
(statearr_35124_35178[(2)] = inst_35002);

(statearr_35124_35178[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (38))){
var inst_35057 = (state_35068[(2)]);
var state_35068__$1 = state_35068;
var statearr_35125_35179 = state_35068__$1;
(statearr_35125_35179[(2)] = inst_35057);

(statearr_35125_35179[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (30))){
var inst_35032 = (state_35068[(16)]);
var inst_35034 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_35035 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_35034,inst_35032);
var state_35068__$1 = state_35068;
var statearr_35126_35180 = state_35068__$1;
(statearr_35126_35180[(2)] = inst_35035);

(statearr_35126_35180[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (10))){
var inst_35061 = (state_35068[(2)]);
var state_35068__$1 = state_35068;
var statearr_35127_35181 = state_35068__$1;
(statearr_35127_35181[(2)] = inst_35061);

(statearr_35127_35181[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35069 === (18))){
var inst_34993 = (state_35068[(21)]);
var inst_34966 = (state_35068[(20)]);
var inst_35023 = inst_34993.o;
var inst_35024 = cljs.core.contains_QMARK_(inst_34966,inst_35023);
var inst_35026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35027 = [inst_35023];
var inst_35028 = (new cljs.core.PersistentVector(null,1,(5),inst_35026,inst_35027,null));
var inst_35029 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_35028);
var state_35068__$1 = (function (){var statearr_35128 = state_35068;
(statearr_35128[(17)] = inst_35024);

return statearr_35128;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35068__$1,(29),inst_35029);
} else {
if((state_val_35069 === (37))){
var inst_35044 = (state_35068[(22)]);
var inst_34986 = (state_35068[(9)]);
var inst_35038 = (state_35068[(18)]);
var inst_35049 = (inst_34986 + (1));
var inst_35050 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_35044,inst_35038) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_35044,inst_35038));
var state_35068__$1 = (function (){var statearr_35129 = state_35068;
(statearr_35129[(13)] = inst_35049);

return statearr_35129;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35068__$1,(39),inst_35050);
} else {
if((state_val_35069 === (8))){
var inst_35063 = (state_35068[(2)]);
var _ = (function (){var statearr_35130 = state_35068;
(statearr_35130[(4)] = cljs.core.rest((state_35068[(4)])));

return statearr_35130;
})();
var state_35068__$1 = state_35068;
var statearr_35131_35182 = state_35068__$1;
(statearr_35131_35182[(2)] = inst_35063);

(statearr_35131_35182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__11438__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__11438__auto____0 = (function (){
var statearr_35132 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35132[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__11438__auto__);

(statearr_35132[(1)] = (1));

return statearr_35132;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__11438__auto____1 = (function (state_35068){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_35068);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e35133){var ex__11441__auto__ = e35133;
var statearr_35134_35183 = state_35068;
(statearr_35134_35183[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_35068[(4)]))){
var statearr_35135_35184 = state_35068;
(statearr_35135_35184[(1)] = cljs.core.first((state_35068[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35185 = state_35068;
state_35068 = G__35185;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__11438__auto__ = function(state_35068){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__11438__auto____1.call(this,state_35068);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__11438__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__11438__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_35136 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_35136[(6)] = c__11512__auto__);

return statearr_35136;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_35366){
var state_val_35367 = (state_35366[(1)]);
if((state_val_35367 === (7))){
var state_35366__$1 = state_35366;
var statearr_35368_35454 = state_35366__$1;
(statearr_35368_35454[(2)] = null);

(statearr_35368_35454[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (20))){
var inst_35224 = cljs.core.PersistentHashMap.EMPTY;
var state_35366__$1 = state_35366;
var statearr_35369_35455 = state_35366__$1;
(statearr_35369_35455[(2)] = inst_35224);

(statearr_35369_35455[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (27))){
var inst_35212 = (state_35366[(7)]);
var inst_35242 = (state_35366[(8)]);
var inst_35206 = (state_35366[(9)]);
var inst_35226 = (state_35366[(10)]);
var inst_35345 = (state_35366[(2)]);
var inst_35346 = (function (){var top_level_subject = inst_35206;
var select_spec = inst_35212;
var base_acc = inst_35226;
var acc_PLUS_refs = inst_35242;
var result = inst_35345;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_35347 = cljs.core.PersistentVector.EMPTY;
var inst_35348 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_35212);
var inst_35349 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_35348);
var inst_35350 = cljs.core.vals(inst_35349);
var inst_35351 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_35212);
var inst_35352 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_35351);
var inst_35353 = cljs.core.vals(inst_35352);
var inst_35354 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_35350,inst_35353);
var inst_35355 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35346,inst_35347,inst_35354);
var inst_35357 = (function (){var top_level_subject = inst_35206;
var select_spec = inst_35212;
var base_acc = inst_35226;
var acc_PLUS_refs = inst_35242;
var result = inst_35345;
var sort_preds = inst_35355;
return (function (acc,p__35356){
var vec__35370 = p__35356;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35370,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35370,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35370,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35370,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_35358 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35357,inst_35345,inst_35355);
var state_35366__$1 = state_35366;
var statearr_35373_35456 = state_35366__$1;
(statearr_35373_35456[(2)] = inst_35358);

(statearr_35373_35456[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (1))){
var state_35366__$1 = state_35366;
var statearr_35374_35457 = state_35366__$1;
(statearr_35374_35457[(2)] = null);

(statearr_35374_35457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (24))){
var inst_35242 = (state_35366[(8)]);
var inst_35242__$1 = (state_35366[(2)]);
var inst_35243 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_35244 = cljs.core.PersistentHashMap.EMPTY;
var inst_35245 = inst_35243;
var inst_35246 = inst_35242__$1;
var inst_35247 = inst_35244;
var state_35366__$1 = (function (){var statearr_35375 = state_35366;
(statearr_35375[(11)] = inst_35247);

(statearr_35375[(12)] = inst_35245);

(statearr_35375[(8)] = inst_35242__$1);

(statearr_35375[(13)] = inst_35246);

return statearr_35375;
})();
var statearr_35376_35458 = state_35366__$1;
(statearr_35376_35458[(2)] = null);

(statearr_35376_35458[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (39))){
var inst_35212 = (state_35366[(7)]);
var inst_35255 = (state_35366[(14)]);
var inst_35262 = (state_35366[(15)]);
var inst_35246 = (state_35366[(13)]);
var inst_35291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35292 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_35246,inst_35212,inst_35255,inst_35262,false);
var state_35366__$1 = (function (){var statearr_35377 = state_35366;
(statearr_35377[(16)] = inst_35291);

return statearr_35377;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35366__$1,(42),inst_35292);
} else {
if((state_val_35367 === (46))){
var inst_35247 = (state_35366[(11)]);
var inst_35255 = (state_35366[(14)]);
var inst_35245 = (state_35366[(12)]);
var inst_35309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35310 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_35311 = cljs.core.first(inst_35255);
var inst_35312 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_35311);
var inst_35313 = [inst_35312];
var inst_35314 = cljs.core.PersistentHashMap.fromArrays(inst_35310,inst_35313);
var inst_35315 = cljs.core.rest(inst_35245);
var inst_35316 = [inst_35314,inst_35315,inst_35247];
var inst_35317 = (new cljs.core.PersistentVector(null,3,(5),inst_35309,inst_35316,null));
var state_35366__$1 = state_35366;
var statearr_35378_35459 = state_35366__$1;
(statearr_35378_35459[(2)] = inst_35317);

(statearr_35378_35459[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (4))){
var inst_35186 = (state_35366[(2)]);
var state_35366__$1 = state_35366;
var statearr_35379_35460 = state_35366__$1;
(statearr_35379_35460[(2)] = inst_35186);

(statearr_35379_35460[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (15))){
var inst_35212 = (state_35366[(7)]);
var inst_35213 = (state_35366[(17)]);
var inst_35212__$1 = (state_35366[(2)]);
var inst_35213__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_35212__$1);
var state_35366__$1 = (function (){var statearr_35380 = state_35366;
(statearr_35380[(7)] = inst_35212__$1);

(statearr_35380[(17)] = inst_35213__$1);

return statearr_35380;
})();
if(cljs.core.truth_(inst_35213__$1)){
var statearr_35381_35461 = state_35366__$1;
(statearr_35381_35461[(1)] = (16));

} else {
var statearr_35382_35462 = state_35366__$1;
(statearr_35382_35462[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (48))){
var inst_35328 = (state_35366[(2)]);
var state_35366__$1 = state_35366;
var statearr_35383_35463 = state_35366__$1;
(statearr_35383_35463[(2)] = inst_35328);

(statearr_35383_35463[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (50))){
var state_35366__$1 = state_35366;
var statearr_35384_35464 = state_35366__$1;
(statearr_35384_35464[(2)] = null);

(statearr_35384_35464[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (21))){
var inst_35212 = (state_35366[(7)]);
var inst_35226 = (state_35366[(2)]);
var inst_35227 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35228 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_35229 = (new cljs.core.PersistentVector(null,2,(5),inst_35227,inst_35228,null));
var inst_35230 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_35212,inst_35229);
var state_35366__$1 = (function (){var statearr_35385 = state_35366;
(statearr_35385[(10)] = inst_35226);

return statearr_35385;
})();
if(cljs.core.truth_(inst_35230)){
var statearr_35386_35465 = state_35366__$1;
(statearr_35386_35465[(1)] = (22));

} else {
var statearr_35387_35466 = state_35366__$1;
(statearr_35387_35466[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (31))){
var inst_35261 = (state_35366[(18)]);
var inst_35255 = (state_35366[(14)]);
var inst_35246 = (state_35366[(13)]);
var inst_35265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35266 = fluree.db.query.fql.flake__GT_recur(db,inst_35255,inst_35261,inst_35246,fuel,max_fuel,cache);
var state_35366__$1 = (function (){var statearr_35388 = state_35366;
(statearr_35388[(19)] = inst_35265);

return statearr_35388;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35366__$1,(34),inst_35266);
} else {
if((state_val_35367 === (32))){
var inst_35261 = (state_35366[(18)]);
var state_35366__$1 = state_35366;
if(cljs.core.truth_(inst_35261)){
var statearr_35389_35467 = state_35366__$1;
(statearr_35389_35467[(1)] = (35));

} else {
var statearr_35390_35468 = state_35366__$1;
(statearr_35390_35468[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (40))){
var inst_35212 = (state_35366[(7)]);
var inst_35302 = (state_35366[(20)]);
var inst_35301 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_35212);
var inst_35302__$1 = cljs.core.empty_QMARK_(inst_35301);
var state_35366__$1 = (function (){var statearr_35391 = state_35366;
(statearr_35391[(20)] = inst_35302__$1);

return statearr_35391;
})();
if(inst_35302__$1){
var statearr_35392_35469 = state_35366__$1;
(statearr_35392_35469[(1)] = (43));

} else {
var statearr_35393_35470 = state_35366__$1;
(statearr_35393_35470[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (33))){
var inst_35255 = (state_35366[(14)]);
var inst_35334 = (state_35366[(2)]);
var inst_35335 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35334,(0),null);
var inst_35336 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35334,(1),null);
var inst_35337 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35334,(2),null);
var inst_35338 = cljs.core.first(inst_35255);
var inst_35339 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_35338);
var inst_35340 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35335,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_35339);
var inst_35245 = inst_35336;
var inst_35246 = inst_35340;
var inst_35247 = inst_35337;
var state_35366__$1 = (function (){var statearr_35394 = state_35366;
(statearr_35394[(11)] = inst_35247);

(statearr_35394[(12)] = inst_35245);

(statearr_35394[(13)] = inst_35246);

return statearr_35394;
})();
var statearr_35395_35471 = state_35366__$1;
(statearr_35395_35471[(2)] = null);

(statearr_35395_35471[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (13))){
var inst_35206 = (state_35366[(9)]);
var inst_35209 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_35206);
var state_35366__$1 = state_35366;
var statearr_35396_35472 = state_35366__$1;
(statearr_35396_35472[(2)] = inst_35209);

(statearr_35396_35472[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (22))){
var inst_35212 = (state_35366[(7)]);
var inst_35232 = cljs.core.first(flakes);
var inst_35233 = fluree.db.query.fql.s(inst_35232);
var inst_35234 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_35212);
var inst_35235 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_35233,inst_35234);
var state_35366__$1 = state_35366;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35366__$1,(25),inst_35235);
} else {
if((state_val_35367 === (36))){
var inst_35212 = (state_35366[(7)]);
var inst_35289 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_35212);
var state_35366__$1 = state_35366;
if(cljs.core.truth_(inst_35289)){
var statearr_35397_35473 = state_35366__$1;
(statearr_35397_35473[(1)] = (39));

} else {
var statearr_35398_35474 = state_35366__$1;
(statearr_35398_35474[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (41))){
var inst_35330 = (state_35366[(2)]);
var state_35366__$1 = state_35366;
var statearr_35399_35475 = state_35366__$1;
(statearr_35399_35475[(2)] = inst_35330);

(statearr_35399_35475[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (43))){
var inst_35212 = (state_35366[(7)]);
var inst_35304 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_35212);
var state_35366__$1 = state_35366;
var statearr_35400_35476 = state_35366__$1;
(statearr_35400_35476[(2)] = inst_35304);

(statearr_35400_35476[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (29))){
var inst_35212 = (state_35366[(7)]);
var inst_35261 = (state_35366[(18)]);
var inst_35255 = (state_35366[(14)]);
var inst_35245 = (state_35366[(12)]);
var inst_35255__$1 = cljs.core.first(inst_35245);
var inst_35256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35257 = cljs.core.first(inst_35255__$1);
var inst_35258 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_35257);
var inst_35259 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_35258];
var inst_35260 = (new cljs.core.PersistentVector(null,3,(5),inst_35256,inst_35259,null));
var inst_35261__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_35212,inst_35260);
var inst_35262 = fluree.db.query.fql.component_follow_QMARK_(inst_35261__$1,inst_35212);
var inst_35263 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_35261__$1);
var state_35366__$1 = (function (){var statearr_35401 = state_35366;
(statearr_35401[(18)] = inst_35261__$1);

(statearr_35401[(14)] = inst_35255__$1);

(statearr_35401[(15)] = inst_35262);

return statearr_35401;
})();
if(cljs.core.truth_(inst_35263)){
var statearr_35402_35477 = state_35366__$1;
(statearr_35402_35477[(1)] = (31));

} else {
var statearr_35403_35478 = state_35366__$1;
(statearr_35403_35478[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (44))){
var inst_35302 = (state_35366[(20)]);
var state_35366__$1 = state_35366;
var statearr_35404_35479 = state_35366__$1;
(statearr_35404_35479[(2)] = inst_35302);

(statearr_35404_35479[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (6))){
var state_35366__$1 = state_35366;
var statearr_35405_35480 = state_35366__$1;
(statearr_35405_35480[(2)] = null);

(statearr_35405_35480[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (28))){
var inst_35246 = (state_35366[(13)]);
var state_35366__$1 = state_35366;
var statearr_35406_35481 = state_35366__$1;
(statearr_35406_35481[(2)] = inst_35246);

(statearr_35406_35481[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (51))){
var inst_35326 = (state_35366[(2)]);
var state_35366__$1 = state_35366;
var statearr_35407_35482 = state_35366__$1;
(statearr_35407_35482[(2)] = inst_35326);

(statearr_35407_35482[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (25))){
var inst_35226 = (state_35366[(10)]);
var inst_35237 = (state_35366[(2)]);
var inst_35238 = fluree.db.util.async.throw_err(inst_35237);
var inst_35239 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35226,inst_35238], 0));
var state_35366__$1 = state_35366;
var statearr_35408_35483 = state_35366__$1;
(statearr_35408_35483[(2)] = inst_35239);

(statearr_35408_35483[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (34))){
var inst_35265 = (state_35366[(19)]);
var inst_35247 = (state_35366[(11)]);
var inst_35245 = (state_35366[(12)]);
var inst_35268 = (state_35366[(2)]);
var inst_35269 = fluree.db.util.async.throw_err(inst_35268);
var inst_35270 = cljs.core.rest(inst_35245);
var inst_35271 = [inst_35269,inst_35270,inst_35247];
var inst_35272 = (new cljs.core.PersistentVector(null,3,(5),inst_35265,inst_35271,null));
var state_35366__$1 = state_35366;
var statearr_35409_35484 = state_35366__$1;
(statearr_35409_35484[(2)] = inst_35272);

(statearr_35409_35484[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (17))){
var inst_35212 = (state_35366[(7)]);
var inst_35216 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_35212);
var state_35366__$1 = state_35366;
var statearr_35411_35485 = state_35366__$1;
(statearr_35411_35485[(2)] = inst_35216);

(statearr_35411_35485[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (3))){
var inst_35364 = (state_35366[(2)]);
var state_35366__$1 = state_35366;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35366__$1,inst_35364);
} else {
if((state_val_35367 === (12))){
var _ = (function (){var statearr_35412 = state_35366;
(statearr_35412[(4)] = cljs.core.rest((state_35366[(4)])));

return statearr_35412;
})();
var state_35366__$1 = state_35366;
var ex35410 = (state_35366__$1[(2)]);
var statearr_35413_35486 = state_35366__$1;
(statearr_35413_35486[(5)] = ex35410);


var statearr_35414_35487 = state_35366__$1;
(statearr_35414_35487[(1)] = (11));

(statearr_35414_35487[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (2))){
var _ = (function (){var statearr_35415 = state_35366;
(statearr_35415[(4)] = cljs.core.cons((5),(state_35366[(4)])));

return statearr_35415;
})();
var inst_35192 = cljs.core.not_empty(flakes);
var state_35366__$1 = state_35366;
if(cljs.core.truth_(inst_35192)){
var statearr_35416_35488 = state_35366__$1;
(statearr_35416_35488[(1)] = (6));

} else {
var statearr_35417_35489 = state_35366__$1;
(statearr_35417_35489[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (23))){
var inst_35226 = (state_35366[(10)]);
var state_35366__$1 = state_35366;
var statearr_35418_35490 = state_35366__$1;
(statearr_35418_35490[(2)] = inst_35226);

(statearr_35418_35490[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (47))){
var state_35366__$1 = state_35366;
var statearr_35419_35491 = state_35366__$1;
(statearr_35419_35491[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (35))){
var inst_35261 = (state_35366[(18)]);
var inst_35247 = (state_35366[(11)]);
var inst_35255 = (state_35366[(14)]);
var inst_35262 = (state_35366[(15)]);
var inst_35246 = (state_35366[(13)]);
var inst_35278 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_35246,inst_35261,inst_35255,inst_35262,false,inst_35247);
var state_35366__$1 = state_35366;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35366__$1,(38),inst_35278);
} else {
if((state_val_35367 === (19))){
var inst_35206 = (state_35366[(9)]);
var inst_35220 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_35221 = [inst_35206];
var inst_35222 = cljs.core.PersistentHashMap.fromArrays(inst_35220,inst_35221);
var state_35366__$1 = state_35366;
var statearr_35421_35492 = state_35366__$1;
(statearr_35421_35492[(2)] = inst_35222);

(statearr_35421_35492[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (11))){
var inst_35194 = (state_35366[(2)]);
var inst_35195 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35194], 0));
var inst_35196 = (function(){throw inst_35194})();
var state_35366__$1 = (function (){var statearr_35423 = state_35366;
(statearr_35423[(21)] = inst_35195);

return statearr_35423;
})();
var statearr_35424_35493 = state_35366__$1;
(statearr_35424_35493[(2)] = inst_35196);

(statearr_35424_35493[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (9))){
var _ = (function (){var statearr_35425 = state_35366;
(statearr_35425[(4)] = cljs.core.cons((12),(state_35366[(4)])));

return statearr_35425;
})();
var inst_35202 = cljs.core.first(flakes);
var inst_35203 = fluree.db.query.fql.s(inst_35202);
var ___$1 = (function (){var statearr_35426 = state_35366;
(statearr_35426[(4)] = cljs.core.rest((state_35366[(4)])));

return statearr_35426;
})();
var state_35366__$1 = state_35366;
var statearr_35427_35494 = state_35366__$1;
(statearr_35427_35494[(2)] = inst_35203);

(statearr_35427_35494[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (5))){
var _ = (function (){var statearr_35428 = state_35366;
(statearr_35428[(4)] = cljs.core.rest((state_35366[(4)])));

return statearr_35428;
})();
var state_35366__$1 = state_35366;
var ex35422 = (state_35366__$1[(2)]);
var statearr_35429_35495 = state_35366__$1;
(statearr_35429_35495[(5)] = ex35422);


if((ex35422 instanceof Error)){
var statearr_35430_35496 = state_35366__$1;
(statearr_35430_35496[(1)] = (4));

(statearr_35430_35496[(5)] = null);

} else {
throw ex35422;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (14))){
var state_35366__$1 = state_35366;
var statearr_35431_35497 = state_35366__$1;
(statearr_35431_35497[(2)] = base_select_spec);

(statearr_35431_35497[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (45))){
var inst_35307 = (state_35366[(2)]);
var state_35366__$1 = state_35366;
if(cljs.core.truth_(inst_35307)){
var statearr_35432_35498 = state_35366__$1;
(statearr_35432_35498[(1)] = (46));

} else {
var statearr_35433_35499 = state_35366__$1;
(statearr_35433_35499[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (26))){
var inst_35245 = (state_35366[(12)]);
var inst_35249 = cljs.core.empty_QMARK_(inst_35245);
var state_35366__$1 = state_35366;
if(inst_35249){
var statearr_35434_35500 = state_35366__$1;
(statearr_35434_35500[(1)] = (28));

} else {
var statearr_35435_35501 = state_35366__$1;
(statearr_35435_35501[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (16))){
var inst_35213 = (state_35366[(17)]);
var state_35366__$1 = state_35366;
var statearr_35436_35502 = state_35366__$1;
(statearr_35436_35502[(2)] = inst_35213);

(statearr_35436_35502[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (38))){
var inst_35245 = (state_35366[(12)]);
var inst_35280 = (state_35366[(2)]);
var inst_35281 = fluree.db.util.async.throw_err(inst_35280);
var inst_35282 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35281,(0),null);
var inst_35283 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35281,(1),null);
var inst_35284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35285 = cljs.core.rest(inst_35245);
var inst_35286 = [inst_35282,inst_35285,inst_35283];
var inst_35287 = (new cljs.core.PersistentVector(null,3,(5),inst_35284,inst_35286,null));
var state_35366__$1 = state_35366;
var statearr_35437_35503 = state_35366__$1;
(statearr_35437_35503[(2)] = inst_35287);

(statearr_35437_35503[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (30))){
var inst_35343 = (state_35366[(2)]);
var state_35366__$1 = state_35366;
var statearr_35438_35504 = state_35366__$1;
(statearr_35438_35504[(2)] = inst_35343);

(statearr_35438_35504[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (10))){
var inst_35206 = (state_35366[(2)]);
var inst_35207 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_35366__$1 = (function (){var statearr_35439 = state_35366;
(statearr_35439[(9)] = inst_35206);

return statearr_35439;
})();
if(cljs.core.truth_(inst_35207)){
var statearr_35440_35505 = state_35366__$1;
(statearr_35440_35505[(1)] = (13));

} else {
var statearr_35441_35506 = state_35366__$1;
(statearr_35441_35506[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (18))){
var inst_35218 = (state_35366[(2)]);
var state_35366__$1 = state_35366;
if(cljs.core.truth_(inst_35218)){
var statearr_35442_35507 = state_35366__$1;
(statearr_35442_35507[(1)] = (19));

} else {
var statearr_35443_35508 = state_35366__$1;
(statearr_35443_35508[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (42))){
var inst_35247 = (state_35366[(11)]);
var inst_35245 = (state_35366[(12)]);
var inst_35291 = (state_35366[(16)]);
var inst_35294 = (state_35366[(2)]);
var inst_35295 = fluree.db.util.async.throw_err(inst_35294);
var inst_35296 = cljs.core.first(inst_35295);
var inst_35297 = cljs.core.rest(inst_35245);
var inst_35298 = [inst_35296,inst_35297,inst_35247];
var inst_35299 = (new cljs.core.PersistentVector(null,3,(5),inst_35291,inst_35298,null));
var state_35366__$1 = state_35366;
var statearr_35444_35509 = state_35366__$1;
(statearr_35444_35509[(2)] = inst_35299);

(statearr_35444_35509[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (37))){
var inst_35332 = (state_35366[(2)]);
var state_35366__$1 = state_35366;
var statearr_35445_35510 = state_35366__$1;
(statearr_35445_35510[(2)] = inst_35332);

(statearr_35445_35510[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (8))){
var inst_35361 = (state_35366[(2)]);
var _ = (function (){var statearr_35446 = state_35366;
(statearr_35446[(4)] = cljs.core.rest((state_35366[(4)])));

return statearr_35446;
})();
var state_35366__$1 = state_35366;
var statearr_35447_35511 = state_35366__$1;
(statearr_35447_35511[(2)] = inst_35361);

(statearr_35447_35511[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35367 === (49))){
var inst_35247 = (state_35366[(11)]);
var inst_35245 = (state_35366[(12)]);
var inst_35246 = (state_35366[(13)]);
var inst_35320 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35321 = cljs.core.rest(inst_35245);
var inst_35322 = [inst_35246,inst_35321,inst_35247];
var inst_35323 = (new cljs.core.PersistentVector(null,3,(5),inst_35320,inst_35322,null));
var state_35366__$1 = state_35366;
var statearr_35448_35512 = state_35366__$1;
(statearr_35448_35512[(2)] = inst_35323);

(statearr_35448_35512[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__11438__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__11438__auto____0 = (function (){
var statearr_35449 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35449[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__11438__auto__);

(statearr_35449[(1)] = (1));

return statearr_35449;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__11438__auto____1 = (function (state_35366){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_35366);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e35450){var ex__11441__auto__ = e35450;
var statearr_35451_35513 = state_35366;
(statearr_35451_35513[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_35366[(4)]))){
var statearr_35452_35514 = state_35366;
(statearr_35452_35514[(1)] = cljs.core.first((state_35366[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35515 = state_35366;
state_35366 = G__35515;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__11438__auto__ = function(state_35366){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__11438__auto____1.call(this,state_35366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__11438__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__11438__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_35453 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_35453[(6)] = c__11512__auto__);

return statearr_35453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__35518 = arguments.length;
switch (G__35518) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_35560){
var state_val_35561 = (state_35560[(1)]);
if((state_val_35561 === (7))){
var inst_35526 = (state_35560[(7)]);
var state_35560__$1 = state_35560;
var statearr_35562_35592 = state_35560__$1;
(statearr_35562_35592[(2)] = inst_35526);

(statearr_35562_35592[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35561 === (1))){
var state_35560__$1 = state_35560;
var statearr_35563_35593 = state_35560__$1;
(statearr_35563_35593[(2)] = null);

(statearr_35563_35593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35561 === (4))){
var inst_35519 = (state_35560[(2)]);
var state_35560__$1 = state_35560;
var statearr_35564_35594 = state_35560__$1;
(statearr_35564_35594[(2)] = inst_35519);

(statearr_35564_35594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35561 === (15))){
var inst_35554 = (state_35560[(2)]);
var inst_35555 = fluree.db.util.async.throw_err(inst_35554);
var _ = (function (){var statearr_35565 = state_35560;
(statearr_35565[(4)] = cljs.core.rest((state_35560[(4)])));

return statearr_35565;
})();
var state_35560__$1 = state_35560;
var statearr_35566_35595 = state_35560__$1;
(statearr_35566_35595[(2)] = inst_35555);

(statearr_35566_35595[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35561 === (13))){
var inst_35538 = (state_35560[(8)]);
var state_35560__$1 = state_35560;
var statearr_35567_35596 = state_35560__$1;
(statearr_35567_35596[(2)] = inst_35538);

(statearr_35567_35596[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35561 === (6))){
var inst_35526 = (state_35560[(7)]);
var inst_35528 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_35529 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_35526,inst_35528);
var state_35560__$1 = state_35560;
var statearr_35568_35597 = state_35560__$1;
(statearr_35568_35597[(2)] = inst_35529);

(statearr_35568_35597[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35561 === (3))){
var inst_35558 = (state_35560[(2)]);
var state_35560__$1 = state_35560;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35560__$1,inst_35558);
} else {
if((state_val_35561 === (12))){
var inst_35538 = (state_35560[(8)]);
var inst_35540 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_35541 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_35538,inst_35540);
var state_35560__$1 = state_35560;
var statearr_35569_35598 = state_35560__$1;
(statearr_35569_35598[(2)] = inst_35541);

(statearr_35569_35598[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35561 === (2))){
var _ = (function (){var statearr_35570 = state_35560;
(statearr_35570[(4)] = cljs.core.cons((5),(state_35560[(4)])));

return statearr_35570;
})();
var inst_35526 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_35560__$1 = (function (){var statearr_35571 = state_35560;
(statearr_35571[(7)] = inst_35526);

return statearr_35571;
})();
if(cljs.core.truth_(fuel)){
var statearr_35572_35599 = state_35560__$1;
(statearr_35572_35599[(1)] = (6));

} else {
var statearr_35573_35600 = state_35560__$1;
(statearr_35573_35600[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35561 === (11))){
var inst_35538 = (state_35560[(2)]);
var state_35560__$1 = (function (){var statearr_35575 = state_35560;
(statearr_35575[(8)] = inst_35538);

return statearr_35575;
})();
if(cljs.core.truth_(limit)){
var statearr_35576_35601 = state_35560__$1;
(statearr_35576_35601[(1)] = (12));

} else {
var statearr_35577_35602 = state_35560__$1;
(statearr_35577_35602[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35561 === (9))){
var inst_35532 = (state_35560[(9)]);
var inst_35534 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_35535 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_35532,inst_35534);
var state_35560__$1 = state_35560;
var statearr_35578_35603 = state_35560__$1;
(statearr_35578_35603[(2)] = inst_35535);

(statearr_35578_35603[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35561 === (5))){
var _ = (function (){var statearr_35579 = state_35560;
(statearr_35579[(4)] = cljs.core.rest((state_35560[(4)])));

return statearr_35579;
})();
var state_35560__$1 = state_35560;
var ex35574 = (state_35560__$1[(2)]);
var statearr_35580_35604 = state_35560__$1;
(statearr_35580_35604[(5)] = ex35574);


if((ex35574 instanceof Error)){
var statearr_35581_35605 = state_35560__$1;
(statearr_35581_35605[(1)] = (4));

(statearr_35581_35605[(5)] = null);

} else {
throw ex35574;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35561 === (14))){
var inst_35544 = (state_35560[(2)]);
var inst_35545 = (function (){return (function (x){
var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__5043__auto__;
}
});
})();
var inst_35546 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_35545);
var inst_35547 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_35544,inst_35546);
var inst_35548 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_35547,flakes);
var inst_35549 = cljs.core.PersistentVector.EMPTY;
var inst_35550 = (function (){var xf = inst_35547;
var flakes_by_sub = inst_35548;
return (function (p1__35516_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__35516_SHARP_);
});
})();
var inst_35551 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35550,inst_35548);
var inst_35552 = fluree.db.util.async.merge_into_QMARK_(inst_35549,inst_35551);
var state_35560__$1 = state_35560;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35560__$1,(15),inst_35552);
} else {
if((state_val_35561 === (10))){
var inst_35532 = (state_35560[(9)]);
var state_35560__$1 = state_35560;
var statearr_35582_35606 = state_35560__$1;
(statearr_35582_35606[(2)] = inst_35532);

(statearr_35582_35606[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35561 === (8))){
var inst_35532 = (state_35560[(2)]);
var state_35560__$1 = (function (){var statearr_35583 = state_35560;
(statearr_35583[(9)] = inst_35532);

return statearr_35583;
})();
if(cljs.core.truth_(offset)){
var statearr_35584_35607 = state_35560__$1;
(statearr_35584_35607[(1)] = (9));

} else {
var statearr_35585_35608 = state_35560__$1;
(statearr_35585_35608[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__11438__auto__ = null;
var fluree$db$query$fql$state_machine__11438__auto____0 = (function (){
var statearr_35586 = [null,null,null,null,null,null,null,null,null,null];
(statearr_35586[(0)] = fluree$db$query$fql$state_machine__11438__auto__);

(statearr_35586[(1)] = (1));

return statearr_35586;
});
var fluree$db$query$fql$state_machine__11438__auto____1 = (function (state_35560){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_35560);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e35587){var ex__11441__auto__ = e35587;
var statearr_35588_35609 = state_35560;
(statearr_35588_35609[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_35560[(4)]))){
var statearr_35589_35610 = state_35560;
(statearr_35589_35610[(1)] = cljs.core.first((state_35560[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35611 = state_35560;
state_35560 = G__35611;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__11438__auto__ = function(state_35560){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__11438__auto____1.call(this,state_35560);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__11438__auto____0;
fluree$db$query$fql$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__11438__auto____1;
return fluree$db$query$fql$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_35590 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_35590[(6)] = c__11512__auto__);

return statearr_35590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__35613 = arguments.length;
switch (G__35613) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_35699){
var state_val_35700 = (state_35699[(1)]);
if((state_val_35700 === (7))){
var inst_35694 = (state_35699[(2)]);
var _ = (function (){var statearr_35702 = state_35699;
(statearr_35702[(4)] = cljs.core.rest((state_35699[(4)])));

return statearr_35702;
})();
var state_35699__$1 = state_35699;
var statearr_35703_35755 = state_35699__$1;
(statearr_35703_35755[(2)] = inst_35694);

(statearr_35703_35755[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (20))){
var inst_35641 = (state_35699[(7)]);
var inst_35634 = (state_35699[(8)]);
var inst_35633 = (state_35699[(9)]);
var inst_35662 = (inst_35633 + (1));
var tmp35701 = inst_35634;
var inst_35632 = inst_35641;
var inst_35633__$1 = inst_35662;
var inst_35634__$1 = tmp35701;
var state_35699__$1 = (function (){var statearr_35704 = state_35699;
(statearr_35704[(8)] = inst_35634__$1);

(statearr_35704[(9)] = inst_35633__$1);

(statearr_35704[(10)] = inst_35632);

return statearr_35704;
})();
var statearr_35705_35756 = state_35699__$1;
(statearr_35705_35756[(2)] = null);

(statearr_35705_35756[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (27))){
var inst_35672 = (state_35699[(11)]);
var inst_35674 = cljs.core.count(inst_35672);
var inst_35675 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_35674);
var state_35699__$1 = state_35699;
var statearr_35706_35757 = state_35699__$1;
(statearr_35706_35757[(2)] = inst_35675);

(statearr_35706_35757[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (1))){
var state_35699__$1 = state_35699;
var statearr_35707_35758 = state_35699__$1;
(statearr_35707_35758[(2)] = null);

(statearr_35707_35758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (24))){
var state_35699__$1 = state_35699;
var statearr_35708_35759 = state_35699__$1;
(statearr_35708_35759[(2)] = null);

(statearr_35708_35759[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (4))){
var inst_35614 = (state_35699[(2)]);
var state_35699__$1 = state_35699;
var statearr_35709_35760 = state_35699__$1;
(statearr_35709_35760[(2)] = inst_35614);

(statearr_35709_35760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (15))){
var inst_35655 = (state_35699[(12)]);
var inst_35655__$1 = offset;
var state_35699__$1 = (function (){var statearr_35710 = state_35699;
(statearr_35710[(12)] = inst_35655__$1);

return statearr_35710;
})();
if(cljs.core.truth_(inst_35655__$1)){
var statearr_35711_35761 = state_35699__$1;
(statearr_35711_35761[(1)] = (17));

} else {
var statearr_35712_35762 = state_35699__$1;
(statearr_35712_35762[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (21))){
var state_35699__$1 = state_35699;
var statearr_35713_35763 = state_35699__$1;
(statearr_35713_35763[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (13))){
var inst_35650 = (state_35699[(2)]);
var state_35699__$1 = state_35699;
var statearr_35715_35764 = state_35699__$1;
(statearr_35715_35764[(2)] = inst_35650);

(statearr_35715_35764[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (22))){
var inst_35690 = (state_35699[(2)]);
var state_35699__$1 = state_35699;
var statearr_35716_35765 = state_35699__$1;
(statearr_35716_35765[(2)] = inst_35690);

(statearr_35716_35765[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (29))){
var inst_35633 = (state_35699[(9)]);
var inst_35672 = (state_35699[(11)]);
var inst_35678 = (state_35699[(2)]);
var inst_35679 = (inst_35633 + (1));
var inst_35680 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,inst_35672);
var state_35699__$1 = (function (){var statearr_35717 = state_35699;
(statearr_35717[(13)] = inst_35679);

(statearr_35717[(14)] = inst_35678);

return statearr_35717;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35699__$1,(30),inst_35680);
} else {
if((state_val_35700 === (6))){
var inst_35640 = (state_35699[(15)]);
var inst_35642 = (state_35699[(16)]);
var inst_35632 = (state_35699[(10)]);
var inst_35639 = cljs.core.seq(inst_35632);
var inst_35640__$1 = cljs.core.first(inst_35639);
var inst_35641 = cljs.core.next(inst_35639);
var inst_35642__$1 = (inst_35640__$1 == null);
var state_35699__$1 = (function (){var statearr_35718 = state_35699;
(statearr_35718[(7)] = inst_35641);

(statearr_35718[(15)] = inst_35640__$1);

(statearr_35718[(16)] = inst_35642__$1);

return statearr_35718;
})();
if(cljs.core.truth_(inst_35642__$1)){
var statearr_35719_35766 = state_35699__$1;
(statearr_35719_35766[(1)] = (8));

} else {
var statearr_35720_35767 = state_35699__$1;
(statearr_35720_35767[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (28))){
var state_35699__$1 = state_35699;
var statearr_35721_35768 = state_35699__$1;
(statearr_35721_35768[(2)] = null);

(statearr_35721_35768[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (25))){
var inst_35688 = (state_35699[(2)]);
var state_35699__$1 = state_35699;
var statearr_35722_35769 = state_35699__$1;
(statearr_35722_35769[(2)] = inst_35688);

(statearr_35722_35769[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (17))){
var inst_35633 = (state_35699[(9)]);
var inst_35657 = (inst_35633 < offset);
var state_35699__$1 = state_35699;
var statearr_35723_35770 = state_35699__$1;
(statearr_35723_35770[(2)] = inst_35657);

(statearr_35723_35770[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (3))){
var inst_35697 = (state_35699[(2)]);
var state_35699__$1 = state_35699;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35699__$1,inst_35697);
} else {
if((state_val_35700 === (12))){
var inst_35645 = (state_35699[(17)]);
var state_35699__$1 = state_35699;
var statearr_35724_35771 = state_35699__$1;
(statearr_35724_35771[(2)] = inst_35645);

(statearr_35724_35771[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (2))){
var _ = (function (){var statearr_35725 = state_35699;
(statearr_35725[(4)] = cljs.core.cons((5),(state_35699[(4)])));

return statearr_35725;
})();
var inst_35627 = subjects;
var inst_35628 = cljs.core.seq(inst_35627);
var inst_35629 = cljs.core.first(inst_35628);
var inst_35630 = cljs.core.next(inst_35628);
var inst_35631 = cljs.core.PersistentVector.EMPTY;
var inst_35632 = inst_35627;
var inst_35633 = (0);
var inst_35634 = inst_35631;
var state_35699__$1 = (function (){var statearr_35726 = state_35699;
(statearr_35726[(18)] = inst_35629);

(statearr_35726[(8)] = inst_35634);

(statearr_35726[(19)] = inst_35630);

(statearr_35726[(9)] = inst_35633);

(statearr_35726[(10)] = inst_35632);

return statearr_35726;
})();
var statearr_35727_35772 = state_35699__$1;
(statearr_35727_35772[(2)] = null);

(statearr_35727_35772[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (23))){
var inst_35640 = (state_35699[(15)]);
var inst_35666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35667 = [inst_35640];
var inst_35668 = (new cljs.core.PersistentVector(null,1,(5),inst_35666,inst_35667,null));
var inst_35669 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_35668);
var state_35699__$1 = state_35699;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35699__$1,(26),inst_35669);
} else {
if((state_val_35700 === (19))){
var inst_35660 = (state_35699[(2)]);
var state_35699__$1 = state_35699;
if(cljs.core.truth_(inst_35660)){
var statearr_35728_35773 = state_35699__$1;
(statearr_35728_35773[(1)] = (20));

} else {
var statearr_35729_35774 = state_35699__$1;
(statearr_35729_35774[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (11))){
var inst_35633 = (state_35699[(9)]);
var inst_35647 = (inst_35633 > limit);
var state_35699__$1 = state_35699;
var statearr_35731_35775 = state_35699__$1;
(statearr_35731_35775[(2)] = inst_35647);

(statearr_35731_35775[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (9))){
var inst_35645 = (state_35699[(17)]);
var inst_35645__$1 = limit;
var state_35699__$1 = (function (){var statearr_35732 = state_35699;
(statearr_35732[(17)] = inst_35645__$1);

return statearr_35732;
})();
if(cljs.core.truth_(inst_35645__$1)){
var statearr_35733_35776 = state_35699__$1;
(statearr_35733_35776[(1)] = (11));

} else {
var statearr_35734_35777 = state_35699__$1;
(statearr_35734_35777[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (5))){
var _ = (function (){var statearr_35735 = state_35699;
(statearr_35735[(4)] = cljs.core.rest((state_35699[(4)])));

return statearr_35735;
})();
var state_35699__$1 = state_35699;
var ex35730 = (state_35699__$1[(2)]);
var statearr_35736_35778 = state_35699__$1;
(statearr_35736_35778[(5)] = ex35730);


if((ex35730 instanceof Error)){
var statearr_35737_35779 = state_35699__$1;
(statearr_35737_35779[(1)] = (4));

(statearr_35737_35779[(5)] = null);

} else {
throw ex35730;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (14))){
var inst_35634 = (state_35699[(8)]);
var state_35699__$1 = state_35699;
var statearr_35738_35780 = state_35699__$1;
(statearr_35738_35780[(2)] = inst_35634);

(statearr_35738_35780[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (26))){
var inst_35671 = (state_35699[(2)]);
var inst_35672 = fluree.db.util.async.throw_err(inst_35671);
var state_35699__$1 = (function (){var statearr_35739 = state_35699;
(statearr_35739[(11)] = inst_35672);

return statearr_35739;
})();
if(cljs.core.truth_(fuel)){
var statearr_35740_35781 = state_35699__$1;
(statearr_35740_35781[(1)] = (27));

} else {
var statearr_35741_35782 = state_35699__$1;
(statearr_35741_35782[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (16))){
var inst_35692 = (state_35699[(2)]);
var state_35699__$1 = state_35699;
var statearr_35742_35783 = state_35699__$1;
(statearr_35742_35783[(2)] = inst_35692);

(statearr_35742_35783[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (30))){
var inst_35679 = (state_35699[(13)]);
var inst_35641 = (state_35699[(7)]);
var inst_35634 = (state_35699[(8)]);
var inst_35682 = (state_35699[(2)]);
var inst_35683 = fluree.db.util.async.throw_err(inst_35682);
var inst_35684 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35634,inst_35683);
var inst_35632 = inst_35641;
var inst_35633 = inst_35679;
var inst_35634__$1 = inst_35684;
var state_35699__$1 = (function (){var statearr_35743 = state_35699;
(statearr_35743[(8)] = inst_35634__$1);

(statearr_35743[(9)] = inst_35633);

(statearr_35743[(10)] = inst_35632);

return statearr_35743;
})();
var statearr_35744_35784 = state_35699__$1;
(statearr_35744_35784[(2)] = null);

(statearr_35744_35784[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (10))){
var inst_35652 = (state_35699[(2)]);
var state_35699__$1 = state_35699;
if(cljs.core.truth_(inst_35652)){
var statearr_35745_35785 = state_35699__$1;
(statearr_35745_35785[(1)] = (14));

} else {
var statearr_35746_35786 = state_35699__$1;
(statearr_35746_35786[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (18))){
var inst_35655 = (state_35699[(12)]);
var state_35699__$1 = state_35699;
var statearr_35747_35787 = state_35699__$1;
(statearr_35747_35787[(2)] = inst_35655);

(statearr_35747_35787[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35700 === (8))){
var inst_35642 = (state_35699[(16)]);
var state_35699__$1 = state_35699;
var statearr_35748_35788 = state_35699__$1;
(statearr_35748_35788[(2)] = inst_35642);

(statearr_35748_35788[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__11438__auto__ = null;
var fluree$db$query$fql$state_machine__11438__auto____0 = (function (){
var statearr_35749 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35749[(0)] = fluree$db$query$fql$state_machine__11438__auto__);

(statearr_35749[(1)] = (1));

return statearr_35749;
});
var fluree$db$query$fql$state_machine__11438__auto____1 = (function (state_35699){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_35699);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e35750){var ex__11441__auto__ = e35750;
var statearr_35751_35789 = state_35699;
(statearr_35751_35789[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_35699[(4)]))){
var statearr_35752_35790 = state_35699;
(statearr_35752_35790[(1)] = cljs.core.first((state_35699[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35791 = state_35699;
state_35699 = G__35791;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__11438__auto__ = function(state_35699){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__11438__auto____1.call(this,state_35699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__11438__auto____0;
fluree$db$query$fql$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__11438__auto____1;
return fluree$db$query$fql$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_35753 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_35753[(6)] = c__11512__auto__);

return statearr_35753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__5045__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__35793 = arguments.length;
switch (G__35793) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where_clause,null,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4 = (function (db,where_clause,default_collection,p__35794){
var map__35795 = p__35794;
var map__35795__$1 = cljs.core.__destructure_map(map__35795);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35795__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35795__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_36059){
var state_val_36060 = (state_36059[(1)]);
if((state_val_36060 === (65))){
var inst_36022 = (state_36059[(7)]);
var inst_36022__$1 = (state_36059[(2)]);
var state_36059__$1 = (function (){var statearr_36061 = state_36059;
(statearr_36061[(7)] = inst_36022__$1);

return statearr_36061;
})();
if(cljs.core.truth_(inst_36022__$1)){
var statearr_36062_36180 = state_36059__$1;
(statearr_36062_36180[(1)] = (66));

} else {
var statearr_36063_36181 = state_36059__$1;
(statearr_36063_36181[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (70))){
var inst_36025 = (state_36059[(8)]);
var state_36059__$1 = state_36059;
var statearr_36064_36182 = state_36059__$1;
(statearr_36064_36182[(2)] = inst_36025);

(statearr_36064_36182[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (62))){
var inst_36013 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
var statearr_36065_36183 = state_36059__$1;
(statearr_36065_36183[(2)] = inst_36013);

(statearr_36065_36183[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (74))){
var inst_36032 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
var statearr_36066_36184 = state_36059__$1;
(statearr_36066_36184[(2)] = inst_36032);

(statearr_36066_36184[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (7))){
var inst_35808 = (state_36059[(9)]);
var state_36059__$1 = state_36059;
var statearr_36067_36185 = state_36059__$1;
(statearr_36067_36185[(2)] = inst_35808);

(statearr_36067_36185[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (59))){
var inst_35837 = (state_36059[(10)]);
var inst_36005 = cljs.core.empty_QMARK_(inst_35837);
var state_36059__$1 = state_36059;
if(inst_36005){
var statearr_36068_36186 = state_36059__$1;
(statearr_36068_36186[(1)] = (60));

} else {
var statearr_36069_36187 = state_36059__$1;
(statearr_36069_36187[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (20))){
var state_36059__$1 = state_36059;
if(cljs.core.truth_(offset)){
var statearr_36070_36188 = state_36059__$1;
(statearr_36070_36188[(1)] = (23));

} else {
var statearr_36071_36189 = state_36059__$1;
(statearr_36071_36189[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (72))){
var inst_35822 = (state_36059[(11)]);
var inst_36002 = (state_36059[(12)]);
var inst_36028 = cljs.core.count(inst_36002);
var inst_36029 = (inst_36028 > inst_35822);
var state_36059__$1 = state_36059;
var statearr_36072_36190 = state_36059__$1;
(statearr_36072_36190[(2)] = inst_36029);

(statearr_36072_36190[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (58))){
var inst_35837 = (state_36059[(10)]);
var inst_36002 = (state_36059[(12)]);
var inst_36003 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35837,inst_36002);
var state_36059__$1 = state_36059;
var statearr_36073_36191 = state_36059__$1;
(statearr_36073_36191[(2)] = inst_36003);

(statearr_36073_36191[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (60))){
var inst_35837 = (state_36059[(10)]);
var inst_36002 = (state_36059[(12)]);
var inst_36007 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35837,inst_36002);
var state_36059__$1 = state_36059;
var statearr_36074_36192 = state_36059__$1;
(statearr_36074_36192[(2)] = inst_36007);

(statearr_36074_36192[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (27))){
var inst_35852 = (state_36059[(13)]);
var state_36059__$1 = state_36059;
var statearr_36075_36193 = state_36059__$1;
(statearr_36075_36193[(2)] = inst_35852);

(statearr_36075_36193[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (1))){
var state_36059__$1 = state_36059;
var statearr_36076_36194 = state_36059__$1;
(statearr_36076_36194[(2)] = null);

(statearr_36076_36194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (69))){
var inst_35822 = (state_36059[(11)]);
var state_36059__$1 = state_36059;
if(cljs.core.truth_(inst_35822)){
var statearr_36077_36195 = state_36059__$1;
(statearr_36077_36195[(1)] = (72));

} else {
var statearr_36078_36196 = state_36059__$1;
(statearr_36078_36196[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (24))){
var inst_35837 = (state_36059[(10)]);
var state_36059__$1 = state_36059;
var statearr_36079_36197 = state_36059__$1;
(statearr_36079_36197[(2)] = inst_35837);

(statearr_36079_36197[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (55))){
var inst_35991 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
var statearr_36080_36198 = state_36059__$1;
(statearr_36080_36198[(2)] = inst_35991);

(statearr_36080_36198[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (39))){
var inst_35999 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
var statearr_36081_36199 = state_36059__$1;
(statearr_36081_36199[(2)] = inst_35999);

(statearr_36081_36199[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (46))){
var inst_35881 = (state_36059[(14)]);
var inst_35863 = (state_36059[(15)]);
var inst_35957 = (inst_35881.cljs$core$IFn$_invoke$arity$2 ? inst_35881.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_35863) : inst_35881.call(null,cljs.core._LT_,inst_35863));
var state_36059__$1 = state_36059;
if(cljs.core.truth_(inst_35957)){
var statearr_36082_36200 = state_36059__$1;
(statearr_36082_36200[(1)] = (49));

} else {
var statearr_36083_36201 = state_36059__$1;
(statearr_36083_36201[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (4))){
var inst_35796 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
var statearr_36084_36202 = state_36059__$1;
(statearr_36084_36202[(2)] = inst_35796);

(statearr_36084_36202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (77))){
var inst_36047 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
var statearr_36085_36203 = state_36059__$1;
(statearr_36085_36203[(2)] = inst_36047);

(statearr_36085_36203[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (54))){
var inst_35989 = cljs.core.PersistentVector.EMPTY;
var state_36059__$1 = state_36059;
var statearr_36086_36204 = state_36059__$1;
(statearr_36086_36204[(2)] = inst_35989);

(statearr_36086_36204[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (15))){
var inst_35807 = (state_36059[(16)]);
var inst_35832 = cljs.core.seq(inst_35807);
var inst_35833 = cljs.core.first(inst_35832);
var inst_35834 = cljs.core.next(inst_35832);
var inst_35835 = cljs.core.PersistentHashSet.EMPTY;
var inst_35836 = inst_35807;
var inst_35837 = inst_35835;
var state_36059__$1 = (function (){var statearr_36087 = state_36059;
(statearr_36087[(17)] = inst_35834);

(statearr_36087[(10)] = inst_35837);

(statearr_36087[(18)] = inst_35833);

(statearr_36087[(19)] = inst_35836);

return statearr_36087;
})();
var statearr_36088_36205 = state_36059__$1;
(statearr_36088_36205[(2)] = null);

(statearr_36088_36205[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (48))){
var inst_35954 = (state_36059[(2)]);
var inst_35955 = fluree.db.util.async.throw_err(inst_35954);
var state_36059__$1 = state_36059;
var statearr_36089_36206 = state_36059__$1;
(statearr_36089_36206[(2)] = inst_35955);

(statearr_36089_36206[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (50))){
var inst_35881 = (state_36059[(14)]);
var inst_35863 = (state_36059[(15)]);
var inst_35973 = (inst_35881.cljs$core$IFn$_invoke$arity$2 ? inst_35881.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_35863) : inst_35881.call(null,cljs.core._LT__EQ_,inst_35863));
var state_36059__$1 = state_36059;
if(cljs.core.truth_(inst_35973)){
var statearr_36090_36207 = state_36059__$1;
(statearr_36090_36207[(1)] = (53));

} else {
var statearr_36091_36208 = state_36059__$1;
(statearr_36091_36208[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (75))){
var state_36059__$1 = state_36059;
if(cljs.core.truth_(offset)){
var statearr_36092_36209 = state_36059__$1;
(statearr_36092_36209[(1)] = (78));

} else {
var statearr_36093_36210 = state_36059__$1;
(statearr_36093_36210[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (21))){
var inst_35862 = (state_36059[(20)]);
var inst_35843 = (state_36059[(21)]);
var inst_35862__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35843,(0),null);
var inst_35863 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35843,(1),null);
var inst_35864 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35843,(2),null);
var inst_35865 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_35862__$1);
var inst_35866 = cljs.core.not(inst_35865);
var state_36059__$1 = (function (){var statearr_36094 = state_36059;
(statearr_36094[(20)] = inst_35862__$1);

(statearr_36094[(15)] = inst_35863);

(statearr_36094[(22)] = inst_35864);

return statearr_36094;
})();
if(inst_35866){
var statearr_36095_36211 = state_36059__$1;
(statearr_36095_36211[(1)] = (29));

} else {
var statearr_36096_36212 = state_36059__$1;
(statearr_36096_36212[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (31))){
var inst_35881 = (state_36059[(14)]);
var inst_35863 = (state_36059[(15)]);
var inst_35877 = (state_36059[(2)]);
var inst_35881__$1 = cljs.core.identical_QMARK_;
var inst_35882 = (inst_35881__$1.cljs$core$IFn$_invoke$arity$2 ? inst_35881__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_35863) : inst_35881__$1.call(null,cljs.core.not_EQ_,inst_35863));
var state_36059__$1 = (function (){var statearr_36097 = state_36059;
(statearr_36097[(14)] = inst_35881__$1);

(statearr_36097[(23)] = inst_35877);

return statearr_36097;
})();
if(cljs.core.truth_(inst_35882)){
var statearr_36098_36213 = state_36059__$1;
(statearr_36098_36213[(1)] = (32));

} else {
var statearr_36099_36214 = state_36059__$1;
(statearr_36099_36214[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (32))){
var inst_35822 = (state_36059[(11)]);
var inst_35862 = (state_36059[(20)]);
var inst_35864 = (state_36059[(22)]);
var inst_35884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35885 = [inst_35862,inst_35864];
var inst_35886 = (new cljs.core.PersistentVector(null,2,(5),inst_35884,inst_35885,null));
var inst_35887 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35888 = [inst_35862];
var inst_35889 = (new cljs.core.PersistentVector(null,1,(5),inst_35887,inst_35888,null));
var inst_35890 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35891 = [inst_35822];
var inst_35892 = cljs.core.PersistentHashMap.fromArrays(inst_35890,inst_35891);
var inst_35893 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_35886,cljs.core._LT__EQ_,inst_35889,inst_35892);
var state_36059__$1 = state_36059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36059__$1,(35),inst_35893);
} else {
if((state_val_36060 === (40))){
var inst_35922 = (state_36059[(2)]);
var inst_35923 = fluree.db.util.async.throw_err(inst_35922);
var state_36059__$1 = state_36059;
var statearr_36100_36215 = state_36059__$1;
(statearr_36100_36215[(2)] = inst_35923);

(statearr_36100_36215[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (56))){
var inst_35986 = (state_36059[(2)]);
var inst_35987 = fluree.db.util.async.throw_err(inst_35986);
var state_36059__$1 = state_36059;
var statearr_36101_36216 = state_36059__$1;
(statearr_36101_36216[(2)] = inst_35987);

(statearr_36101_36216[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (33))){
var inst_35881 = (state_36059[(14)]);
var inst_35863 = (state_36059[(15)]);
var inst_35912 = (inst_35881.cljs$core$IFn$_invoke$arity$2 ? inst_35881.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_35863) : inst_35881.call(null,cljs.core._EQ_,inst_35863));
var state_36059__$1 = state_36059;
if(cljs.core.truth_(inst_35912)){
var statearr_36102_36217 = state_36059__$1;
(statearr_36102_36217[(1)] = (37));

} else {
var statearr_36103_36218 = state_36059__$1;
(statearr_36103_36218[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (13))){
var state_36059__$1 = state_36059;
var statearr_36104_36219 = state_36059__$1;
(statearr_36104_36219[(2)] = limit);

(statearr_36104_36219[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (22))){
var inst_36049 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
var statearr_36105_36220 = state_36059__$1;
(statearr_36105_36220[(2)] = inst_36049);

(statearr_36105_36220[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (36))){
var inst_35896 = (state_36059[(24)]);
var inst_35908 = (state_36059[(2)]);
var inst_35909 = fluree.db.util.async.throw_err(inst_35908);
var inst_35910 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_35896,inst_35909);
var state_36059__$1 = state_36059;
var statearr_36106_36221 = state_36059__$1;
(statearr_36106_36221[(2)] = inst_35910);

(statearr_36106_36221[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (41))){
var inst_35822 = (state_36059[(11)]);
var inst_35862 = (state_36059[(20)]);
var inst_35864 = (state_36059[(22)]);
var inst_35927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35928 = [inst_35862,inst_35864];
var inst_35929 = (new cljs.core.PersistentVector(null,2,(5),inst_35927,inst_35928,null));
var inst_35930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35931 = [inst_35862];
var inst_35932 = (new cljs.core.PersistentVector(null,1,(5),inst_35930,inst_35931,null));
var inst_35933 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35934 = [inst_35822];
var inst_35935 = cljs.core.PersistentHashMap.fromArrays(inst_35933,inst_35934);
var inst_35936 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_35929,cljs.core._LT__EQ_,inst_35932,inst_35935);
var state_36059__$1 = state_36059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36059__$1,(44),inst_35936);
} else {
if((state_val_36060 === (43))){
var inst_35997 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
var statearr_36107_36222 = state_36059__$1;
(statearr_36107_36222[(2)] = inst_35997);

(statearr_36107_36222[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (61))){
var inst_35837 = (state_36059[(10)]);
var inst_36002 = (state_36059[(12)]);
var inst_36009 = cljs.core.PersistentHashSet.EMPTY;
var inst_36010 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36009,inst_36002);
var inst_36011 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_35837,inst_36010);
var state_36059__$1 = state_36059;
var statearr_36108_36223 = state_36059__$1;
(statearr_36108_36223[(2)] = inst_36011);

(statearr_36108_36223[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (29))){
var inst_35862 = (state_36059[(20)]);
var inst_35868 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_35862);
var inst_35869 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35868)].join('');
var inst_35870 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_35871 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_35872 = cljs.core.PersistentHashMap.fromArrays(inst_35870,inst_35871);
var inst_35873 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35869,inst_35872);
var inst_35874 = (function(){throw inst_35873})();
var state_36059__$1 = state_36059;
var statearr_36109_36224 = state_36059__$1;
(statearr_36109_36224[(2)] = inst_35874);

(statearr_36109_36224[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (44))){
var inst_35938 = (state_36059[(2)]);
var inst_35939 = fluree.db.util.async.throw_err(inst_35938);
var state_36059__$1 = state_36059;
var statearr_36110_36225 = state_36059__$1;
(statearr_36110_36225[(2)] = inst_35939);

(statearr_36110_36225[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (6))){
var inst_35806 = (state_36059[(25)]);
var inst_35810 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_35806);
var state_36059__$1 = state_36059;
var statearr_36111_36226 = state_36059__$1;
(statearr_36111_36226[(2)] = inst_35810);

(statearr_36111_36226[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (28))){
var inst_35857 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
var statearr_36112_36227 = state_36059__$1;
(statearr_36112_36227[(2)] = inst_35857);

(statearr_36112_36227[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (64))){
var inst_36017 = (state_36059[(26)]);
var state_36059__$1 = state_36059;
var statearr_36113_36228 = state_36059__$1;
(statearr_36113_36228[(2)] = inst_36017);

(statearr_36113_36228[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (51))){
var inst_35993 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
var statearr_36114_36229 = state_36059__$1;
(statearr_36114_36229[(2)] = inst_35993);

(statearr_36114_36229[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (25))){
var inst_35852 = (state_36059[(2)]);
var state_36059__$1 = (function (){var statearr_36115 = state_36059;
(statearr_36115[(13)] = inst_35852);

return statearr_36115;
})();
if(cljs.core.truth_(limit)){
var statearr_36116_36230 = state_36059__$1;
(statearr_36116_36230[(1)] = (26));

} else {
var statearr_36117_36231 = state_36059__$1;
(statearr_36117_36231[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (34))){
var inst_35806 = (state_36059[(25)]);
var inst_36001 = (state_36059[(2)]);
var inst_36002 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_36001);
var state_36059__$1 = (function (){var statearr_36118 = state_36059;
(statearr_36118[(12)] = inst_36002);

return statearr_36118;
})();
var G__36119_36232 = inst_35806;
var G__36119_36233__$1 = (((G__36119_36232 instanceof cljs.core.Keyword))?G__36119_36232.fqn:null);
switch (G__36119_36233__$1) {
case "or":
var statearr_36120_36235 = state_36059__$1;
(statearr_36120_36235[(1)] = (58));


break;
case "and":
var statearr_36121_36236 = state_36059__$1;
(statearr_36121_36236[(1)] = (59));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__36119_36233__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (17))){
var inst_36054 = (state_36059[(2)]);
var _ = (function (){var statearr_36122 = state_36059;
(statearr_36122[(4)] = cljs.core.rest((state_36059[(4)])));

return statearr_36122;
})();
var state_36059__$1 = state_36059;
var statearr_36123_36237 = state_36059__$1;
(statearr_36123_36237[(2)] = inst_36054);

(statearr_36123_36237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (3))){
var inst_36057 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36059__$1,inst_36057);
} else {
if((state_val_36060 === (12))){
var inst_35816 = (offset + limit);
var state_36059__$1 = state_36059;
var statearr_36124_36238 = state_36059__$1;
(statearr_36124_36238[(2)] = inst_35816);

(statearr_36124_36238[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (2))){
var inst_35808 = (state_36059[(9)]);
var _ = (function (){var statearr_36125 = state_36059;
(statearr_36125[(4)] = cljs.core.cons((5),(state_36059[(4)])));

return statearr_36125;
})();
var inst_35805 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_35806 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35805,(0),null);
var inst_35807 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35805,(1),null);
var inst_35808__$1 = limit;
var state_36059__$1 = (function (){var statearr_36126 = state_36059;
(statearr_36126[(9)] = inst_35808__$1);

(statearr_36126[(16)] = inst_35807);

(statearr_36126[(25)] = inst_35806);

return statearr_36126;
})();
if(cljs.core.truth_(inst_35808__$1)){
var statearr_36127_36239 = state_36059__$1;
(statearr_36127_36239[(1)] = (6));

} else {
var statearr_36128_36240 = state_36059__$1;
(statearr_36128_36240[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (66))){
var inst_36022 = (state_36059[(7)]);
var state_36059__$1 = state_36059;
var statearr_36129_36241 = state_36059__$1;
(statearr_36129_36241[(2)] = inst_36022);

(statearr_36129_36241[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (23))){
var inst_35837 = (state_36059[(10)]);
var inst_35849 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_35837);
var state_36059__$1 = state_36059;
var statearr_36130_36242 = state_36059__$1;
(statearr_36130_36242[(2)] = inst_35849);

(statearr_36130_36242[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (47))){
var inst_35995 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
var statearr_36131_36243 = state_36059__$1;
(statearr_36131_36243[(2)] = inst_35995);

(statearr_36131_36243[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (35))){
var inst_35822 = (state_36059[(11)]);
var inst_35862 = (state_36059[(20)]);
var inst_35864 = (state_36059[(22)]);
var inst_35895 = (state_36059[(2)]);
var inst_35896 = fluree.db.util.async.throw_err(inst_35895);
var inst_35897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35898 = [inst_35862];
var inst_35899 = (new cljs.core.PersistentVector(null,1,(5),inst_35897,inst_35898,null));
var inst_35900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35901 = [inst_35862,inst_35864];
var inst_35902 = (new cljs.core.PersistentVector(null,2,(5),inst_35900,inst_35901,null));
var inst_35903 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35904 = [inst_35822];
var inst_35905 = cljs.core.PersistentHashMap.fromArrays(inst_35903,inst_35904);
var inst_35906 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_35899,cljs.core._LT_,inst_35902,inst_35905);
var state_36059__$1 = (function (){var statearr_36132 = state_36059;
(statearr_36132[(24)] = inst_35896);

return statearr_36132;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36059__$1,(36),inst_35906);
} else {
if((state_val_36060 === (76))){
var inst_35844 = (state_36059[(27)]);
var inst_36016 = (state_36059[(28)]);
var inst_35836 = inst_35844;
var inst_35837 = inst_36016;
var state_36059__$1 = (function (){var statearr_36133 = state_36059;
(statearr_36133[(10)] = inst_35837);

(statearr_36133[(19)] = inst_35836);

return statearr_36133;
})();
var statearr_36134_36244 = state_36059__$1;
(statearr_36134_36244[(2)] = null);

(statearr_36134_36244[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (19))){
var inst_36051 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
var statearr_36135_36245 = state_36059__$1;
(statearr_36135_36245[(2)] = inst_36051);

(statearr_36135_36245[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (57))){
var inst_36017 = (state_36059[(26)]);
var inst_35806 = (state_36059[(25)]);
var inst_36016 = (state_36059[(2)]);
var inst_36017__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_35806);
var state_36059__$1 = (function (){var statearr_36136 = state_36059;
(statearr_36136[(28)] = inst_36016);

(statearr_36136[(26)] = inst_36017__$1);

return statearr_36136;
})();
if(inst_36017__$1){
var statearr_36137_36246 = state_36059__$1;
(statearr_36137_36246[(1)] = (63));

} else {
var statearr_36138_36247 = state_36059__$1;
(statearr_36138_36247[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (68))){
var inst_36037 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
if(cljs.core.truth_(inst_36037)){
var statearr_36139_36248 = state_36059__$1;
(statearr_36139_36248[(1)] = (75));

} else {
var statearr_36140_36249 = state_36059__$1;
(statearr_36140_36249[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (11))){
var inst_35807 = (state_36059[(16)]);
var inst_35822 = (state_36059[(2)]);
var inst_35823 = cljs.core.not_empty(inst_35807);
var state_36059__$1 = (function (){var statearr_36142 = state_36059;
(statearr_36142[(11)] = inst_35822);

return statearr_36142;
})();
if(cljs.core.truth_(inst_35823)){
var statearr_36143_36250 = state_36059__$1;
(statearr_36143_36250[(1)] = (15));

} else {
var statearr_36144_36251 = state_36059__$1;
(statearr_36144_36251[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (9))){
var state_36059__$1 = state_36059;
if(cljs.core.truth_(offset)){
var statearr_36145_36252 = state_36059__$1;
(statearr_36145_36252[(1)] = (12));

} else {
var statearr_36146_36253 = state_36059__$1;
(statearr_36146_36253[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (5))){
var _ = (function (){var statearr_36147 = state_36059;
(statearr_36147[(4)] = cljs.core.rest((state_36059[(4)])));

return statearr_36147;
})();
var state_36059__$1 = state_36059;
var ex36141 = (state_36059__$1[(2)]);
var statearr_36148_36254 = state_36059__$1;
(statearr_36148_36254[(5)] = ex36141);


if((ex36141 instanceof Error)){
var statearr_36149_36255 = state_36059__$1;
(statearr_36149_36255[(1)] = (4));

(statearr_36149_36255[(5)] = null);

} else {
throw ex36141;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (14))){
var inst_35819 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
var statearr_36150_36256 = state_36059__$1;
(statearr_36150_36256[(2)] = inst_35819);

(statearr_36150_36256[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (45))){
var inst_35822 = (state_36059[(11)]);
var inst_35862 = (state_36059[(20)]);
var inst_35864 = (state_36059[(22)]);
var inst_35943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35944 = [inst_35862,inst_35864];
var inst_35945 = (new cljs.core.PersistentVector(null,2,(5),inst_35943,inst_35944,null));
var inst_35946 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35947 = [inst_35862];
var inst_35948 = (new cljs.core.PersistentVector(null,1,(5),inst_35946,inst_35947,null));
var inst_35949 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35950 = [inst_35822];
var inst_35951 = cljs.core.PersistentHashMap.fromArrays(inst_35949,inst_35950);
var inst_35952 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_35945,cljs.core._LT__EQ_,inst_35948,inst_35951);
var state_36059__$1 = state_36059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36059__$1,(48),inst_35952);
} else {
if((state_val_36060 === (53))){
var inst_35822 = (state_36059[(11)]);
var inst_35862 = (state_36059[(20)]);
var inst_35864 = (state_36059[(22)]);
var inst_35975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35976 = [inst_35862];
var inst_35977 = (new cljs.core.PersistentVector(null,1,(5),inst_35975,inst_35976,null));
var inst_35978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35979 = [inst_35862,inst_35864];
var inst_35980 = (new cljs.core.PersistentVector(null,2,(5),inst_35978,inst_35979,null));
var inst_35981 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35982 = [inst_35822];
var inst_35983 = cljs.core.PersistentHashMap.fromArrays(inst_35981,inst_35982);
var inst_35984 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_35977,cljs.core._LT__EQ_,inst_35980,inst_35983);
var state_36059__$1 = state_36059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36059__$1,(56),inst_35984);
} else {
if((state_val_36060 === (78))){
var inst_36016 = (state_36059[(28)]);
var inst_36040 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_36016);
var state_36059__$1 = state_36059;
var statearr_36151_36257 = state_36059__$1;
(statearr_36151_36257[(2)] = inst_36040);

(statearr_36151_36257[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (26))){
var inst_35852 = (state_36059[(13)]);
var inst_35854 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_35852);
var state_36059__$1 = state_36059;
var statearr_36152_36258 = state_36059__$1;
(statearr_36152_36258[(2)] = inst_35854);

(statearr_36152_36258[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (16))){
var state_36059__$1 = state_36059;
var statearr_36153_36259 = state_36059__$1;
(statearr_36153_36259[(2)] = null);

(statearr_36153_36259[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (79))){
var inst_36016 = (state_36059[(28)]);
var state_36059__$1 = state_36059;
var statearr_36154_36260 = state_36059__$1;
(statearr_36154_36260[(2)] = inst_36016);

(statearr_36154_36260[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (38))){
var inst_35881 = (state_36059[(14)]);
var inst_35863 = (state_36059[(15)]);
var inst_35925 = (inst_35881.cljs$core$IFn$_invoke$arity$2 ? inst_35881.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_35863) : inst_35881.call(null,cljs.core._GT_,inst_35863));
var state_36059__$1 = state_36059;
if(cljs.core.truth_(inst_35925)){
var statearr_36155_36261 = state_36059__$1;
(statearr_36155_36261[(1)] = (41));

} else {
var statearr_36156_36262 = state_36059__$1;
(statearr_36156_36262[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (30))){
var state_36059__$1 = state_36059;
var statearr_36157_36263 = state_36059__$1;
(statearr_36157_36263[(2)] = null);

(statearr_36157_36263[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (73))){
var inst_35822 = (state_36059[(11)]);
var state_36059__$1 = state_36059;
var statearr_36158_36264 = state_36059__$1;
(statearr_36158_36264[(2)] = inst_35822);

(statearr_36158_36264[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (10))){
var state_36059__$1 = state_36059;
var statearr_36159_36265 = state_36059__$1;
(statearr_36159_36265[(2)] = null);

(statearr_36159_36265[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (18))){
var inst_35843 = (state_36059[(21)]);
var inst_35836 = (state_36059[(19)]);
var inst_35842 = cljs.core.seq(inst_35836);
var inst_35843__$1 = cljs.core.first(inst_35842);
var inst_35844 = cljs.core.next(inst_35842);
var inst_35845 = cljs.core.not(inst_35843__$1);
var state_36059__$1 = (function (){var statearr_36160 = state_36059;
(statearr_36160[(27)] = inst_35844);

(statearr_36160[(21)] = inst_35843__$1);

return statearr_36160;
})();
if(inst_35845){
var statearr_36161_36266 = state_36059__$1;
(statearr_36161_36266[(1)] = (20));

} else {
var statearr_36162_36267 = state_36059__$1;
(statearr_36162_36267[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (52))){
var inst_35970 = (state_36059[(2)]);
var inst_35971 = fluree.db.util.async.throw_err(inst_35970);
var state_36059__$1 = state_36059;
var statearr_36163_36268 = state_36059__$1;
(statearr_36163_36268[(2)] = inst_35971);

(statearr_36163_36268[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (67))){
var inst_36025 = (state_36059[(8)]);
var inst_35806 = (state_36059[(25)]);
var inst_36025__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_35806);
var state_36059__$1 = (function (){var statearr_36164 = state_36059;
(statearr_36164[(8)] = inst_36025__$1);

return statearr_36164;
})();
if(inst_36025__$1){
var statearr_36165_36269 = state_36059__$1;
(statearr_36165_36269[(1)] = (69));

} else {
var statearr_36166_36270 = state_36059__$1;
(statearr_36166_36270[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (71))){
var inst_36035 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
var statearr_36167_36271 = state_36059__$1;
(statearr_36167_36271[(2)] = inst_36035);

(statearr_36167_36271[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (42))){
var inst_35881 = (state_36059[(14)]);
var inst_35863 = (state_36059[(15)]);
var inst_35941 = (inst_35881.cljs$core$IFn$_invoke$arity$2 ? inst_35881.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_35863) : inst_35881.call(null,cljs.core._GT__EQ_,inst_35863));
var state_36059__$1 = state_36059;
if(cljs.core.truth_(inst_35941)){
var statearr_36168_36272 = state_36059__$1;
(statearr_36168_36272[(1)] = (45));

} else {
var statearr_36169_36273 = state_36059__$1;
(statearr_36169_36273[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (80))){
var inst_36043 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
var statearr_36170_36274 = state_36059__$1;
(statearr_36170_36274[(2)] = inst_36043);

(statearr_36170_36274[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (37))){
var inst_35822 = (state_36059[(11)]);
var inst_35862 = (state_36059[(20)]);
var inst_35864 = (state_36059[(22)]);
var inst_35914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35915 = [inst_35862,inst_35864];
var inst_35916 = (new cljs.core.PersistentVector(null,2,(5),inst_35914,inst_35915,null));
var inst_35917 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35918 = [inst_35822];
var inst_35919 = cljs.core.PersistentHashMap.fromArrays(inst_35917,inst_35918);
var inst_35920 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_35916,inst_35919);
var state_36059__$1 = state_36059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36059__$1,(40),inst_35920);
} else {
if((state_val_36060 === (63))){
var inst_36016 = (state_36059[(28)]);
var inst_36019 = cljs.core.empty_QMARK_(inst_36016);
var state_36059__$1 = state_36059;
var statearr_36171_36275 = state_36059__$1;
(statearr_36171_36275[(2)] = inst_36019);

(statearr_36171_36275[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (8))){
var inst_35813 = (state_36059[(2)]);
var state_36059__$1 = state_36059;
if(cljs.core.truth_(inst_35813)){
var statearr_36172_36276 = state_36059__$1;
(statearr_36172_36276[(1)] = (9));

} else {
var statearr_36173_36277 = state_36059__$1;
(statearr_36173_36277[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36060 === (49))){
var inst_35822 = (state_36059[(11)]);
var inst_35862 = (state_36059[(20)]);
var inst_35864 = (state_36059[(22)]);
var inst_35959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35960 = [inst_35862];
var inst_35961 = (new cljs.core.PersistentVector(null,1,(5),inst_35959,inst_35960,null));
var inst_35962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35963 = [inst_35862,inst_35864];
var inst_35964 = (new cljs.core.PersistentVector(null,2,(5),inst_35962,inst_35963,null));
var inst_35965 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35966 = [inst_35822];
var inst_35967 = cljs.core.PersistentHashMap.fromArrays(inst_35965,inst_35966);
var inst_35968 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_35961,cljs.core._LT_,inst_35964,inst_35967);
var state_36059__$1 = state_36059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36059__$1,(52),inst_35968);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__11438__auto__ = null;
var fluree$db$query$fql$state_machine__11438__auto____0 = (function (){
var statearr_36174 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36174[(0)] = fluree$db$query$fql$state_machine__11438__auto__);

(statearr_36174[(1)] = (1));

return statearr_36174;
});
var fluree$db$query$fql$state_machine__11438__auto____1 = (function (state_36059){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_36059);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e36175){var ex__11441__auto__ = e36175;
var statearr_36176_36278 = state_36059;
(statearr_36176_36278[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_36059[(4)]))){
var statearr_36177_36279 = state_36059;
(statearr_36177_36279[(1)] = cljs.core.first((state_36059[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36280 = state_36059;
state_36059 = G__36280;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__11438__auto__ = function(state_36059){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__11438__auto____1.call(this,state_36059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__11438__auto____0;
fluree$db$query$fql$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__11438__auto____1;
return fluree$db$query$fql$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_36178 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_36178[(6)] = c__11512__auto__);

return statearr_36178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 4);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__5045__auto__ = cljs.core.every_QMARK_((function (p1__36281_SHARP_){
return ((typeof p1__36281_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__36281_SHARP_)));
}),select_smt);
if(or__5045__auto__){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__36282_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__36282_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__36286 = vars;
var vec__36287 = G__36286;
var seq__36288 = cljs.core.seq(vec__36287);
var first__36289 = cljs.core.first(seq__36288);
var seq__36288__$1 = cljs.core.next(seq__36288);
var var$ = first__36289;
var r = seq__36288__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__36286__$1 = G__36286;
var all_vars__$1 = all_vars;
while(true){
var vec__36294 = G__36286__$1;
var seq__36295 = cljs.core.seq(vec__36294);
var first__36296 = cljs.core.first(seq__36295);
var seq__36295__$1 = cljs.core.next(seq__36295);
var var$__$1 = first__36296;
var r__$1 = seq__36295__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__36297 = cljs.core.set(all_vars__$2);
return (fexpr__36297.cljs$core$IFn$_invoke$arity$1 ? fexpr__36297.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__36297.call(null,var$__$1));
})())){
var G__36298 = r__$1;
var G__36299 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__36286__$1 = G__36298;
all_vars__$1 = G__36299;
continue;
} else {
var G__36300 = r__$1;
var G__36301 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__36286__$1 = G__36300;
all_vars__$1 = G__36301;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_36336){
var state_val_36337 = (state_36336[(1)]);
if((state_val_36337 === (1))){
var inst_36309 = functionArray;
var inst_36310 = cljs.core.seq(inst_36309);
var inst_36311 = cljs.core.first(inst_36310);
var inst_36312 = cljs.core.next(inst_36310);
var inst_36313 = cljs.core.PersistentVector.EMPTY;
var inst_36314 = inst_36309;
var inst_36315 = inst_36313;
var state_36336__$1 = (function (){var statearr_36338 = state_36336;
(statearr_36338[(7)] = inst_36312);

(statearr_36338[(8)] = inst_36315);

(statearr_36338[(9)] = inst_36314);

(statearr_36338[(10)] = inst_36311);

return statearr_36338;
})();
var statearr_36339_36352 = state_36336__$1;
(statearr_36339_36352[(2)] = null);

(statearr_36339_36352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36337 === (2))){
var inst_36314 = (state_36336[(9)]);
var inst_36321 = (state_36336[(11)]);
var inst_36320 = cljs.core.seq(inst_36314);
var inst_36321__$1 = cljs.core.first(inst_36320);
var inst_36322 = cljs.core.next(inst_36320);
var state_36336__$1 = (function (){var statearr_36340 = state_36336;
(statearr_36340[(12)] = inst_36322);

(statearr_36340[(11)] = inst_36321__$1);

return statearr_36340;
})();
if(cljs.core.truth_(inst_36321__$1)){
var statearr_36341_36353 = state_36336__$1;
(statearr_36341_36353[(1)] = (4));

} else {
var statearr_36342_36354 = state_36336__$1;
(statearr_36342_36354[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36337 === (3))){
var inst_36334 = (state_36336[(2)]);
var state_36336__$1 = state_36336;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36336__$1,inst_36334);
} else {
if((state_val_36337 === (4))){
var inst_36321 = (state_36336[(11)]);
var inst_36324 = (inst_36321.cljs$core$IFn$_invoke$arity$1 ? inst_36321.cljs$core$IFn$_invoke$arity$1(tuple) : inst_36321.call(null,tuple));
var state_36336__$1 = state_36336;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36336__$1,(7),inst_36324);
} else {
if((state_val_36337 === (5))){
var inst_36315 = (state_36336[(8)]);
var state_36336__$1 = state_36336;
var statearr_36343_36355 = state_36336__$1;
(statearr_36343_36355[(2)] = inst_36315);

(statearr_36343_36355[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36337 === (6))){
var inst_36332 = (state_36336[(2)]);
var state_36336__$1 = state_36336;
var statearr_36344_36356 = state_36336__$1;
(statearr_36344_36356[(2)] = inst_36332);

(statearr_36344_36356[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36337 === (7))){
var inst_36322 = (state_36336[(12)]);
var inst_36315 = (state_36336[(8)]);
var inst_36326 = (state_36336[(2)]);
var inst_36327 = fluree.db.util.async.throw_err(inst_36326);
var inst_36328 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36315,inst_36327);
var inst_36314 = inst_36322;
var inst_36315__$1 = inst_36328;
var state_36336__$1 = (function (){var statearr_36345 = state_36336;
(statearr_36345[(8)] = inst_36315__$1);

(statearr_36345[(9)] = inst_36314);

return statearr_36345;
})();
var statearr_36346_36357 = state_36336__$1;
(statearr_36346_36357[(2)] = null);

(statearr_36346_36357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__11438__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__11438__auto____0 = (function (){
var statearr_36347 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36347[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__11438__auto__);

(statearr_36347[(1)] = (1));

return statearr_36347;
});
var fluree$db$query$fql$format_tuple_$_state_machine__11438__auto____1 = (function (state_36336){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_36336);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e36348){var ex__11441__auto__ = e36348;
var statearr_36349_36358 = state_36336;
(statearr_36349_36358[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_36336[(4)]))){
var statearr_36350_36359 = state_36336;
(statearr_36350_36359[(1)] = cljs.core.first((state_36336[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36360 = state_36336;
state_36336 = G__36360;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__11438__auto__ = function(state_36336){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__11438__auto____1.call(this,state_36336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__11438__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__11438__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_36351 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_36351[(6)] = c__11512__auto__);

return statearr_36351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__36361){
var vec__36362 = p__36361;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36362,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36362,(1),null);
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_36376){
var state_val_36377 = (state_36376[(1)]);
if((state_val_36377 === (1))){
var inst_36365 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36366 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_36367 = [query_map,_id,query_opts];
var inst_36368 = cljs.core.PersistentHashMap.fromArrays(inst_36366,inst_36367);
var inst_36369 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_36368) : fluree.db.query.fql.query.call(null,db,inst_36368));
var state_36376__$1 = (function (){var statearr_36378 = state_36376;
(statearr_36378[(7)] = inst_36365);

return statearr_36378;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36376__$1,(2),inst_36369);
} else {
if((state_val_36377 === (2))){
var inst_36365 = (state_36376[(7)]);
var inst_36371 = (state_36376[(2)]);
var inst_36372 = fluree.db.util.async.throw_err(inst_36371);
var inst_36373 = [tuple_index,inst_36372];
var inst_36374 = (new cljs.core.PersistentVector(null,2,(5),inst_36365,inst_36373,null));
var state_36376__$1 = state_36376;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36376__$1,inst_36374);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__11438__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__11438__auto____0 = (function (){
var statearr_36379 = [null,null,null,null,null,null,null,null];
(statearr_36379[(0)] = fluree$db$query$fql$expand_map_$_state_machine__11438__auto__);

(statearr_36379[(1)] = (1));

return statearr_36379;
});
var fluree$db$query$fql$expand_map_$_state_machine__11438__auto____1 = (function (state_36376){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_36376);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e36380){var ex__11441__auto__ = e36380;
var statearr_36381_36384 = state_36376;
(statearr_36381_36384[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_36376[(4)]))){
var statearr_36382_36385 = state_36376;
(statearr_36382_36385[(1)] = cljs.core.first((state_36376[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36386 = state_36376;
state_36376 = G__36386;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__11438__auto__ = function(state_36376){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__11438__auto____1.call(this,state_36376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__11438__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__11438__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_36383 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_36383[(6)] = c__11512__auto__);

return statearr_36383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__36387 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36387,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36387,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_36450){
var state_val_36451 = (state_36450[(1)]);
if((state_val_36451 === (7))){
var inst_36445 = (state_36450[(2)]);
var _ = (function (){var statearr_36452 = state_36450;
(statearr_36452[(4)] = cljs.core.rest((state_36450[(4)])));

return statearr_36452;
})();
var state_36450__$1 = state_36450;
var statearr_36453_36544 = state_36450__$1;
(statearr_36453_36544[(2)] = inst_36445);

(statearr_36453_36544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36451 === (20))){
var inst_36436 = (state_36450[(2)]);
var state_36450__$1 = state_36450;
var statearr_36454_36545 = state_36450__$1;
(statearr_36454_36545[(2)] = inst_36436);

(statearr_36454_36545[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36451 === (1))){
var state_36450__$1 = state_36450;
var statearr_36455_36546 = state_36450__$1;
(statearr_36455_36546[(2)] = null);

(statearr_36455_36546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36451 === (4))){
var inst_36392 = (state_36450[(2)]);
var state_36450__$1 = state_36450;
var statearr_36456_36547 = state_36450__$1;
(statearr_36456_36547[(2)] = inst_36392);

(statearr_36456_36547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36451 === (15))){
var inst_36412 = (state_36450[(7)]);
var inst_36421 = cljs.core.second(inst_36412);
var inst_36422 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_36421);
var inst_36423 = (inst_36422 > max_fuel);
var state_36450__$1 = state_36450;
if(cljs.core.truth_(inst_36423)){
var statearr_36457_36548 = state_36450__$1;
(statearr_36457_36548[(1)] = (18));

} else {
var statearr_36458_36549 = state_36450__$1;
(statearr_36458_36549[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36451 === (13))){
var state_36450__$1 = state_36450;
var statearr_36459_36550 = state_36450__$1;
(statearr_36459_36550[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36451 === (6))){
var inst_36400 = (state_36450[(8)]);
var state_36450__$1 = state_36450;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36450__$1,(8),inst_36400);
} else {
if((state_val_36451 === (17))){
var inst_36439 = (state_36450[(2)]);
var state_36450__$1 = state_36450;
var statearr_36461_36551 = state_36450__$1;
(statearr_36461_36551[(2)] = inst_36439);

(statearr_36461_36551[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36451 === (3))){
var inst_36448 = (state_36450[(2)]);
var state_36450__$1 = state_36450;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36450__$1,inst_36448);
} else {
if((state_val_36451 === (12))){
var inst_36412 = (state_36450[(7)]);
var inst_36401 = (state_36450[(9)]);
var inst_36418 = (inst_36401.cljs$core$IFn$_invoke$arity$0 ? inst_36401.cljs$core$IFn$_invoke$arity$0() : inst_36401.call(null));
var state_36450__$1 = (function (){var statearr_36462 = state_36450;
(statearr_36462[(10)] = inst_36418);

return statearr_36462;
})();
var statearr_36463_36552 = state_36450__$1;
(statearr_36463_36552[(2)] = inst_36412);

(statearr_36463_36552[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36451 === (2))){
var inst_36400 = (state_36450[(8)]);
var inst_36401 = (state_36450[(9)]);
var _ = (function (){var statearr_36464 = state_36450;
(statearr_36464[(4)] = cljs.core.cons((5),(state_36450[(4)])));

return statearr_36464;
})();
var inst_36398 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_36399 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_36400__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_36401__$1 = (function (){var expandMaps = inst_36398;
var queue_ch = inst_36399;
var res_ch = inst_36400__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_36402 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_36403 = cljs.core.volatile_BANG_((0));
var inst_36404 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36402,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_36403);
var inst_36405 = (function (){var expandMaps = inst_36398;
var queue_ch = inst_36399;
var res_ch = inst_36400__$1;
var stop_BANG_ = inst_36401__$1;
var opts_STAR_ = inst_36404;
return (function (tuple_res,port){
var c__11512__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_36497){
var state_val_36498 = (state_36497[(1)]);
if((state_val_36498 === (7))){
var state_36497__$1 = state_36497;
var statearr_36499_36553 = state_36497__$1;
(statearr_36499_36553[(2)] = tuple_res);

(statearr_36499_36553[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36498 === (1))){
var state_36497__$1 = state_36497;
var statearr_36500_36554 = state_36497__$1;
(statearr_36500_36554[(2)] = null);

(statearr_36500_36554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36498 === (4))){
var inst_36465 = (state_36497[(2)]);
var inst_36466 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_36465);
var inst_36467 = cljs.core.async.close_BANG_(port);
var state_36497__$1 = (function (){var statearr_36501 = state_36497;
(statearr_36501[(7)] = inst_36466);

return statearr_36501;
})();
var statearr_36502_36555 = state_36497__$1;
(statearr_36502_36555[(2)] = inst_36467);

(statearr_36502_36555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36498 === (6))){
var inst_36474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36475 = [tuple_res];
var inst_36476 = (new cljs.core.PersistentVector(null,1,(5),inst_36474,inst_36475,null));
var state_36497__$1 = state_36497;
var statearr_36503_36556 = state_36497__$1;
(statearr_36503_36556[(2)] = inst_36476);

(statearr_36503_36556[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36498 === (3))){
var inst_36495 = (state_36497[(2)]);
var state_36497__$1 = state_36497;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36497__$1,inst_36495);
} else {
if((state_val_36498 === (2))){
var ___$1 = (function (){var statearr_36505 = state_36497;
(statearr_36505[(4)] = cljs.core.cons((5),(state_36497[(4)])));

return statearr_36505;
})();
var state_36497__$1 = state_36497;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_36506_36557 = state_36497__$1;
(statearr_36506_36557[(1)] = (6));

} else {
var statearr_36507_36558 = state_36497__$1;
(statearr_36507_36558[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36498 === (9))){
var inst_36481 = (state_36497[(8)]);
var inst_36479 = (state_36497[(9)]);
var inst_36488 = (state_36497[(2)]);
var inst_36489 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_36479,inst_36488);
var inst_36490 = (inst_36481.cljs$core$IFn$_invoke$arity$1 ? inst_36481.cljs$core$IFn$_invoke$arity$1(inst_36489) : inst_36481.call(null,inst_36489));
var inst_36491 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_36490);
var inst_36492 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_36508 = state_36497;
(statearr_36508[(4)] = cljs.core.rest((state_36497[(4)])));

return statearr_36508;
})();
var state_36497__$1 = (function (){var statearr_36509 = state_36497;
(statearr_36509[(10)] = inst_36491);

return statearr_36509;
})();
var statearr_36510_36559 = state_36497__$1;
(statearr_36510_36559[(2)] = inst_36492);

(statearr_36510_36559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36498 === (5))){
var ___$1 = (function (){var statearr_36511 = state_36497;
(statearr_36511[(4)] = cljs.core.rest((state_36497[(4)])));

return statearr_36511;
})();
var state_36497__$1 = state_36497;
var ex36504 = (state_36497__$1[(2)]);
var statearr_36512_36560 = state_36497__$1;
(statearr_36512_36560[(5)] = ex36504);


var statearr_36513_36561 = state_36497__$1;
(statearr_36513_36561[(1)] = (4));

(statearr_36513_36561[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36498 === (8))){
var inst_36479 = (state_36497[(9)]);
var inst_36479__$1 = (state_36497[(2)]);
var inst_36480 = cljs.core.volatile_BANG_((0));
var inst_36481 = (function (){var tuple_res_SINGLEQUOTE_ = inst_36479__$1;
var query_fuel = inst_36480;
return (function (p1__36391_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__36391_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36391_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_36482 = cljs.core.PersistentVector.EMPTY;
var inst_36483 = (function (){var tuple_res_SINGLEQUOTE_ = inst_36479__$1;
var query_fuel = inst_36480;
return (function (p1__36390_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__36390_SHARP_);
});
})();
var inst_36484 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_36483,expandMaps);
var inst_36485 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_36484);
var inst_36486 = cljs.core.async.into(inst_36482,inst_36485);
var state_36497__$1 = (function (){var statearr_36514 = state_36497;
(statearr_36514[(8)] = inst_36481);

(statearr_36514[(9)] = inst_36479__$1);

return statearr_36514;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36497__$1,(9),inst_36486);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto____0 = (function (){
var statearr_36515 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36515[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto__);

(statearr_36515[(1)] = (1));

return statearr_36515;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto____1 = (function (state_36497){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_36497);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e36516){var ex__11441__auto__ = e36516;
var statearr_36517_36562 = state_36497;
(statearr_36517_36562[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_36497[(4)]))){
var statearr_36518_36563 = state_36497;
(statearr_36518_36563[(1)] = cljs.core.first((state_36497[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36564 = state_36497;
state_36497 = G__36564;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto__ = function(state_36497){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto____1.call(this,state_36497);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_36519 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_36519[(6)] = c__11512__auto____$1);

return statearr_36519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto____$1;
});
})();
var inst_36406 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_36399,tuples_res);
var inst_36407 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_36400__$1,inst_36405,inst_36399);
var inst_36408 = cljs.core.PersistentVector.EMPTY;
var inst_36409 = inst_36408;
var state_36450__$1 = (function (){var statearr_36520 = state_36450;
(statearr_36520[(11)] = inst_36407);

(statearr_36520[(8)] = inst_36400__$1);

(statearr_36520[(12)] = inst_36406);

(statearr_36520[(13)] = inst_36409);

(statearr_36520[(9)] = inst_36401__$1);

return statearr_36520;
})();
var statearr_36521_36565 = state_36450__$1;
(statearr_36521_36565[(2)] = null);

(statearr_36521_36565[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36451 === (19))){
var inst_36412 = (state_36450[(7)]);
var inst_36409 = (state_36450[(13)]);
var inst_36432 = cljs.core.first(inst_36412);
var inst_36433 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36409,inst_36432);
var inst_36409__$1 = inst_36433;
var state_36450__$1 = (function (){var statearr_36522 = state_36450;
(statearr_36522[(13)] = inst_36409__$1);

return statearr_36522;
})();
var statearr_36523_36566 = state_36450__$1;
(statearr_36523_36566[(2)] = null);

(statearr_36523_36566[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36451 === (11))){
var inst_36443 = (state_36450[(2)]);
var state_36450__$1 = state_36450;
var statearr_36525_36567 = state_36450__$1;
(statearr_36525_36567[(2)] = inst_36443);

(statearr_36525_36567[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36451 === (9))){
var inst_36409 = (state_36450[(13)]);
var state_36450__$1 = state_36450;
var statearr_36526_36568 = state_36450__$1;
(statearr_36526_36568[(2)] = inst_36409);

(statearr_36526_36568[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36451 === (5))){
var _ = (function (){var statearr_36527 = state_36450;
(statearr_36527[(4)] = cljs.core.rest((state_36450[(4)])));

return statearr_36527;
})();
var state_36450__$1 = state_36450;
var ex36524 = (state_36450__$1[(2)]);
var statearr_36528_36569 = state_36450__$1;
(statearr_36528_36569[(5)] = ex36524);


if((ex36524 instanceof Error)){
var statearr_36529_36570 = state_36450__$1;
(statearr_36529_36570[(1)] = (4));

(statearr_36529_36570[(5)] = null);

} else {
throw ex36524;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36451 === (14))){
var inst_36441 = (state_36450[(2)]);
var state_36450__$1 = state_36450;
var statearr_36530_36571 = state_36450__$1;
(statearr_36530_36571[(2)] = inst_36441);

(statearr_36530_36571[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36451 === (16))){
var state_36450__$1 = state_36450;
var statearr_36531_36572 = state_36450__$1;
(statearr_36531_36572[(2)] = null);

(statearr_36531_36572[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36451 === (10))){
var inst_36412 = (state_36450[(7)]);
var inst_36416 = fluree.db.util.core.exception_QMARK_(inst_36412);
var state_36450__$1 = state_36450;
if(inst_36416){
var statearr_36532_36573 = state_36450__$1;
(statearr_36532_36573[(1)] = (12));

} else {
var statearr_36533_36574 = state_36450__$1;
(statearr_36533_36574[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36451 === (18))){
var inst_36401 = (state_36450[(9)]);
var inst_36425 = (inst_36401.cljs$core$IFn$_invoke$arity$0 ? inst_36401.cljs$core$IFn$_invoke$arity$0() : inst_36401.call(null));
var inst_36426 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_36427 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_36428 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_36429 = cljs.core.PersistentHashMap.fromArrays(inst_36427,inst_36428);
var inst_36430 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36426,inst_36429);
var state_36450__$1 = (function (){var statearr_36534 = state_36450;
(statearr_36534[(14)] = inst_36425);

return statearr_36534;
})();
var statearr_36535_36575 = state_36450__$1;
(statearr_36535_36575[(2)] = inst_36430);

(statearr_36535_36575[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36451 === (8))){
var inst_36412 = (state_36450[(7)]);
var inst_36412__$1 = (state_36450[(2)]);
var inst_36413 = (inst_36412__$1 == null);
var state_36450__$1 = (function (){var statearr_36536 = state_36450;
(statearr_36536[(7)] = inst_36412__$1);

return statearr_36536;
})();
if(cljs.core.truth_(inst_36413)){
var statearr_36537_36576 = state_36450__$1;
(statearr_36537_36576[(1)] = (9));

} else {
var statearr_36538_36577 = state_36450__$1;
(statearr_36538_36577[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto____0 = (function (){
var statearr_36539 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36539[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto__);

(statearr_36539[(1)] = (1));

return statearr_36539;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto____1 = (function (state_36450){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_36450);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e36540){var ex__11441__auto__ = e36540;
var statearr_36541_36578 = state_36450;
(statearr_36541_36578[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_36450[(4)]))){
var statearr_36542_36579 = state_36450;
(statearr_36542_36579[(1)] = cljs.core.first((state_36450[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36580 = state_36450;
state_36450 = G__36580;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto__ = function(state_36450){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto____1.call(this,state_36450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_36543 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_36543[(6)] = c__11512__auto__);

return statearr_36543;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__36581 = select;
var map__36581__$1 = cljs.core.__destructure_map(map__36581);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36581__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36581__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36581__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__5045__auto__ = as;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__36584 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36584,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36584,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36584,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__36582_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__36582_SHARP_,compare_idx));
}):(function (p1__36583_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__36583_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__36589 = arguments.length;
switch (G__36589) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__36590,p__36591,group_limit,opts){
var map__36592 = p__36590;
var map__36592__$1 = cljs.core.__destructure_map(map__36592);
var res = map__36592__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36592__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__36593 = p__36591;
var map__36593__$1 = cljs.core.__destructure_map(map__36593);
var select_spec = map__36593__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36593__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36593__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36593__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36593__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36593__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36593__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36593__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36593__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36593__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36593__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_36730){
var state_val_36731 = (state_36730[(1)]);
if((state_val_36731 === (7))){
var inst_36600 = (state_36730[(7)]);
var state_36730__$1 = state_36730;
var statearr_36732_36834 = state_36730__$1;
(statearr_36732_36834[(2)] = inst_36600);

(statearr_36732_36834[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (59))){
var inst_36723 = (state_36730[(2)]);
var state_36730__$1 = state_36730;
var statearr_36733_36835 = state_36730__$1;
(statearr_36733_36835[(2)] = inst_36723);

(statearr_36733_36835[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (20))){
var inst_36639 = (state_36730[(8)]);
var inst_36636 = (state_36730[(9)]);
var inst_36635 = (state_36730[(2)]);
var inst_36636__$1 = cljs.core.__destructure_map(inst_36635);
var inst_36637 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36636__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_36638 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36636__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_36639__$1 = offset;
var state_36730__$1 = (function (){var statearr_36734 = state_36730;
(statearr_36734[(8)] = inst_36639__$1);

(statearr_36734[(9)] = inst_36636__$1);

(statearr_36734[(10)] = inst_36638);

(statearr_36734[(11)] = inst_36637);

return statearr_36734;
})();
if(cljs.core.truth_(inst_36639__$1)){
var statearr_36735_36836 = state_36730__$1;
(statearr_36735_36836[(1)] = (21));

} else {
var statearr_36736_36837 = state_36730__$1;
(statearr_36736_36837[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (58))){
var inst_36715 = (state_36730[(12)]);
var state_36730__$1 = state_36730;
var statearr_36737_36838 = state_36730__$1;
(statearr_36737_36838[(2)] = inst_36715);

(statearr_36737_36838[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (60))){
var inst_36719 = (state_36730[(2)]);
var inst_36720 = fluree.db.util.async.throw_err(inst_36719);
var state_36730__$1 = state_36730;
var statearr_36738_36839 = state_36730__$1;
(statearr_36738_36839[(2)] = inst_36720);

(statearr_36738_36839[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (27))){
var inst_36651 = cljs.core.not(inVector_QMARK_);
var state_36730__$1 = state_36730;
var statearr_36739_36840 = state_36730__$1;
(statearr_36739_36840[(2)] = inst_36651);

(statearr_36739_36840[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (1))){
var state_36730__$1 = state_36730;
var statearr_36740_36841 = state_36730__$1;
(statearr_36740_36841[(2)] = null);

(statearr_36740_36841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (24))){
var state_36730__$1 = state_36730;
var statearr_36741_36842 = state_36730__$1;
(statearr_36741_36842[(2)] = offset);

(statearr_36741_36842[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (55))){
var inst_36709 = (state_36730[(13)]);
var state_36730__$1 = state_36730;
var statearr_36742_36843 = state_36730__$1;
(statearr_36742_36843[(2)] = inst_36709);

(statearr_36742_36843[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (39))){
var inst_36677 = (state_36730[(14)]);
var inst_36679 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_36680 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36677,inst_36679);
var state_36730__$1 = state_36730;
var statearr_36743_36844 = state_36730__$1;
(statearr_36743_36844[(2)] = inst_36680);

(statearr_36743_36844[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (46))){
var inst_36689 = (state_36730[(15)]);
var state_36730__$1 = state_36730;
var statearr_36744_36845 = state_36730__$1;
(statearr_36744_36845[(2)] = inst_36689);

(statearr_36744_36845[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (4))){
var inst_36594 = (state_36730[(2)]);
var state_36730__$1 = state_36730;
var statearr_36745_36846 = state_36730__$1;
(statearr_36745_36846[(2)] = inst_36594);

(statearr_36745_36846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (54))){
var inst_36703 = (state_36730[(16)]);
var inst_36709 = (state_36730[(13)]);
var inst_36711 = cljs.core.PersistentVector.EMPTY;
var inst_36712 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_36711,inst_36703,inst_36709);
var state_36730__$1 = state_36730;
var statearr_36746_36847 = state_36730__$1;
(statearr_36746_36847[(2)] = inst_36712);

(statearr_36746_36847[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (15))){
var inst_36621 = (state_36730[(17)]);
var inst_36623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36624 = [inst_36621];
var inst_36625 = (new cljs.core.PersistentVector(null,1,(5),inst_36623,inst_36624,null));
var state_36730__$1 = state_36730;
var statearr_36747_36848 = state_36730__$1;
(statearr_36747_36848[(2)] = inst_36625);

(statearr_36747_36848[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (48))){
var inst_36636 = (state_36730[(9)]);
var inst_36659 = (state_36730[(18)]);
var inst_36648 = (state_36730[(19)]);
var inst_36638 = (state_36730[(10)]);
var inst_36654 = (state_36730[(20)]);
var inst_36695 = (state_36730[(21)]);
var inst_36637 = (state_36730[(11)]);
var inst_36697 = (function (){var map__36630 = inst_36636;
var headers = inst_36637;
var tuples = inst_36638;
var offset_SINGLEQUOTE_ = inst_36648;
var single_result_QMARK_ = inst_36654;
var pp_keys = inst_36659;
var G__36660 = inst_36695;
return (function (p1__36587_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__36587_SHARP_);
});
})();
var inst_36698 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_36697);
var inst_36699 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36695,inst_36698);
var state_36730__$1 = state_36730;
var statearr_36748_36849 = state_36730__$1;
(statearr_36748_36849[(2)] = inst_36699);

(statearr_36748_36849[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (50))){
var inst_36702 = (state_36730[(2)]);
var inst_36703 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_36702);
var state_36730__$1 = (function (){var statearr_36749 = state_36730;
(statearr_36749[(16)] = inst_36703);

return statearr_36749;
})();
if(cljs.core.truth_(orderBy)){
var statearr_36750_36850 = state_36730__$1;
(statearr_36750_36850[(1)] = (51));

} else {
var statearr_36751_36851 = state_36730__$1;
(statearr_36751_36851[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (21))){
var inst_36641 = cljs.core.not(groupBy);
var state_36730__$1 = state_36730;
var statearr_36752_36852 = state_36730__$1;
(statearr_36752_36852[(2)] = inst_36641);

(statearr_36752_36852[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (31))){
var state_36730__$1 = state_36730;
var statearr_36753_36853 = state_36730__$1;
(statearr_36753_36853[(2)] = null);

(statearr_36753_36853[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (32))){
var inst_36654 = (state_36730[(20)]);
var inst_36637 = (state_36730[(11)]);
var inst_36659 = (state_36730[(2)]);
var inst_36661 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36662 = fluree.db.query.fql.select_tuples_fn(inst_36637,vars,select);
var inst_36663 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_36662);
var inst_36664 = [inst_36663];
var inst_36665 = (new cljs.core.PersistentVector(null,1,(5),inst_36661,inst_36664,null));
var state_36730__$1 = (function (){var statearr_36754 = state_36730;
(statearr_36754[(18)] = inst_36659);

(statearr_36754[(22)] = inst_36665);

return statearr_36754;
})();
if(cljs.core.truth_(inst_36654)){
var statearr_36755_36854 = state_36730__$1;
(statearr_36755_36854[(1)] = (33));

} else {
var statearr_36756_36855 = state_36730__$1;
(statearr_36756_36855[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (40))){
var inst_36677 = (state_36730[(14)]);
var state_36730__$1 = state_36730;
var statearr_36757_36856 = state_36730__$1;
(statearr_36757_36856[(2)] = inst_36677);

(statearr_36757_36856[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (56))){
var inst_36715 = (state_36730[(2)]);
var state_36730__$1 = (function (){var statearr_36758 = state_36730;
(statearr_36758[(12)] = inst_36715);

return statearr_36758;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_36759_36857 = state_36730__$1;
(statearr_36759_36857[(1)] = (57));

} else {
var statearr_36760_36858 = state_36730__$1;
(statearr_36760_36858[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (33))){
var inst_36665 = (state_36730[(22)]);
var inst_36667 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_36668 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36665,inst_36667);
var state_36730__$1 = state_36730;
var statearr_36761_36859 = state_36730__$1;
(statearr_36761_36859[(2)] = inst_36668);

(statearr_36761_36859[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (13))){
var inst_36610 = (state_36730[(23)]);
var state_36730__$1 = state_36730;
var statearr_36762_36860 = state_36730__$1;
(statearr_36762_36860[(2)] = inst_36610);

(statearr_36762_36860[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (22))){
var inst_36639 = (state_36730[(8)]);
var state_36730__$1 = state_36730;
var statearr_36763_36861 = state_36730__$1;
(statearr_36763_36861[(2)] = inst_36639);

(statearr_36763_36861[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (36))){
var inst_36671 = (state_36730[(24)]);
var inst_36673 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_36674 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36671,inst_36673);
var state_36730__$1 = state_36730;
var statearr_36764_36862 = state_36730__$1;
(statearr_36764_36862[(2)] = inst_36674);

(statearr_36764_36862[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (41))){
var inst_36648 = (state_36730[(19)]);
var inst_36683 = (state_36730[(2)]);
var state_36730__$1 = (function (){var statearr_36765 = state_36730;
(statearr_36765[(25)] = inst_36683);

return statearr_36765;
})();
if(cljs.core.truth_(inst_36648)){
var statearr_36766_36863 = state_36730__$1;
(statearr_36766_36863[(1)] = (42));

} else {
var statearr_36767_36864 = state_36730__$1;
(statearr_36767_36864[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (43))){
var inst_36683 = (state_36730[(25)]);
var state_36730__$1 = state_36730;
var statearr_36768_36865 = state_36730__$1;
(statearr_36768_36865[(2)] = inst_36683);

(statearr_36768_36865[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (29))){
var inst_36654 = (state_36730[(2)]);
var state_36730__$1 = (function (){var statearr_36769 = state_36730;
(statearr_36769[(20)] = inst_36654);

return statearr_36769;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_36770_36866 = state_36730__$1;
(statearr_36770_36866[(1)] = (30));

} else {
var statearr_36771_36867 = state_36730__$1;
(statearr_36771_36867[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (44))){
var inst_36689 = (state_36730[(2)]);
var state_36730__$1 = (function (){var statearr_36772 = state_36730;
(statearr_36772[(15)] = inst_36689);

return statearr_36772;
})();
if(cljs.core.truth_(group_limit)){
var statearr_36773_36868 = state_36730__$1;
(statearr_36773_36868[(1)] = (45));

} else {
var statearr_36774_36869 = state_36730__$1;
(statearr_36774_36869[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (6))){
var inst_36602 = cljs.core.count(select);
var inst_36603 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_36602);
var state_36730__$1 = state_36730;
var statearr_36775_36870 = state_36730__$1;
(statearr_36775_36870[(2)] = inst_36603);

(statearr_36775_36870[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (28))){
var inst_36649 = (state_36730[(26)]);
var state_36730__$1 = state_36730;
var statearr_36776_36871 = state_36730__$1;
(statearr_36776_36871[(2)] = inst_36649);

(statearr_36776_36871[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (51))){
var inst_36638 = (state_36730[(10)]);
var inst_36637 = (state_36730[(11)]);
var inst_36706 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_36637,orderBy,inst_36638);
var state_36730__$1 = state_36730;
var statearr_36777_36872 = state_36730__$1;
(statearr_36777_36872[(2)] = inst_36706);

(statearr_36777_36872[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (25))){
var state_36730__$1 = state_36730;
var statearr_36778_36873 = state_36730__$1;
(statearr_36778_36873[(2)] = null);

(statearr_36778_36873[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (34))){
var inst_36665 = (state_36730[(22)]);
var state_36730__$1 = state_36730;
var statearr_36779_36874 = state_36730__$1;
(statearr_36779_36874[(2)] = inst_36665);

(statearr_36779_36874[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (17))){
var inst_36628 = (state_36730[(2)]);
var state_36730__$1 = state_36730;
var statearr_36780_36875 = state_36730__$1;
(statearr_36780_36875[(2)] = inst_36628);

(statearr_36780_36875[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (3))){
var inst_36728 = (state_36730[(2)]);
var state_36730__$1 = state_36730;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36730__$1,inst_36728);
} else {
if((state_val_36731 === (12))){
var inst_36610 = (state_36730[(23)]);
var inst_36612 = cljs.core.first(select);
var inst_36613 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_36612);
var inst_36614 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36613);
var inst_36615 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_36614,(1));
var inst_36616 = [inst_36615];
var inst_36617 = [inst_36610];
var inst_36618 = cljs.core.PersistentHashMap.fromArrays(inst_36616,inst_36617);
var state_36730__$1 = state_36730;
var statearr_36781_36876 = state_36730__$1;
(statearr_36781_36876[(2)] = inst_36618);

(statearr_36781_36876[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (2))){
var inst_36600 = (state_36730[(7)]);
var _ = (function (){var statearr_36782 = state_36730;
(statearr_36782[(4)] = cljs.core.cons((5),(state_36730[(4)])));

return statearr_36782;
})();
var inst_36600__$1 = aggregates;
var state_36730__$1 = (function (){var statearr_36783 = state_36730;
(statearr_36783[(7)] = inst_36600__$1);

return statearr_36783;
})();
if(cljs.core.truth_(inst_36600__$1)){
var statearr_36784_36877 = state_36730__$1;
(statearr_36784_36877[(1)] = (6));

} else {
var statearr_36785_36878 = state_36730__$1;
(statearr_36785_36878[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (23))){
var inst_36644 = (state_36730[(2)]);
var state_36730__$1 = state_36730;
if(cljs.core.truth_(inst_36644)){
var statearr_36786_36879 = state_36730__$1;
(statearr_36786_36879[(1)] = (24));

} else {
var statearr_36787_36880 = state_36730__$1;
(statearr_36787_36880[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (47))){
var inst_36695 = (state_36730[(2)]);
var state_36730__$1 = (function (){var statearr_36788 = state_36730;
(statearr_36788[(21)] = inst_36695);

return statearr_36788;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_36789_36881 = state_36730__$1;
(statearr_36789_36881[(1)] = (48));

} else {
var statearr_36790_36882 = state_36730__$1;
(statearr_36790_36882[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (35))){
var inst_36671 = (state_36730[(2)]);
var state_36730__$1 = (function (){var statearr_36791 = state_36730;
(statearr_36791[(24)] = inst_36671);

return statearr_36791;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_36792_36883 = state_36730__$1;
(statearr_36792_36883[(1)] = (36));

} else {
var statearr_36793_36884 = state_36730__$1;
(statearr_36793_36884[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (19))){
var state_36730__$1 = state_36730;
var statearr_36794_36885 = state_36730__$1;
(statearr_36794_36885[(2)] = res);

(statearr_36794_36885[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (57))){
var inst_36659 = (state_36730[(18)]);
var inst_36654 = (state_36730[(20)]);
var inst_36715 = (state_36730[(12)]);
var inst_36717 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_36659,inst_36654,db,fuel,max_fuel,opts,(8),inst_36715);
var state_36730__$1 = state_36730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36730__$1,(60),inst_36717);
} else {
if((state_val_36731 === (11))){
var inst_36725 = (state_36730[(2)]);
var _ = (function (){var statearr_36796 = state_36730;
(statearr_36796[(4)] = cljs.core.rest((state_36730[(4)])));

return statearr_36796;
})();
var state_36730__$1 = state_36730;
var statearr_36797_36886 = state_36730__$1;
(statearr_36797_36886[(2)] = inst_36725);

(statearr_36797_36886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (9))){
var inst_36608 = cljs.core.first(aggregates);
var inst_36609 = fluree.db.query.analytical.calculate_aggregate(res,inst_36608);
var inst_36610 = cljs.core.second(inst_36609);
var state_36730__$1 = (function (){var statearr_36798 = state_36730;
(statearr_36798[(23)] = inst_36610);

return statearr_36798;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_36799_36887 = state_36730__$1;
(statearr_36799_36887[(1)] = (12));

} else {
var statearr_36800_36888 = state_36730__$1;
(statearr_36800_36888[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (5))){
var _ = (function (){var statearr_36801 = state_36730;
(statearr_36801[(4)] = cljs.core.rest((state_36730[(4)])));

return statearr_36801;
})();
var state_36730__$1 = state_36730;
var ex36795 = (state_36730__$1[(2)]);
var statearr_36802_36889 = state_36730__$1;
(statearr_36802_36889[(5)] = ex36795);


if((ex36795 instanceof Error)){
var statearr_36803_36890 = state_36730__$1;
(statearr_36803_36890[(1)] = (4));

(statearr_36803_36890[(5)] = null);

} else {
throw ex36795;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (14))){
var inst_36621 = (state_36730[(2)]);
var state_36730__$1 = (function (){var statearr_36804 = state_36730;
(statearr_36804[(17)] = inst_36621);

return statearr_36804;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_36805_36891 = state_36730__$1;
(statearr_36805_36891[(1)] = (15));

} else {
var statearr_36806_36892 = state_36730__$1;
(statearr_36806_36892[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (45))){
var inst_36689 = (state_36730[(15)]);
var inst_36691 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_36692 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36689,inst_36691);
var state_36730__$1 = state_36730;
var statearr_36807_36893 = state_36730__$1;
(statearr_36807_36893[(2)] = inst_36692);

(statearr_36807_36893[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (53))){
var inst_36709 = (state_36730[(2)]);
var state_36730__$1 = (function (){var statearr_36808 = state_36730;
(statearr_36808[(13)] = inst_36709);

return statearr_36808;
})();
var statearr_36809_36894 = state_36730__$1;
(statearr_36809_36894[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (26))){
var inst_36649 = (state_36730[(26)]);
var inst_36648 = (state_36730[(2)]);
var inst_36649__$1 = cljs.core.not(prettyPrint);
var state_36730__$1 = (function (){var statearr_36811 = state_36730;
(statearr_36811[(26)] = inst_36649__$1);

(statearr_36811[(19)] = inst_36648);

return statearr_36811;
})();
if(inst_36649__$1){
var statearr_36812_36895 = state_36730__$1;
(statearr_36812_36895[(1)] = (27));

} else {
var statearr_36813_36896 = state_36730__$1;
(statearr_36813_36896[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (16))){
var inst_36621 = (state_36730[(17)]);
var state_36730__$1 = state_36730;
var statearr_36814_36897 = state_36730__$1;
(statearr_36814_36897[(2)] = inst_36621);

(statearr_36814_36897[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (38))){
var inst_36677 = (state_36730[(2)]);
var state_36730__$1 = (function (){var statearr_36815 = state_36730;
(statearr_36815[(14)] = inst_36677);

return statearr_36815;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_36816_36898 = state_36730__$1;
(statearr_36816_36898[(1)] = (39));

} else {
var statearr_36817_36899 = state_36730__$1;
(statearr_36817_36899[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (30))){
var inst_36656 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_36730__$1 = state_36730;
var statearr_36818_36900 = state_36730__$1;
(statearr_36818_36900[(2)] = inst_36656);

(statearr_36818_36900[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (10))){
var state_36730__$1 = state_36730;
if(cljs.core.truth_(aggregates)){
var statearr_36819_36901 = state_36730__$1;
(statearr_36819_36901[(1)] = (18));

} else {
var statearr_36820_36902 = state_36730__$1;
(statearr_36820_36902[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (18))){
var inst_36632 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_36730__$1 = state_36730;
var statearr_36821_36903 = state_36730__$1;
(statearr_36821_36903[(2)] = inst_36632);

(statearr_36821_36903[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (52))){
var inst_36638 = (state_36730[(10)]);
var state_36730__$1 = state_36730;
var statearr_36822_36904 = state_36730__$1;
(statearr_36822_36904[(2)] = inst_36638);

(statearr_36822_36904[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (42))){
var inst_36683 = (state_36730[(25)]);
var inst_36648 = (state_36730[(19)]);
var inst_36685 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_36648);
var inst_36686 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36683,inst_36685);
var state_36730__$1 = state_36730;
var statearr_36823_36905 = state_36730__$1;
(statearr_36823_36905[(2)] = inst_36686);

(statearr_36823_36905[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (37))){
var inst_36671 = (state_36730[(24)]);
var state_36730__$1 = state_36730;
var statearr_36824_36906 = state_36730__$1;
(statearr_36824_36906[(2)] = inst_36671);

(statearr_36824_36906[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (8))){
var inst_36606 = (state_36730[(2)]);
var state_36730__$1 = state_36730;
if(cljs.core.truth_(inst_36606)){
var statearr_36825_36907 = state_36730__$1;
(statearr_36825_36907[(1)] = (9));

} else {
var statearr_36826_36908 = state_36730__$1;
(statearr_36826_36908[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36731 === (49))){
var inst_36695 = (state_36730[(21)]);
var state_36730__$1 = state_36730;
var statearr_36827_36909 = state_36730__$1;
(statearr_36827_36909[(2)] = inst_36695);

(statearr_36827_36909[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__11438__auto__ = null;
var fluree$db$query$fql$state_machine__11438__auto____0 = (function (){
var statearr_36828 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36828[(0)] = fluree$db$query$fql$state_machine__11438__auto__);

(statearr_36828[(1)] = (1));

return statearr_36828;
});
var fluree$db$query$fql$state_machine__11438__auto____1 = (function (state_36730){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_36730);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e36829){var ex__11441__auto__ = e36829;
var statearr_36830_36910 = state_36730;
(statearr_36830_36910[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_36730[(4)]))){
var statearr_36831_36911 = state_36730;
(statearr_36831_36911[(1)] = cljs.core.first((state_36730[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36912 = state_36730;
state_36730 = G__36912;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__11438__auto__ = function(state_36730){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__11438__auto____1.call(this,state_36730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__11438__auto____0;
fluree$db$query$fql$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__11438__auto____1;
return fluree$db$query$fql$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_36832 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_36832[(6)] = c__11512__auto__);

return statearr_36832;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__36915,groupBy){
var map__36916 = p__36915;
var map__36916__$1 = cljs.core.__destructure_map(map__36916);
var res = map__36916__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36916__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36916__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__36917 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36917,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36917,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36913_SHARP_){
return fluree.db.util.core.index_of(headers,p1__36913_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36914_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__36914_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__36920 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36920,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36920,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__36923,p__36924,opts){
var map__36925 = p__36923;
var map__36925__$1 = cljs.core.__destructure_map(map__36925);
var res = map__36925__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36925__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36925__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__36926 = p__36924;
var map__36926__$1 = cljs.core.__destructure_map(map__36926);
var select_spec = map__36926__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36926__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36926__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36926__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36926__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36926__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36926__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36926__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_37168){
var state_val_37169 = (state_37168[(1)]);
if((state_val_37169 === (65))){
var state_37168__$1 = state_37168;
var statearr_37170_37321 = state_37168__$1;
(statearr_37170_37321[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (70))){
var inst_37089 = (state_37168[(7)]);
var state_37168__$1 = state_37168;
var statearr_37172_37322 = state_37168__$1;
(statearr_37172_37322[(2)] = inst_37089);

(statearr_37172_37322[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (62))){
var state_37168__$1 = state_37168;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_37173_37323 = state_37168__$1;
(statearr_37173_37323[(1)] = (64));

} else {
var statearr_37174_37324 = state_37168__$1;
(statearr_37174_37324[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (74))){
var inst_37064 = (state_37168[(8)]);
var inst_36996 = (state_37168[(9)]);
var inst_37005 = (state_37168[(10)]);
var inst_37097 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36996,inst_37005,inst_37064);
var state_37168__$1 = state_37168;
var statearr_37175_37325 = state_37168__$1;
(statearr_37175_37325[(2)] = inst_37097);

(statearr_37175_37325[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (7))){
var state_37168__$1 = state_37168;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_37176_37326 = state_37168__$1;
(statearr_37176_37326[(1)] = (82));

} else {
var statearr_37177_37327 = state_37168__$1;
(statearr_37177_37327[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (59))){
var inst_37064 = (state_37168[(8)]);
var inst_36994 = (state_37168[(11)]);
var inst_37068 = cljs.core.count(inst_37064);
var inst_37069 = (inst_36994 - inst_37068);
var state_37168__$1 = state_37168;
var statearr_37178_37328 = state_37168__$1;
(statearr_37178_37328[(2)] = inst_37069);

(statearr_37178_37328[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (86))){
var state_37168__$1 = state_37168;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_37179_37329 = state_37168__$1;
(statearr_37179_37329[(1)] = (89));

} else {
var statearr_37180_37330 = state_37168__$1;
(statearr_37180_37330[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (20))){
var state_37168__$1 = state_37168;
var statearr_37181_37331 = state_37168__$1;
(statearr_37181_37331[(2)] = (0));

(statearr_37181_37331[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (72))){
var inst_37094 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
if(cljs.core.truth_(inst_37094)){
var statearr_37182_37332 = state_37168__$1;
(statearr_37182_37332[(1)] = (73));

} else {
var statearr_37183_37333 = state_37168__$1;
(statearr_37183_37333[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (58))){
var state_37168__$1 = state_37168;
var statearr_37184_37334 = state_37168__$1;
(statearr_37184_37334[(2)] = null);

(statearr_37184_37334[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (60))){
var inst_36995 = (state_37168[(12)]);
var inst_37071 = (state_37168[(2)]);
var inst_37072 = (inst_36995 <= (0));
var state_37168__$1 = (function (){var statearr_37185 = state_37168;
(statearr_37185[(13)] = inst_37071);

return statearr_37185;
})();
if(cljs.core.truth_(inst_37072)){
var statearr_37186_37335 = state_37168__$1;
(statearr_37186_37335[(1)] = (61));

} else {
var statearr_37187_37336 = state_37168__$1;
(statearr_37187_37336[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (27))){
var inst_36994 = (state_37168[(11)]);
var inst_37018 = (inst_36994 < (1));
var state_37168__$1 = state_37168;
var statearr_37188_37337 = state_37168__$1;
(statearr_37188_37337[(2)] = inst_37018);

(statearr_37188_37337[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (1))){
var state_37168__$1 = state_37168;
var statearr_37189_37338 = state_37168__$1;
(statearr_37189_37338[(2)] = null);

(statearr_37189_37338[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (69))){
var inst_37084 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
var statearr_37190_37339 = state_37168__$1;
(statearr_37190_37339[(2)] = inst_37084);

(statearr_37190_37339[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (24))){
var inst_36996 = (state_37168[(9)]);
var state_37168__$1 = state_37168;
var statearr_37191_37340 = state_37168__$1;
(statearr_37191_37340[(2)] = inst_36996);

(statearr_37191_37340[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (55))){
var inst_37054 = (state_37168[(14)]);
var inst_36994 = (state_37168[(11)]);
var inst_37061 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_36994,inst_37054);
var state_37168__$1 = state_37168;
var statearr_37192_37341 = state_37168__$1;
(statearr_37192_37341[(2)] = inst_37061);

(statearr_37192_37341[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (85))){
var inst_37139 = (state_37168[(15)]);
var inst_37138 = (state_37168[(2)]);
var inst_37139__$1 = fluree.db.util.async.throw_err(inst_37138);
var inst_37140 = cljs.core.coll_QMARK_(inst_37139__$1);
var inst_37141 = (!(inst_37140));
var state_37168__$1 = (function (){var statearr_37193 = state_37168;
(statearr_37193[(15)] = inst_37139__$1);

return statearr_37193;
})();
if(inst_37141){
var statearr_37194_37342 = state_37168__$1;
(statearr_37194_37342[(1)] = (86));

} else {
var statearr_37195_37343 = state_37168__$1;
(statearr_37195_37343[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (39))){
var inst_37013 = (state_37168[(16)]);
var inst_37035 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_37036 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_37037 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_37013,inst_37035,inst_37036);
var state_37168__$1 = state_37168;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37168__$1,(42),inst_37037);
} else {
if((state_val_37169 === (88))){
var inst_37161 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
var statearr_37196_37344 = state_37168__$1;
(statearr_37196_37344[(2)] = inst_37161);

(statearr_37196_37344[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (46))){
var inst_36995 = (state_37168[(12)]);
var inst_37049 = ((0) < inst_36995);
var state_37168__$1 = state_37168;
if(cljs.core.truth_(inst_37049)){
var statearr_37197_37345 = state_37168__$1;
(statearr_37197_37345[(1)] = (49));

} else {
var statearr_37198_37346 = state_37168__$1;
(statearr_37198_37346[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (4))){
var inst_36927 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
var statearr_37199_37347 = state_37168__$1;
(statearr_37199_37347[(2)] = inst_36927);

(statearr_37199_37347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (77))){
var inst_36994 = (state_37168[(11)]);
var inst_37105 = (inst_36994 - (1));
var state_37168__$1 = state_37168;
var statearr_37200_37348 = state_37168__$1;
(statearr_37200_37348[(2)] = inst_37105);

(statearr_37200_37348[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (95))){
var inst_37139 = (state_37168[(15)]);
var state_37168__$1 = state_37168;
var statearr_37201_37349 = state_37168__$1;
(statearr_37201_37349[(2)] = inst_37139);

(statearr_37201_37349[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (54))){
var inst_37059 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
if(cljs.core.truth_(inst_37059)){
var statearr_37202_37350 = state_37168__$1;
(statearr_37202_37350[(1)] = (55));

} else {
var statearr_37203_37351 = state_37168__$1;
(statearr_37203_37351[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (92))){
var inst_37139 = (state_37168[(15)]);
var inst_37152 = cljs.core.first(inst_37139);
var state_37168__$1 = state_37168;
var statearr_37204_37352 = state_37168__$1;
(statearr_37204_37352[(2)] = inst_37152);

(statearr_37204_37352[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (15))){
var inst_36945 = (state_37168[(17)]);
var inst_36953 = (state_37168[(2)]);
var inst_36954 = fluree.db.util.async.throw_err(inst_36953);
var inst_36955 = [inst_36945];
var inst_36956 = [inst_36954];
var inst_36957 = cljs.core.PersistentHashMap.fromArrays(inst_36955,inst_36956);
var state_37168__$1 = state_37168;
var statearr_37205_37353 = state_37168__$1;
(statearr_37205_37353[(2)] = inst_36957);

(statearr_37205_37353[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (48))){
var inst_37117 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
var statearr_37206_37354 = state_37168__$1;
(statearr_37206_37354[(2)] = inst_37117);

(statearr_37206_37354[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (50))){
var inst_37040 = (state_37168[(18)]);
var state_37168__$1 = state_37168;
var statearr_37207_37355 = state_37168__$1;
(statearr_37207_37355[(2)] = inst_37040);

(statearr_37207_37355[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (75))){
var inst_37006 = (state_37168[(19)]);
var inst_37009 = (state_37168[(20)]);
var inst_37071 = (state_37168[(13)]);
var inst_37088 = (state_37168[(21)]);
var inst_37099 = (state_37168[(2)]);
var inst_36992 = inst_37006;
var inst_36993 = inst_37009;
var inst_36994 = inst_37071;
var inst_36995 = inst_37088;
var inst_36996 = inst_37099;
var state_37168__$1 = (function (){var statearr_37208 = state_37168;
(statearr_37208[(22)] = inst_36992);

(statearr_37208[(12)] = inst_36995);

(statearr_37208[(23)] = inst_36993);

(statearr_37208[(9)] = inst_36996);

(statearr_37208[(11)] = inst_36994);

return statearr_37208;
})();
var statearr_37209_37356 = state_37168__$1;
(statearr_37209_37356[(2)] = null);

(statearr_37209_37356[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (21))){
var inst_36985 = (state_37168[(24)]);
var inst_36973 = (state_37168[(25)]);
var inst_36977 = (state_37168[(26)]);
var inst_36990 = (state_37168[(2)]);
var inst_36991 = cljs.core.PersistentHashMap.EMPTY;
var inst_36992 = inst_36973;
var inst_36993 = inst_36977;
var inst_36994 = inst_36985;
var inst_36995 = inst_36990;
var inst_36996 = inst_36991;
var state_37168__$1 = (function (){var statearr_37210 = state_37168;
(statearr_37210[(22)] = inst_36992);

(statearr_37210[(12)] = inst_36995);

(statearr_37210[(23)] = inst_36993);

(statearr_37210[(9)] = inst_36996);

(statearr_37210[(11)] = inst_36994);

return statearr_37210;
})();
var statearr_37211_37357 = state_37168__$1;
(statearr_37211_37357[(2)] = null);

(statearr_37211_37357[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (31))){
var inst_37010 = (state_37168[(27)]);
var inst_36995 = (state_37168[(12)]);
var inst_37024 = (inst_36995 >= inst_37010);
var state_37168__$1 = state_37168;
if(cljs.core.truth_(inst_37024)){
var statearr_37212_37358 = state_37168__$1;
(statearr_37212_37358[(1)] = (33));

} else {
var statearr_37213_37359 = state_37168__$1;
(statearr_37213_37359[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (32))){
var inst_37124 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
var statearr_37214_37360 = state_37168__$1;
(statearr_37214_37360[(2)] = inst_37124);

(statearr_37214_37360[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (40))){
var state_37168__$1 = state_37168;
var statearr_37215_37361 = state_37168__$1;
(statearr_37215_37361[(2)] = null);

(statearr_37215_37361[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (91))){
var inst_37149 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
var statearr_37216_37362 = state_37168__$1;
(statearr_37216_37362[(2)] = inst_37149);

(statearr_37216_37362[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (56))){
var inst_37054 = (state_37168[(14)]);
var state_37168__$1 = state_37168;
var statearr_37217_37363 = state_37168__$1;
(statearr_37217_37363[(2)] = inst_37054);

(statearr_37217_37363[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (33))){
var state_37168__$1 = state_37168;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_37218_37364 = state_37168__$1;
(statearr_37218_37364[(1)] = (36));

} else {
var statearr_37219_37365 = state_37168__$1;
(statearr_37219_37365[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (13))){
var inst_36973 = (state_37168[(25)]);
var inst_36977 = (state_37168[(26)]);
var inst_36942 = (state_37168[(28)]);
var inst_36973__$1 = cljs.core.keys(inst_36942);
var inst_36974 = cljs.core.seq(inst_36973__$1);
var inst_36975 = cljs.core.first(inst_36974);
var inst_36976 = cljs.core.next(inst_36974);
var inst_36977__$1 = cljs.core.vals(inst_36942);
var inst_36978 = cljs.core.seq(inst_36977__$1);
var inst_36979 = cljs.core.first(inst_36978);
var inst_36980 = cljs.core.next(inst_36978);
var inst_36981 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_37168__$1 = (function (){var statearr_37220 = state_37168;
(statearr_37220[(29)] = inst_36976);

(statearr_37220[(25)] = inst_36973__$1);

(statearr_37220[(26)] = inst_36977__$1);

(statearr_37220[(30)] = inst_36975);

(statearr_37220[(31)] = inst_36980);

(statearr_37220[(32)] = inst_36979);

return statearr_37220;
})();
if(inst_36981){
var statearr_37221_37366 = state_37168__$1;
(statearr_37221_37366[(1)] = (16));

} else {
var statearr_37222_37367 = state_37168__$1;
(statearr_37222_37367[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (22))){
var inst_36992 = (state_37168[(22)]);
var inst_36993 = (state_37168[(23)]);
var inst_37004 = cljs.core.seq(inst_36992);
var inst_37005 = cljs.core.first(inst_37004);
var inst_37006 = cljs.core.next(inst_37004);
var inst_37007 = cljs.core.seq(inst_36993);
var inst_37008 = cljs.core.first(inst_37007);
var inst_37009 = cljs.core.next(inst_37007);
var inst_37010 = cljs.core.count(inst_37008);
var inst_37011 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_37012 = [headers,vars,inst_37008];
var inst_37013 = cljs.core.PersistentHashMap.fromArrays(inst_37011,inst_37012);
var inst_37014 = (inst_37008 == null);
var state_37168__$1 = (function (){var statearr_37223 = state_37168;
(statearr_37223[(19)] = inst_37006);

(statearr_37223[(27)] = inst_37010);

(statearr_37223[(20)] = inst_37009);

(statearr_37223[(16)] = inst_37013);

(statearr_37223[(10)] = inst_37005);

return statearr_37223;
})();
if(cljs.core.truth_(inst_37014)){
var statearr_37224_37368 = state_37168__$1;
(statearr_37224_37368[(1)] = (24));

} else {
var statearr_37225_37369 = state_37168__$1;
(statearr_37225_37369[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (90))){
var inst_37139 = (state_37168[(15)]);
var state_37168__$1 = state_37168;
var statearr_37226_37370 = state_37168__$1;
(statearr_37226_37370[(2)] = inst_37139);

(statearr_37226_37370[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (36))){
var inst_36995 = (state_37168[(12)]);
var inst_37027 = (inst_36995 - (1));
var state_37168__$1 = state_37168;
var statearr_37227_37371 = state_37168__$1;
(statearr_37227_37371[(2)] = inst_37027);

(statearr_37227_37371[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (41))){
var inst_37120 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
var statearr_37228_37372 = state_37168__$1;
(statearr_37228_37372[(2)] = inst_37120);

(statearr_37228_37372[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (89))){
var inst_37139 = (state_37168[(15)]);
var inst_37144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37145 = [inst_37139];
var inst_37146 = (new cljs.core.PersistentVector(null,1,(5),inst_37144,inst_37145,null));
var state_37168__$1 = state_37168;
var statearr_37229_37373 = state_37168__$1;
(statearr_37229_37373[(2)] = inst_37146);

(statearr_37229_37373[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (43))){
var inst_37040 = (state_37168[(18)]);
var inst_37043 = cljs.core.seq(inst_37040);
var state_37168__$1 = state_37168;
var statearr_37230_37374 = state_37168__$1;
(statearr_37230_37374[(2)] = inst_37043);

(statearr_37230_37374[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (61))){
var state_37168__$1 = state_37168;
var statearr_37231_37375 = state_37168__$1;
(statearr_37231_37375[(2)] = (0));

(statearr_37231_37375[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (29))){
var inst_37021 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
if(cljs.core.truth_(inst_37021)){
var statearr_37232_37376 = state_37168__$1;
(statearr_37232_37376[(1)] = (30));

} else {
var statearr_37233_37377 = state_37168__$1;
(statearr_37233_37377[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (44))){
var inst_37041 = (state_37168[(33)]);
var state_37168__$1 = state_37168;
var statearr_37234_37378 = state_37168__$1;
(statearr_37234_37378[(2)] = inst_37041);

(statearr_37234_37378[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (93))){
var state_37168__$1 = state_37168;
var statearr_37235_37379 = state_37168__$1;
(statearr_37235_37379[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (6))){
var inst_36934 = (state_37168[(34)]);
var inst_36934__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_36936 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_37168__$1 = (function (){var statearr_37237 = state_37168;
(statearr_37237[(35)] = inst_36936);

(statearr_37237[(34)] = inst_36934__$1);

return statearr_37237;
})();
if(cljs.core.truth_(inst_36934__$1)){
var statearr_37238_37380 = state_37168__$1;
(statearr_37238_37380[(1)] = (9));

} else {
var statearr_37239_37381 = state_37168__$1;
(statearr_37239_37381[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (28))){
var inst_36994 = (state_37168[(11)]);
var state_37168__$1 = state_37168;
var statearr_37240_37382 = state_37168__$1;
(statearr_37240_37382[(2)] = inst_36994);

(statearr_37240_37382[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (64))){
var inst_36995 = (state_37168[(12)]);
var inst_37076 = (inst_36995 - (1));
var state_37168__$1 = state_37168;
var statearr_37241_37383 = state_37168__$1;
(statearr_37241_37383[(2)] = inst_37076);

(statearr_37241_37383[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (51))){
var inst_36994 = (state_37168[(11)]);
var inst_37054 = (state_37168[(2)]);
var state_37168__$1 = (function (){var statearr_37242 = state_37168;
(statearr_37242[(14)] = inst_37054);

return statearr_37242;
})();
if(cljs.core.truth_(inst_36994)){
var statearr_37243_37384 = state_37168__$1;
(statearr_37243_37384[(1)] = (52));

} else {
var statearr_37244_37385 = state_37168__$1;
(statearr_37244_37385[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (25))){
var inst_36994 = (state_37168[(11)]);
var state_37168__$1 = state_37168;
if(cljs.core.truth_(inst_36994)){
var statearr_37245_37386 = state_37168__$1;
(statearr_37245_37386[(1)] = (27));

} else {
var statearr_37246_37387 = state_37168__$1;
(statearr_37246_37387[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (34))){
var state_37168__$1 = state_37168;
var statearr_37247_37388 = state_37168__$1;
(statearr_37247_37388[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (17))){
var state_37168__$1 = state_37168;
var statearr_37249_37389 = state_37168__$1;
(statearr_37249_37389[(2)] = limit);

(statearr_37249_37389[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (3))){
var inst_37166 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37168__$1,inst_37166);
} else {
if((state_val_37169 === (12))){
var inst_36942 = (state_37168[(28)]);
var inst_36944 = cljs.core.keys(inst_36942);
var inst_36945 = cljs.core.first(inst_36944);
var inst_36946 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_36947 = cljs.core.vals(inst_36942);
var inst_36948 = cljs.core.first(inst_36947);
var inst_36949 = [headers,vars,inst_36948];
var inst_36950 = cljs.core.PersistentHashMap.fromArrays(inst_36946,inst_36949);
var inst_36951 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_36950,select_spec,limit,opts);
var state_37168__$1 = (function (){var statearr_37250 = state_37168;
(statearr_37250[(17)] = inst_36945);

return statearr_37250;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37168__$1,(15),inst_36951);
} else {
if((state_val_37169 === (2))){
var _ = (function (){var statearr_37251 = state_37168;
(statearr_37251[(4)] = cljs.core.cons((5),(state_37168[(4)])));

return statearr_37251;
})();
var state_37168__$1 = state_37168;
if(cljs.core.truth_(groupBy)){
var statearr_37252_37390 = state_37168__$1;
(statearr_37252_37390[(1)] = (6));

} else {
var statearr_37253_37391 = state_37168__$1;
(statearr_37253_37391[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (66))){
var inst_37086 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
var statearr_37254_37392 = state_37168__$1;
(statearr_37254_37392[(2)] = inst_37086);

(statearr_37254_37392[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (23))){
var inst_37128 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
var statearr_37255_37393 = state_37168__$1;
(statearr_37255_37393[(2)] = inst_37128);

(statearr_37255_37393[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (47))){
var inst_36994 = (state_37168[(11)]);
var inst_37102 = (inst_36994 == null);
var state_37168__$1 = state_37168;
if(cljs.core.truth_(inst_37102)){
var statearr_37256_37394 = state_37168__$1;
(statearr_37256_37394[(1)] = (76));

} else {
var statearr_37257_37395 = state_37168__$1;
(statearr_37257_37395[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (35))){
var inst_37122 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
var statearr_37258_37396 = state_37168__$1;
(statearr_37258_37396[(2)] = inst_37122);

(statearr_37258_37396[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (82))){
var state_37168__$1 = state_37168;
var statearr_37259_37397 = state_37168__$1;
(statearr_37259_37397[(2)] = (1));

(statearr_37259_37397[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (76))){
var state_37168__$1 = state_37168;
var statearr_37260_37398 = state_37168__$1;
(statearr_37260_37398[(2)] = null);

(statearr_37260_37398[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (97))){
var inst_37157 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
var statearr_37261_37399 = state_37168__$1;
(statearr_37261_37399[(2)] = inst_37157);

(statearr_37261_37399[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (19))){
var inst_36986 = (state_37168[(36)]);
var state_37168__$1 = state_37168;
var statearr_37262_37400 = state_37168__$1;
(statearr_37262_37400[(2)] = inst_36986);

(statearr_37262_37400[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (57))){
var inst_36994 = (state_37168[(11)]);
var inst_37064 = (state_37168[(2)]);
var inst_37065 = (inst_36994 == null);
var state_37168__$1 = (function (){var statearr_37263 = state_37168;
(statearr_37263[(8)] = inst_37064);

return statearr_37263;
})();
if(cljs.core.truth_(inst_37065)){
var statearr_37264_37401 = state_37168__$1;
(statearr_37264_37401[(1)] = (58));

} else {
var statearr_37265_37402 = state_37168__$1;
(statearr_37265_37402[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (68))){
var state_37168__$1 = state_37168;
var statearr_37266_37403 = state_37168__$1;
(statearr_37266_37403[(2)] = null);

(statearr_37266_37403[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (11))){
var inst_36942 = (state_37168[(2)]);
var state_37168__$1 = (function (){var statearr_37268 = state_37168;
(statearr_37268[(28)] = inst_36942);

return statearr_37268;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_37269_37404 = state_37168__$1;
(statearr_37269_37404[(1)] = (12));

} else {
var statearr_37270_37405 = state_37168__$1;
(statearr_37270_37405[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (9))){
var inst_36936 = (state_37168[(35)]);
var inst_36934 = (state_37168[(34)]);
var inst_36938 = cljs.core.sorted_map_by(inst_36934);
var inst_36939 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36938,inst_36936);
var state_37168__$1 = state_37168;
var statearr_37271_37406 = state_37168__$1;
(statearr_37271_37406[(2)] = inst_36939);

(statearr_37271_37406[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (5))){
var _ = (function (){var statearr_37272 = state_37168;
(statearr_37272[(4)] = cljs.core.rest((state_37168[(4)])));

return statearr_37272;
})();
var state_37168__$1 = state_37168;
var ex37267 = (state_37168__$1[(2)]);
var statearr_37273_37407 = state_37168__$1;
(statearr_37273_37407[(5)] = ex37267);


if((ex37267 instanceof Error)){
var statearr_37274_37408 = state_37168__$1;
(statearr_37274_37408[(1)] = (4));

(statearr_37274_37408[(5)] = null);

} else {
throw ex37267;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (83))){
var state_37168__$1 = state_37168;
var statearr_37275_37409 = state_37168__$1;
(statearr_37275_37409[(2)] = limit);

(statearr_37275_37409[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (14))){
var inst_37130 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
var statearr_37276_37410 = state_37168__$1;
(statearr_37276_37410[(2)] = inst_37130);

(statearr_37276_37410[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (45))){
var inst_37046 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
if(cljs.core.truth_(inst_37046)){
var statearr_37277_37411 = state_37168__$1;
(statearr_37277_37411[(1)] = (46));

} else {
var statearr_37278_37412 = state_37168__$1;
(statearr_37278_37412[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (53))){
var inst_36994 = (state_37168[(11)]);
var state_37168__$1 = state_37168;
var statearr_37279_37413 = state_37168__$1;
(statearr_37279_37413[(2)] = inst_36994);

(statearr_37279_37413[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (78))){
var inst_36995 = (state_37168[(12)]);
var inst_37107 = (state_37168[(2)]);
var inst_37108 = (inst_36995 <= (0));
var state_37168__$1 = (function (){var statearr_37280 = state_37168;
(statearr_37280[(37)] = inst_37107);

return statearr_37280;
})();
if(cljs.core.truth_(inst_37108)){
var statearr_37281_37414 = state_37168__$1;
(statearr_37281_37414[(1)] = (79));

} else {
var statearr_37282_37415 = state_37168__$1;
(statearr_37282_37415[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (26))){
var inst_37126 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
var statearr_37283_37416 = state_37168__$1;
(statearr_37283_37416[(2)] = inst_37126);

(statearr_37283_37416[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (16))){
var state_37168__$1 = state_37168;
var statearr_37284_37417 = state_37168__$1;
(statearr_37284_37417[(2)] = null);

(statearr_37284_37417[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (81))){
var inst_37006 = (state_37168[(19)]);
var inst_37009 = (state_37168[(20)]);
var inst_36996 = (state_37168[(9)]);
var inst_37107 = (state_37168[(37)]);
var inst_37005 = (state_37168[(10)]);
var inst_37040 = (state_37168[(18)]);
var inst_37113 = (state_37168[(2)]);
var inst_37114 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36996,inst_37005,inst_37040);
var inst_36992 = inst_37006;
var inst_36993 = inst_37009;
var inst_36994 = inst_37107;
var inst_36995 = inst_37113;
var inst_36996__$1 = inst_37114;
var state_37168__$1 = (function (){var statearr_37287 = state_37168;
(statearr_37287[(22)] = inst_36992);

(statearr_37287[(12)] = inst_36995);

(statearr_37287[(23)] = inst_36993);

(statearr_37287[(9)] = inst_36996__$1);

(statearr_37287[(11)] = inst_36994);

return statearr_37287;
})();
var statearr_37288_37418 = state_37168__$1;
(statearr_37288_37418[(2)] = null);

(statearr_37288_37418[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (79))){
var state_37168__$1 = state_37168;
var statearr_37289_37419 = state_37168__$1;
(statearr_37289_37419[(2)] = (0));

(statearr_37289_37419[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (38))){
var inst_37006 = (state_37168[(19)]);
var inst_37009 = (state_37168[(20)]);
var inst_36996 = (state_37168[(9)]);
var inst_36994 = (state_37168[(11)]);
var inst_37031 = (state_37168[(2)]);
var tmp37285 = inst_36996;
var tmp37286 = inst_36994;
var inst_36992 = inst_37006;
var inst_36993 = inst_37009;
var inst_36994__$1 = tmp37286;
var inst_36995 = inst_37031;
var inst_36996__$1 = tmp37285;
var state_37168__$1 = (function (){var statearr_37290 = state_37168;
(statearr_37290[(22)] = inst_36992);

(statearr_37290[(12)] = inst_36995);

(statearr_37290[(23)] = inst_36993);

(statearr_37290[(9)] = inst_36996__$1);

(statearr_37290[(11)] = inst_36994__$1);

return statearr_37290;
})();
var statearr_37291_37420 = state_37168__$1;
(statearr_37291_37420[(2)] = null);

(statearr_37291_37420[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (87))){
var state_37168__$1 = state_37168;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_37292_37421 = state_37168__$1;
(statearr_37292_37421[(1)] = (92));

} else {
var statearr_37293_37422 = state_37168__$1;
(statearr_37293_37422[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (30))){
var inst_36996 = (state_37168[(9)]);
var state_37168__$1 = state_37168;
var statearr_37294_37423 = state_37168__$1;
(statearr_37294_37423[(2)] = inst_36996);

(statearr_37294_37423[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (73))){
var inst_36996 = (state_37168[(9)]);
var state_37168__$1 = state_37168;
var statearr_37295_37424 = state_37168__$1;
(statearr_37295_37424[(2)] = inst_36996);

(statearr_37295_37424[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (96))){
var state_37168__$1 = state_37168;
var statearr_37296_37425 = state_37168__$1;
(statearr_37296_37425[(2)] = null);

(statearr_37296_37425[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (10))){
var inst_36936 = (state_37168[(35)]);
var state_37168__$1 = state_37168;
var statearr_37297_37426 = state_37168__$1;
(statearr_37297_37426[(2)] = inst_36936);

(statearr_37297_37426[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (18))){
var inst_36986 = (state_37168[(36)]);
var inst_36985 = (state_37168[(2)]);
var inst_36986__$1 = offset;
var state_37168__$1 = (function (){var statearr_37298 = state_37168;
(statearr_37298[(24)] = inst_36985);

(statearr_37298[(36)] = inst_36986__$1);

return statearr_37298;
})();
if(cljs.core.truth_(inst_36986__$1)){
var statearr_37299_37427 = state_37168__$1;
(statearr_37299_37427[(1)] = (19));

} else {
var statearr_37300_37428 = state_37168__$1;
(statearr_37300_37428[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (52))){
var inst_36994 = (state_37168[(11)]);
var inst_37056 = ((0) < inst_36994);
var state_37168__$1 = state_37168;
var statearr_37301_37429 = state_37168__$1;
(statearr_37301_37429[(2)] = inst_37056);

(statearr_37301_37429[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (67))){
var inst_37064 = (state_37168[(8)]);
var inst_37010 = (state_37168[(27)]);
var inst_36995 = (state_37168[(12)]);
var inst_37079 = cljs.core.count(inst_37064);
var inst_37080 = (inst_37010 - inst_37079);
var inst_37081 = (inst_36995 - inst_37080);
var state_37168__$1 = state_37168;
var statearr_37302_37430 = state_37168__$1;
(statearr_37302_37430[(2)] = inst_37081);

(statearr_37302_37430[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (71))){
var inst_37064 = (state_37168[(8)]);
var inst_37092 = cljs.core.empty_QMARK_(inst_37064);
var state_37168__$1 = state_37168;
var statearr_37303_37431 = state_37168__$1;
(statearr_37303_37431[(2)] = inst_37092);

(statearr_37303_37431[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (42))){
var inst_37041 = (state_37168[(33)]);
var inst_37040 = (state_37168[(18)]);
var inst_37039 = (state_37168[(2)]);
var inst_37040__$1 = fluree.db.util.async.throw_err(inst_37039);
var inst_37041__$1 = cljs.core.coll_QMARK_(inst_37040__$1);
var state_37168__$1 = (function (){var statearr_37304 = state_37168;
(statearr_37304[(33)] = inst_37041__$1);

(statearr_37304[(18)] = inst_37040__$1);

return statearr_37304;
})();
if(inst_37041__$1){
var statearr_37305_37432 = state_37168__$1;
(statearr_37305_37432[(1)] = (43));

} else {
var statearr_37306_37433 = state_37168__$1;
(statearr_37306_37433[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (80))){
var inst_36995 = (state_37168[(12)]);
var inst_37111 = (inst_36995 - (1));
var state_37168__$1 = state_37168;
var statearr_37307_37434 = state_37168__$1;
(statearr_37307_37434[(2)] = inst_37111);

(statearr_37307_37434[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (37))){
var inst_37010 = (state_37168[(27)]);
var inst_36995 = (state_37168[(12)]);
var inst_37029 = (inst_36995 - inst_37010);
var state_37168__$1 = state_37168;
var statearr_37308_37435 = state_37168__$1;
(statearr_37308_37435[(2)] = inst_37029);

(statearr_37308_37435[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (63))){
var inst_37064 = (state_37168[(8)]);
var inst_37089 = (state_37168[(7)]);
var inst_37088 = (state_37168[(2)]);
var inst_37089__$1 = (inst_37064 == null);
var state_37168__$1 = (function (){var statearr_37309 = state_37168;
(statearr_37309[(7)] = inst_37089__$1);

(statearr_37309[(21)] = inst_37088);

return statearr_37309;
})();
if(cljs.core.truth_(inst_37089__$1)){
var statearr_37310_37436 = state_37168__$1;
(statearr_37310_37436[(1)] = (70));

} else {
var statearr_37311_37437 = state_37168__$1;
(statearr_37311_37437[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (94))){
var inst_37159 = (state_37168[(2)]);
var state_37168__$1 = state_37168;
var statearr_37312_37438 = state_37168__$1;
(statearr_37312_37438[(2)] = inst_37159);

(statearr_37312_37438[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (8))){
var inst_37163 = (state_37168[(2)]);
var _ = (function (){var statearr_37313 = state_37168;
(statearr_37313[(4)] = cljs.core.rest((state_37168[(4)])));

return statearr_37313;
})();
var state_37168__$1 = state_37168;
var statearr_37314_37439 = state_37168__$1;
(statearr_37314_37439[(2)] = inst_37163);

(statearr_37314_37439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (49))){
var inst_36995 = (state_37168[(12)]);
var inst_37040 = (state_37168[(18)]);
var inst_37051 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_36995,inst_37040);
var state_37168__$1 = state_37168;
var statearr_37315_37440 = state_37168__$1;
(statearr_37315_37440[(2)] = inst_37051);

(statearr_37315_37440[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37169 === (84))){
var inst_37135 = (state_37168[(2)]);
var inst_37136 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_37135,opts);
var state_37168__$1 = state_37168;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37168__$1,(85),inst_37136);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11438__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11438__auto____0 = (function (){
var statearr_37316 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37316[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11438__auto__);

(statearr_37316[(1)] = (1));

return statearr_37316;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11438__auto____1 = (function (state_37168){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_37168);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e37317){var ex__11441__auto__ = e37317;
var statearr_37318_37441 = state_37168;
(statearr_37318_37441[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_37168[(4)]))){
var statearr_37319_37442 = state_37168;
(statearr_37319_37442[(1)] = cljs.core.first((state_37168[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37443 = state_37168;
state_37168 = G__37443;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11438__auto__ = function(state_37168){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11438__auto____1.call(this,state_37168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11438__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11438__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_37320 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_37320[(6)] = c__11512__auto__);

return statearr_37320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__37446,opts){
var map__37447 = p__37446;
var map__37447__$1 = cljs.core.__destructure_map(map__37447);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37447__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37447__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37447__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37447__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__5045__auto__ = selectOne;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = select;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
var or__5045__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__37444_SHARP_){
return cljs.core.contains_QMARK_(p1__37444_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__37445_SHARP_){
return cljs.core.contains_QMARK_(p1__37445_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5804__auto__)){
var orderBy = temp__5804__auto__;
if(cljs.core.truth_((function (){var or__5045__auto__ = typeof orderBy === 'string';
if(or__5045__auto__){
return or__5045__auto__;
} else {
var and__5043__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__5043__auto__){
var G__37449 = cljs.core.first(orderBy);
var fexpr__37448 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__37448.cljs$core$IFn$_invoke$arity$1 ? fexpr__37448.cljs$core$IFn$_invoke$arity$1(G__37449) : fexpr__37448.call(null,G__37449));
} else {
return and__5043__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})(),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__5045__auto__ = selectDistinct;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__37450,p__37451){
var map__37452 = p__37450;
var map__37452__$1 = cljs.core.__destructure_map(map__37452);
var query_map = map__37452__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37452__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__37453 = p__37451;
var map__37453__$1 = cljs.core.__destructure_map(map__37453);
var where_result = map__37453__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37453__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37453__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__37454 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5802__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5802__auto__)){
var index_of = temp__5802__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37454,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37454,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37454,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_37487){
var state_val_37488 = (state_37487[(1)]);
if((state_val_37488 === (7))){
var inst_37466 = (state_37487[(7)]);
var state_37487__$1 = state_37487;
var statearr_37489_37512 = state_37487__$1;
(statearr_37489_37512[(2)] = inst_37466);

(statearr_37489_37512[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37488 === (1))){
var state_37487__$1 = state_37487;
var statearr_37490_37513 = state_37487__$1;
(statearr_37490_37513[(2)] = null);

(statearr_37490_37513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37488 === (4))){
var inst_37457 = (state_37487[(2)]);
var state_37487__$1 = state_37487;
var statearr_37491_37514 = state_37487__$1;
(statearr_37491_37514[(2)] = inst_37457);

(statearr_37491_37514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37488 === (13))){
var inst_37476 = (state_37487[(2)]);
var inst_37477 = fluree.db.util.async.throw_err(inst_37476);
var state_37487__$1 = state_37487;
var statearr_37492_37515 = state_37487__$1;
(statearr_37492_37515[(2)] = inst_37477);

(statearr_37492_37515[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37488 === (6))){
var inst_37466 = (state_37487[(7)]);
var inst_37465 = (state_37487[(2)]);
var inst_37466__$1 = fluree.db.util.async.throw_err(inst_37465);
var inst_37467 = fluree.db.util.core.exception_QMARK_(inst_37466__$1);
var state_37487__$1 = (function (){var statearr_37493 = state_37487;
(statearr_37493[(7)] = inst_37466__$1);

return statearr_37493;
})();
if(inst_37467){
var statearr_37494_37516 = state_37487__$1;
(statearr_37494_37516[(1)] = (7));

} else {
var statearr_37495_37517 = state_37487__$1;
(statearr_37495_37517[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37488 === (3))){
var inst_37485 = (state_37487[(2)]);
var state_37487__$1 = state_37487;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37487__$1,inst_37485);
} else {
if((state_val_37488 === (12))){
var inst_37480 = (state_37487[(2)]);
var state_37487__$1 = state_37487;
var statearr_37496_37518 = state_37487__$1;
(statearr_37496_37518[(2)] = inst_37480);

(statearr_37496_37518[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37488 === (2))){
var _ = (function (){var statearr_37497 = state_37487;
(statearr_37497[(4)] = cljs.core.cons((5),(state_37487[(4)])));

return statearr_37497;
})();
var inst_37463 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_37487__$1 = state_37487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37487__$1,(6),inst_37463);
} else {
if((state_val_37488 === (11))){
var state_37487__$1 = state_37487;
var statearr_37499_37519 = state_37487__$1;
(statearr_37499_37519[(2)] = null);

(statearr_37499_37519[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37488 === (9))){
var inst_37482 = (state_37487[(2)]);
var _ = (function (){var statearr_37500 = state_37487;
(statearr_37500[(4)] = cljs.core.rest((state_37487[(4)])));

return statearr_37500;
})();
var state_37487__$1 = state_37487;
var statearr_37501_37520 = state_37487__$1;
(statearr_37501_37520[(2)] = inst_37482);

(statearr_37501_37520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37488 === (5))){
var _ = (function (){var statearr_37502 = state_37487;
(statearr_37502[(4)] = cljs.core.rest((state_37487[(4)])));

return statearr_37502;
})();
var state_37487__$1 = state_37487;
var ex37498 = (state_37487__$1[(2)]);
var statearr_37503_37521 = state_37487__$1;
(statearr_37503_37521[(5)] = ex37498);


if((ex37498 instanceof Error)){
var statearr_37504_37522 = state_37487__$1;
(statearr_37504_37522[(1)] = (4));

(statearr_37504_37522[(5)] = null);

} else {
throw ex37498;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37488 === (10))){
var inst_37466 = (state_37487[(7)]);
var inst_37471 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_37466);
var inst_37472 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_37466);
var inst_37473 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_37471,inst_37472,query_map,opts);
var inst_37474 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_37466,inst_37473,opts);
var state_37487__$1 = state_37487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37487__$1,(13),inst_37474);
} else {
if((state_val_37488 === (8))){
var state_37487__$1 = state_37487;
var statearr_37505_37523 = state_37487__$1;
(statearr_37505_37523[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__11438__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__11438__auto____0 = (function (){
var statearr_37507 = [null,null,null,null,null,null,null,null];
(statearr_37507[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__11438__auto__);

(statearr_37507[(1)] = (1));

return statearr_37507;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__11438__auto____1 = (function (state_37487){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_37487);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e37508){var ex__11441__auto__ = e37508;
var statearr_37509_37524 = state_37487;
(statearr_37509_37524[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_37487[(4)]))){
var statearr_37510_37525 = state_37487;
(statearr_37510_37525[(1)] = cljs.core.first((state_37487[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37526 = state_37487;
state_37487 = G__37526;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__11438__auto__ = function(state_37487){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__11438__auto____1.call(this,state_37487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__11438__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__11438__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_37511 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_37511[(6)] = c__11512__auto__);

return statearr_37511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Running query:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0))], 0));

var map__37527 = query_map;
var map__37527__$1 = cljs.core.__destructure_map(map__37527);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37527__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37527__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37527__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37527__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37527__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37527__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37527__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37527__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37527__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37527__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37527__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37527__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__37528 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__5045__auto__ = offset;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__37528,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__37528;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.truth_((function (){var or__5045__auto____$1 = max_fuel;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_37886){
var state_val_37887 = (state_37886[(1)]);
if((state_val_37887 === (121))){
var inst_37847 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
var statearr_37888_38083 = state_37886__$1;
(statearr_37888_38083[(2)] = inst_37847);

(statearr_37888_38083[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (65))){
var inst_37724 = typeof from === 'string';
var state_37886__$1 = state_37886;
if(cljs.core.truth_(inst_37724)){
var statearr_37889_38084 = state_37886__$1;
(statearr_37889_38084[(1)] = (72));

} else {
var statearr_37890_38085 = state_37886__$1;
(statearr_37890_38085[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (70))){
var inst_37590 = (state_37886[(7)]);
var inst_37592 = (state_37886[(8)]);
var inst_37717 = (state_37886[(2)]);
var inst_37718 = fluree.db.util.async.throw_err(inst_37717);
var inst_37719 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_37592,fuel,max_fuel,inst_37590,inst_37718);
var state_37886__$1 = state_37886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37886__$1,(71),inst_37719);
} else {
if((state_val_37887 === (62))){
var inst_37697 = (state_37886[(9)]);
var state_37886__$1 = state_37886;
var statearr_37891_38086 = state_37886__$1;
(statearr_37891_38086[(2)] = inst_37697);

(statearr_37891_38086[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (74))){
var inst_37853 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
var statearr_37892_38087 = state_37886__$1;
(statearr_37892_38087[(2)] = inst_37853);

(statearr_37892_38087[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (110))){
var inst_37788 = (state_37886[(10)]);
var state_37886__$1 = state_37886;
var statearr_37893_38088 = state_37886__$1;
(statearr_37893_38088[(2)] = inst_37788);

(statearr_37893_38088[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (130))){
var inst_37873 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
var statearr_37894_38089 = state_37886__$1;
(statearr_37894_38089[(2)] = inst_37873);

(statearr_37894_38089[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (128))){
var inst_37864 = (state_37886[(11)]);
var inst_37869 = fluree.db.util.core.exception_QMARK_(inst_37864);
var inst_37870 = (!(inst_37869));
var state_37886__$1 = state_37886;
var statearr_37895_38090 = state_37886__$1;
(statearr_37895_38090[(2)] = inst_37870);

(statearr_37895_38090[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (7))){
var inst_37560 = (state_37886[(12)]);
var inst_37560__$1 = selectOne;
var state_37886__$1 = (function (){var statearr_37896 = state_37886;
(statearr_37896[(12)] = inst_37560__$1);

return statearr_37896;
})();
if(cljs.core.truth_(inst_37560__$1)){
var statearr_37897_38091 = state_37886__$1;
(statearr_37897_38091[(1)] = (9));

} else {
var statearr_37898_38092 = state_37886__$1;
(statearr_37898_38092[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (59))){
var inst_37590 = (state_37886[(7)]);
var inst_37675 = (state_37886[(13)]);
var inst_37592 = (state_37886[(8)]);
var inst_37580 = (state_37886[(14)]);
var inst_37689 = (state_37886[(2)]);
var inst_37690 = fluree.db.util.async.throw_err(inst_37689);
var inst_37691 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_37675,inst_37690);
var inst_37692 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_37592,fuel,max_fuel,inst_37590,inst_37691,inst_37580);
var state_37886__$1 = state_37886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37886__$1,(60),inst_37692);
} else {
if((state_val_37887 === (86))){
var inst_37582 = (state_37886[(15)]);
var inst_37590 = (state_37886[(7)]);
var inst_37592 = (state_37886[(8)]);
var inst_37580 = (state_37886[(14)]);
var inst_37757 = (state_37886[(2)]);
var inst_37758 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_37592,fuel,max_fuel,inst_37590,inst_37757,inst_37580,inst_37582);
var state_37886__$1 = state_37886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37886__$1,(87),inst_37758);
} else {
if((state_val_37887 === (20))){
var inst_37624 = (state_37886[(2)]);
var inst_37625 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37624,(0),null);
var inst_37626 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37624,(1),null);
var inst_37627 = typeof where === 'string';
var state_37886__$1 = (function (){var statearr_37899 = state_37886;
(statearr_37899[(16)] = inst_37625);

(statearr_37899[(17)] = inst_37626);

return statearr_37899;
})();
if(cljs.core.truth_(inst_37627)){
var statearr_37900_38093 = state_37886__$1;
(statearr_37900_38093[(1)] = (30));

} else {
var statearr_37901_38094 = state_37886__$1;
(statearr_37901_38094[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (72))){
var inst_37579 = (state_37886[(18)]);
var state_37886__$1 = state_37886;
if(cljs.core.truth_(inst_37579)){
var statearr_37902_38095 = state_37886__$1;
(statearr_37902_38095[(1)] = (75));

} else {
var statearr_37903_38096 = state_37886__$1;
(statearr_37903_38096[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (58))){
var inst_37683 = (state_37886[(2)]);
var inst_37684 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37685 = [from];
var inst_37686 = (new cljs.core.PersistentVector(null,1,(5),inst_37684,inst_37685,null));
var inst_37687 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_37686,inst_37683);
var state_37886__$1 = state_37886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37886__$1,(59),inst_37687);
} else {
if((state_val_37887 === (60))){
var inst_37694 = (state_37886[(2)]);
var inst_37695 = fluree.db.util.async.throw_err(inst_37694);
var state_37886__$1 = state_37886;
var statearr_37904_38097 = state_37886__$1;
(statearr_37904_38097[(2)] = inst_37695);

(statearr_37904_38097[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (27))){
var inst_37609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37610 = [null,null];
var inst_37611 = (new cljs.core.PersistentVector(null,2,(5),inst_37609,inst_37610,null));
var state_37886__$1 = state_37886;
var statearr_37905_38098 = state_37886__$1;
(statearr_37905_38098[(2)] = inst_37611);

(statearr_37905_38098[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (1))){
var state_37886__$1 = state_37886;
var statearr_37906_38099 = state_37886__$1;
(statearr_37906_38099[(2)] = null);

(statearr_37906_38099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (69))){
var inst_37714 = (state_37886[(2)]);
var inst_37715 = fluree.db.query.range._block_or_tx_collection(db,inst_37714);
var state_37886__$1 = state_37886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37886__$1,(70),inst_37715);
} else {
if((state_val_37887 === (101))){
var inst_37820 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
var statearr_37907_38100 = state_37886__$1;
(statearr_37907_38100[(2)] = inst_37820);

(statearr_37907_38100[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (24))){
var inst_37579 = (state_37886[(18)]);
var inst_37604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37605 = [inst_37579,"ASC"];
var inst_37606 = (new cljs.core.PersistentVector(null,2,(5),inst_37604,inst_37605,null));
var state_37886__$1 = state_37886;
var statearr_37908_38101 = state_37886__$1;
(statearr_37908_38101[(2)] = inst_37606);

(statearr_37908_38101[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (102))){
var inst_37794 = (state_37886[(19)]);
var state_37886__$1 = state_37886;
var statearr_37909_38102 = state_37886__$1;
(statearr_37909_38102[(2)] = inst_37794);

(statearr_37909_38102[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (55))){
var inst_37579 = (state_37886[(18)]);
var inst_37675 = (state_37886[(2)]);
var state_37886__$1 = (function (){var statearr_37910 = state_37886;
(statearr_37910[(13)] = inst_37675);

return statearr_37910;
})();
if(cljs.core.truth_(inst_37579)){
var statearr_37911_38103 = state_37886__$1;
(statearr_37911_38103[(1)] = (56));

} else {
var statearr_37912_38104 = state_37886__$1;
(statearr_37912_38104[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (85))){
var inst_37749 = (state_37886[(20)]);
var inst_37753 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37754 = [inst_37749];
var inst_37755 = (new cljs.core.PersistentVector(null,1,(5),inst_37753,inst_37754,null));
var state_37886__$1 = state_37886;
var statearr_37913_38105 = state_37886__$1;
(statearr_37913_38105[(2)] = inst_37755);

(statearr_37913_38105[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (39))){
var inst_37580 = (state_37886[(14)]);
var state_37886__$1 = state_37886;
var statearr_37914_38106 = state_37886__$1;
(statearr_37914_38106[(2)] = inst_37580);

(statearr_37914_38106[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (88))){
var inst_37763 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_37886__$1 = state_37886;
var statearr_37915_38107 = state_37886__$1;
(statearr_37915_38107[(2)] = inst_37763);

(statearr_37915_38107[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (46))){
var inst_37660 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
if(cljs.core.truth_(inst_37660)){
var statearr_37916_38108 = state_37886__$1;
(statearr_37916_38108[(1)] = (47));

} else {
var statearr_37917_38109 = state_37886__$1;
(statearr_37917_38109[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (4))){
var inst_37547 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
var statearr_37918_38110 = state_37886__$1;
(statearr_37918_38110[(2)] = inst_37547);

(statearr_37918_38110[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (77))){
var inst_37733 = (state_37886[(2)]);
var inst_37734 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_37733);
var state_37886__$1 = state_37886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37886__$1,(78),inst_37734);
} else {
if((state_val_37887 === (106))){
var state_37886__$1 = state_37886;
var statearr_37919_38111 = state_37886__$1;
(statearr_37919_38111[(2)] = null);

(statearr_37919_38111[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (119))){
var inst_37839 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_37840 = ["Invalid 'from' in query:",inst_37839].join('');
var inst_37841 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37842 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_37843 = cljs.core.PersistentHashMap.fromArrays(inst_37841,inst_37842);
var inst_37844 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_37840,inst_37843);
var state_37886__$1 = state_37886;
var statearr_37920_38112 = state_37886__$1;
(statearr_37920_38112[(2)] = inst_37844);

(statearr_37920_38112[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (95))){
var state_37886__$1 = state_37886;
var statearr_37921_38113 = state_37886__$1;
(statearr_37921_38113[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (54))){
var inst_37669 = (state_37886[(21)]);
var state_37886__$1 = state_37886;
var statearr_37923_38114 = state_37886__$1;
(statearr_37923_38114[(2)] = inst_37669);

(statearr_37923_38114[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (92))){
var inst_37768 = (state_37886[(22)]);
var state_37886__$1 = state_37886;
var statearr_37924_38115 = state_37886__$1;
(statearr_37924_38115[(2)] = inst_37768);

(statearr_37924_38115[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (104))){
var inst_37812 = (state_37886[(23)]);
var inst_37812__$1 = (state_37886[(2)]);
var state_37886__$1 = (function (){var statearr_37925 = state_37886;
(statearr_37925[(23)] = inst_37812__$1);

return statearr_37925;
})();
if(cljs.core.truth_(inst_37812__$1)){
var statearr_37926_38116 = state_37886__$1;
(statearr_37926_38116[(1)] = (109));

} else {
var statearr_37927_38117 = state_37886__$1;
(statearr_37927_38117[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (15))){
var inst_37583 = (state_37886[(24)]);
var inst_37581 = (state_37886[(25)]);
var inst_37587 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37583,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_37581);
var state_37886__$1 = state_37886;
var statearr_37928_38118 = state_37886__$1;
(statearr_37928_38118[(2)] = inst_37587);

(statearr_37928_38118[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (48))){
var inst_37697 = (state_37886[(9)]);
var inst_37697__$1 = typeof from === 'string';
var state_37886__$1 = (function (){var statearr_37929 = state_37886;
(statearr_37929[(9)] = inst_37697__$1);

return statearr_37929;
})();
if(cljs.core.truth_(inst_37697__$1)){
var statearr_37930_38119 = state_37886__$1;
(statearr_37930_38119[(1)] = (61));

} else {
var statearr_37931_38120 = state_37886__$1;
(statearr_37931_38120[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (50))){
var inst_37663 = (state_37886[(26)]);
var inst_37665 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_37666 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_37663,inst_37665);
var state_37886__$1 = state_37886;
var statearr_37932_38121 = state_37886__$1;
(statearr_37932_38121[(2)] = inst_37666);

(statearr_37932_38121[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (116))){
var state_37886__$1 = state_37886;
var statearr_37933_38122 = state_37886__$1;
(statearr_37933_38122[(2)] = null);

(statearr_37933_38122[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (75))){
var inst_37727 = cljs.core.PersistentHashMap.EMPTY;
var state_37886__$1 = state_37886;
var statearr_37934_38123 = state_37886__$1;
(statearr_37934_38123[(2)] = inst_37727);

(statearr_37934_38123[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (99))){
var inst_37788 = (state_37886[(10)]);
var state_37886__$1 = state_37886;
var statearr_37935_38124 = state_37886__$1;
(statearr_37935_38124[(2)] = inst_37788);

(statearr_37935_38124[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (21))){
var inst_37579 = (state_37886[(18)]);
var inst_37596 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37597 = cljs.core.second(inst_37579);
var inst_37598 = cljs.core.first(inst_37579);
var inst_37599 = [inst_37597,inst_37598];
var inst_37600 = (new cljs.core.PersistentVector(null,2,(5),inst_37596,inst_37599,null));
var state_37886__$1 = state_37886;
var statearr_37936_38125 = state_37886__$1;
(statearr_37936_38125[(2)] = inst_37600);

(statearr_37936_38125[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (31))){
var inst_37654 = (state_37886[(27)]);
var inst_37654__$1 = typeof from === 'string';
var state_37886__$1 = (function (){var statearr_37937 = state_37886;
(statearr_37937[(27)] = inst_37654__$1);

return statearr_37937;
})();
if(cljs.core.truth_(inst_37654__$1)){
var statearr_37938_38126 = state_37886__$1;
(statearr_37938_38126[(1)] = (44));

} else {
var statearr_37939_38127 = state_37886__$1;
(statearr_37939_38127[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (113))){
var state_37886__$1 = state_37886;
var statearr_37940_38128 = state_37886__$1;
(statearr_37940_38128[(2)] = null);

(statearr_37940_38128[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (32))){
var inst_37625 = (state_37886[(16)]);
var inst_37859 = (state_37886[(2)]);
var state_37886__$1 = (function (){var statearr_37941 = state_37886;
(statearr_37941[(28)] = inst_37859);

return statearr_37941;
})();
if(cljs.core.truth_(inst_37625)){
var statearr_37942_38129 = state_37886__$1;
(statearr_37942_38129[(1)] = (122));

} else {
var statearr_37943_38130 = state_37886__$1;
(statearr_37943_38130[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (40))){
var inst_37579 = (state_37886[(18)]);
var inst_37644 = (state_37886[(2)]);
var state_37886__$1 = (function (){var statearr_37944 = state_37886;
(statearr_37944[(29)] = inst_37644);

return statearr_37944;
})();
if(cljs.core.truth_(inst_37579)){
var statearr_37945_38131 = state_37886__$1;
(statearr_37945_38131[(1)] = (41));

} else {
var statearr_37946_38132 = state_37886__$1;
(statearr_37946_38132[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (129))){
var inst_37867 = (state_37886[(30)]);
var state_37886__$1 = state_37886;
var statearr_37947_38133 = state_37886__$1;
(statearr_37947_38133[(2)] = inst_37867);

(statearr_37947_38133[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (91))){
var inst_37770 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_37886__$1 = state_37886;
var statearr_37948_38134 = state_37886__$1;
(statearr_37948_38134[(2)] = inst_37770);

(statearr_37948_38134[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (117))){
var inst_37582 = (state_37886[(15)]);
var state_37886__$1 = state_37886;
var statearr_37949_38135 = state_37886__$1;
(statearr_37949_38135[(2)] = inst_37582);

(statearr_37949_38135[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (108))){
var inst_37809 = (state_37886[(2)]);
var inst_37810 = fluree.db.util.async.throw_err(inst_37809);
var state_37886__$1 = state_37886;
var statearr_37950_38136 = state_37886__$1;
(statearr_37950_38136[(2)] = inst_37810);

(statearr_37950_38136[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (56))){
var inst_37677 = cljs.core.PersistentHashMap.EMPTY;
var state_37886__$1 = state_37886;
var statearr_37951_38137 = state_37886__$1;
(statearr_37951_38137[(2)] = inst_37677);

(statearr_37951_38137[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (33))){
var state_37886__$1 = state_37886;
var statearr_37952_38138 = state_37886__$1;
(statearr_37952_38138[(2)] = from);

(statearr_37952_38138[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (13))){
var inst_37566 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37567 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_37568 = cljs.core.PersistentHashMap.fromArrays(inst_37566,inst_37567);
var inst_37569 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_37568);
var inst_37570 = (function(){throw inst_37569})();
var state_37886__$1 = state_37886;
var statearr_37953_38139 = state_37886__$1;
(statearr_37953_38139[(2)] = inst_37570);

(statearr_37953_38139[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (22))){
var inst_37579 = (state_37886[(18)]);
var inst_37602 = typeof inst_37579 === 'string';
var state_37886__$1 = state_37886;
if(cljs.core.truth_(inst_37602)){
var statearr_37954_38140 = state_37886__$1;
(statearr_37954_38140[(1)] = (24));

} else {
var statearr_37955_38141 = state_37886__$1;
(statearr_37955_38141[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (90))){
var inst_37761 = (state_37886[(31)]);
var inst_37766 = (state_37886[(2)]);
var state_37886__$1 = (function (){var statearr_37956 = state_37886;
(statearr_37956[(32)] = inst_37766);

return statearr_37956;
})();
var statearr_37957_38142 = state_37886__$1;
(statearr_37957_38142[(2)] = inst_37761);

(statearr_37957_38142[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (109))){
var inst_37788 = (state_37886[(10)]);
var inst_37812 = (state_37886[(23)]);
var inst_37814 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37788,inst_37812);
var state_37886__$1 = state_37886;
var statearr_37958_38143 = state_37886__$1;
(statearr_37958_38143[(2)] = inst_37814);

(statearr_37958_38143[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (36))){
var inst_37579 = (state_37886[(18)]);
var inst_37639 = (state_37886[(2)]);
var inst_37640 = fluree.db.util.async.throw_err(inst_37639);
var state_37886__$1 = (function (){var statearr_37959 = state_37886;
(statearr_37959[(33)] = inst_37640);

return statearr_37959;
})();
if(cljs.core.truth_(inst_37579)){
var statearr_37960_38144 = state_37886__$1;
(statearr_37960_38144[(1)] = (38));

} else {
var statearr_37961_38145 = state_37886__$1;
(statearr_37961_38145[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (41))){
var state_37886__$1 = state_37886;
var statearr_37962_38146 = state_37886__$1;
(statearr_37962_38146[(2)] = null);

(statearr_37962_38146[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (118))){
var inst_37590 = (state_37886[(7)]);
var inst_37828 = (state_37886[(34)]);
var inst_37824 = (state_37886[(35)]);
var inst_37592 = (state_37886[(8)]);
var inst_37832 = (state_37886[(2)]);
var inst_37833 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_37592,fuel,max_fuel,inst_37590,inst_37824,inst_37828,inst_37832);
var state_37886__$1 = state_37886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37886__$1,(112),inst_37833);
} else {
if((state_val_37887 === (89))){
var state_37886__$1 = state_37886;
var statearr_37963_38147 = state_37886__$1;
(statearr_37963_38147[(2)] = null);

(statearr_37963_38147[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (100))){
var inst_37794 = (state_37886[(19)]);
var inst_37799 = cljs.core.int_QMARK_(inst_37794);
var state_37886__$1 = state_37886;
if(inst_37799){
var statearr_37964_38148 = state_37886__$1;
(statearr_37964_38148[(1)] = (102));

} else {
var statearr_37965_38149 = state_37886__$1;
(statearr_37965_38149[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (131))){
var inst_37864 = (state_37886[(11)]);
var inst_37878 = cljs.core.first(inst_37864);
var state_37886__$1 = state_37886;
var statearr_37966_38150 = state_37886__$1;
(statearr_37966_38150[(2)] = inst_37878);

(statearr_37966_38150[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (122))){
var inst_37582 = (state_37886[(15)]);
var inst_37859 = (state_37886[(28)]);
var inst_37625 = (state_37886[(16)]);
var inst_37626 = (state_37886[(17)]);
var inst_37580 = (state_37886[(14)]);
var inst_37861 = fluree.db.query.fql.sort_offset_and_limit_res(inst_37625,inst_37626,inst_37582,inst_37580,inst_37859);
var state_37886__$1 = state_37886;
var statearr_37967_38151 = state_37886__$1;
(statearr_37967_38151[(2)] = inst_37861);

(statearr_37967_38151[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (43))){
var inst_37590 = (state_37886[(7)]);
var inst_37592 = (state_37886[(8)]);
var inst_37644 = (state_37886[(29)]);
var inst_37640 = (state_37886[(33)]);
var inst_37648 = (state_37886[(2)]);
var inst_37649 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_37592,fuel,max_fuel,inst_37590,inst_37640,inst_37644,inst_37648);
var state_37886__$1 = state_37886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37886__$1,(37),inst_37649);
} else {
if((state_val_37887 === (61))){
var inst_37699 = ["_tx",null,"_block",null];
var inst_37700 = (new cljs.core.PersistentArrayMap(null,2,inst_37699,null));
var inst_37701 = (new cljs.core.PersistentHashSet(null,inst_37700,null));
var inst_37702 = (inst_37701.cljs$core$IFn$_invoke$arity$1 ? inst_37701.cljs$core$IFn$_invoke$arity$1(from) : inst_37701.call(null,from));
var state_37886__$1 = state_37886;
var statearr_37968_38152 = state_37886__$1;
(statearr_37968_38152[(2)] = inst_37702);

(statearr_37968_38152[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (29))){
var inst_37614 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
var statearr_37969_38153 = state_37886__$1;
(statearr_37969_38153[(2)] = inst_37614);

(statearr_37969_38153[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (44))){
var inst_37656 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_37657 = clojure.string.includes_QMARK_(inst_37656,"/");
var state_37886__$1 = state_37886;
var statearr_37970_38154 = state_37886__$1;
(statearr_37970_38154[(2)] = inst_37657);

(statearr_37970_38154[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (93))){
var inst_37773 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
if(cljs.core.truth_(inst_37773)){
var statearr_37971_38155 = state_37886__$1;
(statearr_37971_38155[(1)] = (94));

} else {
var statearr_37972_38156 = state_37886__$1;
(statearr_37972_38156[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (6))){
var inst_37557 = (state_37886[(36)]);
var state_37886__$1 = state_37886;
var statearr_37973_38157 = state_37886__$1;
(statearr_37973_38157[(2)] = inst_37557);

(statearr_37973_38157[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (111))){
var inst_37795 = (state_37886[(37)]);
var inst_37817 = (state_37886[(2)]);
var inst_37787 = inst_37795;
var inst_37788 = inst_37817;
var state_37886__$1 = (function (){var statearr_37974 = state_37886;
(statearr_37974[(10)] = inst_37788);

(statearr_37974[(38)] = inst_37787);

return statearr_37974;
})();
var statearr_37975_38158 = state_37886__$1;
(statearr_37975_38158[(2)] = null);

(statearr_37975_38158[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (28))){
var state_37886__$1 = state_37886;
var statearr_37976_38159 = state_37886__$1;
(statearr_37976_38159[(2)] = null);

(statearr_37976_38159[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (64))){
var inst_37579 = (state_37886[(18)]);
var state_37886__$1 = state_37886;
if(cljs.core.truth_(inst_37579)){
var statearr_37977_38160 = state_37886__$1;
(statearr_37977_38160[(1)] = (67));

} else {
var statearr_37978_38161 = state_37886__$1;
(statearr_37978_38161[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (103))){
var state_37886__$1 = state_37886;
if(cljs.core.truth_(fuel)){
var statearr_37979_38162 = state_37886__$1;
(statearr_37979_38162[(1)] = (105));

} else {
var statearr_37980_38163 = state_37886__$1;
(statearr_37980_38163[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (51))){
var inst_37663 = (state_37886[(26)]);
var state_37886__$1 = state_37886;
var statearr_37981_38164 = state_37886__$1;
(statearr_37981_38164[(2)] = inst_37663);

(statearr_37981_38164[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (25))){
var state_37886__$1 = state_37886;
var statearr_37982_38165 = state_37886__$1;
(statearr_37982_38165[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (34))){
var state_37886__$1 = state_37886;
var statearr_37984_38166 = state_37886__$1;
(statearr_37984_38166[(2)] = null);

(statearr_37984_38166[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (125))){
var inst_37867 = (state_37886[(30)]);
var inst_37864 = (state_37886[(11)]);
var inst_37867__$1 = cljs.core.coll_QMARK_(inst_37864);
var state_37886__$1 = (function (){var statearr_37985 = state_37886;
(statearr_37985[(30)] = inst_37867__$1);

return statearr_37985;
})();
if(inst_37867__$1){
var statearr_37986_38167 = state_37886__$1;
(statearr_37986_38167[(1)] = (128));

} else {
var statearr_37987_38168 = state_37886__$1;
(statearr_37987_38168[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (17))){
var inst_37579 = (state_37886[(18)]);
var inst_37590 = (state_37886[(2)]);
var inst_37591 = cljs.core.PersistentHashMap.EMPTY;
var inst_37592 = cljs.core.volatile_BANG_(inst_37591);
var state_37886__$1 = (function (){var statearr_37988 = state_37886;
(statearr_37988[(7)] = inst_37590);

(statearr_37988[(8)] = inst_37592);

return statearr_37988;
})();
if(cljs.core.truth_(inst_37579)){
var statearr_37989_38169 = state_37886__$1;
(statearr_37989_38169[(1)] = (18));

} else {
var statearr_37990_38170 = state_37886__$1;
(statearr_37990_38170[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (3))){
var inst_37884 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37886__$1,inst_37884);
} else {
if((state_val_37887 === (12))){
var inst_37563 = (state_37886[(39)]);
var state_37886__$1 = state_37886;
var statearr_37991_38171 = state_37886__$1;
(statearr_37991_38171[(2)] = inst_37563);

(statearr_37991_38171[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (2))){
var inst_37557 = (state_37886[(36)]);
var _ = (function (){var statearr_37992 = state_37886;
(statearr_37992[(4)] = cljs.core.cons((5),(state_37886[(4)])));

return statearr_37992;
})();
var inst_37557__$1 = select;
var state_37886__$1 = (function (){var statearr_37993 = state_37886;
(statearr_37993[(36)] = inst_37557__$1);

return statearr_37993;
})();
if(cljs.core.truth_(inst_37557__$1)){
var statearr_37994_38172 = state_37886__$1;
(statearr_37994_38172[(1)] = (6));

} else {
var statearr_37995_38173 = state_37886__$1;
(statearr_37995_38173[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (66))){
var inst_37855 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
var statearr_37996_38174 = state_37886__$1;
(statearr_37996_38174[(2)] = inst_37855);

(statearr_37996_38174[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (107))){
var inst_37794 = (state_37886[(19)]);
var inst_37806 = (state_37886[(2)]);
var inst_37807 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_37794,false);
var state_37886__$1 = (function (){var statearr_37997 = state_37886;
(statearr_37997[(40)] = inst_37806);

return statearr_37997;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37886__$1,(108),inst_37807);
} else {
if((state_val_37887 === (23))){
var inst_37618 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
var statearr_37998_38175 = state_37886__$1;
(statearr_37998_38175[(2)] = inst_37618);

(statearr_37998_38175[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (47))){
var inst_37663 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_37886__$1 = (function (){var statearr_37999 = state_37886;
(statearr_37999[(26)] = inst_37663);

return statearr_37999;
})();
if(cljs.core.truth_(fuel)){
var statearr_38000_38176 = state_37886__$1;
(statearr_38000_38176[(1)] = (50));

} else {
var statearr_38001_38177 = state_37886__$1;
(statearr_38001_38177[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (35))){
var inst_37582 = (state_37886[(15)]);
var inst_37580 = (state_37886[(14)]);
var inst_37633 = (state_37886[(2)]);
var inst_37634 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_37635 = [inst_37580,inst_37582];
var inst_37636 = cljs.core.PersistentHashMap.fromArrays(inst_37634,inst_37635);
var inst_37637 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where,inst_37633,inst_37636);
var state_37886__$1 = state_37886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37886__$1,(36),inst_37637);
} else {
if((state_val_37887 === (127))){
var inst_37876 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
if(cljs.core.truth_(inst_37876)){
var statearr_38002_38178 = state_37886__$1;
(statearr_38002_38178[(1)] = (131));

} else {
var statearr_38003_38179 = state_37886__$1;
(statearr_38003_38179[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (82))){
var inst_37851 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
var statearr_38004_38180 = state_37886__$1;
(statearr_38004_38180[(2)] = inst_37851);

(statearr_38004_38180[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (76))){
var inst_37582 = (state_37886[(15)]);
var inst_37580 = (state_37886[(14)]);
var inst_37729 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_37730 = [inst_37580,inst_37582];
var inst_37731 = cljs.core.PersistentHashMap.fromArrays(inst_37729,inst_37730);
var state_37886__$1 = state_37886;
var statearr_38005_38181 = state_37886__$1;
(statearr_38005_38181[(2)] = inst_37731);

(statearr_38005_38181[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (97))){
var inst_37787 = (state_37886[(38)]);
var inst_37794 = (state_37886[(19)]);
var inst_37793 = cljs.core.seq(inst_37787);
var inst_37794__$1 = cljs.core.first(inst_37793);
var inst_37795 = cljs.core.next(inst_37793);
var inst_37796 = cljs.core.not(inst_37794__$1);
var state_37886__$1 = (function (){var statearr_38006 = state_37886;
(statearr_38006[(37)] = inst_37795);

(statearr_38006[(19)] = inst_37794__$1);

return statearr_38006;
})();
if(inst_37796){
var statearr_38007_38182 = state_37886__$1;
(statearr_38007_38182[(1)] = (99));

} else {
var statearr_38008_38183 = state_37886__$1;
(statearr_38008_38183[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (19))){
var inst_37620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37621 = [null,null];
var inst_37622 = (new cljs.core.PersistentVector(null,2,(5),inst_37620,inst_37621,null));
var state_37886__$1 = state_37886;
var statearr_38009_38184 = state_37886__$1;
(statearr_38009_38184[(2)] = inst_37622);

(statearr_38009_38184[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (57))){
var inst_37582 = (state_37886[(15)]);
var inst_37580 = (state_37886[(14)]);
var inst_37679 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_37680 = [inst_37580,inst_37582];
var inst_37681 = cljs.core.PersistentHashMap.fromArrays(inst_37679,inst_37680);
var state_37886__$1 = state_37886;
var statearr_38010_38185 = state_37886__$1;
(statearr_38010_38185[(2)] = inst_37681);

(statearr_38010_38185[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (68))){
var inst_37582 = (state_37886[(15)]);
var inst_37580 = (state_37886[(14)]);
var inst_37710 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_37711 = [inst_37580,inst_37582];
var inst_37712 = cljs.core.PersistentHashMap.fromArrays(inst_37710,inst_37711);
var state_37886__$1 = state_37886;
var statearr_38011_38186 = state_37886__$1;
(statearr_38011_38186[(2)] = inst_37712);

(statearr_38011_38186[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (11))){
var inst_37574 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
var statearr_38012_38187 = state_37886__$1;
(statearr_38012_38187[(2)] = inst_37574);

(statearr_38012_38187[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (115))){
var inst_37579 = (state_37886[(18)]);
var inst_37828 = (state_37886[(2)]);
var state_37886__$1 = (function (){var statearr_38014 = state_37886;
(statearr_38014[(34)] = inst_37828);

return statearr_38014;
})();
if(cljs.core.truth_(inst_37579)){
var statearr_38015_38188 = state_37886__$1;
(statearr_38015_38188[(1)] = (116));

} else {
var statearr_38016_38189 = state_37886__$1;
(statearr_38016_38189[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (9))){
var inst_37560 = (state_37886[(12)]);
var state_37886__$1 = state_37886;
var statearr_38017_38190 = state_37886__$1;
(statearr_38017_38190[(2)] = inst_37560);

(statearr_38017_38190[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (5))){
var _ = (function (){var statearr_38018 = state_37886;
(statearr_38018[(4)] = cljs.core.rest((state_37886[(4)])));

return statearr_38018;
})();
var state_37886__$1 = state_37886;
var ex38013 = (state_37886__$1[(2)]);
var statearr_38019_38191 = state_37886__$1;
(statearr_38019_38191[(5)] = ex38013);


if((ex38013 instanceof Error)){
var statearr_38020_38192 = state_37886__$1;
(statearr_38020_38192[(1)] = (4));

(statearr_38020_38192[(5)] = null);

} else {
throw ex38013;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (112))){
var inst_37835 = (state_37886[(2)]);
var inst_37836 = fluree.db.util.async.throw_err(inst_37835);
var state_37886__$1 = state_37886;
var statearr_38021_38193 = state_37886__$1;
(statearr_38021_38193[(2)] = inst_37836);

(statearr_38021_38193[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (83))){
var inst_37749 = (state_37886[(20)]);
var inst_37748 = (state_37886[(2)]);
var inst_37749__$1 = fluree.db.util.async.throw_err(inst_37748);
var inst_37750 = (inst_37749__$1 == null);
var state_37886__$1 = (function (){var statearr_38022 = state_37886;
(statearr_38022[(20)] = inst_37749__$1);

return statearr_38022;
})();
if(cljs.core.truth_(inst_37750)){
var statearr_38023_38194 = state_37886__$1;
(statearr_38023_38194[(1)] = (84));

} else {
var statearr_38024_38195 = state_37886__$1;
(statearr_38024_38195[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (14))){
var inst_37572 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
var statearr_38025_38196 = state_37886__$1;
(statearr_38025_38196[(2)] = inst_37572);

(statearr_38025_38196[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (45))){
var inst_37654 = (state_37886[(27)]);
var state_37886__$1 = state_37886;
var statearr_38026_38197 = state_37886__$1;
(statearr_38026_38197[(2)] = inst_37654);

(statearr_38026_38197[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (53))){
var inst_37669 = (state_37886[(21)]);
var inst_37671 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_37672 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_37669,inst_37671);
var state_37886__$1 = state_37886;
var statearr_38027_38198 = state_37886__$1;
(statearr_38027_38198[(2)] = inst_37672);

(statearr_38027_38198[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (78))){
var inst_37590 = (state_37886[(7)]);
var inst_37592 = (state_37886[(8)]);
var inst_37736 = (state_37886[(2)]);
var inst_37737 = fluree.db.util.async.throw_err(inst_37736);
var inst_37738 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_37592,fuel,max_fuel,inst_37590,inst_37737);
var state_37886__$1 = state_37886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37886__$1,(79),inst_37738);
} else {
if((state_val_37887 === (132))){
var inst_37864 = (state_37886[(11)]);
var state_37886__$1 = state_37886;
var statearr_38028_38199 = state_37886__$1;
(statearr_38028_38199[(2)] = inst_37864);

(statearr_38028_38199[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (26))){
var inst_37616 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
var statearr_38029_38200 = state_37886__$1;
(statearr_38029_38200[(2)] = inst_37616);

(statearr_38029_38200[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (123))){
var inst_37859 = (state_37886[(28)]);
var state_37886__$1 = state_37886;
var statearr_38030_38201 = state_37886__$1;
(statearr_38030_38201[(2)] = inst_37859);

(statearr_38030_38201[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (16))){
var inst_37583 = (state_37886[(24)]);
var state_37886__$1 = state_37886;
var statearr_38031_38202 = state_37886__$1;
(statearr_38031_38202[(2)] = inst_37583);

(statearr_38031_38202[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (133))){
var inst_37881 = (state_37886[(2)]);
var _ = (function (){var statearr_38032 = state_37886;
(statearr_38032[(4)] = cljs.core.rest((state_37886[(4)])));

return statearr_38032;
})();
var state_37886__$1 = state_37886;
var statearr_38033_38203 = state_37886__$1;
(statearr_38033_38203[(2)] = inst_37881);

(statearr_38033_38203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (81))){
var inst_37768 = (state_37886[(22)]);
var inst_37768__$1 = cljs.core.sequential_QMARK_(from);
var state_37886__$1 = (function (){var statearr_38034 = state_37886;
(statearr_38034[(22)] = inst_37768__$1);

return statearr_38034;
})();
if(inst_37768__$1){
var statearr_38035_38204 = state_37886__$1;
(statearr_38035_38204[(1)] = (91));

} else {
var statearr_38036_38205 = state_37886__$1;
(statearr_38036_38205[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (120))){
var state_37886__$1 = state_37886;
var statearr_38037_38206 = state_37886__$1;
(statearr_38037_38206[(2)] = null);

(statearr_38037_38206[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (79))){
var inst_37740 = (state_37886[(2)]);
var inst_37741 = fluree.db.util.async.throw_err(inst_37740);
var state_37886__$1 = state_37886;
var statearr_38038_38207 = state_37886__$1;
(statearr_38038_38207[(2)] = inst_37741);

(statearr_38038_38207[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (38))){
var state_37886__$1 = state_37886;
var statearr_38039_38208 = state_37886__$1;
(statearr_38039_38208[(2)] = null);

(statearr_38039_38208[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (126))){
var inst_37865 = (state_37886[(41)]);
var state_37886__$1 = state_37886;
var statearr_38040_38209 = state_37886__$1;
(statearr_38040_38209[(2)] = inst_37865);

(statearr_38040_38209[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (98))){
var inst_37579 = (state_37886[(18)]);
var inst_37822 = (state_37886[(2)]);
var inst_37823 = cljs.core.PersistentVector.EMPTY;
var inst_37824 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_37823,inst_37822);
var state_37886__$1 = (function (){var statearr_38041 = state_37886;
(statearr_38041[(35)] = inst_37824);

return statearr_38041;
})();
if(cljs.core.truth_(inst_37579)){
var statearr_38042_38210 = state_37886__$1;
(statearr_38042_38210[(1)] = (113));

} else {
var statearr_38043_38211 = state_37886__$1;
(statearr_38043_38211[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (124))){
var inst_37865 = (state_37886[(41)]);
var inst_37864 = (state_37886[(2)]);
var inst_37865__$1 = selectOne;
var state_37886__$1 = (function (){var statearr_38044 = state_37886;
(statearr_38044[(41)] = inst_37865__$1);

(statearr_38044[(11)] = inst_37864);

return statearr_38044;
})();
if(cljs.core.truth_(inst_37865__$1)){
var statearr_38045_38212 = state_37886__$1;
(statearr_38045_38212[(1)] = (125));

} else {
var statearr_38046_38213 = state_37886__$1;
(statearr_38046_38213[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (87))){
var inst_37760 = (state_37886[(2)]);
var inst_37761 = fluree.db.util.async.throw_err(inst_37760);
var state_37886__$1 = (function (){var statearr_38047 = state_37886;
(statearr_38047[(31)] = inst_37761);

return statearr_38047;
})();
if(cljs.core.truth_(fuel)){
var statearr_38048_38214 = state_37886__$1;
(statearr_38048_38214[(1)] = (88));

} else {
var statearr_38049_38215 = state_37886__$1;
(statearr_38049_38215[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (30))){
var inst_37629 = typeof from === 'string';
var state_37886__$1 = state_37886;
if(cljs.core.truth_(inst_37629)){
var statearr_38050_38216 = state_37886__$1;
(statearr_38050_38216[(1)] = (33));

} else {
var statearr_38051_38217 = state_37886__$1;
(statearr_38051_38217[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (73))){
var inst_37743 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_37886__$1 = state_37886;
if(inst_37743){
var statearr_38052_38218 = state_37886__$1;
(statearr_38052_38218[(1)] = (80));

} else {
var statearr_38053_38219 = state_37886__$1;
(statearr_38053_38219[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (96))){
var inst_37849 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
var statearr_38054_38220 = state_37886__$1;
(statearr_38054_38220[(2)] = inst_37849);

(statearr_38054_38220[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (10))){
var inst_37563 = (state_37886[(39)]);
var inst_37563__$1 = selectDistinct;
var state_37886__$1 = (function (){var statearr_38055 = state_37886;
(statearr_38055[(39)] = inst_37563__$1);

return statearr_38055;
})();
if(cljs.core.truth_(inst_37563__$1)){
var statearr_38056_38221 = state_37886__$1;
(statearr_38056_38221[(1)] = (12));

} else {
var statearr_38057_38222 = state_37886__$1;
(statearr_38057_38222[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (18))){
var inst_37579 = (state_37886[(18)]);
var inst_37594 = cljs.core.vector_QMARK_(inst_37579);
var state_37886__$1 = state_37886;
if(inst_37594){
var statearr_38058_38223 = state_37886__$1;
(statearr_38058_38223[(1)] = (21));

} else {
var statearr_38059_38224 = state_37886__$1;
(statearr_38059_38224[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (105))){
var inst_37803 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_37886__$1 = state_37886;
var statearr_38060_38225 = state_37886__$1;
(statearr_38060_38225[(2)] = inst_37803);

(statearr_38060_38225[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (52))){
var inst_37669 = (state_37886[(2)]);
var state_37886__$1 = (function (){var statearr_38061 = state_37886;
(statearr_38061[(21)] = inst_37669);

return statearr_38061;
})();
var statearr_38062_38226 = state_37886__$1;
(statearr_38062_38226[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (114))){
var inst_37580 = (state_37886[(14)]);
var state_37886__$1 = state_37886;
var statearr_38064_38227 = state_37886__$1;
(statearr_38064_38227[(2)] = inst_37580);

(statearr_38064_38227[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (67))){
var inst_37708 = cljs.core.PersistentHashMap.EMPTY;
var state_37886__$1 = state_37886;
var statearr_38065_38228 = state_37886__$1;
(statearr_38065_38228[(2)] = inst_37708);

(statearr_38065_38228[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (71))){
var inst_37721 = (state_37886[(2)]);
var inst_37722 = fluree.db.util.async.throw_err(inst_37721);
var state_37886__$1 = state_37886;
var statearr_38066_38229 = state_37886__$1;
(statearr_38066_38229[(2)] = inst_37722);

(statearr_38066_38229[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (42))){
var inst_37582 = (state_37886[(15)]);
var state_37886__$1 = state_37886;
var statearr_38067_38230 = state_37886__$1;
(statearr_38067_38230[(2)] = inst_37582);

(statearr_38067_38230[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (80))){
var inst_37746 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_37886__$1 = state_37886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37886__$1,(83),inst_37746);
} else {
if((state_val_37887 === (37))){
var inst_37651 = (state_37886[(2)]);
var inst_37652 = fluree.db.util.async.throw_err(inst_37651);
var state_37886__$1 = state_37886;
var statearr_38068_38231 = state_37886__$1;
(statearr_38068_38231[(2)] = inst_37652);

(statearr_38068_38231[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (63))){
var inst_37705 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
if(cljs.core.truth_(inst_37705)){
var statearr_38069_38232 = state_37886__$1;
(statearr_38069_38232[(1)] = (64));

} else {
var statearr_38070_38233 = state_37886__$1;
(statearr_38070_38233[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (94))){
var inst_37782 = from;
var inst_37783 = cljs.core.seq(inst_37782);
var inst_37784 = cljs.core.first(inst_37783);
var inst_37785 = cljs.core.next(inst_37783);
var inst_37786 = cljs.core.PersistentVector.EMPTY;
var inst_37787 = inst_37782;
var inst_37788 = inst_37786;
var state_37886__$1 = (function (){var statearr_38071 = state_37886;
(statearr_38071[(10)] = inst_37788);

(statearr_38071[(42)] = inst_37784);

(statearr_38071[(38)] = inst_37787);

(statearr_38071[(43)] = inst_37785);

return statearr_38071;
})();
var statearr_38072_38234 = state_37886__$1;
(statearr_38072_38234[(2)] = null);

(statearr_38072_38234[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (8))){
var inst_37581 = (state_37886[(25)]);
var inst_37576 = (state_37886[(2)]);
var inst_37577 = opts_SINGLEQUOTE_;
var inst_37578 = cljs.core.__destructure_map(inst_37577);
var inst_37579 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37578,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_37580 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37578,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_37581__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37578,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_37582 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37578,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_37583 = fluree.db.query.fql_parser.parse_db(db,inst_37576,opts_SINGLEQUOTE_);
var inst_37584 = (inst_37581__$1 == null);
var inst_37585 = cljs.core.not(inst_37584);
var state_37886__$1 = (function (){var statearr_38073 = state_37886;
(statearr_38073[(15)] = inst_37582);

(statearr_38073[(18)] = inst_37579);

(statearr_38073[(24)] = inst_37583);

(statearr_38073[(25)] = inst_37581__$1);

(statearr_38073[(14)] = inst_37580);

return statearr_38073;
})();
if(inst_37585){
var statearr_38074_38235 = state_37886__$1;
(statearr_38074_38235[(1)] = (15));

} else {
var statearr_38075_38236 = state_37886__$1;
(statearr_38075_38236[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (49))){
var inst_37857 = (state_37886[(2)]);
var state_37886__$1 = state_37886;
var statearr_38076_38237 = state_37886__$1;
(statearr_38076_38237[(2)] = inst_37857);

(statearr_38076_38237[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37887 === (84))){
var state_37886__$1 = state_37886;
var statearr_38077_38238 = state_37886__$1;
(statearr_38077_38238[(2)] = null);

(statearr_38077_38238[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__11438__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__11438__auto____0 = (function (){
var statearr_38078 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38078[(0)] = fluree$db$query$fql$query_$_state_machine__11438__auto__);

(statearr_38078[(1)] = (1));

return statearr_38078;
});
var fluree$db$query$fql$query_$_state_machine__11438__auto____1 = (function (state_37886){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_37886);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e38079){var ex__11441__auto__ = e38079;
var statearr_38080_38239 = state_37886;
(statearr_38080_38239[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_37886[(4)]))){
var statearr_38081_38240 = state_37886;
(statearr_38081_38240[(1)] = cljs.core.first((state_37886[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38241 = state_37886;
state_37886 = G__38241;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__11438__auto__ = function(state_37886){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__11438__auto____1.call(this,state_37886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__11438__auto____0;
fluree$db$query$fql$query_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__11438__auto____1;
return fluree$db$query$fql$query_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_38082 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_38082[(6)] = c__11512__auto__);

return statearr_38082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}

});
