// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__5045__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__25363 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25363,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25363,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25363,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25363,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25363,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25363,(5),null);
var G__25366 = idx;
var G__25366__$1 = (((G__25366 instanceof cljs.core.Keyword))?G__25366.fqn:null);
switch (G__25366__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25366__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__25368 = idx;
var G__25368__$1 = (((G__25368 instanceof cljs.core.Keyword))?G__25368.fqn:null);
switch (G__25368__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25368__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__25370 = idx;
var G__25370__$1 = (((G__25370 instanceof cljs.core.Keyword))?G__25370.fqn:null);
switch (G__25370__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25370__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__25373 = arguments.length;
switch (G__25373) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__25374 = (function (){var pred__25377 = cljs.core.identical_QMARK_;
var expr__25378 = test;
if(cljs.core.truth_((pred__25377.cljs$core$IFn$_invoke$arity$2 ? pred__25377.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__25378) : pred__25377.call(null,cljs.core._EQ_,expr__25378)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__25377.cljs$core$IFn$_invoke$arity$2 ? pred__25377.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__25378) : pred__25377.call(null,cljs.core._LT_,expr__25378)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__25377.cljs$core$IFn$_invoke$arity$2 ? pred__25377.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__25378) : pred__25377.call(null,cljs.core._LT__EQ_,expr__25378)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__25377.cljs$core$IFn$_invoke$arity$2 ? pred__25377.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__25378) : pred__25377.call(null,cljs.core._GT_,expr__25378)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__25377.cljs$core$IFn$_invoke$arity$2 ? pred__25377.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__25378) : pred__25377.call(null,cljs.core._GT__EQ_,expr__25378)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__25378)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25374,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25374,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25374,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25374,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_25617){
var state_val_25618 = (state_25617[(1)]);
if((state_val_25618 === (65))){
var inst_25532 = (state_25617[(7)]);
var inst_25588 = (state_25617[(8)]);
var inst_25588__$1 = (state_25617[(2)]);
var inst_25589 = cljs.core.count(inst_25588__$1);
var state_25617__$1 = (function (){var statearr_25619 = state_25617;
(statearr_25619[(8)] = inst_25588__$1);

(statearr_25619[(9)] = inst_25589);

return statearr_25619;
})();
if(cljs.core.truth_(inst_25532)){
var statearr_25620_25757 = state_25617__$1;
(statearr_25620_25757[(1)] = (81));

} else {
var statearr_25621_25758 = state_25617__$1;
(statearr_25621_25758[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (70))){
var inst_25563 = (state_25617[(2)]);
var state_25617__$1 = state_25617;
if(cljs.core.truth_(inst_25563)){
var statearr_25622_25759 = state_25617__$1;
(statearr_25622_25759[(1)] = (71));

} else {
var statearr_25623_25760 = state_25617__$1;
(statearr_25623_25760[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (62))){
var inst_25502 = (state_25617[(10)]);
var inst_25516 = (state_25617[(11)]);
var inst_25531 = (state_25617[(2)]);
var inst_25532 = fluree.db.dbproto._rhs(inst_25516);
var state_25617__$1 = (function (){var statearr_25624 = state_25617;
(statearr_25624[(7)] = inst_25532);

(statearr_25624[(12)] = inst_25531);

return statearr_25624;
})();
if(cljs.core.truth_(inst_25502)){
var statearr_25625_25761 = state_25617__$1;
(statearr_25625_25761[(1)] = (63));

} else {
var statearr_25626_25762 = state_25617__$1;
(statearr_25626_25762[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (74))){
var inst_25556 = (state_25617[(13)]);
var inst_25570 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_25556);
var state_25617__$1 = state_25617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25617__$1,(77),inst_25570);
} else {
if((state_val_25618 === (7))){
var inst_25393 = (state_25617[(14)]);
var state_25617__$1 = state_25617;
var statearr_25627_25763 = state_25617__$1;
(statearr_25627_25763[(2)] = inst_25393);

(statearr_25627_25763[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (59))){
var inst_25478 = (state_25617[(15)]);
var inst_25523 = (state_25617[(16)]);
var inst_25479 = (state_25617[(17)]);
var inst_25522 = (state_25617[(2)]);
var inst_25523__$1 = fluree.db.util.async.throw_err(inst_25522);
var inst_25524 = fluree.db.flake.subrange(inst_25523__$1,start_test,inst_25478,end_test,inst_25479);
var inst_25525 = fluree.db.query.range.value_with_nil_pred(idx,inst_25478,inst_25479);
var state_25617__$1 = (function (){var statearr_25628 = state_25617;
(statearr_25628[(16)] = inst_25523__$1);

(statearr_25628[(18)] = inst_25524);

return statearr_25628;
})();
if(inst_25525){
var statearr_25629_25764 = state_25617__$1;
(statearr_25629_25764[(1)] = (60));

} else {
var statearr_25630_25765 = state_25617__$1;
(statearr_25630_25765[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (86))){
var inst_25597 = (state_25617[(2)]);
var state_25617__$1 = state_25617;
var statearr_25631_25766 = state_25617__$1;
(statearr_25631_25766[(2)] = inst_25597);

(statearr_25631_25766[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (20))){
var inst_25394 = (state_25617[(19)]);
var inst_25442 = (state_25617[(20)]);
var inst_25441 = (state_25617[(2)]);
var inst_25442__$1 = (inst_25394 == null);
var state_25617__$1 = (function (){var statearr_25632 = state_25617;
(statearr_25632[(21)] = inst_25441);

(statearr_25632[(20)] = inst_25442__$1);

return statearr_25632;
})();
if(cljs.core.truth_(inst_25442__$1)){
var statearr_25633_25767 = state_25617__$1;
(statearr_25633_25767[(1)] = (22));

} else {
var statearr_25634_25768 = state_25617__$1;
(statearr_25634_25768[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (72))){
var inst_25549 = (state_25617[(22)]);
var inst_25567 = (inst_25549 + (1));
var inst_25568 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_25617__$1 = (function (){var statearr_25635 = state_25617;
(statearr_25635[(23)] = inst_25567);

return statearr_25635;
})();
if(cljs.core.truth_(inst_25568)){
var statearr_25636_25769 = state_25617__$1;
(statearr_25636_25769[(1)] = (74));

} else {
var statearr_25637_25770 = state_25617__$1;
(statearr_25637_25770[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (58))){
var inst_25612 = (state_25617[(2)]);
var _ = (function (){var statearr_25638 = state_25617;
(statearr_25638[(4)] = cljs.core.rest((state_25617[(4)])));

return statearr_25638;
})();
var state_25617__$1 = state_25617;
var statearr_25639_25771 = state_25617__$1;
(statearr_25639_25771[(2)] = inst_25612);

(statearr_25639_25771[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (60))){
var inst_25478 = (state_25617[(15)]);
var inst_25423 = (state_25617[(24)]);
var inst_25441 = (state_25617[(21)]);
var inst_25399 = (state_25617[(25)]);
var inst_25432 = (state_25617[(26)]);
var inst_25502 = (state_25617[(10)]);
var inst_25450 = (state_25617[(27)]);
var inst_25396 = (state_25617[(28)]);
var inst_25516 = (state_25617[(11)]);
var inst_25477 = (state_25617[(29)]);
var inst_25459 = (state_25617[(30)]);
var inst_25495 = (state_25617[(31)]);
var inst_25518 = (state_25617[(32)]);
var inst_25523 = (state_25617[(16)]);
var inst_25392 = (state_25617[(33)]);
var inst_25479 = (state_25617[(17)]);
var inst_25485 = (state_25617[(34)]);
var inst_25468 = (state_25617[(35)]);
var inst_25404 = (state_25617[(36)]);
var inst_25524 = (state_25617[(18)]);
var inst_25414 = (state_25617[(37)]);
var inst_25489 = (state_25617[(38)]);
var inst_25484 = (state_25617[(39)]);
var inst_25397 = (state_25617[(40)]);
var inst_25511 = (state_25617[(41)]);
var inst_25506 = (state_25617[(42)]);
var inst_25496 = (state_25617[(43)]);
var inst_25403 = (state_25617[(44)]);
var inst_25517 = (state_25617[(45)]);
var inst_25527 = (function (){var no_filter_QMARK_ = inst_25502;
var next_node = inst_25516;
var flakes = inst_25523;
var s1 = inst_25414;
var o2 = inst_25441;
var t1 = inst_25396;
var i = inst_25517;
var m1 = inst_25468;
var root_node = inst_25511;
var to_t = inst_25496;
var s2 = inst_25423;
var p2 = inst_25459;
var permissions = inst_25485;
var limit = inst_25484;
var start_flake = inst_25478;
var acc = inst_25518;
var t2 = inst_25403;
var op1 = inst_25397;
var vec__25389 = inst_25399;
var o1 = inst_25432;
var end_flake = inst_25479;
var base_result = inst_25524;
var p1 = inst_25450;
var idx_compare = inst_25489;
var op2 = inst_25404;
var from_t = inst_25495;
var m2 = inst_25477;
var vec__25386 = inst_25392;
var novelty = inst_25506;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_25528 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_25527,inst_25524,inst_25524);
var state_25617__$1 = state_25617;
var statearr_25640_25772 = state_25617__$1;
(statearr_25640_25772[(2)] = inst_25528);

(statearr_25640_25772[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (27))){
var inst_25451 = (state_25617[(46)]);
var inst_25401 = (state_25617[(47)]);
var inst_25450 = (state_25617[(2)]);
var inst_25451__$1 = (inst_25401 == null);
var state_25617__$1 = (function (){var statearr_25641 = state_25617;
(statearr_25641[(27)] = inst_25450);

(statearr_25641[(46)] = inst_25451__$1);

return statearr_25641;
})();
if(cljs.core.truth_(inst_25451__$1)){
var statearr_25642_25773 = state_25617__$1;
(statearr_25642_25773[(1)] = (28));

} else {
var statearr_25643_25774 = state_25617__$1;
(statearr_25643_25774[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (1))){
var state_25617__$1 = state_25617;
var statearr_25644_25775 = state_25617__$1;
(statearr_25644_25775[(2)] = null);

(statearr_25644_25775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (69))){
var inst_25549 = (state_25617[(22)]);
var inst_25484 = (state_25617[(39)]);
var inst_25561 = (inst_25549 > inst_25484);
var state_25617__$1 = state_25617;
var statearr_25645_25776 = state_25617__$1;
(statearr_25645_25776[(2)] = inst_25561);

(statearr_25645_25776[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (24))){
var inst_25446 = (state_25617[(2)]);
var state_25617__$1 = state_25617;
if(cljs.core.truth_(inst_25446)){
var statearr_25646_25777 = state_25617__$1;
(statearr_25646_25777[(1)] = (25));

} else {
var statearr_25647_25778 = state_25617__$1;
(statearr_25647_25778[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (55))){
var inst_25478 = (state_25617[(15)]);
var inst_25511 = (state_25617[(41)]);
var inst_25510 = (state_25617[(2)]);
var inst_25511__$1 = fluree.db.util.async.throw_err(inst_25510);
var inst_25512 = fluree.db.dbproto._lookup_leaf(inst_25511__$1,inst_25478);
var state_25617__$1 = (function (){var statearr_25648 = state_25617;
(statearr_25648[(41)] = inst_25511__$1);

return statearr_25648;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25617__$1,(56),inst_25512);
} else {
if((state_val_25618 === (85))){
var inst_25592 = (state_25617[(48)]);
var state_25617__$1 = state_25617;
var statearr_25649_25779 = state_25617__$1;
(statearr_25649_25779[(2)] = inst_25592);

(statearr_25649_25779[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (39))){
var inst_25466 = (state_25617[(2)]);
var state_25617__$1 = state_25617;
var statearr_25650_25780 = state_25617__$1;
(statearr_25650_25780[(2)] = inst_25466);

(statearr_25650_25780[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (88))){
var inst_25532 = (state_25617[(7)]);
var inst_25511 = (state_25617[(41)]);
var inst_25604 = fluree.db.dbproto._lookup_leaf(inst_25511,inst_25532);
var state_25617__$1 = state_25617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25617__$1,(90),inst_25604);
} else {
if((state_val_25618 === (46))){
var inst_25480 = (state_25617[(49)]);
var state_25617__$1 = state_25617;
var statearr_25651_25781 = state_25617__$1;
(statearr_25651_25781[(2)] = inst_25480);

(statearr_25651_25781[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (4))){
var inst_25380 = (state_25617[(2)]);
var state_25617__$1 = state_25617;
var statearr_25652_25782 = state_25617__$1;
(statearr_25652_25782[(2)] = inst_25380);

(statearr_25652_25782[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (77))){
var inst_25572 = (state_25617[(2)]);
var inst_25573 = fluree.db.util.async.throw_err(inst_25572);
var state_25617__$1 = state_25617;
if(cljs.core.truth_(inst_25573)){
var statearr_25653_25783 = state_25617__$1;
(statearr_25653_25783[(1)] = (78));

} else {
var statearr_25654_25784 = state_25617__$1;
(statearr_25654_25784[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (54))){
var inst_25502 = (state_25617[(2)]);
var inst_25503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25504 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_25505 = (new cljs.core.PersistentVector(null,2,(5),inst_25503,inst_25504,null));
var inst_25506 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_25505);
var inst_25507 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_25508 = fluree.db.dbproto._resolve(inst_25507);
var state_25617__$1 = (function (){var statearr_25655 = state_25617;
(statearr_25655[(10)] = inst_25502);

(statearr_25655[(42)] = inst_25506);

return statearr_25655;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25617__$1,(55),inst_25508);
} else {
if((state_val_25618 === (15))){
var inst_25395 = (state_25617[(50)]);
var state_25617__$1 = state_25617;
var statearr_25656_25785 = state_25617__$1;
(statearr_25656_25785[(2)] = inst_25395);

(statearr_25656_25785[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (48))){
var inst_25490 = (state_25617[(51)]);
var inst_25484 = (state_25617[(2)]);
var inst_25485 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_25486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25487 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_25488 = (new cljs.core.PersistentVector(null,3,(5),inst_25486,inst_25487,null));
var inst_25489 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_25488);
var inst_25490__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_25617__$1 = (function (){var statearr_25657 = state_25617;
(statearr_25657[(34)] = inst_25485);

(statearr_25657[(51)] = inst_25490__$1);

(statearr_25657[(38)] = inst_25489);

(statearr_25657[(39)] = inst_25484);

return statearr_25657;
})();
if(cljs.core.truth_(inst_25490__$1)){
var statearr_25658_25786 = state_25617__$1;
(statearr_25658_25786[(1)] = (49));

} else {
var statearr_25659_25787 = state_25617__$1;
(statearr_25659_25787[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (50))){
var inst_25493 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_25617__$1 = state_25617;
var statearr_25660_25788 = state_25617__$1;
(statearr_25660_25788[(2)] = inst_25493);

(statearr_25660_25788[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (75))){
var inst_25550 = (state_25617[(52)]);
var state_25617__$1 = state_25617;
var statearr_25661_25789 = state_25617__$1;
(statearr_25661_25789[(2)] = inst_25550);

(statearr_25661_25789[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (21))){
var inst_25437 = (state_25617[(2)]);
var inst_25438 = fluree.db.util.async.throw_err(inst_25437);
var state_25617__$1 = state_25617;
var statearr_25662_25790 = state_25617__$1;
(statearr_25662_25790[(2)] = inst_25438);

(statearr_25662_25790[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (31))){
var state_25617__$1 = state_25617;
var statearr_25663_25791 = state_25617__$1;
(statearr_25663_25791[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_25663_25791[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (32))){
var inst_25401 = (state_25617[(47)]);
var state_25617__$1 = state_25617;
var statearr_25664_25792 = state_25617__$1;
(statearr_25664_25792[(2)] = inst_25401);

(statearr_25664_25792[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (40))){
var inst_25405 = (state_25617[(53)]);
var state_25617__$1 = state_25617;
var statearr_25665_25793 = state_25617__$1;
(statearr_25665_25793[(2)] = inst_25405);

(statearr_25665_25793[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (56))){
var inst_25514 = (state_25617[(2)]);
var inst_25515 = fluree.db.util.async.throw_err(inst_25514);
var inst_25516 = inst_25515;
var inst_25517 = (0);
var inst_25518 = null;
var state_25617__$1 = (function (){var statearr_25666 = state_25617;
(statearr_25666[(11)] = inst_25516);

(statearr_25666[(32)] = inst_25518);

(statearr_25666[(45)] = inst_25517);

return statearr_25666;
})();
var statearr_25667_25794 = state_25617__$1;
(statearr_25667_25794[(2)] = null);

(statearr_25667_25794[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (33))){
var inst_25398 = (state_25617[(54)]);
var inst_25459 = (state_25617[(2)]);
var state_25617__$1 = (function (){var statearr_25668 = state_25617;
(statearr_25668[(30)] = inst_25459);

return statearr_25668;
})();
if(cljs.core.truth_(inst_25398)){
var statearr_25669_25795 = state_25617__$1;
(statearr_25669_25795[(1)] = (34));

} else {
var statearr_25670_25796 = state_25617__$1;
(statearr_25670_25796[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (13))){
var inst_25419 = (state_25617[(2)]);
var inst_25420 = fluree.db.util.async.throw_err(inst_25419);
var state_25617__$1 = state_25617;
var statearr_25671_25797 = state_25617__$1;
(statearr_25671_25797[(2)] = inst_25420);

(statearr_25671_25797[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (22))){
var inst_25432 = (state_25617[(26)]);
var state_25617__$1 = state_25617;
var statearr_25672_25798 = state_25617__$1;
(statearr_25672_25798[(2)] = inst_25432);

(statearr_25672_25798[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (90))){
var inst_25588 = (state_25617[(8)]);
var inst_25589 = (state_25617[(9)]);
var inst_25606 = (state_25617[(2)]);
var inst_25607 = fluree.db.util.async.throw_err(inst_25606);
var inst_25516 = inst_25607;
var inst_25517 = inst_25589;
var inst_25518 = inst_25588;
var state_25617__$1 = (function (){var statearr_25673 = state_25617;
(statearr_25673[(11)] = inst_25516);

(statearr_25673[(32)] = inst_25518);

(statearr_25673[(45)] = inst_25517);

return statearr_25673;
})();
var statearr_25674_25799 = state_25617__$1;
(statearr_25674_25799[(2)] = null);

(statearr_25674_25799[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (36))){
var inst_25405 = (state_25617[(53)]);
var inst_25468 = (state_25617[(2)]);
var state_25617__$1 = (function (){var statearr_25675 = state_25617;
(statearr_25675[(35)] = inst_25468);

return statearr_25675;
})();
if(cljs.core.truth_(inst_25405)){
var statearr_25676_25800 = state_25617__$1;
(statearr_25676_25800[(1)] = (40));

} else {
var statearr_25677_25801 = state_25617__$1;
(statearr_25677_25801[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (41))){
var inst_25471 = (cljs.core._LT__EQ_ === end_test);
var state_25617__$1 = state_25617;
if(cljs.core.truth_(inst_25471)){
var statearr_25678_25802 = state_25617__$1;
(statearr_25678_25802[(1)] = (43));

} else {
var statearr_25679_25803 = state_25617__$1;
(statearr_25679_25803[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (89))){
var inst_25610 = (state_25617[(2)]);
var state_25617__$1 = state_25617;
var statearr_25680_25804 = state_25617__$1;
(statearr_25680_25804[(2)] = inst_25610);

(statearr_25680_25804[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (43))){
var state_25617__$1 = state_25617;
var statearr_25681_25805 = state_25617__$1;
(statearr_25681_25805[(2)] = (2147483647));

(statearr_25681_25805[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (61))){
var inst_25524 = (state_25617[(18)]);
var state_25617__$1 = state_25617;
var statearr_25682_25806 = state_25617__$1;
(statearr_25682_25806[(2)] = inst_25524);

(statearr_25682_25806[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (29))){
var inst_25451 = (state_25617[(46)]);
var state_25617__$1 = state_25617;
var statearr_25683_25807 = state_25617__$1;
(statearr_25683_25807[(2)] = inst_25451);

(statearr_25683_25807[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (44))){
var state_25617__$1 = state_25617;
var statearr_25684_25808 = state_25617__$1;
(statearr_25684_25808[(2)] = fluree.db.util.core.min_integer);

(statearr_25684_25808[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (6))){
var inst_25393 = (state_25617[(14)]);
var inst_25408 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_25393);
var state_25617__$1 = state_25617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25617__$1,(9),inst_25408);
} else {
if((state_val_25618 === (28))){
var inst_25441 = (state_25617[(21)]);
var state_25617__$1 = state_25617;
var statearr_25685_25809 = state_25617__$1;
(statearr_25685_25809[(2)] = inst_25441);

(statearr_25685_25809[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (64))){
var inst_25531 = (state_25617[(12)]);
var inst_25517 = (state_25617[(45)]);
var inst_25545 = cljs.core.seq(inst_25531);
var inst_25546 = cljs.core.first(inst_25545);
var inst_25547 = cljs.core.next(inst_25545);
var inst_25548 = inst_25531;
var inst_25549 = inst_25517;
var inst_25550 = inst_25531;
var state_25617__$1 = (function (){var statearr_25686 = state_25617;
(statearr_25686[(55)] = inst_25546);

(statearr_25686[(52)] = inst_25550);

(statearr_25686[(22)] = inst_25549);

(statearr_25686[(56)] = inst_25548);

(statearr_25686[(57)] = inst_25547);

return statearr_25686;
})();
var statearr_25687_25810 = state_25617__$1;
(statearr_25687_25810[(2)] = null);

(statearr_25687_25810[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (51))){
var inst_25495 = (state_25617[(2)]);
var inst_25496 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_25497 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_25617__$1 = (function (){var statearr_25688 = state_25617;
(statearr_25688[(31)] = inst_25495);

(statearr_25688[(43)] = inst_25496);

return statearr_25688;
})();
if(cljs.core.truth_(inst_25497)){
var statearr_25689_25811 = state_25617__$1;
(statearr_25689_25811[(1)] = (52));

} else {
var statearr_25690_25812 = state_25617__$1;
(statearr_25690_25812[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (25))){
var state_25617__$1 = state_25617;
var statearr_25691_25813 = state_25617__$1;
(statearr_25691_25813[(2)] = (-1));

(statearr_25691_25813[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (34))){
var inst_25398 = (state_25617[(54)]);
var state_25617__$1 = state_25617;
var statearr_25692_25814 = state_25617__$1;
(statearr_25692_25814[(2)] = inst_25398);

(statearr_25692_25814[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (17))){
var inst_25428 = (state_25617[(2)]);
var inst_25429 = fluree.db.util.async.throw_err(inst_25428);
var state_25617__$1 = state_25617;
var statearr_25693_25815 = state_25617__$1;
(statearr_25693_25815[(2)] = inst_25429);

(statearr_25693_25815[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (3))){
var inst_25615 = (state_25617[(2)]);
var state_25617__$1 = state_25617;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25617__$1,inst_25615);
} else {
if((state_val_25618 === (12))){
var inst_25395 = (state_25617[(50)]);
var inst_25423 = (state_25617[(2)]);
var inst_25424 = fluree.db.util.core.pred_ident_QMARK_(inst_25395);
var state_25617__$1 = (function (){var statearr_25694 = state_25617;
(statearr_25694[(24)] = inst_25423);

return statearr_25694;
})();
if(inst_25424){
var statearr_25695_25816 = state_25617__$1;
(statearr_25695_25816[(1)] = (14));

} else {
var statearr_25696_25817 = state_25617__$1;
(statearr_25696_25817[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (2))){
var inst_25399 = (state_25617[(25)]);
var inst_25392 = (state_25617[(33)]);
var inst_25393 = (state_25617[(14)]);
var _ = (function (){var statearr_25697 = state_25617;
(statearr_25697[(4)] = cljs.core.cons((5),(state_25617[(4)])));

return statearr_25697;
})();
var inst_25392__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_25393__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25392__$1,(0),null);
var inst_25394 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25392__$1,(1),null);
var inst_25395 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25392__$1,(2),null);
var inst_25396 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25392__$1,(3),null);
var inst_25397 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25392__$1,(4),null);
var inst_25398 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25392__$1,(5),null);
var inst_25399__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_25400 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25399__$1,(0),null);
var inst_25401 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25399__$1,(1),null);
var inst_25402 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25399__$1,(2),null);
var inst_25403 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25399__$1,(3),null);
var inst_25404 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25399__$1,(4),null);
var inst_25405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25399__$1,(5),null);
var inst_25406 = fluree.db.util.core.pred_ident_QMARK_(inst_25393__$1);
var state_25617__$1 = (function (){var statearr_25698 = state_25617;
(statearr_25698[(25)] = inst_25399__$1);

(statearr_25698[(28)] = inst_25396);

(statearr_25698[(53)] = inst_25405);

(statearr_25698[(58)] = inst_25402);

(statearr_25698[(59)] = inst_25400);

(statearr_25698[(33)] = inst_25392__$1);

(statearr_25698[(19)] = inst_25394);

(statearr_25698[(36)] = inst_25404);

(statearr_25698[(40)] = inst_25397);

(statearr_25698[(54)] = inst_25398);

(statearr_25698[(50)] = inst_25395);

(statearr_25698[(14)] = inst_25393__$1);

(statearr_25698[(44)] = inst_25403);

(statearr_25698[(47)] = inst_25401);

return statearr_25698;
})();
if(inst_25406){
var statearr_25699_25818 = state_25617__$1;
(statearr_25699_25818[(1)] = (6));

} else {
var statearr_25700_25819 = state_25617__$1;
(statearr_25700_25819[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (66))){
var inst_25558 = (state_25617[(60)]);
var inst_25548 = (state_25617[(56)]);
var inst_25556 = (state_25617[(13)]);
var inst_25555 = cljs.core.seq(inst_25548);
var inst_25556__$1 = cljs.core.first(inst_25555);
var inst_25557 = cljs.core.next(inst_25555);
var inst_25558__$1 = (inst_25556__$1 == null);
var state_25617__$1 = (function (){var statearr_25701 = state_25617;
(statearr_25701[(60)] = inst_25558__$1);

(statearr_25701[(61)] = inst_25557);

(statearr_25701[(13)] = inst_25556__$1);

return statearr_25701;
})();
if(cljs.core.truth_(inst_25558__$1)){
var statearr_25702_25820 = state_25617__$1;
(statearr_25702_25820[(1)] = (68));

} else {
var statearr_25703_25821 = state_25617__$1;
(statearr_25703_25821[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (23))){
var inst_25442 = (state_25617[(20)]);
var state_25617__$1 = state_25617;
var statearr_25704_25822 = state_25617__$1;
(statearr_25704_25822[(2)] = inst_25442);

(statearr_25704_25822[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (47))){
var state_25617__$1 = state_25617;
var statearr_25705_25823 = state_25617__$1;
(statearr_25705_25823[(2)] = fluree.db.util.core.max_long);

(statearr_25705_25823[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (35))){
var inst_25462 = (cljs.core._GT__EQ_ === start_test);
var state_25617__$1 = state_25617;
if(cljs.core.truth_(inst_25462)){
var statearr_25706_25824 = state_25617__$1;
(statearr_25706_25824[(1)] = (37));

} else {
var statearr_25707_25825 = state_25617__$1;
(statearr_25707_25825[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (82))){
var inst_25532 = (state_25617[(7)]);
var state_25617__$1 = state_25617;
var statearr_25708_25826 = state_25617__$1;
(statearr_25708_25826[(2)] = inst_25532);

(statearr_25708_25826[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (76))){
var inst_25567 = (state_25617[(23)]);
var inst_25557 = (state_25617[(61)]);
var inst_25581 = (state_25617[(2)]);
var inst_25548 = inst_25557;
var inst_25549 = inst_25567;
var inst_25550 = inst_25581;
var state_25617__$1 = (function (){var statearr_25709 = state_25617;
(statearr_25709[(52)] = inst_25550);

(statearr_25709[(22)] = inst_25549);

(statearr_25709[(56)] = inst_25548);

return statearr_25709;
})();
var statearr_25710_25827 = state_25617__$1;
(statearr_25710_25827[(2)] = null);

(statearr_25710_25827[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (19))){
var inst_25402 = (state_25617[(58)]);
var state_25617__$1 = state_25617;
var statearr_25711_25828 = state_25617__$1;
(statearr_25711_25828[(2)] = inst_25402);

(statearr_25711_25828[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (57))){
var inst_25516 = (state_25617[(11)]);
var inst_25495 = (state_25617[(31)]);
var inst_25506 = (state_25617[(42)]);
var inst_25496 = (state_25617[(43)]);
var inst_25520 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_25516,inst_25495,inst_25496,inst_25506);
var state_25617__$1 = state_25617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25617__$1,(59),inst_25520);
} else {
if((state_val_25618 === (68))){
var inst_25558 = (state_25617[(60)]);
var state_25617__$1 = state_25617;
var statearr_25712_25829 = state_25617__$1;
(statearr_25712_25829[(2)] = inst_25558);

(statearr_25712_25829[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (11))){
var inst_25400 = (state_25617[(59)]);
var state_25617__$1 = state_25617;
var statearr_25714_25830 = state_25617__$1;
(statearr_25714_25830[(2)] = inst_25400);

(statearr_25714_25830[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (9))){
var inst_25410 = (state_25617[(2)]);
var inst_25411 = fluree.db.util.async.throw_err(inst_25410);
var state_25617__$1 = state_25617;
var statearr_25715_25831 = state_25617__$1;
(statearr_25715_25831[(2)] = inst_25411);

(statearr_25715_25831[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (5))){
var _ = (function (){var statearr_25716 = state_25617;
(statearr_25716[(4)] = cljs.core.rest((state_25617[(4)])));

return statearr_25716;
})();
var state_25617__$1 = state_25617;
var ex25713 = (state_25617__$1[(2)]);
var statearr_25717_25832 = state_25617__$1;
(statearr_25717_25832[(5)] = ex25713);


if((ex25713 instanceof Error)){
var statearr_25718_25833 = state_25617__$1;
(statearr_25718_25833[(1)] = (4));

(statearr_25718_25833[(5)] = null);

} else {
throw ex25713;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (83))){
var inst_25600 = (state_25617[(2)]);
var inst_25601 = cljs.core.not(inst_25600);
var state_25617__$1 = state_25617;
if(inst_25601){
var statearr_25719_25834 = state_25617__$1;
(statearr_25719_25834[(1)] = (87));

} else {
var statearr_25720_25835 = state_25617__$1;
(statearr_25720_25835[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (14))){
var inst_25395 = (state_25617[(50)]);
var inst_25426 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_25395);
var state_25617__$1 = state_25617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25617__$1,(17),inst_25426);
} else {
if((state_val_25618 === (45))){
var inst_25475 = (state_25617[(2)]);
var state_25617__$1 = state_25617;
var statearr_25721_25836 = state_25617__$1;
(statearr_25721_25836[(2)] = inst_25475);

(statearr_25721_25836[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (53))){
var state_25617__$1 = state_25617;
var statearr_25722_25837 = state_25617__$1;
(statearr_25722_25837[(2)] = true);

(statearr_25722_25837[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (78))){
var inst_25550 = (state_25617[(52)]);
var state_25617__$1 = state_25617;
var statearr_25723_25838 = state_25617__$1;
(statearr_25723_25838[(2)] = inst_25550);

(statearr_25723_25838[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (26))){
var inst_25394 = (state_25617[(19)]);
var state_25617__$1 = state_25617;
var statearr_25724_25839 = state_25617__$1;
(statearr_25724_25839[(2)] = inst_25394);

(statearr_25724_25839[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (16))){
var inst_25402 = (state_25617[(58)]);
var inst_25432 = (state_25617[(2)]);
var inst_25433 = fluree.db.util.core.pred_ident_QMARK_(inst_25402);
var state_25617__$1 = (function (){var statearr_25725 = state_25617;
(statearr_25725[(26)] = inst_25432);

return statearr_25725;
})();
if(inst_25433){
var statearr_25726_25840 = state_25617__$1;
(statearr_25726_25840[(1)] = (18));

} else {
var statearr_25727_25841 = state_25617__$1;
(statearr_25727_25841[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (81))){
var inst_25532 = (state_25617[(7)]);
var inst_25479 = (state_25617[(17)]);
var inst_25592 = (state_25617[(48)]);
var inst_25489 = (state_25617[(38)]);
var inst_25591 = (inst_25489.cljs$core$IFn$_invoke$arity$2 ? inst_25489.cljs$core$IFn$_invoke$arity$2(inst_25532,inst_25479) : inst_25489.call(null,inst_25532,inst_25479));
var inst_25592__$1 = (inst_25591 < (0));
var state_25617__$1 = (function (){var statearr_25728 = state_25617;
(statearr_25728[(48)] = inst_25592__$1);

return statearr_25728;
})();
if(cljs.core.truth_(inst_25592__$1)){
var statearr_25729_25842 = state_25617__$1;
(statearr_25729_25842[(1)] = (84));

} else {
var statearr_25730_25843 = state_25617__$1;
(statearr_25730_25843[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (79))){
var inst_25550 = (state_25617[(52)]);
var inst_25556 = (state_25617[(13)]);
var inst_25576 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_25550,inst_25556);
var state_25617__$1 = state_25617;
var statearr_25731_25844 = state_25617__$1;
(statearr_25731_25844[(2)] = inst_25576);

(statearr_25731_25844[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (38))){
var state_25617__$1 = state_25617;
var statearr_25732_25845 = state_25617__$1;
(statearr_25732_25845[(2)] = (2147483647));

(statearr_25732_25845[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (87))){
var inst_25588 = (state_25617[(8)]);
var state_25617__$1 = state_25617;
var statearr_25733_25846 = state_25617__$1;
(statearr_25733_25846[(2)] = inst_25588);

(statearr_25733_25846[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (30))){
var inst_25455 = (state_25617[(2)]);
var state_25617__$1 = state_25617;
if(cljs.core.truth_(inst_25455)){
var statearr_25734_25847 = state_25617__$1;
(statearr_25734_25847[(1)] = (31));

} else {
var statearr_25735_25848 = state_25617__$1;
(statearr_25735_25848[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (73))){
var inst_25584 = (state_25617[(2)]);
var state_25617__$1 = state_25617;
var statearr_25736_25849 = state_25617__$1;
(statearr_25736_25849[(2)] = inst_25584);

(statearr_25736_25849[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (10))){
var inst_25400 = (state_25617[(59)]);
var inst_25417 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_25400);
var state_25617__$1 = state_25617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25617__$1,(13),inst_25417);
} else {
if((state_val_25618 === (18))){
var inst_25402 = (state_25617[(58)]);
var inst_25435 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_25402);
var state_25617__$1 = state_25617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25617__$1,(21),inst_25435);
} else {
if((state_val_25618 === (52))){
var inst_25423 = (state_25617[(24)]);
var inst_25450 = (state_25617[(27)]);
var inst_25459 = (state_25617[(30)]);
var inst_25485 = (state_25617[(34)]);
var inst_25414 = (state_25617[(37)]);
var inst_25499 = fluree.db.permissions_validate.no_filter_QMARK_(inst_25485,inst_25414,inst_25423,inst_25450,inst_25459);
var state_25617__$1 = state_25617;
var statearr_25737_25850 = state_25617__$1;
(statearr_25737_25850[(2)] = inst_25499);

(statearr_25737_25850[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (67))){
var inst_25586 = (state_25617[(2)]);
var state_25617__$1 = state_25617;
var statearr_25738_25851 = state_25617__$1;
(statearr_25738_25851[(2)] = inst_25586);

(statearr_25738_25851[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (71))){
var inst_25550 = (state_25617[(52)]);
var inst_25518 = (state_25617[(32)]);
var inst_25565 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25550,inst_25518);
var state_25617__$1 = state_25617;
var statearr_25739_25852 = state_25617__$1;
(statearr_25739_25852[(2)] = inst_25565);

(statearr_25739_25852[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (42))){
var inst_25423 = (state_25617[(24)]);
var inst_25441 = (state_25617[(21)]);
var inst_25432 = (state_25617[(26)]);
var inst_25450 = (state_25617[(27)]);
var inst_25396 = (state_25617[(28)]);
var inst_25477 = (state_25617[(29)]);
var inst_25459 = (state_25617[(30)]);
var inst_25480 = (state_25617[(49)]);
var inst_25468 = (state_25617[(35)]);
var inst_25404 = (state_25617[(36)]);
var inst_25414 = (state_25617[(37)]);
var inst_25397 = (state_25617[(40)]);
var inst_25403 = (state_25617[(44)]);
var inst_25477__$1 = (state_25617[(2)]);
var inst_25478 = fluree.db.flake.__GT_Flake(inst_25414,inst_25450,inst_25432,inst_25396,inst_25397,inst_25468);
var inst_25479 = fluree.db.flake.__GT_Flake(inst_25423,inst_25459,inst_25441,inst_25403,inst_25404,inst_25477__$1);
var inst_25480__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_25617__$1 = (function (){var statearr_25740 = state_25617;
(statearr_25740[(15)] = inst_25478);

(statearr_25740[(29)] = inst_25477__$1);

(statearr_25740[(49)] = inst_25480__$1);

(statearr_25740[(17)] = inst_25479);

return statearr_25740;
})();
if(cljs.core.truth_(inst_25480__$1)){
var statearr_25741_25853 = state_25617__$1;
(statearr_25741_25853[(1)] = (46));

} else {
var statearr_25742_25854 = state_25617__$1;
(statearr_25742_25854[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (80))){
var inst_25578 = (state_25617[(2)]);
var state_25617__$1 = state_25617;
var statearr_25743_25855 = state_25617__$1;
(statearr_25743_25855[(2)] = inst_25578);

(statearr_25743_25855[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (37))){
var state_25617__$1 = state_25617;
var statearr_25744_25856 = state_25617__$1;
(statearr_25744_25856[(2)] = fluree.db.util.core.min_integer);

(statearr_25744_25856[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (63))){
var inst_25531 = (state_25617[(12)]);
var inst_25518 = (state_25617[(32)]);
var inst_25484 = (state_25617[(39)]);
var inst_25517 = (state_25617[(45)]);
var inst_25534 = (inst_25484 - inst_25517);
var inst_25535 = fluree.db.flake.take(inst_25534,inst_25531);
var inst_25536 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25535,inst_25518);
var state_25617__$1 = state_25617;
var statearr_25745_25857 = state_25617__$1;
(statearr_25745_25857[(2)] = inst_25536);

(statearr_25745_25857[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (8))){
var inst_25400 = (state_25617[(59)]);
var inst_25414 = (state_25617[(2)]);
var inst_25415 = fluree.db.util.core.pred_ident_QMARK_(inst_25400);
var state_25617__$1 = (function (){var statearr_25746 = state_25617;
(statearr_25746[(37)] = inst_25414);

return statearr_25746;
})();
if(inst_25415){
var statearr_25747_25858 = state_25617__$1;
(statearr_25747_25858[(1)] = (10));

} else {
var statearr_25748_25859 = state_25617__$1;
(statearr_25748_25859[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (49))){
var inst_25490 = (state_25617[(51)]);
var state_25617__$1 = state_25617;
var statearr_25749_25860 = state_25617__$1;
(statearr_25749_25860[(2)] = inst_25490);

(statearr_25749_25860[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25618 === (84))){
var inst_25484 = (state_25617[(39)]);
var inst_25589 = (state_25617[(9)]);
var inst_25594 = (inst_25589 < inst_25484);
var state_25617__$1 = state_25617;
var statearr_25750_25861 = state_25617__$1;
(statearr_25750_25861[(2)] = inst_25594);

(statearr_25750_25861[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__11438__auto__ = null;
var fluree$db$query$range$state_machine__11438__auto____0 = (function (){
var statearr_25751 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25751[(0)] = fluree$db$query$range$state_machine__11438__auto__);

(statearr_25751[(1)] = (1));

return statearr_25751;
});
var fluree$db$query$range$state_machine__11438__auto____1 = (function (state_25617){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_25617);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e25752){var ex__11441__auto__ = e25752;
var statearr_25753_25862 = state_25617;
(statearr_25753_25862[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_25617[(4)]))){
var statearr_25754_25863 = state_25617;
(statearr_25754_25863[(1)] = cljs.core.first((state_25617[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25864 = state_25617;
state_25617 = G__25864;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__11438__auto__ = function(state_25617){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__11438__auto____1.call(this,state_25617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__11438__auto____0;
fluree$db$query$range$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__11438__auto____1;
return fluree$db$query$range$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_25755 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_25755[(6)] = c__11512__auto__);

return statearr_25755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_25939){
var state_val_25940 = (state_25939[(1)]);
if((state_val_25940 === (7))){
var inst_25934 = (state_25939[(2)]);
var _ = (function (){var statearr_25941 = state_25939;
(statearr_25941[(4)] = cljs.core.rest((state_25939[(4)])));

return statearr_25941;
})();
var state_25939__$1 = state_25939;
var statearr_25942_25982 = state_25939__$1;
(statearr_25942_25982[(2)] = inst_25934);

(statearr_25942_25982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (20))){
var inst_25916 = (state_25939[(2)]);
var inst_25917 = fluree.db.util.async.throw_err(inst_25916);
var state_25939__$1 = state_25939;
var statearr_25943_25983 = state_25939__$1;
(statearr_25943_25983[(2)] = inst_25917);

(statearr_25943_25983[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (1))){
var state_25939__$1 = state_25939;
var statearr_25944_25984 = state_25939__$1;
(statearr_25944_25984[(2)] = null);

(statearr_25944_25984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (4))){
var inst_25865 = (state_25939[(2)]);
var state_25939__$1 = state_25939;
var statearr_25945_25985 = state_25939__$1;
(statearr_25945_25985[(2)] = inst_25865);

(statearr_25945_25985[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (15))){
var inst_25912 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_25939__$1 = state_25939;
if(cljs.core.truth_(inst_25912)){
var statearr_25946_25986 = state_25939__$1;
(statearr_25946_25986[(1)] = (17));

} else {
var statearr_25947_25987 = state_25939__$1;
(statearr_25947_25987[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (21))){
var state_25939__$1 = state_25939;
var statearr_25948_25988 = state_25939__$1;
(statearr_25948_25988[(2)] = (0));

(statearr_25948_25988[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (13))){
var inst_25904 = (state_25939[(2)]);
var state_25939__$1 = state_25939;
var statearr_25949_25989 = state_25939__$1;
(statearr_25949_25989[(2)] = inst_25904);

(statearr_25949_25989[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (22))){
var state_25939__$1 = state_25939;
var statearr_25950_25990 = state_25939__$1;
(statearr_25950_25990[(2)] = (1));

(statearr_25950_25990[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (6))){
var inst_25885 = (state_25939[(7)]);
var inst_25894 = (state_25939[(8)]);
var inst_25896 = (state_25939[(9)]);
var inst_25893 = cljs.core.seq(inst_25885);
var inst_25894__$1 = cljs.core.first(inst_25893);
var inst_25895 = cljs.core.next(inst_25893);
var inst_25896__$1 = (inst_25894__$1 == null);
var state_25939__$1 = (function (){var statearr_25951 = state_25939;
(statearr_25951[(8)] = inst_25894__$1);

(statearr_25951[(9)] = inst_25896__$1);

(statearr_25951[(10)] = inst_25895);

return statearr_25951;
})();
if(cljs.core.truth_(inst_25896__$1)){
var statearr_25952_25991 = state_25939__$1;
(statearr_25952_25991[(1)] = (8));

} else {
var statearr_25953_25992 = state_25939__$1;
(statearr_25953_25992[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (17))){
var inst_25894 = (state_25939[(8)]);
var inst_25914 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_25894);
var state_25939__$1 = state_25939;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25939__$1,(20),inst_25914);
} else {
if((state_val_25940 === (3))){
var inst_25937 = (state_25939[(2)]);
var state_25939__$1 = state_25939;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25939__$1,inst_25937);
} else {
if((state_val_25940 === (12))){
var inst_25887 = (state_25939[(11)]);
var inst_25902 = (inst_25887 >= subject_limit);
var state_25939__$1 = state_25939;
var statearr_25954_25993 = state_25939__$1;
(statearr_25954_25993[(2)] = inst_25902);

(statearr_25954_25993[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (2))){
var _ = (function (){var statearr_25955 = state_25939;
(statearr_25955[(4)] = cljs.core.cons((5),(state_25939[(4)])));

return statearr_25955;
})();
var inst_25878 = subject_groups;
var inst_25879 = cljs.core.seq(inst_25878);
var inst_25880 = cljs.core.first(inst_25879);
var inst_25881 = cljs.core.next(inst_25879);
var inst_25882 = flake_start;
var inst_25883 = subject_start;
var inst_25884 = cljs.core.PersistentVector.EMPTY;
var inst_25885 = inst_25878;
var inst_25886 = inst_25882;
var inst_25887 = inst_25883;
var inst_25888 = inst_25884;
var state_25939__$1 = (function (){var statearr_25956 = state_25939;
(statearr_25956[(11)] = inst_25887);

(statearr_25956[(12)] = inst_25886);

(statearr_25956[(7)] = inst_25885);

(statearr_25956[(13)] = inst_25880);

(statearr_25956[(14)] = inst_25881);

(statearr_25956[(15)] = inst_25888);

return statearr_25956;
})();
var statearr_25957_25994 = state_25939__$1;
(statearr_25957_25994[(2)] = null);

(statearr_25957_25994[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (23))){
var inst_25887 = (state_25939[(11)]);
var inst_25886 = (state_25939[(12)]);
var inst_25920 = (state_25939[(16)]);
var inst_25921 = (state_25939[(17)]);
var inst_25895 = (state_25939[(10)]);
var inst_25888 = (state_25939[(15)]);
var inst_25926 = (state_25939[(2)]);
var inst_25927 = (inst_25886 + inst_25921);
var inst_25928 = (inst_25887 + inst_25926);
var inst_25929 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25888,inst_25920);
var inst_25885 = inst_25895;
var inst_25886__$1 = inst_25927;
var inst_25887__$1 = inst_25928;
var inst_25888__$1 = inst_25929;
var state_25939__$1 = (function (){var statearr_25958 = state_25939;
(statearr_25958[(11)] = inst_25887__$1);

(statearr_25958[(12)] = inst_25886__$1);

(statearr_25958[(7)] = inst_25885);

(statearr_25958[(15)] = inst_25888__$1);

return statearr_25958;
})();
var statearr_25959_25995 = state_25939__$1;
(statearr_25959_25995[(2)] = null);

(statearr_25959_25995[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (19))){
var inst_25920 = (state_25939[(16)]);
var inst_25921 = (state_25939[(17)]);
var inst_25920__$1 = (state_25939[(2)]);
var inst_25921__$1 = cljs.core.count(inst_25920__$1);
var inst_25922 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_25921__$1);
var state_25939__$1 = (function (){var statearr_25960 = state_25939;
(statearr_25960[(16)] = inst_25920__$1);

(statearr_25960[(17)] = inst_25921__$1);

return statearr_25960;
})();
if(inst_25922){
var statearr_25961_25996 = state_25939__$1;
(statearr_25961_25996[(1)] = (21));

} else {
var statearr_25962_25997 = state_25939__$1;
(statearr_25962_25997[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (11))){
var inst_25899 = (state_25939[(18)]);
var state_25939__$1 = state_25939;
var statearr_25964_25998 = state_25939__$1;
(statearr_25964_25998[(2)] = inst_25899);

(statearr_25964_25998[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (9))){
var inst_25886 = (state_25939[(12)]);
var inst_25899 = (state_25939[(18)]);
var inst_25899__$1 = (inst_25886 >= flake_limit);
var state_25939__$1 = (function (){var statearr_25965 = state_25939;
(statearr_25965[(18)] = inst_25899__$1);

return statearr_25965;
})();
if(cljs.core.truth_(inst_25899__$1)){
var statearr_25966_25999 = state_25939__$1;
(statearr_25966_25999[(1)] = (11));

} else {
var statearr_25967_26000 = state_25939__$1;
(statearr_25967_26000[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (5))){
var _ = (function (){var statearr_25968 = state_25939;
(statearr_25968[(4)] = cljs.core.rest((state_25939[(4)])));

return statearr_25968;
})();
var state_25939__$1 = state_25939;
var ex25963 = (state_25939__$1[(2)]);
var statearr_25969_26001 = state_25939__$1;
(statearr_25969_26001[(5)] = ex25963);


if((ex25963 instanceof Error)){
var statearr_25970_26002 = state_25939__$1;
(statearr_25970_26002[(1)] = (4));

(statearr_25970_26002[(5)] = null);

} else {
throw ex25963;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (14))){
var inst_25887 = (state_25939[(11)]);
var inst_25886 = (state_25939[(12)]);
var inst_25888 = (state_25939[(15)]);
var inst_25908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25909 = [inst_25886,inst_25887,inst_25888];
var inst_25910 = (new cljs.core.PersistentVector(null,3,(5),inst_25908,inst_25909,null));
var state_25939__$1 = state_25939;
var statearr_25971_26003 = state_25939__$1;
(statearr_25971_26003[(2)] = inst_25910);

(statearr_25971_26003[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (16))){
var inst_25932 = (state_25939[(2)]);
var state_25939__$1 = state_25939;
var statearr_25972_26004 = state_25939__$1;
(statearr_25972_26004[(2)] = inst_25932);

(statearr_25972_26004[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (10))){
var inst_25906 = (state_25939[(2)]);
var state_25939__$1 = state_25939;
if(cljs.core.truth_(inst_25906)){
var statearr_25973_26005 = state_25939__$1;
(statearr_25973_26005[(1)] = (14));

} else {
var statearr_25974_26006 = state_25939__$1;
(statearr_25974_26006[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (18))){
var inst_25894 = (state_25939[(8)]);
var state_25939__$1 = state_25939;
var statearr_25975_26007 = state_25939__$1;
(statearr_25975_26007[(2)] = inst_25894);

(statearr_25975_26007[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (8))){
var inst_25896 = (state_25939[(9)]);
var state_25939__$1 = state_25939;
var statearr_25976_26008 = state_25939__$1;
(statearr_25976_26008[(2)] = inst_25896);

(statearr_25976_26008[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11438__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11438__auto____0 = (function (){
var statearr_25977 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25977[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11438__auto__);

(statearr_25977[(1)] = (1));

return statearr_25977;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11438__auto____1 = (function (state_25939){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_25939);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e25978){var ex__11441__auto__ = e25978;
var statearr_25979_26009 = state_25939;
(statearr_25979_26009[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_25939[(4)]))){
var statearr_25980_26010 = state_25939;
(statearr_25980_26010[(1)] = cljs.core.first((state_25939[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26011 = state_25939;
state_25939 = G__26011;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11438__auto__ = function(state_25939){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11438__auto____1.call(this,state_25939);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11438__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11438__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_25981 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_25981[(6)] = c__11512__auto__);

return statearr_25981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_26057){
var state_val_26058 = (state_26057[(1)]);
if((state_val_26058 === (7))){
var state_26057__$1 = state_26057;
var statearr_26059_26097 = state_26057__$1;
(statearr_26059_26097[(2)] = null);

(statearr_26059_26097[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26058 === (20))){
var inst_26043 = (state_26057[(2)]);
var inst_26044 = fluree.db.util.async.throw_err(inst_26043);
var inst_26022 = inst_26044;
var state_26057__$1 = (function (){var statearr_26060 = state_26057;
(statearr_26060[(7)] = inst_26022);

return statearr_26060;
})();
var statearr_26061_26098 = state_26057__$1;
(statearr_26061_26098[(2)] = null);

(statearr_26061_26098[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26058 === (1))){
var state_26057__$1 = state_26057;
var statearr_26062_26099 = state_26057__$1;
(statearr_26062_26099[(2)] = null);

(statearr_26062_26099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26058 === (4))){
var inst_26012 = (state_26057[(2)]);
var state_26057__$1 = state_26057;
var statearr_26063_26100 = state_26057__$1;
(statearr_26063_26100[(2)] = inst_26012);

(statearr_26063_26100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26058 === (15))){
var inst_26022 = (state_26057[(7)]);
var inst_26039 = (state_26057[(8)]);
var inst_26039__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_26022);
var state_26057__$1 = (function (){var statearr_26064 = state_26057;
(statearr_26064[(8)] = inst_26039__$1);

return statearr_26064;
})();
if(cljs.core.truth_(inst_26039__$1)){
var statearr_26065_26101 = state_26057__$1;
(statearr_26065_26101[(1)] = (17));

} else {
var statearr_26066_26102 = state_26057__$1;
(statearr_26066_26102[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26058 === (13))){
var inst_26032 = (state_26057[(2)]);
var inst_26033 = fluree.db.util.async.throw_err(inst_26032);
var _ = (function (){var statearr_26067 = state_26057;
(statearr_26067[(4)] = cljs.core.rest((state_26057[(4)])));

return statearr_26067;
})();
var state_26057__$1 = state_26057;
var statearr_26068_26103 = state_26057__$1;
(statearr_26068_26103[(2)] = inst_26033);

(statearr_26068_26103[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26058 === (6))){
var inst_26020 = (state_26057[(2)]);
var inst_26021 = fluree.db.util.async.throw_err(inst_26020);
var inst_26022 = inst_26021;
var state_26057__$1 = (function (){var statearr_26069 = state_26057;
(statearr_26069[(7)] = inst_26022);

return statearr_26069;
})();
var statearr_26070_26104 = state_26057__$1;
(statearr_26070_26104[(2)] = null);

(statearr_26070_26104[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26058 === (17))){
var inst_26039 = (state_26057[(8)]);
var inst_26041 = fluree.db.dbproto._lookup_leaf(root_node,inst_26039);
var state_26057__$1 = state_26057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26057__$1,(20),inst_26041);
} else {
if((state_val_26058 === (3))){
var inst_26055 = (state_26057[(2)]);
var state_26057__$1 = state_26057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26057__$1,inst_26055);
} else {
if((state_val_26058 === (12))){
var _ = (function (){var statearr_26072 = state_26057;
(statearr_26072[(4)] = cljs.core.rest((state_26057[(4)])));

return statearr_26072;
})();
var state_26057__$1 = state_26057;
var ex26071 = (state_26057__$1[(2)]);
var statearr_26073_26105 = state_26057__$1;
(statearr_26073_26105[(5)] = ex26071);


var statearr_26074_26106 = state_26057__$1;
(statearr_26074_26106[(1)] = (11));

(statearr_26074_26106[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26058 === (2))){
var _ = (function (){var statearr_26075 = state_26057;
(statearr_26075[(4)] = cljs.core.cons((5),(state_26057[(4)])));

return statearr_26075;
})();
var inst_26018 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_26057__$1 = state_26057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26057__$1,(6),inst_26018);
} else {
if((state_val_26058 === (19))){
var inst_26048 = (state_26057[(2)]);
var state_26057__$1 = state_26057;
var statearr_26076_26107 = state_26057__$1;
(statearr_26076_26107[(2)] = inst_26048);

(statearr_26076_26107[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26058 === (11))){
var inst_26024 = (state_26057[(2)]);
var state_26057__$1 = (function (){var statearr_26078 = state_26057;
(statearr_26078[(9)] = inst_26024);

return statearr_26078;
})();
var statearr_26079_26108 = state_26057__$1;
(statearr_26079_26108[(2)] = null);

(statearr_26079_26108[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26058 === (9))){
var inst_26022 = (state_26057[(7)]);
var _ = (function (){var statearr_26080 = state_26057;
(statearr_26080[(4)] = cljs.core.cons((12),(state_26057[(4)])));

return statearr_26080;
})();
var inst_26030 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_26022,t,novelty,fast_forward_db_QMARK_);
var state_26057__$1 = state_26057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26057__$1,(13),inst_26030);
} else {
if((state_val_26058 === (5))){
var _ = (function (){var statearr_26081 = state_26057;
(statearr_26081[(4)] = cljs.core.rest((state_26057[(4)])));

return statearr_26081;
})();
var state_26057__$1 = state_26057;
var ex26077 = (state_26057__$1[(2)]);
var statearr_26082_26109 = state_26057__$1;
(statearr_26082_26109[(5)] = ex26077);


if((ex26077 instanceof Error)){
var statearr_26083_26110 = state_26057__$1;
(statearr_26083_26110[(1)] = (4));

(statearr_26083_26110[(5)] = null);

} else {
throw ex26077;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26058 === (14))){
var inst_26036 = (state_26057[(10)]);
var state_26057__$1 = state_26057;
var statearr_26084_26111 = state_26057__$1;
(statearr_26084_26111[(2)] = inst_26036);

(statearr_26084_26111[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26058 === (16))){
var inst_26050 = (state_26057[(2)]);
var state_26057__$1 = state_26057;
var statearr_26085_26112 = state_26057__$1;
(statearr_26085_26112[(2)] = inst_26050);

(statearr_26085_26112[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26058 === (10))){
var inst_26036 = (state_26057[(10)]);
var inst_26036__$1 = (state_26057[(2)]);
var state_26057__$1 = (function (){var statearr_26086 = state_26057;
(statearr_26086[(10)] = inst_26036__$1);

return statearr_26086;
})();
if(cljs.core.truth_(inst_26036__$1)){
var statearr_26087_26113 = state_26057__$1;
(statearr_26087_26113[(1)] = (14));

} else {
var statearr_26088_26114 = state_26057__$1;
(statearr_26088_26114[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26058 === (18))){
var state_26057__$1 = state_26057;
var statearr_26089_26115 = state_26057__$1;
(statearr_26089_26115[(2)] = null);

(statearr_26089_26115[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26058 === (8))){
var inst_26052 = (state_26057[(2)]);
var _ = (function (){var statearr_26090 = state_26057;
(statearr_26090[(4)] = cljs.core.rest((state_26057[(4)])));

return statearr_26090;
})();
var state_26057__$1 = state_26057;
var statearr_26091_26116 = state_26057__$1;
(statearr_26091_26116[(2)] = inst_26052);

(statearr_26091_26116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__11438__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__11438__auto____0 = (function (){
var statearr_26092 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26092[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__11438__auto__);

(statearr_26092[(1)] = (1));

return statearr_26092;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__11438__auto____1 = (function (state_26057){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_26057);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e26093){var ex__11441__auto__ = e26093;
var statearr_26094_26117 = state_26057;
(statearr_26094_26117[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_26057[(4)]))){
var statearr_26095_26118 = state_26057;
(statearr_26095_26118[(1)] = cljs.core.first((state_26057[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26119 = state_26057;
state_26057 = G__26119;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__11438__auto__ = function(state_26057){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__11438__auto____1.call(this,state_26057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__11438__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__11438__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_26096 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_26096[(6)] = c__11512__auto__);

return statearr_26096;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__26126 = arguments.length;
switch (G__26126) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__26127 = (function (){var pred__26130 = cljs.core.identical_QMARK_;
var expr__26131 = test;
if(cljs.core.truth_((pred__26130.cljs$core$IFn$_invoke$arity$2 ? pred__26130.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__26131) : pred__26130.call(null,cljs.core._EQ_,expr__26131)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__26130.cljs$core$IFn$_invoke$arity$2 ? pred__26130.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__26131) : pred__26130.call(null,cljs.core._LT_,expr__26131)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__26130.cljs$core$IFn$_invoke$arity$2 ? pred__26130.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__26131) : pred__26130.call(null,cljs.core._LT__EQ_,expr__26131)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__26130.cljs$core$IFn$_invoke$arity$2 ? pred__26130.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__26131) : pred__26130.call(null,cljs.core._GT_,expr__26131)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__26130.cljs$core$IFn$_invoke$arity$2 ? pred__26130.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__26131) : pred__26130.call(null,cljs.core._GT__EQ_,expr__26131)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__26131)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26127,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26127,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26127,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26127,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_26503){
var state_val_26504 = (state_26503[(1)]);
if((state_val_26504 === (121))){
var inst_26459 = (state_26503[(7)]);
var state_26503__$1 = state_26503;
var statearr_26505_26701 = state_26503__$1;
(statearr_26505_26701[(2)] = inst_26459);

(statearr_26505_26701[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (65))){
var inst_26311 = (state_26503[(8)]);
var inst_26317 = (state_26503[(2)]);
var state_26503__$1 = (function (){var statearr_26506 = state_26503;
(statearr_26506[(9)] = inst_26317);

return statearr_26506;
})();
if(cljs.core.truth_(inst_26311)){
var statearr_26507_26702 = state_26503__$1;
(statearr_26507_26702[(1)] = (66));

} else {
var statearr_26508_26703 = state_26503__$1;
(statearr_26508_26703[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (70))){
var inst_26495 = (state_26503[(2)]);
var state_26503__$1 = state_26503;
var statearr_26509_26704 = state_26503__$1;
(statearr_26509_26704[(2)] = inst_26495);

(statearr_26509_26704[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (62))){
var inst_26310 = (state_26503[(2)]);
var inst_26311 = fluree.db.util.async.throw_err(inst_26310);
var inst_26312 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_26503__$1 = (function (){var statearr_26510 = state_26503;
(statearr_26510[(8)] = inst_26311);

return statearr_26510;
})();
if(cljs.core.truth_(inst_26312)){
var statearr_26511_26705 = state_26503__$1;
(statearr_26511_26705[(1)] = (63));

} else {
var statearr_26512_26706 = state_26503__$1;
(statearr_26512_26706[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (74))){
var inst_26301 = (state_26503[(10)]);
var inst_26180 = (state_26503[(11)]);
var inst_26168 = (state_26503[(12)]);
var inst_26323 = (state_26503[(13)]);
var inst_26283 = (state_26503[(14)]);
var inst_26164 = (state_26503[(15)]);
var inst_26234 = (state_26503[(16)]);
var inst_26322 = (state_26503[(17)]);
var inst_26160 = (state_26503[(18)]);
var inst_26270 = (state_26503[(19)]);
var inst_26279 = (state_26503[(20)]);
var inst_26252 = (state_26503[(21)]);
var inst_26324 = (state_26503[(22)]);
var inst_26311 = (state_26503[(8)]);
var inst_26157 = (state_26503[(23)]);
var inst_26296 = (state_26503[(24)]);
var inst_26169 = (state_26503[(25)]);
var inst_26158 = (state_26503[(26)]);
var inst_26261 = (state_26503[(27)]);
var inst_26153 = (state_26503[(28)]);
var inst_26307 = (state_26503[(29)]);
var inst_26189 = (state_26503[(30)]);
var inst_26281 = (state_26503[(31)]);
var inst_26317 = (state_26503[(9)]);
var inst_26292 = (state_26503[(32)]);
var inst_26330 = (state_26503[(33)]);
var inst_26225 = (state_26503[(34)]);
var inst_26243 = (state_26503[(35)]);
var inst_26290 = (state_26503[(36)]);
var inst_26165 = (state_26503[(37)]);
var inst_26280 = (state_26503[(38)]);
var inst_26302 = (state_26503[(39)]);
var inst_26291 = (state_26503[(40)]);
var inst_26170 = (state_26503[(41)]);
var inst_26320 = (state_26503[(42)]);
var inst_26284 = (state_26503[(43)]);
var inst_26222 = (state_26503[(44)]);
var inst_26321 = (state_26503[(45)]);
var inst_26297 = (state_26503[(46)]);
var inst_26221 = (state_26503[(47)]);
var inst_26338 = (state_26503[(48)]);
var inst_26340 = (function (){var no_filter_QMARK_ = inst_26317;
var t = inst_26297;
var max_limit_QMARK_ = inst_26291;
var next_node = inst_26320;
var fast_forward_db_QMARK_ = inst_26302;
var s1 = inst_26180;
var o2 = inst_26243;
var t1 = inst_26157;
var predicate_fn = inst_26170;
var i = inst_26322;
var m1 = inst_26270;
var root_node = inst_26307;
var s2 = inst_26189;
var p2 = inst_26261;
var permissions = inst_26292;
var vec__26142 = inst_26160;
var limit = inst_26290;
var start_flake = inst_26280;
var flake_limit = inst_26284;
var vec__26146 = inst_26221;
var offset = inst_26321;
var acc = inst_26324;
var vec__26139 = inst_26153;
var t2 = inst_26164;
var op1 = inst_26158;
var o1 = inst_26234;
var end_flake = inst_26281;
var base_result = inst_26330;
var G__26331 = inst_26338;
var s = inst_26323;
var node_start = inst_26311;
var p1 = inst_26252;
var subject_fn = inst_26169;
var vec__26149 = inst_26222;
var object_fn = inst_26225;
var map__26152 = inst_26283;
var map__26145 = inst_26168;
var idx_compare = inst_26296;
var op2 = inst_26165;
var m2 = inst_26279;
var novelty = inst_26301;
return (function (p1__26121_SHARP_){
var G__26513 = p1__26121_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__26513) : subject_fn.call(null,G__26513));
});
})();
var inst_26341 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_26340,inst_26338);
var state_26503__$1 = state_26503;
var statearr_26514_26707 = state_26503__$1;
(statearr_26514_26707[(2)] = inst_26341);

(statearr_26514_26707[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (110))){
var inst_26472 = (state_26503[(2)]);
var state_26503__$1 = state_26503;
var statearr_26515_26708 = state_26503__$1;
(statearr_26515_26708[(2)] = inst_26472);

(statearr_26515_26708[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (7))){
var inst_26154 = (state_26503[(49)]);
var state_26503__$1 = state_26503;
var statearr_26516_26709 = state_26503__$1;
(statearr_26516_26709[(2)] = inst_26154);

(statearr_26516_26709[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (59))){
var state_26503__$1 = state_26503;
var statearr_26517_26710 = state_26503__$1;
(statearr_26517_26710[(2)] = fluree.db.util.core.max_long);

(statearr_26517_26710[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (86))){
var inst_26317 = (state_26503[(9)]);
var state_26503__$1 = state_26503;
var statearr_26518_26711 = state_26503__$1;
(statearr_26518_26711[(2)] = inst_26317);

(statearr_26518_26711[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (20))){
var state_26503__$1 = state_26503;
var statearr_26519_26712 = state_26503__$1;
(statearr_26519_26712[(2)] = null);

(statearr_26519_26712[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (72))){
var inst_26330 = (state_26503[(33)]);
var state_26503__$1 = state_26503;
var statearr_26520_26713 = state_26503__$1;
(statearr_26520_26713[(2)] = inst_26330);

(statearr_26520_26713[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (58))){
var inst_26285 = (state_26503[(50)]);
var state_26503__$1 = state_26503;
var statearr_26521_26714 = state_26503__$1;
(statearr_26521_26714[(2)] = inst_26285);

(statearr_26521_26714[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (60))){
var inst_26290 = (state_26503[(36)]);
var inst_26290__$1 = (state_26503[(2)]);
var inst_26291 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_26290__$1,fluree.db.util.core.max_long);
var inst_26292 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_26293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26294 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_26295 = (new cljs.core.PersistentVector(null,3,(5),inst_26293,inst_26294,null));
var inst_26296 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_26295);
var inst_26297 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26299 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_26300 = (new cljs.core.PersistentVector(null,2,(5),inst_26298,inst_26299,null));
var inst_26301 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_26300);
var inst_26302 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_26303 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_26304 = fluree.db.dbproto._resolve(inst_26303);
var state_26503__$1 = (function (){var statearr_26522 = state_26503;
(statearr_26522[(10)] = inst_26301);

(statearr_26522[(24)] = inst_26296);

(statearr_26522[(32)] = inst_26292);

(statearr_26522[(36)] = inst_26290__$1);

(statearr_26522[(39)] = inst_26302);

(statearr_26522[(40)] = inst_26291);

(statearr_26522[(46)] = inst_26297);

return statearr_26522;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26503__$1,(61),inst_26304);
} else {
if((state_val_26504 === (27))){
var inst_26223 = (state_26503[(51)]);
var state_26503__$1 = state_26503;
var statearr_26523_26715 = state_26503__$1;
(statearr_26523_26715[(2)] = inst_26223);

(statearr_26523_26715[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (1))){
var state_26503__$1 = state_26503;
var statearr_26524_26716 = state_26503__$1;
(statearr_26524_26716[(2)] = null);

(statearr_26524_26716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (69))){
var inst_26281 = (state_26503[(31)]);
var inst_26280 = (state_26503[(38)]);
var inst_26320 = (state_26503[(42)]);
var inst_26329 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_26320);
var inst_26330 = fluree.db.flake.subrange(inst_26329,start_test,inst_26280,end_test,inst_26281);
var inst_26332 = fluree.db.query.range.value_with_nil_pred(idx,inst_26280,inst_26281);
var state_26503__$1 = (function (){var statearr_26525 = state_26503;
(statearr_26525[(33)] = inst_26330);

return statearr_26525;
})();
if(inst_26332){
var statearr_26526_26717 = state_26503__$1;
(statearr_26526_26717[(1)] = (71));

} else {
var statearr_26527_26718 = state_26503__$1;
(statearr_26527_26718[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (101))){
var inst_26418 = (state_26503[(52)]);
var inst_26416 = (state_26503[(53)]);
var inst_26284 = (state_26503[(43)]);
var inst_26417 = (state_26503[(54)]);
var inst_26421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26422 = (inst_26418 - inst_26284);
var inst_26423 = (inst_26417 - inst_26422);
var inst_26424 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_26423,inst_26416);
var inst_26425 = [inst_26284,inst_26424];
var inst_26426 = (new cljs.core.PersistentVector(null,2,(5),inst_26421,inst_26425,null));
var state_26503__$1 = state_26503;
var statearr_26528_26719 = state_26503__$1;
(statearr_26528_26719[(2)] = inst_26426);

(statearr_26528_26719[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (24))){
var inst_26180 = (state_26503[(11)]);
var inst_26168 = (state_26503[(12)]);
var inst_26162 = (state_26503[(55)]);
var inst_26164 = (state_26503[(15)]);
var inst_26166 = (state_26503[(56)]);
var inst_26160 = (state_26503[(18)]);
var inst_26157 = (state_26503[(23)]);
var inst_26169 = (state_26503[(25)]);
var inst_26158 = (state_26503[(26)]);
var inst_26153 = (state_26503[(28)]);
var inst_26189 = (state_26503[(30)]);
var inst_26155 = (state_26503[(57)]);
var inst_26171 = (state_26503[(58)]);
var inst_26165 = (state_26503[(37)]);
var inst_26159 = (state_26503[(59)]);
var inst_26170 = (state_26503[(41)]);
var inst_26163 = (state_26503[(60)]);
var inst_26156 = (state_26503[(61)]);
var inst_26203 = (state_26503[(62)]);
var inst_26213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26215 = [null,null];
var inst_26216 = (new cljs.core.PersistentVector(null,2,(5),inst_26214,inst_26215,null));
var inst_26217 = (function (){var bool = inst_26203;
var s1 = inst_26180;
var o2 = inst_26163;
var t1 = inst_26157;
var predicate_fn = inst_26170;
var m1 = inst_26159;
var s2 = inst_26189;
var p2 = inst_26162;
var vec__26142 = inst_26160;
var vec__26139 = inst_26153;
var t2 = inst_26164;
var op1 = inst_26158;
var o1 = inst_26156;
var p1 = inst_26155;
var subject_fn = inst_26169;
var temp__5806__auto__ = inst_26203;
var object_fn = inst_26171;
var map__26145 = inst_26168;
var op2 = inst_26165;
var m2 = inst_26166;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_26218 = [inst_26216,inst_26217];
var inst_26219 = (new cljs.core.PersistentVector(null,2,(5),inst_26213,inst_26218,null));
var state_26503__$1 = state_26503;
var statearr_26529_26720 = state_26503__$1;
(statearr_26529_26720[(2)] = inst_26219);

(statearr_26529_26720[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (102))){
var inst_26418 = (state_26503[(52)]);
var inst_26416 = (state_26503[(53)]);
var inst_26428 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26429 = [inst_26418,inst_26416];
var inst_26430 = (new cljs.core.PersistentVector(null,2,(5),inst_26428,inst_26429,null));
var state_26503__$1 = state_26503;
var statearr_26530_26721 = state_26503__$1;
(statearr_26530_26721[(2)] = inst_26430);

(statearr_26530_26721[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (55))){
var state_26503__$1 = state_26503;
var statearr_26531_26722 = state_26503__$1;
(statearr_26531_26722[(2)] = (2147483647));

(statearr_26531_26722[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (85))){
var inst_26366 = (state_26503[(2)]);
var state_26503__$1 = state_26503;
if(cljs.core.truth_(inst_26366)){
var statearr_26532_26723 = state_26503__$1;
(statearr_26532_26723[(1)] = (89));

} else {
var statearr_26533_26724 = state_26503__$1;
(statearr_26533_26724[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (39))){
var inst_26162 = (state_26503[(55)]);
var inst_26253 = (state_26503[(63)]);
var inst_26252 = (state_26503[(2)]);
var inst_26253__$1 = (inst_26162 == null);
var state_26503__$1 = (function (){var statearr_26534 = state_26503;
(statearr_26534[(21)] = inst_26252);

(statearr_26534[(63)] = inst_26253__$1);

return statearr_26534;
})();
if(cljs.core.truth_(inst_26253__$1)){
var statearr_26535_26725 = state_26503__$1;
(statearr_26535_26725[(1)] = (40));

} else {
var statearr_26536_26726 = state_26503__$1;
(statearr_26536_26726[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (88))){
var inst_26363 = (state_26503[(2)]);
var state_26503__$1 = state_26503;
var statearr_26537_26727 = state_26503__$1;
(statearr_26537_26727[(2)] = inst_26363);

(statearr_26537_26727[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (46))){
var inst_26159 = (state_26503[(59)]);
var state_26503__$1 = state_26503;
var statearr_26538_26728 = state_26503__$1;
(statearr_26538_26728[(2)] = inst_26159);

(statearr_26538_26728[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (4))){
var inst_26133 = (state_26503[(2)]);
var state_26503__$1 = state_26503;
var statearr_26539_26729 = state_26503__$1;
(statearr_26539_26729[(2)] = inst_26133);

(statearr_26539_26729[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (77))){
var inst_26301 = (state_26503[(10)]);
var inst_26180 = (state_26503[(11)]);
var inst_26168 = (state_26503[(12)]);
var inst_26323 = (state_26503[(13)]);
var inst_26283 = (state_26503[(14)]);
var inst_26164 = (state_26503[(15)]);
var inst_26234 = (state_26503[(16)]);
var inst_26322 = (state_26503[(17)]);
var inst_26160 = (state_26503[(18)]);
var inst_26270 = (state_26503[(19)]);
var inst_26279 = (state_26503[(20)]);
var inst_26252 = (state_26503[(21)]);
var inst_26344 = (state_26503[(64)]);
var inst_26324 = (state_26503[(22)]);
var inst_26311 = (state_26503[(8)]);
var inst_26157 = (state_26503[(23)]);
var inst_26296 = (state_26503[(24)]);
var inst_26169 = (state_26503[(25)]);
var inst_26158 = (state_26503[(26)]);
var inst_26261 = (state_26503[(27)]);
var inst_26153 = (state_26503[(28)]);
var inst_26307 = (state_26503[(29)]);
var inst_26189 = (state_26503[(30)]);
var inst_26281 = (state_26503[(31)]);
var inst_26317 = (state_26503[(9)]);
var inst_26292 = (state_26503[(32)]);
var inst_26330 = (state_26503[(33)]);
var inst_26225 = (state_26503[(34)]);
var inst_26243 = (state_26503[(35)]);
var inst_26290 = (state_26503[(36)]);
var inst_26165 = (state_26503[(37)]);
var inst_26280 = (state_26503[(38)]);
var inst_26302 = (state_26503[(39)]);
var inst_26291 = (state_26503[(40)]);
var inst_26170 = (state_26503[(41)]);
var inst_26320 = (state_26503[(42)]);
var inst_26284 = (state_26503[(43)]);
var inst_26222 = (state_26503[(44)]);
var inst_26321 = (state_26503[(45)]);
var inst_26297 = (state_26503[(46)]);
var inst_26221 = (state_26503[(47)]);
var inst_26346 = (function (){var no_filter_QMARK_ = inst_26317;
var t = inst_26297;
var max_limit_QMARK_ = inst_26291;
var next_node = inst_26320;
var fast_forward_db_QMARK_ = inst_26302;
var s1 = inst_26180;
var o2 = inst_26243;
var t1 = inst_26157;
var predicate_fn = inst_26170;
var i = inst_26322;
var m1 = inst_26270;
var root_node = inst_26307;
var s2 = inst_26189;
var p2 = inst_26261;
var permissions = inst_26292;
var vec__26142 = inst_26160;
var limit = inst_26290;
var start_flake = inst_26280;
var flake_limit = inst_26284;
var vec__26146 = inst_26221;
var offset = inst_26321;
var acc = inst_26324;
var vec__26139 = inst_26153;
var t2 = inst_26164;
var op1 = inst_26158;
var o1 = inst_26234;
var end_flake = inst_26281;
var base_result = inst_26330;
var G__26331 = inst_26344;
var s = inst_26323;
var node_start = inst_26311;
var p1 = inst_26252;
var subject_fn = inst_26169;
var vec__26149 = inst_26222;
var object_fn = inst_26225;
var map__26152 = inst_26283;
var map__26145 = inst_26168;
var idx_compare = inst_26296;
var op2 = inst_26165;
var m2 = inst_26279;
var novelty = inst_26301;
return (function (p1__26122_SHARP_){
var G__26540 = p1__26122_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__26540) : predicate_fn.call(null,G__26540));
});
})();
var inst_26347 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_26346,inst_26344);
var state_26503__$1 = state_26503;
var statearr_26541_26730 = state_26503__$1;
(statearr_26541_26730[(2)] = inst_26347);

(statearr_26541_26730[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (106))){
var inst_26357 = (state_26503[(65)]);
var state_26503__$1 = state_26503;
var statearr_26542_26731 = state_26503__$1;
(statearr_26542_26731[(2)] = inst_26357);

(statearr_26542_26731[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (119))){
var inst_26475 = (state_26503[(66)]);
var state_26503__$1 = state_26503;
var statearr_26543_26732 = state_26503__$1;
(statearr_26543_26732[(2)] = inst_26475);

(statearr_26543_26732[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (95))){
var inst_26390 = (state_26503[(67)]);
var inst_26323 = (state_26503[(13)]);
var inst_26398 = (state_26503[(68)]);
var inst_26400 = (state_26503[(69)]);
var inst_26399 = (state_26503[(70)]);
var inst_26290 = (state_26503[(36)]);
var inst_26398__$1 = cljs.core.count(inst_26390);
var inst_26399__$1 = (inst_26323 + inst_26398__$1);
var inst_26400__$1 = (inst_26399__$1 - inst_26290);
var inst_26401 = cljs.core.pos_int_QMARK_(inst_26400__$1);
var state_26503__$1 = (function (){var statearr_26544 = state_26503;
(statearr_26544[(68)] = inst_26398__$1);

(statearr_26544[(69)] = inst_26400__$1);

(statearr_26544[(70)] = inst_26399__$1);

return statearr_26544;
})();
if(inst_26401){
var statearr_26545_26733 = state_26503__$1;
(statearr_26545_26733[(1)] = (98));

} else {
var statearr_26546_26734 = state_26503__$1;
(statearr_26546_26734[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (54))){
var inst_26180 = (state_26503[(11)]);
var inst_26283 = (state_26503[(14)]);
var inst_26164 = (state_26503[(15)]);
var inst_26234 = (state_26503[(16)]);
var inst_26270 = (state_26503[(19)]);
var inst_26279 = (state_26503[(20)]);
var inst_26252 = (state_26503[(21)]);
var inst_26157 = (state_26503[(23)]);
var inst_26285 = (state_26503[(50)]);
var inst_26158 = (state_26503[(26)]);
var inst_26261 = (state_26503[(27)]);
var inst_26189 = (state_26503[(30)]);
var inst_26243 = (state_26503[(35)]);
var inst_26165 = (state_26503[(37)]);
var inst_26279__$1 = (state_26503[(2)]);
var inst_26280 = fluree.db.flake.__GT_Flake(inst_26180,inst_26252,inst_26234,inst_26157,inst_26158,inst_26270);
var inst_26281 = fluree.db.flake.__GT_Flake(inst_26189,inst_26261,inst_26243,inst_26164,inst_26165,inst_26279__$1);
var inst_26282 = opts;
var inst_26283__$1 = cljs.core.__destructure_map(inst_26282);
var inst_26284 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_26283__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_26285__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26283__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_26286 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_26283__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_26503__$1 = (function (){var statearr_26547 = state_26503;
(statearr_26547[(14)] = inst_26283__$1);

(statearr_26547[(20)] = inst_26279__$1);

(statearr_26547[(71)] = inst_26286);

(statearr_26547[(50)] = inst_26285__$1);

(statearr_26547[(31)] = inst_26281);

(statearr_26547[(38)] = inst_26280);

(statearr_26547[(43)] = inst_26284);

return statearr_26547;
})();
if(cljs.core.truth_(inst_26285__$1)){
var statearr_26548_26735 = state_26503__$1;
(statearr_26548_26735[(1)] = (58));

} else {
var statearr_26549_26736 = state_26503__$1;
(statearr_26549_26736[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (92))){
var inst_26323 = (state_26503[(13)]);
var inst_26379 = (state_26503[(72)]);
var inst_26322 = (state_26503[(17)]);
var inst_26324 = (state_26503[(22)]);
var inst_26321 = (state_26503[(45)]);
var inst_26382 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26383 = (inst_26321 - inst_26379);
var inst_26384 = [inst_26383,inst_26322,inst_26323,inst_26324];
var inst_26385 = (new cljs.core.PersistentVector(null,4,(5),inst_26382,inst_26384,null));
var state_26503__$1 = state_26503;
var statearr_26550_26737 = state_26503__$1;
(statearr_26550_26737[(2)] = inst_26385);

(statearr_26550_26737[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (104))){
var inst_26441 = (state_26503[(2)]);
var inst_26442 = fluree.db.util.async.throw_err(inst_26441);
var state_26503__$1 = state_26503;
var statearr_26551_26738 = state_26503__$1;
(statearr_26551_26738[(2)] = inst_26442);

(statearr_26551_26738[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (15))){
var inst_26163 = (state_26503[(60)]);
var inst_26193 = cljs.core.boolean_QMARK_(inst_26163);
var state_26503__$1 = state_26503;
if(inst_26193){
var statearr_26552_26739 = state_26503__$1;
(statearr_26552_26739[(1)] = (17));

} else {
var statearr_26553_26740 = state_26503__$1;
(statearr_26553_26740[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (48))){
var inst_26166 = (state_26503[(56)]);
var inst_26270 = (state_26503[(2)]);
var state_26503__$1 = (function (){var statearr_26554 = state_26503;
(statearr_26554[(19)] = inst_26270);

return statearr_26554;
})();
if(cljs.core.truth_(inst_26166)){
var statearr_26555_26741 = state_26503__$1;
(statearr_26555_26741[(1)] = (52));

} else {
var statearr_26556_26742 = state_26503__$1;
(statearr_26556_26742[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (50))){
var state_26503__$1 = state_26503;
var statearr_26557_26743 = state_26503__$1;
(statearr_26557_26743[(2)] = (2147483647));

(statearr_26557_26743[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (116))){
var inst_26475 = (state_26503[(66)]);
var inst_26483 = (state_26503[(2)]);
var state_26503__$1 = (function (){var statearr_26558 = state_26503;
(statearr_26558[(73)] = inst_26483);

return statearr_26558;
})();
if(cljs.core.truth_(inst_26475)){
var statearr_26559_26744 = state_26503__$1;
(statearr_26559_26744[(1)] = (118));

} else {
var statearr_26560_26745 = state_26503__$1;
(statearr_26560_26745[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (75))){
var inst_26338 = (state_26503[(48)]);
var state_26503__$1 = state_26503;
var statearr_26561_26746 = state_26503__$1;
(statearr_26561_26746[(2)] = inst_26338);

(statearr_26561_26746[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (99))){
var inst_26399 = (state_26503[(70)]);
var inst_26408 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26409 = [inst_26399,inst_26399];
var inst_26410 = (new cljs.core.PersistentVector(null,2,(5),inst_26408,inst_26409,null));
var state_26503__$1 = state_26503;
var statearr_26562_26747 = state_26503__$1;
(statearr_26562_26747[(2)] = inst_26410);

(statearr_26562_26747[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (21))){
var state_26503__$1 = state_26503;
var statearr_26563_26748 = state_26503__$1;
(statearr_26563_26748[(2)] = null);

(statearr_26563_26748[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (31))){
var inst_26224 = (state_26503[(74)]);
var state_26503__$1 = state_26503;
var statearr_26564_26749 = state_26503__$1;
(statearr_26564_26749[(2)] = inst_26224);

(statearr_26564_26749[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (113))){
var inst_26469 = (state_26503[(2)]);
var state_26503__$1 = state_26503;
var statearr_26565_26750 = state_26503__$1;
(statearr_26565_26750[(2)] = inst_26469);

(statearr_26565_26750[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (32))){
var inst_26244 = (state_26503[(75)]);
var inst_26155 = (state_26503[(57)]);
var inst_26243 = (state_26503[(2)]);
var inst_26244__$1 = (inst_26155 == null);
var state_26503__$1 = (function (){var statearr_26566 = state_26503;
(statearr_26566[(75)] = inst_26244__$1);

(statearr_26566[(35)] = inst_26243);

return statearr_26566;
})();
if(cljs.core.truth_(inst_26244__$1)){
var statearr_26567_26751 = state_26503__$1;
(statearr_26567_26751[(1)] = (34));

} else {
var statearr_26568_26752 = state_26503__$1;
(statearr_26568_26752[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (40))){
var inst_26243 = (state_26503[(35)]);
var state_26503__$1 = state_26503;
var statearr_26569_26753 = state_26503__$1;
(statearr_26569_26753[(2)] = inst_26243);

(statearr_26569_26753[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (91))){
var inst_26357 = (state_26503[(65)]);
var inst_26455 = (state_26503[(2)]);
var inst_26456 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26455,(0),null);
var inst_26457 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26455,(1),null);
var inst_26458 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26455,(2),null);
var inst_26459 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26455,(3),null);
var state_26503__$1 = (function (){var statearr_26570 = state_26503;
(statearr_26570[(76)] = inst_26457);

(statearr_26570[(77)] = inst_26458);

(statearr_26570[(7)] = inst_26459);

(statearr_26570[(78)] = inst_26456);

return statearr_26570;
})();
if(cljs.core.truth_(inst_26357)){
var statearr_26571_26754 = state_26503__$1;
(statearr_26571_26754[(1)] = (105));

} else {
var statearr_26572_26755 = state_26503__$1;
(statearr_26572_26755[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (117))){
var inst_26479 = (state_26503[(2)]);
var inst_26480 = fluree.db.util.async.throw_err(inst_26479);
var state_26503__$1 = state_26503;
var statearr_26573_26756 = state_26503__$1;
(statearr_26573_26756[(2)] = inst_26480);

(statearr_26573_26756[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (108))){
var inst_26464 = (state_26503[(79)]);
var inst_26457 = (state_26503[(76)]);
var inst_26284 = (state_26503[(43)]);
var inst_26464__$1 = (inst_26457 < inst_26284);
var state_26503__$1 = (function (){var statearr_26574 = state_26503;
(statearr_26574[(79)] = inst_26464__$1);

return statearr_26574;
})();
if(cljs.core.truth_(inst_26464__$1)){
var statearr_26575_26757 = state_26503__$1;
(statearr_26575_26757[(1)] = (111));

} else {
var statearr_26576_26758 = state_26503__$1;
(statearr_26576_26758[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (56))){
var state_26503__$1 = state_26503;
var statearr_26577_26759 = state_26503__$1;
(statearr_26577_26759[(2)] = fluree.db.util.core.min_integer);

(statearr_26577_26759[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (33))){
var inst_26239 = (state_26503[(2)]);
var inst_26240 = fluree.db.util.async.throw_err(inst_26239);
var state_26503__$1 = state_26503;
var statearr_26578_26760 = state_26503__$1;
(statearr_26578_26760[(2)] = inst_26240);

(statearr_26578_26760[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (13))){
var inst_26185 = (state_26503[(2)]);
var inst_26186 = fluree.db.util.async.throw_err(inst_26185);
var state_26503__$1 = state_26503;
var statearr_26579_26761 = state_26503__$1;
(statearr_26579_26761[(2)] = inst_26186);

(statearr_26579_26761[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (22))){
var inst_26199 = (state_26503[(2)]);
var state_26503__$1 = state_26503;
var statearr_26580_26762 = state_26503__$1;
(statearr_26580_26762[(2)] = inst_26199);

(statearr_26580_26762[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (90))){
var inst_26301 = (state_26503[(10)]);
var inst_26180 = (state_26503[(11)]);
var inst_26168 = (state_26503[(12)]);
var inst_26323 = (state_26503[(13)]);
var inst_26283 = (state_26503[(14)]);
var inst_26379 = (state_26503[(72)]);
var inst_26378 = (state_26503[(80)]);
var inst_26164 = (state_26503[(15)]);
var inst_26234 = (state_26503[(16)]);
var inst_26322 = (state_26503[(17)]);
var inst_26357 = (state_26503[(65)]);
var inst_26160 = (state_26503[(18)]);
var inst_26270 = (state_26503[(19)]);
var inst_26279 = (state_26503[(20)]);
var inst_26252 = (state_26503[(21)]);
var inst_26324 = (state_26503[(22)]);
var inst_26311 = (state_26503[(8)]);
var inst_26157 = (state_26503[(23)]);
var inst_26296 = (state_26503[(24)]);
var inst_26169 = (state_26503[(25)]);
var inst_26158 = (state_26503[(26)]);
var inst_26261 = (state_26503[(27)]);
var inst_26153 = (state_26503[(28)]);
var inst_26307 = (state_26503[(29)]);
var inst_26189 = (state_26503[(30)]);
var inst_26281 = (state_26503[(31)]);
var inst_26317 = (state_26503[(9)]);
var inst_26292 = (state_26503[(32)]);
var inst_26330 = (state_26503[(33)]);
var inst_26356 = (state_26503[(81)]);
var inst_26225 = (state_26503[(34)]);
var inst_26243 = (state_26503[(35)]);
var inst_26290 = (state_26503[(36)]);
var inst_26165 = (state_26503[(37)]);
var inst_26280 = (state_26503[(38)]);
var inst_26302 = (state_26503[(39)]);
var inst_26291 = (state_26503[(40)]);
var inst_26170 = (state_26503[(41)]);
var inst_26320 = (state_26503[(42)]);
var inst_26284 = (state_26503[(43)]);
var inst_26222 = (state_26503[(44)]);
var inst_26321 = (state_26503[(45)]);
var inst_26297 = (state_26503[(46)]);
var inst_26221 = (state_26503[(47)]);
var inst_26377 = (function (){var no_filter_QMARK_ = inst_26317;
var base_result_SINGLEQUOTE_ = inst_26356;
var t = inst_26297;
var max_limit_QMARK_ = inst_26291;
var next_node = inst_26320;
var fast_forward_db_QMARK_ = inst_26302;
var s1 = inst_26180;
var o2 = inst_26243;
var t1 = inst_26157;
var predicate_fn = inst_26170;
var i = inst_26322;
var rhs = inst_26357;
var m1 = inst_26270;
var root_node = inst_26307;
var s2 = inst_26189;
var p2 = inst_26261;
var permissions = inst_26292;
var vec__26142 = inst_26160;
var limit = inst_26290;
var start_flake = inst_26280;
var flake_limit = inst_26284;
var vec__26146 = inst_26221;
var offset = inst_26321;
var acc = inst_26324;
var vec__26139 = inst_26153;
var t2 = inst_26164;
var op1 = inst_26158;
var o1 = inst_26234;
var end_flake = inst_26281;
var base_result = inst_26330;
var s = inst_26323;
var node_start = inst_26311;
var p1 = inst_26252;
var subject_fn = inst_26169;
var vec__26149 = inst_26222;
var object_fn = inst_26225;
var map__26152 = inst_26283;
var map__26145 = inst_26168;
var idx_compare = inst_26296;
var op2 = inst_26165;
var m2 = inst_26279;
var novelty = inst_26301;
return (function (p1__26124_SHARP_){
return p1__26124_SHARP_.s;
});
})();
var inst_26378__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_26377,inst_26356);
var inst_26379__$1 = cljs.core.count(inst_26378__$1);
var inst_26380 = (inst_26321 > inst_26379__$1);
var state_26503__$1 = (function (){var statearr_26581 = state_26503;
(statearr_26581[(72)] = inst_26379__$1);

(statearr_26581[(80)] = inst_26378__$1);

return statearr_26581;
})();
if(cljs.core.truth_(inst_26380)){
var statearr_26582_26763 = state_26503__$1;
(statearr_26582_26763[(1)] = (92));

} else {
var statearr_26583_26764 = state_26503__$1;
(statearr_26583_26764[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (109))){
var inst_26462 = (state_26503[(82)]);
var state_26503__$1 = state_26503;
var statearr_26584_26765 = state_26503__$1;
(statearr_26584_26765[(2)] = inst_26462);

(statearr_26584_26765[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (36))){
var inst_26248 = (state_26503[(2)]);
var state_26503__$1 = state_26503;
if(cljs.core.truth_(inst_26248)){
var statearr_26585_26766 = state_26503__$1;
(statearr_26585_26766[(1)] = (37));

} else {
var statearr_26586_26767 = state_26503__$1;
(statearr_26586_26767[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (41))){
var inst_26253 = (state_26503[(63)]);
var state_26503__$1 = state_26503;
var statearr_26587_26768 = state_26503__$1;
(statearr_26587_26768[(2)] = inst_26253);

(statearr_26587_26768[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (118))){
var inst_26483 = (state_26503[(73)]);
var state_26503__$1 = state_26503;
var statearr_26588_26769 = state_26503__$1;
(statearr_26588_26769[(2)] = inst_26483);

(statearr_26588_26769[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (89))){
var inst_26323 = (state_26503[(13)]);
var inst_26322 = (state_26503[(17)]);
var inst_26324 = (state_26503[(22)]);
var inst_26356 = (state_26503[(81)]);
var inst_26284 = (state_26503[(43)]);
var inst_26368 = cljs.core.count(inst_26356);
var inst_26369 = (inst_26284 - inst_26322);
var inst_26370 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_26369,inst_26356);
var inst_26371 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26324,inst_26370);
var inst_26372 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26373 = (inst_26322 + inst_26368);
var inst_26374 = [(0),inst_26373,inst_26323,inst_26371];
var inst_26375 = (new cljs.core.PersistentVector(null,4,(5),inst_26372,inst_26374,null));
var state_26503__$1 = state_26503;
var statearr_26589_26770 = state_26503__$1;
(statearr_26589_26770[(2)] = inst_26375);

(statearr_26589_26770[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (100))){
var inst_26390 = (state_26503[(67)]);
var inst_26322 = (state_26503[(17)]);
var inst_26418 = (state_26503[(52)]);
var inst_26416 = (state_26503[(53)]);
var inst_26284 = (state_26503[(43)]);
var inst_26417 = (state_26503[(54)]);
var inst_26412 = (state_26503[(2)]);
var inst_26413 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26412,(0),null);
var inst_26414 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26412,(1),null);
var inst_26415 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_26414,inst_26390);
var inst_26416__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_26415);
var inst_26417__$1 = cljs.core.count(inst_26416__$1);
var inst_26418__$1 = (inst_26322 + inst_26417__$1);
var inst_26419 = (inst_26418__$1 > inst_26284);
var state_26503__$1 = (function (){var statearr_26590 = state_26503;
(statearr_26590[(52)] = inst_26418__$1);

(statearr_26590[(83)] = inst_26413);

(statearr_26590[(53)] = inst_26416__$1);

(statearr_26590[(54)] = inst_26417__$1);

return statearr_26590;
})();
if(cljs.core.truth_(inst_26419)){
var statearr_26591_26771 = state_26503__$1;
(statearr_26591_26771[(1)] = (101));

} else {
var statearr_26592_26772 = state_26503__$1;
(statearr_26592_26772[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (122))){
var inst_26483 = (state_26503[(73)]);
var inst_26457 = (state_26503[(76)]);
var inst_26458 = (state_26503[(77)]);
var inst_26459 = (state_26503[(7)]);
var inst_26456 = (state_26503[(78)]);
var inst_26320 = inst_26483;
var inst_26321 = inst_26456;
var inst_26322 = inst_26457;
var inst_26323 = inst_26458;
var inst_26324 = inst_26459;
var state_26503__$1 = (function (){var statearr_26593 = state_26503;
(statearr_26593[(13)] = inst_26323);

(statearr_26593[(17)] = inst_26322);

(statearr_26593[(22)] = inst_26324);

(statearr_26593[(42)] = inst_26320);

(statearr_26593[(45)] = inst_26321);

return statearr_26593;
})();
var statearr_26594_26773 = state_26503__$1;
(statearr_26594_26773[(2)] = null);

(statearr_26594_26773[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (43))){
var state_26503__$1 = state_26503;
var statearr_26595_26774 = state_26503__$1;
(statearr_26595_26774[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_26595_26774[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (61))){
var inst_26301 = (state_26503[(10)]);
var inst_26307 = (state_26503[(29)]);
var inst_26280 = (state_26503[(38)]);
var inst_26302 = (state_26503[(39)]);
var inst_26297 = (state_26503[(46)]);
var inst_26306 = (state_26503[(2)]);
var inst_26307__$1 = fluree.db.util.async.throw_err(inst_26306);
var inst_26308 = fluree.db.query.range.find_next_valid_node(inst_26307__$1,inst_26280,inst_26297,inst_26301,inst_26302);
var state_26503__$1 = (function (){var statearr_26596 = state_26503;
(statearr_26596[(29)] = inst_26307__$1);

return statearr_26596;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26503__$1,(62),inst_26308);
} else {
if((state_val_26504 === (29))){
var inst_26230 = (state_26503[(2)]);
var inst_26231 = fluree.db.util.async.throw_err(inst_26230);
var state_26503__$1 = state_26503;
var statearr_26597_26775 = state_26503__$1;
(statearr_26597_26775[(2)] = inst_26231);

(statearr_26597_26775[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (44))){
var inst_26162 = (state_26503[(55)]);
var state_26503__$1 = state_26503;
var statearr_26598_26776 = state_26503__$1;
(statearr_26598_26776[(2)] = inst_26162);

(statearr_26598_26776[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (93))){
var inst_26378 = (state_26503[(80)]);
var inst_26317 = (state_26503[(9)]);
var inst_26321 = (state_26503[(45)]);
var inst_26390 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_26321,inst_26378);
var state_26503__$1 = (function (){var statearr_26599 = state_26503;
(statearr_26599[(67)] = inst_26390);

return statearr_26599;
})();
if(cljs.core.truth_(inst_26317)){
var statearr_26600_26777 = state_26503__$1;
(statearr_26600_26777[(1)] = (95));

} else {
var statearr_26601_26778 = state_26503__$1;
(statearr_26601_26778[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (6))){
var inst_26154 = (state_26503[(49)]);
var inst_26174 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_26154);
var state_26503__$1 = state_26503;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26503__$1,(9),inst_26174);
} else {
if((state_val_26504 === (111))){
var inst_26290 = (state_26503[(36)]);
var inst_26458 = (state_26503[(77)]);
var inst_26466 = (inst_26458 < inst_26290);
var state_26503__$1 = state_26503;
var statearr_26602_26779 = state_26503__$1;
(statearr_26602_26779[(2)] = inst_26466);

(statearr_26602_26779[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (28))){
var inst_26224 = (state_26503[(74)]);
var inst_26234 = (state_26503[(2)]);
var inst_26235 = fluree.db.util.core.pred_ident_QMARK_(inst_26224);
var state_26503__$1 = (function (){var statearr_26603 = state_26503;
(statearr_26603[(16)] = inst_26234);

return statearr_26603;
})();
if(inst_26235){
var statearr_26604_26780 = state_26503__$1;
(statearr_26604_26780[(1)] = (30));

} else {
var statearr_26605_26781 = state_26503__$1;
(statearr_26605_26781[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (64))){
var state_26503__$1 = state_26503;
var statearr_26606_26782 = state_26503__$1;
(statearr_26606_26782[(2)] = true);

(statearr_26606_26782[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (103))){
var inst_26413 = (state_26503[(83)]);
var inst_26432 = (state_26503[(2)]);
var inst_26433 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26432,(0),null);
var inst_26434 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26432,(1),null);
var inst_26435 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26436 = [inst_26433,inst_26413,inst_26434];
var inst_26437 = (new cljs.core.PersistentVector(null,3,(5),inst_26435,inst_26436,null));
var state_26503__$1 = state_26503;
var statearr_26607_26783 = state_26503__$1;
(statearr_26607_26783[(2)] = inst_26437);

(statearr_26607_26783[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (51))){
var inst_26268 = (state_26503[(2)]);
var state_26503__$1 = state_26503;
var statearr_26608_26784 = state_26503__$1;
(statearr_26608_26784[(2)] = inst_26268);

(statearr_26608_26784[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (25))){
var inst_26223 = (state_26503[(51)]);
var inst_26222 = (state_26503[(44)]);
var inst_26221 = (state_26503[(47)]);
var inst_26221__$1 = (state_26503[(2)]);
var inst_26222__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26221__$1,(0),null);
var inst_26223__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26222__$1,(0),null);
var inst_26224 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26222__$1,(1),null);
var inst_26225 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26221__$1,(1),null);
var inst_26226 = fluree.db.util.core.pred_ident_QMARK_(inst_26223__$1);
var state_26503__$1 = (function (){var statearr_26609 = state_26503;
(statearr_26609[(51)] = inst_26223__$1);

(statearr_26609[(34)] = inst_26225);

(statearr_26609[(74)] = inst_26224);

(statearr_26609[(44)] = inst_26222__$1);

(statearr_26609[(47)] = inst_26221__$1);

return statearr_26609;
})();
if(inst_26226){
var statearr_26610_26785 = state_26503__$1;
(statearr_26610_26785[(1)] = (26));

} else {
var statearr_26611_26786 = state_26503__$1;
(statearr_26611_26786[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (34))){
var inst_26234 = (state_26503[(16)]);
var state_26503__$1 = state_26503;
var statearr_26612_26787 = state_26503__$1;
(statearr_26612_26787[(2)] = inst_26234);

(statearr_26612_26787[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (17))){
var inst_26163 = (state_26503[(60)]);
var state_26503__$1 = state_26503;
var statearr_26613_26788 = state_26503__$1;
(statearr_26613_26788[(2)] = inst_26163);

(statearr_26613_26788[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (3))){
var inst_26501 = (state_26503[(2)]);
var state_26503__$1 = state_26503;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26503__$1,inst_26501);
} else {
if((state_val_26504 === (12))){
var inst_26156 = (state_26503[(61)]);
var inst_26189 = (state_26503[(2)]);
var inst_26190 = cljs.core.boolean_QMARK_(inst_26156);
var state_26503__$1 = (function (){var statearr_26614 = state_26503;
(statearr_26614[(30)] = inst_26189);

return statearr_26614;
})();
if(inst_26190){
var statearr_26615_26789 = state_26503__$1;
(statearr_26615_26789[(1)] = (14));

} else {
var statearr_26616_26790 = state_26503__$1;
(statearr_26616_26790[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (2))){
var inst_26168 = (state_26503[(12)]);
var inst_26160 = (state_26503[(18)]);
var inst_26153 = (state_26503[(28)]);
var inst_26154 = (state_26503[(49)]);
var _ = (function (){var statearr_26617 = state_26503;
(statearr_26617[(4)] = cljs.core.cons((5),(state_26503[(4)])));

return statearr_26617;
})();
var inst_26153__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_26154__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26153__$1,(0),null);
var inst_26155 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26153__$1,(1),null);
var inst_26156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26153__$1,(2),null);
var inst_26157 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26153__$1,(3),null);
var inst_26158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26153__$1,(4),null);
var inst_26159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26153__$1,(5),null);
var inst_26160__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_26161 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26160__$1,(0),null);
var inst_26162 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26160__$1,(1),null);
var inst_26163 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26160__$1,(2),null);
var inst_26164 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26160__$1,(3),null);
var inst_26165 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26160__$1,(4),null);
var inst_26166 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26160__$1,(5),null);
var inst_26167 = opts;
var inst_26168__$1 = cljs.core.__destructure_map(inst_26167);
var inst_26169 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26168__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_26170 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26168__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_26171 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26168__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_26172 = fluree.db.util.core.pred_ident_QMARK_(inst_26154__$1);
var state_26503__$1 = (function (){var statearr_26618 = state_26503;
(statearr_26618[(84)] = inst_26161);

(statearr_26618[(12)] = inst_26168__$1);

(statearr_26618[(55)] = inst_26162);

(statearr_26618[(15)] = inst_26164);

(statearr_26618[(56)] = inst_26166);

(statearr_26618[(18)] = inst_26160__$1);

(statearr_26618[(23)] = inst_26157);

(statearr_26618[(25)] = inst_26169);

(statearr_26618[(26)] = inst_26158);

(statearr_26618[(28)] = inst_26153__$1);

(statearr_26618[(57)] = inst_26155);

(statearr_26618[(58)] = inst_26171);

(statearr_26618[(37)] = inst_26165);

(statearr_26618[(59)] = inst_26159);

(statearr_26618[(41)] = inst_26170);

(statearr_26618[(60)] = inst_26163);

(statearr_26618[(49)] = inst_26154__$1);

(statearr_26618[(61)] = inst_26156);

return statearr_26618;
})();
if(inst_26172){
var statearr_26619_26791 = state_26503__$1;
(statearr_26619_26791[(1)] = (6));

} else {
var statearr_26620_26792 = state_26503__$1;
(statearr_26620_26792[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (66))){
var inst_26286 = (state_26503[(71)]);
var inst_26311 = (state_26503[(8)]);
var inst_26319 = cljs.core.PersistentVector.EMPTY;
var inst_26320 = inst_26311;
var inst_26321 = inst_26286;
var inst_26322 = (0);
var inst_26323 = (0);
var inst_26324 = inst_26319;
var state_26503__$1 = (function (){var statearr_26621 = state_26503;
(statearr_26621[(13)] = inst_26323);

(statearr_26621[(17)] = inst_26322);

(statearr_26621[(22)] = inst_26324);

(statearr_26621[(42)] = inst_26320);

(statearr_26621[(45)] = inst_26321);

return statearr_26621;
})();
var statearr_26622_26793 = state_26503__$1;
(statearr_26622_26793[(2)] = null);

(statearr_26622_26793[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (107))){
var inst_26475 = (state_26503[(66)]);
var inst_26475__$1 = (state_26503[(2)]);
var state_26503__$1 = (function (){var statearr_26623 = state_26503;
(statearr_26623[(66)] = inst_26475__$1);

return statearr_26623;
})();
if(cljs.core.truth_(inst_26475__$1)){
var statearr_26624_26794 = state_26503__$1;
(statearr_26624_26794[(1)] = (114));

} else {
var statearr_26625_26795 = state_26503__$1;
(statearr_26625_26795[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (23))){
var inst_26171 = (state_26503[(58)]);
var inst_26163 = (state_26503[(60)]);
var inst_26156 = (state_26503[(61)]);
var inst_26206 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26208 = [inst_26156,inst_26163];
var inst_26209 = (new cljs.core.PersistentVector(null,2,(5),inst_26207,inst_26208,null));
var inst_26210 = [inst_26209,inst_26171];
var inst_26211 = (new cljs.core.PersistentVector(null,2,(5),inst_26206,inst_26210,null));
var state_26503__$1 = state_26503;
var statearr_26626_26796 = state_26503__$1;
(statearr_26626_26796[(2)] = inst_26211);

(statearr_26626_26796[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (47))){
var inst_26264 = (cljs.core._GT__EQ_ === start_test);
var state_26503__$1 = state_26503;
if(cljs.core.truth_(inst_26264)){
var statearr_26627_26797 = state_26503__$1;
(statearr_26627_26797[(1)] = (49));

} else {
var statearr_26628_26798 = state_26503__$1;
(statearr_26628_26798[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (35))){
var inst_26244 = (state_26503[(75)]);
var state_26503__$1 = state_26503;
var statearr_26629_26799 = state_26503__$1;
(statearr_26629_26799[(2)] = inst_26244);

(statearr_26629_26799[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (82))){
var inst_26291 = (state_26503[(40)]);
var inst_26320 = (state_26503[(42)]);
var inst_26356 = (state_26503[(2)]);
var inst_26357 = fluree.db.dbproto._rhs(inst_26320);
var state_26503__$1 = (function (){var statearr_26630 = state_26503;
(statearr_26630[(65)] = inst_26357);

(statearr_26630[(81)] = inst_26356);

return statearr_26630;
})();
if(cljs.core.truth_(inst_26291)){
var statearr_26631_26800 = state_26503__$1;
(statearr_26631_26800[(1)] = (83));

} else {
var statearr_26632_26801 = state_26503__$1;
(statearr_26632_26801[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (76))){
var inst_26170 = (state_26503[(41)]);
var inst_26344 = (state_26503[(2)]);
var state_26503__$1 = (function (){var statearr_26633 = state_26503;
(statearr_26633[(64)] = inst_26344);

return statearr_26633;
})();
if(cljs.core.truth_(inst_26170)){
var statearr_26634_26802 = state_26503__$1;
(statearr_26634_26802[(1)] = (77));

} else {
var statearr_26635_26803 = state_26503__$1;
(statearr_26635_26803[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (97))){
var inst_26324 = (state_26503[(22)]);
var inst_26444 = (state_26503[(2)]);
var inst_26445 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26444,(0),null);
var inst_26446 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26444,(1),null);
var inst_26447 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26444,(2),null);
var inst_26448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26449 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26324,inst_26447);
var inst_26450 = [(0),inst_26445,inst_26446,inst_26449];
var inst_26451 = (new cljs.core.PersistentVector(null,4,(5),inst_26448,inst_26450,null));
var state_26503__$1 = state_26503;
var statearr_26636_26804 = state_26503__$1;
(statearr_26636_26804[(2)] = inst_26451);

(statearr_26636_26804[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (19))){
var inst_26201 = (state_26503[(2)]);
var state_26503__$1 = state_26503;
var statearr_26637_26805 = state_26503__$1;
(statearr_26637_26805[(2)] = inst_26201);

(statearr_26637_26805[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (57))){
var inst_26277 = (state_26503[(2)]);
var state_26503__$1 = state_26503;
var statearr_26638_26806 = state_26503__$1;
(statearr_26638_26806[(2)] = inst_26277);

(statearr_26638_26806[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (68))){
var inst_26498 = (state_26503[(2)]);
var _ = (function (){var statearr_26639 = state_26503;
(statearr_26639[(4)] = cljs.core.rest((state_26503[(4)])));

return statearr_26639;
})();
var state_26503__$1 = state_26503;
var statearr_26640_26807 = state_26503__$1;
(statearr_26640_26807[(2)] = inst_26498);

(statearr_26640_26807[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (11))){
var inst_26161 = (state_26503[(84)]);
var state_26503__$1 = state_26503;
var statearr_26641_26808 = state_26503__$1;
(statearr_26641_26808[(2)] = inst_26161);

(statearr_26641_26808[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (115))){
var state_26503__$1 = state_26503;
var statearr_26643_26809 = state_26503__$1;
(statearr_26643_26809[(2)] = null);

(statearr_26643_26809[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (9))){
var inst_26176 = (state_26503[(2)]);
var inst_26177 = fluree.db.util.async.throw_err(inst_26176);
var state_26503__$1 = state_26503;
var statearr_26644_26810 = state_26503__$1;
(statearr_26644_26810[(2)] = inst_26177);

(statearr_26644_26810[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (5))){
var _ = (function (){var statearr_26645 = state_26503;
(statearr_26645[(4)] = cljs.core.rest((state_26503[(4)])));

return statearr_26645;
})();
var state_26503__$1 = state_26503;
var ex26642 = (state_26503__$1[(2)]);
var statearr_26646_26811 = state_26503__$1;
(statearr_26646_26811[(5)] = ex26642);


if((ex26642 instanceof Error)){
var statearr_26647_26812 = state_26503__$1;
(statearr_26647_26812[(1)] = (4));

(statearr_26647_26812[(5)] = null);

} else {
throw ex26642;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (112))){
var inst_26464 = (state_26503[(79)]);
var state_26503__$1 = state_26503;
var statearr_26648_26813 = state_26503__$1;
(statearr_26648_26813[(2)] = inst_26464);

(statearr_26648_26813[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (83))){
var inst_26359 = (state_26503[(85)]);
var inst_26321 = (state_26503[(45)]);
var inst_26359__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_26321);
var state_26503__$1 = (function (){var statearr_26649 = state_26503;
(statearr_26649[(85)] = inst_26359__$1);

return statearr_26649;
})();
if(inst_26359__$1){
var statearr_26650_26814 = state_26503__$1;
(statearr_26650_26814[(1)] = (86));

} else {
var statearr_26651_26815 = state_26503__$1;
(statearr_26651_26815[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (14))){
var inst_26156 = (state_26503[(61)]);
var state_26503__$1 = state_26503;
var statearr_26652_26816 = state_26503__$1;
(statearr_26652_26816[(2)] = inst_26156);

(statearr_26652_26816[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (45))){
var inst_26159 = (state_26503[(59)]);
var inst_26261 = (state_26503[(2)]);
var state_26503__$1 = (function (){var statearr_26653 = state_26503;
(statearr_26653[(27)] = inst_26261);

return statearr_26653;
})();
if(cljs.core.truth_(inst_26159)){
var statearr_26654_26817 = state_26503__$1;
(statearr_26654_26817[(1)] = (46));

} else {
var statearr_26655_26818 = state_26503__$1;
(statearr_26655_26818[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (53))){
var inst_26273 = (cljs.core._LT__EQ_ === end_test);
var state_26503__$1 = state_26503;
if(cljs.core.truth_(inst_26273)){
var statearr_26656_26819 = state_26503__$1;
(statearr_26656_26819[(1)] = (55));

} else {
var statearr_26657_26820 = state_26503__$1;
(statearr_26657_26820[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (78))){
var inst_26344 = (state_26503[(64)]);
var state_26503__$1 = state_26503;
var statearr_26658_26821 = state_26503__$1;
(statearr_26658_26821[(2)] = inst_26344);

(statearr_26658_26821[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (26))){
var inst_26223 = (state_26503[(51)]);
var inst_26228 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_26223);
var state_26503__$1 = state_26503;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26503__$1,(29),inst_26228);
} else {
if((state_val_26504 === (123))){
var inst_26493 = (state_26503[(2)]);
var state_26503__$1 = state_26503;
var statearr_26659_26822 = state_26503__$1;
(statearr_26659_26822[(2)] = inst_26493);

(statearr_26659_26822[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (16))){
var inst_26203 = (state_26503[(62)]);
var inst_26203__$1 = (state_26503[(2)]);
var inst_26204 = (inst_26203__$1 == null);
var state_26503__$1 = (function (){var statearr_26660 = state_26503;
(statearr_26660[(62)] = inst_26203__$1);

return statearr_26660;
})();
if(cljs.core.truth_(inst_26204)){
var statearr_26661_26823 = state_26503__$1;
(statearr_26661_26823[(1)] = (23));

} else {
var statearr_26662_26824 = state_26503__$1;
(statearr_26662_26824[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (81))){
var inst_26350 = (state_26503[(86)]);
var state_26503__$1 = state_26503;
var statearr_26663_26825 = state_26503__$1;
(statearr_26663_26825[(2)] = inst_26350);

(statearr_26663_26825[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (120))){
var inst_26487 = (state_26503[(2)]);
var inst_26488 = cljs.core.not(inst_26487);
var state_26503__$1 = state_26503;
if(inst_26488){
var statearr_26664_26826 = state_26503__$1;
(statearr_26664_26826[(1)] = (121));

} else {
var statearr_26665_26827 = state_26503__$1;
(statearr_26665_26827[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (79))){
var inst_26225 = (state_26503[(34)]);
var inst_26350 = (state_26503[(2)]);
var state_26503__$1 = (function (){var statearr_26666 = state_26503;
(statearr_26666[(86)] = inst_26350);

return statearr_26666;
})();
if(cljs.core.truth_(inst_26225)){
var statearr_26667_26828 = state_26503__$1;
(statearr_26667_26828[(1)] = (80));

} else {
var statearr_26668_26829 = state_26503__$1;
(statearr_26668_26829[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (38))){
var inst_26155 = (state_26503[(57)]);
var state_26503__$1 = state_26503;
var statearr_26669_26830 = state_26503__$1;
(statearr_26669_26830[(2)] = inst_26155);

(statearr_26669_26830[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (98))){
var inst_26398 = (state_26503[(68)]);
var inst_26400 = (state_26503[(69)]);
var inst_26290 = (state_26503[(36)]);
var inst_26403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26404 = (inst_26398 - inst_26400);
var inst_26405 = [inst_26290,inst_26404];
var inst_26406 = (new cljs.core.PersistentVector(null,2,(5),inst_26403,inst_26405,null));
var state_26503__$1 = state_26503;
var statearr_26670_26831 = state_26503__$1;
(statearr_26670_26831[(2)] = inst_26406);

(statearr_26670_26831[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (87))){
var inst_26359 = (state_26503[(85)]);
var state_26503__$1 = state_26503;
var statearr_26671_26832 = state_26503__$1;
(statearr_26671_26832[(2)] = inst_26359);

(statearr_26671_26832[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (30))){
var inst_26224 = (state_26503[(74)]);
var inst_26237 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_26224);
var state_26503__$1 = state_26503;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26503__$1,(33),inst_26237);
} else {
if((state_val_26504 === (73))){
var inst_26169 = (state_26503[(25)]);
var inst_26338 = (state_26503[(2)]);
var state_26503__$1 = (function (){var statearr_26672 = state_26503;
(statearr_26672[(48)] = inst_26338);

return statearr_26672;
})();
if(cljs.core.truth_(inst_26169)){
var statearr_26673_26833 = state_26503__$1;
(statearr_26673_26833[(1)] = (74));

} else {
var statearr_26674_26834 = state_26503__$1;
(statearr_26674_26834[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (96))){
var inst_26390 = (state_26503[(67)]);
var inst_26323 = (state_26503[(13)]);
var inst_26322 = (state_26503[(17)]);
var inst_26290 = (state_26503[(36)]);
var inst_26284 = (state_26503[(43)]);
var inst_26439 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_26390,inst_26322,inst_26323,inst_26284,inst_26290);
var state_26503__$1 = state_26503;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26503__$1,(104),inst_26439);
} else {
if((state_val_26504 === (10))){
var inst_26161 = (state_26503[(84)]);
var inst_26183 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_26161);
var state_26503__$1 = state_26503;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26503__$1,(13),inst_26183);
} else {
if((state_val_26504 === (18))){
var state_26503__$1 = state_26503;
var statearr_26675_26835 = state_26503__$1;
(statearr_26675_26835[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (105))){
var inst_26357 = (state_26503[(65)]);
var inst_26296 = (state_26503[(24)]);
var inst_26281 = (state_26503[(31)]);
var inst_26462 = (state_26503[(82)]);
var inst_26461 = (inst_26296.cljs$core$IFn$_invoke$arity$2 ? inst_26296.cljs$core$IFn$_invoke$arity$2(inst_26357,inst_26281) : inst_26296.call(null,inst_26357,inst_26281));
var inst_26462__$1 = (inst_26461 < (0));
var state_26503__$1 = (function (){var statearr_26677 = state_26503;
(statearr_26677[(82)] = inst_26462__$1);

return statearr_26677;
})();
if(cljs.core.truth_(inst_26462__$1)){
var statearr_26678_26836 = state_26503__$1;
(statearr_26678_26836[(1)] = (108));

} else {
var statearr_26679_26837 = state_26503__$1;
(statearr_26679_26837[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (52))){
var inst_26166 = (state_26503[(56)]);
var state_26503__$1 = state_26503;
var statearr_26680_26838 = state_26503__$1;
(statearr_26680_26838[(2)] = inst_26166);

(statearr_26680_26838[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (114))){
var inst_26301 = (state_26503[(10)]);
var inst_26357 = (state_26503[(65)]);
var inst_26307 = (state_26503[(29)]);
var inst_26302 = (state_26503[(39)]);
var inst_26297 = (state_26503[(46)]);
var inst_26477 = fluree.db.query.range.find_next_valid_node(inst_26307,inst_26357,inst_26297,inst_26301,inst_26302);
var state_26503__$1 = state_26503;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26503__$1,(117),inst_26477);
} else {
if((state_val_26504 === (67))){
var state_26503__$1 = state_26503;
var statearr_26681_26839 = state_26503__$1;
(statearr_26681_26839[(2)] = null);

(statearr_26681_26839[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (71))){
var inst_26301 = (state_26503[(10)]);
var inst_26180 = (state_26503[(11)]);
var inst_26168 = (state_26503[(12)]);
var inst_26323 = (state_26503[(13)]);
var inst_26283 = (state_26503[(14)]);
var inst_26164 = (state_26503[(15)]);
var inst_26234 = (state_26503[(16)]);
var inst_26322 = (state_26503[(17)]);
var inst_26160 = (state_26503[(18)]);
var inst_26270 = (state_26503[(19)]);
var inst_26279 = (state_26503[(20)]);
var inst_26252 = (state_26503[(21)]);
var inst_26324 = (state_26503[(22)]);
var inst_26311 = (state_26503[(8)]);
var inst_26157 = (state_26503[(23)]);
var inst_26296 = (state_26503[(24)]);
var inst_26169 = (state_26503[(25)]);
var inst_26158 = (state_26503[(26)]);
var inst_26261 = (state_26503[(27)]);
var inst_26153 = (state_26503[(28)]);
var inst_26307 = (state_26503[(29)]);
var inst_26189 = (state_26503[(30)]);
var inst_26281 = (state_26503[(31)]);
var inst_26317 = (state_26503[(9)]);
var inst_26292 = (state_26503[(32)]);
var inst_26330 = (state_26503[(33)]);
var inst_26225 = (state_26503[(34)]);
var inst_26243 = (state_26503[(35)]);
var inst_26290 = (state_26503[(36)]);
var inst_26165 = (state_26503[(37)]);
var inst_26280 = (state_26503[(38)]);
var inst_26302 = (state_26503[(39)]);
var inst_26291 = (state_26503[(40)]);
var inst_26170 = (state_26503[(41)]);
var inst_26320 = (state_26503[(42)]);
var inst_26284 = (state_26503[(43)]);
var inst_26222 = (state_26503[(44)]);
var inst_26321 = (state_26503[(45)]);
var inst_26297 = (state_26503[(46)]);
var inst_26221 = (state_26503[(47)]);
var inst_26334 = (function (){var no_filter_QMARK_ = inst_26317;
var t = inst_26297;
var max_limit_QMARK_ = inst_26291;
var next_node = inst_26320;
var fast_forward_db_QMARK_ = inst_26302;
var s1 = inst_26180;
var o2 = inst_26243;
var t1 = inst_26157;
var predicate_fn = inst_26170;
var i = inst_26322;
var m1 = inst_26270;
var root_node = inst_26307;
var s2 = inst_26189;
var p2 = inst_26261;
var permissions = inst_26292;
var vec__26142 = inst_26160;
var limit = inst_26290;
var start_flake = inst_26280;
var flake_limit = inst_26284;
var vec__26146 = inst_26221;
var offset = inst_26321;
var acc = inst_26324;
var vec__26139 = inst_26153;
var t2 = inst_26164;
var op1 = inst_26158;
var o1 = inst_26234;
var end_flake = inst_26281;
var base_result = inst_26330;
var G__26331 = inst_26330;
var s = inst_26323;
var node_start = inst_26311;
var p1 = inst_26252;
var subject_fn = inst_26169;
var vec__26149 = inst_26222;
var object_fn = inst_26225;
var map__26152 = inst_26283;
var map__26145 = inst_26168;
var idx_compare = inst_26296;
var op2 = inst_26165;
var m2 = inst_26279;
var novelty = inst_26301;
return (function (p1__26120_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__26120_SHARP_.o,start_flake.o);
});
})();
var inst_26335 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_26334,inst_26330);
var state_26503__$1 = state_26503;
var statearr_26682_26840 = state_26503__$1;
(statearr_26682_26840[(2)] = inst_26335);

(statearr_26682_26840[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (42))){
var inst_26257 = (state_26503[(2)]);
var state_26503__$1 = state_26503;
if(cljs.core.truth_(inst_26257)){
var statearr_26683_26841 = state_26503__$1;
(statearr_26683_26841[(1)] = (43));

} else {
var statearr_26684_26842 = state_26503__$1;
(statearr_26684_26842[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (80))){
var inst_26301 = (state_26503[(10)]);
var inst_26180 = (state_26503[(11)]);
var inst_26168 = (state_26503[(12)]);
var inst_26323 = (state_26503[(13)]);
var inst_26283 = (state_26503[(14)]);
var inst_26164 = (state_26503[(15)]);
var inst_26350 = (state_26503[(86)]);
var inst_26234 = (state_26503[(16)]);
var inst_26322 = (state_26503[(17)]);
var inst_26160 = (state_26503[(18)]);
var inst_26270 = (state_26503[(19)]);
var inst_26279 = (state_26503[(20)]);
var inst_26252 = (state_26503[(21)]);
var inst_26324 = (state_26503[(22)]);
var inst_26311 = (state_26503[(8)]);
var inst_26157 = (state_26503[(23)]);
var inst_26296 = (state_26503[(24)]);
var inst_26169 = (state_26503[(25)]);
var inst_26158 = (state_26503[(26)]);
var inst_26261 = (state_26503[(27)]);
var inst_26153 = (state_26503[(28)]);
var inst_26307 = (state_26503[(29)]);
var inst_26189 = (state_26503[(30)]);
var inst_26281 = (state_26503[(31)]);
var inst_26317 = (state_26503[(9)]);
var inst_26292 = (state_26503[(32)]);
var inst_26330 = (state_26503[(33)]);
var inst_26225 = (state_26503[(34)]);
var inst_26243 = (state_26503[(35)]);
var inst_26290 = (state_26503[(36)]);
var inst_26165 = (state_26503[(37)]);
var inst_26280 = (state_26503[(38)]);
var inst_26302 = (state_26503[(39)]);
var inst_26291 = (state_26503[(40)]);
var inst_26170 = (state_26503[(41)]);
var inst_26320 = (state_26503[(42)]);
var inst_26284 = (state_26503[(43)]);
var inst_26222 = (state_26503[(44)]);
var inst_26321 = (state_26503[(45)]);
var inst_26297 = (state_26503[(46)]);
var inst_26221 = (state_26503[(47)]);
var inst_26352 = (function (){var no_filter_QMARK_ = inst_26317;
var t = inst_26297;
var max_limit_QMARK_ = inst_26291;
var next_node = inst_26320;
var fast_forward_db_QMARK_ = inst_26302;
var s1 = inst_26180;
var o2 = inst_26243;
var t1 = inst_26157;
var predicate_fn = inst_26170;
var i = inst_26322;
var m1 = inst_26270;
var root_node = inst_26307;
var s2 = inst_26189;
var p2 = inst_26261;
var permissions = inst_26292;
var vec__26142 = inst_26160;
var limit = inst_26290;
var start_flake = inst_26280;
var flake_limit = inst_26284;
var vec__26146 = inst_26221;
var offset = inst_26321;
var acc = inst_26324;
var vec__26139 = inst_26153;
var t2 = inst_26164;
var op1 = inst_26158;
var o1 = inst_26234;
var end_flake = inst_26281;
var base_result = inst_26330;
var G__26331 = inst_26350;
var s = inst_26323;
var node_start = inst_26311;
var p1 = inst_26252;
var subject_fn = inst_26169;
var vec__26149 = inst_26222;
var object_fn = inst_26225;
var map__26152 = inst_26283;
var map__26145 = inst_26168;
var idx_compare = inst_26296;
var op2 = inst_26165;
var m2 = inst_26279;
var novelty = inst_26301;
return (function (p1__26123_SHARP_){
var G__26685 = p1__26123_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__26685) : object_fn.call(null,G__26685));
});
})();
var inst_26353 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_26352,inst_26350);
var state_26503__$1 = state_26503;
var statearr_26686_26843 = state_26503__$1;
(statearr_26686_26843[(2)] = inst_26353);

(statearr_26686_26843[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (37))){
var state_26503__$1 = state_26503;
var statearr_26687_26844 = state_26503__$1;
(statearr_26687_26844[(2)] = (-1));

(statearr_26687_26844[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (63))){
var inst_26180 = (state_26503[(11)]);
var inst_26252 = (state_26503[(21)]);
var inst_26261 = (state_26503[(27)]);
var inst_26189 = (state_26503[(30)]);
var inst_26292 = (state_26503[(32)]);
var inst_26314 = fluree.db.permissions_validate.no_filter_QMARK_(inst_26292,inst_26180,inst_26189,inst_26252,inst_26261);
var state_26503__$1 = state_26503;
var statearr_26688_26845 = state_26503__$1;
(statearr_26688_26845[(2)] = inst_26314);

(statearr_26688_26845[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (94))){
var inst_26453 = (state_26503[(2)]);
var state_26503__$1 = state_26503;
var statearr_26689_26846 = state_26503__$1;
(statearr_26689_26846[(2)] = inst_26453);

(statearr_26689_26846[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (8))){
var inst_26161 = (state_26503[(84)]);
var inst_26180 = (state_26503[(2)]);
var inst_26181 = fluree.db.util.core.pred_ident_QMARK_(inst_26161);
var state_26503__$1 = (function (){var statearr_26690 = state_26503;
(statearr_26690[(11)] = inst_26180);

return statearr_26690;
})();
if(inst_26181){
var statearr_26691_26847 = state_26503__$1;
(statearr_26691_26847[(1)] = (10));

} else {
var statearr_26692_26848 = state_26503__$1;
(statearr_26692_26848[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (49))){
var state_26503__$1 = state_26503;
var statearr_26693_26849 = state_26503__$1;
(statearr_26693_26849[(2)] = fluree.db.util.core.min_integer);

(statearr_26693_26849[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26504 === (84))){
var inst_26291 = (state_26503[(40)]);
var state_26503__$1 = state_26503;
var statearr_26694_26850 = state_26503__$1;
(statearr_26694_26850[(2)] = inst_26291);

(statearr_26694_26850[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__11438__auto__ = null;
var fluree$db$query$range$state_machine__11438__auto____0 = (function (){
var statearr_26695 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26695[(0)] = fluree$db$query$range$state_machine__11438__auto__);

(statearr_26695[(1)] = (1));

return statearr_26695;
});
var fluree$db$query$range$state_machine__11438__auto____1 = (function (state_26503){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_26503);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e26696){var ex__11441__auto__ = e26696;
var statearr_26697_26851 = state_26503;
(statearr_26697_26851[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_26503[(4)]))){
var statearr_26698_26852 = state_26503;
(statearr_26698_26852[(1)] = cljs.core.first((state_26503[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26853 = state_26503;
state_26503 = G__26853;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__11438__auto__ = function(state_26503){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__11438__auto____1.call(this,state_26503);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__11438__auto____0;
fluree$db$query$range$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__11438__auto____1;
return fluree$db$query$range$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_26699 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_26699[(6)] = c__11512__auto__);

return statearr_26699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_26909){
var state_val_26910 = (state_26909[(1)]);
if((state_val_26910 === (7))){
var inst_26883 = (state_26909[(7)]);
var inst_26873 = (state_26909[(8)]);
var inst_26881 = fluree.db.flake.Flake__GT_parts(inst_26873);
var inst_26882 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26881,(0),null);
var inst_26883__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26881,(1),null);
var inst_26884 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26881,(2),null);
var inst_26885 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26881,(3),null);
var inst_26886 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26881,(4),null);
var inst_26887 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26881,(5),null);
var inst_26888 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_26884,inst_26883__$1);
var state_26909__$1 = (function (){var statearr_26911 = state_26909;
(statearr_26911[(9)] = inst_26887);

(statearr_26911[(7)] = inst_26883__$1);

(statearr_26911[(10)] = inst_26885);

(statearr_26911[(11)] = inst_26886);

(statearr_26911[(12)] = inst_26882);

return statearr_26911;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26909__$1,(10),inst_26888);
} else {
if((state_val_26910 === (1))){
var inst_26861 = flakes;
var inst_26862 = cljs.core.seq(inst_26861);
var inst_26863 = cljs.core.first(inst_26862);
var inst_26864 = cljs.core.next(inst_26862);
var inst_26865 = cljs.core.PersistentVector.EMPTY;
var inst_26866 = inst_26861;
var inst_26867 = inst_26865;
var state_26909__$1 = (function (){var statearr_26912 = state_26909;
(statearr_26912[(13)] = inst_26863);

(statearr_26912[(14)] = inst_26866);

(statearr_26912[(15)] = inst_26867);

(statearr_26912[(16)] = inst_26864);

return statearr_26912;
})();
var statearr_26913_26931 = state_26909__$1;
(statearr_26913_26931[(2)] = null);

(statearr_26913_26931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26910 === (4))){
var inst_26873 = (state_26909[(8)]);
var inst_26876 = fluree.db.query.range.is_tag_flake_QMARK_(inst_26873);
var state_26909__$1 = state_26909;
if(inst_26876){
var statearr_26914_26932 = state_26909__$1;
(statearr_26914_26932[(1)] = (7));

} else {
var statearr_26915_26933 = state_26909__$1;
(statearr_26915_26933[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26910 === (6))){
var inst_26905 = (state_26909[(2)]);
var state_26909__$1 = state_26909;
var statearr_26916_26934 = state_26909__$1;
(statearr_26916_26934[(2)] = inst_26905);

(statearr_26916_26934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26910 === (3))){
var inst_26907 = (state_26909[(2)]);
var state_26909__$1 = state_26909;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26909__$1,inst_26907);
} else {
if((state_val_26910 === (2))){
var inst_26873 = (state_26909[(8)]);
var inst_26866 = (state_26909[(14)]);
var inst_26872 = cljs.core.seq(inst_26866);
var inst_26873__$1 = cljs.core.first(inst_26872);
var inst_26874 = cljs.core.next(inst_26872);
var state_26909__$1 = (function (){var statearr_26917 = state_26909;
(statearr_26917[(8)] = inst_26873__$1);

(statearr_26917[(17)] = inst_26874);

return statearr_26917;
})();
if(cljs.core.truth_(inst_26873__$1)){
var statearr_26918_26935 = state_26909__$1;
(statearr_26918_26935[(1)] = (4));

} else {
var statearr_26919_26936 = state_26909__$1;
(statearr_26919_26936[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26910 === (9))){
var inst_26902 = (state_26909[(2)]);
var state_26909__$1 = state_26909;
var statearr_26920_26937 = state_26909__$1;
(statearr_26920_26937[(2)] = inst_26902);

(statearr_26920_26937[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26910 === (5))){
var inst_26867 = (state_26909[(15)]);
var state_26909__$1 = state_26909;
var statearr_26921_26938 = state_26909__$1;
(statearr_26921_26938[(2)] = inst_26867);

(statearr_26921_26938[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26910 === (10))){
var inst_26887 = (state_26909[(9)]);
var inst_26883 = (state_26909[(7)]);
var inst_26885 = (state_26909[(10)]);
var inst_26886 = (state_26909[(11)]);
var inst_26874 = (state_26909[(17)]);
var inst_26882 = (state_26909[(12)]);
var inst_26867 = (state_26909[(15)]);
var inst_26890 = (state_26909[(2)]);
var inst_26891 = fluree.db.util.async.throw_err(inst_26890);
var inst_26892 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26893 = [inst_26882,inst_26883,inst_26891,inst_26885,inst_26886,inst_26887];
var inst_26894 = (new cljs.core.PersistentVector(null,6,(5),inst_26892,inst_26893,null));
var inst_26895 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_26894);
var inst_26896 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26867,inst_26895);
var inst_26866 = inst_26874;
var inst_26867__$1 = inst_26896;
var state_26909__$1 = (function (){var statearr_26922 = state_26909;
(statearr_26922[(14)] = inst_26866);

(statearr_26922[(15)] = inst_26867__$1);

return statearr_26922;
})();
var statearr_26923_26939 = state_26909__$1;
(statearr_26923_26939[(2)] = null);

(statearr_26923_26939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26910 === (8))){
var inst_26873 = (state_26909[(8)]);
var inst_26874 = (state_26909[(17)]);
var inst_26867 = (state_26909[(15)]);
var inst_26899 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26867,inst_26873);
var inst_26866 = inst_26874;
var inst_26867__$1 = inst_26899;
var state_26909__$1 = (function (){var statearr_26924 = state_26909;
(statearr_26924[(14)] = inst_26866);

(statearr_26924[(15)] = inst_26867__$1);

return statearr_26924;
})();
var statearr_26925_26940 = state_26909__$1;
(statearr_26925_26940[(2)] = null);

(statearr_26925_26940[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__11438__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__11438__auto____0 = (function (){
var statearr_26926 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26926[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__11438__auto__);

(statearr_26926[(1)] = (1));

return statearr_26926;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__11438__auto____1 = (function (state_26909){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_26909);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e26927){var ex__11441__auto__ = e26927;
var statearr_26928_26941 = state_26909;
(statearr_26928_26941[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_26909[(4)]))){
var statearr_26929_26942 = state_26909;
(statearr_26929_26942[(1)] = cljs.core.first((state_26909[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26943 = state_26909;
state_26909 = G__26943;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__11438__auto__ = function(state_26909){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__11438__auto____1.call(this,state_26909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__11438__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__11438__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_26930 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_26930[(6)] = c__11512__auto__);

return statearr_26930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__26945 = arguments.length;
switch (G__26945) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_27115){
var state_val_27116 = (state_27115[(1)]);
if((state_val_27116 === (65))){
var state_27115__$1 = state_27115;
var statearr_27117_27217 = state_27115__$1;
(statearr_27117_27217[(2)] = null);

(statearr_27117_27217[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (70))){
var inst_27110 = (state_27115[(2)]);
var _ = (function (){var statearr_27118 = state_27115;
(statearr_27118[(4)] = cljs.core.rest((state_27115[(4)])));

return statearr_27118;
})();
var state_27115__$1 = state_27115;
var statearr_27119_27218 = state_27115__$1;
(statearr_27119_27218[(2)] = inst_27110);

(statearr_27119_27218[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (62))){
var inst_27096 = (state_27115[(2)]);
var state_27115__$1 = state_27115;
var statearr_27120_27219 = state_27115__$1;
(statearr_27120_27219[(2)] = inst_27096);

(statearr_27120_27219[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (7))){
var state_27115__$1 = state_27115;
var statearr_27121_27220 = state_27115__$1;
(statearr_27121_27220[(2)] = false);

(statearr_27121_27220[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (59))){
var inst_27070 = (state_27115[(2)]);
var inst_27071 = fluree.db.util.async.throw_err(inst_27070);
var state_27115__$1 = state_27115;
var statearr_27122_27221 = state_27115__$1;
(statearr_27122_27221[(2)] = inst_27071);

(statearr_27122_27221[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (20))){
var state_27115__$1 = state_27115;
var statearr_27123_27222 = state_27115__$1;
(statearr_27123_27222[(2)] = null);

(statearr_27123_27222[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (58))){
var inst_27060 = (state_27115[(2)]);
var inst_27061 = fluree.db.util.async.throw_err(inst_27060);
var inst_27062 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_27061);
var state_27115__$1 = state_27115;
var statearr_27124_27223 = state_27115__$1;
(statearr_27124_27223[(2)] = inst_27062);

(statearr_27124_27223[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (60))){
var inst_26996 = (state_27115[(7)]);
var inst_26959 = (state_27115[(8)]);
var inst_26956 = (state_27115[(9)]);
var inst_26957 = (state_27115[(10)]);
var inst_27076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27077 = [inst_26957,inst_26956,inst_26996,inst_26959];
var inst_27078 = (new cljs.core.PersistentVector(null,4,(5),inst_27076,inst_27077,null));
var inst_27079 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_27078,opts);
var state_27115__$1 = state_27115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27115__$1,(63),inst_27079);
} else {
if((state_val_27116 === (27))){
var inst_26996 = (state_27115[(7)]);
var inst_27007 = (state_27115[(11)]);
var inst_27007__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_26996);
var state_27115__$1 = (function (){var statearr_27125 = state_27115;
(statearr_27125[(11)] = inst_27007__$1);

return statearr_27125;
})();
if(inst_27007__$1){
var statearr_27126_27224 = state_27115__$1;
(statearr_27126_27224[(1)] = (30));

} else {
var statearr_27127_27225 = state_27115__$1;
(statearr_27127_27225[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (1))){
var state_27115__$1 = state_27115;
var statearr_27128_27226 = state_27115__$1;
(statearr_27128_27226[(2)] = null);

(statearr_27128_27226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (69))){
var inst_27102 = (state_27115[(12)]);
var state_27115__$1 = state_27115;
var statearr_27129_27227 = state_27115__$1;
(statearr_27129_27227[(2)] = inst_27102);

(statearr_27129_27227[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (24))){
var inst_26957 = (state_27115[(10)]);
var state_27115__$1 = state_27115;
if(cljs.core.truth_(inst_26957)){
var statearr_27130_27228 = state_27115__$1;
(statearr_27130_27228[(1)] = (27));

} else {
var statearr_27131_27229 = state_27115__$1;
(statearr_27131_27229[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (55))){
var inst_26996 = (state_27115[(7)]);
var inst_27054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27055 = [inst_26996];
var inst_27056 = (new cljs.core.PersistentVector(null,1,(5),inst_27054,inst_27055,null));
var inst_27057 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_27058 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27056,inst_27057);
var state_27115__$1 = state_27115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27115__$1,(58),inst_27058);
} else {
if((state_val_27116 === (39))){
var inst_27027 = (state_27115[(2)]);
var inst_27028 = fluree.db.util.async.throw_err(inst_27027);
var state_27115__$1 = state_27115;
var statearr_27132_27230 = state_27115__$1;
(statearr_27132_27230[(2)] = inst_27028);

(statearr_27132_27230[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (46))){
var inst_27040 = (state_27115[(13)]);
var inst_27040__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_27115__$1 = (function (){var statearr_27133 = state_27115;
(statearr_27133[(13)] = inst_27040__$1);

return statearr_27133;
})();
if(cljs.core.truth_(inst_27040__$1)){
var statearr_27134_27231 = state_27115__$1;
(statearr_27134_27231[(1)] = (49));

} else {
var statearr_27135_27232 = state_27115__$1;
(statearr_27135_27232[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (4))){
var inst_26946 = (state_27115[(2)]);
var state_27115__$1 = state_27115;
var statearr_27136_27233 = state_27115__$1;
(statearr_27136_27233[(2)] = inst_26946);

(statearr_27136_27233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (54))){
var inst_27052 = (state_27115[(2)]);
var state_27115__$1 = state_27115;
if(cljs.core.truth_(inst_27052)){
var statearr_27137_27234 = state_27115__$1;
(statearr_27137_27234[(1)] = (55));

} else {
var statearr_27138_27235 = state_27115__$1;
(statearr_27138_27235[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (15))){
var inst_26958 = (state_27115[(14)]);
var inst_26977 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_26958);
var state_27115__$1 = state_27115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27115__$1,(18),inst_26977);
} else {
if((state_val_27116 === (48))){
var inst_27098 = (state_27115[(2)]);
var state_27115__$1 = state_27115;
var statearr_27139_27236 = state_27115__$1;
(statearr_27139_27236[(2)] = inst_27098);

(statearr_27139_27236[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (50))){
var inst_26960 = (state_27115[(15)]);
var inst_26996 = (state_27115[(7)]);
var inst_26959 = (state_27115[(8)]);
var inst_26956 = (state_27115[(9)]);
var inst_26966 = (state_27115[(16)]);
var inst_27040 = (state_27115[(13)]);
var inst_26955 = (state_27115[(17)]);
var inst_26971 = (state_27115[(18)]);
var inst_26957 = (state_27115[(10)]);
var inst_27044 = (function (){var t = inst_26959;
var temp__5802__auto__ = inst_27040;
var p = inst_26957;
var idx_predicate_QMARK_ = inst_26960;
var vec__26952 = inst_26955;
var o = inst_26996;
var tag_predicate_QMARK_ = inst_26966;
var s = inst_26956;
var o_coerce_QMARK_ = inst_26971;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_27115__$1 = state_27115;
var statearr_27140_27237 = state_27115__$1;
(statearr_27140_27237[(2)] = inst_27044);

(statearr_27140_27237[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (21))){
var inst_26992 = (state_27115[(2)]);
var state_27115__$1 = state_27115;
var statearr_27141_27238 = state_27115__$1;
(statearr_27141_27238[(2)] = inst_26992);

(statearr_27141_27238[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (31))){
var inst_27007 = (state_27115[(11)]);
var state_27115__$1 = state_27115;
var statearr_27142_27239 = state_27115__$1;
(statearr_27142_27239[(2)] = inst_27007);

(statearr_27142_27239[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (32))){
var inst_27017 = (state_27115[(2)]);
var state_27115__$1 = state_27115;
var statearr_27143_27240 = state_27115__$1;
(statearr_27143_27240[(2)] = inst_27017);

(statearr_27143_27240[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (40))){
var inst_26960 = (state_27115[(15)]);
var inst_27031 = (state_27115[(19)]);
var inst_27031__$1 = cljs.core.not(inst_26960);
var state_27115__$1 = (function (){var statearr_27144 = state_27115;
(statearr_27144[(19)] = inst_27031__$1);

return statearr_27144;
})();
if(inst_27031__$1){
var statearr_27145_27241 = state_27115__$1;
(statearr_27145_27241[(1)] = (43));

} else {
var statearr_27146_27242 = state_27115__$1;
(statearr_27146_27242[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (56))){
var inst_26959 = (state_27115[(8)]);
var inst_27046 = (state_27115[(20)]);
var inst_26956 = (state_27115[(9)]);
var inst_26957 = (state_27115[(10)]);
var inst_27064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27065 = [inst_26957,inst_26956,null,inst_26959];
var inst_27066 = (new cljs.core.PersistentVector(null,4,(5),inst_27064,inst_27065,null));
var inst_27067 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_27046);
var inst_27068 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_27066,inst_27067);
var state_27115__$1 = state_27115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27115__$1,(59),inst_27068);
} else {
if((state_val_27116 === (33))){
var inst_26996 = (state_27115[(7)]);
var inst_27010 = cljs.core.fn_QMARK_(inst_26996);
var inst_27011 = (!(inst_27010));
var state_27115__$1 = state_27115;
var statearr_27147_27243 = state_27115__$1;
(statearr_27147_27243[(2)] = inst_27011);

(statearr_27147_27243[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (13))){
var inst_26958 = (state_27115[(14)]);
var inst_26975 = fluree.db.query.range.tag_string_QMARK_(inst_26958);
var state_27115__$1 = state_27115;
if(cljs.core.truth_(inst_26975)){
var statearr_27148_27244 = state_27115__$1;
(statearr_27148_27244[(1)] = (15));

} else {
var statearr_27149_27245 = state_27115__$1;
(statearr_27149_27245[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (22))){
var inst_26988 = (state_27115[(2)]);
var inst_26989 = fluree.db.util.async.throw_err(inst_26988);
var state_27115__$1 = state_27115;
var statearr_27150_27246 = state_27115__$1;
(statearr_27150_27246[(2)] = inst_26989);

(statearr_27150_27246[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (36))){
var inst_26996 = (state_27115[(7)]);
var inst_26959 = (state_27115[(8)]);
var inst_26956 = (state_27115[(9)]);
var inst_26957 = (state_27115[(10)]);
var inst_27022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27023 = [inst_26957,inst_26996,inst_26956,inst_26959];
var inst_27024 = (new cljs.core.PersistentVector(null,4,(5),inst_27022,inst_27023,null));
var inst_27025 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27024,opts);
var state_27115__$1 = state_27115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27115__$1,(39),inst_27025);
} else {
if((state_val_27116 === (41))){
var inst_26957 = (state_27115[(10)]);
var state_27115__$1 = state_27115;
var statearr_27151_27247 = state_27115__$1;
(statearr_27151_27247[(2)] = inst_26957);

(statearr_27151_27247[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (43))){
var inst_26996 = (state_27115[(7)]);
var state_27115__$1 = state_27115;
var statearr_27152_27248 = state_27115__$1;
(statearr_27152_27248[(2)] = inst_26996);

(statearr_27152_27248[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (61))){
var inst_26996 = (state_27115[(7)]);
var state_27115__$1 = state_27115;
if(cljs.core.truth_(inst_26996)){
var statearr_27153_27249 = state_27115__$1;
(statearr_27153_27249[(1)] = (64));

} else {
var statearr_27154_27250 = state_27115__$1;
(statearr_27154_27250[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (29))){
var inst_27020 = (state_27115[(2)]);
var state_27115__$1 = state_27115;
if(cljs.core.truth_(inst_27020)){
var statearr_27155_27251 = state_27115__$1;
(statearr_27155_27251[(1)] = (36));

} else {
var statearr_27156_27252 = state_27115__$1;
(statearr_27156_27252[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (44))){
var inst_27031 = (state_27115[(19)]);
var state_27115__$1 = state_27115;
var statearr_27157_27253 = state_27115__$1;
(statearr_27157_27253[(2)] = inst_27031);

(statearr_27157_27253[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (6))){
var inst_26957 = (state_27115[(10)]);
var inst_26962 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_26957);
var inst_26963 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_26962);
var state_27115__$1 = state_27115;
var statearr_27158_27254 = state_27115__$1;
(statearr_27158_27254[(2)] = inst_26963);

(statearr_27158_27254[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (28))){
var inst_26957 = (state_27115[(10)]);
var state_27115__$1 = state_27115;
var statearr_27159_27255 = state_27115__$1;
(statearr_27159_27255[(2)] = inst_26957);

(statearr_27159_27255[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (64))){
var inst_26996 = (state_27115[(7)]);
var inst_26959 = (state_27115[(8)]);
var inst_26956 = (state_27115[(9)]);
var inst_26957 = (state_27115[(10)]);
var inst_27085 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27086 = [inst_26996,inst_26957,inst_26956,inst_26959];
var inst_27087 = (new cljs.core.PersistentVector(null,4,(5),inst_27085,inst_27086,null));
var inst_27088 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_27087,opts);
var state_27115__$1 = state_27115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27115__$1,(67),inst_27088);
} else {
if((state_val_27116 === (51))){
var inst_27047 = (state_27115[(21)]);
var inst_26957 = (state_27115[(10)]);
var inst_27046 = (state_27115[(2)]);
var inst_27047__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_26957);
var state_27115__$1 = (function (){var statearr_27160 = state_27115;
(statearr_27160[(20)] = inst_27046);

(statearr_27160[(21)] = inst_27047__$1);

return statearr_27160;
})();
if(inst_27047__$1){
var statearr_27161_27256 = state_27115__$1;
(statearr_27161_27256[(1)] = (52));

} else {
var statearr_27162_27257 = state_27115__$1;
(statearr_27162_27257[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (25))){
var inst_26966 = (state_27115[(16)]);
var inst_27102 = (state_27115[(2)]);
var state_27115__$1 = (function (){var statearr_27163 = state_27115;
(statearr_27163[(12)] = inst_27102);

return statearr_27163;
})();
if(cljs.core.truth_(inst_26966)){
var statearr_27164_27258 = state_27115__$1;
(statearr_27164_27258[(1)] = (68));

} else {
var statearr_27165_27259 = state_27115__$1;
(statearr_27165_27259[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (34))){
var inst_26960 = (state_27115[(15)]);
var state_27115__$1 = state_27115;
var statearr_27166_27260 = state_27115__$1;
(statearr_27166_27260[(2)] = inst_26960);

(statearr_27166_27260[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (17))){
var inst_26994 = (state_27115[(2)]);
var state_27115__$1 = state_27115;
var statearr_27167_27261 = state_27115__$1;
(statearr_27167_27261[(2)] = inst_26994);

(statearr_27167_27261[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (3))){
var inst_27113 = (state_27115[(2)]);
var state_27115__$1 = state_27115;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27115__$1,inst_27113);
} else {
if((state_val_27116 === (12))){
var inst_26958 = (state_27115[(14)]);
var state_27115__$1 = state_27115;
var statearr_27168_27262 = state_27115__$1;
(statearr_27168_27262[(2)] = inst_26958);

(statearr_27168_27262[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (2))){
var inst_26955 = (state_27115[(17)]);
var inst_26957 = (state_27115[(10)]);
var _ = (function (){var statearr_27169 = state_27115;
(statearr_27169[(4)] = cljs.core.cons((5),(state_27115[(4)])));

return statearr_27169;
})();
var inst_26955__$1 = fparts;
var inst_26956 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26955__$1,(0),null);
var inst_26957__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26955__$1,(1),null);
var inst_26958 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26955__$1,(2),null);
var inst_26959 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26955__$1,(3),null);
var inst_26960 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_26957__$1);
var state_27115__$1 = (function (){var statearr_27170 = state_27115;
(statearr_27170[(14)] = inst_26958);

(statearr_27170[(15)] = inst_26960);

(statearr_27170[(8)] = inst_26959);

(statearr_27170[(9)] = inst_26956);

(statearr_27170[(17)] = inst_26955__$1);

(statearr_27170[(10)] = inst_26957__$1);

return statearr_27170;
})();
if(cljs.core.truth_(inst_26957__$1)){
var statearr_27171_27263 = state_27115__$1;
(statearr_27171_27263[(1)] = (6));

} else {
var statearr_27172_27264 = state_27115__$1;
(statearr_27172_27264[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (66))){
var inst_27094 = (state_27115[(2)]);
var state_27115__$1 = state_27115;
var statearr_27173_27265 = state_27115__$1;
(statearr_27173_27265[(2)] = inst_27094);

(statearr_27173_27265[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (23))){
var inst_26996 = (state_27115[(7)]);
var inst_26959 = (state_27115[(8)]);
var inst_26956 = (state_27115[(9)]);
var inst_26957 = (state_27115[(10)]);
var inst_26998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26999 = [inst_26956,inst_26957,inst_26996,inst_26959];
var inst_27000 = (new cljs.core.PersistentVector(null,4,(5),inst_26998,inst_26999,null));
var inst_27001 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27000,opts);
var state_27115__$1 = state_27115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27115__$1,(26),inst_27001);
} else {
if((state_val_27116 === (47))){
var inst_26957 = (state_27115[(10)]);
var state_27115__$1 = state_27115;
if(cljs.core.truth_(inst_26957)){
var statearr_27174_27266 = state_27115__$1;
(statearr_27174_27266[(1)] = (60));

} else {
var statearr_27175_27267 = state_27115__$1;
(statearr_27175_27267[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (35))){
var inst_27014 = (state_27115[(2)]);
var state_27115__$1 = state_27115;
var statearr_27176_27268 = state_27115__$1;
(statearr_27176_27268[(2)] = inst_27014);

(statearr_27176_27268[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (19))){
var inst_26958 = (state_27115[(14)]);
var inst_26957 = (state_27115[(10)]);
var inst_26984 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_26957);
var inst_26985 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26984),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26958)].join('');
var inst_26986 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_26985);
var state_27115__$1 = state_27115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27115__$1,(22),inst_26986);
} else {
if((state_val_27116 === (57))){
var inst_27073 = (state_27115[(2)]);
var state_27115__$1 = state_27115;
var statearr_27177_27269 = state_27115__$1;
(statearr_27177_27269[(2)] = inst_27073);

(statearr_27177_27269[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (68))){
var inst_27102 = (state_27115[(12)]);
var inst_27104 = fluree.db.query.range.coerce_tag_flakes(db,inst_27102);
var state_27115__$1 = state_27115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27115__$1,(71),inst_27104);
} else {
if((state_val_27116 === (11))){
var inst_26971 = (state_27115[(18)]);
var inst_26971__$1 = (state_27115[(2)]);
var inst_26972 = cljs.core.not(inst_26971__$1);
var state_27115__$1 = (function (){var statearr_27179 = state_27115;
(statearr_27179[(18)] = inst_26971__$1);

return statearr_27179;
})();
if(inst_26972){
var statearr_27180_27270 = state_27115__$1;
(statearr_27180_27270[(1)] = (12));

} else {
var statearr_27181_27271 = state_27115__$1;
(statearr_27181_27271[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (9))){
var inst_26958 = (state_27115[(14)]);
var inst_26968 = typeof inst_26958 === 'string';
var state_27115__$1 = state_27115;
var statearr_27182_27272 = state_27115__$1;
(statearr_27182_27272[(2)] = inst_26968);

(statearr_27182_27272[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (5))){
var _ = (function (){var statearr_27183 = state_27115;
(statearr_27183[(4)] = cljs.core.rest((state_27115[(4)])));

return statearr_27183;
})();
var state_27115__$1 = state_27115;
var ex27178 = (state_27115__$1[(2)]);
var statearr_27184_27273 = state_27115__$1;
(statearr_27184_27273[(5)] = ex27178);


if((ex27178 instanceof Error)){
var statearr_27185_27274 = state_27115__$1;
(statearr_27185_27274[(1)] = (4));

(statearr_27185_27274[(5)] = null);

} else {
throw ex27178;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (14))){
var inst_26956 = (state_27115[(9)]);
var inst_26996 = (state_27115[(2)]);
var state_27115__$1 = (function (){var statearr_27186 = state_27115;
(statearr_27186[(7)] = inst_26996);

return statearr_27186;
})();
if(cljs.core.truth_(inst_26956)){
var statearr_27187_27275 = state_27115__$1;
(statearr_27187_27275[(1)] = (23));

} else {
var statearr_27188_27276 = state_27115__$1;
(statearr_27188_27276[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (45))){
var inst_27035 = (state_27115[(2)]);
var state_27115__$1 = state_27115;
var statearr_27189_27277 = state_27115__$1;
(statearr_27189_27277[(2)] = inst_27035);

(statearr_27189_27277[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (53))){
var inst_27047 = (state_27115[(21)]);
var state_27115__$1 = state_27115;
var statearr_27190_27278 = state_27115__$1;
(statearr_27190_27278[(2)] = inst_27047);

(statearr_27190_27278[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (26))){
var inst_27003 = (state_27115[(2)]);
var inst_27004 = fluree.db.util.async.throw_err(inst_27003);
var state_27115__$1 = state_27115;
var statearr_27191_27279 = state_27115__$1;
(statearr_27191_27279[(2)] = inst_27004);

(statearr_27191_27279[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (16))){
var inst_26958 = (state_27115[(14)]);
var inst_26982 = typeof inst_26958 === 'string';
var state_27115__$1 = state_27115;
if(cljs.core.truth_(inst_26982)){
var statearr_27192_27280 = state_27115__$1;
(statearr_27192_27280[(1)] = (19));

} else {
var statearr_27193_27281 = state_27115__$1;
(statearr_27193_27281[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (38))){
var inst_27100 = (state_27115[(2)]);
var state_27115__$1 = state_27115;
var statearr_27194_27282 = state_27115__$1;
(statearr_27194_27282[(2)] = inst_27100);

(statearr_27194_27282[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (30))){
var inst_26960 = (state_27115[(15)]);
var state_27115__$1 = state_27115;
if(cljs.core.truth_(inst_26960)){
var statearr_27195_27283 = state_27115__$1;
(statearr_27195_27283[(1)] = (33));

} else {
var statearr_27196_27284 = state_27115__$1;
(statearr_27196_27284[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (10))){
var inst_26966 = (state_27115[(16)]);
var state_27115__$1 = state_27115;
var statearr_27197_27285 = state_27115__$1;
(statearr_27197_27285[(2)] = inst_26966);

(statearr_27197_27285[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (18))){
var inst_26979 = (state_27115[(2)]);
var inst_26980 = fluree.db.util.async.throw_err(inst_26979);
var state_27115__$1 = state_27115;
var statearr_27198_27286 = state_27115__$1;
(statearr_27198_27286[(2)] = inst_26980);

(statearr_27198_27286[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (52))){
var inst_26996 = (state_27115[(7)]);
var inst_27049 = cljs.core.int_QMARK_(inst_26996);
var state_27115__$1 = state_27115;
var statearr_27199_27287 = state_27115__$1;
(statearr_27199_27287[(2)] = inst_27049);

(statearr_27199_27287[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (67))){
var inst_27090 = (state_27115[(2)]);
var inst_27091 = fluree.db.util.async.throw_err(inst_27090);
var state_27115__$1 = state_27115;
var statearr_27200_27288 = state_27115__$1;
(statearr_27200_27288[(2)] = inst_27091);

(statearr_27200_27288[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (71))){
var inst_27106 = (state_27115[(2)]);
var inst_27107 = fluree.db.util.async.throw_err(inst_27106);
var state_27115__$1 = state_27115;
var statearr_27201_27289 = state_27115__$1;
(statearr_27201_27289[(2)] = inst_27107);

(statearr_27201_27289[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (42))){
var inst_27038 = (state_27115[(2)]);
var state_27115__$1 = state_27115;
if(cljs.core.truth_(inst_27038)){
var statearr_27202_27290 = state_27115__$1;
(statearr_27202_27290[(1)] = (46));

} else {
var statearr_27203_27291 = state_27115__$1;
(statearr_27203_27291[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (37))){
var inst_26957 = (state_27115[(10)]);
var state_27115__$1 = state_27115;
if(cljs.core.truth_(inst_26957)){
var statearr_27204_27292 = state_27115__$1;
(statearr_27204_27292[(1)] = (40));

} else {
var statearr_27205_27293 = state_27115__$1;
(statearr_27205_27293[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (63))){
var inst_27081 = (state_27115[(2)]);
var inst_27082 = fluree.db.util.async.throw_err(inst_27081);
var state_27115__$1 = state_27115;
var statearr_27206_27294 = state_27115__$1;
(statearr_27206_27294[(2)] = inst_27082);

(statearr_27206_27294[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (8))){
var inst_26966 = (state_27115[(16)]);
var inst_26966__$1 = (state_27115[(2)]);
var state_27115__$1 = (function (){var statearr_27207 = state_27115;
(statearr_27207[(16)] = inst_26966__$1);

return statearr_27207;
})();
if(cljs.core.truth_(inst_26966__$1)){
var statearr_27208_27295 = state_27115__$1;
(statearr_27208_27295[(1)] = (9));

} else {
var statearr_27209_27296 = state_27115__$1;
(statearr_27209_27296[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (49))){
var inst_26960 = (state_27115[(15)]);
var inst_26996 = (state_27115[(7)]);
var inst_26959 = (state_27115[(8)]);
var inst_26956 = (state_27115[(9)]);
var inst_26966 = (state_27115[(16)]);
var inst_27040 = (state_27115[(13)]);
var inst_26955 = (state_27115[(17)]);
var inst_26971 = (state_27115[(18)]);
var inst_26957 = (state_27115[(10)]);
var inst_27042 = (function (){var obj_fn = inst_27040;
var t = inst_26959;
var temp__5802__auto__ = inst_27040;
var p = inst_26957;
var idx_predicate_QMARK_ = inst_26960;
var vec__26952 = inst_26955;
var o = inst_26996;
var tag_predicate_QMARK_ = inst_26966;
var s = inst_26956;
var o_coerce_QMARK_ = inst_26971;
return (function (x){
var and__5043__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__5043__auto__;
}
});
})();
var state_27115__$1 = state_27115;
var statearr_27210_27297 = state_27115__$1;
(statearr_27210_27297[(2)] = inst_27042);

(statearr_27210_27297[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__11438__auto__ = null;
var fluree$db$query$range$state_machine__11438__auto____0 = (function (){
var statearr_27211 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27211[(0)] = fluree$db$query$range$state_machine__11438__auto__);

(statearr_27211[(1)] = (1));

return statearr_27211;
});
var fluree$db$query$range$state_machine__11438__auto____1 = (function (state_27115){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_27115);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e27212){var ex__11441__auto__ = e27212;
var statearr_27213_27298 = state_27115;
(statearr_27213_27298[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_27115[(4)]))){
var statearr_27214_27299 = state_27115;
(statearr_27214_27299[(1)] = cljs.core.first((state_27115[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27300 = state_27115;
state_27115 = G__27300;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__11438__auto__ = function(state_27115){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__11438__auto____1.call(this,state_27115);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__11438__auto____0;
fluree$db$query$range$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__11438__auto____1;
return fluree$db$query$range$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_27215 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_27215[(6)] = c__11512__auto__);

return statearr_27215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__27302 = arguments.length;
switch (G__27302) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_27337){
var state_val_27338 = (state_27337[(1)]);
if((state_val_27338 === (7))){
var inst_27324 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_27325 = ["Invalid collection name: ",inst_27324].join('');
var inst_27326 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27327 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_27328 = cljs.core.PersistentHashMap.fromArrays(inst_27326,inst_27327);
var inst_27329 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27325,inst_27328);
var inst_27330 = (function(){throw inst_27329})();
var state_27337__$1 = state_27337;
var statearr_27339_27359 = state_27337__$1;
(statearr_27339_27359[(2)] = inst_27330);

(statearr_27339_27359[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27338 === (1))){
var state_27337__$1 = state_27337;
var statearr_27340_27360 = state_27337__$1;
(statearr_27340_27360[(2)] = null);

(statearr_27340_27360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27338 === (4))){
var inst_27303 = (state_27337[(2)]);
var state_27337__$1 = state_27337;
var statearr_27341_27361 = state_27337__$1;
(statearr_27341_27361[(2)] = inst_27303);

(statearr_27341_27361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27338 === (6))){
var inst_27309 = (state_27337[(7)]);
var inst_27311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27312 = fluree.db.flake.max_subject_id(inst_27309);
var inst_27313 = [inst_27312];
var inst_27314 = (new cljs.core.PersistentVector(null,1,(5),inst_27311,inst_27313,null));
var inst_27315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27316 = fluree.db.flake.min_subject_id(inst_27309);
var inst_27317 = [inst_27316];
var inst_27318 = (new cljs.core.PersistentVector(null,1,(5),inst_27315,inst_27317,null));
var inst_27319 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_27314,cljs.core._LT__EQ_,inst_27318,opts);
var state_27337__$1 = state_27337;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27337__$1,(9),inst_27319);
} else {
if((state_val_27338 === (3))){
var inst_27335 = (state_27337[(2)]);
var state_27337__$1 = state_27337;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27337__$1,inst_27335);
} else {
if((state_val_27338 === (2))){
var inst_27309 = (state_27337[(7)]);
var _ = (function (){var statearr_27343 = state_27337;
(statearr_27343[(4)] = cljs.core.cons((5),(state_27337[(4)])));

return statearr_27343;
})();
var inst_27309__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),name);
var state_27337__$1 = (function (){var statearr_27344 = state_27337;
(statearr_27344[(7)] = inst_27309__$1);

return statearr_27344;
})();
if(cljs.core.truth_(inst_27309__$1)){
var statearr_27345_27362 = state_27337__$1;
(statearr_27345_27362[(1)] = (6));

} else {
var statearr_27346_27363 = state_27337__$1;
(statearr_27346_27363[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27338 === (9))){
var inst_27321 = (state_27337[(2)]);
var inst_27322 = fluree.db.util.async.throw_err(inst_27321);
var state_27337__$1 = state_27337;
var statearr_27347_27364 = state_27337__$1;
(statearr_27347_27364[(2)] = inst_27322);

(statearr_27347_27364[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27338 === (5))){
var _ = (function (){var statearr_27348 = state_27337;
(statearr_27348[(4)] = cljs.core.rest((state_27337[(4)])));

return statearr_27348;
})();
var state_27337__$1 = state_27337;
var ex27342 = (state_27337__$1[(2)]);
var statearr_27349_27365 = state_27337__$1;
(statearr_27349_27365[(5)] = ex27342);


var statearr_27350_27366 = state_27337__$1;
(statearr_27350_27366[(1)] = (4));

(statearr_27350_27366[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27338 === (8))){
var inst_27332 = (state_27337[(2)]);
var _ = (function (){var statearr_27351 = state_27337;
(statearr_27351[(4)] = cljs.core.rest((state_27337[(4)])));

return statearr_27351;
})();
var state_27337__$1 = state_27337;
var statearr_27352_27367 = state_27337__$1;
(statearr_27352_27367[(2)] = inst_27332);

(statearr_27352_27367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__11438__auto__ = null;
var fluree$db$query$range$state_machine__11438__auto____0 = (function (){
var statearr_27353 = [null,null,null,null,null,null,null,null];
(statearr_27353[(0)] = fluree$db$query$range$state_machine__11438__auto__);

(statearr_27353[(1)] = (1));

return statearr_27353;
});
var fluree$db$query$range$state_machine__11438__auto____1 = (function (state_27337){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_27337);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e27354){var ex__11441__auto__ = e27354;
var statearr_27355_27368 = state_27337;
(statearr_27355_27368[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_27337[(4)]))){
var statearr_27356_27369 = state_27337;
(statearr_27356_27369[(1)] = cljs.core.first((state_27337[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27370 = state_27337;
state_27337 = G__27370;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__11438__auto__ = function(state_27337){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__11438__auto____1.call(this,state_27337);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__11438__auto____0;
fluree$db$query$range$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__11438__auto____1;
return fluree$db$query$range$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_27357 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_27357[(6)] = c__11512__auto__);

return statearr_27357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__27374 = flakes;
var vec__27375 = G__27374;
var seq__27376 = cljs.core.seq(vec__27375);
var first__27377 = cljs.core.first(seq__27376);
var seq__27376__$1 = cljs.core.next(seq__27376);
var flake_SINGLEQUOTE_ = first__27377;
var r = seq__27376__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__27374__$1 = G__27374;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__27383 = G__27374__$1;
var seq__27384 = cljs.core.seq(vec__27383);
var first__27385 = cljs.core.first(seq__27384);
var seq__27384__$1 = cljs.core.next(seq__27384);
var flake_SINGLEQUOTE___$1 = first__27385;
var r__$1 = seq__27384__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e27387){var e = e27387;
return null;
}})();
var map__27386 = cmd_map;
var map__27386__$1 = cljs.core.__destructure_map(map__27386);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27386__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27386__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27386__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27386__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27386__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27386__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__27388 = r__$1;
var G__27389 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__27374__$1 = G__27388;
result_STAR___$1 = G__27389;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__27398 = blocks;
var vec__27399 = G__27398;
var seq__27400 = cljs.core.seq(vec__27399);
var first__27401 = cljs.core.first(seq__27400);
var seq__27400__$1 = cljs.core.next(seq__27400);
var block_SINGLEQUOTE_ = first__27401;
var r = seq__27400__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__27398__$1 = G__27398;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__27406 = G__27398__$1;
var seq__27407 = cljs.core.seq(vec__27406);
var first__27408 = cljs.core.first(seq__27407);
var seq__27407__$1 = cljs.core.next(seq__27407);
var block_SINGLEQUOTE___$1 = first__27408;
var r__$1 = seq__27407__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__27409 = block_SINGLEQUOTE___$1;
var map__27409__$1 = cljs.core.__destructure_map(map__27409);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27409__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27409__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27409__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__27398__$1,result_STAR___$1,map__27409,map__27409__$1,block,t,flakes,vec__27406,seq__27407,first__27408,seq__27407__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27398,vec__27399,seq__27400,first__27401,seq__27400__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__27390_SHARP_){
var f = p1__27390_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__27398__$1,result_STAR___$1,map__27409,map__27409__$1,block,t,flakes,vec__27406,seq__27407,first__27408,seq__27407__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27398,vec__27399,seq__27400,first__27401,seq__27400__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__27398__$1,result_STAR___$1,map__27409,map__27409__$1,block,t,flakes,prev_hash,vec__27406,seq__27407,first__27408,seq__27407__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27398,vec__27399,seq__27400,first__27401,seq__27400__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__27391_SHARP_){
var f = p1__27391_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__27398__$1,result_STAR___$1,map__27409,map__27409__$1,block,t,flakes,prev_hash,vec__27406,seq__27407,first__27408,seq__27407__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27398,vec__27399,seq__27400,first__27401,seq__27400__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__27398__$1,result_STAR___$1,map__27409,map__27409__$1,block,t,flakes,prev_hash,hash,vec__27406,seq__27407,first__27408,seq__27407__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27398,vec__27399,seq__27400,first__27401,seq__27400__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__27392_SHARP_){
var f = p1__27392_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__27398__$1,result_STAR___$1,map__27409,map__27409__$1,block,t,flakes,prev_hash,hash,vec__27406,seq__27407,first__27408,seq__27407__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27398,vec__27399,seq__27400,first__27401,seq__27400__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__27398__$1,result_STAR___$1,map__27409,map__27409__$1,block,t,flakes,prev_hash,hash,instant,vec__27406,seq__27407,first__27408,seq__27407__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27398,vec__27399,seq__27400,first__27401,seq__27400__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__27393_SHARP_){
var f = p1__27393_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__27398__$1,result_STAR___$1,map__27409,map__27409__$1,block,t,flakes,prev_hash,hash,instant,vec__27406,seq__27407,first__27408,seq__27407__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27398,vec__27399,seq__27400,first__27401,seq__27400__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__27398__$1,result_STAR___$1,map__27409,map__27409__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__27406,seq__27407,first__27408,seq__27407__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27398,vec__27399,seq__27400,first__27401,seq__27400__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__27394_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__27394_SHARP_.p,(106));
});})(G__27398__$1,result_STAR___$1,map__27409,map__27409__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__27406,seq__27407,first__27408,seq__27407__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27398,vec__27399,seq__27400,first__27401,seq__27400__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__27410 = r__$1;
var G__27411 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__27398__$1 = G__27410;
result_STAR___$1 = G__27411;
continue;
}
break;
}
});
