// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_27429){
var state_val_27430 = (state_27429[(1)]);
if((state_val_27430 === (1))){
var state_27429__$1 = state_27429;
var statearr_27431_27445 = state_27429__$1;
(statearr_27431_27445[(2)] = null);

(statearr_27431_27445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27430 === (2))){
var _ = (function (){var statearr_27432 = state_27429;
(statearr_27432[(4)] = cljs.core.cons((5),(state_27429[(4)])));

return statearr_27432;
})();
var inst_27420 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_27429__$1 = state_27429;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27429__$1,(6),inst_27420);
} else {
if((state_val_27430 === (3))){
var inst_27427 = (state_27429[(2)]);
var state_27429__$1 = state_27429;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27429__$1,inst_27427);
} else {
if((state_val_27430 === (4))){
var inst_27414 = (state_27429[(2)]);
var state_27429__$1 = state_27429;
var statearr_27434_27446 = state_27429__$1;
(statearr_27434_27446[(2)] = inst_27414);

(statearr_27434_27446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27430 === (5))){
var _ = (function (){var statearr_27435 = state_27429;
(statearr_27435[(4)] = cljs.core.rest((state_27429[(4)])));

return statearr_27435;
})();
var state_27429__$1 = state_27429;
var ex27433 = (state_27429__$1[(2)]);
var statearr_27436_27447 = state_27429__$1;
(statearr_27436_27447[(5)] = ex27433);


if((ex27433 instanceof Error)){
var statearr_27437_27448 = state_27429__$1;
(statearr_27437_27448[(1)] = (4));

(statearr_27437_27448[(5)] = null);

} else {
throw ex27433;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27430 === (6))){
var inst_27422 = (state_27429[(2)]);
var inst_27423 = fluree.db.util.async.throw_err(inst_27422);
var inst_27424 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_27423);
var _ = (function (){var statearr_27438 = state_27429;
(statearr_27438[(4)] = cljs.core.rest((state_27429[(4)])));

return statearr_27438;
})();
var state_27429__$1 = state_27429;
var statearr_27439_27449 = state_27429__$1;
(statearr_27439_27449[(2)] = inst_27424);

(statearr_27439_27449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__11438__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__11438__auto____0 = (function (){
var statearr_27440 = [null,null,null,null,null,null,null];
(statearr_27440[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__11438__auto__);

(statearr_27440[(1)] = (1));

return statearr_27440;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__11438__auto____1 = (function (state_27429){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_27429);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e27441){var ex__11441__auto__ = e27441;
var statearr_27442_27450 = state_27429;
(statearr_27442_27450[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_27429[(4)]))){
var statearr_27443_27451 = state_27429;
(statearr_27443_27451[(1)] = cljs.core.first((state_27429[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27452 = state_27429;
state_27429 = G__27452;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__11438__auto__ = function(state_27429){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__11438__auto____1.call(this,state_27429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__11438__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__11438__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_27444 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_27444[(6)] = c__11512__auto__);

return statearr_27444;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_27484){
var state_val_27485 = (state_27484[(1)]);
if((state_val_27485 === (7))){
var inst_27468 = (state_27484[(7)]);
var inst_27470 = cljs.core.empty_QMARK_(inst_27468);
var inst_27471 = (!(inst_27470));
var state_27484__$1 = state_27484;
var statearr_27486_27510 = state_27484__$1;
(statearr_27486_27510[(2)] = inst_27471);

(statearr_27486_27510[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (1))){
var state_27484__$1 = state_27484;
var statearr_27487_27511 = state_27484__$1;
(statearr_27487_27511[(2)] = null);

(statearr_27487_27511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (4))){
var inst_27454 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
var statearr_27488_27512 = state_27484__$1;
(statearr_27488_27512[(2)] = inst_27454);

(statearr_27488_27512[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (6))){
var inst_27468 = (state_27484[(7)]);
var inst_27460 = (state_27484[(8)]);
var inst_27466 = (state_27484[(2)]);
var inst_27467 = fluree.db.util.async.throw_err(inst_27466);
var inst_27468__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_27460,inst_27467);
var state_27484__$1 = (function (){var statearr_27489 = state_27484;
(statearr_27489[(7)] = inst_27468__$1);

return statearr_27489;
})();
if(cljs.core.truth_(inst_27468__$1)){
var statearr_27490_27513 = state_27484__$1;
(statearr_27490_27513[(1)] = (7));

} else {
var statearr_27491_27514 = state_27484__$1;
(statearr_27491_27514[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (3))){
var inst_27482 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27484__$1,inst_27482);
} else {
if((state_val_27485 === (12))){
var inst_27479 = (state_27484[(2)]);
var _ = (function (){var statearr_27492 = state_27484;
(statearr_27492[(4)] = cljs.core.rest((state_27484[(4)])));

return statearr_27492;
})();
var state_27484__$1 = state_27484;
var statearr_27493_27515 = state_27484__$1;
(statearr_27493_27515[(2)] = inst_27479);

(statearr_27493_27515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (2))){
var _ = (function (){var statearr_27494 = state_27484;
(statearr_27494[(4)] = cljs.core.cons((5),(state_27484[(4)])));

return statearr_27494;
})();
var inst_27460 = (function (){return (function (p1__27453_SHARP_){
return p1__27453_SHARP_.o;
});
})();
var inst_27461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27462 = [pred_id];
var inst_27463 = (new cljs.core.PersistentVector(null,1,(5),inst_27461,inst_27462,null));
var inst_27464 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_27463);
var state_27484__$1 = (function (){var statearr_27495 = state_27484;
(statearr_27495[(8)] = inst_27460);

return statearr_27495;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27484__$1,(6),inst_27464);
} else {
if((state_val_27485 === (11))){
var state_27484__$1 = state_27484;
var statearr_27497_27516 = state_27484__$1;
(statearr_27497_27516[(2)] = true);

(statearr_27497_27516[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (9))){
var inst_27474 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
if(cljs.core.truth_(inst_27474)){
var statearr_27498_27517 = state_27484__$1;
(statearr_27498_27517[(1)] = (10));

} else {
var statearr_27499_27518 = state_27484__$1;
(statearr_27499_27518[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (5))){
var _ = (function (){var statearr_27500 = state_27484;
(statearr_27500[(4)] = cljs.core.rest((state_27484[(4)])));

return statearr_27500;
})();
var state_27484__$1 = state_27484;
var ex27496 = (state_27484__$1[(2)]);
var statearr_27501_27519 = state_27484__$1;
(statearr_27501_27519[(5)] = ex27496);


if((ex27496 instanceof Error)){
var statearr_27502_27520 = state_27484__$1;
(statearr_27502_27520[(1)] = (4));

(statearr_27502_27520[(5)] = null);

} else {
throw ex27496;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (10))){
var inst_27468 = (state_27484[(7)]);
var inst_27476 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_27468);
var state_27484__$1 = state_27484;
var statearr_27503_27521 = state_27484__$1;
(statearr_27503_27521[(2)] = inst_27476);

(statearr_27503_27521[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (8))){
var inst_27468 = (state_27484[(7)]);
var state_27484__$1 = state_27484;
var statearr_27504_27522 = state_27484__$1;
(statearr_27504_27522[(2)] = inst_27468);

(statearr_27504_27522[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11438__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11438__auto____0 = (function (){
var statearr_27505 = [null,null,null,null,null,null,null,null,null];
(statearr_27505[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11438__auto__);

(statearr_27505[(1)] = (1));

return statearr_27505;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11438__auto____1 = (function (state_27484){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_27484);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e27506){var ex__11441__auto__ = e27506;
var statearr_27507_27523 = state_27484;
(statearr_27507_27523[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_27484[(4)]))){
var statearr_27508_27524 = state_27484;
(statearr_27508_27524[(1)] = cljs.core.first((state_27484[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27525 = state_27484;
state_27484 = G__27525;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11438__auto__ = function(state_27484){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11438__auto____1.call(this,state_27484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11438__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11438__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_27509 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_27509[(6)] = c__11512__auto__);

return statearr_27509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_27606){
var state_val_27607 = (state_27606[(1)]);
if((state_val_27607 === (7))){
var state_27606__$1 = state_27606;
var statearr_27608_27646 = state_27606__$1;
(statearr_27608_27646[(2)] = flakes);

(statearr_27608_27646[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27607 === (20))){
var inst_27563 = (state_27606[(7)]);
var inst_27596 = (state_27606[(2)]);
var inst_27555 = inst_27563;
var inst_27556 = inst_27596;
var state_27606__$1 = (function (){var statearr_27609 = state_27606;
(statearr_27609[(8)] = inst_27556);

(statearr_27609[(9)] = inst_27555);

return statearr_27609;
})();
var statearr_27610_27647 = state_27606__$1;
(statearr_27610_27647[(2)] = null);

(statearr_27610_27647[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27607 === (1))){
var state_27606__$1 = state_27606;
var statearr_27611_27648 = state_27606__$1;
(statearr_27611_27648[(2)] = null);

(statearr_27611_27648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27607 === (4))){
var inst_27528 = (state_27606[(2)]);
var state_27606__$1 = state_27606;
var statearr_27612_27649 = state_27606__$1;
(statearr_27612_27649[(2)] = inst_27528);

(statearr_27612_27649[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27607 === (15))){
var inst_27562 = (state_27606[(10)]);
var inst_27580 = inst_27562.o;
var state_27606__$1 = state_27606;
var statearr_27613_27650 = state_27606__$1;
(statearr_27613_27650[(2)] = inst_27580);

(statearr_27613_27650[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27607 === (13))){
var inst_27599 = (state_27606[(2)]);
var state_27606__$1 = state_27606;
var statearr_27614_27651 = state_27606__$1;
(statearr_27614_27651[(2)] = inst_27599);

(statearr_27614_27651[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27607 === (6))){
var inst_27535 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_27606__$1 = state_27606;
var statearr_27615_27652 = state_27606__$1;
(statearr_27615_27652[(2)] = inst_27535);

(statearr_27615_27652[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27607 === (17))){
var inst_27577 = (state_27606[(2)]);
var inst_27578 = fluree.db.util.async.throw_err(inst_27577);
var state_27606__$1 = state_27606;
var statearr_27616_27653 = state_27606__$1;
(statearr_27616_27653[(2)] = inst_27578);

(statearr_27616_27653[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27607 === (3))){
var inst_27604 = (state_27606[(2)]);
var state_27606__$1 = state_27606;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27606__$1,inst_27604);
} else {
if((state_val_27607 === (12))){
var inst_27569 = (state_27606[(11)]);
var inst_27562 = (state_27606[(10)]);
var inst_27567 = inst_27562.p;
var inst_27568 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_27567);
var inst_27569__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_27568);
var inst_27570 = inst_27562.op;
var inst_27571 = inst_27570 === false;
var inst_27572 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_27569__$1);
var state_27606__$1 = (function (){var statearr_27617 = state_27606;
(statearr_27617[(11)] = inst_27569__$1);

(statearr_27617[(12)] = inst_27571);

return statearr_27617;
})();
if(inst_27572){
var statearr_27618_27654 = state_27606__$1;
(statearr_27618_27654[(1)] = (14));

} else {
var statearr_27619_27655 = state_27606__$1;
(statearr_27619_27655[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27607 === (2))){
var _ = (function (){var statearr_27620 = state_27606;
(statearr_27620[(4)] = cljs.core.cons((5),(state_27606[(4)])));

return statearr_27620;
})();
var state_27606__$1 = state_27606;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_27621_27656 = state_27606__$1;
(statearr_27621_27656[(1)] = (6));

} else {
var statearr_27622_27657 = state_27606__$1;
(statearr_27622_27657[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27607 === (19))){
var inst_27582 = (state_27606[(13)]);
var inst_27556 = (state_27606[(8)]);
var inst_27569 = (state_27606[(11)]);
var inst_27562 = (state_27606[(10)]);
var inst_27590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27591 = inst_27562.s;
var inst_27592 = [inst_27591,inst_27569,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_27593 = (new cljs.core.PersistentVector(null,3,(5),inst_27590,inst_27592,null));
var inst_27594 = cljs.core.assoc_in(inst_27556,inst_27593,inst_27582);
var state_27606__$1 = state_27606;
var statearr_27623_27658 = state_27606__$1;
(statearr_27623_27658[(2)] = inst_27594);

(statearr_27623_27658[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27607 === (11))){
var inst_27556 = (state_27606[(8)]);
var state_27606__$1 = state_27606;
var statearr_27625_27659 = state_27606__$1;
(statearr_27625_27659[(2)] = inst_27556);

(statearr_27625_27659[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27607 === (9))){
var inst_27555 = (state_27606[(9)]);
var inst_27562 = (state_27606[(10)]);
var inst_27561 = cljs.core.seq(inst_27555);
var inst_27562__$1 = cljs.core.first(inst_27561);
var inst_27563 = cljs.core.next(inst_27561);
var inst_27564 = cljs.core.not(inst_27562__$1);
var state_27606__$1 = (function (){var statearr_27626 = state_27606;
(statearr_27626[(7)] = inst_27563);

(statearr_27626[(10)] = inst_27562__$1);

return statearr_27626;
})();
if(inst_27564){
var statearr_27627_27660 = state_27606__$1;
(statearr_27627_27660[(1)] = (11));

} else {
var statearr_27628_27661 = state_27606__$1;
(statearr_27628_27661[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27607 === (5))){
var _ = (function (){var statearr_27629 = state_27606;
(statearr_27629[(4)] = cljs.core.rest((state_27606[(4)])));

return statearr_27629;
})();
var state_27606__$1 = state_27606;
var ex27624 = (state_27606__$1[(2)]);
var statearr_27630_27662 = state_27606__$1;
(statearr_27630_27662[(5)] = ex27624);


if((ex27624 instanceof Error)){
var statearr_27631_27663 = state_27606__$1;
(statearr_27631_27663[(1)] = (4));

(statearr_27631_27663[(5)] = null);

} else {
throw ex27624;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27607 === (14))){
var inst_27562 = (state_27606[(10)]);
var inst_27574 = inst_27562.o;
var inst_27575 = fluree.db.query.schema.convert_type_to_kw(inst_27574,db);
var state_27606__$1 = state_27606;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27606__$1,(17),inst_27575);
} else {
if((state_val_27607 === (16))){
var inst_27571 = (state_27606[(12)]);
var inst_27582 = (state_27606[(2)]);
var state_27606__$1 = (function (){var statearr_27632 = state_27606;
(statearr_27632[(13)] = inst_27582);

return statearr_27632;
})();
if(cljs.core.truth_(inst_27571)){
var statearr_27633_27664 = state_27606__$1;
(statearr_27633_27664[(1)] = (18));

} else {
var statearr_27634_27665 = state_27606__$1;
(statearr_27634_27665[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27607 === (10))){
var inst_27601 = (state_27606[(2)]);
var _ = (function (){var statearr_27635 = state_27606;
(statearr_27635[(4)] = cljs.core.rest((state_27606[(4)])));

return statearr_27635;
})();
var state_27606__$1 = state_27606;
var statearr_27636_27666 = state_27606__$1;
(statearr_27636_27666[(2)] = inst_27601);

(statearr_27636_27666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27607 === (18))){
var inst_27582 = (state_27606[(13)]);
var inst_27556 = (state_27606[(8)]);
var inst_27569 = (state_27606[(11)]);
var inst_27562 = (state_27606[(10)]);
var inst_27584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27585 = inst_27562.s;
var inst_27586 = [inst_27585,inst_27569,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_27587 = (new cljs.core.PersistentVector(null,3,(5),inst_27584,inst_27586,null));
var inst_27588 = cljs.core.assoc_in(inst_27556,inst_27587,inst_27582);
var state_27606__$1 = state_27606;
var statearr_27637_27667 = state_27606__$1;
(statearr_27637_27667[(2)] = inst_27588);

(statearr_27637_27667[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27607 === (8))){
var inst_27538 = (state_27606[(2)]);
var inst_27539 = cljs.core.PersistentHashSet.EMPTY;
var inst_27540 = cljs.core.vals(tempids);
var inst_27541 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_27539,inst_27540);
var inst_27542 = (function (){var pred_flakes = inst_27538;
var is_new_QMARK_ = inst_27541;
return (function (p1__27527_SHARP_,p2__27526_SHARP_){
var f = p2__27526_SHARP_;
return cljs.core.assoc_in(p1__27527_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__27638 = f.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__27638) : is_new_QMARK_.call(null,G__27638));
})()));
});
})();
var inst_27543 = cljs.core.PersistentHashMap.EMPTY;
var inst_27544 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_27542,inst_27543,inst_27538);
var inst_27552 = cljs.core.seq(inst_27538);
var inst_27553 = cljs.core.first(inst_27552);
var inst_27554 = cljs.core.next(inst_27552);
var inst_27555 = inst_27538;
var inst_27556 = inst_27544;
var state_27606__$1 = (function (){var statearr_27639 = state_27606;
(statearr_27639[(8)] = inst_27556);

(statearr_27639[(9)] = inst_27555);

(statearr_27639[(14)] = inst_27554);

(statearr_27639[(15)] = inst_27553);

return statearr_27639;
})();
var statearr_27640_27668 = state_27606__$1;
(statearr_27640_27668[(2)] = null);

(statearr_27640_27668[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__11438__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__11438__auto____0 = (function (){
var statearr_27641 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27641[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__11438__auto__);

(statearr_27641[(1)] = (1));

return statearr_27641;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__11438__auto____1 = (function (state_27606){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_27606);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e27642){var ex__11441__auto__ = e27642;
var statearr_27643_27669 = state_27606;
(statearr_27643_27669[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_27606[(4)]))){
var statearr_27644_27670 = state_27606;
(statearr_27644_27670[(1)] = cljs.core.first((state_27606[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27671 = state_27606;
state_27606 = G__27671;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__11438__auto__ = function(state_27606){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__11438__auto____1.call(this,state_27606);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__11438__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__11438__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_27645 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_27645[(6)] = c__11512__auto__);

return statearr_27645;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__27673 = arguments.length;
switch (G__27673) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__27676 = arguments.length;
switch (G__27676) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_27988){
var state_val_27989 = (state_27988[(1)]);
if((state_val_27989 === (121))){
var inst_27943 = (state_27988[(7)]);
var state_27988__$1 = state_27988;
var statearr_27990_28183 = state_27988__$1;
(statearr_27990_28183[(2)] = inst_27943);

(statearr_27990_28183[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (65))){
var inst_27842 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
if(cljs.core.truth_(inst_27842)){
var statearr_27991_28184 = state_27988__$1;
(statearr_27991_28184[(1)] = (66));

} else {
var statearr_27992_28185 = state_27988__$1;
(statearr_27992_28185[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (70))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27852 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_27853 = (inst_27848.cljs$core$IFn$_invoke$arity$5 ? inst_27848.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_27852,null) : inst_27848.call(null,cljs.core.PersistentArrayMap,null,3,inst_27852,null));
var inst_27854 = (inst_27848.cljs$core$IFn$_invoke$arity$4 ? inst_27848.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_27853,null) : inst_27848.call(null,cljs.core.PersistentHashSet,null,inst_27853,null));
var inst_27855 = (inst_27854.cljs$core$IFn$_invoke$arity$1 ? inst_27854.cljs$core$IFn$_invoke$arity$1(inst_27847) : inst_27854.call(null,inst_27847));
var state_27988__$1 = state_27988;
if(cljs.core.truth_(inst_27855)){
var statearr_27993_28186 = state_27988__$1;
(statearr_27993_28186[(1)] = (72));

} else {
var statearr_27994_28187 = state_27988__$1;
(statearr_27994_28187[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (62))){
var inst_27832 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_27995_28188 = state_27988__$1;
(statearr_27995_28188[(2)] = inst_27832);

(statearr_27995_28188[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (74))){
var inst_27938 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_27996_28189 = state_27988__$1;
(statearr_27996_28189[(2)] = inst_27938);

(statearr_27996_28189[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (110))){
var inst_27965 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
if(cljs.core.truth_(inst_27965)){
var statearr_27997_28190 = state_27988__$1;
(statearr_27997_28190[(1)] = (117));

} else {
var statearr_27998_28191 = state_27988__$1;
(statearr_27998_28191[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (7))){
var inst_27983 = (state_27988[(2)]);
var _ = (function (){var statearr_27999 = state_27988;
(statearr_27999[(4)] = cljs.core.rest((state_27988[(4)])));

return statearr_27999;
})();
var state_27988__$1 = state_27988;
var statearr_28000_28192 = state_27988__$1;
(statearr_28000_28192[(2)] = inst_27983);

(statearr_28000_28192[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (59))){
var inst_27836 = (state_27988[(10)]);
var inst_27716 = (state_27988[(11)]);
var inst_27835 = (state_27988[(2)]);
var inst_27836__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_27716);
var state_27988__$1 = (function (){var statearr_28001 = state_27988;
(statearr_28001[(10)] = inst_27836__$1);

(statearr_28001[(12)] = inst_27835);

return statearr_28001;
})();
if(cljs.core.truth_(inst_27836__$1)){
var statearr_28002_28193 = state_27988__$1;
(statearr_28002_28193[(1)] = (63));

} else {
var statearr_28003_28194 = state_27988__$1;
(statearr_28003_28194[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (86))){
var inst_27878 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28004_28195 = state_27988__$1;
(statearr_28004_28195[(2)] = inst_27878);

(statearr_28004_28195[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (20))){
var inst_27716 = (state_27988[(11)]);
var inst_27742 = (state_27988[(13)]);
var inst_27742__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_27716);
var state_27988__$1 = (function (){var statearr_28005 = state_27988;
(statearr_28005[(13)] = inst_27742__$1);

return statearr_28005;
})();
if(cljs.core.truth_(inst_27742__$1)){
var statearr_28006_28196 = state_27988__$1;
(statearr_28006_28196[(1)] = (23));

} else {
var statearr_28007_28197 = state_27988__$1;
(statearr_28007_28197[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (72))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27857 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_27847,inst_27848,throw_QMARK_);
var state_27988__$1 = state_27988;
var statearr_28008_28198 = state_27988__$1;
(statearr_28008_28198[(2)] = inst_27857);

(statearr_28008_28198[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (58))){
var inst_27797 = (state_27988[(14)]);
var state_27988__$1 = state_27988;
var statearr_28009_28199 = state_27988__$1;
(statearr_28009_28199[(2)] = inst_27797);

(statearr_28009_28199[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (60))){
var inst_27704 = (state_27988[(15)]);
var inst_27715 = (state_27988[(16)]);
var inst_27823 = fluree.db.dbproto._p_prop(inst_27704,new cljs.core.Keyword(null,"name","name",1843675177),inst_27715);
var inst_27824 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27823)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_27825 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27826 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_27827 = cljs.core.PersistentHashMap.fromArrays(inst_27825,inst_27826);
var inst_27828 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27824,inst_27827);
var inst_27829 = (function(){throw inst_27828})();
var state_27988__$1 = state_27988;
var statearr_28010_28200 = state_27988__$1;
(statearr_28010_28200[(2)] = inst_27829);

(statearr_28010_28200[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (27))){
var inst_27745 = (state_27988[(17)]);
var state_27988__$1 = state_27988;
var statearr_28011_28201 = state_27988__$1;
(statearr_28011_28201[(2)] = inst_27745);

(statearr_28011_28201[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (1))){
var state_27988__$1 = state_27988;
var statearr_28012_28202 = state_27988__$1;
(statearr_28012_28202[(2)] = null);

(statearr_28012_28202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (69))){
var inst_27835 = (state_27988[(12)]);
var state_27988__$1 = state_27988;
var statearr_28013_28203 = state_27988__$1;
(statearr_28013_28203[(2)] = inst_27835);

(statearr_28013_28203[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (101))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27916 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_27847,inst_27848,throw_QMARK_);
var state_27988__$1 = state_27988;
var statearr_28014_28204 = state_27988__$1;
(statearr_28014_28204[(2)] = inst_27916);

(statearr_28014_28204[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (24))){
var inst_27742 = (state_27988[(13)]);
var state_27988__$1 = state_27988;
var statearr_28015_28205 = state_27988__$1;
(statearr_28015_28205[(2)] = inst_27742);

(statearr_28015_28205[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (102))){
var inst_27918 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28016_28206 = state_27988__$1;
(statearr_28016_28206[(2)] = inst_27918);

(statearr_28016_28206[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (55))){
var inst_27814 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28017_28207 = state_27988__$1;
(statearr_28017_28207[(2)] = inst_27814);

(statearr_28017_28207[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (85))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27876 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_27847,inst_27848,throw_QMARK_);
var state_27988__$1 = state_27988;
var statearr_28018_28208 = state_27988__$1;
(statearr_28018_28208[(2)] = inst_27876);

(statearr_28018_28208[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (39))){
var inst_27779 = (state_27988[(18)]);
var state_27988__$1 = state_27988;
var statearr_28019_28209 = state_27988__$1;
(statearr_28019_28209[(2)] = inst_27779);

(statearr_28019_28209[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (88))){
var inst_27835 = (state_27988[(12)]);
var state_27988__$1 = state_27988;
var statearr_28020_28210 = state_27988__$1;
(statearr_28020_28210[(2)] = inst_27835);

(statearr_28020_28210[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (46))){
var inst_27798 = (state_27988[(19)]);
var inst_27716 = (state_27988[(11)]);
var inst_27797 = (state_27988[(2)]);
var inst_27798__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_27716);
var state_27988__$1 = (function (){var statearr_28021 = state_27988;
(statearr_28021[(14)] = inst_27797);

(statearr_28021[(19)] = inst_27798__$1);

return statearr_28021;
})();
if(cljs.core.truth_(inst_27798__$1)){
var statearr_28022_28211 = state_27988__$1;
(statearr_28022_28211[(1)] = (47));

} else {
var statearr_28023_28212 = state_27988__$1;
(statearr_28023_28212[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (4))){
var inst_27677 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28024_28213 = state_27988__$1;
(statearr_28024_28213[(2)] = inst_27677);

(statearr_28024_28213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (77))){
var inst_27936 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28025_28214 = state_27988__$1;
(statearr_28025_28214[(2)] = inst_27936);

(statearr_28025_28214[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (106))){
var inst_27928 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28026_28215 = state_27988__$1;
(statearr_28026_28215[(2)] = inst_27928);

(statearr_28026_28215[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (119))){
var inst_27714 = (state_27988[(20)]);
var inst_27978 = (state_27988[(2)]);
var inst_27703 = inst_27714;
var inst_27704 = inst_27978;
var state_27988__$1 = (function (){var statearr_28027 = state_27988;
(statearr_28027[(21)] = inst_27703);

(statearr_28027[(15)] = inst_27704);

return statearr_28027;
})();
var statearr_28028_28216 = state_27988__$1;
(statearr_28028_28216[(2)] = null);

(statearr_28028_28216[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (95))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27900 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_27901 = (inst_27848.cljs$core$IFn$_invoke$arity$5 ? inst_27848.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_27900,null) : inst_27848.call(null,cljs.core.PersistentArrayMap,null,5,inst_27900,null));
var inst_27902 = (inst_27848.cljs$core$IFn$_invoke$arity$4 ? inst_27848.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_27901,null) : inst_27848.call(null,cljs.core.PersistentHashSet,null,inst_27901,null));
var inst_27903 = (inst_27902.cljs$core$IFn$_invoke$arity$1 ? inst_27902.cljs$core$IFn$_invoke$arity$1(inst_27847) : inst_27902.call(null,inst_27847));
var state_27988__$1 = state_27988;
if(cljs.core.truth_(inst_27903)){
var statearr_28029_28217 = state_27988__$1;
(statearr_28029_28217[(1)] = (96));

} else {
var statearr_28030_28218 = state_27988__$1;
(statearr_28030_28218[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (54))){
var inst_27805 = (state_27988[(22)]);
var state_27988__$1 = state_27988;
var statearr_28031_28219 = state_27988__$1;
(statearr_28031_28219[(2)] = inst_27805);

(statearr_28031_28219[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (92))){
var inst_27835 = (state_27988[(12)]);
var state_27988__$1 = state_27988;
var statearr_28032_28220 = state_27988__$1;
(statearr_28032_28220[(2)] = inst_27835);

(statearr_28032_28220[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (104))){
var inst_27835 = (state_27988[(12)]);
var state_27988__$1 = state_27988;
var statearr_28033_28221 = state_27988__$1;
(statearr_28033_28221[(2)] = inst_27835);

(statearr_28033_28221[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (15))){
var inst_27724 = (state_27988[(23)]);
var state_27988__$1 = state_27988;
var statearr_28034_28222 = state_27988__$1;
(statearr_28034_28222[(2)] = inst_27724);

(statearr_28034_28222[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (48))){
var inst_27798 = (state_27988[(19)]);
var state_27988__$1 = state_27988;
var statearr_28035_28223 = state_27988__$1;
(statearr_28035_28223[(2)] = inst_27798);

(statearr_28035_28223[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (50))){
var inst_27805 = (state_27988[(22)]);
var inst_27716 = (state_27988[(11)]);
var inst_27803 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_27716);
var inst_27804 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_27803);
var inst_27805__$1 = inst_27804 === true;
var state_27988__$1 = (function (){var statearr_28036 = state_27988;
(statearr_28036[(22)] = inst_27805__$1);

return statearr_28036;
})();
if(cljs.core.truth_(inst_27805__$1)){
var statearr_28037_28224 = state_27988__$1;
(statearr_28037_28224[(1)] = (53));

} else {
var statearr_28038_28225 = state_27988__$1;
(statearr_28038_28225[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (116))){
var inst_27959 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28039_28226 = state_27988__$1;
(statearr_28039_28226[(2)] = inst_27959);

(statearr_28039_28226[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (75))){
var inst_27848 = (state_27988[(9)]);
var state_27988__$1 = state_27988;
var G__28040_28227 = inst_27848;
var G__28040_28228__$1 = (((G__28040_28227 instanceof cljs.core.Keyword))?G__28040_28227.fqn:null);
switch (G__28040_28228__$1) {
case "long":
var statearr_28041_28230 = state_27988__$1;
(statearr_28041_28230[(1)] = (79));


break;
case "bigint":
var statearr_28042_28231 = state_27988__$1;
(statearr_28042_28231[(1)] = (83));


break;
case "double":
var statearr_28043_28232 = state_27988__$1;
(statearr_28043_28232[(1)] = (87));


break;
case "float":
var statearr_28044_28233 = state_27988__$1;
(statearr_28044_28233[(1)] = (91));


break;
case "bigdec":
var statearr_28045_28234 = state_27988__$1;
(statearr_28045_28234[(1)] = (95));


break;
case "string":
var statearr_28046_28235 = state_27988__$1;
(statearr_28046_28235[(1)] = (99));


break;
case "instant":
var statearr_28047_28236 = state_27988__$1;
(statearr_28047_28236[(1)] = (103));


break;
default:
var statearr_28048_28237 = state_27988__$1;
(statearr_28048_28237[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (99))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27910 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_27911 = (inst_27848.cljs$core$IFn$_invoke$arity$5 ? inst_27848.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_27910,null) : inst_27848.call(null,cljs.core.PersistentArrayMap,null,5,inst_27910,null));
var inst_27912 = (inst_27848.cljs$core$IFn$_invoke$arity$4 ? inst_27848.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_27911,null) : inst_27848.call(null,cljs.core.PersistentHashSet,null,inst_27911,null));
var inst_27913 = (inst_27912.cljs$core$IFn$_invoke$arity$1 ? inst_27912.cljs$core$IFn$_invoke$arity$1(inst_27847) : inst_27912.call(null,inst_27847));
var state_27988__$1 = state_27988;
if(cljs.core.truth_(inst_27913)){
var statearr_28049_28238 = state_27988__$1;
(statearr_28049_28238[(1)] = (100));

} else {
var statearr_28050_28239 = state_27988__$1;
(statearr_28050_28239[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (21))){
var inst_27740 = (state_27988[(24)]);
var state_27988__$1 = state_27988;
var statearr_28051_28240 = state_27988__$1;
(statearr_28051_28240[(2)] = inst_27740);

(statearr_28051_28240[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (31))){
var inst_27756 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28052_28241 = state_27988__$1;
(statearr_28052_28241[(2)] = inst_27756);

(statearr_28052_28241[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (113))){
var inst_27962 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28053_28242 = state_27988__$1;
(statearr_28053_28242[(2)] = inst_27962);

(statearr_28053_28242[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (32))){
var state_27988__$1 = state_27988;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_28054_28243 = state_27988__$1;
(statearr_28054_28243[(1)] = (35));

} else {
var statearr_28055_28244 = state_27988__$1;
(statearr_28055_28244[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (40))){
var inst_27792 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
if(cljs.core.truth_(inst_27792)){
var statearr_28056_28245 = state_27988__$1;
(statearr_28056_28245[(1)] = (44));

} else {
var statearr_28057_28246 = state_27988__$1;
(statearr_28057_28246[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (91))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27890 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_27891 = (inst_27848.cljs$core$IFn$_invoke$arity$5 ? inst_27848.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_27890,null) : inst_27848.call(null,cljs.core.PersistentArrayMap,null,3,inst_27890,null));
var inst_27892 = (inst_27848.cljs$core$IFn$_invoke$arity$4 ? inst_27848.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_27891,null) : inst_27848.call(null,cljs.core.PersistentHashSet,null,inst_27891,null));
var inst_27893 = (inst_27892.cljs$core$IFn$_invoke$arity$1 ? inst_27892.cljs$core$IFn$_invoke$arity$1(inst_27847) : inst_27892.call(null,inst_27847));
var state_27988__$1 = state_27988;
if(cljs.core.truth_(inst_27893)){
var statearr_28058_28247 = state_27988__$1;
(statearr_28058_28247[(1)] = (92));

} else {
var statearr_28059_28248 = state_27988__$1;
(statearr_28059_28248[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (117))){
var state_27988__$1 = state_27988;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_28060_28249 = state_27988__$1;
(statearr_28060_28249[(1)] = (120));

} else {
var statearr_28061_28250 = state_27988__$1;
(statearr_28061_28250[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (108))){
var inst_27716 = (state_27988[(11)]);
var inst_27947 = (state_27988[(25)]);
var inst_27947__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_27716);
var state_27988__$1 = (function (){var statearr_28062 = state_27988;
(statearr_28062[(25)] = inst_27947__$1);

return statearr_28062;
})();
if(cljs.core.truth_(inst_27947__$1)){
var statearr_28063_28251 = state_27988__$1;
(statearr_28063_28251[(1)] = (111));

} else {
var statearr_28064_28252 = state_27988__$1;
(statearr_28064_28252[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (56))){
var inst_27809 = (state_27988[(2)]);
var inst_27810 = fluree.db.util.async.throw_err(inst_27809);
var inst_27811 = cljs.core.not(inst_27810);
var state_27988__$1 = state_27988;
var statearr_28065_28253 = state_27988__$1;
(statearr_28065_28253[(2)] = inst_27811);

(statearr_28065_28253[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (33))){
var inst_27739 = (state_27988[(26)]);
var state_27988__$1 = state_27988;
var statearr_28066_28254 = state_27988__$1;
(statearr_28066_28254[(2)] = inst_27739);

(statearr_28066_28254[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (13))){
var inst_27734 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
if(cljs.core.truth_(inst_27734)){
var statearr_28067_28255 = state_27988__$1;
(statearr_28067_28255[(1)] = (17));

} else {
var statearr_28068_28256 = state_27988__$1;
(statearr_28068_28256[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (22))){
var inst_27765 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
if(cljs.core.truth_(inst_27765)){
var statearr_28069_28257 = state_27988__$1;
(statearr_28069_28257[(1)] = (32));

} else {
var statearr_28070_28258 = state_27988__$1;
(statearr_28070_28258[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (90))){
var inst_27888 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28071_28259 = state_27988__$1;
(statearr_28071_28259[(2)] = inst_27888);

(statearr_28071_28259[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (109))){
var inst_27945 = (state_27988[(27)]);
var state_27988__$1 = state_27988;
var statearr_28072_28260 = state_27988__$1;
(statearr_28072_28260[(2)] = inst_27945);

(statearr_28072_28260[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (36))){
var inst_27739 = (state_27988[(26)]);
var state_27988__$1 = state_27988;
var statearr_28073_28261 = state_27988__$1;
(statearr_28073_28261[(2)] = inst_27739);

(statearr_28073_28261[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (41))){
var inst_27716 = (state_27988[(11)]);
var inst_27784 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_27716);
var inst_27785 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_27784);
var inst_27786 = inst_27785 === true;
var state_27988__$1 = state_27988;
var statearr_28074_28262 = state_27988__$1;
(statearr_28074_28262[(2)] = inst_27786);

(statearr_28074_28262[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (118))){
var inst_27943 = (state_27988[(7)]);
var state_27988__$1 = state_27988;
var statearr_28075_28263 = state_27988__$1;
(statearr_28075_28263[(2)] = inst_27943);

(statearr_28075_28263[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (89))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27886 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_27847,inst_27848,throw_QMARK_);
var state_27988__$1 = state_27988;
var statearr_28076_28264 = state_27988__$1;
(statearr_28076_28264[(2)] = inst_27886);

(statearr_28076_28264[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (100))){
var inst_27835 = (state_27988[(12)]);
var state_27988__$1 = state_27988;
var statearr_28077_28265 = state_27988__$1;
(statearr_28077_28265[(2)] = inst_27835);

(statearr_28077_28265[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (122))){
var inst_27975 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28078_28266 = state_27988__$1;
(statearr_28078_28266[(2)] = inst_27975);

(statearr_28078_28266[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (43))){
var inst_27789 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28079_28267 = state_27988__$1;
(statearr_28079_28267[(2)] = inst_27789);

(statearr_28079_28267[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (61))){
var inst_27797 = (state_27988[(14)]);
var state_27988__$1 = state_27988;
var statearr_28080_28268 = state_27988__$1;
(statearr_28080_28268[(2)] = inst_27797);

(statearr_28080_28268[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (29))){
var inst_27716 = (state_27988[(11)]);
var inst_27751 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_27716);
var inst_27752 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_27751);
var inst_27753 = inst_27752 === true;
var state_27988__$1 = state_27988;
var statearr_28081_28269 = state_27988__$1;
(statearr_28081_28269[(2)] = inst_27753);

(statearr_28081_28269[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (44))){
var inst_27778 = (state_27988[(28)]);
var inst_27794 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_27778,"a component","a non-component",throw_QMARK_);
var state_27988__$1 = state_27988;
var statearr_28082_28270 = state_27988__$1;
(statearr_28082_28270[(2)] = inst_27794);

(statearr_28082_28270[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (93))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27896 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_27847,inst_27848,throw_QMARK_);
var state_27988__$1 = state_27988;
var statearr_28083_28271 = state_27988__$1;
(statearr_28083_28271[(2)] = inst_27896);

(statearr_28083_28271[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (6))){
var inst_27703 = (state_27988[(21)]);
var inst_27715 = (state_27988[(16)]);
var inst_27712 = cljs.core.seq(inst_27703);
var inst_27713 = cljs.core.first(inst_27712);
var inst_27714 = cljs.core.next(inst_27712);
var inst_27715__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27713,(0),null);
var inst_27716 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27713,(1),null);
var inst_27717 = cljs.core.not(inst_27715__$1);
var state_27988__$1 = (function (){var statearr_28084 = state_27988;
(statearr_28084[(20)] = inst_27714);

(statearr_28084[(11)] = inst_27716);

(statearr_28084[(16)] = inst_27715__$1);

return statearr_28084;
})();
if(inst_27717){
var statearr_28085_28272 = state_27988__$1;
(statearr_28085_28272[(1)] = (8));

} else {
var statearr_28086_28273 = state_27988__$1;
(statearr_28086_28273[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (111))){
var inst_27951 = (state_27988[(29)]);
var inst_27716 = (state_27988[(11)]);
var inst_27949 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_27716);
var inst_27950 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_27949);
var inst_27951__$1 = inst_27950 === true;
var state_27988__$1 = (function (){var statearr_28087 = state_27988;
(statearr_28087[(29)] = inst_27951__$1);

return statearr_28087;
})();
if(cljs.core.truth_(inst_27951__$1)){
var statearr_28088_28274 = state_27988__$1;
(statearr_28088_28274[(1)] = (114));

} else {
var statearr_28089_28275 = state_27988__$1;
(statearr_28089_28275[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (28))){
var inst_27759 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28090_28276 = state_27988__$1;
(statearr_28090_28276[(2)] = inst_27759);

(statearr_28090_28276[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (64))){
var inst_27836 = (state_27988[(10)]);
var state_27988__$1 = state_27988;
var statearr_28091_28277 = state_27988__$1;
(statearr_28091_28277[(2)] = inst_27836);

(statearr_28091_28277[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (103))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27920 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_27921 = (inst_27848.cljs$core$IFn$_invoke$arity$5 ? inst_27848.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_27920,null) : inst_27848.call(null,cljs.core.PersistentArrayMap,null,2,inst_27920,null));
var inst_27922 = (inst_27848.cljs$core$IFn$_invoke$arity$4 ? inst_27848.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_27921,null) : inst_27848.call(null,cljs.core.PersistentHashSet,null,inst_27921,null));
var inst_27923 = (inst_27922.cljs$core$IFn$_invoke$arity$1 ? inst_27922.cljs$core$IFn$_invoke$arity$1(inst_27847) : inst_27922.call(null,inst_27847));
var state_27988__$1 = state_27988;
if(cljs.core.truth_(inst_27923)){
var statearr_28092_28278 = state_27988__$1;
(statearr_28092_28278[(1)] = (104));

} else {
var statearr_28093_28279 = state_27988__$1;
(statearr_28093_28279[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (51))){
var inst_27801 = (state_27988[(30)]);
var state_27988__$1 = state_27988;
var statearr_28094_28280 = state_27988__$1;
(statearr_28094_28280[(2)] = inst_27801);

(statearr_28094_28280[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (25))){
var inst_27762 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28095_28281 = state_27988__$1;
(statearr_28095_28281[(2)] = inst_27762);

(statearr_28095_28281[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (34))){
var inst_27716 = (state_27988[(11)]);
var inst_27779 = (state_27988[(18)]);
var inst_27778 = (state_27988[(2)]);
var inst_27779__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_27716);
var state_27988__$1 = (function (){var statearr_28096 = state_27988;
(statearr_28096[(28)] = inst_27778);

(statearr_28096[(18)] = inst_27779__$1);

return statearr_28096;
})();
if(cljs.core.truth_(inst_27779__$1)){
var statearr_28097_28282 = state_27988__$1;
(statearr_28097_28282[(1)] = (38));

} else {
var statearr_28098_28283 = state_27988__$1;
(statearr_28098_28283[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (17))){
var inst_27704 = (state_27988[(15)]);
var inst_27736 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_27704,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_27988__$1 = state_27988;
var statearr_28099_28284 = state_27988__$1;
(statearr_28099_28284[(2)] = inst_27736);

(statearr_28099_28284[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (3))){
var inst_27986 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27988__$1,inst_27986);
} else {
if((state_val_27989 === (12))){
var inst_27720 = (state_27988[(31)]);
var state_27988__$1 = state_27988;
var statearr_28100_28285 = state_27988__$1;
(statearr_28100_28285[(2)] = inst_27720);

(statearr_28100_28285[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (2))){
var _ = (function (){var statearr_28101 = state_27988;
(statearr_28101[(4)] = cljs.core.cons((5),(state_27988[(4)])));

return statearr_28101;
})();
var inst_27696 = pred_changes;
var inst_27697 = cljs.core.seq(inst_27696);
var inst_27698 = cljs.core.first(inst_27697);
var inst_27699 = cljs.core.next(inst_27697);
var inst_27700 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27698,(0),null);
var inst_27701 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27698,(1),null);
var inst_27702 = db;
var inst_27703 = inst_27696;
var inst_27704 = inst_27702;
var state_27988__$1 = (function (){var statearr_28102 = state_27988;
(statearr_28102[(32)] = inst_27701);

(statearr_28102[(21)] = inst_27703);

(statearr_28102[(33)] = inst_27699);

(statearr_28102[(15)] = inst_27704);

(statearr_28102[(34)] = inst_27700);

return statearr_28102;
})();
var statearr_28103_28286 = state_27988__$1;
(statearr_28103_28286[(2)] = null);

(statearr_28103_28286[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (66))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27716 = (state_27988[(11)]);
var inst_27845 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_27716);
var inst_27846 = cljs.core.__destructure_map(inst_27845);
var inst_27847__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27846,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_27848__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27846,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_27849 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_27848__$1,inst_27847__$1);
var state_27988__$1 = (function (){var statearr_28104 = state_27988;
(statearr_28104[(8)] = inst_27847__$1);

(statearr_28104[(9)] = inst_27848__$1);

return statearr_28104;
})();
if(inst_27849){
var statearr_28105_28287 = state_27988__$1;
(statearr_28105_28287[(1)] = (69));

} else {
var statearr_28106_28288 = state_27988__$1;
(statearr_28106_28288[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (107))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27930 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_27847,inst_27848,throw_QMARK_);
var state_27988__$1 = state_27988;
var statearr_28107_28289 = state_27988__$1;
(statearr_28107_28289[(2)] = inst_27930);

(statearr_28107_28289[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (23))){
var inst_27745 = (state_27988[(17)]);
var inst_27716 = (state_27988[(11)]);
var inst_27744 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_27716);
var inst_27745__$1 = inst_27744 === true;
var state_27988__$1 = (function (){var statearr_28108 = state_27988;
(statearr_28108[(17)] = inst_27745__$1);

return statearr_28108;
})();
if(cljs.core.truth_(inst_27745__$1)){
var statearr_28109_28290 = state_27988__$1;
(statearr_28109_28290[(1)] = (26));

} else {
var statearr_28110_28291 = state_27988__$1;
(statearr_28110_28291[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (47))){
var inst_27801 = (state_27988[(30)]);
var inst_27716 = (state_27988[(11)]);
var inst_27800 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_27716);
var inst_27801__$1 = cljs.core.not(inst_27800);
var state_27988__$1 = (function (){var statearr_28111 = state_27988;
(statearr_28111[(30)] = inst_27801__$1);

return statearr_28111;
})();
if(inst_27801__$1){
var statearr_28112_28292 = state_27988__$1;
(statearr_28112_28292[(1)] = (50));

} else {
var statearr_28113_28293 = state_27988__$1;
(statearr_28113_28293[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (35))){
var inst_27768 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27769 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_27770 = cljs.core.PersistentHashMap.fromArrays(inst_27768,inst_27769);
var inst_27771 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_27770);
var inst_27772 = (function(){throw inst_27771})();
var state_27988__$1 = state_27988;
var statearr_28114_28294 = state_27988__$1;
(statearr_28114_28294[(2)] = inst_27772);

(statearr_28114_28294[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (82))){
var inst_27868 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28115_28295 = state_27988__$1;
(statearr_28115_28295[(2)] = inst_27868);

(statearr_28115_28295[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (76))){
var state_27988__$1 = state_27988;
var statearr_28116_28296 = state_27988__$1;
(statearr_28116_28296[(2)] = null);

(statearr_28116_28296[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (97))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27906 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_27847,inst_27848,throw_QMARK_);
var state_27988__$1 = state_27988;
var statearr_28117_28297 = state_27988__$1;
(statearr_28117_28297[(2)] = inst_27906);

(statearr_28117_28297[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (19))){
var inst_27740 = (state_27988[(24)]);
var inst_27716 = (state_27988[(11)]);
var inst_27739 = (state_27988[(2)]);
var inst_27740__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_27716);
var state_27988__$1 = (function (){var statearr_28118 = state_27988;
(statearr_28118[(26)] = inst_27739);

(statearr_28118[(24)] = inst_27740__$1);

return statearr_28118;
})();
if(cljs.core.truth_(inst_27740__$1)){
var statearr_28119_28298 = state_27988__$1;
(statearr_28119_28298[(1)] = (20));

} else {
var statearr_28120_28299 = state_27988__$1;
(statearr_28120_28299[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (57))){
var state_27988__$1 = state_27988;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_28121_28300 = state_27988__$1;
(statearr_28121_28300[(1)] = (60));

} else {
var statearr_28122_28301 = state_27988__$1;
(statearr_28122_28301[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (68))){
var inst_27716 = (state_27988[(11)]);
var inst_27945 = (state_27988[(27)]);
var inst_27943 = (state_27988[(2)]);
var inst_27944 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_27716);
var inst_27945__$1 = inst_27944 === true;
var state_27988__$1 = (function (){var statearr_28123 = state_27988;
(statearr_28123[(7)] = inst_27943);

(statearr_28123[(27)] = inst_27945__$1);

return statearr_28123;
})();
if(cljs.core.truth_(inst_27945__$1)){
var statearr_28124_28302 = state_27988__$1;
(statearr_28124_28302[(1)] = (108));

} else {
var statearr_28125_28303 = state_27988__$1;
(statearr_28125_28303[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (11))){
var inst_27724 = (state_27988[(23)]);
var inst_27716 = (state_27988[(11)]);
var inst_27722 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_27716);
var inst_27723 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_27722);
var inst_27724__$1 = inst_27723 === false;
var state_27988__$1 = (function (){var statearr_28126 = state_27988;
(statearr_28126[(23)] = inst_27724__$1);

return statearr_28126;
})();
if(cljs.core.truth_(inst_27724__$1)){
var statearr_28127_28304 = state_27988__$1;
(statearr_28127_28304[(1)] = (14));

} else {
var statearr_28128_28305 = state_27988__$1;
(statearr_28128_28305[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (115))){
var inst_27951 = (state_27988[(29)]);
var state_27988__$1 = state_27988;
var statearr_28130_28306 = state_27988__$1;
(statearr_28130_28306[(2)] = inst_27951);

(statearr_28130_28306[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (9))){
var inst_27720 = (state_27988[(31)]);
var inst_27716 = (state_27988[(11)]);
var inst_27720__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_27716);
var state_27988__$1 = (function (){var statearr_28131 = state_27988;
(statearr_28131[(31)] = inst_27720__$1);

return statearr_28131;
})();
if(cljs.core.truth_(inst_27720__$1)){
var statearr_28132_28307 = state_27988__$1;
(statearr_28132_28307[(1)] = (11));

} else {
var statearr_28133_28308 = state_27988__$1;
(statearr_28133_28308[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (5))){
var _ = (function (){var statearr_28134 = state_27988;
(statearr_28134[(4)] = cljs.core.rest((state_27988[(4)])));

return statearr_28134;
})();
var state_27988__$1 = state_27988;
var ex28129 = (state_27988__$1[(2)]);
var statearr_28135_28309 = state_27988__$1;
(statearr_28135_28309[(5)] = ex28129);


if((ex28129 instanceof Error)){
var statearr_28136_28310 = state_27988__$1;
(statearr_28136_28310[(1)] = (4));

(statearr_28136_28310[(5)] = null);

} else {
throw ex28129;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (112))){
var inst_27947 = (state_27988[(25)]);
var state_27988__$1 = state_27988;
var statearr_28137_28311 = state_27988__$1;
(statearr_28137_28311[(2)] = inst_27947);

(statearr_28137_28311[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (83))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27870 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_27871 = (inst_27848.cljs$core$IFn$_invoke$arity$5 ? inst_27848.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_27870,null) : inst_27848.call(null,cljs.core.PersistentArrayMap,null,3,inst_27870,null));
var inst_27872 = (inst_27848.cljs$core$IFn$_invoke$arity$4 ? inst_27848.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_27871,null) : inst_27848.call(null,cljs.core.PersistentHashSet,null,inst_27871,null));
var inst_27873 = (inst_27872.cljs$core$IFn$_invoke$arity$1 ? inst_27872.cljs$core$IFn$_invoke$arity$1(inst_27847) : inst_27872.call(null,inst_27847));
var state_27988__$1 = state_27988;
if(cljs.core.truth_(inst_27873)){
var statearr_28138_28312 = state_27988__$1;
(statearr_28138_28312[(1)] = (84));

} else {
var statearr_28139_28313 = state_27988__$1;
(statearr_28139_28313[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (14))){
var inst_27716 = (state_27988[(11)]);
var inst_27726 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_27716);
var inst_27727 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_27726);
var inst_27728 = inst_27727 === true;
var state_27988__$1 = state_27988;
var statearr_28140_28314 = state_27988__$1;
(statearr_28140_28314[(2)] = inst_27728);

(statearr_28140_28314[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (45))){
var inst_27778 = (state_27988[(28)]);
var state_27988__$1 = state_27988;
var statearr_28141_28315 = state_27988__$1;
(statearr_28141_28315[(2)] = inst_27778);

(statearr_28141_28315[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (53))){
var inst_27704 = (state_27988[(15)]);
var inst_27715 = (state_27988[(16)]);
var inst_27807 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_27704,inst_27715);
var state_27988__$1 = state_27988;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27988__$1,(56),inst_27807);
} else {
if((state_val_27989 === (78))){
var inst_27933 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28142_28316 = state_27988__$1;
(statearr_28142_28316[(2)] = inst_27933);

(statearr_28142_28316[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (26))){
var inst_27716 = (state_27988[(11)]);
var inst_27749 = (state_27988[(35)]);
var inst_27747 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_27716);
var inst_27748 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_27747);
var inst_27749__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_27748);
var state_27988__$1 = (function (){var statearr_28143 = state_27988;
(statearr_28143[(35)] = inst_27749__$1);

return statearr_28143;
})();
if(inst_27749__$1){
var statearr_28144_28317 = state_27988__$1;
(statearr_28144_28317[(1)] = (29));

} else {
var statearr_28145_28318 = state_27988__$1;
(statearr_28145_28318[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (16))){
var inst_27731 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28146_28319 = state_27988__$1;
(statearr_28146_28319[(2)] = inst_27731);

(statearr_28146_28319[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (81))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27866 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_27847,inst_27848,throw_QMARK_);
var state_27988__$1 = state_27988;
var statearr_28147_28320 = state_27988__$1;
(statearr_28147_28320[(2)] = inst_27866);

(statearr_28147_28320[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (120))){
var inst_27968 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27969 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_27970 = cljs.core.PersistentHashMap.fromArrays(inst_27968,inst_27969);
var inst_27971 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_27970);
var inst_27972 = (function(){throw inst_27971})();
var state_27988__$1 = state_27988;
var statearr_28148_28321 = state_27988__$1;
(statearr_28148_28321[(2)] = inst_27972);

(statearr_28148_28321[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (79))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27860 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_27861 = (inst_27848.cljs$core$IFn$_invoke$arity$5 ? inst_27848.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_27860,null) : inst_27848.call(null,cljs.core.PersistentArrayMap,null,2,inst_27860,null));
var inst_27862 = (inst_27848.cljs$core$IFn$_invoke$arity$4 ? inst_27848.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_27861,null) : inst_27848.call(null,cljs.core.PersistentHashSet,null,inst_27861,null));
var inst_27863 = (inst_27862.cljs$core$IFn$_invoke$arity$1 ? inst_27862.cljs$core$IFn$_invoke$arity$1(inst_27847) : inst_27862.call(null,inst_27847));
var state_27988__$1 = state_27988;
if(cljs.core.truth_(inst_27863)){
var statearr_28149_28322 = state_27988__$1;
(statearr_28149_28322[(1)] = (80));

} else {
var statearr_28150_28323 = state_27988__$1;
(statearr_28150_28323[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (38))){
var inst_27716 = (state_27988[(11)]);
var inst_27782 = (state_27988[(36)]);
var inst_27781 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_27716);
var inst_27782__$1 = cljs.core.not(inst_27781);
var state_27988__$1 = (function (){var statearr_28151 = state_27988;
(statearr_28151[(36)] = inst_27782__$1);

return statearr_28151;
})();
if(inst_27782__$1){
var statearr_28152_28324 = state_27988__$1;
(statearr_28152_28324[(1)] = (41));

} else {
var statearr_28153_28325 = state_27988__$1;
(statearr_28153_28325[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (98))){
var inst_27908 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28154_28326 = state_27988__$1;
(statearr_28154_28326[(2)] = inst_27908);

(statearr_28154_28326[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (87))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27880 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_27881 = (inst_27848.cljs$core$IFn$_invoke$arity$5 ? inst_27848.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_27880,null) : inst_27848.call(null,cljs.core.PersistentArrayMap,null,3,inst_27880,null));
var inst_27882 = (inst_27848.cljs$core$IFn$_invoke$arity$4 ? inst_27848.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_27881,null) : inst_27848.call(null,cljs.core.PersistentHashSet,null,inst_27881,null));
var inst_27883 = (inst_27882.cljs$core$IFn$_invoke$arity$1 ? inst_27882.cljs$core$IFn$_invoke$arity$1(inst_27847) : inst_27882.call(null,inst_27847));
var state_27988__$1 = state_27988;
if(cljs.core.truth_(inst_27883)){
var statearr_28155_28327 = state_27988__$1;
(statearr_28155_28327[(1)] = (88));

} else {
var statearr_28156_28328 = state_27988__$1;
(statearr_28156_28328[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (30))){
var inst_27749 = (state_27988[(35)]);
var state_27988__$1 = state_27988;
var statearr_28157_28329 = state_27988__$1;
(statearr_28157_28329[(2)] = inst_27749);

(statearr_28157_28329[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (73))){
var state_27988__$1 = state_27988;
var statearr_28158_28330 = state_27988__$1;
(statearr_28158_28330[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (96))){
var inst_27835 = (state_27988[(12)]);
var state_27988__$1 = state_27988;
var statearr_28160_28331 = state_27988__$1;
(statearr_28160_28331[(2)] = inst_27835);

(statearr_28160_28331[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (10))){
var inst_27981 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28161_28332 = state_27988__$1;
(statearr_28161_28332[(2)] = inst_27981);

(statearr_28161_28332[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (18))){
var inst_27704 = (state_27988[(15)]);
var state_27988__$1 = state_27988;
var statearr_28162_28333 = state_27988__$1;
(statearr_28162_28333[(2)] = inst_27704);

(statearr_28162_28333[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (105))){
var inst_27847 = (state_27988[(8)]);
var inst_27848 = (state_27988[(9)]);
var inst_27926 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_27847,inst_27848,throw_QMARK_);
var state_27988__$1 = state_27988;
var statearr_28163_28334 = state_27988__$1;
(statearr_28163_28334[(2)] = inst_27926);

(statearr_28163_28334[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (52))){
var inst_27817 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28164_28335 = state_27988__$1;
(statearr_28164_28335[(2)] = inst_27817);

(statearr_28164_28335[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (114))){
var inst_27716 = (state_27988[(11)]);
var inst_27953 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_27716);
var inst_27954 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_27953);
var inst_27955 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_27954);
var inst_27956 = (!(inst_27955));
var state_27988__$1 = state_27988;
var statearr_28165_28336 = state_27988__$1;
(statearr_28165_28336[(2)] = inst_27956);

(statearr_28165_28336[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (67))){
var inst_27835 = (state_27988[(12)]);
var state_27988__$1 = state_27988;
var statearr_28166_28337 = state_27988__$1;
(statearr_28166_28337[(2)] = inst_27835);

(statearr_28166_28337[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (71))){
var inst_27940 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28167_28338 = state_27988__$1;
(statearr_28167_28338[(2)] = inst_27940);

(statearr_28167_28338[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (42))){
var inst_27782 = (state_27988[(36)]);
var state_27988__$1 = state_27988;
var statearr_28168_28339 = state_27988__$1;
(statearr_28168_28339[(2)] = inst_27782);

(statearr_28168_28339[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (80))){
var inst_27835 = (state_27988[(12)]);
var state_27988__$1 = state_27988;
var statearr_28169_28340 = state_27988__$1;
(statearr_28169_28340[(2)] = inst_27835);

(statearr_28169_28340[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (37))){
var inst_27775 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28170_28341 = state_27988__$1;
(statearr_28170_28341[(2)] = inst_27775);

(statearr_28170_28341[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (63))){
var inst_27716 = (state_27988[(11)]);
var inst_27838 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_27716);
var inst_27839 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_27838);
var state_27988__$1 = state_27988;
var statearr_28171_28342 = state_27988__$1;
(statearr_28171_28342[(2)] = inst_27839);

(statearr_28171_28342[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (94))){
var inst_27898 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_28172_28343 = state_27988__$1;
(statearr_28172_28343[(2)] = inst_27898);

(statearr_28172_28343[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (8))){
var inst_27704 = (state_27988[(15)]);
var state_27988__$1 = state_27988;
var statearr_28173_28344 = state_27988__$1;
(statearr_28173_28344[(2)] = inst_27704);

(statearr_28173_28344[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (49))){
var inst_27820 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
if(cljs.core.truth_(inst_27820)){
var statearr_28174_28345 = state_27988__$1;
(statearr_28174_28345[(1)] = (57));

} else {
var statearr_28175_28346 = state_27988__$1;
(statearr_28175_28346[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27989 === (84))){
var inst_27835 = (state_27988[(12)]);
var state_27988__$1 = state_27988;
var statearr_28176_28347 = state_27988__$1;
(statearr_28176_28347[(2)] = inst_27835);

(statearr_28176_28347[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__11438__auto__ = null;
var fluree$db$query$schema$state_machine__11438__auto____0 = (function (){
var statearr_28177 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28177[(0)] = fluree$db$query$schema$state_machine__11438__auto__);

(statearr_28177[(1)] = (1));

return statearr_28177;
});
var fluree$db$query$schema$state_machine__11438__auto____1 = (function (state_27988){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_27988);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e28178){var ex__11441__auto__ = e28178;
var statearr_28179_28348 = state_27988;
(statearr_28179_28348[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_27988[(4)]))){
var statearr_28180_28349 = state_27988;
(statearr_28180_28349[(1)] = cljs.core.first((state_27988[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28350 = state_27988;
state_27988 = G__28350;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__11438__auto__ = function(state_27988){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__11438__auto____1.call(this,state_27988);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__11438__auto____0;
fluree$db$query$schema$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__11438__auto____1;
return fluree$db$query$schema$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_28181 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_28181[(6)] = c__11512__auto__);

return statearr_28181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__28352 = arguments.length;
switch (G__28352) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_28376){
var state_val_28377 = (state_28376[(1)]);
if((state_val_28377 === (7))){
var state_28376__$1 = state_28376;
var statearr_28378_28398 = state_28376__$1;
(statearr_28378_28398[(2)] = db);

(statearr_28378_28398[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28377 === (1))){
var state_28376__$1 = state_28376;
var statearr_28379_28399 = state_28376__$1;
(statearr_28379_28399[(2)] = null);

(statearr_28379_28399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28377 === (4))){
var inst_28353 = (state_28376[(2)]);
var state_28376__$1 = state_28376;
var statearr_28380_28400 = state_28376__$1;
(statearr_28380_28400[(2)] = inst_28353);

(statearr_28380_28400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28377 === (6))){
var inst_28362 = (state_28376[(7)]);
var inst_28361 = (state_28376[(2)]);
var inst_28362__$1 = fluree.db.util.async.throw_err(inst_28361);
var inst_28363 = cljs.core.empty_QMARK_(inst_28362__$1);
var state_28376__$1 = (function (){var statearr_28381 = state_28376;
(statearr_28381[(7)] = inst_28362__$1);

return statearr_28381;
})();
if(inst_28363){
var statearr_28382_28401 = state_28376__$1;
(statearr_28382_28401[(1)] = (7));

} else {
var statearr_28383_28402 = state_28376__$1;
(statearr_28383_28402[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28377 === (3))){
var inst_28374 = (state_28376[(2)]);
var state_28376__$1 = state_28376;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28376__$1,inst_28374);
} else {
if((state_val_28377 === (2))){
var _ = (function (){var statearr_28385 = state_28376;
(statearr_28385[(4)] = cljs.core.cons((5),(state_28376[(4)])));

return statearr_28385;
})();
var inst_28359 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_28376__$1 = state_28376;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28376__$1,(6),inst_28359);
} else {
if((state_val_28377 === (9))){
var inst_28371 = (state_28376[(2)]);
var _ = (function (){var statearr_28386 = state_28376;
(statearr_28386[(4)] = cljs.core.rest((state_28376[(4)])));

return statearr_28386;
})();
var state_28376__$1 = state_28376;
var statearr_28387_28403 = state_28376__$1;
(statearr_28387_28403[(2)] = inst_28371);

(statearr_28387_28403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28377 === (5))){
var _ = (function (){var statearr_28388 = state_28376;
(statearr_28388[(4)] = cljs.core.rest((state_28376[(4)])));

return statearr_28388;
})();
var state_28376__$1 = state_28376;
var ex28384 = (state_28376__$1[(2)]);
var statearr_28389_28404 = state_28376__$1;
(statearr_28389_28404[(5)] = ex28384);


if((ex28384 instanceof Error)){
var statearr_28390_28405 = state_28376__$1;
(statearr_28390_28405[(1)] = (4));

(statearr_28390_28405[(5)] = null);

} else {
throw ex28384;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28377 === (10))){
var inst_28368 = (state_28376[(2)]);
var inst_28369 = fluree.db.util.async.throw_err(inst_28368);
var state_28376__$1 = state_28376;
var statearr_28391_28406 = state_28376__$1;
(statearr_28391_28406[(2)] = inst_28369);

(statearr_28391_28406[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28377 === (8))){
var inst_28362 = (state_28376[(7)]);
var inst_28366 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_28362,db,true);
var state_28376__$1 = state_28376;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28376__$1,(10),inst_28366);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__11438__auto__ = null;
var fluree$db$query$schema$state_machine__11438__auto____0 = (function (){
var statearr_28392 = [null,null,null,null,null,null,null,null];
(statearr_28392[(0)] = fluree$db$query$schema$state_machine__11438__auto__);

(statearr_28392[(1)] = (1));

return statearr_28392;
});
var fluree$db$query$schema$state_machine__11438__auto____1 = (function (state_28376){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_28376);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e28393){var ex__11441__auto__ = e28393;
var statearr_28394_28407 = state_28376;
(statearr_28394_28407[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_28376[(4)]))){
var statearr_28395_28408 = state_28376;
(statearr_28395_28408[(1)] = cljs.core.first((state_28376[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28409 = state_28376;
state_28376 = G__28409;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__11438__auto__ = function(state_28376){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__11438__auto____1.call(this,state_28376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__11438__auto____0;
fluree$db$query$schema$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__11438__auto____1;
return fluree$db$query$schema$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_28396 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_28396[(6)] = c__11512__auto__);

return statearr_28396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__28411 = arguments.length;
switch (G__28411) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__28413 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28413,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28413,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28413,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__5043__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__5043__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__28416_SHARP_,p2__28417_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28416_SHARP_,p2__28417_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__28418_SHARP_){
var f = p1__28418_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_28484){
var state_val_28485 = (state_28484[(1)]);
if((state_val_28485 === (1))){
var state_28484__$1 = state_28484;
var statearr_28486_28504 = state_28484__$1;
(statearr_28486_28504[(2)] = null);

(statearr_28486_28504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28485 === (2))){
var _ = (function (){var statearr_28487 = state_28484;
(statearr_28487[(4)] = cljs.core.cons((5),(state_28484[(4)])));

return statearr_28487;
})();
var inst_28436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28437 = fluree.db.flake.max_subject_id((1));
var inst_28438 = [inst_28437];
var inst_28439 = (new cljs.core.PersistentVector(null,1,(5),inst_28436,inst_28438,null));
var inst_28440 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28441 = [(0)];
var inst_28442 = (new cljs.core.PersistentVector(null,1,(5),inst_28440,inst_28441,null));
var inst_28443 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_28439,cljs.core._LT__EQ_,inst_28442);
var state_28484__$1 = state_28484;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28484__$1,(6),inst_28443);
} else {
if((state_val_28485 === (3))){
var inst_28482 = (state_28484[(2)]);
var state_28484__$1 = state_28484;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28484__$1,inst_28482);
} else {
if((state_val_28485 === (4))){
var inst_28424 = (state_28484[(2)]);
var state_28484__$1 = state_28484;
var statearr_28489_28505 = state_28484__$1;
(statearr_28489_28505[(2)] = inst_28424);

(statearr_28489_28505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28485 === (5))){
var _ = (function (){var statearr_28490 = state_28484;
(statearr_28490[(4)] = cljs.core.rest((state_28484[(4)])));

return statearr_28490;
})();
var state_28484__$1 = state_28484;
var ex28488 = (state_28484__$1[(2)]);
var statearr_28491_28506 = state_28484__$1;
(statearr_28491_28506[(5)] = ex28488);


if((ex28488 instanceof Error)){
var statearr_28492_28507 = state_28484__$1;
(statearr_28492_28507[(1)] = (4));

(statearr_28492_28507[(5)] = null);

} else {
throw ex28488;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28485 === (6))){
var inst_28445 = (state_28484[(2)]);
var inst_28446 = fluree.db.util.async.throw_err(inst_28445);
var inst_28447 = (function (){var schema_flakes = inst_28446;
return (function (p1__28419_SHARP_){
return (p1__28419_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_28448 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_28447,inst_28446);
var inst_28449 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28448,(0),null);
var inst_28450 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28448,(1),null);
var inst_28451 = (function (){var schema_flakes = inst_28446;
var vec__28430 = inst_28448;
var collection_flakes = inst_28449;
var predicate_flakes = inst_28450;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__28422_SHARP_,p2__28421_SHARP_){
var f = p2__28421_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__28422_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_28452 = [(-1),"_tx"];
var inst_28453 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_28454 = ["_tx",(-1),(-1),(-1),null,null];
var inst_28455 = cljs.core.PersistentHashMap.fromArrays(inst_28453,inst_28454);
var inst_28456 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_28457 = ["_tx",(-1),(-1),(-1),null,null];
var inst_28458 = cljs.core.PersistentHashMap.fromArrays(inst_28456,inst_28457);
var inst_28459 = [inst_28455,inst_28458];
var inst_28460 = cljs.core.PersistentHashMap.fromArrays(inst_28452,inst_28459);
var inst_28461 = (function (){var schema_flakes = inst_28446;
var vec__28430 = inst_28448;
var collection_flakes = inst_28449;
var predicate_flakes = inst_28450;
return (function (p1__28420_SHARP_){
return p1__28420_SHARP_.s;
});
})();
var inst_28462 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_28461,inst_28449);
var inst_28463 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_28451,inst_28460,inst_28462);
var inst_28465 = (function (){var schema_flakes = inst_28446;
var vec__28430 = inst_28448;
var collection_flakes = inst_28449;
var predicate_flakes = inst_28450;
var coll = inst_28463;
return (function (p__28464,pred_flakes){
var vec__28493 = p__28464;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28493,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28493,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__28496 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__28496.cljs$core$IFn$_invoke$arity$1 ? fexpr__28496.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__28496.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__5045__auto__ = ref_QMARK_;
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_28466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28467 = cljs.core.PersistentHashMap.EMPTY;
var inst_28468 = cljs.core.PersistentHashSet.EMPTY;
var inst_28469 = [inst_28467,inst_28468];
var inst_28470 = (new cljs.core.PersistentVector(null,2,(5),inst_28466,inst_28469,null));
var inst_28471 = (function (){var schema_flakes = inst_28446;
var vec__28430 = inst_28448;
var collection_flakes = inst_28449;
var predicate_flakes = inst_28450;
var coll = inst_28463;
return (function (p1__28423_SHARP_){
return p1__28423_SHARP_.s;
});
})();
var inst_28472 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_28471,inst_28450);
var inst_28473 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_28465,inst_28470,inst_28472);
var inst_28474 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28473,(0),null);
var inst_28475 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28473,(1),null);
var inst_28476 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_28477 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_28478 = [inst_28477,inst_28463,inst_28474,inst_28475];
var inst_28479 = cljs.core.PersistentHashMap.fromArrays(inst_28476,inst_28478);
var _ = (function (){var statearr_28497 = state_28484;
(statearr_28497[(4)] = cljs.core.rest((state_28484[(4)])));

return statearr_28497;
})();
var state_28484__$1 = state_28484;
var statearr_28498_28508 = state_28484__$1;
(statearr_28498_28508[(2)] = inst_28479);

(statearr_28498_28508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__11438__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__11438__auto____0 = (function (){
var statearr_28499 = [null,null,null,null,null,null,null];
(statearr_28499[(0)] = fluree$db$query$schema$schema_map_$_state_machine__11438__auto__);

(statearr_28499[(1)] = (1));

return statearr_28499;
});
var fluree$db$query$schema$schema_map_$_state_machine__11438__auto____1 = (function (state_28484){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_28484);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e28500){var ex__11441__auto__ = e28500;
var statearr_28501_28509 = state_28484;
(statearr_28501_28509[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_28484[(4)]))){
var statearr_28502_28510 = state_28484;
(statearr_28502_28510[(1)] = cljs.core.first((state_28484[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28511 = state_28484;
state_28484 = G__28511;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__11438__auto__ = function(state_28484){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__11438__auto____1.call(this,state_28484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__11438__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__11438__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_28503 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_28503[(6)] = c__11512__auto__);

return statearr_28503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_28553){
var state_val_28554 = (state_28553[(1)]);
if((state_val_28554 === (7))){
var inst_28536 = (state_28553[(2)]);
var inst_28537 = fluree.db.query.schema.flake__GT_pred_map(inst_28536);
var inst_28538 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_28539 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28537,(114));
var inst_28540 = cljs.core.boolean$(inst_28539);
var inst_28541 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28537,(110));
var inst_28542 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28537,(117));
var inst_28543 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_28542);
var inst_28544 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28537,(111));
var inst_28545 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28537,(115));
var inst_28546 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28537,(112));
var inst_28547 = [inst_28540,inst_28541,inst_28543,inst_28544,inst_28545,inst_28546];
var inst_28548 = cljs.core.PersistentHashMap.fromArrays(inst_28538,inst_28547);
var _ = (function (){var statearr_28555 = state_28553;
(statearr_28555[(4)] = cljs.core.rest((state_28553[(4)])));

return statearr_28555;
})();
var state_28553__$1 = state_28553;
var statearr_28556_28579 = state_28553__$1;
(statearr_28556_28579[(2)] = inst_28548);

(statearr_28556_28579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28554 === (1))){
var state_28553__$1 = state_28553;
var statearr_28557_28580 = state_28553__$1;
(statearr_28557_28580[(2)] = null);

(statearr_28557_28580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28554 === (4))){
var inst_28512 = (state_28553[(2)]);
var state_28553__$1 = state_28553;
var statearr_28558_28581 = state_28553__$1;
(statearr_28558_28581[(2)] = inst_28512);

(statearr_28558_28581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28554 === (6))){
var _ = (function (){var statearr_28559 = state_28553;
(statearr_28559[(4)] = cljs.core.cons((9),(state_28553[(4)])));

return statearr_28559;
})();
var inst_28524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28526 = ["_setting/id","root"];
var inst_28527 = (new cljs.core.PersistentVector(null,2,(5),inst_28525,inst_28526,null));
var inst_28528 = [inst_28527];
var inst_28529 = (new cljs.core.PersistentVector(null,1,(5),inst_28524,inst_28528,null));
var inst_28530 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_28529);
var state_28553__$1 = state_28553;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28553__$1,(10),inst_28530);
} else {
if((state_val_28554 === (3))){
var inst_28551 = (state_28553[(2)]);
var state_28553__$1 = state_28553;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28553__$1,inst_28551);
} else {
if((state_val_28554 === (2))){
var _ = (function (){var statearr_28562 = state_28553;
(statearr_28562[(4)] = cljs.core.cons((5),(state_28553[(4)])));

return statearr_28562;
})();
var state_28553__$1 = state_28553;
var statearr_28563_28582 = state_28553__$1;
(statearr_28563_28582[(2)] = null);

(statearr_28563_28582[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28554 === (9))){
var _ = (function (){var statearr_28564 = state_28553;
(statearr_28564[(4)] = cljs.core.rest((state_28553[(4)])));

return statearr_28564;
})();
var state_28553__$1 = state_28553;
var ex28560 = (state_28553__$1[(2)]);
var statearr_28565_28583 = state_28553__$1;
(statearr_28565_28583[(5)] = ex28560);


var statearr_28566_28584 = state_28553__$1;
(statearr_28566_28584[(1)] = (8));

(statearr_28566_28584[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28554 === (5))){
var _ = (function (){var statearr_28567 = state_28553;
(statearr_28567[(4)] = cljs.core.rest((state_28553[(4)])));

return statearr_28567;
})();
var state_28553__$1 = state_28553;
var ex28561 = (state_28553__$1[(2)]);
var statearr_28568_28585 = state_28553__$1;
(statearr_28568_28585[(5)] = ex28561);


if((ex28561 instanceof Error)){
var statearr_28569_28586 = state_28553__$1;
(statearr_28569_28586[(1)] = (4));

(statearr_28569_28586[(5)] = null);

} else {
throw ex28561;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28554 === (10))){
var inst_28532 = (state_28553[(2)]);
var inst_28533 = fluree.db.util.async.throw_err(inst_28532);
var _ = (function (){var statearr_28570 = state_28553;
(statearr_28570[(4)] = cljs.core.rest((state_28553[(4)])));

return statearr_28570;
})();
var state_28553__$1 = state_28553;
var statearr_28571_28587 = state_28553__$1;
(statearr_28571_28587[(2)] = inst_28533);

(statearr_28571_28587[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28554 === (8))){
var inst_28518 = (state_28553[(2)]);
var state_28553__$1 = (function (){var statearr_28572 = state_28553;
(statearr_28572[(7)] = inst_28518);

return statearr_28572;
})();
var statearr_28573_28588 = state_28553__$1;
(statearr_28573_28588[(2)] = null);

(statearr_28573_28588[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__11438__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__11438__auto____0 = (function (){
var statearr_28574 = [null,null,null,null,null,null,null,null];
(statearr_28574[(0)] = fluree$db$query$schema$setting_map_$_state_machine__11438__auto__);

(statearr_28574[(1)] = (1));

return statearr_28574;
});
var fluree$db$query$schema$setting_map_$_state_machine__11438__auto____1 = (function (state_28553){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_28553);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e28575){var ex__11441__auto__ = e28575;
var statearr_28576_28589 = state_28553;
(statearr_28576_28589[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_28553[(4)]))){
var statearr_28577_28590 = state_28553;
(statearr_28577_28590[(1)] = cljs.core.first((state_28553[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28591 = state_28553;
state_28553 = G__28591;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__11438__auto__ = function(state_28553){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__11438__auto____1.call(this,state_28553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__11438__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__11438__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_28578 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_28578[(6)] = c__11512__auto__);

return statearr_28578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
