// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k39826,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__39830 = k39826;
var G__39830__$1 = (((G__39830 instanceof cljs.core.Keyword))?G__39830.fqn:null);
switch (G__39830__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39826,else__5345__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5365__auto__,p__39831){
var vec__39832 = p__39831;
var k__5366__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39832,(0),null);
var v__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39832,(1),null);
return (f__5363__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5363__auto__.cljs$core$IFn$_invoke$arity$3(ret__5365__auto__,k__5366__auto__,v__5367__auto__) : f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__));
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer(writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer(writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.session.DbSession{",", ","}",opts__5359__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39825){
var self__ = this;
var G__39825__$1 = this;
return (new cljs.core.RecordIter((0),G__39825__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__39835 = (function (coll__5339__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__5339__auto__));
});
return fexpr__39835(this__5338__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this39827,other39828){
var self__ = this;
var this39827__$1 = this;
return (((!((other39828 == null)))) && ((((this39827__$1.constructor === other39828.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39827__$1.conn,other39828.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39827__$1.network,other39828.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39827__$1.dbid,other39828.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39827__$1.db_name,other39828.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39827__$1.update_chan,other39828.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39827__$1.transact_chan,other39828.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39827__$1.state,other39828.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39827__$1.schema_cache,other39828.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39827__$1.blank_db,other39828.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39827__$1.close,other39828.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39827__$1.id,other39828.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39827__$1.__extmap,other39828.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5353__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k39826){
var self__ = this;
var this__5349__auto____$1 = this;
var G__39836 = k39826;
var G__39836__$1 = (((G__39836 instanceof cljs.core.Keyword))?G__39836.fqn:null);
switch (G__39836__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k39826);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__39825){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__39837 = cljs.core.keyword_identical_QMARK_;
var expr__39838 = k__5351__auto__;
if(cljs.core.truth_((function (){var G__39840 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__39841 = expr__39838;
return (pred__39837.cljs$core$IFn$_invoke$arity$2 ? pred__39837.cljs$core$IFn$_invoke$arity$2(G__39840,G__39841) : pred__39837.call(null,G__39840,G__39841));
})())){
return (new fluree.db.session.DbSession(G__39825,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39842 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__39843 = expr__39838;
return (pred__39837.cljs$core$IFn$_invoke$arity$2 ? pred__39837.cljs$core$IFn$_invoke$arity$2(G__39842,G__39843) : pred__39837.call(null,G__39842,G__39843));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__39825,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39844 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__39845 = expr__39838;
return (pred__39837.cljs$core$IFn$_invoke$arity$2 ? pred__39837.cljs$core$IFn$_invoke$arity$2(G__39844,G__39845) : pred__39837.call(null,G__39844,G__39845));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__39825,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39846 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__39847 = expr__39838;
return (pred__39837.cljs$core$IFn$_invoke$arity$2 ? pred__39837.cljs$core$IFn$_invoke$arity$2(G__39846,G__39847) : pred__39837.call(null,G__39846,G__39847));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__39825,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39848 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__39849 = expr__39838;
return (pred__39837.cljs$core$IFn$_invoke$arity$2 ? pred__39837.cljs$core$IFn$_invoke$arity$2(G__39848,G__39849) : pred__39837.call(null,G__39848,G__39849));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__39825,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39850 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__39851 = expr__39838;
return (pred__39837.cljs$core$IFn$_invoke$arity$2 ? pred__39837.cljs$core$IFn$_invoke$arity$2(G__39850,G__39851) : pred__39837.call(null,G__39850,G__39851));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__39825,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39852 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__39853 = expr__39838;
return (pred__39837.cljs$core$IFn$_invoke$arity$2 ? pred__39837.cljs$core$IFn$_invoke$arity$2(G__39852,G__39853) : pred__39837.call(null,G__39852,G__39853));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__39825,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39854 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__39855 = expr__39838;
return (pred__39837.cljs$core$IFn$_invoke$arity$2 ? pred__39837.cljs$core$IFn$_invoke$arity$2(G__39854,G__39855) : pred__39837.call(null,G__39854,G__39855));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__39825,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39856 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__39857 = expr__39838;
return (pred__39837.cljs$core$IFn$_invoke$arity$2 ? pred__39837.cljs$core$IFn$_invoke$arity$2(G__39856,G__39857) : pred__39837.call(null,G__39856,G__39857));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__39825,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39858 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__39859 = expr__39838;
return (pred__39837.cljs$core$IFn$_invoke$arity$2 ? pred__39837.cljs$core$IFn$_invoke$arity$2(G__39858,G__39859) : pred__39837.call(null,G__39858,G__39859));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__39825,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39860 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__39861 = expr__39838;
return (pred__39837.cljs$core$IFn$_invoke$arity$2 ? pred__39837.cljs$core$IFn$_invoke$arity$2(G__39860,G__39861) : pred__39837.call(null,G__39860,G__39861));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__39825,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5351__auto__,G__39825),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__39825){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__39825,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write(writer__5389__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__39829){
var extmap__5384__auto__ = (function (){var G__39862 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39829,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__39829)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__39862);
} else {
return G__39862;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__39829),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__39829),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__39829),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__39829),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__39829),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__39829),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__39829),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__39829),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__39829),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__39829),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__39829),null,cljs.core.not_empty(extmap__5384__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__39865 = session;
var map__39865__$1 = cljs.core.__destructure_map(map__39865);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39865__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39865__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.ready_QMARK_ = (function fluree$db$session$ready_QMARK_(db_info){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(db_info)));
});
fluree.db.session.load_ledger_info = (function fluree$db$session$load_ledger_info(conn,network,dbid){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_39907){
var state_val_39908 = (state_39907[(1)]);
if((state_val_39908 === (7))){
var inst_39881 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," is not found on this ledger group."].join('');
var inst_39882 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39883 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_39884 = cljs.core.PersistentHashMap.fromArrays(inst_39882,inst_39883);
var inst_39885 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39881,inst_39884);
var inst_39886 = (function(){throw inst_39885})();
var state_39907__$1 = state_39907;
var statearr_39909_39932 = state_39907__$1;
(statearr_39909_39932[(2)] = inst_39886);

(statearr_39909_39932[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39908 === (1))){
var state_39907__$1 = state_39907;
var statearr_39910_39933 = state_39907__$1;
(statearr_39910_39933[(2)] = null);

(statearr_39910_39933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39908 === (4))){
var inst_39866 = (state_39907[(2)]);
var state_39907__$1 = state_39907;
var statearr_39911_39934 = state_39907__$1;
(statearr_39911_39934[(2)] = inst_39866);

(statearr_39911_39934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39908 === (6))){
var inst_39878 = (state_39907[(7)]);
var inst_39877 = (state_39907[(2)]);
var inst_39878__$1 = fluree.db.util.async.throw_err(inst_39877);
var inst_39879 = cljs.core.empty_QMARK_(inst_39878__$1);
var state_39907__$1 = (function (){var statearr_39912 = state_39907;
(statearr_39912[(7)] = inst_39878__$1);

return statearr_39912;
})();
if(inst_39879){
var statearr_39913_39935 = state_39907__$1;
(statearr_39913_39935[(1)] = (7));

} else {
var statearr_39914_39936 = state_39907__$1;
(statearr_39914_39936[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39908 === (3))){
var inst_39905 = (state_39907[(2)]);
var state_39907__$1 = state_39907;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39907__$1,inst_39905);
} else {
if((state_val_39908 === (12))){
var inst_39900 = (state_39907[(2)]);
var state_39907__$1 = state_39907;
var statearr_39915_39937 = state_39907__$1;
(statearr_39915_39937[(2)] = inst_39900);

(statearr_39915_39937[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39908 === (2))){
var _ = (function (){var statearr_39916 = state_39907;
(statearr_39916[(4)] = cljs.core.cons((5),(state_39907[(4)])));

return statearr_39916;
})();
var inst_39872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39873 = [network,dbid];
var inst_39874 = (new cljs.core.PersistentVector(null,2,(5),inst_39872,inst_39873,null));
var inst_39875 = fluree.db.operations.ledger_info_async(conn,inst_39874);
var state_39907__$1 = state_39907;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39907__$1,(6),inst_39875);
} else {
if((state_val_39908 === (11))){
var inst_39878 = (state_39907[(7)]);
var state_39907__$1 = state_39907;
var statearr_39918_39938 = state_39907__$1;
(statearr_39918_39938[(2)] = inst_39878);

(statearr_39918_39938[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39908 === (9))){
var inst_39902 = (state_39907[(2)]);
var _ = (function (){var statearr_39919 = state_39907;
(statearr_39919[(4)] = cljs.core.rest((state_39907[(4)])));

return statearr_39919;
})();
var state_39907__$1 = state_39907;
var statearr_39920_39939 = state_39907__$1;
(statearr_39920_39939[(2)] = inst_39902);

(statearr_39920_39939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39908 === (5))){
var _ = (function (){var statearr_39921 = state_39907;
(statearr_39921[(4)] = cljs.core.rest((state_39907[(4)])));

return statearr_39921;
})();
var state_39907__$1 = state_39907;
var ex39917 = (state_39907__$1[(2)]);
var statearr_39922_39940 = state_39907__$1;
(statearr_39922_39940[(5)] = ex39917);


if((ex39917 instanceof Error)){
var statearr_39923_39941 = state_39907__$1;
(statearr_39923_39941[(1)] = (4));

(statearr_39923_39941[(5)] = null);

} else {
throw ex39917;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39908 === (10))){
var inst_39878 = (state_39907[(7)]);
var inst_39891 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_39878);
var inst_39892 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39891),"."].join('');
var inst_39893 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39894 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_39895 = cljs.core.PersistentHashMap.fromArrays(inst_39893,inst_39894);
var inst_39896 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39892,inst_39895);
var inst_39897 = (function(){throw inst_39896})();
var state_39907__$1 = state_39907;
var statearr_39924_39942 = state_39907__$1;
(statearr_39924_39942[(2)] = inst_39897);

(statearr_39924_39942[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39908 === (8))){
var inst_39878 = (state_39907[(7)]);
var inst_39888 = fluree.db.session.ready_QMARK_(inst_39878);
var inst_39889 = (!(inst_39888));
var state_39907__$1 = state_39907;
if(inst_39889){
var statearr_39925_39943 = state_39907__$1;
(statearr_39925_39943[(1)] = (10));

} else {
var statearr_39926_39944 = state_39907__$1;
(statearr_39926_39944[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_ledger_info_$_state_machine__11438__auto__ = null;
var fluree$db$session$load_ledger_info_$_state_machine__11438__auto____0 = (function (){
var statearr_39927 = [null,null,null,null,null,null,null,null];
(statearr_39927[(0)] = fluree$db$session$load_ledger_info_$_state_machine__11438__auto__);

(statearr_39927[(1)] = (1));

return statearr_39927;
});
var fluree$db$session$load_ledger_info_$_state_machine__11438__auto____1 = (function (state_39907){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_39907);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e39928){var ex__11441__auto__ = e39928;
var statearr_39929_39945 = state_39907;
(statearr_39929_39945[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_39907[(4)]))){
var statearr_39930_39946 = state_39907;
(statearr_39930_39946[(1)] = cljs.core.first((state_39907[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39947 = state_39907;
state_39907 = G__39947;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$session$load_ledger_info_$_state_machine__11438__auto__ = function(state_39907){
switch(arguments.length){
case 0:
return fluree$db$session$load_ledger_info_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$session$load_ledger_info_$_state_machine__11438__auto____1.call(this,state_39907);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_ledger_info_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_ledger_info_$_state_machine__11438__auto____0;
fluree$db$session$load_ledger_info_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_ledger_info_$_state_machine__11438__auto____1;
return fluree$db$session$load_ledger_info_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_39931 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_39931[(6)] = c__11512__auto__);

return statearr_39931;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.session.load_current_db = (function fluree$db$session$load_current_db(conn,p__39948){
var map__39949 = p__39948;
var map__39949__$1 = cljs.core.__destructure_map(map__39949);
var blank_db = map__39949__$1;
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39949__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39949__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_40024){
var state_val_40025 = (state_40024[(1)]);
if((state_val_40025 === (7))){
var inst_39967 = (state_40024[(7)]);
var inst_39966 = (state_40024[(2)]);
var inst_39967__$1 = fluree.db.util.async.throw_err(inst_39966);
var state_40024__$1 = (function (){var statearr_40026 = state_40024;
(statearr_40026[(7)] = inst_39967__$1);

return statearr_40026;
})();
if(cljs.core.truth_(inst_39967__$1)){
var statearr_40027_40062 = state_40024__$1;
(statearr_40027_40062[(1)] = (8));

} else {
var statearr_40028_40063 = state_40024__$1;
(statearr_40028_40063[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40025 === (20))){
var inst_39972 = (state_40024[(8)]);
var inst_40005 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39972)," for ledger: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid),"."].join('');
var inst_40006 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_40007 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_40008 = cljs.core.PersistentHashMap.fromArrays(inst_40006,inst_40007);
var inst_40009 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40005,inst_40008);
var inst_40010 = (function(){throw inst_40009})();
var state_40024__$1 = state_40024;
var statearr_40029_40064 = state_40024__$1;
(statearr_40029_40064[(2)] = inst_40010);

(statearr_40029_40064[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40025 === (1))){
var state_40024__$1 = state_40024;
var statearr_40030_40065 = state_40024__$1;
(statearr_40030_40065[(2)] = null);

(statearr_40030_40065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40025 === (4))){
var inst_39950 = (state_40024[(2)]);
var state_40024__$1 = state_40024;
var statearr_40031_40066 = state_40024__$1;
(statearr_40031_40066[(2)] = inst_39950);

(statearr_40031_40066[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40025 === (15))){
var inst_40014 = (state_40024[(2)]);
var state_40024__$1 = state_40024;
var statearr_40032_40067 = state_40024__$1;
(statearr_40032_40067[(2)] = inst_40014);

(statearr_40032_40067[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40025 === (21))){
var inst_40012 = (state_40024[(2)]);
var state_40024__$1 = state_40024;
var statearr_40033_40068 = state_40024__$1;
(statearr_40033_40068[(2)] = inst_40012);

(statearr_40033_40068[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40025 === (13))){
var inst_39971 = (state_40024[(9)]);
var inst_39976 = fluree.db.query.schema.schema_map(inst_39971);
var inst_39977 = fluree.db.query.schema.setting_map(inst_39971);
var inst_39978 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(inst_39971);
var inst_39979 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_39978,cljs.core.empty);
var state_40024__$1 = (function (){var statearr_40034 = state_40024;
(statearr_40034[(10)] = inst_39977);

(statearr_40034[(11)] = inst_39979);

return statearr_40034;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40024__$1,(16),inst_39976);
} else {
if((state_val_40025 === (22))){
var inst_39972 = (state_40024[(8)]);
var inst_40000 = (state_40024[(2)]);
var inst_40001 = fluree.db.util.async.throw_err(inst_40000);
var inst_40002 = (inst_39972 + (1));
var inst_39971 = inst_40001;
var inst_39972__$1 = inst_40002;
var state_40024__$1 = (function (){var statearr_40035 = state_40024;
(statearr_40035[(9)] = inst_39971);

(statearr_40035[(8)] = inst_39972__$1);

return statearr_40035;
})();
var statearr_40036_40069 = state_40024__$1;
(statearr_40036_40069[(2)] = null);

(statearr_40036_40069[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40025 === (6))){
var inst_39959 = (state_40024[(2)]);
var inst_39960 = fluree.db.util.async.throw_err(inst_39959);
var inst_39961 = cljs.core.__destructure_map(inst_39960);
var inst_39962 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39961,new cljs.core.Keyword(null,"block","block",664686210));
var inst_39963 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39961,new cljs.core.Keyword(null,"index","index",-1531685915));
var inst_39964 = fluree.db.storage.core.reify_db(conn,network,dbid,blank_db,inst_39963);
var state_40024__$1 = (function (){var statearr_40037 = state_40024;
(statearr_40037[(12)] = inst_39962);

return statearr_40037;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40024__$1,(7),inst_39964);
} else {
if((state_val_40025 === (17))){
var inst_39971 = (state_40024[(9)]);
var inst_39982 = (state_40024[(13)]);
var inst_39984 = (state_40024[(2)]);
var inst_39985 = fluree.db.util.async.throw_err(inst_39984);
var inst_39986 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_39971,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_39982,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"settings","settings",1556144875),inst_39985], 0));
var state_40024__$1 = state_40024;
var statearr_40038_40070 = state_40024__$1;
(statearr_40038_40070[(2)] = inst_39986);

(statearr_40038_40070[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40025 === (3))){
var inst_40022 = (state_40024[(2)]);
var state_40024__$1 = state_40024;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40024__$1,inst_40022);
} else {
if((state_val_40025 === (12))){
var inst_40016 = (state_40024[(2)]);
var state_40024__$1 = state_40024;
var statearr_40039_40071 = state_40024__$1;
(statearr_40039_40071[(2)] = inst_40016);

(statearr_40039_40071[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40025 === (2))){
var _ = (function (){var statearr_40040 = state_40024;
(statearr_40040[(4)] = cljs.core.cons((5),(state_40024[(4)])));

return statearr_40040;
})();
var inst_39957 = fluree.db.session.load_ledger_info(conn,network,dbid);
var state_40024__$1 = state_40024;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40024__$1,(6),inst_39957);
} else {
if((state_val_40025 === (19))){
var inst_39971 = (state_40024[(9)]);
var inst_39991 = (state_40024[(14)]);
var inst_39994 = cljs.core.__destructure_map(inst_39991);
var inst_39995 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39994,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_39996 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39994,new cljs.core.Keyword(null,"block","block",664686210));
var inst_39997 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39994,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_39998 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_39971,inst_39996,inst_39995);
var state_40024__$1 = (function (){var statearr_40041 = state_40024;
(statearr_40041[(15)] = inst_39997);

return statearr_40041;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40024__$1,(22),inst_39998);
} else {
if((state_val_40025 === (11))){
var inst_39972 = (state_40024[(8)]);
var inst_39962 = (state_40024[(12)]);
var inst_39974 = (inst_39972 > inst_39962);
var state_40024__$1 = state_40024;
if(cljs.core.truth_(inst_39974)){
var statearr_40043_40072 = state_40024__$1;
(statearr_40043_40072[(1)] = (13));

} else {
var statearr_40044_40073 = state_40024__$1;
(statearr_40044_40073[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40025 === (9))){
var state_40024__$1 = state_40024;
var statearr_40045_40074 = state_40024__$1;
(statearr_40045_40074[(2)] = null);

(statearr_40045_40074[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40025 === (5))){
var _ = (function (){var statearr_40046 = state_40024;
(statearr_40046[(4)] = cljs.core.rest((state_40024[(4)])));

return statearr_40046;
})();
var state_40024__$1 = state_40024;
var ex40042 = (state_40024__$1[(2)]);
var statearr_40047_40075 = state_40024__$1;
(statearr_40047_40075[(5)] = ex40042);


if((ex40042 instanceof Error)){
var statearr_40048_40076 = state_40024__$1;
(statearr_40048_40076[(1)] = (4));

(statearr_40048_40076[(5)] = null);

} else {
throw ex40042;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40025 === (14))){
var inst_39972 = (state_40024[(8)]);
var inst_39988 = fluree.db.storage.core.read_block(conn,network,dbid,inst_39972);
var state_40024__$1 = state_40024;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40024__$1,(18),inst_39988);
} else {
if((state_val_40025 === (16))){
var inst_39977 = (state_40024[(10)]);
var inst_39981 = (state_40024[(2)]);
var inst_39982 = fluree.db.util.async.throw_err(inst_39981);
var state_40024__$1 = (function (){var statearr_40049 = state_40024;
(statearr_40049[(13)] = inst_39982);

return statearr_40049;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40024__$1,(17),inst_39977);
} else {
if((state_val_40025 === (10))){
var inst_40019 = (state_40024[(2)]);
var _ = (function (){var statearr_40050 = state_40024;
(statearr_40050[(4)] = cljs.core.rest((state_40024[(4)])));

return statearr_40050;
})();
var state_40024__$1 = state_40024;
var statearr_40051_40077 = state_40024__$1;
(statearr_40051_40077[(2)] = inst_40019);

(statearr_40051_40077[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40025 === (18))){
var inst_39991 = (state_40024[(14)]);
var inst_39990 = (state_40024[(2)]);
var inst_39991__$1 = fluree.db.util.async.throw_err(inst_39990);
var state_40024__$1 = (function (){var statearr_40052 = state_40024;
(statearr_40052[(14)] = inst_39991__$1);

return statearr_40052;
})();
if(cljs.core.truth_(inst_39991__$1)){
var statearr_40053_40078 = state_40024__$1;
(statearr_40053_40078[(1)] = (19));

} else {
var statearr_40054_40079 = state_40024__$1;
(statearr_40054_40079[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40025 === (8))){
var inst_39967 = (state_40024[(7)]);
var inst_39969 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_39967);
var inst_39970 = (inst_39969 + (1));
var inst_39971 = inst_39967;
var inst_39972 = inst_39970;
var state_40024__$1 = (function (){var statearr_40055 = state_40024;
(statearr_40055[(9)] = inst_39971);

(statearr_40055[(8)] = inst_39972);

return statearr_40055;
})();
var statearr_40056_40080 = state_40024__$1;
(statearr_40056_40080[(2)] = null);

(statearr_40056_40080[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_current_db_$_state_machine__11438__auto__ = null;
var fluree$db$session$load_current_db_$_state_machine__11438__auto____0 = (function (){
var statearr_40057 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40057[(0)] = fluree$db$session$load_current_db_$_state_machine__11438__auto__);

(statearr_40057[(1)] = (1));

return statearr_40057;
});
var fluree$db$session$load_current_db_$_state_machine__11438__auto____1 = (function (state_40024){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_40024);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e40058){var ex__11441__auto__ = e40058;
var statearr_40059_40081 = state_40024;
(statearr_40059_40081[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_40024[(4)]))){
var statearr_40060_40082 = state_40024;
(statearr_40060_40082[(1)] = cljs.core.first((state_40024[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40083 = state_40024;
state_40024 = G__40083;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$session$load_current_db_$_state_machine__11438__auto__ = function(state_40024){
switch(arguments.length){
case 0:
return fluree$db$session$load_current_db_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$session$load_current_db_$_state_machine__11438__auto____1.call(this,state_40024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_current_db_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_current_db_$_state_machine__11438__auto____0;
fluree$db$session$load_current_db_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_current_db_$_state_machine__11438__auto____1;
return fluree$db$session$load_current_db_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_40061 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_40061[(6)] = c__11512__auto__);

return statearr_40061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Perform a compare and set operation to update the db stored in the session
 *   argument's state atom. Update the cache to `new-db-ch`, but only if the
 *   previously stored db channel is the same as the `old-db-ch`. Returns a boolean
 *   indicating whether the cache was updated.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(p__40084,old_db_ch,new_db_ch){
var map__40085 = p__40084;
var map__40085__$1 = cljs.core.__destructure_map(map__40085);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40085__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (p__40086){
var map__40087 = p__40086;
var map__40087__$1 = cljs.core.__destructure_map(map__40087);
var s = map__40087__$1;
var current = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40087__$1,new cljs.core.Keyword("db","current","db/current",-1088041545));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current,old_db_ch)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","current","db/current",-1088041545),new_db_ch);
} else {
return s;
}
}))),new_db_ch);
});
/**
 * Clears db channel from session state, forcing a new full load next time db
 *   channel is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(p__40088){
var map__40089 = p__40088;
var map__40089__$1 = cljs.core.__destructure_map(map__40089);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40089__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
});
/**
 * Clears any cached database channels and forces an immediate reload. Returns a
 *   channel that will contain the newly loaded database
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(p__40090){
var map__40091 = p__40090;
var map__40091__$1 = cljs.core.__destructure_map(map__40091);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40091__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var blank_db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40091__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40091__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var db_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),db_ch);

var c__11512__auto___40128 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_40111){
var state_val_40112 = (state_40111[(1)]);
if((state_val_40112 === (1))){
var state_40111__$1 = state_40111;
var statearr_40113_40129 = state_40111__$1;
(statearr_40113_40129[(2)] = null);

(statearr_40113_40129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40112 === (2))){
var _ = (function (){var statearr_40114 = state_40111;
(statearr_40114[(4)] = cljs.core.cons((5),(state_40111[(4)])));

return statearr_40114;
})();
var inst_40101 = fluree.db.session.load_current_db(conn,blank_db);
var state_40111__$1 = state_40111;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40111__$1,(6),inst_40101);
} else {
if((state_val_40112 === (3))){
var inst_40109 = (state_40111[(2)]);
var state_40111__$1 = state_40111;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40111__$1,inst_40109);
} else {
if((state_val_40112 === (4))){
var inst_40092 = (state_40111[(2)]);
var inst_40093 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_40094 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40092,"Error reloading db"], 0));
var inst_40095 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(db_ch,inst_40092);
var state_40111__$1 = (function (){var statearr_40116 = state_40111;
(statearr_40116[(7)] = inst_40094);

(statearr_40116[(8)] = inst_40093);

return statearr_40116;
})();
var statearr_40117_40130 = state_40111__$1;
(statearr_40117_40130[(2)] = inst_40095);

(statearr_40117_40130[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40112 === (5))){
var _ = (function (){var statearr_40118 = state_40111;
(statearr_40118[(4)] = cljs.core.rest((state_40111[(4)])));

return statearr_40118;
})();
var state_40111__$1 = state_40111;
var ex40115 = (state_40111__$1[(2)]);
var statearr_40119_40131 = state_40111__$1;
(statearr_40119_40131[(5)] = ex40115);


var statearr_40120_40132 = state_40111__$1;
(statearr_40120_40132[(1)] = (4));

(statearr_40120_40132[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40112 === (6))){
var inst_40103 = (state_40111[(2)]);
var inst_40104 = fluree.db.util.async.throw_err(inst_40103);
var state_40111__$1 = state_40111;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40111__$1,(7),db_ch,inst_40104);
} else {
if((state_val_40112 === (7))){
var inst_40106 = (state_40111[(2)]);
var _ = (function (){var statearr_40121 = state_40111;
(statearr_40121[(4)] = cljs.core.rest((state_40111[(4)])));

return statearr_40121;
})();
var state_40111__$1 = state_40111;
var statearr_40122_40133 = state_40111__$1;
(statearr_40122_40133[(2)] = inst_40106);

(statearr_40122_40133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$reload_db_BANG__$_state_machine__11438__auto__ = null;
var fluree$db$session$reload_db_BANG__$_state_machine__11438__auto____0 = (function (){
var statearr_40123 = [null,null,null,null,null,null,null,null,null];
(statearr_40123[(0)] = fluree$db$session$reload_db_BANG__$_state_machine__11438__auto__);

(statearr_40123[(1)] = (1));

return statearr_40123;
});
var fluree$db$session$reload_db_BANG__$_state_machine__11438__auto____1 = (function (state_40111){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_40111);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e40124){var ex__11441__auto__ = e40124;
var statearr_40125_40134 = state_40111;
(statearr_40125_40134[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_40111[(4)]))){
var statearr_40126_40135 = state_40111;
(statearr_40126_40135[(1)] = cljs.core.first((state_40111[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40136 = state_40111;
state_40111 = G__40136;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$session$reload_db_BANG__$_state_machine__11438__auto__ = function(state_40111){
switch(arguments.length){
case 0:
return fluree$db$session$reload_db_BANG__$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$session$reload_db_BANG__$_state_machine__11438__auto____1.call(this,state_40111);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$reload_db_BANG__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$reload_db_BANG__$_state_machine__11438__auto____0;
fluree$db$session$reload_db_BANG__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$reload_db_BANG__$_state_machine__11438__auto____1;
return fluree$db$session$reload_db_BANG__$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_40127 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_40127[(6)] = c__11512__auto___40128);

return statearr_40127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return db_ch;
});
/**
 * Gets the channel containing the current database from the session's state. If
 *   no database channel is cached then the current database is loaded form storage
 *   and a new channel containing it is cached. Returns the cached channel that
 *   will contain the current database
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(var_args){
var G__40138 = arguments.length;
switch (G__40138) {
case 1:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 = (function (p__40139){
var map__40140 = p__40139;
var map__40140__$1 = cljs.core.__destructure_map(map__40140);
var session = map__40140__$1;
var blank_db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40140__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2(session,blank_db);
}));

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2 = (function (p__40141,blank_db){
var map__40142 = p__40141;
var map__40142__$1 = cljs.core.__destructure_map(map__40142);
var session = map__40142__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40142__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40142__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (s){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis()),new cljs.core.Keyword("req","count","req/count",2145574363),cljs.core.inc);
}));

var or__5045__auto__ = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var cur_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var state_ch = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (s){
if(cljs.core.not(new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(s))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_ch);
} else {
return s;
}
})));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cur_ch,state_ch)){
var c__11512__auto___40180 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_40162){
var state_val_40163 = (state_40162[(1)]);
if((state_val_40163 === (1))){
var state_40162__$1 = state_40162;
var statearr_40164_40181 = state_40162__$1;
(statearr_40164_40181[(2)] = null);

(statearr_40164_40181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40163 === (2))){
var _ = (function (){var statearr_40165 = state_40162;
(statearr_40165[(4)] = cljs.core.cons((5),(state_40162[(4)])));

return statearr_40165;
})();
var inst_40152 = fluree.db.session.load_current_db(conn,blank_db);
var state_40162__$1 = state_40162;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40162__$1,(6),inst_40152);
} else {
if((state_val_40163 === (3))){
var inst_40160 = (state_40162[(2)]);
var state_40162__$1 = state_40162;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40162__$1,inst_40160);
} else {
if((state_val_40163 === (4))){
var inst_40143 = (state_40162[(2)]);
var inst_40144 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_40145 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40143,"Error loading current db"], 0));
var inst_40146 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cur_ch,inst_40143);
var state_40162__$1 = (function (){var statearr_40167 = state_40162;
(statearr_40167[(7)] = inst_40145);

(statearr_40167[(8)] = inst_40144);

return statearr_40167;
})();
var statearr_40168_40182 = state_40162__$1;
(statearr_40168_40182[(2)] = inst_40146);

(statearr_40168_40182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40163 === (5))){
var _ = (function (){var statearr_40169 = state_40162;
(statearr_40169[(4)] = cljs.core.rest((state_40162[(4)])));

return statearr_40169;
})();
var state_40162__$1 = state_40162;
var ex40166 = (state_40162__$1[(2)]);
var statearr_40170_40183 = state_40162__$1;
(statearr_40170_40183[(5)] = ex40166);


var statearr_40171_40184 = state_40162__$1;
(statearr_40171_40184[(1)] = (4));

(statearr_40171_40184[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40163 === (6))){
var inst_40154 = (state_40162[(2)]);
var inst_40155 = fluree.db.util.async.throw_err(inst_40154);
var state_40162__$1 = state_40162;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40162__$1,(7),cur_ch,inst_40155);
} else {
if((state_val_40163 === (7))){
var inst_40157 = (state_40162[(2)]);
var _ = (function (){var statearr_40172 = state_40162;
(statearr_40172[(4)] = cljs.core.rest((state_40162[(4)])));

return statearr_40172;
})();
var state_40162__$1 = state_40162;
var statearr_40173_40185 = state_40162__$1;
(statearr_40173_40185[(2)] = inst_40157);

(statearr_40173_40185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__11438__auto__ = null;
var fluree$db$session$state_machine__11438__auto____0 = (function (){
var statearr_40174 = [null,null,null,null,null,null,null,null,null];
(statearr_40174[(0)] = fluree$db$session$state_machine__11438__auto__);

(statearr_40174[(1)] = (1));

return statearr_40174;
});
var fluree$db$session$state_machine__11438__auto____1 = (function (state_40162){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_40162);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e40175){var ex__11441__auto__ = e40175;
var statearr_40176_40186 = state_40162;
(statearr_40176_40186[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_40162[(4)]))){
var statearr_40177_40187 = state_40162;
(statearr_40177_40187[(1)] = cljs.core.first((state_40162[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40188 = state_40162;
state_40162 = G__40188;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$session$state_machine__11438__auto__ = function(state_40162){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__11438__auto____1.call(this,state_40162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__11438__auto____0;
fluree$db$session$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__11438__auto____1;
return fluree$db$session$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_40178 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_40178[(6)] = c__11512__auto___40180);

return statearr_40178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return cur_ch;
} else {
return state_ch;
}
}
}));

(fluree.db.session.current_db.cljs$lang$maxFixedArity = 2);

/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__5641__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5645__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__40189 = cljs.core.get_global_hierarchy;
return (fexpr__40189.cljs$core$IFn$_invoke$arity$0 ? fexpr__40189.cljs$core$IFn$_invoke$arity$0() : fexpr__40189.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5645__auto__,method_table__5641__auto__,prefer_table__5642__auto__,method_cache__5643__auto__,cached_hierarchy__5644__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_40191){
var state_val_40192 = (state_40191[(1)]);
if((state_val_40192 === (1))){
var state_40191__$1 = state_40191;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40191__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__11438__auto__ = null;
var fluree$db$session$state_machine__11438__auto____0 = (function (){
var statearr_40193 = [null,null,null,null,null,null,null];
(statearr_40193[(0)] = fluree$db$session$state_machine__11438__auto__);

(statearr_40193[(1)] = (1));

return statearr_40193;
});
var fluree$db$session$state_machine__11438__auto____1 = (function (state_40191){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_40191);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e40194){var ex__11441__auto__ = e40194;
var statearr_40195_40198 = state_40191;
(statearr_40195_40198[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_40191[(4)]))){
var statearr_40196_40199 = state_40191;
(statearr_40196_40199[(1)] = cljs.core.first((state_40191[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40200 = state_40191;
state_40191 = G__40200;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$session$state_machine__11438__auto__ = function(state_40191){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__11438__auto____1.call(this,state_40191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__11438__auto____0;
fluree$db$session$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__11438__auto____1;
return fluree$db$session$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_40197 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_40197[(6)] = c__11512__auto__);

return statearr_40197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__40201){
var map__40202 = p__40201;
var map__40202__$1 = cljs.core.__destructure_map(map__40202);
var data = map__40202__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40202__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40202__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40202__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_40261){
var state_val_40262 = (state_40261[(1)]);
if((state_val_40262 === (7))){
var inst_40213 = (state_40261[(7)]);
var inst_40216 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_40217 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_40218 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40216),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40217),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40213),". No-op."].join('');
var inst_40219 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40218], 0));
var state_40261__$1 = state_40261;
var statearr_40263_40301 = state_40261__$1;
(statearr_40263_40301[(2)] = inst_40219);

(statearr_40263_40301[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40262 === (1))){
var state_40261__$1 = state_40261;
var statearr_40264_40302 = state_40261__$1;
(statearr_40264_40302[(2)] = null);

(statearr_40264_40302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40262 === (4))){
var inst_40203 = (state_40261[(2)]);
var state_40261__$1 = state_40261;
var statearr_40265_40303 = state_40261__$1;
(statearr_40265_40303[(2)] = inst_40203);

(statearr_40265_40303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40262 === (15))){
var inst_40242 = (state_40261[(2)]);
var state_40261__$1 = state_40261;
var statearr_40266_40304 = state_40261__$1;
(statearr_40266_40304[(2)] = inst_40242);

(statearr_40266_40304[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40262 === (13))){
var inst_40233 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_40234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40235 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_40236 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_40237 = [inst_40235,inst_40236];
var inst_40238 = (new cljs.core.PersistentVector(null,2,(5),inst_40234,inst_40237,null));
var inst_40239 = (function (){var G__40267 = inst_40233;
var G__40268 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__40269 = inst_40238;
var G__40270 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__40267,G__40268,G__40269,G__40270) : fluree.db.conn_events.process_event.call(null,G__40267,G__40268,G__40269,G__40270));
})();
var state_40261__$1 = state_40261;
var statearr_40271_40305 = state_40261__$1;
(statearr_40271_40305[(2)] = inst_40239);

(statearr_40271_40305[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40262 === (6))){
var inst_40212 = (state_40261[(8)]);
var inst_40213 = (state_40261[(7)]);
var inst_40211 = (state_40261[(2)]);
var inst_40212__$1 = fluree.db.util.async.throw_err(inst_40211);
var inst_40213__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_40212__$1);
var inst_40214 = (block <= inst_40213__$1);
var state_40261__$1 = (function (){var statearr_40272 = state_40261;
(statearr_40272[(8)] = inst_40212__$1);

(statearr_40272[(7)] = inst_40213__$1);

return statearr_40272;
})();
if(cljs.core.truth_(inst_40214)){
var statearr_40273_40306 = state_40261__$1;
(statearr_40273_40306[(1)] = (7));

} else {
var statearr_40274_40307 = state_40261__$1;
(statearr_40274_40307[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40262 === (17))){
var state_40261__$1 = state_40261;
var statearr_40275_40308 = state_40261__$1;
(statearr_40275_40308[(2)] = null);

(statearr_40275_40308[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40262 === (3))){
var inst_40259 = (state_40261[(2)]);
var state_40261__$1 = state_40261;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40261__$1,inst_40259);
} else {
if((state_val_40262 === (12))){
var inst_40254 = (state_40261[(2)]);
var state_40261__$1 = state_40261;
var statearr_40276_40309 = state_40261__$1;
(statearr_40276_40309[(2)] = inst_40254);

(statearr_40276_40309[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40262 === (2))){
var inst_40209 = (state_40261[(9)]);
var _ = (function (){var statearr_40277 = state_40261;
(statearr_40277[(4)] = cljs.core.cons((5),(state_40261[(4)])));

return statearr_40277;
})();
var inst_40209__$1 = fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session);
var state_40261__$1 = (function (){var statearr_40278 = state_40261;
(statearr_40278[(9)] = inst_40209__$1);

return statearr_40278;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40261__$1,(6),inst_40209__$1);
} else {
if((state_val_40262 === (11))){
var state_40261__$1 = state_40261;
var statearr_40280_40310 = state_40261__$1;
(statearr_40280_40310[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40262 === (9))){
var inst_40256 = (state_40261[(2)]);
var _ = (function (){var statearr_40282 = state_40261;
(statearr_40282[(4)] = cljs.core.rest((state_40261[(4)])));

return statearr_40282;
})();
var state_40261__$1 = state_40261;
var statearr_40283_40311 = state_40261__$1;
(statearr_40283_40311[(2)] = inst_40256);

(statearr_40283_40311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40262 === (5))){
var _ = (function (){var statearr_40284 = state_40261;
(statearr_40284[(4)] = cljs.core.rest((state_40261[(4)])));

return statearr_40284;
})();
var state_40261__$1 = state_40261;
var ex40279 = (state_40261__$1[(2)]);
var statearr_40285_40312 = state_40261__$1;
(statearr_40285_40312[(5)] = ex40279);


if((ex40279 instanceof Error)){
var statearr_40286_40313 = state_40261__$1;
(statearr_40286_40313[(1)] = (4));

(statearr_40286_40313[(5)] = null);

} else {
throw ex40279;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40262 === (14))){
var state_40261__$1 = state_40261;
var statearr_40287_40314 = state_40261__$1;
(statearr_40287_40314[(2)] = null);

(statearr_40287_40314[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40262 === (16))){
var inst_40213 = (state_40261[(7)]);
var inst_40245 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_40246 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_40247 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40245),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40246),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40213),". Forcing a db reload."].join('');
var inst_40248 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40247], 0));
var inst_40249 = fluree.db.session.reload_db_BANG_(session);
var state_40261__$1 = (function (){var statearr_40288 = state_40261;
(statearr_40288[(10)] = inst_40248);

return statearr_40288;
})();
var statearr_40289_40315 = state_40261__$1;
(statearr_40289_40315[(2)] = inst_40249);

(statearr_40289_40315[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40262 === (10))){
var inst_40209 = (state_40261[(9)]);
var inst_40212 = (state_40261[(8)]);
var inst_40213 = (state_40261[(7)]);
var inst_40224 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_40225 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_40226 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40224),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40225),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_40227 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40226], 0));
var inst_40228 = (function (){var current_db_ch = inst_40209;
var current_db = inst_40212;
var current_block = inst_40213;
return (function (f){
if((f instanceof fluree.db.flake.Flake)){
return f;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(f);
}
});
})();
var inst_40229 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_40228,flakes);
var inst_40230 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_40212,block,inst_40229);
var inst_40231 = fluree.db.session.cas_db_BANG_(session,inst_40209,inst_40230);
var state_40261__$1 = (function (){var statearr_40290 = state_40261;
(statearr_40290[(11)] = inst_40227);

return statearr_40290;
})();
if(inst_40231){
var statearr_40291_40316 = state_40261__$1;
(statearr_40291_40316[(1)] = (13));

} else {
var statearr_40292_40317 = state_40261__$1;
(statearr_40292_40317[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40262 === (18))){
var inst_40252 = (state_40261[(2)]);
var state_40261__$1 = state_40261;
var statearr_40293_40318 = state_40261__$1;
(statearr_40293_40318[(2)] = inst_40252);

(statearr_40293_40318[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40262 === (8))){
var inst_40213 = (state_40261[(7)]);
var inst_40221 = ((1) + inst_40213);
var inst_40222 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_40221);
var state_40261__$1 = state_40261;
if(inst_40222){
var statearr_40294_40319 = state_40261__$1;
(statearr_40294_40319[(1)] = (10));

} else {
var statearr_40295_40320 = state_40261__$1;
(statearr_40295_40320[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__11438__auto__ = null;
var fluree$db$session$state_machine__11438__auto____0 = (function (){
var statearr_40296 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40296[(0)] = fluree$db$session$state_machine__11438__auto__);

(statearr_40296[(1)] = (1));

return statearr_40296;
});
var fluree$db$session$state_machine__11438__auto____1 = (function (state_40261){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_40261);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e40297){var ex__11441__auto__ = e40297;
var statearr_40298_40321 = state_40261;
(statearr_40298_40321[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_40261[(4)]))){
var statearr_40299_40322 = state_40261;
(statearr_40299_40322[(1)] = cljs.core.first((state_40261[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40323 = state_40261;
state_40261 = G__40323;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$session$state_machine__11438__auto__ = function(state_40261){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__11438__auto____1.call(this,state_40261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__11438__auto____0;
fluree$db$session$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__11438__auto____1;
return fluree$db$session$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_40300 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_40300[(6)] = c__11512__auto__);

return statearr_40300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_40330){
var state_val_40331 = (state_40330[(1)]);
if((state_val_40331 === (1))){
var inst_40324 = fluree.db.session.clear_db_BANG_(session);
var inst_40325 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_40326 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_40327 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40325),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40326)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_40328 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40327], 0));
var state_40330__$1 = (function (){var statearr_40332 = state_40330;
(statearr_40332[(7)] = inst_40328);

(statearr_40332[(8)] = inst_40324);

return statearr_40332;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_40330__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__11438__auto__ = null;
var fluree$db$session$state_machine__11438__auto____0 = (function (){
var statearr_40333 = [null,null,null,null,null,null,null,null,null];
(statearr_40333[(0)] = fluree$db$session$state_machine__11438__auto__);

(statearr_40333[(1)] = (1));

return statearr_40333;
});
var fluree$db$session$state_machine__11438__auto____1 = (function (state_40330){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_40330);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e40334){var ex__11441__auto__ = e40334;
var statearr_40335_40338 = state_40330;
(statearr_40335_40338[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_40330[(4)]))){
var statearr_40336_40339 = state_40330;
(statearr_40336_40339[(1)] = cljs.core.first((state_40330[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40340 = state_40330;
state_40330 = G__40340;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$session$state_machine__11438__auto__ = function(state_40330){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__11438__auto____1.call(this,state_40330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__11438__auto____0;
fluree$db$session$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__11438__auto____1;
return fluree$db$session$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_40337 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_40337[(6)] = c__11512__auto__);

return statearr_40337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__40342 = arguments.length;
switch (G__40342) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (p__40343){
var map__40344 = p__40343;
var map__40344__$1 = cljs.core.__destructure_map(map__40344);
var session = map__40344__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40344__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40344__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40344__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40344__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40344__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40344__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40344__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__40345_40348 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__40345_40348.cljs$core$IFn$_invoke$arity$3 ? fexpr__40345_40348.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__40345_40348.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__40346_40349 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__40346_40349.cljs$core$IFn$_invoke$arity$0 ? fexpr__40346_40349.cljs$core$IFn$_invoke$arity$0() : fexpr__40346_40349.call(null));
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5802__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_40402){
var state_val_40403 = (state_40402[(1)]);
if((state_val_40403 === (7))){
var inst_40398 = (state_40402[(2)]);
var state_40402__$1 = state_40402;
var statearr_40404_40435 = state_40402__$1;
(statearr_40404_40435[(2)] = inst_40398);

(statearr_40404_40435[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (1))){
var state_40402__$1 = state_40402;
var statearr_40405_40436 = state_40402__$1;
(statearr_40405_40436[(2)] = null);

(statearr_40405_40436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (4))){
var inst_40353 = (state_40402[(7)]);
var inst_40352 = (state_40402[(2)]);
var inst_40353__$1 = fluree.db.util.async.throw_err(inst_40352);
var inst_40354 = fluree.db.session.from_cache(network,ledger_id);
var inst_40355 = (inst_40353__$1 == null);
var state_40402__$1 = (function (){var statearr_40406 = state_40402;
(statearr_40406[(7)] = inst_40353__$1);

(statearr_40406[(8)] = inst_40354);

return statearr_40406;
})();
if(cljs.core.truth_(inst_40355)){
var statearr_40407_40437 = state_40402__$1;
(statearr_40407_40437[(1)] = (5));

} else {
var statearr_40408_40438 = state_40402__$1;
(statearr_40408_40438[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (15))){
var inst_40390 = (state_40402[(2)]);
var state_40402__$1 = (function (){var statearr_40409 = state_40402;
(statearr_40409[(9)] = inst_40390);

return statearr_40409;
})();
var statearr_40410_40439 = state_40402__$1;
(statearr_40410_40439[(2)] = null);

(statearr_40410_40439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (13))){
var inst_40394 = (state_40402[(2)]);
var state_40402__$1 = state_40402;
var statearr_40412_40440 = state_40402__$1;
(statearr_40412_40440[(2)] = inst_40394);

(statearr_40412_40440[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (6))){
var inst_40354 = (state_40402[(8)]);
var inst_40360 = (inst_40354 == null);
var state_40402__$1 = state_40402;
if(cljs.core.truth_(inst_40360)){
var statearr_40413_40441 = state_40402__$1;
(statearr_40413_40441[(1)] = (8));

} else {
var statearr_40414_40442 = state_40402__$1;
(statearr_40414_40442[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (17))){
var _ = (function (){var statearr_40415 = state_40402;
(statearr_40415[(4)] = cljs.core.rest((state_40402[(4)])));

return statearr_40415;
})();
var state_40402__$1 = state_40402;
var ex40411 = (state_40402__$1[(2)]);
var statearr_40416_40443 = state_40402__$1;
(statearr_40416_40443[(5)] = ex40411);


var statearr_40417_40444 = state_40402__$1;
(statearr_40417_40444[(1)] = (16));

(statearr_40417_40444[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (3))){
var inst_40400 = (state_40402[(2)]);
var state_40402__$1 = state_40402;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40402__$1,inst_40400);
} else {
if((state_val_40403 === (12))){
var state_40402__$1 = state_40402;
var statearr_40418_40445 = state_40402__$1;
(statearr_40418_40445[(2)] = null);

(statearr_40418_40445[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (2))){
var state_40402__$1 = state_40402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40402__$1,(4),update_chan);
} else {
if((state_val_40403 === (11))){
var state_40402__$1 = state_40402;
var statearr_40419_40446 = state_40402__$1;
(statearr_40419_40446[(2)] = null);

(statearr_40419_40446[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (9))){
var state_40402__$1 = state_40402;
var statearr_40420_40447 = state_40402__$1;
(statearr_40420_40447[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (5))){
var inst_40357 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_40358 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40357], 0));
var state_40402__$1 = state_40402;
var statearr_40422_40448 = state_40402__$1;
(statearr_40422_40448[(2)] = inst_40358);

(statearr_40422_40448[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (14))){
var inst_40353 = (state_40402[(7)]);
var inst_40354 = (state_40402[(8)]);
var _ = (function (){var statearr_40423 = state_40402;
(statearr_40423[(4)] = cljs.core.cons((17),(state_40402[(4)])));

return statearr_40423;
})();
var inst_40378 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40353,(0),null);
var inst_40379 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40353,(1),null);
var inst_40380 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_40381 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40353], 0));
var inst_40382 = fluree.db.util.core.trunc(inst_40381,(200));
var inst_40383 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40380,inst_40382], 0));
var inst_40384 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_40354,inst_40378,inst_40379) : fluree.db.session.process_ledger_update.call(null,inst_40354,inst_40378,inst_40379));
var state_40402__$1 = (function (){var statearr_40424 = state_40402;
(statearr_40424[(10)] = inst_40383);

return statearr_40424;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40402__$1,(18),inst_40384);
} else {
if((state_val_40403 === (16))){
var inst_40353 = (state_40402[(7)]);
var inst_40368 = (state_40402[(2)]);
var inst_40369 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40368,"Exception processing ledger updates for message: ",inst_40353], 0));
var state_40402__$1 = state_40402;
var statearr_40425_40449 = state_40402__$1;
(statearr_40425_40449[(2)] = inst_40369);

(statearr_40425_40449[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (10))){
var inst_40396 = (state_40402[(2)]);
var state_40402__$1 = state_40402;
var statearr_40426_40450 = state_40402__$1;
(statearr_40426_40450[(2)] = inst_40396);

(statearr_40426_40450[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (18))){
var inst_40386 = (state_40402[(2)]);
var inst_40387 = fluree.db.util.async.throw_err(inst_40386);
var _ = (function (){var statearr_40427 = state_40402;
(statearr_40427[(4)] = cljs.core.rest((state_40402[(4)])));

return statearr_40427;
})();
var state_40402__$1 = state_40402;
var statearr_40428_40451 = state_40402__$1;
(statearr_40428_40451[(2)] = inst_40387);

(statearr_40428_40451[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (8))){
var inst_40353 = (state_40402[(7)]);
var inst_40362 = cljs.core.first(inst_40353);
var inst_40363 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40362], 0));
var inst_40364 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_40363].join('');
var inst_40365 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40364], 0));
var state_40402__$1 = state_40402;
var statearr_40429_40452 = state_40402__$1;
(statearr_40429_40452[(2)] = inst_40365);

(statearr_40429_40452[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__11438__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__11438__auto____0 = (function (){
var statearr_40430 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40430[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__11438__auto__);

(statearr_40430[(1)] = (1));

return statearr_40430;
});
var fluree$db$session$process_ledger_updates_$_state_machine__11438__auto____1 = (function (state_40402){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_40402);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e40431){var ex__11441__auto__ = e40431;
var statearr_40432_40453 = state_40402;
(statearr_40432_40453[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_40402[(4)]))){
var statearr_40433_40454 = state_40402;
(statearr_40433_40454[(1)] = cljs.core.first((state_40402[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40455 = state_40402;
state_40402 = G__40455;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__11438__auto__ = function(state_40402){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__11438__auto____1.call(this,state_40402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__11438__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__11438__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_40434 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_40434[(6)] = c__11512__auto__);

return statearr_40434;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Creates a connection without first checking if one already exists. Only useful
 *   if reloading and replacing an existing session.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__40456){
var map__40457 = p__40456;
var map__40457__$1 = cljs.core.__destructure_map(map__40457);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40457__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40457__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40457__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40457__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40457__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40457__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40457__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40457__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40457__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cur_db = (cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_db,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0(),db_name,state__$1,close,id,schema_cache,(cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null),network,null,conn]));
var current_db_fn = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.session.current_db,session);
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__40461 = block_result;
var map__40461__$1 = cljs.core.__destructure_map(map__40461);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40461__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40461__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40461__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40461__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40461__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__40462 = tx_result;
var map__40462__$1 = cljs.core.__destructure_map(map__40462);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40462__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40462__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__40458_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__40458_SHARP_.t);
}):(function (p1__40459_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__40459_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__40460_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__40460_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__40460_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__40463 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40463,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40463,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40463,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40463,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));

var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__40467 = arguments.length;
switch (G__40467) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__40468){
var map__40469 = p__40468;
var map__40469__$1 = cljs.core.__destructure_map(map__40469);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40469__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40469__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40469__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40469__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__40470 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40470,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40470,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40470,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__5045__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__5045__auto____$1 = state;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__40474_40594 = network;
var G__40475_40595 = ledger_id;
var G__40476_40596 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__40477_40597 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5804__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__40478 = cljs.core.seq(tids);
var chunk__40479 = null;
var count__40480 = (0);
var i__40481 = (0);
while(true){
if((i__40481 < count__40480)){
var tid = chunk__40479.cljs$core$IIndexed$_nth$arity$2(null,i__40481);
var temp__5804__auto___40599__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___40599__$1)){
var keyed_callbacks_40600 = temp__5804__auto___40599__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_40601 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__40522_40602 = cljs.core.seq(keyed_callbacks_40600);
var chunk__40523_40603 = null;
var count__40524_40604 = (0);
var i__40525_40605 = (0);
while(true){
if((i__40525_40605 < count__40524_40604)){
var vec__40534_40606 = chunk__40523_40603.cljs$core$IIndexed$_nth$arity$2(null,i__40525_40605);
var k_40607 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40534_40606,(0),null);
var f_40608 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40534_40606,(1),null);
try{(f_40608.cljs$core$IFn$_invoke$arity$1 ? f_40608.cljs$core$IFn$_invoke$arity$1(tx_response_40601) : f_40608.call(null,tx_response_40601));
}catch (e40537){var e_40609 = e40537;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_40609,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__40610 = seq__40522_40602;
var G__40611 = chunk__40523_40603;
var G__40612 = count__40524_40604;
var G__40613 = (i__40525_40605 + (1));
seq__40522_40602 = G__40610;
chunk__40523_40603 = G__40611;
count__40524_40604 = G__40612;
i__40525_40605 = G__40613;
continue;
} else {
var temp__5804__auto___40614__$2 = cljs.core.seq(seq__40522_40602);
if(temp__5804__auto___40614__$2){
var seq__40522_40615__$1 = temp__5804__auto___40614__$2;
if(cljs.core.chunked_seq_QMARK_(seq__40522_40615__$1)){
var c__5567__auto___40616 = cljs.core.chunk_first(seq__40522_40615__$1);
var G__40617 = cljs.core.chunk_rest(seq__40522_40615__$1);
var G__40618 = c__5567__auto___40616;
var G__40619 = cljs.core.count(c__5567__auto___40616);
var G__40620 = (0);
seq__40522_40602 = G__40617;
chunk__40523_40603 = G__40618;
count__40524_40604 = G__40619;
i__40525_40605 = G__40620;
continue;
} else {
var vec__40538_40621 = cljs.core.first(seq__40522_40615__$1);
var k_40622 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40538_40621,(0),null);
var f_40623 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40538_40621,(1),null);
try{(f_40623.cljs$core$IFn$_invoke$arity$1 ? f_40623.cljs$core$IFn$_invoke$arity$1(tx_response_40601) : f_40623.call(null,tx_response_40601));
}catch (e40541){var e_40624 = e40541;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_40624,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__40625 = cljs.core.next(seq__40522_40615__$1);
var G__40626 = null;
var G__40627 = (0);
var G__40628 = (0);
seq__40522_40602 = G__40625;
chunk__40523_40603 = G__40626;
count__40524_40604 = G__40627;
i__40525_40605 = G__40628;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__40629 = seq__40478;
var G__40630 = chunk__40479;
var G__40631 = count__40480;
var G__40632 = (i__40481 + (1));
seq__40478 = G__40629;
chunk__40479 = G__40630;
count__40480 = G__40631;
i__40481 = G__40632;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq(seq__40478);
if(temp__5804__auto____$1){
var seq__40478__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__40478__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__40478__$1);
var G__40633 = cljs.core.chunk_rest(seq__40478__$1);
var G__40634 = c__5567__auto__;
var G__40635 = cljs.core.count(c__5567__auto__);
var G__40636 = (0);
seq__40478 = G__40633;
chunk__40479 = G__40634;
count__40480 = G__40635;
i__40481 = G__40636;
continue;
} else {
var tid = cljs.core.first(seq__40478__$1);
var temp__5804__auto___40637__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___40637__$2)){
var keyed_callbacks_40638 = temp__5804__auto___40637__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_40639 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__40542_40640 = cljs.core.seq(keyed_callbacks_40638);
var chunk__40543_40641 = null;
var count__40544_40642 = (0);
var i__40545_40643 = (0);
while(true){
if((i__40545_40643 < count__40544_40642)){
var vec__40554_40644 = chunk__40543_40641.cljs$core$IIndexed$_nth$arity$2(null,i__40545_40643);
var k_40645 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40554_40644,(0),null);
var f_40646 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40554_40644,(1),null);
try{(f_40646.cljs$core$IFn$_invoke$arity$1 ? f_40646.cljs$core$IFn$_invoke$arity$1(tx_response_40639) : f_40646.call(null,tx_response_40639));
}catch (e40557){var e_40647 = e40557;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_40647,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__40648 = seq__40542_40640;
var G__40649 = chunk__40543_40641;
var G__40650 = count__40544_40642;
var G__40651 = (i__40545_40643 + (1));
seq__40542_40640 = G__40648;
chunk__40543_40641 = G__40649;
count__40544_40642 = G__40650;
i__40545_40643 = G__40651;
continue;
} else {
var temp__5804__auto___40652__$3 = cljs.core.seq(seq__40542_40640);
if(temp__5804__auto___40652__$3){
var seq__40542_40653__$1 = temp__5804__auto___40652__$3;
if(cljs.core.chunked_seq_QMARK_(seq__40542_40653__$1)){
var c__5567__auto___40654 = cljs.core.chunk_first(seq__40542_40653__$1);
var G__40655 = cljs.core.chunk_rest(seq__40542_40653__$1);
var G__40656 = c__5567__auto___40654;
var G__40657 = cljs.core.count(c__5567__auto___40654);
var G__40658 = (0);
seq__40542_40640 = G__40655;
chunk__40543_40641 = G__40656;
count__40544_40642 = G__40657;
i__40545_40643 = G__40658;
continue;
} else {
var vec__40558_40659 = cljs.core.first(seq__40542_40653__$1);
var k_40660 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40558_40659,(0),null);
var f_40661 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40558_40659,(1),null);
try{(f_40661.cljs$core$IFn$_invoke$arity$1 ? f_40661.cljs$core$IFn$_invoke$arity$1(tx_response_40639) : f_40661.call(null,tx_response_40639));
}catch (e40561){var e_40662 = e40561;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_40662,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__40663 = cljs.core.next(seq__40542_40653__$1);
var G__40664 = null;
var G__40665 = (0);
var G__40666 = (0);
seq__40542_40640 = G__40663;
chunk__40543_40641 = G__40664;
count__40544_40642 = G__40665;
i__40545_40643 = G__40666;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__40667 = cljs.core.next(seq__40478__$1);
var G__40668 = null;
var G__40669 = (0);
var G__40670 = (0);
seq__40478 = G__40667;
chunk__40479 = G__40668;
count__40480 = G__40669;
i__40481 = G__40670;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__40473_40598 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__40473_40598.cljs$core$IFn$_invoke$arity$4 ? fexpr__40473_40598.cljs$core$IFn$_invoke$arity$4(G__40474_40594,G__40475_40595,G__40476_40596,G__40477_40597) : fexpr__40473_40598.call(null,G__40474_40594,G__40475_40595,G__40476_40596,G__40477_40597));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_40671 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__11512__auto___40672 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_40578){
var state_val_40579 = (state_40578[(1)]);
if((state_val_40579 === (1))){
var state_40578__$1 = state_40578;
var statearr_40580_40673 = state_40578__$1;
(statearr_40580_40673[(2)] = null);

(statearr_40580_40673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40579 === (2))){
var inst_40563 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_40578__$1 = state_40578;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40578__$1,(4),inst_40563);
} else {
if((state_val_40579 === (3))){
var inst_40576 = (state_40578[(2)]);
var state_40578__$1 = state_40578;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40578__$1,inst_40576);
} else {
if((state_val_40579 === (4))){
var inst_40565 = (state_40578[(7)]);
var inst_40565__$1 = (state_40578[(2)]);
var inst_40566 = (inst_40565__$1 == null);
var state_40578__$1 = (function (){var statearr_40581 = state_40578;
(statearr_40581[(7)] = inst_40565__$1);

return statearr_40581;
})();
if(cljs.core.truth_(inst_40566)){
var statearr_40582_40674 = state_40578__$1;
(statearr_40582_40674[(1)] = (5));

} else {
var statearr_40583_40675 = state_40578__$1;
(statearr_40583_40675[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40579 === (5))){
var inst_40568 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_40569 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40568], 0));
var state_40578__$1 = state_40578;
var statearr_40584_40676 = state_40578__$1;
(statearr_40584_40676[(2)] = inst_40569);

(statearr_40584_40676[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40579 === (6))){
var inst_40565 = (state_40578[(7)]);
var inst_40571 = (transact_handler_40671.cljs$core$IFn$_invoke$arity$2 ? transact_handler_40671.cljs$core$IFn$_invoke$arity$2(conn,inst_40565) : transact_handler_40671.call(null,conn,inst_40565));
var state_40578__$1 = (function (){var statearr_40585 = state_40578;
(statearr_40585[(8)] = inst_40571);

return statearr_40585;
})();
var statearr_40586_40677 = state_40578__$1;
(statearr_40586_40677[(2)] = null);

(statearr_40586_40677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40579 === (7))){
var inst_40574 = (state_40578[(2)]);
var state_40578__$1 = state_40578;
var statearr_40587_40678 = state_40578__$1;
(statearr_40587_40678[(2)] = inst_40574);

(statearr_40587_40678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__11438__auto__ = null;
var fluree$db$session$state_machine__11438__auto____0 = (function (){
var statearr_40588 = [null,null,null,null,null,null,null,null,null];
(statearr_40588[(0)] = fluree$db$session$state_machine__11438__auto__);

(statearr_40588[(1)] = (1));

return statearr_40588;
});
var fluree$db$session$state_machine__11438__auto____1 = (function (state_40578){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_40578);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e40589){var ex__11441__auto__ = e40589;
var statearr_40590_40679 = state_40578;
(statearr_40590_40679[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_40578[(4)]))){
var statearr_40591_40680 = state_40578;
(statearr_40591_40680[(1)] = cljs.core.first((state_40578[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40681 = state_40578;
state_40578 = G__40681;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$session$state_machine__11438__auto__ = function(state_40578){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__11438__auto____1.call(this,state_40578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__11438__auto____0;
fluree$db$session$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__11438__auto____1;
return fluree$db$session$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_40592 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_40592[(6)] = c__11512__auto___40672);

return statearr_40592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__40684 = arguments.length;
switch (G__40684) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__40685 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__40682_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__40682_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__40685);
} else {
return G__40685;
}
})();
var seq__40686 = cljs.core.seq(sessions);
var chunk__40687 = null;
var count__40688 = (0);
var i__40689 = (0);
while(true){
if((i__40689 < count__40688)){
var session = chunk__40687.cljs$core$IIndexed$_nth$arity$2(null,i__40689);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__40691 = seq__40686;
var G__40692 = chunk__40687;
var G__40693 = count__40688;
var G__40694 = (i__40689 + (1));
seq__40686 = G__40691;
chunk__40687 = G__40692;
count__40688 = G__40693;
i__40689 = G__40694;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__40686);
if(temp__5804__auto__){
var seq__40686__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40686__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__40686__$1);
var G__40695 = cljs.core.chunk_rest(seq__40686__$1);
var G__40696 = c__5567__auto__;
var G__40697 = cljs.core.count(c__5567__auto__);
var G__40698 = (0);
seq__40686 = G__40695;
chunk__40687 = G__40696;
count__40688 = G__40697;
i__40689 = G__40698;
continue;
} else {
var session = cljs.core.first(seq__40686__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__40699 = cljs.core.next(seq__40686__$1);
var G__40700 = null;
var G__40701 = (0);
var G__40702 = (0);
seq__40686 = G__40699;
chunk__40687 = G__40700;
count__40688 = G__40701;
i__40689 = G__40702;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
