// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_28864){
var state_val_28865 = (state_28864[(1)]);
if((state_val_28865 === (7))){
var inst_28853 = (state_28864[(7)]);
var inst_28855 = fluree.db.storage.core.serde(conn);
var inst_28856 = fluree.db.serde.protocol._deserialize_block(inst_28855,inst_28853);
var state_28864__$1 = state_28864;
var statearr_28866_28885 = state_28864__$1;
(statearr_28866_28885[(2)] = inst_28856);

(statearr_28866_28885[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (1))){
var state_28864__$1 = state_28864;
var statearr_28867_28886 = state_28864__$1;
(statearr_28867_28886[(2)] = null);

(statearr_28867_28886[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (4))){
var inst_28843 = (state_28864[(2)]);
var state_28864__$1 = state_28864;
var statearr_28868_28887 = state_28864__$1;
(statearr_28868_28887[(2)] = inst_28843);

(statearr_28868_28887[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (6))){
var inst_28853 = (state_28864[(7)]);
var inst_28852 = (state_28864[(2)]);
var inst_28853__$1 = fluree.db.util.async.throw_err(inst_28852);
var state_28864__$1 = (function (){var statearr_28869 = state_28864;
(statearr_28869[(7)] = inst_28853__$1);

return statearr_28869;
})();
if(cljs.core.truth_(inst_28853__$1)){
var statearr_28870_28888 = state_28864__$1;
(statearr_28870_28888[(1)] = (7));

} else {
var statearr_28871_28889 = state_28864__$1;
(statearr_28871_28889[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (3))){
var inst_28862 = (state_28864[(2)]);
var state_28864__$1 = state_28864;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28864__$1,inst_28862);
} else {
if((state_val_28865 === (2))){
var _ = (function (){var statearr_28873 = state_28864;
(statearr_28873[(4)] = cljs.core.cons((5),(state_28864[(4)])));

return statearr_28873;
})();
var inst_28849 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_28850 = fluree.db.storage.core.storage_read(conn,inst_28849);
var state_28864__$1 = state_28864;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28864__$1,(6),inst_28850);
} else {
if((state_val_28865 === (9))){
var inst_28859 = (state_28864[(2)]);
var _ = (function (){var statearr_28874 = state_28864;
(statearr_28874[(4)] = cljs.core.rest((state_28864[(4)])));

return statearr_28874;
})();
var state_28864__$1 = state_28864;
var statearr_28875_28890 = state_28864__$1;
(statearr_28875_28890[(2)] = inst_28859);

(statearr_28875_28890[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (5))){
var _ = (function (){var statearr_28876 = state_28864;
(statearr_28876[(4)] = cljs.core.rest((state_28864[(4)])));

return statearr_28876;
})();
var state_28864__$1 = state_28864;
var ex28872 = (state_28864__$1[(2)]);
var statearr_28877_28891 = state_28864__$1;
(statearr_28877_28891[(5)] = ex28872);


if((ex28872 instanceof Error)){
var statearr_28878_28892 = state_28864__$1;
(statearr_28878_28892[(1)] = (4));

(statearr_28878_28892[(5)] = null);

} else {
throw ex28872;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (8))){
var state_28864__$1 = state_28864;
var statearr_28879_28893 = state_28864__$1;
(statearr_28879_28893[(2)] = null);

(statearr_28879_28893[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__11438__auto____0 = (function (){
var statearr_28880 = [null,null,null,null,null,null,null,null];
(statearr_28880[(0)] = fluree$db$storage$core$read_block_$_state_machine__11438__auto__);

(statearr_28880[(1)] = (1));

return statearr_28880;
});
var fluree$db$storage$core$read_block_$_state_machine__11438__auto____1 = (function (state_28864){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_28864);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e28881){var ex__11441__auto__ = e28881;
var statearr_28882_28894 = state_28864;
(statearr_28882_28894[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_28864[(4)]))){
var statearr_28883_28895 = state_28864;
(statearr_28883_28895[(1)] = cljs.core.first((state_28864[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28896 = state_28864;
state_28864 = G__28896;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__11438__auto__ = function(state_28864){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__11438__auto____1.call(this,state_28864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__11438__auto____0;
fluree$db$storage$core$read_block_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__11438__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_28884 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_28884[(6)] = c__11512__auto__);

return statearr_28884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_28919){
var state_val_28920 = (state_28919[(1)]);
if((state_val_28920 === (7))){
var inst_28908 = (state_28919[(7)]);
var inst_28910 = fluree.db.storage.core.serde(conn);
var inst_28911 = fluree.db.serde.protocol._deserialize_block(inst_28910,inst_28908);
var state_28919__$1 = state_28919;
var statearr_28921_28940 = state_28919__$1;
(statearr_28921_28940[(2)] = inst_28911);

(statearr_28921_28940[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28920 === (1))){
var state_28919__$1 = state_28919;
var statearr_28922_28941 = state_28919__$1;
(statearr_28922_28941[(2)] = null);

(statearr_28922_28941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28920 === (4))){
var inst_28897 = (state_28919[(2)]);
var state_28919__$1 = state_28919;
var statearr_28923_28942 = state_28919__$1;
(statearr_28923_28942[(2)] = inst_28897);

(statearr_28923_28942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28920 === (6))){
var inst_28908 = (state_28919[(7)]);
var inst_28907 = (state_28919[(2)]);
var inst_28908__$1 = fluree.db.util.async.throw_err(inst_28907);
var state_28919__$1 = (function (){var statearr_28924 = state_28919;
(statearr_28924[(7)] = inst_28908__$1);

return statearr_28924;
})();
if(cljs.core.truth_(inst_28908__$1)){
var statearr_28925_28943 = state_28919__$1;
(statearr_28925_28943[(1)] = (7));

} else {
var statearr_28926_28944 = state_28919__$1;
(statearr_28926_28944[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28920 === (3))){
var inst_28917 = (state_28919[(2)]);
var state_28919__$1 = state_28919;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28919__$1,inst_28917);
} else {
if((state_val_28920 === (2))){
var _ = (function (){var statearr_28928 = state_28919;
(statearr_28928[(4)] = cljs.core.cons((5),(state_28919[(4)])));

return statearr_28928;
})();
var inst_28903 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_28904 = [inst_28903,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_28905 = fluree.db.storage.core.storage_read(conn,inst_28904);
var state_28919__$1 = state_28919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28919__$1,(6),inst_28905);
} else {
if((state_val_28920 === (9))){
var inst_28914 = (state_28919[(2)]);
var _ = (function (){var statearr_28929 = state_28919;
(statearr_28929[(4)] = cljs.core.rest((state_28919[(4)])));

return statearr_28929;
})();
var state_28919__$1 = state_28919;
var statearr_28930_28945 = state_28919__$1;
(statearr_28930_28945[(2)] = inst_28914);

(statearr_28930_28945[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28920 === (5))){
var _ = (function (){var statearr_28931 = state_28919;
(statearr_28931[(4)] = cljs.core.rest((state_28919[(4)])));

return statearr_28931;
})();
var state_28919__$1 = state_28919;
var ex28927 = (state_28919__$1[(2)]);
var statearr_28932_28946 = state_28919__$1;
(statearr_28932_28946[(5)] = ex28927);


if((ex28927 instanceof Error)){
var statearr_28933_28947 = state_28919__$1;
(statearr_28933_28947[(1)] = (4));

(statearr_28933_28947[(5)] = null);

} else {
throw ex28927;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28920 === (8))){
var state_28919__$1 = state_28919;
var statearr_28934_28948 = state_28919__$1;
(statearr_28934_28948[(2)] = null);

(statearr_28934_28948[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__11438__auto____0 = (function (){
var statearr_28935 = [null,null,null,null,null,null,null,null];
(statearr_28935[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__11438__auto__);

(statearr_28935[(1)] = (1));

return statearr_28935;
});
var fluree$db$storage$core$read_block_version_$_state_machine__11438__auto____1 = (function (state_28919){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_28919);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e28936){var ex__11441__auto__ = e28936;
var statearr_28937_28949 = state_28919;
(statearr_28937_28949[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_28919[(4)]))){
var statearr_28938_28950 = state_28919;
(statearr_28938_28950[(1)] = cljs.core.first((state_28919[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28951 = state_28919;
state_28919 = G__28951;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__11438__auto__ = function(state_28919){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__11438__auto____1.call(this,state_28919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__11438__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__11438__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_28939 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_28939[(6)] = c__11512__auto__);

return statearr_28939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_28975){
var state_val_28976 = (state_28975[(1)]);
if((state_val_28976 === (1))){
var state_28975__$1 = state_28975;
var statearr_28977_28991 = state_28975__$1;
(statearr_28977_28991[(2)] = null);

(statearr_28977_28991[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28976 === (2))){
var _ = (function (){var statearr_28978 = state_28975;
(statearr_28978[(4)] = cljs.core.cons((5),(state_28975[(4)])));

return statearr_28978;
})();
var inst_28958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28959 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_28960 = (new cljs.core.PersistentVector(null,3,(5),inst_28958,inst_28959,null));
var inst_28961 = cljs.core.select_keys(block_data,inst_28960);
var inst_28962 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28961);
var inst_28963 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_28962);
var inst_28964 = [inst_28963,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_28965 = fluree.db.storage.core.serde(conn);
var inst_28966 = fluree.db.serde.protocol._serialize_block(inst_28965,inst_28961);
var inst_28967 = fluree.db.storage.core.storage_write(conn,inst_28964,inst_28966);
var state_28975__$1 = state_28975;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28975__$1,(6),inst_28967);
} else {
if((state_val_28976 === (3))){
var inst_28973 = (state_28975[(2)]);
var state_28975__$1 = state_28975;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28975__$1,inst_28973);
} else {
if((state_val_28976 === (4))){
var inst_28952 = (state_28975[(2)]);
var state_28975__$1 = state_28975;
var statearr_28980_28992 = state_28975__$1;
(statearr_28980_28992[(2)] = inst_28952);

(statearr_28980_28992[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28976 === (5))){
var _ = (function (){var statearr_28981 = state_28975;
(statearr_28981[(4)] = cljs.core.rest((state_28975[(4)])));

return statearr_28981;
})();
var state_28975__$1 = state_28975;
var ex28979 = (state_28975__$1[(2)]);
var statearr_28982_28993 = state_28975__$1;
(statearr_28982_28993[(5)] = ex28979);


if((ex28979 instanceof Error)){
var statearr_28983_28994 = state_28975__$1;
(statearr_28983_28994[(1)] = (4));

(statearr_28983_28994[(5)] = null);

} else {
throw ex28979;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28976 === (6))){
var inst_28969 = (state_28975[(2)]);
var inst_28970 = fluree.db.util.async.throw_err(inst_28969);
var _ = (function (){var statearr_28984 = state_28975;
(statearr_28984[(4)] = cljs.core.rest((state_28975[(4)])));

return statearr_28984;
})();
var state_28975__$1 = state_28975;
var statearr_28985_28995 = state_28975__$1;
(statearr_28985_28995[(2)] = inst_28970);

(statearr_28985_28995[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__11438__auto____0 = (function (){
var statearr_28986 = [null,null,null,null,null,null,null];
(statearr_28986[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__11438__auto__);

(statearr_28986[(1)] = (1));

return statearr_28986;
});
var fluree$db$storage$core$write_block_version_$_state_machine__11438__auto____1 = (function (state_28975){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_28975);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e28987){var ex__11441__auto__ = e28987;
var statearr_28988_28996 = state_28975;
(statearr_28988_28996[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_28975[(4)]))){
var statearr_28989_28997 = state_28975;
(statearr_28989_28997[(1)] = cljs.core.first((state_28975[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28998 = state_28975;
state_28975 = G__28998;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__11438__auto__ = function(state_28975){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__11438__auto____1.call(this,state_28975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__11438__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__11438__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_28990 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_28990[(6)] = c__11512__auto__);

return statearr_28990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_29021){
var state_val_29022 = (state_29021[(1)]);
if((state_val_29022 === (1))){
var state_29021__$1 = state_29021;
var statearr_29023_29037 = state_29021__$1;
(statearr_29023_29037[(2)] = null);

(statearr_29023_29037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29022 === (2))){
var _ = (function (){var statearr_29024 = state_29021;
(statearr_29024[(4)] = cljs.core.cons((5),(state_29021[(4)])));

return statearr_29024;
})();
var inst_29005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29006 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_29007 = (new cljs.core.PersistentVector(null,3,(5),inst_29005,inst_29006,null));
var inst_29008 = cljs.core.select_keys(block_data,inst_29007);
var inst_29009 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_29008);
var inst_29010 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_29009);
var inst_29011 = fluree.db.storage.core.serde(conn);
var inst_29012 = fluree.db.serde.protocol._serialize_block(inst_29011,inst_29008);
var inst_29013 = fluree.db.storage.core.storage_write(conn,inst_29010,inst_29012);
var state_29021__$1 = state_29021;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29021__$1,(6),inst_29013);
} else {
if((state_val_29022 === (3))){
var inst_29019 = (state_29021[(2)]);
var state_29021__$1 = state_29021;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29021__$1,inst_29019);
} else {
if((state_val_29022 === (4))){
var inst_28999 = (state_29021[(2)]);
var state_29021__$1 = state_29021;
var statearr_29026_29038 = state_29021__$1;
(statearr_29026_29038[(2)] = inst_28999);

(statearr_29026_29038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29022 === (5))){
var _ = (function (){var statearr_29027 = state_29021;
(statearr_29027[(4)] = cljs.core.rest((state_29021[(4)])));

return statearr_29027;
})();
var state_29021__$1 = state_29021;
var ex29025 = (state_29021__$1[(2)]);
var statearr_29028_29039 = state_29021__$1;
(statearr_29028_29039[(5)] = ex29025);


if((ex29025 instanceof Error)){
var statearr_29029_29040 = state_29021__$1;
(statearr_29029_29040[(1)] = (4));

(statearr_29029_29040[(5)] = null);

} else {
throw ex29025;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29022 === (6))){
var inst_29015 = (state_29021[(2)]);
var inst_29016 = fluree.db.util.async.throw_err(inst_29015);
var _ = (function (){var statearr_29030 = state_29021;
(statearr_29030[(4)] = cljs.core.rest((state_29021[(4)])));

return statearr_29030;
})();
var state_29021__$1 = state_29021;
var statearr_29031_29041 = state_29021__$1;
(statearr_29031_29041[(2)] = inst_29016);

(statearr_29031_29041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__11438__auto____0 = (function (){
var statearr_29032 = [null,null,null,null,null,null,null];
(statearr_29032[(0)] = fluree$db$storage$core$write_block_$_state_machine__11438__auto__);

(statearr_29032[(1)] = (1));

return statearr_29032;
});
var fluree$db$storage$core$write_block_$_state_machine__11438__auto____1 = (function (state_29021){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_29021);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e29033){var ex__11441__auto__ = e29033;
var statearr_29034_29042 = state_29021;
(statearr_29034_29042[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_29021[(4)]))){
var statearr_29035_29043 = state_29021;
(statearr_29035_29043[(1)] = cljs.core.first((state_29021[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29044 = state_29021;
state_29021 = G__29044;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__11438__auto__ = function(state_29021){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__11438__auto____1.call(this,state_29021);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__11438__auto____0;
fluree$db$storage$core$write_block_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__11438__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_29036 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_29036[(6)] = c__11512__auto__);

return statearr_29036;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_29064){
var state_val_29065 = (state_29064[(1)]);
if((state_val_29065 === (1))){
var state_29064__$1 = state_29064;
var statearr_29066_29080 = state_29064__$1;
(statearr_29066_29080[(2)] = null);

(statearr_29066_29080[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29065 === (2))){
var _ = (function (){var statearr_29067 = state_29064;
(statearr_29067[(4)] = cljs.core.cons((5),(state_29064[(4)])));

return statearr_29067;
})();
var inst_29051 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_29052 = [history,next_his_key];
var inst_29053 = cljs.core.PersistentHashMap.fromArrays(inst_29051,inst_29052);
var inst_29054 = fluree.db.storage.core.serde(conn);
var inst_29055 = fluree.db.serde.protocol._serialize_leaf(inst_29054,inst_29053);
var inst_29056 = fluree.db.storage.core.storage_write(conn,his_key,inst_29055);
var state_29064__$1 = state_29064;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29064__$1,(6),inst_29056);
} else {
if((state_val_29065 === (3))){
var inst_29062 = (state_29064[(2)]);
var state_29064__$1 = state_29064;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29064__$1,inst_29062);
} else {
if((state_val_29065 === (4))){
var inst_29045 = (state_29064[(2)]);
var state_29064__$1 = state_29064;
var statearr_29069_29081 = state_29064__$1;
(statearr_29069_29081[(2)] = inst_29045);

(statearr_29069_29081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29065 === (5))){
var _ = (function (){var statearr_29070 = state_29064;
(statearr_29070[(4)] = cljs.core.rest((state_29064[(4)])));

return statearr_29070;
})();
var state_29064__$1 = state_29064;
var ex29068 = (state_29064__$1[(2)]);
var statearr_29071_29082 = state_29064__$1;
(statearr_29071_29082[(5)] = ex29068);


if((ex29068 instanceof Error)){
var statearr_29072_29083 = state_29064__$1;
(statearr_29072_29083[(1)] = (4));

(statearr_29072_29083[(5)] = null);

} else {
throw ex29068;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29065 === (6))){
var inst_29058 = (state_29064[(2)]);
var inst_29059 = fluree.db.util.async.throw_err(inst_29058);
var _ = (function (){var statearr_29073 = state_29064;
(statearr_29073[(4)] = cljs.core.rest((state_29064[(4)])));

return statearr_29073;
})();
var state_29064__$1 = state_29064;
var statearr_29074_29084 = state_29064__$1;
(statearr_29074_29084[(2)] = inst_29059);

(statearr_29074_29084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__11438__auto____0 = (function (){
var statearr_29075 = [null,null,null,null,null,null,null];
(statearr_29075[(0)] = fluree$db$storage$core$write_history_$_state_machine__11438__auto__);

(statearr_29075[(1)] = (1));

return statearr_29075;
});
var fluree$db$storage$core$write_history_$_state_machine__11438__auto____1 = (function (state_29064){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_29064);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e29076){var ex__11441__auto__ = e29076;
var statearr_29077_29085 = state_29064;
(statearr_29077_29085[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_29064[(4)]))){
var statearr_29078_29086 = state_29064;
(statearr_29078_29086[(1)] = cljs.core.first((state_29064[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29087 = state_29064;
state_29064 = G__29087;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__11438__auto__ = function(state_29064){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__11438__auto____1.call(this,state_29064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__11438__auto____0;
fluree$db$storage$core$write_history_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__11438__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_29079 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_29079[(6)] = c__11512__auto__);

return statearr_29079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_29113){
var state_val_29114 = (state_29113[(1)]);
if((state_val_29114 === (1))){
var state_29113__$1 = state_29113;
var statearr_29115_29132 = state_29113__$1;
(statearr_29115_29132[(2)] = null);

(statearr_29115_29132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29114 === (2))){
var inst_29094 = (state_29113[(7)]);
var _ = (function (){var statearr_29116 = state_29113;
(statearr_29116[(4)] = cljs.core.cons((5),(state_29113[(4)])));

return statearr_29116;
})();
var inst_29094__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_29095 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29094__$1),"-his"].join('');
var inst_29096 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_29097 = [flakes,inst_29095];
var inst_29098 = cljs.core.PersistentHashMap.fromArrays(inst_29096,inst_29097);
var inst_29099 = fluree.db.storage.core.serde(conn);
var inst_29100 = fluree.db.serde.protocol._serialize_leaf(inst_29099,inst_29098);
var inst_29101 = fluree.db.storage.core.write_history(conn,history,inst_29095,null);
var inst_29102 = fluree.db.storage.core.storage_write(conn,inst_29094__$1,inst_29100);
var state_29113__$1 = (function (){var statearr_29117 = state_29113;
(statearr_29117[(7)] = inst_29094__$1);

(statearr_29117[(8)] = inst_29102);

return statearr_29117;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29113__$1,(6),inst_29101);
} else {
if((state_val_29114 === (3))){
var inst_29111 = (state_29113[(2)]);
var state_29113__$1 = state_29113;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29113__$1,inst_29111);
} else {
if((state_val_29114 === (4))){
var inst_29088 = (state_29113[(2)]);
var state_29113__$1 = state_29113;
var statearr_29119_29133 = state_29113__$1;
(statearr_29119_29133[(2)] = inst_29088);

(statearr_29119_29133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29114 === (5))){
var _ = (function (){var statearr_29120 = state_29113;
(statearr_29120[(4)] = cljs.core.rest((state_29113[(4)])));

return statearr_29120;
})();
var state_29113__$1 = state_29113;
var ex29118 = (state_29113__$1[(2)]);
var statearr_29121_29134 = state_29113__$1;
(statearr_29121_29134[(5)] = ex29118);


if((ex29118 instanceof Error)){
var statearr_29122_29135 = state_29113__$1;
(statearr_29122_29135[(1)] = (4));

(statearr_29122_29135[(5)] = null);

} else {
throw ex29118;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29114 === (6))){
var inst_29102 = (state_29113[(8)]);
var inst_29104 = (state_29113[(2)]);
var inst_29105 = fluree.db.util.async.throw_err(inst_29104);
var state_29113__$1 = (function (){var statearr_29123 = state_29113;
(statearr_29123[(9)] = inst_29105);

return statearr_29123;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29113__$1,(7),inst_29102);
} else {
if((state_val_29114 === (7))){
var inst_29094 = (state_29113[(7)]);
var inst_29107 = (state_29113[(2)]);
var inst_29108 = fluree.db.util.async.throw_err(inst_29107);
var _ = (function (){var statearr_29124 = state_29113;
(statearr_29124[(4)] = cljs.core.rest((state_29113[(4)])));

return statearr_29124;
})();
var state_29113__$1 = (function (){var statearr_29125 = state_29113;
(statearr_29125[(10)] = inst_29108);

return statearr_29125;
})();
var statearr_29126_29136 = state_29113__$1;
(statearr_29126_29136[(2)] = inst_29094);

(statearr_29126_29136[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__11438__auto____0 = (function (){
var statearr_29127 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29127[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__11438__auto__);

(statearr_29127[(1)] = (1));

return statearr_29127;
});
var fluree$db$storage$core$write_leaf_$_state_machine__11438__auto____1 = (function (state_29113){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_29113);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e29128){var ex__11441__auto__ = e29128;
var statearr_29129_29137 = state_29113;
(statearr_29129_29137[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_29113[(4)]))){
var statearr_29130_29138 = state_29113;
(statearr_29130_29138[(1)] = cljs.core.first((state_29113[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29139 = state_29113;
state_29113 = G__29139;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__11438__auto__ = function(state_29113){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__11438__auto____1.call(this,state_29113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__11438__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__11438__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_29131 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_29131[(6)] = c__11512__auto__);

return statearr_29131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_29156){
var state_val_29157 = (state_29156[(1)]);
if((state_val_29157 === (1))){
var state_29156__$1 = state_29156;
var statearr_29158_29173 = state_29156__$1;
(statearr_29158_29173[(2)] = null);

(statearr_29158_29173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29157 === (2))){
var _ = (function (){var statearr_29159 = state_29156;
(statearr_29159[(4)] = cljs.core.cons((5),(state_29156[(4)])));

return statearr_29159;
})();
var inst_29146 = fluree.db.storage.core.serde(conn);
var inst_29147 = fluree.db.serde.protocol._serialize_branch(inst_29146,data);
var inst_29148 = fluree.db.storage.core.storage_write(conn,key,inst_29147);
var state_29156__$1 = state_29156;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29156__$1,(6),inst_29148);
} else {
if((state_val_29157 === (3))){
var inst_29154 = (state_29156[(2)]);
var state_29156__$1 = state_29156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29156__$1,inst_29154);
} else {
if((state_val_29157 === (4))){
var inst_29140 = (state_29156[(2)]);
var state_29156__$1 = state_29156;
var statearr_29161_29174 = state_29156__$1;
(statearr_29161_29174[(2)] = inst_29140);

(statearr_29161_29174[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29157 === (5))){
var _ = (function (){var statearr_29162 = state_29156;
(statearr_29162[(4)] = cljs.core.rest((state_29156[(4)])));

return statearr_29162;
})();
var state_29156__$1 = state_29156;
var ex29160 = (state_29156__$1[(2)]);
var statearr_29163_29175 = state_29156__$1;
(statearr_29163_29175[(5)] = ex29160);


if((ex29160 instanceof Error)){
var statearr_29164_29176 = state_29156__$1;
(statearr_29164_29176[(1)] = (4));

(statearr_29164_29176[(5)] = null);

} else {
throw ex29160;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29157 === (6))){
var inst_29150 = (state_29156[(2)]);
var inst_29151 = fluree.db.util.async.throw_err(inst_29150);
var _ = (function (){var statearr_29165 = state_29156;
(statearr_29165[(4)] = cljs.core.rest((state_29156[(4)])));

return statearr_29165;
})();
var state_29156__$1 = (function (){var statearr_29166 = state_29156;
(statearr_29166[(7)] = inst_29151);

return statearr_29166;
})();
var statearr_29167_29177 = state_29156__$1;
(statearr_29167_29177[(2)] = key);

(statearr_29167_29177[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__11438__auto____0 = (function (){
var statearr_29168 = [null,null,null,null,null,null,null,null];
(statearr_29168[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__11438__auto__);

(statearr_29168[(1)] = (1));

return statearr_29168;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__11438__auto____1 = (function (state_29156){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_29156);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e29169){var ex__11441__auto__ = e29169;
var statearr_29170_29178 = state_29156;
(statearr_29170_29178[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_29156[(4)]))){
var statearr_29171_29179 = state_29156;
(statearr_29171_29179[(1)] = cljs.core.first((state_29156[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29180 = state_29156;
state_29156 = G__29180;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__11438__auto__ = function(state_29156){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__11438__auto____1.call(this,state_29156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__11438__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__11438__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_29172 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_29172[(6)] = c__11512__auto__);

return statearr_29172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__29181_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__29181_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__29182){
var map__29183 = p__29182;
var map__29183__$1 = cljs.core.__destructure_map(map__29183);
var progress = map__29183__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29183__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_29211){
var state_val_29212 = (state_29211[(1)]);
if((state_val_29212 === (1))){
var state_29211__$1 = state_29211;
var statearr_29213_29229 = state_29211__$1;
(statearr_29213_29229[(2)] = null);

(statearr_29213_29229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29212 === (2))){
var inst_29197 = (state_29211[(7)]);
var _ = (function (){var statearr_29214 = state_29211;
(statearr_29214[(4)] = cljs.core.cons((5),(state_29211[(4)])));

return statearr_29214;
})();
var inst_29191 = db;
var inst_29192 = cljs.core.__destructure_map(inst_29191);
var inst_29193 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29192,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_29194 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29192,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_29195 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29192,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_29196 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29192,new cljs.core.Keyword(null,"block","block",664686210));
var inst_29197__$1 = fluree.db.storage.core.ledger_garbage_key(inst_29194,inst_29195,inst_29196);
var inst_29198 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_29199 = [inst_29195,inst_29196,garbage];
var inst_29200 = cljs.core.PersistentHashMap.fromArrays(inst_29198,inst_29199);
var inst_29201 = fluree.db.storage.core.serde(inst_29193);
var inst_29202 = fluree.db.serde.protocol._serialize_garbage(inst_29201,inst_29200);
var inst_29203 = fluree.db.storage.core.storage_write(inst_29193,inst_29197__$1,inst_29202);
var state_29211__$1 = (function (){var statearr_29215 = state_29211;
(statearr_29215[(7)] = inst_29197__$1);

return statearr_29215;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29211__$1,(6),inst_29203);
} else {
if((state_val_29212 === (3))){
var inst_29209 = (state_29211[(2)]);
var state_29211__$1 = state_29211;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29211__$1,inst_29209);
} else {
if((state_val_29212 === (4))){
var inst_29184 = (state_29211[(2)]);
var state_29211__$1 = state_29211;
var statearr_29217_29230 = state_29211__$1;
(statearr_29217_29230[(2)] = inst_29184);

(statearr_29217_29230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29212 === (5))){
var _ = (function (){var statearr_29218 = state_29211;
(statearr_29218[(4)] = cljs.core.rest((state_29211[(4)])));

return statearr_29218;
})();
var state_29211__$1 = state_29211;
var ex29216 = (state_29211__$1[(2)]);
var statearr_29219_29231 = state_29211__$1;
(statearr_29219_29231[(5)] = ex29216);


if((ex29216 instanceof Error)){
var statearr_29220_29232 = state_29211__$1;
(statearr_29220_29232[(1)] = (4));

(statearr_29220_29232[(5)] = null);

} else {
throw ex29216;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29212 === (6))){
var inst_29197 = (state_29211[(7)]);
var inst_29205 = (state_29211[(2)]);
var inst_29206 = fluree.db.util.async.throw_err(inst_29205);
var _ = (function (){var statearr_29221 = state_29211;
(statearr_29221[(4)] = cljs.core.rest((state_29211[(4)])));

return statearr_29221;
})();
var state_29211__$1 = (function (){var statearr_29222 = state_29211;
(statearr_29222[(8)] = inst_29206);

return statearr_29222;
})();
var statearr_29223_29233 = state_29211__$1;
(statearr_29223_29233[(2)] = inst_29197);

(statearr_29223_29233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__11438__auto____0 = (function (){
var statearr_29224 = [null,null,null,null,null,null,null,null,null];
(statearr_29224[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__11438__auto__);

(statearr_29224[(1)] = (1));

return statearr_29224;
});
var fluree$db$storage$core$write_garbage_$_state_machine__11438__auto____1 = (function (state_29211){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_29211);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e29225){var ex__11441__auto__ = e29225;
var statearr_29226_29234 = state_29211;
(statearr_29226_29234[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_29211[(4)]))){
var statearr_29227_29235 = state_29211;
(statearr_29227_29235[(1)] = cljs.core.first((state_29211[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29236 = state_29211;
state_29211 = G__29236;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__11438__auto__ = function(state_29211){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__11438__auto____1.call(this,state_29211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__11438__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__11438__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_29228 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_29228[(6)] = c__11512__auto__);

return statearr_29228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__29238 = arguments.length;
switch (G__29238) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_29294){
var state_val_29295 = (state_29294[(1)]);
if((state_val_29295 === (7))){
var state_29294__$1 = state_29294;
var statearr_29296_29322 = state_29294__$1;
(statearr_29296_29322[(2)] = (0));

(statearr_29296_29322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29295 === (1))){
var state_29294__$1 = state_29294;
var statearr_29297_29323 = state_29294__$1;
(statearr_29297_29323[(2)] = null);

(statearr_29297_29323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29295 === (4))){
var inst_29239 = (state_29294[(2)]);
var state_29294__$1 = state_29294;
var statearr_29298_29324 = state_29294__$1;
(statearr_29298_29324[(2)] = inst_29239);

(statearr_29298_29324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29295 === (6))){
var inst_29264 = (state_29294[(7)]);
var state_29294__$1 = state_29294;
var statearr_29299_29325 = state_29294__$1;
(statearr_29299_29325[(2)] = inst_29264);

(statearr_29299_29325[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29295 === (3))){
var inst_29292 = (state_29294[(2)]);
var state_29294__$1 = state_29294;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29294__$1,inst_29292);
} else {
if((state_val_29295 === (12))){
var inst_29261 = (state_29294[(8)]);
var inst_29288 = (state_29294[(2)]);
var inst_29289 = fluree.db.util.async.throw_err(inst_29288);
var _ = (function (){var statearr_29300 = state_29294;
(statearr_29300[(4)] = cljs.core.rest((state_29294[(4)])));

return statearr_29300;
})();
var state_29294__$1 = (function (){var statearr_29301 = state_29294;
(statearr_29301[(9)] = inst_29289);

return statearr_29301;
})();
var statearr_29302_29326 = state_29294__$1;
(statearr_29302_29326[(2)] = inst_29261);

(statearr_29302_29326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29295 === (2))){
var inst_29254 = (state_29294[(10)]);
var inst_29264 = (state_29294[(7)]);
var inst_29256 = (state_29294[(11)]);
var inst_29252 = (state_29294[(12)]);
var _ = (function (){var statearr_29303 = state_29294;
(statearr_29303[(4)] = cljs.core.cons((5),(state_29294[(4)])));

return statearr_29303;
})();
var inst_29246 = db;
var inst_29247 = cljs.core.__destructure_map(inst_29246);
var inst_29248 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29247,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_29249 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29247,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_29250 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29247,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_29251 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29247,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_29252__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29247,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_29253 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29247,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_29254__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29247,new cljs.core.Keyword(null,"block","block",664686210));
var inst_29255 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29247,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_29256__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29247,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_29257 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29247,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_29258 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29247,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_29259 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29247,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_29260 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29247,new cljs.core.Keyword(null,"post","post",269697687));
var inst_29261 = fluree.db.storage.core.ledger_root_key(inst_29248,inst_29256__$1,inst_29254__$1);
var inst_29262 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_29263 = fluree.db.storage.core.child_data(inst_29255);
var inst_29264__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_29252__$1);
var state_29294__$1 = (function (){var statearr_29304 = state_29294;
(statearr_29304[(13)] = inst_29262);

(statearr_29304[(14)] = inst_29260);

(statearr_29304[(15)] = inst_29250);

(statearr_29304[(10)] = inst_29254__$1);

(statearr_29304[(16)] = inst_29263);

(statearr_29304[(17)] = inst_29258);

(statearr_29304[(18)] = inst_29257);

(statearr_29304[(7)] = inst_29264__$1);

(statearr_29304[(19)] = inst_29249);

(statearr_29304[(11)] = inst_29256__$1);

(statearr_29304[(20)] = inst_29251);

(statearr_29304[(12)] = inst_29252__$1);

(statearr_29304[(21)] = inst_29253);

(statearr_29304[(22)] = inst_29259);

(statearr_29304[(8)] = inst_29261);

return statearr_29304;
})();
if(cljs.core.truth_(inst_29264__$1)){
var statearr_29305_29327 = state_29294__$1;
(statearr_29305_29327[(1)] = (6));

} else {
var statearr_29306_29328 = state_29294__$1;
(statearr_29306_29328[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29295 === (11))){
var inst_29262 = (state_29294[(13)]);
var inst_29260 = (state_29294[(14)]);
var inst_29250 = (state_29294[(15)]);
var inst_29254 = (state_29294[(10)]);
var inst_29263 = (state_29294[(16)]);
var inst_29258 = (state_29294[(17)]);
var inst_29249 = (state_29294[(19)]);
var inst_29256 = (state_29294[(11)]);
var inst_29251 = (state_29294[(20)]);
var inst_29252 = (state_29294[(12)]);
var inst_29253 = (state_29294[(21)]);
var inst_29259 = (state_29294[(22)]);
var inst_29268 = (state_29294[(23)]);
var inst_29261 = (state_29294[(8)]);
var inst_29273 = (state_29294[(2)]);
var inst_29274 = fluree.db.storage.core.child_data(inst_29258);
var inst_29275 = fluree.db.storage.core.child_data(inst_29260);
var inst_29276 = fluree.db.util.core.current_time_millis();
var inst_29277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29278 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_29279 = (new cljs.core.PersistentVector(null,2,(5),inst_29277,inst_29278,null));
var inst_29280 = cljs.core.select_keys(inst_29252,inst_29279);
var inst_29281 = fluree.db.storage.core.child_data(inst_29251);
var inst_29282 = [inst_29254,inst_29263,inst_29256,inst_29268,inst_29273,inst_29274,inst_29275,inst_29249,inst_29276,inst_29250,inst_29259,inst_29280,inst_29281];
var inst_29283 = cljs.core.PersistentHashMap.fromArrays(inst_29262,inst_29282);
var inst_29284 = fluree.db.storage.core.serde(inst_29253);
var inst_29285 = fluree.db.serde.protocol._serialize_db_root(inst_29284,inst_29283);
var inst_29286 = fluree.db.storage.core.storage_write(inst_29253,inst_29261,inst_29285);
var state_29294__$1 = state_29294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29294__$1,(12),inst_29286);
} else {
if((state_val_29295 === (9))){
var inst_29269 = (state_29294[(24)]);
var state_29294__$1 = state_29294;
var statearr_29308_29329 = state_29294__$1;
(statearr_29308_29329[(2)] = inst_29269);

(statearr_29308_29329[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29295 === (5))){
var _ = (function (){var statearr_29309 = state_29294;
(statearr_29309[(4)] = cljs.core.rest((state_29294[(4)])));

return statearr_29309;
})();
var state_29294__$1 = state_29294;
var ex29307 = (state_29294__$1[(2)]);
var statearr_29310_29330 = state_29294__$1;
(statearr_29310_29330[(5)] = ex29307);


if((ex29307 instanceof Error)){
var statearr_29311_29331 = state_29294__$1;
(statearr_29311_29331[(1)] = (4));

(statearr_29311_29331[(5)] = null);

} else {
throw ex29307;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29295 === (10))){
var inst_29257 = (state_29294[(18)]);
var state_29294__$1 = state_29294;
var statearr_29312_29332 = state_29294__$1;
(statearr_29312_29332[(2)] = inst_29257);

(statearr_29312_29332[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29295 === (8))){
var inst_29269 = (state_29294[(24)]);
var inst_29268 = (state_29294[(2)]);
var inst_29269__$1 = custom_ecount;
var state_29294__$1 = (function (){var statearr_29313 = state_29294;
(statearr_29313[(24)] = inst_29269__$1);

(statearr_29313[(23)] = inst_29268);

return statearr_29313;
})();
if(cljs.core.truth_(inst_29269__$1)){
var statearr_29314_29333 = state_29294__$1;
(statearr_29314_29333[(1)] = (9));

} else {
var statearr_29315_29334 = state_29294__$1;
(statearr_29315_29334[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__11438__auto__ = null;
var fluree$db$storage$core$state_machine__11438__auto____0 = (function (){
var statearr_29316 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29316[(0)] = fluree$db$storage$core$state_machine__11438__auto__);

(statearr_29316[(1)] = (1));

return statearr_29316;
});
var fluree$db$storage$core$state_machine__11438__auto____1 = (function (state_29294){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_29294);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e29317){var ex__11441__auto__ = e29317;
var statearr_29318_29335 = state_29294;
(statearr_29318_29335[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_29294[(4)]))){
var statearr_29319_29336 = state_29294;
(statearr_29319_29336[(1)] = cljs.core.first((state_29294[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29337 = state_29294;
state_29294 = G__29337;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__11438__auto__ = function(state_29294){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__11438__auto____1.call(this,state_29294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__11438__auto____0;
fluree$db$storage$core$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__11438__auto____1;
return fluree$db$storage$core$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_29320 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_29320[(6)] = c__11512__auto__);

return statearr_29320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11512__auto___29396 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_29370){
var state_val_29371 = (state_29370[(1)]);
if((state_val_29371 === (7))){
var inst_29350 = (state_29370[(7)]);
var state_29370__$1 = state_29370;
var statearr_29372_29397 = state_29370__$1;
(statearr_29372_29397[(2)] = inst_29350);

(statearr_29372_29397[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29371 === (1))){
var state_29370__$1 = state_29370;
var statearr_29373_29398 = state_29370__$1;
(statearr_29373_29398[(2)] = null);

(statearr_29373_29398[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29371 === (4))){
var inst_29338 = (state_29370[(2)]);
var inst_29339 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_29340 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_29338);
var inst_29341 = cljs.core.async.close_BANG_(return_ch);
var state_29370__$1 = (function (){var statearr_29374 = state_29370;
(statearr_29374[(8)] = inst_29340);

(statearr_29374[(9)] = inst_29339);

return statearr_29374;
})();
var statearr_29375_29399 = state_29370__$1;
(statearr_29375_29399[(2)] = inst_29341);

(statearr_29375_29399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29371 === (6))){
var inst_29350 = (state_29370[(7)]);
var inst_29349 = (state_29370[(10)]);
var inst_29349__$1 = (state_29370[(2)]);
var inst_29350__$1 = (inst_29349__$1 == null);
var state_29370__$1 = (function (){var statearr_29376 = state_29370;
(statearr_29376[(7)] = inst_29350__$1);

(statearr_29376[(10)] = inst_29349__$1);

return statearr_29376;
})();
if(cljs.core.truth_(inst_29350__$1)){
var statearr_29377_29400 = state_29370__$1;
(statearr_29377_29400[(1)] = (7));

} else {
var statearr_29378_29401 = state_29370__$1;
(statearr_29378_29401[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29371 === (3))){
var inst_29368 = (state_29370[(2)]);
var state_29370__$1 = state_29370;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29370__$1,inst_29368);
} else {
if((state_val_29371 === (12))){
var inst_29365 = (state_29370[(2)]);
var _ = (function (){var statearr_29379 = state_29370;
(statearr_29379[(4)] = cljs.core.rest((state_29370[(4)])));

return statearr_29379;
})();
var state_29370__$1 = state_29370;
var statearr_29380_29402 = state_29370__$1;
(statearr_29380_29402[(2)] = inst_29365);

(statearr_29380_29402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29371 === (2))){
var _ = (function (){var statearr_29381 = state_29370;
(statearr_29381[(4)] = cljs.core.cons((5),(state_29370[(4)])));

return statearr_29381;
})();
var inst_29347 = fluree.db.storage.core.storage_read(conn,key);
var state_29370__$1 = state_29370;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29370__$1,(6),inst_29347);
} else {
if((state_val_29371 === (11))){
var inst_29349 = (state_29370[(10)]);
var inst_29359 = fluree.db.storage.core.serde(conn);
var inst_29360 = fluree.db.serde.protocol._deserialize_leaf(inst_29359,inst_29349);
var inst_29361 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_29360);
var inst_29362 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_29361);
var inst_29363 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_29362);
var state_29370__$1 = state_29370;
var statearr_29383_29403 = state_29370__$1;
(statearr_29383_29403[(2)] = inst_29363);

(statearr_29383_29403[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29371 === (9))){
var inst_29355 = (state_29370[(2)]);
var state_29370__$1 = state_29370;
if(cljs.core.truth_(inst_29355)){
var statearr_29384_29404 = state_29370__$1;
(statearr_29384_29404[(1)] = (10));

} else {
var statearr_29385_29405 = state_29370__$1;
(statearr_29385_29405[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29371 === (5))){
var _ = (function (){var statearr_29386 = state_29370;
(statearr_29386[(4)] = cljs.core.rest((state_29370[(4)])));

return statearr_29386;
})();
var state_29370__$1 = state_29370;
var ex29382 = (state_29370__$1[(2)]);
var statearr_29387_29406 = state_29370__$1;
(statearr_29387_29406[(5)] = ex29382);


var statearr_29388_29407 = state_29370__$1;
(statearr_29388_29407[(1)] = (4));

(statearr_29388_29407[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29371 === (10))){
var inst_29357 = cljs.core.async.close_BANG_(return_ch);
var state_29370__$1 = state_29370;
var statearr_29389_29408 = state_29370__$1;
(statearr_29389_29408[(2)] = inst_29357);

(statearr_29389_29408[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29371 === (8))){
var inst_29349 = (state_29370[(10)]);
var inst_29353 = (inst_29349 instanceof Error);
var state_29370__$1 = state_29370;
var statearr_29390_29409 = state_29370__$1;
(statearr_29390_29409[(2)] = inst_29353);

(statearr_29390_29409[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__11438__auto____0 = (function (){
var statearr_29391 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29391[(0)] = fluree$db$storage$core$reify_history_$_state_machine__11438__auto__);

(statearr_29391[(1)] = (1));

return statearr_29391;
});
var fluree$db$storage$core$reify_history_$_state_machine__11438__auto____1 = (function (state_29370){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_29370);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e29392){var ex__11441__auto__ = e29392;
var statearr_29393_29410 = state_29370;
(statearr_29393_29410[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_29370[(4)]))){
var statearr_29394_29411 = state_29370;
(statearr_29394_29411[(1)] = cljs.core.first((state_29370[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29412 = state_29370;
state_29370 = G__29412;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__11438__auto__ = function(state_29370){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__11438__auto____1.call(this,state_29370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__11438__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__11438__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_29395 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_29395[(6)] = c__11512__auto___29396);

return statearr_29395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__29414 = arguments.length;
switch (G__29414) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__5043__auto__ = (rhs == null);
if(and__5043__auto__){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11512__auto___29526 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_29477){
var state_val_29478 = (state_29477[(1)]);
if((state_val_29478 === (7))){
var state_29477__$1 = state_29477;
var statearr_29479_29527 = state_29477__$1;
(statearr_29479_29527[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_29479_29527[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (20))){
var inst_29456 = cljs.core.PersistentVector.EMPTY;
var state_29477__$1 = state_29477;
var statearr_29480_29528 = state_29477__$1;
(statearr_29480_29528[(2)] = inst_29456);

(statearr_29480_29528[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (1))){
var state_29477__$1 = state_29477;
var statearr_29481_29529 = state_29477__$1;
(statearr_29481_29529[(2)] = null);

(statearr_29481_29529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (24))){
var state_29477__$1 = state_29477;
var statearr_29482_29530 = state_29477__$1;
(statearr_29482_29530[(2)] = null);

(statearr_29482_29530[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (4))){
var inst_29417 = (state_29477[(2)]);
var inst_29418 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_29419 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_29417);
var inst_29420 = cljs.core.async.close_BANG_(result_ch);
var state_29477__$1 = (function (){var statearr_29483 = state_29477;
(statearr_29483[(7)] = inst_29418);

(statearr_29483[(8)] = inst_29419);

return statearr_29483;
})();
var statearr_29484_29531 = state_29477__$1;
(statearr_29484_29531[(2)] = inst_29420);

(statearr_29484_29531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (15))){
var inst_29442 = (state_29477[(2)]);
var state_29477__$1 = state_29477;
var statearr_29485_29532 = state_29477__$1;
(statearr_29485_29532[(2)] = inst_29442);

(statearr_29485_29532[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (21))){
var inst_29446 = (state_29477[(9)]);
var inst_29459 = (state_29477[(10)]);
var inst_29431 = (state_29477[(11)]);
var inst_29430 = (state_29477[(12)]);
var inst_29429 = (state_29477[(13)]);
var inst_29466 = (state_29477[(2)]);
var inst_29467 = (function (){var base_node = inst_29429;
var first_flake = inst_29430;
var node_t = inst_29431;
var source = inst_29446;
var coll = inst_29459;
var conj_QMARK_ = inst_29466;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__29487 = f.p;
var fexpr__29486 = (function (){var or__5045__auto__ = remove_preds;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__29486.cljs$core$IFn$_invoke$arity$1 ? fexpr__29486.cljs$core$IFn$_invoke$arity$1(G__29487) : fexpr__29486.call(null,G__29487));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_29468 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_29429);
var inst_29469 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_29467,inst_29468,inst_29459);
var inst_29470 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_29469);
var inst_29471 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_29429,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_29470);
var inst_29472 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_29471);
var _ = (function (){var statearr_29488 = state_29477;
(statearr_29488[(4)] = cljs.core.rest((state_29477[(4)])));

return statearr_29488;
})();
var state_29477__$1 = state_29477;
var statearr_29489_29533 = state_29477__$1;
(statearr_29489_29533[(2)] = inst_29472);

(statearr_29489_29533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (13))){
var state_29477__$1 = state_29477;
var statearr_29490_29534 = state_29477__$1;
(statearr_29490_29534[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_29490_29534[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (22))){
var inst_29446 = (state_29477[(9)]);
var inst_29459 = (state_29477[(10)]);
var inst_29431 = (state_29477[(11)]);
var inst_29430 = (state_29477[(12)]);
var inst_29429 = (state_29477[(13)]);
var inst_29460 = (function (){var base_node = inst_29429;
var first_flake = inst_29430;
var node_t = inst_29431;
var source = inst_29446;
var coll = inst_29459;
return (function (f){
return f.op === true;
});
})();
var state_29477__$1 = state_29477;
var statearr_29491_29535 = state_29477__$1;
(statearr_29491_29535[(2)] = inst_29460);

(statearr_29491_29535[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (6))){
var inst_29431 = (state_29477[(11)]);
var inst_29429 = (state_29477[(13)]);
var inst_29428 = (state_29477[(2)]);
var inst_29429__$1 = fluree.db.util.async.throw_err(inst_29428);
var inst_29430 = fluree.db.dbproto._first_flake(inst_29429__$1);
var inst_29431__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_29429__$1);
var inst_29432 = (inst_29431__$1 > t);
var state_29477__$1 = (function (){var statearr_29492 = state_29477;
(statearr_29492[(11)] = inst_29431__$1);

(statearr_29492[(12)] = inst_29430);

(statearr_29492[(13)] = inst_29429__$1);

return statearr_29492;
})();
if(cljs.core.truth_(inst_29432)){
var statearr_29493_29536 = state_29477__$1;
(statearr_29493_29536[(1)] = (7));

} else {
var statearr_29494_29537 = state_29477__$1;
(statearr_29494_29537[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (17))){
var inst_29430 = (state_29477[(12)]);
var inst_29447 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_29430,rhs,leftmost_QMARK_,t);
var state_29477__$1 = state_29477;
var statearr_29495_29538 = state_29477__$1;
(statearr_29495_29538[(2)] = inst_29447);

(statearr_29495_29538[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (3))){
var inst_29475 = (state_29477[(2)]);
var state_29477__$1 = state_29477;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29477__$1,inst_29475);
} else {
if((state_val_29478 === (12))){
var inst_29444 = (state_29477[(2)]);
var state_29477__$1 = state_29477;
var statearr_29496_29539 = state_29477__$1;
(statearr_29496_29539[(2)] = inst_29444);

(statearr_29496_29539[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (2))){
var _ = (function (){var statearr_29497 = state_29477;
(statearr_29497[(4)] = cljs.core.cons((5),(state_29477[(4)])));

return statearr_29497;
})();
var inst_29426 = fluree.db.dbproto._resolve(node);
var state_29477__$1 = state_29477;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29477__$1,(6),inst_29426);
} else {
if((state_val_29478 === (23))){
var inst_29446 = (state_29477[(9)]);
var inst_29459 = (state_29477[(10)]);
var inst_29431 = (state_29477[(11)]);
var inst_29430 = (state_29477[(12)]);
var inst_29429 = (state_29477[(13)]);
var inst_29462 = (function (){var base_node = inst_29429;
var first_flake = inst_29430;
var node_t = inst_29431;
var source = inst_29446;
var coll = inst_29459;
return (function (f){
return f.op === false;
});
})();
var state_29477__$1 = state_29477;
var statearr_29498_29540 = state_29477__$1;
(statearr_29498_29540[(2)] = inst_29462);

(statearr_29498_29540[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (19))){
var inst_29449 = (state_29477[(14)]);
var inst_29452 = (state_29477[(2)]);
var inst_29453 = fluree.db.util.async.throw_err(inst_29452);
var inst_29454 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_29449,inst_29453);
var state_29477__$1 = state_29477;
var statearr_29499_29541 = state_29477__$1;
(statearr_29499_29541[(2)] = inst_29454);

(statearr_29499_29541[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (11))){
var inst_29431 = (state_29477[(11)]);
var inst_29438 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29431,t);
var state_29477__$1 = state_29477;
if(inst_29438){
var statearr_29501_29542 = state_29477__$1;
(statearr_29501_29542[(1)] = (13));

} else {
var statearr_29502_29543 = state_29477__$1;
(statearr_29502_29543[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (9))){
var inst_29446 = (state_29477[(9)]);
var inst_29446__$1 = (state_29477[(2)]);
var state_29477__$1 = (function (){var statearr_29503 = state_29477;
(statearr_29503[(9)] = inst_29446__$1);

return statearr_29503;
})();
var G__29504_29544 = inst_29446__$1;
var G__29504_29545__$1 = (((G__29504_29544 instanceof cljs.core.Keyword))?G__29504_29544.fqn:null);
switch (G__29504_29545__$1) {
case "novelty":
var statearr_29505_29547 = state_29477__$1;
(statearr_29505_29547[(1)] = (17));


break;
case "history":
var statearr_29506_29548 = state_29477__$1;
(statearr_29506_29548[(1)] = (18));


break;
case "none":
var statearr_29507_29549 = state_29477__$1;
(statearr_29507_29549[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29504_29545__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (5))){
var _ = (function (){var statearr_29508 = state_29477;
(statearr_29508[(4)] = cljs.core.rest((state_29477[(4)])));

return statearr_29508;
})();
var state_29477__$1 = state_29477;
var ex29500 = (state_29477__$1[(2)]);
var statearr_29509_29550 = state_29477__$1;
(statearr_29509_29550[(5)] = ex29500);


var statearr_29510_29551 = state_29477__$1;
(statearr_29510_29551[(1)] = (4));

(statearr_29510_29551[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (14))){
var state_29477__$1 = state_29477;
var statearr_29511_29552 = state_29477__$1;
(statearr_29511_29552[(2)] = null);

(statearr_29511_29552[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (16))){
var inst_29446 = (state_29477[(9)]);
var inst_29459 = (state_29477[(2)]);
var state_29477__$1 = (function (){var statearr_29512 = state_29477;
(statearr_29512[(10)] = inst_29459);

return statearr_29512;
})();
var G__29513_29553 = inst_29446;
var G__29513_29554__$1 = (((G__29513_29553 instanceof cljs.core.Keyword))?G__29513_29553.fqn:null);
switch (G__29513_29554__$1) {
case "novelty":
var statearr_29514_29556 = state_29477__$1;
(statearr_29514_29556[(1)] = (22));


break;
case "history":
var statearr_29515_29557 = state_29477__$1;
(statearr_29515_29557[(1)] = (23));


break;
case "none":
var statearr_29516_29558 = state_29477__$1;
(statearr_29516_29558[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29513_29554__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (10))){
var state_29477__$1 = state_29477;
var statearr_29517_29559 = state_29477__$1;
(statearr_29517_29559[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_29517_29559[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29478 === (18))){
var inst_29446 = (state_29477[(9)]);
var inst_29431 = (state_29477[(11)]);
var inst_29430 = (state_29477[(12)]);
var inst_29429 = (state_29477[(13)]);
var inst_29449 = (function (){var base_node = inst_29429;
var first_flake = inst_29430;
var node_t = inst_29431;
var source = inst_29446;
return (function (p1__29416_SHARP_){
return (p1__29416_SHARP_.t <= t);
});
})();
var inst_29450 = fluree.db.dbproto._resolve_history(node);
var state_29477__$1 = (function (){var statearr_29518 = state_29477;
(statearr_29518[(14)] = inst_29449);

return statearr_29518;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29477__$1,(19),inst_29450);
} else {
if((state_val_29478 === (8))){
var inst_29431 = (state_29477[(11)]);
var inst_29435 = (inst_29431 < t);
var state_29477__$1 = state_29477;
if(cljs.core.truth_(inst_29435)){
var statearr_29519_29560 = state_29477__$1;
(statearr_29519_29560[(1)] = (10));

} else {
var statearr_29520_29561 = state_29477__$1;
(statearr_29520_29561[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__11438__auto____0 = (function (){
var statearr_29521 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29521[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__11438__auto__);

(statearr_29521[(1)] = (1));

return statearr_29521;
});
var fluree$db$storage$core$resolve_t_$_state_machine__11438__auto____1 = (function (state_29477){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_29477);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e29522){var ex__11441__auto__ = e29522;
var statearr_29523_29562 = state_29477;
(statearr_29523_29562[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_29477[(4)]))){
var statearr_29524_29563 = state_29477;
(statearr_29524_29563[(1)] = cljs.core.first((state_29477[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29564 = state_29477;
state_29477 = G__29564;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__11438__auto__ = function(state_29477){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__11438__auto____1.call(this,state_29477);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__11438__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__11438__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_29525 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_29525[(6)] = c__11512__auto___29526);

return statearr_29525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_29624){
var state_val_29625 = (state_29624[(1)]);
if((state_val_29625 === (7))){
var inst_29575 = (state_29624[(7)]);
var inst_29579 = (inst_29575 <= from_t);
var state_29624__$1 = state_29624;
var statearr_29626_29666 = state_29624__$1;
(statearr_29626_29666[(2)] = inst_29579);

(statearr_29626_29666[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (20))){
var inst_29609 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_29610 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29609)].join('');
var inst_29611 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29612 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_29613 = cljs.core.PersistentHashMap.fromArrays(inst_29611,inst_29612);
var inst_29614 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29610,inst_29613);
var inst_29615 = (function(){throw inst_29614})();
var state_29624__$1 = state_29624;
var statearr_29627_29667 = state_29624__$1;
(statearr_29627_29667[(2)] = inst_29615);

(statearr_29627_29667[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (1))){
var state_29624__$1 = state_29624;
var statearr_29628_29668 = state_29624__$1;
(statearr_29628_29668[(2)] = null);

(statearr_29628_29668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (4))){
var inst_29567 = (state_29624[(2)]);
var inst_29568 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29567], 0));
var inst_29569 = (function(){throw inst_29567})();
var state_29624__$1 = (function (){var statearr_29629 = state_29624;
(statearr_29629[(8)] = inst_29568);

return statearr_29629;
})();
var statearr_29630_29669 = state_29624__$1;
(statearr_29630_29669[(2)] = inst_29569);

(statearr_29630_29669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (15))){
var inst_29594 = (state_29624[(2)]);
var state_29624__$1 = (function (){var statearr_29631 = state_29624;
(statearr_29631[(9)] = inst_29594);

return statearr_29631;
})();
if(cljs.core.truth_(from_t)){
var statearr_29632_29670 = state_29624__$1;
(statearr_29632_29670[(1)] = (16));

} else {
var statearr_29633_29671 = state_29624__$1;
(statearr_29633_29671[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (21))){
var inst_29603 = (state_29624[(10)]);
var inst_29605 = (state_29624[(11)]);
var inst_29604 = (state_29624[(12)]);
var inst_29617 = (state_29624[(2)]);
var inst_29618 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_29604,inst_29605,leftmost_QMARK_,to_t);
var inst_29619 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29618,inst_29603);
var _ = (function (){var statearr_29634 = state_29624;
(statearr_29634[(4)] = cljs.core.rest((state_29624[(4)])));

return statearr_29634;
})();
var state_29624__$1 = (function (){var statearr_29635 = state_29624;
(statearr_29635[(13)] = inst_29617);

return statearr_29635;
})();
var statearr_29636_29672 = state_29624__$1;
(statearr_29636_29672[(2)] = inst_29619);

(statearr_29636_29672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (13))){
var inst_29575 = (state_29624[(7)]);
var inst_29587 = (state_29624[(14)]);
var inst_29590 = (function (){var node_t = inst_29575;
var G__29583 = inst_29587;
return (function (p1__29565_SHARP_){
return (p1__29565_SHARP_.t < to_t);
});
})();
var inst_29591 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_29590,inst_29587);
var state_29624__$1 = state_29624;
var statearr_29637_29673 = state_29624__$1;
(statearr_29637_29673[(2)] = inst_29591);

(statearr_29637_29673[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (6))){
var inst_29576 = (state_29624[(15)]);
var state_29624__$1 = state_29624;
var statearr_29638_29674 = state_29624__$1;
(statearr_29638_29674[(2)] = inst_29576);

(statearr_29638_29674[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (17))){
var inst_29594 = (state_29624[(9)]);
var state_29624__$1 = state_29624;
var statearr_29639_29675 = state_29624__$1;
(statearr_29639_29675[(2)] = inst_29594);

(statearr_29639_29675[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (3))){
var inst_29622 = (state_29624[(2)]);
var state_29624__$1 = state_29624;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29624__$1,inst_29622);
} else {
if((state_val_29625 === (12))){
var inst_29575 = (state_29624[(7)]);
var inst_29586 = (state_29624[(2)]);
var inst_29587 = fluree.db.util.async.throw_err(inst_29586);
var inst_29588 = (to_t > inst_29575);
var state_29624__$1 = (function (){var statearr_29640 = state_29624;
(statearr_29640[(14)] = inst_29587);

return statearr_29640;
})();
if(cljs.core.truth_(inst_29588)){
var statearr_29641_29676 = state_29624__$1;
(statearr_29641_29676[(1)] = (13));

} else {
var statearr_29642_29677 = state_29624__$1;
(statearr_29642_29677[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (2))){
var inst_29576 = (state_29624[(15)]);
var _ = (function (){var statearr_29643 = state_29624;
(statearr_29643[(4)] = cljs.core.cons((5),(state_29624[(4)])));

return statearr_29643;
})();
var inst_29575 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_29576__$1 = (from_t == null);
var state_29624__$1 = (function (){var statearr_29644 = state_29624;
(statearr_29644[(7)] = inst_29575);

(statearr_29644[(15)] = inst_29576__$1);

return statearr_29644;
})();
if(cljs.core.truth_(inst_29576__$1)){
var statearr_29645_29678 = state_29624__$1;
(statearr_29645_29678[(1)] = (6));

} else {
var statearr_29646_29679 = state_29624__$1;
(statearr_29646_29679[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (19))){
var state_29624__$1 = state_29624;
var statearr_29647_29680 = state_29624__$1;
(statearr_29647_29680[(2)] = null);

(statearr_29647_29680[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (11))){
var inst_29603 = (state_29624[(2)]);
var inst_29604 = fluree.db.dbproto._first_flake(node);
var inst_29605 = fluree.db.dbproto._rhs(node);
var inst_29606 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_29624__$1 = (function (){var statearr_29649 = state_29624;
(statearr_29649[(10)] = inst_29603);

(statearr_29649[(11)] = inst_29605);

(statearr_29649[(12)] = inst_29604);

return statearr_29649;
})();
if(cljs.core.truth_(inst_29606)){
var statearr_29650_29681 = state_29624__$1;
(statearr_29650_29681[(1)] = (19));

} else {
var statearr_29651_29682 = state_29624__$1;
(statearr_29651_29682[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (9))){
var inst_29584 = fluree.db.dbproto._resolve_history(node);
var state_29624__$1 = state_29624;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29624__$1,(12),inst_29584);
} else {
if((state_val_29625 === (5))){
var _ = (function (){var statearr_29652 = state_29624;
(statearr_29652[(4)] = cljs.core.rest((state_29624[(4)])));

return statearr_29652;
})();
var state_29624__$1 = state_29624;
var ex29648 = (state_29624__$1[(2)]);
var statearr_29653_29683 = state_29624__$1;
(statearr_29653_29683[(5)] = ex29648);


var statearr_29654_29684 = state_29624__$1;
(statearr_29654_29684[(1)] = (4));

(statearr_29654_29684[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (14))){
var inst_29587 = (state_29624[(14)]);
var state_29624__$1 = state_29624;
var statearr_29655_29685 = state_29624__$1;
(statearr_29655_29685[(2)] = inst_29587);

(statearr_29655_29685[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (16))){
var inst_29575 = (state_29624[(7)]);
var inst_29594 = (state_29624[(9)]);
var inst_29596 = (function (){var node_t = inst_29575;
var G__29583 = inst_29594;
return (function (p1__29566_SHARP_){
return (p1__29566_SHARP_.t <= from_t);
});
})();
var inst_29597 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_29596,inst_29594);
var state_29624__$1 = state_29624;
var statearr_29656_29686 = state_29624__$1;
(statearr_29656_29686[(2)] = inst_29597);

(statearr_29656_29686[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (10))){
var state_29624__$1 = state_29624;
var statearr_29657_29687 = state_29624__$1;
(statearr_29657_29687[(2)] = null);

(statearr_29657_29687[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (18))){
var inst_29600 = (state_29624[(2)]);
var state_29624__$1 = state_29624;
var statearr_29658_29688 = state_29624__$1;
(statearr_29658_29688[(2)] = inst_29600);

(statearr_29658_29688[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29625 === (8))){
var inst_29581 = (state_29624[(2)]);
var state_29624__$1 = state_29624;
if(cljs.core.truth_(inst_29581)){
var statearr_29659_29689 = state_29624__$1;
(statearr_29659_29689[(1)] = (9));

} else {
var statearr_29660_29690 = state_29624__$1;
(statearr_29660_29690[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__11438__auto____0 = (function (){
var statearr_29661 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29661[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__11438__auto__);

(statearr_29661[(1)] = (1));

return statearr_29661;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__11438__auto____1 = (function (state_29624){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_29624);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e29662){var ex__11441__auto__ = e29662;
var statearr_29663_29691 = state_29624;
(statearr_29663_29691[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_29624[(4)]))){
var statearr_29664_29692 = state_29624;
(statearr_29664_29692[(1)] = cljs.core.first((state_29624[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29693 = state_29624;
state_29624 = G__29693;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__11438__auto__ = function(state_29624){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__11438__auto____1.call(this,state_29624);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__11438__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__11438__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_29665 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_29665[(6)] = c__11512__auto__);

return statearr_29665;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__5045__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__29694_29704 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__29695_29705 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__29694_29704,G__29695_29705) : object_cache.call(null,G__29694_29704,G__29695_29705));

var G__29696 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__29697 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__29698 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__29699 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__29698,G__29699) : object_cache.call(null,G__29698,G__29699));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__29696,G__29697) : object_cache.call(null,G__29696,G__29697));
} else {
var G__29700 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__29701 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__29702 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__29703 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__29702,G__29703) : object_cache.call(null,G__29702,G__29703));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__29700,G__29701) : object_cache.call(null,G__29700,G__29701));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_29726){
var state_val_29727 = (state_29726[(1)]);
if((state_val_29727 === (7))){
var inst_29715 = (state_29726[(7)]);
var inst_29717 = fluree.db.storage.core.serde(conn);
var inst_29718 = fluree.db.serde.protocol._deserialize_branch(inst_29717,inst_29715);
var state_29726__$1 = state_29726;
var statearr_29728_29747 = state_29726__$1;
(statearr_29728_29747[(2)] = inst_29718);

(statearr_29728_29747[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29727 === (1))){
var state_29726__$1 = state_29726;
var statearr_29729_29748 = state_29726__$1;
(statearr_29729_29748[(2)] = null);

(statearr_29729_29748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29727 === (4))){
var inst_29706 = (state_29726[(2)]);
var state_29726__$1 = state_29726;
var statearr_29730_29749 = state_29726__$1;
(statearr_29730_29749[(2)] = inst_29706);

(statearr_29730_29749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29727 === (6))){
var inst_29715 = (state_29726[(7)]);
var inst_29714 = (state_29726[(2)]);
var inst_29715__$1 = fluree.db.util.async.throw_err(inst_29714);
var state_29726__$1 = (function (){var statearr_29731 = state_29726;
(statearr_29731[(7)] = inst_29715__$1);

return statearr_29731;
})();
if(cljs.core.truth_(inst_29715__$1)){
var statearr_29732_29750 = state_29726__$1;
(statearr_29732_29750[(1)] = (7));

} else {
var statearr_29733_29751 = state_29726__$1;
(statearr_29733_29751[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29727 === (3))){
var inst_29724 = (state_29726[(2)]);
var state_29726__$1 = state_29726;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29726__$1,inst_29724);
} else {
if((state_val_29727 === (2))){
var _ = (function (){var statearr_29735 = state_29726;
(statearr_29735[(4)] = cljs.core.cons((5),(state_29726[(4)])));

return statearr_29735;
})();
var inst_29712 = fluree.db.storage.core.storage_read(conn,key);
var state_29726__$1 = state_29726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29726__$1,(6),inst_29712);
} else {
if((state_val_29727 === (9))){
var inst_29721 = (state_29726[(2)]);
var _ = (function (){var statearr_29736 = state_29726;
(statearr_29736[(4)] = cljs.core.rest((state_29726[(4)])));

return statearr_29736;
})();
var state_29726__$1 = state_29726;
var statearr_29737_29752 = state_29726__$1;
(statearr_29737_29752[(2)] = inst_29721);

(statearr_29737_29752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29727 === (5))){
var _ = (function (){var statearr_29738 = state_29726;
(statearr_29738[(4)] = cljs.core.rest((state_29726[(4)])));

return statearr_29738;
})();
var state_29726__$1 = state_29726;
var ex29734 = (state_29726__$1[(2)]);
var statearr_29739_29753 = state_29726__$1;
(statearr_29739_29753[(5)] = ex29734);


if((ex29734 instanceof Error)){
var statearr_29740_29754 = state_29726__$1;
(statearr_29740_29754[(1)] = (4));

(statearr_29740_29754[(5)] = null);

} else {
throw ex29734;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29727 === (8))){
var state_29726__$1 = state_29726;
var statearr_29741_29755 = state_29726__$1;
(statearr_29741_29755[(2)] = null);

(statearr_29741_29755[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__11438__auto____0 = (function (){
var statearr_29742 = [null,null,null,null,null,null,null,null];
(statearr_29742[(0)] = fluree$db$storage$core$read_branch_$_state_machine__11438__auto__);

(statearr_29742[(1)] = (1));

return statearr_29742;
});
var fluree$db$storage$core$read_branch_$_state_machine__11438__auto____1 = (function (state_29726){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_29726);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e29743){var ex__11441__auto__ = e29743;
var statearr_29744_29756 = state_29726;
(statearr_29744_29756[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_29726[(4)]))){
var statearr_29745_29757 = state_29726;
(statearr_29745_29757[(1)] = cljs.core.first((state_29726[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29758 = state_29726;
state_29726 = G__29758;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__11438__auto__ = function(state_29726){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__11438__auto____1.call(this,state_29726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__11438__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__11438__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_29746 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_29746[(6)] = c__11512__auto__);

return statearr_29746;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11512__auto___29837 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_29809){
var state_val_29810 = (state_29809[(1)]);
if((state_val_29810 === (7))){
var inst_29776 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_29777 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29778 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_29779 = cljs.core.PersistentHashMap.fromArrays(inst_29777,inst_29778);
var inst_29780 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29776,inst_29779);
var inst_29781 = (function(){throw inst_29780})();
var state_29809__$1 = state_29809;
var statearr_29811_29838 = state_29809__$1;
(statearr_29811_29838[(2)] = inst_29781);

(statearr_29811_29838[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29810 === (1))){
var state_29809__$1 = state_29809;
var statearr_29812_29839 = state_29809__$1;
(statearr_29812_29839[(2)] = null);

(statearr_29812_29839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29810 === (4))){
var inst_29759 = (state_29809[(2)]);
var inst_29760 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_29761 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_29759);
var inst_29762 = cljs.core.async.close_BANG_(return_ch);
var state_29809__$1 = (function (){var statearr_29813 = state_29809;
(statearr_29813[(7)] = inst_29760);

(statearr_29813[(8)] = inst_29761);

return statearr_29813;
})();
var statearr_29814_29840 = state_29809__$1;
(statearr_29814_29840[(2)] = inst_29762);

(statearr_29814_29840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29810 === (6))){
var inst_29773 = (state_29809[(9)]);
var inst_29772 = (state_29809[(2)]);
var inst_29773__$1 = fluree.db.util.async.throw_err(inst_29772);
var inst_29774 = (inst_29773__$1 == null);
var state_29809__$1 = (function (){var statearr_29815 = state_29809;
(statearr_29815[(9)] = inst_29773__$1);

return statearr_29815;
})();
if(cljs.core.truth_(inst_29774)){
var statearr_29816_29841 = state_29809__$1;
(statearr_29816_29841[(1)] = (7));

} else {
var statearr_29817_29842 = state_29809__$1;
(statearr_29817_29842[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29810 === (3))){
var inst_29807 = (state_29809[(2)]);
var state_29809__$1 = state_29809;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29809__$1,inst_29807);
} else {
if((state_val_29810 === (12))){
var inst_29773 = (state_29809[(9)]);
var inst_29790 = (state_29809[(2)]);
var inst_29791 = cljs.core.__destructure_map(inst_29773);
var inst_29792 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29791,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_29793 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29791,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_29794 = config;
var inst_29795 = cljs.core.__destructure_map(inst_29794);
var inst_29796 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29795,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_29798 = (function (){var data = inst_29773;
var _ = inst_29790;
var map__29768 = inst_29791;
var children = inst_29792;
var rhs = inst_29793;
var map__29769 = inst_29795;
var comparator = inst_29796;
return (function (idx,p__29797){
var map__29818 = p__29797;
var map__29818__$1 = cljs.core.__destructure_map(map__29818);
var child = map__29818__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29818__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29818__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29818__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29818__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29818__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__5043__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (idx === (0));
} else {
return and__5043__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_29799 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_29798,inst_29792);
var inst_29800 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),inst_29799);
var inst_29801 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_29800,inst_29799);
var inst_29802 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_29796,inst_29801);
var inst_29803 = fluree.db.index.__GT_IndexNode(block,t,inst_29793,inst_29802,config,leftmost_QMARK_);
var inst_29804 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_29803);
var _ = (function (){var statearr_29819 = state_29809;
(statearr_29819[(4)] = cljs.core.rest((state_29809[(4)])));

return statearr_29819;
})();
var state_29809__$1 = state_29809;
var statearr_29820_29843 = state_29809__$1;
(statearr_29820_29843[(2)] = inst_29804);

(statearr_29820_29843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29810 === (2))){
var _ = (function (){var statearr_29821 = state_29809;
(statearr_29821[(4)] = cljs.core.cons((5),(state_29809[(4)])));

return statearr_29821;
})();
var inst_29770 = fluree.db.storage.core.read_branch(conn,key);
var state_29809__$1 = state_29809;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29809__$1,(6),inst_29770);
} else {
if((state_val_29810 === (11))){
var state_29809__$1 = state_29809;
var statearr_29823_29844 = state_29809__$1;
(statearr_29823_29844[(2)] = null);

(statearr_29823_29844[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29810 === (9))){
var inst_29773 = (state_29809[(9)]);
var inst_29784 = (state_29809[(2)]);
var inst_29785 = fluree.db.util.core.exception_QMARK_(inst_29773);
var state_29809__$1 = (function (){var statearr_29824 = state_29809;
(statearr_29824[(10)] = inst_29784);

return statearr_29824;
})();
if(inst_29785){
var statearr_29825_29845 = state_29809__$1;
(statearr_29825_29845[(1)] = (10));

} else {
var statearr_29826_29846 = state_29809__$1;
(statearr_29826_29846[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29810 === (5))){
var _ = (function (){var statearr_29827 = state_29809;
(statearr_29827[(4)] = cljs.core.rest((state_29809[(4)])));

return statearr_29827;
})();
var state_29809__$1 = state_29809;
var ex29822 = (state_29809__$1[(2)]);
var statearr_29828_29847 = state_29809__$1;
(statearr_29828_29847[(5)] = ex29822);


var statearr_29829_29848 = state_29809__$1;
(statearr_29829_29848[(1)] = (4));

(statearr_29829_29848[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29810 === (10))){
var inst_29773 = (state_29809[(9)]);
var inst_29787 = (function(){throw inst_29773})();
var state_29809__$1 = state_29809;
var statearr_29830_29849 = state_29809__$1;
(statearr_29830_29849[(2)] = inst_29787);

(statearr_29830_29849[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29810 === (8))){
var state_29809__$1 = state_29809;
var statearr_29831_29850 = state_29809__$1;
(statearr_29831_29850[(2)] = null);

(statearr_29831_29850[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__11438__auto____0 = (function (){
var statearr_29832 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29832[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__11438__auto__);

(statearr_29832[(1)] = (1));

return statearr_29832;
});
var fluree$db$storage$core$reify_branch_$_state_machine__11438__auto____1 = (function (state_29809){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_29809);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e29833){var ex__11441__auto__ = e29833;
var statearr_29834_29851 = state_29809;
(statearr_29834_29851[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_29809[(4)]))){
var statearr_29835_29852 = state_29809;
(statearr_29835_29852[(1)] = cljs.core.first((state_29809[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29853 = state_29809;
state_29809 = G__29853;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__11438__auto__ = function(state_29809){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__11438__auto____1.call(this,state_29809);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__11438__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__11438__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_29836 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_29836[(6)] = c__11512__auto___29837);

return statearr_29836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_29874){
var state_val_29875 = (state_29874[(1)]);
if((state_val_29875 === (7))){
var state_29874__$1 = state_29874;
var statearr_29876_29896 = state_29874__$1;
(statearr_29876_29896[(2)] = null);

(statearr_29876_29896[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29875 === (1))){
var state_29874__$1 = state_29874;
var statearr_29877_29897 = state_29874__$1;
(statearr_29877_29897[(2)] = null);

(statearr_29877_29897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29875 === (4))){
var inst_29854 = (state_29874[(2)]);
var state_29874__$1 = state_29874;
var statearr_29878_29898 = state_29874__$1;
(statearr_29878_29898[(2)] = inst_29854);

(statearr_29878_29898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29875 === (6))){
var inst_29860 = (state_29874[(7)]);
var inst_29862 = fluree.db.storage.core.serde(conn);
var state_29874__$1 = (function (){var statearr_29879 = state_29874;
(statearr_29879[(8)] = inst_29862);

return statearr_29879;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29874__$1,(9),inst_29860);
} else {
if((state_val_29875 === (3))){
var inst_29872 = (state_29874[(2)]);
var state_29874__$1 = state_29874;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29874__$1,inst_29872);
} else {
if((state_val_29875 === (2))){
var inst_29860 = (state_29874[(7)]);
var _ = (function (){var statearr_29881 = state_29874;
(statearr_29881[(4)] = cljs.core.cons((5),(state_29874[(4)])));

return statearr_29881;
})();
var inst_29860__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_29874__$1 = (function (){var statearr_29882 = state_29874;
(statearr_29882[(7)] = inst_29860__$1);

return statearr_29882;
})();
if(cljs.core.truth_(inst_29860__$1)){
var statearr_29883_29899 = state_29874__$1;
(statearr_29883_29899[(1)] = (6));

} else {
var statearr_29884_29900 = state_29874__$1;
(statearr_29884_29900[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29875 === (9))){
var inst_29862 = (state_29874[(8)]);
var inst_29864 = (state_29874[(2)]);
var inst_29865 = fluree.db.util.async.throw_err(inst_29864);
var inst_29866 = fluree.db.serde.protocol._deserialize_leaf(inst_29862,inst_29865);
var state_29874__$1 = state_29874;
var statearr_29885_29901 = state_29874__$1;
(statearr_29885_29901[(2)] = inst_29866);

(statearr_29885_29901[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29875 === (5))){
var _ = (function (){var statearr_29886 = state_29874;
(statearr_29886[(4)] = cljs.core.rest((state_29874[(4)])));

return statearr_29886;
})();
var state_29874__$1 = state_29874;
var ex29880 = (state_29874__$1[(2)]);
var statearr_29887_29902 = state_29874__$1;
(statearr_29887_29902[(5)] = ex29880);


if((ex29880 instanceof Error)){
var statearr_29888_29903 = state_29874__$1;
(statearr_29888_29903[(1)] = (4));

(statearr_29888_29903[(5)] = null);

} else {
throw ex29880;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29875 === (8))){
var inst_29869 = (state_29874[(2)]);
var _ = (function (){var statearr_29889 = state_29874;
(statearr_29889[(4)] = cljs.core.rest((state_29874[(4)])));

return statearr_29889;
})();
var state_29874__$1 = state_29874;
var statearr_29890_29904 = state_29874__$1;
(statearr_29890_29904[(2)] = inst_29869);

(statearr_29890_29904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__11438__auto____0 = (function (){
var statearr_29891 = [null,null,null,null,null,null,null,null,null];
(statearr_29891[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__11438__auto__);

(statearr_29891[(1)] = (1));

return statearr_29891;
});
var fluree$db$storage$core$read_leaf_$_state_machine__11438__auto____1 = (function (state_29874){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_29874);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e29892){var ex__11441__auto__ = e29892;
var statearr_29893_29905 = state_29874;
(statearr_29893_29905[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_29874[(4)]))){
var statearr_29894_29906 = state_29874;
(statearr_29894_29906[(1)] = cljs.core.first((state_29874[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29907 = state_29874;
state_29874 = G__29907;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__11438__auto__ = function(state_29874){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__11438__auto____1.call(this,state_29874);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__11438__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__11438__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_29895 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_29895[(6)] = c__11512__auto__);

return statearr_29895;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11512__auto___29980 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_29952){
var state_val_29953 = (state_29952[(1)]);
if((state_val_29953 === (7))){
var inst_29924 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_29925 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29926 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_29927 = cljs.core.PersistentHashMap.fromArrays(inst_29925,inst_29926);
var inst_29928 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29924,inst_29927);
var inst_29929 = (function(){throw inst_29928})();
var state_29952__$1 = state_29952;
var statearr_29954_29981 = state_29952__$1;
(statearr_29954_29981[(2)] = inst_29929);

(statearr_29954_29981[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (1))){
var state_29952__$1 = state_29952;
var statearr_29955_29982 = state_29952__$1;
(statearr_29955_29982[(2)] = null);

(statearr_29955_29982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (4))){
var inst_29908 = (state_29952[(2)]);
var inst_29909 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_29910 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_29908);
var inst_29911 = cljs.core.async.close_BANG_(return_ch);
var state_29952__$1 = (function (){var statearr_29956 = state_29952;
(statearr_29956[(7)] = inst_29909);

(statearr_29956[(8)] = inst_29910);

return statearr_29956;
})();
var statearr_29957_29983 = state_29952__$1;
(statearr_29957_29983[(2)] = inst_29911);

(statearr_29957_29983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (6))){
var inst_29921 = (state_29952[(9)]);
var inst_29921__$1 = (state_29952[(2)]);
var inst_29922 = (inst_29921__$1 == null);
var state_29952__$1 = (function (){var statearr_29958 = state_29952;
(statearr_29958[(9)] = inst_29921__$1);

return statearr_29958;
})();
if(cljs.core.truth_(inst_29922)){
var statearr_29959_29984 = state_29952__$1;
(statearr_29959_29984[(1)] = (7));

} else {
var statearr_29960_29985 = state_29952__$1;
(statearr_29960_29985[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (3))){
var inst_29950 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29952__$1,inst_29950);
} else {
if((state_val_29953 === (12))){
var inst_29921 = (state_29952[(9)]);
var inst_29938 = (state_29952[(2)]);
var inst_29939 = cljs.core.__destructure_map(inst_29921);
var inst_29940 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29939,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_29941 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29939,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_29942 = config;
var inst_29943 = cljs.core.__destructure_map(inst_29942);
var inst_29944 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29943,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_29945 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_29944,inst_29940);
var inst_29946 = fluree.db.index.data_node(block,t,inst_29945,rhs,config);
var inst_29947 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_29946);
var _ = (function (){var statearr_29961 = state_29952;
(statearr_29961[(4)] = cljs.core.rest((state_29952[(4)])));

return statearr_29961;
})();
var state_29952__$1 = (function (){var statearr_29962 = state_29952;
(statearr_29962[(10)] = inst_29941);

(statearr_29962[(11)] = inst_29938);

return statearr_29962;
})();
var statearr_29963_29986 = state_29952__$1;
(statearr_29963_29986[(2)] = inst_29947);

(statearr_29963_29986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (2))){
var _ = (function (){var statearr_29964 = state_29952;
(statearr_29964[(4)] = cljs.core.cons((5),(state_29952[(4)])));

return statearr_29964;
})();
var inst_29919 = fluree.db.storage.core.read_leaf(conn,key);
var state_29952__$1 = state_29952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29952__$1,(6),inst_29919);
} else {
if((state_val_29953 === (11))){
var state_29952__$1 = state_29952;
var statearr_29966_29987 = state_29952__$1;
(statearr_29966_29987[(2)] = null);

(statearr_29966_29987[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (9))){
var inst_29921 = (state_29952[(9)]);
var inst_29932 = (state_29952[(2)]);
var inst_29933 = fluree.db.util.core.exception_QMARK_(inst_29921);
var state_29952__$1 = (function (){var statearr_29967 = state_29952;
(statearr_29967[(12)] = inst_29932);

return statearr_29967;
})();
if(inst_29933){
var statearr_29968_29988 = state_29952__$1;
(statearr_29968_29988[(1)] = (10));

} else {
var statearr_29969_29989 = state_29952__$1;
(statearr_29969_29989[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (5))){
var _ = (function (){var statearr_29970 = state_29952;
(statearr_29970[(4)] = cljs.core.rest((state_29952[(4)])));

return statearr_29970;
})();
var state_29952__$1 = state_29952;
var ex29965 = (state_29952__$1[(2)]);
var statearr_29971_29990 = state_29952__$1;
(statearr_29971_29990[(5)] = ex29965);


var statearr_29972_29991 = state_29952__$1;
(statearr_29972_29991[(1)] = (4));

(statearr_29972_29991[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (10))){
var inst_29921 = (state_29952[(9)]);
var inst_29935 = (function(){throw inst_29921})();
var state_29952__$1 = state_29952;
var statearr_29973_29992 = state_29952__$1;
(statearr_29973_29992[(2)] = inst_29935);

(statearr_29973_29992[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29953 === (8))){
var state_29952__$1 = state_29952;
var statearr_29974_29993 = state_29952__$1;
(statearr_29974_29993[(2)] = null);

(statearr_29974_29993[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__11438__auto____0 = (function (){
var statearr_29975 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29975[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__11438__auto__);

(statearr_29975[(1)] = (1));

return statearr_29975;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__11438__auto____1 = (function (state_29952){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_29952);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e29976){var ex__11441__auto__ = e29976;
var statearr_29977_29994 = state_29952;
(statearr_29977_29994[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_29952[(4)]))){
var statearr_29978_29995 = state_29952;
(statearr_29978_29995[(1)] = cljs.core.first((state_29952[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29996 = state_29952;
state_29952 = G__29996;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__11438__auto__ = function(state_29952){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__11438__auto____1.call(this,state_29952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__11438__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__11438__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_29979 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_29979[(6)] = c__11512__auto___29980);

return statearr_29979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k29998,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__30002 = k29998;
var G__30002__$1 = (((G__30002 instanceof cljs.core.Keyword))?G__30002.fqn:null);
switch (G__30002__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k29998,else__5345__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5365__auto__,p__30003){
var vec__30004 = p__30003;
var k__5366__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30004,(0),null);
var v__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30004,(1),null);
return (f__5363__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5363__auto__.cljs$core$IFn$_invoke$arity$3(ret__5365__auto__,k__5366__auto__,v__5367__auto__) : f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__));
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer(writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer(writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__5359__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__29997){
var self__ = this;
var G__29997__$1 = this;
return (new cljs.core.RecordIter((0),G__29997__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__30007 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__30008 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__30009 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__30010 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__30009,G__30010) : object_cache.call(null,G__30009,G__30010));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__30011 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__30012 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__30011,G__30012) : object_cache.call(null,G__30011,G__30012));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__30007,G__30008) : object_cache.call(null,G__30007,G__30008));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__30013 = history_id;
var G__30014 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__30013,G__30014) : object_cache.call(null,G__30013,G__30014));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__30015 = (function (coll__5339__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__5339__auto__));
});
return fexpr__30015(this__5338__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this29999,other30000){
var self__ = this;
var this29999__$1 = this;
return (((!((other30000 == null)))) && ((((this29999__$1.constructor === other30000.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29999__$1.conn,other30000.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29999__$1.config,other30000.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29999__$1.network,other30000.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29999__$1.dbid,other30000.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29999__$1.id,other30000.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29999__$1.leaf,other30000.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29999__$1.first,other30000.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29999__$1.rhs,other30000.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29999__$1.size,other30000.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29999__$1.block,other30000.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29999__$1.t,other30000.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29999__$1.tt_id,other30000.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29999__$1.leftmost_QMARK_,other30000.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29999__$1.tempid,other30000.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29999__$1.__extmap,other30000.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5353__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k29998){
var self__ = this;
var this__5349__auto____$1 = this;
var G__30016 = k29998;
var G__30016__$1 = (((G__30016 instanceof cljs.core.Keyword))?G__30016.fqn:null);
switch (G__30016__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k29998);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__29997){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__30017 = cljs.core.keyword_identical_QMARK_;
var expr__30018 = k__5351__auto__;
if(cljs.core.truth_((function (){var G__30020 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__30021 = expr__30018;
return (pred__30017.cljs$core$IFn$_invoke$arity$2 ? pred__30017.cljs$core$IFn$_invoke$arity$2(G__30020,G__30021) : pred__30017.call(null,G__30020,G__30021));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__29997,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30022 = new cljs.core.Keyword(null,"config","config",994861415);
var G__30023 = expr__30018;
return (pred__30017.cljs$core$IFn$_invoke$arity$2 ? pred__30017.cljs$core$IFn$_invoke$arity$2(G__30022,G__30023) : pred__30017.call(null,G__30022,G__30023));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__29997,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30024 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__30025 = expr__30018;
return (pred__30017.cljs$core$IFn$_invoke$arity$2 ? pred__30017.cljs$core$IFn$_invoke$arity$2(G__30024,G__30025) : pred__30017.call(null,G__30024,G__30025));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__29997,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30026 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__30027 = expr__30018;
return (pred__30017.cljs$core$IFn$_invoke$arity$2 ? pred__30017.cljs$core$IFn$_invoke$arity$2(G__30026,G__30027) : pred__30017.call(null,G__30026,G__30027));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__29997,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30028 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__30029 = expr__30018;
return (pred__30017.cljs$core$IFn$_invoke$arity$2 ? pred__30017.cljs$core$IFn$_invoke$arity$2(G__30028,G__30029) : pred__30017.call(null,G__30028,G__30029));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__29997,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30030 = new cljs.core.Keyword(null,"leaf","leaf",1306118732);
var G__30031 = expr__30018;
return (pred__30017.cljs$core$IFn$_invoke$arity$2 ? pred__30017.cljs$core$IFn$_invoke$arity$2(G__30030,G__30031) : pred__30017.call(null,G__30030,G__30031));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__29997,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30032 = new cljs.core.Keyword(null,"first","first",-644103046);
var G__30033 = expr__30018;
return (pred__30017.cljs$core$IFn$_invoke$arity$2 ? pred__30017.cljs$core$IFn$_invoke$arity$2(G__30032,G__30033) : pred__30017.call(null,G__30032,G__30033));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__29997,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30034 = new cljs.core.Keyword(null,"rhs","rhs",-229356739);
var G__30035 = expr__30018;
return (pred__30017.cljs$core$IFn$_invoke$arity$2 ? pred__30017.cljs$core$IFn$_invoke$arity$2(G__30034,G__30035) : pred__30017.call(null,G__30034,G__30035));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__29997,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30036 = new cljs.core.Keyword(null,"size","size",1098693007);
var G__30037 = expr__30018;
return (pred__30017.cljs$core$IFn$_invoke$arity$2 ? pred__30017.cljs$core$IFn$_invoke$arity$2(G__30036,G__30037) : pred__30017.call(null,G__30036,G__30037));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__29997,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30038 = new cljs.core.Keyword(null,"block","block",664686210);
var G__30039 = expr__30018;
return (pred__30017.cljs$core$IFn$_invoke$arity$2 ? pred__30017.cljs$core$IFn$_invoke$arity$2(G__30038,G__30039) : pred__30017.call(null,G__30038,G__30039));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__29997,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30040 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__30041 = expr__30018;
return (pred__30017.cljs$core$IFn$_invoke$arity$2 ? pred__30017.cljs$core$IFn$_invoke$arity$2(G__30040,G__30041) : pred__30017.call(null,G__30040,G__30041));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__29997,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30042 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__30043 = expr__30018;
return (pred__30017.cljs$core$IFn$_invoke$arity$2 ? pred__30017.cljs$core$IFn$_invoke$arity$2(G__30042,G__30043) : pred__30017.call(null,G__30042,G__30043));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__29997,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30044 = new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559);
var G__30045 = expr__30018;
return (pred__30017.cljs$core$IFn$_invoke$arity$2 ? pred__30017.cljs$core$IFn$_invoke$arity$2(G__30044,G__30045) : pred__30017.call(null,G__30044,G__30045));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__29997,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30046 = new cljs.core.Keyword(null,"tempid","tempid",1427663222);
var G__30047 = expr__30018;
return (pred__30017.cljs$core$IFn$_invoke$arity$2 ? pred__30017.cljs$core$IFn$_invoke$arity$2(G__30046,G__30047) : pred__30017.call(null,G__30046,G__30047));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__29997,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5351__auto__,G__29997),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__29997){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__29997,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write(writer__5389__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__30001){
var extmap__5384__auto__ = (function (){var G__30048 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__30001,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], 0));
if(cljs.core.record_QMARK_(G__30001)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__30048);
} else {
return G__30048;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__30001),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__30001),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__30001),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__30001),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__30001),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__30001),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__30001),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__30001),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__30001),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__30001),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__30001),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__30001),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__30001),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__30001),null,cljs.core.not_empty(extmap__5384__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__30051 = blank_db;
var map__30051__$1 = cljs.core.__destructure_map(map__30051);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30051__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30051__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30051__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__30052 = root_data;
var map__30052__$1 = cljs.core.__destructure_map(map__30052);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30052__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30052__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30052__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30052__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_30074){
var state_val_30075 = (state_30074[(1)]);
if((state_val_30075 === (7))){
var state_30074__$1 = state_30074;
var statearr_30076_30096 = state_30074__$1;
(statearr_30076_30096[(2)] = null);

(statearr_30076_30096[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30075 === (1))){
var state_30074__$1 = state_30074;
var statearr_30077_30097 = state_30074__$1;
(statearr_30077_30097[(2)] = null);

(statearr_30077_30097[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30075 === (4))){
var inst_30053 = (state_30074[(2)]);
var state_30074__$1 = state_30074;
var statearr_30078_30098 = state_30074__$1;
(statearr_30078_30098[(2)] = inst_30053);

(statearr_30078_30098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30075 === (6))){
var inst_30060 = (state_30074[(7)]);
var inst_30062 = fluree.db.storage.core.serde(conn);
var state_30074__$1 = (function (){var statearr_30079 = state_30074;
(statearr_30079[(8)] = inst_30062);

return statearr_30079;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30074__$1,(9),inst_30060);
} else {
if((state_val_30075 === (3))){
var inst_30072 = (state_30074[(2)]);
var state_30074__$1 = state_30074;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30074__$1,inst_30072);
} else {
if((state_val_30075 === (2))){
var inst_30060 = (state_30074[(7)]);
var _ = (function (){var statearr_30081 = state_30074;
(statearr_30081[(4)] = cljs.core.cons((5),(state_30074[(4)])));

return statearr_30081;
})();
var inst_30059 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_30060__$1 = fluree.db.storage.core.storage_read(conn,inst_30059);
var state_30074__$1 = (function (){var statearr_30082 = state_30074;
(statearr_30082[(7)] = inst_30060__$1);

return statearr_30082;
})();
if(cljs.core.truth_(inst_30060__$1)){
var statearr_30083_30099 = state_30074__$1;
(statearr_30083_30099[(1)] = (6));

} else {
var statearr_30084_30100 = state_30074__$1;
(statearr_30084_30100[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30075 === (9))){
var inst_30062 = (state_30074[(8)]);
var inst_30064 = (state_30074[(2)]);
var inst_30065 = fluree.db.util.async.throw_err(inst_30064);
var inst_30066 = fluree.db.serde.protocol._deserialize_garbage(inst_30062,inst_30065);
var state_30074__$1 = state_30074;
var statearr_30085_30101 = state_30074__$1;
(statearr_30085_30101[(2)] = inst_30066);

(statearr_30085_30101[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30075 === (5))){
var _ = (function (){var statearr_30086 = state_30074;
(statearr_30086[(4)] = cljs.core.rest((state_30074[(4)])));

return statearr_30086;
})();
var state_30074__$1 = state_30074;
var ex30080 = (state_30074__$1[(2)]);
var statearr_30087_30102 = state_30074__$1;
(statearr_30087_30102[(5)] = ex30080);


if((ex30080 instanceof Error)){
var statearr_30088_30103 = state_30074__$1;
(statearr_30088_30103[(1)] = (4));

(statearr_30088_30103[(5)] = null);

} else {
throw ex30080;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30075 === (8))){
var inst_30069 = (state_30074[(2)]);
var _ = (function (){var statearr_30089 = state_30074;
(statearr_30089[(4)] = cljs.core.rest((state_30074[(4)])));

return statearr_30089;
})();
var state_30074__$1 = state_30074;
var statearr_30090_30104 = state_30074__$1;
(statearr_30090_30104[(2)] = inst_30069);

(statearr_30090_30104[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__11438__auto____0 = (function (){
var statearr_30091 = [null,null,null,null,null,null,null,null,null];
(statearr_30091[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__11438__auto__);

(statearr_30091[(1)] = (1));

return statearr_30091;
});
var fluree$db$storage$core$read_garbage_$_state_machine__11438__auto____1 = (function (state_30074){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_30074);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e30092){var ex__11441__auto__ = e30092;
var statearr_30093_30105 = state_30074;
(statearr_30093_30105[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_30074[(4)]))){
var statearr_30094_30106 = state_30074;
(statearr_30094_30106[(1)] = cljs.core.first((state_30074[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30107 = state_30074;
state_30074 = G__30107;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__11438__auto__ = function(state_30074){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__11438__auto____1.call(this,state_30074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__11438__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__11438__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_30095 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_30095[(6)] = c__11512__auto__);

return statearr_30095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_30129){
var state_val_30130 = (state_30129[(1)]);
if((state_val_30130 === (7))){
var inst_30118 = (state_30129[(7)]);
var inst_30120 = fluree.db.storage.core.serde(conn);
var inst_30121 = fluree.db.serde.protocol._deserialize_db_root(inst_30120,inst_30118);
var state_30129__$1 = state_30129;
var statearr_30131_30150 = state_30129__$1;
(statearr_30131_30150[(2)] = inst_30121);

(statearr_30131_30150[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30130 === (1))){
var state_30129__$1 = state_30129;
var statearr_30132_30151 = state_30129__$1;
(statearr_30132_30151[(2)] = null);

(statearr_30132_30151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30130 === (4))){
var inst_30108 = (state_30129[(2)]);
var state_30129__$1 = state_30129;
var statearr_30133_30152 = state_30129__$1;
(statearr_30133_30152[(2)] = inst_30108);

(statearr_30133_30152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30130 === (6))){
var inst_30118 = (state_30129[(7)]);
var inst_30117 = (state_30129[(2)]);
var inst_30118__$1 = fluree.db.util.async.throw_err(inst_30117);
var state_30129__$1 = (function (){var statearr_30134 = state_30129;
(statearr_30134[(7)] = inst_30118__$1);

return statearr_30134;
})();
if(cljs.core.truth_(inst_30118__$1)){
var statearr_30135_30153 = state_30129__$1;
(statearr_30135_30153[(1)] = (7));

} else {
var statearr_30136_30154 = state_30129__$1;
(statearr_30136_30154[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30130 === (3))){
var inst_30127 = (state_30129[(2)]);
var state_30129__$1 = state_30129;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30129__$1,inst_30127);
} else {
if((state_val_30130 === (2))){
var _ = (function (){var statearr_30138 = state_30129;
(statearr_30138[(4)] = cljs.core.cons((5),(state_30129[(4)])));

return statearr_30138;
})();
var inst_30114 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_30115 = fluree.db.storage.core.storage_read(conn,inst_30114);
var state_30129__$1 = state_30129;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30129__$1,(6),inst_30115);
} else {
if((state_val_30130 === (9))){
var inst_30124 = (state_30129[(2)]);
var _ = (function (){var statearr_30139 = state_30129;
(statearr_30139[(4)] = cljs.core.rest((state_30129[(4)])));

return statearr_30139;
})();
var state_30129__$1 = state_30129;
var statearr_30140_30155 = state_30129__$1;
(statearr_30140_30155[(2)] = inst_30124);

(statearr_30140_30155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30130 === (5))){
var _ = (function (){var statearr_30141 = state_30129;
(statearr_30141[(4)] = cljs.core.rest((state_30129[(4)])));

return statearr_30141;
})();
var state_30129__$1 = state_30129;
var ex30137 = (state_30129__$1[(2)]);
var statearr_30142_30156 = state_30129__$1;
(statearr_30142_30156[(5)] = ex30137);


if((ex30137 instanceof Error)){
var statearr_30143_30157 = state_30129__$1;
(statearr_30143_30157[(1)] = (4));

(statearr_30143_30157[(5)] = null);

} else {
throw ex30137;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30130 === (8))){
var state_30129__$1 = state_30129;
var statearr_30144_30158 = state_30129__$1;
(statearr_30144_30158[(2)] = null);

(statearr_30144_30158[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__11438__auto____0 = (function (){
var statearr_30145 = [null,null,null,null,null,null,null,null];
(statearr_30145[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__11438__auto__);

(statearr_30145[(1)] = (1));

return statearr_30145;
});
var fluree$db$storage$core$read_db_root_$_state_machine__11438__auto____1 = (function (state_30129){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_30129);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e30146){var ex__11441__auto__ = e30146;
var statearr_30147_30159 = state_30129;
(statearr_30147_30159[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_30129[(4)]))){
var statearr_30148_30160 = state_30129;
(statearr_30148_30160[(1)] = cljs.core.first((state_30129[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30161 = state_30129;
state_30129 = G__30161;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__11438__auto__ = function(state_30129){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__11438__auto____1.call(this,state_30129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__11438__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__11438__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_30149 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_30149[(6)] = c__11512__auto__);

return statearr_30149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_30197){
var state_val_30198 = (state_30197[(1)]);
if((state_val_30198 === (7))){
var inst_30171 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_30172 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30173 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_30174 = cljs.core.PersistentHashMap.fromArrays(inst_30172,inst_30173);
var inst_30175 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30171,inst_30174);
var inst_30176 = (function(){throw inst_30175})();
var state_30197__$1 = state_30197;
var statearr_30199_30221 = state_30197__$1;
(statearr_30199_30221[(2)] = inst_30176);

(statearr_30199_30221[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30198 === (1))){
var state_30197__$1 = state_30197;
var statearr_30200_30222 = state_30197__$1;
(statearr_30200_30222[(2)] = null);

(statearr_30200_30222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30198 === (4))){
var inst_30162 = (state_30197[(2)]);
var state_30197__$1 = state_30197;
var statearr_30201_30223 = state_30197__$1;
(statearr_30201_30223[(2)] = inst_30162);

(statearr_30201_30223[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30198 === (6))){
var state_30197__$1 = state_30197;
var statearr_30202_30224 = state_30197__$1;
(statearr_30202_30224[(2)] = null);

(statearr_30202_30224[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30198 === (3))){
var inst_30195 = (state_30197[(2)]);
var state_30197__$1 = state_30197;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30197__$1,inst_30195);
} else {
if((state_val_30198 === (2))){
var inst_30168 = (state_30197[(7)]);
var _ = (function (){var statearr_30203 = state_30197;
(statearr_30203[(4)] = cljs.core.cons((5),(state_30197[(4)])));

return statearr_30203;
})();
var inst_30168__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_30197__$1 = (function (){var statearr_30204 = state_30197;
(statearr_30204[(7)] = inst_30168__$1);

return statearr_30204;
})();
if(cljs.core.truth_(inst_30168__$1)){
var statearr_30205_30225 = state_30197__$1;
(statearr_30205_30225[(1)] = (6));

} else {
var statearr_30206_30226 = state_30197__$1;
(statearr_30206_30226[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30198 === (11))){
var inst_30187 = (state_30197[(8)]);
var inst_30190 = (state_30197[(2)]);
var inst_30191 = fluree.db.util.async.throw_err(inst_30190);
var inst_30192 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_30187,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_30191);
var _ = (function (){var statearr_30208 = state_30197;
(statearr_30208[(4)] = cljs.core.rest((state_30197[(4)])));

return statearr_30208;
})();
var state_30197__$1 = state_30197;
var statearr_30209_30227 = state_30197__$1;
(statearr_30209_30227[(2)] = inst_30192);

(statearr_30209_30227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30198 === (9))){
var inst_30182 = (state_30197[(9)]);
var inst_30180 = (state_30197[(2)]);
var inst_30181 = fluree.db.util.async.throw_err(inst_30180);
var inst_30182__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_30181);
var inst_30183 = fluree.db.query.schema.schema_map(inst_30182__$1);
var state_30197__$1 = (function (){var statearr_30210 = state_30197;
(statearr_30210[(9)] = inst_30182__$1);

return statearr_30210;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30197__$1,(10),inst_30183);
} else {
if((state_val_30198 === (5))){
var _ = (function (){var statearr_30211 = state_30197;
(statearr_30211[(4)] = cljs.core.rest((state_30197[(4)])));

return statearr_30211;
})();
var state_30197__$1 = state_30197;
var ex30207 = (state_30197__$1[(2)]);
var statearr_30212_30228 = state_30197__$1;
(statearr_30212_30228[(5)] = ex30207);


if((ex30207 instanceof Error)){
var statearr_30213_30229 = state_30197__$1;
(statearr_30213_30229[(1)] = (4));

(statearr_30213_30229[(5)] = null);

} else {
throw ex30207;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30198 === (10))){
var inst_30187 = (state_30197[(8)]);
var inst_30182 = (state_30197[(9)]);
var inst_30185 = (state_30197[(2)]);
var inst_30186 = fluree.db.util.async.throw_err(inst_30185);
var inst_30187__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_30182,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_30186);
var inst_30188 = fluree.db.query.schema.setting_map(inst_30187__$1);
var state_30197__$1 = (function (){var statearr_30214 = state_30197;
(statearr_30214[(8)] = inst_30187__$1);

return statearr_30214;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30197__$1,(11),inst_30188);
} else {
if((state_val_30198 === (8))){
var inst_30168 = (state_30197[(7)]);
var inst_30178 = (state_30197[(2)]);
var state_30197__$1 = (function (){var statearr_30215 = state_30197;
(statearr_30215[(10)] = inst_30178);

return statearr_30215;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30197__$1,(9),inst_30168);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__11438__auto____0 = (function (){
var statearr_30216 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30216[(0)] = fluree$db$storage$core$reify_db_$_state_machine__11438__auto__);

(statearr_30216[(1)] = (1));

return statearr_30216;
});
var fluree$db$storage$core$reify_db_$_state_machine__11438__auto____1 = (function (state_30197){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_30197);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e30217){var ex__11441__auto__ = e30217;
var statearr_30218_30230 = state_30197;
(statearr_30218_30230[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_30197[(4)]))){
var statearr_30219_30231 = state_30197;
(statearr_30219_30231[(1)] = cljs.core.first((state_30197[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30232 = state_30197;
state_30197 = G__30232;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__11438__auto__ = function(state_30197){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__11438__auto____1.call(this,state_30197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__11438__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__11438__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_30220 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_30220[(6)] = c__11512__auto__);

return statearr_30220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__30234 = arguments.length;
switch (G__30234) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_30287){
var state_val_30288 = (state_30287[(1)]);
if((state_val_30288 === (7))){
var inst_30244 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_30245 = (new Error(inst_30244));
var inst_30246 = (function(){throw inst_30245})();
var state_30287__$1 = state_30287;
var statearr_30289_30329 = state_30287__$1;
(statearr_30289_30329[(2)] = inst_30246);

(statearr_30289_30329[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (20))){
var inst_30278 = (state_30287[(2)]);
var state_30287__$1 = state_30287;
var statearr_30290_30330 = state_30287__$1;
(statearr_30290_30330[(2)] = inst_30278);

(statearr_30290_30330[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (1))){
var state_30287__$1 = state_30287;
var statearr_30291_30331 = state_30287__$1;
(statearr_30291_30331[(2)] = null);

(statearr_30291_30331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (4))){
var inst_30235 = (state_30287[(2)]);
var state_30287__$1 = state_30287;
var statearr_30292_30332 = state_30287__$1;
(statearr_30292_30332[(2)] = inst_30235);

(statearr_30292_30332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (15))){
var inst_30253 = (state_30287[(7)]);
var state_30287__$1 = state_30287;
var statearr_30293_30333 = state_30287__$1;
(statearr_30293_30333[(2)] = inst_30253);

(statearr_30293_30333[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (21))){
var inst_30253 = (state_30287[(7)]);
var inst_30252 = (state_30287[(8)]);
var inst_30257 = (state_30287[(9)]);
var inst_30271 = (inst_30252 + (1));
var inst_30272 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_30253,inst_30257);
var inst_30252__$1 = inst_30271;
var inst_30253__$1 = inst_30272;
var state_30287__$1 = (function (){var statearr_30294 = state_30287;
(statearr_30294[(7)] = inst_30253__$1);

(statearr_30294[(8)] = inst_30252__$1);

return statearr_30294;
})();
var statearr_30295_30334 = state_30287__$1;
(statearr_30295_30334[(2)] = null);

(statearr_30295_30334[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (13))){
var inst_30257 = (state_30287[(9)]);
var inst_30261 = (inst_30257 instanceof Error);
var state_30287__$1 = state_30287;
var statearr_30296_30335 = state_30287__$1;
(statearr_30296_30335[(2)] = inst_30261);

(statearr_30296_30335[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (22))){
var state_30287__$1 = state_30287;
var statearr_30297_30336 = state_30287__$1;
(statearr_30297_30336[(2)] = null);

(statearr_30297_30336[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (6))){
var state_30287__$1 = state_30287;
var statearr_30298_30337 = state_30287__$1;
(statearr_30298_30337[(2)] = null);

(statearr_30298_30337[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (17))){
var inst_30280 = (state_30287[(2)]);
var state_30287__$1 = state_30287;
var statearr_30299_30338 = state_30287__$1;
(statearr_30299_30338[(2)] = inst_30280);

(statearr_30299_30338[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (3))){
var inst_30285 = (state_30287[(2)]);
var state_30287__$1 = state_30287;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30287__$1,inst_30285);
} else {
if((state_val_30288 === (12))){
var inst_30258 = (state_30287[(10)]);
var state_30287__$1 = state_30287;
var statearr_30300_30339 = state_30287__$1;
(statearr_30300_30339[(2)] = inst_30258);

(statearr_30300_30339[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (2))){
var _ = (function (){var statearr_30301 = state_30287;
(statearr_30301[(4)] = cljs.core.cons((5),(state_30287[(4)])));

return statearr_30301;
})();
var inst_30241 = (end >= start);
var state_30287__$1 = state_30287;
if(cljs.core.truth_(inst_30241)){
var statearr_30302_30340 = state_30287__$1;
(statearr_30302_30340[(1)] = (6));

} else {
var statearr_30303_30341 = state_30287__$1;
(statearr_30303_30341[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (23))){
var inst_30276 = (state_30287[(2)]);
var state_30287__$1 = state_30287;
var statearr_30304_30342 = state_30287__$1;
(statearr_30304_30342[(2)] = inst_30276);

(statearr_30304_30342[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (19))){
var state_30287__$1 = state_30287;
var statearr_30305_30343 = state_30287__$1;
(statearr_30305_30343[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (11))){
var inst_30258 = (state_30287[(10)]);
var inst_30257 = (state_30287[(9)]);
var inst_30257__$1 = (state_30287[(2)]);
var inst_30258__$1 = (inst_30257__$1 == null);
var state_30287__$1 = (function (){var statearr_30308 = state_30287;
(statearr_30308[(10)] = inst_30258__$1);

(statearr_30308[(9)] = inst_30257__$1);

return statearr_30308;
})();
if(cljs.core.truth_(inst_30258__$1)){
var statearr_30309_30344 = state_30287__$1;
(statearr_30309_30344[(1)] = (12));

} else {
var statearr_30310_30345 = state_30287__$1;
(statearr_30310_30345[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (9))){
var inst_30252 = (state_30287[(8)]);
var inst_30255 = fluree.db.storage.core.read_block(conn,network,dbid,inst_30252);
var state_30287__$1 = state_30287;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30287__$1,(11),inst_30255);
} else {
if((state_val_30288 === (5))){
var _ = (function (){var statearr_30311 = state_30287;
(statearr_30311[(4)] = cljs.core.rest((state_30287[(4)])));

return statearr_30311;
})();
var state_30287__$1 = state_30287;
var ex30307 = (state_30287__$1[(2)]);
var statearr_30312_30346 = state_30287__$1;
(statearr_30312_30346[(5)] = ex30307);


if((ex30307 instanceof Error)){
var statearr_30313_30347 = state_30287__$1;
(statearr_30313_30347[(1)] = (4));

(statearr_30313_30347[(5)] = null);

} else {
throw ex30307;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (14))){
var inst_30263 = (state_30287[(2)]);
var state_30287__$1 = state_30287;
if(cljs.core.truth_(inst_30263)){
var statearr_30314_30348 = state_30287__$1;
(statearr_30314_30348[(1)] = (15));

} else {
var statearr_30315_30349 = state_30287__$1;
(statearr_30315_30349[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (16))){
var inst_30252 = (state_30287[(8)]);
var inst_30266 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30252,end);
var state_30287__$1 = state_30287;
if(inst_30266){
var statearr_30316_30350 = state_30287__$1;
(statearr_30316_30350[(1)] = (18));

} else {
var statearr_30317_30351 = state_30287__$1;
(statearr_30317_30351[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (10))){
var inst_30282 = (state_30287[(2)]);
var _ = (function (){var statearr_30318 = state_30287;
(statearr_30318[(4)] = cljs.core.rest((state_30287[(4)])));

return statearr_30318;
})();
var state_30287__$1 = state_30287;
var statearr_30319_30352 = state_30287__$1;
(statearr_30319_30352[(2)] = inst_30282);

(statearr_30319_30352[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (18))){
var inst_30253 = (state_30287[(7)]);
var inst_30257 = (state_30287[(9)]);
var inst_30268 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_30253,inst_30257);
var state_30287__$1 = state_30287;
var statearr_30320_30353 = state_30287__$1;
(statearr_30320_30353[(2)] = inst_30268);

(statearr_30320_30353[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30288 === (8))){
var inst_30248 = (state_30287[(2)]);
var inst_30249 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_30250 = start;
var inst_30251 = cljs.core.PersistentVector.EMPTY;
var inst_30252 = inst_30250;
var inst_30253 = inst_30251;
var state_30287__$1 = (function (){var statearr_30321 = state_30287;
(statearr_30321[(7)] = inst_30253);

(statearr_30321[(11)] = inst_30249);

(statearr_30321[(8)] = inst_30252);

(statearr_30321[(12)] = inst_30248);

return statearr_30321;
})();
var statearr_30322_30354 = state_30287__$1;
(statearr_30322_30354[(2)] = null);

(statearr_30322_30354[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__11438__auto__ = null;
var fluree$db$storage$core$state_machine__11438__auto____0 = (function (){
var statearr_30323 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30323[(0)] = fluree$db$storage$core$state_machine__11438__auto__);

(statearr_30323[(1)] = (1));

return statearr_30323;
});
var fluree$db$storage$core$state_machine__11438__auto____1 = (function (state_30287){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_30287);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e30324){var ex__11441__auto__ = e30324;
var statearr_30325_30355 = state_30287;
(statearr_30325_30355[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_30287[(4)]))){
var statearr_30326_30356 = state_30287;
(statearr_30326_30356[(1)] = cljs.core.first((state_30287[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30357 = state_30287;
state_30287 = G__30357;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__11438__auto__ = function(state_30287){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__11438__auto____1.call(this,state_30287);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__11438__auto____0;
fluree$db$storage$core$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__11438__auto____1;
return fluree$db$storage$core$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_30327 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_30327[(6)] = c__11512__auto__);

return statearr_30327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_30373){
var state_val_30374 = (state_30373[(1)]);
if((state_val_30374 === (1))){
var state_30373__$1 = state_30373;
var statearr_30375_30389 = state_30373__$1;
(statearr_30375_30389[(2)] = null);

(statearr_30375_30389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30374 === (2))){
var _ = (function (){var statearr_30376 = state_30373;
(statearr_30376[(4)] = cljs.core.cons((5),(state_30373[(4)])));

return statearr_30376;
})();
var inst_30364 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_30373__$1 = state_30373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30373__$1,(6),inst_30364);
} else {
if((state_val_30374 === (3))){
var inst_30371 = (state_30373[(2)]);
var state_30373__$1 = state_30373;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30373__$1,inst_30371);
} else {
if((state_val_30374 === (4))){
var inst_30358 = (state_30373[(2)]);
var state_30373__$1 = state_30373;
var statearr_30378_30390 = state_30373__$1;
(statearr_30378_30390[(2)] = inst_30358);

(statearr_30378_30390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30374 === (5))){
var _ = (function (){var statearr_30379 = state_30373;
(statearr_30379[(4)] = cljs.core.rest((state_30373[(4)])));

return statearr_30379;
})();
var state_30373__$1 = state_30373;
var ex30377 = (state_30373__$1[(2)]);
var statearr_30380_30391 = state_30373__$1;
(statearr_30380_30391[(5)] = ex30377);


if((ex30377 instanceof Error)){
var statearr_30381_30392 = state_30373__$1;
(statearr_30381_30392[(1)] = (4));

(statearr_30381_30392[(5)] = null);

} else {
throw ex30377;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30374 === (6))){
var inst_30366 = (state_30373[(2)]);
var inst_30367 = fluree.db.util.async.throw_err(inst_30366);
var inst_30368 = cljs.core.first(inst_30367);
var _ = (function (){var statearr_30382 = state_30373;
(statearr_30382[(4)] = cljs.core.rest((state_30373[(4)])));

return statearr_30382;
})();
var state_30373__$1 = state_30373;
var statearr_30383_30393 = state_30373__$1;
(statearr_30383_30393[(2)] = inst_30368);

(statearr_30383_30393[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__11438__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__11438__auto____0 = (function (){
var statearr_30384 = [null,null,null,null,null,null,null];
(statearr_30384[(0)] = fluree$db$storage$core$block_$_state_machine__11438__auto__);

(statearr_30384[(1)] = (1));

return statearr_30384;
});
var fluree$db$storage$core$block_$_state_machine__11438__auto____1 = (function (state_30373){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_30373);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e30385){var ex__11441__auto__ = e30385;
var statearr_30386_30394 = state_30373;
(statearr_30386_30394[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_30373[(4)]))){
var statearr_30387_30395 = state_30373;
(statearr_30387_30395[(1)] = cljs.core.first((state_30373[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30396 = state_30373;
state_30373 = G__30396;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__11438__auto__ = function(state_30373){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__11438__auto____1.call(this,state_30373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__11438__auto____0;
fluree$db$storage$core$block_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__11438__auto____1;
return fluree$db$storage$core$block_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_30388 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_30388[(6)] = c__11512__auto__);

return statearr_30388;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
