// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__5045__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_22838){
var state_val_22839 = (state_22838[(1)]);
if((state_val_22839 === (7))){
var inst_22833 = (state_22838[(2)]);
var _ = (function (){var statearr_22840 = state_22838;
(statearr_22840[(4)] = cljs.core.rest((state_22838[(4)])));

return statearr_22840;
})();
var state_22838__$1 = state_22838;
var statearr_22841_22863 = state_22838__$1;
(statearr_22841_22863[(2)] = inst_22833);

(statearr_22841_22863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22839 === (1))){
var state_22838__$1 = state_22838;
var statearr_22842_22864 = state_22838__$1;
(statearr_22842_22864[(2)] = null);

(statearr_22842_22864[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22839 === (4))){
var inst_22795 = (state_22838[(2)]);
var state_22838__$1 = state_22838;
var statearr_22843_22865 = state_22838__$1;
(statearr_22843_22865[(2)] = inst_22795);

(statearr_22843_22865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22839 === (6))){
var inst_22813 = (state_22838[(7)]);
var inst_22820 = (state_22838[(8)]);
var inst_22819 = cljs.core.seq(inst_22813);
var inst_22820__$1 = cljs.core.first(inst_22819);
var inst_22821 = cljs.core.next(inst_22819);
var inst_22822 = cljs.core.not(inst_22820__$1);
var state_22838__$1 = (function (){var statearr_22844 = state_22838;
(statearr_22844[(9)] = inst_22821);

(statearr_22844[(8)] = inst_22820__$1);

return statearr_22844;
})();
if(inst_22822){
var statearr_22845_22866 = state_22838__$1;
(statearr_22845_22866[(1)] = (8));

} else {
var statearr_22846_22867 = state_22838__$1;
(statearr_22846_22867[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22839 === (3))){
var inst_22836 = (state_22838[(2)]);
var state_22838__$1 = state_22838;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22838__$1,inst_22836);
} else {
if((state_val_22839 === (2))){
var _ = (function (){var statearr_22847 = state_22838;
(statearr_22847[(4)] = cljs.core.cons((5),(state_22838[(4)])));

return statearr_22847;
})();
var inst_22808 = chs;
var inst_22809 = cljs.core.seq(inst_22808);
var inst_22810 = cljs.core.first(inst_22809);
var inst_22811 = cljs.core.next(inst_22809);
var inst_22812 = coll;
var inst_22813 = inst_22808;
var inst_22814 = inst_22812;
var state_22838__$1 = (function (){var statearr_22848 = state_22838;
(statearr_22848[(7)] = inst_22813);

(statearr_22848[(10)] = inst_22814);

(statearr_22848[(11)] = inst_22811);

(statearr_22848[(12)] = inst_22810);

return statearr_22848;
})();
var statearr_22849_22868 = state_22838__$1;
(statearr_22849_22868[(2)] = null);

(statearr_22849_22868[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22839 === (11))){
var inst_22814 = (state_22838[(10)]);
var inst_22821 = (state_22838[(9)]);
var inst_22826 = (state_22838[(2)]);
var inst_22827 = fluree.db.util.async.throw_err(inst_22826);
var inst_22828 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22814,inst_22827);
var inst_22813 = inst_22821;
var inst_22814__$1 = inst_22828;
var state_22838__$1 = (function (){var statearr_22851 = state_22838;
(statearr_22851[(7)] = inst_22813);

(statearr_22851[(10)] = inst_22814__$1);

return statearr_22851;
})();
var statearr_22852_22869 = state_22838__$1;
(statearr_22852_22869[(2)] = null);

(statearr_22852_22869[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22839 === (9))){
var inst_22820 = (state_22838[(8)]);
var state_22838__$1 = state_22838;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22838__$1,(11),inst_22820);
} else {
if((state_val_22839 === (5))){
var _ = (function (){var statearr_22853 = state_22838;
(statearr_22853[(4)] = cljs.core.rest((state_22838[(4)])));

return statearr_22853;
})();
var state_22838__$1 = state_22838;
var ex22850 = (state_22838__$1[(2)]);
var statearr_22854_22870 = state_22838__$1;
(statearr_22854_22870[(5)] = ex22850);


var statearr_22855_22871 = state_22838__$1;
(statearr_22855_22871[(1)] = (4));

(statearr_22855_22871[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22839 === (10))){
var inst_22831 = (state_22838[(2)]);
var state_22838__$1 = state_22838;
var statearr_22856_22872 = state_22838__$1;
(statearr_22856_22872[(2)] = inst_22831);

(statearr_22856_22872[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22839 === (8))){
var inst_22814 = (state_22838[(10)]);
var state_22838__$1 = state_22838;
var statearr_22857_22873 = state_22838__$1;
(statearr_22857_22873[(2)] = inst_22814);

(statearr_22857_22873[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__11438__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__11438__auto____0 = (function (){
var statearr_22858 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22858[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__11438__auto__);

(statearr_22858[(1)] = (1));

return statearr_22858;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__11438__auto____1 = (function (state_22838){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_22838);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e22859){var ex__11441__auto__ = e22859;
var statearr_22860_22874 = state_22838;
(statearr_22860_22874[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_22838[(4)]))){
var statearr_22861_22875 = state_22838;
(statearr_22861_22875[(1)] = cljs.core.first((state_22838[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22876 = state_22838;
state_22838 = G__22876;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__11438__auto__ = function(state_22838){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__11438__auto____1.call(this,state_22838);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__11438__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__11438__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_22862 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_22862[(6)] = c__11512__auto__);

return statearr_22862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_22902){
var state_val_22903 = (state_22902[(1)]);
if((state_val_22903 === (7))){
var inst_22897 = (state_22902[(2)]);
var _ = (function (){var statearr_22904 = state_22902;
(statearr_22904[(4)] = cljs.core.rest((state_22902[(4)])));

return statearr_22904;
})();
var state_22902__$1 = state_22902;
var statearr_22905_22927 = state_22902__$1;
(statearr_22905_22927[(2)] = inst_22897);

(statearr_22905_22927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22903 === (1))){
var state_22902__$1 = state_22902;
var statearr_22906_22928 = state_22902__$1;
(statearr_22906_22928[(2)] = null);

(statearr_22906_22928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22903 === (4))){
var inst_22877 = (state_22902[(2)]);
var state_22902__$1 = state_22902;
var statearr_22907_22929 = state_22902__$1;
(statearr_22907_22929[(2)] = inst_22877);

(statearr_22907_22929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22903 === (6))){
var state_22902__$1 = state_22902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22902__$1,(8),chan);
} else {
if((state_val_22903 === (3))){
var inst_22900 = (state_22902[(2)]);
var state_22902__$1 = state_22902;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22902__$1,inst_22900);
} else {
if((state_val_22903 === (2))){
var _ = (function (){var statearr_22908 = state_22902;
(statearr_22908[(4)] = cljs.core.cons((5),(state_22902[(4)])));

return statearr_22908;
})();
var inst_22883 = coll;
var inst_22884 = inst_22883;
var state_22902__$1 = (function (){var statearr_22909 = state_22902;
(statearr_22909[(7)] = inst_22884);

return statearr_22909;
})();
var statearr_22910_22930 = state_22902__$1;
(statearr_22910_22930[(2)] = null);

(statearr_22910_22930[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22903 === (11))){
var inst_22895 = (state_22902[(2)]);
var state_22902__$1 = state_22902;
var statearr_22912_22931 = state_22902__$1;
(statearr_22912_22931[(2)] = inst_22895);

(statearr_22912_22931[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22903 === (9))){
var inst_22884 = (state_22902[(7)]);
var state_22902__$1 = state_22902;
var statearr_22913_22932 = state_22902__$1;
(statearr_22913_22932[(2)] = inst_22884);

(statearr_22913_22932[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22903 === (5))){
var _ = (function (){var statearr_22914 = state_22902;
(statearr_22914[(4)] = cljs.core.rest((state_22902[(4)])));

return statearr_22914;
})();
var state_22902__$1 = state_22902;
var ex22911 = (state_22902__$1[(2)]);
var statearr_22915_22933 = state_22902__$1;
(statearr_22915_22933[(5)] = ex22911);


var statearr_22916_22934 = state_22902__$1;
(statearr_22916_22934[(1)] = (4));

(statearr_22916_22934[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22903 === (10))){
var inst_22884 = (state_22902[(7)]);
var inst_22888 = (state_22902[(8)]);
var inst_22892 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22884,inst_22888);
var inst_22884__$1 = inst_22892;
var state_22902__$1 = (function (){var statearr_22917 = state_22902;
(statearr_22917[(7)] = inst_22884__$1);

return statearr_22917;
})();
var statearr_22918_22935 = state_22902__$1;
(statearr_22918_22935[(2)] = null);

(statearr_22918_22935[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22903 === (8))){
var inst_22888 = (state_22902[(8)]);
var inst_22887 = (state_22902[(2)]);
var inst_22888__$1 = fluree.db.util.async.throw_err(inst_22887);
var inst_22889 = (inst_22888__$1 == null);
var state_22902__$1 = (function (){var statearr_22919 = state_22902;
(statearr_22919[(8)] = inst_22888__$1);

return statearr_22919;
})();
if(cljs.core.truth_(inst_22889)){
var statearr_22920_22936 = state_22902__$1;
(statearr_22920_22936[(1)] = (9));

} else {
var statearr_22921_22937 = state_22902__$1;
(statearr_22921_22937[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__11438__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__11438__auto____0 = (function (){
var statearr_22922 = [null,null,null,null,null,null,null,null,null];
(statearr_22922[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__11438__auto__);

(statearr_22922[(1)] = (1));

return statearr_22922;
});
var fluree$db$util$async$into_QMARK__$_state_machine__11438__auto____1 = (function (state_22902){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_22902);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e22923){var ex__11441__auto__ = e22923;
var statearr_22924_22938 = state_22902;
(statearr_22924_22938[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_22902[(4)]))){
var statearr_22925_22939 = state_22902;
(statearr_22925_22939[(1)] = cljs.core.first((state_22902[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22940 = state_22902;
state_22902 = G__22940;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__11438__auto__ = function(state_22902){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__11438__auto____1.call(this,state_22902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__11438__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__11438__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_22926 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_22926[(6)] = c__11512__auto__);

return statearr_22926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
