// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5804__auto__ = e.response;
if(cljs.core.truth_(temp__5804__auto__)){
var resp = temp__5804__auto__;
var temp__5804__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5804__auto____$1)){
var st = temp__5804__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_(e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status >= (500));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["XHTTP Request Error:",e.request], 0));

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status > (0));
} else {
return and__5043__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__31433 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__31433,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__31433;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__31434 = opts;
var map__31434__$1 = cljs.core.__destructure_map(map__31434);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31434__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31434__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31434__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__31435 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__31435__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__31435,headers], 0)):G__31435);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__31435__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__31435__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0))));
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__31436 = opts;
var map__31436__$1 = cljs.core.__destructure_map(map__31436);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31436__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31436__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31436__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31436__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31436__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__31437 = cljs.core.PersistentArrayMap.EMPTY;
var G__31437__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__31437,headers], 0)):G__31437);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__31437__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__31437__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__31438 = output_format;
var G__31438__$1 = (((G__31438 instanceof cljs.core.Keyword))?G__31438.fqn:null);
switch (G__31438__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify(data);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__31440 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__31440,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__31440;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_31472){
var state_val_31473 = (state_31472[(1)]);
if((state_val_31473 === (7))){
var inst_31468 = (state_31472[(2)]);
var state_31472__$1 = state_31472;
var statearr_31474_31499 = state_31472__$1;
(statearr_31474_31499[(2)] = inst_31468);

(statearr_31474_31499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31473 === (1))){
var state_31472__$1 = state_31472;
var statearr_31475_31500 = state_31472__$1;
(statearr_31475_31500[(2)] = null);

(statearr_31475_31500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31473 === (4))){
var inst_31443 = (state_31472[(7)]);
var inst_31443__$1 = (state_31472[(2)]);
var inst_31444 = (inst_31443__$1 == null);
var state_31472__$1 = (function (){var statearr_31476 = state_31472;
(statearr_31476[(7)] = inst_31443__$1);

return statearr_31476;
})();
if(cljs.core.truth_(inst_31444)){
var statearr_31477_31501 = state_31472__$1;
(statearr_31477_31501[(1)] = (5));

} else {
var statearr_31478_31502 = state_31472__$1;
(statearr_31478_31502[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31473 === (6))){
var inst_31443 = (state_31472[(7)]);
var inst_31451 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31443,(0),null);
var inst_31452 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31443,(1),null);
var state_31472__$1 = (function (){var statearr_31479 = state_31472;
(statearr_31479[(8)] = inst_31451);

(statearr_31479[(9)] = inst_31452);

return statearr_31479;
})();
var statearr_31480_31503 = state_31472__$1;
(statearr_31480_31503[(2)] = null);

(statearr_31480_31503[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31473 === (3))){
var inst_31470 = (state_31472[(2)]);
var state_31472__$1 = state_31472;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31472__$1,inst_31470);
} else {
if((state_val_31473 === (2))){
var state_31472__$1 = state_31472;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31472__$1,(4),pub_chan);
} else {
if((state_val_31473 === (11))){
var _ = (function (){var statearr_31482 = state_31472;
(statearr_31482[(4)] = cljs.core.rest((state_31472[(4)])));

return statearr_31482;
})();
var state_31472__$1 = state_31472;
var ex31481 = (state_31472__$1[(2)]);
var statearr_31483_31504 = state_31472__$1;
(statearr_31483_31504[(5)] = ex31481);


var statearr_31484_31505 = state_31472__$1;
(statearr_31484_31505[(1)] = (10));

(statearr_31484_31505[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31473 === (9))){
var inst_31465 = (state_31472[(2)]);
var state_31472__$1 = (function (){var statearr_31485 = state_31472;
(statearr_31485[(10)] = inst_31465);

return statearr_31485;
})();
var statearr_31486_31506 = state_31472__$1;
(statearr_31486_31506[(2)] = null);

(statearr_31486_31506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31473 === (5))){
var inst_31446 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_31472__$1 = state_31472;
var statearr_31487_31507 = state_31472__$1;
(statearr_31487_31507[(2)] = inst_31446);

(statearr_31487_31507[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31473 === (10))){
var inst_31451 = (state_31472[(8)]);
var inst_31452 = (state_31472[(9)]);
var inst_31453 = (state_31472[(2)]);
var inst_31454 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_31453,"Error sending websocket message:",inst_31451], 0));
var inst_31455 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_31452,false);
var state_31472__$1 = (function (){var statearr_31488 = state_31472;
(statearr_31488[(11)] = inst_31454);

return statearr_31488;
})();
var statearr_31489_31508 = state_31472__$1;
(statearr_31489_31508[(2)] = inst_31455);

(statearr_31489_31508[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31473 === (8))){
var inst_31451 = (state_31472[(8)]);
var inst_31452 = (state_31472[(9)]);
var _ = (function (){var statearr_31490 = state_31472;
(statearr_31490[(4)] = cljs.core.cons((11),(state_31472[(4)])));

return statearr_31490;
})();
var inst_31461 = ws.send(inst_31451);
var inst_31462 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_31452,true);
var ___$1 = (function (){var statearr_31491 = state_31472;
(statearr_31491[(4)] = cljs.core.rest((state_31472[(4)])));

return statearr_31491;
})();
var state_31472__$1 = (function (){var statearr_31492 = state_31472;
(statearr_31492[(12)] = inst_31461);

return statearr_31492;
})();
var statearr_31493_31509 = state_31472__$1;
(statearr_31493_31509[(2)] = inst_31462);

(statearr_31493_31509[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11438__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11438__auto____0 = (function (){
var statearr_31494 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31494[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11438__auto__);

(statearr_31494[(1)] = (1));

return statearr_31494;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11438__auto____1 = (function (state_31472){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_31472);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e31495){var ex__11441__auto__ = e31495;
var statearr_31496_31510 = state_31472;
(statearr_31496_31510[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_31472[(4)]))){
var statearr_31497_31511 = state_31472;
(statearr_31497_31511[(1)] = cljs.core.first((state_31472[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31512 = state_31472;
state_31472 = G__31512;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11438__auto__ = function(state_31472){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11438__auto____1.call(this,state_31472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11438__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11438__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_31498 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_31498[(6)] = c__11512__auto__);

return statearr_31498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__11512__auto___31550 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_31537){
var state_val_31538 = (state_31537[(1)]);
if((state_val_31538 === (1))){
var inst_31516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31517 = [open_QMARK_,timeout_chan];
var inst_31518 = (new cljs.core.PersistentVector(null,2,(5),inst_31516,inst_31517,null));
var state_31537__$1 = state_31537;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_31537__$1,(2),inst_31518,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"priority","priority",1431093715),true], 0));
} else {
if((state_val_31538 === (2))){
var inst_31520 = (state_31537[(2)]);
var inst_31521 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31520,(0),null);
var inst_31522 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31520,(1),null);
var inst_31523 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31522,timeout_chan);
var state_31537__$1 = (function (){var statearr_31539 = state_31537;
(statearr_31539[(7)] = inst_31521);

return statearr_31539;
})();
if(inst_31523){
var statearr_31540_31551 = state_31537__$1;
(statearr_31540_31551[(1)] = (3));

} else {
var statearr_31541_31552 = state_31537__$1;
(statearr_31541_31552[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31538 === (3))){
var inst_31525 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_31526 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31527 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_31528 = cljs.core.PersistentHashMap.fromArrays(inst_31526,inst_31527);
var inst_31529 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31525,inst_31528);
var inst_31530 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_31529);
var inst_31531 = fluree.db.util.xhttp.close_websocket(ws);
var state_31537__$1 = (function (){var statearr_31542 = state_31537;
(statearr_31542[(8)] = inst_31530);

return statearr_31542;
})();
var statearr_31543_31553 = state_31537__$1;
(statearr_31543_31553[(2)] = inst_31531);

(statearr_31543_31553[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31538 === (4))){
var inst_31533 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_31537__$1 = state_31537;
var statearr_31544_31554 = state_31537__$1;
(statearr_31544_31554[(2)] = inst_31533);

(statearr_31544_31554[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31538 === (5))){
var inst_31535 = (state_31537[(2)]);
var state_31537__$1 = state_31537;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31537__$1,inst_31535);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__11438__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__11438__auto____0 = (function (){
var statearr_31545 = [null,null,null,null,null,null,null,null,null];
(statearr_31545[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__11438__auto__);

(statearr_31545[(1)] = (1));

return statearr_31545;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__11438__auto____1 = (function (state_31537){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_31537);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e31546){var ex__11441__auto__ = e31546;
var statearr_31547_31555 = state_31537;
(statearr_31547_31555[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_31537[(4)]))){
var statearr_31548_31556 = state_31537;
(statearr_31548_31556[(1)] = cljs.core.first((state_31537[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31557 = state_31537;
state_31537 = G__31557;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__11438__auto__ = function(state_31537){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__11438__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__11438__auto____1.call(this,state_31537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__11438__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__11438__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_31549 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_31549[(6)] = c__11512__auto___31550);

return statearr_31549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
