// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureedb');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.api_js');
goog.require('fluree.db.connection_js');
cljs.core.enable_console_print_BANG_();
if((typeof flureedb !== 'undefined') && (typeof flureedb.app_state !== 'undefined')){
} else {
flureedb.app_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"FlureeDB APIs",new cljs.core.Keyword(null,"version","version",425292698),"v0.17.0"], null));
}
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state))], 0));
flureedb.on_js_reload = (function flureedb$on_js_reload(){
return null;
});
fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *    1. level [Values: severe, warning, info, config, fine, finer, finest]
 *    
 */
flureedb.set_logging = (function flureedb$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__79261 = opts_SINGLEQUOTE_;
var map__79261__$1 = cljs.core.__destructure_map(map__79261);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__79261__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(level));
});
goog.exportSymbol('flureedb.set_logging', flureedb.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 */
flureedb.connect = (function flureedb$connect(var_args){
var G__79263 = arguments.length;
switch (G__79263) {
case 1:
return flureedb.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect', flureedb.connect);

(flureedb.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 * 
 *     Returns a promise that eventually contains the connection object.
 */
flureedb.connect_p = (function flureedb$connect_p(var_args){
var G__79266 = arguments.length;
switch (G__79266) {
case 1:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect_p', flureedb.connect_p);

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureedb.close = (function flureedb$close(conn){
return fluree.db.connection_js.close(conn);
});
goog.exportSymbol('flureedb.close', flureedb.close);
/**
 * Authenticate with Fluree On-Demand
 */
flureedb.authenticate = (function flureedb$authenticate(var_args){
var G__79269 = arguments.length;
switch (G__79269) {
case 4:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.authenticate', flureedb.authenticate);

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,syncTo);
}));

(flureedb.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Attempts to generate a new user auth record account.
 */
flureedb.password_generate = (function flureedb$password_generate(var_args){
var G__79272 = arguments.length;
switch (G__79272) {
case 4:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_generate', flureedb.password_generate);

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5(conn,ledger,password,user,null);
}));

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var data = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate(conn,ledger,password,data);
}));

(flureedb.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *    Must supply ledger, password and either user or auth identifier.
 *    Expire is optional
 *    - connection - connection object to server
 *    - ledger     - ledger identifier
 *    - password   - plain-text password
 *    - user       - _user/username (TODO: should allow any _user ident in the future)
 *    - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *    - expire     - requested time to expire in milliseconds
 */
flureedb.password_login = (function flureedb$password_login(var_args){
var G__79275 = arguments.length;
switch (G__79275) {
case 4:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_login', flureedb.password_login);

(flureedb.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4(conn,ledger,password,user);
}));

(flureedb.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,auth,expire);
}));

(flureedb.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *    Returns a promise that eventually contains the token or an exception
 */
flureedb.renew_token = (function flureedb$renew_token(var_args){
var G__79278 = arguments.length;
switch (G__79278) {
case 2:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.renew_token', flureedb.renew_token);

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,expire);
}));

(flureedb.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureedb.db = (function flureedb$db(var_args){
var args__5774__auto__ = [];
var len__5768__auto___79287 = arguments.length;
var i__5769__auto___79288 = (0);
while(true){
if((i__5769__auto___79288 < len__5768__auto___79287)){
args__5774__auto__.push((arguments[i__5769__auto___79288]));

var G__79289 = (i__5769__auto___79288 + (1));
i__5769__auto___79288 = G__79289;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((2) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((2)),(0),null)):null);
return flureedb.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5775__auto__);
});
goog.exportSymbol('flureedb.db', flureedb.db);

(flureedb.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__79283){
var vec__79284 = p__79283;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__79284,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts__$1);
}));

(flureedb.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureedb.db.cljs$lang$applyTo = (function (seq79280){
var G__79281 = cljs.core.first(seq79280);
var seq79280__$1 = cljs.core.next(seq79280);
var G__79282 = cljs.core.first(seq79280__$1);
var seq79280__$2 = cljs.core.next(seq79280__$1);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__79281,G__79282,seq79280__$2);
}));

/**
 * Returns db's schema map.
 */
flureedb.db_schema = (function flureedb$db_schema(db){
return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_79308){
var state_val_79309 = (state_79308[(1)]);
if((state_val_79309 === (1))){
var state_79308__$1 = state_79308;
var statearr_79310_79325 = state_79308__$1;
(statearr_79310_79325[(2)] = null);

(statearr_79310_79325[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79309 === (2))){
var _ = (function (){var statearr_79311 = state_79308;
(statearr_79311[(4)] = cljs.core.cons((5),(state_79308[(4)])));

return statearr_79311;
})();
var state_79308__$1 = state_79308;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79308__$1,(6),db);
} else {
if((state_val_79309 === (3))){
var inst_79306 = (state_79308[(2)]);
var state_79308__$1 = state_79308;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79308__$1,inst_79306);
} else {
if((state_val_79309 === (4))){
var inst_79290 = (state_79308[(2)]);
var inst_79291 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79290], 0));
var inst_79292 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_79290) : reject.call(null,inst_79290));
var state_79308__$1 = (function (){var statearr_79313 = state_79308;
(statearr_79313[(7)] = inst_79291);

return statearr_79313;
})();
var statearr_79314_79326 = state_79308__$1;
(statearr_79314_79326[(2)] = inst_79292);

(statearr_79314_79326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79309 === (5))){
var _ = (function (){var statearr_79315 = state_79308;
(statearr_79315[(4)] = cljs.core.rest((state_79308[(4)])));

return statearr_79315;
})();
var state_79308__$1 = state_79308;
var ex79312 = (state_79308__$1[(2)]);
var statearr_79316_79327 = state_79308__$1;
(statearr_79316_79327[(5)] = ex79312);


var statearr_79317_79328 = state_79308__$1;
(statearr_79317_79328[(1)] = (4));

(statearr_79317_79328[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79309 === (6))){
var inst_79299 = (state_79308[(2)]);
var inst_79300 = fluree.db.util.async.throw_err(inst_79299);
var inst_79301 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_79300);
var inst_79302 = cljs.core.clj__GT_js(inst_79301);
var inst_79303 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_79302) : resolve.call(null,inst_79302));
var _ = (function (){var statearr_79318 = state_79308;
(statearr_79318[(4)] = cljs.core.rest((state_79308[(4)])));

return statearr_79318;
})();
var state_79308__$1 = state_79308;
var statearr_79319_79329 = state_79308__$1;
(statearr_79319_79329[(2)] = inst_79303);

(statearr_79319_79329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$db_schema_$_state_machine__11438__auto__ = null;
var flureedb$db_schema_$_state_machine__11438__auto____0 = (function (){
var statearr_79320 = [null,null,null,null,null,null,null,null];
(statearr_79320[(0)] = flureedb$db_schema_$_state_machine__11438__auto__);

(statearr_79320[(1)] = (1));

return statearr_79320;
});
var flureedb$db_schema_$_state_machine__11438__auto____1 = (function (state_79308){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_79308);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e79321){var ex__11441__auto__ = e79321;
var statearr_79322_79330 = state_79308;
(statearr_79322_79330[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_79308[(4)]))){
var statearr_79323_79331 = state_79308;
(statearr_79323_79331[(1)] = cljs.core.first((state_79308[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79332 = state_79308;
state_79308 = G__79332;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
flureedb$db_schema_$_state_machine__11438__auto__ = function(state_79308){
switch(arguments.length){
case 0:
return flureedb$db_schema_$_state_machine__11438__auto____0.call(this);
case 1:
return flureedb$db_schema_$_state_machine__11438__auto____1.call(this,state_79308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$db_schema_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$db_schema_$_state_machine__11438__auto____0;
flureedb$db_schema_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$db_schema_$_state_machine__11438__auto____1;
return flureedb$db_schema_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_79324 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_79324[(6)] = c__11512__auto__);

return statearr_79324;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
});
goog.exportSymbol('flureedb.db_schema', flureedb.db_schema);
/**
 * Completely deletes a ledger.
 *    Returns a promise that will have a response with a corresponding status of success.
 * 
 *    A 200 status indicates the deletion has been successfully initiated.
 *    The full deletion happens in the background on the respective ledger.
 * 
 *    Query servers get notified when this process initiates, and ledger will be marked as
 *    being in a deletion state during the deletion process.
 * 
 *    Attempts to use a ledger in a deletion state will throw an exception.
 */
flureedb.delete_ledger = (function flureedb$delete_ledger(var_args){
var G__79334 = arguments.length;
switch (G__79334) {
case 2:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.delete_ledger', flureedb.delete_ledger);

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_79404){
var state_val_79405 = (state_79404[(1)]);
if((state_val_79405 === (7))){
var inst_79347 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_79404__$1 = state_79404;
var statearr_79406_79451 = state_79404__$1;
(statearr_79406_79451[(2)] = inst_79347);

(statearr_79406_79451[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (20))){
var inst_79355 = (state_79404[(7)]);
var inst_79379 = (state_79404[(2)]);
var state_79404__$1 = (function (){var statearr_79407 = state_79404;
(statearr_79407[(8)] = inst_79379);

return statearr_79407;
})();
if(cljs.core.truth_(inst_79355)){
var statearr_79408_79452 = state_79404__$1;
(statearr_79408_79452[(1)] = (21));

} else {
var statearr_79409_79453 = state_79404__$1;
(statearr_79409_79453[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (1))){
var state_79404__$1 = state_79404;
var statearr_79410_79454 = state_79404__$1;
(statearr_79410_79454[(2)] = null);

(statearr_79410_79454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (24))){
var inst_79386 = (state_79404[(2)]);
var inst_79387 = fluree.db.util.async.throw_err(inst_79386);
var state_79404__$1 = state_79404;
var statearr_79411_79455 = state_79404__$1;
(statearr_79411_79455[(2)] = inst_79387);

(statearr_79411_79455[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (4))){
var inst_79335 = (state_79404[(2)]);
var inst_79336 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79335], 0));
var inst_79337 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_79335) : reject.call(null,inst_79335));
var state_79404__$1 = (function (){var statearr_79412 = state_79404;
(statearr_79412[(9)] = inst_79336);

return statearr_79412;
})();
var statearr_79413_79456 = state_79404__$1;
(statearr_79413_79456[(2)] = inst_79337);

(statearr_79413_79456[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (15))){
var inst_79368 = (state_79404[(10)]);
var inst_79370 = fluree.db.util.core.without_nils(inst_79368);
var inst_79371 = fluree.db.util.json.stringify(inst_79370);
var state_79404__$1 = state_79404;
var statearr_79414_79457 = state_79404__$1;
(statearr_79414_79457[(2)] = inst_79371);

(statearr_79414_79457[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (21))){
var inst_79379 = (state_79404[(8)]);
var inst_79374 = (state_79404[(11)]);
var inst_79381 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_79382 = [inst_79374,inst_79379];
var inst_79383 = cljs.core.PersistentHashMap.fromArrays(inst_79381,inst_79382);
var inst_79384 = fluree.db.operations.command_async(conn,inst_79383);
var state_79404__$1 = state_79404;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79404__$1,(24),inst_79384);
} else {
if((state_val_79405 === (13))){
var inst_79356 = (state_79404[(12)]);
var inst_79363 = (inst_79356 + (30000));
var state_79404__$1 = state_79404;
var statearr_79415_79458 = state_79404__$1;
(statearr_79415_79458[(2)] = inst_79363);

(statearr_79415_79458[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (22))){
var inst_79368 = (state_79404[(10)]);
var inst_79389 = fluree.db.operations.unsigned_command_async(conn,inst_79368);
var state_79404__$1 = state_79404;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79404__$1,(25),inst_79389);
} else {
if((state_val_79405 === (6))){
var state_79404__$1 = state_79404;
var statearr_79416_79459 = state_79404__$1;
(statearr_79416_79459[(2)] = null);

(statearr_79416_79459[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (25))){
var inst_79391 = (state_79404[(2)]);
var inst_79392 = fluree.db.util.async.throw_err(inst_79391);
var state_79404__$1 = state_79404;
var statearr_79417_79460 = state_79404__$1;
(statearr_79417_79460[(2)] = inst_79392);

(statearr_79417_79460[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (17))){
var inst_79355 = (state_79404[(7)]);
var inst_79374 = (state_79404[(2)]);
var state_79404__$1 = (function (){var statearr_79418 = state_79404;
(statearr_79418[(11)] = inst_79374);

return statearr_79418;
})();
if(cljs.core.truth_(inst_79355)){
var statearr_79419_79461 = state_79404__$1;
(statearr_79419_79461[(1)] = (18));

} else {
var statearr_79420_79462 = state_79404__$1;
(statearr_79420_79462[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (3))){
var inst_79402 = (state_79404[(2)]);
var state_79404__$1 = state_79404;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79404__$1,inst_79402);
} else {
if((state_val_79405 === (12))){
var inst_79353 = (state_79404[(13)]);
var state_79404__$1 = state_79404;
var statearr_79421_79463 = state_79404__$1;
(statearr_79421_79463[(2)] = inst_79353);

(statearr_79421_79463[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (2))){
var _ = (function (){var statearr_79422 = state_79404;
(statearr_79422[(4)] = cljs.core.cons((5),(state_79404[(4)])));

return statearr_79422;
})();
var inst_79344 = (opts == null);
var state_79404__$1 = state_79404;
if(cljs.core.truth_(inst_79344)){
var statearr_79423_79464 = state_79404__$1;
(statearr_79423_79464[(1)] = (6));

} else {
var statearr_79424_79465 = state_79404__$1;
(statearr_79424_79465[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (23))){
var inst_79394 = (state_79404[(2)]);
var inst_79395 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_79396 = [(200),inst_79394];
var inst_79397 = cljs.core.PersistentHashMap.fromArrays(inst_79395,inst_79396);
var inst_79398 = cljs.core.clj__GT_js(inst_79397);
var inst_79399 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_79398) : resolve.call(null,inst_79398));
var _ = (function (){var statearr_79425 = state_79404;
(statearr_79425[(4)] = cljs.core.rest((state_79404[(4)])));

return statearr_79425;
})();
var state_79404__$1 = state_79404;
var statearr_79426_79466 = state_79404__$1;
(statearr_79426_79466[(2)] = inst_79399);

(statearr_79426_79466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (19))){
var state_79404__$1 = state_79404;
var statearr_79427_79467 = state_79404__$1;
(statearr_79427_79467[(2)] = null);

(statearr_79427_79467[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (11))){
var inst_79353 = (state_79404[(13)]);
var inst_79360 = (state_79404[(2)]);
var state_79404__$1 = (function (){var statearr_79429 = state_79404;
(statearr_79429[(14)] = inst_79360);

return statearr_79429;
})();
if(cljs.core.truth_(inst_79353)){
var statearr_79430_79468 = state_79404__$1;
(statearr_79430_79468[(1)] = (12));

} else {
var statearr_79431_79469 = state_79404__$1;
(statearr_79431_79469[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (9))){
var inst_79352 = (state_79404[(15)]);
var state_79404__$1 = state_79404;
var statearr_79432_79470 = state_79404__$1;
(statearr_79432_79470[(2)] = inst_79352);

(statearr_79432_79470[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (5))){
var _ = (function (){var statearr_79433 = state_79404;
(statearr_79433[(4)] = cljs.core.rest((state_79404[(4)])));

return statearr_79433;
})();
var state_79404__$1 = state_79404;
var ex79428 = (state_79404__$1[(2)]);
var statearr_79434_79471 = state_79404__$1;
(statearr_79434_79471[(5)] = ex79428);


var statearr_79435_79472 = state_79404__$1;
(statearr_79435_79472[(1)] = (4));

(statearr_79435_79472[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (14))){
var inst_79355 = (state_79404[(7)]);
var inst_79360 = (state_79404[(14)]);
var inst_79365 = (state_79404[(2)]);
var inst_79366 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_79367 = [new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),ledger,inst_79360,inst_79365];
var inst_79368 = cljs.core.PersistentHashMap.fromArrays(inst_79366,inst_79367);
var state_79404__$1 = (function (){var statearr_79436 = state_79404;
(statearr_79436[(10)] = inst_79368);

return statearr_79436;
})();
if(cljs.core.truth_(inst_79355)){
var statearr_79437_79473 = state_79404__$1;
(statearr_79437_79473[(1)] = (15));

} else {
var statearr_79438_79474 = state_79404__$1;
(statearr_79438_79474[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (16))){
var state_79404__$1 = state_79404;
var statearr_79439_79475 = state_79404__$1;
(statearr_79439_79475[(2)] = null);

(statearr_79439_79475[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (10))){
var inst_79356 = (state_79404[(12)]);
var state_79404__$1 = state_79404;
var statearr_79440_79476 = state_79404__$1;
(statearr_79440_79476[(2)] = inst_79356);

(statearr_79440_79476[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (18))){
var inst_79355 = (state_79404[(7)]);
var inst_79374 = (state_79404[(11)]);
var inst_79376 = fluree.crypto.sign_message(inst_79374,inst_79355);
var state_79404__$1 = state_79404;
var statearr_79441_79477 = state_79404__$1;
(statearr_79441_79477[(2)] = inst_79376);

(statearr_79441_79477[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79405 === (8))){
var inst_79352 = (state_79404[(15)]);
var inst_79349 = (state_79404[(2)]);
var inst_79350 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_79349);
var inst_79351 = cljs.core.__destructure_map(inst_79349);
var inst_79352__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79351,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_79353 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79351,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_79354 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_79351,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_79355 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79351,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_79356 = fluree.db.util.core.current_time_millis();
var state_79404__$1 = (function (){var statearr_79442 = state_79404;
(statearr_79442[(7)] = inst_79355);

(statearr_79442[(12)] = inst_79356);

(statearr_79442[(16)] = inst_79350);

(statearr_79442[(15)] = inst_79352__$1);

(statearr_79442[(17)] = inst_79354);

(statearr_79442[(13)] = inst_79353);

return statearr_79442;
})();
if(cljs.core.truth_(inst_79352__$1)){
var statearr_79443_79478 = state_79404__$1;
(statearr_79443_79478[(1)] = (9));

} else {
var statearr_79444_79479 = state_79404__$1;
(statearr_79444_79479[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__11438__auto__ = null;
var flureedb$state_machine__11438__auto____0 = (function (){
var statearr_79445 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79445[(0)] = flureedb$state_machine__11438__auto__);

(statearr_79445[(1)] = (1));

return statearr_79445;
});
var flureedb$state_machine__11438__auto____1 = (function (state_79404){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_79404);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e79446){var ex__11441__auto__ = e79446;
var statearr_79447_79480 = state_79404;
(statearr_79447_79480[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_79404[(4)]))){
var statearr_79448_79481 = state_79404;
(statearr_79448_79481[(1)] = cljs.core.first((state_79404[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79482 = state_79404;
state_79404 = G__79482;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
flureedb$state_machine__11438__auto__ = function(state_79404){
switch(arguments.length){
case 0:
return flureedb$state_machine__11438__auto____0.call(this);
case 1:
return flureedb$state_machine__11438__auto____1.call(this,state_79404);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__11438__auto____0;
flureedb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__11438__auto____1;
return flureedb$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_79449 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_79449[(6)] = c__11512__auto__);

return statearr_79449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
}));

(flureedb.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise returning ledger's stats, including db size and # of flakes.
 *    If ledger doesn't exist, will return an empty map.
 */
flureedb.ledger_stats = (function flureedb$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_79501){
var state_val_79502 = (state_79501[(1)]);
if((state_val_79502 === (1))){
var state_79501__$1 = state_79501;
var statearr_79503_79518 = state_79501__$1;
(statearr_79503_79518[(2)] = null);

(statearr_79503_79518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79502 === (2))){
var _ = (function (){var statearr_79504 = state_79501;
(statearr_79504[(4)] = cljs.core.cons((5),(state_79501[(4)])));

return statearr_79504;
})();
var inst_79491 = fluree.db.operations.ledger_stats_async(conn,ledger);
var state_79501__$1 = state_79501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79501__$1,(6),inst_79491);
} else {
if((state_val_79502 === (3))){
var inst_79499 = (state_79501[(2)]);
var state_79501__$1 = state_79501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79501__$1,inst_79499);
} else {
if((state_val_79502 === (4))){
var inst_79483 = (state_79501[(2)]);
var inst_79484 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79483], 0));
var inst_79485 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_79483) : reject.call(null,inst_79483));
var state_79501__$1 = (function (){var statearr_79506 = state_79501;
(statearr_79506[(7)] = inst_79484);

return statearr_79506;
})();
var statearr_79507_79519 = state_79501__$1;
(statearr_79507_79519[(2)] = inst_79485);

(statearr_79507_79519[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79502 === (5))){
var _ = (function (){var statearr_79508 = state_79501;
(statearr_79508[(4)] = cljs.core.rest((state_79501[(4)])));

return statearr_79508;
})();
var state_79501__$1 = state_79501;
var ex79505 = (state_79501__$1[(2)]);
var statearr_79509_79520 = state_79501__$1;
(statearr_79509_79520[(5)] = ex79505);


var statearr_79510_79521 = state_79501__$1;
(statearr_79510_79521[(1)] = (4));

(statearr_79510_79521[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79502 === (6))){
var inst_79493 = (state_79501[(2)]);
var inst_79494 = fluree.db.util.async.throw_err(inst_79493);
var inst_79495 = cljs.core.clj__GT_js(inst_79494);
var inst_79496 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_79495) : resolve.call(null,inst_79495));
var _ = (function (){var statearr_79511 = state_79501;
(statearr_79511[(4)] = cljs.core.rest((state_79501[(4)])));

return statearr_79511;
})();
var state_79501__$1 = state_79501;
var statearr_79512_79522 = state_79501__$1;
(statearr_79512_79522[(2)] = inst_79496);

(statearr_79512_79522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$ledger_stats_$_state_machine__11438__auto__ = null;
var flureedb$ledger_stats_$_state_machine__11438__auto____0 = (function (){
var statearr_79513 = [null,null,null,null,null,null,null,null];
(statearr_79513[(0)] = flureedb$ledger_stats_$_state_machine__11438__auto__);

(statearr_79513[(1)] = (1));

return statearr_79513;
});
var flureedb$ledger_stats_$_state_machine__11438__auto____1 = (function (state_79501){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_79501);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e79514){var ex__11441__auto__ = e79514;
var statearr_79515_79523 = state_79501;
(statearr_79515_79523[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_79501[(4)]))){
var statearr_79516_79524 = state_79501;
(statearr_79516_79524[(1)] = cljs.core.first((state_79501[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79525 = state_79501;
state_79501 = G__79525;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
flureedb$ledger_stats_$_state_machine__11438__auto__ = function(state_79501){
switch(arguments.length){
case 0:
return flureedb$ledger_stats_$_state_machine__11438__auto____0.call(this);
case 1:
return flureedb$ledger_stats_$_state_machine__11438__auto____1.call(this,state_79501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$ledger_stats_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$ledger_stats_$_state_machine__11438__auto____0;
flureedb$ledger_stats_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$ledger_stats_$_state_machine__11438__auto____1;
return flureedb$ledger_stats_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_79517 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_79517[(6)] = c__11512__auto__);

return statearr_79517;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
});
goog.exportSymbol('flureedb.ledger_stats', flureedb.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 *     A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 *     Once successful, will return with a command-id.
 * 
 *     Ledger creation is handled asynchronously and may not be immediately available.
 * 
 *     Options include:
 *     - :alias       - Alias, if different than db-ident.
 *     - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 *     - :doc         - Optional doc string about this db.
 *     - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 *     - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 *     - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 *     - :jwt         - token for Fluree On-Demand access
 *     
 */
flureedb.new_ledger = (function flureedb$new_ledger(var_args){
var G__79527 = arguments.length;
switch (G__79527) {
case 2:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.new_ledger', flureedb.new_ledger);

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_79651){
var state_val_79652 = (state_79651[(1)]);
if((state_val_79652 === (7))){
var inst_79550 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_79651__$1 = state_79651;
var statearr_79653_79723 = state_79651__$1;
(statearr_79653_79723[(2)] = inst_79550);

(statearr_79653_79723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (20))){
var inst_79557 = (state_79651[(7)]);
var inst_79596 = (state_79651[(2)]);
var inst_79597 = fluree.db.util.core.current_time_millis();
var state_79651__$1 = (function (){var statearr_79654 = state_79651;
(statearr_79654[(8)] = inst_79597);

(statearr_79654[(9)] = inst_79596);

return statearr_79654;
})();
if(cljs.core.truth_(inst_79557)){
var statearr_79655_79724 = state_79651__$1;
(statearr_79655_79724[(1)] = (21));

} else {
var statearr_79656_79725 = state_79651__$1;
(statearr_79656_79725[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (27))){
var inst_79565 = (state_79651[(10)]);
var inst_79610 = (state_79651[(11)]);
var inst_79612 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_79610,new cljs.core.Keyword(null,"jwt","jwt",1504015441),inst_79565);
var state_79651__$1 = state_79651;
var statearr_79657_79726 = state_79651__$1;
(statearr_79657_79726[(2)] = inst_79612);

(statearr_79657_79726[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (1))){
var state_79651__$1 = state_79651;
var statearr_79658_79727 = state_79651__$1;
(statearr_79658_79727[(2)] = null);

(statearr_79658_79727[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (24))){
var inst_79563 = (state_79651[(12)]);
var state_79651__$1 = state_79651;
var statearr_79659_79728 = state_79651__$1;
(statearr_79659_79728[(2)] = inst_79563);

(statearr_79659_79728[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (39))){
var inst_79633 = (state_79651[(2)]);
var inst_79634 = fluree.db.util.async.throw_err(inst_79633);
var state_79651__$1 = state_79651;
var statearr_79660_79729 = state_79651__$1;
(statearr_79660_79729[(2)] = inst_79634);

(statearr_79660_79729[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (4))){
var inst_79528 = (state_79651[(2)]);
var inst_79529 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79528], 0));
var inst_79530 = cljs.core.ex_data(inst_79528);
var inst_79531 = cljs.core.ex_message(inst_79528);
var inst_79532 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_79530,new cljs.core.Keyword(null,"message","message",-406056002),inst_79531);
var inst_79533 = cljs.core.clj__GT_js(inst_79532);
var inst_79534 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_79533) : reject.call(null,inst_79533));
var state_79651__$1 = (function (){var statearr_79661 = state_79651;
(statearr_79661[(13)] = inst_79529);

return statearr_79661;
})();
var statearr_79662_79730 = state_79651__$1;
(statearr_79662_79730[(2)] = inst_79534);

(statearr_79662_79730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (15))){
var inst_79586 = (state_79651[(14)]);
var inst_79588 = fluree.db.graphdb.validate_ledger_name(inst_79586,"alias");
var state_79651__$1 = state_79651;
var statearr_79663_79731 = state_79651__$1;
(statearr_79663_79731[(2)] = inst_79588);

(statearr_79663_79731[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (21))){
var inst_79557 = (state_79651[(7)]);
var state_79651__$1 = state_79651;
var statearr_79664_79732 = state_79651__$1;
(statearr_79664_79732[(2)] = inst_79557);

(statearr_79664_79732[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (31))){
var state_79651__$1 = state_79651;
var statearr_79665_79733 = state_79651__$1;
(statearr_79665_79733[(2)] = null);

(statearr_79665_79733[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (32))){
var inst_79559 = (state_79651[(15)]);
var inst_79621 = (state_79651[(2)]);
var state_79651__$1 = (function (){var statearr_79666 = state_79651;
(statearr_79666[(16)] = inst_79621);

return statearr_79666;
})();
if(cljs.core.truth_(inst_79559)){
var statearr_79667_79734 = state_79651__$1;
(statearr_79667_79734[(1)] = (33));

} else {
var statearr_79668_79735 = state_79651__$1;
(statearr_79668_79735[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (40))){
var inst_79638 = (state_79651[(2)]);
var inst_79639 = fluree.db.util.async.throw_err(inst_79638);
var state_79651__$1 = state_79651;
var statearr_79669_79736 = state_79651__$1;
(statearr_79669_79736[(2)] = inst_79639);

(statearr_79669_79736[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (33))){
var inst_79621 = (state_79651[(16)]);
var inst_79559 = (state_79651[(15)]);
var inst_79623 = fluree.crypto.sign_message(inst_79621,inst_79559);
var state_79651__$1 = state_79651;
var statearr_79670_79737 = state_79651__$1;
(statearr_79670_79737[(2)] = inst_79623);

(statearr_79670_79737[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (13))){
var state_79651__$1 = state_79651;
var statearr_79671_79738 = state_79651__$1;
(statearr_79671_79738[(2)] = null);

(statearr_79671_79738[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (22))){
var inst_79597 = (state_79651[(8)]);
var state_79651__$1 = state_79651;
var statearr_79672_79739 = state_79651__$1;
(statearr_79672_79739[(2)] = inst_79597);

(statearr_79672_79739[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (36))){
var inst_79621 = (state_79651[(16)]);
var inst_79626 = (state_79651[(17)]);
var inst_79628 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_79629 = [inst_79621,inst_79626];
var inst_79630 = cljs.core.PersistentHashMap.fromArrays(inst_79628,inst_79629);
var inst_79631 = fluree.db.operations.command_async(conn,inst_79630);
var state_79651__$1 = state_79651;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79651__$1,(39),inst_79631);
} else {
if((state_val_79652 === (29))){
var inst_79559 = (state_79651[(15)]);
var inst_79615 = (state_79651[(2)]);
var state_79651__$1 = (function (){var statearr_79673 = state_79651;
(statearr_79673[(18)] = inst_79615);

return statearr_79673;
})();
if(cljs.core.truth_(inst_79559)){
var statearr_79674_79740 = state_79651__$1;
(statearr_79674_79740[(1)] = (30));

} else {
var statearr_79675_79741 = state_79651__$1;
(statearr_79675_79741[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (6))){
var state_79651__$1 = state_79651;
var statearr_79676_79742 = state_79651__$1;
(statearr_79676_79742[(2)] = null);

(statearr_79676_79742[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (28))){
var inst_79610 = (state_79651[(11)]);
var state_79651__$1 = state_79651;
var statearr_79677_79743 = state_79651__$1;
(statearr_79677_79743[(2)] = inst_79610);

(statearr_79677_79743[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (25))){
var inst_79597 = (state_79651[(8)]);
var inst_79604 = (inst_79597 + (30000));
var state_79651__$1 = state_79651;
var statearr_79678_79744 = state_79651__$1;
(statearr_79678_79744[(2)] = inst_79604);

(statearr_79678_79744[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (34))){
var state_79651__$1 = state_79651;
var statearr_79679_79745 = state_79651__$1;
(statearr_79679_79745[(2)] = null);

(statearr_79679_79745[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (17))){
var inst_79567 = (state_79651[(19)]);
var inst_79591 = (state_79651[(2)]);
var state_79651__$1 = (function (){var statearr_79680 = state_79651;
(statearr_79680[(20)] = inst_79591);

return statearr_79680;
})();
if(cljs.core.truth_(inst_79567)){
var statearr_79681_79746 = state_79651__$1;
(statearr_79681_79746[(1)] = (18));

} else {
var statearr_79682_79747 = state_79651__$1;
(statearr_79682_79747[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (3))){
var inst_79649 = (state_79651[(2)]);
var state_79651__$1 = state_79651;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79651__$1,inst_79649);
} else {
if((state_val_79652 === (12))){
var inst_79581 = fluree.db.graphdb.validate_ledger_ident(ledger);
var state_79651__$1 = state_79651;
var statearr_79683_79748 = state_79651__$1;
(statearr_79683_79748[(2)] = inst_79581);

(statearr_79683_79748[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (2))){
var _ = (function (){var statearr_79684 = state_79651;
(statearr_79684[(4)] = cljs.core.cons((5),(state_79651[(4)])));

return statearr_79684;
})();
var inst_79547 = (opts == null);
var state_79651__$1 = state_79651;
if(cljs.core.truth_(inst_79547)){
var statearr_79685_79749 = state_79651__$1;
(statearr_79685_79749[(1)] = (6));

} else {
var statearr_79686_79750 = state_79651__$1;
(statearr_79686_79750[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (23))){
var inst_79563 = (state_79651[(12)]);
var inst_79601 = (state_79651[(2)]);
var state_79651__$1 = (function (){var statearr_79687 = state_79651;
(statearr_79687[(21)] = inst_79601);

return statearr_79687;
})();
if(cljs.core.truth_(inst_79563)){
var statearr_79688_79751 = state_79651__$1;
(statearr_79688_79751[(1)] = (24));

} else {
var statearr_79689_79752 = state_79651__$1;
(statearr_79689_79752[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (35))){
var inst_79559 = (state_79651[(15)]);
var inst_79626 = (state_79651[(2)]);
var state_79651__$1 = (function (){var statearr_79690 = state_79651;
(statearr_79690[(17)] = inst_79626);

return statearr_79690;
})();
if(cljs.core.truth_(inst_79559)){
var statearr_79691_79753 = state_79651__$1;
(statearr_79691_79753[(1)] = (36));

} else {
var statearr_79692_79754 = state_79651__$1;
(statearr_79692_79754[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (19))){
var state_79651__$1 = state_79651;
var statearr_79693_79755 = state_79651__$1;
(statearr_79693_79755[(2)] = null);

(statearr_79693_79755[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (11))){
var inst_79577 = (state_79651[(22)]);
var inst_79567 = (state_79651[(19)]);
var inst_79570 = (state_79651[(23)]);
var inst_79577__$1 = (state_79651[(2)]);
var inst_79578 = fluree.db.graphdb.validate_ledger_name(inst_79577__$1,"ledger");
var inst_79579 = fluree.db.graphdb.validate_ledger_name(inst_79570,"network");
var state_79651__$1 = (function (){var statearr_79695 = state_79651;
(statearr_79695[(24)] = inst_79578);

(statearr_79695[(22)] = inst_79577__$1);

(statearr_79695[(25)] = inst_79579);

return statearr_79695;
})();
if(cljs.core.truth_(inst_79567)){
var statearr_79696_79756 = state_79651__$1;
(statearr_79696_79756[(1)] = (12));

} else {
var statearr_79697_79757 = state_79651__$1;
(statearr_79697_79757[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (9))){
var inst_79571 = (state_79651[(26)]);
var inst_79574 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_79571,(1));
var state_79651__$1 = state_79651;
var statearr_79698_79758 = state_79651__$1;
(statearr_79698_79758[(2)] = inst_79574);

(statearr_79698_79758[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (5))){
var _ = (function (){var statearr_79699 = state_79651;
(statearr_79699[(4)] = cljs.core.rest((state_79651[(4)])));

return statearr_79699;
})();
var state_79651__$1 = state_79651;
var ex79694 = (state_79651__$1[(2)]);
var statearr_79700_79759 = state_79651__$1;
(statearr_79700_79759[(5)] = ex79694);


var statearr_79701_79760 = state_79651__$1;
(statearr_79701_79760[(1)] = (4));

(statearr_79701_79760[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (14))){
var inst_79567 = (state_79651[(19)]);
var inst_79584 = (state_79651[(2)]);
var inst_79585 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79584,(0),null);
var inst_79586 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79584,(1),null);
var state_79651__$1 = (function (){var statearr_79702 = state_79651;
(statearr_79702[(14)] = inst_79586);

(statearr_79702[(27)] = inst_79585);

return statearr_79702;
})();
if(cljs.core.truth_(inst_79567)){
var statearr_79703_79761 = state_79651__$1;
(statearr_79703_79761[(1)] = (15));

} else {
var statearr_79704_79762 = state_79651__$1;
(statearr_79704_79762[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (26))){
var inst_79577 = (state_79651[(22)]);
var inst_79565 = (state_79651[(10)]);
var inst_79564 = (state_79651[(28)]);
var inst_79561 = (state_79651[(29)]);
var inst_79556 = (state_79651[(30)]);
var inst_79562 = (state_79651[(31)]);
var inst_79566 = (state_79651[(32)]);
var inst_79560 = (state_79651[(33)]);
var inst_79570 = (state_79651[(23)]);
var inst_79596 = (state_79651[(9)]);
var inst_79558 = (state_79651[(34)]);
var inst_79601 = (state_79651[(21)]);
var inst_79568 = (state_79651[(35)]);
var inst_79606 = (state_79651[(2)]);
var inst_79607 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_79608 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_79570),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_79577)].join('');
var inst_79609 = [inst_79608,inst_79561,inst_79562,new cljs.core.Keyword(null,"new-ledger","new-ledger",34666434),inst_79606,inst_79564,inst_79596,inst_79568,inst_79566,inst_79556,inst_79601,inst_79558,inst_79560];
var inst_79610 = cljs.core.PersistentHashMap.fromArrays(inst_79607,inst_79609);
var state_79651__$1 = (function (){var statearr_79705 = state_79651;
(statearr_79705[(11)] = inst_79610);

return statearr_79705;
})();
if(cljs.core.truth_(inst_79565)){
var statearr_79706_79763 = state_79651__$1;
(statearr_79706_79763[(1)] = (27));

} else {
var statearr_79707_79764 = state_79651__$1;
(statearr_79707_79764[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (16))){
var state_79651__$1 = state_79651;
var statearr_79708_79765 = state_79651__$1;
(statearr_79708_79765[(2)] = null);

(statearr_79708_79765[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (38))){
var inst_79641 = (state_79651[(2)]);
var inst_79642 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_79643 = [(200),inst_79641];
var inst_79644 = cljs.core.PersistentHashMap.fromArrays(inst_79642,inst_79643);
var inst_79645 = cljs.core.clj__GT_js(inst_79644);
var inst_79646 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_79645) : resolve.call(null,inst_79645));
var _ = (function (){var statearr_79709 = state_79651;
(statearr_79709[(4)] = cljs.core.rest((state_79651[(4)])));

return statearr_79709;
})();
var state_79651__$1 = state_79651;
var statearr_79710_79766 = state_79651__$1;
(statearr_79710_79766[(2)] = inst_79646);

(statearr_79710_79766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (30))){
var inst_79615 = (state_79651[(18)]);
var inst_79617 = fluree.db.util.core.without_nils(inst_79615);
var inst_79618 = fluree.db.util.json.stringify(inst_79617);
var state_79651__$1 = state_79651;
var statearr_79711_79767 = state_79651__$1;
(statearr_79711_79767[(2)] = inst_79618);

(statearr_79711_79767[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (10))){
var inst_79571 = (state_79651[(26)]);
var state_79651__$1 = state_79651;
var statearr_79712_79768 = state_79651__$1;
(statearr_79712_79768[(2)] = inst_79571);

(statearr_79712_79768[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (18))){
var inst_79586 = (state_79651[(14)]);
var inst_79585 = (state_79651[(27)]);
var inst_79593 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_79585),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_79586)].join('');
var state_79651__$1 = state_79651;
var statearr_79713_79769 = state_79651__$1;
(statearr_79713_79769[(2)] = inst_79593);

(statearr_79713_79769[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79652 === (37))){
var inst_79615 = (state_79651[(18)]);
var inst_79636 = fluree.db.operations.unsigned_command_async(conn,inst_79615);
var state_79651__$1 = state_79651;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79651__$1,(40),inst_79636);
} else {
if((state_val_79652 === (8))){
var inst_79571 = (state_79651[(26)]);
var inst_79552 = (state_79651[(2)]);
var inst_79553 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_79552);
var inst_79554 = cljs.core.__destructure_map(inst_79552);
var inst_79555 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_79554,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_79556 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79554,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_79557 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79554,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_79558 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79554,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_79559 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79554,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_79560 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79554,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_79561 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79554,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_79562 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79554,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_79563 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79554,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_79564 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79554,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_79565 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79554,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_79566 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79554,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_79567 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79554,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_79568 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79554,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_79569 = fluree.db.graphdb.validate_ledger_ident(ledger);
var inst_79570 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79569,(0),null);
var inst_79571__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79569,(1),null);
var inst_79572 = clojure.string.starts_with_QMARK_(inst_79571__$1,"$");
var state_79651__$1 = (function (){var statearr_79714 = state_79651;
(statearr_79714[(26)] = inst_79571__$1);

(statearr_79714[(7)] = inst_79557);

(statearr_79714[(19)] = inst_79567);

(statearr_79714[(10)] = inst_79565);

(statearr_79714[(12)] = inst_79563);

(statearr_79714[(28)] = inst_79564);

(statearr_79714[(29)] = inst_79561);

(statearr_79714[(30)] = inst_79556);

(statearr_79714[(31)] = inst_79562);

(statearr_79714[(15)] = inst_79559);

(statearr_79714[(36)] = inst_79555);

(statearr_79714[(32)] = inst_79566);

(statearr_79714[(33)] = inst_79560);

(statearr_79714[(37)] = inst_79553);

(statearr_79714[(23)] = inst_79570);

(statearr_79714[(34)] = inst_79558);

(statearr_79714[(35)] = inst_79568);

return statearr_79714;
})();
if(inst_79572){
var statearr_79715_79770 = state_79651__$1;
(statearr_79715_79770[(1)] = (9));

} else {
var statearr_79716_79771 = state_79651__$1;
(statearr_79716_79771[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__11438__auto__ = null;
var flureedb$state_machine__11438__auto____0 = (function (){
var statearr_79717 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79717[(0)] = flureedb$state_machine__11438__auto__);

(statearr_79717[(1)] = (1));

return statearr_79717;
});
var flureedb$state_machine__11438__auto____1 = (function (state_79651){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_79651);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e79718){var ex__11441__auto__ = e79718;
var statearr_79719_79772 = state_79651;
(statearr_79719_79772[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_79651[(4)]))){
var statearr_79720_79773 = state_79651;
(statearr_79720_79773[(1)] = cljs.core.first((state_79651[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79774 = state_79651;
state_79651 = G__79774;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
flureedb$state_machine__11438__auto__ = function(state_79651){
switch(arguments.length){
case 0:
return flureedb$state_machine__11438__auto____0.call(this);
case 1:
return flureedb$state_machine__11438__auto____1.call(this,state_79651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__11438__auto____0;
flureedb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__11438__auto____1;
return flureedb$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_79721 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_79721[(6)] = c__11512__auto__);

return statearr_79721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
}));

(flureedb.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *    Returns a promise that will eventually contain a response or an exception
 *    if the timeout period has expired.
 * 
 *    Response may contain an exception, if the tx resulted in an exception.
 */
flureedb.monitor_tx = (function flureedb$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_79794){
var state_val_79795 = (state_79794[(1)]);
if((state_val_79795 === (1))){
var state_79794__$1 = state_79794;
var statearr_79796_79812 = state_79794__$1;
(statearr_79796_79812[(2)] = null);

(statearr_79796_79812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79795 === (2))){
var _ = (function (){var statearr_79797 = state_79794;
(statearr_79797[(4)] = cljs.core.cons((5),(state_79794[(4)])));

return statearr_79797;
})();
var inst_79784 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1(conn);
var inst_79785 = fluree.db.api_js.monitor_tx(conn,ledger,txid,timeout_ms);
var state_79794__$1 = (function (){var statearr_79798 = state_79794;
(statearr_79798[(7)] = inst_79784);

return statearr_79798;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79794__$1,(6),inst_79785);
} else {
if((state_val_79795 === (3))){
var inst_79792 = (state_79794[(2)]);
var state_79794__$1 = state_79794;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79794__$1,inst_79792);
} else {
if((state_val_79795 === (4))){
var inst_79775 = (state_79794[(2)]);
var inst_79776 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79775], 0));
var inst_79777 = cljs.core.clj__GT_js(inst_79775);
var inst_79778 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_79777) : reject.call(null,inst_79777));
var state_79794__$1 = (function (){var statearr_79800 = state_79794;
(statearr_79800[(8)] = inst_79776);

return statearr_79800;
})();
var statearr_79801_79813 = state_79794__$1;
(statearr_79801_79813[(2)] = inst_79778);

(statearr_79801_79813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79795 === (5))){
var _ = (function (){var statearr_79802 = state_79794;
(statearr_79802[(4)] = cljs.core.rest((state_79794[(4)])));

return statearr_79802;
})();
var state_79794__$1 = state_79794;
var ex79799 = (state_79794__$1[(2)]);
var statearr_79803_79814 = state_79794__$1;
(statearr_79803_79814[(5)] = ex79799);


var statearr_79804_79815 = state_79794__$1;
(statearr_79804_79815[(1)] = (4));

(statearr_79804_79815[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79795 === (6))){
var inst_79787 = (state_79794[(2)]);
var inst_79788 = cljs.core.clj__GT_js(inst_79787);
var inst_79789 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_79788) : resolve.call(null,inst_79788));
var _ = (function (){var statearr_79805 = state_79794;
(statearr_79805[(4)] = cljs.core.rest((state_79794[(4)])));

return statearr_79805;
})();
var state_79794__$1 = state_79794;
var statearr_79806_79816 = state_79794__$1;
(statearr_79806_79816[(2)] = inst_79789);

(statearr_79806_79816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$monitor_tx_$_state_machine__11438__auto__ = null;
var flureedb$monitor_tx_$_state_machine__11438__auto____0 = (function (){
var statearr_79807 = [null,null,null,null,null,null,null,null,null];
(statearr_79807[(0)] = flureedb$monitor_tx_$_state_machine__11438__auto__);

(statearr_79807[(1)] = (1));

return statearr_79807;
});
var flureedb$monitor_tx_$_state_machine__11438__auto____1 = (function (state_79794){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_79794);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e79808){var ex__11441__auto__ = e79808;
var statearr_79809_79817 = state_79794;
(statearr_79809_79817[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_79794[(4)]))){
var statearr_79810_79818 = state_79794;
(statearr_79810_79818[(1)] = cljs.core.first((state_79794[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79819 = state_79794;
state_79794 = G__79819;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
flureedb$monitor_tx_$_state_machine__11438__auto__ = function(state_79794){
switch(arguments.length){
case 0:
return flureedb$monitor_tx_$_state_machine__11438__auto____0.call(this);
case 1:
return flureedb$monitor_tx_$_state_machine__11438__auto____1.call(this,state_79794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$monitor_tx_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$monitor_tx_$_state_machine__11438__auto____0;
flureedb$monitor_tx_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$monitor_tx_$_state_machine__11438__auto____1;
return flureedb$monitor_tx_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_79811 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_79811[(6)] = c__11512__auto__);

return statearr_79811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
});
goog.exportSymbol('flureedb.monitor_tx', flureedb.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 *     that will eventually have the result of the tx, the txid (if :txid-only option used), or
 *     an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 *     Will locally sign a final transaction command if a private key is provided via :private-key
 *     in the options, otherwise will submit the transaction to the connected ledger and request signature,
 *     provided the ledger group has a default private key available for signing.
 * 
 *     Options (opts) is a map with the following possible keys:
 *     - private-key - The private key to use for signing. If not present, a default
 *                     private key will attempt to be used from the connection, if available.
 *     - auth        - The auth id for the auth record being used. The private key must
 *                     correspond to this auth record, or an authority of this auth record.
 *     - expire      - When this transaction should expire if not yet attempted.
 *                     Defaults to 5 minutes.
 *     - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                     By default epoch milliseconds is used.
 *     - deps        - List of one or more txids that must be successfully processed before
 *                     this tx is processed. If any fail, this tx will fail. (not yet implemented)
 *     - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                     but instead return with the txid once it is successfully persisted by the
 *                     transactors. The txid can be used to look up/monitor the response at a later time.
 *     - timeout     - will respond with an exception if timeout reached before response available.
 *     - jwt         - token to access Fluree On-Demand
 *     
 */
flureedb.transact = (function flureedb$transact(var_args){
var G__79821 = arguments.length;
switch (G__79821) {
case 3:
return flureedb.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.transact', flureedb.transact);

(flureedb.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureedb.transact.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(flureedb.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_79847){
var state_val_79848 = (state_79847[(1)]);
if((state_val_79848 === (7))){
var inst_79833 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_79847__$1 = state_79847;
var statearr_79849_79870 = state_79847__$1;
(statearr_79849_79870[(2)] = inst_79833);

(statearr_79849_79870[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79848 === (1))){
var state_79847__$1 = state_79847;
var statearr_79850_79871 = state_79847__$1;
(statearr_79850_79871[(2)] = null);

(statearr_79850_79871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79848 === (4))){
var inst_79822 = (state_79847[(2)]);
var inst_79823 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79822], 0));
var inst_79824 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_79822) : reject.call(null,inst_79822));
var state_79847__$1 = (function (){var statearr_79851 = state_79847;
(statearr_79851[(7)] = inst_79823);

return statearr_79851;
})();
var statearr_79852_79872 = state_79847__$1;
(statearr_79852_79872[(2)] = inst_79824);

(statearr_79852_79872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79848 === (6))){
var state_79847__$1 = state_79847;
var statearr_79853_79873 = state_79847__$1;
(statearr_79853_79873[(2)] = null);

(statearr_79853_79873[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79848 === (3))){
var inst_79845 = (state_79847[(2)]);
var state_79847__$1 = state_79847;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79847__$1,inst_79845);
} else {
if((state_val_79848 === (2))){
var _ = (function (){var statearr_79855 = state_79847;
(statearr_79855[(4)] = cljs.core.cons((5),(state_79847[(4)])));

return statearr_79855;
})();
var inst_79830 = (opts == null);
var state_79847__$1 = state_79847;
if(cljs.core.truth_(inst_79830)){
var statearr_79856_79874 = state_79847__$1;
(statearr_79856_79874[(1)] = (6));

} else {
var statearr_79857_79875 = state_79847__$1;
(statearr_79857_79875[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79848 === (9))){
var inst_79840 = (state_79847[(2)]);
var inst_79841 = cljs.core.clj__GT_js(inst_79840);
var inst_79842 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_79841) : resolve.call(null,inst_79841));
var _ = (function (){var statearr_79858 = state_79847;
(statearr_79858[(4)] = cljs.core.rest((state_79847[(4)])));

return statearr_79858;
})();
var state_79847__$1 = state_79847;
var statearr_79859_79876 = state_79847__$1;
(statearr_79859_79876[(2)] = inst_79842);

(statearr_79859_79876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79848 === (5))){
var _ = (function (){var statearr_79860 = state_79847;
(statearr_79860[(4)] = cljs.core.rest((state_79847[(4)])));

return statearr_79860;
})();
var state_79847__$1 = state_79847;
var ex79854 = (state_79847__$1[(2)]);
var statearr_79861_79877 = state_79847__$1;
(statearr_79861_79877[(5)] = ex79854);


var statearr_79862_79878 = state_79847__$1;
(statearr_79862_79878[(1)] = (4));

(statearr_79862_79878[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79848 === (8))){
var inst_79835 = (state_79847[(2)]);
var inst_79836 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_79835);
var inst_79837 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(txn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_79838 = fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_79837,inst_79835);
var state_79847__$1 = (function (){var statearr_79863 = state_79847;
(statearr_79863[(8)] = inst_79836);

return statearr_79863;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79847__$1,(9),inst_79838);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__11438__auto__ = null;
var flureedb$state_machine__11438__auto____0 = (function (){
var statearr_79864 = [null,null,null,null,null,null,null,null,null];
(statearr_79864[(0)] = flureedb$state_machine__11438__auto__);

(statearr_79864[(1)] = (1));

return statearr_79864;
});
var flureedb$state_machine__11438__auto____1 = (function (state_79847){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_79847);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e79865){var ex__11441__auto__ = e79865;
var statearr_79866_79879 = state_79847;
(statearr_79866_79879[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_79847[(4)]))){
var statearr_79867_79880 = state_79847;
(statearr_79867_79880[(1)] = cljs.core.first((state_79847[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79881 = state_79847;
state_79847 = G__79881;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
flureedb$state_machine__11438__auto__ = function(state_79847){
switch(arguments.length){
case 0:
return flureedb$state_machine__11438__auto____0.call(this);
case 1:
return flureedb$state_machine__11438__auto____1.call(this,state_79847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__11438__auto____0;
flureedb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__11438__auto____1;
return flureedb$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_79868 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_79868[(6)] = c__11512__auto__);

return statearr_79868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
}));

(flureedb.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *    to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *    :t and :flakes.
 */
flureedb.block_range = (function flureedb$block_range(var_args){
var G__79883 = arguments.length;
switch (G__79883) {
case 3:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range', flureedb.block_range);

(flureedb.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,start,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,end,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_79912){
var state_val_79913 = (state_79912[(1)]);
if((state_val_79913 === (7))){
var inst_79895 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_79912__$1 = state_79912;
var statearr_79914_79935 = state_79912__$1;
(statearr_79914_79935[(2)] = inst_79895);

(statearr_79914_79935[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79913 === (1))){
var state_79912__$1 = state_79912;
var statearr_79915_79936 = state_79912__$1;
(statearr_79915_79936[(2)] = null);

(statearr_79915_79936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79913 === (4))){
var inst_79884 = (state_79912[(2)]);
var inst_79885 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79884], 0));
var inst_79886 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_79884) : reject.call(null,inst_79884));
var state_79912__$1 = (function (){var statearr_79916 = state_79912;
(statearr_79916[(7)] = inst_79885);

return statearr_79916;
})();
var statearr_79917_79937 = state_79912__$1;
(statearr_79917_79937[(2)] = inst_79886);

(statearr_79917_79937[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79913 === (6))){
var state_79912__$1 = state_79912;
var statearr_79918_79938 = state_79912__$1;
(statearr_79918_79938[(2)] = null);

(statearr_79918_79938[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79913 === (3))){
var inst_79910 = (state_79912[(2)]);
var state_79912__$1 = state_79912;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79912__$1,inst_79910);
} else {
if((state_val_79913 === (2))){
var _ = (function (){var statearr_79920 = state_79912;
(statearr_79920[(4)] = cljs.core.cons((5),(state_79912[(4)])));

return statearr_79920;
})();
var inst_79892 = (opts == null);
var state_79912__$1 = state_79912;
if(cljs.core.truth_(inst_79892)){
var statearr_79921_79939 = state_79912__$1;
(statearr_79921_79939[(1)] = (6));

} else {
var statearr_79922_79940 = state_79912__$1;
(statearr_79922_79940[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79913 === (9))){
var inst_79897 = (state_79912[(8)]);
var inst_79900 = (state_79912[(2)]);
var inst_79901 = fluree.db.util.async.throw_err(inst_79900);
var inst_79902 = fluree.db.query.block.block_range(inst_79901,start,end,inst_79897);
var state_79912__$1 = state_79912;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79912__$1,(10),inst_79902);
} else {
if((state_val_79913 === (5))){
var _ = (function (){var statearr_79923 = state_79912;
(statearr_79923[(4)] = cljs.core.rest((state_79912[(4)])));

return statearr_79923;
})();
var state_79912__$1 = state_79912;
var ex79919 = (state_79912__$1[(2)]);
var statearr_79924_79941 = state_79912__$1;
(statearr_79924_79941[(5)] = ex79919);


var statearr_79925_79942 = state_79912__$1;
(statearr_79925_79942[(1)] = (4));

(statearr_79925_79942[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79913 === (10))){
var inst_79904 = (state_79912[(2)]);
var inst_79905 = fluree.db.util.async.throw_err(inst_79904);
var inst_79906 = cljs.core.clj__GT_js(inst_79905);
var inst_79907 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_79906) : resolve.call(null,inst_79906));
var _ = (function (){var statearr_79926 = state_79912;
(statearr_79926[(4)] = cljs.core.rest((state_79912[(4)])));

return statearr_79926;
})();
var state_79912__$1 = state_79912;
var statearr_79927_79943 = state_79912__$1;
(statearr_79927_79943[(2)] = inst_79907);

(statearr_79927_79943[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79913 === (8))){
var inst_79897 = (state_79912[(8)]);
var inst_79897__$1 = (state_79912[(2)]);
var inst_79898 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79897__$1], 0));
var state_79912__$1 = (function (){var statearr_79928 = state_79912;
(statearr_79928[(8)] = inst_79897__$1);

return statearr_79928;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79912__$1,(9),inst_79898);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__11438__auto__ = null;
var flureedb$state_machine__11438__auto____0 = (function (){
var statearr_79929 = [null,null,null,null,null,null,null,null,null];
(statearr_79929[(0)] = flureedb$state_machine__11438__auto__);

(statearr_79929[(1)] = (1));

return statearr_79929;
});
var flureedb$state_machine__11438__auto____1 = (function (state_79912){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_79912);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e79930){var ex__11441__auto__ = e79930;
var statearr_79931_79944 = state_79912;
(statearr_79931_79944[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_79912[(4)]))){
var statearr_79932_79945 = state_79912;
(statearr_79932_79945[(1)] = cljs.core.first((state_79912[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79946 = state_79912;
state_79912 = G__79946;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
flureedb$state_machine__11438__auto__ = function(state_79912){
switch(arguments.length){
case 0:
return flureedb$state_machine__11438__auto____0.call(this);
case 1:
return flureedb$state_machine__11438__auto____1.call(this,state_79912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__11438__auto____0;
flureedb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__11438__auto____1;
return flureedb$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_79933 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_79933[(6)] = c__11512__auto__);

return statearr_79933;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
}));

(flureedb.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 *     start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 *     containing keys :block :tx
 */
flureedb.block_range_with_txn = (function flureedb$block_range_with_txn(var_args){
var G__79948 = arguments.length;
switch (G__79948) {
case 3:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range_with_txn', flureedb.block_range_with_txn);

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4(conn,ledger,block_map,null);
}));

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_79983){
var state_val_79984 = (state_79983[(1)]);
if((state_val_79984 === (7))){
var inst_79961 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_79983__$1 = state_79983;
var statearr_79985_80006 = state_79983__$1;
(statearr_79985_80006[(2)] = inst_79961);

(statearr_79985_80006[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79984 === (1))){
var state_79983__$1 = state_79983;
var statearr_79986_80007 = state_79983__$1;
(statearr_79986_80007[(2)] = null);

(statearr_79986_80007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79984 === (4))){
var inst_79949 = (state_79983[(2)]);
var inst_79950 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79949], 0));
var inst_79951 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_79949) : reject.call(null,inst_79949));
var state_79983__$1 = (function (){var statearr_79987 = state_79983;
(statearr_79987[(7)] = inst_79950);

return statearr_79987;
})();
var statearr_79988_80008 = state_79983__$1;
(statearr_79988_80008[(2)] = inst_79951);

(statearr_79988_80008[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79984 === (6))){
var state_79983__$1 = state_79983;
var statearr_79989_80009 = state_79983__$1;
(statearr_79989_80009[(2)] = null);

(statearr_79989_80009[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79984 === (3))){
var inst_79981 = (state_79983[(2)]);
var state_79983__$1 = state_79983;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79983__$1,inst_79981);
} else {
if((state_val_79984 === (2))){
var _ = (function (){var statearr_79991 = state_79983;
(statearr_79991[(4)] = cljs.core.cons((5),(state_79983[(4)])));

return statearr_79991;
})();
var inst_79958 = (opts == null);
var state_79983__$1 = state_79983;
if(cljs.core.truth_(inst_79958)){
var statearr_79992_80010 = state_79983__$1;
(statearr_79992_80010[(1)] = (6));

} else {
var statearr_79993_80011 = state_79983__$1;
(statearr_79993_80011[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79984 === (9))){
var inst_79963 = (state_79983[(8)]);
var inst_79967 = (state_79983[(9)]);
var inst_79966 = (state_79983[(10)]);
var inst_79970 = (state_79983[(2)]);
var inst_79971 = fluree.db.util.async.throw_err(inst_79970);
var inst_79972 = fluree.db.query.block.block_range(inst_79971,inst_79966,inst_79967,inst_79963);
var state_79983__$1 = state_79983;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79983__$1,(10),inst_79972);
} else {
if((state_val_79984 === (5))){
var _ = (function (){var statearr_79994 = state_79983;
(statearr_79994[(4)] = cljs.core.rest((state_79983[(4)])));

return statearr_79994;
})();
var state_79983__$1 = state_79983;
var ex79990 = (state_79983__$1[(2)]);
var statearr_79995_80012 = state_79983__$1;
(statearr_79995_80012[(5)] = ex79990);


var statearr_79996_80013 = state_79983__$1;
(statearr_79996_80013[(1)] = (4));

(statearr_79996_80013[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79984 === (10))){
var inst_79974 = (state_79983[(2)]);
var inst_79975 = fluree.db.util.async.throw_err(inst_79974);
var inst_79976 = fluree.db.query.range.block_with_tx_data(inst_79975);
var inst_79977 = cljs.core.clj__GT_js(inst_79976);
var inst_79978 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_79977) : resolve.call(null,inst_79977));
var _ = (function (){var statearr_79997 = state_79983;
(statearr_79997[(4)] = cljs.core.rest((state_79983[(4)])));

return statearr_79997;
})();
var state_79983__$1 = state_79983;
var statearr_79998_80014 = state_79983__$1;
(statearr_79998_80014[(2)] = inst_79978);

(statearr_79998_80014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79984 === (8))){
var inst_79963 = (state_79983[(8)]);
var inst_79963__$1 = (state_79983[(2)]);
var inst_79964 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(block_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_79965 = cljs.core.__destructure_map(inst_79964);
var inst_79966 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79965,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_79967 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79965,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_79968 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79963__$1], 0));
var state_79983__$1 = (function (){var statearr_79999 = state_79983;
(statearr_79999[(8)] = inst_79963__$1);

(statearr_79999[(9)] = inst_79967);

(statearr_79999[(10)] = inst_79966);

return statearr_79999;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79983__$1,(9),inst_79968);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__11438__auto__ = null;
var flureedb$state_machine__11438__auto____0 = (function (){
var statearr_80000 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_80000[(0)] = flureedb$state_machine__11438__auto__);

(statearr_80000[(1)] = (1));

return statearr_80000;
});
var flureedb$state_machine__11438__auto____1 = (function (state_79983){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_79983);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e80001){var ex__11441__auto__ = e80001;
var statearr_80002_80015 = state_79983;
(statearr_80002_80015[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_79983[(4)]))){
var statearr_80003_80016 = state_79983;
(statearr_80003_80016[(1)] = cljs.core.first((state_79983[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80017 = state_79983;
state_79983 = G__80017;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
flureedb$state_machine__11438__auto__ = function(state_79983){
switch(arguments.length){
case 0:
return flureedb$state_machine__11438__auto____0.call(this);
case 1:
return flureedb$state_machine__11438__auto____1.call(this,state_79983);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__11438__auto____0;
flureedb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__11438__auto____1;
return flureedb$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_80004 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_80004[(6)] = c__11512__auto__);

return statearr_80004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
}));

(flureedb.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureedb.block_query = (function flureedb$block_query(var_args){
var G__80019 = arguments.length;
switch (G__80019) {
case 3:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_query', flureedb.block_query);

(flureedb.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_80086){
var state_val_80087 = (state_80086[(1)]);
if((state_val_80087 === (7))){
var inst_80032 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_80086__$1 = state_80086;
var statearr_80088_80129 = state_80086__$1;
(statearr_80088_80129[(2)] = inst_80032);

(statearr_80088_80129[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (20))){
var inst_80028 = (state_80086[(7)]);
var inst_80034 = (state_80086[(8)]);
var inst_80070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80071 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_80072 = (new cljs.core.PersistentVector(null,1,(5),inst_80070,inst_80071,null));
var inst_80073 = cljs.core.assoc_in(inst_80034,inst_80072,new cljs.core.Keyword(null,"block","block",664686210));
var inst_80074 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_80028,inst_80073);
var state_80086__$1 = state_80086;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80086__$1,(23),inst_80074);
} else {
if((state_val_80087 === (1))){
var state_80086__$1 = state_80086;
var statearr_80089_80130 = state_80086__$1;
(statearr_80089_80130[(2)] = null);

(statearr_80089_80130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (4))){
var inst_80020 = (state_80086[(2)]);
var inst_80021 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_80020], 0));
var inst_80022 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_80020) : reject.call(null,inst_80020));
var state_80086__$1 = (function (){var statearr_80090 = state_80086;
(statearr_80090[(9)] = inst_80021);

return statearr_80090;
})();
var statearr_80091_80131 = state_80086__$1;
(statearr_80091_80131[(2)] = inst_80022);

(statearr_80091_80131[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (15))){
var inst_80058 = (state_80086[(2)]);
var inst_80059 = fluree.db.util.async.throw_err(inst_80058);
var state_80086__$1 = state_80086;
var statearr_80092_80132 = state_80086__$1;
(statearr_80092_80132[(2)] = inst_80059);

(statearr_80092_80132[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (21))){
var inst_80079 = (state_80086[(2)]);
var inst_80080 = cljs.core.clj__GT_js(inst_80079);
var inst_80081 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_80080) : resolve.call(null,inst_80080));
var _ = (function (){var statearr_80093 = state_80086;
(statearr_80093[(4)] = cljs.core.rest((state_80086[(4)])));

return statearr_80093;
})();
var state_80086__$1 = state_80086;
var statearr_80094_80133 = state_80086__$1;
(statearr_80094_80133[(2)] = inst_80081);

(statearr_80094_80133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (13))){
var state_80086__$1 = state_80086;
var statearr_80095_80134 = state_80086__$1;
(statearr_80095_80134[(2)] = null);

(statearr_80095_80134[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (22))){
var inst_80067 = (state_80086[(2)]);
var inst_80068 = fluree.db.util.async.throw_err(inst_80067);
var state_80086__$1 = state_80086;
var statearr_80096_80135 = state_80086__$1;
(statearr_80096_80135[(2)] = inst_80068);

(statearr_80096_80135[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (6))){
var state_80086__$1 = state_80086;
var statearr_80097_80136 = state_80086__$1;
(statearr_80097_80136[(2)] = null);

(statearr_80097_80136[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (17))){
var state_80086__$1 = state_80086;
var statearr_80098_80137 = state_80086__$1;
(statearr_80098_80137[(2)] = null);

(statearr_80098_80137[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (3))){
var inst_80084 = (state_80086[(2)]);
var state_80086__$1 = state_80086;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80086__$1,inst_80084);
} else {
if((state_val_80087 === (12))){
var inst_80042 = (state_80086[(10)]);
var inst_80046 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_80086__$1 = (function (){var statearr_80099 = state_80086;
(statearr_80099[(11)] = inst_80046);

return statearr_80099;
})();
if(cljs.core.truth_(inst_80042)){
var statearr_80100_80138 = state_80086__$1;
(statearr_80100_80138[(1)] = (16));

} else {
var statearr_80101_80139 = state_80086__$1;
(statearr_80101_80139[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (2))){
var _ = (function (){var statearr_80102 = state_80086;
(statearr_80102[(4)] = cljs.core.cons((5),(state_80086[(4)])));

return statearr_80102;
})();
var inst_80028 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_80029 = (opts == null);
var state_80086__$1 = (function (){var statearr_80103 = state_80086;
(statearr_80103[(7)] = inst_80028);

return statearr_80103;
})();
if(cljs.core.truth_(inst_80029)){
var statearr_80104_80140 = state_80086__$1;
(statearr_80104_80140[(1)] = (6));

} else {
var statearr_80105_80141 = state_80086__$1;
(statearr_80105_80141[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (23))){
var inst_80076 = (state_80086[(2)]);
var inst_80077 = fluree.db.util.async.throw_err(inst_80076);
var state_80086__$1 = state_80086;
var statearr_80106_80142 = state_80086__$1;
(statearr_80106_80142[(2)] = inst_80077);

(statearr_80106_80142[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (19))){
var inst_80028 = (state_80086[(7)]);
var inst_80034 = (state_80086[(8)]);
var inst_80062 = (state_80086[(12)]);
var inst_80065 = fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(inst_80062,inst_80028,inst_80034);
var state_80086__$1 = state_80086;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80086__$1,(22),inst_80065);
} else {
if((state_val_80087 === (11))){
var inst_80036 = (state_80086[(13)]);
var inst_80034 = (state_80086[(8)]);
var inst_80042 = (state_80086[(2)]);
var inst_80043 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_80034);
var inst_80044 = (inst_80036 == null);
var state_80086__$1 = (function (){var statearr_80108 = state_80086;
(statearr_80108[(10)] = inst_80042);

(statearr_80108[(14)] = inst_80043);

return statearr_80108;
})();
if(cljs.core.truth_(inst_80044)){
var statearr_80109_80143 = state_80086__$1;
(statearr_80109_80143[(1)] = (12));

} else {
var statearr_80110_80144 = state_80086__$1;
(statearr_80110_80144[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (9))){
var inst_80037 = (state_80086[(15)]);
var state_80086__$1 = state_80086;
var statearr_80111_80145 = state_80086__$1;
(statearr_80111_80145[(2)] = inst_80037);

(statearr_80111_80145[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (5))){
var _ = (function (){var statearr_80112 = state_80086;
(statearr_80112[(4)] = cljs.core.rest((state_80086[(4)])));

return statearr_80112;
})();
var state_80086__$1 = state_80086;
var ex80107 = (state_80086__$1[(2)]);
var statearr_80113_80146 = state_80086__$1;
(statearr_80113_80146[(5)] = ex80107);


var statearr_80114_80147 = state_80086__$1;
(statearr_80114_80147[(1)] = (4));

(statearr_80114_80147[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (14))){
var inst_80036 = (state_80086[(13)]);
var inst_80062 = (state_80086[(2)]);
var inst_80063 = (inst_80036 == null);
var state_80086__$1 = (function (){var statearr_80115 = state_80086;
(statearr_80115[(12)] = inst_80062);

return statearr_80115;
})();
if(cljs.core.truth_(inst_80063)){
var statearr_80116_80148 = state_80086__$1;
(statearr_80116_80148[(1)] = (19));

} else {
var statearr_80117_80149 = state_80086__$1;
(statearr_80117_80149[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (16))){
var inst_80042 = (state_80086[(10)]);
var inst_80048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80049 = ["_auth/id",inst_80042];
var inst_80050 = (new cljs.core.PersistentVector(null,2,(5),inst_80048,inst_80049,null));
var state_80086__$1 = state_80086;
var statearr_80118_80150 = state_80086__$1;
(statearr_80118_80150[(2)] = inst_80050);

(statearr_80118_80150[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (10))){
var inst_80034 = (state_80086[(8)]);
var inst_80040 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_80034);
var state_80086__$1 = state_80086;
var statearr_80119_80151 = state_80086__$1;
(statearr_80119_80151[(2)] = inst_80040);

(statearr_80119_80151[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80087 === (18))){
var inst_80046 = (state_80086[(11)]);
var inst_80043 = (state_80086[(14)]);
var inst_80053 = (state_80086[(2)]);
var inst_80054 = [inst_80053,inst_80043];
var inst_80055 = cljs.core.PersistentHashMap.fromArrays(inst_80046,inst_80054);
var inst_80056 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_80055], 0));
var state_80086__$1 = state_80086;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80086__$1,(15),inst_80056);
} else {
if((state_val_80087 === (8))){
var inst_80037 = (state_80086[(15)]);
var inst_80034 = (state_80086[(8)]);
var inst_80034__$1 = (state_80086[(2)]);
var inst_80035 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_80034__$1);
var inst_80036 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_80034__$1);
var inst_80037__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_80034__$1);
var state_80086__$1 = (function (){var statearr_80120 = state_80086;
(statearr_80120[(16)] = inst_80035);

(statearr_80120[(15)] = inst_80037__$1);

(statearr_80120[(13)] = inst_80036);

(statearr_80120[(8)] = inst_80034__$1);

return statearr_80120;
})();
if(cljs.core.truth_(inst_80037__$1)){
var statearr_80121_80152 = state_80086__$1;
(statearr_80121_80152[(1)] = (9));

} else {
var statearr_80122_80153 = state_80086__$1;
(statearr_80122_80153[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__11438__auto__ = null;
var flureedb$state_machine__11438__auto____0 = (function (){
var statearr_80123 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80123[(0)] = flureedb$state_machine__11438__auto__);

(statearr_80123[(1)] = (1));

return statearr_80123;
});
var flureedb$state_machine__11438__auto____1 = (function (state_80086){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_80086);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e80124){var ex__11441__auto__ = e80124;
var statearr_80125_80154 = state_80086;
(statearr_80125_80154[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_80086[(4)]))){
var statearr_80126_80155 = state_80086;
(statearr_80126_80155[(1)] = cljs.core.first((state_80086[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80156 = state_80086;
state_80086 = G__80156;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
flureedb$state_machine__11438__auto__ = function(state_80086){
switch(arguments.length){
case 0:
return flureedb$state_machine__11438__auto____0.call(this);
case 1:
return flureedb$state_machine__11438__auto____1.call(this,state_80086);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__11438__auto____0;
flureedb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__11438__auto____1;
return flureedb$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_80127 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_80127[(6)] = c__11512__auto__);

return statearr_80127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
}));

(flureedb.block_query.cljs$lang$maxFixedArity = 4);

flureedb.history_query = (function flureedb$history_query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_80176){
var state_val_80177 = (state_80176[(1)]);
if((state_val_80177 === (1))){
var state_80176__$1 = state_80176;
var statearr_80178_80193 = state_80176__$1;
(statearr_80178_80193[(2)] = null);

(statearr_80178_80193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80177 === (2))){
var _ = (function (){var statearr_80179 = state_80176;
(statearr_80179[(4)] = cljs.core.cons((5),(state_80176[(4)])));

return statearr_80179;
})();
var inst_80165 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_80166 = fluree.db.api.query.history_query_async(sources,inst_80165);
var state_80176__$1 = state_80176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80176__$1,(6),inst_80166);
} else {
if((state_val_80177 === (3))){
var inst_80174 = (state_80176[(2)]);
var state_80176__$1 = state_80176;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80176__$1,inst_80174);
} else {
if((state_val_80177 === (4))){
var inst_80157 = (state_80176[(2)]);
var inst_80158 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_80157], 0));
var inst_80159 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_80157) : reject.call(null,inst_80157));
var state_80176__$1 = (function (){var statearr_80181 = state_80176;
(statearr_80181[(7)] = inst_80158);

return statearr_80181;
})();
var statearr_80182_80194 = state_80176__$1;
(statearr_80182_80194[(2)] = inst_80159);

(statearr_80182_80194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80177 === (5))){
var _ = (function (){var statearr_80183 = state_80176;
(statearr_80183[(4)] = cljs.core.rest((state_80176[(4)])));

return statearr_80183;
})();
var state_80176__$1 = state_80176;
var ex80180 = (state_80176__$1[(2)]);
var statearr_80184_80195 = state_80176__$1;
(statearr_80184_80195[(5)] = ex80180);


var statearr_80185_80196 = state_80176__$1;
(statearr_80185_80196[(1)] = (4));

(statearr_80185_80196[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80177 === (6))){
var inst_80168 = (state_80176[(2)]);
var inst_80169 = fluree.db.util.async.throw_err(inst_80168);
var inst_80170 = cljs.core.clj__GT_js(inst_80169);
var inst_80171 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_80170) : resolve.call(null,inst_80170));
var _ = (function (){var statearr_80186 = state_80176;
(statearr_80186[(4)] = cljs.core.rest((state_80176[(4)])));

return statearr_80186;
})();
var state_80176__$1 = state_80176;
var statearr_80187_80197 = state_80176__$1;
(statearr_80187_80197[(2)] = inst_80171);

(statearr_80187_80197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$history_query_$_state_machine__11438__auto__ = null;
var flureedb$history_query_$_state_machine__11438__auto____0 = (function (){
var statearr_80188 = [null,null,null,null,null,null,null,null];
(statearr_80188[(0)] = flureedb$history_query_$_state_machine__11438__auto__);

(statearr_80188[(1)] = (1));

return statearr_80188;
});
var flureedb$history_query_$_state_machine__11438__auto____1 = (function (state_80176){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_80176);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e80189){var ex__11441__auto__ = e80189;
var statearr_80190_80198 = state_80176;
(statearr_80190_80198[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_80176[(4)]))){
var statearr_80191_80199 = state_80176;
(statearr_80191_80199[(1)] = cljs.core.first((state_80176[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80200 = state_80176;
state_80176 = G__80200;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
flureedb$history_query_$_state_machine__11438__auto__ = function(state_80176){
switch(arguments.length){
case 0:
return flureedb$history_query_$_state_machine__11438__auto____0.call(this);
case 1:
return flureedb$history_query_$_state_machine__11438__auto____1.call(this,state_80176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$history_query_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$history_query_$_state_machine__11438__auto____0;
flureedb$history_query_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$history_query_$_state_machine__11438__auto____1;
return flureedb$history_query_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_80192 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_80192[(6)] = c__11512__auto__);

return statearr_80192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
});
goog.exportSymbol('flureedb.history_query', flureedb.history_query);
flureedb.multi_query = (function flureedb$multi_query(sources,multi_query_map){
return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_80220){
var state_val_80221 = (state_80220[(1)]);
if((state_val_80221 === (1))){
var state_80220__$1 = state_80220;
var statearr_80222_80237 = state_80220__$1;
(statearr_80222_80237[(2)] = null);

(statearr_80222_80237[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (2))){
var _ = (function (){var statearr_80223 = state_80220;
(statearr_80223[(4)] = cljs.core.cons((5),(state_80220[(4)])));

return statearr_80223;
})();
var inst_80209 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(multi_query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_80210 = fluree.db.api.query.multi_query_async(sources,inst_80209);
var state_80220__$1 = state_80220;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80220__$1,(6),inst_80210);
} else {
if((state_val_80221 === (3))){
var inst_80218 = (state_80220[(2)]);
var state_80220__$1 = state_80220;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80220__$1,inst_80218);
} else {
if((state_val_80221 === (4))){
var inst_80201 = (state_80220[(2)]);
var inst_80202 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_80201], 0));
var inst_80203 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_80201) : reject.call(null,inst_80201));
var state_80220__$1 = (function (){var statearr_80225 = state_80220;
(statearr_80225[(7)] = inst_80202);

return statearr_80225;
})();
var statearr_80226_80238 = state_80220__$1;
(statearr_80226_80238[(2)] = inst_80203);

(statearr_80226_80238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (5))){
var _ = (function (){var statearr_80227 = state_80220;
(statearr_80227[(4)] = cljs.core.rest((state_80220[(4)])));

return statearr_80227;
})();
var state_80220__$1 = state_80220;
var ex80224 = (state_80220__$1[(2)]);
var statearr_80228_80239 = state_80220__$1;
(statearr_80228_80239[(5)] = ex80224);


var statearr_80229_80240 = state_80220__$1;
(statearr_80229_80240[(1)] = (4));

(statearr_80229_80240[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (6))){
var inst_80212 = (state_80220[(2)]);
var inst_80213 = fluree.db.util.async.throw_err(inst_80212);
var inst_80214 = cljs.core.clj__GT_js(inst_80213);
var inst_80215 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_80214) : resolve.call(null,inst_80214));
var _ = (function (){var statearr_80230 = state_80220;
(statearr_80230[(4)] = cljs.core.rest((state_80220[(4)])));

return statearr_80230;
})();
var state_80220__$1 = state_80220;
var statearr_80231_80241 = state_80220__$1;
(statearr_80231_80241[(2)] = inst_80215);

(statearr_80231_80241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$multi_query_$_state_machine__11438__auto__ = null;
var flureedb$multi_query_$_state_machine__11438__auto____0 = (function (){
var statearr_80232 = [null,null,null,null,null,null,null,null];
(statearr_80232[(0)] = flureedb$multi_query_$_state_machine__11438__auto__);

(statearr_80232[(1)] = (1));

return statearr_80232;
});
var flureedb$multi_query_$_state_machine__11438__auto____1 = (function (state_80220){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_80220);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e80233){var ex__11441__auto__ = e80233;
var statearr_80234_80242 = state_80220;
(statearr_80234_80242[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_80220[(4)]))){
var statearr_80235_80243 = state_80220;
(statearr_80235_80243[(1)] = cljs.core.first((state_80220[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80244 = state_80220;
state_80220 = G__80244;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
flureedb$multi_query_$_state_machine__11438__auto__ = function(state_80220){
switch(arguments.length){
case 0:
return flureedb$multi_query_$_state_machine__11438__auto____0.call(this);
case 1:
return flureedb$multi_query_$_state_machine__11438__auto____1.call(this,state_80220);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$multi_query_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$multi_query_$_state_machine__11438__auto____0;
flureedb$multi_query_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$multi_query_$_state_machine__11438__auto____1;
return flureedb$multi_query_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_80236 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_80236[(6)] = c__11512__auto__);

return statearr_80236;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
});
goog.exportSymbol('flureedb.multi_query', flureedb.multi_query);
/**
 * Execute a query against a database source, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise containing results.
 */
flureedb.query = (function flureedb$query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_80264){
var state_val_80265 = (state_80264[(1)]);
if((state_val_80265 === (1))){
var state_80264__$1 = state_80264;
var statearr_80266_80281 = state_80264__$1;
(statearr_80266_80281[(2)] = null);

(statearr_80266_80281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80265 === (2))){
var _ = (function (){var statearr_80267 = state_80264;
(statearr_80267[(4)] = cljs.core.cons((5),(state_80264[(4)])));

return statearr_80267;
})();
var inst_80254 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_80255 = fluree.db.api.query.query_async(sources,inst_80254);
var state_80264__$1 = state_80264;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80264__$1,(6),inst_80255);
} else {
if((state_val_80265 === (3))){
var inst_80262 = (state_80264[(2)]);
var state_80264__$1 = state_80264;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80264__$1,inst_80262);
} else {
if((state_val_80265 === (4))){
var inst_80245 = (state_80264[(2)]);
var inst_80246 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_80245], 0));
var inst_80247 = cljs.core.clj__GT_js(inst_80245);
var inst_80248 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_80247) : reject.call(null,inst_80247));
var state_80264__$1 = (function (){var statearr_80269 = state_80264;
(statearr_80269[(7)] = inst_80246);

return statearr_80269;
})();
var statearr_80270_80282 = state_80264__$1;
(statearr_80270_80282[(2)] = inst_80248);

(statearr_80270_80282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80265 === (5))){
var _ = (function (){var statearr_80271 = state_80264;
(statearr_80271[(4)] = cljs.core.rest((state_80264[(4)])));

return statearr_80271;
})();
var state_80264__$1 = state_80264;
var ex80268 = (state_80264__$1[(2)]);
var statearr_80272_80283 = state_80264__$1;
(statearr_80272_80283[(5)] = ex80268);


var statearr_80273_80284 = state_80264__$1;
(statearr_80273_80284[(1)] = (4));

(statearr_80273_80284[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80265 === (6))){
var inst_80257 = (state_80264[(2)]);
var inst_80258 = cljs.core.clj__GT_js(inst_80257);
var inst_80259 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_80258) : resolve.call(null,inst_80258));
var _ = (function (){var statearr_80274 = state_80264;
(statearr_80274[(4)] = cljs.core.rest((state_80264[(4)])));

return statearr_80274;
})();
var state_80264__$1 = state_80264;
var statearr_80275_80285 = state_80264__$1;
(statearr_80275_80285[(2)] = inst_80259);

(statearr_80275_80285[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$query_$_state_machine__11438__auto__ = null;
var flureedb$query_$_state_machine__11438__auto____0 = (function (){
var statearr_80276 = [null,null,null,null,null,null,null,null];
(statearr_80276[(0)] = flureedb$query_$_state_machine__11438__auto__);

(statearr_80276[(1)] = (1));

return statearr_80276;
});
var flureedb$query_$_state_machine__11438__auto____1 = (function (state_80264){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_80264);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e80277){var ex__11441__auto__ = e80277;
var statearr_80278_80286 = state_80264;
(statearr_80278_80286[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_80264[(4)]))){
var statearr_80279_80287 = state_80264;
(statearr_80279_80287[(1)] = cljs.core.first((state_80264[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80288 = state_80264;
state_80264 = G__80288;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
flureedb$query_$_state_machine__11438__auto__ = function(state_80264){
switch(arguments.length){
case 0:
return flureedb$query_$_state_machine__11438__auto____0.call(this);
case 1:
return flureedb$query_$_state_machine__11438__auto____1.call(this,state_80264);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$query_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$query_$_state_machine__11438__auto____0;
flureedb$query_$_state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$query_$_state_machine__11438__auto____1;
return flureedb$query_$_state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_80280 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_80280[(6)] = c__11512__auto__);

return statearr_80280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
});
goog.exportSymbol('flureedb.query', flureedb.query);
/**
 * Execute a query against a ledger, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise containing results.
 */
flureedb.signed_query = (function flureedb$signed_query(var_args){
var G__80290 = arguments.length;
switch (G__80290) {
case 3:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.signed_query', flureedb.signed_query);

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__11512__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11513__auto__ = (function (){var switch__11437__auto__ = (function (state_80317){
var state_val_80318 = (state_80317[(1)]);
if((state_val_80318 === (7))){
var inst_80304 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_80317__$1 = state_80317;
var statearr_80319_80340 = state_80317__$1;
(statearr_80319_80340[(2)] = inst_80304);

(statearr_80319_80340[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80318 === (1))){
var state_80317__$1 = state_80317;
var statearr_80320_80341 = state_80317__$1;
(statearr_80320_80341[(2)] = null);

(statearr_80320_80341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80318 === (4))){
var inst_80291 = (state_80317[(2)]);
var inst_80292 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_80291], 0));
var inst_80293 = cljs.core.clj__GT_js(inst_80291);
var inst_80294 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_80293) : reject.call(null,inst_80293));
var state_80317__$1 = (function (){var statearr_80321 = state_80317;
(statearr_80321[(7)] = inst_80292);

return statearr_80321;
})();
var statearr_80322_80342 = state_80317__$1;
(statearr_80322_80342[(2)] = inst_80294);

(statearr_80322_80342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80318 === (6))){
var state_80317__$1 = state_80317;
var statearr_80323_80343 = state_80317__$1;
(statearr_80323_80343[(2)] = null);

(statearr_80323_80343[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80318 === (3))){
var inst_80315 = (state_80317[(2)]);
var state_80317__$1 = state_80317;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80317__$1,inst_80315);
} else {
if((state_val_80318 === (2))){
var _ = (function (){var statearr_80325 = state_80317;
(statearr_80325[(4)] = cljs.core.cons((5),(state_80317[(4)])));

return statearr_80325;
})();
var inst_80300 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_80301 = (opts == null);
var state_80317__$1 = (function (){var statearr_80326 = state_80317;
(statearr_80326[(8)] = inst_80300);

return statearr_80326;
})();
if(cljs.core.truth_(inst_80301)){
var statearr_80327_80344 = state_80317__$1;
(statearr_80327_80344[(1)] = (6));

} else {
var statearr_80328_80345 = state_80317__$1;
(statearr_80328_80345[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80318 === (9))){
var inst_80309 = (state_80317[(2)]);
var inst_80310 = fluree.db.util.async.throw_err(inst_80309);
var inst_80311 = cljs.core.clj__GT_js(inst_80310);
var inst_80312 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_80311) : resolve.call(null,inst_80311));
var _ = (function (){var statearr_80329 = state_80317;
(statearr_80329[(4)] = cljs.core.rest((state_80317[(4)])));

return statearr_80329;
})();
var state_80317__$1 = state_80317;
var statearr_80330_80346 = state_80317__$1;
(statearr_80330_80346[(2)] = inst_80312);

(statearr_80330_80346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80318 === (5))){
var _ = (function (){var statearr_80331 = state_80317;
(statearr_80331[(4)] = cljs.core.rest((state_80317[(4)])));

return statearr_80331;
})();
var state_80317__$1 = state_80317;
var ex80324 = (state_80317__$1[(2)]);
var statearr_80332_80347 = state_80317__$1;
(statearr_80332_80347[(5)] = ex80324);


var statearr_80333_80348 = state_80317__$1;
(statearr_80333_80348[(1)] = (4));

(statearr_80333_80348[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80318 === (8))){
var inst_80300 = (state_80317[(8)]);
var inst_80306 = (state_80317[(2)]);
var inst_80307 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_80300,inst_80306);
var state_80317__$1 = state_80317;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80317__$1,(9),inst_80307);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__11438__auto__ = null;
var flureedb$state_machine__11438__auto____0 = (function (){
var statearr_80334 = [null,null,null,null,null,null,null,null,null];
(statearr_80334[(0)] = flureedb$state_machine__11438__auto__);

(statearr_80334[(1)] = (1));

return statearr_80334;
});
var flureedb$state_machine__11438__auto____1 = (function (state_80317){
while(true){
var ret_value__11439__auto__ = (function (){try{while(true){
var result__11440__auto__ = switch__11437__auto__(state_80317);
if(cljs.core.keyword_identical_QMARK_(result__11440__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11440__auto__;
}
break;
}
}catch (e80335){var ex__11441__auto__ = e80335;
var statearr_80336_80349 = state_80317;
(statearr_80336_80349[(2)] = ex__11441__auto__);


if(cljs.core.seq((state_80317[(4)]))){
var statearr_80337_80350 = state_80317;
(statearr_80337_80350[(1)] = cljs.core.first((state_80317[(4)])));

} else {
throw ex__11441__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11439__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80351 = state_80317;
state_80317 = G__80351;
continue;
} else {
return ret_value__11439__auto__;
}
break;
}
});
flureedb$state_machine__11438__auto__ = function(state_80317){
switch(arguments.length){
case 0:
return flureedb$state_machine__11438__auto____0.call(this);
case 1:
return flureedb$state_machine__11438__auto____1.call(this,state_80317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__11438__auto____0;
flureedb$state_machine__11438__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__11438__auto____1;
return flureedb$state_machine__11438__auto__;
})()
})();
var state__11514__auto__ = (function (){var statearr_80338 = (f__11513__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11513__auto__.cljs$core$IFn$_invoke$arity$0() : f__11513__auto__.call(null));
(statearr_80338[(6)] = c__11512__auto__);

return statearr_80338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11514__auto__);
}));

return c__11512__auto__;
})));
}));

(flureedb.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *    any key, and a two-argument function that will be called with each event.
 * 
 *    The key is any arbitrary key, and is only used to close the listener via close-listener,
 *    otherwise it is opaque to the listener.
 * 
 *    The callback function's first argument is the event header/metadata and the second argument
 *    is the event data itself.
 */
flureedb.listen = (function flureedb$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen(conn,ledger,key,callback);
});
goog.exportSymbol('flureedb.listen', flureedb.listen);
/**
 * Closes a listener.
 */
flureedb.close_listener = (function flureedb$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener(conn,ledger,key);
});
goog.exportSymbol('flureedb.close_listener', flureedb.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureedb.listeners = (function flureedb$listeners(conn){
return fluree.db.connection_js.listeners(conn);
});
goog.exportSymbol('flureedb.listeners', flureedb.listeners);
/**
 * Takes an http request and creates an http signature using a private key
 */
flureedb.http_signature = (function flureedb$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureedb.http_signature', flureedb.http_signature);
