// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.analyzer.impl.namespaces');
goog.require('cljs.core');
/**
 * Given a libspec return a map of :as-alias alias, if was present. Return the
 * libspec with :as-alias elided. If the libspec was *only* :as-alias do not
 * return it.
 */
cljs.analyzer.impl.namespaces.check_and_remove_as_alias = (function cljs$analyzer$impl$namespaces$check_and_remove_as_alias(libspec){
if((((libspec instanceof cljs.core.Symbol)) || ((libspec instanceof cljs.core.Keyword)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec], null);
} else {
var vec__4190 = libspec;
var seq__4191 = cljs.core.seq.call(null,vec__4190);
var first__4192 = cljs.core.first.call(null,seq__4191);
var seq__4191__$1 = cljs.core.next.call(null,seq__4191);
var lib = first__4192;
var spec = seq__4191__$1;
var libspec__$1 = vec__4190;
var vec__4193 = cljs.core.split_with.call(null,cljs.core.complement.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as-alias","as-alias",82482467),null], null), null)),spec);
var pre_spec = cljs.core.nth.call(null,vec__4193,(0),null);
var vec__4196 = cljs.core.nth.call(null,vec__4193,(1),null);
var seq__4197 = cljs.core.seq.call(null,vec__4196);
var first__4198 = cljs.core.first.call(null,seq__4197);
var seq__4197__$1 = cljs.core.next.call(null,seq__4197);
var _ = first__4198;
var first__4198__$1 = cljs.core.first.call(null,seq__4197__$1);
var seq__4197__$2 = cljs.core.next.call(null,seq__4197__$1);
var alias = first__4198__$1;
var post_spec = seq__4197__$2;
var post = vec__4196;
if(cljs.core.seq.call(null,post)){
var libspec_SINGLEQUOTE_ = cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lib], null),cljs.core.concat.call(null,pre_spec,post_spec));
if((alias instanceof cljs.core.Symbol)){
} else {
throw (new Error(["Assert failed: ",[":as-alias must be followed by a symbol, got: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias)].join(''),"\n","(symbol? alias)"].join('')));
}

var G__4199 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as-alias","as-alias",82482467),cljs.core.PersistentArrayMap.createAsIfByAssoc([alias,lib])], null);
if((cljs.core.count.call(null,libspec_SINGLEQUOTE_) > (1))){
return cljs.core.assoc.call(null,G__4199,new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec_SINGLEQUOTE_);
} else {
return G__4199;
}
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec__$1], null);
}
}
});
cljs.analyzer.impl.namespaces.check_as_alias_duplicates = (function cljs$analyzer$impl$namespaces$check_as_alias_duplicates(as_aliases,new_as_aliases){
var seq__4200 = cljs.core.seq.call(null,new_as_aliases);
var chunk__4201 = null;
var count__4202 = (0);
var i__4203 = (0);
while(true){
if((i__4203 < count__4202)){
var vec__4210 = cljs.core._nth.call(null,chunk__4201,i__4203);
var alias = cljs.core.nth.call(null,vec__4210,(0),null);
var _ = cljs.core.nth.call(null,vec__4210,(1),null);
if((!(cljs.core.contains_QMARK_.call(null,as_aliases,alias)))){
} else {
throw (new Error(["Assert failed: ",["Duplicate :as-alias ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias),", already in use for lib ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,as_aliases,alias))].join(''),"\n","(not (contains? as-aliases alias))"].join('')));
}


var G__4216 = seq__4200;
var G__4217 = chunk__4201;
var G__4218 = count__4202;
var G__4219 = (i__4203 + (1));
seq__4200 = G__4216;
chunk__4201 = G__4217;
count__4202 = G__4218;
i__4203 = G__4219;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__4200);
if(temp__5804__auto__){
var seq__4200__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4200__$1)){
var c__5567__auto__ = cljs.core.chunk_first.call(null,seq__4200__$1);
var G__4220 = cljs.core.chunk_rest.call(null,seq__4200__$1);
var G__4221 = c__5567__auto__;
var G__4222 = cljs.core.count.call(null,c__5567__auto__);
var G__4223 = (0);
seq__4200 = G__4220;
chunk__4201 = G__4221;
count__4202 = G__4222;
i__4203 = G__4223;
continue;
} else {
var vec__4213 = cljs.core.first.call(null,seq__4200__$1);
var alias = cljs.core.nth.call(null,vec__4213,(0),null);
var _ = cljs.core.nth.call(null,vec__4213,(1),null);
if((!(cljs.core.contains_QMARK_.call(null,as_aliases,alias)))){
} else {
throw (new Error(["Assert failed: ",["Duplicate :as-alias ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias),", already in use for lib ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,as_aliases,alias))].join(''),"\n","(not (contains? as-aliases alias))"].join('')));
}


var G__4224 = cljs.core.next.call(null,seq__4200__$1);
var G__4225 = null;
var G__4226 = (0);
var G__4227 = (0);
seq__4200 = G__4224;
chunk__4201 = G__4225;
count__4202 = G__4226;
i__4203 = G__4227;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Given libspecs, elide all :as-alias. Return a map of :libspecs (filtered)
 * and :as-aliases.
 */
cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs = (function cljs$analyzer$impl$namespaces$elide_aliases_from_libspecs(var_args){
var G__4229 = arguments.length;
switch (G__4229) {
case 1:
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$1 = (function (libspecs){
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.call(null,libspecs,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2 = (function (libspecs,as_aliases){
var ret = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),as_aliases,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.PersistentVector.EMPTY], null);
return cljs.core.reduce.call(null,(function (ret__$1,libspec){
var map__4230 = cljs.analyzer.impl.namespaces.check_and_remove_as_alias.call(null,libspec);
var map__4230__$1 = cljs.core.__destructure_map.call(null,map__4230);
var as_alias = cljs.core.get.call(null,map__4230__$1,new cljs.core.Keyword(null,"as-alias","as-alias",82482467));
var libspec__$1 = cljs.core.get.call(null,map__4230__$1,new cljs.core.Keyword(null,"libspec","libspec",1228503756));
cljs.analyzer.impl.namespaces.check_as_alias_duplicates.call(null,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798).cljs$core$IFn$_invoke$arity$1(ret__$1),as_alias);

var G__4231 = ret__$1;
var G__4231__$1 = (cljs.core.truth_(libspec__$1)?cljs.core.update.call(null,G__4231,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,libspec__$1):G__4231);
if(cljs.core.truth_(as_alias)){
return cljs.core.update.call(null,G__4231__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.merge,as_alias);
} else {
return G__4231__$1;
}
}),ret,libspecs);
}));

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$lang$maxFixedArity = 2);

cljs.analyzer.impl.namespaces.elide_aliases_from_ns_specs = (function cljs$analyzer$impl$namespaces$elide_aliases_from_ns_specs(ns_specs){

var ret = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.PersistentVector.EMPTY], null);
return cljs.core.reduce.call(null,(function (p__4233,p__4234){
var map__4235 = p__4233;
var map__4235__$1 = cljs.core.__destructure_map.call(null,map__4235);
var ret__$1 = map__4235__$1;
var as_aliases = cljs.core.get.call(null,map__4235__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798));
var vec__4236 = p__4234;
var seq__4237 = cljs.core.seq.call(null,vec__4236);
var first__4238 = cljs.core.first.call(null,seq__4237);
var seq__4237__$1 = cljs.core.next.call(null,seq__4237);
var spec_key = first__4238;
var libspecs = seq__4237__$1;
if((!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"refer-clojure","refer-clojure",813784440),spec_key)))){
var map__4239 = cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.call(null,libspecs,as_aliases);
var map__4239__$1 = cljs.core.__destructure_map.call(null,map__4239);
var as_aliases__$1 = cljs.core.get.call(null,map__4239__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798));
var libspecs__$1 = cljs.core.get.call(null,map__4239__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195));
var G__4240 = ret__$1;
var G__4240__$1 = (((!(cljs.core.empty_QMARK_.call(null,as_aliases__$1))))?cljs.core.update.call(null,G__4240,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.merge,as_aliases__$1):G__4240);
if((!(cljs.core.empty_QMARK_.call(null,libspecs__$1)))){
return cljs.core.update.call(null,G__4240__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,cljs.core.list_STAR_.call(null,spec_key,libspecs__$1));
} else {
return G__4240__$1;
}
} else {
return cljs.core.update.call(null,ret__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,cljs.core.list_STAR_.call(null,spec_key,libspecs));
}
}),ret,ns_specs);
});
