// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.call(null,cljs.core.mapcat.call(null,(function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.call(null,clojure.string.replace.call(null,cljs.core.name.call(null,lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.call(null,ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv.call(null,(function (xs,ns,_){
if(cljs.core._EQ_.call(null,needle,cljs.compiler.get_first_ns_segment.call(null,ns))){
return cljs.core.reduced.call(null,needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__6548 = s;
var map__6548__$1 = cljs.core.__destructure_map.call(null,map__6548);
var name = cljs.core.get.call(null,map__6548__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__6548__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__6550 = info;
var map__6551 = G__6550;
var map__6551__$1 = cljs.core.__destructure_map.call(null,map__6551);
var shadow = cljs.core.get.call(null,map__6551__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__6550__$1 = G__6550;
while(true){
var d__$2 = d__$1;
var map__6553 = G__6550__$1;
var map__6553__$1 = cljs.core.__destructure_map.call(null,map__6553);
var shadow__$1 = cljs.core.get.call(null,map__6553__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__6554 = (d__$2 + (1));
var G__6555 = shadow__$1;
d__$1 = G__6554;
G__6550__$1 = G__6555;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine.call(null,cljs.core._hash.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s)),cljs.compiler.shadow_depth.call(null,s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__6556){
var map__6557 = p__6556;
var map__6557__$1 = cljs.core.__destructure_map.call(null,map__6557);
var name_var = map__6557__$1;
var name = cljs.core.get.call(null,map__6557__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__6557__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__6558 = info;
var map__6558__$1 = cljs.core.__destructure_map.call(null,map__6558);
var ns = cljs.core.get.call(null,map__6558__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.call(null,map__6558__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,"_$_",cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.call(null,cljs.compiler.munge.call(null,[clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('')));
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.call(null,reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__6560 = arguments.length;
switch (G__6560) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.call(null,s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name.call(null,s);
} else {
var depth = cljs.compiler.shadow_depth.call(null,s);
var code = cljs.compiler.hash_scope.call(null,s);
var renamed = cljs.core.get.call(null,cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.call(null,name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace.call(null,ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved.call(null,reserved);
var ss__$2 = cljs.core.map.call(null,rf,clojure.string.split.call(null,ss__$1,/\./));
var ss__$3 = clojure.string.join.call(null,".",ss__$2);
var ms = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11790,11790,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)])).call(null,ss__$3);
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.call(null,",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__6562 = cp;
switch (G__6562) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.call(null,"0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__6564_6568 = cljs.core.seq.call(null,s);
var chunk__6565_6569 = null;
var count__6566_6570 = (0);
var i__6567_6571 = (0);
while(true){
if((i__6567_6571 < count__6566_6570)){
var c_6572 = cljs.core._nth.call(null,chunk__6565_6569,i__6567_6571);
sb.append(cljs.compiler.escape_char.call(null,c_6572));


var G__6573 = seq__6564_6568;
var G__6574 = chunk__6565_6569;
var G__6575 = count__6566_6570;
var G__6576 = (i__6567_6571 + (1));
seq__6564_6568 = G__6573;
chunk__6565_6569 = G__6574;
count__6566_6570 = G__6575;
i__6567_6571 = G__6576;
continue;
} else {
var temp__5804__auto___6577 = cljs.core.seq.call(null,seq__6564_6568);
if(temp__5804__auto___6577){
var seq__6564_6578__$1 = temp__5804__auto___6577;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6564_6578__$1)){
var c__5567__auto___6579 = cljs.core.chunk_first.call(null,seq__6564_6578__$1);
var G__6580 = cljs.core.chunk_rest.call(null,seq__6564_6578__$1);
var G__6581 = c__5567__auto___6579;
var G__6582 = cljs.core.count.call(null,c__5567__auto___6579);
var G__6583 = (0);
seq__6564_6568 = G__6580;
chunk__6565_6569 = G__6581;
count__6566_6570 = G__6582;
i__6567_6571 = G__6583;
continue;
} else {
var c_6584 = cljs.core.first.call(null,seq__6564_6578__$1);
sb.append(cljs.compiler.escape_char.call(null,c_6584));


var G__6585 = cljs.core.next.call(null,seq__6564_6578__$1);
var G__6586 = null;
var G__6587 = (0);
var G__6588 = (0);
seq__6564_6568 = G__6585;
chunk__6565_6569 = G__6586;
count__6566_6570 = G__6587;
i__6567_6571 = G__6588;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__5641__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5642__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5643__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5644__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5645__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5645__auto__,method_table__5641__auto__,prefer_table__5642__auto__,method_cache__5643__auto__,cached_hierarchy__5644__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__6589_6592 = ast;
var map__6589_6593__$1 = cljs.core.__destructure_map.call(null,map__6589_6592);
var env_6594 = cljs.core.get.call(null,map__6589_6593__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_6594))){
var map__6590_6595 = env_6594;
var map__6590_6596__$1 = cljs.core.__destructure_map.call(null,map__6590_6595);
var line_6597 = cljs.core.get.call(null,map__6590_6596__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_6598 = cljs.core.get.call(null,map__6590_6596__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__6591 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast)))){
return cljs.core.assoc.call(null,G__6591,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__6591;
}
})();
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_6597 - (1))], null),cljs.core.fnil.call(null,(function (line__$1){
return cljs.core.update_in.call(null,line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_6598)?(column_6598 - (1)):(0))], null),cljs.core.fnil.call(null,(function (column__$1){
return cljs.core.conj.call(null,column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}));
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.call(null,ast);
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__6607 = arguments.length;
switch (G__6607) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__5793__auto__ = [];
var len__5768__auto___6614 = arguments.length;
var i__5769__auto___6615 = (0);
while(true){
if((i__5769__auto___6615 < len__5768__auto___6614)){
args_arr__5793__auto__.push((arguments[i__5769__auto___6615]));

var G__6616 = (i__5769__auto___6615 + (1));
i__5769__auto___6615 = G__6616;
continue;
} else {
}
break;
}

var argseq__5794__auto__ = (new cljs.core.IndexedSeq(args_arr__5793__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__5794__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,a)){
cljs.compiler.emit.call(null,a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_.call(null,a)){
cljs.core.apply.call(null,cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
a.call(null);
} else {
var s_6617 = (function (){var G__6608 = a;
if((!(typeof a === 'string'))){
return G__6608.toString();
} else {
return G__6608;
}
})();
var temp__5808__auto___6618 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5808__auto___6618 == null)){
} else {
var sm_data_6619 = temp__5808__auto___6618;
cljs.core.swap_BANG_.call(null,sm_data_6619,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__6599_SHARP_){
return (p1__6599_SHARP_ + s_6617.length);
}));
}

cljs.core.print.call(null,s_6617);

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

return cljs.compiler.emits.call(null,b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler.emits.call(null,c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler.emits.call(null,d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler.emits.call(null,e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__6609 = cljs.core.seq.call(null,xs);
var chunk__6610 = null;
var count__6611 = (0);
var i__6612 = (0);
while(true){
if((i__6612 < count__6611)){
var x = cljs.core._nth.call(null,chunk__6610,i__6612);
cljs.compiler.emits.call(null,x);


var G__6620 = seq__6609;
var G__6621 = chunk__6610;
var G__6622 = count__6611;
var G__6623 = (i__6612 + (1));
seq__6609 = G__6620;
chunk__6610 = G__6621;
count__6611 = G__6622;
i__6612 = G__6623;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__6609);
if(temp__5804__auto__){
var seq__6609__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6609__$1)){
var c__5567__auto__ = cljs.core.chunk_first.call(null,seq__6609__$1);
var G__6624 = cljs.core.chunk_rest.call(null,seq__6609__$1);
var G__6625 = c__5567__auto__;
var G__6626 = cljs.core.count.call(null,c__5567__auto__);
var G__6627 = (0);
seq__6609 = G__6624;
chunk__6610 = G__6625;
count__6611 = G__6626;
i__6612 = G__6627;
continue;
} else {
var x = cljs.core.first.call(null,seq__6609__$1);
cljs.compiler.emits.call(null,x);


var G__6628 = cljs.core.next.call(null,seq__6609__$1);
var G__6629 = null;
var G__6630 = (0);
var G__6631 = (0);
seq__6609 = G__6628;
chunk__6610 = G__6629;
count__6611 = G__6630;
i__6612 = G__6631;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq6601){
var G__6602 = cljs.core.first.call(null,seq6601);
var seq6601__$1 = cljs.core.next.call(null,seq6601);
var G__6603 = cljs.core.first.call(null,seq6601__$1);
var seq6601__$2 = cljs.core.next.call(null,seq6601__$1);
var G__6604 = cljs.core.first.call(null,seq6601__$2);
var seq6601__$3 = cljs.core.next.call(null,seq6601__$2);
var G__6605 = cljs.core.first.call(null,seq6601__$3);
var seq6601__$4 = cljs.core.next.call(null,seq6601__$3);
var G__6606 = cljs.core.first.call(null,seq6601__$4);
var seq6601__$5 = cljs.core.next.call(null,seq6601__$4);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6602,G__6603,G__6604,G__6605,G__6606,seq6601__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.call(null);

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (p__6632){
var map__6633 = p__6632;
var map__6633__$1 = cljs.core.__destructure_map.call(null,map__6633);
var m = map__6633__$1;
var gen_line = cljs.core.get.call(null,map__6633__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__6641 = arguments.length;
switch (G__6641) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__5793__auto__ = [];
var len__5768__auto___6647 = arguments.length;
var i__5769__auto___6648 = (0);
while(true){
if((i__5769__auto___6648 < len__5768__auto___6647)){
args_arr__5793__auto__.push((arguments[i__5769__auto___6648]));

var G__6649 = (i__5769__auto___6648 + (1));
i__5769__auto___6648 = G__6649;
continue;
} else {
}
break;
}

var argseq__5794__auto__ = (new cljs.core.IndexedSeq(args_arr__5793__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__5794__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.call(null,a);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__6642_6650 = cljs.core.seq.call(null,xs);
var chunk__6643_6651 = null;
var count__6644_6652 = (0);
var i__6645_6653 = (0);
while(true){
if((i__6645_6653 < count__6644_6652)){
var x_6654 = cljs.core._nth.call(null,chunk__6643_6651,i__6645_6653);
cljs.compiler.emits.call(null,x_6654);


var G__6655 = seq__6642_6650;
var G__6656 = chunk__6643_6651;
var G__6657 = count__6644_6652;
var G__6658 = (i__6645_6653 + (1));
seq__6642_6650 = G__6655;
chunk__6643_6651 = G__6656;
count__6644_6652 = G__6657;
i__6645_6653 = G__6658;
continue;
} else {
var temp__5804__auto___6659 = cljs.core.seq.call(null,seq__6642_6650);
if(temp__5804__auto___6659){
var seq__6642_6660__$1 = temp__5804__auto___6659;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6642_6660__$1)){
var c__5567__auto___6661 = cljs.core.chunk_first.call(null,seq__6642_6660__$1);
var G__6662 = cljs.core.chunk_rest.call(null,seq__6642_6660__$1);
var G__6663 = c__5567__auto___6661;
var G__6664 = cljs.core.count.call(null,c__5567__auto___6661);
var G__6665 = (0);
seq__6642_6650 = G__6662;
chunk__6643_6651 = G__6663;
count__6644_6652 = G__6664;
i__6645_6653 = G__6665;
continue;
} else {
var x_6666 = cljs.core.first.call(null,seq__6642_6660__$1);
cljs.compiler.emits.call(null,x_6666);


var G__6667 = cljs.core.next.call(null,seq__6642_6660__$1);
var G__6668 = null;
var G__6669 = (0);
var G__6670 = (0);
seq__6642_6650 = G__6667;
chunk__6643_6651 = G__6668;
count__6644_6652 = G__6669;
i__6645_6653 = G__6670;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln.call(null);
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq6635){
var G__6636 = cljs.core.first.call(null,seq6635);
var seq6635__$1 = cljs.core.next.call(null,seq6635);
var G__6637 = cljs.core.first.call(null,seq6635__$1);
var seq6635__$2 = cljs.core.next.call(null,seq6635__$1);
var G__6638 = cljs.core.first.call(null,seq6635__$2);
var seq6635__$3 = cljs.core.next.call(null,seq6635__$2);
var G__6639 = cljs.core.first.call(null,seq6635__$3);
var seq6635__$4 = cljs.core.next.call(null,seq6635__$3);
var G__6640 = cljs.core.first.call(null,seq6635__$4);
var seq6635__$5 = cljs.core.next.call(null,seq6635__$4);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6636,G__6637,G__6638,G__6639,G__6640,seq6635__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__5689__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__6671_6675 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__6672_6676 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__6673_6677 = true;
var _STAR_print_fn_STAR__temp_val__6674_6678 = (function (x__5690__auto__){
return sb__5689__auto__.append(x__5690__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__6673_6677);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__6674_6678);

try{cljs.compiler.emit.call(null,expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__6672_6676);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__6671_6675);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__5689__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__5641__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5642__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5643__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5644__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5645__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5645__auto__,method_table__5641__auto__,prefer_table__5642__auto__,method_cache__5643__auto__,cached_hierarchy__5644__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.call(null,cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_.call(null,x)){
return cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.core.record_QMARK_.call(null,x)){
var vec__6679 = cljs.analyzer.record_ns_PLUS_name.call(null,x);
var ns = cljs.core.nth.call(null,vec__6679,(0),null);
var name = cljs.core.nth.call(null,vec__6679,(1),null);
return cljs.compiler.emit_record_value.call(null,ns,name,(function (){
return cljs.compiler.emit_constant.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,x));
}));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,x)){
return cljs.compiler.emit_map.call(null,cljs.core.keys.call(null,x),cljs.core.vals.call(null,x),cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_.call(null,x)){
return cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_.call(null,x)){
return cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
return cljs.compiler.emit_constant_STAR_.call(null,x);

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta.call(null,cljs.core.meta.call(null,v));
if((!((cljs.core.seq.call(null,m) == null)))){
return cljs.compiler.emit_with_meta.call(null,(function (){
return cljs.compiler.emit_constant_no_meta.call(null,v);
}),(function (){
return cljs.compiler.emit_constant_no_meta.call(null,m);
}));
} else {
return cljs.compiler.emit_constant_no_meta.call(null,v);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.call(null,["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.call(null,cljs.core.type.call(null,x))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type.call(null,x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,null,(function (x){
return cljs.compiler.emits.call(null,"null");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.call(null,"NaN");
} else {
if(cljs.core.not.call(null,isFinite(x))){
return cljs.compiler.emits.call(null,(((x > (0)))?"Infinity":"-Infinity"));
} else {
if((((x === (0))) && ((((1) / x) < (0))))){
return cljs.compiler.emits.call(null,"(-0)");
} else {
return cljs.compiler.emits.call(null,"(",x,")");

}
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,String,(function (x){
return cljs.compiler.emits.call(null,cljs.compiler.wrap_in_double_quotes.call(null,cljs.compiler.escape_string.call(null,x)));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Boolean,(function (x){
return cljs.compiler.emits.call(null,(cljs.core.truth_(x)?"true":"false"));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,RegExp,(function (x){
if(cljs.core._EQ_.call(null,"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.call(null,"(new RegExp(\"\"))");
} else {
var vec__6682 = cljs.core.re_find.call(null,/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.call(null,vec__6682,(0),null);
var flags = cljs.core.nth.call(null,vec__6682,(1),null);
var pattern = cljs.core.nth.call(null,vec__6682,(2),null);
return cljs.compiler.emits.call(null,pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace.call(null,kw);
var name = cljs.core.name.call(null,kw);
cljs.compiler.emits.call(null,"new cljs.core.Keyword(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,(cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,kw));

return cljs.compiler.emits.call(null,")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace.call(null,sym);
var name = cljs.core.name.call(null,sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.call(null,"new cljs.core.Symbol(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,symstr);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,sym));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,null);

return cljs.compiler.emits.call(null,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Keyword,(function (x){
var temp__5802__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__5043__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var value = temp__5802__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_keyword.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Symbol,(function (x){
var temp__5802__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__5043__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var value = temp__5802__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_symbol.call(null,x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.call(null,cljs.core.map_indexed.call(null,(function (i,m){
if(cljs.core.even_QMARK_.call(null,i)){
return cljs.compiler.emit_constant.call(null,m);
} else {
return cljs.compiler.emits.call(null,m);
}
}),cljs.compiler.comma_sep.call(null,cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.call(null,"new Date(",inst_ms,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Date,(function (date){
return cljs.compiler.emit_inst.call(null,date.getTime());
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.call(null,"new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash.call(null,uuid_str),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_.call(null,items)){
return cljs.compiler.emit_js_object.call(null,items,(function (p1__6685_SHARP_){
return (function (){
return cljs.compiler.emit_constant.call(null,p1__6685_SHARP_);
});
}));
} else {
return cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__6687){
var map__6688 = p__6687;
var map__6688__$1 = cljs.core.__destructure_map.call(null,map__6688);
var ast = map__6688__$1;
var info = cljs.core.get.call(null,map__6688__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.call(null,map__6688__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.call(null,map__6688__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5802__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5802__auto__)){
var const_expr = temp__5802__auto__;
return cljs.compiler.emit.call(null,cljs.core.assoc.call(null,const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__6689 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__6689__$1 = cljs.core.__destructure_map.call(null,map__6689);
var cenv = map__6689__$1;
var options = cljs.core.get.call(null,map__6689__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.call(null,cljs.core.namespace.call(null,var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name.call(null,var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__5045__auto__ = js_module_name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,ast));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__6690 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.compiler.es5_GT__EQ_.call(null,new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options));
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.namespace.call(null,var_name) == null)));
} else {
return and__5043__auto__;
}
})())){
return clojure.set.difference.call(null,G__6690,cljs.analyzer.es5_allowed);
} else {
return G__6690;
}
})();
var js_module = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__5045__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})()], null));
var info__$2 = (function (){var G__6691 = info__$1;
if(cljs.core.not_EQ_.call(null,form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.call(null,G__6691,reserved);
} else {
return G__6691;
}
})();
var env__9255__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var G__6692_6693 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__6692_6694__$1 = (((G__6692_6693 instanceof cljs.core.Keyword))?G__6692_6693.fqn:null);
switch (G__6692_6694__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace.call(null,var_name))){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"].",cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved));
} else {
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.call(null,"default",cljs.core.name.call(null,var_name));
} else {
return and__5043__auto__;
}
})())){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.call(null,info__$2);
}

break;
default:
cljs.compiler.emits.call(null,info__$2);

}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__6696){
var map__6697 = p__6696;
var map__6697__$1 = cljs.core.__destructure_map.call(null,map__6697);
var arg = map__6697__$1;
var env = cljs.core.get.call(null,map__6697__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.call(null,map__6697__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.call(null,map__6697__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.call(null,map__6697__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_.call(null,sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_.call(null,meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__6698 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__6698__$1 = cljs.core.__destructure_map.call(null,map__6698);
var name = cljs.core.get.call(null,map__6698__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__9255__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"new cljs.core.Var(function(){return ",cljs.compiler.munge.call(null,name),";},",sym,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.call(null,"cljs.core.with_meta(",expr,",",meta,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__6699){
var map__6700 = p__6699;
var map__6700__$1 = cljs.core.__destructure_map.call(null,map__6700);
var expr = cljs.core.get.call(null,map__6700__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.call(null,map__6700__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.call(null,map__6700__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9255__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_with_meta.call(null,expr,meta);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_.call(null,(function (p1__6701_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6701_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count.call(null,keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count.call(null,keys) === (0))){
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count.call(null,keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_(distinct_keys_QMARK_.call(null,keys))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,keys),", [",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.createAsIfByAssoc([",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"])");
}
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashMap.fromArrays([",comma_sep.call(null,keys),"],[",comma_sep.call(null,vals),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__6702){
var map__6703 = p__6702;
var map__6703__$1 = cljs.core.__destructure_map.call(null,map__6703);
var env = cljs.core.get.call(null,map__6703__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.call(null,map__6703__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__6703__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__9255__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_map.call(null,keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.call(null,"cljs.core.list(",comma_sep.call(null,items),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count.call(null,items);
if((cnt < (32))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",comma_sep.call(null,items),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.fromArray([",comma_sep.call(null,items),"], true)");
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__6704){
var map__6705 = p__6704;
var map__6705__$1 = cljs.core.__destructure_map.call(null,map__6705);
var items = cljs.core.get.call(null,map__6705__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6705__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9255__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_vector.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_.call(null,(function (p1__6706_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6706_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count.call(null,items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_(distinct_constants_QMARK_.call(null,items))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,items),", [",comma_sep.call(null,cljs.core.interleave.call(null,items,cljs.core.repeat.call(null,"null"))),"], null), null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.createAsIfByAssoc([",comma_sep.call(null,items),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set","set",304602554),(function (p__6707){
var map__6708 = p__6707;
var map__6708__$1 = cljs.core.__destructure_map.call(null,map__6708);
var items = cljs.core.get.call(null,map__6708__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6708__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9255__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_set.call(null,items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.call(null,"({");

var temp__5804__auto___6731 = cljs.core.seq.call(null,items);
if(temp__5804__auto___6731){
var items_6732__$1 = temp__5804__auto___6731;
var vec__6709_6733 = items_6732__$1;
var seq__6710_6734 = cljs.core.seq.call(null,vec__6709_6733);
var first__6711_6735 = cljs.core.first.call(null,seq__6710_6734);
var seq__6710_6736__$1 = cljs.core.next.call(null,seq__6710_6734);
var vec__6712_6737 = first__6711_6735;
var k_6738 = cljs.core.nth.call(null,vec__6712_6737,(0),null);
var v_6739 = cljs.core.nth.call(null,vec__6712_6737,(1),null);
var r_6740 = seq__6710_6736__$1;
cljs.compiler.emits.call(null,"\"",cljs.core.name.call(null,k_6738),"\": ",emit_js_object_val.call(null,v_6739));

var seq__6715_6741 = cljs.core.seq.call(null,r_6740);
var chunk__6716_6742 = null;
var count__6717_6743 = (0);
var i__6718_6744 = (0);
while(true){
if((i__6718_6744 < count__6717_6743)){
var vec__6725_6745 = cljs.core._nth.call(null,chunk__6716_6742,i__6718_6744);
var k_6746__$1 = cljs.core.nth.call(null,vec__6725_6745,(0),null);
var v_6747__$1 = cljs.core.nth.call(null,vec__6725_6745,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_6746__$1),"\": ",emit_js_object_val.call(null,v_6747__$1));


var G__6748 = seq__6715_6741;
var G__6749 = chunk__6716_6742;
var G__6750 = count__6717_6743;
var G__6751 = (i__6718_6744 + (1));
seq__6715_6741 = G__6748;
chunk__6716_6742 = G__6749;
count__6717_6743 = G__6750;
i__6718_6744 = G__6751;
continue;
} else {
var temp__5804__auto___6752__$1 = cljs.core.seq.call(null,seq__6715_6741);
if(temp__5804__auto___6752__$1){
var seq__6715_6753__$1 = temp__5804__auto___6752__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6715_6753__$1)){
var c__5567__auto___6754 = cljs.core.chunk_first.call(null,seq__6715_6753__$1);
var G__6755 = cljs.core.chunk_rest.call(null,seq__6715_6753__$1);
var G__6756 = c__5567__auto___6754;
var G__6757 = cljs.core.count.call(null,c__5567__auto___6754);
var G__6758 = (0);
seq__6715_6741 = G__6755;
chunk__6716_6742 = G__6756;
count__6717_6743 = G__6757;
i__6718_6744 = G__6758;
continue;
} else {
var vec__6728_6759 = cljs.core.first.call(null,seq__6715_6753__$1);
var k_6760__$1 = cljs.core.nth.call(null,vec__6728_6759,(0),null);
var v_6761__$1 = cljs.core.nth.call(null,vec__6728_6759,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_6760__$1),"\": ",emit_js_object_val.call(null,v_6761__$1));


var G__6762 = cljs.core.next.call(null,seq__6715_6753__$1);
var G__6763 = null;
var G__6764 = (0);
var G__6765 = (0);
seq__6715_6741 = G__6762;
chunk__6716_6742 = G__6763;
count__6717_6743 = G__6764;
i__6718_6744 = G__6765;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.call(null,"[",comma_sep.call(null,items),"]");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__6766){
var map__6767 = p__6766;
var map__6767__$1 = cljs.core.__destructure_map.call(null,map__6767);
var keys = cljs.core.get.call(null,map__6767__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__6767__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.call(null,map__6767__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9255__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_object.call(null,cljs.core.map.call(null,cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__6768){
var map__6769 = p__6768;
var map__6769__$1 = cljs.core.__destructure_map.call(null,map__6769);
var items = cljs.core.get.call(null,map__6769__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6769__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9255__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_array.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.call(null,ns,".map__GT_",name,"(",items,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__6770){
var map__6771 = p__6770;
var map__6771__$1 = cljs.core.__destructure_map.call(null,map__6771);
var expr = cljs.core.get.call(null,map__6771__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__6772){
var map__6773 = p__6772;
var map__6773__$1 = cljs.core.__destructure_map.call(null,map__6773);
var form = cljs.core.get.call(null,map__6773__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.call(null,map__6773__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__9255__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_constant.call(null,form);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__6774 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__6774__$1 = cljs.core.__destructure_map.call(null,map__6774);
var op = cljs.core.get.call(null,map__6774__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__6774__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__6774__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__5045__auto__ = (function (){var and__5043__auto__ = cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842));
if(and__5043__auto__){
var and__5043__auto____$1 = form;
if(cljs.core.truth_(and__5043__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.call(null,form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = (!((const_expr == null)));
if(and__5043__auto__){
return cljs.compiler.truthy_constant_QMARK_.call(null,const_expr);
} else {
return and__5043__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__6775 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__6775__$1 = cljs.core.__destructure_map.call(null,map__6775);
var op = cljs.core.get.call(null,map__6775__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__6775__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__6775__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__5045__auto__ = ((cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__5045__auto__){
return or__5045__auto__;
} else {
var and__5043__auto__ = (!((const_expr == null)));
if(and__5043__auto__){
return cljs.compiler.falsey_constant_QMARK_.call(null,const_expr);
} else {
return and__5043__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag.call(null,env,e);
var or__5045__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null).call(null,tag);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_.call(null,e);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__6776){
var map__6777 = p__6776;
var map__6777__$1 = cljs.core.__destructure_map.call(null,map__6777);
var test = cljs.core.get.call(null,map__6777__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.call(null,map__6777__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.call(null,map__6777__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.call(null,map__6777__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.call(null,map__6777__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not.call(null,(function (){var or__5045__auto__ = unchecked;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.compiler.safe_test_QMARK_.call(null,env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,else$);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"(",((checked)?"cljs.core.truth_":null),"(",test,")?",then,":",else$,")");
} else {
if(checked){
cljs.compiler.emitln.call(null,"if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.call(null,"if(",test,"){");
}

cljs.compiler.emitln.call(null,then,"} else {");

return cljs.compiler.emitln.call(null,else$,"}");
}

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__6778){
var map__6779 = p__6778;
var map__6779__$1 = cljs.core.__destructure_map.call(null,map__6779);
var v = cljs.core.get.call(null,map__6779__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.call(null,map__6779__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.call(null,map__6779__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.call(null,map__6779__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.call(null,"(function(){");
} else {
}

var gs = cljs.core.gensym.call(null,"caseval__");
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"var ",gs,";");
} else {
}

cljs.compiler.emitln.call(null,"switch (",v,") {");

var seq__6780_6808 = cljs.core.seq.call(null,nodes);
var chunk__6781_6809 = null;
var count__6782_6810 = (0);
var i__6783_6811 = (0);
while(true){
if((i__6783_6811 < count__6782_6810)){
var map__6796_6812 = cljs.core._nth.call(null,chunk__6781_6809,i__6783_6811);
var map__6796_6813__$1 = cljs.core.__destructure_map.call(null,map__6796_6812);
var ts_6814 = cljs.core.get.call(null,map__6796_6813__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__6797_6815 = cljs.core.get.call(null,map__6796_6813__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__6797_6816__$1 = cljs.core.__destructure_map.call(null,map__6797_6815);
var then_6817 = cljs.core.get.call(null,map__6797_6816__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__6798_6818 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_6814));
var chunk__6799_6819 = null;
var count__6800_6820 = (0);
var i__6801_6821 = (0);
while(true){
if((i__6801_6821 < count__6800_6820)){
var test_6822 = cljs.core._nth.call(null,chunk__6799_6819,i__6801_6821);
cljs.compiler.emitln.call(null,"case ",test_6822,":");


var G__6823 = seq__6798_6818;
var G__6824 = chunk__6799_6819;
var G__6825 = count__6800_6820;
var G__6826 = (i__6801_6821 + (1));
seq__6798_6818 = G__6823;
chunk__6799_6819 = G__6824;
count__6800_6820 = G__6825;
i__6801_6821 = G__6826;
continue;
} else {
var temp__5804__auto___6827 = cljs.core.seq.call(null,seq__6798_6818);
if(temp__5804__auto___6827){
var seq__6798_6828__$1 = temp__5804__auto___6827;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6798_6828__$1)){
var c__5567__auto___6829 = cljs.core.chunk_first.call(null,seq__6798_6828__$1);
var G__6830 = cljs.core.chunk_rest.call(null,seq__6798_6828__$1);
var G__6831 = c__5567__auto___6829;
var G__6832 = cljs.core.count.call(null,c__5567__auto___6829);
var G__6833 = (0);
seq__6798_6818 = G__6830;
chunk__6799_6819 = G__6831;
count__6800_6820 = G__6832;
i__6801_6821 = G__6833;
continue;
} else {
var test_6834 = cljs.core.first.call(null,seq__6798_6828__$1);
cljs.compiler.emitln.call(null,"case ",test_6834,":");


var G__6835 = cljs.core.next.call(null,seq__6798_6828__$1);
var G__6836 = null;
var G__6837 = (0);
var G__6838 = (0);
seq__6798_6818 = G__6835;
chunk__6799_6819 = G__6836;
count__6800_6820 = G__6837;
i__6801_6821 = G__6838;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_6817);
} else {
cljs.compiler.emitln.call(null,then_6817);
}

cljs.compiler.emitln.call(null,"break;");


var G__6839 = seq__6780_6808;
var G__6840 = chunk__6781_6809;
var G__6841 = count__6782_6810;
var G__6842 = (i__6783_6811 + (1));
seq__6780_6808 = G__6839;
chunk__6781_6809 = G__6840;
count__6782_6810 = G__6841;
i__6783_6811 = G__6842;
continue;
} else {
var temp__5804__auto___6843 = cljs.core.seq.call(null,seq__6780_6808);
if(temp__5804__auto___6843){
var seq__6780_6844__$1 = temp__5804__auto___6843;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6780_6844__$1)){
var c__5567__auto___6845 = cljs.core.chunk_first.call(null,seq__6780_6844__$1);
var G__6846 = cljs.core.chunk_rest.call(null,seq__6780_6844__$1);
var G__6847 = c__5567__auto___6845;
var G__6848 = cljs.core.count.call(null,c__5567__auto___6845);
var G__6849 = (0);
seq__6780_6808 = G__6846;
chunk__6781_6809 = G__6847;
count__6782_6810 = G__6848;
i__6783_6811 = G__6849;
continue;
} else {
var map__6802_6850 = cljs.core.first.call(null,seq__6780_6844__$1);
var map__6802_6851__$1 = cljs.core.__destructure_map.call(null,map__6802_6850);
var ts_6852 = cljs.core.get.call(null,map__6802_6851__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__6803_6853 = cljs.core.get.call(null,map__6802_6851__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__6803_6854__$1 = cljs.core.__destructure_map.call(null,map__6803_6853);
var then_6855 = cljs.core.get.call(null,map__6803_6854__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__6804_6856 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_6852));
var chunk__6805_6857 = null;
var count__6806_6858 = (0);
var i__6807_6859 = (0);
while(true){
if((i__6807_6859 < count__6806_6858)){
var test_6860 = cljs.core._nth.call(null,chunk__6805_6857,i__6807_6859);
cljs.compiler.emitln.call(null,"case ",test_6860,":");


var G__6861 = seq__6804_6856;
var G__6862 = chunk__6805_6857;
var G__6863 = count__6806_6858;
var G__6864 = (i__6807_6859 + (1));
seq__6804_6856 = G__6861;
chunk__6805_6857 = G__6862;
count__6806_6858 = G__6863;
i__6807_6859 = G__6864;
continue;
} else {
var temp__5804__auto___6865__$1 = cljs.core.seq.call(null,seq__6804_6856);
if(temp__5804__auto___6865__$1){
var seq__6804_6866__$1 = temp__5804__auto___6865__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6804_6866__$1)){
var c__5567__auto___6867 = cljs.core.chunk_first.call(null,seq__6804_6866__$1);
var G__6868 = cljs.core.chunk_rest.call(null,seq__6804_6866__$1);
var G__6869 = c__5567__auto___6867;
var G__6870 = cljs.core.count.call(null,c__5567__auto___6867);
var G__6871 = (0);
seq__6804_6856 = G__6868;
chunk__6805_6857 = G__6869;
count__6806_6858 = G__6870;
i__6807_6859 = G__6871;
continue;
} else {
var test_6872 = cljs.core.first.call(null,seq__6804_6866__$1);
cljs.compiler.emitln.call(null,"case ",test_6872,":");


var G__6873 = cljs.core.next.call(null,seq__6804_6866__$1);
var G__6874 = null;
var G__6875 = (0);
var G__6876 = (0);
seq__6804_6856 = G__6873;
chunk__6805_6857 = G__6874;
count__6806_6858 = G__6875;
i__6807_6859 = G__6876;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_6855);
} else {
cljs.compiler.emitln.call(null,then_6855);
}

cljs.compiler.emitln.call(null,"break;");


var G__6877 = cljs.core.next.call(null,seq__6780_6844__$1);
var G__6878 = null;
var G__6879 = (0);
var G__6880 = (0);
seq__6780_6808 = G__6877;
chunk__6781_6809 = G__6878;
count__6782_6810 = G__6879;
i__6783_6811 = G__6880;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.call(null,"default:");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",default$);
} else {
cljs.compiler.emitln.call(null,default$);
}
} else {
}

cljs.compiler.emitln.call(null,"}");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"return ",gs,";})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__6881){
var map__6882 = p__6881;
var map__6882__$1 = cljs.core.__destructure_map.call(null,map__6882);
var throw$ = cljs.core.get.call(null,map__6882__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.call(null,map__6882__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.call(null,"(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.call(null,"throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.mapped_types,t))){
return cljs.core.get.call(null,cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(1))))].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__6884 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.call(null,t,(0),idx),cljs.core.subs.call(null,t,(idx + (1)),cljs.core.count.call(null,t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.call(null,vec__6884,(0),null);
var rstr = cljs.core.nth.call(null,vec__6884,(1),null);
var ret_t = (cljs.core.truth_(rstr)?cljs.compiler.resolve_type.call(null,env,rstr):null);
var axstr = cljs.core.subs.call(null,fstr,(9),(cljs.core.count.call(null,fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_.call(null,axstr))?null:cljs.core.map.call(null,cljs.core.comp.call(null,(function (p1__6883_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__6883_SHARP_);
}),clojure.string.trim),clojure.string.split.call(null,axstr,/,/)));
var G__6887 = ["function(",clojure.string.join.call(null,",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__6887,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__6887;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(0),(cljs.core.count.call(null,t) - (1))))),"="].join('');
} else {
return cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,env,cljs.core.symbol.call(null,t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.call(null,clojure.string.trim.call(null,ts),(1),(cljs.core.count.call(null,ts) - (1)));
var xs = clojure.string.split.call(null,ts__$1,/\|/);
return ["{",clojure.string.join.call(null,"|",cljs.core.map.call(null,(function (p1__6888_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__6888_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find.call(null,/@param/,line))){
var vec__6889 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__6890 = cljs.core.seq.call(null,vec__6889);
var first__6891 = cljs.core.first.call(null,seq__6890);
var seq__6890__$1 = cljs.core.next.call(null,seq__6890);
var p = first__6891;
var first__6891__$1 = cljs.core.first.call(null,seq__6890__$1);
var seq__6890__$2 = cljs.core.next.call(null,seq__6890__$1);
var ts = first__6891__$1;
var first__6891__$2 = cljs.core.first.call(null,seq__6890__$2);
var seq__6890__$3 = cljs.core.next.call(null,seq__6890__$2);
var n = first__6891__$2;
var xs = seq__6890__$3;
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.call(null,"@param",p);
if(and__5043__auto__){
var and__5043__auto____$1 = ts;
if(cljs.core.truth_(and__5043__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts),cljs.compiler.munge.call(null,n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find.call(null,/@return/,line))){
var vec__6892 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__6893 = cljs.core.seq.call(null,vec__6892);
var first__6894 = cljs.core.first.call(null,seq__6893);
var seq__6893__$1 = cljs.core.next.call(null,seq__6893);
var p = first__6894;
var first__6894__$1 = cljs.core.first.call(null,seq__6893__$1);
var seq__6893__$2 = cljs.core.next.call(null,seq__6893__$1);
var ts = first__6894__$1;
var xs = seq__6893__$2;
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.call(null,"@return",p);
if(and__5043__auto__){
var and__5043__auto____$1 = ts;
if(cljs.core.truth_(and__5043__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null).call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null)));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__6897 = arguments.length;
switch (G__6897) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.call(null,null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.call(null,docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__6905 = cljs.core.map.call(null,(function (p1__6895_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))){
return cljs.compiler.munge_param_return.call(null,env,p1__6895_SHARP_);
} else {
return p1__6895_SHARP_;
}
}),clojure.string.split_lines.call(null,e));
var seq__6906 = cljs.core.seq.call(null,vec__6905);
var first__6907 = cljs.core.first.call(null,seq__6906);
var seq__6906__$1 = cljs.core.next.call(null,seq__6906);
var x = first__6907;
var ys = seq__6906__$1;
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,x,"*/","* /"));

var seq__6908 = cljs.core.seq.call(null,ys);
var chunk__6909 = null;
var count__6910 = (0);
var i__6911 = (0);
while(true){
if((i__6911 < count__6910)){
var next_line = cljs.core._nth.call(null,chunk__6909,i__6911);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__6917 = seq__6908;
var G__6918 = chunk__6909;
var G__6919 = count__6910;
var G__6920 = (i__6911 + (1));
seq__6908 = G__6917;
chunk__6909 = G__6918;
count__6910 = G__6919;
i__6911 = G__6920;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__6908);
if(temp__5804__auto__){
var seq__6908__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6908__$1)){
var c__5567__auto__ = cljs.core.chunk_first.call(null,seq__6908__$1);
var G__6921 = cljs.core.chunk_rest.call(null,seq__6908__$1);
var G__6922 = c__5567__auto__;
var G__6923 = cljs.core.count.call(null,c__5567__auto__);
var G__6924 = (0);
seq__6908 = G__6921;
chunk__6909 = G__6922;
count__6910 = G__6923;
i__6911 = G__6924;
continue;
} else {
var next_line = cljs.core.first.call(null,seq__6908__$1);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__6925 = cljs.core.next.call(null,seq__6908__$1);
var G__6926 = null;
var G__6927 = (0);
var G__6928 = (0);
seq__6908 = G__6925;
chunk__6909 = G__6926;
count__6910 = G__6927;
i__6911 = G__6928;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq.call(null,docs__$2)){
cljs.compiler.emitln.call(null,"/**");

var seq__6912_6929 = cljs.core.seq.call(null,docs__$2);
var chunk__6913_6930 = null;
var count__6914_6931 = (0);
var i__6915_6932 = (0);
while(true){
if((i__6915_6932 < count__6914_6931)){
var e_6933 = cljs.core._nth.call(null,chunk__6913_6930,i__6915_6932);
if(cljs.core.truth_(e_6933)){
print_comment_lines.call(null,e_6933);
} else {
}


var G__6934 = seq__6912_6929;
var G__6935 = chunk__6913_6930;
var G__6936 = count__6914_6931;
var G__6937 = (i__6915_6932 + (1));
seq__6912_6929 = G__6934;
chunk__6913_6930 = G__6935;
count__6914_6931 = G__6936;
i__6915_6932 = G__6937;
continue;
} else {
var temp__5804__auto___6938 = cljs.core.seq.call(null,seq__6912_6929);
if(temp__5804__auto___6938){
var seq__6912_6939__$1 = temp__5804__auto___6938;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6912_6939__$1)){
var c__5567__auto___6940 = cljs.core.chunk_first.call(null,seq__6912_6939__$1);
var G__6941 = cljs.core.chunk_rest.call(null,seq__6912_6939__$1);
var G__6942 = c__5567__auto___6940;
var G__6943 = cljs.core.count.call(null,c__5567__auto___6940);
var G__6944 = (0);
seq__6912_6929 = G__6941;
chunk__6913_6930 = G__6942;
count__6914_6931 = G__6943;
i__6915_6932 = G__6944;
continue;
} else {
var e_6945 = cljs.core.first.call(null,seq__6912_6939__$1);
if(cljs.core.truth_(e_6945)){
print_comment_lines.call(null,e_6945);
} else {
}


var G__6946 = cljs.core.next.call(null,seq__6912_6939__$1);
var G__6947 = null;
var G__6948 = (0);
var G__6949 = (0);
seq__6912_6929 = G__6946;
chunk__6913_6930 = G__6947;
count__6914_6931 = G__6948;
i__6915_6932 = G__6949;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.call(null," */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__5043__auto__ = cljs.core.some.call(null,(function (p1__6951_SHARP_){
return goog.string.startsWith(p1__6951_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = opts;
if(cljs.core.truth_(and__5043__auto____$1)){
var and__5043__auto____$2 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__5043__auto____$2){
var define = cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_.call(null,define)){
return cljs.core.pr_str.call(null,define);
} else {
return null;
}
} else {
return and__5043__auto____$2;
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__6952){
var map__6953 = p__6952;
var map__6953__$1 = cljs.core.__destructure_map.call(null,map__6953);
var doc = cljs.core.get.call(null,map__6953__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.call(null,map__6953__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.call(null,map__6953__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.call(null,map__6953__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.call(null,map__6953__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.call(null,map__6953__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__6953__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.call(null,map__6953__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.call(null,map__6953__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.call(null,map__6953__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__5045__auto__ = init;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.call(null,name);
cljs.compiler.emit_comment.call(null,env,doc,cljs.core.concat.call(null,(cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.call(null," = ",(function (){var temp__5802__auto__ = cljs.compiler.get_define.call(null,mname,jsdoc);
if(cljs.core.truth_(temp__5802__auto__)){
var define = temp__5802__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"; return (");

cljs.compiler.emits.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast));

cljs.compiler.emitln.call(null,");})()");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,")");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.call(null,";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.call(null,"goog.exportSymbol('",cljs.compiler.munge.call(null,export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return test;
} else {
return and__5043__auto__;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,";");
} else {
}

return cljs.compiler.emitln.call(null,var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__6954){
var map__6955 = p__6954;
var map__6955__$1 = cljs.core.__destructure_map.call(null,map__6955);
var name = cljs.core.get.call(null,map__6955__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__6955__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__6955__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.call(null,"arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,name)),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function (",arglist,"){");

var seq__6956_6980 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,cljs.core.vector,cljs.core.drop_last.call(null,(2),params)));
var chunk__6957_6981 = null;
var count__6958_6982 = (0);
var i__6959_6983 = (0);
while(true){
if((i__6959_6983 < count__6958_6982)){
var vec__6966_6984 = cljs.core._nth.call(null,chunk__6957_6981,i__6959_6983);
var i_6985 = cljs.core.nth.call(null,vec__6966_6984,(0),null);
var param_6986 = cljs.core.nth.call(null,vec__6966_6984,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_6986);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__6987 = seq__6956_6980;
var G__6988 = chunk__6957_6981;
var G__6989 = count__6958_6982;
var G__6990 = (i__6959_6983 + (1));
seq__6956_6980 = G__6987;
chunk__6957_6981 = G__6988;
count__6958_6982 = G__6989;
i__6959_6983 = G__6990;
continue;
} else {
var temp__5804__auto___6991 = cljs.core.seq.call(null,seq__6956_6980);
if(temp__5804__auto___6991){
var seq__6956_6992__$1 = temp__5804__auto___6991;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6956_6992__$1)){
var c__5567__auto___6993 = cljs.core.chunk_first.call(null,seq__6956_6992__$1);
var G__6994 = cljs.core.chunk_rest.call(null,seq__6956_6992__$1);
var G__6995 = c__5567__auto___6993;
var G__6996 = cljs.core.count.call(null,c__5567__auto___6993);
var G__6997 = (0);
seq__6956_6980 = G__6994;
chunk__6957_6981 = G__6995;
count__6958_6982 = G__6996;
i__6959_6983 = G__6997;
continue;
} else {
var vec__6969_6998 = cljs.core.first.call(null,seq__6956_6992__$1);
var i_6999 = cljs.core.nth.call(null,vec__6969_6998,(0),null);
var param_7000 = cljs.core.nth.call(null,vec__6969_6998,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_7000);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__7001 = cljs.core.next.call(null,seq__6956_6992__$1);
var G__7002 = null;
var G__7003 = (0);
var G__7004 = (0);
seq__6956_6980 = G__7001;
chunk__6957_6981 = G__7002;
count__6958_6982 = G__7003;
i__6959_6983 = G__7004;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count.call(null,params))){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,cljs.core.butlast.call(null,params)));

cljs.compiler.emitln.call(null," = cljs.core.first(",arglist,");");

cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.rest(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__6972_7005 = cljs.core.seq.call(null,params);
var chunk__6973_7006 = null;
var count__6974_7007 = (0);
var i__6975_7008 = (0);
while(true){
if((i__6975_7008 < count__6974_7007)){
var param_7009 = cljs.core._nth.call(null,chunk__6973_7006,i__6975_7008);
cljs.compiler.emit.call(null,param_7009);

if(cljs.core._EQ_.call(null,param_7009,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7010 = seq__6972_7005;
var G__7011 = chunk__6973_7006;
var G__7012 = count__6974_7007;
var G__7013 = (i__6975_7008 + (1));
seq__6972_7005 = G__7010;
chunk__6973_7006 = G__7011;
count__6974_7007 = G__7012;
i__6975_7008 = G__7013;
continue;
} else {
var temp__5804__auto___7014 = cljs.core.seq.call(null,seq__6972_7005);
if(temp__5804__auto___7014){
var seq__6972_7015__$1 = temp__5804__auto___7014;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6972_7015__$1)){
var c__5567__auto___7016 = cljs.core.chunk_first.call(null,seq__6972_7015__$1);
var G__7017 = cljs.core.chunk_rest.call(null,seq__6972_7015__$1);
var G__7018 = c__5567__auto___7016;
var G__7019 = cljs.core.count.call(null,c__5567__auto___7016);
var G__7020 = (0);
seq__6972_7005 = G__7017;
chunk__6973_7006 = G__7018;
count__6974_7007 = G__7019;
i__6975_7008 = G__7020;
continue;
} else {
var param_7021 = cljs.core.first.call(null,seq__6972_7015__$1);
cljs.compiler.emit.call(null,param_7021);

if(cljs.core._EQ_.call(null,param_7021,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7022 = cljs.core.next.call(null,seq__6972_7015__$1);
var G__7023 = null;
var G__7024 = (0);
var G__7025 = (0);
seq__6972_7005 = G__7022;
chunk__6973_7006 = G__7023;
count__6974_7007 = G__7024;
i__6975_7008 = G__7025;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
} else {
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.seq(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__6976_7026 = cljs.core.seq.call(null,params);
var chunk__6977_7027 = null;
var count__6978_7028 = (0);
var i__6979_7029 = (0);
while(true){
if((i__6979_7029 < count__6978_7028)){
var param_7030 = cljs.core._nth.call(null,chunk__6977_7027,i__6979_7029);
cljs.compiler.emit.call(null,param_7030);

if(cljs.core._EQ_.call(null,param_7030,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7031 = seq__6976_7026;
var G__7032 = chunk__6977_7027;
var G__7033 = count__6978_7028;
var G__7034 = (i__6979_7029 + (1));
seq__6976_7026 = G__7031;
chunk__6977_7027 = G__7032;
count__6978_7028 = G__7033;
i__6979_7029 = G__7034;
continue;
} else {
var temp__5804__auto___7035 = cljs.core.seq.call(null,seq__6976_7026);
if(temp__5804__auto___7035){
var seq__6976_7036__$1 = temp__5804__auto___7035;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6976_7036__$1)){
var c__5567__auto___7037 = cljs.core.chunk_first.call(null,seq__6976_7036__$1);
var G__7038 = cljs.core.chunk_rest.call(null,seq__6976_7036__$1);
var G__7039 = c__5567__auto___7037;
var G__7040 = cljs.core.count.call(null,c__5567__auto___7037);
var G__7041 = (0);
seq__6976_7026 = G__7038;
chunk__6977_7027 = G__7039;
count__6978_7028 = G__7040;
i__6979_7029 = G__7041;
continue;
} else {
var param_7042 = cljs.core.first.call(null,seq__6976_7036__$1);
cljs.compiler.emit.call(null,param_7042);

if(cljs.core._EQ_.call(null,param_7042,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7043 = cljs.core.next.call(null,seq__6976_7036__$1);
var G__7044 = null;
var G__7045 = (0);
var G__7046 = (0);
seq__6976_7026 = G__7043;
chunk__6977_7027 = G__7044;
count__6978_7028 = G__7045;
i__6979_7029 = G__7046;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__7047 = cljs.core.seq.call(null,params);
var chunk__7048 = null;
var count__7049 = (0);
var i__7050 = (0);
while(true){
if((i__7050 < count__7049)){
var param = cljs.core._nth.call(null,chunk__7048,i__7050);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7051 = seq__7047;
var G__7052 = chunk__7048;
var G__7053 = count__7049;
var G__7054 = (i__7050 + (1));
seq__7047 = G__7051;
chunk__7048 = G__7052;
count__7049 = G__7053;
i__7050 = G__7054;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__7047);
if(temp__5804__auto__){
var seq__7047__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7047__$1)){
var c__5567__auto__ = cljs.core.chunk_first.call(null,seq__7047__$1);
var G__7055 = cljs.core.chunk_rest.call(null,seq__7047__$1);
var G__7056 = c__5567__auto__;
var G__7057 = cljs.core.count.call(null,c__5567__auto__);
var G__7058 = (0);
seq__7047 = G__7055;
chunk__7048 = G__7056;
count__7049 = G__7057;
i__7050 = G__7058;
continue;
} else {
var param = cljs.core.first.call(null,seq__7047__$1);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7059 = cljs.core.next.call(null,seq__7047__$1);
var G__7060 = null;
var G__7061 = (0);
var G__7062 = (0);
seq__7047 = G__7059;
chunk__7048 = G__7060;
count__7049 = G__7061;
i__7050 = G__7062;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__7063){
var map__7064 = p__7063;
var map__7064__$1 = cljs.core.__destructure_map.call(null,map__7064);
var expr = cljs.core.get.call(null,map__7064__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.call(null,map__7064__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__7064__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__7064__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__7064__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__7064__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__9255__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(function ",cljs.compiler.munge.call(null,name),"(");

cljs.compiler.emit_fn_params.call(null,params);

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emits.call(null,"})");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_.call(null,startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.call(null,"var ",i," = 0, ",a," = new Array(arguments.length -  ",startslice,");");

cljs.compiler.emitln.call(null,"while (",i," < ",a,".length) {",a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}");

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__7065){
var map__7066 = p__7065;
var map__7066__$1 = cljs.core.__destructure_map.call(null,map__7066);
var f = map__7066__$1;
var expr = cljs.core.get.call(null,map__7066__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.call(null,map__7066__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.call(null,map__7066__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.call(null,map__7066__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__7066__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__7066__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__7066__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__7066__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__9255__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var name_7075__$1 = (function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_7076 = cljs.compiler.munge.call(null,name_7075__$1);
var delegate_name_7077 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7076),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function() { ");

cljs.compiler.emits.call(null,"var ",delegate_name_7077," = function (");

var seq__7067_7078 = cljs.core.seq.call(null,params);
var chunk__7068_7079 = null;
var count__7069_7080 = (0);
var i__7070_7081 = (0);
while(true){
if((i__7070_7081 < count__7069_7080)){
var param_7082 = cljs.core._nth.call(null,chunk__7068_7079,i__7070_7081);
cljs.compiler.emit.call(null,param_7082);

if(cljs.core._EQ_.call(null,param_7082,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7083 = seq__7067_7078;
var G__7084 = chunk__7068_7079;
var G__7085 = count__7069_7080;
var G__7086 = (i__7070_7081 + (1));
seq__7067_7078 = G__7083;
chunk__7068_7079 = G__7084;
count__7069_7080 = G__7085;
i__7070_7081 = G__7086;
continue;
} else {
var temp__5804__auto___7087 = cljs.core.seq.call(null,seq__7067_7078);
if(temp__5804__auto___7087){
var seq__7067_7088__$1 = temp__5804__auto___7087;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7067_7088__$1)){
var c__5567__auto___7089 = cljs.core.chunk_first.call(null,seq__7067_7088__$1);
var G__7090 = cljs.core.chunk_rest.call(null,seq__7067_7088__$1);
var G__7091 = c__5567__auto___7089;
var G__7092 = cljs.core.count.call(null,c__5567__auto___7089);
var G__7093 = (0);
seq__7067_7078 = G__7090;
chunk__7068_7079 = G__7091;
count__7069_7080 = G__7092;
i__7070_7081 = G__7093;
continue;
} else {
var param_7094 = cljs.core.first.call(null,seq__7067_7088__$1);
cljs.compiler.emit.call(null,param_7094);

if(cljs.core._EQ_.call(null,param_7094,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7095 = cljs.core.next.call(null,seq__7067_7088__$1);
var G__7096 = null;
var G__7097 = (0);
var G__7098 = (0);
seq__7067_7078 = G__7095;
chunk__7068_7079 = G__7096;
count__7069_7080 = G__7097;
i__7070_7081 = G__7098;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,"var ",mname_7076," = function (",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",(cljs.core.count.call(null,params) - (1)),") {");

var a_7099 = cljs.compiler.emit_arguments_to_array.call(null,(cljs.core.count.call(null,params) - (1)));
cljs.compiler.emitln.call(null,"  ",cljs.core.last.call(null,params)," = new cljs.core.IndexedSeq(",a_7099,",0,null);");

cljs.compiler.emitln.call(null,"} ");
} else {
}

cljs.compiler.emits.call(null,"return ",delegate_name_7077,".call(this,");

var seq__7071_7100 = cljs.core.seq.call(null,params);
var chunk__7072_7101 = null;
var count__7073_7102 = (0);
var i__7074_7103 = (0);
while(true){
if((i__7074_7103 < count__7073_7102)){
var param_7104 = cljs.core._nth.call(null,chunk__7072_7101,i__7074_7103);
cljs.compiler.emit.call(null,param_7104);

if(cljs.core._EQ_.call(null,param_7104,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7105 = seq__7071_7100;
var G__7106 = chunk__7072_7101;
var G__7107 = count__7073_7102;
var G__7108 = (i__7074_7103 + (1));
seq__7071_7100 = G__7105;
chunk__7072_7101 = G__7106;
count__7073_7102 = G__7107;
i__7074_7103 = G__7108;
continue;
} else {
var temp__5804__auto___7109 = cljs.core.seq.call(null,seq__7071_7100);
if(temp__5804__auto___7109){
var seq__7071_7110__$1 = temp__5804__auto___7109;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7071_7110__$1)){
var c__5567__auto___7111 = cljs.core.chunk_first.call(null,seq__7071_7110__$1);
var G__7112 = cljs.core.chunk_rest.call(null,seq__7071_7110__$1);
var G__7113 = c__5567__auto___7111;
var G__7114 = cljs.core.count.call(null,c__5567__auto___7111);
var G__7115 = (0);
seq__7071_7100 = G__7112;
chunk__7072_7101 = G__7113;
count__7073_7102 = G__7114;
i__7074_7103 = G__7115;
continue;
} else {
var param_7116 = cljs.core.first.call(null,seq__7071_7110__$1);
cljs.compiler.emit.call(null,param_7116);

if(cljs.core._EQ_.call(null,param_7116,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7117 = cljs.core.next.call(null,seq__7071_7110__$1);
var G__7118 = null;
var G__7119 = (0);
var G__7120 = (0);
seq__7071_7100 = G__7117;
chunk__7072_7101 = G__7118;
count__7073_7102 = G__7119;
i__7074_7103 = G__7120;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,");");

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,mname_7076,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.call(null,mname_7076,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to.call(null,cljs.core.assoc.call(null,f,new cljs.core.Keyword(null,"name","name",1843675177),name_7075__$1));

cljs.compiler.emitln.call(null,";");

cljs.compiler.emitln.call(null,mname_7076,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_7077,";");

cljs.compiler.emitln.call(null,"return ",mname_7076,";");

cljs.compiler.emitln.call(null,"})()");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__7124){
var map__7125 = p__7124;
var map__7125__$1 = cljs.core.__destructure_map.call(null,map__7125);
var variadic = cljs.core.get.call(null,map__7125__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.call(null,map__7125__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__7125__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.call(null,map__7125__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.call(null,map__7125__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.call(null,map__7125__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.call(null,map__7125__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.call(null,map__7125__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.filter.call(null,(function (p1__7121_SHARP_){
var and__5043__auto__ = p1__7121_SHARP_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__7121_SHARP_));
} else {
return and__5043__auto__;
}
}),recur_frames));
var loop_locals = cljs.core.seq.call(null,cljs.core.map.call(null,cljs.compiler.munge,cljs.core.concat.call(null,recur_params,(cljs.core.truth_((function (){var or__5045__auto__ = in_loop;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.seq.call(null,recur_params);
}
})())?cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),loop_lets):null))));
if(loop_locals){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"((function (",cljs.compiler.comma_sep.call(null,cljs.core.map.call(null,cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.call(null,"return ");
}
} else {
}

if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_7177__$1 = (function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_7178 = cljs.compiler.munge.call(null,name_7177__$1);
var maxparams_7179 = cljs.core.apply.call(null,cljs.core.max_key,cljs.core.count,cljs.core.map.call(null,new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_7180 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7178),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_7181 = cljs.core.sort_by.call(null,(function (p1__7122_SHARP_){
return cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,p1__7122_SHARP_)));
}),cljs.core.seq.call(null,mmap_7180));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"(function() {");

cljs.compiler.emitln.call(null,"var ",mname_7178," = null;");

var seq__7126_7182 = cljs.core.seq.call(null,ms_7181);
var chunk__7127_7183 = null;
var count__7128_7184 = (0);
var i__7129_7185 = (0);
while(true){
if((i__7129_7185 < count__7128_7184)){
var vec__7136_7186 = cljs.core._nth.call(null,chunk__7127_7183,i__7129_7185);
var n_7187 = cljs.core.nth.call(null,vec__7136_7186,(0),null);
var meth_7188 = cljs.core.nth.call(null,vec__7136_7186,(1),null);
cljs.compiler.emits.call(null,"var ",n_7187," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7188))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_7188);
} else {
cljs.compiler.emit_fn_method.call(null,meth_7188);
}

cljs.compiler.emitln.call(null,";");


var G__7189 = seq__7126_7182;
var G__7190 = chunk__7127_7183;
var G__7191 = count__7128_7184;
var G__7192 = (i__7129_7185 + (1));
seq__7126_7182 = G__7189;
chunk__7127_7183 = G__7190;
count__7128_7184 = G__7191;
i__7129_7185 = G__7192;
continue;
} else {
var temp__5804__auto___7193 = cljs.core.seq.call(null,seq__7126_7182);
if(temp__5804__auto___7193){
var seq__7126_7194__$1 = temp__5804__auto___7193;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7126_7194__$1)){
var c__5567__auto___7195 = cljs.core.chunk_first.call(null,seq__7126_7194__$1);
var G__7196 = cljs.core.chunk_rest.call(null,seq__7126_7194__$1);
var G__7197 = c__5567__auto___7195;
var G__7198 = cljs.core.count.call(null,c__5567__auto___7195);
var G__7199 = (0);
seq__7126_7182 = G__7196;
chunk__7127_7183 = G__7197;
count__7128_7184 = G__7198;
i__7129_7185 = G__7199;
continue;
} else {
var vec__7139_7200 = cljs.core.first.call(null,seq__7126_7194__$1);
var n_7201 = cljs.core.nth.call(null,vec__7139_7200,(0),null);
var meth_7202 = cljs.core.nth.call(null,vec__7139_7200,(1),null);
cljs.compiler.emits.call(null,"var ",n_7201," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7202))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_7202);
} else {
cljs.compiler.emit_fn_method.call(null,meth_7202);
}

cljs.compiler.emitln.call(null,";");


var G__7203 = cljs.core.next.call(null,seq__7126_7194__$1);
var G__7204 = null;
var G__7205 = (0);
var G__7206 = (0);
seq__7126_7182 = G__7203;
chunk__7127_7183 = G__7204;
count__7128_7184 = G__7205;
i__7129_7185 = G__7206;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,mname_7178," = function(",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,maxparams_7179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_7179)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,maxparams_7179));

cljs.compiler.emitln.call(null," = var_args;");
} else {
}

cljs.compiler.emitln.call(null,"switch(arguments.length){");

var seq__7142_7207 = cljs.core.seq.call(null,ms_7181);
var chunk__7143_7208 = null;
var count__7144_7209 = (0);
var i__7145_7210 = (0);
while(true){
if((i__7145_7210 < count__7144_7209)){
var vec__7152_7211 = cljs.core._nth.call(null,chunk__7143_7208,i__7145_7210);
var n_7212 = cljs.core.nth.call(null,vec__7152_7211,(0),null);
var meth_7213 = cljs.core.nth.call(null,vec__7152_7211,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7213))){
cljs.compiler.emitln.call(null,"default:");

var restarg_7214 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_7214," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_7215 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_7214," = new cljs.core.IndexedSeq(",a_7215,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_7212,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_7179)),(((cljs.core.count.call(null,maxparams_7179) > (1)))?", ":null),restarg_7214,");");
} else {
var pcnt_7216 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7213));
cljs.compiler.emitln.call(null,"case ",pcnt_7216,":");

cljs.compiler.emitln.call(null,"return ",n_7212,".call(this",(((pcnt_7216 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_7216,maxparams_7179)),null,(1),null)),(2),null))),");");
}


var G__7217 = seq__7142_7207;
var G__7218 = chunk__7143_7208;
var G__7219 = count__7144_7209;
var G__7220 = (i__7145_7210 + (1));
seq__7142_7207 = G__7217;
chunk__7143_7208 = G__7218;
count__7144_7209 = G__7219;
i__7145_7210 = G__7220;
continue;
} else {
var temp__5804__auto___7221 = cljs.core.seq.call(null,seq__7142_7207);
if(temp__5804__auto___7221){
var seq__7142_7222__$1 = temp__5804__auto___7221;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7142_7222__$1)){
var c__5567__auto___7223 = cljs.core.chunk_first.call(null,seq__7142_7222__$1);
var G__7224 = cljs.core.chunk_rest.call(null,seq__7142_7222__$1);
var G__7225 = c__5567__auto___7223;
var G__7226 = cljs.core.count.call(null,c__5567__auto___7223);
var G__7227 = (0);
seq__7142_7207 = G__7224;
chunk__7143_7208 = G__7225;
count__7144_7209 = G__7226;
i__7145_7210 = G__7227;
continue;
} else {
var vec__7155_7228 = cljs.core.first.call(null,seq__7142_7222__$1);
var n_7229 = cljs.core.nth.call(null,vec__7155_7228,(0),null);
var meth_7230 = cljs.core.nth.call(null,vec__7155_7228,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7230))){
cljs.compiler.emitln.call(null,"default:");

var restarg_7231 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_7231," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_7232 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_7231," = new cljs.core.IndexedSeq(",a_7232,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_7229,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_7179)),(((cljs.core.count.call(null,maxparams_7179) > (1)))?", ":null),restarg_7231,");");
} else {
var pcnt_7233 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7230));
cljs.compiler.emitln.call(null,"case ",pcnt_7233,":");

cljs.compiler.emitln.call(null,"return ",n_7229,".call(this",(((pcnt_7233 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_7233,maxparams_7179)),null,(1),null)),(2),null))),");");
}


var G__7234 = cljs.core.next.call(null,seq__7142_7222__$1);
var G__7235 = null;
var G__7236 = (0);
var G__7237 = (0);
seq__7142_7207 = G__7234;
chunk__7143_7208 = G__7235;
count__7144_7209 = G__7236;
i__7145_7210 = G__7237;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"}");

var arg_count_js_7238 = ((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,cljs.core.first.call(null,ms_7181)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.call(null,"throw(new Error('Invalid arity: ' + ",arg_count_js_7238,"));");

cljs.compiler.emitln.call(null,"};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.call(null,mname_7178,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.call(null,mname_7178,".cljs$lang$applyTo = ",cljs.core.some.call(null,(function (p1__7123_SHARP_){
var vec__7158 = p1__7123_SHARP_;
var n = cljs.core.nth.call(null,vec__7158,(0),null);
var m = cljs.core.nth.call(null,vec__7158,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_7181),".cljs$lang$applyTo;");
} else {
}

var seq__7161_7239 = cljs.core.seq.call(null,ms_7181);
var chunk__7162_7240 = null;
var count__7163_7241 = (0);
var i__7164_7242 = (0);
while(true){
if((i__7164_7242 < count__7163_7241)){
var vec__7171_7243 = cljs.core._nth.call(null,chunk__7162_7240,i__7164_7242);
var n_7244 = cljs.core.nth.call(null,vec__7171_7243,(0),null);
var meth_7245 = cljs.core.nth.call(null,vec__7171_7243,(1),null);
var c_7246 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7245));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7245))){
cljs.compiler.emitln.call(null,mname_7178,".cljs$core$IFn$_invoke$arity$variadic = ",n_7244,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_7178,".cljs$core$IFn$_invoke$arity$",c_7246," = ",n_7244,";");
}


var G__7247 = seq__7161_7239;
var G__7248 = chunk__7162_7240;
var G__7249 = count__7163_7241;
var G__7250 = (i__7164_7242 + (1));
seq__7161_7239 = G__7247;
chunk__7162_7240 = G__7248;
count__7163_7241 = G__7249;
i__7164_7242 = G__7250;
continue;
} else {
var temp__5804__auto___7251 = cljs.core.seq.call(null,seq__7161_7239);
if(temp__5804__auto___7251){
var seq__7161_7252__$1 = temp__5804__auto___7251;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7161_7252__$1)){
var c__5567__auto___7253 = cljs.core.chunk_first.call(null,seq__7161_7252__$1);
var G__7254 = cljs.core.chunk_rest.call(null,seq__7161_7252__$1);
var G__7255 = c__5567__auto___7253;
var G__7256 = cljs.core.count.call(null,c__5567__auto___7253);
var G__7257 = (0);
seq__7161_7239 = G__7254;
chunk__7162_7240 = G__7255;
count__7163_7241 = G__7256;
i__7164_7242 = G__7257;
continue;
} else {
var vec__7174_7258 = cljs.core.first.call(null,seq__7161_7252__$1);
var n_7259 = cljs.core.nth.call(null,vec__7174_7258,(0),null);
var meth_7260 = cljs.core.nth.call(null,vec__7174_7258,(1),null);
var c_7261 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7260));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7260))){
cljs.compiler.emitln.call(null,mname_7178,".cljs$core$IFn$_invoke$arity$variadic = ",n_7259,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_7178,".cljs$core$IFn$_invoke$arity$",c_7261," = ",n_7259,";");
}


var G__7262 = cljs.core.next.call(null,seq__7161_7252__$1);
var G__7263 = null;
var G__7264 = (0);
var G__7265 = (0);
seq__7161_7239 = G__7262;
chunk__7162_7240 = G__7263;
count__7163_7241 = G__7264;
i__7164_7242 = G__7265;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"return ",mname_7178,";");

cljs.compiler.emitln.call(null,"})()");
}

if(loop_locals){
return cljs.compiler.emitln.call(null,";})(",cljs.compiler.comma_sep.call(null,loop_locals),"))");
} else {
return null;
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"do","do",46310725),(function (p__7266){
var map__7267 = p__7266;
var map__7267__$1 = cljs.core.__destructure_map.call(null,map__7267);
var statements = cljs.core.get.call(null,map__7267__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.call(null,map__7267__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.call(null,map__7267__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

var seq__7268_7272 = cljs.core.seq.call(null,statements);
var chunk__7269_7273 = null;
var count__7270_7274 = (0);
var i__7271_7275 = (0);
while(true){
if((i__7271_7275 < count__7270_7274)){
var s_7276 = cljs.core._nth.call(null,chunk__7269_7273,i__7271_7275);
cljs.compiler.emitln.call(null,s_7276);


var G__7277 = seq__7268_7272;
var G__7278 = chunk__7269_7273;
var G__7279 = count__7270_7274;
var G__7280 = (i__7271_7275 + (1));
seq__7268_7272 = G__7277;
chunk__7269_7273 = G__7278;
count__7270_7274 = G__7279;
i__7271_7275 = G__7280;
continue;
} else {
var temp__5804__auto___7281 = cljs.core.seq.call(null,seq__7268_7272);
if(temp__5804__auto___7281){
var seq__7268_7282__$1 = temp__5804__auto___7281;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7268_7282__$1)){
var c__5567__auto___7283 = cljs.core.chunk_first.call(null,seq__7268_7282__$1);
var G__7284 = cljs.core.chunk_rest.call(null,seq__7268_7282__$1);
var G__7285 = c__5567__auto___7283;
var G__7286 = cljs.core.count.call(null,c__5567__auto___7283);
var G__7287 = (0);
seq__7268_7272 = G__7284;
chunk__7269_7273 = G__7285;
count__7270_7274 = G__7286;
i__7271_7275 = G__7287;
continue;
} else {
var s_7288 = cljs.core.first.call(null,seq__7268_7282__$1);
cljs.compiler.emitln.call(null,s_7288);


var G__7289 = cljs.core.next.call(null,seq__7268_7282__$1);
var G__7290 = null;
var G__7291 = (0);
var G__7292 = (0);
seq__7268_7272 = G__7289;
chunk__7269_7273 = G__7290;
count__7270_7274 = G__7291;
i__7271_7275 = G__7292;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit.call(null,ret);

if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.call(null,"})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__7293){
var map__7294 = p__7293;
var map__7294__$1 = cljs.core.__destructure_map.call(null,map__7294);
var try$ = cljs.core.get.call(null,map__7294__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.call(null,map__7294__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.call(null,map__7294__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.call(null,map__7294__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.call(null,map__7294__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,"try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.call(null,"catch (",cljs.compiler.munge.call(null,name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote.call(null,finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.call(null,"finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.call(null,try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__7295,is_loop){
var map__7296 = p__7295;
var map__7296__$1 = cljs.core.__destructure_map.call(null,map__7296);
var expr = cljs.core.get.call(null,map__7296__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__7296__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__7296__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__7297_7307 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__7298_7308 = cljs.core.into.call(null,cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.call(null,(function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope.call(null,binding),cljs.core.gensym.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__7298_7308);

try{var seq__7299_7309 = cljs.core.seq.call(null,bindings);
var chunk__7300_7310 = null;
var count__7301_7311 = (0);
var i__7302_7312 = (0);
while(true){
if((i__7302_7312 < count__7301_7311)){
var map__7305_7313 = cljs.core._nth.call(null,chunk__7300_7310,i__7302_7312);
var map__7305_7314__$1 = cljs.core.__destructure_map.call(null,map__7305_7313);
var binding_7315 = map__7305_7314__$1;
var init_7316 = cljs.core.get.call(null,map__7305_7314__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_7315);

cljs.compiler.emitln.call(null," = ",init_7316,";");


var G__7317 = seq__7299_7309;
var G__7318 = chunk__7300_7310;
var G__7319 = count__7301_7311;
var G__7320 = (i__7302_7312 + (1));
seq__7299_7309 = G__7317;
chunk__7300_7310 = G__7318;
count__7301_7311 = G__7319;
i__7302_7312 = G__7320;
continue;
} else {
var temp__5804__auto___7321 = cljs.core.seq.call(null,seq__7299_7309);
if(temp__5804__auto___7321){
var seq__7299_7322__$1 = temp__5804__auto___7321;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7299_7322__$1)){
var c__5567__auto___7323 = cljs.core.chunk_first.call(null,seq__7299_7322__$1);
var G__7324 = cljs.core.chunk_rest.call(null,seq__7299_7322__$1);
var G__7325 = c__5567__auto___7323;
var G__7326 = cljs.core.count.call(null,c__5567__auto___7323);
var G__7327 = (0);
seq__7299_7309 = G__7324;
chunk__7300_7310 = G__7325;
count__7301_7311 = G__7326;
i__7302_7312 = G__7327;
continue;
} else {
var map__7306_7328 = cljs.core.first.call(null,seq__7299_7322__$1);
var map__7306_7329__$1 = cljs.core.__destructure_map.call(null,map__7306_7328);
var binding_7330 = map__7306_7329__$1;
var init_7331 = cljs.core.get.call(null,map__7306_7329__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_7330);

cljs.compiler.emitln.call(null," = ",init_7331,";");


var G__7332 = cljs.core.next.call(null,seq__7299_7322__$1);
var G__7333 = null;
var G__7334 = (0);
var G__7335 = (0);
seq__7299_7309 = G__7332;
chunk__7300_7310 = G__7333;
count__7301_7311 = G__7334;
i__7302_7312 = G__7335;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__7297_7307);
}
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let.call(null,ast,false);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let.call(null,ast,true);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__7336){
var map__7337 = p__7336;
var map__7337__$1 = cljs.core.__destructure_map.call(null,map__7337);
var frame = cljs.core.get.call(null,map__7337__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.call(null,map__7337__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.call(null,map__7337__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec.call(null,cljs.core.take.call(null,cljs.core.count.call(null,exprs),cljs.core.repeatedly.call(null,cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__5635__auto___7338 = cljs.core.count.call(null,exprs);
var i_7339 = (0);
while(true){
if((i_7339 < n__5635__auto___7338)){
cljs.compiler.emitln.call(null,"var ",temps.call(null,i_7339)," = ",exprs.call(null,i_7339),";");

var G__7340 = (i_7339 + (1));
i_7339 = G__7340;
continue;
} else {
}
break;
}

var n__5635__auto___7341 = cljs.core.count.call(null,exprs);
var i_7342 = (0);
while(true){
if((i_7342 < n__5635__auto___7341)){
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,params.call(null,i_7342))," = ",temps.call(null,i_7342),";");

var G__7343 = (i_7342 + (1));
i_7342 = G__7343;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.call(null,"continue;");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__7344){
var map__7345 = p__7344;
var map__7345__$1 = cljs.core.__destructure_map.call(null,map__7345);
var expr = cljs.core.get.call(null,map__7345__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__7345__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__7345__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var seq__7346_7354 = cljs.core.seq.call(null,bindings);
var chunk__7347_7355 = null;
var count__7348_7356 = (0);
var i__7349_7357 = (0);
while(true){
if((i__7349_7357 < count__7348_7356)){
var map__7352_7358 = cljs.core._nth.call(null,chunk__7347_7355,i__7349_7357);
var map__7352_7359__$1 = cljs.core.__destructure_map.call(null,map__7352_7358);
var binding_7360 = map__7352_7359__$1;
var init_7361 = cljs.core.get.call(null,map__7352_7359__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_7360)," = ",init_7361,";");


var G__7362 = seq__7346_7354;
var G__7363 = chunk__7347_7355;
var G__7364 = count__7348_7356;
var G__7365 = (i__7349_7357 + (1));
seq__7346_7354 = G__7362;
chunk__7347_7355 = G__7363;
count__7348_7356 = G__7364;
i__7349_7357 = G__7365;
continue;
} else {
var temp__5804__auto___7366 = cljs.core.seq.call(null,seq__7346_7354);
if(temp__5804__auto___7366){
var seq__7346_7367__$1 = temp__5804__auto___7366;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7346_7367__$1)){
var c__5567__auto___7368 = cljs.core.chunk_first.call(null,seq__7346_7367__$1);
var G__7369 = cljs.core.chunk_rest.call(null,seq__7346_7367__$1);
var G__7370 = c__5567__auto___7368;
var G__7371 = cljs.core.count.call(null,c__5567__auto___7368);
var G__7372 = (0);
seq__7346_7354 = G__7369;
chunk__7347_7355 = G__7370;
count__7348_7356 = G__7371;
i__7349_7357 = G__7372;
continue;
} else {
var map__7353_7373 = cljs.core.first.call(null,seq__7346_7367__$1);
var map__7353_7374__$1 = cljs.core.__destructure_map.call(null,map__7353_7373);
var binding_7375 = map__7353_7374__$1;
var init_7376 = cljs.core.get.call(null,map__7353_7374__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_7375)," = ",init_7376,";");


var G__7377 = cljs.core.next.call(null,seq__7346_7367__$1);
var G__7378 = null;
var G__7379 = (0);
var G__7380 = (0);
seq__7346_7354 = G__7377;
chunk__7347_7355 = G__7378;
count__7348_7356 = G__7379;
i__7349_7357 = G__7380;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,expr);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__7383){
var map__7384 = p__7383;
var map__7384__$1 = cljs.core.__destructure_map.call(null,map__7384);
var expr = map__7384__$1;
var f = cljs.core.get.call(null,map__7384__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.call(null,map__7384__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7384__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__5043__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = cljs.core.not.call(null,new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__5043__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__5043__auto__ = protocol;
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = tag;
if(cljs.core.truth_(and__5043__auto____$1)){
var or__5045__auto__ = (function (){var and__5043__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto____$2)){
var and__5043__auto____$3 = protocol;
if(cljs.core.truth_(and__5043__auto____$3)){
return cljs.core._EQ_.call(null,tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__5043__auto____$3;
}
} else {
return and__5043__auto____$2;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto____$2 = (function (){var or__5045__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__5043__auto____$2)){
var or__5045__auto____$1 = cljs.core._EQ_.call(null,protocol,tag);
if(or__5045__auto____$1){
return or__5045__auto____$1;
} else {
var and__5043__auto____$3 = (!(cljs.core.set_QMARK_.call(null,tag)));
if(and__5043__auto____$3){
var and__5043__auto____$4 = cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null).call(null,tag));
if(and__5043__auto____$4){
var temp__5804__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var.call(null,env,cljs.core.vary_meta.call(null,tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5804__auto__)){
var ps = temp__5804__auto__;
return ps.call(null,protocol);
} else {
return null;
}
} else {
return and__5043__auto____$4;
}
} else {
return and__5043__auto____$3;
}
}
} else {
return and__5043__auto____$2;
}
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.call(null,first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null).call(null,first_arg_tag))));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag.call(null,env,f);
var js_QMARK_ = (function (){var or__5045__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__5045__auto____$1){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__5045__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = (function (){var temp__5804__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5804__auto__)){
var ns_str = temp__5804__auto__;
return cljs.core._EQ_.call(null,cljs.core.get.call(null,clojure.string.split.call(null,ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__5045__auto__ = cljs.core._EQ_.call(null,new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__5045__auto__){
return or__5045__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote.call(null,f);
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__7385 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count.call(null,args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not.call(null,variadic_QMARK_)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (arity > mfa);
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7381_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__7381_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.call(null,cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7382_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__7382_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.call(null,vec__7385,(0),null);
var variadic_invoke = cljs.core.nth.call(null,vec__7385,(1),null);
var env__9255__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.call(null,"(!(",cljs.core.first.call(null,args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.call(null,"((",cljs.core.first.call(null,args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_7388 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.compiler.protocol_prefix.call(null,protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.core.name.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
cljs.compiler.emits.call(null,cljs.core.first.call(null,args),".",pimpl_7388,"(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",cljs.core.rest.call(null,args))),")");
} else {
if(keyword_QMARK_){
cljs.compiler.emits.call(null,f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count.call(null,args),"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_7389 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,mfa_7389,args)),(((mfa_7389 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.compiler.comma_sep.call(null,cljs.core.drop.call(null,mfa_7389,args)),"], 0))");
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1));
} else {
return and__5043__auto__;
}
})())){
var fprop_7390 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.call(null,"(",f__$1,fprop_7390," ? ",f__$1,fprop_7390,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,"(",cljs.compiler.comma_sep.call(null,args),"))");
} else {
cljs.compiler.emits.call(null,"(",f__$1,fprop_7390," ? ",f__$1,fprop_7390,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),"))");
}
} else {
cljs.compiler.emits.call(null,f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__7391){
var map__7392 = p__7391;
var map__7392__$1 = cljs.core.__destructure_map.call(null,map__7392);
var ctor = cljs.core.get.call(null,map__7392__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.call(null,map__7392__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7392__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9255__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(new ",ctor,"(",cljs.compiler.comma_sep.call(null,args),"))");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__7393){
var map__7394 = p__7393;
var map__7394__$1 = cljs.core.__destructure_map.call(null,map__7394);
var target = cljs.core.get.call(null,map__7394__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.call(null,map__7394__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.call(null,map__7394__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9255__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(",target," = ",val,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.call(null,sublib,/\./);
return cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,(function (p1__7395_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__7395_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__7396 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__7396,(0),null);
var sublib = cljs.core.nth.call(null,vec__7396,(1),null);
return cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib)," = goog.global",cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,(function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.call(null,cljs.core.name.call(null,(function (){var or__5045__auto__ = cljs.core.get.call(null,global_exports,cljs.core.symbol.call(null,lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,global_exports,cljs.core.name.call(null,lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.compiler.sublib_select.call(null,sublib),";");
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__7399 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__7399__$1 = cljs.core.__destructure_map.call(null,map__7399);
var options = cljs.core.get.call(null,map__7399__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.call(null,map__7399__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__7400 = options;
var map__7400__$1 = cljs.core.__destructure_map.call(null,map__7400);
var target = cljs.core.get.call(null,map__7400__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.call(null,map__7400__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.call(null,map__7400__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.call(null,cljs.core.gensym.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__7401 = (function (){var libs__$1 = cljs.core.remove.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,seen)),cljs.core.filter.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,libs)),deps));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__7407 = cljs.core.group_by.call(null,cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__7407__$1 = cljs.core.__destructure_map.call(null,map__7407);
var node_libs = cljs.core.get.call(null,map__7407__$1,true);
var libs_to_load = cljs.core.get.call(null,map__7407__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.call(null,vec__7401,(0),null);
var libs_to_load = cljs.core.nth.call(null,vec__7401,(1),null);
var vec__7404 = (function (){var map__7408 = cljs.core.group_by.call(null,cljs.analyzer.goog_module_dep_QMARK_,libs_to_load);
var map__7408__$1 = cljs.core.__destructure_map.call(null,map__7408);
var goog_modules = cljs.core.get.call(null,map__7408__$1,true);
var libs_to_load__$1 = cljs.core.get.call(null,map__7408__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goog_modules,libs_to_load__$1], null);
})();
var goog_modules = cljs.core.nth.call(null,vec__7404,(0),null);
var libs_to_load__$1 = cljs.core.nth.call(null,vec__7404,(1),null);
var global_exports_libs = cljs.core.filter.call(null,cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load__$1);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__7409_7453 = cljs.core.seq.call(null,libs_to_load__$1);
var chunk__7410_7454 = null;
var count__7411_7455 = (0);
var i__7412_7456 = (0);
while(true){
if((i__7412_7456 < count__7411_7455)){
var lib_7457 = cljs.core._nth.call(null,chunk__7410_7454,i__7412_7456);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_7457)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7457),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7457),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7457),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7457),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_7457,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7457),"');");
}

}
}
}


var G__7458 = seq__7409_7453;
var G__7459 = chunk__7410_7454;
var G__7460 = count__7411_7455;
var G__7461 = (i__7412_7456 + (1));
seq__7409_7453 = G__7458;
chunk__7410_7454 = G__7459;
count__7411_7455 = G__7460;
i__7412_7456 = G__7461;
continue;
} else {
var temp__5804__auto___7462 = cljs.core.seq.call(null,seq__7409_7453);
if(temp__5804__auto___7462){
var seq__7409_7463__$1 = temp__5804__auto___7462;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7409_7463__$1)){
var c__5567__auto___7464 = cljs.core.chunk_first.call(null,seq__7409_7463__$1);
var G__7465 = cljs.core.chunk_rest.call(null,seq__7409_7463__$1);
var G__7466 = c__5567__auto___7464;
var G__7467 = cljs.core.count.call(null,c__5567__auto___7464);
var G__7468 = (0);
seq__7409_7453 = G__7465;
chunk__7410_7454 = G__7466;
count__7411_7455 = G__7467;
i__7412_7456 = G__7468;
continue;
} else {
var lib_7469 = cljs.core.first.call(null,seq__7409_7463__$1);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_7469)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7469),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7469),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7469),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7469),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_7469,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7469),"');");
}

}
}
}


var G__7470 = cljs.core.next.call(null,seq__7409_7463__$1);
var G__7471 = null;
var G__7472 = (0);
var G__7473 = (0);
seq__7409_7453 = G__7470;
chunk__7410_7454 = G__7471;
count__7411_7455 = G__7472;
i__7412_7456 = G__7473;
continue;
}
} else {
}
}
break;
}

var seq__7413_7474 = cljs.core.seq.call(null,node_libs);
var chunk__7414_7475 = null;
var count__7415_7476 = (0);
var i__7416_7477 = (0);
while(true){
if((i__7416_7477 < count__7415_7476)){
var lib_7478 = cljs.core._nth.call(null,chunk__7414_7475,i__7416_7477);
var vec__7423_7479 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7478);
var lib_SINGLEQUOTE__7480 = cljs.core.nth.call(null,vec__7423_7479,(0),null);
var sublib_7481 = cljs.core.nth.call(null,vec__7423_7479,(1),null);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_7478)," = require('",lib_SINGLEQUOTE__7480,"')",cljs.compiler.sublib_select.call(null,sublib_7481),";");


var G__7482 = seq__7413_7474;
var G__7483 = chunk__7414_7475;
var G__7484 = count__7415_7476;
var G__7485 = (i__7416_7477 + (1));
seq__7413_7474 = G__7482;
chunk__7414_7475 = G__7483;
count__7415_7476 = G__7484;
i__7416_7477 = G__7485;
continue;
} else {
var temp__5804__auto___7486 = cljs.core.seq.call(null,seq__7413_7474);
if(temp__5804__auto___7486){
var seq__7413_7487__$1 = temp__5804__auto___7486;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7413_7487__$1)){
var c__5567__auto___7488 = cljs.core.chunk_first.call(null,seq__7413_7487__$1);
var G__7489 = cljs.core.chunk_rest.call(null,seq__7413_7487__$1);
var G__7490 = c__5567__auto___7488;
var G__7491 = cljs.core.count.call(null,c__5567__auto___7488);
var G__7492 = (0);
seq__7413_7474 = G__7489;
chunk__7414_7475 = G__7490;
count__7415_7476 = G__7491;
i__7416_7477 = G__7492;
continue;
} else {
var lib_7493 = cljs.core.first.call(null,seq__7413_7487__$1);
var vec__7426_7494 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7493);
var lib_SINGLEQUOTE__7495 = cljs.core.nth.call(null,vec__7426_7494,(0),null);
var sublib_7496 = cljs.core.nth.call(null,vec__7426_7494,(1),null);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_7493)," = require('",lib_SINGLEQUOTE__7495,"')",cljs.compiler.sublib_select.call(null,sublib_7496),";");


var G__7497 = cljs.core.next.call(null,seq__7413_7487__$1);
var G__7498 = null;
var G__7499 = (0);
var G__7500 = (0);
seq__7413_7474 = G__7497;
chunk__7414_7475 = G__7498;
count__7415_7476 = G__7499;
i__7416_7477 = G__7500;
continue;
}
} else {
}
}
break;
}

var seq__7429_7501 = cljs.core.seq.call(null,goog_modules);
var chunk__7430_7502 = null;
var count__7431_7503 = (0);
var i__7432_7504 = (0);
while(true){
if((i__7432_7504 < count__7431_7503)){
var lib_7505 = cljs.core._nth.call(null,chunk__7430_7502,i__7432_7504);
var vec__7439_7506 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7505);
var lib_SINGLEQUOTE__7507 = cljs.core.nth.call(null,vec__7439_7506,(0),null);
var sublib_7508 = cljs.core.nth.call(null,vec__7439_7506,(1),null);
cljs.compiler.emitln.call(null,"goog.require('",lib_SINGLEQUOTE__7507,"');");

cljs.compiler.emitln.call(null,"goog.scope(function(){");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_goog_module_lib.call(null,lib_7505)," = goog.module.get('",lib_SINGLEQUOTE__7507,"')",cljs.compiler.sublib_select.call(null,sublib_7508),";");

cljs.compiler.emitln.call(null,"});");


var G__7509 = seq__7429_7501;
var G__7510 = chunk__7430_7502;
var G__7511 = count__7431_7503;
var G__7512 = (i__7432_7504 + (1));
seq__7429_7501 = G__7509;
chunk__7430_7502 = G__7510;
count__7431_7503 = G__7511;
i__7432_7504 = G__7512;
continue;
} else {
var temp__5804__auto___7513 = cljs.core.seq.call(null,seq__7429_7501);
if(temp__5804__auto___7513){
var seq__7429_7514__$1 = temp__5804__auto___7513;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7429_7514__$1)){
var c__5567__auto___7515 = cljs.core.chunk_first.call(null,seq__7429_7514__$1);
var G__7516 = cljs.core.chunk_rest.call(null,seq__7429_7514__$1);
var G__7517 = c__5567__auto___7515;
var G__7518 = cljs.core.count.call(null,c__5567__auto___7515);
var G__7519 = (0);
seq__7429_7501 = G__7516;
chunk__7430_7502 = G__7517;
count__7431_7503 = G__7518;
i__7432_7504 = G__7519;
continue;
} else {
var lib_7520 = cljs.core.first.call(null,seq__7429_7514__$1);
var vec__7442_7521 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7520);
var lib_SINGLEQUOTE__7522 = cljs.core.nth.call(null,vec__7442_7521,(0),null);
var sublib_7523 = cljs.core.nth.call(null,vec__7442_7521,(1),null);
cljs.compiler.emitln.call(null,"goog.require('",lib_SINGLEQUOTE__7522,"');");

cljs.compiler.emitln.call(null,"goog.scope(function(){");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_goog_module_lib.call(null,lib_7520)," = goog.module.get('",lib_SINGLEQUOTE__7522,"')",cljs.compiler.sublib_select.call(null,sublib_7523),";");

cljs.compiler.emitln.call(null,"});");


var G__7524 = cljs.core.next.call(null,seq__7429_7514__$1);
var G__7525 = null;
var G__7526 = (0);
var G__7527 = (0);
seq__7429_7501 = G__7524;
chunk__7430_7502 = G__7525;
count__7431_7503 = G__7526;
i__7432_7504 = G__7527;
continue;
}
} else {
}
}
break;
}

var seq__7445_7528 = cljs.core.seq.call(null,global_exports_libs);
var chunk__7446_7529 = null;
var count__7447_7530 = (0);
var i__7448_7531 = (0);
while(true){
if((i__7448_7531 < count__7447_7530)){
var lib_7532 = cljs.core._nth.call(null,chunk__7446_7529,i__7448_7531);
var map__7451_7533 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,cljs.core.first.call(null,cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7532))));
var map__7451_7534__$1 = cljs.core.__destructure_map.call(null,map__7451_7533);
var global_exports_7535 = cljs.core.get.call(null,map__7451_7534__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_7535,lib_7532);


var G__7536 = seq__7445_7528;
var G__7537 = chunk__7446_7529;
var G__7538 = count__7447_7530;
var G__7539 = (i__7448_7531 + (1));
seq__7445_7528 = G__7536;
chunk__7446_7529 = G__7537;
count__7447_7530 = G__7538;
i__7448_7531 = G__7539;
continue;
} else {
var temp__5804__auto___7540 = cljs.core.seq.call(null,seq__7445_7528);
if(temp__5804__auto___7540){
var seq__7445_7541__$1 = temp__5804__auto___7540;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7445_7541__$1)){
var c__5567__auto___7542 = cljs.core.chunk_first.call(null,seq__7445_7541__$1);
var G__7543 = cljs.core.chunk_rest.call(null,seq__7445_7541__$1);
var G__7544 = c__5567__auto___7542;
var G__7545 = cljs.core.count.call(null,c__5567__auto___7542);
var G__7546 = (0);
seq__7445_7528 = G__7543;
chunk__7446_7529 = G__7544;
count__7447_7530 = G__7545;
i__7448_7531 = G__7546;
continue;
} else {
var lib_7547 = cljs.core.first.call(null,seq__7445_7541__$1);
var map__7452_7548 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,cljs.core.first.call(null,cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7547))));
var map__7452_7549__$1 = cljs.core.__destructure_map.call(null,map__7452_7548);
var global_exports_7550 = cljs.core.get.call(null,map__7452_7549__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_7550,lib_7547);


var G__7551 = cljs.core.next.call(null,seq__7445_7541__$1);
var G__7552 = null;
var G__7553 = (0);
var G__7554 = (0);
seq__7445_7528 = G__7551;
chunk__7446_7529 = G__7552;
count__7447_7530 = G__7553;
i__7448_7531 = G__7554;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
return cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",loaded_libs,");");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__7555){
var map__7556 = p__7555;
var map__7556__$1 = cljs.core.__destructure_map.call(null,map__7556);
var name = cljs.core.get.call(null,map__7556__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__7556__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__7556__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__7556__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__7556__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__7556__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__7556__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"'nil';");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__7557){
var map__7558 = p__7557;
var map__7558__$1 = cljs.core.__destructure_map.call(null,map__7558);
var name = cljs.core.get.call(null,map__7558__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__7558__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__7558__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__7558__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__7558__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__7558__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__7558__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,name),"');");

if(cljs.core._EQ_.call(null,name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__7559){
var map__7560 = p__7559;
var map__7560__$1 = cljs.core.__destructure_map.call(null,map__7560);
var t = cljs.core.get.call(null,map__7560__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__7560__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__7560__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__7560__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__7560__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.call(null,cljs.compiler.munge,fields);
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__7561_7585 = cljs.core.seq.call(null,protocols);
var chunk__7562_7586 = null;
var count__7563_7587 = (0);
var i__7564_7588 = (0);
while(true){
if((i__7564_7588 < count__7563_7587)){
var protocol_7589 = cljs.core._nth.call(null,chunk__7562_7586,i__7564_7588);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7589)),"}");


var G__7590 = seq__7561_7585;
var G__7591 = chunk__7562_7586;
var G__7592 = count__7563_7587;
var G__7593 = (i__7564_7588 + (1));
seq__7561_7585 = G__7590;
chunk__7562_7586 = G__7591;
count__7563_7587 = G__7592;
i__7564_7588 = G__7593;
continue;
} else {
var temp__5804__auto___7594 = cljs.core.seq.call(null,seq__7561_7585);
if(temp__5804__auto___7594){
var seq__7561_7595__$1 = temp__5804__auto___7594;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7561_7595__$1)){
var c__5567__auto___7596 = cljs.core.chunk_first.call(null,seq__7561_7595__$1);
var G__7597 = cljs.core.chunk_rest.call(null,seq__7561_7595__$1);
var G__7598 = c__5567__auto___7596;
var G__7599 = cljs.core.count.call(null,c__5567__auto___7596);
var G__7600 = (0);
seq__7561_7585 = G__7597;
chunk__7562_7586 = G__7598;
count__7563_7587 = G__7599;
i__7564_7588 = G__7600;
continue;
} else {
var protocol_7601 = cljs.core.first.call(null,seq__7561_7595__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7601)),"}");


var G__7602 = cljs.core.next.call(null,seq__7561_7595__$1);
var G__7603 = null;
var G__7604 = (0);
var G__7605 = (0);
seq__7561_7585 = G__7602;
chunk__7562_7586 = G__7603;
count__7563_7587 = G__7604;
i__7564_7588 = G__7605;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__7565_7606 = cljs.core.seq.call(null,fields__$1);
var chunk__7566_7607 = null;
var count__7567_7608 = (0);
var i__7568_7609 = (0);
while(true){
if((i__7568_7609 < count__7567_7608)){
var fld_7610 = cljs.core._nth.call(null,chunk__7566_7607,i__7568_7609);
cljs.compiler.emitln.call(null,"this.",fld_7610," = ",fld_7610,";");


var G__7611 = seq__7565_7606;
var G__7612 = chunk__7566_7607;
var G__7613 = count__7567_7608;
var G__7614 = (i__7568_7609 + (1));
seq__7565_7606 = G__7611;
chunk__7566_7607 = G__7612;
count__7567_7608 = G__7613;
i__7568_7609 = G__7614;
continue;
} else {
var temp__5804__auto___7615 = cljs.core.seq.call(null,seq__7565_7606);
if(temp__5804__auto___7615){
var seq__7565_7616__$1 = temp__5804__auto___7615;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7565_7616__$1)){
var c__5567__auto___7617 = cljs.core.chunk_first.call(null,seq__7565_7616__$1);
var G__7618 = cljs.core.chunk_rest.call(null,seq__7565_7616__$1);
var G__7619 = c__5567__auto___7617;
var G__7620 = cljs.core.count.call(null,c__5567__auto___7617);
var G__7621 = (0);
seq__7565_7606 = G__7618;
chunk__7566_7607 = G__7619;
count__7567_7608 = G__7620;
i__7568_7609 = G__7621;
continue;
} else {
var fld_7622 = cljs.core.first.call(null,seq__7565_7616__$1);
cljs.compiler.emitln.call(null,"this.",fld_7622," = ",fld_7622,";");


var G__7623 = cljs.core.next.call(null,seq__7565_7616__$1);
var G__7624 = null;
var G__7625 = (0);
var G__7626 = (0);
seq__7565_7606 = G__7623;
chunk__7566_7607 = G__7624;
count__7567_7608 = G__7625;
i__7568_7609 = G__7626;
continue;
}
} else {
}
}
break;
}

var seq__7569_7627 = cljs.core.seq.call(null,pmasks);
var chunk__7570_7628 = null;
var count__7571_7629 = (0);
var i__7572_7630 = (0);
while(true){
if((i__7572_7630 < count__7571_7629)){
var vec__7579_7631 = cljs.core._nth.call(null,chunk__7570_7628,i__7572_7630);
var pno_7632 = cljs.core.nth.call(null,vec__7579_7631,(0),null);
var pmask_7633 = cljs.core.nth.call(null,vec__7579_7631,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7632,"$ = ",pmask_7633,";");


var G__7634 = seq__7569_7627;
var G__7635 = chunk__7570_7628;
var G__7636 = count__7571_7629;
var G__7637 = (i__7572_7630 + (1));
seq__7569_7627 = G__7634;
chunk__7570_7628 = G__7635;
count__7571_7629 = G__7636;
i__7572_7630 = G__7637;
continue;
} else {
var temp__5804__auto___7638 = cljs.core.seq.call(null,seq__7569_7627);
if(temp__5804__auto___7638){
var seq__7569_7639__$1 = temp__5804__auto___7638;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7569_7639__$1)){
var c__5567__auto___7640 = cljs.core.chunk_first.call(null,seq__7569_7639__$1);
var G__7641 = cljs.core.chunk_rest.call(null,seq__7569_7639__$1);
var G__7642 = c__5567__auto___7640;
var G__7643 = cljs.core.count.call(null,c__5567__auto___7640);
var G__7644 = (0);
seq__7569_7627 = G__7641;
chunk__7570_7628 = G__7642;
count__7571_7629 = G__7643;
i__7572_7630 = G__7644;
continue;
} else {
var vec__7582_7645 = cljs.core.first.call(null,seq__7569_7639__$1);
var pno_7646 = cljs.core.nth.call(null,vec__7582_7645,(0),null);
var pmask_7647 = cljs.core.nth.call(null,vec__7582_7645,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7646,"$ = ",pmask_7647,";");


var G__7648 = cljs.core.next.call(null,seq__7569_7639__$1);
var G__7649 = null;
var G__7650 = (0);
var G__7651 = (0);
seq__7569_7627 = G__7648;
chunk__7570_7628 = G__7649;
count__7571_7629 = G__7650;
i__7572_7630 = G__7651;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__7652){
var map__7653 = p__7652;
var map__7653__$1 = cljs.core.__destructure_map.call(null,map__7653);
var t = cljs.core.get.call(null,map__7653__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__7653__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__7653__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__7653__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__7653__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.call(null,cljs.core.map.call(null,cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__7654_7678 = cljs.core.seq.call(null,protocols);
var chunk__7655_7679 = null;
var count__7656_7680 = (0);
var i__7657_7681 = (0);
while(true){
if((i__7657_7681 < count__7656_7680)){
var protocol_7682 = cljs.core._nth.call(null,chunk__7655_7679,i__7657_7681);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7682)),"}");


var G__7683 = seq__7654_7678;
var G__7684 = chunk__7655_7679;
var G__7685 = count__7656_7680;
var G__7686 = (i__7657_7681 + (1));
seq__7654_7678 = G__7683;
chunk__7655_7679 = G__7684;
count__7656_7680 = G__7685;
i__7657_7681 = G__7686;
continue;
} else {
var temp__5804__auto___7687 = cljs.core.seq.call(null,seq__7654_7678);
if(temp__5804__auto___7687){
var seq__7654_7688__$1 = temp__5804__auto___7687;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7654_7688__$1)){
var c__5567__auto___7689 = cljs.core.chunk_first.call(null,seq__7654_7688__$1);
var G__7690 = cljs.core.chunk_rest.call(null,seq__7654_7688__$1);
var G__7691 = c__5567__auto___7689;
var G__7692 = cljs.core.count.call(null,c__5567__auto___7689);
var G__7693 = (0);
seq__7654_7678 = G__7690;
chunk__7655_7679 = G__7691;
count__7656_7680 = G__7692;
i__7657_7681 = G__7693;
continue;
} else {
var protocol_7694 = cljs.core.first.call(null,seq__7654_7688__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7694)),"}");


var G__7695 = cljs.core.next.call(null,seq__7654_7688__$1);
var G__7696 = null;
var G__7697 = (0);
var G__7698 = (0);
seq__7654_7678 = G__7695;
chunk__7655_7679 = G__7696;
count__7656_7680 = G__7697;
i__7657_7681 = G__7698;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__7658_7699 = cljs.core.seq.call(null,fields__$1);
var chunk__7659_7700 = null;
var count__7660_7701 = (0);
var i__7661_7702 = (0);
while(true){
if((i__7661_7702 < count__7660_7701)){
var fld_7703 = cljs.core._nth.call(null,chunk__7659_7700,i__7661_7702);
cljs.compiler.emitln.call(null,"this.",fld_7703," = ",fld_7703,";");


var G__7704 = seq__7658_7699;
var G__7705 = chunk__7659_7700;
var G__7706 = count__7660_7701;
var G__7707 = (i__7661_7702 + (1));
seq__7658_7699 = G__7704;
chunk__7659_7700 = G__7705;
count__7660_7701 = G__7706;
i__7661_7702 = G__7707;
continue;
} else {
var temp__5804__auto___7708 = cljs.core.seq.call(null,seq__7658_7699);
if(temp__5804__auto___7708){
var seq__7658_7709__$1 = temp__5804__auto___7708;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7658_7709__$1)){
var c__5567__auto___7710 = cljs.core.chunk_first.call(null,seq__7658_7709__$1);
var G__7711 = cljs.core.chunk_rest.call(null,seq__7658_7709__$1);
var G__7712 = c__5567__auto___7710;
var G__7713 = cljs.core.count.call(null,c__5567__auto___7710);
var G__7714 = (0);
seq__7658_7699 = G__7711;
chunk__7659_7700 = G__7712;
count__7660_7701 = G__7713;
i__7661_7702 = G__7714;
continue;
} else {
var fld_7715 = cljs.core.first.call(null,seq__7658_7709__$1);
cljs.compiler.emitln.call(null,"this.",fld_7715," = ",fld_7715,";");


var G__7716 = cljs.core.next.call(null,seq__7658_7709__$1);
var G__7717 = null;
var G__7718 = (0);
var G__7719 = (0);
seq__7658_7699 = G__7716;
chunk__7659_7700 = G__7717;
count__7660_7701 = G__7718;
i__7661_7702 = G__7719;
continue;
}
} else {
}
}
break;
}

var seq__7662_7720 = cljs.core.seq.call(null,pmasks);
var chunk__7663_7721 = null;
var count__7664_7722 = (0);
var i__7665_7723 = (0);
while(true){
if((i__7665_7723 < count__7664_7722)){
var vec__7672_7724 = cljs.core._nth.call(null,chunk__7663_7721,i__7665_7723);
var pno_7725 = cljs.core.nth.call(null,vec__7672_7724,(0),null);
var pmask_7726 = cljs.core.nth.call(null,vec__7672_7724,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7725,"$ = ",pmask_7726,";");


var G__7727 = seq__7662_7720;
var G__7728 = chunk__7663_7721;
var G__7729 = count__7664_7722;
var G__7730 = (i__7665_7723 + (1));
seq__7662_7720 = G__7727;
chunk__7663_7721 = G__7728;
count__7664_7722 = G__7729;
i__7665_7723 = G__7730;
continue;
} else {
var temp__5804__auto___7731 = cljs.core.seq.call(null,seq__7662_7720);
if(temp__5804__auto___7731){
var seq__7662_7732__$1 = temp__5804__auto___7731;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7662_7732__$1)){
var c__5567__auto___7733 = cljs.core.chunk_first.call(null,seq__7662_7732__$1);
var G__7734 = cljs.core.chunk_rest.call(null,seq__7662_7732__$1);
var G__7735 = c__5567__auto___7733;
var G__7736 = cljs.core.count.call(null,c__5567__auto___7733);
var G__7737 = (0);
seq__7662_7720 = G__7734;
chunk__7663_7721 = G__7735;
count__7664_7722 = G__7736;
i__7665_7723 = G__7737;
continue;
} else {
var vec__7675_7738 = cljs.core.first.call(null,seq__7662_7732__$1);
var pno_7739 = cljs.core.nth.call(null,vec__7675_7738,(0),null);
var pmask_7740 = cljs.core.nth.call(null,vec__7675_7738,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7739,"$ = ",pmask_7740,";");


var G__7741 = cljs.core.next.call(null,seq__7662_7732__$1);
var G__7742 = null;
var G__7743 = (0);
var G__7744 = (0);
seq__7662_7720 = G__7741;
chunk__7663_7721 = G__7742;
count__7664_7722 = G__7743;
i__7665_7723 = G__7744;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__7745){
var map__7746 = p__7745;
var map__7746__$1 = cljs.core.__destructure_map.call(null,map__7746);
var target = cljs.core.get.call(null,map__7746__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.call(null,map__7746__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.call(null,map__7746__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.call(null,map__7746__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7746__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9255__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep.call(null,args),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__7747){
var map__7748 = p__7747;
var map__7748__$1 = cljs.core.__destructure_map.call(null,map__7748);
var op = cljs.core.get.call(null,map__7748__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.call(null,map__7748__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.call(null,map__7748__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.call(null,map__7748__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.call(null,map__7748__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__5043__auto__ = code;
if(cljs.core.truth_(and__5043__auto__)){
return goog.string.startsWith(clojure.string.trim.call(null,code),"/*");
} else {
return and__5043__auto__;
}
})())){
return cljs.compiler.emits.call(null,code);
} else {
var env__9255__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.call(null,code);
} else {
cljs.compiler.emits.call(null,cljs.core.interleave.call(null,cljs.core.concat.call(null,segs,cljs.core.repeat.call(null,null)),cljs.core.concat.call(null,args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

var seq__7753 = cljs.core.seq.call(null,table);
var chunk__7754 = null;
var count__7755 = (0);
var i__7756 = (0);
while(true){
if((i__7756 < count__7755)){
var vec__7763 = cljs.core._nth.call(null,chunk__7754,i__7756);
var sym = cljs.core.nth.call(null,vec__7763,(0),null);
var value = cljs.core.nth.call(null,vec__7763,(1),null);
var ns_7769 = cljs.core.namespace.call(null,sym);
var name_7770 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__7771 = seq__7753;
var G__7772 = chunk__7754;
var G__7773 = count__7755;
var G__7774 = (i__7756 + (1));
seq__7753 = G__7771;
chunk__7754 = G__7772;
count__7755 = G__7773;
i__7756 = G__7774;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__7753);
if(temp__5804__auto__){
var seq__7753__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7753__$1)){
var c__5567__auto__ = cljs.core.chunk_first.call(null,seq__7753__$1);
var G__7775 = cljs.core.chunk_rest.call(null,seq__7753__$1);
var G__7776 = c__5567__auto__;
var G__7777 = cljs.core.count.call(null,c__5567__auto__);
var G__7778 = (0);
seq__7753 = G__7775;
chunk__7754 = G__7776;
count__7755 = G__7777;
i__7756 = G__7778;
continue;
} else {
var vec__7766 = cljs.core.first.call(null,seq__7753__$1);
var sym = cljs.core.nth.call(null,vec__7766,(0),null);
var value = cljs.core.nth.call(null,vec__7766,(1),null);
var ns_7779 = cljs.core.namespace.call(null,sym);
var name_7780 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__7781 = cljs.core.next.call(null,seq__7753__$1);
var G__7782 = null;
var G__7783 = (0);
var G__7784 = (0);
seq__7753 = G__7781;
chunk__7754 = G__7782;
count__7755 = G__7783;
i__7756 = G__7784;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__7786 = arguments.length;
switch (G__7786) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.call(null,cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs.call(null):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq.call(null,cljs.core.keys.call(null,externs));
while(true){
if(ks){
var k_7791 = cljs.core.first.call(null,ks);
var vec__7787_7792 = cljs.core.conj.call(null,prefix,k_7791);
var top_7793 = cljs.core.nth.call(null,vec__7787_7792,(0),null);
var prefix_SINGLEQUOTE__7794 = vec__7787_7792;
if(((cljs.core.not_EQ_.call(null,new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_7791)) && ((cljs.core.get_in.call(null,known_externs,prefix_SINGLEQUOTE__7794) == null)))){
if((!(((cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,top_level),top_7793)) || (cljs.core.contains_QMARK_.call(null,known_externs,top_7793)))))){
cljs.compiler.emitln.call(null,"var ",clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__7794)),";");

cljs.core.swap_BANG_.call(null,top_level,cljs.core.conj,top_7793);
} else {
cljs.compiler.emitln.call(null,clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__7794)),";");
}
} else {
}

var m_7795 = cljs.core.get.call(null,externs,k_7791);
if(cljs.core.empty_QMARK_.call(null,m_7795)){
} else {
cljs.compiler.emit_externs.call(null,prefix_SINGLEQUOTE__7794,m_7795,top_level,known_externs);
}

var G__7796 = cljs.core.next.call(null,ks);
ks = G__7796;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

