// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
goog.scope(function(){
cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__11078 = arguments.length;
switch (G__11078) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11079 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11079 = (function (f,blockable,meta11080){
this.f = f;
this.blockable = blockable;
this.meta11080 = meta11080;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11079.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11081,meta11080__$1){
var self__ = this;
var _11081__$1 = this;
return (new cljs.core.async.t_cljs$core$async11079(self__.f,self__.blockable,meta11080__$1));
}));

(cljs.core.async.t_cljs$core$async11079.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11081){
var self__ = this;
var _11081__$1 = this;
return self__.meta11080;
}));

(cljs.core.async.t_cljs$core$async11079.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11079.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11079.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async11079.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async11079.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11080","meta11080",1579882360,null)], null);
}));

(cljs.core.async.t_cljs$core$async11079.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11079.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11079");

(cljs.core.async.t_cljs$core$async11079.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write.call(null,writer__5330__auto__,"cljs.core.async/t_cljs$core$async11079");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11079.
 */
cljs.core.async.__GT_t_cljs$core$async11079 = (function cljs$core$async$__GT_t_cljs$core$async11079(f__$1,blockable__$1,meta11080){
return (new cljs.core.async.t_cljs$core$async11079(f__$1,blockable__$1,meta11080));
});

}

return (new cljs.core.async.t_cljs$core$async11079(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__11085 = arguments.length;
switch (G__11085) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__11088 = arguments.length;
switch (G__11088) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__11091 = arguments.length;
switch (G__11091) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11093 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11093);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_11093);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__11095 = arguments.length;
switch (G__11095) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5635__auto___11097 = n;
var x_11098 = (0);
while(true){
if((x_11098 < n__5635__auto___11097)){
(a[x_11098] = x_11098);

var G__11099 = (x_11098 + (1));
x_11098 = G__11099;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle.call(null,a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11100 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11100 = (function (flag,meta11101){
this.flag = flag;
this.meta11101 = meta11101;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11100.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11102,meta11101__$1){
var self__ = this;
var _11102__$1 = this;
return (new cljs.core.async.t_cljs$core$async11100(self__.flag,meta11101__$1));
}));

(cljs.core.async.t_cljs$core$async11100.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11102){
var self__ = this;
var _11102__$1 = this;
return self__.meta11101;
}));

(cljs.core.async.t_cljs$core$async11100.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11100.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async11100.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11100.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async11100.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11101","meta11101",-1678516526,null)], null);
}));

(cljs.core.async.t_cljs$core$async11100.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11100.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11100");

(cljs.core.async.t_cljs$core$async11100.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write.call(null,writer__5330__auto__,"cljs.core.async/t_cljs$core$async11100");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11100.
 */
cljs.core.async.__GT_t_cljs$core$async11100 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11100(flag__$1,meta11101){
return (new cljs.core.async.t_cljs$core$async11100(flag__$1,meta11101));
});

}

return (new cljs.core.async.t_cljs$core$async11100(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11103 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11103 = (function (flag,cb,meta11104){
this.flag = flag;
this.cb = cb;
this.meta11104 = meta11104;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11103.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11105,meta11104__$1){
var self__ = this;
var _11105__$1 = this;
return (new cljs.core.async.t_cljs$core$async11103(self__.flag,self__.cb,meta11104__$1));
}));

(cljs.core.async.t_cljs$core$async11103.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11105){
var self__ = this;
var _11105__$1 = this;
return self__.meta11104;
}));

(cljs.core.async.t_cljs$core$async11103.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11103.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async11103.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11103.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async11103.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11104","meta11104",1445057581,null)], null);
}));

(cljs.core.async.t_cljs$core$async11103.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11103.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11103");

(cljs.core.async.t_cljs$core$async11103.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write.call(null,writer__5330__auto__,"cljs.core.async/t_cljs$core$async11103");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11103.
 */
cljs.core.async.__GT_t_cljs$core$async11103 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11103(flag__$1,cb__$1,meta11104){
return (new cljs.core.async.t_cljs$core$async11103(flag__$1,cb__$1,meta11104));
});

}

return (new cljs.core.async.t_cljs$core$async11103(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11106_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11106_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11107_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11107_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11108 = (i + (1));
i = G__11108;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5043__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___11113 = arguments.length;
var i__5769__auto___11114 = (0);
while(true){
if((i__5769__auto___11114 < len__5768__auto___11113)){
args__5774__auto__.push((arguments[i__5769__auto___11114]));

var G__11115 = (i__5769__auto___11114 + (1));
i__5769__auto___11114 = G__11115;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11111){
var map__11112 = p__11111;
var map__11112__$1 = cljs.core.__destructure_map.call(null,map__11112);
var opts = map__11112__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11109){
var G__11110 = cljs.core.first.call(null,seq11109);
var seq11109__$1 = cljs.core.next.call(null,seq11109);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11110,seq11109__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__11117 = arguments.length;
switch (G__11117) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11018__auto___11164 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_11141){
var state_val_11142 = (state_11141[(1)]);
if((state_val_11142 === (7))){
var inst_11137 = (state_11141[(2)]);
var state_11141__$1 = state_11141;
var statearr_11143_11165 = state_11141__$1;
(statearr_11143_11165[(2)] = inst_11137);

(statearr_11143_11165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11142 === (1))){
var state_11141__$1 = state_11141;
var statearr_11144_11166 = state_11141__$1;
(statearr_11144_11166[(2)] = null);

(statearr_11144_11166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11142 === (4))){
var inst_11120 = (state_11141[(7)]);
var inst_11120__$1 = (state_11141[(2)]);
var inst_11121 = (inst_11120__$1 == null);
var state_11141__$1 = (function (){var statearr_11145 = state_11141;
(statearr_11145[(7)] = inst_11120__$1);

return statearr_11145;
})();
if(cljs.core.truth_(inst_11121)){
var statearr_11146_11167 = state_11141__$1;
(statearr_11146_11167[(1)] = (5));

} else {
var statearr_11147_11168 = state_11141__$1;
(statearr_11147_11168[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11142 === (13))){
var state_11141__$1 = state_11141;
var statearr_11148_11169 = state_11141__$1;
(statearr_11148_11169[(2)] = null);

(statearr_11148_11169[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11142 === (6))){
var inst_11120 = (state_11141[(7)]);
var state_11141__$1 = state_11141;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11141__$1,(11),to,inst_11120);
} else {
if((state_val_11142 === (3))){
var inst_11139 = (state_11141[(2)]);
var state_11141__$1 = state_11141;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11141__$1,inst_11139);
} else {
if((state_val_11142 === (12))){
var state_11141__$1 = state_11141;
var statearr_11149_11170 = state_11141__$1;
(statearr_11149_11170[(2)] = null);

(statearr_11149_11170[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11142 === (2))){
var state_11141__$1 = state_11141;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11141__$1,(4),from);
} else {
if((state_val_11142 === (11))){
var inst_11130 = (state_11141[(2)]);
var state_11141__$1 = state_11141;
if(cljs.core.truth_(inst_11130)){
var statearr_11150_11171 = state_11141__$1;
(statearr_11150_11171[(1)] = (12));

} else {
var statearr_11151_11172 = state_11141__$1;
(statearr_11151_11172[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11142 === (9))){
var state_11141__$1 = state_11141;
var statearr_11152_11173 = state_11141__$1;
(statearr_11152_11173[(2)] = null);

(statearr_11152_11173[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11142 === (5))){
var state_11141__$1 = state_11141;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11153_11174 = state_11141__$1;
(statearr_11153_11174[(1)] = (8));

} else {
var statearr_11154_11175 = state_11141__$1;
(statearr_11154_11175[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11142 === (14))){
var inst_11135 = (state_11141[(2)]);
var state_11141__$1 = state_11141;
var statearr_11155_11176 = state_11141__$1;
(statearr_11155_11176[(2)] = inst_11135);

(statearr_11155_11176[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11142 === (10))){
var inst_11127 = (state_11141[(2)]);
var state_11141__$1 = state_11141;
var statearr_11156_11177 = state_11141__$1;
(statearr_11156_11177[(2)] = inst_11127);

(statearr_11156_11177[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11142 === (8))){
var inst_11124 = cljs.core.async.close_BANG_.call(null,to);
var state_11141__$1 = state_11141;
var statearr_11157_11178 = state_11141__$1;
(statearr_11157_11178[(2)] = inst_11124);

(statearr_11157_11178[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10945__auto__ = null;
var cljs$core$async$state_machine__10945__auto____0 = (function (){
var statearr_11158 = [null,null,null,null,null,null,null,null];
(statearr_11158[(0)] = cljs$core$async$state_machine__10945__auto__);

(statearr_11158[(1)] = (1));

return statearr_11158;
});
var cljs$core$async$state_machine__10945__auto____1 = (function (state_11141){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_11141);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e11159){var ex__10948__auto__ = e11159;
var statearr_11160_11179 = state_11141;
(statearr_11160_11179[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_11141[(4)]))){
var statearr_11161_11180 = state_11141;
(statearr_11161_11180[(1)] = cljs.core.first.call(null,(state_11141[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11181 = state_11141;
state_11141 = G__11181;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$state_machine__10945__auto__ = function(state_11141){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10945__auto____1.call(this,state_11141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10945__auto____0;
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10945__auto____1;
return cljs$core$async$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_11162 = f__11019__auto__.call(null);
(statearr_11162[(6)] = c__11018__auto___11164);

return statearr_11162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process__$1 = (function (p__11182){
var vec__11183 = p__11182;
var v = cljs.core.nth.call(null,vec__11183,(0),null);
var p = cljs.core.nth.call(null,vec__11183,(1),null);
var job = vec__11183;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11018__auto___11359 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_11190){
var state_val_11191 = (state_11190[(1)]);
if((state_val_11191 === (1))){
var state_11190__$1 = state_11190;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11190__$1,(2),res,v);
} else {
if((state_val_11191 === (2))){
var inst_11187 = (state_11190[(2)]);
var inst_11188 = cljs.core.async.close_BANG_.call(null,res);
var state_11190__$1 = (function (){var statearr_11192 = state_11190;
(statearr_11192[(7)] = inst_11187);

return statearr_11192;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11190__$1,inst_11188);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____0 = (function (){
var statearr_11193 = [null,null,null,null,null,null,null,null];
(statearr_11193[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__);

(statearr_11193[(1)] = (1));

return statearr_11193;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____1 = (function (state_11190){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_11190);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e11194){var ex__10948__auto__ = e11194;
var statearr_11195_11360 = state_11190;
(statearr_11195_11360[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_11190[(4)]))){
var statearr_11196_11361 = state_11190;
(statearr_11196_11361[(1)] = cljs.core.first.call(null,(state_11190[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11362 = state_11190;
state_11190 = G__11362;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__ = function(state_11190){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____1.call(this,state_11190);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_11197 = f__11019__auto__.call(null);
(statearr_11197[(6)] = c__11018__auto___11359);

return statearr_11197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__11198){
var vec__11199 = p__11198;
var v = cljs.core.nth.call(null,vec__11199,(0),null);
var p = cljs.core.nth.call(null,vec__11199,(1),null);
var job = vec__11199;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__5635__auto___11363 = n;
var __11364 = (0);
while(true){
if((__11364 < n__5635__auto___11363)){
var G__11202_11365 = type;
var G__11202_11366__$1 = (((G__11202_11365 instanceof cljs.core.Keyword))?G__11202_11365.fqn:null);
switch (G__11202_11366__$1) {
case "compute":
var c__11018__auto___11368 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11364,c__11018__auto___11368,G__11202_11365,G__11202_11366__$1,n__5635__auto___11363,jobs,results,process__$1,async){
return (function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = ((function (__11364,c__11018__auto___11368,G__11202_11365,G__11202_11366__$1,n__5635__auto___11363,jobs,results,process__$1,async){
return (function (state_11215){
var state_val_11216 = (state_11215[(1)]);
if((state_val_11216 === (1))){
var state_11215__$1 = state_11215;
var statearr_11217_11369 = state_11215__$1;
(statearr_11217_11369[(2)] = null);

(statearr_11217_11369[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11216 === (2))){
var state_11215__$1 = state_11215;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11215__$1,(4),jobs);
} else {
if((state_val_11216 === (3))){
var inst_11213 = (state_11215[(2)]);
var state_11215__$1 = state_11215;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11215__$1,inst_11213);
} else {
if((state_val_11216 === (4))){
var inst_11205 = (state_11215[(2)]);
var inst_11206 = process__$1.call(null,inst_11205);
var state_11215__$1 = state_11215;
if(cljs.core.truth_(inst_11206)){
var statearr_11218_11370 = state_11215__$1;
(statearr_11218_11370[(1)] = (5));

} else {
var statearr_11219_11371 = state_11215__$1;
(statearr_11219_11371[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11216 === (5))){
var state_11215__$1 = state_11215;
var statearr_11220_11372 = state_11215__$1;
(statearr_11220_11372[(2)] = null);

(statearr_11220_11372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11216 === (6))){
var state_11215__$1 = state_11215;
var statearr_11221_11373 = state_11215__$1;
(statearr_11221_11373[(2)] = null);

(statearr_11221_11373[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11216 === (7))){
var inst_11211 = (state_11215[(2)]);
var state_11215__$1 = state_11215;
var statearr_11222_11374 = state_11215__$1;
(statearr_11222_11374[(2)] = inst_11211);

(statearr_11222_11374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11364,c__11018__auto___11368,G__11202_11365,G__11202_11366__$1,n__5635__auto___11363,jobs,results,process__$1,async))
;
return ((function (__11364,switch__10944__auto__,c__11018__auto___11368,G__11202_11365,G__11202_11366__$1,n__5635__auto___11363,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____0 = (function (){
var statearr_11223 = [null,null,null,null,null,null,null];
(statearr_11223[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__);

(statearr_11223[(1)] = (1));

return statearr_11223;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____1 = (function (state_11215){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_11215);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e11224){var ex__10948__auto__ = e11224;
var statearr_11225_11375 = state_11215;
(statearr_11225_11375[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_11215[(4)]))){
var statearr_11226_11376 = state_11215;
(statearr_11226_11376[(1)] = cljs.core.first.call(null,(state_11215[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11377 = state_11215;
state_11215 = G__11377;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__ = function(state_11215){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____1.call(this,state_11215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__;
})()
;})(__11364,switch__10944__auto__,c__11018__auto___11368,G__11202_11365,G__11202_11366__$1,n__5635__auto___11363,jobs,results,process__$1,async))
})();
var state__11020__auto__ = (function (){var statearr_11227 = f__11019__auto__.call(null);
(statearr_11227[(6)] = c__11018__auto___11368);

return statearr_11227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
});})(__11364,c__11018__auto___11368,G__11202_11365,G__11202_11366__$1,n__5635__auto___11363,jobs,results,process__$1,async))
);


break;
case "async":
var c__11018__auto___11378 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11364,c__11018__auto___11378,G__11202_11365,G__11202_11366__$1,n__5635__auto___11363,jobs,results,process__$1,async){
return (function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = ((function (__11364,c__11018__auto___11378,G__11202_11365,G__11202_11366__$1,n__5635__auto___11363,jobs,results,process__$1,async){
return (function (state_11240){
var state_val_11241 = (state_11240[(1)]);
if((state_val_11241 === (1))){
var state_11240__$1 = state_11240;
var statearr_11242_11379 = state_11240__$1;
(statearr_11242_11379[(2)] = null);

(statearr_11242_11379[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (2))){
var state_11240__$1 = state_11240;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11240__$1,(4),jobs);
} else {
if((state_val_11241 === (3))){
var inst_11238 = (state_11240[(2)]);
var state_11240__$1 = state_11240;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11240__$1,inst_11238);
} else {
if((state_val_11241 === (4))){
var inst_11230 = (state_11240[(2)]);
var inst_11231 = async.call(null,inst_11230);
var state_11240__$1 = state_11240;
if(cljs.core.truth_(inst_11231)){
var statearr_11243_11380 = state_11240__$1;
(statearr_11243_11380[(1)] = (5));

} else {
var statearr_11244_11381 = state_11240__$1;
(statearr_11244_11381[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (5))){
var state_11240__$1 = state_11240;
var statearr_11245_11382 = state_11240__$1;
(statearr_11245_11382[(2)] = null);

(statearr_11245_11382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (6))){
var state_11240__$1 = state_11240;
var statearr_11246_11383 = state_11240__$1;
(statearr_11246_11383[(2)] = null);

(statearr_11246_11383[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (7))){
var inst_11236 = (state_11240[(2)]);
var state_11240__$1 = state_11240;
var statearr_11247_11384 = state_11240__$1;
(statearr_11247_11384[(2)] = inst_11236);

(statearr_11247_11384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11364,c__11018__auto___11378,G__11202_11365,G__11202_11366__$1,n__5635__auto___11363,jobs,results,process__$1,async))
;
return ((function (__11364,switch__10944__auto__,c__11018__auto___11378,G__11202_11365,G__11202_11366__$1,n__5635__auto___11363,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____0 = (function (){
var statearr_11248 = [null,null,null,null,null,null,null];
(statearr_11248[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__);

(statearr_11248[(1)] = (1));

return statearr_11248;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____1 = (function (state_11240){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_11240);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e11249){var ex__10948__auto__ = e11249;
var statearr_11250_11385 = state_11240;
(statearr_11250_11385[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_11240[(4)]))){
var statearr_11251_11386 = state_11240;
(statearr_11251_11386[(1)] = cljs.core.first.call(null,(state_11240[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11387 = state_11240;
state_11240 = G__11387;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__ = function(state_11240){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____1.call(this,state_11240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__;
})()
;})(__11364,switch__10944__auto__,c__11018__auto___11378,G__11202_11365,G__11202_11366__$1,n__5635__auto___11363,jobs,results,process__$1,async))
})();
var state__11020__auto__ = (function (){var statearr_11252 = f__11019__auto__.call(null);
(statearr_11252[(6)] = c__11018__auto___11378);

return statearr_11252;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
});})(__11364,c__11018__auto___11378,G__11202_11365,G__11202_11366__$1,n__5635__auto___11363,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__11202_11366__$1)].join('')));

}

var G__11388 = (__11364 + (1));
__11364 = G__11388;
continue;
} else {
}
break;
}

var c__11018__auto___11389 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_11274){
var state_val_11275 = (state_11274[(1)]);
if((state_val_11275 === (7))){
var inst_11270 = (state_11274[(2)]);
var state_11274__$1 = state_11274;
var statearr_11276_11390 = state_11274__$1;
(statearr_11276_11390[(2)] = inst_11270);

(statearr_11276_11390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11275 === (1))){
var state_11274__$1 = state_11274;
var statearr_11277_11391 = state_11274__$1;
(statearr_11277_11391[(2)] = null);

(statearr_11277_11391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11275 === (4))){
var inst_11255 = (state_11274[(7)]);
var inst_11255__$1 = (state_11274[(2)]);
var inst_11256 = (inst_11255__$1 == null);
var state_11274__$1 = (function (){var statearr_11278 = state_11274;
(statearr_11278[(7)] = inst_11255__$1);

return statearr_11278;
})();
if(cljs.core.truth_(inst_11256)){
var statearr_11279_11392 = state_11274__$1;
(statearr_11279_11392[(1)] = (5));

} else {
var statearr_11280_11393 = state_11274__$1;
(statearr_11280_11393[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11275 === (6))){
var inst_11255 = (state_11274[(7)]);
var inst_11260 = (state_11274[(8)]);
var inst_11260__$1 = cljs.core.async.chan.call(null,(1));
var inst_11261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11262 = [inst_11255,inst_11260__$1];
var inst_11263 = (new cljs.core.PersistentVector(null,2,(5),inst_11261,inst_11262,null));
var state_11274__$1 = (function (){var statearr_11281 = state_11274;
(statearr_11281[(8)] = inst_11260__$1);

return statearr_11281;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11274__$1,(8),jobs,inst_11263);
} else {
if((state_val_11275 === (3))){
var inst_11272 = (state_11274[(2)]);
var state_11274__$1 = state_11274;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11274__$1,inst_11272);
} else {
if((state_val_11275 === (2))){
var state_11274__$1 = state_11274;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11274__$1,(4),from);
} else {
if((state_val_11275 === (9))){
var inst_11267 = (state_11274[(2)]);
var state_11274__$1 = (function (){var statearr_11282 = state_11274;
(statearr_11282[(9)] = inst_11267);

return statearr_11282;
})();
var statearr_11283_11394 = state_11274__$1;
(statearr_11283_11394[(2)] = null);

(statearr_11283_11394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11275 === (5))){
var inst_11258 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11274__$1 = state_11274;
var statearr_11284_11395 = state_11274__$1;
(statearr_11284_11395[(2)] = inst_11258);

(statearr_11284_11395[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11275 === (8))){
var inst_11260 = (state_11274[(8)]);
var inst_11265 = (state_11274[(2)]);
var state_11274__$1 = (function (){var statearr_11285 = state_11274;
(statearr_11285[(10)] = inst_11265);

return statearr_11285;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11274__$1,(9),results,inst_11260);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____0 = (function (){
var statearr_11286 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11286[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__);

(statearr_11286[(1)] = (1));

return statearr_11286;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____1 = (function (state_11274){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_11274);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e11287){var ex__10948__auto__ = e11287;
var statearr_11288_11396 = state_11274;
(statearr_11288_11396[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_11274[(4)]))){
var statearr_11289_11397 = state_11274;
(statearr_11289_11397[(1)] = cljs.core.first.call(null,(state_11274[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11398 = state_11274;
state_11274 = G__11398;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__ = function(state_11274){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____1.call(this,state_11274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_11290 = f__11019__auto__.call(null);
(statearr_11290[(6)] = c__11018__auto___11389);

return statearr_11290;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_11328){
var state_val_11329 = (state_11328[(1)]);
if((state_val_11329 === (7))){
var inst_11324 = (state_11328[(2)]);
var state_11328__$1 = state_11328;
var statearr_11330_11399 = state_11328__$1;
(statearr_11330_11399[(2)] = inst_11324);

(statearr_11330_11399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11329 === (20))){
var state_11328__$1 = state_11328;
var statearr_11331_11400 = state_11328__$1;
(statearr_11331_11400[(2)] = null);

(statearr_11331_11400[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11329 === (1))){
var state_11328__$1 = state_11328;
var statearr_11332_11401 = state_11328__$1;
(statearr_11332_11401[(2)] = null);

(statearr_11332_11401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11329 === (4))){
var inst_11293 = (state_11328[(7)]);
var inst_11293__$1 = (state_11328[(2)]);
var inst_11294 = (inst_11293__$1 == null);
var state_11328__$1 = (function (){var statearr_11333 = state_11328;
(statearr_11333[(7)] = inst_11293__$1);

return statearr_11333;
})();
if(cljs.core.truth_(inst_11294)){
var statearr_11334_11402 = state_11328__$1;
(statearr_11334_11402[(1)] = (5));

} else {
var statearr_11335_11403 = state_11328__$1;
(statearr_11335_11403[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11329 === (15))){
var inst_11306 = (state_11328[(8)]);
var state_11328__$1 = state_11328;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11328__$1,(18),to,inst_11306);
} else {
if((state_val_11329 === (21))){
var inst_11319 = (state_11328[(2)]);
var state_11328__$1 = state_11328;
var statearr_11336_11404 = state_11328__$1;
(statearr_11336_11404[(2)] = inst_11319);

(statearr_11336_11404[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11329 === (13))){
var inst_11321 = (state_11328[(2)]);
var state_11328__$1 = (function (){var statearr_11337 = state_11328;
(statearr_11337[(9)] = inst_11321);

return statearr_11337;
})();
var statearr_11338_11405 = state_11328__$1;
(statearr_11338_11405[(2)] = null);

(statearr_11338_11405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11329 === (6))){
var inst_11293 = (state_11328[(7)]);
var state_11328__$1 = state_11328;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11328__$1,(11),inst_11293);
} else {
if((state_val_11329 === (17))){
var inst_11314 = (state_11328[(2)]);
var state_11328__$1 = state_11328;
if(cljs.core.truth_(inst_11314)){
var statearr_11339_11406 = state_11328__$1;
(statearr_11339_11406[(1)] = (19));

} else {
var statearr_11340_11407 = state_11328__$1;
(statearr_11340_11407[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11329 === (3))){
var inst_11326 = (state_11328[(2)]);
var state_11328__$1 = state_11328;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11328__$1,inst_11326);
} else {
if((state_val_11329 === (12))){
var inst_11303 = (state_11328[(10)]);
var state_11328__$1 = state_11328;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11328__$1,(14),inst_11303);
} else {
if((state_val_11329 === (2))){
var state_11328__$1 = state_11328;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11328__$1,(4),results);
} else {
if((state_val_11329 === (19))){
var state_11328__$1 = state_11328;
var statearr_11341_11408 = state_11328__$1;
(statearr_11341_11408[(2)] = null);

(statearr_11341_11408[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11329 === (11))){
var inst_11303 = (state_11328[(2)]);
var state_11328__$1 = (function (){var statearr_11342 = state_11328;
(statearr_11342[(10)] = inst_11303);

return statearr_11342;
})();
var statearr_11343_11409 = state_11328__$1;
(statearr_11343_11409[(2)] = null);

(statearr_11343_11409[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11329 === (9))){
var state_11328__$1 = state_11328;
var statearr_11344_11410 = state_11328__$1;
(statearr_11344_11410[(2)] = null);

(statearr_11344_11410[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11329 === (5))){
var state_11328__$1 = state_11328;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11345_11411 = state_11328__$1;
(statearr_11345_11411[(1)] = (8));

} else {
var statearr_11346_11412 = state_11328__$1;
(statearr_11346_11412[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11329 === (14))){
var inst_11306 = (state_11328[(8)]);
var inst_11308 = (state_11328[(11)]);
var inst_11306__$1 = (state_11328[(2)]);
var inst_11307 = (inst_11306__$1 == null);
var inst_11308__$1 = cljs.core.not.call(null,inst_11307);
var state_11328__$1 = (function (){var statearr_11347 = state_11328;
(statearr_11347[(8)] = inst_11306__$1);

(statearr_11347[(11)] = inst_11308__$1);

return statearr_11347;
})();
if(inst_11308__$1){
var statearr_11348_11413 = state_11328__$1;
(statearr_11348_11413[(1)] = (15));

} else {
var statearr_11349_11414 = state_11328__$1;
(statearr_11349_11414[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11329 === (16))){
var inst_11308 = (state_11328[(11)]);
var state_11328__$1 = state_11328;
var statearr_11350_11415 = state_11328__$1;
(statearr_11350_11415[(2)] = inst_11308);

(statearr_11350_11415[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11329 === (10))){
var inst_11300 = (state_11328[(2)]);
var state_11328__$1 = state_11328;
var statearr_11351_11416 = state_11328__$1;
(statearr_11351_11416[(2)] = inst_11300);

(statearr_11351_11416[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11329 === (18))){
var inst_11311 = (state_11328[(2)]);
var state_11328__$1 = state_11328;
var statearr_11352_11417 = state_11328__$1;
(statearr_11352_11417[(2)] = inst_11311);

(statearr_11352_11417[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11329 === (8))){
var inst_11297 = cljs.core.async.close_BANG_.call(null,to);
var state_11328__$1 = state_11328;
var statearr_11353_11418 = state_11328__$1;
(statearr_11353_11418[(2)] = inst_11297);

(statearr_11353_11418[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____0 = (function (){
var statearr_11354 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11354[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__);

(statearr_11354[(1)] = (1));

return statearr_11354;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____1 = (function (state_11328){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_11328);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e11355){var ex__10948__auto__ = e11355;
var statearr_11356_11419 = state_11328;
(statearr_11356_11419[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_11328[(4)]))){
var statearr_11357_11420 = state_11328;
(statearr_11357_11420[(1)] = cljs.core.first.call(null,(state_11328[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11421 = state_11328;
state_11328 = G__11421;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__ = function(state_11328){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____1.call(this,state_11328);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10945__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_11358 = f__11019__auto__.call(null);
(statearr_11358[(6)] = c__11018__auto__);

return statearr_11358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__11423 = arguments.length;
switch (G__11423) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__11426 = arguments.length;
switch (G__11426) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__11429 = arguments.length;
switch (G__11429) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11018__auto___11479 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_11455){
var state_val_11456 = (state_11455[(1)]);
if((state_val_11456 === (7))){
var inst_11451 = (state_11455[(2)]);
var state_11455__$1 = state_11455;
var statearr_11457_11480 = state_11455__$1;
(statearr_11457_11480[(2)] = inst_11451);

(statearr_11457_11480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11456 === (1))){
var state_11455__$1 = state_11455;
var statearr_11458_11481 = state_11455__$1;
(statearr_11458_11481[(2)] = null);

(statearr_11458_11481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11456 === (4))){
var inst_11432 = (state_11455[(7)]);
var inst_11432__$1 = (state_11455[(2)]);
var inst_11433 = (inst_11432__$1 == null);
var state_11455__$1 = (function (){var statearr_11459 = state_11455;
(statearr_11459[(7)] = inst_11432__$1);

return statearr_11459;
})();
if(cljs.core.truth_(inst_11433)){
var statearr_11460_11482 = state_11455__$1;
(statearr_11460_11482[(1)] = (5));

} else {
var statearr_11461_11483 = state_11455__$1;
(statearr_11461_11483[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11456 === (13))){
var state_11455__$1 = state_11455;
var statearr_11462_11484 = state_11455__$1;
(statearr_11462_11484[(2)] = null);

(statearr_11462_11484[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11456 === (6))){
var inst_11432 = (state_11455[(7)]);
var inst_11438 = p.call(null,inst_11432);
var state_11455__$1 = state_11455;
if(cljs.core.truth_(inst_11438)){
var statearr_11463_11485 = state_11455__$1;
(statearr_11463_11485[(1)] = (9));

} else {
var statearr_11464_11486 = state_11455__$1;
(statearr_11464_11486[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11456 === (3))){
var inst_11453 = (state_11455[(2)]);
var state_11455__$1 = state_11455;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11455__$1,inst_11453);
} else {
if((state_val_11456 === (12))){
var state_11455__$1 = state_11455;
var statearr_11465_11487 = state_11455__$1;
(statearr_11465_11487[(2)] = null);

(statearr_11465_11487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11456 === (2))){
var state_11455__$1 = state_11455;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11455__$1,(4),ch);
} else {
if((state_val_11456 === (11))){
var inst_11432 = (state_11455[(7)]);
var inst_11442 = (state_11455[(2)]);
var state_11455__$1 = state_11455;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11455__$1,(8),inst_11442,inst_11432);
} else {
if((state_val_11456 === (9))){
var state_11455__$1 = state_11455;
var statearr_11466_11488 = state_11455__$1;
(statearr_11466_11488[(2)] = tc);

(statearr_11466_11488[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11456 === (5))){
var inst_11435 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11436 = cljs.core.async.close_BANG_.call(null,fc);
var state_11455__$1 = (function (){var statearr_11467 = state_11455;
(statearr_11467[(8)] = inst_11435);

return statearr_11467;
})();
var statearr_11468_11489 = state_11455__$1;
(statearr_11468_11489[(2)] = inst_11436);

(statearr_11468_11489[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11456 === (14))){
var inst_11449 = (state_11455[(2)]);
var state_11455__$1 = state_11455;
var statearr_11469_11490 = state_11455__$1;
(statearr_11469_11490[(2)] = inst_11449);

(statearr_11469_11490[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11456 === (10))){
var state_11455__$1 = state_11455;
var statearr_11470_11491 = state_11455__$1;
(statearr_11470_11491[(2)] = fc);

(statearr_11470_11491[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11456 === (8))){
var inst_11444 = (state_11455[(2)]);
var state_11455__$1 = state_11455;
if(cljs.core.truth_(inst_11444)){
var statearr_11471_11492 = state_11455__$1;
(statearr_11471_11492[(1)] = (12));

} else {
var statearr_11472_11493 = state_11455__$1;
(statearr_11472_11493[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10945__auto__ = null;
var cljs$core$async$state_machine__10945__auto____0 = (function (){
var statearr_11473 = [null,null,null,null,null,null,null,null,null];
(statearr_11473[(0)] = cljs$core$async$state_machine__10945__auto__);

(statearr_11473[(1)] = (1));

return statearr_11473;
});
var cljs$core$async$state_machine__10945__auto____1 = (function (state_11455){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_11455);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e11474){var ex__10948__auto__ = e11474;
var statearr_11475_11494 = state_11455;
(statearr_11475_11494[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_11455[(4)]))){
var statearr_11476_11495 = state_11455;
(statearr_11476_11495[(1)] = cljs.core.first.call(null,(state_11455[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11496 = state_11455;
state_11455 = G__11496;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$state_machine__10945__auto__ = function(state_11455){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10945__auto____1.call(this,state_11455);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10945__auto____0;
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10945__auto____1;
return cljs$core$async$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_11477 = f__11019__auto__.call(null);
(statearr_11477[(6)] = c__11018__auto___11479);

return statearr_11477;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_11518){
var state_val_11519 = (state_11518[(1)]);
if((state_val_11519 === (7))){
var inst_11514 = (state_11518[(2)]);
var state_11518__$1 = state_11518;
var statearr_11520_11539 = state_11518__$1;
(statearr_11520_11539[(2)] = inst_11514);

(statearr_11520_11539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11519 === (1))){
var inst_11497 = init;
var inst_11498 = inst_11497;
var state_11518__$1 = (function (){var statearr_11521 = state_11518;
(statearr_11521[(7)] = inst_11498);

return statearr_11521;
})();
var statearr_11522_11540 = state_11518__$1;
(statearr_11522_11540[(2)] = null);

(statearr_11522_11540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11519 === (4))){
var inst_11501 = (state_11518[(8)]);
var inst_11501__$1 = (state_11518[(2)]);
var inst_11502 = (inst_11501__$1 == null);
var state_11518__$1 = (function (){var statearr_11523 = state_11518;
(statearr_11523[(8)] = inst_11501__$1);

return statearr_11523;
})();
if(cljs.core.truth_(inst_11502)){
var statearr_11524_11541 = state_11518__$1;
(statearr_11524_11541[(1)] = (5));

} else {
var statearr_11525_11542 = state_11518__$1;
(statearr_11525_11542[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11519 === (6))){
var inst_11501 = (state_11518[(8)]);
var inst_11505 = (state_11518[(9)]);
var inst_11498 = (state_11518[(7)]);
var inst_11505__$1 = f.call(null,inst_11498,inst_11501);
var inst_11506 = cljs.core.reduced_QMARK_.call(null,inst_11505__$1);
var state_11518__$1 = (function (){var statearr_11526 = state_11518;
(statearr_11526[(9)] = inst_11505__$1);

return statearr_11526;
})();
if(inst_11506){
var statearr_11527_11543 = state_11518__$1;
(statearr_11527_11543[(1)] = (8));

} else {
var statearr_11528_11544 = state_11518__$1;
(statearr_11528_11544[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11519 === (3))){
var inst_11516 = (state_11518[(2)]);
var state_11518__$1 = state_11518;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11518__$1,inst_11516);
} else {
if((state_val_11519 === (2))){
var state_11518__$1 = state_11518;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11518__$1,(4),ch);
} else {
if((state_val_11519 === (9))){
var inst_11505 = (state_11518[(9)]);
var inst_11498 = inst_11505;
var state_11518__$1 = (function (){var statearr_11529 = state_11518;
(statearr_11529[(7)] = inst_11498);

return statearr_11529;
})();
var statearr_11530_11545 = state_11518__$1;
(statearr_11530_11545[(2)] = null);

(statearr_11530_11545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11519 === (5))){
var inst_11498 = (state_11518[(7)]);
var state_11518__$1 = state_11518;
var statearr_11531_11546 = state_11518__$1;
(statearr_11531_11546[(2)] = inst_11498);

(statearr_11531_11546[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11519 === (10))){
var inst_11512 = (state_11518[(2)]);
var state_11518__$1 = state_11518;
var statearr_11532_11547 = state_11518__$1;
(statearr_11532_11547[(2)] = inst_11512);

(statearr_11532_11547[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11519 === (8))){
var inst_11505 = (state_11518[(9)]);
var inst_11508 = cljs.core.deref.call(null,inst_11505);
var state_11518__$1 = state_11518;
var statearr_11533_11548 = state_11518__$1;
(statearr_11533_11548[(2)] = inst_11508);

(statearr_11533_11548[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__10945__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10945__auto____0 = (function (){
var statearr_11534 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11534[(0)] = cljs$core$async$reduce_$_state_machine__10945__auto__);

(statearr_11534[(1)] = (1));

return statearr_11534;
});
var cljs$core$async$reduce_$_state_machine__10945__auto____1 = (function (state_11518){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_11518);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e11535){var ex__10948__auto__ = e11535;
var statearr_11536_11549 = state_11518;
(statearr_11536_11549[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_11518[(4)]))){
var statearr_11537_11550 = state_11518;
(statearr_11537_11550[(1)] = cljs.core.first.call(null,(state_11518[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11551 = state_11518;
state_11518 = G__11551;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10945__auto__ = function(state_11518){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10945__auto____1.call(this,state_11518);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10945__auto____0;
cljs$core$async$reduce_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10945__auto____1;
return cljs$core$async$reduce_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_11538 = f__11019__auto__.call(null);
(statearr_11538[(6)] = c__11018__auto__);

return statearr_11538;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_11557){
var state_val_11558 = (state_11557[(1)]);
if((state_val_11558 === (1))){
var inst_11552 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_11557__$1 = state_11557;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11557__$1,(2),inst_11552);
} else {
if((state_val_11558 === (2))){
var inst_11554 = (state_11557[(2)]);
var inst_11555 = f__$1.call(null,inst_11554);
var state_11557__$1 = state_11557;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11557__$1,inst_11555);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__10945__auto__ = null;
var cljs$core$async$transduce_$_state_machine__10945__auto____0 = (function (){
var statearr_11559 = [null,null,null,null,null,null,null];
(statearr_11559[(0)] = cljs$core$async$transduce_$_state_machine__10945__auto__);

(statearr_11559[(1)] = (1));

return statearr_11559;
});
var cljs$core$async$transduce_$_state_machine__10945__auto____1 = (function (state_11557){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_11557);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e11560){var ex__10948__auto__ = e11560;
var statearr_11561_11564 = state_11557;
(statearr_11561_11564[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_11557[(4)]))){
var statearr_11562_11565 = state_11557;
(statearr_11562_11565[(1)] = cljs.core.first.call(null,(state_11557[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11566 = state_11557;
state_11557 = G__11566;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__10945__auto__ = function(state_11557){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__10945__auto____1.call(this,state_11557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__10945__auto____0;
cljs$core$async$transduce_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__10945__auto____1;
return cljs$core$async$transduce_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_11563 = f__11019__auto__.call(null);
(statearr_11563[(6)] = c__11018__auto__);

return statearr_11563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__11568 = arguments.length;
switch (G__11568) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_11593){
var state_val_11594 = (state_11593[(1)]);
if((state_val_11594 === (7))){
var inst_11575 = (state_11593[(2)]);
var state_11593__$1 = state_11593;
var statearr_11595_11617 = state_11593__$1;
(statearr_11595_11617[(2)] = inst_11575);

(statearr_11595_11617[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11594 === (1))){
var inst_11569 = cljs.core.seq.call(null,coll);
var inst_11570 = inst_11569;
var state_11593__$1 = (function (){var statearr_11596 = state_11593;
(statearr_11596[(7)] = inst_11570);

return statearr_11596;
})();
var statearr_11597_11618 = state_11593__$1;
(statearr_11597_11618[(2)] = null);

(statearr_11597_11618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11594 === (4))){
var inst_11570 = (state_11593[(7)]);
var inst_11573 = cljs.core.first.call(null,inst_11570);
var state_11593__$1 = state_11593;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11593__$1,(7),ch,inst_11573);
} else {
if((state_val_11594 === (13))){
var inst_11587 = (state_11593[(2)]);
var state_11593__$1 = state_11593;
var statearr_11598_11619 = state_11593__$1;
(statearr_11598_11619[(2)] = inst_11587);

(statearr_11598_11619[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11594 === (6))){
var inst_11578 = (state_11593[(2)]);
var state_11593__$1 = state_11593;
if(cljs.core.truth_(inst_11578)){
var statearr_11599_11620 = state_11593__$1;
(statearr_11599_11620[(1)] = (8));

} else {
var statearr_11600_11621 = state_11593__$1;
(statearr_11600_11621[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11594 === (3))){
var inst_11591 = (state_11593[(2)]);
var state_11593__$1 = state_11593;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11593__$1,inst_11591);
} else {
if((state_val_11594 === (12))){
var state_11593__$1 = state_11593;
var statearr_11601_11622 = state_11593__$1;
(statearr_11601_11622[(2)] = null);

(statearr_11601_11622[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11594 === (2))){
var inst_11570 = (state_11593[(7)]);
var state_11593__$1 = state_11593;
if(cljs.core.truth_(inst_11570)){
var statearr_11602_11623 = state_11593__$1;
(statearr_11602_11623[(1)] = (4));

} else {
var statearr_11603_11624 = state_11593__$1;
(statearr_11603_11624[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11594 === (11))){
var inst_11584 = cljs.core.async.close_BANG_.call(null,ch);
var state_11593__$1 = state_11593;
var statearr_11604_11625 = state_11593__$1;
(statearr_11604_11625[(2)] = inst_11584);

(statearr_11604_11625[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11594 === (9))){
var state_11593__$1 = state_11593;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11605_11626 = state_11593__$1;
(statearr_11605_11626[(1)] = (11));

} else {
var statearr_11606_11627 = state_11593__$1;
(statearr_11606_11627[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11594 === (5))){
var inst_11570 = (state_11593[(7)]);
var state_11593__$1 = state_11593;
var statearr_11607_11628 = state_11593__$1;
(statearr_11607_11628[(2)] = inst_11570);

(statearr_11607_11628[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11594 === (10))){
var inst_11589 = (state_11593[(2)]);
var state_11593__$1 = state_11593;
var statearr_11608_11629 = state_11593__$1;
(statearr_11608_11629[(2)] = inst_11589);

(statearr_11608_11629[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11594 === (8))){
var inst_11570 = (state_11593[(7)]);
var inst_11580 = cljs.core.next.call(null,inst_11570);
var inst_11570__$1 = inst_11580;
var state_11593__$1 = (function (){var statearr_11609 = state_11593;
(statearr_11609[(7)] = inst_11570__$1);

return statearr_11609;
})();
var statearr_11610_11630 = state_11593__$1;
(statearr_11610_11630[(2)] = null);

(statearr_11610_11630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10945__auto__ = null;
var cljs$core$async$state_machine__10945__auto____0 = (function (){
var statearr_11611 = [null,null,null,null,null,null,null,null];
(statearr_11611[(0)] = cljs$core$async$state_machine__10945__auto__);

(statearr_11611[(1)] = (1));

return statearr_11611;
});
var cljs$core$async$state_machine__10945__auto____1 = (function (state_11593){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_11593);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e11612){var ex__10948__auto__ = e11612;
var statearr_11613_11631 = state_11593;
(statearr_11613_11631[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_11593[(4)]))){
var statearr_11614_11632 = state_11593;
(statearr_11614_11632[(1)] = cljs.core.first.call(null,(state_11593[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11633 = state_11593;
state_11593 = G__11633;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$state_machine__10945__auto__ = function(state_11593){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10945__auto____1.call(this,state_11593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10945__auto____0;
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10945__auto____1;
return cljs$core$async$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_11615 = f__11019__auto__.call(null);
(statearr_11615[(6)] = c__11018__auto__);

return statearr_11615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan_BANG_.call(null,ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__11635 = arguments.length;
switch (G__11635) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_.call(null,coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_11637 = (function (_){
var x__5392__auto__ = (((_ == null))?null:_);
var m__5393__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return m__5393__auto__.call(null,_);
} else {
var m__5391__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return m__5391__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_11637.call(null,_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_11638 = (function (m,ch,close_QMARK_){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return m__5393__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5391__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return m__5391__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_11638.call(null,m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_11639 = (function (m,ch){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return m__5393__auto__.call(null,m,ch);
} else {
var m__5391__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return m__5391__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_11639.call(null,m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_11640 = (function (m){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return m__5393__auto__.call(null,m);
} else {
var m__5391__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return m__5391__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_11640.call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11641 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11641 = (function (ch,cs,meta11642){
this.ch = ch;
this.cs = cs;
this.meta11642 = meta11642;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11641.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11643,meta11642__$1){
var self__ = this;
var _11643__$1 = this;
return (new cljs.core.async.t_cljs$core$async11641(self__.ch,self__.cs,meta11642__$1));
}));

(cljs.core.async.t_cljs$core$async11641.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11643){
var self__ = this;
var _11643__$1 = this;
return self__.meta11642;
}));

(cljs.core.async.t_cljs$core$async11641.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11641.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async11641.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11641.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async11641.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async11641.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async11641.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta11642","meta11642",1275715016,null)], null);
}));

(cljs.core.async.t_cljs$core$async11641.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11641.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11641");

(cljs.core.async.t_cljs$core$async11641.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write.call(null,writer__5330__auto__,"cljs.core.async/t_cljs$core$async11641");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11641.
 */
cljs.core.async.__GT_t_cljs$core$async11641 = (function cljs$core$async$mult_$___GT_t_cljs$core$async11641(ch__$1,cs__$1,meta11642){
return (new cljs.core.async.t_cljs$core$async11641(ch__$1,cs__$1,meta11642));
});

}

return (new cljs.core.async.t_cljs$core$async11641(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__11018__auto___11860 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_11776){
var state_val_11777 = (state_11776[(1)]);
if((state_val_11777 === (7))){
var inst_11772 = (state_11776[(2)]);
var state_11776__$1 = state_11776;
var statearr_11778_11861 = state_11776__$1;
(statearr_11778_11861[(2)] = inst_11772);

(statearr_11778_11861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (20))){
var inst_11677 = (state_11776[(7)]);
var inst_11689 = cljs.core.first.call(null,inst_11677);
var inst_11690 = cljs.core.nth.call(null,inst_11689,(0),null);
var inst_11691 = cljs.core.nth.call(null,inst_11689,(1),null);
var state_11776__$1 = (function (){var statearr_11779 = state_11776;
(statearr_11779[(8)] = inst_11690);

return statearr_11779;
})();
if(cljs.core.truth_(inst_11691)){
var statearr_11780_11862 = state_11776__$1;
(statearr_11780_11862[(1)] = (22));

} else {
var statearr_11781_11863 = state_11776__$1;
(statearr_11781_11863[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (27))){
var inst_11721 = (state_11776[(9)]);
var inst_11719 = (state_11776[(10)]);
var inst_11726 = (state_11776[(11)]);
var inst_11646 = (state_11776[(12)]);
var inst_11726__$1 = cljs.core._nth.call(null,inst_11719,inst_11721);
var inst_11727 = cljs.core.async.put_BANG_.call(null,inst_11726__$1,inst_11646,done);
var state_11776__$1 = (function (){var statearr_11782 = state_11776;
(statearr_11782[(11)] = inst_11726__$1);

return statearr_11782;
})();
if(cljs.core.truth_(inst_11727)){
var statearr_11783_11864 = state_11776__$1;
(statearr_11783_11864[(1)] = (30));

} else {
var statearr_11784_11865 = state_11776__$1;
(statearr_11784_11865[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (1))){
var state_11776__$1 = state_11776;
var statearr_11785_11866 = state_11776__$1;
(statearr_11785_11866[(2)] = null);

(statearr_11785_11866[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (24))){
var inst_11677 = (state_11776[(7)]);
var inst_11696 = (state_11776[(2)]);
var inst_11697 = cljs.core.next.call(null,inst_11677);
var inst_11655 = inst_11697;
var inst_11656 = null;
var inst_11657 = (0);
var inst_11658 = (0);
var state_11776__$1 = (function (){var statearr_11786 = state_11776;
(statearr_11786[(13)] = inst_11656);

(statearr_11786[(14)] = inst_11657);

(statearr_11786[(15)] = inst_11655);

(statearr_11786[(16)] = inst_11658);

(statearr_11786[(17)] = inst_11696);

return statearr_11786;
})();
var statearr_11787_11867 = state_11776__$1;
(statearr_11787_11867[(2)] = null);

(statearr_11787_11867[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (39))){
var state_11776__$1 = state_11776;
var statearr_11791_11868 = state_11776__$1;
(statearr_11791_11868[(2)] = null);

(statearr_11791_11868[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (4))){
var inst_11646 = (state_11776[(12)]);
var inst_11646__$1 = (state_11776[(2)]);
var inst_11647 = (inst_11646__$1 == null);
var state_11776__$1 = (function (){var statearr_11792 = state_11776;
(statearr_11792[(12)] = inst_11646__$1);

return statearr_11792;
})();
if(cljs.core.truth_(inst_11647)){
var statearr_11793_11869 = state_11776__$1;
(statearr_11793_11869[(1)] = (5));

} else {
var statearr_11794_11870 = state_11776__$1;
(statearr_11794_11870[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (15))){
var inst_11656 = (state_11776[(13)]);
var inst_11657 = (state_11776[(14)]);
var inst_11655 = (state_11776[(15)]);
var inst_11658 = (state_11776[(16)]);
var inst_11673 = (state_11776[(2)]);
var inst_11674 = (inst_11658 + (1));
var tmp11788 = inst_11656;
var tmp11789 = inst_11657;
var tmp11790 = inst_11655;
var inst_11655__$1 = tmp11790;
var inst_11656__$1 = tmp11788;
var inst_11657__$1 = tmp11789;
var inst_11658__$1 = inst_11674;
var state_11776__$1 = (function (){var statearr_11795 = state_11776;
(statearr_11795[(13)] = inst_11656__$1);

(statearr_11795[(14)] = inst_11657__$1);

(statearr_11795[(18)] = inst_11673);

(statearr_11795[(15)] = inst_11655__$1);

(statearr_11795[(16)] = inst_11658__$1);

return statearr_11795;
})();
var statearr_11796_11871 = state_11776__$1;
(statearr_11796_11871[(2)] = null);

(statearr_11796_11871[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (21))){
var inst_11700 = (state_11776[(2)]);
var state_11776__$1 = state_11776;
var statearr_11800_11872 = state_11776__$1;
(statearr_11800_11872[(2)] = inst_11700);

(statearr_11800_11872[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (31))){
var inst_11726 = (state_11776[(11)]);
var inst_11730 = cljs.core.async.untap_STAR_.call(null,m,inst_11726);
var state_11776__$1 = state_11776;
var statearr_11801_11873 = state_11776__$1;
(statearr_11801_11873[(2)] = inst_11730);

(statearr_11801_11873[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (32))){
var inst_11718 = (state_11776[(19)]);
var inst_11721 = (state_11776[(9)]);
var inst_11719 = (state_11776[(10)]);
var inst_11720 = (state_11776[(20)]);
var inst_11732 = (state_11776[(2)]);
var inst_11733 = (inst_11721 + (1));
var tmp11797 = inst_11718;
var tmp11798 = inst_11719;
var tmp11799 = inst_11720;
var inst_11718__$1 = tmp11797;
var inst_11719__$1 = tmp11798;
var inst_11720__$1 = tmp11799;
var inst_11721__$1 = inst_11733;
var state_11776__$1 = (function (){var statearr_11802 = state_11776;
(statearr_11802[(21)] = inst_11732);

(statearr_11802[(19)] = inst_11718__$1);

(statearr_11802[(9)] = inst_11721__$1);

(statearr_11802[(10)] = inst_11719__$1);

(statearr_11802[(20)] = inst_11720__$1);

return statearr_11802;
})();
var statearr_11803_11874 = state_11776__$1;
(statearr_11803_11874[(2)] = null);

(statearr_11803_11874[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (40))){
var inst_11745 = (state_11776[(22)]);
var inst_11749 = cljs.core.async.untap_STAR_.call(null,m,inst_11745);
var state_11776__$1 = state_11776;
var statearr_11804_11875 = state_11776__$1;
(statearr_11804_11875[(2)] = inst_11749);

(statearr_11804_11875[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (33))){
var inst_11736 = (state_11776[(23)]);
var inst_11738 = cljs.core.chunked_seq_QMARK_.call(null,inst_11736);
var state_11776__$1 = state_11776;
if(inst_11738){
var statearr_11805_11876 = state_11776__$1;
(statearr_11805_11876[(1)] = (36));

} else {
var statearr_11806_11877 = state_11776__$1;
(statearr_11806_11877[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (13))){
var inst_11667 = (state_11776[(24)]);
var inst_11670 = cljs.core.async.close_BANG_.call(null,inst_11667);
var state_11776__$1 = state_11776;
var statearr_11807_11878 = state_11776__$1;
(statearr_11807_11878[(2)] = inst_11670);

(statearr_11807_11878[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (22))){
var inst_11690 = (state_11776[(8)]);
var inst_11693 = cljs.core.async.close_BANG_.call(null,inst_11690);
var state_11776__$1 = state_11776;
var statearr_11808_11879 = state_11776__$1;
(statearr_11808_11879[(2)] = inst_11693);

(statearr_11808_11879[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (36))){
var inst_11736 = (state_11776[(23)]);
var inst_11740 = cljs.core.chunk_first.call(null,inst_11736);
var inst_11741 = cljs.core.chunk_rest.call(null,inst_11736);
var inst_11742 = cljs.core.count.call(null,inst_11740);
var inst_11718 = inst_11741;
var inst_11719 = inst_11740;
var inst_11720 = inst_11742;
var inst_11721 = (0);
var state_11776__$1 = (function (){var statearr_11809 = state_11776;
(statearr_11809[(19)] = inst_11718);

(statearr_11809[(9)] = inst_11721);

(statearr_11809[(10)] = inst_11719);

(statearr_11809[(20)] = inst_11720);

return statearr_11809;
})();
var statearr_11810_11880 = state_11776__$1;
(statearr_11810_11880[(2)] = null);

(statearr_11810_11880[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (41))){
var inst_11736 = (state_11776[(23)]);
var inst_11751 = (state_11776[(2)]);
var inst_11752 = cljs.core.next.call(null,inst_11736);
var inst_11718 = inst_11752;
var inst_11719 = null;
var inst_11720 = (0);
var inst_11721 = (0);
var state_11776__$1 = (function (){var statearr_11811 = state_11776;
(statearr_11811[(19)] = inst_11718);

(statearr_11811[(9)] = inst_11721);

(statearr_11811[(10)] = inst_11719);

(statearr_11811[(25)] = inst_11751);

(statearr_11811[(20)] = inst_11720);

return statearr_11811;
})();
var statearr_11812_11881 = state_11776__$1;
(statearr_11812_11881[(2)] = null);

(statearr_11812_11881[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (43))){
var state_11776__$1 = state_11776;
var statearr_11813_11882 = state_11776__$1;
(statearr_11813_11882[(2)] = null);

(statearr_11813_11882[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (29))){
var inst_11760 = (state_11776[(2)]);
var state_11776__$1 = state_11776;
var statearr_11814_11883 = state_11776__$1;
(statearr_11814_11883[(2)] = inst_11760);

(statearr_11814_11883[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (44))){
var inst_11769 = (state_11776[(2)]);
var state_11776__$1 = (function (){var statearr_11815 = state_11776;
(statearr_11815[(26)] = inst_11769);

return statearr_11815;
})();
var statearr_11816_11884 = state_11776__$1;
(statearr_11816_11884[(2)] = null);

(statearr_11816_11884[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (6))){
var inst_11710 = (state_11776[(27)]);
var inst_11709 = cljs.core.deref.call(null,cs);
var inst_11710__$1 = cljs.core.keys.call(null,inst_11709);
var inst_11711 = cljs.core.count.call(null,inst_11710__$1);
var inst_11712 = cljs.core.reset_BANG_.call(null,dctr,inst_11711);
var inst_11717 = cljs.core.seq.call(null,inst_11710__$1);
var inst_11718 = inst_11717;
var inst_11719 = null;
var inst_11720 = (0);
var inst_11721 = (0);
var state_11776__$1 = (function (){var statearr_11817 = state_11776;
(statearr_11817[(27)] = inst_11710__$1);

(statearr_11817[(19)] = inst_11718);

(statearr_11817[(9)] = inst_11721);

(statearr_11817[(10)] = inst_11719);

(statearr_11817[(20)] = inst_11720);

(statearr_11817[(28)] = inst_11712);

return statearr_11817;
})();
var statearr_11818_11885 = state_11776__$1;
(statearr_11818_11885[(2)] = null);

(statearr_11818_11885[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (28))){
var inst_11736 = (state_11776[(23)]);
var inst_11718 = (state_11776[(19)]);
var inst_11736__$1 = cljs.core.seq.call(null,inst_11718);
var state_11776__$1 = (function (){var statearr_11819 = state_11776;
(statearr_11819[(23)] = inst_11736__$1);

return statearr_11819;
})();
if(inst_11736__$1){
var statearr_11820_11886 = state_11776__$1;
(statearr_11820_11886[(1)] = (33));

} else {
var statearr_11821_11887 = state_11776__$1;
(statearr_11821_11887[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (25))){
var inst_11721 = (state_11776[(9)]);
var inst_11720 = (state_11776[(20)]);
var inst_11723 = (inst_11721 < inst_11720);
var inst_11724 = inst_11723;
var state_11776__$1 = state_11776;
if(cljs.core.truth_(inst_11724)){
var statearr_11822_11888 = state_11776__$1;
(statearr_11822_11888[(1)] = (27));

} else {
var statearr_11823_11889 = state_11776__$1;
(statearr_11823_11889[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (34))){
var state_11776__$1 = state_11776;
var statearr_11824_11890 = state_11776__$1;
(statearr_11824_11890[(2)] = null);

(statearr_11824_11890[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (17))){
var state_11776__$1 = state_11776;
var statearr_11825_11891 = state_11776__$1;
(statearr_11825_11891[(2)] = null);

(statearr_11825_11891[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (3))){
var inst_11774 = (state_11776[(2)]);
var state_11776__$1 = state_11776;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11776__$1,inst_11774);
} else {
if((state_val_11777 === (12))){
var inst_11705 = (state_11776[(2)]);
var state_11776__$1 = state_11776;
var statearr_11826_11892 = state_11776__$1;
(statearr_11826_11892[(2)] = inst_11705);

(statearr_11826_11892[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (2))){
var state_11776__$1 = state_11776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11776__$1,(4),ch);
} else {
if((state_val_11777 === (23))){
var state_11776__$1 = state_11776;
var statearr_11827_11893 = state_11776__$1;
(statearr_11827_11893[(2)] = null);

(statearr_11827_11893[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (35))){
var inst_11758 = (state_11776[(2)]);
var state_11776__$1 = state_11776;
var statearr_11828_11894 = state_11776__$1;
(statearr_11828_11894[(2)] = inst_11758);

(statearr_11828_11894[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (19))){
var inst_11677 = (state_11776[(7)]);
var inst_11681 = cljs.core.chunk_first.call(null,inst_11677);
var inst_11682 = cljs.core.chunk_rest.call(null,inst_11677);
var inst_11683 = cljs.core.count.call(null,inst_11681);
var inst_11655 = inst_11682;
var inst_11656 = inst_11681;
var inst_11657 = inst_11683;
var inst_11658 = (0);
var state_11776__$1 = (function (){var statearr_11829 = state_11776;
(statearr_11829[(13)] = inst_11656);

(statearr_11829[(14)] = inst_11657);

(statearr_11829[(15)] = inst_11655);

(statearr_11829[(16)] = inst_11658);

return statearr_11829;
})();
var statearr_11830_11895 = state_11776__$1;
(statearr_11830_11895[(2)] = null);

(statearr_11830_11895[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (11))){
var inst_11655 = (state_11776[(15)]);
var inst_11677 = (state_11776[(7)]);
var inst_11677__$1 = cljs.core.seq.call(null,inst_11655);
var state_11776__$1 = (function (){var statearr_11831 = state_11776;
(statearr_11831[(7)] = inst_11677__$1);

return statearr_11831;
})();
if(inst_11677__$1){
var statearr_11832_11896 = state_11776__$1;
(statearr_11832_11896[(1)] = (16));

} else {
var statearr_11833_11897 = state_11776__$1;
(statearr_11833_11897[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (9))){
var inst_11707 = (state_11776[(2)]);
var state_11776__$1 = state_11776;
var statearr_11834_11898 = state_11776__$1;
(statearr_11834_11898[(2)] = inst_11707);

(statearr_11834_11898[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (5))){
var inst_11653 = cljs.core.deref.call(null,cs);
var inst_11654 = cljs.core.seq.call(null,inst_11653);
var inst_11655 = inst_11654;
var inst_11656 = null;
var inst_11657 = (0);
var inst_11658 = (0);
var state_11776__$1 = (function (){var statearr_11835 = state_11776;
(statearr_11835[(13)] = inst_11656);

(statearr_11835[(14)] = inst_11657);

(statearr_11835[(15)] = inst_11655);

(statearr_11835[(16)] = inst_11658);

return statearr_11835;
})();
var statearr_11836_11899 = state_11776__$1;
(statearr_11836_11899[(2)] = null);

(statearr_11836_11899[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (14))){
var state_11776__$1 = state_11776;
var statearr_11837_11900 = state_11776__$1;
(statearr_11837_11900[(2)] = null);

(statearr_11837_11900[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (45))){
var inst_11766 = (state_11776[(2)]);
var state_11776__$1 = state_11776;
var statearr_11838_11901 = state_11776__$1;
(statearr_11838_11901[(2)] = inst_11766);

(statearr_11838_11901[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (26))){
var inst_11710 = (state_11776[(27)]);
var inst_11762 = (state_11776[(2)]);
var inst_11763 = cljs.core.seq.call(null,inst_11710);
var state_11776__$1 = (function (){var statearr_11839 = state_11776;
(statearr_11839[(29)] = inst_11762);

return statearr_11839;
})();
if(inst_11763){
var statearr_11840_11902 = state_11776__$1;
(statearr_11840_11902[(1)] = (42));

} else {
var statearr_11841_11903 = state_11776__$1;
(statearr_11841_11903[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (16))){
var inst_11677 = (state_11776[(7)]);
var inst_11679 = cljs.core.chunked_seq_QMARK_.call(null,inst_11677);
var state_11776__$1 = state_11776;
if(inst_11679){
var statearr_11842_11904 = state_11776__$1;
(statearr_11842_11904[(1)] = (19));

} else {
var statearr_11843_11905 = state_11776__$1;
(statearr_11843_11905[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (38))){
var inst_11755 = (state_11776[(2)]);
var state_11776__$1 = state_11776;
var statearr_11844_11906 = state_11776__$1;
(statearr_11844_11906[(2)] = inst_11755);

(statearr_11844_11906[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (30))){
var state_11776__$1 = state_11776;
var statearr_11845_11907 = state_11776__$1;
(statearr_11845_11907[(2)] = null);

(statearr_11845_11907[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (10))){
var inst_11656 = (state_11776[(13)]);
var inst_11658 = (state_11776[(16)]);
var inst_11666 = cljs.core._nth.call(null,inst_11656,inst_11658);
var inst_11667 = cljs.core.nth.call(null,inst_11666,(0),null);
var inst_11668 = cljs.core.nth.call(null,inst_11666,(1),null);
var state_11776__$1 = (function (){var statearr_11846 = state_11776;
(statearr_11846[(24)] = inst_11667);

return statearr_11846;
})();
if(cljs.core.truth_(inst_11668)){
var statearr_11847_11908 = state_11776__$1;
(statearr_11847_11908[(1)] = (13));

} else {
var statearr_11848_11909 = state_11776__$1;
(statearr_11848_11909[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (18))){
var inst_11703 = (state_11776[(2)]);
var state_11776__$1 = state_11776;
var statearr_11849_11910 = state_11776__$1;
(statearr_11849_11910[(2)] = inst_11703);

(statearr_11849_11910[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (42))){
var state_11776__$1 = state_11776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11776__$1,(45),dchan);
} else {
if((state_val_11777 === (37))){
var inst_11736 = (state_11776[(23)]);
var inst_11646 = (state_11776[(12)]);
var inst_11745 = (state_11776[(22)]);
var inst_11745__$1 = cljs.core.first.call(null,inst_11736);
var inst_11746 = cljs.core.async.put_BANG_.call(null,inst_11745__$1,inst_11646,done);
var state_11776__$1 = (function (){var statearr_11850 = state_11776;
(statearr_11850[(22)] = inst_11745__$1);

return statearr_11850;
})();
if(cljs.core.truth_(inst_11746)){
var statearr_11851_11911 = state_11776__$1;
(statearr_11851_11911[(1)] = (39));

} else {
var statearr_11852_11912 = state_11776__$1;
(statearr_11852_11912[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11777 === (8))){
var inst_11657 = (state_11776[(14)]);
var inst_11658 = (state_11776[(16)]);
var inst_11660 = (inst_11658 < inst_11657);
var inst_11661 = inst_11660;
var state_11776__$1 = state_11776;
if(cljs.core.truth_(inst_11661)){
var statearr_11853_11913 = state_11776__$1;
(statearr_11853_11913[(1)] = (10));

} else {
var statearr_11854_11914 = state_11776__$1;
(statearr_11854_11914[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__10945__auto__ = null;
var cljs$core$async$mult_$_state_machine__10945__auto____0 = (function (){
var statearr_11855 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11855[(0)] = cljs$core$async$mult_$_state_machine__10945__auto__);

(statearr_11855[(1)] = (1));

return statearr_11855;
});
var cljs$core$async$mult_$_state_machine__10945__auto____1 = (function (state_11776){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_11776);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e11856){var ex__10948__auto__ = e11856;
var statearr_11857_11915 = state_11776;
(statearr_11857_11915[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_11776[(4)]))){
var statearr_11858_11916 = state_11776;
(statearr_11858_11916[(1)] = cljs.core.first.call(null,(state_11776[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11917 = state_11776;
state_11776 = G__11917;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10945__auto__ = function(state_11776){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10945__auto____1.call(this,state_11776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10945__auto____0;
cljs$core$async$mult_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10945__auto____1;
return cljs$core$async$mult_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_11859 = f__11019__auto__.call(null);
(statearr_11859[(6)] = c__11018__auto___11860);

return statearr_11859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__11919 = arguments.length;
switch (G__11919) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_11921 = (function (m,ch){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return m__5393__auto__.call(null,m,ch);
} else {
var m__5391__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return m__5391__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_11921.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_11922 = (function (m,ch){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return m__5393__auto__.call(null,m,ch);
} else {
var m__5391__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return m__5391__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_11922.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_11923 = (function (m){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return m__5393__auto__.call(null,m);
} else {
var m__5391__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return m__5391__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_11923.call(null,m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_11924 = (function (m,state_map){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return m__5393__auto__.call(null,m,state_map);
} else {
var m__5391__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return m__5391__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_11924.call(null,m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_11925 = (function (m,mode){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return m__5393__auto__.call(null,m,mode);
} else {
var m__5391__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return m__5391__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_11925.call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___11935 = arguments.length;
var i__5769__auto___11936 = (0);
while(true){
if((i__5769__auto___11936 < len__5768__auto___11935)){
args__5774__auto__.push((arguments[i__5769__auto___11936]));

var G__11937 = (i__5769__auto___11936 + (1));
i__5769__auto___11936 = G__11937;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((3) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5775__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__11930){
var map__11931 = p__11930;
var map__11931__$1 = cljs.core.__destructure_map.call(null,map__11931);
var opts = map__11931__$1;
var statearr_11932_11938 = state;
(statearr_11932_11938[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_11933_11939 = state;
(statearr_11933_11939[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_11934_11940 = state;
(statearr_11934_11940[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq11926){
var G__11927 = cljs.core.first.call(null,seq11926);
var seq11926__$1 = cljs.core.next.call(null,seq11926);
var G__11928 = cljs.core.first.call(null,seq11926__$1);
var seq11926__$2 = cljs.core.next.call(null,seq11926__$1);
var G__11929 = cljs.core.first.call(null,seq11926__$2);
var seq11926__$3 = cljs.core.next.call(null,seq11926__$2);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11927,G__11928,G__11929,seq11926__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(1)));
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11941 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11941 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta11942){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta11942 = meta11942;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11943,meta11942__$1){
var self__ = this;
var _11943__$1 = this;
return (new cljs.core.async.t_cljs$core$async11941(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta11942__$1));
}));

(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11943){
var self__ = this;
var _11943__$1 = this;
return self__.meta11942;
}));

(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11941.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta11942","meta11942",1620681456,null)], null);
}));

(cljs.core.async.t_cljs$core$async11941.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11941.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11941");

(cljs.core.async.t_cljs$core$async11941.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write.call(null,writer__5330__auto__,"cljs.core.async/t_cljs$core$async11941");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11941.
 */
cljs.core.async.__GT_t_cljs$core$async11941 = (function cljs$core$async$mix_$___GT_t_cljs$core$async11941(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta11942){
return (new cljs.core.async.t_cljs$core$async11941(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta11942));
});

}

return (new cljs.core.async.t_cljs$core$async11941(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11018__auto___12056 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_12011){
var state_val_12012 = (state_12011[(1)]);
if((state_val_12012 === (7))){
var inst_11971 = (state_12011[(2)]);
var state_12011__$1 = state_12011;
if(cljs.core.truth_(inst_11971)){
var statearr_12013_12057 = state_12011__$1;
(statearr_12013_12057[(1)] = (8));

} else {
var statearr_12014_12058 = state_12011__$1;
(statearr_12014_12058[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (20))){
var inst_11964 = (state_12011[(7)]);
var state_12011__$1 = state_12011;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12011__$1,(23),out,inst_11964);
} else {
if((state_val_12012 === (1))){
var inst_11947 = calc_state.call(null);
var inst_11948 = cljs.core.__destructure_map.call(null,inst_11947);
var inst_11949 = cljs.core.get.call(null,inst_11948,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_11950 = cljs.core.get.call(null,inst_11948,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_11951 = cljs.core.get.call(null,inst_11948,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_11952 = inst_11947;
var state_12011__$1 = (function (){var statearr_12015 = state_12011;
(statearr_12015[(8)] = inst_11949);

(statearr_12015[(9)] = inst_11952);

(statearr_12015[(10)] = inst_11950);

(statearr_12015[(11)] = inst_11951);

return statearr_12015;
})();
var statearr_12016_12059 = state_12011__$1;
(statearr_12016_12059[(2)] = null);

(statearr_12016_12059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (24))){
var inst_11955 = (state_12011[(12)]);
var inst_11952 = inst_11955;
var state_12011__$1 = (function (){var statearr_12017 = state_12011;
(statearr_12017[(9)] = inst_11952);

return statearr_12017;
})();
var statearr_12018_12060 = state_12011__$1;
(statearr_12018_12060[(2)] = null);

(statearr_12018_12060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (4))){
var inst_11964 = (state_12011[(7)]);
var inst_11966 = (state_12011[(13)]);
var inst_11963 = (state_12011[(2)]);
var inst_11964__$1 = cljs.core.nth.call(null,inst_11963,(0),null);
var inst_11965 = cljs.core.nth.call(null,inst_11963,(1),null);
var inst_11966__$1 = (inst_11964__$1 == null);
var state_12011__$1 = (function (){var statearr_12019 = state_12011;
(statearr_12019[(7)] = inst_11964__$1);

(statearr_12019[(13)] = inst_11966__$1);

(statearr_12019[(14)] = inst_11965);

return statearr_12019;
})();
if(cljs.core.truth_(inst_11966__$1)){
var statearr_12020_12061 = state_12011__$1;
(statearr_12020_12061[(1)] = (5));

} else {
var statearr_12021_12062 = state_12011__$1;
(statearr_12021_12062[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (15))){
var inst_11985 = (state_12011[(15)]);
var inst_11956 = (state_12011[(16)]);
var inst_11985__$1 = cljs.core.empty_QMARK_.call(null,inst_11956);
var state_12011__$1 = (function (){var statearr_12022 = state_12011;
(statearr_12022[(15)] = inst_11985__$1);

return statearr_12022;
})();
if(inst_11985__$1){
var statearr_12023_12063 = state_12011__$1;
(statearr_12023_12063[(1)] = (17));

} else {
var statearr_12024_12064 = state_12011__$1;
(statearr_12024_12064[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (21))){
var inst_11955 = (state_12011[(12)]);
var inst_11952 = inst_11955;
var state_12011__$1 = (function (){var statearr_12025 = state_12011;
(statearr_12025[(9)] = inst_11952);

return statearr_12025;
})();
var statearr_12026_12065 = state_12011__$1;
(statearr_12026_12065[(2)] = null);

(statearr_12026_12065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (13))){
var inst_11978 = (state_12011[(2)]);
var inst_11979 = calc_state.call(null);
var inst_11952 = inst_11979;
var state_12011__$1 = (function (){var statearr_12027 = state_12011;
(statearr_12027[(17)] = inst_11978);

(statearr_12027[(9)] = inst_11952);

return statearr_12027;
})();
var statearr_12028_12066 = state_12011__$1;
(statearr_12028_12066[(2)] = null);

(statearr_12028_12066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (22))){
var inst_12005 = (state_12011[(2)]);
var state_12011__$1 = state_12011;
var statearr_12029_12067 = state_12011__$1;
(statearr_12029_12067[(2)] = inst_12005);

(statearr_12029_12067[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (6))){
var inst_11965 = (state_12011[(14)]);
var inst_11969 = cljs.core._EQ_.call(null,inst_11965,change);
var state_12011__$1 = state_12011;
var statearr_12030_12068 = state_12011__$1;
(statearr_12030_12068[(2)] = inst_11969);

(statearr_12030_12068[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (25))){
var state_12011__$1 = state_12011;
var statearr_12031_12069 = state_12011__$1;
(statearr_12031_12069[(2)] = null);

(statearr_12031_12069[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (17))){
var inst_11957 = (state_12011[(18)]);
var inst_11965 = (state_12011[(14)]);
var inst_11987 = inst_11957.call(null,inst_11965);
var inst_11988 = cljs.core.not.call(null,inst_11987);
var state_12011__$1 = state_12011;
var statearr_12032_12070 = state_12011__$1;
(statearr_12032_12070[(2)] = inst_11988);

(statearr_12032_12070[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (3))){
var inst_12009 = (state_12011[(2)]);
var state_12011__$1 = state_12011;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12011__$1,inst_12009);
} else {
if((state_val_12012 === (12))){
var state_12011__$1 = state_12011;
var statearr_12033_12071 = state_12011__$1;
(statearr_12033_12071[(2)] = null);

(statearr_12033_12071[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (2))){
var inst_11952 = (state_12011[(9)]);
var inst_11955 = (state_12011[(12)]);
var inst_11955__$1 = cljs.core.__destructure_map.call(null,inst_11952);
var inst_11956 = cljs.core.get.call(null,inst_11955__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_11957 = cljs.core.get.call(null,inst_11955__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_11958 = cljs.core.get.call(null,inst_11955__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12011__$1 = (function (){var statearr_12034 = state_12011;
(statearr_12034[(18)] = inst_11957);

(statearr_12034[(12)] = inst_11955__$1);

(statearr_12034[(16)] = inst_11956);

return statearr_12034;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_12011__$1,(4),inst_11958);
} else {
if((state_val_12012 === (23))){
var inst_11996 = (state_12011[(2)]);
var state_12011__$1 = state_12011;
if(cljs.core.truth_(inst_11996)){
var statearr_12035_12072 = state_12011__$1;
(statearr_12035_12072[(1)] = (24));

} else {
var statearr_12036_12073 = state_12011__$1;
(statearr_12036_12073[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (19))){
var inst_11991 = (state_12011[(2)]);
var state_12011__$1 = state_12011;
var statearr_12037_12074 = state_12011__$1;
(statearr_12037_12074[(2)] = inst_11991);

(statearr_12037_12074[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (11))){
var inst_11965 = (state_12011[(14)]);
var inst_11975 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_11965);
var state_12011__$1 = state_12011;
var statearr_12038_12075 = state_12011__$1;
(statearr_12038_12075[(2)] = inst_11975);

(statearr_12038_12075[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (9))){
var inst_11982 = (state_12011[(19)]);
var inst_11956 = (state_12011[(16)]);
var inst_11965 = (state_12011[(14)]);
var inst_11982__$1 = inst_11956.call(null,inst_11965);
var state_12011__$1 = (function (){var statearr_12039 = state_12011;
(statearr_12039[(19)] = inst_11982__$1);

return statearr_12039;
})();
if(cljs.core.truth_(inst_11982__$1)){
var statearr_12040_12076 = state_12011__$1;
(statearr_12040_12076[(1)] = (14));

} else {
var statearr_12041_12077 = state_12011__$1;
(statearr_12041_12077[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (5))){
var inst_11966 = (state_12011[(13)]);
var state_12011__$1 = state_12011;
var statearr_12042_12078 = state_12011__$1;
(statearr_12042_12078[(2)] = inst_11966);

(statearr_12042_12078[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (14))){
var inst_11982 = (state_12011[(19)]);
var state_12011__$1 = state_12011;
var statearr_12043_12079 = state_12011__$1;
(statearr_12043_12079[(2)] = inst_11982);

(statearr_12043_12079[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (26))){
var inst_12001 = (state_12011[(2)]);
var state_12011__$1 = state_12011;
var statearr_12044_12080 = state_12011__$1;
(statearr_12044_12080[(2)] = inst_12001);

(statearr_12044_12080[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (16))){
var inst_11993 = (state_12011[(2)]);
var state_12011__$1 = state_12011;
if(cljs.core.truth_(inst_11993)){
var statearr_12045_12081 = state_12011__$1;
(statearr_12045_12081[(1)] = (20));

} else {
var statearr_12046_12082 = state_12011__$1;
(statearr_12046_12082[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (10))){
var inst_12007 = (state_12011[(2)]);
var state_12011__$1 = state_12011;
var statearr_12047_12083 = state_12011__$1;
(statearr_12047_12083[(2)] = inst_12007);

(statearr_12047_12083[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (18))){
var inst_11985 = (state_12011[(15)]);
var state_12011__$1 = state_12011;
var statearr_12048_12084 = state_12011__$1;
(statearr_12048_12084[(2)] = inst_11985);

(statearr_12048_12084[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12012 === (8))){
var inst_11964 = (state_12011[(7)]);
var inst_11973 = (inst_11964 == null);
var state_12011__$1 = state_12011;
if(cljs.core.truth_(inst_11973)){
var statearr_12049_12085 = state_12011__$1;
(statearr_12049_12085[(1)] = (11));

} else {
var statearr_12050_12086 = state_12011__$1;
(statearr_12050_12086[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__10945__auto__ = null;
var cljs$core$async$mix_$_state_machine__10945__auto____0 = (function (){
var statearr_12051 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12051[(0)] = cljs$core$async$mix_$_state_machine__10945__auto__);

(statearr_12051[(1)] = (1));

return statearr_12051;
});
var cljs$core$async$mix_$_state_machine__10945__auto____1 = (function (state_12011){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_12011);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e12052){var ex__10948__auto__ = e12052;
var statearr_12053_12087 = state_12011;
(statearr_12053_12087[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_12011[(4)]))){
var statearr_12054_12088 = state_12011;
(statearr_12054_12088[(1)] = cljs.core.first.call(null,(state_12011[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12089 = state_12011;
state_12011 = G__12089;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10945__auto__ = function(state_12011){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10945__auto____1.call(this,state_12011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10945__auto____0;
cljs$core$async$mix_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10945__auto____1;
return cljs$core$async$mix_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_12055 = f__11019__auto__.call(null);
(statearr_12055[(6)] = c__11018__auto___12056);

return statearr_12055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_12092 = (function (p,v,ch,close_QMARK_){
var x__5392__auto__ = (((p == null))?null:p);
var m__5393__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return m__5393__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5391__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return m__5391__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_12092.call(null,p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_12093 = (function (p,v,ch){
var x__5392__auto__ = (((p == null))?null:p);
var m__5393__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return m__5393__auto__.call(null,p,v,ch);
} else {
var m__5391__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return m__5391__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_12093.call(null,p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_12094 = (function() {
var G__12095 = null;
var G__12095__1 = (function (p){
var x__5392__auto__ = (((p == null))?null:p);
var m__5393__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return m__5393__auto__.call(null,p);
} else {
var m__5391__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return m__5391__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__12095__2 = (function (p,v){
var x__5392__auto__ = (((p == null))?null:p);
var m__5393__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return m__5393__auto__.call(null,p,v);
} else {
var m__5391__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return m__5391__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__12095 = function(p,v){
switch(arguments.length){
case 1:
return G__12095__1.call(this,p);
case 2:
return G__12095__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12095.cljs$core$IFn$_invoke$arity$1 = G__12095__1;
G__12095.cljs$core$IFn$_invoke$arity$2 = G__12095__2;
return G__12095;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__12091 = arguments.length;
switch (G__12091) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12094.call(null,p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12094.call(null,p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__12099 = arguments.length;
switch (G__12099) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__12097_SHARP_){
if(cljs.core.truth_(p1__12097_SHARP_.call(null,topic))){
return p1__12097_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12097_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12100 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12100 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12101){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12101 = meta12101;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12100.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12102,meta12101__$1){
var self__ = this;
var _12102__$1 = this;
return (new cljs.core.async.t_cljs$core$async12100(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12101__$1));
}));

(cljs.core.async.t_cljs$core$async12100.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12102){
var self__ = this;
var _12102__$1 = this;
return self__.meta12101;
}));

(cljs.core.async.t_cljs$core$async12100.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12100.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async12100.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12100.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async12100.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async12100.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async12100.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async12100.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12101","meta12101",-858500242,null)], null);
}));

(cljs.core.async.t_cljs$core$async12100.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12100.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12100");

(cljs.core.async.t_cljs$core$async12100.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write.call(null,writer__5330__auto__,"cljs.core.async/t_cljs$core$async12100");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12100.
 */
cljs.core.async.__GT_t_cljs$core$async12100 = (function cljs$core$async$__GT_t_cljs$core$async12100(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12101){
return (new cljs.core.async.t_cljs$core$async12100(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12101));
});

}

return (new cljs.core.async.t_cljs$core$async12100(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11018__auto___12221 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_12174){
var state_val_12175 = (state_12174[(1)]);
if((state_val_12175 === (7))){
var inst_12170 = (state_12174[(2)]);
var state_12174__$1 = state_12174;
var statearr_12176_12222 = state_12174__$1;
(statearr_12176_12222[(2)] = inst_12170);

(statearr_12176_12222[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (20))){
var state_12174__$1 = state_12174;
var statearr_12177_12223 = state_12174__$1;
(statearr_12177_12223[(2)] = null);

(statearr_12177_12223[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (1))){
var state_12174__$1 = state_12174;
var statearr_12178_12224 = state_12174__$1;
(statearr_12178_12224[(2)] = null);

(statearr_12178_12224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (24))){
var inst_12153 = (state_12174[(7)]);
var inst_12162 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12153);
var state_12174__$1 = state_12174;
var statearr_12179_12225 = state_12174__$1;
(statearr_12179_12225[(2)] = inst_12162);

(statearr_12179_12225[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (4))){
var inst_12105 = (state_12174[(8)]);
var inst_12105__$1 = (state_12174[(2)]);
var inst_12106 = (inst_12105__$1 == null);
var state_12174__$1 = (function (){var statearr_12180 = state_12174;
(statearr_12180[(8)] = inst_12105__$1);

return statearr_12180;
})();
if(cljs.core.truth_(inst_12106)){
var statearr_12181_12226 = state_12174__$1;
(statearr_12181_12226[(1)] = (5));

} else {
var statearr_12182_12227 = state_12174__$1;
(statearr_12182_12227[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (15))){
var inst_12147 = (state_12174[(2)]);
var state_12174__$1 = state_12174;
var statearr_12183_12228 = state_12174__$1;
(statearr_12183_12228[(2)] = inst_12147);

(statearr_12183_12228[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (21))){
var inst_12167 = (state_12174[(2)]);
var state_12174__$1 = (function (){var statearr_12184 = state_12174;
(statearr_12184[(9)] = inst_12167);

return statearr_12184;
})();
var statearr_12185_12229 = state_12174__$1;
(statearr_12185_12229[(2)] = null);

(statearr_12185_12229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (13))){
var inst_12129 = (state_12174[(10)]);
var inst_12131 = cljs.core.chunked_seq_QMARK_.call(null,inst_12129);
var state_12174__$1 = state_12174;
if(inst_12131){
var statearr_12186_12230 = state_12174__$1;
(statearr_12186_12230[(1)] = (16));

} else {
var statearr_12187_12231 = state_12174__$1;
(statearr_12187_12231[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (22))){
var inst_12159 = (state_12174[(2)]);
var state_12174__$1 = state_12174;
if(cljs.core.truth_(inst_12159)){
var statearr_12188_12232 = state_12174__$1;
(statearr_12188_12232[(1)] = (23));

} else {
var statearr_12189_12233 = state_12174__$1;
(statearr_12189_12233[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (6))){
var inst_12153 = (state_12174[(7)]);
var inst_12155 = (state_12174[(11)]);
var inst_12105 = (state_12174[(8)]);
var inst_12153__$1 = topic_fn.call(null,inst_12105);
var inst_12154 = cljs.core.deref.call(null,mults);
var inst_12155__$1 = cljs.core.get.call(null,inst_12154,inst_12153__$1);
var state_12174__$1 = (function (){var statearr_12190 = state_12174;
(statearr_12190[(7)] = inst_12153__$1);

(statearr_12190[(11)] = inst_12155__$1);

return statearr_12190;
})();
if(cljs.core.truth_(inst_12155__$1)){
var statearr_12191_12234 = state_12174__$1;
(statearr_12191_12234[(1)] = (19));

} else {
var statearr_12192_12235 = state_12174__$1;
(statearr_12192_12235[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (25))){
var inst_12164 = (state_12174[(2)]);
var state_12174__$1 = state_12174;
var statearr_12193_12236 = state_12174__$1;
(statearr_12193_12236[(2)] = inst_12164);

(statearr_12193_12236[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (17))){
var inst_12129 = (state_12174[(10)]);
var inst_12138 = cljs.core.first.call(null,inst_12129);
var inst_12139 = cljs.core.async.muxch_STAR_.call(null,inst_12138);
var inst_12140 = cljs.core.async.close_BANG_.call(null,inst_12139);
var inst_12141 = cljs.core.next.call(null,inst_12129);
var inst_12115 = inst_12141;
var inst_12116 = null;
var inst_12117 = (0);
var inst_12118 = (0);
var state_12174__$1 = (function (){var statearr_12194 = state_12174;
(statearr_12194[(12)] = inst_12115);

(statearr_12194[(13)] = inst_12116);

(statearr_12194[(14)] = inst_12117);

(statearr_12194[(15)] = inst_12118);

(statearr_12194[(16)] = inst_12140);

return statearr_12194;
})();
var statearr_12195_12237 = state_12174__$1;
(statearr_12195_12237[(2)] = null);

(statearr_12195_12237[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (3))){
var inst_12172 = (state_12174[(2)]);
var state_12174__$1 = state_12174;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12174__$1,inst_12172);
} else {
if((state_val_12175 === (12))){
var inst_12149 = (state_12174[(2)]);
var state_12174__$1 = state_12174;
var statearr_12196_12238 = state_12174__$1;
(statearr_12196_12238[(2)] = inst_12149);

(statearr_12196_12238[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (2))){
var state_12174__$1 = state_12174;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12174__$1,(4),ch);
} else {
if((state_val_12175 === (23))){
var state_12174__$1 = state_12174;
var statearr_12197_12239 = state_12174__$1;
(statearr_12197_12239[(2)] = null);

(statearr_12197_12239[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (19))){
var inst_12155 = (state_12174[(11)]);
var inst_12105 = (state_12174[(8)]);
var inst_12157 = cljs.core.async.muxch_STAR_.call(null,inst_12155);
var state_12174__$1 = state_12174;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12174__$1,(22),inst_12157,inst_12105);
} else {
if((state_val_12175 === (11))){
var inst_12115 = (state_12174[(12)]);
var inst_12129 = (state_12174[(10)]);
var inst_12129__$1 = cljs.core.seq.call(null,inst_12115);
var state_12174__$1 = (function (){var statearr_12198 = state_12174;
(statearr_12198[(10)] = inst_12129__$1);

return statearr_12198;
})();
if(inst_12129__$1){
var statearr_12199_12240 = state_12174__$1;
(statearr_12199_12240[(1)] = (13));

} else {
var statearr_12200_12241 = state_12174__$1;
(statearr_12200_12241[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (9))){
var inst_12151 = (state_12174[(2)]);
var state_12174__$1 = state_12174;
var statearr_12201_12242 = state_12174__$1;
(statearr_12201_12242[(2)] = inst_12151);

(statearr_12201_12242[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (5))){
var inst_12112 = cljs.core.deref.call(null,mults);
var inst_12113 = cljs.core.vals.call(null,inst_12112);
var inst_12114 = cljs.core.seq.call(null,inst_12113);
var inst_12115 = inst_12114;
var inst_12116 = null;
var inst_12117 = (0);
var inst_12118 = (0);
var state_12174__$1 = (function (){var statearr_12202 = state_12174;
(statearr_12202[(12)] = inst_12115);

(statearr_12202[(13)] = inst_12116);

(statearr_12202[(14)] = inst_12117);

(statearr_12202[(15)] = inst_12118);

return statearr_12202;
})();
var statearr_12203_12243 = state_12174__$1;
(statearr_12203_12243[(2)] = null);

(statearr_12203_12243[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (14))){
var state_12174__$1 = state_12174;
var statearr_12207_12244 = state_12174__$1;
(statearr_12207_12244[(2)] = null);

(statearr_12207_12244[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (16))){
var inst_12129 = (state_12174[(10)]);
var inst_12133 = cljs.core.chunk_first.call(null,inst_12129);
var inst_12134 = cljs.core.chunk_rest.call(null,inst_12129);
var inst_12135 = cljs.core.count.call(null,inst_12133);
var inst_12115 = inst_12134;
var inst_12116 = inst_12133;
var inst_12117 = inst_12135;
var inst_12118 = (0);
var state_12174__$1 = (function (){var statearr_12208 = state_12174;
(statearr_12208[(12)] = inst_12115);

(statearr_12208[(13)] = inst_12116);

(statearr_12208[(14)] = inst_12117);

(statearr_12208[(15)] = inst_12118);

return statearr_12208;
})();
var statearr_12209_12245 = state_12174__$1;
(statearr_12209_12245[(2)] = null);

(statearr_12209_12245[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (10))){
var inst_12115 = (state_12174[(12)]);
var inst_12116 = (state_12174[(13)]);
var inst_12117 = (state_12174[(14)]);
var inst_12118 = (state_12174[(15)]);
var inst_12123 = cljs.core._nth.call(null,inst_12116,inst_12118);
var inst_12124 = cljs.core.async.muxch_STAR_.call(null,inst_12123);
var inst_12125 = cljs.core.async.close_BANG_.call(null,inst_12124);
var inst_12126 = (inst_12118 + (1));
var tmp12204 = inst_12115;
var tmp12205 = inst_12116;
var tmp12206 = inst_12117;
var inst_12115__$1 = tmp12204;
var inst_12116__$1 = tmp12205;
var inst_12117__$1 = tmp12206;
var inst_12118__$1 = inst_12126;
var state_12174__$1 = (function (){var statearr_12210 = state_12174;
(statearr_12210[(12)] = inst_12115__$1);

(statearr_12210[(17)] = inst_12125);

(statearr_12210[(13)] = inst_12116__$1);

(statearr_12210[(14)] = inst_12117__$1);

(statearr_12210[(15)] = inst_12118__$1);

return statearr_12210;
})();
var statearr_12211_12246 = state_12174__$1;
(statearr_12211_12246[(2)] = null);

(statearr_12211_12246[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (18))){
var inst_12144 = (state_12174[(2)]);
var state_12174__$1 = state_12174;
var statearr_12212_12247 = state_12174__$1;
(statearr_12212_12247[(2)] = inst_12144);

(statearr_12212_12247[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12175 === (8))){
var inst_12117 = (state_12174[(14)]);
var inst_12118 = (state_12174[(15)]);
var inst_12120 = (inst_12118 < inst_12117);
var inst_12121 = inst_12120;
var state_12174__$1 = state_12174;
if(cljs.core.truth_(inst_12121)){
var statearr_12213_12248 = state_12174__$1;
(statearr_12213_12248[(1)] = (10));

} else {
var statearr_12214_12249 = state_12174__$1;
(statearr_12214_12249[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10945__auto__ = null;
var cljs$core$async$state_machine__10945__auto____0 = (function (){
var statearr_12215 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12215[(0)] = cljs$core$async$state_machine__10945__auto__);

(statearr_12215[(1)] = (1));

return statearr_12215;
});
var cljs$core$async$state_machine__10945__auto____1 = (function (state_12174){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_12174);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e12216){var ex__10948__auto__ = e12216;
var statearr_12217_12250 = state_12174;
(statearr_12217_12250[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_12174[(4)]))){
var statearr_12218_12251 = state_12174;
(statearr_12218_12251[(1)] = cljs.core.first.call(null,(state_12174[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12252 = state_12174;
state_12174 = G__12252;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$state_machine__10945__auto__ = function(state_12174){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10945__auto____1.call(this,state_12174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10945__auto____0;
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10945__auto____1;
return cljs$core$async$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_12219 = f__11019__auto__.call(null);
(statearr_12219[(6)] = c__11018__auto___12221);

return statearr_12219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__12254 = arguments.length;
switch (G__12254) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__12257 = arguments.length;
switch (G__12257) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__12260 = arguments.length;
switch (G__12260) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_.call(null,out);
} else {
var c__11018__auto___12338 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_12303){
var state_val_12304 = (state_12303[(1)]);
if((state_val_12304 === (7))){
var state_12303__$1 = state_12303;
var statearr_12305_12339 = state_12303__$1;
(statearr_12305_12339[(2)] = null);

(statearr_12305_12339[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (1))){
var state_12303__$1 = state_12303;
var statearr_12306_12340 = state_12303__$1;
(statearr_12306_12340[(2)] = null);

(statearr_12306_12340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (4))){
var inst_12264 = (state_12303[(7)]);
var inst_12263 = (state_12303[(8)]);
var inst_12266 = (inst_12264 < inst_12263);
var state_12303__$1 = state_12303;
if(cljs.core.truth_(inst_12266)){
var statearr_12307_12341 = state_12303__$1;
(statearr_12307_12341[(1)] = (6));

} else {
var statearr_12308_12342 = state_12303__$1;
(statearr_12308_12342[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (15))){
var inst_12289 = (state_12303[(9)]);
var inst_12294 = cljs.core.apply.call(null,f,inst_12289);
var state_12303__$1 = state_12303;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12303__$1,(17),out,inst_12294);
} else {
if((state_val_12304 === (13))){
var inst_12289 = (state_12303[(9)]);
var inst_12289__$1 = (state_12303[(2)]);
var inst_12290 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_12289__$1);
var state_12303__$1 = (function (){var statearr_12309 = state_12303;
(statearr_12309[(9)] = inst_12289__$1);

return statearr_12309;
})();
if(cljs.core.truth_(inst_12290)){
var statearr_12310_12343 = state_12303__$1;
(statearr_12310_12343[(1)] = (14));

} else {
var statearr_12311_12344 = state_12303__$1;
(statearr_12311_12344[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (6))){
var state_12303__$1 = state_12303;
var statearr_12312_12345 = state_12303__$1;
(statearr_12312_12345[(2)] = null);

(statearr_12312_12345[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (17))){
var inst_12296 = (state_12303[(2)]);
var state_12303__$1 = (function (){var statearr_12314 = state_12303;
(statearr_12314[(10)] = inst_12296);

return statearr_12314;
})();
var statearr_12315_12346 = state_12303__$1;
(statearr_12315_12346[(2)] = null);

(statearr_12315_12346[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (3))){
var inst_12301 = (state_12303[(2)]);
var state_12303__$1 = state_12303;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12303__$1,inst_12301);
} else {
if((state_val_12304 === (12))){
var _ = (function (){var statearr_12316 = state_12303;
(statearr_12316[(4)] = cljs.core.rest.call(null,(state_12303[(4)])));

return statearr_12316;
})();
var state_12303__$1 = state_12303;
var ex12313 = (state_12303__$1[(2)]);
var statearr_12317_12347 = state_12303__$1;
(statearr_12317_12347[(5)] = ex12313);


if((ex12313 instanceof Object)){
var statearr_12318_12348 = state_12303__$1;
(statearr_12318_12348[(1)] = (11));

(statearr_12318_12348[(5)] = null);

} else {
throw ex12313;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (2))){
var inst_12262 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_12263 = cnt;
var inst_12264 = (0);
var state_12303__$1 = (function (){var statearr_12319 = state_12303;
(statearr_12319[(7)] = inst_12264);

(statearr_12319[(11)] = inst_12262);

(statearr_12319[(8)] = inst_12263);

return statearr_12319;
})();
var statearr_12320_12349 = state_12303__$1;
(statearr_12320_12349[(2)] = null);

(statearr_12320_12349[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (11))){
var inst_12268 = (state_12303[(2)]);
var inst_12269 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_12303__$1 = (function (){var statearr_12321 = state_12303;
(statearr_12321[(12)] = inst_12268);

return statearr_12321;
})();
var statearr_12322_12350 = state_12303__$1;
(statearr_12322_12350[(2)] = inst_12269);

(statearr_12322_12350[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (9))){
var inst_12264 = (state_12303[(7)]);
var _ = (function (){var statearr_12323 = state_12303;
(statearr_12323[(4)] = cljs.core.cons.call(null,(12),(state_12303[(4)])));

return statearr_12323;
})();
var inst_12275 = chs__$1.call(null,inst_12264);
var inst_12276 = done.call(null,inst_12264);
var inst_12277 = cljs.core.async.take_BANG_.call(null,inst_12275,inst_12276);
var ___$1 = (function (){var statearr_12324 = state_12303;
(statearr_12324[(4)] = cljs.core.rest.call(null,(state_12303[(4)])));

return statearr_12324;
})();
var state_12303__$1 = state_12303;
var statearr_12325_12351 = state_12303__$1;
(statearr_12325_12351[(2)] = inst_12277);

(statearr_12325_12351[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (5))){
var inst_12287 = (state_12303[(2)]);
var state_12303__$1 = (function (){var statearr_12326 = state_12303;
(statearr_12326[(13)] = inst_12287);

return statearr_12326;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12303__$1,(13),dchan);
} else {
if((state_val_12304 === (14))){
var inst_12292 = cljs.core.async.close_BANG_.call(null,out);
var state_12303__$1 = state_12303;
var statearr_12327_12352 = state_12303__$1;
(statearr_12327_12352[(2)] = inst_12292);

(statearr_12327_12352[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (16))){
var inst_12299 = (state_12303[(2)]);
var state_12303__$1 = state_12303;
var statearr_12328_12353 = state_12303__$1;
(statearr_12328_12353[(2)] = inst_12299);

(statearr_12328_12353[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (10))){
var inst_12264 = (state_12303[(7)]);
var inst_12280 = (state_12303[(2)]);
var inst_12281 = (inst_12264 + (1));
var inst_12264__$1 = inst_12281;
var state_12303__$1 = (function (){var statearr_12329 = state_12303;
(statearr_12329[(7)] = inst_12264__$1);

(statearr_12329[(14)] = inst_12280);

return statearr_12329;
})();
var statearr_12330_12354 = state_12303__$1;
(statearr_12330_12354[(2)] = null);

(statearr_12330_12354[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (8))){
var inst_12285 = (state_12303[(2)]);
var state_12303__$1 = state_12303;
var statearr_12331_12355 = state_12303__$1;
(statearr_12331_12355[(2)] = inst_12285);

(statearr_12331_12355[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10945__auto__ = null;
var cljs$core$async$state_machine__10945__auto____0 = (function (){
var statearr_12332 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12332[(0)] = cljs$core$async$state_machine__10945__auto__);

(statearr_12332[(1)] = (1));

return statearr_12332;
});
var cljs$core$async$state_machine__10945__auto____1 = (function (state_12303){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_12303);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e12333){var ex__10948__auto__ = e12333;
var statearr_12334_12356 = state_12303;
(statearr_12334_12356[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_12303[(4)]))){
var statearr_12335_12357 = state_12303;
(statearr_12335_12357[(1)] = cljs.core.first.call(null,(state_12303[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12358 = state_12303;
state_12303 = G__12358;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$state_machine__10945__auto__ = function(state_12303){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10945__auto____1.call(this,state_12303);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10945__auto____0;
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10945__auto____1;
return cljs$core$async$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_12336 = f__11019__auto__.call(null);
(statearr_12336[(6)] = c__11018__auto___12338);

return statearr_12336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__12361 = arguments.length;
switch (G__12361) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11018__auto___12416 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_12393){
var state_val_12394 = (state_12393[(1)]);
if((state_val_12394 === (7))){
var inst_12373 = (state_12393[(7)]);
var inst_12372 = (state_12393[(8)]);
var inst_12372__$1 = (state_12393[(2)]);
var inst_12373__$1 = cljs.core.nth.call(null,inst_12372__$1,(0),null);
var inst_12374 = cljs.core.nth.call(null,inst_12372__$1,(1),null);
var inst_12375 = (inst_12373__$1 == null);
var state_12393__$1 = (function (){var statearr_12395 = state_12393;
(statearr_12395[(7)] = inst_12373__$1);

(statearr_12395[(8)] = inst_12372__$1);

(statearr_12395[(9)] = inst_12374);

return statearr_12395;
})();
if(cljs.core.truth_(inst_12375)){
var statearr_12396_12417 = state_12393__$1;
(statearr_12396_12417[(1)] = (8));

} else {
var statearr_12397_12418 = state_12393__$1;
(statearr_12397_12418[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12394 === (1))){
var inst_12362 = cljs.core.vec.call(null,chs);
var inst_12363 = inst_12362;
var state_12393__$1 = (function (){var statearr_12398 = state_12393;
(statearr_12398[(10)] = inst_12363);

return statearr_12398;
})();
var statearr_12399_12419 = state_12393__$1;
(statearr_12399_12419[(2)] = null);

(statearr_12399_12419[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12394 === (4))){
var inst_12363 = (state_12393[(10)]);
var state_12393__$1 = state_12393;
return cljs.core.async.ioc_alts_BANG_.call(null,state_12393__$1,(7),inst_12363);
} else {
if((state_val_12394 === (6))){
var inst_12389 = (state_12393[(2)]);
var state_12393__$1 = state_12393;
var statearr_12400_12420 = state_12393__$1;
(statearr_12400_12420[(2)] = inst_12389);

(statearr_12400_12420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12394 === (3))){
var inst_12391 = (state_12393[(2)]);
var state_12393__$1 = state_12393;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12393__$1,inst_12391);
} else {
if((state_val_12394 === (2))){
var inst_12363 = (state_12393[(10)]);
var inst_12365 = cljs.core.count.call(null,inst_12363);
var inst_12366 = (inst_12365 > (0));
var state_12393__$1 = state_12393;
if(cljs.core.truth_(inst_12366)){
var statearr_12402_12421 = state_12393__$1;
(statearr_12402_12421[(1)] = (4));

} else {
var statearr_12403_12422 = state_12393__$1;
(statearr_12403_12422[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12394 === (11))){
var inst_12363 = (state_12393[(10)]);
var inst_12382 = (state_12393[(2)]);
var tmp12401 = inst_12363;
var inst_12363__$1 = tmp12401;
var state_12393__$1 = (function (){var statearr_12404 = state_12393;
(statearr_12404[(11)] = inst_12382);

(statearr_12404[(10)] = inst_12363__$1);

return statearr_12404;
})();
var statearr_12405_12423 = state_12393__$1;
(statearr_12405_12423[(2)] = null);

(statearr_12405_12423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12394 === (9))){
var inst_12373 = (state_12393[(7)]);
var state_12393__$1 = state_12393;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12393__$1,(11),out,inst_12373);
} else {
if((state_val_12394 === (5))){
var inst_12387 = cljs.core.async.close_BANG_.call(null,out);
var state_12393__$1 = state_12393;
var statearr_12406_12424 = state_12393__$1;
(statearr_12406_12424[(2)] = inst_12387);

(statearr_12406_12424[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12394 === (10))){
var inst_12385 = (state_12393[(2)]);
var state_12393__$1 = state_12393;
var statearr_12407_12425 = state_12393__$1;
(statearr_12407_12425[(2)] = inst_12385);

(statearr_12407_12425[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12394 === (8))){
var inst_12373 = (state_12393[(7)]);
var inst_12372 = (state_12393[(8)]);
var inst_12374 = (state_12393[(9)]);
var inst_12363 = (state_12393[(10)]);
var inst_12377 = (function (){var cs = inst_12363;
var vec__12368 = inst_12372;
var v = inst_12373;
var c = inst_12374;
return (function (p1__12359_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__12359_SHARP_);
});
})();
var inst_12378 = cljs.core.filterv.call(null,inst_12377,inst_12363);
var inst_12363__$1 = inst_12378;
var state_12393__$1 = (function (){var statearr_12408 = state_12393;
(statearr_12408[(10)] = inst_12363__$1);

return statearr_12408;
})();
var statearr_12409_12426 = state_12393__$1;
(statearr_12409_12426[(2)] = null);

(statearr_12409_12426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10945__auto__ = null;
var cljs$core$async$state_machine__10945__auto____0 = (function (){
var statearr_12410 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12410[(0)] = cljs$core$async$state_machine__10945__auto__);

(statearr_12410[(1)] = (1));

return statearr_12410;
});
var cljs$core$async$state_machine__10945__auto____1 = (function (state_12393){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_12393);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e12411){var ex__10948__auto__ = e12411;
var statearr_12412_12427 = state_12393;
(statearr_12412_12427[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_12393[(4)]))){
var statearr_12413_12428 = state_12393;
(statearr_12413_12428[(1)] = cljs.core.first.call(null,(state_12393[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12429 = state_12393;
state_12393 = G__12429;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$state_machine__10945__auto__ = function(state_12393){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10945__auto____1.call(this,state_12393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10945__auto____0;
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10945__auto____1;
return cljs$core$async$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_12414 = f__11019__auto__.call(null);
(statearr_12414[(6)] = c__11018__auto___12416);

return statearr_12414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__12431 = arguments.length;
switch (G__12431) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11018__auto___12477 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_12455){
var state_val_12456 = (state_12455[(1)]);
if((state_val_12456 === (7))){
var inst_12437 = (state_12455[(7)]);
var inst_12437__$1 = (state_12455[(2)]);
var inst_12438 = (inst_12437__$1 == null);
var inst_12439 = cljs.core.not.call(null,inst_12438);
var state_12455__$1 = (function (){var statearr_12457 = state_12455;
(statearr_12457[(7)] = inst_12437__$1);

return statearr_12457;
})();
if(inst_12439){
var statearr_12458_12478 = state_12455__$1;
(statearr_12458_12478[(1)] = (8));

} else {
var statearr_12459_12479 = state_12455__$1;
(statearr_12459_12479[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12456 === (1))){
var inst_12432 = (0);
var state_12455__$1 = (function (){var statearr_12460 = state_12455;
(statearr_12460[(8)] = inst_12432);

return statearr_12460;
})();
var statearr_12461_12480 = state_12455__$1;
(statearr_12461_12480[(2)] = null);

(statearr_12461_12480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12456 === (4))){
var state_12455__$1 = state_12455;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12455__$1,(7),ch);
} else {
if((state_val_12456 === (6))){
var inst_12450 = (state_12455[(2)]);
var state_12455__$1 = state_12455;
var statearr_12462_12481 = state_12455__$1;
(statearr_12462_12481[(2)] = inst_12450);

(statearr_12462_12481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12456 === (3))){
var inst_12452 = (state_12455[(2)]);
var inst_12453 = cljs.core.async.close_BANG_.call(null,out);
var state_12455__$1 = (function (){var statearr_12463 = state_12455;
(statearr_12463[(9)] = inst_12452);

return statearr_12463;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12455__$1,inst_12453);
} else {
if((state_val_12456 === (2))){
var inst_12432 = (state_12455[(8)]);
var inst_12434 = (inst_12432 < n);
var state_12455__$1 = state_12455;
if(cljs.core.truth_(inst_12434)){
var statearr_12464_12482 = state_12455__$1;
(statearr_12464_12482[(1)] = (4));

} else {
var statearr_12465_12483 = state_12455__$1;
(statearr_12465_12483[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12456 === (11))){
var inst_12432 = (state_12455[(8)]);
var inst_12442 = (state_12455[(2)]);
var inst_12443 = (inst_12432 + (1));
var inst_12432__$1 = inst_12443;
var state_12455__$1 = (function (){var statearr_12466 = state_12455;
(statearr_12466[(8)] = inst_12432__$1);

(statearr_12466[(10)] = inst_12442);

return statearr_12466;
})();
var statearr_12467_12484 = state_12455__$1;
(statearr_12467_12484[(2)] = null);

(statearr_12467_12484[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12456 === (9))){
var state_12455__$1 = state_12455;
var statearr_12468_12485 = state_12455__$1;
(statearr_12468_12485[(2)] = null);

(statearr_12468_12485[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12456 === (5))){
var state_12455__$1 = state_12455;
var statearr_12469_12486 = state_12455__$1;
(statearr_12469_12486[(2)] = null);

(statearr_12469_12486[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12456 === (10))){
var inst_12447 = (state_12455[(2)]);
var state_12455__$1 = state_12455;
var statearr_12470_12487 = state_12455__$1;
(statearr_12470_12487[(2)] = inst_12447);

(statearr_12470_12487[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12456 === (8))){
var inst_12437 = (state_12455[(7)]);
var state_12455__$1 = state_12455;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12455__$1,(11),out,inst_12437);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10945__auto__ = null;
var cljs$core$async$state_machine__10945__auto____0 = (function (){
var statearr_12471 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12471[(0)] = cljs$core$async$state_machine__10945__auto__);

(statearr_12471[(1)] = (1));

return statearr_12471;
});
var cljs$core$async$state_machine__10945__auto____1 = (function (state_12455){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_12455);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e12472){var ex__10948__auto__ = e12472;
var statearr_12473_12488 = state_12455;
(statearr_12473_12488[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_12455[(4)]))){
var statearr_12474_12489 = state_12455;
(statearr_12474_12489[(1)] = cljs.core.first.call(null,(state_12455[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12490 = state_12455;
state_12455 = G__12490;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$state_machine__10945__auto__ = function(state_12455){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10945__auto____1.call(this,state_12455);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10945__auto____0;
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10945__auto____1;
return cljs$core$async$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_12475 = f__11019__auto__.call(null);
(statearr_12475[(6)] = c__11018__auto___12477);

return statearr_12475;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12492 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12492 = (function (f,ch,meta12493){
this.f = f;
this.ch = ch;
this.meta12493 = meta12493;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12494,meta12493__$1){
var self__ = this;
var _12494__$1 = this;
return (new cljs.core.async.t_cljs$core$async12492(self__.f,self__.ch,meta12493__$1));
}));

(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12494){
var self__ = this;
var _12494__$1 = this;
return self__.meta12493;
}));

(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12495 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12495 = (function (f,ch,meta12493,_,fn1,meta12496){
this.f = f;
this.ch = ch;
this.meta12493 = meta12493;
this._ = _;
this.fn1 = fn1;
this.meta12496 = meta12496;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12495.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12497,meta12496__$1){
var self__ = this;
var _12497__$1 = this;
return (new cljs.core.async.t_cljs$core$async12495(self__.f,self__.ch,self__.meta12493,self__._,self__.fn1,meta12496__$1));
}));

(cljs.core.async.t_cljs$core$async12495.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12497){
var self__ = this;
var _12497__$1 = this;
return self__.meta12496;
}));

(cljs.core.async.t_cljs$core$async12495.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12495.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async12495.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12495.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__12491_SHARP_){
return f1.call(null,(((p1__12491_SHARP_ == null))?null:self__.f.call(null,p1__12491_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async12495.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12493","meta12493",1776147428,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async12492","cljs.core.async/t_cljs$core$async12492",1483470916,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta12496","meta12496",113824120,null)], null);
}));

(cljs.core.async.t_cljs$core$async12495.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12495.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12495");

(cljs.core.async.t_cljs$core$async12495.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write.call(null,writer__5330__auto__,"cljs.core.async/t_cljs$core$async12495");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12495.
 */
cljs.core.async.__GT_t_cljs$core$async12495 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12495(f__$1,ch__$1,meta12493__$1,___$2,fn1__$1,meta12496){
return (new cljs.core.async.t_cljs$core$async12495(f__$1,ch__$1,meta12493__$1,___$2,fn1__$1,meta12496));
});

}

return (new cljs.core.async.t_cljs$core$async12495(self__.f,self__.ch,self__.meta12493,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async12492.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12493","meta12493",1776147428,null)], null);
}));

(cljs.core.async.t_cljs$core$async12492.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12492.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12492");

(cljs.core.async.t_cljs$core$async12492.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write.call(null,writer__5330__auto__,"cljs.core.async/t_cljs$core$async12492");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12492.
 */
cljs.core.async.__GT_t_cljs$core$async12492 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12492(f__$1,ch__$1,meta12493){
return (new cljs.core.async.t_cljs$core$async12492(f__$1,ch__$1,meta12493));
});

}

return (new cljs.core.async.t_cljs$core$async12492(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12498 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12498 = (function (f,ch,meta12499){
this.f = f;
this.ch = ch;
this.meta12499 = meta12499;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12498.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12500,meta12499__$1){
var self__ = this;
var _12500__$1 = this;
return (new cljs.core.async.t_cljs$core$async12498(self__.f,self__.ch,meta12499__$1));
}));

(cljs.core.async.t_cljs$core$async12498.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12500){
var self__ = this;
var _12500__$1 = this;
return self__.meta12499;
}));

(cljs.core.async.t_cljs$core$async12498.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12498.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12498.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12498.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12498.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12498.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async12498.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12499","meta12499",1959819974,null)], null);
}));

(cljs.core.async.t_cljs$core$async12498.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12498.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12498");

(cljs.core.async.t_cljs$core$async12498.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write.call(null,writer__5330__auto__,"cljs.core.async/t_cljs$core$async12498");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12498.
 */
cljs.core.async.__GT_t_cljs$core$async12498 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async12498(f__$1,ch__$1,meta12499){
return (new cljs.core.async.t_cljs$core$async12498(f__$1,ch__$1,meta12499));
});

}

return (new cljs.core.async.t_cljs$core$async12498(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12501 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12501 = (function (p,ch,meta12502){
this.p = p;
this.ch = ch;
this.meta12502 = meta12502;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12501.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12503,meta12502__$1){
var self__ = this;
var _12503__$1 = this;
return (new cljs.core.async.t_cljs$core$async12501(self__.p,self__.ch,meta12502__$1));
}));

(cljs.core.async.t_cljs$core$async12501.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12503){
var self__ = this;
var _12503__$1 = this;
return self__.meta12502;
}));

(cljs.core.async.t_cljs$core$async12501.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12501.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12501.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12501.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12501.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12501.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12501.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async12501.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12502","meta12502",259274410,null)], null);
}));

(cljs.core.async.t_cljs$core$async12501.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12501.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12501");

(cljs.core.async.t_cljs$core$async12501.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write.call(null,writer__5330__auto__,"cljs.core.async/t_cljs$core$async12501");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12501.
 */
cljs.core.async.__GT_t_cljs$core$async12501 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async12501(p__$1,ch__$1,meta12502){
return (new cljs.core.async.t_cljs$core$async12501(p__$1,ch__$1,meta12502));
});

}

return (new cljs.core.async.t_cljs$core$async12501(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__12505 = arguments.length;
switch (G__12505) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11018__auto___12546 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_12526){
var state_val_12527 = (state_12526[(1)]);
if((state_val_12527 === (7))){
var inst_12522 = (state_12526[(2)]);
var state_12526__$1 = state_12526;
var statearr_12528_12547 = state_12526__$1;
(statearr_12528_12547[(2)] = inst_12522);

(statearr_12528_12547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12527 === (1))){
var state_12526__$1 = state_12526;
var statearr_12529_12548 = state_12526__$1;
(statearr_12529_12548[(2)] = null);

(statearr_12529_12548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12527 === (4))){
var inst_12508 = (state_12526[(7)]);
var inst_12508__$1 = (state_12526[(2)]);
var inst_12509 = (inst_12508__$1 == null);
var state_12526__$1 = (function (){var statearr_12530 = state_12526;
(statearr_12530[(7)] = inst_12508__$1);

return statearr_12530;
})();
if(cljs.core.truth_(inst_12509)){
var statearr_12531_12549 = state_12526__$1;
(statearr_12531_12549[(1)] = (5));

} else {
var statearr_12532_12550 = state_12526__$1;
(statearr_12532_12550[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12527 === (6))){
var inst_12508 = (state_12526[(7)]);
var inst_12513 = p.call(null,inst_12508);
var state_12526__$1 = state_12526;
if(cljs.core.truth_(inst_12513)){
var statearr_12533_12551 = state_12526__$1;
(statearr_12533_12551[(1)] = (8));

} else {
var statearr_12534_12552 = state_12526__$1;
(statearr_12534_12552[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12527 === (3))){
var inst_12524 = (state_12526[(2)]);
var state_12526__$1 = state_12526;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12526__$1,inst_12524);
} else {
if((state_val_12527 === (2))){
var state_12526__$1 = state_12526;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12526__$1,(4),ch);
} else {
if((state_val_12527 === (11))){
var inst_12516 = (state_12526[(2)]);
var state_12526__$1 = state_12526;
var statearr_12535_12553 = state_12526__$1;
(statearr_12535_12553[(2)] = inst_12516);

(statearr_12535_12553[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12527 === (9))){
var state_12526__$1 = state_12526;
var statearr_12536_12554 = state_12526__$1;
(statearr_12536_12554[(2)] = null);

(statearr_12536_12554[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12527 === (5))){
var inst_12511 = cljs.core.async.close_BANG_.call(null,out);
var state_12526__$1 = state_12526;
var statearr_12537_12555 = state_12526__$1;
(statearr_12537_12555[(2)] = inst_12511);

(statearr_12537_12555[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12527 === (10))){
var inst_12519 = (state_12526[(2)]);
var state_12526__$1 = (function (){var statearr_12538 = state_12526;
(statearr_12538[(8)] = inst_12519);

return statearr_12538;
})();
var statearr_12539_12556 = state_12526__$1;
(statearr_12539_12556[(2)] = null);

(statearr_12539_12556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12527 === (8))){
var inst_12508 = (state_12526[(7)]);
var state_12526__$1 = state_12526;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12526__$1,(11),out,inst_12508);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10945__auto__ = null;
var cljs$core$async$state_machine__10945__auto____0 = (function (){
var statearr_12540 = [null,null,null,null,null,null,null,null,null];
(statearr_12540[(0)] = cljs$core$async$state_machine__10945__auto__);

(statearr_12540[(1)] = (1));

return statearr_12540;
});
var cljs$core$async$state_machine__10945__auto____1 = (function (state_12526){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_12526);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e12541){var ex__10948__auto__ = e12541;
var statearr_12542_12557 = state_12526;
(statearr_12542_12557[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_12526[(4)]))){
var statearr_12543_12558 = state_12526;
(statearr_12543_12558[(1)] = cljs.core.first.call(null,(state_12526[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12559 = state_12526;
state_12526 = G__12559;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$state_machine__10945__auto__ = function(state_12526){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10945__auto____1.call(this,state_12526);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10945__auto____0;
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10945__auto____1;
return cljs$core$async$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_12544 = f__11019__auto__.call(null);
(statearr_12544[(6)] = c__11018__auto___12546);

return statearr_12544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__12561 = arguments.length;
switch (G__12561) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_12624){
var state_val_12625 = (state_12624[(1)]);
if((state_val_12625 === (7))){
var inst_12620 = (state_12624[(2)]);
var state_12624__$1 = state_12624;
var statearr_12626_12665 = state_12624__$1;
(statearr_12626_12665[(2)] = inst_12620);

(statearr_12626_12665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (20))){
var inst_12590 = (state_12624[(7)]);
var inst_12601 = (state_12624[(2)]);
var inst_12602 = cljs.core.next.call(null,inst_12590);
var inst_12576 = inst_12602;
var inst_12577 = null;
var inst_12578 = (0);
var inst_12579 = (0);
var state_12624__$1 = (function (){var statearr_12627 = state_12624;
(statearr_12627[(8)] = inst_12576);

(statearr_12627[(9)] = inst_12601);

(statearr_12627[(10)] = inst_12579);

(statearr_12627[(11)] = inst_12578);

(statearr_12627[(12)] = inst_12577);

return statearr_12627;
})();
var statearr_12628_12666 = state_12624__$1;
(statearr_12628_12666[(2)] = null);

(statearr_12628_12666[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (1))){
var state_12624__$1 = state_12624;
var statearr_12629_12667 = state_12624__$1;
(statearr_12629_12667[(2)] = null);

(statearr_12629_12667[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (4))){
var inst_12565 = (state_12624[(13)]);
var inst_12565__$1 = (state_12624[(2)]);
var inst_12566 = (inst_12565__$1 == null);
var state_12624__$1 = (function (){var statearr_12630 = state_12624;
(statearr_12630[(13)] = inst_12565__$1);

return statearr_12630;
})();
if(cljs.core.truth_(inst_12566)){
var statearr_12631_12668 = state_12624__$1;
(statearr_12631_12668[(1)] = (5));

} else {
var statearr_12632_12669 = state_12624__$1;
(statearr_12632_12669[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (15))){
var state_12624__$1 = state_12624;
var statearr_12636_12670 = state_12624__$1;
(statearr_12636_12670[(2)] = null);

(statearr_12636_12670[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (21))){
var state_12624__$1 = state_12624;
var statearr_12637_12671 = state_12624__$1;
(statearr_12637_12671[(2)] = null);

(statearr_12637_12671[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (13))){
var inst_12576 = (state_12624[(8)]);
var inst_12579 = (state_12624[(10)]);
var inst_12578 = (state_12624[(11)]);
var inst_12577 = (state_12624[(12)]);
var inst_12586 = (state_12624[(2)]);
var inst_12587 = (inst_12579 + (1));
var tmp12633 = inst_12576;
var tmp12634 = inst_12578;
var tmp12635 = inst_12577;
var inst_12576__$1 = tmp12633;
var inst_12577__$1 = tmp12635;
var inst_12578__$1 = tmp12634;
var inst_12579__$1 = inst_12587;
var state_12624__$1 = (function (){var statearr_12638 = state_12624;
(statearr_12638[(8)] = inst_12576__$1);

(statearr_12638[(10)] = inst_12579__$1);

(statearr_12638[(11)] = inst_12578__$1);

(statearr_12638[(12)] = inst_12577__$1);

(statearr_12638[(14)] = inst_12586);

return statearr_12638;
})();
var statearr_12639_12672 = state_12624__$1;
(statearr_12639_12672[(2)] = null);

(statearr_12639_12672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (22))){
var state_12624__$1 = state_12624;
var statearr_12640_12673 = state_12624__$1;
(statearr_12640_12673[(2)] = null);

(statearr_12640_12673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (6))){
var inst_12565 = (state_12624[(13)]);
var inst_12574 = f.call(null,inst_12565);
var inst_12575 = cljs.core.seq.call(null,inst_12574);
var inst_12576 = inst_12575;
var inst_12577 = null;
var inst_12578 = (0);
var inst_12579 = (0);
var state_12624__$1 = (function (){var statearr_12641 = state_12624;
(statearr_12641[(8)] = inst_12576);

(statearr_12641[(10)] = inst_12579);

(statearr_12641[(11)] = inst_12578);

(statearr_12641[(12)] = inst_12577);

return statearr_12641;
})();
var statearr_12642_12674 = state_12624__$1;
(statearr_12642_12674[(2)] = null);

(statearr_12642_12674[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (17))){
var inst_12590 = (state_12624[(7)]);
var inst_12594 = cljs.core.chunk_first.call(null,inst_12590);
var inst_12595 = cljs.core.chunk_rest.call(null,inst_12590);
var inst_12596 = cljs.core.count.call(null,inst_12594);
var inst_12576 = inst_12595;
var inst_12577 = inst_12594;
var inst_12578 = inst_12596;
var inst_12579 = (0);
var state_12624__$1 = (function (){var statearr_12643 = state_12624;
(statearr_12643[(8)] = inst_12576);

(statearr_12643[(10)] = inst_12579);

(statearr_12643[(11)] = inst_12578);

(statearr_12643[(12)] = inst_12577);

return statearr_12643;
})();
var statearr_12644_12675 = state_12624__$1;
(statearr_12644_12675[(2)] = null);

(statearr_12644_12675[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (3))){
var inst_12622 = (state_12624[(2)]);
var state_12624__$1 = state_12624;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12624__$1,inst_12622);
} else {
if((state_val_12625 === (12))){
var inst_12610 = (state_12624[(2)]);
var state_12624__$1 = state_12624;
var statearr_12645_12676 = state_12624__$1;
(statearr_12645_12676[(2)] = inst_12610);

(statearr_12645_12676[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (2))){
var state_12624__$1 = state_12624;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12624__$1,(4),in$);
} else {
if((state_val_12625 === (23))){
var inst_12618 = (state_12624[(2)]);
var state_12624__$1 = state_12624;
var statearr_12646_12677 = state_12624__$1;
(statearr_12646_12677[(2)] = inst_12618);

(statearr_12646_12677[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (19))){
var inst_12605 = (state_12624[(2)]);
var state_12624__$1 = state_12624;
var statearr_12647_12678 = state_12624__$1;
(statearr_12647_12678[(2)] = inst_12605);

(statearr_12647_12678[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (11))){
var inst_12576 = (state_12624[(8)]);
var inst_12590 = (state_12624[(7)]);
var inst_12590__$1 = cljs.core.seq.call(null,inst_12576);
var state_12624__$1 = (function (){var statearr_12648 = state_12624;
(statearr_12648[(7)] = inst_12590__$1);

return statearr_12648;
})();
if(inst_12590__$1){
var statearr_12649_12679 = state_12624__$1;
(statearr_12649_12679[(1)] = (14));

} else {
var statearr_12650_12680 = state_12624__$1;
(statearr_12650_12680[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (9))){
var inst_12612 = (state_12624[(2)]);
var inst_12613 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_12624__$1 = (function (){var statearr_12651 = state_12624;
(statearr_12651[(15)] = inst_12612);

return statearr_12651;
})();
if(cljs.core.truth_(inst_12613)){
var statearr_12652_12681 = state_12624__$1;
(statearr_12652_12681[(1)] = (21));

} else {
var statearr_12653_12682 = state_12624__$1;
(statearr_12653_12682[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (5))){
var inst_12568 = cljs.core.async.close_BANG_.call(null,out);
var state_12624__$1 = state_12624;
var statearr_12654_12683 = state_12624__$1;
(statearr_12654_12683[(2)] = inst_12568);

(statearr_12654_12683[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (14))){
var inst_12590 = (state_12624[(7)]);
var inst_12592 = cljs.core.chunked_seq_QMARK_.call(null,inst_12590);
var state_12624__$1 = state_12624;
if(inst_12592){
var statearr_12655_12684 = state_12624__$1;
(statearr_12655_12684[(1)] = (17));

} else {
var statearr_12656_12685 = state_12624__$1;
(statearr_12656_12685[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (16))){
var inst_12608 = (state_12624[(2)]);
var state_12624__$1 = state_12624;
var statearr_12657_12686 = state_12624__$1;
(statearr_12657_12686[(2)] = inst_12608);

(statearr_12657_12686[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12625 === (10))){
var inst_12579 = (state_12624[(10)]);
var inst_12577 = (state_12624[(12)]);
var inst_12584 = cljs.core._nth.call(null,inst_12577,inst_12579);
var state_12624__$1 = state_12624;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12624__$1,(13),out,inst_12584);
} else {
if((state_val_12625 === (18))){
var inst_12590 = (state_12624[(7)]);
var inst_12599 = cljs.core.first.call(null,inst_12590);
var state_12624__$1 = state_12624;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12624__$1,(20),out,inst_12599);
} else {
if((state_val_12625 === (8))){
var inst_12579 = (state_12624[(10)]);
var inst_12578 = (state_12624[(11)]);
var inst_12581 = (inst_12579 < inst_12578);
var inst_12582 = inst_12581;
var state_12624__$1 = state_12624;
if(cljs.core.truth_(inst_12582)){
var statearr_12658_12687 = state_12624__$1;
(statearr_12658_12687[(1)] = (10));

} else {
var statearr_12659_12688 = state_12624__$1;
(statearr_12659_12688[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10945__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10945__auto____0 = (function (){
var statearr_12660 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12660[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10945__auto__);

(statearr_12660[(1)] = (1));

return statearr_12660;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10945__auto____1 = (function (state_12624){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_12624);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e12661){var ex__10948__auto__ = e12661;
var statearr_12662_12689 = state_12624;
(statearr_12662_12689[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_12624[(4)]))){
var statearr_12663_12690 = state_12624;
(statearr_12663_12690[(1)] = cljs.core.first.call(null,(state_12624[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12691 = state_12624;
state_12624 = G__12691;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10945__auto__ = function(state_12624){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10945__auto____1.call(this,state_12624);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10945__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10945__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_12664 = f__11019__auto__.call(null);
(statearr_12664[(6)] = c__11018__auto__);

return statearr_12664;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__12693 = arguments.length;
switch (G__12693) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__12696 = arguments.length;
switch (G__12696) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__12699 = arguments.length;
switch (G__12699) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11018__auto___12747 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_12723){
var state_val_12724 = (state_12723[(1)]);
if((state_val_12724 === (7))){
var inst_12718 = (state_12723[(2)]);
var state_12723__$1 = state_12723;
var statearr_12725_12748 = state_12723__$1;
(statearr_12725_12748[(2)] = inst_12718);

(statearr_12725_12748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (1))){
var inst_12700 = null;
var state_12723__$1 = (function (){var statearr_12726 = state_12723;
(statearr_12726[(7)] = inst_12700);

return statearr_12726;
})();
var statearr_12727_12749 = state_12723__$1;
(statearr_12727_12749[(2)] = null);

(statearr_12727_12749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (4))){
var inst_12703 = (state_12723[(8)]);
var inst_12703__$1 = (state_12723[(2)]);
var inst_12704 = (inst_12703__$1 == null);
var inst_12705 = cljs.core.not.call(null,inst_12704);
var state_12723__$1 = (function (){var statearr_12728 = state_12723;
(statearr_12728[(8)] = inst_12703__$1);

return statearr_12728;
})();
if(inst_12705){
var statearr_12729_12750 = state_12723__$1;
(statearr_12729_12750[(1)] = (5));

} else {
var statearr_12730_12751 = state_12723__$1;
(statearr_12730_12751[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (6))){
var state_12723__$1 = state_12723;
var statearr_12731_12752 = state_12723__$1;
(statearr_12731_12752[(2)] = null);

(statearr_12731_12752[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (3))){
var inst_12720 = (state_12723[(2)]);
var inst_12721 = cljs.core.async.close_BANG_.call(null,out);
var state_12723__$1 = (function (){var statearr_12732 = state_12723;
(statearr_12732[(9)] = inst_12720);

return statearr_12732;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12723__$1,inst_12721);
} else {
if((state_val_12724 === (2))){
var state_12723__$1 = state_12723;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12723__$1,(4),ch);
} else {
if((state_val_12724 === (11))){
var inst_12703 = (state_12723[(8)]);
var inst_12712 = (state_12723[(2)]);
var inst_12700 = inst_12703;
var state_12723__$1 = (function (){var statearr_12733 = state_12723;
(statearr_12733[(7)] = inst_12700);

(statearr_12733[(10)] = inst_12712);

return statearr_12733;
})();
var statearr_12734_12753 = state_12723__$1;
(statearr_12734_12753[(2)] = null);

(statearr_12734_12753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (9))){
var inst_12703 = (state_12723[(8)]);
var state_12723__$1 = state_12723;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12723__$1,(11),out,inst_12703);
} else {
if((state_val_12724 === (5))){
var inst_12700 = (state_12723[(7)]);
var inst_12703 = (state_12723[(8)]);
var inst_12707 = cljs.core._EQ_.call(null,inst_12703,inst_12700);
var state_12723__$1 = state_12723;
if(inst_12707){
var statearr_12736_12754 = state_12723__$1;
(statearr_12736_12754[(1)] = (8));

} else {
var statearr_12737_12755 = state_12723__$1;
(statearr_12737_12755[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (10))){
var inst_12715 = (state_12723[(2)]);
var state_12723__$1 = state_12723;
var statearr_12738_12756 = state_12723__$1;
(statearr_12738_12756[(2)] = inst_12715);

(statearr_12738_12756[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (8))){
var inst_12700 = (state_12723[(7)]);
var tmp12735 = inst_12700;
var inst_12700__$1 = tmp12735;
var state_12723__$1 = (function (){var statearr_12739 = state_12723;
(statearr_12739[(7)] = inst_12700__$1);

return statearr_12739;
})();
var statearr_12740_12757 = state_12723__$1;
(statearr_12740_12757[(2)] = null);

(statearr_12740_12757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10945__auto__ = null;
var cljs$core$async$state_machine__10945__auto____0 = (function (){
var statearr_12741 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12741[(0)] = cljs$core$async$state_machine__10945__auto__);

(statearr_12741[(1)] = (1));

return statearr_12741;
});
var cljs$core$async$state_machine__10945__auto____1 = (function (state_12723){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_12723);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e12742){var ex__10948__auto__ = e12742;
var statearr_12743_12758 = state_12723;
(statearr_12743_12758[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_12723[(4)]))){
var statearr_12744_12759 = state_12723;
(statearr_12744_12759[(1)] = cljs.core.first.call(null,(state_12723[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12760 = state_12723;
state_12723 = G__12760;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$state_machine__10945__auto__ = function(state_12723){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10945__auto____1.call(this,state_12723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10945__auto____0;
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10945__auto____1;
return cljs$core$async$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_12745 = f__11019__auto__.call(null);
(statearr_12745[(6)] = c__11018__auto___12747);

return statearr_12745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__12762 = arguments.length;
switch (G__12762) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11018__auto___12829 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_12800){
var state_val_12801 = (state_12800[(1)]);
if((state_val_12801 === (7))){
var inst_12796 = (state_12800[(2)]);
var state_12800__$1 = state_12800;
var statearr_12802_12830 = state_12800__$1;
(statearr_12802_12830[(2)] = inst_12796);

(statearr_12802_12830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12801 === (1))){
var inst_12763 = (new Array(n));
var inst_12764 = inst_12763;
var inst_12765 = (0);
var state_12800__$1 = (function (){var statearr_12803 = state_12800;
(statearr_12803[(7)] = inst_12765);

(statearr_12803[(8)] = inst_12764);

return statearr_12803;
})();
var statearr_12804_12831 = state_12800__$1;
(statearr_12804_12831[(2)] = null);

(statearr_12804_12831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12801 === (4))){
var inst_12768 = (state_12800[(9)]);
var inst_12768__$1 = (state_12800[(2)]);
var inst_12769 = (inst_12768__$1 == null);
var inst_12770 = cljs.core.not.call(null,inst_12769);
var state_12800__$1 = (function (){var statearr_12805 = state_12800;
(statearr_12805[(9)] = inst_12768__$1);

return statearr_12805;
})();
if(inst_12770){
var statearr_12806_12832 = state_12800__$1;
(statearr_12806_12832[(1)] = (5));

} else {
var statearr_12807_12833 = state_12800__$1;
(statearr_12807_12833[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12801 === (15))){
var inst_12790 = (state_12800[(2)]);
var state_12800__$1 = state_12800;
var statearr_12808_12834 = state_12800__$1;
(statearr_12808_12834[(2)] = inst_12790);

(statearr_12808_12834[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12801 === (13))){
var state_12800__$1 = state_12800;
var statearr_12809_12835 = state_12800__$1;
(statearr_12809_12835[(2)] = null);

(statearr_12809_12835[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12801 === (6))){
var inst_12765 = (state_12800[(7)]);
var inst_12786 = (inst_12765 > (0));
var state_12800__$1 = state_12800;
if(cljs.core.truth_(inst_12786)){
var statearr_12810_12836 = state_12800__$1;
(statearr_12810_12836[(1)] = (12));

} else {
var statearr_12811_12837 = state_12800__$1;
(statearr_12811_12837[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12801 === (3))){
var inst_12798 = (state_12800[(2)]);
var state_12800__$1 = state_12800;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12800__$1,inst_12798);
} else {
if((state_val_12801 === (12))){
var inst_12764 = (state_12800[(8)]);
var inst_12788 = cljs.core.vec.call(null,inst_12764);
var state_12800__$1 = state_12800;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12800__$1,(15),out,inst_12788);
} else {
if((state_val_12801 === (2))){
var state_12800__$1 = state_12800;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12800__$1,(4),ch);
} else {
if((state_val_12801 === (11))){
var inst_12780 = (state_12800[(2)]);
var inst_12781 = (new Array(n));
var inst_12764 = inst_12781;
var inst_12765 = (0);
var state_12800__$1 = (function (){var statearr_12812 = state_12800;
(statearr_12812[(7)] = inst_12765);

(statearr_12812[(8)] = inst_12764);

(statearr_12812[(10)] = inst_12780);

return statearr_12812;
})();
var statearr_12813_12838 = state_12800__$1;
(statearr_12813_12838[(2)] = null);

(statearr_12813_12838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12801 === (9))){
var inst_12764 = (state_12800[(8)]);
var inst_12778 = cljs.core.vec.call(null,inst_12764);
var state_12800__$1 = state_12800;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12800__$1,(11),out,inst_12778);
} else {
if((state_val_12801 === (5))){
var inst_12768 = (state_12800[(9)]);
var inst_12765 = (state_12800[(7)]);
var inst_12773 = (state_12800[(11)]);
var inst_12764 = (state_12800[(8)]);
var inst_12772 = (inst_12764[inst_12765] = inst_12768);
var inst_12773__$1 = (inst_12765 + (1));
var inst_12774 = (inst_12773__$1 < n);
var state_12800__$1 = (function (){var statearr_12814 = state_12800;
(statearr_12814[(11)] = inst_12773__$1);

(statearr_12814[(12)] = inst_12772);

return statearr_12814;
})();
if(cljs.core.truth_(inst_12774)){
var statearr_12815_12839 = state_12800__$1;
(statearr_12815_12839[(1)] = (8));

} else {
var statearr_12816_12840 = state_12800__$1;
(statearr_12816_12840[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12801 === (14))){
var inst_12793 = (state_12800[(2)]);
var inst_12794 = cljs.core.async.close_BANG_.call(null,out);
var state_12800__$1 = (function (){var statearr_12818 = state_12800;
(statearr_12818[(13)] = inst_12793);

return statearr_12818;
})();
var statearr_12819_12841 = state_12800__$1;
(statearr_12819_12841[(2)] = inst_12794);

(statearr_12819_12841[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12801 === (10))){
var inst_12784 = (state_12800[(2)]);
var state_12800__$1 = state_12800;
var statearr_12820_12842 = state_12800__$1;
(statearr_12820_12842[(2)] = inst_12784);

(statearr_12820_12842[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12801 === (8))){
var inst_12773 = (state_12800[(11)]);
var inst_12764 = (state_12800[(8)]);
var tmp12817 = inst_12764;
var inst_12764__$1 = tmp12817;
var inst_12765 = inst_12773;
var state_12800__$1 = (function (){var statearr_12821 = state_12800;
(statearr_12821[(7)] = inst_12765);

(statearr_12821[(8)] = inst_12764__$1);

return statearr_12821;
})();
var statearr_12822_12843 = state_12800__$1;
(statearr_12822_12843[(2)] = null);

(statearr_12822_12843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10945__auto__ = null;
var cljs$core$async$state_machine__10945__auto____0 = (function (){
var statearr_12823 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12823[(0)] = cljs$core$async$state_machine__10945__auto__);

(statearr_12823[(1)] = (1));

return statearr_12823;
});
var cljs$core$async$state_machine__10945__auto____1 = (function (state_12800){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_12800);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e12824){var ex__10948__auto__ = e12824;
var statearr_12825_12844 = state_12800;
(statearr_12825_12844[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_12800[(4)]))){
var statearr_12826_12845 = state_12800;
(statearr_12826_12845[(1)] = cljs.core.first.call(null,(state_12800[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12846 = state_12800;
state_12800 = G__12846;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$state_machine__10945__auto__ = function(state_12800){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10945__auto____1.call(this,state_12800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10945__auto____0;
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10945__auto____1;
return cljs$core$async$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_12827 = f__11019__auto__.call(null);
(statearr_12827[(6)] = c__11018__auto___12829);

return statearr_12827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__12848 = arguments.length;
switch (G__12848) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11018__auto___12926 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_12893){
var state_val_12894 = (state_12893[(1)]);
if((state_val_12894 === (7))){
var inst_12889 = (state_12893[(2)]);
var state_12893__$1 = state_12893;
var statearr_12895_12927 = state_12893__$1;
(statearr_12895_12927[(2)] = inst_12889);

(statearr_12895_12927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12894 === (1))){
var inst_12849 = [];
var inst_12850 = inst_12849;
var inst_12851 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_12893__$1 = (function (){var statearr_12896 = state_12893;
(statearr_12896[(7)] = inst_12851);

(statearr_12896[(8)] = inst_12850);

return statearr_12896;
})();
var statearr_12897_12928 = state_12893__$1;
(statearr_12897_12928[(2)] = null);

(statearr_12897_12928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12894 === (4))){
var inst_12854 = (state_12893[(9)]);
var inst_12854__$1 = (state_12893[(2)]);
var inst_12855 = (inst_12854__$1 == null);
var inst_12856 = cljs.core.not.call(null,inst_12855);
var state_12893__$1 = (function (){var statearr_12898 = state_12893;
(statearr_12898[(9)] = inst_12854__$1);

return statearr_12898;
})();
if(inst_12856){
var statearr_12899_12929 = state_12893__$1;
(statearr_12899_12929[(1)] = (5));

} else {
var statearr_12900_12930 = state_12893__$1;
(statearr_12900_12930[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12894 === (15))){
var inst_12850 = (state_12893[(8)]);
var inst_12881 = cljs.core.vec.call(null,inst_12850);
var state_12893__$1 = state_12893;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12893__$1,(18),out,inst_12881);
} else {
if((state_val_12894 === (13))){
var inst_12876 = (state_12893[(2)]);
var state_12893__$1 = state_12893;
var statearr_12901_12931 = state_12893__$1;
(statearr_12901_12931[(2)] = inst_12876);

(statearr_12901_12931[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12894 === (6))){
var inst_12850 = (state_12893[(8)]);
var inst_12878 = inst_12850.length;
var inst_12879 = (inst_12878 > (0));
var state_12893__$1 = state_12893;
if(cljs.core.truth_(inst_12879)){
var statearr_12902_12932 = state_12893__$1;
(statearr_12902_12932[(1)] = (15));

} else {
var statearr_12903_12933 = state_12893__$1;
(statearr_12903_12933[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12894 === (17))){
var inst_12886 = (state_12893[(2)]);
var inst_12887 = cljs.core.async.close_BANG_.call(null,out);
var state_12893__$1 = (function (){var statearr_12904 = state_12893;
(statearr_12904[(10)] = inst_12886);

return statearr_12904;
})();
var statearr_12905_12934 = state_12893__$1;
(statearr_12905_12934[(2)] = inst_12887);

(statearr_12905_12934[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12894 === (3))){
var inst_12891 = (state_12893[(2)]);
var state_12893__$1 = state_12893;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12893__$1,inst_12891);
} else {
if((state_val_12894 === (12))){
var inst_12850 = (state_12893[(8)]);
var inst_12869 = cljs.core.vec.call(null,inst_12850);
var state_12893__$1 = state_12893;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12893__$1,(14),out,inst_12869);
} else {
if((state_val_12894 === (2))){
var state_12893__$1 = state_12893;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12893__$1,(4),ch);
} else {
if((state_val_12894 === (11))){
var inst_12858 = (state_12893[(11)]);
var inst_12854 = (state_12893[(9)]);
var inst_12850 = (state_12893[(8)]);
var inst_12866 = inst_12850.push(inst_12854);
var tmp12906 = inst_12850;
var inst_12850__$1 = tmp12906;
var inst_12851 = inst_12858;
var state_12893__$1 = (function (){var statearr_12907 = state_12893;
(statearr_12907[(7)] = inst_12851);

(statearr_12907[(8)] = inst_12850__$1);

(statearr_12907[(12)] = inst_12866);

return statearr_12907;
})();
var statearr_12908_12935 = state_12893__$1;
(statearr_12908_12935[(2)] = null);

(statearr_12908_12935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12894 === (9))){
var inst_12851 = (state_12893[(7)]);
var inst_12862 = cljs.core.keyword_identical_QMARK_.call(null,inst_12851,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_12893__$1 = state_12893;
var statearr_12909_12936 = state_12893__$1;
(statearr_12909_12936[(2)] = inst_12862);

(statearr_12909_12936[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12894 === (5))){
var inst_12851 = (state_12893[(7)]);
var inst_12858 = (state_12893[(11)]);
var inst_12859 = (state_12893[(13)]);
var inst_12854 = (state_12893[(9)]);
var inst_12858__$1 = f.call(null,inst_12854);
var inst_12859__$1 = cljs.core._EQ_.call(null,inst_12858__$1,inst_12851);
var state_12893__$1 = (function (){var statearr_12910 = state_12893;
(statearr_12910[(11)] = inst_12858__$1);

(statearr_12910[(13)] = inst_12859__$1);

return statearr_12910;
})();
if(inst_12859__$1){
var statearr_12911_12937 = state_12893__$1;
(statearr_12911_12937[(1)] = (8));

} else {
var statearr_12912_12938 = state_12893__$1;
(statearr_12912_12938[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12894 === (14))){
var inst_12858 = (state_12893[(11)]);
var inst_12854 = (state_12893[(9)]);
var inst_12871 = (state_12893[(2)]);
var inst_12872 = [];
var inst_12873 = inst_12872.push(inst_12854);
var inst_12850 = inst_12872;
var inst_12851 = inst_12858;
var state_12893__$1 = (function (){var statearr_12913 = state_12893;
(statearr_12913[(7)] = inst_12851);

(statearr_12913[(14)] = inst_12873);

(statearr_12913[(8)] = inst_12850);

(statearr_12913[(15)] = inst_12871);

return statearr_12913;
})();
var statearr_12914_12939 = state_12893__$1;
(statearr_12914_12939[(2)] = null);

(statearr_12914_12939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12894 === (16))){
var state_12893__$1 = state_12893;
var statearr_12915_12940 = state_12893__$1;
(statearr_12915_12940[(2)] = null);

(statearr_12915_12940[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12894 === (10))){
var inst_12864 = (state_12893[(2)]);
var state_12893__$1 = state_12893;
if(cljs.core.truth_(inst_12864)){
var statearr_12916_12941 = state_12893__$1;
(statearr_12916_12941[(1)] = (11));

} else {
var statearr_12917_12942 = state_12893__$1;
(statearr_12917_12942[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12894 === (18))){
var inst_12883 = (state_12893[(2)]);
var state_12893__$1 = state_12893;
var statearr_12918_12943 = state_12893__$1;
(statearr_12918_12943[(2)] = inst_12883);

(statearr_12918_12943[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12894 === (8))){
var inst_12859 = (state_12893[(13)]);
var state_12893__$1 = state_12893;
var statearr_12919_12944 = state_12893__$1;
(statearr_12919_12944[(2)] = inst_12859);

(statearr_12919_12944[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10945__auto__ = null;
var cljs$core$async$state_machine__10945__auto____0 = (function (){
var statearr_12920 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12920[(0)] = cljs$core$async$state_machine__10945__auto__);

(statearr_12920[(1)] = (1));

return statearr_12920;
});
var cljs$core$async$state_machine__10945__auto____1 = (function (state_12893){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_12893);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e12921){var ex__10948__auto__ = e12921;
var statearr_12922_12945 = state_12893;
(statearr_12922_12945[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_12893[(4)]))){
var statearr_12923_12946 = state_12893;
(statearr_12923_12946[(1)] = cljs.core.first.call(null,(state_12893[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12947 = state_12893;
state_12893 = G__12947;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
cljs$core$async$state_machine__10945__auto__ = function(state_12893){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10945__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10945__auto____1.call(this,state_12893);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10945__auto____0;
cljs$core$async$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10945__auto____1;
return cljs$core$async$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_12924 = f__11019__auto__.call(null);
(statearr_12924[(6)] = c__11018__auto___12926);

return statearr_12924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

