// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
goog.require('goog.object');
goog.scope(function(){
cljs.source_map.goog$module$goog$object = goog.module.get('goog.object');
});
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.call(null,(function (m,p__5521){
var vec__5522 = p__5521;
var i = cljs.core.nth.call(null,vec__5522,(0),null);
var v = cljs.core.nth.call(null,vec__5522,(1),null);
return cljs.core.assoc.call(null,m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.call(null,(function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources.call(null,sources);
return (function (a,b){
return cljs.core.compare.call(null,sources__$1.call(null,a),sources__$1.call(null,b));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__5525 = seg;
var gcol = cljs.core.nth.call(null,vec__5525,(0),null);
var source = cljs.core.nth.call(null,vec__5525,(1),null);
var line = cljs.core.nth.call(null,vec__5525,(2),null);
var col = cljs.core.nth.call(null,vec__5525,(3),null);
var name = cljs.core.nth.call(null,vec__5525,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,seg));
if(cljs.core.truth_(temp__5804__auto__)){
var name__$1 = temp__5804__auto__;
return (cljs.source_map.goog$module$goog$object.get.call(null,source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__5528 = seg;
var gcol = cljs.core.nth.call(null,vec__5528,(0),null);
var source = cljs.core.nth.call(null,vec__5528,(1),null);
var line = cljs.core.nth.call(null,vec__5528,(2),null);
var col = cljs.core.nth.call(null,vec__5528,(3),null);
var name = cljs.core.nth.call(null,vec__5528,(4),null);
var vec__5531 = relseg;
var rgcol = cljs.core.nth.call(null,vec__5531,(0),null);
var rsource = cljs.core.nth.call(null,vec__5531,(1),null);
var rline = cljs.core.nth.call(null,vec__5531,(2),null);
var rcol = cljs.core.nth.call(null,vec__5531,(3),null);
var rname = cljs.core.nth.call(null,vec__5531,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__5045__auto__ = source;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__5045__auto__ = line;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__5045__auto__ = col;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta.call(null,nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__5534 = segmap;
var map__5534__$1 = cljs.core.__destructure_map.call(null,map__5534);
var gcol = cljs.core.get.call(null,map__5534__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__5534__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__5534__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__5534__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__5534__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.call(null,(function (m__$1){
return cljs.core.update_in.call(null,m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.call(null,(function (v){
return cljs.core.conj.call(null,v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__5536 = arguments.length;
switch (G__5536) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.call(null,cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by.call(null,cljs.source_map.source_compare.call(null,sources));
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__5540 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__5544 = cljs.core.next.call(null,segs__$1);
var G__5545 = nrelseg;
var G__5546 = cljs.source_map.update_reverse_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__5544;
relseg__$1 = G__5545;
result__$1 = G__5546;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__5540,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__5540,(1),null);
var G__5547 = (gline + (1));
var G__5548 = cljs.core.next.call(null,lines__$1);
var G__5549 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__5550 = result__$1;
gline = G__5547;
lines__$1 = G__5548;
relseg = G__5549;
result = G__5550;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__5552 = segmap;
var map__5552__$1 = cljs.core.__destructure_map.call(null,map__5552);
var gcol = cljs.core.get.call(null,map__5552__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__5552__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__5552__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__5552__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__5552__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.call(null,(function (p1__5551_SHARP_){
return cljs.core.conj.call(null,p1__5551_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__5554 = arguments.length;
switch (G__5554) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.call(null,cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__5558 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__5562 = cljs.core.next.call(null,segs__$1);
var G__5563 = nrelseg;
var G__5564 = cljs.source_map.update_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__5562;
relseg__$1 = G__5563;
result__$1 = G__5564;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__5558,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__5558,(1),null);
var G__5565 = (gline + (1));
var G__5566 = cljs.core.next.call(null,lines__$1);
var G__5567 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__5568 = result__$1;
gline = G__5565;
lines__$1 = G__5566;
relseg = G__5567;
result = G__5568;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.call(null,(function (segs,cols){
cljs.core.swap_BANG_.call(null,relseg,(function (p__5569){
var vec__5570 = p__5569;
var _ = cljs.core.nth.call(null,vec__5570,(0),null);
var source = cljs.core.nth.call(null,vec__5570,(1),null);
var line = cljs.core.nth.call(null,vec__5570,(2),null);
var col = cljs.core.nth.call(null,vec__5570,(3),null);
var name = cljs.core.nth.call(null,vec__5570,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.call(null,segs,cljs.core.reduce.call(null,(function (cols__$1,p__5573){
var vec__5574 = p__5573;
var gcol = cljs.core.nth.call(null,vec__5574,(0),null);
var sidx = cljs.core.nth.call(null,vec__5574,(1),null);
var line = cljs.core.nth.call(null,vec__5574,(2),null);
var col = cljs.core.nth.call(null,vec__5574,(3),null);
var name = cljs.core.nth.call(null,vec__5574,(4),null);
var seg = vec__5574;
var offset = cljs.core.map.call(null,cljs.core._,seg,cljs.core.deref.call(null,relseg));
cljs.core.swap_BANG_.call(null,relseg,(function (p__5577){
var vec__5578 = p__5577;
var _ = cljs.core.nth.call(null,vec__5578,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__5578,(1),null);
var ___$2 = cljs.core.nth.call(null,vec__5578,(2),null);
var ___$3 = cljs.core.nth.call(null,vec__5578,(3),null);
var lname = cljs.core.nth.call(null,vec__5578,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.call(null,cols__$1,cljs.source_map.base64_vlq.encode.call(null,offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.call(null,(0));
var preamble_lines = cljs.core.take.call(null,(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5802__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5802__auto__)){
var name = temp__5802__auto__;
var idx = (function (){var temp__5802__auto____$1 = cljs.core.get.call(null,cljs.core.deref.call(null,names__GT_idx),name);
if(cljs.core.truth_(temp__5802__auto____$1)){
var idx = temp__5802__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref.call(null,name_idx);
cljs.core.swap_BANG_.call(null,names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.call(null,name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.call(null,segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__5584 = cljs.core.seq.call(null,infos);
var chunk__5585 = null;
var count__5586 = (0);
var i__5587 = (0);
while(true){
if((i__5587 < count__5586)){
var info = cljs.core._nth.call(null,chunk__5585,i__5587);
var segv_5938 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_5939 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_5940 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_5939 > (lc_5940 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__5584,chunk__5585,count__5586,i__5587,segv_5938,gline_5939,lc_5940,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_5939 - (lc_5940 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_5938], null));
});})(seq__5584,chunk__5585,count__5586,i__5587,segv_5938,gline_5939,lc_5940,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__5584,chunk__5585,count__5586,i__5587,segv_5938,gline_5939,lc_5940,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5939], null),cljs.core.conj,segv_5938);
});})(seq__5584,chunk__5585,count__5586,i__5587,segv_5938,gline_5939,lc_5940,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__5941 = seq__5584;
var G__5942 = chunk__5585;
var G__5943 = count__5586;
var G__5944 = (i__5587 + (1));
seq__5584 = G__5941;
chunk__5585 = G__5942;
count__5586 = G__5943;
i__5587 = G__5944;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__5584);
if(temp__5804__auto__){
var seq__5584__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5584__$1)){
var c__5567__auto__ = cljs.core.chunk_first.call(null,seq__5584__$1);
var G__5945 = cljs.core.chunk_rest.call(null,seq__5584__$1);
var G__5946 = c__5567__auto__;
var G__5947 = cljs.core.count.call(null,c__5567__auto__);
var G__5948 = (0);
seq__5584 = G__5945;
chunk__5585 = G__5946;
count__5586 = G__5947;
i__5587 = G__5948;
continue;
} else {
var info = cljs.core.first.call(null,seq__5584__$1);
var segv_5949 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_5950 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_5951 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_5950 > (lc_5951 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__5584,chunk__5585,count__5586,i__5587,segv_5949,gline_5950,lc_5951,info,seq__5584__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_5950 - (lc_5951 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_5949], null));
});})(seq__5584,chunk__5585,count__5586,i__5587,segv_5949,gline_5950,lc_5951,info,seq__5584__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__5584,chunk__5585,count__5586,i__5587,segv_5949,gline_5950,lc_5951,info,seq__5584__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5950], null),cljs.core.conj,segv_5949);
});})(seq__5584,chunk__5585,count__5586,i__5587,segv_5949,gline_5950,lc_5951,info,seq__5584__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__5952 = cljs.core.next.call(null,seq__5584__$1);
var G__5953 = null;
var G__5954 = (0);
var G__5955 = (0);
seq__5584 = G__5952;
chunk__5585 = G__5953;
count__5586 = G__5954;
i__5587 = G__5955;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__5588_5956 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__5589_5957 = null;
var count__5590_5958 = (0);
var i__5591_5959 = (0);
while(true){
if((i__5591_5959 < count__5590_5958)){
var vec__5764_5960 = cljs.core._nth.call(null,chunk__5589_5957,i__5591_5959);
var source_idx_5961 = cljs.core.nth.call(null,vec__5764_5960,(0),null);
var vec__5767_5962 = cljs.core.nth.call(null,vec__5764_5960,(1),null);
var __5963 = cljs.core.nth.call(null,vec__5767_5962,(0),null);
var lines_5964__$1 = cljs.core.nth.call(null,vec__5767_5962,(1),null);
var seq__5770_5965 = cljs.core.seq.call(null,lines_5964__$1);
var chunk__5771_5966 = null;
var count__5772_5967 = (0);
var i__5773_5968 = (0);
while(true){
if((i__5773_5968 < count__5772_5967)){
var vec__5812_5969 = cljs.core._nth.call(null,chunk__5771_5966,i__5773_5968);
var line_5970 = cljs.core.nth.call(null,vec__5812_5969,(0),null);
var cols_5971 = cljs.core.nth.call(null,vec__5812_5969,(1),null);
var seq__5815_5972 = cljs.core.seq.call(null,cols_5971);
var chunk__5816_5973 = null;
var count__5817_5974 = (0);
var i__5818_5975 = (0);
while(true){
if((i__5818_5975 < count__5817_5974)){
var vec__5825_5976 = cljs.core._nth.call(null,chunk__5816_5973,i__5818_5975);
var col_5977 = cljs.core.nth.call(null,vec__5825_5976,(0),null);
var infos_5978 = cljs.core.nth.call(null,vec__5825_5976,(1),null);
encode_cols.call(null,infos_5978,source_idx_5961,line_5970,col_5977);


var G__5979 = seq__5815_5972;
var G__5980 = chunk__5816_5973;
var G__5981 = count__5817_5974;
var G__5982 = (i__5818_5975 + (1));
seq__5815_5972 = G__5979;
chunk__5816_5973 = G__5980;
count__5817_5974 = G__5981;
i__5818_5975 = G__5982;
continue;
} else {
var temp__5804__auto___5983 = cljs.core.seq.call(null,seq__5815_5972);
if(temp__5804__auto___5983){
var seq__5815_5984__$1 = temp__5804__auto___5983;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5815_5984__$1)){
var c__5567__auto___5985 = cljs.core.chunk_first.call(null,seq__5815_5984__$1);
var G__5986 = cljs.core.chunk_rest.call(null,seq__5815_5984__$1);
var G__5987 = c__5567__auto___5985;
var G__5988 = cljs.core.count.call(null,c__5567__auto___5985);
var G__5989 = (0);
seq__5815_5972 = G__5986;
chunk__5816_5973 = G__5987;
count__5817_5974 = G__5988;
i__5818_5975 = G__5989;
continue;
} else {
var vec__5828_5990 = cljs.core.first.call(null,seq__5815_5984__$1);
var col_5991 = cljs.core.nth.call(null,vec__5828_5990,(0),null);
var infos_5992 = cljs.core.nth.call(null,vec__5828_5990,(1),null);
encode_cols.call(null,infos_5992,source_idx_5961,line_5970,col_5991);


var G__5993 = cljs.core.next.call(null,seq__5815_5984__$1);
var G__5994 = null;
var G__5995 = (0);
var G__5996 = (0);
seq__5815_5972 = G__5993;
chunk__5816_5973 = G__5994;
count__5817_5974 = G__5995;
i__5818_5975 = G__5996;
continue;
}
} else {
}
}
break;
}


var G__5997 = seq__5770_5965;
var G__5998 = chunk__5771_5966;
var G__5999 = count__5772_5967;
var G__6000 = (i__5773_5968 + (1));
seq__5770_5965 = G__5997;
chunk__5771_5966 = G__5998;
count__5772_5967 = G__5999;
i__5773_5968 = G__6000;
continue;
} else {
var temp__5804__auto___6001 = cljs.core.seq.call(null,seq__5770_5965);
if(temp__5804__auto___6001){
var seq__5770_6002__$1 = temp__5804__auto___6001;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5770_6002__$1)){
var c__5567__auto___6003 = cljs.core.chunk_first.call(null,seq__5770_6002__$1);
var G__6004 = cljs.core.chunk_rest.call(null,seq__5770_6002__$1);
var G__6005 = c__5567__auto___6003;
var G__6006 = cljs.core.count.call(null,c__5567__auto___6003);
var G__6007 = (0);
seq__5770_5965 = G__6004;
chunk__5771_5966 = G__6005;
count__5772_5967 = G__6006;
i__5773_5968 = G__6007;
continue;
} else {
var vec__5831_6008 = cljs.core.first.call(null,seq__5770_6002__$1);
var line_6009 = cljs.core.nth.call(null,vec__5831_6008,(0),null);
var cols_6010 = cljs.core.nth.call(null,vec__5831_6008,(1),null);
var seq__5834_6011 = cljs.core.seq.call(null,cols_6010);
var chunk__5835_6012 = null;
var count__5836_6013 = (0);
var i__5837_6014 = (0);
while(true){
if((i__5837_6014 < count__5836_6013)){
var vec__5844_6015 = cljs.core._nth.call(null,chunk__5835_6012,i__5837_6014);
var col_6016 = cljs.core.nth.call(null,vec__5844_6015,(0),null);
var infos_6017 = cljs.core.nth.call(null,vec__5844_6015,(1),null);
encode_cols.call(null,infos_6017,source_idx_5961,line_6009,col_6016);


var G__6018 = seq__5834_6011;
var G__6019 = chunk__5835_6012;
var G__6020 = count__5836_6013;
var G__6021 = (i__5837_6014 + (1));
seq__5834_6011 = G__6018;
chunk__5835_6012 = G__6019;
count__5836_6013 = G__6020;
i__5837_6014 = G__6021;
continue;
} else {
var temp__5804__auto___6022__$1 = cljs.core.seq.call(null,seq__5834_6011);
if(temp__5804__auto___6022__$1){
var seq__5834_6023__$1 = temp__5804__auto___6022__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5834_6023__$1)){
var c__5567__auto___6024 = cljs.core.chunk_first.call(null,seq__5834_6023__$1);
var G__6025 = cljs.core.chunk_rest.call(null,seq__5834_6023__$1);
var G__6026 = c__5567__auto___6024;
var G__6027 = cljs.core.count.call(null,c__5567__auto___6024);
var G__6028 = (0);
seq__5834_6011 = G__6025;
chunk__5835_6012 = G__6026;
count__5836_6013 = G__6027;
i__5837_6014 = G__6028;
continue;
} else {
var vec__5847_6029 = cljs.core.first.call(null,seq__5834_6023__$1);
var col_6030 = cljs.core.nth.call(null,vec__5847_6029,(0),null);
var infos_6031 = cljs.core.nth.call(null,vec__5847_6029,(1),null);
encode_cols.call(null,infos_6031,source_idx_5961,line_6009,col_6030);


var G__6032 = cljs.core.next.call(null,seq__5834_6023__$1);
var G__6033 = null;
var G__6034 = (0);
var G__6035 = (0);
seq__5834_6011 = G__6032;
chunk__5835_6012 = G__6033;
count__5836_6013 = G__6034;
i__5837_6014 = G__6035;
continue;
}
} else {
}
}
break;
}


var G__6036 = cljs.core.next.call(null,seq__5770_6002__$1);
var G__6037 = null;
var G__6038 = (0);
var G__6039 = (0);
seq__5770_5965 = G__6036;
chunk__5771_5966 = G__6037;
count__5772_5967 = G__6038;
i__5773_5968 = G__6039;
continue;
}
} else {
}
}
break;
}


var G__6040 = seq__5588_5956;
var G__6041 = chunk__5589_5957;
var G__6042 = count__5590_5958;
var G__6043 = (i__5591_5959 + (1));
seq__5588_5956 = G__6040;
chunk__5589_5957 = G__6041;
count__5590_5958 = G__6042;
i__5591_5959 = G__6043;
continue;
} else {
var temp__5804__auto___6044 = cljs.core.seq.call(null,seq__5588_5956);
if(temp__5804__auto___6044){
var seq__5588_6045__$1 = temp__5804__auto___6044;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5588_6045__$1)){
var c__5567__auto___6046 = cljs.core.chunk_first.call(null,seq__5588_6045__$1);
var G__6047 = cljs.core.chunk_rest.call(null,seq__5588_6045__$1);
var G__6048 = c__5567__auto___6046;
var G__6049 = cljs.core.count.call(null,c__5567__auto___6046);
var G__6050 = (0);
seq__5588_5956 = G__6047;
chunk__5589_5957 = G__6048;
count__5590_5958 = G__6049;
i__5591_5959 = G__6050;
continue;
} else {
var vec__5850_6051 = cljs.core.first.call(null,seq__5588_6045__$1);
var source_idx_6052 = cljs.core.nth.call(null,vec__5850_6051,(0),null);
var vec__5853_6053 = cljs.core.nth.call(null,vec__5850_6051,(1),null);
var __6054 = cljs.core.nth.call(null,vec__5853_6053,(0),null);
var lines_6055__$1 = cljs.core.nth.call(null,vec__5853_6053,(1),null);
var seq__5856_6056 = cljs.core.seq.call(null,lines_6055__$1);
var chunk__5857_6057 = null;
var count__5858_6058 = (0);
var i__5859_6059 = (0);
while(true){
if((i__5859_6059 < count__5858_6058)){
var vec__5898_6060 = cljs.core._nth.call(null,chunk__5857_6057,i__5859_6059);
var line_6061 = cljs.core.nth.call(null,vec__5898_6060,(0),null);
var cols_6062 = cljs.core.nth.call(null,vec__5898_6060,(1),null);
var seq__5901_6063 = cljs.core.seq.call(null,cols_6062);
var chunk__5902_6064 = null;
var count__5903_6065 = (0);
var i__5904_6066 = (0);
while(true){
if((i__5904_6066 < count__5903_6065)){
var vec__5911_6067 = cljs.core._nth.call(null,chunk__5902_6064,i__5904_6066);
var col_6068 = cljs.core.nth.call(null,vec__5911_6067,(0),null);
var infos_6069 = cljs.core.nth.call(null,vec__5911_6067,(1),null);
encode_cols.call(null,infos_6069,source_idx_6052,line_6061,col_6068);


var G__6070 = seq__5901_6063;
var G__6071 = chunk__5902_6064;
var G__6072 = count__5903_6065;
var G__6073 = (i__5904_6066 + (1));
seq__5901_6063 = G__6070;
chunk__5902_6064 = G__6071;
count__5903_6065 = G__6072;
i__5904_6066 = G__6073;
continue;
} else {
var temp__5804__auto___6074__$1 = cljs.core.seq.call(null,seq__5901_6063);
if(temp__5804__auto___6074__$1){
var seq__5901_6075__$1 = temp__5804__auto___6074__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5901_6075__$1)){
var c__5567__auto___6076 = cljs.core.chunk_first.call(null,seq__5901_6075__$1);
var G__6077 = cljs.core.chunk_rest.call(null,seq__5901_6075__$1);
var G__6078 = c__5567__auto___6076;
var G__6079 = cljs.core.count.call(null,c__5567__auto___6076);
var G__6080 = (0);
seq__5901_6063 = G__6077;
chunk__5902_6064 = G__6078;
count__5903_6065 = G__6079;
i__5904_6066 = G__6080;
continue;
} else {
var vec__5914_6081 = cljs.core.first.call(null,seq__5901_6075__$1);
var col_6082 = cljs.core.nth.call(null,vec__5914_6081,(0),null);
var infos_6083 = cljs.core.nth.call(null,vec__5914_6081,(1),null);
encode_cols.call(null,infos_6083,source_idx_6052,line_6061,col_6082);


var G__6084 = cljs.core.next.call(null,seq__5901_6075__$1);
var G__6085 = null;
var G__6086 = (0);
var G__6087 = (0);
seq__5901_6063 = G__6084;
chunk__5902_6064 = G__6085;
count__5903_6065 = G__6086;
i__5904_6066 = G__6087;
continue;
}
} else {
}
}
break;
}


var G__6088 = seq__5856_6056;
var G__6089 = chunk__5857_6057;
var G__6090 = count__5858_6058;
var G__6091 = (i__5859_6059 + (1));
seq__5856_6056 = G__6088;
chunk__5857_6057 = G__6089;
count__5858_6058 = G__6090;
i__5859_6059 = G__6091;
continue;
} else {
var temp__5804__auto___6092__$1 = cljs.core.seq.call(null,seq__5856_6056);
if(temp__5804__auto___6092__$1){
var seq__5856_6093__$1 = temp__5804__auto___6092__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5856_6093__$1)){
var c__5567__auto___6094 = cljs.core.chunk_first.call(null,seq__5856_6093__$1);
var G__6095 = cljs.core.chunk_rest.call(null,seq__5856_6093__$1);
var G__6096 = c__5567__auto___6094;
var G__6097 = cljs.core.count.call(null,c__5567__auto___6094);
var G__6098 = (0);
seq__5856_6056 = G__6095;
chunk__5857_6057 = G__6096;
count__5858_6058 = G__6097;
i__5859_6059 = G__6098;
continue;
} else {
var vec__5917_6099 = cljs.core.first.call(null,seq__5856_6093__$1);
var line_6100 = cljs.core.nth.call(null,vec__5917_6099,(0),null);
var cols_6101 = cljs.core.nth.call(null,vec__5917_6099,(1),null);
var seq__5920_6102 = cljs.core.seq.call(null,cols_6101);
var chunk__5921_6103 = null;
var count__5922_6104 = (0);
var i__5923_6105 = (0);
while(true){
if((i__5923_6105 < count__5922_6104)){
var vec__5930_6106 = cljs.core._nth.call(null,chunk__5921_6103,i__5923_6105);
var col_6107 = cljs.core.nth.call(null,vec__5930_6106,(0),null);
var infos_6108 = cljs.core.nth.call(null,vec__5930_6106,(1),null);
encode_cols.call(null,infos_6108,source_idx_6052,line_6100,col_6107);


var G__6109 = seq__5920_6102;
var G__6110 = chunk__5921_6103;
var G__6111 = count__5922_6104;
var G__6112 = (i__5923_6105 + (1));
seq__5920_6102 = G__6109;
chunk__5921_6103 = G__6110;
count__5922_6104 = G__6111;
i__5923_6105 = G__6112;
continue;
} else {
var temp__5804__auto___6113__$2 = cljs.core.seq.call(null,seq__5920_6102);
if(temp__5804__auto___6113__$2){
var seq__5920_6114__$1 = temp__5804__auto___6113__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5920_6114__$1)){
var c__5567__auto___6115 = cljs.core.chunk_first.call(null,seq__5920_6114__$1);
var G__6116 = cljs.core.chunk_rest.call(null,seq__5920_6114__$1);
var G__6117 = c__5567__auto___6115;
var G__6118 = cljs.core.count.call(null,c__5567__auto___6115);
var G__6119 = (0);
seq__5920_6102 = G__6116;
chunk__5921_6103 = G__6117;
count__5922_6104 = G__6118;
i__5923_6105 = G__6119;
continue;
} else {
var vec__5933_6120 = cljs.core.first.call(null,seq__5920_6114__$1);
var col_6121 = cljs.core.nth.call(null,vec__5933_6120,(0),null);
var infos_6122 = cljs.core.nth.call(null,vec__5933_6120,(1),null);
encode_cols.call(null,infos_6122,source_idx_6052,line_6100,col_6121);


var G__6123 = cljs.core.next.call(null,seq__5920_6114__$1);
var G__6124 = null;
var G__6125 = (0);
var G__6126 = (0);
seq__5920_6102 = G__6123;
chunk__5921_6103 = G__6124;
count__5922_6104 = G__6125;
i__5923_6105 = G__6126;
continue;
}
} else {
}
}
break;
}


var G__6127 = cljs.core.next.call(null,seq__5856_6093__$1);
var G__6128 = null;
var G__6129 = (0);
var G__6130 = (0);
seq__5856_6056 = G__6127;
chunk__5857_6057 = G__6128;
count__5858_6058 = G__6129;
i__5859_6059 = G__6130;
continue;
}
} else {
}
}
break;
}


var G__6131 = cljs.core.next.call(null,seq__5588_6045__$1);
var G__6132 = null;
var G__6133 = (0);
var G__6134 = (0);
seq__5588_5956 = G__6131;
chunk__5589_5957 = G__6132;
count__5590_5958 = G__6133;
i__5591_5959 = G__6134;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__5936 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys.call(null,m);
var f = cljs.core.comp.call(null,((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__5581_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__5581_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__5582_SHARP_){
return cljs.core.last.call(null,clojure.string.split.call(null,p1__5582_SHARP_,/\//));
}));
return cljs.core.into_array.call(null,cljs.core.map.call(null,f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.call(null,";",cljs.core.map.call(null,(function (p1__5583_SHARP_){
return clojure.string.join.call(null,",",p1__5583_SHARP_);
}),cljs.source_map.lines__GT_segs.call(null,cljs.core.concat.call(null,preamble_lines,cljs.core.deref.call(null,lines))))), "names": cljs.core.into_array.call(null,cljs.core.map.call(null,clojure.set.map_invert.call(null,cljs.core.deref.call(null,names__GT_idx)),cljs.core.range.call(null,cljs.core.count.call(null,cljs.core.deref.call(null,names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__5937 = G__5936;
cljs.source_map.goog$module$goog$object.set.call(null,G__5937,"sourcesContent",cljs.core.into_array.call(null,new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__5937;
} else {
return G__5936;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq.call(null,cljs_map);
var new_lines = cljs.core.sorted_map.call(null);
while(true){
if(line_map_seq){
var vec__6135 = cljs.core.first.call(null,line_map_seq);
var line = cljs.core.nth.call(null,vec__6135,(0),null);
var col_map = cljs.core.nth.call(null,vec__6135,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq.call(null,col_map);
var new_cols = cljs.core.sorted_map.call(null);
while(true){
if(col_map_seq){
var vec__6138 = cljs.core.first.call(null,col_map_seq);
var col = cljs.core.nth.call(null,vec__6138,(0),null);
var infos = cljs.core.nth.call(null,vec__6138,(1),null);
var G__6143 = cljs.core.next.call(null,col_map_seq);
var G__6144 = cljs.core.assoc.call(null,new_cols,col,cljs.core.reduce.call(null,((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__6138,col,infos,vec__6135,line,col_map){
return (function (v,p__6141){
var map__6142 = p__6141;
var map__6142__$1 = cljs.core.__destructure_map.call(null,map__6142);
var gline = cljs.core.get.call(null,map__6142__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.call(null,map__6142__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.call(null,v,cljs.core.get_in.call(null,js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__6138,col,infos,vec__6135,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__6143;
new_cols = G__6144;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__6145 = cljs.core.next.call(null,line_map_seq);
var G__6146 = cljs.core.assoc.call(null,new_lines,line,new_cols);
line_map_seq = G__6145;
new_lines = G__6146;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.call(null,cljs.core.sorted_map.call(null));
var seq__6147_6355 = cljs.core.seq.call(null,reverse_map);
var chunk__6148_6356 = null;
var count__6149_6357 = (0);
var i__6150_6358 = (0);
while(true){
if((i__6150_6358 < count__6149_6357)){
var vec__6253_6359 = cljs.core._nth.call(null,chunk__6148_6356,i__6150_6358);
var line_6360 = cljs.core.nth.call(null,vec__6253_6359,(0),null);
var columns_6361 = cljs.core.nth.call(null,vec__6253_6359,(1),null);
var seq__6256_6362 = cljs.core.seq.call(null,columns_6361);
var chunk__6257_6363 = null;
var count__6258_6364 = (0);
var i__6259_6365 = (0);
while(true){
if((i__6259_6365 < count__6258_6364)){
var vec__6282_6366 = cljs.core._nth.call(null,chunk__6257_6363,i__6259_6365);
var column_6367 = cljs.core.nth.call(null,vec__6282_6366,(0),null);
var column_info_6368 = cljs.core.nth.call(null,vec__6282_6366,(1),null);
var seq__6285_6369 = cljs.core.seq.call(null,column_info_6368);
var chunk__6286_6370 = null;
var count__6287_6371 = (0);
var i__6288_6372 = (0);
while(true){
if((i__6288_6372 < count__6287_6371)){
var map__6291_6373 = cljs.core._nth.call(null,chunk__6286_6370,i__6288_6372);
var map__6291_6374__$1 = cljs.core.__destructure_map.call(null,map__6291_6373);
var gline_6375 = cljs.core.get.call(null,map__6291_6374__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6376 = cljs.core.get.call(null,map__6291_6374__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6377 = cljs.core.get.call(null,map__6291_6374__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6375], null),cljs.core.fnil.call(null,((function (seq__6285_6369,chunk__6286_6370,count__6287_6371,i__6288_6372,seq__6256_6362,chunk__6257_6363,count__6258_6364,i__6259_6365,seq__6147_6355,chunk__6148_6356,count__6149_6357,i__6150_6358,map__6291_6373,map__6291_6374__$1,gline_6375,gcol_6376,name_6377,vec__6282_6366,column_6367,column_info_6368,vec__6253_6359,line_6360,columns_6361,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6376], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6360,new cljs.core.Keyword(null,"col","col",-1959363084),column_6367,new cljs.core.Keyword(null,"name","name",1843675177),name_6377], null));
});})(seq__6285_6369,chunk__6286_6370,count__6287_6371,i__6288_6372,seq__6256_6362,chunk__6257_6363,count__6258_6364,i__6259_6365,seq__6147_6355,chunk__6148_6356,count__6149_6357,i__6150_6358,map__6291_6373,map__6291_6374__$1,gline_6375,gcol_6376,name_6377,vec__6282_6366,column_6367,column_info_6368,vec__6253_6359,line_6360,columns_6361,inverted))
,cljs.core.sorted_map.call(null)));


var G__6378 = seq__6285_6369;
var G__6379 = chunk__6286_6370;
var G__6380 = count__6287_6371;
var G__6381 = (i__6288_6372 + (1));
seq__6285_6369 = G__6378;
chunk__6286_6370 = G__6379;
count__6287_6371 = G__6380;
i__6288_6372 = G__6381;
continue;
} else {
var temp__5804__auto___6382 = cljs.core.seq.call(null,seq__6285_6369);
if(temp__5804__auto___6382){
var seq__6285_6383__$1 = temp__5804__auto___6382;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6285_6383__$1)){
var c__5567__auto___6384 = cljs.core.chunk_first.call(null,seq__6285_6383__$1);
var G__6385 = cljs.core.chunk_rest.call(null,seq__6285_6383__$1);
var G__6386 = c__5567__auto___6384;
var G__6387 = cljs.core.count.call(null,c__5567__auto___6384);
var G__6388 = (0);
seq__6285_6369 = G__6385;
chunk__6286_6370 = G__6386;
count__6287_6371 = G__6387;
i__6288_6372 = G__6388;
continue;
} else {
var map__6292_6389 = cljs.core.first.call(null,seq__6285_6383__$1);
var map__6292_6390__$1 = cljs.core.__destructure_map.call(null,map__6292_6389);
var gline_6391 = cljs.core.get.call(null,map__6292_6390__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6392 = cljs.core.get.call(null,map__6292_6390__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6393 = cljs.core.get.call(null,map__6292_6390__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6391], null),cljs.core.fnil.call(null,((function (seq__6285_6369,chunk__6286_6370,count__6287_6371,i__6288_6372,seq__6256_6362,chunk__6257_6363,count__6258_6364,i__6259_6365,seq__6147_6355,chunk__6148_6356,count__6149_6357,i__6150_6358,map__6292_6389,map__6292_6390__$1,gline_6391,gcol_6392,name_6393,seq__6285_6383__$1,temp__5804__auto___6382,vec__6282_6366,column_6367,column_info_6368,vec__6253_6359,line_6360,columns_6361,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6392], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6360,new cljs.core.Keyword(null,"col","col",-1959363084),column_6367,new cljs.core.Keyword(null,"name","name",1843675177),name_6393], null));
});})(seq__6285_6369,chunk__6286_6370,count__6287_6371,i__6288_6372,seq__6256_6362,chunk__6257_6363,count__6258_6364,i__6259_6365,seq__6147_6355,chunk__6148_6356,count__6149_6357,i__6150_6358,map__6292_6389,map__6292_6390__$1,gline_6391,gcol_6392,name_6393,seq__6285_6383__$1,temp__5804__auto___6382,vec__6282_6366,column_6367,column_info_6368,vec__6253_6359,line_6360,columns_6361,inverted))
,cljs.core.sorted_map.call(null)));


var G__6394 = cljs.core.next.call(null,seq__6285_6383__$1);
var G__6395 = null;
var G__6396 = (0);
var G__6397 = (0);
seq__6285_6369 = G__6394;
chunk__6286_6370 = G__6395;
count__6287_6371 = G__6396;
i__6288_6372 = G__6397;
continue;
}
} else {
}
}
break;
}


var G__6398 = seq__6256_6362;
var G__6399 = chunk__6257_6363;
var G__6400 = count__6258_6364;
var G__6401 = (i__6259_6365 + (1));
seq__6256_6362 = G__6398;
chunk__6257_6363 = G__6399;
count__6258_6364 = G__6400;
i__6259_6365 = G__6401;
continue;
} else {
var temp__5804__auto___6402 = cljs.core.seq.call(null,seq__6256_6362);
if(temp__5804__auto___6402){
var seq__6256_6403__$1 = temp__5804__auto___6402;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6256_6403__$1)){
var c__5567__auto___6404 = cljs.core.chunk_first.call(null,seq__6256_6403__$1);
var G__6405 = cljs.core.chunk_rest.call(null,seq__6256_6403__$1);
var G__6406 = c__5567__auto___6404;
var G__6407 = cljs.core.count.call(null,c__5567__auto___6404);
var G__6408 = (0);
seq__6256_6362 = G__6405;
chunk__6257_6363 = G__6406;
count__6258_6364 = G__6407;
i__6259_6365 = G__6408;
continue;
} else {
var vec__6293_6409 = cljs.core.first.call(null,seq__6256_6403__$1);
var column_6410 = cljs.core.nth.call(null,vec__6293_6409,(0),null);
var column_info_6411 = cljs.core.nth.call(null,vec__6293_6409,(1),null);
var seq__6296_6412 = cljs.core.seq.call(null,column_info_6411);
var chunk__6297_6413 = null;
var count__6298_6414 = (0);
var i__6299_6415 = (0);
while(true){
if((i__6299_6415 < count__6298_6414)){
var map__6302_6416 = cljs.core._nth.call(null,chunk__6297_6413,i__6299_6415);
var map__6302_6417__$1 = cljs.core.__destructure_map.call(null,map__6302_6416);
var gline_6418 = cljs.core.get.call(null,map__6302_6417__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6419 = cljs.core.get.call(null,map__6302_6417__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6420 = cljs.core.get.call(null,map__6302_6417__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6418], null),cljs.core.fnil.call(null,((function (seq__6296_6412,chunk__6297_6413,count__6298_6414,i__6299_6415,seq__6256_6362,chunk__6257_6363,count__6258_6364,i__6259_6365,seq__6147_6355,chunk__6148_6356,count__6149_6357,i__6150_6358,map__6302_6416,map__6302_6417__$1,gline_6418,gcol_6419,name_6420,vec__6293_6409,column_6410,column_info_6411,seq__6256_6403__$1,temp__5804__auto___6402,vec__6253_6359,line_6360,columns_6361,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6419], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6360,new cljs.core.Keyword(null,"col","col",-1959363084),column_6410,new cljs.core.Keyword(null,"name","name",1843675177),name_6420], null));
});})(seq__6296_6412,chunk__6297_6413,count__6298_6414,i__6299_6415,seq__6256_6362,chunk__6257_6363,count__6258_6364,i__6259_6365,seq__6147_6355,chunk__6148_6356,count__6149_6357,i__6150_6358,map__6302_6416,map__6302_6417__$1,gline_6418,gcol_6419,name_6420,vec__6293_6409,column_6410,column_info_6411,seq__6256_6403__$1,temp__5804__auto___6402,vec__6253_6359,line_6360,columns_6361,inverted))
,cljs.core.sorted_map.call(null)));


var G__6421 = seq__6296_6412;
var G__6422 = chunk__6297_6413;
var G__6423 = count__6298_6414;
var G__6424 = (i__6299_6415 + (1));
seq__6296_6412 = G__6421;
chunk__6297_6413 = G__6422;
count__6298_6414 = G__6423;
i__6299_6415 = G__6424;
continue;
} else {
var temp__5804__auto___6425__$1 = cljs.core.seq.call(null,seq__6296_6412);
if(temp__5804__auto___6425__$1){
var seq__6296_6426__$1 = temp__5804__auto___6425__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6296_6426__$1)){
var c__5567__auto___6427 = cljs.core.chunk_first.call(null,seq__6296_6426__$1);
var G__6428 = cljs.core.chunk_rest.call(null,seq__6296_6426__$1);
var G__6429 = c__5567__auto___6427;
var G__6430 = cljs.core.count.call(null,c__5567__auto___6427);
var G__6431 = (0);
seq__6296_6412 = G__6428;
chunk__6297_6413 = G__6429;
count__6298_6414 = G__6430;
i__6299_6415 = G__6431;
continue;
} else {
var map__6303_6432 = cljs.core.first.call(null,seq__6296_6426__$1);
var map__6303_6433__$1 = cljs.core.__destructure_map.call(null,map__6303_6432);
var gline_6434 = cljs.core.get.call(null,map__6303_6433__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6435 = cljs.core.get.call(null,map__6303_6433__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6436 = cljs.core.get.call(null,map__6303_6433__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6434], null),cljs.core.fnil.call(null,((function (seq__6296_6412,chunk__6297_6413,count__6298_6414,i__6299_6415,seq__6256_6362,chunk__6257_6363,count__6258_6364,i__6259_6365,seq__6147_6355,chunk__6148_6356,count__6149_6357,i__6150_6358,map__6303_6432,map__6303_6433__$1,gline_6434,gcol_6435,name_6436,seq__6296_6426__$1,temp__5804__auto___6425__$1,vec__6293_6409,column_6410,column_info_6411,seq__6256_6403__$1,temp__5804__auto___6402,vec__6253_6359,line_6360,columns_6361,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6435], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6360,new cljs.core.Keyword(null,"col","col",-1959363084),column_6410,new cljs.core.Keyword(null,"name","name",1843675177),name_6436], null));
});})(seq__6296_6412,chunk__6297_6413,count__6298_6414,i__6299_6415,seq__6256_6362,chunk__6257_6363,count__6258_6364,i__6259_6365,seq__6147_6355,chunk__6148_6356,count__6149_6357,i__6150_6358,map__6303_6432,map__6303_6433__$1,gline_6434,gcol_6435,name_6436,seq__6296_6426__$1,temp__5804__auto___6425__$1,vec__6293_6409,column_6410,column_info_6411,seq__6256_6403__$1,temp__5804__auto___6402,vec__6253_6359,line_6360,columns_6361,inverted))
,cljs.core.sorted_map.call(null)));


var G__6437 = cljs.core.next.call(null,seq__6296_6426__$1);
var G__6438 = null;
var G__6439 = (0);
var G__6440 = (0);
seq__6296_6412 = G__6437;
chunk__6297_6413 = G__6438;
count__6298_6414 = G__6439;
i__6299_6415 = G__6440;
continue;
}
} else {
}
}
break;
}


var G__6441 = cljs.core.next.call(null,seq__6256_6403__$1);
var G__6442 = null;
var G__6443 = (0);
var G__6444 = (0);
seq__6256_6362 = G__6441;
chunk__6257_6363 = G__6442;
count__6258_6364 = G__6443;
i__6259_6365 = G__6444;
continue;
}
} else {
}
}
break;
}


var G__6445 = seq__6147_6355;
var G__6446 = chunk__6148_6356;
var G__6447 = count__6149_6357;
var G__6448 = (i__6150_6358 + (1));
seq__6147_6355 = G__6445;
chunk__6148_6356 = G__6446;
count__6149_6357 = G__6447;
i__6150_6358 = G__6448;
continue;
} else {
var temp__5804__auto___6449 = cljs.core.seq.call(null,seq__6147_6355);
if(temp__5804__auto___6449){
var seq__6147_6450__$1 = temp__5804__auto___6449;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6147_6450__$1)){
var c__5567__auto___6451 = cljs.core.chunk_first.call(null,seq__6147_6450__$1);
var G__6452 = cljs.core.chunk_rest.call(null,seq__6147_6450__$1);
var G__6453 = c__5567__auto___6451;
var G__6454 = cljs.core.count.call(null,c__5567__auto___6451);
var G__6455 = (0);
seq__6147_6355 = G__6452;
chunk__6148_6356 = G__6453;
count__6149_6357 = G__6454;
i__6150_6358 = G__6455;
continue;
} else {
var vec__6304_6456 = cljs.core.first.call(null,seq__6147_6450__$1);
var line_6457 = cljs.core.nth.call(null,vec__6304_6456,(0),null);
var columns_6458 = cljs.core.nth.call(null,vec__6304_6456,(1),null);
var seq__6307_6459 = cljs.core.seq.call(null,columns_6458);
var chunk__6308_6460 = null;
var count__6309_6461 = (0);
var i__6310_6462 = (0);
while(true){
if((i__6310_6462 < count__6309_6461)){
var vec__6333_6463 = cljs.core._nth.call(null,chunk__6308_6460,i__6310_6462);
var column_6464 = cljs.core.nth.call(null,vec__6333_6463,(0),null);
var column_info_6465 = cljs.core.nth.call(null,vec__6333_6463,(1),null);
var seq__6336_6466 = cljs.core.seq.call(null,column_info_6465);
var chunk__6337_6467 = null;
var count__6338_6468 = (0);
var i__6339_6469 = (0);
while(true){
if((i__6339_6469 < count__6338_6468)){
var map__6342_6470 = cljs.core._nth.call(null,chunk__6337_6467,i__6339_6469);
var map__6342_6471__$1 = cljs.core.__destructure_map.call(null,map__6342_6470);
var gline_6472 = cljs.core.get.call(null,map__6342_6471__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6473 = cljs.core.get.call(null,map__6342_6471__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6474 = cljs.core.get.call(null,map__6342_6471__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6472], null),cljs.core.fnil.call(null,((function (seq__6336_6466,chunk__6337_6467,count__6338_6468,i__6339_6469,seq__6307_6459,chunk__6308_6460,count__6309_6461,i__6310_6462,seq__6147_6355,chunk__6148_6356,count__6149_6357,i__6150_6358,map__6342_6470,map__6342_6471__$1,gline_6472,gcol_6473,name_6474,vec__6333_6463,column_6464,column_info_6465,vec__6304_6456,line_6457,columns_6458,seq__6147_6450__$1,temp__5804__auto___6449,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6473], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6457,new cljs.core.Keyword(null,"col","col",-1959363084),column_6464,new cljs.core.Keyword(null,"name","name",1843675177),name_6474], null));
});})(seq__6336_6466,chunk__6337_6467,count__6338_6468,i__6339_6469,seq__6307_6459,chunk__6308_6460,count__6309_6461,i__6310_6462,seq__6147_6355,chunk__6148_6356,count__6149_6357,i__6150_6358,map__6342_6470,map__6342_6471__$1,gline_6472,gcol_6473,name_6474,vec__6333_6463,column_6464,column_info_6465,vec__6304_6456,line_6457,columns_6458,seq__6147_6450__$1,temp__5804__auto___6449,inverted))
,cljs.core.sorted_map.call(null)));


var G__6475 = seq__6336_6466;
var G__6476 = chunk__6337_6467;
var G__6477 = count__6338_6468;
var G__6478 = (i__6339_6469 + (1));
seq__6336_6466 = G__6475;
chunk__6337_6467 = G__6476;
count__6338_6468 = G__6477;
i__6339_6469 = G__6478;
continue;
} else {
var temp__5804__auto___6479__$1 = cljs.core.seq.call(null,seq__6336_6466);
if(temp__5804__auto___6479__$1){
var seq__6336_6480__$1 = temp__5804__auto___6479__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6336_6480__$1)){
var c__5567__auto___6481 = cljs.core.chunk_first.call(null,seq__6336_6480__$1);
var G__6482 = cljs.core.chunk_rest.call(null,seq__6336_6480__$1);
var G__6483 = c__5567__auto___6481;
var G__6484 = cljs.core.count.call(null,c__5567__auto___6481);
var G__6485 = (0);
seq__6336_6466 = G__6482;
chunk__6337_6467 = G__6483;
count__6338_6468 = G__6484;
i__6339_6469 = G__6485;
continue;
} else {
var map__6343_6486 = cljs.core.first.call(null,seq__6336_6480__$1);
var map__6343_6487__$1 = cljs.core.__destructure_map.call(null,map__6343_6486);
var gline_6488 = cljs.core.get.call(null,map__6343_6487__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6489 = cljs.core.get.call(null,map__6343_6487__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6490 = cljs.core.get.call(null,map__6343_6487__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6488], null),cljs.core.fnil.call(null,((function (seq__6336_6466,chunk__6337_6467,count__6338_6468,i__6339_6469,seq__6307_6459,chunk__6308_6460,count__6309_6461,i__6310_6462,seq__6147_6355,chunk__6148_6356,count__6149_6357,i__6150_6358,map__6343_6486,map__6343_6487__$1,gline_6488,gcol_6489,name_6490,seq__6336_6480__$1,temp__5804__auto___6479__$1,vec__6333_6463,column_6464,column_info_6465,vec__6304_6456,line_6457,columns_6458,seq__6147_6450__$1,temp__5804__auto___6449,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6489], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6457,new cljs.core.Keyword(null,"col","col",-1959363084),column_6464,new cljs.core.Keyword(null,"name","name",1843675177),name_6490], null));
});})(seq__6336_6466,chunk__6337_6467,count__6338_6468,i__6339_6469,seq__6307_6459,chunk__6308_6460,count__6309_6461,i__6310_6462,seq__6147_6355,chunk__6148_6356,count__6149_6357,i__6150_6358,map__6343_6486,map__6343_6487__$1,gline_6488,gcol_6489,name_6490,seq__6336_6480__$1,temp__5804__auto___6479__$1,vec__6333_6463,column_6464,column_info_6465,vec__6304_6456,line_6457,columns_6458,seq__6147_6450__$1,temp__5804__auto___6449,inverted))
,cljs.core.sorted_map.call(null)));


var G__6491 = cljs.core.next.call(null,seq__6336_6480__$1);
var G__6492 = null;
var G__6493 = (0);
var G__6494 = (0);
seq__6336_6466 = G__6491;
chunk__6337_6467 = G__6492;
count__6338_6468 = G__6493;
i__6339_6469 = G__6494;
continue;
}
} else {
}
}
break;
}


var G__6495 = seq__6307_6459;
var G__6496 = chunk__6308_6460;
var G__6497 = count__6309_6461;
var G__6498 = (i__6310_6462 + (1));
seq__6307_6459 = G__6495;
chunk__6308_6460 = G__6496;
count__6309_6461 = G__6497;
i__6310_6462 = G__6498;
continue;
} else {
var temp__5804__auto___6499__$1 = cljs.core.seq.call(null,seq__6307_6459);
if(temp__5804__auto___6499__$1){
var seq__6307_6500__$1 = temp__5804__auto___6499__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6307_6500__$1)){
var c__5567__auto___6501 = cljs.core.chunk_first.call(null,seq__6307_6500__$1);
var G__6502 = cljs.core.chunk_rest.call(null,seq__6307_6500__$1);
var G__6503 = c__5567__auto___6501;
var G__6504 = cljs.core.count.call(null,c__5567__auto___6501);
var G__6505 = (0);
seq__6307_6459 = G__6502;
chunk__6308_6460 = G__6503;
count__6309_6461 = G__6504;
i__6310_6462 = G__6505;
continue;
} else {
var vec__6344_6506 = cljs.core.first.call(null,seq__6307_6500__$1);
var column_6507 = cljs.core.nth.call(null,vec__6344_6506,(0),null);
var column_info_6508 = cljs.core.nth.call(null,vec__6344_6506,(1),null);
var seq__6347_6509 = cljs.core.seq.call(null,column_info_6508);
var chunk__6348_6510 = null;
var count__6349_6511 = (0);
var i__6350_6512 = (0);
while(true){
if((i__6350_6512 < count__6349_6511)){
var map__6353_6513 = cljs.core._nth.call(null,chunk__6348_6510,i__6350_6512);
var map__6353_6514__$1 = cljs.core.__destructure_map.call(null,map__6353_6513);
var gline_6515 = cljs.core.get.call(null,map__6353_6514__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6516 = cljs.core.get.call(null,map__6353_6514__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6517 = cljs.core.get.call(null,map__6353_6514__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6515], null),cljs.core.fnil.call(null,((function (seq__6347_6509,chunk__6348_6510,count__6349_6511,i__6350_6512,seq__6307_6459,chunk__6308_6460,count__6309_6461,i__6310_6462,seq__6147_6355,chunk__6148_6356,count__6149_6357,i__6150_6358,map__6353_6513,map__6353_6514__$1,gline_6515,gcol_6516,name_6517,vec__6344_6506,column_6507,column_info_6508,seq__6307_6500__$1,temp__5804__auto___6499__$1,vec__6304_6456,line_6457,columns_6458,seq__6147_6450__$1,temp__5804__auto___6449,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6516], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6457,new cljs.core.Keyword(null,"col","col",-1959363084),column_6507,new cljs.core.Keyword(null,"name","name",1843675177),name_6517], null));
});})(seq__6347_6509,chunk__6348_6510,count__6349_6511,i__6350_6512,seq__6307_6459,chunk__6308_6460,count__6309_6461,i__6310_6462,seq__6147_6355,chunk__6148_6356,count__6149_6357,i__6150_6358,map__6353_6513,map__6353_6514__$1,gline_6515,gcol_6516,name_6517,vec__6344_6506,column_6507,column_info_6508,seq__6307_6500__$1,temp__5804__auto___6499__$1,vec__6304_6456,line_6457,columns_6458,seq__6147_6450__$1,temp__5804__auto___6449,inverted))
,cljs.core.sorted_map.call(null)));


var G__6518 = seq__6347_6509;
var G__6519 = chunk__6348_6510;
var G__6520 = count__6349_6511;
var G__6521 = (i__6350_6512 + (1));
seq__6347_6509 = G__6518;
chunk__6348_6510 = G__6519;
count__6349_6511 = G__6520;
i__6350_6512 = G__6521;
continue;
} else {
var temp__5804__auto___6522__$2 = cljs.core.seq.call(null,seq__6347_6509);
if(temp__5804__auto___6522__$2){
var seq__6347_6523__$1 = temp__5804__auto___6522__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6347_6523__$1)){
var c__5567__auto___6524 = cljs.core.chunk_first.call(null,seq__6347_6523__$1);
var G__6525 = cljs.core.chunk_rest.call(null,seq__6347_6523__$1);
var G__6526 = c__5567__auto___6524;
var G__6527 = cljs.core.count.call(null,c__5567__auto___6524);
var G__6528 = (0);
seq__6347_6509 = G__6525;
chunk__6348_6510 = G__6526;
count__6349_6511 = G__6527;
i__6350_6512 = G__6528;
continue;
} else {
var map__6354_6529 = cljs.core.first.call(null,seq__6347_6523__$1);
var map__6354_6530__$1 = cljs.core.__destructure_map.call(null,map__6354_6529);
var gline_6531 = cljs.core.get.call(null,map__6354_6530__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6532 = cljs.core.get.call(null,map__6354_6530__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6533 = cljs.core.get.call(null,map__6354_6530__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6531], null),cljs.core.fnil.call(null,((function (seq__6347_6509,chunk__6348_6510,count__6349_6511,i__6350_6512,seq__6307_6459,chunk__6308_6460,count__6309_6461,i__6310_6462,seq__6147_6355,chunk__6148_6356,count__6149_6357,i__6150_6358,map__6354_6529,map__6354_6530__$1,gline_6531,gcol_6532,name_6533,seq__6347_6523__$1,temp__5804__auto___6522__$2,vec__6344_6506,column_6507,column_info_6508,seq__6307_6500__$1,temp__5804__auto___6499__$1,vec__6304_6456,line_6457,columns_6458,seq__6147_6450__$1,temp__5804__auto___6449,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6532], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6457,new cljs.core.Keyword(null,"col","col",-1959363084),column_6507,new cljs.core.Keyword(null,"name","name",1843675177),name_6533], null));
});})(seq__6347_6509,chunk__6348_6510,count__6349_6511,i__6350_6512,seq__6307_6459,chunk__6308_6460,count__6309_6461,i__6310_6462,seq__6147_6355,chunk__6148_6356,count__6149_6357,i__6150_6358,map__6354_6529,map__6354_6530__$1,gline_6531,gcol_6532,name_6533,seq__6347_6523__$1,temp__5804__auto___6522__$2,vec__6344_6506,column_6507,column_info_6508,seq__6307_6500__$1,temp__5804__auto___6499__$1,vec__6304_6456,line_6457,columns_6458,seq__6147_6450__$1,temp__5804__auto___6449,inverted))
,cljs.core.sorted_map.call(null)));


var G__6534 = cljs.core.next.call(null,seq__6347_6523__$1);
var G__6535 = null;
var G__6536 = (0);
var G__6537 = (0);
seq__6347_6509 = G__6534;
chunk__6348_6510 = G__6535;
count__6349_6511 = G__6536;
i__6350_6512 = G__6537;
continue;
}
} else {
}
}
break;
}


var G__6538 = cljs.core.next.call(null,seq__6307_6500__$1);
var G__6539 = null;
var G__6540 = (0);
var G__6541 = (0);
seq__6307_6459 = G__6538;
chunk__6308_6460 = G__6539;
count__6309_6461 = G__6540;
i__6310_6462 = G__6541;
continue;
}
} else {
}
}
break;
}


var G__6542 = cljs.core.next.call(null,seq__6147_6450__$1);
var G__6543 = null;
var G__6544 = (0);
var G__6545 = (0);
seq__6147_6355 = G__6542;
chunk__6148_6356 = G__6543;
count__6149_6357 = G__6544;
i__6150_6358 = G__6545;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,inverted);
});
