// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__80674 = arguments.length;
switch (G__80674) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.call(null);
var c__11018__auto___80713 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_80695){
var state_val_80696 = (state_80695[(1)]);
if((state_val_80696 === (1))){
var state_80695__$1 = state_80695;
var statearr_80697_80714 = state_80695__$1;
(statearr_80697_80714[(2)] = null);

(statearr_80697_80714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80696 === (2))){
var _ = (function (){var statearr_80698 = state_80695;
(statearr_80698[(4)] = cljs.core.cons.call(null,(5),(state_80695[(4)])));

return statearr_80698;
})();
var inst_80681 = fluree.db.session.db.call(null,conn,ledger,null);
var state_80695__$1 = state_80695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80695__$1,(7),inst_80681);
} else {
if((state_val_80696 === (3))){
var inst_80691 = (state_80695[(2)]);
var inst_80692 = cljs.core.async.put_BANG_.call(null,pc,inst_80691);
var inst_80693 = cljs.core.async.close_BANG_.call(null,pc);
var state_80695__$1 = (function (){var statearr_80700 = state_80695;
(statearr_80700[(7)] = inst_80692);

return statearr_80700;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80695__$1,inst_80693);
} else {
if((state_val_80696 === (4))){
var inst_80675 = (state_80695[(2)]);
var state_80695__$1 = state_80695;
var statearr_80701_80715 = state_80695__$1;
(statearr_80701_80715[(2)] = inst_80675);

(statearr_80701_80715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80696 === (5))){
var _ = (function (){var statearr_80702 = state_80695;
(statearr_80702[(4)] = cljs.core.rest.call(null,(state_80695[(4)])));

return statearr_80702;
})();
var state_80695__$1 = state_80695;
var ex80699 = (state_80695__$1[(2)]);
var statearr_80703_80716 = state_80695__$1;
(statearr_80703_80716[(5)] = ex80699);


var statearr_80704_80717 = state_80695__$1;
(statearr_80704_80717[(1)] = (4));

(statearr_80704_80717[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80696 === (6))){
var inst_80687 = (state_80695[(2)]);
var inst_80688 = fluree.db.util.async.throw_err.call(null,inst_80687);
var _ = (function (){var statearr_80705 = state_80695;
(statearr_80705[(4)] = cljs.core.rest.call(null,(state_80695[(4)])));

return statearr_80705;
})();
var state_80695__$1 = state_80695;
var statearr_80706_80718 = state_80695__$1;
(statearr_80706_80718[(2)] = inst_80688);

(statearr_80706_80718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80696 === (7))){
var inst_80683 = (state_80695[(2)]);
var inst_80684 = fluree.db.util.async.throw_err.call(null,inst_80683);
var inst_80685 = fluree.db.time_travel.as_of_block.call(null,inst_80684,block);
var state_80695__$1 = state_80695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80695__$1,(6),inst_80685);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__10945__auto__ = null;
var fluree$db$api$ledger$state_machine__10945__auto____0 = (function (){
var statearr_80707 = [null,null,null,null,null,null,null,null];
(statearr_80707[(0)] = fluree$db$api$ledger$state_machine__10945__auto__);

(statearr_80707[(1)] = (1));

return statearr_80707;
});
var fluree$db$api$ledger$state_machine__10945__auto____1 = (function (state_80695){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_80695);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e80708){var ex__10948__auto__ = e80708;
var statearr_80709_80719 = state_80695;
(statearr_80709_80719[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_80695[(4)]))){
var statearr_80710_80720 = state_80695;
(statearr_80710_80720[(1)] = cljs.core.first.call(null,(state_80695[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80721 = state_80695;
state_80695 = G__80721;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__10945__auto__ = function(state_80695){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__10945__auto____1.call(this,state_80695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__10945__auto____0;
fluree$db$api$ledger$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__10945__auto____1;
return fluree$db$api$ledger$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_80711 = f__11019__auto__.call(null);
(statearr_80711[(6)] = c__11018__auto___80713);

return statearr_80711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return pc;
} else {
return fluree.db.session.db.call(null,conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t.call(null,db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_80762){
var state_val_80763 = (state_80762[(1)]);
if((state_val_80763 === (7))){
var inst_80731 = cljs.core._EQ_.call(null,(0),auth);
var state_80762__$1 = state_80762;
if(inst_80731){
var statearr_80764_80795 = state_80762__$1;
(statearr_80764_80795[(1)] = (9));

} else {
var statearr_80765_80796 = state_80762__$1;
(statearr_80765_80796[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80763 === (1))){
var state_80762__$1 = state_80762;
var statearr_80766_80797 = state_80762__$1;
(statearr_80766_80797[(2)] = null);

(statearr_80766_80797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80763 === (4))){
var inst_80722 = (state_80762[(2)]);
var state_80762__$1 = state_80762;
var statearr_80767_80798 = state_80762__$1;
(statearr_80767_80798[(2)] = inst_80722);

(statearr_80767_80798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80763 === (15))){
var inst_80739 = (state_80762[(7)]);
var inst_80738 = (state_80762[(2)]);
var inst_80739__$1 = fluree.db.util.async.throw_err.call(null,inst_80738);
var state_80762__$1 = (function (){var statearr_80768 = state_80762;
(statearr_80768[(7)] = inst_80739__$1);

return statearr_80768;
})();
if(cljs.core.truth_(inst_80739__$1)){
var statearr_80769_80799 = state_80762__$1;
(statearr_80769_80799[(1)] = (16));

} else {
var statearr_80770_80800 = state_80762__$1;
(statearr_80770_80800[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80763 === (13))){
var state_80762__$1 = state_80762;
var statearr_80771_80801 = state_80762__$1;
(statearr_80771_80801[(2)] = null);

(statearr_80771_80801[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80763 === (6))){
var state_80762__$1 = state_80762;
var statearr_80772_80802 = state_80762__$1;
(statearr_80772_80802[(2)] = db);

(statearr_80772_80802[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80763 === (17))){
var inst_80743 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_80744 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_80745 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_80746 = cljs.core.PersistentHashMap.fromArrays(inst_80744,inst_80745);
var inst_80747 = cljs.core.ex_info.call(null,inst_80743,inst_80746);
var inst_80748 = (function(){throw inst_80747})();
var state_80762__$1 = state_80762;
var statearr_80773_80803 = state_80762__$1;
(statearr_80773_80803[(2)] = inst_80748);

(statearr_80773_80803[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80763 === (3))){
var inst_80760 = (state_80762[(2)]);
var state_80762__$1 = state_80762;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80762__$1,inst_80760);
} else {
if((state_val_80763 === (12))){
var inst_80736 = fluree.db.dbproto._subid.call(null,db,auth);
var state_80762__$1 = state_80762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80762__$1,(15),inst_80736);
} else {
if((state_val_80763 === (2))){
var _ = (function (){var statearr_80774 = state_80762;
(statearr_80774[(4)] = cljs.core.cons.call(null,(5),(state_80762[(4)])));

return statearr_80774;
})();
var inst_80728 = cljs.core.not.call(null,auth);
var state_80762__$1 = state_80762;
if(inst_80728){
var statearr_80775_80804 = state_80762__$1;
(statearr_80775_80804[(1)] = (6));

} else {
var statearr_80776_80805 = state_80762__$1;
(statearr_80776_80805[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80763 === (11))){
var inst_80755 = (state_80762[(2)]);
var state_80762__$1 = state_80762;
var statearr_80778_80806 = state_80762__$1;
(statearr_80778_80806[(2)] = inst_80755);

(statearr_80778_80806[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80763 === (9))){
var inst_80733 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_80762__$1 = state_80762;
var statearr_80779_80807 = state_80762__$1;
(statearr_80779_80807[(2)] = inst_80733);

(statearr_80779_80807[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80763 === (5))){
var _ = (function (){var statearr_80780 = state_80762;
(statearr_80780[(4)] = cljs.core.rest.call(null,(state_80762[(4)])));

return statearr_80780;
})();
var state_80762__$1 = state_80762;
var ex80777 = (state_80762__$1[(2)]);
var statearr_80781_80808 = state_80762__$1;
(statearr_80781_80808[(5)] = ex80777);


if((ex80777 instanceof Error)){
var statearr_80782_80809 = state_80762__$1;
(statearr_80782_80809[(1)] = (4));

(statearr_80782_80809[(5)] = null);

} else {
throw ex80777;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80763 === (14))){
var inst_80753 = (state_80762[(2)]);
var state_80762__$1 = state_80762;
var statearr_80783_80810 = state_80762__$1;
(statearr_80783_80810[(2)] = inst_80753);

(statearr_80783_80810[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80763 === (16))){
var inst_80739 = (state_80762[(7)]);
var inst_80741 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_80739);
var state_80762__$1 = state_80762;
var statearr_80784_80811 = state_80762__$1;
(statearr_80784_80811[(2)] = inst_80741);

(statearr_80784_80811[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80763 === (10))){
var state_80762__$1 = state_80762;
var statearr_80785_80812 = state_80762__$1;
(statearr_80785_80812[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80763 === (18))){
var inst_80750 = (state_80762[(2)]);
var state_80762__$1 = state_80762;
var statearr_80787_80813 = state_80762__$1;
(statearr_80787_80813[(2)] = inst_80750);

(statearr_80787_80813[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80763 === (8))){
var inst_80757 = (state_80762[(2)]);
var _ = (function (){var statearr_80788 = state_80762;
(statearr_80788[(4)] = cljs.core.rest.call(null,(state_80762[(4)])));

return statearr_80788;
})();
var state_80762__$1 = state_80762;
var statearr_80789_80814 = state_80762__$1;
(statearr_80789_80814[(2)] = inst_80757);

(statearr_80789_80814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10945__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10945__auto____0 = (function (){
var statearr_80790 = [null,null,null,null,null,null,null,null];
(statearr_80790[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10945__auto__);

(statearr_80790[(1)] = (1));

return statearr_80790;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10945__auto____1 = (function (state_80762){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_80762);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e80791){var ex__10948__auto__ = e80791;
var statearr_80792_80815 = state_80762;
(statearr_80792_80815[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_80762[(4)]))){
var statearr_80793_80816 = state_80762;
(statearr_80793_80816[(1)] = cljs.core.first.call(null,(state_80762[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80817 = state_80762;
state_80762 = G__80817;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10945__auto__ = function(state_80762){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10945__auto____1.call(this,state_80762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10945__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10945__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_80794 = f__11019__auto__.call(null);
(statearr_80794[(6)] = c__11018__auto__);

return statearr_80794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_80881){
var state_val_80882 = (state_80881[(1)]);
if((state_val_80882 === (7))){
var inst_80827 = cljs.core._EQ_.call(null,(0),auth);
var state_80881__$1 = state_80881;
if(inst_80827){
var statearr_80883_80932 = state_80881__$1;
(statearr_80883_80932[(1)] = (9));

} else {
var statearr_80884_80933 = state_80881__$1;
(statearr_80884_80933[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (20))){
var inst_80851 = (state_80881[(7)]);
var state_80881__$1 = state_80881;
if(cljs.core.truth_(inst_80851)){
var statearr_80885_80934 = state_80881__$1;
(statearr_80885_80934[(1)] = (22));

} else {
var statearr_80886_80935 = state_80881__$1;
(statearr_80886_80935[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (27))){
var state_80881__$1 = state_80881;
var statearr_80887_80936 = state_80881__$1;
(statearr_80887_80936[(2)] = null);

(statearr_80887_80936[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (1))){
var state_80881__$1 = state_80881;
var statearr_80888_80937 = state_80881__$1;
(statearr_80888_80937[(2)] = null);

(statearr_80888_80937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (24))){
var inst_80865 = (state_80881[(2)]);
var state_80881__$1 = state_80881;
var statearr_80889_80938 = state_80881__$1;
(statearr_80889_80938[(2)] = inst_80865);

(statearr_80889_80938[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (4))){
var inst_80818 = (state_80881[(2)]);
var state_80881__$1 = state_80881;
var statearr_80890_80939 = state_80881__$1;
(statearr_80890_80939[(2)] = inst_80818);

(statearr_80890_80939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (15))){
var inst_80834 = (state_80881[(8)]);
var inst_80833 = (state_80881[(2)]);
var inst_80834__$1 = fluree.db.util.async.throw_err.call(null,inst_80833);
var state_80881__$1 = (function (){var statearr_80891 = state_80881;
(statearr_80891[(8)] = inst_80834__$1);

return statearr_80891;
})();
if(cljs.core.truth_(inst_80834__$1)){
var statearr_80892_80940 = state_80881__$1;
(statearr_80892_80940[(1)] = (16));

} else {
var statearr_80893_80941 = state_80881__$1;
(statearr_80893_80941[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (21))){
var inst_80867 = (state_80881[(9)]);
var inst_80867__$1 = (state_80881[(2)]);
var state_80881__$1 = (function (){var statearr_80894 = state_80881;
(statearr_80894[(9)] = inst_80867__$1);

return statearr_80894;
})();
if(cljs.core.truth_(inst_80867__$1)){
var statearr_80895_80942 = state_80881__$1;
(statearr_80895_80942[(1)] = (29));

} else {
var statearr_80896_80943 = state_80881__$1;
(statearr_80896_80943[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (31))){
var inst_80867 = (state_80881[(9)]);
var inst_80851 = (state_80881[(7)]);
var inst_80875 = (state_80881[(2)]);
var inst_80876 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_80851,new cljs.core.Keyword(null,"roles","roles",143379530),inst_80867,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_80875);
var _ = (function (){var statearr_80897 = state_80881;
(statearr_80897[(4)] = cljs.core.rest.call(null,(state_80881[(4)])));

return statearr_80897;
})();
var state_80881__$1 = state_80881;
var statearr_80898_80944 = state_80881__$1;
(statearr_80898_80944[(2)] = inst_80876);

(statearr_80898_80944[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (32))){
var inst_80871 = (state_80881[(2)]);
var inst_80872 = fluree.db.util.async.throw_err.call(null,inst_80871);
var state_80881__$1 = state_80881;
var statearr_80899_80945 = state_80881__$1;
(statearr_80899_80945[(2)] = inst_80872);

(statearr_80899_80945[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (13))){
var state_80881__$1 = state_80881;
var statearr_80900_80946 = state_80881__$1;
(statearr_80900_80946[(2)] = null);

(statearr_80900_80946[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (22))){
var inst_80851 = (state_80881[(7)]);
var inst_80855 = fluree.db.auth.roles.call(null,db,inst_80851);
var state_80881__$1 = state_80881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80881__$1,(25),inst_80855);
} else {
if((state_val_80882 === (29))){
var inst_80867 = (state_80881[(9)]);
var inst_80869 = fluree.db.permissions.permission_map.call(null,db,inst_80867,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_80881__$1 = state_80881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80881__$1,(32),inst_80869);
} else {
if((state_val_80882 === (6))){
var state_80881__$1 = state_80881;
var statearr_80901_80947 = state_80881__$1;
(statearr_80901_80947[(2)] = null);

(statearr_80901_80947[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (28))){
var inst_80863 = (state_80881[(2)]);
var state_80881__$1 = state_80881;
var statearr_80902_80948 = state_80881__$1;
(statearr_80902_80948[(2)] = inst_80863);

(statearr_80902_80948[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (25))){
var inst_80857 = (state_80881[(2)]);
var inst_80858 = fluree.db.util.async.throw_err.call(null,inst_80857);
var state_80881__$1 = state_80881;
var statearr_80903_80949 = state_80881__$1;
(statearr_80903_80949[(2)] = inst_80858);

(statearr_80903_80949[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (17))){
var inst_80837 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_80838 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_80839 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_80840 = cljs.core.PersistentHashMap.fromArrays(inst_80838,inst_80839);
var inst_80841 = cljs.core.ex_info.call(null,inst_80837,inst_80840);
var inst_80842 = (function(){throw inst_80841})();
var state_80881__$1 = state_80881;
var statearr_80904_80950 = state_80881__$1;
(statearr_80904_80950[(2)] = inst_80842);

(statearr_80904_80950[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (3))){
var inst_80879 = (state_80881[(2)]);
var state_80881__$1 = state_80881;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80881__$1,inst_80879);
} else {
if((state_val_80882 === (12))){
var inst_80831 = fluree.db.dbproto._subid.call(null,db,auth);
var state_80881__$1 = state_80881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80881__$1,(15),inst_80831);
} else {
if((state_val_80882 === (2))){
var _ = (function (){var statearr_80905 = state_80881;
(statearr_80905[(4)] = cljs.core.cons.call(null,(5),(state_80881[(4)])));

return statearr_80905;
})();
var inst_80824 = (auth == null);
var state_80881__$1 = state_80881;
if(cljs.core.truth_(inst_80824)){
var statearr_80906_80951 = state_80881__$1;
(statearr_80906_80951[(1)] = (6));

} else {
var statearr_80907_80952 = state_80881__$1;
(statearr_80907_80952[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (23))){
var state_80881__$1 = state_80881;
var statearr_80908_80953 = state_80881__$1;
(statearr_80908_80953[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (19))){
var state_80881__$1 = state_80881;
var statearr_80910_80954 = state_80881__$1;
(statearr_80910_80954[(2)] = roles);

(statearr_80910_80954[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (11))){
var inst_80849 = (state_80881[(2)]);
var state_80881__$1 = state_80881;
var statearr_80912_80955 = state_80881__$1;
(statearr_80912_80955[(2)] = inst_80849);

(statearr_80912_80955[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (9))){
var state_80881__$1 = state_80881;
var statearr_80913_80956 = state_80881__$1;
(statearr_80913_80956[(2)] = (0));

(statearr_80913_80956[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (5))){
var _ = (function (){var statearr_80914 = state_80881;
(statearr_80914[(4)] = cljs.core.rest.call(null,(state_80881[(4)])));

return statearr_80914;
})();
var state_80881__$1 = state_80881;
var ex80911 = (state_80881__$1[(2)]);
var statearr_80915_80957 = state_80881__$1;
(statearr_80915_80957[(5)] = ex80911);


if((ex80911 instanceof Error)){
var statearr_80916_80958 = state_80881__$1;
(statearr_80916_80958[(1)] = (4));

(statearr_80916_80958[(5)] = null);

} else {
throw ex80911;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (14))){
var inst_80847 = (state_80881[(2)]);
var state_80881__$1 = state_80881;
var statearr_80917_80959 = state_80881__$1;
(statearr_80917_80959[(2)] = inst_80847);

(statearr_80917_80959[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (26))){
var state_80881__$1 = state_80881;
var statearr_80918_80960 = state_80881__$1;
(statearr_80918_80960[(2)] = null);

(statearr_80918_80960[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (16))){
var inst_80834 = (state_80881[(8)]);
var state_80881__$1 = state_80881;
var statearr_80919_80961 = state_80881__$1;
(statearr_80919_80961[(2)] = inst_80834);

(statearr_80919_80961[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (30))){
var state_80881__$1 = state_80881;
var statearr_80920_80962 = state_80881__$1;
(statearr_80920_80962[(2)] = null);

(statearr_80920_80962[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (10))){
var state_80881__$1 = state_80881;
if(cljs.core.truth_(auth)){
var statearr_80921_80963 = state_80881__$1;
(statearr_80921_80963[(1)] = (12));

} else {
var statearr_80922_80964 = state_80881__$1;
(statearr_80922_80964[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (18))){
var inst_80844 = (state_80881[(2)]);
var state_80881__$1 = state_80881;
var statearr_80923_80965 = state_80881__$1;
(statearr_80923_80965[(2)] = inst_80844);

(statearr_80923_80965[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80882 === (8))){
var inst_80851 = (state_80881[(2)]);
var state_80881__$1 = (function (){var statearr_80924 = state_80881;
(statearr_80924[(7)] = inst_80851);

return statearr_80924;
})();
if(cljs.core.truth_(roles)){
var statearr_80925_80966 = state_80881__$1;
(statearr_80925_80966[(1)] = (19));

} else {
var statearr_80926_80967 = state_80881__$1;
(statearr_80926_80967[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__10945__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__10945__auto____0 = (function (){
var statearr_80927 = [null,null,null,null,null,null,null,null,null,null];
(statearr_80927[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__10945__auto__);

(statearr_80927[(1)] = (1));

return statearr_80927;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__10945__auto____1 = (function (state_80881){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_80881);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e80928){var ex__10948__auto__ = e80928;
var statearr_80929_80968 = state_80881;
(statearr_80929_80968[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_80881[(4)]))){
var statearr_80930_80969 = state_80881;
(statearr_80930_80969[(1)] = cljs.core.first.call(null,(state_80881[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80970 = state_80881;
state_80881 = G__80970;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__10945__auto__ = function(state_80881){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__10945__auto____1.call(this,state_80881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__10945__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__10945__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_80931 = f__11019__auto__.call(null);
(statearr_80931[(6)] = c__11018__auto__);

return statearr_80931;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__80971 = db;
var map__80971__$1 = cljs.core.__destructure_map.call(null,map__80971);
var conn = cljs.core.get.call(null,map__80971__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__80971__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__80971__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.call(null,"NEW EVENT:",cljs.core.pr_str.call(null,evt),cljs.core.pr_str.call(null,data));

if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_.call(null,new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);

var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_80978){
var state_val_80979 = (state_80978[(1)]);
if((state_val_80979 === (1))){
var inst_80972 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_80973 = fluree.db.session.db.call(null,conn,inst_80972,null);
var state_80978__$1 = state_80978;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80978__$1,(2),inst_80973);
} else {
if((state_val_80979 === (2))){
var inst_80975 = (state_80978[(2)]);
var inst_80976 = cljs.core.async.put_BANG_.call(null,resp_port,inst_80975);
var state_80978__$1 = state_80978;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80978__$1,inst_80976);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto____0 = (function (){
var statearr_80980 = [null,null,null,null,null,null,null];
(statearr_80980[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto__);

(statearr_80980[(1)] = (1));

return statearr_80980;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto____1 = (function (state_80978){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_80978);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e80981){var ex__10948__auto__ = e80981;
var statearr_80982_81009 = state_80978;
(statearr_80982_81009[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_80978[(4)]))){
var statearr_80983_81010 = state_80978;
(statearr_80983_81010[(1)] = cljs.core.first.call(null,(state_80978[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81011 = state_80978;
state_80978 = G__81011;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto__ = function(state_80978){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto____1.call(this,state_80978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_80984 = f__11019__auto__.call(null);
(statearr_80984[(6)] = c__11018__auto__);

return statearr_80984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener.call(null,conn,network,dbid,listen_id,event_fn);

var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_80997){
var state_val_80998 = (state_80997[(1)]);
if((state_val_80998 === (1))){
var inst_80985 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_80986 = fluree.db.session.db.call(null,conn,inst_80985,null);
var state_80997__$1 = state_80997;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80997__$1,(2),inst_80986);
} else {
if((state_val_80998 === (2))){
var inst_80988 = (state_80997[(7)]);
var inst_80988__$1 = (state_80997[(2)]);
var inst_80989 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_80988__$1);
var inst_80990 = newer_block_QMARK_.call(null,inst_80989);
var state_80997__$1 = (function (){var statearr_80999 = state_80997;
(statearr_80999[(7)] = inst_80988__$1);

return statearr_80999;
})();
if(inst_80990){
var statearr_81000_81012 = state_80997__$1;
(statearr_81000_81012[(1)] = (3));

} else {
var statearr_81001_81013 = state_80997__$1;
(statearr_81001_81013[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80998 === (3))){
var inst_80988 = (state_80997[(7)]);
var inst_80992 = cljs.core.async.put_BANG_.call(null,resp_port,inst_80988);
var state_80997__$1 = state_80997;
var statearr_81002_81014 = state_80997__$1;
(statearr_81002_81014[(2)] = inst_80992);

(statearr_81002_81014[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80998 === (4))){
var state_80997__$1 = state_80997;
var statearr_81003_81015 = state_80997__$1;
(statearr_81003_81015[(2)] = null);

(statearr_81003_81015[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80998 === (5))){
var inst_80995 = (state_80997[(2)]);
var state_80997__$1 = state_80997;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80997__$1,inst_80995);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto____0 = (function (){
var statearr_81004 = [null,null,null,null,null,null,null,null];
(statearr_81004[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto__);

(statearr_81004[(1)] = (1));

return statearr_81004;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto____1 = (function (state_80997){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_80997);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e81005){var ex__10948__auto__ = e81005;
var statearr_81006_81016 = state_80997;
(statearr_81006_81016[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_80997[(4)]))){
var statearr_81007_81017 = state_80997;
(statearr_81007_81017[(1)] = cljs.core.first.call(null,(state_80997[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81018 = state_80997;
state_80997 = G__81018;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto__ = function(state_80997){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto____1.call(this,state_80997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_81008 = f__11019__auto__.call(null);
(statearr_81008[(6)] = c__11018__auto__);

return statearr_81008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_.call(null,syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.call(null);
var map__81019 = db;
var map__81019__$1 = cljs.core.__destructure_map.call(null,map__81019);
var conn = cljs.core.get.call(null,map__81019__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__81019__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__81019__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid.call(null);
var timeout = ((cljs.core.pos_int_QMARK_.call(null,syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.call(null);
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.call(null,pc,db);
} else {
fluree.db.api.ledger.syncTo_wait.call(null,db,syncTo,listen_id,res_port);

var c__11018__auto___81095 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_81069){
var state_val_81070 = (state_81069[(1)]);
if((state_val_81070 === (7))){
var inst_81035 = (state_81069[(7)]);
var inst_81046 = cljs.core._EQ_.call(null,inst_81035,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_81069__$1 = state_81069;
if(inst_81046){
var statearr_81071_81096 = state_81069__$1;
(statearr_81071_81096[(1)] = (9));

} else {
var statearr_81072_81097 = state_81069__$1;
(statearr_81072_81097[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81070 === (1))){
var inst_81028 = (state_81069[(8)]);
var inst_81020 = (state_81069[(9)]);
var inst_81020__$1 = cljs.core.async.timeout.call(null,timeout);
var inst_81028__$1 = res_port;
var inst_81029 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81030 = [inst_81020__$1,inst_81028__$1];
var inst_81031 = (new cljs.core.PersistentVector(null,2,(5),inst_81029,inst_81030,null));
var state_81069__$1 = (function (){var statearr_81073 = state_81069;
(statearr_81073[(8)] = inst_81028__$1);

(statearr_81073[(9)] = inst_81020__$1);

return statearr_81073;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_81069__$1,(2),inst_81031);
} else {
if((state_val_81070 === (4))){
var inst_81028 = (state_81069[(8)]);
var inst_81035 = (state_81069[(7)]);
var inst_81039 = cljs.core._EQ_.call(null,inst_81035,inst_81028);
var state_81069__$1 = state_81069;
if(inst_81039){
var statearr_81074_81098 = state_81069__$1;
(statearr_81074_81098[(1)] = (6));

} else {
var statearr_81075_81099 = state_81069__$1;
(statearr_81075_81099[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81070 === (13))){
var inst_81054 = (state_81069[(10)]);
var inst_81065 = cljs.core.async.put_BANG_.call(null,pc,inst_81054);
var state_81069__$1 = state_81069;
var statearr_81076_81100 = state_81069__$1;
(statearr_81076_81100[(2)] = inst_81065);

(statearr_81076_81100[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81070 === (6))){
var inst_81033 = (state_81069[(11)]);
var inst_81044 = cljs.core.nth.call(null,inst_81033,(0),null);
var state_81069__$1 = state_81069;
var statearr_81077_81101 = state_81069__$1;
(statearr_81077_81101[(2)] = inst_81044);

(statearr_81077_81101[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81070 === (3))){
var state_81069__$1 = state_81069;
var statearr_81078_81102 = state_81069__$1;
(statearr_81078_81102[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_81078_81102[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81070 === (12))){
var inst_81058 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_81059 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81060 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_81061 = cljs.core.PersistentHashMap.fromArrays(inst_81059,inst_81060);
var inst_81062 = cljs.core.ex_info.call(null,inst_81058,inst_81061);
var inst_81063 = cljs.core.async.put_BANG_.call(null,pc,inst_81062);
var state_81069__$1 = state_81069;
var statearr_81079_81103 = state_81069__$1;
(statearr_81079_81103[(2)] = inst_81063);

(statearr_81079_81103[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81070 === (2))){
var inst_81020 = (state_81069[(9)]);
var inst_81035 = (state_81069[(7)]);
var inst_81033 = (state_81069[(11)]);
var inst_81033__$1 = (state_81069[(2)]);
var inst_81034 = cljs.core.nth.call(null,inst_81033__$1,(0),null);
var inst_81035__$1 = cljs.core.nth.call(null,inst_81033__$1,(1),null);
var inst_81036 = cljs.core._EQ_.call(null,inst_81035__$1,inst_81020);
var state_81069__$1 = (function (){var statearr_81080 = state_81069;
(statearr_81080[(7)] = inst_81035__$1);

(statearr_81080[(11)] = inst_81033__$1);

(statearr_81080[(12)] = inst_81034);

return statearr_81080;
})();
if(inst_81036){
var statearr_81081_81104 = state_81069__$1;
(statearr_81081_81104[(1)] = (3));

} else {
var statearr_81082_81105 = state_81069__$1;
(statearr_81082_81105[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81070 === (11))){
var inst_81050 = (state_81069[(2)]);
var state_81069__$1 = state_81069;
var statearr_81083_81106 = state_81069__$1;
(statearr_81083_81106[(2)] = inst_81050);

(statearr_81083_81106[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81070 === (9))){
var inst_81034 = (state_81069[(12)]);
var state_81069__$1 = state_81069;
var statearr_81084_81107 = state_81069__$1;
(statearr_81084_81107[(2)] = inst_81034);

(statearr_81084_81107[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81070 === (5))){
var inst_81054 = (state_81069[(10)]);
var inst_81054__$1 = (state_81069[(2)]);
var inst_81055 = fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);
var inst_81056 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_81054__$1);
var state_81069__$1 = (function (){var statearr_81085 = state_81069;
(statearr_81085[(10)] = inst_81054__$1);

(statearr_81085[(13)] = inst_81055);

return statearr_81085;
})();
if(inst_81056){
var statearr_81086_81108 = state_81069__$1;
(statearr_81086_81108[(1)] = (12));

} else {
var statearr_81087_81109 = state_81069__$1;
(statearr_81087_81109[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81070 === (14))){
var inst_81067 = (state_81069[(2)]);
var state_81069__$1 = state_81069;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81069__$1,inst_81067);
} else {
if((state_val_81070 === (10))){
var state_81069__$1 = state_81069;
var statearr_81088_81110 = state_81069__$1;
(statearr_81088_81110[(2)] = null);

(statearr_81088_81110[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81070 === (8))){
var inst_81052 = (state_81069[(2)]);
var state_81069__$1 = state_81069;
var statearr_81089_81111 = state_81069__$1;
(statearr_81089_81111[(2)] = inst_81052);

(statearr_81089_81111[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__10945__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__10945__auto____0 = (function (){
var statearr_81090 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81090[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__10945__auto__);

(statearr_81090[(1)] = (1));

return statearr_81090;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__10945__auto____1 = (function (state_81069){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_81069);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e81091){var ex__10948__auto__ = e81091;
var statearr_81092_81112 = state_81069;
(statearr_81092_81112[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_81069[(4)]))){
var statearr_81093_81113 = state_81069;
(statearr_81093_81113[(1)] = cljs.core.first.call(null,(state_81069[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81114 = state_81069;
state_81069 = G__81114;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__10945__auto__ = function(state_81069){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__10945__auto____1.call(this,state_81069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__10945__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__10945__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_81094 = f__11019__auto__.call(null);
(statearr_81094[(6)] = c__11018__auto___81095);

return statearr_81094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__81116 = arguments.length;
switch (G__81116) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__81117){
var map__81118 = p__81117;
var map__81118__$1 = cljs.core.__destructure_map.call(null,map__81118);
var opts = map__81118__$1;
var roles = cljs.core.get.call(null,map__81118__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.call(null,map__81118__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.call(null,map__81118__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.call(null,map__81118__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.call(null,map__81118__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.call(null);
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__11018__auto___81207 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_81169){
var state_val_81170 = (state_81169[(1)]);
if((state_val_81170 === (7))){
var inst_81131 = (state_81169[(7)]);
var inst_81133 = fluree.db.api.ledger.syncTo_db.call(null,inst_81131,syncTo,syncTimeout);
var state_81169__$1 = state_81169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81169__$1,(10),inst_81133);
} else {
if((state_val_81170 === (20))){
var inst_81155 = (state_81169[(8)]);
var state_81169__$1 = state_81169;
var statearr_81171_81208 = state_81169__$1;
(statearr_81171_81208[(2)] = inst_81155);

(statearr_81171_81208[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81170 === (1))){
var state_81169__$1 = state_81169;
var statearr_81172_81209 = state_81169__$1;
(statearr_81172_81209[(2)] = null);

(statearr_81172_81209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81170 === (4))){
var inst_81119 = (state_81169[(2)]);
var inst_81120 = cljs.core.async.put_BANG_.call(null,pc,inst_81119);
var inst_81121 = cljs.core.async.close_BANG_.call(null,pc);
var state_81169__$1 = (function (){var statearr_81173 = state_81169;
(statearr_81173[(9)] = inst_81120);

return statearr_81173;
})();
var statearr_81174_81210 = state_81169__$1;
(statearr_81174_81210[(2)] = inst_81121);

(statearr_81174_81210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81170 === (15))){
var inst_81147 = (state_81169[(10)]);
var inst_81149 = fluree.db.api.ledger.add_db_permissions.call(null,inst_81147,auth,roles);
var state_81169__$1 = state_81169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81169__$1,(18),inst_81149);
} else {
if((state_val_81170 === (21))){
var inst_81163 = (state_81169[(2)]);
var inst_81164 = cljs.core.async.put_BANG_.call(null,pc,inst_81163);
var _ = (function (){var statearr_81175 = state_81169;
(statearr_81175[(4)] = cljs.core.rest.call(null,(state_81169[(4)])));

return statearr_81175;
})();
var state_81169__$1 = state_81169;
var statearr_81176_81211 = state_81169__$1;
(statearr_81176_81211[(2)] = inst_81164);

(statearr_81176_81211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81170 === (13))){
var inst_81147 = (state_81169[(2)]);
var state_81169__$1 = (function (){var statearr_81177 = state_81169;
(statearr_81177[(10)] = inst_81147);

return statearr_81177;
})();
if(cljs.core.truth_(roles)){
var statearr_81178_81212 = state_81169__$1;
(statearr_81178_81212[(1)] = (15));

} else {
var statearr_81179_81213 = state_81169__$1;
(statearr_81179_81213[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81170 === (22))){
var inst_81159 = (state_81169[(2)]);
var inst_81160 = fluree.db.util.async.throw_err.call(null,inst_81159);
var state_81169__$1 = state_81169;
var statearr_81180_81214 = state_81169__$1;
(statearr_81180_81214[(2)] = inst_81160);

(statearr_81180_81214[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81170 === (6))){
var inst_81130 = (state_81169[(2)]);
var inst_81131 = fluree.db.util.async.throw_err.call(null,inst_81130);
var state_81169__$1 = (function (){var statearr_81181 = state_81169;
(statearr_81181[(7)] = inst_81131);

return statearr_81181;
})();
if(cljs.core.truth_(syncTo)){
var statearr_81182_81215 = state_81169__$1;
(statearr_81182_81215[(1)] = (7));

} else {
var statearr_81183_81216 = state_81169__$1;
(statearr_81183_81216[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81170 === (17))){
var inst_81155 = (state_81169[(2)]);
var state_81169__$1 = (function (){var statearr_81184 = state_81169;
(statearr_81184[(8)] = inst_81155);

return statearr_81184;
})();
if(cljs.core.truth_(auth)){
var statearr_81185_81217 = state_81169__$1;
(statearr_81185_81217[(1)] = (19));

} else {
var statearr_81186_81218 = state_81169__$1;
(statearr_81186_81218[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81170 === (3))){
var inst_81167 = (state_81169[(2)]);
var state_81169__$1 = state_81169;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81169__$1,inst_81167);
} else {
if((state_val_81170 === (12))){
var inst_81139 = (state_81169[(11)]);
var state_81169__$1 = state_81169;
var statearr_81187_81219 = state_81169__$1;
(statearr_81187_81219[(2)] = inst_81139);

(statearr_81187_81219[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81170 === (2))){
var _ = (function (){var statearr_81188 = state_81169;
(statearr_81188[(4)] = cljs.core.cons.call(null,(5),(state_81169[(4)])));

return statearr_81188;
})();
var inst_81128 = fluree.db.session.db.call(null,conn,ledger,opts_SINGLEQUOTE_);
var state_81169__$1 = state_81169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81169__$1,(6),inst_81128);
} else {
if((state_val_81170 === (19))){
var inst_81155 = (state_81169[(8)]);
var inst_81157 = fluree.db.api.ledger.add_db_permissions.call(null,inst_81155,auth,roles);
var state_81169__$1 = state_81169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81169__$1,(22),inst_81157);
} else {
if((state_val_81170 === (11))){
var inst_81139 = (state_81169[(11)]);
var inst_81141 = fluree.db.time_travel.as_of_block.call(null,inst_81139,block);
var state_81169__$1 = state_81169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81169__$1,(14),inst_81141);
} else {
if((state_val_81170 === (9))){
var inst_81139 = (state_81169[(2)]);
var state_81169__$1 = (function (){var statearr_81190 = state_81169;
(statearr_81190[(11)] = inst_81139);

return statearr_81190;
})();
if(cljs.core.truth_(block)){
var statearr_81191_81220 = state_81169__$1;
(statearr_81191_81220[(1)] = (11));

} else {
var statearr_81192_81221 = state_81169__$1;
(statearr_81192_81221[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81170 === (5))){
var _ = (function (){var statearr_81193 = state_81169;
(statearr_81193[(4)] = cljs.core.rest.call(null,(state_81169[(4)])));

return statearr_81193;
})();
var state_81169__$1 = state_81169;
var ex81189 = (state_81169__$1[(2)]);
var statearr_81194_81222 = state_81169__$1;
(statearr_81194_81222[(5)] = ex81189);


var statearr_81195_81223 = state_81169__$1;
(statearr_81195_81223[(1)] = (4));

(statearr_81195_81223[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81170 === (14))){
var inst_81143 = (state_81169[(2)]);
var inst_81144 = fluree.db.util.async.throw_err.call(null,inst_81143);
var state_81169__$1 = state_81169;
var statearr_81196_81224 = state_81169__$1;
(statearr_81196_81224[(2)] = inst_81144);

(statearr_81196_81224[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81170 === (16))){
var inst_81147 = (state_81169[(10)]);
var state_81169__$1 = state_81169;
var statearr_81197_81225 = state_81169__$1;
(statearr_81197_81225[(2)] = inst_81147);

(statearr_81197_81225[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81170 === (10))){
var inst_81135 = (state_81169[(2)]);
var inst_81136 = fluree.db.util.async.throw_err.call(null,inst_81135);
var state_81169__$1 = state_81169;
var statearr_81198_81226 = state_81169__$1;
(statearr_81198_81226[(2)] = inst_81136);

(statearr_81198_81226[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81170 === (18))){
var inst_81151 = (state_81169[(2)]);
var inst_81152 = fluree.db.util.async.throw_err.call(null,inst_81151);
var state_81169__$1 = state_81169;
var statearr_81199_81227 = state_81169__$1;
(statearr_81199_81227[(2)] = inst_81152);

(statearr_81199_81227[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81170 === (8))){
var inst_81131 = (state_81169[(7)]);
var state_81169__$1 = state_81169;
var statearr_81200_81228 = state_81169__$1;
(statearr_81200_81228[(2)] = inst_81131);

(statearr_81200_81228[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__10945__auto__ = null;
var fluree$db$api$ledger$state_machine__10945__auto____0 = (function (){
var statearr_81201 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81201[(0)] = fluree$db$api$ledger$state_machine__10945__auto__);

(statearr_81201[(1)] = (1));

return statearr_81201;
});
var fluree$db$api$ledger$state_machine__10945__auto____1 = (function (state_81169){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_81169);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e81202){var ex__10948__auto__ = e81202;
var statearr_81203_81229 = state_81169;
(statearr_81203_81229[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_81169[(4)]))){
var statearr_81204_81230 = state_81169;
(statearr_81204_81230[(1)] = cljs.core.first.call(null,(state_81169[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81231 = state_81169;
state_81169 = G__81231;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__10945__auto__ = function(state_81169){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__10945__auto____1.call(this,state_81169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__10945__auto____0;
fluree$db$api$ledger$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__10945__auto____1;
return fluree$db$api$ledger$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_81205 = f__11019__auto__.call(null);
(statearr_81205[(6)] = c__11018__auto___81207);

return statearr_81205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

