// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__70369 = arguments.length;
switch (G__70369) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__11018__auto___70517 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_70456){
var state_val_70457 = (state_70456[(1)]);
if((state_val_70457 === (7))){
var inst_70387 = (state_70456[(7)]);
var inst_70390 = cljs.core.not_EQ_.call(null,(0),inst_70387);
var state_70456__$1 = state_70456;
var statearr_70458_70518 = state_70456__$1;
(statearr_70458_70518[(2)] = inst_70390);

(statearr_70458_70518[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (20))){
var inst_70411 = (state_70456[(8)]);
var inst_70382 = (state_70456[(9)]);
var inst_70415 = fluree.db.auth.roles.call(null,inst_70382,inst_70411);
var state_70456__$1 = state_70456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70456__$1,(23),inst_70415);
} else {
if((state_val_70457 === (27))){
var inst_70382 = (state_70456[(9)]);
var inst_70430 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_70431 = fluree.db.time_travel.as_of_block.call(null,inst_70382,inst_70430);
var state_70456__$1 = state_70456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70456__$1,(30),inst_70431);
} else {
if((state_val_70457 === (1))){
var state_70456__$1 = state_70456;
var statearr_70459_70519 = state_70456__$1;
(statearr_70459_70519[(2)] = null);

(statearr_70459_70519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (24))){
var inst_70382 = (state_70456[(9)]);
var inst_70423 = (state_70456[(10)]);
var inst_70425 = fluree.db.permissions.permission_map.call(null,inst_70382,inst_70423,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_70456__$1 = state_70456;
var statearr_70460_70520 = state_70456__$1;
(statearr_70460_70520[(2)] = inst_70425);

(statearr_70460_70520[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (4))){
var inst_70370 = (state_70456[(2)]);
var inst_70371 = cljs.core.async.put_BANG_.call(null,pc,inst_70370);
var inst_70372 = cljs.core.async.close_BANG_.call(null,pc);
var state_70456__$1 = (function (){var statearr_70461 = state_70456;
(statearr_70461[(11)] = inst_70371);

return statearr_70461;
})();
var statearr_70462_70521 = state_70456__$1;
(statearr_70462_70521[(2)] = inst_70372);

(statearr_70462_70521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (15))){
var inst_70387 = (state_70456[(7)]);
var inst_70401 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70387)," unknown."].join('');
var inst_70402 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70403 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_70404 = cljs.core.PersistentHashMap.fromArrays(inst_70402,inst_70403);
var inst_70405 = cljs.core.ex_info.call(null,inst_70401,inst_70404);
var inst_70406 = (function(){throw inst_70405})();
var state_70456__$1 = state_70456;
var statearr_70463_70522 = state_70456__$1;
(statearr_70463_70522[(2)] = inst_70406);

(statearr_70463_70522[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (21))){
var state_70456__$1 = state_70456;
var statearr_70464_70523 = state_70456__$1;
(statearr_70464_70523[(2)] = null);

(statearr_70464_70523[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (31))){
var inst_70437 = (state_70456[(12)]);
var inst_70387 = (state_70456[(7)]);
var inst_70439 = cljs.core.assoc.call(null,inst_70437,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_70387);
var state_70456__$1 = state_70456;
var statearr_70465_70524 = state_70456__$1;
(statearr_70465_70524[(2)] = inst_70439);

(statearr_70465_70524[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (32))){
var inst_70437 = (state_70456[(12)]);
var state_70456__$1 = state_70456;
var statearr_70466_70525 = state_70456__$1;
(statearr_70466_70525[(2)] = inst_70437);

(statearr_70466_70525[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (33))){
var inst_70423 = (state_70456[(10)]);
var inst_70442 = (state_70456[(2)]);
var state_70456__$1 = (function (){var statearr_70467 = state_70456;
(statearr_70467[(13)] = inst_70442);

return statearr_70467;
})();
if(cljs.core.truth_(inst_70423)){
var statearr_70468_70526 = state_70456__$1;
(statearr_70468_70526[(1)] = (34));

} else {
var statearr_70469_70527 = state_70456__$1;
(statearr_70469_70527[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (13))){
var inst_70398 = (state_70456[(14)]);
var inst_70397 = (state_70456[(2)]);
var inst_70398__$1 = fluree.db.util.async.throw_err.call(null,inst_70397);
var state_70456__$1 = (function (){var statearr_70470 = state_70456;
(statearr_70470[(14)] = inst_70398__$1);

return statearr_70470;
})();
if(cljs.core.truth_(inst_70398__$1)){
var statearr_70471_70528 = state_70456__$1;
(statearr_70471_70528[(1)] = (14));

} else {
var statearr_70472_70529 = state_70456__$1;
(statearr_70472_70529[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (22))){
var inst_70421 = (state_70456[(2)]);
var state_70456__$1 = state_70456;
var statearr_70473_70530 = state_70456__$1;
(statearr_70473_70530[(2)] = inst_70421);

(statearr_70473_70530[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (36))){
var inst_70450 = (state_70456[(2)]);
var inst_70451 = cljs.core.async.put_BANG_.call(null,pc,inst_70450);
var _ = (function (){var statearr_70474 = state_70456;
(statearr_70474[(4)] = cljs.core.rest.call(null,(state_70456[(4)])));

return statearr_70474;
})();
var state_70456__$1 = state_70456;
var statearr_70475_70531 = state_70456__$1;
(statearr_70475_70531[(2)] = inst_70451);

(statearr_70475_70531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (29))){
var inst_70387 = (state_70456[(7)]);
var inst_70437 = (state_70456[(2)]);
var state_70456__$1 = (function (){var statearr_70476 = state_70456;
(statearr_70476[(12)] = inst_70437);

return statearr_70476;
})();
if(cljs.core.truth_(inst_70387)){
var statearr_70477_70532 = state_70456__$1;
(statearr_70477_70532[(1)] = (31));

} else {
var statearr_70478_70533 = state_70456__$1;
(statearr_70478_70533[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (6))){
var inst_70387 = (state_70456[(7)]);
var inst_70381 = (state_70456[(2)]);
var inst_70382 = fluree.db.util.async.throw_err.call(null,inst_70381);
var inst_70383 = opts;
var inst_70384 = cljs.core.__destructure_map.call(null,inst_70383);
var inst_70385 = cljs.core.get.call(null,inst_70384,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_70386 = cljs.core.get.call(null,inst_70384,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_70387__$1 = cljs.core.get.call(null,inst_70384,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_70388 = cljs.core.get.call(null,inst_70384,new cljs.core.Keyword(null,"block","block",664686210));
var state_70456__$1 = (function (){var statearr_70479 = state_70456;
(statearr_70479[(15)] = inst_70386);

(statearr_70479[(9)] = inst_70382);

(statearr_70479[(16)] = inst_70385);

(statearr_70479[(7)] = inst_70387__$1);

(statearr_70479[(17)] = inst_70388);

return statearr_70479;
})();
if(cljs.core.truth_(inst_70387__$1)){
var statearr_70480_70534 = state_70456__$1;
(statearr_70480_70534[(1)] = (7));

} else {
var statearr_70481_70535 = state_70456__$1;
(statearr_70481_70535[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (28))){
var inst_70382 = (state_70456[(9)]);
var state_70456__$1 = state_70456;
var statearr_70482_70536 = state_70456__$1;
(statearr_70482_70536[(2)] = inst_70382);

(statearr_70482_70536[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (25))){
var state_70456__$1 = state_70456;
var statearr_70483_70537 = state_70456__$1;
(statearr_70483_70537[(2)] = null);

(statearr_70483_70537[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (34))){
var inst_70428 = (state_70456[(18)]);
var state_70456__$1 = state_70456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70456__$1,(37),inst_70428);
} else {
if((state_val_70457 === (17))){
var inst_70385 = (state_70456[(16)]);
var state_70456__$1 = state_70456;
var statearr_70484_70538 = state_70456__$1;
(statearr_70484_70538[(2)] = inst_70385);

(statearr_70484_70538[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (3))){
var inst_70454 = (state_70456[(2)]);
var state_70456__$1 = state_70456;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70456__$1,inst_70454);
} else {
if((state_val_70457 === (12))){
var inst_70385 = (state_70456[(16)]);
var inst_70411 = (state_70456[(2)]);
var state_70456__$1 = (function (){var statearr_70485 = state_70456;
(statearr_70485[(8)] = inst_70411);

return statearr_70485;
})();
if(cljs.core.truth_(inst_70385)){
var statearr_70486_70539 = state_70456__$1;
(statearr_70486_70539[(1)] = (17));

} else {
var statearr_70487_70540 = state_70456__$1;
(statearr_70487_70540[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (2))){
var _ = (function (){var statearr_70488 = state_70456;
(statearr_70488[(4)] = cljs.core.cons.call(null,(5),(state_70456[(4)])));

return statearr_70488;
})();
var inst_70379 = fluree.db.session.db.call(null,conn,ledger,null);
var state_70456__$1 = state_70456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70456__$1,(6),inst_70379);
} else {
if((state_val_70457 === (23))){
var inst_70417 = (state_70456[(2)]);
var inst_70418 = fluree.db.util.async.throw_err.call(null,inst_70417);
var state_70456__$1 = state_70456;
var statearr_70489_70541 = state_70456__$1;
(statearr_70489_70541[(2)] = inst_70418);

(statearr_70489_70541[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (35))){
var inst_70442 = (state_70456[(13)]);
var state_70456__$1 = state_70456;
var statearr_70490_70542 = state_70456__$1;
(statearr_70490_70542[(2)] = inst_70442);

(statearr_70490_70542[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (19))){
var inst_70423 = (state_70456[(10)]);
var inst_70423__$1 = (state_70456[(2)]);
var state_70456__$1 = (function (){var statearr_70491 = state_70456;
(statearr_70491[(10)] = inst_70423__$1);

return statearr_70491;
})();
if(cljs.core.truth_(inst_70423__$1)){
var statearr_70492_70543 = state_70456__$1;
(statearr_70492_70543[(1)] = (24));

} else {
var statearr_70493_70544 = state_70456__$1;
(statearr_70493_70544[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (11))){
var state_70456__$1 = state_70456;
var statearr_70495_70545 = state_70456__$1;
(statearr_70495_70545[(2)] = null);

(statearr_70495_70545[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (9))){
var inst_70393 = (state_70456[(2)]);
var state_70456__$1 = state_70456;
if(cljs.core.truth_(inst_70393)){
var statearr_70496_70546 = state_70456__$1;
(statearr_70496_70546[(1)] = (10));

} else {
var statearr_70497_70547 = state_70456__$1;
(statearr_70497_70547[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (5))){
var _ = (function (){var statearr_70498 = state_70456;
(statearr_70498[(4)] = cljs.core.rest.call(null,(state_70456[(4)])));

return statearr_70498;
})();
var state_70456__$1 = state_70456;
var ex70494 = (state_70456__$1[(2)]);
var statearr_70499_70548 = state_70456__$1;
(statearr_70499_70548[(5)] = ex70494);


var statearr_70500_70549 = state_70456__$1;
(statearr_70500_70549[(1)] = (4));

(statearr_70500_70549[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (14))){
var inst_70398 = (state_70456[(14)]);
var state_70456__$1 = state_70456;
var statearr_70501_70550 = state_70456__$1;
(statearr_70501_70550[(2)] = inst_70398);

(statearr_70501_70550[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (26))){
var inst_70388 = (state_70456[(17)]);
var inst_70428 = (state_70456[(2)]);
var state_70456__$1 = (function (){var statearr_70502 = state_70456;
(statearr_70502[(18)] = inst_70428);

return statearr_70502;
})();
if(cljs.core.truth_(inst_70388)){
var statearr_70503_70551 = state_70456__$1;
(statearr_70503_70551[(1)] = (27));

} else {
var statearr_70504_70552 = state_70456__$1;
(statearr_70504_70552[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (16))){
var inst_70408 = (state_70456[(2)]);
var state_70456__$1 = state_70456;
var statearr_70505_70553 = state_70456__$1;
(statearr_70505_70553[(2)] = inst_70408);

(statearr_70505_70553[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (30))){
var inst_70433 = (state_70456[(2)]);
var inst_70434 = fluree.db.util.async.throw_err.call(null,inst_70433);
var state_70456__$1 = state_70456;
var statearr_70506_70554 = state_70456__$1;
(statearr_70506_70554[(2)] = inst_70434);

(statearr_70506_70554[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (10))){
var inst_70382 = (state_70456[(9)]);
var inst_70387 = (state_70456[(7)]);
var inst_70395 = fluree.db.dbproto._subid.call(null,inst_70382,inst_70387);
var state_70456__$1 = state_70456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70456__$1,(13),inst_70395);
} else {
if((state_val_70457 === (18))){
var inst_70411 = (state_70456[(8)]);
var state_70456__$1 = state_70456;
if(cljs.core.truth_(inst_70411)){
var statearr_70507_70555 = state_70456__$1;
(statearr_70507_70555[(1)] = (20));

} else {
var statearr_70508_70556 = state_70456__$1;
(statearr_70508_70556[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (37))){
var inst_70442 = (state_70456[(13)]);
var inst_70445 = (state_70456[(2)]);
var inst_70446 = fluree.db.util.async.throw_err.call(null,inst_70445);
var inst_70447 = cljs.core.assoc.call(null,inst_70442,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_70446);
var state_70456__$1 = state_70456;
var statearr_70509_70557 = state_70456__$1;
(statearr_70509_70557[(2)] = inst_70447);

(statearr_70509_70557[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70457 === (8))){
var inst_70387 = (state_70456[(7)]);
var state_70456__$1 = state_70456;
var statearr_70510_70558 = state_70456__$1;
(statearr_70510_70558[(2)] = inst_70387);

(statearr_70510_70558[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__10945__auto__ = null;
var fluree$db$api$query$state_machine__10945__auto____0 = (function (){
var statearr_70511 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70511[(0)] = fluree$db$api$query$state_machine__10945__auto__);

(statearr_70511[(1)] = (1));

return statearr_70511;
});
var fluree$db$api$query$state_machine__10945__auto____1 = (function (state_70456){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_70456);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e70512){var ex__10948__auto__ = e70512;
var statearr_70513_70559 = state_70456;
(statearr_70513_70559[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_70456[(4)]))){
var statearr_70514_70560 = state_70456;
(statearr_70514_70560[(1)] = cljs.core.first.call(null,(state_70456[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70561 = state_70456;
state_70456 = G__70561;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__10945__auto__ = function(state_70456){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__10945__auto____1.call(this,state_70456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__10945__auto____0;
fluree$db$api$query$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__10945__auto____1;
return fluree$db$api$query$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_70515 = f__11019__auto__.call(null);
(statearr_70515[(6)] = c__11018__auto___70517);

return statearr_70515;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_70702){
var state_val_70703 = (state_70702[(1)]);
if((state_val_70703 === (7))){
var inst_70582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70583 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70584 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70585 = [inst_70583,inst_70584];
var inst_70586 = (new cljs.core.PersistentVector(null,2,(5),inst_70582,inst_70585,null));
var state_70702__$1 = state_70702;
var statearr_70704_70774 = state_70702__$1;
(statearr_70704_70774[(2)] = inst_70586);

(statearr_70704_70774[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (20))){
var inst_70612 = (state_70702[(7)]);
var state_70702__$1 = state_70702;
var statearr_70705_70775 = state_70702__$1;
(statearr_70705_70775[(2)] = inst_70612);

(statearr_70705_70775[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (27))){
var state_70702__$1 = state_70702;
var statearr_70706_70776 = state_70702__$1;
(statearr_70706_70776[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (1))){
var state_70702__$1 = state_70702;
var statearr_70708_70777 = state_70702__$1;
(statearr_70708_70777[(2)] = null);

(statearr_70708_70777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (24))){
var inst_70611 = (state_70702[(8)]);
var state_70702__$1 = state_70702;
if(cljs.core.truth_(inst_70611)){
var statearr_70709_70778 = state_70702__$1;
(statearr_70709_70778[(1)] = (26));

} else {
var statearr_70710_70779 = state_70702__$1;
(statearr_70710_70779[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (39))){
var inst_70657 = (state_70702[(9)]);
var inst_70658 = (state_70702[(10)]);
var inst_70683 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70684 = [inst_70657,inst_70658];
var inst_70685 = (new cljs.core.PersistentVector(null,2,(5),inst_70683,inst_70684,null));
var state_70702__$1 = state_70702;
var statearr_70711_70780 = state_70702__$1;
(statearr_70711_70780[(2)] = inst_70685);

(statearr_70711_70780[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (4))){
var inst_70562 = (state_70702[(2)]);
var state_70702__$1 = state_70702;
var statearr_70712_70781 = state_70702__$1;
(statearr_70712_70781[(2)] = inst_70562);

(statearr_70712_70781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (15))){
var inst_70596 = (state_70702[(11)]);
var inst_70591 = (state_70702[(12)]);
var inst_70605 = (state_70702[(2)]);
var inst_70606 = [inst_70596,inst_70605];
var inst_70607 = (new cljs.core.PersistentVector(null,2,(5),inst_70591,inst_70606,null));
var state_70702__$1 = state_70702;
var statearr_70713_70782 = state_70702__$1;
(statearr_70713_70782[(2)] = inst_70607);

(statearr_70713_70782[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (21))){
var inst_70611 = (state_70702[(8)]);
var state_70702__$1 = state_70702;
var statearr_70714_70783 = state_70702__$1;
(statearr_70714_70783[(2)] = inst_70611);

(statearr_70714_70783[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (31))){
var inst_70652 = (state_70702[(2)]);
var state_70702__$1 = state_70702;
var statearr_70715_70784 = state_70702__$1;
(statearr_70715_70784[(2)] = inst_70652);

(statearr_70715_70784[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (32))){
var inst_70658 = (state_70702[(10)]);
var inst_70661 = cljs.core.pos_int_QMARK_.call(null,inst_70658);
var state_70702__$1 = state_70702;
var statearr_70716_70785 = state_70702__$1;
(statearr_70716_70785[(2)] = inst_70661);

(statearr_70716_70785[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (40))){
var inst_70613 = (state_70702[(13)]);
var inst_70689 = (state_70702[(14)]);
var inst_70687 = (state_70702[(2)]);
var inst_70688 = cljs.core.nth.call(null,inst_70687,(0),null);
var inst_70689__$1 = cljs.core.nth.call(null,inst_70687,(1),null);
var inst_70690 = (inst_70689__$1 > inst_70613);
var state_70702__$1 = (function (){var statearr_70717 = state_70702;
(statearr_70717[(15)] = inst_70688);

(statearr_70717[(14)] = inst_70689__$1);

return statearr_70717;
})();
if(cljs.core.truth_(inst_70690)){
var statearr_70718_70786 = state_70702__$1;
(statearr_70718_70786[(1)] = (41));

} else {
var statearr_70719_70787 = state_70702__$1;
(statearr_70719_70787[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (33))){
var inst_70659 = (state_70702[(16)]);
var state_70702__$1 = state_70702;
var statearr_70720_70788 = state_70702__$1;
(statearr_70720_70788[(2)] = inst_70659);

(statearr_70720_70788[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (13))){
var inst_70597 = (state_70702[(17)]);
var inst_70599 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_70597);
var state_70702__$1 = state_70702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70702__$1,(16),inst_70599);
} else {
if((state_val_70703 === (22))){
var inst_70630 = (state_70702[(2)]);
var state_70702__$1 = state_70702;
if(cljs.core.truth_(inst_70630)){
var statearr_70721_70789 = state_70702__$1;
(statearr_70721_70789[(1)] = (23));

} else {
var statearr_70722_70790 = state_70702__$1;
(statearr_70722_70790[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (36))){
var state_70702__$1 = state_70702;
var statearr_70723_70791 = state_70702__$1;
(statearr_70723_70791[(2)] = null);

(statearr_70723_70791[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (41))){
var inst_70613 = (state_70702[(13)]);
var state_70702__$1 = state_70702;
var statearr_70724_70792 = state_70702__$1;
(statearr_70724_70792[(2)] = inst_70613);

(statearr_70724_70792[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (43))){
var inst_70688 = (state_70702[(15)]);
var inst_70694 = (state_70702[(2)]);
var inst_70695 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70696 = [inst_70688,inst_70694];
var inst_70697 = (new cljs.core.PersistentVector(null,2,(5),inst_70695,inst_70696,null));
var _ = (function (){var statearr_70725 = state_70702;
(statearr_70725[(4)] = cljs.core.rest.call(null,(state_70702[(4)])));

return statearr_70725;
})();
var state_70702__$1 = state_70702;
var statearr_70726_70793 = state_70702__$1;
(statearr_70726_70793[(2)] = inst_70697);

(statearr_70726_70793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (29))){
var inst_70588 = (state_70702[(18)]);
var inst_70643 = cljs.core.pr_str.call(null,inst_70588);
var inst_70644 = ["Invalid block range provided: ",inst_70643].join('');
var inst_70645 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70646 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70647 = cljs.core.PersistentHashMap.fromArrays(inst_70645,inst_70646);
var inst_70648 = cljs.core.ex_info.call(null,inst_70644,inst_70647);
var inst_70649 = (function(){throw inst_70648})();
var state_70702__$1 = state_70702;
var statearr_70727_70794 = state_70702__$1;
(statearr_70727_70794[(2)] = inst_70649);

(statearr_70727_70794[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (6))){
var inst_70580 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_70702__$1 = state_70702;
var statearr_70728_70795 = state_70702__$1;
(statearr_70728_70795[(2)] = inst_70580);

(statearr_70728_70795[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (28))){
var inst_70654 = (state_70702[(2)]);
var state_70702__$1 = state_70702;
var statearr_70729_70796 = state_70702__$1;
(statearr_70729_70796[(2)] = inst_70654);

(statearr_70729_70796[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (25))){
var inst_70657 = (state_70702[(9)]);
var inst_70659 = (state_70702[(16)]);
var inst_70656 = (state_70702[(2)]);
var inst_70657__$1 = cljs.core.nth.call(null,inst_70656,(0),null);
var inst_70658 = cljs.core.nth.call(null,inst_70656,(1),null);
var inst_70659__$1 = cljs.core.pos_int_QMARK_.call(null,inst_70657__$1);
var state_70702__$1 = (function (){var statearr_70730 = state_70702;
(statearr_70730[(9)] = inst_70657__$1);

(statearr_70730[(16)] = inst_70659__$1);

(statearr_70730[(10)] = inst_70658);

return statearr_70730;
})();
if(inst_70659__$1){
var statearr_70731_70797 = state_70702__$1;
(statearr_70731_70797[(1)] = (32));

} else {
var statearr_70732_70798 = state_70702__$1;
(statearr_70732_70798[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (34))){
var inst_70664 = (state_70702[(2)]);
var inst_70665 = cljs.core.not.call(null,inst_70664);
var state_70702__$1 = state_70702;
if(inst_70665){
var statearr_70733_70799 = state_70702__$1;
(statearr_70733_70799[(1)] = (35));

} else {
var statearr_70734_70800 = state_70702__$1;
(statearr_70734_70800[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (17))){
var inst_70613 = (state_70702[(13)]);
var inst_70611 = (state_70702[(8)]);
var inst_70616 = cljs.core.pr_str.call(null,inst_70611);
var inst_70617 = cljs.core.pr_str.call(null,inst_70613);
var inst_70618 = ["Start block is out of range for this ledger. Start block provided: ",inst_70616,". Database block: ",inst_70617].join('');
var inst_70619 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70620 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70621 = cljs.core.PersistentHashMap.fromArrays(inst_70619,inst_70620);
var inst_70622 = cljs.core.ex_info.call(null,inst_70618,inst_70621);
var inst_70623 = (function(){throw inst_70622})();
var state_70702__$1 = state_70702;
var statearr_70735_70801 = state_70702__$1;
(statearr_70735_70801[(2)] = inst_70623);

(statearr_70735_70801[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (3))){
var inst_70700 = (state_70702[(2)]);
var state_70702__$1 = state_70702;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70702__$1,inst_70700);
} else {
if((state_val_70703 === (12))){
var inst_70588 = (state_70702[(18)]);
var inst_70597 = (state_70702[(17)]);
var inst_70595 = (state_70702[(2)]);
var inst_70596 = fluree.db.util.async.throw_err.call(null,inst_70595);
var inst_70597__$1 = cljs.core.second.call(null,inst_70588);
var state_70702__$1 = (function (){var statearr_70736 = state_70702;
(statearr_70736[(11)] = inst_70596);

(statearr_70736[(17)] = inst_70597__$1);

return statearr_70736;
})();
if(cljs.core.truth_(inst_70597__$1)){
var statearr_70737_70802 = state_70702__$1;
(statearr_70737_70802[(1)] = (13));

} else {
var statearr_70738_70803 = state_70702__$1;
(statearr_70738_70803[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (2))){
var _ = (function (){var statearr_70739 = state_70702;
(statearr_70739[(4)] = cljs.core.cons.call(null,(5),(state_70702[(4)])));

return statearr_70739;
})();
var inst_70577 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70578 = cljs.core.sequential_QMARK_.call(null,inst_70577);
var state_70702__$1 = state_70702;
if(inst_70578){
var statearr_70740_70804 = state_70702__$1;
(statearr_70740_70804[(1)] = (6));

} else {
var statearr_70741_70805 = state_70702__$1;
(statearr_70741_70805[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (23))){
var inst_70612 = (state_70702[(7)]);
var inst_70611 = (state_70702[(8)]);
var inst_70632 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70633 = [inst_70611,inst_70612];
var inst_70634 = (new cljs.core.PersistentVector(null,2,(5),inst_70632,inst_70633,null));
var state_70702__$1 = state_70702;
var statearr_70742_70806 = state_70702__$1;
(statearr_70742_70806[(2)] = inst_70634);

(statearr_70742_70806[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (35))){
var inst_70588 = (state_70702[(18)]);
var inst_70667 = cljs.core.pr_str.call(null,inst_70588);
var inst_70668 = ["Invalid block range provided: ",inst_70667].join('');
var inst_70669 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70670 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70671 = cljs.core.PersistentHashMap.fromArrays(inst_70669,inst_70670);
var inst_70672 = cljs.core.ex_info.call(null,inst_70668,inst_70671);
var inst_70673 = (function(){throw inst_70672})();
var state_70702__$1 = state_70702;
var statearr_70743_70807 = state_70702__$1;
(statearr_70743_70807[(2)] = inst_70673);

(statearr_70743_70807[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (19))){
var inst_70611 = (state_70702[(8)]);
var inst_70626 = (state_70702[(2)]);
var state_70702__$1 = (function (){var statearr_70744 = state_70702;
(statearr_70744[(19)] = inst_70626);

return statearr_70744;
})();
if(cljs.core.truth_(inst_70611)){
var statearr_70745_70808 = state_70702__$1;
(statearr_70745_70808[(1)] = (20));

} else {
var statearr_70746_70809 = state_70702__$1;
(statearr_70746_70809[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (11))){
var inst_70613 = (state_70702[(13)]);
var inst_70611 = (state_70702[(8)]);
var inst_70610 = (state_70702[(2)]);
var inst_70611__$1 = cljs.core.nth.call(null,inst_70610,(0),null);
var inst_70612 = cljs.core.nth.call(null,inst_70610,(1),null);
var inst_70613__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_70614 = (inst_70611__$1 > inst_70613__$1);
var state_70702__$1 = (function (){var statearr_70748 = state_70702;
(statearr_70748[(13)] = inst_70613__$1);

(statearr_70748[(7)] = inst_70612);

(statearr_70748[(8)] = inst_70611__$1);

return statearr_70748;
})();
if(cljs.core.truth_(inst_70614)){
var statearr_70749_70810 = state_70702__$1;
(statearr_70749_70810[(1)] = (17));

} else {
var statearr_70750_70811 = state_70702__$1;
(statearr_70750_70811[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (9))){
var inst_70588 = (state_70702[(18)]);
var inst_70591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70592 = cljs.core.first.call(null,inst_70588);
var inst_70593 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_70592);
var state_70702__$1 = (function (){var statearr_70751 = state_70702;
(statearr_70751[(12)] = inst_70591);

return statearr_70751;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70702__$1,(12),inst_70593);
} else {
if((state_val_70703 === (5))){
var _ = (function (){var statearr_70752 = state_70702;
(statearr_70752[(4)] = cljs.core.rest.call(null,(state_70702[(4)])));

return statearr_70752;
})();
var state_70702__$1 = state_70702;
var ex70747 = (state_70702__$1[(2)]);
var statearr_70753_70812 = state_70702__$1;
(statearr_70753_70812[(5)] = ex70747);


if((ex70747 instanceof Error)){
var statearr_70754_70813 = state_70702__$1;
(statearr_70754_70813[(1)] = (4));

(statearr_70754_70813[(5)] = null);

} else {
throw ex70747;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (14))){
var state_70702__$1 = state_70702;
var statearr_70755_70814 = state_70702__$1;
(statearr_70755_70814[(2)] = null);

(statearr_70755_70814[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (26))){
var inst_70611 = (state_70702[(8)]);
var inst_70637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70638 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_70639 = [inst_70611,inst_70638];
var inst_70640 = (new cljs.core.PersistentVector(null,2,(5),inst_70637,inst_70639,null));
var state_70702__$1 = state_70702;
var statearr_70756_70815 = state_70702__$1;
(statearr_70756_70815[(2)] = inst_70640);

(statearr_70756_70815[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (16))){
var inst_70601 = (state_70702[(2)]);
var inst_70602 = fluree.db.util.async.throw_err.call(null,inst_70601);
var state_70702__$1 = state_70702;
var statearr_70757_70816 = state_70702__$1;
(statearr_70757_70816[(2)] = inst_70602);

(statearr_70757_70816[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (38))){
var inst_70657 = (state_70702[(9)]);
var inst_70658 = (state_70702[(10)]);
var inst_70679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70680 = [inst_70658,inst_70657];
var inst_70681 = (new cljs.core.PersistentVector(null,2,(5),inst_70679,inst_70680,null));
var state_70702__$1 = state_70702;
var statearr_70758_70817 = state_70702__$1;
(statearr_70758_70817[(2)] = inst_70681);

(statearr_70758_70817[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (30))){
var state_70702__$1 = state_70702;
var statearr_70759_70818 = state_70702__$1;
(statearr_70759_70818[(2)] = null);

(statearr_70759_70818[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (10))){
var inst_70588 = (state_70702[(18)]);
var state_70702__$1 = state_70702;
var statearr_70760_70819 = state_70702__$1;
(statearr_70760_70819[(2)] = inst_70588);

(statearr_70760_70819[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (18))){
var state_70702__$1 = state_70702;
var statearr_70761_70820 = state_70702__$1;
(statearr_70761_70820[(2)] = null);

(statearr_70761_70820[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (42))){
var inst_70689 = (state_70702[(14)]);
var state_70702__$1 = state_70702;
var statearr_70762_70821 = state_70702__$1;
(statearr_70762_70821[(2)] = inst_70689);

(statearr_70762_70821[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (37))){
var inst_70657 = (state_70702[(9)]);
var inst_70658 = (state_70702[(10)]);
var inst_70676 = (state_70702[(2)]);
var inst_70677 = (inst_70658 < inst_70657);
var state_70702__$1 = (function (){var statearr_70763 = state_70702;
(statearr_70763[(20)] = inst_70676);

return statearr_70763;
})();
if(cljs.core.truth_(inst_70677)){
var statearr_70764_70822 = state_70702__$1;
(statearr_70764_70822[(1)] = (38));

} else {
var statearr_70765_70823 = state_70702__$1;
(statearr_70765_70823[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70703 === (8))){
var inst_70588 = (state_70702[(18)]);
var inst_70588__$1 = (state_70702[(2)]);
var inst_70589 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_70588__$1);
var state_70702__$1 = (function (){var statearr_70766 = state_70702;
(statearr_70766[(18)] = inst_70588__$1);

return statearr_70766;
})();
if(cljs.core.truth_(inst_70589)){
var statearr_70767_70824 = state_70702__$1;
(statearr_70767_70824[(1)] = (9));

} else {
var statearr_70768_70825 = state_70702__$1;
(statearr_70768_70825[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__10945__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__10945__auto____0 = (function (){
var statearr_70769 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70769[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__10945__auto__);

(statearr_70769[(1)] = (1));

return statearr_70769;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__10945__auto____1 = (function (state_70702){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_70702);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e70770){var ex__10948__auto__ = e70770;
var statearr_70771_70826 = state_70702;
(statearr_70771_70826[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_70702[(4)]))){
var statearr_70772_70827 = state_70702;
(statearr_70772_70827[(1)] = cljs.core.first.call(null,(state_70702[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70828 = state_70702;
state_70702 = G__70828;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__10945__auto__ = function(state_70702){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__10945__auto____1.call(this,state_70702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__10945__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__10945__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_70773 = f__11019__auto__.call(null);
(statearr_70773[(6)] = c__11018__auto__);

return statearr_70773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_70978){
var state_val_70979 = (state_70978[(1)]);
if((state_val_70979 === (7))){
var inst_70890 = (state_70978[(2)]);
var inst_70891 = cljs.core.nth.call(null,inst_70890,(0),null);
var inst_70892 = cljs.core.nth.call(null,inst_70890,(1),null);
var inst_70900 = cljs.core.vals.call(null,inst_70892);
var inst_70901 = cljs.core.seq.call(null,inst_70900);
var inst_70902 = cljs.core.first.call(null,inst_70901);
var inst_70903 = cljs.core.next.call(null,inst_70901);
var inst_70904 = cljs.core.PersistentVector.EMPTY;
var inst_70905 = inst_70900;
var inst_70906 = inst_70904;
var state_70978__$1 = (function (){var statearr_70980 = state_70978;
(statearr_70980[(7)] = inst_70903);

(statearr_70980[(8)] = inst_70905);

(statearr_70980[(9)] = inst_70902);

(statearr_70980[(10)] = inst_70891);

(statearr_70980[(11)] = inst_70906);

return statearr_70980;
})();
var statearr_70981_71034 = state_70978__$1;
(statearr_70981_71034[(2)] = null);

(statearr_70981_71034[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (20))){
var inst_70912 = (state_70978[(12)]);
var inst_70917 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_70918 = cljs.core.PersistentHashMap.EMPTY;
var inst_70919 = [true,inst_70918];
var inst_70920 = cljs.core.PersistentHashMap.fromArrays(inst_70917,inst_70919);
var inst_70921 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_70920,inst_70912);
var state_70978__$1 = state_70978;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70978__$1,(22),inst_70921);
} else {
if((state_val_70979 === (27))){
var inst_70966 = (state_70978[(2)]);
var state_70978__$1 = state_70978;
var statearr_70982_71035 = state_70978__$1;
(statearr_70982_71035[(2)] = inst_70966);

(statearr_70982_71035[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (1))){
var state_70978__$1 = state_70978;
var statearr_70983_71036 = state_70978__$1;
(statearr_70983_71036[(2)] = null);

(statearr_70983_71036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (24))){
var inst_70930 = (state_70978[(13)]);
var inst_70968 = (state_70978[(2)]);
var inst_70969 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_70970 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_70971 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_70972 = [inst_70970,inst_70971,inst_70930,inst_70968];
var inst_70973 = cljs.core.PersistentHashMap.fromArrays(inst_70969,inst_70972);
var _ = (function (){var statearr_70985 = state_70978;
(statearr_70985[(4)] = cljs.core.rest.call(null,(state_70978[(4)])));

return statearr_70985;
})();
var state_70978__$1 = state_70978;
var statearr_70986_71037 = state_70978__$1;
(statearr_70986_71037[(2)] = inst_70973);

(statearr_70986_71037[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (4))){
var inst_70831 = (state_70978[(2)]);
var state_70978__$1 = state_70978;
var statearr_70987_71038 = state_70978__$1;
(statearr_70987_71038[(2)] = inst_70831);

(statearr_70987_71038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (15))){
var inst_70850 = (state_70978[(14)]);
var inst_70861 = (state_70978[(15)]);
var inst_70862 = (state_70978[(16)]);
var inst_70869 = (state_70978[(17)]);
var inst_70855 = (state_70978[(18)]);
var inst_70876 = (state_70978[(19)]);
var inst_70871 = (state_70978[(20)]);
var inst_70847 = (state_70978[(21)]);
var inst_70849 = (state_70978[(22)]);
var inst_70854 = (state_70978[(23)]);
var inst_70853 = (state_70978[(24)]);
var inst_70882 = (function (){var subject = inst_70869;
var flake = inst_70861;
var G__70843 = inst_70853;
var vec__70857 = inst_70853;
var r = inst_70862;
var asserted_subjects = inst_70854;
var flake_SINGLEQUOTE_ = inst_70876;
var retracted_subjects = inst_70855;
var seq__70845 = inst_70850;
var asserted_QMARK_ = inst_70871;
var vec__70844 = inst_70847;
var first__70846 = inst_70849;
var first__70859 = inst_70861;
var seq__70858 = inst_70862;
return (function (p1__70830_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__70830_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_70883 = cljs.core.update.call(null,inst_70855,inst_70869,inst_70882);
var tmp70984 = inst_70854;
var inst_70853__$1 = inst_70862;
var inst_70854__$1 = tmp70984;
var inst_70855__$1 = inst_70883;
var state_70978__$1 = (function (){var statearr_70988 = state_70978;
(statearr_70988[(18)] = inst_70855__$1);

(statearr_70988[(23)] = inst_70854__$1);

(statearr_70988[(24)] = inst_70853__$1);

return statearr_70988;
})();
var statearr_70989_71039 = state_70978__$1;
(statearr_70989_71039[(2)] = null);

(statearr_70989_71039[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (21))){
var inst_70928 = (state_70978[(2)]);
var state_70978__$1 = state_70978;
var statearr_70990_71040 = state_70978__$1;
(statearr_70990_71040[(2)] = inst_70928);

(statearr_70990_71040[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (13))){
var inst_70871 = (state_70978[(20)]);
var inst_70876 = (state_70978[(2)]);
var state_70978__$1 = (function (){var statearr_70991 = state_70978;
(statearr_70991[(19)] = inst_70876);

return statearr_70991;
})();
if(cljs.core.truth_(inst_70871)){
var statearr_70992_71041 = state_70978__$1;
(statearr_70992_71041[(1)] = (14));

} else {
var statearr_70993_71042 = state_70978__$1;
(statearr_70993_71042[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (22))){
var inst_70906 = (state_70978[(11)]);
var inst_70913 = (state_70978[(25)]);
var inst_70923 = (state_70978[(2)]);
var inst_70924 = fluree.db.util.async.throw_err.call(null,inst_70923);
var inst_70925 = cljs.core.conj.call(null,inst_70906,inst_70924);
var inst_70905 = inst_70913;
var inst_70906__$1 = inst_70925;
var state_70978__$1 = (function (){var statearr_70994 = state_70978;
(statearr_70994[(8)] = inst_70905);

(statearr_70994[(11)] = inst_70906__$1);

return statearr_70994;
})();
var statearr_70995_71043 = state_70978__$1;
(statearr_70995_71043[(2)] = null);

(statearr_70995_71043[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (6))){
var inst_70861 = (state_70978[(15)]);
var inst_70853 = (state_70978[(24)]);
var inst_70860 = cljs.core.seq.call(null,inst_70853);
var inst_70861__$1 = cljs.core.first.call(null,inst_70860);
var inst_70862 = cljs.core.next.call(null,inst_70860);
var inst_70863 = cljs.core.not.call(null,inst_70861__$1);
var state_70978__$1 = (function (){var statearr_70996 = state_70978;
(statearr_70996[(15)] = inst_70861__$1);

(statearr_70996[(16)] = inst_70862);

return statearr_70996;
})();
if(inst_70863){
var statearr_70997_71044 = state_70978__$1;
(statearr_70997_71044[(1)] = (8));

} else {
var statearr_70998_71045 = state_70978__$1;
(statearr_70998_71045[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (28))){
var inst_70944 = (state_70978[(26)]);
var inst_70951 = (state_70978[(27)]);
var inst_70961 = (state_70978[(2)]);
var inst_70962 = fluree.db.util.async.throw_err.call(null,inst_70961);
var inst_70963 = cljs.core.conj.call(null,inst_70944,inst_70962);
var inst_70943 = inst_70951;
var inst_70944__$1 = inst_70963;
var state_70978__$1 = (function (){var statearr_70999 = state_70978;
(statearr_70999[(28)] = inst_70943);

(statearr_70999[(26)] = inst_70944__$1);

return statearr_70999;
})();
var statearr_71000_71046 = state_70978__$1;
(statearr_71000_71046[(2)] = null);

(statearr_71000_71046[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (25))){
var inst_70944 = (state_70978[(26)]);
var state_70978__$1 = state_70978;
var statearr_71001_71047 = state_70978__$1;
(statearr_71001_71047[(2)] = inst_70944);

(statearr_71001_71047[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (17))){
var inst_70905 = (state_70978[(8)]);
var inst_70912 = (state_70978[(12)]);
var inst_70911 = cljs.core.seq.call(null,inst_70905);
var inst_70912__$1 = cljs.core.first.call(null,inst_70911);
var inst_70913 = cljs.core.next.call(null,inst_70911);
var inst_70914 = cljs.core.not.call(null,inst_70912__$1);
var state_70978__$1 = (function (){var statearr_71002 = state_70978;
(statearr_71002[(12)] = inst_70912__$1);

(statearr_71002[(25)] = inst_70913);

return statearr_71002;
})();
if(inst_70914){
var statearr_71003_71048 = state_70978__$1;
(statearr_71003_71048[(1)] = (19));

} else {
var statearr_71004_71049 = state_70978__$1;
(statearr_71004_71049[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (3))){
var inst_70976 = (state_70978[(2)]);
var state_70978__$1 = state_70978;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70978__$1,inst_70976);
} else {
if((state_val_70979 === (12))){
var inst_70861 = (state_70978[(15)]);
var inst_70874 = fluree.db.flake.flip_flake.call(null,inst_70861);
var state_70978__$1 = state_70978;
var statearr_71005_71050 = state_70978__$1;
(statearr_71005_71050[(2)] = inst_70874);

(statearr_71005_71050[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (2))){
var inst_70847 = (state_70978[(21)]);
var _ = (function (){var statearr_71006 = state_70978;
(statearr_71006[(4)] = cljs.core.cons.call(null,(5),(state_70978[(4)])));

return statearr_71006;
})();
var inst_70847__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_70848 = cljs.core.seq.call(null,inst_70847__$1);
var inst_70849 = cljs.core.first.call(null,inst_70848);
var inst_70850 = cljs.core.next.call(null,inst_70848);
var inst_70851 = cljs.core.PersistentHashMap.EMPTY;
var inst_70852 = cljs.core.PersistentHashMap.EMPTY;
var inst_70853 = inst_70847__$1;
var inst_70854 = inst_70851;
var inst_70855 = inst_70852;
var state_70978__$1 = (function (){var statearr_71007 = state_70978;
(statearr_71007[(14)] = inst_70850);

(statearr_71007[(18)] = inst_70855);

(statearr_71007[(21)] = inst_70847__$1);

(statearr_71007[(22)] = inst_70849);

(statearr_71007[(23)] = inst_70854);

(statearr_71007[(24)] = inst_70853);

return statearr_71007;
})();
var statearr_71008_71051 = state_70978__$1;
(statearr_71008_71051[(2)] = null);

(statearr_71008_71051[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (23))){
var inst_70943 = (state_70978[(28)]);
var inst_70950 = (state_70978[(29)]);
var inst_70949 = cljs.core.seq.call(null,inst_70943);
var inst_70950__$1 = cljs.core.first.call(null,inst_70949);
var inst_70951 = cljs.core.next.call(null,inst_70949);
var inst_70952 = cljs.core.not.call(null,inst_70950__$1);
var state_70978__$1 = (function (){var statearr_71009 = state_70978;
(statearr_71009[(29)] = inst_70950__$1);

(statearr_71009[(27)] = inst_70951);

return statearr_71009;
})();
if(inst_70952){
var statearr_71010_71052 = state_70978__$1;
(statearr_71010_71052[(1)] = (25));

} else {
var statearr_71011_71053 = state_70978__$1;
(statearr_71011_71053[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (19))){
var inst_70906 = (state_70978[(11)]);
var state_70978__$1 = state_70978;
var statearr_71012_71054 = state_70978__$1;
(statearr_71012_71054[(2)] = inst_70906);

(statearr_71012_71054[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (11))){
var inst_70861 = (state_70978[(15)]);
var state_70978__$1 = state_70978;
var statearr_71014_71055 = state_70978__$1;
(statearr_71014_71055[(2)] = inst_70861);

(statearr_71014_71055[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (9))){
var inst_70861 = (state_70978[(15)]);
var inst_70871 = (state_70978[(20)]);
var inst_70869 = inst_70861.s;
var inst_70870 = inst_70861.op;
var inst_70871__$1 = inst_70870 === true;
var state_70978__$1 = (function (){var statearr_71016 = state_70978;
(statearr_71016[(17)] = inst_70869);

(statearr_71016[(20)] = inst_70871__$1);

return statearr_71016;
})();
if(cljs.core.truth_(inst_70871__$1)){
var statearr_71017_71056 = state_70978__$1;
(statearr_71017_71056[(1)] = (11));

} else {
var statearr_71018_71057 = state_70978__$1;
(statearr_71018_71057[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (5))){
var _ = (function (){var statearr_71019 = state_70978;
(statearr_71019[(4)] = cljs.core.rest.call(null,(state_70978[(4)])));

return statearr_71019;
})();
var state_70978__$1 = state_70978;
var ex71013 = (state_70978__$1[(2)]);
var statearr_71020_71058 = state_70978__$1;
(statearr_71020_71058[(5)] = ex71013);


if((ex71013 instanceof Error)){
var statearr_71021_71059 = state_70978__$1;
(statearr_71021_71059[(1)] = (4));

(statearr_71021_71059[(5)] = null);

} else {
throw ex71013;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (14))){
var inst_70850 = (state_70978[(14)]);
var inst_70861 = (state_70978[(15)]);
var inst_70862 = (state_70978[(16)]);
var inst_70869 = (state_70978[(17)]);
var inst_70855 = (state_70978[(18)]);
var inst_70876 = (state_70978[(19)]);
var inst_70871 = (state_70978[(20)]);
var inst_70847 = (state_70978[(21)]);
var inst_70849 = (state_70978[(22)]);
var inst_70854 = (state_70978[(23)]);
var inst_70853 = (state_70978[(24)]);
var inst_70878 = (function (){var subject = inst_70869;
var flake = inst_70861;
var G__70843 = inst_70853;
var vec__70857 = inst_70853;
var r = inst_70862;
var asserted_subjects = inst_70854;
var flake_SINGLEQUOTE_ = inst_70876;
var retracted_subjects = inst_70855;
var seq__70845 = inst_70850;
var asserted_QMARK_ = inst_70871;
var vec__70844 = inst_70847;
var first__70846 = inst_70849;
var first__70859 = inst_70861;
var seq__70858 = inst_70862;
return (function (p1__70829_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__70829_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_70879 = cljs.core.update.call(null,inst_70854,inst_70869,inst_70878);
var tmp71015 = inst_70855;
var inst_70853__$1 = inst_70862;
var inst_70854__$1 = inst_70879;
var inst_70855__$1 = tmp71015;
var state_70978__$1 = (function (){var statearr_71022 = state_70978;
(statearr_71022[(18)] = inst_70855__$1);

(statearr_71022[(23)] = inst_70854__$1);

(statearr_71022[(24)] = inst_70853__$1);

return statearr_71022;
})();
var statearr_71023_71060 = state_70978__$1;
(statearr_71023_71060[(2)] = null);

(statearr_71023_71060[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (26))){
var inst_70950 = (state_70978[(29)]);
var inst_70955 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_70956 = cljs.core.PersistentHashMap.EMPTY;
var inst_70957 = [true,inst_70956];
var inst_70958 = cljs.core.PersistentHashMap.fromArrays(inst_70955,inst_70957);
var inst_70959 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_70958,inst_70950);
var state_70978__$1 = state_70978;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70978__$1,(28),inst_70959);
} else {
if((state_val_70979 === (16))){
var inst_70886 = (state_70978[(2)]);
var state_70978__$1 = state_70978;
var statearr_71024_71061 = state_70978__$1;
(statearr_71024_71061[(2)] = inst_70886);

(statearr_71024_71061[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (10))){
var inst_70888 = (state_70978[(2)]);
var state_70978__$1 = state_70978;
var statearr_71025_71062 = state_70978__$1;
(statearr_71025_71062[(2)] = inst_70888);

(statearr_71025_71062[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (18))){
var inst_70891 = (state_70978[(10)]);
var inst_70930 = (state_70978[(2)]);
var inst_70938 = cljs.core.vals.call(null,inst_70891);
var inst_70939 = cljs.core.seq.call(null,inst_70938);
var inst_70940 = cljs.core.first.call(null,inst_70939);
var inst_70941 = cljs.core.next.call(null,inst_70939);
var inst_70942 = cljs.core.PersistentVector.EMPTY;
var inst_70943 = inst_70938;
var inst_70944 = inst_70942;
var state_70978__$1 = (function (){var statearr_71026 = state_70978;
(statearr_71026[(28)] = inst_70943);

(statearr_71026[(30)] = inst_70941);

(statearr_71026[(13)] = inst_70930);

(statearr_71026[(31)] = inst_70940);

(statearr_71026[(26)] = inst_70944);

return statearr_71026;
})();
var statearr_71027_71063 = state_70978__$1;
(statearr_71027_71063[(2)] = null);

(statearr_71027_71063[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70979 === (8))){
var inst_70855 = (state_70978[(18)]);
var inst_70854 = (state_70978[(23)]);
var inst_70865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70866 = [inst_70854,inst_70855];
var inst_70867 = (new cljs.core.PersistentVector(null,2,(5),inst_70865,inst_70866,null));
var state_70978__$1 = state_70978;
var statearr_71028_71064 = state_70978__$1;
(statearr_71028_71064[(2)] = inst_70867);

(statearr_71028_71064[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__10945__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__10945__auto____0 = (function (){
var statearr_71029 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71029[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__10945__auto__);

(statearr_71029[(1)] = (1));

return statearr_71029;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__10945__auto____1 = (function (state_70978){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_70978);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e71030){var ex__10948__auto__ = e71030;
var statearr_71031_71065 = state_70978;
(statearr_71031_71065[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_70978[(4)]))){
var statearr_71032_71066 = state_70978;
(statearr_71032_71066[(1)] = cljs.core.first.call(null,(state_70978[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71067 = state_70978;
state_70978 = G__71067;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__10945__auto__ = function(state_70978){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__10945__auto____1.call(this,state_70978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__10945__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__10945__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_71033 = f__11019__auto__.call(null);
(statearr_71033[(6)] = c__11018__auto__);

return statearr_71033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_71099){
var state_val_71100 = (state_71099[(1)]);
if((state_val_71100 === (1))){
var inst_71068 = cljs.core.volatile_BANG_.call(null,(0));
var inst_71069 = cljs.core.PersistentHashMap.EMPTY;
var inst_71070 = cljs.core.volatile_BANG_.call(null,inst_71069);
var inst_71071 = cljs.core.first.call(null,resp);
var inst_71072 = cljs.core.rest.call(null,resp);
var inst_71073 = cljs.core.PersistentVector.EMPTY;
var inst_71074 = inst_71068;
var inst_71075 = inst_71070;
var inst_71076 = inst_71071;
var inst_71077 = inst_71072;
var inst_71078 = inst_71073;
var state_71099__$1 = (function (){var statearr_71101 = state_71099;
(statearr_71101[(7)] = inst_71075);

(statearr_71101[(8)] = inst_71074);

(statearr_71101[(9)] = inst_71077);

(statearr_71101[(10)] = inst_71078);

(statearr_71101[(11)] = inst_71076);

return statearr_71101;
})();
var statearr_71102_71117 = state_71099__$1;
(statearr_71102_71117[(2)] = null);

(statearr_71102_71117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71100 === (2))){
var inst_71075 = (state_71099[(7)]);
var inst_71074 = (state_71099[(8)]);
var inst_71076 = (state_71099[(11)]);
var inst_71080 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_71076,inst_71075,inst_71074);
var state_71099__$1 = state_71099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71099__$1,(4),inst_71080);
} else {
if((state_val_71100 === (3))){
var inst_71097 = (state_71099[(2)]);
var state_71099__$1 = state_71099;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71099__$1,inst_71097);
} else {
if((state_val_71100 === (4))){
var inst_71077 = (state_71099[(9)]);
var inst_71078 = (state_71099[(10)]);
var inst_71082 = (state_71099[(2)]);
var inst_71083 = fluree.db.util.async.throw_err.call(null,inst_71082);
var inst_71084 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71085 = [inst_71083];
var inst_71086 = (new cljs.core.PersistentVector(null,1,(5),inst_71084,inst_71085,null));
var inst_71087 = cljs.core.concat.call(null,inst_71078,inst_71086);
var inst_71088 = cljs.core.first.call(null,inst_71077);
var state_71099__$1 = (function (){var statearr_71105 = state_71099;
(statearr_71105[(12)] = inst_71087);

return statearr_71105;
})();
if(cljs.core.truth_(inst_71088)){
var statearr_71106_71118 = state_71099__$1;
(statearr_71106_71118[(1)] = (5));

} else {
var statearr_71107_71119 = state_71099__$1;
(statearr_71107_71119[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71100 === (5))){
var inst_71075 = (state_71099[(7)]);
var inst_71074 = (state_71099[(8)]);
var inst_71087 = (state_71099[(12)]);
var inst_71077 = (state_71099[(9)]);
var inst_71090 = cljs.core.first.call(null,inst_71077);
var inst_71091 = cljs.core.rest.call(null,inst_71077);
var tmp71103 = inst_71075;
var tmp71104 = inst_71074;
var inst_71074__$1 = tmp71104;
var inst_71075__$1 = tmp71103;
var inst_71076 = inst_71090;
var inst_71077__$1 = inst_71091;
var inst_71078 = inst_71087;
var state_71099__$1 = (function (){var statearr_71108 = state_71099;
(statearr_71108[(7)] = inst_71075__$1);

(statearr_71108[(8)] = inst_71074__$1);

(statearr_71108[(9)] = inst_71077__$1);

(statearr_71108[(10)] = inst_71078);

(statearr_71108[(11)] = inst_71076);

return statearr_71108;
})();
var statearr_71109_71120 = state_71099__$1;
(statearr_71109_71120[(2)] = null);

(statearr_71109_71120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71100 === (6))){
var inst_71087 = (state_71099[(12)]);
var state_71099__$1 = state_71099;
var statearr_71110_71121 = state_71099__$1;
(statearr_71110_71121[(2)] = inst_71087);

(statearr_71110_71121[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71100 === (7))){
var inst_71095 = (state_71099[(2)]);
var state_71099__$1 = state_71099;
var statearr_71111_71122 = state_71099__$1;
(statearr_71111_71122[(2)] = inst_71095);

(statearr_71111_71122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10945__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10945__auto____0 = (function (){
var statearr_71112 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71112[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10945__auto__);

(statearr_71112[(1)] = (1));

return statearr_71112;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10945__auto____1 = (function (state_71099){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_71099);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e71113){var ex__10948__auto__ = e71113;
var statearr_71114_71123 = state_71099;
(statearr_71114_71123[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_71099[(4)]))){
var statearr_71115_71124 = state_71099;
(statearr_71115_71124[(1)] = cljs.core.first.call(null,(state_71099[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71125 = state_71099;
state_71099 = G__71125;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10945__auto__ = function(state_71099){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10945__auto____1.call(this,state_71099);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10945__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10945__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_71116 = f__11019__auto__.call(null);
(statearr_71116[(6)] = c__11018__auto__);

return statearr_71116;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__71127 = arguments.length;
switch (G__71127) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__71129){
var map__71130 = p__71129;
var map__71130__$1 = cljs.core.__destructure_map.call(null,map__71130);
var query = map__71130__$1;
var opts = cljs.core.get.call(null,map__71130__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_71215){
var state_val_71216 = (state_71215[(1)]);
if((state_val_71216 === (7))){
var inst_71141 = (state_71215[(7)]);
var inst_71145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71146 = ["_auth/id",inst_71141];
var inst_71147 = (new cljs.core.PersistentVector(null,2,(5),inst_71145,inst_71146,null));
var state_71215__$1 = state_71215;
var statearr_71217_71261 = state_71215__$1;
(statearr_71217_71261[(2)] = inst_71147);

(statearr_71217_71261[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (20))){
var inst_71195 = (state_71215[(2)]);
var inst_71196 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_71215__$1 = (function (){var statearr_71218 = state_71215;
(statearr_71218[(8)] = inst_71195);

return statearr_71218;
})();
if(cljs.core.truth_(inst_71196)){
var statearr_71219_71262 = state_71215__$1;
(statearr_71219_71262[(1)] = (22));

} else {
var statearr_71220_71263 = state_71215__$1;
(statearr_71220_71263[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (27))){
var inst_71198 = (state_71215[(9)]);
var inst_71142 = (state_71215[(10)]);
var inst_71204 = (state_71215[(2)]);
var inst_71205 = fluree.db.util.core.response_time_formatted.call(null,inst_71142);
var inst_71206 = [(200),inst_71204,(100),inst_71205];
var inst_71207 = cljs.core.PersistentHashMap.fromArrays(inst_71198,inst_71206);
var state_71215__$1 = state_71215;
var statearr_71221_71264 = state_71215__$1;
(statearr_71221_71264[(2)] = inst_71207);

(statearr_71221_71264[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (1))){
var state_71215__$1 = state_71215;
var statearr_71222_71265 = state_71215__$1;
(statearr_71222_71265[(2)] = null);

(statearr_71222_71265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (24))){
var inst_71210 = (state_71215[(2)]);
var _ = (function (){var statearr_71223 = state_71215;
(statearr_71223[(4)] = cljs.core.rest.call(null,(state_71215[(4)])));

return statearr_71223;
})();
var state_71215__$1 = state_71215;
var statearr_71224_71266 = state_71215__$1;
(statearr_71224_71266[(2)] = inst_71210);

(statearr_71224_71266[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (4))){
var inst_71131 = (state_71215[(2)]);
var state_71215__$1 = state_71215;
var statearr_71225_71267 = state_71215__$1;
(statearr_71225_71267[(2)] = inst_71131);

(statearr_71225_71267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (15))){
var inst_71182 = (state_71215[(11)]);
var state_71215__$1 = state_71215;
var statearr_71226_71268 = state_71215__$1;
(statearr_71226_71268[(2)] = inst_71182);

(statearr_71226_71268[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (21))){
var inst_71191 = (state_71215[(2)]);
var inst_71192 = fluree.db.util.async.throw_err.call(null,inst_71191);
var state_71215__$1 = state_71215;
var statearr_71227_71269 = state_71215__$1;
(statearr_71227_71269[(2)] = inst_71192);

(statearr_71227_71269[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (13))){
var inst_71182 = (state_71215[(11)]);
var inst_71140 = (state_71215[(12)]);
var inst_71181 = (state_71215[(2)]);
var inst_71182__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_71140);
var state_71215__$1 = (function (){var statearr_71228 = state_71215;
(statearr_71228[(13)] = inst_71181);

(statearr_71228[(11)] = inst_71182__$1);

return statearr_71228;
})();
if(cljs.core.truth_(inst_71182__$1)){
var statearr_71229_71270 = state_71215__$1;
(statearr_71229_71270[(1)] = (15));

} else {
var statearr_71230_71271 = state_71215__$1;
(statearr_71230_71271[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (22))){
var inst_71195 = (state_71215[(8)]);
var inst_71198 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_71199 = cljs.core.sequential_QMARK_.call(null,inst_71195);
var state_71215__$1 = (function (){var statearr_71231 = state_71215;
(statearr_71231[(9)] = inst_71198);

return statearr_71231;
})();
if(inst_71199){
var statearr_71232_71272 = state_71215__$1;
(statearr_71232_71272[(1)] = (25));

} else {
var statearr_71233_71273 = state_71215__$1;
(statearr_71233_71273[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (6))){
var inst_71156 = (state_71215[(14)]);
var inst_71140 = (state_71215[(12)]);
var inst_71155 = (state_71215[(2)]);
var inst_71156__$1 = fluree.db.util.async.throw_err.call(null,inst_71155);
var inst_71157 = fluree.db.api.query.resolve_block_range.call(null,inst_71156__$1,inst_71140);
var state_71215__$1 = (function (){var statearr_71234 = state_71215;
(statearr_71234[(14)] = inst_71156__$1);

return statearr_71234;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71215__$1,(10),inst_71157);
} else {
if((state_val_71216 === (25))){
var inst_71195 = (state_71215[(8)]);
var inst_71201 = cljs.core.doall.call(null,inst_71195);
var state_71215__$1 = state_71215;
var statearr_71235_71274 = state_71215__$1;
(statearr_71235_71274[(2)] = inst_71201);

(statearr_71235_71274[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (17))){
var inst_71187 = (state_71215[(2)]);
var state_71215__$1 = state_71215;
if(cljs.core.truth_(inst_71187)){
var statearr_71236_71275 = state_71215__$1;
(statearr_71236_71275[(1)] = (18));

} else {
var statearr_71237_71276 = state_71215__$1;
(statearr_71237_71276[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (3))){
var inst_71213 = (state_71215[(2)]);
var state_71215__$1 = state_71215;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71215__$1,inst_71213);
} else {
if((state_val_71216 === (12))){
var inst_71140 = (state_71215[(12)]);
var inst_71173 = cljs.core.pr_str.call(null,inst_71140);
var inst_71174 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_71173].join('');
var inst_71175 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71176 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71177 = cljs.core.PersistentHashMap.fromArrays(inst_71175,inst_71176);
var inst_71178 = cljs.core.ex_info.call(null,inst_71174,inst_71177);
var inst_71179 = (function(){throw inst_71178})();
var state_71215__$1 = state_71215;
var statearr_71238_71277 = state_71215__$1;
(statearr_71238_71277[(2)] = inst_71179);

(statearr_71238_71277[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (2))){
var inst_71141 = (state_71215[(7)]);
var _ = (function (){var statearr_71239 = state_71215;
(statearr_71239[(4)] = cljs.core.cons.call(null,(5),(state_71215[(4)])));

return statearr_71239;
})();
var inst_71140 = cljs.core.dissoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_71141__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_71142 = fluree.db.util.core.current_time_millis.call(null);
var inst_71143 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_71215__$1 = (function (){var statearr_71240 = state_71215;
(statearr_71240[(15)] = inst_71143);

(statearr_71240[(12)] = inst_71140);

(statearr_71240[(10)] = inst_71142);

(statearr_71240[(7)] = inst_71141__$1);

return statearr_71240;
})();
if(cljs.core.truth_(inst_71141__$1)){
var statearr_71241_71278 = state_71215__$1;
(statearr_71241_71278[(1)] = (7));

} else {
var statearr_71242_71279 = state_71215__$1;
(statearr_71242_71279[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (23))){
var inst_71195 = (state_71215[(8)]);
var state_71215__$1 = state_71215;
var statearr_71243_71280 = state_71215__$1;
(statearr_71243_71280[(2)] = inst_71195);

(statearr_71243_71280[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (19))){
var inst_71181 = (state_71215[(13)]);
var state_71215__$1 = state_71215;
var statearr_71244_71281 = state_71215__$1;
(statearr_71244_71281[(2)] = inst_71181);

(statearr_71244_71281[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (11))){
var inst_71156 = (state_71215[(14)]);
var inst_71161 = (state_71215[(16)]);
var inst_71162 = (state_71215[(17)]);
var inst_71168 = fluree.db.api.query.block_range.call(null,inst_71156,inst_71161,inst_71162,opts);
var state_71215__$1 = state_71215;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71215__$1,(14),inst_71168);
} else {
if((state_val_71216 === (9))){
var inst_71143 = (state_71215[(15)]);
var inst_71150 = (state_71215[(2)]);
var inst_71151 = [inst_71150];
var inst_71152 = cljs.core.PersistentHashMap.fromArrays(inst_71143,inst_71151);
var inst_71153 = fluree.db.api.query.db.call(null,conn,ledger,inst_71152);
var state_71215__$1 = state_71215;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71215__$1,(6),inst_71153);
} else {
if((state_val_71216 === (5))){
var _ = (function (){var statearr_71246 = state_71215;
(statearr_71246[(4)] = cljs.core.rest.call(null,(state_71215[(4)])));

return statearr_71246;
})();
var state_71215__$1 = state_71215;
var ex71245 = (state_71215__$1[(2)]);
var statearr_71247_71282 = state_71215__$1;
(statearr_71247_71282[(5)] = ex71245);


if((ex71245 instanceof Error)){
var statearr_71248_71283 = state_71215__$1;
(statearr_71248_71283[(1)] = (4));

(statearr_71248_71283[(5)] = null);

} else {
throw ex71245;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (14))){
var inst_71170 = (state_71215[(2)]);
var inst_71171 = fluree.db.util.async.throw_err.call(null,inst_71170);
var state_71215__$1 = state_71215;
var statearr_71249_71284 = state_71215__$1;
(statearr_71249_71284[(2)] = inst_71171);

(statearr_71249_71284[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (26))){
var inst_71195 = (state_71215[(8)]);
var state_71215__$1 = state_71215;
var statearr_71250_71285 = state_71215__$1;
(statearr_71250_71285[(2)] = inst_71195);

(statearr_71250_71285[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (16))){
var inst_71140 = (state_71215[(12)]);
var inst_71185 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_71140);
var state_71215__$1 = state_71215;
var statearr_71251_71286 = state_71215__$1;
(statearr_71251_71286[(2)] = inst_71185);

(statearr_71251_71286[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (10))){
var inst_71140 = (state_71215[(12)]);
var inst_71159 = (state_71215[(2)]);
var inst_71160 = fluree.db.util.async.throw_err.call(null,inst_71159);
var inst_71161 = cljs.core.nth.call(null,inst_71160,(0),null);
var inst_71162 = cljs.core.nth.call(null,inst_71160,(1),null);
var inst_71163 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_71164 = cljs.core.dissoc.call(null,inst_71140,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_71165 = cljs.core.keys.call(null,inst_71164);
var inst_71166 = cljs.core._EQ_.call(null,inst_71163,inst_71165);
var state_71215__$1 = (function (){var statearr_71252 = state_71215;
(statearr_71252[(16)] = inst_71161);

(statearr_71252[(17)] = inst_71162);

return statearr_71252;
})();
if(inst_71166){
var statearr_71253_71287 = state_71215__$1;
(statearr_71253_71287[(1)] = (11));

} else {
var statearr_71254_71288 = state_71215__$1;
(statearr_71254_71288[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71216 === (18))){
var inst_71156 = (state_71215[(14)]);
var inst_71181 = (state_71215[(13)]);
var inst_71189 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_71156,inst_71181);
var state_71215__$1 = state_71215;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71215__$1,(21),inst_71189);
} else {
if((state_val_71216 === (8))){
var state_71215__$1 = state_71215;
var statearr_71255_71289 = state_71215__$1;
(statearr_71255_71289[(2)] = null);

(statearr_71255_71289[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__10945__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__10945__auto____0 = (function (){
var statearr_71256 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71256[(0)] = fluree$db$api$query$block_query_async_$_state_machine__10945__auto__);

(statearr_71256[(1)] = (1));

return statearr_71256;
});
var fluree$db$api$query$block_query_async_$_state_machine__10945__auto____1 = (function (state_71215){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_71215);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e71257){var ex__10948__auto__ = e71257;
var statearr_71258_71290 = state_71215;
(statearr_71258_71290[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_71215[(4)]))){
var statearr_71259_71291 = state_71215;
(statearr_71259_71291[(1)] = cljs.core.first.call(null,(state_71215[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71292 = state_71215;
state_71215 = G__71292;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__10945__auto__ = function(state_71215){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__10945__auto____1.call(this,state_71215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__10945__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__10945__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_71260 = f__11019__auto__.call(null);
(statearr_71260[(6)] = c__11018__auto__);

return statearr_71260;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__71293 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__71293,(0),null);
var p = cljs.core.nth.call(null,vec__71293,(1),null);
var o = cljs.core.nth.call(null,vec__71293,(2),null);
var t = cljs.core.nth.call(null,vec__71293,(3),null);
var vec__71296 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__71296,(0),null);
var idx = cljs.core.nth.call(null,vec__71296,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__71299 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__71299,(0),null);
var id = cljs.core.nth.call(null,vec__71299,(1),null);
var or__5045__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5774__auto__ = [];
var len__5768__auto___71303 = arguments.length;
var i__5769__auto___71304 = (0);
while(true){
if((i__5769__auto___71304 < len__5768__auto___71303)){
args__5774__auto__.push((arguments[i__5769__auto___71304]));

var G__71305 = (i__5769__auto___71304 + (1));
i__5769__auto___71304 = G__71305;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq71302){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq71302));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_71501){
var state_val_71502 = (state_71501[(1)]);
if((state_val_71502 === (7))){
var inst_71421 = (state_71501[(7)]);
var inst_71428 = (state_71501[(8)]);
var inst_71427 = cljs.core.seq.call(null,inst_71421);
var inst_71428__$1 = cljs.core.first.call(null,inst_71427);
var inst_71429 = cljs.core.next.call(null,inst_71427);
var state_71501__$1 = (function (){var statearr_71503 = state_71501;
(statearr_71503[(9)] = inst_71429);

(statearr_71503[(8)] = inst_71428__$1);

return statearr_71503;
})();
if(cljs.core.truth_(inst_71428__$1)){
var statearr_71504_71604 = state_71501__$1;
(statearr_71504_71604[(1)] = (9));

} else {
var statearr_71505_71605 = state_71501__$1;
(statearr_71505_71605[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (20))){
var inst_71491 = (state_71501[(2)]);
var state_71501__$1 = state_71501;
var statearr_71506_71606 = state_71501__$1;
(statearr_71506_71606[(2)] = inst_71491);

(statearr_71506_71606[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (27))){
var inst_71467 = (state_71501[(10)]);
var inst_71449 = (state_71501[(11)]);
var inst_71446 = (state_71501[(12)]);
var inst_71469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71470 = [inst_71449,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_71471 = (new cljs.core.PersistentVector(null,2,(5),inst_71469,inst_71470,null));
var inst_71472 = cljs.core.update_in.call(null,inst_71467,inst_71471,fluree.db.api.query.min_safe,inst_71446);
var state_71501__$1 = state_71501;
var statearr_71507_71607 = state_71501__$1;
(statearr_71507_71607[(2)] = inst_71472);

(statearr_71507_71607[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (1))){
var state_71501__$1 = state_71501;
var statearr_71508_71608 = state_71501__$1;
(statearr_71508_71608[(2)] = null);

(statearr_71508_71608[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (24))){
var inst_71428 = (state_71501[(8)]);
var inst_71449 = (state_71501[(11)]);
var inst_71459 = (state_71501[(13)]);
var inst_71461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71462 = [inst_71449,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_71463 = (new cljs.core.PersistentVector(null,2,(5),inst_71461,inst_71462,null));
var inst_71464 = cljs.core.update_in.call(null,inst_71459,inst_71463,cljs.core.conj,inst_71428);
var state_71501__$1 = state_71501;
var statearr_71510_71609 = state_71501__$1;
(statearr_71510_71609[(2)] = inst_71464);

(statearr_71510_71609[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (4))){
var inst_71307 = (state_71501[(2)]);
var state_71501__$1 = state_71501;
var statearr_71511_71610 = state_71501__$1;
(statearr_71511_71610[(2)] = inst_71307);

(statearr_71511_71610[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (15))){
var inst_71422 = (state_71501[(14)]);
var inst_71429 = (state_71501[(9)]);
var tmp71509 = inst_71422;
var inst_71421 = inst_71429;
var inst_71422__$1 = tmp71509;
var state_71501__$1 = (function (){var statearr_71512 = state_71501;
(statearr_71512[(14)] = inst_71422__$1);

(statearr_71512[(7)] = inst_71421);

return statearr_71512;
})();
var statearr_71513_71611 = state_71501__$1;
(statearr_71513_71611[(2)] = null);

(statearr_71513_71611[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (21))){
var inst_71422 = (state_71501[(14)]);
var inst_71449 = (state_71501[(11)]);
var inst_71453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71454 = [inst_71449,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_71455 = (new cljs.core.PersistentVector(null,2,(5),inst_71453,inst_71454,null));
var inst_71456 = cljs.core.assoc_in.call(null,inst_71422,inst_71455,inst_71449);
var state_71501__$1 = state_71501;
var statearr_71514_71612 = state_71501__$1;
(statearr_71514_71612[(2)] = inst_71456);

(statearr_71514_71612[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (31))){
var inst_71475 = (state_71501[(15)]);
var state_71501__$1 = state_71501;
var statearr_71515_71613 = state_71501__$1;
(statearr_71515_71613[(2)] = inst_71475);

(statearr_71515_71613[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (32))){
var inst_71429 = (state_71501[(9)]);
var inst_71483 = (state_71501[(2)]);
var inst_71421 = inst_71429;
var inst_71422 = inst_71483;
var state_71501__$1 = (function (){var statearr_71516 = state_71501;
(statearr_71516[(14)] = inst_71422);

(statearr_71516[(7)] = inst_71421);

return statearr_71516;
})();
var statearr_71517_71614 = state_71501__$1;
(statearr_71517_71614[(2)] = null);

(statearr_71517_71614[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (33))){
var inst_71422 = (state_71501[(14)]);
var state_71501__$1 = state_71501;
var statearr_71518_71615 = state_71501__$1;
(statearr_71518_71615[(2)] = inst_71422);

(statearr_71518_71615[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (13))){
var inst_71431 = (state_71501[(16)]);
var state_71501__$1 = state_71501;
var statearr_71519_71616 = state_71501__$1;
(statearr_71519_71616[(2)] = inst_71431);

(statearr_71519_71616[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (22))){
var inst_71422 = (state_71501[(14)]);
var state_71501__$1 = state_71501;
var statearr_71520_71617 = state_71501__$1;
(statearr_71520_71617[(2)] = inst_71422);

(statearr_71520_71617[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (29))){
var inst_71475 = (state_71501[(2)]);
var state_71501__$1 = (function (){var statearr_71521 = state_71501;
(statearr_71521[(15)] = inst_71475);

return statearr_71521;
})();
if(cljs.core.truth_(show_auth)){
var statearr_71522_71618 = state_71501__$1;
(statearr_71522_71618[(1)] = (30));

} else {
var statearr_71523_71619 = state_71501__$1;
(statearr_71523_71619[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (6))){
var inst_71407 = (state_71501[(2)]);
var inst_71408 = fluree.db.util.async.throw_err.call(null,inst_71407);
var inst_71416 = resp;
var inst_71417 = cljs.core.seq.call(null,inst_71416);
var inst_71418 = cljs.core.first.call(null,inst_71417);
var inst_71419 = cljs.core.next.call(null,inst_71417);
var inst_71420 = cljs.core.PersistentHashMap.EMPTY;
var inst_71421 = inst_71416;
var inst_71422 = inst_71420;
var state_71501__$1 = (function (){var statearr_71524 = state_71501;
(statearr_71524[(14)] = inst_71422);

(statearr_71524[(7)] = inst_71421);

(statearr_71524[(17)] = inst_71419);

(statearr_71524[(18)] = inst_71408);

(statearr_71524[(19)] = inst_71418);

return statearr_71524;
})();
var statearr_71525_71620 = state_71501__$1;
(statearr_71525_71620[(2)] = null);

(statearr_71525_71620[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (28))){
var inst_71467 = (state_71501[(10)]);
var state_71501__$1 = state_71501;
var statearr_71526_71621 = state_71501__$1;
(statearr_71526_71621[(2)] = inst_71467);

(statearr_71526_71621[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (25))){
var inst_71459 = (state_71501[(13)]);
var state_71501__$1 = state_71501;
var statearr_71527_71622 = state_71501__$1;
(statearr_71527_71622[(2)] = inst_71459);

(statearr_71527_71622[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (34))){
var state_71501__$1 = state_71501;
var statearr_71528_71623 = state_71501__$1;
(statearr_71528_71623[(2)] = null);

(statearr_71528_71623[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (17))){
var inst_71493 = (state_71501[(2)]);
var state_71501__$1 = state_71501;
var statearr_71529_71624 = state_71501__$1;
(statearr_71529_71624[(2)] = inst_71493);

(statearr_71529_71624[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (3))){
var inst_71499 = (state_71501[(2)]);
var state_71501__$1 = state_71501;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71501__$1,inst_71499);
} else {
if((state_val_71502 === (12))){
var inst_71428 = (state_71501[(8)]);
var inst_71408 = (state_71501[(18)]);
var inst_71433 = fluree.db.api.query.auth_match.call(null,auth,inst_71408,inst_71428);
var inst_71434 = cljs.core.not.call(null,inst_71433);
var state_71501__$1 = state_71501;
var statearr_71530_71625 = state_71501__$1;
(statearr_71530_71625[(2)] = inst_71434);

(statearr_71530_71625[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (2))){
var _ = (function (){var statearr_71531 = state_71501;
(statearr_71531[(4)] = cljs.core.cons.call(null,(5),(state_71501[(4)])));

return statearr_71531;
})();
var inst_71313 = (function (){return (function (p1__71306_SHARP_){
return p1__71306_SHARP_.t;
});
})();
var inst_71314 = cljs.core.map.call(null,inst_71313,resp);
var inst_71315 = cljs.core.set.call(null,inst_71314);
var inst_71403 = cljs.core.async.chan.call(null,(1));
var inst_71404 = (function (){var ts = inst_71315;
var c__11018__auto____$1 = inst_71403;
return (function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_71401){
var state_val_71402 = (state_71401[(1)]);
if((state_val_71402 === (7))){
var inst_71347 = (state_71401[(7)]);
var inst_71329 = (state_71401[(8)]);
var inst_71335 = (state_71401[(9)]);
var inst_71341 = (state_71401[(10)]);
var inst_71340 = (state_71401[(2)]);
var inst_71341__$1 = fluree.db.util.async.throw_err.call(null,inst_71340);
var inst_71343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71344 = [inst_71335,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_71345 = (new cljs.core.PersistentVector(null,2,(5),inst_71343,inst_71344,null));
var inst_71346 = cljs.core.assoc_in.call(null,inst_71329,inst_71345,inst_71341__$1);
var inst_71347__$1 = auth;
var state_71401__$1 = (function (){var statearr_71532 = state_71401;
(statearr_71532[(7)] = inst_71347__$1);

(statearr_71532[(11)] = inst_71346);

(statearr_71532[(10)] = inst_71341__$1);

return statearr_71532;
})();
if(cljs.core.truth_(inst_71347__$1)){
var statearr_71533_71626 = state_71401__$1;
(statearr_71533_71626[(1)] = (8));

} else {
var statearr_71534_71627 = state_71401__$1;
(statearr_71534_71627[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71402 === (1))){
var inst_71323 = (state_71401[(12)]);
var inst_71323__$1 = ts;
var inst_71324 = cljs.core.seq.call(null,inst_71323__$1);
var inst_71325 = cljs.core.first.call(null,inst_71324);
var inst_71326 = cljs.core.next.call(null,inst_71324);
var inst_71327 = cljs.core.PersistentHashMap.EMPTY;
var inst_71328 = inst_71323__$1;
var inst_71329 = inst_71327;
var state_71401__$1 = (function (){var statearr_71535 = state_71401;
(statearr_71535[(13)] = inst_71328);

(statearr_71535[(14)] = inst_71325);

(statearr_71535[(8)] = inst_71329);

(statearr_71535[(12)] = inst_71323__$1);

(statearr_71535[(15)] = inst_71326);

return statearr_71535;
})();
var statearr_71536_71628 = state_71401__$1;
(statearr_71536_71628[(2)] = null);

(statearr_71536_71628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71402 === (4))){
var inst_71335 = (state_71401[(9)]);
var inst_71338 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_71335);
var state_71401__$1 = state_71401;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71401__$1,(7),inst_71338);
} else {
if((state_val_71402 === (13))){
var inst_71336 = (state_71401[(16)]);
var inst_71393 = (state_71401[(2)]);
var inst_71328 = inst_71336;
var inst_71329 = inst_71393;
var state_71401__$1 = (function (){var statearr_71537 = state_71401;
(statearr_71537[(13)] = inst_71328);

(statearr_71537[(8)] = inst_71329);

return statearr_71537;
})();
var statearr_71538_71629 = state_71401__$1;
(statearr_71538_71629[(2)] = null);

(statearr_71538_71629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71402 === (6))){
var inst_71397 = (state_71401[(2)]);
var state_71401__$1 = state_71401;
var statearr_71539_71630 = state_71401__$1;
(statearr_71539_71630[(2)] = inst_71397);

(statearr_71539_71630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71402 === (3))){
var inst_71399 = (state_71401[(2)]);
var state_71401__$1 = state_71401;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71401__$1,inst_71399);
} else {
if((state_val_71402 === (12))){
var inst_71346 = (state_71401[(11)]);
var state_71401__$1 = state_71401;
var statearr_71540_71631 = state_71401__$1;
(statearr_71540_71631[(2)] = inst_71346);

(statearr_71540_71631[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71402 === (2))){
var inst_71328 = (state_71401[(13)]);
var inst_71335 = (state_71401[(9)]);
var inst_71334 = cljs.core.seq.call(null,inst_71328);
var inst_71335__$1 = cljs.core.first.call(null,inst_71334);
var inst_71336 = cljs.core.next.call(null,inst_71334);
var state_71401__$1 = (function (){var statearr_71541 = state_71401;
(statearr_71541[(9)] = inst_71335__$1);

(statearr_71541[(16)] = inst_71336);

return statearr_71541;
})();
if(cljs.core.truth_(inst_71335__$1)){
var statearr_71542_71632 = state_71401__$1;
(statearr_71542_71632[(1)] = (4));

} else {
var statearr_71543_71633 = state_71401__$1;
(statearr_71543_71633[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71402 === (11))){
var inst_71328 = (state_71401[(13)]);
var inst_71325 = (state_71401[(14)]);
var inst_71329 = (state_71401[(8)]);
var inst_71323 = (state_71401[(12)]);
var inst_71335 = (state_71401[(9)]);
var inst_71346 = (state_71401[(11)]);
var inst_71336 = (state_71401[(16)]);
var inst_71326 = (state_71401[(15)]);
var inst_71341 = (state_71401[(10)]);
var inst_71353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71354 = [inst_71335,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_71355 = (new cljs.core.PersistentVector(null,2,(5),inst_71353,inst_71354,null));
var inst_71368 = cljs.core.async.chan.call(null,(1));
var inst_71369 = (function (){var t = inst_71335;
var vec__71331 = inst_71328;
var vec__71320 = inst_71323;
var block = inst_71341;
var r = inst_71336;
var G__71342 = inst_71346;
var seq__71332 = inst_71336;
var acc = inst_71329;
var seq__71321 = inst_71326;
var first__71333 = inst_71335;
var first__71322 = inst_71325;
var c__11018__auto____$2 = inst_71368;
var G__71319 = inst_71328;
return (function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_71366){
var state_val_71367 = (state_71366[(1)]);
if((state_val_71367 === (1))){
var state_71366__$1 = state_71366;
var statearr_71544_71634 = state_71366__$1;
(statearr_71544_71634[(2)] = null);

(statearr_71544_71634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71367 === (2))){
var ___$1 = (function (){var statearr_71545 = state_71366;
(statearr_71545[(4)] = cljs.core.cons.call(null,(5),(state_71366[(4)])));

return statearr_71545;
})();
var ___$2 = (function (){var statearr_71546 = state_71366;
(statearr_71546[(4)] = cljs.core.rest.call(null,(state_71366[(4)])));

return statearr_71546;
})();
var state_71366__$1 = state_71366;
var statearr_71547_71635 = state_71366__$1;
(statearr_71547_71635[(2)] = db);

(statearr_71547_71635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71367 === (3))){
var inst_71364 = (state_71366[(2)]);
var state_71366__$1 = state_71366;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71366__$1,inst_71364);
} else {
if((state_val_71367 === (4))){
var inst_71356 = (state_71366[(2)]);
var state_71366__$1 = state_71366;
var statearr_71549_71636 = state_71366__$1;
(statearr_71549_71636[(2)] = inst_71356);

(statearr_71549_71636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71367 === (5))){
var ___$1 = (function (){var statearr_71550 = state_71366;
(statearr_71550[(4)] = cljs.core.rest.call(null,(state_71366[(4)])));

return statearr_71550;
})();
var state_71366__$1 = state_71366;
var ex71548 = (state_71366__$1[(2)]);
var statearr_71551_71637 = state_71366__$1;
(statearr_71551_71637[(5)] = ex71548);


if((ex71548 instanceof Error)){
var statearr_71552_71638 = state_71366__$1;
(statearr_71552_71638[(1)] = (4));

(statearr_71552_71638[(5)] = null);

} else {
throw ex71548;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____0 = (function (){
var statearr_71553 = [null,null,null,null,null,null,null];
(statearr_71553[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__);

(statearr_71553[(1)] = (1));

return statearr_71553;
});
var fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____1 = (function (state_71366){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_71366);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e71554){var ex__10948__auto__ = e71554;
var statearr_71555_71639 = state_71366;
(statearr_71555_71639[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_71366[(4)]))){
var statearr_71556_71640 = state_71366;
(statearr_71556_71640[(1)] = cljs.core.first.call(null,(state_71366[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71641 = state_71366;
state_71366 = G__71641;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__ = function(state_71366){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____1.call(this,state_71366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_71557 = f__11019__auto__.call(null);
(statearr_71557[(6)] = c__11018__auto____$2);

return statearr_71557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
});
})();
var inst_71370 = cljs.core.async.impl.dispatch.run.call(null,inst_71369);
var inst_71371 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_71372 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71373 = ["?auth","?id"];
var inst_71374 = (new cljs.core.PersistentVector(null,2,(5),inst_71372,inst_71373,null));
var inst_71375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71377 = [inst_71335,"_tx/auth","?auth"];
var inst_71378 = (new cljs.core.PersistentVector(null,3,(5),inst_71376,inst_71377,null));
var inst_71379 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71380 = ["?auth","_auth/id","?id"];
var inst_71381 = (new cljs.core.PersistentVector(null,3,(5),inst_71379,inst_71380,null));
var inst_71382 = [inst_71378,inst_71381];
var inst_71383 = (new cljs.core.PersistentVector(null,2,(5),inst_71375,inst_71382,null));
var inst_71384 = [inst_71374,inst_71383];
var inst_71385 = cljs.core.PersistentHashMap.fromArrays(inst_71371,inst_71384);
var inst_71386 = fluree.db.api.query.query_async.call(null,inst_71368,inst_71385);
var state_71401__$1 = (function (){var statearr_71558 = state_71401;
(statearr_71558[(17)] = inst_71370);

(statearr_71558[(18)] = inst_71355);

return statearr_71558;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71401__$1,(14),inst_71386);
} else {
if((state_val_71402 === (9))){
var state_71401__$1 = state_71401;
var statearr_71559_71642 = state_71401__$1;
(statearr_71559_71642[(2)] = show_auth);

(statearr_71559_71642[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71402 === (5))){
var inst_71329 = (state_71401[(8)]);
var state_71401__$1 = state_71401;
var statearr_71560_71643 = state_71401__$1;
(statearr_71560_71643[(2)] = inst_71329);

(statearr_71560_71643[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71402 === (14))){
var inst_71346 = (state_71401[(11)]);
var inst_71355 = (state_71401[(18)]);
var inst_71388 = (state_71401[(2)]);
var inst_71389 = fluree.db.util.async.throw_err.call(null,inst_71388);
var inst_71390 = cljs.core.assoc_in.call(null,inst_71346,inst_71355,inst_71389);
var state_71401__$1 = state_71401;
var statearr_71561_71644 = state_71401__$1;
(statearr_71561_71644[(2)] = inst_71390);

(statearr_71561_71644[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71402 === (10))){
var inst_71351 = (state_71401[(2)]);
var state_71401__$1 = state_71401;
if(cljs.core.truth_(inst_71351)){
var statearr_71562_71645 = state_71401__$1;
(statearr_71562_71645[(1)] = (11));

} else {
var statearr_71563_71646 = state_71401__$1;
(statearr_71563_71646[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71402 === (8))){
var inst_71347 = (state_71401[(7)]);
var state_71401__$1 = state_71401;
var statearr_71564_71647 = state_71401__$1;
(statearr_71564_71647[(2)] = inst_71347);

(statearr_71564_71647[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____0 = (function (){
var statearr_71565 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71565[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__);

(statearr_71565[(1)] = (1));

return statearr_71565;
});
var fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____1 = (function (state_71401){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_71401);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e71566){var ex__10948__auto__ = e71566;
var statearr_71567_71648 = state_71401;
(statearr_71567_71648[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_71401[(4)]))){
var statearr_71568_71649 = state_71401;
(statearr_71568_71649[(1)] = cljs.core.first.call(null,(state_71401[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71650 = state_71401;
state_71401 = G__71650;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__ = function(state_71401){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____1.call(this,state_71401);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_71569 = f__11019__auto__.call(null);
(statearr_71569[(6)] = c__11018__auto____$1);

return statearr_71569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
});
})();
var inst_71405 = cljs.core.async.impl.dispatch.run.call(null,inst_71404);
var state_71501__$1 = (function (){var statearr_71570 = state_71501;
(statearr_71570[(20)] = inst_71405);

return statearr_71570;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71501__$1,(6),inst_71403);
} else {
if((state_val_71502 === (23))){
var inst_71459 = (state_71501[(2)]);
var state_71501__$1 = (function (){var statearr_71571 = state_71501;
(statearr_71571[(13)] = inst_71459);

return statearr_71571;
})();
var statearr_71572_71651 = state_71501__$1;
(statearr_71572_71651[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (35))){
var inst_71489 = (state_71501[(2)]);
var state_71501__$1 = state_71501;
var statearr_71574_71652 = state_71501__$1;
(statearr_71574_71652[(2)] = inst_71489);

(statearr_71574_71652[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (19))){
var state_71501__$1 = state_71501;
var statearr_71575_71653 = state_71501__$1;
(statearr_71575_71653[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (11))){
var inst_71440 = (state_71501[(2)]);
var state_71501__$1 = state_71501;
if(cljs.core.truth_(inst_71440)){
var statearr_71578_71654 = state_71501__$1;
(statearr_71578_71654[(1)] = (15));

} else {
var statearr_71579_71655 = state_71501__$1;
(statearr_71579_71655[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (9))){
var inst_71431 = (state_71501[(16)]);
var inst_71431__$1 = auth;
var state_71501__$1 = (function (){var statearr_71580 = state_71501;
(statearr_71580[(16)] = inst_71431__$1);

return statearr_71580;
})();
if(cljs.core.truth_(inst_71431__$1)){
var statearr_71581_71656 = state_71501__$1;
(statearr_71581_71656[(1)] = (12));

} else {
var statearr_71582_71657 = state_71501__$1;
(statearr_71582_71657[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (5))){
var _ = (function (){var statearr_71583 = state_71501;
(statearr_71583[(4)] = cljs.core.rest.call(null,(state_71501[(4)])));

return statearr_71583;
})();
var state_71501__$1 = state_71501;
var ex71577 = (state_71501__$1[(2)]);
var statearr_71584_71658 = state_71501__$1;
(statearr_71584_71658[(5)] = ex71577);


if((ex71577 instanceof Error)){
var statearr_71585_71659 = state_71501__$1;
(statearr_71585_71659[(1)] = (4));

(statearr_71585_71659[(5)] = null);

} else {
throw ex71577;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (14))){
var inst_71437 = (state_71501[(2)]);
var state_71501__$1 = state_71501;
var statearr_71586_71660 = state_71501__$1;
(statearr_71586_71660[(2)] = inst_71437);

(statearr_71586_71660[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (26))){
var inst_71467 = (state_71501[(2)]);
var state_71501__$1 = (function (){var statearr_71587 = state_71501;
(statearr_71587[(10)] = inst_71467);

return statearr_71587;
})();
var statearr_71588_71661 = state_71501__$1;
(statearr_71588_71661[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (16))){
var inst_71428 = (state_71501[(8)]);
var state_71501__$1 = state_71501;
if(cljs.core.truth_(inst_71428)){
var statearr_71590_71662 = state_71501__$1;
(statearr_71590_71662[(1)] = (18));

} else {
var statearr_71591_71663 = state_71501__$1;
(statearr_71591_71663[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (30))){
var inst_71450 = (state_71501[(21)]);
var inst_71449 = (state_71501[(11)]);
var inst_71475 = (state_71501[(15)]);
var inst_71477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71478 = [inst_71449,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_71479 = (new cljs.core.PersistentVector(null,2,(5),inst_71477,inst_71478,null));
var inst_71480 = cljs.core.assoc_in.call(null,inst_71475,inst_71479,inst_71450);
var state_71501__$1 = state_71501;
var statearr_71592_71664 = state_71501__$1;
(statearr_71592_71664[(2)] = inst_71480);

(statearr_71592_71664[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (10))){
var inst_71428 = (state_71501[(8)]);
var state_71501__$1 = state_71501;
var statearr_71593_71665 = state_71501__$1;
(statearr_71593_71665[(2)] = inst_71428);

(statearr_71593_71665[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (18))){
var inst_71428 = (state_71501[(8)]);
var inst_71408 = (state_71501[(18)]);
var inst_71446 = (state_71501[(12)]);
var inst_71446__$1 = inst_71428.t;
var inst_71447 = cljs.core.get.call(null,inst_71408,inst_71446__$1);
var inst_71448 = cljs.core.__destructure_map.call(null,inst_71447);
var inst_71449 = cljs.core.get.call(null,inst_71448,new cljs.core.Keyword(null,"block","block",664686210));
var inst_71450 = cljs.core.get.call(null,inst_71448,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_71501__$1 = (function (){var statearr_71594 = state_71501;
(statearr_71594[(21)] = inst_71450);

(statearr_71594[(11)] = inst_71449);

(statearr_71594[(12)] = inst_71446__$1);

return statearr_71594;
})();
var statearr_71595_71666 = state_71501__$1;
(statearr_71595_71666[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71502 === (8))){
var inst_71495 = (state_71501[(2)]);
var inst_71496 = cljs.core.vals.call(null,inst_71495);
var _ = (function (){var statearr_71597 = state_71501;
(statearr_71597[(4)] = cljs.core.rest.call(null,(state_71501[(4)])));

return statearr_71597;
})();
var state_71501__$1 = state_71501;
var statearr_71598_71667 = state_71501__$1;
(statearr_71598_71667[(2)] = inst_71496);

(statearr_71598_71667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____0 = (function (){
var statearr_71599 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71599[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__);

(statearr_71599[(1)] = (1));

return statearr_71599;
});
var fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____1 = (function (state_71501){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_71501);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e71600){var ex__10948__auto__ = e71600;
var statearr_71601_71668 = state_71501;
(statearr_71601_71668[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_71501[(4)]))){
var statearr_71602_71669 = state_71501;
(statearr_71602_71669[(1)] = cljs.core.first.call(null,(state_71501[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71670 = state_71501;
state_71501 = G__71670;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__ = function(state_71501){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____1.call(this,state_71501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__10945__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_71603 = f__11019__auto__.call(null);
(statearr_71603[(6)] = c__11018__auto__);

return statearr_71603;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.call(null,(function (block){
return cljs.core.assoc.call(null,block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.call(null,cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_71797){
var state_val_71798 = (state_71797[(1)]);
if((state_val_71798 === (7))){
var inst_71693 = (state_71797[(7)]);
var inst_71695 = fluree.db.api.query.resolve_block_range.call(null,inst_71693,query_map);
var state_71797__$1 = state_71797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71797__$1,(10),inst_71695);
} else {
if((state_val_71798 === (20))){
var inst_71722 = (state_71797[(2)]);
var inst_71723 = fluree.db.util.async.throw_err.call(null,inst_71722);
var inst_71724 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_71723);
var inst_71725 = (inst_71724 - (1));
var state_71797__$1 = state_71797;
var statearr_71799_71862 = state_71797__$1;
(statearr_71799_71862[(2)] = inst_71725);

(statearr_71799_71862[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (27))){
var state_71797__$1 = state_71797;
var statearr_71800_71863 = state_71797__$1;
(statearr_71800_71863[(2)] = null);

(statearr_71800_71863[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (1))){
var state_71797__$1 = state_71797;
var statearr_71801_71864 = state_71797__$1;
(statearr_71801_71864[(2)] = null);

(statearr_71801_71864[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (24))){
var inst_71732 = (state_71797[(2)]);
var inst_71733 = fluree.db.util.async.throw_err.call(null,inst_71732);
var inst_71734 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_71733);
var state_71797__$1 = state_71797;
var statearr_71802_71865 = state_71797__$1;
(statearr_71802_71865[(2)] = inst_71734);

(statearr_71802_71865[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (39))){
var inst_71769 = (state_71797[(2)]);
var inst_71770 = fluree.db.util.async.throw_err.call(null,inst_71769);
var state_71797__$1 = state_71797;
var statearr_71803_71866 = state_71797__$1;
(statearr_71803_71866[(2)] = inst_71770);

(statearr_71803_71866[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (4))){
var inst_71671 = (state_71797[(2)]);
var state_71797__$1 = state_71797;
var statearr_71804_71867 = state_71797__$1;
(statearr_71804_71867[(2)] = inst_71671);

(statearr_71804_71867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (15))){
var inst_71702 = (state_71797[(8)]);
var state_71797__$1 = state_71797;
var statearr_71805_71868 = state_71797__$1;
(statearr_71805_71868[(2)] = inst_71702);

(statearr_71805_71868[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (21))){
var inst_71703 = (state_71797[(9)]);
var inst_71693 = (state_71797[(7)]);
var inst_71730 = fluree.db.time_travel.as_of_block.call(null,inst_71693,inst_71703);
var state_71797__$1 = state_71797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71797__$1,(24),inst_71730);
} else {
if((state_val_71798 === (31))){
var inst_71687 = (state_71797[(10)]);
var state_71797__$1 = state_71797;
var statearr_71806_71869 = state_71797__$1;
(statearr_71806_71869[(2)] = inst_71687);

(statearr_71806_71869[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (32))){
var inst_71748 = (state_71797[(11)]);
var inst_71753 = (state_71797[(12)]);
var inst_71693 = (state_71797[(7)]);
var inst_71757 = (state_71797[(2)]);
var inst_71758 = fluree.db.api.query.format_history_resp.call(null,inst_71693,inst_71748,inst_71753,inst_71757);
var state_71797__$1 = state_71797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71797__$1,(29),inst_71758);
} else {
if((state_val_71798 === (40))){
var inst_71774 = (state_71797[(13)]);
var inst_71748 = (state_71797[(11)]);
var inst_71776 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_71777 = cljs.core.count.call(null,inst_71748);
var inst_71778 = [inst_71774,inst_71777,(200)];
var inst_71779 = cljs.core.PersistentHashMap.fromArrays(inst_71776,inst_71778);
var state_71797__$1 = state_71797;
var statearr_71807_71870 = state_71797__$1;
(statearr_71807_71870[(2)] = inst_71779);

(statearr_71807_71870[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (33))){
var inst_71686 = (state_71797[(14)]);
var state_71797__$1 = state_71797;
var statearr_71808_71871 = state_71797__$1;
(statearr_71808_71871[(2)] = inst_71686);

(statearr_71808_71871[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (13))){
var inst_71792 = (state_71797[(2)]);
var _ = (function (){var statearr_71809 = state_71797;
(statearr_71809[(4)] = cljs.core.rest.call(null,(state_71797[(4)])));

return statearr_71809;
})();
var state_71797__$1 = state_71797;
var statearr_71810_71872 = state_71797__$1;
(statearr_71810_71872[(2)] = inst_71792);

(statearr_71810_71872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (22))){
var inst_71693 = (state_71797[(7)]);
var inst_71736 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_71693);
var state_71797__$1 = state_71797;
var statearr_71811_71873 = state_71797__$1;
(statearr_71811_71873[(2)] = inst_71736);

(statearr_71811_71873[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (36))){
var inst_71693 = (state_71797[(7)]);
var inst_71761 = (state_71797[(15)]);
var inst_71767 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_71693,inst_71761);
var state_71797__$1 = state_71797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71797__$1,(39),inst_71767);
} else {
if((state_val_71798 === (41))){
var inst_71774 = (state_71797[(13)]);
var state_71797__$1 = state_71797;
var statearr_71812_71874 = state_71797__$1;
(statearr_71812_71874[(2)] = inst_71774);

(statearr_71812_71874[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (29))){
var inst_71686 = (state_71797[(14)]);
var inst_71760 = (state_71797[(2)]);
var inst_71761 = fluree.db.util.async.throw_err.call(null,inst_71760);
var state_71797__$1 = (function (){var statearr_71813 = state_71797;
(statearr_71813[(15)] = inst_71761);

return statearr_71813;
})();
if(cljs.core.truth_(inst_71686)){
var statearr_71814_71875 = state_71797__$1;
(statearr_71814_71875[(1)] = (33));

} else {
var statearr_71815_71876 = state_71797__$1;
(statearr_71815_71876[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (6))){
var inst_71683 = (state_71797[(16)]);
var inst_71692 = (state_71797[(2)]);
var inst_71693 = fluree.db.util.async.throw_err.call(null,inst_71692);
var state_71797__$1 = (function (){var statearr_71816 = state_71797;
(statearr_71816[(7)] = inst_71693);

return statearr_71816;
})();
if(cljs.core.truth_(inst_71683)){
var statearr_71817_71877 = state_71797__$1;
(statearr_71817_71877[(1)] = (7));

} else {
var statearr_71818_71878 = state_71797__$1;
(statearr_71818_71878[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (28))){
var inst_71688 = (state_71797[(17)]);
var inst_71753 = (state_71797[(2)]);
var state_71797__$1 = (function (){var statearr_71819 = state_71797;
(statearr_71819[(12)] = inst_71753);

return statearr_71819;
})();
if(cljs.core.truth_(inst_71688)){
var statearr_71820_71879 = state_71797__$1;
(statearr_71820_71879[(1)] = (30));

} else {
var statearr_71821_71880 = state_71797__$1;
(statearr_71821_71880[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (25))){
var inst_71689 = (state_71797[(18)]);
var inst_71747 = (state_71797[(2)]);
var inst_71748 = fluree.db.util.async.throw_err.call(null,inst_71747);
var state_71797__$1 = (function (){var statearr_71822 = state_71797;
(statearr_71822[(11)] = inst_71748);

return statearr_71822;
})();
if(cljs.core.truth_(inst_71689)){
var statearr_71823_71881 = state_71797__$1;
(statearr_71823_71881[(1)] = (26));

} else {
var statearr_71824_71882 = state_71797__$1;
(statearr_71824_71882[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (34))){
var inst_71685 = (state_71797[(19)]);
var state_71797__$1 = state_71797;
var statearr_71825_71883 = state_71797__$1;
(statearr_71825_71883[(2)] = inst_71685);

(statearr_71825_71883[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (17))){
var inst_71702 = (state_71797[(8)]);
var inst_71693 = (state_71797[(7)]);
var inst_71719 = (inst_71702 - (1));
var inst_71720 = fluree.db.time_travel.as_of_block.call(null,inst_71693,inst_71719);
var state_71797__$1 = state_71797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71797__$1,(20),inst_71720);
} else {
if((state_val_71798 === (3))){
var inst_71795 = (state_71797[(2)]);
var state_71797__$1 = state_71797;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71797__$1,inst_71795);
} else {
if((state_val_71798 === (12))){
var inst_71784 = cljs.core.pr_str.call(null,query_map);
var inst_71785 = ["History query not properly formatted. Provided ",inst_71784].join('');
var inst_71786 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71787 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71788 = cljs.core.PersistentHashMap.fromArrays(inst_71786,inst_71787);
var inst_71789 = cljs.core.ex_info.call(null,inst_71785,inst_71788);
var inst_71790 = (function(){throw inst_71789})();
var state_71797__$1 = state_71797;
var statearr_71826_71884 = state_71797__$1;
(statearr_71826_71884[(2)] = inst_71790);

(statearr_71826_71884[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (2))){
var _ = (function (){var statearr_71827 = state_71797;
(statearr_71827[(4)] = cljs.core.cons.call(null,(5),(state_71797[(4)])));

return statearr_71827;
})();
var inst_71681 = query_map;
var inst_71682 = cljs.core.__destructure_map.call(null,inst_71681);
var inst_71683 = cljs.core.get.call(null,inst_71682,new cljs.core.Keyword(null,"block","block",664686210));
var inst_71684 = cljs.core.get.call(null,inst_71682,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_71685 = cljs.core.get.call(null,inst_71682,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_71686 = cljs.core.get.call(null,inst_71682,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_71687 = cljs.core.get.call(null,inst_71682,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_71688 = cljs.core.get.call(null,inst_71682,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_71689 = cljs.core.get.call(null,inst_71682,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_71690 = cljs.core.get.call(null,inst_71682,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_71797__$1 = (function (){var statearr_71828 = state_71797;
(statearr_71828[(19)] = inst_71685);

(statearr_71828[(17)] = inst_71688);

(statearr_71828[(20)] = inst_71690);

(statearr_71828[(16)] = inst_71683);

(statearr_71828[(10)] = inst_71687);

(statearr_71828[(18)] = inst_71689);

(statearr_71828[(21)] = inst_71684);

(statearr_71828[(14)] = inst_71686);

return statearr_71828;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71797__$1,(6),sources);
} else {
if((state_val_71798 === (23))){
var inst_71728 = (state_71797[(22)]);
var inst_71684 = (state_71797[(21)]);
var inst_71693 = (state_71797[(7)]);
var inst_71738 = (state_71797[(2)]);
var inst_71739 = fluree.db.api.query.get_history_pattern.call(null,inst_71684);
var inst_71740 = cljs.core.nth.call(null,inst_71739,(0),null);
var inst_71741 = cljs.core.nth.call(null,inst_71739,(1),null);
var inst_71742 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_71743 = [inst_71728,inst_71738];
var inst_71744 = cljs.core.PersistentHashMap.fromArrays(inst_71742,inst_71743);
var inst_71745 = fluree.db.query.range.time_range.call(null,inst_71693,inst_71741,cljs.core._EQ_,inst_71740,inst_71744);
var state_71797__$1 = state_71797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71797__$1,(25),inst_71745);
} else {
if((state_val_71798 === (35))){
var inst_71765 = (state_71797[(2)]);
var state_71797__$1 = state_71797;
if(cljs.core.truth_(inst_71765)){
var statearr_71829_71885 = state_71797__$1;
(statearr_71829_71885[(1)] = (36));

} else {
var statearr_71830_71886 = state_71797__$1;
(statearr_71830_71886[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (19))){
var inst_71703 = (state_71797[(9)]);
var inst_71728 = (state_71797[(2)]);
var state_71797__$1 = (function (){var statearr_71831 = state_71797;
(statearr_71831[(22)] = inst_71728);

return statearr_71831;
})();
if(cljs.core.truth_(inst_71703)){
var statearr_71832_71887 = state_71797__$1;
(statearr_71832_71887[(1)] = (21));

} else {
var statearr_71833_71888 = state_71797__$1;
(statearr_71833_71888[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (11))){
var inst_71690 = (state_71797[(20)]);
var inst_71702 = (state_71797[(8)]);
var inst_71712 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_71690);
var state_71797__$1 = (function (){var statearr_71835 = state_71797;
(statearr_71835[(23)] = inst_71712);

return statearr_71835;
})();
if(cljs.core.truth_(inst_71702)){
var statearr_71836_71889 = state_71797__$1;
(statearr_71836_71889[(1)] = (14));

} else {
var statearr_71837_71890 = state_71797__$1;
(statearr_71837_71890[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (9))){
var inst_71701 = (state_71797[(2)]);
var inst_71702 = cljs.core.nth.call(null,inst_71701,(0),null);
var inst_71703 = cljs.core.nth.call(null,inst_71701,(1),null);
var inst_71704 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_71705 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_71706 = cljs.core.keys.call(null,inst_71705);
var inst_71707 = cljs.core._EQ_.call(null,inst_71704,inst_71706);
var state_71797__$1 = (function (){var statearr_71838 = state_71797;
(statearr_71838[(9)] = inst_71703);

(statearr_71838[(8)] = inst_71702);

return statearr_71838;
})();
if(inst_71707){
var statearr_71839_71891 = state_71797__$1;
(statearr_71839_71891[(1)] = (11));

} else {
var statearr_71840_71892 = state_71797__$1;
(statearr_71840_71892[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (5))){
var _ = (function (){var statearr_71841 = state_71797;
(statearr_71841[(4)] = cljs.core.rest.call(null,(state_71797[(4)])));

return statearr_71841;
})();
var state_71797__$1 = state_71797;
var ex71834 = (state_71797__$1[(2)]);
var statearr_71842_71893 = state_71797__$1;
(statearr_71842_71893[(5)] = ex71834);


if((ex71834 instanceof Error)){
var statearr_71843_71894 = state_71797__$1;
(statearr_71843_71894[(1)] = (4));

(statearr_71843_71894[(5)] = null);

} else {
throw ex71834;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (14))){
var inst_71702 = (state_71797[(8)]);
var inst_71714 = cljs.core.not_EQ_.call(null,(1),inst_71702);
var state_71797__$1 = state_71797;
var statearr_71844_71895 = state_71797__$1;
(statearr_71844_71895[(2)] = inst_71714);

(statearr_71844_71895[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (26))){
var inst_71689 = (state_71797[(18)]);
var inst_71750 = cljs.core.set.call(null,inst_71689);
var state_71797__$1 = state_71797;
var statearr_71845_71896 = state_71797__$1;
(statearr_71845_71896[(2)] = inst_71750);

(statearr_71845_71896[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (16))){
var inst_71717 = (state_71797[(2)]);
var state_71797__$1 = state_71797;
if(cljs.core.truth_(inst_71717)){
var statearr_71846_71897 = state_71797__$1;
(statearr_71846_71897[(1)] = (17));

} else {
var statearr_71847_71898 = state_71797__$1;
(statearr_71847_71898[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (38))){
var inst_71712 = (state_71797[(23)]);
var inst_71774 = (state_71797[(2)]);
var state_71797__$1 = (function (){var statearr_71848 = state_71797;
(statearr_71848[(13)] = inst_71774);

return statearr_71848;
})();
if(cljs.core.truth_(inst_71712)){
var statearr_71849_71899 = state_71797__$1;
(statearr_71849_71899[(1)] = (40));

} else {
var statearr_71850_71900 = state_71797__$1;
(statearr_71850_71900[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (30))){
var inst_71688 = (state_71797[(17)]);
var state_71797__$1 = state_71797;
var statearr_71851_71901 = state_71797__$1;
(statearr_71851_71901[(2)] = inst_71688);

(statearr_71851_71901[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (10))){
var inst_71697 = (state_71797[(2)]);
var inst_71698 = fluree.db.util.async.throw_err.call(null,inst_71697);
var state_71797__$1 = state_71797;
var statearr_71852_71902 = state_71797__$1;
(statearr_71852_71902[(2)] = inst_71698);

(statearr_71852_71902[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (18))){
var state_71797__$1 = state_71797;
var statearr_71853_71903 = state_71797__$1;
(statearr_71853_71903[(2)] = (-1));

(statearr_71853_71903[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (42))){
var inst_71782 = (state_71797[(2)]);
var state_71797__$1 = state_71797;
var statearr_71854_71904 = state_71797__$1;
(statearr_71854_71904[(2)] = inst_71782);

(statearr_71854_71904[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (37))){
var inst_71761 = (state_71797[(15)]);
var inst_71772 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_71761);
var state_71797__$1 = state_71797;
var statearr_71855_71905 = state_71797__$1;
(statearr_71855_71905[(2)] = inst_71772);

(statearr_71855_71905[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71798 === (8))){
var state_71797__$1 = state_71797;
var statearr_71856_71906 = state_71797__$1;
(statearr_71856_71906[(2)] = null);

(statearr_71856_71906[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__10945__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__10945__auto____0 = (function (){
var statearr_71857 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71857[(0)] = fluree$db$api$query$history_query_async_$_state_machine__10945__auto__);

(statearr_71857[(1)] = (1));

return statearr_71857;
});
var fluree$db$api$query$history_query_async_$_state_machine__10945__auto____1 = (function (state_71797){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_71797);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e71858){var ex__10948__auto__ = e71858;
var statearr_71859_71907 = state_71797;
(statearr_71859_71907[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_71797[(4)]))){
var statearr_71860_71908 = state_71797;
(statearr_71860_71908[(1)] = cljs.core.first.call(null,(state_71797[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71909 = state_71797;
state_71797 = G__71909;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__10945__auto__ = function(state_71797){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__10945__auto____1.call(this,state_71797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__10945__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__10945__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_71861 = f__11019__auto__.call(null);
(statearr_71861[(6)] = c__11018__auto__);

return statearr_71861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_72042){
var state_val_72043 = (state_72042[(1)]);
if((state_val_72043 === (7))){
var inst_71939 = cljs.core.pr_str.call(null,flureeQL);
var inst_71940 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_71939].join('');
var inst_71941 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71942 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71943 = cljs.core.PersistentHashMap.fromArrays(inst_71941,inst_71942);
var inst_71944 = cljs.core.ex_info.call(null,inst_71940,inst_71943);
var inst_71945 = (function(){throw inst_71944})();
var state_72042__$1 = state_72042;
var statearr_72044_72123 = state_72042__$1;
(statearr_72044_72123[(2)] = inst_71945);

(statearr_72044_72123[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (20))){
var inst_71977 = (state_72042[(2)]);
var state_72042__$1 = state_72042;
if(cljs.core.truth_(inst_71977)){
var statearr_72045_72124 = state_72042__$1;
(statearr_72045_72124[(1)] = (21));

} else {
var statearr_72046_72125 = state_72042__$1;
(statearr_72046_72125[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (27))){
var inst_71921 = (state_72042[(7)]);
var state_72042__$1 = state_72042;
var statearr_72047_72126 = state_72042__$1;
(statearr_72047_72126[(2)] = inst_71921);

(statearr_72047_72126[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (1))){
var state_72042__$1 = state_72042;
var statearr_72048_72127 = state_72042__$1;
(statearr_72048_72127[(2)] = null);

(statearr_72048_72127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (24))){
var inst_71983 = (state_72042[(8)]);
var state_72042__$1 = state_72042;
var statearr_72049_72128 = state_72042__$1;
(statearr_72049_72128[(2)] = inst_71983);

(statearr_72049_72128[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (39))){
var inst_71927 = (state_72042[(9)]);
var state_72042__$1 = state_72042;
if(cljs.core.truth_(inst_71927)){
var statearr_72050_72129 = state_72042__$1;
(statearr_72050_72129[(1)] = (42));

} else {
var statearr_72051_72130 = state_72042__$1;
(statearr_72051_72130[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (46))){
var inst_72015 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72016 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72017 = cljs.core.PersistentHashMap.fromArrays(inst_72015,inst_72016);
var inst_72018 = cljs.core.ex_info.call(null,"Invalid query.",inst_72017);
var inst_72019 = (function(){throw inst_72018})();
var state_72042__$1 = state_72042;
var statearr_72052_72131 = state_72042__$1;
(statearr_72052_72131[(2)] = inst_72019);

(statearr_72052_72131[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (4))){
var inst_71911 = (state_72042[(2)]);
var state_72042__$1 = state_72042;
var statearr_72053_72132 = state_72042__$1;
(statearr_72053_72132[(2)] = inst_71911);

(statearr_72053_72132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (15))){
var inst_71962 = (state_72042[(10)]);
var inst_71924 = (state_72042[(11)]);
var inst_71964 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_71962);
var inst_71965 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_71962);
var inst_71966 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_71962);
var inst_71967 = fluree.db.api.query.get_sources.call(null,inst_71964,inst_71965,inst_71966,inst_71924);
var state_72042__$1 = state_72042;
var statearr_72054_72133 = state_72042__$1;
(statearr_72054_72133[(2)] = inst_71967);

(statearr_72054_72133[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (48))){
var inst_71972 = (state_72042[(12)]);
var inst_72026 = (state_72042[(2)]);
var inst_72027 = fluree.db.util.async.throw_err.call(null,inst_72026);
var state_72042__$1 = (function (){var statearr_72055 = state_72042;
(statearr_72055[(13)] = inst_72027);

return statearr_72055;
})();
if(cljs.core.truth_(inst_71972)){
var statearr_72056_72134 = state_72042__$1;
(statearr_72056_72134[(1)] = (49));

} else {
var statearr_72057_72135 = state_72042__$1;
(statearr_72057_72135[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (50))){
var inst_72027 = (state_72042[(13)]);
var state_72042__$1 = state_72042;
var statearr_72058_72136 = state_72042__$1;
(statearr_72058_72136[(2)] = inst_72027);

(statearr_72058_72136[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (21))){
var inst_71979 = cljs.core.volatile_BANG_.call(null,(0));
var state_72042__$1 = state_72042;
var statearr_72059_72137 = state_72042__$1;
(statearr_72059_72137[(2)] = inst_71979);

(statearr_72059_72137[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (31))){
var inst_71925 = (state_72042[(14)]);
var state_72042__$1 = state_72042;
if(cljs.core.truth_(inst_71925)){
var statearr_72060_72138 = state_72042__$1;
(statearr_72060_72138[(1)] = (33));

} else {
var statearr_72061_72139 = state_72042__$1;
(statearr_72061_72139[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (32))){
var inst_72002 = (state_72042[(2)]);
var state_72042__$1 = state_72042;
var statearr_72062_72140 = state_72042__$1;
(statearr_72062_72140[(2)] = inst_72002);

(statearr_72062_72140[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (40))){
var inst_72004 = (state_72042[(15)]);
var state_72042__$1 = state_72042;
var statearr_72063_72141 = state_72042__$1;
(statearr_72063_72141[(2)] = inst_72004);

(statearr_72063_72141[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (33))){
var inst_71925 = (state_72042[(14)]);
var state_72042__$1 = state_72042;
var statearr_72064_72142 = state_72042__$1;
(statearr_72064_72142[(2)] = inst_71925);

(statearr_72064_72142[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (13))){
var inst_71922 = (state_72042[(16)]);
var inst_71951 = (state_72042[(2)]);
var inst_71952 = fluree.db.util.async.throw_err.call(null,inst_71951);
var inst_71953 = fluree.db.time_travel.as_of_block.call(null,inst_71952,inst_71922);
var state_72042__$1 = state_72042;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72042__$1,(12),inst_71953);
} else {
if((state_val_72043 === (22))){
var state_72042__$1 = state_72042;
var statearr_72065_72143 = state_72042__$1;
(statearr_72065_72143[(2)] = null);

(statearr_72065_72143[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (36))){
var inst_71929 = (state_72042[(17)]);
var state_72042__$1 = state_72042;
var statearr_72066_72144 = state_72042__$1;
(statearr_72066_72144[(2)] = inst_71929);

(statearr_72066_72144[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (41))){
var inst_72012 = (state_72042[(2)]);
var state_72042__$1 = state_72042;
if(cljs.core.truth_(inst_72012)){
var statearr_72067_72145 = state_72042__$1;
(statearr_72067_72145[(1)] = (45));

} else {
var statearr_72068_72146 = state_72042__$1;
(statearr_72068_72146[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (43))){
var inst_71923 = (state_72042[(18)]);
var state_72042__$1 = state_72042;
var statearr_72069_72147 = state_72042__$1;
(statearr_72069_72147[(2)] = inst_71923);

(statearr_72069_72147[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (29))){
var inst_72004 = (state_72042[(15)]);
var inst_72004__$1 = (state_72042[(2)]);
var state_72042__$1 = (function (){var statearr_72070 = state_72042;
(statearr_72070[(15)] = inst_72004__$1);

return statearr_72070;
})();
if(cljs.core.truth_(inst_72004__$1)){
var statearr_72071_72148 = state_72042__$1;
(statearr_72071_72148[(1)] = (39));

} else {
var statearr_72072_72149 = state_72042__$1;
(statearr_72072_72149[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (44))){
var inst_72009 = (state_72042[(2)]);
var state_72042__$1 = state_72042;
var statearr_72073_72150 = state_72042__$1;
(statearr_72073_72150[(2)] = inst_72009);

(statearr_72073_72150[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (6))){
var state_72042__$1 = state_72042;
var statearr_72074_72151 = state_72042__$1;
(statearr_72074_72151[(2)] = null);

(statearr_72074_72151[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (28))){
var inst_71926 = (state_72042[(19)]);
var state_72042__$1 = state_72042;
if(cljs.core.truth_(inst_71926)){
var statearr_72075_72152 = state_72042__$1;
(statearr_72075_72152[(1)] = (30));

} else {
var statearr_72076_72153 = state_72042__$1;
(statearr_72076_72153[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (51))){
var inst_72037 = (state_72042[(2)]);
var _ = (function (){var statearr_72077 = state_72042;
(statearr_72077[(4)] = cljs.core.rest.call(null,(state_72042[(4)])));

return statearr_72077;
})();
var state_72042__$1 = state_72042;
var statearr_72078_72154 = state_72042__$1;
(statearr_72078_72154[(2)] = inst_72037);

(statearr_72078_72154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (25))){
var state_72042__$1 = state_72042;
var statearr_72079_72155 = state_72042__$1;
(statearr_72079_72155[(2)] = (1000000));

(statearr_72079_72155[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (34))){
var inst_71929 = (state_72042[(17)]);
var state_72042__$1 = state_72042;
if(cljs.core.truth_(inst_71929)){
var statearr_72080_72156 = state_72042__$1;
(statearr_72080_72156[(1)] = (36));

} else {
var statearr_72081_72157 = state_72042__$1;
(statearr_72081_72157[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (17))){
var inst_71973 = (state_72042[(20)]);
var inst_71928 = (state_72042[(21)]);
var inst_71971 = (state_72042[(2)]);
var inst_71972 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_71928);
var inst_71973__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_71928);
var state_72042__$1 = (function (){var statearr_72082 = state_72042;
(statearr_72082[(20)] = inst_71973__$1);

(statearr_72082[(22)] = inst_71971);

(statearr_72082[(12)] = inst_71972);

return statearr_72082;
})();
if(cljs.core.truth_(inst_71973__$1)){
var statearr_72083_72158 = state_72042__$1;
(statearr_72083_72158[(1)] = (18));

} else {
var statearr_72084_72159 = state_72042__$1;
(statearr_72084_72159[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (3))){
var inst_72040 = (state_72042[(2)]);
var state_72042__$1 = state_72042;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72042__$1,inst_72040);
} else {
if((state_val_72043 === (12))){
var inst_71955 = (state_72042[(2)]);
var inst_71956 = fluree.db.util.async.throw_err.call(null,inst_71955);
var state_72042__$1 = state_72042;
var statearr_72085_72160 = state_72042__$1;
(statearr_72085_72160[(2)] = inst_71956);

(statearr_72085_72160[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (2))){
var inst_71924 = (state_72042[(11)]);
var inst_71926 = (state_72042[(19)]);
var inst_71927 = (state_72042[(9)]);
var inst_71929 = (state_72042[(17)]);
var inst_71928 = (state_72042[(21)]);
var inst_71923 = (state_72042[(18)]);
var inst_71922 = (state_72042[(16)]);
var inst_71920 = (state_72042[(23)]);
var inst_71921 = (state_72042[(7)]);
var inst_71925 = (state_72042[(14)]);
var _ = (function (){var statearr_72086 = state_72042;
(statearr_72086[(4)] = cljs.core.cons.call(null,(5),(state_72042[(4)])));

return statearr_72086;
})();
var inst_71918 = flureeQL;
var inst_71919 = cljs.core.__destructure_map.call(null,inst_71918);
var inst_71920__$1 = cljs.core.get.call(null,inst_71919,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_71921__$1 = cljs.core.get.call(null,inst_71919,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_71922__$1 = cljs.core.get.call(null,inst_71919,new cljs.core.Keyword(null,"block","block",664686210));
var inst_71923__$1 = cljs.core.get.call(null,inst_71919,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_71924__$1 = cljs.core.get.call(null,inst_71919,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_71925__$1 = cljs.core.get.call(null,inst_71919,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_71926__$1 = cljs.core.get.call(null,inst_71919,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_71927__$1 = cljs.core.get.call(null,inst_71919,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_71928__$1 = cljs.core.get.call(null,inst_71919,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_71929__$1 = cljs.core.get.call(null,inst_71919,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_71930 = (function (){var construct = inst_71920__$1;
var select = inst_71921__$1;
var map__71917 = inst_71919;
var block = inst_71922__$1;
var where = inst_71923__$1;
var prefixes = inst_71924__$1;
var selectDistinct = inst_71925__$1;
var selectOne = inst_71926__$1;
var from = inst_71927__$1;
var opts = inst_71928__$1;
var selectReduced = inst_71929__$1;
return (function (p1__71910_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__71910_SHARP_);
});
})();
var inst_71931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71932 = [inst_71921__$1,inst_71926__$1,inst_71925__$1,inst_71929__$1];
var inst_71933 = (new cljs.core.PersistentVector(null,4,(5),inst_71931,inst_71932,null));
var inst_71934 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_71933);
var inst_71935 = cljs.core.count.call(null,inst_71934);
var inst_71936 = inst_71930.call(null,inst_71935);
var state_72042__$1 = (function (){var statearr_72087 = state_72042;
(statearr_72087[(11)] = inst_71924__$1);

(statearr_72087[(19)] = inst_71926__$1);

(statearr_72087[(9)] = inst_71927__$1);

(statearr_72087[(17)] = inst_71929__$1);

(statearr_72087[(21)] = inst_71928__$1);

(statearr_72087[(18)] = inst_71923__$1);

(statearr_72087[(16)] = inst_71922__$1);

(statearr_72087[(23)] = inst_71920__$1);

(statearr_72087[(7)] = inst_71921__$1);

(statearr_72087[(14)] = inst_71925__$1);

return statearr_72087;
})();
if(cljs.core.truth_(inst_71936)){
var statearr_72088_72161 = state_72042__$1;
(statearr_72088_72161[(1)] = (6));

} else {
var statearr_72089_72162 = state_72042__$1;
(statearr_72089_72162[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (23))){
var inst_71928 = (state_72042[(21)]);
var inst_71983 = (state_72042[(8)]);
var inst_71982 = (state_72042[(2)]);
var inst_71983__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_71928);
var state_72042__$1 = (function (){var statearr_72090 = state_72042;
(statearr_72090[(8)] = inst_71983__$1);

(statearr_72090[(24)] = inst_71982);

return statearr_72090;
})();
if(cljs.core.truth_(inst_71983__$1)){
var statearr_72091_72163 = state_72042__$1;
(statearr_72091_72163[(1)] = (24));

} else {
var statearr_72092_72164 = state_72042__$1;
(statearr_72092_72164[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (47))){
var inst_71962 = (state_72042[(10)]);
var inst_71988 = (state_72042[(25)]);
var inst_72021 = (state_72042[(2)]);
var inst_72022 = fluree.db.util.core.current_time_millis.call(null);
var inst_72023 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_71988);
var inst_72024 = fluree.db.query.fql.query.call(null,inst_71962,inst_72023);
var state_72042__$1 = (function (){var statearr_72093 = state_72042;
(statearr_72093[(26)] = inst_72022);

(statearr_72093[(27)] = inst_72021);

return statearr_72093;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72042__$1,(48),inst_72024);
} else {
if((state_val_72043 === (35))){
var inst_72000 = (state_72042[(2)]);
var state_72042__$1 = state_72042;
var statearr_72094_72165 = state_72042__$1;
(statearr_72094_72165[(2)] = inst_72000);

(statearr_72094_72165[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (19))){
var inst_71972 = (state_72042[(12)]);
var state_72042__$1 = state_72042;
var statearr_72095_72166 = state_72042__$1;
(statearr_72095_72166[(2)] = inst_71972);

(statearr_72095_72166[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (11))){
var inst_71924 = (state_72042[(11)]);
var inst_71962 = (state_72042[(2)]);
var state_72042__$1 = (function (){var statearr_72097 = state_72042;
(statearr_72097[(10)] = inst_71962);

return statearr_72097;
})();
if(cljs.core.truth_(inst_71924)){
var statearr_72098_72167 = state_72042__$1;
(statearr_72098_72167[(1)] = (15));

} else {
var statearr_72099_72168 = state_72042__$1;
(statearr_72099_72168[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (9))){
var inst_71948 = (state_72042[(28)]);
var state_72042__$1 = state_72042;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72042__$1,(13),inst_71948);
} else {
if((state_val_72043 === (5))){
var _ = (function (){var statearr_72100 = state_72042;
(statearr_72100[(4)] = cljs.core.rest.call(null,(state_72042[(4)])));

return statearr_72100;
})();
var state_72042__$1 = state_72042;
var ex72096 = (state_72042__$1[(2)]);
var statearr_72101_72169 = state_72042__$1;
(statearr_72101_72169[(5)] = ex72096);


if((ex72096 instanceof Error)){
var statearr_72102_72170 = state_72042__$1;
(statearr_72102_72170[(1)] = (4));

(statearr_72102_72170[(5)] = null);

} else {
throw ex72096;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (14))){
var inst_71959 = (state_72042[(2)]);
var inst_71960 = fluree.db.util.async.throw_err.call(null,inst_71959);
var state_72042__$1 = state_72042;
var statearr_72103_72171 = state_72042__$1;
(statearr_72103_72171[(2)] = inst_71960);

(statearr_72103_72171[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (45))){
var state_72042__$1 = state_72042;
var statearr_72104_72172 = state_72042__$1;
(statearr_72104_72172[(2)] = null);

(statearr_72104_72172[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (26))){
var inst_71928 = (state_72042[(21)]);
var inst_71971 = (state_72042[(22)]);
var inst_71921 = (state_72042[(7)]);
var inst_71982 = (state_72042[(24)]);
var inst_71987 = (state_72042[(2)]);
var inst_71988 = cljs.core.assoc.call(null,inst_71928,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_71971,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_71987,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_71982);
var state_72042__$1 = (function (){var statearr_72105 = state_72042;
(statearr_72105[(25)] = inst_71988);

return statearr_72105;
})();
if(cljs.core.truth_(inst_71921)){
var statearr_72106_72173 = state_72042__$1;
(statearr_72106_72173[(1)] = (27));

} else {
var statearr_72107_72174 = state_72042__$1;
(statearr_72107_72174[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (16))){
var inst_71969 = cljs.core.PersistentHashMap.EMPTY;
var state_72042__$1 = state_72042;
var statearr_72108_72175 = state_72042__$1;
(statearr_72108_72175[(2)] = inst_71969);

(statearr_72108_72175[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (38))){
var inst_71998 = (state_72042[(2)]);
var state_72042__$1 = state_72042;
var statearr_72109_72176 = state_72042__$1;
(statearr_72109_72176[(2)] = inst_71998);

(statearr_72109_72176[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (30))){
var inst_71926 = (state_72042[(19)]);
var state_72042__$1 = state_72042;
var statearr_72110_72177 = state_72042__$1;
(statearr_72110_72177[(2)] = inst_71926);

(statearr_72110_72177[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (10))){
var inst_71948 = (state_72042[(28)]);
var state_72042__$1 = state_72042;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72042__$1,(14),inst_71948);
} else {
if((state_val_72043 === (18))){
var inst_71973 = (state_72042[(20)]);
var state_72042__$1 = state_72042;
var statearr_72111_72178 = state_72042__$1;
(statearr_72111_72178[(2)] = inst_71973);

(statearr_72111_72178[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (42))){
var inst_71927 = (state_72042[(9)]);
var state_72042__$1 = state_72042;
var statearr_72112_72179 = state_72042__$1;
(statearr_72112_72179[(2)] = inst_71927);

(statearr_72112_72179[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (37))){
var inst_71920 = (state_72042[(23)]);
var state_72042__$1 = state_72042;
var statearr_72113_72180 = state_72042__$1;
(statearr_72113_72180[(2)] = inst_71920);

(statearr_72113_72180[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (8))){
var inst_71922 = (state_72042[(16)]);
var inst_71947 = (state_72042[(2)]);
var inst_71948 = sources;
var state_72042__$1 = (function (){var statearr_72114 = state_72042;
(statearr_72114[(29)] = inst_71947);

(statearr_72114[(28)] = inst_71948);

return statearr_72114;
})();
if(cljs.core.truth_(inst_71922)){
var statearr_72115_72181 = state_72042__$1;
(statearr_72115_72181[(1)] = (9));

} else {
var statearr_72116_72182 = state_72042__$1;
(statearr_72116_72182[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72043 === (49))){
var inst_71962 = (state_72042[(10)]);
var inst_72022 = (state_72042[(26)]);
var inst_71982 = (state_72042[(24)]);
var inst_72027 = (state_72042[(13)]);
var inst_72029 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_72030 = cljs.core.deref.call(null,inst_71982);
var inst_72031 = fluree.db.util.core.response_time_formatted.call(null,inst_72022);
var inst_72032 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_71962);
var inst_72033 = [(200),inst_72027,inst_72030,inst_72031,inst_72032];
var inst_72034 = cljs.core.PersistentHashMap.fromArrays(inst_72029,inst_72033);
var state_72042__$1 = state_72042;
var statearr_72117_72183 = state_72042__$1;
(statearr_72117_72183[(2)] = inst_72034);

(statearr_72117_72183[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__10945__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__10945__auto____0 = (function (){
var statearr_72118 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72118[(0)] = fluree$db$api$query$query_async_$_state_machine__10945__auto__);

(statearr_72118[(1)] = (1));

return statearr_72118;
});
var fluree$db$api$query$query_async_$_state_machine__10945__auto____1 = (function (state_72042){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_72042);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e72119){var ex__10948__auto__ = e72119;
var statearr_72120_72184 = state_72042;
(statearr_72120_72184[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_72042[(4)]))){
var statearr_72121_72185 = state_72042;
(statearr_72121_72185[(1)] = cljs.core.first.call(null,(state_72042[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72186 = state_72042;
state_72042 = G__72186;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__10945__auto__ = function(state_72042){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__10945__auto____1.call(this,state_72042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__10945__auto____0;
fluree$db$api$query$query_async_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__10945__auto____1;
return fluree$db$api$query$query_async_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_72122 = f__11019__auto__.call(null);
(statearr_72122[(6)] = c__11018__auto__);

return statearr_72122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_72327){
var state_val_72328 = (state_72327[(1)]);
if((state_val_72328 === (7))){
var inst_72322 = (state_72327[(2)]);
var _ = (function (){var statearr_72329 = state_72327;
(statearr_72329[(4)] = cljs.core.rest.call(null,(state_72327[(4)])));

return statearr_72329;
})();
var state_72327__$1 = state_72327;
var statearr_72330_72406 = state_72327__$1;
(statearr_72330_72406[(2)] = inst_72322);

(statearr_72330_72406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (20))){
var inst_72294 = (state_72327[(2)]);
var state_72327__$1 = state_72327;
var statearr_72331_72407 = state_72327__$1;
(statearr_72331_72407[(2)] = inst_72294);

(statearr_72331_72407[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (27))){
var inst_72274 = (state_72327[(7)]);
var state_72327__$1 = state_72327;
var statearr_72332_72408 = state_72327__$1;
(statearr_72332_72408[(2)] = inst_72274);

(statearr_72332_72408[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (1))){
var state_72327__$1 = state_72327;
var statearr_72333_72409 = state_72327__$1;
(statearr_72333_72409[(2)] = null);

(statearr_72333_72409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (24))){
var inst_72271 = (state_72327[(8)]);
var state_72327__$1 = state_72327;
var statearr_72334_72410 = state_72327__$1;
(statearr_72334_72410[(2)] = inst_72271);

(statearr_72334_72410[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (39))){
var inst_72239 = (state_72327[(9)]);
var inst_72261 = (state_72327[(10)]);
var inst_72228 = (state_72327[(11)]);
var inst_72305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72306 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_72239];
var inst_72307 = (new cljs.core.PersistentVector(null,2,(5),inst_72305,inst_72306,null));
var inst_72308 = cljs.core.assoc_in.call(null,inst_72228,inst_72307,inst_72261);
var state_72327__$1 = state_72327;
var statearr_72335_72411 = state_72327__$1;
(statearr_72335_72411[(2)] = inst_72308);

(statearr_72335_72411[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (4))){
var inst_72187 = (state_72327[(2)]);
var state_72327__$1 = state_72327;
var statearr_72336_72412 = state_72327__$1;
(statearr_72336_72412[(2)] = inst_72187);

(statearr_72336_72412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (15))){
var inst_72261 = (state_72327[(10)]);
var inst_72226 = (state_72327[(12)]);
var inst_72264 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_72261);
var inst_72265 = (inst_72226 == null);
var state_72327__$1 = (function (){var statearr_72337 = state_72327;
(statearr_72337[(13)] = inst_72264);

return statearr_72337;
})();
if(cljs.core.truth_(inst_72265)){
var statearr_72338_72413 = state_72327__$1;
(statearr_72338_72413[(1)] = (18));

} else {
var statearr_72339_72414 = state_72327__$1;
(statearr_72339_72414[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (21))){
var inst_72264 = (state_72327[(13)]);
var state_72327__$1 = state_72327;
var statearr_72340_72415 = state_72327__$1;
(statearr_72340_72415[(2)] = inst_72264);

(statearr_72340_72415[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (31))){
var state_72327__$1 = state_72327;
var statearr_72341_72416 = state_72327__$1;
(statearr_72341_72416[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (32))){
var inst_72290 = (state_72327[(2)]);
var state_72327__$1 = state_72327;
var statearr_72343_72417 = state_72327__$1;
(statearr_72343_72417[(2)] = inst_72290);

(statearr_72343_72417[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (40))){
var inst_72259 = (state_72327[(14)]);
var state_72327__$1 = state_72327;
if(cljs.core.truth_(inst_72259)){
var statearr_72344_72418 = state_72327__$1;
(statearr_72344_72418[(1)] = (42));

} else {
var statearr_72345_72419 = state_72327__$1;
(statearr_72345_72419[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (33))){
var inst_72226 = (state_72327[(12)]);
var inst_72264 = (state_72327[(13)]);
var inst_72285 = ((inst_72264 > inst_72226) ? inst_72264 : inst_72226);
var state_72327__$1 = state_72327;
var statearr_72346_72420 = state_72327__$1;
(statearr_72346_72420[(2)] = inst_72285);

(statearr_72346_72420[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (13))){
var inst_72250 = (state_72327[(2)]);
var state_72327__$1 = state_72327;
var statearr_72347_72421 = state_72327__$1;
(statearr_72347_72421[(2)] = inst_72250);

(statearr_72347_72421[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (22))){
var inst_72271 = (state_72327[(8)]);
var inst_72264 = (state_72327[(13)]);
var inst_72271__$1 = cljs.core._EQ_.call(null,(200),inst_72264);
var state_72327__$1 = (function (){var statearr_72348 = state_72327;
(statearr_72348[(8)] = inst_72271__$1);

return statearr_72348;
})();
if(inst_72271__$1){
var statearr_72349_72422 = state_72327__$1;
(statearr_72349_72422[(1)] = (24));

} else {
var statearr_72350_72423 = state_72327__$1;
(statearr_72350_72423[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (36))){
var inst_72227 = (state_72327[(15)]);
var inst_72261 = (state_72327[(10)]);
var inst_72299 = cljs.core.get.call(null,inst_72261,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_72300 = (inst_72227 + inst_72299);
var state_72327__$1 = state_72327;
var statearr_72351_72424 = state_72327__$1;
(statearr_72351_72424[(2)] = inst_72300);

(statearr_72351_72424[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (41))){
var inst_72238 = (state_72327[(16)]);
var inst_72303 = (state_72327[(17)]);
var inst_72297 = (state_72327[(18)]);
var inst_72317 = (state_72327[(2)]);
var inst_72225 = inst_72238;
var inst_72226 = inst_72297;
var inst_72227 = inst_72303;
var inst_72228 = inst_72317;
var state_72327__$1 = (function (){var statearr_72352 = state_72327;
(statearr_72352[(15)] = inst_72227);

(statearr_72352[(12)] = inst_72226);

(statearr_72352[(11)] = inst_72228);

(statearr_72352[(19)] = inst_72225);

return statearr_72352;
})();
var statearr_72353_72425 = state_72327__$1;
(statearr_72353_72425[(2)] = null);

(statearr_72353_72425[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (43))){
var inst_72261 = (state_72327[(10)]);
var state_72327__$1 = state_72327;
var statearr_72354_72426 = state_72327__$1;
(statearr_72354_72426[(2)] = inst_72261);

(statearr_72354_72426[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (29))){
var inst_72279 = (state_72327[(2)]);
var state_72327__$1 = state_72327;
var statearr_72355_72427 = state_72327__$1;
(statearr_72355_72427[(2)] = inst_72279);

(statearr_72355_72427[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (44))){
var inst_72239 = (state_72327[(9)]);
var inst_72228 = (state_72327[(11)]);
var inst_72314 = (state_72327[(2)]);
var inst_72315 = cljs.core.assoc.call(null,inst_72228,inst_72239,inst_72314);
var state_72327__$1 = state_72327;
var statearr_72356_72428 = state_72327__$1;
(statearr_72356_72428[(2)] = inst_72315);

(statearr_72356_72428[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (6))){
var inst_72240 = (state_72327[(20)]);
var inst_72225 = (state_72327[(19)]);
var inst_72236 = cljs.core.seq.call(null,inst_72225);
var inst_72237 = cljs.core.first.call(null,inst_72236);
var inst_72238 = cljs.core.next.call(null,inst_72236);
var inst_72239 = cljs.core.nth.call(null,inst_72237,(0),null);
var inst_72240__$1 = cljs.core.nth.call(null,inst_72237,(1),null);
var inst_72241 = (inst_72240__$1 == null);
var state_72327__$1 = (function (){var statearr_72357 = state_72327;
(statearr_72357[(16)] = inst_72238);

(statearr_72357[(9)] = inst_72239);

(statearr_72357[(20)] = inst_72240__$1);

return statearr_72357;
})();
if(cljs.core.truth_(inst_72241)){
var statearr_72358_72429 = state_72327__$1;
(statearr_72358_72429[(1)] = (8));

} else {
var statearr_72359_72430 = state_72327__$1;
(statearr_72359_72430[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (28))){
var inst_72226 = (state_72327[(12)]);
var inst_72277 = cljs.core._EQ_.call(null,(207),inst_72226);
var state_72327__$1 = state_72327;
var statearr_72360_72431 = state_72327__$1;
(statearr_72360_72431[(2)] = inst_72277);

(statearr_72360_72431[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (25))){
var inst_72274 = (state_72327[(7)]);
var inst_72226 = (state_72327[(12)]);
var inst_72274__$1 = cljs.core._EQ_.call(null,(200),inst_72226);
var state_72327__$1 = (function (){var statearr_72361 = state_72327;
(statearr_72361[(7)] = inst_72274__$1);

return statearr_72361;
})();
if(inst_72274__$1){
var statearr_72362_72432 = state_72327__$1;
(statearr_72362_72432[(1)] = (27));

} else {
var statearr_72363_72433 = state_72327__$1;
(statearr_72363_72433[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (34))){
var state_72327__$1 = state_72327;
var statearr_72364_72434 = state_72327__$1;
(statearr_72364_72434[(2)] = null);

(statearr_72364_72434[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (17))){
var inst_72258 = (state_72327[(21)]);
var inst_72297 = (state_72327[(2)]);
var state_72327__$1 = (function (){var statearr_72365 = state_72327;
(statearr_72365[(18)] = inst_72297);

return statearr_72365;
})();
if(cljs.core.truth_(inst_72258)){
var statearr_72366_72435 = state_72327__$1;
(statearr_72366_72435[(1)] = (36));

} else {
var statearr_72367_72436 = state_72327__$1;
(statearr_72367_72436[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (3))){
var inst_72325 = (state_72327[(2)]);
var state_72327__$1 = state_72327;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72327__$1,inst_72325);
} else {
if((state_val_72328 === (12))){
var inst_72228 = (state_72327[(11)]);
var state_72327__$1 = state_72327;
var statearr_72368_72437 = state_72327__$1;
(statearr_72368_72437[(2)] = inst_72228);

(statearr_72368_72437[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (2))){
var inst_72197 = (state_72327[(22)]);
var inst_72201 = (state_72327[(23)]);
var inst_72202 = (state_72327[(24)]);
var _ = (function (){var statearr_72369 = state_72327;
(statearr_72369[(4)] = cljs.core.cons.call(null,(5),(state_72327[(4)])));

return statearr_72369;
})();
var inst_72193 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_72194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72195 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_72196 = (new cljs.core.PersistentVector(null,2,(5),inst_72194,inst_72195,null));
var inst_72197__$1 = cljs.core.get_in.call(null,flureeQL,inst_72196);
var inst_72198 = (function (){var global_block = inst_72193;
var global_meta_QMARK_ = inst_72197__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_72199 = cljs.core.PersistentHashMap.EMPTY;
var inst_72200 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_72201__$1 = cljs.core.reduce_kv.call(null,inst_72198,inst_72199,inst_72200);
var inst_72202__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_72204 = (function (){var global_block = inst_72193;
var global_meta_QMARK_ = inst_72197__$1;
var queries = inst_72201__$1;
var start_time = inst_72202__$1;
return (function (p__72203){
var vec__72370 = p__72203;
var alias = cljs.core.nth.call(null,vec__72370,(0),null);
var q = cljs.core.nth.call(null,vec__72370,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_72205 = cljs.core.map.call(null,inst_72204,inst_72201__$1);
var inst_72219 = cljs.core.seq.call(null,inst_72205);
var inst_72220 = cljs.core.first.call(null,inst_72219);
var inst_72221 = cljs.core.next.call(null,inst_72219);
var inst_72222 = cljs.core.nth.call(null,inst_72220,(0),null);
var inst_72223 = cljs.core.nth.call(null,inst_72220,(1),null);
var inst_72224 = cljs.core.PersistentHashMap.EMPTY;
var inst_72225 = inst_72205;
var inst_72226 = null;
var inst_72227 = (0);
var inst_72228 = inst_72224;
var state_72327__$1 = (function (){var statearr_72373 = state_72327;
(statearr_72373[(25)] = inst_72222);

(statearr_72373[(26)] = inst_72221);

(statearr_72373[(15)] = inst_72227);

(statearr_72373[(12)] = inst_72226);

(statearr_72373[(22)] = inst_72197__$1);

(statearr_72373[(23)] = inst_72201__$1);

(statearr_72373[(11)] = inst_72228);

(statearr_72373[(24)] = inst_72202__$1);

(statearr_72373[(27)] = inst_72223);

(statearr_72373[(19)] = inst_72225);

return statearr_72373;
})();
var statearr_72374_72438 = state_72327__$1;
(statearr_72374_72438[(2)] = null);

(statearr_72374_72438[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (23))){
var inst_72292 = (state_72327[(2)]);
var state_72327__$1 = state_72327;
var statearr_72375_72439 = state_72327__$1;
(statearr_72375_72439[(2)] = inst_72292);

(statearr_72375_72439[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (35))){
var inst_72288 = (state_72327[(2)]);
var state_72327__$1 = state_72327;
var statearr_72376_72440 = state_72327__$1;
(statearr_72376_72440[(2)] = inst_72288);

(statearr_72376_72440[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (19))){
var inst_72226 = (state_72327[(12)]);
var inst_72264 = (state_72327[(13)]);
var inst_72268 = cljs.core._EQ_.call(null,inst_72226,inst_72264);
var state_72327__$1 = state_72327;
if(inst_72268){
var statearr_72377_72441 = state_72327__$1;
(statearr_72377_72441[(1)] = (21));

} else {
var statearr_72378_72442 = state_72327__$1;
(statearr_72378_72442[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (11))){
var inst_72227 = (state_72327[(15)]);
var inst_72226 = (state_72327[(12)]);
var inst_72228 = (state_72327[(11)]);
var inst_72202 = (state_72327[(24)]);
var inst_72244 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_72245 = fluree.db.util.core.response_time_formatted.call(null,inst_72202);
var inst_72246 = [inst_72228,inst_72227,inst_72226,inst_72245];
var inst_72247 = cljs.core.PersistentHashMap.fromArrays(inst_72244,inst_72246);
var state_72327__$1 = state_72327;
var statearr_72380_72443 = state_72327__$1;
(statearr_72380_72443[(2)] = inst_72247);

(statearr_72380_72443[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (9))){
var inst_72239 = (state_72327[(9)]);
var inst_72201 = (state_72327[(23)]);
var inst_72240 = (state_72327[(20)]);
var inst_72253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72254 = [inst_72239,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_72255 = (new cljs.core.PersistentVector(null,2,(5),inst_72253,inst_72254,null));
var inst_72256 = cljs.core.get_in.call(null,inst_72201,inst_72255);
var inst_72257 = cljs.core.__destructure_map.call(null,inst_72256);
var inst_72258 = cljs.core.get.call(null,inst_72257,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_72259 = cljs.core.get.call(null,inst_72257,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_72327__$1 = (function (){var statearr_72381 = state_72327;
(statearr_72381[(14)] = inst_72259);

(statearr_72381[(21)] = inst_72258);

return statearr_72381;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72327__$1,(14),inst_72240);
} else {
if((state_val_72328 === (5))){
var _ = (function (){var statearr_72382 = state_72327;
(statearr_72382[(4)] = cljs.core.rest.call(null,(state_72327[(4)])));

return statearr_72382;
})();
var state_72327__$1 = state_72327;
var ex72379 = (state_72327__$1[(2)]);
var statearr_72383_72444 = state_72327__$1;
(statearr_72383_72444[(5)] = ex72379);


var statearr_72384_72445 = state_72327__$1;
(statearr_72384_72445[(1)] = (4));

(statearr_72384_72445[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (14))){
var inst_72261 = (state_72327[(10)]);
var inst_72258 = (state_72327[(21)]);
var inst_72261__$1 = (state_72327[(2)]);
var inst_72262 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_72261__$1);
var state_72327__$1 = (function (){var statearr_72385 = state_72327;
(statearr_72385[(28)] = inst_72262);

(statearr_72385[(10)] = inst_72261__$1);

return statearr_72385;
})();
if(cljs.core.truth_(inst_72258)){
var statearr_72386_72446 = state_72327__$1;
(statearr_72386_72446[(1)] = (15));

} else {
var statearr_72387_72447 = state_72327__$1;
(statearr_72387_72447[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (26))){
var inst_72281 = (state_72327[(2)]);
var state_72327__$1 = state_72327;
if(cljs.core.truth_(inst_72281)){
var statearr_72388_72448 = state_72327__$1;
(statearr_72388_72448[(1)] = (30));

} else {
var statearr_72389_72449 = state_72327__$1;
(statearr_72389_72449[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (16))){
var state_72327__$1 = state_72327;
var statearr_72390_72450 = state_72327__$1;
(statearr_72390_72450[(2)] = null);

(statearr_72390_72450[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (38))){
var inst_72262 = (state_72327[(28)]);
var inst_72303 = (state_72327[(2)]);
var state_72327__$1 = (function (){var statearr_72391 = state_72327;
(statearr_72391[(17)] = inst_72303);

return statearr_72391;
})();
if(cljs.core.truth_(inst_72262)){
var statearr_72392_72451 = state_72327__$1;
(statearr_72392_72451[(1)] = (39));

} else {
var statearr_72393_72452 = state_72327__$1;
(statearr_72393_72452[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (30))){
var state_72327__$1 = state_72327;
var statearr_72394_72453 = state_72327__$1;
(statearr_72394_72453[(2)] = (207));

(statearr_72394_72453[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (10))){
var inst_72320 = (state_72327[(2)]);
var state_72327__$1 = state_72327;
var statearr_72395_72454 = state_72327__$1;
(statearr_72395_72454[(2)] = inst_72320);

(statearr_72395_72454[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (18))){
var inst_72264 = (state_72327[(13)]);
var state_72327__$1 = state_72327;
var statearr_72396_72455 = state_72327__$1;
(statearr_72396_72455[(2)] = inst_72264);

(statearr_72396_72455[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (42))){
var inst_72261 = (state_72327[(10)]);
var inst_72311 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_72261);
var state_72327__$1 = state_72327;
var statearr_72397_72456 = state_72327__$1;
(statearr_72397_72456[(2)] = inst_72311);

(statearr_72397_72456[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (37))){
var state_72327__$1 = state_72327;
var statearr_72398_72457 = state_72327__$1;
(statearr_72398_72457[(2)] = null);

(statearr_72398_72457[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72328 === (8))){
var inst_72197 = (state_72327[(22)]);
var state_72327__$1 = state_72327;
if(cljs.core.truth_(inst_72197)){
var statearr_72399_72458 = state_72327__$1;
(statearr_72399_72458[(1)] = (11));

} else {
var statearr_72400_72459 = state_72327__$1;
(statearr_72400_72459[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__10945__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__10945__auto____0 = (function (){
var statearr_72401 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72401[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__10945__auto__);

(statearr_72401[(1)] = (1));

return statearr_72401;
});
var fluree$db$api$query$multi_query_async_$_state_machine__10945__auto____1 = (function (state_72327){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_72327);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e72402){var ex__10948__auto__ = e72402;
var statearr_72403_72460 = state_72327;
(statearr_72403_72460[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_72327[(4)]))){
var statearr_72404_72461 = state_72327;
(statearr_72404_72461[(1)] = cljs.core.first.call(null,(state_72327[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72462 = state_72327;
state_72327 = G__72462;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__10945__auto__ = function(state_72327){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__10945__auto____1.call(this,state_72327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__10945__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__10945__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_72405 = f__11019__auto__.call(null);
(statearr_72405[(6)] = c__11018__auto__);

return statearr_72405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__72463 = query_type;
var G__72463__$1 = (((G__72463 instanceof cljs.core.Keyword))?G__72463.fqn:null);
switch (G__72463__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__72463__$1)].join('')));

}
});
