// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__5774__auto__ = [];
var len__5768__auto___74289 = arguments.length;
var i__5769__auto___74290 = (0);
while(true){
if((i__5769__auto___74290 < len__5768__auto___74289)){
args__5774__auto__.push((arguments[i__5769__auto___74290]));

var G__74291 = (i__5769__auto___74290 + (1));
i__5769__auto___74290 = G__74291;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((2) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5775__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__74221){
var vec__74222 = p__74221;
var opts = cljs.core.nth.call(null,vec__74222,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__11018__auto___74292 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_74266){
var state_val_74267 = (state_74266[(1)]);
if((state_val_74267 === (7))){
var inst_74243 = (state_74266[(7)]);
var inst_74252 = (state_74266[(8)]);
var inst_74254 = fluree.db.time_travel.as_of_block.call(null,inst_74252,inst_74243);
var state_74266__$1 = state_74266;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74266__$1,(10),inst_74254);
} else {
if((state_val_74267 === (1))){
var state_74266__$1 = state_74266;
var statearr_74268_74293 = state_74266__$1;
(statearr_74268_74293[(2)] = null);

(statearr_74268_74293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74267 === (4))){
var inst_74225 = (state_74266[(2)]);
var inst_74226 = fluree.db.util.log.error.call(null,inst_74225);
var inst_74227 = cljs.core.async.put_BANG_.call(null,pc,inst_74225);
var inst_74228 = cljs.core.async.close_BANG_.call(null,pc);
var state_74266__$1 = (function (){var statearr_74269 = state_74266;
(statearr_74269[(9)] = inst_74226);

(statearr_74269[(10)] = inst_74227);

return statearr_74269;
})();
var statearr_74270_74294 = state_74266__$1;
(statearr_74270_74294[(2)] = inst_74228);

(statearr_74270_74294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74267 === (6))){
var inst_74246 = (state_74266[(11)]);
var inst_74247 = (state_74266[(12)]);
var inst_74243 = (state_74266[(7)]);
var inst_74250 = (state_74266[(2)]);
var inst_74251 = fluree.db.util.async.throw_err.call(null,inst_74250);
var inst_74252 = cljs.core.assoc.call(null,inst_74251,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_74246,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_74247);
var state_74266__$1 = (function (){var statearr_74271 = state_74266;
(statearr_74271[(8)] = inst_74252);

return statearr_74271;
})();
if(cljs.core.truth_(inst_74243)){
var statearr_74272_74295 = state_74266__$1;
(statearr_74272_74295[(1)] = (7));

} else {
var statearr_74273_74296 = state_74266__$1;
(statearr_74273_74296[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74267 === (3))){
var inst_74264 = (state_74266[(2)]);
var state_74266__$1 = state_74266;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74266__$1,inst_74264);
} else {
if((state_val_74267 === (2))){
var _ = (function (){var statearr_74275 = state_74266;
(statearr_74275[(4)] = cljs.core.cons.call(null,(5),(state_74266[(4)])));

return statearr_74275;
})();
var inst_74238 = opts;
var inst_74239 = cljs.core.__destructure_map.call(null,inst_74238);
var inst_74240 = cljs.core.get.call(null,inst_74239,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_74241 = cljs.core.get.call(null,inst_74239,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_74242 = cljs.core.get.call(null,inst_74239,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_74243 = cljs.core.get.call(null,inst_74239,new cljs.core.Keyword(null,"block","block",664686210));
var inst_74244 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_74245 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_74246 = cljs.core.nth.call(null,inst_74245,(0),null);
var inst_74247 = cljs.core.nth.call(null,inst_74245,(1),null);
var inst_74248 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_74266__$1 = (function (){var statearr_74276 = state_74266;
(statearr_74276[(13)] = inst_74240);

(statearr_74276[(11)] = inst_74246);

(statearr_74276[(14)] = inst_74244);

(statearr_74276[(12)] = inst_74247);

(statearr_74276[(7)] = inst_74243);

(statearr_74276[(15)] = inst_74242);

(statearr_74276[(16)] = inst_74241);

return statearr_74276;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74266__$1,(6),inst_74248);
} else {
if((state_val_74267 === (9))){
var inst_74260 = (state_74266[(2)]);
var inst_74261 = cljs.core.async.put_BANG_.call(null,pc,inst_74260);
var _ = (function (){var statearr_74277 = state_74266;
(statearr_74277[(4)] = cljs.core.rest.call(null,(state_74266[(4)])));

return statearr_74277;
})();
var state_74266__$1 = state_74266;
var statearr_74278_74297 = state_74266__$1;
(statearr_74278_74297[(2)] = inst_74261);

(statearr_74278_74297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74267 === (5))){
var _ = (function (){var statearr_74279 = state_74266;
(statearr_74279[(4)] = cljs.core.rest.call(null,(state_74266[(4)])));

return statearr_74279;
})();
var state_74266__$1 = state_74266;
var ex74274 = (state_74266__$1[(2)]);
var statearr_74280_74298 = state_74266__$1;
(statearr_74280_74298[(5)] = ex74274);


var statearr_74281_74299 = state_74266__$1;
(statearr_74281_74299[(1)] = (4));

(statearr_74281_74299[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74267 === (10))){
var inst_74256 = (state_74266[(2)]);
var inst_74257 = fluree.db.util.async.throw_err.call(null,inst_74256);
var state_74266__$1 = state_74266;
var statearr_74282_74300 = state_74266__$1;
(statearr_74282_74300[(2)] = inst_74257);

(statearr_74282_74300[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74267 === (8))){
var inst_74252 = (state_74266[(8)]);
var state_74266__$1 = state_74266;
var statearr_74283_74301 = state_74266__$1;
(statearr_74283_74301[(2)] = inst_74252);

(statearr_74283_74301[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__10945__auto__ = null;
var fluree$db$api_js$state_machine__10945__auto____0 = (function (){
var statearr_74284 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74284[(0)] = fluree$db$api_js$state_machine__10945__auto__);

(statearr_74284[(1)] = (1));

return statearr_74284;
});
var fluree$db$api_js$state_machine__10945__auto____1 = (function (state_74266){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_74266);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e74285){var ex__10948__auto__ = e74285;
var statearr_74286_74302 = state_74266;
(statearr_74286_74302[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_74266[(4)]))){
var statearr_74287_74303 = state_74266;
(statearr_74287_74303[(1)] = cljs.core.first.call(null,(state_74266[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74304 = state_74266;
state_74266 = G__74304;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__10945__auto__ = function(state_74266){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__10945__auto____1.call(this,state_74266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__10945__auto____0;
fluree$db$api_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__10945__auto____1;
return fluree$db$api_js$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_74288 = f__11019__auto__.call(null);
(statearr_74288[(6)] = c__11018__auto___74292);

return statearr_74288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq74218){
var G__74219 = cljs.core.first.call(null,seq74218);
var seq74218__$1 = cljs.core.next.call(null,seq74218);
var G__74220 = cljs.core.first.call(null,seq74218__$1);
var seq74218__$2 = cljs.core.next.call(null,seq74218__$1);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74219,G__74220,seq74218__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__5043__auto__){
var and__5043__auto____$1 = open_api;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__5043__auto__){
return open_api;
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__5043__auto__){
return auth;
} else {
return and__5043__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__74306 = arguments.length;
switch (G__74306) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_74432){
var state_val_74433 = (state_74432[(1)]);
if((state_val_74433 === (7))){
var inst_74332 = (state_74432[(7)]);
var inst_74322 = (state_74432[(8)]);
var inst_74334 = fluree.db.time_travel.as_of_block.call(null,inst_74332,inst_74322);
var state_74432__$1 = state_74432;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74432__$1,(10),inst_74334);
} else {
if((state_val_74433 === (20))){
var inst_74326 = (state_74432[(9)]);
var state_74432__$1 = state_74432;
var statearr_74434_74514 = state_74432__$1;
(statearr_74434_74514[(2)] = inst_74326);

(statearr_74434_74514[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (27))){
var inst_74320 = (state_74432[(10)]);
var state_74432__$1 = state_74432;
var statearr_74435_74515 = state_74432__$1;
(statearr_74435_74515[(2)] = inst_74320);

(statearr_74435_74515[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (1))){
var state_74432__$1 = state_74432;
var statearr_74436_74516 = state_74432__$1;
(statearr_74436_74516[(2)] = null);

(statearr_74436_74516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (24))){
var inst_74329 = (state_74432[(11)]);
var state_74432__$1 = state_74432;
if(cljs.core.truth_(inst_74329)){
var statearr_74437_74517 = state_74432__$1;
(statearr_74437_74517[(1)] = (26));

} else {
var statearr_74438_74518 = state_74432__$1;
(statearr_74438_74518[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (39))){
var inst_74394 = (state_74432[(12)]);
var inst_74397 = cljs.core.ex_data.call(null,inst_74394);
var inst_74398 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74399 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_74397);
var inst_74400 = cljs.core.ex_message.call(null,inst_74394);
var inst_74401 = [inst_74399,inst_74400,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74402 = cljs.core.PersistentHashMap.fromArrays(inst_74398,inst_74401);
var state_74432__$1 = state_74432;
var statearr_74439_74519 = state_74432__$1;
(statearr_74439_74519[(2)] = inst_74402);

(statearr_74439_74519[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (46))){
var inst_74394 = (state_74432[(12)]);
var state_74432__$1 = state_74432;
var statearr_74440_74520 = state_74432__$1;
(statearr_74440_74520[(2)] = inst_74394);

(statearr_74440_74520[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (4))){
var inst_74307 = (state_74432[(2)]);
var inst_74308 = fluree.db.util.log.error.call(null,inst_74307);
var inst_74309 = cljs.core.ex_data.call(null,inst_74307);
var inst_74310 = cljs.core.ex_message.call(null,inst_74307);
var inst_74311 = cljs.core.assoc.call(null,inst_74309,new cljs.core.Keyword(null,"message","message",-406056002),inst_74310);
var state_74432__$1 = (function (){var statearr_74441 = state_74432;
(statearr_74441[(13)] = inst_74308);

return statearr_74441;
})();
var statearr_74442_74521 = state_74432__$1;
(statearr_74442_74521[(2)] = inst_74311);

(statearr_74442_74521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (15))){
var state_74432__$1 = state_74432;
var statearr_74443_74522 = state_74432__$1;
(statearr_74443_74522[(2)] = (1000000));

(statearr_74443_74522[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (48))){
var inst_74394 = (state_74432[(12)]);
var state_74432__$1 = state_74432;
var statearr_74444_74523 = state_74432__$1;
(statearr_74444_74523[(2)] = inst_74394);

(statearr_74444_74523[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (50))){
var inst_74421 = (state_74432[(2)]);
var state_74432__$1 = state_74432;
var statearr_74445_74524 = state_74432__$1;
(statearr_74445_74524[(2)] = inst_74421);

(statearr_74445_74524[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (21))){
var inst_74325 = (state_74432[(14)]);
var state_74432__$1 = state_74432;
if(cljs.core.truth_(inst_74325)){
var statearr_74446_74525 = state_74432__$1;
(statearr_74446_74525[(1)] = (23));

} else {
var statearr_74447_74526 = state_74432__$1;
(statearr_74447_74526[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (31))){
var inst_74383 = (state_74432[(2)]);
var inst_74384 = cljs.core.not.call(null,inst_74383);
var state_74432__$1 = state_74432;
if(inst_74384){
var statearr_74448_74527 = state_74432__$1;
(statearr_74448_74527[(1)] = (35));

} else {
var statearr_74449_74528 = state_74432__$1;
(statearr_74449_74528[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (32))){
var inst_74327 = (state_74432[(15)]);
var state_74432__$1 = state_74432;
var statearr_74450_74529 = state_74432__$1;
(statearr_74450_74529[(2)] = inst_74327);

(statearr_74450_74529[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (40))){
var inst_74357 = (state_74432[(16)]);
var state_74432__$1 = state_74432;
if(cljs.core.truth_(inst_74357)){
var statearr_74451_74530 = state_74432__$1;
(statearr_74451_74530[(1)] = (42));

} else {
var statearr_74452_74531 = state_74432__$1;
(statearr_74452_74531[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (33))){
var inst_74323 = (state_74432[(17)]);
var state_74432__$1 = state_74432;
var statearr_74453_74532 = state_74432__$1;
(statearr_74453_74532[(2)] = inst_74323);

(statearr_74453_74532[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (13))){
var inst_74352 = (state_74432[(18)]);
var inst_74328 = (state_74432[(19)]);
var inst_74350 = (state_74432[(2)]);
var inst_74351 = cljs.core.volatile_BANG_.call(null,(0));
var inst_74352__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_74328);
var state_74432__$1 = (function (){var statearr_74454 = state_74432;
(statearr_74454[(20)] = inst_74351);

(statearr_74454[(18)] = inst_74352__$1);

(statearr_74454[(21)] = inst_74350);

return statearr_74454;
})();
if(cljs.core.truth_(inst_74352__$1)){
var statearr_74455_74533 = state_74432__$1;
(statearr_74455_74533[(1)] = (14));

} else {
var statearr_74456_74534 = state_74432__$1;
(statearr_74456_74534[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (22))){
var inst_74373 = (state_74432[(2)]);
var state_74432__$1 = state_74432;
var statearr_74457_74535 = state_74432__$1;
(statearr_74457_74535[(2)] = inst_74373);

(statearr_74457_74535[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (36))){
var inst_74359 = (state_74432[(22)]);
var inst_74340 = (state_74432[(23)]);
var inst_74390 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_74359);
var inst_74391 = fluree.db.query.fql.query.call(null,inst_74340,inst_74390);
var state_74432__$1 = state_74432;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74432__$1,(38),inst_74391);
} else {
if((state_val_74433 === (41))){
var inst_74425 = (state_74432[(2)]);
var state_74432__$1 = state_74432;
var statearr_74458_74536 = state_74432__$1;
(statearr_74458_74536[(2)] = inst_74425);

(statearr_74458_74536[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (43))){
var state_74432__$1 = state_74432;
var statearr_74459_74537 = state_74432__$1;
(statearr_74459_74537[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (29))){
var inst_74327 = (state_74432[(15)]);
var state_74432__$1 = state_74432;
if(cljs.core.truth_(inst_74327)){
var statearr_74461_74538 = state_74432__$1;
(statearr_74461_74538[(1)] = (32));

} else {
var statearr_74462_74539 = state_74432__$1;
(statearr_74462_74539[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (44))){
var inst_74423 = (state_74432[(2)]);
var state_74432__$1 = state_74432;
var statearr_74463_74540 = state_74432__$1;
(statearr_74463_74540[(2)] = inst_74423);

(statearr_74463_74540[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (6))){
var inst_74322 = (state_74432[(8)]);
var inst_74331 = (state_74432[(2)]);
var inst_74332 = fluree.db.util.async.throw_err.call(null,inst_74331);
var state_74432__$1 = (function (){var statearr_74464 = state_74432;
(statearr_74464[(7)] = inst_74332);

return statearr_74464;
})();
if(cljs.core.truth_(inst_74322)){
var statearr_74465_74541 = state_74432__$1;
(statearr_74465_74541[(1)] = (7));

} else {
var statearr_74466_74542 = state_74432__$1;
(statearr_74466_74542[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (28))){
var inst_74369 = (state_74432[(2)]);
var state_74432__$1 = state_74432;
var statearr_74467_74543 = state_74432__$1;
(statearr_74467_74543[(2)] = inst_74369);

(statearr_74467_74543[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (25))){
var inst_74371 = (state_74432[(2)]);
var state_74432__$1 = state_74432;
var statearr_74468_74544 = state_74432__$1;
(statearr_74468_74544[(2)] = inst_74371);

(statearr_74468_74544[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (34))){
var inst_74380 = (state_74432[(2)]);
var state_74432__$1 = state_74432;
var statearr_74469_74545 = state_74432__$1;
(statearr_74469_74545[(2)] = inst_74380);

(statearr_74469_74545[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (17))){
var inst_74321 = (state_74432[(24)]);
var state_74432__$1 = state_74432;
var statearr_74470_74546 = state_74432__$1;
(statearr_74470_74546[(2)] = inst_74321);

(statearr_74470_74546[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (3))){
var inst_74430 = (state_74432[(2)]);
var state_74432__$1 = state_74432;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74432__$1,inst_74430);
} else {
if((state_val_74433 === (12))){
var inst_74348 = cljs.core.PersistentHashMap.EMPTY;
var state_74432__$1 = state_74432;
var statearr_74471_74547 = state_74432__$1;
(statearr_74471_74547[(2)] = inst_74348);

(statearr_74471_74547[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (2))){
var _ = (function (){var statearr_74472 = state_74432;
(statearr_74472[(4)] = cljs.core.cons.call(null,(5),(state_74432[(4)])));

return statearr_74472;
})();
var inst_74318 = query_map;
var inst_74319 = cljs.core.__destructure_map.call(null,inst_74318);
var inst_74320 = cljs.core.get.call(null,inst_74319,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_74321 = cljs.core.get.call(null,inst_74319,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_74322 = cljs.core.get.call(null,inst_74319,new cljs.core.Keyword(null,"block","block",664686210));
var inst_74323 = cljs.core.get.call(null,inst_74319,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_74324 = cljs.core.get.call(null,inst_74319,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_74325 = cljs.core.get.call(null,inst_74319,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_74326 = cljs.core.get.call(null,inst_74319,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_74327 = cljs.core.get.call(null,inst_74319,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_74328 = cljs.core.get.call(null,inst_74319,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_74329 = cljs.core.get.call(null,inst_74319,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_74432__$1 = (function (){var statearr_74473 = state_74432;
(statearr_74473[(24)] = inst_74321);

(statearr_74473[(17)] = inst_74323);

(statearr_74473[(25)] = inst_74324);

(statearr_74473[(15)] = inst_74327);

(statearr_74473[(14)] = inst_74325);

(statearr_74473[(10)] = inst_74320);

(statearr_74473[(9)] = inst_74326);

(statearr_74473[(11)] = inst_74329);

(statearr_74473[(19)] = inst_74328);

(statearr_74473[(8)] = inst_74322);

return statearr_74473;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74432__$1,(6),sources);
} else {
if((state_val_74433 === (23))){
var inst_74325 = (state_74432[(14)]);
var state_74432__$1 = state_74432;
var statearr_74474_74548 = state_74432__$1;
(statearr_74474_74548[(2)] = inst_74325);

(statearr_74474_74548[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (47))){
var inst_74405 = (state_74432[(26)]);
var inst_74351 = (state_74432[(20)]);
var inst_74340 = (state_74432[(23)]);
var inst_74358 = (state_74432[(27)]);
var inst_74411 = (state_74432[(2)]);
var inst_74412 = cljs.core.deref.call(null,inst_74351);
var inst_74413 = fluree.db.util.core.response_time_formatted.call(null,inst_74358);
var inst_74414 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_74340);
var inst_74415 = [(200),inst_74411,inst_74412,inst_74413,inst_74414];
var inst_74416 = cljs.core.PersistentHashMap.fromArrays(inst_74405,inst_74415);
var state_74432__$1 = state_74432;
var statearr_74475_74549 = state_74432__$1;
(statearr_74475_74549[(2)] = inst_74416);

(statearr_74475_74549[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (35))){
var inst_74386 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74387 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74388 = cljs.core.PersistentHashMap.fromArrays(inst_74386,inst_74387);
var state_74432__$1 = state_74432;
var statearr_74476_74550 = state_74432__$1;
(statearr_74476_74550[(2)] = inst_74388);

(statearr_74476_74550[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (19))){
var inst_74375 = (state_74432[(28)]);
var inst_74375__$1 = (state_74432[(2)]);
var state_74432__$1 = (function (){var statearr_74477 = state_74432;
(statearr_74477[(28)] = inst_74375__$1);

return statearr_74477;
})();
if(cljs.core.truth_(inst_74375__$1)){
var statearr_74478_74551 = state_74432__$1;
(statearr_74478_74551[(1)] = (29));

} else {
var statearr_74479_74552 = state_74432__$1;
(statearr_74479_74552[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (11))){
var inst_74340 = (state_74432[(23)]);
var inst_74324 = (state_74432[(25)]);
var inst_74341 = (state_74432[(29)]);
var inst_74343 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_74340);
var inst_74344 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_74341);
var inst_74345 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_74340);
var inst_74346 = fluree.db.api_js.get_sources.call(null,inst_74341,inst_74343,inst_74344,inst_74345,inst_74324,db_fn);
var state_74432__$1 = state_74432;
var statearr_74481_74553 = state_74432__$1;
(statearr_74481_74553[(2)] = inst_74346);

(statearr_74481_74553[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (9))){
var inst_74340 = (state_74432[(23)]);
var inst_74324 = (state_74432[(25)]);
var inst_74340__$1 = (state_74432[(2)]);
var inst_74341 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_74340__$1);
var state_74432__$1 = (function (){var statearr_74482 = state_74432;
(statearr_74482[(23)] = inst_74340__$1);

(statearr_74482[(29)] = inst_74341);

return statearr_74482;
})();
if(cljs.core.truth_(inst_74324)){
var statearr_74483_74554 = state_74432__$1;
(statearr_74483_74554[(1)] = (11));

} else {
var statearr_74484_74555 = state_74432__$1;
(statearr_74484_74555[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (5))){
var _ = (function (){var statearr_74485 = state_74432;
(statearr_74485[(4)] = cljs.core.rest.call(null,(state_74432[(4)])));

return statearr_74485;
})();
var state_74432__$1 = state_74432;
var ex74480 = (state_74432__$1[(2)]);
var statearr_74486_74556 = state_74432__$1;
(statearr_74486_74556[(5)] = ex74480);


var statearr_74487_74557 = state_74432__$1;
(statearr_74487_74557[(1)] = (4));

(statearr_74487_74557[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (14))){
var inst_74352 = (state_74432[(18)]);
var state_74432__$1 = state_74432;
var statearr_74488_74558 = state_74432__$1;
(statearr_74488_74558[(2)] = inst_74352);

(statearr_74488_74558[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (45))){
var inst_74394 = (state_74432[(12)]);
var inst_74408 = cljs.core.doall.call(null,inst_74394);
var state_74432__$1 = state_74432;
var statearr_74489_74559 = state_74432__$1;
(statearr_74489_74559[(2)] = inst_74408);

(statearr_74489_74559[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (26))){
var inst_74329 = (state_74432[(11)]);
var state_74432__$1 = state_74432;
var statearr_74490_74560 = state_74432__$1;
(statearr_74490_74560[(2)] = inst_74329);

(statearr_74490_74560[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (16))){
var inst_74351 = (state_74432[(20)]);
var inst_74321 = (state_74432[(24)]);
var inst_74328 = (state_74432[(19)]);
var inst_74350 = (state_74432[(21)]);
var inst_74356 = (state_74432[(2)]);
var inst_74357 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_74328);
var inst_74358 = fluree.db.util.core.current_time_millis.call(null);
var inst_74359 = cljs.core.assoc.call(null,inst_74328,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_74350,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_74356,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_74351);
var state_74432__$1 = (function (){var statearr_74491 = state_74432;
(statearr_74491[(22)] = inst_74359);

(statearr_74491[(16)] = inst_74357);

(statearr_74491[(27)] = inst_74358);

return statearr_74491;
})();
if(cljs.core.truth_(inst_74321)){
var statearr_74492_74561 = state_74432__$1;
(statearr_74492_74561[(1)] = (17));

} else {
var statearr_74493_74562 = state_74432__$1;
(statearr_74493_74562[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (38))){
var inst_74394 = (state_74432[(12)]);
var inst_74393 = (state_74432[(2)]);
var inst_74394__$1 = fluree.db.util.async.throw_err.call(null,inst_74393);
var inst_74395 = (inst_74394__$1 instanceof cljs.core.ExceptionInfo);
var state_74432__$1 = (function (){var statearr_74494 = state_74432;
(statearr_74494[(12)] = inst_74394__$1);

return statearr_74494;
})();
if(cljs.core.truth_(inst_74395)){
var statearr_74495_74563 = state_74432__$1;
(statearr_74495_74563[(1)] = (39));

} else {
var statearr_74496_74564 = state_74432__$1;
(statearr_74496_74564[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (30))){
var inst_74375 = (state_74432[(28)]);
var state_74432__$1 = state_74432;
var statearr_74497_74565 = state_74432__$1;
(statearr_74497_74565[(2)] = inst_74375);

(statearr_74497_74565[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (10))){
var inst_74336 = (state_74432[(2)]);
var inst_74337 = fluree.db.util.async.throw_err.call(null,inst_74336);
var state_74432__$1 = state_74432;
var statearr_74498_74566 = state_74432__$1;
(statearr_74498_74566[(2)] = inst_74337);

(statearr_74498_74566[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (18))){
var inst_74326 = (state_74432[(9)]);
var state_74432__$1 = state_74432;
if(cljs.core.truth_(inst_74326)){
var statearr_74499_74567 = state_74432__$1;
(statearr_74499_74567[(1)] = (20));

} else {
var statearr_74500_74568 = state_74432__$1;
(statearr_74500_74568[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (42))){
var inst_74394 = (state_74432[(12)]);
var inst_74405 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_74406 = cljs.core.sequential_QMARK_.call(null,inst_74394);
var state_74432__$1 = (function (){var statearr_74501 = state_74432;
(statearr_74501[(26)] = inst_74405);

return statearr_74501;
})();
if(inst_74406){
var statearr_74502_74569 = state_74432__$1;
(statearr_74502_74569[(1)] = (45));

} else {
var statearr_74503_74570 = state_74432__$1;
(statearr_74503_74570[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (37))){
var inst_74427 = (state_74432[(2)]);
var _ = (function (){var statearr_74504 = state_74432;
(statearr_74504[(4)] = cljs.core.rest.call(null,(state_74432[(4)])));

return statearr_74504;
})();
var state_74432__$1 = state_74432;
var statearr_74505_74571 = state_74432__$1;
(statearr_74505_74571[(2)] = inst_74427);

(statearr_74505_74571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (8))){
var inst_74332 = (state_74432[(7)]);
var state_74432__$1 = state_74432;
var statearr_74506_74572 = state_74432__$1;
(statearr_74506_74572[(2)] = inst_74332);

(statearr_74506_74572[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74433 === (49))){
var state_74432__$1 = state_74432;
var statearr_74507_74573 = state_74432__$1;
(statearr_74507_74573[(2)] = null);

(statearr_74507_74573[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__10945__auto__ = null;
var fluree$db$api_js$state_machine__10945__auto____0 = (function (){
var statearr_74508 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74508[(0)] = fluree$db$api_js$state_machine__10945__auto__);

(statearr_74508[(1)] = (1));

return statearr_74508;
});
var fluree$db$api_js$state_machine__10945__auto____1 = (function (state_74432){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_74432);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e74509){var ex__10948__auto__ = e74509;
var statearr_74510_74574 = state_74432;
(statearr_74510_74574[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_74432[(4)]))){
var statearr_74511_74575 = state_74432;
(statearr_74511_74575[(1)] = cljs.core.first.call(null,(state_74432[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74576 = state_74432;
state_74432 = G__74576;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__10945__auto__ = function(state_74432){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__10945__auto____1.call(this,state_74432);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__10945__auto____0;
fluree$db$api_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__10945__auto____1;
return fluree$db$api_js$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_74512 = f__11019__auto__.call(null);
(statearr_74512[(6)] = c__11018__auto__);

return statearr_74512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__74577_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__74577_SHARP_);
}));

var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_74599){
var state_val_74600 = (state_74599[(1)]);
if((state_val_74600 === (1))){
var inst_74581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74582 = [resp_chan,timeout_chan];
var inst_74583 = (new cljs.core.PersistentVector(null,2,(5),inst_74581,inst_74582,null));
var state_74599__$1 = state_74599;
return cljs.core.async.ioc_alts_BANG_.call(null,state_74599__$1,(2),inst_74583);
} else {
if((state_val_74600 === (2))){
var inst_74585 = (state_74599[(2)]);
var inst_74586 = cljs.core.nth.call(null,inst_74585,(0),null);
var inst_74587 = cljs.core.nth.call(null,inst_74585,(1),null);
var inst_74588 = cljs.core._EQ_.call(null,timeout_chan,inst_74587);
var state_74599__$1 = (function (){var statearr_74601 = state_74599;
(statearr_74601[(7)] = inst_74586);

return statearr_74601;
})();
if(inst_74588){
var statearr_74602_74612 = state_74599__$1;
(statearr_74602_74612[(1)] = (3));

} else {
var statearr_74603_74613 = state_74599__$1;
(statearr_74603_74613[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74600 === (3))){
var inst_74590 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_74591 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_74592 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_74593 = [tid,(408),inst_74592];
var inst_74594 = cljs.core.PersistentHashMap.fromArrays(inst_74591,inst_74593);
var state_74599__$1 = (function (){var statearr_74604 = state_74599;
(statearr_74604[(8)] = inst_74590);

return statearr_74604;
})();
var statearr_74605_74614 = state_74599__$1;
(statearr_74605_74614[(2)] = inst_74594);

(statearr_74605_74614[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74600 === (4))){
var inst_74586 = (state_74599[(7)]);
var state_74599__$1 = state_74599;
var statearr_74606_74615 = state_74599__$1;
(statearr_74606_74615[(2)] = inst_74586);

(statearr_74606_74615[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74600 === (5))){
var inst_74597 = (state_74599[(2)]);
var state_74599__$1 = state_74599;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74599__$1,inst_74597);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__10945__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__10945__auto____0 = (function (){
var statearr_74607 = [null,null,null,null,null,null,null,null,null];
(statearr_74607[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__10945__auto__);

(statearr_74607[(1)] = (1));

return statearr_74607;
});
var fluree$db$api_js$monitor_tx_$_state_machine__10945__auto____1 = (function (state_74599){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_74599);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e74608){var ex__10948__auto__ = e74608;
var statearr_74609_74616 = state_74599;
(statearr_74609_74616[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_74599[(4)]))){
var statearr_74610_74617 = state_74599;
(statearr_74610_74617[(1)] = cljs.core.first.call(null,(state_74599[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74618 = state_74599;
state_74599 = G__74618;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__10945__auto__ = function(state_74599){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__10945__auto____1.call(this,state_74599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__10945__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__10945__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_74611 = f__11019__auto__.call(null);
(statearr_74611[(6)] = c__11018__auto__);

return statearr_74611;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__74620 = arguments.length;
switch (G__74620) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__74621 = opts;
var map__74621__$1 = cljs.core.__destructure_map.call(null,map__74621);
var auth = cljs.core.get.call(null,map__74621__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__74621__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__74621__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__74621__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__74622 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__74622,(0),null);
var authority = cljs.core.nth.call(null,vec__74622,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e74625){var e = e74625;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__74628 = arguments.length;
switch (G__74628) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_74694){
var state_val_74695 = (state_74694[(1)]);
if((state_val_74695 === (7))){
var inst_74648 = (state_74694[(7)]);
var inst_74650 = (state_74694[(8)]);
var inst_74645 = (state_74694[(9)]);
var inst_74649 = (state_74694[(10)]);
var inst_74647 = (state_74694[(11)]);
var inst_74663 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_74664 = [ledger,txn,inst_74645,inst_74647,inst_74648,inst_74649,inst_74650];
var inst_74665 = cljs.core.PersistentHashMap.fromArrays(inst_74663,inst_74664);
var inst_74666 = fluree.db.util.core.without_nils.call(null,inst_74665);
var inst_74667 = fluree.db.operations.transact_async.call(null,conn,inst_74666);
var state_74694__$1 = state_74694;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74694__$1,(13),inst_74667);
} else {
if((state_val_74695 === (20))){
var inst_74685 = (state_74694[(2)]);
var state_74694__$1 = state_74694;
var statearr_74696_74732 = state_74694__$1;
(statearr_74696_74732[(2)] = inst_74685);

(statearr_74696_74732[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74695 === (1))){
var state_74694__$1 = state_74694;
var statearr_74697_74733 = state_74694__$1;
(statearr_74697_74733[(2)] = null);

(statearr_74697_74733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74695 === (4))){
var inst_74629 = (state_74694[(2)]);
var inst_74630 = fluree.db.util.log.error.call(null,inst_74629);
var inst_74631 = cljs.core.ex_data.call(null,inst_74629);
var inst_74632 = cljs.core.ex_message.call(null,inst_74629);
var inst_74633 = cljs.core.assoc.call(null,inst_74631,new cljs.core.Keyword(null,"message","message",-406056002),inst_74632);
var state_74694__$1 = (function (){var statearr_74698 = state_74694;
(statearr_74698[(12)] = inst_74630);

return statearr_74698;
})();
var statearr_74699_74734 = state_74694__$1;
(statearr_74699_74734[(2)] = inst_74633);

(statearr_74699_74734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74695 === (15))){
var inst_74644 = (state_74694[(13)]);
var inst_74669 = (state_74694[(14)]);
var inst_74672 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_74669,inst_74644);
var state_74694__$1 = state_74694;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74694__$1,(17),inst_74672);
} else {
if((state_val_74695 === (13))){
var inst_74643 = (state_74694[(15)]);
var inst_74669 = (state_74694[(2)]);
var state_74694__$1 = (function (){var statearr_74700 = state_74694;
(statearr_74700[(14)] = inst_74669);

return statearr_74700;
})();
if(cljs.core.truth_(inst_74643)){
var statearr_74701_74735 = state_74694__$1;
(statearr_74701_74735[(1)] = (14));

} else {
var statearr_74702_74736 = state_74694__$1;
(statearr_74702_74736[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74695 === (6))){
var inst_74642 = (state_74694[(16)]);
var inst_74643 = (state_74694[(15)]);
var inst_74652 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_74642,opts);
var inst_74653 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_74652);
var inst_74654 = fluree.db.operations.command_async.call(null,conn,inst_74652);
var state_74694__$1 = (function (){var statearr_74703 = state_74694;
(statearr_74703[(17)] = inst_74654);

(statearr_74703[(18)] = inst_74653);

return statearr_74703;
})();
if(cljs.core.truth_(inst_74643)){
var statearr_74704_74737 = state_74694__$1;
(statearr_74704_74737[(1)] = (9));

} else {
var statearr_74705_74738 = state_74694__$1;
(statearr_74705_74738[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74695 === (17))){
var inst_74674 = (state_74694[(19)]);
var inst_74674__$1 = (state_74694[(2)]);
var inst_74675 = (inst_74674__$1 instanceof cljs.core.ExceptionInfo);
var state_74694__$1 = (function (){var statearr_74706 = state_74694;
(statearr_74706[(19)] = inst_74674__$1);

return statearr_74706;
})();
if(cljs.core.truth_(inst_74675)){
var statearr_74707_74739 = state_74694__$1;
(statearr_74707_74739[(1)] = (18));

} else {
var statearr_74708_74740 = state_74694__$1;
(statearr_74708_74740[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74695 === (3))){
var inst_74692 = (state_74694[(2)]);
var state_74694__$1 = state_74694;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74694__$1,inst_74692);
} else {
if((state_val_74695 === (12))){
var inst_74659 = (state_74694[(2)]);
var state_74694__$1 = state_74694;
var statearr_74709_74741 = state_74694__$1;
(statearr_74709_74741[(2)] = inst_74659);

(statearr_74709_74741[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74695 === (2))){
var inst_74642 = (state_74694[(16)]);
var _ = (function (){var statearr_74710 = state_74694;
(statearr_74710[(4)] = cljs.core.cons.call(null,(5),(state_74694[(4)])));

return statearr_74710;
})();
var inst_74640 = opts;
var inst_74641 = cljs.core.__destructure_map.call(null,inst_74640);
var inst_74642__$1 = cljs.core.get.call(null,inst_74641,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_74643 = cljs.core.get.call(null,inst_74641,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_74644 = cljs.core.get.call(null,inst_74641,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_74645 = cljs.core.get.call(null,inst_74641,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_74646 = fluree.db.util.core.current_time_millis.call(null);
var inst_74647 = cljs.core.get.call(null,inst_74641,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_74646);
var inst_74648 = cljs.core.get.call(null,inst_74641,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_74649 = cljs.core.get.call(null,inst_74641,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_74650 = cljs.core.get.call(null,inst_74641,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_74694__$1 = (function (){var statearr_74711 = state_74694;
(statearr_74711[(7)] = inst_74648);

(statearr_74711[(16)] = inst_74642__$1);

(statearr_74711[(15)] = inst_74643);

(statearr_74711[(8)] = inst_74650);

(statearr_74711[(9)] = inst_74645);

(statearr_74711[(10)] = inst_74649);

(statearr_74711[(13)] = inst_74644);

(statearr_74711[(11)] = inst_74647);

return statearr_74711;
})();
if(cljs.core.truth_(inst_74642__$1)){
var statearr_74712_74742 = state_74694__$1;
(statearr_74712_74742[(1)] = (6));

} else {
var statearr_74713_74743 = state_74694__$1;
(statearr_74713_74743[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74695 === (19))){
var inst_74674 = (state_74694[(19)]);
var state_74694__$1 = state_74694;
var statearr_74714_74744 = state_74694__$1;
(statearr_74714_74744[(2)] = inst_74674);

(statearr_74714_74744[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74695 === (11))){
var inst_74661 = (state_74694[(2)]);
var state_74694__$1 = state_74694;
var statearr_74716_74745 = state_74694__$1;
(statearr_74716_74745[(2)] = inst_74661);

(statearr_74716_74745[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74695 === (9))){
var inst_74654 = (state_74694[(17)]);
var state_74694__$1 = state_74694;
var statearr_74717_74746 = state_74694__$1;
(statearr_74717_74746[(2)] = inst_74654);

(statearr_74717_74746[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74695 === (5))){
var _ = (function (){var statearr_74718 = state_74694;
(statearr_74718[(4)] = cljs.core.rest.call(null,(state_74694[(4)])));

return statearr_74718;
})();
var state_74694__$1 = state_74694;
var ex74715 = (state_74694__$1[(2)]);
var statearr_74719_74747 = state_74694__$1;
(statearr_74719_74747[(5)] = ex74715);


var statearr_74720_74748 = state_74694__$1;
(statearr_74720_74748[(1)] = (4));

(statearr_74720_74748[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74695 === (14))){
var inst_74669 = (state_74694[(14)]);
var state_74694__$1 = state_74694;
var statearr_74721_74749 = state_74694__$1;
(statearr_74721_74749[(2)] = inst_74669);

(statearr_74721_74749[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74695 === (16))){
var inst_74687 = (state_74694[(2)]);
var state_74694__$1 = state_74694;
var statearr_74722_74750 = state_74694__$1;
(statearr_74722_74750[(2)] = inst_74687);

(statearr_74722_74750[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74695 === (10))){
var inst_74644 = (state_74694[(13)]);
var inst_74653 = (state_74694[(18)]);
var inst_74657 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_74653,inst_74644);
var state_74694__$1 = state_74694;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74694__$1,(12),inst_74657);
} else {
if((state_val_74695 === (18))){
var inst_74674 = (state_74694[(19)]);
var inst_74677 = cljs.core.ex_data.call(null,inst_74674);
var inst_74678 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74679 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_74677);
var inst_74680 = cljs.core.ex_message.call(null,inst_74674);
var inst_74681 = [inst_74679,inst_74680,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_74682 = cljs.core.PersistentHashMap.fromArrays(inst_74678,inst_74681);
var state_74694__$1 = state_74694;
var statearr_74723_74751 = state_74694__$1;
(statearr_74723_74751[(2)] = inst_74682);

(statearr_74723_74751[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74695 === (8))){
var inst_74689 = (state_74694[(2)]);
var _ = (function (){var statearr_74724 = state_74694;
(statearr_74724[(4)] = cljs.core.rest.call(null,(state_74694[(4)])));

return statearr_74724;
})();
var state_74694__$1 = state_74694;
var statearr_74725_74752 = state_74694__$1;
(statearr_74725_74752[(2)] = inst_74689);

(statearr_74725_74752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__10945__auto__ = null;
var fluree$db$api_js$state_machine__10945__auto____0 = (function (){
var statearr_74726 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74726[(0)] = fluree$db$api_js$state_machine__10945__auto__);

(statearr_74726[(1)] = (1));

return statearr_74726;
});
var fluree$db$api_js$state_machine__10945__auto____1 = (function (state_74694){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_74694);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e74727){var ex__10948__auto__ = e74727;
var statearr_74728_74753 = state_74694;
(statearr_74728_74753[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_74694[(4)]))){
var statearr_74729_74754 = state_74694;
(statearr_74729_74754[(1)] = cljs.core.first.call(null,(state_74694[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74755 = state_74694;
state_74694 = G__74755;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__10945__auto__ = function(state_74694){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__10945__auto____1.call(this,state_74694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__10945__auto____0;
fluree$db$api_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__10945__auto____1;
return fluree$db$api_js$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_74730 = f__11019__auto__.call(null);
(statearr_74730[(6)] = c__11018__auto__);

return statearr_74730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__5774__auto__ = [];
var len__5768__auto___74757 = arguments.length;
var i__5769__auto___74758 = (0);
while(true){
if((i__5769__auto___74758 < len__5768__auto___74757)){
args__5774__auto__.push((arguments[i__5769__auto___74758]));

var G__74759 = (i__5769__auto___74758 + (1));
i__5769__auto___74758 = G__74759;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq74756){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq74756));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_74790){
var state_val_74791 = (state_74790[(1)]);
if((state_val_74791 === (1))){
var inst_74760 = cljs.core.first.call(null,flakes);
var inst_74761 = cljs.core.rest.call(null,flakes);
var inst_74762 = cljs.core.PersistentVector.EMPTY;
var inst_74763 = inst_74760;
var inst_74764 = inst_74761;
var inst_74765 = inst_74762;
var state_74790__$1 = (function (){var statearr_74792 = state_74790;
(statearr_74792[(7)] = inst_74764);

(statearr_74792[(8)] = inst_74765);

(statearr_74792[(9)] = inst_74763);

return statearr_74792;
})();
var statearr_74793_74806 = state_74790__$1;
(statearr_74793_74806[(2)] = null);

(statearr_74793_74806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74791 === (2))){
var inst_74763 = (state_74790[(9)]);
var inst_74767 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_74768 = cljs.core.PersistentHashMap.EMPTY;
var inst_74769 = [true,inst_74768];
var inst_74770 = cljs.core.PersistentHashMap.fromArrays(inst_74767,inst_74769);
var inst_74771 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_74770,inst_74763);
var state_74790__$1 = state_74790;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74790__$1,(4),inst_74771);
} else {
if((state_val_74791 === (3))){
var inst_74788 = (state_74790[(2)]);
var state_74790__$1 = state_74790;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74790__$1,inst_74788);
} else {
if((state_val_74791 === (4))){
var inst_74764 = (state_74790[(7)]);
var inst_74765 = (state_74790[(8)]);
var inst_74773 = (state_74790[(2)]);
var inst_74774 = fluree.db.util.async.throw_err.call(null,inst_74773);
var inst_74775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74776 = [inst_74774];
var inst_74777 = (new cljs.core.PersistentVector(null,1,(5),inst_74775,inst_74776,null));
var inst_74778 = cljs.core.concat.call(null,inst_74765,inst_74777);
var inst_74779 = cljs.core.first.call(null,inst_74764);
var state_74790__$1 = (function (){var statearr_74794 = state_74790;
(statearr_74794[(10)] = inst_74778);

return statearr_74794;
})();
if(cljs.core.truth_(inst_74779)){
var statearr_74795_74807 = state_74790__$1;
(statearr_74795_74807[(1)] = (5));

} else {
var statearr_74796_74808 = state_74790__$1;
(statearr_74796_74808[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74791 === (5))){
var inst_74764 = (state_74790[(7)]);
var inst_74778 = (state_74790[(10)]);
var inst_74781 = cljs.core.first.call(null,inst_74764);
var inst_74782 = cljs.core.rest.call(null,inst_74764);
var inst_74763 = inst_74781;
var inst_74764__$1 = inst_74782;
var inst_74765 = inst_74778;
var state_74790__$1 = (function (){var statearr_74797 = state_74790;
(statearr_74797[(7)] = inst_74764__$1);

(statearr_74797[(8)] = inst_74765);

(statearr_74797[(9)] = inst_74763);

return statearr_74797;
})();
var statearr_74798_74809 = state_74790__$1;
(statearr_74798_74809[(2)] = null);

(statearr_74798_74809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74791 === (6))){
var inst_74778 = (state_74790[(10)]);
var state_74790__$1 = state_74790;
var statearr_74799_74810 = state_74790__$1;
(statearr_74799_74810[(2)] = inst_74778);

(statearr_74799_74810[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74791 === (7))){
var inst_74786 = (state_74790[(2)]);
var state_74790__$1 = state_74790;
var statearr_74800_74811 = state_74790__$1;
(statearr_74800_74811[(2)] = inst_74786);

(statearr_74800_74811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10945__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10945__auto____0 = (function (){
var statearr_74801 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_74801[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10945__auto__);

(statearr_74801[(1)] = (1));

return statearr_74801;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10945__auto____1 = (function (state_74790){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_74790);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e74802){var ex__10948__auto__ = e74802;
var statearr_74803_74812 = state_74790;
(statearr_74803_74812[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_74790[(4)]))){
var statearr_74804_74813 = state_74790;
(statearr_74804_74813[(1)] = cljs.core.first.call(null,(state_74790[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74814 = state_74790;
state_74790 = G__74814;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10945__auto__ = function(state_74790){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10945__auto____1.call(this,state_74790);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10945__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10945__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_74805 = f__11019__auto__.call(null);
(statearr_74805[(6)] = c__11018__auto__);

return statearr_74805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_74882){
var state_val_74883 = (state_74882[(1)]);
if((state_val_74883 === (7))){
var inst_74842 = (state_74882[(2)]);
var inst_74843 = fluree.db.util.async.throw_err.call(null,inst_74842);
var state_74882__$1 = state_74882;
var statearr_74884_74910 = state_74882__$1;
(statearr_74884_74910[(2)] = inst_74843);

(statearr_74884_74910[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74883 === (1))){
var inst_74819 = cljs.core.volatile_BANG_.call(null,(0));
var inst_74820 = cljs.core.PersistentHashMap.EMPTY;
var inst_74821 = cljs.core.volatile_BANG_.call(null,inst_74820);
var inst_74822 = cljs.core.first.call(null,resp);
var inst_74823 = cljs.core.rest.call(null,resp);
var inst_74824 = cljs.core.PersistentVector.EMPTY;
var inst_74825 = inst_74819;
var inst_74826 = inst_74821;
var inst_74827 = inst_74822;
var inst_74828 = inst_74823;
var inst_74829 = inst_74824;
var state_74882__$1 = (function (){var statearr_74885 = state_74882;
(statearr_74885[(7)] = inst_74829);

(statearr_74885[(8)] = inst_74825);

(statearr_74885[(9)] = inst_74826);

(statearr_74885[(10)] = inst_74828);

(statearr_74885[(11)] = inst_74827);

return statearr_74885;
})();
var statearr_74886_74911 = state_74882__$1;
(statearr_74886_74911[(2)] = null);

(statearr_74886_74911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74883 === (4))){
var inst_74829 = (state_74882[(7)]);
var inst_74831 = (state_74882[(12)]);
var inst_74825 = (state_74882[(8)]);
var inst_74826 = (state_74882[(9)]);
var inst_74828 = (state_74882[(10)]);
var inst_74827 = (state_74882[(11)]);
var inst_74833 = (state_74882[(13)]);
var inst_74837 = (function (){var fuel = inst_74825;
var cache = inst_74826;
var curr_block = inst_74827;
var rest_blocks = inst_74828;
var acc = inst_74829;
var flakes = inst_74831;
var asserted = inst_74833;
return (function (p1__74816_SHARP_){
return p1__74816_SHARP_.s;
});
})();
var inst_74838 = cljs.core.group_by.call(null,inst_74837,inst_74833);
var inst_74839 = cljs.core.vals.call(null,inst_74838);
var inst_74840 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_74826,inst_74825,inst_74839);
var state_74882__$1 = state_74882;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74882__$1,(7),inst_74840);
} else {
if((state_val_74883 === (13))){
var inst_74870 = (state_74882[(14)]);
var state_74882__$1 = state_74882;
var statearr_74887_74912 = state_74882__$1;
(statearr_74887_74912[(2)] = inst_74870);

(statearr_74887_74912[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74883 === (6))){
var inst_74829 = (state_74882[(7)]);
var inst_74831 = (state_74882[(12)]);
var inst_74846 = (state_74882[(15)]);
var inst_74825 = (state_74882[(8)]);
var inst_74826 = (state_74882[(9)]);
var inst_74828 = (state_74882[(10)]);
var inst_74827 = (state_74882[(11)]);
var inst_74833 = (state_74882[(13)]);
var inst_74848 = (state_74882[(16)]);
var inst_74846__$1 = (state_74882[(2)]);
var inst_74847 = (function (){var fuel = inst_74825;
var cache = inst_74826;
var curr_block = inst_74827;
var rest_blocks = inst_74828;
var acc = inst_74829;
var flakes = inst_74831;
var asserted = inst_74833;
var asserted_SINGLEQUOTE_ = inst_74846__$1;
return (function (p1__74817_SHARP_){
return p1__74817_SHARP_.op === false;
});
})();
var inst_74848__$1 = cljs.core.filter.call(null,inst_74847,inst_74831);
var inst_74849 = cljs.core.empty_QMARK_.call(null,inst_74848__$1);
var inst_74850 = (!(inst_74849));
var state_74882__$1 = (function (){var statearr_74890 = state_74882;
(statearr_74890[(15)] = inst_74846__$1);

(statearr_74890[(16)] = inst_74848__$1);

return statearr_74890;
})();
if(inst_74850){
var statearr_74891_74913 = state_74882__$1;
(statearr_74891_74913[(1)] = (8));

} else {
var statearr_74892_74914 = state_74882__$1;
(statearr_74892_74914[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74883 === (3))){
var inst_74880 = (state_74882[(2)]);
var state_74882__$1 = state_74882;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74882__$1,inst_74880);
} else {
if((state_val_74883 === (12))){
var inst_74825 = (state_74882[(8)]);
var inst_74826 = (state_74882[(9)]);
var inst_74828 = (state_74882[(10)]);
var inst_74870 = (state_74882[(14)]);
var inst_74873 = cljs.core.first.call(null,inst_74828);
var inst_74874 = cljs.core.rest.call(null,inst_74828);
var tmp74888 = inst_74825;
var tmp74889 = inst_74826;
var inst_74825__$1 = tmp74888;
var inst_74826__$1 = tmp74889;
var inst_74827 = inst_74873;
var inst_74828__$1 = inst_74874;
var inst_74829 = inst_74870;
var state_74882__$1 = (function (){var statearr_74893 = state_74882;
(statearr_74893[(7)] = inst_74829);

(statearr_74893[(8)] = inst_74825__$1);

(statearr_74893[(9)] = inst_74826__$1);

(statearr_74893[(10)] = inst_74828__$1);

(statearr_74893[(11)] = inst_74827);

return statearr_74893;
})();
var statearr_74894_74915 = state_74882__$1;
(statearr_74894_74915[(2)] = null);

(statearr_74894_74915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74883 === (2))){
var inst_74829 = (state_74882[(7)]);
var inst_74831 = (state_74882[(12)]);
var inst_74825 = (state_74882[(8)]);
var inst_74826 = (state_74882[(9)]);
var inst_74828 = (state_74882[(10)]);
var inst_74827 = (state_74882[(11)]);
var inst_74833 = (state_74882[(13)]);
var inst_74831__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_74827);
var inst_74832 = (function (){var fuel = inst_74825;
var cache = inst_74826;
var curr_block = inst_74827;
var rest_blocks = inst_74828;
var acc = inst_74829;
var flakes = inst_74831__$1;
return (function (p1__74815_SHARP_){
return p1__74815_SHARP_.op;
});
})();
var inst_74833__$1 = cljs.core.filter.call(null,inst_74832,inst_74831__$1);
var inst_74834 = cljs.core.empty_QMARK_.call(null,inst_74833__$1);
var inst_74835 = (!(inst_74834));
var state_74882__$1 = (function (){var statearr_74895 = state_74882;
(statearr_74895[(12)] = inst_74831__$1);

(statearr_74895[(13)] = inst_74833__$1);

return statearr_74895;
})();
if(inst_74835){
var statearr_74896_74916 = state_74882__$1;
(statearr_74896_74916[(1)] = (4));

} else {
var statearr_74897_74917 = state_74882__$1;
(statearr_74897_74917[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74883 === (11))){
var inst_74858 = (state_74882[(2)]);
var inst_74859 = fluree.db.util.async.throw_err.call(null,inst_74858);
var state_74882__$1 = state_74882;
var statearr_74898_74918 = state_74882__$1;
(statearr_74898_74918[(2)] = inst_74859);

(statearr_74898_74918[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74883 === (9))){
var state_74882__$1 = state_74882;
var statearr_74899_74919 = state_74882__$1;
(statearr_74899_74919[(2)] = null);

(statearr_74899_74919[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74883 === (5))){
var state_74882__$1 = state_74882;
var statearr_74900_74920 = state_74882__$1;
(statearr_74900_74920[(2)] = null);

(statearr_74900_74920[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74883 === (14))){
var inst_74878 = (state_74882[(2)]);
var state_74882__$1 = state_74882;
var statearr_74901_74921 = state_74882__$1;
(statearr_74901_74921[(2)] = inst_74878);

(statearr_74901_74921[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74883 === (10))){
var inst_74829 = (state_74882[(7)]);
var inst_74846 = (state_74882[(15)]);
var inst_74828 = (state_74882[(10)]);
var inst_74827 = (state_74882[(11)]);
var inst_74862 = (state_74882[(2)]);
var inst_74863 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_74864 = [inst_74846,inst_74862];
var inst_74865 = cljs.core.PersistentHashMap.fromArrays(inst_74863,inst_74864);
var inst_74866 = cljs.core.assoc.call(null,inst_74827,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_74865);
var inst_74867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74868 = [inst_74866];
var inst_74869 = (new cljs.core.PersistentVector(null,1,(5),inst_74867,inst_74868,null));
var inst_74870 = cljs.core.concat.call(null,inst_74829,inst_74869);
var inst_74871 = cljs.core.first.call(null,inst_74828);
var state_74882__$1 = (function (){var statearr_74902 = state_74882;
(statearr_74902[(14)] = inst_74870);

return statearr_74902;
})();
if(cljs.core.truth_(inst_74871)){
var statearr_74903_74922 = state_74882__$1;
(statearr_74903_74922[(1)] = (12));

} else {
var statearr_74904_74923 = state_74882__$1;
(statearr_74904_74923[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74883 === (8))){
var inst_74829 = (state_74882[(7)]);
var inst_74831 = (state_74882[(12)]);
var inst_74846 = (state_74882[(15)]);
var inst_74825 = (state_74882[(8)]);
var inst_74826 = (state_74882[(9)]);
var inst_74828 = (state_74882[(10)]);
var inst_74827 = (state_74882[(11)]);
var inst_74833 = (state_74882[(13)]);
var inst_74848 = (state_74882[(16)]);
var inst_74852 = (function (){var flakes = inst_74831;
var rest_blocks = inst_74828;
var curr_block = inst_74827;
var asserted_SINGLEQUOTE_ = inst_74846;
var acc = inst_74829;
var fuel = inst_74825;
var cache = inst_74826;
var retracted = inst_74848;
var asserted = inst_74833;
return (function (p1__74818_SHARP_){
return p1__74818_SHARP_.s;
});
})();
var inst_74853 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_74848);
var inst_74854 = cljs.core.group_by.call(null,inst_74852,inst_74853);
var inst_74855 = cljs.core.vals.call(null,inst_74854);
var inst_74856 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_74826,inst_74825,inst_74855);
var state_74882__$1 = state_74882;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74882__$1,(11),inst_74856);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__10945__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__10945__auto____0 = (function (){
var statearr_74905 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74905[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__10945__auto__);

(statearr_74905[(1)] = (1));

return statearr_74905;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__10945__auto____1 = (function (state_74882){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_74882);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e74906){var ex__10948__auto__ = e74906;
var statearr_74907_74924 = state_74882;
(statearr_74907_74924[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_74882[(4)]))){
var statearr_74908_74925 = state_74882;
(statearr_74908_74925[(1)] = cljs.core.first.call(null,(state_74882[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74926 = state_74882;
state_74882 = G__74926;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__10945__auto__ = function(state_74882){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__10945__auto____1.call(this,state_74882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__10945__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__10945__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_74909 = f__11019__auto__.call(null);
(statearr_74909[(6)] = c__11018__auto__);

return statearr_74909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_75026){
var state_val_75027 = (state_75026[(1)]);
if((state_val_75027 === (7))){
var inst_74991 = (state_75026[(7)]);
var inst_74998 = (state_75026[(8)]);
var inst_74997 = cljs.core.seq.call(null,inst_74991);
var inst_74998__$1 = cljs.core.first.call(null,inst_74997);
var inst_74999 = cljs.core.next.call(null,inst_74997);
var state_75026__$1 = (function (){var statearr_75028 = state_75026;
(statearr_75028[(9)] = inst_74999);

(statearr_75028[(8)] = inst_74998__$1);

return statearr_75028;
})();
if(cljs.core.truth_(inst_74998__$1)){
var statearr_75029_75066 = state_75026__$1;
(statearr_75029_75066[(1)] = (9));

} else {
var statearr_75030_75067 = state_75026__$1;
(statearr_75030_75067[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75027 === (1))){
var state_75026__$1 = state_75026;
var statearr_75031_75068 = state_75026__$1;
(statearr_75031_75068[(2)] = null);

(statearr_75031_75068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75027 === (4))){
var inst_74928 = (state_75026[(2)]);
var state_75026__$1 = state_75026;
var statearr_75032_75069 = state_75026__$1;
(statearr_75032_75069[(2)] = inst_74928);

(statearr_75032_75069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75027 === (6))){
var inst_74977 = (state_75026[(2)]);
var inst_74978 = fluree.db.util.async.throw_err.call(null,inst_74977);
var inst_74986 = resp;
var inst_74987 = cljs.core.seq.call(null,inst_74986);
var inst_74988 = cljs.core.first.call(null,inst_74987);
var inst_74989 = cljs.core.next.call(null,inst_74987);
var inst_74990 = cljs.core.PersistentHashMap.EMPTY;
var inst_74991 = inst_74986;
var inst_74992 = inst_74990;
var state_75026__$1 = (function (){var statearr_75033 = state_75026;
(statearr_75033[(7)] = inst_74991);

(statearr_75033[(10)] = inst_74978);

(statearr_75033[(11)] = inst_74988);

(statearr_75033[(12)] = inst_74989);

(statearr_75033[(13)] = inst_74992);

return statearr_75033;
})();
var statearr_75034_75070 = state_75026__$1;
(statearr_75034_75070[(2)] = null);

(statearr_75034_75070[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75027 === (3))){
var inst_75024 = (state_75026[(2)]);
var state_75026__$1 = state_75026;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75026__$1,inst_75024);
} else {
if((state_val_75027 === (2))){
var _ = (function (){var statearr_75035 = state_75026;
(statearr_75035[(4)] = cljs.core.cons.call(null,(5),(state_75026[(4)])));

return statearr_75035;
})();
var inst_74934 = (function (){return (function (p1__74927_SHARP_){
return p1__74927_SHARP_.t;
});
})();
var inst_74935 = cljs.core.map.call(null,inst_74934,resp);
var inst_74936 = cljs.core.set.call(null,inst_74935);
var inst_74973 = cljs.core.async.chan.call(null,(1));
var inst_74974 = (function (){var ts = inst_74936;
var c__11018__auto____$1 = inst_74973;
return (function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_74971){
var state_val_74972 = (state_74971[(1)]);
if((state_val_74972 === (1))){
var inst_74944 = ts;
var inst_74945 = cljs.core.seq.call(null,inst_74944);
var inst_74946 = cljs.core.first.call(null,inst_74945);
var inst_74947 = cljs.core.next.call(null,inst_74945);
var inst_74948 = cljs.core.PersistentHashMap.EMPTY;
var inst_74949 = inst_74944;
var inst_74950 = inst_74948;
var state_74971__$1 = (function (){var statearr_75036 = state_74971;
(statearr_75036[(7)] = inst_74950);

(statearr_75036[(8)] = inst_74946);

(statearr_75036[(9)] = inst_74947);

(statearr_75036[(10)] = inst_74949);

return statearr_75036;
})();
var statearr_75037_75071 = state_74971__$1;
(statearr_75037_75071[(2)] = null);

(statearr_75037_75071[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74972 === (2))){
var inst_74956 = (state_74971[(11)]);
var inst_74949 = (state_74971[(10)]);
var inst_74955 = cljs.core.seq.call(null,inst_74949);
var inst_74956__$1 = cljs.core.first.call(null,inst_74955);
var inst_74957 = cljs.core.next.call(null,inst_74955);
var state_74971__$1 = (function (){var statearr_75038 = state_74971;
(statearr_75038[(11)] = inst_74956__$1);

(statearr_75038[(12)] = inst_74957);

return statearr_75038;
})();
if(cljs.core.truth_(inst_74956__$1)){
var statearr_75039_75072 = state_74971__$1;
(statearr_75039_75072[(1)] = (4));

} else {
var statearr_75040_75073 = state_74971__$1;
(statearr_75040_75073[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74972 === (3))){
var inst_74969 = (state_74971[(2)]);
var state_74971__$1 = state_74971;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74971__$1,inst_74969);
} else {
if((state_val_74972 === (4))){
var inst_74956 = (state_74971[(11)]);
var inst_74959 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_74956);
var state_74971__$1 = state_74971;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74971__$1,(7),inst_74959);
} else {
if((state_val_74972 === (5))){
var inst_74950 = (state_74971[(7)]);
var state_74971__$1 = state_74971;
var statearr_75041_75074 = state_74971__$1;
(statearr_75041_75074[(2)] = inst_74950);

(statearr_75041_75074[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74972 === (6))){
var inst_74967 = (state_74971[(2)]);
var state_74971__$1 = state_74971;
var statearr_75042_75075 = state_74971__$1;
(statearr_75042_75075[(2)] = inst_74967);

(statearr_75042_75075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74972 === (7))){
var inst_74950 = (state_74971[(7)]);
var inst_74956 = (state_74971[(11)]);
var inst_74957 = (state_74971[(12)]);
var inst_74961 = (state_74971[(2)]);
var inst_74962 = fluree.db.util.async.throw_err.call(null,inst_74961);
var inst_74963 = cljs.core.assoc.call(null,inst_74950,inst_74956,inst_74962);
var inst_74949 = inst_74957;
var inst_74950__$1 = inst_74963;
var state_74971__$1 = (function (){var statearr_75043 = state_74971;
(statearr_75043[(7)] = inst_74950__$1);

(statearr_75043[(10)] = inst_74949);

return statearr_75043;
})();
var statearr_75044_75076 = state_74971__$1;
(statearr_75044_75076[(2)] = null);

(statearr_75044_75076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__10945__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__10945__auto____0 = (function (){
var statearr_75045 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75045[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__10945__auto__);

(statearr_75045[(1)] = (1));

return statearr_75045;
});
var fluree$db$api_js$format_history_resp_$_state_machine__10945__auto____1 = (function (state_74971){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_74971);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e75046){var ex__10948__auto__ = e75046;
var statearr_75047_75077 = state_74971;
(statearr_75047_75077[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_74971[(4)]))){
var statearr_75048_75078 = state_74971;
(statearr_75048_75078[(1)] = cljs.core.first.call(null,(state_74971[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75079 = state_74971;
state_74971 = G__75079;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__10945__auto__ = function(state_74971){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__10945__auto____1.call(this,state_74971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__10945__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__10945__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_75049 = f__11019__auto__.call(null);
(statearr_75049[(6)] = c__11018__auto____$1);

return statearr_75049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
});
})();
var inst_74975 = cljs.core.async.impl.dispatch.run.call(null,inst_74974);
var state_75026__$1 = (function (){var statearr_75050 = state_75026;
(statearr_75050[(14)] = inst_74975);

return statearr_75050;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75026__$1,(6),inst_74973);
} else {
if((state_val_75027 === (11))){
var inst_75018 = (state_75026[(2)]);
var state_75026__$1 = state_75026;
var statearr_75052_75080 = state_75026__$1;
(statearr_75052_75080[(2)] = inst_75018);

(statearr_75052_75080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75027 === (9))){
var inst_74999 = (state_75026[(9)]);
var inst_74978 = (state_75026[(10)]);
var inst_74998 = (state_75026[(8)]);
var inst_74992 = (state_75026[(13)]);
var inst_75001 = inst_74998.t;
var inst_75002 = cljs.core.get.call(null,inst_74978,inst_75001);
var inst_75003 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75004 = [inst_75002,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_75005 = (new cljs.core.PersistentVector(null,2,(5),inst_75003,inst_75004,null));
var inst_75006 = cljs.core.assoc_in.call(null,inst_74992,inst_75005,inst_75002);
var inst_75007 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75008 = [inst_75002,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_75009 = (new cljs.core.PersistentVector(null,2,(5),inst_75007,inst_75008,null));
var inst_75010 = cljs.core.update_in.call(null,inst_75006,inst_75009,cljs.core.conj,inst_74998);
var inst_75011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75012 = [inst_75002,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_75013 = (new cljs.core.PersistentVector(null,2,(5),inst_75011,inst_75012,null));
var inst_75014 = cljs.core.update_in.call(null,inst_75010,inst_75013,fluree.db.api_js.min_safe,inst_75001);
var inst_74991 = inst_74999;
var inst_74992__$1 = inst_75014;
var state_75026__$1 = (function (){var statearr_75053 = state_75026;
(statearr_75053[(7)] = inst_74991);

(statearr_75053[(13)] = inst_74992__$1);

return statearr_75053;
})();
var statearr_75054_75081 = state_75026__$1;
(statearr_75054_75081[(2)] = null);

(statearr_75054_75081[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75027 === (5))){
var _ = (function (){var statearr_75055 = state_75026;
(statearr_75055[(4)] = cljs.core.rest.call(null,(state_75026[(4)])));

return statearr_75055;
})();
var state_75026__$1 = state_75026;
var ex75051 = (state_75026__$1[(2)]);
var statearr_75056_75082 = state_75026__$1;
(statearr_75056_75082[(5)] = ex75051);


if((ex75051 instanceof Error)){
var statearr_75057_75083 = state_75026__$1;
(statearr_75057_75083[(1)] = (4));

(statearr_75057_75083[(5)] = null);

} else {
throw ex75051;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75027 === (10))){
var inst_74992 = (state_75026[(13)]);
var state_75026__$1 = state_75026;
var statearr_75058_75084 = state_75026__$1;
(statearr_75058_75084[(2)] = inst_74992);

(statearr_75058_75084[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75027 === (8))){
var inst_75020 = (state_75026[(2)]);
var inst_75021 = cljs.core.vals.call(null,inst_75020);
var _ = (function (){var statearr_75059 = state_75026;
(statearr_75059[(4)] = cljs.core.rest.call(null,(state_75026[(4)])));

return statearr_75059;
})();
var state_75026__$1 = state_75026;
var statearr_75060_75085 = state_75026__$1;
(statearr_75060_75085[(2)] = inst_75021);

(statearr_75060_75085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__10945__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__10945__auto____0 = (function (){
var statearr_75061 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75061[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__10945__auto__);

(statearr_75061[(1)] = (1));

return statearr_75061;
});
var fluree$db$api_js$format_history_resp_$_state_machine__10945__auto____1 = (function (state_75026){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_75026);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e75062){var ex__10948__auto__ = e75062;
var statearr_75063_75086 = state_75026;
(statearr_75063_75086[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_75026[(4)]))){
var statearr_75064_75087 = state_75026;
(statearr_75064_75087[(1)] = cljs.core.first.call(null,(state_75026[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75088 = state_75026;
state_75026 = G__75088;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__10945__auto__ = function(state_75026){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__10945__auto____1.call(this,state_75026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__10945__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__10945__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_75065 = f__11019__auto__.call(null);
(statearr_75065[(6)] = c__11018__auto__);

return statearr_75065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_75233){
var state_val_75234 = (state_75233[(1)]);
if((state_val_75234 === (7))){
var inst_75113 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75114 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_75115 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_75116 = [inst_75114,inst_75115];
var inst_75117 = (new cljs.core.PersistentVector(null,2,(5),inst_75113,inst_75116,null));
var state_75233__$1 = state_75233;
var statearr_75235_75306 = state_75233__$1;
(statearr_75235_75306[(2)] = inst_75117);

(statearr_75235_75306[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (20))){
var inst_75143 = (state_75233[(7)]);
var state_75233__$1 = state_75233;
var statearr_75236_75307 = state_75233__$1;
(statearr_75236_75307[(2)] = inst_75143);

(statearr_75236_75307[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (27))){
var state_75233__$1 = state_75233;
var statearr_75237_75308 = state_75233__$1;
(statearr_75237_75308[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (1))){
var state_75233__$1 = state_75233;
var statearr_75239_75309 = state_75233__$1;
(statearr_75239_75309[(2)] = null);

(statearr_75239_75309[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (24))){
var inst_75142 = (state_75233[(8)]);
var state_75233__$1 = state_75233;
if(cljs.core.truth_(inst_75142)){
var statearr_75240_75310 = state_75233__$1;
(statearr_75240_75310[(1)] = (26));

} else {
var statearr_75241_75311 = state_75233__$1;
(statearr_75241_75311[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (39))){
var inst_75188 = (state_75233[(9)]);
var inst_75189 = (state_75233[(10)]);
var inst_75214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75215 = [inst_75188,inst_75189];
var inst_75216 = (new cljs.core.PersistentVector(null,2,(5),inst_75214,inst_75215,null));
var state_75233__$1 = state_75233;
var statearr_75242_75312 = state_75233__$1;
(statearr_75242_75312[(2)] = inst_75216);

(statearr_75242_75312[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (4))){
var inst_75089 = (state_75233[(2)]);
var inst_75090 = fluree.db.util.log.error.call(null,inst_75089);
var inst_75091 = cljs.core.ex_data.call(null,inst_75089);
var inst_75092 = cljs.core.ex_message.call(null,inst_75089);
var inst_75093 = cljs.core.assoc.call(null,inst_75091,new cljs.core.Keyword(null,"message","message",-406056002),inst_75092);
var state_75233__$1 = (function (){var statearr_75243 = state_75233;
(statearr_75243[(11)] = inst_75090);

return statearr_75243;
})();
var statearr_75244_75313 = state_75233__$1;
(statearr_75244_75313[(2)] = inst_75093);

(statearr_75244_75313[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (15))){
var inst_75127 = (state_75233[(12)]);
var inst_75122 = (state_75233[(13)]);
var inst_75136 = (state_75233[(2)]);
var inst_75137 = [inst_75127,inst_75136];
var inst_75138 = (new cljs.core.PersistentVector(null,2,(5),inst_75122,inst_75137,null));
var state_75233__$1 = state_75233;
var statearr_75245_75314 = state_75233__$1;
(statearr_75245_75314[(2)] = inst_75138);

(statearr_75245_75314[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (21))){
var inst_75142 = (state_75233[(8)]);
var state_75233__$1 = state_75233;
var statearr_75246_75315 = state_75233__$1;
(statearr_75246_75315[(2)] = inst_75142);

(statearr_75246_75315[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (31))){
var inst_75183 = (state_75233[(2)]);
var state_75233__$1 = state_75233;
var statearr_75247_75316 = state_75233__$1;
(statearr_75247_75316[(2)] = inst_75183);

(statearr_75247_75316[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (32))){
var inst_75189 = (state_75233[(10)]);
var inst_75192 = cljs.core.pos_int_QMARK_.call(null,inst_75189);
var state_75233__$1 = state_75233;
var statearr_75248_75317 = state_75233__$1;
(statearr_75248_75317[(2)] = inst_75192);

(statearr_75248_75317[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (40))){
var inst_75220 = (state_75233[(14)]);
var inst_75144 = (state_75233[(15)]);
var inst_75218 = (state_75233[(2)]);
var inst_75219 = cljs.core.nth.call(null,inst_75218,(0),null);
var inst_75220__$1 = cljs.core.nth.call(null,inst_75218,(1),null);
var inst_75221 = (inst_75220__$1 > inst_75144);
var state_75233__$1 = (function (){var statearr_75249 = state_75233;
(statearr_75249[(14)] = inst_75220__$1);

(statearr_75249[(16)] = inst_75219);

return statearr_75249;
})();
if(cljs.core.truth_(inst_75221)){
var statearr_75250_75318 = state_75233__$1;
(statearr_75250_75318[(1)] = (41));

} else {
var statearr_75251_75319 = state_75233__$1;
(statearr_75251_75319[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (33))){
var inst_75190 = (state_75233[(17)]);
var state_75233__$1 = state_75233;
var statearr_75252_75320 = state_75233__$1;
(statearr_75252_75320[(2)] = inst_75190);

(statearr_75252_75320[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (13))){
var inst_75128 = (state_75233[(18)]);
var inst_75130 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_75128);
var state_75233__$1 = state_75233;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75233__$1,(16),inst_75130);
} else {
if((state_val_75234 === (22))){
var inst_75161 = (state_75233[(2)]);
var state_75233__$1 = state_75233;
if(cljs.core.truth_(inst_75161)){
var statearr_75253_75321 = state_75233__$1;
(statearr_75253_75321[(1)] = (23));

} else {
var statearr_75254_75322 = state_75233__$1;
(statearr_75254_75322[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (36))){
var state_75233__$1 = state_75233;
var statearr_75255_75323 = state_75233__$1;
(statearr_75255_75323[(2)] = null);

(statearr_75255_75323[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (41))){
var inst_75144 = (state_75233[(15)]);
var state_75233__$1 = state_75233;
var statearr_75256_75324 = state_75233__$1;
(statearr_75256_75324[(2)] = inst_75144);

(statearr_75256_75324[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (43))){
var inst_75219 = (state_75233[(16)]);
var inst_75225 = (state_75233[(2)]);
var inst_75226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75227 = [inst_75219,inst_75225];
var inst_75228 = (new cljs.core.PersistentVector(null,2,(5),inst_75226,inst_75227,null));
var _ = (function (){var statearr_75257 = state_75233;
(statearr_75257[(4)] = cljs.core.rest.call(null,(state_75233[(4)])));

return statearr_75257;
})();
var state_75233__$1 = state_75233;
var statearr_75258_75325 = state_75233__$1;
(statearr_75258_75325[(2)] = inst_75228);

(statearr_75258_75325[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (29))){
var inst_75119 = (state_75233[(19)]);
var inst_75174 = cljs.core.pr_str.call(null,inst_75119);
var inst_75175 = ["Invalid block range provided: ",inst_75174].join('');
var inst_75176 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75177 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75178 = cljs.core.PersistentHashMap.fromArrays(inst_75176,inst_75177);
var inst_75179 = cljs.core.ex_info.call(null,inst_75175,inst_75178);
var inst_75180 = (function(){throw inst_75179})();
var state_75233__$1 = state_75233;
var statearr_75259_75326 = state_75233__$1;
(statearr_75259_75326[(2)] = inst_75180);

(statearr_75259_75326[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (6))){
var inst_75111 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_75233__$1 = state_75233;
var statearr_75260_75327 = state_75233__$1;
(statearr_75260_75327[(2)] = inst_75111);

(statearr_75260_75327[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (28))){
var inst_75185 = (state_75233[(2)]);
var state_75233__$1 = state_75233;
var statearr_75261_75328 = state_75233__$1;
(statearr_75261_75328[(2)] = inst_75185);

(statearr_75261_75328[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (25))){
var inst_75190 = (state_75233[(17)]);
var inst_75188 = (state_75233[(9)]);
var inst_75187 = (state_75233[(2)]);
var inst_75188__$1 = cljs.core.nth.call(null,inst_75187,(0),null);
var inst_75189 = cljs.core.nth.call(null,inst_75187,(1),null);
var inst_75190__$1 = cljs.core.pos_int_QMARK_.call(null,inst_75188__$1);
var state_75233__$1 = (function (){var statearr_75262 = state_75233;
(statearr_75262[(17)] = inst_75190__$1);

(statearr_75262[(9)] = inst_75188__$1);

(statearr_75262[(10)] = inst_75189);

return statearr_75262;
})();
if(inst_75190__$1){
var statearr_75263_75329 = state_75233__$1;
(statearr_75263_75329[(1)] = (32));

} else {
var statearr_75264_75330 = state_75233__$1;
(statearr_75264_75330[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (34))){
var inst_75195 = (state_75233[(2)]);
var inst_75196 = cljs.core.not.call(null,inst_75195);
var state_75233__$1 = state_75233;
if(inst_75196){
var statearr_75265_75331 = state_75233__$1;
(statearr_75265_75331[(1)] = (35));

} else {
var statearr_75266_75332 = state_75233__$1;
(statearr_75266_75332[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (17))){
var inst_75142 = (state_75233[(8)]);
var inst_75144 = (state_75233[(15)]);
var inst_75147 = cljs.core.pr_str.call(null,inst_75142);
var inst_75148 = cljs.core.pr_str.call(null,inst_75144);
var inst_75149 = ["Start block is out of range for this ledger. Start block provided: ",inst_75147,". Database block: ",inst_75148].join('');
var inst_75150 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75151 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75152 = cljs.core.PersistentHashMap.fromArrays(inst_75150,inst_75151);
var inst_75153 = cljs.core.ex_info.call(null,inst_75149,inst_75152);
var inst_75154 = (function(){throw inst_75153})();
var state_75233__$1 = state_75233;
var statearr_75267_75333 = state_75233__$1;
(statearr_75267_75333[(2)] = inst_75154);

(statearr_75267_75333[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (3))){
var inst_75231 = (state_75233[(2)]);
var state_75233__$1 = state_75233;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75233__$1,inst_75231);
} else {
if((state_val_75234 === (12))){
var inst_75119 = (state_75233[(19)]);
var inst_75128 = (state_75233[(18)]);
var inst_75126 = (state_75233[(2)]);
var inst_75127 = fluree.db.util.async.throw_err.call(null,inst_75126);
var inst_75128__$1 = cljs.core.second.call(null,inst_75119);
var state_75233__$1 = (function (){var statearr_75268 = state_75233;
(statearr_75268[(12)] = inst_75127);

(statearr_75268[(18)] = inst_75128__$1);

return statearr_75268;
})();
if(cljs.core.truth_(inst_75128__$1)){
var statearr_75269_75334 = state_75233__$1;
(statearr_75269_75334[(1)] = (13));

} else {
var statearr_75270_75335 = state_75233__$1;
(statearr_75270_75335[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (2))){
var _ = (function (){var statearr_75271 = state_75233;
(statearr_75271[(4)] = cljs.core.cons.call(null,(5),(state_75233[(4)])));

return statearr_75271;
})();
var inst_75108 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_75109 = cljs.core.sequential_QMARK_.call(null,inst_75108);
var state_75233__$1 = state_75233;
if(inst_75109){
var statearr_75272_75336 = state_75233__$1;
(statearr_75272_75336[(1)] = (6));

} else {
var statearr_75273_75337 = state_75233__$1;
(statearr_75273_75337[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (23))){
var inst_75142 = (state_75233[(8)]);
var inst_75143 = (state_75233[(7)]);
var inst_75163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75164 = [inst_75142,inst_75143];
var inst_75165 = (new cljs.core.PersistentVector(null,2,(5),inst_75163,inst_75164,null));
var state_75233__$1 = state_75233;
var statearr_75274_75338 = state_75233__$1;
(statearr_75274_75338[(2)] = inst_75165);

(statearr_75274_75338[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (35))){
var inst_75119 = (state_75233[(19)]);
var inst_75198 = cljs.core.pr_str.call(null,inst_75119);
var inst_75199 = ["Invalid block range provided: ",inst_75198].join('');
var inst_75200 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75201 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75202 = cljs.core.PersistentHashMap.fromArrays(inst_75200,inst_75201);
var inst_75203 = cljs.core.ex_info.call(null,inst_75199,inst_75202);
var inst_75204 = (function(){throw inst_75203})();
var state_75233__$1 = state_75233;
var statearr_75275_75339 = state_75233__$1;
(statearr_75275_75339[(2)] = inst_75204);

(statearr_75275_75339[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (19))){
var inst_75142 = (state_75233[(8)]);
var inst_75157 = (state_75233[(2)]);
var state_75233__$1 = (function (){var statearr_75276 = state_75233;
(statearr_75276[(20)] = inst_75157);

return statearr_75276;
})();
if(cljs.core.truth_(inst_75142)){
var statearr_75277_75340 = state_75233__$1;
(statearr_75277_75340[(1)] = (20));

} else {
var statearr_75278_75341 = state_75233__$1;
(statearr_75278_75341[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (11))){
var inst_75142 = (state_75233[(8)]);
var inst_75144 = (state_75233[(15)]);
var inst_75141 = (state_75233[(2)]);
var inst_75142__$1 = cljs.core.nth.call(null,inst_75141,(0),null);
var inst_75143 = cljs.core.nth.call(null,inst_75141,(1),null);
var inst_75144__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_75145 = (inst_75142__$1 > inst_75144__$1);
var state_75233__$1 = (function (){var statearr_75280 = state_75233;
(statearr_75280[(8)] = inst_75142__$1);

(statearr_75280[(7)] = inst_75143);

(statearr_75280[(15)] = inst_75144__$1);

return statearr_75280;
})();
if(cljs.core.truth_(inst_75145)){
var statearr_75281_75342 = state_75233__$1;
(statearr_75281_75342[(1)] = (17));

} else {
var statearr_75282_75343 = state_75233__$1;
(statearr_75282_75343[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (9))){
var inst_75119 = (state_75233[(19)]);
var inst_75122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75123 = cljs.core.first.call(null,inst_75119);
var inst_75124 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_75123);
var state_75233__$1 = (function (){var statearr_75283 = state_75233;
(statearr_75283[(13)] = inst_75122);

return statearr_75283;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75233__$1,(12),inst_75124);
} else {
if((state_val_75234 === (5))){
var _ = (function (){var statearr_75284 = state_75233;
(statearr_75284[(4)] = cljs.core.rest.call(null,(state_75233[(4)])));

return statearr_75284;
})();
var state_75233__$1 = state_75233;
var ex75279 = (state_75233__$1[(2)]);
var statearr_75285_75344 = state_75233__$1;
(statearr_75285_75344[(5)] = ex75279);


var statearr_75286_75345 = state_75233__$1;
(statearr_75286_75345[(1)] = (4));

(statearr_75286_75345[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (14))){
var state_75233__$1 = state_75233;
var statearr_75287_75346 = state_75233__$1;
(statearr_75287_75346[(2)] = null);

(statearr_75287_75346[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (26))){
var inst_75142 = (state_75233[(8)]);
var inst_75168 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75169 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_75170 = [inst_75142,inst_75169];
var inst_75171 = (new cljs.core.PersistentVector(null,2,(5),inst_75168,inst_75170,null));
var state_75233__$1 = state_75233;
var statearr_75288_75347 = state_75233__$1;
(statearr_75288_75347[(2)] = inst_75171);

(statearr_75288_75347[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (16))){
var inst_75132 = (state_75233[(2)]);
var inst_75133 = fluree.db.util.async.throw_err.call(null,inst_75132);
var state_75233__$1 = state_75233;
var statearr_75289_75348 = state_75233__$1;
(statearr_75289_75348[(2)] = inst_75133);

(statearr_75289_75348[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (38))){
var inst_75188 = (state_75233[(9)]);
var inst_75189 = (state_75233[(10)]);
var inst_75210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75211 = [inst_75189,inst_75188];
var inst_75212 = (new cljs.core.PersistentVector(null,2,(5),inst_75210,inst_75211,null));
var state_75233__$1 = state_75233;
var statearr_75290_75349 = state_75233__$1;
(statearr_75290_75349[(2)] = inst_75212);

(statearr_75290_75349[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (30))){
var state_75233__$1 = state_75233;
var statearr_75291_75350 = state_75233__$1;
(statearr_75291_75350[(2)] = null);

(statearr_75291_75350[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (10))){
var inst_75119 = (state_75233[(19)]);
var state_75233__$1 = state_75233;
var statearr_75292_75351 = state_75233__$1;
(statearr_75292_75351[(2)] = inst_75119);

(statearr_75292_75351[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (18))){
var state_75233__$1 = state_75233;
var statearr_75293_75352 = state_75233__$1;
(statearr_75293_75352[(2)] = null);

(statearr_75293_75352[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (42))){
var inst_75220 = (state_75233[(14)]);
var state_75233__$1 = state_75233;
var statearr_75294_75353 = state_75233__$1;
(statearr_75294_75353[(2)] = inst_75220);

(statearr_75294_75353[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (37))){
var inst_75188 = (state_75233[(9)]);
var inst_75189 = (state_75233[(10)]);
var inst_75207 = (state_75233[(2)]);
var inst_75208 = (inst_75189 < inst_75188);
var state_75233__$1 = (function (){var statearr_75295 = state_75233;
(statearr_75295[(21)] = inst_75207);

return statearr_75295;
})();
if(cljs.core.truth_(inst_75208)){
var statearr_75296_75354 = state_75233__$1;
(statearr_75296_75354[(1)] = (38));

} else {
var statearr_75297_75355 = state_75233__$1;
(statearr_75297_75355[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75234 === (8))){
var inst_75119 = (state_75233[(19)]);
var inst_75119__$1 = (state_75233[(2)]);
var inst_75120 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_75119__$1);
var state_75233__$1 = (function (){var statearr_75298 = state_75233;
(statearr_75298[(19)] = inst_75119__$1);

return statearr_75298;
})();
if(cljs.core.truth_(inst_75120)){
var statearr_75299_75356 = state_75233__$1;
(statearr_75299_75356[(1)] = (9));

} else {
var statearr_75300_75357 = state_75233__$1;
(statearr_75300_75357[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__10945__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__10945__auto____0 = (function (){
var statearr_75301 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75301[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__10945__auto__);

(statearr_75301[(1)] = (1));

return statearr_75301;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__10945__auto____1 = (function (state_75233){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_75233);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e75302){var ex__10948__auto__ = e75302;
var statearr_75303_75358 = state_75233;
(statearr_75303_75358[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_75233[(4)]))){
var statearr_75304_75359 = state_75233;
(statearr_75304_75359[(1)] = cljs.core.first.call(null,(state_75233[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75360 = state_75233;
state_75233 = G__75360;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__10945__auto__ = function(state_75233){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__10945__auto____1.call(this,state_75233);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__10945__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__10945__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_75305 = f__11019__auto__.call(null);
(statearr_75305[(6)] = c__11018__auto__);

return statearr_75305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__75362 = arguments.length;
switch (G__75362) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_75453){
var state_val_75454 = (state_75453[(1)]);
if((state_val_75454 === (7))){
var inst_75385 = (state_75453[(7)]);
var inst_75388 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_75385);
var state_75453__$1 = state_75453;
var statearr_75455_75506 = state_75453__$1;
(statearr_75455_75506[(2)] = inst_75388);

(statearr_75455_75506[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (20))){
var inst_75424 = (state_75453[(8)]);
var inst_75427 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_75424);
var state_75453__$1 = state_75453;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75453__$1,(23),inst_75427);
} else {
if((state_val_75454 === (27))){
var inst_75433 = (state_75453[(9)]);
var inst_75439 = cljs.core.doall.call(null,inst_75433);
var state_75453__$1 = state_75453;
var statearr_75456_75507 = state_75453__$1;
(statearr_75456_75507[(2)] = inst_75439);

(statearr_75456_75507[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (1))){
var state_75453__$1 = state_75453;
var statearr_75457_75508 = state_75453__$1;
(statearr_75457_75508[(2)] = null);

(statearr_75457_75508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (24))){
var inst_75433 = (state_75453[(9)]);
var inst_75436 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_75437 = cljs.core.sequential_QMARK_.call(null,inst_75433);
var state_75453__$1 = (function (){var statearr_75458 = state_75453;
(statearr_75458[(10)] = inst_75436);

return statearr_75458;
})();
if(inst_75437){
var statearr_75459_75509 = state_75453__$1;
(statearr_75459_75509[(1)] = (27));

} else {
var statearr_75460_75510 = state_75453__$1;
(statearr_75460_75510[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (4))){
var inst_75363 = (state_75453[(2)]);
var inst_75364 = fluree.db.util.log.error.call(null,inst_75363);
var inst_75365 = cljs.core.ex_data.call(null,inst_75363);
var inst_75366 = cljs.core.ex_message.call(null,inst_75363);
var inst_75367 = cljs.core.assoc.call(null,inst_75365,new cljs.core.Keyword(null,"message","message",-406056002),inst_75366);
var state_75453__$1 = (function (){var statearr_75461 = state_75453;
(statearr_75461[(11)] = inst_75364);

return statearr_75461;
})();
var statearr_75462_75511 = state_75453__$1;
(statearr_75462_75511[(2)] = inst_75367);

(statearr_75462_75511[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (15))){
var inst_75385 = (state_75453[(7)]);
var inst_75398 = (state_75453[(2)]);
var inst_75399 = cljs.core.ex_info.call(null,inst_75398,inst_75385);
var inst_75400 = (function(){throw inst_75399})();
var state_75453__$1 = state_75453;
var statearr_75463_75512 = state_75453__$1;
(statearr_75463_75512[(2)] = inst_75400);

(statearr_75463_75512[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (21))){
var inst_75424 = (state_75453[(8)]);
var state_75453__$1 = state_75453;
var statearr_75464_75513 = state_75453__$1;
(statearr_75464_75513[(2)] = inst_75424);

(statearr_75464_75513[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (13))){
var inst_75393 = (state_75453[(12)]);
var state_75453__$1 = state_75453;
var statearr_75465_75514 = state_75453__$1;
(statearr_75465_75514[(2)] = inst_75393);

(statearr_75465_75514[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (22))){
var inst_75433 = (state_75453[(2)]);
var inst_75434 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_75453__$1 = (function (){var statearr_75466 = state_75453;
(statearr_75466[(9)] = inst_75433);

return statearr_75466;
})();
if(cljs.core.truth_(inst_75434)){
var statearr_75467_75515 = state_75453__$1;
(statearr_75467_75515[(1)] = (24));

} else {
var statearr_75468_75516 = state_75453__$1;
(statearr_75468_75516[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (29))){
var inst_75436 = (state_75453[(10)]);
var inst_75377 = (state_75453[(13)]);
var inst_75442 = (state_75453[(2)]);
var inst_75443 = fluree.db.util.core.response_time_formatted.call(null,inst_75377);
var inst_75444 = [(200),inst_75442,(100),inst_75443];
var inst_75445 = cljs.core.PersistentHashMap.fromArrays(inst_75436,inst_75444);
var state_75453__$1 = state_75453;
var statearr_75469_75517 = state_75453__$1;
(statearr_75469_75517[(2)] = inst_75445);

(statearr_75469_75517[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (6))){
var inst_75386 = (state_75453[(14)]);
var inst_75385 = (state_75453[(7)]);
var inst_75384 = (state_75453[(2)]);
var inst_75385__$1 = fluree.db.util.async.throw_err.call(null,inst_75384);
var inst_75386__$1 = cljs.core.map_QMARK_.call(null,inst_75385__$1);
var state_75453__$1 = (function (){var statearr_75470 = state_75453;
(statearr_75470[(14)] = inst_75386__$1);

(statearr_75470[(7)] = inst_75385__$1);

return statearr_75470;
})();
if(inst_75386__$1){
var statearr_75471_75518 = state_75453__$1;
(statearr_75471_75518[(1)] = (7));

} else {
var statearr_75472_75519 = state_75453__$1;
(statearr_75472_75519[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (28))){
var inst_75433 = (state_75453[(9)]);
var state_75453__$1 = state_75453;
var statearr_75473_75520 = state_75453__$1;
(statearr_75473_75520[(2)] = inst_75433);

(statearr_75473_75520[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (25))){
var inst_75433 = (state_75453[(9)]);
var state_75453__$1 = state_75453;
var statearr_75474_75521 = state_75453__$1;
(statearr_75474_75521[(2)] = inst_75433);

(statearr_75474_75521[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (17))){
var inst_75416 = cljs.core.pr_str.call(null,query_map);
var inst_75417 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_75416].join('');
var inst_75418 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75419 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75420 = cljs.core.PersistentHashMap.fromArrays(inst_75418,inst_75419);
var inst_75421 = cljs.core.ex_info.call(null,inst_75417,inst_75420);
var inst_75422 = (function(){throw inst_75421})();
var state_75453__$1 = state_75453;
var statearr_75475_75522 = state_75453__$1;
(statearr_75475_75522[(2)] = inst_75422);

(statearr_75475_75522[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (3))){
var inst_75451 = (state_75453[(2)]);
var state_75453__$1 = state_75453;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75453__$1,inst_75451);
} else {
if((state_val_75454 === (12))){
var inst_75385 = (state_75453[(7)]);
var inst_75403 = (state_75453[(2)]);
var inst_75404 = cljs.core.nth.call(null,inst_75385,(0),null);
var inst_75405 = cljs.core.nth.call(null,inst_75385,(1),null);
var inst_75406 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_75407 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_75408 = cljs.core.keys.call(null,inst_75407);
var inst_75409 = cljs.core._EQ_.call(null,inst_75406,inst_75408);
var state_75453__$1 = (function (){var statearr_75476 = state_75453;
(statearr_75476[(15)] = inst_75404);

(statearr_75476[(16)] = inst_75405);

(statearr_75476[(17)] = inst_75403);

return statearr_75476;
})();
if(inst_75409){
var statearr_75477_75523 = state_75453__$1;
(statearr_75477_75523[(1)] = (16));

} else {
var statearr_75478_75524 = state_75453__$1;
(statearr_75478_75524[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (2))){
var _ = (function (){var statearr_75479 = state_75453;
(statearr_75479[(4)] = cljs.core.cons.call(null,(5),(state_75453[(4)])));

return statearr_75479;
})();
var inst_75377 = fluree.db.util.core.current_time_millis.call(null);
var inst_75378 = db;
var inst_75379 = cljs.core.__destructure_map.call(null,inst_75378);
var inst_75380 = cljs.core.get.call(null,inst_75379,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_75381 = cljs.core.get.call(null,inst_75379,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_75382 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_75453__$1 = (function (){var statearr_75480 = state_75453;
(statearr_75480[(18)] = inst_75381);

(statearr_75480[(19)] = inst_75380);

(statearr_75480[(13)] = inst_75377);

return statearr_75480;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75453__$1,(6),inst_75382);
} else {
if((state_val_75454 === (23))){
var inst_75429 = (state_75453[(2)]);
var inst_75430 = fluree.db.util.async.throw_err.call(null,inst_75429);
var state_75453__$1 = state_75453;
var statearr_75481_75525 = state_75453__$1;
(statearr_75481_75525[(2)] = inst_75430);

(statearr_75481_75525[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (19))){
var inst_75413 = (state_75453[(2)]);
var inst_75414 = fluree.db.util.async.throw_err.call(null,inst_75413);
var state_75453__$1 = state_75453;
var statearr_75482_75526 = state_75453__$1;
(statearr_75482_75526[(2)] = inst_75414);

(statearr_75482_75526[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (11))){
var state_75453__$1 = state_75453;
var statearr_75484_75527 = state_75453__$1;
(statearr_75484_75527[(2)] = null);

(statearr_75484_75527[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (9))){
var inst_75391 = (state_75453[(2)]);
var state_75453__$1 = state_75453;
if(cljs.core.truth_(inst_75391)){
var statearr_75485_75528 = state_75453__$1;
(statearr_75485_75528[(1)] = (10));

} else {
var statearr_75486_75529 = state_75453__$1;
(statearr_75486_75529[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (5))){
var _ = (function (){var statearr_75487 = state_75453;
(statearr_75487[(4)] = cljs.core.rest.call(null,(state_75453[(4)])));

return statearr_75487;
})();
var state_75453__$1 = state_75453;
var ex75483 = (state_75453__$1[(2)]);
var statearr_75488_75530 = state_75453__$1;
(statearr_75488_75530[(5)] = ex75483);


var statearr_75489_75531 = state_75453__$1;
(statearr_75489_75531[(1)] = (4));

(statearr_75489_75531[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (14))){
var inst_75381 = (state_75453[(18)]);
var inst_75380 = (state_75453[(19)]);
var inst_75396 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75380),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75381)].join('');
var state_75453__$1 = state_75453;
var statearr_75490_75532 = state_75453__$1;
(statearr_75490_75532[(2)] = inst_75396);

(statearr_75490_75532[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (26))){
var inst_75448 = (state_75453[(2)]);
var _ = (function (){var statearr_75491 = state_75453;
(statearr_75491[(4)] = cljs.core.rest.call(null,(state_75453[(4)])));

return statearr_75491;
})();
var state_75453__$1 = state_75453;
var statearr_75492_75533 = state_75453__$1;
(statearr_75492_75533[(2)] = inst_75448);

(statearr_75492_75533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (16))){
var inst_75404 = (state_75453[(15)]);
var inst_75405 = (state_75453[(16)]);
var inst_75411 = fluree.db.query.block.block_range.call(null,db,inst_75404,inst_75405,opts);
var state_75453__$1 = state_75453;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75453__$1,(19),inst_75411);
} else {
if((state_val_75454 === (10))){
var inst_75393 = (state_75453[(12)]);
var inst_75385 = (state_75453[(7)]);
var inst_75393__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_75385);
var state_75453__$1 = (function (){var statearr_75493 = state_75453;
(statearr_75493[(12)] = inst_75393__$1);

return statearr_75493;
})();
if(cljs.core.truth_(inst_75393__$1)){
var statearr_75494_75534 = state_75453__$1;
(statearr_75494_75534[(1)] = (13));

} else {
var statearr_75495_75535 = state_75453__$1;
(statearr_75495_75535[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (18))){
var inst_75424 = (state_75453[(2)]);
var inst_75425 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_75453__$1 = (function (){var statearr_75496 = state_75453;
(statearr_75496[(8)] = inst_75424);

return statearr_75496;
})();
if(cljs.core.truth_(inst_75425)){
var statearr_75497_75536 = state_75453__$1;
(statearr_75497_75536[(1)] = (20));

} else {
var statearr_75498_75537 = state_75453__$1;
(statearr_75498_75537[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75454 === (8))){
var inst_75386 = (state_75453[(14)]);
var state_75453__$1 = state_75453;
var statearr_75499_75538 = state_75453__$1;
(statearr_75499_75538[(2)] = inst_75386);

(statearr_75499_75538[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__10945__auto__ = null;
var fluree$db$api_js$state_machine__10945__auto____0 = (function (){
var statearr_75500 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75500[(0)] = fluree$db$api_js$state_machine__10945__auto__);

(statearr_75500[(1)] = (1));

return statearr_75500;
});
var fluree$db$api_js$state_machine__10945__auto____1 = (function (state_75453){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_75453);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e75501){var ex__10948__auto__ = e75501;
var statearr_75502_75539 = state_75453;
(statearr_75502_75539[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_75453[(4)]))){
var statearr_75503_75540 = state_75453;
(statearr_75503_75540[(1)] = cljs.core.first.call(null,(state_75453[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75541 = state_75453;
state_75453 = G__75541;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__10945__auto__ = function(state_75453){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__10945__auto____1.call(this,state_75453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__10945__auto____0;
fluree$db$api_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__10945__auto____1;
return fluree$db$api_js$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_75504 = f__11019__auto__.call(null);
(statearr_75504[(6)] = c__11018__auto__);

return statearr_75504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__75543 = arguments.length;
switch (G__75543) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_75738){
var state_val_75739 = (state_75738[(1)]);
if((state_val_75739 === (62))){
var inst_75736 = (state_75738[(2)]);
var state_75738__$1 = state_75738;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75738__$1,inst_75736);
} else {
if((state_val_75739 === (7))){
var inst_75564 = (state_75738[(7)]);
var inst_75574 = cljs.core.not_EQ_.call(null,(1),inst_75564);
var state_75738__$1 = state_75738;
var statearr_75740_75831 = state_75738__$1;
(statearr_75740_75831[(2)] = inst_75574);

(statearr_75740_75831[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (59))){
var inst_75724 = (state_75738[(2)]);
var inst_75725 = fluree.db.util.async.throw_err.call(null,inst_75724);
var state_75738__$1 = state_75738;
var statearr_75741_75832 = state_75738__$1;
(statearr_75741_75832[(2)] = inst_75725);

(statearr_75741_75832[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (20))){
var inst_75632 = (state_75738[(8)]);
var inst_75640 = (state_75738[(9)]);
var inst_75632__$1 = (state_75738[(2)]);
var inst_75633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75634 = cljs.core.get.call(null,inst_75632__$1,(0));
var inst_75635 = cljs.core.get.call(null,inst_75632__$1,(1));
var inst_75636 = cljs.core.get.call(null,inst_75632__$1,(2));
var inst_75637 = cljs.core.get.call(null,inst_75632__$1,(3));
var inst_75638 = [inst_75634,inst_75635,inst_75636,inst_75637];
var inst_75639 = (new cljs.core.PersistentVector(null,4,(5),inst_75633,inst_75638,null));
var inst_75640__$1 = cljs.core.nth.call(null,inst_75639,(0),null);
var inst_75641 = cljs.core.nth.call(null,inst_75639,(1),null);
var inst_75642 = cljs.core.nth.call(null,inst_75639,(2),null);
var inst_75643 = cljs.core.nth.call(null,inst_75639,(3),null);
var inst_75644 = (inst_75640__$1 == null);
var inst_75645 = cljs.core.not.call(null,inst_75644);
var state_75738__$1 = (function (){var statearr_75742 = state_75738;
(statearr_75742[(8)] = inst_75632__$1);

(statearr_75742[(10)] = inst_75641);

(statearr_75742[(9)] = inst_75640__$1);

(statearr_75742[(11)] = inst_75642);

(statearr_75742[(12)] = inst_75643);

return statearr_75742;
})();
if(inst_75645){
var statearr_75743_75833 = state_75738__$1;
(statearr_75743_75833[(1)] = (30));

} else {
var statearr_75744_75834 = state_75738__$1;
(statearr_75744_75834[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (58))){
var inst_75572 = (state_75738[(13)]);
var inst_75728 = (state_75738[(2)]);
var state_75738__$1 = (function (){var statearr_75745 = state_75738;
(statearr_75745[(14)] = inst_75728);

return statearr_75745;
})();
if(cljs.core.truth_(inst_75572)){
var statearr_75746_75835 = state_75738__$1;
(statearr_75746_75835[(1)] = (60));

} else {
var statearr_75747_75836 = state_75738__$1;
(statearr_75747_75836[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (60))){
var inst_75716 = (state_75738[(15)]);
var inst_75728 = (state_75738[(14)]);
var inst_75730 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_75731 = cljs.core.count.call(null,inst_75716);
var inst_75732 = [inst_75728,inst_75731,(200)];
var inst_75733 = cljs.core.PersistentHashMap.fromArrays(inst_75730,inst_75732);
var state_75738__$1 = state_75738;
var statearr_75748_75837 = state_75738__$1;
(statearr_75748_75837[(2)] = inst_75733);

(statearr_75748_75837[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (27))){
var inst_75551 = (state_75738[(16)]);
var inst_75620 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75551)].join('');
var inst_75621 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75622 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75623 = cljs.core.PersistentHashMap.fromArrays(inst_75621,inst_75622);
var inst_75624 = cljs.core.ex_info.call(null,inst_75620,inst_75623);
var inst_75625 = (function(){throw inst_75624})();
var state_75738__$1 = state_75738;
var statearr_75749_75838 = state_75738__$1;
(statearr_75749_75838[(2)] = inst_75625);

(statearr_75749_75838[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (1))){
var inst_75548 = query_map;
var inst_75549 = cljs.core.__destructure_map.call(null,inst_75548);
var inst_75550 = cljs.core.get.call(null,inst_75549,new cljs.core.Keyword(null,"block","block",664686210));
var inst_75551 = cljs.core.get.call(null,inst_75549,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_75552 = cljs.core.get.call(null,inst_75549,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_75738__$1 = (function (){var statearr_75750 = state_75738;
(statearr_75750[(17)] = inst_75552);

(statearr_75750[(18)] = inst_75550);

(statearr_75750[(16)] = inst_75551);

return statearr_75750;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75738__$1,(2),sources);
} else {
if((state_val_75739 === (24))){
var inst_75551 = (state_75738[(16)]);
var inst_75609 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75551)].join('');
var inst_75610 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75611 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75612 = cljs.core.PersistentHashMap.fromArrays(inst_75610,inst_75611);
var inst_75613 = cljs.core.ex_info.call(null,inst_75609,inst_75612);
var inst_75614 = (function(){throw inst_75613})();
var state_75738__$1 = state_75738;
var statearr_75751_75839 = state_75738__$1;
(statearr_75751_75839[(2)] = inst_75614);

(statearr_75751_75839[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (55))){
var inst_75552 = (state_75738[(17)]);
var inst_75719 = (state_75738[(2)]);
var inst_75720 = fluree.db.util.async.throw_err.call(null,inst_75719);
var state_75738__$1 = (function (){var statearr_75752 = state_75738;
(statearr_75752[(19)] = inst_75720);

return statearr_75752;
})();
if(cljs.core.truth_(inst_75552)){
var statearr_75753_75840 = state_75738__$1;
(statearr_75753_75840[(1)] = (56));

} else {
var statearr_75754_75841 = state_75738__$1;
(statearr_75754_75841[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (39))){
var inst_75641 = (state_75738[(10)]);
var inst_75640 = (state_75738[(9)]);
var inst_75642 = (state_75738[(11)]);
var inst_75643 = (state_75738[(12)]);
var inst_75664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75665 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75666 = [inst_75641,inst_75640,inst_75642,inst_75643];
var inst_75667 = (new cljs.core.PersistentVector(null,4,(5),inst_75665,inst_75666,null));
var inst_75668 = [inst_75667,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_75669 = (new cljs.core.PersistentVector(null,2,(5),inst_75664,inst_75668,null));
var state_75738__$1 = state_75738;
var statearr_75755_75842 = state_75738__$1;
(statearr_75755_75842[(2)] = inst_75669);

(statearr_75755_75842[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (46))){
var inst_75674 = (state_75738[(20)]);
var state_75738__$1 = state_75738;
var statearr_75756_75843 = state_75738__$1;
(statearr_75756_75843[(2)] = inst_75674);

(statearr_75756_75843[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (4))){
var state_75738__$1 = state_75738;
var statearr_75757_75844 = state_75738__$1;
(statearr_75757_75844[(2)] = null);

(statearr_75757_75844[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (54))){
var inst_75555 = (state_75738[(21)]);
var inst_75716 = (state_75738[(15)]);
var inst_75715 = (state_75738[(2)]);
var inst_75716__$1 = fluree.db.util.async.throw_err.call(null,inst_75715);
var inst_75717 = fluree.db.api_js.format_history_resp.call(null,inst_75555,inst_75716__$1);
var state_75738__$1 = (function (){var statearr_75758 = state_75738;
(statearr_75758[(15)] = inst_75716__$1);

return statearr_75758;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75738__$1,(55),inst_75717);
} else {
if((state_val_75739 === (15))){
var inst_75555 = (state_75738[(21)]);
var inst_75596 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_75555);
var state_75738__$1 = state_75738;
var statearr_75759_75845 = state_75738__$1;
(statearr_75759_75845[(2)] = inst_75596);

(statearr_75759_75845[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (48))){
var inst_75641 = (state_75738[(10)]);
var inst_75640 = (state_75738[(9)]);
var inst_75642 = (state_75738[(11)]);
var inst_75643 = (state_75738[(12)]);
var inst_75685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75686 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75687 = [inst_75641,inst_75642,inst_75640,inst_75643];
var inst_75688 = (new cljs.core.PersistentVector(null,4,(5),inst_75686,inst_75687,null));
var inst_75689 = [inst_75688,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_75690 = (new cljs.core.PersistentVector(null,2,(5),inst_75685,inst_75689,null));
var state_75738__$1 = state_75738;
var statearr_75760_75846 = state_75738__$1;
(statearr_75760_75846[(2)] = inst_75690);

(statearr_75760_75846[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (50))){
var inst_75703 = (state_75738[(2)]);
var state_75738__$1 = state_75738;
var statearr_75761_75847 = state_75738__$1;
(statearr_75761_75847[(2)] = inst_75703);

(statearr_75761_75847[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (21))){
var inst_75551 = (state_75738[(16)]);
var inst_75607 = cljs.core.empty_QMARK_.call(null,inst_75551);
var state_75738__$1 = state_75738;
if(inst_75607){
var statearr_75762_75848 = state_75738__$1;
(statearr_75762_75848[(1)] = (24));

} else {
var statearr_75763_75849 = state_75738__$1;
(statearr_75763_75849[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (31))){
var inst_75640 = (state_75738[(9)]);
var inst_75651 = (state_75738[(22)]);
var inst_75651__$1 = (inst_75640 == null);
var state_75738__$1 = (function (){var statearr_75764 = state_75738;
(statearr_75764[(22)] = inst_75651__$1);

return statearr_75764;
})();
if(cljs.core.truth_(inst_75651__$1)){
var statearr_75765_75850 = state_75738__$1;
(statearr_75765_75850[(1)] = (33));

} else {
var statearr_75766_75851 = state_75738__$1;
(statearr_75766_75851[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (32))){
var inst_75555 = (state_75738[(21)]);
var inst_75598 = (state_75738[(23)]);
var inst_75588 = (state_75738[(24)]);
var inst_75707 = (state_75738[(2)]);
var inst_75708 = cljs.core.nth.call(null,inst_75707,(0),null);
var inst_75709 = cljs.core.nth.call(null,inst_75707,(1),null);
var inst_75710 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_75711 = [inst_75588,inst_75598];
var inst_75712 = cljs.core.PersistentHashMap.fromArrays(inst_75710,inst_75711);
var inst_75713 = fluree.db.query.range.time_range.call(null,inst_75555,inst_75709,cljs.core._EQ_,inst_75708,inst_75712);
var state_75738__$1 = state_75738;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75738__$1,(54),inst_75713);
} else {
if((state_val_75739 === (40))){
var inst_75640 = (state_75738[(9)]);
var inst_75671 = (state_75738[(25)]);
var inst_75671__$1 = (inst_75640 == null);
var state_75738__$1 = (function (){var statearr_75767 = state_75738;
(statearr_75767[(25)] = inst_75671__$1);

return statearr_75767;
})();
if(cljs.core.truth_(inst_75671__$1)){
var statearr_75768_75852 = state_75738__$1;
(statearr_75768_75852[(1)] = (42));

} else {
var statearr_75769_75853 = state_75738__$1;
(statearr_75769_75853[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (56))){
var inst_75555 = (state_75738[(21)]);
var inst_75720 = (state_75738[(19)]);
var inst_75722 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_75555,inst_75720);
var state_75738__$1 = state_75738;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75738__$1,(59),inst_75722);
} else {
if((state_val_75739 === (33))){
var inst_75641 = (state_75738[(10)]);
var inst_75654 = (state_75738[(26)]);
var inst_75653 = (inst_75641 == null);
var inst_75654__$1 = cljs.core.not.call(null,inst_75653);
var state_75738__$1 = (function (){var statearr_75770 = state_75738;
(statearr_75770[(26)] = inst_75654__$1);

return statearr_75770;
})();
if(inst_75654__$1){
var statearr_75771_75854 = state_75738__$1;
(statearr_75771_75854[(1)] = (36));

} else {
var statearr_75772_75855 = state_75738__$1;
(statearr_75772_75855[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (13))){
var inst_75582 = (state_75738[(2)]);
var inst_75583 = fluree.db.util.async.throw_err.call(null,inst_75582);
var inst_75584 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_75583);
var inst_75585 = (inst_75584 - (1));
var state_75738__$1 = state_75738;
var statearr_75773_75856 = state_75738__$1;
(statearr_75773_75856[(2)] = inst_75585);

(statearr_75773_75856[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (22))){
var state_75738__$1 = state_75738;
var statearr_75774_75857 = state_75738__$1;
(statearr_75774_75857[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (36))){
var inst_75642 = (state_75738[(11)]);
var inst_75656 = (inst_75642 == null);
var state_75738__$1 = state_75738;
var statearr_75776_75858 = state_75738__$1;
(statearr_75776_75858[(2)] = inst_75656);

(statearr_75776_75858[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (41))){
var inst_75705 = (state_75738[(2)]);
var state_75738__$1 = state_75738;
var statearr_75777_75859 = state_75738__$1;
(statearr_75777_75859[(2)] = inst_75705);

(statearr_75777_75859[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (43))){
var inst_75671 = (state_75738[(25)]);
var state_75738__$1 = state_75738;
var statearr_75778_75860 = state_75738__$1;
(statearr_75778_75860[(2)] = inst_75671);

(statearr_75778_75860[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (61))){
var inst_75728 = (state_75738[(14)]);
var state_75738__$1 = state_75738;
var statearr_75779_75861 = state_75738__$1;
(statearr_75779_75861[(2)] = inst_75728);

(statearr_75779_75861[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (29))){
var inst_75628 = (state_75738[(2)]);
var state_75738__$1 = state_75738;
var statearr_75780_75862 = state_75738__$1;
(statearr_75780_75862[(2)] = inst_75628);

(statearr_75780_75862[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (44))){
var inst_75683 = (state_75738[(2)]);
var state_75738__$1 = state_75738;
if(cljs.core.truth_(inst_75683)){
var statearr_75781_75863 = state_75738__$1;
(statearr_75781_75863[(1)] = (48));

} else {
var statearr_75782_75864 = state_75738__$1;
(statearr_75782_75864[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (6))){
var inst_75559 = (state_75738[(2)]);
var inst_75560 = fluree.db.util.async.throw_err.call(null,inst_75559);
var state_75738__$1 = state_75738;
var statearr_75783_75865 = state_75738__$1;
(statearr_75783_75865[(2)] = inst_75560);

(statearr_75783_75865[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (28))){
var state_75738__$1 = state_75738;
var statearr_75784_75866 = state_75738__$1;
(statearr_75784_75866[(2)] = null);

(statearr_75784_75866[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (51))){
var inst_75551 = (state_75738[(16)]);
var inst_75693 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75551)].join('');
var inst_75694 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75695 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75696 = cljs.core.PersistentHashMap.fromArrays(inst_75694,inst_75695);
var inst_75697 = cljs.core.ex_info.call(null,inst_75693,inst_75696);
var inst_75698 = (function(){throw inst_75697})();
var state_75738__$1 = state_75738;
var statearr_75785_75867 = state_75738__$1;
(statearr_75785_75867[(2)] = inst_75698);

(statearr_75785_75867[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (25))){
var inst_75551 = (state_75738[(16)]);
var state_75738__$1 = state_75738;
var statearr_75786_75868 = state_75738__$1;
(statearr_75786_75868[(2)] = inst_75551);

(statearr_75786_75868[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (34))){
var inst_75651 = (state_75738[(22)]);
var state_75738__$1 = state_75738;
var statearr_75787_75869 = state_75738__$1;
(statearr_75787_75869[(2)] = inst_75651);

(statearr_75787_75869[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (17))){
var inst_75592 = (state_75738[(2)]);
var inst_75593 = fluree.db.util.async.throw_err.call(null,inst_75592);
var inst_75594 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_75593);
var state_75738__$1 = state_75738;
var statearr_75788_75870 = state_75738__$1;
(statearr_75788_75870[(2)] = inst_75594);

(statearr_75788_75870[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (3))){
var inst_75555 = (state_75738[(21)]);
var inst_75557 = fluree.db.api_js.resolve_block_range.call(null,inst_75555,query_map);
var state_75738__$1 = state_75738;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75738__$1,(6),inst_75557);
} else {
if((state_val_75739 === (12))){
var inst_75565 = (state_75738[(27)]);
var inst_75588 = (state_75738[(2)]);
var state_75738__$1 = (function (){var statearr_75789 = state_75738;
(statearr_75789[(24)] = inst_75588);

return statearr_75789;
})();
if(cljs.core.truth_(inst_75565)){
var statearr_75790_75871 = state_75738__$1;
(statearr_75790_75871[(1)] = (14));

} else {
var statearr_75791_75872 = state_75738__$1;
(statearr_75791_75872[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (2))){
var inst_75550 = (state_75738[(18)]);
var inst_75554 = (state_75738[(2)]);
var inst_75555 = fluree.db.util.async.throw_err.call(null,inst_75554);
var state_75738__$1 = (function (){var statearr_75792 = state_75738;
(statearr_75792[(21)] = inst_75555);

return statearr_75792;
})();
if(cljs.core.truth_(inst_75550)){
var statearr_75793_75873 = state_75738__$1;
(statearr_75793_75873[(1)] = (3));

} else {
var statearr_75794_75874 = state_75738__$1;
(statearr_75794_75874[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (23))){
var inst_75630 = (state_75738[(2)]);
var state_75738__$1 = state_75738;
var statearr_75795_75875 = state_75738__$1;
(statearr_75795_75875[(2)] = inst_75630);

(statearr_75795_75875[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (47))){
var inst_75680 = (state_75738[(2)]);
var state_75738__$1 = state_75738;
var statearr_75796_75876 = state_75738__$1;
(statearr_75796_75876[(2)] = inst_75680);

(statearr_75796_75876[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (35))){
var inst_75662 = (state_75738[(2)]);
var state_75738__$1 = state_75738;
if(cljs.core.truth_(inst_75662)){
var statearr_75797_75877 = state_75738__$1;
(statearr_75797_75877[(1)] = (39));

} else {
var statearr_75798_75878 = state_75738__$1;
(statearr_75798_75878[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (19))){
var inst_75551 = (state_75738[(16)]);
var inst_75605 = cljs.core.sequential_QMARK_.call(null,inst_75551);
var state_75738__$1 = state_75738;
if(inst_75605){
var statearr_75799_75879 = state_75738__$1;
(statearr_75799_75879[(1)] = (21));

} else {
var statearr_75800_75880 = state_75738__$1;
(statearr_75800_75880[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (57))){
var inst_75720 = (state_75738[(19)]);
var state_75738__$1 = state_75738;
var statearr_75801_75881 = state_75738__$1;
(statearr_75801_75881[(2)] = inst_75720);

(statearr_75801_75881[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (11))){
var state_75738__$1 = state_75738;
var statearr_75802_75882 = state_75738__$1;
(statearr_75802_75882[(2)] = (-1));

(statearr_75802_75882[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (9))){
var inst_75577 = (state_75738[(2)]);
var state_75738__$1 = state_75738;
if(cljs.core.truth_(inst_75577)){
var statearr_75803_75883 = state_75738__$1;
(statearr_75803_75883[(1)] = (10));

} else {
var statearr_75804_75884 = state_75738__$1;
(statearr_75804_75884[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (5))){
var inst_75564 = (state_75738[(7)]);
var inst_75563 = (state_75738[(2)]);
var inst_75564__$1 = cljs.core.nth.call(null,inst_75563,(0),null);
var inst_75565 = cljs.core.nth.call(null,inst_75563,(1),null);
var inst_75572 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_75738__$1 = (function (){var statearr_75805 = state_75738;
(statearr_75805[(7)] = inst_75564__$1);

(statearr_75805[(13)] = inst_75572);

(statearr_75805[(27)] = inst_75565);

return statearr_75805;
})();
if(cljs.core.truth_(inst_75564__$1)){
var statearr_75806_75885 = state_75738__$1;
(statearr_75806_75885[(1)] = (7));

} else {
var statearr_75807_75886 = state_75738__$1;
(statearr_75807_75886[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (14))){
var inst_75555 = (state_75738[(21)]);
var inst_75565 = (state_75738[(27)]);
var inst_75590 = fluree.db.time_travel.as_of_block.call(null,inst_75555,inst_75565);
var state_75738__$1 = state_75738;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75738__$1,(17),inst_75590);
} else {
if((state_val_75739 === (45))){
var inst_75642 = (state_75738[(11)]);
var inst_75676 = (inst_75642 == null);
var inst_75677 = cljs.core.not.call(null,inst_75676);
var state_75738__$1 = state_75738;
var statearr_75808_75887 = state_75738__$1;
(statearr_75808_75887[(2)] = inst_75677);

(statearr_75808_75887[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (53))){
var inst_75701 = (state_75738[(2)]);
var state_75738__$1 = state_75738;
var statearr_75809_75888 = state_75738__$1;
(statearr_75809_75888[(2)] = inst_75701);

(statearr_75809_75888[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (26))){
var inst_75617 = (state_75738[(2)]);
var state_75738__$1 = state_75738;
var statearr_75810_75889 = state_75738__$1;
(statearr_75810_75889[(2)] = inst_75617);

(statearr_75810_75889[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (16))){
var inst_75551 = (state_75738[(16)]);
var inst_75598 = (state_75738[(2)]);
var inst_75599 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_75551);
var state_75738__$1 = (function (){var statearr_75811 = state_75738;
(statearr_75811[(23)] = inst_75598);

return statearr_75811;
})();
if(inst_75599){
var statearr_75812_75890 = state_75738__$1;
(statearr_75812_75890[(1)] = (18));

} else {
var statearr_75813_75891 = state_75738__$1;
(statearr_75813_75891[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (38))){
var inst_75659 = (state_75738[(2)]);
var state_75738__$1 = state_75738;
var statearr_75814_75892 = state_75738__$1;
(statearr_75814_75892[(2)] = inst_75659);

(statearr_75814_75892[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (30))){
var inst_75632 = (state_75738[(8)]);
var inst_75647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75648 = [inst_75632,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_75649 = (new cljs.core.PersistentVector(null,2,(5),inst_75647,inst_75648,null));
var state_75738__$1 = state_75738;
var statearr_75815_75893 = state_75738__$1;
(statearr_75815_75893[(2)] = inst_75649);

(statearr_75815_75893[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (10))){
var inst_75564 = (state_75738[(7)]);
var inst_75555 = (state_75738[(21)]);
var inst_75579 = (inst_75564 - (1));
var inst_75580 = fluree.db.time_travel.as_of_block.call(null,inst_75555,inst_75579);
var state_75738__$1 = state_75738;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75738__$1,(13),inst_75580);
} else {
if((state_val_75739 === (18))){
var inst_75551 = (state_75738[(16)]);
var inst_75601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75602 = [inst_75551];
var inst_75603 = (new cljs.core.PersistentVector(null,1,(5),inst_75601,inst_75602,null));
var state_75738__$1 = state_75738;
var statearr_75816_75894 = state_75738__$1;
(statearr_75816_75894[(2)] = inst_75603);

(statearr_75816_75894[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (52))){
var state_75738__$1 = state_75738;
var statearr_75817_75895 = state_75738__$1;
(statearr_75817_75895[(2)] = null);

(statearr_75817_75895[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (42))){
var inst_75674 = (state_75738[(20)]);
var inst_75641 = (state_75738[(10)]);
var inst_75673 = (inst_75641 == null);
var inst_75674__$1 = cljs.core.not.call(null,inst_75673);
var state_75738__$1 = (function (){var statearr_75818 = state_75738;
(statearr_75818[(20)] = inst_75674__$1);

return statearr_75818;
})();
if(inst_75674__$1){
var statearr_75819_75896 = state_75738__$1;
(statearr_75819_75896[(1)] = (45));

} else {
var statearr_75820_75897 = state_75738__$1;
(statearr_75820_75897[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (37))){
var inst_75654 = (state_75738[(26)]);
var state_75738__$1 = state_75738;
var statearr_75821_75898 = state_75738__$1;
(statearr_75821_75898[(2)] = inst_75654);

(statearr_75821_75898[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (8))){
var inst_75564 = (state_75738[(7)]);
var state_75738__$1 = state_75738;
var statearr_75822_75899 = state_75738__$1;
(statearr_75822_75899[(2)] = inst_75564);

(statearr_75822_75899[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75739 === (49))){
var state_75738__$1 = state_75738;
var statearr_75823_75900 = state_75738__$1;
(statearr_75823_75900[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__10945__auto__ = null;
var fluree$db$api_js$state_machine__10945__auto____0 = (function (){
var statearr_75825 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75825[(0)] = fluree$db$api_js$state_machine__10945__auto__);

(statearr_75825[(1)] = (1));

return statearr_75825;
});
var fluree$db$api_js$state_machine__10945__auto____1 = (function (state_75738){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_75738);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e75826){var ex__10948__auto__ = e75826;
var statearr_75827_75901 = state_75738;
(statearr_75827_75901[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_75738[(4)]))){
var statearr_75828_75902 = state_75738;
(statearr_75828_75902[(1)] = cljs.core.first.call(null,(state_75738[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75903 = state_75738;
state_75738 = G__75903;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__10945__auto__ = function(state_75738){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__10945__auto____1.call(this,state_75738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__10945__auto____0;
fluree$db$api_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__10945__auto____1;
return fluree$db$api_js$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_75829 = f__11019__auto__.call(null);
(statearr_75829[(6)] = c__11018__auto__);

return statearr_75829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__75911 = arguments.length;
switch (G__75911) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__75904_SHARP_){
return cljs.core.dissoc.call(null,p1__75904_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_76000){
var state_val_76001 = (state_76000[(1)]);
if((state_val_76001 === (7))){
var inst_75961 = (state_76000[(7)]);
var inst_75951 = (state_76000[(8)]);
var inst_75957 = (state_76000[(9)]);
var inst_75954 = (state_76000[(10)]);
var inst_75967 = (function (){var responses = inst_75951;
var responses_STAR_ = inst_75954;
var statuses = inst_75957;
var fuel = inst_75961;
return (function (p1__75907_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__75907_SHARP_);
});
})();
var inst_75968 = cljs.core.some.call(null,inst_75967,inst_75957);
var state_76000__$1 = state_76000;
if(cljs.core.truth_(inst_75968)){
var statearr_76002_76050 = state_76000__$1;
(statearr_76002_76050[(1)] = (9));

} else {
var statearr_76003_76051 = state_76000__$1;
(statearr_76003_76051[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76001 === (20))){
var inst_75995 = (state_76000[(2)]);
var state_76000__$1 = state_76000;
var statearr_76004_76052 = state_76000__$1;
(statearr_76004_76052[(2)] = inst_75995);

(statearr_76004_76052[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76001 === (1))){
var inst_75946 = cljs.core.async.chan.call(null,(1));
var inst_75947 = (function (){var c__11018__auto____$1 = inst_75946;
return (function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_75944){
var state_val_75945 = (state_75944[(1)]);
if((state_val_75945 === (1))){
var inst_75912 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_75913 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_75914 = cljs.core.assoc.call(null,inst_75913,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_75915 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_75916 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_75917 = cljs.core.PersistentHashMap.EMPTY;
var inst_75918 = inst_75912;
var inst_75919 = inst_75914;
var inst_75920 = inst_75915;
var inst_75921 = inst_75916;
var inst_75922 = inst_75917;
var state_75944__$1 = (function (){var statearr_76005 = state_75944;
(statearr_76005[(7)] = inst_75919);

(statearr_76005[(8)] = inst_75918);

(statearr_76005[(9)] = inst_75920);

(statearr_76005[(10)] = inst_75921);

(statearr_76005[(11)] = inst_75922);

return statearr_76005;
})();
var statearr_76006_76053 = state_75944__$1;
(statearr_76006_76053[(2)] = null);

(statearr_76006_76053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75945 === (2))){
var inst_75919 = (state_75944[(7)]);
var inst_75924 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_75919);
var inst_75925 = cljs.core.merge.call(null,opts,inst_75924);
var inst_75926 = cljs.core.assoc.call(null,inst_75919,new cljs.core.Keyword(null,"opts","opts",155075701),inst_75925);
var inst_75927 = fluree.db.api_js.query_async.call(null,db,inst_75926,db_fn);
var state_75944__$1 = state_75944;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75944__$1,(4),inst_75927);
} else {
if((state_val_75945 === (3))){
var inst_75942 = (state_75944[(2)]);
var state_75944__$1 = state_75944;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75944__$1,inst_75942);
} else {
if((state_val_75945 === (4))){
var inst_75918 = (state_75944[(8)]);
var inst_75920 = (state_75944[(9)]);
var inst_75922 = (state_75944[(11)]);
var inst_75929 = (state_75944[(2)]);
var inst_75930 = cljs.core.assoc.call(null,inst_75922,inst_75918,inst_75929);
var inst_75931 = cljs.core.first.call(null,inst_75920);
var state_75944__$1 = (function (){var statearr_76007 = state_75944;
(statearr_76007[(12)] = inst_75930);

return statearr_76007;
})();
if(cljs.core.truth_(inst_75931)){
var statearr_76008_76054 = state_75944__$1;
(statearr_76008_76054[(1)] = (5));

} else {
var statearr_76009_76055 = state_75944__$1;
(statearr_76009_76055[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75945 === (5))){
var inst_75920 = (state_75944[(9)]);
var inst_75921 = (state_75944[(10)]);
var inst_75930 = (state_75944[(12)]);
var inst_75933 = cljs.core.first.call(null,inst_75920);
var inst_75934 = cljs.core.first.call(null,inst_75921);
var inst_75935 = cljs.core.rest.call(null,inst_75920);
var inst_75936 = cljs.core.rest.call(null,inst_75921);
var inst_75918 = inst_75933;
var inst_75919 = inst_75934;
var inst_75920__$1 = inst_75935;
var inst_75921__$1 = inst_75936;
var inst_75922 = inst_75930;
var state_75944__$1 = (function (){var statearr_76010 = state_75944;
(statearr_76010[(7)] = inst_75919);

(statearr_76010[(8)] = inst_75918);

(statearr_76010[(9)] = inst_75920__$1);

(statearr_76010[(10)] = inst_75921__$1);

(statearr_76010[(11)] = inst_75922);

return statearr_76010;
})();
var statearr_76011_76056 = state_75944__$1;
(statearr_76011_76056[(2)] = null);

(statearr_76011_76056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75945 === (6))){
var inst_75930 = (state_75944[(12)]);
var state_75944__$1 = state_75944;
var statearr_76012_76057 = state_75944__$1;
(statearr_76012_76057[(2)] = inst_75930);

(statearr_76012_76057[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75945 === (7))){
var inst_75940 = (state_75944[(2)]);
var state_75944__$1 = state_75944;
var statearr_76013_76058 = state_75944__$1;
(statearr_76013_76058[(2)] = inst_75940);

(statearr_76013_76058[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__10945__auto__ = null;
var fluree$db$api_js$state_machine__10945__auto____0 = (function (){
var statearr_76014 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76014[(0)] = fluree$db$api_js$state_machine__10945__auto__);

(statearr_76014[(1)] = (1));

return statearr_76014;
});
var fluree$db$api_js$state_machine__10945__auto____1 = (function (state_75944){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_75944);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e76015){var ex__10948__auto__ = e76015;
var statearr_76016_76059 = state_75944;
(statearr_76016_76059[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_75944[(4)]))){
var statearr_76017_76060 = state_75944;
(statearr_76017_76060[(1)] = cljs.core.first.call(null,(state_75944[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76061 = state_75944;
state_75944 = G__76061;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__10945__auto__ = function(state_75944){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__10945__auto____1.call(this,state_75944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__10945__auto____0;
fluree$db$api_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__10945__auto____1;
return fluree$db$api_js$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_76018 = f__11019__auto__.call(null);
(statearr_76018[(6)] = c__11018__auto____$1);

return statearr_76018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
});
})();
var inst_75948 = cljs.core.async.impl.dispatch.run.call(null,inst_75947);
var state_76000__$1 = (function (){var statearr_76019 = state_76000;
(statearr_76019[(11)] = inst_75948);

return statearr_76019;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76000__$1,(2),inst_75946);
} else {
if((state_val_76001 === (4))){
var inst_75951 = (state_76000[(8)]);
var state_76000__$1 = state_76000;
var statearr_76020_76062 = state_76000__$1;
(statearr_76020_76062[(2)] = inst_75951);

(statearr_76020_76062[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76001 === (15))){
var state_76000__$1 = state_76000;
var statearr_76021_76063 = state_76000__$1;
(statearr_76021_76063[(2)] = (400));

(statearr_76021_76063[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76001 === (13))){
var state_76000__$1 = state_76000;
var statearr_76022_76064 = state_76000__$1;
(statearr_76022_76064[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76001 === (6))){
var inst_75957 = (state_76000[(9)]);
var inst_75965 = cljs.core.first.call(null,inst_75957);
var state_76000__$1 = state_76000;
var statearr_76024_76065 = state_76000__$1;
(statearr_76024_76065[(2)] = inst_75965);

(statearr_76024_76065[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76001 === (17))){
var inst_75978 = (state_76000[(2)]);
var state_76000__$1 = state_76000;
var statearr_76025_76066 = state_76000__$1;
(statearr_76025_76066[(2)] = inst_75978);

(statearr_76025_76066[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76001 === (3))){
var inst_75961 = (state_76000[(7)]);
var inst_75951 = (state_76000[(8)]);
var inst_75957 = (state_76000[(9)]);
var inst_75954 = (state_76000[(10)]);
var inst_75956 = cljs.core.vals.call(null,inst_75951);
var inst_75957__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_75956);
var inst_75958 = (function (){var responses = inst_75951;
var responses_STAR_ = inst_75954;
var statuses = inst_75957__$1;
return (function (p1__75905_SHARP_){
var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__75905_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
});
})();
var inst_75959 = cljs.core.vals.call(null,inst_75951);
var inst_75960 = cljs.core.map.call(null,inst_75958,inst_75959);
var inst_75961__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_75960);
var inst_75962 = (function (){var responses = inst_75951;
var responses_STAR_ = inst_75954;
var statuses = inst_75957__$1;
var fuel = inst_75961__$1;
return (function (p1__75906_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__75906_SHARP_);
});
})();
var inst_75963 = cljs.core.every_QMARK_.call(null,inst_75962,inst_75957__$1);
var state_76000__$1 = (function (){var statearr_76026 = state_76000;
(statearr_76026[(7)] = inst_75961__$1);

(statearr_76026[(9)] = inst_75957__$1);

return statearr_76026;
})();
if(inst_75963){
var statearr_76027_76067 = state_76000__$1;
(statearr_76027_76067[(1)] = (6));

} else {
var statearr_76028_76068 = state_76000__$1;
(statearr_76028_76068[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76001 === (12))){
var state_76000__$1 = state_76000;
var statearr_76029_76069 = state_76000__$1;
(statearr_76029_76069[(2)] = (500));

(statearr_76029_76069[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76001 === (2))){
var inst_75951 = (state_76000[(8)]);
var inst_75950 = (state_76000[(2)]);
var inst_75951__$1 = fluree.db.util.async.throw_err.call(null,inst_75950);
var inst_75952 = (function (){var responses = inst_75951__$1;
return (function (acc,index,response){
var resp = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_75953 = cljs.core.PersistentHashMap.EMPTY;
var inst_75954 = cljs.core.reduce_kv.call(null,inst_75952,inst_75953,inst_75951__$1);
var state_76000__$1 = (function (){var statearr_76030 = state_76000;
(statearr_76030[(8)] = inst_75951__$1);

(statearr_76030[(10)] = inst_75954);

return statearr_76030;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_76031_76070 = state_76000__$1;
(statearr_76031_76070[(1)] = (3));

} else {
var statearr_76032_76071 = state_76000__$1;
(statearr_76032_76071[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76001 === (19))){
var inst_75961 = (state_76000[(7)]);
var inst_75984 = (state_76000[(12)]);
var inst_75954 = (state_76000[(10)]);
var inst_75993 = cljs.core.assoc.call(null,inst_75954,new cljs.core.Keyword(null,"status","status",-1997798413),inst_75984,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_75961);
var state_76000__$1 = state_76000;
var statearr_76033_76072 = state_76000__$1;
(statearr_76033_76072[(2)] = inst_75993);

(statearr_76033_76072[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76001 === (11))){
var inst_75982 = (state_76000[(2)]);
var state_76000__$1 = state_76000;
var statearr_76034_76073 = state_76000__$1;
(statearr_76034_76073[(2)] = inst_75982);

(statearr_76034_76073[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76001 === (9))){
var state_76000__$1 = state_76000;
var statearr_76035_76074 = state_76000__$1;
(statearr_76035_76074[(2)] = (207));

(statearr_76035_76074[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76001 === (5))){
var inst_75998 = (state_76000[(2)]);
var state_76000__$1 = state_76000;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76000__$1,inst_75998);
} else {
if((state_val_76001 === (14))){
var inst_75980 = (state_76000[(2)]);
var state_76000__$1 = state_76000;
var statearr_76036_76075 = state_76000__$1;
(statearr_76036_76075[(2)] = inst_75980);

(statearr_76036_76075[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76001 === (16))){
var state_76000__$1 = state_76000;
var statearr_76037_76076 = state_76000__$1;
(statearr_76037_76076[(2)] = null);

(statearr_76037_76076[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76001 === (10))){
var inst_75961 = (state_76000[(7)]);
var inst_75951 = (state_76000[(8)]);
var inst_75957 = (state_76000[(9)]);
var inst_75954 = (state_76000[(10)]);
var inst_75971 = (function (){var responses = inst_75951;
var responses_STAR_ = inst_75954;
var statuses = inst_75957;
var fuel = inst_75961;
return (function (p1__75908_SHARP_){
return ((499) < p1__75908_SHARP_);
});
})();
var inst_75972 = cljs.core.some.call(null,inst_75971,inst_75957);
var state_76000__$1 = state_76000;
if(cljs.core.truth_(inst_75972)){
var statearr_76038_76077 = state_76000__$1;
(statearr_76038_76077[(1)] = (12));

} else {
var statearr_76039_76078 = state_76000__$1;
(statearr_76039_76078[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76001 === (18))){
var inst_75961 = (state_76000[(7)]);
var inst_75984 = (state_76000[(12)]);
var inst_75989 = (state_76000[(13)]);
var inst_75954 = (state_76000[(10)]);
var inst_75991 = cljs.core.assoc.call(null,inst_75954,new cljs.core.Keyword(null,"status","status",-1997798413),inst_75984,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_75961,new cljs.core.Keyword(null,"block","block",664686210),inst_75989);
var state_76000__$1 = state_76000;
var statearr_76040_76079 = state_76000__$1;
(statearr_76040_76079[(2)] = inst_75991);

(statearr_76040_76079[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76001 === (8))){
var inst_75961 = (state_76000[(7)]);
var inst_75984 = (state_76000[(12)]);
var inst_75989 = (state_76000[(13)]);
var inst_75951 = (state_76000[(8)]);
var inst_75957 = (state_76000[(9)]);
var inst_75954 = (state_76000[(10)]);
var inst_75984__$1 = (state_76000[(2)]);
var inst_75985 = (function (){var responses = inst_75951;
var responses_STAR_ = inst_75954;
var statuses = inst_75957;
var fuel = inst_75961;
var status = inst_75984__$1;
return (function (p1__75909_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__75909_SHARP_));
});
})();
var inst_75986 = cljs.core.vals.call(null,inst_75951);
var inst_75987 = cljs.core.filter.call(null,inst_75985,inst_75986);
var inst_75988 = cljs.core.first.call(null,inst_75987);
var inst_75989__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_75988);
var state_76000__$1 = (function (){var statearr_76041 = state_76000;
(statearr_76041[(12)] = inst_75984__$1);

(statearr_76041[(13)] = inst_75989__$1);

return statearr_76041;
})();
if(cljs.core.truth_(inst_75989__$1)){
var statearr_76042_76080 = state_76000__$1;
(statearr_76042_76080[(1)] = (18));

} else {
var statearr_76043_76081 = state_76000__$1;
(statearr_76043_76081[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__10945__auto__ = null;
var fluree$db$api_js$state_machine__10945__auto____0 = (function (){
var statearr_76044 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76044[(0)] = fluree$db$api_js$state_machine__10945__auto__);

(statearr_76044[(1)] = (1));

return statearr_76044;
});
var fluree$db$api_js$state_machine__10945__auto____1 = (function (state_76000){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_76000);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e76045){var ex__10948__auto__ = e76045;
var statearr_76046_76082 = state_76000;
(statearr_76046_76082[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_76000[(4)]))){
var statearr_76047_76083 = state_76000;
(statearr_76047_76083[(1)] = cljs.core.first.call(null,(state_76000[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76084 = state_76000;
state_76000 = G__76084;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__10945__auto__ = function(state_76000){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__10945__auto____1.call(this,state_76000);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__10945__auto____0;
fluree$db$api_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__10945__auto____1;
return fluree$db$api_js$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_76048 = f__11019__auto__.call(null);
(statearr_76048[(6)] = c__11018__auto__);

return statearr_76048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__76086 = arguments.length;
switch (G__76086) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__76087 = opts;
var map__76087__$1 = cljs.core.__destructure_map.call(null,map__76087);
var auth = cljs.core.get.call(null,map__76087__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__76087__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__76087__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__76087__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__76088 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__76088,(0),null);
var authority = cljs.core.nth.call(null,vec__76088,(1),null);
var action__$1 = (function (){var or__5045__auto__ = action;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e76091){var e = e76091;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__76094 = arguments.length;
switch (G__76094) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_76125){
var state_val_76126 = (state_76125[(1)]);
if((state_val_76126 === (7))){
var state_76125__$1 = state_76125;
var statearr_76127_76148 = state_76125__$1;
(statearr_76127_76148[(2)] = opts);

(statearr_76127_76148[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76126 === (1))){
var state_76125__$1 = state_76125;
var statearr_76128_76149 = state_76125__$1;
(statearr_76128_76149[(2)] = null);

(statearr_76128_76149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76126 === (4))){
var inst_76095 = (state_76125[(2)]);
var inst_76096 = fluree.db.util.log.error.call(null,inst_76095);
var inst_76097 = cljs.core.ex_data.call(null,inst_76095);
var inst_76098 = cljs.core.ex_message.call(null,inst_76095);
var inst_76099 = cljs.core.assoc.call(null,inst_76097,new cljs.core.Keyword(null,"message","message",-406056002),inst_76098);
var state_76125__$1 = (function (){var statearr_76129 = state_76125;
(statearr_76129[(7)] = inst_76096);

return statearr_76129;
})();
var statearr_76130_76150 = state_76125__$1;
(statearr_76130_76150[(2)] = inst_76099);

(statearr_76130_76150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76126 === (6))){
var inst_76109 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76110 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_76111 = (new cljs.core.PersistentVector(null,1,(5),inst_76109,inst_76110,null));
var inst_76112 = cljs.core.assoc_in.call(null,opts,inst_76111,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_76125__$1 = state_76125;
var statearr_76131_76151 = state_76125__$1;
(statearr_76131_76151[(2)] = inst_76112);

(statearr_76131_76151[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76126 === (3))){
var inst_76123 = (state_76125[(2)]);
var state_76125__$1 = state_76125;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76125__$1,inst_76123);
} else {
if((state_val_76126 === (2))){
var _ = (function (){var statearr_76133 = state_76125;
(statearr_76133[(4)] = cljs.core.cons.call(null,(5),(state_76125[(4)])));

return statearr_76133;
})();
var inst_76105 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_76106 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_76107 = (inst_76106 == null);
var state_76125__$1 = (function (){var statearr_76134 = state_76125;
(statearr_76134[(8)] = inst_76105);

return statearr_76134;
})();
if(cljs.core.truth_(inst_76107)){
var statearr_76135_76152 = state_76125__$1;
(statearr_76135_76152[(1)] = (6));

} else {
var statearr_76136_76153 = state_76125__$1;
(statearr_76136_76153[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76126 === (9))){
var inst_76119 = (state_76125[(2)]);
var inst_76120 = fluree.db.util.async.throw_err.call(null,inst_76119);
var _ = (function (){var statearr_76137 = state_76125;
(statearr_76137[(4)] = cljs.core.rest.call(null,(state_76125[(4)])));

return statearr_76137;
})();
var state_76125__$1 = state_76125;
var statearr_76138_76154 = state_76125__$1;
(statearr_76138_76154[(2)] = inst_76120);

(statearr_76138_76154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76126 === (5))){
var _ = (function (){var statearr_76139 = state_76125;
(statearr_76139[(4)] = cljs.core.rest.call(null,(state_76125[(4)])));

return statearr_76139;
})();
var state_76125__$1 = state_76125;
var ex76132 = (state_76125__$1[(2)]);
var statearr_76140_76155 = state_76125__$1;
(statearr_76140_76155[(5)] = ex76132);


var statearr_76141_76156 = state_76125__$1;
(statearr_76141_76156[(1)] = (4));

(statearr_76141_76156[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76126 === (8))){
var inst_76105 = (state_76125[(8)]);
var inst_76115 = (state_76125[(2)]);
var inst_76116 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_76105,inst_76115);
var inst_76117 = fluree.db.operations.command_async.call(null,conn,inst_76116);
var state_76125__$1 = state_76125;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76125__$1,(9),inst_76117);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__10945__auto__ = null;
var fluree$db$api_js$state_machine__10945__auto____0 = (function (){
var statearr_76142 = [null,null,null,null,null,null,null,null,null];
(statearr_76142[(0)] = fluree$db$api_js$state_machine__10945__auto__);

(statearr_76142[(1)] = (1));

return statearr_76142;
});
var fluree$db$api_js$state_machine__10945__auto____1 = (function (state_76125){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_76125);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e76143){var ex__10948__auto__ = e76143;
var statearr_76144_76157 = state_76125;
(statearr_76144_76157[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_76125[(4)]))){
var statearr_76145_76158 = state_76125;
(statearr_76145_76158[(1)] = cljs.core.first.call(null,(state_76125[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76159 = state_76125;
state_76125 = G__76159;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__10945__auto__ = function(state_76125){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__10945__auto____1.call(this,state_76125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__10945__auto____0;
fluree$db$api_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__10945__auto____1;
return fluree$db$api_js$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_76146 = f__11019__auto__.call(null);
(statearr_76146[(6)] = c__11018__auto__);

return statearr_76146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

