// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__72666_72835 = cljs.core.seq.call(null,servers);
var chunk__72667_72836 = null;
var count__72668_72837 = (0);
var i__72669_72838 = (0);
while(true){
if((i__72669_72838 < count__72668_72837)){
var server_72839 = cljs.core._nth.call(null,chunk__72667_72836,i__72669_72838);
var healthcheck_uri_72840 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_72839),"/fdb/health"].join('');
var resp_chan_72841 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_72840,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__11018__auto___72842 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__72666_72835,chunk__72667_72836,count__72668_72837,i__72669_72838,c__11018__auto___72842,healthcheck_uri_72840,resp_chan_72841,server_72839){
return (function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = ((function (seq__72666_72835,chunk__72667_72836,count__72668_72837,i__72669_72838,c__11018__auto___72842,healthcheck_uri_72840,resp_chan_72841,server_72839){
return (function (state_72730){
var state_val_72731 = (state_72730[(1)]);
if((state_val_72731 === (1))){
var state_72730__$1 = state_72730;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72730__$1,(2),resp_chan_72841);
} else {
if((state_val_72731 === (2))){
var inst_72719 = (state_72730[(7)]);
var inst_72719__$1 = (state_72730[(2)]);
var inst_72720 = fluree.db.util.core.exception_QMARK_.call(null,inst_72719__$1);
var state_72730__$1 = (function (){var statearr_72732 = state_72730;
(statearr_72732[(7)] = inst_72719__$1);

return statearr_72732;
})();
if(inst_72720){
var statearr_72733_72843 = state_72730__$1;
(statearr_72733_72843[(1)] = (3));

} else {
var statearr_72734_72844 = state_72730__$1;
(statearr_72734_72844[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72731 === (3))){
var inst_72719 = (state_72730[(7)]);
var inst_72722 = cljs.core.ex_message.call(null,inst_72719);
var inst_72723 = cljs.core.ex_data.call(null,inst_72719);
var inst_72724 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_72722,inst_72723);
var state_72730__$1 = state_72730;
var statearr_72735_72845 = state_72730__$1;
(statearr_72735_72845[(2)] = inst_72724);

(statearr_72735_72845[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72731 === (4))){
var inst_72726 = cljs.core.async.put_BANG_.call(null,promise_chan,server_72839);
var state_72730__$1 = state_72730;
var statearr_72736_72846 = state_72730__$1;
(statearr_72736_72846[(2)] = inst_72726);

(statearr_72736_72846[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72731 === (5))){
var inst_72728 = (state_72730[(2)]);
var state_72730__$1 = state_72730;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72730__$1,inst_72728);
} else {
return null;
}
}
}
}
}
});})(seq__72666_72835,chunk__72667_72836,count__72668_72837,i__72669_72838,c__11018__auto___72842,healthcheck_uri_72840,resp_chan_72841,server_72839))
;
return ((function (seq__72666_72835,chunk__72667_72836,count__72668_72837,i__72669_72838,switch__10944__auto__,c__11018__auto___72842,healthcheck_uri_72840,resp_chan_72841,server_72839){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____0 = (function (){
var statearr_72737 = [null,null,null,null,null,null,null,null];
(statearr_72737[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__);

(statearr_72737[(1)] = (1));

return statearr_72737;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____1 = (function (state_72730){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_72730);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e72738){var ex__10948__auto__ = e72738;
var statearr_72739_72847 = state_72730;
(statearr_72739_72847[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_72730[(4)]))){
var statearr_72740_72848 = state_72730;
(statearr_72740_72848[(1)] = cljs.core.first.call(null,(state_72730[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72849 = state_72730;
state_72730 = G__72849;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__ = function(state_72730){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____1.call(this,state_72730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__;
})()
;})(seq__72666_72835,chunk__72667_72836,count__72668_72837,i__72669_72838,switch__10944__auto__,c__11018__auto___72842,healthcheck_uri_72840,resp_chan_72841,server_72839))
})();
var state__11020__auto__ = (function (){var statearr_72741 = f__11019__auto__.call(null);
(statearr_72741[(6)] = c__11018__auto___72842);

return statearr_72741;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
});})(seq__72666_72835,chunk__72667_72836,count__72668_72837,i__72669_72838,c__11018__auto___72842,healthcheck_uri_72840,resp_chan_72841,server_72839))
);



var G__72850 = seq__72666_72835;
var G__72851 = chunk__72667_72836;
var G__72852 = count__72668_72837;
var G__72853 = (i__72669_72838 + (1));
seq__72666_72835 = G__72850;
chunk__72667_72836 = G__72851;
count__72668_72837 = G__72852;
i__72669_72838 = G__72853;
continue;
} else {
var temp__5804__auto___72854 = cljs.core.seq.call(null,seq__72666_72835);
if(temp__5804__auto___72854){
var seq__72666_72855__$1 = temp__5804__auto___72854;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__72666_72855__$1)){
var c__5567__auto___72856 = cljs.core.chunk_first.call(null,seq__72666_72855__$1);
var G__72857 = cljs.core.chunk_rest.call(null,seq__72666_72855__$1);
var G__72858 = c__5567__auto___72856;
var G__72859 = cljs.core.count.call(null,c__5567__auto___72856);
var G__72860 = (0);
seq__72666_72835 = G__72857;
chunk__72667_72836 = G__72858;
count__72668_72837 = G__72859;
i__72669_72838 = G__72860;
continue;
} else {
var server_72861 = cljs.core.first.call(null,seq__72666_72855__$1);
var healthcheck_uri_72862 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_72861),"/fdb/health"].join('');
var resp_chan_72863 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_72862,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__11018__auto___72864 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__72666_72835,chunk__72667_72836,count__72668_72837,i__72669_72838,c__11018__auto___72864,healthcheck_uri_72862,resp_chan_72863,server_72861,seq__72666_72855__$1,temp__5804__auto___72854){
return (function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = ((function (seq__72666_72835,chunk__72667_72836,count__72668_72837,i__72669_72838,c__11018__auto___72864,healthcheck_uri_72862,resp_chan_72863,server_72861,seq__72666_72855__$1,temp__5804__auto___72854){
return (function (state_72754){
var state_val_72755 = (state_72754[(1)]);
if((state_val_72755 === (1))){
var state_72754__$1 = state_72754;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72754__$1,(2),resp_chan_72863);
} else {
if((state_val_72755 === (2))){
var inst_72743 = (state_72754[(7)]);
var inst_72743__$1 = (state_72754[(2)]);
var inst_72744 = fluree.db.util.core.exception_QMARK_.call(null,inst_72743__$1);
var state_72754__$1 = (function (){var statearr_72756 = state_72754;
(statearr_72756[(7)] = inst_72743__$1);

return statearr_72756;
})();
if(inst_72744){
var statearr_72757_72865 = state_72754__$1;
(statearr_72757_72865[(1)] = (3));

} else {
var statearr_72758_72866 = state_72754__$1;
(statearr_72758_72866[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72755 === (3))){
var inst_72743 = (state_72754[(7)]);
var inst_72746 = cljs.core.ex_message.call(null,inst_72743);
var inst_72747 = cljs.core.ex_data.call(null,inst_72743);
var inst_72748 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_72746,inst_72747);
var state_72754__$1 = state_72754;
var statearr_72759_72867 = state_72754__$1;
(statearr_72759_72867[(2)] = inst_72748);

(statearr_72759_72867[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72755 === (4))){
var inst_72750 = cljs.core.async.put_BANG_.call(null,promise_chan,server_72861);
var state_72754__$1 = state_72754;
var statearr_72760_72868 = state_72754__$1;
(statearr_72760_72868[(2)] = inst_72750);

(statearr_72760_72868[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72755 === (5))){
var inst_72752 = (state_72754[(2)]);
var state_72754__$1 = state_72754;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72754__$1,inst_72752);
} else {
return null;
}
}
}
}
}
});})(seq__72666_72835,chunk__72667_72836,count__72668_72837,i__72669_72838,c__11018__auto___72864,healthcheck_uri_72862,resp_chan_72863,server_72861,seq__72666_72855__$1,temp__5804__auto___72854))
;
return ((function (seq__72666_72835,chunk__72667_72836,count__72668_72837,i__72669_72838,switch__10944__auto__,c__11018__auto___72864,healthcheck_uri_72862,resp_chan_72863,server_72861,seq__72666_72855__$1,temp__5804__auto___72854){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____0 = (function (){
var statearr_72761 = [null,null,null,null,null,null,null,null];
(statearr_72761[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__);

(statearr_72761[(1)] = (1));

return statearr_72761;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____1 = (function (state_72754){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_72754);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e72762){var ex__10948__auto__ = e72762;
var statearr_72763_72869 = state_72754;
(statearr_72763_72869[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_72754[(4)]))){
var statearr_72764_72870 = state_72754;
(statearr_72764_72870[(1)] = cljs.core.first.call(null,(state_72754[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72871 = state_72754;
state_72754 = G__72871;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__ = function(state_72754){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____1.call(this,state_72754);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__;
})()
;})(seq__72666_72835,chunk__72667_72836,count__72668_72837,i__72669_72838,switch__10944__auto__,c__11018__auto___72864,healthcheck_uri_72862,resp_chan_72863,server_72861,seq__72666_72855__$1,temp__5804__auto___72854))
})();
var state__11020__auto__ = (function (){var statearr_72765 = f__11019__auto__.call(null);
(statearr_72765[(6)] = c__11018__auto___72864);

return statearr_72765;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
});})(seq__72666_72835,chunk__72667_72836,count__72668_72837,i__72669_72838,c__11018__auto___72864,healthcheck_uri_72862,resp_chan_72863,server_72861,seq__72666_72855__$1,temp__5804__auto___72854))
);



var G__72872 = cljs.core.next.call(null,seq__72666_72855__$1);
var G__72873 = null;
var G__72874 = (0);
var G__72875 = (0);
seq__72666_72835 = G__72872;
chunk__72667_72836 = G__72873;
count__72668_72837 = G__72874;
i__72669_72838 = G__72875;
continue;
}
} else {
}
}
break;
}

var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_72809){
var state_val_72810 = (state_72809[(1)]);
if((state_val_72810 === (7))){
var inst_72781 = (state_72809[(7)]);
var inst_72788 = cljs.core._EQ_.call(null,inst_72781,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_72809__$1 = state_72809;
if(inst_72788){
var statearr_72811_72876 = state_72809__$1;
(statearr_72811_72876[(1)] = (9));

} else {
var statearr_72812_72877 = state_72809__$1;
(statearr_72812_72877[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72810 === (1))){
var inst_72774 = (state_72809[(8)]);
var inst_72773 = (state_72809[(9)]);
var inst_72773__$1 = promise_chan;
var inst_72774__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_72775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72776 = [inst_72773__$1,inst_72774__$1];
var inst_72777 = (new cljs.core.PersistentVector(null,2,(5),inst_72775,inst_72776,null));
var state_72809__$1 = (function (){var statearr_72813 = state_72809;
(statearr_72813[(8)] = inst_72774__$1);

(statearr_72813[(9)] = inst_72773__$1);

return statearr_72813;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_72809__$1,(2),inst_72777);
} else {
if((state_val_72810 === (4))){
var inst_72774 = (state_72809[(8)]);
var inst_72781 = (state_72809[(7)]);
var inst_72785 = cljs.core._EQ_.call(null,inst_72781,inst_72774);
var state_72809__$1 = state_72809;
if(inst_72785){
var statearr_72814_72878 = state_72809__$1;
(statearr_72814_72878[(1)] = (6));

} else {
var statearr_72815_72879 = state_72809__$1;
(statearr_72815_72879[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72810 === (13))){
var state_72809__$1 = state_72809;
var statearr_72816_72880 = state_72809__$1;
(statearr_72816_72880[(2)] = null);

(statearr_72816_72880[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72810 === (6))){
var state_72809__$1 = state_72809;
var statearr_72817_72881 = state_72809__$1;
(statearr_72817_72881[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_72817_72881[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72810 === (3))){
var state_72809__$1 = state_72809;
var statearr_72818_72882 = state_72809__$1;
(statearr_72818_72882[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_72818_72882[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72810 === (12))){
var inst_72799 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_72800 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72801 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_72802 = cljs.core.PersistentHashMap.fromArrays(inst_72800,inst_72801);
var inst_72803 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_72802);
var inst_72804 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_72803);
var state_72809__$1 = (function (){var statearr_72819 = state_72809;
(statearr_72819[(10)] = inst_72799);

return statearr_72819;
})();
var statearr_72820_72883 = state_72809__$1;
(statearr_72820_72883[(2)] = inst_72804);

(statearr_72820_72883[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72810 === (2))){
var inst_72781 = (state_72809[(7)]);
var inst_72773 = (state_72809[(9)]);
var inst_72779 = (state_72809[(2)]);
var inst_72780 = cljs.core.nth.call(null,inst_72779,(0),null);
var inst_72781__$1 = cljs.core.nth.call(null,inst_72779,(1),null);
var inst_72782 = cljs.core._EQ_.call(null,inst_72781__$1,inst_72773);
var state_72809__$1 = (function (){var statearr_72821 = state_72809;
(statearr_72821[(7)] = inst_72781__$1);

(statearr_72821[(11)] = inst_72780);

return statearr_72821;
})();
if(inst_72782){
var statearr_72822_72884 = state_72809__$1;
(statearr_72822_72884[(1)] = (3));

} else {
var statearr_72823_72885 = state_72809__$1;
(statearr_72823_72885[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72810 === (11))){
var inst_72792 = (state_72809[(2)]);
var state_72809__$1 = state_72809;
var statearr_72824_72886 = state_72809__$1;
(statearr_72824_72886[(2)] = inst_72792);

(statearr_72824_72886[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72810 === (9))){
var inst_72780 = (state_72809[(11)]);
var state_72809__$1 = state_72809;
var statearr_72825_72887 = state_72809__$1;
(statearr_72825_72887[(2)] = inst_72780);

(statearr_72825_72887[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72810 === (5))){
var inst_72796 = (state_72809[(2)]);
var inst_72797 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_72796);
var state_72809__$1 = state_72809;
if(inst_72797){
var statearr_72826_72888 = state_72809__$1;
(statearr_72826_72888[(1)] = (12));

} else {
var statearr_72827_72889 = state_72809__$1;
(statearr_72827_72889[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72810 === (14))){
var inst_72807 = (state_72809[(2)]);
var state_72809__$1 = state_72809;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72809__$1,inst_72807);
} else {
if((state_val_72810 === (10))){
var state_72809__$1 = state_72809;
var statearr_72828_72890 = state_72809__$1;
(statearr_72828_72890[(2)] = null);

(statearr_72828_72890[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72810 === (8))){
var inst_72794 = (state_72809[(2)]);
var state_72809__$1 = state_72809;
var statearr_72829_72891 = state_72809__$1;
(statearr_72829_72891[(2)] = inst_72794);

(statearr_72829_72891[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____0 = (function (){
var statearr_72830 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72830[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__);

(statearr_72830[(1)] = (1));

return statearr_72830;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____1 = (function (state_72809){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_72809);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e72831){var ex__10948__auto__ = e72831;
var statearr_72832_72892 = state_72809;
(statearr_72832_72892[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_72809[(4)]))){
var statearr_72833_72893 = state_72809;
(statearr_72833_72893[(1)] = cljs.core.first.call(null,(state_72809[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72894 = state_72809;
state_72809 = G__72894;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__ = function(state_72809){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____1.call(this,state_72809);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_72834 = f__11019__auto__.call(null);
(statearr_72834[(6)] = c__11018__auto__);

return statearr_72834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_72938){
var state_val_72939 = (state_72938[(1)]);
if((state_val_72939 === (7))){
var state_72938__$1 = state_72938;
var statearr_72940_72966 = state_72938__$1;
(statearr_72940_72966[(2)] = null);

(statearr_72940_72966[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72939 === (1))){
var state_72938__$1 = state_72938;
var statearr_72941_72967 = state_72938__$1;
(statearr_72941_72967[(2)] = null);

(statearr_72941_72967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72939 === (4))){
var inst_72895 = (state_72938[(2)]);
var state_72938__$1 = state_72938;
var statearr_72942_72968 = state_72938__$1;
(statearr_72942_72968[(2)] = inst_72895);

(statearr_72942_72968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72939 === (6))){
var inst_72917 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_72938__$1 = state_72938;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72938__$1,(9),inst_72917);
} else {
if((state_val_72939 === (3))){
var inst_72936 = (state_72938[(2)]);
var state_72938__$1 = state_72938;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72938__$1,inst_72936);
} else {
if((state_val_72939 === (12))){
var inst_72930 = (state_72938[(2)]);
var state_72938__$1 = state_72938;
var statearr_72943_72969 = state_72938__$1;
(statearr_72943_72969[(2)] = inst_72930);

(statearr_72943_72969[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72939 === (2))){
var inst_72901 = (state_72938[(7)]);
var inst_72911 = (state_72938[(8)]);
var inst_72906 = (state_72938[(9)]);
var _ = (function (){var statearr_72944 = state_72938;
(statearr_72944[(4)] = cljs.core.cons.call(null,(5),(state_72938[(4)])));

return statearr_72944;
})();
var inst_72901__$1 = fluree.db.util.core.random_uuid.call(null);
var inst_72902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72903 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_72904 = (new cljs.core.PersistentVector(null,2,(5),inst_72902,inst_72903,null));
var inst_72905 = (function (){var lock_id = inst_72901__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_72906__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_72904,inst_72905);
var inst_72907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72908 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_72909 = (new cljs.core.PersistentVector(null,3,(5),inst_72907,inst_72908,null));
var inst_72910 = cljs.core.get_in.call(null,inst_72906__$1,inst_72909);
var inst_72911__$1 = cljs.core._EQ_.call(null,inst_72901__$1,inst_72910);
var inst_72912 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72913 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_72914 = (new cljs.core.PersistentVector(null,3,(5),inst_72912,inst_72913,null));
var inst_72915 = cljs.core.get_in.call(null,inst_72906__$1,inst_72914);
var state_72938__$1 = (function (){var statearr_72945 = state_72938;
(statearr_72945[(7)] = inst_72901__$1);

(statearr_72945[(8)] = inst_72911__$1);

(statearr_72945[(9)] = inst_72906__$1);

(statearr_72945[(10)] = inst_72915);

return statearr_72945;
})();
if(inst_72911__$1){
var statearr_72946_72970 = state_72938__$1;
(statearr_72946_72970[(1)] = (6));

} else {
var statearr_72947_72971 = state_72938__$1;
(statearr_72947_72971[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72939 === (11))){
var inst_72921 = (state_72938[(11)]);
var inst_72922 = (state_72938[(12)]);
var inst_72915 = (state_72938[(10)]);
var inst_72928 = fluree.db.util.xhttp.try_socket.call(null,inst_72921,sub_chan,pub_chan,inst_72915,(60000),inst_72922);
var state_72938__$1 = state_72938;
var statearr_72949_72972 = state_72938__$1;
(statearr_72949_72972[(2)] = inst_72928);

(statearr_72949_72972[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72939 === (9))){
var inst_72921 = (state_72938[(11)]);
var inst_72901 = (state_72938[(7)]);
var inst_72911 = (state_72938[(8)]);
var inst_72906 = (state_72938[(9)]);
var inst_72915 = (state_72938[(10)]);
var inst_72919 = (state_72938[(13)]);
var inst_72919__$1 = (state_72938[(2)]);
var inst_72920 = clojure.string.replace.call(null,inst_72919__$1,"http","ws");
var inst_72921__$1 = [inst_72920,"/fdb/ws"].join('');
var inst_72922 = (function (){var lock_id = inst_72901;
var state = inst_72906;
var have_lock_QMARK_ = inst_72911;
var resp_chan = inst_72915;
var healthy_server = inst_72919__$1;
var ws_url = inst_72921__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_72923 = fluree.db.util.core.exception_QMARK_.call(null,inst_72919__$1);
var state_72938__$1 = (function (){var statearr_72950 = state_72938;
(statearr_72950[(11)] = inst_72921__$1);

(statearr_72950[(12)] = inst_72922);

(statearr_72950[(13)] = inst_72919__$1);

return statearr_72950;
})();
if(inst_72923){
var statearr_72951_72973 = state_72938__$1;
(statearr_72951_72973[(1)] = (10));

} else {
var statearr_72952_72974 = state_72938__$1;
(statearr_72952_72974[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72939 === (5))){
var _ = (function (){var statearr_72953 = state_72938;
(statearr_72953[(4)] = cljs.core.rest.call(null,(state_72938[(4)])));

return statearr_72953;
})();
var state_72938__$1 = state_72938;
var ex72948 = (state_72938__$1[(2)]);
var statearr_72954_72975 = state_72938__$1;
(statearr_72954_72975[(5)] = ex72948);


if((ex72948 instanceof Error)){
var statearr_72955_72976 = state_72938__$1;
(statearr_72955_72976[(1)] = (4));

(statearr_72955_72976[(5)] = null);

} else {
throw ex72948;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72939 === (10))){
var inst_72915 = (state_72938[(10)]);
var inst_72919 = (state_72938[(13)]);
var inst_72925 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_72926 = cljs.core.async.put_BANG_.call(null,inst_72915,inst_72919);
var state_72938__$1 = (function (){var statearr_72956 = state_72938;
(statearr_72956[(14)] = inst_72925);

return statearr_72956;
})();
var statearr_72957_72977 = state_72938__$1;
(statearr_72957_72977[(2)] = inst_72926);

(statearr_72957_72977[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72939 === (8))){
var inst_72915 = (state_72938[(10)]);
var inst_72933 = (state_72938[(2)]);
var _ = (function (){var statearr_72958 = state_72938;
(statearr_72958[(4)] = cljs.core.rest.call(null,(state_72938[(4)])));

return statearr_72958;
})();
var state_72938__$1 = (function (){var statearr_72959 = state_72938;
(statearr_72959[(15)] = inst_72933);

return statearr_72959;
})();
var statearr_72960_72978 = state_72938__$1;
(statearr_72960_72978[(2)] = inst_72915);

(statearr_72960_72978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__10945__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__10945__auto____0 = (function (){
var statearr_72961 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72961[(0)] = fluree$db$connection$establish_socket_$_state_machine__10945__auto__);

(statearr_72961[(1)] = (1));

return statearr_72961;
});
var fluree$db$connection$establish_socket_$_state_machine__10945__auto____1 = (function (state_72938){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_72938);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e72962){var ex__10948__auto__ = e72962;
var statearr_72963_72979 = state_72938;
(statearr_72963_72979[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_72938[(4)]))){
var statearr_72964_72980 = state_72938;
(statearr_72964_72980[(1)] = cljs.core.first.call(null,(state_72938[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72981 = state_72938;
state_72938 = G__72981;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__10945__auto__ = function(state_72938){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__10945__auto____1.call(this,state_72938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__10945__auto____0;
fluree$db$connection$establish_socket_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__10945__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_72965 = f__11019__auto__.call(null);
(statearr_72965[(6)] = c__11018__auto__);

return statearr_72965;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k72983,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__72987 = k72983;
var G__72987__$1 = (((G__72987 instanceof cljs.core.Keyword))?G__72987.fqn:null);
switch (G__72987__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k72983,else__5345__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5365__auto__,p__72988){
var vec__72989 = p__72988;
var k__5366__auto__ = cljs.core.nth.call(null,vec__72989,(0),null);
var v__5367__auto__ = cljs.core.nth.call(null,vec__72989,(1),null);
return f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__);
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5359__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__72982){
var self__ = this;
var G__72982__$1 = this;
return (new cljs.core.RecordIter((0),G__72982__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (22 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5339__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__5339__auto__));
}).call(null,this__5338__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this72984,other72985){
var self__ = this;
var this72984__$1 = this;
return (((!((other72985 == null)))) && ((((this72984__$1.constructor === other72985.constructor)) && (((cljs.core._EQ_.call(null,this72984__$1.id,other72985.id)) && (((cljs.core._EQ_.call(null,this72984__$1.servers,other72985.servers)) && (((cljs.core._EQ_.call(null,this72984__$1.state,other72985.state)) && (((cljs.core._EQ_.call(null,this72984__$1.req_chan,other72985.req_chan)) && (((cljs.core._EQ_.call(null,this72984__$1.sub_chan,other72985.sub_chan)) && (((cljs.core._EQ_.call(null,this72984__$1.pub_chan,other72985.pub_chan)) && (((cljs.core._EQ_.call(null,this72984__$1.group,other72985.group)) && (((cljs.core._EQ_.call(null,this72984__$1.storage_read,other72985.storage_read)) && (((cljs.core._EQ_.call(null,this72984__$1.storage_write,other72985.storage_write)) && (((cljs.core._EQ_.call(null,this72984__$1.object_cache,other72985.object_cache)) && (((cljs.core._EQ_.call(null,this72984__$1.parallelism,other72985.parallelism)) && (((cljs.core._EQ_.call(null,this72984__$1.serializer,other72985.serializer)) && (((cljs.core._EQ_.call(null,this72984__$1.default_network,other72985.default_network)) && (((cljs.core._EQ_.call(null,this72984__$1.transactor_QMARK_,other72985.transactor_QMARK_)) && (((cljs.core._EQ_.call(null,this72984__$1.publish,other72985.publish)) && (((cljs.core._EQ_.call(null,this72984__$1.transact_handler,other72985.transact_handler)) && (((cljs.core._EQ_.call(null,this72984__$1.tx_private_key,other72985.tx_private_key)) && (((cljs.core._EQ_.call(null,this72984__$1.tx_key_id,other72985.tx_key_id)) && (((cljs.core._EQ_.call(null,this72984__$1.meta,other72985.meta)) && (((cljs.core._EQ_.call(null,this72984__$1.add_listener,other72985.add_listener)) && (((cljs.core._EQ_.call(null,this72984__$1.remove_listener,other72985.remove_listener)) && (((cljs.core._EQ_.call(null,this72984__$1.close,other72985.close)) && (cljs.core._EQ_.call(null,this72984__$1.__extmap,other72985.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5353__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k72983){
var self__ = this;
var this__5349__auto____$1 = this;
var G__72992 = k72983;
var G__72992__$1 = (((G__72992 instanceof cljs.core.Keyword))?G__72992.fqn:null);
switch (G__72992__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k72983);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__72982){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__72993 = cljs.core.keyword_identical_QMARK_;
var expr__72994 = k__5351__auto__;
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__72994))){
return (new fluree.db.connection.Connection(G__72982,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,G__72982,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__72982,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__72982,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__72982,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__72982,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"group","group",582596132),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__72982,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__72982,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__72982,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__72982,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__72982,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__72982,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__72982,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__72982,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__72982,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__72982,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__72982,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__72982,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__72982,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__72982,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__72982,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72993.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__72994))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__72982,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5351__auto__,G__72982),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__72982){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__72982,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5348__auto__,(0)),cljs.core._nth.call(null,entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write.call(null,writer__5389__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__72986){
var extmap__5384__auto__ = (function (){var G__72996 = cljs.core.dissoc.call(null,G__72986,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__72986)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__72996);
} else {
return G__72996;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__72986),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__72986),null,cljs.core.not_empty.call(null,extmap__5384__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__73002 = servers_STAR_;
var vec__73003 = G__73002;
var seq__73004 = cljs.core.seq.call(null,vec__73003);
var first__73005 = cljs.core.first.call(null,seq__73004);
var seq__73004__$1 = cljs.core.next.call(null,seq__73004);
var server = first__73005;
var r = seq__73004__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__73002__$1 = G__73002;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__73009 = G__73002__$1;
var seq__73010 = cljs.core.seq.call(null,vec__73009);
var first__73011 = cljs.core.first.call(null,seq__73010);
var seq__73010__$1 = cljs.core.next.call(null,seq__73010);
var server__$1 = first__73011;
var r__$1 = seq__73010__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__73012 = r__$1;
var G__73013 = is_https_QMARK_;
var G__73014 = result_STAR_;
G__73002__$1 = G__73012;
https_QMARK___$1 = G__73013;
result__$1 = G__73014;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__73015 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__73015 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__73015);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_73044){
var state_val_73045 = (state_73044[(1)]);
if((state_val_73045 === (7))){
var inst_73030 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73031 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73032 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73033 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73034 = fluree.db.connection.establish_socket.call(null,inst_73030,inst_73031,inst_73032,inst_73033);
var state_73044__$1 = state_73044;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73044__$1,(9),inst_73034);
} else {
if((state_val_73045 === (1))){
var state_73044__$1 = state_73044;
var statearr_73046_73065 = state_73044__$1;
(statearr_73046_73065[(2)] = null);

(statearr_73046_73065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73045 === (4))){
var inst_73016 = (state_73044[(2)]);
var state_73044__$1 = state_73044;
var statearr_73047_73066 = state_73044__$1;
(statearr_73047_73066[(2)] = inst_73016);

(statearr_73047_73066[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73045 === (6))){
var inst_73027 = (state_73044[(7)]);
var state_73044__$1 = state_73044;
var statearr_73048_73067 = state_73044__$1;
(statearr_73048_73067[(2)] = inst_73027);

(statearr_73048_73067[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73045 === (3))){
var inst_73042 = (state_73044[(2)]);
var state_73044__$1 = state_73044;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73044__$1,inst_73042);
} else {
if((state_val_73045 === (2))){
var inst_73027 = (state_73044[(7)]);
var _ = (function (){var statearr_73050 = state_73044;
(statearr_73050[(4)] = cljs.core.cons.call(null,(5),(state_73044[(4)])));

return statearr_73050;
})();
var inst_73022 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_73023 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73024 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73025 = [inst_73024,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_73026 = (new cljs.core.PersistentVector(null,3,(5),inst_73023,inst_73025,null));
var inst_73027__$1 = cljs.core.get_in.call(null,inst_73022,inst_73026);
var state_73044__$1 = (function (){var statearr_73051 = state_73044;
(statearr_73051[(7)] = inst_73027__$1);

return statearr_73051;
})();
if(cljs.core.truth_(inst_73027__$1)){
var statearr_73052_73068 = state_73044__$1;
(statearr_73052_73068[(1)] = (6));

} else {
var statearr_73053_73069 = state_73044__$1;
(statearr_73053_73069[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73045 === (9))){
var inst_73036 = (state_73044[(2)]);
var inst_73037 = fluree.db.util.async.throw_err.call(null,inst_73036);
var state_73044__$1 = state_73044;
var statearr_73054_73070 = state_73044__$1;
(statearr_73054_73070[(2)] = inst_73037);

(statearr_73054_73070[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73045 === (5))){
var _ = (function (){var statearr_73055 = state_73044;
(statearr_73055[(4)] = cljs.core.rest.call(null,(state_73044[(4)])));

return statearr_73055;
})();
var state_73044__$1 = state_73044;
var ex73049 = (state_73044__$1[(2)]);
var statearr_73056_73071 = state_73044__$1;
(statearr_73056_73071[(5)] = ex73049);


if((ex73049 instanceof Error)){
var statearr_73057_73072 = state_73044__$1;
(statearr_73057_73072[(1)] = (4));

(statearr_73057_73072[(5)] = null);

} else {
throw ex73049;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73045 === (8))){
var inst_73039 = (state_73044[(2)]);
var _ = (function (){var statearr_73058 = state_73044;
(statearr_73058[(4)] = cljs.core.rest.call(null,(state_73044[(4)])));

return statearr_73058;
})();
var state_73044__$1 = state_73044;
var statearr_73059_73073 = state_73044__$1;
(statearr_73059_73073[(2)] = inst_73039);

(statearr_73059_73073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__10945__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__10945__auto____0 = (function (){
var statearr_73060 = [null,null,null,null,null,null,null,null];
(statearr_73060[(0)] = fluree$db$connection$get_socket_$_state_machine__10945__auto__);

(statearr_73060[(1)] = (1));

return statearr_73060;
});
var fluree$db$connection$get_socket_$_state_machine__10945__auto____1 = (function (state_73044){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_73044);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e73061){var ex__10948__auto__ = e73061;
var statearr_73062_73074 = state_73044;
(statearr_73062_73074[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_73044[(4)]))){
var statearr_73063_73075 = state_73044;
(statearr_73063_73075[(1)] = cljs.core.first.call(null,(state_73044[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73076 = state_73044;
state_73044 = G__73076;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__10945__auto__ = function(state_73044){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__10945__auto____1.call(this,state_73044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__10945__auto____0;
fluree$db$connection$get_socket_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__10945__auto____1;
return fluree$db$connection$get_socket_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_73064 = f__11019__auto__.call(null);
(statearr_73064[(6)] = c__11018__auto__);

return statearr_73064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e73077){var e = e73077;
fluree.db.util.log.error.call(null,"Unable to publish message on websocket. Error encoding JSON message: ",message);

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_73204){
var state_val_73205 = (state_73204[(1)]);
if((state_val_73205 === (7))){
var inst_73200 = (state_73204[(2)]);
var state_73204__$1 = state_73204;
var statearr_73207_73277 = state_73204__$1;
(statearr_73207_73277[(2)] = inst_73200);

(statearr_73207_73277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (20))){
var _ = (function (){var statearr_73208 = state_73204;
(statearr_73208[(4)] = cljs.core.rest.call(null,(state_73204[(4)])));

return statearr_73208;
})();
var state_73204__$1 = state_73204;
var ex73206 = (state_73204__$1[(2)]);
var statearr_73209_73278 = state_73204__$1;
(statearr_73209_73278[(5)] = ex73206);


var statearr_73210_73279 = state_73204__$1;
(statearr_73210_73279[(1)] = (10));

(statearr_73210_73279[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (27))){
var inst_73192 = (state_73204[(2)]);
var _ = (function (){var statearr_73211 = state_73204;
(statearr_73211[(4)] = cljs.core.rest.call(null,(state_73204[(4)])));

return statearr_73211;
})();
var state_73204__$1 = state_73204;
var statearr_73212_73280 = state_73204__$1;
(statearr_73212_73280[(2)] = inst_73192);

(statearr_73212_73280[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (1))){
var inst_73079 = (0);
var state_73204__$1 = (function (){var statearr_73213 = state_73204;
(statearr_73213[(7)] = inst_73079);

return statearr_73213;
})();
var statearr_73214_73281 = state_73204__$1;
(statearr_73214_73281[(2)] = null);

(statearr_73214_73281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (24))){
var inst_73170 = (state_73204[(8)]);
var inst_73170__$1 = (state_73204[(2)]);
var inst_73171 = inst_73170__$1 === true;
var state_73204__$1 = (function (){var statearr_73215 = state_73204;
(statearr_73215[(8)] = inst_73170__$1);

return statearr_73215;
})();
if(cljs.core.truth_(inst_73171)){
var statearr_73216_73282 = state_73204__$1;
(statearr_73216_73282[(1)] = (25));

} else {
var statearr_73217_73283 = state_73204__$1;
(statearr_73217_73283[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (4))){
var inst_73082 = (state_73204[(9)]);
var inst_73082__$1 = (state_73204[(2)]);
var state_73204__$1 = (function (){var statearr_73218 = state_73204;
(statearr_73218[(9)] = inst_73082__$1);

return statearr_73218;
})();
if(cljs.core.truth_(inst_73082__$1)){
var statearr_73219_73284 = state_73204__$1;
(statearr_73219_73284[(1)] = (5));

} else {
var statearr_73220_73285 = state_73204__$1;
(statearr_73220_73285[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (15))){
var inst_73095 = (state_73204[(10)]);
var state_73204__$1 = state_73204;
var statearr_73221_73286 = state_73204__$1;
(statearr_73221_73286[(2)] = inst_73095);

(statearr_73221_73286[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (21))){
var inst_73119 = (state_73204[(11)]);
var inst_73126 = (state_73204[(12)]);
var inst_73121 = (state_73204[(13)]);
var inst_73123 = (state_73204[(14)]);
var inst_73127 = (state_73204[(15)]);
var inst_73122 = (state_73204[(16)]);
var inst_73079 = (state_73204[(7)]);
var inst_73120 = (state_73204[(17)]);
var inst_73082 = (state_73204[(9)]);
var inst_73118 = (state_73204[(18)]);
var inst_73129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73130 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_73126];
var inst_73131 = (new cljs.core.PersistentVector(null,2,(5),inst_73129,inst_73130,null));
var inst_73132 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_73131,inst_73121);
var inst_73159 = cljs.core.async.chan.call(null,(1));
var inst_73160 = (function (){var resp_chan = inst_73121;
var timeout = inst_73127;
var i = inst_73079;
var data = inst_73120;
var vec__73114 = inst_73082;
var _ = inst_73118;
var req_id = inst_73126;
var operation = inst_73119;
var map__73117 = inst_73123;
var msg = inst_73082;
var c__11018__auto____$1 = inst_73159;
var opts = inst_73122;
return (function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_73157){
var state_val_73158 = (state_73157[(1)]);
if((state_val_73158 === (1))){
var inst_73136 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73137 = cljs.core.async.timeout.call(null,timeout);
var inst_73138 = [resp_chan,inst_73137];
var inst_73139 = (new cljs.core.PersistentVector(null,2,(5),inst_73136,inst_73138,null));
var state_73157__$1 = state_73157;
return cljs.core.async.ioc_alts_BANG_.call(null,state_73157__$1,(2),inst_73139);
} else {
if((state_val_73158 === (2))){
var inst_73142 = (state_73157[(7)]);
var inst_73141 = (state_73157[(2)]);
var inst_73142__$1 = cljs.core.nth.call(null,inst_73141,(0),null);
var inst_73143 = cljs.core.nth.call(null,inst_73141,(1),null);
var inst_73144 = (function (){var vec__73133 = inst_73141;
var resp = inst_73142__$1;
var c = inst_73143;
return (function (p1__73078_SHARP_){
return cljs.core.dissoc.call(null,p1__73078_SHARP_,req_id);
});
})();
var inst_73145 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_73144);
var inst_73146 = cljs.core._EQ_.call(null,inst_73143,resp_chan);
var state_73157__$1 = (function (){var statearr_73222 = state_73157;
(statearr_73222[(8)] = inst_73145);

(statearr_73222[(7)] = inst_73142__$1);

return statearr_73222;
})();
if(inst_73146){
var statearr_73223_73287 = state_73157__$1;
(statearr_73223_73287[(1)] = (3));

} else {
var statearr_73224_73288 = state_73157__$1;
(statearr_73224_73288[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73158 === (3))){
var inst_73142 = (state_73157[(7)]);
var state_73157__$1 = state_73157;
var statearr_73225_73289 = state_73157__$1;
(statearr_73225_73289[(2)] = inst_73142);

(statearr_73225_73289[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73158 === (4))){
var inst_73149 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_73150 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73151 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_73152 = cljs.core.PersistentHashMap.fromArrays(inst_73150,inst_73151);
var inst_73153 = cljs.core.ex_info.call(null,inst_73149,inst_73152);
var state_73157__$1 = state_73157;
var statearr_73226_73290 = state_73157__$1;
(statearr_73226_73290[(2)] = inst_73153);

(statearr_73226_73290[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73158 === (5))){
var inst_73155 = (state_73157[(2)]);
var state_73157__$1 = state_73157;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73157__$1,inst_73155);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__10945__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__10945__auto____0 = (function (){
var statearr_73227 = [null,null,null,null,null,null,null,null,null];
(statearr_73227[(0)] = fluree$db$connection$msg_producer_$_state_machine__10945__auto__);

(statearr_73227[(1)] = (1));

return statearr_73227;
});
var fluree$db$connection$msg_producer_$_state_machine__10945__auto____1 = (function (state_73157){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_73157);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e73228){var ex__10948__auto__ = e73228;
var statearr_73229_73291 = state_73157;
(statearr_73229_73291[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_73157[(4)]))){
var statearr_73230_73292 = state_73157;
(statearr_73230_73292[(1)] = cljs.core.first.call(null,(state_73157[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73293 = state_73157;
state_73157 = G__73293;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__10945__auto__ = function(state_73157){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__10945__auto____1.call(this,state_73157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__10945__auto____0;
fluree$db$connection$msg_producer_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__10945__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_73231 = f__11019__auto__.call(null);
(statearr_73231[(6)] = c__11018__auto____$1);

return statearr_73231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
});
})();
var inst_73161 = cljs.core.async.impl.dispatch.run.call(null,inst_73160);
var state_73204__$1 = (function (){var statearr_73232 = state_73204;
(statearr_73232[(19)] = inst_73132);

(statearr_73232[(20)] = inst_73161);

return statearr_73232;
})();
var statearr_73233_73294 = state_73204__$1;
(statearr_73233_73294[(2)] = inst_73159);

(statearr_73233_73294[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (31))){
var inst_73180 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed.");
var state_73204__$1 = state_73204;
var statearr_73234_73295 = state_73204__$1;
(statearr_73234_73295[(2)] = inst_73180);

(statearr_73234_73295[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (32))){
var state_73204__$1 = state_73204;
var statearr_73235_73296 = state_73204__$1;
(statearr_73235_73296[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (33))){
var inst_73188 = (state_73204[(2)]);
var state_73204__$1 = state_73204;
var statearr_73237_73297 = state_73204__$1;
(statearr_73237_73297[(2)] = inst_73188);

(statearr_73237_73297[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (13))){
var inst_73095 = (state_73204[(10)]);
var inst_73092 = (state_73204[(2)]);
var inst_73093 = cljs.core.nth.call(null,inst_73092,(0),null);
var inst_73094 = cljs.core.nth.call(null,inst_73092,(1),null);
var inst_73095__$1 = cljs.core.nth.call(null,inst_73092,(2),null);
var state_73204__$1 = (function (){var statearr_73238 = state_73204;
(statearr_73238[(21)] = inst_73094);

(statearr_73238[(10)] = inst_73095__$1);

(statearr_73238[(22)] = inst_73093);

return statearr_73238;
})();
if(cljs.core.truth_(inst_73095__$1)){
var statearr_73239_73298 = state_73204__$1;
(statearr_73239_73298[(1)] = (14));

} else {
var statearr_73240_73299 = state_73204__$1;
(statearr_73240_73299[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (22))){
var state_73204__$1 = state_73204;
var statearr_73241_73300 = state_73204__$1;
(statearr_73241_73300[(2)] = null);

(statearr_73241_73300[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (36))){
var inst_73186 = (state_73204[(2)]);
var state_73204__$1 = state_73204;
var statearr_73242_73301 = state_73204__$1;
(statearr_73242_73301[(2)] = inst_73186);

(statearr_73242_73301[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (29))){
var inst_73170 = (state_73204[(8)]);
var inst_73178 = (inst_73170 == null);
var state_73204__$1 = state_73204;
if(cljs.core.truth_(inst_73178)){
var statearr_73243_73302 = state_73204__$1;
(statearr_73243_73302[(1)] = (31));

} else {
var statearr_73244_73303 = state_73204__$1;
(statearr_73244_73303[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (6))){
var state_73204__$1 = state_73204;
var statearr_73245_73304 = state_73204__$1;
(statearr_73245_73304[(2)] = null);

(statearr_73245_73304[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (28))){
var inst_73170 = (state_73204[(8)]);
var inst_73176 = fluree.db.util.log.error.call(null,inst_73170,"Error processing message in producer.");
var state_73204__$1 = state_73204;
var statearr_73246_73305 = state_73204__$1;
(statearr_73246_73305[(2)] = inst_73176);

(statearr_73246_73305[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (25))){
var state_73204__$1 = state_73204;
var statearr_73247_73306 = state_73204__$1;
(statearr_73247_73306[(2)] = null);

(statearr_73247_73306[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (34))){
var inst_73170 = (state_73204[(8)]);
var inst_73183 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed. Published result",inst_73170);
var state_73204__$1 = state_73204;
var statearr_73248_73307 = state_73204__$1;
(statearr_73248_73307[(2)] = inst_73183);

(statearr_73248_73307[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (17))){
var inst_73095 = (state_73204[(10)]);
var inst_73084 = (state_73204[(23)]);
var inst_73102 = cljs.core.async.put_BANG_.call(null,inst_73095,inst_73084);
var state_73204__$1 = state_73204;
var statearr_73249_73308 = state_73204__$1;
(statearr_73249_73308[(2)] = inst_73102);

(statearr_73249_73308[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (3))){
var inst_73202 = (state_73204[(2)]);
var state_73204__$1 = state_73204;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73204__$1,inst_73202);
} else {
if((state_val_73205 === (12))){
var state_73204__$1 = state_73204;
var statearr_73250_73309 = state_73204__$1;
(statearr_73250_73309[(2)] = null);

(statearr_73250_73309[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (2))){
var state_73204__$1 = state_73204;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73204__$1,(4),req_chan);
} else {
if((state_val_73205 === (23))){
var inst_73119 = (state_73204[(11)]);
var inst_73126 = (state_73204[(12)]);
var inst_73120 = (state_73204[(17)]);
var inst_73164 = (state_73204[(2)]);
var inst_73165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73166 = [inst_73119,inst_73126,inst_73120];
var inst_73167 = (new cljs.core.PersistentVector(null,3,(5),inst_73165,inst_73166,null));
var inst_73168 = publish_fn.call(null,conn,inst_73167);
var state_73204__$1 = (function (){var statearr_73251 = state_73204;
(statearr_73251[(24)] = inst_73164);

return statearr_73251;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73204__$1,(24),inst_73168);
} else {
if((state_val_73205 === (35))){
var state_73204__$1 = state_73204;
var statearr_73252_73310 = state_73204__$1;
(statearr_73252_73310[(2)] = null);

(statearr_73252_73310[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (19))){
var inst_73108 = (state_73204[(2)]);
var state_73204__$1 = state_73204;
var statearr_73253_73311 = state_73204__$1;
(statearr_73253_73311[(2)] = inst_73108);

(statearr_73253_73311[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (11))){
var inst_73082 = (state_73204[(9)]);
var state_73204__$1 = state_73204;
var statearr_73254_73312 = state_73204__$1;
(statearr_73254_73312[(2)] = inst_73082);

(statearr_73254_73312[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (9))){
var inst_73079 = (state_73204[(7)]);
var inst_73195 = (state_73204[(2)]);
var inst_73196 = (inst_73079 + (1));
var inst_73079__$1 = inst_73196;
var state_73204__$1 = (function (){var statearr_73255 = state_73204;
(statearr_73255[(7)] = inst_73079__$1);

(statearr_73255[(25)] = inst_73195);

return statearr_73255;
})();
var statearr_73256_73313 = state_73204__$1;
(statearr_73256_73313[(2)] = null);

(statearr_73256_73313[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (5))){
var state_73204__$1 = state_73204;
var statearr_73257_73314 = state_73204__$1;
(statearr_73257_73314[(2)] = null);

(statearr_73257_73314[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (14))){
var inst_73095 = (state_73204[(10)]);
var inst_73097 = fluree.db.util.async.channel_QMARK_.call(null,inst_73095);
var state_73204__$1 = state_73204;
var statearr_73258_73315 = state_73204__$1;
(statearr_73258_73315[(2)] = inst_73097);

(statearr_73258_73315[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (26))){
var inst_73170 = (state_73204[(8)]);
var inst_73174 = fluree.db.util.core.exception_QMARK_.call(null,inst_73170);
var state_73204__$1 = state_73204;
if(inst_73174){
var statearr_73259_73316 = state_73204__$1;
(statearr_73259_73316[(1)] = (28));

} else {
var statearr_73260_73317 = state_73204__$1;
(statearr_73260_73317[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (16))){
var inst_73100 = (state_73204[(2)]);
var state_73204__$1 = state_73204;
if(cljs.core.truth_(inst_73100)){
var statearr_73261_73318 = state_73204__$1;
(statearr_73261_73318[(1)] = (17));

} else {
var statearr_73262_73319 = state_73204__$1;
(statearr_73262_73319[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (30))){
var inst_73190 = (state_73204[(2)]);
var state_73204__$1 = state_73204;
var statearr_73263_73320 = state_73204__$1;
(statearr_73263_73320[(2)] = inst_73190);

(statearr_73263_73320[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (10))){
var inst_73082 = (state_73204[(9)]);
var inst_73084 = (state_73204[(2)]);
var inst_73088 = cljs.core.sequential_QMARK_.call(null,inst_73082);
var state_73204__$1 = (function (){var statearr_73264 = state_73204;
(statearr_73264[(23)] = inst_73084);

return statearr_73264;
})();
if(inst_73088){
var statearr_73265_73321 = state_73204__$1;
(statearr_73265_73321[(1)] = (11));

} else {
var statearr_73266_73322 = state_73204__$1;
(statearr_73266_73322[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (18))){
var inst_73084 = (state_73204[(23)]);
var inst_73082 = (state_73204[(9)]);
var inst_73104 = cljs.core.pr_str.call(null,inst_73082);
var inst_73105 = ["Error processing ledger request, no valid return channel: ",inst_73104].join('');
var inst_73106 = fluree.db.util.log.error.call(null,inst_73084,inst_73105);
var state_73204__$1 = state_73204;
var statearr_73267_73323 = state_73204__$1;
(statearr_73267_73323[(2)] = inst_73106);

(statearr_73267_73323[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73205 === (8))){
var inst_73121 = (state_73204[(13)]);
var inst_73123 = (state_73204[(14)]);
var inst_73122 = (state_73204[(16)]);
var inst_73082 = (state_73204[(9)]);
var _ = (function (){var statearr_73268 = state_73204;
(statearr_73268[(4)] = cljs.core.cons.call(null,(20),(state_73204[(4)])));

return statearr_73268;
})();
var inst_73118 = fluree.db.util.log.trace.call(null,"Outgoing message to websocket: ",inst_73082);
var inst_73119 = cljs.core.nth.call(null,inst_73082,(0),null);
var inst_73120 = cljs.core.nth.call(null,inst_73082,(1),null);
var inst_73121__$1 = cljs.core.nth.call(null,inst_73082,(2),null);
var inst_73122__$1 = cljs.core.nth.call(null,inst_73082,(3),null);
var inst_73123__$1 = cljs.core.__destructure_map.call(null,inst_73122__$1);
var inst_73124 = fluree.db.util.core.random_uuid.call(null);
var inst_73125 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73124);
var inst_73126 = cljs.core.get.call(null,inst_73123__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_73125);
var inst_73127 = cljs.core.get.call(null,inst_73123__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_73204__$1 = (function (){var statearr_73269 = state_73204;
(statearr_73269[(11)] = inst_73119);

(statearr_73269[(12)] = inst_73126);

(statearr_73269[(13)] = inst_73121__$1);

(statearr_73269[(14)] = inst_73123__$1);

(statearr_73269[(15)] = inst_73127);

(statearr_73269[(16)] = inst_73122__$1);

(statearr_73269[(17)] = inst_73120);

(statearr_73269[(18)] = inst_73118);

return statearr_73269;
})();
if(cljs.core.truth_(inst_73121__$1)){
var statearr_73270_73324 = state_73204__$1;
(statearr_73270_73324[(1)] = (21));

} else {
var statearr_73271_73325 = state_73204__$1;
(statearr_73271_73325[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__10945__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__10945__auto____0 = (function (){
var statearr_73272 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73272[(0)] = fluree$db$connection$msg_producer_$_state_machine__10945__auto__);

(statearr_73272[(1)] = (1));

return statearr_73272;
});
var fluree$db$connection$msg_producer_$_state_machine__10945__auto____1 = (function (state_73204){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_73204);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e73273){var ex__10948__auto__ = e73273;
var statearr_73274_73326 = state_73204;
(statearr_73274_73326[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_73204[(4)]))){
var statearr_73275_73327 = state_73204;
(statearr_73275_73327[(1)] = cljs.core.first.call(null,(state_73204[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73328 = state_73204;
state_73204 = G__73328;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__10945__auto__ = function(state_73204){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__10945__auto____1.call(this,state_73204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__10945__auto____0;
fluree$db$connection$msg_producer_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__10945__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_73276 = f__11019__auto__.call(null);
(statearr_73276[(6)] = c__11018__auto__);

return statearr_73276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__73329 = conn;
var map__73329__$1 = cljs.core.__destructure_map.call(null,map__73329);
var sub_chan = cljs.core.get.call(null,map__73329__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_73414){
var state_val_73415 = (state_73414[(1)]);
if((state_val_73415 === (7))){
var inst_73410 = (state_73414[(2)]);
var state_73414__$1 = state_73414;
var statearr_73416_73467 = state_73414__$1;
(statearr_73416_73467[(2)] = inst_73410);

(statearr_73416_73467[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (20))){
var inst_73348 = (state_73414[(7)]);
var inst_73362 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_73363 = [inst_73348];
var inst_73364 = cljs.core.PersistentHashMap.fromArrays(inst_73362,inst_73363);
var inst_73365 = fluree.db.util.log.warn.call(null,"Unsupported callback registered",inst_73364);
var state_73414__$1 = state_73414;
var statearr_73417_73468 = state_73414__$1;
(statearr_73417_73468[(2)] = inst_73365);

(statearr_73417_73468[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (27))){
var state_73414__$1 = state_73414;
var statearr_73418_73469 = state_73414__$1;
(statearr_73418_73469[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (1))){
var inst_73330 = (0);
var state_73414__$1 = (function (){var statearr_73420 = state_73414;
(statearr_73420[(8)] = inst_73330);

return statearr_73420;
})();
var statearr_73421_73470 = state_73414__$1;
(statearr_73421_73470[(2)] = null);

(statearr_73421_73470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (24))){
var inst_73341 = (state_73414[(9)]);
var inst_73390 = fluree.db.util.core.exception_QMARK_.call(null,inst_73341);
var state_73414__$1 = state_73414;
if(inst_73390){
var statearr_73422_73471 = state_73414__$1;
(statearr_73422_73471[(1)] = (26));

} else {
var statearr_73423_73472 = state_73414__$1;
(statearr_73423_73472[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (4))){
var inst_73335 = (state_73414[(10)]);
var inst_73340 = (state_73414[(2)]);
var inst_73341 = cljs.core.nth.call(null,inst_73340,(0),null);
var inst_73342 = cljs.core.nth.call(null,inst_73340,(1),null);
var inst_73343 = cljs.core._EQ_.call(null,inst_73342,inst_73335);
var state_73414__$1 = (function (){var statearr_73424 = state_73414;
(statearr_73424[(9)] = inst_73341);

return statearr_73424;
})();
if(inst_73343){
var statearr_73425_73473 = state_73414__$1;
(statearr_73425_73473[(1)] = (5));

} else {
var statearr_73426_73474 = state_73414__$1;
(statearr_73426_73474[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (15))){
var inst_73348 = (state_73414[(7)]);
var inst_73357 = typeof inst_73348 === 'string';
var state_73414__$1 = state_73414;
if(cljs.core.truth_(inst_73357)){
var statearr_73427_73475 = state_73414__$1;
(statearr_73427_73475[(1)] = (17));

} else {
var statearr_73428_73476 = state_73414__$1;
(statearr_73428_73476[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (21))){
var state_73414__$1 = state_73414;
var statearr_73429_73477 = state_73414__$1;
(statearr_73429_73477[(2)] = null);

(statearr_73429_73477[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (31))){
var inst_73404 = (state_73414[(2)]);
var state_73414__$1 = state_73414;
var statearr_73430_73478 = state_73414__$1;
(statearr_73430_73478[(2)] = inst_73404);

(statearr_73430_73478[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (13))){
var inst_73374 = (state_73414[(2)]);
var inst_73375 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73376 = fluree.db.connection.close_websocket.call(null,inst_73375);
var inst_73377 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73378 = fluree.db.session.close_all_sessions.call(null,inst_73377);
var state_73414__$1 = (function (){var statearr_73431 = state_73414;
(statearr_73431[(11)] = inst_73374);

(statearr_73431[(12)] = inst_73376);

return statearr_73431;
})();
var statearr_73432_73479 = state_73414__$1;
(statearr_73432_73479[(2)] = inst_73378);

(statearr_73432_73479[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (22))){
var inst_73368 = (state_73414[(2)]);
var state_73414__$1 = state_73414;
var statearr_73433_73480 = state_73414__$1;
(statearr_73433_73480[(2)] = inst_73368);

(statearr_73433_73480[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (29))){
var inst_73341 = (state_73414[(9)]);
var inst_73396 = fluree.db.util.json.parse.call(null,inst_73341);
var inst_73397 = cljs.core.pr_str.call(null,inst_73396);
var inst_73398 = fluree.db.util.log.trace.call(null,"Received message:",inst_73397);
var inst_73399 = fluree.db.util.json.parse.call(null,inst_73341);
var inst_73400 = fluree.db.conn_events.process_events.call(null,conn,inst_73399);
var inst_73330 = (0);
var state_73414__$1 = (function (){var statearr_73434 = state_73414;
(statearr_73434[(8)] = inst_73330);

(statearr_73434[(13)] = inst_73398);

(statearr_73434[(14)] = inst_73400);

return statearr_73434;
})();
var statearr_73435_73481 = state_73414__$1;
(statearr_73435_73481[(2)] = null);

(statearr_73435_73481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (6))){
var inst_73341 = (state_73414[(9)]);
var inst_73386 = (inst_73341 == null);
var state_73414__$1 = state_73414;
if(cljs.core.truth_(inst_73386)){
var statearr_73436_73482 = state_73414__$1;
(statearr_73436_73482[(1)] = (23));

} else {
var statearr_73437_73483 = state_73414__$1;
(statearr_73437_73483[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (28))){
var inst_73406 = (state_73414[(2)]);
var state_73414__$1 = state_73414;
var statearr_73438_73484 = state_73414__$1;
(statearr_73438_73484[(2)] = inst_73406);

(statearr_73438_73484[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (25))){
var inst_73408 = (state_73414[(2)]);
var state_73414__$1 = state_73414;
var statearr_73439_73485 = state_73414__$1;
(statearr_73439_73485[(2)] = inst_73408);

(statearr_73439_73485[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (17))){
var inst_73348 = (state_73414[(7)]);
var inst_73359 = cljs.core.eval.call(null,inst_73348);
var state_73414__$1 = state_73414;
var statearr_73440_73486 = state_73414__$1;
(statearr_73440_73486[(2)] = inst_73359);

(statearr_73440_73486[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (3))){
var inst_73412 = (state_73414[(2)]);
var state_73414__$1 = state_73414;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73414__$1,inst_73412);
} else {
if((state_val_73415 === (12))){
var inst_73348 = (state_73414[(7)]);
var inst_73353 = cljs.core.fn_QMARK_.call(null,inst_73348);
var state_73414__$1 = state_73414;
if(inst_73353){
var statearr_73441_73487 = state_73414__$1;
(statearr_73441_73487[(1)] = (14));

} else {
var statearr_73442_73488 = state_73414__$1;
(statearr_73442_73488[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (2))){
var inst_73335 = (state_73414[(10)]);
var inst_73335__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_73336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73337 = [sub_chan,inst_73335__$1];
var inst_73338 = (new cljs.core.PersistentVector(null,2,(5),inst_73336,inst_73337,null));
var state_73414__$1 = (function (){var statearr_73443 = state_73414;
(statearr_73443[(10)] = inst_73335__$1);

return statearr_73443;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_73414__$1,(4),inst_73338);
} else {
if((state_val_73415 === (23))){
var inst_73388 = fluree.db.util.log.info.call(null,"Connection closed.");
var state_73414__$1 = state_73414;
var statearr_73444_73489 = state_73414__$1;
(statearr_73444_73489[(2)] = inst_73388);

(statearr_73444_73489[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (19))){
var inst_73370 = (state_73414[(2)]);
var state_73414__$1 = state_73414;
var statearr_73445_73490 = state_73414__$1;
(statearr_73445_73490[(2)] = inst_73370);

(statearr_73445_73490[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (11))){
var inst_73351 = fluree.db.util.log.trace.call(null,"No keep-alive callback is registered");
var state_73414__$1 = state_73414;
var statearr_73446_73491 = state_73414__$1;
(statearr_73446_73491[(2)] = inst_73351);

(statearr_73446_73491[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (9))){
var inst_73330 = (state_73414[(8)]);
var inst_73380 = fluree.db.connection.ping_transactor.call(null,conn);
var inst_73381 = (inst_73330 + (1));
var inst_73330__$1 = inst_73381;
var state_73414__$1 = (function (){var statearr_73447 = state_73414;
(statearr_73447[(8)] = inst_73330__$1);

(statearr_73447[(15)] = inst_73380);

return statearr_73447;
})();
var statearr_73448_73492 = state_73414__$1;
(statearr_73448_73492[(2)] = null);

(statearr_73448_73492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (5))){
var inst_73330 = (state_73414[(8)]);
var inst_73345 = cljs.core._EQ_.call(null,(2),inst_73330);
var state_73414__$1 = state_73414;
if(inst_73345){
var statearr_73449_73493 = state_73414__$1;
(statearr_73449_73493[(1)] = (8));

} else {
var statearr_73450_73494 = state_73414__$1;
(statearr_73450_73494[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (14))){
var inst_73348 = (state_73414[(7)]);
var inst_73355 = inst_73348.call(null);
var state_73414__$1 = state_73414;
var statearr_73451_73495 = state_73414__$1;
(statearr_73451_73495[(2)] = inst_73355);

(statearr_73451_73495[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (26))){
var inst_73341 = (state_73414[(9)]);
var inst_73392 = fluree.db.util.log.error.call(null,inst_73341);
var inst_73330 = (0);
var state_73414__$1 = (function (){var statearr_73452 = state_73414;
(statearr_73452[(8)] = inst_73330);

(statearr_73452[(16)] = inst_73392);

return statearr_73452;
})();
var statearr_73453_73496 = state_73414__$1;
(statearr_73453_73496[(2)] = null);

(statearr_73453_73496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (16))){
var inst_73372 = (state_73414[(2)]);
var state_73414__$1 = state_73414;
var statearr_73454_73497 = state_73414__$1;
(statearr_73454_73497[(2)] = inst_73372);

(statearr_73454_73497[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (30))){
var state_73414__$1 = state_73414;
var statearr_73455_73498 = state_73414__$1;
(statearr_73455_73498[(2)] = null);

(statearr_73455_73498[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (10))){
var inst_73384 = (state_73414[(2)]);
var state_73414__$1 = state_73414;
var statearr_73456_73499 = state_73414__$1;
(statearr_73456_73499[(2)] = inst_73384);

(statearr_73456_73499[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (18))){
var state_73414__$1 = state_73414;
var statearr_73457_73500 = state_73414__$1;
(statearr_73457_73500[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73415 === (8))){
var inst_73348 = (state_73414[(7)]);
var inst_73347 = fluree.db.util.log.warn.call(null,"Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket.");
var inst_73348__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73349 = (inst_73348__$1 == null);
var state_73414__$1 = (function (){var statearr_73459 = state_73414;
(statearr_73459[(7)] = inst_73348__$1);

(statearr_73459[(17)] = inst_73347);

return statearr_73459;
})();
if(cljs.core.truth_(inst_73349)){
var statearr_73460_73501 = state_73414__$1;
(statearr_73460_73501[(1)] = (11));

} else {
var statearr_73461_73502 = state_73414__$1;
(statearr_73461_73502[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__10945__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__10945__auto____0 = (function (){
var statearr_73462 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73462[(0)] = fluree$db$connection$msg_consumer_$_state_machine__10945__auto__);

(statearr_73462[(1)] = (1));

return statearr_73462;
});
var fluree$db$connection$msg_consumer_$_state_machine__10945__auto____1 = (function (state_73414){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_73414);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e73463){var ex__10948__auto__ = e73463;
var statearr_73464_73503 = state_73414;
(statearr_73464_73503[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_73414[(4)]))){
var statearr_73465_73504 = state_73414;
(statearr_73465_73504[(1)] = cljs.core.first.call(null,(state_73414[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73505 = state_73414;
state_73414 = G__73505;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__10945__auto__ = function(state_73414){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__10945__auto____1.call(this,state_73414);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__10945__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__10945__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_73466 = f__11019__auto__.call(null);
(statearr_73466[(6)] = c__11018__auto__);

return statearr_73466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__73507 = arguments.length;
switch (G__73507) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__73508 = opts;
var map__73508__$1 = cljs.core.__destructure_map.call(null,map__73508);
var private$ = cljs.core.get.call(null,map__73508__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__73508__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_73560){
var state_val_73561 = (state_73560[(1)]);
if((state_val_73561 === (7))){
var inst_73518 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_73519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73520 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_73521 = (new cljs.core.PersistentVector(null,2,(5),inst_73519,inst_73520,null));
var inst_73522 = cljs.core.get_in.call(null,inst_73518,inst_73521);
var state_73560__$1 = state_73560;
var statearr_73562_73593 = state_73560__$1;
(statearr_73562_73593[(2)] = inst_73522);

(statearr_73562_73593[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73561 === (1))){
var state_73560__$1 = state_73560;
var statearr_73563_73594 = state_73560__$1;
(statearr_73563_73594[(2)] = null);

(statearr_73563_73594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73561 === (4))){
var inst_73509 = (state_73560[(2)]);
var state_73560__$1 = state_73560;
var statearr_73564_73595 = state_73560__$1;
(statearr_73564_73595[(2)] = inst_73509);

(statearr_73564_73595[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73561 === (15))){
var inst_73529 = (state_73560[(7)]);
var inst_73548 = (state_73560[(2)]);
var inst_73549 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_73550 = [(5000),inst_73548,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_73551 = cljs.core.PersistentHashMap.fromArrays(inst_73549,inst_73550);
var inst_73552 = fluree.db.util.xhttp.get.call(null,inst_73529,inst_73551);
var state_73560__$1 = state_73560;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73560__$1,(16),inst_73552);
} else {
if((state_val_73561 === (13))){
var inst_73529 = (state_73560[(7)]);
var inst_73539 = (state_73560[(8)]);
var inst_73541 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_73542 = [inst_73539];
var inst_73543 = cljs.core.PersistentHashMap.fromArrays(inst_73541,inst_73542);
var inst_73544 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_73529,inst_73543,private$);
var inst_73545 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_73544);
var state_73560__$1 = state_73560;
var statearr_73565_73596 = state_73560__$1;
(statearr_73565_73596[(2)] = inst_73545);

(statearr_73565_73596[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73561 === (6))){
var inst_73515 = (state_73560[(9)]);
var state_73560__$1 = state_73560;
var statearr_73566_73597 = state_73560__$1;
(statearr_73566_73597[(2)] = inst_73515);

(statearr_73566_73597[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73561 === (3))){
var inst_73558 = (state_73560[(2)]);
var state_73560__$1 = state_73560;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73560__$1,inst_73558);
} else {
if((state_val_73561 === (12))){
var inst_73539 = (state_73560[(2)]);
var state_73560__$1 = (function (){var statearr_73567 = state_73560;
(statearr_73567[(8)] = inst_73539);

return statearr_73567;
})();
if(cljs.core.truth_(private$)){
var statearr_73568_73598 = state_73560__$1;
(statearr_73568_73598[(1)] = (13));

} else {
var statearr_73569_73599 = state_73560__$1;
(statearr_73569_73599[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73561 === (2))){
var inst_73515 = (state_73560[(9)]);
var _ = (function (){var statearr_73570 = state_73560;
(statearr_73570[(4)] = cljs.core.cons.call(null,(5),(state_73560[(4)])));

return statearr_73570;
})();
var inst_73515__$1 = jwt;
var state_73560__$1 = (function (){var statearr_73571 = state_73560;
(statearr_73571[(9)] = inst_73515__$1);

return statearr_73571;
})();
if(cljs.core.truth_(inst_73515__$1)){
var statearr_73572_73600 = state_73560__$1;
(statearr_73572_73600[(1)] = (6));

} else {
var statearr_73573_73601 = state_73560__$1;
(statearr_73573_73601[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73561 === (11))){
var inst_73533 = (state_73560[(10)]);
var state_73560__$1 = state_73560;
var statearr_73575_73602 = state_73560__$1;
(statearr_73575_73602[(2)] = inst_73533);

(statearr_73575_73602[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73561 === (9))){
var inst_73525 = (state_73560[(11)]);
var inst_73524 = (state_73560[(12)]);
var inst_73528 = (state_73560[(2)]);
var inst_73529 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73528),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73525)].join('');
var inst_73531 = ["Accept"];
var inst_73532 = ["application/json"];
var inst_73533 = cljs.core.PersistentHashMap.fromArrays(inst_73531,inst_73532);
var state_73560__$1 = (function (){var statearr_73576 = state_73560;
(statearr_73576[(7)] = inst_73529);

(statearr_73576[(10)] = inst_73533);

return statearr_73576;
})();
if(cljs.core.truth_(inst_73524)){
var statearr_73577_73603 = state_73560__$1;
(statearr_73577_73603[(1)] = (10));

} else {
var statearr_73578_73604 = state_73560__$1;
(statearr_73578_73604[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73561 === (5))){
var _ = (function (){var statearr_73579 = state_73560;
(statearr_73579[(4)] = cljs.core.rest.call(null,(state_73560[(4)])));

return statearr_73579;
})();
var state_73560__$1 = state_73560;
var ex73574 = (state_73560__$1[(2)]);
var statearr_73580_73605 = state_73560__$1;
(statearr_73580_73605[(5)] = ex73574);


if((ex73574 instanceof Error)){
var statearr_73581_73606 = state_73560__$1;
(statearr_73581_73606[(1)] = (4));

(statearr_73581_73606[(5)] = null);

} else {
throw ex73574;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73561 === (14))){
var inst_73539 = (state_73560[(8)]);
var state_73560__$1 = state_73560;
var statearr_73582_73607 = state_73560__$1;
(statearr_73582_73607[(2)] = inst_73539);

(statearr_73582_73607[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73561 === (16))){
var inst_73554 = (state_73560[(2)]);
var inst_73555 = fluree.db.util.async.throw_err.call(null,inst_73554);
var _ = (function (){var statearr_73583 = state_73560;
(statearr_73583[(4)] = cljs.core.rest.call(null,(state_73560[(4)])));

return statearr_73583;
})();
var state_73560__$1 = state_73560;
var statearr_73584_73608 = state_73560__$1;
(statearr_73584_73608[(2)] = inst_73555);

(statearr_73584_73608[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73561 === (10))){
var inst_73524 = (state_73560[(12)]);
var inst_73533 = (state_73560[(10)]);
var inst_73535 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73524)].join('');
var inst_73536 = cljs.core.assoc.call(null,inst_73533,"Authorization",inst_73535);
var state_73560__$1 = state_73560;
var statearr_73585_73609 = state_73560__$1;
(statearr_73585_73609[(2)] = inst_73536);

(statearr_73585_73609[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73561 === (8))){
var inst_73524 = (state_73560[(2)]);
var inst_73525 = clojure.string.replace.call(null,k,"_","/");
var inst_73526 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_73560__$1 = (function (){var statearr_73586 = state_73560;
(statearr_73586[(11)] = inst_73525);

(statearr_73586[(12)] = inst_73524);

return statearr_73586;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73560__$1,(9),inst_73526);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__10945__auto__ = null;
var fluree$db$connection$state_machine__10945__auto____0 = (function (){
var statearr_73587 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73587[(0)] = fluree$db$connection$state_machine__10945__auto__);

(statearr_73587[(1)] = (1));

return statearr_73587;
});
var fluree$db$connection$state_machine__10945__auto____1 = (function (state_73560){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_73560);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e73588){var ex__10948__auto__ = e73588;
var statearr_73589_73610 = state_73560;
(statearr_73589_73610[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_73560[(4)]))){
var statearr_73590_73611 = state_73560;
(statearr_73590_73611[(1)] = cljs.core.first.call(null,(state_73560[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73612 = state_73560;
state_73560 = G__73612;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$connection$state_machine__10945__auto__ = function(state_73560){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__10945__auto____1.call(this,state_73560);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__10945__auto____0;
fluree$db$connection$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__10945__auto____1;
return fluree$db$connection$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_73591 = f__11019__auto__.call(null);
(statearr_73591[(6)] = c__11018__auto__);

return statearr_73591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5802__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__73613_SHARP_){
if(cljs.core.truth_(p1__73613_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db.call(null,conn,ledger,null);
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__73614_SHARP_){
var or__5045__auto__ = p1__73614_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e73615){var e = e73615;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__73616 = opts;
var map__73616__$1 = cljs.core.__destructure_map.call(null,map__73616);
var sub_chan = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.call(null,map__73616__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache.call(null);
} else {
}

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.info.call(null,new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5774__auto__ = [];
var len__5768__auto___73657 = arguments.length;
var i__5769__auto___73658 = (0);
while(true){
if((i__5769__auto___73658 < len__5768__auto___73657)){
args__5774__auto__.push((arguments[i__5769__auto___73658]));

var G__73659 = (i__5769__auto___73658 + (1));
i__5769__auto___73658 = G__73659;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__73619){
var vec__73620 = p__73619;
var opts = cljs.core.nth.call(null,vec__73620,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__11018__auto___73660 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_73640){
var state_val_73641 = (state_73640[(1)]);
if((state_val_73641 === (1))){
var inst_73623 = fluree.db.connection.get_socket.call(null,conn);
var state_73640__$1 = state_73640;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73640__$1,(2),inst_73623);
} else {
if((state_val_73641 === (2))){
var inst_73625 = (state_73640[(7)]);
var inst_73626 = (state_73640[(8)]);
var inst_73625__$1 = (state_73640[(2)]);
var inst_73626__$1 = (inst_73625__$1 == null);
var state_73640__$1 = (function (){var statearr_73642 = state_73640;
(statearr_73642[(7)] = inst_73625__$1);

(statearr_73642[(8)] = inst_73626__$1);

return statearr_73642;
})();
if(cljs.core.truth_(inst_73626__$1)){
var statearr_73643_73661 = state_73640__$1;
(statearr_73643_73661[(1)] = (3));

} else {
var statearr_73644_73662 = state_73640__$1;
(statearr_73644_73662[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73641 === (3))){
var inst_73626 = (state_73640[(8)]);
var state_73640__$1 = state_73640;
var statearr_73645_73663 = state_73640__$1;
(statearr_73645_73663[(2)] = inst_73626);

(statearr_73645_73663[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73641 === (4))){
var inst_73625 = (state_73640[(7)]);
var inst_73629 = fluree.db.util.core.exception_QMARK_.call(null,inst_73625);
var state_73640__$1 = state_73640;
var statearr_73646_73664 = state_73640__$1;
(statearr_73646_73664[(2)] = inst_73629);

(statearr_73646_73664[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73641 === (5))){
var inst_73631 = (state_73640[(2)]);
var state_73640__$1 = state_73640;
if(cljs.core.truth_(inst_73631)){
var statearr_73647_73665 = state_73640__$1;
(statearr_73647_73665[(1)] = (6));

} else {
var statearr_73648_73666 = state_73640__$1;
(statearr_73648_73666[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73641 === (6))){
var inst_73625 = (state_73640[(7)]);
var inst_73633 = fluree.db.util.log.error.call(null,inst_73625,"Cannot establish connection to a healthy server, disconnecting.");
var inst_73634 = cljs.core.async.close_BANG_.call(null,conn);
var state_73640__$1 = (function (){var statearr_73649 = state_73640;
(statearr_73649[(9)] = inst_73633);

return statearr_73649;
})();
var statearr_73650_73667 = state_73640__$1;
(statearr_73650_73667[(2)] = inst_73634);

(statearr_73650_73667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73641 === (7))){
var inst_73636 = fluree.db.connection.msg_consumer.call(null,conn);
var state_73640__$1 = state_73640;
var statearr_73651_73668 = state_73640__$1;
(statearr_73651_73668[(2)] = inst_73636);

(statearr_73651_73668[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73641 === (8))){
var inst_73638 = (state_73640[(2)]);
var state_73640__$1 = state_73640;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73640__$1,inst_73638);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__10945__auto__ = null;
var fluree$db$connection$state_machine__10945__auto____0 = (function (){
var statearr_73652 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73652[(0)] = fluree$db$connection$state_machine__10945__auto__);

(statearr_73652[(1)] = (1));

return statearr_73652;
});
var fluree$db$connection$state_machine__10945__auto____1 = (function (state_73640){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_73640);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e73653){var ex__10948__auto__ = e73653;
var statearr_73654_73669 = state_73640;
(statearr_73654_73669[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_73640[(4)]))){
var statearr_73655_73670 = state_73640;
(statearr_73655_73670[(1)] = cljs.core.first.call(null,(state_73640[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73671 = state_73640;
state_73640 = G__73671;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$connection$state_machine__10945__auto__ = function(state_73640){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__10945__auto____1.call(this,state_73640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__10945__auto____0;
fluree$db$connection$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__10945__auto____1;
return fluree$db$connection$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_73656 = f__11019__auto__.call(null);
(statearr_73656[(6)] = c__11018__auto___73660);

return statearr_73656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq73617){
var G__73618 = cljs.core.first.call(null,seq73617);
var seq73617__$1 = cljs.core.next.call(null,seq73617);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73618,seq73617__$1);
}));

