// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__73682 = arguments.length;
switch (G__73682) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_73724){
var state_val_73725 = (state_73724[(1)]);
if((state_val_73725 === (7))){
var inst_73694 = typeof user === 'string';
var state_73724__$1 = state_73724;
if(cljs.core.truth_(inst_73694)){
var statearr_73726_73755 = state_73724__$1;
(statearr_73726_73755[(1)] = (9));

} else {
var statearr_73727_73756 = state_73724__$1;
(statearr_73727_73756[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73725 === (1))){
var state_73724__$1 = state_73724;
var statearr_73728_73757 = state_73724__$1;
(statearr_73728_73757[(2)] = null);

(statearr_73728_73757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73725 === (4))){
var inst_73683 = (state_73724[(2)]);
var inst_73684 = fluree.db.util.log.error.call(null,inst_73683);
var inst_73685 = reject.call(null,inst_73683);
var state_73724__$1 = (function (){var statearr_73729 = state_73724;
(statearr_73729[(7)] = inst_73684);

return statearr_73729;
})();
var statearr_73730_73758 = state_73724__$1;
(statearr_73730_73758[(2)] = inst_73685);

(statearr_73730_73758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73725 === (15))){
var inst_73713 = (state_73724[(2)]);
var inst_73714 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_73713);
var inst_73715 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73716 = cljs.core.constantly.call(null,inst_73714);
var inst_73717 = cljs.core.swap_BANG_.call(null,inst_73715,inst_73716);
var inst_73718 = fluree.db.connection.add_token.call(null,conn,inst_73714);
var inst_73719 = resolve.call(null,inst_73713);
var _ = (function (){var statearr_73731 = state_73724;
(statearr_73731[(4)] = cljs.core.rest.call(null,(state_73724[(4)])));

return statearr_73731;
})();
var state_73724__$1 = (function (){var statearr_73732 = state_73724;
(statearr_73732[(8)] = inst_73717);

(statearr_73732[(9)] = inst_73718);

return statearr_73732;
})();
var statearr_73733_73759 = state_73724__$1;
(statearr_73733_73759[(2)] = inst_73719);

(statearr_73733_73759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73725 === (13))){
var state_73724__$1 = state_73724;
var statearr_73734_73760 = state_73724__$1;
(statearr_73734_73760[(2)] = null);

(statearr_73734_73760[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73725 === (6))){
var state_73724__$1 = state_73724;
var statearr_73735_73761 = state_73724__$1;
(statearr_73735_73761[(2)] = user);

(statearr_73735_73761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73725 === (3))){
var inst_73722 = (state_73724[(2)]);
var state_73724__$1 = state_73724;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73724__$1,inst_73722);
} else {
if((state_val_73725 === (12))){
var state_73724__$1 = state_73724;
var statearr_73736_73762 = state_73724__$1;
(statearr_73736_73762[(2)] = user);

(statearr_73736_73762[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73725 === (2))){
var _ = (function (){var statearr_73737 = state_73724;
(statearr_73737[(4)] = cljs.core.cons.call(null,(5),(state_73724[(4)])));

return statearr_73737;
})();
var inst_73691 = typeof user === 'number';
var state_73724__$1 = state_73724;
if(cljs.core.truth_(inst_73691)){
var statearr_73738_73763 = state_73724__$1;
(statearr_73738_73763[(1)] = (6));

} else {
var statearr_73739_73764 = state_73724__$1;
(statearr_73739_73764[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73725 === (11))){
var inst_73705 = (state_73724[(2)]);
var state_73724__$1 = state_73724;
var statearr_73741_73765 = state_73724__$1;
(statearr_73741_73765[(2)] = inst_73705);

(statearr_73741_73765[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73725 === (9))){
var inst_73696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73697 = ["_user/username",user];
var inst_73698 = (new cljs.core.PersistentVector(null,2,(5),inst_73696,inst_73697,null));
var state_73724__$1 = state_73724;
var statearr_73742_73766 = state_73724__$1;
(statearr_73742_73766[(2)] = inst_73698);

(statearr_73742_73766[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73725 === (5))){
var _ = (function (){var statearr_73743 = state_73724;
(statearr_73743[(4)] = cljs.core.rest.call(null,(state_73724[(4)])));

return statearr_73743;
})();
var state_73724__$1 = state_73724;
var ex73740 = (state_73724__$1[(2)]);
var statearr_73744_73767 = state_73724__$1;
(statearr_73744_73767[(5)] = ex73740);


var statearr_73745_73768 = state_73724__$1;
(statearr_73745_73768[(1)] = (4));

(statearr_73745_73768[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73725 === (14))){
var inst_73703 = (state_73724[(2)]);
var state_73724__$1 = state_73724;
var statearr_73746_73769 = state_73724__$1;
(statearr_73746_73769[(2)] = inst_73703);

(statearr_73746_73769[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73725 === (10))){
var state_73724__$1 = state_73724;
var statearr_73747_73770 = state_73724__$1;
(statearr_73747_73770[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73725 === (8))){
var inst_73707 = (state_73724[(2)]);
var inst_73708 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_73709 = [account,inst_73707,password,expireSeconds,syncTo];
var inst_73710 = cljs.core.PersistentHashMap.fromArrays(inst_73708,inst_73709);
var inst_73711 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_73710);
var state_73724__$1 = state_73724;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73724__$1,(15),inst_73711);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__10945__auto__ = null;
var fluree$db$connection_js$state_machine__10945__auto____0 = (function (){
var statearr_73749 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73749[(0)] = fluree$db$connection_js$state_machine__10945__auto__);

(statearr_73749[(1)] = (1));

return statearr_73749;
});
var fluree$db$connection_js$state_machine__10945__auto____1 = (function (state_73724){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_73724);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e73750){var ex__10948__auto__ = e73750;
var statearr_73751_73771 = state_73724;
(statearr_73751_73771[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_73724[(4)]))){
var statearr_73752_73772 = state_73724;
(statearr_73752_73772[(1)] = cljs.core.first.call(null,(state_73724[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73773 = state_73724;
state_73724 = G__73773;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__10945__auto__ = function(state_73724){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__10945__auto____1.call(this,state_73724);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__10945__auto____0;
fluree$db$connection_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__10945__auto____1;
return fluree$db$connection_js$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_73753 = f__11019__auto__.call(null);
(statearr_73753[(6)] = c__11018__auto__);

return statearr_73753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__73775 = arguments.length;
switch (G__73775) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_73784){
var state_val_73785 = (state_73784[(1)]);
if((state_val_73785 === (1))){
var inst_73776 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73778 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_73779 = (new cljs.core.PersistentVector(null,4,(5),inst_73777,inst_73778,null));
var inst_73780 = cljs.core.async.put_BANG_.call(null,inst_73776,inst_73779);
var inst_73781 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__73786 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__73787 = null;
var count__73788 = (0);
var i__73789 = (0);
while(true){
if((i__73789 < count__73788)){
var k = cljs.core._nth.call(null,chunk__73787,i__73789);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__73797 = seq__73786;
var G__73798 = chunk__73787;
var G__73799 = count__73788;
var G__73800 = (i__73789 + (1));
seq__73786 = G__73797;
chunk__73787 = G__73798;
count__73788 = G__73799;
i__73789 = G__73800;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__73786);
if(temp__5804__auto__){
var seq__73786__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__73786__$1)){
var c__5567__auto__ = cljs.core.chunk_first.call(null,seq__73786__$1);
var G__73801 = cljs.core.chunk_rest.call(null,seq__73786__$1);
var G__73802 = c__5567__auto__;
var G__73803 = cljs.core.count.call(null,c__5567__auto__);
var G__73804 = (0);
seq__73786 = G__73801;
chunk__73787 = G__73802;
count__73788 = G__73803;
i__73789 = G__73804;
continue;
} else {
var k = cljs.core.first.call(null,seq__73786__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__73805 = cljs.core.next.call(null,seq__73786__$1);
var G__73806 = null;
var G__73807 = (0);
var G__73808 = (0);
seq__73786 = G__73805;
chunk__73787 = G__73806;
count__73788 = G__73807;
i__73789 = G__73808;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_73782 = cljs.core.async.take_BANG_.call(null,pc,inst_73781);
var state_73784__$1 = (function (){var statearr_73790 = state_73784;
(statearr_73790[(7)] = inst_73780);

return statearr_73790;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73784__$1,inst_73782);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__10945__auto__ = null;
var fluree$db$connection_js$state_machine__10945__auto____0 = (function (){
var statearr_73791 = [null,null,null,null,null,null,null,null];
(statearr_73791[(0)] = fluree$db$connection_js$state_machine__10945__auto__);

(statearr_73791[(1)] = (1));

return statearr_73791;
});
var fluree$db$connection_js$state_machine__10945__auto____1 = (function (state_73784){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_73784);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e73792){var ex__10948__auto__ = e73792;
var statearr_73793_73809 = state_73784;
(statearr_73793_73809[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_73784[(4)]))){
var statearr_73794_73810 = state_73784;
(statearr_73794_73810[(1)] = cljs.core.first.call(null,(state_73784[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73811 = state_73784;
state_73784 = G__73811;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__10945__auto__ = function(state_73784){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__10945__auto____1.call(this,state_73784);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__10945__auto____0;
fluree$db$connection_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__10945__auto____1;
return fluree$db$connection_js$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_73795 = f__11019__auto__.call(null);
(statearr_73795[(6)] = c__11018__auto__);

return statearr_73795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__73813 = arguments.length;
switch (G__73813) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_73847){
var state_val_73848 = (state_73847[(1)]);
if((state_val_73848 === (1))){
var state_73847__$1 = state_73847;
var statearr_73849_73870 = state_73847__$1;
(statearr_73849_73870[(2)] = null);

(statearr_73849_73870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73848 === (2))){
var _ = (function (){var statearr_73850 = state_73847;
(statearr_73850[(4)] = cljs.core.cons.call(null,(5),(state_73847[(4)])));

return statearr_73850;
})();
var inst_73822 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_73823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73824 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_73825 = (new cljs.core.PersistentVector(null,1,(5),inst_73823,inst_73824,null));
var inst_73826 = cljs.core.PersistentHashMap.EMPTY;
var inst_73827 = cljs.core.atom.call(null,inst_73826);
var inst_73828 = cljs.core.assoc_in.call(null,inst_73822,inst_73825,inst_73827);
var inst_73829 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73830 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_73831 = (new cljs.core.PersistentVector(null,1,(5),inst_73829,inst_73830,null));
var inst_73832 = cljs.core.PersistentHashMap.EMPTY;
var inst_73833 = cljs.core.atom.call(null,inst_73832);
var inst_73834 = cljs.core.assoc_in.call(null,inst_73828,inst_73831,inst_73833);
var inst_73835 = cljs.core.async.promise_chan.call(null);
var inst_73836 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_73834);
var inst_73837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73838 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_73835,null];
var inst_73839 = (new cljs.core.PersistentVector(null,4,(5),inst_73837,inst_73838,null));
var inst_73840 = cljs.core.async.put_BANG_.call(null,inst_73836,inst_73839);
var inst_73841 = (function (){var conn = inst_73834;
var pc = inst_73835;
return (function (x){
if((x == null)){
} else {
var seq__73851_73871 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__73852_73872 = null;
var count__73853_73873 = (0);
var i__73854_73874 = (0);
while(true){
if((i__73854_73874 < count__73853_73873)){
var k_73875 = cljs.core._nth.call(null,chunk__73852_73872,i__73854_73874);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_73875], null),cljs.core.get.call(null,x,k_73875,null));


var G__73876 = seq__73851_73871;
var G__73877 = chunk__73852_73872;
var G__73878 = count__73853_73873;
var G__73879 = (i__73854_73874 + (1));
seq__73851_73871 = G__73876;
chunk__73852_73872 = G__73877;
count__73853_73873 = G__73878;
i__73854_73874 = G__73879;
continue;
} else {
var temp__5804__auto___73880 = cljs.core.seq.call(null,seq__73851_73871);
if(temp__5804__auto___73880){
var seq__73851_73881__$1 = temp__5804__auto___73880;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__73851_73881__$1)){
var c__5567__auto___73882 = cljs.core.chunk_first.call(null,seq__73851_73881__$1);
var G__73883 = cljs.core.chunk_rest.call(null,seq__73851_73881__$1);
var G__73884 = c__5567__auto___73882;
var G__73885 = cljs.core.count.call(null,c__5567__auto___73882);
var G__73886 = (0);
seq__73851_73871 = G__73883;
chunk__73852_73872 = G__73884;
count__73853_73873 = G__73885;
i__73854_73874 = G__73886;
continue;
} else {
var k_73887 = cljs.core.first.call(null,seq__73851_73881__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_73887], null),cljs.core.get.call(null,x,k_73887,null));


var G__73888 = cljs.core.next.call(null,seq__73851_73881__$1);
var G__73889 = null;
var G__73890 = (0);
var G__73891 = (0);
seq__73851_73871 = G__73888;
chunk__73852_73872 = G__73889;
count__73853_73873 = G__73890;
i__73854_73874 = G__73891;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_73842 = cljs.core.async.take_BANG_.call(null,inst_73835,inst_73841);
var ___$1 = (function (){var statearr_73855 = state_73847;
(statearr_73855[(4)] = cljs.core.rest.call(null,(state_73847[(4)])));

return statearr_73855;
})();
var state_73847__$1 = (function (){var statearr_73856 = state_73847;
(statearr_73856[(7)] = inst_73840);

return statearr_73856;
})();
var statearr_73857_73892 = state_73847__$1;
(statearr_73857_73892[(2)] = inst_73842);

(statearr_73857_73892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73848 === (3))){
var inst_73845 = (state_73847[(2)]);
var state_73847__$1 = state_73847;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73847__$1,inst_73845);
} else {
if((state_val_73848 === (4))){
var inst_73814 = (state_73847[(2)]);
var inst_73815 = fluree.db.util.log.error.call(null,inst_73814);
var inst_73816 = reject.call(null,inst_73814);
var state_73847__$1 = (function (){var statearr_73859 = state_73847;
(statearr_73859[(8)] = inst_73815);

return statearr_73859;
})();
var statearr_73860_73893 = state_73847__$1;
(statearr_73860_73893[(2)] = inst_73816);

(statearr_73860_73893[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73848 === (5))){
var _ = (function (){var statearr_73861 = state_73847;
(statearr_73861[(4)] = cljs.core.rest.call(null,(state_73847[(4)])));

return statearr_73861;
})();
var state_73847__$1 = state_73847;
var ex73858 = (state_73847__$1[(2)]);
var statearr_73862_73894 = state_73847__$1;
(statearr_73862_73894[(5)] = ex73858);


var statearr_73863_73895 = state_73847__$1;
(statearr_73863_73895[(1)] = (4));

(statearr_73863_73895[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__10945__auto__ = null;
var fluree$db$connection_js$state_machine__10945__auto____0 = (function (){
var statearr_73864 = [null,null,null,null,null,null,null,null,null];
(statearr_73864[(0)] = fluree$db$connection_js$state_machine__10945__auto__);

(statearr_73864[(1)] = (1));

return statearr_73864;
});
var fluree$db$connection_js$state_machine__10945__auto____1 = (function (state_73847){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_73847);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e73865){var ex__10948__auto__ = e73865;
var statearr_73866_73896 = state_73847;
(statearr_73866_73896[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_73847[(4)]))){
var statearr_73867_73897 = state_73847;
(statearr_73867_73897[(1)] = cljs.core.first.call(null,(state_73847[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73898 = state_73847;
state_73847 = G__73898;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__10945__auto__ = function(state_73847){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__10945__auto____1.call(this,state_73847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__10945__auto____0;
fluree$db$connection_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__10945__auto____1;
return fluree$db$connection_js$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_73868 = f__11019__auto__.call(null);
(statearr_73868[(6)] = c__11018__auto__);

return statearr_73868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__73900 = arguments.length;
switch (G__73900) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__73902 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__73902,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__73902,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__73905 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__73905,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__73905,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_73958){
var state_val_73959 = (state_73958[(1)]);
if((state_val_73959 === (7))){
var inst_73919 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73920 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_73921 = cljs.core.PersistentHashMap.fromArrays(inst_73919,inst_73920);
var inst_73922 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_73921);
var inst_73923 = (function(){throw inst_73922})();
var state_73958__$1 = state_73958;
var statearr_73960_73989 = state_73958__$1;
(statearr_73960_73989[(2)] = inst_73923);

(statearr_73960_73989[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73959 === (1))){
var state_73958__$1 = state_73958;
var statearr_73961_73990 = state_73958__$1;
(statearr_73961_73990[(2)] = null);

(statearr_73961_73990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73959 === (4))){
var inst_73908 = (state_73958[(2)]);
var inst_73909 = cljs.core.clj__GT_js.call(null,inst_73908);
var inst_73910 = reject.call(null,inst_73909);
var state_73958__$1 = state_73958;
var statearr_73962_73991 = state_73958__$1;
(statearr_73962_73991[(2)] = inst_73910);

(statearr_73962_73991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73959 === (13))){
var inst_73937 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73938 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73939 = cljs.core.PersistentHashMap.fromArrays(inst_73937,inst_73938);
var inst_73940 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_73939);
var inst_73941 = (function(){throw inst_73940})();
var state_73958__$1 = state_73958;
var statearr_73963_73992 = state_73958__$1;
(statearr_73963_73992[(2)] = inst_73941);

(statearr_73963_73992[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73959 === (6))){
var state_73958__$1 = state_73958;
var statearr_73964_73993 = state_73958__$1;
(statearr_73964_73993[(2)] = null);

(statearr_73964_73993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73959 === (3))){
var inst_73956 = (state_73958[(2)]);
var state_73958__$1 = state_73958;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73958__$1,inst_73956);
} else {
if((state_val_73959 === (12))){
var state_73958__$1 = state_73958;
var statearr_73965_73994 = state_73958__$1;
(statearr_73965_73994[(2)] = null);

(statearr_73965_73994[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73959 === (2))){
var _ = (function (){var statearr_73966 = state_73958;
(statearr_73966[(4)] = cljs.core.cons.call(null,(5),(state_73958[(4)])));

return statearr_73966;
})();
var inst_73916 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_73958__$1 = state_73958;
if(cljs.core.truth_(inst_73916)){
var statearr_73967_73995 = state_73958__$1;
(statearr_73967_73995[(1)] = (6));

} else {
var statearr_73968_73996 = state_73958__$1;
(statearr_73968_73996[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73959 === (11))){
var inst_73934 = (state_73958[(2)]);
var state_73958__$1 = (function (){var statearr_73970 = state_73958;
(statearr_73970[(7)] = inst_73934);

return statearr_73970;
})();
if(cljs.core.truth_(password)){
var statearr_73971_73997 = state_73958__$1;
(statearr_73971_73997[(1)] = (12));

} else {
var statearr_73972_73998 = state_73958__$1;
(statearr_73972_73998[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73959 === (9))){
var state_73958__$1 = state_73958;
var statearr_73973_73999 = state_73958__$1;
(statearr_73973_73999[(2)] = null);

(statearr_73973_73999[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73959 === (5))){
var _ = (function (){var statearr_73974 = state_73958;
(statearr_73974[(4)] = cljs.core.rest.call(null,(state_73958[(4)])));

return statearr_73974;
})();
var state_73958__$1 = state_73958;
var ex73969 = (state_73958__$1[(2)]);
var statearr_73975_74000 = state_73958__$1;
(statearr_73975_74000[(5)] = ex73969);


var statearr_73976_74001 = state_73958__$1;
(statearr_73976_74001[(1)] = (4));

(statearr_73976_74001[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73959 === (14))){
var inst_73943 = (state_73958[(2)]);
var inst_73944 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_73945 = fluree.db.util.core.without_nils.call(null,inst_73944);
var inst_73946 = cljs.core.async.promise_chan.call(null);
var inst_73947 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73949 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_73945,inst_73946,null];
var inst_73950 = (new cljs.core.PersistentVector(null,4,(5),inst_73948,inst_73949,null));
var inst_73951 = cljs.core.async.put_BANG_.call(null,inst_73947,inst_73950);
var inst_73952 = (function (){var _ = inst_73943;
var data = inst_73945;
var pc = inst_73946;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_73953 = cljs.core.async.take_BANG_.call(null,inst_73946,inst_73952);
var _ = (function (){var statearr_73977 = state_73958;
(statearr_73977[(4)] = cljs.core.rest.call(null,(state_73958[(4)])));

return statearr_73977;
})();
var state_73958__$1 = (function (){var statearr_73978 = state_73958;
(statearr_73978[(8)] = inst_73951);

return statearr_73978;
})();
var statearr_73979_74002 = state_73958__$1;
(statearr_73979_74002[(2)] = inst_73953);

(statearr_73979_74002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73959 === (10))){
var inst_73928 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73929 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73930 = cljs.core.PersistentHashMap.fromArrays(inst_73928,inst_73929);
var inst_73931 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_73930);
var inst_73932 = (function(){throw inst_73931})();
var state_73958__$1 = state_73958;
var statearr_73980_74003 = state_73958__$1;
(statearr_73980_74003[(2)] = inst_73932);

(statearr_73980_74003[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73959 === (8))){
var inst_73925 = (state_73958[(2)]);
var state_73958__$1 = (function (){var statearr_73981 = state_73958;
(statearr_73981[(9)] = inst_73925);

return statearr_73981;
})();
if(cljs.core.truth_(ledger)){
var statearr_73982_74004 = state_73958__$1;
(statearr_73982_74004[(1)] = (9));

} else {
var statearr_73983_74005 = state_73958__$1;
(statearr_73983_74005[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__10945__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__10945__auto____0 = (function (){
var statearr_73984 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73984[(0)] = fluree$db$connection_js$password_generate_$_state_machine__10945__auto__);

(statearr_73984[(1)] = (1));

return statearr_73984;
});
var fluree$db$connection_js$password_generate_$_state_machine__10945__auto____1 = (function (state_73958){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_73958);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e73985){var ex__10948__auto__ = e73985;
var statearr_73986_74006 = state_73958;
(statearr_73986_74006[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_73958[(4)]))){
var statearr_73987_74007 = state_73958;
(statearr_73987_74007[(1)] = cljs.core.first.call(null,(state_73958[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74008 = state_73958;
state_73958 = G__74008;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__10945__auto__ = function(state_73958){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__10945__auto____1.call(this,state_73958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__10945__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__10945__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_73988 = f__11019__auto__.call(null);
(statearr_73988[(6)] = c__11018__auto__);

return statearr_73988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__74010 = arguments.length;
switch (G__74010) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_74077){
var state_val_74078 = (state_74077[(1)]);
if((state_val_74078 === (7))){
var inst_74022 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74023 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_74024 = cljs.core.PersistentHashMap.fromArrays(inst_74022,inst_74023);
var inst_74025 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_74024);
var inst_74026 = (function(){throw inst_74025})();
var state_74077__$1 = state_74077;
var statearr_74079_74118 = state_74077__$1;
(statearr_74079_74118[(2)] = inst_74026);

(statearr_74079_74118[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (20))){
var inst_74060 = (state_74077[(2)]);
var inst_74061 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_74062 = [ledger,password,user,auth,expire];
var inst_74063 = cljs.core.PersistentHashMap.fromArrays(inst_74061,inst_74062);
var inst_74064 = fluree.db.util.core.without_nils.call(null,inst_74063);
var inst_74065 = cljs.core.async.promise_chan.call(null);
var inst_74066 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74067 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74068 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_74064,inst_74065,null];
var inst_74069 = (new cljs.core.PersistentVector(null,4,(5),inst_74067,inst_74068,null));
var inst_74070 = cljs.core.async.put_BANG_.call(null,inst_74066,inst_74069);
var inst_74071 = (function (){var _ = inst_74060;
var data = inst_74064;
var pc = inst_74065;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_74072 = cljs.core.async.take_BANG_.call(null,inst_74065,inst_74071);
var _ = (function (){var statearr_74080 = state_74077;
(statearr_74080[(4)] = cljs.core.rest.call(null,(state_74077[(4)])));

return statearr_74080;
})();
var state_74077__$1 = (function (){var statearr_74081 = state_74077;
(statearr_74081[(7)] = inst_74070);

return statearr_74081;
})();
var statearr_74082_74119 = state_74077__$1;
(statearr_74082_74119[(2)] = inst_74072);

(statearr_74082_74119[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (1))){
var state_74077__$1 = state_74077;
var statearr_74083_74120 = state_74077__$1;
(statearr_74083_74120[(2)] = null);

(statearr_74083_74120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (4))){
var inst_74011 = (state_74077[(2)]);
var inst_74012 = cljs.core.clj__GT_js.call(null,inst_74011);
var inst_74013 = reject.call(null,inst_74012);
var state_74077__$1 = state_74077;
var statearr_74084_74121 = state_74077__$1;
(statearr_74084_74121[(2)] = inst_74013);

(statearr_74084_74121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (15))){
var inst_74047 = (state_74077[(8)]);
var state_74077__$1 = state_74077;
var statearr_74085_74122 = state_74077__$1;
(statearr_74085_74122[(2)] = inst_74047);

(statearr_74085_74122[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (13))){
var inst_74040 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74041 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_74042 = cljs.core.PersistentHashMap.fromArrays(inst_74040,inst_74041);
var inst_74043 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_74042);
var inst_74044 = (function(){throw inst_74043})();
var state_74077__$1 = state_74077;
var statearr_74086_74123 = state_74077__$1;
(statearr_74086_74123[(2)] = inst_74044);

(statearr_74086_74123[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (6))){
var state_74077__$1 = state_74077;
var statearr_74087_74124 = state_74077__$1;
(statearr_74087_74124[(2)] = null);

(statearr_74087_74124[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (17))){
var inst_74051 = (state_74077[(2)]);
var state_74077__$1 = state_74077;
if(cljs.core.truth_(inst_74051)){
var statearr_74088_74125 = state_74077__$1;
(statearr_74088_74125[(1)] = (18));

} else {
var statearr_74089_74126 = state_74077__$1;
(statearr_74089_74126[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (3))){
var inst_74075 = (state_74077[(2)]);
var state_74077__$1 = state_74077;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74077__$1,inst_74075);
} else {
if((state_val_74078 === (12))){
var state_74077__$1 = state_74077;
var statearr_74090_74127 = state_74077__$1;
(statearr_74090_74127[(2)] = null);

(statearr_74090_74127[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (2))){
var _ = (function (){var statearr_74091 = state_74077;
(statearr_74091[(4)] = cljs.core.cons.call(null,(5),(state_74077[(4)])));

return statearr_74091;
})();
var inst_74019 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_74077__$1 = state_74077;
if(cljs.core.truth_(inst_74019)){
var statearr_74092_74128 = state_74077__$1;
(statearr_74092_74128[(1)] = (6));

} else {
var statearr_74093_74129 = state_74077__$1;
(statearr_74093_74129[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (19))){
var inst_74054 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74055 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_74056 = cljs.core.PersistentHashMap.fromArrays(inst_74054,inst_74055);
var inst_74057 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_74056);
var inst_74058 = (function(){throw inst_74057})();
var state_74077__$1 = state_74077;
var statearr_74094_74130 = state_74077__$1;
(statearr_74094_74130[(2)] = inst_74058);

(statearr_74094_74130[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (11))){
var inst_74037 = (state_74077[(2)]);
var state_74077__$1 = (function (){var statearr_74096 = state_74077;
(statearr_74096[(9)] = inst_74037);

return statearr_74096;
})();
if(cljs.core.truth_(password)){
var statearr_74097_74131 = state_74077__$1;
(statearr_74097_74131[(1)] = (12));

} else {
var statearr_74098_74132 = state_74077__$1;
(statearr_74098_74132[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (9))){
var state_74077__$1 = state_74077;
var statearr_74099_74133 = state_74077__$1;
(statearr_74099_74133[(2)] = null);

(statearr_74099_74133[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (5))){
var _ = (function (){var statearr_74100 = state_74077;
(statearr_74100[(4)] = cljs.core.rest.call(null,(state_74077[(4)])));

return statearr_74100;
})();
var state_74077__$1 = state_74077;
var ex74095 = (state_74077__$1[(2)]);
var statearr_74101_74134 = state_74077__$1;
(statearr_74101_74134[(5)] = ex74095);


var statearr_74102_74135 = state_74077__$1;
(statearr_74102_74135[(1)] = (4));

(statearr_74102_74135[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (14))){
var inst_74047 = (state_74077[(8)]);
var inst_74046 = (state_74077[(2)]);
var inst_74047__$1 = user;
var state_74077__$1 = (function (){var statearr_74103 = state_74077;
(statearr_74103[(10)] = inst_74046);

(statearr_74103[(8)] = inst_74047__$1);

return statearr_74103;
})();
if(cljs.core.truth_(inst_74047__$1)){
var statearr_74104_74136 = state_74077__$1;
(statearr_74104_74136[(1)] = (15));

} else {
var statearr_74105_74137 = state_74077__$1;
(statearr_74105_74137[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (16))){
var state_74077__$1 = state_74077;
var statearr_74106_74138 = state_74077__$1;
(statearr_74106_74138[(2)] = auth);

(statearr_74106_74138[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (10))){
var inst_74031 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74032 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_74033 = cljs.core.PersistentHashMap.fromArrays(inst_74031,inst_74032);
var inst_74034 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_74033);
var inst_74035 = (function(){throw inst_74034})();
var state_74077__$1 = state_74077;
var statearr_74107_74139 = state_74077__$1;
(statearr_74107_74139[(2)] = inst_74035);

(statearr_74107_74139[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (18))){
var state_74077__$1 = state_74077;
var statearr_74108_74140 = state_74077__$1;
(statearr_74108_74140[(2)] = null);

(statearr_74108_74140[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74078 === (8))){
var inst_74028 = (state_74077[(2)]);
var state_74077__$1 = (function (){var statearr_74109 = state_74077;
(statearr_74109[(11)] = inst_74028);

return statearr_74109;
})();
if(cljs.core.truth_(ledger)){
var statearr_74110_74141 = state_74077__$1;
(statearr_74110_74141[(1)] = (9));

} else {
var statearr_74111_74142 = state_74077__$1;
(statearr_74111_74142[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__10945__auto__ = null;
var fluree$db$connection_js$state_machine__10945__auto____0 = (function (){
var statearr_74112 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74112[(0)] = fluree$db$connection_js$state_machine__10945__auto__);

(statearr_74112[(1)] = (1));

return statearr_74112;
});
var fluree$db$connection_js$state_machine__10945__auto____1 = (function (state_74077){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_74077);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e74113){var ex__10948__auto__ = e74113;
var statearr_74114_74143 = state_74077;
(statearr_74114_74143[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_74077[(4)]))){
var statearr_74115_74144 = state_74077;
(statearr_74115_74144[(1)] = cljs.core.first.call(null,(state_74077[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74145 = state_74077;
state_74077 = G__74145;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__10945__auto__ = function(state_74077){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__10945__auto____1.call(this,state_74077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__10945__auto____0;
fluree$db$connection_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__10945__auto____1;
return fluree$db$connection_js$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_74116 = f__11019__auto__.call(null);
(statearr_74116[(6)] = c__11018__auto__);

return statearr_74116;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__74147 = arguments.length;
switch (G__74147) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_74182){
var state_val_74183 = (state_74182[(1)]);
if((state_val_74183 === (1))){
var state_74182__$1 = state_74182;
var statearr_74184_74204 = state_74182__$1;
(statearr_74184_74204[(2)] = null);

(statearr_74184_74204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74183 === (2))){
var _ = (function (){var statearr_74185 = state_74182;
(statearr_74185[(4)] = cljs.core.cons.call(null,(5),(state_74182[(4)])));

return statearr_74185;
})();
var inst_74156 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_74182__$1 = state_74182;
if(cljs.core.truth_(inst_74156)){
var statearr_74186_74205 = state_74182__$1;
(statearr_74186_74205[(1)] = (6));

} else {
var statearr_74187_74206 = state_74182__$1;
(statearr_74187_74206[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74183 === (3))){
var inst_74180 = (state_74182[(2)]);
var state_74182__$1 = state_74182;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74182__$1,inst_74180);
} else {
if((state_val_74183 === (4))){
var inst_74148 = (state_74182[(2)]);
var inst_74149 = cljs.core.clj__GT_js.call(null,inst_74148);
var inst_74150 = reject.call(null,inst_74149);
var state_74182__$1 = state_74182;
var statearr_74189_74207 = state_74182__$1;
(statearr_74189_74207[(2)] = inst_74150);

(statearr_74189_74207[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74183 === (5))){
var _ = (function (){var statearr_74190 = state_74182;
(statearr_74190[(4)] = cljs.core.rest.call(null,(state_74182[(4)])));

return statearr_74190;
})();
var state_74182__$1 = state_74182;
var ex74188 = (state_74182__$1[(2)]);
var statearr_74191_74208 = state_74182__$1;
(statearr_74191_74208[(5)] = ex74188);


var statearr_74192_74209 = state_74182__$1;
(statearr_74192_74209[(1)] = (4));

(statearr_74192_74209[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74183 === (6))){
var state_74182__$1 = state_74182;
var statearr_74193_74210 = state_74182__$1;
(statearr_74193_74210[(2)] = null);

(statearr_74193_74210[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74183 === (7))){
var inst_74159 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74160 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_74161 = cljs.core.PersistentHashMap.fromArrays(inst_74159,inst_74160);
var inst_74162 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_74161);
var inst_74163 = (function(){throw inst_74162})();
var state_74182__$1 = state_74182;
var statearr_74194_74211 = state_74182__$1;
(statearr_74194_74211[(2)] = inst_74163);

(statearr_74194_74211[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74183 === (8))){
var inst_74165 = (state_74182[(2)]);
var inst_74166 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_74167 = [jwt,expire];
var inst_74168 = cljs.core.PersistentHashMap.fromArrays(inst_74166,inst_74167);
var inst_74169 = fluree.db.util.core.without_nils.call(null,inst_74168);
var inst_74170 = cljs.core.async.promise_chan.call(null);
var inst_74171 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74173 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_74169,inst_74170,null];
var inst_74174 = (new cljs.core.PersistentVector(null,4,(5),inst_74172,inst_74173,null));
var inst_74175 = cljs.core.async.put_BANG_.call(null,inst_74171,inst_74174);
var inst_74176 = (function (){var _ = inst_74165;
var data = inst_74169;
var pc = inst_74170;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_74177 = cljs.core.async.take_BANG_.call(null,inst_74170,inst_74176);
var _ = (function (){var statearr_74195 = state_74182;
(statearr_74195[(4)] = cljs.core.rest.call(null,(state_74182[(4)])));

return statearr_74195;
})();
var state_74182__$1 = (function (){var statearr_74196 = state_74182;
(statearr_74196[(7)] = inst_74175);

return statearr_74196;
})();
var statearr_74197_74212 = state_74182__$1;
(statearr_74197_74212[(2)] = inst_74177);

(statearr_74197_74212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__10945__auto__ = null;
var fluree$db$connection_js$state_machine__10945__auto____0 = (function (){
var statearr_74198 = [null,null,null,null,null,null,null,null];
(statearr_74198[(0)] = fluree$db$connection_js$state_machine__10945__auto__);

(statearr_74198[(1)] = (1));

return statearr_74198;
});
var fluree$db$connection_js$state_machine__10945__auto____1 = (function (state_74182){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_74182);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e74199){var ex__10948__auto__ = e74199;
var statearr_74200_74213 = state_74182;
(statearr_74200_74213[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_74182[(4)]))){
var statearr_74201_74214 = state_74182;
(statearr_74201_74214[(1)] = cljs.core.first.call(null,(state_74182[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74215 = state_74182;
state_74182 = G__74215;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__10945__auto__ = function(state_74182){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__10945__auto____1.call(this,state_74182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__10945__auto____0;
fluree$db$connection_js$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__10945__auto____1;
return fluree$db$connection_js$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_74202 = f__11019__auto__.call(null);
(statearr_74202[(6)] = c__11018__auto__);

return statearr_74202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

